-- DO NOT MANUALLY RUN THIS SCRIPT WITHOUT EXECUTING trig_ms.sql IMMEDIATLY AFTER

IF OBJECT_ID('Calls') IS NOT NULL
BEGIN
DROP VIEW dbo.Calls
END
GO

CREATE VIEW dbo.Calls AS
SELECT CAST(cs.CallStartID AS BIGINT) AS CallID, cs.Username, cs.AcctSessionID, cs.NASIdentifier, 2 AS AcctStatusType,
cs.TimeRef, DATEADD(ss,ce.CallSessionTime,cs.CallDate) AS CallDate, cs.AccountID, cs.ServerID, cs.NASPort,
CAST(ce.AcctDelayTime AS INT) AS AcctDelayTime, ce.AcctSessionTime, cs.FramedIPAddress, cs.FramedIPv6Address, cs.FramedIPv6Prefix,
ce.AcctInputOctets, ce.AcctOutputOctets, ce.AcctTerminateCause, CAST(cs.NASPortType AS INT) AS NASPortType,
cs.CallingStationID, cs.CalledStationID, cs.ConnectInfo
FROM CallStarts cs JOIN CallStops ce ON (cs.CallStartID = ce.CallStartID)
GO

IF OBJECT_ID('vMasterAccounts') IS NOT NULL
BEGIN
DROP VIEW dbo.vMasterAccounts
END
GO

CREATE VIEW dbo.vMasterAccounts AS
SELECT ma.CustomerID, g.OrganizationID, ma.GroupID, 
aab.FirstName AS BillFirstName, aab.LastName AS BillLastName, aab.Company AS BillCompany, aab.Address1 AS BillAddress1,
aab.Address2 AS BillAddress2, aab.City AS BillCity, bs.State AS BillState, bs.Abbreviation AS BillStateAbbr, aab.Zip AS BillZip,
bco.Country AS BillCountry, aab.PhoneHome AS BillPhoneHome, aab.PhoneWork AS BillPhoneWork, aab.PhoneMobile AS BillPhoneMobile,
aab.Email AS BillEmail,

aas.FirstName AS ShipFirstName, aas.LastName AS ShipLastName, aas.Company AS ShipCompany, aas.Address1 AS ShipAddress1,
aas.Address2 AS ShipAddress2, aas.City AS ShipCity, ss.State AS ShipState, ss.Abbreviation AS ShipStateAbbr, aas.Zip AS ShipZip,
sc.Country AS ShipCountry, aas.PhoneHome AS ShipPhoneHome, aas.PhoneWork AS ShipPhoneWork, aas.PhoneMobile AS ShipPhoneMobile,
aas.Email AS ShipEmail, 

r.Region, rb.ReferredBy, sp.SalesPerson, ma.CreateDate, ma.CreateUser, ma.StartDate, ma.Active, 
CASE WHEN ma.Active = 0 THEN 'Inactive'
WHEN ma.CancelDate < getdate() THEN 'Canceled'
ELSE 'Active' END AS Status,
l.Description AS Language, pp.PayPeriod AS DefaultPayPeriod, pt.PaymentType AS PayMethod,
o.Organization, g.GroupName, c.Code AS Currency, sm.SendMethod, bc.BillingCycle, CASE WHEN bc.CycleType = 0 THEN ma.BillDay ELSE bc.BillDay END AS BillDay, ma.TempExtension, ma.Balance, ma.PendingBalance, ma.CreditLimit,
ma.PO, ma.PIN, ma.ExternalRef, ma.LastModifyDate, ma.LastModifyUser, ma.TransHoldDate, ma.CancelDate, cr.CancelReason, ma.Comments

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	LEFT JOIN Addresses aab ON (ma.BillingAddressID = aab.AddressID)
	LEFT JOIN Countries bco ON (aab.CountryID = bco.CountryID)
	LEFT JOIN States bs ON (aab.StateID = bs.StateID)
	LEFT JOIN Addresses aas ON (ma.ShippingAddressID = aas.AddressID)
	LEFT JOIN Countries sc ON (aas.CountryID = sc.CountryID)
	LEFT JOIN States ss ON (aas.StateID = ss.StateID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
	LEFT JOIN SalesPersons sp ON (ma.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN Languages l ON (ma.LanguageID = l.LanguageID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	WHERE ma.Active IN (1,0)
GO


IF OBJECT_ID('vSubAccounts') IS NOT NULL
BEGIN
DROP VIEW dbo.vSubAccounts
END
GO

CREATE VIEW dbo.vSubAccounts AS
SELECT sa.AccountID, sa.CustomerID, ma.GroupID, sa.AccountTypeID,

aac.FirstName AS ContactFirstName, aac.LastName AS ContactLastName, aac.Company AS ContactCompany, aac.Address1 AS ContactAddress1,
aac.Address2 AS ContactAddress2, aac.City AS ContactCity, cs.State AS ContactState, cs.Abbreviation AS ContactStateAbbr, aac.Zip AS ContactZip,
cc.Country AS ContactCountry, aac.Email AS ContactEmail, aac.PhoneHome AS ContactPhoneHome, aac.PhoneWork AS ContactPhoneWork, aac.PhoneMobile AS ContactPhoneMobile,

aas.FirstName AS ServiceFirstName, aas.LastName AS ServiceLastName, aas.Company AS ServiceCompany, aas.Address1 AS ServiceAddress1,
aas.Address2 AS ServiceAddress2, aas.City AS ServiceCity, ss.State AS ServiceState, ss.Abbreviation AS ServiceStateAbbr, aas.Zip AS ServiceZip,
sc.Country AS ServiceCountry, aas.Email AS ServiceEmail, aas.PhoneHome AS ServicePhoneHome, aas.PhoneWork AS ServicePhoneWork, aas.PhoneMobile AS ServicePhoneMobile,
CASE WHEN aas.Lat IS NOT NULL AND aas.Long IS NOT NULL THEN aas.Lat ELSE sac.Lat END AS ServiceLat,
CASE WHEN aas.Lat IS NOT NULL AND aas.Long IS NOT NULL THEN aas.Long ELSE sac.Long END AS ServiceLong,
sa.Login, sa.Email, sa.ParentAccountID, sc1.ServiceCategory, at1.AccountType, slt.ServiceLevelType AS ServiceTag, slt2.ServiceLevelType AS ServiceTag2, pp.PayPeriod, 
sa.CreateDate, sa.CreateUser, sa.CancelDate, cr.CancelReason, sa.StartDate, sa.BilledThru, sa.ExpireDate,
sa.Extension, CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Active,
CASE WHEN ma.Active = 0 OR sa.Active = 0 THEN NULL WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 1 ELSE 0 END AS Expired,
CASE WHEN ma.Active = 0 OR sa.Active = 0 THEN 'Inactive'
WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) 
	THEN CASE WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'Canceled' ELSE 'Expired' END
WHEN sa.TimeLeft <= 0 OR sa.RateTimeLeft <= 0 THEN 'No time left'
WHEN sa.DataLeft <= 0 OR sa.RateDataLeft <= 0 THEN 'No data left'
WHEN sa.StartDate > getdate() THEN 'Not started'
ELSE 'Active' END AS Status,
sp.SalesPerson, sa.LastModifyDate, sa.LastModifyUser, sa.SendBill, 
CASE sa.RemoteAccess WHEN 2 THEN 'Manager' WHEN 1 THEN 'Service' ELSE 'None' END AS RemoteAccess,
sa.PasswordChange, CASE WHEN sa.Recurring = 1 AND bc.AutoBill IN (0,1) THEN 1 ELSE 0 END AS Recurring,
sa.LoginLimit, d.Domain, t.Tower, sa.TimeLeft, sa.DataLeft, sa.RateTimeLeft, sa.RateDataLeft,
sa.InvoicedDays, sa.Cost, sa.RefAccountID, sa.RefCode, sa.ServiceQty, sa.Comments

FROM SubAccounts sa JOIN ServiceCategories sc1 ON (sa.ServiceCategoryID = sc1.ServiceCategoryID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN CancelReasons cr ON (sa.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN SalesPersons sp ON (sa.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN Towers t ON (sa.TowerID = t.TowerID)
	LEFT JOIN Addresses aac ON (sa.ContactAddressID = aac.AddressID)
	LEFT JOIN Countries cc ON (aac.CountryID = cc.CountryID)
	LEFT JOIN States cs ON (aac.StateID = cs.StateID)
	LEFT JOIN Addresses aas ON (sa.ServiceAddressID = aas.AddressID)
	LEFT JOIN AddressSyncs sac ON (sa.ServiceAddressID = sac.AddressID)
	LEFT JOIN Countries sc ON (aas.CountryID = sc.CountryID)
	LEFT JOIN States ss ON (aas.StateID = ss.StateID)
	LEFT JOIN ServiceLevelTypes slt ON (at1.ServiceLevelTypeID = slt.ServiceLevelTypeID)
	LEFT JOIN ServiceLevelTypes slt2 ON (at1.SecServiceLevelTypeID = slt2.ServiceLevelTypeID)
	WHERE sa.Active IN (1,0)
	AND ma.Active IN (1,0)
GO


IF OBJECT_ID('vIncidents') IS NOT NULL
BEGIN
DROP VIEW dbo.vIncidents
END
GO

CREATE VIEW dbo.vIncidents AS
SELECT i.IncidentID, i.CustomerID, i.AccountID, ma.GroupID, i.CreateDate, it.IncidentType, is1.IncidentState, is1.StatOpen, e.Event, 
co.Operator AS CreateOperator, COALESCE(csa.Login,cca.FirstName + ' ' + cca.LastName) AS CreateUser,
i.Summary, i.Description, i.CustomerAccess, i.LastModifyDate, i.LastModifyUser, i.Duration, i.Email, 
r.Role AS AssignRole, ao.Operator AS AssignOperator, i.DueDate, p.Priority, sb.SchedBlock, i.SchedDate

FROM Incidents i JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN Events e ON (i.EventID = e.EventID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
	LEFT JOIN SubAccounts csa ON (i.CreateAccountID = csa.AccountID)
	LEFT JOIN Addresses cca ON (csa.ContactAddressID = cca.AddressID)
	LEFT JOIN Roles r ON (i.AssignRoleID = r.RoleID)
	LEFT JOIN Operators ao ON (i.AssignOperatorID = ao.OperatorID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	LEFT JOIN SchedBlocks sb ON (i.SchedBlockID = sb.SchedBlockID)
	WHERE ma.Active IN (1,0)
	AND (sa.Active IS NULL OR sa.Active IN (1,0))
GO


IF OBJECT_ID('vActions') IS NOT NULL
BEGIN
DROP VIEW dbo.vActions
END
GO

CREATE VIEW dbo.vActions AS
SELECT a.ActionID, a.IncidentID, ma.GroupID, co.Operator AS CreateOperator, COALESCE(csa.Login,cca.FirstName + ' ' + cca.LastName) AS CreateUser,
a.CreateDate, a.Description, a.LastModifyDate, a.LastModifyUser, a.CustomerAccess, a.Duration, it.IncidentType, is1.IncidentState,
r.Role AS AssignRole, ao.Operator AS AssignOperator

FROM Actions a JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it ON (a.IncidentTypeID = it.IncidentTypeID)
	JOIN IncidentStates is1 ON (a.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators co ON (a.CreateOperatorID = co.OperatorID)
	LEFT JOIN SubAccounts csa ON (a.CreateAccountID = csa.AccountID)
	LEFT JOIN Addresses cca ON (csa.ContactAddressID = cca.AddressID)
	LEFT JOIN Roles r ON (a.AssignRoleID = r.RoleID)
	LEFT JOIN Operators ao ON (a.AssignOperatorID = ao.OperatorID)
GO


IF OBJECT_ID('vInvoices') IS NOT NULL
BEGIN
DROP VIEW dbo.vInvoices
END
GO

CREATE VIEW dbo.vInvoices AS
SELECT i.InvoiceID, i.CustomerID, ma.GroupID, it.InvoiceType, CASE WHEN i.VoidDate IS NOT NULL THEN 'Voided' WHEN i.ChargeAmount <= i.PaidAmount THEN 'Paid' ELSE 'Unpaid' END AS Status,
i.Amount, i.ChargeAmount, i.PaidAmount, pp.PayPlan, i.PayPlanStartDate,
i.CreateDate, i.LastModifyDate, i.LastModifyUser, i.Tax, i.StatementID, i.VoidDate, i.VoidStatementID, COALESCE(i.PO,ma.PO) AS PO, i.PrintDate, i.EmailDate,
i.ExtInvoiceNum, i.Comments

FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE i.Processed = 1
GO

IF OBJECT_ID('vInvoiceItems') IS NOT NULL
BEGIN
DROP VIEW dbo.vInvoiceItems
END
GO

CREATE VIEW dbo.vInvoiceItems AS
SELECT ii.ItemID, ii.InvoiceID, ii.AccountID, ma.GroupID, iit.InvoiceItemType, ii.StartDate, ii.EndDate, 
COALESCE(ii.Description,c.Description,at1.Description,t.Description,ivp.Title + ' (' + ivi.SerialNumber + ')',ct.ChargeType) + CASE WHEN ii.ServiceQty > 1 THEN ' x ' + CAST(ii.ServiceQty AS VARCHAR(10)) ELSE '' END AS Description,
ii.BaseAmount, ii.Amount, ii.Quantity, ii.Days, ii.PaidAmount, t.Tax, tg.TaxGroup, ii.Login, at1.AccountType, ii.ChargeID,
ct.ChargeType, ivp.Title + ' (' + ivi.SerialNumber + ')' AS InvItem, COALESCE(glct.GLCode,glat.GLCode,glt.GLCode) AS GLCode

FROM InvoiceItems ii JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN InvoiceItemTypes iit ON (ii.ItemType = iit.InvoiceItemTypeID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN TaxGroups tg ON (ii.TaxGroupID = tg.TaxGroupID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Charges c ON (ii.ChargeID = c.ChargeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN InvItems ivi ON (ii.InvItemID = ivi.InvItemID)
	LEFT JOIN InvProducts ivp ON (ivi.InvProductID = ivp.InvProductID)
	LEFT JOIN GLCodes glat ON (at1.GLCodeID = glat.GLCodeID)
	LEFT JOIN GLCodes glct ON (ct.GLCodeID = glct.GLCodeID)
	LEFT JOIN GLCodes glt ON (t.GLCodeID = glt.GLCodeID)
GO


IF OBJECT_ID('vPayments') IS NOT NULL
BEGIN
DROP VIEW dbo.vPayments
END
GO

CREATE VIEW dbo.vPayments AS
SELECT p.PaymentID, p.CustomerID, ma.GroupID, p.CreateDate, p.CreateUser, p.EffectiveDate, pt.PaymentType, 
p.CheckNumber, p.PayInfo, COALESCE(p.FinalAmount,p.Amount) AS CurrentAmount, p.Amount, p.StatementID, p.FinalAmount, p.FinalStatementID, p.FinalCreateDate, p.LastModifyDate, p.LastModifyUser,
p.ExternalRef, gl.GLCode
FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
GO

IF OBJECT_ID('vMasterAccountData') IS NOT NULL
BEGIN
DROP VIEW dbo.vMasterAccountData
END
GO

CREATE VIEW dbo.vMasterAccountData AS
SELECT mad.CustomerID, ma.GroupID, adt.AccountDataType, COALESCE(adv.ValueData, mad.Data) AS Data
FROM MasterAccountData mad JOIN MasterAccounts ma ON (mad.CustomerID = ma.CustomerID)
	JOIN AccountDataTypes adt ON (mad.AccountDataTypeID = adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (mad.AccountDataTypeID = adv.AccountDataTypeID AND mad.Data = adv.KeyData)
GO


IF OBJECT_ID('vSubAccountData') IS NOT NULL
BEGIN
DROP VIEW dbo.vSubAccountData
END
GO

CREATE VIEW dbo.vSubAccountData AS
SELECT sad.AccountID, ma.GroupID, adt.AccountDataType, COALESCE(adv.ValueData, sad.Data) AS Data
FROM SubAccountData sad JOIN SubAccounts sa ON (sad.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountDataTypes adt ON (sad.AccountDataTypeID = adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (sad.AccountDataTypeID = adv.AccountDataTypeID AND sad.Data = adv.KeyData)
GO


IF OBJECT_ID('GaugeQ') IS NOT NULL
BEGIN
DROP VIEW dbo.GaugeQ
END
GO

CREATE VIEW dbo.GaugeQ AS
SELECT CAST(0 AS INT) AS AccountID, CAST(0 AS INT) AS GaugeID, CAST(0 AS FLOAT) AS Data
GO


IF OBJECT_ID('vInvProducts') IS NOT NULL
BEGIN
DROP VIEW dbo.vInvProducts
END
GO

CREATE VIEW dbo.vInvProducts AS
SELECT ip.InvProductID, ic.InvCategory, isc.InvSubCategory, is1.InvSource, ip.GroupID, g.GroupName, al.AccessLabel, 
ip.Title, ip.Description, ip.OrderInfo, ct.ChargeType, gl.GLCode, ip.SupplierCost, ip.Cost, ip.L, ip.W, ip.H, ip.Weight, ip.SKU,
ip.ModelNumber, ip.SupplierSKU, ip.EAN, ip.SerialNumberRegExp, ip.CreateDate, ip.CreateUser, ip.ExternalRef, ip.Active, ip.SortOrder
FROM InvProducts ip JOIN InvCategories ic ON (ip.InvCategoryID = ic.InvCategoryID)
	JOIN InvSources is1 ON (ip.InvSourceID = is1.InvSourceID)
	LEFT JOIN InvSubCategories isc ON (ip.InvSubCategoryID = isc.InvSubCategoryID)
	LEFT JOIN AccessLabels al ON (ip.AccessLabelID = al.AccessLabelID)
	LEFT JOIN Groups g ON (ip.GroupID = g.GroupID)
	LEFT JOIN ChargeTypes ct ON (ip.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
GO

IF OBJECT_ID('vInvItems') IS NOT NULL
BEGIN
DROP VIEW dbo.vInvItems
END
GO

CREATE VIEW dbo.vInvItems AS
SELECT ii.InvItemID, ii.InvProductID, ip.Title, ip.EAN, ip.SKU, ip.SupplierSKU, ist.InvStateType, is1.InvState, iw.InvWarehouse, iwp.Location, ii.CustomerID, ii.AccountID, ma.GroupID, bii.InvoiceID, ii.ItemID, ii.SerialNumber,
COALESCE(ii.SupplierCost,ip.SupplierCost) AS SupplierCost, COALESCE(ii.Cost,ip.Cost) AS Cost, gl.GLCode, ii.RecvDate, ii.ShipDate, ii.ReturnDate, ii.AssignDate, ii.AssignUser, ii.TrackNumber, ii.Comments, ii.ExternalRef, ii.CreateDate, ii.CreateUser
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	LEFT JOIN MasterAccounts ma ON (ii.CustomerID = ma.CustomerID)
	LEFT JOIN InvWarehouses iw ON (ii.InvWarehouseID = iw.InvWarehouseID)
	LEFT JOIN InvWarehouseProducts iwp ON (ii.InvProductID = iwp.InvProductID AND ii.InvWarehouseID = iwp.InvWarehouseID)
	LEFT JOIN InvoiceItems bii ON (ii.ItemID = bii.ItemID)
	LEFT JOIN ChargeTypes ct ON (ip.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
GO

IF OBJECT_ID('vAuditTrans') IS NOT NULL
BEGIN
DROP VIEW dbo.vAuditTrans
END
GO

CREATE VIEW dbo.vAuditTrans AS
SELECT atr.AuditTransID, atr.CommitDate, o.Operator, COALESCE(a.FirstName + ' ' + a.LastName,a.Company,CAST(ma.CustomerID AS VARCHAR(10))) AS Customer,
atr.IPAddress, aa.AuditAction, mt.TableName, ata.KeyID AS ID, mc.ColumnName, atu.PreviousData, atu.Data
FROM AuditTableUpdates atu JOIN AuditTables ata ON (atu.AuditTableID = ata.AuditTableID)
	JOIN AuditActions aa ON (ata.AuditActionID = aa.AuditActionID)
	JOIN AuditTrans atr ON (ata.AuditTransID = atr.AuditTransID)
	JOIN MetaColumns mc ON (atu.MetaColumnID = mc.MetaColumnID)
	JOIN MetaTables mt ON (mc.MetaTableID = mt.MetaTableID)
	LEFT JOIN Operators o ON (atr.OperatorID = o.OperatorID)
	LEFT JOIN MasterAccounts ma ON (ma.CustomerID = atr.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ata.AuditActionID = 2

UNION ALL

SELECT atr.AuditTransID, atr.CommitDate, o.Operator, COALESCE(a.FirstName + ' ' + a.LastName,a.Company,CAST(ma.CustomerID AS VARCHAR(10))) AS Customer,
atr.IPAddress, aa.AuditAction, mt.TableName, ata.KeyID AS ID, mc.ColumnName, NULL, ati.Data
FROM AuditTableInserts ati JOIN AuditTables ata ON (ati.AuditTableID = ata.AuditTableID)
	JOIN AuditActions aa ON (ata.AuditActionID = aa.AuditActionID)
	JOIN AuditTrans atr ON (ata.AuditTransID = atr.AuditTransID)
	JOIN MetaColumns mc ON (ati.MetaColumnID = mc.MetaColumnID)
	JOIN MetaTables mt ON (mc.MetaTableID = mt.MetaTableID)
	LEFT JOIN Operators o ON (atr.OperatorID = o.OperatorID)
	LEFT JOIN MasterAccounts ma ON (ma.CustomerID = atr.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ata.AuditActionID = 1

UNION ALL

SELECT atr.AuditTransID, atr.CommitDate, o.Operator, COALESCE(a.FirstName + ' ' + a.LastName,a.Company,CAST(ma.CustomerID AS VARCHAR(10))) AS Customer,
atr.IPAddress, aa.AuditAction, mt.TableName, ata.KeyID AS ID, NULL, NULL, NULL
FROM AuditTables ata JOIN AuditActions aa ON (ata.AuditActionID = aa.AuditActionID)
	JOIN AuditTrans atr ON (ata.AuditTransID = atr.AuditTransID)
	JOIN MetaTables mt ON (ata.MetaTableID = mt.MetaTableID)
	LEFT JOIN Operators o ON (atr.OperatorID = o.OperatorID)
	LEFT JOIN MasterAccounts ma ON (ma.CustomerID = atr.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ata.AuditActionID = 3
GO

IF OBJECT_ID('vAddresses') IS NOT NULL
BEGIN
DROP VIEW dbo.vAddresses
END
GO

CREATE VIEW vAddresses AS
SELECT a.AddressID, a.CustomerID, a.AccountID, a.CreateDate, a.CreateUser, at1.AddressType,
a.FirstName, a.LastName, a.Company, 
a.Address1, a.Address2, a.City, s.State, s.Abbreviation AS StateAbbr, a.Zip, 
s.NationalRegion AS NationalRegion, c.Country, c.Abbr2 AS CountryAbbr2, c.Abbr3 AS CountryAbbr3,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
CASE WHEN a.Lat IS NULL AND a.Long IS NULL AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL THEN 1 ELSE 0 END AS Geocoded,
a.PhoneHome, a.PhoneWork, a.PhoneFax, a.PhoneMobile, a.Email, a.WWW, it.IMType, a.IMHandle, 
a.Aux1, a.Aux2, a.Aux3, a.SSN, a.TaxNumber, a.DLNumber, a.SMSAccessTime, 
a.SMSNoticePurposeMask, a.EmailNoticePurposeMask, a.Comments, a.LastModifyDate, a.LastModifyUser
FROM Addresses a JOIN AddressTypes at1 ON (a.AddressTypeID = at1.AddressTypeID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN States s ON (a.CountryID = s.CountryID AND a.StateID = s.StateID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN IMTypes it ON (a.IMTypeID = it.IMTypeID)
GO

