IF COL_LENGTH('dbo.MasterAccounts','PIN') IS NULL
BEGIN
ALTER TABLE dbo.MasterAccounts ADD PIN VARCHAR(10)
END
GO

IF COL_LENGTH('dbo.SignupOptions','TimeChargeID') IS NULL
BEGIN
IF INDEXPROPERTY(OBJECT_ID('dbo.SignupOptions'),'i_SignupOptions_SS_SC_AT','IndexID') IS NOT NULL
	BEGIN
	DROP INDEX dbo.SignupOptions.i_SignupOptions_SS_SC_AT
	END

ALTER TABLE dbo.SignupOptions ADD TimeChargeID INT

CREATE UNIQUE INDEX i_SignupOptions_SS_SC_AT ON dbo.SignupOptions
(
       SignupServerID,
       ServiceCategoryID,
       AccountTypeID,
       TimeChargeID
)

ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (TimeChargeID)
                             REFERENCES dbo.TimeCharges
END
GO

DELETE FROM Configs WHERE ConfigID IN (46,47,48,49)
GO

DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data NOT LIKE '%.%'
GO

UPDATE Configs SET ConfigID = 329 WHERE ConfigID = 325
GO

DELETE FROM ConfigValues WHERE ConfigID IN (513,517,525,530)
GO

DELETE FROM ConfigGroupData WHERE ConfigID IN (513,517,525,530)
GO

DELETE FROM Configs WHERE ConfigID IN (513,517,525,530)
GO

DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('cust_allow_loginchange.ews','cust_allow_passchange.ews','cust_allow_paymethodcc.ews','cust_allow_settings.ews','cust_allow_mgmt.ews','cust_allow_sa.ews','cust_passwd.ews','cust_passwd_f.ews','cust_passwd_save.ews','cust_sa_edit.ews','cust_sa_edit_f.ews','cust_sa_add_f.ews','cust_login_edit.ews','cust_login_f.ews','cust_login_save.ews','cust_settings.ews','cust_settings_save.ews','cust_recharge_f.ews','cust_status_f.ews')
GO

DELETE FROM MenuSets WHERE MenuItemID IN (235,237,264,253,254)
GO

DELETE FROM MenuItems WHERE MenuItemID IN (235,237,264,253,254)
GO

IF COL_LENGTH('dbo.ServiceCatAccountTypes','CustomerDescription') IS NULL
BEGIN
ALTER TABLE dbo.ServiceCatAccountTypes ADD CustomerDescription text
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.ExternalSystemAccountTypes'),'i_ExternalSystemAccountTypes_ATID','IndexID') IS NULL
BEGIN
CREATE INDEX i_ExternalSystemAccountTypes_ATID ON dbo.ExternalSystemAccountTypes (AccountTypeID,ExternalSystemID,ExternalRef)
END
GO

IF OBJECT_ID('dbo.APIActions') IS NULL
BEGIN

CREATE TABLE dbo.APIActions (
       APIActionID          int NOT NULL,
       APIAction            varchar(64) NOT NULL,
       APIActionTypeID      int NOT NULL,
       APIGroupCheckID      int NULL,
       FeatureID            int NULL,
       Description          text NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1
)

CREATE UNIQUE INDEX i_APIActions_APIAction ON dbo.APIActions
(
       APIAction
)

ALTER TABLE dbo.APIActions
       ADD PRIMARY KEY (APIActionID)

CREATE TABLE dbo.APIActionTypes (
       APIActionTypeID      int NOT NULL,
       APIActionType        varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.APIActionTypes
       ADD PRIMARY KEY (APIActionTypeID)

CREATE TABLE dbo.APIFields (
       APIFieldID           int IDENTITY,
       APIFieldTypeID       int NOT NULL,
       APIActionID          int NOT NULL,
       FieldName            varchar(64) NOT NULL,
       Required             varchar(128) NULL,
       Example              varchar(64) NULL,
       Description          text NULL
)

CREATE UNIQUE INDEX i_APIFields_AAID_FN_AFTID ON dbo.APIFields
(
       APIActionID,
       FieldName,
       APIFieldTypeID
)

ALTER TABLE dbo.APIFields
       ADD PRIMARY KEY (APIFieldID)

CREATE TABLE dbo.APIFieldTypes (
       APIFieldTypeID       int NOT NULL,
       APIFieldType         varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.APIFieldTypes
       ADD PRIMARY KEY (APIFieldTypeID)


CREATE TABLE dbo.APIGroupChecks (
       APIGroupCheckID      int NOT NULL,
       APIGroupCheck        varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.APIGroupChecks
       ADD PRIMARY KEY (APIGroupCheckID)

CREATE TABLE dbo.APIProfileItems (
       APIProfileID         int NOT NULL,
       APIFieldID           int NOT NULL,
       Data                 varchar(255) NULL
)

ALTER TABLE dbo.APIProfileItems
       ADD PRIMARY KEY (APIProfileID, APIFieldID)

CREATE TABLE dbo.APIProfiles (
       APIProfileID         int IDENTITY,
       APIProfile           varchar(128) NOT NULL
)

CREATE UNIQUE INDEX i_APIProfiles_APIProfile ON dbo.APIProfiles
(
       APIProfile
)

ALTER TABLE dbo.APIProfiles
       ADD PRIMARY KEY (APIProfileID)

CREATE TABLE dbo.APIStepColumns (
       APIStepID            int NOT NULL,
       MetaColumnID         int NOT NULL,
       Data                 varchar(255) NULL,
       DefaultData          varchar(255) NULL,
       Active               tinyint NOT NULL DEFAULT 1
)

ALTER TABLE dbo.APIStepColumns
       ADD PRIMARY KEY (APIStepID, MetaColumnID)

CREATE TABLE dbo.APISteps (
       APIStepID            int IDENTITY,
       APIStep              varchar(128) NOT NULL,
       APIActionID          int NOT NULL,
       Step                 int NOT NULL,
       APIStepTypeID        int NOT NULL,
       FeatureID            int NULL,
       Condition            varchar(255) NULL,
       MetaTableID          int NULL,
       ValueQuery           text NULL,
       ValueFields          text NULL,
       DisplayQuery         text NULL,
       DisplayParent        varchar(64) NULL,
       EWS                  text NULL,
       IEAID                int NULL,
       Active               tinyint NOT NULL DEFAULT 1
)

CREATE UNIQUE INDEX i_APISteps_AAID_Step ON dbo.APISteps
(
       APIActionID,
       Step
)

ALTER TABLE dbo.APISteps
       ADD PRIMARY KEY (APIStepID)

CREATE TABLE dbo.APIStepTypes (
       APIStepTypeID        int NOT NULL,
       APIStepType          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.APIStepTypes
       ADD PRIMARY KEY (APIStepTypeID)


CREATE TABLE dbo.APITokens (
       APITokenID           bigint IDENTITY,
       OperatorID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CommitDate           datetime NULL,
       Locked               tinyint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.APITokens
       ADD PRIMARY KEY (APITokenID)

ALTER TABLE dbo.APIActions
       ADD FOREIGN KEY (APIActionTypeID)
                             REFERENCES dbo.APIActionTypes

ALTER TABLE dbo.APIActions
       ADD FOREIGN KEY (APIGroupCheckID)
                             REFERENCES dbo.APIGroupChecks

ALTER TABLE dbo.APIFields
       ADD FOREIGN KEY (APIFieldTypeID)
                             REFERENCES dbo.APIFieldTypes

ALTER TABLE dbo.APIFields
       ADD FOREIGN KEY (APIActionID)
                             REFERENCES dbo.APIActions

ALTER TABLE dbo.APIProfileItems
       ADD FOREIGN KEY (APIProfileID)
                             REFERENCES dbo.APIProfiles

ALTER TABLE dbo.APIProfileItems
       ADD FOREIGN KEY (APIFieldID)
                             REFERENCES dbo.APIFields

ALTER TABLE dbo.APIStepColumns
       ADD FOREIGN KEY (MetaColumnID)
                             REFERENCES dbo.MetaColumns

ALTER TABLE dbo.APIStepColumns
       ADD FOREIGN KEY (APIStepID)
                             REFERENCES dbo.APISteps

ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (APIStepTypeID)
                             REFERENCES dbo.APIStepTypes

ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES dbo.MetaTables

ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (APIActionID)
                             REFERENCES dbo.APIActions

ALTER TABLE dbo.APITokens
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
END
GO

IF COL_LENGTH('dbo.InvStateGroups','POSInvStateID') IS NULL
BEGIN
ALTER TABLE dbo.InvStateGroups ADD POSInvStateID INT

ALTER TABLE dbo.InvStateGroups ADD AssignInvStateID INT

ALTER TABLE dbo.InvStateGroups
       ADD FOREIGN KEY (POSInvStateID)
                             REFERENCES dbo.InvStates

ALTER TABLE dbo.InvStateGroups
       ADD FOREIGN KEY (AssignInvStateID)
                             REFERENCES dbo.InvStates
END
GO


IF OBJECT_ID('dbo.InvoiceGaps') IS NULL
BEGIN
CREATE TABLE dbo.InvoiceGaps (
       InvoiceID            int NOT NULL,
       Locked               tinyint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.InvoiceGaps
       ADD PRIMARY KEY (InvoiceID)
END
GO

IF COL_LENGTH('dbo.Dashes','OrganizationID') IS NULL
BEGIN
ALTER TABLE dbo.Dashes ADD OrganizationID INT
ALTER TABLE dbo.Dashes ADD GroupID INT
ALTER TABLE dbo.Dashes ADD RegionID INT
ALTER TABLE dbo.Dashes ADD MarketTagID INT
ALTER TABLE dbo.Dashes ADD IncidentTypeID INT
ALTER TABLE dbo.Dashes ADD IncidentStateID INT
ALTER TABLE dbo.Dashes ADD RoleID INT
ALTER TABLE dbo.Dashes ADD SchedBlockTypeID INT
ALTER TABLE dbo.Dashes ADD Aux1 INT
ALTER TABLE dbo.Dashes ADD Aux2 INT
ALTER TABLE dbo.Dashes ADD Aux3 INT
ALTER TABLE dbo.Dashes ADD Aux4 INT
ALTER TABLE dbo.Dashes ADD Aux5 INT

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles

ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (SchedBlockTypeID)
                             REFERENCES dbo.SchedBlockTypes
END
GO

UPDATE Schedules SET Parameter = '{CALL InvoiceGapUpdate}' WHERE Parameter = '{CALL InvoiceGaps}' AND TaskName = 'querytrans'
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Payments'),'i_Payments_CD','IndexID') IS NULL
BEGIN
CREATE INDEX i_Payments_CD ON dbo.Payments (CreateDate)
END
GO

IF COL_LENGTH('dbo.WebLinkTypes','AllowOperatorPing') IS NULL
BEGIN
ALTER TABLE dbo.WebLinkTypes ADD AllowOperatorPing tinyint NOT NULL DEFAULT 0
ALTER TABLE dbo.WebLinkTypes ADD AllowAddrLocation tinyint NOT NULL DEFAULT 0
ALTER TABLE dbo.WebLinks ADD Timeout int NULL
CREATE INDEX i_WebLinks_WLT_URL ON dbo.WebLinks (WebLinkTypeID,URL)
CREATE INDEX i_WebLinkTypes_AAL_GID ON dbo.WebLinkTypes (AllowAddrLocation,GroupID)
END
GO

IF COL_LENGTH('dbo.AddressSyncs','SessionRef') IS NULL
BEGIN
ALTER TABLE dbo.AddressSyncs ADD SessionRef VARCHAR(32)
END
GO

IF COL_LENGTH('dbo.InvoiceItems','TaxableAmount') IS NULL
BEGIN
ALTER TABLE dbo.InvoiceItems ADD TaxableAmount NUMERIC(18,4)
END
GO

DELETE FROM Objects WHERE
	ObjectTypeID=3 
	AND ObjectGroupID IN (6,15)
	AND Value IN (SELECT MetaColumnID FROM MetaColumns mc JOIN MetaTables mt ON (mc.MetaTableID = mt.MetaTableID) WHERE mt.TableName IN ('WebLinks','Notices'))
GO

DELETE FROM Objects WHERE
	ObjectTypeID=2 
	AND ObjectGroupID IN (6,15)
	AND Value IN (SELECT MetaTableID FROM MetaTables WHERE TableName IN ('WebLinks','Notices'))
GO

IF OBJECT_ID('dbo.NoticeFormats') IS NULL
BEGIN
CREATE TABLE dbo.NoticeFormats (
       NoticeFormatID       smallint NOT NULL,
       NoticeFormat         varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.NoticeFormats
       ADD PRIMARY KEY (NoticeFormatID)
END
GO

IF COL_LENGTH('dbo.Notices','NoticeFormatID') IS NULL
BEGIN
ALTER TABLE dbo.Notices ADD NoticeFormatID SMALLINT

ALTER TABLE dbo.Notices
       ADD FOREIGN KEY (NoticeFormatID)
                             REFERENCES dbo.NoticeFormats
END
GO

IF OBJECT_ID('dbo.Monitors') IS NULL
BEGIN
CREATE TABLE dbo.MonFilterItems (
       MonFilterItemID      int IDENTITY,
       MonFilterID          int NOT NULL,
       RegionID             int NULL,
       TowerID              int NULL,
       MarketTagID          int NULL,
       GroupID              int NULL,
       ServiceCategoryID    int NULL,
       AccountTypeID        int NULL,
       ServerID             int NULL,
       ServerGroupID        int NULL,
       Allowed              tinyint NOT NULL DEFAULT 1
)

ALTER TABLE dbo.MonFilterItems
       ADD PRIMARY KEY (MonFilterItemID)


CREATE INDEX i_MonFilterItems_MFID ON dbo.MonFilterItems (MonFilterID)

CREATE TABLE dbo.MonFilters (
       MonFilterID          int IDENTITY,
       MonFilter            varchar(128) NOT NULL,
       MonSourceID          smallint NOT NULL,
       AllowExpired         tinyint NOT NULL DEFAULT 1
)

ALTER TABLE dbo.MonFilters
       ADD PRIMARY KEY (MonFilterID)

CREATE TABLE dbo.MonitorProfileOptions (
       MonitorID            int NOT NULL,
       MonProfileItemID     int NOT NULL,
       GaugeID              int NULL
)

ALTER TABLE dbo.MonitorProfileOptions
       ADD PRIMARY KEY (MonitorID, MonProfileItemID)

CREATE TABLE dbo.Monitors (
       MonitorID            int IDENTITY,
       Monitor              varchar(128) NOT NULL,
       MonSourceID          smallint NOT NULL,
       InvProductID         int NULL,
       MonFilterID          int NULL,
       MonProtocolID        smallint NOT NULL,
       MonRadIPSourceID     smallint NULL,
       IPAddress            varchar(64) NULL,
       MonProfileID         int NULL,
       Pace                 float NULL,
       Timeout              int NULL,
       Login                varchar(64) NULL,
       Password             varchar(200) NULL,
       PrivPassword         varchar(200) NULL,
       PingInterval         int NULL,
       Pings                int NULL,
       PingMinGaugeID       int NULL,
       PingMaxGaugeID       int NULL,
       PingAvgGaugeID       int NULL,
       PingTimeoutGaugeID   int NULL,
       PingJitterGaugeID    int NULL,
       SNMPCommunity        varchar(64) NULL,
       SNMPAuthProto        varchar(20) NULL,
       SNMPPrivProto        varchar(20) NULL,
       IPInvAttributeID     int NULL,
       LoginInvAttributeID  int NULL,
       PasswordInvAttributeID int NULL,
       PrivPasswordInvAttributeID int NULL,
       CommunityInvAttributeID int NULL,
       Active               tinyint NOT NULL DEFAULT 1
)

ALTER TABLE dbo.Monitors
       ADD PRIMARY KEY (MonitorID)

CREATE TABLE dbo.MonProfileItems (
       MonProfileItemID     int IDENTITY,
       MonProfileID         int NOT NULL,
       MonProfileItem       varchar(128) NOT NULL,
       OID                  varchar(512) NOT NULL,
       Multiplier           float NOT NULL DEFAULT 1,
       GaugeID              int NULL,
       TableOID             varchar(512) NULL,
       TableValue           varchar(128) NULL,
       InvAttributeID       int NULL,
       AccountDataTypeID    int NULL
)

ALTER TABLE dbo.MonProfileItems
       ADD PRIMARY KEY (MonProfileItemID)

CREATE TABLE dbo.MonProfiles (
       MonProfileID         int IDENTITY,
       MonProfile           varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.MonProfiles
       ADD PRIMARY KEY (MonProfileID)

CREATE TABLE dbo.MonProtocols (
       MonProtocolID        smallint NOT NULL,
       MonProtocol          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.MonProtocols
       ADD PRIMARY KEY (MonProtocolID)

CREATE TABLE dbo.MonRadIPSources (
       MonRadIPSourceID     smallint NOT NULL,
       MonRadIPSource       varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.MonRadIPSources
       ADD PRIMARY KEY (MonRadIPSourceID)

CREATE TABLE dbo.MonSources (
       MonSourceID          smallint NOT NULL,
       MonSource            varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.MonSources
       ADD PRIMARY KEY (MonSourceID)

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (MonFilterID)
                             REFERENCES dbo.MonFilters

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups

ALTER TABLE dbo.MonFilters
       ADD FOREIGN KEY (MonSourceID)
                             REFERENCES dbo.MonSources

ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (MonitorID)
                             REFERENCES dbo.Monitors

ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (MonProfileItemID)
                             REFERENCES dbo.MonProfileItems

ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonFilterID)
                             REFERENCES dbo.MonFilters

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonProtocolID)
                             REFERENCES dbo.MonProtocols

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonRadIPSourceID)
                             REFERENCES dbo.MonRadIPSources

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonProfileID)
                             REFERENCES dbo.MonProfiles

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingMinGaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingMaxGaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingAvgGaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingTimeoutGaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingJitterGaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (IPInvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (LoginInvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PasswordInvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PrivPasswordInvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (CommunityInvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (MonProfileID)
                             REFERENCES dbo.MonProfiles

ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes

ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.MonProfileItems'),'i_MonProfileItems_MPID','IndexID') IS NULL
BEGIN
CREATE INDEX i_MonProfileItems_MPID ON dbo.MonProfileItems (MonProfileID)
END
GO

IF COL_LENGTH('dbo.Exports','Retries') IS NULL
BEGIN
ALTER TABLE dbo.Exports ADD Retries INT
ALTER TABLE dbo.Exports ADD RetryDelay INT
END
GO

IF COL_LENGTH('dbo.TaxSources','BillingImportID') IS NULL
BEGIN
ALTER TABLE dbo.TaxSources ADD BillingImportID INT
ALTER TABLE dbo.BillingImports ADD Description text
ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (BillingImportID)
                             REFERENCES dbo.BillingImports
END
GO

IF COL_LENGTH('dbo.TaxRates','AddressData2') IS NULL
BEGIN
ALTER TABLE dbo.TaxSources ADD AddressDataTypeID2 INT
ALTER TABLE dbo.TaxGroupTaxes ADD AddressDataTypeID2 INT
ALTER TABLE dbo.TaxGroupTaxes ADD AddressData2 VARCHAR(512)
ALTER TABLE dbo.TaxRates ADD AddressData2 VARCHAR(512)
ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (AddressDataTypeID2)
                             REFERENCES dbo.AddressDataTypes
ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (AddressDataTypeID2)
                             REFERENCES dbo.AddressDataTypes
END
GO

IF COL_LENGTH('dbo.ReportGroups','FeatureID') IS NULL
BEGIN
ALTER TABLE dbo.ReportGroups ADD FeatureID INT
END
GO

IF COL_LENGTH('dbo.Gauges','GaugeConversionID') IS NULL
BEGIN
CREATE TABLE dbo.GaugeCounterData (
       AccountID            int NOT NULL,
       GaugeID              int NOT NULL,
       Data                 float NOT NULL,
       LastUpdate           datetime NOT NULL
)

CREATE TABLE dbo.GaugeConversions (
       GaugeConversionID    int NOT NULL,
       GaugeConversion      varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.GaugeCounterData
       ADD PRIMARY KEY (AccountID, GaugeID)

ALTER TABLE dbo.GaugeConversions
       ADD PRIMARY KEY (GaugeConversionID)

ALTER TABLE dbo.GaugeCounterData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts

ALTER TABLE dbo.GaugeCounterData
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges

ALTER TABLE dbo.Gauges ADD GaugeConversionID INT

ALTER TABLE dbo.Gauges
       ADD FOREIGN KEY (GaugeConversionID)
                             REFERENCES dbo.GaugeConversions
END
GO

IF COL_LENGTH('dbo.MonProfileItems','RegExp') IS NULL
BEGIN
ALTER TABLE dbo.MonProfileItems ADD RegExp VARCHAR(1024)
END
GO

IF COL_LENGTH('dbo.MonFilterItems','DomainID') IS NULL
BEGIN
ALTER TABLE dbo.MonFilterItems ADD DomainID INT
ALTER TABLE dbo.MonFilterItems ADD InvProductID INT

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
END
GO

IF COL_LENGTH('dbo.Events','TowerID') IS NULL
BEGIN
ALTER TABLE dbo.Events ADD TowerID INT

ALTER TABLE dbo.Events
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
END
GO

IF COL_LENGTH('dbo.InvAttributes','ServiceAccess') IS NULL
BEGIN
ALTER TABLE dbo.InvAttributes ADD ServiceAccess tinyint NOT NULL DEFAULT 0
END
GO

IF COL_LENGTH('dbo.Gauges','DataLabel') IS NULL
BEGIN
ALTER TABLE dbo.Gauges ADD DataLabel VARCHAR(128)
END
GO

IF COL_LENGTH('dbo.Events','BulkProfileID') IS NULL
BEGIN
ALTER TABLE dbo.Events ADD BulkProfileID INT

ALTER TABLE dbo.Events
       ADD FOREIGN KEY (BulkProfileID)
                             REFERENCES dbo.BulkProfiles
END
GO

IF COL_LENGTH('dbo.Reports','Col2Group') IS NULL
BEGIN
ALTER TABLE dbo.Reports ADD Col2Group VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Sum VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Min VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Max VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Count VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Order VARCHAR(128)
ALTER TABLE dbo.Reports ADD Col2Avg VARCHAR(128)
END
GO

IF OBJECT_ID('dbo.ServiceLevelTypes') IS NULL
BEGIN
CREATE TABLE dbo.ServiceLevelTypes (
	ServiceLevelTypeID int IDENTITY,
	ServiceLevelType varchar (128) NOT NULL,
	Description text NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.ServiceLevelTypes
       ADD PRIMARY KEY (ServiceLevelTypeID)

CREATE TABLE dbo.ServiceCatAccess (
	ServiceCatAccessID int IDENTITY,
	ServiceCategoryID int NOT NULL,
	OperatorGroupID int NOT NULL,
	BulkProfileID int NULL 
)

ALTER TABLE dbo.ServiceCatAccess
       ADD PRIMARY KEY NONCLUSTERED (ServiceCatAccessID)

CREATE CLUSTERED INDEX i_ServiceCatAccess_SCID_OGID ON dbo.ServiceCatAccess
(
	ServiceCategoryID,
	OperatorGroupID
)

CREATE TABLE dbo.ServiceCatATAccess (
	ServiceCatATAccessID int IDENTITY,
	ServiceCategoryID int NOT NULL,
	AccountTypeID int NOT NULL,
	OperatorGroupID int NOT NULL,
	BulkProfileID int NULL 
)

ALTER TABLE dbo.ServiceCatATAccess
       ADD PRIMARY KEY NONCLUSTERED (ServiceCatATAccessID)

CREATE CLUSTERED INDEX i_ServiceCatATAccess_SCID_ATID_OGID ON dbo.ServiceCatATAccess
(
	ServiceCategoryID,
	AccountTypeID,
	OperatorGroupID
)

ALTER TABLE dbo.ServiceCatAccountTypes ADD CustServiceLevelTypeID INT

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (ServiceCategoryID)
		 REFERENCES dbo.ServiceCategories

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (OperatorGroupID)
		 REFERENCES dbo.OperatorGroups

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (BulkProfileID)
		 REFERENCES dbo.BulkProfiles

ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (ServiceCategoryID,AccountTypeID)
		 REFERENCES dbo.ServiceCatAccountTypes

ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (OperatorGroupID)
		 REFERENCES dbo.OperatorGroups

ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (BulkProfileID)
		 REFERENCES dbo.BulkProfiles

ALTER TABLE dbo.ServiceCatAccountTypes
       ADD FOREIGN KEY (CustServiceLevelTypeID)
                             REFERENCES dbo.ServiceLevelTypes
END
GO

IF COL_LENGTH('dbo.BulkItems','AddressDataTypeID') IS NULL
BEGIN
ALTER TABLE dbo.BulkItems ADD AddressDataTypeID INT
ALTER TABLE dbo.BulkItems ADD AddressData VARCHAR(128)

ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
END
GO

IF COL_LENGTH('dbo.States','NationalRegion') IS NULL
BEGIN
ALTER TABLE dbo.States ADD NationalRegion VARCHAR(32)
END
GO

UPDATE Schedules SET TaskName = 'query' WHERE Parameter = '{CALL GaugeRollup}' AND TaskName = 'querytrans'
GO

IF COL_LENGTH('dbo.RegFCC477Techs','RegFCC477VoiceTransportID') IS NULL
BEGIN
ALTER TABLE dbo.RegFCC477Techs ADD RegFCC477VoiceTransportID INT

ALTER TABLE dbo.RegFCC477Techs
       ADD FOREIGN KEY (RegFCC477VoiceTransportID)
                             REFERENCES dbo.RegFCC477VoiceTransports
END
GO

IF OBJECT_ID('dbo.InvCarts') IS NULL
BEGIN
CREATE TABLE dbo.InvCarts (
	InvCartID	int IDENTITY,
	OperatorID	int NOT NULL,
	InvCart 	varchar(128) NULL,
	CreateDate	datetime NOT NULL DEFAULT getdate(),
	LastModifyDate	datetime NOT NULL DEFAULT getdate(),
	Comments	text NULL
)

ALTER TABLE dbo.InvCarts
       ADD PRIMARY KEY (InvCartID)

CREATE INDEX i_InvCarts_OperatorID ON dbo.InvCarts (OperatorID)

CREATE TABLE dbo.InvCartItems (
	InvCartID	int NOT NULL,
	InvItemID	int NOT NULL,
	CreateInvStateID	int NULL,
	CreateInvWarehouseID	int NULL
)

ALTER TABLE dbo.InvCartItems
       ADD PRIMARY KEY (InvCartID,InvItemID)

CREATE INDEX i_InvCartItems_InvItemID ON dbo.InvCartItems (InvItemID)

ALTER TABLE dbo.Operators ADD InvCartID INT

ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (InvCartID)
                             REFERENCES dbo.InvCarts

ALTER TABLE dbo.InvCarts
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (InvCartID)
                             REFERENCES dbo.InvCarts

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (CreateInvStateID)
                             REFERENCES dbo.InvStates

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (CreateInvWarehouseID)
                             REFERENCES dbo.InvWarehouses
END
GO

IF OBJECT_ID('dbo.InvWarehouseGroups') IS NULL
BEGIN
CREATE TABLE dbo.InvWarehouseGroups (
	InvWarehouseGroupID	int IDENTITY,
	InvWarehouseGroup	varchar (128) NOT NULL,
	Description		text NULL,
	PrimaryInvWarehouseID	int NULL,
	Active			tinyint	NOT NULL DEFAULT 1,
	SortOrder		smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.InvWarehouseGroups
       ADD PRIMARY KEY (InvWarehouseGroupID)

CREATE INDEX i_IWG_PrimaryInvWarehouseID ON dbo.InvWarehouseGroups (PrimaryInvWarehouseID)

CREATE TABLE dbo.InvWarehouseGroupItems (
	InvWarehouseGroupID	int NOT NULL,
	InvWarehouseID		int NOT NULL 
)

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD PRIMARY KEY (InvWarehouseGroupID, InvWarehouseID)

CREATE INDEX i_IWGI_InvWarehouseID ON dbo.InvWarehouseGroupItems (InvWarehouseID)

ALTER TABLE dbo.InvWarehouseGroups
       ADD FOREIGN KEY (PrimaryInvWarehouseID)
                             REFERENCES dbo.InvWarehouses

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD FOREIGN KEY (InvWarehouseGroupID)
                             REFERENCES dbo.InvWarehouseGroups

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD FOREIGN KEY (InvWarehouseID)
                             REFERENCES dbo.InvWarehouses
END
GO

IF OBJECT_ID('dbo.Calendars') IS NULL
BEGIN
CREATE TABLE dbo.Calendars (
	CalendarID	int IDENTITY,
	Calendar	varchar (128) NOT NULL,
	CreateDate	datetime NOT NULL DEFAULT getdate(),
	OperatorID	int NOT NULL,
	OrganizationID	int NULL,
	GroupID		int NULL,
	IncidentTypeID	int NULL,
	RoleID		int NULL,
	AuthKey		varchar (32) NOT NULL,
	LastModifyDate	datetime NULL DEFAULT getdate()
)

ALTER TABLE dbo.Calendars
       ADD PRIMARY KEY (CalendarID)

CREATE UNIQUE INDEX i_Calendars_AuthKey ON dbo.Calendars (AuthKey)

CREATE INDEX i_Calendars_OperatorID ON dbo.Calendars (OperatorID)

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles
END
GO

IF COL_LENGTH('dbo.AccountTypes','DataLeftAuth') IS NULL
BEGIN
ALTER TABLE dbo.AccountTypes ADD DataLeftAuth tinyint NOT NULL DEFAULT 0
END
GO

IF COL_LENGTH('dbo.InvLevelAttributes','DefaultData') IS NULL
BEGIN
ALTER TABLE dbo.InvLevelAttributes ADD DefaultData VARCHAR(255)
ALTER TABLE dbo.InvLevelAttributes ADD DefaultInvValueID INT

ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (DefaultInvValueID)
                             REFERENCES dbo.InvValues
END
GO

IF COL_LENGTH('dbo.MasterAccounts','PO') IS NULL
BEGIN
ALTER TABLE dbo.MasterAccounts ADD PO VARCHAR(25)
END
GO

IF COL_LENGTH('dbo.CreditCards','Token') IS NULL
BEGIN
ALTER TABLE dbo.Exports ADD FileTokenLocal VARCHAR(64)
ALTER TABLE dbo.ExternalTrans ADD Token VARCHAR(128)
ALTER TABLE dbo.CreditCards ALTER COLUMN CardNumber VARCHAR(70)
ALTER TABLE dbo.CreditCards ADD Token VARCHAR(128)

ALTER TABLE dbo.CreditCards ADD BatchProcessorID INT
ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES dbo.BatchProcessors

CREATE INDEX i_CreditCards_Token ON dbo.CreditCards (Token)
CREATE INDEX i_CreditCards_CardNumber ON dbo.CreditCards (CardNumber)
END
GO

IF COL_LENGTH('dbo.Notices','AttachFileName') IS NULL
BEGIN
ALTER TABLE dbo.Notices ADD AttachFileName VARCHAR(64)
END
GO

UPDATE RadAttributes SET RadAttributeType = 20, Name = CASE RadAttributeID 
		WHEN 117 THEN '3GPP2-DNS-Server-IPv4' 
		WHEN 132 THEN '3GPP2-Granted-QoS-Parms' ELSE Name END
	WHERE RadVendorID = 5535
	AND RadAttributeType = 6
	AND RadAttributeID IN (73,90,91,98,117,131,132)
GO

IF COL_LENGTH('dbo.Operators','TimeFormatID') IS NULL
BEGIN
ALTER TABLE dbo.Operators ADD TimeFormatID SMALLINT
END
GO

IF ((SELECT NumValue FROM Configs WHERE ConfigID = 0) < 6033)
BEGIN
UPDATE InvoiceItems SET Days = DATEDIFF(dd,StartDate,EndDate) + 1
	WHERE Quantity > 0
	AND ItemType = 3
	AND Days = 0
	AND StartDate <= EndDate
	AND Quantity = DATEDIFF(dd,StartDate,EndDate) + 1
END
GO


IF OBJECT_ID('dbo.IPAddressTypes') IS NULL
BEGIN
CREATE TABLE dbo.IPAddressTypes (
	IPAddressTypeID smallint NOT NULL,
	IPAddressType varchar(128) NOT NULL 
)

ALTER TABLE dbo.IPAddressTypes
       ADD PRIMARY KEY (IPAddressTypeID)


CREATE TABLE dbo.IPAttributeTypes (
	IPAttributeTypeID int IDENTITY,
	IPAttributeType varchar(128) NOT NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.IPAttributeTypes
       ADD PRIMARY KEY (IPAttributeTypeID)


CREATE TABLE dbo.IPAttributes (
	IPAttributeID int IDENTITY,
	IPAttributeTypeID int NOT NULL,
	IPAttribute varchar(128) NOT NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.IPAttributes
       ADD PRIMARY KEY (IPAttributeID)


CREATE TABLE dbo.IPGroups (
	IPGroupID int IDENTITY,
	IPGroup varchar(128) NOT NULL,
	IPAddressTypeID smallint NOT NULL,
	Active tinyint NOT NULL DEFAULT 1,
	SortOrder smallint NOT NULL DEFAULT 0,
	RefCount int NOT NULL DEFAULT 0
)

ALTER TABLE dbo.IPGroups
       ADD PRIMARY KEY (IPGroupID)

CREATE TABLE dbo.IPInvAllocReqs (
	IPInvAllocReqID int IDENTITY,
	IPInvAllocationID int NOT NULL,
	IPRangeID int NULL,
	IPAttributeID int NULL 
)

CREATE UNIQUE INDEX uc_IPInvAllocReqs_ALID_RID_AID ON dbo.IPInvAllocReqs (IPInvAllocationID,IPRangeID,IPAttributeID)

ALTER TABLE dbo.IPInvAllocReqs
       ADD PRIMARY KEY (IPInvAllocReqID)


CREATE TABLE dbo.IPInvAllocations (
	IPInvAllocationID int IDENTITY,
	IPInvAllocation varchar(128) NOT NULL,
	IPGroupID int NOT NULL,
	InvProductID int NOT NULL,
	InvStateID int NOT NULL,
	PrefixLength smallint NOT NULL,
	TargetQty int NOT NULL,
	Active tinyint NOT NULL DEFAULT 1,
	StatAvailPrefixCount int NULL 
)

CREATE INDEX i_IPInvAllocations_IPGID ON dbo.IPInvAllocations (IPGroupID)

ALTER TABLE dbo.IPInvAllocations
       ADD PRIMARY KEY (IPInvAllocationID)

CREATE TABLE dbo.IPMessages (
	IPGroupID int NOT NULL,
	IPRangeID int NULL,
	InvItemID int NULL,
	IPInvAllocationID int NULL,
	Message varchar(512) NOT NULL 
)

CREATE CLUSTERED INDEX i_IPMessages_IPGroupID ON IPMessages (IPGroupID)

CREATE INDEX i_IPMessages_IPRangeID ON dbo.IPMessages (IPRangeID)

CREATE INDEX i_IPMessages_IPInvAllocationID ON dbo.IPMessages (IPInvAllocationID)

CREATE INDEX i_IPMessages_InvItemID ON dbo.IPMessages (InvItemID)

CREATE TABLE dbo.IPRangeAttributes (
	IPRangeID int NOT NULL,
	IPAttributeID int NOT NULL 
)

CREATE INDEX i_IPRangeAttributes_IPAID ON dbo.IPRangeAttributes (IPAttributeID)

ALTER TABLE dbo.IPRangeAttributes
       ADD PRIMARY KEY (IPRangeID,IPAttributeID)

CREATE TABLE dbo.IPRangeTypes (
	IPRangeTypeID smallint NOT NULL,
	IPRangeType varchar(128) NOT NULL 
)

ALTER TABLE dbo.IPRangeTypes
       ADD PRIMARY KEY (IPRangeTypeID)

CREATE TABLE dbo.IPRanges (
	IPRangeID int IDENTITY,
	IPGroupID int NOT NULL,
	IPRangeTypeID smallint NOT NULL,
	IPRange varchar(128) NOT NULL,
	PriorityID smallint NOT NULL,
	StatAvailable numeric(7,4) NULL,
	StatMinPrefixLength smallint NULL,
	StatOrder int NOT NULL DEFAULT 0,
	StatParentIPRangeID int NULL,
	Description varchar(255) NULL,
	Comments text NULL 
)

CREATE TABLE dbo.RadPoolConfigs (
	RadPoolConfigID int IDENTITY,
	InvProductID int NOT NULL,
	InvStateID int NOT NULL,
	ReleaseMins int NOT NULL DEFAULT 0,
	GroupID int NULL,
	ServiceCategoryID int NULL,
	AccountTypeID int NULL,
	MarketTagID int NULL,
	TowerID int NULL,
	ServerGroupID int NULL,
	ServerID int NULL,
	PriorityID smallint NOT NULL DEFAULT 0,
	Active tinyint NOT NULL DEFAULT 1
)

ALTER TABLE dbo.RadPoolConfigs
       ADD PRIMARY KEY (RadPoolConfigID)

CREATE INDEX i_IPRanges_IPGroupID ON dbo.IPRanges (IPGroupID)
CREATE UNIQUE INDEX uc_IPRanges_IPGID_IPRange ON dbo.IPRanges (IPGroupID,IPRange)
CREATE UNIQUE INDEX uc_IPInvAllocations_IPGID_IPID ON dbo.IPInvAllocations (IPGroupID,InvProductID)

ALTER TABLE dbo.IPRanges
       ADD PRIMARY KEY (IPRangeID)

ALTER TABLE dbo.InvItems ADD IPGroupID INT
ALTER TABLE dbo.InvItems ADD IPRangeID INT

ALTER TABLE dbo.IPAttributes
       ADD FOREIGN KEY (IPAttributeTypeID)
                             REFERENCES dbo.IPAttributeTypes

ALTER TABLE dbo.IPGroups
       ADD FOREIGN KEY (IPAddressTypeID)
                             REFERENCES dbo.IPAddressTypes

ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPAttributeID)
                             REFERENCES dbo.IPAttributes
ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPInvAllocationID)
                             REFERENCES dbo.IPInvAllocations

ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges

ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates
ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups

ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPInvAllocationID)
                             REFERENCES dbo.IPInvAllocations
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges

ALTER TABLE dbo.IPRangeAttributes
       ADD FOREIGN KEY (IPAttributeID)
                             REFERENCES dbo.IPAttributes
ALTER TABLE dbo.IPRangeAttributes
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges

ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (StatParentIPRangeID)
                             REFERENCES dbo.IPRanges
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (IPRangeTypeID)
                             REFERENCES dbo.IPRangeTypes
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES dbo.Priorities

ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers

CREATE TABLE dbo.RadPoolStates (
	AccountID int NOT NULL,
	AcctSessionID varchar (40) NULL,
	CallingStationID varchar(64) NULL,
	NASIdentifier varchar (45) NOT NULL,
	CreateDate datetime NOT NULL,
	RadPoolConfigID int NOT NULL,
	InvItemID int NOT NULL,
	OrigInvStateID int NOT NULL 
)

CREATE CLUSTERED INDEX i_RadPoolStates_FPK ON RadPoolStates
(
       AccountID,
       AcctSessionID,
       CallingStationID,
       NASIdentifier
)

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (OrigInvStateID)
                             REFERENCES dbo.InvStates

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (RadPoolConfigID)
                             REFERENCES dbo.RadPoolConfigs

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts

ALTER TABLE dbo.SendMethods ADD PrintStatement tinyint NULL
ALTER TABLE dbo.SendMethods ADD PrintInvoice tinyint NULL
ALTER TABLE dbo.SendMethods ADD EmailStatement tinyint NULL
ALTER TABLE dbo.SendMethods ADD EmailInvoice tinyint NULL
END
GO

IF COL_LENGTH('dbo.Files','SiteID') IS NULL
BEGIN
ALTER TABLE dbo.Files ADD SiteID INT
ALTER TABLE dbo.Files ADD TowerID INT
ALTER TABLE dbo.FileCategories ADD AllowSites tinyint NOT NULL DEFAULT 1
ALTER TABLE dbo.FileCategories ADD AllowTowers tinyint NOT NULL DEFAULT 1

CREATE INDEX i_Files_Sites ON dbo.Files (SiteID)
CREATE INDEX i_Files_Towers ON dbo.Files (TowerID)

ALTER TABLE dbo.Files
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites

ALTER TABLE dbo.Files
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
END
GO

IF COL_LENGTH('dbo.InvProducts','SupplierCost') IS NULL
BEGIN
ALTER TABLE dbo.InvProducts ADD SupplierCost NUMERIC(18,4)
ALTER TABLE dbo.InvItems ADD SupplierCost NUMERIC(18,4)
END
GO

IF COL_LENGTH('dbo.SubAccountDataTypes','GroupID') IS NULL
BEGIN
ALTER TABLE dbo.SubAccountDataTypes ADD GroupID INT
ALTER TABLE dbo.SubAccountDataTypes ADD ServiceCategoryID INT
ALTER TABLE dbo.SubAccountDataTypes ADD FOREIGN KEY (GroupID) REFERENCES dbo.Groups
ALTER TABLE dbo.SubAccountDataTypes ADD FOREIGN KEY (ServiceCategoryID) REFERENCES dbo.ServiceCategories

ALTER TABLE dbo.TaxSources ADD LastImportUser VARCHAR(64)
ALTER TABLE dbo.TaxSources ADD LastImportDate DATETIME

DROP INDEX dbo.SubAccountDataTypes.IX_SubAccountDataTypes
CREATE UNIQUE INDEX IX_SubAccountDataTypes ON dbo.SubAccountDataTypes (AccountTypeID,AccountDataTypeID,GroupID,ServiceCategoryID)
END
GO

IF COL_LENGTH('dbo.LateFees','Active') IS NULL
BEGIN
ALTER TABLE dbo.LateFees ADD Active tinyint NOT NULL DEFAULT 1
END
GO

IF COL_LENGTH('dbo.ServiceGroups','AllowLateFees') IS NULL
BEGIN
ALTER TABLE dbo.ServiceGroups ADD AllowLateFees tinyint NOT NULL DEFAULT 1
ALTER TABLE dbo.ServiceGroups ADD AllowMasterAccountDataTypes tinyint NOT NULL DEFAULT 1
ALTER TABLE dbo.MarketTags ADD CustomerHidden tinyint NOT NULL DEFAULT 1
DROP INDEX dbo.SignupOptions.i_SignupOptions_SS_SC_AT
CREATE UNIQUE INDEX i_SignupOptions_SS_SC_AT ON dbo.SignupOptions (SignupServerID,ServiceCategoryID,AccountTypeID,TimeChargeID,PayPeriodID)
END
GO

IF OBJECT_ID('dbo.InvAttrMaps') IS NULL
BEGIN
CREATE TABLE dbo.InvAttrMaps (
	InvAttrMapID	smallint NOT NULL,
	InvAttrMap 	varchar(128) NOT NULL,
	RegExp		varchar(1024) NULL,
        SortOrder       smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.InvAttrMaps ADD PRIMARY KEY (InvAttrMapID)
ALTER TABLE dbo.InvAttributes ADD InvAttrMapID smallint NULL
ALTER TABLE dbo.TowerAntennas ADD Sensitivity numeric(9,4) NULL
ALTER TABLE dbo.InvAttributes ADD FOREIGN KEY (InvAttrMapID) REFERENCES dbo.InvAttrMaps

CREATE INDEX i_InvAttributes_IAMID ON dbo.InvAttributes (InvAttrMapID)
END
GO

IF COL_LENGTH('dbo.Notices','MailBCC') IS NULL
BEGIN
ALTER TABLE dbo.Notices ADD MailBCC VARCHAR(128) NULL
END
GO

IF COL_LENGTH('dbo.SectionAreas','StringID') IS NULL
BEGIN
ALTER TABLE dbo.SectionAreas ADD StringID INT
ALTER TABLE dbo.SectionLocations ADD StringID INT
ALTER TABLE dbo.SMSWriteStates ADD StringID INT
END
GO

IF COL_LENGTH('dbo.AccountTypes','ServiceLevelTypeID') IS NULL
BEGIN
ALTER TABLE dbo.AccountTypes ADD ServiceLevelTypeID INT
ALTER TABLE dbo.AccountTypes ADD SecServiceLevelTypeID INT
ALTER TABLE dbo.MarketTags ADD ServiceLevelTypeID INT

ALTER TABLE dbo.AccountTypes ADD FOREIGN KEY (ServiceLevelTypeID) REFERENCES dbo.ServiceLevelTypes
ALTER TABLE dbo.AccountTypes ADD FOREIGN KEY (SecServiceLevelTypeID) REFERENCES dbo.ServiceLevelTypes
ALTER TABLE dbo.MarketTags ADD FOREIGN KEY (ServiceLevelTypeID) REFERENCES dbo.ServiceLevelTypes
END
GO

IF COL_LENGTH('dbo.WebForwarders','WebClientCertTypeID') IS NULL
BEGIN
ALTER TABLE dbo.WebForwarders ADD WebClientCertTypeID INT

CREATE TABLE dbo.WebClientCertTypes (
       WebClientCertTypeID   int NOT NULL,
       WebClientCertType    varchar(128) NOT NULL
)

ALTER TABLE dbo.WebClientCertTypes ADD PRIMARY KEY (WebClientCertTypeID)
ALTER TABLE dbo.WebForwarders ADD FOREIGN KEY (WebClientCertTypeID) REFERENCES dbo.WebClientCertTypes
END
GO

IF COL_LENGTH('dbo.Countries','NNLength') IS NULL
BEGIN
ALTER TABLE dbo.Countries ADD NNLength TINYINT
END
GO

IF COL_LENGTH('dbo.SubAccounts','ServiceQty') IS NULL
BEGIN
ALTER TABLE dbo.SubAccounts ADD ServiceQty smallint NOT NULL DEFAULT 1
ALTER TABLE dbo.InvoiceItems ADD ServiceQty smallint NOT NULL DEFAULT 1
END
GO

IF COL_LENGTH('dbo.BulkItems','SAData') IS NULL
BEGIN
ALTER TABLE dbo.BulkItems ADD MAAccountDataTypeID int NULL
ALTER TABLE dbo.BulkItems ADD MAData VARCHAR(128) NULL
ALTER TABLE dbo.BulkItems ADD SAAccountDataTypeID int NULL
ALTER TABLE dbo.BulkItems ADD SAData VARCHAR(128) NULL
ALTER TABLE dbo.BulkItems ADD FOREIGN KEY (MAAccountDataTypeID) REFERENCES dbo.AccountDataTypes
ALTER TABLE dbo.BulkItems ADD FOREIGN KEY (SAAccountDataTypeID) REFERENCES dbo.AccountDataTypes
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Addresses'),'i_Addresses_Address1','IndexID') IS NULL
BEGIN
CREATE INDEX i_Addresses_Address1 ON dbo.Addresses (Address1)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Addresses'),'i_Addresses_Company','IndexID') IS NULL
BEGIN
CREATE INDEX i_Addresses_Company ON dbo.Addresses (Company)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Addresses'),'i_Addresses_PhoneFax','IndexID') IS NULL
BEGIN
CREATE INDEX i_Addresses_PhoneFax ON dbo.Addresses (PhoneFax)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Invoices'),'i_Invoices_CreateDate','IndexID') IS NULL
BEGIN
CREATE INDEX i_Invoices_CreateDate ON dbo.Invoices (CreateDate)
END
GO

DELETE FROM ConfigValues WHERE ConfigID = 20 AND NumValue = 0
GO

IF COL_LENGTH('dbo.SMSPollers','SMPPSystemType') IS NULL
BEGIN
ALTER TABLE dbo.SMSPollers ADD SMPPSystemType VARCHAR(64) NULL
END
GO

IF OBJECT_ID('dbo.OperatorPayments') IS NULL
BEGIN
CREATE TABLE dbo.OperatorPayments (
       OperatorPaymentID    int IDENTITY,
       OperatorID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CustomerID           int NOT NULL,
       PaymentTypeID        int NOT NULL,
       InvoiceID            int NULL,
       Amount               numeric(18,4) NOT NULL,
       CheckNumber          varchar(16) NULL,
       PayInfo              varchar(64) NULL,
       ExternalRef          varchar(64) NULL
)

CREATE INDEX i_OperatorPayments_OID ON dbo.OperatorPayments (OperatorID)
CREATE INDEX i_OperatorPayments_CID ON dbo.OperatorPayments (CustomerID)

ALTER TABLE dbo.OperatorPayments
       ADD PRIMARY KEY (OperatorPaymentID)

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
END
GO

IF COL_LENGTH('dbo.BillingCycles','ExpCancelReasonID') IS NULL
BEGIN
ALTER TABLE dbo.BillingCycles ADD ExpCancelReasonID INT NULL
ALTER TABLE dbo.BillingCycles ADD FOREIGN KEY (ExpCancelReasonID) REFERENCES dbo.CancelReasons
END
GO

IF COL_LENGTH('dbo.SMSPollers','SMPPDstTON') IS NULL
BEGIN
ALTER TABLE dbo.SMSPollers ADD SMPPDstTON int NOT NULL DEFAULT 1
ALTER TABLE dbo.SMSPollers ADD SMPPDstNPI int NOT NULL DEFAULT 1
END
GO

IF COL_LENGTH('dbo.SMSWrites','Message') < 1024
BEGIN
ALTER TABLE dbo.SMSWrites ALTER COLUMN Message VARCHAR(1024) NOT NULL
END
GO

IF OBJECT_ID('dbo.BulkMessages') IS NULL
BEGIN
CREATE TABLE dbo.BulkMessages (
       BulkMessageID        int IDENTITY,
       BulkMessage          varchar(128) NOT NULL,
       NoticeFormatID       smallint NOT NULL DEFAULT 1,
       NoticeTechID         smallint NOT NULL DEFAULT 1,
       AccessLabelID        int NULL,
       MailFrom             varchar(128) NULL,
       MailSubject          varchar(128) NULL,
       Message              text NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.BulkMessages
       ADD PRIMARY KEY (BulkMessageID)

ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (NoticeFormatID)
                             REFERENCES dbo.NoticeFormats

ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (NoticeTechID)
                             REFERENCES dbo.NoticeTechs

ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
END
GO

IF COL_LENGTH('dbo.InvAttributes','ShowSearchResult') IS NULL
BEGIN
ALTER TABLE dbo.InvAttributes ADD ShowSearchResult tinyint NOT NULL DEFAULT 0
END
GO

IF OBJECT_ID('dbo.Certs') IS NULL
BEGIN
CREATE TABLE dbo.Certs (
       CertID               int IDENTITY,
       Cert                 varchar(128) NOT NULL,
       CertTypeID           int NOT NULL,
       Bits                 smallint NULL,
       PrivateKey           text NULL,
       PublicKey            text NULL,
       Comments             text NULL,
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate()
)

CREATE TABLE dbo.CertTypes (
       CertTypeID           int NOT NULL,
       CertType             varchar(128) NOT NULL,
       Description          text NULL,
       StorePrivateKey      tinyint NOT NULL,
       StorePublicKey       tinyint NOT NULL,
       ChangePrivateKey     tinyint NOT NULL,
       ChangePublicKey      tinyint NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.Certs ADD PRIMARY KEY (CertID)
ALTER TABLE dbo.CertTypes ADD PRIMARY KEY (CertTypeID)

ALTER TABLE dbo.BatchProcessors ADD CertID int NULL
ALTER TABLE dbo.CreditCards ADD CertID int NULL
ALTER TABLE dbo.CreditCards ADD CertCardNumber text NULL

ALTER TABLE dbo.Certs ADD FOREIGN KEY (CertTypeID) REFERENCES dbo.CertTypes
ALTER TABLE dbo.CreditCards ADD FOREIGN KEY (CertID) REFERENCES dbo.Certs
ALTER TABLE dbo.BatchProcessors ADD FOREIGN KEY (CertID) REFERENCES dbo.Certs
END
GO

IF OBJECT_ID('dbo.OperatorPins') IS NULL
BEGIN
CREATE TABLE dbo.OperatorPins (
       OperatorPinID        int IDENTITY,
       OperatorID           int NOT NULL,
       CustomerID           int NOT NULL,
       ExpireDate           datetime NULL,
       ActiveDate           datetime NULL,
       Tries                int NOT NULL DEFAULT 0
)

ALTER TABLE dbo.OperatorPins ADD PRIMARY KEY (OperatorPinID)

ALTER TABLE dbo.OperatorPins ADD FOREIGN KEY (OperatorID) REFERENCES dbo.Operators
ALTER TABLE dbo.OperatorPins ADD FOREIGN KEY (CustomerID) REFERENCES dbo.MasterAccounts

CREATE INDEX i_OperatorPins_OID_CID_ED ON dbo.OperatorPins (OperatorID,CustomerID,ExpireDate)
CREATE INDEX i_OperatorPins_CID ON dbo.OperatorPins (CustomerID)
END
GO

IF OBJECT_ID('dbo.FlowDirections') IS NULL
BEGIN
CREATE TABLE dbo.FlowDirections (
       FlowDirectionID    smallint NOT NULL,
       FlowDirection      varchar(128) NOT NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.FlowFilters (
       FlowFilterID       int IDENTITY,
       FlowFilter         varchar(128) NOT NULL,
       DefaultAllow       tinyint NOT NULL DEFAULT 1,
       SortOrder          smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.FlowFilterItems (
       FlowFilterItemID   int IDENTITY,
       FlowFilterItem     varchar(128) NOT NULL,
       FlowFilterID       int NOT NULL,
       FlowDirectionID    smallint NOT NULL DEFAULT 1,
       Protocol           smallint NULL,
       SrcRange           varchar(128) NULL,
       SrcPortStarting    int NULL,
       SrcPortEnding      int NULL,
       DstRange           varchar(128) NULL,
       DstPortStarting    int NULL,
       DstPortEnding      int NULL,
       ExporterRange      varchar(128) NULL
)

ALTER TABLE dbo.FlowDirections ADD PRIMARY KEY (FlowDirectionID)
ALTER TABLE dbo.FlowFilters ADD PRIMARY KEY (FlowFilterID)
ALTER TABLE dbo.FlowFilterItems ADD PRIMARY KEY (FlowFilterItemID)

ALTER TABLE dbo.Monitors ADD FlowFilterID int NULL
ALTER TABLE dbo.Monitors ADD FlowUpGaugeID int NULL
ALTER TABLE dbo.Monitors ADD FlowDownGaugeID int NULL
ALTER TABLE dbo.Monitors ADD FlowUpDownGaugeID int NULL

ALTER TABLE dbo.FlowFilterItems ADD FOREIGN KEY (FlowFilterID) REFERENCES dbo.FlowFilters
ALTER TABLE dbo.FlowFilterItems ADD FOREIGN KEY (FlowDirectionID) REFERENCES dbo.FlowDirections

ALTER TABLE dbo.Monitors ADD FOREIGN KEY (FlowUpGaugeID) REFERENCES dbo.Gauges
ALTER TABLE dbo.Monitors ADD FOREIGN KEY (FlowDownGaugeID) REFERENCES dbo.Gauges
ALTER TABLE dbo.Monitors ADD FOREIGN KEY (FlowUpDownGaugeID) REFERENCES dbo.Gauges
ALTER TABLE dbo.Monitors ADD FOREIGN KEY (FlowFilterID) REFERENCES dbo.FlowFilters
END
GO

IF OBJECT_ID('dbo.GaugeGroups') IS NULL
BEGIN
CREATE TABLE dbo.GaugeGroups (
       GaugeGroupID         int IDENTITY,
       GaugeGroup           varchar(128) NOT NULL,
       StringID             int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.GaugeGroupItems (
       GaugeGroupID        int NOT NULL,
       GaugeID             int NOT NULL,
       GaugeGroupItemID    int IDENTITY,
       IsPrimary           tinyint NOT NULL DEFAULT 0,
       Required            tinyint NOT NULL DEFAULT 0,
       LineFill            tinyint NOT NULL DEFAULT 1,
       DataLabel           varchar(128) NULL,
       Color               varchar(32) NULL
)

ALTER TABLE dbo.GaugeGroups ADD PRIMARY KEY (GaugeGroupID)
ALTER TABLE dbo.GaugeGroupItems ADD PRIMARY KEY NONCLUSTERED (GaugeGroupItemID)

ALTER TABLE dbo.Gauges ADD Color VARCHAR(32) NULL
ALTER TABLE dbo.GaugeAlerts ADD Color VARCHAR(32) NULL

ALTER TABLE dbo.GaugeGroupItems ADD FOREIGN KEY (GaugeGroupID) REFERENCES dbo.GaugeGroups
ALTER TABLE dbo.GaugeGroupItems ADD FOREIGN KEY (GaugeID) REFERENCES dbo.Gauges

CREATE UNIQUE CLUSTERED INDEX i_GaugeGroupItems_GGID_GID ON GaugeGroupItems (GaugeGroupID,GaugeID)
END
GO

IF COL_LENGTH('dbo.SignupServers','ShowStartDate') IS NULL
BEGIN
ALTER TABLE dbo.SignupServers ADD ShowStartDate tinyint NOT NULL DEFAULT 0
END
GO

IF COL_LENGTH('dbo.InvProducts','CloseInvStateID') IS NULL
BEGIN
ALTER TABLE dbo.InvProducts ADD CloseInvStateID int NULL
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_LMD','IndexID') IS NULL
BEGIN
CREATE INDEX i_Incidents_LMD ON dbo.Incidents (LastModifyDate)
END
GO

IF OBJECT_ID('dbo.CreditCardUpdates') IS NULL
BEGIN
CREATE TABLE dbo.CreditCardUpdates (
       CustomerID           int NOT NULL,
       BatchProcessorID     int NOT NULL,
       LastExported         datetime NULL,
       LastReplaced         datetime NULL,
       LastUpdated          datetime NULL,
       LastFailed           datetime NULL,
       ExpirationDate       datetime NOT NULL,
       Token                varchar(128) NULL,
       Message              varchar(255) NULL
)

ALTER TABLE dbo.CreditCardUpdates ADD PRIMARY KEY (CustomerID, BatchProcessorID)
ALTER TABLE dbo.CreditCardUpdates ADD FOREIGN KEY (CustomerID) REFERENCES dbo.MasterAccounts
ALTER TABLE dbo.CreditCardUpdates ADD FOREIGN KEY (BatchProcessorID) REFERENCES dbo.BatchProcessors
END
GO

IF COL_LENGTH('dbo.SignupServers','ShowPhoneMobile') IS NULL
BEGIN
ALTER TABLE dbo.SignupServers ADD ShowPhoneMobile tinyint NOT NULL DEFAULT 1
END
GO

DELETE FROM APIFields WHERE APIActionID = 37 AND FieldName = 'Token'
GO

IF COL_LENGTH('dbo.Files','EventID') IS NULL
BEGIN
ALTER TABLE dbo.FileCategories ADD AllowEvents TINYINT NOT NULL DEFAULT 1
ALTER TABLE dbo.Files ADD EventID INT NULL
ALTER TABLE dbo.Files ADD FOREIGN KEY (EventID) REFERENCES dbo.Events
CREATE INDEX i_Files_Events ON dbo.Files (EventID)
END
GO

IF COL_LENGTH('dbo.Charges','AllowDupe') IS NULL
BEGIN
ALTER TABLE dbo.Charges ADD AllowDupe TINYINT NOT NULL DEFAULT 1
END
GO

IF COL_LENGTH('dbo.Discounts','ChargeTypeID') IS NULL
BEGIN
ALTER TABLE dbo.Discounts ADD ChargeTypeID INT NULL
ALTER TABLE dbo.Discounts ADD FOREIGN KEY (ChargeTypeID) REFERENCES dbo.ChargeTypes
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Actions'),'i_Actions_CD','IndexID') IS NULL
BEGIN
CREATE INDEX i_Actions_CD ON dbo.Actions (CreateDate)
END
GO

IF COL_LENGTH('dbo.Reports','OrderBy') IS NULL
BEGIN
ALTER TABLE dbo.Reports ADD OrderBy VARCHAR(128) NULL
END
GO

IF COL_LENGTH('dbo.NoticeTypes','Parm1RegExp') IS NULL
BEGIN
ALTER TABLE dbo.NoticeTypes ADD Parm1RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm2RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm3RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm4RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm5RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm6RegExp VARCHAR(128) NULL
ALTER TABLE dbo.NoticeTypes ADD Parm7RegExp VARCHAR(128) NULL
END
GO

IF COL_LENGTH('dbo.RegFCC477Techs','Code477') IS NULL
BEGIN
ALTER TABLE dbo.RegFCC477Techs ADD Code477 INT NOT NULL DEFAULT 0
ALTER TABLE dbo.RegFCC477Techs ADD CodeBDC INT NOT NULL DEFAULT 0
END
GO

IF OBJECT_ID('dbo.Syncs') IS NULL
BEGIN
CREATE TABLE dbo.Syncs (
       SyncID        int IDENTITY,
       Sync          varchar(128) NOT NULL,
       Retries       smallint NULL,
       BatchLimit    int NULL,
       DateFormatID  int NULL,
       TimeFormatID  smallint NULL,
       DateSeparator char(1) NULL,
       Decrypt       tinyint NOT NULL DEFAULT 0,
       Active        tinyint NOT NULL DEFAULT 1,
       SortOrder     smallint NOT NULL DEFAULT 0,
       AddURL        varchar(255) NULL,
       UpdateURL     varchar(255) NULL,
       DeleteURL     varchar(255) NULL,
       KeyColumn     varchar(32) NOT NULL,
       Login         varchar(64) NULL,
       Password      varchar(200) NULL,
       SQLQuery      text NOT NULL,
       Comments      text NULL 
)

CREATE TABLE dbo.SyncLocks (
       SyncID        int NOT NULL,
       RefCount      int NOT NULL DEFAULT 0
)

CREATE TABLE dbo.SyncActives (
       SyncID        int NOT NULL,
       Token         varchar(64) NOT NULL,
       Checksum      bigint NOT NULL,
       Retries       int NOT NULL DEFAULT 0,
       CreateDate    datetime NOT NULL DEFAULT getdate(),
       LastModifyDate datetime NULL,
       Message       varchar(128) NULL
)

CREATE TABLE dbo.SyncExamples (
       SyncExampleID int NOT NULL,
       SyncExample   varchar(128) NOT NULL,
       KeyColumn     varchar (32) NOT NULL,
       SQLQuery      text NOT NULL,
       Comments      text NULL,
       Decrypt       tinyint NOT NULL DEFAULT 0,
       FeatureID     int NULL
)

ALTER TABLE dbo.Syncs ADD PRIMARY KEY (SyncID)
ALTER TABLE dbo.SyncLocks ADD PRIMARY KEY (SyncID)
ALTER TABLE dbo.SyncActives ADD PRIMARY KEY (SyncID,Token)
ALTER TABLE dbo.SyncExamples ADD PRIMARY KEY (SyncExampleID)
ALTER TABLE dbo.SyncLocks ADD FOREIGN KEY (SyncID) REFERENCES dbo.Syncs
ALTER TABLE dbo.SyncActives ADD FOREIGN KEY (SyncID) REFERENCES dbo.Syncs
END
GO

IF COL_LENGTH('dbo.IEALocks','LastModifyDate') IS NULL
BEGIN
ALTER TABLE dbo.IEALocks ADD LastModifyDate DATETIME NOT NULL DEFAULT getdate()
ALTER TABLE dbo.IEALocks ADD IPAddress VARCHAR(64) NULL
END
GO

IF COL_LENGTH('dbo.MasterAccounts','BillMonth') IS NULL
BEGIN
ALTER TABLE dbo.MasterAccounts ADD BillMonth TINYINT NULL
ALTER TABLE dbo.BillingCycles ADD BillMonth TINYINT NULL
END
GO

IF COL_LENGTH('dbo.TaxRates','TaxTypeID') IS NULL
BEGIN
ALTER TABLE dbo.TaxRates ADD TaxTypeID INT NULL
ALTER TABLE dbo.TaxRates ADD StartDate DATETIME NULL
ALTER TABLE dbo.TaxRates ADD FOREIGN KEY (TaxTypeID) REFERENCES dbo.TaxTypes
END
GO

IF COL_LENGTH('dbo.MetaTables','LabelTable') IS NULL
BEGIN
ALTER TABLE dbo.MetaTables ADD LabelTable VARCHAR(32) NULL
ALTER TABLE dbo.AccountDataTypes ADD AccessLabelID INT NULL
ALTER TABLE dbo.AddressDataTypes ADD AccessLabelID INT NULL
ALTER TABLE dbo.IncidentDataTypes ADD AccessLabelID INT NULL
ALTER TABLE dbo.AccountDataTypes ADD FOREIGN KEY (AccessLabelID) REFERENCES dbo.AccessLabels
ALTER TABLE dbo.AddressDataTypes ADD FOREIGN KEY (AccessLabelID) REFERENCES dbo.AccessLabels
ALTER TABLE dbo.IncidentDataTypes ADD FOREIGN KEY (AccessLabelID) REFERENCES dbo.AccessLabels
END
GO

IF OBJECT_ID('dbo.IncidentTypeFileCategories') IS NULL
BEGIN
CREATE TABLE dbo.IncidentTypeFileCategories (
       IncidentTypeID       int NOT NULL,
       FileCategoryID       int NOT NULL
)

ALTER TABLE dbo.IncidentTypeFileCategories ADD PRIMARY KEY (IncidentTypeID, FileCategoryID)
ALTER TABLE dbo.IncidentTypeFileCategories ADD FOREIGN KEY (IncidentTypeID) REFERENCES dbo.IncidentTypes
ALTER TABLE dbo.IncidentTypeFileCategories ADD FOREIGN KEY (FileCategoryID) REFERENCES dbo.FileCategories
END
GO

IF OBJECT_ID('dbo.SearchFieldGroups') IS NULL
BEGIN
CREATE TABLE dbo.SearchFieldGroups (
       SearchFieldGroupID int NOT NULL,
       SearchFieldGroup   varchar(128) NOT NULL,
       StringID           int NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.SearchFields (
       SearchFieldID      int NOT NULL,
       SearchField        varchar(128) NOT NULL,
       StringID           int NULL,
       SearchFieldGroupID int NOT NULL,
       FormEWS            text NULL,
       SelectEWS          text NULL,
       JoinEWS            text NULL,
       FilterEWS          text NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.SearchConditions (
       SearchConditionID      int NOT NULL,
       SearchCondition        varchar(128) NOT NULL,
       StringID               int NULL
)

CREATE TABLE dbo.Searches (
       SearchID       int IDENTITY,
       Search         varchar(128) NOT NULL,
       OperatorID     int NOT NULL,
       SortOrder      smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.SearchItems (
       SearchItemID       int IDENTITY,
       SearchID           int NOT NULL,
       SearchFieldID      int NOT NULL,
       AccountDataTypeID  int NULL,
       AddressDataTypeID  int NULL,
       SearchConditionID  int NULL,
       ApplyMask          int NOT NULL,
       DefaultData        varchar(512),
       SortOrder          smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.SearchFieldGroups ADD PRIMARY KEY (SearchFieldGroupID)
ALTER TABLE dbo.SearchFields ADD PRIMARY KEY (SearchFieldID)
ALTER TABLE dbo.SearchConditions ADD PRIMARY KEY (SearchConditionID)
ALTER TABLE dbo.Searches ADD PRIMARY KEY (SearchID)
ALTER TABLE dbo.SearchItems ADD PRIMARY KEY NONCLUSTERED (SearchItemID)
CREATE CLUSTERED INDEX I_SearchItems_SID ON dbo.SearchItems (SearchID)
ALTER TABLE dbo.SearchFields ADD FOREIGN KEY (SearchFieldGroupID) REFERENCES dbo.SearchFieldGroups
ALTER TABLE dbo.SearchItems ADD FOREIGN KEY (SearchID) REFERENCES dbo.Searches
ALTER TABLE dbo.SearchItems ADD FOREIGN KEY (AccountDataTypeID) REFERENCES dbo.AccountDataTypes
ALTER TABLE dbo.SearchItems ADD FOREIGN KEY (AddressDataTypeID) REFERENCES dbo.AddressDataTypes
ALTER TABLE dbo.SearchItems ADD FOREIGN KEY (SearchConditionID) REFERENCES dbo.SearchConditions
ALTER TABLE dbo.SearchItems ADD FOREIGN KEY (SearchFieldID) REFERENCES dbo.SearchFields
ALTER TABLE dbo.RegFCC477AccountTypes ADD VoiceInternet tinyint NOT NULL DEFAULT 1
END
GO

IF COL_LENGTH('dbo.TowerAntennas','ChannelWidth') IS NULL
BEGIN
ALTER TABLE dbo.TowerAntennas ADD ChannelWidth numeric(9,2) NULL
END
GO

IF COL_LENGTH('dbo.SearchFields','AccessLabelID') IS NULL
BEGIN
ALTER TABLE dbo.SearchFields ADD AccessLabelID  int NULL
ALTER TABLE dbo.SearchFields ADD FOREIGN KEY (AccessLabelID) REFERENCES dbo.AccessLabels
END
GO

IF COL_LENGTH('dbo.Schedules','Retries') IS NULL
BEGIN
ALTER TABLE dbo.Schedules ADD Retries int NOT NULL DEFAULT 0
END
GO

IF COL_LENGTH('dbo.AccountTypes','NewCost') IS NULL
BEGIN
ALTER TABLE dbo.AccountTypes ADD NewCost NUMERIC(18,4)
ALTER TABLE dbo.AccountTypes ADD NewCostDate DATETIME
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_CreateOperatorID','IndexID') IS NOT NULL
BEGIN
DROP INDEX dbo.Incidents.i_Incidents_CreateOperatorID
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_COID_ISID','IndexID') IS NULL
BEGIN
CREATE INDEX i_Incidents_COID_ISID ON dbo.Incidents (CreateOperatorID,IncidentStateID)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_AssignRoleID','IndexID') IS NOT NULL
BEGIN
DROP INDEX dbo.Incidents.i_Incidents_AssignRoleID
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_ARID_ISID','IndexID') IS NULL
BEGIN
CREATE INDEX i_Incidents_ARID_ISID ON dbo.Incidents (AssignRoleID,IncidentStateID)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_AssignOperatorID','IndexID') IS NOT NULL
BEGIN
DROP INDEX dbo.Incidents.i_Incidents_AssignOperatorID
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Incidents'),'i_Incidents_AOID_ISID','IndexID') IS NULL
BEGIN
CREATE INDEX i_Incidents_AOID_ISID ON dbo.Incidents (AssignOperatorID,IncidentStateID)
END
GO

IF OBJECT_ID('dbo.PIIRetentions') IS NULL
BEGIN
CREATE TABLE dbo.PIIRetentions (
       PIIRetentionID       int IDENTITY,
       PIIRetention         varchar(128) NOT NULL,
       FieldMask            int NOT NULL DEFAULT 0,
       OrganizationID       int NULL,
       GroupID              int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       InactiveDays         int NULL,
       DeletedDays          int NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1
)

CREATE TABLE dbo.PIIFields (
       PIIFieldID           int IDENTITY,
       PIIRetentionID       int NOT NULL,
       AddressDataTypeID    int NULL,
       AccountDataTypeID    int NULL,
       IncidentDataTypeID   int NULL,
       IncidentTypeID       int NULL
)

ALTER TABLE dbo.PIIRetentions ADD PRIMARY KEY (PIIRetentionID)
ALTER TABLE dbo.PIIFields ADD PRIMARY KEY (PIIFieldID)

ALTER TABLE dbo.PIIRetentions ADD FOREIGN KEY (OrganizationID) REFERENCES dbo.Organizations
ALTER TABLE dbo.PIIRetentions ADD FOREIGN KEY (GroupID) REFERENCES dbo.Groups
ALTER TABLE dbo.PIIRetentions ADD FOREIGN KEY (CountryID) REFERENCES dbo.Countries
ALTER TABLE dbo.PIIRetentions ADD FOREIGN KEY (StateID) REFERENCES dbo.States

ALTER TABLE dbo.PIIFields ADD FOREIGN KEY (PIIRetentionID) REFERENCES dbo.PIIRetentions
ALTER TABLE dbo.PIIFields ADD FOREIGN KEY (AddressDataTypeID) REFERENCES dbo.AddressDataTypes
ALTER TABLE dbo.PIIFields ADD FOREIGN KEY (AccountDataTypeID) REFERENCES dbo.AccountDataTypes
ALTER TABLE dbo.PIIFields ADD FOREIGN KEY (IncidentDataTypeID) REFERENCES dbo.IncidentDataTypes
ALTER TABLE dbo.PIIFields ADD FOREIGN KEY (IncidentTypeID) REFERENCES dbo.IncidentTypes
END
GO

IF COL_LENGTH('dbo.MarketTags','CreatedBefore') IS NULL
BEGIN
ALTER TABLE dbo.MarketTags ADD CreatedBefore DATETIME NULL
ALTER TABLE dbo.MarketTags ADD CreatedAfter DATETIME NULL
END
GO

IF OBJECT_ID('dbo.RegFCCBLProviders') IS NULL
BEGIN
CREATE TABLE dbo.RegFCCBLProviders (
       RegFCCBLProviderID      int IDENTITY,
       RegFCCBLProvider        varchar(128) NOT NULL,
       RegistrationNumber      varchar(32) NOT NULL,
       DataAllowancePolicyURL  varchar(255) NULL,
       NetworkManagementPolicyURL varchar(255) NOT NULL,
       PrivacyPolicyURL        varchar(255) NOT NULL,
       CustomerSupportPhone    varchar(32) NOT NULL,
       CustomerSupportURL      varchar(255) NOT NULL,
       BundleDescription       text NULL,
       BundleStringID          int NULL,
       BundleDiscountsURL      varchar(255) NULL,
       SortOrder               smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.RegFCCBLContracts (
       RegFCCBLContractID      int IDENTITY,
       RegFCCBLContract        varchar(128) NOT NULL,
       ContractRequired        tinyint NOT NULL DEFAULT 0,
       ContractMonths	       int NOT NULL,
       EarlyTerminationFee     numeric(18,4) NULL,
       ContractTermsURL        varchar(255) NULL,
       SortOrder               smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.RegFCCBLCharges (
       RegFCCBLChargeID      int IDENTITY,
       RegFCCBLCharge        varchar(128) NOT NULL,
       SortOrder             smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.RegFCCBLChargeItems (
       RegFCCBLChargeItemID      int IDENTITY,
       RegFCCBLChargeID          int NOT NULL,
       RegFCCBLChargeItem        varchar(128) NULL,
       StringID                  int NULL,
       Recurring                 tinyint NOT NULL DEFAULT 0,
       AccountTypeID             int NULL,
       ChargeTypeID              int NULL,
       Cost                      numeric(18,4) NULL,
       SortOrder                 smallint NOT NULL DEFAULT 0
)

CREATE TABLE dbo.RegFCCBLAccountTypes (
       OrganizationID             int NOT NULL,
       AccountTypeID              int NOT NULL,
       RegFCCBLProviderID         int NULL,
       RegFCCBLContractID         int NULL,
       RegFCCBLChargeID           int NULL,
       TypicalDownMbps            numeric(9,3) NOT NULL DEFAULT 0,
       TypicalUpMbps              numeric(9,3) NOT NULL DEFAULT 0,
       TypicalLatency             int NOT NULL DEFAULT 0,
       IntroRateMonths            int NULL,
       IntroRateCost              numeric(18,4) NULL,
       TaxAmount                  numeric(18,4) NULL,
       MonthlyDataLimit           numeric(9,3) NULL,
       AdditionalDataCost         numeric(18,4) NULL,
       AdditionalDataIncrement    numeric(9,3) NULL,
       CreateDate                 datetime NOT NULL DEFAULT getdate(),
       CreateUser                 varchar(64) NOT NULL DEFAULT suser_name()
)

ALTER TABLE dbo.RegFCCBLProviders ADD PRIMARY KEY (RegFCCBLProviderID)
ALTER TABLE dbo.RegFCCBLContracts ADD PRIMARY KEY (RegFCCBLContractID)
ALTER TABLE dbo.RegFCCBLCharges ADD PRIMARY KEY (RegFCCBLChargeID)
ALTER TABLE dbo.RegFCCBLChargeItems ADD PRIMARY KEY (RegFCCBLChargeItemID)
ALTER TABLE dbo.RegFCCBLAccountTypes ADD PRIMARY KEY (OrganizationID, AccountTypeID)

ALTER TABLE dbo.RegFCCBLChargeItems ADD FOREIGN KEY (RegFCCBLChargeID) REFERENCES dbo.RegFCCBLCharges
ALTER TABLE dbo.RegFCCBLChargeItems ADD FOREIGN KEY (AccountTypeID) REFERENCES dbo.AccountTypes
ALTER TABLE dbo.RegFCCBLChargeItems ADD FOREIGN KEY (ChargeTypeID) REFERENCES dbo.ChargeTypes
ALTER TABLE dbo.RegFCCBLAccountTypes ADD FOREIGN KEY (OrganizationID) REFERENCES dbo.Organizations
ALTER TABLE dbo.RegFCCBLAccountTypes ADD FOREIGN KEY (AccountTypeID) REFERENCES dbo.AccountTypes
ALTER TABLE dbo.RegFCCBLAccountTypes ADD FOREIGN KEY (RegFCCBLProviderID) REFERENCES dbo.RegFCCBLProviders
ALTER TABLE dbo.RegFCCBLAccountTypes ADD FOREIGN KEY (RegFCCBLContractID) REFERENCES dbo.RegFCCBLContracts
ALTER TABLE dbo.RegFCCBLAccountTypes ADD FOREIGN KEY (RegFCCBLChargeID) REFERENCES dbo.RegFCCBLCharges

CREATE INDEX i_RegFCCBLChargeItems_CID ON dbo.RegFCCBLChargeItems (RegFCCBLChargeID)
DELETE FROM MenuSets WHERE MenuItemID = 330
END
GO

IF COL_LENGTH('dbo.Roles','Email') IS NULL
BEGIN
ALTER TABLE dbo.Roles ADD Email VARCHAR(80) NULL
END
GO

IF COL_LENGTH('dbo.Operators','PasswordChange') IS NULL
BEGIN
ALTER TABLE dbo.Operators ADD PasswordChange tinyint NOT NULL DEFAULT 0
END
GO

IF OBJECT_ID('dbo.RegionGroups') IS NULL
BEGIN
CREATE TABLE dbo.RegionGroups (
       RegionGroupID        int IDENTITY,
       RegionGroup          varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.RegionGroups ADD PRIMARY KEY (RegionGroupID)
ALTER TABLE dbo.Regions ADD RegionGroupID  INT NULL
ALTER TABLE dbo.Regions ADD ExternalRef VARCHAR(64) NULL
ALTER TABLE dbo.Regions ADD FOREIGN KEY (RegionGroupID) REFERENCES dbo.RegionGroups
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.MasterAccounts'),'i_MasterAccounts_CreateDate','IndexID') IS NULL
BEGIN
CREATE INDEX i_MasterAccounts_CreateDate ON dbo.MasterAccounts (CreateDate)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.SubAccounts'),'i_SubAccounts_CreateDate','IndexID') IS NULL
BEGIN
CREATE INDEX i_SubAccounts_CreateDate ON dbo.SubAccounts (CreateDate)
END
GO

IF COL_LENGTH('dbo.RegFCCBLChargeItems','DiscountID') IS NULL
BEGIN
ALTER TABLE dbo.RegFCCBLChargeItems ADD DiscountID INT NULL
ALTER TABLE dbo.RegFCCBLChargeItems ADD FOREIGN KEY (DiscountID) REFERENCES dbo.Discounts
END
GO

IF COL_LENGTH('dbo.Schedules','LockDate') IS NULL
BEGIN
ALTER TABLE dbo.Schedules ADD LockDate DATETIME NULL
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.Schedules'),'i_Schedules_Active','IndexID') IS NULL
BEGIN
UPDATE Schedules SET Active = 0 WHERE Active = 1 AND Interval = 0 AND Status IN (2,3)
CREATE INDEX i_Schedules_Active ON dbo.Schedules (Active)
END
GO

IF COL_LENGTH('dbo.RadConfigs','Parent') IS NULL
BEGIN
ALTER TABLE dbo.RadConfigs ADD Parent tinyint NOT NULL DEFAULT 0
ALTER TABLE dbo.RadInvConfigs ADD Parent tinyint NOT NULL DEFAULT 0
ALTER TABLE dbo.MarketTagAttributes ADD Parent tinyint NOT NULL DEFAULT 0
END
GO

UPDATE Schedules SET Interval = 172800 WHERE Interval = 173274
UPDATE Schedules SET Interval = 604800 WHERE Interval = 606461
UPDATE Schedules SET Interval = 1209600 WHERE Interval = 1314000
UPDATE Schedules SET Interval = 2592000 WHERE Interval = 2628000
UPDATE Schedules SET Interval = 5184000 WHERE Interval = 5256000
UPDATE Schedules SET Interval = 7776000 WHERE Interval = 7884000
UPDATE Schedules SET Interval = 15811200 WHERE Interval = 15768000

UPDATE ScheduleIntervals SET Seconds = 172800 WHERE Seconds = 173274
UPDATE ScheduleIntervals SET Seconds = 604800 WHERE Seconds = 606461
UPDATE ScheduleIntervals SET Seconds = 1209600 WHERE Seconds = 1314000
UPDATE ScheduleIntervals SET Seconds = 2592000 WHERE Seconds = 2628000
UPDATE ScheduleIntervals SET Seconds = 5184000 WHERE Seconds = 5256000
UPDATE ScheduleIntervals SET Seconds = 7776000 WHERE Seconds = 7884000
UPDATE ScheduleIntervals SET Seconds = 15811200 WHERE Seconds = 15768000
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.MasterAccountData'),'i_MasterAccountData_Data_ADTID','IndexID') IS NULL
BEGIN
CREATE INDEX i_MasterAccountData_Data_ADTID ON dbo.MasterAccountData (Data,AccountDataTypeID)
END
GO

IF INDEXPROPERTY(OBJECT_ID('dbo.SubAccountData'),'i_SubAccountData_Data_ADTID','IndexID') IS NULL
BEGIN
CREATE INDEX i_SubAccountData_Data_ADTID ON dbo.SubAccountData (Data,AccountDataTypeID)
END
GO

