SET IDENTITY_INSERT CallStarts ON

INSERT INTO CallStarts (CallStartID,Username,AcctSessionID,NASIdentifier,NASPort,TimeRef,CallDate,AcctDelayTime,AccountID,ServerID,CallingStationID,CalledStationID,
NASPortType,AcctStatusType,FramedIPAddress,ConnectInfo)

SELECT CallID,Username,AcctSessionID,NASIdentifier,NASPort,0,CallDate,CASE WHEN AcctDelayTime IS NULL OR AcctDelayTime > 32767 THEN 0 ELSE AcctDelayTime END,AccountID,ServerID,CallerID,NASPortDNIS,NASPortType,AcctStatusType,FramedAddress,ConnectInfo
FROM Emerald..Calls c
	WHERE AcctStatusType=2
	AND CallDate BETWEEN DATEADD(dd,-($day),$getdate) AND DATEADD(ss,-1,DATEADD(dd,-($day-1),$getdate))

SET IDENTITY_INSERT CallStarts OFF

INSERT INTO CallStops (CallStartID,CallSessionTime,AcctDelayTime,AcctSessionTime,AcctInputOctets,AcctOutputOctets,AcctTerminateCause)
SELECT c.CallID,c.AcctSessionTime,CASE WHEN c.AcctDelayTime IS NULL OR c.AcctDelayTime > 32767 THEN 0 ELSE c.AcctDelayTime END,c.AcctSessionTime,c.AcctInputOctets,c.AcctOutputOctets,c.AcctTerminateCause
FROM Emerald..Calls c JOIN CallStarts cs ON (c.CallID = cs.CallStartID)
	WHERE c.AcctStatusType=2
	AND c.CallDate BETWEEN DATEADD(dd,-($day),$getdate) AND DATEADD(ss,-1,DATEADD(dd,-($day-1),$getdate))

INSERT INTO CallInterims (CallStartID,AcctSessionTime,AcctInputOctets,AcctOutputOctets)
SELECT c.CallID,c.AcctSessionTime,c.AcctInputOctets,c.AcctOutputOctets
FROM Emerald..Calls c JOIN CallStarts cs ON (c.CallID = cs.CallStartID)
	WHERE c.AcctStatusType=2
	AND c.CallDate BETWEEN DATEADD(dd,-($day),$getdate) AND DATEADD(ss,-1,DATEADD(dd,-($day-1),$getdate))

UPDATE RateStatusCalls SET LastCallInterimID=(SELECT MAX(CallInterimID) FROM CallInterims) WHERE $day=0
GO

