-- Convert Emerald 5 database to Emerald 6
-- Assumes current version of Emerald 5 and new Empty Emerald 6 database
-- codetabs.sql must be run following this script
-- RateTimeLeft is used to temporarily convey package information

IF ((SELECT COALESCE(MAX(NumValue),0) FROM Emerald..Configs WHERE ConfigID = 0) < 5073)
BEGIN
RAISERROR('Emerald 5.0.73 or later is required to upgrade to version 6.  Please upgrade current version of Emerald 5 and try again.',11,1)
END
GO

IF ((SELECT COALESCE(MAX(NumValue),0) FROM Emerald..Configs WHERE ConfigID = 0) >= 6000)
BEGIN
RAISERROR('Source database is already an Emerald version 6 database.  Please select an Emerald version 5 database to upgrade from and try again.',11,1)
END
GO

IF ((SELECT COUNT(*) FROM MasterAccounts) > 0)
BEGIN
RAISERROR('Database upgrade cannot run against an existing non-empty database.  Create a new Emerald 6 database and try again.',11,1)
END
GO

UPDATE InvProducts SET ChargeTypeID = NULL WHERE ChargeTypeID IS NOT NULL
GO
UPDATE MarketTags SET ChargeTypeID = NULL, CancelChargeTypeID = NULL WHERE ChargeTypeID IS NOT NULL OR CancelChargeTypeID IS NOT NULL
GO
DELETE FROM FileCategoryReqs
GO
DELETE FROM InvAccountTypes
GO
DELETE FROM RefStates
GO
DELETE FROM RefManagers
GO
DELETE FROM RegFCC477AccountTypes
GO
DELETE FROM SectionAccountTypes
GO
DELETE FROM SectionGroups
GO
DELETE FROM SectionOperatorGroups
GO
DELETE FROM TrustedFiles WHERE OperatorGroupID <> 1
GO
UPDATE Events SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
UPDATE AddressGeoSources SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
DELETE FROM BulkItems WHERE GroupID IS NOT NULL
GO
UPDATE Geocoders SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
UPDATE InvProducts SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
UPDATE MarketTags SET GroupID = NULL, ServiceGroupID = NULL WHERE GroupID IS NOT NULL OR ServiceGroupID IS NOT NULL
GO
UPDATE PayPlans SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
UPDATE PromoCodes SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
UPDATE WebLinkTypes SET GroupID = NULL WHERE GroupID IS NOT NULL
GO

DELETE FROM SignupOptions
GO
DELETE FROM SignupServers
GO
DELETE FROM MarketTags WHERE MarketCategoryID IN (SELECT MarketCategoryID FROM MarketCategories WHERE MarketCategory IN ('Emerald5','Emerald5 - Discounts','Emerald5 - Pay Periods'))
GO
DELETE FROM MarketCategories WHERE MarketCategory IN ('Emerald5','Emerald5 - Discounts','Emerald5 - Pay Periods')
GO
DELETE FROM VoiceCalls
GO
DELETE FROM CardAccounts
GO

DELETE FROM ServerPorts
GO
DELETE FROM CallInterims
GO
DELETE FROM CallStops
GO
DELETE FROM CallStarts
GO

DELETE FROM NoticeActives
GO
DELETE FROM AuditLogs
GO
DELETE FROM CommissionItems
GO
DELETE FROM RateItems
GO
DELETE FROM OrgAccountTypes
GO
DELETE FROM ObjectGroups WHERE ObjectGroupID >= 10000
GO
DELETE FROM CardBatches
GO
DELETE FROM CardBatchTypes
GO
DELETE FROM ServiceCatLinks
GO
DELETE FROM ServiceCatAccountTypes
GO
DELETE FROM ServiceCategories
GO
DELETE FROM BatchProcessors
GO
DELETE FROM SubAccountDataTypes
GO
DELETE FROM ServerAccess
GO
DELETE FROM RateStdItems
GO
DELETE FROM RateStdGroups
GO
DELETE FROM Rates
GO
DELETE FROM RadRoamDomains
GO
DELETE FROM RadConcurrency
GO
DELETE FROM RadATConfigs
GO
DELETE FROM OperatorRoles
GO
DELETE FROM ExternalSystemAccountTypes
GO
DELETE FROM ServiceGroupItems
GO
DELETE FROM RadRejects
GO
DELETE FROM RadRejectAttributes
GO
DELETE FROM MasterAccountDataTypes
GO
DELETE FROM ExternalSystemDataTypes WHERE ExternalSystemTypeID >= 10000
GO
DELETE FROM Discounts
GO
DELETE FROM ConfigOperatorGroupData
GO
DELETE FROM ConfigGroupData
GO
DELETE FROM SendMethods
GO
DELETE FROM RateVRates
GO
DELETE FROM RateVDNISItems
GO
DELETE FROM RateVDNISGroupItems
GO
DELETE FROM RateVCondItems
GO
DELETE FROM RateVCondGroups
GO
DELETE FROM RateVDNIS
GO
DELETE FROM RateRules
GO
DELETE FROM RateVDNISGroups
GO
DELETE FROM RateDataSources WHERE RateDataSourceID >= 10000
GO
DELETE FROM RateIntervals
GO
DELETE FROM RadLogs
GO
DELETE FROM RadFilters
GO
DELETE FROM RadFilterGroups
GO
DELETE FROM Notices
GO
DELETE FROM ExternalSystems
GO
DELETE FROM BillingCycles
GO
DELETE FROM WebLinks
GO
DELETE FROM WebLinkTypes
GO
DELETE FROM SysLogs
GO
DELETE FROM Servers
GO
DELETE FROM ServerGroups
GO
DELETE FROM RateTimes
GO
DELETE FROM RateTimeGroups
GO
DELETE FROM RateSourceAttributes WHERE RateSourceID >= 10000
GO
DELETE FROM RateSources WHERE RateSourceID >= 10000
GO
DELETE FROM RadProxyRateProcs
GO
DELETE FROM RadProxyAttributes
GO
DELETE FROM RadProxyAttributeGroups
GO
DELETE FROM RadRoamServers
GO
DELETE FROM RadMapValues
GO
DELETE FROM RadMapAttributes
GO
DELETE FROM RadMapTypes
GO
DELETE FROM ReferredBys
GO
DELETE FROM RateIPProtocols
GO
DELETE FROM RateIPPorts
GO
DELETE FROM PosixAccountServers
GO
DELETE FROM NoticeTypes
GO
UPDATE AccountTypes SET PayPeriodID = NULL WHERE PayPeriodID IS NOT NULL
GO
DELETE FROM PayPeriods
GO
DELETE FROM AccountTypeTemplates
GO
DELETE FROM TimeCharges
GO
DELETE FROM InvAccountTypes WHERE InvProductID IN (SELECT InvProductID FROM InvProducts WHERE InvCategoryID IN (SELECT InvCategoryID FROM InvCategories WHERE InvCategory = 'Emerald5 - IP Groups'))
GO
DELETE FROM InvItems WHERE InvProductID IN (SELECT InvProductID FROM InvProducts WHERE InvCategoryID IN (SELECT InvCategoryID FROM InvCategories WHERE InvCategory = 'Emerald5 - IP Groups'))
GO
DELETE FROM InvProducts WHERE InvCategoryID IN (SELECT InvCategoryID FROM InvCategories WHERE InvCategory = 'Emerald5 - IP Groups')
GO
DELETE FROM InvCategories WHERE InvCategory = 'Emerald5 - IP Groups'
GO
DELETE FROM AccountTypes
GO
DELETE FROM RateClasses
GO
DELETE FROM PaymentTypes
GO
DELETE FROM LDAPServers
GO
DELETE FROM LateFeeDays
GO
DELETE FROM LateFees
GO
DELETE FROM Priorities
GO
DELETE FROM ChargeTypes
GO
DELETE FROM TaxGroupTaxes
GO
DELETE FROM Regions
GO
DELETE FROM TaxGroups
GO
DELETE FROM TaxExemptions
GO
DELETE FROM Taxes
GO
DELETE FROM TaxPiggyBacks
GO
DELETE FROM TaxTypes
GO
DELETE FROM IncidentValues
GO
DELETE FROM IncidentDataTypes
GO
DELETE FROM IncidentTypes
GO
DELETE FROM Roles
GO
DELETE FROM IncidentTemplates WHERE IncidentTemplateID >= 10000
GO
DELETE FROM IncidentStates
GO
DELETE FROM IncidentStateGroups
GO
DELETE FROM GLCodes
GO
DELETE FROM ExternalSystemTypes WHERE ExternalSystemTypeID >= 10000
GO
DELETE FROM AccountDataValues WHERE AccountDataTypeID >= 10000
GO
DELETE FROM Strings WHERE (StringID >= 100000 OR LanguageID >= 10000)
GO
DELETE FROM CCImportColumns WHERE ExportID >= 10000
GO
DELETE FROM ExportColumns WHERE ExportID >= 10000
GO
DELETE FROM Exports WHERE ExportID >= 10000
GO
DELETE FROM DNISNumbers
GO
DELETE FROM DNISGroups
GO
DELETE FROM SalesPersons
GO
DELETE FROM InfoBarOperators
GO
DELETE FROM SectionOperators
GO
DELETE FROM OperatorSchedTimes
GO
DELETE FROM OperatorScheds
GO
DELETE FROM AuditTableInserts
GO
DELETE FROM AuditTableUpdates
GO
DELETE FROM AuditTables
GO
DELETE FROM AuditTrans
GO
DELETE FROM OperatorGroupAccess
GO
DELETE FROM APITokens
GO
DELETE FROM ClientCerts
GO
DELETE FROM Dashes
GO
DELETE FROM Operators
GO
DELETE FROM Languages WHERE LanguageID >= 10000
GO
DELETE FROM CommissionGroups
GO
DELETE FROM CardDigits
GO
DELETE FROM CancelReasons
GO
DELETE FROM Batches
GO
UPDATE Domains SET GroupID = NULL WHERE GroupID IS NOT NULL
GO
DELETE FROM Groups
GO
DELETE FROM Domains
GO
DELETE FROM ServiceGroups
GO
DELETE FROM ThemeFilters
GO
DELETE FROM Themes
GO
DELETE FROM Organizations
GO
DELETE FROM Currencies
GO
DELETE FROM LocPhones
GO
DELETE FROM LocZipCodes
GO
DELETE FROM States
GO
DELETE FROM Countries
GO
DELETE FROM Continents
GO
DELETE FROM AllowedHosts
GO
DELETE FROM OperatorGroups WHERE OperatorGroupID <> 1
GO
DELETE FROM AddressSyncs
GO
DELETE FROM AddressData
GO
UPDATE Sites SET ContactAddressID = NULL, PhysicalAddressID = NULL
GO
DELETE FROM Addresses WHERE CustomerID IS NULL AND AccountID IS NULL
GO
DELETE FROM AddressTypes
GO

DELETE FROM AccountTemplates WHERE AccountTemplateID >= 10000
GO

CREATE INDEX i_Upgrade_RTL ON dbo.SubAccounts (RateTimeLeft,AccountID)
GO

-- RateStatusCalls
IF ((SELECT COUNT(*) FROM RateStatusCalls) = 0)
BEGIN
INSERT INTO RateStatusCalls(LastCallInterimID,Leader,LastUpdate,LastMessage,Advisor,LastAdviceDate)
VALUES(0,NULL,getdate(),NULL,NULL,getdate())
END
GO

-- AccountTemplates
INSERT INTO AccountTemplates (AccountTemplate,AccountTemplateID,CustEdit,CustEditLabel,CustEditStringID,CustNew,CustSave,SADetail,SAEdit,SANew,SASave,SignupBillSave,SignupForm,SignupPage,SignupSave,SignupValidate,SortOrder)
SELECT AccountTemplate,AccountTemplateID,CustEdit,CustEditLabel,CustEditStringID,CustNew,CustSave,SADetail,SAEdit,SANew,SASave,SignupBillSave,SignupForm,SignupPage,SignupSave,SignupValidate,SortOrder 
FROM Emerald..AccountTemplates
	WHERE AccountTemplateID >= 10000
GO

-- AddressTypes
SET IDENTITY_INSERT AddressTypes ON
INSERT INTO AddressTypes (AddressType,AddressTypeID,RequiredFields,SortOrder,ServicePriority,ShippingPriority)
SELECT AddressType,AddressTypeID,RequiredFields,CASE WHEN SortOrder IS NULL OR SortOrder > 32767 THEN 0 ELSE SortOrder END,CASE WHEN AddressType IN ('Service','Service Address') THEN 100 ELSE 0 END, CASE WHEN AddressType IN ('Shipping','Shipping Address') THEN 100 ELSE 0 END
FROM Emerald..AddressTypes
SET IDENTITY_INSERT AddressTypes OFF
GO

INSERT INTO AddressTypes (AddressType,RequiredFields,SortOrder,AllowMBR,AllowSA,AllowAdmin,BillingPriority,ShippingPriority,ContactPriority,ServicePriority)
VALUES('Emerald5 - Billing Address','FirstName,LastName',0,1,0,0,100,10,10,10)
INSERT INTO AddressTypes (AddressType,RequiredFields,SortOrder,AllowMBR,AllowSA,AllowAdmin,BillingPriority,ShippingPriority,ContactPriority,ServicePriority)
VALUES('Emerald5 - Service Contact','FirstName,LastName',0,0,1,0,0,0,100,0)
GO

-- OperatorGroups
SET IDENTITY_INSERT OperatorGroups ON
INSERT INTO OperatorGroups (Description,InternalUse,OperatorGroup,OperatorGroupID)
SELECT Description,InternalUse,OperatorGroup,OperatorGroupID
FROM Emerald..OperatorGroups
	WHERE OperatorGroupID <> 1
SET IDENTITY_INSERT OperatorGroups OFF
go

-- AllowedHosts
SET IDENTITY_INSERT AllowedHosts ON
INSERT INTO AllowedHosts (AllowedHostID,Description,IPAddress,OperatorGroupID)
SELECT AllowedHostID,Description,IPAddress,OperatorGroupID 
FROM Emerald..AllowedHosts
	WHERE OperatorGroupID IS NULL
	OR OperatorGroupID IN (SELECT OperatorGroupID FROM Emerald..OperatorGroups)
SET IDENTITY_INSERT AllowedHosts OFF
GO

-- Continents
INSERT INTO Continents (Continent,ContinentID,Hidden,Planet,SortOrder)
SELECT Continent,ContinentID,Hidden,Planet,SortOrder 
FROM Emerald..Continents
GO

-- Countries
INSERT INTO Countries (Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus)
SELECT Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus 
FROM Emerald..Countries
GO

-- States
SET IDENTITY_INSERT States ON
INSERT INTO States (Abbreviation,CountryID,SortOrder,State,StateID,TimeZone1,TimeZone2)
SELECT Abbreviation,CountryID,SortOrder,State,StateID,TimeZone1,TimeZone2 
FROM Emerald..States
SET IDENTITY_INSERT States OFF
GO

-- Currencies
INSERT INTO Currencies (Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol)
SELECT Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol 
FROM Emerald..Currencies
GO

-- Organizations
SET IDENTITY_INSERT Organizations ON
INSERT INTO Organizations (CurrencyID,InvoiceDetailed,InvoiceFractional,MaxAccounts,Organization,OrganizationID)
SELECT CurrencyID,InvoiceDetailed,InvoiceFractional,MaxAccounts,Organization,OrganizationID 
FROM Emerald..Organizations
SET IDENTITY_INSERT Organizations OFF
GO

-- Themes
SET IDENTITY_INSERT Themes ON
INSERT INTO Themes (Description,Theme,ThemeID)
SELECT Description,Theme,ThemeID 
FROM Emerald..Themes
SET IDENTITY_INSERT Themes OFF
GO

-- ThemeFilters
SET IDENTITY_INSERT ThemeFilters ON
INSERT INTO ThemeFilters (Data,Description,Score,ThemeFilter,ThemeFilterID,ThemeID,ThemeMatchTypeID)
SELECT Data,Description,Score,ThemeFilter,ThemeFilterID,ThemeID,ThemeMatchTypeID 
FROM Emerald..ThemeFilters
SET IDENTITY_INSERT ThemeFilters OFF
GO

-- ServiceGroups
SET IDENTITY_INSERT ServiceGroups ON
INSERT INTO ServiceGroups (AllowAccountTypes,AllowBillingCycles,AllowChargeTypes,AllowDomains,AllowIncidentTypes,AllowPayPeriods,AllowRegions,AllowSalesPersons,AllowSendMethods,Description,ServiceGroup,ServiceGroupID,SortOrder)
SELECT AllowAccountTypes,AllowBillingCycles,AllowChargeTypes,AllowDomains,AllowIncidentTypes,AllowPayPeriods,AllowRegions,AllowSalesPersons,AllowSendMethods,Description,ServiceGroup,ServiceGroupID,SortOrder 
FROM Emerald..ServiceGroups
SET IDENTITY_INSERT ServiceGroups OFF
GO

-- Domains
SET IDENTITY_INSERT Domains ON
INSERT INTO Domains (CustomerAccess,Description,Domain,DomainID,ErrorCount,ErrorMessage,ExpireDate,ExternalDNSRef,ExternalRef,MailDomain,ServiceGroupID,SortOrder)
SELECT CustomerAccess,Description,Domain,DomainID,ErrorCount,ErrorMessage,ExpireDate,ExternalDNSRef,ExternalRef,MailDomain,ServiceGroupID,SortOrder
FROM Emerald..Domains
SET IDENTITY_INSERT Domains OFF
GO

-- Groups
SET IDENTITY_INSERT Groups ON
INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillZip,Description,EmailAccounts,EmailSubject,EndDate,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDomains,GlobalIncidentTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,OrganizationID,PaymentTypes,PrintInvoices,PrintStatements,ReportLogoURL,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore,DomainID)
SELECT g.Active,g.AutoEmailInvoices,g.AutoEmailStatements,g.BillAddress1,g.BillAddress2,g.BillCity,c.CountryID,g.BillFax,g.BillName,g.BillPhone,g.BillState,g.BillZip,g.Description,g.EmailAccounts,g.EmailSubject,g.EndDate,g.GlobalAccountTypes,g.GlobalBillingCycles,g.GlobalChargeTypes,g.GlobalDomains,g.GlobalIncidentTypes,g.GlobalPayPeriods,g.GlobalRegions,g.GlobalSalesPersons,g.GlobalSendMethods,g.GroupID,g.GroupName,g.InvoiceHTMLReport,g.InvoiceReport,g.InvoiceTextReport,g.OrganizationID,g.PaymentTypes,g.PrintInvoices,g.PrintStatements,g.ReportLogoURL,g.SortOrder,g.StartDate,g.StatementHTMLReport,g.StatementReport,g.StatementTextReport,g.ThemeID,g.ThemeScore,g.DomainID
FROM Emerald..Groups g LEFT JOIN Countries c ON (g.BillCountryID = c.CountryID)
SET IDENTITY_INSERT Groups OFF
GO

-- Batches
SET IDENTITY_INSERT Batches ON
INSERT INTO Batches (BatchID,BatchInfo,BatchStateID,BatchTypeID,CreateUser,EndDate,GroupID,ItemCount,ItemTotal,LastModifyDate,LastModifyUser,Rebatch,StartDate)
SELECT b.BatchID,b.BatchInfo,b.BatchStateID,b.BatchTypeID,b.Operator,b.EndDate,b.GroupID,b.ItemCount,b.ItemTotal,b.LastModifyDate,b.LastModifyUser,b.Rebatch,b.StartDate 
FROM Emerald..Batches b JOIN BatchStates bs ON (b.BatchStateID = bs.BatchStateID)
	JOIN BatchTypes bt ON (b.BatchTypeID = bt.BatchTypeID)
SET IDENTITY_INSERT Batches OFF
GO

-- CancelReasons
SET IDENTITY_INSERT CancelReasons ON
INSERT INTO CancelReasons (CancelReason,CancelReasonID,CustomerAccess,Returning,SortOrder,StringID)
SELECT CancelReason,CancelReasonID,CustomerAccess,Returning,SortOrder,StringID
FROM Emerald..CancelReasons
SET IDENTITY_INSERT CancelReasons OFF
GO

-- CardDigits
SET IDENTITY_INSERT CardDigits ON
INSERT INTO CardDigits (AllowLogin,AllowPassword,CardDigit,CardDigitID,IEAID,JavascriptField,JavascriptHeader)
SELECT AllowLogin,AllowPassword,CardDigit,CardDigitID,IEAID,JavascriptField,JavascriptHeader
FROM Emerald..CardDigits
SET IDENTITY_INSERT CardDigits OFF
GO

-- CommissionGroups
SET IDENTITY_INSERT CommissionGroups ON
INSERT INTO CommissionGroups (Active,CommissionGroup,CommissionGroupID,CommissionType,SortOrder)
SELECT Active,CommissionGroup,CommissionGroupID,CommissionType,SortOrder
FROM Emerald..CommissionGroups
SET IDENTITY_INSERT CommissionGroups OFF
GO

-- Languages
INSERT INTO Languages (Active,AllowIEAUpdate,Description,HttpAcceptLanguage,LanguageID,SortOrder)
SELECT Active,AllowIEAUpdate,Description,HttpAcceptLanguage,LanguageID,SortOrder 
FROM Emerald..Languages
	WHERE LanguageID >= 10000

UPDATE l SET AllowIEAUpdate = ol.AllowIEAUpdate, HttpAcceptLanguage = ol.HttpAcceptLanguage
FROM Languages l JOIN Emerald..Languages ol ON (l.LanguageID = ol.LanguageID)
GO

-- Operators
SET IDENTITY_INSERT Operators ON
INSERT INTO Operators (Active,CountryID,DateFormatID,DateSeparator,DaySumIncident,Email,LanguageID,MeasureUnitID,Operator,OperatorGroupID,OperatorID,Password,PrintTypeID,ThemeID)
SELECT Active,CountryID,DateFormatID,DateSeperator,DaySumIncident,Email,LanguageID,MeasureUnitID,Operator,OperatorGroupID,OperatorID,Password,PrintTypeID,ThemeID
FROM Emerald..Operators
SET IDENTITY_INSERT Operators OFF
GO

-- SalesPersons
SET IDENTITY_INSERT SalesPersons ON
INSERT INTO SalesPersons (Active,CommissionGroupID,CommissionValue,GroupID,OperatorID,SalesPerson,SalesPersonID,ServiceGroupID,SortOrder)
SELECT sp.Active,sp.CommissionGroupID,sp.CommissionValue,sp.GroupID,o.OperatorID,sp.SalesPerson,sp.SalesPersonID,sp.ServiceGroupID,sp.SortOrder
FROM Emerald..SalesPersons sp LEFT JOIN Operators o ON (sp.OperatorID = o.OperatorID)
SET IDENTITY_INSERT SalesPersons OFF
GO

-- DNISGroups
SET IDENTITY_INSERT DNISGroups ON
INSERT INTO DNISGroups (DNISGroup,DNISGroupID,Description)
SELECT DNISGroup,DNISGroupID,Description FROM
Emerald..DNISGroups
SET IDENTITY_INSERT DNISGroups OFF
GO

-- DNISNumbers
INSERT INTO DNISNumbers (DNISGroupID,DNISNumber)
SELECT DNISGroupID,DNISNumber
FROM Emerald..DNISNumbers
GO

-- Exports
INSERT INTO Exports (ApproveMatch,ApproveString,AuthMatch,AuthString,CreditMatch,CreditString,DeclineMatch,DeclineString,DefaultProcessorURL,Description,ExportID,ExportType,Features,Filter,FormatDefault,HeaderRow,ImportKeySeparator,ImportKeyValueSeparator,Lines,QuoteString,SQLString,Separator,StageCount,Template,VoidMatch,VoidString)
SELECT ApproveMatch,ApproveString,AuthMatch,AuthString,CreditMatch,CreditString,DeclineMatch,DeclineString,DefaultProcessorURL,Description,ExportID,ExportType,Features,Filter,FormatDefault,HeaderRow,ImportKeySeparator,ImportKeyValueSeparator,Lines,QuoteString,SQLString,Separator,StageCount,Template,VoidMatch,VoidString
FROM Emerald..Exports
	WHERE ExportID >= 10000
GO

-- ExportColumns
INSERT INTO ExportColumns (Align,Description,ExportID,ExportValue,FieldName,Format,Include,MaxSize,MinSize,Padding,Quoted,SortOrder,TransType)
SELECT Align,Description,ExportID,ExportValue,FieldName,Format,Include,MaxSize,MinSize,Padding,Quoted,SortOrder,TransType
FROM Emerald..ExportColumns
	WHERE ExportID >= 10000
GO

-- CCImportColumns
INSERT INTO CCImportColumns (ApproveValue,DeclineValue,Description,ErrorValue,ExportID,FieldSize,FieldType,Line,Position,Quoted,SortOrder,TransType)
SELECT ApproveValue,DeclineValue,Description,ErrorValue,ExportID,FieldSize,FieldType,Line,Position,Quoted,SortOrder,TransType
FROM Emerald..CCImportColumns
	WHERE ExportID >= 10000
GO

-- Strings
INSERT INTO Strings (ApplicationID,Data,LanguageID,StringID)
SELECT ApplicationID,Data,LanguageID,StringID 
FROM Emerald..Strings
	WHERE (StringID >= 100000 OR LanguageID >= 10000)

UPDATE s SET Data = CASE WHEN os.Data LIKE '%:' THEN LEFT(os.Data,DATALENGTH(os.Data)-1) ELSE os.Data END
FROM Strings s JOIN Languages l ON (s.LanguageID = l.LanguageID)
	JOIN Emerald..Strings os ON (s.StringID = os.StringID AND s.LanguageID = os.LanguageID AND s.ApplicationID = os.ApplicationID)
	WHERE l.AllowIEAUpdate = 0
GO

-- AccountDataTypes
INSERT INTO AccountDataTypes (AccountDataType,AccountDataTypeID,AllowMBR,AllowSA,DataTypeID,RegExp,SQLQuery,StringID)
SELECT AccountDataType,AccountDataTypeID,AllowMBR,AllowSA,DataTypeID,RegExp,SQLQuery,StringID
FROM Emerald..AccountDataTypes
	WHERE AccountDataTypeID NOT IN (SELECT AccountDataTypeID FROM AccountDataTypes)
GO

-- AccountDataValues
INSERT INTO AccountDataValues (AccountDataTypeID,KeyData,ValueData)
SELECT AccountDataTypeID,KeyData,ValueData
FROM Emerald..AccountDataValues
	WHERE AccountDataTypeID >= 10000
GO

-- ExternalSystemTypes
INSERT INTO ExternalSystemTypes (DescAux1,DescAux2,DescAux3,ExportID,ExternalSystemType,ExternalSystemTypeID,ShowExportID,ShowLogin,ShowMailHost,ShowPassword,ShowURL)
SELECT DescAux1,DescAux2,DescAux3,ExportID,ExternalSystemType,ExternalSystemTypeID,ShowExportID,ShowLogin,ShowMailHost,ShowPassword,ShowURL
FROM Emerald..ExternalSystemTypes
	WHERE ExternalSystemTypeID >= 10000
GO

-- GLCodes
SET IDENTITY_INSERT GLCodes ON
INSERT INTO GLCodes (Description,GLCode,GLCodeID)
SELECT Description,GLCode,GLCodeID
FROM Emerald..GLCodes
SET IDENTITY_INSERT GLCodes OFF
GO

-- IncidentStateGroups
SET IDENTITY_INSERT IncidentStateGroups ON
INSERT INTO IncidentStateGroups (IncidentStateGroup,IncidentStateGroupID)
SELECT IncidentStateGroup,IncidentStateGroupID
FROM Emerald..IncidentStateGroups
SET IDENTITY_INSERT IncidentStateGroups OFF
GO

-- IncidentStates
SET IDENTITY_INSERT IncidentStates ON
INSERT INTO IncidentStates (CustomerAccess,Description,IncidentState,IncidentStateGroupID,IncidentStateID,Priority,SortOrder,StatArchive,StatBlock,StatEscalate,StatOpen,StatWait,Style)
SELECT CustomerAccess,Description,IncidentState,IncidentStateGroupID,IncidentStateID,Priority,SortOrder,StatArchive,StatBlock,StatEscalate,StatOpen,StatWait,Style
FROM Emerald..IncidentStates
SET IDENTITY_INSERT IncidentStates OFF
GO

-- IncidentTemplates
INSERT INTO IncidentTemplates (CustIncidentEdit,CustIncidentSave,IncidentEdit,IncidentSave,IncidentTemplate,IncidentTemplateID,SortOrder)
SELECT CustIncidentEdit,CustIncidentSave,IncidentEdit,IncidentSave,IncidentTemplate,IncidentTemplateID,SortOrder
FROM Emerald..IncidentTemplates
	WHERE IncidentTemplateID >= 10000
GO

-- Roles
SET IDENTITY_INSERT Roles ON
INSERT INTO Roles (GroupID,Role,RoleAssignTypeID,RoleID,RoleTypeID,SortOrder)
SELECT GroupID,Role,COALESCE(AssignStrategyID,1),RoleID,1,0
FROM Emerald..Roles
SET IDENTITY_INSERT Roles OFF
GO

-- IncidentTypes
SET IDENTITY_INSERT IncidentTypes ON
INSERT INTO IncidentTypes (CustomerAccess,Description,Email,EnableOperatorRole,EscalateDays,GroupID,IncidentStateGroupID,IncidentType,IncidentTypeID,OverDays,RoleID,ServiceGroupID,ShowAssignOperator,ShowCustDueDate,ShowCustomerAccess,ShowDueDate,ShowDuration,ShowEmail,ShowPriority,ShowSummary,SortOrder,WarnDays)
SELECT CustomerAccess,Description,Email,COALESCE(EnableOperatorRole,0),EscalateDays,GroupID,IncidentStateGroupID,IncidentType,IncidentTypeID,OverDays,RoleID,ServiceGroupID,1,ShowCustDueDate,ShowCustomerAccess,ShowDueDate,ShowDuration,ShowEmail,ShowPriority,ShowSummary,SortOrder,WarnDays
FROM Emerald..IncidentTypes
SET IDENTITY_INSERT IncidentTypes OFF
GO

-- IncidentDataTypes
SET IDENTITY_INSERT IncidentDataTypes ON
INSERT INTO IncidentDataTypes (CustomerAccess,DataTypeID,IncidentDataType,IncidentDataTypeID,IncidentTemplateID,IncidentTypeID,RegExp,Required,SQLQuery,Searchable,SortOrder)
SELECT CustomerAccess,DataTypeID,IncidentDataType,IncidentDataTypeID,IncidentTemplateID,IncidentTypeID,RegExp,Required,SQLQuery,Searchable,SortOrder
FROM Emerald..IncidentDataTypes
SET IDENTITY_INSERT IncidentDataTypes OFF
GO

-- IncidentValues
INSERT INTO IncidentValues (IncidentDataTypeID,NumValue,ValueName)
SELECT iv.IncidentDataTypeID,iv.NumValue,iv.ValueName
FROM Emerald..IncidentValues iv JOIN Emerald..IncidentDataTypes idt ON (iv.IncidentDataTypeID = idt.IncidentDataTypeID)
GO

-- TaxTypes
SET IDENTITY_INSERT TaxTypes ON
INSERT INTO TaxTypes (TaxType,TaxTypeID)
SELECT TaxType,TaxTypeID
FROM Emerald..TaxTypes
SET IDENTITY_INSERT TaxTypes OFF
GO

-- TaxPiggyBacks
SET IDENTITY_INSERT TaxPiggyBacks ON
INSERT INTO TaxPiggyBacks (TaxPiggyBack,TaxPiggyBackID)
SELECT TaxPiggyBack,TaxPiggyBackID
FROM Emerald..TaxPiggyBacks
SET IDENTITY_INSERT TaxPiggyBacks OFF
GO

-- Taxes
SET IDENTITY_INSERT Taxes ON
INSERT INTO Taxes (Active,AmountType,CeilingLimit,CumulativeType,Description,FloorLimit,GLCodeID,SortOrder,StringID,Tax,TaxExemptions,TaxID,TaxPigOrder,TaxPiggyBackID,TaxTypeID)
SELECT 1,AmountType,CeilingLimit,CumulativeType,Description,FloorLimit,GLCodeID,SortOrder,StringID,Tax,TaxExemptions,TaxID,TaxPigOrder,TaxPiggyBackID,TaxTypeID
FROM Emerald..Taxes
SET IDENTITY_INSERT Taxes OFF
GO

-- TaxGroups
SET IDENTITY_INSERT TaxGroups ON
INSERT INTO TaxGroups (TaxGroup,TaxGroupID)
SELECT TaxGroup,TaxGroupID
FROM Emerald..TaxGroups
SET IDENTITY_INSERT TaxGroups OFF
GO

-- Regions
SET IDENTITY_INSERT Regions ON
INSERT INTO Regions (GroupID,Region,RegionID,ServiceGroupID,SortOrder)
SELECT GroupID,Region,RegionID,ServiceGroupID,SortOrder
FROM Emerald..Regions
SET IDENTITY_INSERT Regions OFF
GO

-- TaxGroupTaxes
SET IDENTITY_INSERT TaxGroupTaxes ON
INSERT INTO TaxGroupTaxes (AddressCategoryID,City,CountryID,RegionID,StateID,TaxGroupID,TaxGroupTaxID,TaxID,Zip)
SELECT 1,tgt.City,tgt.CountryID,tgt.RegionID,tgt.StateID,tgt.TaxGroupID,tgt.TaxGroupTaxID,tgt.TaxID,tgt.Zip
FROM Emerald..TaxGroupTaxes tgt JOIN TaxGroups tg ON (tgt.TaxGroupID = tg.TaxGroupID)
SET IDENTITY_INSERT TaxGroupTaxes OFF
GO

-- ChargeTypes
SET IDENTITY_INSERT ChargeTypes ON
INSERT INTO ChargeTypes (Amount,ChargeType,ChargeTypeID,GLCodeID,GroupID,ServiceGroupID,SortOrder,StringID,TaxExemptions,TaxGroupID)
SELECT Amount,Description,ChargeTypeID,GLCodeID,GroupID,ServiceGroupID,SortOrder,StringID,TaxExemptions,TaxGroupID
FROM Emerald..ChargeTypes
SET IDENTITY_INSERT ChargeTypes OFF
GO

-- Priorities
INSERT INTO Priorities (Priority,PriorityID,StringID)
SELECT Priority,PriorityID,StringID
FROM Emerald..Priorities
GO

-- LateFees
SET IDENTITY_INSERT LateFees ON
INSERT INTO LateFees (ChargeTypeID,GraceDays,LateFee,LateFeeID,LateFeeTypeID,MaxAmount,MaxDays,MinAmount,PriorityID,SortOrder)
SELECT ChargeTypeID,5,LateFee,LateFeeID,2,MaxAmount,MinDays * 2,MinAmount,0,SortOrder
FROM Emerald..LateFees
SET IDENTITY_INSERT LateFees OFF
GO

-- LateFeeDays
SET IDENTITY_INSERT LateFeeDays ON
INSERT INTO LateFeeDays (Amount,LateFeeDayID,LateFeeID,OverAmount,OverDays)
SELECT Percentage,LateFeeID,LateFeeID,0,MinDays
FROM Emerald..LateFees
SET IDENTITY_INSERT LateFeeDays OFF
GO

-- LDAPServers
INSERT INTO LDAPServers (Calls,LDAPServer,LastModifyDate,LastSyncRead,LastSyncWrite)
SELECT Calls,LDAPServer,LastModifyDate,LastSyncRead,LastSyncWrite
FROM Emerald..LDAPServers
GO

-- PaymentTypes
INSERT INTO PaymentTypes (CustomerAccess,CustomerDescription,CustomerPayment,CustomerStringID,GLCodeID,IsPayMethod,IsPayType,PaymentType,PaymentTypeID,SortOrder,StringID)
SELECT CustomerAccess,CustomerDescription,CustomerPayment,CustomerStringID,GLCodeID,IsPayMethod,IsPayType,PaymentType,PaymentTypeID,SortOrder,StringID
FROM Emerald..PaymentTypes
GO

-- RateClasses
SET IDENTITY_INSERT RateClasses ON
INSERT INTO RateClasses (AllowInterim,RateClass,RateClassID)
SELECT 0,RateClass,RateClassID
FROM Emerald..RateClasses
SET IDENTITY_INSERT RateClasses OFF
GO

-- PayPeriods
SET IDENTITY_INSERT PayPeriods ON
INSERT INTO PayPeriods (ConfirmTrans,GroupID,PayPeriod,PayPeriodID,Period,PeriodTypeID,ServiceGroupID,SetupCharge,SortOrder,StringID)
SELECT ConfirmTrans,GroupID,PayPeriod,PayPeriodID,Period,PeriodTypeID,ServiceGroupID,SetupCharge,SortOrder,StringID
FROM Emerald..PayPeriods
SET IDENTITY_INSERT PayPeriods OFF
GO

-- AccountTypes
SET IDENTITY_INSERT AccountTypes ON
INSERT INTO AccountTypes (AccountType,AccountTypeID,AllowRADIUS,ChargeTypeID,Cost,DNISGroupID,DataLeft,DataLeftRenewal,Description,EndDate,Extension,GLCodeID,GroupID,InactCanceledDays,LoginLimit,LogonAsParent,PayPeriodID,ProrateClose,ProrateCloseTemp,ProrateOpen,ProrateOpenTemp,RLimitDataLeft,RLimitRateDataLeft,RLimitRateTimeLeft,RLimitTimeLeft,RateClassID,RateDataLeft,RateTimeLeft,RemoteAccess,SecChargeTypeID,ServiceGroupID,SortOrder,StartDate,StringID,TaxExemptions,TaxGroupID,TimeLeft,TimeLeftRenewal,UsageToParent,UseServerPassword)
SELECT at1.AccountType,at1.AccountTypeID,(SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM Emerald..RadATConfigs rac WHERE rac.AccountTypeID = at1.AccountTypeID) AS AllowRADIUS,at1.ChargeTypeID,at1.Cost,at1.DNISGroupID,at1.DataLeft,COALESCE(at1.DataLeftRenewal,1),at1.Description,at1.EndDate,NULL,at1.GLCodeID,at1.GroupID,at1.InactCanceledDays,at1.LoginLimit,0,pp.PayPeriodID,at1.ChangeClose,at1.ChangeClose,at1.ChangeOpen,at1.ChangeOpen,NULL,NULL,NULL,NULL,at1.RateClassID,NULL,NULL,COALESCE(at1.RemoteAccess,0),sct.ChargeTypeID,at1.ServiceGroupID,at1.SortOrder,at1.StartDate,at1.StringID,at1.TaxExemptions,at1.TaxGroupID,at1.TimeLeft,COALESCE(at1.TimeLeftRenewal,1),0,0
FROM Emerald..AccountTypes at1 LEFT JOIN PayPeriods pp ON (at1.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ChargeTypes sct ON (at1.SecChargeTypeID = sct.ChargeTypeID)
SET IDENTITY_INSERT AccountTypes OFF
GO

--AccountTypeTemplates
INSERT INTO AccountTypeTemplates (AccountTypeID,AccountTemplateID)
SELECT AccountTypeID,AccountTemplateID
FROM Emerald..AccountTypes
	WHERE AccountTemplateID IS NOT NULL
GO

--AccountTypes (PackageTypes)
INSERT INTO AccountTypes (AccountType,RateTimeLeft,AllowRADIUS,ChargeTypeID,Cost,Description,EndDate,GLCodeID,GroupID,LogonAsParent,PayPeriodID,ProrateClose,ProrateCloseTemp,ProrateOpen,ProrateOpenTemp,RemoteAccess,SecChargeTypeID,ServiceGroupID,SortOrder,StartDate,StringID,TaxExemptions,TaxGroupID,UsageToParent,UseServerPassword)
SELECT 'Package - ' + PackageType,PackageTypeID,0 AS AllowRADIUS,ChargeTypeID,Cost,COALESCE(Description,PackageType),EndDate,GLCodeID,GroupID,0,PayPeriodID,ChangeClose,ChangeClose,ChangeOpen,ChangeOpen,0,SecChargeTypeID,ServiceGroupID,10000,StartDate,StringID,COALESCE(TaxExemptions,0),TaxGroupID,0,0
FROM Emerald..PackageTypes pt
GO

-- PayPeriods
UPDATE p SET AccountTypeID = op.AccountTypeID
FROM PayPeriods p JOIN Emerald..PayPeriods op ON (p.PayPeriodID = op.PayPeriodID)
	WHERE op.AccountTypeID IS NOT NULL
GO

-- NoticeTypes
SET IDENTITY_INSERT NoticeTypes ON
INSERT INTO NoticeTypes (IEAID,DefaultText,Description,InternalID,NoticePurposeID,NoticeType,NoticeTypeID,Parm1Desc,Parm1Query,Parm2Desc,Parm2Query,Parm3Desc,Parm3Query,ReportFile,SQLQuery,SentQuery)
SELECT IEAID,DefaultText,Description,InternalID,32,NoticeType,NoticeTypeID,Parm1Desc,Parm1Query,Parm2Desc,Parm2Query,Parm3Desc,Parm3Query,ReportFile,SQLQuery,SentQuery
FROM Emerald..NoticeTypes
SET IDENTITY_INSERT NoticeTypes OFF
GO

-- PosixAccountServers
SET IDENTITY_INSERT PosixAccountServers ON
INSERT INTO PosixAccountServers (AccountTypeID,LDAPServer,PosixAccountServerID,gidNumber,homeDirectory,loginShell)
SELECT AccountTypeID,LDAPServer,PosixAccountServerID,gidNumber,homeDirectory,loginShell
FROM Emerald..PosixAccountServers
SET IDENTITY_INSERT PosixAccountServers OFF
GO

-- RateIPPorts
INSERT INTO RateIPPorts (Description,Port,SortOrder)
SELECT Description,Port,SortOrder
FROM Emerald..RateIPPorts
GO

-- RateIPProtocols
INSERT INTO RateIPProtocols (Description,Protocol,SortOrder)
SELECT Description,Protocol,SortOrder
FROM Emerald..RateIPProtocols
GO

-- ReferredBys
SET IDENTITY_INSERT ReferredBys ON
INSERT INTO ReferredBys (GroupID,ReferredBy,ReferredByID,SortOrder,StringID)
SELECT GroupID,ReferredBy,ReferredByID,SortOrder,StringID
FROM Emerald..ReferredBys
SET IDENTITY_INSERT ReferredBys OFF
GO

-- RadVendors
INSERT INTO RadVendors (Comments,Description,Name,RadVendorID,VendorURL)
SELECT Comments,Description,Name,RadVendorID,VendorURL
FROM Emerald..RadVendors WHERE RadVendorID NOT IN (SELECT RadVendorID FROM RadVendors)
GO

-- RadAttributes
INSERT INTO RadAttributes (AliasAttributeID,AliasVendorID,Name,RadAttributeID,RadAttributeType,RadVendorID)
SELECT AliasAttributeID,AliasVendorID,Name,RadAttributeID,RadAttributeType,RadVendorID
FROM Emerald..RadAttributes ra 
	WHERE ra.RadVendorID <> 0
	AND NOT EXISTS (SELECT * FROM RadAttributes ra2 WHERE ra.RadVendorID = ra2.RadVendorID AND ra.RadAttributeID = ra2.RadAttributeID)
GO

-- RadValues
INSERT INTO RadValues (Name,RadAttributeID,RadVendorID,Value)
SELECT Name,RadAttributeID,RadVendorID,Value
FROM Emerald..RadValues rv
	WHERE rv.RadVendorID <> 0
	AND NOT EXISTS (SELECT * FROM RadValues rv2 WHERE rv.RadVendorID = rv2.RadVendorID AND rv.RadAttributeID = rv2.RadAttributeID AND rv.Value = rv2.Value)
GO

-- RadMapTypes
INSERT INTO RadMapTypes (RadMapType,RadMapTypeID)
SELECT RadMapType,RadMapTypeID
FROM Emerald..RadMapTypes
go

-- RadMapAttributes
INSERT INTO RadMapAttributes (MapAttribute,RadAttributeID,RadMapTypeID,RadVendorID)
SELECT MapAttribute,RadAttributeID,RadMapTypeID,RadVendorID 
FROM Emerald..RadMapAttributes va
	WHERE EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
GO

-- RadMapValues
INSERT INTO RadMapValues (Description,MapAttribute,MapValue,RadMapTypeID,RadValue)
SELECT Description,MapAttribute,MapValue,RadMapTypeID,RadValue
FROM Emerald..RadMapValues va
GO

-- RadRoamServers
SET IDENTITY_INSERT RadRoamServers ON
INSERT INTO RadRoamServers (AcctPort,AuthPort,IPAddress,RadRoamServerID,RateMax,RateTarget,Retries,Secret,Server,StripDomain,Timeout,TreatAsLocal)
SELECT AcctPort,AuthPort,IPAddress,RadRoamServerID,RateMax,RateTarget,Retries,Secret,Server,StripDomain,Timeout,TreatAsLocal
FROM Emerald..RadRoamServers
SET IDENTITY_INSERT RadRoamServers OFF
GO

-- RadProxyAttributeGroups
SET IDENTITY_INSERT RadProxyAttributeGroups ON
INSERT INTO RadProxyAttributeGroups (Description,Priority,RadProxyAttributeGroupID,RadRoamServerID)
SELECT rpag.Description,rpag.Priority,rpag.RadProxyAttributeGroupID,rpag.RadRoamServerID
FROM Emerald..RadProxyAttributeGroups rpag JOIN RadRoamServers rrs ON (rpag.RadRoamServerID = rrs.RadRoamServerID)
SET IDENTITY_INSERT RadProxyAttributeGroups OFF
GO

-- RadProxyAttributes
SET IDENTITY_INSERT RadProxyAttributes ON
INSERT INTO RadProxyAttributes (RadAttributeID,RadProxyAttributeGroupID,RadProxyAttributeID,RadSearchTypeID,RadVendorID,String)
SELECT RadAttributeID,RadProxyAttributeGroupID,RadProxyAttributeID,SearchType,RadVendorID,String
FROM Emerald..RadProxyAttributes va
	WHERE EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
SET IDENTITY_INSERT RadProxyAttributes OFF
GO

-- RadProxyRateProcs
INSERT INTO RadProxyRateProcs (InBytes,OutBytes,ProcDate,ProxyType,Realm,SessionCount,SessionTime,UserCount)
SELECT InBytes,OutBytes,ProcDate,ProxyType,Realm,SessionCount,SessionTime,UserCount
FROM Emerald..RadProxyRateProcs
GO

-- RateSources
INSERT INTO RateSources (AllowData,AllowTime,RateSource,RateSourceID)
SELECT AllowData,AllowTime,RateSource,RateSourceID
FROM Emerald..RateSources
	WHERE RateSourceID >= 10000
GO

-- RateSourceAttributes
INSERT INTO RateSourceAttributes (AllowData,AllowTime,Attribute,Description,Dynamic,RateMatchTypes,RateSourceID,SortOrder,ValuesQuery)
SELECT rsa.AllowData,rsa.AllowTime,rsa.Attribute,rsa.Description,rsa.Dynamic,rsa.RateMatchTypes,rsa.RateSourceID,rsa.SortOrder,rsa.ValuesQuery 
FROM Emerald..RateSourceAttributes rsa JOIN RateSources rs ON (rsa.RateSourceID = rs.RateSourceID)
	WHERE rsa.RateSourceID >= 10000
GO

-- RateTimeGroups
SET IDENTITY_INSERT RateTimeGroups ON
INSERT INTO RateTimeGroups (RateTimeGroup,RateTimeGroupID)
SELECT RateTimeGroup,RateTimeGroupID
FROM Emerald..RateTimeGroups
SET IDENTITY_INSERT RateTimeGroups OFF
GO

-- RateTimes
SET IDENTITY_INSERT RateTimes ON
INSERT INTO RateTimes (DayWeekMask,Description,EndHour,EndMinute,MonthDay,MonthMask,Priority,RateTimeGroupID,RateTimeID,StartHour,StartMinute,WeekNumMask)
SELECT DayWeekMask,Description,EndHour,EndMinute,MonthDay,MonthMask,Priority,RateTimeGroupID,RateTimeID,StartHour,StartMinute,WeekNumMask
FROM Emerald..RateTimes
SET IDENTITY_INSERT RateTimes OFF
GO

-- ServerGroups
SET IDENTITY_INSERT ServerGroups ON
INSERT INTO ServerGroups (ServerGroup,ServerGroupID)
SELECT ServerGroup,ServerGroupID
FROM Emerald..ServerGroups
SET IDENTITY_INSERT ServerGroups OFF
GO

-- Servers
SET IDENTITY_INSERT Servers ON
INSERT INTO Servers (ServerTypeID,AcctPort,AuthPort,CheckAccess,Comments,Community,Concurrency,ContactName,ContactPhone,DisconnectPort,DisconnectType,IPAddress,Location,PhoneNumber,Ports,RadRoamServerID,Secret,Server,ServerGroupID,ServerID)
SELECT CASE WHEN ServerType > 0 THEN 0 WHEN ServerType IN (-2,-1) THEN ServerType ELSE 0 END AS ServerTypeID,AcctPort,AuthPort,COALESCE(CheckAccess,0),Comments,Community,COALESCE(Concurrency,1),ContactName,ContactPhone,DisconnectPort,DisconnectType,IPAddress,Location,PhoneNumber,Ports,RadRoamServerID,Secret,Server,ServerGroupID,ServerID
FROM Emerald..Servers
SET IDENTITY_INSERT Servers OFF
GO

-- SysLogs
INSERT INTO SysLogs (Data,IPAddress,LogDate,SyslogFacilityID,SyslogSeverityID)
SELECT Data,IPAddress,LogDate,Facility,Severity
FROM Emerald..SysLogs
GO

-- TaxExemptions
INSERT INTO TaxExemptions (TaxExemptionID,TaxExemption,StringID,AllowMBR,AllowItem,Active)
SELECT TaxExemptionID,Exemption,StringID,AllowMBR,AllowItem,Active
FROM Emerald..TaxExemptions
GO

-- WebLinkTypes
SET IDENTITY_INSERT WebLinkTypes ON
INSERT INTO WebLinkTypes (AllowCallSearch,AllowCustomer,AllowOperator,WebLinkType,WebLinkTypeID) VALUES(0,0,1,'Emerald5 - Operator',1)
INSERT INTO WebLinkTypes (AllowCallSearch,AllowCustomer,AllowOperator,WebLinkType,WebLinkTypeID) VALUES(0,1,0,'Emerald5 - Customer',2)
INSERT INTO WebLinkTypes (AllowCallSearch,AllowCustomer,AllowOperator,WebLinkType,WebLinkTypeID) VALUES(1,0,0,'Emerald5 - Caller Search',4)
SET IDENTITY_INSERT WebLinkTypes OFF

-- WebLinks
SET IDENTITY_INSERT WebLinks ON
INSERT INTO WebLinks (SortOrder,URL,WebLink,WebLinkID,WebLinkTypeID)
SELECT SortOrder,URL,Title,WebLinkID,CASE WHEN LinkType IN (1,2,4) THEN LinkType ELSE 1 END
FROM Emerald..WebLinks
SET IDENTITY_INSERT WebLinks OFF
GO

-- BillingCycles
SET IDENTITY_INSERT BillingCycles ON
INSERT INTO BillingCycles (AutoBill,BillDay,BillingCycle,BillingCycleID,CycleType,EBillDays,Extension,GroupID,IBillDays,RenewDays,RenewPeriods,ServiceGroupID,SortOrder,StringID,TBillDays)
SELECT AutoBill,BillDay,Description,BillingCycleID,CycleType,EBillDays,Extension,GroupID,IBillDays,RenewDays,RenewPeriods,ServiceGroupID,SortOrder,StringID,TBillDays
FROM Emerald..BillingCycles
SET IDENTITY_INSERT BillingCycles OFF
GO

-- Configs
UPDATE c SET NumValue = oc.NumValue, Data = oc.Data
FROM Configs c JOIN Emerald..Configs oc ON (c.ConfigID = oc.ConfigID)

-- Disable External interfaces by default (Upgrade & Testing)
UPDATE Configs SET NumValue = 0 WHERE ConfigGroupID = 20
GO

-- ExternalSystems
SET IDENTITY_INSERT ExternalSystems ON
INSERT INTO ExternalSystems (Aux1,Aux2,Aux3,Description,ExportID,ExternalSystem,ExternalSystemID,ExternalSystemTypeID,FileMode,LastSyncDate,LogFile,Login,MailHost,Password)
SELECT Aux1,Aux2,Aux3,Description,ExportID,Name,ExternalSystemID,ExternalSystemTypeID,FileMode,LastSyncDate,LogFile,Login,MailHost,Password
FROM Emerald..ExternalSystems
SET IDENTITY_INSERT ExternalSystems OFF
GO

-- Logs
INSERT INTO AuditLogs (LogMsgID,LogDate,LogMsg,Operator)
SELECT CASE WHEN LogMsg LIKE 'File access denied:%' THEN 301 WHEN LogMsg LIKE 'Invalid Username%' THEN 300 WHEN LogMsg LIKE 'Error updating the Emerald database:%' THEN 302 ELSE 1 END AS LogMsgID,LogDate,LogMsg,Operator
FROM Emerald..Logs
GO

-- Notices
SET IDENTITY_INSERT Notices ON
INSERT INTO Notices (Active,InternalID,LastRunDate,MailCC,MailFrom,MailSubject,Notice,NoticeID,NoticeText,NoticeTypeID,Parm1,Parm2,Parm3)
SELECT Active,InternalID,LastRunDate,MailCC,MailFrom,MailSubject,Notice,NoticeID,NoticeText,NoticeTypeID,Parm1,Parm2,Parm3
FROM Emerald..Notices
SET IDENTITY_INSERT Notices OFF
GO

-- RadFilterGroups
SET IDENTITY_INSERT RadFilterGroups ON
INSERT INTO RadFilterGroups (Active,Description,DestData,DestRadFilterGroupID,RadDestTypeID,RadFilterGroup,RadFilterGroupID,RadSourceTypeID,SortOrder)
SELECT Active,Description,DestData,DestRadFilterGroupID,RadDestTypeID,RadFilterGroup,RadFilterGroupID,RadSourceTypeID,SortOrder
FROM Emerald..RadFilterGroups
SET IDENTITY_INSERT RadFilterGroups OFF
GO

-- RadFilters
SET IDENTITY_INSERT RadFilters ON
INSERT INTO RadFilters (Data,Location,RadAttributeID,RadFilterGroupID,RadFilterID,RadFilterTypeID,RadMergeTypeID,RadSearchTypeID,RadVendorID)
SELECT Data,Location,RadAttributeID,RadFilterGroupID,RadFilterID,RadFilterTypeID,RadMergeTypeID,RadSearchTypeID,RadVendorID
FROM Emerald..RadFilters va
	WHERE (RadVendorID IS NULL AND RadAttributeID IS NULL OR EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID))
SET IDENTITY_INSERT RadFilters OFF
GO

-- RadLogs
INSERT INTO RadLogs (CallingStationID,Data,LogDate,NASIdentifier,NASPort,RadLogMsgID,Username)
SELECT rl.CallerID,rl.Data,rl.LogDate,rl.NASIdentifier,rl.NASPort,rl.RadLogMsgID,rl.Username
FROM Emerald..RadLogs rl JOIN RadLogMsgs rlm ON (rl.RadLogMsgID = rlm.RadLogMsgID)
GO

-- RateIntervals
INSERT INTO RateIntervals (NamePlural,NameShort,NameSingular,RateIntervalID,RateRuleTypeID)
SELECT NamePlural,NameShort,NameSingular,RateIntervalID,RateRuleTypeID
FROM Emerald..RateIntervals
GO

-- RateDataSources
INSERT INTO RateDataSources (BillingMode,ClearQuery,DSN,DataQuery,Password,RateDataSource,RateDataSourceID,RateSourceID,UpdateInterval,UpdateQuery,UseTransactions,Username)
SELECT BillingMode,ClearQuery,DSN,DataQuery,Password,RateDataSource,RateDataSourceID,RateSourceID,UpdateInterval,UpdateQuery,UseTransactions,Username
FROM Emerald..RateDataSources
	WHERE RateDataSourceID >= 10000
GO

-- RateVDNISGroups
SET IDENTITY_INSERT RateVDNISGroups ON
INSERT INTO RateVDNISGroups (RateSourceID,RateVDNISGroup,RateVDNISGroupID,SortOrder)
SELECT RateSourceID,RateVDNISGroup,RateVDNISGroupID,SortOrder
FROM Emerald..RateVDNISGroups
SET IDENTITY_INSERT RateVDNISGroups OFF
GO

-- RateRules
SET IDENTITY_INSERT RateRules ON
INSERT INTO RateRules (ClassQuery,ClassRequired,ClassTTL,DefaultCost,Description,Interval,RateRoundTypeID,RateRule,RateRuleID,RateRuleTypeID,RateSourceID,RateTypeID,RuleQuery,StringID)
SELECT ClassQuery,ClassRequired,ClassTTL,DefaultCost,Description,Interval,RateRoundTypeID,RateRule,RateRuleID,RateRuleTypeID,RateSourceID,RateTypeID,RuleQuery,StringID
FROM Emerald..RateRules ot
SET IDENTITY_INSERT RateRules OFF
GO

-- RateVDNIS
SET IDENTITY_INSERT RateVDNIS ON
INSERT INTO RateVDNIS (Attribute,Description,RateRuleID,RateSourceID,RateVDNIS,RateVDNISID,SortOrder)
SELECT Attribute,Description,RateRuleID,RateSourceID,RateVDNIS,RateVDNISID,SortOrder
FROM Emerald..RateVDNIS
SET IDENTITY_INSERT RateVDNIS OFF
GO

-- RateVCondGroups
SET IDENTITY_INSERT RateVCondGroups ON
INSERT INTO RateVCondGroups (Priority,RateRuleID,RateSourceID,RateVCondGroup,RateVCondGroupID,SortOrder)
SELECT Priority,RateRuleID,RateSourceID,RateVCondGroup,RateVCondGroupID,SortOrder
FROM Emerald..RateVCondGroups
SET IDENTITY_INSERT RateVCondGroups OFF
GO

-- RateVCondItems
SET IDENTITY_INSERT RateVCondItems ON
INSERT INTO RateVCondItems (Attribute,Data,RateMatchTypeID,RateVCondGroupID,RateVCondItemID)
SELECT Attribute,Data,RateMatchTypeID,RateVCondGroupID,RateVCondItemID
FROM Emerald..RateVCondItems
SET IDENTITY_INSERT RateVCondItems OFF
GO

-- RateVDNISGroupItems
INSERT INTO RateVDNISGroupItems (RateVCondGroupID,RateVDNISGroupID,RateVDNISID)
SELECT RateVCondGroupID,RateVDNISGroupID,RateVDNISID 
FROM Emerald..RateVDNISGroupItems
GO

-- RateVDNISItems
SET IDENTITY_INSERT RateVDNISItems ON
INSERT INTO RateVDNISItems (CountryID,DNIS,InitialCost,InitialOption,IntervalCost,IntervalOption,Location,RateMatchTypeID,RateVDNISID,RateVDNISItem,RateVDNISItemID,SortOrder,StateID,StaticCost,StaticOption)
SELECT CountryID,DNIS,InitialCost,InitialOption,IntervalCost,IntervalOption,Location,RateMatchTypeID,RateVDNISID,RateVDNISItem,RateVDNISItemID,SortOrder,StateID,StaticCost,StaticOption
FROM Emerald..RateVDNISItems
SET IDENTITY_INSERT RateVDNISItems OFF
GO

-- RateVRates
SET IDENTITY_INSERT RateVRates ON
INSERT INTO RateVRates (Active,Multiplier,RateRuleID,RateVCondGroupID,RateVDNISGroupID,RateVDNISID,RateVRate,RateVRateID)
SELECT Active,Multiplier,RateRuleID,RateVCondGroupID,RateVDNISGroupID,RateVDNISID,RateVRate,RateVRateID
FROM Emerald..RateVRates
SET IDENTITY_INSERT RateVRates OFF
GO

-- SendMethods
SET IDENTITY_INSERT SendMethods ON
INSERT INTO SendMethods (ChargeTypeID,CustomerAccess,EmailAutoTrans,EmailTypeID,GroupID,PrintAutoTrans,PrintTypeID,SendMethod,SendMethodID,ServiceGroupID,SortOrder,StringID)
SELECT ChargeTypeID,COALESCE(CustomerAccess,0),EmailAutoTrans,EmailTypeID,GroupID,PrintAutoTrans,PrintTypeID,Description,SendMethodID,ServiceGroupID,SortOrder,StringID
FROM Emerald..SendMethods
SET IDENTITY_INSERT SendMethods OFF
GO

-- ConfigGroupData
INSERT INTO ConfigGroupData (ConfigID,Data,GroupID,NumValue)
SELECT ocgd.ConfigID,ocgd.Data,ocgd.GroupID,ocgd.NumValue 
FROM Emerald..ConfigGroupData ocgd JOIN Configs c ON (ocgd.ConfigID = c.ConfigID)
GO

-- ConfigOperatorGroupData
INSERT INTO ConfigOperatorGroupData (ConfigID,Data,NumValue,OperatorGroupID)
SELECT ocogd.ConfigID,ocogd.Data,ocogd.NumValue,ocogd.OperatorGroupID
FROM Emerald..ConfigOperatorGroupData ocogd JOIN Configs c ON (ocogd.ConfigID = c.ConfigID)
GO

-- Discounts
SET IDENTITY_INSERT Discounts ON
INSERT INTO Discounts (Amount,AmountType,Discount,DiscountID,SortOrder,StringID)
SELECT Amount,AmountType,Discount,DiscountID,SortOrder,StringID
FROM Emerald..Discounts
	WHERE Amount <> 0
SET IDENTITY_INSERT Discounts OFF
GO

INSERT INTO MarketCategories (MarketCategory,SortOrder) VALUES('Emerald5 - Discounts',1000)
GO

INSERT INTO MarketTags (MarketTag,StringID,MarketCategoryID,MarketTagAutoTypeID,DiscountID,SortOrder)
SELECT d.Discount AS MarketTag,d.StringID,mc.MarketCategoryID,4 AS MarketTagAutoTypeID,d.DiscountID,d.SortOrder
FROM Discounts d JOIN MarketCategories mc ON (mc.MarketCategory = 'Emerald5 - Discounts')
GO

-- ExternalSystemDataTypes
INSERT INTO ExternalSystemDataTypes (AccountDataTypeID,ExternalSystemTypeID,Required,SortOrder)
SELECT AccountDataTypeID,ExternalSystemTypeID,Required,SortOrder
FROM Emerald..ExternalSystemDataTypes
	WHERE ExternalSystemTypeID >= 10000
GO

-- MasterAccountDataTypes
SET IDENTITY_INSERT MasterAccountDataTypes ON
INSERT INTO MasterAccountDataTypes (AccountDataTypeID,GroupID,MasterAccountDataTypeID,Required,ServiceGroupID,SortOrder)
SELECT madt.AccountDataTypeID,madt.GroupID,madt.MasterAccountDataTypeID,madt.Required,sg.ServiceGroupID,madt.SortOrder
FROM Emerald..MasterAccountDataTypes madt LEFT JOIN ServiceGroups sg ON (madt.ServiceGroupID = sg.ServiceGroupID)
SET IDENTITY_INSERT MasterAccountDataTypes OFF
GO

-- RadRejectAttributes
SET IDENTITY_INSERT RadRejectAttributes ON
INSERT INTO RadRejectAttributes (Data,RadAttributeID,RadLogMsgID,RadRejectAttributeID,RadVendorID,ServerID)
SELECT Data,RadAttributeID,RadLogMsgID,RadRejectAttributeID,RadVendorID,ServerID
FROM Emerald..RadRejectAttributes va
	WHERE IEAID IS NULL
	AND EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
SET IDENTITY_INSERT RadRejectAttributes OFF
GO

-- RadRejects
SET IDENTITY_INSERT RadRejects ON
INSERT INTO RadRejects (Data,RadAttributeID,RadRejectID,RadVendorID)
SELECT Data,RadAttributeID,RadRejectID,RadVendorID
FROM Emerald..RadRejects va
	WHERE EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
SET IDENTITY_INSERT RadRejects OFF
GO

-- ServiceGroupItems
INSERT INTO ServiceGroupItems (GroupID,ServiceGroupID)
SELECT GroupID,ServiceGroupID
FROM Emerald..ServiceGroupItems
GO

-- ExternalSystemAccountTypes
INSERT INTO ExternalSystemAccountTypes (AccountTypeID,Description,ExternalRef,ExternalSystemID)
SELECT AccountTypeID,Description,ExternalRef,ExternalSystemID
FROM Emerald..ExternalSystemAccountTypes
GO

-- OperatorRoles
SET IDENTITY_INSERT OperatorRoles ON
INSERT INTO OperatorRoles (GroupID,MaxActive,OperatorID,OperatorRoleID,RoleID,ShowEscalate,ShowLate,TargetActive,Tier)
SELECT GroupID,MaxActive,OperatorID,OperatorRoleID,RoleID,ShowEscalate,ShowLate,TargetActive,Tier
FROM Emerald..OperatorRoles
SET IDENTITY_INSERT OperatorRoles OFF
GO

-- RadATConfigs
SET IDENTITY_INSERT RadATConfigs ON
INSERT INTO RadATConfigs (AccountTypeID,Data,RadATConfigID,RadAttributeID,RadCheck,RadVendorID,SortOrder,Tag)
SELECT AccountTypeID,CASE WHEN Data IS NULL OR Data = ' ' THEN CAST(COALESCE(Value,0) AS VARCHAR(20)) ELSE Data END AS Data,RadATConfigID,RadAttributeID,RadCheck,RadVendorID,COALESCE(SortOrder,0),Tag
FROM Emerald..RadATConfigs va
	WHERE EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
SET IDENTITY_INSERT RadATConfigs OFF
GO

-- RadATConfigs - Failure attributes
INSERT INTO RadATConfigs (AccountTypeID,Data,RadAttributeID,RadCheck,RadVendorID,SortOrder,Tag,RadFailReason)
SELECT oat.AccountTypeID,rac.Data,rac.RadAttributeID,rac.RadCheck,rac.RadVendorID,COALESCE(rac.SortOrder,0),rac.Tag,oat.RadFailReason
FROM Emerald..AccountTypes oat JOIN RadATConfigs rac ON (oat.RadFailAccountTypeID = rac.AccountTypeID)
	WHERE oat.RadFailReason > 0
	AND EXISTS (SELECT * FROM RadAttributes rav WHERE rac.RadVendorID = rav.RadVendorID AND rac.RadAttributeID = rav.RadAttributeID)
GO

-- RadConcurrency
INSERT INTO RadConcurrency (AccountTypeID,Connections,ConnectionsMax,Description,GroupID,LastSyncDate)
SELECT AccountTypeID,Connections,ConnectionsMax,Description,GroupID,LastSyncDate
FROM Emerald..RadConcurrency
GO

-- RadRoamDomains
SET IDENTITY_INSERT RadRoamDomains ON
INSERT INTO RadRoamDomains (AccountTypeID,Domain,Priority,RadRoamDomainID,RadRoamServerID)
SELECT AccountTypeID,Domain,Priority,RadRoamDomainID,RadRoamServerID
FROM Emerald..RadRoamDomains
SET IDENTITY_INSERT RadRoamDomains OFF
GO

-- Rates
SET IDENTITY_INSERT Rates ON
INSERT INTO Rates (AuthMaxTime,AuthRate,AuthRateTime,ChargeTypeID,ClassifierRateRuleID,DataRateRuleID,MaxCharge,MinCharge,Rate,RateClassID,RateID,RateSourceID)
SELECT AuthMaxTime,AuthRate,AuthRateTime,ChargeTypeID,ClassifierRateRuleID,DataRateRuleID,MaxCharge,MinCharge,Description,RateClassID,RateID,RateSourceID
FROM Emerald..Rates
SET IDENTITY_INSERT Rates OFF
GO

-- RateStdGroups
SET IDENTITY_INSERT RateStdGroups ON
INSERT INTO RateStdGroups (Cost,Description,Priority,RateRuleID,RateStdGroupID)
SELECT Cost,Description,Priority,RateRuleID,RateStdGroupID
FROM Emerald..RateStdGroups
SET IDENTITY_INSERT RateStdGroups OFF
GO

-- RateStdItems
SET IDENTITY_INSERT RateStdItems ON
INSERT INTO RateStdItems (Attribute,Data,RateMatchTypeID,RateStdGroupID,RateStdItemID)
SELECT Attribute,Data,RateMatchTypeID,RateStdGroupID,RateStdItemID
FROM Emerald..RateStdItems
SET IDENTITY_INSERT RateStdItems OFF
GO

-- ServerAccess
INSERT INTO ServerAccess (AccountTypeID,Allowed,MaxSessionLength,ServerID,AccessTime1)
SELECT AccountTypeID,CASE WHEN MaxSessionLength = -2 THEN 0 ELSE 1 END AS Allowed,MaxSessionLength,ServerID, 
CASE WHEN StartTime <> StopTime AND StartTime >= 0 AND StopTime >= 0 THEN 
CAST(StartTime / 60 AS VARCHAR(5)) + ':' + CAST(StartTime % 60 AS VARCHAR(5)) + ' - ' +
CAST(StopTime / 60 AS VARCHAR(5)) + ':' + CAST(StopTime % 60 AS VARCHAR(5)) END AS AccessTime1
FROM Emerald..ServerAccess
	WHERE Port IS NULL
GO

-- SubAccountDataTypes
INSERT INTO SubAccountDataTypes (AccountDataTypeID,AccountTypeID,DefaultData,Required,SortOrder)
SELECT AccountDataTypeID,AccountTypeID,DefaultData,Required,SortOrder
FROM Emerald..SubAccountDataTypes
GO

-- BatchProcessors
SET IDENTITY_INSERT BatchProcessors ON
INSERT INTO BatchProcessors (Active,BatchIn,BatchLimit,BatchOut,BatchProcessor,BatchProcessorID,CardTypes,ExportID,ExportOptions,GroupID,ImportOptions,Login,Merchant,OrganizationID,Password,ProcessorURL,RebatchInterval,RebatchTries,SortOrder,Store,Terminal)
SELECT Active,BatchIn,BatchLimit,BatchOut,BatchProcessor,BatchProcessorID,CardTypes,ExportID,ExportOptions,GroupID,ImportOptions,Login,Merchant,OrganizationID,Password,ProcessorURL,RebatchInterval,RebatchTries,SortOrder,Store,Terminal
FROM Emerald..BatchProcessors
SET IDENTITY_INSERT BatchProcessors OFF
GO

-- PackageTypes
SET IDENTITY_INSERT ServiceCategories ON
INSERT INTO ServiceCategories (ServiceCategoryID,ServiceCategory,StringID,AllowRoot,SortOrder) 
SELECT PackageTypeID,PackageType,StringID,0,100
FROM Emerald..PackageTypes
SET IDENTITY_INSERT ServiceCategories OFF
GO

-- ServiceCategories
INSERT INTO ServiceCategories (ServiceCategory,AllowRoot,SortOrder) VALUES('Emerald5 Services',1,1000)
INSERT INTO ServiceCategories (ServiceCategory,AllowRoot,SortOrder) VALUES('Emerald5 Packages',1,1000)

-- ServiceCatAccountTypes
INSERT INTO ServiceCatAccountTypes (ServiceCategoryID,AccountTypeID)
SELECT sc.ServiceCategoryID,at1.AccountTypeID
FROM AccountTypes at1 JOIN ServiceCategories sc ON (sc.ServiceCategory = 'Emerald5 Services')
	WHERE RateTimeLeft IS NULL

INSERT INTO ServiceCatAccountTypes (ServiceCategoryID,AccountTypeID)
SELECT sc.ServiceCategoryID,at1.AccountTypeID
FROM AccountTypes at1 JOIN ServiceCategories sc ON (sc.ServiceCategory = 'Emerald5 Packages')
	WHERE RateTimeLeft IS NOT NULL
GO

-- ServiceCatLinks
INSERT INTO ServiceCatLinks (ParentServiceCategoryID,ServiceCategoryID)
SELECT sc.ServiceCategoryID,opt.PackageTypeID
FROM Emerald..PackageTypes opt JOIN ServiceCategories sc ON (sc.ServiceCategory IN ('Emerald5 Services','Emerald5 Packages'))
GO

-- CardBatchTypes
SET IDENTITY_INSERT CardBatchTypes ON
INSERT INTO CardBatchTypes (AccountTypeID,ActiveExpireDays,ActiveExpireMins,AllowDirectUse,Amount,BatchSize,BillingCycleID,CardBatchType,CardBatchTypeID,DataLeft,DirectAmount,DomainID,GroupID,InactiveExpireDays,LoginCardDigitID,PasswordCardDigitID,PayPeriodID,SalesPersonID,SendMethodID,ServiceCategoryID,TimeLeft)
SELECT AccountTypeID,ActiveExpireDays,ActiveExpireMins,AllowDirectUse,Amount,BatchSize,BillingCycleID,CardBatchType,CardBatchTypeID,DataLeft,DirectAmount,DomainID,GroupID,InactiveExpireDays,LoginCardDigitID,PasswordCardDigitID,PayPeriodID,SalesPersonID,SendMethodID,
CASE WHEN AccountTypeID IS NOT NULL THEN (SELECT MAX(ServiceCategoryID) FROM ServiceCategories WHERE ServiceCategory = 'Emerald5 Services') END AS ServiceCategoryID,TimeLeft
FROM Emerald..CardBatchTypes
SET IDENTITY_INSERT CardBatchTypes OFF
GO

-- CardBatches
SET IDENTITY_INSERT CardBatches ON
INSERT INTO CardBatches (AccountTypeID,Active,ActiveExpireDays,ActiveExpireMins,AllowDirect,Amount,BatchSize,BillingCycleID,CardBatch,CardBatchID,CardBatchTypeID,Comments,CreateDate,DataLeft,DirectAmount,DomainID,GroupID,InactiveExpireDate,LastModifyDate,LastModifyUser,LoginCardDigitID,LoginParm1,LoginParm2,LoginPrefix,OperatorID,PasswordCardDigitID,PasswordParm1,PasswordParm2,PayPeriodID,RangeStart,RangeStep,SalesPersonID,SendMethodID,ServiceCategoryID,TimeLeft)
SELECT cb.AccountTypeID,cb.Active,cb.ActiveExpireDays,cb.ActiveExpireMins,cb.AllowDirect,cb.Amount,cb.BatchSize,cb.BillingCycleID,cb.CardBatch,cb.CardBatchID,cb.CardBatchTypeID,cb.Comments,cb.CreateDate,cb.DataLeft,cb.DirectAmount,cb.DomainID,cb.GroupID,cb.InactiveExpireDate,cb.LastModifyDate,cb.LastModifyUser,cb.LoginCardDigitID,cb.LoginParm1,cb.LoginParm2,cb.LoginPrefix,
COALESCE(o.OperatorID,(SELECT MIN(OperatorID) FROM Operators)) AS OperatorID,cb.PasswordCardDigitID,cb.PasswordParm1,cb.PasswordParm2,cb.PayPeriodID,cb.RangeStart,cb.RangeStep,cb.SalesPersonID,cb.SendMethodID,
CASE WHEN cb.AccountTypeID IS NOT NULL THEN sc.ServiceCategoryID END AS ServiceCategoryID,cb.TimeLeft
FROM Emerald..CardBatches cb LEFT JOIN Operators o ON (cb.Operator = o.Operator)
	JOIN ServiceCategories sc ON (sc.ServiceCategory = 'Emerald5 Services')
SET IDENTITY_INSERT CardBatches OFF
GO

-- ObjectGroups
INSERT INTO ObjectGroups (Description,ObjectGroup,ObjectGroupID)
SELECT Description,ObjectGroup,ObjectGroupID
FROM Emerald..ObjectGroups
	WHERE ObjectGroupID >= 10000
GO

-- OperatorGroupAccess
INSERT INTO OperatorGroupAccess (AccessType,GroupID,ObjectGroupID,OperatorGroupID)
SELECT ooga.AccessType,ooga.GroupID,ooga.ObjectGroupID,ooga.OperatorGroupID
FROM Emerald..OperatorGroupAccess ooga JOIN ObjectGroups og ON (ooga.ObjectGroupID = og.ObjectGroupID)
	JOIN OperatorGroups opg ON (ooga.OperatorGroupID = opg.OperatorGroupID)
GO

-- OrgAccountTypes
INSERT INTO OrgAccountTypes (AccountTypeID,Comments,CustomerCost,OrganizationID,ResellerCost)
SELECT AccountTypeID,Comments,CustomerCost,OrganizationID,ResellerCost
FROM Emerald..OrgAccountTypes
GO

-- OrgPackageTypes
INSERT INTO OrgAccountTypes (AccountTypeID,Comments,CustomerCost,OrganizationID,ResellerCost)
SELECT pt.AccountTypeID,opt.Comments,opt.CustomerCost,opt.OrganizationID,opt.ResellerCost
FROM Emerald..OrgPackageTypes opt JOIN AccountTypes pt ON (opt.PackageTypeID = pt.RateTimeLeft)
GO

-- RateItems
SET IDENTITY_INSERT RateItems ON
INSERT INTO RateItems (RateID,RateItemID,RateRuleID,RateTimeGroupID)
SELECT RateID,RateItemID,RateRuleID,RateTimeGroupID
FROM Emerald..RateItems
SET IDENTITY_INSERT RateItems OFF
GO

-- CommissionItems
SET IDENTITY_INSERT CommissionItems ON
INSERT INTO CommissionItems (AccountTypeID,ChargeTypeID,Comments,CommissionGroupID,CommissionItemID,CommissionValue)
SELECT AccountTypeID,ChargeTypeID,Comments,CommissionGroupID,CommissionItemID,CommissionValue
FROM Emerald..CommissionItems
SET IDENTITY_INSERT CommissionItems OFF
GO

-- ServiceCatAccountTypes (PackageAccountTypes)
INSERT INTO ServiceCatAccountTypes (ServiceCategoryID,AccountTypeID,Cost1,MaxQty1,AllowCustCancel,AllowCustChangeLogin,AllowCustChangePass,AllowCustAdd,CustomerAccess,CustomerMax)
SELECT PackageTypeID,AccountTypeID,CASE WHEN MaxQty <= 0 THEN NULL ELSE 0.00 END, CASE WHEN MaxQty <= 0 THEN NULL ELSE MaxQty END,AllowCustCancel,AllowCustChangeLogin,AllowCustChangePass,AllowCustAdd, CASE WHEN AllowCustCancel = 0 AND AllowCustChangeLogin = 0 AND AllowCustChangePass = 0 AND AllowCustAdd = 0 THEN 0 ELSE 1 END,CustomerMax
FROM Emerald..PackageAccountTypes
GO

-- TimeCharges
SET IDENTITY_INSERT TimeCharges ON
INSERT INTO TimeCharges (AccountTypeID,ChargeTypeID,CustomerAccess,DataLeft,Days,Description,Minutes,Months,SortOrder,StringID,TimeCharge,TimeChargeID,TimeLeft)
SELECT AccountTypeID,ChargeTypeID,CustomerAccess,DataLeft,Days,Description,Minutes,Months,SortOrder,StringID,TimeCharge,TimeChargeID,TimeLeft
FROM Emerald..TimeCharges
	WHERE AccountTypeID IS NOT NULL
SET IDENTITY_INSERT TimeCharges OFF
GO

-- MasterAccounts
SET IDENTITY_INSERT MasterAccounts ON
INSERT INTO MasterAccounts (Active,Balance,BillDay,BillingCycleID,CancelDate,CancelReasonID,Comments,CreateDate,CreateUser,CreditLimit,CustomerID,ExternalRef,GroupID,LanguageID,LastModifyDate,LastModifyUser,LastReceived,PayPeriodID,PaymentTypeID,PendingBalance,ReferredByID,RegionID,SalesPersonID,SendMethodID,StartDate,TaxExemptions,TempExtension,TransHoldDate)
SELECT Active,ma.Balance,ma.BillDay,ma.BillingCycleID,ma.CancelDate,ma.CancelReasonID,ma.Comments,ma.CreateDate,COALESCE(ma.Operator,'Emerald5'),ma.OverLimit,ma.CustomerID,ma.PayInfo,ma.GroupID,ma.LanguageID,ma.LastModifyDate,ma.LastModifyUser,ma.LastReceived,ma.PayPeriodID,ma.PaymentTypeID,ma.PendingBalance,rb.ReferredByID,COALESCE(ma.RegionID,(SELECT MIN(RegionID) FROM Regions)),ma.SalesPersonID,ma.SendMethodID,ma.StartDate,ma.TaxExemptions,COALESCE(ma.OverDue,0),ma.TransHoldDate
FROM Emerald..MasterAccounts ma LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
SET IDENTITY_INSERT MasterAccounts OFF
GO

-- MasterAccounts - Addresses (Billing Address)
INSERT INTO Addresses (CustomerID,AddressTypeID,CountryID,StateID,CreateDate,CreateUser,Company,Address1,Address2,City,Zip,FirstName,LastName,PhoneHome,PhoneWork,PhoneFax,Email,LastModifyDate,LastModifyUser)
SELECT ma.CustomerID, at1.AddressTypeID, c.CountryID, s.StateID, ma.CreateDate, COALESCE(ma.Operator,'Emerald5'), ma.Company, ma.Address1, ma.Address2, ma.City, ma.Zip, ma.FirstName, ma.LastName, ma.PhoneHome, ma.PhoneWork, ma.PhoneFax, ma.Email, ma.LastModifyDate, ma.LastModifyUser
FROM Emerald..MasterAccounts ma JOIN AddressTypes at1 ON (at1.AddressType = 'Emerald5 - Billing Address')
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
GO

-- SubAccounts
SET IDENTITY_INSERT SubAccounts ON
INSERT INTO SubAccounts (AccountID,AccountTypeID,Active,BilledThru,CancelDate,CancelReasonID,Comments,Cost,CreateDate,CreateUser,CustomerID,DataLeft,DomainID,Email,EnableATConfigs,ExpireDate,Extension,InvoicedDays,LastDataRenewal,LastModifyDate,LastModifyUser,LastTimeRenewal,Login,LoginLimit,ParentAccountID,Password,PasswordChange,PayPeriodID,Recurring,RemoteAccess,SalesPersonID,SendBill,ServiceCategoryID,StartDate,TimeLeft)
SELECT sa.AccountID,sa.AccountTypeID,sa.Active,sa.BilledThru,sa.CancelDate,sa.CancelReasonID,sa.Comments,CASE WHEN sa.DiffCost = 1 THEN COALESCE(sa.Cost,0) END,sa.CreateDate,COALESCE(sa.Operator,'Emerald5'),sa.CustomerID,sa.DataLeft,sa.DomainID,sa.Email,CASE WHEN (SELECT COUNT(*) FROM Emerald..RadConfigs rc WHERE rc.AccountID = sa.AccountID) > 0 THEN 0 ELSE 1 END AS EnableATConfigs,sa.ExpireDate,CASE WHEN sa.Extension > 32767 THEN 32767 ELSE sa.Extension END,
COALESCE((SELECT SUM(CASE WHEN ii.Days > 0 THEN ii.Days ELSE ii.Quantity * 30 END) 
FROM Emerald..InvoiceItems ii JOIN Emerald..Invoices i ON (i.InvoiceID = ii.InvoiceID)
	WHERE ii.AccountID = sa.AccountID
	AND i.VoidDate IS NULL
	AND ii.ItemType = 3),0) AS InvoicedDays,COALESCE(sa.LastDataLeftDate,sa.LastTimeLeftDate),sa.LastModifyDate,sa.LastModifyUser,sa.LastTimeLeftDate,sa.Login,sa.LoginLimit,NULL AS ParentAccountID,Password,0 AS PasswordChange,PayPeriodID,1 AS Recurring,sa.RemoteAccess,sa.SalesPersonID,sa.SendBill,sc.ServiceCategoryID,sa.StartDate,sa.TimeLeft
FROM Emerald..SubAccounts sa JOIN ServiceCategories sc ON (sc.ServiceCategory = 'Emerald5 Services')
SET IDENTITY_INSERT SubAccounts OFF
GO

-- SubAccounts - Addresses (Service Contact)
INSERT INTO Addresses (CustomerID,AccountID,AddressTypeID,CreateDate,CreateUser,FirstName,LastName,PhoneHome,PhoneWork,Email,LastModifyDate,LastModifyUser)
SELECT sa.CustomerID, sa.AccountID, adt.AddressTypeID, sa.CreateDate,COALESCE(sa.Operator,'Emerald5') AS CreateUser,sa.FirstName,sa.LastName,sa.PhoneHome,sa.PhoneWork,sa.Email,sa.LastModifyDate,sa.LastModifyUser
FROM Emerald..MasterAccounts ma JOIN Emerald..SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AddressTypes adt ON (adt.AddressType = 'Emerald5 - Service Contact')
	WHERE (COALESCE(ma.FirstName,'') <> COALESCE(sa.FirstName,'') OR COALESCE(ma.LastName,'') <> COALESCE(sa.LastName,'') OR COALESCE(ma.PhoneHome,'') <> COALESCE(sa.PhoneHome,'') OR COALESCE(ma.PhoneWork,'') <> COALESCE(sa.PhoneWork,''))
GO

-- SubAccounts (Packages)
INSERT INTO SubAccounts (RateTimeLeft,AccountTypeID,Active,BilledThru,CancelDate,CancelReasonID,Comments,Cost,CreateDate,CreateUser,CustomerID,DomainID,EnableATConfigs,ExpireDate,Extension,InvoicedDays,LastModifyDate,LastModifyUser,PasswordChange,PayPeriodID,Recurring,RemoteAccess,SalesPersonID,SendBill,ServiceCategoryID,StartDate)
SELECT p.PackageID,at1.AccountTypeID,p.Active,p.BilledThru,p.CancelDate,p.CancelReasonID,p.Comments,CASE WHEN p.DiffCost = 1 THEN p.Cost END,COALESCE(p.CreateDate,getdate()),COALESCE(o.Operator,'Emerald5'),p.CustomerID,COALESCE((SELECT MIN(osa2.DomainID) FROM Emerald..SubAccounts osa2 WHERE osa2.PackageID = p.PackageID AND osa2.Active = 1),(SELECT MIN(DomainID) FROM Domains)) AS DomainID,0 AS EnableATConfigs,p.ExpireDate,CASE WHEN p.Extension > 32767 THEN 32767 ELSE COALESCE(p.Extension,0) END,
COALESCE((SELECT SUM(CASE WHEN ii.Days > 0 THEN ii.Days ELSE ii.Quantity * 30 END) 
FROM Emerald..InvoiceItems ii JOIN Emerald..Invoices i ON (i.InvoiceID = ii.InvoiceID)
	WHERE ii.PackageID = p.PackageID
	AND i.VoidDate IS NULL
	AND ii.ItemType = 3),0) AS InvoicedDays,COALESCE(p.LastModifyDate,p.CreateDate,getdate()),COALESCE(p.LastModifyUser,o.Operator,'Emerald5'),0 AS PasswordChange,p.PayPeriodID,1 AS Recurring,0 AS RemoteAccess,p.SalesPersonID,0 AS SendBill,sc.ServiceCategoryID,p.StartDate
FROM Emerald..Packages p JOIN ServiceCategories sc ON (sc.ServiceCategory = 'Emerald5 Packages')
	JOIN AccountTypes at1 ON (p.PackageTypeID = at1.RateTimeLeft)
	LEFT JOIN Operators o ON (p.CreateOperatorID = o.OperatorID)
GO

-- RadConfigs
SET IDENTITY_INSERT RadConfigs ON
INSERT INTO RadConfigs (AccountID,Data,RadAttributeID,RadCheck,RadConfigID,RadVendorID,Tag)
SELECT AccountID,CASE WHEN Data IS NULL OR Data = ' ' THEN CAST(COALESCE(Value,0) AS VARCHAR(20)) ELSE Data END AS Data,RadAttributeID,RadCheck,RadConfigID,RadVendorID,Tag
FROM Emerald..RadConfigs va
	WHERE EXISTS (SELECT * FROM RadAttributes rav WHERE va.RadVendorID = rav.RadVendorID AND va.RadAttributeID = rav.RadAttributeID)
SET IDENTITY_INSERT RadConfigs OFF
GO

-- Organization (CustomerID)
UPDATE o SET ResellerCustomerID = oo.ResellerCustomerID
FROM Organizations o JOIN Emerald..Organizations oo ON (o.OrganizationID = oo.OrganizationID)
	WHERE oo.ResellerCustomerID IS NOT NULL
GO

UPDATE d SET GroupID = od.GroupID, CustomerID = od.CustomerID
FROM Domains d JOIN Emerald..Domains od ON (d.DomainID = od.DomainID)
	WHERE (od.GroupID IS NOT NULL OR od.CustomerID IS NOT NULL)
GO

-- PosixAccountUsers
SET IDENTITY_INSERT PosixAccountUsers ON
INSERT INTO PosixAccountUsers (AccountID,PosixAccountServerID,PosixAccountUserID,gidNumber,homeDirectory,loginShell,uidNumber,userPassword)
SELECT pau.AccountID,pau.PosixAccountServerID,pau.PosixAccountUserID,pau.gidNumber,pau.homeDirectory,pau.loginShell,pauid.uidNumber,pau.userPassword
FROM Emerald..PosixAccountUsers pau JOIN Emerald..PosixAccountUIDs pauid ON (pau.PosixAccountUserID = pauid.PosixAccountUserID)
SET IDENTITY_INSERT PosixAccountUsers OFF
GO

-- RateHistory
INSERT INTO RateHistory (AccountID,ChargeID,CustomerID,RateID,RateRuleID,StartDate,TotalCost,TotalCount,TotalData,TotalSessions,TotalTime)
SELECT AccountID,ChargeID,CustomerID,RateID,RateRuleID,StartDate,TotalCost,TotalCount,TotalData,0 AS TotalSessions,TotalTime
FROM Emerald..RateHistory
GO

-- AuditLogs
INSERT INTO AuditLogs (AccountID,CustomerID,LogDate,LogMsg,LogMsgID,Operator)
SELECT AccountID,CustomerID,LogDate,LogMsg,LogMsgID,Operator
FROM Emerald..AuditLogs
GO

-- NoticeActives
INSERT INTO NoticeActives (AccountID,CustomerID,NoticeID,SubTokenID,TokenID)
SELECT AccountID,CustomerID,NoticeID,SubTokenID,TokenID
FROM Emerald..NoticeActives
GO

-- Addresses
INSERT INTO Addresses (CustomerID,Address1,Address2,AddressTypeID,City,Comments,Company,CountryID,CreateDate,CreateUser,Email,FirstName,LastModifyDate,LastModifyUser,LastName,PhoneFax,PhoneHome,Province,StateID,WWW,Zip,SMSNoticePurposeMask,EmailNoticePurposeMask)
SELECT CustomerID,Address1,Address2,AddressTypeID,City,Comments,Company,CountryID,getdate() AS CreateDate,'Emerald5' AS CreateUser,Email,FirstName,getdate() AS LastModifyDate,'Emerald5' AS LastModifyUser,LastName,Fax,Phone,Province,StateID,WWW,Zip,0,0
FROM Emerald..Addresses
GO

-- BankTrans
INSERT INTO BankTrans (ABANumber,AccountNumber,AuthName,BankName,BankPhone,BirthDate,CustomerID,DLNumber,DLState,LastModifyDate,LastModifyUser,SSN,TransType)
SELECT ABANumber,AccountNumber,AuthName,BankName,BankPhone,BirthDate,CustomerID,DLNumber,DLState,LastModifyDate,LastModifyUser,SSN,TransType
FROM Emerald..BankTrans
GO

-- CreditCards
INSERT INTO CreditCards (Bank,BankPhone,BillToAddress1,BillToAddress2,BillToCity,BillToCountryID,BillToStateID,BillToZip,CardHolder,CardLength,CardNumber,CardTypeID,CustomerID,ExpirationDate,LastModifyDate,LastModifyUser,Misc1,Misc2,SecurityCode)
SELECT Bank,BankPhone,BillToAddress1,BillToAddress2,BillToCity,BillToCountryID,BillToStateID,BillToZip,CardHolder,CardLength,CardNumber,CardTypeID,CustomerID,ExpirationDate,LastModifyDate,LastModifyUser,Misc1,Misc2,SecurityCode
FROM Emerald..CreditCards
GO

-- CustomerSettings
UPDATE a SET EmailNoticePurposeMask = 1 + 16 + 
CASE WHEN NotifyAcctLimit = 1 THEN 4 ELSE 0 END + 
CASE WHEN NotifyIncidents = 1 THEN 8 ELSE 0 END + 
CASE WHEN NotifyAnnounce = 1 THEN 32 ELSE 0 END + 
CASE WHEN NotifyAcctStatus = 1 THEN 2 ELSE 0 END + 
CASE WHEN NotifyOffers = 1 THEN 64 ELSE 0 END
FROM Addresses a JOIN Emerald..CustomerSettings ocs ON (a.CustomerID = ocs.CustomerID)
	WHERE (ocs.NotifyAcctLimit = 0 OR ocs.NotifyIncidents = 0 OR ocs.NotifyAnnounce = 0 OR ocs.NotifyAcctStatus = 0 OR ocs.NotifyShipStatus = 0 OR ocs.NotifyOffers = 0)

UPDATE Addresses SET SMSNoticePurposeMask = 0
GO

-- Aliases
SET IDENTITY_INSERT Aliases ON
INSERT INTO Aliases (AccountID,Alias,AliasID,CreateDate,LastModifyDate,LastModifyUser)
SELECT AccountID,Alias,AliasID,CreateDate,LastModifyDate,LastModifyUser
FROM Emerald..Aliases
SET IDENTITY_INSERT Aliases OFF
GO

-- Forwards
SET IDENTITY_INSERT Forwards ON
INSERT INTO Forwards (AccountID,CreateDate,Forward,ForwardID,LastModifyDate,LastModifyUser)
SELECT AccountID,CreateDate,Forward,ForwardID,LastModifyDate,LastModifyUser
FROM Emerald..Forwards
SET IDENTITY_INSERT Forwards OFF
GO

-- MasterAccountData
INSERT INTO MasterAccountData (AccountDataTypeID,CustomerID,Data)
SELECT mad.AccountDataTypeID,mad.CustomerID,CASE WHEN mad.Data = ' ' THEN NULL ELSE mad.Data END
FROM Emerald..MasterAccountData mad JOIN AccountDataTypes adt ON (mad.AccountDataTypeID = adt.AccountDataTypeID)
GO

-- SubAccountData
INSERT INTO SubAccountData (AccountDataTypeID,AccountID,Data)
SELECT AccountDataTypeID,AccountID,CASE WHEN Data = ' ' THEN NULL ELSE Data END
FROM Emerald..SubAccountData
GO

-- Incidents
SET IDENTITY_INSERT Incidents ON
INSERT INTO Incidents (AccountID,AssignOperatorID,AssignRoleID,CreateAccountID,CreateDate,CreateOperatorID,CustomerAccess,sa.CustomerID,Description,DueDate,Duration,Email,IncidentID,IncidentStateID,IncidentTypeID,LastModifyDate,LastModifyUser,PriorityID,Summary)
SELECT i.AccountID,i.AssignOperatorID,i.AssignRoleID,csa.AccountID,i.CreateDate,co.OperatorID,i.CustomerAccess,sa.CustomerID,i.Description,i.DueDate,i.Duration,i.Email,i.IncidentID,i.IncidentStateID,i.IncidentTypeID,i.LastModifyDate,i.LastModifyUser,i.PriorityID,i.Summary
FROM Emerald..Incidents i JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN SubAccounts csa ON (i.CreateAccountID = csa.AccountID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
SET IDENTITY_INSERT Incidents OFF
GO

-- IncidentData
INSERT INTO IncidentData (Data,IncidentDataTypeID,IncidentID)
SELECT Data,IncidentDataTypeID,IncidentID
FROM Emerald..IncidentData
GO

-- Actions
SET IDENTITY_INSERT Actions ON
INSERT INTO Actions (ActionID,AssignOperatorID,AssignRoleID,CreateAccountID,CreateDate,CreateOperatorID,CustomerAccess,Description,Duration,IncidentID,IncidentStateID,IncidentTypeID,LastModifyDate,LastModifyUser)
SELECT ActionID,AssignOperatorID,AssignRoleID,CreateAccountID,CreateDate,CreateOperatorID,CustomerAccess,Description,Duration,IncidentID,IncidentStateID,IncidentTypeID,LastModifyDate,LastModifyUser
FROM Emerald..Actions
SET IDENTITY_INSERT Actions OFF
GO

-- Payments
SET IDENTITY_INSERT Payments ON
INSERT INTO Payments (Amount,BatchID,CheckNumber,CreateDate,CreateUser,CustomerID,DistFlag,FinalAmount,FinalCreateDate,LastModifyDate,LastModifyUser,PayInfo,PaymentID,PaymentTypeID,ProcTransID)
SELECT p.Amount,b.BatchID,p.CheckNumber,p.CreateDate,p.LastModifyUser,p.CustomerID,p.DistFlag,p.FinalAmount,p.FinalCreateDate,p.LastModifyDate,p.LastModifyUser,p.PayInfo,p.PaymentID,p.PaymentTypeID,p.ProcTransID
FROM Emerald..Payments p LEFT JOIN Batches b ON (p.BatchID = b.BatchID)
SET IDENTITY_INSERT Payments OFF
GO

-- Invoices
SET IDENTITY_INSERT Invoices ON
INSERT INTO Invoices (Amount,BatchID,ChargeAmount,Comments,CreateDate,CustomerID,EmailDate,Estimate,ExtInvoiceNum,InvoiceID,InvoiceTypeID,LastModifyDate,LastModifyUser,PO,PaidAmount,PrintBatchID,PrintDate,Processed,Tax,VoidDate)
SELECT Amount,BatchID,ChargeAmount,Comments,CreateDate,CustomerID,EmailDate,Estimate,ExtInvoiceNum,InvoiceID,CASE WHEN InvoiceTypeID IN (9,90) THEN 5 ELSE InvoiceTypeID END,LastModifyDate,LastModifyUser,CASE WHEN Comments LIKE 'PO%' AND DATALENGTH(Comments) <= 25 THEN Comments ELSE PO END,PaidAmount,PrintBatchID,PrintDate,Processed,Tax,VoidDate
FROM Emerald..Invoices
SET IDENTITY_INSERT Invoices OFF
GO

-- Statements
SET IDENTITY_INSERT Statements ON
INSERT INTO Statements (BatchID,CustomerID,DueDate,EmailDate,End0Bal,End120Bal,End30Bal,End60Bal,End90Bal,EndBal,NewCharges,NewCredits,PrevBal,PrintBatchID,PrintDate,StatementDate,StatementID)
SELECT BatchID,CustomerID,DueDate,EmailDate,End0Bal,End120Bal,End30Bal,End60Bal,End90Bal,EndBal,NewCharges,NewCredits,PrevBal,PrintBatchID,PrintDate,StatementDate,StatementID
FROM Emerald..Statements
SET IDENTITY_INSERT Statements OFF
GO

-- Statement Update (MasterAccounts)
UPDATE ma SET LastStatementID = s.StatementID
FROM MasterAccounts ma JOIN (SELECT CustomerID, MAX(StatementID) AS StatementID FROM Statements GROUP BY CustomerID) s ON (ma.CustomerID = s.CustomerID)
GO

-- Statement Update (Payments)
UPDATE p SET StatementID = op.StatementID
FROM Payments p JOIN Emerald..Payments op ON (p.PaymentID = op.PaymentID)
	WHERE op.StatementID IS NOT NULL

UPDATE p SET FinalStatementID = CASE WHEN EXISTS (SELECT * FROM Statements s WHERE s.StatementID = op.FinalStatementID) THEN op.FinalStatementID ELSE op.StatementID END
FROM Payments p JOIN Emerald..Payments op ON (p.PaymentID = op.PaymentID)
	WHERE op.FinalStatementID IS NOT NULL
GO

-- Statement Update (Invoices)
UPDATE i SET StatementID = oi.StatementID
FROM Invoices i JOIN Emerald..Invoices oi ON (i.InvoiceID = oi.InvoiceID)
	WHERE oi.StatementID IS NOT NULL

UPDATE i SET VoidStatementID = CASE WHEN EXISTS (SELECT * FROM Statements s WHERE s.StatementID = oi.VoidStatementID) THEN oi.VoidStatementID ELSE oi.StatementID END
FROM Invoices i JOIN Emerald..Invoices oi ON (i.InvoiceID = oi.InvoiceID)
	WHERE oi.VoidStatementID IS NOT NULL
GO

-- ExternalTrans
SET IDENTITY_INSERT ExternalTrans ON
INSERT INTO ExternalTrans (AccountExpire,AccountNumber,Amount,ApproveCode,AuthAddress,AuthName,AuthSecurityCode,AuthStateID,AuthZip,AutoBill,BankName,BankNumber,BankPhone,BankTransType,BatchID,BatchInID,BatchOutID,BatchProcessorID,BirthDate,CustomerID,DLNumber,DLState,ExportDate,ExternalTransID,InvoiceID,LastModifyDate,LastModifyUser,LastRebatchTry,PaymentID,ProcDate,ProcTransID,RebatchTries,ReqDate,Response,SSN,TransStateID,TransTypeID)
SELECT et.AccountExpire,et.AccountNumber,et.Amount,et.ApproveCode,et.AuthAddress,et.AuthName,et.AuthSecurityCode,et.AuthStateID,et.AuthZip,et.AutoBill,et.BankName,et.BankNumber,et.BankPhone,et.BankTransType,et.BatchID,et.BatchInID,et.BatchOutID,et.BatchProcessorID,et.BirthDate,et.CustomerID,et.DLNumber,et.DLState,et.ExportDate,et.ExternalTransID,et.InvoiceID,et.LastModifyDate,et.LastModifyUser,et.LastRebatchTry,et.PaymentID,et.ProcDate,et.ProcTransID,et.RebatchTries,et.ReqDate,et.Response,et.SSN,et.TransStateID,et.TransTypeID
FROM Emerald..ExternalTrans et JOIN Emerald..MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
SET IDENTITY_INSERT ExternalTrans OFF
GO

-- ExternalSyncs
SET IDENTITY_INSERT ExternalSyncs ON
INSERT INTO ExternalSyncs (AccountID,Active,Aux1,Aux2,Aux3,Aux4,Aux5,Aux6,Aux7,Aux8,CreateDate,Created,ErrorCount,ExternalSyncID,ExternalSystemID,LastModifyDate,LastUpdate,Login,Message,Password,ProcTransID)
SELECT AccountID,Active,Aux1,Aux2,Aux3,Aux4,Aux5,Aux6,Aux7,Aux8,CreateDate,Created,ErrorCount,ExternalSyncID,ExternalSystemID,LastModifyDate,LastUpdate,Login,Message,Password,ProcTransID
FROM Emerald..ExternalSyncs
SET IDENTITY_INSERT ExternalSyncs OFF
GO

-- CardAccounts
SET IDENTITY_INSERT CardAccounts ON
INSERT INTO CardAccounts (Active,AllowCredit,AllowDirect,CardAccountID,CardBatchID,CreditAmount,DirectAccountID,DirectCustomerID,FirstUseDate,InactiveExpireDate,LastCreditDate,Login,OrganizationID,Password,UsedForCredit,UsedForDirect)
SELECT Active,AllowCredit,AllowDirect,CardAccountID,CardBatchID,CreditAmount,DirectAccountID,DirectCustomerID,FirstUseDate,InactiveExpireDate,LastCreditDate,Login,OrganizationID,Password,UsedForCredit,UsedForDirect
FROM Emerald..CardAccounts
SET IDENTITY_INSERT CardAccounts OFF
GO

-- Charges
SET IDENTITY_INSERT Charges ON
INSERT INTO Charges (AccountID,AccountTypeID,AllowInterim,Amount,ChargeID,ChargeTypeID,CreateDate,CreateUser,CustomerID,Description,DistFlag,EndDate,LastModifyDate,LastModifyUser,Quantity,StartDate,TaxExemptions,TaxGroupID)
SELECT AccountID,AccountTypeID,AllowInterim,Amount,ChargeID,ChargeTypeID,LastModifyDate,LastModifyUser,CustomerID,Description,DistFlag,EndDate,LastModifyDate,LastModifyUser,Quantity,StartDate,TaxExemptions,TaxGroupID
FROM Emerald..Charges
SET IDENTITY_INSERT Charges OFF
GO

-- Apply Emerald 5 package hierarchy
UPDATE sa SET ServiceCategoryID = op.PackageTypeID, ParentAccountID = p.AccountID, CancelReasonID = COALESCE(sa.CancelReasonID,p.CancelReasonID), CancelDate = CASE WHEN p.CancelDate < sa.CancelDate THEN p.CancelDate ELSE COALESCE(sa.CancelDate,p.CancelDate) END, Active = CASE WHEN p.Active = 0 THEN p.Active ELSE sa.Active END
FROM SubAccounts sa JOIN Emerald..SubAccounts osa ON (sa.AccountID = osa.AccountID)
	JOIN Emerald..Packages op ON (osa.PackageID = op.PackageID)
	JOIN SubAccounts p ON (op.PackageID = p.RateTimeLeft)

-- Packages not having at least one active service not invoiced in v5
UPDATE psa SET Active = 0
FROM SubAccounts psa
	WHERE psa.Active = 1
	AND psa.RateTimeLeft IS NOT NULL
	AND NOT EXISTS (SELECT * FROM SubAccounts csa WHERE psa.AccountID = csa.ParentAccountID AND csa.Active = 1 AND (csa.CancelDate IS NULL OR csa.CancelDate > psa.BilledThru))
GO

-- InvoiceItems
SET IDENTITY_INSERT InvoiceItems ON
INSERT INTO InvoiceItems (AccountID,AccountTypeID,Amount,BaseAmount,ChargeID,ChargeTypeID,Days,Description,EndDate,InvoiceID,ItemID,ItemType,Login,PaidAmount,PaidFlag,Quantity,StartDate,TaxGroupID,TaxID)
SELECT COALESCE(p.AccountID,ii.AccountID),COALESCE(pat.AccountTypeID,ii.AccountTypeID),ii.Amount,ii.Amount,ii.ChargeID,ii.ChargeTypeID,ii.Days,ii.Description,ii.EndDate,ii.InvoiceID,ii.ItemID,ii.ItemType,ii.Login,ii.PaidAmount,ii.PaidFlag,ii.Quantity,ii.StartDate,ii.TaxGroupID,ii.TaxID
FROM Emerald..InvoiceItems ii LEFT JOIN AccountTypes pat ON (ii.PackageTypeID = pat.RateTimeLeft)
	LEFT JOIN 
		(
		SELECT AccountID, RateTimeLeft AS PackageID
		FROM SubAccounts
			WHERE RateTimeLeft IS NOT NULL
		) p ON (ii.PackageID = p.PackageID)
SET IDENTITY_INSERT InvoiceItems OFF
GO

-- Charges (ItemID)
UPDATE c SET ItemID = oc.ItemID
FROM Charges c JOIN Emerald..Charges oc ON (c.ChargeID = oc.ChargeID)
	WHERE oc.ItemID IS NOT NULL
GO

-- PaymentItems
SET IDENTITY_INSERT PaymentItems ON
INSERT INTO PaymentItems (ActiveDate,Amount,ChargeID,InactiveDate,ItemID,PaymentID,PaymentItemID)
SELECT ActiveDate,Amount,ChargeID,InactiveDate,ItemID,PaymentID,PaymentItemID
FROM Emerald..PaymentItems
SET IDENTITY_INSERT PaymentItems OFF
GO

-- InvoiceSubAccounts
INSERT INTO InvoiceSubAccounts (InvoiceID,AccountID,BilledThru,InvoicedDays)
SELECT i.InvoiceID, sa.AccountID, DATEADD(dd,-1,MIN(ii.StartDate)) AS BilledThru, 0 AS InvoicedDays
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID AND ma.CustomerID = sa.CustomerID)
	LEFT JOIN InvoiceSubAccounts isa ON (i.InvoiceID = isa.InvoiceID AND sa.AccountID = isa.AccountID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType IN (2,3)
 	AND ii.StartDate <= ii.EndDate
	AND ma.Active = 1
	AND sa.Active = 1
	AND i.Processed = 1
	AND isa.InvoiceID IS NULL
GROUP BY i.InvoiceID, sa.AccountID
GO

-- ResellerUsage
INSERT INTO ResellerUsage (AccountID,AccountTypeID,Days,ItemID,LastUpdate,StartMonth,StartYear)
SELECT AccountID,AccountTypeID,Days,ItemID,LastUpdate,StartMonth,StartYear
FROM Emerald..ResellerUsage
go

-- SubAccountUsages
SET IDENTITY_INSERT SubAccountUsages ON
INSERT INTO SubAccountUsages (AccountID,DataLeft,ExpireDate,ItemID,StartDataLeft,StartTimeLeft,SubAccountUsageID,TimeLeft)
SELECT AccountID,DataLeft,ExpireDate,ItemID,StartDataLeft,StartTimeLeft,SubAccountUsageID,TimeLeft
FROM Emerald..SubAccountUsages
SET IDENTITY_INSERT SubAccountUsages OFF
GO

-- VoiceCalls
SET IDENTITY_INSERT VoiceCalls ON
INSERT INTO VoiceCalls (AccountID,AcctTerminateCause,Bytes,CallDate,CallType,CalledNumber,CalledPort,CallingPort,ChargeID,Cost,CountryID,Duration,ErrorCode,Location,Login,ProcDate,SessionRef,StateID,VoiceCallID)
SELECT AccountID,AcctTerminateCause,Bytes,CallDate,CallType,CalledNumber,CalledPort,CallingPort,ChargeID,Cost,CountryID,Duration,ErrorCode,Location,Login,ProcDate,SessionRef,StateID,VoiceCallID
FROM Emerald..VoiceCalls
SET IDENTITY_INSERT VoiceCalls OFF
GO

-- SubAccounts (Static Cost)
INSERT INTO MarketCategories (MarketCategory,SortOrder) VALUES('Emerald5',1000)

INSERT INTO MarketTags (MarketTag,MarketCategoryID,MarketTagAutoTypeID,AllowServiceCost,SortOrder)
SELECT 'Static Cost', mc.MarketCategoryID,4 AS MarketTagAutoTypeID,1 AS AllowServiceCost,1000
FROM MarketCategories mc
	WHERE mc.MarketCategory = 'Emerald5'

-- SubAccountTags
INSERT INTO SubAccountTags (AccountID,MarketTagID,Active,Cost,CreateDate,CreateUser)
SELECT sa.AccountID, mt.MarketTagID, 1 AS Active, sa.Cost AS Cost, getdate() AS CreateDate, 'Emerald5' AS CreateUser
FROM SubAccounts sa JOIN MarketCategories mc ON (mc.MarketCategory = 'Emerald5')
	JOIN MarketTags mt ON (mt.MarketCategoryID = mc.MarketCategoryID AND mt.MarketTag = 'Static Cost')
	WHERE sa.Cost IS NOT NULL

UPDATE SubAccounts SET Cost = NULL WHERE Cost IS NOT NULL
GO

-- SubAccounts (Discounts)
INSERT INTO SubAccountTags (AccountID,MarketTagID,Active,CreateDate,CreateUser)
SELECT sa.AccountID, mt.MarketTagID, 1 AS Active, getdate() AS CreateDate, 'Emerald5' AS CreateUser
FROM SubAccounts sa JOIN MarketCategories mc ON (mc.MarketCategory = 'Emerald5 - Discounts')
	JOIN Emerald..SubAccounts osa ON (sa.AccountID = osa.AccountID)
	JOIN MarketTags mt ON (mc.MarketCategoryID = mt.MarketCategoryID AND osa.DiscountID = mt.DiscountID)
	WHERE sa.ParentAccountID IS NULL
GO

-- Packages (Discounts)
INSERT INTO SubAccountTags (AccountID,MarketTagID,Active,CreateDate,CreateUser)
SELECT sa.AccountID, mt.MarketTagID, 1 AS Active, getdate() AS CreateDate, 'Emerald5' AS CreateUser
FROM SubAccounts sa JOIN MarketCategories mc ON (mc.MarketCategory = 'Emerald5 - Discounts')
	JOIN Emerald..Packages op ON (sa.RateTimeLeft = op.PackageID)
	JOIN MarketTags mt ON (mc.MarketCategoryID = mt.MarketCategoryID AND op.DiscountID = mt.DiscountID)
GO

-- Introductory offers (SubAccounts)
INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,AccountTypeID,AllowReinvoice,CreateUser)
SELECT ma.CustomerID, osa.AccountID, getdate(), DATEADD(dd,1,DATEADD(mm,oat.NextCount - osa.CycleMonths,osa.BilledThru)), oat.NextID, 0, 'Emerald5'
FROM MasterAccounts ma JOIN Emerald..SubAccounts osa ON (ma.CustomerID = osa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Emerald..AccountTypes oat ON (osa.AccountTypeID = oat.AccountTypeID)
	WHERE ma.Active = 1
	AND osa.Active = 1
	AND bc.AutoBill IN (0,1)
	AND oat.NextCount IS NOT NULL
	AND oat.NextID IS NOT NULL
	AND osa.CycleMonths < oat.NextCount
	AND (ma.CancelDate IS NULL OR DATEADD(dd,1,DATEADD(mm,oat.NextCount - osa.CycleMonths,osa.BilledThru)) < ma.CancelDate)
	AND (osa.CancelDate IS NULL OR DATEADD(dd,1,DATEADD(mm,oat.NextCount - osa.CycleMonths,osa.BilledThru)) < osa.CancelDate)
	AND oat.NextID <> osa.AccountTypeID
GO

-- Introductory offers (Packages)
INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,AccountTypeID,AllowReinvoice,CreateUser)
SELECT ma.CustomerID, sa.AccountID, getdate(), DATEADD(dd,1,DATEADD(mm,opt.NextCount - op.CycleMonths,sa.BilledThru)), at1.AccountTypeID, 0, 'Emerald5'
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Emerald..Packages op ON (sa.RateTimeLeft = op.PackageID)
	JOIN Emerald..PackageTypes opt ON (op.PackageTypeID = opt.PackageTypeID)
	JOIN AccountTypes at1 ON (opt.NextID = at1.RateTimeLeft)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND bc.AutoBill IN (0,1)
	AND opt.NextCount IS NOT NULL
	AND opt.NextID IS NOT NULL
	AND op.CycleMonths < opt.NextCount
	AND (ma.CancelDate IS NULL OR DATEADD(dd,1,DATEADD(mm,opt.NextCount - op.CycleMonths,sa.BilledThru)) < ma.CancelDate)
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,DATEADD(mm,opt.NextCount - op.CycleMonths,sa.BilledThru)) < sa.CancelDate)
	AND opt.NextID <> op.PackageTypeID
GO

-- AccountChanges (MasterAccounts Cancel)
INSERT INTO AccountChanges (CustomerID,ActiveDate,EffectiveDate,CancelReasonID,AllowReinvoice,CreateUser)
SELECT ma.CustomerID, getdate(), ma.CancelDate, ma.CancelReasonID, 0, 'Emerald5'
FROM MasterAccounts ma
	WHERE ma.Active IN (1,0)
	AND ma.CancelDate IS NOT NULL
	AND ma.CancelReasonID IS NOT NULL
GO

-- AccountChanges (SubAccounts Cancel)
INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,CancelReasonID,AllowReinvoice,CreateUser)
SELECT sa.CustomerID, sa.AccountID, getdate(), sa.CancelDate, sa.CancelReasonID, 0, 'Emerald5'
FROM SubAccounts sa
	WHERE sa.Active IN (1,0)
	AND sa.CancelDate IS NOT NULL
	AND sa.CancelReasonID IS NOT NULL
GO

-- PayPeriod Discounts
INSERT INTO MarketCategories (MarketCategory,SortOrder) VALUES('Emerald5 - Pay Periods',1000)

INSERT INTO Discounts (Amount,AmountType,Discount,SortOrder,StringID)
SELECT Amount,AmountType,'Pay Period - ' + PayPeriod,1000,PayPeriodID
FROM Emerald..PayPeriods
	WHERE Amount <> 0

INSERT INTO MarketTags (MarketTag,StringID,MarketCategoryID,MarketTagAutoTypeID,PayPeriodID,DiscountID,SortOrder)
SELECT opp.PayPeriod, opp.StringID, mc.MarketCategoryID,5 AS MarketTagAutoTypeID,opp.PayPeriodID,d.DiscountID,1000
FROM Emerald..PayPeriods opp JOIN Discounts d ON (d.Discount LIKE 'Pay Period - %' AND d.StringID = opp.PayPeriodID)
	JOIN MarketCategories mc ON (mc.MarketCategory = 'Emerald5 - Pay Periods')

UPDATE Discounts SET StringID = NULL WHERE Discount LIKE 'Pay Period - %' AND StringID IS NOT NULL
GO

-- SignupServers
SET IDENTITY_INSERT SignupServers ON
INSERT INTO SignupServers (AddressTypeID,AltAddressTypeID,Comments,CountryID,DomainID,GroupID,LoginFillType,PaymentTypes,PrepaidTransfer,RegionID,SalesPersonID,SendMethodID,ShowAddress,ShowCompany,ShowEmail,ShowLogin,ShowPhone,ShowReferredBy,SignupServer,SignupServerID,ThemeID,Title)
SELECT adt.AddressTypeID,os.AddressTypeID,os.Description,os.CountryID,os.DomainID,os.GroupID,os.LoginFillType,41 AS PaymentTypes,COALESCE(os.PrepaidTransfer,0),os.RegionID,os.SalesPersonID,COALESCE((SELECT MIN(SendMethodID) FROM SendMethods WHERE EmailTypeID=1),(SELECT MIN(SendMethodID) FROM SendMethods)) AS SendMethodID,os.ShowAddress,os.ShowCompany,os.ShowEmail,COALESCE(os.ShowLogin,0),os.ShowPhone,os.ShowReferredBy,os.SignupServer,os.SignupServerID,os.ThemeID,os.Title
FROM Emerald..SignupServers os JOIN AddressTypes adt ON (adt.AddressType = 'Emerald5 - Billing Address')
SET IDENTITY_INSERT SignupServers OFF
GO

--SignupOptions (Recurring)
INSERT INTO SignupOptions (SignupOption,SignupServerID,ServiceCategoryID,AccountTypeID,BillingCycleID,PayPeriodID,SetupCharge,Active,SortOrder,CustomerDescription)
SELECT MIN(pt.PackageType), ss.SignupServerID, scs.ServiceCategoryID, pat.AccountTypeID, MIN(pt.BillingCycleID), MIN(pt.PayPeriodID), MIN(ss.SetupCharge), MIN(pt.Active),MIN(pt.SortOrder),MIN(CAST(pt.CustomerDescription AS VARCHAR(4000)))
FROM Emerald..PackageTypes pt
	JOIN BillingCycles bc ON (pt.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ServiceGroups sg ON (pt.ServiceGroupID = sg.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgi ON (pt.ServiceGroupID = sgi.ServiceGroupID)
	JOIN Emerald..SignupServers ss ON (pt.GroupID IS NULL OR pt.GroupID = ss.GroupID OR sgi.GroupID = ss.GroupID)
	JOIN ServiceCategories scs ON (scs.ServiceCategory = 'Emerald5 Services')
	JOIN Emerald..PackageAccountTypes pat ON (pt.PackageTypeID = pat.PackageTypeID AND pt.PrimaryAccountTypeID = pat.AccountTypeID)
	WHERE pt.Active = 1
	AND pt.CustomerAccess = 1
	AND pt.CustomerSignup = 1
	AND pt.PrimaryAccountTypeID IS NOT NULL
	AND pt.PayPeriodID IS NOT NULL
	AND bc.AutoBill IN (0,1)
	AND (ss.PackageTypeID IS NULL OR pt.PackageTypeID = ss.PackageTypeID OR pt.PackageTypeID IN (SELECT PackageTypeID FROM Emerald..SignupPackageTypes spt WHERE spt.SignupServerID = ss.SignupServerID))
	AND (pt.StartDate IS NULL OR pt.StartDate <= getdate())
	AND (pt.EndDate IS NULL OR pt.EndDate >= getdate())
	AND pt.SortOrder >= 0
	AND pat.MaxQty = 0
GROUP BY ss.SignupServerID, scs.ServiceCategoryID, pat.AccountTypeID
GO

--SignupOptions (Nonrecurring)
INSERT INTO SignupOptions (SignupOption,SignupServerID,ServiceCategoryID,AccountTypeID,TimeChargeID,BillingCycleID,PayPeriodID,SetupCharge,Active,SortOrder,CustomerDescription)
SELECT MIN(tc.TimeCharge), ss.SignupServerID, scs.ServiceCategoryID, pat.AccountTypeID, tc.TimeChargeID, MIN(pt.BillingCycleID), MIN(pt.PayPeriodID), MIN(ss.SetupCharge),MIN(pt.Active),MIN(pt.SortOrder),MIN(CAST(tc.Description AS VARCHAR(4000)))
FROM Emerald..PackageTypes pt
	JOIN BillingCycles bc ON (pt.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ServiceGroups sg ON (pt.ServiceGroupID = sg.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgi ON (pt.ServiceGroupID = sgi.ServiceGroupID)
	JOIN Emerald..SignupServers ss ON (pt.GroupID IS NULL OR pt.GroupID = ss.GroupID OR sgi.GroupID = ss.GroupID)
	JOIN ServiceCategories scs ON (scs.ServiceCategory = 'Emerald5 Services')
	JOIN Emerald..PackageAccountTypes pat ON (pt.PackageTypeID = pat.PackageTypeID AND pt.PrimaryAccountTypeID = pat.AccountTypeID)
	JOIN TimeCharges tc ON (pat.AccountTypeID = tc.AccountTypeID)
	WHERE pt.Active = 1
	AND pt.CustomerAccess = 1
	AND pt.CustomerSignup = 1
	AND tc.CustomerAccess = 1
	AND pt.PrimaryAccountTypeID IS NOT NULL
	AND pt.PayPeriodID IS NOT NULL
	AND bc.AutoBill = 2
	AND (ss.PackageTypeID IS NULL OR pt.PackageTypeID = ss.PackageTypeID OR pt.PackageTypeID IN (SELECT PackageTypeID FROM Emerald..SignupPackageTypes spt WHERE spt.SignupServerID = ss.SignupServerID))
	AND (pt.StartDate IS NULL OR pt.StartDate <= getdate())
	AND (pt.EndDate IS NULL OR pt.EndDate >= getdate())
	AND pt.SortOrder >= 0
	AND tc.SortOrder >= 0
GROUP BY ss.SignupServerID, scs.ServiceCategoryID, pat.AccountTypeID, tc.TimeChargeID
GO

-- RadIPGroups
IF ((SELECT COUNT(*) FROM Emerald..RadIPAddresses) > 0)
BEGIN
INSERT INTO InvCategories (InvCategory,Description,SortOrder) VALUES('Emerald5 - IP Groups','Emerald5 RADIUS IP Address Groups',1000)

INSERT INTO InvProducts (InvCategoryID,InvSourceID,Title,CreateDate,CreateUser,Active,SortOrder,ExternalRef)
SELECT ic.InvCategoryID, is1.InvSourceID, rig.RadIPGroup, getdate(), 'Emerald5', 1, 0, rig.RadIPGroupID
FROM Emerald..RadIPGroups rig JOIN InvSources is1 ON (is1.InvSource = 'IPv4 Reservations')
	JOIN InvCategories ic ON (ic.InvCategory = 'Emerald5 - IP Groups')
	WHERE EXISTS (SELECT * FROM Emerald..RadIPAddresses ria WHERE RadIPGroupID = rig.RadIPGroupID)

INSERT INTO InvItems (InvProductID,InvStateID,CustomerID,AccountID,SerialNumber,AssignDate,AssignUser,CreateDate,CreateUser)
SELECT ip.InvProductID, CASE WHEN ria.AccountID IS NULL THEN isa.InvStateID ELSE isc.InvStateID END AS InvStateID, sa.CustomerID, sa.AccountID,
ria.IPAddress AS SerialNumber, ria.LastUsed AS AssignDate, 'Emerald5' AS AssignUser, getdate() AS CreateDate, 'Emerald5' AS CreateUser
FROM Emerald..RadIPAddresses ria JOIN Emerald..RadIPGroups rig ON (ria.RadIPGroupID = rig.RadIPGroupID)
	LEFT JOIN SubAccounts sa ON (ria.AccountID = sa.AccountID)
	JOIN InvProducts ip ON (rig.RadIPGroupID = ip.ExternalRef)
	JOIN InvStates isc ON (isc.InvState = 'Assigned to Customer')
	JOIN InvStates isa ON (isa.InvState = 'Available')

INSERT INTO InvAccountTypes (AccountTypeID,InvProductID,Required,AutoAssign)
SELECT DISTINCT riat.AccountTypeID,ip.InvProductID,1,1
FROM Emerald..RadIPAccountTypes riat JOIN InvCategories ic ON (ic.InvCategory = 'Emerald5 - IP Groups')
	JOIN InvProducts ip ON (ip.ExternalRef = riat.RadIPGroupID)
	WHERE riat.AccountTypeID IS NOT NULL
END
GO

UPDATE OperatorGroups SET InternalUse = 1 WHERE OperatorGroup = 'CustomerAccess' AND InternalUse <> 1
GO

-- Approximate monthly service cost for closed and future invoiced accounts
UPDATE sa SET Cost = COALESCE(iic.Amount,scat.Cost1,at1.Cost)
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ServiceCatAccountTypes scat ON (sa.ServiceCategoryID = scat.ServiceCategoryID AND sa.AccountTypeID = scat.AccountTypeID)
	LEFT JOIN (SELECT ii.AccountID, MAX(ii.ItemID) AS ItemID
	FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
		WHERE i.VoidDate IS NULL
		AND i.Processed = 1
		AND i.InvoiceTypeID IN (1,2,3)
		AND ii.ItemType = 3
		AND ii.Days = 0
		AND ii.Amount >= 0
		AND DATEDIFF(mm,ii.StartDate,DATEADD(dd,1,ii.EndDate)) = ii.Quantity
		GROUP BY ii.AccountID) imax ON (sa.AccountID = imax.AccountID)
	LEFT JOIN InvoiceItems iic ON (imax.ItemID = iic.ItemID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0) OR sa.BilledThru > DATEADD(mm,3,getdate()) OR ma.CancelDate <= DATEADD(dd,1,sa.BilledThru) OR sa.CancelDate <= DATEADD(dd,1,sa.BilledThru))
	AND sa.Cost IS NULL
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
GO

-- Remove temporary variables
DROP INDEX dbo.SubAccounts.i_Upgrade_RTL
GO

UPDATE SubAccounts SET RateTimeLeft = NULL
GO
UPDATE AccountTypes SET RateTimeLeft = NULL
GO

UPDATE InvoiceItems SET Days = DATEDIFF(dd,StartDate,EndDate) + 1
	WHERE Quantity > 0
	AND ItemType = 3
	AND Days = 0
	AND StartDate <= EndDate
	AND Quantity = DATEDIFF(dd,StartDate,EndDate) + 1
GO

{CALL AddressAssign(NULL)}
GO

