IF OBJECT_ID('calls_insert') IS NOT NULL
	DROP TRIGGER calls_insert
GO

CREATE TRIGGER calls_insert ON dbo.Calls INSTEAD OF INSERT
AS
SET NOCOUNT ON
SET DEADLOCK_PRIORITY LOW
DECLARE @Username VARCHAR(64), @mac VARCHAR(64), @AcctSessionID VARCHAR(40), @NASIdentifier VARCHAR(45), @AcctStatusType TINYINT, @TimeRef SMALLINT,
@CallDate DATETIME, @AccountID INT, @ServerID INT, @NASPort VARCHAR(32), @AcctDelayTime INT,
@AcctSessionTime INT, @FramedIPAddress VARCHAR(15), @FramedIPv6Address VARCHAR(39), @FramedIPv6Prefix VARCHAR(43), @AcctInputOctets BIGINT,
@AcctOutputOctets BIGINT, @AcctTerminateCause SMALLINT, @NASPortType INT, @CallingStationID VARCHAR(64), @CalledStationID VARCHAR(64), 
@ConnectInfo VARCHAR(64), @CallStartID BIGINT, @CallStartDate DATETIME, @LastAcctSessionTime INT, @LastAcctInputOctets BIGINT, 
@LastAcctOutputOctets BIGINT, @Authorized TINYINT, @UpStart TINYINT, @UpTime TINYINT, @UpData TINYINT,
@HaveStop TINYINT, @HaveStopTimeLeft TINYINT, @StopAcctSessionTime INT, @AccountTypeID INT, @GroupID INT

DECLARE ci CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR 
SELECT Username, AcctSessionID, NASIdentifier, AcctStatusType, TimeRef, 
CallDate, AccountID, ServerID, NASPort, AcctDelayTime,
AcctSessionTime, FramedIPAddress, FramedIPv6Address, FramedIPv6Prefix, AcctInputOctets, 
AcctOutputOctets, AcctTerminateCause, NASPortType, CallingStationID, CalledStationID,
ConnectInfo
FROM inserted

OPEN ci
goto onefetch
WHILE (@@FETCH_STATUS = 0)
BEGIN
SELECT @CallStartID = NULL, @CallStartDate = NULL, @LastAcctSessionTime = NULL, @LastAcctInputOctets = NULL, @LastAcctOutputOctets = NULL, 
@NASPort = COALESCE(@NASPort,' '), @TimeRef = COALESCE(@TimeRef,0), @Authorized = 1, @UpStart = 0, @UpTime = NULL, @UpData = NULL, @HaveStop = 0, @HaveStopTimeLeft = 0,
@AcctDelayTime = CASE WHEN @AcctDelayTime IS NULL THEN 0 WHEN @AcctDelayTime > 32767 THEN 32767 ELSE @AcctDelayTime END,
@NASPortType = CASE WHEN @NASPortType > 32767 THEN NULL ELSE @NASPortType END,
@AcctSessionTime = COALESCE(@AcctSessionTime,0),
@AcctInputOctets = COALESCE(@AcctInputOctets,0), 
@AcctOutputOctets = COALESCE(@AcctOutputOctets,0)

-- Find matching start record
IF (@AcctStatusType IN (2,3))
BEGIN
SELECT @CallStartID = CallStartID, @AccountID = AccountID, @CallStartDate = CallDate, 
@UpStart = CASE WHEN @AcctStatusType = 2 AND ((FramedIPAddress IS NULL AND @FramedIPAddress IS NOT NULL)
	OR (CalledStationID IS NULL AND @CalledStationID IS NOT NULL)
	OR (CallingStationID IS NULL AND @CallingStationID IS NOT NULL)
	OR (FramedIPv6Prefix IS NULL AND @FramedIPv6Prefix IS NOT NULL)
	OR (FramedIPv6Address IS NULL AND @FramedIPv6Address IS NOT NULL)
	OR (ConnectInfo IS NULL AND @ConnectInfo IS NOT NULL)) THEN 1 ELSE 0 END
FROM CallStarts
	WHERE Username = @Username
	AND AcctSessionID = @AcctSessionID
	AND NASIdentifier = @NASIdentifier
	AND NASPort = @NASPort
	AND TimeRef = @TimeRef
END

IF (@CallStartID IS NOT NULL AND @AcctStatusType IN (2,3))
BEGIN
SELECT @HaveStop = 1, @HaveStopTimeLeft = CASE WHEN AcctDelayTime = -1 THEN 0 ELSE 1 END, @StopAcctSessionTime = COALESCE(AcctSessionTime,0)
FROM CallStops WITH (NOLOCK)
	WHERE CallStartID = @CallStartID
END

-- Lookup AccountID by RADIUS User-Name attribute
IF (@CallStartID IS NULL AND @AccountID IS NULL AND @Username <> ' ')
BEGIN
SELECT	@mac = CASE 
	WHEN @Username LIKE '[0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f]' THEN REPLACE(REPLACE(@Username,'-',''),':','')
	WHEN @Username LIKE '[0-9a-f][0-9a-f][0-9a-f][0-9a-f].[0-9a-f][0-9a-f][0-9a-f][0-9a-f].[0-9a-f][0-9a-f][0-9a-f][0-9a-f]' THEN REPLACE(@Username,'.','')
	ELSE @Username END

SELECT @Authorized = 0, @AccountID = MIN(CASE WHEN at1.LogonAsParent = 1 AND sa.ParentAccountID IS NOT NULL THEN sa.ParentAccountID ELSE sa.AccountID END)
FROM SubAccounts sa WITH (NOLOCK) JOIN MasterAccounts ma WITH (NOLOCK) ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 WITH (NOLOCK) ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE sa.Login IN (@Username,@mac)
	AND at1.AllowRADIUS = 1
	AND ma.Active = 1
	AND sa.Active = 1
END

-- Add new start record if needed
IF (@CallStartID IS NULL AND @AcctStatusType IN (1,2,3))
BEGIN
INSERT INTO CallStarts (Username,AcctSessionID,NASIdentifier,NASPort,TimeRef,CallDate,AcctDelayTime,AccountID,ServerID,CalledStationID,CallingStationID,NASPortType,FramedIPAddress,FramedIPv6Address,FramedIPv6Prefix,ConnectInfo,AcctStatusType)
VALUES(@Username,@AcctSessionID,@NASIdentifier,@NASPort,@TimeRef,DATEADD(ss,-@AcctSessionTime,@CallDate),@AcctDelayTime,@AccountID,@ServerID,@CalledStationID,@CallingStationID,@NASPortType,@FramedIPAddress,@FramedIPv6Address,@FramedIPv6Prefix,@ConnectInfo,@AcctStatusType)

IF (@@ROWCOUNT = 1)
	BEGIN
	SELECT @CallStartID = SCOPE_IDENTITY(), @CallStartDate = DATEADD(ss,-@AcctSessionTime,@CallDate)
	END ELSE BEGIN
	SELECT @CallStartID = CallStartID, @AccountID = AccountID, @CallStartDate = CallDate
	FROM CallStarts
		WHERE Username = @Username
		AND AcctSessionID = @AcctSessionID
		AND NASIdentifier = @NASIdentifier
		AND NASPort = @NASPort
		AND TimeRef = @TimeRef
	END
END

-- Add or update server port
IF (@CallStartID IS NOT NULL AND @AcctStatusType IN (1,2,3))
BEGIN
SELECT @LastAcctSessionTime = AcctSessionTime, @LastAcctInputOctets = AcctInputOctets, @LastAcctOutputOctets = AcctOutputOctets
FROM ServerPorts
	WHERE CallStartID = @CallStartID

IF (@LastAcctSessionTime IS NOT NULL)
	BEGIN
	UPDATE ServerPorts SET AcctSessionTime = CASE WHEN AcctSessionTime < @AcctSessionTime THEN @AcctSessionTime ELSE AcctSessionTime END,
	AcctInputOctets = CASE WHEN AcctInputOctets < @AcctInputOctets THEN @AcctInputOctets ELSE AcctInputOctets END,
	AcctOutputOctets = CASE WHEN AcctOutputOctets < @AcctOutputOctets THEN @AcctOutputOctets ELSE AcctOutputOctets END
		WHERE CallStartID = @CallStartID
	END ELSE BEGIN
	SELECT @LastAcctSessionTime = COALESCE(MAX(AcctSessionTime),0), @LastAcctInputOctets = COALESCE(MAX(AcctInputOctets),0), @LastAcctOutputOctets = COALESCE(MAX(AcctOutputOctets),0)
	FROM CallInterims
		WHERE CallStartID = @CallStartID

	IF (@AcctStatusType IN (1,3))
		BEGIN
		INSERT INTO ServerPorts (CallStartID,AccountID,AcctSessionTime,AcctInputOctets,AcctOutputOctets,Authorized)
		VALUES(@CallStartID,@AccountID,
			CASE WHEN @AcctSessionTime > @LastAcctSessionTime THEN @AcctSessionTime ELSE @LastAcctSessionTime END,
			CASE WHEN @AcctInputOctets > @LastAcctInputOctets THEN @AcctInputOctets ELSE @LastAcctInputOctets END,
			CASE WHEN @AcctOutputOctets > @LastAcctOutputOctets THEN @AcctOutputOctets ELSE @LastAcctOutputOctets END,@Authorized)
		END
	END
END

-- Update SA only if necessary to update service time/data left
IF (@AccountID IS NOT NULL AND ((@AcctStatusType = 2 AND @HaveStopTimeLeft = 0 AND @AcctSessionTime > 0) OR (@AcctStatusType IN (2,3) AND (@AcctInputOctets > @LastAcctInputOctets OR @AcctOutputOctets > @LastAcctOutputOctets))))
BEGIN
SELECT @UpTime = CASE WHEN TimeLeft IS NULL THEN 0 ELSE 1 END, @UpData = CASE WHEN DataLeft IS NULL THEN 0 ELSE 1 END
FROM SubAccounts WITH (NOLOCK)
	WHERE AccountID = @AccountID
END

-- Update service time/data left
IF (@AccountID IS NOT NULL AND ((@AcctStatusType = 2 AND @HaveStopTimeLeft = 0 AND @AcctSessionTime > 0 AND @UpTime = 1) OR (@AcctStatusType IN (2,3) AND @UpData = 1 AND (@AcctInputOctets > @LastAcctInputOctets OR @AcctOutputOctets > @LastAcctOutputOctets))))
BEGIN
UPDATE SubAccounts SET TimeLeft = TimeLeft - CASE WHEN @AcctStatusType = 2 AND @HaveStopTimeLeft = 0 AND @AcctSessionTime > 0 THEN @AcctSessionTime / 60 + CASE WHEN @AcctSessionTime % 60 <> 0 THEN 1 ELSE 0 END ELSE 0 END,
DataLeft = DataLeft - CASE WHEN (@AcctInputOctets + @AcctOutputOctets) - (@LastAcctInputOctets + @LastAcctOutputOctets) > 0 THEN (@AcctInputOctets + @AcctOutputOctets) - (@LastAcctInputOctets + @LastAcctOutputOctets) ELSE 0 END
	WHERE AccountID = @AccountID
END

-- Remove server port and add stop record (CallStops)
IF (@CallStartID IS NOT NULL AND @AcctStatusType = 2)
BEGIN
DELETE FROM ServerPorts WHERE CallStartID = @CallStartID

IF (@HaveStop = 0)
	BEGIN
	INSERT INTO CallStops (CallStartID,CallSessionTime,AcctDelayTime,AcctSessionTime,AcctInputOctets,AcctOutputOctets,AcctTerminateCause)
	VALUES(@CallStartID,DATEDIFF(ss,@CallStartDate,@CallDate),@AcctDelayTime,@AcctSessionTime,@AcctInputOctets,@AcctOutputOctets,@AcctTerminateCause)
	END
END

-- Add CallInterims (Start + Stop)
IF (@CallStartID IS NOT NULL AND @AcctStatusType IN (2,3))
BEGIN
INSERT INTO CallInterims (CallStartID,AcctSessionTime,AcctInputOctets,AcctOutputOctets)
VALUES(@CallStartID,@AcctSessionTime,@AcctInputOctets,@AcctOutputOctets)
END

-- Update stop record if additional interim data available after stop record
IF (@HaveStop = 1 AND @AcctSessionTime >= @StopAcctSessionTime)
BEGIN
UPDATE CallStops SET AcctSessionTime = @AcctSessionTime, AcctInputOctets = @AcctInputOctets, AcctOutputOctets = @AcctOutputOctets, AcctDelayTime = @AcctDelayTime
	WHERE CallStartID = @CallStartID
	AND AcctSessionTime <= @AcctSessionTime
	AND AcctInputOctets <= @AcctInputOctets
	AND AcctOutputOctets <= @AcctOutputOctets
END

-- Update start record if additional data available since start
IF (@UpStart = 1)
BEGIN
UPDATE CallStarts SET FramedIPAddress = COALESCE(@FramedIPAddress,FramedIPAddress), 
FramedIPv6Address = COALESCE(@FramedIPv6Address,FramedIPv6Address), 
FramedIPv6Prefix = COALESCE(@FramedIPv6Prefix,FramedIPv6Prefix),
ConnectInfo = COALESCE(@ConnectInfo,ConnectInfo),
CalledStationID = COALESCE(@CalledStationID,CalledStationID),
CallingStationID = COALESCE(@CallingStationID,CallingStationID)
	WHERE CallStartID = @CallStartID
END

-- Group Concurrency
IF (@AccountID IS NOT NULL AND @AcctStatusType IN (1,2) AND EXISTS (SELECT * FROM RadConcurrency WITH (NOLOCK)))
BEGIN
SELECT @GroupID = ma.GroupID, @AccountTypeID = sa.AccountTypeID
FROM SubAccounts sa WITH (NOLOCK) JOIN MasterAccounts ma WITH (NOLOCK) ON (sa.CustomerID = ma.CustomerID)
	WHERE sa.AccountID = @AccountID

IF (@GroupID IS NOT NULL)
	BEGIN
	UPDATE RadConcurrency SET Connections = Connections + CASE WHEN @AcctStatusType = 1 THEN 1 ELSE -1 END
		WHERE GroupID = @GroupID
		AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)
	END
END

onefetch:
FETCH NEXT FROM ci INTO @Username, @AcctSessionID, @NASIdentifier, @AcctStatusType, @TimeRef, 
@CallDate, @AccountID, @ServerID, @NASPort, @AcctDelayTime,
@AcctSessionTime, @FramedIPAddress, @FramedIPv6Address, @FramedIPv6Prefix, @AcctInputOctets, 
@AcctOutputOctets, @AcctTerminateCause, @NASPortType, @CallingStationID, @CalledStationID,
@ConnectInfo
END
CLOSE ci
DEALLOCATE ci
GO

IF OBJECT_ID('gaugeq_insert') IS NOT NULL
	DROP TRIGGER gaugeq_insert
GO

CREATE TRIGGER gaugeq_insert ON dbo.GaugeQ INSTEAD OF INSERT
AS
DECLARE @AccountID INT, @GaugeID INT, @Data FLOAT
DECLARE ci CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR SELECT AccountID, GaugeID, Data FROM inserted

OPEN ci
goto onefetch
WHILE (@@FETCH_STATUS = 0)
BEGIN
EXEC GaugeAdd @GaugeID, @AccountID, NULL, @Data

onefetch:
FETCH NEXT FROM ci INTO @AccountID, @GaugeID, @Data
END
CLOSE ci
DEALLOCATE ci
GO

