CREATE PROCEDURE dbo.ACHExport (@BatchProcessorID INT, @CustomerID INT, @partid INT = NULL, @parts INT = NULL) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NULL)
BEGIN
SELECT a.Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber, et.AuthName AS AccountHolder, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
COALESCE(et.AuthAddress,a.Address1) AS Address, a.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,a.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,a.StateID)) AS State, COALESCE(et.AuthZip,a.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID IN (128,256) THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC,
CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC,
CASE et.BankTransType WHEN 'savings' THEN 'SAVINGS' WHEN 'businesschecking' THEN 'BUSINESSCK' ELSE 'CHECKING' END AS BankTransTypeIP,
CASE et.BankTransType WHEN 'savings' THEN 'Savings' WHEN 'checking' THEN 'Checking' WHEN 'businesschecking' THEN 'Corporate' ELSE 'Checking' END AS BankTransTypeWP,
et.BankNumber, et.BankName, a.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS CountryCode,
COALESCE(a.PhoneHome,a.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et JOIN MasterAccounts ma ON (ma.CustomerID = et.CustomerID)
	JOIN Groups g ON (g.GroupID = ma.GroupID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND (@partid IS NULL OR et.CustomerID % @parts = @partid - 1)
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND bp.BatchProcessorID = @BatchProcessorID

END ELSE BEGIN

SELECT a.Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber, et.AuthName AS AccountHolder, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
COALESCE(et.AuthAddress,a.Address1) AS Address, a.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,a.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,a.StateID)) AS State, COALESCE(et.AuthZip,a.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID IN (128,256) THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC,
CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC,
CASE et.BankTransType WHEN 'savings' THEN 'SAVINGS' WHEN 'businesschecking' THEN 'BUSINESSCK' ELSE 'CHECKING' END AS BankTransTypeIP,
CASE et.BankTransType WHEN 'savings' THEN 'Savings' WHEN 'checking' THEN 'Checking' WHEN 'businesschecking' THEN 'Corporate' ELSE 'Checking' END AS BankTransTypeWP,
et.BankNumber, et.BankName, a.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS CountryCode,
COALESCE(a.PhoneHome,a.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et JOIN MasterAccounts ma ON (ma.CustomerID = et.CustomerID)
	JOIN Groups g ON (g.GroupID = ma.GroupID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND ma.CustomerID = @CustomerID
	AND bp.BatchProcessorID = @BatchProcessorID
END
GO

CREATE PROCEDURE dbo.AccountChange (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
DECLARE @minBilledThru DATETIME

CREATE TABLE #acma (CustomerID INT, BeforeDate DATETIME, AfterDate DATETIME)
CREATE TABLE #acsa (AccountID INT, BeforeDate DATETIME, AfterDate DATETIME, AccountTypeDate DATETIME, NextCancelDate DATETIME)

CREATE TABLE #acfma (CustomerID INT, StartDate DATETIME, CancelDate DATETIME, CancelReasonID INT)
CREATE TABLE #acfsa (AccountID INT, StartDate DATETIME, CancelDate DATETIME, CancelReasonID INT)

CREATE TABLE #acbma (CustomerID INT, saBillDay INT)

IF (@CustomerID IS NULL AND @AccountID IS NOT NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM SubAccounts WHERE AccountID = @AccountID
END

IF (@CustomerID IS NOT NULL)
BEGIN

INSERT INTO #acma (CustomerID, BeforeDate, AfterDate)
SELECT ma.CustomerID, MAX(CASE WHEN ac.EffectiveDate <= getdate() THEN ac.EffectiveDate END) AS BeforeDate, MIN(CASE WHEN ac.EffectiveDate > getdate() THEN ac.EffectiveDate END) AS AfterDate
FROM MasterAccounts ma JOIN AccountChanges ac ON (ma.CustomerID = ac.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.CustomerID = @CustomerID
	AND ac.InactiveDate IS NULL
	AND ac.AccountID IS NULL
	AND ma.Active = 1
	AND bc.AutoBill IN (0,1)
GROUP BY ma.CustomerID

IF ((SELECT COUNT(*) FROM #acma) = 0)
BEGIN
SELECT @minBilledThru = MIN(sa.BilledThru)
FROM SubAccounts sa
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.Recurring = 1

UPDATE MasterAccounts SET CancelDate = NULL, CancelReasonID = NULL, StartDate = CASE 
WHEN StartDate > getdate() AND @minBilledThru > getdate() THEN DATEADD(dd,1,@minBilledThru)
WHEN StartDate > getdate() AND @minBilledThru <= getdate() THEN DATEADD(dd,-1,getdate())
ELSE StartDate END 
	WHERE CustomerID = @CustomerID 
	AND (CancelDate IS NOT NULL OR CancelReasonID IS NOT NULL OR StartDate > getdate())
END

INSERT INTO #acsa (AccountID, BeforeDate, AfterDate, AccountTypeDate, NextCancelDate)
SELECT sa.AccountID, MAX(CASE WHEN ac.EffectiveDate <= getdate() THEN ac.EffectiveDate END) AS BeforeDate, 
MIN(CASE WHEN ac.EffectiveDate > getdate() THEN ac.EffectiveDate END) AS AfterDate, 
MAX(CASE WHEN ac.EffectiveDate <= getdate() AND ac.AccountTypeID IS NOT NULL THEN ac.EffectiveDate END) AS AccountTypeDate,
MIN(CASE WHEN ac.EffectiveDate > getdate() AND ac.CancelReasonID IS NOT NULL THEN ac.EffectiveDate END) AS NextCancelDate
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)	
	LEFT JOIN AccountChanges ac ON (sa.CustomerID = ac.CustomerID AND sa.AccountID = ac.AccountID AND ac.InactiveDate IS NULL)
	WHERE sa.CustomerID = @CustomerID
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
	AND sa.Active = 1
	AND bc.AutoBill IN (0,1)
	AND sa.Recurring = 1
GROUP BY sa.AccountID

UPDATE SubAccounts SET StartDate = CASE WHEN StartDate > getdate() THEN DATEADD(dd,-1,getdate()) ELSE StartDate END
	WHERE CustomerID = @CustomerID
	AND (@AccountID IS NULL OR AccountID = @AccountID)
	AND Active = 1
	AND Recurring = 1
	AND AccountID NOT IN (SELECT AccountID FROM #acsa WHERE BeforeDate IS NOT NULL AND AfterDate IS NOT NULL)

END ELSE BEGIN
UPDATE IEALocks SET RefCount = RefCount + 1, LastModifyDate = getdate() WHERE IEALockID = 7

INSERT INTO #acma (CustomerID, BeforeDate, AfterDate)
SELECT ma.CustomerID, MAX(CASE WHEN ac.EffectiveDate <= getdate() THEN ac.EffectiveDate END) AS BeforeDate, MIN(CASE WHEN ac.EffectiveDate > getdate() THEN ac.EffectiveDate END) AS AfterDate
FROM MasterAccounts ma JOIN AccountChanges ac ON (ma.CustomerID = ac.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND ac.InactiveDate IS NULL
	AND ac.AccountID IS NULL
	AND bc.AutoBill IN (0,1)
GROUP BY ma.CustomerID

INSERT INTO #acsa (AccountID, BeforeDate, AfterDate, AccountTypeDate, NextCancelDate)
SELECT sa.AccountID, MAX(CASE WHEN ac.EffectiveDate <= getdate() THEN ac.EffectiveDate END) AS BeforeDate, 
MIN(CASE WHEN ac.EffectiveDate > getdate() THEN ac.EffectiveDate END) AS AfterDate,
MAX(CASE WHEN ac.EffectiveDate <= getdate() AND ac.AccountTypeID IS NOT NULL THEN ac.EffectiveDate END) AS AccountTypeDate,
MIN(CASE WHEN ac.EffectiveDate > getdate() AND ac.CancelReasonID IS NOT NULL THEN ac.EffectiveDate END) AS NextCancelDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountChanges ac ON (sa.CustomerID = ac.CustomerID AND sa.AccountID = ac.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ac.InactiveDate IS NULL
	AND bc.AutoBill IN (0,1)
	AND sa.Recurring = 1
GROUP BY sa.AccountID
END

INSERT INTO #acfma (CustomerID, StartDate, CancelReasonID, CancelDate)
SELECT ma.CustomerID,
CASE WHEN acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL AND aca.CancelReasonID IS NULL THEN aca.EffectiveDate 
	WHEN acb.CancelReasonID IS NULL AND acb.AccountChangeID IS NOT NULL THEN acb.EffectiveDate END AS StartDate,
CASE	WHEN acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NOT NULL THEN aca.CancelReasonID
	WHEN acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) THEN acb.CancelReasonID END AS CancelReasonID,
CASE	WHEN acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NOT NULL THEN aca.EffectiveDate
	WHEN acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) THEN acb.EffectiveDate END AS CancelDate

FROM MasterAccounts ma JOIN #acma acma ON (ma.CustomerID = acma.CustomerID)
	LEFT JOIN AccountChanges acb ON (acma.CustomerID = acb.CustomerID AND acma.BeforeDate = acb.EffectiveDate AND acb.AccountID IS NULL AND acb.InactiveDate IS NULL)
	LEFT JOIN AccountChanges aca ON (acma.CustomerID = aca.CustomerID AND acma.AfterDate = aca.EffectiveDate AND aca.AccountID IS NULL AND aca.InactiveDate IS NULL)
	WHERE (acb.AccountChangeID IS NOT NULL OR aca.AccountChangeID IS NOT NULL)
	AND (
	(acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL AND aca.CancelReasonID IS NULL AND ma.StartDate <> aca.EffectiveDate)
	OR (acb.CancelReasonID IS NULL AND acb.AccountChangeID IS NOT NULL AND acb.EffectiveDate <> ma.StartDate)
	OR (acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL AND aca.CancelReasonID IS NULL AND ma.StartDate <> aca.EffectiveDate)
	OR (acb.CancelReasonID IS NULL AND aca.AccountChangeID IS NULL AND ma.CancelDate IS NOT NULL)
	OR (acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NOT NULL AND (ma.CancelReasonID IS NULL OR ma.CancelReasonID <> aca.CancelReasonID OR ma.CancelDate <> aca.EffectiveDate))
	OR (acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) AND (ma.CancelReasonID IS NULL OR ma.CancelReasonID <> acb.CancelReasonID OR ma.CancelDate <> acb.EffectiveDate))
	OR (aca.AccountChangeID IS NOT NULL AND acb.AccountChangeID IS NOT NULL AND acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NULL AND (ma.CancelReasonID IS NOT NULL OR ma.CancelDate IS NOT NULL)))

UPDATE ma SET StartDate = COALESCE(a.StartDate,ma.StartDate), CancelReasonID = a.CancelReasonID, CancelDate = a.CancelDate
FROM MasterAccounts ma JOIN #acfma a ON (ma.CustomerID = a.CustomerID)

INSERT INTO #acfsa (AccountID, StartDate, CancelReasonID, CancelDate)
SELECT sa.AccountID,
CASE	WHEN ((acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL) OR (acb.AccountChangeID IS NULL AND aca.AccountChangeID IS NOT NULL)) AND aca.CancelReasonID IS NULL THEN CASE WHEN ma.StartDate > aca.EffectiveDate THEN ma.StartDate ELSE aca.EffectiveDate END
	WHEN acb.CancelReasonID IS NULL AND acb.AccountChangeID IS NOT NULL THEN CASE WHEN ma.StartDate > acb.EffectiveDate THEN ma.StartDate ELSE acb.EffectiveDate END
	WHEN ma.StartDate > sa.StartDate THEN ma.StartDate END AS StartDate,
CASE	WHEN acb.CancelReasonID IS NULL AND acc.CancelReasonID IS NOT NULL THEN acc.CancelReasonID
	WHEN acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) THEN acb.CancelReasonID
	ELSE NULL END AS CancelReasonID,
CASE	WHEN acb.CancelReasonID IS NULL AND acc.CancelReasonID IS NOT NULL THEN acc.EffectiveDate
	WHEN acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) THEN acb.EffectiveDate
	ELSE NULL END AS CancelDate

FROM SubAccounts sa JOIN #acsa acsa ON (sa.AccountID = acsa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN AccountChanges acb ON (sa.CustomerID = acb.CustomerID AND sa.AccountID = acb.AccountID AND acsa.BeforeDate = acb.EffectiveDate AND acb.InactiveDate IS NULL)
	LEFT JOIN AccountChanges aca ON (sa.CustomerID = aca.CustomerID AND sa.AccountID = aca.AccountID AND acsa.AfterDate = aca.EffectiveDate AND aca.InactiveDate IS NULL)
	LEFT JOIN AccountChanges acc ON (sa.CustomerID = acc.CustomerID AND sa.AccountID = acc.AccountID AND acsa.NextCancelDate = acc.EffectiveDate AND acc.CancelReasonID IS NOT NULL AND acc.InactiveDate IS NULL)
	WHERE ma.StartDate > sa.StartDate
	OR (((acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL) OR (acb.AccountChangeID IS NULL AND aca.AccountChangeID IS NOT NULL)) AND aca.CancelReasonID IS NULL AND CASE WHEN ma.StartDate > aca.EffectiveDate THEN ma.StartDate ELSE aca.EffectiveDate END <> sa.StartDate)
	OR (acb.CancelReasonID IS NULL AND acb.AccountChangeID IS NOT NULL AND CASE WHEN ma.StartDate > acb.EffectiveDate THEN ma.StartDate ELSE acb.EffectiveDate END <> sa.StartDate)
	OR (sa.CancelDate IS NOT NULL AND acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NULL)
	OR (acb.CancelReasonID IS NOT NULL AND aca.AccountChangeID IS NOT NULL AND aca.CancelReasonID IS NULL AND (sa.StartDate <> aca.EffectiveDate OR ma.StartDate > sa.StartDate))
	OR (acb.CancelReasonID IS NULL AND acc.CancelReasonID IS NOT NULL AND (sa.CancelReasonID IS NULL OR sa.CancelReasonID <> aca.CancelReasonID OR sa.CancelDate <> aca.EffectiveDate))
	OR (acb.CancelReasonID IS NOT NULL AND (aca.CancelReasonID IS NOT NULL OR aca.AccountChangeID IS NULL) AND (sa.CancelReasonID IS NULL OR sa.CancelReasonID <> acb.CancelReasonID OR sa.CancelDate <> acb.EffectiveDate))
	OR (aca.AccountChangeID IS NOT NULL AND acb.AccountChangeID IS NOT NULL AND acb.CancelReasonID IS NULL AND aca.CancelReasonID IS NULL AND (sa.CancelReasonID IS NOT NULL OR sa.CancelDate IS NOT NULL))

UPDATE sa SET AccountTypeID = ac.AccountTypeID
FROM SubAccounts sa JOIN #acsa a ON (sa.AccountID = a.AccountID AND a.AccountTypeDate IS NOT NULL)
	JOIN AccountChanges ac ON (sa.CustomerID = ac.CustomerID AND sa.AccountID = ac.AccountID AND a.AccountTypeDate = ac.EffectiveDate)
	WHERE sa.AccountTypeID <> ac.AccountTypeID
	AND ac.AccountTypeID IS NOT NULL
	AND ac.InactiveDate IS NULL

UPDATE sa SET StartDate = COALESCE(a.StartDate,sa.StartDate), CancelReasonID = a.CancelReasonID, CancelDate = a.CancelDate
FROM SubAccounts sa JOIN #acfsa a ON (sa.AccountID = a.AccountID)

UPDATE sa SET BilledThru = CASE WHEN mab.CancelReasonID IS NOT NULL AND sab.CancelReasonID IS NOT NULL AND sa.StartDate > ma.StartDate AND sa.BilledThru >= sab.EffectiveDate AND sa.StartDate > sa.BilledThru THEN DATEADD(dd,-1,sa.StartDate)
WHEN mab.CancelReasonID IS NOT NULL AND sa.BilledThru >= mab.EffectiveDate AND ma.StartDate > sa.BilledThru THEN DATEADD(dd,-1,ma.StartDate)
WHEN sab.CancelReasonID IS NOT NULL AND sa.BilledThru >= sab.EffectiveDate AND sa.StartDate > sa.BilledThru THEN DATEADD(dd,-1,sa.StartDate)
ELSE sa.BilledThru END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN #acma acma ON (sa.CustomerID = acma.CustomerID)
	LEFT JOIN #acsa acsa ON (sa.AccountID = acsa.AccountID)
	LEFT JOIN AccountChanges mab ON (acma.CustomerID = mab.CustomerID AND acma.BeforeDate = mab.EffectiveDate AND mab.AccountID IS NULL AND mab.InactiveDate IS NULL)
	LEFT JOIN AccountChanges sab ON (sa.CustomerID = sab.CustomerID AND sa.AccountID = sab.AccountID AND acsa.BeforeDate = sab.EffectiveDate AND sab.InactiveDate IS NULL)
	WHERE sa.Active = 1
	AND sa.Recurring = 1
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
	AND ma.CancelDate IS NULL
	AND sa.CancelDate IS NULL
	AND ((mab.CancelReasonID IS NOT NULL AND sa.BilledThru >= mab.EffectiveDate AND sa.BilledThru < ma.StartDate) 
		OR (sab.CancelReasonID IS NOT NULL AND sa.BilledThru >= sab.EffectiveDate AND sa.BilledThru < sa.StartDate))

IF (@AccountID IS NULL)
BEGIN
INSERT INTO #acbma (CustomerID,saBillDay)
SELECT ma.CustomerID, DATEPART(dd,aca.EffectiveDate) AS saBillDay
FROM MasterAccounts ma JOIN #acma a ON (ma.CustomerID = a.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountChanges acb ON (a.CustomerID = acb.CustomerID AND a.BeforeDate = acb.EffectiveDate AND acb.AccountID IS NULL AND acb.InactiveDate IS NULL)
	JOIN AccountChanges aca ON (a.CustomerID = aca.CustomerID AND a.AfterDate = aca.EffectiveDate AND aca.AccountID IS NULL AND aca.InactiveDate IS NULL)
	WHERE acb.CancelReasonID IS NOT NULL
	AND aca.CancelReasonID IS NULL
	AND bc.CycleType IN (0,3)
	AND (@CustomerID IS NOT NULL OR ma.BillDay <> DATEPART(dd,aca.EffectiveDate))
	AND NOT EXISTS (SELECT * FROM SubAccounts sa 
		WHERE sa.CustomerID = ma.CustomerID 
		AND sa.Active = 1
		AND sa.Recurring = 1
		AND (sa.BilledThru > aca.EffectiveDate OR (sa.BilledThru < DATEADD(dd,-1,acb.EffectiveDate) AND (sa.CancelDate IS NULL OR sa.BilledThru < DATEADD(dd,-1,sa.CancelDate)))))

IF (@CustomerID IS NOT NULL)
	BEGIN
	INSERT INTO #acbma (CustomerID,saBillDay)
	SELECT ma.CustomerID, MIN(DATEPART(dd,DATEADD(dd,1,sa.BilledThru))) AS saBillDay
	FROM MasterAccounts ma JOIN #acma a ON (ma.CustomerID = a.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		WHERE bc.CycleType IN (0,3)
		AND bc.AutoBill IN (0,1)
		AND sa.Active = 1
		AND sa.Recurring = 1
		AND ma.BillDay BETWEEN 2 AND 27
		AND ma.CustomerID = @CustomerID
		AND NOT EXISTS (SELECT * FROM #acbma bma WHERE bma.CustomerID = ma.CustomerID)
	GROUP BY ma.CustomerID
	HAVING MIN(DATEPART(dd,DATEADD(dd,1,sa.BilledThru))) = MAX(DATEPART(dd,DATEADD(dd,1,sa.BilledThru))) AND MIN(DATEPART(dd,DATEADD(dd,1,sa.BilledThru))) <> MIN(ma.BillDay) AND MIN(DATEPART(dd,sa.BilledThru)+1) <> MIN(ma.BillDay)
	END

UPDATE ma SET BillDay = a.saBillDay
FROM MasterAccounts ma JOIN #acbma a ON (ma.CustomerID = a.CustomerID) WHERE ma.BillDay <> a.saBillDay
END
GO

CREATE PROCEDURE dbo.AccountChangeAlertMBR (@CustomerID INT, @EffectiveDate DATETIME, @CancelReasonID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @Returning INT, @MAOpen DATETIME, @MAClose DATETIME

IF (@CancelReasonID IS NOT NULL)
BEGIN
SELECT @Returning = Returning FROM CancelReasons WHERE CancelReasonID = @CancelReasonID
END


SELECT @MAOpen = MAX(CASE WHEN ac.CancelReasonID IS NULL AND ac.AccountID IS NULL THEN ac.EffectiveDate END), 
@MAClose = MAX(CASE WHEN ac.CancelReasonID IS NOT NULL AND ac.AccountID IS NULL THEN ac.EffectiveDate END)
FROM AccountChanges ac
	WHERE ac.CustomerID = @CustomerID
	AND ac.AccountID IS NULL
	AND ac.InactiveDate IS NULL
	AND ac.EffectiveDate <= @EffectiveDate

SELECT CASE WHEN @CancelReasonID IS NULL AND ac.CancelReasonID IS NULL THEN 1
WHEN @CancelReasonID IS NULL AND ac.CancelReasonID IS NOT NULL THEN 2
WHEN @CancelReasonID IS NOT NULL AND @Returning = 1 AND ac.CancelReasonID IS NULL THEN 3
WHEN @CancelReasonID IS NOT NULL AND @Returning = 1 AND ac.CancelReasonID IS NOT NULL THEN 4
WHEN @CancelReasonID IS NOT NULL AND @Returning = 0 AND ac.CancelReasonID IS NULL THEN 5 
WHEN @CancelReasonID IS NOT NULL AND @Returning = 0 AND ac.CancelReasonID IS NOT NULL THEN 6
END AS AlertMapID, cr.CancelReason, cr.StringID AS crStringID, ac.EffectiveDate, NULL AS AccountID, NULL AS InvoiceID, NULL AS EndDate, NULL AS Login, NULL AS FirstName, NULL AS LastName

FROM AccountChanges ac LEFT JOIN CancelReasons cr ON (ac.CancelReasonID = cr.CancelReasonID)
	WHERE ac.CustomerID = @CustomerID
	AND ac.AccountID IS NULL
	AND ac.EffectiveDate > @EffectiveDate
	AND ac.InactiveDate IS NULL

UNION ALL

SELECT 12 AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, NULL AS EffectiveDate, NULL AS AccountID, NULL AS InvoiceID, NULL AS EndDate, NULL AS Login, NULL AS FirstName, NULL AS LastName
WHERE @CancelReasonID IS NULL AND (@MAOpen > @MAClose OR (@MAOpen IS NULL AND @MAClose IS NULL) OR (@MAOpen IS NOT NULL AND @MAClose IS NULL))

UNION ALL

SELECT 7 AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, NULL AS EffectiveDate, ii.AccountID, MIN(i.InvoiceID) AS InvoiceID, MAX(ii.EndDate) AS EndDate, MIN(sa.Login) AS Login, MIN(a.FirstName) AS FirstName, MIN(a.LastName) AS LastName
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SubAccounts sa ON (sa.CustomerID = i.CustomerID AND sa.AccountID = ii.AccountID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE i.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.CancelDate IS NULL
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.EndDate > @EffectiveDate
	AND @CancelReasonID IS NULL
GROUP BY ii.AccountID
GO

CREATE PROCEDURE dbo.AccountChangeAlertSA (@AccountID INT, @EffectiveDate DATETIME, @AccountTypeID INT, @CancelReasonID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @Returning INT, @MAOpen DATETIME, @MAClose DATETIME, @SAOpen DATETIME, @SAClose DATETIME, @CustomerID INT

IF (@CancelReasonID IS NOT NULL)
BEGIN
SELECT @Returning = Returning FROM CancelReasons WHERE CancelReasonID = @CancelReasonID
END

SELECT @CustomerID = CustomerID FROM SubAccounts WHERE AccountID = @AccountID

SELECT @MAOpen = MAX(CASE WHEN ac.CancelReasonID IS NULL AND ac.AccountID IS NULL THEN ac.EffectiveDate END), 
@MAClose = MAX(CASE WHEN ac.CancelReasonID IS NOT NULL AND ac.AccountID IS NULL THEN ac.EffectiveDate END),
@SAOpen = MAX(CASE WHEN ac.CancelReasonID IS NULL AND ac.AccountID = @AccountID THEN ac.EffectiveDate END),
@SAClose = MAX(CASE WHEN ac.CancelReasonID IS NOT NULL AND ac.AccountID = @AccountID THEN ac.EffectiveDate END)
FROM AccountChanges ac
	WHERE ac.CustomerID = @CustomerID
	AND (ac.AccountID IS NULL OR ac.AccountID = @AccountID)
	AND ac.InactiveDate IS NULL
	AND ac.EffectiveDate <= @EffectiveDate


SELECT 9 AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, NULL AS EffectiveDate, NULL AS InvoiceID, NULL AS EndDate
WHERE @CancelReasonID IS NULL AND (@MAClose > @MAOpen OR (@MAClose IS NOT NULL AND @MAOpen IS NULL))

UNION ALL

SELECT 10 AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, NULL AS EffectiveDate, NULL AS InvoiceID, NULL AS EndDate
WHERE @CancelReasonID IS NULL AND @AccountTypeID IS NOT NULL AND (@SAClose > @SAOpen OR (@SAClose IS NOT NULL AND @SAOpen IS NULL))

UNION ALL

SELECT 11 AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, NULL AS EffectiveDate, NULL AS InvoiceID, NULL AS EndDate
WHERE @CancelReasonID IS NULL AND @AccountTypeID IS NULL AND (@SAOpen > @SAClose OR (@SAOpen IS NULL AND @SAClose IS NULL) OR (@SAOpen IS NOT NULL AND @SAClose IS NULL))

UNION ALL

SELECT CASE WHEN @CancelReasonID IS NULL AND @AccountTypeID IS NOT NULL AND ac.CancelReasonID IS NULL AND ac.AccountTypeID IS NOT NULL THEN 13
WHEN @CancelReasonID IS NULL AND ac.CancelReasonID IS NULL THEN 1
WHEN @CancelReasonID IS NULL AND ac.CancelReasonID IS NOT NULL THEN 2
WHEN @CancelReasonID IS NOT NULL AND @Returning = 1 AND ac.CancelReasonID IS NULL THEN 3
WHEN @CancelReasonID IS NOT NULL AND @Returning = 1 AND ac.CancelReasonID IS NOT NULL THEN 4
WHEN @CancelReasonID IS NOT NULL AND @Returning = 0 AND ac.CancelReasonID IS NULL THEN 5 
WHEN @CancelReasonID IS NOT NULL AND @Returning = 0 AND ac.CancelReasonID IS NULL THEN 6
END AS AlertMapID, cr.CancelReason, cr.StringID AS crStringID, ac.EffectiveDate, NULL AS InvoiceID, NULL AS EndDate

FROM AccountChanges ac LEFT JOIN CancelReasons cr ON (ac.CancelReasonID = cr.CancelReasonID)
	WHERE ac.CustomerID = @CustomerID
	AND ac.AccountID = @AccountID
	AND ac.EffectiveDate > @EffectiveDate
	AND ac.InactiveDate IS NULL

UNION ALL

SELECT CASE WHEN @AccountTypeID IS NOT NULL THEN 8 ELSE 7 END AS AlertMapID, NULL AS CancelReason, NULL AS crStringID, @EffectiveDate AS EffectiveDate, i.InvoiceID AS InvoiceID, MAX(ii.EndDate) AS EndDate
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SubAccounts sa ON (sa.CustomerID = i.CustomerID AND sa.AccountID = ii.AccountID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE i.CustomerID = @CustomerID
	AND ii.AccountID = @AccountID
	AND sa.Active = 1
	AND sa.CancelDate IS NULL
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.EndDate >= @EffectiveDate
	AND @CancelReasonID IS NULL
GROUP BY i.InvoiceID
GO

CREATE PROCEDURE dbo.AccountChangeMBR (@CustomerID INT, @EffectiveDate DATETIME, @CancelReasonID INT, @clearfuture TINYINT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @MAOpen DATETIME, @MAClose DATETIME, @retcode INT, @Returning INT, @futureopen INT, @CancelDate DATETIME, @Active INT

SELECT @MAOpen = MAX(CASE WHEN ac.CancelReasonID IS NULL THEN ac.EffectiveDate END), 
@MAClose = MAX(CASE WHEN ac.CancelReasonID IS NOT NULL THEN ac.EffectiveDate END)
FROM AccountChanges ac
	WHERE ac.CustomerID = @CustomerID
	AND ac.AccountID IS NULL
	AND ac.InactiveDate IS NULL
	AND ac.EffectiveDate <= @EffectiveDate

IF (@retcode IS NULL AND @CancelReasonID IS NOT NULL)
BEGIN
SELECT @Returning = Returning FROM CancelReasons WHERE CancelReasonID = @CancelReasonID
END

IF (@retcode IS NULL)
BEGIN
SELECT @retcode = CASE WHEN COUNT(*) = 0 THEN 5 WHEN MAX(ma.Active) <> 1 AND @CancelReasonID IS NOT NULL THEN 3 WHEN MAX(bc.AutoBill) = 2 THEN 9 END, @CancelDate = MAX(ma.CancelDate), @Active = MAX(ma.Active)
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.CustomerID = @CustomerID
END

IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @MAOpen IS NOT NULL AND (@MAClose IS NULL OR @MAOpen > @MAClose))
BEGIN
SELECT @retcode = 7
END

IF (@retcode IS NULL AND @CancelReasonID IS NULL)
BEGIN
SELECT @retcode = CASE WHEN COUNT(*) > 0 THEN 6 ELSE NULL END
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SubAccounts sa ON (sa.CustomerID = i.CustomerID AND sa.AccountID = ii.AccountID)
	WHERE i.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.CancelDate IS NULL
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND @EffectiveDate BETWEEN ii.StartDate AND ii.EndDate
END

IF (@retcode IS NULL AND @CancelReasonID IS NULL)
BEGIN
UPDATE SubAccounts SET BilledThru = DATEADD(dd,-1,@EffectiveDate)
	WHERE CustomerID = @CustomerID
	AND ((CancelDate IS NULL AND @CancelDate IS NULL) OR BilledThru >= CancelDate OR BilledThru >= @CancelDate)
	AND Active = 1
	AND Recurring = 1
	AND BilledThru <> DATEADD(dd,-1,@EffectiveDate)
	AND (BilledThru > DATEADD(dd,-1,@EffectiveDate) OR NOT EXISTS
		(
		SELECT * 
		FROM AccountChanges ac 
			WHERE ac.CustomerID = SubAccounts.CustomerID 
			AND ac.InactiveDate IS NULL 
			AND ac.CancelReasonID IS NULL 
			AND (ac.AccountID IS NULL OR ac.AccountID = SubAccounts.AccountID)
			AND ac.EffectiveDate < @EffectiveDate
		))
	AND NOT EXISTS 
		(
		SELECT * 
		FROM AccountChanges ac 
			WHERE ac.CustomerID = SubAccounts.CustomerID 
			AND ac.InactiveDate IS NULL 
			AND ac.CancelReasonID IS NULL
			AND (ac.AccountID IS NULL OR ac.AccountID = SubAccounts.AccountID)
			AND ac.EffectiveDate >= @EffectiveDate
		)
END

IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @Active = 0)
BEGIN
UPDATE SubAccounts SET BilledThru = DATEADD(dd,-1,@EffectiveDate)
	WHERE CustomerID = @CustomerID
	AND BilledThru < DATEADD(dd,-1,@EffectiveDate)
	AND Recurring = 1
	AND Active = 1

UPDATE MasterAccounts SET Active = 1, LastModifyUser = @Operator, LastModifyDate = getdate() WHERE CustomerID = @CustomerID AND Active = 0
END

IF (@retcode IS NULL AND @CancelReasonID IS NOT NULL AND (@Returning = 0 OR @clearfuture = 1))
BEGIN
UPDATE AccountChanges SET InactiveDate = getdate(), InactiveUser = @Operator
	WHERE CustomerID = @CustomerID 
	AND (@Returning = 0 OR (@clearfuture = 1 AND AccountID IS NULL))
	AND EffectiveDate > @EffectiveDate
	AND InactiveDate IS NULL
END

IF (@retcode IS NULL)
BEGIN
INSERT INTO AccountChanges (CustomerID,ActiveDate,EffectiveDate,CancelReasonID,CreateUser) 
VALUES(@CustomerID,getdate(),@EffectiveDate,@CancelReasonID,@Operator)
END

SELECT @retcode AS Retcode
GO

CREATE PROCEDURE dbo.AccountChangeSA (@CustomerID INT, @AccountID INT, @AccountTypeID INT, @EffectiveDate DATETIME, @CancelReasonID INT, @clearfuture TINYINT, @newservice TINYINT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @MAOpen DATETIME, @MAClose DATETIME, @SAOpen DATETIME, @SAClose DATETIME, @retcode INT, @Returning INT, @CancelDate DATETIME, @StartDate DATETIME, @Active INT, @revoke INT, @suppress_nochange INT, @cnt INT

IF (@CustomerID IS NULL AND @AccountID IS NOT NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM SubAccounts WHERE AccountID = @AccountID
END

IF (@AccountTypeID IS NOT NULL AND @CancelReasonID IS NULL)
BEGIN
UPDATE AccountChanges SET InactiveDate = getdate(), InactiveUser = @Operator
	WHERE CustomerID = @CustomerID
	AND AccountID = @AccountID
	AND EffectiveDate = @EffectiveDate
	AND AccountTypeID IS NOT NULL
	AND AccountTypeID <> @AccountTypeID
	AND InactiveDate IS NULL
	AND CancelReasonID IS NULL

SELECT @suppress_nochange = CASE WHEN @@ROWCOUNT > 0 THEN 1 END
END

IF (@AccountTypeID IS NULL AND @CancelReasonID IS NULL)
BEGIN
UPDATE AccountChanges SET InactiveDate = getdate(), InactiveUser = @Operator
	WHERE CustomerID = @CustomerID
	AND AccountID = @AccountID
	AND EffectiveDate = @EffectiveDate
	AND InactiveDate IS NULL
	AND CancelReasonID IS NOT NULL

SELECT @revoke = CASE WHEN @@ROWCOUNT > 0 THEN 1 END
END

IF (@revoke IS NULL)
BEGIN
	SELECT @MAOpen = MAX(CASE WHEN CancelReasonID IS NULL AND AccountID IS NULL THEN EffectiveDate END), 
	@MAClose = MAX(CASE WHEN CancelReasonID IS NOT NULL AND AccountID IS NULL THEN EffectiveDate END),
	@SAOpen = MAX(CASE WHEN CancelReasonID IS NULL AND AccountID = @AccountID THEN EffectiveDate END),
	@SAClose = MAX(CASE WHEN CancelReasonID IS NOT NULL AND AccountID = @AccountID THEN EffectiveDate END)
	FROM AccountChanges
		WHERE CustomerID = @CustomerID
		AND InactiveDate IS NULL
		AND EffectiveDate <= @EffectiveDate
	
	IF (@CancelReasonID IS NULL AND ((@MAClose > @MAOpen) OR (@MAClose IS NOT NULL AND @MAOpen IS NULL)))
	BEGIN
	SELECT @retcode = CASE WHEN @AccountTypeID IS NOT NULL THEN 1 ELSE 2 END
	END

	IF (@retcode IS NULL AND @CancelReasonID IS NOT NULL)
	BEGIN
	SELECT @Returning = Returning FROM CancelReasons WHERE CancelReasonID = @CancelReasonID
	END
	
	IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @SAOpen IS NOT NULL AND (@SAClose IS NULL OR @SAOpen > @SAClose))
	BEGIN
	SELECT @retcode = 8
	FROM AccountChanges
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND ((@AccountTypeID IS NULL AND AccountTypeID IS NULL) OR (AccountTypeID = @AccountTypeID))
		AND InactiveDate IS NULL
		AND CancelReasonID IS NULL
		AND EffectiveDate = @SAOpen
	END
	
	IF (@retcode IS NULL)
	BEGIN
	SELECT @retcode = CASE WHEN COUNT(*) = 0 THEN 5 WHEN MAX(ma.Active) <> 1 THEN 3 WHEN MAX(sa.Active) <> 1 AND @CancelReasonID IS NOT NULL THEN 4 WHEN MAX(bc.AutoBill) = 2 THEN 9 WHEN MAX(sa.Recurring) = 0 THEN 10 END, @CancelDate = MAX(ma.CancelDate), @StartDate = MAX(sa.StartDate), @Active = MAX(sa.Active)
	FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		WHERE ma.CustomerID = @CustomerID
		AND sa.AccountID = @AccountID
	END
	
	IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @AccountTypeID IS NULL)
	BEGIN
	SELECT @retcode = CASE WHEN COUNT(*) > 0 THEN 6 ELSE NULL END
	FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
		WHERE i.CustomerID = @CustomerID
		AND ii.AccountID = @AccountID
		AND i.InvoiceTypeID IN (1,2,3,4,5)
		AND i.VoidDate IS NULL
		AND i.Processed = 1
		AND ii.Amount > 0
		AND ii.Quantity > 0
		AND ii.ItemType = 3
		AND @EffectiveDate BETWEEN ii.StartDate AND ii.EndDate
	END
	
	IF (@retcode IS NULL AND @CancelReasonID IS NULL AND ((@SAClose > @SAOpen) OR (@SAClose IS NOT NULL AND @SAOpen IS NULL)))
	BEGIN
	UPDATE SubAccounts SET BilledThru = DATEADD(dd,-1,@EffectiveDate), StartDate = @EffectiveDate
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND ((CancelDate IS NULL AND @CancelDate IS NULL) OR BilledThru >= CancelDate OR BilledThru >= @CancelDate)
		AND Active = 1
		AND Recurring = 1
		AND BilledThru <> DATEADD(dd,-1,@EffectiveDate)
		AND (BilledThru > DATEADD(dd,-1,@EffectiveDate) OR (@SAOpen IS NULL AND @MAOpen IS NULL))
		AND NOT EXISTS
			(
			SELECT * 
			FROM AccountChanges ac
				WHERE ac.CustomerID = SubAccounts.CustomerID
				AND ac.InactiveDate IS NULL
				AND ac.CancelReasonID IS NULL
				AND (ac.AccountID IS NULL OR ac.AccountID = SubAccounts.AccountID)
				AND (ac.EffectiveDate >= @EffectiveDate)
			)
	END
	
	IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @Active = 0)
	BEGIN
	UPDATE SubAccounts SET Active = CASE WHEN @newservice = 1 THEN Active ELSE 1 END, StartDate = CASE WHEN StartDate > @EffectiveDate THEN @EffectiveDate ELSE StartDate END, BilledThru = CASE WHEN BilledThru < DATEADD(dd,-1,@EffectiveDate) THEN DATEADD(dd,-1,@EffectiveDate) ELSE BilledThru END, LastModifyDate = getdate(), LastModifyUser = @Operator
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND Recurring = 1
		AND Active = 0
	END
	
	IF (@retcode IS NULL AND @CancelReasonID IS NOT NULL AND (@Returning = 0 OR @clearfuture = 1))
	BEGIN
	UPDATE AccountChanges SET InactiveDate = getdate(), InactiveUser = @Operator
		WHERE CustomerID = @CustomerID 
		AND AccountID = @AccountID 
		AND EffectiveDate > @EffectiveDate
		AND InactiveDate IS NULL
	END

	IF (@retcode IS NULL AND @CancelReasonID IS NULL AND @StartDate > @EffectiveDate)
	BEGIN
	UPDATE SubAccounts SET StartDate = @EffectiveDate
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND StartDate > @EffectiveDate
	END
	
	IF (@retcode IS NULL)
	BEGIN
	INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,AccountTypeID,CancelReasonID,CreateUser) VALUES(@CustomerID,@AccountID,getdate(),@EffectiveDate,@AccountTypeID,@CancelReasonID,@Operator)
	END

	IF (@retcode IS NULL AND @AccountTypeID IS NOT NULL AND @CancelReasonID IS NULL)
	BEGIN
	SELECT @cnt = COUNT(*)
	FROM AccountChanges
		WHERE EffectiveDate < @EffectiveDate
		AND AccountTypeID IS NOT NULL
		AND InactiveDate IS NULL
		AND CustomerID = @CustomerID
		AND AccountID = @AccountID

	IF (@cnt = 0)
		BEGIN
		INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,AccountTypeID,AllowReinvoice,CreateUser)
		SELECT CustomerID, AccountID, DATEADD(yy,-20,getdate()) AS ActiveDate, DATEADD(yy,-20,getdate()) AS EffectiveDate, AccountTypeID, 0, @Operator
		FROM SubAccounts
			WHERE CustomerID = @CustomerID
			AND AccountID = @AccountID
		END
	END
END

SELECT CASE WHEN @suppress_nochange = 1 AND @retcode = 8 THEN NULL ELSE @retcode END AS Retcode
GO

CREATE PROCEDURE dbo.AccountChangeTimeline (@CustomerID INT, @AccountID INT, @showservice TINYINT, @months INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #actac (AccountChangeID INT, InvoiceID INT)

INSERT INTO #actac (AccountChangeID, InvoiceID)
SELECT ac.AccountChangeID, MIN(i.InvoiceID)
FROM AccountChanges ac JOIN Invoices i ON (ac.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID AND (ac.AccountID IS NULL OR ac.AccountID = ii.AccountID))
	WHERE ac.CustomerID = @CustomerID
	AND (i.CreateDate > DATEADD(mm,-2,getdate()) OR ac.CancelReasonID IS NOT NULL OR (ac.AccountTypeID IS NOT NULL AND ii.AccountTypeID <> ac.AccountTypeID))
	AND ((ii.EndDate > ac.EffectiveDate) OR (ii.EndDate = ac.EffectiveDate AND ac.CancelReasonID IS NULL AND ac.AccountTypeID IS NOT NULL))
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ii.ItemType = 3
	AND ii.Quantity > 0
	AND i.InvoiceTypeID IN (1,2,3)
	AND ac.AllowReinvoice = 1
	AND (i.CreateDate < ac.ActiveDate OR i.CreateDate < ac.InactiveDate)
	AND NOT (i.CreateDate < ac.ActiveDate AND i.CreateDate < ac.InactiveDate AND ac.InactiveDate IS NOT NULL)
GROUP BY ac.AccountChangeID

SELECT ac.AccountChangeID, ac.CreateUser, sa.Login, a.FirstName, a.LastName, at1.AccountType, at1.StringID AS at1StringID, sc.ServiceCategory, sc.StringID AS scStringID, cr.CancelReason, cr.StringID AS crStringID, sa.AccountID, ac.ActiveDate, ac.InactiveDate, ac.EffectiveDate, i.InvoiceID, i.CreateDate, i.Amount,
CASE WHEN i.InvoiceID IS NOT NULL THEN 'conflict' WHEN ac.CancelReasonID IS NULL AND ac.AccountTypeID IS NOT NULL THEN 'changed' WHEN ac.CancelReasonID IS NULL THEN 'active' ELSE 'inactive' END AS Class
FROM AccountChanges ac LEFT JOIN #actac tac ON (ac.AccountChangeID = tac.AccountChangeID)
	LEFT JOIN Invoices i ON (tac.InvoiceID = i.InvoiceID)
	LEFT JOIN SubAccounts sa ON (ac.AccountID = sa.AccountID)
	LEFT JOIN AccountTypes at1 ON (ac.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ServiceCategories sc ON (sa.ServiceCategoryID = sc.ServiceCategoryID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN CancelReasons cr ON (ac.CancelReasonID = cr.CancelReasonID)
	WHERE ac.CustomerID = @CustomerID
	AND (sa.Active IS NULL OR sa.Active IN (1,0))
	AND (ac.AccountID IS NULL OR tac.AccountChangeID IS NOT NULL OR ac.AccountID = @AccountID OR (@AccountID IS NULL AND @showservice = 1))
	AND (ac.InactiveDate IS NULL OR tac.AccountChangeID IS NOT NULL)
	AND (@months = 0 OR i.InvoiceID IS NOT NULL OR ac.EffectiveDate > DATEADD(mm,-@months,getdate()))
ORDER BY ac.EffectiveDate DESC, ac.AccountChangeID DESC
GO

CREATE PROCEDURE dbo.AddrGetCustomFields (@AddressTypeID INT, @AddressID INT, @CustomerAccess TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT atdt.SortOrder, adt.AddressDataTypeID, adt.AddressDataType, adt.StringID, atdt.Required, CASE WHEN ad.AddressDataSourceID IS NULL OR ad.AddressDataSourceID = 2 THEN 0 ELSE 1 END AS ReadOnly, 1 AS Display, ad.Data
FROM AddressTypeDataTypes atdt LEFT JOIN AddressData ad ON (atdt.AddressDataTypeID = ad.AddressDataTypeID AND ad.AddressID = @AddressID)
	JOIN AddressDataTypes adt ON (atdt.AddressDataTypeID = adt.AddressDataTypeID)
	WHERE atdt.AddressTypeID = @AddressTypeID
	AND (@CustomerAccess = 0 OR atdt.CustomerAccess = 1)

UNION ALL

SELECT 0 AS SortOrder, adt.AddressDataTypeID, adt.AddressDataType, adt.StringID, NULL AS Required, 1 AS ReadOnly, 0 AS Display, ad.Data
FROM AddressData ad JOIN AddressDataTypes adt ON (ad.AddressDataTypeID = adt.AddressDataTypeID)
	WHERE ad.AddressID = @AddressID
	AND @CustomerAccess = 0
	AND NOT EXISTS (SELECT * FROM AddressTypeDataTypes atdt WHERE atdt.AddressTypeID = @AddressTypeID AND atdt.AddressDataTypeID = ad.AddressDataTypeID)
ORDER BY 1,3
GO

CREATE PROCEDURE dbo.AddrSearchZip (@CountryID INT, @Zip VARCHAR(20)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT City, StateID, COUNT(*) AS Cnt
FROM Addresses
	WHERE CountryID = @CountryID
	AND Zip = @Zip
	AND StateID IS NOT NULL
GROUP BY City, StateID
HAVING COUNT(*) > 2

UNION ALL

SELECT lzc.City,  lzc.StateID, 1 AS Cnt
FROM LocZipCodes lzc JOIN States s ON (lzc.StateID = s.StateID)
	WHERE s.CountryID = @CountryID 
	AND lzc.ZipCode = @Zip

ORDER BY 3 DESC
GO

CREATE PROCEDURE dbo.AddressAssign (@CustomerID INT) AS
SET NOCOUNT ON
CREATE TABLE #aambrmax (CustomerID INT, BillingPriority INT, ContactPriority INT, ShippingPriority INT, ServicePriority INT)
CREATE TABLE #aasamax (AccountID INT, ContactPriority INT, ServicePriority INT)

CREATE TABLE #aambrid (CustomerID INT, BillingAddressID INT, ContactAddressID INT, ShippingAddressID INT, ServiceAddressID INT)
CREATE TABLE #aasaid (AccountID INT, ContactAddressID INT, ServiceAddressID INT)

IF (@CustomerID IS NOT NULL)
BEGIN
INSERT INTO #aambrmax (CustomerID, BillingPriority, ContactPriority, ShippingPriority, ServicePriority)
SELECT MAX(ma.CustomerID), 
MAX(att.BillingPriority),
MAX(att.ContactPriority),
MAX(CASE WHEN a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL THEN att.ShippingPriority END),
MAX(CASE WHEN a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL THEN att.ServicePriority END)
FROM MasterAccounts ma LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AccountID IS NULL)
	LEFT JOIN AddressTypes att ON (a.AddressTypeID = att.AddressTypeID)
	WHERE ma.CustomerID = @CustomerID
END ELSE BEGIN
INSERT INTO #aambrmax (CustomerID, BillingPriority, ContactPriority, ShippingPriority, ServicePriority)
SELECT ma.CustomerID,
MAX(att.BillingPriority),
MAX(att.ContactPriority),
MAX(CASE WHEN a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL THEN att.ShippingPriority END),
MAX(CASE WHEN a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL THEN att.ServicePriority END)
FROM MasterAccounts ma LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AccountID IS NULL)
	LEFT JOIN AddressTypes att ON (a.AddressTypeID = att.AddressTypeID)
	WHERE ma.Active IN (1,0)
GROUP BY ma.CustomerID

CREATE INDEX aambrmax ON #aambrmax (CustomerID)
END

INSERT INTO #aambrid (CustomerID, BillingAddressID, ContactAddressID, ShippingAddressID, ServiceAddressID)
SELECT aa.CustomerID, 
MIN(CASE WHEN att.BillingPriority = aa.BillingPriority THEN a.AddressID END),
MIN(CASE WHEN att.ContactPriority = aa.ContactPriority AND att.ContactPriority > 0 THEN a.AddressID END),
MIN(CASE WHEN att.ShippingPriority = aa.ShippingPriority AND (a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL) THEN a.AddressID END),
MIN(CASE WHEN att.ServicePriority = aa.ServicePriority AND (a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL) THEN a.AddressID END)
FROM #aambrmax aa LEFT JOIN Addresses a ON (aa.CustomerID = a.CustomerID AND a.AccountID IS NULL)
	LEFT JOIN AddressTypes att ON (a.AddressTypeID = att.AddressTypeID)
GROUP BY aa.CustomerID

CREATE INDEX aambrid ON #aambrid (CustomerID)

UPDATE ma SET BillingAddressID = a.BillingAddressID, ShippingAddressID = a.ShippingAddressID, ServiceAddressID = a.ServiceAddressID
FROM MasterAccounts ma JOIN #aambrid a ON (ma.CustomerID = a.CustomerID)

INSERT INTO #aasamax (AccountID, ContactPriority, ServicePriority)
SELECT sa.AccountID,
MAX(att.ContactPriority),
MAX(CASE WHEN a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL THEN att.ServicePriority END)
FROM SubAccounts sa JOIN #aambrid ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (sa.CustomerID = a.CustomerID AND sa.AccountID = a.AccountID)
	LEFT JOIN AddressTypes att ON (a.AddressTypeID = att.AddressTypeID)
	WHERE sa.Active IN (1,0)
GROUP BY sa.AccountID

CREATE INDEX aasamax ON #aasamax (AccountID)


INSERT INTO #aasaid (AccountID, ContactAddressID, ServiceAddressID)
SELECT aa.AccountID, 
MIN(CASE WHEN att.ContactPriority = aa.ContactPriority AND att.ContactPriority > 0 THEN a.AddressID END),
MIN(CASE WHEN att.ServicePriority = aa.ServicePriority AND att.ServicePriority > 0 AND (a.Address1 IS NOT NULL OR a.Address2 IS NOT NULL) THEN a.AddressID END)
FROM #aasamax aa LEFT JOIN Addresses a ON (aa.AccountID = a.AccountID)
	LEFT JOIN AddressTypes att ON (a.AddressTypeID = att.AddressTypeID)
GROUP BY aa.AccountID

CREATE INDEX aasaid ON #aasaid (AccountID)

UPDATE sa SET ContactAddressID = COALESCE(said.ContactAddressID,maid.ContactAddressID,maid.BillingAddressID), ServiceAddressID = COALESCE(said.ServiceAddressID,maid.ServiceAddressID)
FROM SubAccounts sa JOIN #aasaid said ON (sa.AccountID = said.AccountID)
	JOIN #aambrid maid ON (sa.CustomerID = maid.CustomerID)

WHILE (@@ROWCOUNT <> 0)
BEGIN
UPDATE sa SET ContactAddressID = CASE WHEN ac.AccountID IS NULL AND pac.AccountID IS NOT NULL THEN sap.ContactAddressID ELSE sa.ContactAddressID END,
              ServiceAddressID = CASE WHEN as1.AccountID IS NULL AND pas.AccountID IS NOT NULL THEN sap.ServiceAddressID ELSE sa.ServiceAddressID END
FROM SubAccounts sa JOIN SubAccounts sap ON (sa.ParentAccountID = sap.AccountID)
	JOIN #aambrid maid ON (sa.CustomerID = maid.CustomerID AND sap.CustomerID = maid.CustomerID)
	JOIN Addresses pac ON (sap.ContactAddressID = pac.AddressID)
	JOIN Addresses pas ON (sap.ServiceAddressID = pas.AddressID)
	JOIN Addresses ac ON (sa.ContactAddressID = ac.AddressID)
	JOIN Addresses as1 ON (sa.ServiceAddressID = as1.AddressID)
	WHERE ((ac.AccountID IS NULL AND pac.AccountID IS NOT NULL) OR (as1.AccountID IS NULL AND pas.AccountID IS NOT NULL))
END
GO

CREATE PROCEDURE dbo.AddressClear (@CustomerID INT, @AddressID INT) AS
SET NOCOUNT ON
DECLARE @cnt INT
SELECT @cnt = COUNT(*) FROM Addresses WHERE CustomerID = @CustomerID AND AddressID = @AddressID

IF (@cnt = 1)
BEGIN
DELETE FROM AddressSyncs WHERE AddressID = @AddressID
DELETE FROM AddressData WHERE AddressID = @AddressID
UPDATE Files SET AddressID = NULL WHERE CustomerID = @CustomerID AND AddressID = @AddressID

UPDATE MasterAccounts SET BillingAddressID = CASE WHEN BillingAddressID = @AddressID THEN NULL ELSE BillingAddressID END,
ShippingAddressID = CASE WHEN ShippingAddressID = @AddressID THEN NULL ELSE ShippingAddressID END,
ServiceAddressID = CASE WHEN ServiceAddressID = @AddressID THEN NULL ELSE ServiceAddressID END
	WHERE CustomerID = @CustomerID
	AND (BillingAddressID = @AddressID OR ShippingAddressID = @AddressID OR ServiceAddressID = @AddressID)

UPDATE SubAccounts SET ContactAddressID = CASE WHEN ContactAddressID = @AddressID THEN NULL ELSE ContactAddressID END,
ServiceAddressID = CASE WHEN ServiceAddressID = @AddressID THEN NULL ELSE ServiceAddressID END
	WHERE CustomerID = @CustomerID
	AND (ContactAddressID = @AddressID OR ServiceAddressID = @AddressID)
END

SELECT @cnt AS Cnt
GO

CREATE PROCEDURE dbo.AddressGeoSourceGet (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @SyncDate DATETIME
SELECT @SyncDate = GETDATE()

IF (@CustomerID IS NULL)
BEGIN
SELECT a.AddressID, ags.GeoLayerID, ags.AddressGeoSourceID, ags.Overlap,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
@SyncDate AS SyncDate
FROM MasterAccounts ma JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AccountID IS NULL)
	JOIN AddressGeoSources ags ON (((ags.AllowBilling = 1 AND a.AddressID = ma.BillingAddressID) OR (ags.AllowShipping = 1 AND a.AddressID = ma.ShippingAddressID) OR (ags.AllowService = 1 AND a.AddressID = ma.ServiceAddressID))
		AND (ags.GroupID IS NULL OR ma.GroupID = ags.GroupID)
		AND (ags.CountryID IS NULL OR a.CountryID = ags.CountryID)
		AND (ags.StateID IS NULL OR a.StateID = ags.StateID)
		AND (ags.RegionID IS NULL OR ma.RegionID = ags.RegionID))
	JOIN GeoLayers gl ON (ags.GeoLayerID = gl.GeoLayerID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN AddressData ad ON (a.AddressID = ad.AddressID AND (ags.GeoShapeAddressDataTypeID = ad.AddressDataTypeID 
		OR ags.Aux1AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux2AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux3AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux4AddressDataTypeID = ad.AddressDataTypeID))
	WHERE ma.Active = 1
	AND gl.Status = 1
	AND (ad.AddressDataSourceID = 1 OR ad.Data IS NULL)
	AND ((a.Lat IS NOT NULL AND a.Long IS NOT NULL AND (ad.LastUpdate IS NULL OR ad.LastUpdate < a.LastModifyDate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate))
		OR ((a.Lat IS NULL OR a.Long IS NULL) AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL AND as1.ExportStatus = 1 AND (ad.LastUpdate IS NULL OR ad.LastUpdate < as1.LastUpdate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate)))

UNION

SELECT a.AddressID, ags.GeoLayerID, ags.AddressGeoSourceID, ags.Overlap,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
@SyncDate AS SyncDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN AddressGeoSources ags ON (ags.AllowService = 1
		AND (ags.GroupID IS NULL OR ma.GroupID = ags.GroupID)
		AND (ags.CountryID IS NULL OR a.CountryID = ags.CountryID)
		AND (ags.StateID IS NULL OR a.StateID = ags.StateID)
		AND (ags.RegionID IS NULL OR ma.RegionID = ags.RegionID))
	JOIN GeoLayers gl ON (ags.GeoLayerID = gl.GeoLayerID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN AddressData ad ON (ad.AddressDataSourceID = 1 AND a.AddressID = ad.AddressID AND (ags.GeoShapeAddressDataTypeID = ad.AddressDataTypeID 
		OR ags.Aux1AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux2AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux3AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux4AddressDataTypeID = ad.AddressDataTypeID))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND gl.Status = 1
	AND (ad.AddressDataSourceID = 1 OR ad.Data IS NULL)
	AND ((a.Lat IS NOT NULL AND a.Long IS NOT NULL AND (ad.LastUpdate IS NULL OR ad.LastUpdate < a.LastModifyDate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate))
		OR ((a.Lat IS NULL OR a.Long IS NULL) AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL AND as1.ExportStatus = 1 AND (ad.LastUpdate IS NULL OR ad.LastUpdate < as1.LastUpdate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate)))

END ELSE BEGIN

UPDATE ad SET Data = NULL 
FROM AddressData ad JOIN Addresses a ON (ad.AddressID = a.AddressID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	WHERE ad.AddressDataSourceID = 1
	AND ad.Data IS NOT NULL
	AND a.CustomerID = @CustomerID
	AND ((a.Lat IS NOT NULL AND a.Long IS NOT NULL AND (ad.LastUpdate IS NULL OR ad.LastUpdate < a.LastModifyDate))
		OR ((a.Lat IS NULL OR a.Long IS NULL) AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL AND as1.ExportStatus = 1 AND (ad.LastUpdate IS NULL OR ad.LastUpdate < as1.LastUpdate)))

SELECT a.AddressID, ags.GeoLayerID, ags.AddressGeoSourceID, ags.Overlap,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
@SyncDate AS SyncDate
FROM MasterAccounts ma JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AccountID IS NULL)
	JOIN AddressGeoSources ags ON (((ags.AllowBilling = 1 AND a.AddressID = ma.BillingAddressID) OR (ags.AllowShipping = 1 AND a.AddressID = ma.ShippingAddressID) OR (ags.AllowService = 1 AND a.AddressID = ma.ServiceAddressID))
		AND (ags.GroupID IS NULL OR ma.GroupID = ags.GroupID)
		AND (ags.CountryID IS NULL OR a.CountryID = ags.CountryID)
		AND (ags.StateID IS NULL OR a.StateID = ags.StateID)
		AND (ags.RegionID IS NULL OR ma.RegionID = ags.RegionID))
	JOIN GeoLayers gl ON (ags.GeoLayerID = gl.GeoLayerID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN AddressData ad ON (a.AddressID = ad.AddressID AND (ags.GeoShapeAddressDataTypeID = ad.AddressDataTypeID 
		OR ags.Aux1AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux2AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux3AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux4AddressDataTypeID = ad.AddressDataTypeID))
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND gl.Status = 1
	AND (ad.AddressDataSourceID = 1 OR ad.Data IS NULL)
	AND ((a.Lat IS NOT NULL AND a.Long IS NOT NULL AND (ad.LastUpdate IS NULL OR ad.LastUpdate < a.LastModifyDate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate))
		OR ((a.Lat IS NULL OR a.Long IS NULL) AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL AND as1.ExportStatus = 1 AND (ad.LastUpdate IS NULL OR ad.LastUpdate < as1.LastUpdate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate)))

UNION

SELECT a.AddressID, ags.GeoLayerID, ags.AddressGeoSourceID, ags.Overlap,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
@SyncDate AS SyncDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN AddressGeoSources ags ON (ags.AllowService = 1
		AND (ags.GroupID IS NULL OR ma.GroupID = ags.GroupID)
		AND (ags.CountryID IS NULL OR a.CountryID = ags.CountryID)
		AND (ags.StateID IS NULL OR a.StateID = ags.StateID)
		AND (ags.RegionID IS NULL OR ma.RegionID = ags.RegionID))
	JOIN GeoLayers gl ON (ags.GeoLayerID = gl.GeoLayerID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN AddressData ad ON (ad.AddressDataSourceID = 1 AND a.AddressID = ad.AddressID AND (ags.GeoShapeAddressDataTypeID = ad.AddressDataTypeID 
		OR ags.Aux1AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux2AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux3AddressDataTypeID = ad.AddressDataTypeID
		OR ags.Aux4AddressDataTypeID = ad.AddressDataTypeID))
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND gl.Status = 1
	AND (ad.AddressDataSourceID = 1 OR ad.Data IS NULL)
	AND ((a.Lat IS NOT NULL AND a.Long IS NOT NULL AND (ad.LastUpdate IS NULL OR ad.LastUpdate < a.LastModifyDate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate))
		OR ((a.Lat IS NULL OR a.Long IS NULL) AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL AND as1.ExportStatus = 1 AND (ad.LastUpdate IS NULL OR ad.LastUpdate < as1.LastUpdate OR ad.LastUpdate < gl.CreateDate OR ad.LastUpdate < ags.LastModifyDate)))
END
GO

CREATE PROCEDURE dbo.AddressGeoSourceUP (@AddressID INT, @AddressGeoSourceID INT, @GeoShape VARCHAR(128), @Aux1 VARCHAR(128), @Aux2 VARCHAR(128), @Aux3 VARCHAR(128), @Aux4 VARCHAR(128), @SyncDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GeoShapeAddressDataTypeID INT, @Aux1AddressDataTypeID INT, @Aux2AddressDataTypeID INT, @Aux3AddressDataTypeID INT, @Aux4AddressDataTypeID INT

SELECT @GeoShapeAddressDataTypeID = GeoShapeAddressDataTypeID, @Aux1AddressDataTypeID = Aux1AddressDataTypeID, @Aux2AddressDataTypeID = Aux2AddressDataTypeID, @Aux3AddressDataTypeID = Aux3AddressDataTypeID, @Aux4AddressDataTypeID = Aux4AddressDataTypeID
FROM AddressGeoSources
	WHERE AddressGeoSourceID = @AddressGeoSourceID

IF (@GeoShapeAddressDataTypeID IS NOT NULL)
BEGIN
UPDATE AddressData SET Data = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @GeoShape ELSE Data END,
LastUpdate = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @SyncDate ELSE LastUpdate END,
AddressDataSourceID = CASE WHEN Data IS NULL THEN 1 ELSE AddressDataSourceID END
	WHERE AddressID = @AddressID
	AND AddressDataTypeID = @GeoShapeAddressDataTypeID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressData (AddressID,AddressDataTypeID,AddressDataSourceID,LastUpdate,Data) VALUES(@AddressID,@GeoShapeAddressDataTypeID,1,@SyncDate,@GeoShape)
	END
END

IF (@Aux1AddressDataTypeID IS NOT NULL)
BEGIN
UPDATE AddressData SET Data = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @Aux1 ELSE Data END,
LastUpdate = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @SyncDate ELSE LastUpdate END,
AddressDataSourceID = CASE WHEN Data IS NULL THEN 1 ELSE AddressDataSourceID END
	WHERE AddressID = @AddressID
	AND AddressDataTypeID = @Aux1AddressDataTypeID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressData (AddressID,AddressDataTypeID,AddressDataSourceID,LastUpdate,Data) VALUES(@AddressID,@Aux1AddressDataTypeID,1,@SyncDate,@Aux1)
	END
END

IF (@Aux2AddressDataTypeID IS NOT NULL)
BEGIN
UPDATE AddressData SET Data = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @Aux2 ELSE Data END,
LastUpdate = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @SyncDate ELSE LastUpdate END,
AddressDataSourceID = CASE WHEN Data IS NULL THEN 1 ELSE AddressDataSourceID END
	WHERE AddressID = @AddressID
	AND AddressDataTypeID = @Aux2AddressDataTypeID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressData (AddressID,AddressDataTypeID,AddressDataSourceID,LastUpdate,Data) VALUES(@AddressID,@Aux2AddressDataTypeID,1,@SyncDate,@Aux2)
	END
END

IF (@Aux3AddressDataTypeID IS NOT NULL)
BEGIN
UPDATE AddressData SET Data = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @Aux3 ELSE Data END,
LastUpdate = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @SyncDate ELSE LastUpdate END,
AddressDataSourceID = CASE WHEN Data IS NULL THEN 1 ELSE AddressDataSourceID END
	WHERE AddressID = @AddressID
	AND AddressDataTypeID = @Aux3AddressDataTypeID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressData (AddressID,AddressDataTypeID,AddressDataSourceID,LastUpdate,Data) VALUES(@AddressID,@Aux3AddressDataTypeID,1,@SyncDate,@Aux3)
	END
END

IF (@Aux4AddressDataTypeID IS NOT NULL)
BEGIN
UPDATE AddressData SET Data = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @Aux4 ELSE Data END,
LastUpdate = CASE WHEN Data IS NULL OR AddressDataSourceID = 1 THEN @SyncDate ELSE LastUpdate END,
AddressDataSourceID = CASE WHEN Data IS NULL THEN 1 ELSE AddressDataSourceID END
	WHERE AddressID = @AddressID
	AND AddressDataTypeID = @Aux4AddressDataTypeID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressData (AddressID,AddressDataTypeID,AddressDataSourceID,LastUpdate,Data) VALUES(@AddressID,@Aux4AddressDataTypeID,1,@SyncDate,@Aux4)
	END
END
GO

CREATE PROCEDURE dbo.AddressSyncUpdate (@AddressID INT, @TransTypeID INT, @ProcTransID VARCHAR(1024), @Lat FLOAT, @Long FLOAT, @ExportStatus INT, @Message VARCHAR(512), @SessionRef VARCHAR(32)) AS
SET NOCOUNT ON
DECLARE @CountryID INT, @StateID INT, @Address1 VARCHAR(120), @Address2 VARCHAR(120), @City VARCHAR(60), @Zip VARCHAR(20)
SELECT @CountryID = CountryID, @StateID = StateID, @Address1 = Address1, @Address2 = Address2, @City = City, @Zip = Zip
FROM Addresses
	WHERE AddressID = @AddressID

IF (@SessionRef = ' ')
BEGIN
SELECT @SessionRef = NULL
END

IF (@ExportStatus = 1) -- Approve
BEGIN
UPDATE AddressSyncs SET CountryID = @CountryID, StateID = @StateID, Address1 = @Address1, Address2 = @Address2, City = @City, Zip = @Zip, Lat = @Lat, Long = @Long, LastUpdate = getdate(), ExportStatus = @ExportStatus, ErrorCount = 0, Message = @Message, ProcTransID = @ProcTransID, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, SessionRef = NULL
	WHERE AddressID = @AddressID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressSyncs (AddressID,CountryID,StateID,Address1,Address2,City,Zip,Lat,Long,CreateDate,LastUpdate,ExportStatus,Message,ProcTransID,SessionRef) 
	VALUES(@AddressID,@CountryID,@StateID,@Address1,@Address2,@City,@Zip,@Lat,@Long,getdate(),getdate(),@ExportStatus,@Message,@ProcTransID,NULL)
	END

END ELSE IF (@ExportStatus IN (2,3)) -- Decline, Error
BEGIN
UPDATE AddressSyncs SET CountryID = @CountryID, StateID = @StateID, Address1 = @Address1, Address2 = @Address2, City = @City, Zip = @Zip, Lat = NULL, Long = NULL, LastUpdate = getdate(), ExportStatus = @ExportStatus, ErrorCount = ErrorCount + 1, Message = @Message, ProcTransID = @ProcTransID, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, SessionRef = @SessionRef
	WHERE AddressID = @AddressID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO AddressSyncs (AddressID,CountryID,StateID,Address1,Address2,City,Zip,CreateDate,LastUpdate,ExportStatus,Message,ErrorCount,ProcTransID,SessionRef)
	VALUES(@AddressID,@CountryID,@StateID,@Address1,@Address2,@City,@Zip,getdate(),getdate(),@ExportStatus,@Message,1,@ProcTransID,@SessionRef)
	END
END
GO

CREATE PROCEDURE dbo.Aging (@OperatorGroupID INT, @GroupID INT, @OrganizationID INT, @RegionID INT, @MarketTagID INT, @BalanceGT NUMERIC(18,4), @BalanceLT NUMERIC(18,4)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.CustomerID, ma.PendingBalance, ta.Age0, ta.Age30, ta.Age60, ta.Age90, ta.Age120, a.FirstName, a.LastName, a.Company, a.PhoneWork, a.PhoneHome, ma.Active, ma.GroupID
FROM MasterAccounts ma JOIN 
	(
	SELECT i.CustomerID,
	SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,getdate()) AND getdate() THEN i.ChargeAmount - i.PaidAmount ELSE 0 END) AS Age0,
	SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,getdate()) AND DATEADD(dd,-30,getdate()) THEN i.ChargeAmount - i.PaidAmount ELSE 0 END) AS Age30,
	SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,getdate()) AND DATEADD(dd,-60,getdate()) THEN i.ChargeAmount - i.PaidAmount ELSE 0 END) AS Age60,
	SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,getdate()) AND DATEADD(dd,-90,getdate()) THEN i.ChargeAmount - i.PaidAmount ELSE 0 END) AS Age90,
	SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,getdate())THEN i.ChargeAmount - i.PaidAmount ELSE 0 END) AS Age120
	FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
		JOIN Groups g ON (ma.GroupID = g.GroupID)
		WHERE i.VoidDate IS NULL
		AND i.ChargeAmount > 0
		AND i.Processed = 1
		AND ma.Active = 1
		AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
		AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
		AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
		AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
		AND (@MarketTagID IS NULL OR EXISTS (SELECT * FROM MasterAccountTags mat WHERE ma.CustomerID = mat.CustomerID AND mat.MarketTagID = @MarketTagID AND mat.Active = 1))
		AND (@BalanceGT IS NULL OR ma.PendingBalance > @BalanceGT)
		AND (@BalanceLT IS NULL OR ma.PendingBalance < @BalanceLT)
		AND (@OperatorGroupID = 1 OR EXISTS (SELECT * FROM OperatorGroupAccess oga WHERE oga.ObjectGroupID = 101 AND oga.OperatorGroupID = @OperatorGroupID AND (oga.GroupID = ma.GroupID OR oga.GroupID = 1)))
	GROUP BY i.CustomerID
	) ta ON (ma.CustomerID = ta.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
ORDER BY 6 DESC, 5 DESC, 4 DESC, 3 DESC, 2 DESC
GO

CREATE PROCEDURE dbo.AlertMapGet (@AlertMapTypeID INT) AS
SET NOCOUNT ON
SELECT AlertMapID AS Value, Message AS Description
FROM AlertMaps
	WHERE AlertMapTypeID = @AlertMapTypeID
GO

CREATE PROCEDURE dbo.AuditLogsAdd (@LogMsgID INT, @CustomerID INT, @AccountID INT, @LogMsg VARCHAR(255), @Operator VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO AuditLogs (LogMsgID,CustomerID,AccountID,LogMsg,Operator) VALUES(@LogMsgID,@CustomerID,@AccountID,@LogMsg,@Operator)
GO

CREATE PROCEDURE dbo.AuditTableAdd (@AuditTransID INT,@MetaTableID INT,@KeyID INT,@AuditActionID SMALLINT) AS
SET NOCOUNT ON
INSERT INTO AuditTables (AuditTransID,MetaTableID,KeyID,AuditActionID) VALUES(@AuditTransID,@MetaTableID,@KeyID,@AuditActionID)
SELECT SCOPE_IDENTITY() AS AuditTableID
GO

CREATE PROCEDURE dbo.AuditTableInsertAdd (@AuditTableID INT, @MetaColumnID INT, @Data VARCHAR(1024)) AS
SET NOCOUNT ON
INSERT INTO AuditTableInserts (AuditTableID,MetaColumnID,Data) VALUES(@AuditTableID,@MetaColumnID,@Data)
GO

CREATE PROCEDURE dbo.AuditTableUpdateAdd (@AuditTableID INT, @MetaColumnID INT, @PreviousData VARCHAR(1024), @Data VARCHAR(1024)) AS
SET NOCOUNT ON
INSERT INTO AuditTableUpdates (AuditTableID,MetaColumnID,PreviousData,Data) VALUES(@AuditTableID,@MetaColumnID,@PreviousData,@Data)
GO

CREATE PROCEDURE dbo.AuditTransAdd (@OperatorID INT, @CustomerID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO AuditTrans (OperatorID,CustomerID,CommitDate,IPAddress) VALUES(@OperatorID,@CustomerID,getdate(),@IPAddress)
SELECT SCOPE_IDENTITY() AS AuditTransID
GO

CREATE PROCEDURE dbo.StatsUP AS
SET NOCOUNT ON
UPDATE Statistics Addresses WITH FULLSCAN
UPDATE Statistics AddressData WITH FULLSCAN
UPDATE Statistics MasterAccounts WITH FULLSCAN
UPDATE Statistics MasterAccountData WITH FULLSCAN
UPDATE Statistics SubAccounts WITH FULLSCAN
UPDATE Statistics SubAccountData WITH FULLSCAN
UPDATE Statistics Incidents WITH FULLSCAN
UPDATE Statistics IncidentData WITH FULLSCAN
UPDATE Statistics Actions WITH FULLSCAN
UPDATE Statistics Invoices WITH FULLSCAN
UPDATE Statistics InvoiceItems WITH FULLSCAN
UPDATE Statistics Payments WITH FULLSCAN
UPDATE Statistics PaymentItems WITH FULLSCAN
UPDATE Statistics Charges WITH FULLSCAN
GO

CREATE PROCEDURE dbo.CompressDB AS
SET NOCOUNT ON
EXEC('ALTER TABLE dbo.MasterAccounts REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.MasterAccountData REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.SubAccounts REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.SubAccountData REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Addresses REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.AddressData REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.CardAccounts REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Invoices REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.InvoiceItems REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Charges REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Statements REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Payments REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.PaymentItems REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.CallStarts REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.CallInterims REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.CallStops REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.RadLogs REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.GeoShapes REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.GeoPolygons REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.Incidents REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.IncidentData REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.Actions REBUILD WITH (DATA_COMPRESSION = ROW)')
EXEC('ALTER TABLE dbo.AuditLogs REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.AuditTrans REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.AuditTables REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.AuditTableUpdates REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.AuditTableInserts REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.NoticeLogs REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.SysLogs REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.ScheduleLogs REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.GaugeData REBUILD WITH (DATA_COMPRESSION = PAGE)')
EXEC('ALTER TABLE dbo.SMSWrites REBUILD WITH (DATA_COMPRESSION = ROW)')
GO

CREATE PROCEDURE dbo.DecompressDB AS
SET NOCOUNT ON
EXEC('ALTER TABLE dbo.MasterAccounts REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.MasterAccountData REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.SubAccounts REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.SubAccountData REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Addresses REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AddressData REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.CardAccounts REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Invoices REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.InvoiceItems REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Charges REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Statements REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Payments REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.PaymentItems REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.CallStarts REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.CallInterims REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.CallStops REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.RadLogs REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.GeoShapes REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.GeoPolygons REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Incidents REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.IncidentData REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.Actions REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AuditLogs REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AuditTrans REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AuditTables REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AuditTableUpdates REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.AuditTableInserts REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.NoticeLogs REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.SysLogs REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.ScheduleLogs REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.GaugeData REBUILD WITH (DATA_COMPRESSION = NONE)')
EXEC('ALTER TABLE dbo.SMSWrites REBUILD WITH (DATA_COMPRESSION = NONE)')
GO

CREATE PROCEDURE dbo.RebuildDB AS
SET NOCOUNT ON
EXEC('ALTER TABLE dbo.MasterAccounts REBUILD')
EXEC('ALTER TABLE dbo.MasterAccountData REBUILD')
EXEC('ALTER TABLE dbo.SubAccounts REBUILD')
EXEC('ALTER TABLE dbo.SubAccountData REBUILD')
EXEC('ALTER TABLE dbo.Addresses REBUILD')
EXEC('ALTER TABLE dbo.AddressData REBUILD')
EXEC('ALTER TABLE dbo.CardAccounts REBUILD')
EXEC('ALTER TABLE dbo.Invoices REBUILD')
EXEC('ALTER TABLE dbo.InvoiceItems REBUILD')
EXEC('ALTER TABLE dbo.Charges REBUILD')
EXEC('ALTER TABLE dbo.Statements REBUILD')
EXEC('ALTER TABLE dbo.Payments REBUILD')
EXEC('ALTER TABLE dbo.PaymentItems REBUILD')
EXEC('ALTER TABLE dbo.CallStarts REBUILD')
EXEC('ALTER TABLE dbo.CallInterims REBUILD')
EXEC('ALTER TABLE dbo.CallStops REBUILD')
EXEC('ALTER TABLE dbo.RadLogs REBUILD')
EXEC('ALTER TABLE dbo.GeoShapes REBUILD')
EXEC('ALTER TABLE dbo.GeoPolygons REBUILD')
EXEC('ALTER TABLE dbo.Incidents REBUILD')
EXEC('ALTER TABLE dbo.IncidentData REBUILD')
EXEC('ALTER TABLE dbo.Actions REBUILD')
EXEC('ALTER TABLE dbo.AuditLogs REBUILD')
EXEC('ALTER TABLE dbo.AuditTrans REBUILD')
EXEC('ALTER TABLE dbo.AuditTables REBUILD')
EXEC('ALTER TABLE dbo.AuditTableUpdates REBUILD')
EXEC('ALTER TABLE dbo.AuditTableInserts REBUILD')
EXEC('ALTER TABLE dbo.NoticeLogs REBUILD')
EXEC('ALTER TABLE dbo.SysLogs REBUILD')
EXEC('ALTER TABLE dbo.ScheduleLogs REBUILD')
EXEC('ALTER TABLE dbo.GaugeData REBUILD')
EXEC('ALTER TABLE dbo.SMSWrites REBUILD')
GO

CREATE PROCEDURE dbo.BackupDB (@devname VARCHAR(64), @description VARCHAR(128)) AS 
DECLARE @dbname varchar(128)
SELECT @dbname = DB_NAME()
BACKUP DATABASE @dbname TO @devname WITH INIT, DESCRIPTION = @description 
SELECT 'Database ' + @dbname + ' backed up to device ' + @devname AS Description
GO

CREATE PROCEDURE dbo.BackupDevInfo (@devname VARCHAR(64)) AS
RESTORE HEADERONLY FROM @devname
GO

CREATE PROCEDURE dbo.BankRouteGet (@ABANumber VARCHAR(128)) AS
SET NOCOUNT ON
SELECT BankName, BankPhone 
FROM BankRoutes
	WHERE ABANumber = @ABANumber
GO

CREATE PROCEDURE dbo.BatchProcessorGet (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @armed INT
SELECT @armed = COALESCE(MAX(NumValue),1) FROM Configs WHERE ConfigID = 672

IF (@CustomerID IS NULL)
BEGIN
SELECT bp.BatchProcessorID, bp.ExportID, bp.BatchProcessor, bp.BatchIn, bp.BatchOut, bp.BatchLimit, bp.ImportOptions, bp.ExportOptions, bp.ProcessorURL, bp.Login, bp.Password, bp.Merchant, @armed AS Armed
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
	AND bp.Active IN (1,0)
END ELSE BEGIN
SELECT bp.BatchProcessorID, bp.ExportID, bp.BatchProcessor, bp.BatchIn, bp.BatchOut, bp.BatchLimit, bp.ImportOptions, bp.ExportOptions, bp.ProcessorURL, bp.Login, bp.Password, bp.Merchant, @armed AS Armed
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE (@BatchProcessorID IS NULL OR BatchProcessorID = @BatchProcessorID)
	AND e.ExportType IN (5,6,10)
	AND bp.Active IN (1,0)
	AND bp.BatchProcessorID IN (SELECT BatchProcessorID FROM ExternalTrans WHERE CustomerID = @CustomerID AND TransStateID IN (0,1,2,3))
END
GO

CREATE PROCEDURE dbo.BatchGetTrans (@CustomerID INT) AS
SET NOCOUNT ON
IF (@CustomerID IS NULL)
BEGIN
SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE TransStateID IN (0,1,2,10)
END ELSE BEGIN
SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE CustomerID = @CustomerID
	AND TransStateID IN (0,1,2,10)
END
GO

CREATE PROCEDURE dbo.BatchReserve (@ExternalTransID INT) AS
UPDATE ExternalTrans SET TransStateID = 10
	WHERE ExternalTransID = @ExternalTransID
	AND TransStateID = 0
GO

CREATE PROCEDURE dbo.BatchStatements (@CustomerID INT, @GroupID INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
DECLARE @newinterval INT, @tmpcnt INT, @newpayments INT, @armed INT
SELECT @newinterval = COALESCE(MAX(NumValue),0) FROM Configs WHERE ConfigID = 505
SELECT @newpayments = MAX(NumValue) FROM Configs WHERE ConfigID = 377
SELECT @armed = CASE WHEN @CustomerID IS NULL THEN COALESCE(MAX(NumValue),1) ELSE 1 END FROM Configs WHERE ConfigID = 671

CREATE TABLE #tma (CustomerID INT PRIMARY KEY)
CREATE TABLE #ti (CustomerID INT, NewCharge NUMERIC(18,4), NewCredit NUMERIC(18,4), LastInvoiceID INT, InvoiceCount INT)
CREATE TABLE #tp (CustomerID INT, Amount NUMERIC(18,4), LastPaymentID INT, PayCount INT)

IF (@CustomerID IS NULL)
BEGIN
IF (@GroupID IS NULL)
	BEGIN
	INSERT INTO #tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
		WHERE i.StatementID IS NULL
		AND i.VoidDate IS NULL
		AND i.Processed = 1
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.Active = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.Active = 1
		AND @newpayments = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.Active = 1
		AND @newpayments = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1

	END ELSE BEGIN

	INSERT INTO #tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
		WHERE i.StatementID IS NULL
		AND i.VoidDate IS NULL
		AND i.Processed = 1
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
		AND @newpayments = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
		AND @newpayments = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
	END

DELETE FROM #tma
FROM #tma t JOIN ExternalTrans et ON (t.CustomerID = et.CustomerID)
	WHERE et.TransStateID IN (0,2)

DELETE FROM #tma
FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	WHERE bc.AutoBill IN (0,1)
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > GetDate())
	AND NOT EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.CustomerID = t.CustomerID AND i.Amount <> 0 AND i.StatementID IS NULL AND i.InvoiceTypeID IN (1,2,3,4,5,50))
	AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 15, getdate())
	AND sa.BilledThru > DATEADD(dd,-15,getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GetDate())

DELETE FROM #tma 
FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	WHERE bc.AutoBill IN (0,1)
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > GetDate())
	AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 2, getdate())
	AND EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(dd,-33,getdate()))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GetDate())

DELETE FROM #tma
FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
	JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	LEFT JOIN ConfigGroupData cg ON (ma.GroupID = cg.GroupID AND cg.ConfigID = 505)
	WHERE s.StatementDate > DATEADD(dd,-(COALESCE(cg.NumValue,@newinterval)),getdate())

IF (@OperatorGroupID IS NOT NULL)
	BEGIN
	SELECT @tmpcnt = COUNT(*) FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @OperatorGroupID AND GroupID = 1

	IF (@tmpcnt = 0)
		BEGIN
		DELETE FROM #tma 
		FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
			WHERE ma.GroupID NOT IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @OperatorGroupID)
		END
	END

INSERT INTO #ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
SELECT i.CustomerID, MAX(i.InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount > 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) > 0 THEN -(i.Amount) ELSE 0 END END) AS NewCharge,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount < 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) < 0 THEN -(i.Amount) ELSE 0 END END) AS NewCredit
FROM #tma t JOIN Invoices i ON (t.CustomerID = i.CustomerID)
	WHERE i.Processed = 1
	AND (i.StatementID IS NULL OR (i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL))
GROUP BY i.CustomerID

INSERT INTO #tp (CustomerID,LastPaymentID,PayCount,Amount)
SELECT p.CustomerID, MAX(p.PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
SUM(CASE WHEN p.StatementID IS NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount WHEN p.StatementID IS NULL THEN p.Amount WHEN p.StatementID IS NOT NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount-p.Amount END) AS Amount
FROM #tma t JOIN Payments p ON (t.CustomerID = p.CustomerID)
	WHERE (p.StatementID IS NULL OR (p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL))
	AND p.PaymentTypeID <> 0
GROUP BY p.CustomerID

END ELSE BEGIN

INSERT INTO #tma (CustomerID) VALUES(@CustomerID)

DELETE FROM #tma
FROM #tma t JOIN ExternalTrans et ON (t.CustomerID = et.CustomerID)
	WHERE et.TransStateID IN (0,2)

INSERT INTO #ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
SELECT CustomerID, MAX(InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
SUM(CASE WHEN StatementID IS NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL THEN 0 WHEN StatementID IS NULL THEN CASE WHEN Amount > 0 THEN Amount ELSE 0 END WHEN StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL THEN CASE WHEN -(Amount) > 0 THEN -(Amount) ELSE 0 END END) AS NewCharge,
SUM(CASE WHEN StatementID IS NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL THEN 0 WHEN StatementID IS NULL THEN CASE WHEN Amount < 0 THEN Amount ELSE 0 END WHEN StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL THEN CASE WHEN -(Amount) < 0 THEN -(Amount) ELSE 0 END END) AS NewCredit
FROM Invoices i
	WHERE CustomerID = @CustomerID
	AND (StatementID IS NULL OR (VoidDate IS NOT NULL AND VoidStatementID IS NULL))
	AND Processed = 1
GROUP BY CustomerID

INSERT INTO #tp (CustomerID,LastPaymentID,PayCount,Amount)
SELECT CustomerID, MAX(PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
SUM(CASE WHEN StatementID IS NULL AND FinalAmount IS NOT NULL AND FinalStatementID IS NULL THEN FinalAmount WHEN StatementID IS NULL THEN Amount WHEN StatementID IS NOT NULL AND FinalAmount IS NOT NULL AND FinalStatementID IS NULL THEN FinalAmount - Amount END) AS Amount
FROM Payments
	WHERE CustomerID = @CustomerID
	AND (StatementID IS NULL OR (FinalAmount IS NOT NULL AND FinalStatementID IS NULL))
GROUP BY CustomerID
END

IF (@GroupID IS NULL)
BEGIN
SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, a.FirstName, a.LastName, a.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.PrintDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge, @armed AS Armed
FROM MasterAccounts ma JOIN #tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN #ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN #tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
END ELSE BEGIN
SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, a.FirstName, a.LastName, a.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.PrintDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge, @armed AS Armed
FROM MasterAccounts ma JOIN #tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN #ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN #tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
	AND ma.GroupID = @GroupID
END
GO

CREATE PROCEDURE dbo.BillingACHPending (@BatchProcessorID INT, @MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT et.ExternalTransID AS TransID, et.CustomerID, et.AuthName AS AccountHolder, et.AccountNumber, et.BankName, et.BankNumber, et.AuthAddress AS Address, et.AuthZip AS Zip, et.Amount, et.AutoBill
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE ma.Active = 1
	AND bp.Active IN (1,0)
	AND et.TransStateID = 0
	AND e.ExportType IN (4,6)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	AND (@BatchProcessorID IS NULL OR et.BatchProcessorID = @BatchProcessorID)
GO

CREATE PROCEDURE dbo.BillingBalanceGet(@MBRGlobal INT, @OperatorGroupID INT, @CustomerID INT, @StatementID INT, @InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NOT NULL)
BEGIN
SELECT ma.PendingBalance AS Amount 
FROM MasterAccounts ma
	WHERE ma.CustomerID = @CustomerID
	AND PendingBalance > 0
	AND (@MBRGlobal=1 OR ma.GroupID IN(SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
END

IF (@StatementID IS NOT NULL)
BEGIN
SELECT s.EndBal AS Amount 
FROM Statements s JOIN MasterAccounts ma ON (s.CustomerID = ma.CustomerID)
	WHERE s.StatementID = @StatementID 
	AND s.EndBal > 0
	AND ma.PendingBalance >= s.EndBal
	AND (@MBRGlobal=1 OR ma.GroupID IN(SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
END

IF (@InvoiceID IS NOT NULL)
BEGIN
SELECT i.ChargeAmount AS Amount 
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.ChargeAmount > 0
	AND i.PaidAmount = 0
	AND (@MBRGlobal=1 OR ma.GroupID IN(SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
END
GO

CREATE PROCEDURE dbo.BillingBatchQ (@MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT b.BatchID, bs.BatchState, bs.StringID AS BatchStateStringID, bt.BatchType, bt.StringID AS btStringID, g.GroupName, g.GroupID, b.StartDate, b.BatchInfo, b.CreateUser, b.ItemCount, b.ItemTotal, o.Organization
FROM Batches b JOIN BatchStates bs ON (b.BatchStateID = bs.BatchStateID)
	JOIN BatchTypes bt ON (b.BatchTypeID = bt.BatchTypeID)
	JOIN Groups g ON (b.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE b.BatchStateID IN (1,7,4,2) 
	AND b.BatchTypeID IN (4,5)
	AND (@MBRGlobal = 1 OR b.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))
ORDER BY b.BatchTypeID DESC, b.StartDate, b.BatchID
GO

CREATE PROCEDURE dbo.BillingCCPending (@BatchProcessorID INT, @MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT et.ExternalTransID AS TransID, et.CustomerID, et.AuthName AS CardHolder, et.AccountNumber AS CardNumber, DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AuthAddress AS Address, et.AuthZip AS Zip, et.Amount, tt.TransType, tt.StringID AS ttStringID, et.AutoBill
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN TransTypes tt ON (et.TransTypeID = tt.TransTypeID)
	WHERE ma.Active = 1
	AND bp.Active IN (1,0)
	AND et.TransStateID = 0
	AND e.ExportType IN (1,5,10)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	AND (@BatchProcessorID IS NULL OR et.BatchProcessorID = @BatchProcessorID)
GO

CREATE PROCEDURE dbo.BillingGroupSummary (@MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #bgstmp (GroupID INT, ActiveCount INT, InactiveCount INT, TransCount INT)

INSERT INTO #bgstmp (GroupID,ActiveCount,InactiveCount,TransCount)
SELECT ma.GroupID, SUM(CASE WHEN ma.Active = 1 THEN 1 ELSE 0 END) AS ActiveCount, SUM(CASE WHEN ma.Active = 0 THEN 1 ELSE 0 END) AS InactiveCount, SUM(CASE WHEN ma.Active = 1 AND et.CustomerID IS NOT NULL THEN et.TransCount ELSE 0 END) AS TransCount
FROM MasterAccounts ma LEFT JOIN
	(
	SELECT CustomerID, COUNT(*) AS TransCount
	FROM ExternalTrans
		WHERE TransStateID IN (0,1,2) 
	GROUP BY CustomerID
	) et ON (ma.CustomerID = et.CustomerID)
GROUP BY ma.GroupID


SELECT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, SUM(ActiveCount) AS ActiveCount, SUM(InactiveCount) AS InactiveCount, SUM(TransCount) AS TransCount
FROM #bgstmp
	WHERE (@MBRGlobal = 1 OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))

UNION ALL

SELECT t.GroupID, o.Organization, g.GroupName, t.ActiveCount, t.InactiveCount, t.TransCount
FROM #bgstmp t JOIN Groups g ON (t.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE (@MBRGlobal = 1 OR t.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))
GO

CREATE PROCEDURE dbo.BillingImportList (@BatchProcessorID INT, @MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.CustomerID, DATEDIFF(dd,et.ReqDate,getdate()) AS Age, et.TransTypeID, a.FirstName, a.LastName, a.Company, et.Amount, et.ExternalTransID, et.ReqDate, 
CASE WHEN et.ReqDate < DATEADD(dd,-15,getdate()) THEN 'suspect' END AS Class, tt.TransType, et.AccountNumber
FROM ExternalTrans et JOIN TransTypes tt ON (et.TransTypeID = tt.TransTypeID)
	JOIN MasterAccounts ma ON (ma.CustomerID = et.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE et.TransStateID = 2
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	AND (@BatchProcessorID IS NULL OR et.BatchProcessorID = @BatchProcessorID)
	AND ma.Active IN (1,0)
GO

CREATE PROCEDURE dbo.BillingImportGet (@BillingImportID INT, @BillingImportTypeID INT) AS
SET NOCOUNT ON
SELECT RegExp, LookupQuery
FROM BillingImports
	WHERE BillingImportID = @BillingImportID
	AND BillingImportTypeID = @BillingImportTypeID
	AND LookupQuery IS NOT NULL
GO

CREATE PROCEDURE dbo.BillingPayCheck (@BillingImportID INT, @CustomerID INT, @InvoiceID INT, @StatementID INT, @ExternalRef VARCHAR(64), @PayInfo VARCHAR(64), @CheckNumber VARCHAR(16), @Amount NUMERIC(18,2)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NULL AND @StatementID IS NOT NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM Statements WHERE StatementID = @StatementID
END

IF (@CustomerID IS NULL AND @ExternalRef IS NOT NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM MasterAccounts WHERE ExternalRef = @ExternalRef
END

IF (@CustomerID IS NOT NULL AND @InvoiceID IS NOT NULL)
BEGIN
SELECT @InvoiceID = MIN(InvoiceID) FROM Invoices WHERE InvoiceID = @InvoiceID AND CustomerID = @CustomerID
END

IF (@CustomerID IS NULL AND @InvoiceID IS NOT NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM Invoices WHERE InvoiceID = @InvoiceID
END

IF (@CustomerID IS NOT NULL)
BEGIN
SELECT ma.CustomerID, ma.Active, ma.GroupID, a.FirstName, a.LastName, a.Company, @Amount AS Amount,
CASE WHEN @BillingImportID = 1 THEN 4 WHEN @CheckNumber IS NULL THEN 2 ELSE 4 END AS PaymentTypeID, 
CASE WHEN @BillingImportID = 1 THEN COALESCE(@CheckNumber,@PayInfo) ELSE @CheckNumber END AS CheckNumber,
CASE WHEN @BillingImportID = 1 THEN NULL ELSE @PayInfo END AS PayInfo, @InvoiceID AS InvoiceID,
(SELECT MIN(p.PaymentID) FROM Payments p 
	WHERE p.CustomerID = ma.CustomerID 
	AND COALESCE(p.FinalAmount,p.Amount) = @Amount 
	AND p.PaymentTypeID NOT IN (8,16,32)
	AND ((@BillingImportID = 1 AND p.CheckNumber = COALESCE(@CheckNumber,@PayInfo)) 
		OR (@BillingImportID <> 1 
			AND ((p.PaymentTypeID = 2 AND p.PayInfo = @PayInfo AND @PayInfo IS NOT NULL) 
			OR (p.PaymentTypeID = 4 AND p.CheckNumber = @CheckNumber AND @CheckNumber IS NOT NULL))))) AS DupePaymentID
FROM MasterAccounts ma LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.BulkEmail (@OperatorGroupID INT, @MBRGlobal INT, @BulkProfileID INT, @GroupID INT, @MarketTagID INT, @AccountTypeID INT, @ServiceCategoryID INT, @RegionID INT, @TowerID INT, @EventID INT, @SendMethodID INT, @BillingCycleID INT, @PaymentTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@BulkProfileID IS NOT NULL)
BEGIN
SELECT ma.CustomerID, MIN(a.FirstName) AS FirstName, MIN(a.LastName) AS LastName, MIN(a.Company) AS Company
FROM MasterAccounts ma LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BulkItems bi ON (bi.BulkProfileID = @BulkProfileID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN MasterAccountTags mat ON (ma.CustomerID = mat.CustomerID AND mat.Active = 1)
	LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
	LEFT JOIN Addresses ads ON (ma.CustomerID = ads.CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
	LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN CancelReasons macr ON (ma.CancelReasonID = macr.CancelReasonID)
	LEFT JOIN CancelReasons sacr ON (sa.CancelReasonID = sacr.CancelReasonID)
	LEFT JOIN MasterAccountData mad ON (ma.CustomerID = mad.CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
	WHERE ma.Active = 1
	AND (sa.Active IS NULL OR sa.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate() OR macr.Returning = 1)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate() OR sacr.Returning = 1)
	AND ((bc.AutoBill <> 2 AND sa.Recurring = 1) OR ((sa.DataLeft IS NULL OR sa.DataLeft > 0) AND (sa.TimeLeft IS NULL OR sa.TimeLeft > 0) AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())))
	AND (bi.GroupID IS NULL OR bi.GroupID = ma.GroupID)
	AND (bi.RegionID IS NULL OR bi.RegionID = ma.RegionID)
	AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
	AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
	AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
	AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
	AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
	AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
	AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
	AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
	AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
	AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
	AND (bi.City IS NULL OR bi.City = ads.City)
	AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
	AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
	AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID IN (101,401) AND OperatorGroupID = @OperatorGroupID))
GROUP BY ma.CustomerID
HAVING MIN(bi.Allowed) = 1
END ELSE BEGIN
SELECT DISTINCT ma.CustomerID, a.FirstName, a.LastName, a.Company
FROM MasterAccounts ma LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN MasterAccountTags mat ON (ma.CustomerID = mat.CustomerID AND mat.Active = 1)
	LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
	LEFT JOIN Incidents i ON (@EventID IS NOT NULL AND ma.CustomerID = i.IncidentID AND i.EventID = @EventID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN CancelReasons macr ON (ma.CancelReasonID = macr.CancelReasonID)
	LEFT JOIN CancelReasons sacr ON (sa.CancelReasonID = sacr.CancelReasonID)
	WHERE ma.Active = 1
	AND (sa.Active IS NULL OR sa.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate() OR macr.Returning = 1)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate() OR sacr.Returning = 1)
	AND ((bc.AutoBill <> 2 AND sa.Recurring = 1) OR ((sa.DataLeft IS NULL OR sa.DataLeft > 0) AND (sa.TimeLeft IS NULL OR sa.TimeLeft > 0) AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())))
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@MarketTagID IS NULL OR mat.MarketTagID = @MarketTagID OR sat.MarketTagID = @MarketTagID)
	AND (@AccountTypeID IS NULL OR sa.AccountTypeID = @AccountTypeID)
	AND (@ServiceCategoryID IS NULL OR sa.ServiceCategoryID = @ServiceCategoryID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@TowerID IS NULL OR sa.TowerID = @TowerID)
	AND (@EventID IS NULL OR i.EventID = @EventID)
	AND (@SendMethodID IS NULL OR ma.SendMethodID = @SendMethodID)
	AND (@BillingCycleID IS NULL OR ma.BillingCycleID = @BillingCycleID)
	AND (@PaymentTypeID IS NULL OR ma.PaymentTypeID = @PaymentTypeID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID IN (101,401) AND OperatorGroupID = @OperatorGroupID))
END
GO

CREATE PROCEDURE dbo.LDAPSetLastModifyDate (@type VARCHAR(10), @id VARCHAR(50)) AS
SET NOCOUNT ON
IF (@type = 'read')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncRead = getdate(), Calls = Calls + 1 WHERE LDAPServer = @id
IF (@@rowcount = 0)
	BEGIN
	INSERT INTO LDAPServers (LDAPServer,LastSyncWrite,LastModifyDate,LastSyncRead,Calls) VALUES(@id,'19900101',getdate(),getdate(),1)
	END
END

IF (@type = 'write')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncWrite = COALESCE(LastSyncRead,getdate()), Calls = Calls + 1 WHERE LDAPServer = @id
IF (@@rowcount = 0)
	BEGIN
	INSERT INTO LDAPServers (LDAPServer,LastModifyDate,LastSyncWrite,Calls) VALUES(@id,getdate(),getdate(),1)
	END
END

IF (@type = 'reset')
BEGIN
UPDATE LDAPServers SET LastSyncWrite = DATEADD(yy,-20,getdate()) WHERE LDAPServer = @id
END
GO

CREATE PROCEDURE dbo.LDAPmailAlternateAddress (@accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Alias as mail 
FROM Aliases 
	WHERE AccountID = @accountid
GO

CREATE PROCEDURE dbo.LDAPmailForwardingAddress (@accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Forward 
FROM Forwards 
	WHERE AccountID = @accountid
GO

CREATE PROCEDURE dbo.CGPROGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
CASE
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END AS pk,
CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> ' ' THEN sa.Login END AS uid,
a.FirstName + ' ' + a.LastName AS cn,
a.LastName AS sn,
sa.AccountID,
CASE WHEN (ma.CreditLimit > 0 AND ma.CreditLimit > ma.PendingBalance) THEN '{crypt}abcdefghijklm'
WHEN (ma.CancelDate < getdate() OR sa.CancelDate < getdate()) THEN '{crypt}abcdefghijklm'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN '{crypt}abcdefghijklm'
ELSE sa.Password 
END AS userpassword,
CASE WHEN al.Alias IS NULL THEN 
	CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain
	END ELSE NULL END AS mail,
es.MailHost AS hostserver,
'clear' AS passwordEncryption
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifyDate > ls.LastSyncWrite)
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.Password <> ' '
	AND (sa.Email LIKE '%_@_%' OR sa.Login <> ' ')
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.CGPROPartialNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE 
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Active IN (-1,0) OR ma.Active IN (-1,0))
	AND (sa.Login <> ' ' OR sa.Email LIKE '%_@_%')
	AND sa.Password <> ' '
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.CallsMissing (@numdays INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT cs.NASIdentifier, 
SUM(CASE WHEN ce.CallStartID IS NULL THEN 1 ELSE 0 END) AS MissingStopCount, 
SUM(CASE WHEN cs.AcctStatusType IN (2,3) THEN 1 ELSE 0 END) AS MissingStartCount
FROM CallStarts cs LEFT JOIN CallStops ce ON (cs.CallStartID = ce.CallStartID)
	WHERE cs.CallDate > DATEADD(dd,-@numdays,getdate())

GROUP BY cs.NASIdentifier
ORDER BY 2 DESC, 3 DESC
GO

CREATE PROCEDURE dbo.CallsMissingDetail (@numdays INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT MIN(cs.CallDate) AS CallDate,cs.CallStartID,MIN(cs.AccountID) AS AccountID,MIN(cs.Username) AS Username,CASE 
WHEN MIN(cs.AcctStatusType) IN (2,3) AND MIN(ce.CallStartID) IS NULL THEN 'Start,Stop'
WHEN MIN(ce.CallStartID) IS NULL THEN 'Stop' 
WHEN MIN(cs.AcctStatusType) IN (2,3) THEN 'Start' ELSE 'None' END AS Missing,
CASE WHEN MIN(sp.CallStartID) IS NULL THEN 'No' ELSE 'Yes' END AS Online,
SUM(CASE WHEN ci.CallInterimID IS NOT NULL THEN 1 ELSE 0 END) AS Interims,
MIN(cs.NASIdentifier) AS NASIdentifier,MIN(cs.AcctSessionID) AS AcctSessionID,
CAST(MAX(COALESCE(ce.AcctOutputOctets,ci.AcctOutputOctets)) / 1000000.0 AS NUMERIC(18,2)) AS DownloadMB,
CAST(MAX(COALESCE(ce.AcctInputOctets,ci.AcctInputOctets)) / 1000000.0 AS NUMERIC(18,2)) AS UploadMB,
CAST(MAX(COALESCE(ce.AcctSessionTime,ci.AcctSessionTime)) / 60.0 AS NUMERIC(18,2)) AS SessionMins,
CASE WHEN MIN(cs.AcctDelayTime) >= COALESCE(MIN(ce.AcctDelayTime),0) THEN MIN(cs.AcctDelayTime) ELSE MIN(ce.AcctDelayTime) END AS AcctDelayTime

FROM CallStarts cs LEFT JOIN CallStops ce ON (cs.CallStartID = ce.CallStartID)
	LEFT JOIN ServerPorts sp ON (cs.CallStartID = sp.CallStartID)
	LEFT JOIN CallInterims ci ON (cs.CallStartID = ci.CallStartID)
	WHERE cs.CallDate > DATEADD(dd,-@numdays,getdate())
	AND (cs.AcctStatusType IN (2,3) OR ce.CallStartID IS NULL)
GROUP BY cs.CallStartID

ORDER BY 8,6,1,3,5
GO

CREATE PROCEDURE dbo.CanceledAccounts WITH RECOMPILE AS
SET NOCOUNT ON

DECLARE @yn INT, @autovoid INT, @mbrcount INT, @sacount INT, @invcount INT, @nrexpdays INT
SELECT @yn = MAX(NumValue) FROM Configs WHERE ConfigID = 34
SELECT @autovoid = MAX(NumValue) FROM Configs WHERE ConfigID = 651
SELECT @nrexpdays = MAX(NumValue) FROM Configs WHERE ConfigID = 737

CREATE TABLE #canaaxe (CustomerID INT PRIMARY KEY)

INSERT INTO #canaaxe (CustomerID)
SELECT ma.CustomerID
FROM MasterAccounts ma JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 34)
	WHERE ma.Active = 1
	AND ((ma.PendingBalance = 0 AND ma.Balance = 0) OR (cgd.NumValue = 1) OR (cgd.NumValue IS NULL AND @yn = 1))
	AND ma.CancelDate < getdate()
	AND cr.Returning = 0
	AND bc.AutoBill IN (0,1)

UNION ALL

SELECT ma.CustomerID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 737)
	JOIN
		(
		SELECT CustomerID, MAX(ExpireDate) AS ExpireDate
		FROM SubAccounts
			WHERE Active = 1
			AND ExpireDate IS NOT NULL
		GROUP BY CustomerID
		) asa ON (ma.CustomerID = asa.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill = 2
	AND COALESCE(cgd.NumValue,@nrexpdays) > 0
	AND asa.ExpireDate < DATEADD(dd,-COALESCE(cgd.NumValue,@nrexpdays),getdate())

	
UPDATE ma SET Active = 0, LastModifyDate = getdate(), LastModifyUser = 'Scheduler' 
FROM MasterAccounts ma JOIN #canaaxe ca ON (ma.CustomerID = ca.CustomerID)

SELECT @mbrcount = @@ROWCOUNT

INSERT INTO AuditLogs(LogDate, LogMsgID, LogMsg, Operator, CustomerID, AccountID)
SELECT getdate(), 111, 'CID:' + CAST(ma.CustomerID AS VARCHAR(10)) + ' - Balance:' + CAST(ma.PendingBalance AS VARCHAR(15)), 'Scheduler', ma.CustomerID, NULL
FROM MasterAccounts ma JOIN #canaaxe a ON (ma.CustomerID = a.CustomerID)

UPDATE et SET TransStateID = 9
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 651)
	WHERE ma.PendingBalance <= 0
	AND ma.Active = 1
	AND et.TransStateID = 3
	AND et.TransTypeID IN (16,64)
	AND et.ReqDate < DATEADD(hh,-3,getdate())
	AND (cgd.NumValue = 1 OR (cgd.NumValue IS NULL AND @autovoid = 1))

UPDATE sa SET Active = 0, LastModifyDate = getdate(), LastModifyUser = 'Scheduler'
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN CancelReasons cr ON (sa.CancelReasonID = cr.CancelReasonID)
	WHERE at1.InactCanceledDays > 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND cr.Returning = 0
	AND sa.CancelDate < DATEADD(dd,-(at1.InactCanceledDays),getdate())

SELECT @sacount = @@ROWCOUNT

UPDATE ii SET CustomerID = NULL, AccountID = NULL, InvStateID = ip.CloseInvStateID
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN CancelReasons crma ON (ma.CancelReasonID = crma.CancelReasonID)
	LEFT JOIN CancelReasons crsa ON (sa.CancelReasonID = crsa.CancelReasonID)
	WHERE ip.CloseInvStateID IS NOT NULL
	AND is1.InvStateTypeID = 3
	AND (	(ma.Active < 1 AND ma.LastModifyDate < DATEADD(dd,-3,getdate())) OR
		(sa.Active < 1 AND sa.LastModifyDate < DATEADD(dd,-3,getdate())) OR
		(ma.CancelDate < DATEADD(dd,-3,getdate()) AND crma.Returning = 0) OR
		(sa.CancelDate < DATEADD(dd,-3,getdate()) AND crsa.Returning = 0))

SELECT @invcount = @@ROWCOUNT

SELECT 'MBRs:' + CAST(@mbrcount AS VARCHAR(20)) + ', Services:' + CAST(@sacount AS VARCHAR(20)) + ', Inventory:' + CAST(@invcount AS VARCHAR(20)) AS Description
GO

CREATE PROCEDURE dbo.CardAccountRecharge (@AccountID INT, @CardLogin VARCHAR(64), @CardPassword VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @CustomerID INT, @RC SMALLINT, @OrganizationID INT, @AccountTypeID INT, @CardAccountID INT, @TimeLeft INT, @DataLeft BIGINT, @RateTimeLeft INT, @RateDataLeft BIGINT, @ActiveExpireDays INT, @ActiveExpireMins INT, @DirectAmount NUMERIC(18,4), @AutoBill INT, @PaymentID INT, @trackmode INT

SELECT @CardAccountID = MAX(CardAccountID), @TimeLeft = COALESCE(MAX(cb.TimeLeft),0), @DataLeft = COALESCE(MAX(cb.DataLeft),0), @RateTimeLeft = COALESCE(MAX(cb.RateTimeLeft),0), @RateDataLeft = COALESCE(MAX(cb.RateDataLeft),0), @DirectAmount = COALESCE(MAX(cb.DirectAmount),0), @ActiveExpireDays = COALESCE(MAX(cb.ActiveExpireDays),0), @ActiveExpireMins = COALESCE(MAX(cb.ActiveExpireMins),0)
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	WHERE ca.Login = @CardLogin 
	AND ca.Password = @CardPassword

SELECT @CustomerID = MAX(ma.CustomerID), @AccountTypeID = MAX(sa.AccountTypeID), @OrganizationID = MAX(g.OrganizationID), @AutoBill = MAX(bc.AutoBill)
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1 
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.AccountID = @AccountID
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())

SELECT @trackmode = NumValue FROM Configs WHERE ConfigID = 535
SELECT @trackmode = COALESCE(MAX(cgd.NumValue),@trackmode)
FROM ConfigGroupData cgd JOIN MasterAccounts ma ON (cgd.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND cgd.ConfigID = 535

IF (@CardAccountID IS NOT NULL AND @CustomerID IS NOT NULL)
BEGIN
UPDATE CardAccounts SET UsedForDirect = 1, FirstUseDate = getdate(), DirectCustomerID = @CustomerID, DirectAccountID = @AccountID
	WHERE Active = 1
	AND UsedForCredit = 0
	AND AllowDirect = 1
	AND UsedForDirect = 0
	AND OrganizationID = @OrganizationID
	AND CardAccountID = @CardAccountID
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > getdate())
	AND CardBatchID IN (SELECT cb.CardBatchID FROM CardBatches cb WHERE cb.Active = 1 AND cb.AccountTypeID = @AccountTypeID)

IF (@@ROWCOUNT = 1)
	BEGIN

	IF (@trackmode = 2 AND (@TimeLeft > 0 OR @DataLeft > 0 OR @RateTimeLeft > 0 OR @RateDataLeft > 0))
	BEGIN	
	INSERT INTO SubAccountUsages (AccountID,TimeLeft,DataLeft,RateTimeLeft,RateDataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT @AccountID, @TimeLeft,@DataLeft,@TimeLeft,@DataLeft,@RateTimeLeft,@RateDataLeft,DATEADD(mi,@ActiveExpireMins,DATEADD(dd,CASE WHEN @ActiveExpireDays = 0 AND @ActiveExpireMins = 0 THEN 720 ELSE @ActiveExpireDays END,getdate()))
	FROM SubAccounts 
		WHERE AccountID = @AccountID
	END

	UPDATE SubAccounts SET	TimeLeft = CASE WHEN TimeLeft IS NULL OR @TimeLeft = 0 OR @trackmode = 2 THEN TimeLeft WHEN TimeLeft <= 0 THEN @TimeLeft ELSE TimeLeft + @TimeLeft END,
				DataLeft = CASE WHEN DataLeft IS NULL OR @DataLeft = 0 OR @trackmode = 2 THEN DataLeft WHEN DataLeft <= 0 THEN @DataLeft ELSE DataLeft + @DataLeft END,
				RateTimeLeft = CASE WHEN RateTimeLeft IS NULL OR @RateTimeLeft = 0 OR @trackmode = 2 THEN RateTimeLeft WHEN RateTimeLeft <= 0 THEN @RateTimeLeft ELSE RateTimeLeft + @RateTimeLeft END,
				RateDataLeft = CASE WHEN RateDataLeft IS NULL OR @RateDataLeft = 0 OR @trackmode = 2 THEN RateDataLeft WHEN RateDataLeft <= 0 THEN @RateDataLeft ELSE RateDataLeft + @RateDataLeft END,
				ExpireDate = CASE WHEN ExpireDate IS NULL OR (@ActiveExpireDays = 0 AND @ActiveExpireMins = 0) OR (@AutoBill IN (0,1) AND Recurring = 1)  THEN ExpireDate WHEN (@AutoBill = 2 OR Recurring = 0) AND ExpireDate < getdate() THEN DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,getdate())) ELSE DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,ExpireDate)) END,
				BilledThru = CASE WHEN BilledThru IS NULL OR (@ActiveExpireDays = 0 AND @ActiveExpireMins = 0) OR (@AutoBill IN (0,1) AND Recurring = 1) THEN BilledThru WHEN (@AutoBill = 2 OR Recurring = 0) AND BilledThru < getdate() THEN DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,getdate())) ELSE DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,BilledThru)) END
	WHERE AccountID = @AccountID

	IF (@DirectAmount > 0)
		BEGIN
		INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
		VALUES(@CustomerID,@DirectAmount,getdate(),NULL,32,'prepaid recharge credit',1,getdate(),'prepaid auto')
		SELECT @PaymentID = SCOPE_IDENTITY()
		END

	SELECT @RC = 0

	END ELSE BEGIN
	SELECT @RC = -3
	END

END ELSE BEGIN
SELECT @RC = CASE WHEN @CustomerID IS NULL THEN -1 ELSE -2 END
END

SELECT @RC AS Status, @CustomerID AS CustomerID, @PaymentID AS PaymentID
GO

CREATE PROCEDURE dbo.CardUnusedReset (@reset INT, @agemax INT) AS
SET NOCOUNT ON
CREATE TABLE #caf (CardAccountID INT, CustomerID INT, AccountID INT)

INSERT INTO #caf (CardAccountID, CustomerID, AccountID)
SELECT ca.CardAccountID, ma.CustomerID, sa.AccountID
FROM CardAccounts ca JOIN MasterAccounts ma ON (ma.CustomerID = ca.DirectCustomerID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.AccountID = ca.DirectAccountID)
	JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Incidents i ON (sa.AccountID = i.AccountID)
	LEFT JOIN Payments p ON (ma.CustomerID = p.CustomerID AND p.PaymentTypeID <> 32)
	LEFT JOIN Invoices inv ON (ma.CustomerID = inv.CustomerID)
	LEFT JOIN Charges ch ON (ma.CustomerID = ch.CustomerID)
	LEFT JOIN CallStarts cs ON (sa.AccountID = cs.AccountID)
	LEFT JOIN RateHistory rh ON (sa.AccountID = rh.AccountID)
	LEFT JOIN Statements s ON (ma.CustomerID = s.CustomerID)
	WHERE bc.AutoBill = 2
	AND cb.AllowDirect = 1
	AND ma.Active = 1
	AND sa.Active = 1
	AND cb.Active = 1
	AND ca.Active = 1
	AND p.PaymentID IS NULL
	AND i.IncidentID IS NULL
	AND inv.InvoiceID IS NULL
	AND ch.ChargeID IS NULL
	AND cs.CallStartID IS NULL
	AND rh.AccountID IS NULL
	AND s.StatementID IS NULL
	AND ma.ExternalRef IS NULL
	AND ((cb.TimeLeft IS NULL AND sa.TimeLeft IS NULL) OR (cb.TimeLeft = sa.TimeLeft))
	AND ((cb.DataLeft IS NULL AND sa.DataLeft IS NULL) OR (cb.DataLeft = sa.DataLeft))
	AND ma.BillingAddressID IS NULL
	AND ma.CreateDate < DATEADD(dd,-4,getdate())
	AND (@agemax IS NULL OR ma.CreateDate > DATEADD(dd,-@agemax,getdate()))
	AND ca.AllowDirect = 0
	AND ca.UsedForDirect = 1
	AND ca.UsedForCredit = 0
	AND (SELECT COUNT(*) FROM SubAccounts sa2 WHERE sa2.CustomerID = ma.CustomerID) = 1
	AND (SELECT COUNT(*) FROM Payments p2 WHERE p2.CustomerID = ma.CustomerID) <= 1

IF (@reset = 1)
BEGIN
UPDATE ca SET AllowDirect = cb.AllowDirect, UsedForDirect = 0, FirstUseDate = NULL, AllowCredit = CASE WHEN cb.Amount IS NOT NULL THEN 1 ELSE 0 END, DirectCustomerID = NULL, DirectAccountID = NULL
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN #caf c ON (ca.CardAccountID = c.CardAccountID)

DELETE FROM PaymentItems WHERE PaymentID IN (SELECT PaymentID FROM Payments p, #caf c WHERE p.CustomerID = c.CustomerID)
DELETE FROM Payments WHERE CustomerID IN (SELECT CustomerID FROM #caf)
DELETE FROM SubAccounts WHERE AccountID IN (SELECT AccountID FROM #caf)
DELETE FROM MasterAccounts WHERE CustomerID IN (SELECT CustomerID FROM #caf)

END ELSE BEGIN

SELECT ca.CardAccountID, ca.Login, cb.CardBatch, cbt.CardBatchType, ca.FirstUseDate AS UseDate, c.CustomerID, c.AccountID
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN CardBatchTypes cbt ON (cb.CardBatchTypeID = cbt.CardBatchTypeID)
	JOIN #caf c ON (ca.CardAccountID = c.CardAccountID)
ORDER BY cb.CardBatch, ca.FirstUseDate

END
GO

CREATE PROCEDURE dbo.CertEncryptedDelete (@CertID INT) AS
SET NOCOUNT ON
UPDATE CreditCards SET CertID = NULL, CertCardNumber = NULL WHERE CertID = @CertID
GO

CREATE PROCEDURE dbo.CertEncryptedSummary (@CertID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 'Credit Cards' AS Description, COUNT(*) AS Cnt
FROM CreditCards
	WHERE CertID = @CertID
	AND CertCardNumber IS NOT NULL
GO

CREATE PROCEDURE dbo.CertCheck (@OperatorID INT, @ClientCert VARCHAR(128)) AS
SET NOCOUNT ON
SELECT CASE WHEN cc.ClientCertInactID IS NOT NULL THEN 0 WHEN ExpireDate < getdate() THEN 2 WHEN cc.DownloadOperatorID IS NULL AND cc.DownloadDate IS NULL THEN 3 ELSE 1 END AS Status, cci.ClientCertInact, cc.ExpireDate
FROM ClientCerts cc LEFT JOIN ClientCertInacts cci ON (cc.ClientCertInactID = cci.ClientCertInactID)
	WHERE cc.OperatorID = @OperatorID
	AND cc.ClientCert = @ClientCert
GO

CREATE PROCEDURE dbo.CertDownloadCheck (@OperatorID INT, @ClientCertID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
SELECT ClientCert, Bits, ClientCertID AS SerialNumber, DATEDIFF(dd,getdate(),ExpireDate) AS ExpireDays
FROM ClientCerts
	WHERE OperatorID = @OperatorID
	AND ClientCertID = @ClientCertID
	AND (DownloadDate IS NULL OR DownloadDate > DATEADD(ss,-20,getdate()))
	AND (DownloadOperatorID IS NULL OR DownloadOperatorID = @OperatorID)
	AND (DownloadIPAddress IS NULL OR DownloadIPAddress = @IPAddress)
	AND ClientCertInactID IS NULL
	AND ExpireDate > getdate()
	AND @IPAddress <> ''
GO

CREATE PROCEDURE dbo.CertDownloadCheckOP (@ClientCertID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
SELECT ClientCert, Bits, ClientCertID AS SerialNumber, DATEDIFF(dd,getdate(),ExpireDate) AS ExpireDays
FROM ClientCerts
	WHERE ClientCertID = @ClientCertID
	AND (DownloadDate IS NULL OR DownloadDate > DATEADD(ss,-20,getdate()))
	AND DownloadOperatorID IS NOT NULL
	AND (DownloadIPAddress IS NULL OR DownloadIPAddress = @IPAddress)
	AND ClientCertInactID IS NULL
	AND ExpireDate > getdate()
	AND @IPAddress <> ''
GO

CREATE PROCEDURE dbo.CertDownloadList (@OperatorID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
SELECT ClientCertID, ClientCert
FROM ClientCerts 
	WHERE OperatorID = @OperatorID
	AND (DownloadDate IS NULL OR DownloadDate > DATEADD(ss,-20,getdate()))
	AND (DownloadOperatorID IS NULL OR DownloadOperatorID = @OperatorID)
	AND (DownloadIPAddress IS NULL OR DownloadIPAddress = @IPAddress)
	AND ClientCertInactID IS NULL
	AND ExpireDate > getdate()
	AND @IPAddress <> ''
ORDER BY ClientCert
GO

CREATE PROCEDURE dbo.CertDownloaded (@OperatorID INT, @ClientCertID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @Operator VARCHAR(32)
SELECT @Operator = Operator FROM Operators WHERE OperatorID = @OperatorID
UPDATE ClientCerts SET DownloadOperatorID = @OperatorID, DownloadIPAddress = @IPAddress, DownloadDate = getdate(), LastModifyUser = @Operator, LastModifyDate = getdate()
	WHERE OperatorID = @OperatorID
	AND ClientCertID = @ClientCertID
	AND (DownloadDate IS NULL OR DownloadDate > DATEADD(ss,-20,getdate()))
	AND (DownloadOperatorID IS NULL OR DownloadOperatorID = @OperatorID)
	AND (DownloadIPAddress IS NULL OR DownloadIPAddress = @IPAddress)
	AND ClientCertInactID IS NULL
	AND ExpireDate > getdate()
	AND @IPAddress <> ''

SELECT @@ROWCOUNT AS Confirmed
GO

CREATE PROCEDURE dbo.CertDownloadedOP (@OperatorID INT, @ClientCertID INT, @IPAddress VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @Operator VARCHAR(32)
SELECT @Operator = Operator FROM Operators WHERE OperatorID = @OperatorID
UPDATE ClientCerts SET DownloadOperatorID = @OperatorID, DownloadIPAddress = @IPAddress, DownloadDate = getdate(), LastModifyUser = @Operator, LastModifyDate = getdate()
	WHERE ClientCertID = @ClientCertID
	AND (DownloadDate IS NULL OR DownloadDate > DATEADD(ss,-20,getdate()))
	AND DownloadOperatorID IS NOT NULL
	AND (DownloadIPAddress IS NULL OR DownloadIPAddress = @IPAddress)
	AND ClientCertInactID IS NULL
	AND ExpireDate > getdate()
	AND @IPAddress <> ''

SELECT @@ROWCOUNT AS Confirmed
GO

CREATE PROCEDURE dbo.CertStatus (@OperatorID INT) AS
SET NOCOUNT ON
SELECT COUNT(*) AS ActiveCerts
FROM ClientCerts
	WHERE OperatorID = @OperatorID
	AND ClientCertInactID IS NULL
	AND (ExpireDate IS NULL OR ExpireDate > getdate())
	AND (DownloadDate IS NOT NULL OR DownloadOperatorID IS NOT NULL)
GO

CREATE PROCEDURE dbo.CertToggle (@Operator VARCHAR(32), @required INT) AS
UPDATE Operators SET CertClientRequired = @required WHERE Operator = @Operator
GO

CREATE PROCEDURE dbo.ChangeMailUserPassword (@Login VARCHAR(64), @Domain VARCHAR(64), @Password VARCHAR(200), @ExternalSystemID INT) AS
UPDATE sa SET Password = @Password
FROM SubAccounts sa JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	WHERE esat.ExternalSystemID = @ExternalSystemID
	AND ((sa.Login = @Login AND d.MailDomain = @Domain) OR (sa.Email = @Login + '@' + @Domain))
GO

CREATE PROCEDURE dbo.ChargeRateAdd (@CustomerID INT, @AccountID INT, @ChargeTypeID INT, @TaxGroupID INT, @TaxExemptions INT, @StartDate DATETIME, @Amount NUMERIC(18,4), @Description VARCHAR(64), @Login VARCHAR(64)) AS
SET NOCOUNT ON

INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,DistFlag,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,CreateDate,CreateUser,LastModifyDate,LastModifyUser)
VALUES(@CustomerID,@Description,
CASE WHEN DATEADD(mm,1,@StartDate) > getdate() THEN getdate() ELSE @StartDate END,
CASE WHEN DATEADD(mm,1,@StartDate) > getdate() THEN getdate() ELSE DATEADD(dd,-1,DATEADD(mm,1,@StartDate)) END,@AccountID,1,1,@Amount,1,@TaxGroupID,@TaxExemptions,@ChargeTypeID,getdate(),'Emerald Auto Bill',getdate(),'Emerald Auto Bill')

SELECT SCOPE_IDENTITY() AS ChargeID
GO

CREATE PROCEDURE dbo.ChargeSetupAdd (@AccountID INT, @StartDate DATETIME, @Operator VARCHAR(64)) AS
SET NOCOUNT ON

INSERT INTO Charges (CustomerID, StartDate, EndDate, AccountID, AccountTypeID, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, CreateDate, CreateUser, LastModifyDate, LastModifyUser, AllowInterim)
SELECT DISTINCT sa.CustomerID, @StartDate, @StartDate, sa.AccountID, sa.AccountTypeID, ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate(), @Operator, getdate(), @Operator, 0
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ChargeTypes ct ON (at1.ChargeTypeID = ct.ChargeTypeID OR at1.SecChargeTypeID = ct.ChargeTypeID)
	WHERE sa.AccountID = @AccountID
GO

CREATE PROCEDURE dbo.CheckDatabase AS
DBCC CheckDB WITH TABLERESULTS
GO

CREATE PROCEDURE dbo.CheckGroupGlobal (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT (SELECT COUNT(*) FROM AccountTypes at1 JOIN ServiceGroupItems sgi ON (at1.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM AccountTypes WHERE GroupID = @GroupID AND SortOrder >= 0) AS AccountTypes,
	(SELECT COUNT(*) FROM BillingCycles bc JOIN ServiceGroupItems sgi ON (bc.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM BillingCycles WHERE GroupID = @GroupID AND SortOrder >= 0) AS BillingCycles,
	(SELECT COUNT(*) FROM Regions r JOIN ServiceGroupItems sgi ON (r.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM Regions WHERE GroupID = @GroupID AND SortOrder >= 0) AS Regions,
	(SELECT COUNT(*) FROM Domains d JOIN ServiceGroupItems sgi ON (d.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM Domains WHERE GroupID = @GroupID AND SortOrder >= 0) AS Domains,
	(SELECT COUNT(*) FROM PayPeriods pp JOIN ServiceGroupItems sgi ON (pp.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM PayPeriods WHERE GroupID = @GroupID AND SortOrder >= 0) AS PayPeriods,
	(SELECT COUNT(*) FROM ChargeTypes ct JOIN ServiceGroupItems sgi ON (ct.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM ChargeTypes WHERE GroupID = @GroupID AND SortOrder >= 0) AS ChargeTypes,
	(SELECT COUNT(*) FROM SalesPersons sp JOIN ServiceGroupItems sgi ON (sp.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM SalesPersons WHERE GroupID = @GroupID AND SortOrder >= 0) AS SalesPersons,
	(SELECT COUNT(*) FROM SendMethods sm JOIN ServiceGroupItems sgi ON (sm.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM SendMethods WHERE GroupID = @GroupID AND SortOrder >= 0) AS SendMethods,
	(SELECT COUNT(*) FROM IncidentTypes it JOIN ServiceGroupItems sgi ON (it.ServiceGroupID=sgi.ServiceGroupID) WHERE sgi.GroupID=@GroupID AND SortOrder >= 0) + (SELECT COUNT(*) FROM IncidentTypes WHERE GroupID = @GroupID AND SortOrder >= 0) AS IncidentTypes
FROM Configs 
	WHERE ConfigID = 0
GO

CREATE PROCEDURE dbo.CheckInvoices (@fixinvoices INT) AS
SET NOCOUNT ON

CREATE TABLE #chkitmp (InvoiceID INT, CustomerID INT, Name VARCHAR(80), CreateDate DATETIME, InvoiceAmount NUMERIC(18,4), CalcInvoiceAmount NUMERIC(18,4), Condition INT)
INSERT INTO #chkitmp (InvoiceID,CustomerID,Name,CreateDate,InvoiceAmount,CalcInvoiceAmount,Condition)
SELECT i.InvoiceID, MIN(ma.CustomerID) AS CustomerID, MIN(a.FirstName + ' ' + a.LastName) AS Name, 
MIN(i.CreateDate) AS CreateDate, MIN(ROUND(i.Amount,2)) AS InvoiceAmount, COALESCE(SUM(ROUND(ii.Amount * ii.Quantity,2)),0) AS CalcInvoiceAmount,
CASE	WHEN SUM(CASE WHEN ii.Description LIKE '%Days' THEN ROUND(ii.Amount,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 1
	WHEN SUM(ROUND(ii.Amount,2)) = MIN(i.Amount) THEN 2
	WHEN SUM(CASE WHEN c.ChargeID IS NOT NULL THEN ROUND(c.Amount * c.Quantity,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 3
ELSE NULL END AS Condition
FROM Invoices i LEFT JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN Charges c ON (ii.ChargeID = c.ChargeID)
	WHERE i.VoidDate IS NULL
	AND i.Processed = 1
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(COALESCE(ROUND(ii.Amount * ii.Quantity,2),0))

IF (@fixinvoices IN (1,2,3))
BEGIN
UPDATE InvoiceItems SET Quantity = 1
	WHERE Description LIKE '%Days'
	AND InvoiceID IN (SELECT InvoiceID FROM #chkitmp WHERE Condition = 1)

UPDATE InvoiceItems SET Quantity = 1
	WHERE InvoiceID IN (SELECT InvoiceID FROM #chkitmp WHERE Condition = 2)

UPDATE InvoiceItems SET Amount = c.Amount, Quantity = c.Quantity
FROM InvoiceItems ii JOIN Charges c ON (ii.ChargeID = c.ChargeID)
	JOIN #chkitmp t ON (ii.InvoiceID = t.InvoiceID)
	WHERE t.Condition = 3

IF (@fixinvoices = 2)
	BEGIN
	UPDATE InvoiceItems SET Amount = ii.Amount + ((t.InvoiceAmount - t.CalcInvoiceAmount) / ii.Quantity)
	FROM InvoiceItems ii JOIN #chkitmp t ON (ii.InvoiceID = t.InvoiceID)
		WHERE ii.ItemID = (SELECT MIN(ItemID) FROM InvoiceItems ii2 WHERE ii2.InvoiceID = t.InvoiceID AND ii2.Quantity > 0)
		AND t.Condition IS NULL
	END

IF (@fixinvoices = 3)
	BEGIN
	INSERT INTO InvoiceItems (InvoiceID,ItemType,Description,StartDate,EndDate,Amount,Quantity,PaidAmount)
	SELECT t.InvoiceID, CASE WHEN t.InvoiceAmount - t.CalcInvoiceAmount < 0 THEN 1 ELSE 2 END,'Conversion Adjustment',t.CreateDate,t.CreateDate,t.InvoiceAmount - t.CalcInvoiceAmount,1,0
	FROM #chkitmp t
		WHERE t.InvoiceAmount <> t.CalcInvoiceAmount
	END

END ELSE BEGIN
SELECT t.InvoiceID, t.CustomerID, t.Name, t.CreateDate, t.InvoiceAmount, t.CalcInvoiceAmount, 
CASE WHEN t.Condition = 1 THEN 'E2.5 Prorate Qty Error' 
WHEN t.Condition = 2 THEN 'General Qty Error' 
WHEN t.Condition = 3 THEN 'Use Charge Amount'
ELSE 'N/A' END AS Comments
FROM #chkitmp t
END
GO

CREATE PROCEDURE dbo.CheckAutoPay (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @reason VARCHAR(255)

IF (@reason IS NULL)
BEGIN
SELECT @reason = CASE
WHEN SUM(Amount) > 0 THEN 'Total of ' + CAST(SUM(Amount) AS VARCHAR) + ' in ' + CAST(COUNT(*) AS VARCHAR) + ' outstanding or failed transactions'
END
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND (NOT(TransTypeID IN (16,32,64) AND TransStateID = 3 AND AutoBill = 0)) 
	AND ((TransTypeID IN (16,32,64)	AND TransStateID IN (0,1,2,3,7,10)) OR (TransTypeID = 16 AND TransStateID = 4))
END

IF (@reason IS NULL)
BEGIN
SELECT @reason = CASE 
WHEN ma.Active < 0 THEN 'MBR Deleted' 
WHEN ma.Active = 0 THEN 'MBR Inactive' 
WHEN ma.PaymentTypeID NOT IN (8,16) THEN 'MBR Pay Method not CC/EFT' 
WHEN bc.AutoBill NOT IN (0,1) THEN 'Billing cycle on nonrecurring billing mode'
WHEN ma.TransHoldDate > getdate() THEN 'MBR on CC/EFT hold until ' + CAST(ma.TransHoldDate AS VARCHAR)
WHEN ma.PaymentTypeID = 8 AND cc.ExpirationDate < getdate() THEN 'Expired CC on File'
WHEN ma.PendingBalance <= 0 THEN 'MBR pending balance is zero or credit'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NOT NULL AND e.ExportType = 10 AND cc.Token IS NULL THEN 'CC on file missing token'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NOT NULL AND e.ExportType = 10 AND bp.Active = 0 THEN 'Batch processor for CC on file is inactive'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NOT NULL AND e.ExportType = 10 AND bp.Active = 2 THEN 'Batch processor for CC on file is disabled'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NOT NULL AND e.ExportType = 10 AND bp.GroupID IS NOT NULL AND bp.GroupID <> ma.GroupID THEN 'Batch processor for CC on file assigned to different billing group'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NOT NULL AND e.ExportType = 10 AND bp.OrganizationID IS NOT NULL AND bp.OrganizationID <> g.OrganizationID THEN 'Batch processor for CC on file assigned to different organization'
WHEN ma.PaymentTypeID = 8 AND bp.BatchProcessorID IS NULL AND cc.CardNumber IS NULL THEN 'CC on file missing card number'
WHEN ma.PaymentTypeID = 8 AND cc.CustomerID IS NULL THEN 'MBR no CC on file'
WHEN ma.PaymentTypeID = 16 AND bt.CustomerID IS NULL THEN 'MBR no EFT on file'
WHEN ma.PaymentTypeID = 16 AND ABANumber IS NULL THEN 'EFT no routing number on file'
WHEN ma.PaymentTypeID = 16 AND AccountNumber IS NULL THEN 'EFT no account number on file'
END
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	LEFT JOIN BatchProcessors bp ON (cc.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE ma.CustomerID = @CustomerID
END

IF (@reason IS NULL)
BEGIN
SELECT @reason = 'No applicable active CC batch processor'
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 8
	AND cc.BatchProcessorID IS NULL
	AND cc.CardNumber IS NOT NULL
	AND cc.Token IS NULL
	AND DATEADD(mm,1,cc.ExpirationDate) > getdate()
	AND NOT EXISTS
		(
		SELECT *
		FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (1,5)
			AND (bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID)
			AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
			AND (ct.CardTypeID IS NULL OR bp.CardTypes & ct.CardTypeID = ct.CardTypeID OR bp.CardTypes & 256 = 256)
			AND (cc.CardLength IS NULL OR cc.CardLength IN (ct.Length1,ct.Length2))
		)
END

IF (@reason IS NULL)
BEGIN
SELECT @reason = 'No applicable active EFT batch processor'
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 16
	AND NOT EXISTS
		(
		SELECT *
		FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (4,6)
			AND (bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID)
			AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
		)
END

IF (@reason IS NULL)
BEGIN
SELECT @reason = CASE
WHEN COUNT(*) = 0 THEN 'No suitable unpaid invoices'
WHEN MIN(bc.TBillDays) IS NOT NULL AND DATEADD(dd,-MIN(bc.TBillDays),getdate()) < MIN(CASE WHEN ii.ItemType = 3 AND ii.Amount > 0 THEN ii.StartDate END) THEN 'Unpaid invoice EFT/CC auto trans days not yet reached'
END
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE i.CustomerID = @CustomerID
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Processed = 1
	AND i.InvoiceTypeID NOT IN (91,92,99)
	AND i.PaidAmount < i.ChargeAmount
END

IF (@reason IS NULL)
BEGIN
SELECT @reason = CASE
WHEN COUNT(*) > 0 THEN CAST(COUNT(*) AS VARCHAR) + ' recently voided transactions'
END
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID = 9
	AND LastModifyDate > DATEADD(hh,-3,getdate())
END

SELECT COALESCE(@reason,'None Found') AS Description
GO

CREATE PROCEDURE dbo.ConfigsGet AS
SET NOCOUNT ON
SELECT c.ConfigID, cd.GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c JOIN ConfigGroupData cd ON (c.ConfigID = cd.ConfigID)
UNION ALL
SELECT c.ConfigID, cd.OperatorGroupID AS GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c JOIN ConfigOperatorGroupData cd ON (c.ConfigID = cd.ConfigID)
UNION ALL
SELECT 325 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c CROSS JOIN Organizations o JOIN Currencies cu ON (o.CurrencyID = cu.CurrencyID)
	WHERE c.ConfigID = 323
UNION ALL
SELECT 326 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c CROSS JOIN Organizations o JOIN Currencies cu ON (o.CurrencyID = cu.CurrencyID)
	WHERE c.ConfigID = 324
UNION ALL
SELECT 328 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c CROSS JOIN Organizations o JOIN Currencies cu ON (o.CurrencyID = cu.CurrencyID)
	WHERE c.ConfigID = 327
UNION ALL
SELECT 394 AS ConfigID, NULL AS GroupID, 0 AS DataTypeID, MIN(OperatorID) AS Value, NULL AS Data FROM Operators WHERE OperatorGroupID = 1
UNION ALL
SELECT 512 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, OrganizationID AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 550 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, DomainID AS Value, NULL AS Data FROM Groups WHERE DomainID IS NOT NULL
UNION ALL
SELECT 551 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, GroupName AS Data FROM Groups WHERE GroupName IS NOT NULL
UNION ALL
SELECT 552 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, Description AS Data FROM Groups WHERE Description IS NOT NULL
UNION ALL
SELECT 553 AS ConfigID, NULL AS GroupID, 1 AS DataTypeID, NULL AS Value, 'invoice.rpt' AS Data
UNION ALL
SELECT 553 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, InvoiceReport AS Data FROM Groups WHERE InvoiceReport IS NOT NULL
UNION ALL
SELECT 554 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, InvoiceTextReport AS Data FROM Groups WHERE InvoiceTextReport IS NOT NULL
UNION ALL
SELECT 555 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, InvoiceHTMLReport AS Data FROM Groups WHERE InvoiceHTMLReport IS NOT NULL
UNION ALL
SELECT 556 AS ConfigID, NULL AS GroupID, 1 AS DataTypeID, NULL AS Value, 'statement.rpt' AS Data
UNION ALL
SELECT 556 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, StatementReport AS Data FROM Groups WHERE StatementReport IS NOT NULL
UNION ALL
SELECT 557 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, StatementTextReport AS Data FROM Groups WHERE StatementTextReport IS NOT NULL
UNION ALL
SELECT 558 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, StatementHTMLReport AS Data FROM Groups WHERE StatementHTMLReport IS NOT NULL
UNION ALL
SELECT 559 AS ConfigID, NULL AS GroupID, 1 AS DataTypeID, NULL AS Value, 'receipt.rpt' AS Data
UNION ALL
SELECT 559 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, ReceiptReport AS Data FROM Groups WHERE ReceiptReport IS NOT NULL
UNION ALL
SELECT 560 AS ConfigID, NULL, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups WHERE ReportLogoURL IS NOT NULL AND GroupID = 1
UNION ALL
SELECT 560 AS ConfigID, OrganizationID, 1 AS DataTypeID, NULL AS Value, MIN(ReportLogoURL) AS Data FROM Groups WHERE ReportLogoURL IS NOT NULL GROUP BY OrganizationID
UNION ALL
SELECT 567 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillName AS Data FROM Groups WHERE BillName IS NOT NULL
UNION ALL
SELECT 568 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillAddress1 AS Data FROM Groups WHERE BillAddress1 IS NOT NULL
UNION ALL
SELECT 569 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillAddress2 AS Data FROM Groups WHERE BillAddress2 IS NOT NULL
UNION ALL
SELECT 570 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillCity AS Data FROM Groups WHERE BillCity IS NOT NULL
UNION ALL
SELECT 571 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillState AS Data FROM Groups WHERE BillState IS NOT NULL
UNION ALL
SELECT 573 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, BillZip AS Data FROM Groups WHERE BillZip IS NOT NULL
UNION ALL
SELECT 574 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, BillCountryID AS Value, NULL AS Data FROM Groups WHERE BillCountryID IS NOT NULL
UNION ALL
SELECT 575 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, EmailAccounts AS Data FROM Groups WHERE EmailAccounts IS NOT NULL
UNION ALL
SELECT 576 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, EmailSubject AS Data FROM Groups WHERE EmailSubject IS NOT NULL
UNION ALL
SELECT 579 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalIncidentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 580 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups WHERE ReportLogoURL IS NOT NULL
UNION ALL
SELECT 565 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalSendMethods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 590 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalAccountTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 591 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalBillingCycles AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 592 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalRegions AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 593 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalPayPeriods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 595 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalChargeTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 597 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalDomains AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 598 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, GlobalSalesPersons AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 583 AS ConfigID, CASE WHEN GroupID = 1 THEN NULL ELSE GroupID END, 0 AS DataTypeID, PaymentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 577 AS ConfigID, g.GroupID, 0 AS DataTypeID, 1 AS Value, NULL AS Data
FROM Groups g JOIN BatchProcessors bp ON ((bp.GroupID IS NULL OR bp.GroupID = g.GroupID) AND (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE e.ExportType IN (1,5,10)
	AND bp.Active = 1
GROUP BY g.GroupID
UNION ALL
SELECT 577 AS ConfigID, NULL AS GroupID, 0 AS DataTypeID, 0 AS Value, NULL AS Data
UNION ALL
SELECT 578 AS ConfigID, g.GroupID, 0 AS DataTypeID, 1 AS Value, NULL AS Data
FROM Groups g JOIN BatchProcessors bp ON ((bp.GroupID IS NULL OR bp.GroupID = g.GroupID) AND (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE e.ExportType IN (4,6)
	AND bp.Active = 1
GROUP BY g.GroupID
UNION ALL
SELECT 578 AS ConfigID, NULL AS GroupID, 0 AS DataTypeID, 0 AS Value, NULL AS Data
UNION ALL
SELECT 581 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType IN (5,10) THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g JOIN BatchProcessors bp ON ((bp.GroupID IS NULL OR bp.GroupID = g.GroupID) AND (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE bp.Active = 1
GROUP BY g.GroupID
UNION ALL
SELECT 582 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType = 6 THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g JOIN BatchProcessors bp ON ((bp.GroupID IS NULL OR bp.GroupID = g.GroupID) AND (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE bp.Active = 1
GROUP BY g.GroupID
UNION ALL
SELECT 584 AS ConfigID, 1 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'feet' AS Data
UNION ALL
SELECT 584 AS ConfigID, 2 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'meters' AS Data
UNION ALL
SELECT 585 AS ConfigID, 1 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'miles' AS Data
UNION ALL
SELECT 585 AS ConfigID, 2 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'kilometers' AS Data
UNION ALL
SELECT 586 AS ConfigID, 1 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'inches' AS Data
UNION ALL
SELECT 586 AS ConfigID, 2 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'centimeters' AS Data
UNION ALL
SELECT 587 AS ConfigID, 1 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'pounds' AS Data
UNION ALL
SELECT 587 AS ConfigID, 2 AS MeasureUnitID, 1 AS DataTypeID, NULL AS Value, 'kilograms' AS Data
UNION ALL
SELECT 561 AS ConfigID, bpg.GroupID, 0 AS DataTypeID, bp.BatchProcessorID AS Value, NULL AS Data
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN
		(
		SELECT g.GroupID, COALESCE(
		MIN(CASE WHEN e.ExportType = 10 AND bp.GroupID = g.GroupID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.GroupID = g.GroupID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN e.ExportType = 10 AND bp.OrganizationID = g.OrganizationID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.OrganizationID = g.OrganizationID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN e.ExportType = 10 AND bp.OrganizationID IS NULL THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.OrganizationID IS NULL THEN bp.BatchProcessorID END)
		) AS BatchProcessorID
		FROM BatchProcessors bp JOIN Groups g ON ((bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID) AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID))
		JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (1,5,10)
		GROUP BY g.GroupID
		) bpg ON (bp.BatchProcessorID = bpg.BatchProcessorID)
	WHERE e.ExportType = 10
UNION ALL
SELECT 562 AS ConfigID, bpg.GroupID, 1 AS DataTypeID, NULL AS Value, e.FileTokenLocal AS Data
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN
		(
		SELECT g.GroupID, COALESCE(
		MIN(CASE WHEN e.ExportType = 10 AND bp.GroupID = g.GroupID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.GroupID = g.GroupID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN e.ExportType = 10 AND bp.OrganizationID = g.OrganizationID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.OrganizationID = g.OrganizationID THEN bp.BatchProcessorID END),
		MIN(CASE WHEN e.ExportType = 10 AND bp.OrganizationID IS NULL THEN bp.BatchProcessorID END),
		MIN(CASE WHEN bp.OrganizationID IS NULL THEN bp.BatchProcessorID END)
		) AS BatchProcessorID
		FROM BatchProcessors bp JOIN Groups g ON ((bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID) AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID))
			JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (1,5,10)
		GROUP BY g.GroupID
		) bpg ON (bp.BatchProcessorID = bpg.BatchProcessorID)
	WHERE e.ExportType = 10
	AND e.FileTokenLocal IS NOT NULL
UNION ALL
SELECT 562 AS ConfigID, NULL AS GroupID, 1 AS DataTypeID, NULL AS Value, 'token_cc_default_f.ews' AS Data
UNION ALL
SELECT 730 AS ConfigID, NULL AS GroupID, 0 AS DataTypeID, CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS Value, NULL AS Data FROM InvAttributes WHERE ShowSearchResult = 1 AND InvLevelTypeID = 2
UNION ALL
SELECT 731 AS ConfigID, BatchProcessorID AS GroupID, 0 AS DataTypeID, CertID AS Value, NULL AS Data
FROM BatchProcessors
	WHERE CertID IS NOT NULL
UNION ALL
SELECT 732 AS ConfigID, bp.BatchProcessorID AS GroupID, 1 AS DataTypeID, NULL AS Value, c.PublicKey AS Data
FROM BatchProcessors bp JOIN Certs c ON (bp.CertID = c.CertID)
	WHERE bp.CertID IS NOT NULL
UNION ALL
SELECT 736 AS ConfigID, NULL AS GroupID, 0 AS DataTypeID, RefCount AS Value, NULL AS Data
FROM IEALocks WITH (NOLOCK)
	WHERE IEALockID = 10
UNION ALL
SELECT ConfigID, NULL AS GroupID, CASE WHEN DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, NumValue, Data FROM Configs
GO

CREATE PROCEDURE dbo.CreditCardAuthOnlyVoid WITH RECOMPILE AS
SET NOCOUNT ON
UPDATE ExternalTrans SET TransStateID = 9
	WHERE TransTypeID = 16 
	AND TransStateID = 4 
	AND ProcDate < DATEADD(dd,-10,getdate())

SELECT CAST(@@ROWCOUNT AS VARCHAR(20)) + ' transactions voided' AS Description
GO

CREATE PROCEDURE dbo.CreditCardExport (@BatchProcessorID INT, @CustomerID INT, @partid INT = NULL, @parts INT = NULL) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@CustomerID IS NULL)
BEGIN
SELECT a.Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.AccountExpire) % 100 AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(a.PhoneHome,a.PhoneWork,a.PhoneMobile) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
s.State, s.Abbreviation AS State2, COALESCE(cc.BillToCity,a.City) AS City, c.Country, c.Abbr2 AS Country2, c.Abbr3 AS Country3,
COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID IN (128,256) THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.Token, et.ProcTransID, 
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd, et.ExternalTransID, et.TransTypeID, 
et.ExternalTransID AS TransID, et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
DATEDIFF(mm,ma.CreateDate,getdate()) AS createmonths,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN et.AutoBill = 1 THEN 'RECURRING' ELSE 'ECOMMERCE' END AS WorldPayDIT,
CASE WHEN et.AutoBill = 1 THEN 'true' ELSE 'false' END AS AutoBillTF,
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, a.Company,
cu.Code AS CurrencyCode, ma.ExternalRef AS PayInfo, et.AutoBill, CASE WHEN et.AutoBill = 1 THEN 1 END AS CVAutoBill, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies cu ON (o.CurrencyID = cu.CurrencyID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	LEFT JOIN Countries c ON (c.CountryID = COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID,840))
	LEFT JOIN States s ON (s.StateID = COALESCE(et.AuthStateID,cc.BillToStateID,a.StateID))
	WHERE et.BatchProcessorID = @BatchProcessorID
	AND et.TransStateID = 0
	AND (@partid IS NULL OR et.CustomerID % @parts = @partid - 1)
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND ((e.ExportType IN (1,5) AND et.AccountNumber IS NOT NULL AND et.AccountExpire IS NOT NULL AND et.Token IS NULL)
		OR (e.ExportType IN (10) AND et.Token IS NOT NULL))
	AND p.FinalAmount IS NULL
OPTION (FORCE ORDER)

END ELSE BEGIN

SELECT a.Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.AccountExpire) % 100 AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(a.PhoneHome,a.PhoneWork,a.PhoneMobile) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
s.State, s.Abbreviation AS State2, COALESCE(cc.BillToCity,a.City) AS City, c.Country, c.Abbr2 AS Country2, c.Abbr3 AS Country3,
COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID IN (128,256) THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.Token, et.ProcTransID, 
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd, et.ExternalTransID, et.TransTypeID, 
et.ExternalTransID AS TransID, et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
DATEDIFF(mm,ma.CreateDate,getdate()) AS createmonths,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN et.AutoBill = 1 THEN 'RECURRING' ELSE 'ECOMMERCE' END AS WorldPayDIT,
CASE WHEN et.AutoBill = 1 THEN 'true' ELSE 'false' END AS AutoBillTF,
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, a.Company,
cu.Code AS CurrencyCode, ma.ExternalRef AS PayInfo, et.AutoBill, CASE WHEN et.AutoBill = 1 THEN 1 END AS CVAutoBill, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies cu ON (o.CurrencyID = cu.CurrencyID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	LEFT JOIN Countries c ON (c.CountryID = COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID,840))
	LEFT JOIN States s ON (s.StateID = COALESCE(et.AuthStateID,cc.BillToStateID,a.StateID))
	WHERE et.CustomerID = @CustomerID
	AND et.TransStateID = 0
	AND et.BatchProcessorID = @BatchProcessorID
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND ((e.ExportType IN (1,5) AND et.AccountNumber IS NOT NULL AND et.AccountExpire IS NOT NULL AND et.Token IS NULL)
		OR (e.ExportType IN (10) AND et.Token IS NOT NULL))
	AND p.FinalAmount IS NULL
OPTION (FORCE ORDER)
END
GO

CREATE PROCEDURE dbo.CreditCardImport (@TransID INT, @TransStateID INT, @ApproveCode VARCHAR(12), @Response VARCHAR(256), @etransid VARCHAR(64)) AS
UPDATE ExternalTrans
	SET TransStateID = @TransStateID, AuthSecurityCode = NULL,
	ApproveCode = @ApproveCode,
	Response = @Response,
	ProcTransID = @etransid,
	ProcDate = getdate()
	WHERE ExternalTransID = @TransID
	AND TransStateID IN (0,2,10)

SET NOCOUNT ON
UPDATE cc SET SecurityCode = NULL 
FROM CreditCards cc JOIN ExternalTrans et ON (cc.CustomerID = et.CustomerID)
	WHERE et.ExternalTransID = @TransID
	AND cc.SecurityCode IS NOT NULL 
GO

CREATE PROCEDURE dbo.CreditCardUpExport (@BatchProcessorID INT, @months INT) AS
SET NOCOUNT ON
DECLARE @today DATETIME, @allowed INT
SELECT @months = CASE WHEN @months IS NULL OR @months < 1 THEN 1 ELSE @months END, @today = DATEADD(ms,-DATEPART(ms,getdate()),DATEADD(ss,-(DATEPART(hh,getdate())*3600 + DATEPART(mi,getdate())*60 + DATEPART(ss,getdate())),getdate()))
CREATE TABLE #ccue (CustomerID INT)

SELECT @allowed = CASE WHEN NumValue = 1 THEN 1 ELSE 0 END FROM Configs WHERE ConfigID = 672
IF (@allowed = 1)
	BEGIN
	SELECT @allowed = CASE WHEN Active IN (1,0) THEN 1 ELSE 0 END FROM BatchProcessors WHERE BatchProcessorID = @BatchProcessorID
	END

IF (@allowed = 1)
BEGIN
DELETE FROM ccu
FROM CreditCardUpdates ccu JOIN MasterAccounts ma ON (ccu.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
        JOIN BatchProcessors bp ON (ccu.BatchProcessorID = bp.BatchProcessorID)
        JOIN Exports e ON (bp.ExportID = e.ExportID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	WHERE ma.Active < 1 
	OR (ma.CancelDate < getdate() AND cr.Returning = 0)
	OR cc.BatchProcessorID IS NULL
	OR cc.Token IS NULL
	OR cc.BatchProcessorID <> ccu.BatchProcessorID
	OR ma.PaymentTypeID <> 8
	OR e.ExportType <> 10
	OR e.ExportID NOT IN (64)
	OR bc.AutoBill NOT IN (0,1)

INSERT INTO CreditCardUpdates (CustomerID,BatchProcessorID,LastReplaced,Token,ExpirationDate)
SELECT ma.CustomerID, @BatchProcessorID, cc.LastModifyDate, cc.Token, cc.ExpirationDate
FROM MasterAccounts ma JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
        JOIN BatchProcessors bp ON (cc.BatchProcessorID = bp.BatchProcessorID)
        JOIN Exports e ON (bp.ExportID = e.ExportID)
        WHERE ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
        AND ma.PaymentTypeID = 8
	AND bc.AutoBill IN (0,1)
	AND cc.Token IS NOT NULL
        AND e.ExportType = 10
	AND e.ExportID IN (64)
	AND cc.BatchProcessorID = @BatchProcessorID
	AND NOT EXISTS
		(
		SELECT * 
		FROM CreditCardUpdates ccu
			WHERE ma.CustomerID = ccu.CustomerID
			AND ccu.BatchProcessorID = @BatchProcessorID
		)

UPDATE ccu SET LastReplaced = cc.LastModifyDate, Token = cc.Token, ExpirationDate = cc.ExpirationDate, LastExported = NULL, LastUpdated = NULL, LastFailed = NULL, Message = NULL
FROM CreditCardUpdates ccu JOIN CreditCards cc ON (ccu.CustomerID = cc.CustomerID AND ccu.BatchProcessorID = cc.BatchProcessorID)
	WHERE cc.BatchProcessorID = @BatchProcessorID
	AND cc.Token IS NOT NULL
	AND (ccu.Token IS NULL OR ccu.Token <> cc.Token OR (ccu.Token = cc.Token AND ccu.ExpirationDate <> cc.ExpirationDate))
	AND (ccu.LastExported IS NULL OR ccu.LastExported < DATEADD(dd,-7,getdate()) OR ccu.LastExported < ccu.LastUpdated OR ccu.LastExported < ccu.LastFailed)

UPDATE CreditCardUpdates SET LastExported = NULL
	WHERE BatchProcessorID = @BatchProcessorID
	AND LastExported = @today

INSERT INTO #ccue (CustomerID)
SELECT TOP 20000 ccu.CustomerID
FROM CreditCardUpdates ccu JOIN MasterAccounts ma ON (ccu.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN CreditCards cc ON (ccu.CustomerID = cc.CustomerID AND ccu.BatchProcessorID = cc.BatchProcessorID)
	WHERE ccu.BatchProcessorID = @BatchProcessorID
	AND (ccu.LastExported IS NULL OR ccu.LastExported < DATEADD(dd,-7,@today))
	AND ccu.LastFailed IS NULL
	AND ccu.Token = cc.Token
	AND (	cc.ExpirationDate < getdate()
		OR ((ccu.LastReplaced IS NULL OR ccu.LastReplaced < DATEADD(mm,-@months,@today)) AND (ccu.LastUpdated IS NULL OR ccu.LastUpdated < DATEADD(mm,-@months,@today)))
		OR EXISTS
			(
			SELECT * 
			FROM ExternalTrans et
				WHERE et.CustomerID = cc.CustomerID
				AND et.Token = cc.Token
				AND et.ProcDate > DATEADD(dd,-5,getdate())
				AND et.TransStateID = 3
			))

UPDATE ccu SET LastExported = @today, LastFailed = NULL, Message = NULL
FROM CreditCardUpdates ccu JOIN #ccue ccue ON (ccu.CustomerID = ccue.CustomerID)
	WHERE ccu.BatchProcessorID = @BatchProcessorID
	AND (ccu.LastExported IS NULL OR ccu.LastExported < DATEADD(dd,-7,@today))

SELECT bp.Login, bp.Password, ma.GroupID, CAST(g.GroupName AS VARCHAR(25)) AS GroupName, bp.BatchProcessorID, bp.Merchant, cc.CustomerID, cc.Token,
CAST(DATEPART(yy,@today) AS VARCHAR) + CAST(DATEPART(mm,@today) AS VARCHAR) + CAST(DATEPART(dd,@today) AS VARCHAR) AS BatchID,
RIGHT('0' + CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR),2) AS ExpMM,
RIGHT('0' + CAST(DATEPART(yy,cc.ExpirationDate) AS VARCHAR),2) AS ExpYY
FROM CreditCardUpdates ccu JOIN CreditCards cc ON (ccu.CustomerID = cc.CustomerID AND ccu.BatchProcessorID = cc.BatchProcessorID)
	JOIN MasterAccounts ma ON (cc.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON (ccu.BatchProcessorID = bp.BatchProcessorID)
	WHERE ccu.BatchProcessorID = @BatchProcessorID
	AND ccu.LastExported = @today
	AND ccu.Token = cc.Token
END
GO

CREATE PROCEDURE dbo.CreditCardUpImport (@BatchProcessorID INT, @CustomerID INT, @Token VARCHAR(128), @ExpirationDate DATETIME, @Message VARCHAR(255)) AS
SET NOCOUNT ON
SELECT @Token = CASE WHEN DATALENGTH(@Token) > 5 THEN @Token END, @ExpirationDate = CASE WHEN @ExpirationDate > DATEADD(mm,-1,getdate()) THEN @ExpirationDate END, @Message = CASE WHEN @Message <> ' ' THEN @Message END

UPDATE cc SET Token = COALESCE(@Token,cc.Token), ExpirationDate = COALESCE(@ExpirationDate,cc.ExpirationDate), LastModifyDate = getdate(), LastModifyUser = 'CC Updater'
FROM CreditCards cc JOIN CreditCardUpdates ccu ON (cc.CustomerID = ccu.CustomerID AND cc.BatchProcessorID = ccu.BatchProcessorID)
	WHERE cc.CustomerID = @CustomerID
	AND cc.BatchProcessorID = @BatchProcessorID
	AND cc.Token = ccu.Token
	AND (cc.ExpirationDate = ccu.ExpirationDate OR cc.ExpirationDate < @ExpirationDate)
	AND (cc.Token <> @Token OR cc.ExpirationDate <> @ExpirationDate)

IF (@@ROWCOUNT = 1)
BEGIN
UPDATE CreditCardUpdates SET Token = COALESCE(@Token,Token), ExpirationDate = COALESCE(@ExpirationDate,ExpirationDate), LastReplaced = getdate(), LastUpdated = getdate(), LastFailed = NULL, Message = @Message
	WHERE CustomerID = @CustomerID
	AND BatchProcessorID = @BatchProcessorID
END ELSE BEGIN
UPDATE CreditCardUpdates SET LastUpdated = getdate(), LastFailed = NULL, Message = @Message
	WHERE CustomerID = @CustomerID
	AND BatchProcessorID = @BatchProcessorID
END
GO

CREATE PROCEDURE dbo.CreditCardUpFailed (@BatchProcessorID INT, @CustomerID INT, @Message VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE CreditCardUpdates SET LastFailed = getdate(), Message = @Message 
	WHERE CustomerID = @CustomerID 
	AND BatchProcessorID = @BatchProcessorID
GO

CREATE PROCEDURE dbo.CreditCardUpInfo (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN ccu.LastExported IS NOT NULL AND LastUpdated IS NULL AND LastFailed IS NULL THEN DATEDIFF(dd,ccu.LastExported,getdate()) END AS PendingDays,
ccu.LastFailed AS FailDate, CASE WHEN ccu.LastFailed IS NOT NULL THEN ccu.Message END AS FailMessage, 
ccu.LastUpdated AS UpdateDate, CASE WHEN ccu.LastUpdated IS NOT NULL THEN ccu.Message END AS UpdateMessage
FROM CreditCards cc JOIN CreditCardUpdates ccu ON (cc.CustomerID = ccu.CustomerID AND cc.BatchProcessorID = ccu.BatchProcessorID)
	WHERE cc.CustomerID = @CustomerID
	AND cc.Token = ccu.Token
	AND cc.ExpirationDate = ccu.ExpirationDate
GO

CREATE PROCEDURE dbo.CustCCPending (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS Pending
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID = 0
GO

CREATE PROCEDURE dbo.CustCCDefaultAmount (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @pending NUMERIC(18,4), @pendingcnt INT

IF (@InvoiceID IS NOT NULL)
BEGIN
SELECT ChargeAmount - PaidAmount AS Amount, NULL AS PendingTransAmount, 0 AS PendingTransCount
FROM Invoices
	WHERE InvoiceID = @InvoiceID
	AND CustomerID = @CustomerID
END ELSE BEGIN
SELECT @pending = COALESCE(SUM(Amount),0), @pendingcnt = COUNT(*)
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID IN (0,1,2,10)
	AND TransTypeID IN (16,32,64)

SELECT CASE WHEN PendingBalance - @pending > 0 THEN PendingBalance - @pending END AS Amount, @pending AS PendingTransAmount, @pendingcnt AS PendingTransCount
FROM MasterAccounts
	WHERE CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.CustAllowPurchase (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS AllowPurchase
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
	AND sa.Active = 1
	AND at1.AllowRADIUS = 1
	AND at1.LogonAsParent = 0
	AND tc.CustomerAccess = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (((bc.AutoBill = 2 OR sa.Recurring = 0) AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) 
		OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) 
		OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL)
		OR (tc.RateTimeLeft IS NOT NULL AND sa.RateTimeLeft IS NOT NULL) 
		OR (tc.RateDataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
GO

CREATE PROCEDURE dbo.CustPurchaseSAList (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT sa.AccountID, a.FirstName, a.LastName, sa.Login, at1.AccountType, at1.StringID AS at1StringID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
	AND sa.Active = 1
	AND at1.AllowRADIUS = 1
	AND at1.LogonAsParent = 0
	AND tc.CustomerAccess = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (((bc.AutoBill = 2 OR sa.Recurring = 0) AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) 
		OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) 
		OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL)
		OR (tc.RateTimeLeft IS NOT NULL AND sa.RateTimeLeft IS NOT NULL) 
		OR (tc.RateDataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
ORDER BY at1.AccountType, sa.Login
GO

CREATE PROCEDURE CustPurchaseOptions (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT tc.TimeChargeID, ct.ChargeTypeID, tc.TimeCharge, tc.StringID AS tcStringID, tc.Description, 
CASE WHEN (bc.AutoBill IN (0,1) AND sa.Recurring = 1) OR sa.ExpireDate IS NULL THEN NULL ELSE tc.Months END AS Months,
CASE WHEN (bc.AutoBill IN (0,1) AND sa.Recurring = 1) OR sa.ExpireDate IS NULL THEN NULL ELSE tc.Days END AS Days,
CASE WHEN (bc.AutoBill IN (0,1) AND sa.Recurring = 1) OR sa.ExpireDate IS NULL THEN NULL ELSE tc.Minutes END AS Minutes,
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE tc.TimeLeft / 60 END AS MinsLeft,
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE tc.DataLeft / 1000000.0 END AS MBLeft,
CASE WHEN sa.RateTimeLeft IS NULL THEN NULL ELSE tc.RateTimeLeft / 60 END AS RateMinsLeft,
CASE WHEN sa.RateDataLeft IS NULL THEN NULL ELSE tc.RateDataLeft/ 1000000.0 END AS RateMBLeft,
tc.CustomerMaxQty, ct.Amount
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND sa.Active = 1
	AND at1.AllowRADIUS = 1
	AND at1.LogonAsParent = 0
	AND tc.CustomerAccess = 1
	AND ct.Amount > 0
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (((bc.AutoBill = 2 OR sa.Recurring = 0) AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) 
		OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) 
		OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL)
		OR (tc.RateTimeLeft IS NOT NULL AND sa.RateTimeLeft IS NOT NULL) 
		OR (tc.RateDataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
ORDER BY tc.SortOrder, ct.Amount DESC, tc.TimeCharge
GO

CREATE PROCEDURE dbo.CustIncidentList (@CustomerID INT, @AccountID INT, @IncidentID INT, @manager TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT IncidentID, CASE WHEN is1.StatOpen = 1 THEN i.PriorityID ELSE -1000 END AS Pri, i.CreateDate,
COALESCE(co.Operator,csa.Login,csaa.FirstName + ' ' + csaa.LastName) AS Operator,is1.StatOpen, i.IncidentStateID, i.IncidentTypeID,
CAST(COALESCE(i.Summary,i.Description) AS VARCHAR(1024)) AS Summary, COALESCE(i.Description,i.Summary) AS Detail,
COALESCE(is1.Style,CASE WHEN is1.StatOpen = 1 AND is1.StatEscalate = 1 THEN 'escalated' WHEN is1.StatOpen = 1 AND is1.StatWait = 0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen = 1 THEN 'open' WHEN is1.StatArchive = 1 THEN 'archived' WHEN is1.StatBlock = 1 THEN 'blocking' WHEN is1.StatOpen = 0 THEN 'closed' ELSE 'normal' END) AS Class,
is1.IncidentState, it.IncidentType, it.StringID AS itStringID, p.Priority, p.StringID AS pStringID, i.LastModifyDate, i.LastModifyUser
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
	LEFT JOIN SubAccounts csa ON (i.CreateAccountID = csa.AccountID)
	LEFT JOIN Addresses csaa ON (csa.ContactAddressID = csaa.AddressID)
	WHERE i.CustomerID = @CustomerID
	AND i.CustomerAccess = 1
	AND (@IncidentID IS NULL OR i.IncidentID = @IncidentID)
	AND (@manager = 1 OR i.AccountID = @AccountID)
	AND i.CreateDate > DATEADD(yy,-1,getdate())
ORDER BY 2 DESC, 3 DESC
GO

CREATE PROCEDURE dbo.CustActionList (@CustomerID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT a.ActionID, COALESCE(o.Operator,sa.Login,c.FirstName + ' ' + c.LastName) AS Operator, a.CreateDate, a.Description, is1.IncidentState
FROM Actions a JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN IncidentStates is1 ON (a.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators o ON (a.CreateOperatorID = o.OperatorID)
	LEFT JOIN SubAccounts sa ON (a.CreateAccountID = sa.AccountID)
	LEFT JOIN Addresses c ON (sa.ContactAddressID = c.AddressID)
	WHERE a.IncidentID = @IncidentID
	AND i.CustomerID = @CustomerID
	AND a.CustomerAccess = 1
	AND a.Description IS NOT NULL
ORDER BY a.ActionID
GO

CREATE PROCEDURE dbo.CustAppointments (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT i.IncidentID, it.Description AS IncidentType, it.StringID, sb.SchedBlock, sb.StringID AS sbStringID, i.SchedDate
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN SchedBlocks sb ON (i.SchedBlockID = sb.SchedBlockID)
	WHERE i.CustomerID = @CustomerID
	AND (i.AccountID IS NULL OR i.AccountID = @AccountID)
	AND is1.StatOpen = 1
	AND i.SchedDate > DATEADD(dd,-1,getdate())
ORDER BY i.SchedDate ASC
GO

CREATE PROCEDURE dbo.CustSAInfo (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.PaymentTypeID, ma.CancelDate, bc.AutoBill, CASE WHEN ma.PaymentTypeID IN (8,16) AND bc.AutoBill IN (0,1) THEN 1 ELSE 0 END AS AutoPay,
sa.PasswordChange,
CASE WHEN bc.AutoBill IN (0,1) AND sa.Recurring = 1 THEN 1 ELSE 0 END AS Recurring,
CASE WHEN sa.RemoteAccess = 2 THEN 1 ELSE 0 END AS SendBill,
CASE WHEN sa.RemoteAccess > 0 THEN 1 ELSE 0 END AS RemoteAccess,
CASE WHEN ma.PendingBalance <= 0 THEN 1 ELSE 0 END AS HaveCredit,
CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE sa.AccountID = @AccountID
GO

CREATE PROCEDURE dbo.CustSADefault (@CustomerID INT, @AccountTypeID INT, @ParentAccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @Extension INT
SELECT @Extension = NumValue FROM Configs WHERE ConfigID = 5

SELECT CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(psa.Extension,at1.Extension,bc.Extension,cgd5.NumValue,@Extension,0) END AS Extension,
COALESCE(psa.PayPeriodID,at1.PayPeriodID,ma.PayPeriodID) AS PayPeriodID, at1.RemoteAccess, at1.LoginLimit, 
COALESCE(psa.DomainID,g.DomainID) AS DomainID, at1.AccountTypeID, psa.AccountID AS ParentAccountID, psa.SalesPersonID,
CASE WHEN at1.TimeLeft IS NULL THEN NULL WHEN bc.AutoBill IN (0,1) THEN at1.TimeLeft ELSE 0 END AS TimeLeft,
CASE WHEN at1.DataLeft IS NULL THEN NULL WHEN bc.AutoBill IN (0,1) THEN at1.DataLeft ELSE 0 END AS DataLeft,
CASE WHEN at1.RateTimeLeft IS NULL THEN NULL WHEN bc.AutoBill IN (0,1) THEN at1.RateTimeLeft ELSE 0 END AS RateTimeLeft,
CASE WHEN at1.RateDataLeft IS NULL THEN NULL WHEN bc.AutoBill IN (0,1) THEN at1.RateDataLeft ELSE 0 END AS RateDataLeft
FROM MasterAccounts ma LEFT JOIN ConfigGroupData cgd5 ON (cgd5.ConfigID = 5 AND ma.GroupID = cgd5.GroupID)
	LEFT JOIN SubAccounts psa ON (psa.AccountID = @ParentAccountID AND psa.Active = 1)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (at1.AccountTypeID = @AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND (@ParentAccountID IS NULL OR ma.CustomerID = psa.CustomerID)
GO

CREATE PROCEDURE dbo.CustConfirmChangeAT (@CustomerID INT, @AccountID INT, @AccountTypeID INT, @EffectiveDate DATETIME) AS
SET NOCOUNT ON
DECLARE @retcode INT

SELECT @retcode = CASE 
WHEN DATEADD(dd,1,sa.BilledThru) > @EffectiveDate THEN 1
WHEN scat.AccountTypeID IS NULL THEN 2
WHEN scat.CustomerAccess = 0 THEN 3
WHEN bc.AutoBill NOT IN (0,1) OR sa.Recurring = 0 THEN 4
WHEN scat.CustomerMax IS NOT NULL AND scat.CustomerMax <= (SELECT COUNT(*) FROM SubAccounts msa 
		WHERE msa.CustomerID = @CustomerID
		AND msa.ServiceCategoryID = scat.ServiceCategoryID 
		AND msa.AccountTypeID = scat.AccountTypeID
		AND msa.Active = 1
		AND (msa.CancelDate IS NULL OR msa.CancelDate > getdate())) THEN 5 ELSE 100 END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ServiceCatAccountTypes scat ON (sa.ServiceCategoryID = scat.ServiceCategoryID AND scat.AccountTypeID = @AccountTypeID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND sa.Active = 1

SELECT CASE WHEN @retcode IS NULL THEN 6 WHEN @retcode < 100 THEN @retcode ELSE 0 END AS ReturnCode
GO

CREATE PROCEDURE dbo.CustomerAgingDetail (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT i.InvoiceID, DATEDIFF(dd,i.CreateDate,getdate()) AS Days, i.ChargeAmount - i.PaidAmount AS Amount, i.CreateDate
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	WHERE ma.CustomerID = @CustomerID
	AND i.ChargeAmount > 0
	AND i.ChargeAmount > i.PaidAmount
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
GO

CREATE PROCEDURE dbo.CustomerAllowAcctMgmt (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS AllowAdd
FROM SubAccounts sa JOIN ServiceCatAccountTypes scat ON (sa.ServiceCategoryID = scat.ServiceCategoryID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.ParentAccountID IS NULL
	AND scat.CustomerAccess = 1
	AND scat.AllowCustAdd = 1
	AND (scat.CustomerMax IS NULL OR scat.CustomerMax > (SELECT COUNT(*) FROM SubAccounts msa 
		WHERE msa.CustomerID = @CustomerID
		AND msa.ServiceCategoryID = scat.ServiceCategoryID 
		AND msa.AccountTypeID = scat.AccountTypeID
		AND msa.Active = 1
		AND (msa.CancelDate IS NULL OR msa.CancelDate > getdate())))
GO

CREATE PROCEDURE dbo.CustAcctList (@CustomerID INT, @LoginAccountID INT, @AccountID INT, @showall TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @childaccess INT, @RemoteAccess INT

SELECT @childaccess = COALESCE(cgd.NumValue,c.NumValue,0), @RemoteAccess = sa.RemoteAccess
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 708)
	LEFT JOIN Configs c ON (c.ConfigID = 708)
	WHERE ma.CustomerID = @CustomerID
	AND sa.AccountID = @LoginAccountID

SELECT sa.AccountID, sa.ParentAccountID, scat.CustomerAccess, CASE WHEN bc.AutoBill IN (0,1) AND sa.Recurring = 1 THEN 1 ELSE 0 END AS Recurring,
CASE WHEN sa.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 3 ELSE 1 END AS Status,
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND bc.AutoBill IN (0,1) AND sa.Recurring = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) THEN scat.AllowCustUpgrade ELSE 0 END AS AllowCustUpgrade, 
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND bc.AutoBill IN (0,1) AND sa.Recurring = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) THEN scat.AllowCustDowngrade ELSE 0 END AS AllowCustDowngrade, 
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND bc.AutoBill IN (0,1) AND sa.Recurring = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) AND (scat.AllowCustUpgrade = 1 OR scat.AllowCustDowngrade = 1) THEN 1 ELSE 0 END AS AllowCustChangeAT, 
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND bc.AutoBill IN (0,1) AND sa.Recurring = 1 AND sa.CancelDate IS NULL AND scat.AllowCustCancel = 1 THEN 1 ELSE 0 END AS AllowCustCancel,
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND bc.AutoBill IN (0,1) AND sa.Recurring = 1 AND cr.Returning = 1 AND sa.CancelDate < getdate() AND scat.AllowCustAdd = 1 THEN 1 ELSE 0 END AS AllowCustReopen,
CASE WHEN (@RemoteAccess = 2 OR @LoginAccountID = sa.AccountID OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND scat.CustomerAccess = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) THEN scat.AllowCustChangeLogin ELSE 0 END AS AllowCustChangeLogin, 
CASE WHEN (@RemoteAccess = 2 OR @LoginAccountID = sa.AccountID OR (@childaccess = 1 AND sa.ParentAccountID = @LoginAccountID)) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) THEN scat.AllowCustChangePass ELSE 0 END AS AllowCustChangePass,
CASE WHEN (@RemoteAccess = 2 OR (@childaccess = 1 AND sa.AccountID = @LoginAccountID)) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) AND (SELECT COUNT(*) FROM ServiceCatLinks ascl JOIN ServiceCatAccountTypes ascat ON (ascl.ServiceCategoryID = ascat.ServiceCategoryID)
	WHERE sa.ServiceCategoryID = ascl.ParentServiceCategoryID
	AND ascat.CustomerAccess = 1
	AND ascat.AllowCustAdd = 1) > 0 THEN 1 ELSE 0 END AS AllowAdd,
CASE WHEN ba.CountryID = 840 THEN 1 ELSE 0 END AS AllowFCCBL,
CASE WHEN ba.CountryID = 840 AND blat.RegFCCBLProviderID IS NOT NULL THEN 1 ELSE 0 END AS AllowFCCBLShow,
a.FirstName, a.LastName, sa.Login AS Account, COALESCE(at1.Description,at1.AccountType) AS AccountType, at1.StringID AS at1StringID,
sa.BilledThru, sa.ExpireDate, CASE WHEN bc.AutoBill = 2 OR sa.Recurring = 0 THEN 0 ELSE sa.Extension + ma.TempExtension END AS Extension, 
(sa.TimeLeft + COALESCE(sau.TimeLeft,0)) / 60 AS MinsLeft,
(sa.DataLeft + COALESCE(sau.DataLeft,0)) / 1000000.0 AS MBLeft,
(sa.RateTimeLeft + COALESCE(sau.RateTimeLeft,0)) / 60 AS RateMinsLeft,
(sa.RateDataLeft + COALESCE(sau.RateDataLeft,0)) / 1000000.0 AS RateMBLeft,
ac.EffectiveDate AS ChangeDate, COALESCE(acat.Description,acat.AccountType) AS ChangeAccountType, acat.StringID AS acatStringID, sa.ServiceCategoryID, sa.AccountTypeID, sa.Cost, 
CASE WHEN bc.AutoBill IN (0,1) AND sa.Recurring = 1 THEN pp.PayPeriod ELSE NULL END AS PayPeriod, 
CASE WHEN bc.AutoBill IN (0,1) AND sa.Recurring = 1 THEN pp.StringID ELSE NULL END AS ppStringID,
sa.CancelDate, cr.CancelReason, cr.StringID AS crStringID,
CASE WHEN at1.UseServerPassword = 1 AND (sa.Login IS NULL OR (DATALENGTH(sa.Login) = 12 AND sa.Login NOT LIKE '%[^0-9a-f]%')) THEN 1 ELSE 0 END AS ShowMAC,
CASE WHEN sa.BilledThru < getdate() THEN getdate() ELSE DATEADD(dd,1,sa.BilledThru) END AS FirstChange

FROM SubAccounts sa JOIN ServiceCatAccountTypes scat ON (sa.ServiceCategoryID = scat.ServiceCategoryID AND sa.AccountTypeID = scat.AccountTypeID)
	JOIN ServiceCategories sc ON (sa.ServiceCategoryID = sc.ServiceCategoryID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN CancelReasons cr ON (sa.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses ba ON (ma.BillingAddressID = ba.AddressID)
	LEFT JOIN (SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID) sau ON (sa.AccountID = sau.AccountID)
	LEFT JOIN
		(
		SELECT ac2.AccountID, MAX(ac2.AccountChangeID) AS AccountChangeID
		FROM
			(
			SELECT AccountID, MIN(EffectiveDate) AS EffectiveDate
			FROM AccountChanges
				WHERE CustomerID = @CustomerID
				AND (@AccountID IS NULL OR AccountID = @AccountID)
				AND AccountID IS NOT NULL
				AND InactiveDate IS NULL
				AND AccountTypeID IS NOT NULL
				AND EffectiveDate > getdate()
			GROUP BY AccountID
			) ac JOIN AccountChanges ac2 ON (ac2.CustomerID = @CustomerID AND ac.AccountID = ac2.AccountID AND ac.EffectiveDate = ac2.EffectiveDate AND ac2.AccountTypeID IS NOT NULL AND ac2.InactiveDate IS NULL)
		GROUP BY ac2.AccountID
		) c ON (sa.AccountID = c.AccountID)
	LEFT JOIN AccountChanges ac ON (c.AccountChangeID = ac.AccountChangeID)
	LEFT JOIN AccountTypes acat ON (ac.AccountTypeID = acat.AccountTypeID)
	LEFT JOIN RegFCCBLAccountTypes blat ON (g.OrganizationID = blat.OrganizationID AND sa.AccountTypeID = blat.AccountTypeID)
	WHERE sa.CustomerID = @CustomerID
	AND (@showall = 1 OR scat.CustomerAccess = 1)
	AND sa.Active = 1
	AND (@AccountID IS NOT NULL OR sa.ParentAccountID IS NULL OR @showall = 1)
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
	AND (@RemoteAccess = 2 OR sa.AccountID = @LoginAccountID OR sa.ParentAccountID = @LoginAccountID)
ORDER BY sa.AccountID
GO

CREATE PROCEDURE dbo.CustAcctMarketTags (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MarketTag, mt.StringID, 
DATEADD(mm,COALESCE(COALESCE(sat.InvoicedDaysMax,mt.InvoicedDaysMax) - sat.InvoicedDays,mt.ServiceMonthsMax * 30 - sa.InvoicedDays) / 30,DATEADD(dd,COALESCE(COALESCE(sat.InvoicedDaysMax,mt.InvoicedDaysMax) - sat.InvoicedDays,mt.ServiceMonthsMax * 30 - sa.InvoicedDays) % 30,sa.BilledThru))
AS ActiveThru
FROM SubAccounts sa JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID)
	JOIN MarketTags mt ON (sat.MarketTagID = mt.MarketTagID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND sat.Active = 1
	AND mt.CustomerHidden = 0

UNION ALL

SELECT mt.MarketTag, mt.StringID, NULL AS ActiveThru
FROM MasterAccountTags mat JOIN MarketTags mt ON (mat.MarketTagID = mt.MarketTagID)
	WHERE mat.CustomerID = @CustomerID
	AND mat.Active = 1
	AND mt.CustomerHidden = 0

ORDER BY 1
GO

CREATE PROCEDURE dbo.CustomerBillingInfo (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ratecost NUMERIC(18,4), @AllowPayCredit TINYINT, @AllowPayAuto TINYINT, @PayPending INT

SELECT @ratecost = COALESCE(SUM(TotalCost),0), @PayPending = 0
FROM RateHistory 
	WHERE ChargeID IS NULL
	AND RateCostTypeID = 1
	AND CustomerID = @CustomerID

SELECT @AllowPayCredit = COALESCE(cgd695.NumValue,c695.NumValue,0), @AllowPayAuto = COALESCE(cgd696.NumValue,c696.NumValue,0)
FROM MasterAccounts ma JOIN Configs c695 ON (c695.ConfigID = 695)
	JOIN Configs c696 ON (c696.ConfigID = 696)
	LEFT JOIN ConfigGroupData cgd695 ON (ma.GroupID = cgd695.GroupID AND cgd695.ConfigID = 696)
	LEFT JOIN ConfigGroupData cgd696 ON (ma.GroupID = cgd696.GroupID AND cgd696.ConfigID = 696)
	WHERE ma.CustomerID = @CustomerID

IF (@AllowPayCredit = 0)
BEGIN
SELECT @PayPending = COUNT(*)
FROM ExternalTrans 
	WHERE CustomerID = @CustomerID 
	AND TransStateID IN (0,1,2) 
	AND TransTypeID IN (32,64)
END

SELECT ma.PendingBalance AS CurrentBalance, CASE WHEN ma.PendingBalance < 0 THEN 1 ELSE 0 END AS CurrentCredit,
ma.PendingBalance + @ratecost AS RealtimeBalance, CASE WHEN ma.PendingBalance + @ratecost < 0 THEN 1 ELSE 0 END AS RealtimeCredit,
CASE WHEN ma.PendingBalance - ma.CreditLimit + @ratecost < -ma.CreditLimit THEN ma.CreditLimit ELSE -(ma.PendingBalance - ma.CreditLimit + @ratecost) END AS AvailableBalance,
CASE WHEN ma.PendingBalance - ma.CreditLimit + @ratecost <= 0 THEN 1 ELSE 0 END AS AvailableCredit, ma.CreditLimit,
CASE WHEN @PayPending > 0 THEN 0 WHEN (bc.AutoBill = 2 OR ma.PaymentTypeID = 1 OR (ma.PaymentTypeID IN (8,16) AND @AllowPayAuto = 1)) AND ma.PendingBalance + @ratecost > 0 OR @AllowPayCredit = 1 THEN 1 ELSE 0 END AS ShowPayment,
CASE WHEN ma.CreditLimit > 0 THEN 1 ELSE 0 END AS ShowCredit,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE COALESCE(pt.CustomerDescription,pt.PaymentType) END AS PaymentType, 
CASE WHEN bc.AutoBill = 2 THEN NULL WHEN pt.CustomerDescription IS NOT NULL THEN pt.CustomerStringID ELSE pt.StringID END AS ptStringID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.CustomerBuyTime (@CustomerID INT, @AccountID INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @TimeLeft INT, @DataLeft BIGINT, @RateDataLeft BIGINT, @RateTimeLeft INT
SELECT @TimeLeft = COALESCE(SUM(COALESCE(TimeLeft,0)),0),
@DataLeft = COALESCE(SUM(COALESCE(DataLeft,0)),0),
@RateDataLeft = COALESCE(SUM(COALESCE(RateDataLeft,0)),0),
@RateTimeLeft = COALESCE(SUM(COALESCE(RateTimeLeft,0)),0)
FROM SubAccountUsages 
	WHERE AccountID = @AccountID 
	AND ExpireDate > DATEADD(dd,-1,getdate())

SELECT 2 AS LeftType, 
sa.TimeLeft + @TimeLeft AS TimeLeft, (sa.TimeLeft + @TimeLeft) / 60 AS HoursLeft, (sa.DataLeft + @DataLeft) / 1000000.0 AS DataLeft,
sa.RateTimeLeft + @RateTimeLeft AS RateTimeLeft, (sa.RateTimeLeft + @RateTimeLeft) / 60 AS RateHoursLeft, (sa.RateDataLeft + @RateDataLeft) / 1000000.0 AS RateDataLeft,
sa.ExpireDate, at1.AccountType, at1.StringID AS AccountTypeStringID, ct.Amount, tc.TimeCharge, tc.StringID AS tcStringID, tc.Description, sa.Login, sa.AccountID, ct.ChargeTypeID, tc.CustomerMaxQty
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND tc.CustomerAccess = 1
	AND (((bc.AutoBill = 2 OR sa.Recurring = 0) AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) 
		OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) 
		OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL)
		OR (tc.RateTimeLeft IS NOT NULL AND sa.RateTimeLeft IS NOT NULL) 
		OR (tc.RateDataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)
ORDER BY ct.Amount
GO

CREATE PROCEDURE dbo.CustomerCCFailInfo (@ExternalTransID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT ExternalTransID, ProcDate, Amount, Response
FROM ExternalTrans
	WHERE ExternalTransID = @ExternalTransID
	AND TransStateID = 3	
GO

CREATE PROCEDURE dbo.CustomerCCVoid (@CustomerID INT) AS
SET NOCOUNT ON
UPDATE ExternalTrans SET TransStateID = 9 
	WHERE TransStateID = 3 
	AND ExternalTransID IN (SELECT MAX(et.ExternalTransID) FROM ExternalTrans et WHERE et.CustomerID = @CustomerID AND et.ReqDate > DATEADD(dd,-30,getdate()))
GO

CREATE PROCEDURE dbo.CustomerHistory (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @sd DATETIME

SELECT @sd = DATEADD(mm,-COALESCE(cgd.NumValue,c.NumValue,4),getdate())
FROM MasterAccounts ma JOIN Configs c ON (c.ConfigID = 693)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 693)
	WHERE ma.CustomerID = @CustomerID

SELECT 0 AS SortOrder, i.CreateDate, i.InvoiceID AS HistoryID, CASE WHEN i.VoidDate IS NOT NULL THEN 0 ELSE 1 END AS HistoryType, CASE WHEN i.Amount < 0 THEN i.Amount END AS Credit, CASE WHEN i.Amount >= 0 THEN i.Amount END AS Debit,  it.InvoiceType AS Description, it.StringID, NULL AS Info, NULL AS NumInfo, CASE WHEN i.VoidDate IS NOT NULL THEN 'chvoid' WHEN i.Amount < 0 THEN 'chcredit' WHEN i.Amount > 0 THEN 'chdebit' END AS Class
FROM Invoices i JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	WHERE i.CustomerID = @CustomerID
	And i.CreateDate > @sd
	AND i.Processed = 1
UNION ALL
SELECT 0 AS SortOrder, s.StatementDate AS CreateDate, s.StatementID AS HistoryID, 7 AS HistoryType, NULL AS Credit, NULL AS Debit, NULL AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo, NULL AS Class
FROM Statements s
	WHERE s.CustomerID = @CustomerID
	AND s.StatementDate > @sd
UNION ALL
SELECT 0 AS SortOrder, c.LastModifyDate, c.ChargeID AS HistoryID, 3 AS HistoryType, CASE WHEN c.Amount < 0 THEN c.Amount END AS Credit, CASE WHEN c.Amount >= 0 THEN c.Amount END AS Debit, COALESCE(c.Description,ct.ChargeType) AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo, CASE WHEN c.Amount < 0 THEN 'chcredit' WHEN c.Amount > 0 THEN 'chdebit' END AS Class
FROM Charges c LEFT JOIN ChargeTypes ct ON (c.ChargeTypeID = ct.ChargeTypeID)
	WHERE c.CustomerID = @CustomerID
	AND c.ItemID IS NULL
	AND c.LastModifyDate > @sd
UNION ALL
SELECT 0 AS SortOrder, nl.LogDate, nl.NoticeLogID, 8 AS HistoryType, NULL AS Credit, NULL AS Debit, n.Notice AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo, CASE WHEN nl.ErrorMessage IS NOT NULL THEN 'cherror' END AS Class
FROM NoticeLogs nl LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
	WHERE nl.CustomerID = @CustomerID
	AND nl.LogDate > @sd
UNION ALL
SELECT 0 AS SortOrder, p.CreateDate, p.PaymentID AS HistoryID, 4 AS HistoryType, CASE WHEN et.TransTypeID = 256 THEN NULL WHEN p.Amount >= 0 THEN p.Amount END AS Credit, CASE WHEN et.TransTypeID = 256 THEN p.Amount - p.FinalAmount WHEN p.Amount < 0 THEN p.Amount END AS Debit,
pt.PaymentType, pt.StringID, CASE WHEN p.PaymentTypeID = 4 THEN 'Check #' + p.CheckNumber ELSE et.Response END AS Info, NULL AS NumInfo, 'chcredit' AS Class
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID)
	WHERE p.CustomerID = @CustomerID
	AND (p.FinalAmount IS NULL OR p.FinalAmount > 0)
	AND p.CreateDate > @sd
UNION ALL
SELECT 0 AS SortOrder, ReqDate as CreateDate, et.ExternalTransID AS HistoryID, 5 AS HistoryType, Amount AS Credit, NULL AS Debit, CASE WHEN ts.TransStateID = 3 THEN Response ELSE ts.TransState END AS Response, NULL AS StringID, NULL AS Info, NULL AS NumInfo, CASE WHEN et.TransStateID = 3 THEN 'cherror' WHEN et.TransStateID = 1 THEN 'chconfirm' ELSE 'chpending' END AS Class
FROM ExternalTrans et JOIN TransStates ts ON (et.TransStateID = ts.TransStateID)
	WHERE et.CustomerID = @CustomerID
	AND et.ReqDate > @sd
	AND et.TransStateID IN (0,1,2,3,7,10)
UNION ALL
SELECT 1 AS SortOrder, rh.StartDate AS CreateDate, r.RateID AS HistoryID, 6 AS HistoryType, NULL AS Credit, SUM(TotalCost) AS Debit, MIN(r.Rate) AS Description, NULL AS StringID, MIN(ri.NameShort) AS Info, CASE WHEN MIN(rr.RateRuleTypeID) = 1 THEN SUM(rh.TotalTime) ELSE SUM(rh.TotalData) END / CAST(MIN(rr.Interval) AS NUMERIC(18,4)) AS NumInfo, 'chpending' AS Class
FROM RateHistory rh JOIN Rates r ON (rh.RateID = r.RateID)
	JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	JOIN RateIntervals ri ON (rr.Interval = ri.RateIntervalID)
	WHERE rh.CustomerID = @CustomerID
	AND rh.ChargeID IS NULL
	AND rh.RateCostTypeID = 1
GROUP BY rh.StartDate, r.RateID, rh.RateRuleID

ORDER BY 1 DESC,2 DESC
GO

CREATE PROCEDURE dbo.CustomerPOSItem (@CustomerID INT, @AccountID INT, @InvoiceID INT, @TimeChargeID INT, @Quantity INT) AS
SET NOCOUNT ON

INSERT INTO InvoiceItems (InvoiceID,ItemType,Login,Description,StartDate,EndDate,AccountID,Amount,Quantity,TaxGroupID,ChargeTypeID)
SELECT i.InvoiceID, 2, sa.Login, ct.ChargeType, i.CreateDate, i.CreateDate, sa.AccountID, ct.Amount, @Quantity, ct.TaxGroupID, ct.ChargeTypeID
FROM SubAccounts sa JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	JOIN Invoices i ON (sa.CustomerID = i.CustomerID)
	WHERE sa.AccountID = @AccountID
	AND sa.CustomerID = @CustomerID
	AND tc.TimeChargeID = @TimeChargeID
	AND i.InvoiceID = @InvoiceID
	AND i.Processed = 0
	AND i.InvoiceTypeID = 92
	AND ct.Amount > 0
	AND (@Quantity > 0 AND @Quantity <= COALESCE(tc.CustomerMaxQty,10))
GO

CREATE PROCEDURE dbo.CustomerStatus (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @timeused INT, @TimeLeft INT, @DataLeft BIGINT, @RateDataLeft BIGINT, @RateTimeLeft INT, @RealtimeCost NUMERIC(18,4), @CCPending NUMERIC(18,4), @CCFail INT

SELECT @TimeLeft = COALESCE(SUM(COALESCE(TimeLeft,0)),0),
@DataLeft = COALESCE(SUM(COALESCE(DataLeft,0)),0),
@RateDataLeft = COALESCE(SUM(COALESCE(RateDataLeft,0)),0),
@RateTimeLeft = COALESCE(SUM(COALESCE(RateTimeLeft,0)),0)
FROM SubAccountUsages 
	WHERE AccountID = @AccountID 
	AND ExpireDate > DATEADD(dd,-1,getdate())

SELECT @timeused = COALESCE(SUM(DATEDIFF(ss,cs.CallDate,getdate())) / 60,0)
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	WHERE sp.AccountID = @AccountID

SELECT @RealtimeCost = SUM(TotalCost)
FROM RateHistory
	WHERE CustomerID = @CustomerID
	AND RateCostTypeID = 1
	AND ChargeID IS NULL

SELECT @CCFail = MAX(ExternalTransID)
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND ReqDate > DATEADD(dd,-30,getdate())

SELECT @CCPending = SUM(Amount)
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID IN (0,1,2)
	AND TransTypeID IN (32,64)

SELECT sa.ExpireDate AS ExpireDate, ma.PendingBalance AS Balance, 
CASE WHEN ma.PendingBalance > 0 THEN @CCFail END AS CCFail,
@CCPending AS CCPending,
CASE WHEN ma.PaymentTypeID = 8 AND cc.CardNumber IS NOT NULL AND DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 1 ELSE 0 END AS CCExpired,
CASE WHEN ma.PaymentTypeID = 8 AND cc.CardNumber IS NOT NULL AND DATEADD(mm,-1,cc.ExpirationDate) < getdate() AND DATEADD(mm,1,cc.ExpirationDate) >= getdate() THEN 1 ELSE 0 END AS CCExpiring,
ma.PendingBalance + COALESCE(@RealtimeCost,0) AS RealtimeBalance,
ma.CreditLimit, CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE sa.Extension + ma.TempExtension END AS Extension,
a.FirstName, a.LastName, sa.LoginLimit,
CASE WHEN sa.TimeLeft + @TimeLeft - @timeused < 60 THEN 1 ELSE 2 END AS LeftType, 
sa.TimeLeft + @TimeLeft - @timeused AS TimeLeft, 
(sa.DataLeft + @DataLeft) / 1000000.0 AS DataLeft, CAST(sa.TimeLeft + @TimeLeft - @timeused AS NUMERIC(18,4)) / 60.0 AS HoursLeft, 
CASE WHEN sa.RateTimeLeft + @RateTimeLeft < 60 THEN 1 ELSE 2 END AS RateLeftType, 
sa.RateTimeLeft + @RateTimeLeft AS RateTimeLeft, 
(sa.RateDataLeft + @RateDataLeft) / 1000000.0 AS RateDataLeft, CAST(sa.RateTimeLeft + @RateTimeLeft AS NUMERIC(18,4)) / 60.0 AS RateHoursLeft, 

CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate
	WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate
	ELSE COALESCE(ma.CancelDate,sa.CancelDate) END AS CancelDate,
CASE WHEN ma.Active = 0 OR sa.Active = 0 THEN 0 WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 2 WHEN (sa.TimeLeft + @TimeLeft - @timeused <= 0 OR sa.RateTimeLeft + @RateTimeLeft <= 0) THEN 3 WHEN (sa.DataLeft + @DataLeft <= 0 OR sa.RateDataLeft + @RateDataLeft <= 0) THEN 4 ELSE 1 END AS Status

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE sa.AccountID = @AccountID
	AND ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.CustomerWebLinks (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT wl.WebLink, wl.URL
FROM WebLinks wl JOIN WebLinkTypes wlt ON (wl.WebLinkTypeID = wlt.WebLinkTypeID)
	AND wlt.AllowCustomer = 1
	AND (wlt.GroupID IS NULL OR wlt.GroupID = @GroupID)
ORDER BY wl.SortOrder, wl.WebLink
GO

CREATE PROCEDURE dbo.CallerWebLinks AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT wl.WebLink, wl.URL, wlt.GroupID
FROM WebLinks wl JOIN WebLinkTypes wlt ON (wl.WebLinkTypeID = wlt.WebLinkTypeID)
	WHERE wlt.AllowCallSearch = 1
ORDER BY wl.SortOrder, wl.WebLink
GO

CREATE PROCEDURE dbo.CustomerInvoiceCheck (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) = 1 THEN 1 ELSE 0 END AS Allowed
FROM Invoices
	WHERE InvoiceID = @InvoiceID
	AND CustomerID = @CustomerID
	AND Processed = 1
	AND VoidDate IS NULL
GO

CREATE PROCEDURE dbo.CustomerStatementCheck (@CustomerID INT, @StatementID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) = 1 THEN 1 ELSE 0 END AS Allowed
FROM Statements
	WHERE StatementID = @StatementID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.CustomerPaymentCheck (@CustomerID INT, @PaymentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) = 1 THEN 1 ELSE 0 END AS Allowed
FROM Payments
	WHERE PaymentID = @PaymentID
	AND CustomerID = @CustomerID
	AND (FinalAmount IS NULL OR FinalAmount > 0)
GO

CREATE PROCEDURE dbo.DashSec (@DashID INT, @OperatorID INT) AS
SET NOCOUNT ON
SELECT DashID,DashTypeID,OrganizationID,GroupID,RegionID,MarketTagID,IncidentTypeID,IncidentStateID,RoleID,SchedBlockTypeID,Aux1,Aux2,Aux3,Aux4,Aux5
FROM Dashes
	WHERE DashID = @DashID
	AND OperatorID = @OperatorID
GO


CREATE PROCEDURE dbo.DashGet (@OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT d.DashID, d.Aux1, d.Aux2, d.Aux3, d.Aux4, d.Aux5, dt.FileDisplay, dt.FileEdit, dt.AccessLabel, dt.FeatureID
FROM Dashes d JOIN DashTypes dt ON (d.DashTypeID = dt.DashTypeID)
	WHERE d.OperatorID = @OperatorID
ORDER BY dt.SortOrder, dt.DashType
GO

CREATE PROCEDURE dbo.DashInfo (@DashID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT o.Organization, g.GroupName, r.Region, mt.MarketTag, it1.IncidentType, is1.IncidentState, ro.Role, sbt.SchedBlockType
FROM Dashes d LEFT JOIN Organizations o ON (d.OrganizationID = o.OrganizationID)
	LEFT JOIN Groups g ON (d.GroupID = g.GroupID)
	LEFT JOIN Regions r ON (d.RegionID = r.RegionID)
	LEFT JOIN MarketTags mt ON (d.MarketTagID = mt.MarketTagID)
	LEFT JOIN IncidentTypes it1 ON (d.IncidentTypeID = it1.IncidentTypeID)
	LEFT JOIN IncidentStates is1 ON (d.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Roles ro ON (d.RoleID = ro.RoleID)
	LEFT JOIN SchedBlockTypes sbt ON (d.SchedBlockTypeID = sbt.SchedBlockTypeID)
	WHERE d.DashID = @DashID
GO

CREATE PROCEDURE dbo.DashWebLinks (@DashID INT, @AllowOperator TINYINT, @AllowOperatorPing TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT wlt.WebLinkType, wl.WebLink, wl.URL, wl.Timeout
FROM WebLinks wl JOIN WebLinkTypes wlt ON (wl.WebLinkTypeID = wlt.WebLinkTypeID)
	JOIN Dashes d ON (d.DashID = @DashID)
	WHERE ((@AllowOperator = 1 AND wlt.AllowOperator = 1) OR (@AllowOperatorPing = 1 AND wlt.AllowOperatorPing = 1))
	AND (d.Aux1 IS NULL OR d.Aux1 = wl.WebLinkTypeID)
ORDER BY wlt.WebLinkType, wl.SortOrder, wl.WebLink
GO

CREATE PROCEDURE dbo.DashEvents (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @EventTypeID INT
SELECT @EventTypeID = Aux1 FROM Dashes WHERE DashID = @DashID

SELECT e.EventID, e.CreateDate, e.CloseDate, et.EventType, e.Event, e.Description, g.GroupName, r.Region, mt.MarketTag, bp.BulkProfile
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	LEFT JOIN Regions r ON (e.RegionID = r.RegionID)
	LEFT JOIN Groups g ON (e.GroupID = g.GroupID)
	LEFT JOIN MarketTags mt ON (e.MarketTagID = mt.MarketTagID)
	LEFT JOIN BulkProfiles bp ON (e.BulkProfileID = bp.BulkProfileID)
	WHERE e.Active = 1
	AND (e.CloseDate IS NULL OR e.CloseDate > getdate())
	AND (@EventTypeID IS NULL OR e.EventTypeID = @EventTypeID)
	AND (e.GroupID IS NULL OR @MBRGlobal = 1 OR e.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
ORDER BY e.CreateDate DESC
GO

CREATE PROCEDURE dbo.DashGaugeAlertSum (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @OrganizationID INT, @GroupID INT, @RegionID INT, @MarketTagID INT, @ReportID INT, @lookmax INT
SELECT @OrganizationID = OrganizationID, @GroupID = GroupID, @RegionID = @RegionID, @MarketTagID = MarketTagID FROM Dashes WHERE DashID = @DashID
SELECT @ReportID = ReportID FROM Reports WHERE FileName = 'gauge_alerts.ews'
SELECT @lookmax = MAX(LookbackMins) FROM GaugeAlerts WHERE Active = 1

SELECT ga.GaugeAlertID, MIN(g.Gauge) AS Gauge, MIN(g.StringID) AS gStringID, MIN(ga.GaugeAlert) AS GaugeAlert, MIN(ga.StringID) AS gaStringID, SUM(Cnt) AS Cnt,
(SELECT GroupName FROM Groups WHERE GroupID = @GroupID) AS GroupName,
(SELECT Region FROM Regions WHERE RegionID = @RegionID) AS Region,
(SELECT MarketTag FROM MarketTags WHERE MarketTagID = @MarketTagID) AS MarketTag,
@ReportID AS ReportID

FROM GaugeAlerts ga JOIN
	(
	SELECT ga.GaugeAlertID, 1 AS Cnt
	FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		JOIN GaugeData gd ON (sa.AccountID = gd.AccountID)
		JOIN Gauges g ON (gd.GaugeID = g.GaugeID)
		JOIN GaugeWindows gw ON (gd.GaugeWindowID = gw.GaugeWindowID)
		JOIN GaugeAlerts ga ON (g.GaugeID = ga.GaugeID AND ga.Active = 1)
		JOIN Groups gr ON (ma.GroupID = gr.GroupID)
		WHERE ma.Active = 1
		AND sa.Active = 1
		AND gd.StartDate > DATEADD(mi,-@lookmax,getdate())
		AND gd.StartDate > DATEADD(mi,-ga.LookbackMins,getdate())
		AND (gd.Data < ga.TriggerBelow OR gd.Data > ga.TriggerAbove)
		AND (@OrganizationID IS NULL OR gr.OrganizationID = @OrganizationID)
		AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
		AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
		AND (@MarketTagID IS NULL
			OR EXISTS (SELECT * FROM MasterAccountTags mat WHERE ma.CustomerID = mat.CustomerID AND mat.Active = 1 AND mat.MarketTagID = @MarketTagID)
			OR EXISTS (SELECT * FROM SubAccountTags sat WHERE sa.AccountID = sat.AccountID AND sat.Active = 1 AND sat.MarketTagID = @MarketTagID))
		AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	GROUP BY sa.AccountID, ga.GaugeAlertID
	HAVING SUM(gw.Secs) >= MIN(ga.DwellSecs)
	) gas ON (ga.GaugeAlertID = gas.GaugeAlertID)
	JOIN Gauges g ON (ga.GaugeID = g.GaugeID)
GROUP BY ga.GaugeAlertID
GO

CREATE PROCEDURE dbo.DashGaugeAlert (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @OrganizationID INT, @GroupID INT, @RegionID INT, @MarketTagID INT, @GaugeAlertID INT, @lookmax INT
SELECT @OrganizationID = OrganizationID, @GroupID = GroupID, @RegionID = @RegionID, @MarketTagID = MarketTagID, @GaugeAlertID = Aux1 FROM Dashes WHERE DashID = @DashID
SELECT @lookmax = MAX(LookbackMins) FROM GaugeAlerts WHERE Active = 1

SELECT MIN(sa.CustomerID) AS CustomerID,
sa.AccountID,
MIN(a.FirstName) AS FirstName,
MIN(a.LastName) AS LastName,
MIN(a.Company) AS Company,
MIN(r.Region) AS Region,
MIN(t.Tower) AS Tower,
MIN(sa.Login) AS Login,
MIN(at1.AccountType) AS AccountType,
MIN(at1.StringID) AS at1StringID,
MIN(g.Gauge) AS Gauge,
MIN(g.StringID) AS gStringID,
MIN(ga.GaugeAlert) AS GaugeAlert,
MIN(ga.StringID) AS gaStringID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN GaugeData gd ON (sa.AccountID = gd.AccountID)
	JOIN Gauges g ON (gd.GaugeID = g.GaugeID)
	JOIN GaugeWindows gw ON (gd.GaugeWindowID = gw.GaugeWindowID)
	JOIN GaugeAlerts ga ON (g.GaugeID = ga.GaugeID AND ga.Active = 1)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Groups gr ON (ma.GroupID = gr.GroupID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN Towers t ON (sa.TowerID = t.TowerID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND gd.StartDate > DATEADD(mi,-@lookmax,getdate())
	AND gd.StartDate > DATEADD(mi,-ga.LookbackMins,getdate())
	AND (gd.Data < ga.TriggerBelow OR gd.Data > ga.TriggerAbove)
	AND (@OrganizationID IS NULL OR gr.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@GaugeAlertID IS NULL OR ga.GaugeAlertID = @GaugeAlertID)
	AND (@MarketTagID IS NULL
		OR EXISTS (SELECT * FROM MasterAccountTags mat WHERE ma.CustomerID = mat.CustomerID AND mat.Active = 1 AND mat.MarketTagID = @MarketTagID)
		OR EXISTS (SELECT * FROM SubAccountTags sat WHERE sa.AccountID = sat.AccountID AND sat.Active = 1 AND sat.MarketTagID = @MarketTagID))
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
GROUP BY sa.AccountID, ga.GaugeAlertID
HAVING SUM(gw.Secs) >= MIN(ga.DwellSecs)
GO

CREATE PROCEDURE dbo.DashPayGraph (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @days INT, @GroupID INT, @OrganizationID INT
SELECT @days = COALESCE(Aux1,30), @GroupID = GroupID, @OrganizationID = @OrganizationID FROM Dashes WHERE DashID = @DashID

IF (@MBRGlobal = 1 AND @GroupID IS NULL AND @OrganizationID IS NULL)
BEGIN
SELECT DATEADD(ss,-(DATEPART(hh,MIN(p.CreateDate))*3600 + DATEPART(mi,MIN(p.CreateDate))*60 + DATEPART(ss,MIN(p.CreateDate))),MIN(p.CreateDate)) AS CreateDate, pt.PaymentType, COUNT(*) AS Cnt, SUM(COALESCE(p.FinalAmount,p.Amount)) AS Amount
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	WHERE p.CreateDate > DATEADD(dd,-@days,getdate())
GROUP BY DATEPART(yy,p.CreateDate),DATEPART(mm,p.CreateDate),DATEPART(dd,p.CreateDate),pt.PaymentType
ORDER BY 1
END ELSE BEGIN
SELECT DATEADD(ss,-(DATEPART(hh,MIN(p.CreateDate))*3600 + DATEPART(mi,MIN(p.CreateDate))*60 + DATEPART(ss,MIN(p.CreateDate))),MIN(p.CreateDate)) AS CreateDate, pt.PaymentType, COUNT(*) AS Cnt, SUM(COALESCE(p.FinalAmount,p.Amount)) AS Amount
FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	WHERE (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	AND p.CreateDate > DATEADD(dd,-@days,getdate())
GROUP BY DATEPART(yy,p.CreateDate),DATEPART(mm,p.CreateDate),DATEPART(dd,p.CreateDate),pt.PaymentType
ORDER BY 1
OPTION (FORCE ORDER)
END
GO

CREATE PROCEDURE dbo.DashInvoiceGraph (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @days INT, @GroupID INT, @OrganizationID INT
SELECT @days = COALESCE(Aux1,30), @GroupID = GroupID, @OrganizationID = @OrganizationID FROM Dashes WHERE DashID = @DashID

IF (@MBRGlobal = 1 AND @GroupID IS NULL AND @OrganizationID IS NULL)
BEGIN
SELECT DATEADD(ss,-(DATEPART(hh,MIN(CreateDate))*3600 + DATEPART(mi,MIN(CreateDate))*60 + DATEPART(ss,MIN(CreateDate))),MIN(CreateDate)) AS CreateDate, COUNT(*) AS Cnt, SUM(ChargeAmount) AS Amount
FROM Invoices
	WHERE CreateDate > DATEADD(dd,-@days,getdate())
	AND VoidDate IS NULL
	AND Processed = 1
GROUP BY DATEPART(yy,CreateDate),DATEPART(mm,CreateDate),DATEPART(dd,CreateDate)
ORDER BY 1
END ELSE BEGIN
SELECT DATEADD(ss,-(DATEPART(hh,MIN(i.CreateDate))*3600 + DATEPART(mi,MIN(i.CreateDate))*60 + DATEPART(ss,MIN(i.CreateDate))),MIN(i.CreateDate)) AS CreateDate, COUNT(*) AS Cnt, SUM(i.ChargeAmount) AS Amount
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
	AND i.CreateDate > DATEADD(dd,-@days,getdate())
	AND i.VoidDate IS NULL
	AND i.Processed = 1
GROUP BY DATEPART(yy,i.CreateDate),DATEPART(mm,i.CreateDate),DATEPART(dd,i.CreateDate)
ORDER BY 1
OPTION (FORCE ORDER)
END
GO

CREATE PROCEDURE dbo.DashAppts (@DashID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @days INT, @GroupID INT, @OrganizationID INT, @IncidentTypeID INT, @OperatorID INT
SELECT @days = COALESCE(Aux1,30), @OperatorID = OperatorID, @GroupID = GroupID, @OrganizationID = @OrganizationID, @IncidentTypeID = IncidentTypeID FROM Dashes WHERE DashID = @DashID

SELECT ma.CustomerID, i.IncidentID, it1.IncidentType, it1.StringID AS it1StringID, is1.IncidentState, COALESCE(i.Summary,i.Description) AS Description,
i.PriorityID, p.Priority, p.StringID AS pStringID, i.CreateDate, i.SchedDate, 
DATEPART(mm,i.SchedDate) AS SchedDateMM, DATEPART(dd,i.SchedDate) AS SchedDateDD, DATEPART(yy,i.SchedDate) AS SchedDateYY, DATEPART(dw,i.SchedDate) AS SchedDateDW,
a.FirstName, a.LastName, a.Company, a.Address1, a.Address2, a.City, COALESCE(s.Abbreviation,s.State) AS State, a.Zip, a.PhoneHome, a.PhoneWork, a.PhoneMobile, a.Email,
sa.Login, ra.Role, oc.Operator AS cOperator, 
sb.SchedBlock, sb.StringID AS sbStringID, sb.StartHour, sb.StartMinute, sbt.SchedBlockType, sbt.SchedBlockTypeID, sbt.StringID AS sbtStringID,
sit.Site,
CASE WHEN COALESCE(ra.RoleTypeID,0) NOT IN (4,8) THEN NULL WHEN sita.Lat IS NOT NULL AND sita.Long IS NOT NULL THEN sita.Lat ELSE sitas.Lat END AS SrcLat,
CASE WHEN COALESCE(ra.RoleTypeID,0) NOT IN (4,8) THEN NULL WHEN sita.Lat IS NOT NULL AND sita.Long IS NOT NULL THEN sita.Long ELSE sitas.Long END AS SrcLong,
CASE WHEN COALESCE(ra.RoleTypeID,0) NOT IN (4,8) THEN NULL WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS DstLat,
CASE WHEN COALESCE(ra.RoleTypeID,0) NOT IN (4,8) THEN NULL WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS DstLong

FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	JOIN SchedBlocks sb ON (i.SchedBlockID = sb.SchedBlockID)
	JOIN SchedBlockTypes sbt ON (sb.SchedBlockTypeID = sbt.SchedBlockTypeID)

	LEFT JOIN Operators oc ON (i.CreateOperatorID = oc.OperatorID)
	LEFT JOIN Roles ra ON (i.AssignRoleID = ra.RoleID)

	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN Addresses a ON ((ra.RoleTypeID = 4 AND sa.AccountID IS NOT NULL AND sa.ServiceAddressID = a.AddressID) 
		OR (ra.RoleTypeID = 4 AND sa.AccountID IS NULL AND ma.ServiceAddressID = a.AddressID)
		OR (ra.RoleTypeID = 8 AND ma.BillingAddressID = a.AddressID)
		OR ((ra.RoleTypeID = 2 OR ra.RoleTypeID IS NULL) AND COALESCE(sa.ContactAddressID,ma.BillingAddressID) = a.AddressID))
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN OperatorScheds os ON (i.AssignOperatorID = os.OperatorID AND i.SchedBlockID = os.SchedBlockID)
	LEFT JOIN Sites sit ON (os.SiteID = sit.SiteID)
	LEFT JOIN Addresses sita ON (sit.PhysicalAddressID = sita.AddressID)
	LEFT JOIN AddressSyncs sitas ON (sita.AddressID = sitas.AddressID)

	WHERE i.AssignOperatorID = @OperatorID
	AND i.IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1)
	AND ma.Active IN (1,0)
	AND i.SchedDate IS NOT NULL
	AND i.SchedBlockID IS NOT NULL
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@IncidentTypeID IS NULL OR i.IncidentTypeID = @IncidentTypeID)
OPTION (FORCE ORDER)
GO

CREATE PROCEDURE dbo.DashIncidents (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @OrganizationID INT, @IncidentTypeID INT, @IncidentStateID INT, @RoleID INT, @OperatorID INT, @Role VARCHAR(128), @IncidentType VARCHAR(128), @IncidentState VARCHAR(64)
CREATE TABLE #di (IncidentID INT)

SELECT @OperatorID = CASE WHEN RoleID IS NULL THEN OperatorID END, 
@GroupID = GroupID, 
@OrganizationID = OrganizationID, 
@IncidentTypeID = IncidentTypeID, 
@IncidentStateID = IncidentStateID,
@RoleID = RoleID
FROM Dashes
	WHERE DashID = @DashID

IF (@RoleID IS NOT NULL)
BEGIN
SELECT @Role = Role FROM Roles WHERE RoleID = @RoleID
END

IF (@IncidentStateID IS NOT NULL)
BEGIN
SELECT @IncidentState = IncidentState FROM IncidentStates WHERE IncidentStateID = @IncidentStateID
END

IF (@IncidentTypeID IS NOT NULL)
BEGIN
SELECT @IncidentType = IncidentType FROM IncidentTypes WHERE IncidentTypeID = @IncidentTypeID
END

IF (@OperatorID IS NOT NULL)
BEGIN
INSERT INTO #di (IncidentID)
SELECT i.IncidentID
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	WHERE i.CreateDate > DATEADD(yy,-5,getdate())
	AND is1.StatOpen = 1
	AND (@IncidentTypeID IS NULL OR i.IncidentTypeID = @IncidentTypeID)
	AND (@IncidentStateID IS NULL OR i.IncidentStateID = @IncidentStateID)
	AND (i.AssignOperatorID = @OperatorID
		OR (is1.StatEscalate=1 AND i.AssignRoleID IN (SELECT RoleID FROM OperatorRoles WHERE OperatorID = @OperatorID AND ShowEscalate = 1)) 
		OR ((i.DueDate < getdate() OR DATEADD(dd,it1.OverDays,i.CreateDate) < getdate()) AND i.AssignRoleID IN (SELECT RoleID FROM OperatorRoles WHERE OperatorID = @OperatorID AND ShowLate = 1))
	    )
END ELSE BEGIN
INSERT INTO #di (IncidentID)
SELECT IncidentID
FROM Incidents
	WHERE AssignRoleID = @RoleID
	AND IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1)
	AND (@IncidentTypeID IS NULL OR IncidentTypeID = @IncidentTypeID)
	AND (@IncidentStateID IS NULL OR IncidentStateID = @IncidentStateID)
END

SELECT i.IncidentID, i.CustomerID, g.GroupID, it1.IncidentTypeID, it1.IncidentType, it1.StringID AS it1StringID, is1.IncidentState, COALESCE(i.Summary,i.Description) AS Summary, e.Event,
COALESCE(is1.Style,CASE WHEN is1.StatOpen=1 AND is1.StatEscalate=1 THEN 'escalated' WHEN is1.StatOpen=1 AND is1.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen=1 THEN 'open' WHEN is1.StatArchive=1 THEN 'archived' WHEN is1.StatBlock=1 THEN 'blocking' WHEN is1.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Class,
p.PriorityID, p.Priority, p.StringID AS pStringID, i.CreateDate, COALESCE(i.DueDate,DATEADD(dd,it1.OverDays,i.CreateDate)) AS DueDate,
CASE WHEN sa.ContactAddressID IS NULL THEN ab.FirstName ELSE ac.FirstName END AS FirstName,
CASE WHEN sa.ContactAddressID IS NULL THEN ab.LastName ELSE ac.LastName END AS LastName,
COALESCE(ac.Company,ab.Company) AS Company, sa.Login, ra.Role, oc.Operator AS cOperator, oa.Operator AS aOperator,
@IncidentType AS fltIncidentType, @IncidentState AS fltIncidentState, @Role AS fltRole
FROM #di di JOIN Incidents i ON (di.IncidentID = i.IncidentID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN MasterAccounts ma ON (ma.CustomerID = i.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	LEFT JOIN Roles ra ON (i.AssignRoleID = ra.RoleID)
	LEFT JOIN Operators oc ON (i.CreateOperatorID = oc.OperatorID)
	LEFT JOIN Operators oa ON (i.AssignOperatorID = oa.OperatorID)
	LEFT JOIN Events e ON (i.EventID = e.EventID)
	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses ac ON (sa.ContactAddressID = ac.AddressID)
	WHERE ma.Active IN (1,0)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
OPTION (FORCE ORDER)
GO

CREATE PROCEDURE dbo.DashIncidentNewSum (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @OrganizationID INT, @IncidentTypeID INT, @IncidentStateID INT, @IncidentState VARCHAR(64)
SELECT @GroupID = GroupID, @OrganizationID = OrganizationID, @IncidentTypeID = IncidentTypeID, @IncidentStateID = IncidentStateID FROM Dashes WHERE DashID = @DashID

IF (@IncidentStateID IS NOT NULL)
BEGIN
SELECT @IncidentState = IncidentState FROM IncidentStates WHERE IncidentStateID = @IncidentStateID
END

IF (@MBRGlobal = 1 AND @GroupID IS NULL AND @OrganizationID IS NULL AND @IncidentTypeID IS NULL AND @IncidentStateID IS NULL)
BEGIN
SELECT DATEADD(ss,-((DATEPART(dd,MIN(i.CreateDate))-1)*86400 + DATEPART(hh,MIN(i.CreateDate))*3600 + DATEPART(mi,MIN(i.CreateDate))*60 + DATEPART(ss,MIN(i.CreateDate))),MIN(i.CreateDate)) AS CreateDate, MIN(it1.IncidentType) AS IncidentType, MIN(it1.StringID) AS it1StringID, COUNT(*) AS Cnt, 
SUM(CASE WHEN is1.StatOpen = 1 THEN 1 ELSE 0 END) AS OpenCnt, SUM(CASE WHEN is1.StatOpen = 0 THEN 1 ELSE 0 END) AS CloseCnt, @IncidentState AS fltIncidentState
FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CreateDate > DATEADD(yy,-3,getdate())
	AND ma.Active IN (1,0)
GROUP BY DATEPART(yy,i.CreateDate), DATEPART(mm,i.CreateDate), i.IncidentTypeID
ORDER BY 1,2
OPTION (FORCE ORDER)
END ELSE BEGIN
SELECT DATEADD(ss,-((DATEPART(dd,MIN(i.CreateDate))-1)*86400 + DATEPART(hh,MIN(i.CreateDate))*3600 + DATEPART(mi,MIN(i.CreateDate))*60 + DATEPART(ss,MIN(i.CreateDate))),MIN(i.CreateDate)) AS CreateDate, MIN(it1.IncidentType) AS IncidentType, MIN(it1.StringID) AS it1StringID, COUNT(*) AS Cnt, 
SUM(CASE WHEN is1.StatOpen = 1 THEN 1 ELSE 0 END) AS OpenCnt, SUM(CASE WHEN is1.StatOpen = 0 THEN 1 ELSE 0 END) AS CloseCnt, @IncidentState AS fltIncidentState
FROM Incidents i JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE ma.Active IN (1,0)
	AND i.CreateDate > DATEADD(yy,-3,getdate())
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@IncidentTypeID IS NULL OR i.IncidentTypeID = @IncidentTypeID)
	AND (@IncidentStateID IS NULL OR i.IncidentStateID = @IncidentStateID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
GROUP BY DATEPART(yy,i.CreateDate), DATEPART(mm,i.CreateDate), i.IncidentTypeID
ORDER BY 1,2
END
GO

CREATE PROCEDURE dbo.DashIncidentStatSum (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @OrganizationID INT, @IncidentTypeID INT, @IncidentStateID INT
SELECT @GroupID = GroupID, @OrganizationID = OrganizationID FROM Dashes WHERE DashID = @DashID

IF (@MBRGlobal = 1 AND @GroupID IS NULL AND @OrganizationID IS NULL)
BEGIN
SELECT MIN(it1.IncidentType) AS IncidentType, MIN(it1.IncidentTypeID) AS IncidentTypeID, SUM(is1.StatOpen) AS StatOpen, SUM(CASE WHEN is1.StatOpen = 0 THEN 1 ELSE 0 END) AS Closed, SUM(is1.StatWait) AS StatWait, SUM(is1.StatEscalate) AS StatEscalate, SUM(is1.StatBlock) AS StatBlock, SUM(is1.StatArchive) AS StatArchive
FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CreateDate > DATEADD(yy,-3,getdate())
	AND it1.SortOrder >= 0
	AND ma.Active IN (1,0)
GROUP BY i.IncidentTypeID
OPTION (FORCE ORDER)
END ELSE BEGIN
SELECT MIN(it1.IncidentType) AS IncidentType, MIN(it1.IncidentTypeID) AS IncidentTypeID, SUM(is1.StatOpen) AS StatOpen, SUM(CASE WHEN is1.StatOpen = 0 THEN 1 ELSE 0 END) AS Closed, SUM(is1.StatWait) AS StatWait, SUM(is1.StatEscalate) AS StatEscalate, SUM(is1.StatBlock) AS StatBlock, SUM(is1.StatArchive) AS StatArchive
FROM Incidents i JOIN MasterAccounts ma ON (ma.CustomerID = i.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE i.CreateDate > DATEADD(yy,-3,getdate())
	AND it1.SortOrder >= 0
	AND ma.Active IN (1,0)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
GROUP BY i.IncidentTypeID
END
GO

CREATE PROCEDURE dbo.DashIncidentStateSum (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @OrganizationID INT, @IncidentTypeID INT, @IncidentStateID INT
SELECT @GroupID = GroupID, @OrganizationID = OrganizationID FROM Dashes WHERE DashID = @DashID

IF (@MBRGlobal = 1 AND @GroupID IS NULL AND @OrganizationID IS NULL)
BEGIN
SELECT it1.IncidentType, is1.IncidentState, COUNT(*) AS Cnt
FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CreateDate > DATEADD(yy,-3,getdate())
	AND it1.SortOrder >= 0
	AND is1.SortOrder >= 0
	AND ma.Active IN (1,0)
GROUP BY it1.IncidentType, is1.IncidentState
OPTION (FORCE ORDER)
END ELSE BEGIN
SELECT it1.IncidentType, is1.IncidentState, COUNT(*) AS Cnt
FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE i.CreateDate > DATEADD(yy,-3,getdate())
	AND it1.SortOrder >= 0
	AND is1.SortOrder >= 0
	AND ma.Active IN (1,0)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
GROUP BY it1.IncidentType, is1.IncidentState
END
GO

CREATE PROCEDURE dbo.DashRadOnline (@DashID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ServerGroupID INT, @ServerID INT
SELECT @ServerGroupID = Aux1, @ServerID = Aux2 FROM Dashes WHERE DashID = @DashID

SELECT MIN(sg.ServerGroup) AS ServerGroup, MIN(COALESCE(snas.Server,s.Server)) AS Server, cs.NASIdentifier, COUNT(*) AS Cnt,
SUM((sp.AcctOutputOctets - pci.AcctOutputOctets) / 125000.0 / (CASE WHEN sp.AcctSessionTime <> pci.AcctSessionTime THEN sp.AcctSessionTime - pci.AcctSessionTime END)) AS DownMbit,
SUM((sp.AcctInputOctets - pci.AcctInputOctets) / 125000.0 / (CASE WHEN sp.AcctSessionTime <> pci.AcctSessionTime THEN sp.AcctSessionTime - pci.AcctSessionTime END)) AS UpMbit
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	LEFT JOIN Servers s ON (cs.ServerID = s.ServerID)
	LEFT JOIN Servers snas ON (cs.NASIdentifier = snas.IPAddress)
	LEFT JOIN ServerGroups sg ON (COALESCE(snas.ServerGroupID,s.ServerGroupID) = sg.ServerGroupID)
	LEFT JOIN
		(
		SELECT ci.CallStartID, MAX(ci.CallInterimID) AS CallInterimID
		FROM CallInterims ci JOIN ServerPorts sp2 ON (ci.CallStartID = sp2.CallStartID)
			WHERE ci.AcctSessionTime < sp2.AcctSessionTime
		GROUP BY ci.CallStartID
		) pcis ON (sp.CallStartID = pcis.CallStartID)
	LEFT JOIN CallInterims pci ON (pcis.CallInterimID = pci.CallInterimID)
	WHERE (@ServerID IS NULL OR COALESCE(snas.ServerID,s.ServerID) = @ServerID)
	AND (@ServerGroupID IS NULL OR sg.ServerGroupID = @ServerGroupID)
GROUP BY COALESCE(snas.ServerID,s.ServerID), cs.NASIdentifier
ORDER BY 1,2,3
GO

CREATE PROCEDURE dbo.DashRadLogs (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @OrganizationID INT, @GroupID INT
SELECT @OrganizationID = OrganizationID, @GroupID = GroupID FROM Dashes WHERE DashID = @DashID

SELECT arl.LogDate, arl.AccountID, a.FirstName, a.LastName, arl.Username, arl.NASIdentifier, rlm.RadLogMsg, CASE WHEN arl.RadLogMsgID <> 11 THEN arl.Data END AS Data
FROM
	(
	SELECT MAX(rl.LogDate) AS LogDate, rl.AccountID, rl.NASIdentifier, rl.RadLogMsgID, MIN(rl.Username) AS Username, MIN(rl.Data) AS Data
	FROM RadLogs rl
		WHERE rl.LogDate > DATEADD(hh,-3,getdate())
	GROUP BY rl.AccountID, rl.NASIdentifier, rl.RadLogMsgID
	) arl
	JOIN SubAccounts sa ON (arl.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN RadLogMsgs rlm ON (arl.RadLogMsgID = rlm.RadLogMsgID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
ORDER BY 1 DESC
GO

CREATE PROCEDURE dbo.DashLicenseSum (@DashID INT, @OperatorGroupID INT, @MBRGlobal TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @OrganizationID INT
SELECT @GroupID = GroupID, @OrganizationID = OrganizationID FROM Dashes WHERE DashID = @DashID

SELECT o.Organization, g.GroupName, COALESCE(c.Recurring,0) AS Recurring, COALESCE(c.NonRecurring,0) AS NonRecurring
FROM Groups g JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN
		(
		SELECT ma.GroupID, SUM(CASE WHEN bc.AutoBill IN (0,1) THEN 1 ELSE 0 END) AS Recurring, SUM(CASE WHEN bc.AutoBill = 2 THEN 1 ELSE 0 END) AS NonRecurring
		FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
			LEFT JOIN
				(
				SELECT DISTINCT sa.CustomerID
				FROM SubAccounts sa LEFT JOIN 
					(
					SELECT AccountID, SUM(TimeLeft) AS TimeLeft, SUM(DataLeft) AS DataLeft 
					FROM SubAccountUsages 
						WHERE ExpireDate > getdate() 
					GROUP BY AccountID
					) sau ON (sa.AccountID = sau.AccountID)
					WHERE sa.Active = 1 
					AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())
					AND (sa.TimeLeft IS NULL OR sa.TimeLeft + COALESCE(sau.TimeLeft,0) > 0)
					AND (sa.DataLeft IS NULL OR sa.DataLeft + COALESCE(sau.DataLeft,0) > 0)
				) sa ON (bc.AutoBill = 2 AND ma.CustomerID = sa.CustomerID)
			WHERE ma.Active = 1
			AND (bc.AutoBill IN (0,1) OR (bc.AutoBill = 2 AND sa.CustomerID IS NOT NULL))
		GROUP BY ma.GroupID
		) c ON (g.GroupID = c.GroupID)
	WHERE g.GroupID <> 1
	AND (c.Recurring > 0 OR c.NonRecurring > 0 OR g.Active = 1)
	AND (@GroupID IS NULL OR g.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@MBRGlobal = 1 OR g.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
ORDER BY o.Organization, g.SortOrder, g.GroupName
GO

CREATE PROCEDURE dbo.DistInvoiceGet (@CustomerID INT, @InvoiceID INT, @upgrade INT) AS
SET NOCOUNT ON
IF (@CustomerID IS NOT NULL)
BEGIN
SELECT CASE WHEN MIN(i.InvoiceID) = @InvoiceID THEN 2 WHEN MIN(i.InvoiceTypeID) IN (91,92) AND MIN(ma.PaymentTypeID) IN (8,16) AND @upgrade = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType,  MAX(ii.Amount * ii.Quantity) AS Amount, ROUND(MAX(ii.Amount * ii.Quantity),2) - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate, MIN(ii.AccountID) AS AccountID, MIN(sa.ParentAccountID) AS ParentAccountID
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	WHERE i.VoidDate IS NULL
	AND i.Processed = 1
	AND (i.ChargeAmount <> i.PaidAmount OR (i.ChargeAmount = 0 AND i.InvoiceID = @InvoiceID))
	AND i.CustomerID = @CustomerID
GROUP BY ii.ItemID
UNION ALL
SELECT CASE WHEN MIN(i.InvoiceID) = @InvoiceID THEN 2 WHEN MIN(i.InvoiceTypeID) IN (91,92) AND MIN(ma.PaymentTypeID) IN (8,16) AND @upgrade = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, 0 AS Amount, 0 - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate, MIN(ii.AccountID) AS AccountID, MIN(sa.ParentAccountID) AS ParentAccountID
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	WHERE i.VoidDate IS NOT NULL
	AND i.Processed = 1
	AND (i.PaidAmount <> 0 OR (i.ChargeAmount = 0 AND i.InvoiceID = @InvoiceID))
	AND i.CustomerID = @CustomerID
GROUP BY ii.ItemID
ORDER BY 1 ASC, 8 DESC, 3 DESC, 2 DESC
END ELSE BEGIN
SELECT ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, CASE WHEN MIN(i.VoidDate) IS NULL THEN MIN(ii.Amount * ii.Quantity) ELSE 0 END AS Amount, CASE WHEN MIN(i.VoidDate) IS NULL THEN ROUND(MIN(ii.Amount * ii.Quantity),2) ELSE 0 END - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(ii.AccountID) AS AccountID, MIN(sa.ParentAccountID) AS ParentAccountID
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.Estimate = 0
GROUP BY ii.ItemID
ORDER BY 2 DESC, 1 DESC
END
GO

CREATE PROCEDURE dbo.BillingCycleExpireReset (@BillingCycleID INT) AS
SET NOCOUNT ON
DECLARE @PartialMode INT, @PartialAmount NUMERIC(18,4), @PartialPercent NUMERIC(18,4)
CREATE TABLE #bcer (AccountID INT PRIMARY KEY, ExpireDate DATETIME, Cost NUMERIC(18,4), StartDate DATETIME, AutoBill SMALLINT)

SELECT @PartialMode = COALESCE(MAX(NumValue),0) FROM Configs WHERE ConfigID = 603
SELECT @PartialAmount = COALESCE(MAX(NumValue),0.01) FROM Configs WHERE ConfigID = 604
SELECT @PartialPercent = CASE WHEN @PartialAmount IS NULL THEN .01 WHEN @PartialAmount BETWEEN 1 AND 100 THEN @PartialAmount/100 WHEN @PartialAmount BETWEEN .01 AND .99 THEN @PartialAmount END

INSERT INTO #bcer (AccountID, ExpireDate, Cost, StartDate, AutoBill)
SELECT sa.AccountID,
MAX(CASE		WHEN bc.AutoBill = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN COALESCE(pm.NumValue,@PartialMode) = 0 AND ii.PaidAmount >= COALESCE(pa.NumValue,@PartialAmount) THEN ii.EndDate
			WHEN COALESCE(pm.NumValue,@PartialMode) = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * @PartialPercent) <= ii.PaidAmount  THEN ii.EndDate
			WHEN COALESCE(pm.NumValue,@PartialMode) = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
END) AS ExpireDate, SUM(ii.Amount * ii.Quantity) AS Cost, MIN(ii.StartDate) AS StartDate, MIN(bc.AutoBill) AS AutoBill
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN InvoiceItems ii ON (sa.AccountID = ii.AccountID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	LEFT JOIN ConfigGroupData pm ON (pm.ConfigID = 603 AND ma.GroupID = pm.GroupID)
	LEFT JOIN ConfigGroupData pa ON (pa.ConfigID = 604 AND ma.GroupID = pa.GroupID)
	WHERE ii.ItemType = 3
	AND bc.AutoBill IN (0,1)
	AND ma.BillingCycleID = @BillingCycleID
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
GROUP BY sa.AccountID

UPDATE SubAccounts SET ExpireDate = CASE WHEN diu.AutoBill = 1 THEN NULL WHEN diu.ExpireDate IS NOT NULL THEN diu.ExpireDate WHEN sa.ExpireDate >= diu.StartDate THEN DATEADD(dd,-1,diu.StartDate) ELSE sa.ExpireDate END
FROM SubAccounts sa JOIN #bcer diu ON (sa.AccountID = diu.AccountID)

WHILE (@@ROWCOUNT > 0)
BEGIN
UPDATE sa SET ExpireDate = sap.ExpireDate
FROM SubAccounts sa JOIN SubAccounts sap ON (sa.ParentAccountID = sap.AccountID)
	JOIN #bcer diu ON (sa.AccountID = diu.AccountID)
	WHERE sap.ExpireDate IS NOT NULL
	AND diu.Cost = 0
	AND sa.ExpireDate = diu.ExpireDate
	AND sa.Recurring = 1
	AND sap.ExpireDate < sap.BilledThru
	AND (sa.ExpireDate IS NULL OR sa.ExpireDate <> sap.ExpireDate)
END

SELECT COUNT(*) AS Cnt FROM #bcer
GO

CREATE PROCEDURE dbo.DistInvoiceUpdate (@InvoiceID INT) AS
SET NOCOUNT ON

DECLARE @CustomerID INT, @GroupID INT, @PaidAmount NUMERIC(18,4), @AutoBill INT, @PartialMode INT, @PartialAmount NUMERIC(18,4), @PartialPercent NUMERIC(18,4)
CREATE TABLE #diu (AccountID INT PRIMARY KEY, ExpireDate DATETIME, Cost NUMERIC(18,4), StartDate DATETIME)

SELECT @CustomerID = ma.CustomerID, @GroupID = ma.GroupID, @AutoBill = bc.AutoBill
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE i.InvoiceID = @InvoiceID

SELECT @PartialMode = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 603 AND GroupID = @GroupID
SELECT @PartialAmount = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 604 AND GroupID = @GroupID

IF (@PartialMode IS NULL)
BEGIN
SELECT @PartialMode = MAX(NumValue) FROM Configs WHERE ConfigID = 603
END

IF (@PartialAmount IS NULL)
BEGIN
SELECT @PartialAmount = MAX(NumValue) FROM Configs WHERE ConfigID = 604
END

IF (@PartialMode IS NULL OR @PartialMode = 0)
BEGIN
SELECT @PartialMode = 0, @PartialAmount = COALESCE(@PartialAmount,0.01)
END

IF (@PartialMode = 1)
BEGIN
SELECT @PartialPercent = CASE WHEN @PartialAmount IS NULL THEN .01 WHEN @PartialAmount BETWEEN 1 AND 100 THEN @PartialAmount/100 WHEN @PartialAmount BETWEEN .01 AND .99 THEN @PartialAmount END
END

SELECT @PaidAmount = SUM(ii.PaidAmount)
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	WHERE i.InvoiceID = @InvoiceID
	AND (ii.Quantity * ii.Amount) > 0

UPDATE Invoices SET PaidAmount = COALESCE(@PaidAmount,0) 
	WHERE InvoiceID = @InvoiceID 
	AND PaidAmount <> COALESCE(@PaidAmount,0)

INSERT INTO #diu (AccountID, ExpireDate, Cost, StartDate)
SELECT sa.AccountID,
MAX(CASE		WHEN @AutoBill = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN @PartialMode = 0 AND ii.PaidAmount >= @PartialAmount THEN ii.EndDate
			WHEN @PartialMode = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * @PartialPercent) <= ii.PaidAmount  THEN ii.EndDate
			WHEN @PartialMode = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
			WHEN @AutoBill = 0 AND sa.ExpireDate IS NULL THEN ii.StartDate
END) AS ExpireDate, SUM(ii.Amount * ii.Quantity) AS Cost, MIN(ii.StartDate) AS StartDate
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN InvoiceItems ii ON (sa.AccountID = ii.AccountID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	WHERE ii.ItemType = 3
	AND @AutoBill IN (0,1)
	AND i.VoidDate IS NULL
	AND i.InvoiceID >= @InvoiceID
	AND ma.CustomerID = @CustomerID
	AND i.Processed = 1
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
GROUP BY sa.AccountID

UPDATE SubAccounts SET ExpireDate = CASE WHEN @AutoBill = 1 THEN NULL WHEN diu.ExpireDate IS NOT NULL THEN diu.ExpireDate WHEN sa.ExpireDate >= diu.StartDate THEN DATEADD(dd,-1,diu.StartDate) ELSE sa.ExpireDate END
FROM SubAccounts sa JOIN #diu diu ON (sa.AccountID = diu.AccountID)

WHILE (@@ROWCOUNT > 0)
BEGIN
UPDATE sa SET ExpireDate = sap.ExpireDate
FROM SubAccounts sa JOIN SubAccounts sap ON (sa.ParentAccountID = sap.AccountID)
	JOIN #diu diu ON (sa.AccountID = diu.AccountID)
	WHERE sap.ExpireDate IS NOT NULL
	AND diu.Cost = 0
	AND sa.ExpireDate = diu.ExpireDate
	AND sa.Recurring = 1
	AND sap.ExpireDate < sap.BilledThru
	AND (sa.ExpireDate IS NULL OR sa.ExpireDate <> sap.ExpireDate)
END
GO

CREATE PROCEDURE dbo.DistPayGet (@CustomerID INT, @PaymentID INT) AS
SET NOCOUNT ON
SELECT 1 AS IDType, p.PaymentID AS PID, MIN(COALESCE(p.FinalAmount,p.Amount)) AS Amount, COALESCE(SUM(pi1.Amount),0) AS AmountCommit, MIN(p.DistFlag) AS DistFlag
FROM Payments p LEFT JOIN PaymentItems pi1 ON (p.PaymentID = pi1.PaymentID AND pi1.InactiveDate IS NULL)
	WHERE p.CustomerID = @CustomerID
	AND (p.DistFlag = 1 OR p.PaymentID = @PaymentID)
GROUP BY p.PaymentID
UNION ALL
SELECT 2 AS IDType, c.ChargeID AS PID, CASE WHEN MIN(i2.VoidDate) IS NULL AND (MAX(i2.Estimate) IS NULL OR MAX(i2.Estimate) = 0) THEN CASE WHEN  -(MIN(c.Amount * c.Quantity))  < 0 THEN 0 ELSE -(MIN(c.Amount * c.Quantity))  END ELSE 0 END AS Amount, COALESCE(SUM(pi1.Amount),0) AS AmountCommit, MIN(c.DistFlag) AS DistFlag
FROM Charges c LEFT JOIN PaymentItems pi1 ON (pi1.PaymentID IS NULL AND c.ChargeID = pi1.ChargeID AND pi1.InactiveDate IS NULL)
	LEFT JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN InvoiceItems ii2 ON (c.ItemID = ii2.ItemID)
	LEFT JOIN Invoices i2 ON (ii2.InvoiceID = i2.InvoiceID)
	LEFT JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	WHERE c.CustomerID = @CustomerID
	AND c.DistFlag = 1
	AND c.Quantity > 0
	AND (i.Estimate IS NULL OR i.Estimate = 0)
	AND (c.Amount < 0 OR pi1.ChargeID IS NOT NULL)
GROUP BY c.ChargeID
ORDER BY 1 ASC, 2 DESC
GO

CREATE PROCEDURE dbo.DistPayItemAdd (@PaymentID INT, @ChargeID INT, @ItemID INT, @Amount NUMERIC(18,4)) AS
INSERT INTO PaymentItems (PaymentID,ChargeID,ItemID,Amount,ActiveDate) 
VALUES(@PaymentID,@ChargeID,@ItemID,@Amount,getdate())
GO

CREATE PROCEDURE dbo.DomainGlobalUse (@DomainID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @CBTCount INT, @GroupCount INT, @SignupServerCount INT

SELECT @CBTCount = COUNT(*) FROM CardBatchTypes WHERE DomainID = @DomainID
SELECT @GroupCount = COUNT(*) FROM Groups WHERE DomainID = @DomainID
SELECT @SignupServerCount = COUNT(*) FROM SignupServers WHERE DomainID = @DomainID

SELECT CASE WHEN @CBTCount > 0 OR @GroupCount > 0 OR @SignupServerCount > 0 THEN 1 ELSE 0 END AS GlobalUse
GO

CREATE PROCEDURE dbo.ESAptilo (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
sa.Login + '@' + d.MailDomain AS Username,
a.FirstName AS FirstName,
a.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ab.Email,sa.Email) AS Email,
COALESCE(a.PhoneHome,a.PhoneWork) AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' + CAST(at1.DataLeft AS VARCHAR(16)) END accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'normal' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
a.FirstName AS FirstName,
a.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ab.Email,sa.Email) AS Email,
COALESCE(a.PhoneHome,a.PhoneWork) AS Phonenumber,
NULL AS accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'timereducer' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' + CAST(at1.DataLeft AS VARCHAR(16)) END AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(sa.LastDataRenewal AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND at1.DataLeft IS NOT NULL
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> CAST(sa.LastDataRenewal AS VARCHAR(32)))

UNION ALL

SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux2 IS NULL OR esy.Aux2 <> CAST(DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) AS VARCHAR(32)))
END
GO

CREATE PROCEDURE dbo.ESCPanel (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan, sa.Password, sa.Email, CASE WHEN sad.Data IS NOT NULL AND sad.Data LIKE '%.%' THEN 'y' ELSE 'n' END AS ip, sad.Data AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 524288 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan,
NULL AS Password, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Aux1 <> COALESCE(esat.ExternalRef,at1.AccountType)
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL

SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, sa.Password,
NULL AS cplan, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, 
CASE WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'Account canceled' ELSE 'Account Expired' END AS reason,
NULL AS cplan, NULL AS Password, NULL AS Email, NULL AS ip, NULL AS customip

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS Password, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS Password, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

END
GO

CREATE PROCEDURE dbo.ESDiino (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
sa.Login AS Username, sa.Password, a.FirstName, a.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ab.Email) END AS Email,
c.Abbr2 AS country, NULL AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = a.AddressID)
	JOIN Countries c ON (ab.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
NULL AS username, sa.Password, a.FirstName, a.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ab.Email) END AS Email,
c.Abbr2 AS country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Countries c ON (ab.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATALENGTH(sa.Password) > 5
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
END
GO

CREATE PROCEDURE dbo.ESDirectAdmin (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, sad2.Data AS domain, COALESCE(esat.ExternalRef,at1.AccountType) AS package, sa.Password, sa.Email, sad.Data AS ip
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	LEFT JOIN SubAccountData sad2 ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 25)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 4
	AND sad2.Data IS NOT NULL
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, sa.Password
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 4
	AND sa.Login IS NOT NULL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, CASE WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'Account canceled' ELSE 'Account Expired' END AS reason
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
END
GO

CREATE PROCEDURE dbo.ESEFolder (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,CHARINDEX(':',esat.ExternalRef)+1,20) ELSE NULL END AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
sa.Login AS Username,
sa.Password,
ab.Company AS ct_company,
a.FirstName AS ct_firstname,
a.LastName AS ct_lastname,
COALESCE(a.PhoneHome,ab.PhoneHome) AS ct_phone,
ab.Address1 AS ct_address1,
ab.Address2 AS ct_address2,
ab.City as ct_city,
s.Abbreviation AS ct_state,
ab.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ab.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN Countries c ON (ab.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
ab.Company AS ct_company,
a.FirstName AS ct_firstname,
a.LastName AS ct_lastname,
COALESCE(a.PhoneHome,ab.PhoneHome) AS ct_phone,
ab.Address1 AS ct_address1,
ab.Address2 AS ct_address2,
ab.City as ct_city,
s.Abbreviation AS ct_state,
ab.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ab.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN Countries c ON (ab.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < ma.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
sa.Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> COALESCE(esat.ExternalRef,'') + COALESCE(esat.Description,''))

UNION ALL

SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND es.Aux2 IS NOT NULL
	AND esy.LastModifyDate < DATEADD(mi,-(CAST(es.Aux2 AS INTEGER)),getdate())
END
GO

CREATE PROCEDURE dbo.ESEFolderUpdate (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @Login VARCHAR(64), @Aux1 VARCHAR(255), @Password VARCHAR(128)

IF (@Retcode = 0)
BEGIN
SELECT @Login = COALESCE(sa.Login,sa.Email), @Password = sa.Password, @Aux1 = COALESCE(esat.ExternalRef,'') + COALESCE(esat.Description,'')
FROM SubAccounts sa JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (es.ExternalSystemID = esat.ExternalSystemID AND sa.AccountTypeID = esat.AccountTypeID)
	WHERE es.ExternalSyncID = @ExternalSyncID

IF (@TransTypeID = 1024)
BEGIN
UPDATE	ExternalSyncs SET ErrorCount = 0, Message = NULL, Login = @Login, Password = @Password, Aux1 = @Aux1, Aux2 = NULL, Aux3 = NULL, 
	CreateDate = getdate(), LastModifyDate = getdate(), LastUpdate = getdate(), Active = 1, Created = 1, ProcTransID = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 524288)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux1 = @Aux1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 1048576)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux2 = CASE WHEN Aux2 IS NULL THEN @Data WHEN CAST(Aux2 AS BIGINT) < CAST(@Data AS BIGINT) THEN @Data ELSE Aux2 END
	WHERE ExternalSyncID = @ExternalSyncID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEnom (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @Login VARCHAR(64), @Password VARCHAR(64), @OptionID VARCHAR(15), @AddressTypeID INT, @HostRecord SMALLINT

SELECT @Login = MIN(es.Login), @Password = MIN(es.Password), @OptionID = COALESCE(MIN(es.Aux1),'1054'), @HostRecord = CASE WHEN MIN(es.Aux2) LIKE '%1%' THEN 1 ELSE 0 END, @AddressTypeID = MIN(at1.AddressTypeID)
FROM ExternalSystems es LEFT JOIN AddressTypes at1 ON (es.Aux3 = at1.AddressType)
	WHERE es.ExternalSystemID = @ESID

IF (@Stage = 1)
BEGIN
INSERT INTO Domains (Domain,MailDomain,Description,CustomerID)
SELECT sa.Login, sa.Login, sa.Login, sa.CustomerID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Domains d ON (sa.Login = d.MailDomain)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.Login LIKE '%[a-z0-9].[a-z]%'
	AND d.DomainID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())

INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.Login = d.MailDomain AND ma.CustomerID = d.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND esy.AccountID IS NULL
END

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@Stage = 1)
BEGIN
SELECT esy.ExternalSyncID, 2048 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
a.Company AS RegistrantOrganizationName,
a.FirstName AS RegistrantFirstName,
a.LastName AS RegistrantLastName,
a.Address1 AS RegistrantAddress1,
a.Address2 AS RegistrantAddress2,
a.City AS RegistrantCity,
COALESCE(s.Abbreviation,s.State) AS RegistrantStateProvince,
a.Zip AS RegistrantPostalCode,
c.Country AS RegistrantCountry,
a.Email AS RegistrantEmailAddress,
a.PhoneWork AS RegistrantPhone,
a.PhoneFax AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN States s ON (a.StateID = s.StateID AND a.CountryID = s.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active IN (1,0)
	AND (esy.Created = 1 OR ma.Active = 1)
	AND (esy.Created = 1 OR sa.Active = 1)
	AND (esy.Created = 1 OR g.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (esy.Created = 0 OR esy.LastUpdate < ma.LastModifyDate)
END

IF (@Stage = 2)
BEGIN
SELECT esy.ExternalSyncID, 1024 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
a.Company AS RegistrantOrganizationName,
a.FirstName AS RegistrantFirstName,
a.LastName AS RegistrantLastName,
a.Address1 AS RegistrantAddress1,
a.Address2 AS RegistrantAddress2,
a.City AS RegistrantCity,
COALESCE(s.Abbreviation,s.State) AS RegistrantStateProvince,
a.Zip AS RegistrantPostalCode,
c.Country AS RegistrantCountry,
a.Email AS RegistrantEmailAddress,
a.PhoneWork AS RegistrantPhone,
a.PhoneFax AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN States s ON (a.StateID = s.StateID AND a.CountryID = s.CountryID)
	WHERE ma.Active = 1 
	AND sa.Active = 1 
	AND g.Active = 1 
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND esy.Created = 0
END

IF (@Stage = 3)
BEGIN
SELECT esy.ExternalSyncID, 524288 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
@OptionID AS NewOptionID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> @OptionID)
END

IF (@Stage = 4)
BEGIN
SELECT esy.ExternalSyncID, 1048576 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
@OptionID AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND @HostRecord = 1
	AND (esy.Aux2 IS NULL OR esy.Aux1 <> @OptionID)

UNION ALL

SELECT esy.ExternalSyncID, 2097152 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	WHERE ma.Active = 1
	AND sa.Active = 1 
	AND g.Active = 1
	AND esy.Created = 1
	AND d.ExpireDate < DATEADD(dd,15,getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) > getdate())
END
GO

CREATE PROCEDURE dbo.ESEnomUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @numyears INT, @DomainID INT

IF (@Retcode = 0)
BEGIN

IF (@TransTypeID = 1024)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate(), Created = 1, Active = 1, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, CreateDate = getdate(), ProcTransID = @Data
	WHERE ExternalSyncID = @ExternalSyncID

SELECT @numyears = CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END, @DomainID = d.DomainID
FROM SubAccounts sa JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Domains d ON (sa.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE esy.ExternalSyncID = @ExternalSyncID

UPDATE Domains SET ExpireDate = DATEADD(yy,@numyears,getdate()) WHERE DomainID = @DomainID
END

IF (@TransTypeID = 2048)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate(), Created = 1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2097152)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux3 = @Data
	WHERE ExternalSyncID = @ExternalSyncID

SELECT @numyears = CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END, @DomainID = d.DomainID
FROM SubAccounts sa JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Domains d ON (sa.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE esy.ExternalSyncID = @ExternalSyncID

UPDATE Domains SET ExpireDate = DATEADD(yy,@numyears,ExpireDate) WHERE DomainID = @DomainID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEveryoneDomainUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @DomainID INT, @MailDomain VARCHAR(128)

IF (@Retcode = 0)
BEGIN
SELECT @DomainID = d.DomainID, @MailDomain = d.MailDomain
FROM ExternalSyncs esy JOIN Domains d ON (esy.Aux3 = d.MailDomain)
	WHERE esy.ExternalSyncID = @ExternalSyncID

UPDATE Domains SET ExternalRef = @Data WHERE DomainID = @DomainID
DELETE FROM ExternalSyncs WHERE Aux3 = @MailDomain AND ExternalSyncID = @ExternalSyncID
END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEveryoneNet (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @ClientID VARCHAR(64), @ClientPass VARCHAR(64), @OfferID VARCHAR(64), @ESExternalRef VARCHAR(64)
SELECT @ClientID = Login, @ClientPass = Password, @OfferID = Aux1, @ESExternalRef = Aux2 FROM ExternalSystems WHERE ExternalSystemID = @ESID

IF (@Stage = 1)
BEGIN

INSERT INTO ExternalSyncs (ExternalSystemID,Aux3,Aux6)
SELECT DISTINCT @ESID, d.MailDomain, ' '
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND @ESExternalRef IS NULL
	AND d.ExternalRef IS NULL
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM ExternalSyncs esy2 WHERE esy2.ExternalSystemID = @ESID AND esy2.Aux3 = d.MailDomain)

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT esy.ExternalSyncID, 2097152 AS TransTypeID, NULL AS OrigData, NULL AS Login, NULL Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, NULL AS ExternalRef, @OfferID AS OfferID, d.MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.AccountID IS NULL
	AND esy.Aux3 = d.MailDomain
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND @ESExternalRef IS NULL
	AND d.ExternalRef IS NULL
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID,Aux1,Aux2)
SELECT @ESID, sa.AccountID, COALESCE(a.FirstName,' ') + COALESCE(a.LastName,' '), COALESCE(esat.ExternalRef,@OfferID)
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT esy.ExternalSyncID, 1024 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID)

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active = 0 OR sa.Active = 0 OR ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()))
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND (ma.Active = -1 OR sa.Active = -1 OR sa.BilledThru < DATEADD(dd,-30,getdate()))

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID, NULL, esy.Login, sa.Password, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 524288 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, a.FirstName, a.LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(a.FirstName,' ') + COALESCE(a.LastName,' ') <> esy.Aux1 OR esy.Aux1 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 1048576 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, a.FirstName, a.LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(esat.ExternalRef,@OfferID) <> esy.Aux2 OR esy.Aux2 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 4194304 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, (SELECT MIN(f1.Forward) FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND sa.Login IS NOT NULL
	AND EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')
	AND (esy.Aux4 IS NULL OR esy.Aux4 <> (SELECT MIN(f2.Forward) FROM Forwards f2 WHERE f2.AccountID = sa.AccountID AND f2.Forward LIKE '%[a-z0-9]@[a-z0-9]%'))

UNION ALL

SELECT esy.ExternalSyncID, 8388608 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 0
	AND (esy.Aux5 IS NOT NULL AND esy.Aux5 <> ' ')
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')

UNION ALL

SELECT esy.ExternalSyncID, 16777216 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain,
(SELECT MIN('"' + f1.Forward + '"') FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, CASE WHEN (SELECT COUNT(*) FROM Forwards f3 WHERE f3.AccountID = sa.AccountID AND f3.Forward LIKE '%[a-z0-9]@[a-z0-9]%') > 0 THEN 1 ELSE 0 END AS ForwardOption

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE esat.ExternalSystemID = @ESID
	AND esy.ExternalSystemID = @ESID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 1
	AND esy.Active = 1
	AND (esy.Aux6 IS NULL OR esy.Aux6 <> (SELECT MIN(f4.Forward) FROM Forwards f4 WHERE f4.AccountID = sa.AccountID AND f4.Forward LIKE '%[a-z0-9]@[a-z0-9]%'))
END
GO

CREATE PROCEDURE dbo.ESAccountWS (@ESID INT) AS
SET NOCOUNT ON
DECLARE @APILogin VARCHAR(64), @APIPassword VARCHAR(64), @APIRef VARCHAR(64)
SELECT @APILogin = Login, @APIPassword = Password, @APIRef = Aux1 FROM ExternalSystems WHERE ExternalSystemID = @ESID

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT es.ExternalSyncID,
CASE WHEN ma.Active IN (0,-1) OR sa.Active IN (0,-1) THEN 4096 WHEN es.Created = 0 THEN 1024 ELSE 2048 END AS TransTypeID,
@APILogin AS APILogin, @APIPassword AS APIPassword, @APIRef AS APIRef, esat.ExternalRef AS ESRef,
BINARY_CHECKSUM(ma.RegionID, ma.PaymentTypeID, ma.GroupID, ma.SendMethodID, ma.BillingCycleID, ma.CancelDate, ma.CancelReasonID, ma.PIN, ma.ExternalRef,
sa.Login, sa.Password, sa.AccountTypeID, sa.PayPeriodID, sa.CancelDate, sa.CancelReasonID, sa.Extension, sa.SalesPersonID, sa.RemoteAccess, sa.LoginLimit, sa.DomainID, sa.TowerID,
CASE WHEN bc.AutoBill = 2 OR sa.Recurring = 0 THEN 0 ELSE 1 END,
CASE WHEN ma.Active = -1 OR sa.Active = -1 THEN 'deleted' WHEN ma.Active = 0 OR sa.Active = 0 THEN 'inactive' WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'canceled' WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 'expired' ELSE 'active' END,
b.CountryID, b.StateID, b.Company, b.Address1, b.Address2, b.City, b.Zip, b.FirstName, b.LastName, b.PhoneHome, b.PhoneWork, b.PhoneMobile, b.Email, COALESCE(b.Lat,sb.Lat), COALESCE(b.Long,sb.Long),
v.CountryID, v.StateID, v.Company, v.Address1, v.Address2, v.City, v.Zip, v.FirstName, v.LastName, v.PhoneHome, v.PhoneWork, v.PhoneMobile, v.Email, COALESCE(v.Lat,sv.Lat), COALESCE(v.Long,sv.Long),
c.CountryID, c.StateID, c.Company, c.Address1, c.Address2, c.City, c.Zip, c.FirstName, c.LastName, c.PhoneHome, c.PhoneWork, c.PhoneMobile, c.Email, COALESCE(c.Lat,sc.Lat), COALESCE(c.Long,sc.Long))
AS Aux1, ma.CustomerID, sa.AccountID,
CASE WHEN ma.Active = -1 OR sa.Active = -1 THEN 'deleted' WHEN ma.Active = 0 OR sa.Active = 0 THEN 'inactive' WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'canceled' WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 'expired' ELSE 'active' END AS Status,
CASE WHEN bc.AutoBill = 2 OR sa.Recurring = 0 THEN 0 ELSE 1 END AS Recurring,
CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL THEN CASE WHEN ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE sa.CancelDate END ELSE COALESCE(ma.CancelDate,sa.CancelDate) END AS CancelDate,
CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL THEN CASE WHEN ma.CancelDate < sa.CancelDate THEN macr.CancelReason ELSE sacr.CancelReason END ELSE COALESCE(macr.CancelReason,sacr.CancelReason) END AS CancelReason,

r.Region, pt.PaymentType AS PayMethod, g.GroupName, sm.SendMethod, bc.BillingCycle, ma.PIN, ma.ExternalRef AS MBRExternalRef,
sa.Login, sa.Password, at1.AccountType, pp.PayPeriod, sa.Extension, sp.SalesPerson, CASE sa.RemoteAccess WHEN 0 THEN 'None' WHEN 1 THEN 'Service' WHEN 2 THEN 'Manager' ELSE 'None' END AS RemoteAccess, sa.LoginLimit, 
d.MailDomain AS Domain, t.Tower,

cb.Country AS BillCountry, cb.Abbr2 AS BillCountry2, tb.State AS BillState, tb.Abbreviation AS BillState2, b.Company AS BillCompany, b.Address1 AS BillAddress1, b.Address2 AS BillAddress2, b.City AS BillCity, b.Zip AS BillZip,
b.FirstName AS BillFirstName, b.LastName AS BillLastName, b.PhoneHome AS BillPhoneHome, b.PhoneWork AS BillPhoneWork, b.PhoneMobile AS BillPhoneMobile, b.Email AS BillEmail, b.Lat AS BillLat, b.Long AS BillLong,

cv.Country AS ServiceCountry, cv.Abbr2 AS ServiceCountry2, tv.State AS ServiceState, tv.Abbreviation AS ServiceState2, v.Company AS ServiceCompany, v.Address1 AS ServiceAddress1, v.Address2 AS ServiceAddress2, v.City AS ServiceCity, v.Zip AS ServiceZip,
v.FirstName AS ServiceFirstName, v.LastName AS ServiceLastName, v.PhoneHome AS ServicePhoneHome, v.PhoneWork AS ServicePhoneWork, v.PhoneMobile AS ServicePhoneMobile, v.Email AS ServiceEmail, v.Lat AS ServiceLat, v.Long AS ServiceLong,

cc.Country AS ContactCountry, cc.Abbr2 AS ContactCountry2, tc.State AS ContactState, tc.Abbreviation AS ContactState2, c.Company AS ContactCompany, c.Address1 AS ContactAddress1, c.Address2 AS ContactAddress2, c.City AS ContactCity, c.Zip AS ContactZip,
c.FirstName AS ContactFirstName, c.LastName AS ContactLastName, c.PhoneHome AS ContactPhoneHome, c.PhoneWork AS ContactPhoneWork, c.PhoneMobile AS ContactPhoneMobile, c.Email AS ContactEmail, c.Lat AS ContactLat, c.Long AS ContactLong

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	LEFT JOIN Addresses b ON (ma.BillingAddressID = b.AddressID)
	LEFT JOIN Addresses v ON (sa.ServiceAddressID = v.AddressID)
	LEFT JOIN Addresses c ON (sa.ContactAddressID = c.AddressID)
	LEFT JOIN AddressSyncs sb ON (b.AddressID = sb.AddressID AND b.Lat IS NULL AND b.Long IS NULL AND sb.Lat IS NOT NULL AND sb.Long IS NOT NULL)
	LEFT JOIN AddressSyncs sv ON (v.AddressID = sv.AddressID AND v.Lat IS NULL AND v.Long IS NULL AND sv.Lat IS NOT NULL AND sv.Long IS NOT NULL)
	LEFT JOIN AddressSyncs sc ON (c.AddressID = sc.AddressID AND c.Lat IS NULL AND c.Long IS NULL AND sc.Lat IS NOT NULL AND sc.Long IS NOT NULL)
	JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = es.ExternalSystemID AND esat.AccountTypeID = sa.AccountTypeID)

	JOIN Regions r ON (ma.RegionID = r.RegionID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CancelReasons macr ON (ma.CancelReasonID = macr.CancelReasonID)

	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN CancelReasons sacr ON (sa.CancelReasonID = sacr.CancelReasonID)
	LEFT JOIN SalesPersons sp ON (sa.SalesPersonID = sp.SalesPersonID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Towers t ON (sa.TowerID = t.TowerID)

	LEFT JOIN States tb ON (b.StateID = tb.StateID)
	LEFT JOIN States tv ON (v.StateID = tv.StateID)
	LEFT JOIN States tc ON (c.StateID = tc.StateID)

	LEFT JOIN Countries cb ON (b.CountryID = cb.CountryID)
	LEFT JOIN Countries cv ON (v.CountryID = cv.CountryID)
	LEFT JOIN Countries cc ON (c.CountryID = cc.CountryID)

	WHERE es.ExternalSystemID = @ESID
	AND ((es.Created = 0 
		AND ma.Active = 1
		AND sa.Active = 1
		AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate()))
	OR (es.Created = 1 AND CAST(
BINARY_CHECKSUM(ma.RegionID, ma.PaymentTypeID, ma.GroupID, ma.SendMethodID, ma.BillingCycleID, ma.CancelDate, ma.CancelReasonID, ma.PIN, ma.ExternalRef,
sa.Login, sa.Password, sa.AccountTypeID, sa.PayPeriodID, sa.CancelDate, sa.CancelReasonID, sa.Extension, sa.SalesPersonID, sa.RemoteAccess, sa.LoginLimit, sa.DomainID, sa.TowerID,
CASE WHEN bc.AutoBill = 2 OR sa.Recurring = 0 THEN 0 ELSE 1 END,
CASE WHEN ma.Active = -1 OR sa.Active = -1 THEN 'deleted' WHEN ma.Active = 0 OR sa.Active = 0 THEN 'inactive' WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'canceled' WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 'expired' ELSE 'active' END,
b.CountryID, b.StateID, b.Company, b.Address1, b.Address2, b.City, b.Zip, b.FirstName, b.LastName, b.PhoneHome, b.PhoneWork, b.PhoneMobile, b.Email, COALESCE(b.Lat,sb.Lat), COALESCE(b.Long,sb.Long),
v.CountryID, v.StateID, v.Company, v.Address1, v.Address2, v.City, v.Zip, v.FirstName, v.LastName, v.PhoneHome, v.PhoneWork, v.PhoneMobile, v.Email, COALESCE(v.Lat,sv.Lat), COALESCE(v.Long,sv.Long),
c.CountryID, c.StateID, c.Company, c.Address1, c.Address2, c.City, c.Zip, c.FirstName, c.LastName, c.PhoneHome, c.PhoneWork, c.PhoneMobile, c.Email, COALESCE(c.Lat,sc.Lat), COALESCE(c.Long,sc.Long))
	AS VARCHAR) <> es.Aux1))
GO

CREATE PROCEDURE dbo.ESAccountWSUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(768), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN

IF (@TransTypeID = 1024)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, CreateDate = getdate(), LastModifyDate = getdate(), LastUpdate = getdate(), Created = 1, Aux1 = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2048)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate(), Aux1 = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 4096)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Created = 0, Aux1 = NULL
	WHERE ExternalSyncID = @ExternalSyncID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESGenericWS (@ESID INT) AS
SET NOCOUNT ON
DECLARE @APILogin VARCHAR(64), @APIPassword VARCHAR(64), @APIRef VARCHAR(64)
SELECT @APILogin = Login, @APIPassword = Password, @APIRef = Aux1 FROM ExternalSystems WHERE ExternalSystemID = @ESID

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT es.ExternalSyncID, 2048 AS TransTypeID, @APILogin AS APILogin, @APIPassword AS APIPassword, @APIRef AS APIRef, ma.CustomerID, sa.AccountID,
d.MailDomain AS Domain, CASE WHEN d.MailDomain = es.Aux1 THEN 0 ELSE 1 END AS chDomain,
sa.Login, CASE WHEN sa.Login = es.Login THEN 0 ELSE 1 END AS chLogin,
sa.Password, CASE WHEN sa.Password = es.Password THEN 0 ELSE 1 END AS chPassword,
a.FirstName, CASE WHEN a.FirstName = es.Aux2 THEN 0 ELSE 1 END AS chFirstName,
a.LastName, CASE WHEN a.LastName = es.Aux3 THEN 0 ELSE 1 END AS chLastName,
at1.AccountType AS ServiceType, CASE WHEN es.Aux4 = at1.AccountType THEN 0 ELSE 1 END AS chServiceType,
esat.ExternalRef, CASE WHEN COALESCE(es.Aux5,' ') = COALESCE(esat.ExternalRef,' ') THEN 0 ELSE 1 END AS chExternalRef,
(SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID) AS Alias,
CASE WHEN COALESCE(es.Aux6,' ') = COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chAlias,
(SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID) AS Forward,
CASE WHEN COALESCE(es.Aux7,' ') = COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chForward,
CASE WHEN es.Created = 0 THEN 'add' WHEN sa.Active <> 1 OR sa.Active <> 1 THEN 'delete' ELSE 'update' END AS Action,
CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END AS Active, 

CASE WHEN CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END = es.Active THEN 0 ELSE 1 END AS chActive

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = es.ExternalSystemID AND esat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)

	WHERE es.ExternalSystemID = @ESID
	AND (sa.Active IN (0,-1) 
		OR ma.Active IN (0,-1)
		OR d.MailDomain <> es.Aux1
		OR sa.Login <> es.Login
		OR sa.Password <> es.Password
		OR COALESCE(a.FirstName,' ') <> COALESCE(es.Aux2,' ')
		OR COALESCE(a.LastName,' ') <> COALESCE(es.Aux3,' ')
		OR at1.AccountType <> es.Aux4
		OR COALESCE(esat.ExternalRef,' ')  <> COALESCE(es.Aux5,' ')
		OR CASE WHEN ma.Active = 1 
			AND sa.Active = 1
			AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
			AND DATALENGTH(sa.Password) > 2
		THEN 1 ELSE 0 END <> es.Active

		OR COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID=sa.AccountID),' ') <> COALESCE(es.Aux6,' ')
		OR COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID=sa.AccountID),' ') <> COALESCE(es.Aux7,' ')
	)
GO

CREATE PROCEDURE dbo.ESGenericWSUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN
UPDATE es SET Login = sa.Login, Password = sa.Password, LastUpdate = GETDATE(), LastModifyDate = GETDATE(), ErrorCount = 0, Message = NULL,
Aux1 = d.MailDomain, Aux2 = a.FirstName, Aux3 = a.LastName, Aux4 = at1.AccountType, Aux5 = esat.ExternalRef, 
Aux6 = (SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID),
Aux7 = (SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID),
Created = CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END,
Active = CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = es.ExternalSystemID AND esat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE es.ExternalSyncID = @ExternalSyncID

DELETE FROM ExternalSyncs WHERE ExternalSyncID = @ExternalSyncID AND Created = 0

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESHelm (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esat.ExternalRef IS NOT NULL
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2
	AND es.Aux1 IS NOT NULL
	AND sad.Data = '1'

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1024 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
CASE WHEN COALESCE(s.Abbreviation,s.State) IS NOT NULL THEN COALESCE(ab.City,' ') + ', ' + COALESCE(s.Abbreviation,s.State) ELSE ab.City END AS Town,
ab.Zip AS PostCode,
c.Abbr2 AS CountryCode,
NULL AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	LEFT JOIN Countries c ON (ab.CountryID = c.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
524288 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE 
		(
		SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2 JOIN SubAccounts sa2 ON (es2.AccountID = sa2.AccountID)
			JOIN SubAccountData sad2 ON (sa2.AccountID = sad2.AccountID)
			WHERE sa2.CustomerID = ma.CustomerID
			AND sa2.Active = 1
			AND es2.ExternalSystemID = @ESID
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sad2.AccountDataTypeID = 23
		) END AS UserAccountID,
esat.ExternalRef AS PlanID,
sa.Login + ' (' + at1.AccountType + ')' AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Aux1 IS NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data = '2' AND EXISTS 
		(
		SELECT * 
		FROM ExternalSyncs es2 JOIN SubAccounts sa2 ON (es2.AccountID = sa2.AccountID)
			JOIN SubAccountData sad2 ON (sa2.AccountID = sad2.AccountID)
			WHERE sa2.CustomerID = ma.CustomerID
			AND es2.ExternalSystemID = @ESID
			AND sa2.Active = 1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sad2.AccountDataTypeID = 23
		)))
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
END

IF (@Stage = 3)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1048576 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE
		(
		SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2 JOIN SubAccounts sa2 ON (es2.AccountID = sa2.AccountID)
			JOIN SubAccountData sad2 ON (sa2.AccountID = sad2.AccountID)
			WHERE sa2.CustomerID = ma.CustomerID
			AND sa2.Active = 1
			AND es2.ExternalSystemID = @ESID
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sad2.AccountDataTypeID = 23
		) END AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Aux1 IS NOT NULL
	AND esy.Aux2 IS NULL
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data IN ('2','3') AND EXISTS
		(
		SELECT * 
		FROM ExternalSyncs es2 JOIN SubAccounts sa2 ON (es2.AccountID = sa2.AccountID)
			JOIN SubAccountData sad2 ON (sa2.AccountID = sad2.AccountID)
			WHERE sa2.CustomerID = ma.CustomerID
			AND es2.ExternalSystemID = @ESID
			AND sa2.Active = 1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sad2.AccountDataTypeID = 23
		)))
END

IF (@Stage = 4)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
262144 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
131072 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
4096 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ab.Company AS CompanyName,
a.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
a.Email AS AdminEmailAddress,
a.FirstName, a.LastName,
ab.Address1, ab.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL
END
GO

CREATE PROCEDURE dbo.ESSmarterMail (@ESID INT) AS
SET NOCOUNT ON
DECLARE @authlogin VARCHAR(64), @authpassword VARCHAR(64)
SELECT @authlogin = Login, @authpassword = Password FROM ExternalSystems WHERE ExternalSystemID = @ESID

INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT esy.ExternalSyncID, 1024 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, a.FirstName, a.LastName, d.MailDomain AS Domain

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 1
	AND sa.Login IS NOT NULL

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, a.FirstName, a.LastName, d.MailDomain AS Domain

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, a.FirstName, a.LastName, d.MailDomain AS Domain

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (ma.Active = 0 OR sa.Active = 0 OR ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()))
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, a.FirstName, a.LastName, d.MailDomain AS Domain

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, a.FirstName, a.LastName, d.MailDomain AS Domain

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 1
GO

CREATE PROCEDURE dbo.ESZimbra (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @cnt INT

IF (@Stage = 1)
BEGIN
SELECT @cnt = COUNT(*) FROM ExternalSyncs WHERE ExternalSystemID = @ESID AND AccountID IS NULL
IF (@cnt = 0)
	BEGIN
	INSERT INTO ExternalSyncs (ExternalSystemID) VALUES(@ESID)
	END

SELECT 67108864 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin, 
es.Password AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
NULL AS AuthToken,
NULL AS COSID

FROM ExternalSystems es JOIN ExternalSyncs esy ON (es.ExternalSystemID = esy.ExternalSystemID)
	WHERE es.ExternalSystemID = @ESID
	AND esy.AccountID IS NULL
	AND esy.Aux1 IS NULL
	AND (esy.Aux8 IS NULL OR esy.LastModifyDate < DATEADD(mi,-30,getdate()))
END

IF (@Stage = 2)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID AND es.Aux1 IS NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID,Aux1)
SELECT DISTINCT @ESID, sa.AccountID, a.Alias
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND a.AccountID = es.AccountID AND a.Alias = es.Aux1)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND DATALENGTH(a.Alias) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
sa.Password AS Password,
a.FirstName AS FirstName,
a.LastName AS LastName,
ab.Address1 AS Address1,
ab.City AS City,
s.State AS State,
ab.Zip AS Zip,
COALESCE(ab.PhoneHome,ab.PhoneWork) AS Phone,
ab.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 3)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
a.FirstName AS FirstName,
a.LastName AS LastName,
ab.Address1 AS Address1,
ab.City AS City,
s.State AS State,
ab.Zip AS Zip,
COALESCE(ab.PhoneHome,ab.PhoneWork) AS Phone,
ab.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.LastUpdate < sa.LastModifyDate OR esy.LastUpdate < ma.LastModifyDate)

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND esy.Created = 1
	AND esy.Active = 0

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1	

UNION ALL

SELECT 8192 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE esy.Created = 1
	AND esy.Login <> sa.Login

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
sa.Password AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 1048576 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
a.Alias AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND DATALENGTH(a.Alias) > 1
	AND esa.Aux2 IS NULL

UNION ALL

SELECT 2097152 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
esa.Aux1 AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esa.Aux2 IS NOT NULL
	AND a.AliasID IS NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
END
GO

CREATE PROCEDURE dbo.ErrorHistory (@start DATETIME, @stop DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @istart DATETIME, @istop DATETIME
SELECT @istop = COALESCE(@stop,getdate()), @istart = COALESCE(@start,DATEADD(hh,-6,DATEADD(ss,-(  (DATEPART(hh,getdate()) * 3600) + (DATEPART(mi,getdate()) * 60) + DATEPART(ss,getdate()) ),getdate())))

SELECT 'Scheduled task failure - ' + COALESCE(s.TaskName,'') AS Description, sl.Description AS Message, COUNT(*) AS ErrCount
FROM Schedules s Left Join ScheduleLogs sl ON sl.ScheduleID = s.ScheduleID
WHERE sl.StartDate BETWEEN @istart AND @istop 
	AND sl.Status = 2
GROUP BY sl.Description,  s.TaskName

UNION ALL

SELECT 'Invoices /w pending email delivery ' AS Description, '' AS Message, COUNT(*) AS ErrCount
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND sm.EmailTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND ((g.AutoEmailInvoices = 1 AND sm.EmailInvoice IS NULL) OR (sm.EmailInvoice = 1))
	AND i.Processed = 1
	AND i.ChargeAmount > i.PaidAmount
	AND i.CreateDate BETWEEN DATEADD(dd,-45,getdate()) AND DATEADD(dd,-2,getdate())
	AND i.VoidDate IS NULL
	AND i.EmailDate IS NULL
	AND i.PrintDate IS NULL
HAVING COUNT(*) > 0

UNION ALL

SELECT 'Statements /w pending email delivery ' AS Description, '' AS Message, COUNT(*) AS ErrCount
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND sm.EmailTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND ((g.AutoEmailStatements = 1 AND sm.EmailStatement IS NULL) OR (sm.EmailStatement = 1))
	AND s.EndBal > 0
	AND s.StatementDate > DATEADD(dd,-2,getdate())
	AND s.EmailDate IS NULL
	AND s.PrintDate IS NULL
HAVING COUNT(*) > 0

UNION ALL

SELECT 'Card processing' AS Description, et.Response AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	WHERE et.TransStateID = 3
	AND et.ProcDate BETWEEN @istart AND @istop
	AND ma.Active = 1
GROUP BY et.Response

UNION ALL

SELECT 'CC/EFT status' AS Description, MIN(ts.TransState) AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et JOIN TransStates ts ON (et.TransStateID = ts.TransStateID)
	WHERE et.TransStateID IN (1,7,10)
GROUP BY et.TransStateID

UNION ALL

SELECT 'Card trans' AS Description, MIN(bp.BatchProcessor) + ' awaiting ' + CASE WHEN TransStateID = 0 THEN 'export' WHEN TransStateID =  2 THEN 'response' ELSE 'internal error' END + ' for more than 15 days' AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	WHERE et.TransStateID IN (0,2)
	AND et.ReqDate <= DATEADD(dd,-15,getdate())
	AND ma.Active = 1
	AND bp.Active IN (1,0)
GROUP BY bp.BatchProcessorID, TransStateID

UNION ALL

SELECT 'rating charges' AS Description, MIN(r.Rate) + ' is over ' + CAST(MIN(DATEDIFF(mm,rh.StartDate,getdate())) AS VARCHAR(10)) + ' month(s) behind schedule' AS Message, COUNT(*) AS ErrCount
FROM RateHistory rh JOIN Rates r ON (rh.RateID = r.RateID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE rh.StartDate < DATEADD(dd,-60,getdate())
	AND rh.ChargeID IS NULL
	AND rh.TotalCost > 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND rh.RateCostTypeID = 1
GROUP BY r.RateID, DATEDIFF(mm,rh.StartDate,getdate())

UNION ALL

SELECT 'CC/EFT pending against finalized payment', 'ExternalTransID ' + CAST(et.ExternalTransID AS VARCHAR(15)) + ', CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)), 1
FROM MasterAccounts ma JOIN ExternalTrans et ON (ma.CustomerID = et.CustomerID)
	JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE p.FinalAmount IS NOT NULL
	AND et.TransStateID = 0
	AND ma.Active = 1

UNION ALL

SELECT 'No task history for last 2 days','Is the Emerald Task Scheduler running?',1
FROM Configs
	WHERE ConfigID = 0
	AND DATEDIFF(dd,COALESCE((SELECT MAX(StartDate) FROM ScheduleLogs),getdate()),getdate()) > 2

UNION ALL

SELECT 'CC Auto Pay /w no CC number on file', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,''), 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 8
	AND cc.CardNumber IS NULL
	AND cc.Token IS NULL

UNION ALL

SELECT 'CC Auto Pay /w no active CC batch processor', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,''), 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 8
	AND cc.BatchProcessorID IS NULL
	AND cc.CardNumber IS NOT NULL
	AND cc.Token IS NULL
	AND DATEADD(mm,1,cc.ExpirationDate) > getdate()
	AND NOT EXISTS
		(
		SELECT *
		FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (1,5)
			AND (bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID)
			AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
			AND (ct.CardTypeID IS NULL OR bp.CardTypes & ct.CardTypeID = ct.CardTypeID OR bp.CardTypes & 256 = 256)
			AND (cc.CardLength IS NULL OR cc.CardLength IN (ct.Length1,ct.Length2))
		)

UNION ALL

SELECT 'Bank Auto Pay /w no active EFT batch processor', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,''), 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 16
	AND NOT EXISTS
		(
		SELECT *
		FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
			WHERE bp.Active = 1
			AND e.ExportType IN (4,6)
			AND (bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID)
			AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
		)

UNION ALL

SELECT CASE WHEN bp.Active <> 1 THEN 'Tokenized CC Auto Pay /w Inactive batch processor' WHEN e.ExportType <> 10 THEN 'Tokenized CC Auto Pay assigned non-tokenized batch processor' END, 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,''), 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN BatchProcessors bp ON (cc.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 8
	AND cc.Token IS NOT NULL
	AND (bp.Active <> 1 OR e.ExportType <> 10)

UNION ALL

SELECT 'EFT Auto Pay /w no bank numbers on file', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,''), 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ma.PaymentTypeID = 16
	AND bt.ABANumber IS NULL
	AND bt.AccountNumber IS NULL

UNION ALL

SELECT 'MBR /w Email send method has no deliverable address', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(ba.FirstName,'') + ' ' + COALESCE(ba.LastName,''), 1
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses ba ON (ma.BillingAddressID = ba.AddressID)
	WHERE ma.Active = 1
	AND sm.EmailTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR (ma.PaymentTypeID NOT IN (8,16)))
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > DATEADD(dd,-90,getdate()))
	AND NOT EXISTS
		(
		SELECT *
		FROM Addresses a LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
			WHERE a.CustomerID = ma.CustomerID 
			AND a.Email IS NOT NULL 
			AND a.EmailNoticePurposeMask & 1 = 1
			AND (sa.Active IS NULL OR sa.Active = 1)
		)
	AND NOT EXISTS
		(
		SELECT *
		FROM SubAccounts sa2 
			WHERE sa2.CustomerID = ma.CustomerID 
			AND sa2.Active = 1 
			AND sa2.SendBill = 1 
			AND sa2.Login IS NOT NULL
		)

UNION ALL

SELECT 'File Needed - ' + fc.FileCategory AS Description, 'AccountID ' + CAST(sa.AccountID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,'') AS Message, 1 AS ErrCount
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN FileCategories fc ON (1=1)
	JOIN FileCategoryReqs fcr ON (fc.FileCategoryID = fcr.FileCategoryID)
	LEFT JOIN SubAccountTags sat ON (fcr.MarketTagID = sat.MarketTagID AND sat.AccountID = sa.AccountID AND sat.Active = 1)
	LEFT JOIN Files f ON (fc.FileCategoryID = f.FileCategoryID AND f.AccountID = sa.AccountID AND f.Active = 1)
	LEFT JOIN AlertFileSubAccounts afsa ON (afsa.AccountID = sa.AccountID AND fc.FileCategoryID = afsa.FileCategoryID AND afsa.AlertStateID > 1)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND fcr.FileApplyTypeID = 2
	AND (fcr.GroupID IS NULL OR fcr.GroupID = ma.GroupID)
	AND (fcr.MarketTagID IS NULL OR sat.AccountID IS NOT NULL)
	AND (fcr.AccountTypeID IS NULL OR fcr.AccountTypeID = sa.AccountTypeID)
	AND (fcr.ServiceCategoryID IS NULL OR fcr.ServiceCategoryID = sa.ServiceCategoryID)
	AND f.FileID IS NULL
	AND afsa.AccountID IS NULL

UNION ALL

SELECT 'Product Needed - ' + ip.Title AS Description,'AccountID ' + CAST(sa.AccountID AS VARCHAR(15)) + ' ' + COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,'') AS Message, 1 AS ErrCount
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN InvAccountTypes iat ON (sa.AccountTypeID = iat.AccountTypeID)
	LEFT JOIN InvItems ii ON (iat.InvProductID = ii.InvProductID AND ii.AccountID = sa.AccountID)
	JOIN InvProducts ip ON (iat.InvProductID = ip.InvProductID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND iat.Required = 1
	AND ii.InvItemID IS NULL

UNION ALL

SELECT 'ES Sync ' + es.ExternalSystem, ' CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' Login: ' + COALESCE(sa.Login,'N/A') + ' ' + ess.Message, ess.ErrorCount
FROM ExternalSyncs ess JOIN SubAccounts sa ON (ess.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (ess.ExternalSystemID = es.ExternalSystemID)
	WHERE ess.ErrorCount > 0
	AND ess.Message IS NOT NULL
	AND ess.LastModifyDate BETWEEN @istart AND @istop

UNION ALL

SELECT 'Geocode failure' AS Description, ' CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + COALESCE(as1.Message,'N/A') AS Message, as1.ErrorCount
FROM AddressSyncs as1 JOIN Addresses a ON (as1.AddressID = a.AddressID)
	JOIN MasterAccounts ma ON (a.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND (sa.Active IS NULL OR sa.Active = 1)
	AND a.Lat IS NULL
	AND a.Long IS NULL
	AND as1.ExportStatus IN (2,3)

UNION ALL

SELECT TOP 1000 'Syslog message' AS Description, Data AS Message, COUNT(*) AS ErrCount
FROM SysLogs
	WHERE SyslogSeverityID <= 3
	AND LogDate BETWEEN @istart AND @istop
GROUP BY Data

UNION ALL

SELECT 'Emerald - ' + lm.LogMsg AS Description, l.LogMsg AS Message, COUNT(*) AS ErrCount
FROM AuditLogs l JOIN LogMsgs lm ON (l.LogMsgID = lm.LogMsgID)
	WHERE lm.Severity > 3
	AND LogDate BETWEEN @istart AND @istop
GROUP BY lm.LogMsg, l.LogMsg

UNION ALL

SELECT 'Authentication failure - ' + rlm.RadLogMsg AS Description, 'User: ' + rl.Username AS Message,  COUNT(*) AS ErrCount
FROM RadLogs rl JOIN RadLogMsgs rlm ON (rl.RadLogMsgID = rlm.RadLogMsgID)
	WHERE LogDate BETWEEN @istart AND @istop
	AND rlm.Severity > 0
	AND rl.RadLogMsgID <> 10
	AND NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.Authorized = 1 AND sp.AccountID = rl.AccountID)
GROUP BY rl.Username, rlm.RadLogMsg

UNION ALL

SELECT 'Mail notice - ' + n.Notice AS Description, nl.ErrorMessage AS Message, COUNT(*) AS ErrCount
FROM NoticeLogs nl JOIN Notices n ON (nl.NoticeID = n.NoticeID)
	WHERE nl.LogDate BETWEEN @istart AND @istop
	AND nl.ErrorMessage IS NOT NULL
GROUP BY n.Notice, nl.ErrorMessage

UNION ALL

SELECT 'IP Group - ' + ig.IPGroup AS Description, im.Message, COUNT(*) AS ErrCount
FROM IPRanges ir JOIN IPMessages im ON (ir.IPRangeID = im.IPRangeID)
	JOIN IPGroups ig ON (ir.IPGroupID = ig.IPGroupID)
GROUP BY ig.IPGroup, im.Message

UNION ALL

SELECT 'IP Allocation - ' + ia.IPInvAllocation AS Description, im.Message, COUNT(*) AS ErrCount
FROM IPInvAllocations ia JOIN IPMessages im ON (ia.IPInvAllocationID = im.IPInvAllocationID)
GROUP BY ia.IPInvAllocation, im.Message

UNION ALL

SELECT 'IPAM Inventory - ' + ip.Title AS Description, im.Message, COUNT(*) AS ErrCount
FROM InvItems ii JOIN IPMessages im ON (ii.InvItemID = im.InvItemID)
	JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
GROUP BY ip.Title, im.Message
GO

CREATE PROCEDURE dbo.EventIncidents (@EventID INT, @OnlyOpen TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT i.IncidentID, ma.CustomerID, ma.GroupID, i.IncidentTypeID, a.FirstName, a.LastName, a.Company, is1.IncidentState, e.Resolution, COALESCE(i.Summary,i.Description) AS Description, COALESCE(is1.Style,CASE WHEN is1.StatOpen = 1 THEN 'open' ELSE 'closed' END) AS Class
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	JOIN Incidents i ON (e.EventID = i.EventID AND et.IncidentTypeID = i.IncidentTypeID)
	JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE e.EventID = @EventID
	AND ma.Active IN (1,0)
	AND (@OnlyOpen <> 1 OR (@OnlyOpen = 1 AND is1.StatOpen = 1))
GO

CREATE PROCEDURE dbo.ExportCopy (@SrcExportID INT, @DstExportID INT) AS
SET NOCOUNT ON
INSERT INTO Exports (ExportID,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount,Retries,RetryDelay,FileTokenLocal)
SELECT @DstExportID,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount,Retries,RetryDelay,FileTokenLocal
FROM Exports
	WHERE ExportID = @SrcExportID

INSERT INTO ExportColumns (ExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType)
SELECT @DstExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType
FROM ExportColumns
	WHERE ExportID = @SrcExportID

INSERT INTO CCImportColumns (ExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType)
SELECT @DstExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType
FROM CCImportColumns
	WHERE ExportID = @SrcExportID
GO

CREATE PROCEDURE dbo.ExternalSyncDelete (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(768), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN
DELETE FROM ExternalSyncs WHERE ExternalSyncID = @ExternalSyncID
END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ExternalSyncUpdate (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(768), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN

IF (@TransTypeID = 1024)
BEGIN
UPDATE	ExternalSyncs SET ErrorCount = 0, Message = NULL, Login = COALESCE(sa.Login,sa.Email), Password = sa.Password, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, 
	CreateDate = getdate(), LastModifyDate = getdate(), LastUpdate = getdate(), Active = 1, Created = 1, ProcTransID = @Data
FROM SubAccounts sa JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID)
	WHERE es.ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2048)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate()
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 4096)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 0, Created = 0
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 8192)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Login = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 65536)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Password = sa.Password
FROM ExternalSyncs es JOIN SubAccounts sa ON (es.AccountID = sa.AccountID)
	WHERE es.ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 131072)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 262144)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 0
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 524288)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux1 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 1048576)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux2 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2097152)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux3 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 4194304)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux4 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 8388608)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux5 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 16777216)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux6 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 33554432)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux7 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 67108864)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux8 = CAST(@Data AS VARCHAR(768))
	WHERE ExternalSyncID = @ExternalSyncID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ExternalTransVoid (@CustomerID INT) AS
SET NOCOUNT ON
UPDATE ExternalTrans SET TransStateID = 9 
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
GO

CREATE PROCEDURE dbo.ExternalTransCCAdd (@CustomerID INT, @BatchProcessorID INT, @BatchID INT, @InvoiceID INT, @AuthOnly INT, @Amount NUMERIC(18,4), @LastModifyUser VARCHAR(64), @Token VARCHAR(128), @AccountNumber VARCHAR(128), @AccountExpire DATETIME, @AuthName VARCHAR(50), @AuthAddress VARCHAR(64), @AuthStateID INT, @AuthZip VARCHAR(12), @AuthSecurityCode VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,Token,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,LastRebatchTry)
VALUES(@CustomerID,@BatchProcessorID,@BatchID,@InvoiceID,0,CASE WHEN @AuthOnly = 1 THEN 16 ELSE 64 END,getdate(),@Amount,getdate(),@LastModifyUser,@Token,@AccountNumber,@AccountExpire,@AuthName,@AuthAddress,@AuthStateID,@AuthZip,@AuthSecurityCode,getdate())

UPDATE ExternalTrans SET TransStateID = 9 
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1
GO

CREATE PROCEDURE dbo.ExternalTransEFTAdd (@CustomerID INT, @BatchProcessorID INT, @BatchID INT, @InvoiceID INT, @AuthOnly INT, @Amount NUMERIC(18,4), @LastModifyUser VARCHAR(64), @AccountNumber VARCHAR(64), @BankNumber VARCHAR(64), @AuthName VARCHAR(50), @BankName VARCHAR(64), @BankPhone VARCHAR(20), @BankTransType VARCHAR(16), @SSN VARCHAR(64), @DLNumber VARCHAR(64), @DLState VARCHAR(40), @BirthDate DATETIME) AS
SET NOCOUNT ON
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,BankNumber,AuthName,BankName,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry)
VALUES(@CustomerID,@BatchProcessorID,@BatchID,@InvoiceID,0,CASE WHEN @AuthOnly = 1 THEN 16 ELSE 64 END,getdate(),@Amount,getdate(),@LastModifyUser,@AccountNumber,@BankNumber,@AuthName,@BankName,@BankPhone,@BankTransType,@SSN,@DLNumber,@DLState,@BirthDate,getdate())

UPDATE ExternalTrans SET TransStateID = 9
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1
GO

CREATE PROCEDURE dbo.ExternalTransImport (@CustomerID INT, @partid INT = NULL, @parts INT = NULL) AS
SET NOCOUNT ON
DECLARE @POSAuto INT
UPDATE IEALocks SET RefCount = RefCount + 1, LastModifyDate = getdate() WHERE IEALockID = 1
CREATE TABLE #etisum (CustomerID INT PRIMARY KEY, Amount NUMERIC(18,4), InvoiceID INT, BatchProcessorID INT)
CREATE TABLE #etiretry (ExternalTransID INT PRIMARY KEY)
CREATE TABLE #eticrt (CustomerID INT PRIMARY KEY, RebatchTries SMALLINT)
SELECT @POSAuto = COALESCE(NumValue,0) FROM Configs WHERE ConfigID = 714

IF (@CustomerID IS NOT NULL)
BEGIN
UPDATE ExternalTrans SET TransStateID = 9 WHERE ExternalTransID IN 
	(
	SELECT et.ExternalTransID 
	FROM ExternalTrans et JOIN CreditCards cc ON (et.CustomerID = cc.CustomerID)
		JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
		JOIN Exports e ON (bp.ExportID = e.ExportID)
		WHERE et.TransStateID = 3 
		AND et.TransTypeID IN (16,32,64)
		AND ((e.ExportType IN (1,5) AND cc.Token IS NULL AND (et.AccountNumber <> cc.CardNumber OR et.AccountExpire <> cc.ExpirationDate OR et.AuthName <> cc.CardHolder OR et.AuthAddress <> cc.BillToAddress1))
			OR (e.ExportType = 10 AND (et.Token <> cc.Token OR et.BatchProcessorID <> cc.BatchProcessorID)))
		AND et.ProcDate < cc.LastModifyDate
		AND et.CustomerID = @CustomerID
	UNION ALL
	SELECT et.ExternalTransID
	FROM ExternalTrans et JOIN BankTrans bt ON (et.CustomerID = bt.CustomerID)
		JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
		JOIN Exports e ON (bp.ExportID = e.ExportID)
		WHERE et.TransStateID = 3
		AND et.TransTypeID IN (16,32,64)
		AND e.ExportType IN (4,6)
		AND et.ProcDate < bt.LastModifyDate
		AND (et.AccountNumber <> bt.AccountNumber OR et.BankNumber <> bt.ABANumber OR et.BankTransType <> bt.TransType)
		AND et.CustomerID = @CustomerID
	)

INSERT INTO #etiretry (ExternalTransID)
SELECT et.ExternalTransID
FROM ExternalTrans et JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	WHERE et.LastModifyDate <= getdate()
	AND et.TransStateID IN (3,7)
	AND et.AutoBill = 1
	AND (et.TransStateID = 7 OR
		(
		et.TransStateID = 3
		AND DATEADD(dd,bp.RebatchInterval,et.LastRebatchTry) <= getdate()
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0
		))
	AND et.CustomerID = @CustomerID

IF (@@ROWCOUNT > 0)
	BEGIN
	UPDATE ExternalTrans SET TransStateID = 9 WHERE TransStateID IN (3,7) AND ExternalTransID IN (SELECT ExternalTransID FROM #etiretry)

	INSERT INTO #eticrt (CustomerID,RebatchTries)
	SELECT et.CustomerID, MAX(COALESCE(et.RebatchTries,0))
	FROM ExternalTrans et JOIN #etiretry er ON (et.ExternalTransID = er.ExternalTransID)
	GROUP BY et.CustomerID
	END


INSERT INTO #etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE(MIN(aet.Amount),0) - SUM(CASE WHEN DATEADD(dd,-bc.TBillDays,aii.StartDate) > getdate() THEN i.ChargeAmount ELSE 0 END)
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 714 AND cgd.GroupID = ma.GroupID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(Amount) AS Amount
		FROM ExternalTrans
			WHERE CustomerID = @CustomerID
			AND (NOT(TransTypeID IN (16,32,64) AND TransStateID = 3 AND AutoBill = 0)) 
			AND ((TransTypeID IN (16,32,64)	AND TransStateID IN (0,1,2,3,7,10)) OR (TransTypeID = 16 AND TransStateID = 4))
		GROUP BY CustomerID
		) aet ON (ma.CustomerID = aet.CustomerID)
	LEFT JOIN
		(
		SELECT InvoiceID, MIN(StartDate) AS StartDate
		FROM InvoiceItems
			WHERE ItemType = 3
			AND Amount > 0
		GROUP BY InvoiceID
		) aii ON (i.InvoiceID = aii.InvoiceID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Processed = 1
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND ((COALESCE(cgd.NumValue,@POSAuto) IN (1,2) AND i.InvoiceTypeID = 91 AND i.PayPlanID IS NULL) OR (i.InvoiceTypeID <> 91))
	AND i.InvoiceTypeID NOT IN (92,99)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate())
	AND ma.CustomerID = @CustomerID
GROUP BY ma.CustomerID
HAVING MAX(CASE WHEN i.InvoiceTypeID <> 91 OR COALESCE(cgd.NumValue,@POSAuto) = 1 OR (COALESCE(cgd.NumValue,@POSAuto) = 2 AND i.CreateDate <= DATEADD(dd,-33,getdate())) THEN 1 ELSE 0 END) = 1

INSERT INTO #etisum (CustomerID,InvoiceID,Amount)
SELECT ma.CustomerID, i.InvoiceID, CASE WHEN ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount)) > i.ChargeAmount THEN i.ChargeAmount - i.PaidAmount
ELSE ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount)) - i.PaidAmount END AS Amount
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE ma.Active = 1
	AND ma.PendingBalance > 0
	AND ma.CustomerID = @CustomerID
	AND pp.PaymentTypeID IN (8,16)
	AND pp.PaymentCount > 0
	AND i.InvoiceTypeID IN (91,92)
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.PaidAmount < i.ChargeAmount
	AND COALESCE(i.PayPlanStartDate,i.CreateDate) < getdate()
	AND i.PaidAmount < ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount))
	AND NOT EXISTS (SELECT * FROM ExternalTrans et WHERE et.CustomerID = ma.CustomerID AND (et.InvoiceID = i.InvoiceID OR et.AutoBill = 0) AND et.TransTypeID IN (32,64) AND et.TransStateID <= 3)
	AND NOT EXISTS (SELECT * FROM #etisum WHERE CustomerID = @CustomerID)
END ELSE BEGIN
UPDATE ExternalTrans SET TransStateID = 9 WHERE ExternalTransID IN 
	(
	SELECT et.ExternalTransID 
	FROM ExternalTrans et JOIN CreditCards cc ON (et.CustomerID = cc.CustomerID)
		JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
		JOIN Exports e ON (bp.ExportID = e.ExportID)
		WHERE et.TransStateID = 3
		AND et.TransTypeID IN (16,32,64)
		AND ((e.ExportType IN (1,5) AND cc.Token IS NULL AND (et.AccountNumber <> cc.CardNumber OR et.AccountExpire <> cc.ExpirationDate OR et.AuthName <> cc.CardHolder OR et.AuthAddress <> cc.BillToAddress1))
			OR (e.ExportType = 10 AND (et.Token <> cc.Token OR et.BatchProcessorID <> cc.BatchProcessorID)))
		AND et.ProcDate < cc.LastModifyDate
		AND (@partid IS NULL OR et.CustomerID % @parts = @partid - 1)
	UNION ALL
	SELECT et.ExternalTransID 
	FROM ExternalTrans et JOIN BankTrans bt ON (et.CustomerID = bt.CustomerID)
		JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
		JOIN Exports e ON (bp.ExportID = e.ExportID)
		WHERE et.TransStateID = 3
		AND et.TransTypeID IN (16,32,64)
		AND e.ExportType IN (4,6)
		AND et.ProcDate < bt.LastModifyDate
		AND (et.AccountNumber <> bt.AccountNumber OR et.BankNumber <> bt.ABANumber OR et.BankTransType <> bt.TransType)
		AND (@partid IS NULL OR et.CustomerID % @parts = @partid - 1)
	)

INSERT INTO #etiretry (ExternalTransID)
SELECT et.ExternalTransID
FROM ExternalTrans et JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	WHERE et.LastModifyDate <= getdate()
	AND et.TransStateID IN (3,7)
	AND et.AutoBill = 1
	AND (et.TransStateID = 7 OR
		(
		et.TransStateID = 3
		AND DATEADD(dd,bp.RebatchInterval,et.LastRebatchTry) <= getdate()
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0
		))
	AND (@partid IS NULL OR et.CustomerID % @parts = @partid - 1)

IF (@@ROWCOUNT > 0)
	BEGIN
	UPDATE ExternalTrans SET TransStateID = 9 WHERE TransStateID IN (3,7) AND ExternalTransID IN (SELECT ExternalTransID FROM #etiretry)

	INSERT INTO #eticrt (CustomerID,RebatchTries)
	SELECT et.CustomerID, MAX(COALESCE(et.RebatchTries,0))
	FROM ExternalTrans et JOIN #etiretry er ON (et.ExternalTransID = er.ExternalTransID)
	GROUP BY et.CustomerID
	END


INSERT INTO #etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE(MIN(aet.Amount),0) - SUM(CASE WHEN DATEADD(dd,-bc.TBillDays,aii.StartDate) > getdate() THEN i.ChargeAmount ELSE 0 END)
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 714 AND cgd.GroupID = ma.GroupID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(Amount) AS Amount
		FROM ExternalTrans
			WHERE (NOT(TransTypeID IN (16,32,64) AND TransStateID = 3 AND AutoBill = 0)) 
			AND ((TransTypeID IN (16,32,64)	AND TransStateID IN (0,1,2,3,7,10)) OR (TransTypeID = 16 AND TransStateID = 4))
		GROUP BY CustomerID
		) aet ON (ma.CustomerID = aet.CustomerID)
	LEFT JOIN
		(
		SELECT InvoiceID, MIN(StartDate) AS StartDate
		FROM InvoiceItems
			WHERE ItemType = 3
			AND Amount > 0
		GROUP BY InvoiceID
		) aii ON (i.InvoiceID = aii.InvoiceID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Processed = 1
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND ((COALESCE(cgd.NumValue,@POSAuto) IN (1,2) AND i.InvoiceTypeID = 91 AND i.PayPlanID IS NULL) OR (i.InvoiceTypeID <> 91))
	AND i.InvoiceTypeID NOT IN (92,99)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate())
	AND (@partid IS NULL OR ma.CustomerID % @parts = @partid - 1)
GROUP BY ma.CustomerID
HAVING MAX(CASE WHEN i.InvoiceTypeID <> 91 OR COALESCE(cgd.NumValue,@POSAuto) = 1 OR (COALESCE(cgd.NumValue,@POSAuto) = 2 AND i.CreateDate <= DATEADD(dd,-33,getdate())) THEN 1 ELSE 0 END) = 1

INSERT INTO #etisum (CustomerID,InvoiceID,Amount)
SELECT ma.CustomerID, i.InvoiceID, CASE WHEN ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount)) > i.ChargeAmount THEN i.ChargeAmount - i.PaidAmount
ELSE ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount)) - i.PaidAmount END AS Amount
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE ma.Active = 1
	AND ma.PendingBalance > 0
	AND pp.PaymentTypeID IN (8,16)
	AND pp.PaymentCount > 0
	AND i.InvoiceTypeID IN (91,92)
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.PaidAmount < i.ChargeAmount
	AND COALESCE(i.PayPlanStartDate,i.CreateDate) < getdate()
	AND i.PaidAmount < ((1 + COALESCE(DATEDIFF(mm,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalMonths > 0 THEN pp.IntervalMonths END,DATEDIFF(dd,COALESCE(i.PayPlanStartDate,i.CreateDate),getdate()) / CASE WHEN pp.IntervalDays > 0 THEN pp.IntervalDays END,0)) * (i.ChargeAmount / pp.PaymentCount))
	AND NOT EXISTS (SELECT * FROM ExternalTrans et WHERE et.CustomerID = ma.CustomerID AND (et.InvoiceID = i.InvoiceID OR et.AutoBill = 0) AND et.TransTypeID IN (32,64) AND et.TransStateID <= 3)
	AND NOT EXISTS (SELECT * FROM #etisum eti WHERE eti.CustomerID = ma.CustomerID)
	AND (@partid IS NULL OR ma.CustomerID % @parts = @partid - 1)
END

UPDATE #etisum SET Amount = ROUND(Amount,2) WHERE Amount <> ROUND(Amount,2)

DELETE FROM #etisum WHERE Amount <= 0

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON ((bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID) AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.BatchProcessorID = cc.BatchProcessorID
	AND ma.Active = 1
	AND bp.Active = 1
	AND e.ExportType IN (10)
	AND cc.Token IS NOT NULL
	AND ((eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) OR (eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN BatchProcessors bp ON (bp.GroupID = ma.GroupID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5) 
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ((eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) OR (eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON (g.OrganizationID = bp.OrganizationID AND bp.GroupID IS NULL)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5) 
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ((eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) OR (eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN BatchProcessors bp ON (bp.OrganizationID IS NULL)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5) 
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ((eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) OR (eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN BatchProcessors bp ON (bp.GroupID = ma.GroupID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5,4,6)
	AND ma.Active = 1
	AND ((bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) 
		OR (bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 16)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 16))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON (g.OrganizationID = bp.OrganizationID AND bp.GroupID IS NULL)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5,4,6)
	AND ma.Active = 1
	AND ((bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) 
		OR (bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 16)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 16))
	AND eti.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN BatchProcessors bp ON (bp.OrganizationID IS NULL)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	LEFT JOIN Invoices i ON (eti.InvoiceID = i.InvoiceID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE bp.Active = 1
	AND e.ExportType IN (1,5,4,6)
	AND ma.Active = 1
	AND ((bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 8) 
		OR (bp.CardTypes & 256 = 256 AND e.ExportType IN (1,5) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 8)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NULL AND ma.PaymentTypeID = 16)
		OR (e.ExportType IN (4,6) AND eti.InvoiceID IS NOT NULL AND pp.PaymentTypeID = 16))
	AND eti.BatchProcessorID IS NULL

DELETE FROM #etisum WHERE BatchProcessorID IS NULL

IF (@CustomerID IS NULL)
BEGIN
DELETE FROM #etisum WHERE CustomerID IN (SELECT et.CustomerID
FROM #etisum i JOIN ExternalTrans et ON (i.CustomerID = et.CustomerID)
	WHERE et.TransStateID = 9
	AND et.LastModifyDate > DATEADD(hh,-3,getdate())
	AND et.Amount = i.Amount
	AND NOT EXISTS (SELECT * FROM #eticrt crt WHERE crt.CustomerID = i.CustomerID))
END

INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,Response,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,Token,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthStateID,AuthSecurityCode,LastRebatchTry,RebatchTries)
SELECT 1, ma.CustomerID, bp.BatchProcessorID, NULL, eti.InvoiceID, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 'Card expired' ELSE NULL END, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 3 WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, getdate(), eti.Amount, getdate(), 'CC Auto Bill',cc.Token,cc.CardNumber,cc.ExpirationDate,cc.CardHolder,cc.BillToAddress1,cc.BillToZip,cc.BillToStateID,cc.SecurityCode,getdate(),crt.RebatchTries + 1
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN BatchProcessors bp ON (eti.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN #eticrt crt ON (ma.CustomerID = crt.CustomerID)
	WHERE ma.Active = 1
	AND ((e.ExportType IN (1,5) AND cc.CardNumber IS NOT NULL AND cc.Token IS NULL)
		OR (e.ExportType = 10 AND cc.Token IS NOT NULL AND cc.BatchProcessorID = eti.BatchProcessorID))
	AND ma.PendingBalance >= eti.Amount

INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AuthName,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry,RebatchTries)
SELECT 1, ma.CustomerID, bp.BatchProcessorID, NULL, eti.InvoiceID, CASE WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, getdate(), eti.Amount, getdate(), 'ACH Auto Bill', bt.AccountNumber, bt.AuthName, bt.BankName, bt.ABANumber, bt.BankPhone, bt.TransType, bt.SSN, bt.DLNumber, bt.DLState, bt.BirthDate,getdate(),crt.RebatchTries + 1
FROM MasterAccounts ma JOIN #etisum eti ON (ma.CustomerID = eti.CustomerID)
	JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	JOIN BatchProcessors bp ON (eti.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN #eticrt crt ON (ma.CustomerID = crt.CustomerID)
	WHERE ma.Active = 1
	AND bt.ABANumber IS NOT NULL
	AND bt.AccountNumber IS NOT NULL
	AND e.ExportType IN (4,6)
	AND ma.PendingBalance >= eti.Amount
GO

CREATE PROCEDURE dbo.FCCBLAccountTypesGet (@OrganizationID INT) AS
SET NOCOUNT ON
SELECT at1.AccountTypeID, at1.AccountType, CASE WHEN blat.AccountTypeID IS NULL THEN 1 ELSE 0 END AS IsNew, CASE WHEN fat.RegFCC477TechID IS NOT NULL THEN 1 ELSE 0 END AS IsBB, blat.RegFCCBLProviderID, blat.RegFCCBLContractID, blat.RegFCCBLChargeID, COALESCE(blat.TypicalDownMbps,fat.DownMbps) AS TypicalDownMbps, COALESCE(blat.TypicalUpMbps,fat.UpMbps) AS TypicalUpMbps, blat.TypicalLatency, 
blat.IntroRateMonths, blat.IntroRateCost, COALESCE(blat.TaxAmount, CASE WHEN at1.TaxGroupID IS NULL THEN 0 END) AS TaxAmount, 
COALESCE(blat.MonthlyDataLimit,CASE WHEN at1.DataLeftRenewal = 1 AND at1.DataLeft > 0 THEN at1.DataLeft / 1000000000 END) AS MonthlyDataLimit, blat.AdditionalDataCost, blat.AdditionalDataIncrement, 
CASE WHEN SortOrder < 0 THEN 'hidden' WHEN blat.AccountTypeID IS NULL THEN 'changed' END AS Class

FROM AccountTypes at1 LEFT JOIN RegFCCBLAccountTypes blat ON (at1.AccountTypeID = blat.AccountTypeID AND blat.OrganizationID = @OrganizationID)
	LEFT JOIN RegFCC477AccountTypes fat ON (at1.AccountTypeID = fat.AccountTypeID)
	WHERE (blat.AccountTypeID IS NOT NULL 
		OR (at1.SortOrder >= 0 AND (at1.GroupID IS NULL OR EXISTS (SELECT * FROM Groups g WHERE at1.GroupID = g.GroupID AND g.OrganizationID = @OrganizationID))))
ORDER BY CASE WHEN blat.AccountTypeID IS NULL THEN 0 ELSE 1 END ASC, CASE WHEN at1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, at1.SortOrder, at1.AccountType
GO

CREATE PROCEDURE dbo.FCCBLStatus (@OrganizationID INT) AS
SET NOCOUNT ON

SELECT 'Service type ' + at1.AccountType + ' missing broadband label configuration' AS Description
FROM AccountTypes at1
	WHERE at1.SortOrder >= 0
	AND NOT EXISTS (SELECT * FROM RegFCCBLAccountTypes blat WHERE blat.AccountTypeID = at1.AccountTypeID AND blat.OrganizationID = @OrganizationID)
	AND (at1.GroupID IS NULL OR EXISTS (SELECT * FROM Groups g WHERE at1.GroupID = g.GroupID AND g.OrganizationID = @OrganizationID))

UNION ALL

SELECT 'Introductory rate ' + CAST(blat.IntroRateCost AS VARCHAR) + ' exceeds normal cost of ' + CAST(at1.Cost AS VARCHAR) + ' for service type ' + at1.AccountType
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND blat.IntroRateMonths > 0 
	AND blat.IntroRateCost > at1.Cost

UNION ALL

SELECT 'Service type ' + at1.AccountType + ' is configured as not broadband while marked as broadband within FCC - Services'
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	JOIN RegFCC477AccountTypes fat ON (blat.AccountTypeID = fat.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND at1.SortOrder >= 0
	AND fat.RegFCC477TechID IS NOT NULL
	AND blat.RegFCCBLProviderID IS NULL

UNION ALL

SELECT 'Service type ' + at1.AccountType + ' is misconfigured, make sure typical Up/Down/Lag, intro months, tax, additional cost, monthly limit and increment are positive values'
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND at1.SortOrder >= 0
	AND blat.RegFCCBLProviderID IS NOT NULL
	AND (blat.TypicalDownMbps <= 0 OR blat.TypicalUpMbps <= 0 OR blat.TypicalLatency <= 0 OR blat.TaxAmount < 0 OR blat.IntroRateCost < 0 OR blat.IntroRateMonths <= 0 OR blat.AdditionalDataIncrement <= 0 OR blat.AdditionalDataCost <= 0 OR blat.MonthlyDataLimit <= 0)

UNION ALL

SELECT 'Service type' + at1.AccountType + ' configured with unlimited monthly data however an additional data cost is specified'
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND at1.SortOrder >= 0
	AND MonthlyDataLimit IS NULL
	AND blat.AdditionalDataCost > 0

UNION ALL

SELECT 'Service type ' + at1.AccountType + ' typical down/up bandwidth varies significantly from advertised up/down bandwidth under FCC - Services down:' + CAST(blat.TypicalDownMbps AS VARCHAR) + '/' + CAST(fat.DownMbps AS VARCHAR) + ' up:' + CAST(blat.TypicalUpMbps AS VARCHAR) + '/' + CAST(fat.UpMbps AS VARCHAR)
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	JOIN RegFCC477AccountTypes fat ON (blat.AccountTypeID = fat.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND at1.SortOrder >= 0
	AND blat.RegFCCBLProviderID IS NOT NULL
	AND blat.TypicalDownMbps > 0
	AND fat.DownMbps > 0
	AND blat.TypicalUpMbps > 0
	AND fat.UpMbps > 0
	AND ((blat.TypicalDownMbps / 2 > fat.DownMbps OR blat.TypicalDownMbps * 2 < fat.DownMbps) 
		OR (blat.TypicalUpMbps / 2 > fat.UpMbps OR blat.TypicalUpMbps * 2 < fat.UpMbps))
GO

CREATE PROCEDURE dbo.FCCBLReport (@OrganizationID INT, @AccountTypeID INT) AS
SET NOCOUNT ON
SELECT blat.AccountTypeID, blp.RegFCCBLProvider AS Provider, at1.AccountType, at1.StringID AS at1StringID,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN blat.IntroRateCost ELSE at1.Cost END AS MonthCost, 
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN 'Yes' ELSE 'No' END AS MonthCostIsIntro,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN blat.IntroRateMonths END AS IntroMonths,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN at1.Cost END AS IntroAfterCost,
blc.ContractMonths, blc.ContractTermsURL, 
blc.EarlyTerminationFee, blat.TaxAmount,
blp.BundleDescription, blp.BundleStringID, blp.BundleDiscountsURL,
blat.TypicalDownMbps, blat.TypicalUpMbps, blat.TypicalLatency,
blat.MonthlyDataLimit, blat.AdditionalDataIncrement,
CASE WHEN blat.AdditionalDataIncrement > 1 THEN blat.AdditionalDataCost * blat.AdditionalDataIncrement ELSE blat.AdditionalDataCost END AS AdditionalDataCost, 
blp.DataAllowancePolicyURL,
blp.NetworkManagementPolicyURL, blp.PrivacyPolicyURL,
blp.CustomerSupportPhone, blp.CustomerSupportURL,
'F' + blp.RegistrationNumber + RIGHT('000000000000000' + 'Z' + CAST(blat.OrganizationID AS VARCHAR) + 'A' + CAST(blat.AccountTypeID AS VARCHAR),15) AS UPI
FROM RegFCCBLAccountTypes blat JOIN RegFCCBLProviders blp ON (blat.RegFCCBLProviderID = blp.RegFCCBLProviderID)
	LEFT JOIN RegFCCBLContracts blc ON (blat.RegFCCBLContractID = blc.RegFCCBLContractID)
	JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct1 ON (at1.ChargeTypeID = ct1.ChargeTypeID)
	LEFT JOIN ChargeTypes ct2 ON (at1.SecChargeTypeID = ct2.ChargeTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND blat.AccountTypeID = @AccountTypeID
GO

CREATE PROCEDURE dbo.FCCBLReportCharges (@OrganizationID INT, @AccountTypeID INT) AS
SET NOCOUNT ON
DECLARE @RegFCCBLChargeID INT, @ChargeTypeID INT, @SecChargeTypeID INT, @Cost NUMERIC(18,4)

SELECT @RegFCCBLChargeID = blat.RegFCCBLChargeID, @ChargeTypeID = at1.ChargeTypeID, @SecChargeTypeID = at1.SecChargeTypeID, @Cost = at1.Cost
FROM RegFCCBLAccountTypes blat JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID 
	AND blat.AccountTypeID = @AccountTypeID


SELECT 0 AS Recurring, ChargeType AS Description, StringID, Amount
FROM ChargeTypes
	WHERE (ChargeTypeID = @ChargeTypeID OR ChargeTypeID = @SecChargeTypeID)

UNION

SELECT blci.Recurring, COALESCE(blci.RegFCCBLChargeItem,d.Discount,at1.AccountType,ct.ChargeType) AS Description, 
CASE WHEN blci.RegFCCBLChargeItem IS NOT NULL THEN blci.StringID WHEN at1.AccountType IS NOT NULL THEN at1.StringID WHEN ct.ChargeType IS NOT NULL THEN ct.StringID WHEN d.DiscountID IS NOT NULL THEN d.StringID END AS StringID,
COALESCE(blci.Cost,CASE WHEN d.AmountType = 2 THEN ROUND(d.Amount / 100 * @Cost,2) ELSE d.Amount END,at1.Cost,ct.Amount) AS Amount
FROM RegFCCBLChargeItems blci LEFT JOIN ChargeTypes ct ON (blci.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN AccountTypes at1 ON (blci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Discounts d ON (blci.DiscountID = d.DiscountID)
	WHERE blci.RegFCCBLChargeID = @RegFCCBLChargeID
ORDER BY 1 DESC, 2
GO

CREATE PROCEDURE dbo.FCCBLReportCSV (@OrganizationID INT, @RegFCCBLProviderID INT) AS
SET NOCOUNT ON
DECLARE @RegFCCBLChargeID INT, @AccountTypeID INT, @Cost NUMERIC(18,4), @mdesc VARCHAR(4000), @mcost VARCHAR(4000), @odesc VARCHAR(4000), @ocost VARCHAR(4000)
DECLARE charges CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR SELECT DISTINCT RegFCCBLChargeID, AccountTypeID FROM RegFCCBLAccountTypes WHERE RegFCCBLChargeID IS NOT NULL
CREATE TABLE #blrm (RegFCCBLChargeID INT, AccountTypeID INT, Description VARCHAR(4000), Cost VARCHAR(4000))
CREATE TABLE #blro (RegFCCBLChargeID INT, AccountTypeID INT, Description VARCHAR(4000), Cost VARCHAR(4000))

OPEN charges
goto onefetch
WHILE (@@FETCH_STATUS = 0)
BEGIN
SELECT @mdesc = '', @mcost = '', @odesc = '', @ocost = '', @Cost = Cost FROM AccountTypes WHERE AccountTypeID = @AccountTypeID

SELECT	@mdesc = @mdesc + CASE WHEN blci.Recurring = 1 THEN COALESCE(blci.RegFCCBLChargeItem,d.Discount,at1.AccountType,ct.ChargeType) + '; ' ELSE '' END,
	@odesc = @odesc + CASE WHEN blci.Recurring = 0 THEN COALESCE(blci.RegFCCBLChargeItem,d.Discount,at1.AccountType,ct.ChargeType) + '; ' ELSE '' END,
	@mcost = @mcost + CASE WHEN blci.Recurring = 1 THEN CAST(CAST(COALESCE(blci.Cost,CASE WHEN d.AmountType = 2 THEN ROUND(d.Amount / 100 * @Cost,2) ELSE d.Amount END,at1.Cost,ct.Amount) AS NUMERIC(18,2)) AS VARCHAR) + '; ' ELSE '' END,
	@ocost = @ocost + CASE WHEN blci.Recurring = 0 THEN CAST(CAST(COALESCE(blci.Cost,CASE WHEN d.AmountType = 2 THEN ROUND(d.Amount / 100 * @Cost,2) ELSE d.Amount END,at1.Cost,ct.Amount) AS NUMERIC(18,2)) AS VARCHAR) + '; ' ELSE '' END

FROM RegFCCBLChargeItems blci LEFT JOIN ChargeTypes ct ON (blci.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN AccountTypes at1 ON (blci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Discounts d ON (blci.DiscountID = d.DiscountID)
	WHERE blci.RegFCCBLChargeID = @RegFCCBLChargeID

INSERT INTO #blrm (RegFCCBLChargeID,AccountTypeID,Description,Cost) VALUES(@RegFCCBLChargeID,@AccountTypeID,@mdesc,@mcost)
INSERT INTO #blro (RegFCCBLChargeID,AccountTypeID,Description,Cost) VALUES(@RegFCCBLChargeID,@AccountTypeID,@odesc,@ocost)

onefetch:
FETCH NEXT FROM charges INTO @RegFCCBLChargeID, @AccountTypeID
END
CLOSE charges
DEALLOCATE charges


SELECT blp.RegFCCBLProvider AS provider_name, 
at1.AccountType AS service_plan_name, 
NULL AS tier_plan_name, 
'Fixed' AS connection_type, 
'F' + blp.RegistrationNumber + RIGHT('000000000000000' + 'Z' + CAST(blat.OrganizationID AS VARCHAR) + 'A' + CAST(blat.AccountTypeID AS VARCHAR),15) AS unique_plan_id,
CAST(at1.Cost AS NUMERIC(18,2)) AS monthly_price,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN 'Yes' ELSE 'No' END AS intro_rate,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN CAST(blat.IntroRateCost AS NUMERIC(18,2)) END AS intro_rate_price,
CASE WHEN blat.IntroRateMonths > 0 AND blat.IntroRateCost >= 0 THEN IntroRateMonths END AS intro_rate_time,
CASE WHEN blc.ContractRequired = 1 THEN 'Yes' ELSE 'No' END AS contract_req,
blc.ContractMonths AS contract_time,
blc.ContractTermsURL AS contract_terms_url,
CAST(blc.EarlyTerminationFee AS NUMERIC(18,2)) AS early_termination_fee,

CASE WHEN ct1.Amount IS NOT NULL THEN ct1.ChargeType + '; ' ELSE '' END +
CASE WHEN ct2.Amount IS NOT NULL THEN ct2.ChargeType + '; ' ELSE '' END + 
COALESCE(blro.Description,'') AS single_purchase_fee_descr,

CASE WHEN ct1.Amount IS NOT NULL THEN CAST(CAST(ct1.Amount AS NUMERIC(18,2)) AS VARCHAR) + '; ' ELSE '' END +
CASE WHEN ct2.Amount IS NOT NULL THEN CAST(CAST(ct1.Amount AS NUMERIC(18,2)) AS VARCHAR) + '; ' ELSE '' END + 
COALESCE(blro.Cost,'') AS single_purchase_fees,

blrm.Description AS monthly_provider_fee_descr,
blrm.Cost AS monthly_provider_fee,
CASE WHEN blat.TaxAmount IS NULL THEN 'Varies' ELSE CAST(CAST(blat.TaxAmount AS NUMERIC(18,2)) AS VARCHAR) END AS tax,
blp.BundleDiscountsURL AS bundle_discounts_url,
CAST(blat.TypicalDownMbps AS NUMERIC(18,2)) AS typical_download_speed,
CAST(blat.TypicalUpMbps AS NUMERIC(18,2)) AS typical_upload_speed,
blat.TypicalLatency AS typical_latency,
blat.MonthlyDataLimit AS monthly_data_allow,
blat.AdditionalDataCost AS over_usage_data_price,
blat.AdditionalDataIncrement AS additional_data_increment,
blp.DataAllowancePolicyURL AS data_allowance_policy_url,
blp.NetworkManagementPolicyURL AS network_management_policy_url,
blp.PrivacyPolicyURL AS privacy_policy_url,
blp.CustomerSupportPhone AS customer_support_phone,
blp.CustomerSupportURL AS customer_support_web

FROM RegFCCBLAccountTypes blat JOIN RegFCCBLProviders blp ON (blat.RegFCCBLProviderID = blp.RegFCCBLProviderID)
	LEFT JOIN RegFCCBLContracts blc ON (blat.RegFCCBLContractID = blc.RegFCCBLContractID)
	JOIN AccountTypes at1 ON (blat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct1 ON (at1.ChargeTypeID = ct1.ChargeTypeID)
	LEFT JOIN ChargeTypes ct2 ON (at1.SecChargeTypeID = ct2.ChargeTypeID)
	LEFT JOIN #blrm blrm ON (blat.RegFCCBLChargeID = blrm.RegFCCBLChargeID AND blat.AccountTypeID = blrm.AccountTypeID)
	LEFT JOIN #blro blro ON (blat.RegFCCBLChargeID = blro.RegFCCBLChargeID AND blat.AccountTypeID = blro.AccountTypeID)
	WHERE blat.OrganizationID = @OrganizationID
	AND at1.SortOrder >= 0
	AND (at1.StartDate IS NULL OR at1.StartDate <= getdate())
	AND (at1.EndDate IS NULL OR at1.EndDate > getdate())
	AND (@RegFCCBLProviderID IS NULL OR blat.RegFCCBLProviderID = @RegFCCBLProviderID)
GO

CREATE PROCEDURE dbo.FCC477CountyReport AS
SET NOCOUNT ON
SELECT s.State, adcf.Data AS CountyFIPS, rft.RegFCC477Tech AS Technology, rat.DownMbps AS Download, rat.UpMbps AS Upload, COUNT(*) AS Connections, SUM(CASE WHEN rat.Residential = 1 THEN 1 ELSE 0 END) AS Residential, SUM(CASE WHEN rat.Residential = 0 THEN 1 ELSE 0 END) AS Business
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN States s ON (a.StateID = s.StateID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	JOIN AddressData adct ON (a.AddressID = adct.AddressID AND adct.AddressDataTypeID = 1)
	JOIN AddressData adcf ON (a.AddressID = adcf.AddressID AND adcf.AddressDataTypeID = 2)
	JOIN RegFCC477Techs rft ON (rat.RegFCC477TechID = rft.RegFCC477TechID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND a.CountryID = 840
	AND rat.RegFCC477TechID IS NOT NULL
	AND (rat.DownMbps > 0.200 OR rat.UpMbps > 0.200)
	AND adct.Data IS NOT NULL
	AND adcf.Data IS NOT NULL
GROUP BY s.State, adcf.Data, rft.RegFCC477Tech, rat.DownMbps, rat.UpMbps
ORDER BY s.State, adcf.Data, rft.RegFCC477Tech, rat.DownMbps, rat.UpMbps
GO

CREATE PROCEDURE dbo.FCC477FBSReport (@OrganizationID INT, @GroupID INT, @BDC TINYINT) AS
SET NOCOUNT ON
SELECT s.NationalRef + adcf.Data + adct.Data AS Tract,
CASE WHEN @BDC = 1 THEN rt.CodeBDC ELSE rt.Code477 END AS RegFCC477TechID, CAST(rat.DownMbps AS VARCHAR) AS DownMbps, CAST(rat.UpMbps AS VARCHAR) AS UpMbps, COUNT(*) AS Connections, SUM(CASE WHEN rat.Residential = 1 THEN 1 ELSE 0 END) AS ConsumerConnections
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN States s ON (a.StateID = s.StateID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	JOIN RegFCC477Techs rt ON (rat.RegFCC477TechID = rt.RegFCC477TechID)
	JOIN AddressData adct ON (a.AddressID = adct.AddressID AND adct.AddressDataTypeID = 1)
	JOIN AddressData adcf ON (a.AddressID = adcf.AddressID AND adcf.AddressDataTypeID = 2)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND a.CountryID = 840
	AND rat.RegFCC477TechID IS NOT NULL
	AND (rat.DownMbps > 0.200 OR rat.UpMbps > 0.200)
	AND adct.Data IS NOT NULL
	AND adcf.Data IS NOT NULL
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR g.GroupID = @GroupID)
GROUP BY s.NationalRef, adcf.Data, adct.Data, CASE WHEN @BDC = 1 THEN rt.CodeBDC ELSE rt.Code477 END, rat.DownMbps, rat.UpMbps
GO

CREATE PROCEDURE dbo.FCC477FVSReport (@OrganizationID INT, @GroupID INT) AS
SET NOCOUNT ON
SELECT s.NationalRef + adcf.Data + adct.Data AS Tract,
rat.RegFCC477VoiceTechID, COUNT(*) AS Connections, SUM(CASE WHEN rat.Residential = 1 THEN 1 ELSE 0 END) AS ConsumerConnections
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN States s ON (a.StateID = s.StateID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	JOIN AddressData adct ON (a.AddressID = adct.AddressID AND adct.AddressDataTypeID = 1)
	JOIN AddressData adcf ON (a.AddressID = adcf.AddressID AND adcf.AddressDataTypeID = 2)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND a.CountryID = 840
	AND rat.RegFCC477VoiceTechID IS NOT NULL
	AND adct.Data IS NOT NULL
	AND adcf.Data IS NOT NULL
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR g.GroupID = @GroupID)
GROUP BY s.NationalRef, adcf.Data, adct.Data, rat.RegFCC477VoiceTechID
GO

CREATE PROCEDURE dbo.FCC477IVSReport AS
SET NOCOUNT ON
SELECT MIN(s.State) AS State,
COUNT(*) AS GrandTotal,
SUM(CASE WHEN rat.Residential = 1 THEN 1 ELSE 0 END) AS GrandTotalConsumer,
SUM(CASE WHEN rat.Residential = 0 THEN 1 ELSE 0 END) AS GrandTotalBusiness,

SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NULL THEN 1 ELSE 0 END) AS OverTopTotal,
SUM(CASE WHEN rat.Residential = 1 AND COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NULL THEN 1 ELSE 0 END) AS OverTopConsumer,
SUM(CASE WHEN rat.Residential = 0 AND COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NULL THEN 1 ELSE 0 END) AS OverTopBusiness,

SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NOT NULL THEN 1 ELSE 0 END) AS AllOtherTotal,
SUM(CASE WHEN rat.Residential = 1 AND COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NOT NULL THEN 1 ELSE 0 END) AS AllOtherConsumer,
SUM(CASE WHEN rat.Residential = 0 AND COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NOT NULL THEN 1 ELSE 0 END) AS AllOtherBusiness,

SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NOT NULL AND COALESCE(rat.VoiceInternet,prat.VoiceInternet) = 1 THEN 1 ELSE 0 END) AS ServiceSoldVoiceInternet,
SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) IS NOT NULL AND COALESCE(rat.VoiceInternet,prat.VoiceInternet) = 0 THEN 1 ELSE 0 END) AS ServiceSoldVoiceOnly,

SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) = 1 THEN 1 ELSE 0 END) AS LastMileFTTP,
SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) = 2 THEN 1 ELSE 0 END) AS LastMileCable,
SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) = 3 THEN 1 ELSE 0 END) AS LastMileWireless,
SUM(CASE WHEN COALESCE(rat.RegFCC477VoiceTransportID,prt.RegFCC477VoiceTransportID) = 4 THEN 1 ELSE 0 END) AS LastMileCopper

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN States s ON (a.StateID = s.StateID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	LEFT JOIN SubAccounts psa ON (sa.ParentAccountID = psa.AccountID)
	LEFT JOIN RegFCC477AccountTypes prat ON (psa.AccountTypeID = prat.AccountTypeID)
	LEFT JOIN RegFCC477Techs prt ON (prat.RegFCC477TechID = prt.RegFCC477TechID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND a.CountryID = 840
	AND rat.RegFCC477VoiceTechID = 1
GROUP BY a.StateID
GO

CREATE PROCEDURE dbo.FCC477StateReport AS
SET NOCOUNT ON
SELECT s.State, rft.RegFCC477Tech AS Technology, rat.DownMbps AS Download, rat.UpMbps AS Upload, COUNT(*) AS Connections, SUM(CASE WHEN rat.Residential = 1 THEN 1 ELSE 0 END) AS Residential, SUM(CASE WHEN rat.Residential = 0 THEN 1 ELSE 0 END) AS Business
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	JOIN States s ON (a.StateID = s.StateID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	JOIN AddressData adct ON (a.AddressID = adct.AddressID AND adct.AddressDataTypeID = 1)
	JOIN AddressData adcf ON (a.AddressID = adcf.AddressID AND adcf.AddressDataTypeID = 2)
	JOIN RegFCC477Techs rft ON (rat.RegFCC477TechID = rft.RegFCC477TechID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND a.CountryID = 840
	AND rat.RegFCC477TechID IS NOT NULL
	AND (rat.DownMbps > 0.200 OR rat.UpMbps > 0.200)
	AND adct.Data IS NOT NULL
	AND adcf.Data IS NOT NULL
GROUP BY s.State, rft.RegFCC477Tech, rat.DownMbps, rat.UpMbps
ORDER BY s.State, rft.RegFCC477Tech, rat.DownMbps, rat.UpMbps
GO

CREATE PROCEDURE dbo.FCC477Status AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @layerdate DATETIME
SELECT @layerdate = CreateDate FROM GeoLayers WHERE GeoLayer = 'US Census Tract' AND Status = 1

SELECT sa.CustomerID, sa.AccountID, a.FirstName, a.LastName, sa.Login, CASE 
WHEN a.AddressID IS NULL THEN 'Service address missing'
WHEN s.StateID IS NULL THEN 'State missing from service address'
WHEN s.NationalRef IS NULL THEN 'State FIPS (NationalRef) missing from service address'
WHEN adct.Data IS NULL AND adcf.Data IS NULL THEN 'Census tract and County FIPS data missing from service address'
WHEN adct.Data IS NULL THEN 'Census tract data missing from service address'
WHEN adcf.Data IS NULL THEN 'County FIPS data missing from service address'
WHEN adct.AddressDataSourceID = 1 AND adct.LastUpdate < @layerdate THEN 'Address Census Tract data is older than US Census Tract Layer'
WHEN adcf.AddressDataSourceID = 1 AND adcf.LastUpdate < @layerdate THEN 'Address County FIPS data is older than US Census Tract Layer'
ELSE 'Internal Error' END AS Message
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN RegFCC477AccountTypes rat ON (sa.AccountTypeID = rat.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	LEFT JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN AddressData adct ON (a.AddressID = adct.AddressID AND adct.AddressDataTypeID = 1)
	LEFT JOIN AddressData adcf ON (a.AddressID = adcf.AddressID AND adcf.AddressDataTypeID = 2)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
	AND (a.CountryID = 840 OR a.AddressID IS NULL)
	AND (rat.RegFCC477TechID IS NOT NULL OR rat.RegFCC477VoiceTechID IS NOT NULL)
	AND (adct.Data IS NULL 
		OR adcf.Data IS NULL 
		OR a.AddressID IS NULL
		OR s.NationalRef IS NULL
		OR (adct.AddressDataSourceID = 1 AND adct.LastUpdate < @layerdate)
		OR (adcf.AddressDataSourceID = 1 AND adcf.LastUpdate < @layerdate))
UNION ALL
SELECT NULL,NULL,NULL,NULL,NULL,'US Census Tract layer not loaded or Invalid' WHERE @layerdate IS NULL
UNION ALL
SELECT DISTINCT NULL,NULL,NULL,NULL,NULL,'Update FCC 477 Services to confirm all service types are configured properly'
FROM AccountTypes at1 LEFT JOIN RegFCC477AccountTypes rat ON (at1.AccountTypeID = rat.AccountTypeID)
	WHERE rat.AccountTypeID IS NULL
GO

CREATE PROCEDURE dbo.ShowTriggers AS
SET NOCOUNT ON
SELECT s1.name AS TriggerName, s2.name AS TableName, s1.crdate AS CreateDate
FROM sysobjects s1 LEFT JOIN sysobjects s2 ON (s1.parent_obj = s2.id)
	WHERE s1.xtype IN ('X','TR','TA')
ORDER BY 1
GO

CREATE PROCEDURE dbo.SearchApplyMasks (@SearchFieldID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @search TINYINT, @result TINYINT

SELECT	@search = CASE WHEN FilterEWS IS NOT NULL THEN 1 ELSE 0 END, 
	@result = CASE WHEN SelectEWS IS NOT NULL THEN 1 ELSE 0 END
FROM SearchFields
	WHERE SearchFieldID = @SearchFieldID

SELECT 3 AS Value, 'Field + Column' AS Description, NULL AS StringID WHERE @search = 1 AND @result = 1
UNION ALL
SELECT 1, 'Search Field', NULL WHERE @search = 1
UNION ALL
SELECT 2, 'Result Column', NULL WHERE @result = 1
GO

CREATE PROCEDURE dbo.ListCommissionGroups AS
SET NOCOUNT ON

SELECT CommissionGroupID, CommissionGroup, CASE WHEN Active = 0 THEN 'hidden' END AS Class
FROM CommissionGroups
ORDER BY SortOrder, CommissionGroup
GO

CREATE PROCEDURE dbo.ListRegFCCBLProviders AS
SET NOCOUNT ON

SELECT RegFCCBLProviderID, RegFCCBLProvider, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM RegFCCBLProviders
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, RegFCCBLProvider
GO

CREATE PROCEDURE dbo.ListSearchFields AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT sf.SearchFieldID, sf.SearchField, sf.StringID, sfg.SearchFieldGroup, sfg.StringID AS sfgStringID
FROM SearchFields sf JOIN SearchFieldGroups sfg ON (sf.SearchFieldGroupID = sfg.SearchFieldGroupID)
ORDER BY sfg.SortOrder, sfg.SearchFieldGroup, sf.SortOrder, sf.SearchField
GO

CREATE PROCEDURE dbo.SearchItemFieldsGet (@SearchID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT si.SearchItemID, sf.SearchField, sf.StringID AS sfStringID, COALESCE(acdt.AccountDataType,adt.AddressDataType) AS SearchField2, adt.StringID AS sf2StringID, sc.SearchCondition, sc.StringID AS scStringID, si.DefaultData, sf.FormEWS, si.AccountDataTypeID, si.AddressDataTypeID, si.SortOrder AS Sort1, sf.SortOrder AS Sort2
FROM SearchItems si JOIN SearchFields sf ON (si.SearchFieldID = sf.SearchFieldID)
	LEFT JOIN SearchConditions sc ON (si.SearchConditionID = sc.SearchConditionID)
	LEFT JOIN AccountDataTypes acdt ON (si.AccountDataTypeID = acdt.AccountDataTypeID AND si.SearchFieldID IN (1,2))
	LEFT JOIN AddressDataTypes adt ON (si.AddressDataTypeID = adt.AddressDataTypeID AND si.SearchFieldID IN (3,4,5))
	WHERE si.SearchID = @SearchID
	AND si.ApplyMask & 1 = 1
ORDER BY si.SearchConditionID, si.SortOrder, sf.SortOrder, si.SearchItemID
GO

CREATE PROCEDURE dbo.SearchItemColumnsGet (@SearchID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT si.SearchItemID, sf.SearchField, sf.StringID AS sfStringID, COALESCE(acdt.AccountDataType,adt.AddressDataType) AS SearchField2, adt.StringID AS sf2StringID, si.SortOrder AS Sort1, sf.SortOrder AS Sort2
FROM SearchItems si JOIN SearchFields sf ON (si.SearchFieldID = sf.SearchFieldID)
	LEFT JOIN AccountDataTypes acdt ON (si.AccountDataTypeID = acdt.AccountDataTypeID AND si.SearchFieldID IN (1,2))
	LEFT JOIN AddressDataTypes adt ON (si.AddressDataTypeID = adt.AddressDataTypeID AND si.SearchFieldID IN (3,4,5))
	WHERE si.SearchID = @SearchID
	AND si.ApplyMask & 2 = 2
ORDER BY si.SortOrder, sf.SortOrder, si.SearchItemID
GO

CREATE PROCEDURE dbo.SearchItemQueryGet (@SearchID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT si.SearchItemID, si.SearchConditionID, si.SearchFieldID, si.AccountDataTypeID, si.AddressDataTypeID, sf.JoinEWS,
CASE WHEN si.ApplyMask & 1 = 1 THEN sf.FilterEWS END AS FilterEWS,
CASE WHEN si.ApplyMask & 2 = 2 THEN sf.SelectEWS END AS SelectEWS,
'v' + CAST(si.SearchItemID AS VARCHAR) AS ColumnName, COALESCE(acdt.AccountDataType,adt.AddressDataType,sf.SearchField) AS Description, 
CASE WHEN adt.AddressDataTypeID IS NOT NULL THEN adt.StringID WHEN acdt.AccountDataType IS NULL THEN sf.StringID END AS StringID

FROM SearchItems si JOIN SearchFields sf ON (si.SearchFieldID = sf.SearchFieldID)
	LEFT JOIN AccountDataTypes acdt ON (si.AccountDataTypeID = acdt.AccountDataTypeID AND si.SearchFieldID IN (1,2))
	LEFT JOIN AddressDataTypes adt ON (si.AddressDataTypeID = adt.AddressDataTypeID AND si.SearchFieldID IN (3,4,5))
	WHERE si.SearchID = @SearchID
	AND ((si.ApplyMask & 1 = 1 AND sf.FilterEWS IS NOT NULL) OR (si.ApplyMask & 2 = 2 AND sf.SelectEWS IS NOT NULL))
	AND ((si.SearchFieldID IN (1,2) AND si.AccountDataTypeID IS NOT NULL) OR (si.SearchFieldID IN (3,4,5) AND si.AddressDataTypeID IS NOT NULL) OR (si.SearchFieldID NOT IN (1,2,3,4,5)))
ORDER BY si.SortOrder, sf.SortOrder, si.SearchItemID
GO

CREATE PROCEDURE dbo.SearchAddressDataTypes AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT AddressDataTypeID, AddressDataType, StringID, AccessLabelID
FROM AddressDataTypes
	WHERE SortOrder >= 0
ORDER BY SortOrder, AddressDataType
GO

CREATE PROCEDURE dbo.SearchAccountDataTypes (@IsMBR TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@IsMBR = 1)
BEGIN
SELECT adt.AccountDataTypeID, adt.AccountDataType, adt.AccessLabelID
FROM AccountDataTypes adt
	WHERE EXISTS (SELECT * FROM MasterAccountDataTypes madt WHERE madt.AccountDataTypeID = adt.AccountDataTypeID)
ORDER BY 2
END ELSE BEGIN
SELECT adt.AccountDataTypeID, adt.AccountDataType, adt.AccessLabelID
FROM AccountDataTypes adt
	WHERE EXISTS (SELECT * FROM SubAccountDataTypes sadt WHERE sadt.AccountDataTypeID = adt.AccountDataTypeID)
ORDER BY 2
END
GO

CREATE PROCEDURE dbo.FTSEnabled AS
SET NOCOUNT ON
IF (fulltextserviceproperty('IsFulltextInstalled') = 1 AND (SELECT COUNT(*) FROM sysfulltextcatalogs where name = 'EmeraldCatalog') = 0)
BEGIN

EXEC sp_fulltext_database 'enable'
EXEC sp_fulltext_catalog 'EmeraldCatalog', 'create'

-- Incidents.Description FTI

DECLARE @pk VARCHAR(64)

SELECT @pk = si.name
FROM sysindexes si JOIN sysobjects so ON (si.id = so.id)
	WHERE so.name = 'Incidents'
 	AND (si.status & 2048) = 2048

EXEC sp_fulltext_table 'Incidents', 'create', 'EmeraldCatalog', @pk
EXEC sp_fulltext_column 'Incidents', 'Description', 'add', 0
EXEC sp_fulltext_column 'Incidents', 'Summary', 'add', 0
EXEC sp_fulltext_table 'Incidents', 'activate'

-- Actions.Description FTI

SELECT @pk = si.name
FROM sysindexes si JOIN sysobjects so ON (si.id = so.id)
	WHERE so.name = 'Actions'
 	AND (si.status & 2048) = 2048

EXEC sp_fulltext_table 'Actions', 'create', 'EmeraldCatalog', @pk
EXEC sp_fulltext_column 'Actions', 'Description', 'add', 0
EXEC sp_fulltext_table 'Actions', 'activate'

EXEC sp_fulltext_catalog 'EmeraldCatalog', 'start_full' 
SELECT 1 AS Enabled
END ELSE BEGIN
SELECT fulltextserviceproperty('IsFulltextInstalled') AS Enabled
END
GO

CREATE PROCEDURE dbo.FTSIndex AS
SET NOCOUNT ON
IF ((Select fulltextserviceproperty('IsFulltextInstalled')) = 1 AND (SELECT COUNT(*) FROM sysfulltextcatalogs where name = 'EmeraldCatalog') = 1)
	EXEC sp_fulltext_catalog 'EmeraldCatalog', 'start_incremental'
GO

CREATE PROCEDURE dbo.FileDownload (@FileID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT f.FileName, f.FileSize, f.FileMimeType, f.FileData, mt.IsImage
FROM Files f LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.FileID = @FileID
GO

CREATE PROCEDURE dbo.FileList (@CustomerID INT, @AccountID INT, @IncidentID INT, @PaymentID INT, @InvoiceID INT, @SiteID INT, @TowerID INT, @EventID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@SiteID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.SiteID = @SiteID
END

ELSE IF (@TowerID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.TowerID = @TowerID
END

ELSE IF (@IncidentID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.CustomerID = @CustomerID
	AND f.IncidentID = @IncidentID
END

ELSE IF (@EventID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.EventID = @EventID
END

ELSE IF (@PaymentID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.CustomerID = @CustomerID
	AND f.PaymentID = @PaymentID
END

ELSE IF (@InvoiceID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.CustomerID = @CustomerID
	AND f.InvoiceID = @InvoiceID
END

ELSE IF (@AccountID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.CustomerID = @CustomerID
	AND f.AccountID = @AccountID
END

ELSE IF (@CustomerID IS NOT NULL)
BEGIN
SELECT f.FileID, fc.FileCategoryID, fc.FileCategory, fc.StringID AS fcStringID, f.FileName, f.FileSize / 1000000.0 AS FileSize, f.FileMimeType, f.CreateDate, f.CreateUser, f.Comments, f.Active, mt.IsImage,
f.AccountID, f.IncidentID, f.PaymentID, f.InvoiceID, CASE WHEN f.Active = 0 THEN 'inactive' END AS Class
FROM Files f JOIN FileCategories fc ON (f.FileCategoryID = fc.FileCategoryID)
	LEFT JOIN MimeTypes mt ON (f.FileMimeType = mt.MimeType)
	WHERE f.CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.FileTypeCheck (@FileCategoryID INT, @MimeType VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @cnt INT
SELECT @cnt = COUNT(*) FROM FileCategoryMimeTypes WHERE FileCategoryID = @FileCategoryID

IF (@cnt > 0)
BEGIN
SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS IsValid
FROM FileCategoryMimeTypes fcmt JOIN MimeTypes mt ON (fcmt.MimeTypeID = mt.MimeTypeID)
	WHERE fcmt.FileCategoryID = @FileCategoryID
	AND mt.MimeType = @MimeType
END ELSE BEGIN
SELECT 1 AS IsValid
END
GO

CREATE PROCEDURE dbo.GaugeAdd (@GaugeID INT, @AccountID INT, @StartDate DATETIME, @Data FLOAT) AS
SET NOCOUNT ON
SET DEADLOCK_PRIORITY LOW
DECLARE @winbase DATETIME, @window DATETIME, @GaugeWindowID INT, @GaugeConversionID INT, @LastUpdate DATETIME, @LastData FLOAT
SELECT @StartDate = COALESCE(@StartDate,GETDATE()), @winbase = DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(ms,-DATEPART(ms,getdate()),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),DATEADD(dd,-DATEPART(dd,getdate())+1,getdate()))))

SELECT @window = DATEADD(ss,DATEDIFF(ss,@winbase,@StartDate)-(DATEDIFF(ss,@winbase,@StartDate)%gw.Secs),@winbase), @GaugeWindowID = gw.GaugeWindowID, @GaugeConversionID = g.GaugeConversionID
FROM Gauges g JOIN GaugeWindows gw ON (g.GaugeWindowID = gw.GaugeWindowID)
	WHERE g.GaugeID = @GaugeID

IF (@GaugeConversionID IN (1,2,3))
BEGIN
SELECT @LastData = Data, @LastUpdate = LastUpdate
FROM GaugeCounterData
	WHERE AccountID = @AccountID 
	AND GaugeID = @GaugeID

IF (@LastUpdate IS NULL)
	BEGIN
	INSERT INTO GaugeCounterData (AccountID,GaugeID,Data,LastUpdate) VALUES(@AccountID,@GaugeID,@Data,@StartDate)
	RETURN
	END

IF (@LastUpdate > @StartDate)
	BEGIN
	DELETE FROM GaugeCounterData WHERE AccountID = @AccountID AND GaugeID = @GaugeID
	RETURN
	END

IF (@LastUpdate = @StartDate)
	BEGIN
	UPDATE GaugeCounterData SET Data = @Data WHERE AccountID = @AccountID AND GaugeID = @GaugeID
	RETURN
	END

UPDATE GaugeCounterData SET Data = @Data, LastUpdate = @StartDate WHERE AccountID = @AccountID AND GaugeID = @GaugeID
SELECT @Data = (@Data - CASE WHEN @LastData > @Data THEN 0.0 ELSE @LastData END) / (DATEDIFF(ss,@LastUpdate,@StartDate) * CASE @GaugeConversionID WHEN 1 THEN 1.0 WHEN 2 THEN 60.0 WHEN 3 THEN 3600.0 END)
END

IF (@window IS NOT NULL AND @GaugeWindowID IS NOT NULL)
BEGIN
INSERT INTO GaugeData (GaugeID, AccountID, StartDate, GaugeWindowID, Data) VALUES(@GaugeID,@AccountID,@window,@GaugeWindowID,@Data)
END
GO

CREATE PROCEDURE dbo.GaugeRollup WITH RECOMPILE AS
SET NOCOUNT ON
DECLARE @winbase DATETIME, @curtime DATETIME, @mindays INT, @AccountID INT, @Deleted TINYINT, @delcount BIGINT, @addcount BIGINT, @sacount INT
SELECT @winbase = DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(ms,-DATEPART(ms,getdate()),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),DATEADD(dd,-DATEPART(dd,getdate())+1,getdate())))), @curtime = GETDATE(), @mindays = 5, @delcount = 0, @addcount = 0, @sacount = 0
CREATE TABLE #graid (AccountID INT)

INSERT INTO #graid (AccountID)
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND EXISTS (SELECT * FROM GaugeData gd WHERE gd.AccountID = sa.AccountID)

DELETE FROM GaugeData WHERE AccountID IN (SELECT sa.AccountID FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID) WHERE (ma.Active = -1 OR sa.Active = -1))
SELECT @delcount = @delcount + @@ROWCOUNT

DECLARE gr CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR SELECT AccountID FROM #graid

OPEN gr
goto onefetch
WHILE (@@FETCH_STATUS = 0)
BEGIN

BEGIN TRANSACTION

INSERT INTO GaugeData (GaugeID, AccountID, StartDate, GaugeWindowID, Data)
SELECT gd.GaugeID, @AccountID, DATEADD(ss,DATEDIFF(ss,@winbase,gd.StartDate)-(DATEDIFF(ss,@winbase,gd.StartDate)%rgw.Secs),@winbase), MIN(gd.RollupGaugeWindowID), SUM(gd.Data * gw.Secs) / SUM(gw.Secs)
FROM	(SELECT gd.StartDate, gd.GaugeID, MIN(gd.GaugeWindowID) AS GaugeWindowID, MIN(gd.Data) AS Data, MAX(gr.RollupDays) AS RollupDays, MAX(gr.GaugeWindowID) AS RollupGaugeWindowID
	FROM GaugeData gd JOIN GaugeRollups gr ON (gd.GaugeID = gr.GaugeID)
		WHERE gd.AccountID = @AccountID
		AND (gr.ExemptBelow IS NULL OR gd.Data > gr.ExemptBelow)
		AND (gr.ExemptAbove IS NULL OR gd.Data < gr.ExemptAbove)
		AND gd.GaugeWindowID < gr.GaugeWindowID
		AND gd.StartDate < DATEADD(dd,-CASE WHEN gr.RollupDays < @mindays THEN @mindays ELSE gr.RollupDays END,@curtime)
	GROUP BY gd.StartDate, gd.GaugeID) gd JOIN GaugeWindows gw ON (gd.GaugeWindowID = gw.GaugeWindowID)
		JOIN GaugeWindows rgw ON (gd.RollupGaugeWindowID = rgw.GaugeWindowID)
		WHERE DATEADD(ss,DATEDIFF(ss,@winbase,gd.StartDate)-(DATEDIFF(ss,@winbase,gd.StartDate)%rgw.Secs),@winbase) < DATEADD(dd,-CASE WHEN gd.RollupDays < @mindays THEN @mindays ELSE gd.RollupDays END,@curtime)
GROUP BY gd.GaugeID, DATEADD(ss,DATEDIFF(ss,@winbase,gd.StartDate)-(DATEDIFF(ss,@winbase,gd.StartDate)%rgw.Secs),@winbase)

SELECT @addcount = @addcount + @@ROWCOUNT

DELETE FROM gd
FROM GaugeData gd JOIN GaugeRollups gr ON (gd.GaugeID = gr.GaugeID)
	JOIN GaugeWindows gw ON (gr.GaugeWindowID = gw.GaugeWindowID)
	WHERE gd.AccountID = @AccountID
	AND (gr.ExemptBelow IS NULL OR gd.Data > gr.ExemptBelow)
	AND (gr.ExemptAbove IS NULL OR gd.Data < gr.ExemptAbove)
	AND gd.GaugeWindowID < gr.GaugeWindowID
	AND gd.StartDate < DATEADD(dd,-CASE WHEN gr.RollupDays < @mindays THEN @mindays ELSE gr.RollupDays END,@curtime)
	AND DATEADD(ss,DATEDIFF(ss,@winbase,gd.StartDate)-(DATEDIFF(ss,@winbase,gd.StartDate)%gw.Secs),@winbase) < DATEADD(dd,-CASE WHEN gr.RollupDays < @mindays THEN @mindays ELSE gr.RollupDays END,@curtime)

SELECT @delcount = @delcount + @@ROWCOUNT, @sacount = @sacount + CASE WHEN @@ROWCOUNT > 0 THEN 1 ELSE 0 END

COMMIT TRANSACTION


onefetch:
FETCH NEXT FROM gr INTO @AccountID
END
CLOSE gr
DEALLOCATE gr
DROP TABLE #graid

IF (@sacount > 0 AND DATEPART(dw,@curtime) = 2)
BEGIN
DBCC INDEXDEFRAG (0,'GaugeData','i_GaugeData_AID_SD') WITH NO_INFOMSGS
END

SELECT 'Added:' + CAST(@addcount AS VARCHAR(20)) + ', Removed:' + CAST(@delcount AS VARCHAR(20)) + ', Delta:' + CAST(@addcount - @delcount AS VARCHAR(20)) + ', Services:' + CAST(@sacount AS VARCHAR(11)) AS Description
GO

CREATE PROCEDURE dbo.GeneralFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID AS uniqueIdentifier
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.ExternalSystem = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

CREATE PROCEDURE dbo.GeneralGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id

SELECT
DISTINCT sa.AccountID,
COALESCE(a.LastName,'N/A') AS sn,
COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,'') AS cn,
CASE WHEN sa.Email IS NOT NULL AND sa.Email <> ' ' THEN sa.Email ELSE sa.Login END AS uid,
sa.Password AS userPassword,
g.GroupName AS ou,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain ELSE sa.Email END AS mail,
a.PhoneHome AS telephoneNumber,
COALESCE(s.Abbreviation,s.State) AS st,
ab.Zip AS postalCode,
sa.AccountID AS uniqueIdentifier,
sa.LastModifyUser AS LastModifiedBy,
sa.LastModifyDate AS LastModifyDate,
ab.Address1 AS streetAddress,
ab.PhoneFax AS facsimileTelephoneNumber,
COALESCE(ab.Company,'N/A') AS o,
CASE 	WHEN sa.Active = 0 OR ma.Active = 0 THEN 'Inactive' 
	WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < getdate() THEN 'Canceled'
	WHEN sa.CancelDate IS NOT NULL AND sa.CancelDate < getdate() THEN 'Canceled'
	WHEN ma.CreditLimit > 0 AND ma.CreditLimit > ma.PendingBalance THEN 'Over Credit Limit'
	WHEN DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 'Expired'
	ELSE 'Active'
END AS organizationalStatus,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS otherMailbox

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifyDate > ls.LastSyncWrite)
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.GeoBoundingMatch (@lat float, @long float, @GeoLayerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 0 AS Position, GeoShapeID, GeoShape, Aux1, Aux2, Aux3, Aux4
FROM GeoShapes 
	WHERE GeoLayerID = @GeoLayerID
	AND MinLat <= @lat
	AND MaxLat >= @lat
	AND MinLong <= @long
	AND MaxLong >= @long
GO

CREATE PROCEDURE dbo.GeoBoundingMatch10 (@lat0 float, @long0 float, @GeoLayerID0 INT, @lat1 float, @long1 float, @GeoLayerID1 INT, @lat2 float, @long2 float, @GeoLayerID2 INT,@lat3 float, @long3 float, @GeoLayerID3 INT,@lat4 float, @long4 float, @GeoLayerID4 INT,@lat5 float, @long5 float, @GeoLayerID5 INT,@lat6 float, @long6 float, @GeoLayerID6 INT,@lat7 float, @long7 float, @GeoLayerID7 INT,@lat8 float, @long8 float, @GeoLayerID8 INT,@lat9 float, @long9 float, @GeoLayerID9 INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 0 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID0 AND MinLat<=@lat0 AND MaxLat>=@lat0 AND MinLong<=@long0 AND MaxLong>=@long0
UNION ALL
SELECT 1 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID1 AND MinLat<=@lat1 AND MaxLat>=@lat1 AND MinLong<=@long1 AND MaxLong>=@long1 
UNION ALL
SELECT 2 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID2 AND MinLat<=@lat2 AND MaxLat>=@lat2 AND MinLong<=@long2 AND MaxLong>=@long2
UNION ALL
SELECT 3 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID3 AND MinLat<=@lat3 AND MaxLat>=@lat3 AND MinLong<=@long3 AND MaxLong>=@long3
UNION ALL
SELECT 4 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID4 AND MinLat<=@lat4 AND MaxLat>=@lat4 AND MinLong<=@long4 AND MaxLong>=@long4
UNION ALL
SELECT 5 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID5 AND MinLat<=@lat5 AND MaxLat>=@lat5 AND MinLong<=@long5 AND MaxLong>=@long5
UNION ALL
SELECT 6 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID6 AND MinLat<=@lat6 AND MaxLat>=@lat6 AND MinLong<=@long6 AND MaxLong>=@long6
UNION ALL
SELECT 7 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID7 AND MinLat<=@lat7 AND MaxLat>=@lat7 AND MinLong<=@long7 AND MaxLong>=@long7
UNION ALL
SELECT 8 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID8 AND MinLat<=@lat8 AND MaxLat>=@lat8 AND MinLong<=@long8 AND MaxLong>=@long8
UNION ALL
SELECT 9 AS Position,GeoShapeID,GeoShape,Area,Aux1,Aux2,Aux3,Aux4 FROM GeoShapes WHERE GeoLayerID=@GeoLayerID9 AND MinLat<=@lat9 AND MaxLat>=@lat9 AND MinLong<=@long9 AND MaxLong>=@long9
ORDER BY 1 ASC
GO

CREATE PROCEDURE dbo.GeoLayerAdd (@GeoLayer VARCHAR(128), @DescGeoShape VARCHAR(128), @DescAux1 VARCHAR(128), @DescAux2 VARCHAR(128), @DescAux3 VARCHAR(128), @DescAux4 VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @GeoLayerID INT

SELECT @GeoLayerID = GeoLayerID FROM GeoLayers WHERE GeoLayer = @GeoLayer

IF (@GeoLayerID IS NULL)
BEGIN
INSERT INTO GeoLayers (GeoLayer,DescGeoShape,DescAux1,DescAux2,DescAux3,DescAux4) VALUES(@GeoLayer,@DescGeoShape,@DescAux1,@DescAux2,@DescAux3,@DescAux4)
SELECT @GeoLayerID = SCOPE_IDENTITY()
END ELSE BEGIN
UPDATE GeoLayers SET DescGeoShape = @DescGeoShape, DescAux1 = @DescAux1, DescAux2 = @DescAux2, DescAux3 = @DescAux3, DescAux4 = @DescAux4 WHERE GeoLayerID = @GeoLayerID
END

SELECT @GeoLayerID AS GeoLayerID
GO

CREATE PROCEDURE dbo.GeoLayerClearPartial (@GeoLayerID INT, @GeoSubLayerID INT) AS
SET NOCOUNT ON
DECLARE @minGeoShapeID INT, @cnt INT
CREATE TABLE #glcp (GeoShapeID INT)

IF (@GeoSubLayerID IS  NULL)
BEGIN
SELECT @minGeoShapeID = MIN(GeoShapeID) FROM GeoShapes WHERE GeoLayerID = @GeoLayerID

INSERT INTO #glcp (GeoShapeID)
SELECT GeoShapeID 
FROM GeoShapes 
	WHERE GeoLayerID = @GeoLayerID
	AND GeoShapeID BETWEEN @minGeoShapeID AND @minGeoShapeID + 500
END ELSE BEGIN
SELECT @minGeoShapeID = MIN(GeoShapeID) FROM GeoShapes WHERE GeoLayerID = @GeoLayerID AND GeoSubLayerID = @GeoSubLayerID

INSERT INTO #glcp (GeoShapeID)
SELECT GeoShapeID 
FROM GeoShapes 
	WHERE GeoLayerID = @GeoLayerID
	AND GeoSubLayerID = @GeoSubLayerID
	AND GeoShapeID BETWEEN @minGeoShapeID AND @minGeoShapeID + 500
END

DELETE FROM GeoPolygons WHERE GeoShapeID IN (SELECT GeoShapeID FROM #glcp)
DELETE FROM GeoShapes WHERE GeoShapeID IN (SELECT GeoShapeID FROM #glcp)

SELECT @cnt = @@ROWCOUNT

SELECT CASE WHEN @cnt = 0 THEN 0 ELSE 1 END AS HaveMore

IF (@GeoSubLayerID IS NULL AND @cnt = 0)
BEGIN
DELETE FROM GeoSubLayers WHERE GeoLayerID = @GeoLayerID
END

UPDATE GeoLayers SET CreateDate = NULL, Status = 0 WHERE GeoLayerID = @GeoLayerID
GO

CREATE PROCEDURE dbo.GeoShapeList (@GeoLayerID INT, @GeoSubLayerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT GeoShape,Aux1,Aux2,Aux3,Aux4
FROM GeoShapes
	WHERE GeoLayerID = @GeoLayerID
	AND (@GeoSubLayerID IS NULL OR GeoSubLayerID = @GeoSubLayerID)
ORDER BY 1
GO

CREATE PROCEDURE dbo.TaxGeoSync (@GeoLayerID INT) AS
SET NOCOUNT ON
CREATE TABLE #tgstaxes (Description VARCHAR(128), Tax NUMERIC(18,4), ExternalRef VARCHAR(64), TaxSourceID INT)

UPDATE Taxes SET Active = 0
FROM Taxes t JOIN TaxSources ts ON (t.TaxSourceID = ts.TaxSourceID)
	WHERE ts.TaxSourceTypeID = 1
	AND (@GeoLayerID IS NULL OR ts.GeoLayerID = @GeoLayerID)

UPDATE Taxes SET Tax = CAST(REPLACE(CASE ts.GeoFieldTax WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END,'%','') AS NUMERIC(18,4)),
Description = COALESCE(CASE ts.GeoFieldDescription WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END,t.ExternalRef),
Active = 1, 
AmountType = ts.AmountType, 
CumulativeType = ts.CumulativeType, 
FloorLimit = ts.FloorLimit, 
CeilingLimit = ts.CeilingLimit,
TaxPiggyBackID = ts.TaxPiggyBackID,
TaxPigOrder = ts.TaxPigOrder,
GLCodeID = ts.GLCodeID,
TaxExemptions = ts.TaxExemptions,
TaxTypeID = ts.TaxTypeID

FROM TaxSources ts JOIN Taxes t ON (ts.TaxSourceID = t.TaxSourceID)
	JOIN GeoShapes gs ON (ts.GeoLayerID = gs.GeoLayerID)
	WHERE ts.TaxSourceTypeID = 1
	AND (@GeoLayerID IS NULL OR ts.GeoLayerID = @GeoLayerID)
	AND (ts.GeoSubLayerID IS NULL OR ts.GeoSubLayerID = gs.GeoSubLayerID)
	AND ts.GeoFieldKey IS NOT NULL
	AND ts.GeoFieldTax IS NOT NULL
	AND t.ExternalRef IS NOT NULL
	AND CASE ts.GeoFieldKey WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END = t.ExternalRef

INSERT INTO #tgstaxes (Description,Tax,ExternalRef,TaxSourceID)
SELECT CASE ts.GeoFieldDescription WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END AS Description,
CAST(REPLACE(CASE ts.GeoFieldTax WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END,'%','') AS NUMERIC(18,4)) AS Tax,
CASE ts.GeoFieldKey WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END AS ExternalRef, ts.TaxSourceID
FROM TaxSources ts JOIN GeoShapes gs ON (ts.GeoLayerID = gs.GeoLayerID AND (ts.GeoSubLayerID IS NULL OR ts.GeoSubLayerID = gs.GeoSubLayerID))
	LEFT JOIN Taxes t ON (ts.TaxSourceID = t.TaxSourceID AND CASE ts.GeoFieldKey WHEN 0 THEN gs.GeoShape WHEN 1 THEN gs.Aux1 WHEN 2 THEN gs.Aux2 WHEN 3 THEN gs.Aux3 WHEN 4 THEN gs.Aux4 END = t.ExternalRef)
	WHERE ts.TaxSourceTypeID = 1
	AND ts.GeoFieldKey IS NOT NULL
	AND ts.GeoFieldTax IS NOT NULL
	AND t.TaxID IS NULL
	AND (@GeoLayerID IS NULL OR ts.GeoLayerID = @GeoLayerID)

INSERT INTO Taxes (Description,Tax,AmountType,CumulativeType,FloorLimit,CeilingLimit,TaxPiggyBackID,TaxPigOrder,GLCodeID,TaxExemptions,TaxTypeID,TaxSourceID,ExternalRef,Active,SortOrder)
SELECT COALESCE(MIN(t.Description),t.ExternalRef),MAX(t.Tax), MIN(ts.AmountType), MIN(ts.CumulativeType), MIN(ts.FloorLimit),MIN(ts.CeilingLimit), MIN(ts.TaxPiggyBackID), MIN(ts.TaxPigOrder), MIN(ts.GLCodeID), MIN(ts.TaxExemptions), MIN(ts.TaxTypeID),
t.TaxSourceID, t.ExternalRef, 1 AS Active, -1 AS SortOrder
FROM #tgstaxes t JOIN TaxSources ts ON (t.TaxSourceID = ts.TaxSourceID)
	WHERE t.ExternalRef IS NOT NULL
	AND t.Tax IS NOT NULL
GROUP BY t.TaxSourceID, t.ExternalRef

UPDATE Taxes SET Tax = Tax * 100 WHERE TaxSourceID IN
	(
	SELECT t.TaxSourceID 
	FROM Taxes t JOIN TaxSources ts ON (t.TaxSourceID = ts.TaxSourceID)
		WHERE ts.AmountType = 1
		AND t.Active = 1
		AND (@GeoLayerID IS NULL OR ts.GeoLayerID = @GeoLayerID)
	GROUP BY t.TaxSourceID
	HAVING MAX(t.Tax) < 1.0
	)
GO

CREATE PROCEDURE dbo.GeoLayerComplete (@GeoLayerID INT) AS
SET NOCOUNT ON
UPDATE GeoLayers SET CreateDate = getdate(), Status = 1 WHERE GeoLayerID = @GeoLayerID

EXEC TaxGeoSync @GeoLayerID
GO

CREATE PROCEDURE dbo.GeoLayerDelete (@GeoLayerID INT) AS
SET NOCOUNT ON

UPDATE GeoLayers SET Status = 0 WHERE GeoLayerID = @GeoLayerID
DELETE FROM GeoPolygons WHERE GeoShapeID IN (SELECT GeoShapeID FROM GeoShapes WHERE GeoLayerID = @GeoLayerID)
DELETE FROM GeoShapes WHERE GeoLayerID = @GeoLayerID
DELETE FROM GeoSubLayers WHERE GeoLayerID = @GeoLayerID
DELETE FROM GeoLayers WHERE GeoLayerID = @GeoLayerID
GO

CREATE PROCEDURE dbo.GeoLayersShow AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT gl.GeoLayerID, gl.GeoLayer, gl.CreateDate, gl.Status, gl.DescGeoShape,gl.DescAux1,gl.DescAux2,gl.DescAux3,gl.DescAux4, 
(SELECT COUNT(*) FROM GeoSubLayers gsl WHERE gsl.GeoLayerID=gl.GeoLayerID) AS SubLayers,
(SELECT COUNT(*) FROM GeoShapes gs WHERE gs.GeoLayerID=gl.GeoLayerID) AS Shapes
FROM GeoLayers gl
ORDER BY gl.Status DESC, gl.SortOrder, gl.GeoLayer
GO

CREATE PROCEDURE dbo.GeoPolyAdd (@GeoShapeID INT, @Part SMALLINT, @Seq INT, @Lat FLOAT, @Long FLOAT) AS
SET NOCOUNT ON
INSERT INTO GeoPolygons (GeoShapeID,Part,Seq,Lat,Long) VALUES(@GeoShapeID,@Part,@Seq,@Lat,@Long)
GO

CREATE PROCEDURE dbo.GeoShapeAdd (@GeoLayerID INT, @GeoSubLayerID INT, @GeoShape VARCHAR(128), @Aux1 VARCHAR(128), @Aux2 VARCHAR(128), @Aux3 VARCHAR(128), @Aux4 VARCHAR(128), @MinLat FLOAT, @MinLong FLOAT, @MaxLat FLOAT, @MaxLong FLOAT, @Area FLOAT) AS
SET NOCOUNT ON
INSERT INTO GeoShapes (GeoShape,Aux1,Aux2,Aux3,Aux4,GeoLayerID,GeoSubLayerID,MinLat,MinLong,MaxLat,MaxLong,Area) VALUES(@GeoShape,@Aux1,@Aux2,@Aux3,@Aux4,@GeoLayerID,@GeoSubLayerID,@MinLat,@MinLong,@MaxLat,@MaxLong,@Area)
SELECT SCOPE_IDENTITY() AS GeoShapeID
GO

CREATE PROCEDURE dbo.GeoSubLayerAdd (@GeoLayerID INT, @GeoSubLayer VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @GeoSubLayerID INT

SELECT @GeoSubLayerID = GeoSubLayerID FROM GeoSubLayers WHERE GeoLayerID = @GeoLayerID AND GeoSubLayer = @GeoSubLayer

IF (@GeoSubLayerID IS NULL)
BEGIN
INSERT INTO GeoSubLayers (GeoLayerID,GeoSubLayer) VALUES(@GeoLayerID,@GeoSubLayer)
SELECT @GeoSubLayerID = SCOPE_IDENTITY()
END

SELECT @GeoSubLayerID AS GeoSubLayerID
GO

CREATE PROCEDURE dbo.GeoSubLayerDelete (@GeoSubLayerID INT) AS
SET NOCOUNT ON
DECLARE @GeoLayerID INT
SELECT @GeoLayerID = GeoLayerID FROM GeoSubLayers WHERE GeoSubLayerID = @GeoSubLayerID

IF (@GeoLayerID IS NOT NULL)
BEGIN
DELETE FROM GeoPolygons WHERE GeoShapeID IN (SELECT GeoShapeID FROM GeoShapes WHERE GeoLayerID = @GeoLayerID AND GeoSubLayerID = @GeoSubLayerID)
DELETE FROM GeoShapes WHERE GeoLayerID = @GeoLayerID AND GeoSubLayerID = @GeoSubLayerID
DELETE FROM GeoSubLayers WHERE GeoSubLayerID = @GeoSubLayerID
END
GO

CREATE PROCEDURE dbo.GeoSubLayersShow (@GeoLayerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT gsl.GeoLayerID, gsl.GeoSubLayerID, gl.GeoLayer, gsl.GeoSubLayer,  
(SELECT COUNT(*) FROM GeoShapes gs WHERE gs.GeoLayerID = gsl.GeoLayerID AND gs.GeoSubLayerID = gsl.GeoSubLayerID) AS Shapes
FROM GeoLayers gl JOIN GeoSubLayers gsl ON (gl.GeoLayerID = gsl.GeoLayerID)
	WHERE gl.GeoLayerID = @GeoLayerID
ORDER BY gsl.GeoSubLayer
GO

CREATE PROCEDURE dbo.GeocoderRequired (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS Required
FROM Addresses a JOIN MasterAccounts ma ON (a.CustomerID = ma.CustomerID)
	JOIN Geocoders gc ON (gc.Active = 1 AND (gc.GroupID IS NULL OR ma.GroupID = gc.GroupID) AND (gc.CountryID IS NULL OR a.CountryID = gc.CountryID) AND (gc.StateID IS NULL OR a.StateID = gc.StateID))
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE a.CustomerID = @CustomerID
	AND ma.Active = 1
	AND (sa.AccountID IS NULL OR sa.Active = 1)
	AND a.Lat IS NULL
	AND a.Long IS NULL
	AND a.Address1 IS NOT NULL
	AND a.Address1 <> ' '
	AND a.Address1 NOT LIKE 'ATTN:%'
	AND a.Address1 NOT LIKE 'PO Box%'
	AND a.Address1 NOT LIKE 'PO  Box%'
	AND a.Address1 NOT LIKE 'P.O.%'
	AND a.Address1 NOT LIKE 'P. O. Box%'
	AND a.Address1 NOT LIKE 'Box%'
	AND a.Address1 NOT LIKE 'P.O Box%'
	AND a.Address1 NOT LIKE 'PO. Box%'
	AND a.Address1 NOT LIKE 'POBOX%'
	AND a.StateID IS NOT NULL
	AND (c.ZipStatus <> 2 OR a.Zip IS NOT NULL)
	AND (as1.AddressID IS NULL
		OR (as1.ExportStatus IN (2,3) AND as1.SessionRef IS NULL)
		OR COALESCE(a.CountryID,0) <> COALESCE(as1.CountryID,0)
		OR COALESCE(a.StateID,0) <> COALESCE(as1.StateID,0)
		OR COALESCE(a.Address1,' ') <> COALESCE(as1.Address1,' ')
		OR COALESCE(a.Address2,' ') <> COALESCE(as1.Address2,' ')
		OR COALESCE(a.City,' ') <> COALESCE(as1.City,' ')
		OR COALESCE(a.Zip,' ') <> COALESCE(as1.Zip,' '))
GO

CREATE PROCEDURE dbo.GeocoderExceptions (@GeocoderID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT a.AddressID, ma.CustomerID, a.FirstName, a.LastName, a.Address1, a.Address2, a.City, s.State, a.Zip, c.Country,
CASE WHEN c.ZipStatus = 2 AND a.Zip IS NULL THEN 'Postal Code missing'
WHEN s.StateID IS NULL THEN 'State missing'
WHEN as1.AddressID IS NULL THEN 'New address - sync pending'
WHEN as1.ExportStatus IN (2,3) THEN as1.Message
ELSE 'Changed Address - sync pending' END AS Message

FROM Addresses a JOIN Geocoders gc ON (gc.Active = 1)
	JOIN AddressTypes at1 ON (a.AddressTypeID = at1.AddressTypeID)
	JOIN Countries c ON (a.CountryID = c.CountryID)
	JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN MasterAccounts ma ON (a.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE (ma.CustomerID IS NULL OR ma.Active = 1)
	AND (sa.AccountID IS NULL OR sa.Active = 1)
	AND a.Lat IS NULL
	AND a.Long IS NULL
	AND a.Address1 IS NOT NULL
	AND a.Address1 <> ' '
	AND a.Address1 NOT LIKE 'ATTN:%'
	AND a.Address1 NOT LIKE 'PO Box%'
	AND a.Address1 NOT LIKE 'PO  Box%'
	AND a.Address1 NOT LIKE 'P.O.%'
	AND a.Address1 NOT LIKE 'P. O. Box%'
	AND a.Address1 NOT LIKE 'Box%'
	AND a.Address1 NOT LIKE 'P.O Box%'
	AND a.Address1 NOT LIKE 'PO. Box%'
	AND a.Address1 NOT LIKE 'POBOX%'
	AND (@GeocoderID IS NULL OR gc.GeocoderID = @GeocoderID)
	AND (gc.GroupID IS NULL OR ma.GroupID IS NULL OR ma.GroupID = gc.GroupID)
	AND (gc.CountryID IS NULL OR a.CountryID = gc.CountryID)
	AND (gc.StateID IS NULL OR a.StateID = gc.StateID)
	AND (as1.AddressID IS NULL 
		OR as1.ExportStatus <> 1
		OR as1.Lat IS NULL
		OR as1.Long IS NULL
		OR COALESCE(a.CountryID,0) <> COALESCE(as1.CountryID,0)
		OR COALESCE(a.StateID,0) <> COALESCE(as1.StateID,0)
		OR COALESCE(a.Address1,' ') <> COALESCE(as1.Address1,' ')
		OR COALESCE(a.Address2,' ') <> COALESCE(as1.Address2,' ')
		OR COALESCE(a.City,' ') <> COALESCE(as1.City,' ')
		OR COALESCE(a.Zip,' ') <> COALESCE(as1.Zip,' '))
GO

CREATE PROCEDURE dbo.GeocoderExport (@GeocoderID INT, @CustomerID INT, @SessionRef VARCHAR(32)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NULL)
BEGIN
SELECT 1024 AS TransTypeID, gc.Login, gc.Password, gc.Aux1, gc.Aux2, gc.Aux3, gc.Aux4, gc.Aux5,
a.CustomerID, a.AddressID, a.Address1, a.Address2, a.City, s.State, a.Zip, c.Country,
c.CountryID, c.Abbr2 AS Abbr2, c.Abbr3, c.InternetDomain, s.Abbreviation, s.NationalRef, @SessionRef AS SessionRef

FROM Addresses a JOIN Geocoders gc ON (gc.GeocoderID = @GeocoderID)
	JOIN Countries c ON (a.CountryID = c.CountryID)
	JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN MasterAccounts ma ON (a.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE (ma.CustomerID IS NULL OR ma.Active = 1)
	AND (sa.AccountID IS NULL OR sa.Active = 1)
	AND gc.Active = 1
	AND a.Lat IS NULL
	AND a.Long IS NULL
	AND a.Address1 IS NOT NULL
	AND a.Address1 <> ' '
	AND a.Address1 NOT LIKE 'ATTN:%'
	AND a.Address1 NOT LIKE 'PO Box%'
	AND a.Address1 NOT LIKE 'PO  Box%'
	AND a.Address1 NOT LIKE 'P.O.%'
	AND a.Address1 NOT LIKE 'P. O. Box%'
	AND a.Address1 NOT LIKE 'Box%'
	AND a.Address1 NOT LIKE 'P.O Box%'
	AND a.Address1 NOT LIKE 'PO. Box%'
	AND a.Address1 NOT LIKE 'POBOX%'
	AND a.StateID IS NOT NULL
	AND (c.ZipStatus <> 2 OR a.Zip IS NOT NULL)
	AND (gc.GroupID IS NULL OR ma.GroupID IS NULL OR ma.GroupID = gc.GroupID)
	AND (gc.CountryID IS NULL OR a.CountryID = gc.CountryID)
	AND (gc.StateID IS NULL OR a.StateID = gc.StateID)
	AND (as1.AddressID IS NULL
		OR (as1.ExportStatus IN (2,3) AND (as1.SessionRef = @SessionRef OR as1.SessionRef IS NULL))
		OR COALESCE(a.CountryID,0) <> COALESCE(as1.CountryID,0)
		OR COALESCE(a.StateID,0) <> COALESCE(as1.StateID,0)
		OR COALESCE(a.Address1,' ') <> COALESCE(as1.Address1,' ')
		OR COALESCE(a.Address2,' ') <> COALESCE(as1.Address2,' ')
		OR COALESCE(a.City,' ') <> COALESCE(as1.City,' ')
		OR COALESCE(a.Zip,' ') <> COALESCE(as1.Zip,' '))
END ELSE BEGIN
SELECT 1024 AS TransTypeID, gc.Login, gc.Password, gc.Aux1, gc.Aux2, gc.Aux3, gc.Aux4, gc.Aux5,
a.CustomerID, a.AddressID, a.Address1, a.Address2, a.City, s.State, a.Zip, c.Country,
c.CountryID, c.Abbr2 AS Abbr2, c.Abbr3, c.InternetDomain, s.Abbreviation, s.NationalRef, @SessionRef AS SessionRef

FROM Addresses a JOIN Geocoders gc ON (gc.GeocoderID = @GeocoderID)
	JOIN Countries c ON (a.CountryID = c.CountryID)
	JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN MasterAccounts ma ON (a.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE a.CustomerID = @CustomerID
	AND (ma.CustomerID IS NULL OR ma.Active = 1)
	AND (sa.AccountID IS NULL OR sa.Active = 1)
	AND gc.Active = 1
	AND a.Lat IS NULL
	AND a.Long IS NULL
	AND a.Address1 IS NOT NULL
	AND a.Address1 <> ' '
	AND a.Address1 NOT LIKE 'ATTN:%'
	AND a.Address1 NOT LIKE 'PO Box%'
	AND a.Address1 NOT LIKE 'PO  Box%'
	AND a.Address1 NOT LIKE 'P.O.%'
	AND a.Address1 NOT LIKE 'P. O. Box%'
	AND a.Address1 NOT LIKE 'Box%'
	AND a.Address1 NOT LIKE 'P.O Box%'
	AND a.Address1 NOT LIKE 'PO. Box%'
	AND a.Address1 NOT LIKE 'POBOX%'
	AND a.StateID IS NOT NULL
	AND (c.ZipStatus <> 2 OR a.Zip IS NOT NULL)
	AND (gc.GroupID IS NULL OR ma.GroupID IS NULL OR ma.GroupID = gc.GroupID)
	AND (gc.CountryID IS NULL OR a.CountryID = gc.CountryID)
	AND (gc.StateID IS NULL OR a.StateID = gc.StateID)
	AND (as1.AddressID IS NULL
		OR (as1.ExportStatus IN (2,3) AND (as1.SessionRef = @SessionRef OR as1.SessionRef IS NULL))
		OR COALESCE(a.CountryID,0) <> COALESCE(as1.CountryID,0)
		OR COALESCE(a.StateID,0) <> COALESCE(as1.StateID,0)
		OR COALESCE(a.Address1,' ') <> COALESCE(as1.Address1,' ')
		OR COALESCE(a.Address2,' ') <> COALESCE(as1.Address2,' ')
		OR COALESCE(a.City,' ') <> COALESCE(as1.City,' ')
		OR COALESCE(a.Zip,' ') <> COALESCE(as1.Zip,' '))
END
GO

CREATE PROCEDURE dbo.GeocoderGet (@GeocoderID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @armed INT
SELECT @armed = COALESCE(MAX(NumValue),1) FROM Configs WHERE ConfigID = 675

SELECT gc.GeocoderID, gc.Geocoder, gc.ExportID, gc.ProcessorURL, gc.Login, gc.Password, gc.Aux1, gc.Aux2, gc.Aux3, gc.Aux4, gc.Aux5, @armed AS Armed
FROM Geocoders gc JOIN Exports e ON (gc.ExportID = e.ExportID)
	WHERE e.ExportType = 9
	AND gc.Active = 1
	AND (@GeocoderID IS NULL OR gc.GeocoderID = @GeocoderID)
	AND (@CustomerID IS NULL OR gc.GeocoderID IN (SELECT gc2.GeocoderID FROM Geocoders gc2 JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID AND ma.Active = 1)
		JOIN Addresses a ON (a.CustomerID = @CustomerID)
		WHERE (gc2.GroupID IS NULL OR gc2.GroupID = ma.GroupID)
		AND (gc2.CountryID IS NULL OR gc2.CountryID = a.CountryID)
		AND (gc2.StateID IS NULL OR gc2.StateID = a.StateID)))
ORDER BY gc.SortOrder, gc.Geocoder
GO

CREATE PROCEDURE dbo.History (@CustomerID INT, @backmonths INT, @showtype INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @sd DATETIME
SELECT @sd = DATEADD(mm,-(COALESCE(@backmonths,120)),getdate())

SELECT i.CreateDate, 'Invoice' AS Type, i.Amount, it.InvoiceType AS Description,  i.InvoiceID AS ID,
'invoice_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&InvoiceID=' + CAST(i.InvoiceID AS VARCHAR(16)) AS URL, CASE WHEN i.VoidDate IS NOT NULL THEN 'inactive' ELSE 'active' END AS Class, 
i.LastModifyUser AS Operator
FROM Invoices i JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	WHERE @showtype & 2 = 2
	AND i.CustomerID = @CustomerID
	AND i.CreateDate > @sd

UNION ALL

SELECT i.VoidDate AS CreateDate, 'Invoice' as Type, i.Amount,  'Invoice #' + CAST(i.InvoiceID AS VARCHAR(16)) + '  VOID' AS Description,
InvoiceID AS ID, 'invoice_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&InvoiceID=' + CAST(i.InvoiceID AS VARCHAR(16)) AS URL, 'inactive' AS Class,
i.LastModifyUser AS Operator
FROM Invoices i JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	WHERE @showtype & 2 = 2
	AND i.CustomerID = @CustomerID
	AND i.VoidDate > @sd

UNION ALL

SELECT StatementDate AS CreateDate, 'Statement' AS Type, EndBal AS Amount, '' AS Description, 
StatementID AS ID, 'statement_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&StatementID=' + CAST(StatementID AS VARCHAR(16)) AS URL, 'active' AS Class,
NULL AS Operator
FROM Statements
	WHERE @showtype & 2 = 2
	AND CustomerID = @CustomerID
	AND StatementDate > @sd

UNION ALL

SELECT i.CreateDate, 'Incident', NULL AS Amount, COALESCE(CAST(i.Summary AS VARCHAR(128)),CAST(i.Description AS VARCHAR(128))), IncidentID,
'incident_loader.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&IncidentID=' + CAST(i.IncidentID AS VARCHAR(16)) + '&AccountID=' + COALESCE(CAST(i.AccountID AS VARCHAR(16)),'') AS URL,
COALESCE(is1.Style,CASE WHEN is1.StatOpen=1 AND is1.StatEscalate=1 THEN 'escalated' WHEN is1.StatOpen=1 AND is1.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen=1 THEN 'open' WHEN is1.StatArchive=1 THEN 'archived' WHEN is1.StatBlock=1 THEN 'blocking' WHEN is1.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Class,
COALESCE(o.Operator,i.LastModifyUser) AS Operator
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators o ON (i.CreateOperatorID = o.OperatorID)
	WHERE @showtype & 1 = 1
	AND i.CustomerID = @CustomerID
	and i.CreateDate > @sd

UNION ALL

SELECT a.CreateDate, 'Action', NULL AS Amount, CAST(a.Description AS VARCHAR(128)), ActionID,
'incident_loader.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&IncidentID=' + CAST(i.IncidentID AS VARCHAR(16)) + '&AccountID=' + COALESCE(CAST(i.AccountID AS VARCHAR(16)),'') AS URL,
COALESCE(is1.Style,CASE WHEN is1.StatOpen=1 AND is1.StatEscalate=1 THEN 'escalated' WHEN is1.StatOpen=1 AND is1.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen=1 THEN 'open' WHEN is1.StatArchive=1 THEN 'archived' WHEN is1.StatBlock=1 THEN 'blocking' WHEN is1.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Class,
COALESCE(o.Operator,a.LastModifyUser) AS Operator
FROM Actions a JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators o ON (a.CreateOperatorID = o.OperatorID)
	WHERE @showtype & 1 = 1
	AND a.Description IS NOT NULL
	AND i.CustomerID = @CustomerID
	AND a.CreateDate > @sd

UNION ALL

SELECT LastModifyDate, 'Adjustment', ROUND(Quantity * Amount,2) AS Amount, Description, ChargeID, 'none' AS URL, NULL AS Class, CreateUser AS Operator
FROM Charges
	WHERE @showtype & 2 = 2
	AND ItemID IS NULL
	AND CustomerID = @CustomerID
	AND LastModifyDate > @sd

UNION ALL

SELECT p.CreateDate, 'Payment', COALESCE(p.FinalAmount,p.Amount) AS Amount,
CASE WHEN p.PaymentTypeID = 4 THEN pt.PaymentType + ' #' + p.CheckNumber + '  ' + COALESCE(p.PayInfo,'') ELSE pt.PaymentType + '  ' + COALESCE(p.PayInfo,'') END AS Description, p.PaymentID,
'payment_detail.ews?CustomerID=' +  CAST(@CustomerID AS VARCHAR(16)) + '&PaymentID=' + CAST(p.PaymentID AS VARCHAR(16)) AS URL,
CASE WHEN COALESCE(p.FinalAmount,p.Amount) = 0 THEN 'inactive' WHEN p.FinalAmount IS NOT NULL THEN 'payfinal' END AS Class,
COALESCE(p.CreateUser,p.LastModifyUser) AS Operator
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	WHERE @showtype & 2 = 2
	AND p.CustomerID = @CustomerID
	AND p.CreateDate > @sd

UNION ALL

SELECT et.ReqDate AS CreateDate, 'ETrans (' + tt.TransType + ')', et.Amount, CASE WHEN et.TransStateID = 9 THEN 'VOID - ' ELSE '' END + COALESCE(et.Response,'') AS Response, et.ExternalTransID, 
CASE WHEN et.TransStateID IN (0,2) THEN 'Javascript:ask(''Void this Etrans?'',''mbr_etrans_void.ews?CustomerID='  + CAST(@CustomerID AS VARCHAR(16)) + '&ExternalTransID=' + CAST(et.ExternalTransID AS VARCHAR(16)) + ''')' ELSE 'none' END  as URL, 
CASE WHEN et.TransStateID = 4 THEN 'good' WHEN et.TransStateID = 3 THEN 'bad' WHEN et.TransStateID IN (7,8,9) THEN 'inactive' ELSE 'active' END AS Class,
et.LastModifyUser AS Operator
FROM ExternalTrans et JOIN TransStates ts ON (et.TransStateID = ts.TransStateID)
	JOIN TransTypes tt ON (et.TransTypeID = tt.TransTypeID)
	WHERE @showtype & 4 = 4
	AND et.CustomerID = @CustomerID
	AND et.ReqDate > @sd

UNION ALL

SELECT nl.LogDate, 'Notice (' + n.Notice + ')' AS Type, NULL, COALESCE(nl.ErrorMessage,'Message sent to ' + nl.Email), nl.NoticeLogID, 'none' AS URL, CASE WHEN nl.ErrorMessage IS NULL THEN '' ELSE 'bad' END AS Class, NULL AS Operator
FROM NoticeLogs nl JOIN Notices n ON (nl.NoticeID = n.NoticeID)
	WHERE @showtype & 8 = 8
	AND nl.CustomerID = @CustomerID
	AND nl.LogDate > @sd

UNION ALL

SELECT l.LogDate, lm.LogMsg AS Type, NULL AS Amount, l.LogMsg AS Description, 0 AS ID, 'none' AS URL, '' AS Class, l.Operator
FROM AuditLogs l JOIN LogMsgs lm ON (l.LogMsgID = lm.LogMsgID)
	WHERE @showtype & 8 = 8
	AND l.CustomerID = @CustomerID
	AND l.LogDate > @sd
GO

CREATE PROCEDURE dbo.IISExport (@esid INT, @filemode INT) AS
SET NOCOUNT ON
DECLARE @incremental INT, @port INT, @ipaddress INT, @hostname INT, @description INT, @homedir INT
SELECT @incremental = CASE WHEN @filemode = 1 THEN 1 WHEN @filemode = 2 THEN 0 ELSE 1 END

SELECT @port = 1000, @hostname = 8, @ipaddress = 10, @description = 1001, @homedir = 2

SELECT sa.AccountID, CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Active, 
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @homedir) AS Path,
at1.AccountType,
COALESCE((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @description),ab.Company + ' (' + CAST(sa.AccountID AS VARCHAR(16)) + ')',a.FirstName + ' ' + a.LastName + ' (' + CAST(sa.AccountID AS VARCHAR(16)) + ')') AS Description,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @port) AS Port,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @hostname) AS Hostname,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @ipaddress) AS IPAddress
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @esid)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.ExternalSystemID = @esid
	AND (es.LastSyncDate IS NULL OR ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)
	AND (SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @homedir) IS NOT NULL
	AND (SELECT COUNT(*) FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.AccountDataTypeID IN (@port,@ipaddress,@hostname) AND sad.Data <> ' ') > 0
GO

CREATE PROCEDURE dbo.IMailSetUser (@esid INT, @username VARCHAR(40), @domain VARCHAR(64), @attribute VARCHAR(64), @value VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @DomainID INT, @AccountID INT, @DataTypeID INT, @nid int, @oldpassword VARCHAR(32)
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain

IF (@DomainID IS NOT NULL)
BEGIN
SELECT @AccountID = MAX(sa.AccountID)
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	WHERE sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email))
	AND esat.ExternalSystemID = @esid
END

IF (@AccountID IS NOT NULL)
BEGIN
IF (@attribute = 'MaxSize')
	BEGIN
	SELECT @DataTypeID = 3
	END ELSE IF (@attribute = 'Password' AND @value IS NOT NULL AND DATALENGTH(@value) > 3)
	BEGIN
	SELECT @oldpassword = Password FROM SubAccounts WHERE AccountID = @AccountID
	UPDATE SubAccounts SET Password = @value WHERE AccountID = @AccountID
	END ELSE IF (@attribute IS NOT NULL)
	BEGIN
	SELECT @DataTypeID = MAX(DataTypeID)
	FROM AccountDataTypes adt 
		WHERE AccountDataTypeID BETWEEN 900 AND 999
		AND AccountDataType  = @attribute
	END

IF (@DataTypeID IS NOT NULL)
	BEGIN
	UPDATE SubAccountData SET Data = @value WHERE AccountID = @AccountID AND AccountDataTypeID = @DataTypeID
	IF (@@ROWCOUNT = 0)
		BEGIN
		INSERT INTO SubAccountData (AccountID,AccountDataTypeID,Data)
		VALUES(@AccountID,@DataTypeID,@value)
		END
	END
END
GO

CREATE PROCEDURE dbo.IMailUsers (@esid INT, @username varchar(40), @domain varchar(64)) AS
DECLARE @DomainID INT, @AccountID INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain

IF (@username IS NULL) 
BEGIN
SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, a.FirstName + ' ' + a.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + @domain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN SubAccountData adt900 ON (adt900.AccountID = @AccountID AND adt900.AccountDataTypeID = 900)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID = sa.AccountID AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID = sa.AccountID AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID = sa.AccountID AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID = sa.AccountID AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID = sa.AccountID AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID = sa.AccountID AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID = sa.AccountID AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID = sa.AccountID AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID = sa.AccountID AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID = sa.AccountID AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID = sa.AccountID AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID = sa.AccountID AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID = sa.AccountID AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID = sa.AccountID AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID = sa.AccountID AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID = sa.AccountID AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID = sa.AccountID AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID = sa.AccountID AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID = sa.AccountID AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID = sa.AccountID AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID = sa.AccountID AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID = sa.AccountID AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID = sa.AccountID AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID = sa.AccountID AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID = sa.AccountID AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID = sa.AccountID AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID = sa.AccountID AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID = sa.AccountID AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID = sa.AccountID AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID = sa.AccountID AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID = sa.AccountID AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID = sa.AccountID AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID = sa.AccountID AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID = sa.AccountID AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID = sa.AccountID AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID = sa.AccountID AND adt936.AccountDataTypeID = 936)
	WHERE esat.ExternalSystemID = @esid
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ((sa.Login <> ' ' AND sa.DomainID = @DomainID) 
		OR (sa.Email LIKE '%_@' + @domain))
	AND sa.Active = 1 
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

END ELSE BEGIN

SELECT @AccountID = MAX(sa.AccountID)
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @esid)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email)
		OR (@username + '@' + @domain IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)))

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, a.FirstName + ' ' + a.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + @domain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa LEFT JOIN SubAccountData adt900 ON (adt900.AccountID = @AccountID AND adt900.AccountDataTypeID = 900)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID = @AccountID AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID = @AccountID AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID = @AccountID AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID = @AccountID AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID = @AccountID AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID = @AccountID AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID = @AccountID AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID = @AccountID AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID = @AccountID AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID = @AccountID AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID = @AccountID AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID = @AccountID AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID = @AccountID AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID = @AccountID AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID = @AccountID AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID = @AccountID AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID = @AccountID AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID = @AccountID AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID = @AccountID AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID = @AccountID AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID = @AccountID AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID = @AccountID AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID = @AccountID AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID = @AccountID AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID = @AccountID AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID = @AccountID AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID = @AccountID AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID = @AccountID AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID = @AccountID AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID = @AccountID AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID = @AccountID AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID = @AccountID AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID = @AccountID AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID = @AccountID AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID = @AccountID AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID = @AccountID AND adt936.AccountDataTypeID = 936)
	WHERE sa.AccountID = @AccountID
END
GO

CREATE PROCEDURE dbo.IncidentRelatedDelete (@IncidentID INT) AS
SET NOCOUNT ON
DELETE FROM Files WHERE IncidentID = @IncidentID
DELETE FROM IncidentData WHERE IncidentID = @IncidentID
DELETE FROM Actions WHERE IncidentID = @IncidentID
GO

CREATE PROCEDURE dbo.IncidentActionList (@IncidentID INT, @OperatorID INT, @access INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT a.ActionID,a.CreateDate, COALESCE(o.Operator,ac.FirstName + ' ' + ac.LastName,'N/A') AS Operator, a.Description,a.LastModifyDate,a.LastModifyUser, it1.IncidentType, it1.StringID AS it1StringID,  is1.IncidentState, a.Duration, CASE WHEN i.CustomerAccess = 1 AND a.CustomerAccess = 1 THEN 1 ELSE 0 END AS CustomerAccess, ar.Role AS AssignRole, ao.Operator AS AssignOperator, CASE WHEN @access = 2 OR (@access = 1 AND a.CreateOperatorID = @OperatorID) THEN 1 ELSE 0 END AS AllowEdit
FROM Actions a JOIN IncidentStates is1 ON (a.IncidentStateID = is1.IncidentStateID)
	JOIN IncidentTypes it1 ON (a.IncidentTypeID = it1.IncidentTypeID)
	JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Roles ar ON (a.AssignRoleID = ar.RoleID)
	LEFT JOIN Operators ao ON (a.AssignOperatorID = ao.OperatorID)
	LEFT JOIN SubAccounts sa ON (a.CreateAccountID = sa.AccountID)
	LEFT JOIN Addresses ac ON (sa.ContactAddressID = ac.AddressID)
	LEFT JOIN Operators o ON (a.CreateOperatorID = o.OperatorID)
	WHERE a.IncidentID = @IncidentID
	AND (a.Description IS NOT NULL OR a.Duration <> 0)
	AND ma.Active IN (1,0)
GO

CREATE PROCEDURE dbo.IncidentAssign (@RoleID INT, @GroupID INT, @AccountID INT) AS
SET NOCOUNT ON
DECLARE @iGroupID INT, @RoleAssignTypeID INT
SELECT @iGroupID = CASE WHEN @GroupID IN (1,0) THEN NULL ELSE @GroupID END
SELECT @RoleAssignTypeID = COALESCE(RoleAssignTypeID,1) FROM Roles WHERE RoleID = @RoleID

CREATE TABLE #inatmp (OperatorRoleID INT, Cnt INT)

IF (@RoleAssignTypeID = 1)
BEGIN
INSERT INTO #inatmp (OperatorRoleID, Cnt)
SELECT or1.OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1 JOIN Incidents i ON (or1.OperatorID = i.AssignOperatorID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 0
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION ALL
SELECT or1.OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1 JOIN Incidents i ON (or1.RoleID = i.AssignRoleID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID = @RoleID
	AND (GroupID IS NULL OR GroupID = @iGroupID)
END

IF (@RoleAssignTypeID = 2)
BEGIN
INSERT INTO #inatmp (OperatorRoleID, Cnt)
SELECT or1.OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1 JOIN Incidents i ON (or1.OperatorID = i.AssignOperatorID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CreateDate > DATEADD(dd,-20,getdate())
	AND is1.StatEscalate = 0
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION ALL
SELECT or1.OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1 JOIN Incidents i ON (or1.RoleID = i.AssignRoleID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CreateDate > DATEADD(dd,-20,getdate())
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID = @RoleID
	AND (GroupID IS NULL OR GroupID = @iGroupID)
END

IF (@RoleAssignTypeID = 15)
BEGIN
SELECT @RoleAssignTypeID AS RoleAssignTypeID, NULL AS OperatorRoleID, RoleID, NULL AS OperatorID, 1 AS Tier, 0 AS TargetRatio, 0 AS MaxRatio
FROM Roles
	WHERE RoleID = @RoleID
	AND (GroupID IS NULL OR GroupID = @iGroupID)
END ELSE BEGIN
SELECT TOP 1 @RoleAssignTypeID AS RoleAssignTypeID, t.OperatorRoleID, MAX(or1.RoleID) AS RoleID, MAX(or1.OperatorID) AS OperatorID, MAX(or1.Tier) AS Tier, SUM(t.Cnt) / CAST (MAX(or1.TargetActive) AS NUMERIC) AS TargetRatio, SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) AS MaxRatio
FROM #inatmp t JOIN OperatorRoles or1 ON (t.OperatorRoleID = or1.OperatorRoleID)
	WHERE (or1.TargetActive IS NULL OR or1.TargetActive > 0)
	AND (or1.MaxActive IS NULL OR or1.MaxActive > 0)
GROUP BY t.OperatorRoleID
ORDER BY CASE WHEN SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) > 1 THEN 1 ELSE 0 END ASC, MAX(or1.Tier) ASC, SUM(t.Cnt) / CAST(MAX(or1.TargetActive) AS NUMERIC) ASC
END
GO

CREATE PROCEDURE dbo.IncidentAssignList (@OperatorID INT, @viewopt INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@viewopt = 1)
BEGIN
SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o JOIN OperatorRoles r ON (o.OperatorID = r.OperatorID)
	WHERE r.RoleID IN (SELECT RoleID FROM OperatorRoles WHERE OperatorID = @OperatorID)
	AND o.Active = 1
	AND o.OperatorID <> @OperatorID
ORDER BY 2 ASC
END

IF (@viewopt = 2)
BEGIN
SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o 
	WHERE o.OperatorID IN (SELECT OperatorID FROM OperatorRoles)
	AND o.Active = 1
	AND o.OperatorID <> @OperatorID
ORDER BY 2 ASC
END
GO

CREATE PROCEDURE dbo.IncidentAssignSched (@RoleID INT, @IncidentTypeID INT, @SchedBlockID INT, @SchedDate DATETIME, @CustomerID INT, @AccountID INT, @IncidentID INT, @GroupID INT) AS
SET NOCOUNT ON
DECLARE @TimeUnits INT, @RoleTypeID INT, @RoleAssignTypeID INT, @AddressID INT, @DstLat FLOAT, @DstLong FLOAT
CREATE TABLE #ias (OperatorID INT, AllocTimeUnits INT, ApptCount INT)

SELECT @SchedDate = DATEADD(ms,-DATEPART(ms,@SchedDate),DATEADD(ss,-((DATEPART(hh,@SchedDate)*3600)+(DATEPART(mi,@SchedDate)*60)+DATEPART(ss,@SchedDate)),@SchedDate))
SELECT @TimeUnits = TimeUnits FROM IncidentTypes WHERE IncidentTypeID = @IncidentTypeID
SELECT @RoleTypeID = RoleTypeID, @RoleAssignTypeID = RoleAssignTypeID FROM Roles WHERE RoleID = @RoleID

IF (@RoleTypeID = 8)
BEGIN
SELECT @AddressID = BillingAddressID FROM MasterAccounts WHERE CustomerID = @CustomerID
END

IF (@RoleTypeID = 4 AND @AccountID IS NULL)
BEGIN
SELECT @AddressID = ServiceAddressID FROM MasterAccounts WHERE CustomerID = @CustomerID
END

IF (@RoleTypeID = 4 AND @AccountID IS NOT NULL)
BEGIN
SELECT @AddressID = ServiceAddressID FROM SubAccounts WHERE CustomerID = @CustomerID AND AccountID = @AccountID
END

SELECT @DstLat = CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END, @DstLong = CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END
FROM Addresses a LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	WHERE a.AddressID = @AddressID

INSERT INTO #ias (OperatorID, AllocTimeUnits, ApptCount)
SELECT i.AssignOperatorID, SUM(it.TimeUnits), COUNT(*)
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Operators o ON (i.AssignOperatorID = o.OperatorID)
	JOIN OperatorScheds os ON (i.AssignOperatorID = os.OperatorID AND os.SchedBlockID = @SchedBlockID)
	JOIN SchedBlocks sb ON (sb.SchedBlockID = @SchedBlockID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	WHERE i.SchedDate >= @SchedDate 
	AND i.SchedDate < DATEADD(dd,1,@SchedDate)
	AND i.SchedBlockID = @SchedBlockID
	AND (@IncidentID IS NULL OR i.IncidentID <> @IncidentID)
	AND is1.StatOpen = 1
	AND it.TimeUnits >= 0
	AND o.Active = 1
	AND sb.Active = 1
GROUP BY i.AssignOperatorID

SELECT or1.OperatorID, DATEADD(mi,COALESCE(sb.StartMinute,0),DATEADD(hh,COALESCE(sb.StartHour,0),@SchedDate)) AS CurDate, or1.MaxDistance, or1.Tier, @DstLat AS DstLat, @DstLong AS DstLong,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS SrcLat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS SrcLong,
COALESCE(ias.AllocTimeUnits,0) AS AllocTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) AS MaxTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) - COALESCE(ias.AllocTimeUnits,0) AS RemainingTimeUnits, COALESCE(ias.ApptCount,0) AS ApptCount, CASE WHEN ias.ApptCount IS NULL THEN 0 ELSE 1 END AS HaveAppt, 1 AS Operator, @RoleAssignTypeID AS RoleAssignTypeID
FROM OperatorRoles or1 JOIN OperatorScheds os ON (or1.OperatorID = os.OperatorID)
	LEFT JOIN #ias ias ON (or1.OperatorID = ias.OperatorID)
	JOIN SchedBlocks sb ON (os.SchedBlockID = sb.SchedBlockID)
	JOIN Operators o ON (or1.OperatorID = o.OperatorID AND sb.SchedBlockTypeID = o.SchedBlockTypeID)
	LEFT JOIN Sites s ON (os.SiteID = s.SiteID)
	LEFT JOIN Addresses a ON (s.PhysicalAddressID = a.AddressID)
	LEFT JOIN AddressSyncs as1 ON (s.PhysicalAddressID = as1.AddressID AND as1.ExportStatus = 1)
	WHERE or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @GroupID)
	AND os.SchedBlockID = @SchedBlockID
	AND o.Active = 1
	AND COALESCE(ias.AllocTimeUnits,0) + @TimeUnits <= COALESCE(os.TimeUnits,sb.TimeUnits)

UNION ALL

SELECT or1.OperatorID, DATEADD(mi,COALESCE(sb.StartMinute,0),DATEADD(hh,COALESCE(sb.StartHour,0),@SchedDate)) AS CurDate, or1.MaxDistance, or1.Tier, @DstLat AS DstLat, @DstLong AS DstLong,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS SrcLat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS SrcLong,
COALESCE(ias.AllocTimeUnits,0) AS AllocTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) AS MaxTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) - COALESCE(ias.AllocTimeUnits,0) AS RemainingTimeUnits, COALESCE(ias.ApptCount,0) AS ApptCount, CASE WHEN ias.ApptCount IS NULL THEN 0 ELSE 1 END AS HaveAppt, 0 AS Operator, @RoleAssignTypeID AS RoleAssignTypeID
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Operators o ON (i.AssignOperatorID = o.OperatorID)
	JOIN OperatorRoles or1 ON (i.AssignOperatorID = or1.OperatorID AND i.AssignRoleID = or1.RoleID)
	JOIN #ias ias ON (or1.OperatorID = ias.OperatorID)
	JOIN OperatorScheds os ON (i.AssignOperatorID = os.OperatorID AND os.SchedBlockID = @SchedBlockID)
	JOIN SchedBlocks sb ON (sb.SchedBlockID = @SchedBlockID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	WHERE i.SchedDate >= @SchedDate 
	AND i.SchedDate < DATEADD(dd,1,@SchedDate)
	AND i.SchedBlockID = @SchedBlockID
	AND (@IncidentID IS NULL OR i.IncidentID <> @IncidentID)
	AND is1.StatOpen = 1
	AND it.TimeUnits >= 0
	AND o.Active = 1
	AND sb.Active = 1
	AND @RoleTypeID = 8
	AND ((as1.Lat IS NOT NULL AND as1.Long IS NOT NULL) OR (a.Lat IS NOT NULL AND a.Long IS NOT NULL))
	AND @DstLat IS NOT NULL
	AND @DstLong IS NOT NULL

UNION ALL

SELECT or1.OperatorID, DATEADD(mi,COALESCE(sb.StartMinute,0),DATEADD(hh,COALESCE(sb.StartHour,0),@SchedDate)) AS CurDate, or1.MaxDistance, or1.Tier, @DstLat AS DstLat, @DstLong AS DstLong,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS SrcLat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS SrcLong,
COALESCE(ias.AllocTimeUnits,0) AS AllocTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) AS MaxTimeUnits, COALESCE(os.TimeUnits,sb.TimeUnits) - COALESCE(ias.AllocTimeUnits,0) AS RemainingTimeUnits, COALESCE(ias.ApptCount,0) AS ApptCount, CASE WHEN ias.ApptCount IS NULL THEN 0 ELSE 1 END AS HaveAppt, 0 AS Operator, @RoleAssignTypeID AS RoleAssignTypeID
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Operators o ON (i.AssignOperatorID = o.OperatorID)
	JOIN OperatorRoles or1 ON (i.AssignOperatorID = or1.OperatorID AND i.AssignRoleID = or1.RoleID)
	JOIN #ias ias ON (or1.OperatorID = ias.OperatorID)
	JOIN OperatorScheds os ON (i.AssignOperatorID = os.OperatorID AND os.SchedBlockID = @SchedBlockID)
	JOIN SchedBlocks sb ON (sb.SchedBlockID = @SchedBlockID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	WHERE i.SchedDate >= @SchedDate 
	AND i.SchedDate < DATEADD(dd,1,@SchedDate)
	AND i.SchedBlockID = @SchedBlockID
	AND (@IncidentID IS NULL OR i.IncidentID <> @IncidentID)
	AND is1.StatOpen = 1
	AND it.TimeUnits >= 0
	AND o.Active = 1
	AND sb.Active = 1
	AND @RoleTypeID = 4
	AND ((as1.Lat IS NOT NULL AND as1.Long IS NOT NULL) OR (a.Lat IS NOT NULL AND a.Long IS NOT NULL))
	AND @DstLat IS NOT NULL
	AND @DstLong IS NOT NULL
GO

CREATE PROCEDURE dbo.IncidentChangeTypeData (@IncidentID INT, @newIncidentTypeID INT) AS
SET NOCOUNT ON
CREATE TABLE #ictd (SrcIncidentDataTypeID INT, DstIncidentDataTypeID INT, DstData VARCHAR(255))

INSERT INTO #ictd (SrcIncidentDataTypeID,DstIncidentDataTypeID,DstData)
SELECT it1.IncidentDataTypeID, it2.IncidentDataTypeID, COALESCE(CAST(iv2.NumValue AS VARCHAR(10)),id1.Data)
FROM Incidents i JOIN IncidentDataTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentDataTypes it2 ON (it1.IncidentDataType = it2.IncidentDataType AND it2.IncidentTypeID = @newIncidentTypeID)
	JOIN IncidentData id1 ON (i.IncidentID = id1.IncidentID AND it1.IncidentDataTypeID = id1.IncidentDataTypeID)
	LEFT JOIN IncidentValues iv1 ON (it1.IncidentDataTypeID = iv1.IncidentDataTypeID AND it1.DataTypeID = 2 AND id1.Data = CAST(iv1.NumValue AS VARCHAR(10)))
	LEFT JOIN IncidentValues iv2 ON (it2.IncidentDataTypeID = iv2.IncidentDataTypeID AND it2.DataTypeID = 2 AND iv1.ValueName = iv2.ValueName)
	WHERE i.IncidentID = @IncidentID
	AND id1.Data IS NOT NULL
	AND it1.IncidentDataTypeID <> it2.IncidentDataTypeID
	AND it1.DataTypeID = it2.DataTypeID
	AND (	(it1.DataTypeID IN (0,1) AND it2.DataTypeID IN (0,1))
	OR	(it1.DataTypeID = 3 AND CAST(it1.SQLQuery AS VARCHAR(255)) = CAST(it2.SQLQuery AS VARCHAR(255)))
	OR	(it1.DataTypeID = 2 AND iv2.NumValue IS NOT NULL))

DELETE FROM IncidentData 
	WHERE IncidentID = @IncidentID 
	AND IncidentDataTypeID IN (SELECT DstIncidentDataTypeID FROM #ictd)

UPDATE IncidentData SET IncidentDataTypeID = i.DstIncidentDataTypeID, Data = i.DstData
FROM IncidentData id1 JOIN #ictd i ON (id1.IncidentDataTypeID = i.SrcIncidentDataTypeID)
	WHERE id1.IncidentID = @IncidentID
GO

CREATE PROCEDURE dbo.IncidentDataFields (@IncidentTypeID INT, @IncidentID INT, @CustomerAccess TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT idt.SQLQuery,idt.RegExp,COALESCE(idt.Required,0) AS Required,idt.IncidentDataTypeID,idt.IncidentDataType,idt.DataTypeID, id1.Data, COALESCE(iv.ValueName,id1.Data) AS ValueName, it1.IncidentEdit, it1.IncidentSave, it1.CustIncidentEdit, it1.CustIncidentSave
FROM IncidentDataTypes idt
	LEFT JOIN IncidentData id1 ON (id1.IncidentID = @IncidentID AND id1.IncidentDataTypeID = idt.IncidentDataTypeID)
	LEFT JOIN IncidentValues iv ON (id1.IncidentDataTypeID = iv.IncidentDataTypeID AND CAST(iv.NumValue AS VARCHAR(20)) = id1.Data)
	LEFT JOIN IncidentTemplates it1 ON (idt.IncidentTemplateID = it1.IncidentTemplateID)
	WHERE idt.IncidentTypeID = @IncidentTypeID
	AND (@CustomerAccess IS NULL OR (@CustomerAccess = 1 AND idt.CustomerAccess = 1))
ORDER BY idt.SortOrder,idt.IncidentDataType
GO

CREATE PROCEDURE dbo.IncidentDataLoader (@IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT IncidentDataTypeID,Data
FROM IncidentData
	WHERE IncidentID = @IncidentID
GO

CREATE PROCEDURE dbo.IncidentEventList (@IncidentTypeID INT, @CustomerID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @EventID INT, @GroupID INT, @RegionID INT
SELECT @EventID = EventID FROM Incidents WHERE IncidentID = @IncidentID
SELECT @GroupID = GroupID, @RegionID = RegionID FROM MasterAccounts WHERE CustomerID = @CustomerID

SELECT e.EventID, e.Event, et.SortOrder, et.EventType, et.StringID AS etStringID, CASE WHEN e.Active = 0 OR e.CloseDate < getdate() THEN 'inactive' END AS Class
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.MarketTagID = e.MarketTagID AND mat.Active = 1)
	WHERE et.IncidentTypeID = @IncidentTypeID
	AND e.Active = 1 
	AND (e.CloseDate IS NULL OR e.CloseDate > DATEADD(dd,-2,getdate()))
	AND (e.GroupID IS NULL OR e.GroupID = @GroupID)
	AND (e.RegionID IS NULL OR e.RegionID = @RegionID)
	AND (e.MarketTagID IS NULL OR mat.MarketTagID IS NOT NULL)

UNION

SELECT e.EventID, e.Event, et.SortOrder, et.EventType, et.StringID AS etStringID, CASE WHEN e.Active = 0 OR e.CloseDate < getdate() THEN 'inactive' END AS Class
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	WHERE e.EventID = @EventID

ORDER BY et.SortOrder, et.EventType, e.Event
GO

CREATE PROCEDURE dbo.IncidentList (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT i.IncidentID, i.IncidentTypeID, CASE WHEN is1.StatOpen = 1 THEN i.PriorityID ELSE -10000 END AS Pri, i.CreateDate, p.StringID AS pStringID, p.Priority,
COALESCE(co.Operator,csa.Login,csaa.FirstName + ' ' + csaa.LastName) AS Operator, ao.Operator AS AssignOperator, ar.Role AS AssignRole,
CAST(COALESCE(i.Summary,i.Description) AS VARCHAR(512)) AS Summary,
COALESCE(is1.Style,CASE WHEN is1.StatOpen = 1 AND is1.StatEscalate = 1 THEN 'escalated' WHEN is1.StatOpen = 1 AND is1.StatWait = 0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen = 1 THEN 'open' WHEN is1.StatArchive = 1 THEN 'archived' WHEN is1.StatBlock = 1 THEN 'blocking' WHEN is1.StatOpen = 0 THEN 'closed' ELSE 'normal' END) AS Class,
is1.IncidentState, it.IncidentType, it.StringID AS itStringID, e.Event, i.SchedDate, sb.SchedBlock, sa.Login, sbt.StringID AS sbtStringID, sbt.SchedBlockType
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN Events e ON (i.EventID = e.EventID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
	LEFT JOIN SubAccounts csa ON (i.CreateAccountID = csa.AccountID)
	LEFT JOIN Addresses csaa ON (csa.ContactAddressID = csaa.AddressID)
	LEFT JOIN Roles ar ON (i.AssignRoleID = ar.RoleID)
	LEFT JOIN Operators ao ON (i.AssignOperatorID = ao.OperatorID)
	LEFT JOIN SchedBlocks sb ON (i.SchedBlockID = sb.SchedBlockID)
	LEFT JOIN SchedBlockTypes sbt ON (sb.SchedBlockTypeID = sbt.SchedBlockTypeID)
	WHERE i.CustomerID = @CustomerID
	AND (@AccountID IS NULL OR i.AccountID = @AccountID)
GO

CREATE PROCEDURE dbo.IncidentLoader (@IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT i.IncidentID, i.AccountID AS iAccountID, i.CreateDate,COALESCE(o.Operator,sa.Login,a.FirstName + ' ' + a.LastName) AS CreateUser, i.LastModifyDate, i.LastModifyUser, i.IncidentTypeID, i.IncidentStateID, i.EventID, i.Summary, i.Description, i.CustomerAccess, i.Duration, i.Email, AssignRoleID, i.AssignOperatorID, i.DueDate, i.PriorityID, i.SchedBlockID, i.SchedDate
FROM Incidents i LEFT JOIN Operators o ON (i.CreateOperatorID = o.OperatorID)
	LEFT JOIN SubAccounts sa ON (i.CreateAccountID = sa.AccountID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE i.IncidentID = @IncidentID
GO

CREATE PROCEDURE dbo.IncidentReassign (@RoleID INT, @OperatorID INT, @NewOperatorID INT, @assigntype INT) AS
SET NOCOUNT ON
IF (@assigntype = 1)
BEGIN
UPDATE Incidents SET AssignOperatorID = @NewOperatorID 
	WHERE AssignRoleID = @RoleID 
	AND AssignOperatorID = @OperatorID
	AND IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1)
END

IF (@assigntype = 2)
BEGIN
UPDATE Incidents SET AssignOperatorID = @NewOperatorID WHERE AssignRoleID = @RoleID AND AssignOperatorID = @OperatorID
END
GO

CREATE PROCEDURE dbo.IncidentSchedInfo (@IncidentID INT) AS
SET NOCOUNT ON
SELECT SchedBlockID, SchedDate 
FROM Incidents
	WHERE IncidentID = @IncidentID
GO

CREATE PROCEDURE dbo.IncidentShow (@GroupID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT i.IncidentID,i.AccountID,i.CreateDate,i.IncidentTypeID,i.IncidentStateID,it1.IncidentType,COALESCE(Duration,0) + COALESCE((SELECT SUM(Duration) FROM Actions WHERE IncidentID=i.IncidentID AND Duration IS NOT NULL),0) AS TotalDuration,
CASE WHEN it1.ShowDueDate = 1 AND is1.StatOpen = 1 THEN COALESCE(CASE WHEN it1.ShowCustDueDate = 1 THEN i.DueDate ELSE NULL END,DATEADD(dd,it1.OverDays,i.CreateDate)) ELSE NULL END AS DueDate,
COALESCE(co.Operator,a.FirstName + ' ' + a.LastName,'N/A') AS Operator,i.Summary,i.Description,i.CustomerAccess,i.LastModifyDate,i.LastModifyUser,i.DueDate as CustDueDate,
AssignRoleID,AssignOperatorID,
COALESCE(r.[Role],'N/A') AS AssignRole,
COALESCE(o.Operator,'N/A') AS AssignOperator,it1.ShowPriority,it1.ShowEmail,it1.ShowDuration,i.Duration,i.Email,it1.ShowSummary,i.PriorityID,it1.ShowCustomerAccess,it1.ShowCustDueDate
FROM Incidents i JOIN IncidentTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN SubAccounts sac ON (i.CreateAccountID = sac.AccountID)
	LEFT JOIN Addresses a ON (sac.ContactAddressID = a.AddressID)
	LEFT JOIN Operators o ON (i.AssignOperatorID = o.OperatorID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
	LEFT JOIN Roles r ON (i.AssignRoleID = r.RoleID)
	WHERE i.IncidentID = @IncidentID
	AND ma.GroupID = @GroupID
	AND ma.Active IN (1,0)
GO

CREATE PROCEDURE dbo.IncidentTypeSettings (@IncidentTypeID INT) AS
SET NOCOUNT ON

SELECT Email, RoleID, CustomerAccess, ShowPriority, ShowEmail, ShowDuration, ShowDueDate, ShowCustomerAccess, ShowSummary, ShowCustDueDate, ShowAssignOperator, EnableOperatorRole, SchedBlockTypeID, SchedLimitDays, SchedMinDays
FROM IncidentTypes
	WHERE IncidentTypeID = @IncidentTypeID
GO

CREATE PROCEDURE dbo.InfoBarShow (@OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ib1 INT, @ib1_cnt INT, @ib2 INT, @ib2_cnt INT, @ib3 INT, @ib3_cnt INT, @ib4 INT, @ib4_cnt INT, @ib5 INT

SELECT	@ib1 = MAX(CASE WHEN ib.InfoBarID = 1 THEN COALESCE(ibo.Active,ibog.Active,1) ELSE 0 END),
	@ib2 = MAX(CASE WHEN ib.InfoBarID = 2 THEN COALESCE(ibo.Active,ibog.Active,1) ELSE 0 END),
	@ib3 = MAX(CASE WHEN ib.InfoBarID = 3 THEN COALESCE(ibo.Active,ibog.Active,0) ELSE 0 END),
	@ib4 = MAX(CASE WHEN ib.InfoBarID = 4 THEN COALESCE(ibo.Active,ibog.Active,0) ELSE 0 END),
	@ib5 = MAX(CASE WHEN ib.InfoBarID = 5 THEN COALESCE(ibo.Active,ibog.Active,1) ELSE 0 END)
FROM InfoBars ib JOIN Operators o ON (o.OperatorID = @OperatorID)
	LEFT JOIN InfoBarOperatorGroups ibog ON (o.OperatorGroupID = ibog.OperatorGroupID AND ib.InfoBarID = ibog.InfoBarID)
	LEFT JOIN InfoBarOperators ibo ON (o.OperatorID = ibo.OperatorID AND ib.InfoBarID = ibo.InfoBarID)

IF (@ib1 = 1 OR @ib2 = 1)
BEGIN
SELECT @ib1_cnt = SUM(CASE WHEN i.SchedBlockID IS NULL THEN 1 ELSE 0 END), @ib2_cnt = SUM(CASE WHEN i.SchedBlockID IS NOT NULL THEN 1 ELSE 0 END)
FROM Incidents i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	WHERE i.AssignOperatorID = @OperatorID
	AND i.IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1)
	AND ma.Active IN (1,0)
OPTION (FORCE ORDER)
END

IF (@ib3 = 1)
BEGIN
SELECT @ib3_cnt = COUNT(*) FROM Events WHERE Active = 1
END

IF (@ib4 = 1)
BEGIN
SELECT @ib4_cnt = COUNT(*)
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	WHERE et.TransStateID IN (0,1,2)
	AND ma.Active = 1
END


SELECT InfoBarID, InfoBar, StringID, Class, Link, AccessLabel, FeatureID, @ib1_cnt AS Cnt
FROM InfoBars
	WHERE InfoBarID = 1
	AND @ib1 = 1
	AND @ib1_cnt > 0

UNION ALL

SELECT InfoBarID, InfoBar, StringID, Class, Link, AccessLabel, FeatureID, @ib2_cnt
FROM InfoBars
	WHERE InfoBarID = 2
	AND @ib2 = 1
	AND @ib2_cnt > 0

UNION ALL

SELECT InfoBarID, InfoBar, StringID, Class, Link, AccessLabel, FeatureID, @ib3_cnt
FROM InfoBars
	WHERE InfoBarID = 3
	AND @ib3 = 1
	AND @ib3_cnt > 0

UNION ALL

SELECT InfoBarID, InfoBar, StringID, Class, Link, AccessLabel, FeatureID, @ib4_cnt
FROM InfoBars
	WHERE InfoBarID = 4
	AND @ib4 = 1
	AND @ib4_cnt > 0

UNION ALL

SELECT ib.InfoBarID, og.InfoMessage AS InfoBar, NULL AS StringID, ib.Class, ib.Link, ib.AccessLabel, ib.FeatureID, NULL AS Cnt
FROM Operators o JOIN OperatorGroups og ON (o.OperatorGroupID = og.OperatorGroupID)
	JOIN InfoBars ib ON (ib.InfoBarID = 5)
	WHERE o.OperatorID = @OperatorID
	AND og.InfoMessage IS NOT NULL
	AND (og.InfoExpireDate IS NULL OR og.InfoExpireDate > getdate())
	AND @ib5 = 1
GO

CREATE PROCEDURE dbo.InvCartItemAdd (@OperatorID INT, @InvItemID INT, @add INT) AS
SET NOCOUNT ON
DECLARE @InvCartID INT
SELECT @InvCartID = InvCartID FROM Operators WHERE OperatorID = @OperatorID

IF (@InvCartID IS NOT NULL)
BEGIN
IF (@add = 0)
	BEGIN
	DELETE FROM InvCartItems WHERE InvCartID = @InvCartID AND InvItemID = @InvItemID
	END

IF (@add = 1)
	BEGIN
	INSERT INTO InvCartItems (InvCartID,InvItemID,CreateInvStateID,CreateInvWarehouseID)
	SELECT @InvCartID,InvItemID,InvStateID,InvWarehouseID
	FROM InvItems
		WHERE InvItemID = @InvItemID
		AND NOT EXISTS (SELECT * FROM InvCartItems WHERE InvItemID = @InvItemID AND InvCartID = @InvCartID)
	END
END
GO

CREATE PROCEDURE dbo.InvCartItemUpdate (@InvItemID INT, @InvWarehouseID INT, @InvStateID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE ii SET InvWarehouseID = @InvWarehouseID, InvStateID = CASE WHEN @InvStateID IS NULL OR @InvStateID = -1 THEN ii.InvStateID ELSE @InvStateID END
FROM InvItems ii JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	WHERE ii.InvItemID = @InvItemID
	AND (COALESCE(ii.InvWarehouseID,0) <> COALESCE(@InvWarehouseID,0) OR (@InvStateID IS NOT NULL AND @InvStateID <> -1 AND ii.InvStateID <> @InvStateID))
	AND (is1.InvStateTypeID IN (1,2) OR (is1.InvStateTypeID = 4 AND ii.ItemID IS NULL AND ii.AccountID IS NULL))

IF (@@ROWCOUNT <> 0)
BEGIN
EXEC InvItemLog @InvItemID, @Operator
END
GO

CREATE PROCEDURE dbo.InvCartGet (@InvCartID INT) AS
SET NOCOUNT ON
SELECT ii.InvItemID, ii.InvStateID, is1.InvState, ii.InvWarehouseID, iso.InvStateGroupID, ip.Title, ic.InvCategory, isc.InvSubCategory, ii.SerialNumber, COALESCE(ii.Cost,ip.Cost) AS Cost, ip.SKU, ip.EAN, ip.ModelNumber,
CASE WHEN is1.InvStateTypeID IN (1,2) THEN 1 WHEN is1.InvStateTypeID = 3 THEN 0 WHEN is1.InvStateTypeID = 4 AND ii.ItemID IS NULL AND ii.AccountID IS NULL THEN 1 ELSE 0 END AS ChangeState, ist.Class
FROM InvCartItems ici JOIN InvItems ii ON (ici.InvItemID = ii.InvItemID)
	JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvSources iso ON (ip.InvSourceID = iso.InvSourceID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	JOIN InvCategories ic ON (ip.InvCategoryID = ic.InvCategoryID)
	LEFT JOIN InvSubCategories isc ON (ip.InvSubCategoryID = isc.InvSubCategoryID)
	WHERE ici.InvCartID = @InvCartID
ORDER BY ic.SortOrder, isc.SortOrder, ip.SortOrder, ip.Title, ii.SerialNumber
GO

CREATE PROCEDURE dbo.InvCartList (@OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @CurrentInvCartID INT
SELECT @CurrentInvCartID = InvCartID FROM Operators WHERE OperatorID = @OperatorID

SELECT ic.InvCartID, MIN(ic.CreateDate) AS CreateDate, MIN(ic.InvCart) AS InvCart,
SUM(CASE WHEN is1.InvStateTypeID = 1 THEN 1 ELSE 0 END) AS Available,
SUM(CASE WHEN is1.InvStateTypeID = 2 THEN 1 ELSE 0 END) AS Reserved,
SUM(CASE WHEN is1.InvStateTypeID = 3 THEN 1 ELSE 0 END) AS Allocated,
SUM(CASE WHEN is1.InvStateTypeID = 4 THEN 1 ELSE 0 END) AS Unavailable,
CASE WHEN ic.InvCartID = @CurrentInvCartID THEN 1 ELSE 0 END AS IsCurrent
FROM InvCarts ic LEFT JOIN InvCartItems ici ON (ic.InvCartID = ici.InvCartID)
	LEFT JOIN InvItems ii ON (ici.InvItemID = ii.InvItemID)
	LEFT JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	WHERE ic.OperatorID = @OperatorID
GROUP BY ic.InvCartID
GO

CREATE PROCEDURE dbo.InvCartSec (@InvCartID INT, @OperatorID INT) AS
SET NOCOUNT ON
SELECT CreateDate, InvCart
FROM InvCarts
	WHERE InvCartID = @InvCartID
	AND OperatorID = @OperatorID
GO

CREATE PROCEDURE dbo.InvItemSetAttr (@MBRGlobal TINYINT, @OperatorGroupID INT, @InvProductID INT, @Product VARCHAR(255), @InvWarehouseID INT, @Warehouse VARCHAR(128), @InvStateID INT, @State VARCHAR(128), @SerialNumber VARCHAR(80), @InvAttribute VARCHAR(128), @Data VARCHAR(2048), @Operator VARCHAR(64)) AS
SET NOCOUNT ON

DECLARE @chkInvItemID INT, @chkInvProductID INT, @chkInvWarehouseID INT, @chkInvStateID INT
DECLARE @InvItemID INT,  @InvAttributeID INT, @InvValueID INT, @Retcode INT
SELECT @Retcode = 0

IF (@Retcode = 0 AND (@SerialNumber IS NULL OR @SerialNumber = ' '))
BEGIN
SELECT @Retcode = -3
END

IF (@Retcode = 0 AND @Product IS NOT NULL)
BEGIN

SELECT @InvProductID = MIN(InvProductID), @chkInvProductID = MAX(InvProductID)
FROM InvProducts
	WHERE Title = @Product
	AND GroupID IS NULL
	AND (GroupID IS NULL OR @MBRGlobal = 1 OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))

IF (@InvProductID IS NULL)
	BEGIN
	SELECT @Retcode = -5
	END
IF (@InvProductID IS NOT NULL AND @InvProductID <> @chkInvProductID)
	BEGIN
	SELECT @Retcode = -6
	END
END

IF (@Retcode = 0 AND (SELECT COUNT(*) FROM InvProducts WHERE InvProductID = @InvProductID) = 0)
BEGIN
SELECT @Retcode = -4
END

IF (@Retcode = 0 AND @InvWarehouseID IS NOT NULL AND @Warehouse IS NULL)
BEGIN
SELECT @chkInvWarehouseID = iwp.InvWarehouseID
FROM InvWarehouseProducts iwp
	WHERE iwp.InvProductID = @InvProductID
	AND iwp.InvWarehouseID = @InvWarehouseID

IF (@chkInvWarehouseID IS NULL)
	BEGIN
	SELECT @Retcode = -7
	END
END

IF (@Retcode = 0 AND @Warehouse IS NOT NULL)
BEGIN
SELECT @InvWarehouseID = MIN(iw.InvWarehouseID), @chkInvWarehouseID = MAX(iw.InvWarehouseID)
FROM InvWarehouses iw JOIN InvWarehouseProducts iwp ON (iw.InvWarehouseID = iwp.InvWarehouseID)
	WHERE iwp.InvProductID = @InvProductID
	AND iw.InvWarehouse = @Warehouse

IF (@InvWarehouseID IS NULL)
	BEGIN
	SELECT @Retcode = -7
	END
IF (@InvWarehouseID IS NOT NULL AND @InvWarehouseID <> @chkInvWarehouseID)
	BEGIN
	SELECT @Retcode = -8
	END
END

IF (@Retcode = 0 AND @InvStateID IS NOT NULL AND @State IS NULL)
BEGIN
SELECT @chkInvStateID = is1.InvStateID
FROM InvStates is1 JOIN InvSources src ON (is1.InvStateGroupID = src.InvStateGroupID)
	JOIN InvProducts ip ON (src.InvSourceID = ip.InvSourceID)
	WHERE ip.InvProductID = @InvProductID
	AND is1.InvStateID = @InvStateID

IF (@chkInvStateID IS NULL)
	BEGIN
	SELECT @Retcode = -9
	END
END

IF (@Retcode = 0 AND @State IS NOT NULL)
BEGIN

SELECT @InvStateID = MIN(is1.InvStateID), @chkInvStateID = MAX(is1.InvStateID)
FROM InvStates is1 JOIN InvSources src ON (is1.InvStateGroupID = src.InvStateGroupID)
	JOIN InvProducts ip ON (src.InvSourceID = ip.InvSourceID)
	WHERE ip.InvProductID = @InvProductID
	AND is1.InvState = @State

IF (@InvStateID IS NULL)
	BEGIN
	SELECT @Retcode = -9
	END
IF (@InvStateID IS NOT NULL AND @InvStateID <> @chkInvStateID)
	BEGIN
	SELECT @Retcode = -10
	END
END

IF (@Retcode = 0)
BEGIN
SELECT @InvItemID = MIN(InvItemID), @chkInvItemID = MAX(InvItemID) FROM InvItems WHERE InvProductID = @InvProductID AND SerialNumber = @SerialNumber

IF (@InvItemID IS NOT NULL AND @chkInvItemID IS NOT NULL AND @InvItemID <> @chkInvItemID)
	BEGIN
	SELECT @Retcode = -1
	END
END

IF (@Retcode = 0 AND @InvItemID IS NULL AND @SerialNumber IS NOT NULL AND @SerialNumber <> ' ')
BEGIN
INSERT INTO InvItems (InvProductID,InvWarehouseID,InvStateID,SerialNumber,CreateDate,CreateUser) VALUES(@InvProductID,@InvWarehouseID,@InvStateID,@SerialNumber,getdate(),@Operator)
SELECT @InvItemID = SCOPE_IDENTITY()

EXEC InvItemLog @InvItemID, @Operator
END

IF (@Retcode = 0)
BEGIN
IF (@InvAttribute = 'Cost')
	BEGIN
	UPDATE InvItems SET Cost = CAST(@Data AS NUMERIC(18,4)) WHERE InvItemID = @InvItemID
	END
IF (@InvAttribute = 'SupplierCost')
	BEGIN
	UPDATE InvItems SET SupplierCost = CAST(@Data AS NUMERIC(18,4)) WHERE InvItemID = @InvItemID
	END
IF (@InvAttribute = 'TrackNumber')
	BEGIN
	UPDATE InvItems SET TrackNumber = @Data WHERE InvItemID = @InvItemID
	END
IF (@InvAttribute = 'Comments')
	BEGIN
	UPDATE InvItems SET Comments = @Data WHERE InvItemID = @InvItemID
	END
IF (@InvAttribute = 'ExternalRef')
	BEGIN
	UPDATE InvItems SET ExternalRef = @Data WHERE InvItemID = @InvItemID
	END
IF (@InvAttribute NOT IN ('Cost','SupplierCost','TrackNumber','Comments','ExternalRef'))
	BEGIN
	SELECT @InvAttributeID = MIN(ia.InvAttributeID)
	FROM InvProducts ip JOIN InvLevelAttributes ila ON ((ila.InvCategoryID IS NULL OR ip.InvCategoryID = ila.InvCategoryID)
			AND (ila.InvSubCategoryID IS NULL OR ip.InvSubCategoryID = ila.InvSubCategoryID)
			AND (ila.InvProductID IS NULL OR ip.InvProductID = ila.InvProductID)
			AND (ila.InvSourceID IS NULL OR ip.InvSourceID = ila.InvSourceID))
		JOIN InvAttributes ia ON (ila.InvAttributeID = ia.InvAttributeID)
		WHERE ia.InvAttribute = @InvAttribute
		AND ip.InvProductID = @InvProductID
		AND ia.InvLevelTypeID = 2

	IF (@InvAttributeID IS NOT NULL)
		BEGIN
		SELECT @InvValueID = InvValueID FROM InvValues WHERE InvAttributeID = @InvAttributeID AND Data = @Data 

		UPDATE InvItemData SET InvValueID = @InvValueID, Data = CASE WHEN @InvValueID IS NULL THEN @Data ELSE NULL END
			WHERE InvItemID = @InvItemID
			AND InvAttributeID = @InvAttributeID

		IF (@@ROWCOUNT = 0)
			BEGIN
			INSERT INTO InvItemData (InvItemID,InvAttributeID,InvValueID,Data) VALUES(@InvItemID,@InvAttributeID,@InvValueID,CASE WHEN @InvValueID IS NULL THEN @Data ELSE NULL END)
			END

		END ELSE BEGIN
		SELECT @Retcode = -2
		END
	END
END

SELECT @Retcode AS Retcode
GO

CREATE PROCEDURE dbo.InvItemSetDefaultCost AS
SET NOCOUNT ON
UPDATE ii SET Cost = ip.Cost
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	WHERE ii.Cost IS NULL
	AND ip.Cost IS NOT NULL
GO

CREATE PROCEDURE dbo.InvItemSetDefaultAttr (@InvItemID INT) AS
SET NOCOUNT ON

INSERT INTO InvItemData (InvItemID,InvAttributeID,InvValueID,Data)
SELECT DISTINCT ii.InvItemID, ila.InvAttributeID, ila.DefaultInvValueID, ila.DefaultData
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvLevelAttributes ila ON ((ila.InvCategoryID IS NULL OR ip.InvCategoryID = ila.InvCategoryID) 
	AND (ila.InvProductID IS NULL OR ip.InvProductID = ila.InvProductID)
	AND (ila.InvSubCategoryID IS NULL OR ip.InvSubCategoryID = ila.InvSubCategoryID)
	AND (ila.InvSourceID IS NULL OR ip.InvSourceID = ila.InvSourceID))
	JOIN InvAttributes ia ON (ila.InvAttributeID = ia.InvAttributeID)
	WHERE ii.InvItemID = @InvItemID
	AND ia.InvLevelTypeID = 2
	AND (ila.DefaultData IS NOT NULL OR ila.DefaultInvValueID IS NOT NULL)
	AND NOT EXISTS (SELECT * FROM InvItemData iid WHERE iid.InvItemID = ii.InvItemID AND iid.InvAttributeID = ila.InvAttributeID)
GO

CREATE PROCEDURE dbo.InvStateUpdate (@InvItemID INT) AS
SET NOCOUNT ON
DECLARE @clearInvStateID INT

SELECT @clearInvStateID = ii.InvStateID
FROM InvItems ii JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	WHERE ii.InvItemID = @InvItemID
	AND is1.InvStateTypeID = 1
	AND (ii.CustomerID IS NOT NULL OR ii.AccountID IS NOT NULL)

IF (@clearInvStateID IS NOT NULL)
BEGIN
UPDATE InvItems SET CustomerID = NULL, AccountID = NULL WHERE InvItemID = @InvItemID AND InvStateID = @clearInvStateID
END
GO

CREATE PROCEDURE dbo.InvItemDupeCheck (@InvProductID INT, @SerialNumber VARCHAR(80)) AS
SET NOCOUNT ON
SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS Found
FROM InvItems 
	WHERE InvProductID = @InvProductID
	AND SerialNumber = @SerialNumber
GO

CREATE PROCEDURE dbo.InvItemDataGet (@InvItemID INT) AS
SET NOCOUNT ON
SELECT ia.InvAttribute, COALESCE(iv.Data,iid.Data) AS Data, ia.ServiceAccess
FROM InvItemData iid JOIN InvAttributes ia ON (iid.InvAttributeID = ia.InvAttributeID)
	LEFT JOIN InvValues iv ON (iid.InvValueID = iv.InvValueID)
	WHERE iid.InvItemID = @InvItemID
ORDER BY 1
GO

CREATE PROCEDURE dbo.InvItemGet (@InvItemID INT) AS
SET NOCOUNT ON
SELECT is1.InvStateTypeID, ab.FirstName AS bFirstName, ab.LastName AS bLastName, ab.Company AS bCompany, a.FirstName AS cFirstName, a.LastName AS cLastName, sa.Login, iw.InvWarehouse, iwp.Location, ii.InvoiceID, 
iv.InvItemID,iv.InvProductID,iv.InvStateID,iv.InvWarehouseID,
CASE WHEN ma.Active < 0 OR sa.Active < 0 THEN NULL ELSE iv.CustomerID END AS CustomerID,
CASE WHEN ma.Active < 0 OR sa.Active < 0 THEN NULL ELSE iv.AccountID END AS AccountID,iv.ItemID,iv.SerialNumber,iv.Cost,iv.SupplierCost,
CASE WHEN ma.Active < 0 OR sa.Active < 0 THEN 1 ELSE 0 END AS Deleted,
iv.RecvDate,iv.ShipDate,iv.ReturnDate,iv.AssignDate,
iv.AssignUser,iv.TrackNumber,iv.Comments,iv.ExternalRef,
iv.CreateDate,iv.CreateUser
FROM InvItems iv JOIN InvStates is1 ON (iv.InvStateID = is1.InvStateID)
	LEFT JOIN MasterAccounts ma ON (iv.CustomerID = ma.CustomerID)
	LEFT JOIN InvWarehouseProducts iwp ON (iv.InvProductID = iwp.InvProductID AND iv.InvWarehouseID = iwp.InvWarehouseID)
	LEFT JOIN InvWarehouses iw ON (iv.InvWarehouseID = iw.InvWarehouseID)
	LEFT JOIN SubAccounts sa ON (iv.AccountID = sa.AccountID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN InvoiceItems ii ON (iv.ItemID = ii.ItemID)
	WHERE iv.InvItemID = @InvItemID
GO

CREATE PROCEDURE dbo.InvItemLog (@InvItemID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @InvItemLogID INT

SELECT @InvItemLogID = iil.InvItemLogID
FROM InvItemLogs iil, InvItems ii
	WHERE iil.InvItemLogID = (SELECT MAX(InvItemLogID) FROM InvItemLogs WHERE InvItemID = @InvItemID)
	AND iil.InvItemID = ii.InvItemID
	AND iil.InvStateID = ii.InvStateID
	AND (iil.InvWarehouseID = ii.InvWarehouseID OR (iil.InvWarehouseID IS NULL AND ii.InvWarehouseID IS NULL))
	AND (iil.CustomerID = ii.CustomerID OR (iil.CustomerID IS NULL AND ii.CustomerID IS NULL))
	AND (iil.AccountID = ii.AccountID OR (iil.AccountID IS NULL AND ii.AccountID IS NULL))
	AND (iil.ItemID = ii.ItemID OR (iil.ItemID IS NULL AND ii.ItemID IS NULL))

IF (@InvItemLogID IS NULL)
BEGIN
INSERT INTO InvItemLogs (InvItemID, InvStateID, InvWarehouseID, CustomerID, AccountID, ItemID, CreateDate, CreateUser)
SELECT InvItemID, InvStateID, InvWarehouseID, CustomerID, AccountID, ItemID, getdate(), @Operator
FROM InvItems
	WHERE InvItemID = @InvItemID
END
GO

CREATE PROCEDURE dbo.InvItemLogGet (@InvItemID INT) AS
SET NOCOUNT ON
SELECT is1.InvState, is1.StringID AS is1StringID, iw.InvWarehouse, ab.FirstName AS bFirstName, ab.LastName AS bLastName, ab.Company AS bCompany, ma.CustomerID, sa.AccountID, a.FirstName AS cFirstName, a.LastName AS cLastName, sa.Login, iil.CreateDate, iil.CreateUser, ii.InvoiceID
FROM InvItemLogs iil JOIN InvStates is1 ON (iil.InvStateID = is1.InvStateID)
	LEFT JOIN InvWarehouses iw ON (iil.InvWarehouseID = iw.InvWarehouseID)
	LEFT JOIN MasterAccounts ma ON (iil.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (iil.AccountID = sa.AccountID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN InvoiceItems ii ON (iil.ItemID = ii.ItemID)
	WHERE iil.InvItemID = @InvItemID
ORDER BY InvItemLogID DESC
GO

CREATE PROCEDURE dbo.InvProductDataGet (@InvProductID INT) AS
SET NOCOUNT ON
SELECT ia.InvAttribute, COALESCE(iv.Data,ipd.Data) AS Data 
FROM InvProductData ipd JOIN InvAttributes ia ON (ipd.InvAttributeID = ia.InvAttributeID)
	LEFT JOIN InvValues iv ON (ipd.InvValueID = iv.InvValueID)
	WHERE ipd.InvProductID = @InvProductID
ORDER BY 1
GO

CREATE PROCEDURE dbo.InvProductGet (@InvProductID INT, @Title VARCHAR(255)) AS
SET NOCOUNT ON

IF (@Title IS NOT NULL)
BEGIN
SELECT @InvProductID = MIN(InvProductID) FROM InvProducts WHERE Title = @Title
END

SELECT ip.InvProductID, ic.InvCategory, ic.StringID AS icStringID, isc.InvSubCategory, isc.StringID AS iscStringID, 
is1.InvSource, is1.InvStateGroupID, ip.Title, ip.Description, ip.OrderInfo, ip.Cost, ip.L, ip.W, ip.H, ip.Weight, ip.SKU,
ip.ModelNumber, ip.SupplierSKU, ip.EAN, ip.SerialNumberRegExp, ip.GroupID, ip.AccessLabelID
FROM InvProducts ip JOIN InvCategories ic ON (ip.InvCategoryID = ic.InvCategoryID)
	LEFT JOIN InvSubCategories isc ON (ip.InvSubCategoryID = isc.InvSubCategoryID)
	JOIN InvSources is1 ON (ip.InvSourceID = is1.InvSourceID)
	WHERE ip.InvProductID = @InvProductID
GO

CREATE PROCEDURE dbo.InvProductIDGet (@InvProductID INT, @Title VARCHAR(255), @SKU VARCHAR(64), @SupplierSKU VARCHAR(64), @EAN VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT InvProductID, GroupID, Title, SerialNumberRegExp
FROM InvProducts
	WHERE (@InvProductID IS NULL OR InvProductID = @InvProductID)
	AND (@Title IS NULL OR Title = @Title)
	AND (@SKU IS NULL OR SKU = @SKU)
	AND (@SupplierSKU IS NULL OR SupplierSKU = @SupplierSKU)
	AND (@EAN IS NULL OR EAN = @EAN)
	AND Active = 1
GO

CREATE PROCEDURE dbo.InvoiceBatchVoidGet (@BatchID INT) AS
SET NOCOUNT ON

SELECT 0 AS Result, i.InvoiceID, i.CustomerID, ma.GroupID, CASE WHEN s.StatementID = ma.LastStatementID AND s.PrintDate IS NULL AND s.EmailDate IS NULL AND s.LateCharge = 0 THEN 1 ELSE 0 END AS SDL
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Statements s ON (i.StatementID = s.StatementID)
	WHERE i.BatchID = @BatchID
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND NOT EXISTS
		(
		SELECT * FROM Invoices ni 
		WHERE ni.CustomerID = i.CustomerID
		AND ni.VoidDate IS NULL
		AND ni.Processed = 1
		AND ni.InvoiceID > i.InvoiceID
		AND ni.InvoiceTypeID IN (1,2,3)
		)
	AND ma.Active = 1

UNION ALL

SELECT 1 AS Result, i.InvoiceID, i.CustomerID, NULL, NULL
FROM Invoices i
	WHERE i.BatchID = @BatchID
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND EXISTS
		(
		SELECT * FROM Invoices ni
		WHERE ni.CustomerID = i.CustomerID
		AND ni.VoidDate IS NULL
		AND ni.Processed = 1
		AND ni.InvoiceID > i.InvoiceID
		AND ni.InvoiceTypeID IN (1,2,3)
		)

UNION ALL

SELECT 2 AS Result, i.InvoiceID, i.CustomerID, NULL, NULL
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	WHERE i.BatchID = @BatchID
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND ma.Active <> 1
GO

CREATE PROCEDURE dbo.InvoiceGapUpdate AS
SET NOCOUNT ON
DECLARE @start INT, @end INT, @interval INT, @curpos INT, @limit INT, @gapcount INT

IF ((SELECT NumValue FROM Configs WHERE ConfigID = 702) = 0)
BEGIN
RETURN
END

SELECT @start = MIN(InvoiceID) FROM Invoices
SELECT @end = MAX(InvoiceID) FROM Invoices
SELECT @interval = MAX(n) FROM Numbers
SELECT @limit = 10000, @gapcount = 0

UPDATE InvoiceGaps SET Locked = 2
DELETE FROM InvoiceGaps

WHILE(@start < @end AND @limit > 0)
BEGIN
INSERT INTO InvoiceGaps(InvoiceID)
SELECT n.n + @start
FROM Numbers n LEFT JOIN Invoices i ON (n.n + @start = i.InvoiceID)
	WHERE i.InvoiceID IS NULL
	AND n.n + @start < @end
	AND n.n > 0

SELECT @limit = @limit - @@ROWCOUNT, @start = @start + @interval, @gapcount = @gapcount + @@ROWCOUNT
END

SELECT CAST(@gapcount AS VARCHAR(20)) + ' sequence gaps recorded' AS Description
GO

CREATE PROCEDURE dbo.InvoiceAdd (@BatchID INT, @CustomerID INT, @InvoiceTypeID INT, @Amount NUMERIC(18,4), @ChargeAmount NUMERIC(18,4), @LastModifyUser VARCHAR(32), @Tax NUMERIC(18,4)) AS
SET NOCOUNT ON
DECLARE @InvoiceID INT
IF ((SELECT NumValue FROM Configs WHERE ConfigID = 702) = 1)
BEGIN
SELECT @InvoiceID = MIN(InvoiceID) FROM InvoiceGaps

IF (@InvoiceID IS NOT NULL)
	BEGIN
	UPDATE InvoiceGaps SET Locked = 1 WHERE InvoiceID = @InvoiceID AND Locked = 0
	IF (@@ROWCOUNT <> 1)
		BEGIN
		SELECT @InvoiceID = NULL
		END
	END
END

IF (@InvoiceID IS NOT NULL)
BEGIN
DELETE FROM InvoiceGaps WHERE InvoiceID = @InvoiceID

SET IDENTITY_INSERT Invoices ON
INSERT INTO Invoices(InvoiceID,BatchID,CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,LastModifyUser,Tax,Processed)
VALUES(@InvoiceID,@BatchID,@CustomerID,@InvoiceTypeID,@Amount,@ChargeAmount,0,@LastModifyUser,@Tax,1)
SET IDENTITY_INSERT Invoices OFF

SELECT @InvoiceID AS InvoiceID
END ELSE BEGIN
INSERT INTO Invoices(BatchID,CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,LastModifyUser,Tax,Processed)
VALUES(@BatchID,@CustomerID,@InvoiceTypeID,@Amount,@ChargeAmount,0,@LastModifyUser,@Tax,1)

SELECT SCOPE_IDENTITY() AS InvoiceID
END
GO

CREATE PROCEDURE dbo.InvoiceChargeUpdate (@ItemID INT, @ChargeID INT) AS
UPDATE Charges SET ItemID = @ItemID WHERE ChargeID = @ChargeID AND ItemID IS NULL
GO

CREATE PROCEDURE dbo.CustPOSVoidList (@CustomerID INT, @CurrentInvoiceID INT) AS
SET NOCOUNT ON
CREATE TABLE #cpvl (InvoiceID INT)

INSERT INTO #cpvl (InvoiceID)
SELECT InvoiceID
FROM Invoices i 
	WHERE i.CustomerID = @CustomerID
	AND i.InvoiceTypeID = 92
	AND i.Processed = 0
	AND i.Estimate = 0
	AND i.VoidDate IS NULL
	AND (@CurrentInvoiceID IS NULL OR i.InvoiceID <> @CurrentInvoiceID)

UPDATE Invoices SET Processed = 2 WHERE InvoiceID IN (SELECT InvoiceID FROM #cpvl)
DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM #cpvl)
DELETE FROM Invoices WHERE InvoiceID IN (SELECT InvoiceID FROM #cpvl)

SELECT InvoiceID
FROM Invoices i 
	WHERE i.CustomerID = @CustomerID
	AND i.InvoiceTypeID = 92
	AND i.ChargeAmount > 0
	AND i.PaidAmount = 0
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND (@CurrentInvoiceID IS NULL OR i.InvoiceID <> @CurrentInvoiceID)
GO

CREATE PROCEDURE dbo.CustInvoiceDelete (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @allow INT

SELECT @allow = COUNT(*) 
FROM Invoices
	WHERE InvoiceID = @InvoiceID
	AND CustomerID = @CustomerID
	AND Processed = 0

IF (@allow = 1)
BEGIN
UPDATE Invoices SET Processed = 2 WHERE InvoiceID = @InvoiceID AND Processed = 0
IF (@@ROWCOUNT = 1)
	BEGIN
	UPDATE Charges SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
	DELETE FROM InvoiceItems WHERE InvoiceID = @InvoiceID
	DELETE FROM Invoices WHERE InvoiceID = @InvoiceID
	END
END
GO

CREATE PROCEDURE dbo.InvoiceDelete (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @allow INT

SELECT @allow = COUNT(*) 
FROM Invoices
	WHERE InvoiceID = @InvoiceID
	AND Processed = 0

IF (@allow = 1)
BEGIN
UPDATE Invoices SET Processed = 2 WHERE InvoiceID = @InvoiceID AND Processed = 0
IF (@@ROWCOUNT = 1)
	BEGIN
	UPDATE Charges SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
	DELETE FROM InvoiceItems WHERE InvoiceID = @InvoiceID
	DELETE FROM Invoices WHERE InvoiceID = @InvoiceID
	END
END
GO

CREATE PROCEDURE dbo.InvoiceDeleteProcessed (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @allow INT, @CustomerID INT

SELECT @allow = COUNT(*), @CustomerID = MIN(CustomerID)
FROM Invoices
	WHERE InvoiceID = @InvoiceID
	AND Processed = 1
	AND StatementID IS NULL
	AND VoidStatementID IS NULL

IF (@allow = 1)
BEGIN
UPDATE Invoices SET Processed = 2 WHERE InvoiceID = @InvoiceID AND Processed = 1
IF (@@ROWCOUNT = 1)
	BEGIN
	DELETE FROM InvoiceTags WHERE InvoiceID = @InvoiceID
	DELETE FROM InvoiceSubAccounts WHERE InvoiceID = @InvoiceID
	UPDATE ExternalTrans SET InvoiceID = NULL WHERE InvoiceID = @InvoiceID

	DELETE FROM PaymentItems WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
	DELETE FROM InvoiceItemDiscounts WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)

	UPDATE Charges SET ItemID = (SELECT MIN(ii.ItemID) FROM InvoiceItems ii JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
			WHERE i.CustomerID = @CustomerID
			AND i.InvoiceID <> @InvoiceID
			AND i.VoidDate IS NULL
			AND ii.ChargeID = Charges.ChargeID)
		WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
	DELETE FROM InvoiceItems WHERE InvoiceID = @InvoiceID
	DELETE FROM Invoices WHERE InvoiceID = @InvoiceID
	END
END ELSE
	BEGIN
	RAISERROR('Invoice cannot be removed because it does not exist or has been assigned to a statement',11,1)
	END
GO

CREATE PROCEDURE dbo.InvoiceEmailList (@GroupID INT, @OperatorGroupID INT, @MBRGlobal INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @email_zeroinv INT
SELECT @email_zeroinv = NumValue FROM Configs WHERE ConfigID = 724

SELECT g.BillPhone, g.BillFax, g.BillName, g.BillAddress1, g.BillAddress2, g.BillCity, g.BillState, g.BillZip, g.EmailAccounts, g.ReportLogoURL, ab.Company, ab.FirstName, ab.LastName, ma.CustomerID, i.InvoiceID, CASE WHEN sm.EmailTypeID = 16 THEN COALESCE(g.InvoiceTextReport,'einvoice.rpt') ELSE COALESCE(g.InvoiceReport,'invoice.rpt') END AS ReportFile,
'{Invoices.InvoiceID}=' + CAST(i.InvoiceID AS VARCHAR(16)) AS Formula
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN ConfigGroupData cg ON (ma.GroupID = cg.GroupID AND cg.ConfigID = 724)
	WHERE ma.Active = 1
	AND i.EmailDate IS NULL
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND i.CreateDate > DATEADD(dd,-45,getdate())
	AND sm.EmailTypeID IS NOT NULL
	AND (i.ChargeAmount > i.PaidAmount OR COALESCE(cg.NumValue,@email_zeroinv,1) = 1)
	AND (sm.EmailInvoice = 1 OR (sm.EmailInvoice IS NULL AND g.AutoEmailInvoices IN (0,1)))
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND ((@OperatorGroupID IS NULL AND (sm.EmailInvoice = 1 OR (sm.EmailInvoice IS NULL AND g.AutoEmailInvoices = 1))) OR (@OperatorGroupID IS NOT NULL AND (COALESCE(@MBRGlobal,1) = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=106 AND OperatorGroupID=@OperatorGroupID))))
GO

CREATE PROCEDURE dbo.InvoiceEmailSent (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
UPDATE Invoices SET EmailDate=getdate() WHERE EmailDate IS NULL AND InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.InvoiceGetItems (@ForceNext INT, @CustomerID INT) AS
SET NOCOUNT ON
DECLARE @inv_next_days INT, @lastpaid INT, @InvoiceID INT

SELECT @InvoiceID = MAX(InvoiceID)
FROM Invoices
	WHERE InvoiceTypeID IN (1,2,3)
	AND VoidDate IS NULL
	AND Processed = 1
	AND ChargeAmount > 0
	AND CustomerID = @CustomerID

IF (@InvoiceID IS NOT NULL)
BEGIN
SELECT @lastpaid = CASE WHEN PaidAmount >= (ChargeAmount / 2) THEN 1 ELSE 0 END
FROM Invoices
	WHERE InvoiceID = @InvoiceID
END

IF (@ForceNext = 1)
BEGIN
SELECT @inv_next_days = COALESCE(cgd.NumValue,c.NumValue,90)
FROM MasterAccounts ma LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Configs c ON (c.ConfigID = 37)
	WHERE ma.CustomerID = @CustomerID
END

SELECT CASE WHEN c.Amount < 0 THEN 1 ELSE 2 END AS ItemType, c.AllowInterim, c.AccountID, c.AccountTypeID, c.ChargeID, c.ChargeTypeID, COALESCE(c.Description,ct.ChargeType) AS Description, CASE WHEN c.Description IS NULL THEN ct.StringID ELSE NULL END AS StringID, c.Amount, c.Quantity, 
c.TaxGroupID, c.TaxExemptions, c.StartDate, c.EndDate
FROM MasterAccounts ma JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	LEFT JOIN ChargeTypes ct ON (c.ChargeTypeID = ct.ChargeTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND c.ItemID IS NULL
	AND ma.Active = 1

SELECT 3 AS ItemType, sa.AccountID, sa.Login, pp.Period AS Quantity, pp.PeriodTypeID AS QuantityType, DATEADD(dd,1,sa.BilledThru) AS StartDate, 
CASE WHEN pp.PeriodTypeID = 1 THEN pp.Period ELSE NULL END AS Months, 
CASE WHEN bc.CycleType IN (3,4) AND pp.PeriodTypeID = 1 AND pp.Period > 1 THEN 
	(
	SELECT MAX(sa2.BilledThru) 
	FROM SubAccounts sa2 JOIN PayPeriods pp2 ON (sa2.PayPeriodID = pp2.PayPeriodID)
		WHERE sa2.Active = 1
		AND sa2.Recurring = 1
		AND pp2.PeriodTypeID = 1
		AND pp2.Period = pp.Period
		AND sa2.CustomerID = @CustomerID
	) END AS MaxBilled
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND ma.CustomerID = @CustomerID
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru
			OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) 
			OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension + ma.TempExtension + 1,sa.ExpireDate) >= getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN  DATEADD(dd,bc.RenewDays,sa.StartDate) ELSE  DATEADD(mm,bc.RenewPeriods * pp.Period,sa.StartDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+ma.TempExtension+1,sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR (bc.AutoBill = 0 AND (@lastpaid IS NULL OR @lastpaid = 1))
		OR bc.AutoBill = 1)
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,@inv_next_days,getdate()) >= sa.BilledThru))
GO

CREATE PROCEDURE dbo.InvoiceGetList (@ForceNext INT, @InvoiceID INT, @CustomerID INT, @GroupID INT, @OperatorGroupID INT, @LanguageID INT) AS
SET NOCOUNT ON
DECLARE @inv_next_days INT, @interim_lookahead INT, @armed INT

CREATE TABLE #iglc (CustomerID INT PRIMARY KEY)
CREATE TABLE #igli (CustomerID INT PRIMARY KEY, InvoiceID INT)
CREATE TABLE #igl (CustomerID INT PRIMARY KEY, HaveCharges TINYINT NOT NULL)

SELECT @inv_next_days = COALESCE(MAX(NumValue),90) FROM Configs WHERE ConfigID = 37
SELECT @interim_lookahead = COALESCE(MAX(NumValue),45) FROM Configs WHERE ConfigID = 36
SELECT @armed = CASE WHEN @CustomerID IS NULL THEN COALESCE(MAX(NumValue),1) ELSE 1 END FROM Configs WHERE ConfigID = 671

IF (@InvoiceID IS NULL)
BEGIN
IF (@CustomerID IS NOT NULL)
	BEGIN
	INSERT INTO #iglc (CustomerID)
	SELECT CustomerID 
	FROM MasterAccounts
		WHERE Active = 1
		AND CustomerID = @CustomerID
		AND (@OperatorGroupID IS NULL OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
	END ELSE IF (@GroupID IS NOT NULL)
	BEGIN
	INSERT INTO #iglc (CustomerID)
	SELECT CustomerID 
	FROM MasterAccounts
		WHERE Active = 1 
		AND GroupID = @GroupID
		AND (@OperatorGroupID IS NULL OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
	END ELSE BEGIN
	INSERT INTO #iglc (CustomerID)
	SELECT CustomerID 
	FROM MasterAccounts
		WHERE Active = 1
		AND (@OperatorGroupID IS NULL OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
	END

INSERT INTO #igli (CustomerID, InvoiceID)
SELECT i.CustomerID, MAX(i.InvoiceID)
FROM Invoices i JOIN #iglc c ON (i.CustomerID = c.CustomerID)
	WHERE i.InvoiceTypeID IN (1,2,3)
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.ChargeAmount > 0
GROUP BY i.CustomerID
END

IF (@CustomerID IS NOT NULL AND @InvoiceID IS NULL)
BEGIN
INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 1
FROM MasterAccounts ma JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.CustomerID = @CustomerID
	AND c.ItemID IS NULL
	AND c.Quantity > 0
	AND c.AllowInterim = 1
	AND bc.AutoBill = 2

INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 1
FROM MasterAccounts ma JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 36 AND ma.GroupID = cgd.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.PaymentTypeID <> 64
	AND c.ItemID IS NULL
	AND c.AllowInterim = 1
	AND c.Quantity > 0
	AND bc.AutoBill IN (0,1)
	AND ((ma.CancelDate < getdate()) OR (NOT EXISTS
		(
		SELECT *
		FROM SubAccounts sa
			WHERE sa.CustomerID = @CustomerID
			AND sa.Active = 1
			AND sa.Recurring = 1
			AND (sa.CancelDate IS NULL OR sa.CancelDate > sa.BilledThru)
			AND DATEADD(dd,COALESCE(cgd.NumValue,@interim_lookahead) + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) > sa.BilledThru
		)))

INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 0
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Charges c ON (c.ItemID IS NULL AND ma.CustomerID = c.CustomerID AND c.Quantity > 0)
	LEFT JOIN #igli igli ON (ma.CustomerID = igli.CustomerID)
	LEFT JOIN Invoices i ON (igli.InvoiceID = i.InvoiceID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.PaymentTypeID <> 64
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND NOT EXISTS (SELECT * FROM #igl WHERE CustomerID = @CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru 
			OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) 
			OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension + ma.TempExtension + 1,sa.ExpireDate) >= getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN  DATEADD(dd,bc.RenewDays,sa.StartDate) ELSE  DATEADD(mm,bc.RenewPeriods * pp.Period,sa.StartDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+ma.TempExtension+1,sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR (bc.AutoBill = 0 AND (i.ChargeAmount IS NULL OR i.PaidAmount >= i.ChargeAmount / 2))
		OR bc.AutoBill = 1)
	AND ((c.ChargeID IS NOT NULL AND @CustomerID IS NOT NULL)
		OR (COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= sa.BilledThru))


SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, a.FirstName, a.LastName, a.Company, 
ma.CustomerID, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, COALESCE(ma.BillMonth,bc.BillMonth)-1 AS CalendarOffset, bc.CycleType, g.OrganizationID, igl.HaveCharges, @armed AS Armed
FROM #igl igl JOIN #iglc iglc ON (igl.CustomerID = iglc.CustomerID)
	JOIN MasterAccounts ma ON (igl.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
UNION ALL
SELECT 50 AS InvoiceTypeID, a.FirstName, a.LastName, a.Company, ma.CustomerID, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, COALESCE(ma.BillMonth,bc.BillMonth)-1 AS CalendarOffset, bc.CycleType, g.OrganizationID, 1 AS HaveCharges, @armed AS Armed
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (ma.CustomerID = o.ResellerCustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN #iglc iglc ON (ma.CustomerID = iglc.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND EXISTS
		(
		SELECT * 
		FROM MasterAccounts rma JOIN SubAccounts rsa ON (rma.CustomerID = rsa.CustomerID)
			JOIN ResellerUsage ru ON (rsa.AccountID = ru.AccountID)
			WHERE rma.GroupID = g.GroupID
			AND o.InvoiceFractional <> 2
			AND ((DATEPART(yy,getdate()) > ru.StartYear)
				OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth AND DATEPART(dd,getdate()) >= 1))))
			AND ru.Days > 0
			AND ru.ItemID IS NULL
		)
END

IF (@CustomerID IS NULL AND @InvoiceID IS NULL)
BEGIN
INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 1
FROM #iglc iglc JOIN Charges c ON (iglc.CustomerID = c.CustomerID)
	JOIN MasterAccounts ma ON (iglc.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE c.ItemID IS NULL
	AND c.Quantity > 0
	AND c.AllowInterim = 1
	AND bc.AutoBill = 2

INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 1
FROM #iglc iglc JOIN Charges c ON (iglc.CustomerID = c.CustomerID)
	JOIN MasterAccounts ma ON (iglc.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 36 AND ma.GroupID = cgd.GroupID)
	WHERE ma.PaymentTypeID <> 64
	AND c.ItemID IS NULL
	AND c.AllowInterim = 1
	AND c.Quantity > 0
	AND bc.AutoBill IN (0,1)
	AND ((ma.CancelDate < getdate()) OR (NOT EXISTS
		(
		SELECT *
		FROM SubAccounts sa
			WHERE sa.CustomerID = iglc.CustomerID
			AND sa.Active = 1
			AND sa.Recurring = 1
			AND (sa.CancelDate IS NULL OR sa.CancelDate > sa.BilledThru)
			AND DATEADD(dd,COALESCE(cgd.NumValue,@interim_lookahead) + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) > sa.BilledThru
		)))

INSERT INTO #igl (CustomerID,HaveCharges)
SELECT DISTINCT ma.CustomerID, 0
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	JOIN #iglc iglc ON (ma.CustomerID = iglc.CustomerID)
	LEFT JOIN #igli igli ON (ma.CustomerID = igli.CustomerID)
	LEFT JOIN Invoices i ON (igli.InvoiceID = i.InvoiceID)
	WHERE ma.PaymentTypeID <> 64
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND NOT EXISTS (SELECT * FROM #igl igl WHERE igl.CustomerID = ma.CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru 
			OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) 
			OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension + ma.TempExtension + 1,sa.ExpireDate) >= getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate()) 
			OR ((bc.RenewDays > 0 OR bc.RenewPeriods > 0) AND CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN  DATEADD(dd,bc.RenewDays,sa.StartDate) ELSE  DATEADD(mm,bc.RenewPeriods * pp.Period,sa.StartDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+ma.TempExtension+1,sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR (bc.AutoBill = 0 AND (i.ChargeAmount IS NULL OR i.PaidAmount >= i.ChargeAmount / 2))
		OR bc.AutoBill = 1)
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= sa.BilledThru))


SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, a.FirstName, a.LastName, a.Company, 
ma.CustomerID, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, COALESCE(ma.BillMonth,bc.BillMonth)-1 AS CalendarOffset, bc.CycleType, g.OrganizationID, igl.HaveCharges, @armed AS Armed
FROM #igl igl JOIN MasterAccounts ma ON (igl.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
UNION ALL
SELECT 50 AS InvoiceTypeID, a.FirstName, a.LastName, a.Company, ma.CustomerID, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, COALESCE(ma.BillMonth,bc.BillMonth)-1 AS CalendarOffset, bc.CycleType, g.OrganizationID, 1 AS HaveCharges, @armed AS Armed
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (ma.CustomerID = o.ResellerCustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN #iglc iglc ON (ma.CustomerID = iglc.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE EXISTS
		(
		SELECT * 
		FROM MasterAccounts rma JOIN SubAccounts rsa ON (rma.CustomerID = rsa.CustomerID)
			JOIN ResellerUsage ru ON (rsa.AccountID = ru.AccountID)
			WHERE rma.GroupID = g.GroupID
			AND o.InvoiceFractional <> 2
			AND ((DATEPART(yy,getdate()) > ru.StartYear) 
				OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth AND DATEPART(dd,getdate()) >= 1))))
			AND ru.Days > 0
			AND ru.ItemID IS NULL
		)
END

IF (@InvoiceID IS NOT NULL)
BEGIN
SELECT i.InvoiceTypeID, a.FirstName, a.LastName, a.Company, ma.CustomerID, CASE WHEN @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, COALESCE(ma.BillMonth,bc.BillMonth) - 1 AS CalendarOffset, bc.CycleType, g.OrganizationID, 1 AS HaveCharges, @armed AS Armed
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.InvoiceTypeID IN (91,92)
	AND i.Processed = 0
	AND i.Estimate = 0
END
GO

CREATE PROCEDURE dbo.InvoiceGetPOSItems (@InvoiceID INT) AS
SET NOCOUNT ON
SELECT ItemID, ItemType, Login, Days, Description, StartDate, EndDate, AccountID, Amount, Quantity, TaxGroupID, ChargeTypeID
FROM InvoiceItems
	WHERE InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.InvoiceGetReinvoice (@CustomerID INT) AS 
SET NOCOUNT ON
DECLARE @StartInvoiceID INT, @GroupID INT
CREATE TABLE #igr (AccountID INT, CancelReasonID INT, AccountTypeID INT, EffectiveDate DATETIME, ActiveDate DATETIME, InactiveDate DATETIME)

SELECT @GroupID = GroupID FROM MasterAccounts WHERE CustomerID = @CustomerID

INSERT INTO #igr (AccountID,CancelReasonID,AccountTypeID,EffectiveDate,ActiveDate,InactiveDate)
SELECT AccountID, CancelReasonID, AccountTypeID, EffectiveDate, ActiveDate, InactiveDate
FROM AccountChanges
	WHERE CustomerID = @CustomerID
	AND AllowReinvoice = 1

SELECT @StartInvoiceID = MIN(i.InvoiceID)
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN #igr ac ON (ac.AccountID IS NULL OR ac.AccountID = ii.AccountID)
	WHERE i.CustomerID = @CustomerID
	AND (i.CreateDate > DATEADD(mm,-2,getdate()) OR ac.CancelReasonID IS NOT NULL OR (ac.AccountTypeID IS NOT NULL AND ii.AccountTypeID <> ac.AccountTypeID))
	AND ((ii.EndDate > ac.EffectiveDate) OR (ii.EndDate = ac.EffectiveDate AND ac.CancelReasonID IS NULL AND ac.AccountTypeID IS NOT NULL))
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND ii.ItemType = 3
	AND ii.Quantity > 0
	AND i.InvoiceTypeID IN (1,2,3)
	AND (i.CreateDate < ac.ActiveDate OR i.CreateDate < ac.InactiveDate)
	AND NOT (i.CreateDate < ac.ActiveDate AND i.CreateDate < ac.InactiveDate AND ac.InactiveDate IS NOT NULL)

IF (@StartInvoiceID < 0)
BEGIN
SELECT @StartInvoiceID = NULL
END

SELECT i.InvoiceID, i.CreateDate, it1.InvoiceType, it1.StringID AS it1StringID, i.Amount, CASE WHEN i.ChargeAmount > i.PaidAmount THEN 0 ELSE 1 END AS Paid, @GroupID AS GroupID
FROM Invoices i JOIN InvoiceTypes it1 ON (i.InvoiceTypeID = it1.InvoiceTypeID)
	WHERE i.CustomerID = @CustomerID
	AND i.InvoiceID >= @StartInvoiceID
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.InvoiceTypeID IN (1,2,3)
ORDER BY i.InvoiceID ASC
GO

CREATE PROCEDURE dbo.InvoiceGetResellerItems (@CustomerID INT) AS
SET NOCOUNT ON
SELECT 2 AS ItemType, sa2.AccountID, at2.AccountTypeID, COALESCE(sa2.Login,sa2.Email) AS Login, at2.AccountType AS Description, at2.StringID, COALESCE(oat.ResellerCost,at2.Cost) * CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 1 ELSE (CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END) / 30 END AS Amount, 1 AS Quantity, 0 AS QuantityType, at2.TaxGroupID, at2.TaxExemptions, CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 0 ELSE CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END END AS Days,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 1

SELECT 2 AS ItemType, ru.AccountTypeID, MIN(at2.AccountType) AS Description, MIN(at2.StringID) AS StringID, COUNT(*) AS RCount,ROUND(SUM(CASE WHEN (o.InvoiceFractional = 0 AND ru.Days > 0) OR ru.Days >= 27.5 THEN 30 ELSE ru.Days END) / 30,0) AS Quantity,MIN(COALESCE(oat.ResellerCost,at2.Cost)) AS Amount, 0 AS QuantityType, MIN(at2.TaxGroupID) AS TaxGroupID, MIN(at2.TaxExemptions) AS TaxExemptions,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 0
GROUP BY ru.StartYear,ru.StartMonth,ru.AccountTypeID
GO

CREATE PROCEDURE dbo.InvoiceItemDescFreeze WITH RECOMPILE AS
SET NOCOUNT ON

UPDATE ii SET Description = COALESCE(ct.ChargeType,at1.Description)
FROM InvoiceItems ii LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN InvItems vi ON (ii.InvItemID = vi.InvItemID)
	WHERE ii.Description IS NULL
	AND vi.SerialNumber IS NULL
	AND (ct.ChargeType IS NOT NULL OR at1.Description IS NOT NULL)

SELECT CAST(@@ROWCOUNT AS VARCHAR(16)) + ' line item descriptions frozen' AS Description
GO

CREATE PROCEDURE dbo.InvoiceItemAdd (@InvoiceID INT, @ItemType INT, @Days INT, @Quantity INT, @BaseAmount NUMERIC(18,4), @Amount NUMERIC(18,4), @TaxableAmount NUMERIC(18,4), @Login VARCHAR(64), @Description VARCHAR(200), @StartDate DATETIME, @EndDate DATETIME, @AccountID INT, @AccountTypeID INT, @ChargeID INT, @ChargeTypeID INT, @TaxID INT, @TaxGroupID INT, @ServiceQty INT) AS
SET NOCOUNT ON
DECLARE @ItemID INT

INSERT INTO InvoiceItems (InvoiceID,ItemType,Days,Quantity,BaseAmount,Amount,TaxableAmount,Login,Description,StartDate,EndDate,AccountID,AccountTypeID,ChargeID,ChargeTypeID,TaxID,TaxGroupID,ServiceQty)
VALUES(@InvoiceID, @ItemType, @Days, @Quantity, @BaseAmount, @Amount, @TaxableAmount, @Login, @Description, @StartDate, @EndDate, @AccountID, @AccountTypeID, @ChargeID, @ChargeTypeID, @TaxID, @TaxGroupID, @ServiceQty)

SELECT @ItemID = SCOPE_IDENTITY()

IF (@ItemType = 3 AND @Amount < 0 AND @Quantity > 0 AND @AccountID IS NOT NULL AND @ChargeID IS NULL)
BEGIN
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,AccountTypeID,Amount,Quantity,ItemID,CreateUser,LastModifyDate,LastModifyUser,AllowDupe)
SELECT CustomerID,@Description,@StartDate,@EndDate,@AccountID,@AccountTypeID,@Amount,@Quantity,@ItemID,'GBE',getdate(),'GBE',0
FROM SubAccounts
	WHERE AccountID = @AccountID
END

SELECT @ItemID AS ItemID
GO

CREATE PROCEDURE dbo.InvoiceItemUpdate (@ItemID INT, @BaseAmount NUMERIC(18,4), @Amount NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE InvoiceItems SET BaseAmount = @BaseAmount, Amount = @Amount
	WHERE ItemID = @ItemID
GO

CREATE PROCEDURE dbo.InvoiceItemDiscAdd (@ItemID INT, @DiscountID INT, @Amount NUMERIC(18,4)) AS
SET NOCOUNT ON
INSERT INTO InvoiceItemDiscounts (ItemID,DiscountID,Amount) VALUES(@ItemID,@DiscountID,@Amount)
GO

CREATE PROCEDURE dbo.InvoiceItemPaid (@ItemID INT, @ItemType INT) AS
SET NOCOUNT ON
DECLARE @fpaycnt INT, @TimeChargeID INT, @AutoBill INT, @GroupID INT, @CustomerID INT, @AccountID INT, @ChargeTypeID INT, @LateFeeID INT, @ServiceGroupID INT, @ServiceCategoryID INT, @InvoiceID INT, @StatementID INT, @Quantity INT, @Months INT, @Days INT, @Minutes INT, @TimeLeft INT, @RateTimeLeft INT, @DataLeft BIGINT, @RateDataLeft BIGINT, @PaidFlag INT, @stmtLateCharge INT, @itemLateCharge INT, @trackmode INT, @expmode INT, @cont INT, @GraceDays INT, @latestart DATETIME, @latecharge NUMERIC(18,4), @LateFeeTypeID INT, @ExpCancelReasonID INT, @invoicedate DATETIME, @now DATETIME, @expdate DATETIME, @expstart_open DATETIME, @expstart_close DATETIME, @expend_lastat DATETIME, @expend_minAccountTypeID INT, @expend_maxAccountTypeID INT, @expend_open DATETIME, @expend_close DATETIME, @reinvoice TINYINT

SELECT @CustomerID = ma.CustomerID, @AccountID = ii.AccountID, @invoicedate = i.CreateDate, @InvoiceID = i.InvoiceID, @StatementID = i.StatementID, @GroupID = ma.GroupID, @ChargeTypeID = ii.ChargeTypeID, @ServiceCategoryID = sa.ServiceCategoryID, @stmtLateCharge = s.LateCharge, @itemLateCharge = ii.LateCharge,
@ExpCancelReasonID = CASE
	WHEN bc.ExpCancelReasonID IS NOT NULL
	AND ii.ItemType = 3
	AND sa.Recurring = 1
	AND bc.AutoBill = 0
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND sa.ExpireDate IS NOT NULL
	AND sa.ExpireDate < sa.BilledThru
	AND sa.BilledThru = ii.EndDate
	AND DATEADD(dd,ma.TempExtension + sa.Extension,sa.ExpireDate) < getdate() THEN bc.ExpCancelReasonID END, @now = getdate(), @expdate = DATEADD(dd,ma.TempExtension + sa.Extension,sa.ExpireDate), @reinvoice = 0
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Statements s ON (i.StatementID = s.StatementID)
	WHERE ii.ItemID = @ItemID

IF (@ExpCancelReasonID IS NOT NULL)
BEGIN
SELECT @fpaycnt = COUNT(*)
FROM PaymentItems pi1 JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
	WHERE pi1.ItemID = @ItemID
	AND p.CreateDate >= @invoicedate
	AND pi1.InactiveDate IS NULL

IF (@fpaycnt = 0)
	BEGIN
	SELECT @fpaycnt = COUNT(*)
	FROM PaymentItems pi1 JOIN Charges c ON (pi1.ChargeID = c.ChargeID)
		WHERE pi1.ItemID = @ItemID
		AND c.CreateDate >= @invoicedate
		AND pi1.InactiveDate IS NULL
	END

IF (@fpaycnt = 0)
	BEGIN
	SELECT @ExpCancelReasonID = NULL
	END
END

IF (@ExpCancelReasonID IS NOT NULL)
BEGIN
SELECT @now = DATEADD(ms,-DATEPART(ms,@now),DATEADD(ss,-(DATEPART(hh,@now)*3600 + DATEPART(mi,@now)*60 + DATEPART(ss,@now)),@now))

IF (DATEDIFF(dd,@expdate,@now) > 1)
	BEGIN
	SELECT @expstart_open = MAX(CASE WHEN CancelReasonID IS NULL THEN EffectiveDate END), @expstart_close = MAX(CASE WHEN CancelReasonID IS NOT NULL THEN EffectiveDate END)
	FROM AccountChanges
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND InactiveDate IS NULL
		AND EffectiveDate <= @expdate

	SELECT	@expend_close = MAX(CASE WHEN CancelReasonID IS NOT NULL THEN EffectiveDate END),
		@expend_open = MAX(CASE WHEN CancelReasonID IS NULL THEN EffectiveDate END), 
		@expend_minAccountTypeID = MIN(CASE WHEN CancelReasonID IS NULL THEN AccountTypeID END),
		@expend_maxAccountTypeID = MAX(CASE WHEN CancelReasonID IS NULL THEN AccountTypeID END),
		@expend_lastat = MAX(CASE WHEN CancelReasonID IS NULL AND AccountTypeID IS NOT NULL THEN EffectiveDate END)
	FROM AccountChanges
		WHERE CustomerID = @CustomerID
		AND AccountID = @AccountID
		AND InactiveDate IS NULL
		AND EffectiveDate > @expdate
		AND EffectiveDate <= @now

	IF (@expstart_close IS NULL OR @expstart_open > @expstart_close)
		BEGIN
		SELECT @reinvoice = 1
		INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,CancelReasonID,CreateUser,InactiveUser) VALUES(@CustomerID,@AccountID,getdate(),@expdate,@expCancelReasonID,'GBE',NULL)
		END

	IF ((@expend_open IS NOT NULL OR @expend_close IS NOT NULL) AND (@expend_minAccountTypeID IS NOT NULL OR @expend_close IS NULL OR @expend_open > @expend_close))
		BEGIN
		IF (@expend_minAccountTypeID IS NOT NULL AND @expend_minAccountTypeID <> @expend_maxAccountTypeID)
			BEGIN
			SELECT @expend_minAccountTypeID = MIN(AccountTypeID)
			FROM AccountChanges
				WHERE CustomerID = @CustomerID
				AND AccountID = @AccountID
				AND InactiveDate IS NULL
				AND CancelReasonID IS NULL
				AND AccountTypeID IS NOT NULL
				AND EffectiveDate = @expend_lastat
			END

		IF (@expend_open IS NOT NULL AND (@expend_close IS NULL OR @expend_open > @expend_close))
			BEGIN
			UPDATE AccountChanges SET InactiveDate = getdate()
				WHERE CustomerID = @CustomerID
				AND AccountID = @AccountID
				AND InactiveDate IS NULL
				AND EffectiveDate > @expdate
				AND EffectiveDate <= @now
			END
		END

	IF ((@expend_close IS NULL OR @expend_open > @expend_close) OR (@expend_close IS NULL AND @expend_open IS NULL AND @reinvoice = 1))
		BEGIN
		SELECT @reinvoice = 1
		INSERT INTO AccountChanges (CustomerID,AccountID,ActiveDate,EffectiveDate,CancelReasonID,AccountTypeID,CreateUser,InactiveUser) VALUES(@CustomerID,@AccountID,getdate(),@now,NULL,@expend_minAccountTypeID,'GBE',NULL)
		END
	END
END

IF (@ItemType IN (0,2) AND @ChargeTypeID IS NOT NULL AND @AccountID IS NOT NULL)
BEGIN
SELECT @TimeChargeID = MAX(tc.TimeChargeID), @Quantity = MAX(ii.Quantity), @AutoBill = MAX(bc.AutoBill), @Months = MAX(tc.Months * ii.Quantity), @Days = MAX(tc.Days * ii.Quantity), @Minutes = MAX(tc.Minutes * ii.Quantity), @TimeLeft = MAX(tc.TimeLeft * ii.Quantity), @RateTimeLeft = MAX(tc.RateTimeLeft * ii.Quantity), @DataLeft = MAX(tc.DataLeft * ii.Quantity), @RateDataLeft = MAX(tc.RateDataLeft * ii.Quantity), @PaidFlag = MAX(ii.PaidFlag)
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	WHERE tc.ChargeTypeID = @ChargeTypeID
	AND ii.ItemID = @ItemID
	AND ma.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND ma.Active = 1
	AND sa.Active = 1

SELECT @trackmode = NumValue FROM Configs WHERE ConfigID = 535
SELECT @trackmode = COALESCE(MAX(NumValue),@trackmode)
FROM ConfigGroupData
	WHERE GroupID = @GroupID
	AND ConfigID = 535

SELECT @expmode = NumValue FROM Configs WHERE ConfigID = 712
SELECT @expmode = COALESCE(MAX(NumValue),@trackmode,1)
FROM ConfigGroupData
	WHERE GroupID = @GroupID
	AND ConfigID = 712

IF (@TimeChargeID IS NOT NULL AND @PaidFlag = 0 AND @Quantity > 0 AND @AccountID IS NOT NULL)
	BEGIN
	IF (@trackmode = 2 AND (@TimeLeft > 0 OR @RateTimeLeft > 0 OR @DataLeft > 0 OR @RateDataLeft > 0))
		BEGIN	
		INSERT INTO SubAccountUsages (AccountID,ItemID,TimeLeft,StartTimeLeft,RateTimeLeft,StartRateTimeLeft,DataLeft,StartDataLeft,RateDataLeft,StartRateDataLeft,ExpireDate)
		SELECT @AccountID,@ItemID,COALESCE(@TimeLeft,0),COALESCE(@TimeLeft,0),COALESCE(@RateTimeLeft,0),COALESCE(@RateTimeLeft,0),COALESCE(@DataLeft,0),COALESCE(@DataLeft,0),COALESCE(@RateDataLeft,0),COALESCE(@RateDataLeft,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN DATEADD(yy,2,getdate()) ELSE DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),getdate()))) END
		FROM SubAccounts
			WHERE AccountID = @AccountID
		END

	UPDATE SubAccounts SET 
		BilledThru = CASE WHEN @AutoBill = 2 OR Recurring = 0 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < getdate() THEN getdate() ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
		ExpireDate = CASE WHEN @AutoBill = 2 OR Recurring = 0 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN ExpireDate WHEN ExpireDate < getdate() THEN getdate() ELSE ExpireDate END))) ELSE ExpireDate END,
		TimeLeft = CASE WHEN @TimeLeft IS NULL OR TimeLeft IS NULL OR @trackmode = 2 THEN TimeLeft WHEN (@AutoBill = 2 OR Recurring = 0) AND ExpireDate < getdate() AND @expmode = 1 THEN @TimeLeft WHEN TimeLeft >= 0 THEN TimeLeft + @TimeLeft ELSE @TimeLeft END,
		RateTimeLeft = CASE WHEN @RateTimeLeft IS NULL OR RateTimeLeft IS NULL OR @trackmode = 2 THEN RateTimeLeft WHEN (@AutoBill = 2 OR Recurring = 0) AND ExpireDate < getdate() AND @expmode = 1  THEN @RateTimeLeft WHEN RateTimeLeft >= 0 THEN RateTimeLeft + @RateTimeLeft ELSE @RateTimeLeft END,
		DataLeft = CASE WHEN @DataLeft IS NULL OR DataLeft IS NULL OR @trackmode = 2 THEN DataLeft WHEN (@AutoBill = 2 OR Recurring = 0) AND ExpireDate < getdate() AND @expmode = 1  THEN @DataLeft WHEN DataLeft >= 0 THEN DataLeft + @DataLeft ELSE @DataLeft END,
		RateDataLeft = CASE WHEN @RateDataLeft IS NULL OR RateDataLeft IS NULL OR @trackmode = 2 THEN RateDataLeft WHEN (@AutoBill = 2 OR Recurring = 0) AND ExpireDate < getdate() AND @expmode = 1 THEN @RateDataLeft WHEN RateDataLeft >= 0 THEN RateDataLeft + @RateDataLeft ELSE @RateDataLeft END
		WHERE AccountID=@AccountID
	
	UPDATE InvoiceItems SET PaidFlag = 1 WHERE ItemID = @ItemID
	END
END

IF (@stmtLateCharge = 0 AND @itemLateCharge = 0)
BEGIN
SELECT @LateFeeID = lf.LateFeeID, @LateFeeTypeID = lf.LateFeeTypeID, @GraceDays = lf.GraceDays
FROM LateFees lf LEFT JOIN ServiceGroupItems sgi ON (lf.ServiceGroupID = sgi.ServiceGroupID AND sgi.GroupID = @GroupID)
	LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND lf.MarketTagID = mat.MarketTagID)
	WHERE lf.LateFeeTypeID IN (1,2)
	AND lf.Active = 1
	AND (lf.GroupID IS NULL OR lf.GroupID = @GroupID OR sgi.ServiceGroupID IS NOT NULL)
	AND (lf.MarketTagID IS NULL OR mat.Active = 1)
ORDER BY lf.PriorityID ASC, lf.SortOrder DESC, lf.LateFeeID DESC

IF (@LateFeeID IS NOT NULL AND @StatementID IS NOT NULL)
	BEGIN
	SELECT @cont = SUM(CASE WHEN ROUND(ii.Amount * ii.Quantity,2) - ii.PaidAmount > 0 OR ii.LateCharge = 1 THEN 1 ELSE 0 END), @latestart = MAX(CASE WHEN s.DueDate > DATEADD(dd,@GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,@GraceDays,s.StatementDate) END)
	FROM Statements s JOIN Invoices i ON (s.StatementID = i.StatementID)
		JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
		WHERE s.StatementID = @StatementID
		AND i.VoidDate IS NULL
		AND i.PayPlanID IS NULL
		AND i.Processed = 1
		AND ii.Amount > 0
		AND ii.Quantity > 0

	IF (@cont = 0 AND @LateFeeTypeID = 1)
		BEGIN
		SELECT @latecharge = MAX(lfd.Amount)
		FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
			JOIN LateFeeDays lfd ON (lfd.LateFeeID = @LateFeeID)
			JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
			JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
			WHERE i.StatementID = @StatementID
			AND ii.Amount > 0
			AND ii.Quantity > 0
			AND i.Processed = 1
			AND i.VoidDate IS NULL
			AND i.PayPlanID IS NULL
			AND pi1.InactiveDate IS NULL
			AND COALESCE(p.EffectiveDate,p.CreateDate) >= DATEADD(dd,lfd.OverDays,@latestart)
		GROUP BY lfd.LateFeeDayID
		HAVING SUM(pi1.Amount) >= MAX(lfd.OverAmount)
		ORDER BY MIN(lfd.OverDays) ASC,MIN(lfd.OverAmount) ASC
		END
	IF (@cont = 0 AND @LateFeeTypeID = 2)
		BEGIN
		CREATE TABLE #iipa (Amount NUMERIC(18,4), OverDays INT)

		INSERT INTO #iipa (Amount,OverDays)
		SELECT MIN(pi1.Amount) AS Amount, MAX(lfd.OverDays) AS OverDays
		FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
			JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
			JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
			JOIN LateFeeDays lfd ON (lfd.LateFeeID = @LateFeeID AND lfd.OverDays > DATEDIFF(dd,@latestart,COALESCE(p.EffectiveDate,p.CreateDate)))
			WHERE i.StatementID = @StatementID
			AND ii.Amount > 0
			AND ii.Quantity > 0
			AND i.Processed = 1
			AND i.VoidDate IS NULL
			AND i.PayPlanID IS NULL
			AND pi1.InactiveDate IS NULL
			AND COALESCE(p.EffectiveDate,p.CreateDate) >= DATEADD(dd,lfd.OverDays,@latestart)
		GROUP BY pi1.PaymentItemID

		SELECT @latecharge = SUM(iipa.Amount * (lfd.Amount / 100))
		FROM LateFeeDays lfd, #iipa iipa
			WHERE lfd.LateFeeID = @LateFeeID
			AND lfd.OverDays = iipa.OverDays
		END
	END

IF (@LateFeeID IS NULL AND (@ChargeTypeID IS NOT NULL OR @ServiceCategoryID IS NOT NULL))
	BEGIN
	SELECT @LateFeeID = lf.LateFeeID, @GraceDays = lf.GraceDays
	FROM LateFees lf LEFT JOIN ServiceGroupItems sgi ON (lf.ServiceGroupID = sgi.ServiceGroupID AND sgi.GroupID = @GroupID)
		LEFT JOIN LateFeeServiceCats lfsc ON (lf.LateFeeID = lfsc.LateFeeID AND lfsc.ServiceCategoryID = @ServiceCategoryID)
		LEFT JOIN LateFeeChargeTypes lfct ON (lf.LateFeeID = lfct.LateFeeID AND lfct.ChargeTypeID = @ChargeTypeID)
		LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND lf.MarketTagID = mat.MarketTagID)
		LEFT JOIN SubAccountTags sat ON (sat.AccountID = @AccountID AND lf.MarketTagID = sat.MarketTagID)
		WHERE lf.LateFeeTypeID = 3
		AND lf.Active = 1
		AND (lf.GroupID IS NULL OR lf.GroupID = @GroupID OR sgi.ServiceGroupID IS NOT NULL)
		AND (lf.MarketTagID IS NULL OR mat.Active = 1 OR sat.Active = 1)
		AND (@ServiceCategoryID IS NULL OR lfsc.LateFeeID IS NOT NULL)
		AND (@ChargeTypeID IS NULL OR lfct.LateFeeID IS NOT NULL)
	ORDER BY lf.PriorityID ASC, lf.SortOrder DESC, lf.LateFeeID DESC

	IF (@LateFeeID IS NOT NULL)
		BEGIN
		SELECT @cont = SUM(CASE WHEN ROUND(ii.Amount * ii.Quantity,2) - ii.PaidAmount > 0 OR ii.LateCharge = 1 THEN 1 ELSE 0 END), @latestart = MAX(CASE WHEN s.DueDate > DATEADD(dd,@GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,@GraceDays,s.StatementDate) END)
		FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
			JOIN Statements s ON (i.StatementID = s.StatementID)
			WHERE s.StatementID = @StatementID
			AND (@ChargeTypeID IS NULL OR ii.ChargeTypeID = @ChargeTypeID)
			AND (@AccountID IS NULL OR ii.AccountID = @AccountID)
			AND ii.ItemType = @ItemType
			AND i.VoidDate IS NULL
			AND i.PayPlanID IS NULL
			AND i.Processed = 1
			AND ii.Amount > 0
			AND ii.Quantity > 0

		IF (@cont = 0)
			BEGIN
			CREATE TABLE #iipb (Amount NUMERIC(18,4), OverDays INT)

			INSERT INTO #iipb (Amount,OverDays)
			SELECT MIN(pi1.Amount) AS Amount, MAX(lfd.OverDays) AS OverDays
			FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
				JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
				JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
				JOIN LateFeeDays lfd ON (lfd.LateFeeID = @LateFeeID AND lfd.OverDays > DATEDIFF(dd,@latestart,COALESCE(p.EffectiveDate,p.CreateDate)))
				WHERE i.StatementID = @StatementID
				AND (@ChargeTypeID IS NULL OR ii.ChargeTypeID = @ChargeTypeID)
				AND (@AccountID IS NULL OR ii.AccountID = @AccountID)
				AND ii.ItemType = @ItemType
				AND ii.Amount > 0
				AND ii.Quantity > 0
				AND i.Processed = 1
				AND i.VoidDate IS NULL
				AND i.PayPlanID IS NULL
				AND pi1.InactiveDate IS NULL
				AND COALESCE(p.EffectiveDate,p.CreateDate) >= DATEADD(dd,lfd.OverDays,@latestart)

			SELECT @latecharge = SUM(iipb.Amount * (lfd.Amount / 100))
			FROM LateFeeDays lfd JOIN #iipb iipb ON (lfd.OverDays = iipb.OverDays)
				WHERE lfd.LateFeeID = @LateFeeID
			END
		END
	END

IF (@latecharge IS NOT NULL AND @LateFeeID IS NOT NULL)
	BEGIN
	INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,AccountTypeID,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,CreateDate,CreateUser,LastModifyDate,LastModifyUser)
	SELECT @CustomerID, NULL AS Description, getdate() AS StartDate, getdate() AS EndDate, @AccountID AS AccountID, NULL AS AccountTypeID, 0 AS AllowInterim, 
	CASE WHEN lf.MinAmount IS NOT NULL AND @latecharge < lf.MinAmount THEN lf.MinAmount WHEN lf.MaxAmount IS NOT NULL AND @latecharge > lf.MaxAmount THEN lf.MaxAmount ELSE @latecharge END AS Amount,
	1 AS Quantity, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate() AS CreateDate, 'GBE' AS CreateUser, getdate() AS LastModifyDate, 'GBE' AS LastModifyUser
	FROM LateFees lf JOIN ChargeTypes ct ON (lf.ChargeTypeID = ct.ChargeTypeID)
		WHERE lf.LateFeeID = @LateFeeID

	IF (@LateFeeTypeID IN (1,2))
		BEGIN
		UPDATE Statements SET LateCharge = 1 WHERE StatementID = @StatementID AND LateCharge = 0
		END

	IF (@LateFeeTypeID = 3)
		BEGIN
		UPDATE InvoiceItems SET LateCharge = 1
		FROM InvoiceItems ii JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
			WHERE i.StatementID = @StatementID
			AND (@ChargeTypeID IS NULL OR ii.ChargeTypeID = @ChargeTypeID)
			AND (@AccountID IS NULL OR ii.AccountID = @AccountID)
			AND ii.ItemType = @ItemType
			AND i.VoidDate IS NULL
			AND i.PayPlanID IS NULL
			AND i.Processed = 1
			AND ii.Amount > 0
			AND ii.Quantity > 0
			AND ii.LateCharge = 0
		END
	END
END

SELECT @reinvoice AS Reinvoice
GO

CREATE PROCEDURE dbo.InvoiceItemPayUpdate (@newAmount NUMERIC(18,4), @ItemID INT, @curAmount NUMERIC(18,4)) AS 
UPDATE InvoiceItems SET PaidAmount = @newAmount 
	WHERE ItemID = @ItemID
	AND PaidAmount = @curAmount
GO

CREATE PROCEDURE dbo.LateFeeCreate (@GroupID INT, @Preview TINYINT) WITH RECOMPILE AS
SET NOCOUNT ON
DECLARE @stmtcnt INT, @itemcnt INT

IF ((SELECT COUNT(*) FROM LateFees WHERE Active = 1 AND MaxDays IS NOT NULL AND MaxDays > 0) = 0)
BEGIN
RETURN
END

CREATE TABLE #lfg (CustomerID INT, Preference INT, LateFeeID INT)
CREATE TABLE #lfgm (CustomerID INT, LateFeeID INT, LateFeeTypeID SMALLINT, MaxDays SMALLINT, GraceDays SMALLINT)

CREATE TABLE #lfqs (CustomerID INT, StatementID INT, Unpaid NUMERIC(18,4), LateFeeID INT, LateFeeTypeID SMALLINT, LateStart DATETIME)
CREATE TABLE #lfqi (CustomerID INT, ItemID INT, Unpaid NUMERIC(18,4), LateFeeID INT, LateFeeTypeID SMALLINT, LateStart DATETIME)

CREATE TABLE #lfcs (CustomerID INT, StatementID INT, LateFeeID INT, Amount NUMERIC(18,4), OverDays SMALLINT)
CREATE TABLE #lfci (CustomerID INT, ItemID INT, LateFeeID INT, Amount NUMERIC(18,4), OverDays SMALLINT)
CREATE TABLE #lfcsm (CustomerID INT, StatementID INT, LateFeeID INT, Amount NUMERIC(18,4))
CREATE TABLE #lfcim (CustomerID INT, ItemID INT, LateFeeID INT, Amount NUMERIC(18,4))

INSERT INTO #lfg (CustomerID,Preference,LateFeeID)
SELECT ma.CustomerID, (lf.PriorityID * 100000) + lf.SortOrder, lf.LateFeeID
FROM MasterAccounts ma JOIN LateFees lf ON (lf.LateFeeTypeID IN (1,2,3))
	LEFT JOIN ServiceGroupItems sgi ON (lf.ServiceGroupID = sgi.ServiceGroupID AND sgi.GroupID = ma.GroupID)
	LEFT JOIN MasterAccountTags mat ON (ma.CustomerID = mat.CustomerID AND lf.MarketTagID = mat.MarketTagID)
	WHERE ma.Active = 1
	AND lf.Active = 1
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (lf.GroupID IS NULL OR lf.GroupID = ma.GroupID OR sgi.ServiceGroupID IS NOT NULL)
	AND (lf.MarketTagID IS NULL OR mat.Active = 1)

INSERT INTO #lfgm (CustomerID,LateFeeID,LateFeeTypeID,MaxDays,GraceDays)
SELECT l.CustomerID, l.LateFeeID, lf.LateFeeTypeID, lf.MaxDays, lf.GraceDays
FROM #lfg l JOIN (SELECT CustomerID,MAX(Preference) AS Preference FROM #lfg GROUP BY CustomerID) lg ON (l.CustomerID = lg.CustomerID AND l.Preference = lg.Preference)
	JOIN LateFees lf ON (l.LateFeeID = lf.LateFeeID)
	WHERE lf.Active = 1
	AND lf.MaxDays > 0

INSERT INTO #lfqs (CustomerID,StatementID,Unpaid,LateFeeID,LateFeeTypeID,LateStart)
SELECT MIN(l.CustomerID), s.StatementID, SUM(ROUND(ii.Amount * ii.Quantity,2) - ii.PaidAmount), MIN(l.LateFeeID), MIN(l.LateFeeTypeID), MAX(CASE WHEN s.DueDate > DATEADD(dd,l.GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,l.GraceDays,s.StatementDate) END)
FROM #lfgm l JOIN Statements s ON (l.CustomerID = s.CustomerID)
	JOIN Invoices i ON (i.StatementID = s.StatementID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	WHERE s.LateCharge = 0
	AND ii.LateCharge = 0
	AND s.EndBal > 0
	AND l.LateFeeTypeID IN (1,2)
	AND i.VoidDate IS NULL
	AND i.PayPlanID IS NULL
	AND DATEDIFF(dd,CASE WHEN s.DueDate > DATEADD(dd,l.GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,l.GraceDays,s.StatementDate) END,getdate()) BETWEEN l.MaxDays AND l.MaxDays + 5
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Processed = 1
	AND ii.PaidAmount < (ROUND(ii.Amount * ii.Quantity,2))
GROUP BY s.StatementID

INSERT INTO #lfqi (CustomerID,ItemID,Unpaid,LateFeeID,LateFeeTypeID,LateStart)
SELECT MIN(l.CustomerID), MIN(ii.ItemID), SUM(ROUND(ii.Amount * ii.Quantity,2) - ii.PaidAmount), MIN(l.LateFeeID), MIN(l.LateFeeTypeID), MAX(CASE WHEN s.DueDate > DATEADD(dd,l.GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,l.GraceDays,s.StatementDate) END)
FROM #lfgm l JOIN Statements s ON (l.CustomerID = s.CustomerID)
	JOIN Invoices i ON (i.StatementID = s.StatementID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID AND ii.ItemType = 3)
	LEFT JOIN LateFeeServiceCats lfsc ON (l.LateFeeID = lfsc.LateFeeID AND sa.ServiceCategoryID = lfsc.ServiceCategoryID)
	LEFT JOIN LateFeeChargeTypes lfct ON (l.LateFeeID = lfct.LateFeeID AND ii.ChargeTypeID = lfct.ChargeTypeID)
	WHERE s.LateCharge = 0
	AND ii.LateCharge = 0
	AND s.EndBal > 0
	AND l.LateFeeTypeID = 3
	AND i.VoidDate IS NULL
	AND i.PayPlanID IS NULL
	AND DATEDIFF(dd,CASE WHEN s.DueDate > DATEADD(dd,l.GraceDays,s.StatementDate) THEN s.DueDate ELSE DATEADD(dd,l.GraceDays,s.StatementDate) END,getdate()) BETWEEN l.MaxDays AND l.MaxDays + 5
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Processed = 1
	AND ii.PaidAmount < (ROUND(ii.Amount * ii.Quantity,2))
	AND (lfsc.ServiceCategoryID IS NOT NULL OR lfct.ChargeTypeID IS NOT NULL)
GROUP BY ii.ItemID

INSERT INTO #lfcs (CustomerID,StatementID,LateFeeID,Amount,OverDays)
SELECT MIN(l.CustomerID), l.StatementID, MIN(l.LateFeeID), MAX(lfd.Amount), MIN(lfd.OverDays)
FROM #lfqs l JOIN Invoices i ON (l.StatementID = i.StatementID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN LateFeeDays lfd ON (lfd.LateFeeID = l.LateFeeID)
	LEFT JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID AND pi1.InactiveDate IS NULL)
	LEFT JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
	WHERE l.LateFeeTypeID = 1
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.LateCharge = 0
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND i.PayPlanID IS NULL
	AND (COALESCE(p.EffectiveDate,p.CreateDate,getdate()) >= DATEADD(dd,lfd.OverDays,l.LateStart))
GROUP BY l.StatementID,lfd.LateFeeDayID
HAVING COALESCE(SUM(pi1.Amount),0) + MIN(l.Unpaid) >= MAX(lfd.OverAmount)

INSERT INTO #lfcsm (CustomerID,StatementID,LateFeeID,Amount)
SELECT MIN(l.CustomerID), l.StatementID, MIN(l.LateFeeID), MAX(l.Amount)
FROM #lfcs l JOIN (SELECT StatementID, MAX(OverDays) AS OverDays FROM #lfcs GROUP BY StatementID) lg ON (l.StatementID = lg.StatementID AND l.OverDays = lg.OverDays)
GROUP BY l.StatementID

TRUNCATE TABLE #lfcs

INSERT INTO #lfcs (CustomerID,StatementID,LateFeeID,Amount,OverDays)
SELECT MIN(l.CustomerID), l.StatementID, MIN(l.LateFeeID), MIN(l.Unpaid), MAX(lfd.OverDays)
FROM #lfqs l JOIN LateFeeDays lfd ON (lfd.LateFeeID = l.LateFeeID)
	WHERE l.LateFeeTypeID = 2
	AND getdate() >= DATEADD(dd,lfd.OverDays,l.LateStart)
	AND l.Unpaid > 0
GROUP BY l.StatementID

INSERT INTO #lfcs (CustomerID,StatementID,LateFeeID,Amount,OverDays)
SELECT MIN(l.CustomerID), l.StatementID, MIN(l.LateFeeID), MIN(pi1.Amount), MAX(lfd.OverDays)
FROM #lfqs l JOIN Invoices i ON (l.StatementID = i.StatementID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN LateFeeDays lfd ON (lfd.LateFeeID = l.LateFeeID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID AND pi1.InactiveDate IS NULL)
	JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
	WHERE l.LateFeeTypeID = 2
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.LateCharge = 0
	AND i.Processed = 1
	AND i.VoidDate IS NULL
	AND i.PayPlanID IS NULL
	AND COALESCE(p.EffectiveDate,p.CreateDate) >= DATEADD(dd,lfd.OverDays,l.LateStart)
GROUP BY l.StatementID, pi1.PaymentItemID

INSERT INTO #lfcsm (CustomerID,StatementID,LateFeeID,Amount)
SELECT MIN(l.CustomerID), l.StatementID, MIN(l.LateFeeID), SUM(l.Amount * lfd.Amount / 100)
FROM #lfcs l JOIN LateFeeDays lfd ON (l.LateFeeID = lfd.LateFeeID AND l.OverDays = lfd.OverDays)
GROUP BY l.StatementID

SELECT @stmtcnt = COUNT(*) FROM #lfcsm


INSERT INTO #lfci (CustomerID,ItemID,LateFeeID,Amount,OverDays)
SELECT MIN(l.CustomerID), l.ItemID, MIN(l.LateFeeID), MIN(l.Unpaid), MAX(lfd.OverDays)
FROM #lfqi l JOIN LateFeeDays lfd ON (lfd.LateFeeID = l.LateFeeID)
	WHERE l.LateFeeTypeID = 3
	AND getdate() >= DATEADD(dd,lfd.OverDays,l.LateStart)
	AND l.Unpaid > 0
GROUP BY l.ItemID

INSERT INTO #lfci (CustomerID,ItemID,LateFeeID,Amount,OverDays)
SELECT MIN(l.CustomerID), l.ItemID, MIN(l.LateFeeID), MIN(pi1.Amount), MIN(lfd.OverDays)
FROM #lfqi l JOIN InvoiceItems ii ON (l.ItemID = ii.ItemID)
	JOIN LateFeeDays lfd ON (lfd.LateFeeID = l.LateFeeID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID AND pi1.InactiveDate IS NULL)
	JOIN Payments p ON (pi1.PaymentID = p.PaymentID)
	WHERE l.LateFeeTypeID = 3
	AND COALESCE(p.EffectiveDate,p.CreateDate) >= DATEADD(dd,lfd.OverDays,l.LateStart)
GROUP BY l.ItemID, pi1.PaymentItemID

INSERT INTO #lfcim (CustomerID,ItemID,LateFeeID,Amount)
SELECT MIN(l.CustomerID), l.ItemID, MIN(l.LateFeeID), SUM(l.Amount * lfd.Amount / 100)
FROM #lfci l JOIN LateFeeDays lfd ON (l.LateFeeID = lfd.LateFeeID AND l.OverDays = lfd.OverDays)
GROUP BY l.ItemID

SELECT @itemcnt = COUNT(*) FROM #lfcim

IF (@Preview = 0)
BEGIN

IF (@stmtcnt > 0)
	BEGIN
	UPDATE Statements SET LateCharge = 1 WHERE StatementID IN (SELECT StatementID FROM #lfcsm) AND LateCharge = 0
	
	IF (@@ROWCOUNT <> @stmtcnt)
		BEGIN
		RAISERROR('Change conflict detected updating statement late charge status',11,1)
		END

	INSERT INTO Charges (CustomerID,StartDate,EndDate,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,CreateDate,CreateUser,LastModifyDate,LastModifyUser)
	SELECT l.CustomerID, getdate() AS StartDate, getdate() AS EndDate, 0 AS AllowInterim, 
	CASE WHEN l.Amount < lf.MinAmount THEN lf.MinAmount WHEN l.Amount > lf.MaxAmount THEN lf.MaxAmount ELSE l.Amount END AS Amount,
	1 AS Quantity, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate() AS CreateDate, 'GBE' AS CreateUser, getdate() AS LastModifyDate, 'GBE' AS LastModifyUser
	FROM #lfcsm l JOIN LateFees lf ON (l.LateFeeID = lf.LateFeeID)
		JOIN ChargeTypes ct ON (lf.ChargeTypeID = ct.ChargeTypeID)
	END

IF (@itemcnt > 0)
	BEGIN
	UPDATE InvoiceItems SET LateCharge = 1 WHERE ItemID IN (SELECT ItemID FROM #lfcim) AND LateCharge = 0

	IF (@@ROWCOUNT <> @itemcnt)
		BEGIN
		RAISERROR('Change conflict detected updating invoice line item late charge status',11,1)
		END

	INSERT INTO Charges (CustomerID,StartDate,EndDate,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,CreateDate,CreateUser,LastModifyDate,LastModifyUser)
	SELECT l.CustomerID, getdate() AS StartDate, getdate() AS EndDate, 0 AS AllowInterim, 
	CASE WHEN l.Amount < lf.MinAmount THEN lf.MinAmount WHEN l.Amount > lf.MaxAmount THEN lf.MaxAmount ELSE l.Amount END AS Amount,
	1 AS Quantity, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate() AS CreateDate, 'GBE' AS CreateUser, getdate() AS LastModifyDate, 'GBE' AS LastModifyUser
	FROM #lfcim l JOIN LateFees lf ON (l.LateFeeID = lf.LateFeeID)
		JOIN ChargeTypes ct ON (lf.ChargeTypeID = ct.ChargeTypeID)
	END

SELECT CAST(@stmtcnt + @itemcnt AS VARCHAR(16)) + ' late charges processed' AS Description
END ELSE BEGIN

SELECT ma.CustomerID, a.FirstName, a.LastName, a.Company, lf.LateFee, 
CASE WHEN l.Amount < lf.MinAmount THEN lf.MinAmount WHEN l.Amount > lf.MaxAmount THEN lf.MaxAmount ELSE l.Amount END AS Amount,
lft.LateFeeType, l.StatementID, NULL AS InvoiceID, NULL AS ItemID
FROM #lfcsm l JOIN MasterAccounts ma ON (l.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	JOIN LateFees lf ON (l.LateFeeID = lf.LateFeeID)
	JOIN LateFeeTypes lft ON (lf.LateFeeTypeID = lft.LateFeeTypeID)
UNION ALL
SELECT ma.CustomerID, a.FirstName, a.LastName, a.Company, lf.LateFee, 
CASE WHEN l.Amount < lf.MinAmount THEN lf.MinAmount WHEN l.Amount > lf.MaxAmount THEN lf.MaxAmount ELSE l.Amount END,
lft.LateFeeType, NULL, ii.InvoiceID, l.ItemID
FROM #lfcim l JOIN MasterAccounts ma ON (l.CustomerID = ma.CustomerID)
	JOIN InvoiceItems ii ON (l.ItemID = ii.ItemID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	JOIN LateFees lf ON (l.LateFeeID = lf.LateFeeID)
	JOIN LateFeeTypes lft ON (lf.LateFeeTypeID = lft.LateFeeTypeID)
END
GO

CREATE PROCEDURE dbo.InvoicePOSCredit (@InvoiceID INT) AS
SET NOCOUNT ON
INSERT INTO Charges (CustomerID,AccountID,ChargeTypeID,AccountTypeID,ItemID,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser,CreateUser)
SELECT i.CustomerID, ii.AccountID, ii.ChargeTypeID, ii.AccountTypeID, ii.ItemID, ii.Description, ii.StartDate, ii.EndDate, 1, ii.Amount, ii.Quantity, i.LastModifyDate, i.LastModifyUser, i.LastModifyUser
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	WHERE i.InvoiceID = @InvoiceID
	AND ii.Quantity > 0
	AND ii.Amount <= -0.01
GO

CREATE PROCEDURE dbo.InvoiceRepay (@CustomerID INT) AS
SET NOCOUNT ON
UPDATE i SET PaidAmount = COALESCE(aii.PaidAmount,0), ChargeAmount = COALESCE(aii.ChargeAmount,0)
FROM Invoices i LEFT JOIN
	(
	SELECT InvoiceID, SUM(ROUND(PaidAmount,2)) AS PaidAmount, SUM(ROUND(Amount * Quantity,2)) AS ChargeAmount
	FROM InvoiceItems
		WHERE Amount > 0
	GROUP BY InvoiceID
	) aii ON (i.InvoiceID = aii.InvoiceID)
	WHERE i.PaidAmount = 0
	AND i.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.InvoiceSAUpdate (@InvoiceID INT, @AccountID INT, @startBilledThru DATETIME, @endBilledThru DATETIME, @startInvoicedDays INT, @endInvoicedDays INT, @Cost NUMERIC(18,4)) AS 
SET NOCOUNT ON
INSERT INTO InvoiceSubAccounts (InvoiceID,AccountID,BilledThru,InvoicedDays) VALUES(@InvoiceID,@AccountID,@startBilledThru,@startInvoicedDays)

UPDATE SubAccounts SET BilledThru = @endBilledThru, InvoicedDays = @endInvoicedDays, Cost = @Cost
	WHERE AccountID = @AccountID
	AND BilledThru >= @startBilledThru
	AND BilledThru < DATEADD(dd,1,@startBilledThru)
	AND InvoicedDays = @startInvoicedDays

SELECT @@ROWCOUNT AS Cnt
GO

CREATE PROCEDURE dbo.InvoiceTagAdd (@InvoiceID INT, @AccountID INT, @MarketTagID INT, @initialInvoicedDays INT, @InvoicedDays INT, @CancelItemID INT) AS
SET NOCOUNT ON
DECLARE @Cnt INT

INSERT INTO InvoiceTags (InvoiceID,AccountID,MarketTagID,InvoicedDays) VALUES(@InvoiceID,@AccountID,@MarketTagID,@initialInvoicedDays)

UPDATE SubAccountTags SET InvoicedDays = @InvoicedDays, CancelItemID = COALESCE(CancelItemID,@CancelItemID)
	WHERE AccountID = @AccountID
	AND MarketTagID = @MarketTagID
	AND InvoicedDays = @initialInvoicedDays

SELECT @Cnt  = @@ROWCOUNT

IF (@Cnt = 0)
BEGIN
IF (@initialInvoicedDays = 0 AND (SELECT COUNT(*) FROM SubAccountTags WHERE AccountID = @AccountID AND MarketTagID = @MarketTagID) = 0)
	BEGIN
	INSERT INTO SubAccountTags (AccountID,MarketTagID,CreateUser,CreateDate,InvoicedDays) VALUES(@AccountID,@MarketTagID,NULL,getdate(),@InvoicedDays)
	SELECT @Cnt = @@ROWCOUNT
	END
END

SELECT @Cnt AS Cnt
GO

CREATE PROCEDURE dbo.InvoiceVoidCheck (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @checkorder INT

SELECT @checkorder = cgd.NumValue
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 644)
	WHERE i.InvoiceID = @InvoiceID

IF (@checkorder IS NULL)
BEGIN
SELECT @checkorder = COALESCE(MIN(NumValue),1) FROM Configs WHERE ConfigID = 644
END

IF (@checkorder = 1)
BEGIN
SELECT MIN(i2.InvoiceID) AS InvoiceID
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Invoices i2 ON (i2.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii2 ON (i2.InvoiceID = ii2.InvoiceID)
	WHERE i.InvoiceID = @InvoiceID
	AND ii.ItemType = 3
	AND ii2.ItemType = 3
	AND ii.AccountID = ii2.AccountID
	AND i2.VoidDate IS NULL
	AND i2.Processed = 1
	AND ii2.EndDate >= ii.StartDate
	AND i2.InvoiceID <> @InvoiceID
END ELSE BEGIN
SELECT NULL AS InvoiceID
END
GO

CREATE PROCEDURE dbo.InvoiceVoidDupeCharges (@InvoiceID INT) AS
SET NOCOUNT ON

UPDATE Charges SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID) AND AllowDupe = 1
UPDATE ResellerUsage SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
GO

CREATE PROCEDURE dbo.InvoiceVoidSAUpdate (@InvoiceID INT) AS
SET NOCOUNT ON

UPDATE Charges SET DistFlag = 1 WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE Amount < 0 AND Quantity > 0 AND InvoiceID = @InvoiceID)

UPDATE sa SET
	TimeLeft = TimeLeft - COALESCE(asau.StartTimeLeft,0),
	DataLeft = DataLeft - COALESCE(asau.StartDataLeft,0),
	RateTimeLeft = RateTimeLeft - COALESCE(asau.StartRateTimeLeft,0),
	RateDataLeft = RateDataLeft - COALESCE(asau.StartRateDataLeft,0)

FROM SubAccounts sa LEFT JOIN
	(
	SELECT sau.AccountID,
	SUM(CASE WHEN sau.StartTimeLeft IS NOT NULL THEN sau.StartTimeLeft - CASE WHEN sau.TimeLeft < 0 THEN 0 ELSE sau.TimeLeft END ELSE 0 END) AS StartTimeLeft,
	SUM(CASE WHEN sau.StartDataLeft IS NOT NULL THEN sau.StartDataLeft - CASE WHEN sau.DataLeft < 0 THEN 0 ELSE sau.DataLeft END ELSE 0 END) AS StartDataLeft,
	SUM(CASE WHEN sau.StartRateTimeLeft IS NOT NULL THEN sau.StartRateTimeLeft - CASE WHEN sau.RateTimeLeft < 0 THEN 0 ELSE sau.RateTimeLeft END ELSE 0 END) AS StartRateTimeLeft,
	SUM(CASE WHEN sau.StartRateDataLeft IS NOT NULL THEN sau.StartRateDataLeft - CASE WHEN sau.RateDataLeft < 0 THEN 0 ELSE sau.RateDataLeft END ELSE 0 END) AS StartRateDataLeft
	FROM SubAccountUsages sau JOIN InvoiceItems ii ON (sau.ItemID = ii.ItemID)
		WHERE ii.InvoiceID = @InvoiceID
	GROUP BY sau.AccountID
	) asau ON (sa.AccountID = asau.AccountID)
	WHERE sa.Active = 1
	AND (sa.TimeLeft IS NOT NULL OR sa.DataLeft IS NOT NULL OR sa.RateDataLeft IS NOT NULL OR sa.RateTimeLeft IS NOT NULL)
	AND sa.AccountID IN (SELECT DISTINCT AccountID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)

DELETE FROM SubAccountUsages WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)

UPDATE SubAccounts SET BilledThru = CASE WHEN sa.BilledThru > isa.BilledThru THEN isa.BilledThru ELSE sa.BilledThru END,
ExpireDate = CASE WHEN bc.AutoBill = 1 THEN NULL WHEN sa.ExpireDate > isa.BilledThru THEN isa.BilledThru ELSE sa.ExpireDate END,
InvoicedDays = CASE WHEN sa.InvoicedDays > isa.InvoicedDays THEN isa.InvoicedDays ELSE sa.InvoicedDays END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN InvoiceSubAccounts isa ON (sa.AccountID = isa.AccountID)
	WHERE isa.InvoiceID = @InvoiceID

UPDATE sat SET InvoicedDays = CASE WHEN sat.InvoicedDays > it.InvoicedDays THEN it.InvoicedDays ELSE sat.InvoicedDays END, 
CancelItemID = CASE WHEN CancelItemID IS NULL THEN NULL WHEN CancelItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID=@InvoiceID) THEN NULL ELSE CancelItemID END
FROM SubAccountTags sat JOIN InvoiceTags it ON (sat.AccountID = it.AccountID AND sat.MarketTagID = it.MarketTagID)
	WHERE it.InvoiceID = @InvoiceID

SELECT CustomerID, InvoiceTypeID
FROM Invoices 
	WHERE InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.ListIncidentFileCategories (@IncidentTypeID INT) AS
SET NOCOUNT ON
SELECT fc.FileCategoryID, fc.FileCategory, fc.StringID, fc.AccessLabelID
FROM IncidentTypeFileCategories itfc JOIN FileCategories fc ON (itfc.FileCategoryID = fc.FileCategoryID)
	WHERE itfc.IncidentTypeID = @IncidentTypeID
	AND fc.SortOrder >= 0
ORDER BY fc.SortOrder, fc.FileCategory
GO

CREATE PROCEDURE dbo.ListPayPlans AS
SET NOCOUNT ON
SELECT PayPlanID, PayPlan, StringID, GroupID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM PayPlans
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, PayPlan
GO

CREATE PROCEDURE dbo.ListRateIPProtocols AS
SET NOCOUNT ON
SELECT Protocol,Description
FROM RateIPProtocols
ORDER BY SortOrder, Description
GO

CREATE PROCEDURE dbo.ListFlowDirections AS
SET NOCOUNT ON
SELECT FlowDirectionID, FlowDirection
FROM FlowDirections
ORDER BY SortOrder, FlowDirection
GO

CREATE PROCEDURE dbo.ListFlowFilters AS
SET NOCOUNT ON
SELECT FlowFilterID, FlowFilter
FROM FlowFilters
ORDER BY SortOrder, FlowFilter
GO

CREATE PROCEDURE dbo.ListCertTypes AS
SET NOCOUNT ON
SELECT CertTypeID, CertType
FROM CertTypes
ORDER BY SortOrder, CertType
GO

CREATE PROCEDURE dbo.ListCerts (@CertTypeID INT) AS
SET NOCOUNT ON
SELECT CertID, Cert
FROM Certs
	WHERE CertTypeID = @CertTypeID
ORDER BY Cert
GO

CREATE PROCEDURE dbo.ListBulkMessages (@NoticeTechID INT) AS
SET NOCOUNT ON
SELECT BulkMessageID, BulkMessage
FROM BulkMessages
	WHERE NoticeTechID = @NoticeTechID
	AND SortOrder >= 0
ORDER BY SortOrder, BulkMessage
GO

CREATE PROCEDURE dbo.ListIPRanges (@IPGroupID INT, @IPInvAllocationID INT = NULL) AS
SET NOCOUNT ON
IF (@IPInvAllocationID IS NULL)
BEGIN
SELECT IPRangeID, Description, IPRange
FROM IPRanges
	WHERE IPGroupID = @IPGroupID
	AND IPRangeTypeID = 1
ORDER BY StatOrder, PriorityID, IPRange

END ELSE BEGIN

SELECT ir.IPRangeID, ir.Description, ir.IPRange
FROM IPRanges ir JOIN IPInvAllocations iia ON (ir.IPGroupID = iia.IPGroupID)
	WHERE iia.IPInvAllocationID = @IPInvAllocationID
	AND ir.IPRangeTypeID = 1
ORDER BY ir.StatOrder, ir.PriorityID, ir.IPRange
END
GO

CREATE PROCEDURE dbo.ListIPGroups AS
SET NOCOUNT ON
SELECT IPGroupID, IPGroup, CASE WHEN Active = 0 THEN 'hidden' END AS Class
FROM IPGroups
ORDER BY Active DESC, SortOrder, IPGroup
GO

CREATE PROCEDURE dbo.ListIPRangeTypes AS
SET NOCOUNT ON
SELECT IPRangeTypeID, IPRangeType
FROM IPRangeTypes
ORDER BY IPRangeTypeID
GO

CREATE PROCEDURE dbo.ListIPAddressTypes AS
SET NOCOUNT ON
SELECT IPAddressTypeID, IPAddressType
FROM IPAddressTypes
ORDER BY IPAddressTypeID
GO

CREATE PROCEDURE dbo.ListIPAttributes AS
SET NOCOUNT ON
SELECT ia.IPAttributeID, ia.IPAttribute, iat.IPAttributeType
FROM IPAttributes ia JOIN IPAttributeTypes iat ON (ia.IPAttributeTypeID = iat.IPAttributeTypeID)
ORDER BY iat.SortOrder, iat.IPAttributeType, ia.SortOrder, ia.IPAttribute
GO

CREATE PROCEDURE dbo.ListIPAttributeTypes AS
SET NOCOUNT ON
SELECT IPAttributeTypeID,IPAttributeType
FROM IPAttributeTypes
ORDER BY SortOrder,IPAttributeType
GO

CREATE PROCEDURE dbo.ListServiceLevelTypes AS
SET NOCOUNT ON
SELECT ServiceLevelTypeID, ServiceLevelType, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM ServiceLevelTypes
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, ServiceLevelType
GO

CREATE PROCEDURE dbo.ListDashTypes AS
SET NOCOUNT ON
SELECT DashTypeID,DashType,StringID,FeatureID
FROM DashTypes
ORDER BY SortOrder,DashType
GO

CREATE PROCEDURE dbo.ListMonProfileItems (@MonProfileID INT, @MonitorID INT) AS
SET NOCOUNT ON
SELECT mpi.MonProfileItemID, CASE WHEN mpi.MonProfileItem = 'N/A' THEN mpi.OID ELSE mpi.MonProfileItem END AS MonProfileItem, CASE WHEN mpo.MonitorID IS NOT NULL THEN mpo.GaugeID ELSE mpi.GaugeID END AS GaugeID
FROM MonProfileItems mpi LEFT JOIN MonitorProfileOptions mpo ON (mpo.MonitorID = @MonitorID AND mpi.MonProfileItemID = mpo.MonProfileItemID)
	WHERE mpi.MonProfileID = @MonProfileID
ORDER BY mpi.MonProfileItem, mpi.OID
GO

CREATE PROCEDURE dbo.ListMonRadIPSources AS
SET NOCOUNT ON
SELECT MonRadIPSourceID, MonRadIPSource
FROM MonRadIPSources
ORDER BY SortOrder,MonRadIPSource
GO

CREATE PROCEDURE dbo.ListMonProtocols AS
SET NOCOUNT ON
SELECT MonProtocolID, MonProtocol
FROM MonProtocols
ORDER BY SortOrder,MonProtocol
GO

CREATE PROCEDURE dbo.ListMonProfiles AS
SET NOCOUNT ON
SELECT MonProfileID, MonProfile
FROM MonProfiles
ORDER BY SortOrder,MonProfile
GO

CREATE PROCEDURE dbo.ListMonFilters (@MonSourceID INT) AS
SET NOCOUNT ON
SELECT MonFilterID, MonFilter
FROM MonFilters
	WHERE (@MonSourceID IS NULL OR MonSourceID = @MonSourceID)
ORDER BY MonFilter
GO

CREATE PROCEDURE dbo.ListMonGauges AS
SET NOCOUNT ON
SELECT m.MonitorID, g.GaugeID, 'Min ms' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.PingMinGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 1
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Max ms' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.PingMaxGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 1
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Avg ms' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.PingAvgGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 1
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Timeouts' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.PingTimeoutGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 1
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Jitter' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.PingJitterGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 1
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Download Rate' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.FlowDownGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 5
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Upload Rate' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.FlowUpGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 5
UNION ALL
SELECT m.MonitorID, g.GaugeID, 'Down+Up Rate' AS Purpose, g.Gauge
FROM Monitors m JOIN Gauges g ON (m.FlowUpDownGaugeID = g.GaugeID)
	WHERE m.MonProtocolID = 5
UNION ALL
SELECT m.MonitorID, g.GaugeID, mpi.MonProfileItem AS Purpose, g.Gauge
FROM Monitors m JOIN MonProfileItems mpi ON (m.MonProfileID = mpi.MonProfileID)
	LEFT JOIN MonitorProfileOptions mpo ON (m.MonitorID = mpo.MonitorID AND mpi.MonProfileItemID = mpo.MonProfileItemID)
	JOIN Gauges g ON (g.GaugeID = COALESCE(mpo.GaugeID,mpi.GaugeID))
	WHERE m.MonProtocolID IN (2,3,4)
	AND (mpo.MonitorID IS NULL OR mpo.GaugeID IS NOT NULL)
GO

CREATE PROCEDURE dbo.ListMonSources AS
SET NOCOUNT ON
SELECT MonSourceID, MonSource
FROM MonSources
ORDER BY SortOrder, MonSource
GO

CREATE PROCEDURE dbo.ListAccessLabels AS
SET NOCOUNT ON
SELECT AccessLabelID, AccessLabel, CASE WHEN Active=0 THEN 'inactive' WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM AccessLabels
ORDER BY Active DESC, CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder, AccessLabel
GO

CREATE PROCEDURE dbo.ListNoticeFormats AS
SET NOCOUNT ON
SELECT NoticeFormatID, NoticeFormat, StringID
FROM NoticeFormats
ORDER BY SortOrder, NoticeFormat
GO

CREATE PROCEDURE dbo.ListAPIActions AS
SET NOCOUNT ON
SELECT a.APIActionID, a.APIAction, at1.APIActionType, a.FeatureID, CASE WHEN a.Active = 0 THEN 'inactive' END AS Class
FROM APIActions a JOIN APIActionTypes at1 ON (a.APIActionTypeID = at1.APIActionTypeID)
ORDER BY at1.SortOrder, a.Active DESC, a.APIAction
GO

CREATE PROCEDURE dbo.ListAPIProfileActions (@APIProfileID INT) AS
SET NOCOUNT ON
SELECT a.APIActionID, 
CASE WHEN EXISTS (SELECT * FROM APIProfileItems pi2 JOIN APIFields f2 ON (pi2.APIFieldID = f2.APIFieldID) WHERE pi2.APIProfileID=@APIProfileID AND f2.APIActionID = a.APIActionID) THEN '* ' END AS Asterisk,
a.APIAction, at1.APIActionType, a.FeatureID, CASE WHEN a.Active = 0 THEN 'inactive' END AS Class
FROM APIActions a JOIN APIActionTypes at1 ON (a.APIActionTypeID = at1.APIActionTypeID)
	WHERE EXISTS (SELECT * FROM APIFields f WHERE f.APIActionID = a.APIActionID AND f.APIFieldTypeID = 1)
ORDER BY at1.SortOrder, a.Active DESC, a.APIAction
GO

CREATE PROCEDURE dbo.ListAccessTimes AS
SET NOCOUNT ON
SELECT AccessTypeID,AccessType
FROM AccessTypes
ORDER BY AccessTypeID
GO

CREATE PROCEDURE dbo.ListAccessTypes AS
SET NOCOUNT ON
SELECT AccessTypeID,AccessType
FROM AccessTypes
ORDER BY SortOrder,AccessType
GO

CREATE PROCEDURE dbo.ListAccessTypesBitmask AS
SET NOCOUNT ON
SELECT AccessTypeID,AccessType
FROM AccessTypes
	WHERE AccessTypeID IN (1,2,4,8,16,32,64,128,256,512,1024)
ORDER BY SortOrder,AccessTypeID
GO

CREATE PROCEDURE dbo.ListAccountDataTypes (@AllowMBR TINYINT = 1, @AllowSA TINYINT = 1) AS
SET NOCOUNT ON
SELECT AccountDataTypeID, AccountDataType, StringID
FROM AccountDataTypes
	WHERE (AllowMBR = @AllowMBR OR AllowSA = @AllowSA)
ORDER BY CASE WHEN AccountDataTypeID > 10000 THEN 0 ELSE 1 END ASC, AccountDataType
GO

CREATE PROCEDURE dbo.ListAccountDataValues (@AccountDataTypeID INT) AS
SET NOCOUNT ON
SELECT KeyData, ValueData
FROM AccountDataValues
	WHERE AccountDataTypeID = @AccountDataTypeID
ORDER BY KeyData
GO

CREATE PROCEDURE dbo.ListAccountType (@AccountTypeID INT) AS
SET NOCOUNT ON
SELECT AccountType, StringID, RateClassID
FROM AccountTypes 
	WHERE AccountTypeID = @AccountTypeID
GO

CREATE PROCEDURE dbo.ListAccountTypeSections (@SectionLocationID INT, @AccountTypeID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sat.Enabled
FROM SectionObjects so LEFT JOIN SectionAccountTypes sat ON (so.SectionObjectID=sat.SectionObjectID AND sat.AccountTypeID=@AccountTypeID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = @SectionLocationID
ORDER BY sa.SectionArea, so.SortOrder, 2
GO

CREATE PROCEDURE dbo.ListAccountTypes (@ServiceCategoryID INT = NULL) AS
SET NOCOUNT ON
SELECT CASE WHEN at1.SortOrder < 0 THEN 'hidden' WHEN at1.EndDate < getdate() THEN 'inactive' WHEN at1.StartDate > getdate() THEN 'inactive' END AS Class, at1.AccountTypeID, at1.AccountType, at1.StringID, at1.GroupID, at1.Description
FROM AccountTypes at1
	WHERE (@ServiceCategoryID IS NULL OR EXISTS (SELECT * FROM ServiceCatAccountTypes scat WHERE scat.AccountTypeID = at1.AccountTypeID AND scat.ServiceCategoryID = @ServiceCategoryID))
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, AccountType
GO

CREATE PROCEDURE dbo.ListActiveGroups AS
SET NOCOUNT ON
SELECT GroupID, GroupName
FROM Groups
	WHERE GroupID <> 1
	AND SortOrder >= 0
	AND Active = 1
	AND (StartDate IS NULL OR StartDate < getdate())
	AND (EndDate IS NULL OR EndDate > getdate())
ORDER BY SortOrder, GroupName
GO

CREATE PROCEDURE dbo.ListActiveServiceGroups AS
SET NOCOUNT ON
SELECT ServiceGroupID, ServiceGroup
FROM ServiceGroups
	WHERE SortOrder >= 0
ORDER BY SortOrder, ServiceGroup
GO

CREATE PROCEDURE dbo.ListAddressCategories AS
SET NOCOUNT ON
SELECT AddressCategoryID, AddressCategory, StringID
FROM AddressCategories
ORDER BY SortOrder, AddressCategory
GO

CREATE PROCEDURE dbo.ListAddressDataTypes AS
SET NOCOUNT ON
SELECT AddressDataTypeID, AddressDataType
FROM AddressDataTypes
ORDER BY SortOrder, AddressDataType
GO

CREATE PROCEDURE dbo.ListAddressTypeSections (@AddressTypeID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sat.Enabled
FROM SectionObjects so LEFT JOIN SectionAddressTypes sat ON (so.SectionObjectID = sat.SectionObjectID AND sat.AddressTypeID = @AddressTypeID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = 7
ORDER BY sa.SectionArea,so.SortOrder,2
GO

CREATE PROCEDURE dbo.ListAdminAddresses AS
SET NOCOUNT ON
SELECT a.AddressID, adt.AddressType, a.Company, a.FirstName, a.LastName, a.Address1, a.Address2, c.Country, a.City, s.State, a.Zip
FROM Addresses a JOIN AddressTypes adt ON (a.AddressTypeID = adt.AddressTypeID)
	LEFT JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	WHERE CustomerID IS NULL
	AND AccountID IS NULL
ORDER BY a.Company, a.FirstName, a.LastName
GO

CREATE PROCEDURE dbo.ListAlertSources AS
SET NOCOUNT ON
SELECT AlertSourceID, AlertSource, StringID, CASE WHEN Active=0 THEN 'inactive' END AS Class
FROM AlertSources
ORDER BY Active DESC, SortOrder, AlertSource
GO

CREATE PROCEDURE dbo.ListAlertStates AS
SET NOCOUNT ON
SELECT AlertStateID, AlertState, StringID, Class
FROM AlertStates
ORDER BY SortOrder, AlertState
GO

CREATE PROCEDURE dbo.ListAlertTypes AS
SET NOCOUNT ON
SELECT AlertTypeID, AlertType, StringID
FROM AlertTypes
ORDER BY AlertType
GO

CREATE PROCEDURE dbo.ListAuditActions AS
SET NOCOUNT ON
SELECT AuditActionID, AuditAction, StringID 
FROM AuditActions
ORDER BY AuditActionID
GO

CREATE PROCEDURE dbo.ListBillingCycles AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, BillingCycleID, BillingCycle, StringID, GroupID
FROM BillingCycles
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, BillingCycle
GO

CREATE PROCEDURE dbo.ListBillingImports (@BillingImportTypeID INT) AS
SET NOCOUNT ON
SELECT BillingImportID, BillingImport, StringID
FROM BillingImports
	WHERE BillingImportTypeID = @BillingImportTypeID
ORDER BY SortOrder, BillingImport
GO

CREATE PROCEDURE dbo.ListBulkProfiles AS
SET NOCOUNT ON
SELECT BulkProfileID, BulkProfile, StringID
FROM BulkProfiles
	WHERE SortOrder >= 0
ORDER BY SortOrder, BulkProfile
GO

CREATE PROCEDURE dbo.ListCancelReasons (@CancelReasonID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT cr.CancelReasonID, cr.CancelReason, cr.StringID, CASE WHEN cr.SortOrder < 0 THEN 'hidden' END AS Class
FROM CancelReasons cr
	WHERE (cr.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND cr.SortOrder >= 0))
	OR cr.CancelReasonID = @CancelReasonID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND cr.SortOrder >= 0))
	OR (cr.GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND cr.SortOrder >= 0))
ORDER BY CASE WHEN cr.SortOrder >= 0 THEN 1 ELSE 0 END DESC, cr.SortOrder, cr.CancelReason
GO

CREATE PROCEDURE dbo.ListCardBatchTypes (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CardBatchTypeID, CardBatchType
FROM CardBatchTypes
	WHERE (@GroupID IS NULL OR GroupID = @GroupID)
ORDER BY CardBatchType
GO

CREATE PROCEDURE dbo.ListChargeTypes AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, ChargeTypeID, ChargeType, StringID, GroupID
FROM ChargeTypes
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, ChargeType
GO

CREATE PROCEDURE dbo.ListClientAccountTypes (@OperatorGroupID INT, @CustomerID INT, @AccountTypeID INT, @ServiceCategoryID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #lcat (AccountTypeID INT PRIMARY KEY, Allowed TINYINT)

IF (@OperatorGroupID IS NOT NULL AND @CustomerID IS NOT NULL AND @ServiceCategoryID IS NOT NULL)
BEGIN
INSERT INTO #lcat (AccountTypeID,Allowed)
SELECT scata.AccountTypeID, MIN(CASE WHEN lat.Allowed IS NULL AND scata.BulkProfileID IS NULL THEN 1 WHEN lat.Allowed IS NULL AND scata.BulkProfileID IS NOT NULL THEN 0 ELSE lat.Allowed END)
FROM ServiceCatATAccess scata LEFT JOIN (SELECT scata.AccountTypeID, MIN(bi.Allowed) AS Allowed
	FROM ServiceCatATAccess scata JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN BulkItems bi ON (bi.BulkProfileID = scata.BulkProfileID)
		LEFT JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sa.Active = 1)
		LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.Active = 1)
		LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
		LEFT JOIN Addresses ads ON (ads.CustomerID = @CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
		LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
		LEFT JOIN MasterAccountData mad ON (mad.CustomerID = @CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
		LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
		WHERE scata.OperatorGroupID = @OperatorGroupID
		AND scata.ServiceCategoryID = @ServiceCategoryID
		AND (bi.GroupID IS NULL OR bi.GroupID = ma.GroupID)
		AND (bi.RegionID IS NULL OR bi.RegionID = ma.RegionID)
		AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
		AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
		AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
		AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
		AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
		AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
		AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
		AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
		AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
		AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
		AND (bi.City IS NULL OR bi.City = ads.City)
		AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
		AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
		AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
GROUP BY scata.ServiceCategoryID,scata.AccountTypeID) lat ON (scata.AccountTypeID = lat.AccountTypeID)
	WHERE scata.OperatorGroupID = @OperatorGroupID
	AND scata.ServiceCategoryID = @ServiceCategoryID
GROUP BY scata.AccountTypeID
END

SELECT CASE WHEN SortOrder < 0 THEN 'hidden' WHEN at1.EndDate < getdate() THEN 'inactive' WHEN at1.StartDate > getdate() THEN 'inactive' END AS Class, at1.AccountTypeID, at1.AccountType, at1.StringID, at1.Description
FROM AccountTypes at1 LEFT JOIN ServiceCatAccountTypes scat ON (at1.AccountTypeID = scat.AccountTypeID AND scat.ServiceCategoryID = @ServiceCategoryID)
	LEFT JOIN #lcat lcat ON (at1.AccountTypeID = lcat.AccountTypeID)
	WHERE ((at1.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR at1.AccountTypeID = @AccountTypeID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = at1.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR (at1.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalAccountTypes = 1) AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0)))
	AND (@ServiceCategoryID IS NULL OR scat.AccountTypeID IS NOT NULL OR at1.AccountTypeID = @AccountTypeID)
	AND (lcat.Allowed IS NULL OR lcat.Allowed = 1 OR at1.AccountTypeID = @AccountTypeID)
ORDER BY CASE WHEN at1.SortOrder < 0 THEN 0 ELSE 1 END DESC, scat.ServiceLevel, at1.SortOrder ASC, at1.AccountType
GO

CREATE PROCEDURE dbo.ListClientGroups (@GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN SortOrder < 0 THEN 'hidden' WHEN Active = 0 THEN 'inactive' WHEN StartDate >= getdate() OR EndDate <= getdate() THEN 'inactive' END AS Class, GroupID, GroupName
FROM Groups
	WHERE GroupID <> 1
	AND (GroupID = @GroupID OR @hide = 0 OR (@hide = 1 AND SortOrder >= 0))
ORDER BY CASE WHEN SortOrder < 0 THEN 0 WHEN Active = 0 OR StartDate >= getdate() OR EndDate <= getdate() THEN 1 ELSE 2 END DESC, SortOrder ASC,GroupName
GO

CREATE PROCEDURE dbo.ListClientAddressTypes (@AddressTypeID INT, @AllowMBR TINYINT, @AllowSA TINYINT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT AddressTypeID, AddressType, StringID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM AddressTypes
	WHERE ((@hide = 0 OR (@hide = 1 AND SortOrder >= 0))
		AND (@AllowMBR <> 1 OR AllowMBR = 1)
		AND (@AllowSA <> 1 OR AllowSA = 1))
	OR AddressTypeID = @AddressTypeID

ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, AddressType
GO

CREATE PROCEDURE dbo.ListClientBatchProcessors (@MBRGlobal INT, @OperatorGroupID INT, @IsCC TINYINT, @IsEFT TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT bp.BatchProcessorID, bp.BatchProcessor, CASE WHEN e.ExportType IN (1,4) THEN 1 ELSE 0 END AS AllowImport
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE bp.Active IN (1,0)
	AND (@IsCC = 0 OR (@IsCC = 1 AND e.ExportType IN (1,5,10)))
	AND (@IsEFT = 0 OR (@IsEFT = 1 AND e.ExportType IN (4,6)))
	AND (@MBRGlobal = 1 OR bp.GroupID IS NULL OR bp.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID))
ORDER BY bp.SortOrder, bp.BatchProcessor
GO

CREATE PROCEDURE dbo.ListClientBillingCycles (@BillingCycleID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN bc.SortOrder < 0 THEN 'hidden' END AS Class, bc.BillingCycleID, bc.BillingCycle, bc.StringID
FROM BillingCycles bc
	WHERE (bc.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR bc.BillingCycleID = @BillingCycleID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = bc.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR (bc.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalBillingCycles = 1) AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
ORDER BY CASE WHEN bc.SortOrder < 0 THEN 0 ELSE 1 END DESC, bc.SortOrder ASC, bc.BillingCycle
GO

CREATE PROCEDURE dbo.ListClientBillingCyclesNR (@BillingCycleID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN bc.SortOrder < 0 THEN 'hidden' END AS Class, bc.BillingCycleID, bc.BillingCycle, bc.StringID
FROM BillingCycles bc
	WHERE bc.AutoBill = 2 AND ((bc.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR bc.BillingCycleID = @BillingCycleID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = bc.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0))
	OR (bc.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalBillingCycles = 1) AND (@hide = 0 OR @hide = 1 AND bc.SortOrder >= 0)))
ORDER BY CASE WHEN bc.SortOrder < 0 THEN 0 ELSE 1 END DESC, bc.SortOrder ASC, bc.BillingCycle
GO

CREATE PROCEDURE dbo.ListClientCancelReasons (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CancelReasonID, CancelReason, StringID, NULL AS Class
FROM CancelReasons
	WHERE (GroupID = @GroupID OR GroupID IS NULL OR @GroupID IS NULL)
	AND SortOrder >= 0
ORDER BY SortOrder, CancelReason
GO

CREATE PROCEDURE dbo.ListClientCertInacts AS 
SET NOCOUNT ON
SELECT ClientCertInactID, ClientCertInact, SortOrder, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM ClientCertInacts
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder,ClientCertInact
GO

CREATE PROCEDURE dbo.ListClientChargeTypes (@ChargeTypeID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN ct.SortOrder < 0 THEN 'hidden' END AS Class, ct.ChargeTypeID, ct.ChargeType, ct.StringID, ct.Amount, ct.TaxGroupID
FROM ChargeTypes ct
	WHERE (ct.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND ct.SortOrder >= 0))
	OR ct.ChargeTypeID = @ChargeTypeID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND ct.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = ct.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND ct.SortOrder >= 0))
	OR (ct.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalChargeTypes = 1) AND (@hide = 0 OR @hide = 1 AND ct.SortOrder >= 0))
ORDER BY CASE WHEN ct.SortOrder < 0 THEN 0 ELSE 1 END DESC, ct.SortOrder ASC, ct.ChargeType
GO

CREATE PROCEDURE dbo.ListClientDomains (@DomainID INT, @GroupID INT, @CustomerID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT d.DomainID, d.Domain, d.MailDomain, CASE WHEN d.SortOrder < 0 THEN 'hidden' END AS Class
FROM Domains d
	WHERE d.CustomerID = @CustomerID
	OR d.CustomerID IS NULL AND ((d.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND d.SortOrder >= 0))
		OR d.DomainID = @DomainID
		OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND d.SortOrder >= 0))
		OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = d.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND d.SortOrder >= 0))
		OR (d.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalDomains = 1) AND (@hide = 0 OR @hide = 1 AND d.SortOrder >= 0)))
ORDER BY CASE WHEN d.SortOrder >= 0 THEN 1 ELSE 0 END DESC, d.SortOrder, d.Domain
GO

CREATE PROCEDURE dbo.ListClientIncidentTypes (@IncidentTypeID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT it1.IncidentTypeID, it1.IncidentType, CASE WHEN it1.SortOrder < 0 THEN 'hidden' END AS Class
FROM IncidentTypes it1
	WHERE (it1.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND it1.SortOrder >= 0))
	OR it1.IncidentTypeID = @IncidentTypeID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND it1.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = it1.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND it1.SortOrder >= 0))
	OR (it1.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalIncidentTypes = 1) AND (@hide = 0 OR @hide = 1 AND it1.SortOrder >= 0))
ORDER BY CASE WHEN it1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, it1.SortOrder, it1.IncidentType
GO

CREATE PROCEDURE dbo.ListClientMarketTagMBR (@MarketTagID INT, @GroupID INT, @MarketTagAutoTypeID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class, mt.MarketTagID, mt.MarketTag, mt.StringID, mt.GroupID, mc.MarketCategory
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE ((@MarketTagAutoTypeID IS NULL AND mt.MarketTagAutoTypeID IN (1,2,3)) OR mt.MarketTagAutoTypeID = @MarketTagAutoTypeID)
	AND ((mt.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0))
	OR mt.MarketTagID = @MarketTagID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0))
	OR ((mt.GroupID IS NULL OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = mt.ServiceGroupID AND sgi.GroupID = @GroupID)) AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0)))
ORDER BY mt.Active DESC, CASE WHEN mt.SortOrder < 0 THEN 0 ELSE 1 END DESC, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.ListClientMarketTagSA (@MarketTagID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class, mt.MarketTagID, mt.MarketTag, mt.StringID, mt.GroupID, mc.MarketCategory
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
	AND ((mt.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0))
	OR mt.MarketTagID = @MarketTagID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0))
	OR ((mt.GroupID IS NULL OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = mt.ServiceGroupID AND sgi.GroupID = @GroupID)) AND (@hide = 0 OR @hide = 1 AND mt.SortOrder >= 0)))
ORDER BY mt.Active DESC, CASE WHEN mt.SortOrder < 0 THEN 0 ELSE 1 END DESC, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.ListClientPayPeriods (@PayPeriodID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN pp.SortOrder < 0 THEN 'hidden' END AS Class, pp.PayPeriodID, pp.PayPeriod, pp.StringID
FROM PayPeriods pp
	WHERE (pp.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND pp.SortOrder >= 0))
	OR pp.PayPeriodID = @PayPeriodID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND pp.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = pp.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND pp.SortOrder >= 0))
	OR (pp.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalPayPeriods = 1) AND (@hide = 0 OR @hide = 1 AND pp.SortOrder >= 0))
ORDER BY CASE WHEN pp.SortOrder < 0 THEN 0 ELSE 1 END DESC, pp.SortOrder ASC, pp.PayPeriod
GO

CREATE PROCEDURE dbo.ListClientPayPlans (@PayPlanID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT pp.PayPlanID, pp.PayPlan, pp.StringID
FROM PayPlans pp JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
	LEFT JOIN CreditCards cc ON (cc.CustomerID = @CustomerID)
	LEFT JOIN BankTrans bt ON (bt.CustomerID = @CustomerID)
	WHERE pp.PayPlanID = @PayPlanID OR ((pp.GroupID IS NULL OR pp.GroupID = ma.GroupID)
	AND (pp.PaymentTypeID = 1 OR (pp.PaymentTypeID = 8 AND (cc.CardNumber IS NOT NULL OR cc.Token IS NOT NULL) AND cc.ExpirationDate > getdate()) OR (pp.PaymentTypeID = 16 AND bt.ABANumber IS NOT NULL AND bt.AccountNumber IS NOT NULL))
	AND (pp.MarketTagID IS NULL OR pp.MarketTagID IN (SELECT MarketTagID FROM MasterAccountTags mat WHERE mat.CustomerID = ma.CustomerID AND mat.Active = 1)))
ORDER BY pp.SortOrder,pp.PayPlan
GO

CREATE PROCEDURE dbo.ListClientReferredBys (@ReferredByID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT r.ReferredByID, r.ReferredBy, r.StringID, CASE WHEN r.SortOrder < 0 THEN 'hidden' END AS Class
FROM ReferredBys r
	WHERE (r.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR r.ReferredByID = @ReferredByID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR (r.GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
ORDER BY CASE WHEN r.SortOrder >= 0 THEN 1 ELSE 0 END DESC, r.SortOrder, r.ReferredBy
GO

CREATE PROCEDURE dbo.ListClientRegions (@RegionID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN r.SortOrder < 0 OR rg.SortOrder < 0 THEN 'hidden' END AS Class, rg.RegionGroup, rg.StringID AS rgStringID, r.RegionID, r.Region, r.StringID, r.GroupID
FROM Regions r LEFT JOIN RegionGroups rg ON (r.RegionGroupID = rg.RegionGroupID)
	WHERE (r.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR r.RegionID = @RegionID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = r.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR (r.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalRegions = 1) AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
ORDER BY CASE WHEN rg.SortOrder IS NULL THEN -1 WHEN rg.SortOrder < 0 THEN 0 ELSE 1 END DESC, rg.SortOrder ASC, rg.RegionGroup, 
         CASE WHEN r.SortOrder < 0 THEN 0 ELSE 1 END DESC, r.SortOrder ASC,r.Region
GO

CREATE PROCEDURE dbo.ListClientRoleOperators (@RoleID INT, @OperatorID INT, @AssignOperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT o.OperatorID, o.Operator, o.FirstName, o.LastName, CASE WHEN o.Active = 0 THEN 'inactive' END AS Class
FROM Operators o LEFT JOIN OperatorRoles or1 ON (o.OperatorID = or1.OperatorID AND or1.RoleID = @RoleID)
	JOIN OperatorGroups og ON (o.OperatorGroupID = og.OperatorGroupID)
	WHERE (or1.OperatorID IS NOT NULL AND o.Active = 1 AND og.InternalUse = 0 AND og.OperatorGroup <> 'CustomerSignup')
	OR (@RoleID IS NULL AND o.OperatorID = @OperatorID)
	OR o.OperatorID = @AssignOperatorID
ORDER BY o.Operator
GO

CREATE PROCEDURE dbo.ListClientRoles (@RoleID INT, @GroupID INT, @hide TINYINT, @SchedBlockTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT r.RoleID, r.Role, CASE WHEN r.SortOrder < 0 THEN 'hidden' END AS Class
FROM Roles r
	WHERE (r.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR r.RoleID = @RoleID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	OR (r.GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND r.SortOrder >= 0))
	AND ((@SchedBlockTypeID IS NULL AND r.RoleTypeID = 1) OR (@SchedBlockTypeID IS NOT NULL AND r.RoleTypeID IN (2,4,8)))
ORDER BY CASE WHEN r.SortOrder >= 0 THEN 1 ELSE 0 END DESC, r.SortOrder, r.Role
GO

CREATE PROCEDURE dbo.ListClientSalesPersons (@SalesPersonID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN sp.Active = 0 THEN 'inactive' WHEN sp.SortOrder < 0 THEN 'hidden' END AS Class, sp.SalesPersonID, sp.SalesPerson
FROM SalesPersons sp
	WHERE (sp.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND sp.SortOrder >= 0))
	OR sp.SalesPersonID = @SalesPersonID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND sp.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = sp.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND sp.SortOrder >= 0))
	OR (sp.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalSalesPersons = 1) AND (@hide = 0 OR @hide = 1 AND sp.SortOrder >= 0))
ORDER BY CASE WHEN sp.SortOrder < 0 OR sp.Active = 0 THEN 0 ELSE 1 END DESC, sp.SortOrder ASC, SalesPerson
GO

CREATE PROCEDURE dbo.ListClientSendMethods (@SendMethodID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN sm.SortOrder < 0 THEN 'hidden' END AS Class, sm.SendMethodID, sm.SendMethod, sm.StringID
FROM SendMethods sm
	WHERE (sm.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND sm.SortOrder >= 0))
	OR sm.SendMethodID = @SendMethodID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND sm.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = sm.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND sm.SortOrder >= 0))
	OR (sm.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalSendMethods = 1) AND (@hide = 0 OR @hide = 1 AND sm.SortOrder >= 0))
ORDER BY CASE WHEN sm.SortOrder < 0 THEN 0 ELSE 1 END DESC, sm.SortOrder ASC, sm.SendMethod
GO

CREATE PROCEDURE dbo.ListClientServiceCategories (@OperatorGroupID INT, @CustomerID INT, @ServiceCategoryID INT, @ParentAccountID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #lcsc (ServiceCategoryID INT PRIMARY KEY, Allowed TINYINT)

IF (@OperatorGroupID IS NOT NULL AND @CustomerID IS NOT NULL)
BEGIN
INSERT INTO #lcsc (ServiceCategoryID,Allowed)
SELECT sca.ServiceCategoryID, MIN(CASE WHEN lsc.Allowed IS NULL AND sca.BulkProfileID IS NULL THEN 1 WHEN lsc.Allowed IS NULL AND sca.BulkProfileID IS NOT NULL THEN 0 ELSE lsc.Allowed END)
FROM ServiceCatAccess sca LEFT JOIN (SELECT sca.ServiceCategoryID, MIN(bi.Allowed) AS Allowed
	FROM ServiceCatAccess sca JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN BulkItems bi ON (sca.BulkProfileID = bi.BulkProfileID)
		LEFT JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sa.Active = 1)
		LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.Active = 1)
		LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
		LEFT JOIN Addresses ads ON (ads.CustomerID = @CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
		LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
		LEFT JOIN MasterAccountData mad ON (mad.CustomerID = @CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
		LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
		WHERE sca.OperatorGroupID = @OperatorGroupID
		AND (bi.GroupID IS NULL OR bi.GroupID = ma.GroupID)
		AND (bi.RegionID IS NULL OR bi.RegionID = ma.RegionID)
		AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
		AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
		AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
		AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
		AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
		AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
		AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
		AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
		AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
		AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
		AND (bi.City IS NULL OR bi.City = ads.City)
		AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
		AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
		AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
GROUP BY sca.ServiceCategoryID) lsc ON (sca.ServiceCategoryID = lsc.ServiceCategoryID)
	WHERE sca.OperatorGroupID = @OperatorGroupID
GROUP BY sca.ServiceCategoryID
END

SELECT CASE WHEN sc.SortOrder < 0 THEN 'hidden' END AS Class, sc.ServiceCategoryID, sc.ServiceCategory, sc.StringID
FROM ServiceCategories sc LEFT JOIN SubAccounts sa ON (sa.AccountID = @ParentAccountID)
	LEFT JOIN ServiceCatLinks scl ON (sa.ServiceCategoryID = scl.ParentServiceCategoryID AND  sc.ServiceCategoryID = scl.ServiceCategoryID)
	LEFT JOIN #lcsc lcsc ON (sc.ServiceCategoryID = lcsc.ServiceCategoryID)
	WHERE (sa.AccountID IS NULL OR (sa.AccountID IS NOT NULL AND scl.ServiceCategoryID IS NOT NULL))
	AND ((@ParentAccountID IS NULL AND sc.AllowRoot = 1) OR @ParentAccountID IS NOT NULL)
	AND ((sc.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND sc.SortOrder >= 0))
	OR sc.ServiceCategoryID = @ServiceCategoryID
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND sc.SortOrder >= 0))
	OR ((sc.GroupID IS NULL OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = sc.ServiceGroupID AND sgi.GroupID = @GroupID)) AND (@hide = 0 OR @hide = 1 AND sc.SortOrder >= 0)))
	AND (lcsc.Allowed IS NULL OR lcsc.Allowed = 1 OR sc.ServiceCategoryID = @ServiceCategoryID)
ORDER BY CASE WHEN sc.SortOrder < 0 THEN 0 ELSE 1 END DESC, sc.SortOrder ASC, sc.ServiceCategory
GO

CREATE PROCEDURE dbo.ListClientServiceCatEdit (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN sc.SortOrder < 0 THEN 'hidden' END AS Class, sc.ServiceCategoryID, sc.ServiceCategory, sc.StringID
FROM ServiceCategories sc JOIN SubAccounts sa ON (sa.AccountID = @AccountID)
	LEFT JOIN SubAccounts psa ON (sa.ParentAccountID = psa.AccountID)
	LEFT JOIN ServiceCatLinks pscl ON (psa.ServiceCategoryID = pscl.ParentServiceCategoryID AND  sc.ServiceCategoryID = pscl.ServiceCategoryID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE sa.ServiceCategoryID = sc.ServiceCategoryID
	OR ((sc.GroupID IS NULL OR sc.GroupID = ma.GroupID OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = sc.ServiceGroupID AND sgi.GroupID = ma.GroupID))

		AND EXISTS (SELECT * FROM ServiceCatAccountTypes scat WHERE sc.ServiceCategoryID = scat.ServiceCategoryID AND sa.AccountTypeID = scat.AccountTypeID)

		AND NOT EXISTS (SELECT * FROM SubAccounts csa LEFT JOIN ServiceCatLinks cscl ON (csa.ServiceCategoryID = cscl.ServiceCategoryID AND sc.ServiceCategoryID = cscl.ParentServiceCategoryID)
			WHERE csa.ParentAccountID = sa.AccountID
			AND csa.CustomerID = sa.CustomerID
			AND csa.Active IN (1,0)
			AND cscl.ServiceCategoryID IS NULL)

		AND NOT EXISTS (SELECT * FROM AccountChanges ac LEFT JOIN ServiceCatAccountTypes scat ON (sc.ServiceCategoryID = scat.ServiceCategoryID AND ac.AccountTypeID = scat.AccountTypeID)
			WHERE ac.CustomerID = ma.CustomerID
			AND ac.AccountID = sa.AccountID
			AND ac.InactiveDate IS NULL
			AND ac.EffectiveDate > getdate()
			AND ac.AccountTypeID IS NOT NULL
			AND scat.ServiceCategoryID IS NULL)
		AND sc.SortOrder >= 0
		AND ((psa.AccountID IS NULL AND sc.AllowRoot = 1) OR (psa.AccountID IS NOT NULL AND pscl.ServiceCategoryID IS NOT NULL)))
ORDER BY CASE WHEN sc.SortOrder < 0 THEN 0 ELSE 1 END DESC, sc.SortOrder ASC, sc.ServiceCategory
GO

CREATE PROCEDURE dbo.ListClientTaxExemptions AS
SET NOCOUNT ON
SELECT TaxExemptionID, TaxExemption, StringID
FROM TaxExemptions 
	WHERE Active = 1
	AND AllowMBR = 1
ORDER BY TaxExemption
GO

CREATE PROCEDURE dbo.ListConfigPaymentTypes AS
SET NOCOUNT ON
SELECT PaymentTypeID AS NumValue, PaymentType AS ValueName, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM PaymentTypes
	WHERE IsPayType = 1
ORDER BY PaymentTypeID
GO

CREATE PROCEDURE dbo.ListConfigChargeTypes AS
SET NOCOUNT ON
SELECT 1 AS Ord, 0 AS SortOrder, NULL AS NumValue, 'None' AS ValueName, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder >= 0 THEN 2 ELSE 3 END AS Ord, SortOrder, ChargeTypeID AS NumValue, ChargeType AS ValueName, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM ChargeTypes 
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.ListConfigBillAddressTypes AS
SET NOCOUNT ON
SELECT 1 AS Ord, 0 AS SortOrder, NULL AS NumValue, 'Disabled' AS ValueName, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder >= 0 THEN 2 ELSE 3 END AS Ord, SortOrder, AddressTypeID, AddressType, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM AddressTypes
	WHERE BillingPriority > 0
	AND AllowMBR = 1
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.ListConfigOperatorGroups (@ConfigGroupID INT) AS
SET NOCOUNT ON
SELECT OperatorGroupID AS ID, OperatorGroup AS Description, CASE WHEN EXISTS(SELECT * FROM ConfigOperatorGroupData cogd, Configs c WHERE cogd.ConfigID=c.ConfigID AND c.ConfigGroupID=@ConfigGroupID AND cogd.OperatorGroupID=og.OperatorGroupID) THEN '*' ELSE '' END AS NonGlobal
FROM OperatorGroups og 
ORDER BY og.OperatorGroup
GO

CREATE PROCEDURE dbo.ListConfigGroups (@ConfigGroupID INT) AS
SET NOCOUNT ON
SELECT CASE WHEN g.SortOrder < 0 THEN 'hidden' WHEN g.Active = 0 THEN 'inactive' WHEN g.StartDate >= getdate() OR g.EndDate <= getdate() THEN 'inactive' END AS Class, g.GroupID AS ID, g.GroupName AS Description, CASE WHEN EXISTS (SELECT * FROM ConfigGroupData cgd, Configs c WHERE cgd.ConfigID = c.ConfigID AND c.ConfigGroupID = @ConfigGroupID AND cgd.GroupID = g.GroupID) THEN '*' ELSE '' END AS NonGlobal
FROM Groups g
	WHERE g.GroupID <> 1
ORDER BY CASE WHEN g.SortOrder < 0 THEN 0 WHEN g.Active = 0 OR g.StartDate >= getdate() OR g.EndDate <= getdate() THEN 1 ELSE 2 END DESC, g.SortOrder ASC, g.GroupName
GO

CREATE PROCEDURE dbo.ListCountries AS
SET NOCOUNT ON
SELECT CountryID, Country, 9000 + CountryID AS StringID, o.Continent
FROM Countries c JOIN Continents o ON (c.ContinentID = o.ContinentID)
	WHERE c.Hidden = 0
	AND c.Restricted = 0
	AND o.Hidden = 0
ORDER BY o.SortOrder, c.SortOrder, c.Country
GO

CREATE PROCEDURE dbo.ListCustServiceCategories (@OperatorGroupID INT, @CustomerID INT, @ParentAccountID INT) AS
SET NOCOUNT ON
DECLARE @ParentServiceCategoryID INT
CREATE TABLE #lcsc (ServiceCategoryID INT PRIMARY KEY, Allowed TINYINT)

IF (@OperatorGroupID IS NOT NULL AND @CustomerID IS NOT NULL)
BEGIN
INSERT INTO #lcsc (ServiceCategoryID,Allowed)
SELECT sca.ServiceCategoryID, MIN(CASE WHEN lsc.Allowed IS NULL AND sca.BulkProfileID IS NULL THEN 1 WHEN lsc.Allowed IS NULL AND sca.BulkProfileID IS NOT NULL THEN 0 ELSE lsc.Allowed END)
FROM ServiceCatAccess sca LEFT JOIN (SELECT sca.ServiceCategoryID, MIN(bi.Allowed) AS Allowed
	FROM ServiceCatAccess sca JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN BulkItems bi ON (sca.BulkProfileID = bi.BulkProfileID)
		LEFT JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sa.Active = 1)
		LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.Active = 1)
		LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
		LEFT JOIN Addresses ads ON (ads.CustomerID = @CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
		LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
		LEFT JOIN MasterAccountData mad ON (mad.CustomerID = @CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
		LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
		WHERE sca.OperatorGroupID = @OperatorGroupID
		AND (bi.GroupID IS NULL OR bi.GroupID = ma.GroupID)
		AND (bi.RegionID IS NULL OR bi.RegionID = ma.RegionID)
		AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
		AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
		AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
		AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
		AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
		AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
		AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
		AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
		AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
		AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
		AND (bi.City IS NULL OR bi.City = ads.City)
		AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
		AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
		AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
GROUP BY sca.ServiceCategoryID) lsc ON (sca.ServiceCategoryID = lsc.ServiceCategoryID)
	WHERE sca.OperatorGroupID = @OperatorGroupID
GROUP BY sca.ServiceCategoryID
END

IF (@ParentAccountID IS NULL)
BEGIN
SELECT DISTINCT sc.ServiceCategoryID, sc.ServiceCategory, sc.StringID
FROM ServiceCategories sc JOIN ServiceCatAccountTypes scat ON (sc.ServiceCategoryID = scat.ServiceCategoryID)
	JOIN AccountTypes at1 ON (scat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sc.ServiceCategoryID = sa.ServiceCategoryID AND sa.Active = 1 AND sa.ParentAccountID IS NULL)
	LEFT JOIN #lcsc lcsc ON (sc.ServiceCategoryID = lcsc.ServiceCategoryID)
	WHERE scat.CustomerAccess = 1
	AND scat.AllowCustAdd = 1
	AND at1.SortOrder >= 0
	AND ((sa.AccountID IS NOT NULL AND (lcsc.Allowed IS NULL OR lcsc.Allowed = 1)) OR lcsc.Allowed = 1)
	AND (at1.StartDate IS NULL OR at1.StartDate < getdate())
	AND (at1.EndDate IS NULL OR at1.EndDate > getdate())
	AND (scat.CustomerMax IS NULL OR scat.CustomerMax > (SELECT COUNT(*) FROM SubAccounts msa 
		WHERE msa.CustomerID = @CustomerID
		AND msa.ServiceCategoryID = scat.ServiceCategoryID 
		AND msa.AccountTypeID = scat.AccountTypeID
		AND msa.Active = 1
		AND (msa.CancelDate IS NULL OR msa.CancelDate > getdate())))
ORDER BY sc.ServiceCategory
END ELSE BEGIN
SELECT @ParentServiceCategoryID = ServiceCategoryID
FROM SubAccounts
	WHERE CustomerID = @CustomerID
	AND AccountID = @ParentAccountID
	AND Active = 1

SELECT DISTINCT sc.ServiceCategoryID, sc.ServiceCategory, sc.StringID
FROM ServiceCatLinks scl JOIN ServiceCategories sc ON (scl.ServiceCategoryID = sc.ServiceCategoryID)
	JOIN ServiceCatAccountTypes scat ON (sc.ServiceCategoryID = scat.ServiceCategoryID)
	JOIN AccountTypes at1 ON (scat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN #lcsc lcsc ON (sc.ServiceCategoryID = lcsc.ServiceCategoryID)
	WHERE scl.ParentServiceCategoryID = @ParentServiceCategoryID
	AND scat.CustomerAccess = 1
	AND scat.AllowCustAdd = 1
	AND at1.SortOrder >= 0
	AND (lcsc.Allowed IS NULL OR lcsc.Allowed = 1)
	AND (at1.StartDate IS NULL OR at1.StartDate < getdate())
	AND (at1.EndDate IS NULL OR at1.EndDate > getdate())
	AND (scat.CustomerMax IS NULL OR scat.CustomerMax > (SELECT COUNT(*) FROM SubAccounts msa 
		WHERE msa.CustomerID = @CustomerID
		AND msa.ServiceCategoryID = scat.ServiceCategoryID 
		AND msa.AccountTypeID = scat.AccountTypeID
		AND msa.Active = 1
		AND (msa.CancelDate IS NULL OR msa.CancelDate > getdate())))
ORDER BY sc.ServiceCategory
END
GO

CREATE PROCEDURE dbo.ListCustAccountTypes (@ServiceCategoryID INT, @OperatorGroupID INT, @CustomerID INT, @AccountTypeID INT) AS
SET NOCOUNT ON
DECLARE @ServiceLevel INT, @CustServiceLevelTypeID INT, @AllowCustUpgrade TINYINT, @AllowCustDowngrade TINYINT, @AllowRADIUS TINYINT
CREATE TABLE #lcat (AccountTypeID INT PRIMARY KEY, Allowed TINYINT)

IF (@OperatorGroupID IS NOT NULL AND @CustomerID IS NOT NULL AND @ServiceCategoryID IS NOT NULL)
BEGIN
INSERT INTO #lcat (AccountTypeID,Allowed)
SELECT scata.AccountTypeID, MIN(CASE WHEN lat.Allowed IS NULL AND scata.BulkProfileID IS NULL THEN 1 WHEN lat.Allowed IS NULL AND scata.BulkProfileID IS NOT NULL THEN 0 ELSE lat.Allowed END)
FROM ServiceCatATAccess scata LEFT JOIN (SELECT scata.AccountTypeID, MIN(bi.Allowed) AS Allowed
	FROM ServiceCatATAccess scata JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN BulkItems bi ON (bi.BulkProfileID = scata.BulkProfileID)
		LEFT JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sa.Active = 1)
		LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.Active = 1)
		LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
		LEFT JOIN Addresses ads ON (ads.CustomerID = @CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
		LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
		LEFT JOIN MasterAccountData mad ON (mad.CustomerID = @CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
		LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
		WHERE scata.OperatorGroupID = @OperatorGroupID
		AND scata.ServiceCategoryID = @ServiceCategoryID
		AND (bi.GroupID IS NULL OR bi.GroupID = ma.GroupID)
		AND (bi.RegionID IS NULL OR bi.RegionID = ma.RegionID)
		AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
		AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
		AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
		AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
		AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
		AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
		AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
		AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
		AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
		AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
		AND (bi.City IS NULL OR bi.City = ads.City)
		AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
		AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
		AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
GROUP BY scata.ServiceCategoryID,scata.AccountTypeID) lat ON (scata.AccountTypeID = lat.AccountTypeID)
	WHERE scata.OperatorGroupID = @OperatorGroupID
	AND scata.ServiceCategoryID = @ServiceCategoryID
GROUP BY scata.AccountTypeID
END


IF (@AccountTypeID IS NOT NULL)
BEGIN
SELECT @ServiceLevel = scat.ServiceLevel, @CustServiceLevelTypeID = scat.CustServiceLevelTypeID, @AllowCustUpgrade = scat.AllowCustUpgrade, @AllowCustDowngrade = scat.AllowCustDowngrade, @AllowRADIUS = at1.AllowRADIUS
FROM ServiceCatAccountTypes scat JOIN AccountTypes at1 ON (scat.AccountTypeID = at1.AccountTypeID)
	WHERE scat.ServiceCategoryID = @ServiceCategoryID
	AND scat.AccountTypeID = @AccountTypeID
END

SELECT at1.AccountTypeID, COALESCE(at1.Description,at1.AccountType) AS AccountType, at1.StringID AS at1StringID, scat.CustomerDescription,
CASE WHEN scat.ServiceLevel < @ServiceLevel THEN 'downgrade' WHEN scat.ServiceLevel > @ServiceLevel THEN 'upgrade' END AS Class,
CASE WHEN at1.UseServerPassword = 0 AND (at1.AllowRADIUS = 1 OR EXISTS (SELECT * FROM ExternalSystemAccountTypes esat WHERE esat.AccountTypeID = at1.AccountTypeID)) THEN 1 ELSE 0 END AS ShowLogin,
CASE WHEN at1.UseServerPassword = 1 THEN 1 ELSE 0 END AS ShowMAC

FROM ServiceCatAccountTypes scat JOIN AccountTypes at1 ON (scat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN #lcat lcat ON (at1.AccountTypeID = lcat.AccountTypeID)
	WHERE scat.ServiceCategoryID = @ServiceCategoryID
	AND scat.CustomerAccess = 1
	AND (@AccountTypeID IS NULL OR (@CustServiceLevelTypeID IS NULL AND scat.CustServiceLevelTypeID IS NULL) OR (scat.CustServiceLevelTypeID = @CustServiceLevelTypeID))
	AND (@AccountTypeID IS NOT NULL OR scat.AllowCustAdd = 1)
	AND (@AllowRADIUS IS NULL OR at1.AllowRADIUS = @AllowRADIUS)
	AND (scat.AccountTypeID = @AccountTypeID OR (at1.SortOrder >= 0 AND (at1.StartDate IS NULL OR at1.StartDate < getdate()) AND (at1.EndDate IS NULL OR at1.EndDate > getdate())))
	AND (lcat.Allowed IS NULL OR lcat.Allowed = 1 OR scat.AccountTypeID = @AccountTypeID)
	AND (@AccountTypeID IS NULL 
		OR scat.AccountTypeID = @AccountTypeID 
		OR (@ServiceLevel IS NOT NULL AND scat.ServiceLevel >= 0 AND @AllowCustUpgrade = 1 AND scat.ServiceLevel > @ServiceLevel) 
		OR (@ServiceLevel IS NOT NULL AND scat.ServiceLevel >= 0 AND @AllowCustDowngrade = 1 AND scat.ServiceLevel < @ServiceLevel))
	AND (scat.CustomerMax IS NULL OR scat.CustomerMax > (SELECT COUNT(*) FROM SubAccounts msa 
		WHERE msa.CustomerID = @CustomerID
		AND msa.ServiceCategoryID = scat.ServiceCategoryID 
		AND msa.AccountTypeID = scat.AccountTypeID
		AND msa.Active = 1
		AND (msa.CancelDate IS NULL OR msa.CancelDate > getdate())))
ORDER BY scat.ServiceLevel DESC, at1.AccountType
GO

CREATE PROCEDURE dbo.ListCustCancelReasons (@GroupID INT) AS
SET NOCOUNT ON
SELECT cr.CancelReasonID, cr.CancelReason, cr.StringID, NULL AS Class
FROM CancelReasons cr
	WHERE cr.CustomerAccess = 1
	AND cr.SortOrder >= 0
	AND (cr.GroupID IS NULL OR @GroupID IS NULL OR cr.GroupID = @GroupID)
ORDER BY cr.SortOrder, cr.CancelReason
GO

CREATE PROCEDURE dbo.ListCustSendMethods (@CustomerID INT, @SendMethodID INT) AS
SET NOCOUNT ON

SELECT CASE WHEN sm.SortOrder < 0 THEN 'hidden' END AS Class, sm.SendMethodID, sm.SendMethod, sm.StringID
FROM MasterAccounts ma JOIN SendMethods sm ON (sm.GroupID IS NULL OR sm.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND (@SendMethodID IS NULL OR sm.SendMethodID = @SendMethodID)
	AND (ma.SendMethodID = sm.SendMethodID OR sm.CustomerAccess = 1)

ORDER BY CASE WHEN sm.SendMethodID = ma.SendMethodID THEN 1 ELSE 0 END DESC, CASE WHEN sm.SortOrder < 0 THEN 0 ELSE 1 END DESC, sm.SortOrder ASC, sm.SendMethod
GO

CREATE PROCEDURE dbo.ListCustomerIncidentTypes (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT it1.IncidentTypeID, it1.IncidentType, CASE WHEN it1.SortOrder < 0 THEN 'hidden' END AS Class
FROM IncidentTypes it1
	WHERE it1.CustomerAccess = 1
	AND (@GroupID IS NULL OR it1.GroupID = @GroupID
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = it1.ServiceGroupID AND sgi.GroupID = @GroupID))
	OR (it1.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalIncidentTypes = 1)))
ORDER BY CASE WHEN it1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, it1.SortOrder, it1.IncidentType
GO

CREATE PROCEDURE dbo.ListDateFormats AS
SET NOCOUNT ON
SELECT CAST(NumValue AS INTEGER) AS Value, ValueName AS Description 
FROM ConfigValues 
	WHERE ConfigID = 390
GO

CREATE PROCEDURE dbo.ListTimeFormats AS
SET NOCOUNT ON
SELECT CAST(NumValue AS INTEGER) AS Value, ValueName AS Description 
FROM ConfigValues 
	WHERE ConfigID = 393
GO

CREATE PROCEDURE dbo.ListDiscounts AS
SET NOCOUNT ON
SELECT DiscountID, Discount, StringID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM Discounts
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, Discount
GO

CREATE PROCEDURE dbo.ListDomainUsers (@domain varchar(64), @esid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @DomainID INT
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain

IF (@DomainID IS NOT NULL)
BEGIN
SELECT COALESCE(sa.Login,SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)) AS Username
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login IS NOT NULL AND sa.DomainID = @DomainID) OR (sa.Login IS NULL AND sa.Email LIKE '%_@' + @domain))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND esat.ExternalSystemID = @esid
END
GO

CREATE PROCEDURE dbo.ListDomains AS
SET NOCOUNT ON
SELECT DomainID, Domain, MailDomain, GroupID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM Domains
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, Domain
GO

CREATE PROCEDURE dbo.ListEmailTypes AS
SET NOCOUNT ON
SELECT EmailTypeID, EmailType, StringID
FROM EmailTypes
	WHERE SortOrder >= 0
ORDER BY SortOrder, EmailType
GO

CREATE PROCEDURE dbo.ListEventTypes AS
SET NOCOUNT ON
SELECT EventTypeID, EventType, StringID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM EventTypes
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, EventType
GO

CREATE PROCEDURE dbo.ListFileCategories (@CustomerID INT, @AccountID INT, @IncidentID INT, @PaymentID INT, @InvoiceID INT, @SiteID INT, @TowerID INT, @EventID INT) AS
SET NOCOUNT ON
SELECT FileCategoryID, FileCategory, StringID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM FileCategories
	WHERE (AllowMBR = 1 AND @CustomerID IS NOT NULL AND @AccountID IS NULL AND @IncidentID IS NULL AND @PaymentID IS NULL AND @InvoiceID IS NULL)
	OR (AllowSA = 1 AND @AccountID IS NOT NULL)
	OR (AllowIncidents = 1 AND @IncidentID IS NOT NULL)
	OR (AllowPayments = 1 AND @PaymentID IS NOT NULL)
	OR (AllowInvoices = 1 AND @InvoiceID IS NOT NULL)
	OR (AllowSites = 1 AND @SiteID IS NOT NULL)
	OR (AllowTowers = 1 AND @TowerID IS NOT NULL)
	OR (AllowEvents = 1 AND @EventID IS NOT NULL)
	OR (@CustomerID IS NULL AND @AccountID IS NULL AND @IncidentID IS NULL AND @PaymentID IS NULL AND @InvoiceID IS NULL)
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, FileCategory
GO

CREATE PROCEDURE dbo.ListFileMimeTypes (@FileCategoryID INT) AS
SET NOCOUNT ON
SELECT mt.MimeTypeID, mt.MimeType, mt.Description, mt.Extension
FROM FileCategoryMimeTypes fcmt JOIN MimeTypes mt ON (fcmt.MimeTypeID = mt.MimeTypeID)
	WHERE fcmt.FileCategoryID = @FileCategoryID
ORDER BY CASE WHEN mt.SortOrder >= 0 THEN 1 ELSE 0 END DESC, mt.SortOrder, mt.MimeType
GO

CREATE PROCEDURE dbo.ListGLCodes AS
SET NOCOUNT ON
SELECT GLCodeID, GLCode 
FROM GLCodes
ORDER BY GLCode
GO

CREATE PROCEDURE dbo.ListGaugeConversions AS
SET NOCOUNT ON
SELECT GaugeConversionID,GaugeConversion
FROM GaugeConversions
ORDER BY SortOrder,GaugeConversion ASC
GO

CREATE PROCEDURE dbo.ListGaugeWindows AS
SET NOCOUNT ON
SELECT GaugeWindowID,GaugeWindow
FROM GaugeWindows
ORDER BY Secs ASC
GO

CREATE PROCEDURE dbo.ListGauges (@GaugeSourceID INT) AS
SET NOCOUNT ON
SELECT g.GaugeID, g.Gauge, g.StringID, gs.GaugeSource, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM Gauges g JOIN GaugeSources gs ON (g.GaugeSourceID = gs.GaugeSourceID)
	WHERE (@GaugeSourceID IS NULL OR g.GaugeSourceID = @GaugeSourceID)
ORDER BY g.Active DESC, gs.GaugeSource, g.SortOrder, g.Gauge
GO

CREATE PROCEDURE dbo.ListGaugeAlerts (@GaugeID INT) AS
SET NOCOUNT ON
SELECT ga.GaugeAlertID, g.Gauge, g.StringID AS gStringID, ga.GaugeAlert, ga.StringID AS gaStringID
FROM GaugeAlerts ga JOIN Gauges g ON (ga.GaugeID = g.GaugeID)
	WHERE ga.Active = 1
	AND g.Active = 1
	AND (@GaugeID IS NULL OR g.GaugeID = @GaugeID)
ORDER BY g.SortOrder, g.Gauge, ga.GaugeAlert
GO

CREATE PROCEDURE dbo.ListGeoLayerFields (@GeoLayerID INT) AS
SET NOCOUNT ON
SELECT 0 AS Value, DescGeoShape AS Description FROM GeoLayers WHERE GeoLayerID = @GeoLayerID AND DescGeoShape IS NOT NULL
UNION ALL
SELECT 1 AS Value, DescAux1 AS Description FROM GeoLayers WHERE GeoLayerID = @GeoLayerID AND DescAux1 IS NOT NULL
UNION ALL
SELECT 2 AS Value, DescAux2 AS Description FROM GeoLayers WHERE GeoLayerID = @GeoLayerID AND DescAux2 IS NOT NULL
UNION ALL
SELECT 3 AS Value, DescAux3 AS Description FROM GeoLayers WHERE GeoLayerID = @GeoLayerID AND DescAux3 IS NOT NULL
UNION ALL
SELECT 4 AS Value, DescAux4 AS Description FROM GeoLayers WHERE GeoLayerID = @GeoLayerID AND DescAux4 IS NOT NULL
ORDER BY 2
GO

CREATE PROCEDURE dbo.ListGeoLayers AS
SET NOCOUNT ON
SELECT GeoLayerID, GeoLayer, CASE WHEN Status <> 1 THEN 'bad' END AS Class
FROM GeoLayers
ORDER BY SortOrder,GeoLayer
GO

CREATE PROCEDURE dbo.ListGeoSubLayers (@GeoLayerID INT) AS
SET NOCOUNT ON
SELECT GeoSubLayerID, GeoSubLayer
FROM GeoSubLayers
	WHERE GeoLayerID = @GeoLayerID
ORDER BY GeoSubLayer
GO

CREATE PROCEDURE dbo.ListGlobalSections (@SectionLocationID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sg.Enabled
FROM SectionObjects so LEFT JOIN SectionGlobals sg ON (so.SectionObjectID = sg.SectionObjectID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = @SectionLocationID
ORDER BY sa.SectionArea, so.SortOrder, 2
GO

CREATE PROCEDURE dbo.ListGroupSections (@SectionLocationID INT, @GroupID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sg.Enabled
FROM SectionObjects so LEFT JOIN SectionGroups sg ON (so.SectionObjectID = sg.SectionObjectID AND sg.GroupID = @GroupID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = @SectionLocationID
ORDER BY sa.SectionArea, so.SortOrder, 2
GO

CREATE PROCEDURE dbo.ListGroups AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' WHEN Active = 0 THEN 'inactive' WHEN StartDate >= getdate() OR EndDate <= getdate() THEN 'inactive' END AS Class, GroupID, GroupName
FROM Groups
	WHERE GroupID <> 1
ORDER BY CASE WHEN SortOrder < 0 THEN 0 WHEN Active = 0 OR StartDate >= getdate() OR EndDate <= getdate() THEN 1 ELSE 2 END DESC, SortOrder ASC,GroupName
GO

CREATE PROCEDURE dbo.ListIMTypes (@IMTypeID INT) AS
SET NOCOUNT ON
SELECT IMTypeID, IMType, StringID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM IMTypes
	WHERE (SortOrder >= 0 OR IMTypeID = @IMTypeID)
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, IMType
GO

CREATE PROCEDURE dbo.ListIncidentDataTypes (@IncidentTypeID INT) AS
SET NOCOUNT ON
IF (@IncidentTypeID IS NOT NULL)
BEGIN
SELECT IncidentDataTypeID,IncidentDataType,RegExp,CASE WHEN DataTypeID = 3 THEN 1 ELSE DataTypeID END AS DataTypeID
FROM IncidentDataTypes 
	WHERE Searchable = 1
	AND IncidentTypeID = @IncidentTypeID
ORDER BY SortOrder,IncidentDataType
END ELSE BEGIN
SELECT it.IncidentTypeID, it.IncidentType, idt.IncidentDataTypeID, idt.IncidentDataType, idt.RegExp, idt.DataTypeID, CASE WHEN it.SortOrder < 0 THEN 'hidden' END AS Class
FROM IncidentDataTypes idt JOIN IncidentTypes it ON (idt.IncidentTypeID = it.IncidentTypeID)
ORDER BY CASE WHEN it.SortOrder >= 0 THEN 1 ELSE 0 END DESC, it.SortOrder, it.IncidentType, idt.SortOrder, idt.IncidentDataType
END
GO

CREATE PROCEDURE dbo.ListIncidentDataValues (@IncidentDataTypeID INT) AS
SET NOCOUNT ON
SELECT NumValue, ValueName 
FROM IncidentValues 
	WHERE IncidentDataTypeID = @IncidentDataTypeID
ORDER BY ValueName
GO

CREATE PROCEDURE dbo.ListIncidentStateGroups AS
SET NOCOUNT ON
SELECT IncidentStateGroupID, IncidentStateGroup
FROM IncidentStateGroups 
ORDER BY IncidentStateGroup
GO

CREATE PROCEDURE dbo.ListIncidentStates (@IncidentTypeID INT, @StatOpen INT) AS
SET NOCOUNT ON
IF (@IncidentTypeID IS NOT NULL)
BEGIN
SELECT is1.IncidentStateID, is1.IncidentState, CASE WHEN is1.SortOrder < 0 THEN 'hidden' 
WHEN Style IS NOT NULL THEN Style
WHEN StatOpen = 1 AND StatEscalate = 1 THEN 'escalated' 
WHEN StatOpen = 1 THEN 'open' 
WHEN StatArchive = 1 THEN 'archived' 
WHEN StatBlock = 1 THEN 'blocking'
WHEN StatOpen = 0 THEN 'closed' END AS Class, isg.IncidentStateGroup
FROM IncidentTypes it JOIN IncidentStates is1 ON (it.IncidentStateGroupID = is1.IncidentStateGroupID)
	JOIN IncidentStateGroups isg ON (is1.IncidentStateGroupID = isg.IncidentStateGroupID)
	WHERE it.IncidentTypeID = @IncidentTypeID
	AND (@StatOpen IS NULL OR @StatOpen = is1.StatOpen)
ORDER BY CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.SortOrder, is1.Description
END ELSE BEGIN
SELECT is1.IncidentStateID, is1.IncidentState, CASE WHEN is1.SortOrder < 0 THEN 'hidden' 
WHEN Style IS NOT NULL THEN Style
WHEN StatOpen = 1 AND StatEscalate = 1 THEN 'escalated' 
WHEN StatOpen = 1 THEN 'open' 
WHEN StatArchive = 1 THEN 'archived' 
WHEN StatBlock = 1 THEN 'blocking'
WHEN StatOpen = 0 THEN 'closed' END AS Class, isg.IncidentStateGroup
FROM IncidentStates is1 JOIN IncidentStateGroups isg ON (is1.IncidentStateGroupID = isg.IncidentStateGroupID)
	WHERE (@StatOpen IS NULL OR @StatOpen = is1.StatOpen)
ORDER BY CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.SortOrder, is1.Description
END
GO

CREATE PROCEDURE dbo.ListIncidentTypes AS
SET NOCOUNT ON
SELECT IncidentTypeID, IncidentType, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM IncidentTypes
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, IncidentType
GO

CREATE PROCEDURE dbo.ListInvCarts (@OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @InvCartID INT
SELECT @InvCartID = InvCartID FROM Operators WHERE OperatorID = @OperatorID

SELECT ic.InvCartID, ic.CreateDate, CASE WHEN ic.InvCartID = @InvCartID THEN '* ' ELSE '' END + ic.InvCart AS InvCart
FROM InvCarts ic
	WHERE ic.OperatorID = @OperatorID
ORDER BY CASE WHEN ic.InvCartID = @InvCartID THEN 1 ELSE 0 END DESC, ic.CreateDate DESC, ic.InvCart
GO

CREATE PROCEDURE dbo.ListInvLevelTypes AS
SET NOCOUNT ON
SELECT InvLevelTypeID, InvLevelType
FROM InvLevelTypes
ORDER BY InvLevelTypeID
GO

CREATE PROCEDURE dbo.ListInvAttrMaps AS
SET NOCOUNT ON
SELECT InvAttrMapID, InvAttrMap
FROM InvAttrMaps
ORDER BY SortOrder, InvAttrMap
GO

CREATE PROCEDURE dbo.ListInvAttributes AS
SET NOCOUNT ON
SELECT ia.InvAttributeID, ia.InvAttribute, ilt.InvLevelType
FROM InvAttributes ia JOIN InvLevelTypes ilt ON (ia.InvLevelTypeID = ilt.InvLevelTypeID)
ORDER BY ilt.InvLevelType, ia.InvAttribute
GO

CREATE PROCEDURE dbo.ListInvCategories AS
SET NOCOUNT ON
SELECT InvCategoryID, InvCategory, StringID
FROM InvCategories
ORDER BY SortOrder, InvCategory
GO

CREATE PROCEDURE dbo.ListInvItemAttributes (@InvItemID INT) AS
SET NOCOUNT ON
SELECT DISTINCT ia.InvAttributeID, ia.InvAttribute, iid.InvValueID, iid.Data, ila.Required, COALESCE(iam.RegExp,ila.RegExp) AS RegExp, (SELECT COUNT(*) FROM InvValues WHERE InvAttributeID=ia.InvAttributeID) AS ValueCount, ia.ServiceAccess, ila.SortOrder
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvLevelAttributes ila ON ((ila.InvCategoryID IS NULL OR ip.InvCategoryID = ila.InvCategoryID) 
	AND (ila.InvProductID IS NULL OR ip.InvProductID = ila.InvProductID)
	AND (ila.InvSubCategoryID IS NULL OR ip.InvSubCategoryID = ila.InvSubCategoryID)
	AND (ila.InvSourceID IS NULL OR ip.InvSourceID = ila.InvSourceID))
	JOIN InvAttributes ia ON (ila.InvAttributeID = ia.InvAttributeID)
	LEFT JOIN InvItemData iid ON (ii.InvItemID = iid.InvItemID AND ia.InvAttributeID = iid.InvAttributeID)
	LEFT JOIN InvAttrMaps iam ON (ia.InvAttrMapID = iam.InvAttrMapID)
	WHERE ii.InvItemID = @InvItemID
	AND ia.InvLevelTypeID = 2
ORDER BY ila.SortOrder, ia.InvAttribute
GO

CREATE PROCEDURE dbo.ListInvProductAttributes (@InvProductID INT, @InvLevelTypeID INT, @bulk TINYINT) AS
SET NOCOUNT ON
SELECT DISTINCT ia.InvAttributeID, ia.InvAttribute, ila.Required, COALESCE(iam.RegExp,ila.RegExp) AS RegExp, (SELECT COUNT(*) FROM InvValues WHERE InvAttributeID=ia.InvAttributeID) AS ValueCount, ia.ServiceAccess, ila.DefaultData, ila.DefaultInvValueID
FROM InvProducts ip JOIN InvLevelAttributes ila ON ((ila.InvCategoryID IS NULL OR ip.InvCategoryID = ila.InvCategoryID) 
	AND (ila.InvProductID IS NULL OR ip.InvProductID = ila.InvProductID)
	AND (ila.InvSubCategoryID IS NULL OR ip.InvSubCategoryID = ila.InvSubCategoryID)
	AND (ila.InvSourceID IS NULL OR ip.InvSourceID = ila.InvSourceID))
	JOIN InvAttributes ia ON (ila.InvAttributeID = ia.InvAttributeID)
	LEFT JOIN InvAttrMaps iam ON (ia.InvAttrMapID = iam.InvAttrMapID)
	WHERE ip.InvProductID = @InvProductID
	AND ia.InvLevelTypeID = @InvLevelTypeID
	AND ((@bulk = 1 AND ila.AllowBulk = 1) OR @bulk IS NULL OR @bulk <> 1)
GO

CREATE PROCEDURE dbo.ListInvProductWarehouses (@InvProductID INT) AS
SET NOCOUNT ON
SELECT iw.InvWarehouseID, iw.InvWarehouse, iwp.Location, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM InvWarehouseProducts iwp JOIN InvWarehouses iw ON (iwp.InvWarehouseID = iw.InvWarehouseID)
	WHERE iwp.InvProductID = @InvProductID
ORDER BY iw.Active DESC, iw.SortOrder, iw.InvWarehouse, iwp.Location
GO

CREATE PROCEDURE dbo.ListInvProducts (@InvCategoryID INT, @InvSubCategoryID INT, @Assignable TINYINT) AS
SET NOCOUNT ON
SELECT ip.InvProductID, ic.InvCategory, isc.InvSubCategory, ip.Title, ip.GroupID, ip.Cost, CASE WHEN ip.Active = 0 THEN 'hidden' END AS Class
FROM InvProducts ip JOIN InvCategories ic ON (ip.InvCategoryID = ic.InvCategoryID)
	JOIN InvSources is1 ON (ip.InvSourceID = is1.InvSourceID)
	JOIN InvSourceTypes ist ON (is1.InvSourceTypeID = ist.InvSourceTypeID)
	LEFT JOIN InvSubCategories isc ON (ip.InvSubCategoryID = isc.InvSubCategoryID)
	WHERE (@InvCategoryID IS NULL OR ip.InvCategoryID = @InvCategoryID)
	AND (@InvSubCategoryID IS NULL OR ip.InvSubCategoryID = @InvSubCategoryID)
	AND (@Assignable IS NULL OR ist.Assignable = @Assignable)
ORDER BY ic.SortOrder, ic.InvCategory, isc.SortOrder, isc.InvSubCategory, ip.SortOrder, ip.Title
GO

CREATE PROCEDURE dbo.ListInvPurchaseStates (@InvSourceID INT) AS
SET NOCOUNT ON
SELECT is1.InvStateID, is1.InvState, is1.StringID, CASE WHEN SortOrder < 0 THEN 'hidden' ELSE ist.Class END AS Class
FROM InvSources src JOIN InvStates is1 ON (src.InvStateGroupID = is1.InvStateGroupID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	WHERE src.InvSourceID = @InvSourceID
	AND is1.InvStateTypeID IN (2,4)
ORDER BY CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.InvStateTypeID ASC, is1.SortOrder, is1.InvState
GO

CREATE PROCEDURE dbo.ListInvReceiveStates (@InvSourceID INT) AS
SET NOCOUNT ON
SELECT is1.InvStateID, is1.InvState, is1.StringID, CASE WHEN SortOrder < 0 THEN 'hidden' ELSE ist.Class END AS Class
FROM InvSources src JOIN InvStates is1 ON (src.InvStateGroupID = is1.InvStateGroupID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	WHERE src.InvSourceID = @InvSourceID
	AND is1.InvStateTypeID IN (1,4)
ORDER BY CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.InvStateTypeID ASC, is1.SortOrder, is1.InvState
GO

CREATE PROCEDURE dbo.ListInvSources AS
SET NOCOUNT ON
SELECT is1.InvSourceID, is1.InvSource, ist.InvSourceType
FROM InvSources is1 JOIN InvSourceTypes ist ON (is1.InvSourceTypeID = ist.InvSourceTypeID)
ORDER BY ist.InvSourceType, is1.InvSource
GO

CREATE PROCEDURE dbo.ListInvStateTypes AS
SET NOCOUNT ON
SELECT InvStateTypeID,InvStateType,StringID
FROM InvStateTypes
ORDER BY InvStateTypeID
GO

CREATE PROCEDURE dbo.ListAllInvStates (@Available TINYINT, @Reserved TINYINT, @Allocated TINYINT, @Unavailable TINYINT) AS
SET NOCOUNT ON
SELECT is1.InvStateGroupID, is1.InvStateID, is1.InvState, is1.StringID, ist.Class
FROM InvStates is1 JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	WHERE (ist.InvStateTypeID = 1 AND (@Available IS NULL OR @Available = 1))
	OR (ist.InvStateTypeID = 2 AND (@Reserved IS NULL OR @Reserved = 1))
	OR (ist.InvStateTypeID = 3 AND (@Allocated IS NULL OR @Allocated = 1))
	OR (ist.InvStateTypeID = 4 AND (@Unavailable IS NULL OR @Unavailable = 1))
ORDER BY CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.InvStateTypeID ASC, is1.SortOrder, is1.InvState
GO

CREATE PROCEDURE dbo.ListInvStates (@InvStateID INT, @InvProductID INT, @InvSourceID INT, @InvStateTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @InvStateGroupID INT

IF (@InvStateGroupID IS NULL AND @InvProductID IS NOT NULL)
BEGIN
SELECT @InvStateGroupID = is1.InvStateGroupID
FROM InvProducts ip JOIN InvSources is1 ON (ip.InvSourceID = is1.InvSourceID)
	WHERE ip.InvProductID = @InvProductID
END

IF (@InvStateGroupID IS NULL AND @InvSourceID IS NOT NULL)
BEGIN
SELECT @InvStateGroupID = InvStateGroupID FROM InvSources WHERE InvSourceID = @InvSourceID
END

IF (@InvStateGroupID IS NULL)
BEGIN
SELECT @InvStateGroupID = CASE WHEN COUNT(*) = 1 THEN MIN(InvStateGroupID) END FROM InvStateGroups
END

SELECT is1.InvStateID, is1.InvState, is1.StringID, CASE WHEN @InvStateGroupID IS NULL AND @InvStateID IS NULL THEN isg.InvStateGroup END AS InvStateGroup, ist.Class
FROM InvStateGroups isg JOIN InvStates is1 ON (isg.InvStateGroupID = is1.InvStateGroupID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	WHERE (@InvStateGroupID IS NULL OR isg.InvStateGroupID = @InvStateGroupID)
	AND (@InvStateTypeID IS NULL OR is1.InvStateTypeID = @InvStateTypeID OR is1.InvStateID = @InvStateID)
ORDER BY isg.InvStateGroup, CASE WHEN is1.SortOrder >= 0 THEN 1 ELSE 0 END DESC, is1.InvStateTypeID ASC, is1.SortOrder, is1.InvState
GO

CREATE PROCEDURE dbo.ListInvSubCategories (@InvCategoryID INT) AS
SET NOCOUNT ON
SELECT InvSubCategoryID, InvSubCategory, StringID
FROM InvSubCategories
	WHERE InvCategoryID = @InvCategoryID
ORDER BY SortOrder, InvSubCategory
GO

CREATE PROCEDURE dbo.ListInvValues (@InvAttributeID INT) AS
SET NOCOUNT ON
SELECT InvValueID, Data, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM InvValues
	WHERE InvAttributeID = @InvAttributeID
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, Data
GO

CREATE PROCEDURE dbo.ListInvWarehouseGroups AS
SET NOCOUNT ON
SELECT InvWarehouseGroupID, InvWarehouseGroup, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM InvWarehouseGroups
ORDER BY Active DESC, SortOrder, InvWarehouseGroup
GO

CREATE PROCEDURE dbo.ListInvWarehouses AS
SET NOCOUNT ON
SELECT InvWarehouseID, InvWarehouse, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM InvWarehouses
ORDER BY Active DESC, SortOrder, InvWarehouse
GO

CREATE PROCEDURE dbo.ListInvoiceTypes AS
SET NOCOUNT ON
SELECT InvoiceTypeID, InvoiceType, StringID
FROM InvoiceTypes
ORDER BY InvoiceTypeID
GO

CREATE PROCEDURE dbo.ListLanguages AS
SET NOCOUNT ON
SELECT LanguageID, Description, CASE WHEN Active=0 THEN 'inactive' END AS Class
FROM Languages
ORDER BY Active DESC, SortOrder, Description
GO

CREATE PROCEDURE dbo.ListMailUsers (@esid integer) AS
SELECT Login, Login AS Shell, sa.Email, d.MailDomain, Password, sad.Data as HomeDir 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID = @esid
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

UNION ALL

SELECT Login, Login AS Shell, a.Alias AS Email, d.MailDomain, Password, sad.Data AS HomeDir
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID = @esid
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()
GO

CREATE PROCEDURE dbo.ListMarketTagMBR AS
SET NOCOUNT ON
SELECT CASE WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class, mt.MarketTagID, mt.MarketTag, mt.StringID, mt.GroupID, mc.MarketCategory
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (1,2,3)
ORDER BY mt.Active DESC, CASE WHEN mt.SortOrder < 0 THEN 0 ELSE 1 END DESC, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.ListMarketTagSA AS
SET NOCOUNT ON
SELECT CASE WHEN mt.Active=0 THEN 'inactive' WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class, mt.MarketTagID, mt.MarketTag, mt.StringID, mt.GroupID, mc.MarketCategory
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
ORDER BY mt.Active DESC, CASE WHEN mt.SortOrder < 0 THEN 0 ELSE 1 END DESC, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.ListMarketTags AS
SET NOCOUNT ON
SELECT mt.MarketTagID, mt.MarketTag, mt.StringID, mc.MarketCategory, mc.StringID AS mcStringID, CASE WHEN mt.Active=0 THEN 'inactive' WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID=mc.MarketCategoryID)
ORDER BY mt.Active DESC, CASE WHEN mt.SortOrder < 0 THEN 0 ELSE 1 END DESC, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.ListMeasureUnits AS
SET NOCOUNT ON
SELECT CAST(NumValue AS INTEGER) AS Value, ValueName AS Description 
FROM ConfigValues 
	WHERE ConfigID = 392
GO

CREATE PROCEDURE dbo.ListMetaTableAudit AS
SET NOCOUNT ON
SELECT mt.MetaTableID, MIN(mt.TableName) AS TableName, MIN(mt.Description) AS Description
FROM MetaTables mt JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mc.IsKey = 1 AND mc.Quoted = 0)
	WHERE mt.AllowAudit = 1
GROUP BY mt.MetaTableID
HAVING COUNT(*) = 1
GO

CREATE PROCEDURE dbo.ListMetaTables AS
SET NOCOUNT ON
SELECT MetaTableID, TableName, Description
FROM MetaTables
ORDER BY TableName
GO

CREATE PROCEDURE dbo.ListMetaColumns (@MetaTableID INT) AS
SET NOCOUNT ON
SELECT MetaColumnID, ColumnName, Description, StringID
FROM MetaColumns
	WHERE MetaTableID = @MetaTableID
	AND ColumnName NOT IN ('IEAID','SortOrder')
ORDER BY ColumnName
GO

CREATE PROCEDURE dbo.ListMimeTypes AS
SET NOCOUNT ON
SELECT MimeTypeID, MimeType, Description
FROM MimeTypes
ORDER BY SortOrder,MimeType
GO

CREATE PROCEDURE dbo.ListNoticePurposes AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, NoticePurposeID, NoticePurpose, StringID
FROM NoticePurposes
	WHERE SortOrder >= 0
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, NoticePurpose
GO

CREATE PROCEDURE dbo.ListCustNoticePurposes AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, NoticePurposeID, COALESCE(CustomerDescription,NoticePurpose) AS NoticePurpose, StringID
FROM NoticePurposes
	WHERE SortOrder >= 0
	AND CustomerAccess = 1
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, CustomerDescription, NoticePurpose
GO

CREATE PROCEDURE dbo.ListNoticeTechs AS
SET NOCOUNT ON
SELECT NoticeTechID, NoticeTech 
FROM NoticeTechs 
ORDER BY SortOrder, NoticeTech
GO

CREATE PROCEDURE dbo.ListNoticeTypes AS
SET NOCOUNT ON
SELECT nt.NoticeTypeID, nt.NoticeType, np.NoticePurpose
FROM NoticeTypes nt JOIN NoticePurposes np ON (nt.NoticePurposeID=np.NoticePurposeID)
	WHERE nt.InternalID IS NULL
ORDER BY np.NoticePurpose, nt.NoticeType
GO

CREATE PROCEDURE dbo.ListObjectGroups AS
SET NOCOUNT ON
SELECT ObjectGroupID,ObjectGroup
FROM ObjectGroups
	WHERE ObjectGroupID >= 0
ORDER BY ObjectGroup
GO

CREATE PROCEDURE dbo.ListOperatorWebLinkTypes(@AllowOperator TINYINT, @AllowOperatorPing TINYINT) AS
SET NOCOUNT ON
SELECT WebLinkTypeID,WebLinkType,GroupID,AccessLabelID
FROM WebLinkTypes
	WHERE (@AllowOperator = 1 AND AllowOperator = 1)
	OR (@AllowOperatorPing = 1 AND AllowOperatorPing = 1)
ORDER BY WebLinkType
GO

CREATE PROCEDURE dbo.ListOperatorGroupSections (@SectionLocationID INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sog.Enabled
FROM SectionObjects so LEFT JOIN SectionOperatorGroups sog ON (so.SectionObjectID = sog.SectionObjectID AND sog.OperatorGroupID = @OperatorGroupID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = @SectionLocationID
ORDER BY sa.SectionArea, so.SortOrder, 2
GO

CREATE PROCEDURE dbo.ListAllOperatorGroups AS
SET NOCOUNT ON
SELECT OperatorGroupID, OperatorGroup, Description
FROM OperatorGroups
ORDER BY OperatorGroup
GO

CREATE PROCEDURE dbo.ListOperatorGroups AS
SET NOCOUNT ON
SELECT OperatorGroupID, OperatorGroup, Description
FROM OperatorGroups
	WHERE InternalUse = 0
ORDER BY OperatorGroup
GO

CREATE PROCEDURE dbo.ListOperatorIncidentTypes (@MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT IncidentTypeID, IncidentType, CASE WHEN SchedBlockTypeID IS NULL THEN 0 ELSE 1 END AS IsScheduled, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, StringID
FROM IncidentTypes
	WHERE SortOrder >= 0
	AND (GroupID IS NULL OR @MBRGlobal = 1 OR GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID = @OperatorGroupID))
ORDER BY SortOrder, IncidentType
GO

CREATE PROCEDURE dbo.ListOperatorSections (@SectionLocationID INT, @OperatorID INT) AS
SET NOCOUNT ON
SELECT so.SectionObjectID, COALESCE(so.Description,so.SectionObject) AS Description, so.StringID, sa.SectionArea, sa.StringID AS saStringID, sop.Enabled
FROM SectionObjects so LEFT JOIN SectionOperators sop ON (so.SectionObjectID = sop.SectionObjectID AND sop.OperatorID = @OperatorID)
	JOIN SectionAreas sa ON (so.SectionAreaID = sa.SectionAreaID)
	WHERE so.SectionLocationID = @SectionLocationID
ORDER BY sa.SectionArea, so.SortOrder, 2
GO

CREATE PROCEDURE dbo.ListOperatorOrganizations (@MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
IF (@MBRGlobal = 1)
BEGIN
SELECT OrganizationID, Organization
FROM Organizations
ORDER BY Organization
END ELSE BEGIN
SELECT DISTINCT o.OrganizationID, o.Organization
	FROM Organizations o JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN OperatorGroupAccess oga ON (g.GroupID = oga.GroupID)
	WHERE oga.ObjectGroupID = 101
	AND oga.OperatorGroupID = @OperatorGroupID
ORDER BY o.Organization
END
GO

CREATE PROCEDURE dbo.ListOrgGroups (@OrganizationID INT) AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' WHEN Active = 0 THEN 'inactive' WHEN StartDate >= getdate() OR EndDate <= getdate() THEN 'inactive' END AS Class, GroupID, GroupName
FROM Groups
	WHERE GroupID <> 1
	AND (@OrganizationID IS NULL OR OrganizationID = @OrganizationID)
ORDER BY CASE WHEN SortOrder < 0 THEN 0 WHEN Active = 0 OR StartDate >= getdate() OR EndDate <= getdate() THEN 1 ELSE 2 END DESC, SortOrder ASC,GroupName
GO

CREATE PROCEDURE dbo.ListOrganizations AS
SET NOCOUNT ON
SELECT OrganizationID, Organization
FROM Organizations
ORDER BY Organization
GO

CREATE PROCEDURE dbo.ListPayMethods AS
SET NOCOUNT ON
SELECT PaymentTypeID,PaymentType,StringID 
FROM PaymentTypes 
	WHERE IsPayMethod = 1
ORDER BY SortOrder,PaymentType
GO

CREATE PROCEDURE dbo.ListPayPeriods AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, PayPeriodID, PayPeriod, StringID, GroupID
FROM PayPeriods
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, PayPeriod
GO

CREATE PROCEDURE dbo.ListCustPaymentTypes (@AllowCC TINYINT, @AllowEFT TINYINT) AS
SET NOCOUNT ON
SELECT PaymentTypeID,PaymentType,StringID 
FROM PaymentTypes 
	WHERE IsPayType = 1
	AND CustomerPayment = 1
	AND (@AllowCC = 1 OR PaymentTypeID <> 8)
	AND (@AllowEFT = 1 OR PaymentTypeID <> 16)
	AND SortOrder >= 0
ORDER BY SortOrder,PaymentType
GO

CREATE PROCEDURE dbo.ListPaymentTypes (@AllowCC INT, @AllowEFT INT) AS
SET NOCOUNT ON
SELECT PaymentTypeID,PaymentType,StringID 
FROM PaymentTypes 
	WHERE IsPayType = 1
	AND (@AllowCC = 1 OR PaymentTypeID <> 8)
	AND (@AllowEFT = 1 OR PaymentTypeID <> 16)
	AND SortOrder >= 0
ORDER BY SortOrder,PaymentType
GO

CREATE PROCEDURE dbo.ListPrintTypes AS
SET NOCOUNT ON
SELECT PrintTypeID, PrintType
FROM PrintTypes
ORDER BY PrintType
GO

CREATE PROCEDURE dbo.ListPriorities AS
SET NOCOUNT ON
SELECT PriorityID, Priority, StringID
FROM Priorities
ORDER BY PriorityID
GO

CREATE PROCEDURE dbo.ListPromoCodes AS
SET NOCOUNT ON
SELECT PromoCodeID, Code, PromoCode, StringID, CASE WHEN Active = 0 THEN 'inactive' WHEN ExpireDate < getdate() THEN 'expired' END AS Class, GroupID
FROM PromoCodes
ORDER BY Active DESC, CASE WHEN ExpireDate < getdate() THEN 1 ELSE 0 END ASC, Code
GO

CREATE PROCEDURE dbo.ListRadSearchTypes (@RadSearchTypeID INT) AS
SET NOCOUNT ON
SELECT RadSearchTypeID, RadSearchType
FROM RadSearchTypes
	WHERE (@RadSearchTypeID IS NULL OR RadSearchTypeID = @RadSearchTypeID)
ORDER BY 1
GO

CREATE PROCEDURE dbo.ListRadFilterTypes AS
SET NOCOUNT ON
SELECT RadFilterTypeID, RadFilterType
FROM RadFilterTypes
ORDER BY 1
GO

CREATE PROCEDURE dbo.ListRadAttributes (@RadVendorID INT) AS
SET NOCOUNT ON
SELECT RadAttributeID, Name AS RadAttribute, RadAttributeType
FROM RadAttributes
	WHERE RadAttributeType NOT IN (20,21,22,23,27,28)
	AND RadVendorID = @RadVendorID
ORDER BY 2
GO

CREATE PROCEDURE dbo.ListRadFailReasons AS
SET NOCOUNT ON
SELECT RadFailReasonID, RadFailReason
FROM RadFailReasons
ORDER BY SortOrder, RadFailReason
GO

CREATE PROCEDURE dbo.ListRadMergeTypes AS
SET NOCOUNT ON
SELECT RadMergeTypeID, RadMergeType, StringID
FROM RadMergeTypes
	WHERE AllowAttr = 1
ORDER BY RadMergeType
GO

CREATE PROCEDURE dbo.ListRadValues (@VendorID INT, @AttributeID INT) AS
SET NOCOUNT ON
SELECT Value, Name AS Description 
FROM RadValues 
	WHERE RadVendorID = @VendorID
	AND RadAttributeID = @AttributeID
ORDER BY Name
GO

CREATE PROCEDURE dbo.ListRadVendors AS
SET NOCOUNT ON
SELECT RadVendorID, Name AS RadVendor
FROM RadVendors
ORDER BY CASE WHEN RadVendorID = 0 THEN 0 ELSE 1 END ASC,2
GO

CREATE PROCEDURE dbo.ListRecentEvents AS
SET NOCOUNT ON
SELECT EventID,Event,CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM Events
	WHERE CloseDate IS NULL
	OR CloseDate > DATEADD(mm,-2,getdate())
ORDER BY Active DESC, CreateDate DESC
GO

CREATE PROCEDURE dbo.ListRegionGroups AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, RegionGroupID, RegionGroup, StringID
FROM RegionGroups
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, RegionGroup
GO

CREATE PROCEDURE dbo.ListRegions AS
SET NOCOUNT ON
SELECT CASE WHEN r.SortOrder < 0 OR rg.SortOrder < 0 THEN 'hidden' END AS Class, rg.RegionGroup, rg.StringID AS rgStringID, r.RegionID, r.Region, r.StringID, r.GroupID
FROM Regions r LEFT JOIN RegionGroups rg ON (r.RegionGroupID = rg.RegionGroupID)
ORDER BY CASE WHEN rg.SortOrder IS NULL THEN -1 WHEN rg.SortOrder < 0 THEN 0 ELSE 1 END DESC, rg.SortOrder ASC, rg.RegionGroup, 
         CASE WHEN r.SortOrder < 0 THEN 0 ELSE 1 END DESC, r.SortOrder ASC, r.Region
GO

CREATE PROCEDURE dbo.ListReportGroups (@ReportGroupTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT rg.ReportGroupID, rg.ReportGroup, rg.StringID, rg.AccessLabel, rg.FeatureID, rg.SortOrder
FROM ReportGroups rg JOIN Reports r ON (rg.ReportGroupID = r.ReportGroupID AND r.Active = 1)
	WHERE rg.ReportGroupTypeID = @ReportGroupTypeID
ORDER BY rg.SortOrder, rg.ReportGroup
GO

CREATE PROCEDURE dbo.ListReports (@ReportGroupTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT r.ReportID, r.ReportTypeID, r.Report, r.FileName, COALESCE(r.AccessLabel,rg.AccessLabel) AS AccessLabel, rg.ReportGroup, rg.FeatureID, rg.StringID, rg.Class
FROM Reports r JOIN ReportGroups rg ON (r.ReportGroupID = rg.ReportGroupID)
	WHERE rg.ReportGroupTypeID = @ReportGroupTypeID
	AND r.Active = 1
	AND rg.Active = 1
ORDER BY rg.SortOrder, rg.ReportGroup, r.SortOrder, r.Report
GO

CREATE PROCEDURE dbo.ListRoleAssignTypes (@RoleTypeID INT) AS
SET NOCOUNT ON
SELECT RoleAssignTypeID, RoleAssignType
FROM RoleAssignTypes
	WHERE @RoleTypeID & RoleTypeMask = @RoleTypeID
ORDER BY 2
GO

CREATE PROCEDURE dbo.ListReferredBys AS
SET NOCOUNT ON
SELECT ReferredByID, ReferredBy, StringID, GroupID, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM ReferredBys
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, ReferredBy
GO

CREATE PROCEDURE dbo.ListSalesPersons AS
SET NOCOUNT ON
SELECT CASE WHEN Active = 0 THEN 'inactive' WHEN SortOrder < 0 THEN 'hidden' END AS Class, SalesPersonID, SalesPerson, GroupID
FROM SalesPersons
ORDER BY CASE WHEN SortOrder < 0 OR Active = 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, SalesPerson
GO

CREATE PROCEDURE dbo.ListSchedules AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ScheduleID, TaskName, Description, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM Schedules
	WHERE Interval > 0
ORDER BY Active DESC,TaskName,Description
GO

CREATE PROCEDURE dbo.ListSchedBlockTypes AS
SET NOCOUNT ON
SELECT SchedBlockTypeID, SchedBlockType, StringID
FROM SchedBlockTypes
ORDER BY SchedBlockType
GO

CREATE PROCEDURE dbo.ListSchedBlocks (@SchedBlockTypeID INT) AS
SET NOCOUNT ON
SELECT SchedBlockID, SchedBlock, StringID, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM SchedBlocks 
	WHERE SchedBlockTypeID = @SchedBlockTypeID
ORDER BY StartHour, StartMinute
GO

CREATE PROCEDURE dbo.ListSearchInvAttributes (@InvCategoryID INT, @InvSubCategoryID INT, @InvProductID INT) AS
SET NOCOUNT ON
SELECT DISTINCT ia.InvAttributeID, ia.InvAttribute, ila.Required, ila.RegExp, (SELECT COUNT(*) FROM InvValues WHERE InvAttributeID=ia.InvAttributeID) AS ValueCount
FROM InvAttributes ia JOIN InvLevelAttributes ila ON (ia.InvAttributeID = ila.InvAttributeID)
	LEFT JOIN InvProducts ip ON (ip.InvProductID = @InvProductID)
	WHERE ((@InvCategoryID IS NOT NULL AND ila.InvCategoryID = @InvCategoryID)
		OR (@InvSubCategoryID IS NOT NULL AND ila.InvSubCategoryID = @InvSubCategoryID)
		OR (@InvProductID IS NOT NULL AND (ila.InvProductID = @InvProductID OR ila.InvSourceID = ip.InvSourceID)))
	AND ia.InvLevelTypeID = 2
GO

CREATE PROCEDURE dbo.ListSearchQueries (@SearchTypeID INT) AS
SET NOCOUNT ON
SELECT SearchQueryID, SearchQuery, FeatureID, SQLQuery
FROM SearchQueries
	WHERE SearchTypeID = @SearchTypeID
	AND SortOrder >= 0
ORDER BY SortOrder,SearchQuery
GO

CREATE PROCEDURE dbo.ListSectionAreas AS
SET NOCOUNT ON
SELECT SectionAreaID, SectionArea 
FROM SectionAreas 
ORDER BY SortOrder, SectionArea
GO

CREATE PROCEDURE dbo.ListSendMethods AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, SendMethodID, SendMethod, StringID, GroupID
FROM SendMethods
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, SendMethod
GO

CREATE PROCEDURE dbo.ListServerGroups AS
SET NOCOUNT ON
SELECT sg.ServerGroupID, MIN(sg.ServerGroup) AS ServerGroup, COUNT(s.ServerID) AS Servers
FROM ServerGroups sg LEFT JOIN Servers s ON (sg.ServerGroupID = s.ServerGroupID)
GROUP BY sg.ServerGroupID
ORDER BY 2,1
GO

CREATE PROCEDURE dbo.ListServerPorts (@ServerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT cs.AcctSessionID, cs.NASIdentifier, cs.NASPort, cs.Username, cs.FramedIPAddress, cs.FramedIPv6Address, cs.FramedIPv6Prefix, cs.AccountID, cs.CallingStationID, cs.CalledStationID, cs.ConnectInfo
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	WHERE cs.ServerID = @ServerID
ORDER BY cs.Username, cs.FramedIPAddress, cs.FramedIPv6Prefix
GO

CREATE PROCEDURE dbo.ListServers (@ServerGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT s.ServerID, s.ServerGroupID, s.Server, s.IPAddress, st.ServerType,
(SELECT COUNT(*) FROM ServerPorts sp, CallStarts cs WHERE sp.CallStartID = cs.CallStartID AND cs.ServerID = s.ServerID) AS ActiveSessions,
CASE WHEN s.Ports = 0 THEN NULL ELSE s.Ports END AS Ports, s.ProbeCOAInterval, s.Concurrency, s.CheckAccess, s.Location, CASE WHEN s.ServerPassword IS NOT NULL THEN 1 ELSE 0 END AS HaveServerPassword,
CASE WHEN s.DisconnectPort IS NOT NULL THEN 1 ELSE 0 END AS HaveDynAuth

FROM Servers s JOIN ServerTypes st ON (s.ServerTypeID = st.ServerTypeID)
	WHERE (@ServerGroupID IS NULL OR s.ServerGroupID = @ServerGroupID)
ORDER BY 5,3
GO

CREATE PROCEDURE dbo.ListServiceCategories AS
SET NOCOUNT ON
SELECT CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class, ServiceCategoryID, ServiceCategory, StringID, GroupID
FROM ServiceCategories
ORDER BY CASE WHEN SortOrder < 0 THEN 0 ELSE 1 END DESC, SortOrder ASC, ServiceCategory
GO

CREATE PROCEDURE dbo.ListServiceGroups AS
SET NOCOUNT ON
SELECT ServiceGroupID,ServiceGroup, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM ServiceGroups
ORDER BY CASE WHEN SortOrder >= 0 THEN 1 ELSE 0 END DESC, SortOrder, ServiceGroupID
GO

CREATE PROCEDURE dbo.ListSignupAccountTypes (@ServiceCategoryID INT, @BillingCycleID INT, @GroupID INT, @hide TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN at1.SortOrder < 0 THEN 'hidden' WHEN at1.EndDate < getdate() THEN 'inactive' WHEN at1.StartDate > getdate() THEN 'inactive' END AS Class, at1.AccountTypeID, at1.AccountType, at1.StringID, at1.Description
FROM AccountTypes at1 LEFT JOIN ServiceCatAccountTypes scat ON (at1.AccountTypeID = scat.AccountTypeID AND scat.ServiceCategoryID = @ServiceCategoryID)
	LEFT JOIN BillingCycles bc ON (bc.BillingCycleID = @BillingCycleID)
	WHERE ((at1.GroupID = @GroupID AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR (@GroupID IS NULL AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR (EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = at1.ServiceGroupID AND sgi.GroupID = @GroupID) AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0))
	OR (at1.GroupID IS NULL AND @GroupID IS NOT NULL AND EXISTS (SELECT * FROM Groups WHERE GroupID = @GroupID AND GlobalAccountTypes = 1) AND (@hide = 0 OR @hide = 1 AND at1.SortOrder >= 0)))
	AND (@ServiceCategoryID IS NULL OR scat.AccountTypeID IS NOT NULL)
	AND (bc.AutoBill IS NULL OR bc.AutoBill IN (0,1) OR (bc.AutoBill = 2 AND EXISTS (SELECT * FROM TimeCharges tc WHERE tc.AccountTypeID = at1.AccountTypeID)))
ORDER BY CASE WHEN at1.SortOrder < 0 THEN 0 ELSE 1 END DESC, scat.ServiceLevel, at1.SortOrder ASC, at1.AccountType
GO

CREATE PROCEDURE dbo.ListSignupPaymentTypes AS
SET NOCOUNT ON
SELECT PaymentTypeID, COALESCE(CustomerDescription,PaymentType) AS PaymentType, CASE WHEN CustomerDescription IS NOT NULL THEN CustomerStringID ELSE StringID END AS StringID
FROM PaymentTypes
	WHERE CustomerAccess = 1
ORDER BY SortOrder, PaymentType
GO

CREATE PROCEDURE dbo.ListSites AS
SET NOCOUNT ON
SELECT s.SiteID, s.Site
FROM Sites s
ORDER BY s.Site
GO

CREATE PROCEDURE dbo.ListStates (@CountryID INT) AS
SET NOCOUNT ON
SELECT s.StateID, s.State, s.Abbreviation, c.ZipStatus
FROM States s JOIN Countries c ON (s.CountryID = c.CountryID)
	WHERE s.CountryID = @CountryID
ORDER BY s.SortOrder,s.State
GO

CREATE PROCEDURE dbo.ListSyslogFacilities AS
SET NOCOUNT ON
SELECT SyslogFacilityID, SyslogFacility, StringID
FROM SyslogFacilities 
ORDER BY SyslogFacility
GO

CREATE PROCEDURE dbo.ListSyslogSeverities AS
SET NOCOUNT ON
SELECT SyslogSeverityID, SyslogSeverity, StringID
FROM SyslogSeverities
ORDER BY SyslogSeverityID
GO

CREATE PROCEDURE dbo.ListTaxGroups AS
SET NOCOUNT ON
SELECT TaxGroupID, TaxGroup
FROM TaxGroups
ORDER BY TaxGroup
GO

CREATE PROCEDURE dbo.ListTaxSources AS
SET NOCOUNT ON
SELECT ts.TaxSourceID, ts.TaxSource, tst.TaxSourceType
FROM TaxSources ts JOIN TaxSourceTypes tst ON (ts.TaxSourceTypeID=tst.TaxSourceTypeID)
ORDER BY tst.TaxSourceType,ts.TaxSource
GO

CREATE PROCEDURE dbo.ListThemes AS
SET NOCOUNT ON
SELECT ThemeID, Theme
FROM Themes
ORDER BY Theme
GO

CREATE PROCEDURE dbo.ListTowers AS
SET NOCOUNT ON
SELECT t.TowerID, tt.TowerType, t.Tower
FROM Towers t JOIN TowerTypes tt ON (t.TowerTypeID = tt.TowerTypeID)
ORDER BY CASE WHEN t.SortOrder >= 0 THEN 1 ELSE 0 END DESC, t.SortOrder, t.Tower
GO

CREATE PROCEDURE dbo.MBRDefault (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @TempExtension INT

SELECT @TempExtension = NumValue FROM ConfigGroupData WHERE ConfigID = 9 AND GroupID = @GroupID

IF (@TempExtension IS NULL)
BEGIN
SELECT @TempExtension = NumValue FROM Configs WHERE ConfigID = 9
END

SELECT COALESCE(@TempExtension,0) AS TempExtension
GO

CREATE PROCEDURE dbo.MBRDelete (@CustomerID INT) AS
SET NOCOUNT ON

IF ((SELECT COUNT(*) FROM MasterAccounts WHERE Active <> 1 AND CustomerID = @CustomerID) = 1)
BEGIN
DELETE FROM Files WHERE CustomerID = @CustomerID
DELETE FROM BankTrans WHERE CustomerID = @CustomerID
DELETE FROM CreditCards WHERE CustomerID = @CustomerID
DELETE FROM CreditCardUpdates WHERE CustomerID = @CustomerID
DELETE FROM NoticeActives WHERE CustomerID = @CustomerID
DELETE FROM AccountChanges WHERE CustomerID = @CustomerID
DELETE FROM MasterAccountPromoCodes WHERE CustomerID = @CustomerID
DELETE FROM OperatorPins WHERE CustomerID = @CustomerID
DELETE FROM NoticeLogs WHERE CustomerID = @CustomerID
UPDATE Domains SET CustomerID = NULL WHERE CustomerID = @CustomerID
UPDATE Organizations SET ResellerCustomerID = NULL WHERE ResellerCustomerID = @CustomerID
UPDATE InvItemLogs SET CustomerID = NULL, AccountID = NULL WHERE CustomerID = @CustomerID
DELETE FROM Alerts WHERE CustomerID = @CustomerID
DELETE FROM OperatorPayments WHERE CustomerID = @CustomerID
DELETE FROM RateHistory WHERE CustomerID = @CustomerID
DELETE FROM AlertInvMasterAccounts WHERE CustomerID = @CustomerID
DELETE FROM AlertFileMasterAccounts WHERE CustomerID = @CustomerID
DELETE FROM MasterAccountData WHERE CustomerID = @CustomerID
DELETE FROM Actions WHERE IncidentID IN (SELECT IncidentID FROM Incidents WHERE CustomerID = @CustomerID)
DELETE FROM IncidentData WHERE IncidentID IN (SELECT IncidentID FROM Incidents WHERE CustomerID = @CustomerID)
DELETE FROM Incidents WHERE CustomerID = @CustomerID
UPDATE MasterAccounts SET BillingAddressID = NULL, ServiceAddressID = NULL, ShippingAddressID = NULL, LastStatementID = NULL WHERE CustomerID = @CustomerID
UPDATE SubAccounts SET ServiceAddressID = NULL, ContactAddressID = NULL WHERE CustomerID = @CustomerID
DELETE FROM AddressData WHERE AddressID IN (SELECT AddressID FROM Addresses WHERE CustomerID = @CustomerID)
DELETE FROM AddressSyncs WHERE AddressID IN (SELECT AddressID FROM Addresses WHERE CustomerID = @CustomerID)
DELETE FROM Addresses WHERE CustomerID = @CustomerID
DELETE FROM MasterAccountTags WHERE CustomerID = @CustomerID
DELETE FROM AccountTagTimes WHERE CustomerID = @CustomerID
DELETE FROM AccountChanges WHERE CustomerID = @CustomerID
UPDATE AuditTrans SET CustomerID = NULL WHERE CustomerID = @CustomerID
DELETE FROM ExternalTrans WHERE CustomerID = @CustomerID
UPDATE CardAccounts SET DirectCustomerID = NULL, DirectAccountID = NULL WHERE DirectCustomerID = @CustomerID
UPDATE InvItems SET CustomerID = NULL, AccountID = NULL WHERE CustomerID = @CustomerID
DELETE FROM SubAccountUsages WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM InvoiceTags WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @CustomerID)
DELETE FROM InvoiceSubAccounts WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @CustomerID)
UPDATE Charges SET ItemID = NULL WHERE ItemID IS NOT NULL AND CustomerID = @CustomerID
DELETE FROM PaymentItems WHERE PaymentID IN (SELECT PaymentID FROM Payments WHERE CustomerID = @CustomerID)
DELETE FROM PaymentItems WHERE ChargeID IN (SELECT ChargeID FROM Charges WHERE CustomerID = @CustomerID)
DELETE FROM ResellerUsage WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM InvoiceItemDiscounts WHERE ItemID IN (SELECT ii.ItemID FROM InvoiceItems ii JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID) WHERE i.CustomerID = @CustomerID)
DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @CustomerID)
DELETE FROM Payments WHERE CustomerID = @CustomerID
DELETE FROM Invoices WHERE CustomerID = @CustomerID
DELETE FROM VoiceCalls WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM Charges WHERE CustomerID = @CustomerID
DELETE FROM Statements WHERE CustomerID = @CustomerID

DELETE FROM Forwards WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM Aliases WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM GaugeData WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM GaugeCounterData WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM OperatorCookies WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM NoticeActives WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM ExternalSyncs WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM PosixAccountUsers WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM RefStates WHERE SrcAccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM RefStates WHERE DstAccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM SubAccountData WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM RadConfigs WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM AccountTagTimes WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM SubAccountTags WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM RadPoolStates WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM AlertInvSubAccounts WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM AlertFileSubAccounts WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM Alerts WHERE AccountID IN (SELECT AccountID FROM SubAccounts WHERE CustomerID = @CustomerID)
DELETE FROM SubAccounts WHERE CustomerID = @CustomerID
DELETE FROM MasterAccounts WHERE CustomerID = @CustomerID
END ELSE BEGIN
SELECT 'MBR #' + CAST(@CustomerID AS VARCHAR(10)) + ' not found or MBR is Active' AS Description
END
GO

CREATE PROCEDURE dbo.MBRMoveList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT sa.AccountID, sa.ParentAccountID, sa.Login, a.FirstName, a.LastName, a.Company, at1.AccountTypeID, at1.AccountType, at1.StringID AS atStringID, sc.ServiceCategory, sc.StringID AS scStringID, 
sa.PayPeriodID, pp.PayPeriod, sa.RemoteAccess, sa.SalesPersonID, sp.SalesPerson,
CASE WHEN sa.Active = 0 THEN 'inactive'
WHEN sa.CancelDate IS NOT NULL THEN 'canceled'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate() THEN 'expired'
ELSE 'active' END AS Class

FROM MasterAccounts ma JOIN SubAccounts sa ON (sa.CustomerID = ma.CustomerID)
	JOIN ServiceCategories sc ON (sa.ServiceCategoryID = sc.ServiceCategoryID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN SalesPersons sp ON (sa.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND sa.Active IN (1,0)
ORDER BY sa.Login, a.LastName
GO

CREATE PROCEDURE dbo.MBRPromoCodes (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mapc.PromoCodeID, mapc.CreateDate, mapc.CreateUser, pc.Code, pc.PromoCode AS Description
FROM MasterAccountPromoCodes mapc JOIN PromoCodes pc ON (mapc.PromoCodeID = pc.PromoCodeID)
	WHERE mapc.CustomerID = @CustomerID
ORDER BY mapc.CreateDate DESC
GO

CREATE PROCEDURE dbo.MBRACHLoad (@CustomerID INT) AS
SET NOCOUNT ON
SELECT AuthName, BankName, BankPhone, ABANumber, AccountNumber, TransType, SSN, BirthDate, DLNumber, DLState 
FROM BankTrans
	WHERE CustomerID = @CustomerID
UNION ALL
SELECT a.FirstName + ' ' + a.LastName AS AuthName, NULL AS BankName, NULL AS BankPhone, NULL AS ABANumber, NULL AS AccountNumber, NULL AS TransType, NULL AS SSN, NULL AS BirthDate, NULL AS DLNumber, NULL AS DLState
FROM MasterAccounts ma JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRAddresses (@CustomerID INT, @all TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @WebLinkTypeID INT, @LocURL VARCHAR(255)

SELECT @WebLinkTypeID = MIN(wlt.WebLinkTypeID)
FROM MasterAccounts ma JOIN WebLinkTypes wlt ON (ma.GroupID = wlt.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND wlt.AllowAddrLocation = 1

IF (@WebLinkTypeID IS NULL)
BEGIN
SELECT @WebLinkTypeID = MIN(WebLinkTypeID) FROM WebLinkTypes WHERE AllowAddrLocation = 1
END

IF (@WebLinkTypeID IS NOT NULL)
BEGIN
SELECT @LocURL = MIN(wl.URL) FROM WebLinks wl WHERE WebLinkTypeID = @WebLinkTypeID
END

SELECT adt.AddressTypeID, 1 AS IsMBR, a.AccountID, 
CASE WHEN a.AddressID = ma.BillingAddressID THEN 1 ELSE 0 END AS IsBilling, 
CASE WHEN a.AddressID = ma.ServiceAddressID THEN 1 ELSE 0 END AS IsService,
CASE WHEN a.AddressID = ma.ShippingAddressID THEN 1 ELSE 0 END AS IsShipping,
CASE WHEN DATEPART(dd,getdate()) = DATEPART(dd,a.BirthDate) AND DATEPART(mm,getdate()) = DATEPART(mm,a.BirthDate) THEN 1 ELSE 0 END AS IsBirthday,
adt.AddressType, adt.StringID AS AddressTypeStringID, c.Country, c.StringID AS CountryStringID, COALESCE(s.Abbreviation,s.State) AS State,
a.BirthDate, a.Company, a.Address1, a.Address2, a.City, a.Zip, a.Province, a.FirstName, a.LastName, a.PhoneHome, a.PhoneWork, a.PhoneFax, a.PhoneMobile,
a.Email, a.WWW, a.AddressID, imt.IMType, imt.StringID AS IMTypeStringID, CASE WHEN imt.IMTypeID IS NOT NULL THEN a.IMHandle END AS IMHandle, imt.URI,
c.DescAux1, c.DescAux2, c.DescAux3, 
CASE WHEN c.DescAux1 IS NOT NULL THEN a.Aux1 END AS Aux1,
CASE WHEN c.DescAux2 IS NOT NULL THEN a.Aux2 END AS Aux2,
CASE WHEN c.DescAux3 IS NOT NULL THEN a.Aux3 END AS Aux3,
a.TaxNumber,a.SSN,a.DLNumber,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
CASE WHEN (a.Lat IS NOT NULL OR as1.Lat IS NOT NULL) AND (a.Long IS NOT NULL OR as1.Long IS NOT NULL) THEN @LocURL END AS LocURL,
CASE WHEN as1.ExportStatus = 1 AND a.Lat IS NULL AND a.Long IS NULL AND (a.CountryID <> as1.CountryID OR a.StateID <> as1.StateID OR a.Address1 <> as1.Address1 OR a.Address2 <> as1.Address2 OR a.Zip <> as1.Zip) THEN 1 ELSE 0 END AS GeoSync,
CASE WHEN (a.Lat IS NULL OR a.Long IS NULL) AND as1.ExportStatus IN (2,3) THEN as1.Message END AS GeoMessage,
CASE WHEN sa.Active IN (0,-1) THEN 'inactive' END AS Class,
CASE WHEN a.Email IS NOT NULL AND a.EmailNoticePurposeMask & 1 = 1 THEN 'billnotify' END AS EmailClass,
CASE WHEN a.PhoneMobile IS NOT NULL AND a.SMSNoticePurposeMask & 1 = 1 THEN 'billnotify' END AS SMSClass

FROM MasterAccounts ma JOIN Addresses a ON (ma.CustomerID = a.CustomerID)
	JOIN AddressTypes adt ON (a.AddressTypeID = adt.AddressTypeID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN IMTypes imt ON (a.IMTypeID = imt.IMTypeID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
	WHERE ma.CustomerID = @CustomerID
	AND (@all = 1 OR (@all = 0 AND a.AddressID IN (ma.BillingAddressID,ma.ServiceAddressID,ma.ShippingAddressID)))
ORDER BY CASE WHEN a.AccountID IS NULL THEN 1 ELSE 0 END DESC, adt.SortOrder, 4 DESC, 5 DESC,  adt.AddressType
GO

CREATE PROCEDURE dbo.MBRAddressData (@CustomerID INT, @detail TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ad.AddressID,adt.AddressDataType,adt.StringID,ad.Data
FROM MasterAccounts ma JOIN AddressData ad ON (ma.BillingAddressID = ad.AddressID OR ma.ServiceAddressID = ad.AddressID OR ma.ShippingAddressID = ad.AddressID)
	JOIN AddressDataTypes adt ON (ad.AddressDataTypeID = adt.AddressDataTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ((@detail = 0 AND adt.Summary = 1) OR (@detail = 1 AND adt.Detail = 1))
	AND adt.SortOrder >= 0
	AND ad.Data IS NOT NULL
ORDER BY adt.SortOrder,adt.AddressDataType
GO

CREATE PROCEDURE dbo.MBRAging (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT ma.CustomerID, End0Bal AS Balance0,
CASE WHEN End30Bal > 0 THEN End30Bal ELSE 0 END AS Balance30,
CASE WHEN End60Bal > 0 THEN End60Bal ELSE 0 END AS Balance60,
CASE WHEN End90Bal > 0 THEN End90Bal ELSE 0 END AS Balance90,
CASE WHEN End120Bal > 0 THEN End120Bal ELSE 0 END AS Balance120,
s.StatementDate AS AgedDate
FROM MasterAccounts ma JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	AND ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRAlerts (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @confirm_cnt INT, @confirm_cost NUMERIC(18,4), @decline_cnt INT, @decline_cost NUMERIC(18,4), @pend_cnt INT, @pend_cost NUMERIC(18,4)
DECLARE @AutoBill SMALLINT, @TempExtension INT, @PaymentTypeID INT, @BillingAddressID INT, @GroupID INT, @RegionID INT, @Active INT, @CancelDate DATETIME, @TowerID INT, @StartDate DATETIME
DECLARE @email_missing TINYINT, @exp_cnt INT, @expg_cnt INT, @card_expired INT, @card_missing INT, @eft_missing INT, @inc_cnt INT, @apptp_cnt INT, @apptf_cnt INT, @sa_cnt INT, @lookmax INT

SELECT @lookmax = MAX(LookbackMins) FROM GaugeAlerts WHERE Active = 1

SELECT @BillingAddressID = ma.BillingAddressID, @email_missing = CASE WHEN ma.BillingAddressID IS NOT NULL AND ma.Active = 1 AND bc.AutoBill IN (0,1) AND sm.EmailTypeID IS NOT NULL AND sm.PrintTypeID IS NULL THEN 1 ELSE 0 END, @AutoBill = bc.AutoBill, @TempExtension = ma.TempExtension, @PaymentTypeID = ma.PaymentTypeID, @GroupID = ma.GroupID, @RegionID = ma.RegionID, @Active = ma.Active, @CancelDate = ma.CancelDate, @StartDate = ma.StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	WHERE ma.CustomerID = @CustomerID

SELECT @confirm_cnt = SUM(CASE WHEN et.TransStateID = 1 THEN 1 ELSE 0 END), 
@confirm_cost = SUM(CASE WHEN et.TransStateID = 1 THEN et.Amount ELSE 0 END),
@decline_cnt = SUM(CASE WHEN et.TransStateID = 3 AND @Active = 1 THEN 1 ELSE 0 END),
@decline_cost = SUM(CASE WHEN et.TransStateID = 3 AND @Active = 1 THEN et.Amount ELSE 0 END),
@pend_cnt = SUM(CASE WHEN et.TransStateID IN (0,2) THEN 1 ELSE 0 END),
@pend_cost = SUM(CASE WHEN et.TransStateID IN (0,2) THEN et.Amount ELSE 0 END)
FROM ExternalTrans et
	WHERE et.CustomerID = @CustomerID
	AND et.TransStateID IN (0,1,2,4)
	AND et.TransTypeID IN (32,64)

SELECT @inc_cnt = SUM(CASE WHEN i.SchedDate IS NULL THEN 1 ELSE 0 END), @apptp_cnt = SUM(CASE WHEN i.SchedDate < getdate() THEN 1 ELSE 0 END), @apptf_cnt = SUM(CASE WHEN i.SchedDate > getdate() THEN 1 ELSE 0 END)
FROM Incidents i JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	WHERE i.CustomerID = @CustomerID
	AND i.CreateDate > DATEADD(mm,-6,getdate())
	AND is1.StatOpen = 1

IF (@email_missing = 1 AND EXISTS
	(
	SELECT *
	FROM Addresses a LEFT JOIN SubAccounts sa ON (a.AccountID = sa.AccountID)
		WHERE a.CustomerID = @CustomerID
		AND a.EmailNoticePurposeMask & 1 = 1
		AND a.Email IS NOT NULL
		AND (sa.Active IS NULL OR sa.Active = 1)
	))
BEGIN
SELECT @email_missing = 0
END

IF (@AutoBill IN (0,1) AND @Active = 1 AND (@CancelDate IS NULL OR @CancelDate > getdate()))
BEGIN
SELECT @sa_cnt = COUNT(*),
@TowerID = MIN(TowerID),
@exp_cnt = SUM(CASE WHEN DATEADD(dd,@TempExtension + Extension + 1,ExpireDate) < getdate() THEN 0 WHEN ExpireDate < DATEADD(dd,-1,getdate()) AND (CancelDate IS NULL OR CancelDate > getdate()) AND @AutoBill = 0 THEN 1 END), 
@expg_cnt = SUM(CASE WHEN DATEADD(dd,@TempExtension + Extension + 1,ExpireDate) < getdate() AND ExpireDate < DATEADD(dd,-1,getdate()) AND (CancelDate IS NULL OR CancelDate > getdate()) AND @AutoBill = 0 THEN 1 ELSE 0 END)
FROM SubAccounts 
	WHERE CustomerID = @CustomerID
	AND Active = 1
	AND Recurring = 1
END

IF (@PaymentTypeID = 8 AND @Active = 1)
BEGIN
SELECT @card_missing = CASE WHEN COUNT(*) = 0 OR MIN(CardNumber) IS NULL OR MIN(ExpirationDate) IS NULL THEN 1 ELSE 0 END, @card_expired = CASE WHEN MIN(ExpirationDate) < getdate() THEN 1 ELSE 0 END
FROM CreditCards 
	WHERE CustomerID = @CustomerID
END

IF (@PaymentTypeID = 16 AND @Active = 1)
BEGIN
SELECT @eft_missing = CASE WHEN COUNT(*) = 0 OR MIN(ABANumber) IS NULL OR MIN(AccountNumber) IS NULL THEN 1 ELSE 0 END
FROM BankTrans
	WHERE CustomerID = @CustomerID
END

SELECT 1 AS AlertMapID, @confirm_cnt AS Cnt, @confirm_cost AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @confirm_cnt > 0
UNION ALL
SELECT 2 AS AlertMapID, @pend_cnt AS Cnt, @pend_cost AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @pend_cnt > 0
UNION ALL
SELECT 3 AS AlertMapID, @decline_cnt AS Cnt, @decline_cost AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @decline_cnt > 0
UNION ALL
SELECT 4 AS AlertMapID, @inc_cnt AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @inc_cnt > 0
UNION ALL
SELECT 5 AS AlertMapID, @apptp_cnt AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @apptp_cnt > 0
UNION ALL
SELECT 6 AS AlertMapID, @apptf_cnt AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @apptf_cnt > 0
UNION ALL
SELECT 7 AS AlertMapID, @exp_cnt AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @exp_cnt > 0
UNION ALL
SELECT 8 AS AlertMapID, @expg_cnt AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @expg_cnt > 0
UNION ALL
SELECT 9 AS AlertMapID, @card_missing AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @card_missing > 0
UNION ALL
SELECT 10 AS AlertMapID, @card_expired AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @card_expired > 0
UNION ALL
SELECT 11 AS AlertMapID, @eft_missing AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @eft_missing > 0
UNION ALL
SELECT 16 AS AlertMapID, @eft_missing AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @sa_cnt = 0 AND @Active = 1 AND @AutoBill IN (0,1) AND (@CancelDate IS NULL OR @CancelDate > getdate())

UNION ALL

SELECT DISTINCT 12 AS AlertMapID, NULL AS Cnt, NULL AS Amount, et.IncidentTypeID, e.EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, e.Event AS Message
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	LEFT JOIN MasterAccountTags mat ON (e.MarketTagID = mat.MarketTagID AND mat.CustomerID = @CustomerID AND mat.Active = 1)
	WHERE @Active = 1
	AND e.Active = 1
	AND e.BulkProfileID IS NULL
	AND (e.CloseDate IS NULL OR e.CloseDate > getdate())
	AND (e.GroupID IS NULL OR e.GroupID = @GroupID)
	AND (e.RegionID IS NULL OR e.RegionID = @RegionID)
	AND (e.MarketTagID IS NULL OR mat.CustomerID IS NOT NULL)
	AND (e.TowerID IS NULL OR e.TowerID = @TowerID)
	AND NOT EXISTS (SELECT * FROM Incidents i WHERE i.CustomerID = @CustomerID AND i.EventID = e.EventID)

UNION ALL

SELECT DISTINCT 12 AS AlertMapID, NULL AS Cnt, NULL AS Amount, MIN(et.IncidentTypeID) AS IncidentTypeID, e.EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, MIN(e.Event) AS Message
FROM Events e JOIN EventTypes et ON (e.EventTypeID = et.EventTypeID)
	JOIN BulkItems bi ON (bi.BulkProfileID = e.BulkProfileID)
	JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
	JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID AND sa.Active = 1)
	LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mat.Active = 1)
	LEFT JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID AND sat.Active = 1)
	LEFT JOIN Addresses ads ON (ads.CustomerID = @CustomerID AND (bi.AddressCategoryID IS NULL OR (bi.AddressCategoryID = 1 AND ma.BillingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 2 AND ma.ShippingAddressID = ads.AddressID) OR (bi.AddressCategoryID = 4 AND sa.ServiceAddressID = ads.AddressID)))
	LEFT JOIN AddressData ad ON (ads.AddressID = ad.AddressID AND bi.AddressDataTypeID = ad.AddressDataTypeID)
	LEFT JOIN MasterAccountData mad ON (mad.CustomerID = @CustomerID AND bi.MAAccountDataTypeID = mad.AccountDataTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND bi.SAAccountDataTypeID = sad.AccountDataTypeID)
	WHERE @Active = 1
	AND e.Active = 1
	AND NOT EXISTS (SELECT * FROM Incidents i WHERE i.CustomerID = @CustomerID AND i.EventID = e.EventID)
	AND (e.CloseDate IS NULL OR e.CloseDate > getdate())
	AND (bi.GroupID IS NULL OR bi.GroupID = @GroupID)
	AND (bi.RegionID IS NULL OR bi.RegionID = @RegionID)
	AND (bi.TowerID IS NULL OR bi.TowerID = sa.TowerID)
	AND (bi.ServiceCategoryID IS NULL OR bi.ServiceCategoryID = sa.ServiceCategoryID)
	AND (bi.AccountTypeID IS NULL OR bi.AccountTypeID = sa.AccountTypeID)
	AND (bi.BillingCycleID IS NULL OR bi.BillingCycleID = ma.BillingCycleID)
	AND (bi.MarketTagID IS NULL OR bi.MarketTagID = mat.MarketTagID OR bi.MarketTagID = sat.MarketTagID)
	AND (bi.PaymentTypeID IS NULL OR bi.PaymentTypeID = ma.PaymentTypeID)
	AND (bi.SendMethodID IS NULL OR bi.SendMethodID = ma.SendMethodID)
	AND (bi.CountryID IS NULL OR bi.CountryID = ads.CountryID)
	AND (bi.StateID IS NULL OR bi.StateID = ads.StateID)
	AND (bi.Zip IS NULL OR bi.Zip = ads.Zip)
	AND (bi.City IS NULL OR bi.City = ads.City)
	AND (bi.AddressDataTypeID IS NULL OR ad.Data LIKE bi.AddressData)
	AND (bi.MAAccountDataTypeID IS NULL OR mad.Data LIKE bi.MAData) 
	AND (bi.SAAccountDataTypeID IS NULL OR sad.Data LIKE bi.SAData)
GROUP BY sa.AccountID, e.EventID
HAVING MIN(bi.Allowed) = 1

UNION ALL

SELECT 13 AS AlertMapID, NULL AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, AlertID, NULL AS FileCategoryID, NULL AS AddressID, at1.AlertType AS Item, a.Message
FROM Alerts a JOIN AlertTypes at1 ON (a.AlertTypeID = at1.AlertTypeID)
	WHERE a.CustomerID = @CustomerID
	AND a.AlertStateID = 1

UNION ALL

SELECT 14 AS AlertMapID, NULL AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, fc.FileCategoryID, NULL AS AddressID, NULL AS Item, fc.FileCategory AS Message
FROM FileCategories fc JOIN FileCategoryReqs fcr ON (fc.FileCategoryID = fcr.FileCategoryID)
	LEFT JOIN MasterAccountTags mat ON (fcr.MarketTagID = mat.MarketTagID AND mat.CustomerID = @CustomerID AND mat.Active = 1)
	LEFT JOIN Files f ON (fc.FileCategoryID = f.FileCategoryID AND f.CustomerID = @CustomerID AND f.Active = 1)
	LEFT JOIN AlertFileMasterAccounts afma ON (afma.CustomerID = @CustomerID AND fc.FileCategoryID = afma.FileCategoryID AND afma.AlertStateID > 1)
	WHERE @Active = 1
	AND fcr.FileApplyTypeID = 1
	AND (fcr.GroupID IS NULL OR fcr.GroupID = @GroupID)
	AND (fcr.MarketTagID IS NULL OR mat.CustomerID IS NOT NULL)
	AND f.FileID IS NULL
	AND afma.CustomerID IS NULL

UNION ALL

SELECT 15 AS AlertMapID, NULL AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, a.AddressID, NULL AS Item, as1.Message
FROM Addresses a JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
	WHERE @Active = 1
	AND a.CustomerID = @CustomerID
	AND as1.ExportStatus <> 1
	AND (a.Lat IS NULL OR a.Long IS NULL)

UNION ALL

SELECT 17 AS AlertMapID, COUNT(*) AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, MIN(res.Item) AS Item, MIN(res.Message) AS Message
FROM (SELECT ga.GaugeAlertID, MIN(g.Gauge) AS Item, MIN(ga.GaugeAlert) AS Message
FROM Gauges g JOIN GaugeAlerts ga ON (g.GaugeID = ga.GaugeID AND ga.Active = 1)
	JOIN SubAccounts sa ON (sa.CustomerID = @CustomerID)
	JOIN GaugeData gd ON (g.GaugeID = gd.GaugeID AND sa.AccountID = gd.AccountID)
	JOIN GaugeWindows gw ON (gd.GaugeWindowID = gw.GaugeWindowID)
	WHERE @Active = 1
	AND @lookmax IS NOT NULL
	AND gd.StartDate > DATEADD(mi,-@lookmax,getdate())
	AND gd.StartDate > DATEADD(mi,-ga.LookbackMins,getdate())
	AND (gd.Data < ga.TriggerBelow OR gd.Data > ga.TriggerAbove) 
GROUP BY sa.AccountID,ga.GaugeAlertID
HAVING SUM(gw.Secs) >= MIN(ga.DwellSecs)) res
GROUP BY res.GaugeAlertID

UNION ALL

SELECT 18 AS AlertMapID, NULL AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, NULL AS AddressID, NULL AS Item, NULL AS Message
	WHERE @StartDate > getdate()

UNION ALL

SELECT 19 AS AlertMapID, NULL AS Cnt, NULL AS Amount, NULL AS IncidentTypeID, NULL AS EventID, NULL AS AlertID, NULL AS FileCategoryID, @BillingAddressID AS AddressID, NULL AS Item, NULL AS Message
	WHERE @email_missing = 1
GO

CREATE PROCEDURE dbo.MBRBillDay (@BillingCycleID INT, @StartDate DATETIME) AS
SET NOCOUNT ON
SELECT CASE WHEN CycleType IN (1,2,4) THEN COALESCE(BillDay,1) ELSE COALESCE(DATEPART(dd,@StartDate),DATEPART(dd,getdate())) END AS BillDay
FROM BillingCycles
	WHERE BillingCycleID = @BillingCycleID
GO

CREATE PROCEDURE dbo.MBRCCLoad (@CustomerID INT) AS
SET NOCOUNT ON
SELECT CASE WHEN cc.Token IS NOT NULL AND cc.BatchProcessorID IS NOT NULL THEN cc.CardNumber END AS TokenCardNumber, CASE WHEN cc.Token IS NULL THEN cc.CardNumber END AS CardNumber, DATEPART(yy,cc.ExpirationDate) AS ExpireYear, RIGHT('0' + CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR(2)),2) AS ExpireMonth, 
cc.CardHolder, cc.BillToAddress1, cc.BillToAddress2, cc.BillToCity AS City, cc.BillToStateID AS StateID, COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID) AS CountryID, cc.BillToZip, cc.SecurityCode, cc.Bank, cc.BankPhone, CASE WHEN cc.BatchProcessorID IS NOT NULL THEN cc.Token END AS Token, cc.BatchProcessorID
FROM MasterAccounts ma JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
UNION ALL
SELECT NULL, NULL, NULL, NULL, a.FirstName + ' ' + a.LastName, a.Address1, a.Address2, a.City, a.StateID, COALESCE(a.CountryID,g.BillCountryID), a.Zip, NULL, NULL, NULL, NULL, NULL
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRCancelDefault (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN MAX(sa.BilledThru) > getdate() THEN MAX(sa.BilledThru) ELSE getdate() END AS CancelDate
FROM SubAccounts sa
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
GO

CREATE PROCEDURE dbo.MBRChargeSec (@CustomerID INT, @ChargeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS Cnt
FROM Charges
	WHERE ChargeID = @ChargeID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRChargeUnappliedList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT c.ChargeID, c.CreateDate, c.CreateUser, c.Amount, c.Quantity, ROUND(c.Amount * c.Quantity,2) AS Total, c.Description, c.StartDate, c.EndDate, at1.AccountType, at1.StringID AS at1StringID, ct.ChargeType, ct.StringID AS ctStringID
FROM Charges c LEFT JOIN AccountTypes at1 ON (c.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct ON (c.ChargeTypeID = ct.ChargeTypeID)
	WHERE c.CustomerID = @CustomerID
	AND c.ItemID IS NULL
GO

CREATE PROCEDURE dbo.MBRCloseAutoList WITH RECOMPILE AS
SET NOCOUNT ON
DECLARE @Days INT, @CancelReasonID INT

SELECT @Days = NumValue FROM Configs WHERE ConfigID = 376
SELECT @CancelReasonID = NumValue FROM Configs WHERE ConfigID = 375

SELECT ma.CustomerID, COALESCE(MAX(cgdc.NumValue),@CancelReasonID) AS CancelReasonID, MAX(sa.ExpireDate) AS CancelDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 376)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 375)
	WHERE bc.AutoBill = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Recurring = 1
	AND ma.CancelDate IS NULL
	AND sa.CancelDate IS NULL
	AND sa.ExpireDate IS NOT NULL
	AND COALESCE(cgdc.NumValue,@CancelReasonID) IS NOT NULL
	AND COALESCE(cgdd.NumValue,@Days) > 0
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) > DATEADD(dd,1 + sa.Extension + ma.TempExtension,sa.ExpireDate)
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) > sa.BilledThru
	AND NOT EXISTS
		(
		SELECT *
		FROM Invoices i
			WHERE i.CustomerID = ma.CustomerID
			AND i.VoidDate IS NULL
			AND i.InvoiceTypeID IN (1,2,3)
			AND i.CreateDate > DATEADD(dd,-33,getdate())
		)
	AND NOT EXISTS
		(
		SELECT * 
		FROM SubAccounts sa2 
			WHERE sa2.CustomerID = ma.CustomerID 
			AND sa2.Active = 1
			AND ((sa2.ExpireDate IS NULL) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < sa2.BilledThru) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < DATEADD(dd,1 + sa2.Extension + ma.TempExtension,sa2.ExpireDate)))
		)
GROUP BY ma.CustomerID
OPTION (FORCE ORDER)
GO

CREATE PROCEDURE dbo.MBRCurrentBalance (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @iTotal NUMERIC(18,4), @cTotal NUMERIC(18,4), @pTotal NUMERIC(18,4)

IF (@CustomerID IS NULL)
BEGIN
UPDATE ma SET PendingBalance = ma.Balance + COALESCE(ai.Amount,0) + COALESCE(ac.Amount,0) + COALESCE(ap.Amount,0)
FROM MasterAccounts ma
	LEFT JOIN
		(
		SELECT CustomerID, SUM(CASE WHEN StatementID IS NULL THEN Amount ELSE -Amount END) AS Amount
		FROM Invoices 
			WHERE Processed = 1
			AND ((StatementID IS NULL AND VoidDate IS NULL) OR (StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL))
		GROUP BY CustomerID
		) ai ON (ma.CustomerID = ai.CustomerID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(ROUND(Amount * Quantity,2)) AS Amount
		FROM Charges 
			WHERE ItemID IS NULL
		GROUP BY CustomerID
		) ac ON (ma.CustomerID = ac.CustomerID)
	LEFT JOIN
		(
		SELECT CustomerID, -SUM(CASE WHEN StatementID IS NULL THEN COALESCE(FinalAmount,Amount) ELSE FinalAmount - Amount END) AS Amount
		FROM Payments
			WHERE (StatementID IS NULL OR (StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL))
		GROUP BY CustomerID
		) ap ON (ma.CustomerID = ap.CustomerID)
	WHERE ma.Active = 1
END

IF (@CustomerID IS NOT NULL)
BEGIN
SELECT @iTotal = SUM(CASE WHEN StatementID IS NULL THEN Amount ELSE -Amount END)
FROM Invoices
	WHERE CustomerID = @CustomerID
	AND Processed = 1
	AND ((StatementID IS NULL AND VoidDate IS NULL) OR (StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL))

SELECT @cTotal = SUM(ROUND(Amount * Quantity,2))
FROM Charges
	WHERE CustomerID = @CustomerID
	AND ItemID IS NULL

SELECT @pTotal = -SUM(CASE WHEN StatementID IS NULL THEN COALESCE(FinalAmount,Amount) ELSE FinalAmount - Amount END)
FROM Payments
	WHERE CustomerID = @CustomerID
	AND (StatementID IS NULL OR (StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL))

UPDATE MasterAccounts SET PendingBalance = Balance + COALESCE(@iTotal,0) + COALESCE(@cTotal,0) + COALESCE(@pTotal,0)
	WHERE CustomerID = @CustomerID
	AND Active IN (1,0)
END
GO

CREATE PROCEDURE dbo.MBRCustom (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT adt.AccountDataType, adt.StringID, COALESCE(adv.ValueData,mad.Data) AS Data, mad.AccountDataTypeID
FROM MasterAccounts ma JOIN MasterAccountData mad ON (ma.CustomerID = mad.CustomerID)
	JOIN MasterAccountDataTypes madt ON (mad.AccountDataTypeID = madt.AccountDataTypeID)
	JOIN AccountDataTypes adt ON (mad.AccountDataTypeID = adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (mad.AccountDataTypeID=adv.AccountDataTypeID AND mad.Data=adv.KeyData)
	WHERE ma.CustomerID = @CustomerID
	AND mad.Data IS NOT NULL
	AND mad.Data <> ' '
	AND adt.AllowMBR = 1
	AND (madt.GroupID IS NULL OR madt.GroupID = ma.GroupID OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = madt.ServiceGroupID AND sgi.GroupID = ma.GroupID))
ORDER BY CASE WHEN madt.SortOrder >= 0 THEN 1 ELSE 0 END DESC, adt.AccountDataType
GO

CREATE PROCEDURE dbo.MBRDefaultEmail (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @Email VARCHAR(80)

SELECT @Email = a.Email
FROM MasterAccounts ma JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE a.EmailNoticePurposeMask & 1 = 1
	AND ma.CustomerID = @CustomerID
	AND a.Email IS NOT NULL
	AND a.Email LIKE '%@%'

IF (@Email IS NULL)
BEGIN
SELECT @Email = a.Email
FROM MasterAccounts ma JOIN Addresses a ON (ma.ShippingAddressID = a.AddressID OR ma.ServiceAddressID = a.AddressID)
	WHERE a.EmailNoticePurposeMask & 1 = 1
	AND ma.CustomerID = @CustomerID
	AND a.Email IS NOT NULL
	AND a.Email LIKE '%@%'
END

IF (@Email IS NULL)
BEGIN
SELECT @Email = MAX(a.Email)
FROM Addresses a
	WHERE a.EmailNoticePurposeMask & 1 = 1
	AND a.CustomerID = @CustomerID
	AND a.AccountID IS NULL
	AND a.Email IS NOT NULL
	AND a.Email LIKE '%@%'
END

IF (@Email IS NULL)
BEGIN
SELECT @Email = MAX(a.Email)
FROM Addresses a
	WHERE a.EmailNoticePurposeMask & 1 = 1
	AND a.CustomerID = @CustomerID
	AND a.AccountID IS NOT NULL
	AND a.Email IS NOT NULL
	AND a.Email LIKE '%@%'
END

IF (@Email IS NULL)
BEGIN
SELECT @Email = MAX(Email)
FROM SubAccounts 
	WHERE CustomerID = @CustomerID
	AND Active = 1
	AND SendBill = 1
	AND Email IS NOT NULL 
	AND Email LIKE '%@%'
END

IF (@Email IS NULL)
BEGIN
SELECT @Email = sa.Login + '@' + d.MailDomain
FROM SubAccounts sa JOIN Domains d ON (sa.DomainID = d.DomainID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.SendBill = 1
	AND sa.Email IS NULL
	AND sa.Login IS NOT NULL
END

SELECT @Email AS Email, sm.EmailTypeID, g.EmailSubject, g.EmailAccounts
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRBalance (@CustomerID INT) AS
SET NOCOUNT ON
SELECT CASE WHEN ma.PendingBalance <= 0 THEN NULL ELSE ma.PendingBalance END AS ChargeBalance, ma.PendingBalance AS CurrentBalance, ma.CreditLimit AS CreditLimit
FROM MasterAccounts ma
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRDetail (@CustomerID INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @rhTotalCost NUMERIC(18,4)

SELECT @rhTotalCost = SUM(TotalCost)
FROM RateHistory
	WHERE RateCostTypeID = 1 
	AND ChargeID IS NULL 
	AND CustomerID = @CustomerID

SELECT ma.CustomerID, sp.SalesPerson,
ma.LastReceived, ma.PIN, rb.ReferredBy, rb.StringID AS rbStringID,
ma.StartDate, CancelDate AS EndDate, cr.CancelReason, cr.StringID AS CancelReasonStringID, pt.PaymentType, pt.StringID AS ptStringID, r.Region, r.StringID AS rStringID, g.GroupName, o.Organization,
ma.Active, ma.PayPeriodID, pp.PayPeriod,
CASE WHEN ma.Active = 0 THEN 0 WHEN ma.CancelDate IS NOT NULL THEN 2 ELSE 1 END AS MBRStatus,
CASE WHEN ma.PaymentTypeID = 8 AND bc.AutoBill IN (0,1) AND ma.Active = 1 THEN 1 ELSE 0 END AS CCReq,
CASE WHEN cc.CardNumber IS NULL OR cc.ExpirationDate IS NULL THEN 0 WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN  2 ELSE 1 END AS CCStatus,
DATEPART(yyyy,cc.ExpirationDate) AS CCYear, DATEPART(mm,cc.ExpirationDate) AS CCMonth,
CASE WHEN ma.PaymentTypeID = 16 AND bc.AutoBill IN (0,1) AND ma.Active = 1 THEN 1 ELSE 0 END AS ACHReq,
CASE WHEN bt.ABANumber IS NULL OR bt.AccountNumber IS NULL THEN 0 ELSE 1 END AS ACHStatus,
ma.Comments, bc.BillingCycle, bc.StringID AS bcStringID, ma.TaxExemptions, sm.SendMethod, sm.StringID AS smStringID,
ma.CreateUser, ma.CreateDate, ma.PendingBalance AS CurrentBalance, ma.PendingBalance + COALESCE(@rhTotalCost,0) AS RealtimeBalance,
COALESCE(ma.CreditLimit,0) AS CreditLimit, COALESCE(ma.LastStatementID,0) As LastStatementID, ma.LastModifyUser, ma.LastModifyDate, st.EndBal, ma.TempExtension
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
	LEFT JOIN SalesPersons sp ON (ma.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Statements st ON (ma.LastStatementID = st.StatementID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRFileRequired (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT fc.FileCategoryID, fc.FileCategory
FROM FileCategories fc JOIN FileCategoryReqs fcr ON (fc.FileCategoryID = fcr.FileCategoryID)
	JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
	LEFT JOIN MasterAccountTags mat ON (fcr.MarketTagID = mat.MarketTagID AND mat.CustomerID = @CustomerID AND mat.Active = 1)
	LEFT JOIN Files f ON (fc.FileCategoryID = f.FileCategoryID AND f.CustomerID = @CustomerID AND f.Active = 1)
	LEFT JOIN AlertFileMasterAccounts afma ON (afma.CustomerID = @CustomerID AND fc.FileCategoryID = afma.FileCategoryID AND afma.AlertStateID > 1)
	WHERE fcr.FileApplyTypeID = 1
	AND (fcr.GroupID IS NULL OR fcr.GroupID = ma.GroupID)
	AND (fcr.MarketTagID IS NULL OR mat.CustomerID IS NOT NULL)
	AND f.FileID IS NULL
	AND afma.CustomerID IS NULL
GO

CREATE PROCEDURE dbo.MBRFileSec (@CustomerID INT, @FileID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS Cnt, FileCategoryID
FROM Files
	WHERE FileID = @FileID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.AdminFileSec (@SiteID INT, @TowerID INT, @EventID INT, @FileID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@SiteID IS NOT NULL)
BEGIN
SELECT 1 AS Cnt, FileCategoryID
FROM Files
	WHERE FileID = @FileID
	AND SiteID = @SiteID
END

IF (@TowerID IS NOT NULL)
BEGIN
SELECT 1 AS Cnt, FileCategoryID
FROM Files
	WHERE FileID = @FileID
	AND TowerID = @TowerID
END

IF (@EventID IS NOT NULL)
BEGIN
SELECT 1 AS Cnt, FileCategoryID
FROM Files
	WHERE FileID = @FileID
	AND EventID = @EventID
END
GO

CREATE PROCEDURE dbo.MBRGetCustomFields (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT COALESCE(madt.Required,0) AS Required, adt.RegExp, adt.StringID, adt.AccountDataType,adt.AccountDataTypeID,adt.DataTypeID
FROM MasterAccountDataTypes madt JOIN AccountDataTypes adt ON (madt.AccountDataTypeID = adt.AccountDataTypeID)
	WHERE adt.AllowMBR = 1
	AND (madt.GroupID IS NULL OR madt.GroupID = @GroupID OR madt.ServiceGroupID IN (SELECT ServiceGroupID FROM ServiceGroupItems WHERE GroupID = @GroupID))
ORDER BY madt.SortOrder, adt.AccountDataType
GO

CREATE PROCEDURE dbo.MBRGroupID (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.Active, ma.CustomerID, ma.GroupID, g.OrganizationID, a.FirstName, a.LastName, a.Company, bc.AutoBill,
CASE WHEN bc.AutoBill IN (0,1) AND ma.CancelDate IS NULL AND ma.Active = 1 THEN 1 END AS AllowClose,
CASE WHEN bc.AutoBill IN (0,1) AND (ma.CancelDate IS NOT NULL OR ma.Active = 0) THEN 1 END AS AllowOpen,
CASE WHEN bc.AutoBill IN (0,1) AND ma.PaymentTypeID IN (8,16) THEN 1 ELSE 0 END AS AutoPay
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active IN (1,0)
GO

CREATE PROCEDURE dbo.MBRIncidentSec (@CustomerID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT IncidentTypeID
FROM Incidents
	WHERE IncidentID = @IncidentID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRInvList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ii.InvItemID, ip.Title, ip.ModelNumber, is1.InvState, is1.StringID AS is1StringID, ic.InvCategory, ic.StringID AS icStringID, ii.SerialNumber, ist.Class, sa.Login, sa.AccountID, a.FirstName, a.LastName, at1.AccountType, ii.AssignDate, ii.AssignUser
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	JOIN InvCategories ic ON (ip.InvCategoryID = ic.InvCategoryID)
	JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ii.CustomerID = @CustomerID
ORDER BY is1.InvStateTypeID, ip.SortOrder, ip.Title
GO

CREATE PROCEDURE dbo.MBRInvoiceDetail (@InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT i.InvoiceID, i.ExtInvoiceNum, i.Comments, i.PO, i.Amount, i.CreateDate, i.LastModifyDate, i.LastModifyUser, i.StatementID, i.BatchID, i.PrintBatchID,
CASE WHEN i.Estimate = 1 THEN 1 WHEN i.Processed = 0 AND i.InvoiceTypeID = 91 THEN 1 ELSE 0 END AS Estimate,
i.Tax, it.InvoiceType, i.VoidDate, i.PrintDate, i.EmailDate, i.PayPlanID, pp.PayPlan, pp.StringID AS ppStringID, CASE WHEN i.PayPlanID IS NOT NULL THEN COALESCE(i.PayPlanStartDate,i.CreateDate) END AS PayPlanStartDate,
CASE WHEN i.VoidDate IS NULL AND i.InvoiceTypeID IN (91,92) AND i.Processed = 1 AND i.ChargeAmount > 0 AND i.PaidAmount < i.ChargeAmount THEN 1 END AS ShowPayPlan,
CASE WHEN i.VoidDate IS NULL THEN 0 ELSE 1 END AS Voided, i.ChargeAmount - i.PaidAmount AS Unpaid
FROM Invoices i JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE i.InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.MBRInvoiceItemDiscounts (@InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT iid.ItemID, d.Discount, d.StringID, iid.Amount
FROM InvoiceItems ii JOIN InvoiceItemDiscounts iid ON (ii.ItemID = iid.ItemID)
	JOIN Discounts d ON (iid.DiscountID = d.DiscountID)
	WHERE ii.InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.MBRInvoiceItems (@InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ii.ItemID, ii.AccountID, ii.Login, COALESCE(ii.Description,CASE WHEN vi.SerialNumber IS NOT NULL THEN ip.Title + ' (' + vi.SerialNumber + ')' ELSE ip.Title END,ct.ChargeType,at1.Description,t.Description) + CASE WHEN ii.ServiceQty > 1 THEN ' x ' + CAST(ii.ServiceQty AS VARCHAR(10)) ELSE '' END AS Description, ii.BaseAmount, ii.TaxableAmount, ii.Amount, ii.Quantity, ii.Amount * ii.Quantity AS Total, ii.PaidAmount, ii.StartDate, ii.EndDate,
COALESCE(glct.GLCode,glat.GLCode,glt.GLCode) AS GLCode, tg.TaxGroup, iit.InvoiceItemType, iit.StringID AS iitStringID, ii.BaseAmount - ii.Amount AS DiscountAmount, ii.LateCharge
FROM InvoiceItems ii LEFT JOIN TaxGroups tg ON (ii.TaxGroupID = tg.TaxGroupID)
	JOIN InvoiceItemTypes iit ON (ii.ItemType = iit.InvoiceItemTypeID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN InvItems vi ON (ii.InvItemID = vi.InvItemID)
	LEFT JOIN InvProducts ip ON (vi.InvProductID = ip.InvProductID)
	LEFT JOIN GLCodes glat ON (at1.GLCodeID = glat.GLCodeID)
	LEFT JOIN GLCodes glct ON (ct.GLCodeID = glct.GLCodeID)
	LEFT JOIN GLCodes glt ON (t.GLCodeID = glt.GLCodeID)
	WHERE ii.InvoiceID = @InvoiceID
ORDER BY ii.ItemType, ii.StartDate, ii.EndDate, ii.ItemID
GO

CREATE PROCEDURE dbo.MBRInvoiceList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT i.InvoiceID, CASE WHEN i.VoidDate IS NOT NULL THEN 'inactive' WHEN i.Estimate = 1 THEN 'estimate' WHEN i.ChargeAmount > i.PaidAmount THEN 'unpaid' WHEN i.Estimate = 0 AND i.Processed = 0 THEN 'bad' END AS Class,
it.InvoiceType, it.StringID AS itStringID, i.Amount, i.ChargeAmount, i.PaidAmount, i.CreateDate, i.PO, i.Comments, i.PrintDate, i.EmailDate, i.ExtInvoiceNum, pp.PayPlan, pp.StringID AS ppStringID,
CASE WHEN i.VoidDate IS NOT NULL THEN 0 WHEN i.Estimate=1 THEN 4 WHEN i.ChargeAmount=0 THEN 1 WHEN i.ChargeAmount <= i.PaidAmount THEN 2 ELSE 3 END AS Status
FROM Invoices i JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	LEFT JOIN PayPlans pp ON (i.PayPlanID = pp.PayPlanID)
	WHERE i.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRInvoiceSec (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS Cnt, Estimate, CASE WHEN VoidDate IS NOT NULL THEN 1 ELSE 0 END AS Void, Processed, CASE WHEN InvoiceTypeID = 91 AND Processed = 0 THEN 1 ELSE 0 END AS AllowEdit
FROM Invoices 
	WHERE InvoiceID = @InvoiceID 
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRMarketTagList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MarketTagID, mc.StringID AS mcStringID, mc.MarketCategory, mt.StringID AS mtStringID, mt.MarketTag,
CASE WHEN mat.CustomerID IS NULL THEN 0 ELSE 1 END AS HaveTag
FROM MarketTags mt LEFT JOIN MasterAccountTags mat ON (mat.CustomerID = @CustomerID AND mt.MarketTagID = mat.MarketTagID)
	JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
	WHERE mt.MarketTagAutoTypeID = 1
	AND (mat.CustomerID IS NOT NULL OR mt.Active = 1)
	AND (mt.GroupID IS NULL OR mt.GroupID = ma.GroupID OR EXISTS (SELECT * FROM ServiceGroupItems sgi WHERE sgi.ServiceGroupID = mt.ServiceGroupID AND sgi.GroupID = ma.GroupID))
ORDER BY mc.SortOrder, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.MBRMarketTags (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mat.MarketTagID, mat.CreateDate, mtat.AssignStringID, mtat.AssignType, CASE WHEN mat.Active = 0 OR mt.Active = 0 THEN 0 ELSE 1 END AS Active,
CASE WHEN mt.MarketTagAutoTypeID = 1 THEN mat.CreateUser END AS CreateUser, CASE WHEN mat.Active = 0 OR mt.Active = 0 THEN 'taginactive' WHEN mt.MarketTagAutoTypeID = 1 THEN 'tagmanual' WHEN mt.MarketTagAutoTypeID = 2 THEN 'tagauto' WHEN mt.MarketTagAutoTypeID = 3 THEN 'tagexternal' END AS Class,
mc.StringID AS mcStringID, mc.MarketCategory, mt.StringID AS mtStringID, mt.MarketTag, CASE WHEN mt.MarketTagAutoTypeID = 1 AND mt.AllowAccessTime = 1 THEN 1 ELSE 0 END AS AllowTime
FROM MasterAccountTags mat JOIN MarketTags mt ON (mat.MarketTagID = mt.MarketTagID)
	JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	JOIN MarketTagAutoTypes mtat ON (mt.MarketTagAutoTypeID = mtat.MarketTagAutoTypeID)
	WHERE mat.CustomerID = @CustomerID
	AND (mt.MarketTagAutoTypeID = 1 OR (mat.Active = 1 AND mt.Hidden = 0))
ORDER BY mt.MarketTagAutoTypeID, mc.SortOrder, mc.MarketCategory, mt.SortOrder, mt.MarketTag
GO

CREATE PROCEDURE dbo.MBROpenChkMax (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @MaxAccounts INT, @GroupID INT

SELECT @MaxAccounts = o.MaxAccounts, @GroupID = ma.GroupID
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE ma.CustomerID = @CustomerID

IF (@MaxAccounts IS NOT NULL)
BEGIN
SELECT @MaxAccounts - COUNT(*) AS CountLeft
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND ma.GroupID = @GroupID
	AND (bc.AutoBill IN (0,1) OR EXISTS ((SELECT * FROM SubAccounts sa
			LEFT JOIN (SELECT AccountID, SUM(TimeLeft) AS TimeLeft, SUM(DataLeft) AS DataLeft FROM SubAccountUsages WHERE ExpireDate > getdate() GROUP BY AccountID) sau ON (sa.AccountID = sau.AccountID)
			WHERE sa.CustomerID = ma.CustomerID
			AND sa.Active = 1 
			AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())
			AND (sa.TimeLeft IS NULL OR sa.TimeLeft + COALESCE(sau.TimeLeft,0) > 0)
			AND (sa.DataLeft IS NULL OR sa.DataLeft + COALESCE(sau.DataLeft,0) > 0))))
END ELSE BEGIN
SELECT NULL AS CountLeft
END
GO

CREATE PROCEDURE dbo.MBROpenList (@CustomerID INT) AS
SET NOCOUNT ON
SELECT sa.AccountID, ma.GroupID, CASE WHEN at1.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS AllowSetupCharge, CASE WHEN pp.SetupCharge = 1 THEN 1 ELSE 0 END AS DefaultSetupCharge
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND sa.Active = 1
GO

CREATE PROCEDURE dbo.MBRPaymentAlerts (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS AlertMapID, NULL AS Cnt, NULL AS Amount
FROM MasterAccounts
	WHERE CustomerID = @CustomerID
	AND PaymentTypeID IN (8,16)

UNION ALL

SELECT 2 AS AlertMapID, COUNT(*) AS Cnt, SUM(ChargeAmount - PaidAmount) AS Amount
FROM Invoices
	WHERE CustomerID = @CustomerID
	AND InvoiceTypeID IN (91,92)
	AND Processed = 1
	AND VoidDate IS NULL
	AND ChargeAmount > PaidAmount
HAVING COUNT(*) > 0

UNION ALL

SELECT CASE TransStateID WHEN 1 THEN 3 WHEN 0 THEN 4 WHEN 2 THEN 4 END AS AlertMapID, COUNT(*) AS Cnt, SUM(Amount) AS Amount
FROM ExternalTrans
	WHERE CustomerID = @CustomerID
	AND TransStateID IN (1,0,2)
GROUP BY CASE TransStateID WHEN 1 THEN 3 WHEN 0 THEN 4 WHEN 2 THEN 4 END

UNION ALL

SELECT 5 AS AlertMapID, COUNT(*) AS Cnt, SUM(Amount) AS Amount
FROM Payments
	WHERE CustomerID = @CustomerID
	AND CreateDate > DATEADD(mi,-15,getdate())
HAVING COUNT(*) > 0
GO

CREATE PROCEDURE dbo.CustPaymentCCDefault (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @addrtype INT
SELECT @addrtype = COALESCE(cgd.NumValue,c.NumValue,3)
FROM MasterAccounts ma JOIN Configs c ON (c.ConfigID = 533)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 533 AND cgd.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID

IF (@addrtype IN (1,2)) 
BEGIN
SELECT COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID) AS CountryID, 
COALESCE(cc.BillToStateID,a.StateID) AS StateID, 
COALESCE(cc.CardHolder,a.FirstName + ' ' + a.LastName) AS CardHolder, 
COALESCE(cc.BillToAddress1,a.Address1) AS BillToAddress1, 
COALESCE(cc.BillToZip,a.Zip) AS BillToZip,
COALESCE(cc.BillToCity,a.City) AS BillToCity,
DATEPART(yy,ExpirationDate) AS ExpireYear, CASE WHEN DATEPART(mm,ExpirationDate) < 10 THEN '0' + CAST(DATEPART(mm,ExpirationDate) AS VARCHAR(5)) ELSE CAST(DATEPART(mm,ExpirationDate) AS VARCHAR(5)) END AS ExpireMonth

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID AND @addrtype = 1)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	WHERE ma.CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.CustPaymentEFTDefault (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @addrtype INT
SELECT @addrtype = COALESCE(cgd.NumValue,c.NumValue,3)
FROM MasterAccounts ma JOIN Configs c ON (c.ConfigID = 533)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 533 AND cgd.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID

IF (@addrtype IN (1,2)) 
BEGIN
SELECT COALESCE(bt.AuthName,a.FirstName + ' ' + a.LastName) AS AuthName, bt.TransType
FROM MasterAccounts ma LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID AND @addrtype = 1)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	WHERE ma.CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.MBRPaymentCCDefault (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT COALESCE(cc.BillToCountryID,a.CountryID,g.BillCountryID) AS CountryID, COALESCE(cc.BillToStateID,a.StateID) AS StateID, cc.CardNumber, 
COALESCE(cc.CardHolder,a.FirstName + ' ' + a.LastName) AS CardHolder, COALESCE(cc.BillToAddress1,a.Address1) AS BillToAddress1, COALESCE(cc.BillToZip,a.Zip) AS BillToZip, COALESCE(cc.BillToCity,a.City) AS BillToCity,
DATEPART(yy,ExpirationDate) AS ExpireYear, CASE WHEN DATEPART(mm,ExpirationDate) < 10 THEN '0' + CAST(DATEPART(mm,ExpirationDate) AS VARCHAR(5)) ELSE CAST(DATEPART(mm,ExpirationDate) AS VARCHAR(5)) END AS ExpireMonth, cc.SecurityCode

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRPaymentDetail (@PaymentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @CommitAmount NUMERIC(18,4)

SELECT @CommitAmount = SUM(Amount)
FROM PaymentItems
	WHERE PaymentID = @PaymentID
	AND InactiveDate IS NULL

SELECT p.Amount, p.CreateDate AS CreateDate, p.CreateUser, p.EffectiveDate, pt.PaymentTypeID, pt.PaymentType, pt.StringID AS ptStringID, p.CheckNumber, p.PayInfo, p.FinalAmount, p.FinalCreateDate, p.LastModifyDate, p.LastModifyUser, p.ExternalRef, COALESCE(@CommitAmount,0) AS CommitAmount
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	WHERE p.PaymentID = @PaymentID
GO

CREATE PROCEDURE dbo.MBRPaymentDetailItems (@PaymentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT pi1.PaymentItemID, ii.InvoiceID, iit.InvoiceItemType, iit.StringID AS iitStringID, pi1.ActiveDate, pi1.Amount, ii.Login, COALESCE(ii.Description,ct.ChargeType,at1.Description,t.Description) AS Description, ROUND(ii.Amount * ii.Quantity,2) AS ItemAmount
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN InvoiceItemTypes iit ON (ii.ItemType = iit.InvoiceItemTypeID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	WHERE pi1.PaymentID = @PaymentID 
	AND pi1.InactiveDate IS NULL
GO

CREATE PROCEDURE dbo.MBRPaymentDetailTrans (@PaymentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT et.ExternalTransID, ts.TransState, ts.StringID AS tsStringID, tt.TransType, tt.StringID AS ttStringID, et.ReqDate, et.ProcDate, et.Amount, et.ApproveCode, et.Response, et.RebatchTries, et.LastRebatchTry, et.LastModifyUser, et.AutoBill, et.Token, et.AccountNumber, 
CASE et.TransStateID WHEN 1 THEN 'suspect' WHEN 3 THEN 'bad' WHEN 9 THEN 'inactive' END AS Class
FROM ExternalTrans et JOIN TransStates ts ON (et.TransStateID = ts.TransStateID)
	JOIN TransTypes tt ON (et.TransTypeID = tt.TransTypeID)
	WHERE et.PaymentID = @PaymentID
GO

CREATE PROCEDURE dbo.MBRPaymentList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT p.PaymentID, COALESCE(p.FinalAmount,p.Amount) AS Amount, COALESCE(p.EffectiveDate,p.CreateDate) AS CreateDate,
pt.PaymentType, pt.StringID AS ptStringID, p.CheckNumber, p.PayInfo, et.ApproveCode, CASE WHEN p.FinalAmount IS NULL THEN 0 ELSE 1 END AS HaveFinal, 
CASE WHEN COALESCE(p.FinalAmount,p.Amount) = 0 THEN 'inactive' WHEN p.FinalAmount IS NOT NULL THEN 'payfinal' WHEN et.AutoBill = 0 AND ma.PaymentTypeID IN (8,16) THEN 'transmanual' END AS Class, COALESCE(et.AutoBill,0) AS AutoBill

FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID AND et.TransStateID = 4 AND et.TransTypeID IN (32,64))
	WHERE p.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRPaymentPending (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT et.ExternalTransID, ts.TransStateID, ts.TransState, ts.StringID AS tsStringID, tt.TransType, tt.StringID AS ttStringID, et.ReqDate, bp.BatchProcessor, et.Amount, et.AutoBill, et.Response,
CASE WHEN  et.TransStateID = 3 THEN 'bad' WHEN et.TransStateID = 1 THEN 'suspect' WHEN et.AutoBill = 0 THEN 'transmanual' END AS Class
FROM ExternalTrans et JOIN TransTypes tt ON (et.TransTypeID = tt.TransTypeID)
	JOIN TransStates ts ON (et.TransStateID = ts.TransStateID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	WHERE et.CustomerID = @CustomerID
	AND et.TransStateID NOT IN (4,8,9)
GO

CREATE PROCEDURE dbo.MBRPaymentSec (@CustomerID INT, @PaymentID INT, @AllowDishonorCC SMALLINT, @AllowDishonorEFT SMALLINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @voidwin INT
SELECT @voidwin = COALESCE(MAX(NumValue),3) FROM Configs WHERE ConfigID = 701

SELECT 1 AS Cnt, CASE 
WHEN FinalAmount IS NOT NULL THEN 0 
WHEN PaymentTypeID = 8 AND @AllowDishonorCC = 0 THEN 0
WHEN PaymentTypeID = 16 AND @AllowDishonorEFT = 0 THEN 0
WHEN PaymentTypeID = 32 THEN 0
ELSE 1 END AS AllowDishonor,
CASE WHEN PaymentTypeID IN (8,16) AND FinalAmount IS NULL AND CreateDate < DATEADD(hh,-@voidwin,getdate()) THEN 1 ELSE 0 END AS AllowCredit, 
CASE WHEN PaymentTypeID NOT IN (8,16,32) AND (FinalAmount IS NULL OR (FinalStatementID IS NULL AND DATEPART(yy,FinalCreateDate) = DATEPART(yy,getdate()) AND DATEPART(mm,FinalCreateDate) = DATEPART(mm,getdate()) AND DATEPART(dd,FinalCreateDate) = DATEPART(dd,getdate()))) THEN 1 ELSE 0 END AS AllowEdit,
CASE WHEN PaymentTypeID IN (8,16) AND CreateDate > DATEADD(hh,-@voidwin,getdate()) AND FinalAmount IS NULL THEN 1 ELSE 0 END AS AllowVoid
FROM Payments
	WHERE PaymentID = @PaymentID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRPaymentStatus (@PaymentID INT) AS
SET NOCOUNT ON
SELECT p.PayInfo, p.Amount, p.PaymentTypeID, pt.PaymentType, pt.StringID, 
CASE WHEN p.PaymentTypeID NOT IN (8,16) THEN 1
	WHEN p.FinalAmount IS NOT NULL THEN 2
	WHEN (et.AccountNumber IS NULL AND et.Token IS NULL) THEN 3
	WHEN e.ExportID IS NULL THEN 4
	ELSE 0 END AS CreditStatus,
CASE WHEN (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate()) AND bc.AutoBill IN (0,1) AND ma.PaymentTypeID IN (8,6) AND ma.PendingBalance + p.Amount > 0 THEN 1 ELSE 0 END AutoPayWarn,
CASE WHEN p.PaymentTypeID = 32 THEN 1 WHEN p.FinalAmount IS NOT NULL THEN 2 ELSE 0 END AS DishonorStatus
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID=pt.PaymentTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID AND et.TransStateID = 4 AND et.ProcTransID IS NOT NULL AND et.ProcTransID = p.ProcTransID)
	LEFT JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN Exports e ON (bp.ExportID = e.ExportID AND e.Features & 8 = 8)
	WHERE p.PaymentID = @PaymentID
GO

CREATE PROCEDURE dbo.MBRPosDetail (@InvoiceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT MIN(i.CreateDate) AS CreateDate, MIN(i.Estimate) AS Estimate, MIN(i.PO) AS PO, MIN(i.Comments) AS Comments,
COALESCE(SUM(ROUND(ii.Amount * ii.Quantity,2)),0) AS TotalAmount, 
COALESCE(SUM(ROUND(CASE WHEN ii.Amount > 0 THEN ii.Amount ELSE 0.0 END * ii.Quantity,2)),0) AS ChargeAmount,
MAX(CASE WHEN ii.InvItemID IS NOT NULL THEN 1 ELSE 0 END) AS HaveInv
FROM Invoices i LEFT JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.VoidDate IS NULL
	AND i.Processed = 0
	AND i.InvoiceTypeID IN (91,92)
GO

CREATE PROCEDURE dbo.MBRPosInvDetail (@InvoiceID INT, @InvItemID INT) AS
SET NOCOUNT ON
SELECT ii.InvItemID, ip.ChargeTypeID, ct.TaxGroupID, COALESCE(ii.Cost,ip.Cost,ct.Amount,0) AS Cost
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN Invoices i ON (i.InvoiceID = @InvoiceID)
	LEFT JOIN ChargeTypes ct ON (ip.ChargeTypeID = ct.ChargeTypeID)
	WHERE ii.InvItemID = @InvItemID
	AND is1.InvStateTypeID = 1
	AND i.Processed = 0
	AND i.VoidDate IS NULL
GO

CREATE PROCEDURE dbo.MBRPosInvReserve (@ItemID INT, @InvStateID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @curInvStateID INT, @InvItemID INT

SELECT @curInvStateID = iv.InvStateID, @InvItemID = ii.InvItemID
FROM InvoiceItems ii JOIN InvItems iv ON (ii.InvItemID = iv.InvItemID)
	JOIN InvProducts ip ON (iv.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (iv.InvStateID = is1.InvStateID)
	JOIN InvSources src ON (ip.InvSourceID = src.InvSourceID)
	JOIN InvStates is2 ON (src.InvStateGroupID = is2.InvStateGroupID AND is2.InvStateID = @InvStateID)
	WHERE ii.ItemID = @ItemID
	AND is1.InvStateTypeID = 1

IF (@curInvStateID IS NOT NULL)
BEGIN
UPDATE InvItems SET InvStateID = @InvStateID, ItemID = @ItemID, AssignDate = getdate(), AssignUser = @Operator
	WHERE InvItemID = @InvItemID
	AND InvStateID = @curInvStateID

SELECT @@ROWCOUNT AS Reserved
END ELSE BEGIN
SELECT 0 AS Reserved
END
GO

CREATE PROCEDURE dbo.MBRPosItems (@InvoiceID INT) AS
SET NOCOUNT ON
SELECT ii.ItemID, ii.Description, ii.Amount, ii.Quantity, ct.ChargeType, ct.StringID AS ctStringID, tc.TimeCharge, tc.StringID AS tcStringID, sa.Login, at1.AccountType, at1.StringID AS at1StringID,
a.FirstName, a.LastName, vi.SerialNumber, ip.Title, tg.TaxGroup, ii.InvItemID, ip.InvSourceID, CASE WHEN is1.InvStateTypeID IN (2,3,4) THEN 'bad' END AS Class,
CASE WHEN vi.Cost IS NOT NULL THEN 1 ELSE 0 END AS LockAmount, CASE WHEN ii.InvItemID IS NOT NULL THEN 1 ELSE 0 END AS LockQty, isg.POSInvStateID
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN InvItems vi ON (ii.InvItemID = vi.InvItemID)
	LEFT JOIN InvStates is1 ON (vi.InvStateID = is1.InvStateID)
	LEFT JOIN InvStateGroups isg ON (is1.InvStateGroupID = isg.InvStateGroupID)
	LEFT JOIN InvProducts ip ON (vi.InvProductID = ip.InvProductID)
	LEFT JOIN TaxGroups tg ON (ii.TaxGroupID = tg.TaxGroupID)
	LEFT JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID AND tc.ChargeTypeID = ii.ChargeTypeID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.Processed = 0
	AND i.InvoiceTypeID IN (91,92)
GO

CREATE PROCEDURE dbo.MBRSalesInfo (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS AlertMapID, NULL AS Cnt, NULL AS AccountID, pc.PromoCode AS Message, pc.StringID
FROM MasterAccountPromoCodes mapc JOIN PromoCodes pc ON (mapc.PromoCodeID = pc.PromoCodeID)
	WHERE mapc.CustomerID = @CustomerID
	AND pc.Active = 1

UNION ALL

SELECT DISTINCT 2 AS AlertMapID, NULL AS Cnt, rsa.AccountID, CASE WHEN ra.Company IS NOT NULL THEN ra.Company ELSE ra.FirstName + ' ' + ra.LastName END AS Message, NULL AS StringID
FROM SubAccounts sa JOIN SubAccounts rsa ON (sa.RefAccountID = rsa.AccountID)
	JOIN Addresses ra ON (rsa.ContactAddressID = ra.AddressID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1

UNION ALL

SELECT 3 AS AlertMapID, COUNT(*) AS Cnt, NULL AS AccountID, MIN(rm.RefManager) AS Message, NULL AS StringID
FROM SubAccounts sa JOIN RefStates rs ON (sa.AccountID = rs.SrcAccountID)
	JOIN RefManagers rm ON (rs.RefManagerID = rm.RefManagerID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
	AND rm.Active = 1
GROUP BY rm.RefManagerID

UNION ALL

SELECT 4 AS AlertMapID, COUNT(*) AS Cnt, NULL AS AccountID, MIN(COALESCE(sp.SalesPerson,'None')) AS Message, NULL AS StringID
FROM SubAccounts sa LEFT JOIN SalesPersons sp ON (sa.SalesPersonID = sp.SalesPersonID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active = 1
GROUP BY sa.SalesPersonID

UNION ALL

SELECT 5 AS AlertMapID, NULL AS Cnt, NULL AS AccountID, mt.MarketTag AS Message, mt.StringID
FROM MasterAccountTags mat JOIN MarketTags mt ON (mat.MarketTagID = mt.MarketTagID)
	WHERE mat.CustomerID = @CustomerID
	AND mat.Active = 1
	AND mt.MarketTagAutoTypeID = 1
GO

CREATE PROCEDURE dbo.MBRStatementDetail (@StatementID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT StatementID, StatementDate, DueDate, PrevBal, NewCharges, NewCredits, EndBal, End0Bal, End30Bal, End60Bal, End90Bal, End120Bal, PrintDate, EmailDate, BatchID, PrintBatchID
FROM Statements
	WHERE StatementID = @StatementID
GO

CREATE PROCEDURE dbo.MBRStatementItems (@StatementID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 0 AS IsPay, i.InvoiceID AS IsID, ii.Login, COALESCE(ii.Description,CASE WHEN vi.SerialNumber IS NOT NULL THEN ip.Title + ' (' + vi.SerialNumber + ')' ELSE ip.Title END,ct.ChargeType,at1.Description,t.Description) + CASE WHEN ii.ServiceQty > 1 THEN ' x ' + CAST(ii.ServiceQty AS VARCHAR(10)) ELSE '' END AS Description, CASE WHEN ii.Amount * ii.Quantity < 0 THEN ROUND(ii.Amount * ii.Quantity,2) END AS Credit, 
CASE WHEN ii.Amount * ii.Quantity >= 0 THEN ROUND(ii.Amount * ii.Quantity,2) END AS Charge, ii.StartDate, CASE WHEN ii.StartDate = ii.EndDate THEN NULL ELSE ii.EndDate END AS EndDate,
COALESCE(glct.GLCode,glat.GLCode,glt.GLCode) AS GLCode, CASE WHEN i.StatementID = i.VoidStatementID THEN 'inactive' WHEN i.StatementID IS NOT NULL AND i.VoidStatementID IS NOT NULL AND i.StatementID <> i.VoidStatementID THEN 'suspect' END AS Class
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN InvItems vi ON (ii.InvItemID = vi.InvItemID)
	LEFT JOIN InvProducts ip ON (vi.InvProductID = ip.InvProductID)
	LEFT JOIN GLCodes glat ON (at1.GLCodeID = glat.GLCodeID)
	LEFT JOIN GLCodes glct ON (ct.GLCodeID = glct.GLCodeID)
	LEFT JOIN GLCodes glt ON (t.GLCodeID = glt.GLCodeID)
	WHERE (i.StatementID = @StatementID OR i.VoidStatementID = @StatementID)

UNION ALL

SELECT 1 AS IsPay, p.PaymentID AS IsID, NULL AS Login, pt.PaymentType AS Description, CASE WHEN p.StatementID = p.FinalStatementID THEN p.FinalAmount WHEN p.FinalStatementID = @StatementID THEN COALESCE(p.FinalAmount,0) - p.Amount ELSE p.Amount END AS Credit,
NULL AS Charge, p.CreateDate AS StartDate, NULL AS EndDate,
gl.GLCode, CASE WHEN (p.StatementID = p.FinalStatementID AND p.FinalAmount = 0) OR (p.FinalAmount IS NULL AND p.Amount = 0) THEN 'inactive' END AS Class
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	WHERE (p.StatementID = @StatementID OR p.FinalStatementID = @StatementID)
GO

CREATE PROCEDURE dbo.MBRStatementList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT StatementID, StatementDate, DueDate, PrevBal, EndBal, NewCharges, NewCredits, PrintDate, EmailDate, LateCharge
FROM Statements
	WHERE CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRStatementSec (@CustomerID INT, @StatementID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT COUNT(*) AS Cnt 
FROM Statements 
	WHERE StatementID = @StatementID
	AND CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRSubAccountList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT sa.AccountID, sa.Login, a.FirstName, a.LastName, at1.AccountType, CASE WHEN sa.Active = 0 THEN 'inactive' END AS Class
FROM SubAccounts sa LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.Active IN (1,0)
ORDER BY sa.Active DESC, at1.SortOrder, at1.AccountType, sa.Login, a.FirstName
GO

CREATE PROCEDURE dbo.MDFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE WHEN sa.Email LIKE '%@%' THEN sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain END
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.Password <> ' '
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.MDGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid,
a.FirstName + ' ' + a.LastName AS cn,
a.FirstName + ' ' + a.LastName AS mdFullName,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mdForwardAddress,
'N' AS mdKeepForwardedMail,
CASE WHEN fw.Forward IS NULL THEN 'N' ELSE 'Y' END AS mdIsForwarding,
es.MailHost AS mailHost,
sa.Password AS mdPassword,

CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 'N' ELSE
	CASE WHEN ma.CreditLimit > 0 AND ma.CreditLimit > ma.PendingBalance THEN 'N'
	WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 'N'
	ELSE 'Y' END
END AS mdAllowAccess,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,
es.LogFile + '/' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mdMailDir, 
ab.Address1 AS mdHomeAddress,
ab.City AS mdHomeCity,
s.State AS mdHomeState,
ab.Zip AS mdHomeZipcode,
c.Country AS mdHomeCountry,
ab.PhoneHome AS mdHomePhone,
ab.PhoneFax AS mdHomeFax,
ab.Company AS mdBusCompany,
ab.PhoneWork AS mdBusPhone

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses ab ON (ma.BillingAddressID = ab.AddressID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN States s ON (ab.StateID = s.StateID)
	LEFT JOIN Countries c ON (ab.CountryID = c.CountryID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifyDate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.MapGetAttributes AS
SELECT MapAttribute, RadAttributeID,RadVendorID,RadMapTypeID
FROM RadMapAttributes
GO

CREATE PROCEDURE dbo.MapGetValues AS
SELECT MapAttribute,MapValue,RadValue,RadMapTypeID
FROM RadMapValues
ORDER BY MapAttribute,RadMapTypeID
GO

CREATE PROCEDURE dbo.MarketAddMBRTag (@CustomerID INT, @MarketTagID INT) AS
SET NOCOUNT ON
INSERT INTO MasterAccountTags (CustomerID,MarketTagID,CreateUser,CreateDate) VALUES(@CustomerID,@MarketTagID,'GBE',getdate())
GO

CREATE PROCEDURE dbo.MarketAddSATag (@AccountID INT, @MarketTagID INT) AS
SET NOCOUNT ON
INSERT INTO SubAccountTags (AccountID,MarketTagID,CreateUser,CreateDate,InvoicedDays) VALUES(@AccountID,@MarketTagID,NULL,getdate(),0)
GO

CREATE PROCEDURE dbo.MarketGetAT AS
SET NOCOUNT ON

SELECT AccountTypeID, ServiceLevelTypeID, SecServiceLevelTypeID, ProrateOpen, ProrateOpenTemp, ProrateClose, ProrateCloseTemp, Cost, Description, StringID, TaxGroupID, TaxExemptions
FROM AccountTypes
GO

CREATE PROCEDURE dbo.MarketGetAddressData (@CustomerID INT) AS
SET NOCOUNT ON

SELECT ad.AddressID, ad.AddressDataTypeID, ad.Data
FROM AddressData ad JOIN Addresses a ON (ad.AddressID = a.AddressID)
	WHERE a.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MarketGetConditions AS
SET NOCOUNT ON
SELECT mtc.SrcMarketTagID,mtc.MarketTagCondTypeID,mtc.DstMarketTagID,mtc.DstMarketTagGroupID 
FROM MarketTagConditions mtc
	WHERE (mtc.DstMarketTagID IS NOT NULL OR mtc.DstMarketTagGroupID IS NOT NULL)
	AND (mtc.DstMarketTagGroupID IS NULL OR EXISTS (SELECT * FROM MarketTagGroupItems mtgi WHERE mtgi.MarketTagGroupID = mtc.DstMarketTagGroupID))
GO

CREATE PROCEDURE dbo.MarketGetDiscount AS
SET NOCOUNT ON
SELECT d.DiscountID, d.Amount, d.AmountType, d.ChargeTypeID, ct.TaxGroupID, ct.TaxExemptions
FROM Discounts d LEFT JOIN ChargeTypes ct ON (d.ChargeTypeID = ct.ChargeTypeID)
GO

CREATE PROCEDURE dbo.MarketGetGroups AS
SET NOCOUNT ON
SELECT MarketTagGroupID,MarketTagID
FROM MarketTagGroupItems
GO

CREATE PROCEDURE dbo.MarketGetMBR (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.CustomerID, ma.GroupID, ma.RegionID, ma.PaymentTypeID, ma.SendMethodID,ma.BillingCycleID,
b.AddressID AS bAddressID, b.CountryID AS bCountryID, b.StateID AS bStateID, b.City AS bCity, b.Zip AS bZip,
s.AddressID AS sAddressID, s.CountryID AS sCountryID, s.StateID AS sStateID, s.City AS sCity, s.Zip AS sZip,
e.AddressID AS eAddressID, e.CountryID AS eCountryID, e.StateID AS eStateID, e.City AS eCity, e.Zip AS eZip
FROM MasterAccounts ma LEFT JOIN Addresses b ON (ma.BillingAddressID = b.AddressID)
	LEFT JOIN Addresses s ON (ma.ShippingAddressID = s.AddressID)
	LEFT JOIN Addresses e ON (ma.ServiceAddressID = e.AddressID)
	WHERE ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MarketGetMBRTags (@CustomerID INT) AS
SET NOCOUNT ON

SELECT mat.CustomerID, mat.MarketTagID, mat.Active, att.StartDate, att.EndDate, att.AccessTime
FROM MasterAccountTags mat JOIN MarketTags mt ON (mat.MarketTagID = mt.MarketTagID)
	LEFT JOIN AccountTagTimes att ON (mat.CustomerID = att.CustomerID AND mat.MarketTagID = att.MarketTagID)
	WHERE mt.MarketTagAutoTypeID IN (1,2,3)
	AND mat.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MarketGetOrgAT AS
SET NOCOUNT ON
SELECT oat.OrganizationID,oat.AccountTypeID,oat.ResellerCost,oat.CustomerCost 
FROM OrgAccountTypes oat JOIN Organizations o ON (oat.OrganizationID = o.OrganizationID)
	WHERE o.ResellerCustomerID IS NOT NULL
GO

CREATE PROCEDURE dbo.MarketGetPromoCodes (@CustomerID INT) AS
SET NOCOUNT ON
SELECT CustomerID, PromoCodeID 
FROM MasterAccountPromoCodes 
	WHERE CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MarketGetSA (@CustomerID INT, @RetroDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@RetroDate IS NULL)
BEGIN
SELECT sa.CustomerID, sa.AccountID, sa.ParentAccountID, sa.AccountTypeID, sa.ServiceCategoryID, psa.ServiceCategoryID AS ParentServiceCategoryID, sa.PayPeriodID, a.AddressID, a.CountryID, a.StateID, a.City, a.Zip, sa.BilledThru, sa.InvoicedDays, sa.ServiceQty, sa.CreateDate
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	LEFT JOIN SubAccounts psa ON (sa.ParentAccountID = psa.AccountID)
	WHERE sa.Active = 1
	AND sa.CustomerID = @CustomerID
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
ORDER BY sa.AccountID DESC

END ELSE BEGIN

SELECT sa.CustomerID, sa.AccountID, sa.ParentAccountID, sa.AccountTypeID, sa.ServiceCategoryID, psa.ServiceCategoryID AS ParentServiceCategoryID, sa.PayPeriodID, a.AddressID, a.CountryID, a.StateID, a.City, a.Zip, COALESCE(DATEADD(dd,-1,rd.StartDate),sa.BilledThru) AS BilledThru, sa.InvoicedDays, sa.ServiceQty, sa.CreateDate
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	LEFT JOIN SubAccounts psa ON (sa.ParentAccountID = psa.AccountID)
	LEFT JOIN
		(
		SELECT ii.AccountID, MIN(ii.StartDate) AS StartDate
		FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
			JOIN InvoiceItems iir ON (i.InvoiceID = iir.InvoiceID)
			WHERE i.CustomerID = @CustomerID
			AND i.VoidDate IS NULL
			AND i.Processed = 1
			AND ii.ItemType = 3
			AND iir.ItemType = 3
			AND iir.EndDate >= @RetroDate
		GROUP BY ii.AccountID
		) rd ON (sa.AccountID = rd.AccountID)
	WHERE sa.Active = 1
	AND sa.CustomerID = @CustomerID
	AND sa.Recurring = 1
	AND bc.AutoBill IN (0,1)
ORDER BY sa.AccountID DESC
END
GO

CREATE PROCEDURE dbo.MarketGetSATags (@CustomerID INT, @RetroDate DATETIME) AS
SET NOCOUNT ON

IF (@RetroDate IS NULL)
BEGIN
SELECT sat.AccountID, sat.MarketTagID, sat.Active, sat.Cost, sat.CostAccountTypeID, sat.InvoicedDays, sat.InvoicedDaysMax, sat.CancelItemID, att.StartDate, att.EndDate, att.AccessTime
FROM SubAccounts sa JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID)
	JOIN MarketTags mt ON (sat.MarketTagID = mt.MarketTagID)
	LEFT JOIN AccountTagTimes att ON (sat.AccountID = att.AccountID AND sat.MarketTagID = att.MarketTagID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
	AND sa.CustomerID = @CustomerID

END ELSE BEGIN

SELECT sat.AccountID, sat.MarketTagID, sat.Active, sat.Cost, sat.CostAccountTypeID, COALESCE(rd.InvoicedDays,sat.InvoicedDays) AS InvoicedDays, sat.InvoicedDaysMax, sat.CancelItemID, att.StartDate, att.EndDate, att.AccessTime
FROM SubAccounts sa JOIN SubAccountTags sat ON (sa.AccountID = sat.AccountID)
	JOIN MarketTags mt ON (sat.MarketTagID = mt.MarketTagID)
	LEFT JOIN AccountTagTimes att ON (sat.AccountID = att.AccountID AND sat.MarketTagID = att.MarketTagID)
	LEFT JOIN (SELECT it.AccountID, it.MarketTagID, MIN(it.InvoicedDays) AS InvoicedDays
		FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
			JOIN InvoiceTags it ON (i.InvoiceID = it.InvoiceID AND ii.AccountID = it.AccountID)
			WHERE i.CustomerID = @CustomerID
			AND i.VoidDate IS NULL
			AND i.Processed = 1
			AND @RetroDate IS NOT NULL
			AND ii.EndDate >= @RetroDate
		GROUP BY it.AccountID, it.MarketTagID) rd ON (sa.AccountID = rd.AccountID AND sat.MarketTagID = rd.MarketTagID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
	AND sa.CustomerID = @CustomerID
END
GO

CREATE PROCEDURE dbo.MarketGetServiceGroups AS
SET NOCOUNT ON
SELECT DISTINCT sgi.ServiceGroupID, sgi.GroupID
FROM ServiceGroupItems sgi JOIN MarketTags mt ON (sgi.ServiceGroupID = mt.ServiceGroupID)
GO

CREATE PROCEDURE dbo.MarketGetServices (@GroupID INT, @CustomerID INT) AS
SET NOCOUNT ON
IF (@CustomerID IS NOT NULL)
BEGIN
SELECT CustomerID
FROM MasterAccounts
	WHERE Active = 1
	AND CustomerID = @CustomerID
END ELSE BEGIN
SELECT CustomerID
FROM MasterAccounts
	WHERE Active = 1
	AND (@GroupID IS NULL OR GroupID = @GroupID)
END
GO

CREATE PROCEDURE dbo.MarketGetTags AS
SET NOCOUNT ON
CREATE TABLE #mgtref (SeqID INT IDENTITY, SortOrder SMALLINT, ParentServiceCategoryID INT,ServiceCategoryID INT,AccountTypeID INT, ServiceCountMin INT, ServiceCountMax INT, Cost NUMERIC(18,4), StartDate DATETIME)

INSERT INTO #mgtref (SortOrder, ParentServiceCategoryID, ServiceCategoryID, AccountTypeID, ServiceCountMin, ServiceCountMax, Cost)
SELECT 1, ParentServiceCategoryID, ServiceCategoryID, AccountTypeID, 0, MaxQty1, Cost1
FROM ServiceCatParentAccountTypes
	WHERE Cost1 IS NOT NULL
UNION ALL
SELECT 2, ParentServiceCategoryID, ServiceCategoryID, AccountTypeID, MaxQty1+1, MaxQty2, Cost2
FROM ServiceCatParentAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND (MaxQty2 IS NULL OR MaxQty2 > MaxQty1)
UNION ALL
SELECT 3, ParentServiceCategoryID, ServiceCategoryID, AccountTypeID, MaxQty2+1, MaxQty3, Cost3
FROM ServiceCatParentAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND MaxQty2 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND Cost3 IS NOT NULL
	AND (MaxQty3 IS NULL OR MaxQty3 > MaxQty2)
UNION ALL
SELECT 4, ParentServiceCategoryID, ServiceCategoryID, AccountTypeID, MaxQty3+1, MaxQty4, Cost4
FROM ServiceCatParentAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND MaxQty2 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND MaxQty3 IS NOT NULL
	AND Cost3 IS NOT NULL
	AND Cost4 IS NOT NULL
	AND (MaxQty4 IS NULL OR MaxQty4 > MaxQty3)
UNION ALL
SELECT 5, NULL, ServiceCategoryID, AccountTypeID, 0, MaxQty1, Cost1
FROM ServiceCatAccountTypes
	WHERE Cost1 IS NOT NULL
UNION ALL
SELECT 6, NULL, ServiceCategoryID, AccountTypeID, MaxQty1+1, MaxQty2, Cost2
FROM ServiceCatAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND (MaxQty2 IS NULL OR MaxQty2 > MaxQty1)
UNION ALL
SELECT 7, NULL, ServiceCategoryID, AccountTypeID, MaxQty2+1, MaxQty3, Cost3
FROM ServiceCatAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND MaxQty2 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND Cost3 IS NOT NULL
	AND (MaxQty3 IS NULL OR MaxQty3 > MaxQty2)
UNION ALL
SELECT 8, NULL, ServiceCategoryID, AccountTypeID, MaxQty3+1, MaxQty4, Cost4
FROM ServiceCatAccountTypes
	WHERE MaxQty1 IS NOT NULL
	AND Cost1 IS NOT NULL
	AND MaxQty2 IS NOT NULL
	AND Cost2 IS NOT NULL
	AND MaxQty3 IS NOT NULL
	AND Cost3 IS NOT NULL
	AND Cost4 IS NOT NULL
	AND (MaxQty4 IS NULL OR MaxQty4 > MaxQty3)

INSERT INTO #mgtref (SortOrder,AccountTypeID,Cost,StartDate)
SELECT 9, AccountTypeID, NewCost, NewCostDate
FROM AccountTypes
	WHERE NewCost IS NOT NULL
	AND NewCostDate IS NOT NULL

SELECT 1,mt.SortOrder,mt.MarketTagID,mt.MarketTag,mt.MarketTagAutoTypeID,mt.GroupID,mt.ServiceGroupID,mt.RegionID,mt.PaymentTypeID,mt.SendMethodID,mt.BillingCycleID,mt.AddressCategoryID,mt.CountryID,
mt.StateID,mt.City,mt.Zip,mt.AddressDataTypeID,mt.AddressData,mt.ServiceLevelTypeID,mt.AccountTypeID,mt.ServiceCategoryID,mt.ParentServiceCategoryID,mt.PromoCodeID,mt.ChargeTypeID,mt.PayPeriodID,
mt.CancelPeriodMonthsMin,mt.StartDate,mt.EndDate,mt.AccessTime,mt.InvoicedDaysMax,mt.ServiceMonthsMin,mt.ServiceMonthsMax,
mt.MarketServiceCountTypeID,mt.ServiceCountTotalMin,mt.ServiceCountTotalMax,mt.ServiceCountMin,mt.ServiceCountMax,mt.Cost,
mt.AllowAccessTime,mt.AllowServiceCost,mt.AllowInvoicedDaysMax,mt.DiscountID,mt.CancelChargeInvoicedMonths,
mt.CancelChargeTypeID,mt.MarketTagCancelTypeID, ct.TaxGroupID AS CancelTaxGroupID, ct.TaxExemptions AS CancelTaxExemptions, ct.Amount AS CancelAmount,
mt.CreatedBefore,mt.CreatedAfter
FROM MarketTags mt LEFT JOIN ChargeTypes ct ON (mt.CancelChargeTypeID = ct.ChargeTypeID)
	WHERE mt.Active = 1
UNION ALL
SELECT 2,SortOrder,-(SeqID) AS MarketTagID,NULL AS MarketTag,5 AS MarketTagAutoTypeID,NULL AS GroupID,NULL AS ServiceGroupID,NULL AS Region,NULL AS PaymentTypeID, NULL AS SendMethodID, NULL AS BillingCycleID,NULL AS AddressCategoryID,NULL AS CountryID,
NULL AS StateID,NULL AS City,NULL AS Zip,NULL AS AddressDataTypeID,NULL AS AddressData,NULL AS ServiceLevelTypeID,AccountTypeID,ServiceCategoryID,ParentServiceCategoryID,NULL AS PromoCodeID,NULL AS ChargeTypeID,NULL AS PayPeriodID,
NULL AS CancelPeriodMonthsMin,StartDate,NULL AS EndDate,NULL AS AccessTime,NULL AS InvoicedDaysMax,NULL AS ServiceMonthsMin,NULL AS ServiceMonthsMax,
2 AS MarketServiceCountTypeID,NULL AS ServiceCountTotalMin,NULL AS ServiceCountTotalMax,ServiceCountMin,ServiceCountMax,Cost,
0 AS AllowAccessTime,0 AS AllowServiceCost,0 AS AllowInvoicedDaysMax,NULL AS DiscountID,NULL AS CancelChargeInvoicedMonths,
NULL AS CancelChargeTypeID,NULL AS MarketTagCancelTypeID, NULL AS CancelTaxGroupID, NULL AS CancelTaxExemptions, NULL AS CancelAmount,
NULL AS CreatedBefore, NULL AS CreatedAfter
FROM #mgtref
ORDER BY 1 ASC, 2 ASC, 3
GO

CREATE PROCEDURE dbo.MenuList (@Menu VARCHAR(128)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi.LabelName, mi.SectionObject, mi.Access, mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu = @Menu
ORDER BY ms.SortOrder ASC, mi.Label
GO

CREATE PROCEDURE dbo.MenuListAT (@Menu VARCHAR(128), @AccountTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ms.SortOrder, mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi.Access, mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class, mi.SectionObject
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu = @Menu
UNION ALL
SELECT 0, NULL, NULL, act.CustEdit, 'read', NULL, NULL, 'svctemplate', act.CustEditLabel, act.CustEditStringID, NULL, act.CustEdit, NULL, m.Class, NULL
FROM AccountTypes at1 JOIN AccountTypeTemplates att ON (at1.AccountTypeID = att.AccountTypeID)
	JOIN AccountTemplates act ON (att.AccountTemplateID = act.AccountTemplateID)
	CROSS JOIN Menus m
	WHERE at1.AccountTypeID = @AccountTypeID
	AND act.CustEdit IS NOT NULL
	AND m.Menu = @Menu
	AND @Menu = 'custsaset'
UNION ALL
SELECT 0, NULL, NULL, act.SADetail, 'read', NULL, NULL, 'svctemplate', act.AccountTemplate, NULL, NULL, act.SADetail, NULL, m.Class, NULL
FROM AccountTypes at1 JOIN AccountTypeTemplates att ON (at1.AccountTypeID = att.AccountTypeID)
	JOIN AccountTemplates act ON (att.AccountTemplateID = act.AccountTemplateID)
	CROSS JOIN Menus m
	WHERE at1.AccountTypeID = @AccountTypeID
	AND act.SADetail IS NOT NULL
	AND m.Menu = @Menu
	AND @Menu = 'sadetail'
ORDER BY 1 ASC
GO

CREATE PROCEDURE dbo.MenuListSearch (@Menu VARCHAR(128), @OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi.LabelName, mi.SectionObject, mi.Access, mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class, 1 AS SortOrder, ms.SortOrder AS SortOrder2
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu = @Menu

UNION ALL

SELECT NULL AS MetaTableID, NULL AS MetaColumnID, 'search_searches_form.ews' AS FileName, NULL AS LabelName, NULL AS SectionObject, 'read' AS Access, NULL AS Condition, NULL AS FeatureID, 'searchsearches' AS Label, s.Search AS Description, NULL AS DescStringID, NULL AS AccessKey, 'search_searches_form.ews?SearchID=' + CAST(s.SearchID AS VARCHAR) AS Link, NULL AS Attribute, 'menu_search' AS Class, 2 AS SortOrder, s.SortOrder AS SortOrder2
FROM Searches s
	WHERE s.OperatorID = @OperatorID
	AND EXISTS (SELECT * FROM SearchItems si WHERE si.SearchID = s.SearchID)
	
ORDER BY 16 ASC, 17 ASC, 9
GO

CREATE PROCEDURE dbo.MetaFormCheck (@TableName VARCHAR(64))  AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mc.MetaColumnID, mc.ColumnName, mc.Description, CASE WHEN mc.IsKey = 0 AND mc.Quoted = 0 AND mc.Nullable = 0 THEN 1 ELSE mc.Required END AS Required, mc.MinSize, mc.MaxSize, mc.MetaRuleID, mc.RegExp, mc.Quoted, mc.StringID
FROM MetaTables mt JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID)
	WHERE mt.TableName = @TableName
GO

CREATE PROCEDURE dbo.MetaGetGroupID (@metatableid INT, @data INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @table VARCHAR(40), @prevtable VARCHAR(40), @column VARCHAR(40), @prevcolumn VARCHAR(40)
DECLARE @txtdata VARCHAR(15), @grouptable VARCHAR(40)

SELECT @grouptable = GroupTable FROM MetaTables WHERE MetaTableID = @metatableid
SELECT @column = ColumnName FROM MetaColumns mc, MetaTables mt WHERE mt.MetaTableID = mc.MetaTableID AND mt.TableName = @grouptable AND mc.IsKey = 1 AND mc.Quoted = 0
SELECT @table = @grouptable
SELECT @txtdata = CAST(@data AS VARCHAR(15))
IF (@column IS NOT NULL)
BEGIN
CREATE TABLE #mggtmp (Data INT NULL)
WHILE(@grouptable IS NOT NULL)
	BEGIN
	SELECT @prevcolumn = @column, @prevtable = @table
	SELECT @grouptable = GroupTable FROM MetaTables WHERE TableName = @grouptable
	IF (@grouptable IS NOT NULL)
		BEGIN
		SELECT @table = @grouptable
		SELECT @column = ColumnName FROM MetaColumns mc, MetaTables mt WHERE mt.MetaTableID = mc.MetaTableID AND mt.TableName = @grouptable AND mc.IsKey = 1 AND mc.Quoted = 0
		DELETE FROM #mggtmp
		EXEC('INSERT INTO #mggtmp (Data) SELECT ' + @column + ' FROM ' + @prevtable + ' WHERE ' + @prevcolumn + ' = ' + @txtdata)
		SELECT @txtdata = 'NULL'
		SELECT @txtdata = CAST(Data AS VARCHAR(15)) FROM #mggtmp
		END
	END
DELETE FROM #mggtmp
EXEC('INSERT INTO #mggtmp (Data) SELECT GroupID FROM ' + @table + ' WHERE ' + @column + ' = ' + @txtdata)
SELECT DISTINCT Data AS GroupID FROM #mggtmp
END
ELSE
BEGIN
SELECT NULL AS GroupID
END
GO

CREATE PROCEDURE dbo.MetaGetTable (@MetaTableID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT MetaColumnID,ColumnName,Quoted,DepTable,DepColumn,MetaRuleID,Required,Nullable,MinSize,MaxSize,IsKey,Description,RegExp,CheckQuery,AllowAudit,AddOnly
FROM MetaColumns
	WHERE MetaTableID = @MetaTableID
GO

CREATE PROCEDURE dbo.MetaGetTableInfo (@table VARCHAR(40)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mt.GroupTable, mc2.ColumnName AS GroupColumn, mt.LabelTable, mc4.ColumnName AS LabelColumn, mt.AllowAudit
FROM MetaTables mt LEFT JOIN MetaTables mt2 ON (mt.GroupTable = mt2.TableName)
	LEFT JOIN MetaTables mt3 ON (mt.LabelTable = mt3.TableName)
	LEFT JOIN MetaColumns mc2 ON (mt2.MetaTableID = mc2.MetaTableID AND mc2.IsKey = 1)
	LEFT JOIN MetaColumns mc3 ON (mt3.MetaTableID = mc3.MetaTableID AND mc3.IsKey = 1)
	LEFT JOIN MetaColumns mc4 ON (mt.MetaTableID = mc4.MetaTableID AND mc3.ColumnName = mc4.ColumnName)
	WHERE mt.TableName = @table
GO

CREATE PROCEDURE dbo.NSFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE sa.Active = 1
	AND ma.Active = 1
	AND (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.NSGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x500uniqueIdentifier,
sa.AccountID AS accountid, a.FirstName + ' ' + a.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
'mailbox' AS mailDeliveryOption,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
a.LastName AS sn,
a.FirstName AS givenname,
sa.Password AS userpassword,
CASE WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 'inactive' ELSE 'active' END AS inetuserstatus,
CASE WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 'inactive' ELSE 'active' END AS mailuserstatus,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS rfc822mailbox,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifyDate > ls.LastSyncWrite)
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.NoticeMBRLicense (@Operator VARCHAR(32), @thlimit INT, @licleft INT, @licmbrs INT, @GroupID INT) AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @mbrs INT, @groupmbrs INT

SELECT @mbrs = COUNT(*), @groupmbrs = SUM(CASE WHEN @GroupID IS NULL OR ma.GroupID = @GroupID THEN 1 ELSE 0 END)
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (1,0)

SELECT @mbrs = @mbrs + COUNT(*), @groupmbrs = @groupmbrs + SUM(CASE WHEN @GroupID IS NULL OR ma.GroupID = @GroupID THEN 1 ELSE 0 END)
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND bc.AutoBill = 2
	AND EXISTS
		(
		SELECT *
		FROM SubAccounts sa LEFT JOIN
			(
			SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft, SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft
			FROM SubAccountUsages
				WHERE ExpireDate > getdate()
			GROUP BY AccountID
			) sau ON (sa.AccountID = sau.AccountID)
			WHERE sa.Active = 1
			AND sa.CustomerID = ma.CustomerID
			AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())
			AND (sa.TimeLeft IS NULL OR sa.TimeLeft + COALESCE(sau.TimeLeft,0) > 0)
			AND (sa.DataLeft IS NULL OR sa.DataLeft + COALESCE(sau.DataLeft,0) > 0)
		)

SELECT o.OperatorID, DATEPART(dd,getdate()) AS TokenID, o.Operator, o.FirstName, o.LastName,
@groupmbrs AS MBRCount, @thlimit AS WarnCount, CASE WHEN @groupmbrs - @thlimit > 0 THEN @groupmbrs - @thlimit ELSE 0 END AS OverCount, 
@mbrs AS LicenseUsed, @licmbrs - @mbrs AS LicenseRemain, @licmbrs AS LicensePurchased
FROM Operators o
	WHERE o.Operator = @Operator
	AND ((@groupmbrs > @thlimit) OR (@mbrs + @licleft > @licmbrs))
GO

CREATE PROCEDURE dbo.NoticeBulkProfileList AS
SET NOCOUNT ON
SELECT 1 AS uord, NULL AS SortOrder, NULL AS Value, NULL AS Description
UNION ALL
SELECT 2 AS uord, SortOrder, BulkProfileID AS Value, BulkProfile AS Description
FROM BulkProfiles
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeSchedBlockTypeList AS
SET NOCOUNT ON
SELECT 1 AS uord, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2 AS uord, SchedBlockTypeID AS Value, SchedBlockType AS Description
FROM SchedBlockTypes
ORDER BY 1,3
GO

CREATE PROCEDURE dbo.NoticeRegionList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 3 ELSE 2 END AS uord, SortOrder, RegionID AS Value,Region AS Description, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM Regions
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeSAMarketTagsList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN mt.SortOrder < 0 THEN 3 ELSE 2 END AS uord, mt.SortOrder, mt.MarketTagID, '[' + mc.MarketCategory + '] ' + mt.MarketTag AS Description, CASE WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeMAMarketTagsList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN mt.SortOrder < 0 THEN 3 ELSE 2 END AS uord, mt.SortOrder, mt.MarketTagID, '[' + mc.MarketCategory + '] ' + mt.MarketTag AS Description, CASE WHEN mt.SortOrder < 0 THEN 'hidden' END AS Class
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (1,2,3)
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeRoleList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2 AS uord, SortOrder, RoleID, Role
FROM Roles
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeStatusList AS
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description
UNION ALL
SELECT 3, 'Success'
UNION ALL
SELECT 2, 'Fail'
GO

CREATE PROCEDURE dbo.NoticePayMethodList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2 AS uord, SortOrder, PaymentTypeID, PaymentType
FROM PaymentTypes
	WHERE IsPayMethod = 1
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticePaymentTypeList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2 AS uord, SortOrder, PaymentTypeID, PaymentType
FROM PaymentTypes
	WHERE IsPayType = 1
	AND SortOrder >= 0
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeMarketSAExpireList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN mt.SortOrder < 0 THEN 3 ELSE 2 END AS uord, mt.SortOrder, mt.MarketTagID, '[' + mc.MarketCategory + '] ' + mt.MarketTag AS MarketTag, CASE WHEN mt.SortOrder < 0 THEN 'hidden' END
FROM MarketTags mt JOIN MarketCategories mc ON (mt.MarketCategoryID = mc.MarketCategoryID)
	WHERE mt.MarketTagAutoTypeID IN (4,5,6)
	AND mt.CustomerHidden = 0
	AND (mt.InvoicedDaysMax IS NOT NULL OR mt.ServiceMonthsMax IS NOT NULL OR mt.AllowInvoicedDaysMax = 1)
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeSendMethodList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 3 ELSE 2 END AS uord, SortOrder, SendMethodID, SendMethod, CASE WHEN SortOrder < 0 THEN 'hidden' END
FROM SendMethods
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeScheduleList AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1 AS uord, 1 AS Active, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT 2 AS uord, Active, ScheduleID AS Value, '[' + TaskName + '] ' + Description AS Description, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM Schedules
	WHERE Interval > 0
ORDER BY 1,2 DESC,4
GO

CREATE PROCEDURE dbo.NoticeGaugeList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT 2 AS uord, SortOrder, GaugeID AS Value,Gauge AS Description, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM Gauges
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeOrgList AS
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description
UNION ALL
SELECT OrganizationID AS Value,Organization AS Description 
FROM Organizations 
GO

CREATE PROCEDURE dbo.NoticeGroupList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 4 WHEN Active = 0 OR StartDate >= getdate() OR EndDate <= getdate() THEN 3 ELSE 2 END, SortOrder, GroupID AS Value, GroupName AS Description, CASE WHEN SortOrder < 0 THEN 'hidden' WHEN Active = 0 THEN 'inactive' WHEN StartDate >= getdate() OR EndDate <= getdate() THEN 'inactive' END AS Class
FROM Groups 
	WHERE GroupID <> 1
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeBillingCycleList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 3 ELSE 2 END AS uord, SortOrder, BillingCycleID AS Value,BillingCycle AS Description, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM BillingCycles
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeAccountTypeList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 3 ELSE 2 END AS uord, SortOrder, AccountTypeID AS Value,AccountType AS Description, CASE WHEN SortOrder < 0 THEN 'hidden' WHEN EndDate < getdate() THEN 'inactive' WHEN StartDate > getdate() THEN 'inactive' END AS Class
FROM AccountTypes 
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeIncidentTypeList AS 
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN SortOrder < 0 THEN 3 ELSE 2 END, SortOrder, IncidentTypeID AS Value, IncidentType AS Description, CASE WHEN SortOrder < 0 THEN 'hidden' END AS Class
FROM IncidentTypes 
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeInvWarehouseList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN Active = 0 THEN 3 ELSE 2 END, SortOrder, InvWarehouseID, InvWarehouse, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM InvWarehouses
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeInvWarehouseGroupList AS
SET NOCOUNT ON
SELECT 1 AS uord, 0 AS SortOrder, NULL AS Value, 'All' AS Description, NULL AS Class
UNION ALL
SELECT CASE WHEN Active = 0 THEN 3 ELSE 2 END, SortOrder, InvWarehouseGroupID, InvWarehouseGroup, CASE WHEN Active = 0 THEN 'inactive' END AS Class
FROM InvWarehouseGroups
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeInvSourceList AS
SET NOCOUNT ON
SELECT 1 AS SortOrder, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2, InvSourceID, InvSource FROM InvSources
ORDER BY 1,3
GO

CREATE PROCEDURE dbo.NoticeInvCategoryList AS
SET NOCOUNT ON
SELECT 1 AS uorder, 0 AS SortOrder, NULL AS Value, 'All' AS Description
UNION ALL
SELECT 2, SortOrder, InvCategoryID, InvCategory FROM InvCategories
ORDER BY 1,2,4
GO

CREATE PROCEDURE dbo.NoticeActivesAdd (@NoticeID INT, @CustomerID INT, @AccountID INT, @OperatorID INT, @TokenID INT, @SubTokenID INT) AS
SET NOCOUNT ON
INSERT INTO NoticeActives (NoticeID,CustomerID,AccountID,OperatorID,TokenID,SubTokenID) VALUES(@NoticeID,@CustomerID,@AccountID,@OperatorID,@TokenID,@SubTokenID)
GO

CREATE PROCEDURE dbo.NoticeActivesDelete (@NoticeID INT, @CustomerID INT, @AccountID INT, @OperatorID INT, @TokenID INT, @SubTokenID INT) AS
SET NOCOUNT ON

DELETE FROM NoticeActives 
	WHERE NoticeID = @NoticeID
	AND ((CustomerID IS NULL AND @CustomerID IS NULL) OR CustomerID = @CustomerID)
	AND ((AccountID IS NULL AND @AccountID IS NULL) OR AccountID = @AccountID)
	AND ((OperatorID IS NULL AND @OperatorID IS NULL) OR OperatorID = @OperatorID)
	AND ((TokenID IS NULL AND @TokenID IS NULL) OR TokenID = @TokenID)
	AND ((SubTokenID IS NULL AND @SubTokenID IS NULL) OR SubTokenID = @SubTokenID)
GO

CREATE PROCEDURE dbo.NoticeActivesGet (@NoticeID INT) AS
SET NOCOUNT ON
SELECT CustomerID, AccountID, OperatorID, TokenID, SubTokenID
FROM NoticeActives 
	WHERE NoticeID = @NoticeID
GO

CREATE PROCEDURE dbo.NoticeConfigGet (@NoticeID INT, @InternalID INT) AS
SET NOCOUNT ON
DECLARE @armed INT
SELECT @armed = COALESCE(MAX(NumValue),1) FROM Configs WHERE ConfigID = 674

SELECT n.NoticeID, n.Active, nt.SentQuery, nt.ReportFile, nt.SQLQuery, n.Parm1, n.Parm2, n.Parm3, n.Parm4, n.Parm5, n.Parm6, n.Parm7,
nt.NoticePurposeID, n.NoticeTechID, n.NoticeFormatID, n.AccessTime, n.MailFrom, n.MailSubject, n.MailCC, n.MailBCC, n.AttachFileName, n.NoticeText, @armed AS Armed
FROM Notices n JOIN NoticeTypes nt ON (n.NoticeTypeID = nt.NoticeTypeID)
	WHERE (n.NoticeID = @NoticeID OR (@NoticeID IS NULL AND @InternalID IS NOT NULL AND n.InternalID = @InternalID))
GO

CREATE PROCEDURE dbo.NoticeLogsAdd (@NoticeID INT, @InternalID INT, @CustomerID INT, @AccountID INT, @Email VARCHAR(80), @ErrorMessage VARCHAR(128)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@NoticeID IS NULL)
BEGIN
SELECT @NoticeID = MIN(NoticeID) FROM Notices WHERE InternalID = @InternalID AND Active = 1
END

IF (@CustomerID IS NULL)
BEGIN
SELECT @CustomerID = CustomerID FROM SubAccounts WHERE AccountID = @AccountID
END

IF (@NoticeID IS NOT NULL AND @CustomerID IS NOT NULL)
BEGIN
INSERT INTO NoticeLogs (NoticeID,CustomerID,Email,ErrorMessage) VALUES(@NoticeID,@CustomerID,@Email,@ErrorMessage)
END
GO

CREATE PROCEDURE dbo.NoticeMailList (@OperatorID INT, @CustomerID INT, @AccountID INT, @normal_to INT, @NoticePurposeID INT, @NoticeTechID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@NoticeTechID = 1 AND @normal_to = 0)
BEGIN
SELECT o.LanguageID, o.PrintTypeID AS EmailTypeID, g.EmailAccounts AS EmailAccounts, g.EmailSubject, 
CASE WHEN o.FirstName IS NULL AND o.LastName IS NULL THEN o.Operator ELSE o.FirstName END AS FirstName,
CASE WHEN o.FirstName IS NULL AND o.LastName IS NULL THEN NULL ELSE o.LastName END AS LastName,
NULL AS Login, o.Email, NULL AS MailDomain
FROM Operators o
	LEFT JOIN Groups g ON (g.GroupID = 1)
	WHERE o.OperatorID = @OperatorID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AccountID)
	WHERE sa.AccountID = @AccountID
END


IF (@NoticeTechID = 2 AND @normal_to = 0)
BEGIN
SELECT LanguageID, PhoneMobile, 
CASE WHEN FirstName IS NULL AND LastName IS NULL THEN Operator ELSE FirstName END AS FirstName,
CASE WHEN FirstName IS NULL AND LastName IS NULL THEN NULL ELSE LastName END AS LastName,
NULL AS SMSAccessTime
FROM Operators
	WHERE OperatorID = @OperatorID

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE ma.CustomerID = @CustomerID

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE sa.AccountID = @AccountID
END


IF (@NoticeTechID = 1 AND @normal_to = 1)
BEGIN
SELECT o.LanguageID, o.PrintTypeID AS EmailTypeID, g2.EmailAccounts AS EmailAccounts, g2.EmailSubject, 
CASE WHEN o.FirstName IS NULL AND o.LastName IS NULL THEN o.Operator ELSE o.FirstName END AS FirstName,
CASE WHEN o.FirstName IS NULL AND o.LastName IS NULL THEN NULL ELSE o.LastName END AS LastName,
NULL AS Login, o.Email, NULL AS MailDomain
FROM Operators o
	LEFT JOIN Groups g2 ON (g2.GroupID = 1)
	WHERE o.Active = 1
	AND o.Email IS NOT NULL
	AND o.OperatorID = @OperatorID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Addresses a ON (ma.CustomerID = a.CustomerID)
	WHERE a.AccountID IS NULL
	AND a.EmailNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND a.Email IS NOT NULL
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Addresses a ON (sa.AccountID = a.AccountID)
	WHERE a.EmailNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND a.Email IS NOT NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CustomerID = @CustomerID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Addresses a ON (sa.AccountID = a.AccountID)
	WHERE a.EmailNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND a.Email IS NOT NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.AccountID = @AccountID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE a.EmailNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND a.Email IS NOT NULL
	AND a.AccountID IS NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.AccountID = @AccountID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, a.FirstName, a.LastName, NULL AS Login, a.Email, NULL AS MailDomain
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	WHERE a.EmailNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND a.Email IS NOT NULL
	AND a.AccountID IS NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.AccountID = @AccountID

UNION

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, COALESCE(a.FirstName,a2.FirstName) AS FirstName, COALESCE(a.LastName,a2.LastName) AS LastName, sa.Login, sa.Email, d.MailDomain
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.Active = 1)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Addresses a2 ON (ma.BillingAddressID = a2.AddressID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.SendBill = 1
	AND sa.Login IS NOT NULL
END

IF (@NoticeTechID = 2 AND @normal_to = 1)
BEGIN
SELECT LanguageID, PhoneMobile, 
CASE WHEN FirstName IS NULL AND LastName IS NULL THEN Operator ELSE FirstName END AS FirstName,
CASE WHEN FirstName IS NULL AND LastName IS NULL THEN NULL ELSE LastName END AS LastName,
NULL AS SMSAccessTime
FROM Operators
	WHERE OperatorID = @OperatorID
	AND Active = 1
	AND PhoneMobile IS NOT NULL

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN Addresses a ON (ma.CustomerID = a.CustomerID)
	WHERE ma.CustomerID = @CustomerID
	AND a.AccountID IS NULL
	AND a.SMSNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND ma.Active = 1
	AND a.PhoneMobile IS NOT NULL

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.AccountID = a.AccountID)
	WHERE ma.CustomerID = @CustomerID
	AND a.SMSNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND a.PhoneMobile IS NOT NULL

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.AccountID = a.AccountID)
	WHERE sa.AccountID = @AccountID
	AND a.SMSNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND a.PhoneMobile IS NOT NULL

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE sa.AccountID = @AccountID
	AND a.SMSNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND a.PhoneMobile IS NOT NULL
	AND a.AccountID IS NULL

UNION

SELECT ma.LanguageID, a.PhoneMobile, a.FirstName, a.LastName, a.SMSAccessTime
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Addresses a ON (sa.ServiceAddressID = a.AddressID)
	WHERE sa.AccountID = @AccountID
	AND a.SMSNoticePurposeMask & @NoticePurposeID = @NoticePurposeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND a.PhoneMobile IS NOT NULL
	AND a.AccountID IS NULL
END
GO

CREATE PROCEDURE dbo.NoticeSMSWrite (@NoticeID INT, @SMSNumber VARCHAR(32), @Message VARCHAR(1024)) AS
SET NOCOUNT ON
INSERT INTO SMSWrites (SMSNumber,Message) VALUES(@SMSNumber,@Message)
GO

CREATE PROCEDURE dbo.OGCopy (@SrcObjectGroupID INT, @DstObjectGroupID INT) AS
SET NOCOUNT ON

IF (@DstObjectGroupID > 10000)
BEGIN
INSERT INTO Objects (ObjectGroupID,ObjectTypeID,Value,Data,Description,Active,DirectRef)
SELECT @DstObjectGroupID, o.ObjectTypeID, o.Value, o.Data, o.Description, o.Active, o.DirectRef
FROM Objects o
	WHERE o.ObjectGroupID = @SrcObjectGroupID
	AND NOT EXISTS
		(
		SELECT * 
		FROM Objects eo 
			WHERE eo.ObjectGroupID = @DstObjectGroupID 
			AND eo.ObjectTypeID = o.ObjectTypeID 
			AND COALESCE(eo.Value,'') = COALESCE(o.Value,'')
			AND COALESCE(eo.Data,'') = COALESCE(o.Data,'')
		)
END
GO

CREATE PROCEDURE dbo.OGACopy (@SrcOperatorGroupID INT, @DstOperatorGroupID INT, @DstGroupID INT) AS
SET NOCOUNT ON

INSERT INTO OperatorGroupAccess(OperatorGroupID,ObjectGroupID,GroupID,AccessType)
SELECT DISTINCT @DstOperatorGroupID, oga.ObjectGroupID, CASE WHEN @DstGroupID = 1 THEN oga.GroupID ELSE @DstGroupID END, oga.AccessType
FROM OperatorGroupAccess oga
	WHERE oga.OperatorGroupID = @SrcOperatorGroupID
	AND NOT EXISTS (SELECT * FROM OperatorGroupAccess oga2 
		WHERE oga2.OperatorGroupID = @DstOperatorGroupID 
		AND oga2.ObjectGroupID = oga.ObjectGroupID
		AND oga2.GroupID = CASE WHEN @DstGroupID = 1 THEN oga.GroupID ELSE @DstGroupID END)
	AND NOT EXISTS (SELECT * FROM OperatorGroupAccess oga3
		WHERE oga3.OperatorGroupID = @DstOperatorGroupID
		AND oga3.ObjectGroupID = oga.ObjectGroupID
		AND oga3.GroupID = 1
		AND ((oga.GroupID = 1 AND @DstGroupID <> 1) OR (oga.GroupID <> 1 AND @DstGroupID = 1))
		AND (oga.AccessType & 1 = 0 OR oga3.AccessType & 1 = 1)
		AND (oga.AccessType & 2 = 0 OR oga3.AccessType & 2 = 2)
		AND (oga.AccessType & 4 = 0 OR oga3.AccessType & 4 = 4)
		AND (oga.AccessType & 8 = 0 OR oga3.AccessType & 8 = 8))

UPDATE ogad SET AccessType = CASE WHEN ogad.AccessType & 1 = 1 OR ogas.AccessType & 1 = 1 THEN 1 ELSE 0 END +
CASE WHEN ogad.AccessType & 2 = 2 OR ogas.AccessType & 2 = 2 THEN 2 ELSE 0 END +
CASE WHEN ogad.AccessType & 4 = 4 OR ogas.AccessType & 4 = 4 THEN 4 ELSE 0 END +
CASE WHEN ogad.AccessType & 8 = 8 OR ogas.AccessType & 8 = 8 THEN 8 ELSE 0 END
FROM OperatorGroupAccess ogad JOIN OperatorGroupAccess ogas ON (ogad.ObjectGroupID = ogas.ObjectGroupID AND ogad.GroupID = ogas.GroupID)
	WHERE ogad.OperatorGroupID = @DstOperatorGroupID
	AND ogas.OperatorGroupID = @SrcOperatorGroupID
	AND ogad.GroupID = @DstGroupID
GO

CREATE PROCEDURE dbo.PayAutoCheck (@CustomerID INT) AS
SET NOCOUNT ON

SELECT CASE WHEN PendingBalance < 0 THEN -(PendingBalance) ELSE 0 END AS Amount
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.CustomerID = @CustomerID
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate())
	AND ma.PaymentTypeID IN (8,16)
	AND bc.AutoBill IN (0,1)
GO

CREATE PROCEDURE dbo.PayBalSettle (@CustomerID INT, @fixhistory INT) AS
SET NOCOUNT ON
DECLARE @PaidAmount NUMERIC(18,4), @InvAmount NUMERIC(18,4), @FinalAmount NUMERIC(18,4), @InvoiceID INT, @ChargeID INT, @ItemID INT, @StatementID INT, @CurBal NUMERIC(18,4), @NC NUMERIC(18,4)

SELECT @PaidAmount = SUM(CASE WHEN FinalStatementID IS NOT NULL THEN FinalAmount ELSE Amount END) 
FROM Payments
	WHERE StatementID IS NOT NULL 
	AND CustomerID = @CustomerID

SELECT @InvAmount = SUM(CASE WHEN VoidDate IS NOT NULL AND VoidStatementID IS NOT NULL THEN 0 ELSE Amount END)
FROM Invoices
	WHERE CustomerID = @CustomerID 
	AND StatementID IS NOT NULL

SELECT @PaidAmount = COALESCE(@PaidAmount,0), @InvAmount = COALESCE(@InvAmount,0)

SELECT @FinalAmount = ROUND(Balance - (@InvAmount - @PaidAmount),2), @CurBal = Balance, @NC = ROUND(@InvAmount - @PaidAmount,2)
FROM MasterAccounts 
	WHERE CustomerID = @CustomerID

SELECT @FinalAmount = CASE WHEN COUNT(*) > 0 THEN 0 ELSE @FinalAmount END
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	WHERE i.CustomerID = @CustomerID
	AND i.VoidDate IS NULL
	AND i.Processed = 1
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(ROUND(ii.Amount * ii.Quantity,2))

IF (@fixhistory = 0)
BEGIN
SELECT Balance AS CurrentBalance, @FinalAmount AS CalcDiff, Balance + @FinalAmount AS CalcBalance, @InvAmount AS Invoiced, @PaidAmount AS Paid
FROM MasterAccounts
	WHERE CustomerID = @CustomerID
END

IF (@FinalAmount <> 0 AND @fixhistory = 1)
BEGIN
INSERT INTO Invoices (CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,CreateDate,LastModifyDate,LastModifyUser,Tax,Comments,Estimate,Processed,PrintDate,EmailDate)
VALUES(@CustomerID,4,@FinalAmount,CASE WHEN @FinalAmount > 0 THEN @FinalAmount ELSE 0 END, CASE WHEN @FinalAmount < 0 THEN -@FinalAmount ELSE 0 END,DATEADD(yy,-10,getdate()),getdate(),'GBE',0,'GBE Balance sync',0,1,DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()))

SELECT @InvoiceID = SCOPE_IDENTITY()

IF (@FinalAmount < 0)
	BEGIN
	INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser,CreateDate,CreateUser)
	VALUES(@CustomerID,'GBE balance sync',DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()),1,@FinalAmount,1,getdate(),'GBE',getdate(),'GBE')
	SELECT @ChargeID = SCOPE_IDENTITY()
	END

INSERT INTO InvoiceItems (InvoiceID,ItemType,Days,Description,StartDate,EndDate,Amount,Quantity,ChargeID)
VALUES(@InvoiceID,CASE WHEN @FinalAmount < 0 THEN 1 ELSE 2 END,0,'GBE balance sync',DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()),@FinalAmount,1,@ChargeID)

SELECT @ItemID = SCOPE_IDENTITY()

IF (@ChargeID IS NOT NULL)
BEGIN
UPDATE Charges SET ItemID = @ItemID WHERE ChargeID = @ChargeID
END

INSERT INTO Statements (CustomerID,StatementDate,PrevBal,NewCharges,NewCredits,EndBal,PrintDate,EmailDate)
VALUES(@CustomerID,DATEADD(yy,-10,getdate()),@NC,CASE WHEN @FinalAmount < 0 THEN 0 ELSE @FinalAmount END, CASE WHEN @FinalAmount > 0 THEN 0 ELSE -@FinalAmount END, @CurBal, DATEADD(yy,-10,getdate()), DATEADD(yy,-10,getdate()))

SELECT @StatementID = SCOPE_IDENTITY()
UPDATE Invoices SET StatementID = @StatementID WHERE InvoiceID = @InvoiceID
END
GO

CREATE PROCEDURE dbo.PayBatchProcGet (@CustomerID INT, @BatchProcessorID INT, @cardlen INT, @cardprefix VARCHAR(4), @PaymentTypeID INT) AS
SET NOCOUNT ON
DECLARE @outBatchProcessorID INT, @AllowAuthOnly INT, @Realtime INT

IF (@BatchProcessorID IS NOT NULL)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = 1
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON ((bp.OrganizationID IS NULL OR bp.OrganizationID = g.OrganizationID) AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID))
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE ma.CustomerID = @CustomerID
	AND bp.BatchProcessorID = @BatchProcessorID
	AND ma.Active = 1
	AND bp.Active = 1
	AND e.ExportType IN (10)
END

IF (@outBatchProcessorID IS NULL AND @PaymentTypeID = 8)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,5)
	AND ctp.Prefix = SUBSTRING(@cardprefix,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND @cardlen IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END

IF (@outBatchProcessorID IS NULL AND @PaymentTypeID = 8)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND g.OrganizationID = bp.OrganizationID
	AND bp.GroupID IS NULL
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,5)
	AND ctp.Prefix = SUBSTRING(@cardprefix,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND @cardlen IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END

IF (@outBatchProcessorID IS NULL AND @PaymentTypeID = 8)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE bp.OrganizationID IS NULL
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,5)
	AND ctp.Prefix = SUBSTRING(@cardprefix,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND @cardlen IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END

IF (@outBatchProcessorID IS NULL)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((@PaymentTypeID = 8 AND e.ExportType IN (1,5) AND bp.CardTypes & 256 = 256) OR (@PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END

IF (@outBatchProcessorID IS NULL)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND g.OrganizationID = bp.OrganizationID
	AND bp.GroupID IS NULL
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((@PaymentTypeID = 8 AND e.ExportType IN (1,5) AND bp.CardTypes & 256 = 256) OR (@PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END

IF (@outBatchProcessorID IS NULL)
BEGIN
SELECT @outBatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6) THEN 1 ELSE 0 END
FROM MasterAccounts ma, BatchProcessors bp, Exports e
	WHERE bp.OrganizationID IS NULL
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((@PaymentTypeID = 8 AND e.ExportType IN (1,5) AND bp.CardTypes & 256 = 256) OR (@PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND (@BatchProcessorID IS NULL OR bp.BatchProcessorID = @BatchProcessorID)
END


SELECT @outBatchProcessorID AS BatchProcessorID, @AllowAuthOnly AS AllowAuthOnly, @Realtime AS Realtime
GO

CREATE PROCEDURE dbo.PayCheckAdd (@CustomerID INT, @PaymentTypeID INT, @BatchID INT, @Amount NUMERIC(18,4), @CheckNumber VARCHAR(16), @PayInfo VARCHAR(64), @ExternalRef VARCHAR(64), @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE MasterAccounts SET TempExtension = 0 WHERE CustomerID = @CustomerID AND TempExtension > 0
INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,CheckNumber,PayInfo,ExternalRef,CreateUser,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(@CustomerID,@PaymentTypeID,@BatchID,@Amount,@CheckNumber,@PayInfo,@ExternalRef,@LastModifyUser,@LastModifyUser,1,getdate(),getdate())

SELECT SCOPE_IDENTITY() AS PaymentID

IF (@PaymentTypeID = 4)
BEGIN
INSERT INTO Charges (CustomerID,ChargeTypeID,Description,StartDate,EndDate,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,CreateDate,LastModifyDate,CreateUser,LastModifyUser)
SELECT ma.CustomerID, ct.ChargeTypeID,ct.ChargeType + ' (#' + @CheckNumber + ')', getdate() AS StartDate, getdate() AS EndDate, 0 AS AllowInterim, ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, getdate(),getdate(),@LastModifyUser,@LastModifyUser
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Configs c ON (c.ConfigID = 705)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 705 AND cgd.GroupID = ma.GroupID)
	JOIN ChargeTypes ct ON (ct.ChargeTypeID = COALESCE(cgd.NumValue,c.NumValue))
	WHERE ma.CustomerID = @CustomerID
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR (ma.CancelDate > DATEADD(dd,1,getdate()) AND EXISTS (SELECT * 
		FROM SubAccounts sa
			WHERE sa.CustomerID = ma.CustomerID
			AND sa.Active = 1
			AND sa.Recurring = 1
			AND sa.BilledThru < DATEADD(dd,-2,ma.CancelDate)
			AND (sa.CancelDate IS NULL OR sa.BilledThru < DATEADD(dd,-2,sa.CancelDate)) )))
END
GO

CREATE PROCEDURE dbo.PayGetTrans (@ExternalTransID INT) AS
SET NOCOUNT ON
SELECT et.CustomerID, et.InvoiceID, et.TransStateID, et.TransTypeID, et.Amount AS TransAmount, et.PaymentID, et.ProcTransID, p.Amount AS PayAmount, p.FinalAmount AS FinalAmount, p.StatementID, p.FinalStatementID
FROM ExternalTrans et LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.ExternalTransID = @ExternalTransID
GO

CREATE PROCEDURE dbo.PayPrepaidAdd (@CustomerID INT, @BatchID INT, @Amount NUMERIC(18,4), @CardAccountID INT, @PayInfo VARCHAR(64), @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE MasterAccounts SET TempExtension = 0 WHERE CustomerID = @CustomerID AND TempExtension > 0

INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,ProcTransID,PayInfo,CreateUser,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(@CustomerID,32,@BatchID,@Amount,CAST(@CardAccountID AS VARCHAR(40)),@PayInfo,@LastModifyUser,@LastModifyUser,1,getdate(),getdate())

SELECT SCOPE_IDENTITY() AS PaymentID
GO

CREATE PROCEDURE dbo.PayPrepaidGet (@CustomerID INT, @Login VARCHAR(40), @Password VARCHAR(128)) AS
SET NOCOUNT ON
SELECT ca.CardAccountID, CASE WHEN ca.Active = 1 AND cb.Active = 1 THEN 1 ELSE 0 END AS Active, 
CASE WHEN ca.InactiveExpireDate < getdate() THEN 1 ELSE 0 END AS Expired,
CASE WHEN ca.UsedForDirect = 1 OR (ca.AllowCredit = 0 AND ca.CreditAmount <= 0) THEN 1 ELSE 0 END AS Consumed,
CASE WHEN (SELECT o.OrganizationID FROM Organizations o, Groups g, MasterAccounts ma WHERE o.OrganizationID = g.OrganizationID AND ma.GroupID = g.GroupID AND ma.CustomerID = @CustomerID) = ca.OrganizationID THEN 1 ELSE 0 END AS OrgMatch,
CASE WHEN ca.AllowCredit = 1 AND ca.CreditAmount IS NOT NULL THEN 1 ELSE 0 END AS AllowCredit, CreditAmount
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	WHERE ca.Login = @Login
	AND ca.Password = @Password
GO

CREATE PROCEDURE dbo.PayTransAdd (@ExternalTransID INT, @BatchID INT, @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @ConfigID INT, @PercentConfigID INT, @PaymentTypeID INT, @CustomerID INT, @Amount NUMERIC(18,4), @ProcTransID VARCHAR(64), @etLastModifyUser VARCHAR(64), @ProcDate DATETIME, @BatchProcessorID INT, @AccountNumber VARCHAR(128), @Token VARCHAR(128)

SELECT @CustomerID = et.CustomerID, @Amount = et.Amount, @ProcTransID = et.ProcTransID, @etLastModifyUser = et.LastModifyUser,
@ConfigID = CASE WHEN ext.IsBatch = 1 AND ext.IsCC = 1 THEN 706 WHEN ext.IsBatch = 1 AND ext.IsCC = 0 THEN 707 END,
@PercentConfigID = CASE WHEN ext.IsBatch = 1 AND ext.IsCC = 1 THEN 711 END,
@PaymentTypeID = CASE WHEN ext.IsBatch = 1 AND ext.IsCC = 1 THEN 8 WHEN ext.IsBatch = 1 AND ext.IsCC = 0 THEN 16 ELSE 64 END,
@ProcDate = et.ProcDate, @BatchProcessorID = et.BatchProcessorID, @AccountNumber = et.AccountNumber, @Token = et.Token
FROM ExternalTrans et JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN ExportTypes ext ON (e.ExportType = ext.ExportTypeID)
	WHERE et.ExternalTransID = @ExternalTransID
	AND et.TransTypeID IN (32,64)

UPDATE MasterAccounts SET TempExtension = 0 WHERE TempExtension > 0 AND CustomerID = @CustomerID

INSERT INTO Payments (CustomerID,Amount,CreateDate,BatchID,PaymentTypeID,ProcTransID,DistFlag,LastModifyDate,LastModifyUser,CreateUser) VALUES(@CustomerID,@Amount,getdate(),@BatchID,@PaymentTypeID,@ProcTransID,1,getdate(),@LastModifyUser,CASE WHEN @LastModifyUser LIKE '%auto bill%' AND @etLastModifyUser NOT LIKE '%auto bill%' THEN @etLastModifyUser ELSE @LastModifyUser END)
SELECT SCOPE_IDENTITY() AS PaymentID

IF (@ConfigID IS NOT NULL)
BEGIN
INSERT INTO Charges (CustomerID,ChargeTypeID,StartDate,EndDate,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,CreateDate,LastModifyDate,CreateUser,LastModifyUser)
SELECT ma.CustomerID, ct.ChargeTypeID, getdate() AS StartDate, getdate() AS EndDate, 0 AS AllowInterim, ct.Amount + (@Amount * COALESCE(pcgd.NumValue,pc.NumValue,0) / 100), 1, ct.TaxGroupID, ct.TaxExemptions, getdate(),getdate(),@LastModifyUser,@LastModifyUser
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Configs c ON (c.ConfigID = @ConfigID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = @ConfigID AND cgd.GroupID = ma.GroupID)
	LEFT JOIN Configs pc ON (pc.ConfigID = @PercentConfigID)
	LEFT JOIN ConfigGroupData pcgd ON (pcgd.ConfigID = @PercentConfigID AND pcgd.GroupID = ma.GroupID)
	JOIN ChargeTypes ct ON (ct.ChargeTypeID = COALESCE(cgd.NumValue,c.NumValue))
	WHERE ma.CustomerID = @CustomerID
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR (ma.CancelDate > DATEADD(dd,1,getdate()) AND EXISTS (SELECT * 
		FROM SubAccounts sa
			WHERE sa.CustomerID = ma.CustomerID
			AND sa.Active = 1
			AND sa.Recurring = 1
			AND sa.BilledThru < DATEADD(dd,-2,ma.CancelDate)
			AND (sa.CancelDate IS NULL OR sa.BilledThru < DATEADD(dd,-2,sa.CancelDate)) )))
END

UPDATE ExternalTrans SET TransStateID = 9
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (32,64)
	AND BatchProcessorID = @BatchProcessorID
	AND ProcDate < @ProcDate
	AND ((@AccountNumber IS NOT NULL AND AccountNumber = @AccountNumber) OR (@Token IS NOT NULL AND Token = @Token))
	AND ExternalTransID <> @ExternalTransID
GO

CREATE PROCEDURE dbo.PaymentChange (@CustomerID INT, @PaymentID INT, @NewAmount NUMERIC(18,4), @PayInfo VARCHAR(64), @Operator VARCHAR(64)) AS
SET NOCOUNT ON

UPDATE Payments SET DistFlag = 1, LastModifyDate = getdate(), PayInfo = @PayInfo, LastModifyUser = @Operator,
Amount = CASE WHEN FinalAmount IS NULL AND StatementID IS NULL AND DATEPART(yy,CreateDate) = DATEPART(yy,getdate()) AND DATEPART(mm,CreateDate) = DATEPART(mm,getdate()) AND DATEPART(dd,CreateDate) = DATEPART(dd,getdate()) THEN ROUND(@NewAmount,2) ELSE Amount END,
FinalAmount = CASE WHEN FinalAmount IS NOT NULL OR StatementID IS NOT NULL OR DATEPART(yy,CreateDate) <> DATEPART(yy,getdate()) OR DATEPART(mm,CreateDate) <> DATEPART(mm,getdate()) OR DATEPART(dd,CreateDate) <> DATEPART(dd,getdate()) THEN ROUND(@NewAmount,2) ELSE FinalAmount END,
FinalCreateDate = CASE WHEN FinalAmount IS NOT NULL OR StatementID IS NOT NULL OR DATEPART(yy,CreateDate) <> DATEPART(yy,getdate()) OR DATEPART(mm,CreateDate) <> DATEPART(mm,getdate()) OR DATEPART(dd,CreateDate) <> DATEPART(dd,getdate()) THEN COALESCE(FinalCreateDate,getdate()) ELSE FinalCreateDate END
	WHERE PaymentID = @PaymentID 
	AND CustomerID = @CustomerID
	AND PaymentTypeID NOT IN (8,16,32) 
	AND @NewAmount IS NOT NULL
	AND ((FinalAmount IS NULL AND Amount <> ROUND(@NewAmount,2)) OR (FinalAmount IS NOT NULL AND FinalAmount <> ROUND(@NewAmount,2)))
	AND (FinalAmount IS NULL OR (FinalStatementID IS NULL AND DATEPART(yy,FinalCreateDate) = DATEPART(yy,getdate()) AND DATEPART(mm,FinalCreateDate) = DATEPART(mm,getdate()) AND DATEPART(dd,FinalCreateDate) = DATEPART(dd,getdate())))

SELECT @@ROWCOUNT AS Status
GO

CREATE PROCEDURE dbo.PaymentCredit (@CustomerID INT, @PaymentID INT, @Amount NUMERIC(18,4), @Operator VARCHAR(64), @Void INT) AS
SET NOCOUNT ON
DECLARE @Realtime INT, @Status INT

SELECT @Realtime = MAX(ext.IsRealtime)
FROM ExternalTrans et JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	JOIN ExportTypes ext ON (e.ExportType = ext.ExportTypeID)
	WHERE et.PaymentID = @PaymentID
	AND et.CustomerID = @CustomerID
	AND ((@Void = 1 AND et.Amount > 0) OR et.Amount >= @Amount)
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND et.TransTypeID IN (32,64)

INSERT INTO ExternalTrans (CustomerID,InvoiceID,BatchProcessorID,TransStateID,TransTypeID,ReqDate,Amount,PaymentID,LastModifyDate,LastModifyUser,Token,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,ProcTransID,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,AutoBill,LastRebatchTry,ApproveCode)
SELECT et.CustomerID,et.InvoiceID,et.BatchProcessorID,0 AS TransStateID,CASE WHEN @Void = 1 THEN 128 ELSE 256 END AS TransTypeID,getdate() AS ReqDate,CASE WHEN @Void = 1 THEN et.Amount ELSE @Amount END AS Amount,et.PaymentID,getdate() AS LastModifyDate,@Operator AS LastModifyUser,et.Token,et.AccountNumber,et.AccountExpire,et.AuthName,et.AuthAddress,et.AuthStateID,et.AuthZip,et.AuthSecurityCode,et.ProcTransID,et.BankName,et.BankNumber,et.BankPhone,et.BankTransType,et.SSN,et.DLNumber,et.DLState,et.BirthDate,0,getdate() AS LastRebatchTry,et.ApproveCode
FROM ExternalTrans et JOIN Payments p ON (et.PaymentID = p.PaymentID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE et.PaymentID = @PaymentID
	AND et.CustomerID = @CustomerID
	AND ((@Void = 1 AND et.Amount > 0) OR et.Amount >= @Amount)
	AND p.FinalAmount IS NULL
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND bp.Active IN (1,0)
	AND et.TransTypeID IN (32,64)
	AND ((@Void = 1 AND e.Features & 16 = 16) OR (@Void <> 1 AND e.Features & 8 = 8))
	AND NOT EXISTS (SELECT * FROM ExternalTrans et2 WHERE et2.TransStateID IN (0,1,2,7,10) AND et2.ExternalTransID <> et.ExternalTransID AND et2.PaymentID=@PaymentID)

SELECT @@ROWCOUNT AS Status, @Realtime AS Realtime
GO

CREATE PROCEDURE dbo.PaymentDishonor (@PaymentID INT, @NSFCharge INT, @PayInfo VARCHAR(64), @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @ChargeTypeID INT, @CustomerID INT

IF (@NSFCharge = 1)
BEGIN
SELECT @ChargeTypeID = ct.ChargeTypeID, @CustomerID = p.CustomerID
FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	LEFT JOIN ConfigGroupData cgd ON (cgd.ConfigID = 15 AND ma.GroupID = cgd.GroupID)
	JOIN Configs c ON (c.ConfigID = 15)
	JOIN ChargeTypes ct ON (COALESCE(cgd.NumValue,c.NumValue) = ct.ChargeTypeID)
	WHERE p.PaymentID = @PaymentID
END

UPDATE Payments SET FinalAmount = 0, FinalCreateDate = getdate(), LastModifyDate = getdate(), LastModifyUser = @Operator, PayInfo = @PayInfo, DistFlag = 1
	WHERE PaymentID = @PaymentID
	AND FinalAmount IS NULL

IF (@@ROWCOUNT = 1 AND @ChargeTypeID IS NOT NULL)
BEGIN
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,CreateDate,CreateUser,LastModifyDate,LastModifyUser)
SELECT @CustomerID,'NSF (Payment #' + CAST(@PaymentID AS VARCHAR(16)) + ')',getdate(),getdate(),1,Amount,1,TaxGroupID,TaxExemptions,ChargeTypeID,getdate(),@Operator,getdate(),@Operator
FROM ChargeTypes
	WHERE ChargeTypeID = @ChargeTypeID
END
GO

CREATE PROCEDURE dbo.PhoneLocation (@phone VARCHAR(64), @OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT c.Country, s.State, lp.City, Lat, Long, lp.Telco
FROM LocPhones lp JOIN States s ON (lp.StateID = s.StateID)
	JOIN Countries c ON (s.CountryID = c.CountryID)
	JOIN Operators o ON (o.OperatorID = @OperatorID)
	WHERE c.TelLocPrefixLen IS NOT NULL
	AND lp.Prefix = SUBSTRING(@phone,1,c.TelLocPrefixLen)
	AND (o.CountryID IS NULL OR o.CountryID = c.CountryID OR 
			(o.CountryID IN (92,124,316,630,840) AND c.CountryID IN (92,124,316,630,840)))
GO

CREATE PROCEDURE dbo.PhoneSearch (@OperatorGroupID INT, @MBRGlobal INT, @phone VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #psa (CustomerID INT)

SELECT @phone = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@phone,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','')

INSERT INTO #psa (CustomerID)
SELECT DISTINCT CustomerID
FROM Addresses
	WHERE CustomerID IS NOT NULL
	AND ((REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneFax,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone)
	OR (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneHome,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone)
	OR (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneMobile,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone)
	OR (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneWork,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone))

SELECT ma.CustomerID, a.FirstName, a.LastName, a.Company, r.Region, (SELECT GroupName FROM Groups WHERE GroupID = ma.GroupID) AS GroupName, a.Address1, a.Address2, a.City, c.Country, s.State, a.Zip, ma.Active
FROM #psa psa JOIN MasterAccounts ma ON (psa.CustomerID = ma.CustomerID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN States s ON (a.StateID = s.StateID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	WHERE ma.Active IN (0,1)
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
ORDER BY ma.Active DESC, ma.CustomerID DESC
GO

CREATE PROCEDURE dbo.PosixFullNegSync @id VARCHAR(50) AS
SET NOCOUNT ON
SELECT COALESCE(pau.uidNumber,pau.PosixAccountUserID) AS uidNumber
FROM PosixAccountUsers pau JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID)
	WHERE pas.LDAPServer = @id
GO

CREATE PROCEDURE dbo.PosixGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
DECLARE @lmdate DATETIME, @calls INT
EXEC LDAPSetLastModifyDate 'read', @id

SELECT @lmdate = LastSyncWrite, @calls = Calls
FROM LDAPServers
	WHERE LDAPServer = @id

SELECT DISTINCT sa.AccountID as accountid, COALESCE(pau.uidNumber,pau.PosixAccountUserID+65535) AS uidnumber,
CASE	WHEN ma.Active = 0 OR sa.Active = 0 THEN 1
	WHEN (sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) THEN 1
	ELSE DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate)) END AS shadowexpire,
CASE WHEN al.Alias IS NOT NULL THEN NULL ELSE COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) END AS rfc822mailbox,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
COALESCE(a.FirstName,'') + ' ' + COALESCE(a.LastName,'') AS cn,
COALESCE(a.LastName,'N/A') as sn,
COALESCE(a.FirstName,'N/A') as gn,
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END AS uid,
CASE WHEN pau.userPassword <> '' THEN pau.userPassword ELSE sa.Password END AS userpassword,
COALESCE(pau.loginShell,pas.loginShell) AS loginshell,
COALESCE(pau.gidNumber,pas.gidNumber) AS gidNumber,
CASE WHEN pau.homeDirectory <> '' THEN pau.homeDirectory ELSE pas.homeDirectory + '/' + CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END END AS homedirectory,
d.MailDomain AS dc

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN PosixAccountUsers pau ON (sa.AccountID = pau.AccountID)
	JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID AND sa.AccountTypeID = pas.AccountTypeID)
	WHERE sa.Password <> ''
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)
	AND sa.Active IN (1,0)
	AND ma.Active IN (1,0)
	AND pas.LDAPServer = @id
GO

CREATE PROCEDURE dbo.PrintAddBatch (@type VARCHAR(16), @GroupID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchID INT, @ItemCount INT, @ItemTotal NUMERIC(18,4), @printzero NUMERIC(18,4), @batchmax INT

IF (@type = 'invoice' AND @GroupID IS NOT NULL)
BEGIN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, CreateUser, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(4,8,@GroupID,@Operator,getdate(),getdate(),@Operator,0,0)

SELECT @BatchID = SCOPE_IDENTITY()
SELECT @printzero = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 507 AND GroupID = @GroupID

SELECT @printzero = COALESCE(@printzero,NumValue) FROM Configs WHERE ConfigID = 507
SELECT @batchmax = COALESCE(NumValue,0) FROM Configs WHERE ConfigID = 622

SET ROWCOUNT @batchmax
UPDATE i SET PrintBatchID = @BatchID
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	WHERE ma.Active = 1
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.CreateDate > DATEADD(dd,-45,getdate())
	AND sm.PrintTypeID IS NOT NULL
	AND (sm.PrintInvoice IS NULL OR sm.PrintInvoice = 1)
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND i.PrintBatchID IS NULL
	AND i.PrintDate IS NULL
	AND ma.GroupID = @GroupID
	AND (@printzero = 1 OR i.ChargeAmount > i.PaidAmount)
SET ROWCOUNT 0

SELECT @ItemCount = COUNT(*), @ItemTotal = SUM(Amount)
FROM Invoices 
	WHERE PrintBatchID = @BatchID

IF (@ItemCount = 0)
	BEGIN
	DELETE FROM Batches WHERE BatchID = @BatchID
	SELECT @BatchID = NULL
	END ELSE BEGIN
	UPDATE Batches SET BatchStateID = 1, EndDate = getdate(), ItemCount = @ItemCount, ItemTotal = @ItemTotal WHERE BatchID = @BatchID
	END
END

IF (@type = 'statement' AND @GroupID IS NOT NULL)
BEGIN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, CreateUser, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(5,8,@GroupID,@Operator,getdate(),getdate(),@Operator,0,0)

SELECT @BatchID = SCOPE_IDENTITY()
SELECT @printzero = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 38 AND GroupID = @GroupID

SELECT @printzero = COALESCE(@printzero,NumValue) FROM Configs WHERE ConfigID = 38
SELECT @batchmax = COALESCE(NumValue,0) FROM Configs WHERE ConfigID = 627

SET ROWCOUNT @batchmax
UPDATE s SET PrintBatchID = @BatchID
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Statements s ON (ma.CustomerID = s.CustomerID AND ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
	AND sm.PrintTypeID IS NOT NULL
	AND (sm.PrintStatement IS NULL OR sm.PrintStatement = 1)
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND s.PrintBatchID IS NULL
	AND s.PrintDate IS NULL
	AND ma.GroupID = @GroupID
	AND ((@printzero = 1)
		OR (@printzero = 0 AND s.EndBal > 0) 
		OR (@printzero = 30 AND s.End30Bal + s.End60Bal + s.End90Bal + s.End120Bal > 0)
		OR (@printzero = 60 AND s.End60Bal + s.End90Bal + s.End120Bal > 0)
		OR (@printzero = 90 AND s.End90Bal + s.End120Bal > 0)
		OR (@printzero = 120 AND s.End120Bal > 0))
SET ROWCOUNT 0

SELECT @ItemCount = COUNT(*), @ItemTotal = SUM(EndBal)
FROM Statements
	WHERE PrintBatchID = @BatchID

IF (@ItemCount = 0)
	BEGIN
	DELETE FROM Batches WHERE BatchID = @BatchID
	SELECT @BatchID = NULL
	END ELSE BEGIN
	UPDATE Batches SET BatchStateID = 1, EndDate = getdate(), ItemCount = @ItemCount, ItemTotal = @ItemTotal WHERE BatchID = @BatchID
	END
END

SELECT @BatchID AS BatchID
GO

CREATE PROCEDURE dbo.PrintMarkSent (@BatchID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchTypeID INT
SELECT @BatchTypeID = BatchTypeID FROM Batches WHERE BatchID = @BatchID

IF (@BatchTypeID = 4)
BEGIN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = getdate(), LastModifyUser = @Operator WHERE BatchID = @BatchID

INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,CreateUser,LastModifyDate,LastModifyUser,AllowInterim)
SELECT i.CustomerID, ct.ChargeType, getdate(), getdate(), ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', getdate(), 'GBE',0
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN ChargeTypes ct ON (sm.ChargeTypeID = ct.ChargeTypeID)
	JOIN Batches b ON (i.PrintBatchID = b.BatchID)
	WHERE i.PrintBatchID = @BatchID
	AND i.PrintDate IS NULL
	AND i.VoidDate IS NULL
	AND b.Rebatch IS NULL
	AND i.CreateDate > DATEADD(dd,-10,getdate())

UPDATE Invoices SET PrintDate = getdate()
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NULL
END

IF (@BatchTypeID = 5)
BEGIN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = getdate(), LastModifyUser = @Operator WHERE BatchID = @BatchID

INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,CreateUser,LastModifyDate,LastModifyUser,AllowInterim)
SELECT s.CustomerID, ct.ChargeType, getdate(), getdate(), ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', getdate(), 'GBE',0
FROM Statements s JOIN MasterAccounts ma ON (s.CustomerID = ma.CustomerID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN ChargeTypes ct ON (sm.ChargeTypeID = ct.ChargeTypeID)
	JOIN Batches b ON (s.PrintBatchID = b.BatchID)
	WHERE s.PrintBatchID = @BatchID
	AND s.PrintDate IS NULL
	AND b.Rebatch IS NULL

UPDATE Statements SET PrintDate = getdate()
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NULL
END
GO

CREATE PROCEDURE dbo.PrintNoMarkSent (@BatchID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchTypeID INT
SELECT @BatchTypeID = BatchTypeID FROM Batches WHERE BatchID = @BatchID

IF (@BatchTypeID = 4)
BEGIN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = getdate(), LastModifyUser = @Operator, Rebatch = 1 WHERE BatchID = @BatchID

UPDATE Invoices SET PrintDate = NULL
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NOT NULL
END

IF (@BatchTypeID = 5)
BEGIN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = getdate(), LastModifyUser = @Operator, Rebatch = 1 WHERE BatchID = @BatchID

UPDATE Statements SET PrintDate = NULL
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NOT NULL
END
GO

CREATE PROCEDURE dbo.QmailFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.ExternalSystem = @id
GO

CREATE PROCEDURE dbo.QmailGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid, a.FirstName + ' ' + a.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
a.LastName AS sn,
a.FirstName AS givenname,
sa.Password AS userpassword,

CASE	WHEN sa.Active = 0 OR ma.Active = 0 THEN 'disabled'
	WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 'nopop'
	ELSE 'active'
END AS accountStatus,
CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,

CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress,
'./' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mailMessageStore,
CASE WHEN fw.Forward IS NULL THEN 'noforward' ELSE 'nolocal' END AS deliveryMode

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifyDate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.ExternalSystem = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

CREATE PROCEDURE dbo.CIBCExport (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @BatchID INT, @now DATETIME, @errmsg VARCHAR(512), @TranCntDebit INT, @TranSumDebit NUMERIC(18,4), @TranCntCredit INT, @TranSumCredit NUMERIC(18,4), @ShortName VARCHAR(128), @CPA VARCHAR(128), @OriginatorDebit VARCHAR(128), @OriginatorCredit VARCHAR(128), @CIBCAcct VARCHAR(128), @FIN VARCHAR(128), @Currency VARCHAR(5)

SELECT @ShortName = bp.Merchant, @CPA = COALESCE(bp.BatchAux1,'437'), @OriginatorDebit = COALESCE(bp.BatchAux2,bp.BatchAux3), @OriginatorCredit = COALESCE(bp.BatchAux3,bp.BatchAux2), @CIBCAcct = bp.Store, @FIN = bp.Terminal, @Currency = c.Code, @now = getdate()
FROM BatchProcessors bp LEFT JOIN Organizations o ON (bp.OrganizationID = o.OrganizationID)
	LEFT JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	WHERE bp.BatchProcessorID = @BatchProcessorID

IF (@Currency IS NULL)
BEGIN
SELECT @Currency = CASE WHEN MIN(c.Code) = MAX(c.Code) THEN MIN(c.Code) END
FROM Organizations o JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
END

IF (@errmsg IS NULL AND (@ShortName IS NULL OR DATALENGTH(@ShortName) > 15))
BEGIN
SELECT @errmsg = 'Company short name required and must not exceed 15 characters in length'
END

IF (@errmsg IS NULL AND (ISNUMERIC(@CPA) = 0 OR DATALENGTH(@CPA) <> 3))
BEGIN
SELECT @errmsg = 'CPA must be three digits in length'
END

IF (@errmsg IS NULL AND (@OriginatorDebit IS NULL OR DATALENGTH(@OriginatorDebit) <> 10))
BEGIN
SELECT @errmsg = 'Originator Number (Debit) must be 10 characters in length'
END

IF (@errmsg IS NULL AND (@OriginatorCredit IS NULL OR DATALENGTH(@OriginatorCredit) <> 10))
BEGIN
SELECT @errmsg = 'Originator Number (Credit) must be 10 characters in length'
END

IF (@errmsg IS NULL AND (@CIBCAcct IS NULL OR DATALENGTH(@CIBCAcct) <> 7))
BEGIN
SELECT @errmsg = 'CIBC account number must be 7 characters in length'
END

IF (@errmsg IS NULL AND (@FIN IS NULL OR DATALENGTH(@FIN) <> 9 OR @FIN NOT LIKE '0%'))
BEGIN
SELECT @errmsg = 'Financial institution number must be 9 characters (0 + institution (3 digit) + branch id (5 digit)) in length'
END

IF (@errmsg IS NULL AND @Currency IS NULL)
BEGIN
SELECT @errmsg = 'This batch processor must be assigned to an organization'
END

IF (@errmsg IS NULL AND @CustomerID IS NOT NULL)
BEGIN
SELECT @errmsg = 'Per-customer batches not supported for flat file export'
END

IF (@errmsg IS NOT NULL)
BEGIN
RAISERROR(@errmsg,11,1)
RETURN
END

CREATE TABLE #cibc (ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), AuthName VARCHAR(64))

INSERT INTO #cibc (ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,AuthName)
SELECT et.ExternalTransID, et.TransTypeID, et.BankNumber, et.AccountNumber, et.Amount, et.AuthName
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	WHERE et.TransStateID = 0
	AND et.TransTypeID IN (64,256)
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND bp.BatchProcessorID = @BatchProcessorID

SELECT @TranCntDebit = SUM(CASE WHEN TransTypeID = 64 THEN 1 ELSE 0 END),
@TranCntCredit = SUM(CASE WHEN TransTypeID = 256 THEN 1 ELSE 0 END),
@TranSumDebit = SUM(CASE WHEN TransTypeID = 64 THEN Amount ELSE 0 END),
@TranSumCredit = SUM(CASE WHEN TransTypeID = 256 THEN Amount ELSE 0 END)
FROM #cibc

IF (@TranCntDebit > 0 OR @TranCntCredit > 0)
BEGIN
INSERT INTO Batches (BatchTypeID,BatchStateID,GroupID,CreateUser,StartDate,EndDate,LastModifyDate,LastModifyUser,ItemCount,ItemTotal)
SELECT 6 AS BatchTypeID,3 AS BatchStateID, NULL AS GroupID,'batch' AS Operator,@now AS StartDate, @now AS EndDate, @now AS LastModifyDate, 'batch' AS LastModifyUser, @TranCntDebit + @TranCntCredit AS ItemCount, @TranSumDebit + @TranSumCredit AS ItemTotal

SELECT @BatchID = SCOPE_IDENTITY()
END

IF (@TranCntDebit > 0)
BEGIN
SELECT 134217728 AS TransTypeID, @OriginatorDebit AS Originator, RIGHT('00' + CAST(DATEPART(yy,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(mm,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(dd,@now) AS VARCHAR),2) AS FileDate, (@BatchID % 9998) + 1 AS FileNumber, @FIN AS FIN,
@CIBCAcct AS CIBCAcct, @ShortName AS ShortName, @Currency AS Currency, NULL AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, NULL AS TranCnt,
NULL AS TranSum, 'D' AS GroupName, @BatchID AS GroupID

UNION ALL

SELECT 16384 AS TransTypeID, NULL AS Originator, RIGHT('00' + CAST(DATEPART(yy,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(mm,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(dd,@now) AS VARCHAR),2) AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, @CPA AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, NULL AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID

UNION ALL

SELECT TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, NULL AS CPA, BankNumber,
AccountNumber, Amount, ExternalTransID, AuthName, NULL AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID
FROM #cibc
	WHERE TransTypeID = 64

UNION ALL

SELECT 32768 AS TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, @CPA AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, @TranCntDebit AS TranCnt,
@TranSumDebit AS TranSum, NULL AS GroupName, NULL AS GroupID

UNION ALL

SELECT 268435456 AS TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, NULL AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, @TranCntDebit AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID
END


IF (@TranCntCredit > 0)
BEGIN
SELECT 134217728 AS TransTypeID, @OriginatorCredit AS Originator, RIGHT('00' + CAST(DATEPART(yy,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(mm,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(dd,@now) AS VARCHAR),2) AS FileDate, (@BatchID % 9998) + 1 AS FileNumber, @FIN AS FIN,
@CIBCAcct AS CIBCAcct, @ShortName AS ShortName, @Currency AS Currency, NULL AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, NULL AS TranCnt,
NULL AS TranSum, 'C' AS GroupName, @BatchID AS GroupID

UNION ALL

SELECT 16384 AS TransTypeID, NULL AS Originator, RIGHT('00' + CAST(DATEPART(yy,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(mm,@now) AS VARCHAR),2) + RIGHT('00' + CAST(DATEPART(dd,@now) AS VARCHAR),2) AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, @CPA AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, NULL AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID

UNION ALL

SELECT TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, NULL AS CPA, BankNumber,
AccountNumber, Amount, ExternalTransID, AuthName, NULL AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID
FROM #cibc
	WHERE TransTypeID = 256

UNION ALL

SELECT 32768 AS TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, @CPA AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, @TranCntCredit AS TranCnt,
@TranSumCredit AS TranSum, NULL AS GroupName, NULL AS GroupID

UNION ALL

SELECT 268435456 AS TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, NULL AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, @TranCntCredit AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID
END

IF (@TranCntDebit > 0 OR @TranCntCredit > 0)
BEGIN
UPDATE et SET BatchOutID = @BatchID 
FROM ExternalTrans et JOIN #cibc c ON (et.ExternalTransID = c.ExternalTransID)
END ELSE BEGIN
SELECT 268435456 AS TransTypeID, NULL AS Originator, NULL AS FileDate, NULL AS FileNumber, NULL AS FIN,
NULL AS CIBCAcct, NULL AS ShortName, NULL AS Currency, NULL AS CPA, NULL AS BankNumber,
NULL AS AccountNumber, NULL AS Amount, NULL AS ExternalTransID, NULL AS AuthName, NULL AS TranCnt,
NULL AS TranSum, NULL AS GroupName, NULL AS GroupID
WHERE 1=0
END
GO

CREATE PROCEDURE dbo.RBCExport (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @BatchID INT

CREATE TABLE #rbse (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5))
CREATE TABLE #rbsed (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5), RecordCount INT IDENTITY, ItemCount INT, ItemTotal NUMERIC(18,4))
CREATE TABLE #rbsec (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5), RecordCount INT IDENTITY, ItemCount INT, ItemTotal NUMERIC(18,4))

IF (@CustomerID IS NULL)
BEGIN
INSERT INTO #rbse (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT bp.Merchant, 
bp.Store,
c.Code AS CurrencyCode,
bp.Login,
et.ExternalTransID, 
et.TransTypeID,
et.BankNumber, 
et.AccountNumber,
et.Amount,
et.ReqDate,
et.AuthName,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,a.StateID)) AS Country3

FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.Active IN (1,0)
	AND bp.BatchProcessorID = @BatchProcessorID

IF ((SELECT COUNT(*) FROM #rbse) > 0)
BEGIN
INSERT INTO Batches (BatchTypeID,BatchStateID,GroupID,CreateUser,StartDate,EndDate,LastModifyDate,LastModifyUser,ItemCount,ItemTotal)
SELECT 6 AS BatchTypeID,3 AS BatchStateID, NULL AS GroupID,'batch' AS Operator,getdate() AS StartDate, getdate() AS EndDate, getdate() AS LastModifyDate, 'batch' AS LastModifyUser, COUNT(*) AS ItemCount, SUM(Amount) AS ItemTotal
FROM #rbse
SELECT @BatchID = SCOPE_IDENTITY()

IF ((SELECT COUNT(*) FROM #rbse WHERE TransTypeID = 64) > 0)
BEGIN
INSERT INTO #rbsed (TransTypeID,Merchant,Store,CurrencyCode)
SELECT 16384,MIN(Merchant),MIN(Store),MIN(CurrencyCode) FROM #rbse WHERE TransTypeID = 64

INSERT INTO #rbsed (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3
FROM #rbse WHERE TransTypeID = 64

INSERT INTO #rbsed (TransTypeID,Merchant,ItemCount,ItemTotal)
SELECT 32768,MIN(Merchant),COUNT(*),SUM(Amount) FROM #rbse WHERE TransTypeID = 64

SELECT 'D' AS GroupName, '$$AAPASTD0152[PROD[NL$$' AS FileFormat, @BatchID % 9999 AS GroupID,RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,ItemCount,ItemTotal,
DATEPART(yyyy,getdate()) AS nowyyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(dd,-DATEPART(dd,getdate())+1,getdate())),getdate()) AS nowddd,
DATEPART(yyyy,DATEADD(dd,2,getdate())) AS now2yyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,DATEADD(dd,2,getdate()))+1,DATEADD(dd,-DATEPART(dd,DATEADD(dd,2,getdate()))+1,DATEADD(dd,2,getdate()))),DATEADD(dd,2,getdate())) AS now2ddd
FROM #rbsed
ORDER BY RecordCount
END

IF ((SELECT COUNT(*) FROM #rbse WHERE TransTypeID = 256) > 0)
BEGIN
INSERT INTO #rbsec (TransTypeID,Merchant,Store,CurrencyCode)
SELECT 16384,MIN(Merchant),MIN(Store),MIN(CurrencyCode) FROM #rbse WHERE TransTypeID = 256

INSERT INTO #rbsec (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3
FROM #rbse WHERE TransTypeID = 256

INSERT INTO #rbsec (TransTypeID,Merchant,ItemCount,ItemTotal)
SELECT 32768,MIN(Merchant),COUNT(*),SUM(Amount) FROM #rbse WHERE TransTypeID = 256

SELECT 'C' AS GroupName, '$$AAPDSTD0152[PROD[NL$$' AS FileFormat, @BatchID % 9999 AS GroupID,RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,ItemCount,ItemTotal,
DATEPART(yyyy,getdate()) AS nowyyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(dd,-DATEPART(dd,getdate())+1,getdate())),getdate()) AS nowddd,
DATEPART(yyyy,DATEADD(dd,2,getdate())) AS now2yyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,DATEADD(dd,2,getdate()))+1,DATEADD(dd,-DATEPART(dd,DATEADD(dd,2,getdate()))+1,DATEADD(dd,2,getdate()))),DATEADD(dd,2,getdate())) AS now2ddd
FROM #rbsec
ORDER BY RecordCount
END

UPDATE ExternalTrans SET BatchOutID = @BatchID WHERE ExternalTransID IN (SELECT ExternalTransID FROM #rbse)
END ELSE BEGIN
SELECT NULL AS GroupName, NULL AS FileFormat, NULL AS GroupID,NULL AS RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,NULL AS ItemCount,NULL AS ItemTotal,
NULL AS nowyyyy,NULL AS nowddd, NULL AS now2yyyy, NULL AS now2ddd
FROM #rbse
END
END 
GO

CREATE PROCEDURE dbo.RadATCopy (@SrcAccountTypeID INT, @DstAccountTypeID INT) AS
SET NOCOUNT ON
IF (@SrcAccountTypeID <> @DstAccountTypeID AND (SELECT COUNT(*) FROM AccountTypes WHERE AccountTypeID=@SrcAccountTypeID) > 0)
BEGIN
DELETE FROM RadATConfigs WHERE AccountTypeID = @DstAccountTypeID

INSERT INTO RadATConfigs (AccountTypeID,RadVendorID,RadAttributeID,RadMergeTypeID,RadFailReason,Parent,RadCheck,Tag,Data,SortOrder)
SELECT @DstAccountTypeID,RadVendorID,RadAttributeID,RadMergeTypeID,RadFailReason,Parent,RadCheck,Tag,Data,SortOrder
FROM RadATConfigs
	WHERE AccountTypeID = @SrcAccountTypeID
END
GO

CREATE PROCEDURE dbo.RadAtCache (@AccountTypeID VARCHAR(10)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CAST(at1.AccountTypeID AS VARCHAR(10)) AS AccountType, at1.AccountTypeID, rac.RadVendorID, rac.RadAttributeID, rac.RadMergeTypeID, rac.RadFailReason, rac.RadCheck, rac.Tag, rac.Data, at1.RateClassID, at1.DataLeftAuth
FROM AccountTypes at1 LEFT JOIN RadATConfigs rac ON (at1.AccountTypeID = rac.AccountTypeID AND rac.Parent = 0)
	WHERE at1.AllowRADIUS = 1
	AND (@AccountTypeID IS NULL OR at1.AccountTypeID = CAST(@AccountTypeID AS INT))
ORDER BY at1.AccountTypeID, rac.RadATConfigID
GO

CREATE PROCEDURE dbo.RadAttributeGet (@RadVendorID INT, @RadAttributeID INT) AS
SET NOCOUNT ON
SELECT Name AS Attribute, RadAttributeType, CASE WHEN RadAttributeID > 255 OR RadAttributeType IN (10,11,12,13,14) THEN 1 END AS Tag 
FROM RadAttributes 
	WHERE RadVendorID = @RadVendorID
	AND RadAttributeID = @RadAttributeID
GO

CREATE PROCEDURE dbo.RadCheckOnline (@Username varchar(64), @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @GroupID INT, @LoginLimit INT, @Connections INT, @ConnectionsMax INT, @AccountTypeID INT, @RadConcurrencyID INT

SELECT @AccountTypeID = sa.AccountTypeID, @LoginLimit = sa.LoginLimit, @GroupID = ma.GroupID 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	WHERE sa.AccountID = @AccountID

SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
FROM RadConcurrency
	WHERE GroupID = @GroupID
	AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)

IF (@RadConcurrencyID IS NOT NULL)
BEGIN
IF (@Connections >= @ConnectionsMax)
	BEGIN
	SELECT @Connections, @ConnectionsMax
	END ELSE BEGIN
	SELECT COUNT(*) 
		FROM ServerPorts 
			WHERE AccountID = @AccountID 
	END
END ELSE BEGIN
	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID = @AccountID 
END
GO

CREATE PROCEDURE dbo.RadCheckOnlineCallerID (@Username varchar(64), @AccountID INT, @CallingStationID VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @LoginLimit INT, @Connections INT, @ConnectionsMax INT, @AccountTypeID INT, @RadConcurrencyID INT

IF (@CallingStationID IS NOT NULL)
BEGIN
DELETE FROM ServerPorts WHERE CallStartID IN 
	(
	SELECT sp.CallStartID 
	FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
		WHERE cs.CallingStationID = @CallingStationID 
		AND sp.AccountID = @AccountID
	)
END

SELECT @AccountTypeID = sa.AccountTypeID, @LoginLimit = sa.LoginLimit, @GroupID = ma.GroupID 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	WHERE sa.AccountID = @AccountID

SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
FROM RadConcurrency
	WHERE GroupID = @GroupID
	AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)

IF (@RadConcurrencyID IS NOT NULL)
BEGIN
IF (@Connections >= @ConnectionsMax)
	BEGIN
	SELECT @Connections, @ConnectionsMax
	END ELSE BEGIN
	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID = @AccountID 
	END
END ELSE BEGIN
	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID = @AccountID 
END
GO

CREATE PROCEDURE dbo.RadClearNAS (@NASIdentifier VARCHAR(45), @CallDate DATETIME) AS
SET NOCOUNT ON

DELETE FROM sp 
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	WHERE cs.NASIdentifier = @NASIdentifier
	AND cs.CallDate <= @CallDate
GO

CREATE PROCEDURE dbo.RadClearPorts (@NASIdentifier VARCHAR(45)) AS
SET NOCOUNT ON

IF (@NASIdentifier IS NULL)
BEGIN
DELETE FROM ServerPorts
END ELSE BEGIN
DELETE FROM sp
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	WHERE cs.NASIdentifier = @NASIdentifier
END
GO

CREATE PROCEDURE dbo.RadClearInterim (@missthresh INT, @maxthresh INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #rci (CallStartID BIGINT NOT NULL)

IF (@missthresh > 1)
BEGIN
INSERT INTO #rci (CallStartID)
SELECT cs.CallStartID
FROM CallStarts cs JOIN CallInterims ci ON (cs.CallStartID = ci.CallStartID)
	JOIN ServerPorts sp ON (cs.CallStartID = sp.CallStartID)
	WHERE ci.AcctSessionTime > 60
	AND sp.AcctSessionTime > 0
GROUP BY cs.CallStartID
HAVING (MAX(ci.AcctSessionTime) / COUNT(*) * @missthresh) + MAX(ci.AcctSessionTime) < DATEDIFF(ss,MIN(cs.CallDate),getdate()) - 3600
END

IF (@maxthresh > 300)
BEGIN
INSERT INTO #rci (CallStartID)
SELECT cs.CallStartID
FROM CallStarts cs JOIN ServerPorts sp ON (cs.CallStartID = sp.CallStartID)
	WHERE sp.AcctSessionTime = 0
	AND cs.CallDate < DATEADD(ss,-@maxthresh,getdate())
END

ALTER TABLE #rci ADD PRIMARY KEY (CallStartID)
DELETE FROM ServerPorts
FROM ServerPorts sp JOIN #rci i ON (sp.CallStartID = i.CallStartID)

SELECT CAST(@@ROWCOUNT AS VARCHAR(20)) + ' sessions removed' AS Description
GO

CREATE PROCEDURE dbo.RadConcurrencySync AS
SET NOCOUNT ON

UPDATE rc SET LastSyncDate = getdate(), Connections = COALESCE(s.Connections,0)
FROM RadConcurrency rc LEFT JOIN
	(
	SELECT rc.RadConcurrencyID, COUNT(*) AS Connections 
	FROM ServerPorts sp JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
		JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
		JOIN RadConcurrency rc ON (rc.GroupID = ma.GroupID AND (rc.AccountTypeID IS NULL OR sa.AccountTypeID = rc.AccountTypeID))
	GROUP BY rc.RadConcurrencyID
	) s ON (rc.RadConcurrencyID = s.RadConcurrencyID)
GO

CREATE PROCEDURE dbo.RadDNISCache AS
SET NOCOUNT ON
SELECT CAST(at1.AccountTypeID AS VARCHAR) AS AccountType, dn.DNISNumber
FROM AccountTypes at1 JOIN DNISNumbers dn ON (at1.DNISGroupID = dn.DNISGroupID)
UNION ALL
SELECT CAST(AccountTypeID AS VARCHAR), NULL
FROM AccountTypes
	WHERE DNISGroupID IS NULL
GO

CREATE PROCEDURE dbo.RadGetCacheUsers (@ldate DATETIME, @flag SMALLINT)  AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@flag = 1)
BEGIN
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft, 
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.LastModifyDate > @ldate
UNION
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login + '@' + d.MailDomain, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft, 
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE 	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.LastModifyDate > @ldate
UNION
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft,
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND ma.LastModifyDate > @ldate
UNION
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login + '@' + d.MailDomain, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft, 
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE 	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND ma.LastModifyDate > @ldate

END ELSE IF (@flag = 2)
BEGIN
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft, 
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
UNION ALL
SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, sa.Login + '@' + d.MailDomain, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, sa.LoginLimit,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft,
sa.CancelDate AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + CASE WHEN sa.CancelDate <= sa.ExpireDate OR ma.CancelDate <= sa.ExpireDate THEN 0 ELSE sa.Extension + ma.TempExtension END,sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
CASE 	WHEN EXISTS (SELECT * FROM RadConfigs rc WHERE rc.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccounts sa2, RadATConfigs ratc WHERE sa2.ParentAccountID = COALESCE(sap.AccountID,sa.AccountID) AND sa2.AccountTypeID = ratc.AccountTypeID AND sa2.Active = 1 AND ratc.Parent = 1) THEN 1
	WHEN EXISTS (SELECT * FROM SubAccountTags sat, MarketTagAttributes mta WHERE sat.MarketTagID = mta.MarketTagID AND sat.Active = 1 AND sat.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
	WHEN EXISTS (SELECT * FROM InvItems ii, InvProducts ip, InvStates is1, RadInvConfigs ric WHERE ii.InvProductID = ip.InvProductID AND ii.InvStateID = is1.InvStateID AND ip.InvSourceID = ric.InvSourceID AND is1.InvStateTypeID = 3 AND ii.AccountID = COALESCE(sap.AccountID,sa.AccountID)) THEN 1
ELSE 0 END AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
END
GO

CREATE PROCEDURE dbo.RadGetConfigs (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @EnableATConfigs INT, @AccountTypeID INT
CREATE TABLE #rgc (AccountID INT PRIMARY KEY, AccountTypeID INT NOT NULL, Parent TINYINT NOT NULL)

SELECT @EnableATConfigs = EnableATConfigs, @AccountTypeID = AccountTypeID 
FROM SubAccounts 
	WHERE AccountID = @AccountID

INSERT INTO #rgc (AccountID,AccountTypeID,Parent)
SELECT @AccountID, @AccountTypeID, 0

UNION ALL

SELECT sa.AccountID, sa.AccountTypeID, 1
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND sa.ParentAccountID = @AccountID

SELECT 0 + rgc.Parent AS Order1, rac.AccountTypeID AS Order2, rac.SortOrder AS Order3, rac.RadATConfigID AS Order4, rac.RadVendorID, rac.RadAttributeID, rac.RadMergeTypeID, rac.RadCheck, rac.Tag, rac.Data
FROM #rgc rgc JOIN RadATConfigs rac ON (rgc.AccountTypeID = rac.AccountTypeID AND rgc.Parent = rac.Parent)
	WHERE @EnableATConfigs = 1
	AND rac.RadFailReason = 0

UNION ALL

SELECT 2 + rgc.Parent AS Order1, rc.SortOrder AS Order2, rc.RadConfigID AS Order3, 0 AS Order4, rc.RadVendorID, rc.RadAttributeID, rc.RadMergeTypeID, rc.RadCheck, rc.Tag, rc.Data
FROM #rgc rgc JOIN RadConfigs rc ON (rgc.AccountID = rc.AccountID AND rgc.Parent = rc.Parent)

UNION ALL

SELECT 4 + rgc.Parent AS Order1, mta.MarketTagID AS Order2, mta.SortOrder AS Order3, mta.MarketTagAttributeID AS Order4, mta.RadVendorID, mta.RadAttributeID, mta.RadMergeTypeID, 0 AS RadCheck, mta.Tag, mta.Data
FROM #rgc rgc JOIN SubAccountTags sat ON (rgc.AccountID = sat.AccountID)
	JOIN MarketTagAttributes mta ON (sat.MarketTagID = mta.MarketTagID AND rgc.Parent = mta.Parent)
	WHERE sat.Active = 1

UNION ALL

SELECT 6 + rgc.Parent AS Order1, ric.InvSourceID AS Order2, ric.SortOrder AS Order3, ric.RadInvConfigID AS Order4, ric.RadVendorID, ric.RadAttributeID, ric.RadMergeTypeID, ric.RadCheck, ric.Tag, COALESCE(iv.RadData,iv.Data,iid.Data,CASE WHEN ric.Data = '$serialnumber' THEN ii.SerialNumber END,ric.Data) AS Data
FROM #rgc rgc JOIN InvItems ii ON (rgc.AccountID = ii.AccountID)
	JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN RadInvConfigs ric ON (ip.InvSourceID = ric.InvSourceID AND rgc.Parent = ric.Parent)
	LEFT JOIN InvItemData iid ON (ii.InvItemID = iid.InvItemID AND ric.InvAttributeID = iid.InvAttributeID)
	LEFT JOIN InvValues iv ON (iid.InvValueID = iv.InvValueID)
	WHERE is1.InvStateTypeID = 3
	AND (iv.Data IS NOT NULL OR ric.Data IS NOT NULL OR iid.Data IS NOT NULL)

ORDER BY 1,2,3,4
GO

CREATE PROCEDURE dbo.RadGetFilterGroups AS
SET NOCOUNT ON
SELECT RadFilterGroupID, RadSourceTypeID, RadDestTypeID, DestRadFilterGroupID, DestData
FROM RadFilterGroups
	WHERE Active = 1 OR RadSourceTypeID = 1
ORDER BY SortOrder DESC,RadFilterGroup DESC
GO

CREATE PROCEDURE dbo.RadGetFilters (@RadFilterGroupID INT) AS
SET NOCOUNT ON
SELECT RadFilterTypeID, RadVendorID, RadAttributeID, RadSearchTypeID, RadMergeTypeID, Location, Data
FROM RadFilters
	WHERE RadFilterGroupID = @RadFilterGroupID
ORDER BY RadFilterID DESC
GO

CREATE PROCEDURE dbo.RadGetPoolConfigs (@AccountID INT, @ClientServerID INT, @AcctSessionID VARCHAR(40), @CallingStationID VARCHAR(64), @NASIdentifier VARCHAR(64), @NASPort VARCHAR(32)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @NASServerID INT, @ServerGroupID INT, @RadPoolConfigsIP4 INT, @RadPoolConfigsIP6 INT, @RadPoolConfigsInt INT, @InvSourceTypeID INT, @RadPoolConfigID INT, @CustomerID INT
SELECT @NASServerID = ServerID FROM Servers WHERE IPAddress = @NASIdentifier
SELECT @CustomerID = CustomerID FROM SubAccounts WHERE AccountID = @AccountID
SELECT @ServerGroupID = ServerGroupID FROM Servers WHERE ServerID = COALESCE(@NASServerID,@ClientServerID)

CREATE TABLE #rgpc (RadPoolConfigID INT, InvStateID INT, InvItemID INT)

IF ((SELECT COUNT(*) FROM RadPoolStates WHERE AccountID = @AccountID AND ((@AcctSessionID IS NULL AND AcctSessionID IS NULL) OR (AcctSessionID = @AcctSessionID)) AND ((@CallingStationID IS NULL AND CallingStationID IS NULL) OR (CallingStationID = @CallingStationID)) AND NASIdentifier = @NASIdentifier) > 0)
BEGIN
SELECT ric.RadVendorID AS VendorID, ric.RadAttributeID AS AttributeID, ric.RadMergeTypeID, ric.RadCheck, ric.Tag, COALESCE(iv.RadData,iv.Data,iid.Data,CASE WHEN ric.Data = '$serialnumber' THEN ii.SerialNumber END,ric.Data) AS Data
FROM RadPoolStates rps JOIN InvItems ii ON (rps.InvItemID = ii.InvItemID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN RadInvConfigs ric ON (ip.InvSourceID = ric.InvSourceID)
	LEFT JOIN InvItemData iid ON (ii.InvItemID = iid.InvItemID AND ric.InvAttributeID = iid.InvAttributeID)
	LEFT JOIN InvValues iv ON (iid.InvValueID = iv.InvValueID)
	WHERE rps.AccountID = @AccountID
	AND ii.AccountID = @AccountID
	AND is1.InvStateTypeID = 4
	AND ((@AcctSessionID IS NULL AND rps.AcctSessionID IS NULL) OR (rps.AcctSessionID = @AcctSessionID))
	AND ((@CallingStationID IS NULL AND rps.CallingStationID IS NULL) OR (rps.CallingStationID = @CallingStationID))
	AND rps.NASIdentifier = @NASIdentifier
	AND (iv.Data IS NOT NULL OR ric.Data IS NOT NULL OR iid.Data IS NOT NULL)
ORDER BY ric.InvSourceID, ric.SortOrder, ric.RadInvConfigID

END ELSE BEGIN

DECLARE ci CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
SELECT is1.InvSourceTypeID, rpc.RadPoolConfigID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	CROSS JOIN RadPoolConfigs rpc
	JOIN InvProducts ip ON (rpc.InvProductID = ip.InvProductID)
	JOIN InvSources is1 ON (ip.InvSourceID = is1.InvSourceID)
	WHERE sa.AccountID = @AccountID
	AND (rpc.GroupID IS NULL OR ma.GroupID = rpc.GroupID)
	AND (rpc.ServiceCategoryID IS NULL OR sa.ServiceCategoryID = rpc.ServiceCategoryID)
	AND (rpc.AccountTypeID IS NULL OR sa.AccountTypeID = rpc.AccountTypeID)
	AND (rpc.MarketTagID IS NULL 
		OR EXISTS (SELECT * FROM MasterAccountTags mat WHERE mat.CustomerID = sa.CustomerID AND mat.Active = 1 AND mat.MarketTagID = rpc.MarketTagID)
		OR EXISTS (SELECT * FROM SubAccountTags sat WHERE sat.AccountID = sa.AccountID AND sat.Active = 1 AND sat.MarketTagID = rpc.MarketTagID))
	AND (rpc.TowerID IS NULL OR sa.TowerID = rpc.TowerID)
	AND (rpc.ServerGroupID IS NULL OR @ServerGroupID = rpc.ServerGroupID)
	AND (rpc.ServerID IS NULL OR COALESCE(@NASServerID,@ClientServerID) = rpc.ServerID)
	AND rpc.Active = 1
	AND NOT EXISTS
		(
		SELECT * 
		FROM InvItems ii2 JOIN InvStates st2 ON (ii2.InvStateID = st2.InvStateID)
			JOIN InvProducts ip2 ON (ii2.InvProductID = ip2.InvProductID)
			WHERE ii2.AccountID = @AccountID
			AND st2.InvStateTypeID = 3
			AND ip2.InvSourceID = ip.InvSourceID
		)
ORDER BY rpc.PriorityID DESC,
CASE WHEN rpc.AccountTypeID IS NOT NULL AND rpc.ServiceCategoryID IS NOT NULL THEN 3 WHEN rpc.AccountTypeID IS NOT NULL THEN 2 WHEN rpc.ServiceCategoryID IS NOT NULL THEN 1 ELSE 0 END DESC,
CASE WHEN rpc.ServerID IS NOT NULL AND rpc.ServerGroupID IS NOT NULL THEN 3 WHEN rpc.ServerID IS NOT NULL THEN 2 WHEN rpc.ServerGroupID IS NOT NULL THEN 1 ELSE 0 END DESC,
CASE WHEN rpc.TowerID IS NOT NULL AND rpc.GroupID IS NOT NULL THEN 3 WHEN rpc.TowerID IS NOT NULL THEN 2 WHEN rpc.GroupID IS NOT NULL THEN 1 ELSE 0 END DESC

OPEN ci
goto onefetch
WHILE (@@FETCH_STATUS = 0)
BEGIN
IF (@RadPoolConfigsIP4 IS NULL AND @InvSourceTypeID = 4)
	BEGIN
	SELECT @RadPoolConfigsIP4 = @RadPoolConfigID
	END
IF (@RadPoolConfigsIP6 IS NULL AND @InvSourceTypeID = 5)
	BEGIN
	SELECT @RadPoolConfigsIP6 = @RadPoolConfigID
	END
IF (@RadPoolConfigsInt IS NULL AND @InvSourceTypeID = 6)
	BEGIN
	SELECT @RadPoolConfigsInt = @RadPoolConfigID
	END

onefetch:
FETCH NEXT FROM ci INTO @InvSourceTypeID, @RadPoolConfigID
END
CLOSE ci
DEALLOCATE ci

INSERT INTO #rgpc (RadPoolConfigID,InvItemID,InvStateID)
SELECT aii.RadPoolConfigID, ii.InvItemID, ii.InvStateID
FROM InvItems ii JOIN
	(
	SELECT rpc.RadPoolConfigID, MIN(ii.InvItemID) AS InvItemID
	FROM InvItems ii JOIN RadPoolConfigs rpc ON (ii.InvProductID = rpc.InvProductID)
		JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
		WHERE is1.InvStateTypeID = 1
		AND rpc.RadPoolConfigID IN (@RadPoolConfigsIP4,@RadPoolConfigsIP6,@RadPoolConfigsInt)
	GROUP BY rpc.RadPoolConfigID
	) aii ON (aii.InvItemID = ii.InvItemID)

SET TRANSACTION ISOLATION LEVEL READ COMMITTED

UPDATE ii SET AssignDate = getdate(), AssignUser = 'RADIUS', CustomerID = @CustomerID, AccountID = @AccountID, InvStateID = rpc.InvStateID
FROM InvItems ii JOIN #rgpc rgpc ON (ii.InvItemID = rgpc.InvItemID)
	JOIN RadPoolConfigs rpc ON (rgpc.RadPoolConfigID = rpc.RadPoolConfigID)
	WHERE ii.InvStateID = rgpc.InvStateID
	AND ii.InvProductID = rpc.InvProductID

INSERT INTO RadPoolStates (AccountID,AcctSessionID,CallingStationID,NASIdentifier,CreateDate,RadPoolConfigID,InvItemID,OrigInvStateID)
SELECT @AccountID,@AcctSessionID,@CallingStationID,@NASIdentifier,getdate(),rgpc.RadPoolConfigID,rgpc.InvItemID,rgpc.InvStateID
FROM InvItems ii JOIN #rgpc rgpc ON (ii.InvItemID = rgpc.InvItemID)
	WHERE ii.AccountID = @AccountID

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ric.RadVendorID AS VendorID, ric.RadAttributeID AS AttributeID, ric.RadMergeTypeID, ric.RadCheck, ric.Tag, COALESCE(iv.RadData,iv.Data,iid.Data,CASE WHEN ric.Data = '$serialnumber' THEN ii.SerialNumber END,ric.Data) AS Data
FROM InvItems ii JOIN #rgpc rgpc ON (ii.InvItemID = rgpc.InvItemID)
	JOIN RadPoolConfigs rpc ON (rgpc.RadPoolConfigID = rpc.RadPoolConfigID)
	JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN RadInvConfigs ric ON (ip.InvSourceID = ric.InvSourceID)
	LEFT JOIN InvItemData iid ON (ii.InvItemID = iid.InvItemID AND ric.InvAttributeID = iid.InvAttributeID)
	LEFT JOIN InvValues iv ON (iid.InvValueID = iv.InvValueID)
	WHERE ii.InvStateID = rpc.InvStateID
	AND ii.InvProductID = rpc.InvProductID
	AND ii.InvStateID <> rgpc.InvStateID
	AND ii.AccountID = @AccountID
	AND (iv.Data IS NOT NULL OR ric.Data IS NOT NULL OR iid.Data IS NOT NULL)
ORDER BY ric.InvSourceID, ric.SortOrder, ric.RadInvConfigID
END
GO

CREATE PROCEDURE dbo.RadPoolUpdate AS
SET NOCOUNT ON
DECLARE @resets INT, @states INT

UPDATE ii SET AssignDate = NULL, AssignUser = NULL, CustomerID = NULL, AccountID = NULL, InvStateID = rps.OrigInvStateID
FROM RadPoolStates rps JOIN RadPoolConfigs rpc ON (rps.RadPoolConfigID = rpc.RadPoolConfigID)
	JOIN InvItems ii ON (rps.InvItemID = ii.InvItemID AND rpc.InvStateID = ii.InvStateID AND rps.AccountID = ii.AccountID)
	WHERE rps.CreateDate < DATEADD(mi,-CASE WHEN rpc.ReleaseMins < 2 THEN 2 ELSE rpc.ReleaseMins END,getdate())	
	AND NOT EXISTS (SELECT * FROM ServerPorts sp JOIN CallStarts cs ON (sp.AccountID = rps.AccountID AND sp.CallStartID = cs.CallStartID AND (rps.AcctSessionID IS NULL OR rps.AcctSessionID = cs.AcctSessionID) AND (rps.CallingStationID IS NULL OR rps.CallingStationID = cs.CallingStationID) AND rps.NASIdentifier = cs.NASIdentifier))

SELECT @resets = @@ROWCOUNT

DELETE FROM rps
FROM RadPoolStates rps JOIN InvItems ii ON (rps.InvItemID = ii.InvItemID)
	WHERE (ii.AccountID IS NULL OR rps.AccountID <> ii.AccountID)

SELECT @states = @@ROWCOUNT

SELECT 'Resets:' + CAST(@resets AS VARCHAR(20)) + ', States:' + CAST(@states AS VARCHAR(20)) AS Description
GO

CREATE PROCEDURE dbo.RadGetProxyAttributes AS
SET NOCOUNT ON
SELECT apg.RadProxyAttributeGroupID,apg.RadRoamServerID,ap.String,ap.RadSearchTypeID AS SearchType,ap.RadAttributeID, ap.RadVendorID
FROM RadProxyAttributeGroups apg JOIN RadProxyAttributes ap ON (apg.RadProxyAttributeGroupID = ap.RadProxyAttributeGroupID)
ORDER BY apg.Priority ASC, apg.RadProxyAttributeGroupID
GO

CREATE PROCEDURE dbo.RadGetRejectAttributes AS
SET NOCOUNT ON
SELECT RadLogMsgID,ServerID,RadVendorID,RadAttributeID,Data
FROM RadRejectAttributes
GO

CREATE PROCEDURE dbo.RadGetRejects AS
SET NOCOUNT ON
SELECT ra.RadAttributeID, ra.Name, rr.Data, ra.RadAttributeType, rr.RadVendorID
FROM RadAttributes ra JOIN RadRejects rr ON (ra.RadVendorID = rr.RadVendorID AND ra.RadAttributeID = rr.RadAttributeID)
ORDER BY rr.Data
GO

CREATE PROCEDURE dbo.RadGetUser (@user VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @AddressID INT, @CustomerID INT, @AccountID INT, @CardAccountID INT, @userp VARCHAR(64), @domainp VARCHAR(64), @mac VARCHAR(64), @chkcard INT
SELECT @userp = CASE WHEN @user LIKE '%@%' THEN SUBSTRING(@user,1,CHARINDEX('@',@user)-1) END, 
	@domainp = CASE WHEN @user LIKE '%@%' THEN SUBSTRING(@user,CHARINDEX('@',@user)+1,DATALENGTH(@user)) END,
	@mac = CASE 
	WHEN @user LIKE '[0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f][:-][0-9a-f][0-9a-f]' THEN REPLACE(REPLACE(@user,'-',''),':','')
	WHEN @user LIKE '[0-9a-f][0-9a-f][0-9a-f][0-9a-f].[0-9a-f][0-9a-f][0-9a-f][0-9a-f].[0-9a-f][0-9a-f][0-9a-f][0-9a-f]' THEN REPLACE(@user,'.','')
	ELSE @user END

CREATE TABLE #rgusa (AccountID INT NOT NULL, ParentAccountID INT, EnableRGC TINYINT NOT NULL)
CREATE TABLE #rgusac (ParentAccountID INT NOT NULL, AccountID INT NOT NULL, AccountTypeID INT NOT NULL)

SELECT @CardAccountID = MAX(CardAccountID)
FROM CardAccounts
	WHERE Login = COALESCE(@userp,@user)
	AND Active = 1
	AND AllowDirect = 1
	AND UsedForCredit = 0
	AND UsedForDirect = 0
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > getdate())

IF (@CardAccountID IS NOT NULL)
	BEGIN
	SELECT @chkcard = COUNT(*) 
	FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
		JOIN BillingCycles bc ON (cb.BillingCycleID = bc.BillingCycleID)
		WHERE cb.Active = 1
		AND ca.Active = 1
		AND ca.AllowDirect = 1
		AND ca.UsedForCredit = 0
		AND ca.UsedForDirect = 0
		AND cb.PayPeriodID IS NOT NULL
		AND cb.SendMethodID IS NOT NULL
		AND bc.AutoBill = 2
		AND cb.ServiceCategoryID IS NOT NULL
		AND cb.AccountTypeID IS NOT NULL
		AND cb.DomainID IS NOT NULL
		AND ca.CardAccountID = @CardAccountID
	IF (@chkcard = 1)
		BEGIN
		UPDATE CardAccounts SET AllowDirect = 0, UsedForDirect = 1 WHERE CardAccountID = @CardAccountID AND UsedForDirect = 0

		IF (@@ROWCOUNT = 1)
			BEGIN
			INSERT INTO MasterAccounts (SalesPersonID, CreateDate, StartDate, Active, PayPeriodID, PaymentTypeID, Comments, GroupID, RegionID, SendMethodID, BillingCycleID, BillDay, Balance, PendingBalance,CreateUser, LastModifyDate, LastModifyUser)
			SELECT cb.SalesPersonID, getdate(), getdate(), 1, cb.PayPeriodID, 1, 'prepaid auto', cb.GroupID, (SELECT MIN(RegionID) FROM Regions), cb.SendMethodID, cb.BillingCycleID, DATEPART(dd,getdate()),0, -(COALESCE(cb.DirectAmount,0)), 'prepaid auto', getdate(), 'prepaid auto'
			FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
				JOIN Groups g ON (cb.GroupID = g.GroupID)
				WHERE ca.CardAccountID = @CardAccountID

			SELECT @CustomerID = SCOPE_IDENTITY()

			INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
			SELECT CustomerID, -(PendingBalance),getdate(),NULL,32,'prepaid direct credit',0,getdate(),'prepaid auto'
			FROM MasterAccounts
				WHERE CustomerID = @CustomerID
				AND PendingBalance < 0

			INSERT INTO SubAccounts (CustomerID, Login, ServiceCategoryID, AccountTypeID, PayPeriodID, Comments, Password, CreateDate, StartDate, BilledThru, ExpireDate, Extension, Active, SalesPersonID, CreateUser, LastModifyDate, LastModifyUser, TimeLeft, DataLeft, SendBill, RemoteAccess, LoginLimit, DomainID)
			SELECT @CustomerID, ca.Login, cb.ServiceCategoryID, cb.AccountTypeID, cb.PayPeriodID, 'prepaid auto', ca.Password, getdate(), getdate(), DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),getdate())), DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),getdate())), 0, 1, cb.SalesPersonID, 'prepaid auto', getdate(), 'prepaid auto', cb.TimeLeft, cb.DataLeft, 1, 2, at1.LoginLimit, cb.DomainID
			FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
				JOIN Groups g ON (cb.GroupID = g.GroupID)
				JOIN AccountTypes at1 ON (cb.AccountTypeID = at1.AccountTypeID)
				WHERE ca.CardAccountID = @CardAccountID

			SELECT @AccountID = SCOPE_IDENTITY()

			UPDATE CardAccounts SET DirectCustomerID = @CustomerID, DirectAccountID = @AccountID, AllowDirect = 0, UsedForDirect = 1, AllowCredit = 0, FirstUseDate = getdate() WHERE CardAccountID = @CardAccountID
			END
		END
	END

INSERT INTO #rgusa (AccountID,ParentAccountID,EnableRGC)
SELECT sa.AccountID,sap.AccountID AS ParentAccountID,0
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	WHERE sa.Login IN (@user,@mac)
	AND @user IS NOT NULL
	AND @user <> ' '
UNION
SELECT sa.AccountID,sap.AccountID AS ParentAccountID,0
FROM SubAccounts sa JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccounts sap ON (at1.LogonAsParent = 1 AND sa.ParentAccountID = sap.AccountID)
	WHERE sa.Login = @userp
	AND d.MailDomain = @domainp
	AND @userp IS NOT NULL
	AND @domainp IS NOT NULL
	AND @userp <> ' '
	AND @domainp <> ' '

UPDATE rgusa SET EnableRGC = 1
FROM #rgusa rgusa
	WHERE EXISTS
		(
		SELECT * 
		FROM RadConfigs rc
			WHERE rc.AccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
			AND rc.Parent = 0
		)

UPDATE rgusa SET EnableRGC = 1
FROM #rgusa rgusa
	WHERE rgusa.EnableRGC = 0
	AND EXISTS
		(
		SELECT * 
		FROM SubAccountTags sat JOIN MarketTagAttributes mta ON (sat.MarketTagID = mta.MarketTagID)
			WHERE sat.AccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
			AND sat.Active = 1
			AND mta.Parent = 0
		)

UPDATE rgusa SET EnableRGC = 1
FROM #rgusa rgusa
	WHERE rgusa.EnableRGC = 0
	AND EXISTS
		(
		SELECT * 
		FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
			JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
			JOIN RadInvConfigs ric ON (ip.InvSourceID = ric.InvSourceID)
			WHERE ii.AccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
			AND is1.InvStateTypeID = 3 
			AND ric.Parent = 0
		)

INSERT INTO #rgusac (ParentAccountID, AccountID, AccountTypeID)
SELECT sa.ParentAccountID, sa.AccountID, sa.AccountTypeID
FROM #rgusa rgusa JOIN SubAccounts sa ON (sa.ParentAccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID))
	WHERE sa.Active = 1
	AND rgusa.EnableRGC = 0

IF (@@ROWCOUNT > 0)
	BEGIN
	UPDATE rgusa SET EnableRGC = 1
	FROM #rgusa rgusa
		WHERE rgusa.EnableRGC = 0
		AND EXISTS
			(
			SELECT * 
			FROM #rgusac rgusac JOIN RadATConfigs ratc ON (rgusac.AccountTypeID = ratc.AccountTypeID)
				WHERE rgusac.ParentAccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID) 
				AND ratc.Parent = 1
			)
	
	UPDATE rgusa SET EnableRGC = 1
	FROM #rgusa rgusa
		WHERE rgusa.EnableRGC = 0
		AND EXISTS
			(
			SELECT * 
			FROM #rgusac rgusac JOIN RadConfigs rc ON (rgusac.AccountID = rc.AccountID)
				WHERE rgusac.ParentAccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
				AND rc.Parent = 1
			)
	
	UPDATE rgusa SET EnableRGC = 1
	FROM #rgusa rgusa
		WHERE rgusa.EnableRGC = 0
		AND EXISTS
			(
			SELECT * 
			FROM #rgusac rgusac JOIN SubAccountTags sat ON (rgusac.AccountID = sat.AccountID)
				JOIN MarketTagAttributes mta ON (sat.MarketTagID = mta.MarketTagID)
				WHERE rgusac.ParentAccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
				AND sat.Active = 1
				AND mta.Parent = 1
			)
	
	UPDATE rgusa SET EnableRGC = 1
	FROM #rgusa rgusa
		WHERE rgusa.EnableRGC = 0
		AND EXISTS
			(
			SELECT * 
			FROM #rgusac rgusac JOIN InvItems ii ON (rgusac.AccountID = ii.AccountID)
				JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
				JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
				JOIN RadInvConfigs ric ON (ip.InvSourceID = ric.InvSourceID)
				WHERE rgusac.ParentAccountID = COALESCE(rgusa.ParentAccountID,rgusa.AccountID)
				AND is1.InvStateTypeID = 3 
				AND ric.Parent = 1
			)
	END

SELECT COALESCE(sap.AccountID,sa.AccountID) AS AccountID, @user AS Login, sa.Password, NULL AS Domain, CAST(COALESCE(sap.AccountTypeID,sa.AccountTypeID) AS VARCHAR(10)) AS AccountTypeID, CASE WHEN sap.AccountID IS NULL THEN sa.LoginLimit ELSE sap.LoginLimit END AS LoginLimit, 
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) IS NULL THEN NULL ELSE ((CASE WHEN sap.AccountID IS NOT NULL THEN sap.TimeLeft ELSE sa.TimeLeft END) + COALESCE(sau.TimeLeft,0)) * 60 END AS TimeLeft, 
CASE WHEN sap.AccountID IS NULL THEN CASE WHEN ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE sa.CancelDate END ELSE CASE WHEN ma.CancelDate < sap.CancelDate THEN ma.CancelDate ELSE sap.CancelDate END END AS MasterExpire,
CASE WHEN sap.AccountID IS NULL OR (sap.ExpireDate IS NULL AND sa.ExpireDate IS NOT NULL) OR (DATEADD(dd,sa.Extension,sa.ExpireDate) < DATEADD(dd,sap.Extension,sap.ExpireDate)) THEN 
	CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) END
ELSE
	CASE WHEN sap.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sap.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sap.ExpireDate OR sap.CancelDate <= sap.ExpireDate THEN 0 ELSE ma.TempExtension + sap.Extension END END,sap.ExpireDate) END
END AS SubExpire,
CASE WHEN ma.CreditLimit > 0 AND ma.PendingBalance > ma.CreditLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR sa.Active <= 0 OR (sap.Active IS NOT NULL AND sap.Active <= 0) OR ma.Active <= 0 THEN NULL WHEN sa.StartDate IS NULL THEN getdate() ELSE sa.StartDate END AS StartDate,
NULL AS BadAccountType, NULL AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.CreditLimit - ma.PendingBalance - COALESCE(arh.TotalCost,0) AS AmountLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.DataLeft ELSE sa.DataLeft END) + COALESCE(sau.DataLeft,0) END AS DataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateDataLeft ELSE sa.RateDataLeft END) + COALESCE(sau.RateDataLeft,0) END AS RateDataLeft,
CASE WHEN (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) IS NULL THEN NULL ELSE (CASE WHEN sap.AccountID IS NOT NULL THEN sap.RateTimeLeft ELSE sa.RateTimeLeft END) + COALESCE(sau.RateTimeLeft,0) END AS RateTimeLeft,
rgusa.EnableRGC AS UseRadGetConfigs, at1.UseServerPassword

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN #rgusa rgusa ON (sa.AccountID = rgusa.AccountID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN SubAccounts sap ON (rgusa.ParentAccountID = sap.AccountID)
	LEFT JOIN
		(
		SELECT AccountID, SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft,
		SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft,
		SUM(CASE WHEN RateTimeLeft > 0 THEN RateTimeLeft ELSE 0 END) AS RateTimeLeft,
		SUM(CASE WHEN RateDataLeft > 0 THEN RateDataLeft ELSE 0 END) AS RateDataLeft
		FROM SubAccountUsages
			WHERE ExpireDate > getdate()
		GROUP BY AccountID
		) sau ON (sau.AccountID = COALESCE(sap.AccountID,sa.AccountID))
	LEFT JOIN
		(
		SELECT CustomerID, SUM(TotalCost) AS TotalCost
		FROM RateHistory
			WHERE RateCostTypeID = 1
			AND ChargeID IS NULL
		GROUP BY CustomerID
		) arh ON (ma.CustomerID = arh.CustomerID)
	WHERE at1.AllowRADIUS = 1
	AND ma.Active IN (0,1)
	AND sa.Active IN (0,1)
	AND (at1.LogonAsParent = 0 OR sap.AccountID IS NOT NULL)
GO

CREATE PROCEDURE dbo.RadListOnline (@MBRGlobal INT, @OperatorGroupID INT, @Username VARCHAR(64), @NASIdentifier VARCHAR(45)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@MBRGlobal = 0)
BEGIN
SELECT CASE WHEN snas.ServerID IS NOT NULL THEN snas.Server ELSE s.Server END AS Server, cs.NASIdentifier, cs.NASPort, cs.CallDate, cs.AcctDelayTime,
DATEDIFF(mi,cs.CallDate,getdate()) AS Duration, CASE WHEN sp.AcctSessionTime = 0 THEN -1 ELSE DATEDIFF(mi,DATEADD(ss,sp.AcctSessionTime,cs.CallDate),getdate()) END AS LastUpdate,
sp.AcctInputOctets/1000000.0 AS UpMB, sp.AcctOutputOctets/1000000.0 AS DownMB, 
cs.CallingStationID, cs.CalledStationID, COALESCE(rvnpt.Name,CAST(cs.NASPortType AS VARCHAR(10))) AS NASPortType,
cs.FramedIPAddress, cs.FramedIPv6Prefix, cs.FramedIPv6Address, cs.ConnectInfo, cs.AcctSessionID, sp.Authorized, cs.AccountID,
cs.CallStartID, cs.Username, 
CASE WHEN sp.AcctSessionTime - pci.AcctSessionTime > 0 THEN (sp.AcctInputOctets - pci.AcctInputOctets) / 125000.0 / (sp.AcctSessionTime - pci.AcctSessionTime) END AS UpMbit, 
CASE WHEN sp.AcctSessionTime - pci.AcctSessionTime > 0 THEN (sp.AcctOutputOctets - pci.AcctOutputOctets) / 125000.0 / (sp.AcctSessionTime - pci.AcctSessionTime) END AS DownMbit,
CASE	WHEN snas.DisconnectPort IS NOT NULL THEN 1
	WHEN snas.ServerID IS NULL AND s.DisconnectPort IS NOT NULL THEN 1
	ELSE 0 END AS AllowDisconnect
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Servers s ON (cs.ServerID = s.ServerID)
	LEFT JOIN Servers snas ON (cs.NASIdentifier = snas.IPAddress)
	LEFT JOIN RadValues rvnpt ON (rvnpt.RadVendorID = 0 AND rvnpt.RadAttributeID = 61 AND rvnpt.Value = cs.NASPortType)
	LEFT JOIN
		(
		SELECT ci.CallStartID, MAX(ci.CallInterimID) AS CallInterimID
		FROM CallInterims ci JOIN ServerPorts sp2 ON (ci.CallStartID = sp2.CallStartID)
			WHERE ci.AcctSessionTime < sp2.AcctSessionTime 
		GROUP BY ci.CallStartID
		) pcis ON (sp.CallStartID = pcis.CallStartID)
	LEFT JOIN CallInterims pci ON (pcis.CallInterimID = pci.CallInterimID)
	WHERE ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @OperatorGroupID)
	AND (@Username IS NULL OR cs.Username LIKE @Username + '%')
	AND (@NASIdentifier IS NULL OR cs.NASIdentifier = @NASIdentifier)
END ELSE BEGIN
SELECT CASE WHEN snas.ServerID IS NOT NULL THEN snas.Server ELSE s.Server END AS Server, cs.NASIdentifier, cs.NASPort, cs.CallDate, cs.AcctDelayTime,
DATEDIFF(mi,cs.CallDate,getdate()) AS Duration, CASE WHEN sp.AcctSessionTime = 0 THEN -1 ELSE DATEDIFF(mi,DATEADD(ss,sp.AcctSessionTime,cs.CallDate),getdate()) END AS LastUpdate,
sp.AcctInputOctets/1000000.0 AS UpMB, sp.AcctOutputOctets/1000000.0 AS DownMB, 
cs.CallingStationID, cs.CalledStationID, COALESCE(rvnpt.Name,CAST(cs.NASPortType AS VARCHAR(10))) AS NASPortType,
cs.FramedIPAddress, cs.FramedIPv6Prefix, cs.FramedIPv6Address, cs.ConnectInfo, cs.AcctSessionID, sp.Authorized, cs.AccountID,
cs.CallStartID, cs.Username, 
CASE WHEN sp.AcctSessionTime - pci.AcctSessionTime > 0 THEN (sp.AcctInputOctets - pci.AcctInputOctets) / 125000.0 / (sp.AcctSessionTime - pci.AcctSessionTime) END AS UpMbit, 
CASE WHEN sp.AcctSessionTime - pci.AcctSessionTime > 0 THEN (sp.AcctOutputOctets - pci.AcctOutputOctets) / 125000.0 / (sp.AcctSessionTime - pci.AcctSessionTime) END AS DownMbit,
CASE	WHEN snas.DisconnectPort IS NOT NULL THEN 1
	WHEN snas.ServerID IS NULL AND s.DisconnectPort IS NOT NULL THEN 1
	ELSE 0 END AS AllowDisconnect
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	LEFT JOIN Servers s ON (cs.ServerID = s.ServerID)
	LEFT JOIN Servers snas ON (cs.NASIdentifier = snas.IPAddress)
	LEFT JOIN RadValues rvnpt ON (rvnpt.RadVendorID = 0 AND rvnpt.RadAttributeID = 61 AND rvnpt.Value = cs.NASPortType)
	LEFT JOIN
		(
		SELECT ci.CallStartID, MAX(ci.CallInterimID) AS CallInterimID
		FROM CallInterims ci JOIN ServerPorts sp2 ON (ci.CallStartID = sp2.CallStartID)
			WHERE ci.AcctSessionTime < sp2.AcctSessionTime 
		GROUP BY ci.CallStartID
		) pcis ON (sp.CallStartID = pcis.CallStartID)
	LEFT JOIN CallInterims pci ON (pcis.CallInterimID = pci.CallInterimID)
	WHERE (@Username IS NULL OR cs.Username LIKE @Username + '%')
	AND (@NASIdentifier IS NULL OR cs.NASIdentifier = @NASIdentifier)
END
GO

CREATE PROCEDURE dbo.RadListOnlineServers AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT asp.NASIdentifier, s.Server, asp.SessionsActive
FROM
	(
	SELECT cs.NASIdentifier, COUNT(*) AS SessionsActive
	FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	GROUP BY cs.NASIdentifier
	) asp
	LEFT JOIN Servers s ON (asp.NASIdentifier = s.IPAddress)
ORDER BY 2,1
GO

CREATE PROCEDURE dbo.RadOnlineClear (@CallStartID BIGINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 
CASE WHEN snas.DisconnectPort IS NOT NULL THEN snas.IPAddress ELSE s.IPAddress END AS IPAddress,
CASE WHEN snas.DisconnectPort IS NOT NULL THEN snas.Secret ELSE s.Secret END AS Secret,
COALESCE (snas.DisconnectPort,s.DisconnectPort) AS DisconnectPort,
cs.AcctSessionID, sp.CallStartID, ma.GroupID,
CASE WHEN s.DisconnectType & 1 = 1 AND cs.NASPort <> ' ' THEN cs.NASPort END AS NASPort,
CASE WHEN s.DisconnectType & 2 = 2 THEN cs.NASIdentifier END AS NASIPAddress,
CASE WHEN s.DisconnectType & 4 = 4 THEN cs.CallingStationID END AS CallingStationID,
CASE WHEN s.DisconnectType & 8 = 8 THEN cs.Username END AS Username, 
CASE WHEN s.DisconnectType & 16 = 16 THEN cs.CalledStationID END AS CalledStationID,
CASE WHEN s.DisconnectType & 32 = 32 THEN cs.FramedIPAddress END AS FramedIPAddress,
CASE WHEN s.DisconnectType & 64 = 64 THEN cs.NASIdentifier END AS NASIdentifier,
CASE WHEN s.DisconnectType & 128 = 128 THEN cs.NASIdentifier END AS NASIPv6Address,
CASE WHEN s.DisconnectType & 256 = 256 AND cs.NASPort <> ' ' THEN cs.NASPort END AS NASPortID,
CASE WHEN s.DisconnectType & 512 = 512 THEN cs.FramedIPv6Address END AS FramedIPv6Address,
CASE WHEN s.DisconnectType & 1024 = 1024 THEN cs.FramedIPv6Prefix END AS FramedIPv6Prefix
FROM ServerPorts sp JOIN CallStarts cs ON (sp.CallStartID = cs.CallStartID)
	LEFT JOIN Servers s ON (cs.ServerID = s.ServerID)
	LEFT JOIN Servers snas ON (cs.NASIdentifier = snas.IPAddress)
	LEFT JOIN SubAccounts sa ON (cs.AccountID = sa.AccountID)
	LEFT JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE (s.DisconnectPort IS NOT NULL OR snas.DisconnectPort IS NOT NULL)
	AND sp.CallStartID = @CallStartID
GO

CREATE PROCEDURE dbo.RadProxyCallCount AS
SET NOCOUNT ON
DECLARE @StartDate SMALLDATETIME
SELECT @StartDate = DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())))

CREATE TABLE #rpcctmp (Realm VARCHAR(64), Username VARCHAR(64), InBytes BIGINT, OutBytes BIGINT, SessionTime  INT, SessionCount INT)

INSERT INTO #rpcctmp (Realm, Username, InBytes, OutBytes, SessionTime, SessionCount)
SELECT SUBSTRING(cs.Username,CHARINDEX('@',cs.Username) + 1,DATALENGTH(cs.Username)) AS Realm, cs.Username, SUM(ce.AcctInputOctets) AS InBytes, SUM(ce.AcctOutputOctets) AS OutBytes, SUM(ce.AcctSessionTime) AS SessionTime, COUNT(*) AS SessionCount
FROM CallStarts cs, CallStops ce
	WHERE cs.CallDate BETWEEN @StartDate AND DATEADD(mm,1,@StartDate)
	AND cs.CallStartID = ce.CallStartID
	AND cs.AccountID IS NULL
	AND cs.Username LIKE '%@%'
GROUP BY cs.Username

SELECT  @StartDate AS StartDate, COUNT(*) AS Data, COUNT(*) AS SessionMaxData, t.Realm, SUM(t.InBytes) + SUM(t.OutBytes) AS AllBytes, SUM(t.InBytes) AS InBytes, SUM(t.OutBytes) AS OutBytes, SUM(t.SessionTime) AS SessionMaxTime, SUM(t.SessionTime) AS SessionTime, SUM(t.SessionCount) AS SessionCount
FROM #rpcctmp t
	WHERE NOT EXISTS (SELECT * FROM RadProxyRateProcs rprp WHERE rprp.Realm = t.Realm AND rprp.ProxyType = 1 AND rprp.ProcDate = @StartDate)
GROUP BY t.Realm
GO

CREATE PROCEDURE dbo.RadProxyCallCountUP (@ProxyType SMALLINT, @Realm VARCHAR(64), @InBytes BIGINT, @OutBytes BIGINT, @UserCount INT, @SessionTime INT, @SessionCount INT) AS
SET NOCOUNT ON
DECLARE @StartDate DATETIME
SELECT @StartDate = DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())))

INSERT INTO RadProxyRateProcs (Realm, ProxyType, ProcDate, InBytes, OutBytes, UserCount, SessionTime, SessionCount)
VALUES(@Realm, @ProxyType, @StartDate, @InBytes, @OutBytes, @UserCount, @SessionTime, @SessionCount)
GO

CREATE PROCEDURE dbo.RadRoamCache AS
SET NOCOUNT ON
SELECT rrd.Domain AS Label, rrs.Server, rrs.IPAddress, rrs.Secret, rrs.AuthPort, rrs.AcctPort,
rrd.Priority, rrs.Timeout, rrs.Retries, rrs.StripDomain, rrs.TreatAsLocal, CAST(rrd.AccountTypeID AS VARCHAR(10)) AS AccountType, rrs.RateTarget, rrs.RateMax
FROM RadRoamServers rrs JOIN RadRoamDomains rrd ON (rrd.RadRoamServerID = rrs.RadRoamServerID)
UNION
SELECT CAST(RadRoamServerID AS VARCHAR(10)) AS Label, Server, IPAddress, Secret, AuthPort, AcctPort, 
0, Timeout, Retries, StripDomain, TreatAsLocal, NULL, RateTarget, RateMax
FROM RadRoamServers
ORDER BY Label,Priority
GO

CREATE PROCEDURE dbo.RadServerAccessCache AS
SET NOCOUNT ON
SELECT MaxSessionLength, s.IPAddress, NULL AS Port, CAST(sa.AccountTypeID AS VARCHAR(10)) AS AccountType, sa.Allowed, sa.AccessTime1, sa.AccessTime2, sa.AccessTime3
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
UNION
SELECT MaxSessionLength, s.Server, NULL AS Port, CAST(sa.AccountTypeID AS VARCHAR(10)) AS AccountType, sa.Allowed, sa.AccessTime1, sa.AccessTime2, sa.AccessTime3
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
UNION
SELECT NULL, s.IPAddress, NULL, NULL, CASE WHEN s.CheckAccess = 0 THEN 1 ELSE 0 END, NULL, NULL, NULL
FROM Servers s LEFT JOIN ServerAccess sa ON (s.ServerID = sa.ServerID AND sa.AccountTypeID IS NULL)
	WHERE sa.ServerAccessID IS NULL
UNION
SELECT NULL, s.Server, NULL, NULL, CASE WHEN s.CheckAccess = 0 THEN 1 ELSE 0 END, NULL, NULL, NULL
FROM Servers s LEFT JOIN ServerAccess sa ON (s.ServerID = sa.ServerID AND sa.AccountTypeID IS NULL)
	WHERE sa.ServerAccessID IS NULL
UNION
SELECT NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL
GO

CREATE PROCEDURE dbo.RateClassChildServiceTag (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT slt.ServiceLevelType AS Attribute, 1 AS Data
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ServiceLevelTypes slt ON (at1.ServiceLevelTypeID = slt.ServiceLevelTypeID)
	WHERE sa.ParentAccountID = @AccountID
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND slt.ServiceLevelType NOT LIKE '% %'

UNION ALL

SELECT slt.ServiceLevelType AS Attribute, 1 AS Data
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ServiceLevelTypes slt ON (at1.SecServiceLevelTypeID = slt.ServiceLevelTypeID)
	WHERE sa.ParentAccountID = @AccountID
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND slt.ServiceLevelType NOT LIKE '% %'
GO

CREATE PROCEDURE dbo.RateCallsResellerClassifier AS
SET NOCOUNT ON
CREATE TABLE #rcrctmp2 (GroupID INT)
INSERT INTO #rcrctmp2 (GroupID)
SELECT g.GroupID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NULL

CREATE TABLE #rcrctmp (GroupID INT, CustomerID INT)
INSERT INTO #rcrctmp (GroupID, CustomerID)
SELECT g.GroupID, o.ResellerCustomerID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NOT NULL

SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp
UNION ALL
SELECT 'CustomerID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp
UNION ALL
SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp2
UNION ALL
SELECT 'RateClassID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, '0' AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp2
GO

CREATE PROCEDURE dbo.RateCallsUP (@hostip VARCHAR(64), @Preferred INT, @CallID BIGINT, @Message VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @IsLeader INT, @Leader VARCHAR(64), @LastUpdate DATETIME, @LastMessage VARCHAR(255), @Advisor VARCHAR(64), @LastAdviceDate DATETIME, @status INT, @Lead INT
SELECT @Leader = MAX(Leader), @LastUpdate = MAX(LastUpdate), @LastMessage = MAX(LastMessage), @Advisor = MAX(Advisor), @LastAdviceDate = MAX(LastAdviceDate) FROM RateStatusCalls
IF (@hostip = @Leader)
BEGIN
IF (@Advisor <> @hostip AND DATEDIFF(ss,@LastAdviceDate,getdate()) < 90 AND @Preferred = 0 AND @CallID IS NOT NULL)
	BEGIN
	UPDATE RateStatusCalls SET LastCallInterimID = @CallID, LastMessage = COALESCE(@Message,LastMessage), Leader = Advisor, LastUpdate = getdate() WHERE Leader = @hostip
	SELECT @Lead = 0

	END ELSE BEGIN
	UPDATE RateStatusCalls SET LastUpdate = getdate(), LastCallInterimID = COALESCE(@CallID,LastCallInterimID), LastMessage = COALESCE(@Message,LastMessage) WHERE Leader = @hostip
	IF (@@ROWCOUNT = 0)
		BEGIN
		IF (@Preferred = 1)
			BEGIN
			UPDATE RateStatusCalls SET Advisor = @hostip, LastAdviceDate = DATEADD(mi,1,getdate())
			END
		SELECT @Lead = 0

		END ELSE BEGIN
		SELECT @Lead = 1
		END
	END

END ELSE BEGIN
IF (DATEDIFF(ss,@LastUpdate,getdate()) > 90)
	BEGIN
	UPDATE RateStatusCalls SET Leader = @hostip, LastUpdate = getdate(), LastCallInterimID = COALESCE(@CallID,LastCallInterimID), LastMessage = NULL WHERE DATEDIFF(ss,LastUpdate,getdate()) > 90 OR Leader = @hostip
	SELECT @Lead = CASE WHEN @@ROWCOUNT = 1 THEN 1 ELSE 0 END
	END ELSE BEGIN
	SELECT @Lead = 0
	END
END

SELECT @Lead AS Lead
GO

CREATE PROCEDURE dbo.RateChargesGet AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @delay INT, @interim INT, @thismonth DATETIME
CREATE TABLE #rcgv (AccountID INT, MaxCallDate DATETIME, Cost NUMERIC(18,4), Cnt INT, RateID INT, Interim INT)
SELECT @delay = CASE WHEN NumValue <= 0 THEN 1 WHEN NumValue > 15 THEN 15 ELSE NumValue END FROM Configs WHERE ConfigID = 646
SELECT @interim = CASE WHEN NumValue = 1 THEN 1 ELSE 0 END FROM Configs WHERE ConfigID = 647
SELECT @thismonth = DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate()))

INSERT INTO #rcgv (AccountID,MaxCallDate,Cost,Cnt,RateID,Interim)
SELECT sa.AccountID, MAX(vc.CallDate) AS MaxCallDate, SUM(vc.Cost) AS Cost, COUNT(*) AS Cnt, (SELECT MIN(RateID) FROM Rates WHERE RateClassID=at1.RateClassID AND RateSourceID=4) AS RateID, COALESCE(MAX(cgdi.NumValue),@interim) AS Interim
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (bc.BillingCycleID = ma.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ConfigGroupData cgdi ON (cgdi.GroupID = ma.GroupID AND cgdi.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdd ON (cgdd.GroupID = ma.GroupID AND cgdd.ConfigID = 646)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND vc.ProcDate IS NOT NULL
	AND vc.ChargeID IS NULL
	AND (COALESCE(cgdi.NumValue,@interim) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR vc.CallDate < DATEADD(dd,CASE
	WHEN bc.CycleType IN (1,2,4) AND (bc.BillDay IS NULL OR bc.BillDay = 1) THEN 0
	WHEN bc.CycleType IN (0,3) AND (ma.BillDay <= 1 OR ma.BillDay >= 28) THEN 0
	WHEN bc.CycleType IN (1,2,4) THEN bc.BillDay - 1
	WHEN bc.CycleType IN (0,3) THEN ma.BillDay - 1 END + 
	CASE WHEN COALESCE(cgdd.NumValue,@delay) <= 1 OR COALESCE(cgdi.NumValue,@interim) = 1 THEN 0 ELSE -@delay END,@thismonth))
GROUP BY sa.AccountID, at1.RateClassID

SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeType AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID)
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID = 0
	AND rh.RateCostTypeID = 1
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,@interim,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,@delay,1)),DATEADD(mm,-1,getdate())))

UNION ALL

SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeType AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID) 
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN MasterAccounts ma ON (rh.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (sa.AccountID = rh.AccountID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID <> 0
	AND rh.RateCostTypeID = 1
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,@interim,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,@delay,1)),DATEADD(mm,-1,getdate())))

UNION ALL

SELECT NULL AS RRDescription, NULL AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeType AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, CASE WHEN r.MaxCharge < rcgv.Cost THEN r.MaxCharge ELSE rcgv.Cost END AS TotalCost, ma.CustomerID, sa.AccountID, rcgv.MaxCallDate AS StartDate, ma.CustomerID AS RHCustomerID, NULL AS RateRuleID,
rcgv.RateID, ma.LanguageID, CASE WHEN rcgv.Interim = 1 THEN NULL ELSE r.MinCharge END AS MinCharge, COALESCE(sa.Login,sa.Email) AS Login,
2 AS RBType,rcgv.Cnt AS RecordCount
FROM #rcgv rcgv JOIN SubAccounts sa ON (rcgv.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Rates r ON (rcgv.RateID = r.RateID)
	JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
ORDER BY 9,11,10,14
GO

CREATE PROCEDURE dbo.RateGetCalls AS
SET NOCOUNT ON
DECLARE @LastCallInterimID BIGINT
SELECT @LastCallInterimID = MAX(LastCallInterimID) FROM RateStatusCalls

SELECT TOP 1000 ma.GroupID, at1.RateClassID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay,
ci.CallInterimID AS CallID, cs.CallStartID AS SessionID, cs.Username, cs.NASIdentifier, cs.NASPort,
DATEADD(ss,CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctSessionTime ELSE 0 END,cs.CallDate) AS StartDate,
ci.AcctSessionTime - CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctSessionTime ELSE 0 END AS Duration,
CASE WHEN ci.AcctOutputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctOutputOctets ELSE 0 END < 0 THEN 0 ELSE ci.AcctOutputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.AcctOutputOctets IS NOT NULL THEN pci.AcctOutputOctets ELSE 0 END END AS AcctOutputOctets,
CASE WHEN ci.AcctInputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctInputOctets ELSE 0 END < 0 THEN 0 ELSE ci.AcctInputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.AcctInputOctets IS NOT NULL THEN pci.AcctInputOctets ELSE 0 END END AS AcctInputOctets,
CASE WHEN ci.AcctInputOctets + ci.AcctOutputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctInputOctets + pci.AcctOutputOctets ELSE 0 END < 0 THEN 0 ELSE ci.AcctInputOctets + ci.AcctOutputOctets - CASE WHEN rc.AllowInterim = 1 AND pci.CallInterimID IS NOT NULL THEN pci.AcctInputOctets + pci.AcctOutputOctets ELSE 0 END END AS Data,
cs.FramedIPAddress, cs.FramedIPv6Address, cs.NASPortType, cs.CalledStationID, cs.CallingStationID, cs.ConnectInfo, cs.AccountID

FROM CallInterims ci JOIN CallStarts cs ON (ci.CallStartID = cs.CallStartID)
	JOIN SubAccounts sa ON (cs.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN RateClasses rc ON (at1.RateClassID = rc.RateClassID)
	JOIN (SELECT ci.CallInterimID, MAX(CASE WHEN ci2.CallInterimID < ci.CallInterimID THEN ci2.CallInterimID ELSE NULL END) AS PrevCallInterimID
		FROM CallInterims ci JOIN CallInterims ci2 ON (ci.CallStartID = ci2.CallStartID)
			WHERE ci.CallInterimID > @LastCallInterimID
		GROUP BY ci.CallInterimID) fpci ON (ci.CallInterimID = fpci.CallInterimID)
	LEFT JOIN CallInterims pci ON (fpci.PrevCallInterimID = pci.CallInterimID)
	LEFT JOIN CallStops ce ON (ci.CallStartID = ce.CallStartID)
	WHERE ci.CallInterimID > @LastCallInterimID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND ((rc.AllowInterim = 1 AND (pci.CallInterimID IS NULL OR pci.AcctSessionTime < ci.AcctSessionTime)) OR (ci.AcctSessionTime = ce.AcctSessionTime))
ORDER BY ci.CallInterimID ASC
GO

CREATE PROCEDURE dbo.RateGetCostTypes AS
SET NOCOUNT ON
SELECT r.RateID, rct.RateCostTypeID, rct.CostAttribute, rct.CostUPQuery, rr.DataAttribute
FROM Rates r JOIN RateCostTypes rct ON (r.RateCostTypeID = rct.RateCostTypeID)
	JOIN RateRules rr ON (r.ClassifierRateRuleID = rr.RateRuleID)
GO

CREATE PROCEDURE dbo.RateGetVoiceCalls AS
SET NOCOUNT ON
SELECT CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, ma.GroupID, at1.RateClassID, vc.VoiceCallID,vc.Login,sa.AccountID,vc.CallDate AS StartDate, vc.Duration, vc.SessionRef, vc.CalledNumber, vc.CallingPort, vc.CalledPort, vc.Bytes AS Data, vc.CallType, vc.AcctTerminateCause, vc.Location
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.Login = sa.Login)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND vc.ChargeID IS NULL
	AND vc.ProcDate IS NULL
	AND at1.RateClassID IS NOT NULL
GO

CREATE PROCEDURE dbo.RateHistAll (@RateSourceID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT rh.StartDate, rh.AccountID, CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalCost, rh.TotalData
FROM Rates r JOIN RateHistory rh ON (r.RateID = rh.RateID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	WHERE rh.StartDate > DATEADD(dd,-45,getdate())
	AND r.RateSourceID = @RateSourceID
GO

CREATE PROCEDURE dbo.RateHistUser (@RateSourceID INT, @AccountID INT, @StartDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT rh.StartDate, rh.AccountID, CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalData, rh.TotalCost
FROM Rates r JOIN RateHistory rh ON (r.RateID = rh.RateID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	WHERE rh.StartDate >= @StartDate
	AND rh.AccountID = @AccountID
	AND r.RateSourceID = @RateSourceID
GO

CREATE PROCEDURE dbo.RateHistoryUnapplied AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT MIN(r.Rate) AS Rate, DATEDIFF(mm,StartDate,getdate()) AS Months, COUNT(*) AS Records, SUM (TotalTime) AS TotalTime, SUM(TotalCost) AS TotalCost, SUM(TotalCount) AS TotalCount, SUM(TotalData) AS TotalData
FROM RateHistory rh JOIN Rates r ON (r.RateID = rh.RateID)
	WHERE rh.ChargeID IS NULL
	AND rh.RateCostTypeID = 1
	AND rh.StartDate >= DATEADD(mm,-12,getdate())
GROUP BY DATEDIFF(mm,StartDate,getdate()), r.RateID
ORDER BY 2,1
GO

CREATE PROCEDURE dbo.RateNetflowResellerClassifier (@Direction INT) AS
SET NOCOUNT ON
CREATE TABLE #rnrctmp (AccountID INT, CustomerID INT, RateClassID INT, BillDay SMALLINT, IPAddress VARCHAR(64), CollectIP VARCHAR(64))

INSERT INTO #rnrctmp (AccountID, CustomerID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, o.ResellerCustomerID, at1.RateClassID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND o.ResellerCustomerID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2

SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'CustomerID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
GO

CREATE PROCEDURE dbo.RateNetflowUserClassifier (@Direction INT) AS
SET NOCOUNT ON
CREATE TABLE #rnuctmp (AccountID INT, RateClassID INT, BillDay SMALLINT, IPAddress VARCHAR(64), CollectIP VARCHAR(64))

INSERT INTO #rnuctmp (AccountID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, at1.RateClassID, CASE WHEN bc.CycleType IN (0,3) THEN ma.BillDay ELSE COALESCE(bc.BillDay,1) END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2

SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3) AND CollectIP IS NOT NULL
GO

CREATE PROCEDURE dbo.RateProxyUserClassifier AS
SET NOCOUNT ON
CREATE TABLE #rpuctmp (AccountID INT, RateClassID INT, Data VARCHAR(255))

INSERT INTO #rpuctmp (AccountID, RateClassID, Data)
SELECT sa.AccountID, at1.RateClassID, sad.Data
FROM SubAccountData sad JOIN SubAccounts sa ON (sad.AccountID = sa.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND sad.AccountDataTypeID = 14
	AND at1.RateClassID IS NOT NULL

SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(1 AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'Realm' AS Attribute, AccountID AS GroupingID, 1 AS MatchTypeID, Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
GO

CREATE PROCEDURE dbo.RateStdRules (@RateRuleID INT) AS
SET NOCOUNT ON

SELECT rsi.Attribute, rsi.RateStdGroupID AS GroupingID, rsi.RateMatchTypeID AS MatchTypeID, rsi.Data, rsg.Cost, rsg.Priority
FROM RateStdGroups rsg JOIN RateStdItems rsi ON (rsg.RateStdGroupID = rsi.RateStdGroupID)
	WHERE rsg.RateRuleID = @RateRuleID

UNION ALL

SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost, NULL AS Priority
FROM RateRules 
	WHERE RateRuleID = @RateRuleID
GO

CREATE PROCEDURE dbo.RateUP (@CustomerID INT, @AccountID INT, @RateID INT, @RateRuleID INT, @TotalCount NUMERIC(28,12), @TotalData BIGINT, @TotalTime INT, @TotalCost NUMERIC(28,12), @TotalSessions INT, @RateCostTypeID INT, @StartDate DATETIME, @RateSourceID INT, @SessionID VARCHAR(20)) AS
SET NOCOUNT ON
DECLARE @MaxStartDate DATETIME, @custid INT
SELECT @custid = CustomerID FROM SubAccounts WHERE AccountID = @AccountID

IF (@custid IS NOT NULL)
BEGIN
UPDATE RateHistory SET TotalCount = TotalCount + @TotalCount, TotalData = TotalData + @TotalData, TotalTime = TotalTime + @TotalTime, TotalCost = TotalCost + @TotalCost, RateCostTypeID = @RateCostTypeID
	WHERE StartDate BETWEEN @StartDate AND DATEADD(hh,1,@StartDate)
	AND AccountID = @AccountID
	AND CustomerID = CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END
	AND RateID = @RateID
	AND RateRuleID = @RateRuleID
	AND ChargeID IS NULL

IF (@@ROWCOUNT < 1)
	BEGIN
	SELECT @MaxStartDate = MAX(StartDate) 
	FROM RateHistory 
		WHERE StartDate BETWEEN @StartDate AND DATEADD(hh,1,@StartDate)
		AND AccountID = @AccountID
		AND CustomerID = CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END
		AND RateID = @RateID
		AND RateRuleID = @RateRuleID

	INSERT INTO RateHistory (StartDate,AccountID,CustomerID,RateRuleID,RateID,TotalTime,ChargeID,TotalCount,TotalData,TotalCost,RateCostTypeID)
	VALUES(CASE WHEN @MaxStartDate IS NULL THEN @StartDate ELSE DATEADD(mi,1,@MaxStartDate) END, @AccountID, CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END, @RateRuleID, @RateID, @TotalTime, NULL, @TotalCount, @TotalData, @TotalCost, @RateCostTypeID)
	END

IF (@RateCostTypeID = 3)
	BEGIN
	UPDATE SubAccounts SET RateDataLeft = RateDataLeft - @TotalCost WHERE AccountID = @AccountID
	END

IF (@RateCostTypeID = 4)
	BEGIN
	UPDATE SubAccounts SET RateTimeLeft = RateTimeLeft - @TotalCost WHERE AccountID = @AccountID
	END
END

IF (@SessionID IS NOT NULL AND @RateCostTypeID IN (1,2) AND @RateSourceID = 1)
BEGIN
UPDATE CallCosts SET Cost = Cost + @TotalCost 
	WHERE CallStartID = CAST(CAST(@SessionID AS FLOAT) AS BIGINT)
	AND RateID = @RateID

IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO CallCosts (CallStartID,RateID,Cost) VALUES(CAST(CAST(@SessionID AS FLOAT) AS BIGINT),@RateID,@TotalCost)
	END
END
GO

CREATE PROCEDURE dbo.RateVDNISClear (@RateVDNISID INT) AS
SET NOCOUNT ON
DELETE FROM RateVDNISItems WHERE RateVDNISID = @RateVDNISID
GO

CREATE PROCEDURE dbo.RateVDNISImport (@RateVDNISID INT, @prefix VARCHAR(64), @rate NUMERIC(18,4), @label VARCHAR(128), @location VARCHAR(128), @country VARCHAR(128), @state VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @CountryID INT, @StateID INT

IF (@country IS NOT NULL)
BEGIN
SELECT @CountryID = MIN(CountryID) FROM Countries WHERE Country = @country OR Abbr2 = @country OR Abbr3 = @country
END

IF (@state IS NOT NULL)
BEGIN
SELECT @StateID = MIN(StateID) FROM States WHERE (@CountryID IS NULL OR @CountryID = CountryID) AND (State = @state OR Abbreviation = @state)
END

IF (@prefix IS NOT NULL AND @rate IS NOT NULL)
BEGIN
INSERT INTO RateVDNISItems (RateVDNISID,RateVDNISItem,DNIS,Location,RateMatchTypeID,IntervalCost,IntervalOption,CountryID,StateID,SortOrder)
VALUES(@RateVDNISID,COALESCE(@label,@prefix),@prefix,@location,2,@rate,1,@CountryID,@StateID,0)
END
GO

CREATE PROCEDURE dbo.RateVRules (@RateRuleID INT) AS
SET NOCOUNT ON

CREATE TABLE #rvrtmp (RuleCounter INT IDENTITY, RateVCondGroupID INT, DNIS VARCHAR(64), Attribute VARCHAR(64), RateMatchTypeID INT, IntervalCost NUMERIC(18,4), InitialCost NUMERIC(18,4), StaticCost NUMERIC(18,4))

INSERT INTO #rvrtmp (RateVCondGroupID,DNIS,Attribute,RateMatchTypeID,IntervalCost,InitialCost,StaticCost)
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr JOIN RateVDNISGroupItems vdgi ON (vr.RateVDNISGroupID = vdgi.RateVDNISGroupID)
	JOIN RateVDNIS vd ON (vdgi.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr JOIN RateVDNISGroupItems vdgi ON (vr.RateVDNISGroupID = vdgi.RateVDNISGroupID)
	JOIN RateVDNIS vd ON (vdgi.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr JOIN RateVDNISGroupItems vdgi ON (vr.RateVDNISGroupID = vdgi.RateVDNISGroupID)
	JOIN RateVDNIS vd ON (vdgi.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr JOIN RateVDNIS vd ON (vr.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr JOIN RateVDNIS vd ON (vr.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr JOIN RateVDNIS vd ON (vr.RateVDNISID = vd.RateVDNISID)
	JOIN RateVDNISItems vdi ON (vd.RateVDNISID = vdi.RateVDNISID)
	WHERE vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

SELECT vci.Attribute, t.RuleCounter AS GroupingID, vci.RateMatchTypeID AS MatchTypeID, vci.Data, t.IntervalCost AS Cost, vcg.Priority
FROM #rvrtmp t JOIN RateVCondGroups vcg ON (t.RateVCondGroupID = vcg.RateVCondGroupID)
	JOIN RateVCondItems vci ON (vcg.RateVCondGroupID = vci.RateVCondGroupID)

UNION ALL
SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost AS Cost, NULL AS Priority
FROM RateRules
	WHERE RateRuleID = @RateRuleID

UNION ALL
SELECT Attribute, RuleCounter AS GroupingID, RateMatchTypeID AS MatchTypeID, DNIS AS Data, COALESCE(IntervalCost,(SELECT DefaultCost FROM RateRules WHERE RateRuleID=@RateRuleID)) AS Cost, NULL AS Priority
FROM #rvrtmp
	WHERE IntervalCost IS NOT NULL OR StaticCost IS NOT NULL OR InitialCost IS NOT NULL

UNION ALL
SELECT 'InitialCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(InitialCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM #rvrtmp t
	WHERE InitialCost IS NOT NULL

UNION ALL
SELECT 'StaticCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(StaticCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM #rvrtmp
	WHERE StaticCost IS NOT NULL
ORDER BY 2,1
GO

CREATE PROCEDURE dbo.RateVoiceCallsClear AS
SET NOCOUNT ON
UPDATE VoiceCalls SET ProcDate = NULL, ErrorCode = NULL WHERE ProcDate IS NOT NULL AND ChargeID IS NULL
GO

CREATE PROCEDURE dbo.RateVoiceCallsLoc AS
SET NOCOUNT ON
UPDATE VoiceCalls SET Location = lp.City, StateID = s.StateID, CountryID = s.CountryID
FROM VoiceCalls vc JOIN LocPhones lp ON (SUBSTRING(vc.CalledNumber,1,6) = lp.Prefix)
	JOIN States s ON (lp.StateID = s.StateID)
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 10

UPDATE VoiceCalls SET Location = lp.City, StateID = s.StateID, CountryID = s.CountryID
FROM VoiceCalls vc JOIN LocPhones lp ON (SUBSTRING(vc.CalledNumber,1,7) = '1' + lp.Prefix)
	JOIN States s ON (lp.StateID = s.StateID)
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 11

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc JOIN Countries c ON (SUBSTRING(vc.CalledNumber,2,DATALENGTH(c.TelPrefix)) = c.TelPrefix)
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND (vc.CalledNumber LIKE '+%' OR vc.CalledNumber LIKE '0%')
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc JOIN Countries c ON (SUBSTRING(vc.CalledNumber,1,DATALENGTH(c.TelPrefix)) = c.TelPrefix)
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc JOIN Countries c ON (SUBSTRING(vc.CalledNumber,4,DATALENGTH(c.TelPrefix)) = c.TelPrefix)
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND vc.CalledNumber LIKE '011%'
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
GO

CREATE PROCEDURE dbo.RateVoiceCallsUP (@AccountID INT,@VoiceCallID BIGINT,@Matched INT, @Cost NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE VoiceCalls SET AccountID = COALESCE(AccountID,@AccountID), Cost = @Cost, ProcDate = CASE WHEN @Matched = 1 THEN getdate() ELSE NULL END, ErrorCode = CASE WHEN @Matched = 0 THEN 1 ELSE NULL END 
WHERE VoiceCallID = @VoiceCallID
AND ProcDate IS NULL
AND ChargeID IS NULL
GO

CREATE PROCEDURE dbo.RefSync WITH RECOMPILE AS
SET NOCOUNT ON
CREATE TABLE #rsync (OID INT IDENTITY, RefManagerID INT NOT NULL, SrcAccountID INT NOT NULL, DstAccountID INT NOT NULL, InvoicedDays INT NOT NULL, HaveRoom TINYINT NOT NULL, HaveState TINYINT NOT NULL, Active TINYINT NOT NULL, NeedSrcExtTag TINYINT NOT NULL, NeedDstExtTag TINYINT NOT NULL, AllowAdd TINYINT, AddDays INT NOT NULL)
CREATE TABLE #rsagg (RefManagerID INT NOT NULL, SrcAccountID INT NOT NULL, ActiveCount INT NOT NULL, StartOID INT, EndOID INT)
UPDATE IEALocks SET RefCount = RefCount + 1, LastModifyDate = getdate() WHERE IEALockID = 6

INSERT INTO #rsync (RefManagerID, SrcAccountID, DstAccountID, InvoicedDays, HaveRoom, HaveState, Active, NeedSrcExtTag, NeedDstExtTag, AddDays)
SELECT rm.RefManagerID, srcsa.AccountID AS SrcAccountID, dstsa.AccountID AS DstAccountID, COALESCE(dstt.InvoicedDays,dstsa.InvoicedDays),
CASE	WHEN rs.RefManagerID IS NULL OR rm.SrcInvoicedDaysLimit IS NULL THEN 1
	WHEN rs.CreditDays >= rm.SrcInvoicedDaysLimit THEN 0 ELSE 1 END AS HaveRoom,
CASE WHEN rs.RefManagerID IS NOT NULL THEN 1 ELSE 0 END AS HaveState,
CASE WHEN srcsa.Active = 1 AND srcma.Active = 1 AND dstsa.Active = 1 AND dstma.Active = 1
	AND (rm.SrcInvoicedDaysMin IS NULL OR COALESCE(srct.InvoicedDays,srcsa.InvoicedDays) >= rm.SrcInvoicedDaysMin)
	AND (rm.DstInvoicedDaysMin IS NULL OR COALESCE(dstt.InvoicedDays,dstsa.InvoicedDays) >= rm.DstInvoicedDaysMin)
THEN 1 ELSE 0 END AS Active,
CASE WHEN srce.MarketTagID IS NULL THEN 1 ELSE 0 END AS NeedSrcExtTag,
CASE WHEN rm.DstExtMarketTagID IS NOT NULL AND dste.MarketTagID IS NULL THEN 1 ELSE 0 END AS NeedDstExtTag,
CASE	WHEN rs.RefManagerID IS NULL THEN 0 
	WHEN COALESCE(dstt.InvoicedDays,dstsa.InvoicedDays) - rs.LastDays + rs.CreditDays > rm.SrcInvoicedDaysLimit THEN rm.SrcInvoicedDaysLimit - rs.CreditDays
	WHEN COALESCE(dstt.InvoicedDays,dstsa.InvoicedDays) > rs.LastDays THEN COALESCE(dstt.InvoicedDays,dstsa.InvoicedDays) - rs.LastDays ELSE 0 END AS AddDays
FROM RefManagers rm JOIN SubAccounts srcsa ON ((rm.SrcServiceCategoryID IS NULL OR rm.SrcServiceCategoryID = srcsa.ServiceCategoryID) AND (rm.SrcAccountTypeID IS NULL OR rm.SrcAccountTypeID = srcsa.AccountTypeID) AND srcsa.Active = 1)
	JOIN MasterAccounts srcma ON (srcsa.CustomerID = srcma.CustomerID)
	JOIN SubAccounts dstsa ON ((rm.DstServiceCategoryID IS NULL OR rm.DstServiceCategoryID = dstsa.ServiceCategoryID) AND (rm.DstAccountTypeID IS NULL OR rm.DstAccountTypeID = dstsa.AccountTypeID) AND dstsa.Active = 1)
	JOIN MasterAccounts dstma ON (dstsa.CustomerID = dstma.CustomerID)
	LEFT JOIN SubAccountTags srct ON (srcsa.AccountID = srct.AccountID AND rm.SrcMarketTagID = srct.MarketTagID AND srct.Active = 1)
	LEFT JOIN SubAccountTags dstt ON (dstsa.AccountID = dstt.AccountID AND rm.DstMarketTagID = dstt.MarketTagID AND dstt.Active = 1)
	LEFT JOIN RefStates rs ON (rm.RefManagerID = rs.RefManagerID AND srcsa.AccountID = rs.SrcAccountID AND dstsa.AccountID = rs.DstAccountID)
	LEFT JOIN SubAccountTags srce ON (srcsa.AccountID = srce.AccountID AND rm.SrcExtMarketTagID = srce.MarketTagID)
	LEFT JOIN SubAccountTags dste ON (dstsa.AccountID = dste.AccountID AND rm.DstExtMarketTagID = dste.MarketTagID)
	WHERE srcsa.Active IN (1,0)
	AND srcma.Active IN (1,0)
	AND dstsa.Active IN (1,0)
	AND dstma.Active IN (1,0)
	AND (rm.SrcMarketTagID IS NULL OR srct.AccountID IS NOT NULL)
	AND (rm.DstMarketTagID IS NULL OR dstt.AccountID IS NOT NULL)
	AND (rm.GroupID IS NULL OR (srcma.GroupID = rm.GroupID AND dstma.GroupID = rm.GroupID))
	AND dstsa.RefAccountID = srcsa.AccountID
	AND dstsa.CustomerID <> srcsa.CustomerID
	AND (srcsa.RefAccountID IS NULL OR srcsa.RefAccountID <> dstsa.AccountID)
ORDER BY 1, 2, 7 DESC, 5 DESC, COALESCE(rs.CreateDate,getdate()) ASC

INSERT INTO #rsagg(RefManagerID, SrcAccountID, ActiveCount, StartOID, EndOID)
SELECT rs.RefManagerID, rs.SrcAccountID, SUM(rs.Active), MIN(rs.OID) AS StartOID, MAX(CASE WHEN rs.Active = 1 AND rs.HaveRoom = 1 THEN rs.OID END) AS EndOID
FROM RefManagers rm JOIN #rsync rs ON (rm.RefManagerID = rs.RefManagerID)
	WHERE rs.Active = 1
GROUP BY rs.RefManagerID, rs.SrcAccountID
HAVING SUM(rs.Active) >= MIN(rm.SrcReferralsMin) AND (MIN(rm.SrcReferralsMax) IS NULL OR SUM(rs.Active) <= MIN(rm.SrcReferralsMax))

UPDATE rs SET AllowAdd = 1
FROM #rsync rs JOIN #rsagg ra ON (rs.RefManagerID = ra.RefManagerID AND rs.SrcAccountID = ra.SrcAccountID)
	JOIN RefManagers rm ON (rs.RefManagerID = rm.RefManagerID)
	WHERE rs.OID >= ra.StartOID
	AND ((rm.SrcReferralsCreditMax IS NULL AND rs.OID <= ra.EndOID) OR (rm.SrcReferralsCreditMax IS NOT NULL AND rs.OID <= CASE WHEN ra.StartOID + rm.SrcReferralsCreditMax < ra.EndOID THEN ra.StartOID + rm.SrcReferralsCreditMax ELSE ra.EndOID END))

UPDATE s SET LastUpdate = getdate(), LastDays = rs.InvoicedDays, LastAddDays = CASE WHEN rs.AllowAdd = 1 AND rs.AddDays <> 0 THEN InvoicedDays ELSE s.LastAddDays END, CreditDays = CASE WHEN rs.AllowAdd = 1 THEN CreditDays + rs.AddDays ELSE CreditDays END
FROM RefStates s JOIN #rsync rs ON (s.RefManagerID = rs.RefManagerID AND s.SrcAccountID = rs.SrcAccountID AND s.DstAccountID = rs.DstAccountID)

INSERT INTO RefStates (RefManagerID, SrcAccountID, DstAccountID, StartingDays, LastDays, LastAddDays, CreditDays)
SELECT rs.RefManagerID, rs.SrcAccountID, rs.DstAccountID, InvoicedDays, InvoicedDays, InvoicedDays, 0
FROM #rsync rs LEFT JOIN RefStates s ON (rs.RefManagerID = s.RefManagerID AND rs.SrcAccountID = s.SrcAccountID AND rs.DstAccountID = s.DstAccountID)
	WHERE s.RefManagerID IS NULL
	AND rs.Active = 1

UPDATE sat SET InvoicedDaysMax = InvoicedDaysMax + (rs.AddDays / CASE WHEN rf.SrcReferralsMin < 1 THEN 1 ELSE rf.SrcReferralsMin END)
FROM SubAccountTags sat JOIN #rsync rs ON (sat.AccountID = rs.SrcAccountID)
	JOIN RefManagers rf ON (rs.RefManagerID = rf.RefManagerID AND sat.MarketTagID = rf.SrcExtMarketTagID)
	WHERE rs.AllowAdd = 1
	AND rs.AddDays <> 0

INSERT INTO SubAccountTags (AccountID, MarketTagID, InvoicedDaysMax, CreateDate, CreateUser)
SELECT rs.SrcAccountID, rf.SrcExtMarketTagID, SUM(rs.AddDays / CASE WHEN rf.SrcReferralsMin < 1 THEN 1 ELSE rf.SrcReferralsMin END), getdate(), 'Referral Manager'
FROM #rsync rs JOIN RefManagers rf ON (rs.RefManagerID = rf.RefManagerID)
	LEFT JOIN SubAccountTags sat ON (rs.SrcAccountID = sat.AccountID AND rf.SrcExtMarketTagID = sat.MarketTagID)
	WHERE sat.AccountID IS NULL
	AND rs.Active = 1
	AND rf.SrcExtMarketTagID IS NOT NULL
GROUP BY rs.SrcAccountID, rf.SrcExtMarketTagID

INSERT INTO SubAccountTags (AccountID, MarketTagID, CreateDate, CreateUser)
SELECT DISTINCT rs.DstAccountID, rf.DstExtMarketTagID, getdate(), 'Referral Manager'
FROM #rsync rs JOIN RefManagers rf ON (rs.RefManagerID = rf.RefManagerID)
	LEFT JOIN SubAccountTags sat ON (rs.DstAccountID = sat.AccountID AND rf.DstExtMarketTagID = sat.MarketTagID)
	WHERE sat.AccountID IS NULL
	AND rs.Active = 1
	AND rf.DstExtMarketTagID IS NOT NULL
GO

CREATE PROCEDURE dbo.ReportGroupAccess (@OperatorGroupID INT, @OrganizationID INT, @GroupID INT) AS
SET NOCOUNT ON
DECLARE @reqall INT, @total INT, @allowed INT, @groupmatch INT, @result INT

IF (@GroupID = 1)
BEGIN
SELECT @result = 0
END

IF (@result IS NULL AND @OrganizationID IS NULL)
BEGIN
IF (@GroupID IS NOT NULL)
	BEGIN
	SELECT @result = CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END
	FROM OperatorGroupAccess
		WHERE ObjectGroupID = 101
		AND AccessType & 1 = 1
		AND OperatorGroupID = @OperatorGroupID
		AND GroupID = @GroupID
	END ELSE BEGIN
	SELECT @result = 0
	END
END

IF (@result IS NULL)
BEGIN
SELECT @reqall = NumValue FROM ConfigOperatorGroupData WHERE ConfigID = 729 AND OperatorGroupID = @OperatorGroupID

IF (@reqall IS NULL)
	BEGIN
	SELECT @reqall = NumValue FROM Configs WHERE ConfigID = 729
	END

SELECT @reqall = CASE WHEN @reqall IN (1,2) THEN @reqall ELSE 0 END

SELECT @allowed = SUM(CASE WHEN a.Active = 1 OR @reqall IN (0,1) THEN 1 ELSE 0 END), @groupmatch = MAX(CASE WHEN a.GroupID = @GroupID THEN 1 ELSE 0 END)
FROM
	(
	SELECT g.GroupID, g.Active
	FROM OperatorGroupAccess oga JOIN Groups g ON (oga.GroupID = g.GroupID)
		WHERE oga.ObjectGroupID = 101 
		AND oga.AccessType & 1 = 1
		AND oga.OperatorGroupID = @OperatorGroupID
		AND g.OrganizationID = @OrganizationID
	GROUP BY g.GroupID, g.Active
	) a

IF (@GroupID IS NOT NULL)
	BEGIN
	SELECT @result = @groupmatch
	END
END

IF (@result IS NULL)
BEGIN
SELECT @total = COUNT(*) FROM Groups WHERE OrganizationID = @OrganizationID AND (Active = 1 OR @reqall IN (0,1))

SELECT @result = CASE 
	WHEN @reqall = 0 AND @total > 0 AND @allowed > 0 THEN 1
	WHEN @reqall IN (1,2) AND @allowed = @total AND @total > 0 THEN 1
	ELSE 0 END
END

SELECT CASE WHEN @result = 1 THEN 1 ELSE 0 END AS Allowed
GO

CREATE PROCEDURE dbo.ReportChangeTables (@AuditTransID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT adt.AuditTableID, adt.MetaTableID, mt.TableName, mt.Description, adt.KeyID, adt.AuditActionID, aa.AuditAction, aa.StringID AS aaStringID, (SELECT MIN(Description) FROM MetaColumns mc WHERE adt.MetaTableID = mc.MetaTableID AND mc.IsKey = 1 AND mc.Quoted = 0) AS KeyCol
FROM AuditTables adt JOIN MetaTables mt ON (adt.MetaTableID = mt.MetaTableID)
	JOIN AuditActions aa ON (adt.AuditActionID = aa.AuditActionID)
	WHERE adt.AuditTransID = @AuditTransID
GO

CREATE PROCEDURE dbo.ReportChangeTrans (@AuditTransID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT AuditTransID, atr.OperatorID, atr.CustomerID, o.Operator, a.FirstName, a.LastName, a.Company, atr.CommitDate, atr.IPAddress
FROM AuditTrans atr LEFT JOIN Operators o ON (atr.OperatorID = o.OperatorID)
	LEFT JOIN MasterAccounts ma ON (atr.CustomerID = ma.CustomerID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE atr.AuditTransID = @AuditTransID
GO

CREATE PROCEDURE dbo.ReportChangeInserts (@OperatorGroupID INT, @AuditTableID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mc.Description, mc.StringID, CASE WHEN ISNUMERIC(ati.Data) = 1 AND mc.MetaRuleID = 7 THEN 1 ELSE 0 END AS IsDT, ati.Data,
CASE WHEN ISNUMERIC(ati.Data) = 1 AND mc.DepTable IS NOT NULL AND mc.DepColumn IS NOT NULL AND EXISTS (SELECT * FROM MetaColumns mc2 JOIN MetaTables mt2 ON (mc2.MetaTableID = mt2.MetaTableID) 
	WHERE mc2.ColumnName = CASE WHEN mc.DepTable IN ('Taxes','Addresses') THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-2) WHEN mc.DepTable LIKE '%ies' THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-3) + 'y' ELSE LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-1) END
	AND mt2.TableName = mc.DepTable) THEN 1 ELSE 0 END AS Lookup, mc.DepTable, CASE WHEN mc.DepTable IN ('Taxes','Addresses') THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-2) WHEN mc.DepTable LIKE '%ies' THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-3) + 'y' ELSE LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-1) END AS DepLabel, mc.DepColumn

FROM AuditTableInserts ati JOIN MetaColumns mc ON (ati.MetaColumnID = mc.MetaColumnID)
	WHERE ati.AuditTableID = @AuditTableID
	AND (mc.MetaRuleID NOT IN (2,11,29) OR @OperatorGroupID = 1)
ORDER BY 1
GO

CREATE PROCEDURE dbo.ReportChangeUpdates (@OperatorGroupID INT, @AuditTableID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mc.Description, mc.StringID, CASE WHEN ISNUMERIC(atu.Data) = 1 AND mc.MetaRuleID = 7 THEN 1 ELSE 0 END AS IsDT, CASE WHEN ISNUMERIC(atu.PreviousData) = 1 AND mc.MetaRuleID = 7 THEN 1 ELSE 0 END AS IsDTPrev, atu.PreviousData, atu.Data, ISNUMERIC(atu.Data) AS LookupData, ISNUMERIC(atu.PreviousData) AS LookupPrevData,
CASE WHEN mc.DepTable IS NOT NULL AND mc.DepColumn IS NOT NULL AND EXISTS (SELECT * FROM MetaColumns mc2 JOIN MetaTables mt2 ON (mc2.MetaTableID = mt2.MetaTableID) 
	WHERE mc2.ColumnName = CASE WHEN mc.DepTable IN ('Taxes','Addresses') THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-2) WHEN mc.DepTable LIKE '%ies' THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-3) + 'y' ELSE LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-1) END
	AND mt2.TableName = mc.DepTable) THEN 1 ELSE 0 END AS Lookup, mc.DepTable, CASE WHEN mc.DepTable IN ('Taxes','Addresses') THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-2) WHEN mc.DepTable LIKE '%ies' THEN LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-3) + 'y' ELSE LEFT(mc.DepTable,DATALENGTH(mc.DepTable)-1) END AS DepLabel, mc.DepColumn

FROM AuditTableUpdates atu JOIN MetaColumns mc ON (atu.MetaColumnID = mc.MetaColumnID)
	WHERE atu.AuditTableID = @AuditTableID
	AND (mc.MetaRuleID NOT IN (2,11,29) OR @OperatorGroupID = 1)
ORDER BY 1
GO

CREATE PROCEDURE dbo.ReportInvoicePayAccum (@CustomerID INT) AS
SET NOCOUNT ON

SELECT CreateDate, Amount 
FROM Invoices
	WHERE CustomerID = @CustomerID
	AND Processed = 1
	AND VoidDate IS NULL

UNION ALL

SELECT COALESCE(FinalCreateDate,CreateDate), -COALESCE(FinalAmount,Amount) 
FROM Payments
	WHERE CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.ReportInvoicePayDist (@CustomerID INT) AS
SET NOCOUNT ON
CREATE TABLE #risip (InvoiceID INT, PaymentID INT, Amount NUMERIC(18,4))
CREATE INDEX i_risip_IID_PID ON #risip (InvoiceID,PaymentID)

INSERT INTO #risip (InvoiceID, PaymentID, Amount)
SELECT i.InvoiceID, pi1.PaymentID, SUM(pi1.Amount) AS Amount
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	WHERE pi1.InactiveDate IS NULL
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.CustomerID = @CustomerID
GROUP BY i.InvoiceID, pi1.PaymentID

SELECT i.InvoiceID, i.CreateDate, it1.InvoiceType, CASE WHEN i.ChargeAmount <= i.PaidAmount THEN 1 ELSE 0 END AS IsPaid,
ap.PayCnt, ap.PayAmount, ap.PayAmount - apmin.Amount - CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN apmax.Amount ELSE 0 END AS midAmount,
pmin.PaymentID AS minPaymentID, pmin.CreateDate AS minCreateDate, ptmax.PaymentType AS minPaymentType, DATEDIFF(dd,i.CreateDate,pmin.CreateDate) AS minDays, apmin.Amount AS minAmount,
CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN pmax.PaymentID END AS maxPaymentID,
CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN pmax.CreateDate END AS maxCreateDate,
CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN ptmax.PaymentType END AS maxPaymentType,
CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN DATEDIFF(dd,i.CreateDate,pmax.CreateDate) END AS maxDays, 
CASE WHEN ap.minPaymentID <> ap.maxPaymentID THEN apmax.Amount END AS maxAmount
FROM 
	(
	SELECT InvoiceID, COUNT(DISTINCT PaymentID) AS PayCnt, SUM(Amount) AS PayAmount, MIN(PaymentID) AS minPaymentID, MAX(PaymentID) AS maxPaymentID
	FROM #risip
	GROUP BY InvoiceID
	) ap JOIN Invoices i ON (ap.InvoiceID = i.InvoiceID)
	JOIN InvoiceTypes it1 ON (i.InvoiceTypeID = it1.InvoiceTypeID)
	JOIN Payments pmin ON (ap.minPaymentID = pmin.PaymentID)
	JOIN PaymentTypes ptmin ON (pmin.PaymentTypeID = ptmin.PaymentTypeID)
	JOIN Payments pmax ON (ap.maxPaymentID = pmax.PaymentID)
	JOIN PaymentTypes ptmax ON (pmax.PaymentTypeID = ptmax.PaymentTypeID)
	JOIN #risip apmin ON (ap.InvoiceID = apmin.InvoiceID AND ap.minPaymentID = apmin.PaymentID)
	JOIN #risip apmax ON (ap.InvoiceID = apmax.InvoiceID AND ap.maxPaymentID = apmax.PaymentID)
GO

CREATE PROCEDURE dbo.ReportPaymentsGL (@sd DATETIME, @ed DATETIME, @OrganizationID INT, @GroupID INT, @RegionID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

CREATE TABLE #rpgl (PayMonth INT, GLCodeID INT, Amount NUMERIC(18,4))
CREATE TABLE #rpglcodes (GLCodeID INT)

INSERT INTO #rpgl (PayMonth,GLCodeID,Amount)
SELECT DATEDIFF(mm,@sd,pi1.ActiveDate) AS PayMonth, COALESCE(at1.GLCodeID,ct.GLCodeID,t.GLCodeID) AS GLCodeID, SUM(pi1.Amount) AS Amount
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE pi1.ActiveDate BETWEEN @sd AND @ed
	AND pi1.PaymentID IS NOT NULL
	AND pi1.InactiveDate IS NULL
	AND (at1.GLCodeID IS NOT NULL OR ct.GLCodeID IS NOT NULL OR t.GLCodeID IS NOT NULL)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
GROUP BY DATEDIFF(mm,@sd,pi1.ActiveDate), COALESCE(at1.GLCodeID,ct.GLCodeID,t.GLCodeID)

INSERT INTO #rpglcodes (GLCodeID)
SELECT DISTINCT GLCodeID FROM #rpgl WHERE Amount > 0

SELECT DATEADD(mm,n.n,@sd) AS MonthStart, gl.GLCode, COALESCE(p.Amount,0) AS Amount
FROM Numbers n CROSS JOIN GLCodes gl
	LEFT JOIN #rpgl p ON (n.n = p.PayMonth AND gl.GLCodeID = p.GLCodeID)
	WHERE n.n < DATEDIFF(mm,@sd,@ed)
	AND gl.GLCodeID IN (SELECT GLCodeID FROM #rpglcodes)
ORDER BY 2,1
GO

CREATE PROCEDURE dbo.ReportPaymentsPayType (@sd DATETIME, @ed DATETIME, @OrganizationID INT, @GroupID INT, @RegionID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DATEADD(mm,n.n,@sd) AS MonthStart, pt.PaymentType, pt.StringID AS ptStringID, COALESCE(p.AmountSum,0) AS AmountSum, COALESCE(p.AmountAvg,0) AS AmountAvg, COALESCE(p.PayCount,0) AS PayCount, COALESCE(p.CreditSum,0) AS CreditSum
FROM Numbers n JOIN PaymentTypes pt ON (pt.SortOrder >= 0 AND pt.IsPayType = 1)
	LEFT JOIN
		(
		SELECT DATEDIFF(mm,@sd,p.CreateDate) AS PayMonth, MIN(p.PaymentTypeID) AS PaymentTypeID, SUM(COALESCE(p.FinalAmount,p.Amount)) AS AmountSum, AVG(COALESCE(p.FinalAmount,p.Amount)) AS AmountAvg, COUNT(*) AS PayCount, SUM(CASE WHEN p.FinalAmount IS NOT NULL AND p.FinalAmount <= p.Amount THEN p.Amount - p.FinalAmount ELSE 0 END) AS CreditSum
		FROM Payments 