CREATE PROCEDURE dbo.TabName2Description ( @tab varchar(64),  @d varchar(72) OUTPUT)  AS
set nocount on
DECLARE @i int
Select @i = 2, @d = upper(substring(@tab, 1, 1))
while (@i <= datalength(@tab) )
	BEGIN
	if ascii(substring(@tab, @i, 1)) = ascii(upper(substring(@tab, @i, 1))) and
		ascii(substring(@tab, @i-1, 1)) <> ascii(upper(substring(@tab, @i-1, 1))) 
		select @d = @d + ' ' + substring(@tab, @i, 1)
	else
		select @d = @d + substring(@tab, @i, 1)
	select @i = @i + 1
	END
if left(@d,4) = 'Rad ' 
	select @d = substring(@d, 5, datalength(@d)-4)
select @d = REPLACE (@d, 'Rad ', 'RADIUS ')
GO

CREATE PROCEDURE dbo.MetaTableAdd (@tabname varchar(64)) AS
DECLARE @t varchar(72), @cname varchar(64), @mcid int
INSERT INTO MetaTables(TableName,Description)
Select TableName=Convert(varchar,name), 'N/A' AS Description
From sysobjects
Where type = 'U'
	and name = @tabname
	AND @tabname NOT IN (SELECT TableName FROM MetaTables)
INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case isnullable when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	'N/A' AS Description,
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, NULL as DepGroup, NULL as DepColumn, 	
	CASE WHEN st.name in ('datetime') THEN 7 ELSE NULL END as MetaRuleID, mt.MetaTableID, 
	0 as MinSize, isnullable as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.xtype = st.xtype
	and so.name = @tabname
	AND CONVERT(VARCHAR,sc.name) NOT IN (SELECT ColumnName FROM MetaColumns WHERE MetaTableID = mt.MetaTableID)
Update mc
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = fkeyid
	and fc.id = fkeyid	
	and fc.colid = fkey1
	and rt.id = rkeyid
	and rc.id = rkeyid	
	and rc.colid = rkey1
	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and ft.name = @tabname
	AND mc.DepTable IS NULL
	AND mc.DepColumn IS NULL
Update mc Set Required=0
From syscolumns sc, sysobjects so, MetaColumns mc, MetaTables mt
Where so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and so.id = sc.id
	and so.type = 'U'
	and sc.cdefault > 0
	and mt.TableName = @tabname
Update mc Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
	and mt.TableName = @tabname
EXEC TabName2Description @tabname, @t OUTPUT
Update MetaTables Set Description = @t Where TableName = @tabname AND Description = 'N/A'
DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = @tabname
OPEN clist
FETCH NEXT FROM clist INTO @mcid, @cname
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	EXEC TabName2Description @cname, @t OUTPUT
	Update MetaColumns Set Description = @t Where MetaColumnID = @mcid AND Description = 'N/A'
	FETCH NEXT FROM clist INTO @mcid, @cname
	END
close clist
deallocate clist

IF ((SELECT SUM(CASE WHEN mc.Quoted = 1 THEN 2 ELSE 1 END)
FROM MetaTables mt JOIN MetaColumns mc ON (mt.MetaTableID=mc.MetaTableID)
	AND mc.IsKey = 1
	AND mt.TableName = @tabname) <> 1)
BEGIN
UPDATE MetaTables SET Auditable = 0 WHERE TableName = @tabname
END
GO

CREATE PROCEDURE dbo.MetaTableDelete (@tablename VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @MetaTableID INT
SELECT @MetaTableID = MetaTableID FROM MetaTables WHERE TableName = @tablename

IF (@MetaTableID IS NOT NULL)
BEGIN
DELETE FROM AuditTableUpdates WHERE MetaColumnID IN (SELECT MetaColumnID FROM MetaColumns WHERE MetaTableID = @MetaTableID)
DELETE FROM AuditTableInserts WHERE MetaColumnID IN (SELECT MetaColumnID FROM MetaColumns WHERE MetaTableID = @MetaTableID)
DELETE FROM AuditTables WHERE MetaTableID = @MetaTableID
DELETE FROM MetaColumns WHERE MetaTableID = @MetaTableID
DELETE FROM MetaTables WHERE MetaTableID = @MetaTableID
END ELSE BEGIN
SELECT 'The table ' + @tablename + ' was not found in MetaTables'
END
GO

CREATE PROCEDURE dbo.DeleteALLAccounts (@dbname VARCHAR(64), @confirm VARCHAR(32)) AS
SET NOCOUNT ON

IF (@dbname IS NULL)
BEGIN
RAISERROR('Database name is required',11,1)
RETURN
END

IF (@dbname <> db_name())
BEGIN
RAISERROR('The current database does not match @dbname input parameter',11,1)
RETURN
END

IF (@@TRANCOUNT = 0)
BEGIN
RAISERROR('This must run within a transaction',11,1)
RETURN
END

IF (@confirm <> 'I AM SERIOUS')
BEGIN
RAISERROR('Invalid confirmation response',11,1);
RETURN
END

UPDATE Organizations SET ResellerCustomerID = NULL WHERE ResellerCustomerID IS NOT NULL
UPDATE Domains SET CustomerID = NULL WHERE CustomerID IS NOT NULL
UPDATE InvoiceItems SET ChargeID = NULL WHERE ChargeID IS NOT NULL
UPDATE MasterAccounts SET BillingAddressID = NULL, ShippingAddressID = NULL, ServiceAddressID = NULL, LastStatementID = NULL
UPDATE SubAccounts SET ServiceAddressID = NULL, ContactAddressID = NULL, ParentAccountID = NULL, RefAccountID = NULL
UPDATE InvItemLogs SET CustomerID = NULL, AccountID = NULL, ItemID = NULL
UPDATE InvItems SET CustomerID = NULL, AccountID = NULL, ItemID = NULL
UPDATE Payments SET StatementID = NULL, FinalStatementID = NULL
UPDATE Invoices SET StatementID = NULL, VoidStatementID = NULL

DELETE FROM Aliases
DELETE FROM Forwards
DELETE FROM Actions
DELETE FROM Files
DELETE FROM IncidentData
DELETE FROM Incidents
DELETE FROM RadConfigs
DELETE FROM RateHistory
DELETE FROM SubAccountData
DELETE FROM PaymentItems
DELETE FROM Charges
DELETE FROM ResellerUsage
DELETE FROM InvoiceItemDiscounts
DELETE FROM InvoiceItems
DELETE FROM AccountChanges
DELETE FROM AccountTagTimes
DELETE FROM AddressSyncs WHERE AddressID IN (SELECT AddressID FROM Addresses WHERE CustomerID IS NOT NULL OR AccountID IS NOT NULL)
DELETE FROM AddressData WHERE AddressID IN (SELECT AddressID FROM Addresses WHERE CustomerID IS NOT NULL OR AccountID IS NOT NULL)
DELETE FROM Addresses WHERE CustomerID IS NOT NULL OR AccountID IS NOT NULL
DELETE FROM AlertFileSubAccounts
DELETE FROM AlertInvSubAccounts
DELETE FROM Alerts WHERE CustomerID IS NOT NULL OR AccountID IS NOT NULL
DELETE FROM ServerPorts
DELETE FROM CallInterims
DELETE FROM CallStops
DELETE FROM CallStarts
DELETE FROM CardAccounts WHERE DirectCustomerID IS NOT NULL OR DirectAccountID IS NOT NULL
DELETE FROM ExternalSyncs
DELETE FROM GaugeCounterData
DELETE FROM GaugeData
DELETE FROM InvoiceSubAccounts
DELETE FROM InvoiceTags
DELETE FROM OperatorCookies WHERE AccountID IS NOT NULL
DELETE FROM PosixAccountUsers
DELETE FROM RadLogs
DELETE FROM RefStates
DELETE FROM SubAccountTags
DELETE FROM SubAccountUsages
DELETE FROM SubAccounts
DELETE FROM AlertFileMasterAccounts
DELETE FROM AlertInvMasterAccounts
DELETE FROM AuditTableInserts
DELETE FROM AuditTableUpdates
DELETE FROM AuditTables
DELETE FROM AuditTrans
DELETE FROM BankTrans
DELETE FROM CreditCards
DELETE FROM ExternalTrans
DELETE FROM Invoices
DELETE FROM MasterAccountData
DELETE FROM MasterAccountPromoCodes
DELETE FROM MasterAccountTags
DELETE FROM Payments
DELETE FROM Statements
DELETE FROM NoticeLogs
DELETE FROM MasterAccounts
GO

CREATE PROCEDURE dbo.sizecheck (@column VARCHAR(64)) AS
SET NOCOUNT ON
SELECT CONVERT(VARCHAR(32),st.name) AS TableName,CONVERT(VARCHAR(32),sc.name) AS ColumnName, sc.length, CASE WHEN MIN(sr1.rkeyid) IS NULL AND MIN(sr2.constid) IS NULL THEN 'No References' WHEN MIN(sr1.rkeyid) IS NOT NULL THEN object_name(MIN(sr1.rkeyid)) 

ELSE 'Primary key /w ' + CAST(COUNT(sr2.constid) AS VARCHAR(10)) + ' references' END AS KeyInfo, 
MIN(si.rowcnt) AS rows
FROM sysobjects st JOIN syscolumns sc ON (st.id = sc.id)
	LEFT JOIN sysindexes si ON (st.name = si.name)
	LEFT JOIN sysreferences sr1 ON (sc.id = sr1.fkeyid AND colorder = sr1.fkey1)
	LEFT JOIN sysreferences sr2 ON (sc.id = sr2.rkeyid AND colorder = sr2.rkey1)
	WHERE sc.name LIKE '%' + @column + '%'
	AND sc.name NOT LIKE '@%'
	AND st.id = sc.id
GROUP BY st.name, sc.name, sc.length
GO

CREATE PROCEDURE dbo.procstat (@procname VARCHAR(64) = NULL) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @interval_id BIGINT

IF (@procname IS NOT NULL)
BEGIN
SELECT StartDate, 
ROUND(SUM(TimeTotal) / MAX(Calls),2) AS Runtime,
ROUND(SUM(ReadTotal) / MAX(Calls),0) AS Reads,
ROUND(SUM(WriteTotal) / MAX(Calls),0) AS Writes,
ROUND(1.0 * SUM(LockTotal) / MAX(Calls),2) AS LockWait,
ROUND(1.0 * SUM(NetTotal) / MAX(Calls),2) AS NetWait,
ROUND(1.0 * SUM(BufTotal) / MAX(Calls),2) AS BufWait,
ROUND(SUM(CPUTotal) / MAX(Calls),2) AS CPU,
ROUND(MAX(Calls) / (DATEDIFF(ss,MIN(StartDate),MAX(CASE WHEN EndDate < getdate() THEN EndDate ELSE getdate() END)) + 0.0),2) AS CPS,
MAX(Calls) AS Calls,
ROUND(SUM(RowTotal) / MAX(Calls),0) AS Rows
FROM
	(
	SELECT CAST(SWITCHOFFSET(MIN(qsrsi.start_time),DATEPART(tz,SYSDATETIMEOFFSET())) AS DATETIME) AS StartDate, 
	CAST(SWITCHOFFSET(MIN(qsrsi.end_time),DATEPART(tz,SYSDATETIMEOFFSET())) AS DATETIME) AS EndDate, 
	SUM(qsrs.avg_duration / 1000 * qsrs.count_executions) AS TimeTotal,
	SUM(qsrs.avg_logical_io_reads * qsrs.count_executions) AS ReadTotal,
	SUM(qsrs.avg_logical_io_writes * qsrs.count_executions) AS WriteTotal,
	MAX(alck.LckTotal) AS LockTotal,
	MAX(anet.NetTotal) AS NetTotal,
	MAX(abuf.BufTotal) AS BufTotal,
	SUM(qsrs.avg_cpu_time / 1000 * qsrs.count_executions) AS CPUTotal,
	SUM(qsrs.count_executions) AS Calls,
	SUM(qsrs.avg_rowcount * qsrs.count_executions) AS RowTotal
	FROM sys.query_store_query qsq JOIN sys.query_store_plan qsp ON (qsq.query_id = qsp.query_id)
		JOIN sys.query_store_runtime_stats qsrs ON (qsp.plan_id = qsrs.plan_id)
		JOIN sys.query_store_runtime_stats_interval qsrsi ON (qsrs.runtime_stats_interval_id = qsrsi.runtime_stats_interval_id)
		JOIN sysobjects so ON (qsq.object_id = so.id)
		LEFT JOIN
			(
			SELECT runtime_stats_interval_id, plan_id, SUM(total_query_wait_time_ms) AS LckTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 3
			GROUP BY runtime_stats_interval_id, plan_id
			) alck ON (qsp.plan_id = alck.plan_id AND qsrs.runtime_stats_interval_id = alck.runtime_stats_interval_id)
		LEFT JOIN
			(
			SELECT runtime_stats_interval_id, plan_id, SUM(total_query_wait_time_ms) AS NetTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 15
			GROUP BY runtime_stats_interval_id, plan_id
			) anet ON (qsp.plan_id = anet.plan_id AND qsrs.runtime_stats_interval_id = anet.runtime_stats_interval_id)
		LEFT JOIN 
			(
			SELECT runtime_stats_interval_id, plan_id, SUM(total_query_wait_time_ms) AS BufTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 6
			GROUP BY runtime_stats_interval_id, plan_id
			) abuf ON (qsp.plan_id = abuf.plan_id AND qsrs.runtime_stats_interval_id = abuf.runtime_stats_interval_id)
		WHERE so.name = @procname
	GROUP BY qsrs.runtime_stats_interval_id, qsp.plan_id
	) psa
GROUP BY StartDate
ORDER BY StartDate DESC
END ELSE BEGIN
SELECT @interval_id = MAX(runtime_stats_interval_id) FROM sys.query_store_runtime_stats_interval

SELECT MIN(StartDate) AS StartDate, ProcName,
ROUND(SUM(TimeTotal) / MAX(Calls),2) AS Runtime,
ROUND(SUM(ReadTotal) / MAX(Calls),0) AS Reads,
ROUND(SUM(WriteTotal) / MAX(Calls),0) AS Writes,
ROUND(1.0 * SUM(LockTotal) / MAX(Calls),2) AS LockWait,
ROUND(1.0 * SUM(NetTotal) / MAX(Calls),2) AS NetWait,
ROUND(1.0 * SUM(BufTotal) / MAX(Calls),2) AS BufWait,
ROUND(SUM(CPUTotal) / MAX(Calls),2) AS CPU,
ROUND(MAX(Calls) / (DATEDIFF(ss,MIN(StartDate),MAX(CASE WHEN EndDate < getdate() THEN EndDate ELSE getdate() END)) + 0.0),2) AS CPS,
MAX(Calls) AS Calls,
ROUND(SUM(RowTotal) / MAX(Calls),0) AS Rows
FROM
	(
	SELECT MIN(so.name) AS ProcName, CAST(SWITCHOFFSET(MIN(qsrsi.start_time),DATEPART(tz,SYSDATETIMEOFFSET())) AS DATETIME) AS StartDate, 
	CAST(SWITCHOFFSET(MIN(qsrsi.end_time),DATEPART(tz,SYSDATETIMEOFFSET())) AS DATETIME) AS EndDate, 
	SUM(qsrs.avg_duration / 1000 * qsrs.count_executions) AS TimeTotal,
	SUM(qsrs.avg_logical_io_reads * qsrs.count_executions) AS ReadTotal,
	SUM(qsrs.avg_logical_io_writes * qsrs.count_executions) AS WriteTotal,
	MAX(alck.LckTotal) AS LockTotal,
	MAX(anet.NetTotal) AS NetTotal,
	MAX(abuf.BufTotal) AS BufTotal,
	SUM(qsrs.avg_cpu_time / 1000 * qsrs.count_executions) AS CPUTotal,
	SUM(qsrs.count_executions) AS Calls,
	SUM(qsrs.avg_rowcount * qsrs.count_executions) AS RowTotal
	FROM sys.query_store_query qsq JOIN sys.query_store_plan qsp ON (qsq.query_id = qsp.query_id)
		JOIN sys.query_store_runtime_stats qsrs ON (qsp.plan_id = qsrs.plan_id)
		JOIN sys.query_store_runtime_stats_interval qsrsi ON (qsrs.runtime_stats_interval_id = qsrsi.runtime_stats_interval_id)
		JOIN sysobjects so ON (qsq.object_id = so.id)
		LEFT JOIN
			(
			SELECT plan_id, SUM(total_query_wait_time_ms) AS LckTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 3
				AND runtime_stats_interval_id = @interval_id
			GROUP BY plan_id
			) alck ON (qsp.plan_id = alck.plan_id)
		LEFT JOIN
			(
			SELECT plan_id, SUM(total_query_wait_time_ms) AS NetTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 15
				AND runtime_stats_interval_id = @interval_id
			GROUP BY plan_id
			) anet ON (qsp.plan_id = anet.plan_id)
		LEFT JOIN 
			(
			SELECT plan_id, SUM(total_query_wait_time_ms) AS BufTotal
			FROM sys.query_store_wait_stats
				WHERE wait_category = 6
				AND runtime_stats_interval_id = @interval_id
			GROUP BY plan_id
			) abuf ON (qsp.plan_id = abuf.plan_id)
		WHERE qsrs.runtime_stats_interval_id = @interval_id
	GROUP BY qsp.plan_id
	) psa
GROUP BY ProcName
ORDER BY ProcName
END
GO

CREATE PROCEDURE dbo.InvoiceGaps AS
SET NOCOUNT ON
SELECT MIN(ma.CustomerID) AS CustomerID, sa.AccountID, MIN(ii.StartDate) AS Starting, MAX(ii.EndDate) AS Ending, 
DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate)) - (SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1) AS FreeDays,
(MIN(at1.Cost)/30) * (DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate)) - (SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1)) AS EstimatedCost

FROM MasterAccounts ma, SubAccounts sa, Invoices i, InvoiceItems ii, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CancelDate IS NULL
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.AccountID = sa.AccountID
	AND ii.StartDate > DATEADD(mm,-12,getdate())
	AND sa.BilledThru > DATEADD(mm,-1,getdate())
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.Cost > 0
GROUP BY sa.AccountID
HAVING SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1 < DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate))
GO

CREATE FUNCTION dbo.ParseDelim(@data VARCHAR(8000), @separator VARCHAR(5), @pos INT) RETURNS VARCHAR(8000) AS
BEGIN
DECLARE @cur INT, @start INT, @end INT

WHILE (@pos > 0)
	BEGIN
	SELECT @cur = CHARINDEX(@separator,@data,COALESCE(@end,1)), @pos = @pos - 1
	IF (@cur IS NULL OR @cur = 0)
		BEGIN
		IF (@pos = 0)
			SELECT @start = COALESCE(@end,1), @end = DATALENGTH(@data) + 2
		BREAK
		END

	SELECT @start = COALESCE(@end,1), @end = @cur + 1
	END

IF (@pos = 0)
	RETURN SUBSTRING(@data,@start,@end - @start - 1)

RETURN NULL
END
GO

