CREATE PROCEDURE dbo.CT_InvAttrMaps (@InvAttrMap VARCHAR(255),@InvAttrMapID SMALLINT,@RegExp VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE InvAttrMaps SET InvAttrMap = @InvAttrMap,
	RegExp = @RegExp,
	SortOrder = @SortOrder
	WHERE InvAttrMapID = @InvAttrMapID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvAttrMaps (InvAttrMap,InvAttrMapID,RegExp,SortOrder)
VALUES (@InvAttrMap,@InvAttrMapID,@RegExp,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_DataTypes (@ConfigsOnly SMALLINT,@DataType VARCHAR(255),@DataTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE DataTypes SET ConfigsOnly = @ConfigsOnly,
	DataType = @DataType
	WHERE DataTypeID = @DataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO DataTypes (ConfigsOnly,DataType,DataTypeID)
VALUES (@ConfigsOnly,@DataType,@DataTypeID)
END
GO

CREATE PROCEDURE dbo.CT_AccountDataTypes (@AccountDataType VARCHAR(255),@AccountDataTypeID INT,@AllowMBR SMALLINT,@AllowSA SMALLINT,@DataTypeID SMALLINT,@RegExp VARCHAR(255),@SQLQuery VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
UPDATE AccountDataTypes SET AccountDataType = @AccountDataType,
	AllowMBR = @AllowMBR,
	AllowSA = @AllowSA,
	DataTypeID = @DataTypeID,
	RegExp = @RegExp,
	SQLQuery = @SQLQuery,
	StringID = @StringID
	WHERE AccountDataTypeID = @AccountDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountDataTypes (AccountDataType,AccountDataTypeID,AllowMBR,AllowSA,DataTypeID,RegExp,SQLQuery,StringID)
VALUES (@AccountDataType,@AccountDataTypeID,@AllowMBR,@AllowSA,@DataTypeID,@RegExp,@SQLQuery,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AccountDataValues (@AccountDataTypeID INT,@KeyData VARCHAR(255),@ValueData VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE AccountDataValues SET ValueData = @ValueData
	WHERE AccountDataTypeID = @AccountDataTypeID
	AND KeyData = @KeyData

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountDataValues (AccountDataTypeID,KeyData,ValueData)
VALUES (@AccountDataTypeID,@KeyData,@ValueData)
END
GO

CREATE PROCEDURE dbo.CT_Applications (@AppName VARCHAR(255),@ApplicationID INT) AS
SET NOCOUNT ON
UPDATE Applications SET AppName = @AppName
	WHERE ApplicationID = @ApplicationID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Applications (AppName,ApplicationID)
VALUES (@AppName,@ApplicationID)
END
GO

CREATE PROCEDURE dbo.CT_BatchStates (@BatchState VARCHAR(255),@BatchStateID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE BatchStates SET BatchState = @BatchState,
	StringID = @StringID
	WHERE BatchStateID = @BatchStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BatchStates (BatchState,BatchStateID,StringID)
VALUES (@BatchState,@BatchStateID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_BatchTypes (@BatchType VARCHAR(255),@BatchTypeID INT,@Description VARCHAR(8000),@StringID INT,@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE BatchTypes SET BatchType = @BatchType,
	Description = @Description,
	StringID = @StringID,
	TableName = @TableName
	WHERE BatchTypeID = @BatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BatchTypes (BatchType,BatchTypeID,Description,StringID,TableName)
VALUES (@BatchType,@BatchTypeID,@Description,@StringID,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_CardDigits (@AllowLogin SMALLINT,@AllowPassword SMALLINT,@CardDigit VARCHAR(255),@IEAID INT,@JavascriptField VARCHAR(8000),@JavascriptHeader VARCHAR(8000)) AS
SET NOCOUNT ON
UPDATE CardDigits SET JavascriptHeader = @JavascriptHeader,
	JavascriptField = @JavascriptField
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CardDigits (AllowLogin,AllowPassword,CardDigit,IEAID,JavascriptField,JavascriptHeader)
VALUES (@AllowLogin,@AllowPassword,@CardDigit,@IEAID,@JavascriptField,@JavascriptHeader)
END
GO

CREATE PROCEDURE dbo.CT_CardTypes (@CRC VARCHAR(255),@CardType VARCHAR(255),@CardTypeID INT,@Length1 INT,@Length2 INT) AS
SET NOCOUNT ON
UPDATE CardTypes SET CRC = @CRC,
	CardType = @CardType,
	Length1 = @Length1,
	Length2 = @Length2
	WHERE CardTypeID = @CardTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CardTypes (CRC,CardType,CardTypeID,Length1,Length2)
VALUES (@CRC,@CardType,@CardTypeID,@Length1,@Length2)
END
GO

CREATE PROCEDURE dbo.CT_CardTypePrefixes (@CardTypeID INT,@Prefix VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM CardTypePrefixes WHERE CardTypeID = @CardTypeID AND Prefix = @Prefix
IF (@CTcnt = 0)
BEGIN
INSERT INTO CardTypePrefixes (CardTypeID,Prefix)
VALUES (@CardTypeID,@Prefix)
END
GO

CREATE PROCEDURE dbo.CT_CertTypes (@CertType VARCHAR(255),@CertTypeID INT,@ChangePrivateKey SMALLINT,@ChangePublicKey SMALLINT,@Description VARCHAR(8000),@SortOrder SMALLINT,@StorePrivateKey SMALLINT,@StorePublicKey SMALLINT) AS
SET NOCOUNT ON
UPDATE CertTypes SET CertType = @CertType,
	ChangePrivateKey = @ChangePrivateKey,
	ChangePublicKey = @ChangePublicKey,
	Description = @Description,
	SortOrder = @SortOrder,
	StorePrivateKey = @StorePrivateKey,
	StorePublicKey = @StorePublicKey
	WHERE CertTypeID = @CertTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CertTypes (CertType,CertTypeID,ChangePrivateKey,ChangePublicKey,Description,SortOrder,StorePrivateKey,StorePublicKey)
VALUES (@CertType,@CertTypeID,@ChangePrivateKey,@ChangePublicKey,@Description,@SortOrder,@StorePrivateKey,@StorePublicKey)
END
GO

CREATE PROCEDURE dbo.CT_ExportTypes (@ExportType VARCHAR(255),@ExportTypeID SMALLINT,@IsBatch SMALLINT,@IsCC SMALLINT,@IsExternal SMALLINT,@IsGeo SMALLINT,@IsRealtime SMALLINT) AS
SET NOCOUNT ON
UPDATE ExportTypes SET ExportType = @ExportType,
	IsBatch = @IsBatch,
	IsCC = @IsCC,
	IsExternal = @IsExternal,
	IsGeo = @IsGeo,
	IsRealtime = @IsRealtime
	WHERE ExportTypeID = @ExportTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExportTypes (ExportType,ExportTypeID,IsBatch,IsCC,IsExternal,IsGeo,IsRealtime)
VALUES (@ExportType,@ExportTypeID,@IsBatch,@IsCC,@IsExternal,@IsGeo,@IsRealtime)
END
GO

CREATE PROCEDURE dbo.CT_Exports (@ApproveMatch SMALLINT,@ApproveString VARCHAR(255),@AuthMatch SMALLINT,@AuthString VARCHAR(255),@CreditMatch SMALLINT,@CreditString VARCHAR(255),@DeclineMatch SMALLINT,@DeclineString VARCHAR(255),@DefaultProcessorURL VARCHAR(255),@Description VARCHAR(255),@ExportID INT,@ExportType SMALLINT,@Features INT,@FileTokenLocal VARCHAR(255),@Filter VARCHAR(255),@FormatDefault INT,@HeaderRow SMALLINT,@ImportKeySeparator VARCHAR(255),@ImportKeyValueSeparator VARCHAR(255),@Lines SMALLINT,@QuoteString VARCHAR(255),@Retries INT,@RetryDelay INT,@SQLString VARCHAR(255),@Separator VARCHAR(255),@StageCount INT,@Template VARCHAR(8000),@VoidMatch SMALLINT,@VoidString VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Exports SET ApproveMatch = @ApproveMatch,
	ApproveString = @ApproveString,
	AuthMatch = @AuthMatch,
	AuthString = @AuthString,
	CreditMatch = @CreditMatch,
	CreditString = @CreditString,
	DeclineMatch = @DeclineMatch,
	DeclineString = @DeclineString,
	DefaultProcessorURL = @DefaultProcessorURL,
	Description = @Description,
	ExportType = @ExportType,
	Features = @Features,
	FileTokenLocal = @FileTokenLocal,
	Filter = @Filter,
	FormatDefault = @FormatDefault,
	HeaderRow = @HeaderRow,
	ImportKeySeparator = @ImportKeySeparator,
	ImportKeyValueSeparator = @ImportKeyValueSeparator,
	Lines = @Lines,
	QuoteString = @QuoteString,
	Retries = @Retries,
	RetryDelay = @RetryDelay,
	SQLString = @SQLString,
	Separator = @Separator,
	StageCount = @StageCount,
	Template = @Template,
	VoidMatch = @VoidMatch,
	VoidString = @VoidString
	WHERE ExportID = @ExportID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Exports (ApproveMatch,ApproveString,AuthMatch,AuthString,CreditMatch,CreditString,DeclineMatch,DeclineString,DefaultProcessorURL,Description,ExportID,ExportType,Features,FileTokenLocal,Filter,FormatDefault,HeaderRow,ImportKeySeparator,ImportKeyValueSeparator,Lines,QuoteString,Retries,RetryDelay,SQLString,Separator,StageCount,Template,VoidMatch,VoidString)
VALUES (@ApproveMatch,@ApproveString,@AuthMatch,@AuthString,@CreditMatch,@CreditString,@DeclineMatch,@DeclineString,@DefaultProcessorURL,@Description,@ExportID,@ExportType,@Features,@FileTokenLocal,@Filter,@FormatDefault,@HeaderRow,@ImportKeySeparator,@ImportKeyValueSeparator,@Lines,@QuoteString,@Retries,@RetryDelay,@SQLString,@Separator,@StageCount,@Template,@VoidMatch,@VoidString)
END
GO

CREATE PROCEDURE dbo.CT_ExportColumns (@Align SMALLINT,@Description VARCHAR(255),@ExportID INT,@ExportValue VARCHAR(255),@FieldName VARCHAR(255),@Format SMALLINT,@IEAID INT,@Include SMALLINT,@MaxSize SMALLINT,@MinSize SMALLINT,@Padding CHAR(32),@Quoted SMALLINT,@SortOrder SMALLINT,@TransType INT) AS
SET NOCOUNT ON
UPDATE ExportColumns SET Align = @Align,
	Description = @Description,
	ExportID = @ExportID,
	ExportValue = @ExportValue,
	FieldName = @FieldName,
	Format = @Format,
	Include = @Include,
	MaxSize = @MaxSize,
	MinSize = @MinSize,
	Padding = @Padding,
	Quoted = @Quoted,
	SortOrder = @SortOrder,
	TransType = @TransType
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExportColumns (Align,Description,ExportID,ExportValue,FieldName,Format,IEAID,Include,MaxSize,MinSize,Padding,Quoted,SortOrder,TransType)
VALUES (@Align,@Description,@ExportID,@ExportValue,@FieldName,@Format,@IEAID,@Include,@MaxSize,@MinSize,@Padding,@Quoted,@SortOrder,@TransType)
END
GO

CREATE PROCEDURE dbo.CT_CCImportColumns (@ApproveValue VARCHAR(255),@DeclineValue VARCHAR(255),@Description VARCHAR(255),@ErrorValue VARCHAR(255),@ExportID INT,@FieldSize SMALLINT,@FieldType SMALLINT,@IEAID INT,@Line INT,@Position SMALLINT,@Quoted SMALLINT,@SortOrder SMALLINT,@TransType INT) AS
SET NOCOUNT ON
UPDATE CCImportColumns SET ApproveValue = @ApproveValue,
	DeclineValue = @DeclineValue,
	Description = @Description,
	ErrorValue = @ErrorValue,
	ExportID = @ExportID,
	FieldSize = @FieldSize,
	FieldType = @FieldType,
	Line = @Line,
	Position = @Position,
	Quoted = @Quoted,
	SortOrder = @SortOrder,
	TransType = @TransType
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CCImportColumns (ApproveValue,DeclineValue,Description,ErrorValue,ExportID,FieldSize,FieldType,IEAID,Line,Position,Quoted,SortOrder,TransType)
VALUES (@ApproveValue,@DeclineValue,@Description,@ErrorValue,@ExportID,@FieldSize,@FieldType,@IEAID,@Line,@Position,@Quoted,@SortOrder,@TransType)
END
GO

CREATE PROCEDURE dbo.CT_ConfigGroups (@ConfigGroupID INT,@Name VARCHAR(255),@SortOrder SMALLINT,@VisibleGlobal SMALLINT,@VisibleGroupID SMALLINT,@VisibleOperatorGroupID SMALLINT) AS
SET NOCOUNT ON
UPDATE ConfigGroups SET Name = @Name,
	SortOrder = @SortOrder,
	VisibleGlobal = @VisibleGlobal,
	VisibleGroupID = @VisibleGroupID,
	VisibleOperatorGroupID = @VisibleOperatorGroupID
	WHERE ConfigGroupID = @ConfigGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ConfigGroups (ConfigGroupID,Name,SortOrder,VisibleGlobal,VisibleGroupID,VisibleOperatorGroupID)
VALUES (@ConfigGroupID,@Name,@SortOrder,@VisibleGlobal,@VisibleGroupID,@VisibleOperatorGroupID)
END
GO

CREATE PROCEDURE dbo.CT_Configs (@AllowGlobal SMALLINT,@AllowGroupID SMALLINT,@AllowOperatorGroupID SMALLINT,@ConfigGroupID INT,@ConfigID INT,@Data VARCHAR(255),@DataTypeID SMALLINT,@Description VARCHAR(255),@FeatureID INT,@NumValue NUMERIC(18,4),@SortOrder SMALLINT,@ValuesQuery VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Configs SET ConfigGroupID = @ConfigGroupID,
	DataTypeID = @DataTypeID,
	Description = @Description,
	FeatureID = @FeatureID,
	AllowGlobal = @AllowGlobal,
	AllowGroupID = @AllowGroupID,
	AllowOperatorGroupID = @AllowOperatorGroupID,
	ValuesQuery = @ValuesQuery
	WHERE ConfigID = @ConfigID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Configs (AllowGlobal,AllowGroupID,AllowOperatorGroupID,ConfigGroupID,ConfigID,Data,DataTypeID,Description,FeatureID,NumValue,SortOrder,ValuesQuery)
VALUES (@AllowGlobal,@AllowGroupID,@AllowOperatorGroupID,@ConfigGroupID,@ConfigID,@Data,@DataTypeID,@Description,@FeatureID,@NumValue,@SortOrder,@ValuesQuery)
END
GO

CREATE PROCEDURE dbo.CT_ConfigValues (@ConfigID INT,@NumValue NUMERIC(18,4),@ValueName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ConfigValues SET ValueName = @ValueName
	WHERE ConfigID = @ConfigID
	AND NumValue = @NumValue

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ConfigValues (ConfigID,NumValue,ValueName)
VALUES (@ConfigID,@NumValue,@ValueName)
END
GO

CREATE PROCEDURE dbo.CT2_Continents (@Continent VARCHAR(255),@ContinentID INT,@Hidden SMALLINT,@Planet VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Continents SET ContinentID = @ContinentID,
	Continent = @Continent,
	Planet = @Planet
	WHERE ContinentID = @ContinentID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Continents (Continent,ContinentID,Hidden,Planet,SortOrder)
VALUES (@Continent,@ContinentID,@Hidden,@Planet,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT2_Countries (@Abbr2 CHAR(32),@Abbr3 CHAR(32),@Comments VARCHAR(255),@ContinentID INT,@Country VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@Hidden SMALLINT,@InternetDomain VARCHAR(255),@NNLength SMALLINT,@Restricted SMALLINT,@SortOrder SMALLINT,@TelIDD VARCHAR(255),@TelLocPrefixLen SMALLINT,@TelNDD VARCHAR(255),@TelPrefix VARCHAR(255),@ZipStatus SMALLINT) AS
SET NOCOUNT ON
UPDATE Countries SET CountryID = @CountryID,
	ZipStatus = @ZipStatus,
	Country = @Country,
	InternetDomain = @InternetDomain,
	ContinentID = @ContinentID,
	TelPrefix = @TelPrefix,
	TelIDD = @TelIDD,
	TelNDD = @TelNDD,
	TelLocPrefixLen = @TelLocPrefixLen,
	Abbr2 = @Abbr2,
	Abbr3 = @Abbr3,
	NNLength = @NNLength
	WHERE CountryID = @CountryID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Countries (Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,NNLength,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus)
VALUES (@Abbr2,@Abbr3,@Comments,@ContinentID,@Country,@CountryID,@Currency,@Hidden,@InternetDomain,@NNLength,@Restricted,@SortOrder,@TelIDD,@TelLocPrefixLen,@TelNDD,@TelPrefix,@ZipStatus)
END
GO

CREATE PROCEDURE dbo.CT_TimeZones (@StringID INT,@TimeZone VARCHAR(255),@TimeZoneID NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE TimeZones SET StringID = @StringID,
	TimeZone = @TimeZone
	WHERE TimeZoneID = @TimeZoneID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TimeZones (StringID,TimeZone,TimeZoneID)
VALUES (@StringID,@TimeZone,@TimeZoneID)
END
GO

CREATE PROCEDURE dbo.CT_States (@Abbreviation VARCHAR(255),@CountryID INT,@LocalRef VARCHAR(255),@NationalRef VARCHAR(255),@NationalRegion VARCHAR(255),@SortOrder SMALLINT,@State VARCHAR(255),@TimeZone1 NUMERIC(18,4),@TimeZone2 NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE States SET CountryID = @CountryID,
	State = @State,
	Abbreviation = @Abbreviation,
	TimeZone1 = @TimeZone1,
	TimeZone2 = @TimeZone2,
	NationalRef = @NationalRef,
	NationalRegion = @NationalRegion
	WHERE CountryID = @CountryID
	AND State = @State

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO States (Abbreviation,CountryID,LocalRef,NationalRef,NationalRegion,SortOrder,State,TimeZone1,TimeZone2)
VALUES (@Abbreviation,@CountryID,@LocalRef,@NationalRef,@NationalRegion,@SortOrder,@State,@TimeZone1,@TimeZone2)
END
GO

CREATE PROCEDURE dbo.CT_SyncExamples (@Comments VARCHAR(8000),@Decrypt SMALLINT,@FeatureID INT,@KeyColumn VARCHAR(255),@SQLQuery VARCHAR(8000),@SyncExample VARCHAR(255),@SyncExampleID INT) AS
SET NOCOUNT ON
UPDATE SyncExamples SET Comments = @Comments,
	Decrypt = @Decrypt,
	FeatureID = @FeatureID,
	KeyColumn = @KeyColumn,
	SQLQuery = @SQLQuery,
	SyncExample = @SyncExample
	WHERE SyncExampleID = @SyncExampleID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SyncExamples (Comments,Decrypt,FeatureID,KeyColumn,SQLQuery,SyncExample,SyncExampleID)
VALUES (@Comments,@Decrypt,@FeatureID,@KeyColumn,@SQLQuery,@SyncExample,@SyncExampleID)
END
GO

CREATE PROCEDURE dbo.CT_EmailTypes (@EmailType VARCHAR(255),@EmailTypeID SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM EmailTypes WHERE EmailTypeID = @EmailTypeID
IF (@CTcnt = 0)
BEGIN
INSERT INTO EmailTypes (EmailType,EmailTypeID,SortOrder,StringID)
VALUES (@EmailType,@EmailTypeID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_FlowDirections (@FlowDirection VARCHAR(255),@FlowDirectionID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE FlowDirections SET FlowDirection = @FlowDirection,
	SortOrder = @SortOrder
	WHERE FlowDirectionID = @FlowDirectionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO FlowDirections (FlowDirection,FlowDirectionID,SortOrder)
VALUES (@FlowDirection,@FlowDirectionID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_PrintTypes (@CRData VARCHAR(255),@Data VARCHAR(255),@PrintType VARCHAR(255),@PrintTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE PrintTypes SET CRData = @CRData,
	Data = @Data,
	PrintType = @PrintType
	WHERE PrintTypeID = @PrintTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (@CRData,@Data,@PrintType,@PrintTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ExternalSystemTypes (@DescAux1 VARCHAR(255),@DescAux2 VARCHAR(255),@DescAux3 VARCHAR(255),@ExportID INT,@ExternalSystemType VARCHAR(255),@ExternalSystemTypeID INT,@ShowExportID SMALLINT,@ShowKey SMALLINT,@ShowLogin SMALLINT,@ShowMailHost SMALLINT,@ShowPassword SMALLINT,@ShowURL SMALLINT) AS
SET NOCOUNT ON
UPDATE ExternalSystemTypes SET DescAux1 = @DescAux1,
	DescAux2 = @DescAux2,
	DescAux3 = @DescAux3,
	ExportID = @ExportID,
	ExternalSystemType = @ExternalSystemType,
	ShowExportID = @ShowExportID,
	ShowKey = @ShowKey,
	ShowLogin = @ShowLogin,
	ShowMailHost = @ShowMailHost,
	ShowPassword = @ShowPassword,
	ShowURL = @ShowURL
	WHERE ExternalSystemTypeID = @ExternalSystemTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExternalSystemTypes (DescAux1,DescAux2,DescAux3,ExportID,ExternalSystemType,ExternalSystemTypeID,ShowExportID,ShowKey,ShowLogin,ShowMailHost,ShowPassword,ShowURL)
VALUES (@DescAux1,@DescAux2,@DescAux3,@ExportID,@ExternalSystemType,@ExternalSystemTypeID,@ShowExportID,@ShowKey,@ShowLogin,@ShowMailHost,@ShowPassword,@ShowURL)
END
GO

CREATE PROCEDURE dbo.CT_ExternalSystemDataTypes (@AccountDataTypeID INT,@ExternalSystemTypeID INT,@Required SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE ExternalSystemDataTypes SET ExternalSystemTypeID = @ExternalSystemTypeID,
	AccountDataTypeID = @AccountDataTypeID
	WHERE ExternalSystemTypeID = @ExternalSystemTypeID
	AND AccountDataTypeID = @AccountDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExternalSystemDataTypes (AccountDataTypeID,ExternalSystemTypeID,Required,SortOrder)
VALUES (@AccountDataTypeID,@ExternalSystemTypeID,@Required,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT2_Currencies (@Active SMALLINT,@Code VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@CurrencyID INT,@SortOrder SMALLINT,@Symbol VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Currencies SET Currency = @Currency,
	Symbol = @Symbol,
	Code = @Code
	WHERE CurrencyID = @CurrencyID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Currencies (Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol)
VALUES (@Active,@Code,@CountryID,@Currency,@CurrencyID,@SortOrder,@Symbol)
END
GO

CREATE PROCEDURE dbo.CT_Languages (@Active SMALLINT,@AllowIEAUpdate SMALLINT,@Description VARCHAR(255),@HttpAcceptLanguage VARCHAR(255),@LanguageID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Languages SET LanguageID = @LanguageID,
	Description = @Description,
	HttpAcceptLanguage = @HttpAcceptLanguage
	WHERE LanguageID = @LanguageID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Languages (Active,AllowIEAUpdate,Description,HttpAcceptLanguage,LanguageID,SortOrder)
VALUES (@Active,@AllowIEAUpdate,@Description,@HttpAcceptLanguage,@LanguageID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_LogMsgs (@LogMsg VARCHAR(255),@LogMsgID SMALLINT,@Severity INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE LogMsgs SET LogMsg = @LogMsg,
	Severity = @Severity,
	StringID = @StringID
	WHERE LogMsgID = @LogMsgID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO LogMsgs (LogMsg,LogMsgID,Severity,StringID)
VALUES (@LogMsg,@LogMsgID,@Severity,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_MenuItems (@Access VARCHAR(255),@AccessKey VARCHAR(255),@Attribute VARCHAR(255),@ColumnName VARCHAR(255),@Condition VARCHAR(255),@DescStringID INT,@Description VARCHAR(255),@FeatureID INT,@FileName VARCHAR(255),@HelpStringID INT,@Label VARCHAR(255),@LabelName VARCHAR(255),@Link VARCHAR(255),@MenuItem VARCHAR(255),@MenuItemID INT,@SectionObject VARCHAR(255),@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE MenuItems SET TableName = @TableName,
	ColumnName = @ColumnName,
	Label = @Label,
	MenuItem = @MenuItem,
	Description = @Description,
	FileName = @FileName,
	Access = @Access,
	Condition = @Condition,
	FeatureID = @FeatureID,
	DescStringID = @DescStringID,
	HelpStringID = @HelpStringID,
	AccessKey = @AccessKey,
	Link = @Link,
	Attribute = @Attribute,
	LabelName = @LabelName,
	SectionObject = @SectionObject
	WHERE MenuItemID = @MenuItemID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MenuItems (Access,AccessKey,Attribute,ColumnName,Condition,DescStringID,Description,FeatureID,FileName,HelpStringID,Label,LabelName,Link,MenuItem,MenuItemID,SectionObject,TableName)
VALUES (@Access,@AccessKey,@Attribute,@ColumnName,@Condition,@DescStringID,@Description,@FeatureID,@FileName,@HelpStringID,@Label,@LabelName,@Link,@MenuItem,@MenuItemID,@SectionObject,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_Menus (@Class VARCHAR(255),@Description VARCHAR(8000),@Menu VARCHAR(255),@MenuID INT) AS
SET NOCOUNT ON
UPDATE Menus SET Class = @Class,
	Description = @Description,
	Menu = @Menu
	WHERE MenuID = @MenuID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Menus (Class,Description,Menu,MenuID)
VALUES (@Class,@Description,@Menu,@MenuID)
END
GO

CREATE PROCEDURE dbo.CT_MenuSets (@MenuID INT,@MenuItemID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MenuSets SET SortOrder = @SortOrder
	WHERE MenuID = @MenuID
	AND MenuItemID = @MenuItemID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MenuSets (MenuID,MenuItemID,SortOrder)
VALUES (@MenuID,@MenuItemID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MetaRules (@MetaRule VARCHAR(255),@MetaRuleID INT) AS
SET NOCOUNT ON
UPDATE MetaRules SET MetaRule = @MetaRule
	WHERE MetaRuleID = @MetaRuleID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MetaRules (MetaRule,MetaRuleID)
VALUES (@MetaRule,@MetaRuleID)
END
GO

CREATE PROCEDURE dbo.CT_MetaTables (@AllowAudit SMALLINT,@Auditable SMALLINT,@Description VARCHAR(255),@GroupTable VARCHAR(255),@LabelTable VARCHAR(255),@SortOrder SMALLINT,@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE MetaTables SET AllowAudit = @AllowAudit,
	Auditable = @Auditable,
	Description = @Description,
	GroupTable = @GroupTable,
	LabelTable = @LabelTable,
	SortOrder = @SortOrder
	WHERE TableName = @TableName

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MetaTables (AllowAudit,Auditable,Description,GroupTable,LabelTable,SortOrder,TableName)
VALUES (@AllowAudit,@Auditable,@Description,@GroupTable,@LabelTable,@SortOrder,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_MetaColumns (@TableName VARCHAR(32), @ColumnName VARCHAR(32), @Description VARCHAR(255), @StringID INT, @DepTable VARCHAR(32), @DepColumn VARCHAR(32), @DepGroup INT, @MetaRuleID INT, @Required SMALLINT, @Nullable SMALLINT, @Quoted SMALLINT, @MinSize INT, @MaxSize INT, @IsKey SMALLINT, @AllowAudit TINYINT, @AddOnly TINYINT, @ColumnType INT, @RegExp VARCHAR(255), @CheckQuery VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @MetaTableID INT
SELECT @MetaTableID = MetaTableID FROM MetaTables WHERE TableName = @TableName
IF (@MetaTableID IS NOT NULL)
BEGIN
UPDATE MetaColumns SET Description = @Description,
	StringID = @StringID,
	DepTable = @DepTable,
	DepGroup = @DepGroup,
	MetaRuleID = @MetaRuleID,
	Required = @Required,
	Nullable = @Nullable,
	Quoted = @Quoted,
	MinSize = @MinSize,
	MaxSize = CASE WHEN @MaxSize > MaxSize THEN @MaxSize ELSE MaxSize END,
	IsKey = @IsKey,
	ColumnType = @ColumnType,
	AllowAudit = @AllowAudit,
	AddOnly = @AddOnly,
	CheckQuery = @CheckQuery
	WHERE MetaTableID = @MetaTableID
	AND ColumnName = @ColumnName
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO MetaColumns (MetaTableID,ColumnName,Description,StringID,DepTable,DepColumn,DepGroup,MetaRuleID,Required,Nullable,Quoted,MinSize,MaxSize,IsKey,ColumnType,AllowAudit,AddOnly,RegExp,CheckQuery)
	VALUES (@MetaTableID,@ColumnName,@Description,@StringID,@DepTable,@DepColumn,@DepGroup,@MetaRuleID,@Required,@Nullable,@Quoted,@MinSize,@MaxSize,@IsKey,@ColumnType,@AllowAudit,@AddOnly,@RegExp,@CheckQuery)
	END
END
GO

CREATE PROCEDURE dbo.CT_NoticeTechs (@NoticeTech VARCHAR(255),@NoticeTechID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE NoticeTechs SET NoticeTechID = @NoticeTechID,
	NoticeTech = @NoticeTech
	WHERE NoticeTechID = @NoticeTechID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO NoticeTechs (NoticeTech,NoticeTechID,SortOrder)
VALUES (@NoticeTech,@NoticeTechID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_NoticeFormats (@NoticeFormat VARCHAR(255),@NoticeFormatID SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE NoticeFormats SET NoticeFormatID = @NoticeFormatID,
	NoticeFormat = @NoticeFormat,
	StringID = @StringID
	WHERE NoticeFormatID = @NoticeFormatID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO NoticeFormats (NoticeFormat,NoticeFormatID,SortOrder,StringID)
VALUES (@NoticeFormat,@NoticeFormatID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_NoticePurposes (@CustomerAccess SMALLINT,@CustomerDescription VARCHAR(255),@NoticePurpose VARCHAR(255),@NoticePurposeID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE NoticePurposes SET NoticePurpose = @NoticePurpose,
	StringID = @StringID
	WHERE NoticePurposeID = @NoticePurposeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO NoticePurposes (CustomerAccess,CustomerDescription,NoticePurpose,NoticePurposeID,SortOrder,StringID)
VALUES (@CustomerAccess,@CustomerDescription,@NoticePurpose,@NoticePurposeID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_NoticeTypes (@DefaultText VARCHAR(8000),@Description VARCHAR(8000),@IEAID INT,@InternalID SMALLINT,@NoticePurposeID INT,@NoticeType VARCHAR(255),@Parm1Desc VARCHAR(255),@Parm1Query VARCHAR(8000),@Parm1RegExp VARCHAR(255),@Parm2Desc VARCHAR(255),@Parm2Query VARCHAR(8000),@Parm2RegExp VARCHAR(255),@Parm3Desc VARCHAR(255),@Parm3Query VARCHAR(8000),@Parm3RegExp VARCHAR(255),@Parm4Desc VARCHAR(255),@Parm4Query VARCHAR(8000),@Parm4RegExp VARCHAR(255),@Parm5Desc VARCHAR(255),@Parm5Query VARCHAR(8000),@Parm5RegExp VARCHAR(255),@Parm6Desc VARCHAR(255),@Parm6Query VARCHAR(8000),@Parm6RegExp VARCHAR(255),@Parm7Desc VARCHAR(255),@Parm7Query VARCHAR(8000),@Parm7RegExp VARCHAR(255),@ReportFile VARCHAR(255),@SQLQuery VARCHAR(8000),@SentQuery VARCHAR(8000)) AS
SET NOCOUNT ON
UPDATE NoticeTypes SET NoticeType = @NoticeType,
	Description = @Description,
	SQLQuery = @SQLQuery,
	ReportFile = @ReportFile,
	Parm1Desc = @Parm1Desc,
	Parm2Desc = @Parm2Desc,
	Parm3Desc = @Parm3Desc,
	Parm4Desc = @Parm4Desc,
	Parm5Desc = @Parm5Desc,
	Parm6Desc = @Parm6Desc,
	Parm7Desc = @Parm7Desc,
	InternalID = @InternalID,
	Parm1Query = @Parm1Query,
	Parm2Query = @Parm2Query,
	Parm3Query = @Parm3Query,
	Parm4Query = @Parm4Query,
	Parm5Query = @Parm5Query,
	Parm6Query = @Parm6Query,
	Parm7Query = @Parm7Query,
	Parm1RegExp = @Parm1RegExp,
	Parm2RegExp = @Parm2RegExp,
	Parm3RegExp = @Parm3RegExp,
	Parm4RegExp = @Parm4RegExp,
	Parm5RegExp = @Parm5RegExp,
	Parm6RegExp = @Parm6RegExp,
	Parm7RegExp = @Parm7RegExp
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO NoticeTypes (DefaultText,Description,IEAID,InternalID,NoticePurposeID,NoticeType,Parm1Desc,Parm1Query,Parm1RegExp,Parm2Desc,Parm2Query,Parm2RegExp,Parm3Desc,Parm3Query,Parm3RegExp,Parm4Desc,Parm4Query,Parm4RegExp,Parm5Desc,Parm5Query,Parm5RegExp,Parm6Desc,Parm6Query,Parm6RegExp,Parm7Desc,Parm7Query,Parm7RegExp,ReportFile,SQLQuery,SentQuery)
VALUES (@DefaultText,@Description,@IEAID,@InternalID,@NoticePurposeID,@NoticeType,@Parm1Desc,@Parm1Query,@Parm1RegExp,@Parm2Desc,@Parm2Query,@Parm2RegExp,@Parm3Desc,@Parm3Query,@Parm3RegExp,@Parm4Desc,@Parm4Query,@Parm4RegExp,@Parm5Desc,@Parm5Query,@Parm5RegExp,@Parm6Desc,@Parm6Query,@Parm6RegExp,@Parm7Desc,@Parm7Query,@Parm7RegExp,@ReportFile,@SQLQuery,@SentQuery)
END
GO

CREATE PROCEDURE dbo.CT_Notices (@InternalID INT, @Active INT, @NoticeTechID INT, @Notice VARCHAR(64), @MailFrom VARCHAR(128), @MailSubject VARCHAR(128), @MailCC VARCHAR(128), @NoticeText VARCHAR(8000)) AS
SET NOCOUNT ON
INSERT INTO Notices (InternalID, NoticeTypeID, Active, NoticeTechID, Notice, MailFrom, MailSubject, MailCC, NoticeText)
SELECT nt.InternalID, nt.NoticeTypeID, @Active, @NoticeTechID, @Notice, @MailFrom, @MailSubject, @MailCC, @NoticeText
FROM NoticeTypes nt
	WHERE nt.InternalID = @InternalID
	AND nt.InternalID NOT IN (SELECT InternalID FROM Notices WHERE InternalID IS NOT NULL)
UPDATE Notices SET NoticeTechID = @NoticeTechID WHERE InternalID = @InternalID
GO

CREATE PROCEDURE dbo.CT_ObjectTypes (@ObjectType VARCHAR(255),@ObjectTypeID INT) AS
SET NOCOUNT ON
UPDATE ObjectTypes SET ObjectType = @ObjectType
	WHERE ObjectTypeID = @ObjectTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ObjectTypes (ObjectType,ObjectTypeID)
VALUES (@ObjectType,@ObjectTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ObjectGroups (@Description VARCHAR(8000),@ObjectGroup VARCHAR(255),@ObjectGroupID INT) AS
SET NOCOUNT ON
UPDATE ObjectGroups SET Description = @Description,
	ObjectGroup = @ObjectGroup
	WHERE ObjectGroupID = @ObjectGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ObjectGroups (Description,ObjectGroup,ObjectGroupID)
VALUES (@Description,@ObjectGroup,@ObjectGroupID)
END
GO

CREATE PROCEDURE dbo.CT_Objects (@TableName VARCHAR(255), @ColumnName VARCHAR(255), @FileName VARCHAR(255), @ObjectTypeID INT, @ObjectGroupID INT, @Active TINYINT, @DirectRef TINYINT) AS
SET NOCOUNT ON
DECLARE @ObjectID INT
IF (@ObjectTypeID IN (1,4))
BEGIN
SELECT @ObjectID = ObjectID FROM Objects WHERE ObjectGroupID = @ObjectGroupID AND ObjectTypeID = @ObjectTypeID AND Data = @FileName
END
IF (@ObjectTypeID IN (1,4) AND @ObjectID IS NULL)
BEGIN
INSERT INTO Objects (Data,ObjectGroupID,ObjectTypeID,Active,DirectRef)
VALUES(@FileName,@ObjectGroupID,@ObjectTypeID,@Active,@DirectRef)
END
IF (@ObjectTypeID = 1 AND @ObjectID IS NOT NULL)
BEGIN
UPDATE Objects SET DirectRef = @DirectRef WHERE ObjectID = @ObjectID AND DirectRef <> @DirectRef
END
IF (@ObjectTypeID = 2)
BEGIN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID,Active)
SELECT mt.MetaTableID,@ObjectGroupID,2,@Active
FROM MetaTables mt
	WHERE mt.TableName = @TableName
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mt.MetaTableID AND ObjectGroupID = @ObjectGroupID AND ObjectTypeID = 2)
END
IF (@ObjectTypeID = 3)
BEGIN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID,Active)
SELECT mc.MetaColumnID,@ObjectGroupID,3,@Active
FROM MetaTables mt, MetaColumns mc
	WHERE mt.TableName = @TableName
	AND mt.MetaTableID = mc.MetaTableID
	AND mc.ColumnName = @ColumnName
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mc.MetaColumnID AND ObjectGroupID = @ObjectGroupID AND ObjectTypeID = 3)
END
GO

CREATE PROCEDURE dbo.CT_PaymentTypes (@CustomerAccess SMALLINT,@CustomerDescription VARCHAR(255),@CustomerPayment SMALLINT,@CustomerStringID INT,@IsPayMethod SMALLINT,@IsPayType SMALLINT,@PaymentType VARCHAR(255),@PaymentTypeID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE PaymentTypes SET IsPayMethod = @IsPayMethod,
	IsPayType = @IsPayType,
	CustomerAccess = @CustomerAccess,
	CustomerPayment = @CustomerPayment
	WHERE PaymentTypeID = @PaymentTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PaymentTypes (CustomerAccess,CustomerDescription,CustomerPayment,CustomerStringID,IsPayMethod,IsPayType,PaymentType,PaymentTypeID,SortOrder,StringID)
VALUES (@CustomerAccess,@CustomerDescription,@CustomerPayment,@CustomerStringID,@IsPayMethod,@IsPayType,@PaymentType,@PaymentTypeID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_Priorities (@Priority VARCHAR(255),@PriorityID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Priorities WHERE PriorityID = @PriorityID
IF (@CTcnt = 0)
BEGIN
INSERT INTO Priorities (Priority,PriorityID,StringID)
VALUES (@Priority,@PriorityID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RadDestTypes (@RadDestType VARCHAR(255),@RadDestTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE RadDestTypes SET RadDestType = @RadDestType,
	SortOrder = @SortOrder
	WHERE RadDestTypeID = @RadDestTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID,SortOrder)
VALUES (@RadDestType,@RadDestTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RadSourceTypes (@RadSourceType VARCHAR(255),@RadSourceTypeID INT) AS
SET NOCOUNT ON
UPDATE RadSourceTypes SET RadSourceType = @RadSourceType
	WHERE RadSourceTypeID = @RadSourceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID)
VALUES (@RadSourceType,@RadSourceTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RadFilterTypes (@RadFilterType VARCHAR(255),@RadFilterTypeID INT) AS
SET NOCOUNT ON
UPDATE RadFilterTypes SET RadFilterType = @RadFilterType
	WHERE RadFilterTypeID = @RadFilterTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadFilterTypes (RadFilterType,RadFilterTypeID)
VALUES (@RadFilterType,@RadFilterTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RadMergeTypes (@AllowAttr SMALLINT,@RadMergeType VARCHAR(255),@RadMergeTypeID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE RadMergeTypes SET AllowAttr = @AllowAttr,
	RadMergeType = @RadMergeType,
	StringID = @StringID
	WHERE RadMergeTypeID = @RadMergeTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadMergeTypes (AllowAttr,RadMergeType,RadMergeTypeID,StringID)
VALUES (@AllowAttr,@RadMergeType,@RadMergeTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RadLogMsgs (@RadLogMsg VARCHAR(255),@RadLogMsgID SMALLINT,@Severity INT) AS
SET NOCOUNT ON
UPDATE RadLogMsgs SET RadLogMsg = @RadLogMsg,
	Severity = @Severity
	WHERE RadLogMsgID = @RadLogMsgID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadLogMsgs (RadLogMsg,RadLogMsgID,Severity)
VALUES (@RadLogMsg,@RadLogMsgID,@Severity)
END
GO

CREATE PROCEDURE dbo.CT_RadRejectAttributes (@Data VARCHAR(255),@IEAID INT,@RadAttributeID INT,@RadLogMsgID SMALLINT,@RadVendorID INT,@ServerID INT) AS
SET NOCOUNT ON
UPDATE RadRejectAttributes SET RadLogMsgID = @RadLogMsgID,
	RadVendorID = @RadVendorID,
	RadAttributeID = @RadAttributeID,
	Data = @Data
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadRejectAttributes (Data,IEAID,RadAttributeID,RadLogMsgID,RadVendorID,ServerID)
VALUES (@Data,@IEAID,@RadAttributeID,@RadLogMsgID,@RadVendorID,@ServerID)
END
GO

CREATE PROCEDURE dbo.CT_RadSearchTypes (@RadSearchType VARCHAR(255),@RadSearchTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE RadSearchTypes SET RadSearchType = @RadSearchType
	WHERE RadSearchTypeID = @RadSearchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadSearchTypes (RadSearchType,RadSearchTypeID)
VALUES (@RadSearchType,@RadSearchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateRuleTypes (@RateRuleType VARCHAR(255),@RateRuleTypeID INT) AS
SET NOCOUNT ON
UPDATE RateRuleTypes SET RateRuleType = @RateRuleType
	WHERE RateRuleTypeID = @RateRuleTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRuleTypes (RateRuleType,RateRuleTypeID)
VALUES (@RateRuleType,@RateRuleTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateIntervals (@NamePlural VARCHAR(255),@NameShort VARCHAR(255),@NameSingular VARCHAR(255),@RateIntervalID INT,@RateRuleTypeID INT) AS
SET NOCOUNT ON
UPDATE RateIntervals SET RateRuleTypeID = @RateRuleTypeID
	WHERE RateIntervalID = @RateIntervalID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateIntervals (NamePlural,NameShort,NameSingular,RateIntervalID,RateRuleTypeID)
VALUES (@NamePlural,@NameShort,@NameSingular,@RateIntervalID,@RateRuleTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateIPPorts (@Description VARCHAR(255),@Port INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM RateIPPorts WHERE Port = @Port
IF (@CTcnt = 0)
BEGIN
INSERT INTO RateIPPorts (Description,Port,SortOrder)
VALUES (@Description,@Port,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RateIPProtocols (@Description VARCHAR(255),@Protocol INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE RateIPProtocols SET Description = @Description,
	SortOrder = @SortOrder
	WHERE Protocol = @Protocol

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateIPProtocols (Description,Protocol,SortOrder)
VALUES (@Description,@Protocol,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RateMatchTypes (@RateMatchType VARCHAR(255),@RateMatchTypeID INT) AS
SET NOCOUNT ON
UPDATE RateMatchTypes SET RateMatchType = @RateMatchType
	WHERE RateMatchTypeID = @RateMatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateMatchTypes (RateMatchType,RateMatchTypeID)
VALUES (@RateMatchType,@RateMatchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateRoundTypes (@AllowData SMALLINT,@AllowTime SMALLINT,@RateRoundType VARCHAR(255),@RateRoundTypeID INT) AS
SET NOCOUNT ON
UPDATE RateRoundTypes SET AllowData = @AllowData,
	AllowTime = @AllowTime,
	RateRoundType = @RateRoundType
	WHERE RateRoundTypeID = @RateRoundTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRoundTypes (AllowData,AllowTime,RateRoundType,RateRoundTypeID)
VALUES (@AllowData,@AllowTime,@RateRoundType,@RateRoundTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateSources (@AllowData SMALLINT,@AllowTime SMALLINT,@RateSource VARCHAR(255),@RateSourceID INT) AS
SET NOCOUNT ON
UPDATE RateSources SET AllowData = @AllowData,
	AllowTime = @AllowTime,
	RateSource = @RateSource
	WHERE RateSourceID = @RateSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateSources (AllowData,AllowTime,RateSource,RateSourceID)
VALUES (@AllowData,@AllowTime,@RateSource,@RateSourceID)
END
GO

CREATE PROCEDURE dbo.CT_RateSourceAttributes (@AllowData SMALLINT,@AllowTime SMALLINT,@Attribute VARCHAR(255),@Description VARCHAR(255),@Dynamic SMALLINT,@RateMatchTypes INT,@RateSourceID INT,@SortOrder SMALLINT,@ValuesQuery VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateSourceAttributes SET Description = @Description,
	AllowData = @AllowData,
	AllowTime = @AllowTime,
	Dynamic = @Dynamic,
	ValuesQuery = @ValuesQuery,
	RateMatchTypes = @RateMatchTypes
	WHERE RateSourceID = @RateSourceID
	AND Attribute = @Attribute

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateSourceAttributes (AllowData,AllowTime,Attribute,Description,Dynamic,RateMatchTypes,RateSourceID,SortOrder,ValuesQuery)
VALUES (@AllowData,@AllowTime,@Attribute,@Description,@Dynamic,@RateMatchTypes,@RateSourceID,@SortOrder,@ValuesQuery)
END
GO

CREATE PROCEDURE dbo.CT_RateTypes (@RateSourceID INT,@RateType VARCHAR(255),@RateTypeID INT,@RuleQuery VARCHAR(255),@ScriptConfigure VARCHAR(255),@ScriptSummary VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateTypes SET RateSourceID = @RateSourceID,
	RateType = @RateType,
	RuleQuery = @RuleQuery,
	ScriptConfigure = @ScriptConfigure,
	ScriptSummary = @ScriptSummary
	WHERE RateTypeID = @RateTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateTypes (RateSourceID,RateType,RateTypeID,RuleQuery,ScriptConfigure,ScriptSummary)
VALUES (@RateSourceID,@RateType,@RateTypeID,@RuleQuery,@ScriptConfigure,@ScriptSummary)
END
GO

CREATE PROCEDURE dbo.CT_RateCostTypes (@CostAttribute VARCHAR(255),@CostUPQuery VARCHAR(255),@RateCostType VARCHAR(255),@RateCostTypeID SMALLINT,@SortOrder SMALLINT,@Unit VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateCostTypes SET CostAttribute = @CostAttribute,
	CostUPQuery = @CostUPQuery,
	RateCostType = @RateCostType,
	SortOrder = @SortOrder,
	Unit = @Unit
	WHERE RateCostTypeID = @RateCostTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateCostTypes (CostAttribute,CostUPQuery,RateCostType,RateCostTypeID,SortOrder,Unit)
VALUES (@CostAttribute,@CostUPQuery,@RateCostType,@RateCostTypeID,@SortOrder,@Unit)
END
GO

CREATE PROCEDURE dbo.CT_RateRules (@ClassQuery VARCHAR(255),@ClassRequired SMALLINT,@ClassTTL INT,@DataAttribute VARCHAR(255),@DefaultCost NUMERIC(18,4),@Description VARCHAR(8000),@Interval INT,@RateCostTypeID SMALLINT,@RateRoundTypeID INT,@RateRule VARCHAR(255),@RateRuleTypeID INT,@RateSourceID INT,@RateTypeID INT,@RuleQuery VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
UPDATE RateRules SET ClassQuery = @ClassQuery,
	ClassRequired = @ClassRequired,
	ClassTTL = @ClassTTL,
	DataAttribute = @DataAttribute,
	DefaultCost = @DefaultCost,
	Description = @Description,
	Interval = @Interval,
	RateCostTypeID = @RateCostTypeID,
	RateRoundTypeID = @RateRoundTypeID,
	RateRuleTypeID = @RateRuleTypeID,
	RateSourceID = @RateSourceID,
	RateTypeID = @RateTypeID,
	RuleQuery = @RuleQuery,
	StringID = @StringID
	WHERE RateRule = @RateRule

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRules (ClassQuery,ClassRequired,ClassTTL,DataAttribute,DefaultCost,Description,Interval,RateCostTypeID,RateRoundTypeID,RateRule,RateRuleTypeID,RateSourceID,RateTypeID,RuleQuery,StringID)
VALUES (@ClassQuery,@ClassRequired,@ClassTTL,@DataAttribute,@DefaultCost,@Description,@Interval,@RateCostTypeID,@RateRoundTypeID,@RateRule,@RateRuleTypeID,@RateSourceID,@RateTypeID,@RuleQuery,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_ScheduleIntervals (@Interval VARCHAR(255),@Seconds INT) AS
SET NOCOUNT ON
UPDATE ScheduleIntervals SET Interval = @Interval
	WHERE Seconds = @Seconds

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ScheduleIntervals (Interval,Seconds)
VALUES (@Interval,@Seconds)
END
GO

CREATE PROCEDURE dbo.CT_ScheduleTasks (@Description VARCHAR(255),@TaskName VARCHAR(255),@TaskType VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ScheduleTasks SET Description = @Description,
	TaskType = @TaskType
	WHERE TaskName = @TaskName

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ScheduleTasks (Description,TaskName,TaskType)
VALUES (@Description,@TaskName,@TaskType)
END
GO

CREATE PROCEDURE dbo.CT_Schedules (@TaskName VARCHAR(255),@Parameter VARCHAR(255),@TargetSecs INT,@MaxSecs INT,@Status SMALLINT,@Interval INT,@StartHH INT, @StartMI INT, @Aligned SMALLINT, @Description VARCHAR(255),@Active SMALLINT,@MaxConcurrent INT) AS
SET NOCOUNT ON
DECLARE @StartDate DATETIME
SELECT @StartDate = DATEADD(mi,@StartMI,DATEADD(hh,@StartHH,DATEADD(hh,-(DATEPART(hh,getdate())),DATEADD(mi,-(DATEPART(mi,getdate())),getdate()))))
IF ((SELECT COUNT(*) FROM Schedules WHERE TaskName = @TaskName AND COALESCE(Parameter,' ') = COALESCE(@Parameter,' ') AND Interval > 0) = 0)
BEGIN
INSERT INTO Schedules (Active,Aligned,Description,Interval,LastModifyDate,LastModifyUser,LastStart,LastStatus,LastUpdate,LockServerID,MaxConcurrent,MaxSecs,Operator,Parameter,Server,StartDate,Status,TargetSecs,TaskName)
VALUES (@Active,@Aligned,@Description,@Interval,getdate(),'admin',NULL,NULL,NULL,NULL,@MaxConcurrent,@MaxSecs,'admin',@Parameter,NULL,@StartDate,@Status,@TargetSecs,@TaskName)
END
GO

CREATE PROCEDURE dbo.CT_SearchConditions (@SearchCondition VARCHAR(255),@SearchConditionID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SearchConditions SET SearchCondition = @SearchCondition,
	StringID = @StringID
	WHERE SearchConditionID = @SearchConditionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SearchConditions (SearchCondition,SearchConditionID,StringID)
VALUES (@SearchCondition,@SearchConditionID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SearchFieldGroups (@SearchFieldGroup VARCHAR(255),@SearchFieldGroupID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SearchFieldGroups SET SearchFieldGroup = @SearchFieldGroup,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE SearchFieldGroupID = @SearchFieldGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SearchFieldGroups (SearchFieldGroup,SearchFieldGroupID,SortOrder,StringID)
VALUES (@SearchFieldGroup,@SearchFieldGroupID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SearchFields (@FilterEWS VARCHAR(8000),@FormEWS VARCHAR(8000),@JoinEWS VARCHAR(8000),@SearchField VARCHAR(255),@SearchFieldGroupID INT,@SearchFieldID INT,@SelectEWS VARCHAR(8000),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SearchFields SET FilterEWS = @FilterEWS,
	FormEWS = @FormEWS,
	JoinEWS = @JoinEWS,
	SearchField = @SearchField,
	SearchFieldGroupID = @SearchFieldGroupID,
	SelectEWS = @SelectEWS,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE SearchFieldID = @SearchFieldID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SearchFields (FilterEWS,FormEWS,JoinEWS,SearchField,SearchFieldGroupID,SearchFieldID,SelectEWS,SortOrder,StringID)
VALUES (@FilterEWS,@FormEWS,@JoinEWS,@SearchField,@SearchFieldGroupID,@SearchFieldID,@SelectEWS,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_ServerTypes (@ServerType VARCHAR(255),@ServerTypeID INT,@Vendor VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ServerTypes SET ServerTypeID = @ServerTypeID,
	Vendor = @Vendor
	WHERE ServerType = @ServerType

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ServerTypes (ServerType,ServerTypeID,Vendor)
VALUES (@ServerType,@ServerTypeID,@Vendor)
END
GO

CREATE PROCEDURE dbo.CT_ThemeMatchTypes (@Hidden SMALLINT,@ThemeMatchType VARCHAR(255),@ThemeMatchTypeID INT) AS
SET NOCOUNT ON
UPDATE ThemeMatchTypes SET Hidden = @Hidden,
	ThemeMatchType = @ThemeMatchType
	WHERE ThemeMatchTypeID = @ThemeMatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ThemeMatchTypes (Hidden,ThemeMatchType,ThemeMatchTypeID)
VALUES (@Hidden,@ThemeMatchType,@ThemeMatchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_TransStates (@StringID INT,@TransState VARCHAR(255),@TransStateID SMALLINT) AS
SET NOCOUNT ON
UPDATE TransStates SET StringID = @StringID,
	TransState = @TransState
	WHERE TransStateID = @TransStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TransStates (StringID,TransState,TransStateID)
VALUES (@StringID,@TransState,@TransStateID)
END
GO

CREATE PROCEDURE dbo.CT_TransTypes (@StringID INT,@TransType VARCHAR(255),@TransTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE TransTypes SET StringID = @StringID,
	TransType = @TransType
	WHERE TransTypeID = @TransTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TransTypes (StringID,TransType,TransTypeID)
VALUES (@StringID,@TransType,@TransTypeID)
END
GO

CREATE PROCEDURE dbo.CT_PeriodTypes (@AllowPayPeriod SMALLINT,@PeriodType VARCHAR(255),@PeriodTypeID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE PeriodTypes SET AllowPayPeriod = @AllowPayPeriod,
	PeriodType = @PeriodType,
	StringID = @StringID
	WHERE PeriodTypeID = @PeriodTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PeriodTypes (AllowPayPeriod,PeriodType,PeriodTypeID,StringID)
VALUES (@AllowPayPeriod,@PeriodType,@PeriodTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RateDataSources (@BillingMode INT,@ClearQuery VARCHAR(8000),@DSN VARCHAR(255),@DataQuery VARCHAR(8000),@Password VARCHAR(255),@RateDataSource VARCHAR(255),@RateDataSourceID INT,@RateSourceID INT,@UpdateInterval SMALLINT,@UpdateQuery VARCHAR(8000),@UseTransactions SMALLINT,@Username VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM RateDataSources WHERE RateDataSourceID = @RateDataSourceID
IF (@CTcnt = 0)
BEGIN
INSERT INTO RateDataSources (BillingMode,ClearQuery,DSN,DataQuery,Password,RateDataSource,RateDataSourceID,RateSourceID,UpdateInterval,UpdateQuery,UseTransactions,Username)
VALUES (@BillingMode,@ClearQuery,@DSN,@DataQuery,@Password,@RateDataSource,@RateDataSourceID,@RateSourceID,@UpdateInterval,@UpdateQuery,@UseTransactions,@Username)
END
GO

CREATE PROCEDURE dbo.CT_InvoiceTypes (@InvoiceType VARCHAR(255),@InvoiceTypeID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE InvoiceTypes SET InvoiceType = @InvoiceType,
	StringID = @StringID
	WHERE InvoiceTypeID = @InvoiceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvoiceTypes (InvoiceType,InvoiceTypeID,StringID)
VALUES (@InvoiceType,@InvoiceTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_InvoiceItemTypes (@InvoiceItemType VARCHAR(255),@InvoiceItemTypeID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE InvoiceItemTypes SET InvoiceItemType = @InvoiceItemType,
	StringID = @StringID
	WHERE InvoiceItemTypeID = @InvoiceItemTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvoiceItemTypes (InvoiceItemType,InvoiceItemTypeID,StringID)
VALUES (@InvoiceItemType,@InvoiceItemTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_IEALocks (@IEALock VARCHAR(255),@IEALockID INT,@RefCount INT) AS
SET NOCOUNT ON
UPDATE IEALocks SET IEALock = @IEALock
	WHERE IEALockID = @IEALockID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IEALocks (IEALock,IEALockID,RefCount)
VALUES (@IEALock,@IEALockID,@RefCount)
END
GO

CREATE PROCEDURE dbo.CT_AccountTemplates (@AccountTemplate VARCHAR(255),@AccountTemplateID INT,@CustEdit VARCHAR(255),@CustEditLabel VARCHAR(255),@CustEditStringID INT,@CustNew VARCHAR(255),@CustSave VARCHAR(255),@SADetail VARCHAR(255),@SAEdit VARCHAR(255),@SANew VARCHAR(255),@SASave VARCHAR(255),@SignupForm VARCHAR(255),@SignupPage VARCHAR(255),@SignupSave VARCHAR(255),@SignupValidate VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE AccountTemplates SET AccountTemplate = @AccountTemplate,
	SANew = @SANew,
	SAEdit = @SAEdit,
	SASave = @SASave,
	SADetail = @SADetail,
	CustNew = @CustNew,
	CustEdit = @CustEdit,
	CustEditLabel = @CustEditLabel,
	CustEditStringID = @CustEditStringID,
	CustSave = @CustSave,
	SignupPage = @SignupPage,
	SignupForm = @SignupForm,
	SignupValidate = @SignupValidate,
	SignupSave = @SignupSave
	WHERE AccountTemplateID = @AccountTemplateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountTemplates (AccountTemplate,AccountTemplateID,CustEdit,CustEditLabel,CustEditStringID,CustNew,CustSave,SADetail,SAEdit,SANew,SASave,SignupForm,SignupPage,SignupSave,SignupValidate,SortOrder)
VALUES (@AccountTemplate,@AccountTemplateID,@CustEdit,@CustEditLabel,@CustEditStringID,@CustNew,@CustSave,@SADetail,@SAEdit,@SANew,@SASave,@SignupForm,@SignupPage,@SignupSave,@SignupValidate,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_IncidentTemplates (@CustIncidentEdit VARCHAR(255),@CustIncidentSave VARCHAR(255),@IncidentEdit VARCHAR(255),@IncidentSave VARCHAR(255),@IncidentTemplate VARCHAR(255),@IncidentTemplateID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE IncidentTemplates SET IncidentTemplate = @IncidentTemplate,
	IncidentEdit = @IncidentEdit,
	IncidentSave = @IncidentSave,
	CustIncidentEdit = @CustIncidentEdit,
	CustIncidentSave = @CustIncidentSave
	WHERE IncidentTemplateID = @IncidentTemplateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IncidentTemplates (CustIncidentEdit,CustIncidentSave,IncidentEdit,IncidentSave,IncidentTemplate,IncidentTemplateID,SortOrder)
VALUES (@CustIncidentEdit,@CustIncidentSave,@IncidentEdit,@IncidentSave,@IncidentTemplate,@IncidentTemplateID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_GaugeWindows (@GaugeWindow VARCHAR(255),@GaugeWindowID SMALLINT,@Secs INT) AS
SET NOCOUNT ON
UPDATE GaugeWindows SET GaugeWindow = @GaugeWindow,
	Secs = @Secs
	WHERE GaugeWindowID = @GaugeWindowID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO GaugeWindows (GaugeWindow,GaugeWindowID,Secs)
VALUES (@GaugeWindow,@GaugeWindowID,@Secs)
END
GO

CREATE PROCEDURE dbo.CT_GaugeConversions (@GaugeConversion VARCHAR(255),@GaugeConversionID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE GaugeConversions SET GaugeConversion = @GaugeConversion,
	SortOrder = @SortOrder
	WHERE GaugeConversionID = @GaugeConversionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO GaugeConversions (GaugeConversion,GaugeConversionID,SortOrder)
VALUES (@GaugeConversion,@GaugeConversionID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_FileApplyTypes (@FileApplyType VARCHAR(255),@FileApplyTypeID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE FileApplyTypes SET FileApplyType = @FileApplyType
	WHERE FileApplyTypeID = @FileApplyTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO FileApplyTypes (FileApplyType,FileApplyTypeID,StringID)
VALUES (@FileApplyType,@FileApplyTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_GaugeSources (@GaugeSource VARCHAR(255),@GaugeSourceID INT) AS
SET NOCOUNT ON
UPDATE GaugeSources SET GaugeSource = @GaugeSource
	WHERE GaugeSourceID = @GaugeSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO GaugeSources (GaugeSource,GaugeSourceID)
VALUES (@GaugeSource,@GaugeSourceID)
END
GO

CREATE PROCEDURE dbo.CT_InvLevelTypes (@InvLevelType VARCHAR(255),@InvLevelTypeID INT) AS
SET NOCOUNT ON
UPDATE InvLevelTypes SET InvLevelType = @InvLevelType
	WHERE InvLevelTypeID = @InvLevelTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvLevelTypes (InvLevelType,InvLevelTypeID)
VALUES (@InvLevelType,@InvLevelTypeID)
END
GO

CREATE PROCEDURE dbo.CT_InvAttributes (@Description VARCHAR(8000),@IEAID INT,@InvAttribute VARCHAR(255),@InvLevelTypeID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM InvAttributes WHERE IEAID = @IEAID
IF (@CTcnt = 0)
BEGIN
INSERT INTO InvAttributes (Description,IEAID,InvAttribute,InvLevelTypeID)
VALUES (@Description,@IEAID,@InvAttribute,@InvLevelTypeID)
END
GO

CREATE PROCEDURE dbo.CT_InfoBars (@AccessLabel VARCHAR(255),@Class VARCHAR(255),@Description VARCHAR(8000),@FeatureID INT,@InfoBar VARCHAR(255),@InfoBarID INT,@Link VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
UPDATE InfoBars SET AccessLabel = @AccessLabel,
	Class = @Class,
	Description = @Description,
	FeatureID = @FeatureID,
	InfoBar = @InfoBar,
	Link = @Link,
	StringID = @StringID
	WHERE InfoBarID = @InfoBarID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InfoBars (AccessLabel,Class,Description,FeatureID,InfoBar,InfoBarID,Link,StringID)
VALUES (@AccessLabel,@Class,@Description,@FeatureID,@InfoBar,@InfoBarID,@Link,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_MarketTagCondTypes (@IsGroup SMALLINT,@MarketTagCondType VARCHAR(255),@MarketTagCondTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MarketTagCondTypes SET IsGroup = @IsGroup,
	MarketTagCondType = @MarketTagCondType,
	SortOrder = @SortOrder
	WHERE MarketTagCondTypeID = @MarketTagCondTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MarketTagCondTypes (IsGroup,MarketTagCondType,MarketTagCondTypeID,SortOrder)
VALUES (@IsGroup,@MarketTagCondType,@MarketTagCondTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MarketTagCancelTypes (@MarketTagCancelType VARCHAR(255),@MarketTagCancelTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MarketTagCancelTypes SET MarketTagCancelType = @MarketTagCancelType,
	SortOrder = @SortOrder
	WHERE MarketTagCancelTypeID = @MarketTagCancelTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MarketTagCancelTypes (MarketTagCancelType,MarketTagCancelTypeID,SortOrder)
VALUES (@MarketTagCancelType,@MarketTagCancelTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MarketTagAutoTypes (@AssignStringID INT,@AssignType VARCHAR(255),@Description VARCHAR(8000),@MarketTagAutoType VARCHAR(255),@MarketTagAutoTypeID INT,@SortOrder SMALLINT,@TagLevel VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE MarketTagAutoTypes SET AssignStringID = @AssignStringID,
	AssignType = @AssignType,
	Description = @Description,
	MarketTagAutoType = @MarketTagAutoType,
	SortOrder = @SortOrder,
	TagLevel = @TagLevel
	WHERE MarketTagAutoTypeID = @MarketTagAutoTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MarketTagAutoTypes (AssignStringID,AssignType,Description,MarketTagAutoType,MarketTagAutoTypeID,SortOrder,TagLevel)
VALUES (@AssignStringID,@AssignType,@Description,@MarketTagAutoType,@MarketTagAutoTypeID,@SortOrder,@TagLevel)
END
GO

CREATE PROCEDURE dbo.CT_LateFeeTypes (@LateFeeType VARCHAR(255),@LateFeeTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE LateFeeTypes SET LateFeeType = @LateFeeType
	WHERE LateFeeTypeID = @LateFeeTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO LateFeeTypes (LateFeeType,LateFeeTypeID)
VALUES (@LateFeeType,@LateFeeTypeID)
END
GO

CREATE PROCEDURE dbo.CT_MarketServiceCountTypes (@Description VARCHAR(8000),@MarketServiceCountType VARCHAR(255),@MarketServiceCountTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MarketServiceCountTypes SET Description = @Description,
	MarketServiceCountType = @MarketServiceCountType,
	SortOrder = @SortOrder
	WHERE MarketServiceCountTypeID = @MarketServiceCountTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MarketServiceCountTypes (Description,MarketServiceCountType,MarketServiceCountTypeID,SortOrder)
VALUES (@Description,@MarketServiceCountType,@MarketServiceCountTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_InvSourceTypes (@Assignable SMALLINT,@InvSourceType VARCHAR(255),@InvSourceTypeID INT) AS
SET NOCOUNT ON
UPDATE InvSourceTypes SET Assignable = @Assignable,
	InvSourceType = @InvSourceType
	WHERE InvSourceTypeID = @InvSourceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvSourceTypes (Assignable,InvSourceType,InvSourceTypeID)
VALUES (@Assignable,@InvSourceType,@InvSourceTypeID)
END
GO

CREATE PROCEDURE dbo.CT_InvStateTypes (@Class VARCHAR(255),@InvStateType VARCHAR(255),@InvStateTypeID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE InvStateTypes SET Class = @Class,
	InvStateType = @InvStateType,
	StringID = @StringID
	WHERE InvStateTypeID = @InvStateTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvStateTypes (Class,InvStateType,InvStateTypeID,StringID)
VALUES (@Class,@InvStateType,@InvStateTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_InvReserveTypes (@InvReserveType VARCHAR(255),@InvReserveTypeID INT) AS
SET NOCOUNT ON
UPDATE InvReserveTypes SET InvReserveType = @InvReserveType
	WHERE InvReserveTypeID = @InvReserveTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvReserveTypes (InvReserveType,InvReserveTypeID)
VALUES (@InvReserveType,@InvReserveTypeID)
END
GO

CREATE PROCEDURE dbo.CT_AlertMapTypes (@AlertMapType VARCHAR(255),@AlertMapTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE AlertMapTypes SET AlertMapType = @AlertMapType
	WHERE AlertMapTypeID = @AlertMapTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AlertMapTypes (AlertMapType,AlertMapTypeID)
VALUES (@AlertMapType,@AlertMapTypeID)
END
GO

CREATE PROCEDURE dbo.CT_AlertMaps (@AlertMapID INT,@AlertMapTypeID SMALLINT,@Message VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE AlertMaps SET Message = @Message
	WHERE AlertMapTypeID = @AlertMapTypeID
	AND AlertMapID = @AlertMapID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AlertMaps (AlertMapID,AlertMapTypeID,Message)
VALUES (@AlertMapID,@AlertMapTypeID,@Message)
END
GO

CREATE PROCEDURE dbo.CT_DashTypes (@AccessLabel VARCHAR(255),@DashType VARCHAR(255),@DashTypeID INT,@Description VARCHAR(8000),@FeatureID INT,@FileDelete VARCHAR(255),@FileDisplay VARCHAR(255),@FileEdit VARCHAR(255),@FileList VARCHAR(255),@FileUpdate VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE DashTypes SET AccessLabel = @AccessLabel,
	DashType = @DashType,
	Description = @Description,
	FeatureID = @FeatureID,
	FileDelete = @FileDelete,
	FileDisplay = @FileDisplay,
	FileEdit = @FileEdit,
	FileList = @FileList,
	FileUpdate = @FileUpdate,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE DashTypeID = @DashTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO DashTypes (AccessLabel,DashType,DashTypeID,Description,FeatureID,FileDelete,FileDisplay,FileEdit,FileList,FileUpdate,SortOrder,StringID)
VALUES (@AccessLabel,@DashType,@DashTypeID,@Description,@FeatureID,@FileDelete,@FileDisplay,@FileEdit,@FileList,@FileUpdate,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AddressDataTypes (@AddressDataType VARCHAR(255),@AddressDataTypeID INT,@Detail SMALLINT,@ExternalRef VARCHAR(255),@IsPhone SMALLINT,@SortOrder SMALLINT,@StringID INT,@Summary SMALLINT) AS
SET NOCOUNT ON
UPDATE AddressDataTypes SET AddressDataTypeID = @AddressDataTypeID,
	AddressDataType = @AddressDataType,
	StringID = @StringID,
	IsPhone = @IsPhone
	WHERE AddressDataTypeID = @AddressDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AddressDataTypes (AddressDataType,AddressDataTypeID,Detail,ExternalRef,IsPhone,SortOrder,StringID,Summary)
VALUES (@AddressDataType,@AddressDataTypeID,@Detail,@ExternalRef,@IsPhone,@SortOrder,@StringID,@Summary)
END
GO

CREATE PROCEDURE dbo.CT_AccessTypes (@AccessType VARCHAR(255),@AccessTypeID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE AccessTypes SET AccessType = @AccessType,
	SortOrder = @SortOrder
	WHERE AccessTypeID = @AccessTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccessTypes (AccessType,AccessTypeID,SortOrder)
VALUES (@AccessType,@AccessTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_AddressDataSources (@AddressDataSource VARCHAR(255),@AddressDataSourceID INT) AS
SET NOCOUNT ON
UPDATE AddressDataSources SET AddressDataSource = @AddressDataSource
	WHERE AddressDataSourceID = @AddressDataSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AddressDataSources (AddressDataSource,AddressDataSourceID)
VALUES (@AddressDataSource,@AddressDataSourceID)
END
GO

CREATE PROCEDURE dbo.CT_AddressCategories (@AddressCategory VARCHAR(255),@AddressCategoryID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE AddressCategories SET AddressCategory = @AddressCategory,
	StringID = @StringID
	WHERE AddressCategoryID = @AddressCategoryID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AddressCategories (AddressCategory,AddressCategoryID,SortOrder,StringID)
VALUES (@AddressCategory,@AddressCategoryID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_BankRoutes (@ABANumber VARCHAR(255),@BankName VARCHAR(255),@BankPhone VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE BankRoutes SET BankName = @BankName,
	BankPhone = @BankPhone
	WHERE ABANumber = @ABANumber

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BankRoutes (ABANumber,BankName,BankPhone)
VALUES (@ABANumber,@BankName,@BankPhone)
END
GO

CREATE PROCEDURE dbo.CT_BillingImportTypes (@BillingImportType VARCHAR(255),@BillingImportTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE BillingImportTypes SET BillingImportType = @BillingImportType
	WHERE BillingImportTypeID = @BillingImportTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BillingImportTypes (BillingImportType,BillingImportTypeID,SortOrder)
VALUES (@BillingImportType,@BillingImportTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_BillingImports (@BillingImport VARCHAR(255),@BillingImportID INT,@BillingImportTypeID INT,@Description VARCHAR(8000),@LookupQuery VARCHAR(255),@RegExp VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE BillingImports SET BillingImportTypeID = @BillingImportTypeID,
	BillingImport = @BillingImport,
	StringID = @StringID,
	RegExp = @RegExp,
	LookupQuery = @LookupQuery,
	Description = @Description
	WHERE BillingImportID = @BillingImportID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BillingImports (BillingImport,BillingImportID,BillingImportTypeID,Description,LookupQuery,RegExp,SortOrder,StringID)
VALUES (@BillingImport,@BillingImportID,@BillingImportTypeID,@Description,@LookupQuery,@RegExp,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AuditActions (@AuditAction VARCHAR(255),@AuditActionID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE AuditActions SET AuditAction = @AuditAction,
	StringID = @StringID
	WHERE AuditActionID = @AuditActionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AuditActions (AuditAction,AuditActionID,StringID)
VALUES (@AuditAction,@AuditActionID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AlertSourceTypes (@AlertSourceType VARCHAR(255),@AlertSourceTypeID INT) AS
SET NOCOUNT ON
UPDATE AlertSourceTypes SET AlertSourceType = @AlertSourceType
	WHERE AlertSourceTypeID = @AlertSourceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AlertSourceTypes (AlertSourceType,AlertSourceTypeID)
VALUES (@AlertSourceType,@AlertSourceTypeID)
END
GO

CREATE PROCEDURE dbo.CT_AlertSources (@Active SMALLINT,@AlertSource VARCHAR(255),@AlertSourceTypeID INT,@ExternalRef VARCHAR(255),@IEAID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE AlertSources SET AlertSourceTypeID = @AlertSourceTypeID
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AlertSources (Active,AlertSource,AlertSourceTypeID,ExternalRef,IEAID,SortOrder,StringID)
VALUES (@Active,@AlertSource,@AlertSourceTypeID,@ExternalRef,@IEAID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AlertStates (@AlertState VARCHAR(255),@AlertStateID SMALLINT,@Class VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE AlertStates SET AlertState = @AlertState,
	Class = @Class,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE AlertStateID = @AlertStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AlertStates (AlertState,AlertStateID,Class,SortOrder,StringID)
VALUES (@AlertState,@AlertStateID,@Class,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AlertTypes (@AlertType VARCHAR(255),@AllowManual SMALLINT,@ExternalRef VARCHAR(255),@IEAID INT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM AlertTypes WHERE IEAID = @IEAID
IF (@CTcnt = 0)
BEGIN
INSERT INTO AlertTypes (AlertType,AllowManual,ExternalRef,IEAID,StringID)
VALUES (@AlertType,@AllowManual,@ExternalRef,@IEAID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RadFailReasons (@RadFailReason VARCHAR(255),@RadFailReasonID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE RadFailReasons SET RadFailReason = @RadFailReason
	WHERE RadFailReasonID = @RadFailReasonID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadFailReasons (RadFailReason,RadFailReasonID,SortOrder)
VALUES (@RadFailReason,@RadFailReasonID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RegFCC477VoiceTransports (@RegFCC477VoiceTransport VARCHAR(255),@RegFCC477VoiceTransportID INT) AS
SET NOCOUNT ON
UPDATE RegFCC477VoiceTransports SET RegFCC477VoiceTransport = @RegFCC477VoiceTransport
	WHERE RegFCC477VoiceTransportID = @RegFCC477VoiceTransportID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RegFCC477VoiceTransports (RegFCC477VoiceTransport,RegFCC477VoiceTransportID)
VALUES (@RegFCC477VoiceTransport,@RegFCC477VoiceTransportID)
END
GO

CREATE PROCEDURE dbo.CT_RateVDNISImportTypes (@IEAID INT,@ImportQuery VARCHAR(8000),@Prefix VARCHAR(255),@RateVDNISImportType VARCHAR(255),@RegExp VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE RateVDNISImportTypes SET RateVDNISImportType = @RateVDNISImportType,
	RegExp = @RegExp,
	Prefix = @Prefix,
	ImportQuery = @ImportQuery
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateVDNISImportTypes (IEAID,ImportQuery,Prefix,RateVDNISImportType,RegExp,SortOrder)
VALUES (@IEAID,@ImportQuery,@Prefix,@RateVDNISImportType,@RegExp,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_ReportTypes (@ReportType VARCHAR(255),@ReportTypeID INT) AS
SET NOCOUNT ON
UPDATE ReportTypes SET ReportType = @ReportType
	WHERE ReportTypeID = @ReportTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportTypes (ReportType,ReportTypeID)
VALUES (@ReportType,@ReportTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ReportGroupTypes (@ReportGroupType VARCHAR(255),@ReportGroupTypeID INT) AS
SET NOCOUNT ON
UPDATE ReportGroupTypes SET ReportGroupType = @ReportGroupType
	WHERE ReportGroupTypeID = @ReportGroupTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportGroupTypes (ReportGroupType,ReportGroupTypeID)
VALUES (@ReportGroupType,@ReportGroupTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ReportDataTypes (@ReportDataType VARCHAR(255),@ReportDataTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE ReportDataTypes SET ReportDataType = @ReportDataType
	WHERE ReportDataTypeID = @ReportDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportDataTypes (ReportDataType,ReportDataTypeID)
VALUES (@ReportDataType,@ReportDataTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ReportGroups (@AccessLabel VARCHAR(255),@Active SMALLINT,@Class VARCHAR(255),@FeatureID INT,@ReportGroup VARCHAR(255),@ReportGroupID INT,@ReportGroupTypeID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE ReportGroups SET ReportGroupTypeID = @ReportGroupTypeID,
	FeatureID = @FeatureID
	WHERE ReportGroupID = @ReportGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportGroups (AccessLabel,Active,Class,FeatureID,ReportGroup,ReportGroupID,ReportGroupTypeID,SortOrder,StringID)
VALUES (@AccessLabel,@Active,@Class,@FeatureID,@ReportGroup,@ReportGroupID,@ReportGroupTypeID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_Reports (@AccessLabel VARCHAR(255),@Active SMALLINT,@Col2Avg VARCHAR(255),@Col2Count VARCHAR(255),@Col2Group VARCHAR(255),@Col2Max VARCHAR(255),@Col2Min VARCHAR(255),@Col2Order VARCHAR(255),@Col2Sum VARCHAR(255),@ColAvg VARCHAR(255),@ColCount VARCHAR(255),@ColGroup VARCHAR(255),@ColMax VARCHAR(255),@ColMin VARCHAR(255),@ColOrder VARCHAR(255),@ColSum VARCHAR(255),@FileName VARCHAR(255),@IEAID INT,@OrderBy VARCHAR(255),@Report VARCHAR(255),@ReportGroupID INT,@ReportQuery VARCHAR(8000),@ReportTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Reports SET ReportTypeID = @ReportTypeID,
	ReportGroupID = @ReportGroupID,
	ReportQuery = @ReportQuery,
	FileName = @FileName,
	ColGroup = @ColGroup,
	ColSum = @ColSum,
	ColMin = @ColMin,
	ColMax = @ColMax,
	ColCount = @ColCount,
	ColOrder = @ColOrder,
	ColAvg = @ColAvg,
	Col2Group = @Col2Group,
	Col2Sum = @Col2Sum,
	Col2Min = @Col2Min,
	Col2Max = @Col2Max,
	Col2Count = @Col2Count,
	Col2Order = @Col2Order,
	Col2Avg = @Col2Avg,
	OrderBy = @OrderBy
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Reports (AccessLabel,Active,Col2Avg,Col2Count,Col2Group,Col2Max,Col2Min,Col2Order,Col2Sum,ColAvg,ColCount,ColGroup,ColMax,ColMin,ColOrder,ColSum,FileName,IEAID,OrderBy,Report,ReportGroupID,ReportQuery,ReportTypeID,SortOrder)
VALUES (@AccessLabel,@Active,@Col2Avg,@Col2Count,@Col2Group,@Col2Max,@Col2Min,@Col2Order,@Col2Sum,@ColAvg,@ColCount,@ColGroup,@ColMax,@ColMin,@ColOrder,@ColSum,@FileName,@IEAID,@OrderBy,@Report,@ReportGroupID,@ReportQuery,@ReportTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_ReportFields (@CRFieldName VARCHAR(255),@DefaultValue VARCHAR(255),@Description VARCHAR(255),@EWSFile VARCHAR(255),@FieldName VARCHAR(255),@ReportDataTypeID SMALLINT,@ReportField VARCHAR(255),@ReportFieldID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE ReportFields SET CRFieldName = @CRFieldName,
	DefaultValue = @DefaultValue,
	Description = @Description,
	EWSFile = @EWSFile,
	FieldName = @FieldName,
	ReportDataTypeID = @ReportDataTypeID,
	ReportField = @ReportField,
	StringID = @StringID
	WHERE ReportFieldID = @ReportFieldID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportFields (CRFieldName,DefaultValue,Description,EWSFile,FieldName,ReportDataTypeID,ReportField,ReportFieldID,StringID)
VALUES (@CRFieldName,@DefaultValue,@Description,@EWSFile,@FieldName,@ReportDataTypeID,@ReportField,@ReportFieldID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_ReportParameters (@IEAID INT, @ReportFieldID INT, @Required SMALLINT, @SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @ReportID INT
SELECT @ReportID = ReportID FROM Reports WHERE IEAID = @IEAID
IF (@ReportID IS NOT NULL)
BEGIN
UPDATE ReportParameters SET Required = @Required, SortOrder = @SortOrder WHERE ReportID = @ReportID AND ReportFieldID = @ReportFieldID
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO ReportParameters (ReportID,ReportFieldID,Required,SortOrder) VALUES(@ReportID,@ReportFieldID,@Required,@SortOrder)
	END
END
GO

CREATE PROCEDURE dbo.CT_RegFCC477Techs (@Code477 INT,@CodeBDC INT,@RegFCC477Tech VARCHAR(255),@RegFCC477TechID INT,@RegFCC477VoiceTransportID INT) AS
SET NOCOUNT ON
UPDATE RegFCC477Techs SET Code477 = @Code477,
	CodeBDC = @CodeBDC,
	RegFCC477Tech = @RegFCC477Tech,
	RegFCC477VoiceTransportID = @RegFCC477VoiceTransportID
	WHERE RegFCC477TechID = @RegFCC477TechID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RegFCC477Techs (Code477,CodeBDC,RegFCC477Tech,RegFCC477TechID,RegFCC477VoiceTransportID)
VALUES (@Code477,@CodeBDC,@RegFCC477Tech,@RegFCC477TechID,@RegFCC477VoiceTransportID)
END
GO

CREATE PROCEDURE dbo.CT_RegFCC477VoiceTechs (@RegFCC477VoiceTech VARCHAR(255),@RegFCC477VoiceTechID INT) AS
SET NOCOUNT ON
UPDATE RegFCC477VoiceTechs SET RegFCC477VoiceTech = @RegFCC477VoiceTech
	WHERE RegFCC477VoiceTechID = @RegFCC477VoiceTechID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RegFCC477VoiceTechs (RegFCC477VoiceTech,RegFCC477VoiceTechID)
VALUES (@RegFCC477VoiceTech,@RegFCC477VoiceTechID)
END
GO

CREATE PROCEDURE dbo.CT_Numbers (@n SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Numbers WHERE n = @n
IF (@CTcnt = 0)
BEGIN
INSERT INTO Numbers (n)
VALUES (@n)
END
GO

CREATE PROCEDURE dbo.CT_SMSREGroupTypes (@SMSREGroupType VARCHAR(255),@SMSREGroupTypeID INT) AS
SET NOCOUNT ON
UPDATE SMSREGroupTypes SET SMSREGroupType = @SMSREGroupType
	WHERE SMSREGroupTypeID = @SMSREGroupTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SMSREGroupTypes (SMSREGroupType,SMSREGroupTypeID)
VALUES (@SMSREGroupType,@SMSREGroupTypeID)
END
GO

CREATE PROCEDURE dbo.CT_SMSRESources (@SMSRESource VARCHAR(255),@SMSRESourceID INT) AS
SET NOCOUNT ON
UPDATE SMSRESources SET SMSRESource = @SMSRESource
	WHERE SMSRESourceID = @SMSRESourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SMSRESources (SMSRESource,SMSRESourceID)
VALUES (@SMSRESource,@SMSRESourceID)
END
GO

CREATE PROCEDURE dbo.CT_SMSWriteStates (@SMSWriteState VARCHAR(255),@SMSWriteStateID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SMSWriteStates SET SMSWriteState = @SMSWriteState,
	StringID = @StringID
	WHERE SMSWriteStateID = @SMSWriteStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SMSWriteStates (SMSWriteState,SMSWriteStateID,StringID)
VALUES (@SMSWriteState,@SMSWriteStateID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SMSREActions (@SMSREAction VARCHAR(255),@SMSREActionID INT) AS
SET NOCOUNT ON
UPDATE SMSREActions SET SMSREAction = @SMSREAction
	WHERE SMSREActionID = @SMSREActionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SMSREActions (SMSREAction,SMSREActionID)
VALUES (@SMSREAction,@SMSREActionID)
END
GO

CREATE PROCEDURE dbo.CT_SMSREGroups (@Active SMALLINT,@IEAID INT,@SMSPollerID INT,@SMSREGroup VARCHAR(255),@SMSREGroupTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE SMSREGroups SET SMSREGroup = @SMSREGroup,
	SMSREGroupTypeID = @SMSREGroupTypeID
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SMSREGroups (Active,IEAID,SMSPollerID,SMSREGroup,SMSREGroupTypeID,SortOrder)
VALUES (@Active,@IEAID,@SMSPollerID,@SMSREGroup,@SMSREGroupTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_SMSREItems (@IEAID INT, @GroupIEAID INT, @SMSREItem VARCHAR(128), @SMSRESourceID INT, @SMSREActionID INT, @Expression VARCHAR(512), @LogQuery VARCHAR(512), @Comments TEXT, @Active TINYINT, @SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @SMSREGroupID INT
SELECT @SMSREGroupID = SMSREGroupID FROM SMSREGroups WHERE IEAID = @GroupIEAID
IF (@SMSREGroupID IS NOT NULL)
BEGIN
UPDATE SMSREItems SET SMSREItem = @SMSREItem, SMSREGroupID = @SMSREGroupID, SMSRESourceID = @SMSRESourceID, SMSREActionID = @SMSREActionID, Expression = @Expression, LogQuery = @LogQuery
	WHERE IEAID = @IEAID
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO SMSREItems (SMSREItem,SMSREGroupID,SMSRESourceID,SMSREActionID,Expression,LogQuery,Comments,Active,SortOrder,IEAID) 
	VALUES(@SMSREItem,@SMSREGroupID,@SMSRESourceID,@SMSREActionID,@Expression,@LogQuery,@Comments,@Active,@SortOrder,@IEAID)
	END
END
GO

CREATE PROCEDURE dbo.CT_SectionAreas (@Prefix VARCHAR(255),@SectionArea VARCHAR(255),@SectionAreaID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SectionAreas SET Prefix = @Prefix,
	SectionArea = @SectionArea,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE SectionAreaID = @SectionAreaID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SectionAreas (Prefix,SectionArea,SectionAreaID,SortOrder,StringID)
VALUES (@Prefix,@SectionArea,@SectionAreaID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SectionLocations (@AllowAccountType SMALLINT,@AllowGroup SMALLINT,@AllowOperator SMALLINT,@AllowOperatorGroup SMALLINT,@Description VARCHAR(255),@Prefix VARCHAR(255),@SectionLocation VARCHAR(255),@SectionLocationID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SectionLocations SET AllowAccountType = @AllowAccountType,
	AllowGroup = @AllowGroup,
	AllowOperator = @AllowOperator,
	AllowOperatorGroup = @AllowOperatorGroup,
	Description = @Description,
	Prefix = @Prefix,
	SectionLocation = @SectionLocation,
	SortOrder = @SortOrder,
	StringID = @StringID
	WHERE SectionLocationID = @SectionLocationID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SectionLocations (AllowAccountType,AllowGroup,AllowOperator,AllowOperatorGroup,Description,Prefix,SectionLocation,SectionLocationID,SortOrder,StringID)
VALUES (@AllowAccountType,@AllowGroup,@AllowOperator,@AllowOperatorGroup,@Description,@Prefix,@SectionLocation,@SectionLocationID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SectionObjects (@Description VARCHAR(255),@SectionAreaID INT,@SectionLocationID INT,@SectionObject VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE SectionObjects SET Description = @Description,
	StringID = @StringID,
	SortOrder = @SortOrder
	WHERE SectionLocationID = @SectionLocationID
	AND SectionAreaID = @SectionAreaID
	AND SectionObject = @SectionObject

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SectionObjects (Description,SectionAreaID,SectionLocationID,SectionObject,SortOrder,StringID)
VALUES (@Description,@SectionAreaID,@SectionLocationID,@SectionObject,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_SectionFeatures (@SectionLocationID INT, @SectionAreaID INT, @SectionObject VARCHAR(128), @FeatureID INT, @Enabled SMALLINT) AS
SET NOCOUNT ON
DECLARE @SectionObjectID INT
SELECT @SectionObjectID = SectionObjectID FROM SectionObjects WHERE SectionLocationID = @SectionLocationID AND SectionAreaID = @SectionAreaID AND SectionObject = @SectionObject
IF (@SectionObjectID IS NOT NULL)
BEGIN
UPDATE SectionFeatures SET Enabled = @Enabled WHERE FeatureID = @FeatureID AND SectionObjectID = @SectionObjectID
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO SectionFeatures (FeatureID,SectionObjectID,Enabled) VALUES(@FeatureID,@SectionObjectID,@Enabled)
	END
END
GO

CREATE PROCEDURE dbo.CT_SectionGlobals (@SectionLocationID INT, @SectionAreaID INT, @SectionObject VARCHAR(128), @Enabled TINYINT) AS
SET NOCOUNT ON
DECLARE @SectionObjectID INT
SELECT @SectionObjectID = SectionObjectID FROM SectionObjects WHERE SectionLocationID = @SectionLocationID AND SectionAreaID = @SectionAreaID AND SectionObject = @SectionObject
IF ((SELECT COUNT(*) FROM SectionGlobals WHERE SectionObjectID = @SectionObjectID) = 0)
BEGIN
INSERT INTO SectionGlobals (SectionObjectID,Enabled) VALUES(@SectionObjectID,@Enabled)
END
GO

CREATE PROCEDURE dbo.CT_SectionNameGroups (@Description VARCHAR(255),@SectionNameGroup VARCHAR(255),@SectionNameGroupID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE SectionNameGroups SET Description = @Description,
	SectionNameGroup = @SectionNameGroup,
	SortOrder = @SortOrder
	WHERE SectionNameGroupID = @SectionNameGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SectionNameGroups (Description,SectionNameGroup,SectionNameGroupID,SortOrder)
VALUES (@Description,@SectionNameGroup,@SectionNameGroupID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_SectionNames (@SectionLocationID INT, @SectionAreaID INT, @SectionObject VARCHAR(128), @SectionNameGroupID INT, @Enabled SMALLINT) AS
SET NOCOUNT ON
DECLARE @SectionObjectID INT
SELECT @SectionObjectID = SectionObjectID FROM SectionObjects WHERE SectionLocationID = @SectionLocationID AND SectionAreaID = @SectionAreaID AND SectionObject = @SectionObject
IF (@SectionObjectID IS NOT NULL)
BEGIN
UPDATE SectionNames SET Enabled = @Enabled WHERE SectionNameGroupID = @SectionNameGroupID AND SectionObjectID = @SectionObjectID
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO SectionNames (SectionNameGroupID,SectionObjectID,Enabled) VALUES(@SectionNameGroupID,@SectionObjectID,@Enabled)
	END
END
GO

CREATE PROCEDURE dbo.CT_SearchTypes (@SearchType VARCHAR(255),@SearchTypeID INT) AS
SET NOCOUNT ON
UPDATE SearchTypes SET SearchType = @SearchType
	WHERE SearchTypeID = @SearchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SearchTypes (SearchType,SearchTypeID)
VALUES (@SearchType,@SearchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_SearchQueries (@FeatureID INT,@SQLQuery VARCHAR(8000),@SearchQuery VARCHAR(255),@SearchQueryID INT,@SearchTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE SearchQueries SET SearchQuery = @SearchQuery,
	SearchTypeID = @SearchTypeID,
	SQLQuery = @SQLQuery,
	FeatureID = @FeatureID
	WHERE SearchQueryID = @SearchQueryID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SearchQueries (FeatureID,SQLQuery,SearchQuery,SearchQueryID,SearchTypeID,SortOrder)
VALUES (@FeatureID,@SQLQuery,@SearchQuery,@SearchQueryID,@SearchTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RoleTypes (@RoleType VARCHAR(255),@RoleTypeID INT) AS
SET NOCOUNT ON
UPDATE RoleTypes SET RoleType = @RoleType
	WHERE RoleTypeID = @RoleTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RoleTypes (RoleType,RoleTypeID)
VALUES (@RoleType,@RoleTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RoleAssignTypes (@RoleAssignType VARCHAR(255),@RoleAssignTypeID INT,@RoleTypeMask INT) AS
SET NOCOUNT ON
UPDATE RoleAssignTypes SET RoleAssignType = @RoleAssignType,
	RoleTypeMask = @RoleTypeMask
	WHERE RoleAssignTypeID = @RoleAssignTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RoleAssignTypes (RoleAssignType,RoleAssignTypeID,RoleTypeMask)
VALUES (@RoleAssignType,@RoleAssignTypeID,@RoleTypeMask)
END
GO

CREATE PROCEDURE dbo.CT_SyslogSourceItemTypes (@SyslogSourceItemType VARCHAR(255),@SyslogSourceItemTypeID INT) AS
SET NOCOUNT ON
UPDATE SyslogSourceItemTypes SET SyslogSourceItemType = @SyslogSourceItemType
	WHERE SyslogSourceItemTypeID = @SyslogSourceItemTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SyslogSourceItemTypes (SyslogSourceItemType,SyslogSourceItemTypeID)
VALUES (@SyslogSourceItemType,@SyslogSourceItemTypeID)
END
GO

CREATE PROCEDURE dbo.CT_SyslogFacilities (@StringID INT,@SyslogFacility VARCHAR(255),@SyslogFacilityID SMALLINT) AS
SET NOCOUNT ON
UPDATE SyslogFacilities SET StringID = @StringID,
	SyslogFacility = @SyslogFacility
	WHERE SyslogFacilityID = @SyslogFacilityID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SyslogFacilities (StringID,SyslogFacility,SyslogFacilityID)
VALUES (@StringID,@SyslogFacility,@SyslogFacilityID)
END
GO

CREATE PROCEDURE dbo.CT_SyslogSeverities (@StringID INT,@SyslogSeverity VARCHAR(255),@SyslogSeverityID SMALLINT) AS
SET NOCOUNT ON
UPDATE SyslogSeverities SET StringID = @StringID,
	SyslogSeverity = @SyslogSeverity
	WHERE SyslogSeverityID = @SyslogSeverityID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO SyslogSeverities (StringID,SyslogSeverity,SyslogSeverityID)
VALUES (@StringID,@SyslogSeverity,@SyslogSeverityID)
END
GO

CREATE PROCEDURE dbo.CT_TaxSourceTypes (@TaxSourceType VARCHAR(255),@TaxSourceTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE TaxSourceTypes SET TaxSourceType = @TaxSourceType
	WHERE TaxSourceTypeID = @TaxSourceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TaxSourceTypes (TaxSourceType,TaxSourceTypeID)
VALUES (@TaxSourceType,@TaxSourceTypeID)
END
GO

CREATE PROCEDURE dbo.CT_TrustedFiles (@Active SMALLINT,@Comments VARCHAR(8000),@Description VARCHAR(8000),@FileName VARCHAR(255),@IEAID INT,@OperatorGroupID INT,@TrustedFile VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE TrustedFiles SET TrustedFile = @TrustedFile,
	Description = @Description,
	FileName = @FileName
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TrustedFiles (Active,Comments,Description,FileName,IEAID,OperatorGroupID,TrustedFile)
VALUES (@Active,@Comments,@Description,@FileName,@IEAID,@OperatorGroupID,@TrustedFile)
END
GO

CREATE PROCEDURE dbo.CT_WebForwarderTypes (@WebForwarderType VARCHAR(255),@WebForwarderTypeID INT) AS
SET NOCOUNT ON
UPDATE WebForwarderTypes SET WebForwarderType = @WebForwarderType
	WHERE WebForwarderTypeID = @WebForwarderTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO WebForwarderTypes (WebForwarderType,WebForwarderTypeID)
VALUES (@WebForwarderType,@WebForwarderTypeID)
END
GO

CREATE PROCEDURE dbo.CT_WebClientCertTypes (@WebClientCertType VARCHAR(255),@WebClientCertTypeID INT) AS
SET NOCOUNT ON
UPDATE WebClientCertTypes SET WebClientCertType = @WebClientCertType
	WHERE WebClientCertTypeID = @WebClientCertTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO WebClientCertTypes (WebClientCertType,WebClientCertTypeID)
VALUES (@WebClientCertType,@WebClientCertTypeID)
END
GO

CREATE PROCEDURE dbo.CT_APIActionTypes (@APIActionType VARCHAR(255),@APIActionTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE APIActionTypes SET APIActionType = @APIActionType,
	SortOrder = @SortOrder
	WHERE APIActionTypeID = @APIActionTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIActionTypes (APIActionType,APIActionTypeID,SortOrder)
VALUES (@APIActionType,@APIActionTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_APIGroupChecks (@APIGroupCheck VARCHAR(255),@APIGroupCheckID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE APIGroupChecks SET APIGroupCheck = @APIGroupCheck,
	SortOrder = @SortOrder
	WHERE APIGroupCheckID = @APIGroupCheckID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIGroupChecks (APIGroupCheck,APIGroupCheckID,SortOrder)
VALUES (@APIGroupCheck,@APIGroupCheckID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_APIStepTypes (@APIStepType VARCHAR(255),@APIStepTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE APIStepTypes SET APIStepType = @APIStepType,
	SortOrder = @SortOrder
	WHERE APIStepTypeID = @APIStepTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIStepTypes (APIStepType,APIStepTypeID,SortOrder)
VALUES (@APIStepType,@APIStepTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_APIFieldTypes (@APIFieldType VARCHAR(255),@APIFieldTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE APIFieldTypes SET APIFieldType = @APIFieldType,
	SortOrder = @SortOrder
	WHERE APIFieldTypeID = @APIFieldTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIFieldTypes (APIFieldType,APIFieldTypeID,SortOrder)
VALUES (@APIFieldType,@APIFieldTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_APIActions (@APIAction VARCHAR(255),@APIActionID INT,@APIActionTypeID INT,@APIGroupCheckID INT,@Active SMALLINT,@Comments VARCHAR(8000),@Description VARCHAR(8000),@FeatureID INT) AS
SET NOCOUNT ON
UPDATE APIActions SET APIAction = @APIAction,
	APIActionTypeID = @APIActionTypeID,
	APIGroupCheckID = @APIGroupCheckID,
	Active = @Active,
	Comments = @Comments,
	Description = @Description,
	FeatureID = @FeatureID
	WHERE APIActionID = @APIActionID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIActions (APIAction,APIActionID,APIActionTypeID,APIGroupCheckID,Active,Comments,Description,FeatureID)
VALUES (@APIAction,@APIActionID,@APIActionTypeID,@APIGroupCheckID,@Active,@Comments,@Description,@FeatureID)
END
GO

CREATE PROCEDURE dbo.CT_APISteps (@APIActionID INT,@APIStep VARCHAR(255),@APIStepTypeID INT,@Active SMALLINT,@Condition VARCHAR(255),@DisplayParent VARCHAR(255),@DisplayQuery VARCHAR(8000),@EWS VARCHAR(8000),@FeatureID INT,@IEAID INT,@Step INT,@TableName VARCHAR(255),@ValueFields VARCHAR(8000),@ValueQuery VARCHAR(8000)) AS
SET NOCOUNT ON
DECLARE @MetaTableID INT
SELECT @MetaTableID = MetaTableID FROM MetaTables WHERE TableName = @TableName
UPDATE APISteps SET APIActionID = @APIActionID,
	APIStep = @APIStep,
	APIStepTypeID = @APIStepTypeID,
	Active = @Active,
	Condition = @Condition,
	DisplayParent = @DisplayParent,
	DisplayQuery = @DisplayQuery,
	EWS = @EWS,
	FeatureID = @FeatureID,
	Step = @Step,
	MetaTableID = @MetaTableID,
	ValueFields = @ValueFields,
	ValueQuery = @ValueQuery
	WHERE IEAID = @IEAID
IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APISteps (APIActionID,APIStep,APIStepTypeID,Active,Condition,DisplayParent,DisplayQuery,EWS,FeatureID,IEAID,Step,MetaTableID,ValueFields,ValueQuery)
VALUES (@APIActionID,@APIStep,@APIStepTypeID,@Active,@Condition,@DisplayParent,@DisplayQuery,@EWS,@FeatureID,@IEAID,@Step,@MetaTableID,@ValueFields,@ValueQuery)
END
GO

CREATE PROCEDURE dbo.CT_APIFields (@APIActionID INT,@APIFieldTypeID INT,@Description VARCHAR(8000),@Example VARCHAR(255),@FieldName VARCHAR(255),@Required VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE APIFields SET Description = @Description,
	Example = @Example,
	Required = @Required
	WHERE APIActionID = @APIActionID
	AND FieldName = @FieldName
	AND APIFieldTypeID = @APIFieldTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIFields (APIActionID,APIFieldTypeID,Description,Example,FieldName,Required)
VALUES (@APIActionID,@APIFieldTypeID,@Description,@Example,@FieldName,@Required)
END
GO

CREATE PROCEDURE dbo.CT_APIStepColumns (@IEAID INT,@Active SMALLINT,@Data VARCHAR(255),@DefaultData VARCHAR(255),@TableName VARCHAR(255),@ColumnName VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @MetaColumnID INT, @APIStepID INT
SELECT @MetaColumnID = mc.MetaColumnID
FROM MetaTables mt JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID)
	WHERE mt.TableName = @TableName
	AND mc.ColumnName = @ColumnName
SELECT @APIStepID = APIStepID FROM APISteps WHERE IEAID = @IEAID
UPDATE APIStepColumns SET Active = @Active,
	Data = @Data,
	DefaultData = @DefaultData
	WHERE APIStepID = @APIStepID
	AND MetaColumnID = @MetaColumnID
IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO APIStepColumns (APIStepID,Active,Data,DefaultData,MetaColumnID)
VALUES (@APIStepID,@Active,@Data,@DefaultData,@MetaColumnID)
END
GO
GO

CREATE PROCEDURE dbo.CT_MonProtocols (@MonProtocol VARCHAR(255),@MonProtocolID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MonProtocols SET MonProtocol = @MonProtocol,
	SortOrder = @SortOrder
	WHERE MonProtocolID = @MonProtocolID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MonProtocols (MonProtocol,MonProtocolID,SortOrder)
VALUES (@MonProtocol,@MonProtocolID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MonRadIPSources (@MonRadIPSource VARCHAR(255),@MonRadIPSourceID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MonRadIPSources SET MonRadIPSource = @MonRadIPSource,
	SortOrder = @SortOrder
	WHERE MonRadIPSourceID = @MonRadIPSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MonRadIPSources (MonRadIPSource,MonRadIPSourceID,SortOrder)
VALUES (@MonRadIPSource,@MonRadIPSourceID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MonSources (@MonSource VARCHAR(255),@MonSourceID SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE MonSources SET MonSource = @MonSource,
	SortOrder = @SortOrder
	WHERE MonSourceID = @MonSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MonSources (MonSource,MonSourceID,SortOrder)
VALUES (@MonSource,@MonSourceID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_IPAddressTypes (@IPAddressType VARCHAR(255),@IPAddressTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE IPAddressTypes SET IPAddressType = @IPAddressType
	WHERE IPAddressTypeID = @IPAddressTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IPAddressTypes (IPAddressType,IPAddressTypeID)
VALUES (@IPAddressType,@IPAddressTypeID)
END
GO

CREATE PROCEDURE dbo.CT_IPRangeTypes (@IPRangeType VARCHAR(255),@IPRangeTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE IPRangeTypes SET IPRangeType = @IPRangeType
	WHERE IPRangeTypeID = @IPRangeTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IPRangeTypes (IPRangeType,IPRangeTypeID)
VALUES (@IPRangeType,@IPRangeTypeID)
END
GO

