CREATE PROCEDURE dbo.CT_MarketCategories (@MarketCategory VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO MarketCategories (MarketCategory,SortOrder,StringID)
VALUES (@MarketCategory,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_SMSPollers (@SMSPoller VARCHAR(255),@SMSPollerID INT) AS
SET NOCOUNT ON
INSERT INTO SMSPollers (SMSPoller,SMSPollerID)
VALUES (@SMSPoller,@SMSPollerID)
GO

CREATE PROCEDURE dbo.CT_ServiceCategories (@AllowRoot SMALLINT,@ServiceCategory VARCHAR(255),@SortOrder INT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO ServiceCategories (AllowRoot,ServiceCategory,SortOrder,StringID)
VALUES (@AllowRoot,@ServiceCategory,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_SchedTimes (@SchedTime VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO SchedTimes (SchedTime,SortOrder)
VALUES (@SchedTime,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_SchedTimeItems (@SchedTimeItem VARCHAR(128), @SchedTime VARCHAR(128), @AccessTime VARCHAR(128), @Include TINYINT, @Comments TEXT) AS
SET NOCOUNT ON
DECLARE @SchedTimeID INT
SELECT @SchedTimeID = SchedTimeID FROM SchedTimes WHERE SchedTime = @SchedTime
IF (@SchedTimeID IS NOT NULL)
BEGIN
INSERT INTO SchedTimeItems (SchedTimeItem,SchedTimeID,AccessTime,Include,Comments) VALUES(@SchedTimeItem,@SchedTimeID,@AccessTime,@Include,@Comments)
END
GO

CREATE PROCEDURE dbo.CT_SchedBlockTypes (@SchedBlockType VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
INSERT INTO SchedBlockTypes (SchedBlockType,StringID)
VALUES (@SchedBlockType,@StringID)
GO

CREATE PROCEDURE dbo.CT_SchedBlocks (@SchedBlock VARCHAR(128), @StringID INT, @SchedBlockType VARCHAR(128), @SchedTime VARCHAR(128), @StartHour TINYINT, @StartMinute TINYINT, @TimeUnits INT, @Quantity INT, @Active TINYINT, @Comments TEXT) AS
SET NOCOUNT ON
DECLARE @SchedBlockTypeID INT, @SchedTimeID INT
SELECT @SchedBlockTypeID = SchedBlockTypeID FROM SchedBlockTypes WHERE SchedBlockType = @SchedBlockType
SELECT @SchedTimeID = SchedTimeID FROM SchedTimes WHERE SchedTime = @SchedTime
IF (@SchedBlockTypeID IS NOT NULL AND @SchedTimeID IS NOT NULL)
BEGIN
INSERT INTO SchedBlocks (SchedBlock,StringID,SchedBlockTypeID,SchedTimeID,StartHour,StartMinute,TimeUnits,Quantity,Active,Comments)
VALUES(@SchedBlock,@StringID,@SchedBlockTypeID,@SchedTimeID,@StartHour,@StartMinute,@TimeUnits,@Quantity,@Active,@Comments)
END
GO

CREATE PROCEDURE dbo.CT_ClientCertInacts (@ClientCertInact VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO ClientCertInacts (ClientCertInact,SortOrder)
VALUES (@ClientCertInact,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_InvStateGroups (@InvStateGroup VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO InvStateGroups (InvStateGroup)
VALUES (@InvStateGroup)
GO

CREATE PROCEDURE dbo.CT_MimeTypes (@Description VARCHAR(255),@Extension VARCHAR(255),@IsImage SMALLINT,@MimeType VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO MimeTypes (Description,Extension,IsImage,MimeType,SortOrder)
VALUES (@Description,@Extension,@IsImage,@MimeType,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_InvCategories (@Description VARCHAR(8000),@InvCategory VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO InvCategories (Description,InvCategory,SortOrder,StringID)
VALUES (@Description,@InvCategory,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_FileCategories (@ActiveExpireDays INT,@AllowAddresses SMALLINT,@AllowIncidents SMALLINT,@AllowInvProducts SMALLINT,@AllowInvoices SMALLINT,@AllowMBR SMALLINT,@AllowPayments SMALLINT,@AllowSA SMALLINT,@AllowStatements SMALLINT,@DisplayDetail SMALLINT,@DisplaySummary SMALLINT,@FileCategory VARCHAR(255),@InactiveExpireDaysMBR INT,@InactiveExpireDaysSA INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO FileCategories (ActiveExpireDays,AllowAddresses,AllowIncidents,AllowInvProducts,AllowInvoices,AllowMBR,AllowPayments,AllowSA,AllowStatements,DisplayDetail,DisplaySummary,FileCategory,InactiveExpireDaysMBR,InactiveExpireDaysSA,SortOrder,StringID)
VALUES (@ActiveExpireDays,@AllowAddresses,@AllowIncidents,@AllowInvProducts,@AllowInvoices,@AllowMBR,@AllowPayments,@AllowSA,@AllowStatements,@DisplayDetail,@DisplaySummary,@FileCategory,@InactiveExpireDaysMBR,@InactiveExpireDaysSA,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_IMTypes (@IMType VARCHAR(255),@SortOrder SMALLINT,@StringID INT,@URI VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO IMTypes (IMType,SortOrder,StringID,URI)
VALUES (@IMType,@SortOrder,@StringID,@URI)
GO

CREATE PROCEDURE dbo.CT_Domains (@Description VARCHAR(255),@Domain VARCHAR(255),@DomainID INT,@MailDomain VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT Domains ON


INSERT INTO Domains (Description,Domain,DomainID,MailDomain,SortOrder)
VALUES (@Description,@Domain,@DomainID,@MailDomain,@SortOrder)
SET IDENTITY_INSERT Domains OFF
GO

CREATE PROCEDURE dbo.CT_Continents (@Continent VARCHAR(255),@ContinentID INT,@Hidden SMALLINT,@Planet VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Continents SET ContinentID = @ContinentID,
	Continent = @Continent,
	Planet = @Planet
	WHERE ContinentID = @ContinentID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Continents (Continent,ContinentID,Hidden,Planet,SortOrder)
VALUES (@Continent,@ContinentID,@Hidden,@Planet,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_Countries (@Abbr2 CHAR(32),@Abbr3 CHAR(32),@Comments VARCHAR(255),@ContinentID INT,@Country VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@Hidden SMALLINT,@InternetDomain VARCHAR(255),@Restricted SMALLINT,@SortOrder SMALLINT,@TelIDD VARCHAR(255),@TelLocPrefixLen SMALLINT,@TelNDD VARCHAR(255),@TelPrefix VARCHAR(255),@ZipStatus SMALLINT) AS
SET NOCOUNT ON
UPDATE Countries SET CountryID = @CountryID,
	ZipStatus = @ZipStatus,
	Country = @Country,
	InternetDomain = @InternetDomain,
	ContinentID = @ContinentID,
	TelPrefix = @TelPrefix,
	TelIDD = @TelIDD,
	TelNDD = @TelNDD,
	TelLocPrefixLen = @TelLocPrefixLen,
	Abbr2 = @Abbr2,
	Abbr3 = @Abbr3
	WHERE CountryID = @CountryID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Countries (Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus)
VALUES (@Abbr2,@Abbr3,@Comments,@ContinentID,@Country,@CountryID,@Currency,@Hidden,@InternetDomain,@Restricted,@SortOrder,@TelIDD,@TelLocPrefixLen,@TelNDD,@TelPrefix,@ZipStatus)
END
GO

CREATE PROCEDURE dbo.CT_Currencies (@Active SMALLINT,@Code VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@CurrencyID INT,@SortOrder SMALLINT,@Symbol VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Currencies SET Currency = @Currency,
	Symbol = @Symbol,
	Code = @Code
	WHERE CurrencyID = @CurrencyID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Currencies (Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol)
VALUES (@Active,@Code,@CountryID,@Currency,@CurrencyID,@SortOrder,@Symbol)
END
GO

CREATE PROCEDURE dbo.CT_Organizations (@InvoiceDetailed SMALLINT,@InvoiceFractional SMALLINT,@MaxAccounts INT,@Organization VARCHAR(255),@OrganizationID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Organizations WHERE OrganizationID = @OrganizationID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Organizations ON


INSERT INTO Organizations (InvoiceDetailed,InvoiceFractional,MaxAccounts,Organization,OrganizationID)
VALUES (@InvoiceDetailed,@InvoiceFractional,@MaxAccounts,@Organization,@OrganizationID)
SET IDENTITY_INSERT Organizations OFF
END
GO

CREATE PROCEDURE dbo.CT_Groups (@Active SMALLINT,@AutoEmailInvoices SMALLINT,@AutoEmailStatements SMALLINT,@BillAddress1 VARCHAR(255),@BillAddress2 VARCHAR(255),@BillCity VARCHAR(255),@BillFax VARCHAR(255),@BillName VARCHAR(255),@BillPhone VARCHAR(255),@BillState VARCHAR(255),@BillZip VARCHAR(255),@Description VARCHAR(255),@DomainID INT,@EmailAccounts VARCHAR(255),@EmailSubject VARCHAR(255),@EndDate DATETIME,@GlobalAccountTypes SMALLINT,@GlobalBillingCycles SMALLINT,@GlobalChargeTypes SMALLINT,@GlobalDomains SMALLINT,@GlobalIncidentTypes SMALLINT,@GlobalPayPeriods SMALLINT,@GlobalRegions SMALLINT,@GlobalSalesPersons SMALLINT,@GlobalSendMethods SMALLINT,@GroupID INT,@GroupName VARCHAR(255),@InvoiceHTMLReport VARCHAR(255),@InvoiceReport VARCHAR(255),@InvoiceTextReport VARCHAR(255),@OrganizationID INT,@PaymentTypes INT,@ReceiptReport VARCHAR(255),@SortOrder SMALLINT,@StartDate DATETIME,@StatementHTMLReport VARCHAR(255),@StatementReport VARCHAR(255),@StatementTextReport VARCHAR(255),@ThemeID INT,@ThemeScore INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Groups WHERE GroupID = @GroupID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Groups ON


INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillFax,BillName,BillPhone,BillState,BillZip,Description,DomainID,EmailAccounts,EmailSubject,EndDate,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDomains,GlobalIncidentTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,OrganizationID,PaymentTypes,ReceiptReport,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (@Active,@AutoEmailInvoices,@AutoEmailStatements,@BillAddress1,@BillAddress2,@BillCity,@BillFax,@BillName,@BillPhone,@BillState,@BillZip,@Description,@DomainID,@EmailAccounts,@EmailSubject,@EndDate,@GlobalAccountTypes,@GlobalBillingCycles,@GlobalChargeTypes,@GlobalDomains,@GlobalIncidentTypes,@GlobalPayPeriods,@GlobalRegions,@GlobalSalesPersons,@GlobalSendMethods,@GroupID,@GroupName,@InvoiceHTMLReport,@InvoiceReport,@InvoiceTextReport,@OrganizationID,@PaymentTypes,@ReceiptReport,@SortOrder,@StartDate,@StatementHTMLReport,@StatementReport,@StatementTextReport,@ThemeID,@ThemeScore)
SET IDENTITY_INSERT Groups OFF
END
GO

CREATE PROCEDURE dbo.CT_OperatorGroups (@Description VARCHAR(255),@InfoMessage VARCHAR(255),@InternalUse SMALLINT,@OperatorGroup VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO OperatorGroups (Description,InfoMessage,InternalUse,OperatorGroup)
VALUES (@Description,@InfoMessage,@InternalUse,@OperatorGroup)
GO

