CREATE PROCEDURE dbo.CT_IncidentStateGroups (@IncidentStateGroup VARCHAR(255),@IncidentStateGroupID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT IncidentStateGroups ON


INSERT INTO IncidentStateGroups (IncidentStateGroup,IncidentStateGroupID)
VALUES (@IncidentStateGroup,@IncidentStateGroupID)
SET IDENTITY_INSERT IncidentStateGroups OFF
GO

CREATE PROCEDURE dbo.CT_RateTimeGroups (@RateTimeGroup VARCHAR(255),@RateTimeGroupID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT RateTimeGroups ON


INSERT INTO RateTimeGroups (RateTimeGroup,RateTimeGroupID)
VALUES (@RateTimeGroup,@RateTimeGroupID)
SET IDENTITY_INSERT RateTimeGroups OFF
GO

CREATE PROCEDURE dbo.CT_RateTimes (@DayWeekMask INT,@Description VARCHAR(255),@EndHour SMALLINT,@EndMinute SMALLINT,@MonthDay SMALLINT,@MonthMask INT,@Priority SMALLINT,@RateTimeGroupID INT,@StartHour SMALLINT,@StartMinute SMALLINT,@WeekNumMask INT) AS
SET NOCOUNT ON
INSERT INTO RateTimes (DayWeekMask,Description,EndHour,EndMinute,MonthDay,MonthMask,Priority,RateTimeGroupID,StartHour,StartMinute,WeekNumMask)
VALUES (@DayWeekMask,@Description,@EndHour,@EndMinute,@MonthDay,@MonthMask,@Priority,@RateTimeGroupID,@StartHour,@StartMinute,@WeekNumMask)
GO

CREATE PROCEDURE dbo.CT_Roles (@Role VARCHAR(255),@RoleAssignTypeID INT,@RoleTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO Roles ([Role],RoleAssignTypeID,RoleTypeID,SortOrder)
VALUES (@Role,@RoleAssignTypeID,@RoleTypeID,@SortOrder)
GO

CREATE PROCEDURE dbo.CT2_PrintTypes (@CRData VARCHAR(255),@Data VARCHAR(255),@PrintType VARCHAR(255),@PrintTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE PrintTypes SET CRData = @CRData,
	Data = @Data,
	PrintType = @PrintType
	WHERE PrintTypeID = @PrintTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (@CRData,@Data,@PrintType,@PrintTypeID)
END
GO

CREATE PROCEDURE dbo.CT_SendMethods (@CustomerAccess SMALLINT,@EmailAutoTrans SMALLINT,@EmailTypeID SMALLINT,@PrintAutoTrans SMALLINT,@PrintTypeID SMALLINT,@SendMethod VARCHAR(255),@SendMethodID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT SendMethods ON


INSERT INTO SendMethods (CustomerAccess,EmailAutoTrans,EmailTypeID,PrintAutoTrans,PrintTypeID,SendMethod,SendMethodID,SortOrder,StringID)
VALUES (@CustomerAccess,@EmailAutoTrans,@EmailTypeID,@PrintAutoTrans,@PrintTypeID,@SendMethod,@SendMethodID,@SortOrder,@StringID)
SET IDENTITY_INSERT SendMethods OFF
GO

CREATE PROCEDURE dbo.CT_TaxExemptions (@Active SMALLINT,@AllowItem SMALLINT,@AllowMBR SMALLINT,@StringID INT,@TaxExemption VARCHAR(255),@TaxExemptionID INT) AS
SET NOCOUNT ON
INSERT INTO TaxExemptions (Active,AllowItem,AllowMBR,StringID,TaxExemption,TaxExemptionID)
VALUES (@Active,@AllowItem,@AllowMBR,@StringID,@TaxExemption,@TaxExemptionID)
GO

CREATE PROCEDURE dbo.CT_TaxPiggyBacks (@TaxPiggyBack VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO TaxPiggyBacks (TaxPiggyBack)
VALUES (@TaxPiggyBack)
GO

CREATE PROCEDURE dbo.CT_RateStatusCalls AS
SET NOCOUNT ON
INSERT INTO RateStatusCalls(LastCallInterimID,Leader,LastUpdate,LastMessage,Advisor,LastAdviceDate)
VALUES(0,NULL,getdate(),NULL,NULL,getdate())
GO

CREATE PROCEDURE dbo.CT_AllowedHosts (@Description VARCHAR(255),@IPAddress VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO AllowedHosts (Description,IPAddress)
VALUES (@Description,@IPAddress)
GO

CREATE PROCEDURE dbo.CT_CancelReasons (@CancelReason VARCHAR(255),@CustomerAccess SMALLINT,@Returning SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO CancelReasons (CancelReason,CustomerAccess,Returning,SortOrder,StringID)
VALUES (@CancelReason,@CustomerAccess,@Returning,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_BillingCycles (@AutoBill SMALLINT,@BillDay INT,@BillingCycle VARCHAR(255),@CycleType SMALLINT,@EBillDays INT,@Extension SMALLINT,@IBillDays INT,@RenewDays INT,@RenewPeriods INT,@SortOrder SMALLINT,@StringID INT,@TBillDays INT) AS
SET NOCOUNT ON
INSERT INTO BillingCycles (AutoBill,BillDay,BillingCycle,CycleType,EBillDays,Extension,IBillDays,RenewDays,RenewPeriods,SortOrder,StringID,TBillDays)
VALUES (@AutoBill,@BillDay,@BillingCycle,@CycleType,@EBillDays,@Extension,@IBillDays,@RenewDays,@RenewPeriods,@SortOrder,@StringID,@TBillDays)
GO

CREATE PROCEDURE dbo.CT_ChargeTypes (@Amount NUMERIC(18,4),@ChargeType VARCHAR(255),@SortOrder SMALLINT,@StringID INT,@TaxExemptions INT) AS
SET NOCOUNT ON
INSERT INTO ChargeTypes (Amount,ChargeType,SortOrder,StringID,TaxExemptions)
VALUES (@Amount,@ChargeType,@SortOrder,@StringID,@TaxExemptions)
GO

CREATE PROCEDURE dbo.CT_Discounts (@Amount NUMERIC(18,4),@AmountType SMALLINT,@Discount VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO Discounts (Amount,AmountType,Discount,SortOrder,StringID)
VALUES (@Amount,@AmountType,@Discount,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_IncidentTypes (@CustomerAccess SMALLINT,@Description VARCHAR(255),@Email VARCHAR(255),@EscalateDays SMALLINT,@IncidentStateGroupID INT,@IncidentType VARCHAR(255),@OverDays SMALLINT,@ShowCustDueDate SMALLINT,@ShowCustomerAccess SMALLINT,@ShowDueDate SMALLINT,@ShowDuration SMALLINT,@ShowEmail SMALLINT,@ShowPriority SMALLINT,@ShowSummary SMALLINT,@SortOrder SMALLINT,@WarnDays SMALLINT) AS
SET NOCOUNT ON
INSERT INTO IncidentTypes (CustomerAccess,Description,Email,EscalateDays,IncidentStateGroupID,IncidentType,OverDays,ShowCustDueDate,ShowCustomerAccess,ShowDueDate,ShowDuration,ShowEmail,ShowPriority,ShowSummary,SortOrder,WarnDays)
VALUES (@CustomerAccess,@Description,@Email,@EscalateDays,@IncidentStateGroupID,@IncidentType,@OverDays,@ShowCustDueDate,@ShowCustomerAccess,@ShowDueDate,@ShowDuration,@ShowEmail,@ShowPriority,@ShowSummary,@SortOrder,@WarnDays)
GO

CREATE PROCEDURE dbo.CT_IncidentStates (@CustomerAccess SMALLINT,@Description VARCHAR(255),@IncidentState VARCHAR(255),@IncidentStateGroupID INT,@Priority SMALLINT,@SortOrder SMALLINT,@StatArchive SMALLINT,@StatBlock SMALLINT,@StatEscalate SMALLINT,@StatOpen SMALLINT,@StatWait SMALLINT,@Style VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO IncidentStates (CustomerAccess,Description,IncidentState,IncidentStateGroupID,Priority,SortOrder,StatArchive,StatBlock,StatEscalate,StatOpen,StatWait,Style)
VALUES (@CustomerAccess,@Description,@IncidentState,@IncidentStateGroupID,@Priority,@SortOrder,@StatArchive,@StatBlock,@StatEscalate,@StatOpen,@StatWait,@Style)
GO

CREATE PROCEDURE dbo.CT_Operators AS
INSERT INTO Operators (PrintTypeID,OperatorGroupID,Operator,Password,Email,CountryID)
SELECT 2, og.OperatorGroupID, 'admin','pass1',NULL,840
FROM OperatorGroups og
	WHERE OperatorGroup = 'Admin'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'admin')
UNION ALL
SELECT 2, og.OperatorGroupID, 'signup','signup',NULL,NULL
FROM OperatorGroups og
	WHERE OperatorGroup = 'CustomerSignup'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'signup')
GO

CREATE PROCEDURE dbo.CT_OperatorGroupAccess (@ObjectGroupID INT, @OperatorGroup VARCHAR(32), @AccessType INT) AS
SET NOCOUNT ON
DECLARE @OperatorGroupID INT
SELECT @OperatorGroupID = OperatorGroupID FROM OperatorGroups WHERE OperatorGroup = @OperatorGroup
IF (@OperatorGroupID IS NOT NULL)
BEGIN
UPDATE OperatorGroupAccess SET AccessType = @AccessType
	WHERE ObjectGroupID = @ObjectGroupID
	AND OperatorGroupID = @OperatorGroupID
	AND GroupID = 1
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO OperatorGroupAccess (ObjectGroupID,OperatorGroupID,GroupID,AccessType)
	VALUES (@ObjectGroupID,@OperatorGroupID,1,@AccessType)
	END
END
GO

CREATE PROCEDURE dbo.CT_PayPeriods (@ConfirmTrans SMALLINT,@PayPeriod VARCHAR(255),@Period SMALLINT,@PeriodTypeID INT,@SetupCharge SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO PayPeriods (ConfirmTrans,PayPeriod,Period,PeriodTypeID,SetupCharge,SortOrder,StringID)
VALUES (@ConfirmTrans,@PayPeriod,@Period,@PeriodTypeID,@SetupCharge,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_AccountTypes (@AccountType VARCHAR(255),@AllowRADIUS SMALLINT,@Cost NUMERIC(18,4),@DataLeft BIGINT,@DataLeftRenewal SMALLINT,@Description VARCHAR(255),@EndDate DATETIME,@Extension SMALLINT,@InactCanceledDays SMALLINT,@LoginLimit SMALLINT,@LogonAsParent SMALLINT,@ProrateClose SMALLINT,@ProrateCloseTemp SMALLINT,@ProrateOpen SMALLINT,@ProrateOpenTemp SMALLINT,@RLimitDataLeft BIGINT,@RLimitRateDataLeft BIGINT,@RLimitRateTimeLeft INT,@RLimitTimeLeft INT,@RateDataLeft BIGINT,@RateTimeLeft INT,@RemoteAccess SMALLINT,@SortOrder INT,@StartDate DATETIME,@TaxExemptions INT,@TimeLeft INT,@TimeLeftRenewal SMALLINT,@UsageToParent SMALLINT,@UseServerPassword SMALLINT) AS
SET NOCOUNT ON
INSERT INTO AccountTypes (AccountType,AllowRADIUS,Cost,DataLeft,DataLeftRenewal,Description,EndDate,Extension,InactCanceledDays,LoginLimit,LogonAsParent,ProrateClose,ProrateCloseTemp,ProrateOpen,ProrateOpenTemp,RLimitDataLeft,RLimitRateDataLeft,RLimitRateTimeLeft,RLimitTimeLeft,RateDataLeft,RateTimeLeft,RemoteAccess,SortOrder,StartDate,TaxExemptions,TimeLeft,TimeLeftRenewal,UsageToParent,UseServerPassword)
VALUES (@AccountType,@AllowRADIUS,@Cost,@DataLeft,@DataLeftRenewal,@Description,@EndDate,@Extension,@InactCanceledDays,@LoginLimit,@LogonAsParent,@ProrateClose,@ProrateCloseTemp,@ProrateOpen,@ProrateOpenTemp,@RLimitDataLeft,@RLimitRateDataLeft,@RLimitRateTimeLeft,@RLimitTimeLeft,@RateDataLeft,@RateTimeLeft,@RemoteAccess,@SortOrder,@StartDate,@TaxExemptions,@TimeLeft,@TimeLeftRenewal,@UsageToParent,@UseServerPassword)
GO

CREATE PROCEDURE dbo.CT_RadFilterGroups (@Active SMALLINT,@Description VARCHAR(255),@DestData VARCHAR(255),@DestRadFilterGroupID INT,@RadDestTypeID INT,@RadFilterGroup VARCHAR(255),@RadFilterGroupID INT,@RadSourceTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT RadFilterGroups ON


INSERT INTO RadFilterGroups (Active,Description,DestData,DestRadFilterGroupID,RadDestTypeID,RadFilterGroup,RadFilterGroupID,RadSourceTypeID,SortOrder)
VALUES (@Active,@Description,@DestData,@DestRadFilterGroupID,@RadDestTypeID,@RadFilterGroup,@RadFilterGroupID,@RadSourceTypeID,@SortOrder)
SET IDENTITY_INSERT RadFilterGroups OFF
GO

CREATE PROCEDURE dbo.CT_RadFilters (@Data VARCHAR(255),@Location VARCHAR(255),@RadAttributeID INT,@RadFilterGroupID INT,@RadFilterTypeID INT,@RadMergeTypeID SMALLINT,@RadSearchTypeID SMALLINT,@RadVendorID INT) AS
SET NOCOUNT ON
INSERT INTO RadFilters (Data,Location,RadAttributeID,RadFilterGroupID,RadFilterTypeID,RadMergeTypeID,RadSearchTypeID,RadVendorID)
VALUES (@Data,@Location,@RadAttributeID,@RadFilterGroupID,@RadFilterTypeID,@RadMergeTypeID,@RadSearchTypeID,@RadVendorID)
GO

CREATE PROCEDURE dbo.CT_ReferredBys (@ReferredBy VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO ReferredBys (ReferredBy,SortOrder,StringID)
VALUES (@ReferredBy,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_Regions (@Region VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO Regions (Region,SortOrder)
VALUES (@Region,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_SalesPersons (@Active SMALLINT,@SalesPerson VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO SalesPersons (Active,SalesPerson,SortOrder)
VALUES (@Active,@SalesPerson,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_ServerGroups (@ServerGroup VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO ServerGroups (ServerGroup)
VALUES (@ServerGroup)
GO

CREATE PROCEDURE dbo.CT_Servers AS
SET NOCOUNT ON
INSERT INTO Servers (ServerGroupID,Server,ServerTypeID,IPAddress,Location,Secret) 
SELECT ServerGroupID,'localhost',-1,'127.0.0.1','local','localhost'
FROM ServerGroups
	WHERE ServerGroup = 'Other'
GO

CREATE PROCEDURE dbo.CT_AddressTypes (@AddressType VARCHAR(255),@AllowAdmin SMALLINT,@AllowMBR SMALLINT,@AllowSA SMALLINT,@BillingPriority INT,@ContactPriority INT,@EmailNoticePurposeMask INT,@RequiredFields VARCHAR(255),@SMSNoticePurposeMask INT,@ServicePriority INT,@ShippingPriority INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO AddressTypes (AddressType,AllowAdmin,AllowMBR,AllowSA,BillingPriority,ContactPriority,EmailNoticePurposeMask,RequiredFields,SMSNoticePurposeMask,ServicePriority,ShippingPriority,SortOrder,StringID)
VALUES (@AddressType,@AllowAdmin,@AllowMBR,@AllowSA,@BillingPriority,@ContactPriority,@EmailNoticePurposeMask,@RequiredFields,@SMSNoticePurposeMask,@ServicePriority,@ShippingPriority,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT2_Groups (@Active SMALLINT,@AutoEmailInvoices SMALLINT,@AutoEmailStatements SMALLINT,@BillAddress1 VARCHAR(255),@BillAddress2 VARCHAR(255),@BillCity VARCHAR(255),@BillCountryID INT,@BillFax VARCHAR(255),@BillName VARCHAR(255),@BillPhone VARCHAR(255),@BillState VARCHAR(255),@BillTaxID VARCHAR(255),@BillZip VARCHAR(255),@Description VARCHAR(255),@DomainID INT,@EmailAccounts VARCHAR(255),@EmailSubject VARCHAR(255),@EndDate DATETIME,@ExternalRef VARCHAR(255),@GlobalAccountTypes SMALLINT,@GlobalBillingCycles SMALLINT,@GlobalChargeTypes SMALLINT,@GlobalDomains SMALLINT,@GlobalIncidentTypes SMALLINT,@GlobalPayPeriods SMALLINT,@GlobalRegions SMALLINT,@GlobalSalesPersons SMALLINT,@GlobalSendMethods SMALLINT,@GroupID INT,@GroupName VARCHAR(255),@InvoiceHTMLReport VARCHAR(255),@InvoiceReport VARCHAR(255),@InvoiceTextReport VARCHAR(255),@OrganizationID INT,@PaymentTypes INT,@PrintInvoices SMALLINT,@PrintStatements SMALLINT,@ReceiptReport VARCHAR(255),@ReportLogoURL VARCHAR(255),@SortOrder SMALLINT,@StartDate DATETIME,@StatementHTMLReport VARCHAR(255),@StatementReport VARCHAR(255),@StatementTextReport VARCHAR(255),@ThemeID INT,@ThemeScore INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Groups WHERE GroupID = @GroupID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Groups ON


INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillTaxID,BillZip,Description,DomainID,EmailAccounts,EmailSubject,EndDate,ExternalRef,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDomains,GlobalIncidentTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,OrganizationID,PaymentTypes,PrintInvoices,PrintStatements,ReceiptReport,ReportLogoURL,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (@Active,@AutoEmailInvoices,@AutoEmailStatements,@BillAddress1,@BillAddress2,@BillCity,@BillCountryID,@BillFax,@BillName,@BillPhone,@BillState,@BillTaxID,@BillZip,@Description,@DomainID,@EmailAccounts,@EmailSubject,@EndDate,@ExternalRef,@GlobalAccountTypes,@GlobalBillingCycles,@GlobalChargeTypes,@GlobalDomains,@GlobalIncidentTypes,@GlobalPayPeriods,@GlobalRegions,@GlobalSalesPersons,@GlobalSendMethods,@GroupID,@GroupName,@InvoiceHTMLReport,@InvoiceReport,@InvoiceTextReport,@OrganizationID,@PaymentTypes,@PrintInvoices,@PrintStatements,@ReceiptReport,@ReportLogoURL,@SortOrder,@StartDate,@StatementHTMLReport,@StatementReport,@StatementTextReport,@ThemeID,@ThemeScore)
SET IDENTITY_INSERT Groups OFF
END
GO

CREATE PROCEDURE dbo.CT_ServiceCatAccountTypes (@ServiceCategory VARCHAR(128), @AccountType VARCHAR(64), @CustomerAccess TINYINT, @CustomerMax INT, @ServiceLevel INT) AS
SET NOCOUNT ON
DECLARE @ServiceCategoryID INT, @AccountTypeID INT
SELECT @ServiceCategoryID = ServiceCategoryID FROM ServiceCategories WHERE ServiceCategory = @ServiceCategory
SELECT @AccountTypeID = AccountTypeID FROM AccountTypes WHERE AccountType = @AccountType
IF (@ServiceCategoryID IS NOT NULL AND @AccountTypeID IS NOT NULL)
BEGIN
INSERT INTO ServiceCatAccountTypes (ServiceCategoryID,AccountTypeID,CustomerAccess,CustomerMax,ServiceLevel,AllowCustChangePass,AllowCustUpgrade) VALUES(@ServiceCategoryID,@AccountTypeID,@CustomerAccess,@CustomerMax,@ServiceLevel,1,1)
END
GO

