IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL IceWarpSync(''partial'')}' AND TaskName = 'querytrans') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('{CALL IceWarpSync(''partial'')}',NULL,0,'Merak Mail Sync (partial)',300,1,'20040101','admin',NULL,NULL,'querytrans',NULL,1,NULL,NULL,NULL,NULL,'20040101','admin',1)
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL IceWarpSync(''daily'')}' AND TaskName = 'querytrans') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('{CALL IceWarpSync(''daily'')}',NULL,0,'Merak Mail Sync (daily)',86400,1,'20040101','admin',NULL,NULL,'querytrans',NULL,1,NULL,NULL,NULL,NULL,'20040101','admin',1)
GO

IF (object_id('GetSubForwards') IS NOT NULL)
	DROP FUNCTION GetSubForwards
GO

IF (object_id('IceWarpSync') IS NOT NULL)
	DROP PROCEDURE IceWarpSync
GO

CREATE FUNCTION GetSubForwards (@accountid int) RETURNS varchar(1024)
AS
BEGIN
DECLARE @all_forwards as varchar(1024)

Select @all_forwards = ''
Select @all_forwards = @all_forwards + Forward + ';' FROM Forwards WHERE AccountID = @accountid

RETURN @all_forwards
END
GO

CREATE PROCEDURE dbo.IceWarpSync (@synctype VARCHAR(32)) AS 
-- Sync types
-- 'full' resynchronizes all data
-- 'daily' daily maintenance to delete unreferenced data
-- 'partial' does incremental synchronization
-- Sync Domains

SET NOCOUNT ON
DECLARE @starting DATETIME, @lastsync DATETIME, @sadtid INT
SELECT @lastsync = COALESCE(MAX(LastSyncDate),DATEADD(yy,-20,getdate())) FROM ExternalSystems WHERE ExternalSystemTypeID = -3 AND LastSyncDate IS NOT NULL
SELECT @starting = getdate()
SELECT @sadtid = 3

IF ((SELECT COUNT(*) FROM Configs WHERE ConfigID=673 AND NumValue=1) = 0)
BEGIN
RAISERROR('External System Exports has been disabled. (See Emerald Admin / Web Interface / Upgrade & Testing)',11,1)
RETURN
END

IF (@synctype = 'full')
BEGIN
SELECT @lastsync = DATEADD(yy,-20,getdate())
END

IF (@synctype IN ('full','daily'))
BEGIN
DELETE FROM icewarp..Domains WHERE D_ID NOT IN (SELECT DomainID FROM Domains)
UPDATE icewarp..Domains SET D_Domain = d.MailDomain
FROM icewarp..Domains id1, Domains d
	WHERE id1.D_ID = d.DomainID
	AND id1.D_Domain <> d.MailDomain
END

INSERT INTO icewarp..Domains (D_ID,D_Domain)
SELECT DomainID,MailDomain 
FROM Domains
	WHERE DomainID NOT IN (SELECT D_ID FROM icewarp..Domains)

-- Sync Aliases
IF (@synctype IN ('full','daily'))
BEGIN
DELETE FROM icewarp..Aliases WHERE A_UserID NOT IN 
(SELECT AccountID 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.ExternalSystemTypeID = -3
	AND ma.Active = 1
	AND sa.Active = 1)

END

DELETE FROM icewarp..Aliases 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	JOIN icewarp..Aliases a ON (a.A_UserID = sa.AccountID)
	WHERE es.ExternalSystemTypeID = -3
	AND (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync)
	AND ma.Active = 1
	AND sa.Active = 1

INSERT INTO icewarp..Aliases (A_Alias,A_Domain,A_UserID)
SELECT sa.Login, d.MailDomain, sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.ExternalSystemTypeID = -3
	AND (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync)
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
UNION ALL
SELECT CASE WHEN a.Alias LIKE '%_@_%' THEN SUBSTRING(a.Alias,1,CHARINDEX('@',a.Alias)-1) ELSE a.Alias END,
CASE WHEN a.Alias LIKE '%_@_%' THEN SUBSTRING(a.Alias,CHARINDEX('@',a.Alias)+1,DATALENGTH(a.Alias)) ELSE d.MailDomain END, sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	WHERE es.ExternalSystemTypeID = -3
	AND (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync)
	AND ma.Active = 1
	AND sa.Active = 1
	AND a.Alias <> ' '

-- Sync Users

IF (@synctype IN ('full','daily'))
BEGIN
DELETE FROM icewarp..Users WHERE U_ID NOT IN (SELECT sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.ExternalSystemTypeID = -3
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL)
END

INSERT INTO icewarp..Users (U_Type,U_ID,U_Alias,U_Domain,U_Name,U_Mailbox,U_AccountDisabled,U_Password,U_MailboxPath,U_ForwardTo,U_MaxBoxSize,U_AccountType)
SELECT 0 AS U_Type, sa.AccountID AS U_ID, ';' + sa.Login + ';' AS U_Alias,
d.MailDomain AS U_Domain,
CAST(a.FirstName + ' ' + a.LastName AS VARCHAR(127)) AS U_Name,
sa.Login AS U_Mailbox,
CASE WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 1 ELSE 0 END AS U_AccountDisabled,
sa.Password AS U_Password,
d.MailDomain + '\' + REPLACE(REPLACE(REPLACE(sa.Login,'/',''),'\',''),'..','') + '\' AS U_MailboxPath,dbo.GetSubForwards(sa.AccountID) AS U_ForwardTo,
CAST ((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.AccountDataTypeID = @sadtid AND Data LIKE '%[0-9]%') AS INT) AS U_MaxBoxSize,
1 as U_AccountType

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE es.ExternalSystemTypeID = -3
	AND (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync)
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND sa.AccountID NOT IN (SELECT U_ID FROM icewarp..Users)

UPDATE icewarp..Users SET 
U_Alias = ';' + sa.Login + ';',
U_Domain = d.MailDomain,
U_Name = CAST(a.FirstName + ' ' + a.LastName AS VARCHAR(127)),
U_Mailbox = sa.Login,
U_AccountDisabled = CASE WHEN ((sa.ExpireDate IS NULL AND (ma.CancelDate < getdate() OR sa.CancelDate < getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) < getdate()) THEN 1 ELSE 0 END,
U_AccountValidTill = NULL,
U_Password = sa.Password,
U_ForwardTo = dbo.GetSubForwards(sa.AccountID),
U_MaxBoxSize = CAST((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.AccountDataTypeID = @sadtid AND Data LIKE '%[0-9]%') AS INT)

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	JOIN icewarp..Users iu ON (sa.AccountID = iu.U_ID AND iu.U_Type = 0)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE es.ExternalSystemTypeID = -3
	AND (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync OR @synctype IN ('full','daily'))
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL

UPDATE ExternalSystems SET LastSyncDate = @starting WHERE ExternalSystemTypeID = -3
GO

