CREATE TABLE dbo.AccessLabels (
       AccessLabelID        int IDENTITY,
       AccessLabel          varchar(128) NOT NULL,
       ObjectGroupID        int NOT NULL,
       Description          text NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX I_AccessLabels_AL ON dbo.AccessLabels
(
       AccessLabel
)
go




ALTER TABLE dbo.AccessLabels
       ADD PRIMARY KEY (AccessLabelID)
go


CREATE TABLE dbo.AccessTypes (
       AccessTypeID         smallint NOT NULL,
       AccessType           varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.AccessTypes
       ADD PRIMARY KEY (AccessTypeID)
go


CREATE TABLE dbo.AccountChanges (
       AccountChangeID      int IDENTITY,
       CustomerID           int NOT NULL,
       AccountID            int NULL,
       ActiveDate           datetime NOT NULL DEFAULT getdate(),
       InactiveDate         datetime NULL,
       EffectiveDate        datetime NOT NULL DEFAULT getdate(),
       AccountTypeID        int NULL,
       CancelReasonID       int NULL,
       CreateCustomerID     int NULL,
       AllowReinvoice       tinyint NOT NULL DEFAULT 1,
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       InactiveUser         varchar(64) NULL DEFAULT suser_name()
)
go

CREATE INDEX i_AccountChanges_CE ON dbo.AccountChanges
(
       CustomerID,
       AccountID,
       EffectiveDate
)
go









ALTER TABLE dbo.AccountChanges
       ADD PRIMARY KEY (AccountChangeID)
go


CREATE TABLE dbo.AccountDataTypes (
       AccountDataTypeID    int NOT NULL,
       AccountDataType      varchar(64) NOT NULL,
       DataTypeID           smallint NOT NULL,
       AllowMBR             tinyint NOT NULL DEFAULT 1,
       AllowSA              tinyint NOT NULL DEFAULT 1,
       StringID             int NULL,
       SQLQuery             varchar(1024) NULL,
       RegExp               varchar(1024) NULL,
       AccessLabelID        int NULL
)
go

CREATE INDEX i_ADT_ADTs ON dbo.AccountDataTypes
(
       AccountDataType
)
go





ALTER TABLE dbo.AccountDataTypes
       ADD PRIMARY KEY (AccountDataTypeID)
go


CREATE TABLE dbo.AccountDataValues (
       AccountDataTypeID    int NOT NULL,
       KeyData              varchar(128) NOT NULL,
       ValueData            varchar(128) NOT NULL
)
go



ALTER TABLE dbo.AccountDataValues
       ADD PRIMARY KEY (AccountDataTypeID, KeyData)
go


CREATE TABLE dbo.AccountTagTimes (
       AccountTagTimeID     int IDENTITY,
       AccountTagTime       varchar(128) NOT NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       MarketTagID          int NOT NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       AccessTime           varchar(128) NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_AccountTagTimes_CustomerID ON dbo.AccountTagTimes
(
       CustomerID,
       MarketTagID
)
go

CREATE INDEX i_AccountTagTimes_AccountID ON dbo.AccountTagTimes
(
       AccountID,
       MarketTagID
)
go



ALTER TABLE dbo.AccountTagTimes
       ADD PRIMARY KEY (AccountTagTimeID)
go


CREATE TABLE dbo.AccountTemplates (
       AccountTemplateID    int NOT NULL,
       AccountTemplate      varchar(128) NOT NULL,
       SANew                varchar(64) NULL,
       SAEdit               varchar(64) NULL,
       SASave               varchar(64) NULL,
       SADetail             varchar(64) NULL,
       CustNew              varchar(64) NULL,
       CustEdit             varchar(64) NULL,
       CustEditLabel        varchar(128) NULL,
       CustEditStringID     int NULL,
       CustSave             varchar(64) NULL,
       SignupPage           varchar(64) NULL,
       SignupForm           varchar(64) NULL,
       SignupValidate       varchar(64) NULL,
       SignupSave           varchar(64) NULL,
       SignupBillSave       varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go









ALTER TABLE dbo.AccountTemplates
       ADD PRIMARY KEY (AccountTemplateID)
go


CREATE TABLE dbo.AccountTypes (
       AccountTypeID        int IDENTITY,
       AccountType          varchar(64) NOT NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          varchar(128) NOT NULL,
       StringID             int NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       RateClassID          int NULL,
       ChargeTypeID         int NULL,
       SecChargeTypeID      int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       DNISGroupID          int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Extension            smallint NULL DEFAULT 0,
       GLCodeID             int NULL,
       LoginLimit           smallint NULL,
       RemoteAccess         tinyint NOT NULL DEFAULT 0,
       PayPeriodID          int NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       AllowRADIUS          tinyint NOT NULL DEFAULT 1,
       LogonAsParent        tinyint NOT NULL DEFAULT 0,
       UsageToParent        tinyint NOT NULL DEFAULT 0,
       UseServerPassword    tinyint NOT NULL DEFAULT 0,
       ProrateOpen          tinyint NOT NULL DEFAULT 1,
       ProrateOpenTemp      tinyint NOT NULL DEFAULT 1,
       ProrateClose         tinyint NOT NULL DEFAULT 1,
       ProrateCloseTemp     tinyint NOT NULL DEFAULT 1,
       DataLeftRenewal      tinyint NOT NULL DEFAULT 3,
       TimeLeftRenewal      tinyint NOT NULL DEFAULT 3,
       InactCanceledDays    smallint NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       RateTimeLeft         int NULL,
       RateDataLeft         bigint NULL,
       RLimitTimeLeft       int NULL,
       RLimitDataLeft       bigint NULL,
       RLimitRateTimeLeft   int NULL,
       RLimitRateDataLeft   bigint NULL,
       DataLeftAuth         tinyint NOT NULL DEFAULT 0,
       ServiceLevelTypeID   int NULL,
       SecServiceLevelTypeID int NULL,
       NewCost              numeric(18,4) NULL,
       NewCostDate          datetime NULL
)
go

CREATE UNIQUE INDEX XAK1AccountTypes ON dbo.AccountTypes
(
       AccountType
)
go

CREATE INDEX i_AccountTypes_ALID ON dbo.AccountTypes
(
       AccessLabelID
)
go












ALTER TABLE dbo.AccountTypes
       ADD PRIMARY KEY (AccountTypeID)
go


CREATE TABLE dbo.AccountTypeTemplates (
       AccountTypeID        int NOT NULL,
       AccountTemplateID    int NOT NULL
)
go



ALTER TABLE dbo.AccountTypeTemplates
       ADD PRIMARY KEY (AccountTypeID, AccountTemplateID)
go


CREATE TABLE dbo.Actions (
       ActionID             int IDENTITY,
       IncidentID           int NOT NULL,
       CreateOperatorID     int NULL,
       CreateAccountID      int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       Description          text NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       Duration             int NOT NULL DEFAULT 0,
       IncidentTypeID       int NOT NULL,
       IncidentStateID      int NOT NULL,
       AssignRoleID         int NULL,
       AssignOperatorID     int NULL
)
go

CREATE INDEX i_Actions_IncidentID ON dbo.Actions
(
       IncidentID
)
go

CREATE INDEX i_Actions_CD ON dbo.Actions
(
       CreateDate
)
go



ALTER TABLE dbo.Actions
       ADD PRIMARY KEY (ActionID)
go


CREATE TABLE dbo.AddressCategories (
       AddressCategoryID    int NOT NULL,
       AddressCategory      varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go





ALTER TABLE dbo.AddressCategories
       ADD PRIMARY KEY (AddressCategoryID)
go


CREATE TABLE dbo.AddressData (
       AddressID            int NOT NULL,
       AddressDataTypeID    int NOT NULL,
       AddressDataSourceID  int NOT NULL,
       LastUpdate           datetime NOT NULL DEFAULT getdate(),
       Data                 varchar(512) NULL
)
go

CREATE INDEX i_AddressData_ADSID ON dbo.AddressData
(
       AddressDataSourceID
)
go





ALTER TABLE dbo.AddressData
       ADD PRIMARY KEY (AddressID, AddressDataTypeID)
go


CREATE TABLE dbo.AddressDataSources (
       AddressDataSourceID  int NOT NULL,
       AddressDataSource    varchar(128) NOT NULL
)
go



ALTER TABLE dbo.AddressDataSources
       ADD PRIMARY KEY (AddressDataSourceID)
go


CREATE TABLE dbo.AddressDataTypes (
       AddressDataTypeID    int NOT NULL,
       AddressDataType      varchar(128) NOT NULL,
       StringID             int NULL,
       Summary              tinyint NOT NULL DEFAULT 1,
       Detail               tinyint NOT NULL DEFAULT 1,
       IsPhone              tinyint NOT NULL DEFAULT 0,
       ExternalRef          varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       AccessLabelID        int NULL
)
go


ALTER TABLE dbo.AddressDataTypes
       ADD PRIMARY KEY (AddressDataTypeID)
go


CREATE TABLE dbo.Addresses (
       AddressID            int IDENTITY,
       CustomerID           int NULL,
       AccountID            int NULL,
       AddressTypeID        int NOT NULL,
       CountryID            int NULL,
       StateID              int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL DEFAULT suser_name(),
       Gender               char(1) NULL,
       BirthDate            datetime NULL,
       Company              varchar(128) NULL,
       Address1             varchar(180) NULL,
       Address2             varchar(180) NULL,
       City                 varchar(64) NULL,
       Zip                  varchar(20) NULL,
       Province             varchar(80) NULL,
       FirstName            varchar(80) NULL,
       LastName             varchar(80) NULL,
       PhoneHome            varchar(32) NULL,
       PhoneWork            varchar(32) NULL,
       PhoneFax             varchar(32) NULL,
       PhoneMobile          varchar(32) NULL,
       Email                varchar(80) NULL,
       WWW                  varchar(200) NULL,
       IMTypeID             int NULL,
       IMHandle             varchar(80) NULL,
       Lat                  float NULL,
       Long                 float NULL,
       Aux1                 varchar(80) NULL,
       Aux2                 varchar(80) NULL,
       Aux3                 varchar(80) NULL,
       SSN                  varchar(128) NULL,
       TaxNumber            varchar(128) NULL,
       DLNumber             varchar(128) NULL,
       SMSAccessTime        varchar(128) NULL,
       SMSNoticePurposeMask int NOT NULL DEFAULT 2147483647,
       EmailNoticePurposeMask int NOT NULL DEFAULT 2147483647,
       Comments             text NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Addresses_CustomerID ON dbo.Addresses
(
       CustomerID,
       AccountID
)
go

CREATE INDEX i_Addresses_TaxNumber ON dbo.Addresses
(
       TaxNumber
)
go

CREATE INDEX i_Addresses_FirstName ON dbo.Addresses
(
       FirstName
)
go

CREATE INDEX i_Addresses_LastName ON dbo.Addresses
(
       LastName,
       FirstName
)
go

CREATE INDEX i_Addresses_AccountID ON dbo.Addresses
(
       AccountID
)
go


CREATE INDEX i_Addresses_PhoneHome ON dbo.Addresses
(
       PhoneHome
)
go

CREATE INDEX i_Addresses_PhoneWork ON dbo.Addresses
(
       PhoneWork
)
go

CREATE INDEX i_Addresses_PhoneMobile ON dbo.Addresses
(
       PhoneMobile
)
go

CREATE INDEX i_Addresses_City ON dbo.Addresses
(
       City
)
go

CREATE INDEX i_Addresses_Zip ON dbo.Addresses
(
       Zip
)
go

CREATE INDEX i_Addresses_StateID ON dbo.Addresses
(
       StateID
)
go

CREATE INDEX i_Addresses_SSN ON dbo.Addresses
(
       SSN
)
go

CREATE INDEX i_Addresses_Address1 ON dbo.Addresses
(
       Address1
)
go

CREATE INDEX i_Addresses_Company ON dbo.Addresses
(
       Company
)
go

CREATE INDEX i_Addresses_PhoneFax ON dbo.Addresses
(
       PhoneFax
)
go



ALTER TABLE dbo.Addresses
       ADD PRIMARY KEY (AddressID)
go


CREATE TABLE dbo.AddressGeoSources (
       AddressGeoSourceID   int IDENTITY,
       AddressGeoSource     varchar(128) NOT NULL,
       AllowBilling         tinyint NOT NULL DEFAULT 1,
       AllowShipping        tinyint NOT NULL DEFAULT 1,
       AllowService         tinyint NOT NULL DEFAULT 1,
       GroupID              int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       RegionID             int NULL,
       GeoLayerID           int NOT NULL,
       Overlap              varchar(32) NULL,
       GeoShapeAddressDataTypeID int NULL,
       Aux1AddressDataTypeID int NULL,
       Aux2AddressDataTypeID int NULL,
       Aux3AddressDataTypeID int NULL,
       Aux4AddressDataTypeID int NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       Active               tinyint NOT NULL DEFAULT 1
)
go
















ALTER TABLE dbo.AddressGeoSources
       ADD PRIMARY KEY (AddressGeoSourceID)
go


CREATE TABLE dbo.AddressSyncs (
       AddressID            int NOT NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Address1             varchar(180) NULL,
       Address2             varchar(180) NULL,
       City                 varchar(64) NULL,
       Zip                  varchar(20) NULL,
       Lat                  float NULL,
       Long                 float NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastUpdate           datetime NULL,
       ExportStatus         tinyint NULL,
       ErrorCount           int NOT NULL DEFAULT 0,
       Message              varchar(512) NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       ProcTransID          varchar(1024) NULL,
       SessionRef           varchar(32) NULL
)
go





CREATE INDEX i_AddressSyncs_AID_ES ON dbo.AddressSyncs
(
       AddressID,
       ExportStatus
)
go









ALTER TABLE dbo.AddressSyncs
       ADD PRIMARY KEY (AddressID)
go


CREATE TABLE dbo.AddressTypeDataTypes (
       AddressTypeDataTypeID int IDENTITY,
       AddressTypeID        int NOT NULL,
       AddressDataTypeID    int NOT NULL,
       Required             tinyint NOT NULL DEFAULT 0,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX i_ATDT_ATID_ADTID ON dbo.AddressTypeDataTypes
(
       AddressTypeID,
       AddressDataTypeID
)
go




ALTER TABLE dbo.AddressTypeDataTypes
       ADD PRIMARY KEY (AddressTypeDataTypeID)
go


CREATE TABLE dbo.AddressTypes (
       AddressTypeID        int IDENTITY,
       AddressType          varchar(128) NOT NULL,
       StringID             int NULL,
       RequiredFields       varchar(512) NULL,
       ContactPriority      int NOT NULL DEFAULT 0,
       BillingPriority      int NOT NULL DEFAULT 0,
       ShippingPriority     int NOT NULL DEFAULT 0,
       ServicePriority      int NOT NULL DEFAULT 0,
       AllowMBR             tinyint NOT NULL DEFAULT 1,
       AllowSA              tinyint NOT NULL DEFAULT 1,
       AllowAdmin           tinyint NOT NULL DEFAULT 1,
       SMSNoticePurposeMask int NOT NULL DEFAULT 2147483647,
       EmailNoticePurposeMask int NOT NULL DEFAULT 2147483647,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go








ALTER TABLE dbo.AddressTypes
       ADD PRIMARY KEY (AddressTypeID)
go


CREATE TABLE dbo.AlertFileMasterAccounts (
       CustomerID           int NOT NULL,
       FileCategoryID       int NOT NULL,
       AlertStateID         smallint NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       Comments             varchar(512) NULL
)
go


ALTER TABLE dbo.AlertFileMasterAccounts
       ADD PRIMARY KEY (CustomerID, FileCategoryID)
go


CREATE TABLE dbo.AlertFileSubAccounts (
       AccountID            int NOT NULL,
       FileCategoryID       int NOT NULL,
       AlertStateID         smallint NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name()
)
go


ALTER TABLE dbo.AlertFileSubAccounts
       ADD PRIMARY KEY (AccountID, FileCategoryID)
go


CREATE TABLE dbo.AlertInvMasterAccounts (
       CustomerID           int NOT NULL,
       InvProductID         int NOT NULL,
       AlertStateID         smallint NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       Comments             varchar(512) NULL
)
go


ALTER TABLE dbo.AlertInvMasterAccounts
       ADD PRIMARY KEY (CustomerID, InvProductID)
go


CREATE TABLE dbo.AlertInvSubAccounts (
       AccountID            int NOT NULL,
       InvProductID         int NOT NULL,
       AlertStateID         smallint NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       Comments             varchar(512) NULL
)
go


ALTER TABLE dbo.AlertInvSubAccounts
       ADD PRIMARY KEY (AccountID, InvProductID)
go


CREATE TABLE dbo.AlertMaps (
       AlertMapTypeID       smallint NOT NULL,
       AlertMapID           int NOT NULL,
       Message              varchar(1024) NOT NULL
)
go



ALTER TABLE dbo.AlertMaps
       ADD PRIMARY KEY (AlertMapTypeID, AlertMapID)
go


CREATE TABLE dbo.AlertMapTypes (
       AlertMapTypeID       smallint NOT NULL,
       AlertMapType         varchar(128) NULL
)
go



ALTER TABLE dbo.AlertMapTypes
       ADD PRIMARY KEY (AlertMapTypeID)
go


CREATE TABLE dbo.Alerts (
       AlertID              int IDENTITY,
       AlertSourceID        int NOT NULL,
       AlertTypeID          int NOT NULL,
       AlertStateID         smallint NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       ExpireDate           datetime NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       Message              varchar(1024) NULL
)
go

CREATE INDEX i_Alerts_CustomerID ON dbo.Alerts
(
       CustomerID
)
go

CREATE INDEX i_Alerts_AccountID ON dbo.Alerts
(
       AccountID
)
go

CREATE INDEX i_Alerts_AlertStateID ON dbo.Alerts
(
       AlertStateID
)
go

CREATE INDEX i_Alerts_ExpireDate ON dbo.Alerts
(
       ExpireDate
)
go


ALTER TABLE dbo.Alerts
       ADD PRIMARY KEY (AlertID)
go


CREATE TABLE dbo.AlertSources (
       AlertSourceID        int IDENTITY,
       AlertSource          varchar(128) NOT NULL,
       StringID             int NULL,
       AlertSourceTypeID    int NOT NULL,
       ExternalRef          varchar(64) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       IEAID                int NULL
)
go

CREATE INDEX i_AlertSources_ASTID_A ON dbo.AlertSources
(
       AlertSourceTypeID,
       Active
)
go


ALTER TABLE dbo.AlertSources
       ADD PRIMARY KEY (AlertSourceID)
go


CREATE TABLE dbo.AlertSourceTypes (
       AlertSourceTypeID    int NOT NULL,
       AlertSourceType      varchar(128) NOT NULL
)
go


ALTER TABLE dbo.AlertSourceTypes
       ADD PRIMARY KEY (AlertSourceTypeID)
go


CREATE TABLE dbo.AlertStates (
       AlertStateID         smallint NOT NULL,
       AlertState           varchar(128) NOT NULL,
       StringID             int NULL,
       Class                varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go






ALTER TABLE dbo.AlertStates
       ADD PRIMARY KEY (AlertStateID)
go


CREATE TABLE dbo.AlertTypes (
       AlertTypeID          int IDENTITY,
       AlertType            varchar(128) NOT NULL,
       StringID             int NULL,
       AccessLabelID        int NULL,
       AllowManual          tinyint NOT NULL DEFAULT 0,
       ExternalRef          varchar(64) NULL,
       IEAID                int NULL
)
go


ALTER TABLE dbo.AlertTypes
       ADD PRIMARY KEY (AlertTypeID)
go


CREATE TABLE dbo.Aliases (
       AliasID              int IDENTITY,
       Alias                varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Aliases_AccountID ON dbo.Aliases
(
       AccountID
)
go

CREATE INDEX IX_Aliases_Alias ON dbo.Aliases
(
       Alias
)
go


ALTER TABLE dbo.Aliases
       ADD PRIMARY KEY (AliasID)
go


CREATE TABLE dbo.AllowedHosts (
       AllowedHostID        int IDENTITY,
       OperatorGroupID      int NULL,
       IPAddress            varchar(64) NULL,
       Description          varchar(100) NOT NULL
)
go



ALTER TABLE dbo.AllowedHosts
       ADD PRIMARY KEY (AllowedHostID)
go

CREATE TABLE dbo.APIActions (
       APIActionID          int NOT NULL,
       APIAction            varchar(64) NOT NULL,
       APIActionTypeID      int NOT NULL,
       APIGroupCheckID      int NULL,
       FeatureID            int NULL,
       Description          text NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go

CREATE UNIQUE INDEX i_APIActions_APIAction ON dbo.APIActions
(
       APIAction
)
go

ALTER TABLE dbo.APIActions
       ADD PRIMARY KEY (APIActionID)
go


CREATE TABLE dbo.APIActionTypes (
       APIActionTypeID      int NOT NULL,
       APIActionType        varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.APIActionTypes
       ADD PRIMARY KEY (APIActionTypeID)
go


CREATE TABLE dbo.APIFields (
       APIFieldID           int IDENTITY,
       APIFieldTypeID       int NOT NULL,
       APIActionID          int NOT NULL,
       FieldName            varchar(64) NOT NULL,
       Required             varchar(128) NULL,
       Example              varchar(64) NULL,
       Description          text NULL
)
go

CREATE UNIQUE INDEX i_APIFields_AAID_FN_AFTID ON dbo.APIFields
(
       APIActionID,
       FieldName,
       APIFieldTypeID
)
go

ALTER TABLE dbo.APIFields
       ADD PRIMARY KEY (APIFieldID)
go


CREATE TABLE dbo.APIFieldTypes (
       APIFieldTypeID       int NOT NULL,
       APIFieldType         varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.APIFieldTypes
       ADD PRIMARY KEY (APIFieldTypeID)
go


CREATE TABLE dbo.APIGroupChecks (
       APIGroupCheckID      int NOT NULL,
       APIGroupCheck        varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.APIGroupChecks
       ADD PRIMARY KEY (APIGroupCheckID)
go


CREATE TABLE dbo.APIProfileItems (
       APIProfileID         int NOT NULL,
       APIFieldID           int NOT NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.APIProfileItems
       ADD PRIMARY KEY (APIProfileID, APIFieldID)
go


CREATE TABLE dbo.APIProfiles (
       APIProfileID         int IDENTITY,
       APIProfile           varchar(128) NOT NULL
)
go

CREATE UNIQUE INDEX i_APIProfiles_APIProfile ON dbo.APIProfiles
(
       APIProfile
)
go


ALTER TABLE dbo.APIProfiles
       ADD PRIMARY KEY (APIProfileID)
go


CREATE TABLE dbo.APIStepColumns (
       APIStepID            int NOT NULL,
       MetaColumnID         int NOT NULL,
       Data                 varchar(255) NULL,
       DefaultData          varchar(255) NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.APIStepColumns
       ADD PRIMARY KEY (APIStepID, MetaColumnID)
go


CREATE TABLE dbo.APISteps (
       APIStepID            int IDENTITY,
       APIStep              varchar(128) NOT NULL,
       APIActionID          int NOT NULL,
       Step                 int NOT NULL,
       APIStepTypeID        int NOT NULL,
       FeatureID            int NULL,
       Condition            varchar(255) NULL,
       MetaTableID          int NULL,
       ValueQuery           text NULL,
       ValueFields          text NULL,
       DisplayQuery         text NULL,
       DisplayParent        varchar(64) NULL,
       EWS                  text NULL,
       IEAID                int NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go

CREATE UNIQUE INDEX i_APISteps_AAID_Step ON dbo.APISteps
(
       APIActionID,
       Step
)
go

ALTER TABLE dbo.APISteps
       ADD PRIMARY KEY (APIStepID)
go


CREATE TABLE dbo.APIStepTypes (
       APIStepTypeID        int NOT NULL,
       APIStepType          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.APIStepTypes
       ADD PRIMARY KEY (APIStepTypeID)
go


CREATE TABLE dbo.APITokens (
       APITokenID           bigint IDENTITY,
       OperatorID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CommitDate           datetime NULL,
       Locked               tinyint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.APITokens
       ADD PRIMARY KEY (APITokenID)
go

CREATE TABLE dbo.Applications (
       ApplicationID        int NOT NULL,
       AppName              varchar(32) NOT NULL
)
go

CREATE INDEX XIE1Applications ON dbo.Applications
(
       AppName
)
go


ALTER TABLE dbo.Applications
       ADD PRIMARY KEY (ApplicationID)
go


CREATE TABLE dbo.AuditActions (
       AuditActionID        tinyint NOT NULL,
       AuditAction          varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.AuditActions
       ADD PRIMARY KEY (AuditActionID)
go


CREATE TABLE dbo.AuditLogs (
       AuditLogID           int IDENTITY,
       LogMsgID             smallint NOT NULL,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       LogMsg               varchar(255) NULL,
       Operator             varchar(64) NULL,
       CustomerID           int NULL,
       AccountID            int NULL
)
go

CREATE INDEX i_Logs_LogDate ON dbo.AuditLogs
(
       LogDate
)
go

CREATE INDEX i_AuditLogs_CustomerID ON dbo.AuditLogs
(
       CustomerID
)
go





ALTER TABLE dbo.AuditLogs
       ADD PRIMARY KEY (AuditLogID)
go


CREATE TABLE dbo.AuditTableInserts (
       AuditTableID         int NOT NULL,
       MetaColumnID         int NOT NULL,
       Data                 varchar(1024) NULL
)
go



ALTER TABLE dbo.AuditTableInserts
       ADD PRIMARY KEY (AuditTableID, MetaColumnID)
go


CREATE TABLE dbo.AuditTables (
       AuditTableID         int IDENTITY,
       AuditTransID         int NOT NULL,
       MetaTableID          int NOT NULL,
       KeyID                int NOT NULL,
       AuditActionID        tinyint NOT NULL
)
go

CREATE CLUSTERED INDEX I_AuditTables_ATID ON dbo.AuditTables
(
       AuditTransID,
       AuditTableID
)
go

CREATE INDEX I_AuditTables_MTID ON dbo.AuditTables
(
       MetaTableID
)
go




ALTER TABLE dbo.AuditTables
       ADD PRIMARY KEY NONCLUSTERED (AuditTableID)
go


CREATE TABLE dbo.AuditTableUpdates (
       AuditTableID         int NOT NULL,
       MetaColumnID         int NOT NULL,
       PreviousData         varchar(1024) NULL,
       Data                 varchar(1024) NULL
)
go



ALTER TABLE dbo.AuditTableUpdates
       ADD PRIMARY KEY (AuditTableID, MetaColumnID)
go


CREATE TABLE dbo.AuditTrans (
       AuditTransID         int IDENTITY,
       OperatorID           int NULL,
       CustomerID           int NULL,
       CommitDate           datetime NOT NULL,
       IPAddress            varchar(64) NULL
)
go

CREATE INDEX i_AuditTrans_CommitDate ON dbo.AuditTrans
(
       CommitDate
)
go

CREATE INDEX I_AuditTrans_OID ON dbo.AuditTrans
(
       OperatorID,
       CommitDate
)
go



ALTER TABLE dbo.AuditTrans
       ADD PRIMARY KEY (AuditTransID)
go


CREATE TABLE dbo.BankRoutes (
       ABANumber            varchar(15) NOT NULL,
       BankName             varchar(64) NULL,
       BankPhone            varchar(20) NULL
)
go

CREATE INDEX IX_BankRoutes ON dbo.BankRoutes
(
       BankName
)
go


ALTER TABLE dbo.BankRoutes
       ADD PRIMARY KEY (ABANumber)
go


CREATE TABLE dbo.BankTrans (
       CustomerID           int NOT NULL,
       AuthName             varchar(64) NOT NULL,
       BankName             varchar(64) NOT NULL,
       BankPhone            varchar(20) NULL,
       ABANumber            varchar(128) NOT NULL,
       AccountNumber        varchar(128) NOT NULL,
       TransType            varchar(16) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       SSN                  varchar(128) NULL,
       DLNumber             varchar(128) NULL,
       DLState              varchar(40) NULL,
       BirthDate            datetime NULL
)
go


ALTER TABLE dbo.BankTrans
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.Batches (
       BatchID              int IDENTITY,
       BatchTypeID          int NOT NULL,
       BatchStateID         int NOT NULL,
       GroupID              int NULL,
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       StartDate            datetime NOT NULL DEFAULT getdate(),
       EndDate              datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       BatchInfo            varchar(512) NULL,
       ItemCount            int NULL,
       ItemTotal            numeric(18,4) NULL,
       Rebatch              smallint NULL
)
go

CREATE INDEX i_Batches_GroupID ON dbo.Batches
(
       GroupID
)
go

CREATE INDEX i_Batches_BatchTypeID ON dbo.Batches
(
       BatchTypeID,
       BatchStateID
)
go

CREATE INDEX i_Batches_StartDate ON dbo.Batches
(
       StartDate
)
go




ALTER TABLE dbo.Batches
       ADD PRIMARY KEY (BatchID)
go


CREATE TABLE dbo.BatchProcessors (
       BatchProcessorID     int IDENTITY,
       OrganizationID       int NULL,
       GroupID              int NULL,
       ExportID             int NOT NULL,
       BatchProcessor       varchar(128) NOT NULL,
       BatchIn              varchar(255) NULL,
       BatchOut             varchar(255) NULL,
       BatchLimit           int NULL,
       Merchant             varchar(64) NULL,
       Store                varchar(64) NULL,
       Terminal             varchar(64) NULL,
       BatchAux1            varchar(128) NULL,
       BatchAux2            varchar(128) NULL,
       BatchAux3            varchar(128) NULL,
       ImportOptions        int NULL,
       ExportOptions        int NULL,
       RebatchTries         int NULL DEFAULT 0,
       RebatchInterval      int NULL,
       ProcessorURL         varchar(255) NULL,
       Login                varchar(64) NULL,
       Password             varchar(200) NULL,
       CardTypes            int NOT NULL DEFAULT 255,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               tinyint NOT NULL DEFAULT 1,
       CertID               int NULL
)
go

CREATE INDEX Statistic_CardTypes ON dbo.BatchProcessors
(
       CardTypes
)
go









ALTER TABLE dbo.BatchProcessors
       ADD PRIMARY KEY (BatchProcessorID)
go


CREATE TABLE dbo.BatchStates (
       BatchStateID         int NOT NULL,
       BatchState           varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.BatchStates
       ADD PRIMARY KEY (BatchStateID)
go


CREATE TABLE dbo.BatchTypes (
       BatchTypeID          int NOT NULL,
       BatchType            varchar(64) NOT NULL,
       StringID             int NULL,
       TableName            varchar(64) NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.BatchTypes
       ADD PRIMARY KEY (BatchTypeID)
go


CREATE TABLE dbo.BillingCycles (
       BillingCycleID       int IDENTITY,
       BillingCycle         varchar(128) NOT NULL,
       StringID             int NULL,
       CycleType            smallint NOT NULL DEFAULT 0,
       AutoBill             smallint NOT NULL DEFAULT 0,
       Extension            smallint NULL,
       BillDay              int NULL,
       IBillDays            int NOT NULL DEFAULT 15,
       EBillDays            int NOT NULL DEFAULT 5,
       RenewDays            int NOT NULL DEFAULT 0,
       RenewPeriods         int NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       TBillDays            int NULL,
       ExpCancelReasonID    int NULL,
       BillMonth            tinyint NULL
)
go














ALTER TABLE dbo.BillingCycles
       ADD PRIMARY KEY (BillingCycleID)
go


CREATE TABLE dbo.BillingImports (
       BillingImportID      int NOT NULL,
       BillingImportTypeID  int NOT NULL,
       BillingImport        varchar(128) NOT NULL,
       StringID             int NULL,
       RegExp               varchar(1024) NOT NULL,
       LookupQuery          varchar(1024) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Description          text NULL
)
go

CREATE INDEX i_BillingImports_BIT ON dbo.BillingImports
(
       BillingImportTypeID
)
go





ALTER TABLE dbo.BillingImports
       ADD PRIMARY KEY (BillingImportID)
go


CREATE TABLE dbo.BillingImportTypes (
       BillingImportTypeID  int NOT NULL,
       BillingImportType    varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.BillingImportTypes
       ADD PRIMARY KEY (BillingImportTypeID)
go


CREATE TABLE dbo.BulkItems (
       BulkItemID           int IDENTITY,
       BulkProfileID        int NOT NULL,
       BulkItem             varchar(128) NOT NULL,
       Allowed              tinyint NOT NULL DEFAULT 1,
       GroupID              int NULL,
       RegionID             int NULL,
       TowerID              int NULL,
       ServiceCategoryID    int NULL,
       AccountTypeID        int NULL,
       BillingCycleID       int NULL,
       MarketTagID          int NULL,
       PaymentTypeID        int NULL,
       SendMethodID         int NULL,
       AddressCategoryID    int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Zip                  varchar(20) NULL,
       City                 varchar(64) NULL,
       AddressDataTypeID    int NULL,
       AddressData          varchar(128) NULL,
       MAAccountDataTypeID  int NULL,
       MAData               varchar(128) NULL,
       SAAccountDataTypeID  int NULL,
       SAData               varchar(128) NULL
)
go


ALTER TABLE dbo.BulkItems
       ADD PRIMARY KEY (BulkItemID)
go


CREATE TABLE dbo.BulkMessages (
       BulkMessageID        int IDENTITY,
       BulkMessage          varchar(128) NOT NULL,
       NoticeFormatID       smallint NOT NULL DEFAULT 1,
       NoticeTechID         smallint NOT NULL DEFAULT 1,
       AccessLabelID        int NULL,
       MailFrom             varchar(128) NULL,
       MailSubject          varchar(128) NULL,
       Message              text NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.BulkMessages
       ADD PRIMARY KEY (BulkMessageID)
go


CREATE TABLE dbo.BulkProfiles (
       BulkProfileID        int IDENTITY,
       BulkProfile          varchar(128) NOT NULL,
       StringID             int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.BulkProfiles
       ADD PRIMARY KEY (BulkProfileID)
go


CREATE TABLE dbo.Calendars (
	CalendarID	int IDENTITY,
	Calendar	varchar (128) NOT NULL,
	CreateDate	datetime NOT NULL DEFAULT getdate(),
	OperatorID	int NOT NULL,
	OrganizationID	int NULL,
	GroupID		int NULL,
	IncidentTypeID	int NULL,
	RoleID		int NULL,
	AuthKey		varchar (32) NOT NULL,
	LastModifyDate	datetime NULL DEFAULT getdate()
)
go

ALTER TABLE dbo.Calendars
       ADD PRIMARY KEY (CalendarID)
go

CREATE UNIQUE INDEX i_Calendars_AuthKey ON dbo.Calendars
(
	AuthKey
)
go

CREATE INDEX i_Calendars_OperatorID ON dbo.Calendars
(
	OperatorID
)
go



CREATE TABLE dbo.CallCosts (
       CallStartID          bigint NOT NULL,
       RateID               int NOT NULL,
       Cost                 numeric(28,12) NOT NULL
)
go


ALTER TABLE dbo.CallCosts
       ADD PRIMARY KEY (CallStartID, RateID)
go


CREATE TABLE dbo.CallInterims (
       CallInterimID        bigint IDENTITY,
       CallStartID          bigint NOT NULL,
       AcctSessionTime      int NOT NULL,
       AcctInputOctets      bigint NOT NULL DEFAULT 0,
       AcctOutputOctets     bigint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX IX_CallInterims ON dbo.CallInterims
(
       CallStartID,
       AcctSessionTime
) WITH IGNORE_DUP_KEY
go





ALTER TABLE dbo.CallInterims
       ADD PRIMARY KEY (CallInterimID)
go


CREATE TABLE dbo.CallStarts (
       CallStartID          bigint IDENTITY,
       Username             varchar(64) NOT NULL,
       AcctSessionID        varchar(40) NOT NULL,
       NASIdentifier        varchar(45) NOT NULL,
       NASPort              varchar(32) NULL DEFAULT ' ',
       TimeRef              smallint NULL DEFAULT 0,
       CallDate             datetime NOT NULL DEFAULT getdate(),
       AcctDelayTime        smallint NOT NULL DEFAULT 0,
       AccountID            int NULL,
       ServerID             int NULL,
       CallingStationID     varchar(64) NULL,
       CalledStationID      varchar(64) NULL,
       NASPortType          smallint NULL,
       AcctStatusType       tinyint NOT NULL,
       FramedIPAddress      varchar(15) NULL,
       FramedIPv6Address    varchar(39) NULL,
       FramedIPv6Prefix     varchar(43) NULL,
       ConnectInfo          varchar(64) NULL
)
go

CREATE UNIQUE INDEX i_CallStarts_FPK ON dbo.CallStarts
(
       Username,
       AcctSessionID,
       NASIdentifier,
       NASPort,
       TimeRef
) WITH IGNORE_DUP_KEY
go

CREATE INDEX i_CallStarts_AccountID ON dbo.CallStarts
(
       AccountID,
       CallDate
)
go







CREATE INDEX i_CallStarts_CallDate ON dbo.CallStarts
(
       CallDate
)
go









ALTER TABLE dbo.CallStarts
       ADD PRIMARY KEY (CallStartID)
go


CREATE TABLE dbo.CallStops (
       CallStartID          bigint NOT NULL,
       CallSessionTime      int NOT NULL DEFAULT 0,
       AcctDelayTime        smallint NOT NULL DEFAULT 0,
       AcctSessionTime      int NULL DEFAULT 0,
       AcctInputOctets      bigint NULL,
       AcctOutputOctets     bigint NULL,
       AcctTerminateCause   smallint NULL
)
go

CREATE UNIQUE CLUSTERED INDEX i_CallStops_CSID ON CallStops
(
       CallStartID
) WITH IGNORE_DUP_KEY
go








CREATE TABLE dbo.CancelReasons (
       CancelReasonID       int IDENTITY,
       CancelReason         varchar(128) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       Returning            tinyint NOT NULL DEFAULT 0,
       CustomerAccess       tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go





ALTER TABLE dbo.CancelReasons
       ADD PRIMARY KEY (CancelReasonID)
go


CREATE TABLE dbo.CardAccounts (
       CardAccountID        int IDENTITY,
       CardBatchID          int NOT NULL,
       OrganizationID       int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       Login                varchar(40) NOT NULL,
       Password             varchar(128) NOT NULL,
       InactiveExpireDate   datetime NULL,
       FirstUseDate         datetime NULL,
       AllowCredit          tinyint NOT NULL DEFAULT 1,
       UsedForCredit        tinyint NOT NULL DEFAULT 0,
       LastCreditDate       datetime NULL,
       CreditAmount         numeric(18,4) NULL,
       AllowDirect          tinyint NOT NULL DEFAULT 1,
       UsedForDirect        tinyint NOT NULL DEFAULT 0,
       DirectCustomerID     int NULL,
       DirectAccountID      int NULL
)
go

CREATE UNIQUE INDEX I_CardAccounts_Login ON dbo.CardAccounts
(
       Login
)
go

CREATE INDEX I_CardAccounts_CardBatchID ON dbo.CardAccounts
(
       CardBatchID,
       Active
)
go











ALTER TABLE dbo.CardAccounts
       ADD PRIMARY KEY (CardAccountID)
go


CREATE TABLE dbo.CardBatches (
       CardBatchID          int IDENTITY,
       CardBatch            varchar(128) NULL,
       CardBatchTypeID      int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       OperatorID           int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       LastModifyDate       datetime NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NULL,
       InactiveExpireDate   datetime NULL,
       ActiveExpireDays     int NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       RateTimeLeft         int NULL,
       RateDataLeft         bigint NULL,
       Amount               numeric(18,4) NULL,
       GroupID              int NOT NULL,
       LoginCardDigitID     int NOT NULL,
       PasswordCardDigitID  int NOT NULL,
       AllowDirect          tinyint NOT NULL DEFAULT 1,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          int NULL,
       SendMethodID         int NULL,
       BillingCycleID       int NULL,
       ServiceCategoryID    int NULL,
       AccountTypeID        int NULL,
       DomainID             int NULL,
       SalesPersonID        int NULL,
       RangeStart           numeric(18,4) NULL,
       BatchSize            int NOT NULL,
       RangeStep            numeric(18,4) NULL,
       LoginPrefix          varchar(10) NULL,
       LoginParm1           varchar(20) NULL,
       LoginParm2           varchar(20) NULL,
       PasswordParm1        varchar(20) NULL,
       PasswordParm2        varchar(20) NULL,
       Comments             text NULL,
       ActiveExpireMins     int NULL
)
go







ALTER TABLE dbo.CardBatches
       ADD PRIMARY KEY (CardBatchID)
go


CREATE TABLE dbo.CardBatchTypes (
       CardBatchTypeID      int IDENTITY,
       CardBatchType        varchar(128) NOT NULL,
       InactiveExpireDays   int NULL,
       ActiveExpireDays     int NOT NULL DEFAULT 30,
       Amount               numeric(18,4) NULL,
       BatchSize            int NULL,
       GroupID              int NULL,
       LoginCardDigitID     int NOT NULL,
       PasswordCardDigitID  int NOT NULL,
       AllowDirectUse       smallint NOT NULL DEFAULT 1,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          int NULL,
       SendMethodID         int NULL,
       BillingCycleID       int NULL,
       ServiceCategoryID    int NULL,
       AccountTypeID        int NULL,
       DomainID             int NULL,
       SalesPersonID        int NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       RateTimeLeft         int NULL,
       RateDataLeft         bigint NULL,
       ActiveExpireMins     int NULL
)
go


ALTER TABLE dbo.CardBatchTypes
       ADD PRIMARY KEY (CardBatchTypeID)
go


CREATE TABLE dbo.CardDigits (
       CardDigitID          int IDENTITY,
       CardDigit            varchar(64) NOT NULL,
       JavascriptHeader     text NULL,
       JavascriptField      text NOT NULL,
       AllowLogin           smallint NOT NULL DEFAULT 1,
       AllowPassword        smallint NOT NULL DEFAULT 1,
       IEAID                int NULL
)
go





ALTER TABLE dbo.CardDigits
       ADD PRIMARY KEY (CardDigitID)
go


CREATE TABLE dbo.CardTypePrefixes (
       CardTypeID           int NOT NULL,
       Prefix               varchar(5) NOT NULL
)
go


ALTER TABLE dbo.CardTypePrefixes
       ADD PRIMARY KEY (CardTypeID, Prefix)
go


CREATE TABLE dbo.CardTypes (
       CardTypeID           int NOT NULL,
       CardType             varchar(128) NOT NULL,
       Length1              int NULL,
       Length2              int NULL,
       CRC                  varchar(10) NOT NULL DEFAULT 'crc'
)
go




ALTER TABLE dbo.CardTypes
       ADD PRIMARY KEY (CardTypeID)
go


CREATE TABLE dbo.CCImportColumns (
       CCImportColumnID     int IDENTITY,
       ExportID             int NOT NULL,
       FieldType            smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Position             smallint NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL DEFAULT 0,
       FieldSize            smallint NOT NULL,
       ApproveValue         varchar(128) NULL,
       DeclineValue         varchar(128) NULL,
       ErrorValue           varchar(128) NULL,
       Line                 int NOT NULL DEFAULT 1,
       TransType            int NOT NULL DEFAULT 511,
       IEAID                int NULL
)
go




ALTER TABLE dbo.CCImportColumns
       ADD PRIMARY KEY (CCImportColumnID)
go


CREATE TABLE dbo.Charges (
       ChargeID             int IDENTITY,
       CustomerID           int NOT NULL,
       Description          varchar(128) NULL,
       StartDate            datetime NOT NULL DEFAULT getdate(),
       EndDate              datetime NOT NULL DEFAULT getdate(),
       AccountID            int NULL,
       AccountTypeID        int NULL,
       DistFlag             tinyint NOT NULL DEFAULT 1,
       AllowInterim         tinyint NOT NULL DEFAULT 1,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       ChargeTypeID         int NULL,
       ItemID               int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       AllowDupe            tinyint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_Charges_CustomerID ON dbo.Charges
(
       CustomerID
)
go

CREATE INDEX i_Charges_ItemID ON dbo.Charges
(
       ItemID
)
go

ALTER TABLE dbo.Charges
       ADD PRIMARY KEY (ChargeID)
go


CREATE TABLE dbo.Certs (
       CertID               int IDENTITY,
       Cert                 varchar(128) NOT NULL,
       CertTypeID           int NOT NULL,
       Bits                 smallint NULL,
       PrivateKey           text NULL,
       PublicKey            text NULL,
       Comments             text NULL,
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate()
)
go

ALTER TABLE dbo.Certs
       ADD PRIMARY KEY (CertID)
go


CREATE TABLE dbo.CertTypes (
       CertTypeID           int NOT NULL,
       CertType             varchar(128) NOT NULL,
       Description          text NULL,
       StorePrivateKey      tinyint NOT NULL,
       StorePublicKey       tinyint NOT NULL,
       ChangePrivateKey     tinyint NOT NULL,
       ChangePublicKey      tinyint NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.CertTypes
       ADD PRIMARY KEY (CertTypeID)
go




CREATE TABLE dbo.ChargeTypes (
       ChargeTypeID         int IDENTITY,
       ChargeType           varchar(45) NOT NULL,
       StringID             int NULL,
       Amount               numeric(18,4) NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       AccessLabelID        int NULL,
       GLCodeID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_ChargeTypes_ALID ON dbo.ChargeTypes
(
       AccessLabelID
)
go









ALTER TABLE dbo.ChargeTypes
       ADD PRIMARY KEY (ChargeTypeID)
go


CREATE TABLE dbo.ClientCertInacts (
       ClientCertInactID    int IDENTITY,
       ClientCertInact      varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ClientCertInacts
       ADD PRIMARY KEY (ClientCertInactID)
go


CREATE TABLE dbo.ClientCerts (
       ClientCertID         int IDENTITY,
       ClientCert           varchar(128) NOT NULL,
       OperatorID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       DownloadDate         datetime NULL,
       DownloadOperatorID   int NULL,
       DownloadIPAddress    varchar(64) NULL,
       ClientCertInactID    int NULL,
       Comments             varchar(512) NULL,
       Bits                 int NOT NULL DEFAULT 2048,
       ExpireDate           datetime NOT NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE UNIQUE CLUSTERED INDEX i_ClientCerts_CN ON ClientCerts
(
       ClientCert
)
go

CREATE INDEX i_ClientCerts_OperatorID ON dbo.ClientCerts
(
       OperatorID,
       ClientCertInactID,
       ExpireDate
)
go







ALTER TABLE dbo.ClientCerts
       ADD PRIMARY KEY NONCLUSTERED (ClientCertID)
go


CREATE TABLE dbo.CommissionGroups (
       CommissionGroupID    int IDENTITY,
       CommissionGroup      varchar(128) NOT NULL,
       CommissionType       smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               tinyint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.CommissionGroups
       ADD PRIMARY KEY (CommissionGroupID)
go


CREATE TABLE dbo.CommissionItems (
       CommissionItemID     int IDENTITY,
       CommissionGroupID    int NOT NULL,
       AccountTypeID        int NULL,
       ChargeTypeID         int NULL,
       CommissionValue      numeric(18,4) NOT NULL,
       Comments             varchar(255) NULL
)
go

CREATE INDEX I_CI_AT ON dbo.CommissionItems
(
       CommissionGroupID,
       AccountTypeID
)
go

CREATE INDEX I_CI_CT ON dbo.CommissionItems
(
       CommissionGroupID,
       ChargeTypeID
)
go


ALTER TABLE dbo.CommissionItems
       ADD PRIMARY KEY (CommissionItemID)
go


CREATE TABLE dbo.ConfigGroupData (
       ConfigID             int NOT NULL,
       GroupID              int NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go

CREATE INDEX Statistic_NumValue ON dbo.ConfigGroupData
(
       NumValue
)
go



ALTER TABLE dbo.ConfigGroupData
       ADD PRIMARY KEY (ConfigID, GroupID)
go


CREATE TABLE dbo.ConfigGroups (
       ConfigGroupID        int NOT NULL,
       Name                 varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       VisibleGlobal        smallint NOT NULL DEFAULT 1,
       VisibleGroupID       smallint NOT NULL DEFAULT 0,
       VisibleOperatorGroupID smallint NOT NULL DEFAULT 0
)
go







ALTER TABLE dbo.ConfigGroups
       ADD PRIMARY KEY (ConfigGroupID)
go


CREATE TABLE dbo.ConfigOperatorGroupData (
       ConfigID             int NOT NULL,
       OperatorGroupID      int NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go



ALTER TABLE dbo.ConfigOperatorGroupData
       ADD PRIMARY KEY (ConfigID, OperatorGroupID)
go


CREATE TABLE dbo.Configs (
       ConfigID             int NOT NULL,
       ConfigGroupID        int NOT NULL,
       DataTypeID           smallint NOT NULL DEFAULT 1,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       FeatureID            int NULL,
       AllowGlobal          tinyint NOT NULL DEFAULT 1,
       AllowGroupID         tinyint NOT NULL DEFAULT 0,
       AllowOperatorGroupID tinyint NOT NULL DEFAULT 0,
       ValuesQuery          varchar(255) NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go













ALTER TABLE dbo.Configs
       ADD PRIMARY KEY (ConfigID)
go


CREATE TABLE dbo.ConfigValues (
       ConfigID             int NOT NULL,
       NumValue             numeric(18,4) NOT NULL,
       ValueName            varchar(128) NOT NULL
)
go




ALTER TABLE dbo.ConfigValues
       ADD PRIMARY KEY (ConfigID, NumValue)
go


CREATE TABLE dbo.Continents (
       ContinentID          int NOT NULL,
       Continent            varchar(64) NOT NULL,
       Planet               varchar(64) NOT NULL,
       Hidden               smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.Continents
       ADD PRIMARY KEY (ContinentID)
go


CREATE TABLE dbo.Countries (
       CountryID            int NOT NULL,
       Country              varchar(64) NOT NULL,
       StringID             int NULL,
       InternetDomain       varchar(5) NULL,
       ContinentID          int NOT NULL,
       TelPrefix            varchar(10) NULL,
       TelIDD               varchar(32) NULL,
       TelNDD               varchar(32) NULL,
       TelLocPrefixLen      smallint NULL,
       Abbr2                char(2) NULL,
       Abbr3                char(3) NULL,
       Hidden               smallint NOT NULL DEFAULT 0,
       Restricted           smallint NOT NULL DEFAULT 0,
       Currency             varchar(5) NULL,
       Comments             varchar(255) NULL,
       ZipStatus            smallint NULL,
       DescAux1             varchar(128) NULL,
       DescAux2             varchar(128) NULL,
       DescAux3             varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 100,
       NNLength             tinyint NULL
)
go

CREATE INDEX IX_Countries ON dbo.Countries
(
       Country
)
go













ALTER TABLE dbo.Countries
       ADD PRIMARY KEY (CountryID)
go


CREATE TABLE dbo.CreditCards (
       CustomerID           int NOT NULL,
       CardHolder           varchar(121) NULL,
       CardNumber           varchar(70) NULL,
       CardTypeID           int NULL,
       CardLength           int NULL,
       ExpirationDate       datetime NOT NULL,
       BillToAddress1       varchar(100) NULL,
       BillToAddress2       varchar(100) NULL,
       BillToCity           varchar(64) NULL,
       BillToZip            varchar(20) NULL,
       BillToCountryID      int NULL,
       BillToStateID        int NULL,
       SecurityCode         varchar(64) NULL,
       Bank                 varchar(64) NULL,
       BankPhone            varchar(32) NULL,
       Misc1                varchar(64) NULL,
       Misc2                varchar(64) NULL,
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       Token                varchar(128) NULL,
       BatchProcessorID     int NULL,
       CertID               int NULL,
       CertCardNumber       text NULL
)
go

CREATE INDEX i_CreditCards_Token ON dbo.CreditCards
(
       Token
)
go

CREATE INDEX i_CreditCards_CardNumber ON dbo.CreditCards
(
       CardNumber
)
go

CREATE INDEX i_CreditCards_CertID ON dbo.CreditCards
(
       CertID
)
go

ALTER TABLE dbo.CreditCards
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.CreditCardUpdates (
       CustomerID           int NOT NULL,
       BatchProcessorID     int NOT NULL,
       LastExported         datetime NULL,
       LastReplaced         datetime NULL,
       LastUpdated          datetime NULL,
       LastFailed           datetime NULL,
       ExpirationDate       datetime NOT NULL,
       Token                varchar(128) NULL,
       Message              varchar(255) NULL
)
go

ALTER TABLE dbo.CreditCardUpdates
       ADD PRIMARY KEY (CustomerID, BatchProcessorID)
go


CREATE TABLE dbo.Currencies (
       CurrencyID           int NOT NULL,
       CountryID            int NULL,
       Currency             varchar(64) NULL,
       Symbol               varchar(50) NULL,
       Code                 varchar(5) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_Currencies_CountryID ON dbo.Currencies
(
       CountryID
)
go

CREATE INDEX i_Currencies_Code ON dbo.Currencies
(
       Code
)
go



ALTER TABLE dbo.Currencies
       ADD PRIMARY KEY (CurrencyID)
go


CREATE TABLE dbo.Dashes (
       DashID               int IDENTITY,
       DashTypeID           int NOT NULL,
       OperatorID           int NOT NULL,
       OrganizationID       int NULL,
       GroupID              int NULL,
       RegionID             int NULL,
       MarketTagID          int NULL,
       IncidentTypeID       int NULL,
       IncidentStateID      int NULL,
       RoleID               int NULL,
       SchedBlockTypeID     int NULL,
       Aux1                 int NULL,
       Aux2                 int NULL,
       Aux3                 int NULL,
       Aux4                 int NULL,
       Aux5                 int NULL
)
go

CREATE INDEX i_Dashes_OID ON dbo.Dashes
(
       OperatorID
)
go



ALTER TABLE dbo.Dashes
       ADD PRIMARY KEY (DashID)
go


CREATE TABLE dbo.DashTypes (
       DashTypeID           int NOT NULL,
       DashType             varchar(128) NOT NULL,
       StringID             int NULL,
       Description          text NULL,
       FileDisplay          varchar(64) NULL,
       FileList             varchar(64) NULL,
       FileEdit             varchar(64) NULL,
       FileUpdate           varchar(64) NULL,
       FileDelete           varchar(64) NULL,
       AccessLabel          varchar(64) NULL,
       FeatureID            int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.DashTypes
       ADD PRIMARY KEY (DashTypeID)
go


CREATE TABLE dbo.DataTypes (
       DataTypeID           smallint NOT NULL,
       DataType             varchar(64) NOT NULL,
       ConfigsOnly          smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.DataTypes
       ADD PRIMARY KEY (DataTypeID)
go


CREATE TABLE dbo.Discounts (
       DiscountID           int IDENTITY,
       Discount             varchar(128) NOT NULL,
       StringID             int NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT 0,
       AmountType           tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1,
       ChargeTypeID         int NULL
)
go


ALTER TABLE dbo.Discounts
       ADD PRIMARY KEY (DiscountID)
go


CREATE TABLE dbo.DNISGroups (
       DNISGroupID          int IDENTITY,
       DNISGroup            varchar(25) NOT NULL,
       Description          varchar(45) NOT NULL
)
go

CREATE INDEX i_DNISGroups_DNISGroup ON dbo.DNISGroups
(
       DNISGroup
)
go


ALTER TABLE dbo.DNISGroups
       ADD PRIMARY KEY (DNISGroupID)
go


CREATE TABLE dbo.DNISNumbers (
       DNISGroupID          int NOT NULL,
       DNISNumber           varchar(20) NOT NULL
)
go


ALTER TABLE dbo.DNISNumbers
       ADD PRIMARY KEY (DNISGroupID, DNISNumber)
go


CREATE TABLE dbo.Domains (
       DomainID             int IDENTITY,
       Domain               varchar(128) NOT NULL,
       ServiceGroupID       int NULL,
       MailDomain           varchar(64) NOT NULL,
       GroupID              int NULL,
       CustomerID           int NULL,
       Description          varchar(1024) NOT NULL,
       ExternalRef          varchar(64) NULL,
       CustomerAccess       tinyint NULL,
       ExpireDate           datetime NULL,
       ExternalDNSRef       varchar(64) NULL,
       ErrorCount           int NULL,
       ErrorMessage         varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_Domains_Domain ON dbo.Domains
(
       Domain
)
go

CREATE INDEX i_Domains_MailDomain ON dbo.Domains
(
       MailDomain
)
go

CREATE INDEX i_Domains_CustomerID ON dbo.Domains
(
       CustomerID
)
go


ALTER TABLE dbo.Domains
       ADD PRIMARY KEY (DomainID)
go


CREATE TABLE dbo.EmailTypes (
       EmailTypeID          smallint NOT NULL,
       EmailType            varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go





ALTER TABLE dbo.EmailTypes
       ADD PRIMARY KEY (EmailTypeID)
go


CREATE TABLE dbo.Events (
       EventID              int IDENTITY,
       Event                varchar(128) NOT NULL,
       EventTypeID          int NOT NULL,
       GroupID              int NULL,
       RegionID             int NULL,
       MarketTagID          int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       Description          text NULL,
       Resolution           text NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       CloseDate            datetime NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       TowerID              int NULL,
       BulkProfileID        int NULL
)
go

CREATE INDEX i_Events_GroupID ON dbo.Events
(
       GroupID
)
go

CREATE INDEX i_Events_MarketTagID ON dbo.Events
(
       MarketTagID
)
go

CREATE INDEX i_Events_CD_A ON dbo.Events
(
       CreateDate,
       Active
)
go

CREATE INDEX i_Events_Active ON dbo.Events
(
       Active,
       CloseDate
)
go






ALTER TABLE dbo.Events
       ADD PRIMARY KEY (EventID)
go


CREATE TABLE dbo.EventTypes (
       EventTypeID          int IDENTITY,
       EventType            varchar(128) NOT NULL,
       StringID             int NULL,
       AccessLabelID        int NULL,
       IncidentTypeID       int NOT NULL,
       IncidentStateID      int NOT NULL,
       IncidentCloseAuto    tinyint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.EventTypes
       ADD PRIMARY KEY (EventTypeID)
go


CREATE TABLE dbo.ExportColumns (
       ExportColumnID       int IDENTITY,
       ExportID             int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       FieldName            varchar(64) NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL,
       MinSize              smallint NOT NULL,
       MaxSize              smallint NOT NULL,
       Align                smallint NOT NULL,
       Format               smallint NOT NULL,
       Padding              char(1) NULL,
       ExportValue          varchar(100) NULL,
       Include              smallint NOT NULL,
       TransType            int NOT NULL DEFAULT 511,
       IEAID                int NULL
)
go

CREATE INDEX i_ExportColumns_ExportID ON dbo.ExportColumns
(
       ExportID
)
go




ALTER TABLE dbo.ExportColumns
       ADD PRIMARY KEY (ExportColumnID)
go


CREATE TABLE dbo.Exports (
       ExportID             int NOT NULL,
       Description          varchar(64) NOT NULL,
       Separator            varchar(6) NULL,
       ImportKeySeparator   varchar(6) NULL,
       ImportKeyValueSeparator varchar(6) NULL,
       QuoteString          varchar(6) NULL,
       SQLString            varchar(255) NOT NULL,
       HeaderRow            smallint NOT NULL,
       ApproveString        varchar(100) NULL,
       AuthString           varchar(100) NULL,
       VoidString           varchar(100) NULL,
       CreditString         varchar(100) NULL,
       DeclineString        varchar(100) NULL,
       ApproveMatch         smallint NULL,
       AuthMatch            smallint NULL,
       VoidMatch            smallint NULL,
       CreditMatch          smallint NULL,
       DeclineMatch         smallint NULL,
       ExportType           smallint NOT NULL,
       Filter               varchar(16) NULL,
       Lines                smallint NOT NULL,
       Retries              int NULL,
       RetryDelay           int NULL,
       FormatDefault        int NULL DEFAULT 1,
       DefaultProcessorURL  varchar(128) NULL,
       Features             int NULL,
       Template             text NULL,
       StageCount           int NULL,
       FileTokenLocal       varchar(64) NULL
)
go

CREATE INDEX i_Exports_ExportType ON dbo.Exports
(
       ExportType
)
go



ALTER TABLE dbo.Exports
       ADD PRIMARY KEY (ExportID)
go


CREATE TABLE dbo.ExportTypes (
       ExportTypeID         smallint NOT NULL,
       ExportType           varchar(64) NOT NULL,
       IsBatch              tinyint NOT NULL DEFAULT 0,
       IsRealtime           tinyint NOT NULL DEFAULT 0,
       IsCC                 tinyint NOT NULL DEFAULT 0,
       IsExternal           tinyint NOT NULL DEFAULT 0,
       IsGeo                tinyint NOT NULL DEFAULT 0
)
go








ALTER TABLE dbo.ExportTypes
       ADD PRIMARY KEY (ExportTypeID)
go




CREATE TABLE dbo.ExternalSyncs (
       ExternalSyncID       int IDENTITY,
       ExternalSystemID     int NOT NULL,
       AccountID            int NULL,
       ProcTransID          varchar(64) NULL,
       Login                varchar(128) NULL,
       Password             varchar(200) NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       Aux4                 varchar(128) NULL,
       Aux5                 varchar(128) NULL,
       Aux6                 varchar(128) NULL,
       Aux7                 varchar(128) NULL,
       Aux8                 varchar(768) NULL,
       Active               tinyint NOT NULL DEFAULT 0,
       Created              tinyint NOT NULL DEFAULT 0,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastUpdate           datetime NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       ErrorCount           int NOT NULL DEFAULT 0,
       Message              varchar(128) NULL
)
go

CREATE INDEX I2_ES_AID_ESID ON dbo.ExternalSyncs
(
       AccountID,
       ExternalSystemID
)
go


ALTER TABLE dbo.ExternalSyncs
       ADD PRIMARY KEY (ExternalSyncID)
go


CREATE TABLE dbo.ExternalSystemAccountTypes (
       ExternalSystemID     int NOT NULL,
       AccountTypeID        int NOT NULL,
       Description          varchar(255) NULL,
       ExternalRef          varchar(64) NULL
)
go

ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD PRIMARY KEY (ExternalSystemID, AccountTypeID)
go

CREATE INDEX i_ExternalSystemAccountTypes_ATID ON dbo.ExternalSystemAccountTypes (AccountTypeID,ExternalSystemID,ExternalRef)
go


CREATE TABLE dbo.ExternalSystemDataTypes (
       ExternalSystemTypeID int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL
)
go



ALTER TABLE dbo.ExternalSystemDataTypes
       ADD PRIMARY KEY (ExternalSystemTypeID, AccountDataTypeID)
go


CREATE TABLE dbo.ExternalSystems (
       ExternalSystemID     int IDENTITY,
       ExternalSystem       varchar(64) NOT NULL,
       ExternalSystemTypeID int NOT NULL,
       ExportID             int NULL,
       Description          varchar(128) NULL,
       MailHost             varchar(64) NULL,
       Login                varchar(64) NULL,
       Password             varchar(200) NULL,
       LogFile              varchar(100) NULL,
       LastSyncDate         datetime NULL,
       FileMode             smallint NOT NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       PublicKey            varchar(4000) NULL,
       PrivateKey           varchar(4000) NULL
)
go


CREATE INDEX i_ExternalSystems_Name ON dbo.ExternalSystems
(
       ExternalSystem
)
go


ALTER TABLE dbo.ExternalSystems
       ADD PRIMARY KEY (ExternalSystemID)
go


CREATE TABLE dbo.ExternalSystemTypes (
       ExternalSystemTypeID int NOT NULL,
       ExternalSystemType   varchar(128) NOT NULL,
       ShowExportID         smallint NOT NULL DEFAULT 1,
       ShowMailHost         smallint NOT NULL DEFAULT 1,
       ShowLogin            smallint NOT NULL DEFAULT 1,
       ShowPassword         smallint NOT NULL DEFAULT 1,
       ShowURL              smallint NOT NULL DEFAULT 1,
       ShowKey              smallint NOT NULL DEFAULT 0,
       ExportID             int NULL,
       DescAux1             varchar(64) NULL,
       DescAux2             varchar(64) NULL,
       DescAux3             varchar(128) NULL
)
go



ALTER TABLE dbo.ExternalSystemTypes
       ADD PRIMARY KEY (ExternalSystemTypeID)
go


CREATE TABLE dbo.ExternalTrans (
       ExternalTransID      int IDENTITY(2000,1),
       BatchID              int NULL,
       BatchOutID           int NULL,
       BatchInID            int NULL,
       CustomerID           int NOT NULL,
       InvoiceID            int NULL,
       BatchProcessorID     int NOT NULL,
       TransStateID         tinyint NOT NULL DEFAULT 0,
       TransTypeID          smallint NOT NULL,
       ReqDate              datetime NOT NULL DEFAULT getdate(),
       ExportDate           datetime NULL,
       ProcDate             datetime NULL,
       Amount               numeric(18,4) NOT NULL,
       PaymentID            int NULL,
       ApproveCode          varchar(12) NULL,
       Response             varchar(256) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       AccountNumber        varchar(128) NULL,
       AccountExpire        datetime NULL,
       AuthName             varchar(64) NULL,
       AuthAddress          varchar(64) NULL,
       AuthStateID          int NULL,
       AuthZip              varchar(20) NULL,
       AuthSecurityCode     varchar(64) NULL,
       ProcTransID          varchar(64) NULL,
       BankName             varchar(64) NULL,
       BankNumber           varchar(128) NULL,
       BankPhone            varchar(20) NULL,
       BankTransType        varchar(16) NULL,
       RebatchTries         smallint NULL,
       LastRebatchTry       datetime NOT NULL,
       SSN                  varchar(128) NULL,
       DLNumber             varchar(128) NULL,
       DLState              varchar(40) NULL,
       BirthDate            datetime NULL,
       AutoBill             tinyint NOT NULL DEFAULT 0,
       Token                varchar(128) NULL
)
go

CREATE INDEX i_ET_CustomerID ON dbo.ExternalTrans
(
       CustomerID,
       TransStateID,
       AutoBill
)
go











CREATE INDEX i_ET_TransStateID ON dbo.ExternalTrans
(
       TransStateID,
       AutoBill
)
go




CREATE INDEX i_ET_PaymentID ON dbo.ExternalTrans
(
       PaymentID
)
go

CREATE INDEX i_ET_BatchProcessorID ON dbo.ExternalTrans
(
       BatchProcessorID,
       TransStateID,
       AutoBill
)
go







ALTER TABLE dbo.ExternalTrans
       ADD PRIMARY KEY (ExternalTransID)
go


CREATE TABLE dbo.FileApplyTypes (
       FileApplyTypeID      smallint NOT NULL,
       FileApplyType        varchar(128) NOT NULL,
       StringID             int NULL
)
go




ALTER TABLE dbo.FileApplyTypes
       ADD PRIMARY KEY (FileApplyTypeID)
go


CREATE TABLE dbo.FileCategories (
       FileCategoryID       int IDENTITY,
       FileCategory         varchar(128) NOT NULL,
       StringID             int NULL,
       AllowMBR             tinyint NOT NULL DEFAULT 1,
       AllowSA              tinyint NOT NULL DEFAULT 1,
       AllowIncidents       tinyint NOT NULL DEFAULT 1,
       AllowPayments        tinyint NOT NULL DEFAULT 1,
       AllowInvoices        tinyint NOT NULL DEFAULT 1,
       AllowStatements      tinyint NOT NULL DEFAULT 1,
       AllowAddresses       tinyint NOT NULL DEFAULT 1,
       AllowInvProducts     tinyint NOT NULL DEFAULT 1,
       DisplayDetail        tinyint NOT NULL DEFAULT 0,
       DisplaySummary       tinyint NOT NULL DEFAULT 0,
       InactiveExpireDaysMBR int NULL,
       InactiveExpireDaysSA int NULL,
       ActiveExpireDays     int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       AllowSites           tinyint NOT NULL DEFAULT 1,
       AllowTowers          tinyint NOT NULL DEFAULT 1,
       AllowEvents          tinyint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_FC_FileCategory ON dbo.FileCategories
(
       FileCategory
)
go

CREATE INDEX i_FileCategories_ALID ON dbo.FileCategories
(
       AccessLabelID
)
go


ALTER TABLE dbo.FileCategories
       ADD PRIMARY KEY (FileCategoryID)
go


CREATE TABLE dbo.FileCategoryMimeTypes (
       FileCategoryID       int NOT NULL,
       MimeTypeID           int NOT NULL
)
go



ALTER TABLE dbo.FileCategoryMimeTypes
       ADD PRIMARY KEY (FileCategoryID, MimeTypeID)
go


CREATE TABLE dbo.FileCategoryReqs (
       FileCategoryReqID    int IDENTITY,
       FileCategoryReq      varchar(128) NOT NULL,
       FileCategoryID       int NOT NULL,
       FileApplyTypeID      smallint NOT NULL,
       GroupID              int NULL,
       MarketTagID          int NULL,
       AccountTypeID        int NULL,
       ServiceCategoryID    int NULL,
       IncidentTypeID       int NULL
)
go









ALTER TABLE dbo.FileCategoryReqs
       ADD PRIMARY KEY (FileCategoryReqID)
go


CREATE TABLE dbo.Files (
       FileID               int IDENTITY,
       FileCategoryID       int NOT NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       IncidentID           int NULL,
       PaymentID            int NULL,
       InvoiceID            int NULL,
       StatementID          int NULL,
       AddressID            int NULL,
       InvProductID         int NULL,
       FileName             varchar(128) NULL,
       FileSize             int NOT NULL,
       FileMimeType         varchar(128) NOT NULL,
       FileData             image NOT NULL,
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       Comments             varchar(255) NULL,
       ExpireDate           datetime NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SiteID               int NULL,
       TowerID              int NULL,
       EventID              int NULL
)
go

CREATE INDEX i_Files_CustomerID ON dbo.Files
(
       CustomerID
)
go



CREATE INDEX i_Files_AccountID ON dbo.Files
(
       AccountID
)
go

CREATE INDEX i_Files_IncidentID ON dbo.Files
(
       IncidentID
)
go

CREATE INDEX i_Files_PaymentID ON dbo.Files
(
       PaymentID
)
go

CREATE INDEX i_Files_InvoiceID ON dbo.Files
(
       InvoiceID
)
go

CREATE INDEX i_Files_StatementID ON dbo.Files
(
       StatementID
)
go

CREATE INDEX i_Files_FileName ON dbo.Files
(
       FileName
)
go

CREATE INDEX i_Files_AddressID ON dbo.Files
(
       AddressID
)
go

CREATE INDEX i_Files_InvProducts ON dbo.Files
(
       InvProductID
)
go

CREATE INDEX i_Files_Sites ON dbo.Files
(
       SiteID
)
go

CREATE INDEX i_Files_Towers ON dbo.Files
(
       TowerID
)
go

CREATE INDEX i_Files_Events ON dbo.Files
(
       EventID
)
go


ALTER TABLE dbo.Files
       ADD PRIMARY KEY (FileID)
go


CREATE TABLE dbo.FlowDirections (
       FlowDirectionID    smallint NOT NULL,
       FlowDirection      varchar(128) NOT NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.FlowDirections
       ADD PRIMARY KEY (FlowDirectionID)
go

CREATE TABLE dbo.FlowFilters (
       FlowFilterID       int IDENTITY,
       FlowFilter         varchar(128) NOT NULL,
       DefaultAllow       tinyint NOT NULL DEFAULT 1,
       SortOrder          smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.FlowFilters
       ADD PRIMARY KEY (FlowFilterID)
go

CREATE TABLE dbo.FlowFilterItems (
       FlowFilterItemID   int IDENTITY,
       FlowFilterItem     varchar(128) NOT NULL,
       FlowFilterID       int NOT NULL,
       FlowDirectionID    smallint NOT NULL DEFAULT 1,
       Protocol           smallint NULL,
       SrcRange           varchar(128) NULL,
       SrcPortStarting    int NULL,
       SrcPortEnding      int NULL,
       DstRange           varchar(128) NULL,
       DstPortStarting    int NULL,
       DstPortEnding      int NULL,
       ExporterRange      varchar(128) NULL
)
go

ALTER TABLE dbo.FlowFilterItems
       ADD PRIMARY KEY (FlowFilterItemID)
go



CREATE TABLE dbo.Forwards (
       ForwardID            int IDENTITY,
       Forward              varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Forwards_AccountID ON dbo.Forwards
(
       AccountID
)
go


ALTER TABLE dbo.Forwards
       ADD PRIMARY KEY (ForwardID)
go


CREATE TABLE dbo.GaugeAlerts (
       GaugeAlertID         int IDENTITY,
       GaugeAlert           varchar(128) NOT NULL,
       StringID             int NULL,
       GaugeID              int NOT NULL,
       TriggerAbove         float NULL,
       TriggerBelow         float NULL,
       LookbackMins         int NOT NULL DEFAULT 1440,
       DwellSecs            int NOT NULL DEFAULT 1,
       Active               tinyint NOT NULL DEFAULT 1,
       Color                varchar(32) NOT NULL
)
go

CREATE INDEX i_GaugeAlerts_GaugeID ON dbo.GaugeAlerts
(
       GaugeID
)
go




CREATE INDEX Statistic_LookbackMins ON dbo.GaugeAlerts
(
       LookbackMins
)
go


ALTER TABLE dbo.GaugeAlerts
       ADD PRIMARY KEY (GaugeAlertID)
go


CREATE TABLE dbo.GaugeData (
       AccountID            int NOT NULL,
       StartDate            datetime NOT NULL,
       GaugeID              int NOT NULL,
       GaugeWindowID        tinyint NOT NULL,
       Data                 float NOT NULL DEFAULT 0
)
go

CREATE CLUSTERED INDEX i_GaugeData_AID_SD ON dbo.GaugeData
(
       AccountID,
       StartDate
)
go


CREATE TABLE dbo.GaugeCounterData (
       AccountID            int NOT NULL,
       GaugeID              int NOT NULL,
       Data                 float NOT NULL,
       LastUpdate           datetime NOT NULL
)
go

ALTER TABLE dbo.GaugeCounterData
       ADD PRIMARY KEY (AccountID, GaugeID)
go


CREATE TABLE dbo.GaugeConversions (
       GaugeConversionID    int NOT NULL,
       GaugeConversion      varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.GaugeConversions
       ADD PRIMARY KEY (GaugeConversionID)
go


CREATE TABLE dbo.GaugeGroups (
       GaugeGroupID         int IDENTITY,
       GaugeGroup           varchar(128) NOT NULL,
       StringID             int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.GaugeGroups
       ADD PRIMARY KEY (GaugeGroupID)
go


CREATE TABLE dbo.GaugeGroupItems (
       GaugeGroupID        int NOT NULL,
       GaugeID             int NOT NULL,
       GaugeGroupItemID    int IDENTITY,
       IsPrimary           tinyint NOT NULL DEFAULT 0,
       Required            tinyint NOT NULL DEFAULT 0,
       LineFill            tinyint NOT NULL DEFAULT 1,
       DataLabel           varchar(128) NULL,
       Color               varchar(32) NULL
)
go

CREATE UNIQUE CLUSTERED INDEX i_GaugeGroupItems_GGID_GID ON GaugeGroupItems
(
       GaugeGroupID,
       GaugeID
)
go

ALTER TABLE dbo.GaugeGroupItems
       ADD PRIMARY KEY NONCLUSTERED (GaugeGroupItemID)
go


CREATE TABLE dbo.GaugeRollups (
       GaugeRollupID        int IDENTITY,
       GaugeID              int NOT NULL,
       RollupDays           int NOT NULL,
       GaugeWindowID        tinyint NOT NULL,
       ExemptBelow          float NULL,
       ExemptAbove          float NULL
)
go





ALTER TABLE dbo.GaugeRollups
       ADD PRIMARY KEY (GaugeRollupID)
go


CREATE TABLE dbo.Gauges (
       GaugeID              int IDENTITY,
       Gauge                varchar(128) NOT NULL,
       StringID             int NULL,
       GaugeSourceID        int NOT NULL,
       GaugeWindowID        tinyint NOT NULL,
       ExternalRef          varchar(64) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       GaugeConversionID    int NULL,
       DataLabel            varchar(128) NULL,
       Color                varchar(32) NULL
)
go



ALTER TABLE dbo.Gauges
       ADD PRIMARY KEY (GaugeID)
go


CREATE TABLE dbo.GaugeSources (
       GaugeSourceID        int NOT NULL,
       GaugeSource          varchar(128) NOT NULL
)
go


ALTER TABLE dbo.GaugeSources
       ADD PRIMARY KEY (GaugeSourceID)
go


CREATE TABLE dbo.GaugeWindows (
       GaugeWindowID        tinyint NOT NULL,
       GaugeWindow          varchar(128) NOT NULL,
       Secs                 int NOT NULL
)
go




ALTER TABLE dbo.GaugeWindows
       ADD PRIMARY KEY (GaugeWindowID)
go


CREATE TABLE dbo.Geocoders (
       GeocoderID           int IDENTITY,
       Geocoder             varchar(128) NOT NULL,
       GroupID              int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       ExportID             int NOT NULL,
       ProcessorURL         varchar(255) NOT NULL,
       Login                varchar(64) NULL,
       Password             varchar(200) NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       Aux4                 varchar(128) NULL,
       Aux5                 varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               tinyint NOT NULL DEFAULT 1
)
go








ALTER TABLE dbo.Geocoders
       ADD PRIMARY KEY (GeocoderID)
go


CREATE TABLE dbo.GeoLayers (
       GeoLayerID           int IDENTITY,
       GeoLayer             varchar(128) NOT NULL,
       CreateDate           datetime NULL,
       Status               smallint NOT NULL DEFAULT 0,
       DescGeoShape         varchar(128) NULL,
       DescAux1             varchar(128) NULL,
       DescAux2             varchar(128) NULL,
       DescAux3             varchar(128) NULL,
       DescAux4             varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX i_GeoLayers_GeoLayer ON dbo.GeoLayers
(
       GeoLayer
)
go









ALTER TABLE dbo.GeoLayers
       ADD PRIMARY KEY (GeoLayerID)
go


CREATE TABLE dbo.GeoPolygons (
       GeoShapeID           int NOT NULL,
       Part                 smallint NOT NULL,
       Seq                  int NOT NULL,
       Lat                  float NOT NULL,
       Long                 float NOT NULL
)
go


ALTER TABLE dbo.GeoPolygons
       ADD PRIMARY KEY (GeoShapeID, Part, Seq)
go


CREATE TABLE dbo.GeoShapes (
       GeoShapeID           int IDENTITY,
       GeoShape             varchar(128) NOT NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       Aux4                 varchar(128) NULL,
       GeoLayerID           int NOT NULL,
       GeoSubLayerID        int NULL,
       MinLat               float NOT NULL,
       MinLong              float NOT NULL,
       MaxLat               float NOT NULL,
       MaxLong              float NOT NULL,
       Area                 float NOT NULL DEFAULT 0
)
go

CREATE CLUSTERED INDEX i_GeoShapes_Bounding ON dbo.GeoShapes
(
       GeoLayerID,
       MinLat,
       MinLong,
       MaxLat,
       MaxLong
)
go

CREATE INDEX Statistic_Aux2 ON dbo.GeoShapes
(
       Aux2
)
go

CREATE INDEX Statistic_Aux3 ON dbo.GeoShapes
(
       Aux3
)
go

CREATE INDEX Statistic_Aux4 ON dbo.GeoShapes
(
       Aux4
)
go

CREATE INDEX i_GeoShapes_GLID ON dbo.GeoShapes
(
       GeoLayerID,
       GeoSubLayerID
)
go







CREATE INDEX Statistic_Aux1 ON dbo.GeoShapes
(
       Aux1
)
go


ALTER TABLE dbo.GeoShapes
       ADD PRIMARY KEY NONCLUSTERED (GeoShapeID)
go


CREATE TABLE dbo.GeoSubLayers (
       GeoSubLayerID        int IDENTITY,
       GeoLayerID           int NOT NULL,
       GeoSubLayer          varchar(128) NOT NULL
)
go

CREATE INDEX i_GeoSubLayers_GSL ON dbo.GeoSubLayers
(
       GeoLayerID,
       GeoSubLayer
)
go



ALTER TABLE dbo.GeoSubLayers
       ADD PRIMARY KEY (GeoSubLayerID)
go


CREATE TABLE dbo.GLCodes (
       GLCodeID             int IDENTITY,
       GLCode               varchar(32) NOT NULL,
       Description          varchar(255) NULL,
       ExternalRef          varchar(64) NULL
)
go

CREATE UNIQUE INDEX i_GLCodes_GLCode ON dbo.GLCodes
(
       GLCode
)
go


ALTER TABLE dbo.GLCodes
       ADD PRIMARY KEY (GLCodeID)
go


CREATE TABLE dbo.Groups (
       GroupID              int IDENTITY,
       OrganizationID       int NOT NULL,
       DomainID             int NOT NULL,
       GroupName            varchar(32) NOT NULL,
       Description          varchar(45) NOT NULL,
       ReportLogoURL        varchar(128) NULL,
       InvoiceReport        varchar(45) NULL,
       InvoiceTextReport    varchar(45) NULL,
       InvoiceHTMLReport    varchar(45) NULL,
       StatementReport      varchar(45) NULL,
       StatementTextReport  varchar(45) NULL,
       StatementHTMLReport  varchar(45) NULL,
       ReceiptReport        varchar(45) NULL,
       GlobalAccountTypes   tinyint NOT NULL DEFAULT 1,
       GlobalBillingCycles  tinyint NOT NULL DEFAULT 1,
       GlobalRegions        tinyint NOT NULL DEFAULT 1,
       GlobalPayPeriods     tinyint NOT NULL DEFAULT 1,
       GlobalChargeTypes    tinyint NOT NULL DEFAULT 1,
       GlobalDomains        tinyint NOT NULL DEFAULT 1,
       GlobalSalesPersons   tinyint NOT NULL DEFAULT 1,
       GlobalSendMethods    tinyint NOT NULL DEFAULT 1,
       GlobalIncidentTypes  tinyint NOT NULL DEFAULT 1,
       BillName             varchar(50) NOT NULL,
       BillAddress1         varchar(80) NOT NULL,
       BillAddress2         varchar(80) NULL,
       BillCity             varchar(64) NOT NULL,
       BillState            varchar(50) NOT NULL,
       BillZip              varchar(32) NULL,
       BillCountryID        int NULL,
       BillPhone            varchar(32) NULL,
       BillFax              varchar(32) NULL,
       BillTaxID            varchar(64) NULL,
       ExternalRef          varchar(64) NULL,
       EmailAccounts        varchar(64) NOT NULL,
       EmailSubject         varchar(64) NOT NULL,
       AutoEmailInvoices    tinyint NOT NULL DEFAULT 0,
       AutoEmailStatements  tinyint NOT NULL DEFAULT 1,
       ThemeID              int NULL,
       ThemeScore           int NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       PaymentTypes         int NOT NULL DEFAULT 65535,
       PrintInvoices        smallint NULL,
       PrintStatements      smallint NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_Groups_DomainID ON dbo.Groups
(
       DomainID
)
go











CREATE INDEX I_Groups_OrganizationID ON dbo.Groups
(
       OrganizationID
)
go











CREATE INDEX i_Groups_GroupName ON dbo.Groups
(
       GroupName
)
go



















ALTER TABLE dbo.Groups
       ADD PRIMARY KEY (GroupID)
go


CREATE TABLE dbo.IEALocks (
       IEALockID            int NOT NULL,
       IEALock              varchar(128) NOT NULL,
       RefCount             int NOT NULL DEFAULT 0,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       IPAddress            varchar(64) NULL
)
go


ALTER TABLE dbo.IEALocks
       ADD PRIMARY KEY (IEALockID)
go


CREATE TABLE dbo.IMTypes (
       IMTypeID             int IDENTITY,
       IMType               varchar(128) NOT NULL,
       URI                  varchar(64) NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go






ALTER TABLE dbo.IMTypes
       ADD PRIMARY KEY (IMTypeID)
go


CREATE TABLE dbo.IncidentData (
       IncidentID           int NOT NULL,
       IncidentDataTypeID   int NOT NULL,
       Data                 varchar(255) NULL
)
go

CREATE INDEX IX_IncidentData ON dbo.IncidentData
(
       Data
)
go

CREATE INDEX x_IncidentData_IDTID ON dbo.IncidentData
(
       IncidentDataTypeID
)
go


ALTER TABLE dbo.IncidentData
       ADD PRIMARY KEY (IncidentID, IncidentDataTypeID)
go


CREATE TABLE dbo.IncidentDataTypes (
       IncidentDataTypeID   int IDENTITY,
       IncidentTypeID       int NOT NULL,
       IncidentDataType     varchar(128) NOT NULL,
       DataTypeID           smallint NOT NULL DEFAULT 0,
       Searchable           smallint NOT NULL DEFAULT 1,
       CustomerAccess       tinyint NOT NULL DEFAULT 1,
       Required             smallint NULL,
       RegExp               varchar(255) NULL,
       SQLQuery             text NULL,
       IncidentTemplateID   int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       AccessLabelID        int NULL
)
go







ALTER TABLE dbo.IncidentDataTypes
       ADD PRIMARY KEY (IncidentDataTypeID)
go


CREATE TABLE dbo.Incidents (
       IncidentID           int IDENTITY,
       CustomerID           int NOT NULL,
       AccountID            int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       IncidentTypeID       int NOT NULL,
       IncidentStateID      int NOT NULL,
       EventID              int NULL,
       CreateOperatorID     int NULL,
       CreateAccountID      int NULL,
       Summary              text NULL,
       Description          text NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Duration             int NOT NULL DEFAULT 0,
       Email                varchar(80) NULL,
       AssignRoleID         int NULL,
       AssignOperatorID     int NULL,
       DueDate              datetime NULL,
       PriorityID           smallint NOT NULL DEFAULT 0,
       SchedBlockID         int NULL,
       SchedDate            datetime NULL
)
go

CREATE INDEX i_Incidents_AccountID ON dbo.Incidents
(
       AccountID
)
go

CREATE INDEX i_Incidents_SBID ON dbo.Incidents
(
       SchedBlockID,
       SchedDate
)
go

CREATE INDEX i_Incidents_CustomerID ON dbo.Incidents
(
       CustomerID,
       AccountID
)
go

CREATE INDEX i_Incidents_Date ON dbo.Incidents
(
       CreateDate
)
go

CREATE INDEX i_Incidents_LMD ON dbo.Incidents
(
       LastModifyDate
)
go

CREATE INDEX i_Incidents_CID_CD ON dbo.Incidents
(
       CustomerID,
       CreateDate
)
go

CREATE INDEX i_Incidents_IncidentTypeID ON dbo.Incidents
(
       IncidentTypeID
)
go

CREATE INDEX i_Incidents_IncidentStateID ON dbo.Incidents
(
       IncidentStateID
)
go

CREATE INDEX i_Incidents_COID_ISID ON dbo.Incidents
(
       CreateOperatorID,
       IncidentStateID
)
go

CREATE INDEX i_Incidents_ARID_ISID ON dbo.Incidents
(
       AssignRoleID,
       IncidentStateID
)
go

CREATE INDEX i_Incidents_AOID_ISID ON dbo.Incidents
(
       AssignOperatorID,
       IncidentStateID
)
go

CREATE INDEX i_Incidents_DueDate ON dbo.Incidents
(
       DueDate
)
go

CREATE INDEX i_Incidents_EventID ON dbo.Incidents
(
       EventID
)
go

ALTER TABLE dbo.Incidents
       ADD PRIMARY KEY (IncidentID)
go


CREATE TABLE dbo.IncidentStateGroups (
       IncidentStateGroupID int IDENTITY,
       IncidentStateGroup   varchar(128) NOT NULL
)
go


ALTER TABLE dbo.IncidentStateGroups
       ADD PRIMARY KEY (IncidentStateGroupID)
go


CREATE TABLE dbo.IncidentStates (
       IncidentStateID      int IDENTITY,
       IncidentStateGroupID int NOT NULL,
       StatOpen             tinyint NOT NULL DEFAULT 0,
       StatWait             tinyint NOT NULL DEFAULT 0,
       StatEscalate         tinyint NOT NULL DEFAULT 0,
       StatBlock            tinyint NOT NULL DEFAULT 0,
       StatArchive          tinyint NOT NULL DEFAULT 0,
       IncidentState        varchar(64) NOT NULL,
       AccessLabelID        int NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 1,
       Description          varchar(255) NOT NULL,
       Style                varchar(255) NULL,
       Priority             smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_IncidentStates_ISG ON dbo.IncidentStates
(
       IncidentStateGroupID
)
go








ALTER TABLE dbo.IncidentStates
       ADD PRIMARY KEY (IncidentStateID)
go


CREATE TABLE dbo.IncidentTemplates (
       IncidentTemplateID   int NOT NULL,
       IncidentTemplate     varchar(128) NOT NULL,
       IncidentEdit         varchar(64) NULL,
       IncidentSave         varchar(64) NULL,
       CustIncidentEdit     varchar(64) NULL,
       CustIncidentSave     varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.IncidentTemplates
       ADD PRIMARY KEY (IncidentTemplateID)
go


CREATE TABLE dbo.IncidentTypes (
       IncidentTypeID       int IDENTITY,
       IncidentStateGroupID int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       IncidentType         varchar(128) NOT NULL,
       Description          varchar(1024) NOT NULL DEFAULT null,
       Email                varchar(80) NULL DEFAULT null,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       OverDays             smallint NULL,
       EscalateDays         smallint NULL,
       WarnDays             smallint NULL,
       OverMins             smallint NULL,
       EscalateMins         smallint NULL,
       WarnMins             smallint NULL,
       RoleID               int NULL,
       AccessLabelID        int NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       ShowPriority         tinyint NOT NULL DEFAULT 0,
       ShowEmail            tinyint NOT NULL DEFAULT 0,
       ShowDuration         tinyint NOT NULL DEFAULT 0,
       ShowDueDate          tinyint NOT NULL DEFAULT 0,
       ShowCustomerAccess   tinyint NOT NULL DEFAULT 0,
       ShowSummary          tinyint NOT NULL DEFAULT 0,
       ShowCustDueDate      tinyint NOT NULL DEFAULT 0,
       ShowAssignOperator   tinyint NOT NULL DEFAULT 1,
       EnableOperatorRole   smallint NOT NULL DEFAULT 0,
       SchedBlockTypeID     int NULL,
       SchedLimitDays       smallint NULL,
       SchedMinDays         smallint NULL,
       TimeUnits            int NULL
)
go

CREATE INDEX i_IncidentTypes_GroupID ON dbo.IncidentTypes
(
       GroupID
)
go

ALTER TABLE dbo.IncidentTypes
       ADD PRIMARY KEY (IncidentTypeID)
go


CREATE TABLE dbo.IncidentTypeFileCategories (
       IncidentTypeID       int NOT NULL,
       FileCategoryID       int NOT NULL
)
go

ALTER TABLE dbo.IncidentTypeFileCategories
       ADD PRIMARY KEY (IncidentTypeID, FileCategoryID)
go



CREATE TABLE dbo.IncidentValues (
       IncidentDataTypeID   int NOT NULL,
       NumValue             int NOT NULL,
       ValueName            varchar(128) NOT NULL
)
go



ALTER TABLE dbo.IncidentValues
       ADD PRIMARY KEY (IncidentDataTypeID, NumValue)
go


CREATE TABLE dbo.InfoBarOperatorGroups (
       InfoBarID            int NOT NULL,
       OperatorGroupID      int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_InfoBarOperatorGroups_OGID ON dbo.InfoBarOperatorGroups
(
       OperatorGroupID
)
go


ALTER TABLE dbo.InfoBarOperatorGroups
       ADD PRIMARY KEY (InfoBarID, OperatorGroupID)
go


CREATE TABLE dbo.InfoBarOperators (
       InfoBarID            int NOT NULL,
       OperatorID           int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_InfoBarOperators_OPID ON dbo.InfoBarOperators
(
       OperatorID
)
go


ALTER TABLE dbo.InfoBarOperators
       ADD PRIMARY KEY (InfoBarID, OperatorID)
go


CREATE TABLE dbo.InfoBars (
       InfoBarID            int NOT NULL,
       InfoBar              varchar(128) NOT NULL,
       StringID             int NULL,
       Class                varchar(64) NULL,
       Link                 varchar(64) NULL,
       Description          text NULL,
       AccessLabel          varchar(64) NULL,
       FeatureID            int NULL
)
go








ALTER TABLE dbo.InfoBars
       ADD PRIMARY KEY (InfoBarID)
go


CREATE TABLE dbo.InvAccountTypes (
       AccountTypeID        int NOT NULL,
       InvProductID         int NOT NULL,
       Required             tinyint NOT NULL DEFAULT 1,
       AutoAssign           tinyint NOT NULL DEFAULT 1
)
go




ALTER TABLE dbo.InvAccountTypes
       ADD PRIMARY KEY (AccountTypeID, InvProductID)
go

CREATE TABLE dbo.InvAttrMaps (
	InvAttrMapID	smallint NOT NULL,
	InvAttrMap 	varchar(128) NOT NULL,
	RegExp		varchar(1024) NULL,
        SortOrder       smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.InvAttrMaps
       ADD PRIMARY KEY (InvAttrMapID)
go

CREATE TABLE dbo.InvAttributes (
       InvAttributeID       int IDENTITY,
       InvAttribute         varchar(128) NOT NULL,
       Description          text NULL,
       InvLevelTypeID       int NOT NULL,
       InvAttrMapID         smallint NULL,
       IEAID                int NULL,
       ServiceAccess        tinyint NOT NULL DEFAULT 0,
       ShowSearchResult     tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvAttributes_Attribute ON dbo.InvAttributes
(
       InvAttribute
)
go

CREATE INDEX i_InvAttributes_ILTID ON dbo.InvAttributes
(
       InvLevelTypeID
)
go

CREATE INDEX i_InvAttributes_IAMID ON dbo.InvAttributes
(
       InvAttrMapID
)
go



ALTER TABLE dbo.InvAttributes
       ADD PRIMARY KEY (InvAttributeID)
go

CREATE TABLE dbo.InvCarts (
	InvCartID	int IDENTITY,
	OperatorID	int NOT NULL,
	InvCart 	varchar(128) NULL,
	CreateDate	datetime NOT NULL DEFAULT getdate(),
	LastModifyDate	datetime NOT NULL DEFAULT getdate(),
	Comments	text NULL
)
go

ALTER TABLE dbo.InvCarts
       ADD PRIMARY KEY (InvCartID)
go

CREATE INDEX i_InvCarts_OperatorID ON dbo.InvCarts
(
	OperatorID
)
go


CREATE TABLE dbo.InvCartItems (
	InvCartID	int NOT NULL,
	InvItemID	int NOT NULL,
	CreateInvStateID	int NULL,
	CreateInvWarehouseID	int NULL
)
go

ALTER TABLE dbo.InvCartItems
       ADD PRIMARY KEY (InvCartID,InvItemID)
go

CREATE INDEX i_InvCartItems_InvItemID ON dbo.InvCartItems
(
	InvItemID
)
go


CREATE TABLE dbo.InvCategories (
       InvCategoryID        int IDENTITY,
       InvCategory          varchar(128) NOT NULL,
       StringID             int NULL,
       Description          text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvCategories_IC ON dbo.InvCategories
(
       InvCategory
)
go


ALTER TABLE dbo.InvCategories
       ADD PRIMARY KEY (InvCategoryID)
go


CREATE TABLE dbo.InvItemData (
       InvItemID            int NOT NULL,
       InvAttributeID       int NOT NULL,
       InvValueID           int NULL,
       Data                 varchar(2048) NULL
)
go




ALTER TABLE dbo.InvItemData
       ADD PRIMARY KEY (InvItemID, InvAttributeID)
go


CREATE TABLE dbo.InvItemLogs (
       InvItemLogID         int IDENTITY,
       InvItemID            int NOT NULL,
       InvStateID           int NOT NULL,
       InvWarehouseID       int NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       ItemID               int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_InvItemLogs_ItemID ON dbo.InvItemLogs
(
       InvItemID
)
go







ALTER TABLE dbo.InvItemLogs
       ADD PRIMARY KEY (InvItemLogID)
go


CREATE TABLE dbo.InvItems (
       InvItemID            int IDENTITY,
       InvProductID         int NOT NULL,
       InvStateID           int NOT NULL,
       InvWarehouseID       int NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       ItemID               int NULL,
       SerialNumber         varchar(80) NULL,
       Cost                 numeric(18,4) NULL,
       RecvDate             datetime NULL,
       ShipDate             datetime NULL,
       ReturnDate           datetime NULL,
       AssignDate           datetime NULL,
       AssignUser           varchar(64) NULL,
       TrackNumber          varchar(80) NULL,
       Comments             text NULL,
       ExternalRef          varchar(64) NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       IPGroupID            int NULL,
       IPRangeID            int NULL,
       SupplierCost         numeric(18,4) NULL
)
go

CREATE INDEX i_InvItems_SerialNo ON dbo.InvItems
(
       SerialNumber
)
go

CREATE INDEX i_InvItems_CID ON dbo.InvItems
(
       CustomerID
)
go

CREATE INDEX i_InvItems_AID ON dbo.InvItems
(
       AccountID,
       InvStateID
)
go

CREATE INDEX i_InvItems_PID_State ON dbo.InvItems
(
       InvProductID,
       InvStateID
)
go

CREATE INDEX i_InvItems_AID_PID ON dbo.InvItems
(
       AccountID,
       InvProductID
)
go

ALTER TABLE dbo.InvItems
       ADD PRIMARY KEY (InvItemID)
go


CREATE TABLE dbo.InvLevelAttributes (
       InvLevelAttributeID  int IDENTITY,
       InvAttributeID       int NOT NULL,
       InvCategoryID        int NULL,
       InvSubCategoryID     int NULL,
       InvProductID         int NULL,
       InvSourceID          int NULL,
       Required             tinyint NOT NULL DEFAULT 0,
       AllowBulk            tinyint NOT NULL DEFAULT 1,
       RegExp               varchar(255) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       DefaultData          varchar(255) NULL,
       DefaultInvValueID    int NULL
)
go

CREATE INDEX i_InvLevelAttributes_SID ON dbo.InvLevelAttributes
(
       InvSourceID
)
go

CREATE INDEX i_InvLevelAttributes_CPSC ON dbo.InvLevelAttributes
(
       InvCategoryID,
       InvProductID,
       InvSubCategoryID
)
go








ALTER TABLE dbo.InvLevelAttributes
       ADD PRIMARY KEY (InvLevelAttributeID)
go


CREATE TABLE dbo.InvLevelTypes (
       InvLevelTypeID       int NOT NULL,
       InvLevelType         varchar(128) NOT NULL
)
go



ALTER TABLE dbo.InvLevelTypes
       ADD PRIMARY KEY (InvLevelTypeID)
go


CREATE TABLE dbo.InvoiceItemDiscounts (
       ItemID               int NOT NULL,
       DiscountID           int NOT NULL,
       Amount               numeric(18,4) NOT NULL
)
go



ALTER TABLE dbo.InvoiceItemDiscounts
       ADD PRIMARY KEY (ItemID, DiscountID)
go


CREATE TABLE dbo.InvoiceItems (
       ItemID               int IDENTITY,
       InvoiceID            int NOT NULL,
       ItemType             smallint NOT NULL DEFAULT 1,
       Description          varchar(200) NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       BaseAmount           numeric(18,4) NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       Days                 smallint NOT NULL DEFAULT 0,
       PaidAmount           numeric(18,4) NOT NULL DEFAULT 0,
       TaxID                int NULL,
       TaxGroupID           int NULL,
       Login                varchar(64) NULL,
       AccountID            int NULL,
       AccountTypeID        int NULL,
       ChargeID             int NULL,
       ChargeTypeID         int NULL,
       InvItemID            int NULL,
       PaidFlag             tinyint NOT NULL DEFAULT 0,
       LateCharge           tinyint NOT NULL DEFAULT 0,
       TaxableAmount        numeric(18,4) NULL,
       ServiceQty           smallint NOT NULL DEFAULT 1
)
go

CREATE CLUSTERED INDEX i_InvoiceItems_InvoiceID_ItemID ON dbo.InvoiceItems
(
       InvoiceID,
       ItemID
)
go







CREATE INDEX i_InvoiceItems_AID_IID ON dbo.InvoiceItems
(
       AccountID,
       InvoiceID
)
go









ALTER TABLE dbo.InvoiceItems
       ADD PRIMARY KEY NONCLUSTERED (ItemID)
go


CREATE TABLE dbo.InvoiceItemTypes (
       InvoiceItemTypeID    smallint NOT NULL,
       InvoiceItemType      varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.InvoiceItemTypes
       ADD PRIMARY KEY (InvoiceItemTypeID)
go


CREATE TABLE dbo.Invoices (
       InvoiceID            int IDENTITY,
       BatchID              int NULL,
       CustomerID           int NOT NULL,
       InvoiceTypeID        tinyint NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       ChargeAmount         numeric(18,4) NOT NULL DEFAULT 0,
       PaidAmount           numeric(18,4) NOT NULL DEFAULT 0,
       PayPlanID            int NULL,
       PayPlanStartDate     datetime NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Tax                  numeric(18,4) NOT NULL DEFAULT 0,
       StatementID          int NULL,
       VoidDate             datetime NULL,
       VoidStatementID      int NULL,
       PO                   varchar(25) NULL,
       Comments             varchar(100) NULL,
       PrintDate            datetime NULL,
       EmailDate            datetime NULL,
       PrintBatchID         int NULL,
       Estimate             tinyint NOT NULL DEFAULT 0,
       Processed            tinyint NOT NULL DEFAULT 1,
       ExtInvoiceNum        varchar(20) NULL
)
go

CREATE INDEX iCustomerID ON dbo.Invoices
(
       CustomerID,
       InvoiceTypeID
)
go

CREATE INDEX i_Invoices_PrintBatchID ON dbo.Invoices
(
       PrintBatchID
)
go

CREATE INDEX i_Invoices_VoidStatementID ON dbo.Invoices
(
       VoidStatementID
)
go

CREATE INDEX i_Invoices_StatementID ON dbo.Invoices
(
       StatementID
)
go

CREATE INDEX i_Invoices_ExtInvoiceNum ON dbo.Invoices
(
       ExtInvoiceNum
)
go

CREATE INDEX i_Invoices_CreateDate ON dbo.Invoices
(
       CreateDate
)
go




ALTER TABLE dbo.Invoices
       ADD PRIMARY KEY (InvoiceID)
go



CREATE TABLE dbo.InvoiceGaps (
       InvoiceID            int NOT NULL,
       Locked               tinyint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.InvoiceGaps
       ADD PRIMARY KEY (InvoiceID)
go



CREATE TABLE dbo.InvoiceSubAccounts (
       InvoiceID            int NOT NULL,
       AccountID            int NOT NULL,
       BilledThru           datetime NOT NULL,
       InvoicedDays         int NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.InvoiceSubAccounts
       ADD PRIMARY KEY (InvoiceID, AccountID)
go


CREATE TABLE dbo.InvoiceTags (
       InvoiceID            int NOT NULL,
       AccountID            int NOT NULL,
       MarketTagID          int NOT NULL,
       InvoicedDays         int NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.InvoiceTags
       ADD PRIMARY KEY (InvoiceID, AccountID, MarketTagID)
go


CREATE TABLE dbo.InvoiceTypes (
       InvoiceTypeID        tinyint NOT NULL,
       InvoiceType          varchar(128) NOT NULL,
       StringID             int NULL
)
go




ALTER TABLE dbo.InvoiceTypes
       ADD PRIMARY KEY (InvoiceTypeID)
go


CREATE TABLE dbo.InvProductData (
       InvProductID         int NOT NULL,
       InvAttributeID       int NOT NULL,
       InvValueID           int NULL,
       Data                 varchar(2048) NULL
)
go




ALTER TABLE dbo.InvProductData
       ADD PRIMARY KEY (InvProductID, InvAttributeID)
go


CREATE TABLE dbo.InvProducts (
       InvProductID         int IDENTITY,
       InvCategoryID        int NOT NULL,
       InvSubCategoryID     int NULL,
       InvSourceID          int NOT NULL,
       GroupID              int NULL,
       AccessLabelID        int NULL,
       Title                varchar(255) NOT NULL,
       Description          text NULL,
       OrderInfo            text NULL,
       ChargeTypeID         int NULL,
       Cost                 numeric(18,4) NULL,
       L                    float NULL,
       W                    float NULL,
       H                    float NULL,
       Weight               float NULL,
       SKU                  varchar(64) NULL,
       ModelNumber          varchar(64) NULL,
       SupplierSKU          varchar(64) NULL,
       EAN                  varchar(64) NULL,
       SerialNumberRegExp   varchar(128) NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL DEFAULT suser_name(),
       ExternalRef          varchar(64) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       SupplierCost         numeric(18,4) NULL,
       CloseInvStateID      int NULL
)
go

CREATE INDEX i_InvProducts_Cats ON dbo.InvProducts
(
       InvCategoryID,
       InvSubCategoryID
)
go



CREATE INDEX i_InvProducts_Title ON dbo.InvProducts
(
       Title
)
go

CREATE INDEX i_InvProducts_ModelNumber ON dbo.InvProducts
(
       ModelNumber
)
go

CREATE INDEX i_InvProducts_SKU ON dbo.InvProducts
(
       SKU
)
go







ALTER TABLE dbo.InvProducts
       ADD PRIMARY KEY (InvProductID)
go


CREATE TABLE dbo.InvReserveTypes (
       InvReserveTypeID     int NOT NULL,
       InvReserveType       varchar(128) NOT NULL
)
go


ALTER TABLE dbo.InvReserveTypes
       ADD PRIMARY KEY (InvReserveTypeID)
go


CREATE TABLE dbo.InvSources (
       InvSourceID          int IDENTITY,
       InvSource            varchar(128) NOT NULL,
       InvSourceTypeID      int NOT NULL,
       InvStateGroupID      int NOT NULL
)
go

CREATE INDEX i_InvSources_ISTID ON dbo.InvSources
(
       InvSourceTypeID
)
go

CREATE INDEX i_InvSources_Source ON dbo.InvSources
(
       InvSource
)
go



ALTER TABLE dbo.InvSources
       ADD PRIMARY KEY (InvSourceID)
go


CREATE TABLE dbo.InvSourceTypes (
       InvSourceTypeID      int NOT NULL,
       InvSourceType        varchar(128) NOT NULL,
       Assignable           tinyint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.InvSourceTypes
       ADD PRIMARY KEY (InvSourceTypeID)
go


CREATE TABLE dbo.InvStateGroups (
       InvStateGroupID      int IDENTITY,
       InvStateGroup        varchar(128) NOT NULL,
       POSInvStateID        int NULL,
       AssignInvStateID     int NULL
)
go


ALTER TABLE dbo.InvStateGroups
       ADD PRIMARY KEY (InvStateGroupID)
go


CREATE TABLE dbo.InvStates (
       InvStateID           int IDENTITY,
       InvState             varchar(128) NOT NULL,
       StringID             int NULL,
       InvStateGroupID      int NOT NULL,
       InvStateTypeID       int NOT NULL,
       InvReserveTypeID     int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvStates_State ON dbo.InvStates
(
       InvState
)
go

CREATE INDEX i_InvStates_SGID_SO ON dbo.InvStates
(
       InvStateGroupID,
       SortOrder
)
go






ALTER TABLE dbo.InvStates
       ADD PRIMARY KEY (InvStateID)
go


CREATE TABLE dbo.InvStateTypes (
       InvStateTypeID       int NOT NULL,
       InvStateType         varchar(128) NOT NULL,
       StringID             int NULL,
       Class                varchar(64) NULL
)
go





ALTER TABLE dbo.InvStateTypes
       ADD PRIMARY KEY (InvStateTypeID)
go


CREATE TABLE dbo.InvSubCategories (
       InvSubCategoryID     int IDENTITY,
       InvCategoryID        int NOT NULL,
       InvSubCategory       varchar(128) NOT NULL,
       StringID             int NULL,
       Description          text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvSubCategories_ISC ON dbo.InvSubCategories
(
       InvSubCategory
)
go



ALTER TABLE dbo.InvSubCategories
       ADD PRIMARY KEY (InvSubCategoryID)
go


CREATE TABLE dbo.InvValues (
       InvValueID           int IDENTITY,
       InvAttributeID       int NOT NULL,
       Data                 varchar(128) NOT NULL,
       RadData              varchar(255) NULL,
       ExternalRef          varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvValues_AID ON dbo.InvValues
(
       InvAttributeID
)
go



ALTER TABLE dbo.InvValues
       ADD PRIMARY KEY (InvValueID)
go


CREATE TABLE dbo.InvWarehouseProducts (
       InvProductID         int NOT NULL,
       InvWarehouseID       int NOT NULL,
       ReorderQty           int NULL,
       TargetQty            int NULL,
       Location             varchar(1024) NULL,
       Comments             text NULL
)
go



ALTER TABLE dbo.InvWarehouseProducts
       ADD PRIMARY KEY (InvProductID, InvWarehouseID)
go


CREATE TABLE dbo.InvWarehouses (
       InvWarehouseID       int IDENTITY,
       InvWarehouse         varchar(128) NOT NULL,
       SiteID               int NULL,
       Description          text NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_InvWarehouses_Warehouse ON dbo.InvWarehouses
(
       InvWarehouse
)
go



ALTER TABLE dbo.InvWarehouses
       ADD PRIMARY KEY (InvWarehouseID)
go


CREATE TABLE dbo.InvWarehouseGroups (
	InvWarehouseGroupID	int IDENTITY,
	InvWarehouseGroup	varchar (128) NOT NULL,
	Description		text NULL,
	PrimaryInvWarehouseID	int NULL,
	Active			tinyint	NOT NULL DEFAULT 1,
	SortOrder		smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.InvWarehouseGroups
       ADD PRIMARY KEY (InvWarehouseGroupID)
go

CREATE INDEX i_IWG_PrimaryInvWarehouseID ON dbo.InvWarehouseGroups
(
	PrimaryInvWarehouseID
)
go


CREATE TABLE dbo.InvWarehouseGroupItems (
	InvWarehouseGroupID	int NOT NULL,
	InvWarehouseID		int NOT NULL 
)
go

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD PRIMARY KEY (InvWarehouseGroupID, InvWarehouseID)
go

CREATE INDEX i_IWGI_InvWarehouseID ON dbo.InvWarehouseGroupItems
(
	InvWarehouseID
)
go

CREATE TABLE dbo.IPAddressTypes (
	IPAddressTypeID smallint NOT NULL,
	IPAddressType varchar(128) NOT NULL 
)
go

ALTER TABLE dbo.IPAddressTypes
       ADD PRIMARY KEY (IPAddressTypeID)
go


CREATE TABLE dbo.IPAttributeTypes (
	IPAttributeTypeID int IDENTITY,
	IPAttributeType varchar(128) NOT NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.IPAttributeTypes
       ADD PRIMARY KEY (IPAttributeTypeID)
go


CREATE TABLE dbo.IPAttributes (
	IPAttributeID int IDENTITY,
	IPAttributeTypeID int NOT NULL,
	IPAttribute varchar(128) NOT NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.IPAttributes
       ADD PRIMARY KEY (IPAttributeID)
go


CREATE TABLE dbo.IPGroups (
	IPGroupID int IDENTITY,
	IPGroup varchar(128) NOT NULL,
	IPAddressTypeID smallint NOT NULL,
	Active tinyint NOT NULL DEFAULT 1,
	SortOrder smallint NOT NULL DEFAULT 0,
	RefCount int NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.IPGroups
       ADD PRIMARY KEY (IPGroupID)
go


CREATE TABLE dbo.IPInvAllocReqs (
	IPInvAllocReqID int IDENTITY,
	IPInvAllocationID int NOT NULL,
	IPRangeID int NULL,
	IPAttributeID int NULL 
)
go

CREATE UNIQUE INDEX uc_IPInvAllocReqs_ALID_RID_AID ON dbo.IPInvAllocReqs
(
	IPInvAllocationID,
	IPRangeID,
	IPAttributeID
)
go

ALTER TABLE dbo.IPInvAllocReqs
       ADD PRIMARY KEY (IPInvAllocReqID)
go


CREATE TABLE dbo.IPInvAllocations (
	IPInvAllocationID int IDENTITY,
	IPInvAllocation varchar(128) NOT NULL,
	IPGroupID int NOT NULL,
	InvProductID int NOT NULL,
	InvStateID int NOT NULL,
	PrefixLength smallint NOT NULL,
	TargetQty int NOT NULL,
	Active tinyint NOT NULL DEFAULT 1,
	StatAvailPrefixCount int NULL 
)
go

CREATE UNIQUE INDEX uc_IPInvAllocations_IPGID_IPID ON dbo.IPInvAllocations
(
	IPGroupID,
	InvProductID
)
go

CREATE INDEX i_IPInvAllocations_IPGID ON dbo.IPInvAllocations
(
	IPGroupID
)
go

ALTER TABLE dbo.IPInvAllocations
       ADD PRIMARY KEY (IPInvAllocationID)
go


CREATE TABLE dbo.IPMessages (
	IPGroupID int NOT NULL,
	IPRangeID int NULL,
	InvItemID int NULL,
	IPInvAllocationID int NULL,
	Message varchar(512) NOT NULL 
)
go

CREATE CLUSTERED INDEX i_IPMessages_IPGroupID ON dbo.IPMessages
(
	IPGroupID
)
go

CREATE INDEX i_IPMessages_IPRangeID ON dbo.IPMessages
(
	IPRangeID
)
go

CREATE INDEX i_IPMessages_IPInvAllocationID ON dbo.IPMessages
(
	IPInvAllocationID
)
go

CREATE INDEX i_IPMessages_InvItemID ON dbo.IPMessages
(
	InvItemID
)
go


CREATE TABLE dbo.IPRangeAttributes (
	IPRangeID int NOT NULL,
	IPAttributeID int NOT NULL 
)
go

CREATE INDEX i_IPRangeAttributes_IPAID ON dbo.IPRangeAttributes
(
	IPAttributeID
)
go

ALTER TABLE dbo.IPRangeAttributes
       ADD PRIMARY KEY (IPRangeID,IPAttributeID)
go


CREATE TABLE dbo.IPRangeTypes (
	IPRangeTypeID smallint NOT NULL,
	IPRangeType varchar(128) NOT NULL 
)
go

ALTER TABLE dbo.IPRangeTypes
       ADD PRIMARY KEY (IPRangeTypeID)
go


CREATE TABLE dbo.IPRanges (
	IPRangeID int IDENTITY,
	IPGroupID int NOT NULL,
	IPRangeTypeID smallint NOT NULL,
	IPRange varchar(128) NOT NULL,
	PriorityID smallint NOT NULL,
	StatAvailable numeric(7,4) NULL,
	StatMinPrefixLength smallint NULL,
	StatOrder int NOT NULL DEFAULT 0,
	StatParentIPRangeID int NULL,
	Description varchar(255) NULL,
	Comments text NULL 
)
go

CREATE INDEX i_IPRanges_IPGroupID ON dbo.IPRanges
(
	IPGroupID
)
go

CREATE UNIQUE INDEX uc_IPRanges_IPGID_IPRange ON dbo.IPRanges
(
	IPGroupID,
	IPRange
)
go

ALTER TABLE dbo.IPRanges
       ADD PRIMARY KEY (IPRangeID)
go


CREATE TABLE dbo.Languages (
       LanguageID           int NOT NULL,
       Description          varchar(64) NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1,
       HttpAcceptLanguage   varchar(64) NULL,
       AllowIEAUpdate       tinyint NOT NULL DEFAULT 1
)
go



ALTER TABLE dbo.Languages
       ADD PRIMARY KEY (LanguageID)
go


CREATE TABLE dbo.LateFeeChargeTypes (
       LateFeeID            int NOT NULL,
       ChargeTypeID         int NOT NULL
)
go



ALTER TABLE dbo.LateFeeChargeTypes
       ADD PRIMARY KEY (LateFeeID, ChargeTypeID)
go


CREATE TABLE dbo.LateFeeDays (
       LateFeeDayID         int IDENTITY,
       LateFeeID            int NOT NULL,
       OverDays             smallint NOT NULL,
       OverAmount           numeric(18,4) NOT NULL DEFAULT 0,
       Amount               numeric(18,4) NOT NULL
)
go

CREATE UNIQUE INDEX uc_LateFeeDays_ID_Over ON dbo.LateFeeDays
(
       LateFeeID,
       OverDays,
       OverAmount
)
go


ALTER TABLE dbo.LateFeeDays
       ADD PRIMARY KEY (LateFeeDayID)
go


CREATE TABLE dbo.LateFees (
       LateFeeID            int IDENTITY,
       LateFeeTypeID        smallint NOT NULL,
       LateFee              varchar(128) NOT NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       MarketTagID          int NULL,
       ChargeTypeID         int NOT NULL,
       PriorityID           smallint NOT NULL DEFAULT 0,
       GraceDays            smallint NOT NULL DEFAULT 0,
       MaxDays              smallint NULL,
       MinAmount            numeric(18,4) NULL,
       MaxAmount            numeric(18,4) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               tinyint NOT NULL DEFAULT 1
)
go








ALTER TABLE dbo.LateFees
       ADD PRIMARY KEY (LateFeeID)
go


CREATE TABLE dbo.LateFeeServiceCats (
       LateFeeID            int NOT NULL,
       ServiceCategoryID    int NOT NULL
)
go


ALTER TABLE dbo.LateFeeServiceCats
       ADD PRIMARY KEY (LateFeeID, ServiceCategoryID)
go


CREATE TABLE dbo.LateFeeTypes (
       LateFeeTypeID        smallint NOT NULL,
       LateFeeType          varchar(128) NOT NULL
)
go


ALTER TABLE dbo.LateFeeTypes
       ADD PRIMARY KEY (LateFeeTypeID)
go


CREATE TABLE dbo.LDAPServers (
       LDAPServer           varchar(50) NOT NULL,
       LastModifyDate       datetime NOT NULL,
       LastSyncRead         datetime NOT NULL,
       LastSyncWrite        datetime NOT NULL,
       Calls                int NULL
)
go


ALTER TABLE dbo.LDAPServers
       ADD PRIMARY KEY (LDAPServer)
go


CREATE TABLE dbo.Licenses (
       LicenseID            varchar(50) NOT NULL,
       Company              varchar(80) NOT NULL
)
go


ALTER TABLE dbo.Licenses
       ADD PRIMARY KEY (LicenseID)
go


CREATE TABLE dbo.LocPhones (
       Prefix               varchar(12) NOT NULL,
       StateID              int NOT NULL,
       City                 varchar(64) NOT NULL,
       Lat                  float NULL,
       Long                 float NULL,
       Telco                varchar(64) NULL
)
go



ALTER TABLE dbo.LocPhones
       ADD PRIMARY KEY (Prefix, StateID)
go


CREATE TABLE dbo.LocZipCodes (
       ZipCode              varchar(15) NOT NULL,
       StateID              int NOT NULL,
       City                 varchar(64) NOT NULL,
       County               varchar(64) NULL,
       Lat                  float NULL,
       Long                 float NULL
)
go



ALTER TABLE dbo.LocZipCodes
       ADD PRIMARY KEY (ZipCode, StateID)
go


CREATE TABLE dbo.LogMsgs (
       LogMsgID             smallint NOT NULL,
       LogMsg               varchar(128) NOT NULL DEFAULT 'Undefined',
       StringID             int NULL,
       Severity             int NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.LogMsgs
       ADD PRIMARY KEY (LogMsgID)
go


CREATE TABLE dbo.MarketCategories (
       MarketCategoryID     int IDENTITY,
       MarketCategory       varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.MarketCategories
       ADD PRIMARY KEY (MarketCategoryID)
go


CREATE TABLE dbo.MarketServiceCountTypes (
       MarketServiceCountTypeID int NOT NULL,
       MarketServiceCountType varchar(128) NOT NULL,
       Description          text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.MarketServiceCountTypes
       ADD PRIMARY KEY (MarketServiceCountTypeID)
go


CREATE TABLE dbo.MarketTagAttributes (
       MarketTagAttributeID int IDENTITY,
       MarketTagID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadMergeTypeID       smallint NOT NULL DEFAULT 3,
       Tag                  tinyint NULL,
       Data                 varchar(4000) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Parent               tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_MarketTagAttributes_MTID ON dbo.MarketTagAttributes
(
       MarketTagID
)
go





ALTER TABLE dbo.MarketTagAttributes
       ADD PRIMARY KEY (MarketTagAttributeID)
go


CREATE TABLE dbo.MarketTagAutoTypes (
       MarketTagAutoTypeID  int NOT NULL,
       MarketTagAutoType    varchar(128) NOT NULL,
       TagLevel             varchar(16) NULL,
       AssignType           varchar(32) NULL,
       AssignStringID       int NULL,
       Description          text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.MarketTagAutoTypes
       ADD PRIMARY KEY (MarketTagAutoTypeID)
go


CREATE TABLE dbo.MarketTagCancelTypes (
       MarketTagCancelTypeID int NOT NULL,
       MarketTagCancelType  varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.MarketTagCancelTypes
       ADD PRIMARY KEY (MarketTagCancelTypeID)
go


CREATE TABLE dbo.MarketTagConditions (
       MarketTagConditionID int IDENTITY,
       MarketTagCondition   varchar(128) NULL,
       MarketTagCondTypeID  int NOT NULL,
       SrcMarketTagID       int NOT NULL,
       DstMarketTagID       int NULL,
       DstMarketTagGroupID  int NULL
)
go

CREATE UNIQUE INDEX i_MarketTagConditions_SrcDst ON dbo.MarketTagConditions
(
       SrcMarketTagID,
       DstMarketTagID,
       DstMarketTagGroupID
)
go





ALTER TABLE dbo.MarketTagConditions
       ADD PRIMARY KEY (MarketTagConditionID)
go


CREATE TABLE dbo.MarketTagCondTypes (
       MarketTagCondTypeID  int NOT NULL,
       MarketTagCondType    varchar(128) NOT NULL,
       IsGroup              tinyint NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go





ALTER TABLE dbo.MarketTagCondTypes
       ADD PRIMARY KEY (MarketTagCondTypeID)
go


CREATE TABLE dbo.MarketTagGroupItems (
       MarketTagGroupID     int NOT NULL,
       MarketTagID          int NOT NULL
)
go



ALTER TABLE dbo.MarketTagGroupItems
       ADD PRIMARY KEY (MarketTagGroupID, MarketTagID)
go


CREATE TABLE dbo.MarketTagGroups (
       MarketTagGroupID     int IDENTITY,
       MarketTagGroup       varchar(128) NOT NULL
)
go


ALTER TABLE dbo.MarketTagGroups
       ADD PRIMARY KEY (MarketTagGroupID)
go


CREATE TABLE dbo.MarketTags (
       MarketTagID          int IDENTITY,
       MarketTag            varchar(128) NOT NULL,
       StringID             int NULL,
       MarketCategoryID     int NOT NULL,
       MarketTagAutoTypeID  int NOT NULL,
       CancelPeriodMonthsMin smallint NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       RegionID             int NULL,
       PaymentTypeID        int NULL,
       SendMethodID         int NULL,
       BillingCycleID       int NULL,
       AddressCategoryID    int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       City                 varchar(64) NULL,
       Zip                  varchar(20) NULL,
       AddressDataTypeID    int NULL,
       AddressData          varchar(512) NULL,
       AccountTypeID        int NULL,
       ServiceCategoryID    int NULL,
       ParentServiceCategoryID int NULL,
       PromoCodeID          int NULL,
       ChargeTypeID         int NULL,
       PayPeriodID          int NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       AccessTime           varchar(128) NULL,
       InvoicedDaysMax      int NULL,
       ServiceMonthsMin     int NULL,
       ServiceMonthsMax     int NULL,
       MarketServiceCountTypeID int NULL,
       ServiceCountTotalMin int NULL,
       ServiceCountTotalMax int NULL,
       ServiceCountMin      int NULL,
       ServiceCountMax      int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       Cost                 numeric(18,4) NULL,
       MinServiceLevel      int NULL,
       AccessLabelID        int NULL,
       CopyServiceCost      tinyint NULL,
       CopyServiceLevel     tinyint NULL,
       AllowAccessTime      tinyint NOT NULL DEFAULT 0,
       AllowServiceCost     tinyint NOT NULL DEFAULT 0,
       AllowInvoicedDaysMax tinyint NOT NULL DEFAULT 0,
       Hidden               tinyint NOT NULL DEFAULT 0,
       CustomerHidden       tinyint NOT NULL DEFAULT 1,
       DiscountID           int NULL,
       CancelServiceLevelMin int NULL,
       CancelChargeInvoicedMonths int NULL,
       CancelChargeTypeID   int NULL,
       MarketTagCancelTypeID int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       ServiceLevelTypeID   int NULL,
       CreatedBefore        datetime NULL,
       CreatedAfter         datetime NULL
)
go

CREATE INDEX i_MarketTags_MarketTag ON dbo.MarketTags
(
       MarketTag
)
go





CREATE INDEX i_MarketTags_MCID ON dbo.MarketTags
(
       MarketCategoryID
)
go

CREATE INDEX i_MarketTags_MTATID ON dbo.MarketTags
(
       MarketTagAutoTypeID
)
go

CREATE INDEX i_MarketTags_ADTID ON dbo.MarketTags
(
       AddressDataTypeID
)
go







ALTER TABLE dbo.MarketTags
       ADD PRIMARY KEY (MarketTagID)
go


CREATE TABLE dbo.MasterAccountData (
       CustomerID           int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       Data                 varchar(512) NULL
)
go




ALTER TABLE dbo.MasterAccountData
       ADD PRIMARY KEY (CustomerID, AccountDataTypeID)
go


CREATE TABLE dbo.MasterAccountDataTypes (
       MasterAccountDataTypeID int IDENTITY,
       GroupID              int NULL,
       AccountDataTypeID    int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL,
       ServiceGroupID       int NULL
)
go

CREATE UNIQUE INDEX IX_MasterAccountDataTypes ON dbo.MasterAccountDataTypes
(
       GroupID,
       AccountDataTypeID
)
go




ALTER TABLE dbo.MasterAccountDataTypes
       ADD PRIMARY KEY (MasterAccountDataTypeID)
go


CREATE TABLE dbo.MasterAccountPromoCodes (
       CustomerID           int NOT NULL,
       PromoCodeID          int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_MAPC_PromoCodeID ON dbo.MasterAccountPromoCodes
(
       PromoCodeID
)
go


ALTER TABLE dbo.MasterAccountPromoCodes
       ADD PRIMARY KEY (CustomerID, PromoCodeID)
go


CREATE TABLE dbo.MasterAccounts (
       CustomerID           int IDENTITY,
       BillingAddressID     int NULL,
       ShippingAddressID    int NULL,
       ServiceAddressID     int NULL,
       LastStatementID      int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       RegionID             int NOT NULL,
       ReferredByID         int NULL,
       SalesPersonID        int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       StartDate            datetime NOT NULL DEFAULT getdate(),
       Active               smallint NOT NULL DEFAULT 1,
       LanguageID           int NULL,
       PayPeriodID          int NOT NULL,
       PaymentTypeID        int NOT NULL DEFAULT 1,
       LastReceived         datetime NOT NULL DEFAULT getdate(),
       Comments             text NULL,
       GroupID              int NOT NULL,
       TempExtension        smallint NOT NULL DEFAULT 0,
       SendMethodID         int NOT NULL,
       CreditLimit          numeric(18,4) NOT NULL DEFAULT 0,
       BillingCycleID       int NOT NULL,
       BillDay              tinyint NOT NULL DEFAULT 1,
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       Balance              numeric(18,4) NOT NULL DEFAULT 0,
       PendingBalance       numeric(18,4) NOT NULL DEFAULT 0,
       PIN                  varchar(10) NULL,
       ExternalRef          varchar(64) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       TransHoldDate        datetime NULL,
       PO                   varchar(25) NULL,
       BillMonth            tinyint NULL
)
go

CREATE INDEX iBillingCycleID ON dbo.MasterAccounts
(
       BillingCycleID
)
go











CREATE INDEX i_MasterAccounts_GroupID ON dbo.MasterAccounts
(
       GroupID
)
go

CREATE INDEX i_MasterAccounts_CreateDate ON dbo.MasterAccounts
(
       CreateDate
)
go

CREATE INDEX i_MasterAccounts_LastMDate ON dbo.MasterAccounts
(
       LastModifyDate
)
go

CREATE INDEX i_MasterAccounts_Active ON dbo.MasterAccounts
(
       Active
)
go

CREATE INDEX i_MasterAccounts_CancelDate ON dbo.MasterAccounts
(
       CancelDate
)
go

CREATE INDEX IX_MasterAccounts_Region ON dbo.MasterAccounts
(
       RegionID
)
go

CREATE INDEX i_MasterAccounts_ExternalRef ON dbo.MasterAccounts
(
       ExternalRef
)
go




ALTER TABLE dbo.MasterAccounts
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.MasterAccountTags (
       CustomerID           int NOT NULL,
       MarketTagID          int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL DEFAULT suser_name()
)
go




ALTER TABLE dbo.MasterAccountTags
       ADD PRIMARY KEY (CustomerID, MarketTagID)
go


CREATE TABLE dbo.MenuItems (
       MenuItemID           int NOT NULL,
       MenuItem             varchar(128) NOT NULL,
       Label                varchar(64) NOT NULL,
       TableName            varchar(64) NULL,
       ColumnName           varchar(64) NULL,
       FileName             varchar(64) NULL,
       LabelName            varchar(64) NULL,
       SectionObject        varchar(128) NULL,
       Access               varchar(16) NULL,
       Condition            varchar(255) NULL,
       FeatureID            int NULL,
       Description          varchar(128) NOT NULL,
       DescStringID         int NULL,
       HelpStringID         int NULL,
       AccessKey            varchar(5) NULL,
       Link                 varchar(255) NOT NULL,
       Attribute            varchar(255) NULL
)
go








ALTER TABLE dbo.MenuItems
       ADD PRIMARY KEY (MenuItemID)
go


CREATE TABLE dbo.Menus (
       MenuID               int NOT NULL,
       Menu                 varchar(128) NOT NULL,
       Description          text NULL,
       Class                varchar(64) NULL
)
go




ALTER TABLE dbo.Menus
       ADD PRIMARY KEY (MenuID)
go


CREATE TABLE dbo.MenuSets (
       MenuID               int NOT NULL,
       MenuItemID           int NOT NULL,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.MenuSets
       ADD PRIMARY KEY (MenuID, MenuItemID)
go


CREATE TABLE dbo.MetaColumns (
       MetaColumnID         int IDENTITY,
       MetaTableID          int NULL,
       ColumnName           varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       StringID             int NULL,
       DepTable             varchar(32) NULL,
       DepColumn            varchar(32) NULL,
       DepGroup             int NULL,
       MetaRuleID           int NULL,
       Required             tinyint NULL,
       Nullable             tinyint NULL,
       Quoted               tinyint NULL,
       MinSize              int NULL,
       MaxSize              int NULL,
       IsKey                tinyint NULL,
       AllowAudit           tinyint NOT NULL DEFAULT 1,
       AddOnly              tinyint NOT NULL DEFAULT 0,
       ColumnType           int NULL,
       HelpText             text NULL,
       RegExp               varchar(255) NULL,
       CheckQuery           varchar(255) NULL
)
go

CREATE INDEX i_MetaColumns_IsKey ON dbo.MetaColumns
(
       MetaTableID,
       IsKey
)
go


CREATE INDEX i_MetaColumns_MTID_MC ON dbo.MetaColumns
(
       MetaTableID,
       ColumnName
)
go









ALTER TABLE dbo.MetaColumns
       ADD PRIMARY KEY (MetaColumnID)
go


CREATE TABLE dbo.MetaRules (
       MetaRuleID           int NOT NULL,
       MetaRule             varchar(255) NOT NULL
)
go



ALTER TABLE dbo.MetaRules
       ADD PRIMARY KEY (MetaRuleID)
go




CREATE TABLE dbo.MetaTables (
       MetaTableID          int IDENTITY,
       TableName            varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       GroupTable           varchar(32) NULL,
       GroupName            varchar(15) NULL,
       Auditable            tinyint NOT NULL DEFAULT 1,
       AllowAudit           tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       LabelTable           varchar(32) NULL
)
go

CREATE UNIQUE INDEX XAK1MetaTables ON dbo.MetaTables
(
       TableName
)
go






ALTER TABLE dbo.MetaTables
       ADD PRIMARY KEY (MetaTableID)
go


CREATE TABLE dbo.MimeTypes (
       MimeTypeID           int IDENTITY,
       MimeType             varchar(128) NOT NULL,
       Extension            varchar(256) NULL,
       Description          varchar(256) NULL,
       IsImage              tinyint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX IX_MimeTypes ON dbo.MimeTypes
(
       MimeType
)
go


ALTER TABLE dbo.MimeTypes
       ADD PRIMARY KEY (MimeTypeID)
go


CREATE TABLE dbo.MonFilterItems (
       MonFilterItemID      int IDENTITY,
       MonFilterID          int NOT NULL,
       RegionID             int NULL,
       TowerID              int NULL,
       MarketTagID          int NULL,
       GroupID              int NULL,
       ServiceCategoryID    int NULL,
       AccountTypeID        int NULL,
       ServerID             int NULL,
       ServerGroupID        int NULL,
       Allowed              tinyint NOT NULL DEFAULT 1,
       DomainID             int NULL,
       InvProductID         int NULL
)
go


ALTER TABLE dbo.MonFilterItems
       ADD PRIMARY KEY (MonFilterItemID)
go

CREATE INDEX i_MonFilterItems_MFID ON dbo.MonFilterItems
(
       MonFilterID
)
go


CREATE TABLE dbo.MonFilters (
       MonFilterID          int IDENTITY,
       MonFilter            varchar(128) NOT NULL,
       MonSourceID          smallint NOT NULL,
       AllowExpired         tinyint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.MonFilters
       ADD PRIMARY KEY (MonFilterID)
go


CREATE TABLE dbo.MonitorProfileOptions (
       MonitorID            int NOT NULL,
       MonProfileItemID     int NOT NULL,
       GaugeID              int NULL
)
go


ALTER TABLE dbo.MonitorProfileOptions
       ADD PRIMARY KEY (MonitorID, MonProfileItemID)
go


CREATE TABLE dbo.Monitors (
       MonitorID            int IDENTITY,
       Monitor              varchar(128) NOT NULL,
       MonSourceID          smallint NOT NULL,
       InvProductID         int NULL,
       MonFilterID          int NULL,
       MonProtocolID        smallint NOT NULL,
       MonRadIPSourceID     smallint NULL,
       IPAddress            varchar(64) NULL,
       MonProfileID         int NULL,
       Pace                 float NULL,
       Timeout              int NULL,
       Login                varchar(64) NULL,
       Password             varchar(200) NULL,
       PrivPassword         varchar(200) NULL,
       PingInterval         int NULL,
       Pings                int NULL,
       PingMinGaugeID       int NULL,
       PingMaxGaugeID       int NULL,
       PingAvgGaugeID       int NULL,
       PingTimeoutGaugeID   int NULL,
       PingJitterGaugeID    int NULL,
       SNMPCommunity        varchar(64) NULL,
       SNMPAuthProto        varchar(20) NULL,
       SNMPPrivProto        varchar(20) NULL,
       IPInvAttributeID     int NULL,
       LoginInvAttributeID  int NULL,
       PasswordInvAttributeID int NULL,
       PrivPasswordInvAttributeID int NULL,
       CommunityInvAttributeID int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       FlowFilterID         int NULL,
       FlowUpGaugeID        int NULL,
       FlowDownGaugeID      int NULL,
       FlowUpDownGaugeID    int NULL
)
go


ALTER TABLE dbo.Monitors
       ADD PRIMARY KEY (MonitorID)
go


CREATE TABLE dbo.MonProfileItems (
       MonProfileItemID     int IDENTITY,
       MonProfileID         int NOT NULL,
       MonProfileItem       varchar(128) NOT NULL,
       OID                  varchar(512) NOT NULL,
       Multiplier           float NOT NULL DEFAULT 1,
       GaugeID              int NULL,
       TableOID             varchar(512) NULL,
       TableValue           varchar(128) NULL,
       InvAttributeID       int NULL,
       AccountDataTypeID    int NULL,
       RegExp               varchar(1024) NULL
)
go

ALTER TABLE dbo.MonProfileItems
       ADD PRIMARY KEY (MonProfileItemID)
go

CREATE INDEX i_MonProfileItems_MPID ON dbo.MonProfileItems
(
       MonProfileID
)
go


CREATE TABLE dbo.MonProfiles (
       MonProfileID         int IDENTITY,
       MonProfile           varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.MonProfiles
       ADD PRIMARY KEY (MonProfileID)
go


CREATE TABLE dbo.MonProtocols (
       MonProtocolID        smallint NOT NULL,
       MonProtocol          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.MonProtocols
       ADD PRIMARY KEY (MonProtocolID)
go


CREATE TABLE dbo.MonRadIPSources (
       MonRadIPSourceID     smallint NOT NULL,
       MonRadIPSource       varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.MonRadIPSources
       ADD PRIMARY KEY (MonRadIPSourceID)
go


CREATE TABLE dbo.MonSources (
       MonSourceID          smallint NOT NULL,
       MonSource            varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.MonSources
       ADD PRIMARY KEY (MonSourceID)
go


CREATE TABLE dbo.NoticeActives (
       NoticeID             int NOT NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       OperatorID           int NULL,
       TokenID              int NULL,
       SubTokenID           int NULL
)
go

CREATE UNIQUE INDEX i_NoticeActives_UC ON dbo.NoticeActives
(
       NoticeID,
       CustomerID,
       AccountID,
       OperatorID,
       TokenID,
       SubTokenID
)
go


CREATE TABLE dbo.NoticeLogs (
       NoticeLogID          int IDENTITY,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       NoticeID             int NOT NULL,
       CustomerID           int NOT NULL,
       Email                varchar(80) NOT NULL,
       ErrorMessage         varchar(255) NULL
)
go

CREATE INDEX i_NoticeLogs_CustomerID ON dbo.NoticeLogs
(
       CustomerID,
       LogDate
)
go

CREATE INDEX i_NoticeLogs_CreateDate ON dbo.NoticeLogs
(
       LogDate
)
go





ALTER TABLE dbo.NoticeLogs
       ADD PRIMARY KEY (NoticeLogID)
go


CREATE TABLE dbo.NoticePurposes (
       NoticePurposeID      int NOT NULL,
       NoticePurpose        varchar(128) NOT NULL,
       StringID             int NULL,
       CustomerDescription  varchar(128) NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go







ALTER TABLE dbo.NoticePurposes
       ADD PRIMARY KEY (NoticePurposeID)
go


CREATE TABLE dbo.Notices (
       NoticeID             int IDENTITY,
       NoticeTypeID         int NOT NULL,
       NoticeTechID         smallint NOT NULL DEFAULT 1,
       Active               tinyint NOT NULL DEFAULT 1,
       Notice               varchar(64) NOT NULL,
       MailFrom             varchar(128) NULL,
       MailSubject          varchar(128) NULL,
       MailCC               varchar(128) NULL,
       NoticeText           text NOT NULL,
       AccessTime           varchar(128) NULL,
       Parm1                varchar(128) NULL,
       Parm2                varchar(128) NULL,
       Parm3                varchar(128) NULL,
       Parm4                varchar(128) NULL,
       Parm5                varchar(128) NULL,
       Parm6                varchar(128) NULL,
       Parm7                varchar(128) NULL,
       LastRunDate          datetime NULL,
       InternalID           smallint NULL,
       NoticeFormatID       smallint NULL,
       AttachFileName       varchar(64) NULL,
       MailBCC              varchar(128) NULL
)
go






ALTER TABLE dbo.Notices
       ADD PRIMARY KEY (NoticeID)
go


CREATE TABLE dbo.NoticeTechs (
       NoticeTechID         smallint NOT NULL,
       NoticeTech           varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.NoticeTechs
       ADD PRIMARY KEY (NoticeTechID)
go


CREATE TABLE dbo.NoticeFormats (
       NoticeFormatID       smallint NOT NULL,
       NoticeFormat         varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.NoticeFormats
       ADD PRIMARY KEY (NoticeFormatID)
go



CREATE TABLE dbo.NoticeTypes (
       NoticeTypeID         int IDENTITY,
       NoticeType           varchar(128) NOT NULL,
       NoticePurposeID      int NOT NULL,
       Description          text NULL,
       DefaultText          text NULL,
       SQLQuery             text NOT NULL,
       SentQuery            text NULL,
       ReportFile           varchar(45) NULL,
       Parm1Desc            varchar(128) NULL,
       Parm2Desc            varchar(128) NULL,
       Parm3Desc            varchar(128) NULL,
       Parm4Desc            varchar(128) NULL,
       Parm5Desc            varchar(128) NULL,
       Parm6Desc            varchar(128) NULL,
       Parm7Desc            varchar(128) NULL,
       InternalID           smallint NULL,
       Parm1Query           text NULL,
       Parm2Query           text NULL,
       Parm3Query           text NULL,
       Parm4Query           text NULL,
       Parm5Query           text NULL,
       Parm6Query           text NULL,
       Parm7Query           text NULL,
       IEAID                int NULL,
       Parm1RegExp          varchar(128) NULL,
       Parm2RegExp          varchar(128) NULL,
       Parm3RegExp          varchar(128) NULL,
       Parm4RegExp          varchar(128) NULL,
       Parm5RegExp          varchar(128) NULL,
       Parm6RegExp          varchar(128) NULL,
       Parm7RegExp          varchar(128) NULL
)
go

CREATE INDEX IX_NoticeTypes ON dbo.NoticeTypes
(
       InternalID
)
go




ALTER TABLE dbo.NoticeTypes
       ADD PRIMARY KEY (NoticeTypeID)
go


CREATE TABLE dbo.Numbers (
       n                    smallint NOT NULL
)
go


ALTER TABLE dbo.Numbers
       ADD PRIMARY KEY (n)
go


CREATE TABLE dbo.ObjectGroups (
       ObjectGroupID        int NOT NULL,
       ObjectGroup          varchar(32) NOT NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.ObjectGroups
       ADD PRIMARY KEY (ObjectGroupID)
go


CREATE TABLE dbo.Objects (
       ObjectID             int IDENTITY,
       ObjectGroupID        int NOT NULL,
       ObjectTypeID         int NOT NULL,
       Value                int NULL,
       Data                 varchar(80) NULL,
       Description          varchar(16) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       DirectRef            tinyint NOT NULL DEFAULT 0
)
go






CREATE INDEX i_Objects_OTID ON dbo.Objects
(
       ObjectTypeID,
       Active
)
go


ALTER TABLE dbo.Objects
       ADD PRIMARY KEY (ObjectID)
go


CREATE TABLE dbo.ObjectTypes (
       ObjectTypeID         int NOT NULL,
       ObjectType           varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ObjectTypes
       ADD PRIMARY KEY (ObjectTypeID)
go


CREATE TABLE dbo.OperatorCookies (
       Cookie               varchar(128) NOT NULL,
       LastUsed             datetime NOT NULL DEFAULT getdate(),
       OperatorID           int NULL,
       AccountID            int NULL
)
go





ALTER TABLE dbo.OperatorCookies
       ADD PRIMARY KEY (Cookie)
go


CREATE TABLE dbo.OperatorGroupAccess (
       OperatorGroupID      int NOT NULL,
       ObjectGroupID        int NOT NULL,
       GroupID              int NOT NULL,
       AccessType           smallint NOT NULL DEFAULT 1
)
go





ALTER TABLE dbo.OperatorGroupAccess
       ADD PRIMARY KEY (OperatorGroupID, ObjectGroupID, GroupID)
go


CREATE TABLE dbo.OperatorGroups (
       OperatorGroupID      int IDENTITY,
       OperatorGroup        varchar(128) NOT NULL,
       StartPage            varchar(64) NULL,
       Description          varchar(1024) NULL,
       InternalUse          tinyint NOT NULL DEFAULT 0,
       InfoMessage          varchar(1024) NULL,
       InfoURL              varchar(128) NULL,
       InfoExpireDate       datetime NULL
)
go





ALTER TABLE dbo.OperatorGroups
       ADD PRIMARY KEY (OperatorGroupID)
go


CREATE TABLE dbo.OperatorRoles (
       OperatorRoleID       int IDENTITY,
       OperatorID           int NOT NULL,
       RoleID               int NOT NULL,
       GroupID              int NULL,
       TargetActive         int NULL,
       MaxActive            int NULL,
       MaxDistance          numeric(12,2) NULL,
       Tier                 smallint NOT NULL DEFAULT 1,
       ShowEscalate         tinyint NOT NULL DEFAULT 0,
       ShowLate             tinyint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX i_OperatorRoles_unique ON dbo.OperatorRoles
(
       OperatorID,
       RoleID,
       GroupID
)
go

CREATE INDEX IX_OperatorRoles ON dbo.OperatorRoles
(
       RoleID,
       OperatorID
)
go







ALTER TABLE dbo.OperatorRoles
       ADD PRIMARY KEY (OperatorRoleID)
go





CREATE TABLE dbo.OperatorPayments (
       OperatorPaymentID    int IDENTITY,
       OperatorID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CustomerID           int NOT NULL,
       PaymentTypeID        int NOT NULL,
       InvoiceID            int NULL,
       Amount               numeric(18,4) NOT NULL,
       CheckNumber          varchar(16) NULL,
       PayInfo              varchar(64) NULL,
       ExternalRef          varchar(64) NULL
)
go

CREATE INDEX i_OperatorPayments_OID ON dbo.OperatorPayments
(
       OperatorID
)
go

CREATE INDEX i_OperatorPayments_CID ON dbo.OperatorPayments
(
       CustomerID
)
go

ALTER TABLE dbo.OperatorPayments
       ADD PRIMARY KEY (OperatorPaymentID)
go


CREATE TABLE dbo.OperatorPins (
       OperatorPinID        int IDENTITY,
       OperatorID           int NOT NULL,
       CustomerID           int NOT NULL,
       ExpireDate           datetime NULL,
       ActiveDate           datetime NULL,
       Tries                int NOT NULL DEFAULT 0
)
go

CREATE INDEX i_OperatorPins_OID_CID_ED ON dbo.OperatorPins
(
       OperatorID,CustomerID,ExpireDate
)
go

CREATE INDEX i_OperatorPins_CID ON dbo.OperatorPins
(
       CustomerID
)
go

ALTER TABLE dbo.OperatorPins
       ADD PRIMARY KEY (OperatorPinID)
go


CREATE TABLE dbo.Operators (
       OperatorID           int IDENTITY,
       PrintTypeID          smallint NULL,
       OperatorGroupID      int NOT NULL,
       Operator             varchar(32) NOT NULL,
       FirstName            varchar(80) NULL,
       LastName             varchar(80) NULL,
       CertClientRequired   tinyint NOT NULL DEFAULT 0,
       Password             varchar(200) NULL,
       AccessTime1          varchar(128) NULL,
       AccessTime2          varchar(128) NULL,
       AccessTime3          varchar(128) NULL,
       Email                varchar(80) NULL,
       PhoneMobile          varchar(32) NULL,
       LanguageID           int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       DateFormatID         int NULL,
       DateSeparator        char(1) NULL,
       ThemeID              int NULL,
       CountryID            int NULL,
       DaySumIncident       tinyint NULL,
       MeasureUnitID        smallint NULL,
       SchedBlockTypeID     int NULL,
       InvCartID            int NULL,
       TimeFormatID         smallint NULL,
       PasswordChange       tinyint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX uc_Operator ON dbo.Operators
(
       Operator
)
go

CREATE INDEX i_Operators_OperatorGroupID ON dbo.Operators
(
       OperatorGroupID
)
go




CREATE INDEX i_Operators_Email ON dbo.Operators
(
       Email
)
go









ALTER TABLE dbo.Operators
       ADD PRIMARY KEY (OperatorID)
go


CREATE TABLE dbo.OperatorScheds (
       OperatorSchedID      int IDENTITY,
       OperatorID           int NOT NULL,
       SchedBlockID         int NOT NULL,
       SiteID               int NULL,
       SchedTimeID          int NOT NULL,
       TimeUnits            int NULL
)
go

CREATE UNIQUE INDEX uc_OperatorScheds_OID_SBID ON dbo.OperatorScheds
(
       OperatorID,
       SchedBlockID
)
go

CREATE INDEX i_OperatorScheds_STID ON dbo.OperatorScheds
(
       SchedTimeID
)
go

CREATE INDEX i_OperatorScheds_OID ON dbo.OperatorScheds
(
       OperatorID
)
go




ALTER TABLE dbo.OperatorScheds
       ADD PRIMARY KEY (OperatorSchedID)
go


CREATE TABLE dbo.OperatorSchedTimes (
       OperatorSchedTimeID  int IDENTITY,
       OperatorSchedTime    varchar(128) NOT NULL,
       OperatorID           int NOT NULL,
       OperatorSchedID      int NULL,
       AccessTime           varchar(128) NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       Include              tinyint NOT NULL DEFAULT 0,
       Comments             text NULL
)
go




ALTER TABLE dbo.OperatorSchedTimes
       ADD PRIMARY KEY (OperatorSchedTimeID)
go


CREATE TABLE dbo.OrgAccountTypes (
       OrganizationID       int NOT NULL,
       AccountTypeID        int NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             varchar(128) NULL
)
go


ALTER TABLE dbo.OrgAccountTypes
       ADD PRIMARY KEY (OrganizationID, AccountTypeID)
go


CREATE TABLE dbo.Organizations (
       OrganizationID       int IDENTITY,
       ResellerCustomerID   int NULL,
       Organization         varchar(255) NOT NULL,
       InvoiceDetailed      smallint NOT NULL DEFAULT 0,
       InvoiceFractional    smallint NOT NULL DEFAULT 0,
       MaxAccounts          int NULL,
       CurrencyID           int NOT NULL DEFAULT 207
)
go


ALTER TABLE dbo.Organizations
       ADD PRIMARY KEY (OrganizationID)
go


CREATE TABLE dbo.PaymentItems (
       PaymentItemID        int IDENTITY,
       PaymentID            int NULL,
       ChargeID             int NULL,
       ItemID               int NOT NULL,
       ActiveDate           datetime NOT NULL,
       InactiveDate         datetime NULL,
       Amount               numeric(18,4) NOT NULL
)
go

CREATE INDEX i_PaymentItems_ItemID ON dbo.PaymentItems
(
       ItemID,
       InactiveDate
)
go

CREATE INDEX i_PaymentItems_PaymentID ON dbo.PaymentItems
(
       PaymentID,
       InactiveDate
)
go

CREATE INDEX i_PaymentItems_ChargeID ON dbo.PaymentItems
(
       ChargeID,
       InactiveDate
)
go




ALTER TABLE dbo.PaymentItems
       ADD PRIMARY KEY (PaymentItemID)
go


CREATE TABLE dbo.Payments (
       PaymentID            int IDENTITY,
       CustomerID           int NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL,
       EffectiveDate        datetime NULL,
       BatchID              int NULL,
       PaymentTypeID        int NOT NULL,
       CheckNumber          varchar(16) NULL,
       PayInfo              varchar(64) NULL,
       ProcTransID          varchar(64) NULL,
       DistFlag             tinyint NOT NULL DEFAULT 1,
       StatementID          int NULL,
       FinalAmount          numeric(18,4) NULL,
       FinalStatementID     int NULL,
       FinalCreateDate      datetime NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       ExternalRef          varchar(64) NULL
)
go

CREATE INDEX i_Payments_CustomerID_CD ON dbo.Payments
(
       CustomerID,
       CreateDate
)
go

CREATE INDEX i_Payments_CD ON dbo.Payments
(
       CreateDate
)
go

CREATE INDEX i_Payments_StatementID ON dbo.Payments
(
       StatementID
)
go

CREATE INDEX i_Payments_FinalStatementID ON dbo.Payments
(
       FinalStatementID
)
go








ALTER TABLE dbo.Payments
       ADD PRIMARY KEY (PaymentID)
go


CREATE TABLE dbo.PaymentTypes (
       PaymentTypeID        int NOT NULL,
       PaymentType          varchar(128) NOT NULL,
       StringID             int NULL,
       CustomerDescription  varchar(128) NULL,
       CustomerStringID     int NULL,
       GLCodeID             int NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 1,
       CustomerPayment      tinyint NOT NULL DEFAULT 1,
       IsPayMethod          tinyint NOT NULL DEFAULT 1,
       IsPayType            tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go








ALTER TABLE dbo.PaymentTypes
       ADD PRIMARY KEY (PaymentTypeID)
go


CREATE TABLE dbo.PayPeriods (
       PayPeriodID          int IDENTITY,
       AccountTypeID        int NULL,
       PayPeriod            varchar(64) NOT NULL,
       StringID             int NULL,
       PeriodTypeID         int NOT NULL,
       Period               smallint NOT NULL,
       SetupCharge          tinyint NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       ConfirmTrans         smallint NULL DEFAULT 0
)
go

CREATE INDEX i_PayPeriods_GroupID ON dbo.PayPeriods
(
       GroupID
)
go









ALTER TABLE dbo.PayPeriods
       ADD PRIMARY KEY (PayPeriodID)
go


CREATE TABLE dbo.PayPlans (
       PayPlanID            int IDENTITY,
       PayPlan              varchar(128) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       MarketTagID          int NULL,
       AccessLabelID        int NULL,
       IntervalMonths       int NULL,
       IntervalDays         int NULL,
       PaymentCount         int NOT NULL DEFAULT 1,
       PaymentTypeID        int NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go






ALTER TABLE dbo.PayPlans
       ADD PRIMARY KEY (PayPlanID)
go


CREATE TABLE dbo.PeriodTypes (
       PeriodTypeID         int NOT NULL,
       PeriodType           varchar(32) NOT NULL,
       StringID             int NULL,
       AllowPayPeriod       smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.PeriodTypes
       ADD PRIMARY KEY (PeriodTypeID)
go

CREATE TABLE dbo.PIIRetentions (
       PIIRetentionID       int IDENTITY,
       PIIRetention         varchar(128) NOT NULL,
       FieldMask            int NOT NULL DEFAULT 0,
       OrganizationID       int NULL,
       GroupID              int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       InactiveDays         int NULL,
       DeletedDays          int NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1
)
go

ALTER TABLE dbo.PIIRetentions
       ADD PRIMARY KEY (PIIRetentionID)
go

CREATE TABLE dbo.PIIFields (
       PIIFieldID           int IDENTITY,
       PIIRetentionID       int NOT NULL,
       AddressDataTypeID    int NULL,
       AccountDataTypeID    int NULL,
       IncidentDataTypeID   int NULL,
       IncidentTypeID       int NULL
)
go

ALTER TABLE dbo.PIIFields
       ADD PRIMARY KEY (PIIFieldID)
go


CREATE TABLE dbo.PosixAccountServers (
       PosixAccountServerID int IDENTITY,
       LDAPServer           varchar(50) NOT NULL,
       AccountTypeID        varchar(20) NOT NULL,
       gidNumber            int NOT NULL,
       loginShell           varchar(100) NOT NULL,
       homeDirectory        varchar(100) NOT NULL
)
go

CREATE INDEX i_PosixAccountServers_ID ON dbo.PosixAccountServers
(
       PosixAccountServerID
)
go


ALTER TABLE dbo.PosixAccountServers
       ADD PRIMARY KEY (LDAPServer, AccountTypeID)
go


CREATE TABLE dbo.PosixAccountUsers (
       PosixAccountUserID   int IDENTITY,
       PosixAccountServerID int NOT NULL,
       AccountID            int NOT NULL,
       uidNumber            int NULL,
       gidNumber            int NULL,
       loginShell           varchar(100) NULL,
       homeDirectory        varchar(100) NULL,
       userPassword         varchar(50) NULL
)
go

CREATE INDEX i_PosixAccountUsers_ID ON dbo.PosixAccountUsers
(
       PosixAccountUserID
)
go

CREATE INDEX i_PosixAccountUsers_SrvrID ON dbo.PosixAccountUsers
(
       PosixAccountServerID
)
go


ALTER TABLE dbo.PosixAccountUsers
       ADD PRIMARY KEY (AccountID)
go


CREATE TABLE dbo.PrintTypes (
       PrintTypeID          smallint NOT NULL,
       PrintType            varchar(64) NOT NULL,
       Data                 varchar(128) NULL,
       CRData               varchar(128) NULL
)
go

CREATE UNIQUE INDEX pk_PrintTypes ON dbo.PrintTypes
(
       PrintType
)
go


ALTER TABLE dbo.PrintTypes
       ADD PRIMARY KEY (PrintTypeID)
go


CREATE TABLE dbo.Priorities (
       PriorityID           smallint NOT NULL,
       Priority             varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.Priorities
       ADD PRIMARY KEY (PriorityID)
go


CREATE TABLE dbo.PromoCodes (
       PromoCodeID          int IDENTITY,
       PromoCode            varchar(128) NOT NULL,
       StringID             int NULL,
       Code                 varchar(64) NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       MaxUsers             int NULL,
       ExpireDate           datetime NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       GroupID              int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       RegionID             int NULL,
       AccessLabelID        int NULL,
       Comments             text NULL
)
go

CREATE UNIQUE INDEX i_PromoCodes_Code ON dbo.PromoCodes
(
       Code
)
go







ALTER TABLE dbo.PromoCodes
       ADD PRIMARY KEY (PromoCodeID)
go


CREATE TABLE dbo.RadATConfigs (
       RadATConfigID        int IDENTITY,
       AccountTypeID        int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadMergeTypeID       smallint NOT NULL DEFAULT 3,
       RadFailReason        int NOT NULL DEFAULT 0,
       Parent               tinyint NOT NULL DEFAULT 0,
       RadCheck             tinyint NOT NULL DEFAULT 0,
       Tag                  tinyint NULL,
       Data                 varchar(4000) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RadATConfigs_ATID ON dbo.RadATConfigs
(
       AccountTypeID
)
go







ALTER TABLE dbo.RadATConfigs
       ADD PRIMARY KEY (RadATConfigID)
go


CREATE TABLE dbo.RadAttributes (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Name                 varchar(64) NOT NULL,
       RadAttributeType     smallint NOT NULL,
       AliasAttributeID     int NULL,
       AliasVendorID        int NULL
)
go







ALTER TABLE dbo.RadAttributes
       ADD PRIMARY KEY (RadAttributeID, RadVendorID)
go


CREATE TABLE dbo.RadConcurrency (
       RadConcurrencyID     int IDENTITY,
       GroupID              int NOT NULL,
       AccountTypeID        int NULL,
       LastSyncDate         datetime NOT NULL DEFAULT getdate(),
       ConnectionsMax       int NOT NULL DEFAULT 0,
       Connections          int NOT NULL DEFAULT 0,
       Description          varchar(100) NULL
)
go

CREATE UNIQUE CLUSTERED INDEX i_RC_GroupAccountID ON RadConcurrency
(
       GroupID,
       AccountTypeID
)
go


ALTER TABLE dbo.RadConcurrency
       ADD PRIMARY KEY NONCLUSTERED (RadConcurrencyID)
go


CREATE TABLE dbo.RadConfigs (
       RadConfigID          int IDENTITY,
       AccountID            int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadMergeTypeID       smallint NOT NULL DEFAULT 3,
       RadCheck             tinyint NOT NULL DEFAULT 0,
       Tag                  smallint NULL,
       Data                 varchar(4000) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Parent               tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RadConfigs_AccountID ON dbo.RadConfigs
(
       AccountID
)
go


ALTER TABLE dbo.RadConfigs
       ADD PRIMARY KEY (RadConfigID)
go


CREATE TABLE dbo.RadDestTypes (
       RadDestTypeID        int NOT NULL,
       RadDestType          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RadDestTypes
       ADD PRIMARY KEY (RadDestTypeID)
go


CREATE TABLE dbo.RadFailReasons (
       RadFailReasonID      int NOT NULL,
       RadFailReason        varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.RadFailReasons
       ADD PRIMARY KEY (RadFailReasonID)
go


CREATE TABLE dbo.RadFilterGroups (
       RadFilterGroupID     int IDENTITY,
       RadFilterGroup       varchar(64) NOT NULL,
       RadSourceTypeID      int NOT NULL,
       Description          varchar(255) NULL,
       DestRadFilterGroupID int NULL,
       DestData             varchar(255) NULL,
       RadDestTypeID        int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go






ALTER TABLE dbo.RadFilterGroups
       ADD PRIMARY KEY (RadFilterGroupID)
go


CREATE TABLE dbo.RadFilters (
       RadFilterID          int IDENTITY,
       RadMergeTypeID       smallint NULL,
       RadFilterTypeID      int NULL,
       RadVendorID          int NULL,
       RadSearchTypeID      smallint NOT NULL,
       RadAttributeID       int NULL,
       RadFilterGroupID     int NOT NULL,
       Location             varchar(64) NULL,
       Data                 varchar(4000) NULL
)
go



ALTER TABLE dbo.RadFilters
       ADD PRIMARY KEY (RadFilterID)
go


CREATE TABLE dbo.RadFilterTypes (
       RadFilterTypeID      int NOT NULL,
       RadFilterType        varchar(64) NOT NULL
)
go



ALTER TABLE dbo.RadFilterTypes
       ADD PRIMARY KEY (RadFilterTypeID)
go


CREATE TABLE dbo.RadInvConfigs (
       RadInvConfigID       int IDENTITY,
       InvSourceID          int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadMergeTypeID       smallint NOT NULL DEFAULT 3,
       InvAttributeID       int NULL,
       RadCheck             tinyint NOT NULL DEFAULT 0,
       Tag                  smallint NULL,
       Data                 varchar(4000) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Parent               tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RadInvConfigs_ISID ON dbo.RadInvConfigs
(
       InvSourceID
)
go






ALTER TABLE dbo.RadInvConfigs
       ADD PRIMARY KEY (RadInvConfigID)
go


CREATE TABLE dbo.RadLogMsgs (
       RadLogMsgID          smallint NOT NULL,
       RadLogMsg            varchar(64) NOT NULL,
       Severity             int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RadLogMsgs
       ADD PRIMARY KEY (RadLogMsgID)
go


CREATE TABLE dbo.RadLogs (
       LogDate              datetime NOT NULL DEFAULT getdate(),
       Username             varchar(64) NOT NULL,
       RadLogMsgID          smallint NOT NULL,
       AccountID            int NULL,
       Data                 varchar(128) NULL,
       NASIdentifier        varchar(45) NULL,
       NASPort              varchar(32) NULL,
       CallingStationID     varchar(64) NULL,
       CalledStationID      varchar(64) NULL
)
go

CREATE UNIQUE CLUSTERED INDEX uc_RadLogs ON RadLogs
(
       LogDate,
       Username,
       RadLogMsgID
) WITH IGNORE_DUP_KEY
go





CREATE TABLE dbo.RadMapAttributes (
       MapAttribute         varchar(64) NOT NULL,
       RadMapTypeID         int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL
)
go


ALTER TABLE dbo.RadMapAttributes
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID)
go


CREATE TABLE dbo.RadMapTypes (
       RadMapTypeID         int NOT NULL,
       RadMapType           varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RadMapTypes
       ADD PRIMARY KEY (RadMapTypeID)
go


CREATE TABLE dbo.RadMapValues (
       MapAttribute         varchar(64) NOT NULL,
       RadMapTypeID         int NOT NULL,
       MapValue             varchar(64) NOT NULL,
       RadValue             int NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RadMapValues
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID, MapValue, 
              RadValue)
go


CREATE TABLE dbo.RadMergeTypes (
       RadMergeTypeID       smallint NOT NULL,
       RadMergeType         varchar(128) NOT NULL,
       StringID             int NULL,
       AllowAttr            tinyint NOT NULL DEFAULT 1
)
go

ALTER TABLE dbo.RadMergeTypes
       ADD PRIMARY KEY (RadMergeTypeID)
go


CREATE TABLE dbo.RadPoolConfigs (
	RadPoolConfigID int IDENTITY,
	InvProductID int NOT NULL,
	InvStateID int NOT NULL,
	ReleaseMins int NOT NULL DEFAULT 0,
	GroupID int NULL,
	ServiceCategoryID int NULL,
	AccountTypeID int NULL,
	MarketTagID int NULL,
	TowerID int NULL,
	ServerGroupID int NULL,
	ServerID int NULL,
	PriorityID smallint NOT NULL DEFAULT 0,
	Active tinyint NOT NULL DEFAULT 1
)
go

ALTER TABLE dbo.RadPoolConfigs
       ADD PRIMARY KEY (RadPoolConfigID)
go


CREATE TABLE dbo.RadPoolStates (
	AccountID int NOT NULL,
	AcctSessionID varchar (40) NULL,
	CallingStationID varchar(64) NULL,
	NASIdentifier varchar (45) NOT NULL,
	CreateDate datetime NOT NULL,
	RadPoolConfigID int NOT NULL,
	InvItemID int NOT NULL,
	OrigInvStateID int NOT NULL 
)
go

CREATE CLUSTERED INDEX i_RadPoolStates_FPK ON dbo.RadPoolStates
(
       AccountID,
       AcctSessionID,
       CallingStationID,
       NASIdentifier
)
go


CREATE TABLE dbo.RadProxyAttributeGroups (
       RadProxyAttributeGroupID int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Priority             int NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RadProxyAttributeGroups
       ADD PRIMARY KEY (RadProxyAttributeGroupID)
go


CREATE TABLE dbo.RadProxyAttributes (
       RadProxyAttributeID  int IDENTITY,
       RadProxyAttributeGroupID int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadSearchTypeID      smallint NOT NULL,
       String               varchar(253) NOT NULL
)
go

CREATE UNIQUE INDEX uc_RadProxyAttributes ON dbo.RadProxyAttributes
(
       RadProxyAttributeGroupID,
       RadVendorID,
       RadAttributeID,
       RadSearchTypeID,
       String
)
go


ALTER TABLE dbo.RadProxyAttributes
       ADD PRIMARY KEY (RadProxyAttributeID)
go


CREATE TABLE dbo.RadProxyRateProcs (
       Realm                varchar(64) NOT NULL,
       ProxyType            smallint NOT NULL,
       ProcDate             datetime NOT NULL,
       InBytes              bigint NULL,
       OutBytes             bigint NULL,
       UserCount            int NULL,
       SessionTime          int NULL,
       SessionCount         int NULL
)
go


ALTER TABLE dbo.RadProxyRateProcs
       ADD PRIMARY KEY (Realm, ProcDate, ProxyType)
go


CREATE TABLE dbo.RadRejectAttributes (
       RadRejectAttributeID int IDENTITY,
       IEAID                int NULL,
       ServerID             int NULL,
       RadLogMsgID          smallint NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go







ALTER TABLE dbo.RadRejectAttributes
       ADD PRIMARY KEY (RadRejectAttributeID)
go


CREATE TABLE dbo.RadRejects (
       RadRejectID          int IDENTITY,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Data                 varchar(4000) NOT NULL
)
go




ALTER TABLE dbo.RadRejects
       ADD PRIMARY KEY (RadRejectID)
go


CREATE TABLE dbo.RadRoamDomains (
       RadRoamDomainID      int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Domain               varchar(64) NOT NULL,
       Priority             int NOT NULL DEFAULT 0,
       AccountTypeID        int NULL
)
go

CREATE INDEX i_RadRoamDomains_Domain ON dbo.RadRoamDomains
(
       Domain
)
go


ALTER TABLE dbo.RadRoamDomains
       ADD PRIMARY KEY (RadRoamDomainID)
go


CREATE TABLE dbo.RadRoamServers (
       RadRoamServerID      int IDENTITY,
       IPAddress            varchar(64) NOT NULL,
       Server               varchar(32) NOT NULL,
       Secret               varchar(255) NOT NULL,
       Timeout              int NOT NULL DEFAULT 0,
       Retries              int NOT NULL DEFAULT 0,
       TreatAsLocal         smallint NOT NULL DEFAULT 0,
       StripDomain          smallint NOT NULL DEFAULT 0,
       AuthPort             int NULL,
       AcctPort             int NULL,
       RateTarget           int NULL,
       RateMax              int NULL
)
go


ALTER TABLE dbo.RadRoamServers
       ADD PRIMARY KEY (RadRoamServerID)
go


CREATE TABLE dbo.RadSearchTypes (
       RadSearchTypeID      smallint NOT NULL,
       RadSearchType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RadSearchTypes
       ADD PRIMARY KEY (RadSearchTypeID)
go


CREATE TABLE dbo.RadSourceTypes (
       RadSourceTypeID      int NOT NULL,
       RadSourceType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RadSourceTypes
       ADD PRIMARY KEY (RadSourceTypeID)
go


CREATE TABLE dbo.RadValues (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Value                bigint NOT NULL,
       Name                 varchar(128) NOT NULL
)
go





ALTER TABLE dbo.RadValues
       ADD PRIMARY KEY (RadAttributeID, RadVendorID, Value)
go


CREATE TABLE dbo.RadVendors (
       RadVendorID          int NOT NULL,
       Name                 varchar(64) NOT NULL,
       VendorURL            varchar(128) NULL,
       Description          text NULL,
       Comments             text NULL
)
go


ALTER TABLE dbo.RadVendors
       ADD PRIMARY KEY (RadVendorID)
go


CREATE TABLE dbo.RateClasses (
       RateClassID          int IDENTITY,
       RateClass            varchar(128) NOT NULL,
       AllowInterim         tinyint NULL
)
go


ALTER TABLE dbo.RateClasses
       ADD PRIMARY KEY (RateClassID)
go


CREATE TABLE dbo.RateCostTypes (
       RateCostTypeID       smallint NOT NULL,
       RateCostType         varchar(128) NOT NULL,
       Unit                 varchar(64) NOT NULL,
       CostAttribute        varchar(64) NOT NULL,
       CostUPQuery          varchar(255) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go







ALTER TABLE dbo.RateCostTypes
       ADD PRIMARY KEY (RateCostTypeID)
go


CREATE TABLE dbo.RateDataSources (
       RateDataSourceID     int NOT NULL,
       RateDataSource       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       DSN                  varchar(128) NULL,
       Username             varchar(64) NULL,
       Password             varchar(128) NULL,
       DataQuery            text NOT NULL,
       UpdateQuery          text NULL,
       UseTransactions      tinyint NOT NULL DEFAULT 1,
       UpdateInterval       smallint NOT NULL DEFAULT 0,
       BillingMode          int NULL,
       ClearQuery           text NULL
)
go




ALTER TABLE dbo.RateDataSources
       ADD PRIMARY KEY (RateDataSourceID)
go


CREATE TABLE dbo.RateHistory (
       StartDate            datetime NOT NULL,
       AccountID            int NOT NULL,
       CustomerID           int NOT NULL,
       RateRuleID           int NOT NULL,
       RateID               int NOT NULL,
       RateCostTypeID       smallint NOT NULL DEFAULT 1,
       TotalTime            int NOT NULL,
       ChargeID             int NULL,
       TotalCount           numeric(28,12) NOT NULL,
       TotalSessions        int NOT NULL DEFAULT 0,
       TotalData            bigint NOT NULL,
       TotalCost            numeric(28,12) NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RateHistory_ChargeID ON dbo.RateHistory
(
       CustomerID,
       ChargeID
)
go


ALTER TABLE dbo.RateHistory
       ADD PRIMARY KEY (StartDate, AccountID, CustomerID, RateRuleID, 
              RateID)
go


CREATE TABLE dbo.RateIntervals (
       RateIntervalID       int NOT NULL,
       RateRuleTypeID       int NOT NULL,
       NameSingular         varchar(64) NOT NULL,
       NamePlural           varchar(64) NOT NULL,
       NameShort            varchar(64) NOT NULL
)
go



ALTER TABLE dbo.RateIntervals
       ADD PRIMARY KEY (RateIntervalID)
go


CREATE TABLE dbo.RateIPPorts (
       Port                 int NOT NULL,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateIPPorts
       ADD PRIMARY KEY (Port)
go


CREATE TABLE dbo.RateIPProtocols (
       Protocol             int NOT NULL,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateIPProtocols
       ADD PRIMARY KEY (Protocol)
go


CREATE TABLE dbo.RateItems (
       RateItemID           int IDENTITY,
       RateID               int NOT NULL,
       RateRuleID           int NOT NULL,
       RateTimeGroupID      int NOT NULL
)
go

CREATE UNIQUE INDEX IX_RateItems ON dbo.RateItems
(
       RateID,
       RateRuleID,
       RateTimeGroupID
)
go




ALTER TABLE dbo.RateItems
       ADD PRIMARY KEY (RateItemID)
go


CREATE TABLE dbo.RateMatchTypes (
       RateMatchTypeID      int NOT NULL,
       RateMatchType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RateMatchTypes
       ADD PRIMARY KEY (RateMatchTypeID)
go


CREATE TABLE dbo.RateRoundTypes (
       RateRoundTypeID      int NOT NULL,
       RateRoundType        varchar(64) NOT NULL,
       AllowData            smallint NOT NULL DEFAULT 0,
       AllowTime            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.RateRoundTypes
       ADD PRIMARY KEY (RateRoundTypeID)
go


CREATE TABLE dbo.RateRules (
       RateRuleID           int IDENTITY,
       RateRule             varchar(64) NOT NULL,
       StringID             int NULL,
       RateSourceID         int NOT NULL,
       RateCostTypeID       smallint NOT NULL DEFAULT 1,
       RateRoundTypeID      int NOT NULL,
       RateTypeID           int NULL,
       RateRuleTypeID       int NOT NULL DEFAULT 1,
       Interval             int NOT NULL,
       ClassRequired        smallint NOT NULL,
       ClassTTL             int NULL,
       ClassQuery           varchar(255) NULL,
       RuleQuery            varchar(255) NULL,
       DefaultCost          numeric(28,12) NULL,
       DataAttribute        varchar(64) NULL,
       Description          text NULL
)
go








ALTER TABLE dbo.RateRules
       ADD PRIMARY KEY (RateRuleID)
go


CREATE TABLE dbo.RateRuleTypes (
       RateRuleTypeID       int NOT NULL,
       RateRuleType         varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RateRuleTypes
       ADD PRIMARY KEY (RateRuleTypeID)
go


CREATE TABLE dbo.Rates (
       RateID               int IDENTITY,
       RateSourceID         int NOT NULL,
       RateCostTypeID       smallint NOT NULL DEFAULT 1,
       Rate                 varchar(64) NOT NULL,
       MinCharge            numeric(18,4) NULL,
       MaxCharge            numeric(18,4) NULL,
       ChargeTypeID         int NULL,
       RateClassID          int NOT NULL DEFAULT 1,
       DataRateRuleID       int NULL,
       ClassifierRateRuleID int NOT NULL,
       AuthMaxTime          int NULL,
       AuthRate             smallint NULL,
       AuthRateTime         smallint NULL
)
go








ALTER TABLE dbo.Rates
       ADD PRIMARY KEY (RateID)
go


CREATE TABLE dbo.RateSourceAttributes (
       RateSourceID         int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       Description          varchar(255) NULL,
       AllowData            smallint NOT NULL DEFAULT 0,
       AllowTime            smallint NOT NULL DEFAULT 0,
       Dynamic              smallint NOT NULL DEFAULT 0,
       ValuesQuery          varchar(255) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       RateMatchTypes       int NOT NULL DEFAULT 0
)
go





ALTER TABLE dbo.RateSourceAttributes
       ADD PRIMARY KEY (RateSourceID, Attribute)
go


CREATE TABLE dbo.RateSources (
       RateSourceID         int NOT NULL,
       RateSource           varchar(255) NOT NULL,
       AllowData            smallint NOT NULL DEFAULT 1,
       AllowTime            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.RateSources
       ADD PRIMARY KEY (RateSourceID)
go


CREATE TABLE dbo.RateStatusCalls (
       LastCallInterimID    bigint NULL,
       Leader               varchar(64) NULL,
       LastUpdate           datetime NOT NULL DEFAULT 'Jan 1 2000',
       LastMessage          varchar(255) NULL,
       Advisor              varchar(64) NULL,
       LastAdviceDate       datetime NOT NULL DEFAULT 'Jan 1 2000'
)
go


CREATE TABLE dbo.RateStdGroups (
       RateStdGroupID       int IDENTITY,
       RateRuleID           int NOT NULL,
       Priority             smallint NULL,
       Cost                 numeric(28,12) NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RateStdGroups
       ADD PRIMARY KEY (RateStdGroupID)
go


CREATE TABLE dbo.RateStdItems (
       RateStdItemID        int IDENTITY,
       RateStdGroupID       int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       RateMatchTypeID      int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RateStdItems
       ADD PRIMARY KEY (RateStdItemID)
go


CREATE TABLE dbo.RateTimeGroups (
       RateTimeGroupID      int IDENTITY,
       RateTimeGroup        varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RateTimeGroups
       ADD PRIMARY KEY (RateTimeGroupID)
go


CREATE TABLE dbo.RateTimes (
       RateTimeID           int IDENTITY,
       RateTimeGroupID      int NOT NULL,
       StartHour            smallint NULL,
       StartMinute          smallint NULL,
       EndHour              smallint NULL,
       EndMinute            smallint NULL,
       DayWeekMask          int NULL,
       WeekNumMask          int NULL,
       MonthMask            int NULL,
       MonthDay             smallint NULL,
       Priority             smallint NULL,
       Description          varchar(255) NOT NULL
)
go




ALTER TABLE dbo.RateTimes
       ADD PRIMARY KEY (RateTimeID)
go


CREATE TABLE dbo.RateTypes (
       RateTypeID           int NOT NULL,
       RateType             varchar(128) NOT NULL,
       RateSourceID         int NULL,
       RuleQuery            varchar(255) NOT NULL,
       ScriptConfigure      varchar(64) NOT NULL,
       ScriptSummary        varchar(64) NOT NULL
)
go



ALTER TABLE dbo.RateTypes
       ADD PRIMARY KEY (RateTypeID)
go


CREATE TABLE dbo.RateVCondGroups (
       RateVCondGroupID     int IDENTITY,
       RateVCondGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Priority             smallint NULL
)
go


ALTER TABLE dbo.RateVCondGroups
       ADD PRIMARY KEY (RateVCondGroupID)
go


CREATE TABLE dbo.RateVCondItems (
       RateVCondItemID      int IDENTITY,
       RateVCondGroupID     int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       RateMatchTypeID      int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RateVCondItems
       ADD PRIMARY KEY (RateVCondItemID)
go


CREATE TABLE dbo.RateVDNIS (
       RateVDNISID          int IDENTITY,
       RateVDNIS            varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       Attribute            varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RateVDNIS
       ADD PRIMARY KEY (RateVDNISID)
go


CREATE TABLE dbo.RateVDNISGroupItems (
       RateVDNISGroupID     int NOT NULL,
       RateVDNISID          int NOT NULL,
       RateVCondGroupID     int NULL
)
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD PRIMARY KEY (RateVDNISGroupID, RateVDNISID)
go


CREATE TABLE dbo.RateVDNISGroups (
       RateVDNISGroupID     int IDENTITY,
       RateVDNISGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateVDNISGroups
       ADD PRIMARY KEY (RateVDNISGroupID)
go


CREATE TABLE dbo.RateVDNISImportTypes (
       RateVDNISImportTypeID int IDENTITY,
       RateVDNISImportType  varchar(128) NOT NULL,
       RegExp               varchar(1024) NOT NULL,
       Prefix               varchar(32) NULL,
       ImportQuery          text NULL,
       IEAID                int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateVDNISImportTypes
       ADD PRIMARY KEY (RateVDNISImportTypeID)
go


CREATE TABLE dbo.RateVDNISItems (
       RateVDNISItemID      int IDENTITY,
       RateVDNISID          int NOT NULL,
       RateVDNISItem        varchar(128) NULL,
       DNIS                 varchar(64) NOT NULL,
       Location             varchar(128) NULL,
       RateMatchTypeID      int NOT NULL,
       IntervalCost         numeric(28,12) NULL,
       IntervalOption       smallint NOT NULL DEFAULT 0,
       InitialCost          numeric(18,4) NULL,
       InitialOption        smallint NOT NULL DEFAULT 0,
       StaticCost           numeric(18,4) NULL,
       StaticOption         smallint NOT NULL DEFAULT 0,
       CountryID            int NULL,
       StateID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RVDI_DNIS ON dbo.RateVDNISItems
(
       DNIS
)
go




ALTER TABLE dbo.RateVDNISItems
       ADD PRIMARY KEY (RateVDNISItemID)
go


CREATE TABLE dbo.RateVRates (
       RateVRateID          int IDENTITY,
       RateVRate            varchar(128) NULL,
       RateRuleID           int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       RateVDNISID          int NULL,
       RateVDNISGroupID     int NULL,
       RateVCondGroupID     int NULL,
       Multiplier           numeric(18,4) NULL
)
go


ALTER TABLE dbo.RateVRates
       ADD PRIMARY KEY (RateVRateID)
go


CREATE TABLE dbo.ReferredBys (
       ReferredByID         int IDENTITY,
       ReferredBy           varchar(128) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.ReferredBys
       ADD PRIMARY KEY (ReferredByID)
go


CREATE TABLE dbo.RefManagers (
       RefManagerID         int IDENTITY,
       RefManager           varchar(128) NOT NULL,
       GroupID              int NULL,
       SrcMarketTagID       int NULL,
       SrcServiceCategoryID int NULL,
       SrcAccountTypeID     int NULL,
       SrcReferralsMin      int NOT NULL DEFAULT 1,
       SrcReferralsMax      int NULL,
       SrcInvoicedDaysMin   int NULL,
       SrcExtMarketTagID    int NOT NULL,
       SrcInvoicedDaysLimit int NULL,
       SrcReferralsCreditMax int NULL,
       SrcServiceLevelMin   int NULL,
       DstMarketTagID       int NULL,
       DstServiceCategoryID int NULL,
       DstAccountTypeID     int NULL,
       DstInvoicedDaysMin   int NULL,
       DstServiceLevelMin   int NULL,
       DstExtMarketTagID    int NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RefManagers
       ADD PRIMARY KEY (RefManagerID)
go


CREATE TABLE dbo.RefStates (
       RefManagerID         int NOT NULL,
       SrcAccountID         int NOT NULL,
       DstAccountID         int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastUpdate           datetime NOT NULL DEFAULT getdate(),
       StartingDays         int NOT NULL,
       LastDays             int NOT NULL,
       LastAddDays          int NOT NULL,
       CreditDays           int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RefStates
       ADD PRIMARY KEY (RefManagerID, SrcAccountID, DstAccountID)
go


CREATE TABLE dbo.RegFCC477AccountTypes (
       AccountTypeID        int NOT NULL,
       RegFCC477TechID      int NULL,
       DownMbps             numeric(9,3) NULL,
       UpMbps               numeric(9,3) NULL,
       RegFCC477VoiceTechID int NULL,
       RegFCC477VoiceTransportID int NULL,
       Residential          tinyint NOT NULL DEFAULT 1,
       VoiceInternet        tinyint NOT NULL DEFAULT 1
)
go






ALTER TABLE dbo.RegFCC477AccountTypes
       ADD PRIMARY KEY (AccountTypeID)
go


CREATE TABLE dbo.RegFCC477Techs (
       RegFCC477TechID      int NOT NULL,
       RegFCC477Tech        varchar(128) NOT NULL,
       RegFCC477VoiceTransportID   int NULL,
       Code477              int NOT NULL DEFAULT 0,
       CodeBDC              int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RegFCC477Techs
       ADD PRIMARY KEY (RegFCC477TechID)
go


CREATE TABLE dbo.RegFCC477VoiceTechs (
       RegFCC477VoiceTechID int NOT NULL,
       RegFCC477VoiceTech   varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RegFCC477VoiceTechs
       ADD PRIMARY KEY (RegFCC477VoiceTechID)
go


CREATE TABLE dbo.RegFCC477VoiceTransports (
       RegFCC477VoiceTransportID int NOT NULL,
       RegFCC477VoiceTransport varchar(128) NOT NULL
)
go

ALTER TABLE dbo.RegFCC477VoiceTransports
       ADD PRIMARY KEY (RegFCC477VoiceTransportID)
go


CREATE TABLE dbo.RegFCCBLProviders (
       RegFCCBLProviderID      int IDENTITY,
       RegFCCBLProvider        varchar(128) NOT NULL,
       RegistrationNumber      varchar(32) NOT NULL,
       DataAllowancePolicyURL  varchar(255) NULL,
       NetworkManagementPolicyURL varchar(255) NOT NULL,
       PrivacyPolicyURL        varchar(255) NOT NULL,
       CustomerSupportPhone    varchar(32) NOT NULL,
       CustomerSupportURL      varchar(255) NOT NULL,
       BundleDescription       text NULL,
       BundleStringID          int NULL,
       BundleDiscountsURL      varchar(255) NULL,
       SortOrder               smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.RegFCCBLProviders
       ADD PRIMARY KEY (RegFCCBLProviderID)
go


CREATE TABLE dbo.RegFCCBLContracts (
       RegFCCBLContractID      int IDENTITY,
       RegFCCBLContract        varchar(128) NOT NULL,
       ContractRequired        tinyint NOT NULL DEFAULT 0,
       ContractMonths	       int NOT NULL,
       EarlyTerminationFee     numeric(18,4) NULL,
       ContractTermsURL        varchar(255) NULL,
       SortOrder               smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.RegFCCBLContracts
       ADD PRIMARY KEY (RegFCCBLContractID)
go


CREATE TABLE dbo.RegFCCBLCharges (
       RegFCCBLChargeID      int IDENTITY,
       RegFCCBLCharge        varchar(128) NOT NULL,
       SortOrder             smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.RegFCCBLCharges
       ADD PRIMARY KEY (RegFCCBLChargeID)
go


CREATE TABLE dbo.RegFCCBLChargeItems (
       RegFCCBLChargeItemID      int IDENTITY,
       RegFCCBLChargeID          int NOT NULL,
       RegFCCBLChargeItem        varchar(128) NULL,
       StringID                  int NULL,
       Recurring                 tinyint NOT NULL DEFAULT 0,
       AccountTypeID             int NULL,
       ChargeTypeID              int NULL,
       Cost                      numeric(18,4) NULL,
       SortOrder                 smallint NOT NULL DEFAULT 0,
       DiscountID                int NULL
)
go

ALTER TABLE dbo.RegFCCBLChargeItems
       ADD PRIMARY KEY (RegFCCBLChargeItemID)
go

CREATE INDEX i_RegFCCBLChargeItems_CID ON dbo.RegFCCBLChargeItems
(
       RegFCCBLChargeID
)
go

CREATE TABLE dbo.RegFCCBLAccountTypes (
       OrganizationID             int NOT NULL,
       AccountTypeID              int NOT NULL,
       RegFCCBLProviderID         int NULL,
       RegFCCBLContractID         int NULL,
       RegFCCBLChargeID           int NULL,
       TypicalDownMbps            numeric(9,3) NOT NULL DEFAULT 0,
       TypicalUpMbps              numeric(9,3) NOT NULL DEFAULT 0,
       TypicalLatency             int NOT NULL DEFAULT 0,
       IntroRateMonths            int NULL,
       IntroRateCost              numeric(18,4) NULL,
       TaxAmount                  numeric(18,4) NULL,
       MonthlyDataLimit           numeric(9,3) NULL,
       AdditionalDataCost         numeric(18,4) NULL,
       AdditionalDataIncrement    numeric(9,3) NULL,
       CreateDate                 datetime NOT NULL DEFAULT getdate(),
       CreateUser                 varchar(64) NOT NULL DEFAULT suser_name()
)
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD PRIMARY KEY (OrganizationID, AccountTypeID)
go



CREATE TABLE dbo.Regions (
       RegionID             int IDENTITY,
       Region               varchar(64) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       RegionGroupID        int NULL,
       ExternalRef          varchar(64) NULL
)
go

ALTER TABLE dbo.Regions
       ADD PRIMARY KEY (RegionID)
go

CREATE TABLE dbo.RegionGroups (
       RegionGroupID        int IDENTITY,
       RegionGroup          varchar(128) NOT NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.RegionGroups
       ADD PRIMARY KEY (RegionGroupID)
go

CREATE TABLE dbo.ReportDataTypes (
       ReportDataTypeID     smallint NOT NULL,
       ReportDataType       varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ReportDataTypes
       ADD PRIMARY KEY (ReportDataTypeID)
go


CREATE TABLE dbo.ReportFields (
       ReportFieldID        int NOT NULL,
       ReportField          varchar(128) NOT NULL,
       StringID             int NULL,
       Description          varchar(255) NULL,
       FieldName            varchar(64) NOT NULL,
       CRFieldName          varchar(128) NULL,
       ReportDataTypeID     smallint NOT NULL,
       DefaultValue         varchar(255) NULL,
       EWSFile              varchar(64) NULL
)
go



ALTER TABLE dbo.ReportFields
       ADD PRIMARY KEY (ReportFieldID)
go


CREATE TABLE dbo.ReportGroups (
       ReportGroupID        int NOT NULL,
       ReportGroupTypeID    int NOT NULL,
       ReportGroup          varchar(128) NOT NULL,
       StringID             int NULL,
       AccessLabel          varchar(64) NULL,
       Class                varchar(64) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       FeatureID            int NULL
)
go




ALTER TABLE dbo.ReportGroups
       ADD PRIMARY KEY (ReportGroupID)
go


CREATE TABLE dbo.ReportGroupTypes (
       ReportGroupTypeID    int NOT NULL,
       ReportGroupType      varchar(128) NOT NULL
)
go



ALTER TABLE dbo.ReportGroupTypes
       ADD PRIMARY KEY (ReportGroupTypeID)
go


CREATE TABLE dbo.ReportParameters (
       ReportID             int NOT NULL,
       ReportFieldID        int NOT NULL,
       Required             smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.ReportParameters
       ADD PRIMARY KEY (ReportID, ReportFieldID)
go


CREATE TABLE dbo.Reports (
       ReportID             int IDENTITY,
       ReportTypeID         int NOT NULL,
       ReportGroupID        int NOT NULL,
       Report               varchar(128) NOT NULL,
       ReportQuery          text NULL,
       FileName             varchar(45) NULL,
       AccessLabel          varchar(64) NULL,
       ColGroup             varchar(128) NULL,
       ColSum               varchar(128) NULL,
       ColMin               varchar(128) NULL,
       ColMax               varchar(128) NULL,
       ColCount             varchar(128) NULL,
       ColOrder             varchar(128) NULL,
       ColAvg               varchar(128) NULL,
       Col2Group            varchar(128) NULL,
       Col2Sum              varchar(128) NULL,
       Col2Min              varchar(128) NULL,
       Col2Max              varchar(128) NULL,
       Col2Count            varchar(128) NULL,
       Col2Order            varchar(128) NULL,
       Col2Avg              varchar(128) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       IEAID                int NULL,
       OrderBy              varchar(128) NULL
)
go






ALTER TABLE dbo.Reports
       ADD PRIMARY KEY (ReportID)
go


CREATE TABLE dbo.ReportTypes (
       ReportTypeID         int NOT NULL,
       ReportType           varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ReportTypes
       ADD PRIMARY KEY (ReportTypeID)
go


CREATE TABLE dbo.ResellerUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       AccountID            int NOT NULL,
       AccountTypeID        int NOT NULL,
       Days                 float NOT NULL DEFAULT 0,
       LastUpdate           datetime NOT NULL DEFAULT getdate(),
       ItemID               int NULL
)
go

CREATE INDEX i_ResellerUsage_AccountID ON dbo.ResellerUsage
(
       AccountID,
       StartYear,
       StartMonth
)
go

CREATE INDEX i_ResellerUsage_ItemID ON dbo.ResellerUsage
(
       ItemID
)
go


ALTER TABLE dbo.ResellerUsage
       ADD PRIMARY KEY (StartYear, StartMonth, AccountID, 
              AccountTypeID)
go


CREATE TABLE dbo.RoleAssignTypes (
       RoleAssignTypeID     int NOT NULL,
       RoleAssignType       varchar(128) NOT NULL,
       RoleTypeMask         int NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.RoleAssignTypes
       ADD PRIMARY KEY (RoleAssignTypeID)
go


CREATE TABLE dbo.Roles (
       RoleID               int IDENTITY,
       Role                 varchar(128) NOT NULL,
       GroupID              int NULL,
       RoleAssignTypeID     int NOT NULL,
       RoleTypeID           int NOT NULL DEFAULT 1,
       AccessLabelID        int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Email                varchar(80) NULL
)
go







ALTER TABLE dbo.Roles
       ADD PRIMARY KEY (RoleID)
go


CREATE TABLE dbo.RoleTypes (
       RoleTypeID           int NOT NULL,
       RoleType             varchar(128) NOT NULL
)
go



ALTER TABLE dbo.RoleTypes
       ADD PRIMARY KEY (RoleTypeID)
go


CREATE TABLE dbo.SalesPersons (
       SalesPersonID        int IDENTITY,
       SalesPerson          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Active               tinyint NOT NULL DEFAULT 1,
       OperatorID           int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       CommissionGroupID    int NULL,
       CommissionValue      numeric(18,4) NULL
)
go

CREATE UNIQUE INDEX iSalesPersons_SalesPerson ON dbo.SalesPersons
(
       SalesPerson
)
go

CREATE INDEX I_SalesPersons_SPCG ON dbo.SalesPersons
(
       SalesPersonID,
       CommissionGroupID
)
go








ALTER TABLE dbo.SalesPersons
       ADD PRIMARY KEY (SalesPersonID)
go


CREATE TABLE dbo.SchedBlocks (
       SchedBlockID         int IDENTITY,
       SchedBlock           varchar(128) NOT NULL,
       StringID             int NULL,
       SchedBlockTypeID     int NOT NULL,
       SchedTimeID          int NOT NULL,
       GroupID              int NULL,
       MarketTagID          int NULL,
       StartHour            tinyint NULL,
       StartMinute          tinyint NULL,
       Minutes              int NULL,
       TimeUnits            int NOT NULL,
       Quantity             int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       Comments             text NULL
)
go









ALTER TABLE dbo.SchedBlocks
       ADD PRIMARY KEY (SchedBlockID)
go


CREATE TABLE dbo.SchedBlockTypes (
       SchedBlockTypeID     int IDENTITY,
       SchedBlockType       varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.SchedBlockTypes
       ADD PRIMARY KEY (SchedBlockTypeID)
go


CREATE TABLE dbo.SchedTimeItems (
       SchedTimeItemID      int IDENTITY,
       SchedTimeItem        varchar(128) NOT NULL,
       SchedTimeID          int NOT NULL,
       AccessTime           varchar(128) NOT NULL,
       Include              tinyint NOT NULL DEFAULT 1,
       Comments             text NULL
)
go



ALTER TABLE dbo.SchedTimeItems
       ADD PRIMARY KEY (SchedTimeItemID)
go


CREATE TABLE dbo.SchedTimes (
       SchedTimeID          int IDENTITY,
       SchedTime            varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.SchedTimes
       ADD PRIMARY KEY (SchedTimeID)
go


CREATE TABLE dbo.ScheduleIntervals (
       Interval             varchar(32) NOT NULL,
       Seconds              int NOT NULL
)
go



ALTER TABLE dbo.ScheduleIntervals
       ADD PRIMARY KEY (Interval)
go


CREATE TABLE dbo.ScheduleLogs (
       ScheduleID           int NOT NULL,
       ScheduleServerID     int NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       Status               smallint NOT NULL,
       Description          varchar(255) NULL
)
go

CREATE CLUSTERED INDEX i_ScheduleLogs_SD_SID ON dbo.ScheduleLogs
(
       StartDate,
       ScheduleID
)
go







CREATE TABLE dbo.Schedules (
       ScheduleID           int IDENTITY,
       Server               varchar(64) NULL,
       ScheduleServerID     int NULL,
       TaskName             varchar(32) NOT NULL,
       Parameter            varchar(255) NULL,
       TargetSecs           int NULL,
       MaxSecs              int NULL,
       Status               tinyint NOT NULL DEFAULT 0,
       LastStatus           varchar(255) NULL,
       LastStart            datetime NULL,
       LastUpdate           datetime NULL,
       Interval             int NOT NULL DEFAULT 0,
       StartDate            datetime NULL,
       Aligned              tinyint NOT NULL DEFAULT 0,
       Description          varchar(100) NULL,
       LockServerID         int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       MaxConcurrent        int NOT NULL DEFAULT 1,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Operator             varchar(64) NULL DEFAULT suser_name(),
       Retries              int NOT NULL DEFAULT 0,
       LockDate             datetime NULL
)
go

ALTER TABLE dbo.Schedules
       ADD PRIMARY KEY (ScheduleID)
go

CREATE INDEX i_Schedules_Active ON dbo.Schedules
(
       Active
)
go


CREATE TABLE dbo.ScheduleServers (
       Server               varchar(64) NOT NULL,
       ScheduleServerID     int IDENTITY,
       IPAddress            varchar(64) NULL,
       Port                 int NOT NULL,
       Description          varchar(100) NULL,
       LastStart            datetime NULL DEFAULT getdate(),
       Signal               smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.ScheduleServers
       ADD PRIMARY KEY (Server)
go


CREATE TABLE dbo.ScheduleTasks (
       TaskName             varchar(32) NOT NULL,
       TaskType             varchar(32) NULL,
       Description          varchar(255) NULL
)
go

ALTER TABLE dbo.ScheduleTasks
       ADD PRIMARY KEY (TaskName)
go

CREATE TABLE dbo.SearchFieldGroups (
       SearchFieldGroupID int NOT NULL,
       SearchFieldGroup   varchar(128) NOT NULL,
       StringID           int NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.SearchFieldGroups
       ADD PRIMARY KEY (SearchFieldGroupID)
go

CREATE TABLE dbo.SearchFields (
       SearchFieldID      int NOT NULL,
       SearchField        varchar(128) NOT NULL,
       StringID           int NULL,
       SearchFieldGroupID int NOT NULL,
       FormEWS            text NULL,
       SelectEWS          text NULL,
       JoinEWS            text NULL,
       FilterEWS          text NULL,
       AccessLabelID      int NULL,
       SortOrder          smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.SearchFields
       ADD PRIMARY KEY (SearchFieldID)
go


CREATE TABLE dbo.SearchConditions (
       SearchConditionID      int NOT NULL,
       SearchCondition        varchar(128) NOT NULL,
       StringID               int NULL
)
go

ALTER TABLE dbo.SearchConditions
       ADD PRIMARY KEY (SearchConditionID)
go


CREATE TABLE dbo.Searches (
       SearchID       int IDENTITY,
       Search         varchar(128) NOT NULL,
       OperatorID     int NOT NULL,
       SortOrder      smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.Searches
       ADD PRIMARY KEY (SearchID)
go

CREATE TABLE dbo.SearchItems (
       SearchItemID       int IDENTITY,
       SearchID           int NOT NULL,
       SearchFieldID      int NOT NULL,
       AccountDataTypeID  int NULL,
       AddressDataTypeID  int NULL,
       SearchConditionID  int NULL,
       ApplyMask          int NOT NULL,
       DefaultData        varchar(512),
       SortOrder          smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.SearchItems
       ADD PRIMARY KEY NONCLUSTERED (SearchItemID)
go

CREATE CLUSTERED INDEX I_SearchItems_SID ON dbo.SearchItems
(
       SearchID
)
go



CREATE TABLE dbo.SearchQueries (
       SearchQueryID        int NOT NULL,
       SearchQuery          varchar(128) NOT NULL,
       SearchTypeID         int NOT NULL,
       SQLQuery             text NOT NULL,
       FeatureID            int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go






ALTER TABLE dbo.SearchQueries
       ADD PRIMARY KEY (SearchQueryID)
go


CREATE TABLE dbo.SearchTypes (
       SearchTypeID         int NOT NULL,
       SearchType           varchar(128) NOT NULL
)
go


ALTER TABLE dbo.SearchTypes
       ADD PRIMARY KEY (SearchTypeID)
go


CREATE TABLE dbo.ServiceLevelTypes (
	ServiceLevelTypeID int IDENTITY,
	ServiceLevelType varchar (128) NOT NULL,
	Description text NULL,
	SortOrder smallint NOT NULL DEFAULT 0
)
go

ALTER TABLE dbo.ServiceLevelTypes
       ADD PRIMARY KEY (ServiceLevelTypeID)
go


CREATE TABLE dbo.ServiceCatAccess (
	ServiceCatAccessID int IDENTITY,
	ServiceCategoryID int NOT NULL,
	OperatorGroupID int NOT NULL,
	BulkProfileID int NULL 
)
go

ALTER TABLE dbo.ServiceCatAccess
       ADD PRIMARY KEY NONCLUSTERED (ServiceCatAccessID)
go

CREATE CLUSTERED INDEX i_ServiceCatAccess_SCID_OGID ON dbo.ServiceCatAccess
(
	ServiceCategoryID,
	OperatorGroupID
)
go


CREATE TABLE dbo.ServiceCatATAccess (
	ServiceCatATAccessID int IDENTITY,
	ServiceCategoryID int NOT NULL,
	AccountTypeID int NOT NULL,
	OperatorGroupID int NOT NULL,
	BulkProfileID int NULL 
)
go

ALTER TABLE dbo.ServiceCatATAccess
       ADD PRIMARY KEY NONCLUSTERED (ServiceCatATAccessID)
go

CREATE CLUSTERED INDEX i_ServiceCatATAccess_SCID_ATID_OGID ON dbo.ServiceCatATAccess
(
	ServiceCategoryID,
	AccountTypeID,
	OperatorGroupID
)
go


CREATE TABLE dbo.SectionAccountTypes (
       AccountTypeID        int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go




ALTER TABLE dbo.SectionAccountTypes
       ADD PRIMARY KEY (AccountTypeID, SectionObjectID)
go


CREATE TABLE dbo.SectionAddressTypes (
       AddressTypeID        int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go




ALTER TABLE dbo.SectionAddressTypes
       ADD PRIMARY KEY (AddressTypeID, SectionObjectID)
go


CREATE TABLE dbo.SectionAreas (
       SectionAreaID        int NOT NULL,
       SectionArea          varchar(128) NOT NULL,
       Prefix               varchar(32) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       StringID             int NULL
)
go





ALTER TABLE dbo.SectionAreas
       ADD PRIMARY KEY (SectionAreaID)
go


CREATE TABLE dbo.SectionFeatures (
       FeatureID            int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              smallint NULL
)
go


ALTER TABLE dbo.SectionFeatures
       ADD PRIMARY KEY (FeatureID, SectionObjectID)
go


CREATE TABLE dbo.SectionGlobals (
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go



ALTER TABLE dbo.SectionGlobals
       ADD PRIMARY KEY (SectionObjectID)
go


CREATE TABLE dbo.SectionGroups (
       GroupID              int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go




ALTER TABLE dbo.SectionGroups
       ADD PRIMARY KEY (GroupID, SectionObjectID)
go


CREATE TABLE dbo.SectionLocations (
       SectionLocationID    int NOT NULL,
       SectionLocation      varchar(128) NOT NULL,
       Prefix               varchar(32) NOT NULL,
       Description          varchar(1024) NULL,
       AllowAccountType     tinyint NOT NULL DEFAULT 0,
       AllowOperator        tinyint NOT NULL DEFAULT 1,
       AllowOperatorGroup   tinyint NOT NULL DEFAULT 1,
       AllowGroup           tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       StringID             int NULL
)
go

CREATE INDEX i_SectionLocations_Prefix ON dbo.SectionLocations
(
       Prefix
)
go








ALTER TABLE dbo.SectionLocations
       ADD PRIMARY KEY (SectionLocationID)
go


CREATE TABLE dbo.SectionNameGroups (
       SectionNameGroupID   int NOT NULL,
       SectionNameGroup     varchar(128) NOT NULL,
       Description          varchar(1024) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.SectionNameGroups
       ADD PRIMARY KEY (SectionNameGroupID)
go


CREATE TABLE dbo.SectionNames (
       SectionNameGroupID   int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go


ALTER TABLE dbo.SectionNames
       ADD PRIMARY KEY (SectionNameGroupID, SectionObjectID)
go


CREATE TABLE dbo.SectionObjects (
       SectionObjectID      int IDENTITY,
       SectionLocationID    int NOT NULL,
       SectionAreaID        int NOT NULL,
       SectionObject        varchar(128) NOT NULL,
       Description          varchar(1024) NULL,
       StringID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX UC_SectionObjects_LAO ON dbo.SectionObjects
(
       SectionLocationID,
       SectionAreaID,
       SectionObject
)
go







ALTER TABLE dbo.SectionObjects
       ADD PRIMARY KEY (SectionObjectID)
go


CREATE TABLE dbo.SectionOperatorGroups (
       OperatorGroupID      int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go




ALTER TABLE dbo.SectionOperatorGroups
       ADD PRIMARY KEY (OperatorGroupID, SectionObjectID)
go


CREATE TABLE dbo.SectionOperators (
       OperatorID           int NOT NULL,
       SectionObjectID      int NOT NULL,
       Enabled              tinyint NULL
)
go




ALTER TABLE dbo.SectionOperators
       ADD PRIMARY KEY (OperatorID, SectionObjectID)
go


CREATE TABLE dbo.SendMethods (
       SendMethodID         int IDENTITY,
       SendMethod           varchar(128) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       AccessLabelID        int NULL,
       ChargeTypeID         int NULL,
       PrintTypeID          smallint NULL,
       EmailTypeID          smallint NULL,
       PrintAutoTrans       tinyint NOT NULL DEFAULT 0,
       EmailAutoTrans       tinyint NOT NULL DEFAULT 0,
       PrintStmtAmount      numeric(18,4) NULL,
       EmailStmtAmount      numeric(18,4) NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL,
       PrintStatement       tinyint NULL,
       PrintInvoice         tinyint NULL,
       EmailStatement       tinyint NULL,
       EmailInvoice         tinyint NULL
)
go

ALTER TABLE dbo.SendMethods
       ADD PRIMARY KEY (SendMethodID)
go


CREATE TABLE dbo.ServerAccess (
       ServerAccessID       int IDENTITY,
       ServerID             int NULL,
       AccountTypeID        int NULL,
       Allowed              smallint NOT NULL DEFAULT 1,
       MaxSessionLength     int NULL DEFAULT 0,
       AccessTime1          varchar(128) NULL,
       AccessTime2          varchar(128) NULL,
       AccessTime3          varchar(128) NULL,
       Comments             text NULL
)
go




ALTER TABLE dbo.ServerAccess
       ADD PRIMARY KEY (ServerAccessID)
go


CREATE TABLE dbo.ServerGroups (
       ServerGroupID        int IDENTITY,
       ServerGroup          varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ServerGroups
       ADD PRIMARY KEY (ServerGroupID)
go


CREATE TABLE dbo.ServerPorts (
       CallStartID          bigint NOT NULL,
       AccountID            int NULL,
       AcctSessionTime      int NOT NULL DEFAULT 0,
       AcctInputOctets      bigint NOT NULL,
       AcctOutputOctets     bigint NOT NULL,
       Authorized           tinyint NULL
)
go

CREATE UNIQUE CLUSTERED INDEX i_ServerPorts_CallStartID ON ServerPorts
(
       CallStartID
) WITH IGNORE_DUP_KEY
go

CREATE INDEX i_ServerPorts_AccountID ON dbo.ServerPorts
(
       AccountID
)
go




CREATE TABLE dbo.Servers (
       ServerID             int IDENTITY,
       ServerGroupID        int NOT NULL,
       SiteID               int NULL,
       Server               varchar(32) NOT NULL,
       ServerTypeID         int NOT NULL,
       IPAddress            varchar(64) NOT NULL,
       Location             varchar(128) NULL,
       Ports                int NULL DEFAULT 0,
       PhoneNumber          varchar(32) NULL,
       ContactName          varchar(64) NULL,
       ContactPhone         varchar(32) NULL,
       Comments             varchar(1024) NULL,
       Secret               varchar(255) NULL DEFAULT null,
       ServerPassword       varchar(255) NULL,
       Community            varchar(32) NULL DEFAULT null,
       RadRoamServerID      int NULL,
       CheckAccess          tinyint NOT NULL DEFAULT 0,
       Concurrency          tinyint NOT NULL DEFAULT 1,
       ProbeCOAInterval     int NULL,
       AuthPort             int NULL,
       AcctPort             int NULL,
       DisconnectPort       int NULL,
       DisconnectType       int NULL
)
go

CREATE UNIQUE INDEX iIPAddress ON dbo.Servers
(
       IPAddress
)
go

CREATE INDEX i_Servers_SiteID ON dbo.Servers
(
       SiteID
)
go











ALTER TABLE dbo.Servers
       ADD PRIMARY KEY (ServerID)
go


CREATE TABLE dbo.ServerTypes (
       ServerTypeID         int NOT NULL,
       ServerType           varchar(128) NOT NULL,
       Vendor               varchar(128) NULL
)
go




ALTER TABLE dbo.ServerTypes
       ADD PRIMARY KEY (ServerTypeID)
go


CREATE TABLE dbo.ServiceCatAccountTypes (
       ServiceCategoryID    int NOT NULL,
       AccountTypeID        int NOT NULL,
       Cost1                numeric(18,4) NULL,
       MaxQty1              int NULL,
       Cost2                numeric(18,4) NULL,
       MaxQty2              int NULL,
       Cost3                numeric(18,4) NULL,
       MaxQty3              int NULL,
       Cost4                numeric(18,4) NULL,
       MaxQty4              int NULL,
       AllowCustCancel      tinyint NOT NULL DEFAULT 0,
       AllowCustChangeLogin tinyint NOT NULL DEFAULT 0,
       AllowCustChangePass  tinyint NOT NULL DEFAULT 0,
       AllowCustAdd         tinyint NOT NULL DEFAULT 0,
       AllowCustUpgrade     tinyint NOT NULL DEFAULT 0,
       AllowCustDowngrade   tinyint NOT NULL DEFAULT 0,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       CustomerMax          int NULL DEFAULT 0,
       ServiceLevel         int NOT NULL DEFAULT 0,
       CustomerDescription  text NULL,
       CustServiceLevelTypeID int
)
go


ALTER TABLE dbo.ServiceCatAccountTypes
       ADD PRIMARY KEY (ServiceCategoryID, AccountTypeID)
go


CREATE TABLE dbo.ServiceCategories (
       ServiceCategoryID    int IDENTITY,
       ServiceCategory      varchar(128) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       AccessLabelID        int NULL,
       AllowRoot            tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go








ALTER TABLE dbo.ServiceCategories
       ADD PRIMARY KEY (ServiceCategoryID)
go


CREATE TABLE dbo.ServiceCatLinks (
       ParentServiceCategoryID int NOT NULL,
       ServiceCategoryID    int NOT NULL
)
go



ALTER TABLE dbo.ServiceCatLinks
       ADD PRIMARY KEY (ServiceCategoryID, ParentServiceCategoryID)
go


CREATE TABLE dbo.ServiceCatParentAccountTypes (
       ParentServiceCategoryID int NOT NULL,
       ServiceCategoryID    int NOT NULL,
       AccountTypeID        int NOT NULL,
       Cost1                numeric(18,4) NULL,
       MaxQty1              int NULL,
       Cost2                numeric(18,4) NULL,
       MaxQty2              int NULL,
       Cost3                numeric(18,4) NULL,
       MaxQty3              int NULL,
       Cost4                numeric(18,4) NULL,
       MaxQty4              int NULL
)
go




ALTER TABLE dbo.ServiceCatParentAccountTypes
       ADD PRIMARY KEY (ParentServiceCategoryID, ServiceCategoryID, 
              AccountTypeID)
go


CREATE TABLE dbo.ServiceGroupItems (
       ServiceGroupID       int NOT NULL,
       GroupID              int NOT NULL
)
go

CREATE INDEX i_ServiceGroupItems_GroupID ON dbo.ServiceGroupItems
(
       GroupID
)
go


ALTER TABLE dbo.ServiceGroupItems
       ADD PRIMARY KEY (ServiceGroupID, GroupID)
go


CREATE TABLE dbo.ServiceGroups (
       ServiceGroupID       int IDENTITY,
       ServiceGroup         varchar(128) NOT NULL,
       Description          text NULL,
       AllowAccountTypes    tinyint NOT NULL DEFAULT 1,
       AllowServiceCategories tinyint NOT NULL DEFAULT 1,
       AllowBillingCycles   tinyint NOT NULL DEFAULT 1,
       AllowRegions         tinyint NOT NULL DEFAULT 1,
       AllowDomains         tinyint NOT NULL DEFAULT 1,
       AllowPayPeriods      tinyint NOT NULL DEFAULT 1,
       AllowChargeTypes     tinyint NOT NULL DEFAULT 1,
       AllowSalesPersons    tinyint NOT NULL DEFAULT 1,
       AllowMarketTags      tinyint NOT NULL DEFAULT 1,
       AllowSendMethods     tinyint NOT NULL DEFAULT 1,
       AllowIncidentTypes   tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       AllowLateFees        tinyint NOT NULL DEFAULT 1,
       AllowMasterAccountDataTypes   tinyint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.ServiceGroups
       ADD PRIMARY KEY (ServiceGroupID)
go


CREATE TABLE dbo.SignupOptions (
       SignupOptionID       int IDENTITY,
       SignupOption         varchar(128) NOT NULL,
       SignupServerID       int NOT NULL,
       ServiceCategoryID    int NOT NULL,
       AccountTypeID        int NOT NULL,
       TimeChargeID         INT NULL,
       BillingCycleID       int NOT NULL,
       PayPeriodID          int NOT NULL,
       MarketTagID          int NULL,
       SetupCharge          tinyint NOT NULL DEFAULT 1,
       CustomerDescription  text NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX i_SignupOptions_SS_SC_AT ON dbo.SignupOptions
(
       SignupServerID,
       ServiceCategoryID,
       AccountTypeID,
       TimeChargeID,
       PayPeriodID
)
go

ALTER TABLE dbo.SignupOptions
       ADD PRIMARY KEY (SignupOptionID)
go


CREATE TABLE dbo.SignupServers (
       SignupServerID       int IDENTITY,
       SignupServer         varchar(128) NOT NULL,
       Title                varchar(128) NULL,
       ThemeID              int NOT NULL,
       GroupID              int NOT NULL,
       RegionID             int NOT NULL,
       CountryID            int NULL,
       SalesPersonID        int NULL,
       DomainID             int NOT NULL,
       SendMethodID         int NOT NULL,
       AddressTypeID        int NOT NULL,
       AltAddressTypeID     int NULL,
       PaymentTypes         int NOT NULL DEFAULT 41,
       ShowCompany          tinyint NOT NULL DEFAULT 1,
       ShowAddress          tinyint NOT NULL DEFAULT 1,
       ShowPhone            tinyint NOT NULL DEFAULT 1,
       ShowEmail            tinyint NOT NULL DEFAULT 1,
       ShowReferredBy       tinyint NOT NULL DEFAULT 1,
       LoginFillType        tinyint NOT NULL DEFAULT 0,
       ShowLogin            tinyint NOT NULL DEFAULT 1,
       PrepaidTransfer      tinyint NOT NULL DEFAULT 1,
       Comments             text NULL,
       ShowStartDate        tinyint NOT NULL DEFAULT 0,
       ShowPhoneMobile      tinyint NOT NULL DEFAULT 1
)
go

CREATE UNIQUE INDEX i_SignupServers_ThemeID ON dbo.SignupServers
(
       ThemeID
)
go


ALTER TABLE dbo.SignupServers
       ADD PRIMARY KEY (SignupServerID)
go


CREATE TABLE dbo.Sites (
       SiteID               int IDENTITY,
       Site                 varchar(128) NOT NULL,
       PhysicalAddressID    int NULL,
       ContactAddressID     int NULL,
       Description          text NULL,
       Comments             text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go




ALTER TABLE dbo.Sites
       ADD PRIMARY KEY (SiteID)
go


CREATE TABLE dbo.SMSPollers (
       SMSPollerID          int NOT NULL DEFAULT 0,
       SMSPoller            varchar(128) NOT NULL,
       PollSerialPort       varchar(128) NULL,
       PollSerialSetting    varchar(128) NULL,
       PollMode             smallint NULL,
       PollReconfigInterval int NULL,
       PollATTimeout        int NULL,
       PollWriteTimeout     int NULL,
       PollDebugFlag        int NULL,
       PollStatusInterval   int NULL,
       PollLogFile          varchar(128) NULL,
       PollAllowWrite       smallint NULL,
       PollWriteCharset     smallint NULL,
       SMPPServer           varchar(64) NULL,
       SMPPPort             int NULL,
       SMPPTransport        int NULL,
       SMPPServerBackup     varchar(64) NULL,
       SMPPSystemID         varchar(64) NULL,
       SMPPPortBackup       int NULL,
       SMPPPassword         varchar(200) NULL,
       SMPPAddressRange     varchar(255) NULL,
       SMPPRateLimit        int NULL,
       SMPPSourceAddress    varchar(32) NULL,
       SMPPSystemType       varchar(64) NULL,
       SMPPDstTON           int NOT NULL DEFAULT 1,
       SMPPDstNPI           int NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.SMSPollers
       ADD PRIMARY KEY (SMSPollerID)
go


CREATE TABLE dbo.SMSREActions (
       SMSREActionID        int NOT NULL,
       SMSREAction          varchar(128) NOT NULL
)
go



ALTER TABLE dbo.SMSREActions
       ADD PRIMARY KEY (SMSREActionID)
go


CREATE TABLE dbo.SMSREGroups (
       SMSREGroupID         int IDENTITY,
       SMSREGroup           varchar(128) NOT NULL,
       SMSREGroupTypeID     int NOT NULL DEFAULT 1,
       SMSPollerID          int NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       IEAID                int NULL
)
go





ALTER TABLE dbo.SMSREGroups
       ADD PRIMARY KEY (SMSREGroupID)
go


CREATE TABLE dbo.SMSREGroupTypes (
       SMSREGroupTypeID     int NOT NULL,
       SMSREGroupType       varchar(128) NOT NULL
)
go


ALTER TABLE dbo.SMSREGroupTypes
       ADD PRIMARY KEY (SMSREGroupTypeID)
go


CREATE TABLE dbo.SMSREItems (
       SMSREItemID          int IDENTITY,
       SMSREItem            varchar(128) NOT NULL,
       SMSREGroupID         int NOT NULL,
       SMSRESourceID        int NOT NULL,
       SMSREActionID        int NOT NULL,
       Expression           varchar(512) NOT NULL,
       LogQuery             varchar(512) NULL,
       Comments             text NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       IEAID                int NULL
)
go






ALTER TABLE dbo.SMSREItems
       ADD PRIMARY KEY (SMSREItemID)
go


CREATE TABLE dbo.SMSRESources (
       SMSRESourceID        int NOT NULL,
       SMSRESource          varchar(128) NOT NULL
)
go


ALTER TABLE dbo.SMSRESources
       ADD PRIMARY KEY (SMSRESourceID)
go


CREATE TABLE dbo.SMSStatus (
       SMSPollerID          int NOT NULL,
       IMSI                 varchar(32) NULL,
       Revision             varchar(128) NULL,
       Model                varchar(128) NULL,
       Vendor               varchar(128) NULL,
       SerialNumber         varchar(128) NULL,
       SerialPort           varchar(128) NULL,
       PollState            smallint NULL,
       PollAction           smallint NULL,
       PollMode             smallint NULL,
       Reads                int NULL,
       Writes               int NULL,
       Uptime               int NULL,
       CapPoll              varchar(64) NULL,
       CapInterrupt         varchar(64) NULL,
       LastError            varchar(255) NULL,
       LastModifyDate       datetime NULL,
       Restart              tinyint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.SMSStatus
       ADD PRIMARY KEY (SMSPollerID)
go


CREATE TABLE dbo.SMSWrites (
       SMSWriteID           int IDENTITY,
       SMSWriteStateID      tinyint NOT NULL DEFAULT 0,
       SMSPollerID          int NOT NULL DEFAULT 0,
       SendDate             datetime NOT NULL DEFAULT getdate(),
       SMSNumber            varchar(32) NOT NULL,
       Message              varchar(1024) NOT NULL,
       Realtime             tinyint NOT NULL DEFAULT 0,
       ExpireSecs           int NOT NULL DEFAULT 3600,
       StatusMsg            varchar(128) NULL,
       StatusDate           datetime NULL
)
go

CREATE INDEX i_SMSWrites_SendDate ON dbo.SMSWrites
(
       SendDate,
       SMSWriteStateID
)
go

CREATE INDEX i_SMSWrites_SMSNumber ON dbo.SMSWrites
(
       SMSNumber
)
go






ALTER TABLE dbo.SMSWrites
       ADD PRIMARY KEY (SMSWriteID)
go


CREATE TABLE dbo.SMSWriteStates (
       SMSWriteStateID      tinyint NOT NULL,
       SMSWriteState        varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.SMSWriteStates
       ADD PRIMARY KEY (SMSWriteStateID)
go


CREATE TABLE dbo.Statements (
       StatementID          int IDENTITY,
       BatchID              int NULL,
       CustomerID           int NOT NULL,
       StatementDate        datetime NOT NULL DEFAULT getdate(),
       DueDate              datetime NULL,
       PrevBal              numeric(18,4) NOT NULL DEFAULT 0,
       NewCharges           numeric(18,4) NOT NULL,
       NewCredits           numeric(18,4) NOT NULL,
       EndBal               numeric(18,4) NOT NULL DEFAULT 0,
       End0Bal              numeric(18,4) NOT NULL DEFAULT 0,
       End30Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End60Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End90Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End120Bal            numeric(18,4) NOT NULL DEFAULT 0,
       PrintDate            datetime NULL,
       EmailDate            datetime NULL,
       PrintBatchID         int NULL,
       LateCharge           tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_Statements_CustomerID ON dbo.Statements
(
       CustomerID,
       StatementDate
)
go

CREATE INDEX i_Statements_PrintBatchID ON dbo.Statements
(
       PrintBatchID
)
go







ALTER TABLE dbo.Statements
       ADD PRIMARY KEY (StatementID)
go


CREATE TABLE dbo.States (
       StateID              int IDENTITY,
       CountryID            int NOT NULL,
       State                varchar(80) NOT NULL,
       Abbreviation         varchar(10) NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       TimeZone1            numeric(4,2) NULL,
       TimeZone2            numeric(4,2) NULL,
       NationalRef          varchar(32) NULL,
       LocalRef             varchar(32) NULL,
       NationalRegion       varchar(32) NULL
)
go

CREATE UNIQUE INDEX i_States_Country_State ON dbo.States
(
       State,
       CountryID
)
go

CREATE INDEX i_States_Abbreviation ON dbo.States
(
       Abbreviation,
       CountryID
)
go






ALTER TABLE dbo.States
       ADD PRIMARY KEY (StateID)
go


CREATE TABLE dbo.Strings (
       StringID             int NOT NULL,
       LanguageID           int NOT NULL,
       ApplicationID        int NOT NULL,
       Data                 varchar(4000) NULL
)
go




ALTER TABLE dbo.Strings
       ADD PRIMARY KEY (StringID, LanguageID, ApplicationID)
go


CREATE TABLE dbo.SubAccountData (
       AccountID            int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       Data                 varchar(512) NULL
)
go


ALTER TABLE dbo.SubAccountData
       ADD PRIMARY KEY (AccountID, AccountDataTypeID)
go


CREATE TABLE dbo.SubAccountDataTypes (
       SubAccountDataTypeID int IDENTITY,
       AccountTypeID        int NULL,
       AccountDataTypeID    int NOT NULL,
       DefaultData          varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL,
       GroupID              int NULL,
       ServiceCategoryID    int NULL
)
go

CREATE UNIQUE INDEX IX_SubAccountDataTypes ON dbo.SubAccountDataTypes
(
       AccountTypeID,
       AccountDataTypeID,
       GroupID,
       ServiceCategoryID
)
go



ALTER TABLE dbo.SubAccountDataTypes
       ADD PRIMARY KEY (SubAccountDataTypeID)
go


CREATE TABLE dbo.SubAccounts (
       AccountID            int IDENTITY,
       CustomerID           int NOT NULL,
       ContactAddressID     int NULL,
       ServiceAddressID     int NULL,
       Login                varchar(64) NULL,
       Email                varchar(80) NULL,
       Password             varchar(200) NULL,
       ParentAccountID      int NULL,
       ServiceCategoryID    int NOT NULL,
       AccountTypeID        int NOT NULL,
       PayPeriodID          int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NOT NULL DEFAULT suser_name(),
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       StartDate            datetime NOT NULL DEFAULT getdate(),
       BilledThru           datetime NOT NULL DEFAULT null,
       ExpireDate           datetime NULL DEFAULT null,
       Extension            smallint NOT NULL DEFAULT 0,
       Active               smallint NOT NULL DEFAULT 1,
       SalesPersonID        int NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       SendBill             tinyint NOT NULL DEFAULT 0,
       RemoteAccess         tinyint NULL DEFAULT 1,
       EnableATConfigs      tinyint NOT NULL DEFAULT 1,
       PasswordChange       tinyint NOT NULL DEFAULT 0,
       Recurring            tinyint NOT NULL DEFAULT 1,
       LoginLimit           smallint NULL DEFAULT 1,
       DomainID             int NOT NULL,
       TowerID              int NULL,
       TimeLeft             int NULL DEFAULT null,
       DataLeft             bigint NULL,
       RateTimeLeft         int NULL,
       RateDataLeft         bigint NULL,
       InvoicedDays         int NOT NULL DEFAULT 0,
       Cost                 numeric(18,4) NULL,
       LastTimeRenewal      datetime NULL,
       LastDataRenewal      datetime NULL,
       RefAccountID         int NULL,
       RefCode              varchar(20) NULL,
       Comments             text NULL,
       ServiceQty           smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_SubAccounts_LMD ON dbo.SubAccounts
(
       LastModifyDate
)
go

CREATE INDEX i_SubAccounts_CreateDate ON dbo.SubAccounts
(
       CreateDate
)
go

CREATE INDEX i_SubAccounts_Login ON dbo.SubAccounts
(
       Login
)
go

CREATE INDEX i_SubAccounts_AccountTypeID ON dbo.SubAccounts
(
       AccountTypeID
)
go

CREATE INDEX i_SubAccounts_Email ON dbo.SubAccounts
(
       Email
)
go

CREATE INDEX i_SubAccounts_CustomerID ON dbo.SubAccounts
(
       CustomerID
)
go

CREATE INDEX i_SubAccounts_PAID_SCID ON dbo.SubAccounts
(
       ParentAccountID,
       ServiceCategoryID
)
go

CREATE INDEX i_SubAccounts_SCID ON dbo.SubAccounts
(
       ServiceCategoryID
)
go

CREATE INDEX i_SubAccounts_RefCode ON dbo.SubAccounts
(
       RefCode
)
go



ALTER TABLE dbo.SubAccounts
       ADD PRIMARY KEY (AccountID)
go


CREATE TABLE dbo.SubAccountTags (
       AccountID            int NOT NULL,
       MarketTagID          int NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       Cost                 numeric(18,4) NULL,
       CostAccountTypeID    int NULL,
       InvoicedDaysMax      int NULL,
       InvoicedDays         int NOT NULL DEFAULT 0,
       CancelItemID         int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       CreateUser           varchar(64) NULL DEFAULT suser_name()
)
go







ALTER TABLE dbo.SubAccountTags
       ADD PRIMARY KEY (AccountID, MarketTagID)
go


CREATE TABLE dbo.SubAccountUsages (
       SubAccountUsageID    int IDENTITY,
       AccountID            int NOT NULL,
       ExpireDate           datetime NOT NULL,
       TimeLeft             int NOT NULL DEFAULT 0,
       DataLeft             bigint NOT NULL DEFAULT 0,
       RateTimeLeft         int NOT NULL DEFAULT 0,
       RateDataLeft         bigint NULL,
       ItemID               int NULL,
       StartTimeLeft        int NULL,
       StartDataLeft        bigint NULL,
       StartRateTimeLeft    int NULL,
       StartRateDataLeft    bigint NULL
)
go

CREATE CLUSTERED INDEX i_SubAccountUsages_AID ON dbo.SubAccountUsages
(
       AccountID
)
go

CREATE INDEX IX_SAU_ItemID ON dbo.SubAccountUsages
(
       ItemID
)
go


ALTER TABLE dbo.SubAccountUsages
       ADD PRIMARY KEY NONCLUSTERED (SubAccountUsageID)
go

CREATE TABLE dbo.Syncs (
       SyncID        int IDENTITY,
       Sync          varchar(128) NOT NULL,
       Retries       smallint NULL,
       BatchLimit    int NULL,
       DateFormatID  int NULL,
       TimeFormatID  smallint NULL,
       DateSeparator char(1) NULL,
       Decrypt       tinyint NOT NULL DEFAULT 0,
       Active        tinyint NOT NULL DEFAULT 1,
       SortOrder     smallint NOT NULL DEFAULT 0,
       AddURL        varchar(255) NULL,
       UpdateURL     varchar(255) NULL,
       DeleteURL     varchar(255) NULL,
       KeyColumn     varchar(32) NOT NULL,
       Login         varchar(64) NULL,
       Password      varchar(200) NULL,
       SQLQuery      text NOT NULL,
       Comments      text NULL
)
GO

ALTER TABLE dbo.Syncs
       ADD PRIMARY KEY (SyncID)
GO

CREATE TABLE dbo.SyncLocks (
       SyncID        int NOT NULL,
       RefCount      int NOT NULL DEFAULT 0
)
GO

ALTER TABLE dbo.SyncLocks
       ADD PRIMARY KEY (SyncID)
GO

CREATE TABLE dbo.SyncActives (
       SyncID        int NOT NULL,
       Token         varchar(64) NOT NULL,
       Checksum      bigint NOT NULL,
       Retries       int NOT NULL DEFAULT 0,
       CreateDate    datetime NOT NULL DEFAULT getdate(),
       LastModifyDate datetime NULL,
       Message       varchar(128) NULL
)
GO

ALTER TABLE dbo.SyncActives
       ADD PRIMARY KEY (SyncID,Token)
GO

CREATE TABLE dbo.SyncExamples (
       SyncExampleID int NOT NULL,
       SyncExample   varchar(128) NOT NULL,
       KeyColumn     varchar(32) NOT NULL,
       SQLQuery      text NOT NULL,
       Comments      text NULL,
       Decrypt       tinyint NOT NULL DEFAULT 0,
       FeatureID     int NULL
)
GO

ALTER TABLE dbo.SyncExamples
       ADD PRIMARY KEY (SyncExampleID)
GO


CREATE TABLE dbo.SyslogAlerts (
       SyslogAlertID        int IDENTITY,
       SyslogAlert          varchar(128) NOT NULL,
       Description          text NULL,
       AlertSourceID        int NOT NULL,
       AlertTypeID          int NOT NULL,
       AlertStateID         smallint NOT NULL,
       SyslogSourceID       int NULL,
       SyslogMsgTypeID      int NULL,
       ExpireMins           int NULL,
       RegExp               varchar(1024) NOT NULL
)
go







ALTER TABLE dbo.SyslogAlerts
       ADD PRIMARY KEY (SyslogAlertID)
go


CREATE TABLE dbo.SyslogFacilities (
       SyslogFacilityID     tinyint NOT NULL,
       SyslogFacility       varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.SyslogFacilities
       ADD PRIMARY KEY (SyslogFacilityID)
go


CREATE TABLE dbo.SyslogMsgTypeItems (
       SyslogMsgTypeItemID  int IDENTITY,
       SyslogMsgTypeItem    varchar(128) NOT NULL,
       SyslogMsgTypeID      int NOT NULL,
       SyslogFacilityID     tinyint NULL,
       SyslogSeverityID     tinyint NULL,
       SyslogSourceID       int NULL,
       RegExp               varchar(1024) NULL
)
go






ALTER TABLE dbo.SyslogMsgTypeItems
       ADD PRIMARY KEY (SyslogMsgTypeItemID)
go


CREATE TABLE dbo.SyslogMsgTypes (
       SyslogMsgTypeID      int IDENTITY,
       SyslogMsgType        varchar(128) NOT NULL,
       ExpireDays           int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.SyslogMsgTypes
       ADD PRIMARY KEY (SyslogMsgTypeID)
go


CREATE TABLE dbo.SysLogs (
       SyslogID             bigint IDENTITY,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       SyslogSeverityID     tinyint NOT NULL DEFAULT 0,
       SyslogFacilityID     tinyint NOT NULL DEFAULT 0,
       SyslogSourceID       int NULL,
       SyslogMsgTypeID      int NULL,
       IPAddress            varchar(64) NOT NULL,
       Data                 varchar(1024) NOT NULL
)
go

CREATE INDEX i_SysLogs_LD_MTID_SID ON dbo.SysLogs
(
       LogDate,
       SyslogMsgTypeID,
       SyslogSourceID
)
go

CREATE INDEX i_SysLogs_IPAddress ON dbo.SysLogs
(
       IPAddress
)
go






ALTER TABLE dbo.SysLogs
       ADD PRIMARY KEY (SyslogID)
go


CREATE TABLE dbo.SyslogSeverities (
       SyslogSeverityID     tinyint NOT NULL,
       SyslogSeverity       varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.SyslogSeverities
       ADD PRIMARY KEY (SyslogSeverityID)
go


CREATE TABLE dbo.SyslogSourceItems (
       SyslogSourceItemID   int IDENTITY,
       SyslogSourceItem     varchar(128) NOT NULL,
       SyslogSourceID       int NOT NULL,
       SyslogSourceItemTypeID int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go




ALTER TABLE dbo.SyslogSourceItems
       ADD PRIMARY KEY (SyslogSourceItemID)
go


CREATE TABLE dbo.SyslogSourceItemTypes (
       SyslogSourceItemTypeID int NOT NULL,
       SyslogSourceItemType varchar(128) NOT NULL
)
go


ALTER TABLE dbo.SyslogSourceItemTypes
       ADD PRIMARY KEY (SyslogSourceItemTypeID)
go


CREATE TABLE dbo.SyslogSources (
       SyslogSourceID       int IDENTITY,
       SyslogSource         varchar(128) NOT NULL,
       ExpireDays           int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.SyslogSources
       ADD PRIMARY KEY (SyslogSourceID)
go


CREATE TABLE dbo.Taxes (
       TaxID                int IDENTITY,
       Description          varchar(128) NOT NULL,
       StringID             int NULL,
       Tax                  numeric(18,4) NOT NULL DEFAULT 0,
       AmountType           smallint NOT NULL DEFAULT 1,
       CumulativeType       smallint NULL,
       FloorLimit           numeric(18,4) NULL,
       CeilingLimit         numeric(18,4) NULL,
       TaxPiggyBackID       int NULL,
       TaxPigOrder          smallint NOT NULL DEFAULT 1,
       GLCodeID             int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       TaxTypeID            int NULL,
       TaxSourceID          int NULL,
       ExternalRef          varchar(64) NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       SortOrder            smallint NULL DEFAULT 0
)
go

CREATE INDEX i_Taxes_TSID ON dbo.Taxes
(
       TaxSourceID
)
go

CREATE INDEX i_Taxes_ExternalRef ON dbo.Taxes
(
       ExternalRef
)
go






ALTER TABLE dbo.Taxes
       ADD PRIMARY KEY (TaxID)
go


CREATE TABLE dbo.TaxExemptions (
       TaxExemptionID       int NOT NULL,
       TaxExemption         varchar(64) NOT NULL,
       StringID             int NULL,
       AllowMBR             tinyint NOT NULL DEFAULT 0,
       AllowItem            tinyint NOT NULL DEFAULT 0,
       Active               tinyint NOT NULL DEFAULT 0
)
go





ALTER TABLE dbo.TaxExemptions
       ADD PRIMARY KEY (TaxExemptionID)
go


CREATE TABLE dbo.TaxGroups (
       TaxGroupID           int IDENTITY,
       TaxGroup             varchar(64) NOT NULL
)
go


ALTER TABLE dbo.TaxGroups
       ADD PRIMARY KEY (TaxGroupID)
go


CREATE TABLE dbo.TaxGroupTaxes (
       TaxGroupTaxID        int IDENTITY,
       TaxGroupID           int NOT NULL,
       TaxID                int NULL,
       TaxSourceID          int NULL,
       AddressCategoryID    int NOT NULL DEFAULT 1,
       StateID              int NULL,
       CountryID            int NULL,
       RegionID             int NULL,
       City                 varchar(64) NULL,
       Zip                  varchar(20) NULL,
       AddressDataTypeID    int NULL,
       AddressData          varchar(512) NULL,
       AddressDataTypeID2   int NULL,
       AddressData2         varchar(512) NULL
)
go

CREATE UNIQUE INDEX IX_TaxGroupTaxes ON dbo.TaxGroupTaxes
(
       TaxGroupID,
       TaxID,
       StateID,
       CountryID,
       RegionID,
       City,
       Zip,
       TaxSourceID
)
go









ALTER TABLE dbo.TaxGroupTaxes
       ADD PRIMARY KEY (TaxGroupTaxID)
go


CREATE TABLE dbo.TaxPiggyBacks (
       TaxPiggyBackID       int IDENTITY,
       TaxPiggyBack         varchar(64) NULL
)
go


ALTER TABLE dbo.TaxPiggyBacks
       ADD PRIMARY KEY (TaxPiggyBackID)
go


CREATE TABLE dbo.TaxRates (
       TaxSourceID          int NOT NULL,
       ExternalRef          varchar(64) NOT NULL,
       Description          varchar(128) NULL,
       Tax                  numeric(18,4) NOT NULL,
       CountryID            int NULL,
       StateID              int NULL,
       City                 varchar(64) NULL,
       Zip                  varchar(20) NULL,
       AddressData          varchar(512) NULL,
       AddressData2         varchar(512) NULL,
       TaxTypeID            int NULL,
       StartDate            datetime NULL
)
go

CREATE CLUSTERED INDEX i_TaxRates_TaxSourceID ON dbo.TaxRates
(
       TaxSourceID,ExternalRef
)
go


CREATE TABLE dbo.TaxSources (
       TaxSourceID          int IDENTITY,
       TaxSource            varchar(128) NOT NULL,
       TaxSourceTypeID      smallint NOT NULL,
       AmountType           smallint NOT NULL DEFAULT 1,
       CumulativeType       smallint NULL,
       FloorLimit           numeric(18,4) NULL,
       CeilingLimit         numeric(18,4) NULL,
       TaxPiggyBackID       int NULL,
       TaxPigOrder          smallint NOT NULL DEFAULT 1,
       GLCodeID             int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       TaxTypeID            int NULL,
       GeoLayerID           int NULL,
       GeoSubLayerID        int NULL,
       GeoFieldDescription  smallint NULL,
       GeoFieldKey          smallint NULL,
       GeoFieldTax          smallint NULL,
       AddressDataTypeID    int NULL,
       AddressDataTypeID2   int NULL,
       CountryID            int NULL,
       StateID              int NULL,
       BillingImportID      int NULL,
       LastImportUser       varchar(64) NULL,
       LastImportDate       datetime NULL
)
go














ALTER TABLE dbo.TaxSources
       ADD PRIMARY KEY (TaxSourceID)
go


CREATE TABLE dbo.TaxSourceTypes (
       TaxSourceTypeID      smallint NOT NULL,
       TaxSourceType        varchar(128) NOT NULL
)
go


ALTER TABLE dbo.TaxSourceTypes
       ADD PRIMARY KEY (TaxSourceTypeID)
go


CREATE TABLE dbo.TaxTypes (
       TaxTypeID            int IDENTITY,
       TaxType              varchar(64) NOT NULL
)
go


ALTER TABLE dbo.TaxTypes
       ADD PRIMARY KEY (TaxTypeID)
go


CREATE TABLE dbo.ThemeFilters (
       ThemeFilterID        int IDENTITY,
       ThemeFilter          varchar(128) NOT NULL,
       Description          text NULL,
       ThemeID              int NOT NULL,
       ThemeMatchTypeID     int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Score                int NOT NULL
)
go




ALTER TABLE dbo.ThemeFilters
       ADD PRIMARY KEY (ThemeFilterID)
go


CREATE TABLE dbo.ThemeMatchTypes (
       ThemeMatchTypeID     int NOT NULL,
       ThemeMatchType       varchar(128) NOT NULL,
       Hidden               smallint NOT NULL DEFAULT 0
)
go



ALTER TABLE dbo.ThemeMatchTypes
       ADD PRIMARY KEY (ThemeMatchTypeID)
go


CREATE TABLE dbo.Themes (
       ThemeID              int IDENTITY,
       Theme                varchar(50) NOT NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.Themes
       ADD PRIMARY KEY (ThemeID)
go


CREATE TABLE dbo.TimeCharges (
       TimeChargeID         int IDENTITY,
       TimeCharge           varchar(128) NOT NULL,
       StringID             int NULL,
       Description          text NULL,
       ChargeTypeID         int NOT NULL,
       AccountTypeID        int NOT NULL,
       Months               int NULL,
       Days                 int NULL,
       Minutes              int NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       RateTimeLeft         int NULL,
       RateDataLeft         bigint NULL,
       CustomerMaxQty       int NULL,
       CustomerAccess       tinyint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX IX_TimeCharges_AccountTypes ON dbo.TimeCharges
(
       ChargeTypeID,
       AccountTypeID
)
go

CREATE INDEX I_TimeCharges_ATID_CTID ON dbo.TimeCharges
(
       AccountTypeID,
       ChargeTypeID
)
go


ALTER TABLE dbo.TimeCharges
       ADD PRIMARY KEY (TimeChargeID)
go


CREATE TABLE dbo.TimeZones (
       TimeZoneID           numeric(4,2) NOT NULL,
       TimeZone             varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.TimeZones
       ADD PRIMARY KEY (TimeZoneID)
go


CREATE TABLE dbo.TowerAntennas (
       TowerAntennaID       int IDENTITY,
       TowerAntenna         varchar(128) NOT NULL,
       TowerID              int NOT NULL,
       TowerAntennaTypeID   int NOT NULL,
       ServerID             int NULL,
       BeamCenter           numeric(5,2) NULL,
       Tilt                 numeric(5,2) NULL,
       SerialNumber         varchar(64) NULL,
       Frequency            numeric(9,2) NULL,
       ChannelWidth         numeric(9,2) NULL,
       Altitude             numeric(10,4) NULL,
       PowerTX              numeric(9,4) NULL,
       Sensitivity          numeric(9,4) NULL,
       RangePrimary         numeric(12,2) NULL,
       RangeMax             numeric(12,2) NULL,
       Comments             text NULL
)
go

CREATE INDEX i_TowerAntennas_TowerAntenna ON dbo.TowerAntennas
(
       TowerAntenna
)
go

CREATE INDEX i_TowerAntennas_TowerID ON dbo.TowerAntennas
(
       TowerID
)
go

CREATE INDEX i_TowerAntennas_TAT ON dbo.TowerAntennas
(
       TowerAntennaTypeID
)
go

CREATE INDEX i_TowerAntennas_ServerID ON dbo.TowerAntennas
(
       ServerID
)
go

CREATE INDEX i_TowerAntennas_SerialNumber ON dbo.TowerAntennas
(
       SerialNumber
)
go




ALTER TABLE dbo.TowerAntennas
       ADD PRIMARY KEY (TowerAntennaID)
go


CREATE TABLE dbo.TowerAntennaServiceCats (
       TowerAntennaID       int NOT NULL,
       ServiceCategoryID    int NOT NULL
)
go



ALTER TABLE dbo.TowerAntennaServiceCats
       ADD PRIMARY KEY (TowerAntennaID, ServiceCategoryID)
go


CREATE TABLE dbo.TowerAntennaTypes (
       TowerAntennaTypeID   int IDENTITY,
       TowerAntennaType     varchar(128) NOT NULL,
       BeamWidthV           numeric(5,2) NULL,
       BeamWidthH           numeric(5,2) NULL,
       Gain                 numeric(6,3) NULL,
       Manufacturer         varchar(128) NULL,
       Model                varchar(128) NULL,
       Description          text NULL,
       Comments             text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.TowerAntennaTypes
       ADD PRIMARY KEY (TowerAntennaTypeID)
go


CREATE TABLE dbo.Towers (
       TowerID              int IDENTITY,
       Tower                varchar(128) NOT NULL,
       TowerTypeID          int NOT NULL,
       SiteID               int NOT NULL,
       BaseAltitude         numeric(10,4) NULL,
       Height               numeric(10,4) NULL,
       Description          text NULL,
       Comments             text NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_Towers_SiteID ON dbo.Towers
(
       SiteID
)
go

CREATE INDEX i_Towers_TowerTypeID ON dbo.Towers
(
       TowerTypeID
)
go

CREATE INDEX i_Towers_Tower ON dbo.Towers
(
       Tower
)
go



ALTER TABLE dbo.Towers
       ADD PRIMARY KEY (TowerID)
go


CREATE TABLE dbo.TowerTypes (
       TowerTypeID          int IDENTITY,
       TowerType            varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.TowerTypes
       ADD PRIMARY KEY (TowerTypeID)
go


CREATE TABLE dbo.TransStates (
       TransStateID         tinyint NOT NULL,
       TransState           varchar(128) NOT NULL,
       StringID             int NULL
)
go




ALTER TABLE dbo.TransStates
       ADD PRIMARY KEY (TransStateID)
go


CREATE TABLE dbo.TransTypes (
       TransTypeID          smallint NOT NULL,
       TransType            varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.TransTypes
       ADD PRIMARY KEY (TransTypeID)
go


CREATE TABLE dbo.TrustedFiles (
       TrustedFileID        int IDENTITY,
       TrustedFile          varchar(128) NOT NULL,
       Description          text NULL,
       Comments             text NULL,
       OperatorGroupID      int NOT NULL,
       FileName             varchar(64) NOT NULL,
       Active               tinyint NOT NULL DEFAULT 0,
       IEAID                int NULL
)
go

CREATE UNIQUE INDEX i_TrustedFiles_FileName ON dbo.TrustedFiles
(
       FileName
)
go


ALTER TABLE dbo.TrustedFiles
       ADD PRIMARY KEY (TrustedFileID)
go


CREATE TABLE dbo.VoiceCalls (
       VoiceCallID          bigint IDENTITY,
       AccountID            int NULL,
       CallDate             datetime NOT NULL,
       Login                varchar(64) NOT NULL,
       Duration             int NOT NULL,
       SessionRef           varchar(64) NULL,
       CalledNumber         varchar(64) NULL,
       CallingPort          varchar(32) NULL,
       CalledPort           varchar(32) NULL,
       Bytes                bigint NULL,
       CallType             varchar(64) NULL,
       AcctTerminateCause   smallint NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Location             varchar(64) NULL,
       ChargeID             int NULL,
       ProcDate             datetime NULL,
       ErrorCode            smallint NULL,
       Cost                 numeric(28,12) NULL
)
go

CREATE UNIQUE INDEX i_VoiceCalls_Unique ON dbo.VoiceCalls
(
       CallDate,
       Login,
       Duration,
       SessionRef,
       CalledNumber
)
go

CREATE INDEX i_VoiceCalls_AID_CD ON dbo.VoiceCalls
(
       AccountID,
       CallDate
)
go

CREATE INDEX i_VoiceCalls_C_PD ON dbo.VoiceCalls
(
       ChargeID,
       ProcDate
)
go


ALTER TABLE dbo.VoiceCalls
       ADD PRIMARY KEY (VoiceCallID)
go


CREATE TABLE dbo.WebForwarders (
       WebForwarderID       int IDENTITY,
       WebForwarder         varchar(128) NOT NULL,
       WebForwarderTypeID   int NOT NULL DEFAULT 1,
       WebClientCertTypeID  int NULL,
       IPAddress            varchar(64) NOT NULL,
       Active               tinyint NOT NULL DEFAULT 1,
       Comments             text NULL
)
go

CREATE UNIQUE INDEX i_WebForwarders_IPAddress ON dbo.WebForwarders
(
       IPAddress
)
go

CREATE INDEX i_WebForwarders_Active ON dbo.WebForwarders
(
       Active
)
go


ALTER TABLE dbo.WebForwarders
       ADD PRIMARY KEY (WebForwarderID)
go


CREATE TABLE dbo.WebForwarderTypes (
       WebForwarderTypeID   int NOT NULL,
       WebForwarderType     varchar(128) NOT NULL
)
go


ALTER TABLE dbo.WebForwarderTypes
       ADD PRIMARY KEY (WebForwarderTypeID)
go

CREATE TABLE dbo.WebClientCertTypes (
       WebClientCertTypeID   int NOT NULL,
       WebClientCertType     varchar(128) NOT NULL
)
go

ALTER TABLE dbo.WebClientCertTypes
       ADD PRIMARY KEY (WebClientCertTypeID)
go



CREATE TABLE dbo.WebLinks (
       WebLinkID            int IDENTITY,
       WebLinkTypeID        int NOT NULL DEFAULT 1,
       WebLink              varchar(128) NOT NULL,
       URL                  varchar(255) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Timeout              int NULL
)
go

CREATE INDEX i_WebLinks_WLT_URL ON dbo.WebLinks
(
       WebLinkTypeID,
       URL
)
go

ALTER TABLE dbo.WebLinks
       ADD PRIMARY KEY (WebLinkID)
go


CREATE TABLE dbo.WebLinkTypes (
       WebLinkTypeID        int IDENTITY,
       WebLinkType          varchar(128) NOT NULL,
       AllowOperator        tinyint NOT NULL DEFAULT 1,
       AccessLabelID        int NULL,
       AllowCustomer        tinyint NOT NULL DEFAULT 0,
       GroupID              int NULL,
       AllowCallSearch      tinyint NOT NULL DEFAULT 0,
       AllowOperatorPing    tinyint NOT NULL DEFAULT 0,
       AllowAddrLocation    tinyint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_WebLinkTypes_AAL_GID ON dbo.WebLinkTypes
(
       AllowAddrLocation,
       GroupID
)
go

ALTER TABLE dbo.WebLinkTypes
       ADD PRIMARY KEY (WebLinkTypeID)
go


ALTER TABLE dbo.AccessLabels
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES dbo.ObjectGroups
go


ALTER TABLE dbo.AccountChanges
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AccountChanges
       ADD FOREIGN KEY (CreateCustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AccountChanges
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES dbo.CancelReasons
go


ALTER TABLE dbo.AccountChanges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.AccountChanges
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AccountDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go

ALTER TABLE dbo.AccountDataTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.AccountDataValues
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.AccountTagTimes
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AccountTagTimes
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AccountTagTimes
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES dbo.DNISGroups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (SecChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES dbo.RateClasses
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go

ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (ServiceLevelTypeID)
                             REFERENCES dbo.ServiceLevelTypes
go

ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (SecServiceLevelTypeID)
                             REFERENCES dbo.ServiceLevelTypes
go

ALTER TABLE dbo.AccountTypeTemplates
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.AccountTypeTemplates
       ADD FOREIGN KEY (AccountTemplateID)
                             REFERENCES dbo.AccountTemplates
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (CreateAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES dbo.Incidents
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.AddressData
       ADD FOREIGN KEY (AddressDataSourceID)
                             REFERENCES dbo.AddressDataSources
go


ALTER TABLE dbo.AddressData
       ADD FOREIGN KEY (AddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.AddressData
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.AddressDataTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (IMTypeID)
                             REFERENCES dbo.IMTypes
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (GeoLayerID)
                             REFERENCES dbo.GeoLayers
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (Aux3AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (Aux4AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (GeoShapeAddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (Aux1AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (Aux2AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressGeoSources
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.AddressSyncs
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.AddressSyncs
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.AddressSyncs
       ADD FOREIGN KEY (AddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.AddressTypeDataTypes
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.AddressTypeDataTypes
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.AlertFileMasterAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AlertFileMasterAccounts
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.AlertFileMasterAccounts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.AlertFileSubAccounts
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.AlertFileSubAccounts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.AlertFileSubAccounts
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AlertInvMasterAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AlertInvMasterAccounts
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.AlertInvMasterAccounts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.AlertInvSubAccounts
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.AlertInvSubAccounts
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AlertInvSubAccounts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.Alerts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Alerts
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Alerts
       ADD FOREIGN KEY (AlertSourceID)
                             REFERENCES dbo.AlertSources
go


ALTER TABLE dbo.Alerts
       ADD FOREIGN KEY (AlertTypeID)
                             REFERENCES dbo.AlertTypes
go


ALTER TABLE dbo.Alerts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.AlertSources
       ADD FOREIGN KEY (AlertSourceTypeID)
                             REFERENCES dbo.AlertSourceTypes
go


ALTER TABLE dbo.AlertTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.Aliases
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AllowedHosts
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go

ALTER TABLE dbo.APIActions
       ADD FOREIGN KEY (APIActionTypeID)
                             REFERENCES dbo.APIActionTypes
go


ALTER TABLE dbo.APIActions
       ADD FOREIGN KEY (APIGroupCheckID)
                             REFERENCES dbo.APIGroupChecks
go


ALTER TABLE dbo.APIFields
       ADD FOREIGN KEY (APIFieldTypeID)
                             REFERENCES dbo.APIFieldTypes
go


ALTER TABLE dbo.APIFields
       ADD FOREIGN KEY (APIActionID)
                             REFERENCES dbo.APIActions
go


ALTER TABLE dbo.APIProfileItems
       ADD FOREIGN KEY (APIProfileID)
                             REFERENCES dbo.APIProfiles
go


ALTER TABLE dbo.APIProfileItems
       ADD FOREIGN KEY (APIFieldID)
                             REFERENCES dbo.APIFields
go


ALTER TABLE dbo.APIStepColumns
       ADD FOREIGN KEY (MetaColumnID)
                             REFERENCES dbo.MetaColumns
go


ALTER TABLE dbo.APIStepColumns
       ADD FOREIGN KEY (APIStepID)
                             REFERENCES dbo.APISteps
go


ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (APIStepTypeID)
                             REFERENCES dbo.APIStepTypes
go


ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES dbo.MetaTables
go


ALTER TABLE dbo.APISteps
       ADD FOREIGN KEY (APIActionID)
                             REFERENCES dbo.APIActions
go


ALTER TABLE dbo.APITokens
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.AuditLogs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES dbo.LogMsgs
go


ALTER TABLE dbo.AuditTableInserts
       ADD FOREIGN KEY (MetaColumnID)
                             REFERENCES dbo.MetaColumns
go


ALTER TABLE dbo.AuditTableInserts
       ADD FOREIGN KEY (AuditTableID)
                             REFERENCES dbo.AuditTables
go


ALTER TABLE dbo.AuditTables
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES dbo.MetaTables
go


ALTER TABLE dbo.AuditTables
       ADD FOREIGN KEY (AuditTransID)
                             REFERENCES dbo.AuditTrans
go


ALTER TABLE dbo.AuditTables
       ADD FOREIGN KEY (AuditActionID)
                             REFERENCES dbo.AuditActions
go


ALTER TABLE dbo.AuditTableUpdates
       ADD FOREIGN KEY (MetaColumnID)
                             REFERENCES dbo.MetaColumns
go


ALTER TABLE dbo.AuditTableUpdates
       ADD FOREIGN KEY (AuditTableID)
                             REFERENCES dbo.AuditTables
go


ALTER TABLE dbo.AuditTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.AuditTrans
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.BankTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Batches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Batches
       ADD FOREIGN KEY (BatchStateID)
                             REFERENCES dbo.BatchStates
go


ALTER TABLE dbo.Batches
       ADD FOREIGN KEY (BatchTypeID)
                             REFERENCES dbo.BatchTypes
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (ExpCancelReasonID)
                             REFERENCES dbo.CancelReasons
go

ALTER TABLE dbo.BillingImports
       ADD FOREIGN KEY (BillingImportTypeID)
                             REFERENCES dbo.BillingImportTypes
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (AddressCategoryID)
                             REFERENCES dbo.AddressCategories
go

ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (MAAccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go

ALTER TABLE dbo.BulkItems
       ADD FOREIGN KEY (SAAccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go

ALTER TABLE dbo.BulkProfiles
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.CancelReasons
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (DirectCustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (DirectAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (CardBatchID)
                             REFERENCES dbo.CardBatches
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (CardBatchTypeID)
                             REFERENCES dbo.CardBatchTypes
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (LoginCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (PasswordCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (LoginCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (PasswordCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.CardTypePrefixes
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES dbo.CardTypes
go


ALTER TABLE dbo.CCImportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.ClientCerts
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.ClientCerts
       ADD FOREIGN KEY (DownloadOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.ClientCerts
       ADD FOREIGN KEY (ClientCertInactID)
                             REFERENCES dbo.ClientCertInacts
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES dbo.CommissionGroups
go


ALTER TABLE dbo.ConfigGroupData
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ConfigGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.ConfigOperatorGroupData
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.ConfigOperatorGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.Configs
       ADD FOREIGN KEY (ConfigGroupID)
                             REFERENCES dbo.ConfigGroups
go


ALTER TABLE dbo.Configs
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go


ALTER TABLE dbo.ConfigValues
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.Countries
       ADD FOREIGN KEY (ContinentID)
                             REFERENCES dbo.Continents
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BillToCountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES dbo.CardTypes
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BillToStateID)
                             REFERENCES dbo.States
go

ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES dbo.BatchProcessors
go

ALTER TABLE dbo.Currencies
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (DashTypeID)
                             REFERENCES dbo.DashTypes
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.Dashes
       ADD FOREIGN KEY (SchedBlockTypeID)
                             REFERENCES dbo.SchedBlockTypes
go


ALTER TABLE dbo.Discounts
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.DNISNumbers
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES dbo.DNISGroups
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go

ALTER TABLE dbo.Events
       ADD FOREIGN KEY (BulkProfileID)
                             REFERENCES dbo.BulkProfiles
go

ALTER TABLE dbo.Events
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Events
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.Events
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.Events
       ADD FOREIGN KEY (EventTypeID)
                             REFERENCES dbo.EventTypes
go


ALTER TABLE dbo.Events
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.EventTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.EventTypes
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.EventTypes
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.ExportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.Exports
       ADD FOREIGN KEY (ExportType)
                             REFERENCES dbo.ExportTypes
go


ALTER TABLE dbo.ExternalSyncs
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES dbo.ExternalSystems
go


ALTER TABLE dbo.ExternalSyncs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES dbo.ExternalSystems
go


ALTER TABLE dbo.ExternalSystemDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.ExternalSystemDataTypes
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES dbo.ExternalSystemTypes
go


ALTER TABLE dbo.ExternalSystems
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.ExternalSystems
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES dbo.ExternalSystemTypes
go


ALTER TABLE dbo.ExternalSystemTypes
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (TransStateID)
                             REFERENCES dbo.TransStates
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (TransTypeID)
                             REFERENCES dbo.TransTypes
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES dbo.BatchProcessors
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (AuthStateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES dbo.Payments
go


ALTER TABLE dbo.FileCategories
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.FileCategoryMimeTypes
       ADD FOREIGN KEY (MimeTypeID)
                             REFERENCES dbo.MimeTypes
go


ALTER TABLE dbo.FileCategoryMimeTypes
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (FileApplyTypeID)
                             REFERENCES dbo.FileApplyTypes
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.FileCategoryReqs
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES dbo.Payments
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES dbo.Incidents
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (StatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (AddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.Files
       ADD FOREIGN KEY (EventID)
                             REFERENCES dbo.Events
go


ALTER TABLE dbo.Forwards
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.GaugeAlerts
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.GaugeRollups
       ADD FOREIGN KEY (GaugeWindowID)
                             REFERENCES dbo.GaugeWindows
go


ALTER TABLE dbo.GaugeRollups
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Gauges
       ADD FOREIGN KEY (GaugeSourceID)
                             REFERENCES dbo.GaugeSources
go


ALTER TABLE dbo.Gauges
       ADD FOREIGN KEY (GaugeWindowID)
                             REFERENCES dbo.GaugeWindows
go

ALTER TABLE dbo.Gauges
       ADD FOREIGN KEY (GaugeConversionID)
                             REFERENCES dbo.GaugeConversions
go

ALTER TABLE dbo.GaugeCounterData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go

ALTER TABLE dbo.GaugeCounterData
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go

ALTER TABLE dbo.GaugeGroupItems
       ADD FOREIGN KEY (GaugeGroupID)
                             REFERENCES dbo.GaugeGroups
go

ALTER TABLE dbo.GaugeGroupItems
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Geocoders
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Geocoders
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Geocoders
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.Geocoders
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.GeoPolygons
       ADD FOREIGN KEY (GeoShapeID)
                             REFERENCES dbo.GeoShapes
go


ALTER TABLE dbo.GeoShapes
       ADD FOREIGN KEY (GeoSubLayerID)
                             REFERENCES dbo.GeoSubLayers
go


ALTER TABLE dbo.GeoShapes
       ADD FOREIGN KEY (GeoLayerID)
                             REFERENCES dbo.GeoLayers
go


ALTER TABLE dbo.GeoSubLayers
       ADD FOREIGN KEY (GeoLayerID)
                             REFERENCES dbo.GeoLayers
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (BillCountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.IncidentData
       ADD FOREIGN KEY (IncidentDataTypeID)
                             REFERENCES dbo.IncidentDataTypes
go


ALTER TABLE dbo.IncidentData
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES dbo.Incidents
go


ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (IncidentTemplateID)
                             REFERENCES dbo.IncidentTemplates
go


ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go

ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (EventID)
                             REFERENCES dbo.Events
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (CreateAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (SchedBlockID)
                             REFERENCES dbo.SchedBlocks
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.IncidentStates
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES dbo.IncidentStateGroups
go


ALTER TABLE dbo.IncidentStates
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES dbo.IncidentStateGroups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (SchedBlockTypeID)
                             REFERENCES dbo.SchedBlockTypes
go


ALTER TABLE dbo.IncidentTypeFileCategories
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go

ALTER TABLE dbo.IncidentTypeFileCategories
       ADD FOREIGN KEY (FileCategoryID)
                             REFERENCES dbo.FileCategories
go


ALTER TABLE dbo.IncidentValues
       ADD FOREIGN KEY (IncidentDataTypeID)
                             REFERENCES dbo.IncidentDataTypes
go


ALTER TABLE dbo.InfoBarOperatorGroups
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.InfoBarOperatorGroups
       ADD FOREIGN KEY (InfoBarID)
                             REFERENCES dbo.InfoBars
go


ALTER TABLE dbo.InfoBarOperators
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.InfoBarOperators
       ADD FOREIGN KEY (InfoBarID)
                             REFERENCES dbo.InfoBars
go


ALTER TABLE dbo.InvAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.InvAccountTypes
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.InvAttributes
       ADD FOREIGN KEY (InvLevelTypeID)
                             REFERENCES dbo.InvLevelTypes
go


ALTER TABLE dbo.InvAttributes
       ADD FOREIGN KEY (InvAttrMapID)
                             REFERENCES dbo.InvAttrMaps
go


ALTER TABLE dbo.InvItemData
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.InvItemData
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go


ALTER TABLE dbo.InvItemData
       ADD FOREIGN KEY (InvValueID)
                             REFERENCES dbo.InvValues
go


ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (InvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go

ALTER TABLE dbo.InvStateGroups
       ADD FOREIGN KEY (POSInvStateID)
                             REFERENCES dbo.InvStates
go

ALTER TABLE dbo.InvStateGroups
       ADD FOREIGN KEY (AssignInvStateID)
                             REFERENCES dbo.InvStates
go

ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates
go


ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go


ALTER TABLE dbo.InvItemLogs
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates
go


ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (InvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go


ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go

ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go

ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (InvCategoryID)
                             REFERENCES dbo.InvCategories
go


ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (InvSubCategoryID)
                             REFERENCES dbo.InvSubCategories
go


ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (InvSourceID)
                             REFERENCES dbo.InvSources
go

ALTER TABLE dbo.InvLevelAttributes
       ADD FOREIGN KEY (DefaultInvValueID)
                             REFERENCES dbo.InvValues
go

ALTER TABLE dbo.InvoiceItemDiscounts
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.InvoiceItemDiscounts
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ItemType)
                             REFERENCES dbo.InvoiceItemTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (TaxID)
                             REFERENCES dbo.Taxes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES dbo.Charges
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (VoidStatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (StatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (InvoiceTypeID)
                             REFERENCES dbo.InvoiceTypes
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (BatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (PayPlanID)
                             REFERENCES dbo.PayPlans
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.InvoiceSubAccounts
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.InvoiceSubAccounts
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.InvoiceTags
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.InvoiceTags
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.InvoiceTags
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.InvProductData
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.InvProductData
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.InvProductData
       ADD FOREIGN KEY (InvValueID)
                             REFERENCES dbo.InvValues
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (InvCategoryID)
                             REFERENCES dbo.InvCategories
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (InvSubCategoryID)
                             REFERENCES dbo.InvSubCategories
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (InvSourceID)
                             REFERENCES dbo.InvSources
go


ALTER TABLE dbo.InvProducts
       ADD FOREIGN KEY (CloseInvStateID)
                             REFERENCES dbo.InvStates
go


ALTER TABLE dbo.InvSources
       ADD FOREIGN KEY (InvSourceTypeID)
                             REFERENCES dbo.InvSourceTypes
go


ALTER TABLE dbo.InvSources
       ADD FOREIGN KEY (InvStateGroupID)
                             REFERENCES dbo.InvStateGroups
go


ALTER TABLE dbo.InvStates
       ADD FOREIGN KEY (InvStateTypeID)
                             REFERENCES dbo.InvStateTypes
go


ALTER TABLE dbo.InvStates
       ADD FOREIGN KEY (InvReserveTypeID)
                             REFERENCES dbo.InvReserveTypes
go


ALTER TABLE dbo.InvStates
       ADD FOREIGN KEY (InvStateGroupID)
                             REFERENCES dbo.InvStateGroups
go


ALTER TABLE dbo.InvStates
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.InvSubCategories
       ADD FOREIGN KEY (InvCategoryID)
                             REFERENCES dbo.InvCategories
go


ALTER TABLE dbo.InvValues
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.InvWarehouseProducts
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.InvWarehouseProducts
       ADD FOREIGN KEY (InvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go


ALTER TABLE dbo.InvWarehouses
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites
go


ALTER TABLE dbo.LateFeeChargeTypes
       ADD FOREIGN KEY (LateFeeID)
                             REFERENCES dbo.LateFees
go


ALTER TABLE dbo.LateFeeChargeTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.LateFeeDays
       ADD FOREIGN KEY (LateFeeID)
                             REFERENCES dbo.LateFees
go


ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (LateFeeTypeID)
                             REFERENCES dbo.LateFeeTypes
go

ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go

ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.LateFeeServiceCats
       ADD FOREIGN KEY (LateFeeID)
                             REFERENCES dbo.LateFees
go


ALTER TABLE dbo.LateFeeServiceCats
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.LocPhones
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.LocZipCodes
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.MarketTagAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.MarketTagAttributes
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.MarketTagAttributes
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MarketTagConditions
       ADD FOREIGN KEY (MarketTagCondTypeID)
                             REFERENCES dbo.MarketTagCondTypes
go


ALTER TABLE dbo.MarketTagConditions
       ADD FOREIGN KEY (DstMarketTagGroupID)
                             REFERENCES dbo.MarketTagGroups
go


ALTER TABLE dbo.MarketTagConditions
       ADD FOREIGN KEY (SrcMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MarketTagConditions
       ADD FOREIGN KEY (DstMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MarketTagGroupItems
       ADD FOREIGN KEY (MarketTagGroupID)
                             REFERENCES dbo.MarketTagGroups
go


ALTER TABLE dbo.MarketTagGroupItems
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (PromoCodeID)
                             REFERENCES dbo.PromoCodes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (MarketTagAutoTypeID)
                             REFERENCES dbo.MarketTagAutoTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (AddressCategoryID)
                             REFERENCES dbo.AddressCategories
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (ParentServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (MarketServiceCountTypeID)
                             REFERENCES dbo.MarketServiceCountTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (MarketTagCancelTypeID)
                             REFERENCES dbo.MarketTagCancelTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (MarketCategoryID)
                             REFERENCES dbo.MarketCategories
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (CancelChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.MarketTags
       ADD FOREIGN KEY (ServiceLevelTypeID)
                             REFERENCES dbo.ServiceLevelTypes
go


ALTER TABLE dbo.MasterAccountData
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.MasterAccountData
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.MasterAccountPromoCodes
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.MasterAccountPromoCodes
       ADD FOREIGN KEY (PromoCodeID)
                             REFERENCES dbo.PromoCodes
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (BillingAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (LastStatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (ReferredByID)
                             REFERENCES dbo.ReferredBys
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES dbo.CancelReasons
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (ShippingAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (ServiceAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.MasterAccountTags
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.MasterAccountTags
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MenuSets
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MenuSets
       ADD FOREIGN KEY (MenuID)
                             REFERENCES dbo.Menus
go


ALTER TABLE dbo.MenuSets
       ADD FOREIGN KEY (MenuItemID)
                             REFERENCES dbo.MenuItems
go


ALTER TABLE dbo.MetaColumns
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES dbo.MetaTables
go


ALTER TABLE dbo.MetaColumns
       ADD FOREIGN KEY (MetaRuleID)
                             REFERENCES dbo.MetaRules
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (MonFilterID)
                             REFERENCES dbo.MonFilters
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups
go

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go

ALTER TABLE dbo.MonFilterItems
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go

ALTER TABLE dbo.MonFilters
       ADD FOREIGN KEY (MonSourceID)
                             REFERENCES dbo.MonSources
go


ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (MonitorID)
                             REFERENCES dbo.Monitors
go


ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (MonProfileItemID)
                             REFERENCES dbo.MonProfileItems
go


ALTER TABLE dbo.MonitorProfileOptions
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonFilterID)
                             REFERENCES dbo.MonFilters
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonProtocolID)
                             REFERENCES dbo.MonProtocols
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonRadIPSourceID)
                             REFERENCES dbo.MonRadIPSources
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (MonProfileID)
                             REFERENCES dbo.MonProfiles
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingMinGaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingMaxGaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingAvgGaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingTimeoutGaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PingJitterGaugeID)
                             REFERENCES dbo.Gauges
go

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (FlowUpGaugeID)
                             REFERENCES dbo.Gauges
go

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (FlowDownGaugeID)
                             REFERENCES dbo.Gauges
go

ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (FlowUpDownGaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (IPInvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (LoginInvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PasswordInvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (PrivPasswordInvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (CommunityInvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.Monitors
       ADD FOREIGN KEY (FlowFilterID)
                             REFERENCES dbo.FlowFilters
go



ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (MonProfileID)
                             REFERENCES dbo.MonProfiles
go


ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (GaugeID)
                             REFERENCES dbo.Gauges
go


ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.MonProfileItems
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.NoticeActives
       ADD FOREIGN KEY (NoticeID)
                             REFERENCES dbo.Notices
go


ALTER TABLE dbo.NoticeLogs
       ADD FOREIGN KEY (NoticeID)
                             REFERENCES dbo.Notices
go


ALTER TABLE dbo.NoticeLogs
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Notices
       ADD FOREIGN KEY (NoticeTypeID)
                             REFERENCES dbo.NoticeTypes
go


ALTER TABLE dbo.Notices
       ADD FOREIGN KEY (NoticeTechID)
                             REFERENCES dbo.NoticeTechs
go

ALTER TABLE dbo.Notices
       ADD FOREIGN KEY (NoticeFormatID)
                             REFERENCES dbo.NoticeFormats
go


ALTER TABLE dbo.NoticeTypes
       ADD FOREIGN KEY (NoticePurposeID)
                             REFERENCES dbo.NoticePurposes
go


ALTER TABLE dbo.Objects
       ADD FOREIGN KEY (ObjectTypeID)
                             REFERENCES dbo.ObjectTypes
go


ALTER TABLE dbo.Objects
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES dbo.ObjectGroups
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES dbo.ObjectGroups
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (SchedBlockTypeID)
                             REFERENCES dbo.SchedBlockTypes
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES dbo.PrintTypes
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go

ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (InvCartID)
                             REFERENCES dbo.InvCarts
go

ALTER TABLE dbo.OperatorScheds
       ADD FOREIGN KEY (SchedTimeID)
                             REFERENCES dbo.SchedTimes
go


ALTER TABLE dbo.OperatorScheds
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.OperatorScheds
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites
go


ALTER TABLE dbo.OperatorScheds
       ADD FOREIGN KEY (SchedBlockID)
                             REFERENCES dbo.SchedBlocks
go


ALTER TABLE dbo.OperatorSchedTimes
       ADD FOREIGN KEY (OperatorSchedID)
                             REFERENCES dbo.OperatorScheds
go


ALTER TABLE dbo.OperatorSchedTimes
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.OrgAccountTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.OrgAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.Organizations
       ADD FOREIGN KEY (CurrencyID)
                             REFERENCES dbo.Currencies
go


ALTER TABLE dbo.Organizations
       ADD FOREIGN KEY (ResellerCustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES dbo.Charges
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES dbo.Payments
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (BatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (FinalStatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (StatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.PaymentTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (PeriodTypeID)
                             REFERENCES dbo.PeriodTypes
go


ALTER TABLE dbo.PayPlans
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.PayPlans
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.PayPlans
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.PayPlans
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.PromoCodes
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.PromoCodes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.PromoCodes
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.PromoCodes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.PromoCodes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.RadATConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadATConfigs
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.RadATConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadAttributes
       ADD FOREIGN KEY (RadVendorID)
                             REFERENCES dbo.RadVendors
go


ALTER TABLE dbo.RadConcurrency
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadConcurrency
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.RadConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadConfigs
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.RadConfigs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RadFilterGroups
       ADD FOREIGN KEY (RadDestTypeID)
                             REFERENCES dbo.RadDestTypes
go


ALTER TABLE dbo.RadFilterGroups
       ADD FOREIGN KEY (RadSourceTypeID)
                             REFERENCES dbo.RadSourceTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadFilterGroupID)
                             REFERENCES dbo.RadFilterGroups
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadFilterTypeID)
                             REFERENCES dbo.RadFilterTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadSearchTypeID)
                             REFERENCES dbo.RadSearchTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.RadInvConfigs
       ADD FOREIGN KEY (InvSourceID)
                             REFERENCES dbo.InvSources
go


ALTER TABLE dbo.RadInvConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadInvConfigs
       ADD FOREIGN KEY (InvAttributeID)
                             REFERENCES dbo.InvAttributes
go


ALTER TABLE dbo.RadInvConfigs
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.RadLogs
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES dbo.RadLogMsgs
go


ALTER TABLE dbo.RadMapAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadMapValues
       ADD FOREIGN KEY (MapAttribute, RadMapTypeID)
                             REFERENCES dbo.RadMapAttributes
go


ALTER TABLE dbo.RadProxyAttributeGroups
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES dbo.RadRoamServers
go


ALTER TABLE dbo.RadProxyAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadProxyAttributes
       ADD FOREIGN KEY (RadSearchTypeID)
                             REFERENCES dbo.RadSearchTypes
go


ALTER TABLE dbo.RadProxyAttributes
       ADD FOREIGN KEY (RadProxyAttributeGroupID)
                             REFERENCES dbo.RadProxyAttributeGroups
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES dbo.RadLogMsgs
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.RadRejects
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadRoamDomains
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadRoamDomains
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES dbo.RadRoamServers
go


ALTER TABLE dbo.RadValues
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RateDataSources
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateHistory
       ADD FOREIGN KEY (RateCostTypeID)
                             REFERENCES dbo.RateCostTypes
go


ALTER TABLE dbo.RateIntervals
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES dbo.RateRuleTypes
go


ALTER TABLE dbo.RateItems
       ADD FOREIGN KEY (RateID)
                             REFERENCES dbo.Rates
go


ALTER TABLE dbo.RateItems
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES dbo.RateTimeGroups
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateRoundTypeID)
                             REFERENCES dbo.RateRoundTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateTypeID)
                             REFERENCES dbo.RateTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES dbo.RateRuleTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (Interval)
                             REFERENCES dbo.RateIntervals
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateCostTypeID)
                             REFERENCES dbo.RateCostTypes
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (RateCostTypeID)
                             REFERENCES dbo.RateCostTypes
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES dbo.RateClasses
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (ClassifierRateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (DataRateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateSourceAttributes
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateStdGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateStdGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateStdItems
       ADD FOREIGN KEY (RateStdGroupID)
                             REFERENCES dbo.RateStdGroups
go


ALTER TABLE dbo.RateStdItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateTimes
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES dbo.RateTimeGroups
go


ALTER TABLE dbo.RateTimes
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateTypes
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVDNISGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.ReferredBys
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (SrcExtMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (DstMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (DstExtMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (SrcAccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (DstAccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (SrcServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (DstServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.RefManagers
       ADD FOREIGN KEY (SrcMarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.RefStates
       ADD FOREIGN KEY (RefManagerID)
                             REFERENCES dbo.RefManagers
go


ALTER TABLE dbo.RefStates
       ADD FOREIGN KEY (SrcAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RefStates
       ADD FOREIGN KEY (DstAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RegFCC477AccountTypes
       ADD FOREIGN KEY (RegFCC477TechID)
                             REFERENCES dbo.RegFCC477Techs
go


ALTER TABLE dbo.RegFCC477AccountTypes
       ADD FOREIGN KEY (RegFCC477VoiceTechID)
                             REFERENCES dbo.RegFCC477VoiceTechs
go


ALTER TABLE dbo.RegFCC477AccountTypes
       ADD FOREIGN KEY (RegFCC477VoiceTransportID)
                             REFERENCES dbo.RegFCC477VoiceTransports
go


ALTER TABLE dbo.RegFCC477AccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

ALTER TABLE dbo.RegFCC477Techs
       ADD FOREIGN KEY (RegFCC477VoiceTransportID)
                             REFERENCES dbo.RegFCC477VoiceTransports
go

ALTER TABLE dbo.Regions
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Regions
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go

ALTER TABLE dbo.Regions
       ADD FOREIGN KEY (RegionGroupID)
                             REFERENCES dbo.RegionGroups
go

ALTER TABLE dbo.ReportFields
       ADD FOREIGN KEY (ReportDataTypeID)
                             REFERENCES dbo.ReportDataTypes
go


ALTER TABLE dbo.ReportGroups
       ADD FOREIGN KEY (ReportGroupTypeID)
                             REFERENCES dbo.ReportGroupTypes
go


ALTER TABLE dbo.ReportParameters
       ADD FOREIGN KEY (ReportFieldID)
                             REFERENCES dbo.ReportFields
go


ALTER TABLE dbo.ReportParameters
       ADD FOREIGN KEY (ReportID)
                             REFERENCES dbo.Reports
go


ALTER TABLE dbo.Reports
       ADD FOREIGN KEY (ReportGroupID)
                             REFERENCES dbo.ReportGroups
go


ALTER TABLE dbo.Reports
       ADD FOREIGN KEY (ReportTypeID)
                             REFERENCES dbo.ReportTypes
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Roles
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.Roles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Roles
       ADD FOREIGN KEY (RoleTypeID)
                             REFERENCES dbo.RoleTypes
go


ALTER TABLE dbo.Roles
       ADD FOREIGN KEY (RoleAssignTypeID)
                             REFERENCES dbo.RoleAssignTypes
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES dbo.CommissionGroups
go


ALTER TABLE dbo.SchedBlocks
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SchedBlocks
       ADD FOREIGN KEY (SchedBlockTypeID)
                             REFERENCES dbo.SchedBlockTypes
go


ALTER TABLE dbo.SchedBlocks
       ADD FOREIGN KEY (SchedTimeID)
                             REFERENCES dbo.SchedTimes
go


ALTER TABLE dbo.SchedBlocks
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.SchedTimeItems
       ADD FOREIGN KEY (SchedTimeID)
                             REFERENCES dbo.SchedTimes
go


ALTER TABLE dbo.Schedules
       ADD FOREIGN KEY (Server)
                             REFERENCES dbo.ScheduleServers
go


ALTER TABLE dbo.SearchQueries
       ADD FOREIGN KEY (SearchTypeID)
                             REFERENCES dbo.SearchTypes
go

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (ServiceCategoryID)
		 REFERENCES dbo.ServiceCategories
go

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (OperatorGroupID)
		 REFERENCES dbo.OperatorGroups
go

ALTER TABLE dbo.ServiceCatAccess
	ADD FOREIGN KEY (BulkProfileID)
		 REFERENCES dbo.BulkProfiles
go


ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (ServiceCategoryID,AccountTypeID)
		 REFERENCES dbo.ServiceCatAccountTypes
go

ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (OperatorGroupID)
		 REFERENCES dbo.OperatorGroups
go

ALTER TABLE dbo.ServiceCatATAccess
	ADD FOREIGN KEY (BulkProfileID)
		 REFERENCES dbo.BulkProfiles
go



ALTER TABLE dbo.SectionAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SectionAccountTypes
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionAddressTypes
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.SectionAddressTypes
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionFeatures
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionGlobals
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionGroups
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SectionGroups
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionNames
       ADD FOREIGN KEY (SectionNameGroupID)
                             REFERENCES dbo.SectionNameGroups
go


ALTER TABLE dbo.SectionNames
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionObjects
       ADD FOREIGN KEY (SectionLocationID)
                             REFERENCES dbo.SectionLocations
go


ALTER TABLE dbo.SectionObjects
       ADD FOREIGN KEY (SectionAreaID)
                             REFERENCES dbo.SectionAreas
go


ALTER TABLE dbo.SectionOperatorGroups
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.SectionOperatorGroups
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SectionOperators
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.SectionOperators
       ADD FOREIGN KEY (SectionObjectID)
                             REFERENCES dbo.SectionObjects
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES dbo.PrintTypes
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (EmailTypeID)
                             REFERENCES dbo.EmailTypes
go


ALTER TABLE dbo.ServerAccess
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ServerAccess
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES dbo.RadRoamServers
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (ServerTypeID)
                             REFERENCES dbo.ServerTypes
go


ALTER TABLE dbo.ServiceCatAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ServiceCatAccountTypes
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go

ALTER TABLE dbo.ServiceCatAccountTypes
       ADD FOREIGN KEY (CustServiceLevelTypeID)
                             REFERENCES dbo.ServiceLevelTypes
go



ALTER TABLE dbo.ServiceCategories
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ServiceCategories
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.ServiceCategories
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go


ALTER TABLE dbo.ServiceCatLinks
       ADD FOREIGN KEY (ParentServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.ServiceCatLinks
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.ServiceCatParentAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ServiceCatParentAccountTypes
       ADD FOREIGN KEY (ServiceCategoryID, AccountTypeID)
                             REFERENCES dbo.ServiceCatAccountTypes
go


ALTER TABLE dbo.ServiceCatParentAccountTypes
       ADD FOREIGN KEY (ParentServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.ServiceCatParentAccountTypes
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.ServiceGroupItems
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.ServiceGroupItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (SignupServerID)
                             REFERENCES dbo.SignupServers
go

ALTER TABLE dbo.SignupOptions
       ADD FOREIGN KEY (TimeChargeID)
                             REFERENCES dbo.TimeCharges
go

ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go

ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go

ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (AltAddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.Sites
       ADD FOREIGN KEY (PhysicalAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.Sites
       ADD FOREIGN KEY (ContactAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.SMSREGroups
       ADD FOREIGN KEY (SMSPollerID)
                             REFERENCES dbo.SMSPollers
go


ALTER TABLE dbo.SMSREItems
       ADD FOREIGN KEY (SMSRESourceID)
                             REFERENCES dbo.SMSRESources
go


ALTER TABLE dbo.SMSREItems
       ADD FOREIGN KEY (SMSREActionID)
                             REFERENCES dbo.SMSREActions
go


ALTER TABLE dbo.SMSREItems
       ADD FOREIGN KEY (SMSREGroupID)
                             REFERENCES dbo.SMSREGroups
go


ALTER TABLE dbo.SMSWrites
       ADD FOREIGN KEY (SMSPollerID)
                             REFERENCES dbo.SMSPollers
go


ALTER TABLE dbo.SMSWrites
       ADD FOREIGN KEY (SMSWriteStateID)
                             REFERENCES dbo.SMSWriteStates
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (BatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.States
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Strings
       ADD FOREIGN KEY (ApplicationID)
                             REFERENCES dbo.Applications
go


ALTER TABLE dbo.Strings
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.SubAccountData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccountData
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
GO

ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
GO

ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (ParentAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES dbo.CancelReasons
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (RefAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (ContactAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (ServiceAddressID)
                             REFERENCES dbo.Addresses
go


ALTER TABLE dbo.SubAccountTags
       ADD FOREIGN KEY (CostAccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SubAccountTags
       ADD FOREIGN KEY (CancelItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.SubAccountTags
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccountTags
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go


ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.SyslogAlerts
       ADD FOREIGN KEY (SyslogSourceID)
                             REFERENCES dbo.SyslogSources
go


ALTER TABLE dbo.SyslogAlerts
       ADD FOREIGN KEY (AlertSourceID)
                             REFERENCES dbo.AlertSources
go


ALTER TABLE dbo.SyslogAlerts
       ADD FOREIGN KEY (AlertTypeID)
                             REFERENCES dbo.AlertTypes
go


ALTER TABLE dbo.SyslogAlerts
       ADD FOREIGN KEY (AlertStateID)
                             REFERENCES dbo.AlertStates
go


ALTER TABLE dbo.SyslogAlerts
       ADD FOREIGN KEY (SyslogMsgTypeID)
                             REFERENCES dbo.SyslogMsgTypes
go


ALTER TABLE dbo.SyslogMsgTypeItems
       ADD FOREIGN KEY (SyslogSourceID)
                             REFERENCES dbo.SyslogSources
go


ALTER TABLE dbo.SyslogMsgTypeItems
       ADD FOREIGN KEY (SyslogFacilityID)
                             REFERENCES dbo.SyslogFacilities
go


ALTER TABLE dbo.SyslogMsgTypeItems
       ADD FOREIGN KEY (SyslogSeverityID)
                             REFERENCES dbo.SyslogSeverities
go


ALTER TABLE dbo.SyslogMsgTypeItems
       ADD FOREIGN KEY (SyslogMsgTypeID)
                             REFERENCES dbo.SyslogMsgTypes
go


ALTER TABLE dbo.SysLogs
       ADD FOREIGN KEY (SyslogMsgTypeID)
                             REFERENCES dbo.SyslogMsgTypes
go


ALTER TABLE dbo.SysLogs
       ADD FOREIGN KEY (SyslogSourceID)
                             REFERENCES dbo.SyslogSources
go


ALTER TABLE dbo.SyslogSourceItems
       ADD FOREIGN KEY (SyslogSourceID)
                             REFERENCES dbo.SyslogSources
go


ALTER TABLE dbo.SyslogSourceItems
       ADD FOREIGN KEY (SyslogSourceItemTypeID)
                             REFERENCES dbo.SyslogSourceItemTypes
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES dbo.TaxTypes
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxPiggyBackID)
                             REFERENCES dbo.TaxPiggyBacks
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxSourceID)
                             REFERENCES dbo.TaxSources
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (TaxID)
                             REFERENCES dbo.Taxes
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (AddressDataTypeID2)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (TaxSourceID)
                             REFERENCES dbo.TaxSources
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (AddressCategoryID)
                             REFERENCES dbo.AddressCategories
go


ALTER TABLE dbo.TaxRates
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.TaxRates
       ADD FOREIGN KEY (TaxSourceID)
                             REFERENCES dbo.TaxSources
go


ALTER TABLE dbo.TaxRates
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.TaxRates
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES dbo.TaxTypes
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (AddressDataTypeID2)
                             REFERENCES dbo.AddressDataTypes
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (TaxSourceTypeID)
                             REFERENCES dbo.TaxSourceTypes
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (TaxPiggyBackID)
                             REFERENCES dbo.TaxPiggyBacks
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES dbo.TaxTypes
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (GeoLayerID)
                             REFERENCES dbo.GeoLayers
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (GeoSubLayerID)
                             REFERENCES dbo.GeoSubLayers
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go

ALTER TABLE dbo.TaxSources
       ADD FOREIGN KEY (BillingImportID)
                             REFERENCES dbo.BillingImports
GO

ALTER TABLE dbo.ThemeFilters
       ADD FOREIGN KEY (ThemeMatchTypeID)
                             REFERENCES dbo.ThemeMatchTypes
go


ALTER TABLE dbo.ThemeFilters
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.TimeCharges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.TimeCharges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.TowerAntennas
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.TowerAntennas
       ADD FOREIGN KEY (TowerAntennaTypeID)
                             REFERENCES dbo.TowerAntennaTypes
go


ALTER TABLE dbo.TowerAntennas
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.TowerAntennaServiceCats
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go


ALTER TABLE dbo.TowerAntennaServiceCats
       ADD FOREIGN KEY (TowerAntennaID)
                             REFERENCES dbo.TowerAntennas
go


ALTER TABLE dbo.Towers
       ADD FOREIGN KEY (TowerTypeID)
                             REFERENCES dbo.TowerTypes
go


ALTER TABLE dbo.Towers
       ADD FOREIGN KEY (SiteID)
                             REFERENCES dbo.Sites
go


ALTER TABLE dbo.TrustedFiles
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.WebForwarders
       ADD FOREIGN KEY (WebForwarderTypeID)
                             REFERENCES dbo.WebForwarderTypes
go

ALTER TABLE dbo.WebForwarders
       ADD FOREIGN KEY (WebClientCertTypeID)
                             REFERENCES dbo.WebClientCertTypes
go

ALTER TABLE dbo.WebLinks
       ADD FOREIGN KEY (WebLinkTypeID)
                             REFERENCES dbo.WebLinkTypes
go


ALTER TABLE dbo.WebLinkTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.WebLinkTypes
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.InvCarts
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (InvCartID)
                             REFERENCES dbo.InvCarts
go

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (CreateInvStateID)
                             REFERENCES dbo.InvStates
go

ALTER TABLE dbo.InvCartItems
       ADD FOREIGN KEY (CreateInvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go

ALTER TABLE dbo.InvWarehouseGroups
       ADD FOREIGN KEY (PrimaryInvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD FOREIGN KEY (InvWarehouseGroupID)
                             REFERENCES dbo.InvWarehouseGroups
go

ALTER TABLE dbo.InvWarehouseGroupItems
       ADD FOREIGN KEY (InvWarehouseID)
                             REFERENCES dbo.InvWarehouses
go


ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go

ALTER TABLE dbo.Calendars
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles
go



ALTER TABLE dbo.IPAttributes
       ADD FOREIGN KEY (IPAttributeTypeID)
                             REFERENCES dbo.IPAttributeTypes
go

ALTER TABLE dbo.IPGroups
       ADD FOREIGN KEY (IPAddressTypeID)
                             REFERENCES dbo.IPAddressTypes
go

ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPAttributeID)
                             REFERENCES dbo.IPAttributes
go
ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPInvAllocationID)
                             REFERENCES dbo.IPInvAllocations
go
ALTER TABLE dbo.IPInvAllocReqs
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges
go

ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go
ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates
go
ALTER TABLE dbo.IPInvAllocations
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
go

ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
go
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPInvAllocationID)
                             REFERENCES dbo.IPInvAllocations
go
ALTER TABLE dbo.IPMessages
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges
go

ALTER TABLE dbo.IPRangeAttributes
       ADD FOREIGN KEY (IPAttributeID)
                             REFERENCES dbo.IPAttributes
go
ALTER TABLE dbo.IPRangeAttributes
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges
go

ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
go
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (StatParentIPRangeID)
                             REFERENCES dbo.IPRanges
go
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (IPRangeTypeID)
                             REFERENCES dbo.IPRangeTypes
go
ALTER TABLE dbo.IPRanges
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES dbo.Priorities
go

ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (IPGroupID)
                             REFERENCES dbo.IPGroups
go
ALTER TABLE dbo.InvItems
       ADD FOREIGN KEY (IPRangeID)
                             REFERENCES dbo.IPRanges
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (InvProductID)
                             REFERENCES dbo.InvProducts
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (InvStateID)
                             REFERENCES dbo.InvStates
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (MarketTagID)
                             REFERENCES dbo.MarketTags
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (ServiceCategoryID)
                             REFERENCES dbo.ServiceCategories
go

ALTER TABLE dbo.RadPoolConfigs
       ADD FOREIGN KEY (TowerID)
                             REFERENCES dbo.Towers
go


ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (InvItemID)
                             REFERENCES dbo.InvItems
go

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (OrigInvStateID)
                             REFERENCES dbo.InvStates
go

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (RadPoolConfigID)
                             REFERENCES dbo.RadPoolConfigs
go

ALTER TABLE dbo.RadPoolStates
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go

ALTER TABLE dbo.OperatorPayments
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (NoticeFormatID)
                             REFERENCES dbo.NoticeFormats
go

ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (NoticeTechID)
                             REFERENCES dbo.NoticeTechs
go

ALTER TABLE dbo.BulkMessages
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.Certs
       ADD FOREIGN KEY (CertTypeID)
                             REFERENCES dbo.CertTypes
go

ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (CertID)
                             REFERENCES dbo.Certs
go


ALTER TABLE dbo.CreditCardUpdates
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go

ALTER TABLE dbo.CreditCardUpdates
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES dbo.BatchProcessors
go

ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (CertID)
                             REFERENCES dbo.Certs
go

ALTER TABLE dbo.OperatorPins
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go

ALTER TABLE dbo.OperatorPins
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go

ALTER TABLE dbo.FlowFilterItems
       ADD FOREIGN KEY (FlowFilterID)
                             REFERENCES dbo.FlowFilters
go

ALTER TABLE dbo.FlowFilterItems
       ADD FOREIGN KEY (FlowDirectionID)
                             REFERENCES dbo.FlowDirections
go

ALTER TABLE dbo.SyncLocks
       ADD FOREIGN KEY (SyncID)
                             REFERENCES dbo.Syncs
GO

ALTER TABLE dbo.SyncActives
       ADD FOREIGN KEY (SyncID)
                             REFERENCES dbo.Syncs
GO

ALTER TABLE dbo.SearchFields
       ADD FOREIGN KEY (SearchFieldGroupID)
                             REFERENCES dbo.SearchFieldGroups
go

ALTER TABLE dbo.SearchFields
       ADD FOREIGN KEY (AccessLabelID)
                             REFERENCES dbo.AccessLabels
go

ALTER TABLE dbo.SearchItems
       ADD FOREIGN KEY (SearchID)
                             REFERENCES dbo.Searches
go

ALTER TABLE dbo.SearchItems
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go

ALTER TABLE dbo.SearchItems
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.SearchItems
       ADD FOREIGN KEY (SearchConditionID)
                             REFERENCES dbo.SearchConditions
go

ALTER TABLE dbo.SearchItems
       ADD FOREIGN KEY (SearchFieldID)
                             REFERENCES dbo.SearchFields
go


ALTER TABLE dbo.PIIRetentions
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go

ALTER TABLE dbo.PIIRetentions
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go

ALTER TABLE dbo.PIIRetentions
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go

ALTER TABLE dbo.PIIRetentions
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go

ALTER TABLE dbo.PIIFields
       ADD FOREIGN KEY (PIIRetentionID)
                             REFERENCES dbo.PIIRetentions
go

ALTER TABLE dbo.PIIFields
       ADD FOREIGN KEY (AddressDataTypeID)
                             REFERENCES dbo.AddressDataTypes
go

ALTER TABLE dbo.PIIFields
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go

ALTER TABLE dbo.PIIFields
       ADD FOREIGN KEY (IncidentDataTypeID)
                             REFERENCES dbo.IncidentDataTypes
go

ALTER TABLE dbo.PIIFields
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.RegFCCBLChargeItems
       ADD FOREIGN KEY (RegFCCBLChargeID)
                             REFERENCES dbo.RegFCCBLCharges
go

ALTER TABLE dbo.RegFCCBLChargeItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

ALTER TABLE dbo.RegFCCBLChargeItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go

ALTER TABLE dbo.RegFCCBLChargeItems
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD FOREIGN KEY (RegFCCBLProviderID)
                             REFERENCES dbo.RegFCCBLProviders
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD FOREIGN KEY (RegFCCBLContractID)
                             REFERENCES dbo.RegFCCBLContracts
go

ALTER TABLE dbo.RegFCCBLAccountTypes
       ADD FOREIGN KEY (RegFCCBLChargeID)
                             REFERENCES dbo.RegFCCBLCharges
go

