{CALL CT_InvAttrMaps('Service Transmit Power (dBm)',1,'^\d+$',100)}
go
{CALL CT_InvAttrMaps('Service Receive Sensitivity (dBm)',2,'^-\d+$',200)}
go
{CALL CT_InvAttrMaps('Service Antenna Gain (dBi)',3,'^\d+$',300)}
go
{CALL CT_InvAttrMaps('Service Additional Gain (dB)',4,'^\d+$',400)}
go
{CALL CT_InvAttrMaps('Service Additional Loss (dB)',5,'^-\d+$',400)}
go
{CALL CT_DataTypes(0,'Number',0)}
go
{CALL CT_DataTypes(0,'String',1)}
go
{CALL CT_DataTypes(0,'Values from List',2)}
go
{CALL CT_DataTypes(1,'Values from Query',3)}
go
{CALL CT_DataTypes(1,'Bitmask Values from List',4)}
go
{CALL CT_DataTypes(0,'Configured',5)}
go
{CALL CT_AccountDataTypes('Max Message Size',1,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Home Directory',2,1,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Max Mailbox Size',3,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('HomeDir Limit',4,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Hostname',8,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('IP Address',10,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('NetFlow IP Range',11,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Netflow Collector IP',12,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Proxy Realm',14,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Network Software',19,0,1,2,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('System Type',20,0,1,2,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Modem Speeds',21,0,1,2,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Helm Account Level',23,0,1,2,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Site IP Address',24,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Domain Name',25,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SNMP IP',26,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SNMP Login',27,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SNMP Password',28,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SNMP Priv Password',29,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SNMP Community',30,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Ping IP',31,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Antenna Height (meters)',32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Virtual Circuit ID',40,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('VPI/VCI',41,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Numeric field test',500,1,0,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('String field test',501,1,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Value list test',502,1,0,2,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('UserDir',900,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('NumTries',901,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('AttemptTime',902,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('NumTimesSuspended',903,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('LastLogin',904,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SuspendUserAccount',905,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('ICalEnable',906,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SpellEnable',907,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('NoOfSuggestions',908,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Depth',909,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Options',910,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('SpellChecking',911,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('PreviewSize',912,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('ConfirmOnDelete',913,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('DisplayCompletedTasks',914,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('EntryGranularity',915,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('StartTime',916,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('EndTime',917,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxEventsToDisplay',918,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxTasksToDisplay',919,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxNotesToDisplay',920,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxDailyRecurCount',921,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxWeeklyRecurCount',922,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxMonthlyRecurCount',923,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxYearlyRecurCount',924,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('HoursClock',925,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxNoOfSearchResultsPerPage',926,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxEventTitleLength',927,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxTaskTitleLength',928,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('StartDay',929,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxMailboxSize',930,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('MaxMessages',931,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Flags',932,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Type',933,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('DefaultView',934,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('DefCalName',935,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('TimeZone',936,0,0,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Port',1000,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_AccountDataTypes('Description',1001,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_AccountDataValues(23,'1','Primary')}
go
{CALL CT_AccountDataValues(23,'2','Secondary')}
go
{CALL CT_Applications('Global',1)}
go
{CALL CT_Applications('EmerWeb',2)}
go
{CALL CT_Applications('EmerClock',3)}
go
{CALL CT_Applications('EmerLog',4)}
go
{CALL CT_Applications('EmerDAP',5)}
go
{CALL CT_Applications('RADIUS',6)}
go
{CALL CT_Applications('EmerAuth',7)}
go
{CALL CT_Applications('EmerExport',8)}
go
{CALL CT_BatchStates('Open',1,NULL)}
go
{CALL CT_BatchStates('Failed',2,NULL)}
go
{CALL CT_BatchStates('Succeeded',3,NULL)}
go
{CALL CT_BatchStates('Partial Success',4,NULL)}
go
{CALL CT_BatchStates('Aborted',5,NULL)}
go
{CALL CT_BatchStates('Reversed',6,NULL)}
go
{CALL CT_BatchStates('Processing',7,NULL)}
go
{CALL CT_BatchStates('Initializing',8,NULL)}
go
{CALL CT_BatchTypes('Invoice',1,'Invoice Batch',NULL,'Invoices')}
go
{CALL CT_BatchTypes('Statement',2,'Statement Batch',NULL,'Statements')}
go
{CALL CT_BatchTypes('Payment',3,'Payment Batch',NULL,'Payments')}
go
{CALL CT_BatchTypes('Print Invoice',4,'Print Invoice Batch',NULL,'Invoices')}
go
{CALL CT_BatchTypes('Print Statement',5,'Print Statements Batch',NULL,'Statements')}
go
{CALL CT_BatchTypes('Batch Export',6,'CC/EFT Export Batch',NULL,'ExternalTrans')}
go
{CALL CT_CardDigits(1,0,'Credit Card Compatible (16 digit)',1,'credit_card_number([''4$Current.BatchID'' + ''0000''.substring(0,4-''$Current.BatchID''.length) + ''$floop.Value''],16,1)','/*
Javascript credit card number generator 
Copyright (C) 2006 Graham King graham@darkcoding.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

www.darkcoding.net
*/

var visaPrefixList = new Array( 
    "4539",
    "4556",
    "4916",
    "4532",
    "4929",
    "40240071",
    "4485",
    "4716",
    "4" 
);

var mastercardPrefixList = new Array( 
    "51",
    "52",
    "53",
    "54",
    "55"
);

var amexPrefixList = new Array( 
    "34",
    "37"
);

var discoverPrefixList = new Array("6011");

var dinersPrefixList = new Array(
    "300",
    "301",
    "302",
    "303",
    "36",
    "38"
);

var enRoutePrefixList = new Array( 
    "2014",
    "2149"
);

var jcbPrefixList16 = new Array(
    "3088",
    "3096",
    "3112",
    "3158",
    "3337",
    "3528"
);

var jcbPrefixList15 = new Array(
    "2100",
    "1800"
);

var voyagerPrefixList = new Array("8699");


function strrev(str) {
   if (!str) return '''';
   var revstr='''';
   for (i = str.length-1; i>=0; i--)
       revstr+=str.charAt(i)
   return revstr;
}

/*
''prefix'' is the start of the CC number as a string, any number of digits.
''length'' is the length of the CC number to generate. Typically 13 or 16
*/
function completed_number(prefix, length) {

    var ccnumber = prefix;

    // generate digits

    while ( ccnumber.length < (length - 1) ) {
        ccnumber += Math.floor(Math.random()*10);
    }

    // reverse number and convert to int 

    var reversedCCnumberString = strrev( ccnumber );

    var reversedCCnumber = new Array();
    for ( var i=0; i < reversedCCnumberString.length; i++ ) {
        reversedCCnumber[i] = parseInt( reversedCCnumberString.charAt(i) );   
    }

    // calculate sum    
    
    var sum = 0;
    var pos = 0;
    
    while ( pos < length - 1 ) {

        odd = reversedCCnumber[ pos ] * 2;
        if ( odd > 9 ) {
            odd -= 9;
        }

        sum += odd;

        if ( pos != (length - 2) ) {

            sum += reversedCCnumber[ pos +1 ];
        }
        pos += 2;
    }
    
    // calculate check digit

    var checkdigit = (( Math.floor(sum/10) + 1) * 10 - sum) % 10;
    ccnumber += checkdigit;

    return ccnumber;
    
}

function credit_card_number(prefixList, length, howMany) {

    var result = new Array();
    for (var i = 0; i < howMany; i++) {

        var randomArrayIndex = Math.floor(Math.random() * prefixList.length); 
        var ccnumber = prefixList[ randomArrayIndex ];
        result.push( completed_number(ccnumber, length) );
    }

    return result;
}


')}
go
{CALL CT_CardDigits(0,1,'Numeric Password (10 digit)',2,'''$Rndp.Numeric''.substring(0,10)',NULL)}
go
{CALL CT_CardDigits(0,1,'Numeric Password (8 digit)',3,'''$Rndp.Numeric''.substring(0,8)',NULL)}
go
{CALL CT_CardDigits(0,1,'Numeric Password (6 digit)',4,'''$Rndp.Numeric''.substring(0,6)',NULL)}
go
{CALL CT_CardDigits(0,1,'Numeric Password (12 digit)',5,'''$Rndp.Numeric''.substring(0,12)',NULL)}
go
{CALL CT_CardDigits(0,1,'Numeric Password (14 digit)',6,'''$Rndp.Numeric''.substring(0,14)',NULL)}
go
{CALL CT_CardDigits(0,1,'Password (6 characters)',7,'''$Rndp.Alpha''.substring(0,6)',NULL)}
go
{CALL CT_CardDigits(0,1,'Password (8 characters)',8,'''$Rndp.Alpha''.substring(0,8)',NULL)}
go
{CALL CT_CardDigits(0,1,'Password (10 characters)',9,'''$Rndp.Alpha''.substring(0,10)',NULL)}
go
{CALL CT_CardDigits(0,1,'Password (12 characters)',10,'''$Rndp.Alpha''.substring(0,12)',NULL)}
go
{CALL CT_CardDigits(0,1,'Password (14 characters)',11,'''$Rndp.Alpha''.substring(0,14)',NULL)}
go
{CALL CT_CardDigits(1,0,'Numeric Account (8 digit)',12,'makeseq(''$Variables.LoginPrefix'',''$Current.BatchID'',''$Rndl.Numeric'',8)','var u=new Array();
function makeseq(prefix,batchid,random,len)
{
var answer;
var c=0;
var r;

answer=batchid+''0000''.substring(0,4-batchid.length) + random.substring(0,len-4);
while(u[answer]==1)
	{
	c++;
	r = c.toString();
	answer=batchid+''0000''.substring(0,4-batchid.length) + r + random.substring(0,len-4-r.length);
	}
u[answer] = 1;
return prefix + answer;
}
')}
go
{CALL CT_CardDigits(1,0,'Numeric Account (10 digit)',13,'makeseq(''$Variables.LoginPrefix'',''$Current.BatchID'',''$Rndl.Numeric'',10)','var u=new Array();
function makeseq(prefix,batchid,random,len)
{
var answer;
var c=0;
var r;

answer=batchid+''0000''.substring(0,4-batchid.length) + random.substring(0,len-4);
while(u[answer]==1)
	{
	c++;
	r = c.toString();
	answer=batchid+''0000''.substring(0,4-batchid.length) + r + random.substring(0,len-4-r.length);
	}
u[answer] = 1;
return prefix + answer;
}')}
go
{CALL CT_CardDigits(1,0,'Numeric Account (12 digit)',14,'makeseq(''$Variables.LoginPrefix'',''$Current.BatchID'',''$Rndl.Numeric'',12)','var u=new Array();
function makeseq(prefix,batchid,random,len)
{
var answer;
var c=0;
var r;

answer=batchid+''0000''.substring(0,4-batchid.length) + random.substring(0,len-4);
while(u[answer]==1)
	{
	c++;
	r = c.toString();
	answer=batchid+''0000''.substring(0,4-batchid.length) + r + random.substring(0,len-4-r.length);
	}
u[answer] = 1;
return prefix + answer;
}
')}
go
{CALL CT_CardDigits(1,0,'Numeric Account (14 digit)',15,'makeseq(''$Variables.LoginPrefix'',''$Current.BatchID'',''$Rndl.Numeric'',14)','var u=new Array();
function makeseq(prefix,batchid,random,len)
{
var answer;
var c=0;
var r;

answer=batchid+''0000''.substring(0,4-batchid.length) + random.substring(0,len-4);
while(u[answer]==1)
	{
	c++;
	r = c.toString();
	answer=batchid+''0000''.substring(0,4-batchid.length) + r + random.substring(0,len-4-r.length);
	}
u[answer] = 1;
return prefix + answer;
}
')}
go
{CALL CT_CardDigits(1,0,'Numeric Account (16 digit)',16,'makeseq(''$Variables.LoginPrefix'',''$Current.BatchID'',''$Rndl.Numeric'',16)','var u=new Array();
function makeseq(prefix,batchid,random,len)
{
var answer;
var c=0;
var r;

answer=batchid+''0000''.substring(0,4-batchid.length) + random.substring(0,len-4);
while(u[answer]==1)
	{
	c++;
	r = c.toString();
	answer=batchid+''0000''.substring(0,4-batchid.length) + r + random.substring(0,len-4-r.length);
	}
u[answer] = 1;
return prefix + answer;
}
')}
go
{CALL CT_CardDigits(1,0,'Sequential Account (Unique Prefix Required)',17,'makeseq(''$Variables.LoginPrefix'',''$floop.Value'',''$Variables.BatchSize'')','function makeseq(prefix,current,max)
{
return prefix + ''0000000000000000000000000''.substring(0,max.length-current.length) + current;
}')}
go
{CALL CT_CardTypes('mod10','MasterCard',1,16,NULL)}
go
{CALL CT_CardTypes('mod10','VISA',2,13,16)}
go
{CALL CT_CardTypes('mod10','American Express',4,15,NULL)}
go
{CALL CT_CardTypes('mod10','Diners Club',8,14,NULL)}
go
{CALL CT_CardTypes('mod10','Carte Blanche',16,14,NULL)}
go
{CALL CT_CardTypes('mod10','Discover',32,16,NULL)}
go
{CALL CT_CardTypes('none','enRoute',64,15,NULL)}
go
{CALL CT_CardTypes('mod10','JCB',128,16,15)}
go
{CALL CT_CardTypes('mod10','Any',256,NULL,NULL)}
go
{CALL CT_CardTypePrefixes(1,'51')}
go
{CALL CT_CardTypePrefixes(1,'52')}
go
{CALL CT_CardTypePrefixes(1,'53')}
go
{CALL CT_CardTypePrefixes(1,'54')}
go
{CALL CT_CardTypePrefixes(1,'55')}
go
{CALL CT_CardTypePrefixes(2,'4')}
go
{CALL CT_CardTypePrefixes(4,'34')}
go
{CALL CT_CardTypePrefixes(4,'37')}
go
{CALL CT_CardTypePrefixes(8,'30')}
go
{CALL CT_CardTypePrefixes(8,'36')}
go
{CALL CT_CardTypePrefixes(8,'38')}
go
{CALL CT_CardTypePrefixes(16,'389')}
go
{CALL CT_CardTypePrefixes(32,'6011')}
go
{CALL CT_CardTypePrefixes(64,'2014')}
go
{CALL CT_CardTypePrefixes(64,'2149')}
go
{CALL CT_CardTypePrefixes(128,'1800')}
go
{CALL CT_CardTypePrefixes(128,'2131')}
go
{CALL CT_CardTypePrefixes(128,'35')}
go
{CALL CT_CertTypes('Write only encrypted storage',1,0,0,'This certificate type is intended for encrypted storage of sensitive data such as pre-tokenized account numbers',0,0,1)}
go
{CALL CT_ExportTypes('CC - Batch',1,1,1,0,0,0)}
go
{CALL CT_ExportTypes('External - Batch',3,0,0,1,0,0)}
go
{CALL CT_ExportTypes('EFT - Batch',4,1,0,0,0,0)}
go
{CALL CT_ExportTypes('CC - Realtime',5,1,1,0,0,1)}
go
{CALL CT_ExportTypes('EFT - Realtime',6,1,0,0,0,1)}
go
{CALL CT_ExportTypes('External - Realtime',8,0,0,1,0,1)}
go
{CALL CT_ExportTypes('Geocoder - Realtime',9,0,0,0,1,1)}
go
{CALL CT_ExportTypes('CC - Realtime Tokenized',10,1,1,0,0,1)}
go
{CALL CT_Exports(0,NULL,0,NULL,0,NULL,0,NULL,NULL,'MAPP-PC Global Retail PC',2,1,0,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,NULL,0,NULL,0,NULL,0,NULL,NULL,'Card Soft',3,1,0,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'TelePC',4,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(1,'AUTH/TKT',0,NULL,0,NULL,0,NULL,NULL,'PTC',5,1,1,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(1,'AUTH/TKT',0,NULL,0,NULL,0,NULL,NULL,'PTC Non-AVS',6,1,1,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(3,'.APP',0,NULL,0,NULL,3,'.BAD',NULL,'PC-Charge',7,1,1,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(2,'A TIME',0,NULL,0,NULL,0,NULL,NULL,'IC Verify',8,1,0,NULL,NULL,1,0,NULL,NULL,2,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(7,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CyberCash',9,1,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(2,'A TIME',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'IC Verify w/AVS',10,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(0,NULL,0,NULL,0,NULL,0,NULL,NULL,'Domain POS (Card Services)',11,1,0,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'PC-Transact IT',12,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'MAPP-PC Global Retail PC',13,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(1,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'PC Authorize',14,1,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(0,'APPR CAPTURE',0,NULL,0,NULL,0,NULL,NULL,'Global Retail PC AVS',15,1,0,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(NULL,'APPR CAPTURE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Global Retail PC non-AVS',16,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Visanet POS-Partner',17,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(7,'1',0,NULL,0,NULL,7,'2',NULL,'Authorize.net',18,1,0,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(1,'00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CCard (UK)',19,1,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'PC-Transact IT v1.2',20,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(3,'.APP',NULL,NULL,NULL,NULL,3,'.BAD',NULL,'PC-Transact IT configured batch format',21,1,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(2,'A TIME Y',0,NULL,0,NULL,0,NULL,NULL,'Web Authorize (IC Verify Emu)',22,1,0,NULL,NULL,1,0,NULL,NULL,2,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,NULL)}
go
{CALL CT_Exports(1,'A',NULL,NULL,NULL,NULL,1,'D R',NULL,'Shift4',30,5,NULL,NULL,NULL,5,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(1,'APPROVED',0,NULL,0,NULL,0,NULL,'https://concord.net','Concord',31,5,1,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',7,'2','https://secure.authorize.net/gateway/transact.dll','Authorize.Net',32,5,27,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,'1')}
go
{CALL CT_Exports(1,'Settled',NULL,NULL,NULL,NULL,1,'Exception',NULL,'Vital POS-partner 5.2',33,1,NULL,NULL,NULL,0,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','\t',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(7,'1',0,'1',0,'1',7,'2','https://secure.authorize.net/gateway/transact.dll','Authorize.Net (AIM)',37,5,27,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'00',0,'0',0,'0',0,NULL,'https://localhost/Hps.Exchange.PosGateway/PosGatewayService.asmx','Heartland Transaction Gateway',38,5,23,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[AUTHCAPTURE]
<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema">
<soap:Body>
<PosRequest clientType="PosGatewayClient" clientVer="1.0.0.0"
xmlns="http://Hps.Exchange.PosGateway">
<Ver1.0>
<Header>
<LicenseId>9999</LicenseId>
<SiteId>$store</SiteId>
<DeviceId>$terminal</DeviceId>
<UserName>$login</UserName>
<Password>$password</Password>
<SiteTrace>$TransID</SiteTrace>
</Header>
<Transaction>
<CreditSale>
<ManualEntry>
<CardNbr>$CardNumber</CardNbr>
<ExpMonth>$expmm</ExpMonth>
<ExpYear>$expyyyy</ExpYear>
<CardPresent>0</CardPresent>
<ReaderPresent>0</ReaderPresent>
<CVV2>$SecurityCode</CVV2>
<Amt>$Amount</Amt>
</ManualEntry>

<CardHolderData>
<CardHolderFirstName>$CardHolder</CardHolderFirstName>
<CardHolderAddr>$Address</CardHolderAddr>
<CardHolderCity>$City</CardHolderCity>
<CardHolderState>$State</CardHolderState>
<CardHolderZip>$Zip</CardHolderZip>
<CardHolderPhone>$Phone</CardHolderPhone>
</CardHolderData>

</CreditSale>
</Transaction>
</Ver1.0>
</PosRequest>
</soap:Body>
</soap:Envelope>
[VOID]
<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema">
<soap:Body>
<PosRequest clientType="PosGatewayClient" clientVer="1.0.0.0"
xmlns="http://Hps.Exchange.PosGateway">
<Ver1.0>
<Header>
<LicenseId>9999</LicenseId>
<SiteId>$store</SiteId>
<DeviceId>$terminal</DeviceId>
<UserName>$login</UserName>
<Password>$password</Password>
<SiteTrace>$TransID</SiteTrace>
</Header>
<Transaction>

<CreditVoid>
<GatewayTxnId>$ProcTransID</GatewayTxnId>
</CreditVoid>

</Transaction>
</Ver1.0>
</PosRequest>
</soap:Body>
</soap:Envelope>
[CREDIT]
<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema">
<soap:Body>
<PosRequest clientType="PosGatewayClient" clientVer="1.0.0.0"
xmlns="http://Hps.Exchange.PosGateway">
<Ver1.0>
<Header>
<LicenseId>9999</LicenseId>
<SiteId>$store</SiteId>
<DeviceId>$terminal</DeviceId>
<UserName>$login</UserName>
<Password>$password</Password>
<SiteTrace>$TransID</SiteTrace>
</Header>
<Transaction>
<CreditReturn>

<ManualEntry>
<CardNbr>$CardNumber</CardNbr>
<ExpMonth>$expmm</ExpMonth>
<ExpYear>$expyyyy</ExpYear>
<CardPresent>0</CardPresent>
<ReaderPresent>0</ReaderPresent>
<CVV2>$SecurityCode</CVV2>
<Amt>$Amount</Amt>
</ManualEntry>

<CardHolderData>
<CardHolderFirstName>$CardHolder</CardHolderFirstName>
<CardHolderAddr>$Address</CardHolderAddr>
<CardHolderCity>$City</CardHolderCity>
<CardHolderState>$State</CardHolderState>
<CardHolderZip>$Zip</CardHolderZip>
<CardHolderPhone>$Phone</CardHolderPhone>
</CardHolderData>

</CreditReturn>
</Transaction>
</Ver1.0>
</PosRequest>
</soap:Body>
</soap:Envelope>
',0,'0')}
go
{CALL CT_Exports(0,'01',0,'01',0,'01',0,'00','https://orbital1.paymentech.net/authorize','Paymentech Orbital',39,5,11,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CREDIT]
<?xml version="1.0" encoding="UTF-8"?>
<Request>
	<Refund POSEntryMode="01" AccountTypeInd="91" 
		TermEntCapInd="05" CATInfoInd="06" TermLocInd="01" 
		CardHolderAttendanceInd="01" CardPresentInd="N" 
		POSConditionCode="59" AttendedTermDataInd="01" 
		FormatInd="N" HcsTcsInd="T" TxCatg="7" MessageType="FR" 
		Version="2" TzCode="705">
		<Comments>Customer Refund</Comments>
		<AccountNum AccountTypeInd="91">$CardNumber</AccountNum>
		<MerchantID>$Merchant</MerchantID>
		<TerminalID TermEntCapInd="05" CATInfoInd="06" TermLocInd="01" 
			CardPresentInd="N" POSConditionCode="59" AttendedTermDataInd="01">
			$Terminal</TerminalID>
		<BIN>$store</BIN>
		<OrderID>$TransID</OrderID>
		<Amount>$Amount</Amount>
		<Currency CurrencyCode="$Password" CurrencyExponent="2"/>
			<TxDateTime/>
	<CardPresence><CardNP><Exp>$expmm$expyy</Exp></CardNP>
		</CardPresence>
		<POScardID>4</POScardID>
		<EntryDataSrc>02</EntryDataSrc>
	</Refund>
</Request>
[]
<?xml version="1.0" encoding="UTF-8"?>
<Request>
	<AC>
		<CommonData>
			<CommonMandatory AuthOverrideInd="N" LangInd="00" 
				CardHolderAttendanceInd="01" HcsTcsInd="T" TxCatg="$Login" 
				MessageType="$ReqType" Version="2" TzCode="705">
			<AccountNum AccountTypeInd="91">$CardNumber</AccountNum>
			<POSDetails POSEntryMode="01"/>
			<MerchantID>$Merchant</MerchantID>
			<TerminalID TermEntCapInd="05" CATInfoInd="06" TermLocInd="01" 
				CardPresentInd="N" POSConditionCode="59" AttendedTermDataInd="01">
				$Terminal</TerminalID>
			<BIN>$store</BIN>
			<OrderID>$TransID</OrderID>
			<AmountDetails>
				<Amount>$Amount</Amount>
			</AmountDetails>
			<TxTypeCommon TxTypeID="G"/>
			<Currency CurrencyCode="$Password" CurrencyExponent="2"/>
			<CardPresence>
				<CardNP>
					<Exp>$expmm$expyy</Exp>
				</CardNP>
			</CardPresence>
			<TxDateTime/>
		</CommonMandatory>
		<CommonOptional>
			<Comments>$Company</Comments>
			<ShippingRef></ShippingRef>

	<CardSecVal CardSecInd="1">$SecurityCode</CardSecVal>
			<ECommerceData ECSecurityInd="07">
				<ECOrderNum>$transid</ECOrderNum>
			</ECommerceData>
		</CommonOptional>
	</CommonData>
	<Auth>
		<AuthMandatory FormatInd="H"/>
		<AuthOptional>
			<AVSextended>
				<AVSname>$CardHolder</AVSname>
				<AVSaddress1>$Address</AVSaddress1>
				<AVSaddress2></AVSaddress2>
				<AVScity>$City</AVScity>
				<AVSstate>$State2</AVSstate>
				<AVSzip>$Zip</AVSzip>
				<AVScountryCode>$Country2</AVScountryCode>
			</AVSextended>
		</AuthOptional>
	</Auth>
	<Cap>
		<CapMandatory>
		<EntryDataSrc>02</EntryDataSrc>
		</CapMandatory>
		<CapOptional/>
	</Cap>
	</AC>
</Request>
',0,'01')}
go
{CALL CT_Exports(5,'1',0,NULL,6,'1',2,'Declined','https://webservices.primerchants.com/billing/TransactionCentral/ProcessCC.asp','Transaction Central',40,5,9,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,6,'1')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'12','https://payflowpro.paypal.com','Payflow Pro',41,5,27,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'0')}
go
{CALL CT_Exports(0,'A',0,'A S',0,NULL,0,'D S R X','https://www.intellipay.net/LinkSmart/','IntelliPay',42,5,19,NULL,'ini',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'A S')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'2','https://gateway.securenet.com/payment.scrnt','SecureNet',43,5,27,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'G',0,'G',0,'G',0,'D','https://wwws.echo-inc.com/scripts/INR200.EXE','ECHO',44,5,11,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'Approved',0,'Approved',0,'Approved',0,'Declined','https://www.usaepay.com/gate.php','USA ePay',45,5,27,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'Approved')}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',7,'2','https://secure.nelixtransax.net/api/transact.php','NELiX TransaX',46,5,27,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,7,'1')}
go
{CALL CT_Exports(0,'OK',0,'OK',0,'OK',0,'NOTAUTHED REJECTED','https://ukvps.protx.com/vspgateway/service/vspdirect-register.vsp','Protx',47,5,27,NULL,'ini',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'OK')}
go
{CALL CT_Exports(1,'A',1,'A',1,'A',1,'E','https://www.sagepayments.net/cgi-bin/eftBankcard.dll?Retail_Transaction','Sage Payments',48,5,27,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,1,'A')}
go
{CALL CT_Exports(7,'0',7,'0',7,'0',0,NULL,'https://migs.mastercard.com.au/vpcdps','ANZ eGate (MiGS)',49,5,9,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'2',0,NULL,0,'3',0,'5','https://www.govone.com/epay/http/mp.aspx','PayPoint (FirstData)',50,5,25,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'3')}
go
{CALL CT_Exports(0,'000',0,'000',0,'000',0,NULL,'https://gtwy.ippay.com/ippay','IP Pay',51,5,27,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[AUTH]
<ippay>
<TransactionType>AUTHONLY</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<CardNum>$CardNumber</CardNum>
<CardExpMonth>$expmm</CardExpMonth>
<CardExpYear>$expyy</CardExpYear>
<CVV2>$SecurityCode</CVV2>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[CAPTURE]
<ippay>
<TransactionType>SALE</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<CardNum>$CardNumber</CardNum>
<CardExpMonth>$expmm</CardExpMonth>
<CardExpYear>$expyy</CardExpYear>
<CVV2>$SecurityCode</CVV2>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[AUTHCAPTURE]
<ippay>
<TransactionType>CAPT</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<CardNum>$CardNumber</CardNum>
<CardExpMonth>$expmm</CardExpMonth>
<CardExpYear>$expyy</CardExpYear>
<CVV2>$SecurityCode</CVV2>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
<Approval>$ApproveCode</Approval>
</ippay>
[VOID]
<ippay>
<TransactionType>VOID</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<CardNum>$CardNumber</CardNum>
<CardExpMonth>$expmm</CardExpMonth>
<CardExpYear>$expyy</CardExpYear>
<CVV2>$SecurityCode</CVV2>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[CREDIT]
<ippay>
<TransactionType>CREDIT</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<CardNum>$CardNumber</CardNum>
<CardExpMonth>$expmm</CardExpMonth>
<CardExpYear>$expyy</CardExpYear>
<CVV2>$SecurityCode</CVV2>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>',0,'000')}
go
{CALL CT_Exports(1,'APPROVAL',1,'APPROVAL',1,'APPROVAL',0,'DECLINED','http://your server name:port','viaWARP',52,5,26,NULL,'htmlform',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,1,'Good')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'0','https://www.beanstream.com/scripts/process_transaction.asp','beanstream',53,5,26,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'1',NULL,'Westpac PayWay',54,5,26,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'0')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'2','https://www.cbggatewaysecure.com/Controller/client/scrubsEngineCurl.php','Chargeback Guardian',55,5,26,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'0',0,NULL,0,NULL,0,'1','https://www.ecs-pay.net/secure/transaction/process.asp','Instabill',56,5,3,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'5 4',0,'4',0,'5 4',0,'6','https://IPCharge.net/IPCHAPI/rh.aspx','IP Charge (VeriFone)',57,5,27,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CREDIT</PAYMENT_TYPE>
<COMMAND>SALE</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<ACCT_NUM>$CardNumber</ACCT_NUM>
<CUSTOMER_STREET>$Address</CUSTOMER_STREET>
<CUSTOMER_ZIP>$Zip</CUSTOMER_ZIP>
<EXP_MONTH>$expmm</EXP_MONTH>
<EXP_YEAR>$expyy</EXP_YEAR>
<INVOICE>$TransID</INVOICE>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
<PRESENT_FLAG>1</PRESENT_FLAG>
<TRANS_AMOUNT>$Amount</TRANS_AMOUNT>
<PURCHASE_ID>$TransID</PURCHASE_ID>
<CARDHOLDER>$CardHolder</CARDHOLDER>
<CVV2>$SecurityCode</CVV2>
<CUSTOMER_STATE>$State2</CUSTOMER_STATE>
<CUSTOMER_CITY>$City</CUSTOMER_CITY>
</TRANSACTION>
[CREDIT]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CREDIT</PAYMENT_TYPE>
<COMMAND>CREDIT</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TRANS_AMOUNT>$Amount</TRANS_AMOUNT>
<TROUTD>$ProcTransID</TROUTD>
</TRANSACTION>
[VOID]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CREDIT</PAYMENT_TYPE>
<COMMAND>VOID</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TROUTD>$VoidProcTransID</TROUTD>
</TRANSACTION>
[AUTH]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CREDIT</PAYMENT_TYPE>
<COMMAND>PRE_AUTH</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<ACCT_NUM>$CardNumber</ACCT_NUM>
<CUSTOMER_STREET>$Address</CUSTOMER_STREET>
<CUSTOMER_ZIP>$Zip</CUSTOMER_ZIP>
<EXP_MONTH>$expmm</EXP_MONTH>
<EXP_YEAR>$expyy</EXP_YEAR>
<INVOICE>$TransID</INVOICE>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
<PRESENT_FLAG>1</PRESENT_FLAG>
<TRANS_AMOUNT>$Amount</TRANS_AMOUNT>
<PURCHASE_ID>$TransID</PURCHASE_ID>
<CARDHOLDER>$CardHolder</CARDHOLDER>
<CVV2>$SecurityCode</CVV2>
<CUSTOMER_STATE>$State2</CUSTOMER_STATE>
<CUSTOMER_CITY>$City</CUSTOMER_CITY>
</TRANSACTION>
[AUTHCAPTURE]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CREDIT</PAYMENT_TYPE>
<COMMAND>COMPLETION</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TROUTD>$ProcTransID</TROUTD>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
</TRANSACTION>
',0,'7')}
go
{CALL CT_Exports(0,'000 001 002 003 004 005 006 007 008 009 023 024 025 026 027 028 029',0,'000 001 002 003 004 005 006 007 008 009 023 024 025 026 027 028 029',0,'000 001 002 003 004 005 006 007 008 009 023 024 025 026 027 028 029',0,'050','https://www3.moneris.com/gateway2/servlet/MpgRequest','Moneris eSelect',58,5,27,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<?xml version="1.0"?>
<request>
<store_id>$Login</store_id>
<api_token>$Password</api_token>

<purchase>
<order_id>$TransID</order_id>
<cust_id>$CustomerID</cust_id>
<amount>$Amount</amount>
<pan>$CardNumber</pan>
<expdate>$expyy$expmm</expdate>
<crypt_type>1</crypt_type>

<avs_info>
<avs_street_number>$Address</avs_street_number>
<avs_street_name>$Address</avs_street_name>
<avs_zipcode>$Zip</avs_zipcode>
<avs_email>$Email</avs_email>
<avs_custphone>$Phone</avs_custphone>
</avs_info>

<cvd_info>
<cvd_value>$SecurityCode</cvd_value>
<cvd_indicator>$SecurityCodePresent</cvd_indicator>
</cvd_info>

</purchase>
</request>
[AUTH]
<?xml version="1.0"?>
<request>
<store_id>$Login</store_id>
<api_token>$Password</api_token>

<preauth>
<order_id>$TransID</order_id>
<cust_id>$CUstomerID</cust_id>
<amount>$Amount</amount>
<pan>$CardNumber</pan>
<expdate>$expyy$expmm</expdate>
<crypt_type>1</crypt_type>

<avs_info>
<avs_street_number>$Address</avs_street_number>
<avs_street_name>$Address</avs_street_name>
<avs_zipcode>$Zip</avs_zipcode>
<avs_email>$Email</avs_email>
<avs_custphone>$Phone</avs_custphone>
</avs_info>

<cvd_info>
<cvd_value>$SecurityCode</cvd_value>
<cvd_indicator>$SecurityCodePresent</cvd_indicator>
</cvd_info>
</preauth>

</request>
[AUTHCAPTURE]
<?xml version="1.0"?>
<request>
<store_id>$Login</store_id>
<api_token>$Password</api_token>

<completion>
<order_id>$PrevTransID</order_id>
<comp_amount>$Amount</comp_amount>
<txn_number>$ProcTransID</txn_number>
<crypt_type>1</crypt_type>
</completion>

</request>
[VOID]
<?xml version="1.0"?>
<request>
<store_id>$Login</store_id>
<api_token>$Password</api_token>

<purchasecorrection>
<order_id>$PrevTransID</order_id>
<txn_number>$ProcTransID</txn_number>
<crypt_type>1</crypt_type>
</purchasecorrection>

</request>
[CREDIT]
<?xml version="1.0"?>
<request>
<store_id>$Login</store_id>
<api_token>$Password</api_token>

<refund>
<order_id>$PrevTransID</order_id>
<amount>$Amount</amount>
<txn_number>$ProcTransID</txn_number>
<crypt_type>1</crypt_type>
</refund>

</request>',0,'000 001 002 003 004 005 006 007 008 009 023 024 025 026 027 028 029')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,NULL,'https://api.convergepay.com/VirtualMerchant/process.do','Converge (Elavon)',59,5,27,NULL,'ini',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'0')}
go
{CALL CT_Exports(0,'true',0,'true',0,'true',0,'false','https://api.globalgatewaye4.firstdata.com/transaction/v11','Payeezy (First Data)',60,5,27,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<?xml version="1.0" encoding="utf-8" ?>
<Transaction>
<ExactID>$Login</ExactID>
<Password>$Password</Password>
<Transaction_Type>00</Transaction_Type>
<Card_Number>$CardNumber</Card_Number>
<CardHoldersName>$CardHolder</CardHoldersName>
<VerificationStr1>$Address|$Zip|$City|$State|$Country2</VerificationStr1>
<VerificationStr2>$SecurityCode</VerificationStr2>
<Expiry_Date>$expmm$expyy</Expiry_Date>
<Currency>$CurrencyCode</Currency>
<DollarAmount>$Amount</DollarAmount>
<Customer_Ref>$CustomerID</Customer_Ref>
<Reference_No>$TransID</Reference_No>
<Client_Email>$Email</Client_Email>
</Transaction>
[AUTH]
<?xml version="1.0" encoding="utf-8" ?>
<Transaction>
<ExactID>$Login</ExactID>
<Password>$Password</Password>
<Transaction_Type>01</Transaction_Type>
<Card_Number>$CardNumber</Card_Number>
<CardHoldersName>$CardHolder</CardHoldersName>
<VerificationStr1>$Address|$Zip|$City|$State|$Country2</VerificationStr1>
<VerificationStr2>$SecurityCode</VerificationStr2>
<Expiry_Date>$expmm$expyy</Expiry_Date>
<Currency>$CurrencyCode</Currency>
<DollarAmount>$Amount</DollarAmount>
<Customer_Ref>$CustomerID</Customer_Ref>
<Reference_No>$TransID</Reference_No>
<Client_Email>$Email</Client_Email>
</Transaction>
[AUTHCAPTURE]
<?xml version="1.0" encoding="utf-8" ?>
<Transaction>
<ExactID>$Login</ExactID>
<Password>$Password</Password>
<Transaction_Type>32</Transaction_Type>
<Transaction_Tag>$ProcTrans1</Transaction_Tag>
<Authorization_Num>$ProcTrans2</Authorization_Num>
<Currency>$CurrencyCode</Currency>
<DollarAmount>$Amount</DollarAmount>
<Customer_Ref>$CustomerID</Customer_Ref>
<Reference_No>$PrevTransID</Reference_No>
</Transaction>
[VOID]
<?xml version="1.0" encoding="utf-8" ?>
<Transaction>
<ExactID>$Login</ExactID>
<Password>$Password</Password>
<Transaction_Type>33</Transaction_Type>
<Transaction_Tag>$ProcTrans1</Transaction_Tag>
<Authorization_Num>$ProcTrans2</Authorization_Num>
<Currency>$CurrencyCode</Currency>
<DollarAmount>$Amount</DollarAmount>
<Customer_Ref>$CustomerID</Customer_Ref>
<Reference_No>$PrevTransID</Reference_No>
</Transaction>
[CREDIT]
<?xml version="1.0" encoding="utf-8" ?>
<Transaction>
<ExactID>$Login</ExactID>
<Password>$Password</Password>
<Transaction_Type>34</Transaction_Type>
<Transaction_Tag>$ProcTrans1</Transaction_Tag>
<Authorization_Num>$ProcTrans2</Authorization_Num>
<Currency>$CurrencyCode</Currency>
<DollarAmount>$Amount</DollarAmount>
<Customer_Ref>$CustomerID</Customer_Ref>
<Reference_No>$PrevTransID</Reference_No>
</Transaction>',0,'true')}
go
{CALL CT_Exports(0,'AUTHORISED',0,'AUTHORISED',2,'1 2 3 4 5 6 7 8 9',0,'REFUSED','https://secure.worldpay.com/jsp/merchant/xml/paymentService.jsp','World Pay',61,5,25,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<submit>
<order orderCode="$TransID">
<description>Transaction $TransID</description>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
<paymentDetails>
<$WorldPayType>
<cardNumber>$CardNumber</cardNumber>
<expiryDate><date month="$expmm" year="$expyyyy"/></expiryDate>
<cardHolderName>$CardHolder</cardHolderName>
<cvc>$SecurityCode</cvc>
<cardAddress>
<address><address1>$Address</address1>
<postalCode>$Zip</postalCode>
<city>$City</city>
<state>$State</state>
<countryCode>$Country2</countryCode>
<telephoneNumber>$Phone</telephoneNumber>
</address>
</cardAddress>
</$WorldPayType>
</paymentDetails>
<shopper><shopperEmailAddress>$Email</shopperEmailAddress></shopper>
<shopperAdditionalData><shopperAccountNumber>$CustomerID</shopperAccountNumber></shopperAdditionalData>
<dynamicInteractionType type="$WorldPayDIT" />
</order>
</submit>
</paymentService>
[VOID]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<cancel/>
</orderModification>
</modify>
</paymentService>
[CREDIT]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<refund>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
</refund>
</orderModification>
</modify>
</paymentService>',2,'1 2 3 4 5 6 7 8 9')}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',7,'2','https://secure.mobiusgateway.com/api/transact.php','Mobius Payments',62,5,27,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,7,'1')}
go
{CALL CT_Exports(0,'000',0,'000',0,'000',0,NULL,'https://gtwy.ippay.com/ippay','IP Pay',63,10,27,'token_cc_ippay_f.ews','xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[AUTH]
<ippay>
<TransactionType>AUTHONLY</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<Token>$Token</Token>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[CAPTURE]
<ippay>
<TransactionType>SALE</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<Token>$Token</Token>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[AUTHCAPTURE]
<ippay>
<TransactionType>CAPT</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<Token>$Token</Token>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
<Approval>$ApproveCode</Approval>
</ippay>
[VOID]
<ippay>
<TransactionType>VOID</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<Token>$Token</Token>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>
[CREDIT]
<ippay>
<TransactionType>CREDIT</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Origin>$Terminal</Origin>
<Password>$Password</Password>
<OrderNumber>$TransID</OrderNumber>
<Token>$Token</Token>
<CardName>$CardHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<BillingAddress>$Address</BillingAddress>
<BillingCity>$City</BillingCity>
<BillingPostalCode>$Zip</BillingPostalCode>
<BillingCountry>$Country3</BillingCountry>
<BillingPhone>$Phone</BillingPhone>
<Email>$Email</Email>
<UDField3>CustomerID $CustomerID</UDField3>
</ippay>',0,'000')}
go
{CALL CT_Exports(0,'AUTHORISED',0,'AUTHORISED',2,'1 2 3 4 5 6 7 8 9',0,'REFUSED','https://secure.worldpay.com/jsp/merchant/xml/paymentService.jsp','World Pay',64,10,25,'token_cc_worldpay_f.ews','xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<submit>
<order orderCode="$TransID">
<description>Transaction $TransID</description>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
<paymentDetails>
<TOKEN-SSL tokenScope="merchant"> 
<paymentTokenID>$Token</paymentTokenID>
<paymentInstrument>
<cardDetails>
<expiryDate><date month="$expmm" year="$expyyyy"/></expiryDate>
<cardHolderName>$CardHolder</cardHolderName>
<cardAddress>
<address><address1>$Address</address1>
<postalCode>$Zip</postalCode>
<city>$City</city>
<state>$State</state>
<countryCode>$Country2</countryCode>
<telephoneNumber>$Phone</telephoneNumber>
</address>
</cardAddress>
</cardDetails>
</paymentInstrument>
</TOKEN-SSL>
</paymentDetails>
<shopper><shopperEmailAddress>$Email</shopperEmailAddress></shopper>
<shopperAdditionalData><shopperAccountNumber>$CustomerID</shopperAccountNumber></shopperAdditionalData>
<dynamicInteractionType type="$WorldPayDIT" />
</order>
</submit>
</paymentService>
[VOID]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<cancel/>
</orderModification>
</modify>
</paymentService>
[CREDIT]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.0" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<refund>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
</refund>
</orderModification>
</modify>
</paymentService>
',2,'1 2 3 4 5 6 7 8 9')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'2','https://api.authorize.net/xml/v1/request.api','Authorize.Net (AIM)',65,10,27,'token_cc_authnet_f.ews','json',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[AUTH]
{
"createTransactionRequest":
	{
	"merchantAuthentication":
		{
		"name": "$Login",
		"transactionKey": "$Password"
		},
	"refId": "$TransID",
	"transactionRequest":
		{
		"transactionType": "authOnlyTransaction",
		"amount": "$Amount",
		"currencyCode": "$CurrencyCode",
		"profile":
			{
			"customerProfileId": "$Token"
			}
		}
	}
}
[AUTHCAPTURE]
{
"createTransactionRequest":
	{
	"merchantAuthentication":
		{
		"name": "$Login",
		"transactionKey": "$Password"
		},
	"refId": "$TransID",
	"transactionRequest":
		{
		"transactionType": "priorAuthCaptureTransaction",
		"amount": "$Amount",
		"currencyCode": "$CurrencyCode",
		"refTransId": "$ProcTransID"
		}
	}
}
[CAPTURE]
{
"createTransactionRequest":
	{
	"merchantAuthentication":
		{
		"name": "$Login",
		"transactionKey": "$Password"
		},
	"refId": "$TransID",
	"transactionRequest":
		{
		"transactionType": "authCaptureTransaction",
		"amount": "$Amount",
		"currencyCode": "$CurrencyCode",
		"profile":
			{
			"customerProfileId": "$Token"
			},
		"transactionSettings":
			{
	                "setting":
				{
				"settingName": "recurringBilling",
				"settingValue": "$AutoBillTF"
				}
			}
		}
	}
}
[VOID]
{
"createTransactionRequest":
	{
	"merchantAuthentication":
		{
		"name": "$Login",
		"transactionKey": "$Password"
		},
	"refId": "$TransID",
	"transactionRequest":
		{
		"transactionType": "voidTransaction",
		"refTransId": "$ProcTransID"
		}
	}
}
[CREDIT]
{
"createTransactionRequest":
	{
	"merchantAuthentication":
		{
		"name": "$Login",
		"transactionKey": "$Password"
		},
	"refId": "$TransID",
	"transactionRequest":
		{
		"transactionType": "refundTransaction",
		"amount": "$Amount",
		"currencyCode": "$CurrencyCode",
		"payment": 
			{
			"creditCard":
				{
				"cardNumber": "$CardNumber",
				"expirationDate": "XXXX"
				}
			},
		"refTransId": "$ProcTransID"
		}
	}
}',0,'1')}
go
{CALL CT_Exports(1,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Generic',99,1,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL CreditCardExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Account Export',100,3,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL UserExport($esid,$FileMode)}','\t',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Telecheck',201,4,NULL,NULL,'telecheck',1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(1,'1',NULL,NULL,NULL,NULL,1,'2',NULL,'Authorize.net',202,4,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(7,'1',0,'1',0,'1',7,'2','https://secure.authorize.net/gateway/transact.dll','Authorize.Net',203,6,25,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,'1')}
go
{CALL CT_Exports(7,'1',0,'1',0,'1',7,'2','https://secure.authorize.net/gateway/transact.dll','Authorize.Net (AIM)',204,6,25,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,0,'1')}
go
{CALL CT_Exports(5,'1',0,NULL,6,'1',2,'Declined','https://webservices.primerchants.com/billing/TransactionCentral/processcheckonline.asp','Transaction Central',205,6,9,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,6,'1')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'12','https://payflowpro.paypal.com','Payflow Pro',206,6,25,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'0')}
go
{CALL CT_Exports(0,'R',0,NULL,0,'R',0,'D','https://wwws.echo-inc.com/scripts/INR200.EXE','ECHO',207,6,9,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'Approved',0,'Approved',0,'Approved',0,'Declined','https://www.usaepay.com/gate.php','USA ePay',208,6,25,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'Approved')}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',7,'2','https://secure.nelixtransax.net/api/transact.php','NELiX TransaX',209,6,25,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,7,'1')}
go
{CALL CT_Exports(0,'2',0,NULL,0,'3',0,'5','https://www.govone.com/epay/http/mp.aspx','PayPoint (FirstData)',210,6,25,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'3')}
go
{CALL CT_Exports(0,'000',0,'000',0,'000',0,NULL,'https://gtwy.ippay.com/ippay','IP Pay',211,6,25,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<JetPay>
<TransactionType>CHECK</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Password>$Password</Password>
<CardName>$AccountHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<ACH Type = "$BankTransTypeIP" SEC = "$Merchant">
<AccountNumber>$AccountNumber</AccountNumber>
<ABA>$BankNumber</ABA>
<CheckNumber>$TransID</CheckNumber>
</ACH>
</JetPay>
[VOID]
<JetPay>
<TransactionType>VOIDACH</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$ProcTransID</TransactionID>
<Password>$Password</Password>
<CardName>$AccountHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<ACH Type = "$BankTransTypeIP" SEC = "$Merchant">
<AccountNumber>$AccountNumber</AccountNumber>
<ABA>$BankNumber</ABA>
<CheckNumber>$TransID</CheckNumber>
</ACH>
</JetPay>
[CREDIT]
<JetPay>
<TransactionType>REVERSAL</TransactionType>
<TerminalID>$Login</TerminalID>
<TransactionID>$TransactionID</TransactionID>
<Password>$Password</Password>
<CardName>$AccountHolder</CardName>
<TotalAmount>$Amount</TotalAmount>
<ACH Type = "$BankTransTypeIP" SEC = "$Merchant">
<AccountNumber>$AccountNumber</AccountNumber>
<ABA>$BankNumber</ABA>
<CheckNumber>$TransID</CheckNumber>
</ACH>
</JetPay>',0,'000')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'2','https://gateway.securenet.com/payment.scrnt','SecureNet',212,6,25,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}','|',NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'1',0,'1',0,'1',0,'0','https://www.beanstream.com/scripts/process_transaction.asp','beanstream',213,6,24,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'1')}
go
{CALL CT_Exports(0,'4',0,'4',0,'4',0,'6','https://APIDemo.IPCharge.net/IPCHAPI/RH.aspx','IP Charge (VeriFone)',214,6,25,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CHECK</PAYMENT_TYPE>
<COMMAND>SALE</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TRANS_AMOUNT>$Amount</TRANS_AMOUNT>
<ABA_NUM>$BankNumber</ABA_NUM>
<ACCT_NUM>$AccountNumber</ACCT_NUM>
<CUSTOMER_STREET>$Address</CUSTOMER_STREET>
<CUSTOMER_ZIP>$Zip</CUSTOMER_ZIP>
<CHECK_TYPE>0</CHECK_TYPE>
<CUSTOMER_ID_TYPE>$idtype</CUSTOMER_ID_TYPE>
<CUSTOMER_ID_DD>$birthdd</CUSTOMER_ID_DD>
<CUSTOMER_ID_MM>$birthmm</CUSTOMER_ID_MM>
<CUSTOMER_ID_YY>$birthyyyy</CUSTOMER_ID_YY>
<CUSTOMER_ID_STATE>$DLNumber</CUSTOMER_ID_STATE>
<CUSTOMER_BANK>$BankName</CUSTOMER_BANK>
<CUSTOMER_CITY>$City</CUSTOMER_CITY>
<CUSTOMER_COUNTRY>$Country2</CUSTOMER_COUNTRY>
<CUSTOMER_FIRSTNAME>$AccountHolder</CUSTOMER_FIRSTNAME>
<CUSTOMER_LASTNAME></CUSTOMER_LASTNAME>
<CUSTOMER_PHONE>$Phone</CUSTOMER_PHONE>
<CUSTOMER_STATE>$State2</CUSTOMER_STATE>
<BANK_ACCOUNT_TYPE>$BankTransTypeFC</BANK_ACCOUNT_TYPE>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
<CUSTOMER_ID_NUM>$DLNumber$SSN</CUSTOMER_ID_NUM>
<CUSTOMER_EMAIL>$Email</CUSTOMER_EMAIL>
</TRANSACTION>
[CREDIT]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CHECK</PAYMENT_TYPE>
<COMMAND>CREDIT</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TRANS_AMOUNT>$Amount</TRANS_AMOUNT>
<ABA_NUM>$BankNumber</ABA_NUM>
<ACCT_NUM>$AccountNumber</ACCT_NUM>
<CUSTOMER_STREET>$Address</CUSTOMER_STREET>
<CUSTOMER_ZIP>$Zip</CUSTOMER_ZIP>
<CHECK_TYPE>0</CHECK_TYPE>
<CUSTOMER_ID_TYPE>$idtype</CUSTOMER_ID_TYPE>
<CUSTOMER_ID_DD>$birthdd</CUSTOMER_ID_DD>
<CUSTOMER_ID_MM>$birthmm</CUSTOMER_ID_MM>
<CUSTOMER_ID_YY>$birthyyyy</CUSTOMER_ID_YY>
<CUSTOMER_ID_STATE>$DLNumber</CUSTOMER_ID_STATE>
<CUSTOMER_BANK>$BankName</CUSTOMER_BANK>
<CUSTOMER_CITY>$City</CUSTOMER_CITY>
<CUSTOMER_COUNTRY>$Country2</CUSTOMER_COUNTRY>
<CUSTOMER_FIRSTNAME>$AccountHolder</CUSTOMER_FIRSTNAME>
<CUSTOMER_LASTNAME></CUSTOMER_LASTNAME>
<CUSTOMER_PHONE>$Phone</CUSTOMER_PHONE>
<CUSTOMER_STATE>$State2</CUSTOMER_STATE>
<BANK_ACCOUNT_TYPE>$BankTransTypeFC</BANK_ACCOUNT_TYPE>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
<CUSTOMER_ID_NUM>$DLNumber$SSN</CUSTOMER_ID_NUM>
<CUSTOMER_EMAIL>$Email</CUSTOMER_EMAIL>
<TROUTD>$ProcTransID</TROUTD>
</TRANSACTION>
[VOID]
<TRANSACTION>
<FUNCTION_TYPE>PAYMENT</FUNCTION_TYPE>
<PAYMENT_TYPE>CHECK</PAYMENT_TYPE>
<COMMAND>VOID</COMMAND>
<USER_ID>$Login</USER_ID>
<USER_PW>$Password</USER_PW>
<CLIENT_ID>$Store</CLIENT_ID>
<MERCHANTKEY>$Merchant</MERCHANTKEY>
<TROUTD>$ProcTransID</TROUTD>
<BATCH_TRACE_ID>$TransID</BATCH_TRACE_ID>
</TRANSACTION>',0,'7')}
go
{CALL CT_Exports(0,'.',0,NULL,0,NULL,0,'R. U. I.',NULL,'RBC Standard 152',215,4,13,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL RBCExport($BatchProcessorID,$CustomerID)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,NULL,'https://api.convergepay.com/VirtualMerchant/process.do','Converge (Elavon)',216,6,17,NULL,'ini',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,0,'0')}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',7,'2','https://secure.mobiusgateway.com/api/transact.php','Mobius Payments',217,6,27,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,NULL,7,'1')}
go
{CALL CT_Exports(0,'CAPTURED AUTHORISED',0,NULL,2,'1 2 3 4 5 6 7 8 9',0,'REFUSED','https://secure.worldpay.com/jsp/merchant/xml/paymentService.jsp','World Pay',218,6,25,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',NULL,NULL,'[CAPTURE]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.4" merchantCode="$Merchant">
<submit>
<order orderCode="$TransID">
<description>Transaction $TransID</description>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
<paymentDetails>
<ACH_DIRECT_DEBIT-SSL><echeckSale>
<companyName>$Company</companyName>
<billingAddress><address>
<firstName>$FirstName</firstName>
<lastName>$LastName</lastName>
<address1>$Address</address1>
<postalCode>$Zip</postalCode>
<city>$City</city>
<state>$State2</state>
<countryCode>$Country2</countryCode>
</address></billingAddress>
<bankAccountType>$BankTransTypeWP</bankAccountType>
<accountNumber>$AccountNumber</accountNumber>
<routingNumber>$BankNumber</routingNumber>
<customIdentifier>TID $TransID</customIdentifier>
</echeckSale></ACH_DIRECT_DEBIT-SSL>
</paymentDetails>
<shopper><shopperEmailAddress>$Email</shopperEmailAddress></shopper>
<shopperAdditionalData><shopperAccountNumber>$CustomerID</shopperAccountNumber></shopperAdditionalData>
</order>
</submit>
</paymentService>
[VOID]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.4" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<cancel/>
</orderModification>
</modify>
</paymentService>
[CREDIT]
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE paymentService PUBLIC "-//WorldPay//DTD WorldPay PaymentService v1//EN" "http://dtd.worldpay.com/paymentService_v1.dtd">
<paymentService version="1.4" merchantCode="$Merchant">
<modify>
<orderModification orderCode="$PrevTransID">
<refund>
<amount currencyCode="$CurrencyCode" exponent="2" value="$Amount"/>
</refund>
</orderModification>
</modify>
</paymentService>',2,'1 2 3 4 5 6 7 8 9')}
go
{CALL CT_Exports(0,'6D',0,NULL,0,'6C',0,NULL,NULL,'CIBC 80',219,4,13,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL CIBCExport($BatchProcessorID,$CustomerID)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(1,'A',NULL,NULL,NULL,NULL,1,'D',NULL,'Generic',299,4,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(0,'L R',0,NULL,0,NULL,0,NULL,'https://geocoding.geo.census.gov/geocoder/locations/address','US Census.gov geocoder',300,9,1,NULL,'json',2,0,NULL,NULL,1,NULL,2,5000,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'0',0,NULL,0,NULL,0,NULL,'http://myserver:8019/geocode','MS Mappoint (Emergeo Proxy)',301,9,1,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'$code',0,NULL,0,NULL,0,'008','https://geocoder.ca','Geocoder.ca (US and Canada)',302,9,1,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'Parcel GPS StreetSegmentInterpolation AddressRangeInterpolation',0,NULL,0,NULL,0,NULL,'https://geoservices.tamu.edu/Services/Geocode/WebService/GeocoderWebServiceHttpNonParsed_V04_01.aspx','Texas A&M Geo Services',303,9,1,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'Good',0,NULL,0,NULL,0,NULL,'https://dev.virtualearth.net/REST/v1/Locations','Bing Location Services',304,9,1,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'node way relation',0,NULL,0,NULL,0,NULL,'https://nominatim.openstreetmap.org/search','Nominatim OpenStreetMap',305,9,1,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,1,10000,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'street_address',0,NULL,0,NULL,0,NULL,'http://www.datasciencetoolkit.org/maps/api/geocode/json','Data Science Toolkit',306,9,1,NULL,'json',2,0,NULL,NULL,1,NULL,1,5000,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(0,'EXACT_MATCH HIGH_ACCURACY',0,NULL,0,NULL,0,NULL,'https://www.geocode.farm/v3/xml/forward/','Geocode.Farm',307,9,1,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,1,5000,'{CALL GeocoderExport($GeocoderID,$CustomerID,$''SessionRef)}',NULL,NULL,NULL,0,NULL)}
go
{CALL CT_Exports(2,'SetupOK',NULL,NULL,NULL,NULL,2,NULL,NULL,'IIS',1000,3,NULL,NULL,NULL,2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL IISExport($esid,$FileMode)}',NULL,NULL,NULL,NULL,NULL)}
go
{CALL CT_Exports(0,'0 206',0,'0',0,'0',0,NULL,'https://ws.everyone.net/ccc/xrc','Everyone.Net Email Service',1010,8,0,NULL,'ini',2,0,NULL,':',1,NULL,NULL,NULL,'{CALL ESEveryoneNet($esid,$stage)}',NULL,2,'[ADD]
version: 1
clientID: $ClientID
password: $password

createUser ( $ExternalRef ( $OfferID ) "$Login" "$Pass" )
[DELETE]
version: 1
clientID: $clientID
password: $password

deleteUser ( $ExternalRef "$Login" )
[PASS]
version: 1
clientID: $clientID
password: $password

setUserPassword ( $ExternalRef "$Login" "$Pass" )
[ENABLE]
version: 1
clientID: $clientID
password: $password

unsuspendUser ( $ExternalRef "$Login" )
[DISABLE]
version: 1
clientID: $clientID
password: $password

suspendUser ( $ExternalRef "$Login" )
[AUX1]
version: 1
clientID: $clientID
password: $password

setUserNames ( $ExternalRef "$Login" "$FirstName" "" "$LastName" )
[AUX2]
version: 1
clientID: $clientID
password: $password

setUserOffers ( $ExternalRef "$Login" ($OfferID) )
[AUX3]
version: 1
clientID: $clientID
password: $password

createEmailClient ( ($OfferID) "$MailDomain" "$MailDomain" )
[AUX4]
version: 1
clientID: $clientID
password: $password

createEmailAlias ( $ExternalRef "$Login" ( "$Forward" ) )
[AUX5]
version: 1
clientID: $clientID
password: $password

deleteEmailAlias ( $ExternalRef "$Login" )
[AUX6]
version: 1
clientID: $clientID
password: $password

setUserForwarding ( $ExternalRef "$Login" :ForwardingInfo(options $ForwardOption
recipients ( $Forward )
) )',0,'0')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'0','http://myhelmserveraddress:8086/ServiceAPI/httpapi.aspx','Helm 4 Control Panel',1011,8,0,NULL,'xmlencoded',2,0,NULL,':',1,NULL,NULL,NULL,'{CALL ESHelm($esid,$stage)}',NULL,4,NULL,0,'0')}
go
{CALL CT_Exports(7,'1',7,'1',7,'1',0,NULL,'http://mycpanelserveraddress','CPanel Control Panel',1012,8,0,NULL,'jsonflat',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESCPanel($esid,$stage)}',NULL,2,NULL,7,'1')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,NULL,'http://mydirectadminaddress:2222','DirectAdmin Control Panel',1013,8,0,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESDirectAdmin($esid,$stage)}',NULL,2,NULL,0,'0')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'0','http://mysmartermailserver:9998/Services/svcUserAdmin.asmx','SmarterMail',1014,8,0,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESSmarterMail($esid)}',NULL,NULL,'[ADD]
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <AddUser xmlns="http://tempuri.org/">
      <AuthUserName>$authlogin</AuthUserName>
      <AuthPassword>$authpassword</AuthPassword>
      <NewUsername>$login</NewUsername>
      <NewPassword>$Password</NewPassword>
      <DomainName>$domain</DomainName>
      <FirstName>$FirstName</FirstName>
      <LastName>$LastName</LastName>
      <IsDomainAdmin>0</IsDomainAdmin>
    </AddUser>
  </soap12:Body>
</soap12:Envelope>
[DELETE]
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <DeleteUser xmlns="http://tempuri.org/">
      <AuthUserName>$authlogin</AuthUserName>
      <AuthPassword>$authpassword</AuthPassword>
      <Username>$login</Username>
      <DomainName>$domain</DomainName>
    </DeleteUser>
  </soap12:Body>
</soap12:Envelope>
[PASS]
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <UpdateUser xmlns="http://tempuri.org/">
      <AuthUserName>$authlogin</AuthUserName>
      <AuthPassword>$authpassword</AuthPassword>
      <EmailAddress>$login@$domain</EmailAddress>
      <NewPassword>$Password</NewPassword>
      <NewFirstName>$FirstName</NewFirstName>
      <NewLastName>$LastName</NewLastName>
      <IsDomainAdmin>0</IsDomainAdmin>
    </UpdateUser>
  </soap12:Body>
</soap12:Envelope>
[ENABLE]
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <UpdateUser xmlns="http://tempuri.org/">
      <AuthUserName>$authlogin</AuthUserName>
      <AuthPassword>$authpassword</AuthPassword>
      <EmailAddress>$login@$domain</EmailAddress>
      <NewPassword>$Password</NewPassword>
      <NewFirstName>$FirstName</NewFirstName>
      <NewLastName>$LastName</NewLastName>
      <IsDomainAdmin>0</IsDomainAdmin>
    </UpdateUser>
  </soap12:Body>
</soap12:Envelope>
[DISABLE]
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <UpdateUser xmlns="http://tempuri.org/">
      <AuthUserName>$authlogin</AuthUserName>
      <AuthPassword>$authpassword</AuthPassword>
      <EmailAddress>$login@$domain</EmailAddress>
      <NewPassword>$password$authpassword</NewPassword>
      <NewFirstName>$FirstName</NewFirstName>
      <NewLastName>$LastName</NewLastName>
      <IsDomainAdmin>0</IsDomainAdmin>
    </UpdateUser>
  </soap12:Body>
</soap12:Envelope>
',0,'0')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,'0','http://resellertest.enom.com/interface.asp','eNom Domains',1015,8,0,NULL,'xmlencoded',2,0,NULL,NULL,0,NULL,NULL,NULL,'{CALL ESEnom($esid,$stage)}',NULL,4,NULL,0,'0')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,NULL,'http://myserver/myscript','Generic Web Service',1016,8,0,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESGenericWS($esid)}',NULL,1,NULL,0,'0')}
go
{CALL CT_Exports(5,'0',0,'true',0,'true',0,NULL,'https://globalapi.diino.com/partner_api/1.7','Diino Backup Service',1017,8,0,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESDiino($esid,$stage)}',NULL,2,NULL,0,'true')}
go
{CALL CT_Exports(0,'0',0,'0',0,'0',0,NULL,'https://<server>/interopAPI/url/callgate','eFolder Backup Service',1018,8,0,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESEFolder($esid,$stage)}',NULL,2,NULL,0,'0')}
go
{CALL CT_Exports(0,'OK',0,'OK',0,'OK $error',0,'OK','http://google.com','Google Apps (Users)',1019,8,64,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESGMail($esid,$stage)}',NULL,4,'[ADD]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:login userName="$Login" password="$Password" suspended="false"/>
    <apps:name familyName="$LastName" givenName="$FirstName"/>
</atom:entry>
[MODIFY]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:name familyName="$LastName" givenName="$FirstName"/>
</atom:entry>
[LOGIN]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:login userName="$NewLogin"/>
</atom:entry>
[PASS]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:login password="$Password"/>
</atom:entry>
[ENABLE]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:login suspended="false"/>
</atom:entry>
[DISABLE]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#user"/>
    <apps:login suspended="true"/>
</atom:entry>
[AUX2]
<?xml version="1.0" encoding="UTF-8"?>
<atom:entry xmlns:atom="http://www.w3.org/2005/Atom" xmlns:apps="http://schemas.google.com/apps/2006">
    <atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/apps/2006#nickname"/>
    <apps:nickname name="$NewLogin"/>
    <apps:login userName="$Login"/>
</atom:entry>',0,'OK')}
go
{CALL CT_Exports(0,'200',0,'200',0,'200',0,NULL,'https://myserver/ccs/servlet/RequestHandler','Aptilo MAS',1020,8,0,NULL,'urlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESAptilo($esid,$stage)}',NULL,2,NULL,0,'200')}
go
{CALL CT_Exports(0,'OK',0,'OK',0,'OK',0,'OK','https://myzimbraserver:7071/service/admin/soap','Zimbra Mail',1021,8,64,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESZimbra($esid,$stage)}',NULL,3,'[AUX8]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><nosession/></context></soap:Header><soap:Body><AuthRequest xmlns="urn:zimbraAdmin"><name>$APILogin</name><password>$APIPassword</password></AuthRequest></soap:Body></soap:Envelope>
[ADD]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><CreateAccountRequest xmlns="urn:zimbraAdmin"><name>$Login@$Domain</name><password>$Password</password><a n="gn">$FirstName</a><a n="sn">$LastName</a><a n="displayName">$FirstName $LastName</a><a n="street">$Address1</a><a n="l">$City</a><a n="st">$State</a><a n="postalCode">$Zip</a><a n="telephoneNumber">$Phone</a><a n="company">$Company</a><a n="zimbraAccountStatus">active</a><a n="zimbraPrefMailForwardingAddress">$MailForward</a><a n="zimbraCOSId">$COSID</a></CreateAccountRequest></soap:Body></soap:Envelope>
[MODIFY]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><ModifyAccountRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><a n="gn">$FirstName</a><a n="sn">$LastName</a><a n="displayName">$FirstName $LastName</a><a n="street">$Address1</a><a n="l">$City</a><a n="st">$State</a><a n="postalCode">$Zip</a><a n="telephoneNumber">$Phone</a><a n="company">$Company</a><a n="zimbraPrefMailForwardingAddress">$MailForward</a><a n="zimbraCOSId">$COSID</a></ModifyAccountRequest></soap:Body></soap:Envelope>
[ENABLE]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><ModifyAccountRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><a n="zimbraAccountStatus">active</a></ModifyAccountRequest></soap:Body></soap:Envelope>
[DISABLE]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><ModifyAccountRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><a n="zimbraAccountStatus">locked</a></ModifyAccountRequest></soap:Body></soap:Envelope>
[PASS]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><SetPasswordRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><newPassword>$Password</newPassword></SetPasswordRequest></soap:Body></soap:Envelope>
[LOGIN]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><RenameAccountRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><newName>$Login@$Domain</newName></RenameAccountRequest></soap:Body></soap:Envelope>
[DELETE]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><DeleteAccountRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id></DeleteAccountRequest></soap:Body></soap:Envelope>
[AUX2]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><AddAccountAliasRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><alias>$MailAlias</alias></AddAccountAliasRequest></soap:Body></soap:Envelope>
[AUX3]
<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"><soap:Header><context xmlns="urn:zimbra"><authToken>$AuthToken</authToken><nosession/></context></soap:Header><soap:Body><RemoveAccountAliasRequest xmlns="urn:zimbraAdmin"><id>$ProcTransID</id><alias>$MailAlias</alias></RemoveAccountAliasRequest></soap:Body></soap:Envelope>',0,'OK')}
go
{CALL CT_Exports(0,'0',0,NULL,0,'0',0,NULL,'http://myserver/myscript','Detailed Account Sync',1022,8,0,NULL,'xmlencoded',2,0,NULL,NULL,1,NULL,NULL,NULL,'{CALL ESAccountWS($esid)}',NULL,1,NULL,0,'0')}
go
{CALL CT_Exports(2,'.',NULL,NULL,NULL,NULL,0,NULL,NULL,'Connectnc',1299,4,NULL,NULL,NULL,1,0,NULL,NULL,1,'"',NULL,NULL,'{CALL ACHExport($BatchProcessorID,$CustomerID,$partid,$parts)}',',',NULL,NULL,NULL,NULL)}
go
{CALL CT_ExportColumns(0,NULL,2,'10$000000S0','Const1',0,2251,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'CardNumber',1,2252,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,2,'$expmm$expyy','CreditCardExpire',0,2253,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'CardHolder',1,2254,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'Address',1,2255,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'Zip',1,2256,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'Amount',3,2257,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,2,'|||||','Const2',0,2258,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,2,NULL,'TransID',2,2259,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,4,NULL,'CardNumber',1,2260,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,4,'$expmm$expyy','CreditCardExpire',0,2261,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,4,NULL,'Amount',3,2262,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,4,NULL,'Zip',1,2263,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,4,NULL,'Address',7,2264,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,3,'C1','Const1',0,2265,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,3,NULL,'LastModifyUser',1,2266,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,3,NULL,'TransID',2,2267,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,3,NULL,'CardNumber',1,2268,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,3,'$expmm$expyy','CreditCardExpire',0,2269,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,5,'S','Const1',0,2270,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'CardNumber',1,2271,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,5,'$expmm$expyy','CreditCardExpire',0,2272,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'CardHolder',1,2273,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'Address',7,2274,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'Zip',1,2275,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'TransID',2,2276,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,5,'0','Const2',0,2277,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,5,'"1","","","2","","",0.00,','Const3',0,2278,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,5,NULL,'Amount',3,2279,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,6,'S','Const1',0,2280,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,6,NULL,'CardNumber',1,2281,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,6,'$expmm$expyy','CreditCardExpire',0,2282,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,6,NULL,'CardHolder',1,2283,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,6,NULL,'TransID',2,2284,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,6,NULL,'Amount',3,2285,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,7,'1','Const1',0,2286,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,7,NULL,'CardNumber',1,2287,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,7,'$expmm$expyy','CreditCardExpire',0,2288,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,7,NULL,'Amount',3,2289,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,7,NULL,'TransID',2,2290,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,7,NULL,'Zip',1,2291,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,7,NULL,'Address',1,2292,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,8,'C1','Const1',0,2293,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,8,NULL,'TransID',2,2294,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,8,NULL,'CardHolder',1,2295,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,8,NULL,'CardNumber',1,2296,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,8,'$expyy$expmm','CreditCardExpire',0,2297,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,8,NULL,'Amount',3,2298,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'TransID',2,2299,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'CardHolder',1,2300,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'CardNumber',1,2301,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,9,'$expmm$expyy','CreditCardExpire',0,2302,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'Address',7,2303,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'Zip',1,2304,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,9,NULL,'Amount',3,2305,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,10,'C1','Const1',0,2306,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'TransID',2,2307,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'CardHolder',1,2308,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'CardNumber',1,2309,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,10,'$expyy$expmm','CreditCardExpire',0,2310,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'Amount',3,2311,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'Const2',0,2312,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'Zip',1,2313,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,10,NULL,'Address',1,2314,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'CardNumber',1,2315,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,11,'$expyy$expmm','CreditCardExpire',0,2316,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'Amount',3,2317,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'Address',7,2318,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'Zip',1,2319,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'CardHolder',1,2320,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,11,NULL,'TransID',2,2321,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,11,'.00','Const1',0,2322,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(1,NULL,12,'$records','Const1',0,2323,1,4,4,'0',0,1,511)}
go
{CALL CT_ExportColumns(1,NULL,12,'N S','Const2',0,2324,1,3,3,NULL,0,2,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'CardNumber',1,2325,1,16,16,NULL,0,3,511)}
go
{CALL CT_ExportColumns(1,NULL,12,'$expyy$expmm','CreditCardExpire',0,2326,1,4,4,NULL,0,4,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Amount',3,2327,1,12,12,'0',0,5,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Const3',0,2328,1,7,7,NULL,0,6,511)}
go
{CALL CT_ExportColumns(1,NULL,12,'$HH$MM$DD','Const4',0,2329,1,8,8,NULL,0,7,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Const5',0,2330,1,53,53,NULL,0,8,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'TransID',2,2331,1,70,70,NULL,0,9,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Const6',0,2332,1,81,81,NULL,0,10,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Amount',3,2333,1,12,12,NULL,0,11,511)}
go
{CALL CT_ExportColumns(1,NULL,12,'  0','Const7',0,2334,1,3,3,NULL,0,12,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Address',1,2335,1,20,20,NULL,0,13,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Const8',0,2336,1,1,1,NULL,0,14,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'Zip',1,2337,1,9,9,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'TransID',2,2338,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'CardNumber',1,2339,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,14,'$expyy$expmm','CreditCardExpire',0,2340,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'CardHolder',1,2341,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'Address',7,2342,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'Zip',1,2343,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'Amount',3,2344,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'CustomerID',2,2345,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,14,NULL,'TransID',2,2346,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'10$000000S0','Const1',0,2347,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'$MM-$DD-$YYYY $HH:$MI:$SS||','Const2',0,2348,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'CardNumber',1,2349,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'$expyy$expmm','CreditCardExpire',0,2350,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'CardHolder',1,2351,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Address',7,2352,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Zip',1,2353,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Amount',3,2354,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'|||||','Const3',0,2355,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'TransID',2,2356,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,16,'10$000000S0','Const1',0,2357,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,16,'$MM-$DD-$YYYY $HH:$MI:$SS||','Const2',0,2358,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'CardNumber',1,2359,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,16,'$expyy$expmm','CreditCardExpire',0,2360,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'CardHolder',1,2361,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'Address',1,2362,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'Zip',1,2363,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'Amount',3,2364,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,16,'|||||','Const3',0,2365,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,16,NULL,'TransID',2,2366,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'CardNumber',1,2367,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,17,'$expyy$expmm','CreditCardExpire',0,2368,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'Merchant',1,2369,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'Amount',3,2370,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'Zip',1,2371,0,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'Address',7,2372,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,17,'$Address$Zip','Const1',0,2373,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,17,'N,,1,,','Const2',0,2374,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,17,NULL,'TransID',2,2375,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,17,'0','Const3',0,2376,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(1,NULL,17,NULL,'startdd',1,2377,0,2,2,'0',0,11,511)}
go
{CALL CT_ExportColumns(1,NULL,17,NULL,'startmm',1,2378,0,2,2,'0',0,12,511)}
go
{CALL CT_ExportColumns(0,NULL,17,'$startmm$startdd','Const4',0,2379,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,NULL,19,'09','Const1',0,2389,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,19,NULL,'CardNumber',1,2390,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,19,'$expyy$expmm','CreditCardExpire',0,2391,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,19,NULL,'Const2',0,2392,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,19,NULL,'Amount',3,2393,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,19,NULL,'TransID',2,2394,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,19,NULL,'Merchant',1,2395,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'$records','Const1',0,2396,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'N, ,S','Const2',0,2397,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'CardNumber',1,2398,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'$expyy$expmm','CreditCardExpire',0,2399,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'Amount',3,2400,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'      ,','Const3',0,2401,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'$HH$MI','Const4',0,2402,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,20,'$MM$DD','Const5',0,2403,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,20,',,','Const6',0,2404,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'TransID',2,2405,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,20,',','Const7',0,2406,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'Amount',3,2407,1,0,0,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,NULL,20,',0','Const8',0,2408,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'Address',1,2409,1,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'Zip',1,2410,1,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,NULL,20,NULL,'Const9',0,2411,1,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,NULL,21,'$records','Const1',0,2412,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,21,NULL,'TransID',2,2413,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,21,NULL,'CardNumber',1,2414,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,21,'$expyy$expmm','CreditCardExpire',0,2415,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,21,NULL,'Amount',3,2416,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,21,NULL,'Address',1,2417,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,21,NULL,'Zip',1,2418,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,99,NULL,'TransID',2,2419,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,99,NULL,'CardNumber',1,2420,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,99,'$expmm$expyy','CreditCardExpire',0,2421,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,99,NULL,'Amount',3,2422,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,99,NULL,'Zip',1,2423,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,99,NULL,'Address',1,2424,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,13,'10$000000S0','Const1',0,2425,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'CardNumber',1,2426,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,13,'$expmm$expyy','CreditCardExpire',0,2427,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'CardHolder',1,2428,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'Address',1,2429,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'Zip',1,2430,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'Amount',3,2431,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,13,'|||||','Const2',0,2432,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,13,NULL,'TransID',2,2433,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'CardNumber',1,2435,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'$expmm$expyy','CreditCardExpire',0,2436,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'CardHolder',1,2437,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Address',1,2438,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Zip',1,2439,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'Amount',3,2440,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,15,'|||||','Const2',0,2441,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,15,NULL,'TransID',2,2442,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(1,NULL,99,NULL,'expyy',1,2443,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,99,NULL,'expmm',1,2444,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,2,NULL,'expyy',1,2445,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,2,NULL,'expmm',1,2446,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,3,NULL,'expyy',1,2447,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,3,NULL,'expmm',1,2448,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,4,NULL,'expyy',1,2449,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,4,NULL,'expmm',1,2450,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,5,NULL,'expyy',1,2451,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,5,NULL,'expmm',1,2452,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,6,NULL,'expyy',1,2453,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,6,NULL,'expmm',1,2454,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,7,NULL,'expyy',1,2455,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,7,NULL,'expmm',1,2456,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,8,NULL,'expyy',1,2457,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,8,NULL,'expmm',1,2458,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,9,NULL,'expyy',1,2459,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,9,NULL,'expmm',1,2460,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,10,NULL,'expyy',1,2461,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,10,NULL,'expmm',1,2462,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,11,NULL,'expyy',1,2463,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,11,NULL,'expmm',1,2464,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'expyy',1,2465,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,12,NULL,'expmm',1,2466,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,13,NULL,'expyy',1,2467,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,13,NULL,'expmm',1,2468,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,14,NULL,'expyy',1,2469,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,14,NULL,'expmm',1,2470,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,15,NULL,'expyy',1,2471,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,15,NULL,'expmm',1,2472,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,16,NULL,'expyy',1,2473,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,16,NULL,'expmm',1,2474,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,17,NULL,'expyy',1,2475,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,17,NULL,'expmm',1,2476,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,19,NULL,'expyy',1,2479,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,19,NULL,'expmm',1,2480,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,20,NULL,'expyy',1,2481,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,20,NULL,'expmm',1,2482,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,21,NULL,'expyy',1,2483,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,21,NULL,'expmm',1,2484,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,99,NULL,'expyy',1,2485,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,99,NULL,'expmm',1,2486,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'CustomerID',2,2487,1,16,16,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'AccountHolder',1,2488,1,30,30,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'AccountNumber',1,2489,1,20,20,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'Amount',3,2490,1,9,9,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'TransType',1,2491,1,1,1,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'BankNumber',1,2492,1,9,9,NULL,0,6,511)}
go
{CALL CT_ExportColumns(1,NULL,201,NULL,'expyy',1,2493,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(1,NULL,201,NULL,'expmm',1,2494,0,2,2,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,201,'$expyy$expmm','CreditCardExpire',0,2495,1,4,4,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,201,'$this\n!2!','TransID',2,2496,1,20,20,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'CustomerID',2,2497,1,16,16,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'Address',1,2498,1,30,30,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'City',1,2499,1,20,20,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'State',1,2500,1,2,2,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'Zip',1,2501,1,9,9,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,NULL,201,NULL,'PaymentStopDate',0,2502,1,6,6,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'TransID',2,2503,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'TransID',2,2504,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Amount',3,2505,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,202,'ECHECK','PayMethod',0,2506,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,202,'AUTH_CAPTURE','BankTransType',0,2507,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'AuthCode',0,2508,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'TransactionID',0,2509,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'CCNumber',0,2510,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'CCExpire',0,2511,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'AccountNumber',1,2512,1,0,0,NULL,1,10,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'BankNumber',1,2513,1,0,0,NULL,1,11,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'BankName',1,2514,1,0,0,NULL,1,12,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'CustomerID',2,2515,1,0,0,NULL,1,13,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'AccountHolder',1,2516,1,0,0,NULL,1,14,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'LastName',0,2517,1,0,0,NULL,1,15,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Company',1,2518,1,0,0,NULL,1,16,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Address',1,2519,1,0,0,NULL,1,17,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'City',1,2520,1,0,0,NULL,1,18,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'State',1,2521,1,0,0,NULL,1,19,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Zip',1,2522,1,0,0,NULL,1,20,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Phone',0,2523,1,0,0,NULL,1,21,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Fax',0,2524,1,0,0,NULL,1,22,511)}
go
{CALL CT_ExportColumns(0,NULL,202,NULL,'Email',0,2525,1,0,0,NULL,1,23,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'Amount',3,2526,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'AccountHolder',1,2527,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'BankName',1,2528,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'BankNumber',1,2529,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'AccountNumber',1,2530,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'BankTransType',1,2531,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'City',1,2532,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'State',1,2533,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'Zip',1,2534,1,0,0,NULL,1,10,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'Address',1,2535,1,0,0,NULL,1,11,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'Address2',0,2536,1,0,0,NULL,1,12,511)}
go
{CALL CT_ExportColumns(0,NULL,299,NULL,'TransID',2,2537,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'ID',2,2672,1,0,0,NULL,0,1,15)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'Status',1,2673,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'Login',1,2674,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'Email',1,2675,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'Password',1,2676,1,0,0,NULL,0,5,15)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'FirstName',1,2677,1,0,0,NULL,0,6,15)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'LastName',1,2678,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'MailHost',1,2679,1,0,0,NULL,0,8,15)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'HomeDir',1,2680,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'HomeDirLimit',2,2681,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,NULL,100,NULL,'ExpireDay',2,2682,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,NULL,22,'C1','Const1',0,6869,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'TransID',2,6870,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'CardHolder',1,6871,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'CardNumber',1,6872,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,22,'$expyy$expmm','CreditCardExpire',0,6873,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'Amount',3,6874,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'Const2',0,6875,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'Zip',1,6876,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'Address',1,6877,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'expyy',1,6878,0,0,0,NULL,1,0,511)}
go
{CALL CT_ExportColumns(0,NULL,22,NULL,'expmm',1,6879,0,0,0,NULL,1,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'CardHolder',1,30335,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'Amount',3,30336,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'CardNumber',1,30337,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'expyy',1,30338,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'expmm',1,30339,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,'$expyy/$expmm','CreditCardExpire',0,30340,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'LastModifyUser',1,30341,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,33,'Pending Authorization','TransactionType',0,30342,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'startdd',1,30343,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'startyy',1,30344,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'startmm',1,30345,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,33,'$startmm/$startdd/$startyy','DueDate',0,30346,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'Merchant',1,30347,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,NULL,33,NULL,'TransID',2,30348,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'Amount',3,30765,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'AccountHolder',1,30766,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'BankName',1,30767,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'BankNumber',1,30768,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'AccountNumber',1,30769,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'BankTransType',1,30770,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'City',1,30771,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'State',1,30772,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'Phone',1,30773,1,0,0,NULL,1,10,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'Address',1,30774,1,0,0,NULL,1,11,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'Address2',0,30775,1,0,0,NULL,1,12,511)}
go
{CALL CT_ExportColumns(0,NULL,1299,NULL,'TransID',2,30776,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'TransID',2,37605,1,0,0,NULL,1,1,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'TransID',2,37606,1,0,0,NULL,1,2,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Amount',3,37607,1,0,0,NULL,1,3,511)}
go
{CALL CT_ExportColumns(0,NULL,18,'CC','PayMethod',0,37608,1,0,0,NULL,1,4,511)}
go
{CALL CT_ExportColumns(0,NULL,18,'AUTH_CAPTURE','BankTransType',0,37609,1,0,0,NULL,1,5,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'AuthCode',0,37610,1,0,0,NULL,1,6,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'TransactionID',0,37611,1,0,0,NULL,1,7,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'CardNumber',1,37612,1,0,0,NULL,1,8,511)}
go
{CALL CT_ExportColumns(0,NULL,18,'$expmm$expyy','CardExpire',0,37613,1,0,0,NULL,1,9,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'AccountNumber',0,37614,1,0,0,NULL,1,10,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'BankNumber',0,37615,1,0,0,NULL,1,11,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'BankName',0,37616,1,0,0,NULL,1,12,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'CustomerID',2,37617,1,0,0,NULL,1,13,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'CardHolder',1,37618,1,0,0,NULL,1,14,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'LastName',0,37619,1,0,0,NULL,1,15,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Company',1,37620,1,0,0,NULL,1,16,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Address',7,37621,1,0,0,NULL,1,17,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'City',0,37622,1,0,0,NULL,1,18,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'State',0,37623,1,0,0,NULL,1,19,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Zip',1,37624,1,0,0,NULL,1,20,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Phone',0,37625,1,0,0,NULL,1,21,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Fax',0,37626,1,0,0,NULL,1,22,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'Email',0,37627,1,0,0,NULL,1,23,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'expyy',1,37628,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,18,NULL,'expmm',1,37629,0,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,'THB - API Signature',30,'$0','Const1',0,37630,1,2,2,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,'THB - Function Request',30,'1D','Const2',0,37631,1,2,2,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,'THB - Requester Reference',30,NULL,'TransID',2,37632,1,12,12,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'THB - Error Indicator',30,'N','Const3',0,37633,1,1,1,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'THB - Error Pri/Sec Codes',30,NULL,'Const4',0,37634,1,9,9,NULL,0,15,511)}
go
{CALL CT_ExportColumns(1,'THB - Merchant ID',30,NULL,'Merchant',2,37635,1,10,10,'0',0,16,511)}
go
{CALL CT_ExportColumns(1,'THB - Tran ID',30,NULL,'Const5',0,37636,1,10,10,'0',0,17,511)}
go
{CALL CT_ExportColumns(0,'THB - Invoice',30,NULL,'TransID',1,37637,1,10,10,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'THB - Card Number',30,NULL,'CardNumber',1,37638,1,19,19,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'VDB - FS & DTI',30,'$FS$Const9','Const7',0,37639,1,4,4,NULL,0,100,511)}
go
{CALL CT_ExportColumns(0,'VDB - Vendor',30,'Emerald v4 - Export v$version','Const8',0,37640,1,35,35,NULL,0,101,511)}
go
{CALL CT_ExportColumns(0,'VDB - DTI 000',30,'000','Const9',0,37641,0,0,0,NULL,0,102,511)}
go
{CALL CT_ExportColumns(0,'STB - DTI 001',30,'001','Const10',0,37642,0,0,0,NULL,0,200,511)}
go
{CALL CT_ExportColumns(0,'STB - FS & DTI',30,'$FS$Const10','Const11',0,37643,1,4,4,NULL,0,201,511)}
go
{CALL CT_ExportColumns(0,'STB - Card Type',30,NULL,'CardType',1,37644,1,2,2,NULL,0,202,511)}
go
{CALL CT_ExportColumns(0,'STB - Card Entry Mode',30,'M','Const12',0,37645,1,1,1,NULL,0,203,511)}
go
{CALL CT_ExportColumns(0,'STB - Card Present',30,'N','Const13',0,37646,1,1,1,NULL,0,204,511)}
go
{CALL CT_ExportColumns(1,'STB - expyy',30,NULL,'expyy',1,37647,0,2,2,'0',0,205,511)}
go
{CALL CT_ExportColumns(1,'STB - expmm',30,NULL,'expmm',1,37648,0,2,2,'0',0,206,511)}
go
{CALL CT_ExportColumns(0,'STB - Expiration Date',30,'$expmm$expyy','CreditCardExpire',0,37649,1,4,4,NULL,0,207,511)}
go
{CALL CT_ExportColumns(0,'STB - Clerk',30,NULL,'Const14',0,37650,1,5,5,NULL,0,208,511)}
go
{CALL CT_ExportColumns(1,'STB - startyy',30,NULL,'startyy',1,37651,0,2,2,'0',0,209,511)}
go
{CALL CT_ExportColumns(1,'STB - startmm',30,NULL,'startmm',1,37652,0,2,2,'0',0,210,511)}
go
{CALL CT_ExportColumns(1,'STB - startdd',30,NULL,'startdd',1,37653,0,2,2,'0',0,211,511)}
go
{CALL CT_ExportColumns(1,'STB - starthh',30,NULL,'starthh',1,37654,0,2,2,'0',0,212,511)}
go
{CALL CT_ExportColumns(1,'STB - startmi',30,NULL,'startmi',1,37655,0,2,2,'0',0,213,511)}
go
{CALL CT_ExportColumns(1,'STB - startss',30,NULL,'startss',1,37656,0,2,2,'0',0,214,511)}
go
{CALL CT_ExportColumns(0,'STB - Date',30,'$startmm$startdd$startyy','Const15',0,37657,1,6,6,NULL,0,215,511)}
go
{CALL CT_ExportColumns(0,'STB - Time',30,'$starthh$startmi$startss','Const16',0,37658,1,6,6,NULL,0,216,511)}
go
{CALL CT_ExportColumns(0,'STB - Sale Flag',30,'S','Const17',0,37659,1,1,1,NULL,0,217,511)}
go
{CALL CT_ExportColumns(1,'STB - Amount',30,NULL,'Amount',4,37660,1,14,14,'0',0,218,511)}
go
{CALL CT_ExportColumns(1,'STB - Secondary Amount',30,NULL,'Const18',0,37661,1,14,14,'0',0,219,511)}
go
{CALL CT_ExportColumns(0,'STB - Response Code',30,NULL,'Const19',0,37662,1,1,1,NULL,0,220,511)}
go
{CALL CT_ExportColumns(0,'STB - Authorization',30,NULL,'Const20',0,37663,1,6,6,NULL,0,221,511)}
go
{CALL CT_ExportColumns(0,'STB - AVS Result',30,NULL,'Const21',0,37664,1,1,1,NULL,0,222,511)}
go
{CALL CT_ExportColumns(0,'STB - AVS Street Verified',30,NULL,'Const22',0,37665,1,1,1,NULL,0,223,511)}
go
{CALL CT_ExportColumns(0,'STB - AVS Zip Verified',30,NULL,'Const23',0,37666,1,1,1,NULL,0,224,511)}
go
{CALL CT_ExportColumns(0,'AVSB - DTI 002',30,'002','Const24',0,37667,0,3,3,NULL,0,300,511)}
go
{CALL CT_ExportColumns(0,'AVSB - FS & DTI',30,'$FS$Const24','Const25',0,37668,1,4,4,NULL,0,301,511)}
go
{CALL CT_ExportColumns(0,'AVSB - Customer Name',30,NULL,'CardHolder',1,37669,1,35,35,NULL,0,302,511)}
go
{CALL CT_ExportColumns(0,'AVSB - Street Address',30,NULL,'Address',1,37670,1,30,30,NULL,0,303,511)}
go
{CALL CT_ExportColumns(0,'AVSB - Zip Code',30,NULL,'Zip',1,37671,1,9,9,NULL,0,304,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - DTI 022',30,'022','Const26',0,37672,0,3,3,NULL,0,400,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - FS & DTI',30,'$FS$Const26','Const27',0,37673,1,4,4,NULL,0,401,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - CVV2 Indicator',30,NULL,'SecurityCodePresent',1,37674,1,1,1,NULL,0,402,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - Code',30,NULL,'SecurityCode',1,37675,1,4,4,NULL,0,403,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - Result',30,NULL,'Const30',0,37676,1,1,1,NULL,0,404,511)}
go
{CALL CT_ExportColumns(0,'CVV2B - Valid',30,NULL,'Const31',0,37677,1,1,1,NULL,0,405,511)}
go
{CALL CT_ExportColumns(0,'TH - STX',30,'$STX','Const0',0,37678,1,1,1,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'TH - ETX',30,'$ETX','Const100',0,37679,1,1,1,NULL,0,1000,511)}
go
{CALL CT_ExportColumns(0,'TH - LRC',30,'A','Const101',0,37680,1,1,1,NULL,0,1001,511)}
go
{CALL CT_ExportColumns(0,'Method',31,'CreditCardCharge','Method',0,37681,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'TransID',31,NULL,'TransID',2,37682,0,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'TransID',31,'$TransID','ReferenceNumber',0,37683,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',31,NULL,'Amount',3,37684,0,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'Amount',31,'$Amount','TransactionAmount',0,37685,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',31,NULL,'CardNumber',1,37686,0,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',31,'$CardNumber','AccountNumber',0,37687,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'expmm',31,NULL,'expmm',1,37688,0,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,'expmm',31,'$expmm','ExpirationMonth',0,37689,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,'expyy',31,NULL,'expyy',1,37690,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expyy',31,'$expyy','ExpirationYear',0,37691,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'Login',31,NULL,'Login',1,37692,0,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'Login',31,'$Login','Username',0,37693,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'Password',31,NULL,'Password',1,37694,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Address',32,NULL,'Address',10,37695,0,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Address',32,'$Address','x_Address',0,37696,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Amount',32,NULL,'Amount',3,37697,0,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',32,'$Amount','x_Amount',0,37698,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',32,NULL,'CardNumber',10,37699,0,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',32,'$CardNumber','x_Card_Num',0,37700,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'expmm',32,NULL,'expmm',1,37701,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expyy',32,NULL,'expyy',1,37702,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',32,'$expmm$expyy','x_Exp_Date',0,37703,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'x_Method',32,'CC','x_Method',0,37706,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Zip',32,NULL,'Zip',10,37707,0,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'Zip',32,'$Zip','x_Zip',0,37708,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_URL',32,'FALSE','X_ADC_URL',0,37709,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_Delim_Data',32,'TRUE','X_ADC_Delim_Data',0,37710,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,'x_Version',32,'3.0','x_Version',0,37711,1,0,0,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',32,NULL,'CustomerID',2,37712,0,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',32,'$CustomerID','x_cust_id',0,37713,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'TransID',32,NULL,'TransID',2,37714,2,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'TransID',32,'$TransID','x_Invoice_Num',0,37715,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'Login',32,NULL,'Login',1,37716,0,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Login',32,'$Login','x_Login',0,37717,1,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Password',32,NULL,'Password',1,37718,0,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'Password',32,'$Password','x_Password',0,37719,1,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'SecurityCode',32,NULL,'SecurityCode',10,37720,0,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'SecurityCode',32,'$SecurityCode','x_Card_Code',0,37721,1,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'x_relay_response',32,'False','x_relay_response',0,37722,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Address',203,NULL,'Address',1,37723,0,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Address',203,'$Address','x_Address',0,37724,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Amount',203,NULL,'Amount',3,37725,0,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',203,'$Amount','x_Amount',0,37726,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'AccountNumber',203,NULL,'AccountNumber',1,37727,0,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'AccountNumber',203,'$AccountNumber','x_Bank_Acct_Num',0,37728,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'expmm',203,NULL,'expmm',1,37729,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expyy',203,NULL,'expyy',1,37730,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',203,'$expmm$expyy','x_Exp_Date',0,37731,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'AccountHolder',203,NULL,'AccountHolder',1,37732,0,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'AccountHolder',203,'$AccountHolder','x_Last_Name',0,37733,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'x_Method',203,'ECHECK','x_Method',0,37734,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Zip',203,NULL,'Zip',1,37735,0,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'Zip',203,'$Zip','x_Zip',0,37736,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_URL',203,'FALSE','X_ADC_URL',0,37737,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_Delim_Data',203,'TRUE','X_ADC_Delim_Data',0,37738,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,'x_Version',203,'3.0','x_Version',0,37739,1,0,0,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',203,NULL,'CustomerID',2,37740,0,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',203,'$CustomerID','x_cust_id',0,37741,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'TransID',203,NULL,'TransID',2,37742,2,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'TransID',203,'$TransID','x_Invoice_Num',0,37743,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'Login',203,NULL,'Login',1,37744,0,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Login',203,'$Login','x_Login',0,37745,1,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Password',203,NULL,'Password',1,37746,0,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'Password',203,'$Password','x_Password',0,37747,1,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'BankNumber',203,NULL,'BankNumber',1,37748,0,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'BankNumber',203,'$BankNumber','x_Bank_ABA_Code',0,37749,1,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'BankName',203,NULL,'BankName',1,37750,0,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'BankName',203,'$BankName','x_Bank_Name',0,37751,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Company',203,NULL,'Company',1,37752,0,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'Company',203,'$Company','x_Company',0,37753,1,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'BankTransType',203,NULL,'BankTransType',1,37754,0,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'BankTransType',203,'$BankTransType','x_Bank_Acct_Type',0,37755,1,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'Address',203,NULL,'Address',1,37756,0,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'Address',203,'$Address','x_Address',0,37757,1,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'City',203,NULL,'City',1,37758,0,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'City',203,'$City','x_City',0,37759,1,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'Country',203,NULL,'Country',1,37760,0,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Country',203,'$Country','x_Country',0,37761,1,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'SSN',203,NULL,'SSN',1,37762,0,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'SSN',203,'$SSN','x_Customer_Tax_ID',0,37763,1,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'x_Customer_Organization_Type',203,'I','x_Customer_Organization_Type',0,37764,1,0,0,NULL,0,24,511)}
go
{CALL CT_ExportColumns(0,'DLNumber',203,NULL,'DLNumber',1,37765,0,0,0,NULL,0,25,511)}
go
{CALL CT_ExportColumns(0,'DLNumber',203,'$DLNumber','x_Drivers_License_Num',0,37766,1,0,0,NULL,0,25,511)}
go
{CALL CT_ExportColumns(0,'DLState',203,NULL,'DLState',1,37767,0,0,0,NULL,0,26,511)}
go
{CALL CT_ExportColumns(0,'DLState',203,'$DLState','x_Drivers_License_State',0,37768,1,0,0,NULL,0,26,511)}
go
{CALL CT_ExportColumns(0,'birthmm',203,NULL,'birthmm',1,37769,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'birthdd',203,NULL,'birthdd',1,37770,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'birthyyyy',203,NULL,'birthyyyy',1,37771,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'x_Drivers_License_DOB',203,'$birthyyyy/$birthmm/$birthdd','x_Drivers_License_DOB',0,37772,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'x_First_Name',203,NULL,'x_First_Name',0,37773,1,0,0,NULL,0,28,511)}
go
{CALL CT_ExportColumns(0,'x_Freight',203,'0','x_Freight',0,37774,1,0,0,NULL,0,29,511)}
go
{CALL CT_ExportColumns(0,'State',203,NULL,'State',1,37775,0,0,0,NULL,0,30,511)}
go
{CALL CT_ExportColumns(0,'State',203,'$State','x_State',0,37776,1,0,0,NULL,0,30,511)}
go
{CALL CT_ExportColumns(0,'x_Tax',203,'0','x_Tax',0,37777,1,0,0,NULL,0,31,511)}
go
{CALL CT_ExportColumns(0,'x_relay_response',203,'False','x_relay_response',0,37778,1,0,0,NULL,0,32,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'AccountID',2,37779,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'Active',2,37780,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'Path',1,37781,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'AccountType',1,37782,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'Description',1,37783,1,0,0,NULL,0,5,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'Port',1,37784,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'Hostname',1,37785,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,NULL,1000,NULL,'IPAddress',1,37786,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Phone',32,NULL,'Phone',10,37787,0,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Phone',32,'$Phone','x_Phone',0,37788,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'State',32,NULL,'State',10,37789,0,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'State',32,'$State','x_State',0,37790,1,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'City',32,NULL,'City',10,37791,0,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'City',32,'$City','x_City',0,37792,1,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'FirstName',32,NULL,'FirstName',10,37793,0,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'FirstName',32,'$FirstName','x_First_Name',0,37794,1,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'LastName',32,NULL,'LastName',10,37795,0,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'LastName',32,'$LastName','x_Last_Name',0,37796,1,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'Country',32,NULL,'Country',10,37797,0,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Country',32,'$Country','x_Country',0,37798,1,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Email',32,NULL,'Email',10,37799,0,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'Email',32,'$Email','x_Email',0,37800,1,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'Address',37,NULL,'Address',10,37801,0,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Address',37,'$Address','x_Address',0,37802,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Amount',37,NULL,'Amount',3,37803,0,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',37,'$Amount','x_Amount',0,37804,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',37,NULL,'CardNumber',10,37805,0,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'CardNumber',37,'$CardNumber','x_Card_Num',0,37806,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'expmm',37,NULL,'expmm',1,37807,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expyy',37,NULL,'expyy',1,37808,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',37,'$expmm$expyy','x_Exp_Date',0,37809,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'x_Method',37,'CC','x_Method',0,37810,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Zip',37,NULL,'Zip',10,37811,0,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'Zip',37,'$Zip','x_Zip',0,37812,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_URL',37,'FALSE','X_ADC_URL',0,37813,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_Delim_Data',37,'TRUE','X_ADC_Delim_Data',0,37814,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,'x_Version',37,'3.0','x_Version',0,37815,1,0,0,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',37,NULL,'CustomerID',2,37816,0,0,0,NULL,0,3,1023)}
go
{CALL CT_ExportColumns(0,'CustomerID',37,'$CustomerID','x_cust_id',0,37817,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'TransID',37,NULL,'TransID',2,37818,2,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'TransID',37,'$TransID','x_Invoice_Num',0,37819,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'Login',37,NULL,'Login',1,37820,0,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Login',37,'$Login','x_Login',0,37821,1,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Transaction Key',37,NULL,'Password',1,37822,0,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'Transaction Key',37,'$Password','x_tran_key',0,37823,1,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'SecurityCode',37,NULL,'SecurityCode',10,37824,0,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'SecurityCode',37,'$SecurityCode','x_Card_Code',0,37825,1,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'x_relay_response',37,'False','x_relay_response',0,37826,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Phone',37,NULL,'Phone',10,37827,0,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Phone',37,'$Phone','x_Phone',0,37828,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'State',37,NULL,'State',10,37829,0,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'State',37,'$State','x_State',0,37830,1,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'City',37,NULL,'City',10,37831,0,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'City',37,'$City','x_City',0,37832,1,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'FirstName',37,NULL,'FirstName',10,37833,0,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'FirstName',37,'$FirstName','x_First_Name',0,37834,1,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'LastName',37,NULL,'LastName',10,37835,0,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'LastName',37,'$LastName','x_Last_Name',0,37836,1,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'Country',37,NULL,'Country',10,37837,0,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Country',37,'$Country','x_Country',0,37838,1,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Email',37,NULL,'Email',10,37839,0,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'Email',37,'$Email','x_Email',0,37840,1,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'x_type',32,'AUTH_CAPTURE','x_type',0,37841,1,0,0,NULL,0,24,64)}
go
{CALL CT_ExportColumns(0,'x_type',32,'AUTH_ONLY','x_type',0,37842,1,0,0,NULL,0,24,16)}
go
{CALL CT_ExportColumns(0,'x_type',32,'CREDIT','x_type',0,37843,1,0,0,NULL,0,24,256)}
go
{CALL CT_ExportColumns(0,'x_type',32,'VOID','x_type',0,37844,1,0,0,NULL,0,24,128)}
go
{CALL CT_ExportColumns(0,'x_type',32,'PRIOR_AUTH_CAPTURE','x_type',0,37845,1,0,0,NULL,0,24,32)}
go
{CALL CT_ExportColumns(0,'x_type',37,'AUTH_CAPTURE','x_type',0,37846,1,0,0,NULL,0,24,64)}
go
{CALL CT_ExportColumns(0,'x_type',37,'AUTH_ONLY','x_type',0,37847,1,0,0,NULL,0,24,16)}
go
{CALL CT_ExportColumns(0,'x_type',37,'CREDIT','x_type',0,37848,1,0,0,NULL,0,24,256)}
go
{CALL CT_ExportColumns(0,'x_type',37,'VOID','x_type',0,37849,1,0,0,NULL,0,24,128)}
go
{CALL CT_ExportColumns(0,'x_type',37,'PRIOR_AUTH_CAPTURE','x_type',0,37850,1,0,0,NULL,0,24,32)}
go
{CALL CT_ExportColumns(0,'x_type',203,'AUTH_CAPTURE','x_type',0,37851,1,0,0,NULL,0,33,64)}
go
{CALL CT_ExportColumns(0,'x_type',203,'AUTH_ONLY','x_type',0,37852,1,0,0,NULL,0,33,16)}
go
{CALL CT_ExportColumns(0,'x_type',203,'CREDIT','x_type',0,37853,1,0,0,NULL,0,33,256)}
go
{CALL CT_ExportColumns(0,'x_type',203,'VOID','x_type',0,37854,1,0,0,NULL,0,33,128)}
go
{CALL CT_ExportColumns(0,'x_type',203,'PRIOR_AUTH_CAPTURE','x_type',0,37855,1,0,0,NULL,0,33,32)}
go
{CALL CT_ExportColumns(0,'Address',204,NULL,'Address',10,37917,0,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Address',204,'$Address','x_Address',0,37918,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'Amount',204,NULL,'Amount',3,37919,0,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',204,'$Amount','x_Amount',0,37920,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'AccountNumber',204,NULL,'AccountNumber',10,37921,0,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'AccountNumber',204,'$AccountNumber','x_Bank_Acct_Num',0,37922,1,0,0,NULL,0,4,511)}
go
{CALL CT_ExportColumns(0,'expmm',204,NULL,'expmm',1,37923,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expyy',204,NULL,'expyy',1,37924,0,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',204,'$expmm$expyy','x_Exp_Date',0,37925,1,0,0,NULL,0,6,511)}
go
{CALL CT_ExportColumns(0,'AccountHolder',204,NULL,'AccountHolder',10,37926,0,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'AccountHolder',204,'$AccountHolder','x_Last_Name',0,37927,1,0,0,NULL,0,7,511)}
go
{CALL CT_ExportColumns(0,'x_Method',204,'ECHECK','x_Method',0,37928,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'Zip',204,NULL,'Zip',10,37929,0,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'Zip',204,'$Zip','x_Zip',0,37930,1,0,0,NULL,0,9,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_URL',204,'FALSE','X_ADC_URL',0,37931,1,0,0,NULL,0,10,511)}
go
{CALL CT_ExportColumns(0,'X_ADC_Delim_Data',204,'TRUE','X_ADC_Delim_Data',0,37932,1,0,0,NULL,0,11,511)}
go
{CALL CT_ExportColumns(0,'x_Version',204,'3.0','x_Version',0,37933,1,0,0,NULL,0,12,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',204,NULL,'CustomerID',2,37934,0,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'CustomerID',204,'$CustomerID','x_cust_id',0,37935,1,0,0,NULL,0,3,511)}
go
{CALL CT_ExportColumns(0,'TransID',204,NULL,'TransID',2,37936,2,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'TransID',204,'$TransID','x_Invoice_Num',0,37937,1,0,0,NULL,0,13,511)}
go
{CALL CT_ExportColumns(0,'Login',204,NULL,'Login',1,37938,0,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Login',204,'$Login','x_Login',0,37939,1,0,0,NULL,0,14,511)}
go
{CALL CT_ExportColumns(0,'Transaction Key',204,NULL,'Password',1,37940,0,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'Transaction Key',204,'$Password','x_tran_key',0,37941,1,0,0,NULL,0,15,511)}
go
{CALL CT_ExportColumns(0,'BankNumber',204,NULL,'BankNumber',10,37942,0,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'BankNumber',204,'$BankNumber','x_Bank_ABA_Code',0,37943,1,0,0,NULL,0,16,511)}
go
{CALL CT_ExportColumns(0,'BankName',204,NULL,'BankName',10,37944,0,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'BankName',204,'$BankName','x_Bank_Name',0,37945,1,0,0,NULL,0,17,511)}
go
{CALL CT_ExportColumns(0,'Company',204,NULL,'Company',10,37946,0,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'Company',204,'$Company','x_Company',0,37947,1,0,0,NULL,0,18,511)}
go
{CALL CT_ExportColumns(0,'BankTransType',204,NULL,'BankTransType',1,37948,0,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'BankTransType',204,'$BankTransType','x_Bank_Acct_Type',0,37949,1,0,0,NULL,0,19,511)}
go
{CALL CT_ExportColumns(0,'Address',204,NULL,'Address',10,37950,0,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'Address',204,'$Address','x_Address',0,37951,1,0,0,NULL,0,20,511)}
go
{CALL CT_ExportColumns(0,'City',204,NULL,'City',10,37952,0,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'City',204,'$City','x_City',0,37953,1,0,0,NULL,0,21,511)}
go
{CALL CT_ExportColumns(0,'Country',204,NULL,'Country',10,37954,0,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'Country',204,'$Country','x_Country',0,37955,1,0,0,NULL,0,22,511)}
go
{CALL CT_ExportColumns(0,'SSN',204,NULL,'SSN',10,37956,0,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'SSN',204,'$SSN','x_Customer_Tax_ID',0,37957,1,0,0,NULL,0,23,511)}
go
{CALL CT_ExportColumns(0,'x_Customer_Organization_Type',204,'I','x_Customer_Organization_Type',0,37958,1,0,0,NULL,0,24,511)}
go
{CALL CT_ExportColumns(0,'DLNumber',204,NULL,'DLNumber',10,37959,0,0,0,NULL,0,25,511)}
go
{CALL CT_ExportColumns(0,'DLNumber',204,'$DLNumber','x_Drivers_License_Num',0,37960,1,0,0,NULL,0,25,511)}
go
{CALL CT_ExportColumns(0,'DLState',204,NULL,'DLState',10,37961,0,0,0,NULL,0,26,511)}
go
{CALL CT_ExportColumns(0,'DLState',204,'$DLState','x_Drivers_License_State',0,37962,1,0,0,NULL,0,26,511)}
go
{CALL CT_ExportColumns(0,'birthmm',204,NULL,'birthmm',1,37963,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'birthdd',204,NULL,'birthdd',1,37964,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'birthyyyy',204,NULL,'birthyyyy',1,37965,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'x_Drivers_License_DOB',204,'$birthyyyy/$birthmm/$birthdd','x_Drivers_License_DOB',0,37966,0,0,0,NULL,0,27,511)}
go
{CALL CT_ExportColumns(0,'x_First_Name',204,NULL,'x_First_Name',0,37967,1,0,0,NULL,0,28,511)}
go
{CALL CT_ExportColumns(0,'x_Freight',204,'0','x_Freight',0,37968,1,0,0,NULL,0,29,511)}
go
{CALL CT_ExportColumns(0,'State',204,NULL,'State',10,37969,0,0,0,NULL,0,30,511)}
go
{CALL CT_ExportColumns(0,'State',204,'$State','x_State',0,37970,1,0,0,NULL,0,30,511)}
go
{CALL CT_ExportColumns(0,'x_Tax',204,'0','x_Tax',0,37971,1,0,0,NULL,0,31,511)}
go
{CALL CT_ExportColumns(0,'x_relay_response',204,'False','x_relay_response',0,37972,1,0,0,NULL,0,32,511)}
go
{CALL CT_ExportColumns(0,'x_type',204,'AUTH_CAPTURE','x_type',0,37973,1,0,0,NULL,0,33,64)}
go
{CALL CT_ExportColumns(0,'x_type',204,'AUTH_ONLY','x_type',0,37974,1,0,0,NULL,0,33,16)}
go
{CALL CT_ExportColumns(0,'x_type',204,'CREDIT','x_type',0,37975,1,0,0,NULL,0,33,256)}
go
{CALL CT_ExportColumns(0,'x_type',204,'VOID','x_type',0,37976,1,0,0,NULL,0,33,128)}
go
{CALL CT_ExportColumns(0,'x_type',204,'PRIOR_AUTH_CAPTURE','x_type',0,37977,1,0,0,NULL,0,33,32)}
go
{CALL CT_ExportColumns(0,'MID Number',39,NULL,'Merchant',1,37985,1,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Terminal',1,37987,1,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,'application/PTI26','Content-Type',0,37992,3,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,'1','Request-number',0,37993,3,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,'Request','Document-type',0,37994,3,0,0,NULL,0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Email',1,37997,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'expmm',1,37998,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'expyy',1,37999,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Phone',1,38000,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'FirstName',1,38001,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'LastName',1,38002,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'State',1,38003,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'City',1,38004,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Country',1,38005,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'CardNumber',1,38006,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'CardHolder',1,38007,1,30,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Address',1,38008,1,30,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Zip',1,38009,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'SecurityCode',1,38010,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'TransTypeID',2,38012,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'TransID',2,38013,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'CustomerID',2,38014,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'LastModifyUser',1,38015,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'InvoiceID',2,38016,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Amount',4,38026,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'CardType',1,38027,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'SecurityCodePresent',1,38028,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Company',1,38031,1,0,0,'0',0,0,511)}
go
{CALL CT_ExportColumns(0,'BIN Number',39,NULL,'Store',1,38032,1,0,0,NULL,0,0,112)}
go
{CALL CT_ExportColumns(0,NULL,39,'1.0','Mime-Version',0,38033,3,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,NULL,39,'text','Content-transfer-encoding',0,38034,3,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,NULL,39,'Emerald 5.0.70','Interface-version',0,38035,3,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Merchant Number',40,NULL,'Login',1,38036,0,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'Merchant Number',40,'$Login','MerchantID',0,38037,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'Registration Key',40,NULL,'Password',1,38038,0,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'Registration Key',40,'$Password','RegKey',0,38039,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'Amount',40,NULL,'Amount',3,38040,1,0,0,NULL,0,3,448)}
go
{CALL CT_ExportColumns(0,'TransID',40,NULL,'TransID',2,38041,0,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'TransID',40,'$TransID','REFID',0,38042,1,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'CardNumber',40,NULL,'CardNumber',1,38043,0,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'CardNumber',40,'$CardNumber','AccountNo',0,38044,1,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'expmm',40,NULL,'expmm',1,38045,0,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,'expmm',40,'$expmm','CCMonth',0,38046,1,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,'expyy',40,NULL,'expyy',1,38047,0,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(1,'expyy',40,'$expyy','CCYear',0,38048,1,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'CardHolder',40,NULL,'CardHolder',1,38049,0,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'CardHolder',40,'$CardHolder','NameonAccount',0,38050,1,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'Address',40,NULL,'Address',1,38051,0,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'Address',40,'$Address','AVSADDR',0,38052,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'Zip',40,NULL,'Zip',1,38053,0,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'Zip',40,'$Zip','AVSZIP',0,38054,1,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'CCRURL',40,NULL,'CCRURL',0,38055,1,0,0,NULL,0,11,448)}
go
{CALL CT_ExportColumns(0,'SecurityCode',40,NULL,'SecurityCode',1,38056,0,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'SecurityCode',40,'$SecurityCode','CVV2',0,38057,1,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'Merchant Number',205,NULL,'Login',1,38058,0,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'Merchant Number',205,'$Login','MerchantID',0,38059,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'Registration Key',205,NULL,'Password',1,38060,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'Registration Key',205,'$Password','RegKey',0,38061,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'ProcTransID',32,NULL,'ProcTransID',1,38062,0,0,0,NULL,0,25,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',32,'$ProcTransID','x_trans_id',0,38063,1,0,0,NULL,0,25,416)}
go
{CALL CT_ExportColumns(0,'Amount',205,NULL,'Amount',3,38064,1,0,0,NULL,0,3,448)}
go
{CALL CT_ExportColumns(0,'TransID',205,NULL,'TransID',2,38065,0,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'TransID',205,'$TransID','RefID',0,38066,1,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',205,NULL,'AccountNumber',1,38067,0,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',205,'$AccountNumber','AccountNo',0,38068,1,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'AccountHolder',205,NULL,'AccountHolder',1,38069,0,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,'AccountHolder',205,'$AccountHolder','NameonAccount',0,38070,1,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,NULL,205,NULL,'CKRURL',0,38071,1,0,0,NULL,0,7,896)}
go
{CALL CT_ExportColumns(0,'BankNumber',205,NULL,'BankNumber',1,38072,0,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'BankNumber',205,'$BankNumber','TRANSROUTE',0,38073,1,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'Content-Type',41,'text/namevalue','Content-Type',0,38074,3,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Connect',41,'close
X-VPS-VIT-CLIENT-CERTIFICATION-ID: 12cbb2341ad2123d8b191d2d011b7fde','Connect',0,38075,3,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'TransID',41,NULL,'TransID',2,38076,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'TransID',41,'$TransID','X-VPS-REQUEST-ID',0,38077,3,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',41,NULL,'CardNumber',1,38079,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',41,'$CardNumber','ACCT',0,38080,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Amount',41,NULL,'Amount',3,38081,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'Amount',41,'$Amount','AMT',0,38082,1,0,0,NULL,0,5,240)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',41,NULL,'CurrencyCode',1,38083,0,0,0,NULL,0,6,240)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',41,'$CurrencyCode','CURRENCY',0,38084,1,0,0,NULL,0,6,240)}
go
{CALL CT_ExportColumns(0,'TransID',41,'$TransID','CUSTREF',0,38085,1,0,0,NULL,0,7,240)}
go
{CALL CT_ExportColumns(0,'SecurityCode',41,NULL,'SecurityCode',1,38086,0,0,0,NULL,0,8,240)}
go
{CALL CT_ExportColumns(0,'SecurityCode',41,'$SecurityCode','CVV2',0,38087,1,0,0,NULL,0,8,240)}
go
{CALL CT_ExportColumns(0,'expmm',41,NULL,'expmm',1,38088,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'expyy',41,NULL,'expyy',1,38089,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',41,'$expmm$expyy','EXPDATE',0,38090,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',41,NULL,'CardHolder',1,38091,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',41,'$CardHolder','NAME',0,38092,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',41,NULL,'ProcTransID',1,38093,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',41,'$ProcTransID','ORIGID',0,38094,1,0,0,NULL,0,11,416)}
go
{CALL CT_ExportColumns(0,'Partner',41,NULL,'Merchant',1,38095,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Merchant',41,'$Merchant','PARTNER',0,38096,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Password',41,NULL,'Password',1,38097,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Password',41,'$Password','PWD',0,38098,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Address',41,NULL,'Address',1,38099,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',41,'$Address','STREET',0,38100,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'TENDER',41,'C','TENDER',0,38101,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'Auth Only',41,'A','TRXTYPE',0,38102,1,0,0,NULL,0,16,16)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',41,'S','TRXTYPE',0,38103,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'Credit',41,'C','TRXTYPE',0,38104,1,0,0,NULL,0,16,256)}
go
{CALL CT_ExportColumns(0,'Void',41,'V','TRXTYPE',0,38105,1,0,0,NULL,0,16,128)}
go
{CALL CT_ExportColumns(0,'Capture previous auth',41,'D','TRXTYPE',0,38106,1,0,0,NULL,0,16,32)}
go
{CALL CT_ExportColumns(0,'User',41,NULL,'Login',1,38107,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Login',41,'$Login','USER',0,38108,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Store',41,'$Store','VENDOR',0,38109,1,0,0,NULL,0,22,496)}
go
{CALL CT_ExportColumns(0,'VERBOSITY',41,'LOW','VERBOSITY',0,38110,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Zip',41,NULL,'Zip',1,38111,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'TransID',41,'$TransID','ieatransid',0,38112,2,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Host',41,'payflowpro.paypal.com','Host',0,38113,3,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Content-Type',206,'text/namevalue','Content-Type',0,38114,3,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Connect',206,'close
X-VPS-VIT-CLIENT-CERTIFICATION-ID: 12cbb2341ad2123d8b191d2d011b7fde','Connect',0,38115,3,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'TransID',206,NULL,'TransID',2,38116,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'TransID',206,'$TransID','X-VPS-REQUEST-ID',0,38117,3,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Amount',206,NULL,'Amount',3,38120,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'Amount',206,'$Amount','AMT',0,38121,1,0,0,NULL,0,5,240)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',206,NULL,'CurrencyCode',1,38122,0,0,0,NULL,0,6,240)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',206,'$CurrencyCode','CURRENCY',0,38123,1,0,0,NULL,0,6,240)}
go
{CALL CT_ExportColumns(0,'TransID',206,'$TransID','CUSTREF',0,38124,1,0,0,NULL,0,7,240)}
go
{CALL CT_ExportColumns(0,'AccountHolder',206,NULL,'AccountHolder',1,38130,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'AccountHolder',206,'$AccountHolder','FIRSTNAME',0,38131,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',206,NULL,'ProcTransID',1,38132,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',206,'$ProcTransID','ORIGID',0,38133,1,0,0,NULL,0,11,416)}
go
{CALL CT_ExportColumns(0,'Partner',206,NULL,'Merchant',1,38134,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Merchant',206,'$Merchant','PARTNER',0,38135,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Password',206,NULL,'Password',1,38136,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Password',206,'$Password','PWD',0,38137,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Address',206,NULL,'Address',1,38138,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',206,'$Address','STREET',0,38139,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'TENDER',206,'A','TENDER',0,38140,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',206,'S','TRXTYPE',0,38142,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'Credit',206,'C','TRXTYPE',0,38143,1,0,0,NULL,0,16,256)}
go
{CALL CT_ExportColumns(0,'Void',206,'V','TRXTYPE',0,38144,1,0,0,NULL,0,16,128)}
go
{CALL CT_ExportColumns(0,'User',206,NULL,'Login',1,38146,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Login',206,'$Login','USER',0,38147,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Store',206,'$Store','VENDOR',0,38148,1,0,0,NULL,0,22,496)}
go
{CALL CT_ExportColumns(0,'VERBOSITY',206,'LOW','VERBOSITY',0,38149,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Zip',206,NULL,'Zip',1,38150,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'TransID',206,'$TransID','ieatransid',0,38151,2,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Host',206,'payflowpro.paypal.com','Host',0,38152,3,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,NULL,41,'Credit','AUTHCODE',0,38153,2,0,0,NULL,0,21,256)}
go
{CALL CT_ExportColumns(0,NULL,41,'N','AVSADDR',0,38154,2,0,0,NULL,0,21,256)}
go
{CALL CT_ExportColumns(0,NULL,41,'/','AVSZIP',0,38155,2,0,0,NULL,0,21,256)}
go
{CALL CT_ExportColumns(0,NULL,41,'A','IAVS',0,38156,2,0,0,NULL,0,21,256)}
go
{CALL CT_ExportColumns(0,'BankNumber',206,NULL,'BankNumber',1,38157,0,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'BankNumber',206,'$BankNumber','ABA',0,38158,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'AccountNumber',206,NULL,'AccountNumber',1,38159,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'AccountNumber',206,'$AccountNumber','ACCT',0,38160,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'BankTransType',206,NULL,'BankTransType',1,38161,0,1,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'BankTransType',206,'$BankTransType','ACCTTYPE',0,38162,1,1,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'AUTHTYPE',206,'WEB','AUTHTYPE',0,38163,1,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'Store',38,NULL,'Store',1,38166,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',38,NULL,'Password',1,38169,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',38,NULL,'CardNumber',1,38178,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'expmm',38,NULL,'expmm',2,38179,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'expyyyy',38,NULL,'expyyyy',2,38181,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'Amount',38,NULL,'Amount',3,38183,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',38,NULL,'ProcTransID',2,38184,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',38,NULL,'CardHolder',1,38186,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Address',38,NULL,'Address',1,38188,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'State',38,NULL,'State',1,38189,1,0,0,NULL,1,15,496)}
go
{CALL CT_ExportColumns(0,'City',38,NULL,'City',1,38190,1,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'Zip',38,NULL,'Zip',1,38191,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Country',38,NULL,'Country',1,38192,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Phone',38,NULL,'Phone',1,38193,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',38,NULL,'SecurityCode',1,38194,0,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Terminal',38,NULL,'Terminal',1,38198,0,0,0,NULL,0,22,496)}
go
{CALL CT_ExportColumns(0,'TransID',38,NULL,'TransID',2,38199,2,0,0,NULL,0,23,496)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1010,NULL,'ExternalSyncID',2,38200,2,0,0,NULL,0,1,33494016)}
go
{CALL CT_ExportColumns(0,'OrigData',1010,NULL,'OrigData',1,38201,1,0,0,NULL,0,2,8192)}
go
{CALL CT_ExportColumns(0,'Login',1010,NULL,'Login',1,38202,1,0,0,NULL,0,4,33494016)}
go
{CALL CT_ExportColumns(0,'Pass',1010,NULL,'Pass',1,38203,1,0,0,NULL,0,5,66560)}
go
{CALL CT_ExportColumns(0,'clientID',1010,NULL,'clientID',1,38204,1,0,0,NULL,0,6,33494016)}
go
{CALL CT_ExportColumns(0,'password',1010,NULL,'password',1,38206,1,0,0,'0',0,7,33494016)}
go
{CALL CT_ExportColumns(0,'Content-Type',1010,'application/x-eon-xrc-request','Content-Type',0,38207,3,0,0,NULL,0,0,33494016)}
go
{CALL CT_ExportColumns(0,'FirstName',1010,NULL,'FirstName',1,38210,1,0,0,NULL,0,8,524288)}
go
{CALL CT_ExportColumns(0,'ExternalRef',1010,NULL,'ExternalRef',1,38211,1,0,0,NULL,0,9,27202560)}
go
{CALL CT_ExportColumns(0,'OfferID',1010,NULL,'OfferID',1,38212,1,0,0,NULL,0,10,3146752)}
go
{CALL CT_ExportColumns(0,'IFirstName',1010,'$FirstName','IFirstName',0,38213,2,0,0,NULL,0,8,524288)}
go
{CALL CT_ExportColumns(0,'LastName',1010,NULL,'LastName',1,38214,1,0,0,NULL,0,11,524288)}
go
{CALL CT_ExportColumns(0,'ILastName',1010,'$LastName','ILastName',0,38215,2,0,0,NULL,0,11,524288)}
go
{CALL CT_ExportColumns(0,'Trans Cat (2=Recurring)',39,NULL,'Login',1,38216,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Currency Code',39,NULL,'Password',1,38217,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'State2',1,38218,1,2,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'Country2',1,38219,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,NULL,39,NULL,'ExternalTransID',2,38220,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Request Type - Auth Only',39,'A','ReqType',0,38221,1,0,0,NULL,0,0,16)}
go
{CALL CT_ExportColumns(0,'Request Type - AuthCapture',39,'AC','ReqType',0,38222,1,0,0,NULL,0,0,64)}
go
{CALL CT_ExportColumns(0,'Login',38,NULL,'Login',1,38223,1,0,0,NULL,0,24,496)}
go
{CALL CT_ExportColumns(0,'Terminal',38,NULL,'Terminal',1,38224,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Email',42,NULL,'EMAIL',1,38225,1,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'expmm',42,NULL,'expmm',1,38227,0,0,0,NULL,0,2,80)}
go
{CALL CT_ExportColumns(0,'expyy',42,NULL,'expyy',1,38228,0,0,0,NULL,0,2,80)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',42,'$expmm$expyy','EXPDATE',0,38229,1,0,0,NULL,0,2,80)}
go
{CALL CT_ExportColumns(0,'Phone',42,NULL,'PHONE',1,38230,1,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',42,NULL,'CardHolder',1,38232,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',42,'$CardHolder','NAME',0,38234,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'City',42,NULL,'CITY',1,38235,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'Country2',42,NULL,'Country2',1,38237,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Country2',42,'$Country2','COUNTRYCODE',0,38238,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',42,NULL,'CardNumber',1,38239,0,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',42,'$CardNumber','CARDNUM',0,38240,1,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',42,NULL,'ProcTransID',1,38241,0,0,0,NULL,0,8,160)}
go
{CALL CT_ExportColumns(0,'ProcTransID',42,'$ProcTransID','TRANSID',0,38242,1,0,0,NULL,0,8,160)}
go
{CALL CT_ExportColumns(0,'Address',42,NULL,'ADDRESS',1,38243,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Zip',42,NULL,'ZIP',1,38245,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',42,NULL,'SecurityCode',1,38247,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',42,'$SecurityCode','CV2VALUE',0,38248,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCodePresent',42,NULL,'SecurityCodePresent',2,38249,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'SecurityCodePresent',42,'$SecurityCodePresent','CV2',0,38250,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',42,NULL,'ExternalTransID',2,38251,0,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',42,'$ExternalTransID','INVOICE',0,38252,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'CustomerID',42,NULL,'CustomerID',2,38253,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'CustomerID',42,'$CustomerID','CUSTID',0,38254,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Amount',42,NULL,'AMOUNT',3,38255,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'CardType',42,NULL,'CardType',1,38257,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'CardType',42,'$CardType','METHOD',0,38258,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Login',42,NULL,'LOGIN',1,38259,1,0,0,NULL,0,17,240)}
go
{CALL CT_ExportColumns(0,'Password',42,NULL,'PASSWORD',1,38261,1,0,0,NULL,0,18,240)}
go
{CALL CT_ExportColumns(0,NULL,42,'NamedValueList','RECEIPTFORMAT',0,38263,1,0,0,NULL,0,19,240)}
go
{CALL CT_ExportColumns(0,NULL,42,'Y','SENDCV2RESULT',0,38264,1,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',42,'NA','TYPE',0,38265,1,0,0,NULL,0,21,64)}
go
{CALL CT_ExportColumns(0,'Auth Only',42,'AO','TYPE',0,38266,1,0,0,NULL,0,21,16)}
go
{CALL CT_ExportColumns(0,'Void Transaction',42,'Void','Void',0,38267,1,0,0,NULL,0,21,128)}
go
{CALL CT_ExportColumns(0,'Capture',42,'PreAuthCompletion','PreAuthCompletion',0,38268,1,0,0,NULL,0,21,32)}
go
{CALL CT_ExportColumns(0,'BatchManagementURL',42,'https://www.intellipay.net/BatchManagement/','BatchManagementURL',0,38269,4,0,0,NULL,0,22,160)}
go
{CALL CT_ExportColumns(0,NULL,42,'$ExternalTransID','ieatransid',0,38270,2,0,0,NULL,0,23,240)}
go
{CALL CT_ExportColumns(0,'Email',43,NULL,'Email',1,38271,0,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Email',43,'$Email','s_email',0,38272,1,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Email Receipt',43,'FALSE','s_emailreceipt',0,38273,1,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'expmm',43,NULL,'expmm',1,38274,0,0,0,NULL,0,2,336)}
go
{CALL CT_ExportColumns(0,'expyy',43,NULL,'expyy',1,38275,0,0,0,NULL,0,2,336)}
go
{CALL CT_ExportColumns(0,'Expire Date',43,'$expmm$expyy','s_exp_date',0,38276,1,0,0,NULL,0,2,336)}
go
{CALL CT_ExportColumns(0,'Phone',43,NULL,'Phone',1,38277,0,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'Phone',43,'$Phone','s_phone',0,38278,1,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'State',43,NULL,'State',1,38279,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'State',43,'$State','s_state',0,38280,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'City',43,NULL,'City',1,38281,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'City',43,'$City','s_city',0,38282,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'Country2',43,NULL,'Country2',1,38283,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Country2',43,'$Country2','s_country',0,38284,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',43,NULL,'CardNumber',1,38285,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',43,'$CardNumber','s_card_num',0,38286,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',43,NULL,'ProcTransID',1,38287,0,0,0,NULL,0,8,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',43,'$ProcTransID','s_trans_id',0,38288,1,0,0,NULL,0,8,416)}
go
{CALL CT_ExportColumns(0,'CardHolder',43,NULL,'CardHolder',1,38289,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',43,'$CardHolder','s_first_name',0,38290,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Address',43,NULL,'Address',1,38291,0,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Address',43,'$Address','s_address',0,38292,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Zip',43,NULL,'Zip',1,38293,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Zip',43,'$Zip','s_zip',0,38294,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',43,NULL,'SecurityCode',1,38295,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',43,'$SecurityCode','s_card_code',0,38296,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',43,NULL,'ExternalTransID',2,38297,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',43,'$ExternalTransID','s_orderid',0,38298,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Auth only',43,'AUTH_ONLY','s_type',0,38299,1,0,0,NULL,0,14,16)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',43,'AUTH_CAPTURE','s_type',0,38300,1,0,0,NULL,0,14,64)}
go
{CALL CT_ExportColumns(0,'Credit',43,'CREDIT','s_type',0,38301,1,0,0,NULL,0,14,256)}
go
{CALL CT_ExportColumns(0,'Void',43,'VOID','s_type',0,38302,1,0,0,NULL,0,14,128)}
go
{CALL CT_ExportColumns(0,'Capture previous',43,'PRIOR_AUTH_C','s_type',0,38303,1,0,0,NULL,0,14,32)}
go
{CALL CT_ExportColumns(0,NULL,43,'CC','s_method',0,38304,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',43,NULL,'CustomerID',2,38305,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'CustomerID',43,'$CustomerID','s_customer_id',0,38306,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Amount',43,NULL,'Amount',3,38307,0,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Amount',43,'$Amount','s_amount',0,38308,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'SecureNet ID',43,NULL,'Login',1,38309,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'SecureNet ID',43,'$Login','s_securenetid',0,38310,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Security Key',43,NULL,'Password',1,38311,0,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Security Key',43,'$Password','s_securekey',0,38312,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Company',43,NULL,'Company',1,38313,0,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'Company',43,'$Company','s_company',0,38314,1,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',44,NULL,'CardHolder',1,38315,0,0,0,NULL,0,0,368)}
go
{CALL CT_ExportColumns(0,'CardHolder',44,'$CardHolder','billing_name',0,38316,1,0,0,NULL,0,0,368)}
go
{CALL CT_ExportColumns(0,'Company',44,NULL,'Company',1,38317,0,0,0,NULL,0,1,368)}
go
{CALL CT_ExportColumns(0,'Company',44,'$Company','billing_company_name',0,38318,1,0,0,NULL,0,1,368)}
go
{CALL CT_ExportColumns(0,'Address',44,NULL,'Address',1,38319,0,0,0,NULL,0,2,368)}
go
{CALL CT_ExportColumns(0,'Address',44,'$Address','billing_address1',0,38320,1,0,0,NULL,0,2,368)}
go
{CALL CT_ExportColumns(0,'City',44,NULL,'City',1,38321,0,0,0,NULL,0,3,368)}
go
{CALL CT_ExportColumns(0,'City',44,'$City','billing_city',0,38322,1,0,0,NULL,0,3,368)}
go
{CALL CT_ExportColumns(0,'State',44,NULL,'State',1,38323,0,0,0,NULL,0,4,368)}
go
{CALL CT_ExportColumns(0,'State',44,'$State','billing_state',0,38324,1,0,0,NULL,0,4,368)}
go
{CALL CT_ExportColumns(0,'Zip',44,NULL,'Zip',1,38325,0,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'Zip',44,'$Zip','billing_zip',0,38326,1,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'Country',44,NULL,'Country',1,38327,0,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'Country',44,'$Country','billing_country',0,38328,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'Phone',44,NULL,'Phone',1,38329,0,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'Phone',44,'$Phone','billing_phone',0,38330,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'Email',44,NULL,'Email',1,38331,0,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'Email',44,'$Email','billing_email',0,38332,1,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'CardNumber',44,NULL,'CardNumber',1,38333,0,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'CardNumber',44,'$CardNumber','cc_number',0,38334,1,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'expmm',44,NULL,'expmm',1,38335,0,0,0,NULL,0,10,368)}
go
{CALL CT_ExportColumns(0,'expmm',44,'$expmm','ccexp_month',0,38336,1,0,0,NULL,0,10,368)}
go
{CALL CT_ExportColumns(0,'expyyyy',44,NULL,'expyyyy',1,38337,0,0,0,NULL,0,11,368)}
go
{CALL CT_ExportColumns(0,'expyyyy',44,'$expyyyy','ccexp_year',0,38338,1,0,0,NULL,0,11,368)}
go
{CALL CT_ExportColumns(0,NULL,44,'Y','cnp_recurring',0,38339,1,0,0,NULL,0,12,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',44,NULL,'SecurityCode',1,38340,0,0,0,NULL,0,13,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',44,'$SecurityCode','cnp_security',0,38341,1,0,0,NULL,0,13,368)}
go
{CALL CT_ExportColumns(0,'TransID',44,NULL,'TransID',2,38342,0,0,0,NULL,0,14,368)}
go
{CALL CT_ExportColumns(0,'TransID',44,'$TransID','counter',0,38343,1,0,0,NULL,0,14,752)}
go
{CALL CT_ExportColumns(0,'Amount',44,NULL,'Amount',4,38344,0,0,0,NULL,0,15,368)}
go
{CALL CT_ExportColumns(0,'Amount',44,'$Amount','grand_total',0,38345,1,0,0,NULL,0,15,368)}
go
{CALL CT_ExportColumns(0,'Auth',44,'AV','transaction_type',0,38346,1,0,0,NULL,0,16,16)}
go
{CALL CT_ExportColumns(0,'Deposit',44,'DS','transaction_type',0,38347,1,0,0,NULL,0,16,32)}
go
{CALL CT_ExportColumns(0,'Auth + Deposit',44,'EV','transaction_type',0,38348,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'Credit',44,'CR','transaction_type',0,38349,1,0,0,NULL,0,16,256)}
go
{CALL CT_ExportColumns(0,'Self Service',44,'S','order_type',0,38350,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Merchant ID (Login)',44,NULL,'Login',1,38351,0,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Merchant ID (Login)',44,'$Login','merchant_echo_id',0,38352,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Merchant PIN (Password)',44,NULL,'Password',1,38353,0,0,0,NULL,0,18,368)}
go
{CALL CT_ExportColumns(0,'Merchant PIN (Password)',44,'$Password','merchant_pin',0,38354,1,0,0,NULL,0,18,368)}
go
{CALL CT_ExportColumns(0,'ProcTransID',44,NULL,'ProcTransID',1,38355,0,0,0,NULL,0,19,368)}
go
{CALL CT_ExportColumns(0,'ProcTransID',44,'$ProcTransID','order_number',0,38356,1,0,0,NULL,0,19,288)}
go
{CALL CT_ExportColumns(0,'TransID',44,'$TransID','merchant_trace_nbr',0,38357,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Phone',207,NULL,'Phone',1,38372,0,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'Phone',207,'$Phone','billing_phone',0,38373,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,NULL,207,'Y','cnp_recurring',0,38382,1,0,0,NULL,0,12,368)}
go
{CALL CT_ExportColumns(0,'TransID',207,NULL,'TransID',2,38385,0,0,0,NULL,0,14,368)}
go
{CALL CT_ExportColumns(0,'TransID',207,'$TransID','counter',0,38386,1,0,0,NULL,0,14,752)}
go
{CALL CT_ExportColumns(0,'Amount',207,NULL,'Amount',4,38387,0,0,0,NULL,0,15,368)}
go
{CALL CT_ExportColumns(0,'Amount',207,'$Amount','grand_total',0,38388,1,0,0,NULL,0,15,368)}
go
{CALL CT_ExportColumns(0,'Electronic Check Debit ACH Only',207,'DH','transaction_type',0,38391,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'Credit',207,'DC','transaction_type',0,38392,1,0,0,NULL,0,16,256)}
go
{CALL CT_ExportColumns(0,'Self Service',207,'S','order_type',0,38393,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Login',207,NULL,'Login',1,38394,0,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Merchant ID (Login)',207,'$Login','merchant_echo_id',0,38395,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Password',207,NULL,'Password',1,38396,0,0,0,NULL,0,18,368)}
go
{CALL CT_ExportColumns(0,'Merchant PIN (Password)',207,'$Password','merchant_pin',0,38397,1,0,0,NULL,0,18,368)}
go
{CALL CT_ExportColumns(0,'ProcTransID',207,NULL,'ProcTransID',1,38398,0,0,0,NULL,0,19,368)}
go
{CALL CT_ExportColumns(0,'ProcTransID',207,'$ProcTransID','order_number',0,38399,1,0,0,NULL,0,19,288)}
go
{CALL CT_ExportColumns(0,'TransID',207,'$TransID','merchant_trace_nbr',0,38400,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',207,NULL,'Address',1,38401,0,0,0,NULL,0,1,320)}
go
{CALL CT_ExportColumns(0,'Address',207,'$Address','ec_address1',0,38402,1,0,0,NULL,0,1,320)}
go
{CALL CT_ExportColumns(0,'BankName',207,NULL,'BankName',1,38403,0,0,0,NULL,0,2,320)}
go
{CALL CT_ExportColumns(0,'BankName',207,'$BankName','ec_bank_name',0,38404,1,0,0,NULL,0,2,320)}
go
{CALL CT_ExportColumns(0,'City',207,NULL,'City',1,38405,0,0,0,NULL,0,3,320)}
go
{CALL CT_ExportColumns(0,'City',207,'$City','ec_city',0,38406,1,0,0,NULL,0,3,320)}
go
{CALL CT_ExportColumns(0,'Email',207,NULL,'Email',1,38407,0,0,0,NULL,0,4,320)}
go
{CALL CT_ExportColumns(0,'Email',207,'$Email','ec_email',0,38408,1,0,0,NULL,0,4,320)}
go
{CALL CT_ExportColumns(0,'AccountHolder',207,NULL,'AccountHolder',1,38409,0,0,0,NULL,0,5,320)}
go
{CALL CT_ExportColumns(0,'AccountHolder',207,'$AccountHolder','ec_first_name',0,38410,1,0,0,NULL,0,5,320)}
go
{CALL CT_ExportColumns(0,'Country2',207,NULL,'Country2',1,38411,0,0,0,NULL,0,6,320)}
go
{CALL CT_ExportColumns(0,'Country2',207,'$Country2','ec_id_country',0,38412,1,0,0,NULL,0,6,320)}
go
{CALL CT_ExportColumns(0,'DLNumber',207,NULL,'DLNumber',1,38413,0,0,0,NULL,0,8,320)}
go
{CALL CT_ExportColumns(0,'DLNumber',207,'$DLNumber','ec_id_number',0,38414,1,0,0,NULL,0,8,320)}
go
{CALL CT_ExportColumns(0,'DLState',207,NULL,'DLState',1,38415,0,0,0,NULL,0,9,320)}
go
{CALL CT_ExportColumns(0,'DLState',207,'$DLState','ec_id_state',0,38416,1,0,0,NULL,0,9,320)}
go
{CALL CT_ExportColumns(0,NULL,207,'DL','ec_id_type',0,38417,1,0,0,NULL,0,10,320)}
go
{CALL CT_ExportColumns(0,NULL,207,NULL,'ec_last_name',0,38418,1,0,0,NULL,0,11,320)}
go
{CALL CT_ExportColumns(0,NULL,207,'PPD','ec_payment_type',0,38419,1,0,0,NULL,0,13,320)}
go
{CALL CT_ExportColumns(0,'BankNumber',207,NULL,'BankNumber',1,38420,0,0,0,NULL,0,20,320)}
go
{CALL CT_ExportColumns(0,'BankNumber',207,'$BankNumber','ec_rt',0,38421,1,0,0,NULL,0,20,320)}
go
{CALL CT_ExportColumns(0,'Zip',207,NULL,'Zip',1,38422,0,0,0,NULL,0,21,320)}
go
{CALL CT_ExportColumns(0,'Zip',207,'$Zip','ec_zip',0,38423,1,0,0,NULL,0,21,320)}
go
{CALL CT_ExportColumns(0,'AccountNumber',207,NULL,'AccountNumber',1,38424,0,0,0,NULL,0,22,320)}
go
{CALL CT_ExportColumns(0,'AccountNumber',207,'$AccountNumber','ec_account',0,38425,1,0,0,NULL,0,22,320)}
go
{CALL CT_ExportColumns(0,'Username',1011,NULL,'Username',1,38439,1,0,0,NULL,0,1,1971200)}
go
{CALL CT_ExportColumns(0,'Password',1011,NULL,'Password',1,38440,1,0,0,NULL,0,2,1971200)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1011,NULL,'ExternalSyncID',2,38441,2,0,0,NULL,0,3,1971200)}
go
{CALL CT_ExportColumns(0,'AccountRoleId',1011,NULL,'AccountRoleId',1,38442,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'NewAccountName',1011,NULL,'NewAccountName',1,38443,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'CompanyName',1011,NULL,'CompanyName',1,38444,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'AccountEmailAddress',1011,NULL,'AccountEmailAddress',1,38445,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'AdminLoginName',1011,NULL,'AdminLoginName',1,38446,1,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'AdminLoginPassword',1011,NULL,'AdminLoginPassword',1,38447,1,0,0,NULL,0,9,1024)}
go
{CALL CT_ExportColumns(0,'AdminEmailAddress',1011,NULL,'AdminEmailAddress',1,38448,1,0,0,NULL,0,10,1024)}
go
{CALL CT_ExportColumns(0,'FirstName',1011,NULL,'FirstName',1,38449,1,0,0,NULL,0,11,1024)}
go
{CALL CT_ExportColumns(0,'LastName',1011,NULL,'LastName',1,38450,1,0,0,NULL,0,12,1024)}
go
{CALL CT_ExportColumns(0,'Address1',1011,NULL,'Address1',1,38451,1,0,0,NULL,0,13,1024)}
go
{CALL CT_ExportColumns(0,'Address2',1011,NULL,'Address2',1,38452,1,0,0,NULL,0,14,1024)}
go
{CALL CT_ExportColumns(0,'Town',1011,NULL,'Town',1,38453,1,0,0,NULL,0,15,1024)}
go
{CALL CT_ExportColumns(0,'PostCode',1011,NULL,'PostCode',1,38454,1,0,0,NULL,0,16,1024)}
go
{CALL CT_ExportColumns(0,'CountryCode',1011,NULL,'CountryCode',1,38455,1,0,0,NULL,0,17,1024)}
go
{CALL CT_ExportColumns(0,'UserAccountID',1011,NULL,'UserAccountID',1,38456,1,0,0,NULL,0,18,1970176)}
go
{CALL CT_ExportColumns(0,'PlanID',1011,NULL,'PlanID',1,38457,1,0,0,NULL,0,19,524288)}
go
{CALL CT_ExportColumns(0,'PackageName',1011,NULL,'PackageName',1,38458,1,0,0,NULL,0,20,524288)}
go
{CALL CT_ExportColumns(0,'PackageID',1011,NULL,'PackageID',1,38459,1,0,0,NULL,0,21,1048576)}
go
{CALL CT_ExportColumns(0,'DomainName',1011,NULL,'DomainName',1,38460,1,0,0,NULL,0,22,1048576)}
go
{CALL CT_ExportColumns(0,'action',1011,'CreateAccount','action',0,38461,1,0,0,NULL,0,0,1024)}
go
{CALL CT_ExportColumns(0,'action',1011,'AddPackage','action',0,38462,1,0,0,NULL,0,0,524288)}
go
{CALL CT_ExportColumns(0,'action',1011,'AddDomainToPackage','action',0,38463,1,0,0,NULL,0,0,1048576)}
go
{CALL CT_ExportColumns(0,'action',1011,'SuspendAccount','action',0,38464,1,0,0,NULL,0,0,262144)}
go
{CALL CT_ExportColumns(0,'action',1011,'UnsuspendAccount','action',0,38465,1,0,0,NULL,0,0,131072)}
go
{CALL CT_ExportColumns(0,'action',1011,'DeleteAccount','action',0,38466,1,0,0,NULL,0,0,4096)}
go
{CALL CT_ExportColumns(0,'AccountName',1011,NULL,'AccountName',1,38467,1,0,0,NULL,0,23,1971200)}
go
{CALL CT_ExportColumns(0,'Base URL',1012,'baseurl','baseurl',1,38468,0,0,0,NULL,0,0,988160)}
go
{CALL CT_ExportColumns(0,'Add URL',1012,'$baseurl/json-api/createacct','URL',0,38469,4,0,0,NULL,0,0,1024)}
go
{CALL CT_ExportColumns(0,'Change PW URL',1012,'$baseurl/json-api/passwd','URL',0,38470,4,0,0,NULL,0,0,65536)}
go
{CALL CT_ExportColumns(0,'Suspend URL',1012,'$baseurl/json-api/suspendacct','URL',0,38471,4,0,0,NULL,0,0,262144)}
go
{CALL CT_ExportColumns(0,'Unsuspend URL',1012,'$baseurl/json-api/unsuspendacct','URL',0,38472,4,0,0,NULL,0,0,131072)}
go
{CALL CT_ExportColumns(0,'Delete URL',1012,'$baseurl/json-api/removeacct','URL',0,38473,4,0,0,NULL,0,0,4096)}
go
{CALL CT_ExportColumns(0,'Change Package URL',1012,'$baseurl/json-api/changepackage','URL',0,38474,4,0,0,NULL,0,0,524288)}
go
{CALL CT_ExportColumns(0,'Login',1012,NULL,'Login',1,38475,0,0,0,NULL,0,1,988160)}
go
{CALL CT_ExportColumns(0,'Login',1012,'$Login','username',0,38476,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Login',1012,'$Login','user',0,38477,1,0,0,NULL,0,1,987136)}
go
{CALL CT_ExportColumns(0,'Domain',1012,'$Login','domain',0,38478,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'cplan',1012,NULL,'cplan',1,38479,0,0,0,NULL,0,3,525312)}
go
{CALL CT_ExportColumns(0,'Password',1012,NULL,'SAPassword',1,38480,0,0,0,NULL,0,4,66560)}
go
{CALL CT_ExportColumns(0,'Password',1012,'$SAPassword','password',0,38481,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'Password',1012,'$SAPassword','pass',0,38482,1,0,0,NULL,0,4,65536)}
go
{CALL CT_ExportColumns(0,'reason',1012,NULL,'reason',1,38483,1,0,0,NULL,0,5,262144)}
go
{CALL CT_ExportColumns(0,'keepdns',1012,'n','keepdns',0,38484,1,0,0,NULL,0,6,4096)}
go
{CALL CT_ExportColumns(0,'plan',1012,'$cplan','pkg',0,38485,1,0,0,NULL,0,3,524288)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1012,NULL,'ExternalSyncID',2,38486,2,0,0,NULL,0,7,988160)}
go
{CALL CT_ExportColumns(0,'plan',1012,'$cplan','plan',0,38487,2,0,0,NULL,0,3,524288)}
go
{CALL CT_ExportColumns(0,'plan',1012,'$cplan','plan',0,38488,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'Base URL',1013,NULL,'baseurl',1,38489,0,0,0,NULL,0,0,398336)}
go
{CALL CT_ExportColumns(0,'Add URL',1013,'$baseurl/CMD_API_ACCOUNT_USER','URL',0,38490,4,0,0,NULL,0,0,1024)}
go
{CALL CT_ExportColumns(0,'Suspend/Delete URL',1013,'$baseurl/CMD_API_SELECT_USERS','URL',0,38491,4,0,0,NULL,0,0,397312)}
go
{CALL CT_ExportColumns(0,'action',1013,'create','action',0,38492,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'add',1013,'submit','add',0,38493,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Login',1013,NULL,'Login',1,38494,0,0,0,NULL,0,3,398336)}
go
{CALL CT_ExportColumns(0,'username',1013,'$Login','username',0,38495,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'Login',1013,'$Login','select0',0,38496,1,0,0,NULL,0,3,397312)}
go
{CALL CT_ExportColumns(0,'Email',1012,NULL,'Email',1,38497,0,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'contactemail',1012,'$Email','contactemail',0,38498,1,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'Password',1013,NULL,'Password',1,38499,0,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'Password',1013,'$Password','passwd',0,38500,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'Password',1013,'$Password','passwd2',0,38501,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'domain',1013,NULL,'domain',1,38502,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'ip',1013,NULL,'ip',1,38503,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'notify',1013,'no','notify',0,38504,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'suspend',1013,'Suspend','suspend',0,38505,1,0,0,NULL,0,8,262144)}
go
{CALL CT_ExportColumns(0,'suspend',1013,'Unsuspend','suspend',0,38506,1,0,0,NULL,0,8,131072)}
go
{CALL CT_ExportColumns(0,'confirmed',1013,'Confirm','confirmed',0,38507,1,0,0,NULL,0,9,4096)}
go
{CALL CT_ExportColumns(0,'delete',1013,'yes','delete',0,38508,1,0,0,NULL,0,10,4096)}
go
{CALL CT_ExportColumns(0,'ProcTransID',37,NULL,'ProcTransID',1,38509,0,0,0,NULL,0,25,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',37,'$ProcTransID','x_trans_id',0,38510,1,0,0,NULL,0,25,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',204,NULL,'ProcTransID',1,38511,0,0,0,NULL,0,34,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',204,'$ProcTransID','x_trans_id',0,38512,1,0,0,NULL,0,34,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',203,NULL,'ProcTransID',1,38513,0,0,0,NULL,0,34,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',203,'$ProcTransID','x_trans_id',0,38514,1,0,0,NULL,0,34,384)}
go
{CALL CT_ExportColumns(0,'authlogin',1014,NULL,'authlogin',1,38515,1,0,0,NULL,0,1,463872)}
go
{CALL CT_ExportColumns(0,'authpassword',1014,NULL,'authpassword',1,38516,1,0,0,NULL,0,2,463872)}
go
{CALL CT_ExportColumns(0,'Password',1014,NULL,'Password',1,38517,1,0,0,NULL,0,3,459776)}
go
{CALL CT_ExportColumns(0,'login',1014,NULL,'login',1,38518,1,0,0,NULL,0,4,463872)}
go
{CALL CT_ExportColumns(0,'FirstName',1014,NULL,'FirstName',1,38519,1,0,0,NULL,0,5,459776)}
go
{CALL CT_ExportColumns(0,'LastName',1014,NULL,'LastName',1,38520,1,0,0,NULL,0,6,459776)}
go
{CALL CT_ExportColumns(0,'domain',1014,NULL,'domain',1,38521,1,0,0,NULL,0,7,463872)}
go
{CALL CT_ExportColumns(0,'Content-Type',1014,'application/soap+xml; charset=utf-8','Content-Type',0,38522,3,0,0,NULL,0,0,463872)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1014,NULL,'ExternalSyncID',2,38523,2,0,0,NULL,0,8,463872)}
go
{CALL CT_ExportColumns(0,'UNcommand',45,'sale','UMcommand',0,38524,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'UNcommand',45,'authonly','UMcommand',0,38525,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'UNcommand',45,'capture','UMcommand',0,38526,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'UNcommand',45,'void','UMcommand',0,38527,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'UNcommand',45,'credit','UMcommand',0,38528,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Login',45,NULL,'Login',1,38529,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',45,'$Login','UMkey',0,38530,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',45,NULL,'ProcTransID',1,38531,0,0,0,NULL,0,3,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',45,'$ProcTransID','UMrefNum',0,38532,1,0,0,NULL,0,3,416)}
go
{CALL CT_ExportColumns(0,'CardNumber',45,NULL,'CardNumber',1,38533,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',45,'$CardNumber','UMcard',0,38534,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'expmm',45,NULL,'expmm',1,38535,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'expyy',45,NULL,'expyy',1,38536,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'expmmexpyy',45,'$expmm$expyy','UMexpir',0,38537,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'CountryCode',45,NULL,'CountryCode',2,38538,0,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'CountryCode',45,'$CountryCode','UMcurrency',0,38539,1,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'Amount',45,NULL,'Amount',2,38540,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Amount',45,'$Amount','UMamount',0,38541,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',45,NULL,'CustomerID',2,38542,0,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',45,'$CustomerID','UMcustid',0,38543,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'TransID',45,NULL,'TransID',2,38544,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'TransID',45,'$TransID','UMinvoice',0,38545,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',45,NULL,'SecurityCode',1,38546,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',45,'$SecurityCode','UMcvv2',0,38547,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'Email',45,NULL,'Email',1,38548,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'Email',45,'$Email','UMcustemail',0,38549,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,NULL,45,'No','UMcustreceipt',0,38550,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',45,NULL,'CardHolder',1,38551,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',45,'$CardHolder','UMname',0,38552,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Address',45,NULL,'Address',1,38553,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',45,'$Address','UMstreet',0,38554,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Zip',45,NULL,'Zip',1,38555,0,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'Zip',45,'$Zip','UMzip',0,38556,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'UMsoftware',45,'Emerald v5','UMsoftware',0,38557,1,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'TransID',45,'$TransID','ieatransid',0,38558,2,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'UNcommand',208,'check','UMcommand',0,38559,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'UNcommand',208,'void','UMcommand',0,38562,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'UNcommand',208,'checkcredit','UMcommand',0,38563,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Login',208,NULL,'Login',1,38564,0,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'Login',208,'$Login','UMkey',0,38565,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'ProcTransID',208,NULL,'ProcTransID',1,38566,0,0,0,NULL,0,3,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',208,'$ProcTransID','UMrefNum',0,38567,1,0,0,NULL,0,3,416)}
go
{CALL CT_ExportColumns(0,'CountryCode',208,NULL,'CountryCode',2,38573,0,0,0,NULL,0,6,448)}
go
{CALL CT_ExportColumns(0,'CountryCode',208,'$CountryCode','UMcurrency',0,38574,1,0,0,NULL,0,6,448)}
go
{CALL CT_ExportColumns(0,'Amount',208,NULL,'Amount',2,38575,0,0,0,NULL,0,7,448)}
go
{CALL CT_ExportColumns(0,'Amount',208,'$Amount','UMamount',0,38576,1,0,0,NULL,0,7,448)}
go
{CALL CT_ExportColumns(0,'CustomerID',208,NULL,'CustomerID',2,38577,0,0,0,NULL,0,8,448)}
go
{CALL CT_ExportColumns(0,'CustomerID',208,'$CustomerID','UMcustid',0,38578,1,0,0,NULL,0,8,448)}
go
{CALL CT_ExportColumns(0,'TransID',208,NULL,'TransID',2,38579,0,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'TransID',208,'$TransID','UMinvoice',0,38580,1,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'Email',208,NULL,'Email',1,38583,0,0,0,NULL,0,11,448)}
go
{CALL CT_ExportColumns(0,'Email',208,'$Email','UMcustemail',0,38584,1,0,0,NULL,0,11,448)}
go
{CALL CT_ExportColumns(0,NULL,208,'No','UMcustreceipt',0,38585,1,0,0,NULL,0,12,448)}
go
{CALL CT_ExportColumns(0,'AccountHolder',208,NULL,'AccountHolder',1,38586,0,0,0,NULL,0,13,448)}
go
{CALL CT_ExportColumns(0,'AccountHolder',208,'$AccountHolder','UMname',0,38587,1,0,0,NULL,0,13,448)}
go
{CALL CT_ExportColumns(0,'Address',208,NULL,'Address',1,38588,0,0,0,NULL,0,14,448)}
go
{CALL CT_ExportColumns(0,'Address',208,'$Address','UMstreet',0,38589,1,0,0,NULL,0,14,448)}
go
{CALL CT_ExportColumns(0,'Zip',208,NULL,'Zip',1,38590,0,0,0,NULL,0,15,448)}
go
{CALL CT_ExportColumns(0,'Zip',208,'$Zip','UMzip',0,38591,1,0,0,NULL,0,15,448)}
go
{CALL CT_ExportColumns(0,'UMsoftware',208,'Emerald v5','UMsoftware',0,38592,1,0,0,NULL,0,16,448)}
go
{CALL CT_ExportColumns(0,'TransID',208,'$TransID','ieatransid',0,38593,2,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'BankNumber',208,NULL,'BankNumber',1,38594,0,0,0,NULL,0,17,448)}
go
{CALL CT_ExportColumns(0,'BankNumber',208,'$BankNumber','UMrouting',0,38595,1,0,0,NULL,0,17,448)}
go
{CALL CT_ExportColumns(0,'AccountNumber',208,NULL,'AccountNumber',1,38596,0,0,0,NULL,0,18,448)}
go
{CALL CT_ExportColumns(0,'AccountNumber',208,'$AccountNumber','UMaccount',0,38597,1,0,0,NULL,0,18,448)}
go
{CALL CT_ExportColumns(0,'DLNumber',208,NULL,'DLNumber',1,38598,0,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'DLNumber',208,'$DLNumber','UMdlnum',0,38599,1,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'DLState',208,NULL,'DLState',1,38600,0,0,0,NULL,0,20,448)}
go
{CALL CT_ExportColumns(0,'DLState',208,'$DLState','UMdlstate',0,38601,1,0,0,NULL,0,20,448)}
go
{CALL CT_ExportColumns(0,'Auth only',46,'auth','type',0,38602,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'Capture',46,'capture','type',0,38603,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',46,'sale','type',0,38604,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Credit',46,'refund','type',0,38605,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Credit',46,'void','type',0,38606,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Login',46,NULL,'Login',1,38607,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',46,'$Login','username',0,38608,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',46,NULL,'password',1,38609,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',46,NULL,'CardNumber',1,38611,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',46,'$CardNumber','ccnumber',0,38612,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'expmm',46,NULL,'expmm',1,38613,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'expyy',46,NULL,'expyy',1,38614,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'MMYY',46,'$expmm$expyy','ccexp',0,38615,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'Amount',46,NULL,'amount',3,38616,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',46,NULL,'SecurityCode',1,38618,0,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',46,'$SecurityCode','cvv',0,38619,1,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,NULL,46,'creditcard','payment',0,38620,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'TransID',46,NULL,'TransID',2,38621,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'TransID',46,'$TransID','orderid',0,38622,1,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'TransID',46,'$TransID','ieatransid',0,38623,2,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',46,NULL,'CardHolder',1,38624,0,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',46,'$CardHolder','firstname',0,38625,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',46,NULL,'lastname',0,38626,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Company',46,NULL,'company',1,38627,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Address',46,NULL,'Address',1,38629,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'Address',46,'$Address','address1',0,38630,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'City',46,NULL,'city',1,38631,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'State2',46,NULL,'State2',1,38633,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'State2',46,'$State2','state',0,38634,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Zip',46,NULL,'zip',1,38635,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Country2',46,NULL,'Country2',1,38637,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Country2',46,'$Country2','country',0,38638,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Phone',46,NULL,'phone',1,38639,1,0,0,NULL,0,17,80)}
go
{CALL CT_ExportColumns(0,'Email',46,NULL,'email',1,38641,1,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',46,NULL,'ProcTransID',1,38643,0,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',46,'$ProcTransID','transactionid',0,38644,1,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',209,'sale','type',0,38647,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Credit',209,'refund','type',0,38648,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Credit',209,'void','type',0,38649,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Login',209,NULL,'Login',1,38650,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',209,'$Login','username',0,38651,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',209,NULL,'password',1,38652,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Amount',209,NULL,'amount',3,38658,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,NULL,209,'check','payment',0,38661,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'TransID',209,NULL,'TransID',2,38662,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'TransID',209,'$TransID','orderid',0,38663,1,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'TransID',209,'$TransID','ieatransid',0,38664,2,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'AccountHolder',209,NULL,'AccountHolder',1,38665,0,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'AccountHolder',209,'$AccountHolder','firstname',0,38666,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'AccountHolder',209,NULL,'lastname',0,38667,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Company',209,NULL,'company',1,38668,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Address',209,NULL,'Address',1,38669,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'Address',209,'$Address','address1',0,38670,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'City',209,NULL,'City',1,38671,0,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'City',209,'$City','city',0,38672,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'State2',209,NULL,'State2',1,38673,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'State2',209,'$State2','state',0,38674,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Zip',209,NULL,'zip',1,38675,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Country2',209,NULL,'Country2',1,38677,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Country2',209,'$Country2','country',0,38678,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Phone',209,NULL,'phone',1,38679,1,0,0,NULL,0,17,80)}
go
{CALL CT_ExportColumns(0,'Email',209,NULL,'email',1,38680,1,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',209,NULL,'ProcTransID',1,38681,0,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',209,'$ProcTransID','transactionid',0,38682,1,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'AccountHolder',209,'$AccountHolder','checkname',0,38683,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'BankNumber',209,NULL,'BankNumber',1,38684,0,0,0,NULL,0,20,64)}
go
{CALL CT_ExportColumns(0,'BankNumber',209,'$BankNumber','checkaba',0,38685,1,0,0,NULL,0,20,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',209,NULL,'AccountNumber',1,38686,0,0,0,NULL,0,21,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',209,'$AccountNumber','checkaccount',0,38687,1,0,0,NULL,0,21,64)}
go
{CALL CT_ExportColumns(0,NULL,209,'personal','account_holder_type',0,38688,1,0,0,NULL,0,22,64)}
go
{CALL CT_ExportColumns(0,'BankTransType',209,NULL,'BankTransType',1,38689,0,0,0,NULL,0,23,64)}
go
{CALL CT_ExportColumns(0,'BankTransType',209,'$BankTransType','account_type',0,38690,1,0,0,NULL,0,23,64)}
go
{CALL CT_ExportColumns(0,'Auth/Capture URL',47,'https://ukvps.protx.com/vspgateway/service/vspdirect-register.vsp','URL',0,38691,4,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Capture URL',47,'https://ukvps.protx.com/vspgateway/service/release.vsp','URL',0,38692,4,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'Credit URL',47,'https://ukvps.protx.com/vspgateway/service/refund.vsp','URL',0,38693,4,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Void URL',47,'https://ukvps.protx.com/vspgateway/service/void.vsp','URL',0,38694,4,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'VPSProtocol',47,'2.22','VPSProtocol',0,38695,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'TxType',47,'DEFERRED','TxType',0,38696,1,0,0,NULL,0,3,16)}
go
{CALL CT_ExportColumns(0,'TxType',47,'RELEASE','TxType',0,38697,1,0,0,NULL,0,3,32)}
go
{CALL CT_ExportColumns(0,'TxType',47,'PAYMENT','TxType',0,38698,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'TxType',47,'VOID','TxType',0,38699,1,0,0,NULL,0,3,128)}
go
{CALL CT_ExportColumns(0,'TxType',47,'REFUND','TxType',0,38700,1,0,0,NULL,0,3,256)}
go
{CALL CT_ExportColumns(0,'Vendor Login',47,NULL,'Login',1,38701,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Vendor Login',47,'$Login','Vendor',0,38702,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'TransID',47,NULL,'TransID',2,38703,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'TransID',47,'$TransID','VendorTxCode',0,38704,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'PrevTransID',47,NULL,'PrevTransID',2,38705,0,0,0,NULL,0,6,256)}
go
{CALL CT_ExportColumns(0,'PrevTransID',47,'$PrevTransID','RelatedVendorTxCode',0,38706,1,0,0,NULL,0,6,256)}
go
{CALL CT_ExportColumns(0,'Amount',47,NULL,'Amount',3,38707,1,0,0,NULL,0,7,464)}
go
{CALL CT_ExportColumns(0,'Amount',47,NULL,'Amount',3,38708,0,0,0,NULL,0,7,32)}
go
{CALL CT_ExportColumns(0,'Amount',47,'$Amount','ReleaseAmount',0,38709,1,0,0,NULL,0,7,32)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',47,NULL,'CurrencyCode',1,38710,0,0,0,NULL,0,8,336)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',47,'$CurrencyCode','Currency',0,38711,1,0,0,NULL,0,8,336)}
go
{CALL CT_ExportColumns(0,NULL,47,'TransID: $TransID','Description',0,38712,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,NULL,47,'TransID: $PrevTransID','Description',0,38713,1,0,0,NULL,0,9,256)}
go
{CALL CT_ExportColumns(0,'CardHolder',47,NULL,'CardHolder',1,38714,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',47,NULL,'CardNumber',1,38715,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'expmm',47,NULL,'expmm',1,38716,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'expyy',47,NULL,'expyy',1,38717,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'MMYY',47,'$expmm$expyy','ExpiryDate',0,38718,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',47,NULL,'SecurityCode',1,38719,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',47,'$SecurityCode','CV2',0,38720,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'CardTypeAbbr',47,NULL,'CardTypeAbbr',1,38721,0,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'CardTypeAbbr',47,'$CardTypeAbbr','CardType',0,38722,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'Address',47,NULL,'Address',1,38723,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Address',47,'$Address','BillingAddress',0,38724,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Zip',47,NULL,'Zip',1,38725,0,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Zip',47,'$Zip','BillingPostCode',0,38726,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Email',47,NULL,'Email',1,38727,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Email',47,'$Email','CustomerEMail',0,38728,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'ProcTrans1',47,NULL,'ProcTrans1',1,38729,0,0,0,NULL,0,17,416)}
go
{CALL CT_ExportColumns(0,'ProcTrans1',47,'$ProcTrans1','RelatedVPSTxId',0,38730,1,0,0,NULL,0,17,256)}
go
{CALL CT_ExportColumns(0,'ProcTrans1',47,'$ProcTrans1','VPSTxId',0,38731,1,0,0,NULL,0,17,160)}
go
{CALL CT_ExportColumns(0,'ProcTrans2',47,NULL,'ProcTrans2',1,38732,0,0,0,NULL,0,18,416)}
go
{CALL CT_ExportColumns(0,'ProcTrans2',47,'$ProcTrans2','RelatedSecurityKey',0,38733,1,0,0,NULL,0,18,256)}
go
{CALL CT_ExportColumns(0,'ProcTrans2',47,'$ProcTrans2','SecurityKey',0,38734,1,0,0,NULL,0,18,160)}
go
{CALL CT_ExportColumns(0,'ApproveCode',47,NULL,'ApproveCode',1,38735,0,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'ApproveCode',47,'$ApproveCode','RelatedTxAuthNo',0,38736,1,0,0,NULL,0,19,256)}
go
{CALL CT_ExportColumns(0,'ApproveCode',47,'$ApproveCode','TxAuthNo',0,38737,1,0,0,NULL,0,19,160)}
go
{CALL CT_ExportColumns(0,'TransID',47,'$TransID','ieatransid',0,38738,2,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'TransID',39,'$TransID','ieatransid',0,38739,2,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Login',48,NULL,'Login',1,38740,0,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Login',48,'$Login','M_id',0,38741,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Password',48,NULL,'Password',1,38742,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',48,'$Password','M_key',0,38743,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',48,NULL,'CardHolder',1,38744,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',48,'$CardHolder','C_name',0,38745,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Address',48,NULL,'Address',1,38746,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Address',48,'$Address','C_address',0,38747,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'City',48,NULL,'City',1,38748,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'City',48,'$City','C_city',0,38749,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'State',48,NULL,'State',1,38750,0,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'State',48,'$State','C_state',0,38751,1,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'Zip',48,NULL,'Zip',1,38752,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Zip',48,'$Zip','C_zip',0,38753,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Country',48,NULL,'Country',1,38754,0,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'Country',48,'$Country','C_country',0,38755,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'Email',48,NULL,'Email',1,38756,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'Email',48,'$Email','C_email',0,38757,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',48,NULL,'CardNumber',1,38758,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',48,'$CardNumber','C_cardnumber',0,38759,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'expyy',48,NULL,'expyy',1,38760,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'expmm',48,NULL,'expmm',1,38761,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'MMYY',48,'$expmm$expyy','C_exp',0,38762,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'Amount',48,NULL,'Amount',3,38763,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Amount',48,'$Amount','T_amt',0,38764,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',48,'01','T_code',0,38765,1,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'Auth Only',48,'02','T_code',0,38766,1,0,0,NULL,0,13,16)}
go
{CALL CT_ExportColumns(0,'Capture previous',48,'03','T_code',0,38767,1,0,0,NULL,0,13,32)}
go
{CALL CT_ExportColumns(0,'Void',48,'04','T_code',0,38768,1,0,0,NULL,0,13,128)}
go
{CALL CT_ExportColumns(0,'Credit',48,'06','T_code',0,38769,1,0,0,NULL,0,13,256)}
go
{CALL CT_ExportColumns(0,'TransID',48,NULL,'TransID',2,38770,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'TransID',48,'$TransID','T_ordernum',0,38771,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'TransID',48,'$TransID','ieatransid',0,38772,2,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'ApproveCode',48,NULL,'ApproveCode',1,38773,0,0,0,NULL,0,15,416)}
go
{CALL CT_ExportColumns(0,'ApproveCode',48,'$ApproveCode','T_auth',0,38774,1,0,0,NULL,0,15,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',48,NULL,'ProcTransID',1,38775,0,0,0,NULL,0,16,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',48,'$ProcTransID','T_reference',0,38776,1,0,0,NULL,0,16,416)}
go
{CALL CT_ExportColumns(0,'SecurityCode',48,NULL,'SecurityCode',1,38777,0,0,0,NULL,0,17,240)}
go
{CALL CT_ExportColumns(0,'SecurityCode',48,'$SecurityCode','C_cvv',0,38778,1,0,0,NULL,0,17,240)}
go
{CALL CT_ExportColumns(0,'Phone',48,NULL,'Phone',1,38779,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Phone',48,'$Phone','C_telephone',0,38780,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'IOfferID',1010,'$OfferID','IOfferID',0,38781,2,0,0,NULL,0,12,1048576)}
go
{CALL CT_ExportColumns(0,'MailDomain',1010,NULL,'MailDomain',1,38782,1,0,0,NULL,0,13,2097152)}
go
{CALL CT_ExportColumns(0,NULL,49,'1','vpc_Version',0,38783,1,0,0,NULL,0,1,368)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',49,'pay','vpc_Command',0,38784,1,0,0,NULL,0,2,64)}
go
{CALL CT_ExportColumns(0,'TransID',49,NULL,'TransID',2,38785,0,0,0,NULL,0,3,368)}
go
{CALL CT_ExportColumns(0,'TransID',49,'$TransID','vpc_MerchTxnRef',0,38786,1,0,0,NULL,0,3,368)}
go
{CALL CT_ExportColumns(0,'Access Code (Required)',49,NULL,'Password',1,38787,0,0,0,NULL,0,4,368)}
go
{CALL CT_ExportColumns(0,'Access Code (Required)',49,'$Password','vpc_AccessCode',0,38788,1,0,0,NULL,0,4,368)}
go
{CALL CT_ExportColumns(0,'Merchant (Required)',49,NULL,'Login',1,38789,0,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'Merchant (Required)',49,'$Login','vpc_Merchant',0,38790,1,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'TransID',49,'$TransID','vpc_OrderInfo',0,38791,1,0,0,NULL,0,3,368)}
go
{CALL CT_ExportColumns(0,'Amount',49,NULL,'Amount',4,38792,0,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'Amount',49,'$Amount','vpc_Amount',0,38793,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'CardNumber',49,NULL,'CardNumber',1,38794,0,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'CardNumber',49,'$CardNumber','vpc_CardNum',0,38795,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'expyy',49,NULL,'expyy',1,38796,0,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'expmm',49,NULL,'expmm',1,38797,0,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'expyyexpmm',49,'$expyy$expmm','vpc_CardExp',0,38798,1,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',49,NULL,'SecurityCode',1,38799,0,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',49,'$SecurityCode','vpc_CardSecurityCode',0,38800,1,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'User (EMS)',49,NULL,'Store',1,38801,0,0,0,NULL,0,10,256)}
go
{CALL CT_ExportColumns(0,'User (EMS)',49,'$Store','vpc_User',0,38802,1,0,0,NULL,0,10,256)}
go
{CALL CT_ExportColumns(0,'Password (EMS)',49,NULL,'Terminal',1,38803,0,0,0,NULL,0,11,288)}
go
{CALL CT_ExportColumns(0,'Password (EMS)',49,'$Terminal','vpc_Password',0,38804,1,0,0,NULL,0,11,256)}
go
{CALL CT_ExportColumns(0,'Credit',49,'Refund','vpc_Command',0,38805,1,0,0,NULL,0,2,256)}
go
{CALL CT_ExportColumns(0,'Capture',49,'capture','vpc_Command',0,38806,1,0,0,NULL,0,2,32)}
go
{CALL CT_ExportColumns(0,'ProcTransID',49,NULL,'ProcTransID',1,38807,0,0,0,NULL,0,12,288)}
go
{CALL CT_ExportColumns(0,'ProcTransID',49,'$ProcTransID','vpc_TransactionNo',0,38808,1,0,0,NULL,0,12,288)}
go
{CALL CT_ExportColumns(0,'Login',1015,NULL,'UID',1,38809,1,0,0,NULL,0,1,3673088)}
go
{CALL CT_ExportColumns(0,'Password',1015,NULL,'PW',1,38810,1,0,0,NULL,0,2,3673088)}
go
{CALL CT_ExportColumns(0,'Second Level Domain',1015,NULL,'SLD',1,38811,1,0,0,NULL,0,3,3673088)}
go
{CALL CT_ExportColumns(0,'Top Level Domain',1015,NULL,'TLD',1,38812,1,0,0,NULL,0,4,3673088)}
go
{CALL CT_ExportColumns(0,'Company',1015,NULL,'RegistrantOrganizationName',1,38813,1,0,0,NULL,0,5,3072)}
go
{CALL CT_ExportColumns(0,'First Name',1015,NULL,'RegistrantFirstName',1,38814,1,0,0,NULL,0,6,3072)}
go
{CALL CT_ExportColumns(0,'Last Name',1015,NULL,'RegistrantLastName',1,38815,1,0,0,NULL,0,7,3072)}
go
{CALL CT_ExportColumns(0,'Address 1',1015,NULL,'RegistrantAddress1',1,38816,1,0,0,NULL,0,8,3072)}
go
{CALL CT_ExportColumns(0,'Address 2',1015,NULL,'RegistrantAddress2',1,38817,1,0,0,NULL,0,9,3072)}
go
{CALL CT_ExportColumns(0,'City',1015,NULL,'RegistrantCity',1,38818,1,0,0,NULL,0,10,3072)}
go
{CALL CT_ExportColumns(0,'State',1015,NULL,'RegistrantStateProvince',1,38819,1,0,0,NULL,0,11,3072)}
go
{CALL CT_ExportColumns(0,'Zip',1015,NULL,'RegistrantPostalCode',1,38820,1,0,0,NULL,0,12,3072)}
go
{CALL CT_ExportColumns(0,'Country',1015,NULL,'RegistrantCountry',1,38821,1,0,0,NULL,0,13,3072)}
go
{CALL CT_ExportColumns(0,'Email',1015,NULL,'RegistrantEmailAddress',1,38822,1,0,0,NULL,0,14,3072)}
go
{CALL CT_ExportColumns(0,'Phone',1015,NULL,'RegistrantPhone',1,38823,1,0,0,NULL,0,15,3072)}
go
{CALL CT_ExportColumns(0,'Fax',1015,NULL,'RegistrantFax',1,38824,1,0,0,NULL,0,16,3072)}
go
{CALL CT_ExportColumns(0,'Domain Reg Years',1015,NULL,'NumYears',2,38825,1,0,0,NULL,0,17,2098176)}
go
{CALL CT_ExportColumns(0,'Email Option ID',1015,NULL,'NewOptionID',1,38826,1,0,0,NULL,0,18,1572864)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1015,NULL,'ExternalSyncID',2,38827,2,0,0,NULL,0,19,3673088)}
go
{CALL CT_ExportColumns(0,'Register Domain (Add)',1015,'Purchase','command',0,38828,1,0,0,NULL,0,20,1024)}
go
{CALL CT_ExportColumns(0,'Update Domain Contact (Modify)',1015,'Contacts','command',0,38829,1,0,0,NULL,0,20,2048)}
go
{CALL CT_ExportColumns(0,'Configure Mail (Aux1)',1015,'ServiceSelect','command',0,38830,1,0,0,NULL,0,20,524288)}
go
{CALL CT_ExportColumns(0,'Configure Host Records (Aux2)',1015,'SetHosts','command',0,38831,1,0,0,NULL,0,20,1048576)}
go
{CALL CT_ExportColumns(0,'Renew Domain (Aux3)',1015,'Extend','command',0,38832,1,0,0,NULL,0,20,2097152)}
go
{CALL CT_ExportColumns(0,'ResponseType',1015,'xml','ResponseType',0,38833,1,0,0,NULL,0,21,3673088)}
go
{CALL CT_ExportColumns(0,'UseDNS (Add)',1015,'default','UseDNS',0,38834,1,0,0,NULL,0,22,1024)}
go
{CALL CT_ExportColumns(0,'UnlockRegistrar (Add)',1015,'0','UnlockRegistrar',0,38835,1,0,0,NULL,0,23,1024)}
go
{CALL CT_ExportColumns(0,'Service (Aux1)',1015,'emailset','Service',0,38836,1,0,0,NULL,0,24,524288)}
go
{CALL CT_ExportColumns(0,'Update (Aux1)',1015,'true','Update',0,38837,1,0,0,NULL,0,25,524288)}
go
{CALL CT_ExportColumns(0,'NewOptionID',1015,'$NewOptionID','ieaoptionid',0,38838,2,0,0,NULL,0,18,1572864)}
go
{CALL CT_ExportColumns(0,'Forward',1010,NULL,'Forward',1,38839,1,0,0,NULL,0,14,20971520)}
go
{CALL CT_ExportColumns(0,'ForwardOption',1010,NULL,'ForwardOption',2,38840,1,0,0,NULL,0,15,16777216)}
go
{CALL CT_ExportColumns(0,'TransID',50,NULL,'TransID',2,38841,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Make Payment',50,'https://www.govone.com/epay/http/mp.aspx','URL',0,38842,4,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Reference',50,'$TransID','f',0,38843,1,0,0,NULL,0,2,112)}
go
{CALL CT_ExportColumns(0,'Amount',50,NULL,'Amount',3,38844,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'PaymentAmount',50,'$Amount','o',0,38845,1,0,0,NULL,0,3,112)}
go
{CALL CT_ExportColumns(0,'PaymentMedium',50,'2','pp',0,38846,1,0,0,NULL,0,4,112)}
go
{CALL CT_ExportColumns(0,'CardNumber',50,NULL,'CardNumber',1,38847,0,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'CardNumber',50,'$CardNumber','pac',0,38848,1,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'expmm',50,NULL,'expmm',1,38849,0,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'expyy',50,NULL,'expyy',1,38850,0,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'ExpirationMonth',50,'$expmm','pax',0,38851,1,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'ExpirationYear',50,'$expyy','pap',0,38852,1,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'PurchaseID',50,'$TransID','pau',0,38853,1,0,0,NULL,0,2,112)}
go
{CALL CT_ExportColumns(0,'SecurityCode',50,NULL,'SecurityCode',1,38854,0,0,0,NULL,0,7,112)}
go
{CALL CT_ExportColumns(0,'CVV2',50,'$SecurityCode','pav',0,38855,1,0,0,NULL,0,7,112)}
go
{CALL CT_ExportColumns(0,'CardHolder',50,NULL,'CardHolder',1,38856,0,0,0,NULL,0,8,112)}
go
{CALL CT_ExportColumns(0,'NameFull',50,'$CardHolder','pabe',0,38857,1,0,0,NULL,0,8,112)}
go
{CALL CT_ExportColumns(0,'Phone',50,NULL,'Phone',1,38858,0,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'Phone1',50,'$Phone','pabp',0,38859,1,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'Email',50,NULL,'Email',1,38860,0,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'Email',50,'$Email','pabi',0,38861,1,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'Address',50,NULL,'Address',1,38862,0,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'Street1',50,'$Address','pabs',0,38863,1,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'City',50,NULL,'City',1,38864,0,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'City',50,'$City','pasc',0,38865,1,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'State2',50,NULL,'State2',1,38866,0,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'State',50,'$State2','passt',0,38867,1,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'Zip',50,NULL,'Zip',1,38868,0,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'Zip',50,'$Zip','pasz',0,38869,1,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'CardStatusFlag',50,'1','par',0,38870,1,0,0,NULL,0,15,112)}
go
{CALL CT_ExportColumns(0,'Reference Identifier',50,'$TransID','i',0,38871,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'RefundAmount',50,'$Amount','e',0,38872,1,0,0,NULL,0,3,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',50,NULL,'ProcTransID',1,38873,0,0,0,NULL,0,16,384)}
go
{CALL CT_ExportColumns(0,'ConfirmationNumber',50,'$ProcTransID','o',0,38874,1,0,0,NULL,0,16,384)}
go
{CALL CT_ExportColumns(0,'Cancel Payment',50,'https://www.govone.com/epay/http/cp.aspx','URL',0,38875,4,0,0,NULL,0,1,384)}
go
{CALL CT_ExportColumns(0,'Return Mode',50,'r','m',0,38876,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Application ID',50,NULL,'Login',1,38877,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Application ID',50,'$Login','a',0,38878,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Security Key',50,NULL,'Password',1,38879,0,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Security Key',50,'$Password','s',0,38880,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Payment Channel',50,'0','p',0,38881,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'TransID',210,NULL,'TransID',2,38882,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Make Payment',210,'https://www.govone.com/epay/http/mp.aspx','URL',0,38883,4,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Reference',210,'$TransID','f',0,38884,1,0,0,NULL,0,2,112)}
go
{CALL CT_ExportColumns(0,'Amount',210,NULL,'Amount',3,38885,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'PaymentAmount',210,'$Amount','o',0,38886,1,0,0,NULL,0,3,112)}
go
{CALL CT_ExportColumns(0,'PaymentMedium',210,'1','pp',0,38887,1,0,0,NULL,0,4,112)}
go
{CALL CT_ExportColumns(0,'AccountNumber',210,NULL,'AccountNumber',1,38888,0,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'AccountNumber',210,'$AccountNumber','ppn',0,38889,1,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'AccountHolder',210,NULL,'AccountHolder',1,38897,0,0,0,NULL,0,8,112)}
go
{CALL CT_ExportColumns(0,'NameFull',210,'$AccountHolder','ppae',0,38898,1,0,0,NULL,0,8,112)}
go
{CALL CT_ExportColumns(0,'Phone',210,NULL,'Phone',1,38899,0,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'Phone1',210,'$Phone','ppap',0,38900,1,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'Email',210,NULL,'Email',1,38901,0,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'Email',210,'$Email','ppai',0,38902,1,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'Address',210,NULL,'Address',1,38903,0,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'Street1',210,'$Address','ppds',0,38904,1,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'City',210,NULL,'City',1,38905,0,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'City',210,'$City','ppdc',0,38906,1,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'State2',210,NULL,'State2',1,38907,0,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'State',210,'$State2','ppdst',0,38908,1,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'Zip',210,NULL,'Zip',1,38909,0,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'Zip',210,'$Zip','ppdz',0,38910,1,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'Reference Identifier',210,'$TransID','i',0,38912,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'RefundAmount',210,'$Amount','e',0,38913,1,0,0,NULL,0,3,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',210,NULL,'ProcTransID',1,38914,0,0,0,NULL,0,16,384)}
go
{CALL CT_ExportColumns(0,'ConfirmationNumber',210,'$ProcTransID','o',0,38915,1,0,0,NULL,0,16,384)}
go
{CALL CT_ExportColumns(0,'Cancel Payment',210,'https://www.govone.com/epay/http/cp.aspx','URL',0,38916,4,0,0,NULL,0,1,384)}
go
{CALL CT_ExportColumns(0,'Return Mode',210,'r','m',0,38917,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Application ID',210,NULL,'Login',1,38918,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Application ID',210,'$Login','a',0,38919,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Security Key',210,NULL,'Password',1,38920,0,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Security Key',210,'$Password','s',0,38921,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Payment Channel',210,'0','p',0,38922,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'BankNumber',210,NULL,'BankNumber',1,38923,0,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'BankRoutingNumber',210,'$BankNumber','ppb',0,38924,1,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'BankName',210,NULL,'BankName',1,38925,0,0,0,NULL,0,21,112)}
go
{CALL CT_ExportColumns(0,'BankName',210,'$BankName','ppm',0,38926,1,0,0,NULL,0,21,112)}
go
{CALL CT_ExportColumns(0,'DLNumber',210,NULL,'DLNumber',1,38927,0,0,0,NULL,0,22,112)}
go
{CALL CT_ExportColumns(0,'DriversLicenseNumber',210,'$DLNumber','ppd',0,38928,1,0,0,NULL,0,22,112)}
go
{CALL CT_ExportColumns(0,'DLState',210,NULL,'DLState',1,38929,0,0,0,NULL,0,23,112)}
go
{CALL CT_ExportColumns(0,'DriversLicenseState',210,'$DLState','ppr',0,38930,1,0,0,NULL,0,23,112)}
go
{CALL CT_ExportColumns(0,'SSN',210,NULL,'SSN',1,38931,0,0,0,NULL,0,24,112)}
go
{CALL CT_ExportColumns(0,'SSN',210,'$SSN','pps',0,38932,1,0,0,NULL,0,24,112)}
go
{CALL CT_ExportColumns(0,'Company',210,NULL,'Company',1,38933,0,0,0,NULL,0,25,112)}
go
{CALL CT_ExportColumns(0,'BusinessName',210,'$Company','ppu',0,38934,1,0,0,NULL,0,25,112)}
go
{CALL CT_ExportColumns(0,'URL',40,'https://webservices.primerchants.com/billing/TransactionCentral/voidcreditcconline.asp','URL',0,38935,4,0,0,NULL,0,13,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',40,NULL,'ProcTransID',1,38936,0,0,0,NULL,0,14,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',40,'$ProcTransID','TransID',0,38937,1,0,0,NULL,0,14,384)}
go
{CALL CT_ExportColumns(0,'Amount',40,'$Amount','CreditAmount',0,38938,1,0,0,NULL,0,3,384)}
go
{CALL CT_ExportColumns(0,'URL',205,'https://webservices.primerchants.com/billing/transactioncentral/addckcreditupdtonline.asp','URL',0,38939,4,0,0,NULL,0,9,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',205,NULL,'ProcTransID',1,38940,0,0,0,NULL,0,10,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',205,'$ProcTransID','TransID',0,38941,1,0,0,NULL,0,10,384)}
go
{CALL CT_ExportColumns(0,'Amount',205,'$Amount','CreditAmount',0,38944,1,0,0,NULL,0,3,384)}
go
{CALL CT_ExportColumns(0,'Terminal ID',51,NULL,'Login',1,39033,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Password',51,NULL,'Password',1,39034,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(1,'TransID',51,NULL,'TransID',2,39035,1,0,0,'0',0,2,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',51,NULL,'CardNumber',1,39036,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'expmm',51,NULL,'expmm',1,39037,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'expyy',51,NULL,'expyy',1,39038,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',51,NULL,'SecurityCode',1,39039,1,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',51,NULL,'CardHolder',1,39040,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Amount',51,NULL,'Amount',4,39041,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'Address',51,NULL,'Address',1,39042,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'City',51,NULL,'City',1,39043,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'Zip',51,NULL,'Zip',1,39044,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'Country3',51,NULL,'Country3',1,39045,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Phone',51,NULL,'Phone',1,39046,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Email',51,NULL,'Email',1,39047,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'ApproveCode',51,NULL,'ApproveCode',1,39048,1,0,0,NULL,0,15,32)}
go
{CALL CT_ExportColumns(0,'TransID',51,'$TransID','ieatransid',0,39049,2,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'zero pad',51,'000000000000000000','zero',0,39050,0,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'18-digit transid (auth)',51,'$TransID$zero','TransactionID',0,39051,1,18,18,NULL,0,2,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',51,NULL,'ProcTransID',1,39052,1,0,0,NULL,0,17,416)}
go
{CALL CT_ExportColumns(0,'18-digit transid (ref)',51,'$ProcTransID','TransactionID',0,39053,1,0,0,NULL,0,2,416)}
go
{CALL CT_ExportColumns(0,'Origin (RECURRING,BILL PAYMENT, INTERNET, PHONE ORDER)',51,NULL,'Terminal',1,39054,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Terminal ID',211,NULL,'Login',1,39055,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Password',211,NULL,'Password',1,39056,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(1,'TransID',211,NULL,'TransID',2,39057,1,0,0,'0',0,2,496)}
go
{CALL CT_ExportColumns(0,'AccountNumber',211,NULL,'AccountNumber',1,39058,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'AccountHolder',211,NULL,'AccountHolder',1,39062,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Amount',211,NULL,'Amount',4,39063,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'TransID',211,'$TransID','ieatransid',0,39071,2,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'zero pad',211,'000000000000000000','zero',0,39072,0,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'18-digit transid (auth)',211,'$TransID$zero','TransactionID',0,39073,1,18,18,NULL,0,2,336)}
go
{CALL CT_ExportColumns(0,'ProcTransID',211,NULL,'ProcTransID',1,39074,1,0,0,NULL,0,17,160)}
go
{CALL CT_ExportColumns(0,'BankNumber',211,NULL,'BankNumber',1,39077,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'BankTransTypeIP',211,NULL,'BankTransTypeIP',1,39078,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'Standard Entry Class (SEC)',211,NULL,'Merchant',1,39079,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'Email',212,NULL,'Email',1,39080,0,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Email',212,'$Email','s_email',0,39081,1,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Email Receipt',212,'FALSE','s_emailreceipt',0,39082,1,0,0,NULL,0,1,80)}
go
{CALL CT_ExportColumns(0,'Phone',212,NULL,'Phone',1,39086,0,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'Phone',212,'$Phone','s_phone',0,39087,1,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'State',212,NULL,'State',1,39088,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'State',212,'$State','s_state',0,39089,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'City',212,NULL,'City',1,39090,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'City',212,'$City','s_city',0,39091,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'Country2',212,NULL,'Country2',1,39092,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Country2',212,'$Country2','s_country',0,39093,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'BankNumber',212,NULL,'BankNumber',1,39094,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'BankNumber',212,'$BankNumber','s_bank_aba_code',0,39095,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',212,NULL,'ProcTransID',1,39096,0,0,0,NULL,0,8,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',212,'$ProcTransID','s_trans_id',0,39097,1,0,0,NULL,0,8,416)}
go
{CALL CT_ExportColumns(0,'AccountHolder',212,NULL,'AccountHolder',1,39098,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'AccountHolder',212,'$AccountHolder','s_first_name',0,39099,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Address',212,NULL,'Address',1,39100,0,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Address',212,'$Address','s_address',0,39101,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Zip',212,NULL,'Zip',1,39102,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Zip',212,'$Zip','s_zip',0,39103,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'AccountNumber',212,NULL,'AccountNumber',1,39104,0,0,0,NULL,0,12,336)}
go
{CALL CT_ExportColumns(0,'AccountNumber',212,'$AccountNumber','s_bank_acct_num',0,39105,1,0,0,NULL,0,12,336)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',212,NULL,'ExternalTransID',2,39106,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'ExternalTransID',212,'$ExternalTransID','s_orderid',0,39107,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Auth only',212,'AUTH_ONLY','s_type',0,39108,1,0,0,NULL,0,14,16)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',212,'AUTH_CAPTURE','s_type',0,39109,1,0,0,NULL,0,14,64)}
go
{CALL CT_ExportColumns(0,'Credit',212,'CREDIT','s_type',0,39110,1,0,0,NULL,0,14,256)}
go
{CALL CT_ExportColumns(0,'Void',212,'VOID','s_type',0,39111,1,0,0,NULL,0,14,128)}
go
{CALL CT_ExportColumns(0,'Capture previous',212,'PRIOR_AUTH_C','s_type',0,39112,1,0,0,NULL,0,14,32)}
go
{CALL CT_ExportColumns(0,NULL,212,'ECHECK','s_method',0,39113,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',212,NULL,'CustomerID',2,39114,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'CustomerID',212,'$CustomerID','s_customer_id',0,39115,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Amount',212,NULL,'Amount',3,39116,0,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'Amount',212,'$Amount','s_amount',0,39117,1,0,0,NULL,0,17,368)}
go
{CALL CT_ExportColumns(0,'SecureNet ID',212,NULL,'Login',1,39118,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'SecureNet ID',212,'$Login','s_securenetid',0,39119,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Security Key',212,NULL,'Password',1,39120,0,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Security Key',212,'$Password','s_securekey',0,39121,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'Company',212,NULL,'Company',1,39122,0,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'Company',212,'$Company','s_company',0,39123,1,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'BankTransTypeUC',212,NULL,'BankTransTypeUC',1,39124,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'BankTransTypeUC',212,'$BankTransTypeUC','s_bank_acct_type',0,39125,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'BankName',212,NULL,'BankName',1,39126,0,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'BankName',212,'$BankName','s_bank_acct_name',0,39127,1,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'TransID',43,NULL,'TransID',1,39128,2,0,0,NULL,0,21,256)}
go
{CALL CT_ExportColumns(0,'Forward',1010,'$Forward','IForward',0,39129,2,0,0,NULL,0,14,16777216)}
go
{CALL CT_ExportColumns(0,'Address',52,NULL,'Address',1,39130,1,0,0,NULL,0,1,368)}
go
{CALL CT_ExportColumns(0,'Amount',52,NULL,'Amount',3,39131,1,0,0,NULL,0,2,368)}
go
{CALL CT_ExportColumns(0,'Auth+Capture',52,'SALE','Auth_Transaction_Type',0,39132,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'Credit',52,'REFUND','Auth_Transaction_Type',0,39133,1,0,0,NULL,0,3,256)}
go
{CALL CT_ExportColumns(0,'Auth Only',52,'PREAUTH','Auth_Transaction_Type',0,39134,1,0,0,NULL,0,3,16)}
go
{CALL CT_ExportColumns(0,'Capture previous',52,'FORCE','Auth_Transaction_Type',0,39135,1,0,0,NULL,0,3,32)}
go
{CALL CT_ExportColumns(0,'ApproveCode',52,NULL,'ApproveCode',1,39136,0,0,0,NULL,0,4,288)}
go
{CALL CT_ExportColumns(0,'ApproveCode',52,'$ApproveCode','ApprovalCode',0,39137,1,0,0,NULL,0,4,288)}
go
{CALL CT_ExportColumns(0,'CardNumber',52,NULL,'CardNumber',1,39138,1,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'CardPresent',52,'N','CardPresent',0,39139,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'CustomerID',52,NULL,'CustomerID',2,39140,0,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'CustomerID',52,'$CustomerID','CustomerCode',0,39141,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'SecurityCodePresent',52,NULL,'SecurityCodePresent',2,39142,0,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'SecurityCodePresent',52,'$SecurityCodePresent','CVV2Indicator',0,39143,1,0,0,NULL,0,8,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',52,NULL,'SecurityCode',1,39144,0,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'SecurityCode',52,'$SecurityCode','CVV2Value',0,39145,1,0,0,NULL,0,9,368)}
go
{CALL CT_ExportColumns(0,'expmm',52,NULL,'expmm',1,39146,0,0,0,NULL,0,10,368)}
go
{CALL CT_ExportColumns(0,'expyy',52,NULL,'expyy',1,39147,0,0,0,NULL,0,10,368)}
go
{CALL CT_ExportColumns(0,'mm/yy',52,'$expmm/$expyy','ExpDate',0,39148,1,0,0,NULL,0,10,368)}
go
{CALL CT_ExportColumns(0,'ProcTransID',52,NULL,'ProcTransID',1,39149,0,0,0,NULL,0,11,128)}
go
{CALL CT_ExportColumns(0,'ProcTransID',52,'$ProcTransID','IDStamp_List',0,39150,1,0,0,NULL,0,11,128)}
go
{CALL CT_ExportColumns(0,'TransID',52,NULL,'TransID',2,39151,0,0,0,NULL,0,12,368)}
go
{CALL CT_ExportColumns(0,'TransID',52,'$TransID','InvoiceNumber',0,39152,1,0,0,NULL,0,12,368)}
go
{CALL CT_ExportColumns(0,'Phone',52,NULL,'Phone',1,39153,0,0,0,NULL,0,13,368)}
go
{CALL CT_ExportColumns(0,'Phone',52,'$Phone','PhoneNumber',0,39154,1,0,0,NULL,0,13,368)}
go
{CALL CT_ExportColumns(0,'Profile Name',52,NULL,'Terminal',1,39155,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Profile Name',52,'$Terminal','ProfileName',0,39156,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Credit:Management',52,'Credit:Management','Queue',0,39157,1,0,0,NULL,0,15,128)}
go
{CALL CT_ExportColumns(0,'Void',52,'Void','Action',0,39158,1,0,0,NULL,0,15,128)}
go
{CALL CT_ExportColumns(0,'State2',52,NULL,'State2',1,39159,0,0,0,NULL,0,16,368)}
go
{CALL CT_ExportColumns(0,'State2',52,'$State2','StateCode',0,39160,1,0,0,NULL,0,16,368)}
go
{CALL CT_ExportColumns(0,'User ID',52,NULL,'Login',1,39161,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Password',52,NULL,'Password',1,39162,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'User ID',52,'$Login;$Password','UserID',0,39163,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Zip',52,NULL,'Zip',1,39164,1,0,0,NULL,0,18,368)}
go
{CALL CT_ExportColumns(0,'TransID',52,'$TransID','ieatransid',0,39165,2,0,0,NULL,0,12,432)}
go
{CALL CT_ExportColumns(0,'Base URL',52,NULL,'baseurl',1,39166,0,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'/cgi-bin/auth.cgi',52,'$baseurl/cgi-bin/auth.cgi','URL',0,39167,4,0,0,NULL,0,0,368)}
go
{CALL CT_ExportColumns(0,'/cgi-bin/gatewayadmin.cgi',52,'$baseurl/cgi-bin/gatewayadmin.cgi','URL',0,39168,4,0,0,NULL,0,0,128)}
go
{CALL CT_ExportColumns(0,'CardHolder',52,NULL,'CardHolder',1,39169,0,0,0,NULL,0,19,368)}
go
{CALL CT_ExportColumns(0,'Merchant ID',53,NULL,'Merchant',1,39170,0,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Merchant ID',53,'$Merchant','merchant_id',0,39171,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'paymentMethod',53,'CC','paymentMethod',0,39172,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Auth Only',53,'PA','trnType',0,39173,1,0,0,NULL,0,3,16)}
go
{CALL CT_ExportColumns(0,'Capture previous',53,'PAC','trnType',0,39174,1,0,0,NULL,0,3,32)}
go
{CALL CT_ExportColumns(0,'Auth+Capture',53,'P','trnType',0,39175,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'Void',53,'VP','trnType',0,39176,1,0,0,NULL,0,3,128)}
go
{CALL CT_ExportColumns(0,'Credit',53,'R','trnType',0,39177,1,0,0,NULL,0,3,256)}
go
{CALL CT_ExportColumns(0,'Username',53,NULL,'Login',1,39178,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Username',53,'$Login','username',0,39179,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Password',53,NULL,'password',1,39180,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'adjId',53,NULL,'ProcTransID',1,39181,0,0,0,NULL,0,6,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',53,'$ProcTransID','adjId',0,39182,1,0,0,NULL,0,6,416)}
go
{CALL CT_ExportColumns(0,'CardHolder',53,NULL,'CardHolder',1,39183,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',53,'$CardHolder','trnCardOwner',0,39184,1,0,0,NULL,0,7,240)}
go
{CALL CT_ExportColumns(0,'CardNumber',53,NULL,'CardNumber',1,39185,0,0,0,NULL,0,8,240)}
go
{CALL CT_ExportColumns(0,'CardNumber',53,'$CardNumber','trnCardNumber',0,39186,1,0,0,NULL,0,8,240)}
go
{CALL CT_ExportColumns(0,'expmm',53,NULL,'expmm',1,39187,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'expmm',53,'$expmm','trnExpMonth',0,39188,1,0,0,NULL,0,9,240)}
go
{CALL CT_ExportColumns(0,'expyy',53,NULL,'expyy',1,39189,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'expyy',53,'$expyy','trnExpYear',0,39190,1,0,0,NULL,0,10,240)}
go
{CALL CT_ExportColumns(0,'SecurityCode',53,NULL,'SecurityCode',1,39191,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',53,'$SecurityCode','trnCardCvd',0,39192,1,0,0,NULL,0,11,240)}
go
{CALL CT_ExportColumns(0,'CardHolder',53,'$CardHolder','ordName',0,39193,1,0,0,NULL,0,7,240)}
go
{CALL CT_ExportColumns(0,'Email',53,NULL,'Email',1,39194,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Email',53,'$Email','ordEmailAddress',0,39195,1,0,0,NULL,0,12,240)}
go
{CALL CT_ExportColumns(0,'Phone',53,NULL,'Phone',1,39196,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Phone',53,'$Phone','ordPhoneNumber',0,39197,1,0,0,NULL,0,13,240)}
go
{CALL CT_ExportColumns(0,'Address',53,NULL,'Address',1,39198,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',53,'$Address','ordAddress1',0,39199,1,0,0,NULL,0,14,240)}
go
{CALL CT_ExportColumns(0,'City',53,NULL,'City',1,39200,0,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'City',53,'$City','ordCity',0,39201,1,0,0,NULL,0,15,240)}
go
{CALL CT_ExportColumns(0,'State2',53,NULL,'State2',1,39202,0,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'State2',53,'$State2','ordProvince',0,39203,1,0,0,NULL,0,16,240)}
go
{CALL CT_ExportColumns(0,'Zip',53,NULL,'Zip',1,39204,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Zip',53,'$Zip','ordPostalCode',0,39205,1,0,0,NULL,0,17,240)}
go
{CALL CT_ExportColumns(0,'Country2',53,NULL,'Country2',1,39206,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Country2',53,'$Country2','ordCountry',0,39207,1,0,0,NULL,0,18,240)}
go
{CALL CT_ExportColumns(0,'TransID',53,NULL,'TransID',2,39208,0,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'TransID',53,'$TransID','trnOrderNumber',0,39209,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'requestType',53,'BACKEND','requestType',0,39210,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Merchant ID',213,NULL,'Merchant',1,39211,0,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'Merchant ID',213,'$Merchant','merchant_id',0,39212,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'paymentMethod',213,'CC','paymentMethod',0,39213,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'Debit',213,'D','trnType',0,39216,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'Void Debit',213,'VD','trnType',0,39217,1,0,0,NULL,0,3,128)}
go
{CALL CT_ExportColumns(0,'Credit',213,'C','trnType',0,39218,1,0,0,NULL,0,3,256)}
go
{CALL CT_ExportColumns(0,'Username',213,NULL,'Login',1,39219,0,0,0,NULL,0,4,448)}
go
{CALL CT_ExportColumns(0,'Username',213,'$Login','username',0,39220,1,0,0,NULL,0,4,448)}
go
{CALL CT_ExportColumns(0,'Password',213,NULL,'password',1,39221,1,0,0,NULL,0,5,448)}
go
{CALL CT_ExportColumns(0,'adjId',213,NULL,'ProcTransID',1,39222,0,0,0,NULL,0,6,384)}
go
{CALL CT_ExportColumns(0,'ProcTransID',213,'$ProcTransID','adjId',0,39223,1,0,0,NULL,0,6,384)}
go
{CALL CT_ExportColumns(0,'BankNumber',213,NULL,'BankNumber',1,39228,0,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'BankNumber',213,'$BankNumber','routingNumber',0,39229,1,0,0,NULL,0,9,192)}
go
{CALL CT_ExportColumns(0,'AccountNumber',213,NULL,'accountNumber',1,39230,1,0,0,NULL,0,10,192)}
go
{CALL CT_ExportColumns(0,'AccountHolder',213,NULL,'AccountHolder',1,39234,0,0,0,NULL,0,21,448)}
go
{CALL CT_ExportColumns(0,'Email',213,NULL,'Email',1,39235,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Email',213,'$Email','ordEmailAddress',0,39236,1,0,0,NULL,0,12,240)}
go
{CALL CT_ExportColumns(0,'Phone',213,NULL,'Phone',1,39237,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Phone',213,'$Phone','ordPhoneNumber',0,39238,1,0,0,NULL,0,13,240)}
go
{CALL CT_ExportColumns(0,'Address',213,NULL,'Address',1,39239,0,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Address',213,'$Address','ordAddress1',0,39240,1,0,0,NULL,0,14,240)}
go
{CALL CT_ExportColumns(0,'City',213,NULL,'City',1,39241,0,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'City',213,'$City','ordCity',0,39242,1,0,0,NULL,0,15,240)}
go
{CALL CT_ExportColumns(0,'State2',213,NULL,'State2',1,39243,0,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'State2',213,'$State2','ordProvince',0,39244,1,0,0,NULL,0,16,240)}
go
{CALL CT_ExportColumns(0,'Zip',213,NULL,'Zip',1,39245,0,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Zip',213,'$Zip','ordPostalCode',0,39246,1,0,0,NULL,0,17,240)}
go
{CALL CT_ExportColumns(0,'Country2',213,NULL,'Country2',1,39247,0,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'Country2',213,'$Country2','ordCountry',0,39248,1,0,0,NULL,0,18,240)}
go
{CALL CT_ExportColumns(0,'TransID',213,NULL,'TransID',2,39249,0,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'TransID',213,'$TransID','trnOrderNumber',0,39250,1,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'requestType',213,'BACKEND','requestType',0,39251,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'AccountHolder',213,'$AccountHolder','ordName',0,39252,1,0,0,NULL,0,21,192)}
go
{CALL CT_ExportColumns(0,'TransID',53,'$TransID','ref1',0,39253,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'TransID',213,'$TransID','ref1',0,39254,1,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'Amount',213,NULL,'Amount',3,39255,0,0,0,NULL,0,22,448)}
go
{CALL CT_ExportColumns(0,'Amount',213,'$Amount','trnAmount',0,39256,1,0,0,NULL,0,22,448)}
go
{CALL CT_ExportColumns(0,'Amount',53,NULL,'Amount',3,39257,0,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'Amount',53,'$Amount','trnAmount',0,39258,1,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'APILogin',1016,NULL,'APILogin',1,39261,1,0,0,NULL,0,1,2048)}
go
{CALL CT_ExportColumns(0,'APIPassword',1016,NULL,'APIPassword',1,39262,1,0,0,NULL,0,2,2048)}
go
{CALL CT_ExportColumns(0,'API Reference',1016,NULL,'APIRef',1,39263,1,0,0,NULL,0,3,2048)}
go
{CALL CT_ExportColumns(0,'Domain',1016,NULL,'Domain',1,39264,1,0,0,NULL,0,4,2048)}
go
{CALL CT_ExportColumns(0,'Domain Changed',1016,NULL,'chDomain',2,39265,1,0,0,NULL,0,4,2048)}
go
{CALL CT_ExportColumns(0,'First Name',1016,NULL,'FirstName',1,39266,1,0,0,NULL,0,5,2048)}
go
{CALL CT_ExportColumns(0,'First Name Changed',1016,NULL,'chFirstName',2,39267,1,0,0,NULL,0,5,2048)}
go
{CALL CT_ExportColumns(0,'Last Name',1016,NULL,'LastName',1,39268,1,0,0,NULL,0,6,2048)}
go
{CALL CT_ExportColumns(0,'Last Name Changed',1016,NULL,'chLastName',2,39269,1,0,0,NULL,0,6,2048)}
go
{CALL CT_ExportColumns(0,'Service Type',1016,NULL,'ServiceType',1,39270,1,0,0,NULL,0,7,2048)}
go
{CALL CT_ExportColumns(0,'Service Type Changed',1016,NULL,'chServiceType',2,39271,1,0,0,NULL,0,7,2048)}
go
{CALL CT_ExportColumns(0,'External Reference',1016,NULL,'ExternalRef',1,39272,1,0,0,NULL,0,8,2048)}
go
{CALL CT_ExportColumns(0,'External Ref Changed',1016,NULL,'chExternalRef',2,39273,1,0,0,NULL,0,8,2048)}
go
{CALL CT_ExportColumns(0,'Email Alias',1016,NULL,'Alias',1,39274,1,0,0,NULL,0,9,2048)}
go
{CALL CT_ExportColumns(0,'Email Alias Changed',1016,NULL,'chAlias',2,39275,1,0,0,NULL,0,9,2048)}
go
{CALL CT_ExportColumns(0,'Email Forward',1016,NULL,'Forward',1,39276,1,0,0,NULL,0,10,2048)}
go
{CALL CT_ExportColumns(0,'Email Forward Changed',1016,NULL,'chForward',2,39277,1,0,0,NULL,0,10,2048)}
go
{CALL CT_ExportColumns(0,'Action',1016,NULL,'Action',1,39278,1,0,0,NULL,0,11,2048)}
go
{CALL CT_ExportColumns(0,'Active',1016,NULL,'Active',2,39279,1,0,0,NULL,0,12,2048)}
go
{CALL CT_ExportColumns(0,'Active Changed',1016,NULL,'chActive',2,39280,1,0,0,NULL,0,12,2048)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1016,NULL,'ExternalSyncID',2,39281,2,0,0,NULL,0,13,2048)}
go
{CALL CT_ExportColumns(0,'Login',1016,NULL,'Login',1,39282,1,0,0,NULL,0,14,2048)}
go
{CALL CT_ExportColumns(0,'Login Changed',1016,NULL,'chLogin',2,39283,1,0,0,NULL,0,14,2048)}
go
{CALL CT_ExportColumns(0,'Password',1016,NULL,'Password',1,39284,1,0,0,NULL,0,15,2048)}
go
{CALL CT_ExportColumns(0,'Password Changed',1016,NULL,'chPassword',2,39285,1,0,0,NULL,0,15,2048)}
go
{CALL CT_ExportColumns(0,'Account ID',1016,NULL,'AccountID',2,39286,1,0,0,NULL,0,16,2048)}
go
{CALL CT_ExportColumns(0,'CustomerID',1016,NULL,'CustomerID',2,39287,1,0,0,NULL,0,17,2048)}
go
{CALL CT_ExportColumns(0,'Auth+Capture',54,'capture','order.type',0,39288,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Credit',54,'refund','order.type',0,39289,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Auth Only',54,'preauth','order.type',0,39290,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'Capture previous',54,'captureWithoutAuth','order.type',0,39291,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'Void',54,'reversal','order.type',0,39292,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Login',54,NULL,'Login',1,39293,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',54,'$Login','customer.username',0,39294,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',54,NULL,'Password',1,39295,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Password',54,'$Password','customer.password',0,39296,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Merchant ID',54,NULL,'Merchant',1,39297,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'Merchant ID',54,'$Merchant','customer.merchant',0,39298,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',54,NULL,'CardNumber',1,39299,0,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',54,'$CardNumber','card.PAN',0,39300,1,0,0,NULL,0,5,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',54,'$SecurityCode','card.CVN',0,39301,1,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'SecurityCode',54,NULL,'SecurityCode',1,39302,0,0,0,NULL,0,6,496)}
go
{CALL CT_ExportColumns(0,'expyy',54,NULL,'expyy',1,39303,0,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'expyy',54,'$expyy','card.expiryYear',0,39304,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'expmm',54,NULL,'expmm',1,39305,0,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'expmm',54,'$expmm','card.expiryMonth',0,39306,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',54,NULL,'CardHolder',1,39307,0,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',54,'$CardHolder','card.cardHolderName',0,39308,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'Amount',54,NULL,'Amount',4,39309,0,0,0,NULL,0,10,240)}
go
{CALL CT_ExportColumns(0,'Amount',54,'$Amount','order.amount',3,39310,1,0,0,NULL,0,10,240)}
go
{CALL CT_ExportColumns(0,'TransID',54,NULL,'TransID',2,39311,0,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'TransID',54,'$TransID','customer.orderNumber',0,39312,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',54,NULL,'CurrencyCode',1,39313,0,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',54,'$CurrencyCode','card.currency',0,39314,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Terminal',54,NULL,'Terminal',1,39315,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Terminal',54,'$Terminal','order.ECI',0,39316,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'PrevTransID',54,NULL,'PrevTransID',2,39317,0,0,0,NULL,0,14,416)}
go
{CALL CT_ExportColumns(0,'PrevTransID',54,'$PrevTransID','customer.originalOrderNumber',0,39318,1,0,0,NULL,0,14,416)}
go
{CALL CT_ExportColumns(0,'TransID',54,'$TransID','ieatransid',0,39319,2,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1017,NULL,'ExternalSyncID',2,39320,2,0,0,NULL,0,1,400384)}
go
{CALL CT_ExportColumns(0,'LogFile',1017,NULL,'LogFile',1,39321,0,0,0,NULL,0,2,400384)}
go
{CALL CT_ExportColumns(0,'partner_id',1017,NULL,'partner_id',1,39322,1,0,0,NULL,0,3,400384)}
go
{CALL CT_ExportColumns(0,'shared_secret',1017,NULL,'shared_secret',1,39323,1,0,0,NULL,0,4,400384)}
go
{CALL CT_ExportColumns(0,'feature_set_id',1017,NULL,'feature_set_id',1,39324,1,0,0,NULL,0,5,3072)}
go
{CALL CT_ExportColumns(0,'username',1017,NULL,'username',1,39325,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'password',1017,NULL,'password',1,39326,1,0,0,NULL,0,7,3072)}
go
{CALL CT_ExportColumns(0,'firstname',1017,NULL,'firstname',1,39327,1,0,0,NULL,0,8,3072)}
go
{CALL CT_ExportColumns(0,'lastname',1017,NULL,'lastname',1,39328,1,0,0,NULL,0,9,3072)}
go
{CALL CT_ExportColumns(0,'email',1017,NULL,'email',1,39329,1,0,0,NULL,0,10,3072)}
go
{CALL CT_ExportColumns(0,'country',1017,NULL,'country',1,39330,1,0,0,NULL,0,11,3072)}
go
{CALL CT_ExportColumns(0,'user_id',1017,NULL,'user_id',1,39331,1,0,0,NULL,0,12,399360)}
go
{CALL CT_ExportColumns(0,NULL,1017,'$LogFile/create_user','create_user',0,39332,4,0,0,NULL,0,13,1024)}
go
{CALL CT_ExportColumns(0,NULL,1017,'$LogFile/update_user','update_user',0,39333,4,0,0,NULL,0,13,2048)}
go
{CALL CT_ExportColumns(0,NULL,1017,'$LogFile/activate_user','activate_user',0,39334,4,0,0,NULL,0,13,131072)}
go
{CALL CT_ExportColumns(0,NULL,1017,'$LogFile/disable_user','disable_user',0,39335,4,0,0,NULL,0,13,262144)}
go
{CALL CT_ExportColumns(0,NULL,1017,'$LogFile/delete_user','delete_user',0,39336,4,0,0,NULL,0,13,4096)}
go
{CALL CT_ExportColumns(0,'result_type',1017,'xml','result_type',0,39337,1,0,0,NULL,0,14,400384)}
go
{CALL CT_ExportColumns(0,'Auth Only',55,'auth','type',0,39338,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',55,'sale','type',0,39339,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Capture',55,'capture','type',0,39340,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'Void',55,'void','type',0,39341,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Refund',55,'refund','type',0,39342,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'Company ID',55,NULL,'Login',1,39343,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',55,'$Login','company_id',0,39344,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Company Key',55,NULL,'Password',1,39345,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Client Password Key',55,'$Password','company_key',0,39346,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',55,NULL,'CardNumber',1,39347,0,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',55,'$CardNumber','cc_number',0,39348,1,0,0,NULL,0,4,496)}
go
{CALL CT_ExportColumns(0,'expyy',55,NULL,'expyy',1,39349,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'expmm',55,NULL,'expmm',1,39350,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'exp MMYY',55,'$expmm$expyy','cc_exp',0,39351,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',55,NULL,'SecurityCode',1,39352,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',55,'$SecurityCode','cvv',0,39353,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Amount',55,NULL,'amount',3,39354,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'TransID',55,NULL,'TransID',2,39355,0,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'TransID',55,'$TransID','order_id',0,39356,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'FirstName',55,NULL,'FirstName',1,39357,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'FirstName',55,'$FirstName','first_name',0,39358,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'LastName',55,NULL,'LastName',1,39359,0,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'LastName',55,'$LastName','last_name',0,39360,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Company',55,NULL,'company',1,39361,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Address',55,NULL,'Address',1,39362,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'Address',55,'$Address','address1',0,39363,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'city',55,NULL,'city',1,39364,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'State2',55,NULL,'State2',1,39365,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'State2',55,'$State2','state',0,39366,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'zip',55,NULL,'zip',1,39367,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Country2',55,NULL,'Country2',1,39368,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'Country2',55,'$Country2','country',0,39369,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'phone',55,NULL,'phone',1,39370,1,0,0,NULL,0,17,80)}
go
{CALL CT_ExportColumns(0,'Email',55,NULL,'email',1,39371,1,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',55,NULL,'ProcTransID',1,39372,0,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',55,'$ProcTransID','transaction_id',0,39373,1,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'Product ID',55,NULL,'Terminal',1,39374,0,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Terminal',55,'$Terminal','product_id',0,39375,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'TransID',55,'$TransID','ieatransid',0,39376,2,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'Processor ID',55,NULL,'Store',1,39377,0,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'Store',55,'$Store','processor_id',0,39378,1,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1018,NULL,'ExternalSyncID',2,39379,2,0,0,NULL,0,1,2038784)}
go
{CALL CT_ExportColumns(0,'auth_username',1018,NULL,'auth_username',1,39380,1,0,0,NULL,0,2,2038784)}
go
{CALL CT_ExportColumns(0,'auth_password',1018,NULL,'auth_password',1,39381,1,0,0,NULL,0,3,2038784)}
go
{CALL CT_ExportColumns(0,'serviceplanID',1018,NULL,'serviceplanID',1,39382,1,0,0,NULL,0,4,525312)}
go
{CALL CT_ExportColumns(0,'hardquota',1018,NULL,'hardquota',1,39383,1,0,0,NULL,0,5,525312)}
go
{CALL CT_ExportColumns(0,'accountno',1018,NULL,'accountno',1,39384,1,0,0,NULL,0,6,2037760)}
go
{CALL CT_ExportColumns(0,'username',1018,NULL,'username',1,39385,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'password',1018,NULL,'password',1,39386,1,0,0,NULL,0,8,66560)}
go
{CALL CT_ExportColumns(0,'ct_company',1018,NULL,'ct_company',1,39387,1,0,0,NULL,0,9,3072)}
go
{CALL CT_ExportColumns(0,'ct_firstname',1018,NULL,'ct_firstname',1,39388,1,0,0,NULL,0,10,3072)}
go
{CALL CT_ExportColumns(0,'ct_lastname',1018,NULL,'ct_lastname',1,39389,1,0,0,NULL,0,11,3072)}
go
{CALL CT_ExportColumns(0,'ct_phone',1018,NULL,'ct_phone',1,39390,1,0,0,NULL,0,12,3072)}
go
{CALL CT_ExportColumns(0,'ct_address1',1018,NULL,'ct_address1',1,39391,1,0,0,NULL,0,13,3072)}
go
{CALL CT_ExportColumns(0,'ct_address2',1018,NULL,'ct_address2',1,39392,1,0,0,NULL,0,14,3072)}
go
{CALL CT_ExportColumns(0,'ct_city',1018,NULL,'ct_city',1,39393,1,0,0,NULL,0,15,3072)}
go
{CALL CT_ExportColumns(0,'ct_state',1018,NULL,'ct_state',1,39394,1,0,0,NULL,0,16,3072)}
go
{CALL CT_ExportColumns(0,'ct_zip',1018,NULL,'ct_zip',1,39395,1,0,0,NULL,0,17,3072)}
go
{CALL CT_ExportColumns(0,'ct_country',1018,NULL,'ct_country',1,39396,1,0,0,NULL,0,18,3072)}
go
{CALL CT_ExportColumns(0,'ct_email',1018,NULL,'ct_email',1,39397,1,0,0,NULL,0,19,3072)}
go
{CALL CT_ExportColumns(0,'createaccount',1018,'createaccount','method',0,39398,1,0,0,NULL,0,20,1024)}
go
{CALL CT_ExportColumns(0,'updateaccountcontact',1018,'updateaccountcontact','method',0,39399,1,0,0,NULL,0,20,2048)}
go
{CALL CT_ExportColumns(0,'accountsetinfo',1018,'accountsetinfo','method',0,39400,1,0,0,NULL,0,20,524288)}
go
{CALL CT_ExportColumns(0,'enableaccount',1018,'enableaccount','method',0,39401,1,0,0,NULL,0,20,393216)}
go
{CALL CT_ExportColumns(0,'resetaccountpassword',1018,'resetaccountpassword','method',0,39402,1,0,0,NULL,0,20,65536)}
go
{CALL CT_ExportColumns(0,'deleteaccount',1018,'deleteaccount','method',0,39403,1,0,0,NULL,0,20,4096)}
go
{CALL CT_ExportColumns(0,'mustchange',1018,'0','mustchange',0,39404,1,0,0,NULL,0,21,66560)}
go
{CALL CT_ExportColumns(0,'enable',1018,'1','enable',0,39405,1,0,0,NULL,0,22,131072)}
go
{CALL CT_ExportColumns(0,'disable',1018,'0','enable',0,39406,1,0,0,NULL,0,22,262144)}
go
{CALL CT_ExportColumns(0,'aux1value',1018,'$ServiceplanID$Hardquota','aux1value',0,39407,2,0,0,NULL,0,23,524288)}
go
{CALL CT_ExportColumns(0,'EFSDEV',1018,NULL,'EFSDEV',1,39408,1,0,0,NULL,0,24,2038784)}
go
{CALL CT_ExportColumns(0,'expiration',1018,'NULL','expiration',0,39409,1,0,0,NULL,0,25,524288)}
go
{CALL CT_ExportColumns(0,'expiredays',1018,NULL,'expiredays',1,39411,1,0,0,NULL,0,26,1024)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1019,NULL,'ExternalSyncID',2,39490,2,0,0,NULL,0,1,70728704)}
go
{CALL CT_ExportColumns(0,'Auth',1019,NULL,'Auth',1,39491,0,0,0,NULL,0,2,3619840)}
go
{CALL CT_ExportColumns(0,'Authorization Header',1019,'GoogleLogin auth=$Auth','Authorization',0,39492,3,0,0,NULL,0,2,3619840)}
go
{CALL CT_ExportColumns(0,NULL,1019,'application/atom+xml','Content-type',0,39493,3,0,0,NULL,0,3,3619840)}
go
{CALL CT_ExportColumns(0,'PUT',1019,'PUT','X-HTTP-Method-Override',0,39494,3,0,0,NULL,0,4,468992)}
go
{CALL CT_ExportColumns(0,'DELETE',1019,'DELETE','X-HTTP-Method-Override',0,39495,3,0,0,NULL,0,4,2101248)}
go
{CALL CT_ExportColumns(0,'ClientLogin URL',1019,'https://www.google.com/accounts/ClientLogin','URL',0,39496,4,0,0,NULL,0,6,67108864)}
go
{CALL CT_ExportColumns(0,'Domain',1019,NULL,'Domain',1,39497,1,0,0,NULL,0,5,3619840)}
go
{CALL CT_ExportColumns(0,'Add URL',1019,'https://apps-apis.google.com/a/feeds/$domain/user/2.0','URL',0,39498,4,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Update URL',1019,'https://apps-apis.google.com/a/feeds/$domain/user/2.0/$login','URL',0,39499,4,0,0,NULL,0,6,473088)}
go
{CALL CT_ExportColumns(0,'APILogin',1019,NULL,'APILogin',1,39500,0,0,0,NULL,0,7,67108864)}
go
{CALL CT_ExportColumns(0,'APILogin',1019,'$APILogin','Email',0,39501,1,0,0,NULL,0,7,67108864)}
go
{CALL CT_ExportColumns(0,'APIPassword',1019,NULL,'APIPassword',1,39502,0,0,0,NULL,0,8,67108864)}
go
{CALL CT_ExportColumns(0,'APIPassword',1019,'$APIPassword','Passwd',0,39503,1,0,0,NULL,0,8,67108864)}
go
{CALL CT_ExportColumns(0,'accountType',1019,'HOSTED','accountType',0,39504,1,0,0,NULL,0,9,67108864)}
go
{CALL CT_ExportColumns(0,'service',1019,'apps','service',0,39505,1,0,0,NULL,0,10,67108864)}
go
{CALL CT_ExportColumns(0,'Login',1019,NULL,'Login',1,39506,1,0,0,NULL,0,5,3619840)}
go
{CALL CT_ExportColumns(0,'NewLogin',1019,NULL,'NewLogin',1,39507,1,0,0,NULL,0,12,1056768)}
go
{CALL CT_ExportColumns(0,'Password',1019,NULL,'Password',1,39508,1,0,0,NULL,0,13,66560)}
go
{CALL CT_ExportColumns(0,'FirstName',1019,NULL,'FirstName',1,39509,1,0,0,NULL,0,14,3072)}
go
{CALL CT_ExportColumns(0,'LastName',1019,NULL,'LastName',1,39510,1,0,0,NULL,0,15,3072)}
go
{CALL CT_ExportColumns(0,'Status',1019,'OK','Status',0,39511,2,0,0,NULL,0,16,3619840)}
go
{CALL CT_ExportColumns(0,'Login',1019,'$Login','AddLogin',0,39512,2,0,0,NULL,0,17,1024)}
go
{CALL CT_ExportColumns(0,'AddLogin',1019,'$NewLogin','AddLogin',0,39513,2,0,0,NULL,0,17,1056768)}
go
{CALL CT_ExportColumns(0,'Add Nickname URL',1019,'https://apps-apis.google.com/a/feeds/$domain/nickname/2.0','URL',0,39514,4,0,0,NULL,0,6,1048576)}
go
{CALL CT_ExportColumns(0,'Delete Nickname URL',1019,'https://apps-apis.google.com/a/feeds/$domain/nickname/2.0/$login','URL',0,39515,4,0,0,NULL,0,6,2097152)}
go
{CALL CT_ExportColumns(0,'source',1019,'Emerald 5.0.73','source',0,39516,1,0,0,NULL,0,11,67108864)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1020,NULL,'ExternalSyncID',2,39517,2,0,0,NULL,0,1,1580032)}
go
{CALL CT_ExportColumns(0,'APILogin',1020,NULL,'APILogin',1,39518,0,0,0,NULL,0,2,1580032)}
go
{CALL CT_ExportColumns(0,'login',1020,'$APILogin','login',0,39519,1,0,0,NULL,0,2,1580032)}
go
{CALL CT_ExportColumns(0,'APIPassword',1020,NULL,'APIPassword',1,39520,0,0,0,NULL,0,3,1580032)}
go
{CALL CT_ExportColumns(0,'pwd',1020,'$APIPassword','pwd',0,39521,1,0,0,NULL,0,3,1580032)}
go
{CALL CT_ExportColumns(0,'username',1020,NULL,'username',1,39522,1,0,0,NULL,0,4,1580032)}
go
{CALL CT_ExportColumns(0,'username',1020,'$username','password',0,39523,1,0,0,NULL,0,5,3072)}
go
{CALL CT_ExportColumns(0,'FirstName',1020,NULL,'firstname',1,39524,1,0,0,NULL,0,6,3072)}
go
{CALL CT_ExportColumns(0,'LastName',1020,NULL,'lastname',1,39525,1,0,0,NULL,0,7,3072)}
go
{CALL CT_ExportColumns(0,'begindate',1020,NULL,'begindate',1,39526,1,0,0,NULL,0,8,1051648)}
go
{CALL CT_ExportColumns(0,'enddate',1020,NULL,'enddate',1,39527,1,0,0,NULL,0,9,1051648)}
go
{CALL CT_ExportColumns(0,'purgeafter',1020,NULL,'purgeafter',1,39528,1,0,0,NULL,0,10,1051648)}
go
{CALL CT_ExportColumns(0,'accessprofile',1020,NULL,'accessprofile',1,39529,1,0,0,NULL,0,11,3072)}
go
{CALL CT_ExportColumns(0,'serviceprofiles',1020,NULL,'serviceprofiles',1,39530,1,0,0,NULL,0,12,3072)}
go
{CALL CT_ExportColumns(0,'email',1020,NULL,'email',1,39531,1,0,0,NULL,0,13,3072)}
go
{CALL CT_ExportColumns(0,'phonenumber',1020,NULL,'phonenumber',1,39532,1,0,0,NULL,0,14,3072)}
go
{CALL CT_ExportColumns(0,'accountinfo',1020,NULL,'accountinfo',1,39533,1,0,0,NULL,0,15,525312)}
go
{CALL CT_ExportColumns(0,'concurrentlogins',1020,NULL,'concurrentlogins',1,39534,1,0,0,NULL,0,16,3072)}
go
{CALL CT_ExportColumns(0,'accounttype',1020,NULL,'accounttype',1,39535,1,0,0,NULL,0,17,3072)}
go
{CALL CT_ExportColumns(0,'Data',1020,NULL,'Data',1,39537,2,0,0,NULL,0,18,1572864)}
go
{CALL CT_ExportColumns(0,'username',1020,'$username','ieauser',0,39538,2,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'accesstype',1020,'1','accesstype',0,39539,1,0,0,NULL,0,19,3072)}
go
{CALL CT_ExportColumns(0,'organization',1020,'postpaid','organization',0,39540,1,0,0,NULL,0,20,3072)}
go
{CALL CT_ExportColumns(0,'method',1020,'addUser','method',0,39541,1,0,0,NULL,0,21,1024)}
go
{CALL CT_ExportColumns(0,'method',1020,'modifyUser','method',0,39542,1,0,0,NULL,0,21,1574912)}
go
{CALL CT_ExportColumns(0,'method',1020,'delUser','method',0,39543,1,0,0,NULL,0,21,4096)}
go
{CALL CT_ExportColumns(0,'force',1020,'true','force',0,39544,1,0,0,NULL,0,22,4096)}
go
{CALL CT_ExportColumns(0,'Auth + Capture',56,'SA','Action',0,39545,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'Auth Only',56,'PA','Action',0,39546,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'Capture',56,'CP','Action',0,39547,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'Secret Code',56,NULL,'Login',1,39548,0,0,0,NULL,0,2,112)}
go
{CALL CT_ExportColumns(0,'Login',56,'$Login','Secret',0,39549,1,0,0,NULL,0,2,112)}
go
{CALL CT_ExportColumns(0,'Hashing Key',56,NULL,'Password',1,39550,0,0,0,NULL,0,3,112)}
go
{CALL CT_ExportColumns(0,'UMID',56,NULL,'Merchant',1,39551,0,0,0,NULL,0,4,112)}
go
{CALL CT_ExportColumns(0,'Merchant',56,'$Merchant','UMID',0,39552,1,0,0,NULL,0,4,112)}
go
{CALL CT_ExportColumns(0,'SiteID',56,NULL,'Store',1,39553,0,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'Store',56,'$Store','SiteID',0,39554,1,0,0,NULL,0,5,112)}
go
{CALL CT_ExportColumns(0,'TransID',56,NULL,'TransID',2,39555,0,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'TransID',56,'$TransID','OrderID',0,39556,1,0,0,NULL,0,6,112)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',56,NULL,'CurrencyCode',1,39557,0,0,0,NULL,0,7,112)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',56,'$CurrencyCode','Currency',0,39558,1,0,0,NULL,0,7,112)}
go
{CALL CT_ExportColumns(0,'Amount',56,NULL,'Amount',3,39559,1,0,0,NULL,0,8,112)}
go
{CALL CT_ExportColumns(0,'Email',56,NULL,'Email',1,39560,0,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'Email',56,'$Email','CustomerEmail',0,39561,1,0,0,NULL,0,9,112)}
go
{CALL CT_ExportColumns(0,'FirstName',56,NULL,'FirstName',1,39562,0,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'FirstName',56,'$FirstName','CustomerFirstName',0,39563,1,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'LastName',56,NULL,'LastName',1,39564,0,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'LastName',56,'$LastName','CustomerLastName',0,39565,1,0,0,NULL,0,11,112)}
go
{CALL CT_ExportColumns(0,'City',56,NULL,'City',1,39566,0,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'City',56,'$City','CustomerCity',0,39567,1,0,0,NULL,0,12,112)}
go
{CALL CT_ExportColumns(0,'Address',56,NULL,'Address',1,39568,0,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'Address',56,'$Address','CustomerAddress',0,39569,1,0,0,NULL,0,13,112)}
go
{CALL CT_ExportColumns(0,'State2',56,NULL,'State2',1,39570,0,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'State2',56,'$State2','CustomerState',0,39571,1,0,0,NULL,0,14,112)}
go
{CALL CT_ExportColumns(0,'Zip',56,NULL,'Zip',1,39572,0,0,0,NULL,0,15,112)}
go
{CALL CT_ExportColumns(0,'Zip',56,'$Zip','CustomerZip',0,39573,1,0,0,NULL,0,15,112)}
go
{CALL CT_ExportColumns(0,'Country2',56,NULL,'Country2',1,39574,0,0,0,NULL,0,16,112)}
go
{CALL CT_ExportColumns(0,'Country2',56,'$Country2','CustomerCountry',0,39575,1,0,0,NULL,0,16,112)}
go
{CALL CT_ExportColumns(0,'Phone',56,NULL,'Phone',1,39576,0,0,0,NULL,0,17,112)}
go
{CALL CT_ExportColumns(0,'Phone',56,'$Phone','CustomerPhone',0,39577,1,0,0,NULL,0,17,112)}
go
{CALL CT_ExportColumns(0,'CardType',56,NULL,'CardType',1,39578,1,0,0,NULL,0,18,112)}
go
{CALL CT_ExportColumns(0,'CardNumber',56,NULL,'CardNumber',1,39579,1,0,0,NULL,0,19,112)}
go
{CALL CT_ExportColumns(0,'expmm',56,NULL,'expmm',1,39580,0,0,0,NULL,0,20,112)}
go
{CALL CT_ExportColumns(0,'expmm',56,'$expmm','ExpMonth',0,39581,1,0,0,NULL,0,20,112)}
go
{CALL CT_ExportColumns(0,'expyyyy',56,NULL,'expyyyy',1,39582,0,0,0,NULL,0,21,112)}
go
{CALL CT_ExportColumns(0,'expyyyy',56,'$expyyyy','ExpYear',0,39583,1,0,0,NULL,0,21,112)}
go
{CALL CT_ExportColumns(0,'SecurityCode',56,NULL,'SecurityCode',1,39584,1,0,0,NULL,0,22,112)}
go
{CALL CT_ExportColumns(0,'ReturnURL',56,'https://localhost','ReturnURL',0,39585,1,0,0,NULL,0,23,112)}
go
{CALL CT_ExportColumns(0,'Fingerprint',56,'$Merchant$TransID$CurrencyCode$Amount$Login$Password','Fingerprint',11,39586,1,0,0,NULL,0,24,112)}
go
{CALL CT_ExportColumns(0,'expmm',57,NULL,'expmm',1,39587,1,0,0,NULL,0,1,336)}
go
{CALL CT_ExportColumns(0,'expyy',57,NULL,'expyy',1,39588,1,0,0,NULL,0,2,336)}
go
{CALL CT_ExportColumns(0,'State2',57,NULL,'State2',1,39589,1,0,0,NULL,0,3,336)}
go
{CALL CT_ExportColumns(0,'City',57,NULL,'City',1,39590,1,0,0,NULL,0,4,336)}
go
{CALL CT_ExportColumns(0,'PrevTransID',57,NULL,'PrevTransID',2,39591,1,0,0,NULL,0,5,256)}
go
{CALL CT_ExportColumns(0,'CardNumber',57,NULL,'CardNumber',1,39592,1,0,0,NULL,0,6,336)}
go
{CALL CT_ExportColumns(0,'ProcTransID',57,NULL,'ProcTransID',1,39593,1,0,0,NULL,0,7,288)}
go
{CALL CT_ExportColumns(0,'CardHolder',57,NULL,'CardHolder',1,39594,1,0,0,NULL,0,8,336)}
go
{CALL CT_ExportColumns(0,'Address',57,NULL,'Address',1,39595,1,0,0,NULL,0,9,336)}
go
{CALL CT_ExportColumns(0,'Zip',57,NULL,'Zip',1,39596,1,0,0,NULL,0,10,336)}
go
{CALL CT_ExportColumns(0,'SecurityCode',57,NULL,'SecurityCode',1,39597,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'TransID',57,NULL,'TransID',2,39598,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Merchant Key',57,NULL,'Merchant',1,39599,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Client ID',57,NULL,'Store',1,39600,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'Amount',57,NULL,'Amount',3,39601,1,0,0,NULL,0,15,336)}
go
{CALL CT_ExportColumns(0,'User ID',57,NULL,'Login',1,39602,1,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'User PW',57,NULL,'Password',1,39603,1,0,0,NULL,0,17,496)}
go
{CALL CT_ExportColumns(0,'Email',214,NULL,'Email',1,39604,1,0,0,NULL,0,1,320)}
go
{CALL CT_ExportColumns(0,'AccountNumber',214,NULL,'AccountNumber',1,39605,1,0,0,NULL,0,2,320)}
go
{CALL CT_ExportColumns(0,'AccountHolder',214,NULL,'AccountHolder',1,39606,1,0,0,NULL,0,3,320)}
go
{CALL CT_ExportColumns(0,'Address',214,NULL,'Address',1,39607,1,0,0,NULL,0,4,320)}
go
{CALL CT_ExportColumns(0,'City',214,NULL,'City',1,39608,1,0,0,NULL,0,5,320)}
go
{CALL CT_ExportColumns(0,'State2',214,NULL,'State2',1,39609,1,0,0,NULL,0,6,320)}
go
{CALL CT_ExportColumns(0,'Zip',214,NULL,'Zip',1,39610,1,0,0,NULL,0,7,320)}
go
{CALL CT_ExportColumns(0,'ProcTransID',214,NULL,'ProcTransID',1,39611,1,0,0,NULL,0,8,384)}
go
{CALL CT_ExportColumns(0,'TransID',214,NULL,'TransID',2,39612,1,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'Merchant Key',214,NULL,'Merchant',1,39613,1,0,0,NULL,0,10,448)}
go
{CALL CT_ExportColumns(0,'Client ID',214,NULL,'Store',1,39614,1,0,0,NULL,0,11,448)}
go
{CALL CT_ExportColumns(0,'Amount',214,NULL,'Amount',3,39615,1,0,0,NULL,0,12,320)}
go
{CALL CT_ExportColumns(0,'BankTransTypeFC',214,NULL,'BankTransTypeFC',1,39616,1,0,0,NULL,0,13,320)}
go
{CALL CT_ExportColumns(0,'BankNumber',214,NULL,'BankNumber',1,39617,1,0,0,NULL,0,14,320)}
go
{CALL CT_ExportColumns(0,'BankName',214,NULL,'BankName',1,39618,1,0,0,NULL,0,15,320)}
go
{CALL CT_ExportColumns(0,'User ID',214,NULL,'Login',1,39619,1,0,0,NULL,0,16,448)}
go
{CALL CT_ExportColumns(0,'User PW',214,NULL,'Password',1,39620,1,0,0,NULL,0,17,448)}
go
{CALL CT_ExportColumns(0,'SSN',214,NULL,'SSN',1,39621,1,0,0,NULL,0,18,320)}
go
{CALL CT_ExportColumns(0,'DLNumber',214,NULL,'DLNumber',1,39622,1,0,0,NULL,0,19,320)}
go
{CALL CT_ExportColumns(0,'DLState',214,NULL,'DLState',1,39623,1,0,0,NULL,0,20,320)}
go
{CALL CT_ExportColumns(0,'birthyyyy',214,NULL,'birthyyyy',1,39624,1,0,0,NULL,0,21,320)}
go
{CALL CT_ExportColumns(0,'birthmm',214,NULL,'birthmm',1,39625,1,0,0,NULL,0,22,320)}
go
{CALL CT_ExportColumns(0,'birthdd',214,NULL,'birthdd',1,39626,1,0,0,NULL,0,23,320)}
go
{CALL CT_ExportColumns(0,'idtype',214,NULL,'idtype',1,39627,1,0,0,NULL,0,24,320)}
go
{CALL CT_ExportColumns(0,'Country2',214,NULL,'Country2',1,39628,1,0,0,NULL,0,25,320)}
go
{CALL CT_ExportColumns(0,'Phone',214,NULL,'Phone',1,39629,1,0,0,NULL,0,26,320)}
go
{CALL CT_ExportColumns(0,'Content-Type',214,'text/xml','Content-Type',0,39630,3,0,0,NULL,0,27,448)}
go
{CALL CT_ExportColumns(0,'Content-Type',57,'text/xml','Content-Type',0,39631,3,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'ieatransid',214,'$TransID','ieatransid',0,39632,2,0,0,NULL,0,9,448)}
go
{CALL CT_ExportColumns(0,'ieatransid',57,'$TransID','ieatransid',0,39633,2,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',57,'$ProcTransID','VoidProcTransID',0,39634,1,0,0,NULL,0,7,128)}
go
{CALL CT_ExportColumns(0,'Store ID',58,NULL,'Login',1,39635,1,0,0,NULL,0,1,511)}
go
{CALL CT_ExportColumns(0,'API Token',58,NULL,'Password',1,39637,1,0,0,NULL,0,2,511)}
go
{CALL CT_ExportColumns(0,'Amount',58,NULL,'Amount',3,39639,1,0,0,NULL,0,3,383)}
go
{CALL CT_ExportColumns(0,'CardNumber',58,NULL,'CardNumber',1,39641,1,0,0,NULL,0,4,95)}
go
{CALL CT_ExportColumns(0,'expmm',58,NULL,'expmm',1,39643,1,0,0,NULL,0,5,95)}
go
{CALL CT_ExportColumns(0,'expyy',58,NULL,'expyy',1,39645,1,0,0,NULL,0,6,95)}
go
{CALL CT_ExportColumns(0,'CustomerID',58,NULL,'CustomerID',2,39647,1,0,0,NULL,0,7,95)}
go
{CALL CT_ExportColumns(0,'TransID',58,NULL,'TransID',2,39649,1,0,0,NULL,0,8,511)}
go
{CALL CT_ExportColumns(0,'User-Agent',58,'PERL - 2.5.0','User-Agent',0,39651,3,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'PrevTransID',58,NULL,'PrevTransID',2,39652,1,0,0,NULL,0,9,416)}
go
{CALL CT_ExportColumns(0,'Address',58,NULL,'Address',1,39653,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Zip',58,NULL,'Zip',1,39654,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'Email',58,NULL,'Email',1,39655,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'Phone',58,NULL,'Phone',1,39656,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',58,NULL,'SecurityCode',1,39657,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'SecurityCodePresent',58,NULL,'SecurityCodePresent',2,39658,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'TransID',58,'$TransID','ieatransid',0,39659,2,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',58,NULL,'ProcTransID',1,39660,1,0,0,NULL,0,17,416)}
go
{CALL CT_ExportColumns(0,'APILogin',1021,NULL,'APILogin',1,39661,1,0,0,NULL,0,1,67108864)}
go
{CALL CT_ExportColumns(0,'APIPassword',1021,NULL,'APIPassword',1,39662,1,0,0,NULL,0,2,67108864)}
go
{CALL CT_ExportColumns(0,'Login',1021,NULL,'Login',1,39663,1,0,0,NULL,0,3,11264)}
go
{CALL CT_ExportColumns(0,'Domain',1021,NULL,'Domain',1,39664,1,0,0,NULL,0,4,11264)}
go
{CALL CT_ExportColumns(0,'Password',1021,NULL,'Password',1,39665,1,0,0,NULL,0,5,66560)}
go
{CALL CT_ExportColumns(0,'FirstName',1021,NULL,'FirstName',1,39666,1,0,0,NULL,0,6,3072)}
go
{CALL CT_ExportColumns(0,'LastName',1021,NULL,'LastName',1,39667,1,0,0,NULL,0,7,3072)}
go
{CALL CT_ExportColumns(0,'Address1',1021,NULL,'Address1',1,39668,1,0,0,NULL,0,8,3072)}
go
{CALL CT_ExportColumns(0,'City',1021,NULL,'City',1,39669,1,0,0,NULL,0,9,3072)}
go
{CALL CT_ExportColumns(0,'State',1021,NULL,'State',1,39670,1,0,0,NULL,0,10,3072)}
go
{CALL CT_ExportColumns(0,'Zip',1021,NULL,'Zip',1,39671,1,0,0,NULL,0,11,3072)}
go
{CALL CT_ExportColumns(0,'Phone',1021,NULL,'Phone',1,39672,1,0,0,NULL,0,12,3072)}
go
{CALL CT_ExportColumns(0,'Company',1021,NULL,'Company',1,39673,1,0,0,NULL,0,13,3072)}
go
{CALL CT_ExportColumns(0,'MailForward',1021,NULL,'MailForward',1,39674,1,0,0,NULL,0,14,3072)}
go
{CALL CT_ExportColumns(0,'MailAlias',1021,NULL,'MailAlias',1,39675,1,0,0,NULL,0,15,3145728)}
go
{CALL CT_ExportColumns(0,'ProcTransID',1021,NULL,'ProcTransID',1,39676,1,0,0,NULL,0,16,3618816)}
go
{CALL CT_ExportColumns(0,'AuthToken',1021,NULL,'AuthToken',1,39677,1,0,0,NULL,0,17,3619840)}
go
{CALL CT_ExportColumns(0,'COSID',1021,NULL,'COSID',1,39678,1,0,0,NULL,0,18,3072)}
go
{CALL CT_ExportColumns(0,'Login',1021,'$Login','iLogin',0,39679,2,0,0,NULL,0,3,8192)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1021,NULL,'ExternalSyncID',2,39680,2,0,0,NULL,0,19,70728704)}
go
{CALL CT_ExportColumns(0,'Status',1021,'OK','Status',0,39681,2,0,0,NULL,0,20,70728704)}
go
{CALL CT_ExportColumns(0,'Vendor',41,NULL,'Store',1,39682,0,0,0,NULL,0,22,240)}
go
{CALL CT_ExportColumns(0,'Vendor',206,NULL,'Store',1,39683,0,0,0,NULL,0,22,240)}
go
{CALL CT_ExportColumns(0,'X-VPS-CLIENTTIMEOUT',206,'200','X-VPS-CLIENTTIMEOUT',0,39684,3,0,0,NULL,0,23,496)}
go
{CALL CT_ExportColumns(0,'X-VPS-CLIENTTIMEOUT',41,'200','X-VPS-CLIENTTIMEOUT',0,39685,3,0,0,NULL,0,23,496)}
go
{CALL CT_ExportColumns(0,'getaccountlist',1018,'getaccountlist','method',0,39686,1,0,0,NULL,0,20,1048576)}
go
{CALL CT_ExportColumns(1,'Record Count',215,NULL,'RecordCount',2,39687,1,6,6,'0',0,10,49472)}
go
{CALL CT_ExportColumns(0,'Header',215,'A','RecordType',0,39688,1,1,1,NULL,0,20,16384)}
go
{CALL CT_ExportColumns(0,'Footer',215,'Z','RecordType',0,39689,1,1,1,NULL,0,20,32768)}
go
{CALL CT_ExportColumns(0,'Debit',215,'D','RecordType',0,39690,1,1,1,NULL,0,20,64)}
go
{CALL CT_ExportColumns(0,'Credit',215,'C','RecordType',0,39691,1,1,1,NULL,0,20,256)}
go
{CALL CT_ExportColumns(0,'Header',215,'HDR','TransactionCode',0,39692,1,3,3,NULL,0,30,16384)}
go
{CALL CT_ExportColumns(0,'Footer',215,'TRL','TransactionCode',0,39693,1,3,3,NULL,0,30,32768)}
go
{CALL CT_ExportColumns(0,'Credit/Debit',215,NULL,'TransactionCode',0,39694,1,3,3,NULL,0,30,320)}
go
{CALL CT_ExportColumns(0,'Client Number',215,NULL,'Merchant',1,39695,1,10,10,'0',0,40,49472)}
go
{CALL CT_ExportColumns(0,'Client Name',215,NULL,'Store',1,39696,1,30,30,NULL,0,50,16384)}
go
{CALL CT_ExportColumns(0,'Credit/Debit',215,NULL,'Blank',0,39697,1,1,1,NULL,0,50,320)}
go
{CALL CT_ExportColumns(1,'Total Transactions',215,NULL,'ItemCount',2,39698,1,6,6,'0',0,70,32768)}
go
{CALL CT_ExportColumns(1,'File creation number',215,NULL,'GroupID',2,39699,1,4,4,'0',0,60,16384)}
go
{CALL CT_ExportColumns(1,'Customer number',215,NULL,'TransID',2,39700,1,19,19,'0',0,60,320)}
go
{CALL CT_ExportColumns(1,'Value of payment transactions',215,NULL,'ItemTotal',4,39701,1,14,14,'0',0,80,32768)}
go
{CALL CT_ExportColumns(0,'File creation date',215,NULL,'nowyyyy',2,39702,1,4,4,NULL,0,70,16384)}
go
{CALL CT_ExportColumns(1,'File creation date',215,NULL,'nowddd',2,39703,1,3,3,'0',0,71,16384)}
go
{CALL CT_ExportColumns(0,'Payment Number',215,'00','PaymentNumber',0,39704,1,2,2,'0',0,70,320)}
go
{CALL CT_ExportColumns(0,'Currency Type',215,NULL,'CurrencyCode',1,39705,1,3,3,NULL,0,80,16384)}
go
{CALL CT_ExportColumns(1,'BankNumber',215,NULL,'BankNumber',1,39706,1,9,9,'0',0,90,320)}
go
{CALL CT_ExportColumns(0,'Input Type',215,'1','InputType',0,39707,1,1,1,NULL,0,90,16384)}
go
{CALL CT_ExportColumns(0,'zero fill',215,NULL,'zerofill',0,39708,1,2,2,'0',0,90,32768)}
go
{CALL CT_ExportColumns(0,'15+6+8+9+46+2+1 = 87',215,NULL,'blankfill',0,39709,1,87,87,NULL,0,100,16384)}
go
{CALL CT_ExportColumns(0,'Account Number',215,NULL,'AccountNumber',1,39710,1,18,18,NULL,0,100,320)}
go
{CALL CT_ExportColumns(0,'Number of optional records',215,NULL,'zerofill',0,39711,1,6,6,'0',0,100,32768)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39712,1,1,1,NULL,0,110,320)}
go
{CALL CT_ExportColumns(0,'12+6+63+2+1 = 84',215,NULL,'blankfill',0,39713,1,84,84,NULL,0,110,32768)}
go
{CALL CT_ExportColumns(1,'Credit/Debit Amount',215,NULL,'Amount',4,39714,1,10,10,'0',0,120,320)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39715,1,6,6,NULL,0,130,320)}
go
{CALL CT_ExportColumns(1,'Payment date',215,NULL,'now2yyyy',2,39716,1,4,4,'0',0,140,320)}
go
{CALL CT_ExportColumns(1,'Payment date',215,NULL,'now2ddd',2,39717,1,3,3,'0',0,141,320)}
go
{CALL CT_ExportColumns(0,'Customer Name',215,NULL,'AuthName',10,39718,1,30,30,NULL,0,150,320)}
go
{CALL CT_ExportColumns(0,'Language Code',215,'E','LanguageCode',0,39719,1,1,1,NULL,0,160,320)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39720,1,1,1,NULL,0,170,320)}
go
{CALL CT_ExportColumns(0,'client short name',215,NULL,'clientshortname',0,39721,1,15,15,NULL,0,180,320)}
go
{CALL CT_ExportColumns(0,'Destination Currency',215,NULL,'destcurrency',0,39722,1,3,3,NULL,0,190,320)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39723,1,1,1,NULL,0,200,320)}
go
{CALL CT_ExportColumns(0,'Destination Country',215,NULL,'Country3',1,39724,1,3,3,NULL,0,210,320)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39725,1,2,2,NULL,0,220,320)}
go
{CALL CT_ExportColumns(0,'blank fill',215,NULL,'blankfill',0,39726,1,2,2,NULL,0,230,320)}
go
{CALL CT_ExportColumns(0,'Optional Record indicator',215,'N','optionalrecord',0,39727,1,1,1,NULL,0,240,320)}
go
{CALL CT_ExportColumns(0,'Batch Number',215,NULL,'GroupID',2,39728,0,0,0,NULL,0,0,49472)}
go
{CALL CT_ExportColumns(0,'Credit/Debit type',215,NULL,'GroupName',1,39729,0,0,0,NULL,0,0,49472)}
go
{CALL CT_ExportColumns(0,'Reserved',215,NULL,'blankfill',0,39730,1,6,6,NULL,0,50,32768)}
go
{CALL CT_ExportColumns(0,'Reserved',215,NULL,'blankfill',0,39731,1,14,14,NULL,0,60,32768)}
go
{CALL CT_ExportColumns(0,'FileFormat',215,NULL,'FileFormat',1,39732,1,0,0,NULL,0,5,16384)}
go
{CALL CT_ExportColumns(0,'ccvoid',59,'ccvoid','ssl_transaction_type',0,39733,1,0,0,NULL,0,0,128)}
go
{CALL CT_ExportColumns(0,'Merchant ID',59,NULL,'Merchant',1,39734,0,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Merchant',59,'$Merchant','ssl_merchant_id',0,39735,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'ccsale',59,'ccsale','ssl_transaction_type',0,39736,1,0,0,NULL,0,0,64)}
go
{CALL CT_ExportColumns(0,'ccreturn',59,'ccreturn','ssl_transaction_type',0,39737,1,0,0,NULL,0,0,256)}
go
{CALL CT_ExportColumns(0,'ccauthonly',59,'ccauthonly','ssl_transaction_type',0,39738,1,0,0,NULL,0,0,16)}
go
{CALL CT_ExportColumns(0,'cccomplete',59,'cccomplete','ssl_transaction_type',0,39739,1,0,0,NULL,0,0,32)}
go
{CALL CT_ExportColumns(0,'User ID',59,NULL,'Login',1,39740,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',59,'$Login','ssl_user_id',0,39741,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'PIN',59,NULL,'Password',1,39742,0,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'Password',59,'$Password','ssl_pin',0,39743,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',59,NULL,'ProcTransID',1,39744,0,0,0,NULL,0,4,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',59,'$ProcTransID','ssl_txn_id',0,39745,1,0,0,NULL,0,4,416)}
go
{CALL CT_ExportColumns(0,'Amount',59,NULL,'Amount',3,39746,0,0,0,NULL,0,5,336)}
go
{CALL CT_ExportColumns(0,'Amount',59,'$Amount','ssl_amount',0,39747,1,0,0,NULL,0,5,336)}
go
{CALL CT_ExportColumns(0,'ssl_show_form',59,'false','ssl_show_form',0,39748,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',59,NULL,'CardNumber',1,39749,0,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',59,'$CardNumber','ssl_card_number',0,39750,1,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'expmm',59,NULL,'expmm',1,39751,0,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'expyy',59,NULL,'expyy',1,39752,0,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'MMYY',59,'$expmm$expyy','ssl_exp_date',0,39753,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'Zip',59,NULL,'Zip',1,39754,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Zip',59,'$Zip','ssl_avs_zip',0,39755,1,9,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Address',59,NULL,'Address',1,39756,0,30,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'Address',59,'$Address','ssl_avs_address',0,39757,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',59,NULL,'SecurityCode',1,39758,0,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',59,'$SecurityCode','ssl_cvv2cvc2',0,39759,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'SecurityCodeInd',59,NULL,'SecurityCodeInd',2,39760,0,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'SecurityCodeInd',59,'$SecurityCodeInd','ssl_cvv2cvc2_indicator',0,39761,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'TransID',59,NULL,'TransID',2,39762,0,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'TransID',59,'$TransID','ssl_invoice_number',0,39763,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'ecspurchase',216,'ecspurchase','ssl_transaction_type',0,39764,1,0,0,NULL,0,0,64)}
go
{CALL CT_ExportColumns(0,'ecsvoid',216,'ecsvoid','ssl_transaction_type',0,39765,1,0,0,NULL,0,0,128)}
go
{CALL CT_ExportColumns(0,'Merchant ID',216,NULL,'Merchant',1,39766,0,0,0,NULL,0,1,192)}
go
{CALL CT_ExportColumns(0,'Merchant',216,'$Merchant','ssl_merchant_id',0,39767,1,0,0,NULL,0,1,192)}
go
{CALL CT_ExportColumns(0,'User ID',216,NULL,'Login',1,39768,0,0,0,NULL,0,2,192)}
go
{CALL CT_ExportColumns(0,'ssl_user_id',216,'$Login','Login',0,39769,1,0,0,NULL,0,2,192)}
go
{CALL CT_ExportColumns(0,'PIN',216,NULL,'Password',1,39770,0,0,0,NULL,0,3,192)}
go
{CALL CT_ExportColumns(0,'Password',216,'$Password','ssl_pin',0,39771,1,0,0,NULL,0,3,192)}
go
{CALL CT_ExportColumns(0,'BankNumber',216,NULL,'BankNumber',1,39772,0,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'BankNumber',216,'$BankNumber','ssl_aba_number',0,39773,1,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',216,NULL,'AccountNumber',1,39774,0,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'AccountNumber',216,'$AccountNumber','ssl_bank_account_number',0,39775,1,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'TEL',216,'TEL','ssl_ecs_product_code',0,39776,0,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,'BusinessAccount',216,NULL,'BusinessAccount',2,39777,0,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'BusinessAccount',216,'$BusinessAccount','ssl_bank_account_type',0,39778,1,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'Amount',216,NULL,'Amount',3,39779,0,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'Amount',216,'$Amount','ssl_amount',0,39780,1,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'FirstName',216,NULL,'FirstName',1,39781,0,20,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'FirstName',216,'$FirstName','ssl_first_name',0,39782,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'Company',216,NULL,'Company',1,39783,0,50,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'Company',216,'$Company','ssl_company',0,39784,1,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'DLNumber',216,NULL,'DLNumber',1,39785,0,0,0,NULL,0,11,64)}
go
{CALL CT_ExportColumns(0,'DLNumber',216,'$DLNumber','ssl_drivers_license_number',0,39786,1,0,0,NULL,0,11,64)}
go
{CALL CT_ExportColumns(0,'Phone',216,NULL,'Phone',1,39787,0,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'Phone',216,'$Phone','ssl_drivers_license_phone_number',0,39788,1,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'DLState',216,NULL,'DLState',1,39789,0,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'DLState',216,'$DLState','ssl_drivers_license_state',0,39790,1,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'TransID',216,NULL,'TransID',2,39791,0,0,0,NULL,0,14,192)}
go
{CALL CT_ExportColumns(0,'TransID',216,'$TransID','ieatransid',0,39792,2,0,0,NULL,0,14,192)}
go
{CALL CT_ExportColumns(0,'ssl_agree',216,'1','ssl_agree',0,39793,1,0,0,NULL,0,15,64)}
go
{CALL CT_ExportColumns(0,NULL,59,'ASCII','ssl_result_format',0,39794,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,NULL,216,'ASCII','ssl_result_format',0,39795,1,0,0,NULL,0,16,192)}
go
{CALL CT_ExportColumns(0,'TransID',59,'$TransID','ieatransid',0,39796,2,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,NULL,216,'false','ssl_show_form',0,39797,1,0,0,NULL,0,17,192)}
go
{CALL CT_ExportColumns(0,'LastName',216,'$LastName','ssl_last_name',0,39798,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'LastName',216,NULL,'LastName',1,39799,0,30,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'Gateway ID',60,NULL,'Login',1,39800,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Password',60,NULL,'Password',1,39801,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'CardNumber',60,NULL,'CardNumber',1,39802,1,0,0,NULL,0,3,80)}
go
{CALL CT_ExportColumns(0,'CardHolder',60,NULL,'CardHolder',1,39803,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'Address',60,NULL,'Address',1,39804,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'Zip',60,NULL,'Zip',1,39805,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'City',60,NULL,'City',1,39806,1,0,0,NULL,0,7,80)}
go
{CALL CT_ExportColumns(0,'State',60,NULL,'State',1,39807,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'Country2',60,NULL,'Country2',1,39808,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',60,NULL,'SecurityCode',1,39809,1,0,0,NULL,0,10,80)}
go
{CALL CT_ExportColumns(0,'expmm',60,NULL,'expmm',1,39810,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'expyy',60,NULL,'expyy',1,39811,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',60,NULL,'CurrencyCode',1,39812,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Amount',60,NULL,'Amount',3,39813,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',60,NULL,'CustomerID',2,39814,1,0,0,NULL,0,15,496)}
go
{CALL CT_ExportColumns(0,'TransID',60,NULL,'TransID',2,39815,1,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'PrevTransID',60,NULL,'PrevTransID',2,39816,1,0,0,NULL,0,17,416)}
go
{CALL CT_ExportColumns(0,'ProcTrans1',60,NULL,'ProcTrans1',1,39817,1,0,0,NULL,0,18,416)}
go
{CALL CT_ExportColumns(0,'ProcTrans2',60,NULL,'ProcTrans2',1,39818,1,0,0,NULL,0,19,416)}
go
{CALL CT_ExportColumns(0,'TransID',60,'$TransID','ieatransid',0,39819,2,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Content-Type',60,'application/xml; charset=UTF-8','Content-Type',0,39820,3,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'Accept',60,'application/xml','Accept',0,39821,3,0,0,NULL,0,21,496)}
go
{CALL CT_ExportColumns(0,'Email',60,NULL,'Email',1,39822,1,0,0,NULL,0,22,80)}
go
{CALL CT_ExportColumns(0,'FirstName',59,NULL,'FirstName',1,39823,0,20,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'FirstName',59,'$FirstName','ssl_first_name',0,39824,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'LastName',59,NULL,'LastName',1,39825,0,30,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'LastName',59,'$LastName','ssl_last_name',0,39826,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'XML Login',61,NULL,'Login',1,39828,1,0,0,NULL,0,0,448)}
go
{CALL CT_ExportColumns(0,'XML Password',61,NULL,'Password',1,39829,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'TransID',61,NULL,'TransID',2,39830,1,0,0,'0',0,2,448)}
go
{CALL CT_ExportColumns(0,'CardNumber',61,NULL,'CardNumber',1,39831,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'expmm',61,NULL,'expmm',1,39832,1,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'expyyyy',61,NULL,'expyyyy',1,39833,1,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'SecurityCode',61,NULL,'SecurityCode',1,39834,1,0,0,NULL,0,6,64)}
go
{CALL CT_ExportColumns(0,'CardHolder',61,NULL,'CardHolder',1,39835,1,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'Amount',61,NULL,'Amount',4,39836,1,0,0,NULL,0,8,320)}
go
{CALL CT_ExportColumns(0,'Address',61,NULL,'Address',1,39837,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'City',61,NULL,'City',1,39838,1,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'Zip',61,NULL,'Zip',1,39839,1,0,0,NULL,0,11,64)}
go
{CALL CT_ExportColumns(0,'Country2',61,NULL,'Country2',1,39840,1,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'Phone',61,NULL,'Phone',1,39841,1,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'Email',61,NULL,'Email',1,39842,1,0,0,NULL,0,14,64)}
go
{CALL CT_ExportColumns(0,'CustomerID',61,NULL,'CustomerID',2,39843,1,0,0,NULL,0,15,64)}
go
{CALL CT_ExportColumns(0,'WorldPayType',61,NULL,'WorldPayType',1,39845,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'Installation ID',61,NULL,'Terminal',1,39849,1,0,0,NULL,0,18,64)}
go
{CALL CT_ExportColumns(0,'Merchant Code',61,NULL,'Merchant',1,39850,1,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',61,NULL,'CurrencyCode',1,39851,1,0,0,NULL,0,20,320)}
go
{CALL CT_ExportColumns(0,'Content-Type',61,'text/xml','Content-Type',0,39852,3,0,0,NULL,0,17,448)}
go
{CALL CT_ExportColumns(0,'TransID',61,'$TransID','ieatransid',0,39853,2,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'State',61,NULL,'State',1,39854,1,0,0,NULL,0,21,64)}
go
{CALL CT_ExportColumns(0,'Result format',300,'json','format',0,39855,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'locator version',300,'Public_AR_Current','benchmark',0,39856,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Address1',300,NULL,'Address1',1,39857,0,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'Address1',300,'$Address1','street',0,39858,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'City',300,NULL,'city',1,39859,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'State',300,NULL,'state',1,39860,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'geocoding response',300,'locations','returntype',0,39861,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'zip',300,NULL,'zip',1,39862,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,NULL,300,NULL,'AddressID',2,39863,2,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'GET',300,'GET','GET',0,39864,5,0,0,NULL,0,9,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',301,NULL,'AddressID',2,39865,2,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Address1',301,NULL,'Address1',1,39866,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Address1',301,'$Address1','Address',0,39867,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'State Abbreviation',301,NULL,'Abbreviation',1,39868,0,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'State',301,'$State','State',0,39869,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'City',301,NULL,'City',1,39870,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'Zip',301,NULL,'Zip',1,39871,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'Auth Key',301,NULL,'Password',1,39872,0,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Password',301,'$Password','AuthKey',0,39873,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Authentication Code',302,NULL,'Password',1,39874,0,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Password',302,'$Password','auth',0,39875,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Address1',302,NULL,'Address1',1,39876,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'City',302,NULL,'City',1,39877,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'State',302,NULL,'State',1,39878,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Zip',302,NULL,'Zip',1,39879,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Location',302,'$Address1, $City $State $Zip','locate',0,39880,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'The output type desired',302,'XML','geoit',0,39881,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',302,NULL,'AddressID',2,39882,0,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',302,'$AddressID','id',0,39883,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'API Key',303,NULL,'Password',1,39884,0,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Password',303,'$Password','apikey',0,39885,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'output format',303,'XML','format',0,39886,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'include census',303,'false','census',0,39887,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'API version',303,'4.01','version',0,39888,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'not store details /w acct',303,'false','notStore',0,39889,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'Address1',303,NULL,'Address1',1,39890,0,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Address1',303,'$Address1','streetAddress',0,39891,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'city',303,NULL,'city',1,39892,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'state',303,NULL,'state',1,39893,1,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'zip',303,NULL,'zip',1,39894,1,0,0,NULL,0,9,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',303,NULL,'AddressID',2,39895,2,0,0,NULL,0,10,1024)}
go
{CALL CT_ExportColumns(0,'Bing Maps Key',304,NULL,'Password',1,39896,0,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Password',304,'$Password','key',0,39897,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'output format',304,'xml','o',0,39898,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Country',304,NULL,'Abbr2',1,39899,0,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'Country',304,'$Abbr2','CountryRegion',0,39900,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'State',304,NULL,'State',1,39901,0,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'State',304,'$State','adminDistrict',0,39902,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'City',304,NULL,'City',1,39903,0,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'City',304,'$City','locality',0,39904,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'Zip',304,NULL,'Zip',1,39905,0,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Zip',304,'$Zip','postalCode',0,39906,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Address1',304,NULL,'Address1',1,39907,0,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'Address1',304,'$Address1','addressLine',0,39908,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',304,NULL,'AddressID',2,39909,2,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'output format',305,'xml','format',0,39910,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'User Agent',305,'Emerald Management Suite REV3','User-Agent',0,39911,3,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Address1',305,NULL,'Address1',1,39912,0,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'Address1',305,'$Address1','street',0,39913,1,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,'city',305,NULL,'city',1,39914,1,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,'state',305,NULL,'state',1,39915,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'Country',305,NULL,'Abbr2',1,39916,0,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Country',305,'$Abbr2','country',0,39917,1,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'Zip',305,NULL,'Zip',1,39918,0,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'Zip',305,'$Zip','postalcode',0,39919,1,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'AddressID',305,NULL,'AddressID',2,39920,2,0,0,NULL,0,8,1024)}
go
{CALL CT_ExportColumns(0,'GET',305,'GET','GET',0,39921,5,0,0,NULL,0,9,1024)}
go
{CALL CT_ExportColumns(0,'PrevTransID',61,NULL,'PrevTransID',2,39922,1,0,0,NULL,0,22,384)}
go
{CALL CT_ExportColumns(0,'sale',62,'sale','type',0,39923,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'auth',62,'auth','type',0,39924,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'credit',62,'credit','type',0,39925,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'capture',62,'capture','type',0,39926,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'void',62,'void','type',0,39927,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Username',62,NULL,'Login',1,39928,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',62,'$Login','username',0,39929,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',62,NULL,'password',1,39930,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'email',62,NULL,'email',1,39931,1,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'expmm',62,NULL,'expmm',1,39932,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'expyy',62,NULL,'expyy',1,39933,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'mmyy',62,'$expmm$expyy','ccexp',0,39934,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'phone',62,NULL,'phone',1,39935,1,0,0,NULL,0,19,80)}
go
{CALL CT_ExportColumns(0,'firstname',62,NULL,'firstname',1,39936,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'lastname',62,NULL,'lastname',1,39937,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'state2',62,NULL,'state2',1,39938,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'state2',62,'$state2','state',0,39939,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'city',62,NULL,'city',1,39940,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Country2',62,NULL,'Country2',1,39941,0,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'Country2',62,'$country2','country',0,39942,1,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',62,NULL,'CardNumber',1,39943,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'CardNumber',62,'$CardNumber','ccnumber',0,39944,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',62,NULL,'SecurityCode',1,39945,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'SecurityCode',62,'$SecurityCode','cvv',0,39946,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Amount',62,NULL,'amount',3,39947,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',62,NULL,'CurrencyCode',1,39948,0,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',62,'$CurrencyCode','currency',0,39949,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'Processor ID',62,NULL,'Merchant',1,39950,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Merchant',62,'$Merchant','processor_id',0,39951,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'TransID',62,NULL,'TransID',2,39952,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'TransID',62,'$TransID','orderid',0,39953,1,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'TransID',62,'$TransID','ieatransid',0,39954,2,0,0,NULL,0,10,384)}
go
{CALL CT_ExportColumns(0,'company',62,NULL,'company',1,39955,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'Address',62,NULL,'Address',1,39956,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Address',62,'$Address','address1',0,39957,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'zip',62,NULL,'zip',1,39958,1,0,0,NULL,0,17,80)}
go
{CALL CT_ExportColumns(0,'transactionid',62,NULL,'ProcTransID',1,39959,0,0,0,NULL,0,20,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',62,'$ProcTransID','transactionid',0,39960,1,0,0,NULL,0,20,416)}
go
{CALL CT_ExportColumns(0,'sale',217,'sale','type',0,39961,1,0,0,NULL,0,1,64)}
go
{CALL CT_ExportColumns(0,'auth',217,'auth','type',0,39962,1,0,0,NULL,0,1,16)}
go
{CALL CT_ExportColumns(0,'credit',217,'credit','type',0,39963,1,0,0,NULL,0,1,256)}
go
{CALL CT_ExportColumns(0,'capture',217,'capture','type',0,39964,1,0,0,NULL,0,1,32)}
go
{CALL CT_ExportColumns(0,'void',217,'void','type',0,39965,1,0,0,NULL,0,1,128)}
go
{CALL CT_ExportColumns(0,'Username',217,NULL,'Login',1,39966,0,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Login',217,'$Login','username',0,39967,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'Password',217,NULL,'password',1,39968,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'email',217,NULL,'email',1,39969,1,0,0,NULL,0,20,80)}
go
{CALL CT_ExportColumns(0,'BankNumber',217,NULL,'BankNumber',1,39970,0,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'BankNumber',217,'$BankNumber','checkaba',0,39971,1,0,0,NULL,0,5,80)}
go
{CALL CT_ExportColumns(0,'phone',217,NULL,'phone',1,39972,1,0,0,NULL,0,19,80)}
go
{CALL CT_ExportColumns(0,'firstname',217,NULL,'firstname',1,39973,1,0,0,NULL,0,11,80)}
go
{CALL CT_ExportColumns(0,'lastname',217,NULL,'lastname',1,39974,1,0,0,NULL,0,12,80)}
go
{CALL CT_ExportColumns(0,'state2',217,NULL,'state2',1,39975,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'state2',217,'$state2','state',0,39976,1,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'city',217,NULL,'city',1,39977,1,0,0,NULL,0,15,80)}
go
{CALL CT_ExportColumns(0,'Country2',217,NULL,'Country2',1,39978,0,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'Country2',217,'$country2','country',0,39979,1,0,0,NULL,0,18,80)}
go
{CALL CT_ExportColumns(0,'AccountHolder',217,NULL,'AccountHolder',1,39980,0,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'AccountHolder',217,'$AccountHolder','checkname',0,39981,1,0,0,NULL,0,4,80)}
go
{CALL CT_ExportColumns(0,'AccountNumber',217,NULL,'AccountNumber',1,39982,0,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'AccountNumber',217,'$AccountNumber','checkaccount',0,39983,1,0,0,NULL,0,6,80)}
go
{CALL CT_ExportColumns(0,'Amount',217,NULL,'amount',3,39984,1,0,0,NULL,0,7,368)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',217,NULL,'CurrencyCode',1,39985,0,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',217,'$CurrencyCode','currency',0,39986,1,0,0,NULL,0,8,80)}
go
{CALL CT_ExportColumns(0,'Processor ID',217,NULL,'Merchant',1,39987,0,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'Merchant',217,'$Merchant','processor_id',0,39988,1,0,0,NULL,0,9,80)}
go
{CALL CT_ExportColumns(0,'TransID',217,NULL,'TransID',2,39989,0,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'TransID',217,'$TransID','orderid',0,39990,1,0,0,NULL,0,10,112)}
go
{CALL CT_ExportColumns(0,'TransID',217,'$TransID','ieatransid',0,39991,2,0,0,NULL,0,10,384)}
go
{CALL CT_ExportColumns(0,'company',217,NULL,'company',1,39992,1,0,0,NULL,0,13,80)}
go
{CALL CT_ExportColumns(0,'Address',217,NULL,'Address',1,39993,0,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'Address',217,'$Address','address1',0,39994,1,0,0,NULL,0,14,80)}
go
{CALL CT_ExportColumns(0,'zip',217,NULL,'zip',1,39995,1,0,0,NULL,0,17,80)}
go
{CALL CT_ExportColumns(0,'transactionid',217,NULL,'ProcTransID',1,39996,0,0,0,NULL,0,20,416)}
go
{CALL CT_ExportColumns(0,'ProcTransID',217,'$ProcTransID','transactionid',0,39997,1,0,0,NULL,0,20,416)}
go
{CALL CT_ExportColumns(0,'personal',217,'personal','account_holder_type',0,39998,1,0,0,NULL,0,21,80)}
go
{CALL CT_ExportColumns(0,'BankTransType',217,NULL,'BankTransType',1,39999,0,0,0,NULL,0,22,80)}
go
{CALL CT_ExportColumns(0,'BankTransType',217,'$BankTransType','account_type',0,40000,1,0,0,NULL,0,22,80)}
go
{CALL CT_ExportColumns(0,'SEC Code (PPD,WEB,TEL or CCD)',217,NULL,'Store',1,40001,0,0,0,NULL,0,23,80)}
go
{CALL CT_ExportColumns(0,'Store',217,'$Store','sec_code',0,40002,1,0,0,NULL,0,23,80)}
go
{CALL CT_ExportColumns(0,'check',217,'check','payment',0,40003,1,0,0,NULL,0,24,80)}
go
{CALL CT_ExportColumns(0,'creditcard',62,'creditcard','payment',0,40004,1,0,0,NULL,0,21,80)}
go
{CALL CT_ExportColumns(0,'SSN',217,NULL,'SSN',1,40005,0,0,0,NULL,0,25,80)}
go
{CALL CT_ExportColumns(0,'DLNumber',217,NULL,'DLNumber',1,40006,0,0,0,NULL,0,26,80)}
go
{CALL CT_ExportColumns(0,'SSN',217,'$SSN','social_security_number',0,40007,1,0,0,NULL,0,25,80)}
go
{CALL CT_ExportColumns(0,'DLNumber',217,'$DLNumber','drivers_license_number',0,40008,1,0,0,NULL,0,26,80)}
go
{CALL CT_ExportColumns(0,'birthyyyy',217,NULL,'birthyyyy',1,40009,0,0,0,NULL,0,27,80)}
go
{CALL CT_ExportColumns(0,'birthmm',217,NULL,'birthmm',1,40010,0,0,0,NULL,0,27,80)}
go
{CALL CT_ExportColumns(0,'birthdd',217,NULL,'birthdd',1,40011,0,0,0,NULL,0,27,80)}
go
{CALL CT_ExportColumns(0,'YYYYMMDD',217,'$birthyyyy$birthmm$birthdd','drivers_license_dob',0,40012,1,0,0,NULL,0,27,80)}
go
{CALL CT_ExportColumns(0,'DLState',217,NULL,'DLState',1,40013,0,0,0,NULL,0,28,80)}
go
{CALL CT_ExportColumns(0,'DLState',217,'$DLState','drivers_license_state',0,40014,1,0,0,NULL,0,28,80)}
go
{CALL CT_ExportColumns(0,'ExternalSyncID',1022,NULL,'ExternalSyncID',1,40015,2,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'API Login',1022,NULL,'APILogin',1,40016,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'API Password',1022,NULL,'APIPassword',1,40017,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'API Reference',1022,NULL,'APIRef',1,40018,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'ESAT Reference',1022,NULL,'ESRef',1,40019,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Aux1',1022,NULL,'Aux1',1,40020,2,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Status',1022,NULL,'Status',1,40021,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Recurring',1022,NULL,'Recurring',2,40022,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Cancel Date',1022,NULL,'CancelDate',1,40023,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Cancel Reason',1022,NULL,'CancelReason',1,40024,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Region',1022,NULL,'Region',1,40025,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Payment Method',1022,NULL,'PayMethod',1,40026,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Billing Group',1022,NULL,'GroupName',1,40027,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Send Method',1022,NULL,'SendMethod',1,40028,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Billing Cycle',1022,NULL,'BillingCycle',1,40029,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'PIN',1022,NULL,'PIN',1,40030,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'MBR External Reference',1022,NULL,'MBRExternalRef',1,40031,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Login',1022,NULL,'Login',1,40032,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Password',1022,NULL,'Password',1,40033,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Type',1022,NULL,'AccountType',1,40034,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'PayPeriod',1022,NULL,'PayPeriod',1,40035,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Extension',1022,NULL,'Extension',2,40036,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'SalesPerson',1022,NULL,'SalesPerson',1,40037,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Remote Access',1022,NULL,'RemoteAccess',1,40038,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'LoginLimit',1022,NULL,'LoginLimit',1,40039,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Domain',1022,NULL,'Domain',1,40040,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Tower',1022,NULL,'Tower',1,40041,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Country',1022,NULL,'BillCountry',1,40042,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Country2',1022,NULL,'BillCountry2',1,40043,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill State',1022,NULL,'BillState',1,40044,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill State2',1022,NULL,'BillState2',1,40045,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Company',1022,NULL,'BillCompany',1,40046,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Address1',1022,NULL,'BillAddress1',1,40047,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Address2',1022,NULL,'BillAddress2',1,40048,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill City',1022,NULL,'BillCity',1,40049,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Zip',1022,NULL,'BillZip',1,40050,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill First Name',1022,NULL,'BillFirstName',1,40051,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Last Name',1022,NULL,'BillLastName',1,40052,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Home Phone',1022,NULL,'BillPhoneHome',1,40053,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Work Phone',1022,NULL,'BillPhoneWork',1,40054,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Mobile Phone',1022,NULL,'BillPhoneMobile',1,40055,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Email',1022,NULL,'BillEmail',1,40056,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Latitude',1022,NULL,'BillLat',1,40057,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Bill Longitude',1022,NULL,'BillLong',1,40058,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Country',1022,NULL,'ServiceCountry',1,40059,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Country2',1022,NULL,'ServiceCountry2',1,40060,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service State',1022,NULL,'ServiceState',1,40061,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service State2',1022,NULL,'ServiceState2',1,40062,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Company',1022,NULL,'ServiceCompany',1,40063,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Address1',1022,NULL,'ServiceAddress1',1,40064,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Address2',1022,NULL,'ServiceAddress2',1,40065,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service City',1022,NULL,'ServiceCity',1,40066,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Zip',1022,NULL,'ServiceZip',1,40067,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service First Name',1022,NULL,'ServiceFirstName',1,40068,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Last Name',1022,NULL,'ServiceLastName',1,40069,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Home Phone',1022,NULL,'ServicePhoneHome',1,40070,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Work Phone',1022,NULL,'ServicePhoneWork',1,40071,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Mobile Phone',1022,NULL,'ServicePhoneMobile',1,40072,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Email',1022,NULL,'ServiceEmail',1,40073,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Latitude',1022,NULL,'ServiceLat',1,40074,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Service Longitude',1022,NULL,'ServiceLong',1,40075,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Country',1022,NULL,'ContactCountry',1,40076,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Country2',1022,NULL,'ContactCountry2',1,40077,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact State',1022,NULL,'ContactState',1,40078,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact State2',1022,NULL,'ContactState2',1,40079,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Company',1022,NULL,'ContactCompany',1,40080,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Address1',1022,NULL,'ContactAddress1',1,40081,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Address2',1022,NULL,'ContactAddress2',1,40082,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact City',1022,NULL,'ContactCity',1,40083,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Zip',1022,NULL,'ContactZip',1,40084,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact First Name',1022,NULL,'ContactFirstName',1,40085,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Last Name',1022,NULL,'ContactLastName',1,40086,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Home Phone',1022,NULL,'ContactPhoneHome',1,40087,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Work Phone',1022,NULL,'ContactPhoneWork',1,40088,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Mobile Phone',1022,NULL,'ContactPhoneMobile',1,40089,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Email',1022,NULL,'ContactEmail',1,40090,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Latitude',1022,NULL,'ContactLat',1,40091,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Contact Longitude',1022,NULL,'ContactLong',1,40092,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Action',1022,'add','action',0,40093,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,'Action',1022,'modify','action',0,40094,1,0,0,NULL,0,2,2048)}
go
{CALL CT_ExportColumns(0,'Action',1022,'delete','action',0,40095,1,0,0,NULL,0,2,4096)}
go
{CALL CT_ExportColumns(0,'CustomerID',1022,NULL,'CustomerID',2,40096,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'AccountID',1022,NULL,'AccountID',2,40097,1,0,0,NULL,0,1,7168)}
go
{CALL CT_ExportColumns(0,'Delay',305,'1800','Delay',0,40098,6,0,0,NULL,0,10,1024)}
go
{CALL CT_ExportColumns(0,'Delay',300,'2000','Delay',0,40099,6,0,0,NULL,0,10,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',300,NULL,'SessionRef',1,40100,2,0,0,NULL,0,11,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',303,NULL,'SessionRef',1,40101,2,0,0,NULL,0,11,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',305,NULL,'SessionRef',1,40102,2,0,0,NULL,0,11,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',301,NULL,'SessionRef',1,40103,2,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',302,NULL,'SessionRef',1,40104,2,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,'Session Reference',304,NULL,'SessionRef',1,40105,2,0,0,NULL,0,9,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,'false','sensor',0,40106,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'Address1',1,40107,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'City',1,40108,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'State',1,40109,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'Zip',1,40110,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'AddressID',2,40111,2,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,NULL,'SessionRef',1,40112,2,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,'$Address1, $City, $State, $Zip','address',0,40113,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,'GET','GET',0,40114,5,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,NULL,306,'100','Delay',0,40115,6,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,'GET',304,'GET','GET',0,40116,5,0,0,NULL,0,10,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'en','lang',0,40117,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'Address1',1,40118,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'City',1,40119,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'State',1,40120,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'Zip',1,40121,0,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'AddressID',2,40122,2,0,0,NULL,0,3,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'SessionRef',1,40123,2,0,0,NULL,0,4,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'$Address1, $City, $State, $Zip','addr',0,40124,1,0,0,NULL,0,2,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'GET','GET',0,40125,5,0,0,NULL,0,6,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'300','Delay',0,40126,6,0,0,NULL,0,7,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,NULL,'Abbr2',1,40127,0,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'$Abbr2','country',0,40128,1,0,0,NULL,0,5,1024)}
go
{CALL CT_ExportColumns(0,NULL,307,'1','count',0,40129,1,0,0,NULL,0,1,1024)}
go
{CALL CT_ExportColumns(0,'Terminal ID',63,NULL,'Login',1,40130,1,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'Password',63,NULL,'Password',1,40131,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(1,'TransID',63,NULL,'TransID',2,40132,1,0,0,'0',0,2,496)}
go
{CALL CT_ExportColumns(0,'Token',63,NULL,'Token',1,40133,1,0,0,NULL,0,3,496)}
go
{CALL CT_ExportColumns(0,'CardHolder',63,NULL,'CardHolder',1,40134,1,0,0,NULL,0,7,496)}
go
{CALL CT_ExportColumns(0,'Amount',63,NULL,'Amount',4,40135,1,0,0,NULL,0,8,496)}
go
{CALL CT_ExportColumns(0,'Address',63,NULL,'Address',1,40136,1,0,0,NULL,0,9,496)}
go
{CALL CT_ExportColumns(0,'City',63,NULL,'City',1,40137,1,0,0,NULL,0,10,496)}
go
{CALL CT_ExportColumns(0,'Zip',63,NULL,'Zip',1,40138,1,0,0,NULL,0,11,496)}
go
{CALL CT_ExportColumns(0,'Country3',63,NULL,'Country3',1,40139,1,0,0,NULL,0,12,496)}
go
{CALL CT_ExportColumns(0,'Phone',63,NULL,'Phone',1,40140,1,0,0,NULL,0,13,496)}
go
{CALL CT_ExportColumns(0,'Email',63,NULL,'Email',1,40141,1,0,0,NULL,0,14,496)}
go
{CALL CT_ExportColumns(0,'ApproveCode',63,NULL,'ApproveCode',1,40142,1,0,0,NULL,0,15,32)}
go
{CALL CT_ExportColumns(0,'TransID',63,'$TransID','ieatransid',0,40143,2,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'zero pad',63,'000000000000000000','zero',0,40144,0,0,0,NULL,0,16,496)}
go
{CALL CT_ExportColumns(0,'18-digit transid (auth)',63,'$TransID$zero','TransactionID',0,40145,1,18,18,NULL,0,2,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',63,NULL,'ProcTransID',1,40146,1,0,0,NULL,0,17,416)}
go
{CALL CT_ExportColumns(0,'18-digit transid (ref)',63,'$ProcTransID','TransactionID',0,40147,1,0,0,NULL,0,2,416)}
go
{CALL CT_ExportColumns(0,'Origin (RECURRING,BILL PAYMENT, INTERNET, PHONE ORDER)',63,NULL,'Terminal',1,40148,1,0,0,NULL,0,18,496)}
go
{CALL CT_ExportColumns(0,'XML Login',64,NULL,'Login',1,40149,1,0,0,NULL,0,0,448)}
go
{CALL CT_ExportColumns(0,'XML Password',64,NULL,'Password',1,40150,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'TransID',64,NULL,'TransID',2,40151,1,0,0,'0',0,2,448)}
go
{CALL CT_ExportColumns(0,'Token',64,NULL,'Token',1,40152,1,0,0,NULL,0,3,64)}
go
{CALL CT_ExportColumns(0,'Amount',64,NULL,'Amount',4,40153,1,0,0,NULL,0,8,320)}
go
{CALL CT_ExportColumns(0,'Email',64,NULL,'Email',1,40154,1,0,0,NULL,0,14,64)}
go
{CALL CT_ExportColumns(0,'CustomerID',64,NULL,'CustomerID',2,40155,1,0,0,NULL,0,15,64)}
go
{CALL CT_ExportColumns(0,'Installation ID',64,NULL,'Terminal',1,40156,1,0,0,NULL,0,18,64)}
go
{CALL CT_ExportColumns(0,'Merchant Code',64,NULL,'Merchant',1,40157,1,0,0,NULL,0,19,448)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',64,NULL,'CurrencyCode',1,40158,1,0,0,NULL,0,20,320)}
go
{CALL CT_ExportColumns(0,'Content-Type',64,'text/xml','Content-Type',0,40159,3,0,0,NULL,0,17,448)}
go
{CALL CT_ExportColumns(0,'TransID',64,'$TransID','ieatransid',0,40160,2,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'PrevTransID',64,NULL,'PrevTransID',2,40161,1,0,0,NULL,0,22,384)}
go
{CALL CT_ExportColumns(0,'AutoBill',53,NULL,'AutoBill',2,40162,0,0,0,NULL,0,22,496)}
go
{CALL CT_ExportColumns(0,'AutoBill',53,'$AutoBill','recurringPayment',0,40163,1,0,0,NULL,0,22,496)}
go
{CALL CT_ExportColumns(0,'CVAutoBill',59,NULL,'CVAutoBill',1,40164,0,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'CVAutoBill',59,'$CVAutoBill','ssl_recurring_flag',0,40165,7,0,0,NULL,0,16,80)}
go
{CALL CT_ExportColumns(0,'ProcTransID',216,NULL,'ProcTransID',1,40166,0,0,0,NULL,0,18,128)}
go
{CALL CT_ExportColumns(0,'ProcTransID',216,'$ProcTransID','ssl_txn_id',0,40167,1,0,0,NULL,0,18,128)}
go
{CALL CT_ExportColumns(0,'WorldPayDIT',61,NULL,'WorldPayDIT',1,40168,1,0,0,NULL,0,23,64)}
go
{CALL CT_ExportColumns(0,'WorldPayDIT',64,NULL,'WorldPayDIT',1,40169,1,0,0,NULL,0,23,64)}
go
{CALL CT_ExportColumns(0,'XML Login',218,NULL,'Login',1,40170,1,0,0,NULL,0,0,448)}
go
{CALL CT_ExportColumns(0,'XML Password',218,NULL,'Password',1,40171,1,0,0,NULL,0,1,448)}
go
{CALL CT_ExportColumns(0,'TransID',218,NULL,'TransID',2,40172,1,0,0,NULL,0,2,448)}
go
{CALL CT_ExportColumns(0,'currencyCode',218,NULL,'CurrencyCode',1,40173,1,0,0,NULL,0,4,320)}
go
{CALL CT_ExportColumns(0,'merchantCode',218,NULL,'Merchant',1,40174,1,0,0,NULL,0,5,448)}
go
{CALL CT_ExportColumns(0,'Amount',218,NULL,'Amount',4,40175,1,0,0,NULL,0,6,320)}
go
{CALL CT_ExportColumns(0,'firstName',218,NULL,'FirstName',1,40176,1,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'lastName',218,NULL,'LastName',1,40177,1,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'address1',218,NULL,'Address',1,40178,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'postalCode',218,NULL,'Zip',1,40179,1,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'city',218,NULL,'City',1,40180,1,0,0,NULL,0,11,64)}
go
{CALL CT_ExportColumns(0,'state',218,NULL,'State2',1,40181,1,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'countryCode',218,NULL,'Country2',1,40182,1,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'bankAccountType',218,NULL,'BankTransTypeWP',1,40183,1,0,0,NULL,0,14,64)}
go
{CALL CT_ExportColumns(0,'accountNumber',218,NULL,'AccountNumber',1,40184,1,0,0,NULL,0,15,64)}
go
{CALL CT_ExportColumns(0,'routingNumber',218,NULL,'BankNumber',1,40185,1,0,0,NULL,0,16,64)}
go
{CALL CT_ExportColumns(0,'companyName',218,NULL,'Company',1,40186,1,0,0,NULL,0,17,64)}
go
{CALL CT_ExportColumns(0,'shopperEmailAddress',218,NULL,'Email',1,40187,1,0,0,NULL,0,18,64)}
go
{CALL CT_ExportColumns(0,'shopperAccountNumber',218,NULL,'CustomerID',2,40188,1,0,0,NULL,0,19,64)}
go
{CALL CT_ExportColumns(0,'PrevTransID',218,NULL,'PrevTransID',2,40189,1,0,0,NULL,0,20,384)}
go
{CALL CT_ExportColumns(0,'TransID',218,'$TransID','ieatransid',0,40190,2,0,0,NULL,0,3,448)}
go
{CALL CT_ExportColumns(0,'expmm',64,NULL,'expmm',1,40191,1,0,0,NULL,0,4,64)}
go
{CALL CT_ExportColumns(0,'expyyyy',64,NULL,'expyyyy',1,40192,1,0,0,NULL,0,5,64)}
go
{CALL CT_ExportColumns(0,'CardHolder',64,NULL,'CardHolder',1,40193,1,0,0,NULL,0,7,64)}
go
{CALL CT_ExportColumns(0,'Address',64,NULL,'Address',1,40194,1,0,0,NULL,0,9,64)}
go
{CALL CT_ExportColumns(0,'City',64,NULL,'City',1,40195,1,0,0,NULL,0,10,64)}
go
{CALL CT_ExportColumns(0,'Zip',64,NULL,'Zip',1,40196,1,0,0,NULL,0,11,64)}
go
{CALL CT_ExportColumns(0,'Country2',64,NULL,'Country2',1,40197,1,0,0,NULL,0,12,64)}
go
{CALL CT_ExportColumns(0,'Phone',64,NULL,'Phone',1,40198,1,0,0,NULL,0,13,64)}
go
{CALL CT_ExportColumns(0,'State',64,NULL,'State',1,40199,1,0,0,NULL,0,21,64)}
go
{CALL CT_ExportColumns(0,'File header',219,'1','RecordType',0,40200,1,1,1,NULL,0,10,134217728)}
go
{CALL CT_ExportColumns(0,'Batch header',219,'5','RecordType',0,40201,1,1,1,NULL,0,10,16384)}
go
{CALL CT_ExportColumns(0,'Detail record',219,'6','RecordType',0,40202,1,1,1,NULL,0,10,320)}
go
{CALL CT_ExportColumns(0,'Batch trailer',219,'7','RecordType',0,40203,1,1,1,NULL,0,10,32768)}
go
{CALL CT_ExportColumns(0,'File trailer',219,'9','RecordType',0,40204,1,1,1,NULL,0,10,268435456)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40205,1,2,2,NULL,0,20,134217728)}
go
{CALL CT_ExportColumns(0,'Credit',219,'C','CreditDebit',0,40206,1,1,1,NULL,0,20,256)}
go
{CALL CT_ExportColumns(0,'Debit',219,'D','CreditDebit',0,40207,1,1,1,NULL,0,20,64)}
go
{CALL CT_ExportColumns(1,'CPA',219,NULL,'CPA',1,40208,1,3,3,'0',0,20,32768)}
go
{CALL CT_ExportColumns(1,'Batch count',219,'1','BatchCount',0,40209,1,6,6,'0',0,20,268435456)}
go
{CALL CT_ExportColumns(1,'Originator',219,NULL,'Originator',1,40210,0,0,0,'0',0,30,134217728)}
go
{CALL CT_ExportColumns(1,'Transaction code',219,NULL,'CPA',1,40211,1,3,3,'0',0,30,16384)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40212,1,1,1,NULL,0,30,320)}
go
{CALL CT_ExportColumns(1,'Batch entry count',219,NULL,'TranCnt',2,40213,1,6,6,'0',0,30,32768)}
go
{CALL CT_ExportColumns(1,'Detail count',219,NULL,'TranCnt',2,40214,1,6,6,'0',0,30,268435456)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40215,1,5,5,NULL,0,40,134217728)}
go
{CALL CT_ExportColumns(0,'Payment sundry information',219,NULL,'Filler',0,40216,1,10,10,NULL,0,40,16384)}
go
{CALL CT_ExportColumns(1,'Bank ID and transit number',219,NULL,'BankNumber',1,40217,1,9,9,'0',0,40,320)}
go
{CALL CT_ExportColumns(1,'Reserved',219,NULL,'Filler',0,40218,1,10,10,'0',0,40,32768)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40219,1,67,67,NULL,0,40,268435456)}
go
{CALL CT_ExportColumns(1,'Originator number',219,'$Originator','Orig2',0,40220,1,10,10,'0',0,50,134217728)}
go
{CALL CT_ExportColumns(1,'Value date',219,NULL,'FileDate',1,40221,1,6,6,'0',0,50,16384)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40222,1,20,20,NULL,0,50,32768)}
go
{CALL CT_ExportColumns(1,'File creation date',219,NULL,'FileDate',1,40223,1,6,6,'0',0,60,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40224,1,14,14,NULL,0,60,16384)}
go
{CALL CT_ExportColumns(0,'Receiver account number',219,NULL,'AccountNumber',1,40225,1,12,12,NULL,0,60,320)}
go
{CALL CT_ExportColumns(1,'Entry dollar amount',219,NULL,'TranSum',4,40226,1,12,12,'0',0,60,32768)}
go
{CALL CT_ExportColumns(1,'File creation number',219,NULL,'FileNumber',2,40227,1,4,4,'0',0,70,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40228,1,5,5,NULL,0,70,320)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40229,1,28,28,NULL,0,70,32768)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40230,1,1,1,NULL,0,80,134217728)}
go
{CALL CT_ExportColumns(1,'Amount',219,NULL,'Amount',4,40231,1,10,10,'0',0,80,320)}
go
{CALL CT_ExportColumns(1,'Institution and branch transit',219,NULL,'FIN',1,40232,1,9,9,'0',0,90,134217728)}
go
{CALL CT_ExportColumns(0,'Cross reference number',219,NULL,'ExternalTransID',2,40233,1,13,13,NULL,0,90,320)}
go
{CALL CT_ExportColumns(0,'Receiver name',219,NULL,'AuthName',1,40234,1,22,22,NULL,0,100,320)}
go
{CALL CT_ExportColumns(0,'Account number',219,NULL,'CIBCAcct',1,40235,1,12,12,NULL,0,110,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40236,1,6,6,NULL,0,110,320)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40237,1,2,2,NULL,0,120,134217728)}
go
{CALL CT_ExportColumns(0,'Originators short name',219,NULL,'ShortName',1,40238,1,15,15,NULL,0,130,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40239,1,1,1,NULL,0,140,134217728)}
go
{CALL CT_ExportColumns(0,'Currency indicator',219,NULL,'Currency',1,40240,1,3,3,NULL,0,150,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40241,1,4,4,NULL,0,160,134217728)}
go
{CALL CT_ExportColumns(0,'Filler',219,NULL,'Filler',0,40242,1,46,46,NULL,0,20,16384)}
go
{CALL CT_ExportColumns(0,'Originator - Debit # (10 digit)',219,NULL,'BatchAux2',11,40243,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(0,'Company Short Name (15 chars max)',219,NULL,'Merchant',11,40244,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(0,'CPA Code (3 digit)',219,NULL,'BatchAux1',11,40245,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(0,'CIBC Account # (7 digit)',219,NULL,'Store',11,40246,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(0,'Financial Institution # (9 digits)',219,NULL,'Terminal',11,40247,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(1,'Destination data center',219,'$Originator','Orig1',0,40248,1,5,5,'0',0,30,134217728)}
go
{CALL CT_ExportColumns(0,'Originator - Credit # (10 digit)',219,NULL,'BatchAux3',11,40249,0,0,0,NULL,0,0,0)}
go
{CALL CT_ExportColumns(0,'Credit or debit',219,NULL,'GroupName',1,40250,0,0,0,NULL,0,0,134217728)}
go
{CALL CT_ExportColumns(0,'Batch number',219,NULL,'GroupID',2,40251,0,0,0,NULL,0,0,134217728)}
go
{CALL CT_ExportColumns(0,'CustomerID',51,NULL,'CustomerID',2,40252,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'CustomerID',63,NULL,'CustomerID',2,40253,1,0,0,NULL,0,19,496)}
go
{CALL CT_ExportColumns(0,'createmonths',51,NULL,'createmonths',2,40254,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'createmonths',63,NULL,'createmonths',2,40255,1,0,0,NULL,0,20,496)}
go
{CALL CT_ExportColumns(0,'Login',65,NULL,'Login',1,40256,1,0,0,NULL,0,1,496)}
go
{CALL CT_ExportColumns(0,'Transaction Key',65,NULL,'Password',1,40257,1,0,0,NULL,0,2,496)}
go
{CALL CT_ExportColumns(0,'TransID',65,NULL,'TransID',2,40258,1,0,0,'0',0,3,496)}
go
{CALL CT_ExportColumns(0,'Token',65,NULL,'Token',1,40259,1,0,0,NULL,0,4,336)}
go
{CALL CT_ExportColumns(0,'Amount',65,NULL,'Amount',3,40260,1,0,0,NULL,0,5,368)}
go
{CALL CT_ExportColumns(0,'CurrencyCode',65,NULL,'CurrencyCode',1,40261,1,0,0,NULL,0,6,368)}
go
{CALL CT_ExportColumns(0,'Content-Type',65,'application/json','Content-Type',0,40262,3,0,0,NULL,0,0,496)}
go
{CALL CT_ExportColumns(0,'ProcTransID',65,NULL,'ProcTransID',1,40263,1,0,0,NULL,0,7,416)}
go
{CALL CT_ExportColumns(0,'recurringBilling',65,NULL,'AutoBillTF',1,40264,1,0,0,NULL,0,8,64)}
go
{CALL CT_ExportColumns(0,'CardNumber',65,NULL,'CardNumber',1,40265,1,0,0,NULL,0,9,256)}
go
{CALL CT_CCImportColumns('C1',NULL,'C1',NULL,8,2,9,411,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,8,20,1,412,1,0,1,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,8,0,7,413,2,0,1,4,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,8,0,8,414,2,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,9,0,1,415,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,9,0,2,416,1,0,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,9,0,7,417,1,0,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response',NULL,9,0,8,418,1,0,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,12,10,1,419,1,115,0,0,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,12,35,8,420,1,67,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,12,6,7,421,1,47,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,12,6,2,422,1,47,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,8,0,2,423,2,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,19,10,1,424,1,115,0,0,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,19,35,8,425,1,67,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,19,6,7,426,1,47,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,19,6,2,427,1,47,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,14,0,1,428,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,14,0,2,429,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,14,0,7,430,1,10,0,4,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'Response',NULL,14,0,8,431,1,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,15,0,1,432,1,0,0,16,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,15,8,7,433,1,9,0,17,511)}
go
{CALL CT_CCImportColumns('Authorized $this $sink',NULL,'Response',NULL,15,0,8,434,1,0,0,18,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink',NULL,15,0,0,435,1,0,0,19,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,15,0,2,436,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,16,0,1,437,1,0,0,16,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,16,0,7,438,1,9,0,15,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response',NULL,16,0,8,439,1,0,0,18,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink',NULL,16,0,0,440,1,0,0,19,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,16,0,2,441,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,19,0,1,446,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,19,0,7,447,1,0,0,4,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,19,0,8,448,1,0,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,19,0,2,449,1,0,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'TransID',NULL,20,0,1,450,1,0,0,15,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,20,0,7,451,1,0,0,8,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response',NULL,20,0,8,452,1,0,0,13,511)}
go
{CALL CT_CCImportColumns('$filename','$filename','Status',NULL,21,0,2,453,1,0,0,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,21,8,1,454,1,119,0,1,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$sink','Response',NULL,21,6,8,455,1,47,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,21,6,7,456,1,47,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink',NULL,21,25,0,457,1,70,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,99,0,1,458,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response',NULL,99,0,8,459,1,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,99,0,7,460,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,99,0,2,461,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,202,0,1,462,1,0,0,8,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,202,0,7,463,1,0,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink',NULL,202,0,0,464,1,0,0,1,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode $this $sink','Declined $approvecode','Response Code',NULL,202,0,8,465,1,0,0,3,511)}
go
{CALL CT_CCImportColumns('C1',NULL,'C1',NULL,10,2,9,466,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,10,20,1,467,1,0,1,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,10,0,7,468,2,0,1,4,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,10,0,8,469,2,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,10,0,2,470,2,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'TransID',NULL,299,0,1,572,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,299,0,2,573,1,0,1,2,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode $this','Declined $approvecode','Response Code',NULL,299,0,8,574,1,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'ApproveCode',NULL,299,0,7,575,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'TransID',NULL,5,0,1,576,1,0,1,5,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,5,0,2,577,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'ApproveCode',NULL,5,0,7,578,1,10,1,4,511)}
go
{CALL CT_CCImportColumns('Authorized $this / $approvecode','$status','Response Code',NULL,5,0,8,579,1,0,1,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'TransID',NULL,6,0,1,580,1,0,1,5,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,6,0,2,581,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'ApproveCode',NULL,6,0,7,582,1,10,1,4,511)}
go
{CALL CT_CCImportColumns('Authorized $this / $approvecode','$status','Response Code',NULL,6,0,8,583,1,0,1,3,511)}
go
{CALL CT_CCImportColumns('C1',NULL,'C1',NULL,22,2,9,618,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,8,20,1,619,1,0,1,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,22,6,7,620,2,2,1,1,511)}
go
{CALL CT_CCImportColumns('Authorized $this',NULL,'Response',NULL,22,0,8,621,2,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,22,0,2,622,2,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,33,0,1,3922,1,0,0,9,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,33,0,7,3923,1,0,0,10,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,33,0,2,3924,1,0,0,6,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $approvecode','Response','Error $approvecode',33,0,8,3925,1,0,0,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,1299,0,1,3986,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,1299,0,2,3987,1,0,1,2,511)}
go
{CALL CT_CCImportColumns('Approved','Declined','Response','Error',1299,0,8,3988,1,0,1,1,511)}
go
{CALL CT_CCImportColumns('000000','DDDDDD','Approve Code','EEEEEE',1299,0,7,3989,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,18,0,1,4901,1,0,0,8,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,18,0,7,4902,1,0,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink',NULL,18,0,0,4903,1,0,0,1,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode $this $sink','Declined $approvecode','Response Code',NULL,18,0,8,4904,1,0,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'TransID',NULL,7,0,1,4905,1,0,1,5,511)}
go
{CALL CT_CCImportColumns('$filename','$filename','Status',NULL,7,0,2,4906,1,0,1,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,7,0,7,4907,1,0,1,8,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','Response Code',NULL,7,0,8,4908,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,30,12,1,4909,1,6,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,30,1,2,4910,1,135,0,2,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,30,6,7,4911,1,136,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Sink (Error Codes)',NULL,30,9,0,4912,1,19,0,4,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $status $approvecode $sink','Response','Error $status $sink',30,0,8,4913,1,0,0,5,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ReferenceNumber',NULL,31,0,1,4914,0,0,0,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResultMessage',NULL,31,0,2,4915,0,0,0,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ApprovalNumber',NULL,31,0,7,4916,0,0,0,0,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$status  $ResponseCode - $ResultCode',NULL,NULL,31,0,8,4917,0,0,0,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,32,0,1,4918,1,0,0,8,383)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,32,0,2,4919,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,32,0,7,4920,1,0,0,5,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','Response Code','Error $this',32,0,8,4921,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,203,0,1,4922,1,0,0,8,383)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,203,0,2,4923,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,203,0,7,4924,1,0,0,5,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','Response Code','Error $this',203,0,8,4925,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response Reason Code',NULL,32,0,5,4926,1,0,0,3,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,37,0,1,4927,1,0,0,8,383)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,37,0,2,4928,1,0,1,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,37,0,7,4929,1,0,1,5,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this $.sink','Response Code','Error $this',37,0,8,4930,1,0,1,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'AVS Response',NULL,37,0,0,4931,1,0,1,6,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'External Trans ID',NULL,37,0,10,4932,1,0,1,7,1008)}
go
{CALL CT_CCImportColumns(NULL,NULL,'External Trans ID',NULL,32,0,10,4933,1,0,1,7,1008)}
go
{CALL CT_CCImportColumns(NULL,NULL,'External Trans ID',NULL,203,0,10,4934,1,0,0,7,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,204,0,1,4940,1,0,0,8,383)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,204,0,2,4941,1,0,0,1,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approve Code',NULL,204,0,7,4942,1,0,0,5,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','Response Code','Error $this',204,0,8,4943,1,0,0,4,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'External Trans ID',NULL,204,0,10,4944,1,0,0,7,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,39,0,1,4945,1,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ProcStatus$ApprovalStatus',NULL,39,0,2,4946,1,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AuthCode',NULL,39,0,7,4947,1,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TxRefNum',NULL,39,0,10,4948,0,0,0,0,496)}
go
{CALL CT_CCImportColumns('Authorized $this','Declined $this','$StatusMsg','Error $this',39,0,8,4949,0,0,0,0,240)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransID',NULL,40,0,10,4950,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RefNo',NULL,40,0,1,4951,0,0,0,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Auth',NULL,40,0,7,4952,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Auth',NULL,40,0,2,4953,0,0,0,0,448)}
go
{CALL CT_CCImportColumns('Approved $Auth ($AVSCode:$CVV2ResponseMsg)',NULL,'Notes',NULL,40,0,8,4954,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransID',NULL,205,0,10,4955,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RefNo',NULL,205,0,1,4956,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Auth',NULL,205,0,7,4957,0,0,0,0,448)}
go
{CALL CT_CCImportColumns('Approved $approvecode',NULL,'$Notes',NULL,205,0,8,4958,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Auth',NULL,205,0,2,4959,0,0,0,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$PNREF',NULL,41,0,10,4960,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESULT',NULL,41,0,2,4961,0,0,0,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode ($AVSADDR$AVSZIP$IAVS)',NULL,'$RESPMSG','Error $this',41,0,8,4962,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AUTHCODE',NULL,41,0,7,4963,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,41,0,1,4964,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$PNREF',NULL,206,0,10,4965,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESULT',NULL,206,0,2,4966,0,0,0,0,496)}
go
{CALL CT_CCImportColumns('Approved','Declined $this','$RESPMSG','Error $this',206,0,8,4967,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,206,0,1,4969,0,0,0,0,496)}
go
{CALL CT_CCImportColumns('000000',NULL,NULL,NULL,206,0,7,4973,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$rspcode',NULL,38,0,2,4974,0,0,0,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,38,0,7,4975,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','$rsptext','Error $this',38,0,8,4976,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$gatewaytxnid',NULL,38,0,10,4977,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$GatewayRspCode',NULL,38,0,2,4978,0,0,1,0,384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sitetrace',NULL,38,0,1,4979,0,0,0,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1010,0,1,4980,0,0,1,0,33494016)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,1010,0,2,4981,0,0,1,0,33494016)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$errorDescription',NULL,1010,0,8,4983,0,0,1,0,31396864)}
go
{CALL CT_CCImportColumns('$IFirstName$ILastName',NULL,'$IName',NULL,1010,0,7,4984,0,0,1,0,524288)}
go
{CALL CT_CCImportColumns('Authorized Credit','Declined Credit','$StatusMsg','Error Credit',39,0,8,4985,0,0,0,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESPONSECODE',NULL,42,0,2,4986,0,0,1,0,240)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AUTHCODE',NULL,42,0,7,4987,0,0,1,0,240)}
go
{CALL CT_CCImportColumns('Approved $approvecode ($AVSDATA)','Declined $this','$DECLINEREASON1MESSAGE','Error $this',42,0,8,4988,0,0,1,0,240)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransID',NULL,42,0,10,4989,0,0,1,0,80)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,42,0,1,4990,0,0,1,0,240)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response Code',NULL,43,0,2,4991,1,0,1,1,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','Response Reason Text','Error $this',43,0,8,4992,1,0,1,4,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approval Code',NULL,43,0,7,4993,1,0,1,5,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'AVS Result Code',NULL,43,0,0,4994,1,0,1,6,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Transaction ID',NULL,43,0,10,4995,1,0,1,9,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Order ID',NULL,43,0,1,4996,1,0,1,13,240)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,44,0,2,4997,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,44,0,7,4998,0,0,1,0,368)}
go
{CALL CT_CCImportColumns('Approved $approvecode ($avsresult)','Declined ($this)','$declinecode','Error $this',44,0,8,4999,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ordernumber',NULL,44,0,10,5000,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$merchanttracenbr',NULL,44,0,1,5001,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,207,0,2,5002,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,207,0,7,5003,0,0,1,0,368)}
go
{CALL CT_CCImportColumns('Approved $approvecode ($avsresult)','Declined ($this)','$declinecode','Error $this',207,0,8,5004,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ordernumber',NULL,207,0,10,5005,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$merchanttracenbr',NULL,207,0,1,5006,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResultCode',NULL,1011,0,2,5011,0,0,0,0,1971200)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1011,0,1,5012,0,0,1,0,1971200)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResultData',NULL,1011,0,7,5013,0,0,1,0,1573888)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResultDescription',NULL,1011,0,8,5014,0,0,1,0,1971200)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,1012,0,2,5015,0,0,1,0,988160)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$statusmsg',NULL,1012,0,8,5016,0,0,1,0,988160)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1012,0,1,5017,0,0,1,0,988160)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$plan',NULL,1012,0,7,5018,0,0,1,0,524288)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$error',NULL,1013,0,2,5019,0,0,1,0,398336)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$text',NULL,1013,0,8,5020,0,0,1,0,201728)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1013,0,1,5021,0,0,1,0,398336)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1014,0,1,5022,0,0,1,0,463872)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResultCode',NULL,1014,0,2,5023,0,0,1,0,463872)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Message',NULL,1014,0,8,5024,0,0,1,0,463872)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMstatus',NULL,45,0,2,5025,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMauthCode',NULL,45,0,7,5026,0,0,1,0,480)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMrefNum',NULL,45,0,10,5027,0,0,1,0,336)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $UMerrorcode:$UMerror',NULL,'Error $UMerrorcode:$UMerror',45,0,8,5028,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,45,0,1,5029,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMstatus',NULL,208,0,2,5030,0,0,1,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMauthCode',NULL,208,0,7,5031,0,0,1,0,480)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$UMrefNum',NULL,208,0,10,5032,0,0,1,0,336)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $UMerrorcode:$UMerror',NULL,'Error $UMerrorcode:$UMerror',208,0,8,5033,0,0,1,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,208,0,1,5034,0,0,1,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$response',NULL,46,0,2,5035,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,46,0,7,5036,0,0,1,0,352)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionid',NULL,46,0,10,5037,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,46,0,1,5038,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','$responsetext','Error $this',46,0,8,5039,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$response',NULL,209,0,2,5040,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,209,0,7,5041,0,0,1,0,352)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionid',NULL,209,0,10,5042,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,209,0,1,5043,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','$responsetext','Error $this',209,0,8,5044,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Status',NULL,47,0,2,5045,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','$StatusDetail','Error $this',47,0,8,5046,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$VPSTxId:$SecurityKey',NULL,47,0,10,5047,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TxAuthNo',NULL,47,0,7,5048,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,47,0,1,5049,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approval Indicator',NULL,48,2,2,5050,1,2,1,1,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Code',NULL,48,6,7,5051,1,3,1,2,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','Message','Error $this',48,32,8,5052,1,9,1,3,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Reference',NULL,48,10,10,5053,1,47,1,4,496)}
go
{CALL CT_CCImportColumns('$ieatransid','$ieatransid','$ieatransid','$ieatransid',48,0,1,5054,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$IOfferID',NULL,1010,0,7,5055,0,0,1,0,1048576)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$keyonly',NULL,1010,0,7,5056,0,0,1,0,2097152)}
go
{CALL CT_CCImportColumns('ESEveryoneDomainUP',NULL,NULL,NULL,1010,0,11,5057,0,0,1,0,2097152)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$vpc_MerchTxnRef',NULL,49,0,1,5058,0,0,1,1,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$vpc_TxnResponseCode',NULL,49,0,2,5059,0,0,1,2,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$vpc_TransactionNo',NULL,49,0,10,5060,0,0,1,3,368)}
go
{CALL CT_CCImportColumns('Approved $approvecode',NULL,'$vpc_Message',NULL,49,0,8,5061,0,0,1,4,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$vpc_AuthorizeId',NULL,49,0,7,5062,0,0,1,5,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1015,0,1,5063,0,0,1,0,3673088)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ErrCount',NULL,1015,0,2,5064,0,0,1,0,3673088)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Err1',NULL,1015,0,8,5065,0,0,1,0,3673088)}
go
{CALL CT_CCImportColumns('ESEnomUP',NULL,NULL,NULL,1015,0,11,5066,0,0,1,0,2100224)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$OrderID',NULL,1015,0,7,5067,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieaoptionid',NULL,1015,0,7,5068,0,0,1,0,1572864)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$o',NULL,50,0,10,5069,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$z',NULL,50,0,7,5070,0,0,1,0,112)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','$m','Error $this',50,0,8,5071,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$c',NULL,50,0,2,5072,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$i',NULL,50,0,1,5073,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$o',NULL,210,0,10,5074,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$z',NULL,210,0,7,5075,0,0,1,0,112)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','$m','Error $this',210,0,8,5076,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$c',NULL,210,0,2,5077,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$i',NULL,210,0,1,5078,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RefID',NULL,40,0,1,5079,0,0,1,0,384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,51,0,1,5100,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ActionCode',NULL,51,0,2,5101,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.Approval',NULL,51,0,7,5102,0,0,1,0,368)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'$.ErrMsg $.ResponseText',NULL,51,0,8,5103,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionID',NULL,51,0,10,5104,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,211,0,1,5105,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ActionCode',NULL,211,0,2,5106,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.ErrMsg $.ResponseText',NULL,211,0,8,5108,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionID',NULL,211,0,10,5109,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.Approval',NULL,211,0,7,5111,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Response Code',NULL,212,0,2,5112,1,0,1,1,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode','Declined $this','Response Reason Text','Error $this',212,0,8,5113,1,0,1,4,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Approval Code',NULL,212,0,7,5114,1,0,1,5,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'AVS Result Code',NULL,212,0,0,5115,1,0,1,6,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Transaction ID',NULL,212,0,10,5116,1,0,1,9,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Order ID',NULL,212,0,1,5117,1,0,1,13,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransID',NULL,43,0,1,5118,0,0,1,13,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$IForward',NULL,1010,0,7,5119,0,0,1,0,16777216)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$verbiage',NULL,52,0,2,5120,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Result',NULL,52,0,2,5121,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ApprovalCode',NULL,52,0,7,5122,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$InvoiceNumber',NULL,52,0,1,5123,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,52,0,1,5124,0,0,1,0,432)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$this','$verbiage','Error $this',52,0,8,5125,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$IDStamp',NULL,52,0,10,5126,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$trnId',NULL,53,0,10,5127,0,0,1,0,80)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$this','$messageText','Error $this',53,0,8,5128,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authCode',NULL,53,0,7,5129,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ref1',NULL,53,0,1,5130,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$trnApproved',NULL,53,0,2,5131,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$trnId',NULL,213,0,10,5132,0,0,1,0,80)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$this','$messageText','Error $this',213,0,8,5133,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authCode',NULL,213,0,7,5134,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ref1',NULL,213,0,1,5135,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$trnApproved',NULL,213,0,2,5136,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$retcode',NULL,1016,0,2,5137,0,0,1,0,2048)}
go
{CALL CT_CCImportColumns('ESGenericWSUP',NULL,NULL,NULL,1016,0,11,5138,0,0,1,0,2048)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$message',NULL,1016,0,8,5139,0,0,1,0,2048)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1016,0,1,5140,0,0,1,0,2048)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$message',NULL,1016,0,7,5141,0,0,1,0,2048)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$responsesummaryCode',NULL,54,0,2,5142,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$this','$responseText','Error $this',54,0,8,5143,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$responseauthId',NULL,54,0,7,5144,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$responsereceiptNo',NULL,54,0,10,5145,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,54,0,1,5146,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$userid',NULL,1017,0,10,5147,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1017,0,1,5148,0,0,1,0,400384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$result',NULL,1017,0,2,5149,0,0,1,0,399360)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$message',NULL,1017,0,8,5150,0,0,1,0,400384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$userid',NULL,1017,0,2,5151,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$response',NULL,55,0,2,5152,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','Declined $this','$responsetext','$this',55,0,8,5153,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,55,0,7,5154,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionid',NULL,55,0,10,5155,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,55,0,1,5156,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1018,0,1,5157,0,0,1,0,2038784)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$errorcode',NULL,1018,0,2,5158,0,0,1,0,2038784)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sAccountNo',NULL,1018,0,10,5159,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$aux1value',NULL,1018,0,7,5160,0,0,1,0,524288)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$errormsg',NULL,1018,0,8,5161,0,0,1,0,2038784)}
go
{CALL CT_CCImportColumns('ESEFolderUpdate',NULL,NULL,NULL,1018,0,11,5162,0,0,1,0,1573888)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Status',NULL,1019,0,2,5187,0,0,1,0,3619840)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Error',NULL,1019,0,2,5188,0,0,1,0,67108864)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$errorreason',NULL,1019,0,8,5189,0,0,1,0,70728704)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1019,0,1,5190,0,0,1,0,70728704)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddLogin',NULL,1019,0,10,5191,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Auth',NULL,1019,0,7,5192,0,0,1,0,67108864)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddLogin',NULL,1019,0,7,5193,0,0,1,0,1056768)}
go
{CALL CT_CCImportColumns('ExternalSyncDelete',NULL,NULL,NULL,1019,0,11,5194,0,0,1,0,2097152)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1020,0,1,5195,0,0,1,0,1580032)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,1020,0,2,5196,0,0,1,0,1580032)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Data',NULL,1020,0,7,5197,0,0,1,0,1572864)}
go
{CALL CT_CCImportColumns(NULL,'$status $this','$error','$status $this',1020,0,8,5198,0,0,1,0,1580032)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieauser',NULL,1020,0,10,5199,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ReturnCode',NULL,56,0,2,5200,0,0,1,0,112)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$this','$ReturnMessage','$this',56,0,8,5201,0,0,1,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$OrderID',NULL,56,0,1,5202,0,0,1,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionID',NULL,56,0,7,5203,0,0,1,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,57,0,1,5204,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESULTCODE',NULL,57,0,2,5205,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AUTHCODE',NULL,57,0,7,5206,0,0,1,0,368)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESPONSETEXT','Error $this',57,0,8,5207,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TROUTD',NULL,57,0,10,5208,0,0,1,0,80)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,214,0,1,5209,0,0,1,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESULTCODE',NULL,214,0,2,5210,0,0,1,0,448)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AUTHCODE',NULL,214,0,7,5211,0,0,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$RESPONSETEXT','Error $this',214,0,8,5212,0,0,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TROUTD',NULL,214,0,10,5213,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,58,0,1,5214,1,0,1,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ResponseCode',NULL,58,0,2,5215,1,0,1,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AuthCode',NULL,58,0,7,5216,1,0,1,0,511)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'$Message','Error $this',58,0,8,5217,1,0,1,0,511)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransID',NULL,58,0,10,5218,0,0,1,0,80)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$accountid',NULL,1021,0,10,5219,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Text',NULL,1021,0,8,5220,0,0,1,0,70728704)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$iLogin',NULL,1021,0,7,5221,0,0,1,0,8192)}
go
{CALL CT_CCImportColumns('ExternalSyncDelete',NULL,NULL,NULL,1021,0,11,5222,0,0,1,0,2097152)}
go
{CALL CT_CCImportColumns('A',NULL,NULL,NULL,1021,0,7,5223,0,0,1,0,1048576)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1021,0,1,5224,0,0,1,0,70728704)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Status',NULL,1021,0,2,5225,0,0,1,0,70728704)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authToken',NULL,1021,0,7,5226,0,0,1,0,67108864)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$nCurrentDiskMB',NULL,1018,0,7,5227,0,0,1,0,1048576)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Customer Number',NULL,215,19,1,5228,1,39,1,1,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status.',NULL,215,1,2,5229,1,181,1,2,320)}
go
{CALL CT_CCImportColumns('Approved','Declined $status','Electronic Message','Error $status',215,15,8,5230,1,166,1,4,320)}
go
{CALL CT_CCImportColumns('D0 C0',NULL,'Record Type',NULL,215,2,9,5231,1,26,1,0,49472)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$status',NULL,215,0,7,5232,0,0,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,215,19,10,5233,1,39,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sslresult',NULL,59,0,2,5234,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$.this $.errorMessage $.errorName','$sslresultmessage','$.errorMessage $.errorName',59,0,8,5235,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ssltxnid',NULL,59,0,10,5236,0,0,1,0,80)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sslapprovalcode',NULL,59,0,7,5237,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sslinvoicenumber',NULL,59,0,1,5238,0,0,1,0,0)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sslresult',NULL,216,0,2,5239,0,0,1,0,192)}
go
{CALL CT_CCImportColumns(NULL,'$.this $.errorMessage $.errorName','$sslresultmessage','$.errorMessage $.errorName',216,0,8,5240,0,0,1,0,192)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ssltxnid',NULL,216,0,10,5241,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,216,0,1,5242,0,0,1,0,192)}
go
{CALL CT_CCImportColumns('000000',NULL,NULL,NULL,216,0,7,5243,0,0,1,0,192)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,59,0,1,5244,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionApproved',NULL,60,0,2,5245,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Approved $approvecode',NULL,'$BankMessage',NULL,60,0,8,5246,0,0,1,0,352)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$BankMessage',NULL,60,0,8,5247,0,0,1,0,144)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AuthorizationNum',NULL,60,0,7,5248,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionTag:$AuthorizationNum',NULL,60,0,10,5249,0,0,1,0,80)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,60,0,1,5250,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,61,0,1,5251,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$lastEvent',NULL,61,0,2,5252,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.AuthorisationIdid',NULL,61,0,7,5253,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'$ISO8583ReturnCodedescription','$.lastEvent $.error',61,0,8,5254,0,0,1,0,96)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,61,0,1,5256,0,0,1,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,61,0,1,5257,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$cancelReceivedorderCode',NULL,61,0,2,5258,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$refundReceivedorderCode',NULL,61,0,2,5259,0,0,1,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$tigerLine_side',NULL,300,0,2,5260,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$coordinates_y',NULL,300,0,12,5261,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$coordinates_x',NULL,300,0,13,5262,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,'Address Not Found',NULL,NULL,300,0,8,5263,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,300,0,1,5264,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$retcode',NULL,301,0,2,5265,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$message',NULL,301,0,8,5266,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$lat',NULL,301,0,12,5267,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$long',NULL,301,0,13,5268,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,301,0,1,5269,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$id',NULL,302,0,1,5270,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$latt',NULL,302,0,12,5271,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$longt',NULL,302,0,13,5272,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$code',NULL,302,0,2,5273,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns('Address Matched',NULL,'$description',NULL,302,0,8,5274,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,303,0,1,5275,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$NAACCRGISCoordinateQualityType',NULL,303,0,2,5276,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Latitude',NULL,303,0,12,5277,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Longitude',NULL,303,0,13,5278,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns('Matched $NAACCRGISCoordinateQualityType','No Match ($NAACCRGISCoordinateQualityType)','$NAACCRGISCoordinateQualityType',NULL,303,0,8,5279,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionId',NULL,303,0,10,5280,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,304,0,1,5281,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Latitude',NULL,304,0,12,5282,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Longitude',NULL,304,0,13,5283,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TraceId',NULL,304,0,10,5284,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$MatchCode',NULL,304,0,2,5285,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns('$MatchCode','$StatusCode ($MatchCode)','$MatchCode',NULL,304,0,8,5286,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,305,0,1,5287,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$placeosmtype',NULL,305,0,2,5288,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,'Address Not Found',NULL,NULL,305,0,8,5289,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$placeosmid',NULL,305,0,10,5290,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$placelat',NULL,305,0,12,5291,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$placelon',NULL,305,0,13,5292,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$orderStatusorderCode',NULL,61,0,10,5293,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$response',NULL,62,0,2,5294,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionid',NULL,62,0,10,5295,0,0,1,0,336)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$responsetext',NULL,62,0,8,5296,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$orderid',NULL,62,0,1,5297,0,0,1,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,62,0,7,5298,0,0,1,0,352)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,62,0,1,5299,0,0,1,0,384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$response',NULL,217,0,2,5300,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionid',NULL,217,0,10,5301,0,0,1,0,336)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$responsetext',NULL,217,0,8,5302,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$orderid',NULL,217,0,1,5303,0,0,1,0,112)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$authcode',NULL,217,0,7,5304,0,0,1,0,352)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,217,0,1,5305,0,0,1,0,384)}
go
{CALL CT_CCImportColumns('ESAccountWSUP',NULL,NULL,NULL,1022,0,11,5306,0,0,1,0,7168)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ExternalSyncID',NULL,1022,0,1,5307,0,0,1,0,7168)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$retcode',NULL,1022,0,2,5308,0,0,1,0,7168)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$message',NULL,1022,0,8,5309,0,0,1,0,7168)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Aux1',NULL,1022,0,10,5310,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$Aux1',NULL,1022,0,7,5311,0,0,1,0,6144)}
go
{CALL CT_CCImportColumns('$TransID',NULL,'Trans ID',NULL,37,0,1,5312,1,0,0,8,128)}
go
{CALL CT_CCImportColumns('$TransID',NULL,'Trans ID',NULL,32,0,1,5313,1,0,0,8,128)}
go
{CALL CT_CCImportColumns('$TransID',NULL,'Trans ID',NULL,203,0,1,5314,1,0,0,8,128)}
go
{CALL CT_CCImportColumns('$TransID',NULL,'Trans ID',NULL,204,0,1,5315,1,0,0,8,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sessionref',NULL,300,0,14,5316,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$SessionRef',NULL,303,0,14,5317,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$SessionRef',NULL,305,0,14,5318,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sessionref',NULL,301,0,14,5319,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sessionref',NULL,302,0,14,5320,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$sessionref',NULL,304,0,14,5321,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,306,0,1,5322,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$results_types',NULL,306,0,2,5323,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$SessionRef',NULL,306,0,14,5324,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$location_lat',NULL,306,0,12,5325,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$location_lng',NULL,306,0,13,5326,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,'Address Not Found',NULL,NULL,306,0,8,5327,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$AddressID',NULL,307,0,1,5328,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$accuracy',NULL,307,0,2,5329,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$SessionRef',NULL,307,0,14,5330,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$latitude',NULL,307,0,12,5331,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$longitude',NULL,307,0,13,5332,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,'Address Not Found',NULL,NULL,307,0,8,5333,0,0,1,0,1024)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,63,0,1,5334,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ActionCode',NULL,63,0,2,5335,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.Approval',NULL,63,0,7,5336,0,0,1,0,368)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'$.ErrMsg $.ResponseText',NULL,63,0,8,5337,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$TransactionID',NULL,63,0,10,5338,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,64,0,1,5339,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$lastEvent',NULL,64,0,2,5340,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$.AuthorisationIdid',NULL,64,0,7,5341,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode',NULL,'$ISO8583ReturnCodedescription','$.lastEvent $.error',64,0,8,5342,0,0,1,0,96)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,64,0,1,5343,0,0,1,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,64,0,1,5344,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$cancelReceivedorderCode',NULL,64,0,2,5345,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$refundReceivedorderCode',NULL,64,0,2,5346,0,0,1,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$orderStatusorderCode',NULL,64,0,10,5347,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$lastEvent',NULL,218,0,2,5348,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,218,0,1,5349,0,0,1,0,384)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$refundReceivedorderCode',NULL,218,0,2,5350,0,0,1,0,256)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$ieatransid',NULL,218,0,1,5351,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$orderStatusorderCode',NULL,218,0,10,5352,0,0,1,0,64)}
go
{CALL CT_CCImportColumns('Authorized',NULL,'$ISO8583ReturnCodedescription','$.lastEvent $.error',218,0,8,5353,0,0,1,0,64)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$cancelReceivedorderCode',NULL,218,0,2,5354,0,0,1,0,128)}
go
{CALL CT_CCImportColumns(NULL,NULL,NULL,NULL,218,0,7,5355,0,0,1,0,448)}
go
{CALL CT_CCImportColumns('Authorized',NULL,'$.error',NULL,218,0,8,5356,0,0,1,0,384)}
go
{CALL CT_CCImportColumns('6D 6C',NULL,'RecordType',NULL,219,2,9,5357,0,1,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Trans ID',NULL,219,13,1,5358,0,40,1,0,320)}
go
{CALL CT_CCImportColumns('Approved',NULL,'Response',NULL,219,0,8,5359,0,0,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'Status',NULL,219,2,2,5360,0,1,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,NULL,NULL,219,0,7,5361,0,0,1,0,320)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$refId',NULL,65,0,1,5362,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionResponse_authCode',NULL,65,0,7,5363,0,0,1,0,496)}
go
{CALL CT_CCImportColumns('Authorized $approvecode','$.errorText','$.description','$.errorText $.text',65,0,8,5364,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionResponse_responseCode',NULL,65,0,2,5365,0,0,1,0,496)}
go
{CALL CT_CCImportColumns(NULL,NULL,'$transactionResponse_transId',NULL,65,0,10,5366,0,0,1,0,496)}
go
{CALL CT_ConfigGroups(1,'Client',10,1,1,0)}
go
{CALL CT_ConfigGroups(4,'SMTP',40,1,0,0)}
go
{CALL CT_ConfigGroups(5,'Reports',50,1,0,0)}
go
{CALL CT_ConfigGroups(6,'Accounting',60,1,0,0)}
go
{CALL CT_ConfigGroups(8,'Operator',80,1,0,1)}
go
{CALL CT_ConfigGroups(9,'CC Batch',65,1,0,0)}
go
{CALL CT_ConfigGroups(10,'ACH Batch',68,1,0,0)}
go
{CALL CT_ConfigGroups(11,'Logs',90,1,0,0)}
go
{CALL CT_ConfigGroups(13,'Security',110,1,0,1)}
go
{CALL CT_ConfigGroups(14,'Customer Web',140,1,0,0)}
go
{CALL CT_ConfigGroups(16,'Operator Limits',160,1,0,1)}
go
{CALL CT_ConfigGroups(17,'Operator Rights',170,1,0,1)}
go
{CALL CT_ConfigGroups(18,'RADIUS Auth Test',180,1,1,0)}
go
{CALL CT_ConfigGroups(19,'Session Manager',190,1,0,0)}
go
{CALL CT_ConfigGroups(20,'Upgrade & Testing',200,1,0,0)}
go
{CALL CT_Configs(1,0,0,1,0,NULL,0,'Database Version',NULL,-1.0000,1001,NULL)}
go
{CALL CT_Configs(1,0,0,1,1,NULL,4,'Location Datasets',NULL,1.0000,1000,NULL)}
go
{CALL CT_Configs(1,0,0,1,2,NULL,1,'Database EWS Binding
',NULL,NULL,1010,NULL)}
go
{CALL CT_Configs(1,1,0,6,5,NULL,0,'Default Expire Grace Period (Days)',NULL,15.0000,5,NULL)}
go
{CALL CT_Configs(1,1,0,1,6,NULL,0,'Min Password Length',NULL,4.0000,6,NULL)}
go
{CALL CT_Configs(1,1,0,1,7,NULL,2,'Random Passwords',NULL,.0000,21,NULL)}
go
{CALL CT_Configs(1,1,0,6,9,NULL,0,'Setup Expire Grace Period (Days)',NULL,20.0000,9,NULL)}
go
{CALL CT_Configs(1,1,0,1,10,NULL,2,'Password Complexity',NULL,.0000,10,NULL)}
go
{CALL CT_Configs(1,1,0,6,14,NULL,2,'Send Receipts',NULL,1.0000,99,NULL)}
go
{CALL CT_Configs(1,1,0,6,15,NULL,3,'NSF Charge Type',NULL,NULL,15,'{CALL ListConfigChargeTypes}')}
go
{CALL CT_Configs(1,1,0,6,16,NULL,2,'Send Manual Payment Receipts',NULL,.0000,100,NULL)}
go
{CALL CT_Configs(1,0,0,5,18,NULL,2,'Default Print Format',NULL,2.0000,18,NULL)}
go
{CALL CT_Configs(1,0,0,1,20,NULL,4,'Unique Login Checking',NULL,1.0000,4,NULL)}
go
{CALL CT_Configs(1,0,1,8,28,NULL,0,'Idle timeout (secs)',NULL,14400000.0000,30,NULL)}
go
{CALL CT_Configs(1,1,0,1,33,NULL,2,'Login Character Restrictions',NULL,2.0000,4,NULL)}
go
{CALL CT_Configs(1,1,0,6,34,NULL,2,'Inactivate MBR w/non-zero Balance',NULL,.0000,34,NULL)}
go
{CALL CT_Configs(1,0,0,6,35,NULL,0,'CC/EFT Dupe payment protection (Days)',NULL,14.0000,350,NULL)}
go
{CALL CT_Configs(1,1,0,6,36,NULL,0,'Interim Look-Ahead (Days)',NULL,45.0000,37,NULL)}
go
{CALL CT_Configs(1,1,0,6,37,NULL,0,'Invoice Next Term Max (Days)',NULL,120.0000,38,NULL)}
go
{CALL CT_Configs(1,1,0,6,38,NULL,2,'Print 0 Balance or Credit Statements',NULL,1.0000,39,NULL)}
go
{CALL CT_Configs(1,0,0,5,40,NULL,2,'Enable Crystal Reports Print Engine',NULL,.0000,1,NULL)}
go
{CALL CT_Configs(1,0,0,5,41,NULL,2,'Enable Emerald Print Engine',NULL,1.0000,1,NULL)}
go
{CALL CT_Configs(1,0,0,4,50,'localhost',1,'Email Smart Host',NULL,NULL,50,NULL)}
go
{CALL CT_Configs(1,0,0,4,51,'changeme.localhost',1,'Email Domain',NULL,NULL,51,NULL)}
go
{CALL CT_Configs(1,0,0,4,52,'changeme@localhost',1,'Email Admin',NULL,NULL,52,NULL)}
go
{CALL CT_Configs(1,0,0,4,53,'changeme@localhost',1,'Email Accounts',NULL,.0000,53,NULL)}
go
{CALL CT_Configs(1,0,0,4,54,NULL,0,'Email Max Retries',NULL,16.0000,54,NULL)}
go
{CALL CT_Configs(1,0,0,4,57,NULL,1,'Email Login',NULL,NULL,50,NULL)}
go
{CALL CT_Configs(1,0,0,4,58,NULL,5,'Email Password',NULL,NULL,50,NULL)}
go
{CALL CT_Configs(1,0,0,4,59,NULL,2,'Enable 8-BITMIME',NULL,1.0000,59,NULL)}
go
{CALL CT_Configs(1,0,0,4,60,NULL,2,'Certificate Validation',NULL,.0000,60,NULL)}
go
{CALL CT_Configs(1,0,0,11,200,NULL,0,'Trim days for RADIUS Logs',NULL,200.0000,200,NULL)}
go
{CALL CT_Configs(1,0,0,11,201,NULL,0,'Trim days for Scheduler Logs',NULL,183.0000,201,NULL)}
go
{CALL CT_Configs(1,0,0,11,202,NULL,0,'Trim days for Audit Logs',NULL,183.0000,202,NULL)}
go
{CALL CT_Configs(1,0,0,11,203,NULL,0,'Trim days for Syslogs',NULL,183.0000,203,NULL)}
go
{CALL CT_Configs(1,0,0,11,205,NULL,0,'Trim days for Start/Stop Call records',NULL,730.0000,205,NULL)}
go
{CALL CT_Configs(1,0,0,11,206,NULL,0,'Trim days for  Interim Call records',NULL,45.0000,206,NULL)}
go
{CALL CT_Configs(1,0,0,11,209,NULL,0,'Trim days for Sensitive Data - Completed CC/EFT Trans',NULL,.0000,209,NULL)}
go
{CALL CT_Configs(1,0,0,11,210,NULL,0,'Trim days for Sensitive Data - Inactive Accounts',NULL,.0000,210,NULL)}
go
{CALL CT_Configs(1,0,0,11,211,NULL,0,'Trim days for sent SMS messages',NULL,1095.0000,211,NULL)}
go
{CALL CT_Configs(1,0,0,11,212,NULL,0,'Trim days for Voice Calls',NULL,730.0000,207,NULL)}
go
{CALL CT_Configs(1,0,0,11,213,NULL,0,'Trim days for Notice Logs',NULL,730.0000,204,NULL)}
go
{CALL CT_Configs(1,0,0,11,214,NULL,0,'Trim days for Change log',NULL,730.0000,203,NULL)}
go
{CALL CT_Configs(1,0,0,11,215,NULL,0,'RADIUS Logs dupe suppression seconds',NULL,300.0000,200,NULL)}
go
{CALL CT_Configs(1,0,0,11,216,NULL,0,'RADIUS Logs unknown MAC trim minutes',NULL,15.0000,200,NULL)}
go
{CALL CT_Configs(0,0,0,13,220,NULL,1,'Encryption Verifier',NULL,NULL,220,NULL)}
go
{CALL CT_Configs(1,0,0,13,221,NULL,0,'Encrypt Passwords',NULL,.0000,221,NULL)}
go
{CALL CT_Configs(1,0,0,13,222,NULL,0,'Encrypt CC/EFT data',NULL,.0000,222,NULL)}
go
{CALL CT_Configs(1,0,1,17,223,NULL,2,'Password Visibility',NULL,.0000,222,NULL)}
go
{CALL CT_Configs(1,0,1,17,224,NULL,2,'CC/EFT Visibility',NULL,.0000,224,NULL)}
go
{CALL CT_Configs(1,0,1,17,240,NULL,4,'Allowed Pay Methods',NULL,62.0000,240,'{CALL ListConfigPaymentTypes}')}
go
{CALL CT_Configs(1,0,1,17,241,NULL,0,'Cash Amount Limit',NULL,NULL,241,NULL)}
go
{CALL CT_Configs(1,0,1,17,242,NULL,0,'Check Amount Limit',NULL,NULL,242,NULL)}
go
{CALL CT_Configs(1,0,1,17,243,NULL,0,'Manual CC Amount Limit',NULL,NULL,243,NULL)}
go
{CALL CT_Configs(1,0,1,17,244,NULL,0,'Manual ACH Amount Limit',NULL,NULL,244,NULL)}
go
{CALL CT_Configs(1,0,1,17,245,NULL,0,'Minimum CC Amount',NULL,NULL,245,NULL)}
go
{CALL CT_Configs(1,0,1,17,246,NULL,0,'Minimum EFT Amount',NULL,NULL,246,NULL)}
go
{CALL CT_Configs(1,0,1,17,247,NULL,2,'Theme Selection',NULL,1.0000,225,NULL)}
go
{CALL CT_Configs(1,0,1,17,248,NULL,2,'Language Selection',NULL,1.0000,226,NULL)}
go
{CALL CT_Configs(1,0,1,17,249,NULL,2,'Search Incident Assignment',NULL,.0000,227,NULL)}
go
{CALL CT_Configs(1,0,1,16,301,NULL,0,'Max Results - Simple Search',NULL,2000.0000,301,NULL)}
go
{CALL CT_Configs(1,0,1,16,302,NULL,0,'Max Results - MBR Search',NULL,2000.0000,302,NULL)}
go
{CALL CT_Configs(1,0,1,8,303,NULL,0,'Max months of customer history to display',NULL,24.0000,303,NULL)}
go
{CALL CT_Configs(1,0,1,16,304,NULL,0,'Max Results - Service Search',NULL,2000.0000,304,NULL)}
go
{CALL CT_Configs(1,0,1,16,305,NULL,0,'Max Results - Prepaid Search',NULL,2000.0000,305,NULL)}
go
{CALL CT_Configs(1,0,1,16,306,NULL,0,'Max Results - Advanced Search',NULL,2000.0000,306,NULL)}
go
{CALL CT_Configs(1,0,1,16,307,NULL,0,'Max Results - Custom Search',NULL,2000.0000,307,NULL)}
go
{CALL CT_Configs(1,0,1,16,308,NULL,0,'Max Results - Invoice Search',NULL,2000.0000,308,NULL)}
go
{CALL CT_Configs(1,0,1,16,309,NULL,0,'Max Results - Statement Search',NULL,2000.0000,309,NULL)}
go
{CALL CT_Configs(1,0,1,16,310,NULL,0,'Max Results - Payment Search',NULL,2000.0000,310,NULL)}
go
{CALL CT_Configs(1,0,1,16,311,NULL,0,'Max Results - RADIUS Log Search',NULL,2000.0000,311,NULL)}
go
{CALL CT_Configs(1,0,1,16,312,NULL,0,'Max Results - Incident Search',NULL,1000.0000,312,NULL)}
go
{CALL CT_Configs(1,0,1,16,313,NULL,0,'Max Results - Call Search',NULL,2000.0000,313,NULL)}
go
{CALL CT_Configs(1,0,1,16,314,NULL,0,'Max Results - Inventory Search',NULL,2000.0000,314,NULL)}
go
{CALL CT_Configs(1,0,1,16,315,NULL,0,'Max Results - Mail Log Search',NULL,2000.0000,315,NULL)}
go
{CALL CT_Configs(1,0,1,8,316,NULL,2,'Credit Card swipe',NULL,1.0000,316,NULL)}
go
{CALL CT_Configs(1,0,1,16,317,NULL,0,'Max Results - SMS Log Search',NULL,2000.0000,317,NULL)}
go
{CALL CT_Configs(1,0,1,16,318,NULL,0,'Max Results - Syslog Search',NULL,2000.0000,318,NULL)}
go
{CALL CT_Configs(1,0,1,16,319,NULL,0,'Max Results - Change History Search',NULL,2000.0000,319,NULL)}
go
{CALL CT_Configs(1,0,0,1,323,NULL,2,'Show Currency Code (Reports)',NULL,.0000,310,NULL)}
go
{CALL CT_Configs(1,0,0,1,324,NULL,2,'Show Currency Code (Client)',NULL,.0000,314,NULL)}
go
{CALL CT_Configs(1,0,0,14,327,NULL,2,'Customer Website Show Currency Code',NULL,.0000,504,NULL)}
go
{CALL CT_Configs(1,0,1,16,329,NULL,0,'Max Results - Audit Log Search',NULL,2000.0000,325,NULL)}
go
{CALL CT_Configs(1,1,0,6,375,NULL,3,'Recurring MBR Expired Auto Close Reason',NULL,1.0000,375,'SELECT CancelReasonID AS NumValue, CancelReason AS ValueName FROM CancelReasons WHERE SortOrder > 0 ORDER BY SortOrder')}
go
{CALL CT_Configs(1,1,0,6,376,NULL,2,'Recurring MBR Expired Auto Close After',NULL,.0000,376,NULL)}
go
{CALL CT_Configs(1,0,0,6,377,NULL,2,'Allow Payment to Trigger new Statements',NULL,.0000,38,NULL)}
go
{CALL CT_Configs(1,0,1,8,390,NULL,2,'Default date format',NULL,1.0000,390,NULL)}
go
{CALL CT_Configs(1,0,1,8,391,'/',1,'Default date seperator',NULL,.0000,391,NULL)}
go
{CALL CT_Configs(1,0,1,8,392,NULL,2,'Default measurement units',NULL,1.0000,394,NULL)}
go
{CALL CT_Configs(1,0,1,8,393,NULL,2,'Default time format',NULL,1.0000,393,NULL)}
go
{CALL CT_Configs(1,1,0,14,501,NULL,2,'Customer Website Allow Payment',NULL,1.0000,501,NULL)}
go
{CALL CT_Configs(1,1,0,14,502,'Customer Account Center',1,'Customer Website Name',NULL,.0000,400,NULL)}
go
{CALL CT_Configs(1,1,0,14,503,NULL,2,'Customer Website Allow Pay Method Change',NULL,.0000,503,NULL)}
go
{CALL CT_Configs(1,1,0,6,504,NULL,2,'Time and Data Left update',NULL,1.0000,504,NULL)}
go
{CALL CT_Configs(1,1,0,6,505,NULL,0,'Minimum new statement interval (Days)',NULL,25.0000,505,NULL)}
go
{CALL CT_Configs(1,1,0,14,506,NULL,2,'Customer Website Show Billing History',NULL,1.0000,506,NULL)}
go
{CALL CT_Configs(1,1,0,6,507,NULL,2,'Print 0 Balance or Credit Invoices',NULL,.0000,39,NULL)}
go
{CALL CT_Configs(1,1,0,14,514,NULL,2,'Customer Website Incident Access',NULL,1.0000,514,NULL)}
go
{CALL CT_Configs(1,1,0,14,515,NULL,2,'Customer Website Show Call History',NULL,1.0000,515,NULL)}
go
{CALL CT_Configs(1,1,0,14,516,NULL,2,'Customer Website Allow Data Purchase',NULL,1.0000,516,NULL)}
go
{CALL CT_Configs(1,1,0,14,518,NULL,1,'Customer Website Logout URL',NULL,NULL,500,NULL)}
go
{CALL CT_Configs(1,1,0,14,519,NULL,2,'Customer Website Confirm Logout',NULL,1.0000,519,NULL)}
go
{CALL CT_Configs(1,1,0,14,520,NULL,1,'Customer Website Logo URL',NULL,NULL,450,NULL)}
go
{CALL CT_Configs(1,1,0,14,521,NULL,2,'Customer Website Require CC AVS',NULL,.0000,521,NULL)}
go
{CALL CT_Configs(1,1,0,14,522,NULL,2,'Customer Website Require CC CVV2',NULL,.0000,522,NULL)}
go
{CALL CT_Configs(1,1,0,14,523,NULL,2,'Customer Website Default Login Fill Type',NULL,4.0000,523,NULL)}
go
{CALL CT_Configs(1,1,0,1,524,'https://www.iea-software.com/support',1,'Support URL',NULL,NULL,0,NULL)}
go
{CALL CT_Configs(1,1,0,14,526,NULL,2,'Customer Website Allow MBR Cancel',NULL,.0000,500,NULL)}
go
{CALL CT_Configs(1,1,0,14,527,NULL,0,'Customer Website StringID',NULL,NULL,401,NULL)}
go
{CALL CT_Configs(1,1,0,14,528,NULL,2,'Customer Website Allow Prepaid Recharge',NULL,.0000,502,NULL)}
go
{CALL CT_Configs(1,1,0,14,529,NULL,2,'Customer Website Show Avaliable Credit',NULL,1.0000,506,NULL)}
go
{CALL CT_Configs(1,0,0,5,531,NULL,2,'Auto close reports when not in focus',NULL,1.0000,19,NULL)}
go
{CALL CT_Configs(1,1,0,14,533,NULL,2,'Customer Website Address default for CC AVS',NULL,1.0000,523,NULL)}
go
{CALL CT_Configs(1,1,0,6,535,NULL,2,'Time and Data Left tracking',NULL,1.0000,504,NULL)}
go
{CALL CT_Configs(1,1,0,18,540,NULL,1,'Acct-Session-ID',NULL,NULL,540,NULL)}
go
{CALL CT_Configs(1,1,0,18,541,NULL,1,'NAS-Identifier',NULL,NULL,541,NULL)}
go
{CALL CT_Configs(1,1,0,18,542,NULL,1,'NAS-Port',NULL,NULL,542,NULL)}
go
{CALL CT_Configs(1,1,0,18,543,NULL,1,'Called-Station-ID',NULL,NULL,543,NULL)}
go
{CALL CT_Configs(1,1,0,18,544,NULL,1,'Calling-Station-ID',NULL,NULL,544,NULL)}
go
{CALL CT_Configs(1,1,0,6,603,NULL,2,'Renewal move expiration forward strategy',NULL,.0000,35,NULL)}
go
{CALL CT_Configs(1,1,0,6,604,NULL,0,'Renewal move expiration forward amount',NULL,.0100,36,NULL)}
go
{CALL CT_Configs(1,0,1,16,620,NULL,0,'Max Invoices Per Batch',NULL,.0000,620,NULL)}
go
{CALL CT_Configs(1,0,1,16,621,NULL,0,'Max Invoice Preview Batch',NULL,.0000,621,NULL)}
go
{CALL CT_Configs(1,0,0,16,622,NULL,0,'Max Invoice Print Batch',NULL,.0000,622,NULL)}
go
{CALL CT_Configs(1,0,1,16,625,NULL,0,'Max Statements Per Batch',NULL,.0000,625,NULL)}
go
{CALL CT_Configs(1,0,1,16,626,NULL,0,'Max Statement Preview Batch',NULL,.0000,626,NULL)}
go
{CALL CT_Configs(1,0,0,16,627,NULL,0,'Max Statement Print Batch',NULL,.0000,627,NULL)}
go
{CALL CT_Configs(1,0,0,19,632,NULL,2,'Verify Session Status',NULL,1.0000,43,NULL)}
go
{CALL CT_Configs(1,0,0,19,633,NULL,4,'Debug Options',NULL,.0000,45,NULL)}
go
{CALL CT_Configs(1,0,0,19,634,NULL,2,'Enforce Concurrency Control',NULL,1.0000,20,NULL)}
go
{CALL CT_Configs(1,0,0,19,635,NULL,2,'Enforce Time Left',NULL,1.0000,30,NULL)}
go
{CALL CT_Configs(1,0,0,19,636,NULL,2,'Enforce Rate/Balance Restrictions',NULL,1.0000,40,NULL)}
go
{CALL CT_Configs(1,0,0,19,637,NULL,0,'Limit Check Interval (secs)',NULL,60.0000,50,NULL)}
go
{CALL CT_Configs(1,0,0,19,638,NULL,0,'Rating Check Interval (secs)',NULL,300.0000,60,NULL)}
go
{CALL CT_Configs(1,0,0,19,639,NULL,2,'Rating global history preload',NULL,.0000,70,NULL)}
go
{CALL CT_Configs(1,1,0,6,640,NULL,2,'Allow Setup Charge for new Accounts',NULL,1.0000,640,NULL)}
go
{CALL CT_Configs(1,1,0,6,641,NULL,2,'Allow Setup Charge for Re-Opened Accounts',NULL,.0000,641,NULL)}
go
{CALL CT_Configs(1,1,0,6,642,NULL,2,'Allow Only Acct Admins to Override Setup Charge',NULL,1.0000,642,NULL)}
go
{CALL CT_Configs(1,1,0,6,644,NULL,2,'Enforce Chronological Invoice Void',NULL,1.0000,644,NULL)}
go
{CALL CT_Configs(1,1,0,6,646,NULL,0,'Rating Charge Delay (Days)',NULL,2.0000,646,NULL)}
go
{CALL CT_Configs(1,1,0,6,647,NULL,2,'Rating Allow Interim Charges',NULL,.0000,647,NULL)}
go
{CALL CT_Configs(1,0,0,8,648,NULL,0,'Bad password lockout interval (secs)',NULL,20.0000,31,NULL)}
go
{CALL CT_Configs(1,1,0,6,649,NULL,0,'New MBR Default Credit Limit',NULL,.0000,644,NULL)}
go
{CALL CT_Configs(1,0,0,19,650,NULL,2,'Enforce Bytes Left',NULL,1.0000,35,NULL)}
go
{CALL CT_Configs(1,1,0,6,651,NULL,2,'Auto void failed CC/EFT on 0 or credit balance',NULL,1.0000,345,NULL)}
go
{CALL CT_Configs(1,0,0,8,652,NULL,2,'Bad password lockout after',NULL,2.0000,32,NULL)}
go
{CALL CT_Configs(1,0,1,17,670,NULL,2,'CSRF Countermeasures',NULL,1.0000,30,NULL)}
go
{CALL CT_Configs(1,0,0,20,671,NULL,2,'Batch Invoice & Statement Processing',NULL,1.0000,10,NULL)}
go
{CALL CT_Configs(1,0,0,20,672,NULL,2,'CC/EFT Transactions',NULL,1.0000,20,NULL)}
go
{CALL CT_Configs(1,0,0,20,673,NULL,2,'External System Exports',NULL,1.0000,30,NULL)}
go
{CALL CT_Configs(1,0,0,20,674,NULL,2,'Email/SMS Notification',NULL,1.0000,40,NULL)}
go
{CALL CT_Configs(1,0,0,20,675,NULL,2,'Geocoding',NULL,1.0000,50,NULL)}
go
{CALL CT_Configs(1,0,0,19,680,NULL,2,'Enforce Authorization Change',NULL,1.0000,37,NULL)}
go
{CALL CT_Configs(1,0,0,19,681,NULL,0,'Authorization Check Interval (secs)',NULL,300.0000,55,NULL)}
go
{CALL CT_Configs(1,0,0,19,682,NULL,2,'Enable Service Restoration',NULL,.0000,43,NULL)}
go
{CALL CT_Configs(1,0,0,19,683,NULL,0,'Restore Check Interval (secs)',NULL,90.0000,58,NULL)}
go
{CALL CT_Configs(1,1,0,14,690,NULL,3,'Customer Website Change Billing Address',NULL,NULL,690,'{CALL ListConfigBillAddressTypes}')}
go
{CALL CT_Configs(1,1,0,14,691,NULL,2,'Customer Website Allow Promo Codes',NULL,.0000,517,NULL)}
go
{CALL CT_Configs(1,1,0,14,692,NULL,2,'Customer Website Allow Send Method Change',NULL,.0000,503,NULL)}
go
{CALL CT_Configs(1,1,0,14,693,NULL,0,'Customer Website Billing History Months',NULL,4.0000,522,NULL)}
go
{CALL CT_Configs(1,1,0,14,695,NULL,2,'Customer Website Payment on Credit Balance',NULL,.0000,502,NULL)}
go
{CALL CT_Configs(1,1,0,14,696,NULL,2,'Customer Website Payment on CC/EFT Auto',NULL,.0000,502,NULL)}
go
{CALL CT_Configs(1,1,0,14,697,NULL,2,'Customer Website Allow EFT',NULL,.0000,521,NULL)}
go
{CALL CT_Configs(1,1,0,6,698,NULL,2,'Credits reduce taxable amount',NULL,1.0000,39,NULL)}
go
{CALL CT_Configs(1,0,0,11,700,NULL,0,'Trim days for API tokens',NULL,183.0000,201,NULL)}
go
{CALL CT_Configs(1,0,0,6,701,NULL,0,'Allow CC/EFT New Payment Void (Hours)',NULL,17.0000,350,NULL)}
go
{CALL CT_Configs(1,0,0,6,702,NULL,2,'Gapless Invoice Numbering',NULL,.0000,38,NULL)}
go
{CALL CT_Configs(1,0,1,8,703,NULL,2,'Web links',NULL,.0000,703,NULL)}
go
{CALL CT_Configs(1,0,1,8,704,NULL,2,'HTML editor',NULL,2.0000,702,NULL)}
go
{CALL CT_Configs(1,1,0,6,705,NULL,3,'Check Payment Fee',NULL,NULL,200,'{CALL ListConfigChargeTypes}')}
go
{CALL CT_Configs(1,1,0,6,706,NULL,3,'CC Payment Fee',NULL,NULL,200,'{CALL ListConfigChargeTypes}')}
go
{CALL CT_Configs(1,1,0,6,707,NULL,3,'EFT Payment Fee',NULL,NULL,200,'{CALL ListConfigChargeTypes}')}
go
{CALL CT_Configs(1,1,0,14,708,NULL,2,'Customer Website Child Service Management',NULL,.0000,522,NULL)}
go
{CALL CT_Configs(1,0,1,8,709,NULL,0,'Max months of timeline changes to display',NULL,60.0000,304,NULL)}
go
{CALL CT_Configs(1,0,1,17,710,NULL,2,'Incident Actions',NULL,.0000,228,NULL)}
go
{CALL CT_Configs(1,1,0,6,711,NULL,0,'CC Payment Fee (Percentage)',NULL,NULL,200,NULL)}
go
{CALL CT_Configs(1,1,0,6,712,NULL,2,'Time and Data Left nonrecurring purchases',NULL,1.0000,504,NULL)}
go
{CALL CT_Configs(1,0,0,5,713,NULL,2,'Allow HTML to PDF when emailing PDF',NULL,.0000,10,NULL)}
go
{CALL CT_Configs(1,1,0,6,714,NULL,2,'CC/EFT auto pay for POS Invoices',NULL,.0000,340,NULL)}
go
{CALL CT_Configs(1,0,1,17,715,NULL,2,'Password Complexity',NULL,.0000,223,NULL)}
go
{CALL CT_Configs(1,0,1,17,716,NULL,0,'Min Password Length',NULL,NULL,223,NULL)}
go
{CALL CT_Configs(1,0,0,5,717,NULL,2,'Allow HTML to PDF when printing PDF',NULL,.0000,10,NULL)}
go
{CALL CT_Configs(1,0,0,1,718,NULL,1,'Access-Control-Allow-Origin',NULL,NULL,2000,NULL)}
go
{CALL CT_Configs(1,0,0,1,719,NULL,1,'X-Frame-Options',NULL,NULL,2000,NULL)}
go
{CALL CT_Configs(1,1,0,6,720,NULL,0,'Reinvoice Invoice Void Limit (Count)',NULL,NULL,38,NULL)}
go
{CALL CT_Configs(1,0,0,1,721,NULL,2,'Strict Transport Security',NULL,.0000,1900,NULL)}
go
{CALL CT_Configs(1,1,0,6,722,NULL,0,'Prorate of less than (Days) adds following month',NULL,14.0000,38,NULL)}
go
{CALL CT_Configs(1,0,1,8,723,NULL,2,'Default account search status',NULL,5.0000,400,NULL)}
go
{CALL CT_Configs(1,1,0,6,724,NULL,2,'Email 0 Balance or Credit Invoices',NULL,1.0000,39,NULL)}
go
{CALL CT_Configs(1,1,0,6,725,NULL,2,'Email 0 Balance or Credit Statements',NULL,1.0000,39,NULL)}
go
{CALL CT_Configs(1,0,1,17,726,NULL,2,'Dishonor CC Transactions',NULL,.0000,224,NULL)}
go
{CALL CT_Configs(1,0,1,17,727,NULL,2,'Dishonor EFT Transactions',NULL,1.0000,224,NULL)}
go
{CALL CT_Configs(1,0,1,16,728,NULL,0,'Incident Search - FTS Result Limit',NULL,3000.0000,313,NULL)}
go
{CALL CT_Configs(1,0,1,17,729,NULL,2,'Organization Level Reporting',NULL,.0000,226,NULL)}
go
{CALL CT_Configs(1,0,1,17,733,NULL,2,'Require PIN for MBR Access',NULL,.0000,228,NULL)}
go
{CALL CT_Configs(1,0,0,11,734,NULL,0,'Trim days for Operator PIN Authorization',NULL,183.0000,734,NULL)}
go
{CALL CT_Configs(1,0,1,17,735,NULL,2,'Parent Service Closing',NULL,1.0000,225,NULL)}
go
{CALL CT_Configs(1,1,0,6,737,NULL,2,'Non Recurring MBR Expired Auto Inactivate After',NULL,.0000,377,NULL)}
go
{CALL CT_ConfigValues(1,1.0000,'US, Canada, Mexico')}
go
{CALL CT_ConfigValues(7,.0000,'Disabled')}
go
{CALL CT_ConfigValues(7,10.0000,'Numeric 3 digits')}
go
{CALL CT_ConfigValues(7,20.0000,'Numeric 5 digits')}
go
{CALL CT_ConfigValues(7,30.0000,'Numeric 7 digits')}
go
{CALL CT_ConfigValues(7,40.0000,'Mixed case 5 characters')}
go
{CALL CT_ConfigValues(7,41.0000,'Mixed case 6 characters')}
go
{CALL CT_ConfigValues(7,50.0000,'Mixed case 7 characters')}
go
{CALL CT_ConfigValues(7,60.0000,'Mixed case 8 characters')}
go
{CALL CT_ConfigValues(7,70.0000,'Mixed case 10 characters')}
go
{CALL CT_ConfigValues(7,80.0000,'Alphanumeric 6 characters')}
go
{CALL CT_ConfigValues(7,90.0000,'Alphanumeric 8 characters')}
go
{CALL CT_ConfigValues(7,100.0000,'Alphanumeric 10 characters')}
go
{CALL CT_ConfigValues(7,110.0000,'Alphanumeric 16 characters')}
go
{CALL CT_ConfigValues(7,120.0000,'Alphanumeric + Symbols 8 characters')}
go
{CALL CT_ConfigValues(7,130.0000,'Alphanumeric + Symbols 16 characters')}
go
{CALL CT_ConfigValues(7,140.0000,'Alphanumeric + Symbols 20 characters')}
go
{CALL CT_ConfigValues(10,.0000,'None')}
go
{CALL CT_ConfigValues(10,1.0000,'(Passphrase) or (Mixed Case)')}
go
{CALL CT_ConfigValues(10,2.0000,'(Passphrase) or (Mixed Case) or (Lower + Num or Sym)')}
go
{CALL CT_ConfigValues(10,3.0000,'(Passphrase) or (Alpha + Num or Sym)')}
go
{CALL CT_ConfigValues(10,4.0000,'(Passphrase) or (Alpha + Num + Sym)')}
go
{CALL CT_ConfigValues(10,5.0000,'(Passphrase) or (Mixed Case + Num or Sym)')}
go
{CALL CT_ConfigValues(10,6.0000,'(Passphrase) or (Mixed Case + Num + Sym)')}
go
{CALL CT_ConfigValues(10,7.0000,'(Passphrase) or (Mixed Case + 2x Num or Sym)')}
go
{CALL CT_ConfigValues(10,8.0000,'(Passphrase) or (Mixed Case + 2x Num + 2x Sym)')}
go
{CALL CT_ConfigValues(10,9.0000,'Mixed Case')}
go
{CALL CT_ConfigValues(10,10.0000,'Mixed Case + Num or Sym')}
go
{CALL CT_ConfigValues(10,11.0000,'Mixed Case + Num + Sym')}
go
{CALL CT_ConfigValues(10,12.0000,'(Passphrase) or 3x (Lower + Upper + Num + Sym)')}
go
{CALL CT_ConfigValues(10,13.0000,'Alpha or Num or Sym')}
go
{CALL CT_ConfigValues(14,.0000,'No')}
go
{CALL CT_ConfigValues(14,1.0000,'Yes')}
go
{CALL CT_ConfigValues(16,.0000,'No')}
go
{CALL CT_ConfigValues(16,1.0000,'Yes')}
go
{CALL CT_ConfigValues(18,1.0000,'HTML')}
go
{CALL CT_ConfigValues(18,2.0000,'PDF')}
go
{CALL CT_ConfigValues(18,3.0000,'RTF')}
go
{CALL CT_ConfigValues(18,4.0000,'MS Word')}
go
{CALL CT_ConfigValues(20,1.0000,'By Domain')}
go
{CALL CT_ConfigValues(20,2.0000,'By Global')}
go
{CALL CT_ConfigValues(20,4.0000,'By Service Type')}
go
{CALL CT_ConfigValues(20,8.0000,'By Service Category')}
go
{CALL CT_ConfigValues(20,16.0000,'By External System')}
go
{CALL CT_ConfigValues(20,32.0000,'By Billing Group')}
go
{CALL CT_ConfigValues(20,64.0000,'By MBR')}
go
{CALL CT_ConfigValues(20,128.0000,'Exclude MBR')}
go
{CALL CT_ConfigValues(33,.0000,'None')}
go
{CALL CT_ConfigValues(33,1.0000,'Low ASCII')}
go
{CALL CT_ConfigValues(33,2.0000,'Email Characters')}
go
{CALL CT_ConfigValues(33,3.0000,'Alphanumeric')}
go
{CALL CT_ConfigValues(33,4.0000,'Numeric Only')}
go
{CALL CT_ConfigValues(34,.0000,'No')}
go
{CALL CT_ConfigValues(34,1.0000,'Yes')}
go
{CALL CT_ConfigValues(38,.0000,'No - Current Balance')}
go
{CALL CT_ConfigValues(38,1.0000,'Yes')}
go
{CALL CT_ConfigValues(38,30.0000,'No - 30 Day Balance')}
go
{CALL CT_ConfigValues(38,60.0000,'No - 60 Day Balance')}
go
{CALL CT_ConfigValues(38,90.0000,'No - 90 Day Balance')}
go
{CALL CT_ConfigValues(38,120.0000,'No - 120 Day Balance')}
go
{CALL CT_ConfigValues(40,.0000,'No')}
go
{CALL CT_ConfigValues(40,1.0000,'Yes')}
go
{CALL CT_ConfigValues(41,.0000,'No')}
go
{CALL CT_ConfigValues(41,1.0000,'Yes')}
go
{CALL CT_ConfigValues(59,.0000,'No (Not Recommended)')}
go
{CALL CT_ConfigValues(59,1.0000,'Yes (Recommended)')}
go
{CALL CT_ConfigValues(60,.0000,'Disabled (Insecure)')}
go
{CALL CT_ConfigValues(60,1.0000,'Required')}
go
{CALL CT_ConfigValues(223,.0000,'Show Passwords')}
go
{CALL CT_ConfigValues(223,1.0000,'Hide Passwords')}
go
{CALL CT_ConfigValues(224,.0000,'Show Secure Data')}
go
{CALL CT_ConfigValues(224,1.0000,'Hide Secure Data')}
go
{CALL CT_ConfigValues(224,2.0000,'Show Only Last 4 Characters')}
go
{CALL CT_ConfigValues(224,3.0000,'Show First 6 + Last 4 Characters')}
go
{CALL CT_ConfigValues(240,2.0000,'Cash')}
go
{CALL CT_ConfigValues(240,4.0000,'Check')}
go
{CALL CT_ConfigValues(240,8.0000,'Credit Card')}
go
{CALL CT_ConfigValues(240,16.0000,'Bank Transfer')}
go
{CALL CT_ConfigValues(240,32.0000,'Pre-Paid Card')}
go
{CALL CT_ConfigValues(240,64.0000,'Cash - Other #1')}
go
{CALL CT_ConfigValues(240,128.0000,'Cash - Other #2')}
go
{CALL CT_ConfigValues(240,256.0000,'Cash - Other #3')}
go
{CALL CT_ConfigValues(240,512.0000,'Cash - Other #4')}
go
{CALL CT_ConfigValues(240,1024.0000,'Cash - Other #5')}
go
{CALL CT_ConfigValues(240,2048.0000,'Cash - Other #6')}
go
{CALL CT_ConfigValues(240,4096.0000,'Cash - Other #7')}
go
{CALL CT_ConfigValues(240,8192.0000,'Cash - Other #8')}
go
{CALL CT_ConfigValues(240,16384.0000,'Cash - Other #9')}
go
{CALL CT_ConfigValues(240,32768.0000,'Cash - Other #10')}
go
{CALL CT_ConfigValues(240,65536.0000,'Cash - Other #11')}
go
{CALL CT_ConfigValues(240,131072.0000,'Cash - Other #12')}
go
{CALL CT_ConfigValues(240,262144.0000,'Cash - Other #13')}
go
{CALL CT_ConfigValues(240,524288.0000,'Cash - Other #14')}
go
{CALL CT_ConfigValues(240,1048576.0000,'Cash - Other #15')}
go
{CALL CT_ConfigValues(247,.0000,'Disallow Operator Preference')}
go
{CALL CT_ConfigValues(247,1.0000,'Allow Operator Preference')}
go
{CALL CT_ConfigValues(248,.0000,'Disallow Operator Preference')}
go
{CALL CT_ConfigValues(248,1.0000,'Allow Operator Preference')}
go
{CALL CT_ConfigValues(249,.0000,'Self Only')}
go
{CALL CT_ConfigValues(249,1.0000,'Operators with Common Roles')}
go
{CALL CT_ConfigValues(249,2.0000,'All Operators of any Role')}
go
{CALL CT_ConfigValues(316,.0000,'Disabled')}
go
{CALL CT_ConfigValues(316,1.0000,'Monitor Keyboard')}
go
{CALL CT_ConfigValues(323,.0000,'Hide')}
go
{CALL CT_ConfigValues(323,1.0000,'Show')}
go
{CALL CT_ConfigValues(324,.0000,'Hide')}
go
{CALL CT_ConfigValues(324,1.0000,'Show')}
go
{CALL CT_ConfigValues(327,.0000,'No')}
go
{CALL CT_ConfigValues(327,1.0000,'Yes')}
go
{CALL CT_ConfigValues(376,.0000,'Disabled')}
go
{CALL CT_ConfigValues(376,30.0000,'30 Days')}
go
{CALL CT_ConfigValues(376,45.0000,'45 Days')}
go
{CALL CT_ConfigValues(376,60.0000,'60 Days')}
go
{CALL CT_ConfigValues(376,90.0000,'90 Days')}
go
{CALL CT_ConfigValues(376,120.0000,'120 Days')}
go
{CALL CT_ConfigValues(376,150.0000,'5 Months')}
go
{CALL CT_ConfigValues(376,182.0000,'6 Months')}
go
{CALL CT_ConfigValues(376,210.0000,'7 Months')}
go
{CALL CT_ConfigValues(376,240.0000,'8 Months')}
go
{CALL CT_ConfigValues(376,270.0000,'9 Months')}
go
{CALL CT_ConfigValues(376,300.0000,'10 Months')}
go
{CALL CT_ConfigValues(376,330.0000,'11 Months')}
go
{CALL CT_ConfigValues(376,365.0000,'1 Year')}
go
{CALL CT_ConfigValues(376,730.0000,'2 Years')}
go
{CALL CT_ConfigValues(376,1095.0000,'3 Years')}
go
{CALL CT_ConfigValues(377,.0000,'No')}
go
{CALL CT_ConfigValues(377,1.0000,'Yes')}
go
{CALL CT_ConfigValues(390,1.0000,'MMDDYY')}
go
{CALL CT_ConfigValues(390,2.0000,'DDMMYY')}
go
{CALL CT_ConfigValues(390,3.0000,'YYMMDD')}
go
{CALL CT_ConfigValues(390,4.0000,'YYDDMM')}
go
{CALL CT_ConfigValues(390,5.0000,'MMDDCCYY')}
go
{CALL CT_ConfigValues(390,6.0000,'DDMMCCYY')}
go
{CALL CT_ConfigValues(390,7.0000,'CCYYMMDD')}
go
{CALL CT_ConfigValues(390,8.0000,'CCYYDDMM')}
go
{CALL CT_ConfigValues(392,1.0000,'Imperial (US)')}
go
{CALL CT_ConfigValues(392,2.0000,'Metric')}
go
{CALL CT_ConfigValues(393,1.0000,'HH24:MI:SS')}
go
{CALL CT_ConfigValues(393,2.0000,'HH12:MI:SS')}
go
{CALL CT_ConfigValues(393,3.0000,'HH24:MI')}
go
{CALL CT_ConfigValues(393,4.0000,'HH12:MI')}
go
{CALL CT_ConfigValues(501,.0000,'No')}
go
{CALL CT_ConfigValues(501,1.0000,'Yes')}
go
{CALL CT_ConfigValues(503,.0000,'No')}
go
{CALL CT_ConfigValues(503,1.0000,'Yes')}
go
{CALL CT_ConfigValues(504,.0000,'No')}
go
{CALL CT_ConfigValues(504,1.0000,'Yes')}
go
{CALL CT_ConfigValues(506,.0000,'No')}
go
{CALL CT_ConfigValues(506,1.0000,'Yes')}
go
{CALL CT_ConfigValues(507,.0000,'No')}
go
{CALL CT_ConfigValues(507,1.0000,'Yes')}
go
{CALL CT_ConfigValues(514,.0000,'No')}
go
{CALL CT_ConfigValues(514,1.0000,'Yes')}
go
{CALL CT_ConfigValues(515,.0000,'No')}
go
{CALL CT_ConfigValues(515,1.0000,'Yes')}
go
{CALL CT_ConfigValues(516,.0000,'No')}
go
{CALL CT_ConfigValues(516,1.0000,'Yes')}
go
{CALL CT_ConfigValues(519,.0000,'No')}
go
{CALL CT_ConfigValues(519,1.0000,'Yes')}
go
{CALL CT_ConfigValues(521,.0000,'No')}
go
{CALL CT_ConfigValues(521,1.0000,'Yes')}
go
{CALL CT_ConfigValues(522,.0000,'No')}
go
{CALL CT_ConfigValues(522,1.0000,'Yes')}
go
{CALL CT_ConfigValues(523,.0000,'None')}
go
{CALL CT_ConfigValues(523,1.0000,'First & Last Name')}
go
{CALL CT_ConfigValues(523,2.0000,'First & Last Name + Random')}
go
{CALL CT_ConfigValues(523,3.0000,'First Name + Last Initial')}
go
{CALL CT_ConfigValues(523,4.0000,'First Name + Last Initial + Random')}
go
{CALL CT_ConfigValues(523,5.0000,'First Name')}
go
{CALL CT_ConfigValues(523,6.0000,'First Name + Random')}
go
{CALL CT_ConfigValues(523,7.0000,'Last Name')}
go
{CALL CT_ConfigValues(523,8.0000,'Last Name + Random')}
go
{CALL CT_ConfigValues(523,9.0000,'Random Number')}
go
{CALL CT_ConfigValues(526,.0000,'No')}
go
{CALL CT_ConfigValues(526,1.0000,'Yes')}
go
{CALL CT_ConfigValues(528,.0000,'No')}
go
{CALL CT_ConfigValues(528,1.0000,'Yes')}
go
{CALL CT_ConfigValues(529,.0000,'No')}
go
{CALL CT_ConfigValues(529,1.0000,'Yes')}
go
{CALL CT_ConfigValues(531,.0000,'No')}
go
{CALL CT_ConfigValues(531,1.0000,'Yes')}
go
{CALL CT_ConfigValues(533,1.0000,'CC or MBR Address')}
go
{CALL CT_ConfigValues(533,2.0000,'CC Address')}
go
{CALL CT_ConfigValues(533,3.0000,'None')}
go
{CALL CT_ConfigValues(535,1.0000,'Simple (Flat)')}
go
{CALL CT_ConfigValues(535,2.0000,'Detailed (Historical)')}
go
{CALL CT_ConfigValues(603,.0000,'Amount is min amount paid')}
go
{CALL CT_ConfigValues(603,1.0000,'Amount is  min percent  paid')}
go
{CALL CT_ConfigValues(603,2.0000,'Proportional to payment')}
go
{CALL CT_ConfigValues(603,3.0000,'Full payment required')}
go
{CALL CT_ConfigValues(632,.0000,'No')}
go
{CALL CT_ConfigValues(632,1.0000,'Yes')}
go
{CALL CT_ConfigValues(633,1.0000,'Section messages')}
go
{CALL CT_ConfigValues(633,2.0000,'SQL queries')}
go
{CALL CT_ConfigValues(633,4.0000,'RADIUS disconnect')}
go
{CALL CT_ConfigValues(633,16.0000,'Detailed status messages')}
go
{CALL CT_ConfigValues(633,32.0000,'Rating engine messages')}
go
{CALL CT_ConfigValues(634,.0000,'No')}
go
{CALL CT_ConfigValues(634,1.0000,'Yes')}
go
{CALL CT_ConfigValues(635,.0000,'No')}
go
{CALL CT_ConfigValues(635,1.0000,'Yes')}
go
{CALL CT_ConfigValues(636,.0000,'No')}
go
{CALL CT_ConfigValues(636,1.0000,'Yes')}
go
{CALL CT_ConfigValues(639,.0000,'No')}
go
{CALL CT_ConfigValues(639,1.0000,'Yes')}
go
{CALL CT_ConfigValues(640,.0000,'No')}
go
{CALL CT_ConfigValues(640,1.0000,'Yes')}
go
{CALL CT_ConfigValues(641,.0000,'No')}
go
{CALL CT_ConfigValues(641,1.0000,'Yes')}
go
{CALL CT_ConfigValues(642,.0000,'No')}
go
{CALL CT_ConfigValues(642,1.0000,'Yes')}
go
{CALL CT_ConfigValues(644,.0000,'No (Not Recommended)')}
go
{CALL CT_ConfigValues(644,1.0000,'Yes (Recommended)')}
go
{CALL CT_ConfigValues(647,.0000,'No (Recommended)')}
go
{CALL CT_ConfigValues(647,1.0000,'Yes (Not Recommended)')}
go
{CALL CT_ConfigValues(650,.0000,'No')}
go
{CALL CT_ConfigValues(650,1.0000,'Yes')}
go
{CALL CT_ConfigValues(651,.0000,'No')}
go
{CALL CT_ConfigValues(651,1.0000,'Yes')}
go
{CALL CT_ConfigValues(652,1.0000,'1 Attempt')}
go
{CALL CT_ConfigValues(652,2.0000,'2 Attempts')}
go
{CALL CT_ConfigValues(652,3.0000,'3 Attempts')}
go
{CALL CT_ConfigValues(652,4.0000,'4 Attempts')}
go
{CALL CT_ConfigValues(652,5.0000,'5 Attempts')}
go
{CALL CT_ConfigValues(652,6.0000,'6 Attempts')}
go
{CALL CT_ConfigValues(652,7.0000,'7 Attempts')}
go
{CALL CT_ConfigValues(652,8.0000,'8 Attempts')}
go
{CALL CT_ConfigValues(652,9.0000,'9 Attempts')}
go
{CALL CT_ConfigValues(652,10.0000,'10 Attempts')}
go
{CALL CT_ConfigValues(670,.0000,'None (Not Recommended)')}
go
{CALL CT_ConfigValues(670,1.0000,'Yes (Recommended)')}
go
{CALL CT_ConfigValues(671,.0000,'Disabled')}
go
{CALL CT_ConfigValues(671,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(672,.0000,'Disabled')}
go
{CALL CT_ConfigValues(672,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(673,.0000,'Disabled')}
go
{CALL CT_ConfigValues(673,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(674,.0000,'Disabled')}
go
{CALL CT_ConfigValues(674,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(675,.0000,'Disabled')}
go
{CALL CT_ConfigValues(675,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(680,.0000,'No')}
go
{CALL CT_ConfigValues(680,1.0000,'Yes')}
go
{CALL CT_ConfigValues(682,.0000,'No')}
go
{CALL CT_ConfigValues(682,1.0000,'Yes')}
go
{CALL CT_ConfigValues(691,.0000,'No')}
go
{CALL CT_ConfigValues(691,1.0000,'Yes')}
go
{CALL CT_ConfigValues(692,.0000,'No')}
go
{CALL CT_ConfigValues(692,1.0000,'Yes')}
go
{CALL CT_ConfigValues(695,.0000,'No')}
go
{CALL CT_ConfigValues(695,1.0000,'Yes')}
go
{CALL CT_ConfigValues(696,.0000,'No')}
go
{CALL CT_ConfigValues(696,1.0000,'Yes')}
go
{CALL CT_ConfigValues(697,.0000,'No (Recommended)')}
go
{CALL CT_ConfigValues(697,1.0000,'Yes')}
go
{CALL CT_ConfigValues(698,.0000,'Disabled')}
go
{CALL CT_ConfigValues(698,1.0000,'Enabled - Within Invoice')}
go
{CALL CT_ConfigValues(702,.0000,'Disabled (Recommended)')}
go
{CALL CT_ConfigValues(702,1.0000,'Enabled (Not Recommended)')}
go
{CALL CT_ConfigValues(703,.0000,'Open Normally')}
go
{CALL CT_ConfigValues(703,1.0000,'Open in New Window')}
go
{CALL CT_ConfigValues(704,.0000,'None')}
go
{CALL CT_ConfigValues(704,1.0000,'NicEdit')}
go
{CALL CT_ConfigValues(704,2.0000,'TinyMCE')}
go
{CALL CT_ConfigValues(708,.0000,'Manager Access (Recommended)')}
go
{CALL CT_ConfigValues(708,1.0000,'Manager or Service Access')}
go
{CALL CT_ConfigValues(710,.0000,'Add Only')}
go
{CALL CT_ConfigValues(710,1.0000,'Add & Change Self')}
go
{CALL CT_ConfigValues(710,2.0000,'Add & Change Any')}
go
{CALL CT_ConfigValues(712,1.0000,'If expired replace existing time and data')}
go
{CALL CT_ConfigValues(712,2.0000,'If expired add to existing time and data')}
go
{CALL CT_ConfigValues(713,.0000,'Disabled')}
go
{CALL CT_ConfigValues(713,1.0000,'Convert using wkhtmltopdf')}
go
{CALL CT_ConfigValues(714,.0000,'Disabled')}
go
{CALL CT_ConfigValues(714,1.0000,'Enabled')}
go
{CALL CT_ConfigValues(714,2.0000,'Add Unpaid')}
go
{CALL CT_ConfigValues(715,.0000,'Billing Group Defaults')}
go
{CALL CT_ConfigValues(715,1.0000,'(Passphrase) or (Mixed Case)')}
go
{CALL CT_ConfigValues(715,2.0000,'(Passphrase) or (Mixed Case) or (Lower + Num or Sym)')}
go
{CALL CT_ConfigValues(715,3.0000,'(Passphrase) or (Alpha + Num or Sym)')}
go
{CALL CT_ConfigValues(715,4.0000,'(Passphrase) or (Alpha + Num + Sym)')}
go
{CALL CT_ConfigValues(715,5.0000,'(Passphrase) or (Mixed Case + Num or Sym)')}
go
{CALL CT_ConfigValues(715,6.0000,'(Passphrase) or (Mixed Case + Num + Sym)')}
go
{CALL CT_ConfigValues(715,7.0000,'(Passphrase) or (Mixed Case + 2x Num or Sym)')}
go
{CALL CT_ConfigValues(715,8.0000,'(Passphrase) or (Mixed Case + 2x Num + 2x Sym)')}
go
{CALL CT_ConfigValues(715,9.0000,'Mixed Case')}
go
{CALL CT_ConfigValues(715,10.0000,'Mixed Case + Num or Sym')}
go
{CALL CT_ConfigValues(715,11.0000,'Mixed Case + Num + Sym')}
go
{CALL CT_ConfigValues(715,12.0000,'(Passphrase) or 3x (Lower + Upper + Num + Sym)')}
go
{CALL CT_ConfigValues(715,13.0000,'Alpha or Num or Sym')}
go
{CALL CT_ConfigValues(717,.0000,'Disabled')}
go
{CALL CT_ConfigValues(717,1.0000,'Convert using wkhtmltopdf')}
go
{CALL CT_ConfigValues(721,.0000,'Default')}
go
{CALL CT_ConfigValues(721,31536000.0000,'Enabled')}
go
{CALL CT_ConfigValues(723,.0000,'All')}
go
{CALL CT_ConfigValues(723,1.0000,'Active')}
go
{CALL CT_ConfigValues(723,3.0000,'Canceled')}
go
{CALL CT_ConfigValues(723,4.0000,'Inactive')}
go
{CALL CT_ConfigValues(723,5.0000,'Normal')}
go
{CALL CT_ConfigValues(724,.0000,'No')}
go
{CALL CT_ConfigValues(724,1.0000,'Yes')}
go
{CALL CT_ConfigValues(725,.0000,'No - Current Balance')}
go
{CALL CT_ConfigValues(725,1.0000,'Yes')}
go
{CALL CT_ConfigValues(725,30.0000,'No - 30 Day Balance')}
go
{CALL CT_ConfigValues(725,60.0000,'No - 60 Day Balance')}
go
{CALL CT_ConfigValues(725,90.0000,'No - 90 Day Balance')}
go
{CALL CT_ConfigValues(725,120.0000,'No - 120 Day Balance')}
go
{CALL CT_ConfigValues(726,.0000,'Disallow Dishonor Payment')}
go
{CALL CT_ConfigValues(726,1.0000,'Allow Dishonor Payment')}
go
{CALL CT_ConfigValues(727,.0000,'Disallow Dishonor Payment')}
go
{CALL CT_ConfigValues(727,1.0000,'Allow Dishonor Payment')}
go
{CALL CT_ConfigValues(729,.0000,'Requires access to one or more groups of the organization')}
go
{CALL CT_ConfigValues(729,1.0000,'Requires access to ALL groups of the organization')}
go
{CALL CT_ConfigValues(729,2.0000,'Requires access to ALL active groups of the organization')}
go
{CALL CT_ConfigValues(733,.0000,'Disabled')}
go
{CALL CT_ConfigValues(733,1800.0000,'Enabled - Expires After 30 Mins')}
go
{CALL CT_ConfigValues(733,3600.0000,'Enabled - Expires After 1 Hour')}
go
{CALL CT_ConfigValues(733,7200.0000,'Enabled - Expires After 2 Hours')}
go
{CALL CT_ConfigValues(733,10800.0000,'Enabled - Expires After 3 Hours')}
go
{CALL CT_ConfigValues(733,14400.0000,'Enabled - Expires After 4 Hours')}
go
{CALL CT_ConfigValues(733,18000.0000,'Enabled - Expires After 5 Hours')}
go
{CALL CT_ConfigValues(733,21600.0000,'Enabled - Expires After 6 Hours')}
go
{CALL CT_ConfigValues(733,43200.0000,'Enabled - Expires After 12 Hours')}
go
{CALL CT_ConfigValues(733,86400.0000,'Enabled - Expires After 1 Day')}
go
{CALL CT_ConfigValues(733,172800.0000,'Enabled - Expires After 2 Days')}
go
{CALL CT_ConfigValues(733,259200.0000,'Enabled - Expires After 3 Days')}
go
{CALL CT_ConfigValues(733,345600.0000,'Enabled - Expires After 4 Days')}
go
{CALL CT_ConfigValues(733,432000.0000,'Enabled - Expires After 5 Days')}
go
{CALL CT_ConfigValues(733,518400.0000,'Enabled - Expires After 6 Days')}
go
{CALL CT_ConfigValues(733,604800.0000,'Enabled - Expires After 1 Week')}
go
{CALL CT_ConfigValues(735,.0000,'Disallow child services from remaining open')}
go
{CALL CT_ConfigValues(735,1.0000,'Allow child services to remain open')}
go
{CALL CT_ConfigValues(737,.0000,'Disabled')}
go
{CALL CT_ConfigValues(737,30.0000,'30 Days')}
go
{CALL CT_ConfigValues(737,60.0000,'60 Days')}
go
{CALL CT_ConfigValues(737,90.0000,'90 Days')}
go
{CALL CT_ConfigValues(737,120.0000,'120 Days')}
go
{CALL CT_ConfigValues(737,182.0000,'6 Months')}
go
{CALL CT_ConfigValues(737,365.0000,'1 Year')}
go
{CALL CT_ConfigValues(737,730.0000,'2 Years')}
go
{CALL CT_ConfigValues(737,1095.0000,'3 Years')}
go
{CALL CT_ConfigValues(737,1460.0000,'4 Years')}
go
{CALL CT_ConfigValues(737,1825.0000,'5 Years')}
go
{CALL CT2_Continents('Africa',1,0,'Earth',8)}
go
{CALL CT2_Continents('Asia',2,0,'Earth',6)}
go
{CALL CT2_Continents('Europe',3,0,'Earth',2)}
go
{CALL CT2_Continents('North America',4,0,'Earth',1)}
go
{CALL CT2_Continents('South America',5,0,'Earth',4)}
go
{CALL CT2_Continents('Oceania',6,0,'Earth',10)}
go
{CALL CT2_Countries('AF','AFG',NULL,2,'Afghanistan',4,NULL,0,'af',9,0,100,'00',NULL,'0','93',NULL)}
go
{CALL CT2_Countries('AL','ALB',NULL,3,'Albania',8,NULL,0,'al',9,0,100,'00',NULL,'0','355',2)}
go
{CALL CT2_Countries('DZ','DZA',NULL,1,'Algeria',12,NULL,0,'dz',9,0,100,'00',NULL,'7','213',NULL)}
go
{CALL CT2_Countries('AS','ASM',NULL,6,'American Samoa',16,NULL,0,'as',10,0,100,'011',NULL,'1','1-684',2)}
go
{CALL CT2_Countries('AD','AND',NULL,3,'Andorra',20,NULL,0,'ad',NULL,0,100,'00',NULL,NULL,'376',2)}
go
{CALL CT2_Countries('AO','AGO',NULL,1,'Angola',24,NULL,0,'ao',NULL,0,100,'00',NULL,'0','244',2)}
go
{CALL CT2_Countries('AG','ATG',NULL,4,'Antigua and Barbuda',28,NULL,0,'ag',10,0,100,'011',NULL,'1','1',2)}
go
{CALL CT2_Countries('AZ','AZE',NULL,3,'Azerbaijan',31,NULL,0,'az',9,0,100,'00',NULL,'8','994',NULL)}
go
{CALL CT2_Countries('AR','ARG',NULL,5,'Argentina',32,NULL,0,'ar',NULL,0,100,'00',NULL,'0','54',NULL)}
go
{CALL CT2_Countries('AU','AUS',NULL,6,'Australia',36,NULL,0,'au',9,0,100,'0011',NULL,'0','61',NULL)}
go
{CALL CT2_Countries('AT','AUT',NULL,3,'Austria',40,NULL,0,'at',NULL,0,100,'00',NULL,'0','43',NULL)}
go
{CALL CT2_Countries('BS','BHS',NULL,4,'Bahamas',44,NULL,0,'bs',10,0,100,'011',NULL,'1','1-242',2)}
go
{CALL CT2_Countries('BH','BHR',NULL,2,'Bahrain',48,NULL,0,'bh',8,0,100,'00',NULL,NULL,'973',2)}
go
{CALL CT2_Countries('BD','BGD',NULL,2,'Bangladesh',50,NULL,0,'bd',10,0,100,'00',NULL,'0','880',NULL)}
go
{CALL CT2_Countries('AM','ARM',NULL,3,'Armenia',51,NULL,0,'am',6,0,100,'00',NULL,'8','374',NULL)}
go
{CALL CT2_Countries('BB','BRB',NULL,4,'Barbados',52,NULL,0,'bb',10,0,100,'011',NULL,'1','1-246',2)}
go
{CALL CT2_Countries('BE','BEL',NULL,3,'Belgium',56,NULL,0,'be',9,0,100,'00',NULL,'0','32',NULL)}
go
{CALL CT2_Countries('BM','BMU',NULL,4,'Bermuda',60,NULL,0,'bm',10,0,100,'011',NULL,'1','1-444',2)}
go
{CALL CT2_Countries('BT','BTN',NULL,2,'Bhutan',64,NULL,0,'bt',NULL,0,100,'00',NULL,NULL,'975',2)}
go
{CALL CT2_Countries('BO','BOL',NULL,5,'Bolivia',68,NULL,0,'bo',NULL,0,100,'0010',NULL,'010','591',2)}
go
{CALL CT2_Countries('BA','BIH',NULL,3,'Bosnia and Herzegovina',70,NULL,0,'ba',8,0,100,'00',NULL,'0','387',NULL)}
go
{CALL CT2_Countries('BW','BWA',NULL,1,'Botswana',72,NULL,0,'bw',NULL,0,100,'00',NULL,NULL,'267',2)}
go
{CALL CT2_Countries('BR','BRA',NULL,5,'Brazil',76,NULL,0,'br',11,0,100,'0014 0015 0021 0023 0031',NULL,'014 015 021 023 031','55',NULL)}
go
{CALL CT2_Countries('BZ','BLZ',NULL,4,'Belize',84,NULL,0,'bz',7,0,100,'00',NULL,'0','501',2)}
go
{CALL CT2_Countries('SB','SLB',NULL,6,'Solomon Islands',90,NULL,0,'sb',7,0,100,'00',NULL,NULL,'677',2)}
go
{CALL CT2_Countries('VG','VGB',NULL,4,'British Virgin Islands',92,NULL,0,'vi',NULL,0,100,'011',6,'1','1',2)}
go
{CALL CT2_Countries('BN','BRN',NULL,2,'Brunei',96,NULL,0,'bn',NULL,0,100,'00',NULL,'0','673',2)}
go
{CALL CT2_Countries('BG','BGR',NULL,3,'Bulgaria',100,NULL,0,'bg',9,0,100,'00',NULL,'0','359',NULL)}
go
{CALL CT2_Countries('MM','MMR',NULL,2,'Burma',104,NULL,0,'mm',NULL,0,100,'00',NULL,NULL,'95',NULL)}
go
{CALL CT2_Countries('BI','BDI',NULL,1,'Burundi',108,NULL,0,'bi',NULL,0,100,'00',NULL,NULL,'257',2)}
go
{CALL CT2_Countries('BY','BLR',NULL,3,'Belarus',112,NULL,0,'by',9,0,100,'8~10',NULL,'8','375',NULL)}
go
{CALL CT2_Countries('KH','KHM',NULL,2,'Cambodia',116,NULL,0,'kh',9,0,100,'001',NULL,'0','855',2)}
go
{CALL CT2_Countries('CM','CMR',NULL,1,'Cameroon',120,NULL,0,'cm',NULL,0,100,'00',NULL,NULL,'237',2)}
go
{CALL CT2_Countries('CA','CAN',NULL,4,'Canada',124,NULL,0,'ca',10,0,100,'011',6,'1','1',NULL)}
go
{CALL CT2_Countries('CV','CPV',NULL,1,'Cape Verde',132,NULL,0,'cv',NULL,0,100,'0',NULL,NULL,'238',2)}
go
{CALL CT2_Countries('KY','CYM',NULL,4,'Cayman Islands',136,NULL,0,'ky',10,0,100,'011',NULL,'1','1',2)}
go
{CALL CT2_Countries('CF','CAF',NULL,1,'Central African Republic',140,NULL,0,'cf',NULL,0,100,'00',NULL,NULL,'236',2)}
go
{CALL CT2_Countries('LK','LKA',NULL,2,'Sri Lanka',144,NULL,0,'lk',7,0,100,'00',NULL,'0','94',NULL)}
go
{CALL CT2_Countries('TD','TCD',NULL,1,'Chad',148,NULL,0,'td',8,0,100,'15',NULL,NULL,'235',NULL)}
go
{CALL CT2_Countries('CL','CHL',NULL,5,'Chile',152,NULL,0,'cl',9,0,100,'00',NULL,NULL,'56',2)}
go
{CALL CT2_Countries('CN','CHN',NULL,2,'China',156,NULL,0,'cn',NULL,0,100,'00',NULL,'0','86',NULL)}
go
{CALL CT2_Countries('CO','COL',NULL,5,'Colombia',170,NULL,0,'co',10,0,100,'005',NULL,'03','57',2)}
go
{CALL CT2_Countries('KM','COM',NULL,1,'Comoros',174,NULL,0,'km',NULL,0,100,'00',NULL,NULL,'269',NULL)}
go
{CALL CT2_Countries('YT','MYT',NULL,1,'Mayotte',175,NULL,0,'yt',NULL,0,100,'00',NULL,NULL,'269',NULL)}
go
{CALL CT2_Countries('CG','COG',NULL,1,'Congo',178,NULL,0,'cg',NULL,0,100,'00',NULL,NULL,'242',2)}
go
{CALL CT2_Countries('CK','COK',NULL,4,'Cook Islands',184,NULL,0,'ck',5,0,100,'00',NULL,'00','682',2)}
go
{CALL CT2_Countries('CR','CRI',NULL,4,'Costa Rica',188,NULL,0,'cr',8,0,100,'00',NULL,NULL,'506',2)}
go
{CALL CT2_Countries('HR','HRV',NULL,3,'Croatia',191,NULL,0,'hr',9,0,100,'00',NULL,'0','385',NULL)}
go
{CALL CT2_Countries('CU','CUB',NULL,4,'Cuba',192,NULL,0,'cu',NULL,0,100,'119',NULL,'0','53',NULL)}
go
{CALL CT2_Countries('CY','CYP',NULL,3,'Cyprus',196,NULL,0,'cy',8,0,100,'00',NULL,NULL,'357',NULL)}
go
{CALL CT2_Countries('CZ','CZE',NULL,3,'Czech Republic',203,NULL,0,'cz',9,0,100,'00',NULL,NULL,'420',NULL)}
go
{CALL CT2_Countries('BJ','BEN',NULL,1,'Benin',204,NULL,0,'bj',NULL,0,100,'00',NULL,NULL,'229',2)}
go
{CALL CT2_Countries('DK','DNK',NULL,3,'Denmark',208,NULL,0,'dk',8,0,100,'00',NULL,NULL,'45',NULL)}
go
{CALL CT2_Countries('DM','DMA',NULL,4,'Dominica',212,NULL,0,'dm',NULL,0,100,'011',NULL,'1','1-767',2)}
go
{CALL CT2_Countries('DO','DOM',NULL,4,'Dominican Republic',214,NULL,0,'do',10,0,100,'011',NULL,'1','1-767',2)}
go
{CALL CT2_Countries('EC','ECU',NULL,5,'Ecuador',218,NULL,0,'ec',NULL,0,100,'00',NULL,'0','593',2)}
go
{CALL CT2_Countries('SV','SLV',NULL,4,'El Salvador',222,NULL,0,'sv',8,0,100,'00',NULL,NULL,'503',2)}
go
{CALL CT2_Countries('GQ','GNQ',NULL,1,'Equatorial Guinea',226,NULL,0,'gq',NULL,0,100,'00',NULL,NULL,'240',2)}
go
{CALL CT2_Countries('ET','ETH',NULL,1,'Ethiopia',231,NULL,0,'et',NULL,0,100,'00',NULL,'0','251',2)}
go
{CALL CT2_Countries('ER','ERI',NULL,1,'Eritrea',232,NULL,0,'er',NULL,0,100,'00',NULL,'0','291',2)}
go
{CALL CT2_Countries('EE','EST',NULL,3,'Estonia',233,NULL,0,'ee',NULL,0,100,'00',NULL,'0','372',NULL)}
go
{CALL CT2_Countries('FO','FRO',NULL,3,'Faroe Islands',234,NULL,0,'fo',5,0,100,'00',NULL,NULL,'298',NULL)}
go
{CALL CT2_Countries('FK','FLK',NULL,5,'Falkland Islands',238,NULL,0,'fk',5,0,100,'00',NULL,NULL,'500',NULL)}
go
{CALL CT2_Countries('FJ','FJI',NULL,6,'Fiji',242,NULL,0,'fj',NULL,0,100,'00',NULL,NULL,'679',2)}
go
{CALL CT2_Countries('FI','FIN',NULL,3,'Finland',246,NULL,0,'fi',NULL,0,100,'00 990 994 999',NULL,'0','358',NULL)}
go
{CALL CT2_Countries('FR','FRA',NULL,3,'France',250,NULL,0,'fr',9,0,100,'00 40 50 70 90',NULL,'0','33',NULL)}
go
{CALL CT2_Countries('GF','GUF',NULL,1,'Guiana',254,NULL,0,'gf',NULL,0,100,'00',NULL,NULL,'594',2)}
go
{CALL CT2_Countries('PF','PYF',NULL,6,'French Polynesia',258,NULL,0,'pf',6,0,100,'00',NULL,NULL,'689',2)}
go
{CALL CT2_Countries('DJ','DJI',NULL,1,'Djibouti',262,NULL,0,'dj',NULL,0,100,'00',NULL,NULL,'253',2)}
go
{CALL CT2_Countries('GA','GAB',NULL,1,'Gabon',266,NULL,0,'ga',7,0,100,'00',NULL,NULL,'241',2)}
go
{CALL CT2_Countries('GE','GEO',NULL,3,'Georgia',268,NULL,0,'ge',9,0,100,'8~10',NULL,'8','995',NULL)}
go
{CALL CT2_Countries('GM','GMB',NULL,1,'Gambia',270,NULL,0,'gm',NULL,0,100,'00',NULL,NULL,'220',2)}
go
{CALL CT2_Countries('DE','DEU',NULL,3,'Germany',276,NULL,0,'de',10,0,100,'00',NULL,'0','49',NULL)}
go
{CALL CT2_Countries('GH','GHA',NULL,1,'Ghana',288,NULL,0,'gh',9,0,100,'00',NULL,NULL,'233',2)}
go
{CALL CT2_Countries('GI','GIB',NULL,3,'Gibraltar',292,NULL,0,'gi',NULL,0,100,'00',NULL,NULL,'350',2)}
go
{CALL CT2_Countries('KI','KIR',NULL,6,'Kiribati',296,NULL,0,'ki',8,0,100,'00',NULL,'0','686',2)}
go
{CALL CT2_Countries('GR','GRC',NULL,3,'Greece',300,NULL,0,'gr',10,0,100,'00',NULL,NULL,'30',NULL)}
go
{CALL CT2_Countries('GL','GRL',NULL,6,'Greenland',304,NULL,0,'gl',6,0,100,'00',NULL,NULL,'299',NULL)}
go
{CALL CT2_Countries('GD','GRD',NULL,4,'Grenada',308,NULL,0,'gd',NULL,0,100,'011',NULL,'1','1-473',2)}
go
{CALL CT2_Countries('GP','GLP',NULL,4,'Guadeloupe',312,NULL,0,'gp',NULL,0,100,'00',NULL,NULL,'590',2)}
go
{CALL CT2_Countries('GU','GUM',NULL,6,'Guam',316,NULL,0,'gu',10,0,100,'011',6,'1','671',2)}
go
{CALL CT2_Countries('GT','GTM',NULL,4,'Guatemala',320,NULL,0,'gt',8,0,100,'00',NULL,NULL,'502',2)}
go
{CALL CT2_Countries('GN','GIN',NULL,1,'Guinea',324,NULL,0,'gn',NULL,0,100,'00',NULL,'0','224',2)}
go
{CALL CT2_Countries('GY','GUY',NULL,5,'Guyana',328,NULL,0,'gy',NULL,0,100,'001',NULL,'0','592',2)}
go
{CALL CT2_Countries('HT','HTI',NULL,4,'Haiti',332,NULL,0,'ht',NULL,0,100,'00',NULL,'0','509',2)}
go
{CALL CT2_Countries('VA','VAT',NULL,3,'Vatican City State',336,NULL,0,'va',10,0,100,'00',NULL,NULL,'39',NULL)}
go
{CALL CT2_Countries('HN','HND',NULL,4,'Honduras',340,NULL,0,'hn',8,0,100,'00',NULL,'0','504',2)}
go
{CALL CT2_Countries('HK','HKG',NULL,2,'Hong Kong',344,NULL,0,'hk',8,0,100,'001',NULL,NULL,'852',2)}
go
{CALL CT2_Countries('HU','HUN',NULL,3,'Hungary',348,NULL,0,'hu',9,0,100,'00',NULL,'6','36',NULL)}
go
{CALL CT2_Countries('IS','ISL',NULL,3,'Iceland',352,NULL,0,'is',NULL,0,100,'00',NULL,'0','354',NULL)}
go
{CALL CT2_Countries('IN','IND',NULL,2,'India',356,NULL,0,'in',10,0,100,'00',NULL,'0','91',NULL)}
go
{CALL CT2_Countries('ID','IDN',NULL,2,'Indonesia',360,NULL,0,'id',NULL,0,100,'001 008',NULL,'0','62',NULL)}
go
{CALL CT2_Countries('IR','IRN',NULL,2,'Iran',364,NULL,0,'ir',NULL,0,100,'00',NULL,'0','98',NULL)}
go
{CALL CT2_Countries('IQ','IRQ',NULL,2,'Iraq',368,NULL,0,'iq',NULL,0,100,'00',NULL,'0','964',2)}
go
{CALL CT2_Countries('IE','IRL',NULL,3,'Ireland',372,NULL,0,'ie',9,0,100,'00',NULL,'0','353',2)}
go
{CALL CT2_Countries('IL','ISR',NULL,2,'Israel',376,NULL,0,'il',9,0,100,'00 012 013 014',NULL,'0','972',NULL)}
go
{CALL CT2_Countries('IT','ITA',NULL,3,'Italy',380,NULL,0,'it',NULL,0,100,'00',NULL,NULL,'39',NULL)}
go
{CALL CT2_Countries('CI','CIV',NULL,1,'Cote d''Ivoire',384,NULL,0,'ci',NULL,0,100,'00',NULL,'0','225',2)}
go
{CALL CT2_Countries('JM','JAM',NULL,4,'Jamaica',388,NULL,0,'jm',10,0,100,'011',NULL,'1','1-876',2)}
go
{CALL CT2_Countries('JP','JPN',NULL,2,'Japan',392,NULL,0,'jp',11,0,100,'001 010 0061 0041',NULL,'0','81',NULL)}
go
{CALL CT2_Countries('KZ','KAZ',NULL,2,'Kazakhstan',398,NULL,0,'kz',10,0,100,'8~10',NULL,'8','7',NULL)}
go
{CALL CT2_Countries('JO','JOR',NULL,2,'Jordan',400,NULL,0,'jo',NULL,0,100,'00',NULL,'0','962',2)}
go
{CALL CT2_Countries('KE','KEN',NULL,1,'Kenya',404,NULL,0,'ke',10,0,100,'000',NULL,'0','254',2)}
go
{CALL CT2_Countries('KP','PRK',NULL,2,'North Korea',408,NULL,0,'kp',NULL,0,100,'001 002',NULL,'0 082','82',NULL)}
go
{CALL CT2_Countries('KR','KOR',NULL,2,'South Korea',410,NULL,0,'kr',NULL,0,100,'00',NULL,'0','850',NULL)}
go
{CALL CT2_Countries('KW','KWT',NULL,2,'Kuwait',414,NULL,0,'kw',8,0,100,'00',NULL,'0','965',2)}
go
{CALL CT2_Countries('KG','KGZ',NULL,2,'Kyrgyzstan',417,NULL,0,'kg',NULL,0,100,'00',NULL,'0','996',NULL)}
go
{CALL CT2_Countries('LA','LAO',NULL,2,'Laos',418,NULL,0,'la',NULL,0,100,'00',NULL,'0','856',2)}
go
{CALL CT2_Countries('LB','LBN',NULL,2,'Lebanon',422,NULL,0,'lb',NULL,0,100,'00',NULL,'0','961',2)}
go
{CALL CT2_Countries('LS','LSO',NULL,1,'Lesotho',426,NULL,0,'ls',NULL,0,100,'00',NULL,'0','266',2)}
go
{CALL CT2_Countries('LV','LVA',NULL,3,'Latvia',428,NULL,0,'lv',8,0,100,'00',NULL,'8','371',NULL)}
go
{CALL CT2_Countries('LR','LBR',NULL,1,'Liberia',430,NULL,0,'lr',NULL,0,100,'00',NULL,'22','231',2)}
go
{CALL CT2_Countries('LY','LBY',NULL,1,'Libya',434,NULL,0,'ly',NULL,0,100,'00',NULL,'0','218',NULL)}
go
{CALL CT2_Countries('LI','LIE',NULL,3,'Liechtenstein',438,NULL,0,'li',NULL,0,100,'00',NULL,'0','41',NULL)}
go
{CALL CT2_Countries('LT','LTU',NULL,3,'Lithuania',440,NULL,0,'lt',8,0,100,'00',NULL,'8','370',NULL)}
go
{CALL CT2_Countries('LU','LUX',NULL,3,'Luxembourg',442,NULL,0,'lu',9,0,100,'00',NULL,NULL,'352',NULL)}
go
{CALL CT2_Countries('MO','MAC',NULL,2,'Macau',446,NULL,0,'mo',NULL,0,100,'00',NULL,'0','853',2)}
go
{CALL CT2_Countries('MG','MDG',NULL,1,'Madagascar',450,NULL,0,'mg',NULL,0,100,'00',NULL,'0','261',2)}
go
{CALL CT2_Countries('MW','MWI',NULL,1,'Malawi',454,NULL,0,'mw',NULL,0,100,'00',NULL,NULL,'265',2)}
go
{CALL CT2_Countries('MY','MYS',NULL,2,'Malaysia',458,NULL,0,'my',7,0,100,'00',NULL,'0','60',NULL)}
go
{CALL CT2_Countries('MV','MDV',NULL,2,'Maldives',462,NULL,0,'mv',7,0,100,'00',NULL,'0','960',2)}
go
{CALL CT2_Countries('ML','MLI',NULL,1,'Mali',466,NULL,0,'ml',NULL,0,100,'00',NULL,'0','223',2)}
go
{CALL CT2_Countries('MT','MLT',NULL,3,'Malta',470,NULL,0,'mt',NULL,0,100,'00',NULL,'0','356',2)}
go
{CALL CT2_Countries('MQ','MTQ',NULL,4,'Martinique',474,NULL,0,'mq',NULL,0,100,'00',NULL,'0','596',NULL)}
go
{CALL CT2_Countries('MR','MRT',NULL,1,'Mauritania',478,NULL,0,'mr',NULL,0,100,'00',NULL,'0','222',2)}
go
{CALL CT2_Countries('MU','MUS',NULL,1,'Mauritius',480,NULL,0,'mu',8,0,100,'00',NULL,'0','230',2)}
go
{CALL CT2_Countries('MX','MEX',NULL,4,'Mexico',484,NULL,0,'mx',10,0,100,'00',NULL,'1','52',NULL)}
go
{CALL CT2_Countries('MC','MCO',NULL,3,'Monaco',492,NULL,0,'mc',NULL,0,100,'00',NULL,'0','377',NULL)}
go
{CALL CT2_Countries('MN','MNG',NULL,2,'Mongolia',496,NULL,0,'mn',8,0,100,'001',NULL,'0','976',NULL)}
go
{CALL CT2_Countries('MD','MDA',NULL,3,'Moldova',498,NULL,0,'md',8,0,100,'00',NULL,'0','373',NULL)}
go
{CALL CT2_Countries('MS','MSR',NULL,4,'Montserrat',500,NULL,0,'ms',10,0,100,'011',NULL,'1','1',2)}
go
{CALL CT2_Countries('MA','MAR',NULL,1,'Morocco',504,NULL,0,'ma',NULL,0,100,'00',NULL,NULL,'212',2)}
go
{CALL CT2_Countries('MZ','MOZ',NULL,1,'Mozambique',508,NULL,0,'mz',NULL,0,100,'00',NULL,'0','258',2)}
go
{CALL CT2_Countries('OM','OMN',NULL,2,'Oman',512,NULL,0,'om',NULL,0,100,'00',NULL,'0','968',2)}
go
{CALL CT2_Countries('NA','NAM',NULL,1,'Namibia',516,NULL,0,'na',NULL,0,100,'00',NULL,'0','264',2)}
go
{CALL CT2_Countries('NR','NRU',NULL,6,'Nauru',520,NULL,0,'nr',NULL,0,100,'00',NULL,'0','674',NULL)}
go
{CALL CT2_Countries('NP','NPL',NULL,2,'Nepal',524,NULL,0,'np',10,0,100,'00',NULL,'0','977',2)}
go
{CALL CT2_Countries('NL','NLD',NULL,3,'Netherlands',528,NULL,0,'nl',9,0,100,'00',NULL,'0','31',NULL)}
go
{CALL CT2_Countries('AN','ANT',NULL,3,'Netherlands Antilles',530,NULL,0,'nl',NULL,0,100,'00',NULL,'0','599',2)}
go
{CALL CT2_Countries('AW','ABW',NULL,4,'Aruba',533,NULL,0,'aw',NULL,0,100,'00',NULL,NULL,'297',2)}
go
{CALL CT2_Countries('NC','NCL',NULL,6,'New Caledonia',540,NULL,0,'nc',6,0,100,'00',NULL,'0','687',2)}
go
{CALL CT2_Countries('VU','VUT',NULL,6,'Vanuatu',548,NULL,0,'vu',NULL,0,100,'00',NULL,NULL,'678',2)}
go
{CALL CT2_Countries('NZ','NZL',NULL,6,'New Zealand',554,NULL,0,'nz',NULL,0,100,'00',NULL,'0','64',NULL)}
go
{CALL CT2_Countries('NI','NIC',NULL,4,'Nicaragua',558,NULL,0,'ni',8,0,100,'00',NULL,'0','505',2)}
go
{CALL CT2_Countries('NE','NER',NULL,1,'Niger',562,NULL,0,'ne',8,0,100,'00',NULL,'0','227',2)}
go
{CALL CT2_Countries('NG','NGA',NULL,1,'Nigeria',566,NULL,0,'ng',8,0,100,'009',NULL,'0','234',2)}
go
{CALL CT2_Countries('NU','NIU',NULL,6,'Niue',570,NULL,0,'nu',4,0,100,'00',NULL,'0','683',NULL)}
go
{CALL CT2_Countries('NO','NOR',NULL,3,'Norway',578,NULL,0,'no',8,0,100,'00',NULL,NULL,'47',NULL)}
go
{CALL CT2_Countries('MP','MNP',NULL,6,'Northern Mariana Islands',580,NULL,0,'mp',NULL,0,100,'011',NULL,'1','670',2)}
go
{CALL CT2_Countries('FM','FSM',NULL,6,'Micronesia',583,NULL,0,'fm',7,0,100,'011',NULL,'1','691',NULL)}
go
{CALL CT2_Countries('MH','MHL',NULL,6,'Marshall Islands',584,NULL,0,'mh',7,0,100,'011',NULL,'1','692',NULL)}
go
{CALL CT2_Countries('PW','PLW',NULL,6,'Palau',585,NULL,0,'pw',7,0,100,'011',NULL,NULL,'680',NULL)}
go
{CALL CT2_Countries('PK','PAK',NULL,2,'Pakistan',586,NULL,0,'pk',10,0,100,'00',NULL,'0','92',NULL)}
go
{CALL CT2_Countries('PA','PAN',NULL,4,'Panama',591,NULL,0,'pa',8,0,100,'00',NULL,'0','507',2)}
go
{CALL CT2_Countries('PG','PNG',NULL,6,'Papua New Guinea',598,NULL,0,'pg',NULL,0,100,'5',NULL,NULL,'675',2)}
go
{CALL CT2_Countries('PY','PRY',NULL,5,'Paraguay',600,NULL,0,'py',9,0,100,'002',NULL,'0','595',2)}
go
{CALL CT2_Countries('PE','PER',NULL,5,'Peru',604,NULL,0,'pe',9,0,100,'00',NULL,'0','51',2)}
go
{CALL CT2_Countries('PH','PHL',NULL,2,'Philippines',608,NULL,0,'ph',10,0,100,'00',NULL,'0','63',NULL)}
go
{CALL CT2_Countries('PL','POL',NULL,3,'Poland',616,NULL,0,'pl',9,0,100,'0',NULL,'0','48',NULL)}
go
{CALL CT2_Countries('PT','PRT',NULL,3,'Portugal',620,NULL,0,'pt',9,0,100,'00',NULL,NULL,'351',NULL)}
go
{CALL CT2_Countries('GW','GNB',NULL,1,'Guinea-Bissau',624,NULL,0,'gw',NULL,0,100,'00',NULL,NULL,'245',2)}
go
{CALL CT2_Countries('PR','PRI',NULL,4,'Puerto Rico',630,NULL,0,'pr',10,0,100,'011',6,'1','1',NULL)}
go
{CALL CT2_Countries('QA','QAT',NULL,2,'Qatar',634,NULL,0,'qa',8,0,100,'00',NULL,'0','974',2)}
go
{CALL CT2_Countries('RE','REU',NULL,1,'Reunion',638,NULL,0,'re',NULL,0,100,'00',NULL,'0','262',NULL)}
go
{CALL CT2_Countries('RO','ROM',NULL,3,'Romania',642,NULL,0,'ro',10,0,100,'00',NULL,'0','40',NULL)}
go
{CALL CT2_Countries('RU','RUS',NULL,2,'Russian Federation',643,NULL,0,'ru',10,0,100,'8~10',NULL,'8','7',NULL)}
go
{CALL CT2_Countries('RW','RWA',NULL,1,'Rwanda',646,NULL,0,'rw',NULL,0,100,'00',NULL,'0','250',2)}
go
{CALL CT2_Countries('SH','SHN',NULL,1,'Saint Helena',654,NULL,0,'sh',NULL,0,100,'00',NULL,NULL,'290',NULL)}
go
{CALL CT2_Countries('KN','KNA',NULL,5,'Saint Kitts and Nevis',659,NULL,0,'kn',10,0,100,'011',NULL,'1','1-869',2)}
go
{CALL CT2_Countries('AI','AIA',NULL,4,'Anguilla',660,NULL,0,'ai',NULL,0,100,'011',NULL,'1','1-264',2)}
go
{CALL CT2_Countries('LC','LCA',NULL,4,'Saint Lucia',662,NULL,0,'lc',10,0,100,'011',NULL,'1','1-758',2)}
go
{CALL CT2_Countries('PM','SPM',NULL,4,'Saint Pierre and Miquelon',666,NULL,0,'pm',NULL,0,100,'00',NULL,'0','508',NULL)}
go
{CALL CT2_Countries('VC','VCT',NULL,4,'Saint Vincent and the Grenadines',670,NULL,0,'vc',10,0,100,'011',NULL,'1','1',2)}
go
{CALL CT2_Countries('SM','SMR',NULL,3,'San Marino',674,NULL,0,'sm',NULL,0,100,'00',NULL,'0','378',NULL)}
go
{CALL CT2_Countries('ST','STP',NULL,1,'Sao Tome and Principe',678,NULL,0,'st',NULL,0,100,'00',NULL,'0','239',NULL)}
go
{CALL CT2_Countries('SA','SAU',NULL,2,'Saudi Arabia',682,NULL,0,'sa',9,0,100,'00',NULL,'0','966',NULL)}
go
{CALL CT2_Countries('SN','SEN',NULL,1,'Senegal',686,NULL,0,'sn',NULL,0,100,'00',NULL,'0','221',2)}
go
{CALL CT2_Countries('SC','SYC',NULL,1,'Seychelles',690,NULL,0,'sc',NULL,0,100,'00',NULL,'0','248',2)}
go
{CALL CT2_Countries('SL','SLE',NULL,1,'Sierra Leone',694,NULL,0,'sl',NULL,0,100,'00',NULL,'0','232',2)}
go
{CALL CT2_Countries('SG','SGP',NULL,2,'Singapore',702,NULL,0,'sg',8,0,100,'001 002 008 012 013 018 019',NULL,NULL,'65',NULL)}
go
{CALL CT2_Countries('SK','SVK',NULL,3,'Slovakia',703,NULL,0,'sk',9,0,100,NULL,NULL,NULL,'42',NULL)}
go
{CALL CT2_Countries('VN','VNM',NULL,2,'Viet Nam',704,NULL,0,'vn',9,0,100,'00',NULL,'0','84',NULL)}
go
{CALL CT2_Countries('SI','SVN',NULL,3,'Slovenia',705,NULL,0,'si',NULL,0,100,'00',NULL,'0','386',NULL)}
go
{CALL CT2_Countries('SO','SOM',NULL,1,'Somalia',706,NULL,0,'so',NULL,0,100,'00',NULL,NULL,'252',NULL)}
go
{CALL CT2_Countries('ZA','ZAF',NULL,1,'South Africa',710,NULL,0,'za',9,0,100,'9',NULL,'0','27',NULL)}
go
{CALL CT2_Countries('ZW','ZWE',NULL,1,'Zimbabwe',716,NULL,0,'zw',NULL,0,100,'00',NULL,'0','263',2)}
go
{CALL CT2_Countries('ES','ESP',NULL,3,'Spain',724,NULL,0,'es',9,0,100,'00',NULL,NULL,'34',NULL)}
go
{CALL CT2_Countries('SD','SDN',NULL,1,'Sudan',736,NULL,0,'sd',NULL,0,100,'00',NULL,'0','249',NULL)}
go
{CALL CT2_Countries('SR','SUR',NULL,5,'Suriname',740,NULL,0,'sr',NULL,0,100,'00',NULL,NULL,'597',2)}
go
{CALL CT2_Countries('SZ','SWZ',NULL,1,'Swaziland',748,NULL,0,'sz',8,0,100,'00',NULL,NULL,'268',2)}
go
{CALL CT2_Countries('SE','SWE',NULL,3,'Sweden',752,NULL,0,'se',7,0,100,'00',NULL,'0','46',NULL)}
go
{CALL CT2_Countries('CH','CHE',NULL,3,'Switzerland',756,NULL,0,'ch',9,0,100,'00',NULL,'0','41',NULL)}
go
{CALL CT2_Countries('SY','SYR',NULL,2,'Syria',760,NULL,0,'sy',9,0,100,'00',NULL,'0','963',2)}
go
{CALL CT2_Countries('TJ','TJK',NULL,2,'Tajikistan',762,NULL,0,'tj',NULL,0,100,'8~10',NULL,'8','7',NULL)}
go
{CALL CT2_Countries('TH','THA',NULL,2,'Thailand',764,NULL,0,'th',9,0,100,'001',NULL,'0','66',NULL)}
go
{CALL CT2_Countries('TG','TGO',NULL,1,'Togo',768,NULL,0,'tg',8,0,100,'00',NULL,NULL,'228',2)}
go
{CALL CT2_Countries('TK','TKL',NULL,6,'Tokelau',772,NULL,0,'tk',NULL,0,100,'00',NULL,NULL,'690',NULL)}
go
{CALL CT2_Countries('TO','TON',NULL,6,'Tonga',776,NULL,0,'to',NULL,0,100,'00',NULL,NULL,'676',2)}
go
{CALL CT2_Countries('TT','TTO',NULL,4,'Trinidad and Tobago',780,NULL,0,'tt',10,0,100,'011',NULL,'1','1-868',2)}
go
{CALL CT2_Countries('AE','ARE',NULL,2,'United Arab Emirates',784,NULL,0,'ae',9,0,100,'00',NULL,NULL,'971',2)}
go
{CALL CT2_Countries('TN','TUN',NULL,1,'Tunisia',788,NULL,0,'tn',8,0,100,'00',NULL,'0','216',2)}
go
{CALL CT2_Countries('TR','TUR',NULL,2,'Turkey',792,NULL,0,'tr',11,0,100,'00',NULL,'0','90',NULL)}
go
{CALL CT2_Countries('TM','TKM',NULL,2,'Turkmenistan',795,NULL,0,'tm',NULL,0,100,'8~10',NULL,'8','993',NULL)}
go
{CALL CT2_Countries('TC','TCA',NULL,4,'Turks and Caicos Islands',796,NULL,0,'tc',10,0,100,'011',NULL,'1','1-649',2)}
go
{CALL CT2_Countries('TV','TUV',NULL,6,'Tuvalu',798,NULL,0,'tv',NULL,0,100,'00',NULL,NULL,'688',2)}
go
{CALL CT2_Countries('UG','UGA',NULL,1,'Uganda',800,NULL,0,'ug',NULL,0,100,'000',NULL,'0','256',2)}
go
{CALL CT2_Countries('UA','UKR',NULL,3,'Ukraine',804,NULL,0,'ua',9,0,100,'8~10',NULL,'8','380',NULL)}
go
{CALL CT2_Countries('MK','MKD',NULL,3,'Macedonia',807,NULL,0,'mk',NULL,0,100,'00',NULL,'0','389',NULL)}
go
{CALL CT2_Countries('EG','EGY',NULL,1,'Egypt',818,NULL,0,'eg',10,0,100,'00',NULL,'0','20',2)}
go
{CALL CT2_Countries('GB','GBR',NULL,3,'United Kingdom',826,NULL,0,'uk',10,0,100,'00',NULL,'0','44',NULL)}
go
{CALL CT2_Countries('TZ','TZA',NULL,1,'Tanzania',834,NULL,0,'tz',NULL,0,100,'000',NULL,'0','255',2)}
go
{CALL CT2_Countries('US','USA',NULL,4,'United States',840,NULL,0,'us',10,0,10,'011',6,'1','1',NULL)}
go
{CALL CT2_Countries('VI','VIR',NULL,4,'Virgin Islands',850,NULL,0,'vi',10,0,100,'011',NULL,'1','1',NULL)}
go
{CALL CT2_Countries('BF','BFA',NULL,1,'Burkina Faso',854,NULL,0,'bf',8,0,100,'00',NULL,NULL,'226',2)}
go
{CALL CT2_Countries('UY','URY',NULL,5,'Uruguay',858,NULL,0,'uy',NULL,0,100,'00',NULL,'0','598',NULL)}
go
{CALL CT2_Countries('UZ','UZB',NULL,2,'Uzbekistan',860,NULL,0,'uz',NULL,0,100,'8~10',NULL,'8','998',NULL)}
go
{CALL CT2_Countries('VE','VEN',NULL,4,'Venezuela',862,NULL,0,'ve',7,0,100,'00',NULL,'0','58',2)}
go
{CALL CT2_Countries('WS','WSM',NULL,6,'Western Samoa',882,NULL,0,'ws',5,0,100,'00',NULL,NULL,'685',2)}
go
{CALL CT2_Countries('YE','YEM',NULL,2,'Yemen',887,NULL,0,'ye',9,0,100,'00',NULL,'0','967',2)}
go
{CALL CT2_Countries('YU','YUG',NULL,3,'Yugoslavia',891,NULL,0,'yu',NULL,0,100,'99',NULL,'0','381',NULL)}
go
{CALL CT2_Countries('ZM','ZMB',NULL,1,'Zambia',894,NULL,0,'zm',NULL,0,100,'00',NULL,'0','260',2)}
go
{CALL CT2_Countries('EU','EUR',NULL,3,'European Union',978,NULL,0,NULL,NULL,0,100,NULL,NULL,NULL,NULL,NULL)}
go
{CALL CT_TimeZones(NULL,'American Samoa (-11:00)',-11.00)}
go
{CALL CT_TimeZones(NULL,'Hawaii-Aleutian Standard Time (-10:00)',-10.00)}
go
{CALL CT_TimeZones(NULL,'French Polynesia (-9:30)',-9.30)}
go
{CALL CT_TimeZones(NULL,'Alaska Standard Time (-9:00)',-9.00)}
go
{CALL CT_TimeZones(NULL,'Pacific Standard Time (-8:00)',-8.00)}
go
{CALL CT_TimeZones(NULL,'Mountain Standard Time (-7:00)',-7.00)}
go
{CALL CT_TimeZones(NULL,'Central Standard Time (-6:00)',-6.00)}
go
{CALL CT_TimeZones(NULL,'Eastern Standard Time (-5:00)',-5.00)}
go
{CALL CT_TimeZones(NULL,'Atlantic Time (-4:00)',-4.00)}
go
{CALL CT_TimeZones(NULL,'Newfoundland (-3:30)',-3.30)}
go
{CALL CT_TimeZones(NULL,'Brazil official time (-3:00)',-3.00)}
go
{CALL CT_TimeZones(NULL,'Mid Atlantic (-2:00)',-2.00)}
go
{CALL CT_TimeZones(NULL,'Azores (-1:00)',-1.00)}
go
{CALL CT_TimeZones(NULL,'Greenwich Mean Time (0:00)',.00)}
go
{CALL CT_TimeZones(NULL,'Amsterdam, Berlin, Rome, Brussels (+1:00)',1.00)}
go
{CALL CT_TimeZones(NULL,'Athens, Beirut, Istanbul, Cairo (+2:00)',2.00)}
go
{CALL CT_TimeZones(NULL,'Baghdad, Moscow, Kuwait (+3:00)',3.00)}
go
{CALL CT_TimeZones(NULL,'Abu Dhabi (+4:00)',4.00)}
go
{CALL CT_TimeZones(NULL,'Kabul (+4:30)',4.30)}
go
{CALL CT_TimeZones(NULL,'Ekaterinburg, Islamabad, Karachi (+5:00)',5.00)}
go
{CALL CT_TimeZones(NULL,'New Delhi (+5:30)',5.30)}
go
{CALL CT_TimeZones(NULL,'Kathmandu (+5:45)',5.45)}
go
{CALL CT_TimeZones(NULL,'Astana, Dhaka (+6:00)',6.00)}
go
{CALL CT_TimeZones(NULL,'Rangoon (+6:30)',6.30)}
go
{CALL CT_TimeZones(NULL,'Bangkok, Hanoi, Jakarta (+7:00)',7.00)}
go
{CALL CT_TimeZones(NULL,'Singapore, Beijing, Hong Kong (+8:00)',8.00)}
go
{CALL CT_TimeZones(NULL,'Tokyo, Seoul, Osaka (+9:00)',9.00)}
go
{CALL CT_TimeZones(NULL,'Adelaide, Darwin (+9:30)',9.30)}
go
{CALL CT_TimeZones(NULL,'Melbourne, Sydney, Brisbane, Guam (+10:00)',10.00)}
go
{CALL CT_TimeZones(NULL,'Magadan, Solomon Island, Caledonia (+11:00)',11.00)}
go
{CALL CT_TimeZones(NULL,'Auckland, Fiji, Marshall Islands (+12:00)',12.00)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'and Zabol',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Badakhshan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Badghis',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Baghlan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Balkh',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Bamian',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Daykondi',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Farah',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Faryab',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Ghazni',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Ghowr',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Helmand',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Herat',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Jowzjan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Kabol',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Kandahar',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Kapisa',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Khowst',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Konar',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Kondoz',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Laghman',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Lowgar',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Nangarhar',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Nimruz',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Nurestan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Oruzgan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Paktia',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Paktika',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Panjshir',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Parvan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Samangan',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Sar-e Pol',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Takhar',NULL,NULL)}
go
{CALL CT_States(NULL,4,NULL,NULL,NULL,10,'Vardak',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Beratit',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Dibres',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Durresit',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Elbasanit',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Fierit',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Gjirokastres',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Korces',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Kukesit',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Lezhes',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Shkodres',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Tiranes',NULL,NULL)}
go
{CALL CT_States(NULL,8,NULL,NULL,NULL,10,'Qarku i Vlores',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Adrar',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Ain Defla',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Ain Temouchent',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Alger',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Annaba',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Batna',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Bechar',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Bejaia',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Biskra',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Blida',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Bordj Bou Arreridj',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Bouira',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Boumerdes',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Chlef',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Constantine',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Djelfa',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'El Bayadh',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'El Oued',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'El Tarf',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Ghardaia',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Guelma',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Illizi',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Jijel',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Khenchela',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Laghouat',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'M''Sila',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Mascara',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Medea',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Mila',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Mostaganem',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Naama',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Oran',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Ouargla',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Oum el Bouaghi',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Relizane',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Saida',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Setif',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Sidi Bel Abbes',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Skikda',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Souk Ahras',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tamanghasset',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tebessa',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tiaret',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tindouf',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tipaza',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tissemsilt',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tizi Ouzou',NULL,NULL)}
go
{CALL CT_States(NULL,12,NULL,NULL,NULL,10,'Tlemcen',NULL,NULL)}
go
{CALL CT_States(NULL,16,NULL,NULL,NULL,10,'Manu''a',NULL,NULL)}
go
{CALL CT_States(NULL,16,NULL,NULL,NULL,10,'Rose Island',NULL,NULL)}
go
{CALL CT_States(NULL,16,NULL,NULL,NULL,10,'Swains Island',NULL,NULL)}
go
{CALL CT_States(NULL,16,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Andorra la Vella',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Canillo',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Encamp',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Escaldes-Engordany',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'La Massana',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Ordino',NULL,NULL)}
go
{CALL CT_States(NULL,20,NULL,NULL,NULL,10,'Sant Julia de Loria',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Bengo',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Benguela',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Bie',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Cabinda',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Cuando Cubango',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Cuanza Norte',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Cuanza Sul',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Cunene',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Huambo',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Huila',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Luanda',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Lunda Norte',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Lunda Sul',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Malanje',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Moxico',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Namibe',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Uige',NULL,NULL)}
go
{CALL CT_States(NULL,24,NULL,NULL,NULL,10,'Zaire',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Barbuda',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Redonda',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint John',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint Mary',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint Paul',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint Peter',NULL,NULL)}
go
{CALL CT_States(NULL,28,NULL,NULL,NULL,10,'Saint Philip',NULL,NULL)}
go
{CALL CT_States(NULL,31,NULL,NULL,NULL,10,'rayon - singular)',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Buenos Aires',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Buenos Aires Capital Federal',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Catamarca',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Chaco',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Chubut',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Cordoba',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Corrientes',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Entre Rios',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Formosa',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Jujuy',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'La Pampa',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'La Rioja',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Mendoza',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Misiones',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Neuquen',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Rio Negro',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Salta',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'San Juan',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'San Luis',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Santa Cruz',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Santa Fe',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Santiago del Estero',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Tierra del Fuego - Antartida e Islas del Atlantico Sur',NULL,NULL)}
go
{CALL CT_States(NULL,32,NULL,NULL,NULL,10,'Tucuman',NULL,NULL)}
go
{CALL CT_States('ACT',36,NULL,NULL,NULL,10,'Australian Capital Territory',NULL,NULL)}
go
{CALL CT_States('NSW',36,NULL,NULL,NULL,10,'New South Wales',NULL,NULL)}
go
{CALL CT_States('NT',36,NULL,NULL,NULL,10,'Northern Territory',NULL,NULL)}
go
{CALL CT_States('QLD',36,NULL,NULL,NULL,10,'Queensland',NULL,NULL)}
go
{CALL CT_States('SA',36,NULL,NULL,NULL,10,'South Australia',NULL,NULL)}
go
{CALL CT_States('TAS',36,NULL,NULL,NULL,10,'Tasmania',NULL,NULL)}
go
{CALL CT_States('VIC',36,NULL,NULL,NULL,10,'Victoria',NULL,NULL)}
go
{CALL CT_States('WA',36,NULL,NULL,NULL,10,'Western Australia',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Burgenland',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Kaernten',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Niederoesterreich',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Oberoesterreich',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Salzburg',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Steiermark',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Tirol',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Vorarlberg',NULL,NULL)}
go
{CALL CT_States(NULL,40,NULL,NULL,NULL,10,'Wien (Vienna)',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Hadd',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Manamah',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Mintaqah al Gharbiyah',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Mintaqah al Wusta',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Mintaqah ash Shamaliyah',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Al Muharraq',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Ar Rifa'' wa al Mintaqah al Janubiyah',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Jidd Hafs',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Juzur Hawar',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Madinat ''Isa',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Madinat Hamad',NULL,NULL)}
go
{CALL CT_States(NULL,48,NULL,NULL,NULL,10,'Sitrah',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'and Sylhet',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'Barisal',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'Chittagong',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'Dhaka',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'Khulna',NULL,NULL)}
go
{CALL CT_States(NULL,50,NULL,NULL,NULL,10,'Rajshahi',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Aragatsotn',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Ararat',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Armavir',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Geghark''unik''',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Kotayk''',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Lorri',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Shirak',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Syunik''',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Tavush',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Vayots'' Dzor',NULL,NULL)}
go
{CALL CT_States(NULL,51,NULL,NULL,NULL,10,'Yerevan',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Christ Church',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Andrew',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint James',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint John',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Joseph',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Lucy',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Michael',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Peter',NULL,NULL)}
go
{CALL CT_States(NULL,52,NULL,NULL,NULL,10,'Saint Philip',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Brabant Wallon',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Brussels (Bruxelles)',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Flanders',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Hainaut',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Liege',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Limburg',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Luxembourg',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Namur',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Oost-Vlaanderen',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Vlaams-Brabant',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'Wallonia',NULL,NULL)}
go
{CALL CT_States(NULL,56,NULL,NULL,NULL,10,'West-Vlaanderen',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Devonshire',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Hamilton',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Paget',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Pembroke',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Saint George''s',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Sandys',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Smith''s',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Southampton',NULL,NULL)}
go
{CALL CT_States(NULL,60,NULL,NULL,NULL,10,'Warwick',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Bumthang',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Chhukha',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Chirang',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Dagana',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Geylegphug',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Ha',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Lhuntshi',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Mongar',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Paro',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Pemagatsel',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Punakha',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Samchi',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Samdrup Jongkhar',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Shemgang',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Tashigang',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Thimphu',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Tongsa',NULL,NULL)}
go
{CALL CT_States(NULL,64,NULL,NULL,NULL,10,'Wangdi Phodrang',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Beni',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Chuquisaca',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Cochabamba',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'La Paz',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Oruro',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Pando',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Potosi',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Santa Cruz',NULL,NULL)}
go
{CALL CT_States(NULL,68,NULL,NULL,NULL,10,'Tarija',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Francistown',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Gaborone',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Ghanzi',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Jwaneng',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Kgalagadi',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Kgatleng',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Kweneng',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Lobatse',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Northeast',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Northwest',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Selebi-Pikwe',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Southeast',NULL,NULL)}
go
{CALL CT_States(NULL,72,NULL,NULL,NULL,10,'Southern',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Acre',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Alagoas',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Amapa',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Amazonas',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Bahia',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Ceara',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Distrito Federal',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Espirito Santo',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Goias',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Maranhao',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Mato Grosso',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Mato Grosso do Sul',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Minas Gerais',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Para',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Paraiba',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Parana',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Pernambuco',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Piaui',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Rio de Janeiro',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Rio Grande do Norte',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Rio Grande do Sul',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Rondonia',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Roraima',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Santa Catarina',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Sao Paulo',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Sergipe',NULL,NULL)}
go
{CALL CT_States(NULL,76,NULL,NULL,NULL,10,'Tocantins',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Belize',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Cayo',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Corozal',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Orange Walk',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Stann Creek',NULL,NULL)}
go
{CALL CT_States(NULL,84,NULL,NULL,NULL,10,'Toledo',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Choiseul',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Guadalcanal',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Honiara',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Isabel',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Makira',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Malaita',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Rennell and Bellona',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Temotu',NULL,NULL)}
go
{CALL CT_States(NULL,90,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States('VI',92,NULL,NULL,NULL,100,'Virgin Islands',NULL,NULL)}
go
{CALL CT_States(NULL,96,NULL,NULL,NULL,10,'Belait',NULL,NULL)}
go
{CALL CT_States(NULL,96,NULL,NULL,NULL,10,'Brunei and Muara',NULL,NULL)}
go
{CALL CT_States(NULL,96,NULL,NULL,NULL,10,'Temburong',NULL,NULL)}
go
{CALL CT_States(NULL,96,NULL,NULL,NULL,10,'Tutong',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Blagoevgrad',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Burgas',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Dobrich',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Gabrovo',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Khaskovo',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Kurdzhali',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Kyustendil',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Lovech',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Montana',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Pazardzhik',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Pernik',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Pleven',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Plovdiv',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Razgrad',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Ruse',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Shumen',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Silistra',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Sliven',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Smolyan',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Sofiya',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Sofiya-Grad',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Stara Zagora',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Turgovishte',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Varna',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Veliko Turnovo',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Vidin',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Vratsa',NULL,NULL)}
go
{CALL CT_States(NULL,100,NULL,NULL,NULL,10,'Yambol',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Bubanza',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Bujumbura',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Bururi',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Cankuzo',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Cibitoke',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Gitega',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Karuzi',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Kayanza',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Kirundo',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Makamba',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Muramvya',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Muyinga',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Mwaro',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Ngozi',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Rutana',NULL,NULL)}
go
{CALL CT_States(NULL,108,NULL,NULL,NULL,10,'Ruyigi',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Brest',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Homyel''',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Horad Minsk',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Hrodna',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Mahilyow',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Minsk',NULL,NULL)}
go
{CALL CT_States(NULL,112,NULL,NULL,NULL,10,'Vitsyebsk',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Adamaoua',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Centre',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Est',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Extreme-Nord',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Littoral',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Nord',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Nord-Ouest',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Ouest',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Sud',NULL,NULL)}
go
{CALL CT_States(NULL,120,NULL,NULL,NULL,10,'Sud-Ouest',NULL,NULL)}
go
{CALL CT_States('AB',124,NULL,NULL,NULL,10,'Alberta',NULL,NULL)}
go
{CALL CT_States('BC',124,NULL,NULL,NULL,10,'British Columbia',NULL,NULL)}
go
{CALL CT_States('MB',124,NULL,NULL,NULL,10,'Manitoba',NULL,NULL)}
go
{CALL CT_States('NB',124,NULL,NULL,NULL,10,'New Brunswick',NULL,NULL)}
go
{CALL CT_States('NF',124,NULL,NULL,NULL,10,'Newfoundland and Labrador',NULL,NULL)}
go
{CALL CT_States('NT',124,NULL,NULL,NULL,10,'Northwest Territories',NULL,NULL)}
go
{CALL CT_States('NS',124,NULL,NULL,NULL,10,'Nova Scotia',NULL,NULL)}
go
{CALL CT_States('NU',124,NULL,NULL,NULL,10,'Nunavut',NULL,NULL)}
go
{CALL CT_States('ON',124,NULL,NULL,NULL,10,'Ontario',NULL,NULL)}
go
{CALL CT_States('PE',124,NULL,NULL,NULL,10,'Prince Edward Island',NULL,NULL)}
go
{CALL CT_States('PQ',124,NULL,NULL,NULL,10,'Quebec',NULL,NULL)}
go
{CALL CT_States('SK',124,NULL,NULL,NULL,10,'Saskatchewan',NULL,NULL)}
go
{CALL CT_States('YT',124,NULL,NULL,NULL,10,'Yukon Territory',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Boa Vista',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Brava',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Maio',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Mosteiros',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Paul',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Porto Novo',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Praia',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Ribeira Grande',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sal',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Santa Catarina',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Santa Cruz',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sao Domingos',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sao Filipe',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sao Miguel',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sao Nicolau',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Sao Vicente',NULL,NULL)}
go
{CALL CT_States(NULL,132,NULL,NULL,NULL,10,'Tarrafal',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Creek',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Midland',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'South Town',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Spot Bay',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Stake Bay',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'West End',NULL,NULL)}
go
{CALL CT_States(NULL,136,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Bamingui-Bangoran',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Bangui',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Basse-Kotto',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Bouenza',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Brazzaville',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Cuvette',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Cuvette-Ouest',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Haut-Mbomou',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Haute-Kotto',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Kemo',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Kouilou',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Lekoumou',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Likouala',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Lobaye',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Mambere-Kadei',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Mbomou',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Nana-Grebizi',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Nana-Mambere',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Niari',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Ombella-Mpoko',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Ouaka',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Ouham',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Ouham-Pende',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Plateaux',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Pool',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Sangha',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Sangha-Mbaere',NULL,NULL)}
go
{CALL CT_States(NULL,140,NULL,NULL,NULL,10,'Vakaga',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'North Central',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'North Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'North Western',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'Sabaragamuwa',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'Southern',NULL,NULL)}
go
{CALL CT_States(NULL,144,NULL,NULL,NULL,10,'Uva',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Batha',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Biltine',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Borkou-Ennedi-Tibesti',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Chari-Baguirmi',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Guera',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Kanem',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Lac',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Logone Occidental',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Logone Oriental',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Mayo-Kebbi',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Moyen-Chari',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Ouaddai',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Salamat',NULL,NULL)}
go
{CALL CT_States(NULL,148,NULL,NULL,NULL,10,'Tandjile',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Aisen del General Carlos Ibanez del Campo',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Antofagasta',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Araucania',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Atacama',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Bio-Bio',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Coquimbo',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Libertador General Bernardo O''Higgins',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Los Lagos',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Magallanes y de la Antartica Chilena',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Maule',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Region Metropolitana (Santiago)',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Tarapaca',NULL,NULL)}
go
{CALL CT_States(NULL,152,NULL,NULL,NULL,10,'Valparaiso',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Anhui',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Beijing',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Chongqing',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Fujian',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Gansu',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Guangdong',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Guangxi',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Guizhou',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Hainan',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Hebei',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Heilongjiang',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Henan',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Hubei',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Hunan',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Jiangsu',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Jiangxi',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Jilin',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Liaoning',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Nei Mongol',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Ningxia',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Qinghai',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Shaanxi',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Shandong',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Shanghai',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Shanxi',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Sichuan',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Tianjin',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Xinjiang',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Xizang (Tibet)',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Yunnan',NULL,NULL)}
go
{CALL CT_States(NULL,156,NULL,NULL,NULL,0,'Zhejiang',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Amazonas',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Antioquia',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Arauca',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Atlantico',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Bolivar',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Boyaca',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Caldas',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Caqueta',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Casanare',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Cauca',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Cesar',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Choco',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Cordoba',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Cundinamarca',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Distrito Capital de Bogota',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Guainia',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Guaviare',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Huila',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'La Guajira',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Magdalena',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Meta',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Narino',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Norte de Santander',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Putumayo',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Quindio',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Risaralda',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'San Andres y Providencia',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Santander',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Sucre',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Tolima',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Valle del Cauca',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Vaupes',NULL,NULL)}
go
{CALL CT_States(NULL,170,NULL,NULL,NULL,10,'Vichada',NULL,NULL)}
go
{CALL CT_States(NULL,174,NULL,NULL,NULL,10,'and Moutsamoudou',NULL,NULL)}
go
{CALL CT_States(NULL,174,NULL,NULL,NULL,10,'Anjouan (Nzwani)',NULL,NULL)}
go
{CALL CT_States(NULL,174,NULL,NULL,NULL,10,'Fomboni',NULL,NULL)}
go
{CALL CT_States(NULL,174,NULL,NULL,NULL,10,'Grande Comore (Njazidja)',NULL,NULL)}
go
{CALL CT_States(NULL,174,NULL,NULL,NULL,10,'Moroni',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Bandundu',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Bas-Congo',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Equateur',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Kasai-Occidental',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Kasai-Oriental',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Katanga',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Kinshasa',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Maniema',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Nord-Kivu',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Orientale',NULL,NULL)}
go
{CALL CT_States(NULL,178,NULL,NULL,NULL,10,'Sud-Kivu',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Alajuela',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Cartago',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Guanacaste',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Heredia',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Limon',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'Puntarenas',NULL,NULL)}
go
{CALL CT_States(NULL,188,NULL,NULL,NULL,10,'San Jose',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Bjelovarsko-Bilogorska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Brodsko-Posavska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Dubrovacko-Neretvanska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Istarska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Karlovacka Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Koprivnicko-Krizevacka Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Krapinsko-Zagorska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Licko-Senjska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Medimurska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Osjecko-Baranjska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Pozesko-Slavonska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Primorsko-Goranska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Sibensko-Kninska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Sisacko-Moslavacka Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Splitsko-Dalmatinska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Varazdinska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Viroviticko-Podravska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Vukovarsko-Srijemska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Zadarska Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Zagreb',NULL,NULL)}
go
{CALL CT_States(NULL,191,NULL,NULL,NULL,10,'Zagrebacka Zupanija',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Camaguey',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Ciego de Avila',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Cienfuegos',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Ciudad de La Habana',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Granma',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Guantanamo',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Holguin',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Isla de la Juventud',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'La Habana',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Las Tunas',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Matanzas',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Pinar del Rio',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Sancti Spiritus',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Santiago de Cuba',NULL,NULL)}
go
{CALL CT_States(NULL,192,NULL,NULL,NULL,10,'Villa Clara',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'all but a small part of Famagusta',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'and small parts of Lefkosia (Nicosia) and Larnaca',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'Famagusta',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'Kyrenia',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'Larnaca',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'Limassol',NULL,NULL)}
go
{CALL CT_States(NULL,196,NULL,NULL,NULL,10,'Nicosia',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Jihocesky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Jihomoravsky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Karlovarsky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Kralovehradecky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Liberecky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Moravskoslezsky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Olomoucky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Pardubicky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Plzensky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Praha (Prague)',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Stredocesky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Ustecky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Vysocina',NULL,NULL)}
go
{CALL CT_States(NULL,203,NULL,NULL,NULL,10,'Zlinsky Kraj',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Alibori',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Atakora',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Atlantique',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Borgou',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Collines',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Donga',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Kouffo',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Littoral',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Mono',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Oueme',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Plateau',NULL,NULL)}
go
{CALL CT_States(NULL,204,NULL,NULL,NULL,10,'Zou',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Arhus',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Bornholm',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Frederiksberg',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Frederiksborg',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Fyn',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Kobenhavn',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Kobenhavn (Copenhagen)',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Nordjylland',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Ribe',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Ringkobing',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Roskilde',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Sonderjylland',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Storstrom',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Vejle',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Vestsjalland',NULL,NULL)}
go
{CALL CT_States(NULL,208,NULL,NULL,NULL,10,'Viborg',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Andrew',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint David',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint John',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Joseph',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Luke',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Mark',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Patrick',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Paul',NULL,NULL)}
go
{CALL CT_States(NULL,212,NULL,NULL,NULL,10,'Saint Peter',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Azua',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Baoruco',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Barahona',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Dajabon',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Distrito Nacional',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Duarte',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'El Seibo',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Elias Pina',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Espaillat',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Hato Mayor',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Independencia',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'La Altagracia',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'La Romana',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'La Vega',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Maria Trinidad Sanchez',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Monsenor Nouel',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Monte Cristi',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Monte Plata',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Pedernales',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Peravia',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Puerto Plata',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Salcedo',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Samana',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'San Cristobal',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'San Jose de Ocoa',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'San Juan',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'San Pedro de Macoris',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Sanchez Ramirez',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Santiago',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Santiago Rodriguez',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Santo Domingo',NULL,NULL)}
go
{CALL CT_States(NULL,214,NULL,NULL,NULL,10,'Valverde',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Azuay',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Bolivar',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Canar',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Carchi',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Chimborazo',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Cotopaxi',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'El Oro',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Esmeraldas',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Galapagos',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Guayas',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Imbabura',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Loja',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Los Rios',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Manabi',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Morona-Santiago',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Napo',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Orellana',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Pastaza',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Pichincha',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Sucumbios',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Tungurahua',NULL,NULL)}
go
{CALL CT_States(NULL,218,NULL,NULL,NULL,10,'Zamora-Chinchipe',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Ahuachapan',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Cabanas',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Chalatenango',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Cuscatlan',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'La Libertad',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'La Paz',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'La Union',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Morazan',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'San Miguel',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'San Salvador',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'San Vicente',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Santa Ana',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Sonsonate',NULL,NULL)}
go
{CALL CT_States(NULL,222,NULL,NULL,NULL,10,'Usulutan',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Annobon',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Bioko Norte',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Bioko Sur',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Centro Sur',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Kie-Ntem',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Litoral',NULL,NULL)}
go
{CALL CT_States(NULL,226,NULL,NULL,NULL,10,'Wele-Nzas',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Adis Abeba (Addis Ababa)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Afar',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Amara (Amhara)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Binshangul Gumuz',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Dire Dawa',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Gambela Hizboch (Gambela Peoples)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Hareri Hizb (Harari People)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Oromiya (Oromia)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Sumale (Somali)',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Tigray',NULL,NULL)}
go
{CALL CT_States(NULL,231,NULL,NULL,NULL,10,'Ye Debub Biheroch Bihereseboch na Hizboch',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Anseba',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Debub (Southern)',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Debubawi K''eyih Bahri (Southern Red Sea)',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Gash Barka',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Ma''akel (Central)',NULL,NULL)}
go
{CALL CT_States(NULL,232,NULL,NULL,NULL,10,'Semenawi Keyih Bahri (Northern Red Sea)',NULL,NULL)}
go
{CALL CT_States(NULL,242,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,242,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,242,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,242,NULL,NULL,NULL,10,'Rotuma',NULL,NULL)}
go
{CALL CT_States(NULL,242,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Aland',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Etela-Suomen Laani',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Ita-Suomen Laani',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Lansi-Suomen Laani',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Lappi',NULL,NULL)}
go
{CALL CT_States(NULL,246,NULL,NULL,NULL,10,'Oulun Laani',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Alsace',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Aquitaine',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Auvergne',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Basse-Normandie',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Bourgogne',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Bretagne',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Centre',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Champagne-Ardenne',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Corse',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Franche-Comte',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Haute-Normandie',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Ile-de-France',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Languedoc-Roussillon',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Limousin',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Lorraine',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Midi-Pyrenees',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Nord-Pas-de-Calais',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Pays de la Loire',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Picardie',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Poitou-Charentes',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Provence-Alpes-Cote d''Azur',NULL,NULL)}
go
{CALL CT_States(NULL,250,NULL,NULL,NULL,10,'Rhone-Alpes',NULL,NULL)}
go
{CALL CT_States(NULL,258,NULL,NULL,NULL,10,'and Iles Sous-le-Vent',NULL,NULL)}
go
{CALL CT_States(NULL,258,NULL,NULL,NULL,10,'Archipel des Tuamotu',NULL,NULL)}
go
{CALL CT_States(NULL,258,NULL,NULL,NULL,10,'Archipel des Tubuai',NULL,NULL)}
go
{CALL CT_States(NULL,258,NULL,NULL,NULL,10,'Iles du Vent',NULL,NULL)}
go
{CALL CT_States(NULL,262,NULL,NULL,NULL,10,'''Ali Sabih',NULL,NULL)}
go
{CALL CT_States(NULL,262,NULL,NULL,NULL,10,'Dikhil',NULL,NULL)}
go
{CALL CT_States(NULL,262,NULL,NULL,NULL,10,'Djibouti',NULL,NULL)}
go
{CALL CT_States(NULL,262,NULL,NULL,NULL,10,'Obock',NULL,NULL)}
go
{CALL CT_States(NULL,262,NULL,NULL,NULL,10,'Tadjoura',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Banjul',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Central River',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Estuaire',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Haut-Ogooue',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Lower River',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Moyen-Ogooue',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Ngounie',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'North Bank',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Nyanga',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Ogooue-Ivindo',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Ogooue-Lolo',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Ogooue-Maritime',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Upper River',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,266,NULL,NULL,NULL,10,'Woleu-Ntem',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Baden-Wuerttemberg',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Bayern',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Berlin',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Brandenburg',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Bremen',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Hamburg',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Hessen',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Mecklenburg-Vorpommern',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Niedersachsen',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Nordrhein-Westfalen',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Rheinland-Pfalz',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Saarland',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Sachsen',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Sachsen-Anhalt',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Schleswig-Holstein',NULL,NULL)}
go
{CALL CT_States(NULL,276,NULL,NULL,NULL,10,'Thueringen',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Ashanti',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Brong-Ahafo',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Greater Accra',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Upper East',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Upper West',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Volta',NULL,NULL)}
go
{CALL CT_States(NULL,288,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Abemama',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Aranuka',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Arorae',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Banaba',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Beru',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Butaritari',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Central Gilberts',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Gilbert Islands',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Kanton',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Kiritimati',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Kuria',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Line Islands',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Maiana',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Makin',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Marakei',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Nikunau',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Nonouti',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Northern Gilberts',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Onotoa',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Southern Gilberts',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Tabiteuea',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Tabuaeran',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Tamana',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Tarawa',NULL,NULL)}
go
{CALL CT_States(NULL,296,NULL,NULL,NULL,10,'Teraina)',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Achaia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Agion Oros (Mt. Athos)',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Aitolia kai Akarmania',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Argolis',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Arkadia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Arta',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Attiki',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Chalkidiki',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Chanion',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Chios',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Dodekanisos',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Drama',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Evros',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Evrytania',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Evvoia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Florina',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Fokidos',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Fthiotis',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Grevena',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Ileia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Imathia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Ioannina',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Irakleion',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Karditsa',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kastoria',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kavala',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kefallinia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kerkyra',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kilkis',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Korinthia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kozani',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Kyklades',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Lakonia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Larisa',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Lasithi',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Lefkas',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Lesvos',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Magnisia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Messinia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Pella',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Pieria',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Preveza',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Rethynnis',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Rodopi',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Samos',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Serrai',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Thesprotia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Thessaloniki',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Trikala',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Voiotia',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Xanthi',NULL,NULL)}
go
{CALL CT_States(NULL,300,NULL,NULL,NULL,10,'Zakynthos',NULL,NULL)}
go
{CALL CT_States(NULL,304,NULL,NULL,NULL,10,'Avannaa (Nordgronland)',NULL,NULL)}
go
{CALL CT_States(NULL,304,NULL,NULL,NULL,10,'Kitaa (Vestgronland)',NULL,NULL)}
go
{CALL CT_States(NULL,304,NULL,NULL,NULL,10,'Tunu (Ostgronland)',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Carriacou and Petit Martinique',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint Andrew',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint David',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint John',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint Mark',NULL,NULL)}
go
{CALL CT_States(NULL,308,NULL,NULL,NULL,10,'Saint Patrick',NULL,NULL)}
go
{CALL CT_States('GU',316,NULL,NULL,NULL,100,'Guam',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Alta Verapaz',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Baja Verapaz',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Chimaltenango',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Chiquimula',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'El Progreso',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Escuintla',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Guatemala',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Huehuetenango',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Izabal',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Jalapa',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Jutiapa',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Peten',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Quetzaltenango',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Quiche',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Retalhuleu',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Sacatepequez',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'San Marcos',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Santa Rosa',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Solola',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Suchitepequez',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Totonicapan',NULL,NULL)}
go
{CALL CT_States(NULL,320,NULL,NULL,NULL,10,'Zacapa',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Beyla',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Boffa',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Boke',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Conakry',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Coyah',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Dabola',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Dalaba',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Dinguiraye',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Dubreka',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Faranah',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Forecariah',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Fria',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Gaoual',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Gueckedou',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Kankan',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Kerouane',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Kindia',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Kissidougou',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Koubia',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Koundara',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Kouroussa',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Labe',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Lelouma',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Lola',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Macenta',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Mali',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Mamou',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Mandiana',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Nzerekore',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Pita',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Siguiri',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Telimele',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Tougue',NULL,NULL)}
go
{CALL CT_States(NULL,324,NULL,NULL,NULL,10,'Yomou',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Barima-Waini',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Cuyuni-Mazaruni',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Demerara-Mahaica',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'East Berbice-Corentyne',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Essequibo Islands-West Demerara',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Mahaica-Berbice',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Pomeroon-Supenaam',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Potaro-Siparuni',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Upper Demerara-Berbice',NULL,NULL)}
go
{CALL CT_States(NULL,328,NULL,NULL,NULL,10,'Upper Takutu-Upper Essequibo',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Artibonite',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Centre',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Grand ''Anse',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Nord',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Nord-Est',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Nord-Ouest',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Ouest',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Sud',NULL,NULL)}
go
{CALL CT_States(NULL,332,NULL,NULL,NULL,10,'Sud-Est',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Atlantida',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Choluteca',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Colon',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Comayagua',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Copan',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Cortes',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'El Paraiso',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Francisco Morazan',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Gracias a Dios',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Intibuca',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Islas de la Bahia',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'La Paz',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Lempira',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Ocotepeque',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Olancho',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Santa Barbara',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Valle',NULL,NULL)}
go
{CALL CT_States(NULL,340,NULL,NULL,NULL,10,'Yoro',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Austurland',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Hofudhborgarsvaedhi',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Nordhurland Eystra',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Nordhurland Vestra',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Sudhurland',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Sudhurnes',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Vestfirdhir',NULL,NULL)}
go
{CALL CT_States(NULL,352,NULL,NULL,NULL,10,'Vesturland',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Andaman and Nicobar Islands',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Andhra Pradesh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Arunachal Pradesh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Assam',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Bihar',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Chandigarh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Chhattisgarh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Dadra and Nagar Haveli',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Daman and Diu',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Delhi',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Goa',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Gujarat',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Haryana',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Himachal Pradesh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Jammu and Kashmir',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Jharkhand',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Karnataka',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Kerala',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Lakshadweep',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Madhya Pradesh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Maharashtra',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Manipur',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Meghalaya',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Mizoram',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Nagaland',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Orissa',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Pondicherry',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Punjab',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Rajasthan',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Sikkim',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Tamil Nadu',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Tripura',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Uttar Pradesh',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'Uttaranchal',NULL,NULL)}
go
{CALL CT_States(NULL,356,NULL,NULL,NULL,10,'West Bengal',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Aceh',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Bali',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Banten',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Bengkulu',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Gorontalo',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Irian Jaya Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Jakarta Raya',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Jambi',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Jawa Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Jawa Tengah',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Jawa Timur',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kalimantan Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kalimantan Selatan',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kalimantan Tengah',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kalimantan Timur',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kepulauan Bangka Belitung',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Kepulauan Riau',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Lampung',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Maluku',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Maluku Utara',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Nusa Tenggara Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Nusa Tenggara Timur',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Papua',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Riau',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sulawesi Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sulawesi Selatan',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sulawesi Tengah',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sulawesi Tenggara',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sulawesi Utara',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sumatera Barat',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sumatera Selatan',NULL,NULL)}
go
{CALL CT_States(NULL,360,NULL,NULL,NULL,10,'Sumatera Utara',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Ardabil',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Azarbayjan-e Gharbi',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Azarbayjan-e Sharqi',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Bushehr',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Chahar Mahall va Bakhtiari',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Esfahan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Fars',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Gilan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Golestan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Hamadan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Hormozgan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Ilam',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Kerman',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Kermanshah',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Khorasan-e Janubi',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Khorasan-e Razavi',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Khorasan-e Shemali',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Khuzestan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Kohgiluyeh va Buyer Ahmad',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Kordestan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Lorestan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Markazi',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Mazandaran',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Qazvin',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Qom',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Semnan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Sistan va Baluchestan',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Tehran',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Yazd',NULL,NULL)}
go
{CALL CT_States(NULL,364,NULL,NULL,NULL,10,'Zanjan',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Al Anbar',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Al Basrah',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Al Muthanna',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Al Qadisiyah',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'An Najaf',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Arbil',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'As Sulaymaniyah',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'At Ta''mim',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Babil',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Baghdad',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Dahuk',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Dhi Qar',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Diyala',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Karbala''',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Maysan',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Ninawa',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Salah ad Din',NULL,NULL)}
go
{CALL CT_States(NULL,368,NULL,NULL,NULL,10,'Wasit',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Carlow',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Cavan',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Clare',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Cork',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Donegal',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Dublin',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Galway',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Kerry',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Kildare',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Kilkenny',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Laois',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Leitrim',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Limerick',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Longford',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Louth',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Mayo',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Meath',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Monaghan',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Offaly',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Roscommon',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Sligo',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Tipperary',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Waterford',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Westmeath',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Wexford',NULL,NULL)}
go
{CALL CT_States(NULL,372,NULL,NULL,NULL,10,'Wicklow',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Haifa',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Jerusalem',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Southern',NULL,NULL)}
go
{CALL CT_States(NULL,376,NULL,NULL,NULL,10,'Tel Aviv',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Abruzzo',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Basilicata',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Calabria',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Campania',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Emilia-Romagna',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Friuli-Venezia Giulia',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Lazio',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Liguria',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Lombardia',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Marche',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Molise',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Piemonte',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Puglia',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Sardegna',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Sicilia',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Toscana',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Trentino-Alto Adige',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Umbria',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Valle d''Aosta',NULL,NULL)}
go
{CALL CT_States(NULL,380,NULL,NULL,NULL,10,'Veneto',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Agneby',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Bafing',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Bas-Sassandra',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Denguele',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Dix-Huit Montagnes',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Fromager',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Haut-Sassandra',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Lacs',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Lagunes',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Marahoue',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Moyen-Cavally',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Moyen-Comoe',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'N''zi-Comoe',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Savanes',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Sud-Bandama',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Sud-Comoe',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Vallee du Bandama',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Worodougou',NULL,NULL)}
go
{CALL CT_States(NULL,384,NULL,NULL,NULL,10,'Zanzan',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Clarendon',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Hanover',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Kingston',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Manchester',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Portland',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Andrew',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Ann',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Catherine',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Elizabeth',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint James',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Mary',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Saint Thomas',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Trelawny',NULL,NULL)}
go
{CALL CT_States(NULL,388,NULL,NULL,NULL,10,'Westmoreland',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Aichi',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Akita',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Aomori',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Chiba',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Ehime',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Fukui',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Fukuoka',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Fukushima',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Gifu',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Gumma',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Hiroshima',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Hokkaido',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Hyogo',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Ibaraki',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Ishikawa',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Iwate',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kagawa',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kagoshima',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kanagawa',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kochi',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kumamoto',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Kyoto',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Mie',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Miyagi',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Miyazaki',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Nagano',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Nagasaki',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Nara',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Niigata',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Oita',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Okayama',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Okinawa',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Osaka',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Saga',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Saitama',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Shiga',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Shimane',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Shizuoka',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Tochigi',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Tokushima',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Tokyo',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Tottori',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Toyama',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Wakayama',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Yamagata',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Yamaguchi',NULL,NULL)}
go
{CALL CT_States(NULL,392,NULL,NULL,NULL,10,'Yamanashi',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Almaty Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Almaty Qalasy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Aqmola Oblysy (Astana)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Aqtobe Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Astana Qalasy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Atyrau Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Batys Qazaqstan Oblysy (Oral)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Bayqongyr Qalasy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Mangghystau Oblysy (Aqtau)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Ongtustik Qazaqstan Oblysy (Shymkent)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Pavlodar Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Qaraghandy Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Qostanay Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Qyzylorda Oblysy',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Shyghys Qazaqstan Oblysy (Oskemen)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Soltustik Qazaqstan Oblysy (Petropavlovsk)',NULL,NULL)}
go
{CALL CT_States(NULL,398,NULL,NULL,NULL,10,'Zhambyl Oblysy (Taraz)',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'''Amman',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Ajlun',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Al ''Aqabah',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Al Balqa''',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Al Karak',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Al Mafraq',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'At Tafilah',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Az Zarqa''',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Irbid',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Jarash',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Ma''an',NULL,NULL)}
go
{CALL CT_States(NULL,400,NULL,NULL,NULL,10,'Madaba',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Coast',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Nairobi Area',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'North Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Nyanza',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Rift Valley',NULL,NULL)}
go
{CALL CT_States(NULL,404,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,414,NULL,NULL,NULL,10,'Al ''Asimah',NULL,NULL)}
go
{CALL CT_States(NULL,414,NULL,NULL,NULL,10,'Al Ahmadi',NULL,NULL)}
go
{CALL CT_States(NULL,414,NULL,NULL,NULL,10,'Al Farwaniyah',NULL,NULL)}
go
{CALL CT_States(NULL,414,NULL,NULL,NULL,10,'Al Jahra''',NULL,NULL)}
go
{CALL CT_States(NULL,414,NULL,NULL,NULL,10,'Hawalli',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Batken Oblasty',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Bishkek Shaary',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Chuy Oblasty (Bishkek)',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Jalal-Abad Oblasty',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Naryn Oblasty',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Osh Oblasty',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Talas Oblasty',NULL,NULL)}
go
{CALL CT_States(NULL,417,NULL,NULL,NULL,10,'Ysyk-Kol Oblasty (Karakol)',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Attapu',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Bokeo',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Bolikhamxai',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Champasak',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Houaphan',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Khammouan',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Louangnamtha',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Louangphrabang',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Oudomxai',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Phongsali',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Salavan',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Savannakhet',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Viangchan',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Viangchan (Vientiane)',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Xaignabouli',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Xaisomboun',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Xekong',NULL,NULL)}
go
{CALL CT_States(NULL,418,NULL,NULL,NULL,10,'Xiangkhoang',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Beqaa',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Beyrouth',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Liban-Nord',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Liban-Sud',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Mont-Liban',NULL,NULL)}
go
{CALL CT_States(NULL,422,NULL,NULL,NULL,10,'Nabatiye',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Berea',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Butha-Buthe',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Leribe',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Mafeteng',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Maseru',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Mohale''s Hoek',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Mokhotlong',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Qacha''s Nek',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Quthing',NULL,NULL)}
go
{CALL CT_States(NULL,426,NULL,NULL,NULL,10,'Thaba-Tseka',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Bomi',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Bong',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Gbarpolu',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Grand Bassa',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Grand Cape Mount',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Grand Gedeh',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Grand Kru',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Lofa',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Margibi',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Maryland',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Montserrado',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Nimba',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'River Cess',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'River Gee',NULL,NULL)}
go
{CALL CT_States(NULL,430,NULL,NULL,NULL,10,'Sinoe',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Ajdabiya',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al ''Aziziyah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al Fatih',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al Jabal al Akhdar',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al Jufrah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al Khums',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Al Kufrah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'An Nuqat al Khams',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Ash Shati''',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Awbari',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Az Zawiyah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Banghazi',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Darnah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Ghadamis',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Gharyan',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Misratah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Murzuq',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Sabha',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Sawfajjin',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Surt',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Tarabulus',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Tarhunah',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Tubruq',NULL,NULL)}
go
{CALL CT_States(NULL,434,NULL,NULL,NULL,10,'Yafran',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Balzers',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Eschen',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Gamprin',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Mauren',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Planken',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Ruggell',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Schaan',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Schellenberg',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Triesen',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Triesenberg',NULL,NULL)}
go
{CALL CT_States(NULL,438,NULL,NULL,NULL,10,'Vaduz',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Alytaus',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Kauno',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Klaipedos',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Marijampoles',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Panevezio',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Siauliu',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Taurages',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Telsiu',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Utenos',NULL,NULL)}
go
{CALL CT_States(NULL,440,NULL,NULL,NULL,10,'Vilniaus',NULL,NULL)}
go
{CALL CT_States(NULL,442,NULL,NULL,NULL,10,'Diekirch',NULL,NULL)}
go
{CALL CT_States(NULL,442,NULL,NULL,NULL,10,'Grevenmacher',NULL,NULL)}
go
{CALL CT_States(NULL,442,NULL,NULL,NULL,10,'Luxembourg',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Antananarivo',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Antsiranana',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Fianarantsoa',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Mahajanga',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Toamasina',NULL,NULL)}
go
{CALL CT_States(NULL,450,NULL,NULL,NULL,10,'Toliara',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Balaka',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Blantyre',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Chikwawa',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Chiradzulu',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Chitipa',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Dedza',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Dowa',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Karonga',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Kasungu',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Likoma',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Lilongwe',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Machinga (Kasupe)',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Mangochi',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Mchinji',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Mulanje',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Mwanza',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Mzimba',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Nkhata Bay',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Nkhotakota',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Nsanje',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Ntcheu',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Ntchisi',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Phalombe',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Rumphi',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Salima',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Thyolo',NULL,NULL)}
go
{CALL CT_States(NULL,454,NULL,NULL,NULL,10,'Zomba',NULL,NULL)}
go
{CALL CT_States(NULL,458,NULL,NULL,NULL,10,'and Putrajaya',NULL,NULL)}
go
{CALL CT_States(NULL,458,NULL,NULL,NULL,10,'city of Kuala Lumpur',NULL,NULL)}
go
{CALL CT_States(NULL,458,NULL,NULL,NULL,10,'Labuan',NULL,NULL)}
go
{CALL CT_States(NULL,458,NULL,NULL,NULL,10,'wilayah persekutuan',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Alifu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Baa',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Dhaalu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Faafu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Gaafu Alifu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Gaafu Dhaalu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Gnaviyani',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Haa Alifu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Haa Dhaalu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Kaafu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Laamu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Lhaviyani',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Maale',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Meemu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Noonu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Raa',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Seenu',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Shaviyani',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Thaa',NULL,NULL)}
go
{CALL CT_States(NULL,462,NULL,NULL,NULL,10,'Vaavu',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Gao',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Kayes',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Kidal',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Koulikoro',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Mopti',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Segou',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Sikasso',NULL,NULL)}
go
{CALL CT_States(NULL,466,NULL,NULL,NULL,10,'Tombouctou',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Adrar',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Assaba',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Brakna',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Dakhlet Nouadhibou',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Gorgol',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Guidimaka',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Hodh Ech Chargui',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Hodh El Gharbi',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Inchiri',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Nouakchott',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Tagant',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Tiris Zemmour',NULL,NULL)}
go
{CALL CT_States(NULL,478,NULL,NULL,NULL,10,'Trarza',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Agalega Islands',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Black River',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Cargados Carajos Shoals',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Flacq',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Grand Port',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Moka',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Pamplemousses',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Plaines Wilhems',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Port Louis',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Riviere du Rempart',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Rodrigues',NULL,NULL)}
go
{CALL CT_States(NULL,480,NULL,NULL,NULL,10,'Savanne',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Aguascalientes',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Baja California',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Baja California Sur',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Campeche',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Chiapas',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Chihuahua',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Coahuila de Zaragoza',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Colima',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Distrito Federal',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Durango',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Guanajuato',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Guerrero',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Hidalgo',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Jalisco',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Mexico',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Michoacan de Ocampo',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Morelos',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Nayarit',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Nuevo Leon',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Oaxaca',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Puebla',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Queretaro de Arteaga',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Quintana Roo',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'San Luis Potosi',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Sinaloa',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Sonora',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Tabasco',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Tamaulipas',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Tlaxcala',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Veracruz-Llave',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Yucatan',NULL,NULL)}
go
{CALL CT_States(NULL,484,NULL,NULL,NULL,10,'Zacatecas',NULL,NULL)}
go
{CALL CT_States(NULL,492,NULL,NULL,NULL,10,'La Condamine',NULL,NULL)}
go
{CALL CT_States(NULL,492,NULL,NULL,NULL,10,'Monaco-Ville',NULL,NULL)}
go
{CALL CT_States(NULL,492,NULL,NULL,NULL,10,'Monte-Carlo',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Arhangay',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Bayan-Olgiy',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Bayanhongor',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Bulgan',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Darhan Uul',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Dornod',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Dornogovi',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Dundgovi',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Dzavhan',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Govi-Altay',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Govi-Sumber',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Hentiy',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Hovd',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Hovsgol',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Omnogovi',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Orhon',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Ovorhangay',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Selenge',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Suhbaatar',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Tov',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Ulaanbaatar',NULL,NULL)}
go
{CALL CT_States(NULL,496,NULL,NULL,NULL,10,'Uvs',NULL,NULL)}
go
{CALL CT_States(NULL,500,NULL,NULL,NULL,10,'Saint Anthony',NULL,NULL)}
go
{CALL CT_States(NULL,500,NULL,NULL,NULL,10,'Saint Georges',NULL,NULL)}
go
{CALL CT_States(NULL,500,NULL,NULL,NULL,10,'Saint Peter',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Cabo Delgado',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Cidade de Maputo',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Gaza',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Inhambane',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Manica',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Maputo',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Nampula',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Niassa',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Sofala',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Tete',NULL,NULL)}
go
{CALL CT_States(NULL,508,NULL,NULL,NULL,10,'Zambezia',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Caprivi',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Erongo',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Hardap',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Karas',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Khomas',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Kunene',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Ohangwena',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Okavango',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Omaheke',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Omusati',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Oshana',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Oshikoto',NULL,NULL)}
go
{CALL CT_States(NULL,516,NULL,NULL,NULL,10,'Otjozondjupa',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Aiwo',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Anabar',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Anetan',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Anibare',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Baiti',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Boe',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Buada',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Denigomodu',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Ewa',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Ijuw',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Meneng',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Nibok',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Uaboe',NULL,NULL)}
go
{CALL CT_States(NULL,520,NULL,NULL,NULL,10,'Yaren',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Bagmati',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Bheri',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Dhawalagiri',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Gandaki',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Janakpur',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Karnali',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Kosi',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Lumbini',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Mahakali',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Mechi',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Narayani',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Rapti',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Sagarmatha',NULL,NULL)}
go
{CALL CT_States(NULL,524,NULL,NULL,NULL,10,'Seti',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Drenthe',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Flevoland',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Friesland (Fryslan)',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Gelderland',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Groningen',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Limburg',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Noord-Brabant',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Noord-Holland',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Overijssel',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Utrecht',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Zeeland',NULL,NULL)}
go
{CALL CT_States(NULL,528,NULL,NULL,NULL,10,'Zuid-Holland',NULL,NULL)}
go
{CALL CT_States(NULL,540,NULL,NULL,NULL,10,'and Sud',NULL,NULL)}
go
{CALL CT_States(NULL,540,NULL,NULL,NULL,10,'Nord',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Malampa',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Penama',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Sanma',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Shefa',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Tafea',NULL,NULL)}
go
{CALL CT_States(NULL,548,NULL,NULL,NULL,10,'Torba',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Auckland',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Bay of Plenty',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Canterbury',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Chatham Islands',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Gisborne',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Hawke''s Bay',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Manawatu-Wanganui',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Marlborough',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Nelson',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Northland',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Otago',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Southland',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Taranaki',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Tasman',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Waikato',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'Wellington',NULL,NULL)}
go
{CALL CT_States(NULL,554,NULL,NULL,NULL,10,'West Coast',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Atlantico Norte',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Atlantico Sur',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Boaco',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Carazo',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Chinandega',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Chontales',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Esteli',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Granada',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Jinotega',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Leon',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Madriz',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Managua',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Masaya',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Matagalpa',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Nueva Segovia',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Rio San Juan',NULL,NULL)}
go
{CALL CT_States(NULL,558,NULL,NULL,NULL,10,'Rivas',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Agadez',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Diffa',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Dosso',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Maradi',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Niamey',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Tahoua',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Tillaberi',NULL,NULL)}
go
{CALL CT_States(NULL,562,NULL,NULL,NULL,10,'Zinder',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Abia',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Adamawa',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Akwa Ibom',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Anambra',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Bauchi',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Bayelsa',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Benue',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Borno',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Cross River',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Delta',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Ebonyi',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Edo',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Ekiti',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Enugu',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Federal Capital Territory',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Gombe',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Imo',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Jigawa',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Kaduna',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Kano',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Katsina',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Kebbi',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Kogi',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Kwara',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Lagos',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Nassarawa',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Niger',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Ogun',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Ondo',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Osun',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Oyo',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Plateau',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Rivers',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Sokoto',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Taraba',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Yobe',NULL,NULL)}
go
{CALL CT_States(NULL,566,NULL,NULL,NULL,10,'Zamfara',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Akershus',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Aust-Agder',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Buskerud',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Finnmark',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Hedmark',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Hordaland',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'More og Romsdal',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Nord-Trondelag',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Nordland',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Oppland',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Oslo',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Ostfold',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Rogaland',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Sogn og Fjordane',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Sor-Trondelag',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Telemark',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Troms',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Vest-Agder',NULL,NULL)}
go
{CALL CT_States(NULL,578,NULL,NULL,NULL,10,'Vestfold',NULL,NULL)}
go
{CALL CT_States(NULL,580,NULL,NULL,NULL,10,'Rota',NULL,NULL)}
go
{CALL CT_States(NULL,580,NULL,NULL,NULL,10,'Saipan',NULL,NULL)}
go
{CALL CT_States(NULL,580,NULL,NULL,NULL,10,'Tinian',NULL,NULL)}
go
{CALL CT_States(NULL,583,NULL,NULL,NULL,10,'Chuuk (Truk)',NULL,NULL)}
go
{CALL CT_States(NULL,583,NULL,NULL,NULL,10,'Kosrae (Kosaie)',NULL,NULL)}
go
{CALL CT_States(NULL,583,NULL,NULL,NULL,10,'Pohnpei (Ponape)',NULL,NULL)}
go
{CALL CT_States(NULL,583,NULL,NULL,NULL,10,'Yap',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ailinginae',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ailinglaplap',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ailuk',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Arno',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Aur',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Bikar',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Bikini',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Bokak',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ebon',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Enewetak',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Erikub',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Jabat',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Jaluit',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Jemo',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Kili',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Kwajalein',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Lae',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Lib',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Likiep',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Majuro',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Maloelap',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Mejit',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Mili',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Namorik',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Namu',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Rongelap',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Rongrik',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Toke',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ujae',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Ujelang',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Utirik',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Wotho',NULL,NULL)}
go
{CALL CT_States(NULL,584,NULL,NULL,NULL,10,'Wotje',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Aimeliik',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Airai',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Angaur',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Hatohobei',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Kayangel',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Koror',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Melekeok',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngaraard',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngarchelong',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngardmau',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngatpang',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngchesar',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngeremlengui',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Ngiwal',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Peleliu',NULL,NULL)}
go
{CALL CT_States(NULL,585,NULL,NULL,NULL,10,'Sonsorol',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'Balochistan',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'Federally Administered Tribal Areas',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'Islamabad Capital Territory',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'North-West Frontier Province',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'Punjab',NULL,NULL)}
go
{CALL CT_States(NULL,586,NULL,NULL,NULL,10,'Sindh',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'and Veraguas',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Bocas del Toro',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Chiriqui',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Cocle',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Colon',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Darien',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Herrera',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Los Santos',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'Panama',NULL,NULL)}
go
{CALL CT_States(NULL,591,NULL,NULL,NULL,10,'San Blas(Kuna Yala)',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Bougainville',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Chimbu',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'East New Britain',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'East Sepik',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Eastern Highlands',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Enga',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Gulf',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Madang',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Manus',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Milne Bay',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Morobe',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'National Capital',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'New Ireland',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Sandaun',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Southern Highlands',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'West New Britain',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,598,NULL,NULL,NULL,10,'Western Highlands',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Alto Paraguay',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Alto Parana',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Amambay',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Asuncion',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Boqueron',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Caaguazu',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Caazapa',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Canindeyu',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Concepcion',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Cordillera',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Guaira',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Itapua',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Misiones',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Neembucu',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Paraguari',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'Presidente Hayes',NULL,NULL)}
go
{CALL CT_States(NULL,600,NULL,NULL,NULL,10,'San Pedro',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Amazonas',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Ancash',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Apurimac',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Arequipa',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Ayacucho',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Cajamarca',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Callao',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Cusco',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Huancavelica',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Huanuco',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Ica',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Junin',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'La Libertad',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Lambayeque',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Lima',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Loreto',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Madre de Dios',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Moquegua',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Pasco',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Piura',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Puno',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'San Martin',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Tacna',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Tumbes',NULL,NULL)}
go
{CALL CT_States(NULL,604,NULL,NULL,NULL,10,'Ucayali',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Dolnoslaskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Kujawsko-Pomorskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Lodzkie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Lubelskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Lubuskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Malopolskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Mazowieckie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Opolskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Podkarpackie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Podlaskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Pomorskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Slaskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Swietokrzyskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Warminsko-Mazurskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Wielkopolskie',NULL,NULL)}
go
{CALL CT_States(NULL,616,NULL,NULL,NULL,10,'Zachodniopomorskie',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Acores (Azores)',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Aveiro',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Beja',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Braga',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Braganca',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Castelo Branco',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Coimbra',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Evora',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Faro',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Guarda',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Leiria',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Lisboa',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Madeira',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Portalegre',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Porto',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Santarem',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Setubal',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Viana do Castelo',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Vila Real',NULL,NULL)}
go
{CALL CT_States(NULL,620,NULL,NULL,NULL,10,'Viseu',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Bafata',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Biombo',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Bissau',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Bolama',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Cacheu',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Gabu',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Oio',NULL,NULL)}
go
{CALL CT_States(NULL,624,NULL,NULL,NULL,10,'Quinara',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Aguada',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Aguadilla',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Aguas Buenas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Aibonito',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Anasco',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Arecibo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Arroyo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Barceloneta',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Barranquitas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Bayamon',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Cabo Rojo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Caguas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Camuy',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Canovanas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Carolina',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Catano',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Cayey',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Ceiba',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Ciales',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Cidra',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Coamo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Comerio',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Corozal',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Culebra',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Dorado',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Fajardo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Florida',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Guanica',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Guayama',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Guayanilla',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Guaynabo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Gurabo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Hatillo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Hormigueros',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Humacao',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Isabela',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Jayuya',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Juana Diaz',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Juncos',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Lajas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Lares',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Las Marias',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Las Piedras',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Loiza',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Luquillo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Manati',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Maricao',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Maunabo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Mayaguez',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Moca',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Morovis',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Naguabo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Naranjito',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Orocovis',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Patillas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Penuelas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Ponce',NULL,NULL)}
go
{CALL CT_States('PR',630,NULL,NULL,NULL,100,'Puerto Rico',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Quebradillas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Rincon',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Rio Grande',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Sabana Grande',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Salinas',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'San German',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'San Juan',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'San Lorenzo',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'San Sebastian',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Santa Isabel',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Toa Alta',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Toa Baja',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Trujillo Alto',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Utuado',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Vega Alta',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Vega Baja',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Vieques',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Villalba',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Yabucoa',NULL,NULL)}
go
{CALL CT_States(NULL,630,NULL,NULL,NULL,10,'Yauco',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Ad Dawhah',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Al Ghuwayriyah',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Al Jumayliyah',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Al Khawr',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Al Wakrah',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Ar Rayyan',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Jarayan al Batinah',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Madinat ash Shamal',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Umm Sa''id',NULL,NULL)}
go
{CALL CT_States(NULL,634,NULL,NULL,NULL,10,'Umm Salal',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Alba',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Arad',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Arges',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Bacau',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Bihor',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Bistrita-Nasaud',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Botosani',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Braila',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Brasov',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Bucuresti (Bucharest)',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Buzau',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Calarasi',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Caras-Severin',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Cluj',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Constanta',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Covasna',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Dimbovita',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Dolj',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Galati',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Giurgiu',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Gorj',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Harghita',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Hunedoara',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Ialomita',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Iasi',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Ilfov',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Maramures',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Mehedinti',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Mures',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Neamt',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Olt',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Prahova',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Salaj',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Satu Mare',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Sibiu',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Suceava',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Teleorman',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Timis',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Tulcea',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Vaslui',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Vilcea',NULL,NULL)}
go
{CALL CT_States(NULL,642,NULL,NULL,NULL,10,'Vrancea',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Adygeya (Maykop)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Aga Buryat (Aginskoye)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Altay (Barnaul)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Altay (Gorno-Altaysk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Amur (Blagoveshchensk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Arkhangel''sk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Astrakhan''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Bashkortostan (Ufa)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Belgorod',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Bryansk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Buryatiya (Ulan-Ude)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Chechnya (Groznyy)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Chelyabinsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Chita',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Chukotka (Anadyr'')',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Chuvashiya (Cheboksary)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Dagestan (Makhachkala)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Evenk (Tura)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Ingushetiya (Magas)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Irkutsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Ivanovo',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kabardino-Balkariya (Nal''chik)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kaliningrad',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kalmykiya (Elista)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kaluga',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kamchatka (Petropavlovsk-Kamchatskiy)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Karachayevo-Cherkesiya (Cherkessk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kareliya (Petrozavodsk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kemerovo',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Khabarovsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Khakasiya (Abakan)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Khanty-Mansi',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kirov',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Komi (Syktyvkar)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Komi-Permyak (Kudymkar)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Koryak (Palana)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kostroma',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Krasnodar',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Krasnoyarsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kurgan',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Kursk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Leningrad',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Lipetsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Magadan',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Mariy-El (Yoshkar-Ola)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Mordoviya (Saransk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Moscow',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Murmansk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Nenets (Nar''yan-Mar)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Nizhniy Novgorod',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'North Ossetia (Vladikavkaz)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Novgorod',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Novosibirsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Omsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Orel',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Orenburg',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Penza',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Perm''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Primorskiy (Vladivostok)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Pskov',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Rostov',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Ryazan''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Saint Petersburg (Sankt-Peterburg)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Sakha (Yakutsk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Sakhalin (Yuzhno-Sakhalinsk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Samara',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Saratov',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Smolensk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Stavropol''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Sverdlovsk (Yekaterinburg)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tambov',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tatarstan (Kazan'')',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Taymyr (Dudinka),',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tomsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tula',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tver''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tyumen''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Tyva (Kyzyl)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Udmurtiya (Izhevsk)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Ul''yanovsk',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Ust''-Orda Buryat (Ust''-Ordynskiy),',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Vladimir',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Volgograd',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Vologda',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Voronezh',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Yamalo-Nenets (Salekhard)',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Yaroslavl''',NULL,NULL)}
go
{CALL CT_States(NULL,643,NULL,NULL,NULL,0,'Yevrey (Birobidzhan)',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Byumba',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Cyangugu',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Gikongoro',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Gisenyi',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Gitarama',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'in Kinyarwanda',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Kibungo',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Kibuye',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Kigali Rurale',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Kigali-ville',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Ruhengeri',NULL,NULL)}
go
{CALL CT_States(NULL,646,NULL,NULL,NULL,10,'Umutara',NULL,NULL)}
go
{CALL CT_States(NULL,654,NULL,NULL,NULL,10,'Ascension',NULL,NULL)}
go
{CALL CT_States(NULL,654,NULL,NULL,NULL,10,'Saint Helena',NULL,NULL)}
go
{CALL CT_States(NULL,654,NULL,NULL,NULL,10,'Tristan da Cunha',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Christ Church Nichola Town',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Anne Sandy Point',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint George Basseterre',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint George Gingerland',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint James Windward',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint John Capesterre',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint John Figtree',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Mary Cayon',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Paul Capesterre',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Paul Charlestown',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Peter Basseterre',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Thomas Lowland',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Saint Thomas Middle Island',NULL,NULL)}
go
{CALL CT_States(NULL,659,NULL,NULL,NULL,10,'Trinity Palmetto Point',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Anse-la-Raye',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Castries',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Choiseul',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Dauphin',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Dennery',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Gros-Islet',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Laborie',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Micoud',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Praslin',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Soufriere',NULL,NULL)}
go
{CALL CT_States(NULL,662,NULL,NULL,NULL,10,'Vieux-Fort',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Charlotte',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Grenadines',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Saint Andrew',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Saint David',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Saint George',NULL,NULL)}
go
{CALL CT_States(NULL,670,NULL,NULL,NULL,10,'Saint Patrick',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Acquaviva',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Borgo Maggiore',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Chiesanuova',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Domagnano',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Faetano',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Fiorentino',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Montegiardino',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'San Marino Citta',NULL,NULL)}
go
{CALL CT_States(NULL,674,NULL,NULL,NULL,10,'Serravalle',NULL,NULL)}
go
{CALL CT_States(NULL,678,NULL,NULL,NULL,10,'Principe',NULL,NULL)}
go
{CALL CT_States(NULL,678,NULL,NULL,NULL,10,'Sao Tome',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'''Asir',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Al Bahah',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Al Hudud ash Shamaliyah',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Al Jawf',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Al Madinah',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Al Qasim',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Ar Riyad',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Ash Sharqiyah (Eastern Province)',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Ha''il',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Jizan',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Makkah',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Najran',NULL,NULL)}
go
{CALL CT_States(NULL,682,NULL,NULL,NULL,10,'Tabuk',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Dakar',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Diourbel',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Fatick',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Kaolack',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Kolda',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Louga',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Matam',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Saint-Louis',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Tambacounda',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Thies',NULL,NULL)}
go
{CALL CT_States(NULL,686,NULL,NULL,NULL,10,'Ziguinchor',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Anse aux Pins',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Anse Boileau',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Anse Etoile',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Anse Louis',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Anse Royale',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Baie Lazare',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Baie Sainte Anne',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Beau Vallon',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Bel Air',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Bel Ombre',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Cascade',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Glacis',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Grand'' Anse (on Mahe)',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Grand'' Anse (on Praslin)',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'La Digue',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'La Riviere Anglaise',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Mont Buxton',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Mont Fleuri',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Plaisance',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Pointe La Rue',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Port Glaud',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Saint Louis',NULL,NULL)}
go
{CALL CT_States(NULL,690,NULL,NULL,NULL,10,'Takamaka',NULL,NULL)}
go
{CALL CT_States(NULL,694,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,694,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,694,NULL,NULL,NULL,10,'Southern',NULL,NULL)}
go
{CALL CT_States(NULL,694,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Banskobystricky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Bratislavsky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Kosicky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Nitriansky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Presovsky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Trenciansky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Trnavsky',NULL,NULL)}
go
{CALL CT_States(NULL,703,NULL,NULL,NULL,10,'Zilinsky',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Awdal',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Bakool',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Banaadir',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Bari',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Bay',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Galguduud',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Gedo',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Hiiraan',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Jubbada Dhexe',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Jubbada Hoose',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Mudug',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Nugaal',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Sanaag',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Shabeellaha Dhexe',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Shabeellaha Hoose',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Sool',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Togdheer',NULL,NULL)}
go
{CALL CT_States(NULL,706,NULL,NULL,NULL,10,'Woqooyi Galbeed',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Eastern Cape',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Free State',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Gauteng',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'KwaZulu-Natal',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Limpopo',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Mpumalanga',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'North-West',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Northern Cape',NULL,NULL)}
go
{CALL CT_States(NULL,710,NULL,NULL,NULL,10,'Western Cape',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Bulawayo',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Harare',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Manicaland',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Mashonaland Central',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Mashonaland East',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Mashonaland West',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Masvingo',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Matabeleland North',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Matabeleland South',NULL,NULL)}
go
{CALL CT_States(NULL,716,NULL,NULL,NULL,10,'Midlands',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Andalucia',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Aragon',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Asturias',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Baleares (Balearic Islands)',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Canarias (Canary Islands)',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Cantabria',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Castilla y Leon',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Castilla-La Mancha',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Cataluna',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Ceuta',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Comunidad Valenciana',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Extremadura',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Galicia',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'La Rioja',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Madrid',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Melilla',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Murcia',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Navarra',NULL,NULL)}
go
{CALL CT_States(NULL,724,NULL,NULL,NULL,10,'Pais Vasco (Basque Country)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'A''ali an Nil (Upper Nile)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Bahr al Ahmar (Red Sea)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Buhayrat (Lakes)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Jazirah (El Gezira)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Khartum (Khartoum)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Qadarif (Gedaref)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Al Wahdah (Unity)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'An Nil al Abyad (White Nile)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'An Nil al Azraq (Blue Nile)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Ash Shamaliyah (Northern)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Bahr al Jabal (Bahr al Jabal)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Gharb al Istiwa''iyah (Western Equatoria)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Gharb Bahr al Ghazal (Western Bahr al Ghazal)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Gharb Darfur (Western Darfur)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Gharb Kurdufan (Western Kordofan)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Janub Darfur (Southern Darfur)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Janub Kurdufan (Southern Kordofan)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Junqali (Jonglei)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Kassala (Kassala)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Nahr an Nil (Nile)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Shamal Bahr al Ghazal (Northern Bahr al Ghazal)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Shamal Darfur (Northern Darfur)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Shamal Kurdufan (Northern Kordofan)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Sharq al Istiwa''iyah (Eastern Equatoria)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Sinnar (Sinnar)',NULL,NULL)}
go
{CALL CT_States(NULL,736,NULL,NULL,NULL,10,'Warab (Warab)',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Brokopondo',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Commewijne',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Coronie',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Marowijne',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Nickerie',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Para',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Paramaribo',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Saramacca',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Sipaliwini',NULL,NULL)}
go
{CALL CT_States(NULL,740,NULL,NULL,NULL,10,'Wanica',NULL,NULL)}
go
{CALL CT_States(NULL,748,NULL,NULL,NULL,10,'Hhohho',NULL,NULL)}
go
{CALL CT_States(NULL,748,NULL,NULL,NULL,10,'Lubombo',NULL,NULL)}
go
{CALL CT_States(NULL,748,NULL,NULL,NULL,10,'Manzini',NULL,NULL)}
go
{CALL CT_States(NULL,748,NULL,NULL,NULL,10,'Shiselweni',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Blekinge',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Dalarnas',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Gavleborgs',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Gotlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Hallands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Jamtlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Jonkopings',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Kalmar',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Kronobergs',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Norrbottens',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Orebro',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Ostergotlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Skane',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Sodermanlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Stockholms',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Uppsala',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Varmlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Vasterbottens',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Vasternorrlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Vastmanlands',NULL,NULL)}
go
{CALL CT_States(NULL,752,NULL,NULL,NULL,10,'Vastra Gotalands',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Appenzell Ausser-Rhoden',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Appenzell Inner-Rhoden',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Basel-Landschaft',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Basel-Stadt',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Bern',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'cantoni',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Fribourg',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Geneve',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Glarus',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Graubunden',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Jura',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Luzern',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Neuchatel',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Nidwalden',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Obwalden',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Sankt Gallen',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Schaffhausen',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Schwyz',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'singular - cantone in Italian',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'singular - kanton in German)',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Solothurn',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Thurgau',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Ticino',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Uri',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Valais',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Vaud',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Zug',NULL,NULL)}
go
{CALL CT_States(NULL,756,NULL,NULL,NULL,10,'Zurich',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Al Hasakah',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Al Ladhiqiyah',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Al Qunaytirah',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Ar Raqqah',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'As Suwayda''',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Dar''a',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Dayr az Zawr',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Dimashq',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Halab',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Hamah',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Hims',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Idlib',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Rif Dimashq',NULL,NULL)}
go
{CALL CT_States(NULL,760,NULL,NULL,NULL,10,'Tartus',NULL,NULL)}
go
{CALL CT_States(NULL,762,NULL,NULL,NULL,10,'Viloyati Khatlon (Qurghonteppa)',NULL,NULL)}
go
{CALL CT_States(NULL,762,NULL,NULL,NULL,10,'Viloyati Mukhtori Kuhistoni Badakhshon',NULL,NULL)}
go
{CALL CT_States(NULL,762,NULL,NULL,NULL,10,'Viloyati Sughd (Khujand)',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Amnat Charoen',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Ang Thong',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Buriram',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chachoengsao',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chai Nat',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chaiyaphum',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chanthaburi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chiang Mai',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chiang Rai',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chon Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Chumphon',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Kalasin',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Kamphaeng Phet',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Kanchanaburi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Khon Kaen',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Krabi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Krung Thep Mahanakhon (Bangkok)',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Lampang',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Lamphun',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Loei',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Lop Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Mae Hong Son',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Maha Sarakham',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Mukdahan',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Nayok',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Pathom',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Phanom',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Ratchasima',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Sawan',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nakhon Si Thammarat',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nan',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Narathiwat',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nong Bua Lamphu',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nong Khai',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Nonthaburi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Pathum Thani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Pattani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phangnga',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phatthalung',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phayao',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phetchabun',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phetchaburi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phichit',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phitsanulok',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phra Nakhon Si Ayutthaya',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phrae',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Phuket',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Prachin Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Prachuap Khiri Khan',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Ranong',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Ratchaburi',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Rayong',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Roi Et',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sa Kaeo',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sakon Nakhon',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Samut Prakan',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Samut Sakhon',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Samut Songkhram',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sara Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Satun',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sing Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sisaket',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Songkhla',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Sukhothai',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Suphan Buri',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Surat Thani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Surin',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Tak',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Trang',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Trat',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Ubon Ratchathani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Udon Thani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Uthai Thani',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Uttaradit',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Yala',NULL,NULL)}
go
{CALL CT_States(NULL,764,NULL,NULL,NULL,10,'Yasothon',NULL,NULL)}
go
{CALL CT_States(NULL,768,NULL,NULL,NULL,10,'Centrale',NULL,NULL)}
go
{CALL CT_States(NULL,768,NULL,NULL,NULL,10,'Kara',NULL,NULL)}
go
{CALL CT_States(NULL,768,NULL,NULL,NULL,10,'Maritime',NULL,NULL)}
go
{CALL CT_States(NULL,768,NULL,NULL,NULL,10,'Plateaux',NULL,NULL)}
go
{CALL CT_States(NULL,768,NULL,NULL,NULL,10,'Savanes',NULL,NULL)}
go
{CALL CT_States(NULL,776,NULL,NULL,NULL,10,'Ha''apai',NULL,NULL)}
go
{CALL CT_States(NULL,776,NULL,NULL,NULL,10,'Tongatapu',NULL,NULL)}
go
{CALL CT_States(NULL,776,NULL,NULL,NULL,10,'Vava''u',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Aileu',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Ainaro',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Baucau',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Bobonaro (Maliana)',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Cova-Lima (Suai)',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Dili',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Ermera',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Lautem (Los Palos)',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Liquica',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Manatuto',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Manufahi (Same)',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Oecussi (Ambeno)',NULL,NULL)}
go
{CALL CT_States(NULL,780,NULL,NULL,NULL,10,'Viqueque',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'''Ajman',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Abu Zaby (Abu Dhabi)',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Al Fujayrah',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Ash Shariqah (Sharjah)',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Dubayy (Dubai)',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Ra''s al Khaymah',NULL,NULL)}
go
{CALL CT_States(NULL,784,NULL,NULL,NULL,10,'Umm al Qaywayn',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Ariana (Aryanah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Beja (Bajah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Ben Arous (Bin ''Arus)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Bizerte (Banzart)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Gabes (Qabis)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Gafsa (Qafsah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Jendouba (Jundubah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Kairouan (Al Qayrawan)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Kasserine (Al Qasrayn)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Kebili (Qibili)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Kef (Al Kaf)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Mahdia (Al Mahdiyah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Manouba (Manubah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Medenine (Madanin)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Monastir (Al Munastir)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Nabeul (Nabul)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Sfax (Safaqis)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Sidi Bou Zid (Sidi Bu Zayd)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Siliana (Silyanah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Sousse (Susah)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Tataouine (Tatawin)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Tozeur (Tawzar)',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Tunis',NULL,NULL)}
go
{CALL CT_States(NULL,788,NULL,NULL,NULL,10,'Zaghouan (Zaghwan)',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Adana',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Adiyaman',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Afyonkarahisar',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Agri',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Aksaray',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Amasya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Ankara',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Antalya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Ardahan',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Artvin',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Aydin',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Balikesir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bartin',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Batman',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bayburt',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bilecik',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bingol',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bitlis',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bolu',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Burdur',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Bursa',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Canakkale',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Cankiri',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Corum',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Denizli',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Diyarbakir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Duzce',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Edirne',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Elazig',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Erzincan',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Erzurum',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Eskisehir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Gaziantep',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Giresun',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Gumushane',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Hakkari',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Hatay',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Igdir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Isparta',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Istanbul',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Izmir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kahramanmaras',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Karabuk',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Karaman',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kars',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kastamonu',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kayseri',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kilis',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kirikkale',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kirklareli',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kirsehir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kocaeli',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Konya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Kutahya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Malatya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Manisa',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Mardin',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Mersin',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Mugla',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Mus',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Nevsehir',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Nigde',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Ordu',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Osmaniye',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Rize',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Sakarya',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Samsun',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Sanliurfa',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Siirt',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Sinop',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Sirnak',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Sivas',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Tekirdag',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Tokat',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Trabzon',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Tunceli',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Usak',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Van',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Yalova',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Yozgat',NULL,NULL)}
go
{CALL CT_States(NULL,792,NULL,NULL,NULL,10,'Zonguldak',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Adjumani',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Apac',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Arua',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Bugiri',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Bundibugyo',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Bushenyi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Busia',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Gulu',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Hoima',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Iganga',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Jinja',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kabale',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kabarole',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kaberamaido',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kalangala',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kampala',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kamuli',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kamwenge',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kanungu',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kapchorwa',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kasese',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Katakwi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kayunga',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kibale',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kiboga',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kisoro',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kitgum',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kotido',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kumi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Kyenjojo',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Lira',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Luwero',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Masaka',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Masindi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mayuge',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mbale',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mbarara',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Moroto',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Moyo',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mpigi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mubende',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Mukono',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Nakapiripirit',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Nakasongola',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Nebbi',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Ntungamo',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Pader',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Pallisa',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Rakai',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Rukungiri',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Sembabule',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Sironko',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Soroti',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Tororo',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Wakiso',NULL,NULL)}
go
{CALL CT_States(NULL,800,NULL,NULL,NULL,10,'Yumbe',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Cherkasy',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Chernihiv',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Chernivtsi',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Crimea or Avtonomna Respublika Krym (Simferopol'')',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Dnipropetrovs''k',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Donets''k',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Ivano-Frankivs''k',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Kharkiv',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Kherson',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Khmel''nyts''kyy',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Kiev (Kyyiv)',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Kirovohrad',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Kyyiv',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'L''viv',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Luhans''k',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Mykolayiv',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Odesa',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Poltava',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Rivne',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Sevastopol''',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Sumy',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Ternopil''',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Vinnytsya',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Volyn'' (Luts''k)',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Zakarpattya (Uzhhorod)',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Zaporizhzhya',NULL,NULL)}
go
{CALL CT_States(NULL,804,NULL,NULL,NULL,10,'Zhytomyr',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Aerodrom (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Aracinovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Berovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Bitola',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Bogdanci',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Bogovinje',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Bosilovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Brvenica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Butel (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Cair (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Caska',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Centar (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Centar Zupa',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Cesinovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Cucer-Sandevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Debar',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Debartsa',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Delcevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Demir Hisar',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Demir Kapija',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Dojran',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Dolneni',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Drugovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Gazi Baba (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Gevgelija',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Gjorce Petrov (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Gostivar',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Gradsko',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Ilinden',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Jegunovce',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Karbinci',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Karpos (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kavadarci',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kicevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kisela Voda (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kocani',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Konce',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kratovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kriva Palanka',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Krivogastani',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Krusevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Kumanovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Lipkovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Lozovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Makedonska Kamenica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Makedonski Brod',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Mavrovo i Rastusa',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Mogila',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Negotino',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Novaci',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Novo Selo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Ohrid',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Oslomej',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Pehcevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Petrovec',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Plasnica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Prilep',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Probistip',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Radovis',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Rankovce',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Resen',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Rosoman',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Saraj (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Skopje',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Sopiste',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Staro Nagoricane',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Stip',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Struga',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Strumica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Studenicani',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Suto Orizari (Skopje)',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Sveti Nikole',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Tearce',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Tetovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Valandovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Vasilevo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Veles',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Vevcani',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Vinica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Vranestica',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Vrapciste',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Zajas',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Zelenikovo',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Zelino',NULL,NULL)}
go
{CALL CT_States(NULL,807,NULL,NULL,NULL,10,'Zrnovci',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Ad Daqahliyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Bahr al Ahmar',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Buhayrah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Fayyum',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Gharbiyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Iskandariyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Isma''iliyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Jizah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Minufiyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Minya',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Qahirah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Qalyubiyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Al Wadi al Jadid',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'As Suways',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Ash Sharqiyah',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Aswan',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Asyut',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Bani Suwayf',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Bur Sa''id',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Dumyat',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Janub Sina''',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Kafr ash Shaykh',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Matruh',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Qina',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Shamal Sina''',NULL,NULL)}
go
{CALL CT_States(NULL,818,NULL,NULL,NULL,10,'Suhaj',NULL,NULL)}
go
{CALL CT_States(NULL,826,NULL,NULL,NULL,0,'England',NULL,NULL)}
go
{CALL CT_States(NULL,826,NULL,NULL,NULL,0,'Northern Ireland',NULL,NULL)}
go
{CALL CT_States(NULL,826,NULL,NULL,NULL,0,'Scotland',NULL,NULL)}
go
{CALL CT_States(NULL,826,NULL,NULL,NULL,0,'Wales',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Arusha',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Dar es Salaam',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Dodoma',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Iringa',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Kagera',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Kigoma',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Kilimanjaro',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Lindi',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Manyara',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Mara',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Mbeya',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Morogoro',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Mtwara',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Mwanza',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Pemba North',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Pemba South',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Pwani',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Rukwa',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Ruvuma',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Shinyanga',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Singida',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Tabora',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Tanga',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Zanzibar Central/South',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Zanzibar North',NULL,NULL)}
go
{CALL CT_States(NULL,834,NULL,NULL,NULL,10,'Zanzibar Urban/West',NULL,NULL)}
go
{CALL CT_States('AL',840,NULL,'01','Southeast',10,'Alabama',-6.00,NULL)}
go
{CALL CT_States('AK',840,NULL,'02','Western',10,'Alaska',-9.00,NULL)}
go
{CALL CT_States('AZ',840,NULL,'04','Western',10,'Arizona',-7.00,-8.00)}
go
{CALL CT_States('AR',840,NULL,'05','Southwest',10,'Arkansas',-6.00,NULL)}
go
{CALL CT_States('CA',840,NULL,'06','West Coast',10,'California',-8.00,NULL)}
go
{CALL CT_States('CO',840,NULL,'08','Western',10,'Colorado',-7.00,NULL)}
go
{CALL CT_States('CT',840,NULL,'09','Northeast',10,'Connecticut',-5.00,NULL)}
go
{CALL CT_States('DE',840,NULL,'10','Mid-Atlantic',10,'Delaware',-5.00,NULL)}
go
{CALL CT_States('DC',840,NULL,'11','Mid-Atlantic',10,'District of Columbia',-5.00,NULL)}
go
{CALL CT_States('FL',840,NULL,'12','Southeast',10,'Florida',-5.00,NULL)}
go
{CALL CT_States('GA',840,NULL,'13','Southeast',10,'Georgia',-5.00,NULL)}
go
{CALL CT_States('HI',840,NULL,'15','West Coast',10,'Hawaii',-10.00,NULL)}
go
{CALL CT_States('ID',840,NULL,'16','Western',10,'Idaho',-8.00,NULL)}
go
{CALL CT_States('IL',840,NULL,'17','Mid-West',10,'Illinois',-6.00,NULL)}
go
{CALL CT_States('IN',840,NULL,'18','Mid-West',10,'Indiana',-5.00,-6.00)}
go
{CALL CT_States('IA',840,NULL,'19','Western',10,'Iowa',-6.00,NULL)}
go
{CALL CT_States('KS',840,NULL,'20','Southwest',10,'Kansas',-6.00,NULL)}
go
{CALL CT_States('KY',840,NULL,'21','Southeast',10,'Kentucky',-5.00,-6.00)}
go
{CALL CT_States('LA',840,NULL,'22','Southeast',10,'Louisiana',-6.00,NULL)}
go
{CALL CT_States('ME',840,NULL,'23','Northeast',10,'Maine',-5.00,NULL)}
go
{CALL CT_States('MD',840,NULL,'24','Mid-Atlantic',10,'Maryland',-5.00,NULL)}
go
{CALL CT_States('MA',840,NULL,'25','Northeast',10,'Massachusetts',-5.00,NULL)}
go
{CALL CT_States('MI',840,NULL,'26','Mid-West',10,'Michigan',-5.00,-6.00)}
go
{CALL CT_States('MN',840,NULL,'27','Western',10,'Minnesota',-6.00,NULL)}
go
{CALL CT_States('MS',840,NULL,'28','Southeast',10,'Mississippi',-6.00,NULL)}
go
{CALL CT_States('MO',840,NULL,'29','Southwest',10,'Missouri',-6.00,NULL)}
go
{CALL CT_States('MT',840,NULL,'30','Western',10,'Montana',-7.00,NULL)}
go
{CALL CT_States('NE',840,NULL,'31','Western',10,'Nebraska',-6.00,-7.00)}
go
{CALL CT_States('NV',840,NULL,'32','West Coast',10,'Nevada',-8.00,NULL)}
go
{CALL CT_States('NH',840,NULL,'33','Northeast',10,'New Hampshire',-5.00,NULL)}
go
{CALL CT_States('NJ',840,NULL,'34','Mid-Atlantic',10,'New Jersey',-5.00,NULL)}
go
{CALL CT_States('NM',840,NULL,'35','Western',10,'New Mexico',-7.00,NULL)}
go
{CALL CT_States('NY',840,NULL,'36','Northeast',10,'New York',-5.00,NULL)}
go
{CALL CT_States('NC',840,NULL,'37','Southeast',10,'North Carolina',-5.00,NULL)}
go
{CALL CT_States('ND',840,NULL,'38','Western',10,'North Dakota',-6.00,NULL)}
go
{CALL CT_States('OH',840,NULL,'39','Mid-West',10,'Ohio',-5.00,NULL)}
go
{CALL CT_States('OK',840,NULL,'40','Southwest',10,'Oklahoma',-6.00,NULL)}
go
{CALL CT_States('OR',840,NULL,'41','Western',10,'Oregon',-8.00,NULL)}
go
{CALL CT_States('PA',840,NULL,'42','Mid-Atlantic',10,'Pennsylvania',-5.00,NULL)}
go
{CALL CT_States('RI',840,NULL,'44','Northeast',10,'Rhode Island',-5.00,NULL)}
go
{CALL CT_States('SC',840,NULL,'45','Southeast',10,'South Carolina',-5.00,NULL)}
go
{CALL CT_States('SD',840,NULL,'46','Western',10,'South Dakota',-6.00,-7.00)}
go
{CALL CT_States('TN',840,NULL,'47','Southeast',10,'Tennessee',-6.00,-5.00)}
go
{CALL CT_States('TX',840,NULL,'48','Southwest',10,'Texas',-6.00,-7.00)}
go
{CALL CT_States('UT',840,NULL,'49','Western',10,'Utah',-7.00,NULL)}
go
{CALL CT_States('VT',840,NULL,'50','Northeast',10,'Vermont',-5.00,NULL)}
go
{CALL CT_States('VA',840,NULL,'51','Mid-Atlantic',10,'Virginia',-5.00,NULL)}
go
{CALL CT_States('WA',840,NULL,'53','Western',1,'Washington',-8.00,NULL)}
go
{CALL CT_States('WV',840,NULL,'54','Mid-Atlantic',10,'West Virginia',-5.00,NULL)}
go
{CALL CT_States('WI',840,NULL,'55','Mid-West',10,'Wisconsin',-6.00,NULL)}
go
{CALL CT_States('WY',840,NULL,'56','Western',10,'Wyoming',-7.00,NULL)}
go
{CALL CT_States(NULL,850,NULL,NULL,NULL,10,'Saint John',NULL,NULL)}
go
{CALL CT_States(NULL,850,NULL,NULL,NULL,10,'Saint Thomas',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Acklins and Crooked Islands',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Bale',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Bam',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Banwa',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Bazega',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Bimini',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Bougouriba',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Boulgou',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Boulkiemde',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Cat Island',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Comoe',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Exuma',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Freeport',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Fresh Creek',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Ganzourgou',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Gnagna',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Gourma',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Governor''s Harbour',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Green Turtle Cay',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Harbour Island',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'High Rock',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Houet',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Inagua',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Ioba',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kadiogo',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kemps Bay',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kenedougou',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Komondjari',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kompienga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kossi',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Koulpelogo',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kouritenga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Kourweogo',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Leraba',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Long Island',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Loroum',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Marsh Harbour',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Mayaguana',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Mouhoun',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Nahouri',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Namentenga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Nayala',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'New Providence',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Nichollstown and Berry Islands',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Noumbiel',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Oubritenga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Oudalan',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Passore',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Poni',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Ragged Island',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Rock Sound',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'San Salvador and Rum Cay',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Sandy Point',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Sanguie',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Sanmatenga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Seno',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Sissili',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Soum',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Sourou',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Tapoa',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Tuy',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Yagha',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Yatenga',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Ziro',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Zondoma',NULL,NULL)}
go
{CALL CT_States(NULL,854,NULL,NULL,NULL,10,'Zoundweogo',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Artigas',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Canelones',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Cerro Largo',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Colonia',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Durazno',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Flores',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Florida',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Lavalleja',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Maldonado',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Montevideo',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Paysandu',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Rio Negro',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Rivera',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Rocha',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Salto',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'San Jose',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Soriano',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Tacuarembo',NULL,NULL)}
go
{CALL CT_States(NULL,858,NULL,NULL,NULL,10,'Treinta y Tres',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Andijon Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Buxoro Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Farg''ona Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Jizzax Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Namangan Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Navoiy Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Qaraqalpog''iston Respublikasi (Nukus)',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Qashqadaryo Viloyati (Qarshi)',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Samarqand Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Sirdaryo Viloyati (Guliston)',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Surxondaryo Viloyati (Termiz)',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Toshkent Shahri',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Toshkent Viloyati',NULL,NULL)}
go
{CALL CT_States(NULL,860,NULL,NULL,NULL,10,'Xorazm Viloyati (Urganch)',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Amazonas',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Anzoategui',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Apure',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Aragua',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Barinas',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Bolivar',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Carabobo',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Cojedes',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Delta Amacuro',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Dependencias Federales',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Distrito Federal',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Falcon',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Guarico',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Lara',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Merida',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Miranda',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Monagas',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Nueva Esparta',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Portuguesa',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Sucre',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Tachira',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Trujillo',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Vargas',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Yaracuy',NULL,NULL)}
go
{CALL CT_States(NULL,862,NULL,NULL,NULL,10,'Zulia',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'A''ana',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Aiga-i-le-Tai',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Atua',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Fa''asaleleaga',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Gaga''emauga',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Gagaifomauga',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Palauli',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Satupa''itea',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Tuamasaga',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Va''a-o-Fonoti',NULL,NULL)}
go
{CALL CT_States(NULL,882,NULL,NULL,NULL,10,'Vaisigano',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'''Adan',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'''Amran',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Abyan',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Ad Dali''',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Al Bayda''',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Al Hudaydah',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Al Jawf',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Al Mahrah',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Al Mahwit',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Dhamar',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Hadramawt',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Hajjah',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Ibb',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Lahij',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Ma''rib',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Sa''dah',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'San''a''',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Shabwah',NULL,NULL)}
go
{CALL CT_States(NULL,887,NULL,NULL,NULL,10,'Ta''izz',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Central',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Copperbelt',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Eastern',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Luapula',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Lusaka',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'North-Western',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Northern',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Southern',NULL,NULL)}
go
{CALL CT_States(NULL,894,NULL,NULL,NULL,10,'Western',NULL,NULL)}
go
{CALL CT_SyncExamples('Listing of all posted payments',0,8,'PaymentID','SELECT p.PaymentID, p.CustomerID, a.FirstName, a.LastName, a.Company, g.GroupName, p.CreateDate, p.CreateUser, pt.PaymentType, p.CheckNumber, p.PayInfo, COALESCE(p.FinalAmount,p.Amount) AS CurrentAmount, p.ExternalRef, gl.GLCode
FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)','Billing payments',1)}
go
{CALL CT_SyncExamples('Listing of all processed invoices including voided invoices',0,8,'InvoiceID','SELECT i.InvoiceID, i.CustomerID, a.FirstName, a.LastName, a.Company, g.GroupName, it.InvoiceType, CASE WHEN i.VoidDate IS NOT NULL THEN ''Voided'' WHEN i.ChargeAmount <= i.PaidAmount THEN ''Paid'' ELSE ''Unpaid'' END AS Status,
i.Amount, i.PaidAmount, i.CreateDate, i.Tax, i.VoidDate, COALESCE(i.PO,ma.PO) AS PO, i.ExtInvoiceNum, i.Comments
FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN InvoiceTypes it ON (i.InvoiceTypeID = it.InvoiceTypeID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	WHERE i.Processed = 1

','Billing invoices',2)}
go
{CALL CT_SyncExamples('Listing of all account statements',0,8,'StatementID','SELECT s.StatementID, s.CustomerID, a.FirstName, a.LastName, a.Company, g.GroupName, s.StatementDate, s.DueDate, s.PrevBal, s.NewCharges, s.NewCredits, s.EndBal, s.End0Bal, s.End30Bal, s.End60Bal, s.End90Bal, s.End120Bal
FROM Statements s JOIN MasterAccounts ma ON (s.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)	
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)

','Billing statements',3)}
go
{CALL CT_SyncExamples('List of all active MBRs',0,NULL,'CustomerID','SELECT ma.CustomerID, o.Organization, g.GroupName,
aab.FirstName AS BillFirstName, aab.LastName AS BillLastName, aab.Company AS BillCompany, aab.Address1 AS BillAddress1,
aab.Address2 AS BillAddress2, aab.City AS BillCity, bs.State AS BillState, bs.Abbreviation AS BillStateAbbr, aab.Zip AS BillZip,
bco.Country AS BillCountry, aab.PhoneHome AS BillPhoneHome, aab.PhoneWork AS BillPhoneWork, aab.PhoneMobile AS BillPhoneMobile,
aab.Email AS BillEmail,

aas.FirstName AS ShipFirstName, aas.LastName AS ShipLastName, aas.Company AS ShipCompany, aas.Address1 AS ShipAddress1,
aas.Address2 AS ShipAddress2, aas.City AS ShipCity, ss.State AS ShipState, ss.Abbreviation AS ShipStateAbbr, aas.Zip AS ShipZip,
sc.Country AS ShipCountry, aas.PhoneHome AS ShipPhoneHome, aas.PhoneWork AS ShipPhoneWork, aas.PhoneMobile AS ShipPhoneMobile,
aas.Email AS ShipEmail, 

r.Region, rb.ReferredBy, sp.SalesPerson, ma.CreateDate, ma.CreateUser, ma.StartDate,  
CASE WHEN ma.Active = 0 THEN ''Inactive'' WHEN ma.CancelDate < getdate() THEN ''Canceled'' ELSE ''Active'' END AS Status,
pp.PayPeriod AS DefaultPayPeriod, pt.PaymentType AS PayMethod,
g.GroupName, sm.SendMethod, bc.BillingCycle, CASE WHEN bc.CycleType = 0 THEN ma.BillDay ELSE bc.BillDay END AS BillDay, ma.TempExtension, ma.Balance, ma.PendingBalance, ma.CreditLimit,
ma.PO AS StandingPO, ma.PIN, ma.ExternalRef, ma.TransHoldDate, ma.CancelDate, cr.CancelReason, ma.Comments

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN Addresses aab ON (ma.BillingAddressID = aab.AddressID)
	LEFT JOIN Countries bco ON (aab.CountryID = bco.CountryID)
	LEFT JOIN States bs ON (aab.StateID = bs.StateID)
	LEFT JOIN Addresses aas ON (ma.ShippingAddressID = aas.AddressID)
	LEFT JOIN Countries sc ON (aas.CountryID = sc.CountryID)
	LEFT JOIN States ss ON (aas.StateID = ss.StateID)
	JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
	LEFT JOIN SalesPersons sp ON (ma.SalesPersonID = sp.SalesPersonID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	WHERE ma.Active = 1
','MBRs active',4)}
go
{CALL CT_SyncExamples('Listing of all inventory items',0,31,'InvItemID','SELECT ii.InvItemID, ii.InvProductID, ip.Title, ip.EAN, ip.SKU, ip.SupplierSKU, ist.InvStateType, is1.InvState, iw.InvWarehouse, ii.CustomerID, ii.AccountID, ma.GroupID, bii.InvoiceID, ii.ItemID, ii.SerialNumber,
COALESCE(ii.SupplierCost,ip.SupplierCost) AS SupplierCost, COALESCE(ii.Cost,ip.Cost) AS Cost, gl.GLCode, ii.RecvDate, ii.ShipDate, ii.ReturnDate, ii.AssignDate, ii.AssignUser, ii.TrackNumber, ii.Comments, ii.ExternalRef, ii.CreateDate, ii.CreateUser
FROM InvItems ii JOIN InvProducts ip ON (ii.InvProductID = ip.InvProductID)
	JOIN InvStates is1 ON (ii.InvStateID = is1.InvStateID)
	JOIN InvStateTypes ist ON (is1.InvStateTypeID = ist.InvStateTypeID)
	LEFT JOIN MasterAccounts ma ON (ii.CustomerID = ma.CustomerID)
	LEFT JOIN InvWarehouses iw ON (ii.InvWarehouseID = iw.InvWarehouseID)
	LEFT JOIN InvoiceItems bii ON (ii.ItemID = bii.ItemID)
	LEFT JOIN ChargeTypes ct ON (ip.ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
','Inventory items',5)}
go
{CALL CT_SyncExamples('List of incidents assigned to active and inactive MBRs',0,NULL,'IncidentID','SELECT i.IncidentID, i.CustomerID, i.AccountID, a.FirstName, a.LastName, a.Company, g.GroupName,
i.CreateDate, it.IncidentType, is1.IncidentState, e.Event, 
co.Operator AS CreateOperator, COALESCE(csa.Login,cca.FirstName + '' '' + cca.LastName) AS CreateUser,
i.Summary, i.Description, i.LastModifyDate, i.LastModifyUser, 
r.Role AS AssignRole, ao.Operator AS AssignOperator, p.Priority, sb.SchedBlock, i.SchedDate

FROM Incidents i JOIN IncidentTypes it ON (i.IncidentTypeID = it.IncidentTypeID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	JOIN Priorities p ON (i.PriorityID = p.PriorityID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Addresses a ON (ma.BillingAddressID = a.AddressID)
	LEFT JOIN SubAccounts sa ON (i.AccountID = sa.AccountID)
	LEFT JOIN Events e ON (i.EventID = e.EventID)
	LEFT JOIN Operators co ON (i.CreateOperatorID = co.OperatorID)
	LEFT JOIN SubAccounts csa ON (i.CreateAccountID = csa.AccountID)
	LEFT JOIN Addresses cca ON (csa.ContactAddressID = cca.AddressID)
	LEFT JOIN Roles r ON (i.AssignRoleID = r.RoleID)
	LEFT JOIN Operators ao ON (i.AssignOperatorID = ao.OperatorID)
	LEFT JOIN SchedBlocks sb ON (i.SchedBlockID = sb.SchedBlockID)
	WHERE ma.Active IN (1,0)
	AND (sa.Active IS NULL OR sa.Active IN (1,0))','Incidents',6)}
go
{CALL CT_SyncExamples('List of all active services',0,NULL,'AccountID','SELECT AccountID,CustomerID,GroupID,ContactFirstName,ContactLastName,ContactCompany,ContactAddress1,ContactAddress2,ContactCity,ContactState,ContactStateAbbr,ContactZip,ContactCountry,ContactEmail,ContactPhoneHome,ContactPhoneWork,ContactPhoneMobile,ServiceFirstName,ServiceLastName,ServiceCompany,ServiceAddress1,ServiceAddress2,ServiceCity,ServiceState,ServiceStateAbbr,ServiceZip,ServiceCountry,ServiceEmail,ServicePhoneHome,ServicePhoneWork,ServicePhoneMobile,ServiceLat,ServiceLong,Login,Email,ParentAccountID,ServiceCategory,AccountType,PayPeriod,CreateDate,CreateUser,CancelDate,CancelReason,StartDate,BilledThru,ExpireDate,Extension,Active,Expired,Status,SalesPerson,LastModifyDate,LastModifyUser,RemoteAccess,Recurring,LoginLimit,Domain,Tower,TimeLeft,DataLeft,RateTimeLeft,RateDataLeft,InvoicedDays,Cost,ServiceQty,Comments
FROM vSubAccounts
	WHERE Active = 1','Services active',7)}
go
{CALL CT_SyncExamples('Similar to Active services template /w fewer columns, expired accounts are excluded and service Password field included',1,NULL,'AccountID','SELECT ma.CustomerID, sa.AccountID, a.FirstName, a.LastName, a.Company, at1.AccountType, sa.Login, sa.Password
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN Addresses a ON (sa.ContactAddressID = a.AddressID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.ExpireDate IS NULL AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())) OR DATEADD(dd,CASE WHEN bc.AutoBill=2 OR sa.Recurring=0 THEN 0 ELSE 1 + CASE WHEN ma.CancelDate <= sa.ExpireDate OR sa.CancelDate <= sa.ExpireDate THEN 0 ELSE ma.TempExtension + sa.Extension END END,sa.ExpireDate) >= getdate())
	AND sa.Login IS NOT NULL
','Services active unexpired',8)}
go
{CALL CT_SyncExamples('Listing of all address data',0,NULL,'AddressID','SELECT a.AddressID, a.CustomerID, a.AccountID, a.CreateDate, at1.AddressType,
a.FirstName, a.LastName, a.Company, 
a.Address1, a.Address2, a.City, s.State, s.Abbreviation AS StateAbbr, a.Zip, 
s.NationalRegion AS NationalRegion, c.Country, c.Abbr2 AS CountryAbbr2, c.Abbr3 AS CountryAbbr3,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Lat ELSE as1.Lat END AS Lat,
CASE WHEN a.Lat IS NOT NULL AND a.Long IS NOT NULL THEN a.Long ELSE as1.Long END AS Long,
CASE WHEN a.Lat IS NULL AND a.Long IS NULL AND as1.Lat IS NOT NULL AND as1.Long IS NOT NULL THEN 1 ELSE 0 END AS Geocoded,
a.PhoneHome, a.PhoneWork, a.PhoneFax, a.PhoneMobile, a.Email, a.WWW, a.Comments
FROM Addresses a JOIN AddressTypes at1 ON (a.AddressTypeID = at1.AddressTypeID)
	LEFT JOIN Countries c ON (a.CountryID = c.CountryID)
	LEFT JOIN States s ON (a.CountryID = s.CountryID AND a.StateID = s.StateID)
	LEFT JOIN AddressSyncs as1 ON (a.AddressID = as1.AddressID)
','Address / Contact data',9)}
go
{CALL CT_EmailTypes('HTML',1,0,NULL)}
go
{CALL CT_EmailTypes('PDF',2,0,NULL)}
go
{CALL CT_EmailTypes('RTF',4,-1,NULL)}
go
{CALL CT_EmailTypes('MS Word',8,-1,NULL)}
go
{CALL CT_EmailTypes('Text',16,-1,NULL)}
go
{CALL CT_FlowDirections('Flow relative',1,200)}
go
{CALL CT_FlowDirections('Service relative',2,100)}
go
{CALL CT_PrintTypes(NULL,'text/html','HTML',1)}
go
{CALL CT_PrintTypes('cmd=EXPORT&EXPORT_FMT=U2FPDF%3A0','application/pdf','PDF',2)}
go
{CALL CT_PrintTypes(NULL,'application/rtf','RTF',4)}
go
{CALL CT_PrintTypes(NULL,'application/msword','MS Word',8)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'Modus Mail',-5,0,0,0,0,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'MailSite',-4,0,0,0,1,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'Merak Mail',-3,0,0,0,0,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'Imail',-2,0,0,0,0,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'External (EmerAuth..etc)',0,0,0,0,1,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'Export (File, XML, HTTP..etc)',10,1,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'LDAP - Communigate',100,0,0,0,1,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'LDAP - Netscape/Sun Msg Server',101,0,0,0,1,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'LDAP - Qmail',102,0,0,0,1,0,0)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'LDAP - MDaemon',103,0,0,0,1,0,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'LDAP - General',104,0,0,0,0,0,0)}
go
{CALL CT_ExternalSystemTypes('Offer ID','Default ClientID',NULL,1010,'Everyone.Net (Email Service)',200,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,1014,'SmarterMail (Email)',201,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('COS ID',NULL,NULL,1021,'Zimbra Mail',202,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,1019,'Google Apps (Mail)',203,0,0,1,0,1,0)}
go
{CALL CT_ExternalSystemTypes('Account Name','Account Role ID',NULL,1011,'Helm 4 (Control Panel)',250,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,1012,'CPanel (Control Panel)',251,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,1013,'DirectAdmin (Control Panel)',252,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('Email OptionID (1054)','Set Host Records (1/0)','Contact Address Type',1015,'eNom Domains',300,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('Feature Set ID',NULL,NULL,1017,'Diino Backup Service',400,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('Sandbox (EFSDEV)','Usage Interval (Mins)',NULL,1018,'eFolder Backup Service',401,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes(NULL,NULL,NULL,NULL,'IIS Web Provisioning (emersetup.asp)',1000,1,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('API Ref',NULL,NULL,1016,'Generic Web Service',1001,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemTypes('API Ref',NULL,NULL,1022,'Detailed Account Sync',1002,0,0,1,0,1,1)}
go
{CALL CT_ExternalSystemDataTypes(3,-3,NULL,10)}
go
{CALL CT_ExternalSystemDataTypes(3,-2,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(3,101,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(3,102,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(23,250,0,1)}
go
{CALL CT_ExternalSystemDataTypes(24,251,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(24,252,NULL,2)}
go
{CALL CT_ExternalSystemDataTypes(25,252,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(2,1000,0,6)}
go
{CALL CT_ExternalSystemDataTypes(8,1000,NULL,1)}
go
{CALL CT_ExternalSystemDataTypes(10,1000,NULL,2)}
go
{CALL CT_ExternalSystemDataTypes(1000,1000,NULL,3)}
go
{CALL CT_ExternalSystemDataTypes(1001,1000,NULL,4)}
go
{CALL CT2_Currencies(1,'AFN',4,'afghani',1,0,'Af')}
go
{CALL CT2_Currencies(1,'ALL',8,'lek',2,0,'L')}
go
{CALL CT2_Currencies(1,'DZD',12,'dinar',3,0,'DA')}
go
{CALL CT2_Currencies(1,'AOA',24,'kwanza',4,0,'Kz')}
go
{CALL CT2_Currencies(1,'ARA',32,'austral',7,0,'A')}
go
{CALL CT2_Currencies(1,'ARS',32,'peso',8,0,'$')}
go
{CALL CT2_Currencies(1,'AMD',51,'dram',9,0,NULL)}
go
{CALL CT2_Currencies(1,'AWG',533,'guilder',10,0,'Afl.')}
go
{CALL CT2_Currencies(1,'AUD',36,'dollar',11,0,'A$')}
go
{CALL CT2_Currencies(1,'AZM',31,'manat',13,0,NULL)}
go
{CALL CT2_Currencies(1,'BSD',44,'dollar',14,0,'B$')}
go
{CALL CT2_Currencies(1,'BHD',48,'dinar',15,0,'BD')}
go
{CALL CT2_Currencies(1,'BDT',50,'taka',16,0,'Tk')}
go
{CALL CT2_Currencies(1,'BBD',52,'dollar',17,0,'Bds$')}
go
{CALL CT2_Currencies(1,'BYR',112,'ruble',18,0,'BR')}
go
{CALL CT2_Currencies(1,'BZD',84,'dollar',20,0,'BZ$')}
go
{CALL CT2_Currencies(1,'BMD',60,'dollar',22,0,'Bd$')}
go
{CALL CT2_Currencies(1,'BTN',64,'ngultrum',23,0,'Nu')}
go
{CALL CT2_Currencies(1,'BOB',68,'boliviano',24,0,'Bs')}
go
{CALL CT2_Currencies(1,'BAM',70,'convertible mark',25,0,'KM')}
go
{CALL CT2_Currencies(1,'BWP',72,'pula',26,0,'P')}
go
{CALL CT2_Currencies(1,'BRL',76,'real',27,0,'R$')}
go
{CALL CT2_Currencies(1,'BND',96,'ringgit',28,0,'B$')}
go
{CALL CT2_Currencies(1,'BGN',100,'new lev',29,0,'Lv')}
go
{CALL CT2_Currencies(1,'BIF',108,'franc',31,0,'FBu')}
go
{CALL CT2_Currencies(1,'KHR',116,'new riel',32,0,'CR')}
go
{CALL CT2_Currencies(1,'XAF',NULL,'franc',33,0,'CFAF')}
go
{CALL CT2_Currencies(1,'CAD',124,'dollar',34,0,'Can$')}
go
{CALL CT2_Currencies(1,'CVE',132,'escudo',35,0,'C.V.Esc.')}
go
{CALL CT2_Currencies(1,'KYD',136,'dollar',36,0,'CI$')}
go
{CALL CT2_Currencies(1,'CLP',152,'peso',39,0,'Ch$')}
go
{CALL CT2_Currencies(1,'CNY',156,'yuan renminbi',40,0,'Y')}
go
{CALL CT2_Currencies(1,'COP',170,'peso',41,0,'Col$')}
go
{CALL CT2_Currencies(1,'KMF',174,'franc',42,0,'CF')}
go
{CALL CT2_Currencies(1,'CDF',178,'franc',44,0,NULL)}
go
{CALL CT2_Currencies(1,'CRC',188,'colon',46,0,'C')}
go
{CALL CT2_Currencies(1,'HRK',191,'kuna',48,0,'HRK')}
go
{CALL CT2_Currencies(1,'CUC',NULL,'convertible peso',49,0,'Cuc$')}
go
{CALL CT2_Currencies(1,'CUP',192,'peso',50,0,'Cu$')}
go
{CALL CT2_Currencies(1,'CYP',196,'pound',51,0,'C')}
go
{CALL CT2_Currencies(1,'CZK',203,'koruna',52,0,'Kc')}
go
{CALL CT2_Currencies(1,'DKK',208,'krone',53,0,'Dkr')}
go
{CALL CT2_Currencies(1,'DJF',262,'franc',54,0,'DF')}
go
{CALL CT2_Currencies(1,'DOP',214,'peso',56,0,'RD$')}
go
{CALL CT2_Currencies(1,'ECS',218,'sucre',57,0,'S/')}
go
{CALL CT2_Currencies(1,'EGP',818,'pound',58,0,'E')}
go
{CALL CT2_Currencies(1,'SVC',222,'colon',59,0,'')}
go
{CALL CT2_Currencies(1,'GQE',226,'franc',60,0,'CFAF')}
go
{CALL CT2_Currencies(1,'ERN',232,'nakfa',61,0,'Nfa')}
go
{CALL CT2_Currencies(1,'EEK',233,'kroon',62,0,'KR')}
go
{CALL CT2_Currencies(1,'ETB',231,'birr',63,0,'Br')}
go
{CALL CT2_Currencies(1,'XEU',NULL,'European Currency Unit',64,0,'ecu')}
go
{CALL CT2_Currencies(1,'EUR',978,'euro',65,0,'EUR')}
go
{CALL CT2_Currencies(1,'FKP',238,'pound',66,0,'FKP')}
go
{CALL CT2_Currencies(1,'FJD',242,'dollar',67,0,'F$')}
go
{CALL CT2_Currencies(1,'GMD',270,'dalasi',72,0,'D')}
go
{CALL CT2_Currencies(1,'GEL',268,'lari',73,0,NULL)}
go
{CALL CT2_Currencies(1,'GHC',288,'new cedi',75,0,'GHC')}
go
{CALL CT2_Currencies(1,'GIP',292,'pound',76,0,'GIP')}
go
{CALL CT2_Currencies(1,'GTQ',320,'quetzal',79,0,'Q')}
go
{CALL CT2_Currencies(1,'GWP',624,'peso',80,0,'PG')}
go
{CALL CT2_Currencies(1,'XOF',NULL,'franc',81,0,'CFAF')}
go
{CALL CT2_Currencies(1,'GNS',324,'syli',82,0,'FG')}
go
{CALL CT2_Currencies(1,'GNF',324,'franc',83,0,NULL)}
go
{CALL CT2_Currencies(1,'GYD',328,'dollar',84,0,'G$')}
go
{CALL CT2_Currencies(1,'HTG',332,'gourde',85,0,'G')}
go
{CALL CT2_Currencies(1,'HNL',340,'lempira',86,0,'L')}
go
{CALL CT2_Currencies(1,'HKD',344,'dollar',87,0,'HK$')}
go
{CALL CT2_Currencies(1,'HUF',348,'forint',88,0,'Ft')}
go
{CALL CT2_Currencies(1,'ISK',352,'krna',89,0,'IKr')}
go
{CALL CT2_Currencies(1,'INR',356,'rupee',90,0,'Rs')}
go
{CALL CT2_Currencies(1,'IDR',360,'rupiah',91,0,'Rp')}
go
{CALL CT2_Currencies(1,'XDR',NULL,'Special Drawing Right',92,0,'SDR')}
go
{CALL CT2_Currencies(1,'IRR',364,'rial',93,0,'Rls')}
go
{CALL CT2_Currencies(1,'IQD',368,'dinar',94,0,'ID')}
go
{CALL CT2_Currencies(1,'ILS',376,'new shekel',97,0,'NIS')}
go
{CALL CT2_Currencies(1,'ITL',380,'lira',98,0,'Lit')}
go
{CALL CT2_Currencies(1,'JMD',388,'dollar',100,0,'J$')}
go
{CALL CT2_Currencies(1,'JPY',392,'yen',101,0,'')}
go
{CALL CT2_Currencies(1,'JOD',400,'dinar',102,0,'JD')}
go
{CALL CT2_Currencies(1,'KZT',398,'tenge',103,0,NULL)}
go
{CALL CT2_Currencies(1,'KES',404,'shilling',104,0,'K Sh')}
go
{CALL CT2_Currencies(1,'KPW',408,'won',105,0,'Wn')}
go
{CALL CT2_Currencies(1,'KRW',410,'won',106,0,'W')}
go
{CALL CT2_Currencies(1,'KWD',414,'dinar',107,0,'KD')}
go
{CALL CT2_Currencies(1,'KGS',417,'som',108,0,NULL)}
go
{CALL CT2_Currencies(1,'LAK',418,'new kip',109,0,'KN')}
go
{CALL CT2_Currencies(1,'LVL',428,'lat',110,0,'Ls')}
go
{CALL CT2_Currencies(1,'LBP',422,'pound',111,0,'L.L.')}
go
{CALL CT2_Currencies(1,'LSL',426,'loti',112,0,'L')}
go
{CALL CT2_Currencies(1,'LRD',430,'dollar',113,0,'$')}
go
{CALL CT2_Currencies(1,'LYD',434,'dinar',114,0,'LD')}
go
{CALL CT2_Currencies(1,'LTL',440,'litas',115,0,NULL)}
go
{CALL CT2_Currencies(1,'LUF',442,'franc',116,0,'LuxF')}
go
{CALL CT2_Currencies(1,'MOP',446,'pataca',118,0,'P')}
go
{CALL CT2_Currencies(1,'MKD',807,'denar',119,0,'MKD')}
go
{CALL CT2_Currencies(1,'MGF',450,'franc',120,0,'FMG')}
go
{CALL CT2_Currencies(1,'MGA',NULL,'ariayry',121,0,'MGA')}
go
{CALL CT2_Currencies(1,'MWK',454,'kwacha',122,0,'MK')}
go
{CALL CT2_Currencies(1,'MYR',458,'ringgit',123,0,'RM')}
go
{CALL CT2_Currencies(1,'MVR',462,'rufiyaa',124,0,'Rf')}
go
{CALL CT2_Currencies(1,'MTL',470,'lira',126,0,'Lm')}
go
{CALL CT2_Currencies(1,'MRO',478,'ouguiya',127,0,'UM')}
go
{CALL CT2_Currencies(1,'MUR',480,'rupee',128,0,'Mau Rs')}
go
{CALL CT2_Currencies(1,'MXN',484,'peso',129,0,'Mex$')}
go
{CALL CT2_Currencies(1,'MDL',498,'leu',130,0,NULL)}
go
{CALL CT2_Currencies(1,'MNT',496,'tugrik',131,0,'Tug')}
go
{CALL CT2_Currencies(1,'MAD',504,'dirham',133,0,'DH')}
go
{CALL CT2_Currencies(1,'MZM',508,'metical',134,0,'Mt')}
go
{CALL CT2_Currencies(1,'MMK',104,'kyat',135,0,'K')}
go
{CALL CT2_Currencies(1,'NAD',516,'dollar',136,0,'N$')}
go
{CALL CT2_Currencies(1,'NPR',524,'rupee',137,0,'NRs')}
go
{CALL CT2_Currencies(1,'ANG',4,'guilder',138,0,'NAf.')}
go
{CALL CT2_Currencies(1,'NLG',528,'guilder',139,0,'f.')}
go
{CALL CT2_Currencies(1,'NZD',554,'dollar',142,0,'NZ$')}
go
{CALL CT2_Currencies(1,'NIO',558,'gold cordoba',143,0,'C$')}
go
{CALL CT2_Currencies(1,'NGN',566,'naira',145,0,'N')}
go
{CALL CT2_Currencies(1,'NOK',578,'krone',146,0,'NKr')}
go
{CALL CT2_Currencies(1,'OMR',512,'rial',147,0,'RO')}
go
{CALL CT2_Currencies(1,'PKR',586,'rupee',148,0,'Rs')}
go
{CALL CT2_Currencies(1,'PAB',591,'balboa',149,0,'B')}
go
{CALL CT2_Currencies(1,'PGK',598,'kina',150,0,'K')}
go
{CALL CT2_Currencies(1,'PYG',600,'guarani',151,0,'G')}
go
{CALL CT2_Currencies(1,'PEI',NULL,'inti',152,0,NULL)}
go
{CALL CT2_Currencies(1,'PEN',604,'new sol',153,0,'S/.')}
go
{CALL CT2_Currencies(1,'PHP',608,'peso',154,0,'dashed P')}
go
{CALL CT2_Currencies(1,'PLN',NULL,'zloty',155,0,'zl')}
go
{CALL CT2_Currencies(1,'PTE',620,'escudo',156,0,'Esc')}
go
{CALL CT2_Currencies(1,'QAR',634,'riyal',158,0,'QR')}
go
{CALL CT2_Currencies(1,'ROL',642,'leu',159,0,'L')}
go
{CALL CT2_Currencies(1,'RON',642,'leu',160,0,'L')}
go
{CALL CT2_Currencies(1,'RUR',NULL,'ruble',161,0,'R')}
go
{CALL CT2_Currencies(1,'RUB',643,'ruble',162,0,'R')}
go
{CALL CT2_Currencies(1,'RWF',646,'franc',163,0,'RF')}
go
{CALL CT2_Currencies(1,'STD',678,'dobra',164,0,'Db')}
go
{CALL CT2_Currencies(1,'SAR',682,'riyal',165,0,'SRls')}
go
{CALL CT2_Currencies(1,'CSD',891,'dinar',167,0,'Din')}
go
{CALL CT2_Currencies(1,'SCR',690,'rupee',168,0,'SR')}
go
{CALL CT2_Currencies(1,'SLL',694,'leone',169,0,'Le')}
go
{CALL CT2_Currencies(1,'SGD',702,'dollar',170,0,'S$')}
go
{CALL CT2_Currencies(1,'SKK',703,'koruna',171,0,'Sk')}
go
{CALL CT2_Currencies(1,'SIT',705,'tolar',172,0,'SlT')}
go
{CALL CT2_Currencies(1,'SBD',90,'dollar',173,0,'SI$')}
go
{CALL CT2_Currencies(1,'SOS',706,'shilling',174,0,'So. Sh.')}
go
{CALL CT2_Currencies(1,'ZAR',710,'rand',175,0,'R')}
go
{CALL CT2_Currencies(1,'ESP',724,'peseta',176,0,'Ptas')}
go
{CALL CT2_Currencies(1,'LKR',144,'rupee',178,0,'SLRs')}
go
{CALL CT2_Currencies(1,'SHP',654,'pound',179,0,'S')}
go
{CALL CT2_Currencies(1,'XCD',NULL,'dollar',182,0,'EC$')}
go
{CALL CT2_Currencies(1,'SDP',736,'pound',183,0,NULL)}
go
{CALL CT2_Currencies(1,'SDP',736,'dinar',184,0,NULL)}
go
{CALL CT2_Currencies(1,'SRD',740,'Dollar',185,0,'$Sur')}
go
{CALL CT2_Currencies(1,'SZL',748,'lilangeni',186,0,'L')}
go
{CALL CT2_Currencies(1,'SEK',752,'krona',187,0,'kr')}
go
{CALL CT2_Currencies(1,'CHF',756,'franc',188,0,'SwF')}
go
{CALL CT2_Currencies(1,'SYP',760,'pound',189,0,'S')}
go
{CALL CT2_Currencies(1,'TWD',NULL,'new dollar',190,0,'NT$')}
go
{CALL CT2_Currencies(1,'TJR',762,'ruble',191,0,NULL)}
go
{CALL CT2_Currencies(1,'TJS',762,'somoni',192,0,'dirams')}
go
{CALL CT2_Currencies(1,'TZS',834,'shilling',193,0,'TSh')}
go
{CALL CT2_Currencies(1,'THB',764,'baht',194,0,'Bt')}
go
{CALL CT2_Currencies(1,'TOP',776,'pa''anga',196,0,'T$')}
go
{CALL CT2_Currencies(1,'TTD',780,'dollar',197,0,'TT$')}
go
{CALL CT2_Currencies(1,'TND',788,'dinar',198,0,'TD')}
go
{CALL CT2_Currencies(1,'TRY',792,'lira',199,0,'YTL')}
go
{CALL CT2_Currencies(1,'TRL',792,'lira',200,0,'TL')}
go
{CALL CT2_Currencies(1,'TMM',795,'manat',201,0,NULL)}
go
{CALL CT2_Currencies(1,'UGS',NULL,'shilling',202,0,'USh')}
go
{CALL CT2_Currencies(1,'UGX',800,'shilling',203,0,'USh')}
go
{CALL CT2_Currencies(1,'UAH',NULL,'Hryvnia',204,0,NULL)}
go
{CALL CT2_Currencies(1,'AED',784,'dirham',205,0,'Dh')}
go
{CALL CT2_Currencies(1,'GBP',826,'pound',206,0,'GBP')}
go
{CALL CT2_Currencies(1,'USD',840,'dollar',207,0,'$')}
go
{CALL CT2_Currencies(1,'UYP',NULL,'peso',208,0,'Ur$')}
go
{CALL CT2_Currencies(1,'UYN',NULL,'new peso',209,0,'NUr$')}
go
{CALL CT2_Currencies(1,'UYU',858,'peso uruguayo',210,0,'$U')}
go
{CALL CT2_Currencies(1,'UZS',860,'som',211,0,NULL)}
go
{CALL CT2_Currencies(1,'VUV',548,'vatu',212,0,'VT')}
go
{CALL CT2_Currencies(1,'VEB',862,'bolivar',213,0,'Bs')}
go
{CALL CT2_Currencies(1,'VND',704,'dong',214,0,'d')}
go
{CALL CT2_Currencies(1,'XPF',NULL,'franc',215,0,'CFPF')}
go
{CALL CT2_Currencies(1,'WST',882,'tala',216,0,'WS$')}
go
{CALL CT2_Currencies(1,'YER',NULL,'rial',217,0,'YRls')}
go
{CALL CT2_Currencies(1,'ZRN',NULL,'new zaire',218,0,'NZ')}
go
{CALL CT2_Currencies(1,'ZMK',894,'kwacha',219,0,'ZK')}
go
{CALL CT2_Currencies(1,'ZWD',716,'dollar',220,0,'Z$')}
go
{CALL CT_Languages(1,1,'English','en',1,0)}
go
{CALL CT_Languages(1,1,'Spanish','es',3,1)}
go
{CALL CT_Languages(1,1,'French','fr',4,2)}
go
{CALL CT_Languages(1,1,'German','de',5,3)}
go
{CALL CT_Languages(1,1,'Portuguese','pt',6,6)}
go
{CALL CT_Languages(1,1,'Japanese','ja',7,7)}
go
{CALL CT_Languages(1,1,'Chinese - Simplified','zh',8,8)}
go
{CALL CT_Languages(1,1,'Korean','ko',9,9)}
go
{CALL CT_Languages(1,1,'Arabic','ar',10,10)}
go
{CALL CT_LogMsgs('Generic Message',0,0,NULL)}
go
{CALL CT_LogMsgs('Generic Error',1,5,NULL)}
go
{CALL CT_LogMsgs('File Error',2,5,NULL)}
go
{CALL CT_LogMsgs('SQL Generic',10,5,NULL)}
go
{CALL CT_LogMsgs('SQL Error',11,5,NULL)}
go
{CALL CT_LogMsgs('Report Generic',20,5,NULL)}
go
{CALL CT_LogMsgs('Report Error',21,5,NULL)}
go
{CALL CT_LogMsgs('Batch Generic',50,1,NULL)}
go
{CALL CT_LogMsgs('Batch Invoice',51,1,NULL)}
go
{CALL CT_LogMsgs('Batch Statements',52,1,NULL)}
go
{CALL CT_LogMsgs('Batch Summary',53,1,NULL)}
go
{CALL CT_LogMsgs('Batch Charges',54,1,NULL)}
go
{CALL CT_LogMsgs('Batch Export',55,1,NULL)}
go
{CALL CT_LogMsgs('Batch Import',56,1,NULL)}
go
{CALL CT_LogMsgs('Batch Print',57,1,NULL)}
go
{CALL CT_LogMsgs('Batch Email',58,1,NULL)}
go
{CALL CT_LogMsgs('MBR Generic',100,1,NULL)}
go
{CALL CT_LogMsgs('MBR Add',101,1,NULL)}
go
{CALL CT_LogMsgs('MBR Edit',102,2,NULL)}
go
{CALL CT_LogMsgs('MBR Delete',103,3,NULL)}
go
{CALL CT_LogMsgs('MBR Payment',104,1,NULL)}
go
{CALL CT_LogMsgs('MBR Credit',105,1,NULL)}
go
{CALL CT_LogMsgs('MBR Invoice Add',106,1,NULL)}
go
{CALL CT_LogMsgs('MBR Invoice Void',107,3,NULL)}
go
{CALL CT_LogMsgs('MBR Custom',108,1,NULL)}
go
{CALL CT_LogMsgs('MBR Cancel',110,1,NULL)}
go
{CALL CT_LogMsgs('MBR Inactivate',111,1,NULL)}
go
{CALL CT_LogMsgs('MBR ReActivate',112,1,NULL)}
go
{CALL CT_LogMsgs('Service Generic',200,1,NULL)}
go
{CALL CT_LogMsgs('Service Add',201,1,NULL)}
go
{CALL CT_LogMsgs('Service Edit',202,2,NULL)}
go
{CALL CT_LogMsgs('Service Delete',203,3,NULL)}
go
{CALL CT_LogMsgs('Service Incident',204,1,NULL)}
go
{CALL CT_LogMsgs('Service Action',205,1,NULL)}
go
{CALL CT_LogMsgs('Service Alias',206,1,NULL)}
go
{CALL CT_LogMsgs('Service Forward',207,1,NULL)}
go
{CALL CT_LogMsgs('Service RADIUS',208,1,NULL)}
go
{CALL CT_LogMsgs('Service Custom',209,1,NULL)}
go
{CALL CT_LogMsgs('Service Cancel',210,1,NULL)}
go
{CALL CT_LogMsgs('Login Failure',300,0,NULL)}
go
{CALL CT_LogMsgs('Access Denied',301,0,NULL)}
go
{CALL CT_LogMsgs('Product Update',302,0,NULL)}
go
{CALL CT_LogMsgs('Remove Tag',303,1,NULL)}
go
{CALL CT_LogMsgs('Login',304,0,NULL)}
go
{CALL CT_LogMsgs('Logout',305,0,NULL)}
go
{CALL CT_LogMsgs('Incoming SMS',400,0,NULL)}
go
{CALL CT_LogMsgs('Mail Generic',1000,1,NULL)}
go
{CALL CT_LogMsgs('Mail Invoice',1001,1,NULL)}
go
{CALL CT_LogMsgs('Mail Statement',1002,1,NULL)}
go
{CALL CT_LogMsgs('Mail Receipt',1003,1,NULL)}
go
{CALL CT_LogMsgs('Mail Notice',1004,1,NULL)}
go
{CALL CT_MenuItems(NULL,'1',NULL,NULL,NULL,11394,'Home',NULL,NULL,NULL,'home',NULL,'/','Home',1,NULL,NULL)}
go
{CALL CT_MenuItems('read','2',NULL,'AccountID',NULL,11395,'Accounts',NULL,'accounts.ews',NULL,'acctsrch',NULL,'accounts.ews','Accounts',2,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('read','I',NULL,NULL,NULL,10548,'Invoice Search',8,'search_invoice.ews',NULL,'invoices',NULL,'search_invoice.ews','Invoices Search',3,NULL,NULL)}
go
{CALL CT_MenuItems('read','I',NULL,NULL,NULL,10497,'Incidents',NULL,'incidents_search.ews',NULL,'incidents',NULL,'incidents_search.ews?ShowOption=1&Assign=-1','incidents',4,NULL,NULL)}
go
{CALL CT_MenuItems('read','T',NULL,NULL,NULL,11421,'Statement Search',8,'search_statement.ews',NULL,'statements',NULL,'search_statement.ews','Statement Search',5,NULL,NULL)}
go
{CALL CT_MenuItems('read','5',NULL,NULL,NULL,11396,'Reports',NULL,'reports.ews',NULL,'reports',NULL,'reports.ews','Reports',7,NULL,NULL)}
go
{CALL CT_MenuItems('add','N',NULL,NULL,NULL,11422,'New MBR',NULL,'mbr_add.ews',NULL,'newmbr',NULL,'mbr_add.ews','New MBR',8,NULL,'MasterAccounts')}
go
{CALL CT_MenuItems('read','S',NULL,NULL,NULL,11423,'Simple Search',NULL,'search_simple.ews',NULL,'accounts',NULL,'search_simple.ews','Simple Search',9,NULL,NULL)}
go
{CALL CT_MenuItems('read','M',NULL,NULL,NULL,11424,'MBR Search',NULL,'search_mbr.ews',NULL,'mbrsrch',NULL,'search_mbr.ews','MBR Search',10,NULL,NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,11425,'Service Search',NULL,'search_sa.ews',NULL,'sasrch',NULL,'search_sa.ews','Service Search',11,NULL,NULL)}
go
{CALL CT_MenuItems('read','V',NULL,NULL,NULL,11426,'Advanced Search',NULL,'search_advanced.ews',NULL,'advsrch',NULL,'search_advanced.ews','Advanced Search',12,NULL,NULL)}
go
{CALL CT_MenuItems('read','C',NULL,NULL,NULL,11427,'Custom Search',NULL,'search_searches.ews',NULL,'custsrch',NULL,'search_searches.ews','Custom Search',13,NULL,NULL)}
go
{CALL CT_MenuItems('read','H',NULL,NULL,NULL,11400,'Show MBR',NULL,'mbr_detail.ews',NULL,'showmbr',NULL,'mbr_detail.ews?CustomerID=$Variables.CustomerID&ShowAll=1','Show MBR',14,'ma_mnu_ShowMBR','MasterAccounts')}
go
{CALL CT_MenuItems('modify','E',NULL,NULL,NULL,11401,'Edit MBR',NULL,'mbr_edit.ews',NULL,'editmbr',NULL,'mbr_edit.ews?CustomerID=$Variables.CustomerID','Edit MBR',15,'ma_mnu_EditMBR','MasterAccounts')}
go
{CALL CT_MenuItems('add','N',NULL,NULL,NULL,11402,'New Service',NULL,'sa_add.ews',NULL,'newsa',NULL,'sa_add.ews?CustomerID=$Variables.CustomerID','New Service',16,'ma_mnu_NewService','SubAccounts')}
go
{CALL CT_MenuItems('add','I',NULL,NULL,NULL,10468,'New Incident',NULL,'incident_edit.ews',NULL,'newincident',NULL,'incident_edit.ews?CustomerID=$Variables.CustomerID','New Incident',17,'ma_mnu_NewIncident','Incidents')}
go
{CALL CT_MenuItems('read','D',NULL,NULL,NULL,10497,'Incidents',NULL,'mbr_incidents.ews',NULL,'mbrincidents',NULL,'mbr_incidents.ews?CustomerID=$Variables.CustomerID&AccountID=$Variables.AccountID#ltop','Incidents',18,'ma_mnu_Incidents','Incidents')}
go
{CALL CT_MenuItems('add','P',NULL,NULL,NULL,10165,'Make Payment',8,'mbr_payment_add.ews',NULL,'mbrpayment',NULL,'mbr_payment_add.ews?src=mbr&CustomerID=$Variables.CustomerID','Make Payment',20,'ma_mnu_MakePayment','Payments')}
go
{CALL CT_MenuItems('add','A',NULL,NULL,NULL,11403,'Adjustment',8,'mbr_adjustment_edit.ews',NULL,'mbradjustment',NULL,'mbr_adjustment_edit.ews?CustomerID=$Variables.CustomerID#etop','Adjustment',21,'ma_mnu_Adjustments','Charges')}
go
{CALL CT_MenuItems('add','O',NULL,NULL,NULL,11404,'Point Of Sale',8,'mbr_pos_add.ews',NULL,'newpos',NULL,'mbr_pos_add.ews?CustomerID=$Variables.CustomerID','Point Of Sale',22,'ma_mnu_POS','Invoices')}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,11405,'Addresses',NULL,'mbr_addr.ews',NULL,'mbraddress',NULL,'mbr_addr.ews?CustomerID=$Variables.CustomerID#ltop','Addresses',24,'ma_mnu_Addresses','Addresses')}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,10052,'Aging Report',8,'mbr_aging.ews',NULL,'mbraging',NULL,'mbr_aging.ews?CustomerID=$Variables.CustomerID#ltop','Aging Report',25,NULL,NULL)}
go
{CALL CT_MenuItems('read','S',NULL,NULL,NULL,11406,'Statements',8,'mbr_statements.ews',NULL,'mbrstatements',NULL,'mbr_statements.ews?CustomerID=$Variables.CustomerID#ltop','Statements',26,'ma_mnu_Statements',NULL)}
go
{CALL CT_MenuItems('read','V',NULL,NULL,NULL,11407,'Invoices',8,'mbr_invoices.ews',NULL,'mbrinvoices',NULL,'mbr_invoices.ews?CustomerID=$Variables.CustomerID#ltop','Invoices',27,'ma_mnu_Invoices',NULL)}
go
{CALL CT_MenuItems('read','H',NULL,NULL,NULL,11408,'History',NULL,'mbr_history.ews',NULL,'mbrhistory',NULL,'mbr_history.ews?CustomerID=$Variables.CustomerID&HistoryType=7','History',28,NULL,NULL)}
go
{CALL CT_MenuItems('modify','O',NULL,'Active','$GroupID.AllowOpen == 1',11409,'Open MBR',8,'mbr_open.ews',NULL,'mbropen',NULL,'mbr_open.ews?CustomerID=$Variables.CustomerID','Open MBR',29,NULL,'MasterAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active','$GroupID.AllowClose == 1',11410,'Close MBR',8,'mbr_close.ews',NULL,'mbrclose',NULL,'mbr_close.ews?CustomerID=$Variables.CustomerID&preview=1#etop','Close MBR',30,NULL,'MasterAccounts')}
go
{CALL CT_MenuItems('delete',NULL,NULL,NULL,NULL,11411,'Delete MBR',NULL,'mbr_delete.ews',NULL,'mbrdelete',NULL,'javascript:ask(''This will delete the Master Account.  It is NOT reversible. Are you positive?'',''mbr_delete.ews?CustomerID=$Variables.CustomerID'');','Delete MBR',31,'ma_mnu_DeleteMBR','MasterAccounts')}
go
{CALL CT_MenuItems('read','H',NULL,NULL,NULL,11400,'Show MBR',NULL,'mbr_detail.ews',NULL,'sashowmbr',NULL,'mbr_detail.ews?CustomerID=$FindCustomerID.CustomerID','Show MBR',32,'sa_mnu_ShowMBR','MasterAccounts')}
go
{CALL CT_MenuItems('read','S',NULL,NULL,NULL,11413,'Show Service',NULL,'sa_detail.ews',NULL,'showservice',NULL,'sa_detail.ews?AccountID=$Variables.AccountID','Show Service',33,'sa_mnu_ShowService','SubAccounts')}
go
{CALL CT_MenuItems('add','N',NULL,NULL,NULL,11402,'New Service',NULL,'sa_add.ews',NULL,'newservice',NULL,'sa_add.ews?CustomerID=$FindCustomerID.CustomerID','New Service',34,'sa_mnu_NewService','SubAccounts')}
go
{CALL CT_MenuItems('modify','E',NULL,NULL,NULL,11414,'Edit Service',NULL,'sa_edit.ews',NULL,'editservice',NULL,'sa_edit.ews?AccountID=$Variables.AccountID','Edit Service',35,'sa_mnu_EditService','SubAccounts')}
go
{CALL CT_MenuItems('delete',NULL,NULL,NULL,NULL,11415,'Delete Service',NULL,'sa_delete.ews',NULL,'sadelete',NULL,'sa_delete.ews?AccountID=$Variables.AccountID#etop','Delete Service',36,'sa_mnu_DeleteService','SubAccounts')}
go
{CALL CT_MenuItems('read','C',NULL,NULL,NULL,11416,'Usage History',NULL,'sa_timeon.ews',NULL,'satimeon',NULL,'sa_timeon.ews?AccountID=$Variables.AccountID#etop','Usage History',37,NULL,NULL)}
go
{CALL CT_MenuItems('read','D',NULL,NULL,NULL,10497,'Incidents',NULL,'sa_incidents.ews',NULL,'saincidents',NULL,'sa_incidents.ews?AccountID=$Variables.AccountID#ltop','Incidents',39,'sa_mnu_NewIncident','Incidents')}
go
{CALL CT_MenuItems('add','I',NULL,NULL,NULL,10468,'New Incident',NULL,'incident_edit.ews',NULL,'sanewincident',NULL,'incident_edit.ews?CustomerID=$FindCustomerID.CustomerID&iAccountID=$Variables.AccountID&AccountID=$Variables.AccountID','New Incident',40,'sa_mnu_NewIncident','Incidents')}
go
{CALL CT_MenuItems('read','U',NULL,NULL,NULL,11417,'RADIUS',NULL,'sa_radius.ews',NULL,'saradius',NULL,'sa_radius.ews?AccountID=$Variables.AccountID#ltop','RADIUS',41,'sa_mnu_RADIUS','RadConfigs')}
go
{CALL CT_MenuItems('read','E',NULL,NULL,NULL,11418,'Email Settings',NULL,'sa_mail.ews',NULL,'saemail',NULL,'sa_mail.ews?AccountID=$Variables.AccountID#etop','Email Settings',42,'sa_mnu_EmailSettings',NULL)}
go
{CALL CT_MenuItems('modify','O',NULL,'Active','$FindCustomerID.AllowOpen == 1',11419,'Open Service',8,'sa_open.ews',NULL,'saopen',NULL,'sa_open.ews?AccountID=$Variables.AccountID#etop','Open Service',43,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active','$FindCustomerID.AllowClose == 1',11420,'Close Service',8,'sa_close.ews',NULL,'saclose',NULL,'sa_close.ews?AccountID=$Variables.AccountID#etop','Close Service',44,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('add','I',NULL,NULL,'$Variables.InvoiceID ==',11433,'Invoice Current',8,'mbr_invoice_current.ews',NULL,'invcurrent',NULL,'mbr_invoice_current.ews?CustomerID=$Variables.CustomerID#ltop','Invoice Current',45,'mai_mnu_InvoiceCurrent',NULL)}
go
{CALL CT_MenuItems('read','P',NULL,NULL,'$Variables.InvoiceID ==',11434,'Preview Next',8,'mbr_invoice_preview.ews',NULL,'invpreview',NULL,'mbr_invoice_preview.ews?CustomerID=$Variables.CustomerID&forcenext=1#ltop','Preview Next',46,'mai_mnu_PreviewNext',NULL)}
go
{CALL CT_MenuItems('add','N',NULL,NULL,'$Variables.InvoiceID ==',11435,'Invoice Next',8,'mbr_invoice_next.ews',NULL,'invnext',NULL,'mbr_invoice_next.ews?CustomerID=$Variables.CustomerID#ltop','Invoice Next',47,'mai_mnu_InvoiceNext',NULL)}
go
{CALL CT_MenuItems('read','P',NULL,NULL,'$Variables.InvoiceID !=',10164,'Print',8,'print_invoice.ews',NULL,'invprint',NULL,'javascript:newwinrpt(''print_invoice.ews?CustomerID=$Variables.CustomerID&InvoiceID=$Variables.InvoiceID'')','Print',48,'mai_mnu_Print',NULL)}
go
{CALL CT_MenuItems('read','E',NULL,NULL,'$Variables.InvoiceID !=',10188,'Email',8,'email_invoice.ews',NULL,'invemail',NULL,'email_invoice.ews?CustomerID=$Variables.CustomerID&InvoiceID=$Variables.InvoiceID#etop','Email',49,'mai_mnu_Email',NULL)}
go
{CALL CT_MenuItems('add','A',NULL,NULL,'$Variables.InvoiceID !=',10161,'Make Payment',8,'mbr_payment_add.ews',NULL,'invpayment',NULL,'mbr_payment_add.ews?src=invoice&InvoiceID=$Variables.InvoiceID&CustomerID=$Variables.CustomerID#etop','Make Payment',50,'mai_mnu_MakePayment',NULL)}
go
{CALL CT_MenuItems('modify','V',NULL,'InvoiceTypeID','$InvoiceSec.Void == 0',10540,'Void Invoice',8,'invoice_void.ews',NULL,'invvoid',NULL,'javascript:ask(''Voiding will duplicate Non-POS adjustments applied to this invoice. These can be viewed or modified from the history menu. Continue?'',''invoice_void.ews?InvoiceID=$Variables.InvoiceID&CustomerID=$Variables.CustomerID#ltop'');','Void Invoice',51,'mai_mnu_VoidInvoice','Invoices')}
go
{CALL CT_MenuItems('read','P',NULL,NULL,'$Variables.StatementID ==',11431,'Preview Statement',8,'mbr_statement_preview.ews',NULL,'statementpreview',NULL,'mbr_statement_preview.ews?CustomerID=$Variables.CustomerID#ltop','Preview Statement',52,'mst_mnu_Preview','Statements')}
go
{CALL CT_MenuItems('add','N',NULL,NULL,'$Variables.StatementID ==',11432,'New Statement',NULL,'mbr_statement_next.ews',NULL,'statementnew',NULL,'mbr_statement_next.ews?CustomerID=$Variables.CustomerID#ltop','New Statement',53,'mst_mnu_New','Statements')}
go
{CALL CT_MenuItems('read','P',NULL,NULL,'$Variables.StatementID !=',10164,'Print',8,'print_statement.ews',NULL,'statementprint',NULL,'javascript:newwinrpt(''print_statement.ews?CustomerID=$Variables.CustomerID&StatementID=$Variables.StatementID'')','Print',54,'mst_mnu_Print','Statements')}
go
{CALL CT_MenuItems('read','E',NULL,NULL,'$Variables.StatementID !=',10188,'Email',8,'email_statement.ews',NULL,'statementemail',NULL,'email_statement.ews?CustomerID=$Variables.CustomerID&StatementID=$Variables.StatementID#etop','Email',55,'mst_mnu_Email','Statements')}
go
{CALL CT_MenuItems('add','P',NULL,NULL,'$Variables.StatementID !=',10161,'Payment',8,'mbr_payment_add.ews',NULL,'statementpayment',NULL,'mbr_payment_add.ews?CustomerID=$Variables.CustomerID&InvoiceID=0&Amount=$Unpaid.Unpaid','Payment',56,NULL,'Payments')}
go
{CALL CT_MenuItems('read','7',NULL,NULL,NULL,11397,'Options',NULL,'pref.ews',NULL,'pref',NULL,'pref.ews','Options',57,NULL,NULL)}
go
{CALL CT_MenuItems('read','9',NULL,NULL,NULL,11581,'Admin',NULL,'admin.ews',NULL,'admin',NULL,'admin/admin.ews','Admin',58,NULL,NULL)}
go
{CALL CT_MenuItems(NULL,NULL,NULL,NULL,NULL,NULL,'Logoff',NULL,NULL,NULL,'logoff',NULL,'javascript:logoff();','Logoff',59,NULL,NULL)}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,NULL,10468,'New Incident',NULL,'incident_edit.ews',NULL,'newincident',NULL,'incident_edit.ews?CustomerID=$FindCustomerID.CustomerID&iAccountID=$Variables.AccountID&AccountID=$Variables.AccountID','New Incident',61,NULL,'Incidents')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11450,'SA Incident',NULL,'incident_list_f.ews',NULL,'saincident',NULL,'incident_list_f.ews','SA Incident',63,'shs_show_Incidents','Incidents')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11451,'SA RADIUS',NULL,'sa_radius_f.ews',NULL,'saradius',NULL,'sa_radius_f.ews','SA RADIUS',64,'shs_show_RADIUS','Radconfigs')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11452,'SA Email',NULL,'sa_email_f.ews',NULL,'saemail',NULL,'sa_email_f.ews','SA Email',65,'shs_show_Email','Aliases')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11453,'MBR SA List',NULL,'sa_list_f.ews',NULL,'mbrsalist',NULL,'sa_list_f.ews','MBR SA List',67,'shm_show_Services','SubAccounts')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11455,'MBR Aging',8,'mbr_aging_f.ews',NULL,'mbraging',NULL,'mbr_aging_f.ews','MBR Aging',70,'shm_show_Aging','Aging')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12215,'MBR Statements',NULL,'mbr_statements_f.ews',NULL,'mbrstatements',NULL,'mbr_statements_f.ews','MBR Statements',71,NULL,'Statements')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12216,'MBR Invoices',NULL,'mbr_invoices_f.ews',NULL,'mbrinvoices',NULL,'mbr_invoices_f.ews','MBR Invoices',72,NULL,'Invoices')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11456,'MBR History',NULL,'mbr_history_f.ews',NULL,'mbrhistory',NULL,'mbr_history_f.ews','MBR History',73,'shm_show_History',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'General',NULL,NULL,NULL,'ageneral','ageneral','admin.ews?MGID=ageneral','General',74,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Pre-Paid',15,NULL,NULL,'aprepaid','aprepaid','admin.ews?MGID=aprepaid','Pre-Paid',75,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sales & Marketing',NULL,NULL,NULL,'asales','asales','admin.ews?MGID=asales','Sales & Marketing',76,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rating',25,NULL,NULL,'arating','arating','admin.ews?MGID=arating','Rating',77,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Resellers',11,NULL,NULL,'aresellers','aresellers','admin.ews?MGID=aresellers','Resellers',78,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Services',NULL,NULL,NULL,'aservices','aservices','admin.ews?MGID=aservices','Services',80,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Accounting',8,NULL,NULL,'aaccounting','aaccounting','admin.ews?MGID=aaccounting','Accounting',81,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Reports & Logs',NULL,NULL,NULL,'areports','areports','admin.ews?MGID=areports','Reports & Logs',82,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Incidents & Schedules',NULL,NULL,NULL,'aincidents','aincidents','admin.ews?MGID=aincidents','Incidents & Schedules',83,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Scheduler',NULL,NULL,NULL,'atasks','atasks','admin.ews?MGID=atasks','Scheduler',84,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Web Interface',NULL,NULL,NULL,'aweb','aweb','admin.ews?MGID=aweb','Web Interface',85,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Security',NULL,NULL,NULL,'asecurity','asecurity','admin.ews?MGID=asecurity','Security',86,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Advanced',NULL,NULL,NULL,'aadvanced','aadvanced','admin.ews?MGID=aadvanced','Advanced',87,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Database',NULL,NULL,NULL,'adatabase','adatabase','admin.ews?MGID=adatabase','Database',88,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Apply',NULL,'apply.ews',NULL,'aapply',NULL,'apply.ews','Apply',89,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Client',NULL,'main.ews',NULL,'aclient',NULL,'/main.ews','Client',90,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Domains',NULL,'Domains-List.ews',NULL,'domains',NULL,'Domains-List.ews?MGID=$Variables.MGID','Domains',91,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Billing Groups',NULL,'Groups-List.ews',NULL,'groups',NULL,'Groups-List.ews?MGID=$Variables.MGID','Billing Groups',92,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'MBR Custom Data',NULL,'MasterAccountDataTypes-list.ews',NULL,'mbrcustom',NULL,'MasterAccountDataTypes-list.ews?MGID=$Variables.MGID','MBR Custom Data',93,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Regions',NULL,'Regions-List.ews',NULL,'regions',NULL,'Regions-List.ews?MGID=$Variables.MGID','Regions',94,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SMTP Settings',NULL,'configs-list.ews',NULL,'smtp',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=4&nogroup=1','SMTP Settings',95,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Address Types',NULL,'AddressTypes-list.ews',NULL,'addresstypes',NULL,'AddressTypes-list.ews?MGID=$Variables.MGID','Address Types',97,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sales Persons',8,'SalesPersons-list.ews',NULL,'salespersons',NULL,'SalesPersons-list.ews?MGID=$Variables.MGID','Sales Persons',98,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Referred By',NULL,'ReferredBys-List.ews',NULL,'referredbys',NULL,'ReferredBys-List.ews?MGID=$Variables.MGID','Referred By',99,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Cancel Reasons',8,'CancelReasons-list.ews',NULL,'cancelreasons',NULL,'CancelReasons-List.ews?MGID=$Variables.MGID','Cancel Reasons',100,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Types',NULL,'AccountTypes-list.ews',NULL,'accounttypes',NULL,'AccountTypes-List.ews?MGID=$Variables.MGID','Service Types',101,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Custom Data',NULL,'SubAccountDataTypes-list.ews',NULL,'sacustom',NULL,'SubAccountDataTypes-list.ews?MGID=$Variables.MGID','Custom Data',102,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'External Systems',14,'ExternalSystems-list.ews',NULL,'externalsystems',NULL,'ExternalSystems-list.ews?MGID=$Variables.MGID','External Systems',103,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Report Groups',NULL,'ReportGroups-list.ews',NULL,'reportgroups',NULL,'ReportGroups-list.ews?MGID=$Variables.MGID','Report Groups',104,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Settings',NULL,'configs-list.ews',NULL,'reportsettings',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=5&nogroup=1','Settings',105,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Log Trimming',NULL,'configs-list.ews',NULL,'logtrim',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=11&nogroup=1','Log Trimming',106,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Incident Types',NULL,'IncidentTypes-list.ews',NULL,'incidenttypes',NULL,'IncidentTypes-list.ews?MGID=$Variables.MGID','Incident Types',108,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Settings',NULL,'configs-list.ews',NULL,'accountingsettings',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=6','Settings',110,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Charge Types',NULL,'ChargeTypes-list.ews',NULL,'chargetypes',NULL,'ChargeTypes-list.ews?MGID=$Variables.MGID','Charge Types',111,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Pay Periods',8,'PayPeriods-list.ews',NULL,'payperiods',NULL,'PayPeriods-list.ews?MGID=$Variables.MGID','Pay Periods',112,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Taxes',8,'Taxes-list.ews',NULL,'taxes',NULL,'Taxes-list.ews?MGID=$Variables.MGID','Taxes',113,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Discounts',8,'Discounts-list.ews',NULL,'discounts',NULL,'Discounts-list.ews?MGID=$Variables.MGID','Discounts',114,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Billing Cycles',NULL,'BillingCycles-list.ews',NULL,'billingcycles',NULL,'BillingCycles-list.ews?MGID=$Variables.MGID','Billing Cycles',115,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Send Methods',NULL,'SendMethods-list.ews',NULL,'sendmethods',NULL,'SendMethods-list.ews?MGID=$Variables.MGID','Send Methods',117,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'GL Codes',NULL,'GLCodes-list.ews',NULL,'glcodes',NULL,'GLCodes-list.ews?MGID=$Variables.MGID','GL Codes',118,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'RADIUS',NULL,NULL,NULL,'radius','aradius','admin.ews?MGID=aradius','RADIUS',119,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Vendors',NULL,'RadVendors-list.ews',NULL,'vendors',NULL,'RadVendors-list.ews?MGID=$Variables.MGID','Vendors',120,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Access Servers',NULL,'ServerGroups-List.ews',NULL,'servergroups',NULL,'ServerGroups-List.ews?MGID=$Variables.MGID','Access Servers',124,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Roam Servers',1,'RadRoamServers-List.ews',NULL,'radroamservers',NULL,'RadRoamServers-List.ews?MGID=$Variables.MGID','Roam Servers',125,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Roam Domains',1,'RadRoamDomains-List.ews',NULL,'radroamdomains',NULL,'RadRoamDomains-List.ews?MGID=$Variables.MGID','Roam Domains',126,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'RADIUS Log Msgs',13,'RadLogMsgs-List.ews',NULL,'logmsgs',NULL,'RadLogMsgs-List.ews?MGID=$Variables.MGID','RADIUS Log Msgs',127,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Reject Attributes',NULL,'RadRejects-List.ews',NULL,'radrejects',NULL,'RadRejects-List.ews?MGID=$Variables.MGID','Reject Attributes',128,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Filter Groups',24,'RadFilterGroups-List.ews',NULL,'radfiltergroups',NULL,'RadFilterGroups-List.ews?MGID=$Variables.MGID','Filter Groups',130,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Group Concurrency',NULL,'RadConcurrency-List.ews',NULL,'radconcurrency',NULL,'RadConcurrency-List.ews?MGID=$Variables.MGID','Group Concurrency',131,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Search task history',NULL,'sched_logs.ews',NULL,'schedlogs',NULL,'sched_logs.ews?MGID=$Variables.MGID','Search task history',132,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Current Status',NULL,'sched_status.ews',NULL,'schedcurrent',NULL,'sched_status.ews?MGID=$Variables.MGID','Current Status',133,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Configure schedule',NULL,'Schedules-list.ews',NULL,'schedcfg',NULL,'Schedules-list.ews?MGID=$Variables.MGID','Configure schedule',134,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operator Settings',NULL,'configs-list.ews',NULL,'opsettings',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=8','Operator Settings',135,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Themes',NULL,'themes-list.ews',NULL,'themes',NULL,'themes-list.ews?MGID=$Variables.MGID','Themes',142,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Web Links',NULL,'WebLinkTypes-list.ews',NULL,'weblink',NULL,'WebLinkTypes-list.ews?MGID=$Variables.MGID','Web Links',143,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operators',NULL,'Operators-list.ews',NULL,'operators',NULL,'Operators-list.ews?MGID=$Variables.MGID','Operators',144,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operator Groups',NULL,'OperatorGroups-list.ews',NULL,'operatorgroups',NULL,'OperatorGroups-list.ews?MGID=$Variables.MGID','Operator Groups',145,NULL,NULL)}
go
{CALL CT_MenuItems('read','C',NULL,NULL,NULL,10196,'Call Search',NULL,'callsearch.ews',NULL,'callsearch',NULL,'callsearch.ews#etop','Call Search',146,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Table2Script',13,'table2script.ews',NULL,'table2sript',NULL,'Table2Script-List.ews?MGID=aadvanced','Table2Script',149,NULL,NULL)}
go
{CALL CT_MenuItems('read','O',NULL,NULL,NULL,11428,'Online',NULL,'online_list.ews',NULL,'online',NULL,'online_list.ews#etop','Online',150,NULL,NULL)}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,11429,'Aging',8,'aging.ews',NULL,'aging',NULL,'aging.ews#etop','Aging',153,NULL,NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,11546,'RADIUS Logs',NULL,'radlogs.ews',NULL,'radlogs',NULL,'radlogs.ews#etop','RADIUS Logs',155,NULL,NULL)}
go
{CALL CT_MenuItems('read','M',NULL,NULL,NULL,11547,'Mail Logs',NULL,'maillogs.ews',NULL,'maillogs',NULL,'maillogs.ews#etop','Mail Logs',156,NULL,NULL)}
go
{CALL CT_MenuItems('read','Y',NULL,NULL,NULL,11548,'System Logs',10,'syslogs.ews',NULL,'syslogs',NULL,'syslogs.ews#etop','System Logs',157,NULL,NULL)}
go
{CALL CT_MenuItems('read','U',NULL,NULL,NULL,11550,'Audit Logs',NULL,'auditlogs.ews',NULL,'auditlogs',NULL,'auditlogs.ews#etop','Audit Logs',159,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Security',NULL,'ipsec_list.ews',NULL,'ipsec',NULL,'ipsec_list.ews?MGID=$Variables.MGID','IP Security',160,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Encryption',NULL,'encmgr.ews',NULL,'encmgr',NULL,'encmgr.ews?MGID=$Variables.MGID','Encryption',161,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Exports',13,'exports-list.ews',NULL,'exports',NULL,'exports-list.ews?MGID=$Variables.MGID','Exports',162,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Notice Types',12,'NoticeTypes-list.ews',NULL,'noticetypes',NULL,'NoticeTypes-list.ews?MGID=$Variables.MGID','Notice Types',163,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Meta Tables',13,'meta_table_list.ews',NULL,'metatables',NULL,'meta_table_list.ews?MGID=$Variables.MGID','Meta Tables',164,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Object Groups',13,'og_list.ews',NULL,'oglist',NULL,'og_list.ews?MGID=$Variables.MGID','Object Groups',165,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Menu Editor',13,'Menus-list.ews',NULL,'menulist',NULL,'Menus-List.ews?MGID=$Variables.MGID','Menu Editor',166,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SQL Query',NULL,'db_query.ews',NULL,'dbquery',NULL,'db_query.ews?MGID=$Variables.MGID','SQL Query',167,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Current Activity',NULL,'db_spidwatch.ews',NULL,'dbspidwatch',NULL,'db_spidwatch.ews?MGID=$Variables.MGID','Current Activity',168,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Scheduler Tasks',13,'sched_tasks.ews',NULL,'schedtasks',NULL,'sched_tasks.ews?MGID=$Variables.MGID','Scheduler Tasks',169,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Time Sets',25,'timerates-list.ews',NULL,'timesets',NULL,'timerates-list.ews?MGID=$Variables.MGID','Time Sets',170,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Priorities',NULL,'Priorities-List.ews',NULL,'priorities',NULL,'Priorities-List.ews?MGID=$Variables.MGID','Priorities',171,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operator Roles',NULL,'Roles-List.ews',NULL,'roles',NULL,'Roles-List.ews?MGID=$Variables.MGID','Operator Roles',172,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Incident States',NULL,'IncidentStateGroups-List.ews',NULL,'incidentstategroups',NULL,'IncidentStateGroups-List.ews?MGID=$Variables.MGID','Incident States',173,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rate Classes',25,'RateClasses-List.ews',NULL,'rateclasses',NULL,'RateClasses-List.ews?MGID=$Variables.MGID','Rate Classes',174,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rate Sources',25,'RateSources-List.ews',NULL,'ratesources',NULL,'RateSources-List.ews?MGID=$Variables.MGID','Rate Sources',175,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Customer Settings',NULL,'configs-lits.ews',NULL,'customersettings',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=14','Customer Settings',176,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Protocols',NULL,'RateIPProtocols-list.ews',NULL,'ipprotocols',NULL,'RateIPProtocols-list.ews?MGID=$Variables.MGID','IP Protocols',178,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Ports',NULL,'RateIPPorts-list.ews',NULL,'ipports',NULL,'RateIPPorts-list.ews?MGID=$Variables.MGID','IP Ports',179,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rates',25,'Rates-List.ews',NULL,'rates',NULL,'Rates-List.ews?MGID=$Variables.MGID','Rates',180,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rule Sets',25,'RateRules-List.ews',NULL,'raterules',NULL,'RateRules-List.ews?MGID=$Variables.MGID','Rule Sets',181,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rate Config Types',25,'RateTypes-List.ews',NULL,'ratetypes',NULL,'RateTypes-List.ews?MGID=$Variables.MGID','Rate Config Types',182,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Client Settings',NULL,'configs-list.ews',NULL,'clientsettings',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=1','Client Settings',183,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Intervals',25,'RateIntervals-List.ews',NULL,'rateintervals',NULL,'RateIntervals-List.ews?MGID=$Variables.MGID','Intervals',184,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rate Classifiers',25,'RateClass-list.ews',NULL,'rateclass',NULL,'RateClass-List.ews?MGID=$Variables.MGID','Rate Classifiers',185,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tax Groups',8,'TaxGroups-list.ews',NULL,'taxgroups',NULL,'TaxGroups-list.ews?MGID=$Variables.MGID','TaxGroups',187,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Organizations',NULL,'Organizations-list.ews',NULL,'organizations',NULL,'Organizations-List.ews?MGID=$Variables.MGID','Organizations',188,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Pricing',11,'OrgAccountTypes-list.ews',NULL,'orgaccounttypes',NULL,'OrgAccountTypes-list.ews?MGID=$Variables.MGID','Service Pricing',189,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Countries',NULL,'Countries-list.ews',NULL,'countries',NULL,'Countries-List.ews?MGID=$Variables.MGID','Countries',190,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Geo Regions',NULL,'Continents-list.ews',NULL,'continents',NULL,'Continents-List.ews?MGID=$Variables.MGID','Geo Regions',191,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Batch Processors',8,'BatchProcessors-List.ews',NULL,'batchprocessors',NULL,'BatchProcessors-List.ews?MGID=$Variables.MGID','Batch Processors',194,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Notices',12,'Notices-list.ews',NULL,'notices',NULL,'Notices-list.ews?MGID=$Variables.MGID','Notices',195,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'External Sys Types',14,'ExternalSystemTypes-list.ews',NULL,'externalsystemtypes',NULL,'ExternalSystemTypes-list.ews?MGID=$Variables.MGID','External Sys Types',196,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,11567,'Acct Data Fields',NULL,'AccountDataTypes-list.ews',NULL,'accountdatatypes',NULL,'AccountDataTypes-list.ews?MGID=$Variables.MGID','Acct Data Fields',197,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tax Exemptions',8,'TaxExemptions-list.ews',NULL,'taxexemptions',NULL,'TaxExemptions-list.ews?MGID=$Variables.MGID','Tax Exemptions',200,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tax Pig Groups',8,'TaxPigGroups-list.ews',NULL,'taxpiggybacks',NULL,'TaxPiggyBacks-list.ews?MGID=$Variables.MGID','Tax Pig Groups',201,NULL,NULL)}
go
{CALL CT_MenuItems('read','3',NULL,NULL,NULL,11398,'Billing',8,'billing.ews',NULL,'billing',NULL,'billing.ews','Billing',202,NULL,NULL)}
go
{CALL CT_MenuItems('read','O',NULL,NULL,NULL,11584,'Post Payments',8,'billing_payments.ews',NULL,'payments',NULL,'billing_payments.ews','Post Payments',203,NULL,NULL)}
go
{CALL CT_MenuItems('read','4',NULL,NULL,NULL,11399,'Support',NULL,'incidents_search.ews',NULL,'support',NULL,'incidents_search.ews?ShowOption=1&Assign=-1','support',204,NULL,NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,11585,'Create Bills',8,'billing_create.ews',NULL,'billingcreate',NULL,'billing_create.ews#ltop','Billing Create',205,NULL,NULL)}
go
{CALL CT_MenuItems('read','N',NULL,NULL,NULL,11586,'Send Bills',8,'billing_send.ews',NULL,'billingsend',NULL,'billing_send.ews?action=print#ltop','Billing Send',206,NULL,NULL)}
go
{CALL CT_MenuItems('read','D',NULL,NULL,NULL,11587,'Credit Cards',8,'billing_cc.ews',NULL,'billingcc',NULL,'billing_cc.ews?option=1#etop','Billing CC',208,NULL,NULL)}
go
{CALL CT_MenuItems('read','B',NULL,NULL,NULL,11588,'Bank Trans',8,'billing_ach.ews',NULL,'billingach',NULL,'billing_ach.ews?option=1#etop','Billing ACH',209,NULL,NULL)}
go
{CALL CT_MenuItems('read','F',NULL,NULL,NULL,10112,'Failed Transactions',NULL,'billing_failed.ews',NULL,'billingfailed',NULL,'billing_failed.ews#ltop','Billing Failed',210,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Groups',NULL,'ServiceGroups-list.ews',NULL,'servicegroups',NULL,'ServiceGroups-list.ews?MGID=$Variables.MGID','Service Groups',211,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operator Limits',NULL,'configs-list.ews',NULL,'oplimits',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=16','Operator Limits',212,NULL,NULL)}
go
{CALL CT_MenuItems('read','B',NULL,NULL,NULL,11590,'Bulk Messaging',NULL,'support_email.ews',NULL,'bulkemail',NULL,'support_email.ews#etop','Bulk Messaging',213,NULL,NULL)}
go
{CALL CT_MenuItems('read','U',NULL,NULL,NULL,11589,'Usage Charges',NULL,'billing_external.ews',NULL,'external',NULL,'billing_external.ews#ltop','Billing External',214,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Group Rights',NULL,'configs-list.ews',NULL,'oprights',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=17','Group Rights',220,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Active Sessions',NULL,'emerwho.ews',NULL,'emerwho',NULL,'emerwho.ews?MGID=$Variables.MGID','Active Sessions',221,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Late Fees',8,'latefees-list.ews',NULL,'latefees',NULL,'LateFees-list.ews?MGID=$Variables.MGID','Late Fees',222,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sequences',15,'carddigits-list.ews',NULL,'cardsequences',NULL,'carddigits-list.ews?MGID=$Variables.MGID','Sequences',223,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Batch Types',NULL,'cardbatchtypes-list.ews',NULL,'cardbatchtypes',NULL,'cardbatchtypes-list.ews?MGID=$Variables.MGID','Batch Types',224,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Prepaid Batches',15,'cardbatches-list.ews',NULL,'cardbatches',NULL,'cardbatches-list.ews?MGID=$Variables.MGID','Prepaid Batches',225,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Time & Data Charges',NULL,'timecharges-list.ews',NULL,'timecharges',NULL,'timecharges-list.ews?MGID=$Variables.MGID','Time & Data Charges',226,NULL,NULL)}
go
{CALL CT_MenuItems('read','P',NULL,NULL,NULL,11430,'Reports',NULL,'reports.ews',NULL,'reports',NULL,'reports.ews#ltop','Reports',227,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Signup Servers',18,'SignupServers-list.ews',NULL,'signupsrv',NULL,'SignupServers-list.ews?MGID=$Variables.MGID','Signup Servers',230,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12217,'Service Status',16,'cust_status.ews',NULL,'custacctstatus',NULL,'cust_status.ews','Service Status',231,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowCallHistory == 1',12218,'Usage Stats',NULL,'cust_online.ews',NULL,'custusagehist',NULL,'cust_online.ews?AccountID=$User.AccountID','Usage Stats',232,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowBillHistory == 1',12219,'Billing & Payments',8,'cust_history.ews',NULL,'custbillhist',NULL,'cust_history.ews','Billing & Payments',233,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12220,'Manage Account',NULL,'cust_accounts.ews',NULL,'custaccounts',NULL,'cust_accounts.ews','Manage Account',234,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowTimeCharge == 1',12221,'Purchase Data',8,'cust_buytime.ews',NULL,'custbuytime',NULL,'cust_buytime.ews','Purchase Data',236,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowIncidents == 1',12222,'Help & Appointments',NULL,'cust_incidents.ews',NULL,'custhelp',NULL,'cust_incidents.ews','Help & Appointments',238,NULL,NULL)}
go
{CALL CT_MenuItems(NULL,NULL,NULL,NULL,NULL,11444,'Log Off',NULL,NULL,NULL,'custlogoff',NULL,'javascript:logoff();','Log Off',239,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowCustChangeLogin == 1',12223,'Change my access password',16,'cust_sa_pass_edit.ews',NULL,'custpasschange',NULL,'cust_sa_pass_edit.ews?AccountID=$User.AccountID','Change Password',240,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.RecurringManager == 1',12224,'Credit Card and automatic payment settings',8,'cust_billing.ews',NULL,'custbilling',NULL,'cust_billing.ews','Update Billing',241,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Clear Online List',NULL,'radclearports.ews',NULL,'radclearports',NULL,'RadClearPorts.ews?MGID=$Variables.MGID','Clear Online List',242,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Auth Test Config',NULL,'configs-list.ews',NULL,'radlogin',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=18','Auth Test Config',243,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowCustChangeLogin == 1',12225,'Change service login',16,'cust_sa_login_edit.ews',NULL,'custsalogin',NULL,'cust_sa_login_edit.ews?AccountID=$floop.AccountID&FilterAccountID=$Variables.FilterAccountID','Change service login',244,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowCustChangePass == 1',12226,'Change service password',16,'cust_sa_pass_edit.ews',NULL,'custsapass',NULL,'cust_sa_pass_edit.ews?AccountID=$floop.AccountID&FilterAccountID=$Variables.FilterAccountID','Change service password',245,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowCustCancel == 1',12227,'Cancel this service',8,'cust_sa_cancel.ews',NULL,'custsacancel',NULL,'cust_sa_cancel.ews?AccountID=$floop.AccountID&FilterAccountID=$Variables.FilterAccountID','Cancel this service',246,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'License Keys',NULL,'Licenses-List.ews',NULL,'licensekeys',NULL,'Licenses-list.ews?MGID=$Variables.MGID','License Keys',247,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.InvoiceID ==',11438,'Verify Invoices',8,'invoice_recalc.ews',NULL,'invrecalc',NULL,'invoice_recalc.ews?CustomerID=$Variables.CustomerID#ltop','Verify Invoices',250,'mai_mnu_VerifyInvoices',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.CardBatchID !=',NULL,'XML Export',15,'CardAccounts-export.ews',NULL,'cardxmlexport',NULL,'CardAccounts-export.ews?headertype=17&type=xml&CardBatchID=$Variables.CardBatchID','XML Export',251,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.CardBatchID !=',NULL,'TSV Export',15,'CardAccounts-export.ews',NULL,'cardcsvexport',NULL,'CardAccounts-export.ews?CardBatchID=$Variables.CardBatchID&headertype=17&type=tsv','TSV Export',252,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowMBRCancel == 1',12228,'Cancel account and all services',NULL,'cust_mbr_cancel.ews',NULL,'custmbrcancel',NULL,'cust_mbr_cancel.ews','Cancel account (Includes all services)',255,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Languages',NULL,'Languages-list.ews',NULL,'languages',NULL,'Languages-list.ews?MGID=$Variables.MGID','Languages',256,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Currencies',NULL,'Currencies-list.ews',NULL,'currencies',NULL,'Currencies-list.ews?MGID=$Variables.MGID','Currencies',257,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Commissions',8,'CommissionGroups-list.ews',NULL,'commissions',NULL,'CommissionGroups-list.ews?MGID=$Variables.MGID','Commissions',258,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Report Fields',NULL,'ReportFields-list.ews',NULL,'reportfields',NULL,'ReportFields-list.ews?MGID=$Variables.MGID','Report Fields',259,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Data Sources',NULL,'RateDataSources-list.ews',NULL,'ratedatasources',NULL,'RateDataSources-list.ews?MGID=$Variables.MGID','Data Sources',260,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Object Group Info',NULL,'og_info.ews',NULL,'groupinfo',NULL,'og_info.ews?MGID=$Variables.MGID','Object Group Info',261,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Session Manager',NULL,'configs-list.ews',NULL,'sesmgr',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=19&nogroup=1','Session Manager',262,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Payment Types',8,'PaymentTypes-edit.ews',NULL,'paymenttypes',NULL,'PaymentTypes-edit.ews?MGID=$Variables.MGID','Payment Types',263,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowRecharge == 1',12229,'Prepaid Recharge',15,'cust_recharge.ews',NULL,'custrecharge',NULL,'cust_recharge.ews','Prepaid Recharge',265,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Backup Emerald',NULL,'db_backup.ews',NULL,'dbbackup',NULL,'db_backup.ews?MGID=$Variables.MGID','Backup Emerald',266,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Auth Fail Attributes',NULL,'radrejectattributes-list.ews',NULL,'radrejectattributes',NULL,'RadRejectAttributes-list.ews?MGID=$Variables.MGID','Auth Fail Attributes',267,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tax Types',8,'TaxTypes-list.ews',NULL,'taxtypes',NULL,'TaxTypes-list.ews?MGID=$Variables.MGID','Tax Types',268,NULL,NULL)}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,12174,'Prepaid Search',15,'search_cards.ews',NULL,'prepaidsearch',NULL,'search_cards.ews','Prepaid Search',269,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Batch Manager',8,'batchmgr.ews',NULL,'batchmgr',NULL,'batchmgr.ews?MGID=$Variables.MGID','Batch Manager',270,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Templates',NULL,'accounttemplates-list.ews',NULL,'accounttemplates',NULL,'AccountTemplates-list.ews?MGID=$Variables.MGID','Service Templates',271,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Incident Templates',NULL,'IncidentTemplates-list.ews',NULL,'incidenttemplates',NULL,'IncidentTemplates-list.ews?MGID=$Variables.MGID','Incident Templates',272,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Database Usage',NULL,'db_usage.ews',NULL,'dbusage',NULL,'db_usage.ews?MGID=$Variables.MGID','Database Usage',273,NULL,NULL)}
go
{CALL CT_MenuItems('read','S',NULL,NULL,NULL,12230,'SMS Logs',30,'smslogs.ews',NULL,'smslogs',NULL,'smslogs.ews#etop','SMS Logs',274,NULL,NULL)}
go
{CALL CT_MenuItems('read','H',NULL,NULL,NULL,12231,'Change History',NULL,'changelog.ews',NULL,'changelog',NULL,'changelog.ews#etop','Change History',275,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Trusted Access',NULL,'TrustedFiles-list.ews',NULL,'trustedfiles',NULL,'TrustedFiles-list.ews?MGID=$Variables.MGID','Trusted Access',276,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Reverse Proxies',NULL,'WebForwarders-list.ews',NULL,'webforwarders',NULL,'WebForwarders-list.ews?MGID=$Variables.MGID','Reverse Proxies',277,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.CardBatchID !=',NULL,'Excel Export',15,'CardAccounts-export.ews',NULL,'cardexcelexport',NULL,'CardAccounts-export.ews?CardBatchID=$Variables.CardBatchID&headertype=17&type=excel','Excel Export',278,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Messaging',NULL,NULL,NULL,'amsg','amsg','admin.ews?MGID=amsg','Messaging',279,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Compliance',NULL,NULL,NULL,'acomply','acomply','admin.ews?MGID=acomply','Compliance',280,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'FCC - Services',NULL,'RegFCC477AccountTypes-edit.ews',NULL,'fcc477services',NULL,'RegFCC477AccountTypes-edit.ews?MGID=$Variables.MGID','FCC - Services',281,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Geography',NULL,NULL,NULL,'ageo','ageo','admin.ews?MGID=ageo','Geography',282,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Inventory',31,NULL,NULL,'ainv','ainv','admin.ews?MGID=ainv','Inventory',283,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sites',NULL,NULL,NULL,'asites','asites','admin.ews?MGID=asites','Sites',284,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Categories',NULL,'ServiceCategories.ews',NULL,'servicecat',NULL,'ServiceCategories-list.ews?MGID=$Variables.MGID','Service Categories',285,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Type Fields',NULL,NULL,NULL,'sectionat',NULL,'SectionAccountTypes.ews?MGID=$Variables.MGID','Service Type Fields',286,NULL,'SectionAccountTypes')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Admin Addresses',NULL,'Addresses-list.ews',NULL,'addresses',NULL,'Addresses-list.ews?MGID=$Variables.MGID','Admin Addresses',287,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sites',NULL,'Sites-list.ews',NULL,'sites',NULL,'Sites-list.ews?MGID=$Variables.MGID','Sites',288,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tower Types',28,'TowerTypes-list.ews',NULL,'towertype',NULL,'TowerTypes-list.ews?MGID=$Variables.MGID','Tower Types',289,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Towers',28,'Towers-list.ews',NULL,'towers',NULL,'Towers-list.ews?MGID=$Variables.MGID','Towers',290,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Antenna Types',28,'TowerAntennaTypes-list.ews',NULL,'toweranttype',NULL,'TowerAntennaTypes-list.ews?MGID=$Variables.MGID','Antenna Types',291,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SMS Pollers',30,'SMSPollers-list.ews',NULL,'smspollers',NULL,'SMSPollers-list.ews?MGID=$Variables.MGID','SMS Pollers',292,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SMS Exp Groups',NULL,'SMSREGroups-list.ews',NULL,'smsregroups',NULL,'SMSREGroups-list.ews?MGID=$Variables.MGID','SMS Exp Groups',293,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SMS Processing',30,'SMSProc-edit.ews',NULL,'smsproc',NULL,'SMSProc-edit.ews?MGID=$Variables.MGID','SMS Processing',294,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Notify Purposes',NULL,'NoticePurposes-edit.ews',NULL,'noticepurpose',NULL,'NoticePurposes-edit.ews?MGID=$Variables.MGID','Notify Purposes',295,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Market Categories',8,'MarketCategories-list.ews',NULL,'marketcat',NULL,'MarketCategories-list.ews?MGID=$Variables.MGID','Market Categories',296,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Market Tags',8,'MarketTags-list.ews',NULL,'markettags',NULL,'MarketTags-list.ews?MGID=$Variables.MGID','Market Tags',297,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Market Groups',8,'MarketTagGroups-list.ews',NULL,'markettaggroups',NULL,'MarketTagGroups-list.ews?MGID=$Variables.MGID','Market Groups',298,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Referral Manager',17,'RefManagers-list.ews',NULL,'refmanagers',NULL,'RefManagers-list.ews?MGID=$Variables.MGID','Referral Manager',299,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Database Log',NULL,'db_errorlog.ews',NULL,'dberrorlog',NULL,'db_errorlog.ews?MGID=$Variables.MGID','Database Log',300,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Promo Codes',17,'PromoCodes-list.ews',NULL,'promocodes',NULL,'PromoCodes-list.ews?MGID=$Variables.MGID','Promo Codes',301,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Client Cert Status',NULL,'ClientCertInacts-list.ews',NULL,'clientcertinacts',NULL,'ClientCertInacts-list.ews?MGID=$Variables.MGID','Client Cert Status',302,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Access Labels',NULL,'AccessLabels-list.ews',NULL,'accesslabels',NULL,'AccessLabels-list.ews?MGID=$Variables.MGID','Access Labels',303,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Mime Types',NULL,'MimeTypes-list.ews',NULL,'mimetypes',NULL,'MimeTypes-list.ews?MGID=$Variables.MGID','Mime Types',304,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'File Categories',32,'FileCategories-list.ews',NULL,'filecategories',NULL,'FileCategories-list.ews?MGID=$Variables.MGID','File Categories',305,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Event Types',NULL,'EventTypes-list.ews',NULL,'eventtypes',NULL,'EventTypes-list.ews?MGID=$Variables.MGID','Event Types',306,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Scheduling Resources',33,'SchedBlockTypes-list.ews',NULL,'schedblocktypes',NULL,'SchedBlockTypes-list.ews?MGID=$Variables.MGID','Scheduling Resources',307,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Scheduling Time Sets',33,'SchedTimes-list.ews',NULL,'schedtimes',NULL,'SchedTimes-list.ews?MGID=$Variables.MGID','Scheduling Time Sets',308,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Warehouses',31,'InvWarehouses-list.ews',NULL,'invwarehouses',NULL,'InvWarehouses-list.ews?MGID=$Variables.MGID','Warehouses',309,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Product Attributes',31,'InvAttributes-list.ews',NULL,'invattributes',NULL,'InvAttributes-list.ews?MGID=$Variables.MGID','Product Attributes',310,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Product Categories',31,'InvCategories-list.ews',NULL,'invcategories',NULL,'InvCategories-list.ews?MGID=$Variables.MGID','Product Categories',311,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Product States',31,'InvStateGroups-list.ews',NULL,'invstategroups',NULL,'InvStateGroups-list.ews?MGID=$Variables.MGID','Product States',312,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Product Sources',31,'InvSources-list.ews',NULL,'invsources',NULL,'InvSources-list.ews?MGID=$Variables.MGID','Product Sources',313,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Products',31,'InvProducts-list.ews',NULL,'invproducts',NULL,'InvProducts-list.ews?MGID=$Variables.MGID','Products',314,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Change Logging',NULL,'changelog_list.ews',NULL,'changeloglist',NULL,'changelog_list.ews?MGID=$Variables.MGID','Change Logging',315,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Syslog Sources',10,'SyslogSources-list.ews',NULL,'syslogsources',NULL,'SyslogSources-list.ews?MGID=$Variables.MGID','Syslog Sources',316,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Syslog Msg Types',10,'SyslogMsgTypes-list.ews',NULL,'syslogmsgtypes',NULL,'SyslogMsgTypes-list.ews?MGID=$Variables.MGID','Syslog Msg Types',317,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Alert Sources',NULL,'AlertSources-list.ews',NULL,'alertsources',NULL,'AlertSources-list.ews?MGID=$Variables.MGID','Alert Sources',318,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Alert Types',NULL,'AlertTypes-list.ews',NULL,'alerttypes',NULL,'AlertTypes-list.ews?MGID=$Variables.MGID','Alert Types',319,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Syslog Alerts',10,'SyslogAlerts-list.ews',NULL,'syslogalerts',NULL,'SyslogAlerts-list.ews?MGID=$Variables.MGID','Syslog Alerts',320,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Gauges',NULL,'Gauges-list.ews',NULL,'gauges',NULL,'Gauges-list.ews?MGID=$Variables.MGID','Gauges',321,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Layers',29,'layers_list.ews',NULL,'layers',NULL,'layers_list.ews?MGID=$Variables.MGID','Layers',322,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Dashboard Types',NULL,'DashTypes-list.ews',NULL,'dashtypes',NULL,'DashTypes-list.ews?MGID=$Variables.MGID','Dashboard Types',323,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Alert Source Types',NULL,'AlertSourceTypes-list.ews',NULL,'alertsourcetypes',NULL,'AlertSourceTypes-list.ews?MGID=$Variables.MGID','Alert Source Types',324,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Billing Group Fields',NULL,'SectionGroups.ews',NULL,'sectiongroups',NULL,'SectionGroups.ews?MGID=$Variables.MGID','Billing Group Fields',325,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Global Default Fields',NULL,'SectionGlobals.ews',NULL,'sectionglobals',NULL,'SectionGlobals.ews?MGID=$Variables.MGID','Global Default Fields',326,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Group Fields',NULL,'SectionOperatorGroups.ews',NULL,'sectionoperatorgroups',NULL,'SectionOperatorGroups.ews?MGID=$Variables.MGID','Group Fields',327,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Address Layer Data',29,'AddressGeoSources-list.ews',NULL,'addressgeosources',NULL,'AddressGeoSources-list.ews?MGID=$Variables.MGID','Address Layer Data',328,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Address Data Types',NULL,'AddressDataTypes-list.ews',NULL,'addressdatatypes',NULL,'AddressDataTypes-list.ews?MGID=$Variables.MGID','Address Data Types',329,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12633,'FCC 477 Fixed Deployment',NULL,'fcc477_fbd.ews',NULL,'fcc477fbd',NULL,'fcc477_fbd.ews?MGID=$Variables.MGID','FCC 477 Fixed Deployment',330,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'FCC - Fixed Broadband Download',NULL,'fcc477_fbs.ews',NULL,'fcc477fbs',NULL,'fcc477_fbs.ews?MGID=$Variables.MGID','FCC - Fixed Broadband Download',331,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'FCC - Fixed Voice Download',NULL,'fcc477_fvs.ews',NULL,'fcc477fvs',NULL,'fcc477_fvs.ews?MGID=$Variables.MGID','FCC - Fixed Voice Download',332,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'FCC - Status',NULL,'fcc477_status.ews',NULL,'fcc477status',NULL,'fcc477_status.ews?MGID=$Variables.MGID','FCC - Status',333,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Tax Sources',NULL,'TaxSources-list.ews',NULL,'taxsources',NULL,'TaxSources-list.ews?MGID=$Variables.MGID','Tax Sources',334,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Process Address Data',29,'geoproc_admin.ews',NULL,'geoprocaddressdata',NULL,'geoproc_admin.ews?MGID=$Variables.MGID','Process Address Data',335,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Geocoders',29,'Geocoders-list.ews',NULL,'geocoders',NULL,'Geocoders-list.ews?MGID=$Variables.MGID','Geocoders',336,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Messaging Types',NULL,'IMTypes-List.ews',NULL,'imtypes',NULL,'IMTypes-List.ews?MGID=$Variables.MGID','Messaging Types',337,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12232,'Localization & UI',NULL,'pref_operators.ews',NULL,'prefoperators',NULL,'pref_operators.ews#etop','Localization & UI',338,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12233,'Field Visibility',NULL,'pref_sections.ews',NULL,'prefsections',NULL,'pref_sections.ews#etop','Field Visibility',339,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12234,'Manage Dashboard',NULL,'pref_dashes.ews',NULL,'prefdashes',NULL,'pref_dashes.ews#ltop','Manage Dashboard',340,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,10253,'Change Password',NULL,'pref_password.ews',NULL,'prefpasswd',NULL,'pref_password.ews#etop','Change Password',341,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12235,'Infobar Settings',NULL,'pref_infobaroperators.ews',NULL,'prefinfobar',NULL,'pref_infobaroperators.ews#etop','Infobar Settings',342,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Operator Messaging',NULL,'OperatorGroups_msg.ews',NULL,'ogmsg',NULL,'OperatorGroups_msg.ews?MGID=$Variables.MGID','Operator Messaging',343,NULL,NULL)}
go
{CALL CT_MenuItems('read','6',NULL,NULL,NULL,12236,'Inventory',31,'inventory.ews',NULL,'inv',NULL,'inventory.ews','Inventory',344,NULL,NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,11396,'Reports',NULL,'mbr_history.ews',NULL,'mbrhistory',NULL,'mbr_history.ews?CustomerID=$FindCustomerID.CustomerID&HistoryType=7','Reports',345,'ma_mnu_Reports',NULL)}
go
{CALL CT_MenuItems('read','E',NULL,NULL,NULL,12237,'Events',NULL,'events.ews',NULL,'events',NULL,'events.ews?Active=1#ltop','Events',346,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Rate Deck Formats',NULL,'RateVDNISImportTypes-list.ews',NULL,'ratevdnisimporttypes',NULL,'RateVDNISImportTypes-list.ews?MGID=$Variables.MGID','Rate Deck Formats',347,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Account Filters',NULL,'BulkProfiles-list.ews',NULL,'bulkprofile',NULL,'BulkProfiles-list.ews?MGID=$Variables.MGID','Account Filters',348,NULL,NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,12238,'Receive Items',NULL,'inv_receive.ews',NULL,'invreceive',NULL,'inv_receive.ews','Receive Items',349,NULL,NULL)}
go
{CALL CT_MenuItems('read','S',NULL,NULL,NULL,12239,'Search Inventory',31,'inv_search.ews',NULL,'invsearch',NULL,'inv_search.ews','Search Inventory',350,NULL,NULL)}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,11405,'Addresses',NULL,'sa_addr.ews',NULL,'saaddresses',NULL,'sa_addr.ews?AccountID=$Variables.AccountID#ltop','Addresses',351,'sa_mnu_Addresses','Addresses')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12240,'Gauges',NULL,'sa_gauge.ews',NULL,'sagauge',NULL,'sa_gauge.ews?AccountID=$Variables.AccountID#etop','Gauges',352,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'PCI Check',NULL,'pci_check.ews',NULL,'pcicheck',NULL,'pci_check.ews?MGID=$Variables.MGID','PCI Check',353,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12241,'MBR Market Tag List',NULL,'mbr_tag_list_f.ews',NULL,'mbrtaglist',NULL,'mbr_tag_list_f.ews','MBR Market Tag List',354,'shm_show_MarketTags',NULL)}
go
{CALL CT_MenuItems('read','M',NULL,NULL,NULL,12242,'Market Tags',8,'mbr_tag_edit.ews',NULL,'mbrtags',NULL,'mbr_tag_edit.ews?CustomerID=$Variables.CustomerID#etop','Market Tags',355,'ma_mnu_MarketTags',NULL)}
go
{CALL CT_MenuItems('read','G',NULL,NULL,NULL,12242,'Market Tags',8,'sa_tag_edit.ews',NULL,'satags',NULL,'sa_tag_edit.ews?AccountID=$Variables.AccountID#etop','Market Tags',356,'sa_mnu_MarketTags',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12243,'SA Market Tag List',8,'sa_tag_list_f.ews',NULL,'sataglist',NULL,'sa_tag_list_f.ews','SA Market Tag List',357,'shs_show_MarketTags',NULL)}
go
{CALL CT_MenuItems('read','Y',NULL,NULL,NULL,12073,'Payments',8,'mbr_payments.ews',NULL,'mbrpayments',NULL,'mbr_payments.ews?CustomerID=$Variables.CustomerID#ltop','Payments',358,'ma_mnu_Payments',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12244,'Show Invoices',NULL,'mbr_invoices.ews',NULL,'mbrinvoicesshow',NULL,'mbr_invoices.ews?CustomerID=$Variables.CustomerID#ltop','Show Invoices',359,'mai_mnu_ShowInvoices',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12245,'Show Statements',NULL,'mbr_statements.ews',NULL,'mbrstatementsshow',NULL,'mbr_statements.ews?CustomerID=$Variables.CustomerID#ltop','Show Statements',360,'mst_mnu_Show',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12246,'Show Payments',NULL,'mbr_payments.ews',NULL,'mbrpaymentsshow',NULL,'mbr_payments.ews?CustomerID=$Variables.CustomerID#ltop','Show Payments',361,'map_mnu_ShowPayments',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.PaymentID !=',11738,'Print Receipt',NULL,'print_receipt.ews',NULL,'receiptprint',NULL,'javascript:newwinrpt(''print_receipt.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID'')','Print Receipt',362,'map_mnu_PrintReceipt',NULL)}
go
{CALL CT_MenuItems('read','P',NULL,NULL,NULL,12247,'Payment Search',8,'search_payment.ews',NULL,'searchpayments',NULL,'search_payment.ews','Payment Search',363,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.PaymentID !=',12248,'Email Receipt',8,'email_receipt.ews',NULL,'receiptemail',NULL,'email_receipt.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID#etop','Email Receipt',364,'map_mnu_EmailReceipt',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$PaymentSec.AllowEdit == 1',12249,'Change Payment',8,'mbr_payment_edit.ews',NULL,'payedit',NULL,'mbr_payment_edit.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID#etop','Change Payment',365,'map_mnu_Edit',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$PaymentSec.AllowCredit == 1',12250,'Refund Payment',8,'mbr_payment_credit.ews',NULL,'paycredit',NULL,'mbr_payment_credit.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID#etop','Refund Payment',366,'map_mnu_Credit',NULL)}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,'$Variables.PaymentID ==',10165,'Make Payment',8,'mbr_payment_add.ews',NULL,'mbrpaypayment',NULL,'mbr_payment_add.ews?src=payments&CustomerID=$Variables.CustomerID#etop','Make Payment',367,'map_mnu_MakePayment','Payments')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$PaymentSec.AllowVoid == 1',12251,'Void Payment',8,'mbr_payment_void.ews',NULL,'payvoid',NULL,'javascript:ask(''Payments cannot be voided once transaction has settled. Do you wish to VOID this payment?'',''mbr_payment_void.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID'')','Void Payment',368,'map_mnu_Void','mbr_payment_void.ews')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$PaymentSec.AllowDishonor == 1',12178,'Dishonor Payment',8,'mbr_payment_dishonor.ews',NULL,'paydishonor',NULL,'mbr_payment_dishonor.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID#etop','Dishonor Payment',369,'map_mnu_Dishonor',NULL)}
go
{CALL CT_MenuItems('read','R',NULL,NULL,NULL,11396,'Reports',NULL,'sa_timeon.ews',NULL,'sareports',NULL,'sa_timeon.ews?AccountID=$Variables.AccountID#etop','Reports',370,'sa_mnu_Reports',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Payment Plans',8,'PayPlans-list.ews',NULL,'payplans',NULL,'PayPlans-list.ews?MGID=$Variables.MGID','Payment Plans',371,NULL,NULL)}
go
{CALL CT_MenuItems('read','W',NULL,NULL,NULL,12252,'Towers',28,'sa_towers.ews',NULL,'satowers',NULL,'sa_towers.ews?AccountID=$Variables.AccountID#etop','Towers',372,'sa_mnu_Towers',NULL)}
go
{CALL CT_MenuItems('read','V',NULL,NULL,NULL,12236,'Inventory',31,'sa_inv.ews',NULL,'sainv',NULL,'sa_inv.ews?AccountID=$Variables.AccountID#ltop','Inventory',373,'sa_mnu_Inventory',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12253,'SA Inventory',31,'sa_inv_list_f.ews',NULL,'sainvlist',NULL,'sa_inv_list_f.ews','SA Inventory',374,'shs_show_Inventory',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12254,'MBR Inventory',31,'mbr_inv_list_f.ews',NULL,'mbrinv',NULL,'mbr_inv_list_f.ews','MBR Inventory',375,'shm_show_Inventory',NULL)}
go
{CALL CT_MenuItems('read','C',NULL,NULL,NULL,12255,'Attachments',32,'mbr_files.ews',NULL,'mbrfiles',NULL,'mbr_files.ews?CustomerID=$Variables.CustomerID#ltop','Attachments',376,'ma_mnu_Attachments','Files')}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,NULL,12256,'Attach File',32,'file_add.ews',NULL,'filenew',NULL,'file_add.ews?CustomerID=$FindCustomerID.CustomerID&AccountID=$Variables.AccountID&InvoiceID=$Variables.InvoiceID&PaymentID=$Variables.PaymentID&IncidentID=$Variables.IncidentID','Attach File',377,NULL,'Files')}
go
{CALL CT_MenuItems('add','C',NULL,NULL,NULL,12255,'Attachments',32,'sa_files.ews',NULL,'safiles',NULL,'sa_files.ews?AccountID=$Variables.AccountID#ltop','Attachments',378,'sa_mnu_Attachments','Files')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12257,'MA File List',NULL,'file_list_f.ews',NULL,'mbrfilelist',NULL,'file_list_f.ews','MA File List',379,'shm_show_Files','Files')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12258,'SA File List',NULL,'file_list_f.ews',NULL,'safilelist',NULL,'file_list_f.ews','SA File List',380,'shs_show_Files','Files')}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,'$Variables.PaymentID !=',12256,'Attach File',32,'file_add.ews',NULL,'payfile',NULL,'file_add.ews?CustomerID=$Variables.CustomerID&PaymentID=$Variables.PaymentID#etop','Attach File',381,'map_mnu_Attach','Files')}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,'$Variables.InvoiceID !=',12256,'Attach File',32,'file_add.ews',NULL,'invoicefile',NULL,'file_add.ews?CustomerID=$Variables.CustomerID&InvoiceID=$Variables.InvoiceID#etop','Attach File',382,'mai_mnu_AttachFile','Files')}
go
{CALL CT_MenuItems('delete',NULL,NULL,NULL,'$InvoiceSec.Processed == 0',12259,'Delete Invoice',8,'invoice_delete.ews',NULL,'invdelete',NULL,'javascript:ask(''Are you sure you would like to delete this invoice?'',''invoice_delete.ews?InvoiceID=$Variables.InvoiceID&CustomerID=$Variables.CustomerID#ltop'');','Delete Invoice',383,'mai_mnu_DeleteInvoice','Invoices')}
go
{CALL CT_MenuItems('modify',NULL,NULL,NULL,'$InvoiceSec.AllowEdit == 1',12260,'Edit Invoice',NULL,'mbr_pos_edit.ews',NULL,'invedit',NULL,'mbr_pos_edit.ews?CustomerID=$Variables.CustomerID&InvoiceID=$Variables.InvoiceID#etop','Edit Invoice',384,'mai_mnu_EditInvoice','InvoiceItems')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.InvoiceID ==',12261,'Reinvoice',8,'invoice_reinvoice.ews',NULL,'invreinvoice',NULL,'invoice_reinvoice.ews?CustomerID=$FindCustomerID.CustomerID#ltop','Reinvoice',385,'mai_mnu_Reinvoice',NULL)}
go
{CALL CT_MenuItems('read','T',NULL,NULL,'$GroupID.AutoBill != 2',12262,'Timeline',8,'timeline.ews',NULL,'mbrtimeline',NULL,'timeline.ews?CustomerID=$Variables.CustomerID#etop','Timeline',386,'ma_mnu_Timeline','MasterAccounts')}
go
{CALL CT_MenuItems('read','T',NULL,NULL,'$FindCustomerID.Recurring == 1',12262,'Timeline',8,'timeline.ews',NULL,'satimeline',NULL,'timeline.ews?AccountID=$Variables.AccountID#etop','Timeline',387,'sa_mnu_Timeline','SubAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active',NULL,12263,'Schedule Open',8,'mbr_open.ews',NULL,'tlmbropen',NULL,'mbr_open.ews?CustomerID=$Variables.CustomerID#etop','Schedule Open',388,NULL,'MasterAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active',NULL,12264,'Schedule Close',8,'mbr_close.ews',NULL,'tlmbrclose',NULL,'mbr_close.ews?CustomerID=$Variables.CustomerID&preview=1#etop','Schedule Close',389,NULL,'MasterAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active',NULL,12263,'Schedule Open',8,'sa_open.ews',NULL,'tlsaopen',NULL,'sa_open.ews?AccountID=$Variables.AccountID#etop','Schedule Open',390,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'Active',NULL,12264,'Schedule Close',8,'sa_close.ews',NULL,'tlsaclose',NULL,'sa_close.ews?AccountID=$Variables.AccountID#etop','Schedule Close',391,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('modify',NULL,NULL,'AccountTypeID',NULL,12265,'Change Service Type',8,'sa_change.ews',NULL,'tlsachange',NULL,'sa_change.ews?AccountID=$Variables.AccountID#etop','Change Service Type',392,NULL,'SubAccounts')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Upgrade & Testing',NULL,'configs-list.ews',NULL,'safing',NULL,'configs-list.ews?MGID=$Variables.MGID&CGID=20&nogroup=1','Upgrade & Testing',393,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$GroupID.AutoPay == 1',12266,'Process Transactions',8,'mbr_payments_batchexport.ews',NULL,'mbrbatchexport',NULL,'mbr_payments_batchexport.ews?CustomerID=$Variables.CustomerID#ltop','Process Transactions',394,'map_mnu_ProcTrans','Payments')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.BillingAddressTypeID != 0',12267,'Change billing address and notification settings',16,'cust_billaddr.ews',NULL,'custbilladdr',NULL,'cust_billaddr.ews','Change billing address',395,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowCustChangeAT == 1',12268,'Upgrade or downgrade service',16,'cust_sa_at.ews',NULL,'custsaat',NULL,'cust_sa_at.ews?AccountID=$floop.AccountID&AccountTypeID=$floop.AccountTypeID&FilterAccountID=$Variables.FilterAccountID','Upgrade or downgrade service',396,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowAcctAdd == 1',12269,'Add a new service to my account',16,'cust_sa_add.ews',NULL,'custsaadd',NULL,'cust_sa_add.ews','Add a new service',397,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowAdd == 1',12270,'Add and attach a new service',16,'cust_sa_add.ews',NULL,'custsachildadd',NULL,'cust_sa_add.ews?ParentAccountID=$floop.AccountID&FilterAccountID=$Variables.FilterAccountID','Attach a new service',398,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowPromoCodes == 1',12271,'Enter promo code',17,'cust_promo.ews',NULL,'custpromo',NULL,'cust_promo.ews','Enter promo code',399,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Customer.AllowSendMethod == 1',12272,'Bill delivery options',8,'cust_sendmethod.ews',NULL,'custsendmethod',NULL,'cust_sendmethod.ews','Update Send Method',400,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'API Actions',13,'APIActions-list.ews',NULL,'apiactions',NULL,'APIActions-list.ews?MGID=$Variables.MGID','API Actions',401,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12273,'SA List',NULL,'sa_list_f.ews',NULL,'salist',NULL,'sa_list_f.ews','SA List',402,'shs_show_Services','SubAccounts')}
go
{CALL CT_MenuItems('add',NULL,NULL,NULL,NULL,12274,'New Child Service',NULL,'sa_add.ews',NULL,'newchildservice',NULL,'sa_add.ews?CustomerID=$FindCustomerID.CustomerID&ParentAccountID=$Variables.AccountID','New Child Service',403,'sa_mnu_NewChildService','SubAccounts')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'API Info',34,'api_info.ews',NULL,'apiinfo',NULL,'api_info.ews?MGID=$Variables.MGID','API Info',404,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'API Profiles',34,'APIProfiles-list.ews',NULL,'apiprofiles',NULL,'APIProfiles-list.ews?MGID=$Variables.MGID','API Profiles',405,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$floop.AllowCustReopen == 1',12275,'Reactivate this service',8,'cust_sa_open.ews',NULL,'custsaopen',NULL,'cust_sa_open.ews?AccountID=$floop.AccountID&FilterAccountID=$Variables.FilterAccountID','Reactivate this service',406,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Search Queries',13,'SearchQueries-list.ews',NULL,'searchqueries',NULL,'SearchQueries-list.ews?MGID=$Variables.MGID','Search Queries',407,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Monitoring',NULL,'Monitors-list.ews',NULL,'monitors',NULL,'Monitors-list.ews?MGID=$Variables.MGID','Service Monitoring',408,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Filters',NULL,'MonFilters-list.ews',NULL,'monfilters',NULL,'MonFilters-list.ews?MGID=$Variables.MGID','Service Filters',409,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12276,'Promo Codes',17,'mbr_promo.ews',NULL,'mbrpromo',NULL,'mbr_promo.ews?CustomerID=$Variables.CustomerID','Promo Codes',410,'ma_mnu_PromoCodes',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'SNMP Profiles',NULL,'MonProfiles-list.ews',NULL,'monprofiles',NULL,'MonProfiles-list.ews?MGID=$Variables.MGID','SNMP Profiles',411,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Billing Imports',8,'BillingImports-list.ews',NULL,'billingimports',NULL,'BillingImports-list.ews?MGID=$Variables.MGID','Billing Imports',412,NULL,NULL)}
go
{CALL CT_MenuItems(NULL,NULL,NULL,NULL,'$InvoiceSec.Estimate == 1',10137,'Preview',8,'mbr_invoice_preview.ews',NULL,'investpreview',NULL,'mbr_invoice_preview.ews?CustomerID=$Variables.CustomerID&InvoiceID=$Variables.InvoiceID&forcenext=1#ltop','Preview',413,'mai_mnu_Preview',NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Service Tags',NULL,'ServiceLevelTypes-list.ews',NULL,'serviceleveltypes',NULL,'ServiceLevelTypes-list.ews?MGID=$Variables.MGID','Service Tags',414,NULL,'ServiceLevelTypes')}
go
{CALL CT_MenuItems('read','C',NULL,NULL,NULL,12277,'My Carts',31,'inv_cart.ews',NULL,'invcart',NULL,'inv_cart.ews','My Carts',415,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Warehouse Groups',31,'InvWarehouseGroups-list.ews',NULL,'invwarehousegroups',NULL,'InvWarehouseGroups-list.ews?MGID=$Variables.MGID','Warehouse Groups',416,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,12278,'Calendars',33,'pref_cals.ews',NULL,'prefcals',NULL,'pref_cals.ews#ltop','Calendars',417,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Attributes',31,'IPAttributes-list.ews',NULL,'ipattrs',NULL,'IPAttributes-list.ews?MGID=$Variables.MGID','IP Attributes',418,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Groups',31,'IPGroups-list.ews',NULL,'ipgroups',NULL,'IPGroups-list.ews?MGID=$Variables.MGID','IP Groups',419,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'IP Inventory Allocations',31,'IPInvAllocations-list.ews',NULL,'ipinvalloc',NULL,'IPInvAllocations-list.ews?MGID=$Variables.MGID','IP Inventory Allocations',420,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Dynamic Addressing',31,'RadPoolConfigs-list.ews',NULL,'radpoolconfigs',NULL,'RadPoolConfigs-list.ews?MGID=$Variables.MGID','Dynamic Addressing',421,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,'$Variables.InvoiceID ==',12291,'Preview Current',8,'mbr_invoice_preview.ews',NULL,'invcurpreview',NULL,'mbr_invoice_preview.ews?CustomerID=$Variables.CustomerID&forcenext=0#ltop','Preview Current',422,'mai_mnu_PreviewCurrent',NULL)}
go
{CALL CT_MenuItems('read','A',NULL,NULL,NULL,12292,'Appointments',33,'appts_assign.ews',NULL,'apptmgr',NULL,'appts_assign.ews#ltop','Appointments',423,NULL,NULL)}
go
{CALL CT_MenuItems('modify',NULL,NULL,NULL,NULL,12608,'Move Services',NULL,'mbr_move.ews',NULL,'mbrmove',NULL,'mbr_move.ews?CustomerID=$Variables.CustomerID#ltop','Move Services',424,'ma_mnu_Move','SubAccounts')}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Canned Messages',12,'BulkMessages-list.ews',NULL,'bulkmessages',NULL,'BulkMessages-list.ews?MGID=$Variables.MGID','Canned Messages',425,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Certificates',NULL,'Certs-list.ews',NULL,'certs',NULL,'Certs-list.ews?MGID=$Variables.MGID','Certificates',426,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Flow Filters',NULL,'FlowFilters-list.ews',NULL,'flowfilters',NULL,'FlowFilters-list.ews?MGID=$Variables.MGID','Flow Filters',427,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sync / Export',NULL,'Syncs-list.ews',NULL,'qsync',NULL,'Syncs-list.ews?MGID=$Variables.MGID','Sync / Export',428,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Sync Templates',NULL,'SyncExamples-list.ews',NULL,'qsyncexamples',NULL,'SyncExamples-list.ews?MGID=$Variables.MGID','Sync Templates',429,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Search Fields',13,'SearchFields-list.ews',NULL,'searchfields',NULL,'SearchFields-list.ews?MGID=$Variables.MGID','Search Fields',430,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Performance Stats',NULL,'db_perfstat.ews',NULL,'dbperfstat',NULL,'db_perfstat.ews?MGID=$Variables.MGID','Performance Stats',431,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'PII Retention',NULL,'PIIRetentions-list.ews',NULL,'piiretention',NULL,'PIIRetentions-list.ews?MGID=$Variables.MGID','PII Retention',432,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'FCC - Broadband Labels',NULL,'RegFCCBLAccountTypes-edit.ews',NULL,'fccbl',NULL,'RegFCCBLAccountTypes-edit.ews?MGID=$Variables.MGID','FCC - Broadband Labels',433,NULL,NULL)}
go
{CALL CT_MenuItems(NULL,NULL,NULL,NULL,'$floop.AllowFCCBLShow == 1',12667,'View broadband label',16,'cust_fccbl.ews',NULL,'custfccbl',NULL,'cust_fccbl.ews?AccountID=$floop.AccountID','View broadband label',434,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Import Parsers',NULL,'import_test.ews',NULL,'importtest',NULL,'import_test.ews?MGID=$Variables.MGID','Import Parsers',435,NULL,NULL)}
go
{CALL CT_MenuItems('read',NULL,NULL,NULL,NULL,NULL,'Region Groups',NULL,'RegionGroups-List.ews',NULL,'regiongroups',NULL,'RegionGroups-List.ews?MGID=$Variables.MGID','Region Groups',436,NULL,NULL)}
go
{CALL CT_Menus('menu_main','Main client menu set','main',1)}
go
{CALL CT_Menus('menu_mbr','MBR Menu Set','mbr',2)}
go
{CALL CT_Menus('menu_sa','SA Menu Set','sa',3)}
go
{CALL CT_Menus('menu_search','Search Menu set','search',4)}
go
{CALL CT_Menus('menu_report','Report Menu Set','report',5)}
go
{CALL CT_Menus('menu_statement','Statement Menu Set','statement',6)}
go
{CALL CT_Menus('menu_invoice','Invoice Menu Set','invoice',7)}
go
{CALL CT_Menus('menu_cust','Main Customer Menu Set','cust',8)}
go
{CALL CT_Menus('menu_pref','Operator Preferences Menu','pref',9)}
go
{CALL CT_Menus('menu_history','History Menu Set','history',10)}
go
{CALL CT_Menus('menu_incident','Incident Menu Set','incident',11)}
go
{CALL CT_Menus('menu_sa_detail','SA Detail Set','sadetail',12)}
go
{CALL CT_Menus('menu_mbr_detail','MBR Detail Set','madetail',13)}
go
{CALL CT_Menus('menu_admin','Admin Menu Set','admin',14)}
go
{CALL CT_Menus('menu_adminsub','Admin General Menu','ageneral',15)}
go
{CALL CT_Menus('menu_adminsub','Admin Sales Menu','asales',16)}
go
{CALL CT_Menus('menu_adminsub','Admin Services Menu','aservices',17)}
go
{CALL CT_Menus('menu_adminsub','Admin Reports Menu','areports',18)}
go
{CALL CT_Menus('menu_adminsub','Admin Incidents Menu','aincidents',19)}
go
{CALL CT_Menus('menu_adminsub','Admin Accounting Menu','aaccounting',20)}
go
{CALL CT_Menus('menu_adminsub','Admin RADIUS Menu','aradius',21)}
go
{CALL CT_Menus('menu_adminsub','Admin Scheduler Menu','atasks',22)}
go
{CALL CT_Menus('menu_adminsub','Admin Web Menu','aweb',23)}
go
{CALL CT_Menus('menu_adminsub','Admin Security Menu','asecurity',26)}
go
{CALL CT_Menus('menu_log',' Log Menu Set','log',27)}
go
{CALL CT_Menus('menu_adminsub','Admin Advanced Menu','aadvanced',28)}
go
{CALL CT_Menus('menu_adminsub','Admin Database Menu','adatabase',29)}
go
{CALL CT_Menus('menu_adminsub','Admin Rating Menu','arating',30)}
go
{CALL CT_Menus('menu_adminopt','Admin Option Menu Set','adminopt',31)}
go
{CALL CT_Menus('menu_mainopt','Main client option  menu set','mainopt',32)}
go
{CALL CT_Menus('menu_adminsub','Admin Resellers Menu','aresellers',33)}
go
{CALL CT_Menus('menu_billing','Billing Menu','billing',34)}
go
{CALL CT_Menus('menu_support','Support menu set','support',35)}
go
{CALL CT_Menus('menu_adminsub','Admin Prepaid Accounts','aprepaid',36)}
go
{CALL CT_Menus('menu_custset','Customer Settings','custset',37)}
go
{CALL CT_Menus('menu_custsaset','Customer SA  Update Options','custsaset',38)}
go
{CALL CT_Menus('menu_adminsub','Admin Messaging Menu','amsg',39)}
go
{CALL CT_Menus('menu_adminsub','Admin Compliance Menu','acomply',40)}
go
{CALL CT_Menus('menu_adminsub','Admin Geography Menu','ageo',41)}
go
{CALL CT_Menus('menu_adminsub','Admin Sites Menu','asites',42)}
go
{CALL CT_Menus('menu_adminsub','Admin Inventory Menu','ainv',43)}
go
{CALL CT_Menus('menu_inv','Inventory Menu Set','inv',44)}
go
{CALL CT_Menus('menu_mareport','MBR Reports Menu Set','mareport',45)}
go
{CALL CT_Menus('menu_payment','Payment Menu Set','payment',46)}
go
{CALL CT_Menus('menu_sareport','Service Reports Menu Set','sareport',47)}
go
{CALL CT_Menus('menu_file','File Menu Set','file',48)}
go
{CALL CT_Menus('menu_timeline','MBR Timeline','matimeline',49)}
go
{CALL CT_Menus('menu_timeline','SA Timeline','satimeline',50)}
go
{CALL CT_MenuSets(1,1,100)}
go
{CALL CT_MenuSets(1,2,200)}
go
{CALL CT_MenuSets(1,7,500)}
go
{CALL CT_MenuSets(1,57,1000)}
go
{CALL CT_MenuSets(1,202,300)}
go
{CALL CT_MenuSets(1,204,400)}
go
{CALL CT_MenuSets(1,344,600)}
go
{CALL CT_MenuSets(2,14,100)}
go
{CALL CT_MenuSets(2,15,200)}
go
{CALL CT_MenuSets(2,16,300)}
go
{CALL CT_MenuSets(2,17,400)}
go
{CALL CT_MenuSets(2,18,500)}
go
{CALL CT_MenuSets(2,20,700)}
go
{CALL CT_MenuSets(2,21,800)}
go
{CALL CT_MenuSets(2,22,900)}
go
{CALL CT_MenuSets(2,24,1000)}
go
{CALL CT_MenuSets(2,26,1200)}
go
{CALL CT_MenuSets(2,27,1100)}
go
{CALL CT_MenuSets(2,29,1500)}
go
{CALL CT_MenuSets(2,30,1600)}
go
{CALL CT_MenuSets(2,31,1700)}
go
{CALL CT_MenuSets(2,345,600)}
go
{CALL CT_MenuSets(2,355,650)}
go
{CALL CT_MenuSets(2,358,1300)}
go
{CALL CT_MenuSets(2,376,950)}
go
{CALL CT_MenuSets(2,386,1400)}
go
{CALL CT_MenuSets(2,410,675)}
go
{CALL CT_MenuSets(2,424,1050)}
go
{CALL CT_MenuSets(3,32,100)}
go
{CALL CT_MenuSets(3,33,200)}
go
{CALL CT_MenuSets(3,34,400)}
go
{CALL CT_MenuSets(3,35,300)}
go
{CALL CT_MenuSets(3,36,1400)}
go
{CALL CT_MenuSets(3,39,600)}
go
{CALL CT_MenuSets(3,40,500)}
go
{CALL CT_MenuSets(3,41,1100)}
go
{CALL CT_MenuSets(3,42,1200)}
go
{CALL CT_MenuSets(3,43,1300)}
go
{CALL CT_MenuSets(3,44,1300)}
go
{CALL CT_MenuSets(3,351,800)}
go
{CALL CT_MenuSets(3,356,700)}
go
{CALL CT_MenuSets(3,370,650)}
go
{CALL CT_MenuSets(3,372,675)}
go
{CALL CT_MenuSets(3,373,687)}
go
{CALL CT_MenuSets(3,378,750)}
go
{CALL CT_MenuSets(3,387,1250)}
go
{CALL CT_MenuSets(3,403,450)}
go
{CALL CT_MenuSets(4,3,800)}
go
{CALL CT_MenuSets(4,5,900)}
go
{CALL CT_MenuSets(4,8,100)}
go
{CALL CT_MenuSets(4,9,200)}
go
{CALL CT_MenuSets(4,10,300)}
go
{CALL CT_MenuSets(4,11,400)}
go
{CALL CT_MenuSets(4,12,600)}
go
{CALL CT_MenuSets(4,13,700)}
go
{CALL CT_MenuSets(4,269,500)}
go
{CALL CT_MenuSets(4,363,1000)}
go
{CALL CT_MenuSets(5,146,15)}
go
{CALL CT_MenuSets(5,150,10)}
go
{CALL CT_MenuSets(5,153,20)}
go
{CALL CT_MenuSets(5,227,5)}
go
{CALL CT_MenuSets(6,52,200)}
go
{CALL CT_MenuSets(6,53,300)}
go
{CALL CT_MenuSets(6,54,400)}
go
{CALL CT_MenuSets(6,55,500)}
go
{CALL CT_MenuSets(6,360,100)}
go
{CALL CT_MenuSets(7,45,200)}
go
{CALL CT_MenuSets(7,46,300)}
go
{CALL CT_MenuSets(7,47,400)}
go
{CALL CT_MenuSets(7,48,500)}
go
{CALL CT_MenuSets(7,49,600)}
go
{CALL CT_MenuSets(7,50,700)}
go
{CALL CT_MenuSets(7,51,800)}
go
{CALL CT_MenuSets(7,250,1200)}
go
{CALL CT_MenuSets(7,359,100)}
go
{CALL CT_MenuSets(7,382,1300)}
go
{CALL CT_MenuSets(7,383,800)}
go
{CALL CT_MenuSets(7,384,750)}
go
{CALL CT_MenuSets(7,385,1100)}
go
{CALL CT_MenuSets(7,413,725)}
go
{CALL CT_MenuSets(7,422,250)}
go
{CALL CT_MenuSets(8,231,100)}
go
{CALL CT_MenuSets(8,232,800)}
go
{CALL CT_MenuSets(8,233,200)}
go
{CALL CT_MenuSets(8,234,400)}
go
{CALL CT_MenuSets(8,236,700)}
go
{CALL CT_MenuSets(8,238,300)}
go
{CALL CT_MenuSets(8,239,900)}
go
{CALL CT_MenuSets(8,265,600)}
go
{CALL CT_MenuSets(9,338,100)}
go
{CALL CT_MenuSets(9,339,500)}
go
{CALL CT_MenuSets(9,340,300)}
go
{CALL CT_MenuSets(9,341,200)}
go
{CALL CT_MenuSets(9,342,400)}
go
{CALL CT_MenuSets(9,417,600)}
go
{CALL CT_MenuSets(11,61,61)}
go
{CALL CT_MenuSets(12,63,200)}
go
{CALL CT_MenuSets(12,64,300)}
go
{CALL CT_MenuSets(12,65,400)}
go
{CALL CT_MenuSets(12,357,100)}
go
{CALL CT_MenuSets(12,374,150)}
go
{CALL CT_MenuSets(12,380,500)}
go
{CALL CT_MenuSets(12,402,50)}
go
{CALL CT_MenuSets(13,67,100)}
go
{CALL CT_MenuSets(13,70,300)}
go
{CALL CT_MenuSets(13,73,600)}
go
{CALL CT_MenuSets(13,354,200)}
go
{CALL CT_MenuSets(13,375,400)}
go
{CALL CT_MenuSets(13,379,500)}
go
{CALL CT_MenuSets(14,74,100)}
go
{CALL CT_MenuSets(14,75,200)}
go
{CALL CT_MenuSets(14,76,300)}
go
{CALL CT_MenuSets(14,77,400)}
go
{CALL CT_MenuSets(14,78,500)}
go
{CALL CT_MenuSets(14,80,600)}
go
{CALL CT_MenuSets(14,81,700)}
go
{CALL CT_MenuSets(14,82,800)}
go
{CALL CT_MenuSets(14,83,900)}
go
{CALL CT_MenuSets(14,84,1000)}
go
{CALL CT_MenuSets(14,85,1100)}
go
{CALL CT_MenuSets(14,86,1200)}
go
{CALL CT_MenuSets(14,87,1300)}
go
{CALL CT_MenuSets(14,88,1400)}
go
{CALL CT_MenuSets(14,119,600)}
go
{CALL CT_MenuSets(14,279,350)}
go
{CALL CT_MenuSets(14,280,1250)}
go
{CALL CT_MenuSets(14,282,150)}
go
{CALL CT_MenuSets(14,283,950)}
go
{CALL CT_MenuSets(14,284,170)}
go
{CALL CT_MenuSets(15,91,100)}
go
{CALL CT_MenuSets(15,92,200)}
go
{CALL CT_MenuSets(15,93,400)}
go
{CALL CT_MenuSets(15,188,250)}
go
{CALL CT_MenuSets(15,211,300)}
go
{CALL CT_MenuSets(15,270,600)}
go
{CALL CT_MenuSets(15,287,150)}
go
{CALL CT_MenuSets(15,305,700)}
go
{CALL CT_MenuSets(15,325,900)}
go
{CALL CT_MenuSets(15,326,800)}
go
{CALL CT_MenuSets(15,348,1000)}
go
{CALL CT_MenuSets(16,98,100)}
go
{CALL CT_MenuSets(16,99,200)}
go
{CALL CT_MenuSets(16,100,300)}
go
{CALL CT_MenuSets(16,114,500)}
go
{CALL CT_MenuSets(16,258,400)}
go
{CALL CT_MenuSets(16,296,700)}
go
{CALL CT_MenuSets(16,297,600)}
go
{CALL CT_MenuSets(16,298,800)}
go
{CALL CT_MenuSets(16,299,350)}
go
{CALL CT_MenuSets(16,301,450)}
go
{CALL CT_MenuSets(17,101,100)}
go
{CALL CT_MenuSets(17,102,200)}
go
{CALL CT_MenuSets(17,103,300)}
go
{CALL CT_MenuSets(17,285,400)}
go
{CALL CT_MenuSets(17,286,500)}
go
{CALL CT_MenuSets(17,348,600)}
go
{CALL CT_MenuSets(17,414,700)}
go
{CALL CT_MenuSets(18,104,200)}
go
{CALL CT_MenuSets(18,105,100)}
go
{CALL CT_MenuSets(18,106,400)}
go
{CALL CT_MenuSets(18,259,300)}
go
{CALL CT_MenuSets(18,315,500)}
go
{CALL CT_MenuSets(18,316,600)}
go
{CALL CT_MenuSets(18,317,700)}
go
{CALL CT_MenuSets(18,318,900)}
go
{CALL CT_MenuSets(18,319,1000)}
go
{CALL CT_MenuSets(18,320,800)}
go
{CALL CT_MenuSets(18,321,1100)}
go
{CALL CT_MenuSets(18,408,1200)}
go
{CALL CT_MenuSets(18,409,1300)}
go
{CALL CT_MenuSets(18,411,1400)}
go
{CALL CT_MenuSets(18,427,1500)}
go
{CALL CT_MenuSets(19,108,100)}
go
{CALL CT_MenuSets(19,171,500)}
go
{CALL CT_MenuSets(19,172,400)}
go
{CALL CT_MenuSets(19,173,300)}
go
{CALL CT_MenuSets(19,306,600)}
go
{CALL CT_MenuSets(19,307,700)}
go
{CALL CT_MenuSets(19,308,800)}
go
{CALL CT_MenuSets(20,110,100)}
go
{CALL CT_MenuSets(20,111,200)}
go
{CALL CT_MenuSets(20,112,300)}
go
{CALL CT_MenuSets(20,113,500)}
go
{CALL CT_MenuSets(20,115,900)}
go
{CALL CT_MenuSets(20,117,1000)}
go
{CALL CT_MenuSets(20,118,1100)}
go
{CALL CT_MenuSets(20,187,400)}
go
{CALL CT_MenuSets(20,194,1200)}
go
{CALL CT_MenuSets(20,200,700)}
go
{CALL CT_MenuSets(20,222,1300)}
go
{CALL CT_MenuSets(20,226,1400)}
go
{CALL CT_MenuSets(20,263,1500)}
go
{CALL CT_MenuSets(20,268,800)}
go
{CALL CT_MenuSets(20,334,600)}
go
{CALL CT_MenuSets(20,371,1600)}
go
{CALL CT_MenuSets(21,120,120)}
go
{CALL CT_MenuSets(21,124,124)}
go
{CALL CT_MenuSets(21,125,125)}
go
{CALL CT_MenuSets(21,126,126)}
go
{CALL CT_MenuSets(21,128,128)}
go
{CALL CT_MenuSets(21,130,130)}
go
{CALL CT_MenuSets(21,131,131)}
go
{CALL CT_MenuSets(21,242,140)}
go
{CALL CT_MenuSets(21,243,150)}
go
{CALL CT_MenuSets(21,262,160)}
go
{CALL CT_MenuSets(21,267,127)}
go
{CALL CT_MenuSets(21,421,135)}
go
{CALL CT_MenuSets(22,132,132)}
go
{CALL CT_MenuSets(22,133,133)}
go
{CALL CT_MenuSets(22,134,134)}
go
{CALL CT_MenuSets(23,135,175)}
go
{CALL CT_MenuSets(23,142,142)}
go
{CALL CT_MenuSets(23,143,144)}
go
{CALL CT_MenuSets(23,176,176)}
go
{CALL CT_MenuSets(23,183,174)}
go
{CALL CT_MenuSets(23,212,175)}
go
{CALL CT_MenuSets(23,221,141)}
go
{CALL CT_MenuSets(23,230,143)}
go
{CALL CT_MenuSets(23,247,200)}
go
{CALL CT_MenuSets(23,256,210)}
go
{CALL CT_MenuSets(23,277,220)}
go
{CALL CT_MenuSets(23,393,230)}
go
{CALL CT_MenuSets(23,404,270)}
go
{CALL CT_MenuSets(23,405,250)}
go
{CALL CT_MenuSets(26,144,100)}
go
{CALL CT_MenuSets(26,145,200)}
go
{CALL CT_MenuSets(26,160,400)}
go
{CALL CT_MenuSets(26,161,500)}
go
{CALL CT_MenuSets(26,220,300)}
go
{CALL CT_MenuSets(26,261,600)}
go
{CALL CT_MenuSets(26,276,800)}
go
{CALL CT_MenuSets(26,303,700)}
go
{CALL CT_MenuSets(26,327,350)}
go
{CALL CT_MenuSets(26,426,900)}
go
{CALL CT_MenuSets(27,155,2)}
go
{CALL CT_MenuSets(27,156,6)}
go
{CALL CT_MenuSets(27,157,5)}
go
{CALL CT_MenuSets(27,159,3)}
go
{CALL CT_MenuSets(27,274,7)}
go
{CALL CT_MenuSets(27,275,8)}
go
{CALL CT_MenuSets(28,127,1500)}
go
{CALL CT_MenuSets(28,149,1000)}
go
{CALL CT_MenuSets(28,162,100)}
go
{CALL CT_MenuSets(28,163,200)}
go
{CALL CT_MenuSets(28,164,300)}
go
{CALL CT_MenuSets(28,165,400)}
go
{CALL CT_MenuSets(28,166,500)}
go
{CALL CT_MenuSets(28,169,600)}
go
{CALL CT_MenuSets(28,175,700)}
go
{CALL CT_MenuSets(28,178,900)}
go
{CALL CT_MenuSets(28,179,900)}
go
{CALL CT_MenuSets(28,182,800)}
go
{CALL CT_MenuSets(28,185,800)}
go
{CALL CT_MenuSets(28,196,1100)}
go
{CALL CT_MenuSets(28,201,1300)}
go
{CALL CT_MenuSets(28,257,1400)}
go
{CALL CT_MenuSets(28,271,1600)}
go
{CALL CT_MenuSets(28,272,1700)}
go
{CALL CT_MenuSets(28,293,1800)}
go
{CALL CT_MenuSets(28,302,1900)}
go
{CALL CT_MenuSets(28,304,2000)}
go
{CALL CT_MenuSets(28,323,2100)}
go
{CALL CT_MenuSets(28,324,2200)}
go
{CALL CT_MenuSets(28,337,2300)}
go
{CALL CT_MenuSets(28,347,850)}
go
{CALL CT_MenuSets(28,401,1050)}
go
{CALL CT_MenuSets(28,407,2400)}
go
{CALL CT_MenuSets(28,412,2500)}
go
{CALL CT_MenuSets(28,429,2600)}
go
{CALL CT_MenuSets(28,430,2350)}
go
{CALL CT_MenuSets(28,435,875)}
go
{CALL CT_MenuSets(29,167,100)}
go
{CALL CT_MenuSets(29,168,200)}
go
{CALL CT_MenuSets(29,266,500)}
go
{CALL CT_MenuSets(29,273,300)}
go
{CALL CT_MenuSets(29,300,400)}
go
{CALL CT_MenuSets(29,428,600)}
go
{CALL CT_MenuSets(29,431,350)}
go
{CALL CT_MenuSets(30,170,170)}
go
{CALL CT_MenuSets(30,174,171)}
go
{CALL CT_MenuSets(30,180,160)}
go
{CALL CT_MenuSets(30,181,165)}
go
{CALL CT_MenuSets(30,184,184)}
go
{CALL CT_MenuSets(30,260,200)}
go
{CALL CT_MenuSets(31,59,100)}
go
{CALL CT_MenuSets(31,89,95)}
go
{CALL CT_MenuSets(31,90,90)}
go
{CALL CT_MenuSets(32,58,58)}
go
{CALL CT_MenuSets(32,59,59)}
go
{CALL CT_MenuSets(33,92,11)}
go
{CALL CT_MenuSets(33,188,10)}
go
{CALL CT_MenuSets(33,189,12)}
go
{CALL CT_MenuSets(34,203,4)}
go
{CALL CT_MenuSets(34,205,5)}
go
{CALL CT_MenuSets(34,206,6)}
go
{CALL CT_MenuSets(34,208,10)}
go
{CALL CT_MenuSets(34,209,11)}
go
{CALL CT_MenuSets(34,210,12)}
go
{CALL CT_MenuSets(34,214,19)}
go
{CALL CT_MenuSets(35,4,100)}
go
{CALL CT_MenuSets(35,213,300)}
go
{CALL CT_MenuSets(35,346,200)}
go
{CALL CT_MenuSets(35,423,400)}
go
{CALL CT_MenuSets(36,223,100)}
go
{CALL CT_MenuSets(36,224,110)}
go
{CALL CT_MenuSets(36,225,120)}
go
{CALL CT_MenuSets(36,251,200)}
go
{CALL CT_MenuSets(36,252,210)}
go
{CALL CT_MenuSets(36,278,220)}
go
{CALL CT_MenuSets(37,240,300)}
go
{CALL CT_MenuSets(37,241,100)}
go
{CALL CT_MenuSets(37,255,1000)}
go
{CALL CT_MenuSets(37,395,200)}
go
{CALL CT_MenuSets(37,397,400)}
go
{CALL CT_MenuSets(37,399,500)}
go
{CALL CT_MenuSets(37,400,150)}
go
{CALL CT_MenuSets(38,244,100)}
go
{CALL CT_MenuSets(38,245,200)}
go
{CALL CT_MenuSets(38,246,1000)}
go
{CALL CT_MenuSets(38,396,300)}
go
{CALL CT_MenuSets(38,398,400)}
go
{CALL CT_MenuSets(38,406,500)}
go
{CALL CT_MenuSets(38,434,600)}
go
{CALL CT_MenuSets(39,95,100)}
go
{CALL CT_MenuSets(39,195,400)}
go
{CALL CT_MenuSets(39,292,200)}
go
{CALL CT_MenuSets(39,294,300)}
go
{CALL CT_MenuSets(39,295,500)}
go
{CALL CT_MenuSets(39,343,600)}
go
{CALL CT_MenuSets(39,348,700)}
go
{CALL CT_MenuSets(39,425,800)}
go
{CALL CT_MenuSets(40,281,100)}
go
{CALL CT_MenuSets(40,331,300)}
go
{CALL CT_MenuSets(40,332,400)}
go
{CALL CT_MenuSets(40,333,150)}
go
{CALL CT_MenuSets(40,353,50)}
go
{CALL CT_MenuSets(40,432,70)}
go
{CALL CT_MenuSets(40,433,125)}
go
{CALL CT_MenuSets(41,94,100)}
go
{CALL CT_MenuSets(41,97,50)}
go
{CALL CT_MenuSets(41,190,400)}
go
{CALL CT_MenuSets(41,191,500)}
go
{CALL CT_MenuSets(41,322,200)}
go
{CALL CT_MenuSets(41,328,300)}
go
{CALL CT_MenuSets(41,329,70)}
go
{CALL CT_MenuSets(41,335,350)}
go
{CALL CT_MenuSets(41,336,150)}
go
{CALL CT_MenuSets(41,436,125)}
go
{CALL CT_MenuSets(42,287,100)}
go
{CALL CT_MenuSets(42,288,200)}
go
{CALL CT_MenuSets(42,289,400)}
go
{CALL CT_MenuSets(42,290,300)}
go
{CALL CT_MenuSets(42,291,600)}
go
{CALL CT_MenuSets(43,309,100)}
go
{CALL CT_MenuSets(43,310,400)}
go
{CALL CT_MenuSets(43,311,300)}
go
{CALL CT_MenuSets(43,312,500)}
go
{CALL CT_MenuSets(43,313,600)}
go
{CALL CT_MenuSets(43,314,200)}
go
{CALL CT_MenuSets(43,416,150)}
go
{CALL CT_MenuSets(43,418,900)}
go
{CALL CT_MenuSets(43,419,700)}
go
{CALL CT_MenuSets(43,420,800)}
go
{CALL CT_MenuSets(44,349,200)}
go
{CALL CT_MenuSets(44,350,100)}
go
{CALL CT_MenuSets(44,415,300)}
go
{CALL CT_MenuSets(45,25,300)}
go
{CALL CT_MenuSets(45,28,200)}
go
{CALL CT_MenuSets(46,361,100)}
go
{CALL CT_MenuSets(46,362,300)}
go
{CALL CT_MenuSets(46,364,400)}
go
{CALL CT_MenuSets(46,365,500)}
go
{CALL CT_MenuSets(46,366,600)}
go
{CALL CT_MenuSets(46,367,200)}
go
{CALL CT_MenuSets(46,368,700)}
go
{CALL CT_MenuSets(46,369,800)}
go
{CALL CT_MenuSets(46,381,900)}
go
{CALL CT_MenuSets(46,394,250)}
go
{CALL CT_MenuSets(47,37,100)}
go
{CALL CT_MenuSets(47,352,200)}
go
{CALL CT_MenuSets(48,377,100)}
go
{CALL CT_MenuSets(49,385,300)}
go
{CALL CT_MenuSets(49,388,100)}
go
{CALL CT_MenuSets(49,389,200)}
go
{CALL CT_MenuSets(50,385,400)}
go
{CALL CT_MenuSets(50,390,100)}
go
{CALL CT_MenuSets(50,391,200)}
go
{CALL CT_MenuSets(50,392,300)}
go
{CALL CT_MetaRules('Credit Card',1)}
go
{CALL CT_MetaRules('Password',2)}
go
{CALL CT_MetaRules('Unique Login',3)}
go
{CALL CT_MetaRules('IP Address',4)}
go
{CALL CT_MetaRules('Bit Field',5)}
go
{CALL CT_MetaRules('Email Address',6)}
go
{CALL CT_MetaRules('Date/Time',7)}
go
{CALL CT_MetaRules('DNS Address',8)}
go
{CALL CT_MetaRules('Numeric',10)}
go
{CALL CT_MetaRules('Secure Data',11)}
go
{CALL CT_MetaRules('Low ASCII',12)}
go
{CALL CT_MetaRules('Domain Name',13)}
go
{CALL CT_MetaRules('Binary Data',14)}
go
{CALL CT_MetaRules('Ref /w GroupID',20)}
go
{CALL CT_MetaRules('Ref /w Service GroupID',21)}
go
{CALL CT_MetaRules('Time Range',22)}
go
{CALL CT_MetaRules('IP Prefix',23)}
go
{CALL CT_MetaRules('Meters',24)}
go
{CALL CT_MetaRules('Kilometers',25)}
go
{CALL CT_MetaRules('Kilograms',26)}
go
{CALL CT_MetaRules('Centimeters',27)}
go
{CALL CT_MetaRules('Regular Expression',28)}
go
{CALL CT_MetaRules('Password (Any Strength)',29)}
go
{CALL CT_MetaRules('SNMP OID',30)}
go
{CALL CT_MetaRules('Small Integer',31)}
go
{CALL CT_MetaTables(1,1,'Access Labels',NULL,NULL,0,'AccessLabels')}
go
{CALL CT_MetaTables(1,1,'Account Changes',NULL,NULL,0,'AccountChanges')}
go
{CALL CT_MetaTables(1,1,'Account Data Types',NULL,NULL,0,'AccountDataTypes')}
go
{CALL CT_MetaTables(1,0,'Account Data Values',NULL,NULL,0,'AccountDataValues')}
go
{CALL CT_MetaTables(1,1,'Account Tag Times',NULL,NULL,0,'AccountTagTimes')}
go
{CALL CT_MetaTables(1,1,'Account Templates',NULL,NULL,0,'AccountTemplates')}
go
{CALL CT_MetaTables(1,1,'Account Types',NULL,NULL,0,'AccountTypes')}
go
{CALL CT_MetaTables(1,0,'Account Type Templates',NULL,NULL,0,'AccountTypeTemplates')}
go
{CALL CT_MetaTables(1,1,'Actions','Incidents',NULL,0,'Actions')}
go
{CALL CT_MetaTables(1,0,'Address Data',NULL,'AddressDataTypes',0,'AddressData')}
go
{CALL CT_MetaTables(1,1,'Address Data Types',NULL,NULL,0,'AddressDataTypes')}
go
{CALL CT_MetaTables(1,1,'Addresses',NULL,NULL,0,'Addresses')}
go
{CALL CT_MetaTables(1,1,'Address Geo Sources',NULL,NULL,0,'AddressGeoSources')}
go
{CALL CT_MetaTables(1,1,'Address Type Data Types',NULL,NULL,0,'AddressTypeDataTypes')}
go
{CALL CT_MetaTables(1,1,'Address Types',NULL,NULL,0,'AddressTypes')}
go
{CALL CT_MetaTables(1,1,'Alert Sources',NULL,NULL,0,'AlertSources')}
go
{CALL CT_MetaTables(1,1,'Alert Source Types',NULL,NULL,0,'AlertSourceTypes')}
go
{CALL CT_MetaTables(1,1,'Alert Types',NULL,NULL,0,'AlertTypes')}
go
{CALL CT_MetaTables(1,1,'Aliases','SubAccounts',NULL,0,'Aliases')}
go
{CALL CT_MetaTables(1,1,'Allowed Hosts',NULL,NULL,0,'AllowedHosts')}
go
{CALL CT_MetaTables(1,1,'APIActions',NULL,NULL,0,'APIActions')}
go
{CALL CT_MetaTables(1,1,'APIFields',NULL,NULL,0,'APIFields')}
go
{CALL CT_MetaTables(1,0,'APIProfile Items',NULL,NULL,0,'APIProfileItems')}
go
{CALL CT_MetaTables(1,1,'APIProfiles',NULL,NULL,0,'APIProfiles')}
go
{CALL CT_MetaTables(1,0,'APIStep Columns',NULL,NULL,0,'APIStepColumns')}
go
{CALL CT_MetaTables(1,1,'APISteps',NULL,NULL,0,'APISteps')}
go
{CALL CT_MetaTables(1,1,'Applications',NULL,NULL,0,'Applications')}
go
{CALL CT_MetaTables(1,0,'Audit Logs',NULL,NULL,0,'AuditLogs')}
go
{CALL CT_MetaTables(1,1,'Bank Trans','MasterAccounts',NULL,0,'BankTrans')}
go
{CALL CT_MetaTables(1,1,'Batches',NULL,NULL,0,'Batches')}
go
{CALL CT_MetaTables(1,1,'Batch Processors',NULL,NULL,0,'BatchProcessors')}
go
{CALL CT_MetaTables(1,1,'Billing Cycles',NULL,NULL,0,'BillingCycles')}
go
{CALL CT_MetaTables(1,1,'Billing Imports',NULL,NULL,0,'BillingImports')}
go
{CALL CT_MetaTables(1,1,'Bulk Items',NULL,NULL,0,'BulkItems')}
go
{CALL CT_MetaTables(1,1,'Bulk Messages',NULL,NULL,0,'BulkMessages')}
go
{CALL CT_MetaTables(1,1,'Bulk Profiles',NULL,NULL,0,'BulkProfiles')}
go
{CALL CT_MetaTables(1,1,'Calendars',NULL,NULL,0,'Calendars')}
go
{CALL CT_MetaTables(1,1,'Cancel Reasons',NULL,NULL,0,'CancelReasons')}
go
{CALL CT_MetaTables(1,1,'Card Accounts',NULL,NULL,0,'CardAccounts')}
go
{CALL CT_MetaTables(1,1,'Card Batches',NULL,NULL,0,'CardBatches')}
go
{CALL CT_MetaTables(1,1,'Card Batch Types',NULL,NULL,0,'CardBatchTypes')}
go
{CALL CT_MetaTables(1,1,'Card Digits',NULL,NULL,0,'CardDigits')}
go
{CALL CT_MetaTables(1,1,'CCImport Columns',NULL,NULL,0,'CCImportColumns')}
go
{CALL CT_MetaTables(1,1,'Certificates',NULL,NULL,0,'Certs')}
go
{CALL CT_MetaTables(1,1,'Charges',NULL,NULL,0,'Charges')}
go
{CALL CT_MetaTables(1,1,'Charge Types',NULL,NULL,1,'ChargeTypes')}
go
{CALL CT_MetaTables(1,1,'Client Cert Inacts',NULL,NULL,0,'ClientCertInacts')}
go
{CALL CT_MetaTables(1,1,'Client Certs',NULL,NULL,0,'ClientCerts')}
go
{CALL CT_MetaTables(1,1,'Commission Groups',NULL,NULL,0,'CommissionGroups')}
go
{CALL CT_MetaTables(1,1,'Commission Items',NULL,NULL,0,'CommissionItems')}
go
{CALL CT_MetaTables(1,0,'Config Group Data',NULL,NULL,0,'ConfigGroupData')}
go
{CALL CT_MetaTables(1,1,'Config Groups',NULL,NULL,0,'ConfigGroups')}
go
{CALL CT_MetaTables(1,0,'Config Operator Group Data',NULL,NULL,0,'ConfigOperatorGroupData')}
go
{CALL CT_MetaTables(1,1,'Configs',NULL,NULL,0,'Configs')}
go
{CALL CT_MetaTables(1,0,'Config Values',NULL,NULL,0,'ConfigValues')}
go
{CALL CT_MetaTables(1,1,'Continents',NULL,NULL,0,'Continents')}
go
{CALL CT_MetaTables(1,1,'Countries',NULL,NULL,0,'Countries')}
go
{CALL CT_MetaTables(1,1,'Credit Cards','MasterAccounts',NULL,0,'CreditCards')}
go
{CALL CT_MetaTables(1,1,'Currencies',NULL,NULL,0,'Currencies')}
go
{CALL CT_MetaTables(1,1,'Dashes',NULL,NULL,0,'Dashes')}
go
{CALL CT_MetaTables(1,1,'Dash Types',NULL,NULL,0,'DashTypes')}
go
{CALL CT_MetaTables(1,1,'Discounts',NULL,NULL,5,'Discounts')}
go
{CALL CT_MetaTables(1,1,'DNIS Groups',NULL,NULL,10,'DNISGroups')}
go
{CALL CT_MetaTables(1,0,'DNISNumbers',NULL,NULL,0,'DNISNumbers')}
go
{CALL CT_MetaTables(1,1,'Domains',NULL,NULL,1,'Domains')}
go
{CALL CT_MetaTables(1,1,'Events',NULL,NULL,0,'Events')}
go
{CALL CT_MetaTables(1,1,'Event Types',NULL,NULL,0,'EventTypes')}
go
{CALL CT_MetaTables(1,1,'Export Columns',NULL,NULL,0,'ExportColumns')}
go
{CALL CT_MetaTables(1,1,'Exports',NULL,NULL,0,'Exports')}
go
{CALL CT_MetaTables(1,0,'External System Account Types',NULL,NULL,0,'ExternalSystemAccountTypes')}
go
{CALL CT_MetaTables(1,0,'External System Data Types',NULL,NULL,0,'ExternalSystemDataTypes')}
go
{CALL CT_MetaTables(1,1,'External Systems',NULL,NULL,0,'ExternalSystems')}
go
{CALL CT_MetaTables(1,1,'External System Types',NULL,NULL,0,'ExternalSystemTypes')}
go
{CALL CT_MetaTables(1,1,'External Trans',NULL,NULL,0,'ExternalTrans')}
go
{CALL CT_MetaTables(1,1,'File Categories',NULL,NULL,0,'FileCategories')}
go
{CALL CT_MetaTables(1,0,'File Category Mime Types',NULL,NULL,0,'FileCategoryMimeTypes')}
go
{CALL CT_MetaTables(1,1,'File Category Reqs',NULL,NULL,0,'FileCategoryReqs')}
go
{CALL CT_MetaTables(1,1,'Files',NULL,'FileCategories',0,'Files')}
go
{CALL CT_MetaTables(1,1,'Flow Filter Items',NULL,NULL,0,'FlowFilterItems')}
go
{CALL CT_MetaTables(1,1,'Flow Filters',NULL,NULL,0,'FlowFilters')}
go
{CALL CT_MetaTables(1,1,'Forwards','SubAccounts',NULL,0,'Forwards')}
go
{CALL CT_MetaTables(1,1,'Gauge Alerts',NULL,NULL,0,'GaugeAlerts')}
go
{CALL CT_MetaTables(1,1,'Gauge Group Items',NULL,NULL,0,'GaugeGroupItems')}
go
{CALL CT_MetaTables(1,1,'Gauge Groups',NULL,NULL,0,'GaugeGroups')}
go
{CALL CT_MetaTables(1,1,'Gauge Rollups',NULL,NULL,0,'GaugeRollups')}
go
{CALL CT_MetaTables(1,1,'Gauges',NULL,NULL,0,'Gauges')}
go
{CALL CT_MetaTables(1,1,'Geocoders',NULL,NULL,0,'Geocoders')}
go
{CALL CT_MetaTables(1,1,'Geo Layers',NULL,NULL,0,'GeoLayers')}
go
{CALL CT_MetaTables(1,1,'GL Codes',NULL,NULL,56,'GLCodes')}
go
{CALL CT_MetaTables(1,1,'Groups',NULL,NULL,0,'Groups')}
go
{CALL CT_MetaTables(1,1,'IMTypes',NULL,NULL,0,'IMTypes')}
go
{CALL CT_MetaTables(1,0,'Incident Data',NULL,'IncidentDataTypes',0,'IncidentData')}
go
{CALL CT_MetaTables(1,1,'Incident Data Types',NULL,NULL,0,'IncidentDataTypes')}
go
{CALL CT_MetaTables(1,1,'Incidents','MasterAccounts',NULL,0,'Incidents')}
go
{CALL CT_MetaTables(1,1,'Incident State Groups',NULL,NULL,0,'IncidentStateGroups')}
go
{CALL CT_MetaTables(1,1,'Incident States',NULL,NULL,0,'IncidentStates')}
go
{CALL CT_MetaTables(1,1,'Incident Templates',NULL,NULL,0,'IncidentTemplates')}
go
{CALL CT_MetaTables(1,0,'Incident Type File Categories',NULL,NULL,0,'IncidentTypeFileCategories')}
go
{CALL CT_MetaTables(1,1,'Incident Types',NULL,NULL,0,'IncidentTypes')}
go
{CALL CT_MetaTables(1,0,'Incident Values',NULL,NULL,0,'IncidentValues')}
go
{CALL CT_MetaTables(1,0,'Info Bar Operators',NULL,NULL,0,'InfoBarOperators')}
go
{CALL CT_MetaTables(1,0,'Inv Account Types',NULL,NULL,0,'InvAccountTypes')}
go
{CALL CT_MetaTables(1,1,'Inv Attributes',NULL,NULL,0,'InvAttributes')}
go
{CALL CT_MetaTables(1,0,'Inventory Cart Items',NULL,NULL,0,'InvCartItems')}
go
{CALL CT_MetaTables(1,1,'Inventory Carts',NULL,NULL,0,'InvCarts')}
go
{CALL CT_MetaTables(1,1,'Inv Categories',NULL,NULL,0,'InvCategories')}
go
{CALL CT_MetaTables(1,0,'Inv Item Data',NULL,NULL,0,'InvItemData')}
go
{CALL CT_MetaTables(1,1,'Inv Items',NULL,NULL,0,'InvItems')}
go
{CALL CT_MetaTables(1,1,'Inv Level Attributes',NULL,NULL,0,'InvLevelAttributes')}
go
{CALL CT_MetaTables(1,1,'Invoice Items','Invoices',NULL,0,'InvoiceItems')}
go
{CALL CT_MetaTables(1,1,'Invoices','MasterAccounts',NULL,0,'Invoices')}
go
{CALL CT_MetaTables(1,1,'Invoice Types',NULL,NULL,0,'InvoiceTypes')}
go
{CALL CT_MetaTables(1,0,'Inv Product Data',NULL,NULL,0,'InvProductData')}
go
{CALL CT_MetaTables(1,1,'Inv Products',NULL,NULL,0,'InvProducts')}
go
{CALL CT_MetaTables(1,1,'Inv Sources',NULL,NULL,0,'InvSources')}
go
{CALL CT_MetaTables(1,1,'Inv State Groups',NULL,NULL,0,'InvStateGroups')}
go
{CALL CT_MetaTables(1,1,'Inv States',NULL,NULL,0,'InvStates')}
go
{CALL CT_MetaTables(1,1,'Inv Sub Categories',NULL,NULL,0,'InvSubCategories')}
go
{CALL CT_MetaTables(1,1,'Inv Values',NULL,NULL,0,'InvValues')}
go
{CALL CT_MetaTables(1,0,'Inv Warehouse Group Members',NULL,NULL,0,'InvWarehouseGroupItems')}
go
{CALL CT_MetaTables(1,1,'Inv Warehouse Groups',NULL,NULL,0,'InvWarehouseGroups')}
go
{CALL CT_MetaTables(1,0,'Inv Warehouse Products',NULL,NULL,0,'InvWarehouseProducts')}
go
{CALL CT_MetaTables(1,1,'Inv Warehouses',NULL,NULL,0,'InvWarehouses')}
go
{CALL CT_MetaTables(1,1,'IPAttributes',NULL,NULL,0,'IPAttributes')}
go
{CALL CT_MetaTables(1,1,'IPAttribute Types',NULL,NULL,0,'IPAttributeTypes')}
go
{CALL CT_MetaTables(1,1,'IP Address Groups',NULL,NULL,0,'IPGroups')}
go
{CALL CT_MetaTables(1,1,'IP Inventory Allocations',NULL,NULL,0,'IPInvAllocations')}
go
{CALL CT_MetaTables(1,1,'IP Inventory Allocation Reqs',NULL,NULL,0,'IPInvAllocReqs')}
go
{CALL CT_MetaTables(1,0,'IP Range Attributes',NULL,NULL,0,'IPRangeAttributes')}
go
{CALL CT_MetaTables(1,1,'IP Ranges',NULL,NULL,0,'IPRanges')}
go
{CALL CT_MetaTables(1,1,'IP Range Types',NULL,NULL,0,'IPRangeTypes')}
go
{CALL CT_MetaTables(1,1,'Languages',NULL,NULL,0,'Languages')}
go
{CALL CT_MetaTables(1,0,'Late Fee Charge Types',NULL,NULL,0,'LateFeeChargeTypes')}
go
{CALL CT_MetaTables(1,1,'Late Fee Days',NULL,NULL,0,'LateFeeDays')}
go
{CALL CT_MetaTables(1,1,'Late Fees',NULL,NULL,0,'LateFees')}
go
{CALL CT_MetaTables(1,0,'Late Fee Service Cats',NULL,NULL,0,'LateFeeServiceCats')}
go
{CALL CT_MetaTables(1,0,'LDAPServers',NULL,NULL,0,'LDAPServers')}
go
{CALL CT_MetaTables(1,0,'Licenses',NULL,NULL,0,'Licenses')}
go
{CALL CT_MetaTables(1,1,'Log Msgs',NULL,NULL,0,'LogMsgs')}
go
{CALL CT_MetaTables(1,1,'Market Categories',NULL,NULL,0,'MarketCategories')}
go
{CALL CT_MetaTables(1,1,'Market Tag Attributes',NULL,NULL,0,'MarketTagAttributes')}
go
{CALL CT_MetaTables(1,1,'Market Tag Conditions',NULL,NULL,0,'MarketTagConditions')}
go
{CALL CT_MetaTables(1,0,'Market Tag Group Items',NULL,NULL,0,'MarketTagGroupItems')}
go
{CALL CT_MetaTables(1,1,'Market Tag Groups',NULL,NULL,0,'MarketTagGroups')}
go
{CALL CT_MetaTables(1,1,'Market Tags',NULL,NULL,0,'MarketTags')}
go
{CALL CT_MetaTables(1,0,'Master Account Data','MasterAccounts','AccountDataTypes',0,'MasterAccountData')}
go
{CALL CT_MetaTables(1,1,'Master Account Data Types',NULL,NULL,0,'MasterAccountDataTypes')}
go
{CALL CT_MetaTables(1,1,'Master Accounts',NULL,NULL,0,'MasterAccounts')}
go
{CALL CT_MetaTables(1,0,'Master Account Tags','MasterAccounts',NULL,0,'MasterAccountTags')}
go
{CALL CT_MetaTables(1,1,'Menu Items',NULL,NULL,0,'MenuItems')}
go
{CALL CT_MetaTables(1,1,'Menus',NULL,NULL,0,'Menus')}
go
{CALL CT_MetaTables(1,0,'Menu Sets',NULL,NULL,0,'MenuSets')}
go
{CALL CT_MetaTables(1,1,'Meta Columns',NULL,NULL,0,'MetaColumns')}
go
{CALL CT_MetaTables(1,1,'Meta Rules',NULL,NULL,0,'MetaRules')}
go
{CALL CT_MetaTables(1,1,'Meta Tables',NULL,NULL,0,'MetaTables')}
go
{CALL CT_MetaTables(1,1,'Mime Types',NULL,NULL,0,'MimeTypes')}
go
{CALL CT_MetaTables(1,1,'Mon Filter Items',NULL,NULL,0,'MonFilterItems')}
go
{CALL CT_MetaTables(1,1,'Mon Filters',NULL,NULL,0,'MonFilters')}
go
{CALL CT_MetaTables(1,0,'Monitor Profile Options',NULL,NULL,0,'MonitorProfileOptions')}
go
{CALL CT_MetaTables(1,1,'Monitors',NULL,NULL,0,'Monitors')}
go
{CALL CT_MetaTables(1,1,'Mon Profile Items',NULL,NULL,0,'MonProfileItems')}
go
{CALL CT_MetaTables(1,1,'Mon Profiles',NULL,NULL,0,'MonProfiles')}
go
{CALL CT_MetaTables(1,1,'Notice Actives',NULL,NULL,0,'NoticeActives')}
go
{CALL CT_MetaTables(1,1,'Notice Purposes',NULL,NULL,0,'NoticePurposes')}
go
{CALL CT_MetaTables(1,1,'Notices',NULL,NULL,0,'Notices')}
go
{CALL CT_MetaTables(1,1,'Notice Types',NULL,NULL,0,'NoticeTypes')}
go
{CALL CT_MetaTables(1,1,'Object Groups',NULL,NULL,0,'ObjectGroups')}
go
{CALL CT_MetaTables(1,1,'Objects',NULL,NULL,0,'Objects')}
go
{CALL CT_MetaTables(1,0,'Operator Cookies',NULL,NULL,0,'OperatorCookies')}
go
{CALL CT_MetaTables(1,0,'Operator Group Access',NULL,NULL,0,'OperatorGroupAccess')}
go
{CALL CT_MetaTables(1,1,'Operator Groups',NULL,NULL,0,'OperatorGroups')}
go
{CALL CT_MetaTables(0,1,'Operator Payments',NULL,NULL,0,'OperatorPayments')}
go
{CALL CT_MetaTables(1,1,'Operator Roles',NULL,NULL,0,'OperatorRoles')}
go
{CALL CT_MetaTables(0,1,'Operators',NULL,NULL,0,'Operators')}
go
{CALL CT_MetaTables(1,1,'Operator Scheds',NULL,NULL,0,'OperatorScheds')}
go
{CALL CT_MetaTables(1,1,'Operator Sched Times',NULL,NULL,0,'OperatorSchedTimes')}
go
{CALL CT_MetaTables(1,0,'Org Account Types',NULL,NULL,0,'OrgAccountTypes')}
go
{CALL CT_MetaTables(1,1,'Organizations',NULL,NULL,0,'Organizations')}
go
{CALL CT_MetaTables(1,1,'Payments','MasterAccounts',NULL,0,'Payments')}
go
{CALL CT_MetaTables(1,1,'Payment Types',NULL,NULL,8,'PaymentTypes')}
go
{CALL CT_MetaTables(1,1,'Pay Periods',NULL,NULL,7,'PayPeriods')}
go
{CALL CT_MetaTables(1,1,'Pay Plans',NULL,NULL,0,'PayPlans')}
go
{CALL CT_MetaTables(1,1,'Period Types',NULL,NULL,0,'PeriodTypes')}
go
{CALL CT_MetaTables(1,1,'PIIFields',NULL,NULL,0,'PIIFields')}
go
{CALL CT_MetaTables(1,1,'PIIRetentions',NULL,NULL,0,'PIIRetentions')}
go
{CALL CT_MetaTables(1,1,'Print Types',NULL,NULL,0,'PrintTypes')}
go
{CALL CT_MetaTables(1,1,'Priorities',NULL,NULL,0,'Priorities')}
go
{CALL CT_MetaTables(1,1,'Promo Codes',NULL,NULL,0,'PromoCodes')}
go
{CALL CT_MetaTables(1,1,'RADIUS AT Configs',NULL,NULL,0,'RadATConfigs')}
go
{CALL CT_MetaTables(1,0,'RADIUS Attributes',NULL,NULL,0,'RadAttributes')}
go
{CALL CT_MetaTables(1,1,'RADIUS Group Concurrency',NULL,NULL,12,'RadConcurrency')}
go
{CALL CT_MetaTables(1,1,'RADIUS SA Configs',NULL,NULL,0,'RadConfigs')}
go
{CALL CT_MetaTables(1,1,'RADIUS Filter Groups',NULL,NULL,11,'RadFilterGroups')}
go
{CALL CT_MetaTables(1,1,'RADIUS Filters',NULL,NULL,0,'RadFilters')}
go
{CALL CT_MetaTables(1,1,'RADIUS Inv Configs',NULL,NULL,0,'RadInvConfigs')}
go
{CALL CT_MetaTables(1,1,'RADIUS Log Msgs',NULL,NULL,8,'RadLogMsgs')}
go
{CALL CT_MetaTables(1,0,'RADIUS Logs',NULL,NULL,0,'RadLogs')}
go
{CALL CT_MetaTables(1,1,'RADIUS Pool Configs',NULL,NULL,0,'RadPoolConfigs')}
go
{CALL CT_MetaTables(1,1,'RADIUS Proxy Attr Groups',NULL,NULL,0,'RadProxyAttributeGroups')}
go
{CALL CT_MetaTables(1,0,'RADIUS Proxy Attributes',NULL,NULL,0,'RadProxyAttributes')}
go
{CALL CT_MetaTables(1,1,'RADIUS Reject Attrs',NULL,NULL,0,'RadRejectAttributes')}
go
{CALL CT_MetaTables(1,1,'RADIUS Rejects',NULL,NULL,0,'RadRejects')}
go
{CALL CT_MetaTables(1,1,'RADIUS Roam Domains',NULL,NULL,7,'RadRoamDomains')}
go
{CALL CT_MetaTables(1,1,'RADIUS Roam Servers',NULL,NULL,6,'RadRoamServers')}
go
{CALL CT_MetaTables(1,0,'RADIUS Values',NULL,NULL,0,'RadValues')}
go
{CALL CT_MetaTables(1,1,'RADIUS Vendors',NULL,NULL,1,'RadVendors')}
go
{CALL CT_MetaTables(1,1,'Rate Classes',NULL,NULL,0,'RateClasses')}
go
{CALL CT_MetaTables(1,1,'Rate Cost Types',NULL,NULL,0,'RateCostTypes')}
go
{CALL CT_MetaTables(1,1,'Rate Data Sources',NULL,NULL,0,'RateDataSources')}
go
{CALL CT_MetaTables(1,0,'Rate History',NULL,NULL,0,'RateHistory')}
go
{CALL CT_MetaTables(1,1,'Rate Intervals',NULL,NULL,0,'RateIntervals')}
go
{CALL CT_MetaTables(1,1,'Rate IPPorts',NULL,NULL,0,'RateIPPorts')}
go
{CALL CT_MetaTables(1,1,'Rate IPProtocols',NULL,NULL,0,'RateIPProtocols')}
go
{CALL CT_MetaTables(1,1,'Rate Items',NULL,NULL,0,'RateItems')}
go
{CALL CT_MetaTables(1,1,'Rate Rules',NULL,NULL,0,'RateRules')}
go
{CALL CT_MetaTables(1,1,'Rates',NULL,NULL,0,'Rates')}
go
{CALL CT_MetaTables(1,0,'Rate Source Attributes',NULL,NULL,0,'RateSourceAttributes')}
go
{CALL CT_MetaTables(1,1,'Rate Sources',NULL,NULL,0,'RateSources')}
go
{CALL CT_MetaTables(1,1,'Rate Std Groups',NULL,NULL,0,'RateStdGroups')}
go
{CALL CT_MetaTables(1,1,'Rate Std Items',NULL,NULL,0,'RateStdItems')}
go
{CALL CT_MetaTables(1,1,'Rate Time Groups',NULL,NULL,0,'RateTimeGroups')}
go
{CALL CT_MetaTables(1,1,'Rate Times',NULL,NULL,0,'RateTimes')}
go
{CALL CT_MetaTables(1,1,'Rate Types',NULL,NULL,0,'RateTypes')}
go
{CALL CT_MetaTables(1,1,'Rate VCond Groups',NULL,NULL,0,'RateVCondGroups')}
go
{CALL CT_MetaTables(1,1,'Rate VCond Items',NULL,NULL,0,'RateVCondItems')}
go
{CALL CT_MetaTables(1,1,'Rate VDNIS',NULL,NULL,0,'RateVDNIS')}
go
{CALL CT_MetaTables(1,0,'Rate VDNISGroup Items',NULL,NULL,0,'RateVDNISGroupItems')}
go
{CALL CT_MetaTables(1,1,'Rate VDNISGroups',NULL,NULL,0,'RateVDNISGroups')}
go
{CALL CT_MetaTables(1,1,'Rate VDNISImport Types',NULL,NULL,0,'RateVDNISImportTypes')}
go
{CALL CT_MetaTables(1,1,'Rate VDNISItems',NULL,NULL,0,'RateVDNISItems')}
go
{CALL CT_MetaTables(1,1,'Rate VRates',NULL,NULL,0,'RateVRates')}
go
{CALL CT_MetaTables(1,1,'Referred Bys',NULL,NULL,0,'ReferredBys')}
go
{CALL CT_MetaTables(1,1,'Ref Managers',NULL,NULL,0,'RefManagers')}
go
{CALL CT_MetaTables(1,1,'Reg FCC477Account Types',NULL,NULL,0,'RegFCC477AccountTypes')}
go
{CALL CT_MetaTables(1,0,'Reg FCCBLAccount Types',NULL,NULL,0,'RegFCCBLAccountTypes')}
go
{CALL CT_MetaTables(1,1,'Reg FCCBLCharge Items',NULL,NULL,0,'RegFCCBLChargeItems')}
go
{CALL CT_MetaTables(1,1,'Reg FCCBLCharges',NULL,NULL,0,'RegFCCBLCharges')}
go
{CALL CT_MetaTables(1,1,'Reg FCCBLContracts',NULL,NULL,0,'RegFCCBLContracts')}
go
{CALL CT_MetaTables(1,1,'Reg FCCBLProviders',NULL,NULL,0,'RegFCCBLProviders')}
go
{CALL CT_MetaTables(1,1,'Region Groups',NULL,NULL,0,'RegionGroups')}
go
{CALL CT_MetaTables(1,1,'Regions',NULL,NULL,4,'Regions')}
go
{CALL CT_MetaTables(1,1,'Report Fields',NULL,NULL,0,'ReportFields')}
go
{CALL CT_MetaTables(1,1,'Report Groups',NULL,NULL,0,'ReportGroups')}
go
{CALL CT_MetaTables(1,0,'Report Parameters',NULL,NULL,0,'ReportParameters')}
go
{CALL CT_MetaTables(1,1,'Reports',NULL,NULL,0,'Reports')}
go
{CALL CT_MetaTables(1,1,'Roles',NULL,NULL,0,'Roles')}
go
{CALL CT_MetaTables(1,1,'Sales Persons',NULL,NULL,7,'SalesPersons')}
go
{CALL CT_MetaTables(1,1,'Sched Blocks',NULL,NULL,0,'SchedBlocks')}
go
{CALL CT_MetaTables(1,1,'Sched Block Types',NULL,NULL,0,'SchedBlockTypes')}
go
{CALL CT_MetaTables(1,1,'Sched Time Items',NULL,NULL,0,'SchedTimeItems')}
go
{CALL CT_MetaTables(1,1,'Sched Times',NULL,NULL,0,'SchedTimes')}
go
{CALL CT_MetaTables(1,0,'Schedule Intervals',NULL,NULL,0,'ScheduleIntervals')}
go
{CALL CT_MetaTables(0,1,'Schedule Logs',NULL,NULL,0,'ScheduleLogs')}
go
{CALL CT_MetaTables(1,1,'Schedules',NULL,NULL,0,'Schedules')}
go
{CALL CT_MetaTables(1,0,'Schedule Servers',NULL,NULL,0,'ScheduleServers')}
go
{CALL CT_MetaTables(1,0,'Schedule Tasks',NULL,NULL,0,'ScheduleTasks')}
go
{CALL CT_MetaTables(1,1,'Searches',NULL,NULL,0,'Searches')}
go
{CALL CT_MetaTables(1,1,'Search Fields',NULL,NULL,0,'SearchFields')}
go
{CALL CT_MetaTables(1,1,'Search Items',NULL,NULL,0,'SearchItems')}
go
{CALL CT_MetaTables(1,1,'Search Queries',NULL,NULL,0,'SearchQueries')}
go
{CALL CT_MetaTables(1,0,'Section Account Types',NULL,NULL,0,'SectionAccountTypes')}
go
{CALL CT_MetaTables(1,0,'Section Address Types',NULL,NULL,0,'SectionAddressTypes')}
go
{CALL CT_MetaTables(1,1,'Section Globals',NULL,NULL,0,'SectionGlobals')}
go
{CALL CT_MetaTables(1,0,'Section Groups',NULL,NULL,0,'SectionGroups')}
go
{CALL CT_MetaTables(1,0,'Section Operator Groups',NULL,NULL,0,'SectionOperatorGroups')}
go
{CALL CT_MetaTables(1,0,'Section Operators',NULL,NULL,0,'SectionOperators')}
go
{CALL CT_MetaTables(1,1,'Send Methods',NULL,NULL,0,'SendMethods')}
go
{CALL CT_MetaTables(1,1,'Server Access',NULL,NULL,0,'ServerAccess')}
go
{CALL CT_MetaTables(1,1,'Server Groups',NULL,NULL,5,'ServerGroups')}
go
{CALL CT_MetaTables(1,1,'Server Ports',NULL,NULL,0,'ServerPorts')}
go
{CALL CT_MetaTables(1,1,'Servers',NULL,NULL,0,'Servers')}
go
{CALL CT_MetaTables(1,1,'Server Types',NULL,NULL,4,'ServerTypes')}
go
{CALL CT_MetaTables(1,1,'Service Cat Access',NULL,NULL,0,'ServiceCatAccess')}
go
{CALL CT_MetaTables(1,0,'Service Cat Account Types',NULL,NULL,0,'ServiceCatAccountTypes')}
go
{CALL CT_MetaTables(1,1,'Service Cat Service Type Access',NULL,NULL,0,'ServiceCatATAccess')}
go
{CALL CT_MetaTables(1,1,'Service Categories',NULL,NULL,0,'ServiceCategories')}
go
{CALL CT_MetaTables(1,0,'Service Cat Links',NULL,NULL,0,'ServiceCatLinks')}
go
{CALL CT_MetaTables(1,0,'Service Cat Parent Account Types',NULL,NULL,0,'ServiceCatParentAccountTypes')}
go
{CALL CT_MetaTables(1,0,'Service Group Items',NULL,NULL,0,'ServiceGroupItems')}
go
{CALL CT_MetaTables(1,1,'Service Groups',NULL,NULL,0,'ServiceGroups')}
go
{CALL CT_MetaTables(1,1,'Service Level Types',NULL,NULL,0,'ServiceLevelTypes')}
go
{CALL CT_MetaTables(1,1,'Signup Options',NULL,NULL,0,'SignupOptions')}
go
{CALL CT_MetaTables(1,1,'Signup Servers',NULL,NULL,0,'SignupServers')}
go
{CALL CT_MetaTables(1,1,'Sites',NULL,NULL,0,'Sites')}
go
{CALL CT_MetaTables(1,1,'SMSPollers',NULL,NULL,0,'SMSPollers')}
go
{CALL CT_MetaTables(1,1,'SMSREGroups',NULL,NULL,0,'SMSREGroups')}
go
{CALL CT_MetaTables(1,1,'SMSREItems',NULL,NULL,0,'SMSREItems')}
go
{CALL CT_MetaTables(1,1,'SMSStatus',NULL,NULL,0,'SMSStatus')}
go
{CALL CT_MetaTables(1,1,'Statements','MasterAccounts',NULL,0,'Statements')}
go
{CALL CT_MetaTables(1,1,'States',NULL,NULL,0,'States')}
go
{CALL CT_MetaTables(1,0,'Strings',NULL,NULL,0,'Strings')}
go
{CALL CT_MetaTables(1,0,'Sub Account Data','SubAccounts','AccountDataTypes',0,'SubAccountData')}
go
{CALL CT_MetaTables(1,1,'Sub Account Data Types',NULL,NULL,0,'SubAccountDataTypes')}
go
{CALL CT_MetaTables(1,1,'Sub Accounts','MasterAccounts',NULL,0,'SubAccounts')}
go
{CALL CT_MetaTables(1,0,'Sub Account Tags','SubAccounts',NULL,0,'SubAccountTags')}
go
{CALL CT_MetaTables(1,0,'Sync Actives',NULL,NULL,0,'SyncActives')}
go
{CALL CT_MetaTables(1,1,'Sync Examples',NULL,NULL,0,'SyncExamples')}
go
{CALL CT_MetaTables(1,1,'Syncs',NULL,NULL,0,'Syncs')}
go
{CALL CT_MetaTables(1,1,'Syslog Alerts',NULL,NULL,0,'SyslogAlerts')}
go
{CALL CT_MetaTables(1,1,'Syslog Msg Type Items',NULL,NULL,0,'SyslogMsgTypeItems')}
go
{CALL CT_MetaTables(1,1,'Syslog Msg Types',NULL,NULL,0,'SyslogMsgTypes')}
go
{CALL CT_MetaTables(0,1,'Sys Logs',NULL,NULL,0,'SysLogs')}
go
{CALL CT_MetaTables(1,1,'Syslog Source Items',NULL,NULL,0,'SyslogSourceItems')}
go
{CALL CT_MetaTables(1,1,'Syslog Sources',NULL,NULL,0,'SyslogSources')}
go
{CALL CT_MetaTables(1,1,'Taxes',NULL,NULL,0,'Taxes')}
go
{CALL CT_MetaTables(1,1,'Tax Exemptions',NULL,NULL,0,'TaxExemptions')}
go
{CALL CT_MetaTables(1,1,'Tax Groups',NULL,NULL,0,'TaxGroups')}
go
{CALL CT_MetaTables(1,1,'Tax Group Taxes',NULL,NULL,0,'TaxGroupTaxes')}
go
{CALL CT_MetaTables(1,1,'Tax Piggy Backs',NULL,NULL,0,'TaxPiggyBacks')}
go
{CALL CT_MetaTables(1,1,'Tax Sources',NULL,NULL,0,'TaxSources')}
go
{CALL CT_MetaTables(1,1,'Tax Types',NULL,NULL,0,'TaxTypes')}
go
{CALL CT_MetaTables(1,1,'Theme Filters',NULL,NULL,0,'ThemeFilters')}
go
{CALL CT_MetaTables(1,1,'Themes',NULL,NULL,0,'Themes')}
go
{CALL CT_MetaTables(1,1,'Time Charges',NULL,NULL,0,'TimeCharges')}
go
{CALL CT_MetaTables(1,1,'Tower Antennas',NULL,NULL,0,'TowerAntennas')}
go
{CALL CT_MetaTables(1,0,'Tower Antenna Service Cats',NULL,NULL,0,'TowerAntennaServiceCats')}
go
{CALL CT_MetaTables(1,1,'Tower Antenna Types',NULL,NULL,0,'TowerAntennaTypes')}
go
{CALL CT_MetaTables(1,1,'Towers',NULL,NULL,0,'Towers')}
go
{CALL CT_MetaTables(1,1,'Tower Types',NULL,NULL,0,'TowerTypes')}
go
{CALL CT_MetaTables(1,1,'Trusted Files',NULL,NULL,0,'TrustedFiles')}
go
{CALL CT_MetaTables(1,1,'Web Forwarders',NULL,NULL,0,'WebForwarders')}
go
{CALL CT_MetaTables(1,1,'Web Links',NULL,NULL,0,'WebLinks')}
go
{CALL CT_MetaTables(1,1,'Web Link Types',NULL,NULL,0,'WebLinkTypes')}
go
{CALL CT_MetaColumns('AccessLabels','AccessLabel','Access Label',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','AccessLabelID','Access Label ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','ObjectGroupID','Object Group ID',10653,'ObjectGroups','ObjectGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccessLabels','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','AccountChangeID','Account Change ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','ActiveDate','Active Date',NULL,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','AllowReinvoice','Allow Reinvoice',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','CancelReasonID','Cancel Reason ID',10663,'CancelReasons','CancelReasonID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','CreateCustomerID','Create Customer ID',NULL,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','EffectiveDate','Effective Date',12563,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','InactiveDate','Inactive Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountChanges','InactiveUser','Inactive User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','AccountDataType','Account Data Type',11134,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','AccountDataTypeID','Account Data Type ID',11131,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','AllowMBR','Allow MBR',11133,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','AllowSA','Allow SA',11132,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','DataTypeID','Data Type ID',10988,'DataTypes','DataTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','RegExp','Validation RegExp',NULL,NULL,NULL,NULL,NULL,0,1,1,0,1024,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','SQLQuery','SQLQuery',11143,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataValues','AccountDataTypeID','Account Data Type ID',11131,'AccountDataTypes','AccountDataTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataValues','KeyData','Key Data',11135,NULL,NULL,NULL,NULL,1,0,1,0,128,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountDataValues','ValueData','Value Data',11136,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','AccessTime','Access Time',NULL,NULL,NULL,NULL,22,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','AccountTagTime','Account Tag Time',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','AccountTagTimeID','Account Tag Time ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','EndDate','End Date',10519,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTagTimes','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','AccountTemplate','Account Template',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','AccountTemplateID','Account Template ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','CustEdit','Cust Edit',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','CustEditLabel','Cust Edit Label',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','CustEditStringID','Cust Edit String ID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','CustNew','Cust New',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','CustSave','Cust Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SADetail','SA Detail',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SAEdit','SA Edit',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SANew','SA New',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SASave','SA Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SignupBillSave','Signup Billing Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SignupForm','Signup Form',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SignupPage','Signup Page',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SignupSave','Signup Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SignupValidate','Signup Validate',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTemplates','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','AccountType','Service Type',10041,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','AccountTypeID','Account Type ID',10610,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','AllowRADIUS','Allow RADIUS',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','Cost','Cost',10228,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','DataLeft','Data Left',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','DataLeftAuth','Data Left Auth',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','DataLeftRenewal','Data Left Renewal',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','DNISGroupID','DNISGroup ID',10694,'DNISGroups','DNISGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','EndDate','End Date',10519,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','Extension','Extension',10609,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','GLCodeID','GLCode ID',10584,'GLCodes','GLCodeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','InactCanceledDays','Inact Canceled Days',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','LoginLimit','Login Limit',10720,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','LogonAsParent','Logon As Parent',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','NewCost','New Cost',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','NewCostDate','New Cost Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','OverDue','Over Due',10742,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','PayPeriodID','Pay Period ID',10647,'PayPeriods','PayPeriodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ProrateClose','Prorate Close',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ProrateCloseTemp','Prorate Close Temp',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ProrateOpen','Prorate Open',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ProrateOpenTemp','Prorate Open Temp',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RateClassID','Rate Class ID',10898,'RateClasses','RateClassID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RateDataLeft','Rating Data Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RateTimeLeft','Rate Time Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RemoteAccess','Remote Access',10719,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RequireUserPass','Require User Pass',10894,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RLimitDataLeft','Rollover Limit - Data Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RLimitRateDataLeft','Rollover Limit - Rating Data Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RLimitRateTimeLeft','Rollover Limit - Rating Time Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','RLimitTimeLeft','Rollover Limit - Time Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','SecChargeTypeID','Secondary Setup Charge',NULL,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','SecServiceLevelTypeID','Sec Service Level Type ID',NULL,'ServiceLevelTypes','ServiceLevelTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','ServiceLevelTypeID','Service Level Type ID',NULL,'ServiceLevelTypes','ServiceLevelTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','TaxExemptions','Tax Exemptions',11184,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','TaxGroupID','Tax Group ID',10897,'TaxGroups','TaxGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','TimeLeft','Time Left',10233,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','TimeLeftRenewal','Time Left Renewal',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','UsageToParent','Usage To Parent',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypes','UseServerPassword','Use Server Password',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypeTemplates','AccountTemplateID','Account Template ID',NULL,'AccountTemplates','AccountTemplateID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AccountTypeTemplates','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','ActionID','Action ID',10885,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','AssignOperatorID','Assign Operator ID',10884,'Operators','OperatorID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','AssignRoleID','Assign Role ID',10883,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','CreateAccountID','Create Account ID',10881,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','CreateOperatorID','Create Operator ID',10880,'Operators','OperatorID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','Duration','Duration',10882,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','IncidentID','Incident',10474,'Incidents','IncidentID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','IncidentStateID','Incident State',10879,'IncidentStates','IncidentStateID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','IncidentTypeID','Incident Type',10878,'IncidentTypes','IncidentTypeID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Actions','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressData','AddressDataSourceID','Address Data Source ID',NULL,'AddressDataSources','AddressDataSourceID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressData','AddressDataTypeID','Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressData','AddressID','Address ID',11092,'Addresses','AddressID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,512,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressData','LastUpdate','Last Update',10562,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','AddressDataType','Address Data Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','AddressDataTypeID','Address Data Type ID',NULL,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','Detail','Detail',12290,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','IsPhone','Is Phone',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressDataTypes','Summary','Summary',10315,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Address1','Address 1',10813,NULL,NULL,NULL,NULL,0,1,1,0,180,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Address2','Address 2',10814,NULL,NULL,NULL,NULL,0,1,1,0,180,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','AddressID','Address ID',11092,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','AddressTypeID','Address Type',11091,'AddressTypes','AddressTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Aux1','Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Aux2','Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Aux3','Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','BirthDate','Birth Date',10854,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','City','City',10290,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Company','Company',10025,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','CountryID','Country',10292,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','DLNumber','Driver License Number',NULL,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Email','Email',10188,NULL,NULL,NULL,6,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','EmailNoticePurposeMask','Email Notice Purpose Mask',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','FirstName','First Name',10043,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Gender','Gender',10770,NULL,NULL,NULL,NULL,0,1,1,0,1,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','IMHandle','Messaging Handle',NULL,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','IMTypeID','Messaging Type',NULL,'IMTypes','IMTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','LastName','Last Name',10020,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Lat','Lat',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Long','Long',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','PhoneFax','Phone Fax',10820,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','PhoneHome','Phone Home',10775,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','PhoneMobile','Phone Mobile',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','PhoneWork','Phone Work',10771,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Province','Province',10812,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','SMSAccessTime','SMS Access Time',NULL,NULL,NULL,NULL,22,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','SMSNoticePurposeMask','SMSNotice Purpose Mask',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','SSN','SSN',10856,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','StateID','State',10291,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','TaxNumber','Tax Number',NULL,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','WWW','WWW',11095,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Addresses','Zip','Zip',10077,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','AddressGeoSource','Address Geo Source',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','AddressGeoSourceID','Address Geo Source ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','AllowBilling','Allow Billing',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','AllowService','Allow Service',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','AllowShipping','Allow Shipping',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Aux1AddressDataTypeID','Aux 1Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Aux2AddressDataTypeID','Aux 2Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Aux3AddressDataTypeID','Aux 3Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Aux4AddressDataTypeID','Aux 4Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','CountryID','Country ID',11051,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','GeoLayerID','Geo Layer ID',NULL,'GeoLayers','GeoLayerID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','GeoShapeAddressDataTypeID','Geo Shape Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','IEAID','IEAID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','Overlap','Overlap',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','RegionID','Region ID',10629,'Regions','RegionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressGeoSources','StateID','State ID',11120,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','AddressDataTypeID','Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','AddressTypeDataTypeID','Address Type Data Type ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','AddressTypeID','Address Type ID',11088,'AddressTypes','AddressTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','Required','Required',10736,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypeDataTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','AddressType','Address Type',11091,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','AddressTypeID','Address Type ID',11088,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','AllowAdmin','Allow Admin',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','AllowMBR','Allow MBR',11133,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','AllowSA','Allow SA',11132,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','BillingPriority','Billing Priority',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','ContactPriority','Contact Priority',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','EmailNoticePurposeMask','Email Notice Purpose Mask',NULL,NULL,NULL,NULL,5,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','RequiredFields','Required Fields',11090,NULL,NULL,NULL,NULL,0,1,1,0,512,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','ServicePriority','Service Priority',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','ShippingPriority','Shipping Priority',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','SMSNoticePurposeMask','SMSNotice Purpose Mask',NULL,NULL,NULL,NULL,5,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AddressTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','AlertSource','Alert Source',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','AlertSourceID','Alert Source ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','AlertSourceTypeID','Alert Source Type ID',NULL,'AlertSourceTypes','AlertSourceTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','IEAID','IEAID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSources','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSourceTypes','AlertSourceType','Alert Source Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertSourceTypes','AlertSourceTypeID','Alert Source Type ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','AlertType','Alert Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','AlertTypeID','Alert Type ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','AllowManual','Allow Manual',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','IEAID','IEAID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AlertTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','Alias','Alias',10766,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','AliasID','Alias ID',10601,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Aliases','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AllowedHosts','AllowedHostID','Allowed Host ID',10598,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AllowedHosts','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AllowedHosts','IPAddress','IPAddress',10207,NULL,NULL,NULL,23,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AllowedHosts','OperatorGroupID','Operator Group ID',10599,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','APIAction','APIAction',NULL,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','APIActionID','APIAction ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','APIActionTypeID','APIAction Type ID',NULL,'APIActionTypes','APIActionTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','APIGroupCheckID','APIGroup Check ID',NULL,'APIGroupChecks','APIGroupCheckID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIActions','FeatureID','Feature ID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','APIActionID','APIAction ID',NULL,'APIActions','APIActionID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','APIFieldID','APIField ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','APIFieldTypeID','APIField Type ID',NULL,'APIFieldTypes','APIFieldTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','Example','Example',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','FieldName','Field Name',10847,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIFields','Required','Required',10736,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIProfileItems','APIFieldID','APIField ID',NULL,'APIFields','APIFieldID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIProfileItems','APIProfileID','APIProfile ID',NULL,'APIProfiles','APIProfileID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIProfileItems','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIProfiles','APIProfile','APIProfile',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIProfiles','APIProfileID','APIProfile ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIStepColumns','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIStepColumns','APIStepID','APIStep ID',NULL,'APISteps','APIStepID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIStepColumns','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIStepColumns','DefaultData','Default Data',11141,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APIStepColumns','MetaColumnID','Meta Column ID',10664,'MetaColumns','MetaColumnID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','APIActionID','APIAction ID',NULL,'APIActions','APIActionID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','APIStep','APIStep',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','APIStepID','APIStep ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','APIStepTypeID','APIStep Type ID',NULL,'APIStepTypes','APIStepTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','Condition','Condition',10954,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','DisplayParent','Display Parent',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','DisplayQuery','Display Query',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','EWS','EWS',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','FeatureID','Feature ID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','MetaTableID','Meta Table ID',10665,'MetaTables','MetaTableID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','Step','Step',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','ValueFields','Value Fields',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('APISteps','ValueQuery','Value Query',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Applications','ApplicationID','Application ID',10600,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Applications','AppName','App Name',10765,NULL,NULL,NULL,NULL,1,0,1,1,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','AccountID','Account ID',10034,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','CustomerID','Customer ID',10018,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','LogDate','Log Date',10554,NULL,NULL,NULL,7,0,0,1,1,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','LogMsg','Log Msg',10764,NULL,NULL,NULL,NULL,1,0,1,1,255,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','LogMsgID','Log Msg ID',10597,'LogMsgs','LogMsgID',NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('AuditLogs','Operator','Operator',10049,NULL,NULL,NULL,NULL,1,0,1,1,64,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','ABANumber','ABANumber',10763,NULL,NULL,NULL,11,1,0,1,1,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','AccountNumber','Account Number',10073,NULL,NULL,NULL,11,1,0,1,1,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','AuthName','Auth Name',10287,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','BankName','Bank Name',10074,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','BankPhone','Bank Phone',10295,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','BirthDate','Birth Date',10854,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','DLNumber','DLNumber',10857,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','DLState','DLState',10855,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','SSN','SSN',10856,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BankTrans','TransType','Trans Type',10762,NULL,NULL,NULL,NULL,1,1,1,0,16,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','BatchID','Batch ID',11195,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','BatchInfo','Batch Info',11309,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','BatchStateID','Batch State ID',11306,'BatchStates','BatchStateID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','BatchTypeID','Batch Type ID',11305,'BatchTypes','BatchTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','EndDate','End Date',10519,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','ItemCount','Item Count',11307,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','ItemTotal','Item Total',11308,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','Rebatch','Rebatch',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Batches','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchAux1','Batch Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchAux2','Batch Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchAux3','Batch Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchIn','Batch In',11073,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchLimit','Batch Limit',11063,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchOut','Batch Out',11074,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchProcessor','Batch Processor',10067,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','BatchProcessorID','Batch Processor ID',11062,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','CardTypes','Card Types',11067,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','CertID','Cert ID',NULL,'Certs','CertID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','ExportID','Export ID',10591,'Exports','ExportID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','ExportOptions','Export Options',11065,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','ImportOptions','Import Options',11064,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Login','Login',10038,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Merchant','Merchant',11069,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','OrganizationID','Organization ID',11046,'Organizations','OrganizationID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Password','Password',10402,NULL,NULL,NULL,29,0,1,1,0,200,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','ProcessorURL','Processor URL',11068,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','RebatchInterval','Rebatch Interval',11066,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','RebatchTries','Rebatch Tries',10744,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Store','Store',11070,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BatchProcessors','Terminal','Terminal',11071,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','AutoBill','Auto Bill',10713,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','BillDay','Bill Day',10593,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','BillingCycle','Billing Cycle',10666,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','BillingCycleID','Billing Cycle ID',10596,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','BillMonth','Bill Month',12625,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','CycleType','Cycle Type',10714,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','EBillDays','EBill Days',10595,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','ExpCancelReasonID','Exp Cancel Reason ID',NULL,'CancelReasons','CancelReasonID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','Extension','Extension',10609,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','IBillDays','IBill Days',10594,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','RenewDays','Renew Days',11202,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','RenewPeriods','Renew Periods',11203,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingCycles','TBillDays','TBill Days',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','BillingImport','Billing Import',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','BillingImportID','Billing Import ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','BillingImportTypeID','Billing Import Type',NULL,'BillingImportTypes','BillingImportTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','LookupQuery','Lookup Query',NULL,NULL,NULL,NULL,NULL,0,1,1,0,1024,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','RegExp','Reg Exp',NULL,NULL,NULL,NULL,NULL,1,0,1,0,1024,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BillingImports','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','AddressCategoryID','Address Category ID',NULL,'AddressCategories','AddressCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','AddressData','Address Data',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','AddressDataTypeID','Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','Allowed','Allowed',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','BillingCycleID','Billing Cycle ID',10596,'BillingCycles','BillingCycleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','BulkItem','Bulk Item',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','BulkItemID','Bulk Item ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','BulkProfileID','Bulk Profile ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','City','City',10290,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','CountryID','Country ID',11051,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','MAAccountDataTypeID','MBR Custom Data Type ID',NULL,'AccountDataTypes','AccountDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','MAData','MBR Custom Data',10011,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','PaymentTypeID','Payment Type ID',10648,'PaymentTypes','PaymentTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','RegionID','Region ID',10629,'Regions','RegionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','SAAccountDataTypeID','Service Custom Data Type ID',NULL,'AccountDataTypes','AccountDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','SAData','Service Custom Data',10016,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','SendMethodID','Send Method ID',11234,'SendMethods','SendMethodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','StateID','State ID',11120,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','TowerID','Tower ID',NULL,'Towers','TowerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkItems','Zip','Zip',10077,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','BulkMessage','Bulk Message',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','BulkMessageID','Bulk Message ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','MailFrom','Mail From',11080,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','MailSubject','Mail Subject',11081,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','Message','Message',10316,NULL,NULL,NULL,NULL,1,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','NoticeFormatID','Notice Format ID',NULL,'NoticeFormats','NoticeFormatID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','NoticeTechID','Notice Tech ID',NULL,'NoticeTechs','NoticeTechID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkMessages','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkProfiles','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkProfiles','BulkProfile','Bulk Profile',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkProfiles','BulkProfileID','Bulk Profile ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkProfiles','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('BulkProfiles','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','AuthKey','Authorization Key',NULL,NULL,NULL,NULL,NULL,1,0,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','Calendar','Calendar',10439,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','CalendarID','Calendar ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','IncidentTypeID','Incident Type ID',10987,'IncidentTypes','IncidentTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','OrganizationID','Organization ID',11046,'Organizations','OrganizationID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Calendars','RoleID','Role ID',10986,'Roles','RoleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','CancelReason','Cancel Reason',10341,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','CancelReasonID','Cancel Reason ID',10663,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','Returning','Returning',11216,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CancelReasons','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','AllowCredit','Allow Credit',11256,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','AllowDirect','Allow Direct',11245,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','CardAccountID','Card Account ID',11260,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','CardBatchID','Card Batch ID',11246,'CardBatches','CardBatchID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','CreditAmount','Credit Amount',11264,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','DirectAccountID','Direct Account ID',11261,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','DirectCustomerID','Direct Customer ID',11259,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','FirstUseDate','First Use Date',11262,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','InactiveExpireDate','Inactive Expire Date',11247,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','LastCreditDate','Last Credit Date',11263,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','Login','Login',10038,NULL,NULL,NULL,NULL,1,0,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','OrganizationID','Organization ID',11046,'Organizations','OrganizationID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','Password','Password',10402,NULL,NULL,NULL,29,1,0,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','UsedForCredit','Used For Credit',11257,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardAccounts','UsedForDirect','Used For Direct',11258,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','ActiveExpireDays','Active Expire Days',11238,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','ActiveExpireMins','Active Expire Mins',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','AllowDirect','Allow Direct',11245,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','Amount','Amount',10078,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','BatchSize','Batch Size',11237,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','BillingCycleID','Billing Cycle ID',10596,'BillingCycles','BillingCycleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','BytesLeft','Bytes Left',11241,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','CardBatch','Card Batch',11251,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','CardBatchID','Card Batch ID',11246,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','CardBatchTypeID','Card Batch Type ID',11236,'CardBatchTypes','CardBatchTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','DataLeft','Data Left',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','DirectAmount','Direct Amount',11243,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','DomainID','Domain ID',10693,'Domains','DomainID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','InactiveExpireDate','Inactive Expire Date',11247,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LoginCardDigitID','Login Card Digit ID',11242,'CardDigits','CardDigitID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LoginParm1','Login Parm 1',11252,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LoginParm2','Login Parm 2',11253,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','LoginPrefix','Login Prefix',11255,NULL,NULL,NULL,NULL,0,1,1,0,10,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','PasswordCardDigitID','Password Card Digit ID',11239,'CardDigits','CardDigitID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','PasswordParm1','Password Parm 1',11254,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','PasswordParm2','Password Parm 2',11250,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','PayPeriodID','Pay Period ID',10647,'PayPeriods','PayPeriodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','RangeStart','Range Start',11248,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','RangeStep','Range Step',11249,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','RateDataLeft','Rating Data Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','RateTimeLeft','Rate Time Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','SalesPersonID','Sales Person ID',10627,'SalesPersons','SalesPersonID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','SendMethodID','Send Method ID',11234,'SendMethods','SendMethodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatches','TimeLeft','Time Left',10233,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','ActiveExpireDays','Active Expire Days',11238,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','ActiveExpireMins','Active Expire Mins',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','AllowDirectUse','Allow Direct Use',11235,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','Amount','Amount',10078,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','BatchSize','Batch Size',11237,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','BillingCycleID','Billing Cycle ID',10596,'BillingCycles','BillingCycleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','BytesLeft','Bytes Left',11241,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','CardBatchType','Batch Type Description',11244,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','CardBatchTypeID','Card Batch Type ID',11236,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','DataLeft','Data Left',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','DirectAmount','Direct Amount',11243,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','DomainID','Domain ID',10693,'Domains','DomainID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','InactiveExpireDays','Inactive Expire Days',11240,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','LoginCardDigitID','Login Card Digit ID',11242,'CardDigits','CardDigitID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','PasswordCardDigitID','Password Card Digit ID',11239,'CardDigits','CardDigitID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','PayPeriodID','Pay Period ID',10647,'PayPeriods','PayPeriodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','RateDataLeft','Rating Data Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','RateTimeLeft','Rate Time Left',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','SalesPersonID','Sales Person ID',10627,'SalesPersons','SalesPersonID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','SendMethodID','Send Method ID',11234,'SendMethods','SendMethodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardBatchTypes','TimeLeft','Time Left',10233,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','AllowLogin','Allow Login',11230,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','AllowPassword','Allow Password',11231,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','CardDigit','Sequence Description',11233,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','CardDigitID','Card Digit ID',11232,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','JavascriptField','Javascript Field',11229,NULL,NULL,NULL,NULL,1,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CardDigits','JavascriptHeader','Javascript Header',11228,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','ApproveValue','Approve Value',10761,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','CCImportColumnID','CCImport Column ID',10590,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','DeclineValue','Decline Value',10759,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','ErrorValue','Error Value',10760,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','ExportID','Export ID',10591,'Exports','ExportID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','FieldSize','Field Size',10711,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','FieldType','Field Type',10712,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','Line','Line',10592,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','Position','Position',10709,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','Quoted','Quoted',10710,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CCImportColumns','TransType','Trans Type',10762,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','Bits','Bits',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','Cert','Cert',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','CertID','Cert ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','CertTypeID','Certificate Type',NULL,'CertTypes','CertTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','PrivateKey','Private Key',NULL,NULL,NULL,NULL,29,0,1,1,0,0,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Certs','PublicKey','Public Key',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','AccountTypeID','Account Type',10588,'AccountTypes','AccountTypeID',NULL,21,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','AllowInterim','Allow Interim',11342,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','ChargeID','Charge ID',10589,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','ChargeTypeID','Charge Type',10585,'ChargeTypes','ChargeTypeID',NULL,21,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,1,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','DistFlag','Dist Flag',11193,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','EndDate','End Date',10519,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','ItemID','Item ID',10586,'InvoiceItems','ItemID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','Quantity','Quantity',10520,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','TaxExemptions','Tax Exemptions',11184,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Charges','TaxGroupID','Tax Group',11188,'TaxGroups','TaxGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','ChargeType','Charge Type',10585,NULL,NULL,NULL,NULL,1,0,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','ChargeTypeID','Charge Type ID',10587,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','GLCodeID','GLCode ID',10584,'GLCodes','GLCodeID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','TaxExemptions','Tax Exemptions',11184,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ChargeTypes','TaxGroupID','Tax Group ID',10897,'TaxGroups','TaxGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCertInacts','ClientCertInact','Client Cert Inact',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCertInacts','ClientCertInactID','Client Cert Inact ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCertInacts','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','Bits','Bits',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','ClientCert','Client Cert',NULL,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','ClientCertID','Client Cert ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','ClientCertInactID','Client Cert Inact ID',NULL,'ClientCertInacts','ClientCertInactID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,512,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','DownloadDate','Download Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','DownloadIPAddress','Download IPAddress',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','DownloadOperatorID','Download Operator ID',NULL,'Operators','OperatorID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','ExpireDate','Expire Date',10558,NULL,NULL,NULL,7,1,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ClientCerts','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionGroups','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionGroups','CommissionGroup','Commission',11378,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionGroups','CommissionGroupID','Commission Group ID',11377,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionGroups','CommissionType','Commission Type',11376,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionGroups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','CommissionGroupID','Commission Group ID',11377,'CommissionGroups','CommissionGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','CommissionItemID','Commission Item ID',11379,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CommissionItems','CommissionValue','Commission Value',11380,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroupData','ConfigID','Config ID',10578,'Configs','ConfigID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroupData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroupData','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroupData','NumValue','Num Value',10886,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroups','ConfigGroupID','Config Group ID',10580,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroups','Name','Name',10054,NULL,NULL,NULL,NULL,1,0,1,1,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigGroups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigOperatorGroupData','ConfigID','Config ID',10578,'Configs','ConfigID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigOperatorGroupData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigOperatorGroupData','NumValue','Num Value',10886,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigOperatorGroupData','OperatorGroupID','Operator Group ID',10599,'OperatorGroups','OperatorGroupID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','ConfigGroupID','Config Group ID',10580,'ConfigGroups','ConfigGroupID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','ConfigID','Config ID',10578,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','ConfigType','Config Type',10708,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','Edition','Edition',10581,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','Feature','Feature',10577,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','NumValue','Value',10014,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Configs','Template','Template',10755,NULL,NULL,NULL,NULL,0,1,1,0,16,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigValues','ConfigID','Config ID',10578,'Configs','ConfigID',NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigValues','Value','Value',10014,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ConfigValues','ValueName','Value Name',10756,NULL,NULL,NULL,NULL,1,0,1,1,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Continents','Continent','Continent',11060,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Continents','ContinentID','Continent ID',11052,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Continents','Hidden','Hidden',11048,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Continents','Planet','Planet',11061,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Continents','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Abbr2','Abbr 2',11058,NULL,NULL,NULL,NULL,0,1,1,0,2,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Abbr3','Abbr 3',11059,NULL,NULL,NULL,NULL,0,1,1,0,3,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','ContinentID','Continent ID',11052,'Continents','ContinentID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Country','Country',10292,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','CountryID','Country ID',11051,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Currency','Currency',11056,NULL,NULL,NULL,NULL,0,1,1,0,5,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','DescAux1','Desc Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','DescAux2','Desc Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','DescAux3','Desc Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Hidden','Hidden',11048,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','InternetDomain','Internet Domain',11057,NULL,NULL,NULL,NULL,0,1,1,0,5,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','NNLength','NNLength',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','Restricted','Restricted',11049,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','TelIDD','Tel IDD',11054,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','TelLocPrefixLen','Tel Loc Prefix Len',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','TelNDD','Tel NDD',11055,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','TelPrefix','Tel Prefix',11053,NULL,NULL,NULL,NULL,0,1,1,0,10,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','UNID','UNID',11050,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Countries','ZipStatus','Zip Status',NULL,NULL,NULL,NULL,NULL,0,1,0,NULL,NULL,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','Bank','Bank',11270,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BankPhone','Bank Phone',10295,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BatchProcessorID','Batch Processor ID',11062,'BatchProcessors','BatchProcessorID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToAddress1','Bill To Address 1',11275,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToAddress2','Bill To Address 2',11271,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToCity','Bill To City',11274,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToCountryID','Bill To Country ID',11268,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToStateID','Bill To State ID',11267,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','BillToZip','Bill To Zip',11273,NULL,NULL,NULL,NULL,0,1,1,0,15,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CardHolder','Card Holder',10084,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CardLength','Card Length',11265,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CardNumber','Card Number',10085,NULL,NULL,NULL,11,0,1,1,0,70,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CardTypeID','Card Type ID',11266,'CardTypes','CardTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CertCardNumber','Cert Card Number',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CertID','Cert ID',NULL,'Certs','CertID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','ExpirationDate','Expiration Date',10434,NULL,NULL,NULL,7,1,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','Misc1','Misc 1',11277,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','Misc2','Misc 2',11276,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','SecurityCode','Security Code',10288,NULL,NULL,NULL,11,0,1,1,0,64,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('CreditCards','Token','Token',12618,NULL,NULL,NULL,11,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','Code','Code',11374,NULL,NULL,NULL,NULL,0,1,1,0,5,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','CountryID','Country ID',11051,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','Currency','Currency',11056,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','CurrencyID','Currency ID',11372,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Currencies','Symbol','Symbol',11373,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','Aux1','Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','Aux2','Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','Aux3','Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','Aux4','Aux 4',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','Aux5','Aux 5',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','DashID','Dash ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','DashTypeID','Dash Type ID',NULL,'DashTypes','DashTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','IncidentStateID','Incident State ID',10973,'IncidentStates','IncidentStateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','IncidentTypeID','Incident Type ID',10987,'IncidentTypes','IncidentTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','OrganizationID','Organization ID',11046,'Organizations','OrganizationID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','RegionID','Region ID',10629,'Regions','RegionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','RoleID','Role ID',10986,'Roles','RoleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Dashes','SchedBlockTypeID','Sched Block Type ID',NULL,'SchedBlockTypes','SchedBlockTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','AccessLabel','Access Label',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','DashType','Dash Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','DashTypeID','Dash Type ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FeatureID','Feature ID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FileDelete','File Delete',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FileDisplay','File Display',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FileEdit','File Edit',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FileList','File List',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','FileUpdate','File Update',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DashTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','Amount','Amount',10078,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','AmountType','Amount Type',10731,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','Discount','Discount',10608,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','DiscountID','Discount ID',10695,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Discounts','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DNISGroups','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DNISGroups','DNISGroup','DNISGroup',10851,NULL,NULL,NULL,NULL,1,0,1,1,25,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DNISGroups','DNISGroupID','DNISGroup ID',10694,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DNISNumbers','DNISGroupID','DNISGroup ID',10694,'DNISGroups','DNISGroupID',NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('DNISNumbers','DNISNumber','DNISNumber',10850,NULL,NULL,NULL,NULL,1,0,1,1,20,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','CustomerID','Customer ID',10018,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,1024,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','Domain','Domain',10606,NULL,NULL,NULL,NULL,1,0,1,1,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','DomainID','Domain ID',10693,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ErrorCount','Error Count',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ErrorMessage','Error Message',12427,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ExpireDate','Expire Date',10558,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ExternalDNSRef','External DNS Ref',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ExternalRef','External Reference',12355,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','GroupID','Group ID',10583,'Groups','GroupID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','MailDomain','Mail Domain',10849,NULL,NULL,NULL,13,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','ServiceGroupID','Service Group ID',11201,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Domains','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','BulkProfileID','Account Filter',12482,'BulkProfiles','BulkProfileID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','CloseDate','Close Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','Event','Event',12462,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','EventID','Event ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','EventTypeID','Event Type ID',NULL,'EventTypes','EventTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','RegionID','Region ID',10629,'Regions','RegionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','Resolution','Resolution',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Events','TowerID','Tower ID',NULL,'Towers','TowerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','EventType','Event Type',12474,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','EventTypeID','Event Type ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','IncidentCloseAuto','Incident Close Auto',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','IncidentStateID','Incident State ID',10973,'IncidentStates','IncidentStateID',NULL,NULL,1,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','IncidentTypeID','Incident Type ID',10987,'IncidentTypes','IncidentTypeID',NULL,NULL,1,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('EventTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Align','Align',10752,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','ExportColumnID','Export Column ID',10692,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','ExportID','Export ID',10591,'Exports','ExportID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','ExportValue','Export Value',10848,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','FieldName','Field Name',10847,NULL,NULL,NULL,NULL,1,0,1,1,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Format','Format',10531,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Include','Include',10754,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','MaxSize','Max Size',10658,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','MinSize','Min Size',10662,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Padding','Padding',10551,NULL,NULL,NULL,NULL,0,1,1,0,1,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','Quoted','Quoted',10710,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExportColumns','TransType','Trans Type',10762,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ApproveMatch','Approve Match',10750,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ApproveString','Approve String',10843,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','AuthMatch','Auth Match',10930,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','AuthString','Auth String',10938,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','CreditMatch','Credit Match',10932,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','CreditString','Credit String',10940,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','DeclineMatch','Decline Match',10751,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','DeclineString','Decline String',10844,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','DefaultProcessorURL','Default Processor URL',10935,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ExportID','Export ID',10591,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ExportType','Export Type',10747,'ExportTypes','ExportTypeID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Features','Features',10934,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','FileTokenLocal','File Token Local',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Filter','Filter',10840,NULL,NULL,NULL,NULL,0,1,1,0,16,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','FormatDefault','Format Default',10933,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','HeaderRow','Header Row',10749,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ImportKeySeparator','Import Key Separator',10936,NULL,NULL,NULL,NULL,0,1,1,0,6,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','ImportKeyValueSeparator','Import Key Value Separator',10937,NULL,NULL,NULL,NULL,0,1,1,0,6,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Lines','Lines',10748,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','QuoteString','Quote String',10846,NULL,NULL,NULL,NULL,0,1,1,0,6,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Retries','Retries',10120,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','RetryDelay','Retry Delay',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Separator','Separator',10845,NULL,NULL,NULL,NULL,0,1,1,0,6,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','SQLString','SQLString',10842,NULL,NULL,NULL,NULL,1,0,1,1,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','StageCount','Stages',NULL,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','Template','Template',10755,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','VoidMatch','Void Match',10931,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Exports','VoidString','Void String',10939,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemAccountTypes','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemAccountTypes','Description','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemAccountTypes','ExternalRef','External Reference',12355,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemAccountTypes','ExternalSystemID','External System ID',10887,'ExternalSystems','ExternalSystemID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemDataTypes','AccountDataTypeID','Account Data Type ID',11131,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemDataTypes','ExternalSystemTypeID','External System Type ID',11129,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemDataTypes','Required','Required',10736,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemDataTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Aux1','Custom data field 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Aux2','Custom data field 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Aux3','Custom data field 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','ExportID','Export ID',10591,'Exports','ExportID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','ExternalSystem','External System',NULL,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','ExternalSystemID','External System ID',10887,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','ExternalSystemTypeID','External System Type ID',11129,'ExternalSystemTypes','ExternalSystemTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','FileMode','File Mode',11137,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','LastSyncDate','Last Sync Date',10861,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','LogFile','Log File',11138,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Login','Login',10038,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','MailHost','Mail Host',11139,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','Password','Password',10402,NULL,NULL,NULL,NULL,0,1,1,0,32,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','PrivateKey','Private Key',NULL,NULL,NULL,NULL,NULL,0,1,1,0,4000,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystems','PublicKey','Public Key',NULL,NULL,NULL,NULL,NULL,0,1,1,0,4000,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','DescAux1','Custom field description 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','DescAux2','Custom field description 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','DescAux3','Custom field description 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ExportID','Export ID',10591,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ExternalSystemType','External System Type',11130,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ExternalSystemTypeID','External System Type ID',11129,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ShowExportID','Show Export ID',11127,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ShowLogin','Show Login',11125,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ShowMailHost','Show Mail Host',11124,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ShowPassword','Show Password',11126,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalSystemTypes','ShowURL','Show URL',11128,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AccountExpire','Account Expire',10572,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AccountNumber','Account Number',10073,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ApproveCode','Approve Code',10838,NULL,NULL,NULL,NULL,0,1,1,0,12,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AuthAddress','Auth Address',10835,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AuthName','Auth Name',10287,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AuthSecurityCode','Auth Security Code',10834,NULL,NULL,NULL,11,0,1,1,0,64,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AuthStateID','Auth State ID',11281,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AuthZip','Auth Zip',10836,NULL,NULL,NULL,NULL,0,1,1,0,15,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','AutoBill','Auto Bill',10713,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BankName','Bank Name',10074,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BankNumber','Bank Number',10075,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BankPhone','Bank Phone',10295,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BankTransType','Bank Trans Type',10833,NULL,NULL,NULL,NULL,0,1,1,0,16,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BatchID','Batch ID',11195,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BatchInID','Batch In ID',11278,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BatchOutID','Batch Out ID',11279,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BatchProcessorID','Batch Processor ID',11062,'BatchProcessors','BatchProcessorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','BirthDate','Birth Date',10854,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','DLNumber','DLNumber',10857,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','DLState','DLState',10855,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ExportDate','Export Date',11283,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ExternalTransID','External Trans ID',10690,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','InvoiceID','Invoice ID',10147,'Invoices','InvoiceID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','LastRebatchTry','Last Rebatch Try',10573,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','PaymentID','Payment ID',10651,'Payments','PaymentID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ProcDate','Proc Date',10576,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ProcTransID','Proc Trans ID',11199,NULL,NULL,NULL,NULL,0,1,1,0,40,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','RebatchTries','Rebatch Tries',10744,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','ReqDate','Req Date',10575,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','Response','Response',10837,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','SSN','SSN',10856,NULL,NULL,NULL,11,0,1,1,0,128,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','StatementID','Statement ID',10149,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','Token','Token',12618,NULL,NULL,NULL,11,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','TransStateID','Trans State ID',11280,'TransStates','TransStateID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('ExternalTrans','TransTypeID','Trans Type ID',11282,'TransTypes','TransTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','ActiveExpireDays','Active Expire Days',11238,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowAddresses','Allow Addresses',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowEvents','Allow Events',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowIncidents','Allow Incidents',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowInvoices','Allow Invoices',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowInvProducts','Allow Inv Products',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowMBR','Allow MBR',11133,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowPayments','Allow Payments',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowSA','Allow SA',11132,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowSites','Allow Sites',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowStatements','Allow Statements',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','AllowTowers','Allow Towers',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','DisplayDetail','Display Detail',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','DisplaySummary','Display Summary',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','FileCategory','File Category',12629,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','FileCategoryID','File Category ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','InactiveExpireDaysMBR','Inactive Expire Days MBR',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','InactiveExpireDaysSA','Inactive Expire Days SA',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategories','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryMimeTypes','FileCategoryID','File Category ID',NULL,'FileCategories','FileCategoryID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryMimeTypes','MimeTypeID','Mime Type ID',NULL,'MimeTypes','MimeTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','FileApplyTypeID','File Apply Type ID',NULL,'FileApplyTypes','FileApplyTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','FileCategoryID','File Category ID',NULL,'FileCategories','FileCategoryID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','FileCategoryReq','File Category Req',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','FileCategoryReqID','File Category Req ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','IncidentTypeID','Incident Type ID',10987,'IncidentTypes','IncidentTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FileCategoryReqs','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','AddressID','Address ID',11092,'Addresses','AddressID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','EventID','Event ID',NULL,'Events','EventID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','ExpireDate','Expire Date',10558,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileCategoryID','File Category ID',NULL,'FileCategories','FileCategoryID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileData','File Data',NULL,NULL,NULL,NULL,14,1,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileID','File ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileMimeType','File Mime Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileName','File Name',10462,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','FileSize','File Size',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','IncidentID','Incident ID',10033,'Incidents','IncidentID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','InvoiceID','Invoice ID',10147,'Invoices','InvoiceID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','PaymentID','Payment ID',10651,'Payments','PaymentID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','SiteID','Site ID',NULL,'Sites','SiteID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','StatementID','Statement ID',10149,'Statements','StatementID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Files','TowerID','Tower ID',NULL,'Towers','TowerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','DstPortEnding','Ending Destination Port',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','DstPortStarting','Starting Destination Port',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','DstRange','Destination Address Range',NULL,NULL,NULL,NULL,23,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','ExporterRange','Exporter Range',NULL,NULL,NULL,NULL,23,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','FlowDirectionID','Flow Direction ID',NULL,'FlowDirections','FlowDirectionID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','FlowFilterID','Flow Filter ID',10676,'FlowFilters','FlowFilterID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','FlowFilterItem','Flow Filter Item',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','FlowFilterItemID','Flow Filter Item ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','Protocol','IP Protocol',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','SrcPortEnding','Ending Source Port',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','SrcPortStarting','Starting Source Port',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilterItems','SrcRange','Source Address Range',NULL,NULL,NULL,NULL,23,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilters','DefaultAllow','Default Allow',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilters','FlowFilter','Flow Filter',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilters','FlowFilterID','Flow Filter ID',10676,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('FlowFilters','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','Forward','Forward',10830,NULL,NULL,NULL,NULL,1,0,1,1,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','ForwardID','Forward ID',10674,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Forwards','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','Color','Color',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','DwellSecs','Dwell Secs',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','GaugeAlert','Gauge Alert',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','GaugeAlertID','Gauge Alert ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','GaugeID','Gauge ID',NULL,'Gauges','GaugeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','LookbackMins','Lookback Mins',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','TriggerAbove','Trigger Above',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeAlerts','TriggerBelow','Trigger Below',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','Color','Color',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','DataLabel','Data Label',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','GaugeGroupID','Gauge Group ID',NULL,'GaugeGroups','GaugeGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','GaugeGroupItemID','Gauge Group Item ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','GaugeID','Gauge ID',NULL,'Gauges','GaugeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','IsPrimary','Is Primary',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','LineFill','Line Fill',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroupItems','Required','Required',10736,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroups','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroups','GaugeGroup','Gauge Group',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroups','GaugeGroupID','Gauge Group ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeGroups','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','ExemptAbove','Exempt Above',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','ExemptBelow','Exempt Below',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','GaugeID','Gauge ID',NULL,'Gauges','GaugeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','GaugeRollupID','Gauge Rollup ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','GaugeWindowID','Gauge Window ID',NULL,'GaugeWindows','GaugeWindowID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GaugeRollups','RollupDays','Rollup Days',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','Color','Color',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','DataLabel','Data Label',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','Gauge','Gauge',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','GaugeConversionID','Gauge Conversion ID',NULL,'GaugeConversions','GaugeConversionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','GaugeID','Gauge ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','GaugeSourceID','Gauge Source ID',NULL,'GaugeSources','GaugeSourceID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','GaugeWindowID','Gauge Window ID',NULL,'GaugeWindows','GaugeWindowID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Gauges','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Aux1','Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Aux2','Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Aux3','Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Aux4','Aux 4',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Aux5','Aux 5',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','CountryID','Country ID',11051,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','ExportID','Export ID',10591,'Exports','ExportID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Geocoder','Geocoder',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','GeocoderID','Geocoder ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Login','Login',10038,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','Password','Password',10402,NULL,NULL,NULL,29,0,1,1,0,200,0,0,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','ProcessorURL','Processor URL',11068,NULL,NULL,NULL,NULL,1,0,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Geocoders','StateID','State ID',11120,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','DescAux1','Desc Aux 1',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','DescAux2','Desc Aux 2',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','DescAux3','Desc Aux 3',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','DescAux4','Desc Aux 4',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','DescGeoShape','Desc Geo Shape',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','GeoLayer','Geo Layer',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','GeoLayerID','Geo Layer ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GeoLayers','Status','Status',10046,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GLCodes','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,1,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GLCodes','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GLCodes','GLCode','GLCode',10828,NULL,NULL,NULL,NULL,1,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('GLCodes','GLCodeID','GLCode ID',10584,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','AutoEmailInvoices','Auto Email Invoices',11301,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','AutoEmailStatements','Auto Email Statements',11300,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillAddress1','Bill Address 1',11115,NULL,NULL,NULL,NULL,1,0,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillAddress2','Bill Address 2',11116,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillCity','Bill City',11117,NULL,NULL,NULL,NULL,1,0,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillCountryID','Bill Country ID',11101,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillFax','Bill Fax',11303,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillName','Bill Name',11114,NULL,NULL,NULL,NULL,1,0,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillPhone','Bill Phone',11304,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillProvince','Bill Province',11118,NULL,NULL,NULL,NULL,0,1,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillState','Bill State',10373,NULL,NULL,NULL,NULL,1,0,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillTaxID','Bill Tax ID',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','BillZip','Bill Zip',11119,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','DomainID','Domain ID',10693,'Domains','DomainID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','EmailAccounts','Email Accounts',11105,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','EmailSubject','Email Subject',11106,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','EndDate','End Date',10519,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalAccountTypes','Global Account Types',11160,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalBillingCycles','Global Billing Cycles',11159,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalChargeTypes','Global Charge Types',11164,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalDomains','Global Domains',11158,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalIncidentTypes','Global Incident Types',11362,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalPayPeriods','Global Pay Periods',11163,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalRegions','Global Regions',11161,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalSalesPersons','Global Sales Persons',11162,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GlobalSendMethods','Global Send Methods',11221,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GroupID','Group ID',10583,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','GroupName','Group Name',10817,NULL,NULL,NULL,NULL,1,0,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','InvoiceHTMLReport','Invoice HTMLReport',11110,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','InvoiceReport','Invoice Report',11108,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','InvoiceTextReport','Invoice Text Report',11109,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','MaxAccounts','Max Accounts',11103,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','MaxServices','Max Services',11104,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','OrganizationID','Organization ID',11046,'Organizations','OrganizationID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','PartialPmtExtDays','Partial Pmt Ext Days',11099,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','PartialPmtExtOption','Partial Pmt Ext Option',11098,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','PaymentTypes','Payment Types',11175,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','PrintInvoices','Print Invoices',NULL,NULL,NULL,NULL,NULL,0,1,0,NULL,NULL,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','PrintStatements','Print Statements',NULL,NULL,NULL,NULL,NULL,0,1,0,NULL,NULL,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','ReceiptReport','Receipt Report',NULL,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','ReportLogoURL','Report Logo URL',11302,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','StatementHTMLReport','Statement HTMLReport',11113,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','StatementReport','Statement Report',11111,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','StatementTextReport','Statement Text Report',11112,NULL,NULL,NULL,NULL,0,1,1,0,45,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','ThemeID','Theme ID',10923,'Themes','ThemeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Groups','ThemeScore','Theme Score',11102,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IMTypes','IMType','IMType',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IMTypes','IMTypeID','IMType ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IMTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IMTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IMTypes','URI','URI',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentData','IncidentDataTypeID','Incident Data Type ID',10876,'IncidentDataTypes','IncidentDataTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentData','IncidentID','Incident ID',10033,'Incidents','IncidentID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','DataTypeID','Data Type ID',10988,'DataTypes','DataTypeID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','IncidentDataType','Field Name',10847,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','IncidentDataTypeID','Incident Data Type ID',10876,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','IncidentTemplateID','Incident Configuration',NULL,'IncidentTemplates','IncidentTemplateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','IncidentTypeID','Incident Type ID',10987,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','RegExp','Validation RegExp',NULL,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','Required','Field Required',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','Searchable','Searchable',10989,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentDataTypes','SQLQuery','SQL Query',11570,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','AssignOperatorID','Assign Operator ID',10884,'Operators','OperatorID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','AssignRoleID','Assign Role ID',10883,'Roles','RoleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','CreateAccountID','Create Account ID',10881,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','CreateOperatorID','Create Operator ID',10880,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','DueDate','Due Date',10473,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','Duration','Time / Duration',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','Email','Email',10188,NULL,NULL,NULL,6,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','EventID','Event ID',NULL,'Events','EventID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','IncidentID','Incident ID',10033,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','IncidentStateID','Incident State',10879,'IncidentStates','IncidentStateID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','IncidentTypeID','Incident Type',10878,'IncidentTypes','IncidentTypeID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','PriorityID','Priority',10314,'Priorities','PriorityID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','SchedBlockID','Sched Block ID',NULL,'SchedBlocks','SchedBlockID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','SchedDate','Sched Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Incidents','Summary','Summary',10315,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStateGroups','IncidentStateGroup','Incident State Group',10976,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStateGroups','IncidentStateGroupID','Incident State Group ID',10974,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','IncidentState','Incident State',10879,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','IncidentStateGroupID','Incident State Group ID',10974,'IncidentStateGroups','IncidentStateGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','IncidentStateID','Incident State ID',10973,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','Priority','Priority',10314,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','StatArchive','Stat Archive',10972,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','StatBlock','Stat Block',10971,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','StatEscalate','Stat Escalate',10970,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','StatOpen','Stat Open',10968,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','StatWait','Stat Wait',10969,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentStates','Style','Style',10975,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','CustIncidentEdit','Cust Incident Edit',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','CustIncidentSave','Cust Incident Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','IncidentEdit','Incident Edit',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','IncidentSave','Incident Save',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','IncidentTemplate','Incident Template',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','IncidentTemplateID','Incident Template ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTemplates','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypeFileCategories','FileCategoryID','File Category ID',NULL,'FileCategories','FileCategoryID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypeFileCategories','IncidentTypeID','Incident Type ID',10987,'IncidentTypes','IncidentTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','CustomerAccess','Customer Access',10877,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','Description','Description',10050,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','Email','Email',10188,NULL,NULL,NULL,6,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','EnableOperatorRole','Enable Operator Role',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','EscalateDays','Escalate Days',10978,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','EscalateMins','Escalate Mins',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','IncidentStateGroupID','Incident State Group ID',10974,'IncidentStateGroups','IncidentStateGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','IncidentType','Incident Type',10878,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','IncidentTypeID','Incident Type ID',10987,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','OverDays','Over Days',10977,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','OverMins','Over Mins',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','RoleID','Role ID',10986,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','SchedBlockTypeID','Sched Block Type ID',NULL,'SchedBlockTypes','SchedBlockTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','SchedLimitDays','Sched Limit Days',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','SchedMinDays','Sched Min Days',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowAssignOperator','Show Assign Operator',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowCustDueDate','Show Cust Due Date',11214,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowCustomerAccess','Show Customer Access',10984,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowDueDate','Show Due Date',10983,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowDuration','Show Duration',10982,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowEmail','Show Email',10981,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowPriority','Show Priority',10980,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','ShowSummary','Show Summary',10985,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','TimeUnits','Time Units',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','WarnDays','Warn Days',10979,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentTypes','WarnMins','Warn Mins',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentValues','IncidentDataTypeID','Incident Data Type ID',10876,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentValues','NumValue','Num Value',10886,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IncidentValues','ValueName','Value Name',10756,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InfoBarOperators','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InfoBarOperators','InfoBarID','Info Bar ID',NULL,'InfoBars','InfoBarID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InfoBarOperators','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAccountTypes','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAccountTypes','AutoAssign','Auto Assign',12467,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAccountTypes','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAccountTypes','Required','Required',10736,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','IEAID','IEAID',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','InvAttribute','Inv Attribute',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','InvAttributeID','Inv Attribute ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','InvAttrMapID','Inv Attr Map ID',NULL,'InvAttrMaps','InvAttrMapID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','InvLevelTypeID','Inv Level Type ID',NULL,'InvLevelTypes','InvLevelTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','ServiceAccess','Service Access',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvAttributes','ShowSearchResult','Show Search Result',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCartItems','CreateInvStateID','Initial Item State',NULL,'InvStates','InvStateID',NULL,NULL,0,1,0,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCartItems','CreateInvWarehouseID','Initial Warehouse Assignment',NULL,'InvWarehouses','InvWarehouseID',NULL,NULL,0,1,0,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCartItems','InvCartID','Cart ID',NULL,'InvCarts','InvCartID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCartItems','InvItemID','Item ID',10586,'InvItems','InvItemID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','InvCart','Cart Description',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','InvCartID','Cart ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCarts','OperatorID','Operator ID',10652,'Operators','OperatorID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCategories','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCategories','InvCategory','Inv Category',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCategories','InvCategoryID','Inv Category ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCategories','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvCategories','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItemData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,2048,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItemData','InvAttributeID','Inv Attribute ID',NULL,'InvAttributes','InvAttributeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItemData','InvItemID','Inv Item ID',NULL,'InvItems','InvItemID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItemData','InvValueID','Inv Value ID',NULL,'InvValues','InvValueID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','AssignDate','Assign Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','AssignUser','Assign User',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','Cost','Customer Cost',11343,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','InvItemID','Inv Item ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','InvStateID','Inv State ID',NULL,'InvStates','InvStateID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','InvWarehouseID','Inv Warehouse ID',NULL,'InvWarehouses','InvWarehouseID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','IPGroupID','IPGroup ID',10644,'IPGroups','IPGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','IPRangeID','IPRange ID',NULL,'IPRanges','IPRangeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','ItemID','Item ID',10586,'InvoiceItems','ItemID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','RecvDate','Recv Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','ReturnDate','Return Date',12367,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','SerialNumber','Serial Number',12340,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','ShipDate','Ship Date',12366,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','SupplierCost','Supplier Cost',12373,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvItems','TrackNumber','Track Number',NULL,NULL,NULL,NULL,NULL,0,1,1,0,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','AllowBulk','Allow Bulk',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','DefaultData','Default Data',11141,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','DefaultInvValueID','Default Value',11385,'InvValues','InvValueID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvAttributeID','Inv Attribute ID',NULL,'InvAttributes','InvAttributeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvCategoryID','Inv Category ID',NULL,'InvCategories','InvCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvLevelAttributeID','Inv Level Attribute ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvSourceID','Inv Source ID',NULL,'InvSources','InvSourceID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','InvSubCategoryID','Inv Sub Category ID',NULL,'InvSubCategories','InvSubCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','RegExp','Reg Exp',NULL,NULL,NULL,NULL,28,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','Required','Required',10736,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvLevelAttributes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','AccountID','Account ID',10034,'SubAccounts','AccountID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','AccountTypeID','Account Type',10588,'AccountTypes','AccountTypeID',NULL,21,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','BaseAmount','Base Amount',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','ChargeID','Charge ID',10589,'Charges','ChargeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','ChargeTypeID','Charge Type',10585,'ChargeTypes','ChargeTypeID',NULL,21,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','Days','Days',10227,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,200,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','EndDate','End Date',10519,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','GLState','GLState',10733,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','InvItemID','Inv Item ID',NULL,'InvItems','InvItemID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','InvoiceID','Invoice ID',10147,'Invoices','InvoiceID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','ItemID','Item ID',10586,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','ItemType','Item Type',10673,'InvoiceItemTypes','InvoiceItemTypeID',NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','LateCharge','Late Charge',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','Login','Login',10038,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','PaidAmount','Paid Amount',10522,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','PaidFlag','Paid Flag',11288,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','Quantity','Quantity',10520,NULL,NULL,NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','StartDate','Start Date',10518,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','TaxGroupID','Tax Group ID',10897,'TaxGroups','TaxGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceItems','TaxID','Tax ID',10672,'Taxes','TaxID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','BatchID','Batch ID',11195,'Batches','BatchID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','ChargeAmount','Charge Amount',11298,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,100,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','EmailBatchID','Email Batch ID',11293,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','EmailDate','Email Date',11296,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','Estimate','Estimate',11290,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','ETransBatchID','ETrans Batch ID',11292,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','ExtInvoiceNum','Ext Invoice Num',NULL,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','InvoiceID','Invoice ID',10147,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','InvoiceTypeID','Invoice Type ID',10671,'InvoiceTypes','InvoiceTypeID',NULL,10,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PaidAmount','Paid Amount',10522,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PayPlanID','Pay Plan ID',NULL,'PayPlans','PayPlanID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PayPlanStartDate','Pay Plan Start Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PO','PO',11299,NULL,NULL,NULL,NULL,0,1,1,0,25,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PrintBatchID','Print Batch ID',11291,'Batches','BatchID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','PrintDate','Print Date',11295,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','Processed','Processed',10746,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','StatementID','Statement ID',10149,'Statements','StatementID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','Tax','Tax',10514,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','VoidDate','Void Date',11297,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Invoices','VoidStatementID','Void Statement ID',11294,'Statements','StatementID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceTypes','InvoiceType','Invoice Type',10827,NULL,NULL,NULL,NULL,1,0,1,1,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvoiceTypes','InvoiceTypeID','Invoice Type ID',10671,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProductData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,2048,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProductData','InvAttributeID','Inv Attribute ID',NULL,'InvAttributes','InvAttributeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProductData','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProductData','InvValueID','Inv Value ID',NULL,'InvValues','InvValueID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','CloseInvStateID','Service Assigned Closed State',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','Cost','Customer Cost',11343,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','EAN','EAN',12341,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','H','H',NULL,NULL,NULL,NULL,27,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','InvCategoryID','Inv Category ID',NULL,'InvCategories','InvCategoryID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','InvProductID','Inv Product ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','InvSourceID','Inv Source ID',NULL,'InvSources','InvSourceID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','InvSubCategoryID','Inv Sub Category ID',NULL,'InvSubCategories','InvSubCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','L','L',NULL,NULL,NULL,NULL,27,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','ModelNumber','Model Number',12343,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','OrderInfo','Order Info',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','SerialNumberRegExp','Serial Number Reg Exp',NULL,NULL,NULL,NULL,28,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','SKU','SKU',12342,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','SupplierCost','Supplier Cost',12373,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','SupplierSKU','Supplier SKU',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','Title','Title',10767,NULL,NULL,NULL,NULL,1,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','W','W',NULL,NULL,NULL,NULL,27,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvProducts','Weight','Weight',NULL,NULL,NULL,NULL,26,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSources','InvSource','Inv Source',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSources','InvSourceID','Inv Source ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSources','InvSourceTypeID','Inv Source Type ID',NULL,'InvSourceTypes','InvSourceTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSources','InvStateGroupID','Inv State Group ID',NULL,'InvStateGroups','InvStateGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStateGroups','AssignInvStateID','Assign Inv State ID',NULL,'InvStates','InvStateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStateGroups','InvStateGroup','Inv State Group',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStateGroups','InvStateGroupID','Inv State Group ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStateGroups','POSInvStateID','POSInv State ID',NULL,'InvStates','InvStateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','InvReserveTypeID','Inv Reserve Type ID',NULL,'InvReserveTypes','InvReserveTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','InvState','Inv State',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','InvStateGroupID','Inv State Group ID',NULL,'InvStateGroups','InvStateGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','InvStateID','Inv State ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','InvStateTypeID','Inv State Type ID',NULL,'InvStateTypes','InvStateTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvStates','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','InvCategoryID','Inv Category ID',NULL,'InvCategories','InvCategoryID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','InvSubCategory','Inv Sub Category',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','InvSubCategoryID','Inv Sub Category ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvSubCategories','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','Data','Data',10757,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','InvAttributeID','Inv Attribute ID',NULL,'InvAttributes','InvAttributeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','InvValueID','Inv Value ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','RadData','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvValues','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroupItems','InvWarehouseGroupID','Warehouse Group ID',NULL,'InvWarehouseGroups','InvWarehouseGroupID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroupItems','InvWarehouseID','Warehouse ID',NULL,'InvWarehouses','InvWarehouseID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','InvWarehouseGroup','Warehouse Group',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','InvWarehouseGroupID','Warehouse Group ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','PrimaryInvWarehouseID','Primary Warehouse ID',NULL,'InvWarehouses','InvWarehouseID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseGroups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','InvWarehouseID','Inv Warehouse ID',NULL,'InvWarehouses','InvWarehouseID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','Location','Location',10912,NULL,NULL,NULL,NULL,0,1,1,0,1024,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','ReorderQty','Reorder Qty',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouseProducts','TargetQty','Target Qty',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','InvWarehouse','Inv Warehouse',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','InvWarehouseID','Inv Warehouse ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','SiteID','Site ID',NULL,'Sites','SiteID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('InvWarehouses','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributes','IPAttribute','IPAttribute',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributes','IPAttributeID','IPAttribute ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributes','IPAttributeTypeID','IPAttribute Type ID',NULL,'IPAttributeTypes','IPAttributeTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributeTypes','IPAttributeType','IPAttribute Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributeTypes','IPAttributeTypeID','IPAttribute Type ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPAttributeTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPGroups','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPGroups','IPAddressTypeID','IPAddress Type ID',NULL,'IPAddressTypes','IPAddressTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPGroups','IPGroup','IPGroup',10796,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPGroups','IPGroupID','IPGroup ID',10644,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPGroups','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','InvProductID','Inv Product ID',NULL,'InvProducts','InvProductID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','InvStateID','Inv State ID',NULL,'InvStates','InvStateID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','IPGroupID','IPGroup ID',10644,'IPGroups','IPGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','IPInvAllocation','IPInv Allocation',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','IPInvAllocationID','IPInv Allocation ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','PrefixLength','Prefix Length',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocations','TargetQty','Target Qty',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocReqs','IPAttributeID','IPAttribute ID',NULL,'IPAttributes','IPAttributeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocReqs','IPInvAllocationID','IPInv Allocation ID',NULL,'IPInvAllocations','IPInvAllocationID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocReqs','IPInvAllocReqID','IPInv Alloc Req ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPInvAllocReqs','IPRangeID','IPRange ID',NULL,'IPRanges','IPRangeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRangeAttributes','IPAttributeID','IPAttribute ID',NULL,'IPAttributes','IPAttributeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRangeAttributes','IPRangeID','IPRange ID',NULL,'IPRanges','IPRangeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','IPGroupID','IPGroup ID',10644,'IPGroups','IPGroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','IPRange','IPRange',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','IPRangeID','IPRange ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','IPRangeTypeID','IPRange Type ID',NULL,'IPRangeTypes','IPRangeTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRanges','PriorityID','Priority ID',10966,'Priorities','PriorityID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRangeTypes','IPRangeType','IPRange Type',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('IPRangeTypes','IPRangeTypeID','IPRange Type ID',NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','AllowIEAUpdate','Allow IEAUpdate',11369,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,30,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','HttpAcceptLanguage','Http Accept Language',11371,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','LanguageID','Language ID',10650,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Languages','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeChargeTypes','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeChargeTypes','LateFeeID','Late Fee ID',11224,'LateFees','LateFeeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeDays','Amount','Amount',10078,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeDays','LateFeeDayID','Late Fee Day ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeDays','LateFeeID','Late Fee ID',11224,'LateFees','LateFeeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeDays','OverAmount','Over Amount',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeDays','OverDays','Over Days',10977,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','GraceDays','Grace Days',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','LateFee','Late Fee',11225,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','LateFeeID','Late Fee ID',11224,'LateFees','LateFeeID',NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','LateFeeTypeID','Late Fee Type ID',NULL,'LateFeeTypes','LateFeeTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','MaxAmount','Max Amount',11227,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','MaxDays','Max Days',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','MinAmount','Min Amount',11226,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','PriorityID','Priority ID',10966,'Priorities','PriorityID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFees','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeServiceCats','LateFeeID','Late Fee ID',11224,'LateFees','LateFeeID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LateFeeServiceCats','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LDAPServers','Calls','Calls',10617,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LDAPServers','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LDAPServers','LastSyncRead','Last Sync Read',10569,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LDAPServers','LastSyncWrite','Last Sync Write',10570,NULL,NULL,NULL,7,1,0,1,1,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LDAPServers','LDAPServer','LDAPServer',10824,NULL,NULL,NULL,NULL,1,0,1,1,50,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Licenses','Company','Company',10025,NULL,NULL,NULL,NULL,1,0,1,1,80,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Licenses','LicenseID','License ID',10823,NULL,NULL,NULL,NULL,1,0,1,1,50,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LogMsgs','Description','Description',10050,NULL,NULL,NULL,NULL,0,0,1,0,50,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LogMsgs','LogMsgID','Log Msg ID',10597,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('LogMsgs','Severity','Severity',10642,NULL,NULL,NULL,10,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketCategories','MarketCategory','Market Category',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketCategories','MarketCategoryID','Market Category ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketCategories','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketCategories','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','Data','Data',10757,NULL,NULL,NULL,NULL,1,0,1,0,4000,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','MarketTagAttributeID','Market Tag Attribute ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','Parent','Parent',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','RadAttributeID','Attribute ID',10872,'RadAttributes','RadAttributeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','RadMergeTypeID','Merge Type ID',10870,'RadMergeTypes','RadMergeTypeID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','RadVendorID','Vendor ID',10632,NULL,NULL,NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','SortOrder','Sort Order',10582,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagAttributes','Tag','Tag',10875,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','DstMarketTagGroupID','Dst Market Tag Group ID',NULL,'MarketTagGroups','MarketTagGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','DstMarketTagID','Dst Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','MarketTagCondition','Market Tag Condition',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','MarketTagConditionID','Market Tag Condition ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','MarketTagCondTypeID','Market Tag Cond Type ID',NULL,'MarketTagCondTypes','MarketTagCondTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagConditions','SrcMarketTagID','Src Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagGroupItems','MarketTagGroupID','Market Tag Group ID',NULL,'MarketTagGroups','MarketTagGroupID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagGroupItems','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagGroups','MarketTagGroup','Market Tag Group',NULL,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTagGroups','MarketTagGroupID','Market Tag Group ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AccessLabelID','Access Label ID',NULL,'AccessLabels','AccessLabelID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AccessTime','Access Time',NULL,NULL,NULL,NULL,22,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AccountTypeID','Account Type ID',10610,'AccountTypes','AccountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AddressCategoryID','Address Category ID',NULL,'AddressCategories','AddressCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AddressData','Address Data',NULL,NULL,NULL,NULL,NULL,0,1,1,0,512,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AddressDataTypeID','Address Data Type ID',NULL,'AddressDataTypes','AddressDataTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AllowAccessTime','Allow Access Time',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AllowInvoicedDaysMax','Allow Invoiced Days Max',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','AllowServiceCost','Allow Service Cost',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','BillingCycleID','Billing Cycle ID',10596,'BillingCycles','BillingCycleID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CancelChargeInvoicedMonths','Cancel Charge Invoiced Months',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CancelChargeTypeID','Cancel Charge Type ID',NULL,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CancelPeriodMonthsMin','Cancel Period Months Min',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CancelServiceLevelMin','Cancel Service Level Min',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ChargeTypeID','Charge Type ID',10587,'ChargeTypes','ChargeTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','City','City',10290,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CopyServiceCost','Copy Service Cost',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CopyServiceLevel','Copy Service Level',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','Cost','Cost',10228,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CountryID','Country ID',11051,'Countries','CountryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CreatedAfter','Created After',12309,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CreatedBefore','Created Before',12308,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','CustomerHidden','Customer Hidden',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','DiscountID','Discount ID',10695,'Discounts','DiscountID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','EndDate','End Date',10519,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','Hidden','Hidden',11048,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','InvoicedDaysMax','Invoiced Days Max',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketCategoryID','Market Category ID',NULL,'MarketCategories','MarketCategoryID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketServiceCountTypeID','Market Service Count Type ID',NULL,'MarketServiceCountTypes','MarketServiceCountTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketTag','Market Tag',12213,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketTagAutoTypeID','Market Tag Auto Type ID',NULL,'MarketTagAutoTypes','MarketTagAutoTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketTagCancelTypeID','Market Tag Cancel Type ID',NULL,'MarketTagCancelTypes','MarketTagCancelTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MarketTagID','Market Tag ID',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','MinServiceLevel','Min Service Level',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ParentServiceCategoryID','Parent Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','PaymentTypeID','Payment Type ID',10648,'PaymentTypes','PaymentTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','PayPeriodID','Pay Period ID',10647,'PayPeriods','PayPeriodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','PromoCodeID','Promo Code ID',NULL,'PromoCodes','PromoCodeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','RegionID','Region ID',10629,'Regions','RegionID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','SendMethodID','Send Method ID',11234,'SendMethods','SendMethodID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceCategoryID','Service Category ID',NULL,'ServiceCategories','ServiceCategoryID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceCountMax','Service Count Max',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceCountMin','Service Count Min',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceCountTotalMax','Service Count Total Max',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceCountTotalMin','Service Count Total Min',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceGroupID','Service Group ID',11201,'ServiceGroups','ServiceGroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceLevelTypeID','Service Level Type ID',NULL,'ServiceLevelTypes','ServiceLevelTypeID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceMonthsMax','Service Months Max',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','ServiceMonthsMin','Service Months Min',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','StateID','State ID',11120,'States','StateID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MarketTags','Zip','Zip',10077,NULL,NULL,NULL,NULL,0,1,1,0,20,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountData','AccountDataTypeID','Account Data Type ID',11131,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountData','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountData','Data','Data',10757,NULL,NULL,NULL,NULL,0,1,1,0,512,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','AccountDataTypeID','Account Data Type ID',11131,'AccountDataTypes','AccountDataTypeID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','MasterAccountDataTypeID','Master Account Data Type ID',11142,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','Required','Field Required',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','ServiceGroupID','Service Group',11213,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountDataTypes','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','Balance','Balance',10160,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','BillDay','Bill Day',10593,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','BillingAddressID','Billing Address ID',NULL,'Addresses','AddressID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','BillingCycleID','Billing Cycle ID',10596,'BillingCycles','BillingCycleID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','BillMonth','Bill Month',12625,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CancelDate','Cancel Date',10342,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CancelReasonID','Cancel Reason ID',10663,'CancelReasons','CancelReasonID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','Comments','Comments',10181,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CreditLimit','Credit Limit',11699,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','CustomerID','Customer ID',10018,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','ExternalRef','External Ref',12372,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','GroupID','Group ID',10583,'Groups','GroupID',NULL,NULL,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','LanguageID','Language ID',10650,'Languages','LanguageID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','LastModifyDate','Last Modify Date',10553,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','LastModifyUser','Last Modify User',10758,NULL,NULL,NULL,NULL,0,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','LastReceived','Last Received',10568,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','LastStatementID','Last Statement ID',10668,'Statements','StatementID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','PaymentTypeID','Payment Type ID',10648,'PaymentTypes','PaymentTypeID',NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','PayPeriodID','Pay Period ID',10647,'PayPeriods','PayPeriodID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','PendingBalance','Pending Balance',11340,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','PIN','Personal Identification Number',NULL,NULL,NULL,NULL,10,0,1,0,0,10,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','PO','Standing Purchase Order',NULL,NULL,NULL,NULL,NULL,0,1,1,0,25,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','ReferredByID','Referred By ID',10929,'ReferredBys','ReferredByID',NULL,20,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','RegionID','Region ID',10629,'Regions','RegionID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','SalesPersonID','Sales Person ID',10627,'SalesPersons','SalesPersonID',NULL,21,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','SendMethodID','Send Method ID',11234,'SendMethods','SendMethodID',NULL,21,1,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','ServiceAddressID','Service Address ID',NULL,'Addresses','AddressID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','ShippingAddressID','Shipping Address ID',NULL,'Addresses','AddressID',NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','StartDate','Start Date',10518,NULL,NULL,NULL,7,0,0,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','TaxExemptions','Tax Exemptions',11184,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','TempExtension','Temp Extension',11662,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccounts','TransHoldDate','Trans Hold Date',NULL,NULL,NULL,NULL,7,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountTags','Active','Active',10222,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountTags','CreateDate','Create Date',10484,NULL,NULL,NULL,7,0,0,1,0,0,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountTags','CreateUser','Create User',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,1,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountTags','CustomerID','Customer ID',10018,'MasterAccounts','CustomerID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MasterAccountTags','MarketTagID','Market Tag ID',NULL,'MarketTags','MarketTagID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Access','Access',10953,NULL,NULL,NULL,NULL,0,1,1,0,16,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','AccessKey','Access Key',10949,NULL,NULL,NULL,NULL,0,1,1,0,5,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Attribute','Attribute',10839,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','ColumnName','Column Name',10818,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Condition','Condition',10954,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','DescStringID','Desc String ID',10947,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','FeatureID','Feature',10577,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','FileName','File Name',10462,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','HelpStringID','Help String ID',10948,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Label','Label',10952,NULL,NULL,NULL,NULL,1,0,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','LabelName','Label Name',NULL,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','Link','Link',10950,NULL,NULL,NULL,NULL,1,0,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','MenuItem','Menu Item',10951,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','MenuItemID','Menu Item ID',10946,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','SectionObject','Section Object',NULL,NULL,NULL,NULL,NULL,0,1,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuItems','TableName','Table Name',10942,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Menus','Class','Class',10945,NULL,NULL,NULL,NULL,0,1,1,0,64,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Menus','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Menus','Menu','Menu',10944,NULL,NULL,NULL,NULL,1,0,1,0,128,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('Menus','MenuID','Menu ID',10943,NULL,NULL,NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuSets','GroupID','Group ID',10583,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuSets','MenuID','Menu ID',10943,'Menus','MenuID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuSets','MenuItemID','Menu Item ID',10946,'MenuItems','MenuItemID',NULL,NULL,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MenuSets','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','AddOnly','Add Only',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','AllowAudit','Allow Audit',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','CheckQuery','Check Query',NULL,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','ColumnName','Column Name',10818,NULL,NULL,NULL,NULL,1,0,1,1,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','ColumnType','Column Type',10659,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','DepColumn','Dep Column',10816,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','DepGroup','Dep Group',10661,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','DepTable','Dep Table',10819,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,1,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','HelpText','Help Text',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','IsKey','Is Key',10734,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','MaxSize','Max Size',10658,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','MetaColumnID','Meta Column ID',10664,NULL,NULL,NULL,10,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','MetaRuleID','Meta Rule ID',10660,'MetaRules','MetaRuleID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','MetaTableID','Meta Table ID',10665,'MetaTables','MetaTableID',NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','MinSize','Min Size',10662,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','Nullable','Nullable',10737,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','Quoted','Quoted',10710,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','RegExp','Reg Exp',NULL,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','Required','Required',10736,NULL,NULL,NULL,10,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaColumns','StringID','String ID',10967,NULL,NULL,NULL,NULL,0,1,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaRules','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaRules','MetaRuleID','Meta Rule ID',10660,NULL,NULL,NULL,10,1,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','AllowAudit','Allow Audit',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','Auditable','Auditable',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','Description','Description',10050,NULL,NULL,NULL,NULL,1,0,1,0,255,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','GroupName','Group Name',10817,NULL,NULL,NULL,NULL,0,1,1,0,15,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','GroupTable','Group Table',NULL,NULL,NULL,NULL,NULL,0,1,1,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','LabelTable','Label Table',NULL,NULL,NULL,NULL,NULL,0,1,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','MetaTableID','Meta Table ID',10665,NULL,NULL,NULL,NULL,0,0,0,0,0,1,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','SortOrder','Sort Order',10582,NULL,NULL,NULL,31,0,0,0,0,0,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MetaTables','TableName','Table Name',10942,NULL,NULL,NULL,NULL,1,0,1,0,32,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MimeTypes','Description','Description',10050,NULL,NULL,NULL,NULL,0,1,1,0,256,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MimeTypes','Extension','Extension',10609,NULL,NULL,NULL,NULL,0,1,1,0,256,0,1,0,NULL,NULL,NULL)}
go
{CALL CT_MetaColumns('MimeTypes','IsImage','Is Image',NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,1,0,NULL,N