CREATE PROCEDURE dbo.QmailGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'disabled' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'nopop'
	WHEN ma.OverLimit > 0 THEN 'active'
	WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'nopop'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'nopop'
	ELSE 'active'
	END
END AS accountStatus,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,

CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress,
'./' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mailMessageStore,
CASE WHEN fw.Forward IS NULL THEN 'noforward' ELSE 'nolocal' END AS deliveryMode

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ''
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

CREATE PROCEDURE dbo.QmailFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> '' OR sa.Email <> '')
	AND sa.Password <> ''
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.Name = @id
GO

-- Permissions
GRANT EXECUTE ON QmailFullNegSync TO Emerald
GRANT EXECUTE ON QmailGetPartial TO Emerald
GO
