CREATE PROCEDURE dbo.NSFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND (sa.Login <> '' OR sa.Email <> '')
	AND sa.Password <> ''
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.NSGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x500uniqueIdentifier,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
'mailbox' AS mailDeliveryOption,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS inetuserstatus,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS mailuserstatus,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS rfc822mailbox,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.Password <> ''
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
GO

GRANT EXECUTE ON NSFullNegSync TO Emerald
GRANT EXECUTE ON NSGetPartial TO Emerald
go
