CREATE PROCEDURE dbo.PosixGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
-- Read & Set Last Retreive Date
DECLARE @lmdate DATETIME, @calls INT, @pasid INT, @pasuid INT, @accountid INT, @uid INT
EXEC LDAPSetLastModifyDate 'read', @id
SELECT @lmdate = LastSyncWrite, @calls = Calls
FROM LDAPServers
	WHERE LDAPServer = @id

-- Find the lowest avaliable uidNumber and assign it.

-- Starting UID
SELECT @uid = 1000
IF NOT EXISTS (SELECT * FROM PosixAccountUIDs WHERE LDAPServer = @id)
BEGIN
WHILE(@uid < 65535)
	BEGIN
	INSERT INTO PosixAccountUIDs (uidNumber,PosixAccountUserID,LDAPServer) VALUES(@uid,NULL,@id)
	SELECT @uid = @uid + 1
	END
END

DECLARE onebyone CURSOR FOR
SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, PosixAccountServers pas
	WHERE sa.CustomerID = ma.CustomerID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau2, PosixAccountUIDs pai2 WHERE AccountID = sa.AccountID AND pau2.PosixAccountUserID = pai2.PosixAccountUserID AND pai2.LDAPServer = @id)
	AND sa.AccountTypeID = pas.AccountTypeID
	AND pas.LDAPServer = @id
	AND sa.Password <> ''
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)

OPEN onebyone
FETCH NEXT FROM onebyone INTO @accountid
WHILE(@@FETCH_STATUS <> -1)
BEGIN
SELECT @uid = NULL, @pasuid = NULL, @pasid = NULL

SELECT @uid = MIN(uidNumber) FROM PosixAccountUIDs
	WHERE PosixAccountUserID IS NULL
	AND LDAPServer = @id

SELECT @pasid = PosixAccountServerID
FROM PosixAccountServers pas, SubAccounts sa
	WHERE sa.AccountID = @accountid
	AND pas.AccountTypeID = sa.AccountTypeID

INSERT INTO PosixAccountUsers (PosixAccountServerID,AccountID)
	VALUES(@pasid,@accountid)

SELECT @pasuid = PosixAccountUserID FROM PosixAccountUsers
	WHERE AccountID = @accountid

IF (@pasuid IS NOT NULL)
SELECT @uid = uidNumber FROM PosixAccountUIDs
	WHERE PosixAccountUserID = @pasuid
	AND LDAPServer = @id

UPDATE PosixAccountUIDs
	SET PosixAccountUserID = @pasuid
		WHERE uidNumber = @uid
		AND LDAPServer = @id

IF NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau, PosixAccountUIDs pai
		WHERE pai.PosixAccountUserID = pau.PosixAccountUserID)
BEGIN
RAISERROR('UID Assignment Failed. Make sure all 65535 UIDs are not in use',10,1,50000)
END

FETCH NEXT FROM onebyone INTO @accountid
END
CLOSE onebyone
DEALLOCATE onebyone

-- Periodically remove deleted entries to free up uids.
IF @calls % 50 = 0
BEGIN
DELETE FROM PosixAccountUsers
FROM PosixAccountUsers pau
WHERE NOT EXISTS (SELECT 1 FROM SubAccounts sa, MasterAccounts ma WHERE sa.AccountID = pau.AccountID AND ma.CustomerID = sa.CustomerID AND ma.Active IN (1,0) AND sa.Active IN (1,0))

UPDATE pai SET PosixAccountUserID = NULL
FROM PosixAccountUIDs pai
	WHERE NOT EXISTS (SELECT 1 FROM PosixAccountUsers WHERE PosixAccountUserID = pai.PosixAccountUserID)
	AND PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
END

-- Output Query Result
SELECT DISTINCT sa.AccountID as accountid, pai.uidNumber AS uidnumber,
shadowexpire = CASE
	WHEN ma.Active = 0 OR sa.Active = 0 OR p.Active = 0 THEN 1
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 1
	WHEN ma.CancelDate < getdate() THEN 1
	WHEN ma.OverLimit > 0 THEN NULL
	WHEN sa.ExpireDate IS NULL THEN
		DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate))
	ELSE 
		DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate))
END,
rfc822mailbox = CASE WHEN al.Alias IS NOT NULL THEN NULL ELSE COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) END,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
COALESCE(sa.FirstName,'') + ' ' + COALESCE(sa.LastName,'') AS cn,
COALESCE(sa.LastName,'N/A') as sn,
COALESCE(sa.FirstName,'N/A') as gn,
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END AS uid,
CASE WHEN pau.userPassword <> '' THEN pau.UserPassword ELSE sa.Password END AS userpassword,
CASE WHEN pau.loginShell <> '' THEN pau.loginShell ELSE pas.loginShell END AS loginshell,
CASE WHEN pau.gidNumber IS NOT NULL THEN pau.gidNumber ELSE pas.gidNumber END AS gidNumber,
CASE WHEN pau.homeDirectory <> '' THEN pau.homeDirectory ELSE pas.homeDirectory + '/' + CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END END AS homedirectory,
d.MailDomain AS dc

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN PosixAccountUsers pau ON (sa.AccountID = pau.AccountID)
	JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID AND sa.AccountTypeID = pas.AccountTypeID)
	JOIN PosixAccountUIDs pai ON (pau.PosixAccountUserID = pai.PosixAccountUserID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Password <> ''
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)
	AND sa.Active IN (1,0)
	AND ma.Active IN (1,0)
	AND pas.LDAPServer = @id
GO

CREATE PROCEDURE dbo.PosixFullNegSync @id VARCHAR(50) AS
SET NOCOUNT ON
SELECT uidNumber 
FROM PosixAccountUIDs 
	WHERE PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
GO

