CREATE PROCEDURE dbo.MDGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.FirstName + ' ' + sa.LastName AS mdFullName,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mdForwardAddress,
'N' AS mdKeepForwardedMail,
CASE WHEN fw.Forward IS NULL THEN 'N' ELSE 'Y' END AS mdIsForwarding,
es.MailHost AS mailHost,
sa.Password AS mdPassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'N' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'N'
	WHEN (ma.CancelDate < getdate() OR sa.CancelDate < getdate()) THEN 'N'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'N'
	ELSE 'Y' END
END AS mdAllowAccess,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,
es.LogFile + '/' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mdMailDir, 
ma.Address1 AS mdHomeAddress,
ma.City AS mdHomeCity,
s.State AS mdHomeState,
ma.Zip AS mdHomeZipcode,
c.Country AS mdHomeCountry,
ma.PhoneHome AS mdHomePhone,
ma.PhoneFax AS mdHomeFax,
ma.Company AS mdBusCompany,
ma.PhoneWork AS mdBusPhone

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ''
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.MDFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE WHEN sa.Email LIKE '%@%' THEN sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain END
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> '' OR sa.Email <> '')
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.Password <> ''
	AND es.Name = @id
GO

-- Permissions
GRANT EXECUTE ON MDFullNegSync TO Emerald
GRANT EXECUTE ON MDGetPartial TO Emerald
GO
