CREATE PROCEDURE dbo.GeneralGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id

SELECT
DISTINCT sa.AccountID,
COALESCE(sa.LastName,'N/A') AS sn,
COALESCE(sa.FirstName,'') + ' ' + COALESCE(sa.LastName,'') AS cn,
CASE WHEN sa.Email IS NOT NULL AND sa.Email <> '' THEN sa.Email ELSE sa.Login END AS uid,
sa.Password AS userPassword,
g.GroupName AS ou,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain ELSE sa.Email END AS mail,
sa.PhoneHome AS telephoneNumber,
COALESCE(s.Abbreviation,s.State) AS st,
ma.Zip AS postalCode,
sa.AccountID AS uniqueIdentifier,
sa.LastModifyUser AS LastModifiedBy,
sa.LastModifyDate AS LastModifyDate,
ma.Address1 AS streetAddress,
ma.PhoneFax AS facsimileTelephoneNumber,
COALESCE(ma.Company,'N/A') AS o,
CASE 	WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'Inactive' 
	WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < getdate() THEN 'Canceled'
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'Over Credit Limit'
	WHEN DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'Expired'
	ELSE 'Active'
END AS organizationalStatus,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS otherMailbox

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.GeneralFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID AS uniqueIdentifier
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.Name = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

GRANT EXECUTE ON GeneralFullNegSync TO Emerald
GRANT EXECUTE ON GeneralGetPartial TO Emerald
GO
