CREATE PROCEDURE dbo.CGPROPartialNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE 
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> '' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.Active IN (-1,0) OR ma.Active IN (-1,0) OR p.Active IN (-1,0))
	AND (sa.Login <> '' OR sa.Email LIKE '%_@_%')
	AND sa.Password <> ''
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.CGPROGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
CASE
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> '' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END AS pk,
CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> '' THEN sa.Login END AS uid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.LastName AS sn,
sa.AccountID,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance) THEN '{crypt}abcdefghijklm'
WHEN (ma.CancelDate < getdate() OR sa.CancelDate < getdate()) THEN '{crypt}abcdefghijklm'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN '{crypt}abcdefghijklm'
ELSE sa.Password 
END AS userpassword,
CASE WHEN al.Alias IS NULL THEN 
	CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain
	END ELSE NULL END AS mail,
es.MailHost AS hostserver,
'clear' AS passwordEncryption
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Password <> ''
	AND (sa.Email LIKE '%_@_%' OR sa.Login <> '')
	AND es.Name = @id
GO

GRANT EXECUTE ON CGPROPartialNegSync TO Emerald
GRANT EXECUTE ON CGPROGetPartial TO Emerald
GO

