CREATE OR REPLACE PROCEDURE CT_DataTypes (ConfigsOnly_ IN SMALLINT,DataType_ IN VARCHAR2,DataTypeID_ IN SMALLINT) AS
BEGIN
UPDATE DataTypes SET ConfigsOnly =ConfigsOnly_,
	DataType =DataType_
	WHERE DataTypeID =DataTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO DataTypes (ConfigsOnly,DataType,DataTypeID)
VALUES (ConfigsOnly_,DataType_ ,DataTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_AccountDataTypes (AccountDataType_ IN VARCHAR2,AccountDataTypeID_ IN INTEGER,AllowMBR_ IN SMALLINT,AllowSA_ IN SMALLINT,DataTypeID_ IN SMALLINT,RegExp_ IN VARCHAR2,SQLQuery_ IN VARCHAR2,StringID_ IN INTEGER) AS
BEGIN
UPDATE AccountDataTypes SET AccountDataType =AccountDataType_,
	AllowMBR =AllowMBR_,
	AllowSA =AllowSA_,
	DataTypeID =DataTypeID_,
	RegExp =RegExp_,
	SQLQuery =SQLQuery_,
	StringID =StringID_
	WHERE AccountDataTypeID =AccountDataTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO AccountDataTypes (AccountDataType,AccountDataTypeID,AllowMBR,AllowSA,DataTypeID,RegExp,SQLQuery,StringID)
VALUES (AccountDataType_,AccountDataTypeID_ ,AllowMBR_ ,AllowSA_ ,DataTypeID_ ,RegExp_ ,SQLQuery_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_AccountDataValues (AccountDataTypeID_ IN INTEGER,KeyData_ IN VARCHAR2,ValueData_ IN VARCHAR2) AS
BEGIN
UPDATE AccountDataValues SET ValueData =ValueData_
	WHERE AccountDataTypeID =AccountDataTypeID_
	AND KeyData =KeyData_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO AccountDataValues (AccountDataTypeID,KeyData,ValueData)
VALUES (AccountDataTypeID_,KeyData_ ,ValueData_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Applications (AppName_ IN VARCHAR2,ApplicationID_ IN INTEGER) AS
BEGIN
UPDATE Applications SET AppName =AppName_
	WHERE ApplicationID =ApplicationID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Applications (AppName,ApplicationID)
VALUES (AppName_,ApplicationID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_BatchStates (BatchState_ IN VARCHAR2,BatchStateID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE BatchStates SET BatchState =BatchState_,
	StringID =StringID_
	WHERE BatchStateID =BatchStateID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO BatchStates (BatchState,BatchStateID,StringID)
VALUES (BatchState_,BatchStateID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_BatchTypes (BatchType_ IN VARCHAR2,BatchTypeID_ IN INTEGER,Description_ IN VARCHAR2,StringID_ IN INTEGER,TableName_ IN VARCHAR2) AS
BEGIN
UPDATE BatchTypes SET BatchType =BatchType_,
	Description =Description_,
	StringID =StringID_,
	TableName =TableName_
	WHERE BatchTypeID =BatchTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO BatchTypes (BatchType,BatchTypeID,Description,StringID,TableName)
VALUES (BatchType_,BatchTypeID_ ,Description_ ,StringID_ ,TableName_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_CardDigits (AllowLogin_ IN SMALLINT,AllowPassword_ IN SMALLINT,CardDigit_ IN VARCHAR2,IEAID_ IN INTEGER,JavascriptField_ IN VARCHAR2,JavascriptHeader_ IN VARCHAR2) AS
BEGIN
UPDATE CardDigits SET JavascriptHeader =JavascriptHeader_,
	JavascriptField =JavascriptField_
	WHERE IEAID =IEAID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO CardDigits (AllowLogin,AllowPassword,CardDigit,IEAID,JavascriptField,JavascriptHeader)
VALUES (AllowLogin_,AllowPassword_ ,CardDigit_ ,IEAID_ ,JavascriptField_ ,JavascriptHeader_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_CardTypes (CRC_ IN VARCHAR2,CardType_ IN VARCHAR2,CardTypeID_ IN INTEGER,Length1_ IN INTEGER,Length2_ IN INTEGER) AS
BEGIN
UPDATE CardTypes SET CRC =CRC_,
	CardType =CardType_,
	Length1 =Length1_,
	Length2 =Length2_
	WHERE CardTypeID =CardTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO CardTypes (CRC,CardType,CardTypeID,Length1,Length2)
VALUES (CRC_,CardType_ ,CardTypeID_ ,Length1_ ,Length2_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_CardTypePrefixes (CardTypeID_ IN INTEGER,Prefix_ IN VARCHAR2) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM CardTypePrefixes WHERE CardTypeID = CardTypeID_ AND Prefix = Prefix_;
IF (CTcnt_ = 0) THEN
INSERT INTO CardTypePrefixes (CardTypeID,Prefix)
VALUES (CardTypeID_,Prefix_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_ExportTypes (ExportType_ IN VARCHAR2,ExportTypeID_ IN INTEGER,IsBatch_ IN SMALLINT,IsCC_ IN SMALLINT,IsRealtime_ IN SMALLINT) AS
BEGIN
UPDATE ExportTypes SET ExportType =ExportType_,
	IsBatch =IsBatch_,
	IsCC =IsCC_,
	IsRealtime =IsRealtime_
	WHERE ExportTypeID =ExportTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ExportTypes (ExportType,ExportTypeID,IsBatch,IsCC,IsRealtime)
VALUES (ExportType_,ExportTypeID_ ,IsBatch_ ,IsCC_ ,IsRealtime_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Exports (ApproveMatch_ IN SMALLINT,ApproveString_ IN VARCHAR2,AuthMatch_ IN SMALLINT,AuthString_ IN VARCHAR2,CreditMatch_ IN SMALLINT,CreditString_ IN VARCHAR2,DeclineMatch_ IN SMALLINT,DeclineString_ IN VARCHAR2,DefaultProcessorURL_ IN VARCHAR2,Description_ IN VARCHAR2,ExportID_ IN INTEGER,ExportType_ IN SMALLINT,Features_ IN INTEGER,Filter_ IN VARCHAR2,FormatDefault_ IN INTEGER,HeaderRow_ IN SMALLINT,ImportKeySeparator_ IN VARCHAR2,ImportKeyValueSeparator_ IN VARCHAR2,Lines_ IN SMALLINT,QuoteString_ IN VARCHAR2,SQLString_ IN VARCHAR2,Separator_ IN VARCHAR2,StageCount_ IN INTEGER,Template_ IN VARCHAR2,VoidMatch_ IN SMALLINT,VoidString_ IN VARCHAR2) AS
BEGIN
UPDATE Exports SET ApproveMatch =ApproveMatch_,
	ApproveString =ApproveString_,
	AuthMatch =AuthMatch_,
	AuthString =AuthString_,
	CreditMatch =CreditMatch_,
	CreditString =CreditString_,
	DeclineMatch =DeclineMatch_,
	DeclineString =DeclineString_,
	DefaultProcessorURL =DefaultProcessorURL_,
	Description =Description_,
	ExportType =ExportType_,
	Features =Features_,
	Filter =Filter_,
	FormatDefault =FormatDefault_,
	HeaderRow =HeaderRow_,
	ImportKeySeparator =ImportKeySeparator_,
	ImportKeyValueSeparator =ImportKeyValueSeparator_,
	Lines =Lines_,
	QuoteString =QuoteString_,
	SQLString =SQLString_,
	Separator =Separator_,
	StageCount =StageCount_,
	Template =Template_,
	VoidMatch =VoidMatch_,
	VoidString =VoidString_
	WHERE ExportID =ExportID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Exports (ApproveMatch,ApproveString,AuthMatch,AuthString,CreditMatch,CreditString,DeclineMatch,DeclineString,DefaultProcessorURL,Description,ExportID,ExportType,Features,Filter,FormatDefault,HeaderRow,ImportKeySeparator,ImportKeyValueSeparator,Lines,QuoteString,SQLString,Separator,StageCount,Template,VoidMatch,VoidString)
VALUES (ApproveMatch_,ApproveString_ ,AuthMatch_ ,AuthString_ ,CreditMatch_ ,CreditString_ ,DeclineMatch_ ,DeclineString_ ,DefaultProcessorURL_ ,Description_ ,ExportID_ ,ExportType_ ,Features_ ,Filter_ ,FormatDefault_ ,HeaderRow_ ,ImportKeySeparator_ ,ImportKeyValueSeparator_ ,Lines_ ,QuoteString_ ,SQLString_ ,Separator_ ,StageCount_ ,Template_ ,VoidMatch_ ,VoidString_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ExportColumns (Align_ IN SMALLINT,Description_ IN VARCHAR2,ExportID_ IN INTEGER,ExportValue_ IN VARCHAR2,FieldName_ IN VARCHAR2,Format_ IN SMALLINT,IEAID_ IN INTEGER,Include_ IN SMALLINT,MaxSize_ IN SMALLINT,MinSize_ IN SMALLINT,Padding_ IN CHAR,Quoted_ IN SMALLINT,SortOrder_ IN SMALLINT,TransType_ IN INTEGER) AS
BEGIN
UPDATE ExportColumns SET Align =Align_,
	Description =Description_,
	ExportID =ExportID_,
	ExportValue =ExportValue_,
	FieldName =FieldName_,
	Format =Format_,
	Include =Include_,
	MaxSize =MaxSize_,
	MinSize =MinSize_,
	Padding =Padding_,
	Quoted =Quoted_,
	SortOrder =SortOrder_,
	TransType =TransType_
	WHERE IEAID =IEAID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ExportColumns (Align,Description,ExportID,ExportValue,FieldName,Format,IEAID,Include,MaxSize,MinSize,Padding,Quoted,SortOrder,TransType)
VALUES (Align_,Description_ ,ExportID_ ,ExportValue_ ,FieldName_ ,Format_ ,IEAID_ ,Include_ ,MaxSize_ ,MinSize_ ,Padding_ ,Quoted_ ,SortOrder_ ,TransType_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_CCImportColumns (ApproveValue_ IN VARCHAR2,DeclineValue_ IN VARCHAR2,Description_ IN VARCHAR2,ErrorValue_ IN VARCHAR2,ExportID_ IN INTEGER,FieldSize_ IN SMALLINT,FieldType_ IN SMALLINT,IEAID_ IN INTEGER,Line_ IN INTEGER,Position_ IN SMALLINT,Quoted_ IN SMALLINT,SortOrder_ IN SMALLINT,TransType_ IN INTEGER) AS
BEGIN
UPDATE CCImportColumns SET ApproveValue =ApproveValue_,
	DeclineValue =DeclineValue_,
	Description =Description_,
	ErrorValue =ErrorValue_,
	ExportID =ExportID_,
	FieldSize =FieldSize_,
	FieldType =FieldType_,
	Line =Line_,
	Position =Position_,
	Quoted =Quoted_,
	SortOrder =SortOrder_,
	TransType =TransType_
	WHERE IEAID =IEAID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO CCImportColumns (ApproveValue,DeclineValue,Description,ErrorValue,ExportID,FieldSize,FieldType,IEAID,Line,Position,Quoted,SortOrder,TransType)
VALUES (ApproveValue_,DeclineValue_ ,Description_ ,ErrorValue_ ,ExportID_ ,FieldSize_ ,FieldType_ ,IEAID_ ,Line_ ,Position_ ,Quoted_ ,SortOrder_ ,TransType_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ConfigGroups (ConfigGroupID_ IN INTEGER,Name_ IN VARCHAR2,SortOrder_ IN INTEGER,VisibleGlobal_ IN SMALLINT,VisibleGroupID_ IN SMALLINT,VisibleOperatorGroupID_ IN SMALLINT) AS
BEGIN
UPDATE ConfigGroups SET Name =Name_,
	SortOrder =SortOrder_,
	VisibleGlobal =VisibleGlobal_,
	VisibleGroupID =VisibleGroupID_,
	VisibleOperatorGroupID =VisibleOperatorGroupID_
	WHERE ConfigGroupID =ConfigGroupID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ConfigGroups (ConfigGroupID,Name,SortOrder,VisibleGlobal,VisibleGroupID,VisibleOperatorGroupID)
VALUES (ConfigGroupID_,Name_ ,SortOrder_ ,VisibleGlobal_ ,VisibleGroupID_ ,VisibleOperatorGroupID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Configs (AllowGlobal_ IN SMALLINT,AllowGroupID_ IN SMALLINT,AllowOperatorGroupID_ IN SMALLINT,ConfigGroupID_ IN INTEGER,ConfigID_ IN INTEGER,Data_ IN VARCHAR2,DataTypeID_ IN SMALLINT,Description_ IN VARCHAR2,FeatureID_ IN INTEGER,NumValue_ IN NUMERIC,SortOrder_ IN SMALLINT,ValuesQuery_ IN VARCHAR2) AS
BEGIN
UPDATE Configs SET ConfigGroupID =ConfigGroupID_,
	DataTypeID =DataTypeID_,
	Description =Description_,
	FeatureID =FeatureID_,
	AllowGlobal =AllowGlobal_,
	AllowGroupID =AllowGroupID_,
	AllowOperatorGroupID =AllowOperatorGroupID_,
	ValuesQuery =ValuesQuery_
	WHERE ConfigID =ConfigID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Configs (AllowGlobal,AllowGroupID,AllowOperatorGroupID,ConfigGroupID,ConfigID,Data,DataTypeID,Description,FeatureID,NumValue,SortOrder,ValuesQuery)
VALUES (AllowGlobal_,AllowGroupID_ ,AllowOperatorGroupID_ ,ConfigGroupID_ ,ConfigID_ ,Data_ ,DataTypeID_ ,Description_ ,FeatureID_ ,NumValue_ ,SortOrder_ ,ValuesQuery_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ConfigValues (ConfigID_ IN INTEGER,NumValue_ IN NUMERIC,ValueName_ IN VARCHAR2) AS
BEGIN
UPDATE ConfigValues SET ValueName =ValueName_
	WHERE ConfigID =ConfigID_
	AND NumValue =NumValue_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ConfigValues (ConfigID,NumValue,ValueName)
VALUES (ConfigID_,NumValue_ ,ValueName_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Continents (Continent_ IN VARCHAR2,ContinentID_ IN INTEGER,Hidden_ IN SMALLINT,Planet_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE Continents SET ContinentID =ContinentID_,
	Continent =Continent_,
	Planet =Planet_
	WHERE ContinentID =ContinentID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Continents (Continent,ContinentID,Hidden,Planet,SortOrder)
VALUES (Continent_,ContinentID_ ,Hidden_ ,Planet_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Countries (Abbr2_ IN CHAR,Abbr3_ IN CHAR,Comments_ IN VARCHAR2,ContinentID_ IN INTEGER,Country_ IN VARCHAR2,CountryID_ IN INTEGER,Currency_ IN VARCHAR2,Hidden_ IN SMALLINT,InternetDomain_ IN VARCHAR2,Restricted_ IN SMALLINT,SortOrder_ IN SMALLINT,TelIDD_ IN VARCHAR2,TelLocPrefixLen_ IN SMALLINT,TelNDD_ IN VARCHAR2,TelPrefix_ IN VARCHAR2,ZipStatus_ IN SMALLINT) AS
BEGIN
UPDATE Countries SET CountryID =CountryID_,
	ZipStatus =ZipStatus_,
	Country =Country_,
	InternetDomain =InternetDomain_,
	ContinentID =ContinentID_,
	TelPrefix =TelPrefix_,
	TelIDD =TelIDD_,
	TelNDD =TelNDD_,
	TelLocPrefixLen =TelLocPrefixLen_,
	Abbr2 =Abbr2_,
	Abbr3 =Abbr3_
	WHERE CountryID =CountryID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Countries (Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus)
VALUES (Abbr2_,Abbr3_ ,Comments_ ,ContinentID_ ,Country_ ,CountryID_ ,Currency_ ,Hidden_ ,InternetDomain_ ,Restricted_ ,SortOrder_ ,TelIDD_ ,TelLocPrefixLen_ ,TelNDD_ ,TelPrefix_ ,ZipStatus_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_TimeZones (StringID_ IN INTEGER,TimeZone_ IN VARCHAR2,TimeZoneID_ IN NUMERIC) AS
BEGIN
UPDATE TimeZones SET StringID =StringID_,
	TimeZone =TimeZone_
	WHERE TimeZoneID =TimeZoneID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO TimeZones (StringID,TimeZone,TimeZoneID)
VALUES (StringID_,TimeZone_ ,TimeZoneID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_States (Abbreviation_ IN VARCHAR2,CountryID_ IN INTEGER,SortOrder_ IN SMALLINT,State_ IN VARCHAR2,TimeZone1_ IN NUMERIC,TimeZone2_ IN NUMERIC) AS
BEGIN
UPDATE States SET CountryID =CountryID_,
	State =State_,
	Abbreviation =Abbreviation_,
	TimeZone1 =TimeZone1_,
	TimeZone2 =TimeZone2_
	WHERE CountryID =CountryID_
	AND State =State_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO States (Abbreviation,CountryID,SortOrder,State,TimeZone1,TimeZone2)
VALUES (Abbreviation_,CountryID_ ,SortOrder_ ,State_ ,TimeZone1_ ,TimeZone2_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_EmailTypes (EmailType_ IN VARCHAR2,EmailTypeID_ IN SMALLINT) AS
BEGIN
UPDATE EmailTypes SET EmailType =EmailType_
	WHERE EmailTypeID =EmailTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO EmailTypes (EmailType,EmailTypeID)
VALUES (EmailType_,EmailTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_PrintTypes (CRData_ IN VARCHAR2,Data_ IN VARCHAR2,PrintType_ IN VARCHAR2,PrintTypeID_ IN SMALLINT) AS
BEGIN
UPDATE PrintTypes SET CRData =CRData_,
	Data =Data_,
	PrintType =PrintType_
	WHERE PrintTypeID =PrintTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (CRData_,Data_ ,PrintType_ ,PrintTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ExternalSystemTypes (DescAux1_ IN VARCHAR2,DescAux2_ IN VARCHAR2,DescAux3_ IN VARCHAR2,ExportID_ IN INTEGER,ExternalSystemType_ IN VARCHAR2,ExternalSystemTypeID_ IN INTEGER,ShowExportID_ IN SMALLINT,ShowLogin_ IN SMALLINT,ShowMailHost_ IN SMALLINT,ShowPassword_ IN SMALLINT,ShowURL_ IN SMALLINT) AS
BEGIN
UPDATE ExternalSystemTypes SET DescAux1 =DescAux1_,
	DescAux2 =DescAux2_,
	DescAux3 =DescAux3_,
	ExportID =ExportID_,
	ExternalSystemType =ExternalSystemType_,
	ShowExportID =ShowExportID_,
	ShowLogin =ShowLogin_,
	ShowMailHost =ShowMailHost_,
	ShowPassword =ShowPassword_,
	ShowURL =ShowURL_
	WHERE ExternalSystemTypeID =ExternalSystemTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ExternalSystemTypes (DescAux1,DescAux2,DescAux3,ExportID,ExternalSystemType,ExternalSystemTypeID,ShowExportID,ShowLogin,ShowMailHost,ShowPassword,ShowURL)
VALUES (DescAux1_,DescAux2_ ,DescAux3_ ,ExportID_ ,ExternalSystemType_ ,ExternalSystemTypeID_ ,ShowExportID_ ,ShowLogin_ ,ShowMailHost_ ,ShowPassword_ ,ShowURL_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ExternalSystemDataTypes (AccountDataTypeID_ IN INTEGER,ExternalSystemTypeID_ IN INTEGER,Required_ IN SMALLINT,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE ExternalSystemDataTypes SET ExternalSystemTypeID =ExternalSystemTypeID_,
	AccountDataTypeID =AccountDataTypeID_
	WHERE ExternalSystemTypeID =ExternalSystemTypeID_
	AND AccountDataTypeID =AccountDataTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ExternalSystemDataTypes (AccountDataTypeID,ExternalSystemTypeID,Required,SortOrder)
VALUES (AccountDataTypeID_,ExternalSystemTypeID_ ,Required_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_FilterTypes (Checked_ IN INTEGER,Description_ IN VARCHAR2,FilterType_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE FilterTypes SET Checked =Checked_,
	Description =Description_,
	SortOrder =SortOrder_
	WHERE FilterType =FilterType_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO FilterTypes (Checked,Description,FilterType,SortOrder)
VALUES (Checked_,Description_ ,FilterType_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Currencies (Active_ IN SMALLINT,Code_ IN VARCHAR2,CountryID_ IN INTEGER,Currency_ IN VARCHAR2,CurrencyID_ IN INTEGER,SortOrder_ IN SMALLINT,Symbol_ IN VARCHAR2) AS
BEGIN
UPDATE Currencies SET CountryID =CountryID_,
	Currency =Currency_,
	Symbol =Symbol_,
	Code =Code_
	WHERE CurrencyID =CurrencyID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Currencies (Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol)
VALUES (Active_,Code_ ,CountryID_ ,Currency_ ,CurrencyID_ ,SortOrder_ ,Symbol_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Organizations (InvoiceDetailed_ IN SMALLINT,InvoiceFractional_ IN SMALLINT,MaxAccounts_ IN INTEGER,Organization_ IN VARCHAR2,OrganizationID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM Organizations WHERE OrganizationID = OrganizationID_;
IF (CTcnt_ = 0) THEN

SELECT Organizations_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO Organizations (InvoiceDetailed,InvoiceFractional,MaxAccounts,Organization,OrganizationID)
VALUES (InvoiceDetailed_,InvoiceFractional_ ,MaxAccounts_ ,Organization_ ,OrganizationID_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_Groups (Active_ IN SMALLINT,AutoEmailInvoices_ IN SMALLINT,AutoEmailStatements_ IN SMALLINT,BillAddress1_ IN VARCHAR2,BillAddress2_ IN VARCHAR2,BillCity_ IN VARCHAR2,BillCountryID_ IN INTEGER,BillFax_ IN VARCHAR2,BillName_ IN VARCHAR2,BillPhone_ IN VARCHAR2,BillState_ IN VARCHAR2,BillZip_ IN VARCHAR2,BillingOption_ IN SMALLINT,Description_ IN VARCHAR2,DomainID_ IN INTEGER,EmailAccounts_ IN VARCHAR2,EmailSubject_ IN VARCHAR2,EndDate_ IN DATE,FTPDir_ IN VARCHAR2,GlobalAccountTypes_ IN SMALLINT,GlobalBillingCycles_ IN SMALLINT,GlobalChargeTypes_ IN SMALLINT,GlobalDiscounts_ IN SMALLINT,GlobalDomains_ IN SMALLINT,GlobalIncidentTypes_ IN SMALLINT,GlobalPackageTypes_ IN SMALLINT,GlobalPayPeriods_ IN SMALLINT,GlobalRegions_ IN SMALLINT,GlobalSalesPersons_ IN SMALLINT,GlobalSendMethods_ IN SMALLINT,GroupID_ IN INTEGER,GroupName_ IN VARCHAR2,InvoiceHTMLReport_ IN VARCHAR2,InvoiceReport_ IN VARCHAR2,InvoiceTextReport_ IN VARCHAR2,MBRFields_ IN INTEGER,OrganizationID_ IN INTEGER,PaymentTypes_ IN INTEGER,SendCredits_ IN SMALLINT,SortOrder_ IN SMALLINT,StartDate_ IN DATE,StatementHTMLReport_ IN VARCHAR2,StatementReport_ IN VARCHAR2,StatementTextReport_ IN VARCHAR2,ThemeID_ IN INTEGER,ThemeScore_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM Groups WHERE GroupID = GroupID_;
IF (CTcnt_ = 0) THEN

SELECT Groups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillZip,BillingOption,Description,DomainID,EmailAccounts,EmailSubject,EndDate,FTPDir,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDiscounts,GlobalDomains,GlobalIncidentTypes,GlobalPackageTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,MBRFields,OrganizationID,PaymentTypes,SendCredits,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (Active_,AutoEmailInvoices_ ,AutoEmailStatements_ ,BillAddress1_ ,BillAddress2_ ,BillCity_ ,BillCountryID_ ,BillFax_ ,BillName_ ,BillPhone_ ,BillState_ ,BillZip_ ,BillingOption_ ,Description_ ,DomainID_ ,EmailAccounts_ ,EmailSubject_ ,EndDate_ ,FTPDir_ ,GlobalAccountTypes_ ,GlobalBillingCycles_ ,GlobalChargeTypes_ ,GlobalDiscounts_ ,GlobalDomains_ ,GlobalIncidentTypes_ ,GlobalPackageTypes_ ,GlobalPayPeriods_ ,GlobalRegions_ ,GlobalSalesPersons_ ,GlobalSendMethods_ ,GroupID_ ,GroupName_ ,InvoiceHTMLReport_ ,InvoiceReport_ ,InvoiceTextReport_ ,MBRFields_ ,OrganizationID_ ,PaymentTypes_ ,SendCredits_ ,SortOrder_ ,StartDate_ ,StatementHTMLReport_ ,StatementReport_ ,StatementTextReport_ ,ThemeID_ ,ThemeScore_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_Languages (Active_ IN SMALLINT,AllowIEAUpdate_ IN SMALLINT,BaseURL_ IN VARCHAR2,Description_ IN VARCHAR2,HttpAcceptLanguage_ IN VARCHAR2,LanguageID_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE Languages SET LanguageID =LanguageID_,
	Description =Description_,
	BaseURL =BaseURL_,
	HttpAcceptLanguage =HttpAcceptLanguage_
	WHERE LanguageID =LanguageID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Languages (Active,AllowIEAUpdate,BaseURL,Description,HttpAcceptLanguage,LanguageID,SortOrder)
VALUES (Active_,AllowIEAUpdate_ ,BaseURL_ ,Description_ ,HttpAcceptLanguage_ ,LanguageID_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Strings (ApplicationID_ IN INTEGER,Data_ IN VARCHAR2,LanguageID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE Strings SET Data =Data_
	WHERE ApplicationID =ApplicationID_
	AND StringID =StringID_
	AND LanguageID =LanguageID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Strings (ApplicationID,Data,LanguageID,StringID)
VALUES (ApplicationID_,Data_ ,LanguageID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_LogMsgs (Description_ IN VARCHAR2,LogMsgID_ IN INTEGER,Severity_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE LogMsgs SET Description =Description_,
	Severity =Severity_,
	StringID =StringID_
	WHERE LogMsgID =LogMsgID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO LogMsgs (Description,LogMsgID,Severity,StringID)
VALUES (Description_,LogMsgID_ ,Severity_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_MenuItems (Access_ IN VARCHAR2,AccessKey_ IN VARCHAR2,Attribute_ IN VARCHAR2,ColumnName_ IN VARCHAR2,Condition_ IN VARCHAR2,DescStringID_ IN INTEGER,Description_ IN VARCHAR2,FeatureID_ IN INTEGER,FileName_ IN VARCHAR2,HelpStringID_ IN INTEGER,Label_ IN VARCHAR2,Link_ IN VARCHAR2,MenuItem_ IN VARCHAR2,MenuItemID_ IN INTEGER,TableName_ IN VARCHAR2) AS
BEGIN
UPDATE MenuItems SET TableName =TableName_,
	ColumnName =ColumnName_,
	FileName =FileName_,
	"Access" =Access_,
	Condition =Condition_,
	FeatureID =FeatureID_,
	DescStringID =DescStringID_,
	HelpStringID =HelpStringID_,
	Link =Link_,
	Attribute =Attribute_
	WHERE MenuItemID =MenuItemID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO MenuItems ("Access",AccessKey,Attribute,ColumnName,Condition,DescStringID,Description,FeatureID,FileName,HelpStringID,Label,Link,MenuItem,MenuItemID,TableName)
VALUES (Access_,AccessKey_ ,Attribute_ ,ColumnName_ ,Condition_ ,DescStringID_ ,Description_ ,FeatureID_ ,FileName_ ,HelpStringID_ ,Label_ ,Link_ ,MenuItem_ ,MenuItemID_ ,TableName_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Menus (Class_ IN VARCHAR2,Description_ IN VARCHAR2,Menu_ IN VARCHAR2,MenuID_ IN INTEGER) AS
BEGIN
UPDATE Menus SET Class =Class_,
	Description =Description_,
	Menu =Menu_
	WHERE MenuID =MenuID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Menus (Class,Description,Menu,MenuID)
VALUES (Class_,Description_ ,Menu_ ,MenuID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_MenuSets (MenuID_ IN INTEGER,MenuItemID_ IN INTEGER,SortOrder_ IN INTEGER) AS
BEGIN
UPDATE MenuSets SET SortOrder =SortOrder_
	WHERE MenuID =MenuID_
	AND MenuItemID =MenuItemID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO MenuSets (MenuID,MenuItemID,SortOrder)
VALUES (MenuID_,MenuItemID_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_MetaRules (Description_ IN VARCHAR2,MetaRuleID_ IN INTEGER) AS
BEGIN
UPDATE MetaRules SET Description =Description_
	WHERE MetaRuleID =MetaRuleID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO MetaRules (Description,MetaRuleID)
VALUES (Description_,MetaRuleID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_MetaTables (Description_ IN VARCHAR2,GroupTable_ IN VARCHAR2,SortOrder_ IN INTEGER,TableName_ IN VARCHAR2) AS
BEGIN
UPDATE MetaTables SET Description =Description_,
	GroupTable =GroupTable_,
	SortOrder =SortOrder_
	WHERE TableName =TableName_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO MetaTables (Description,GroupTable,SortOrder,TableName)
VALUES (Description_,GroupTable_ ,SortOrder_ ,TableName_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_MetaColumns (TableName_ IN VARCHAR2,ColumnName_ IN VARCHAR2,Description_ IN VARCHAR2,DepTable_ IN VARCHAR2,DepColumn_ IN VARCHAR2,DepGroup_ IN INTEGER,MetaRuleID_ IN INTEGER,Required_ IN SMALLINT,Nullable_ IN SMALLINT,Quoted_ IN SMALLINT,MinSize_ IN INTEGER,MaxSize_ IN INTEGER,IsKey_ IN SMALLINT,ColumnType_ IN INTEGER,HelpText_ IN VARCHAR2) AS
BEGIN
DECLARE
MetaTableID_ INTEGER;
BEGIN
SELECT MetaTableID INTO MetaTableID_  FROM MetaTables WHERE TableName = TableName_;
IF (MetaTableID_ IS NOT NULL) THEN
UPDATE MetaColumns SET Description =Description_,
	DepTable =DepTable_,
	DepGroup =DepGroup_,
	MetaRuleID =MetaRuleID_,
	Required =Required_,
	Nullable =Nullable_,
	Quoted =Quoted_,
	MinSize =MinSize_,
	MaxSize = CASE WHEN MaxSize_ > MaxSize THEN MaxSize_ ELSE MaxSize END,
	IsKey =IsKey_,
	ColumnType =ColumnType_,
	HelpText =HelpText_
	WHERE MetaTableID =MetaTableID_
	AND ColumnName =ColumnName_;
IF (SQL%ROWCOUNT = 0) THEN
	INSERT INTO MetaColumns (MetaTableID,ColumnName,Description,DepTable,DepColumn,DepGroup,MetaRuleID,Required,Nullable,Quoted,MinSize,MaxSize,IsKey,ColumnType,HelpText)
	VALUES (MetaTableID_,ColumnName_ ,Description_ ,DepTable_ ,DepColumn_ ,DepGroup_ ,MetaRuleID_ ,Required_ ,Nullable_ ,Quoted_ ,MinSize_ ,MaxSize_ ,IsKey_ ,ColumnType_ ,HelpText_ );
END IF;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_NoticeTypes (DefaultText_ IN VARCHAR2,Description_ IN VARCHAR2,IEAID_ IN INTEGER,IEATag_ IN INTEGER,InternalID_ IN SMALLINT,NoticeType_ IN VARCHAR2,Parm1Desc_ IN VARCHAR2,Parm1Query_ IN VARCHAR2,Parm1TypeID_ IN SMALLINT,Parm2Desc_ IN VARCHAR2,Parm2Query_ IN VARCHAR2,Parm2TypeID_ IN SMALLINT,Parm3Desc_ IN VARCHAR2,Parm3Query_ IN VARCHAR2,Parm3TypeID_ IN SMALLINT,ReportFile_ IN VARCHAR2,SQLQuery_ IN VARCHAR2,SentQuery_ IN VARCHAR2) AS
BEGIN
UPDATE NoticeTypes SET IEATag =IEATag_,
	NoticeType =NoticeType_,
	Description =Description_,
	SQLQuery =SQLQuery_,
	ReportFile =ReportFile_,
	Parm1Desc =Parm1Desc_,
	Parm2Desc =Parm2Desc_,
	Parm3Desc =Parm3Desc_,
	Parm1TypeID =Parm1TypeID_,
	Parm2TypeID =Parm2TypeID_,
	Parm3TypeID =Parm3TypeID_,
	InternalID =InternalID_,
	Parm1Query =Parm1Query_,
	Parm2Query =Parm2Query_,
	Parm3Query =Parm3Query_
	WHERE IEAID =IEAID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO NoticeTypes (DefaultText,Description,IEAID,IEATag,InternalID,NoticeType,Parm1Desc,Parm1Query,Parm1TypeID,Parm2Desc,Parm2Query,Parm2TypeID,Parm3Desc,Parm3Query,Parm3TypeID,ReportFile,SQLQuery,SentQuery)
VALUES (DefaultText_,Description_ ,IEAID_ ,IEATag_ ,InternalID_ ,NoticeType_ ,Parm1Desc_ ,Parm1Query_ ,Parm1TypeID_ ,Parm2Desc_ ,Parm2Query_ ,Parm2TypeID_ ,Parm3Desc_ ,Parm3Query_ ,Parm3TypeID_ ,ReportFile_ ,SQLQuery_ ,SentQuery_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Notices (InternalID_ IN INTEGER,Active_ IN INTEGER,Notice_ IN VARCHAR2,MailFrom_ IN VARCHAR2,MailSubject_ IN VARCHAR2,MailCC_ IN VARCHAR2,NoticeText_ IN VARCHAR2) AS
BEGIN
INSERT INTO Notices (InternalID, NoticeTypeID, Active, Notice, MailFrom, MailSubject, MailCC, NoticeText)
SELECT nt.InternalID, nt.NoticeTypeID,Active_ ,Notice_ ,MailFrom_ ,MailSubject_ ,MailCC_ ,NoticeText_ 
FROM NoticeTypes nt
	WHERE nt.InternalID =InternalID_
	AND nt.InternalID NOT IN (SELECT InternalID FROM Notices);
END;
/

CREATE OR REPLACE PROCEDURE CT_ObjectGroups (Description_ IN VARCHAR2,ObjectGroup_ IN VARCHAR2,ObjectGroupID_ IN INTEGER) AS
BEGIN
UPDATE ObjectGroups SET Description =Description_,
	ObjectGroup =ObjectGroup_
	WHERE ObjectGroupID =ObjectGroupID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ObjectGroups (Description,ObjectGroup,ObjectGroupID)
VALUES (Description_,ObjectGroup_ ,ObjectGroupID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Objects (TableName_ IN VARCHAR2,ColumnName_ IN VARCHAR2,FileName_ IN VARCHAR2,ObjectTypeID_ IN INTEGER,ObjectGroupID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN
IF (ObjectTypeID_ = 1) THEN
SELECT COUNT(*) INTO CTcnt_  FROM Objects WHERE ObjectGroupID = ObjectGroupID_ AND ObjectTypeID = 1 AND Data = FileName_;
END IF;
IF (ObjectTypeID_ = 1 AND CTcnt_ = 0) THEN
INSERT INTO Objects (Data,ObjectGroupID,ObjectTypeID)
VALUES(FileName_,ObjectGroupID_ ,1);
END IF;
IF (ObjectTypeID_ = 2) THEN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID)
SELECT mt.MetaTableID,ObjectGroupID_ ,2
FROM MetaTables mt
	WHERE mt.TableName =TableName_
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mt.MetaTableID AND ObjectGroupID =ObjectGroupID_ AND ObjectTypeID = 2);
END IF;
IF (ObjectTypeID_ = 3) THEN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID)
SELECT mc.MetaColumnID,ObjectGroupID_ ,3
FROM MetaTables mt, MetaColumns mc
	WHERE mt.TableName =TableName_
	AND mt.MetaTableID = mc.MetaTableID
	AND mc.ColumnName =ColumnName_
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mc.MetaColumnID AND ObjectGroupID =ObjectGroupID_ AND ObjectTypeID = 3);
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_PaymentTypes (CustomerAccess_ IN SMALLINT,CustomerDescription_ IN VARCHAR2,CustomerPayment_ IN SMALLINT,CustomerStringID_ IN INTEGER,GLCodeID_ IN INTEGER,IsPayMethod_ IN SMALLINT,IsPayType_ IN SMALLINT,PaymentType_ IN VARCHAR2,PaymentTypeID_ IN INTEGER,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
UPDATE PaymentTypes SET IsPayMethod =IsPayMethod_,
	IsPayType =IsPayType_,
	CustomerAccess =CustomerAccess_,
	CustomerPayment =CustomerPayment_
	WHERE PaymentTypeID =PaymentTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO PaymentTypes (CustomerAccess,CustomerDescription,CustomerPayment,CustomerStringID,GLCodeID,IsPayMethod,IsPayType,PaymentType,PaymentTypeID,SortOrder,StringID)
VALUES (CustomerAccess_,CustomerDescription_ ,CustomerPayment_ ,CustomerStringID_ ,GLCodeID_ ,IsPayMethod_ ,IsPayType_ ,PaymentType_ ,PaymentTypeID_ ,SortOrder_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_Priorities (Priority_ IN VARCHAR2,PriorityID_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM Priorities WHERE PriorityID = PriorityID_;
IF (CTcnt_ = 0) THEN
INSERT INTO Priorities (Priority,PriorityID,StringID)
VALUES (Priority_,PriorityID_ ,StringID_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadDestTypes (RadDestType_ IN VARCHAR2,RadDestTypeID_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE RadDestTypes SET RadDestType =RadDestType_,
	SortOrder =SortOrder_
	WHERE RadDestTypeID =RadDestTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID,SortOrder)
VALUES (RadDestType_,RadDestTypeID_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadSourceTypes (RadSourceType_ IN VARCHAR2,RadSourceTypeID_ IN INTEGER) AS
BEGIN
UPDATE RadSourceTypes SET RadSourceType =RadSourceType_
	WHERE RadSourceTypeID =RadSourceTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID)
VALUES (RadSourceType_,RadSourceTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadFilterTypes (RadFilterType_ IN VARCHAR2,RadFilterTypeID_ IN INTEGER) AS
BEGIN
UPDATE RadFilterTypes SET RadFilterType =RadFilterType_
	WHERE RadFilterTypeID =RadFilterTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadFilterTypes (RadFilterType,RadFilterTypeID)
VALUES (RadFilterType_,RadFilterTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadMergeTypes (RadMergeType_ IN CHAR,RadMergeTypeID_ IN INTEGER) AS
BEGIN
UPDATE RadMergeTypes SET RadMergeType =RadMergeType_
	WHERE RadMergeTypeID =RadMergeTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID)
VALUES (RadMergeType_,RadMergeTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadLogMsgs (Description_ IN VARCHAR2,RadLogMsgID_ IN INTEGER,Severity_ IN INTEGER) AS
BEGIN
UPDATE RadLogMsgs SET Description =Description_,
	Severity =Severity_
	WHERE RadLogMsgID =RadLogMsgID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadLogMsgs (Description,RadLogMsgID,Severity)
VALUES (Description_,RadLogMsgID_ ,Severity_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadRejectAttributes (Data_ IN VARCHAR2,IEAID_ IN INTEGER,RadAttributeID_ IN INTEGER,RadLogMsgID_ IN INTEGER,RadVendorID_ IN INTEGER,ServerID_ IN INTEGER) AS
BEGIN
UPDATE RadRejectAttributes SET RadLogMsgID =RadLogMsgID_,
	RadVendorID =RadVendorID_,
	RadAttributeID =RadAttributeID_,
	Data =Data_
	WHERE IEAID =IEAID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadRejectAttributes (Data,IEAID,RadAttributeID,RadLogMsgID,RadVendorID,ServerID)
VALUES (Data_,IEAID_ ,RadAttributeID_ ,RadLogMsgID_ ,RadVendorID_ ,ServerID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadSearchTypes (RadSearchType_ IN VARCHAR2,RadSearchTypeID_ IN INTEGER) AS
BEGIN
UPDATE RadSearchTypes SET RadSearchType =RadSearchType_
	WHERE RadSearchTypeID =RadSearchTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RadSearchTypes (RadSearchType,RadSearchTypeID)
VALUES (RadSearchType_,RadSearchTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateRuleTypes (RateRuleType_ IN VARCHAR2,RateRuleTypeID_ IN INTEGER) AS
BEGIN
UPDATE RateRuleTypes SET RateRuleType =RateRuleType_
	WHERE RateRuleTypeID =RateRuleTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateRuleTypes (RateRuleType,RateRuleTypeID)
VALUES (RateRuleType_,RateRuleTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateIntervals (NamePlural_ IN VARCHAR2,NameShort_ IN VARCHAR2,NameSingular_ IN VARCHAR2,RateIntervalID_ IN INTEGER,RateRuleTypeID_ IN INTEGER) AS
BEGIN
UPDATE RateIntervals SET RateRuleTypeID =RateRuleTypeID_
	WHERE RateIntervalID =RateIntervalID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateIntervals (NamePlural,NameShort,NameSingular,RateIntervalID,RateRuleTypeID)
VALUES (NamePlural_,NameShort_ ,NameSingular_ ,RateIntervalID_ ,RateRuleTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateIPPorts (Description_ IN VARCHAR2,Port_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM RateIPPorts WHERE Port = Port_;
IF (CTcnt_ = 0) THEN
INSERT INTO RateIPPorts (Description,Port,SortOrder)
VALUES (Description_,Port_ ,SortOrder_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateIPProtocols (Description_ IN VARCHAR2,Protocol_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM RateIPProtocols WHERE Protocol = Protocol_;
IF (CTcnt_ = 0) THEN
INSERT INTO RateIPProtocols (Description,Protocol,SortOrder)
VALUES (Description_,Protocol_ ,SortOrder_ );
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateMatchTypes (RateMatchType_ IN VARCHAR2,RateMatchTypeID_ IN INTEGER) AS
BEGIN
UPDATE RateMatchTypes SET RateMatchType =RateMatchType_
	WHERE RateMatchTypeID =RateMatchTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateMatchTypes (RateMatchType,RateMatchTypeID)
VALUES (RateMatchType_,RateMatchTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateRoundTypes (AllowData_ IN SMALLINT,AllowTime_ IN SMALLINT,RateRoundType_ IN VARCHAR2,RateRoundTypeID_ IN INTEGER) AS
BEGIN
UPDATE RateRoundTypes SET AllowData =AllowData_,
	AllowTime =AllowTime_,
	RateRoundType =RateRoundType_
	WHERE RateRoundTypeID =RateRoundTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateRoundTypes (AllowData,AllowTime,RateRoundType,RateRoundTypeID)
VALUES (AllowData_,AllowTime_ ,RateRoundType_ ,RateRoundTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateSources (AllowData_ IN SMALLINT,AllowTime_ IN SMALLINT,RateSource_ IN VARCHAR2,RateSourceID_ IN INTEGER) AS
BEGIN
UPDATE RateSources SET AllowData =AllowData_,
	AllowTime =AllowTime_,
	RateSource =RateSource_
	WHERE RateSourceID =RateSourceID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateSources (AllowData,AllowTime,RateSource,RateSourceID)
VALUES (AllowData_,AllowTime_ ,RateSource_ ,RateSourceID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateSourceAttributes (AllowData_ IN SMALLINT,AllowTime_ IN SMALLINT,Attribute_ IN VARCHAR2,Description_ IN VARCHAR2,Dynamic_ IN SMALLINT,RateMatchTypes_ IN INTEGER,RateSourceID_ IN INTEGER,SortOrder_ IN SMALLINT,ValuesQuery_ IN VARCHAR2) AS
BEGIN
UPDATE RateSourceAttributes SET RateSourceID =RateSourceID_,
	Attribute =Attribute_,
	Description =Description_,
	AllowData =AllowData_,
	AllowTime =AllowTime_,
	Dynamic =Dynamic_,
	ValuesQuery =ValuesQuery_,
	RateMatchTypes =RateMatchTypes_
	WHERE RateSourceID =RateSourceID_
	AND Attribute =Attribute_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateSourceAttributes (AllowData,AllowTime,Attribute,Description,Dynamic,RateMatchTypes,RateSourceID,SortOrder,ValuesQuery)
VALUES (AllowData_,AllowTime_ ,Attribute_ ,Description_ ,Dynamic_ ,RateMatchTypes_ ,RateSourceID_ ,SortOrder_ ,ValuesQuery_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateTypes (RateSourceID_ IN INTEGER,RateType_ IN VARCHAR2,RateTypeID_ IN INTEGER,RuleQuery_ IN VARCHAR2,ScriptConfigure_ IN VARCHAR2,ScriptSummary_ IN VARCHAR2) AS
BEGIN
UPDATE RateTypes SET RateSourceID =RateSourceID_,
	RateType =RateType_,
	RuleQuery =RuleQuery_,
	ScriptConfigure =ScriptConfigure_,
	ScriptSummary =ScriptSummary_
	WHERE RateTypeID =RateTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateTypes (RateSourceID,RateType,RateTypeID,RuleQuery,ScriptConfigure,ScriptSummary)
VALUES (RateSourceID_,RateType_ ,RateTypeID_ ,RuleQuery_ ,ScriptConfigure_ ,ScriptSummary_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateRules (ClassQuery_ IN VARCHAR2,ClassRequired_ IN SMALLINT,ClassTTL_ IN INTEGER,DefaultCost_ IN NUMERIC,Description_ IN VARCHAR2,Interval_ IN INTEGER,RateRoundTypeID_ IN INTEGER,RateRule_ IN VARCHAR2,RateRuleTypeID_ IN INTEGER,RateSourceID_ IN INTEGER,RateTypeID_ IN INTEGER,RuleQuery_ IN VARCHAR2,StringID_ IN INTEGER) AS
BEGIN
UPDATE RateRules SET ClassQuery =ClassQuery_,
	ClassRequired =ClassRequired_,
	ClassTTL =ClassTTL_,
	DefaultCost =DefaultCost_,
	Description =Description_,
	Interval =Interval_,
	RateRoundTypeID =RateRoundTypeID_,
	RateRuleTypeID =RateRuleTypeID_,
	RateSourceID =RateSourceID_,
	RateTypeID =RateTypeID_,
	RuleQuery =RuleQuery_,
	StringID =StringID_
	WHERE RateRule =RateRule_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateRules (ClassQuery,ClassRequired,ClassTTL,DefaultCost,Description,Interval,RateRoundTypeID,RateRule,RateRuleTypeID,RateSourceID,RateTypeID,RuleQuery,StringID)
VALUES (ClassQuery_,ClassRequired_ ,ClassTTL_ ,DefaultCost_ ,Description_ ,Interval_ ,RateRoundTypeID_ ,RateRule_ ,RateRuleTypeID_ ,RateSourceID_ ,RateTypeID_ ,RuleQuery_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ScheduleIntervals (Interval_ IN VARCHAR2,Seconds_ IN INTEGER) AS
BEGIN
UPDATE ScheduleIntervals SET Interval =Interval_
	WHERE Seconds =Seconds_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ScheduleIntervals (Interval,Seconds)
VALUES (Interval_,Seconds_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ScheduleTasks (Description_ IN VARCHAR2,TaskName_ IN VARCHAR2,TaskType_ IN VARCHAR2) AS
BEGIN
UPDATE ScheduleTasks SET Description =Description_,
	TaskType =TaskType_
	WHERE TaskName =TaskName_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ScheduleTasks (Description,TaskName,TaskType)
VALUES (Description_,TaskName_ ,TaskType_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ServerTypes (Model_ IN VARCHAR2,SNMPType_ IN INTEGER,SNMPUser_ IN VARCHAR2,ServerType_ IN INTEGER,Vendor_ IN VARCHAR2) AS
BEGIN
UPDATE ServerTypes SET Model =Model_,
	SNMPType =SNMPType_,
	SNMPUser =SNMPUser_,
	Vendor =Vendor_
	WHERE ServerType =ServerType_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ServerTypes (Model,SNMPType,SNMPUser,ServerType,Vendor)
VALUES (Model_,SNMPType_ ,SNMPUser_ ,ServerType_ ,Vendor_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ThemeMatchTypes (Hidden_ IN SMALLINT,ThemeMatchType_ IN VARCHAR2,ThemeMatchTypeID_ IN INTEGER) AS
BEGIN
UPDATE ThemeMatchTypes SET Hidden =Hidden_,
	ThemeMatchType =ThemeMatchType_
	WHERE ThemeMatchTypeID =ThemeMatchTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ThemeMatchTypes (Hidden,ThemeMatchType,ThemeMatchTypeID)
VALUES (Hidden_,ThemeMatchType_ ,ThemeMatchTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_TransStates (StringID_ IN INTEGER,TransState_ IN VARCHAR2,TransStateID_ IN INTEGER) AS
BEGIN
UPDATE TransStates SET StringID =StringID_,
	TransState =TransState_
	WHERE TransStateID =TransStateID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO TransStates (StringID,TransState,TransStateID)
VALUES (StringID_,TransState_ ,TransStateID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_TransTypes (StringID_ IN INTEGER,TransType_ IN VARCHAR2,TransTypeID_ IN INTEGER) AS
BEGIN
UPDATE TransTypes SET StringID =StringID_,
	TransType =TransType_
	WHERE TransTypeID =TransTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO TransTypes (StringID,TransType,TransTypeID)
VALUES (StringID_,TransType_ ,TransTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_WebAccess (Name_ IN VARCHAR2,WebAccess_ IN INTEGER) AS
BEGIN
UPDATE WebAccess SET Name =Name_
	WHERE WebAccess =WebAccess_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO WebAccess (Name,WebAccess)
VALUES (Name_,WebAccess_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_PeriodTypes (AllowPayPeriod_ IN SMALLINT,PeriodType_ IN VARCHAR2,PeriodTypeID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE PeriodTypes SET AllowPayPeriod =AllowPayPeriod_,
	PeriodType =PeriodType_,
	StringID =StringID_
	WHERE PeriodTypeID =PeriodTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO PeriodTypes (AllowPayPeriod,PeriodType,PeriodTypeID,StringID)
VALUES (AllowPayPeriod_,PeriodType_ ,PeriodTypeID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateDataSources (BillingMode_ IN INTEGER,ClearQuery_ IN VARCHAR2,DSN_ IN VARCHAR2,DataQuery_ IN VARCHAR2,Password_ IN VARCHAR2,RateDataSource_ IN VARCHAR2,RateDataSourceID_ IN INTEGER,RateSourceID_ IN INTEGER,UpdateInterval_ IN SMALLINT,UpdateQuery_ IN VARCHAR2,UseTransactions_ IN SMALLINT,Username_ IN VARCHAR2) AS
BEGIN
UPDATE RateDataSources SET BillingMode =BillingMode_,
	ClearQuery =ClearQuery_,
	DSN =DSN_,
	DataQuery =DataQuery_,
	Password =Password_,
	RateDataSource =RateDataSource_,
	RateSourceID =RateSourceID_,
	UpdateInterval =UpdateInterval_,
	UpdateQuery =UpdateQuery_,
	UseTransactions =UseTransactions_,
	Username =Username_
	WHERE RateDataSourceID =RateDataSourceID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO RateDataSources (BillingMode,ClearQuery,DSN,DataQuery,Password,RateDataSource,RateDataSourceID,RateSourceID,UpdateInterval,UpdateQuery,UseTransactions,Username)
VALUES (BillingMode_,ClearQuery_ ,DSN_ ,DataQuery_ ,Password_ ,RateDataSource_ ,RateDataSourceID_ ,RateSourceID_ ,UpdateInterval_ ,UpdateQuery_ ,UseTransactions_ ,Username_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_InvoiceTypes (InvoiceType_ IN VARCHAR2,InvoiceTypeID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE InvoiceTypes SET InvoiceType =InvoiceType_,
	StringID =StringID_
	WHERE InvoiceTypeID =InvoiceTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO InvoiceTypes (InvoiceType,InvoiceTypeID,StringID)
VALUES (InvoiceType_,InvoiceTypeID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_InvoiceItemTypes (InvoiceItemType_ IN VARCHAR2,InvoiceItemTypeID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE InvoiceItemTypes SET InvoiceItemType =InvoiceItemType_,
	StringID =StringID_
	WHERE InvoiceItemTypeID =InvoiceItemTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO InvoiceItemTypes (InvoiceItemType,InvoiceItemTypeID,StringID)
VALUES (InvoiceItemType_,InvoiceItemTypeID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_IEALocks (IEALock_ IN VARCHAR2,IEALockID_ IN INTEGER,RefCount_ IN INTEGER) AS
BEGIN
UPDATE IEALocks SET IEALock =IEALock_
	WHERE IEALockID =IEALockID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO IEALocks (IEALock,IEALockID,RefCount)
VALUES (IEALock_,IEALockID_ ,RefCount_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT2_ReportFields (CRFieldName_ IN VARCHAR2,DataType_ IN SMALLINT,DefaultValue_ IN VARCHAR2,Description_ IN VARCHAR2,EWSFile_ IN VARCHAR2,FieldName_ IN VARCHAR2,ReportField_ IN VARCHAR2,ReportFieldID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE ReportFields SET Description =Description_,
	CRFieldName =CRFieldName_,
	DataType =DataType_,
	DefaultValue =DefaultValue_,
	EWSFile =EWSFile_
	WHERE ReportFieldID =ReportFieldID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ReportFields (CRFieldName,DataType,DefaultValue,Description,EWSFile,FieldName,ReportField,ReportFieldID,StringID)
VALUES (CRFieldName_,DataType_ ,DefaultValue_ ,Description_ ,EWSFile_ ,FieldName_ ,ReportField_ ,ReportFieldID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_AccountTemplates (AccountTemplate_ IN VARCHAR2,AccountTemplateID_ IN INTEGER,CustEdit_ IN VARCHAR2,CustEditLabel_ IN VARCHAR2,CustEditStringID_ IN INTEGER,CustNew_ IN VARCHAR2,CustSave_ IN VARCHAR2,LoginLabel_ IN VARCHAR2,LoginStringID_ IN INTEGER,SADetail_ IN VARCHAR2,SAEdit_ IN VARCHAR2,SANew_ IN VARCHAR2,SASave_ IN VARCHAR2,SignupForm_ IN VARCHAR2,SignupPage_ IN VARCHAR2,SignupSave_ IN VARCHAR2,SignupValidate_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE AccountTemplates SET AccountTemplate =AccountTemplate_,
	LoginLabel =LoginLabel_,
	LoginStringID =LoginStringID_,
	SANew =SANew_,
	SAEdit =SAEdit_,
	SASave =SASave_,
	SADetail =SADetail_,
	CustNew =CustNew_,
	CustEdit =CustEdit_,
	CustEditLabel =CustEditLabel_,
	CustEditStringID =CustEditStringID_,
	CustSave =CustSave_,
	SignupPage =SignupPage_,
	SignupForm =SignupForm_,
	SignupValidate =SignupValidate_,
	SignupSave =SignupSave_
	WHERE AccountTemplateID =AccountTemplateID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO AccountTemplates (AccountTemplate,AccountTemplateID,CustEdit,CustEditLabel,CustEditStringID,CustNew,CustSave,LoginLabel,LoginStringID,SADetail,SAEdit,SANew,SASave,SignupForm,SignupPage,SignupSave,SignupValidate,SortOrder)
VALUES (AccountTemplate_,AccountTemplateID_ ,CustEdit_ ,CustEditLabel_ ,CustEditStringID_ ,CustNew_ ,CustSave_ ,LoginLabel_ ,LoginStringID_ ,SADetail_ ,SAEdit_ ,SANew_ ,SASave_ ,SignupForm_ ,SignupPage_ ,SignupSave_ ,SignupValidate_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_IncidentTemplates (CustIncidentEdit_ IN VARCHAR2,CustIncidentSave_ IN VARCHAR2,IncidentEdit_ IN VARCHAR2,IncidentSave_ IN VARCHAR2,IncidentTemplate_ IN VARCHAR2,IncidentTemplateID_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE IncidentTemplates SET IncidentTemplate =IncidentTemplate_,
	IncidentEdit =IncidentEdit_,
	IncidentSave =IncidentSave_,
	CustIncidentEdit =CustIncidentEdit_,
	CustIncidentSave =CustIncidentSave_
	WHERE IncidentTemplateID =IncidentTemplateID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO IncidentTemplates (CustIncidentEdit,CustIncidentSave,IncidentEdit,IncidentSave,IncidentTemplate,IncidentTemplateID,SortOrder)
VALUES (CustIncidentEdit_,CustIncidentSave_ ,IncidentEdit_ ,IncidentSave_ ,IncidentTemplate_ ,IncidentTemplateID_ ,SortOrder_ );
END IF;
END;
