CREATE PROCEDURE dbo.CT_DataTypes (@ConfigsOnly SMALLINT,@DataType VARCHAR(255),@DataTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE DataTypes SET ConfigsOnly = @ConfigsOnly,
	DataType = @DataType
	WHERE DataTypeID = @DataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO DataTypes (ConfigsOnly,DataType,DataTypeID)
VALUES (@ConfigsOnly,@DataType,@DataTypeID)
END
GO

CREATE PROCEDURE dbo.CT_AccountDataTypes (@AccountDataType VARCHAR(255),@AccountDataTypeID INT,@AllowMBR SMALLINT,@AllowSA SMALLINT,@DataTypeID SMALLINT,@RegExp VARCHAR(255),@SQLQuery VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
UPDATE AccountDataTypes SET AccountDataType = @AccountDataType,
	AllowMBR = @AllowMBR,
	AllowSA = @AllowSA,
	DataTypeID = @DataTypeID,
	RegExp = @RegExp,
	SQLQuery = @SQLQuery,
	StringID = @StringID
	WHERE AccountDataTypeID = @AccountDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountDataTypes (AccountDataType,AccountDataTypeID,AllowMBR,AllowSA,DataTypeID,RegExp,SQLQuery,StringID)
VALUES (@AccountDataType,@AccountDataTypeID,@AllowMBR,@AllowSA,@DataTypeID,@RegExp,@SQLQuery,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AccountDataValues (@AccountDataTypeID INT,@KeyData VARCHAR(255),@ValueData VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE AccountDataValues SET ValueData = @ValueData
	WHERE AccountDataTypeID = @AccountDataTypeID
	AND KeyData = @KeyData

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountDataValues (AccountDataTypeID,KeyData,ValueData)
VALUES (@AccountDataTypeID,@KeyData,@ValueData)
END
GO

CREATE PROCEDURE dbo.CT_Applications (@AppName VARCHAR(255),@ApplicationID INT) AS
SET NOCOUNT ON
UPDATE Applications SET AppName = @AppName
	WHERE ApplicationID = @ApplicationID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Applications (AppName,ApplicationID)
VALUES (@AppName,@ApplicationID)
END
GO

CREATE PROCEDURE dbo.CT_BatchStates (@BatchState VARCHAR(255),@BatchStateID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE BatchStates SET BatchState = @BatchState,
	StringID = @StringID
	WHERE BatchStateID = @BatchStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BatchStates (BatchState,BatchStateID,StringID)
VALUES (@BatchState,@BatchStateID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_BatchTypes (@BatchType VARCHAR(255),@BatchTypeID INT,@Description VARCHAR(8000),@StringID INT,@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE BatchTypes SET BatchType = @BatchType,
	Description = @Description,
	StringID = @StringID,
	TableName = @TableName
	WHERE BatchTypeID = @BatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO BatchTypes (BatchType,BatchTypeID,Description,StringID,TableName)
VALUES (@BatchType,@BatchTypeID,@Description,@StringID,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_CardDigits (@AllowLogin SMALLINT,@AllowPassword SMALLINT,@CardDigit VARCHAR(255),@IEAID INT,@JavascriptField VARCHAR(8000),@JavascriptHeader VARCHAR(8000)) AS
SET NOCOUNT ON
UPDATE CardDigits SET JavascriptHeader = @JavascriptHeader,
	JavascriptField = @JavascriptField
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CardDigits (AllowLogin,AllowPassword,CardDigit,IEAID,JavascriptField,JavascriptHeader)
VALUES (@AllowLogin,@AllowPassword,@CardDigit,@IEAID,@JavascriptField,@JavascriptHeader)
END
GO

CREATE PROCEDURE dbo.CT_CardTypes (@CRC VARCHAR(255),@CardType VARCHAR(255),@CardTypeID INT,@Length1 INT,@Length2 INT) AS
SET NOCOUNT ON
UPDATE CardTypes SET CRC = @CRC,
	CardType = @CardType,
	Length1 = @Length1,
	Length2 = @Length2
	WHERE CardTypeID = @CardTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CardTypes (CRC,CardType,CardTypeID,Length1,Length2)
VALUES (@CRC,@CardType,@CardTypeID,@Length1,@Length2)
END
GO

CREATE PROCEDURE dbo.CT_CardTypePrefixes (@CardTypeID INT,@Prefix VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM CardTypePrefixes WHERE CardTypeID = @CardTypeID AND Prefix = @Prefix
IF (@CTcnt = 0)
BEGIN
INSERT INTO CardTypePrefixes (CardTypeID,Prefix)
VALUES (@CardTypeID,@Prefix)
END
GO

CREATE PROCEDURE dbo.CT_ExportTypes (@ExportType VARCHAR(255),@ExportTypeID INT,@IsBatch SMALLINT,@IsCC SMALLINT,@IsRealtime SMALLINT) AS
SET NOCOUNT ON
UPDATE ExportTypes SET ExportType = @ExportType,
	IsBatch = @IsBatch,
	IsCC = @IsCC,
	IsRealtime = @IsRealtime
	WHERE ExportTypeID = @ExportTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExportTypes (ExportType,ExportTypeID,IsBatch,IsCC,IsRealtime)
VALUES (@ExportType,@ExportTypeID,@IsBatch,@IsCC,@IsRealtime)
END
GO

CREATE PROCEDURE dbo.CT_Exports (@ApproveMatch SMALLINT,@ApproveString VARCHAR(255),@AuthMatch SMALLINT,@AuthString VARCHAR(255),@CreditMatch SMALLINT,@CreditString VARCHAR(255),@DeclineMatch SMALLINT,@DeclineString VARCHAR(255),@DefaultProcessorURL VARCHAR(255),@Description VARCHAR(255),@ExportID INT,@ExportType SMALLINT,@Features INT,@Filter VARCHAR(255),@FormatDefault INT,@HeaderRow SMALLINT,@ImportKeySeparator VARCHAR(255),@ImportKeyValueSeparator VARCHAR(255),@Lines SMALLINT,@QuoteString VARCHAR(255),@SQLString VARCHAR(255),@Separator VARCHAR(255),@StageCount INT,@Template VARCHAR(8000),@VoidMatch SMALLINT,@VoidString VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Exports SET ApproveMatch = @ApproveMatch,
	ApproveString = @ApproveString,
	AuthMatch = @AuthMatch,
	AuthString = @AuthString,
	CreditMatch = @CreditMatch,
	CreditString = @CreditString,
	DeclineMatch = @DeclineMatch,
	DeclineString = @DeclineString,
	DefaultProcessorURL = @DefaultProcessorURL,
	Description = @Description,
	ExportType = @ExportType,
	Features = @Features,
	Filter = @Filter,
	FormatDefault = @FormatDefault,
	HeaderRow = @HeaderRow,
	ImportKeySeparator = @ImportKeySeparator,
	ImportKeyValueSeparator = @ImportKeyValueSeparator,
	Lines = @Lines,
	QuoteString = @QuoteString,
	SQLString = @SQLString,
	Separator = @Separator,
	StageCount = @StageCount,
	Template = @Template,
	VoidMatch = @VoidMatch,
	VoidString = @VoidString
	WHERE ExportID = @ExportID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Exports (ApproveMatch,ApproveString,AuthMatch,AuthString,CreditMatch,CreditString,DeclineMatch,DeclineString,DefaultProcessorURL,Description,ExportID,ExportType,Features,Filter,FormatDefault,HeaderRow,ImportKeySeparator,ImportKeyValueSeparator,Lines,QuoteString,SQLString,Separator,StageCount,Template,VoidMatch,VoidString)
VALUES (@ApproveMatch,@ApproveString,@AuthMatch,@AuthString,@CreditMatch,@CreditString,@DeclineMatch,@DeclineString,@DefaultProcessorURL,@Description,@ExportID,@ExportType,@Features,@Filter,@FormatDefault,@HeaderRow,@ImportKeySeparator,@ImportKeyValueSeparator,@Lines,@QuoteString,@SQLString,@Separator,@StageCount,@Template,@VoidMatch,@VoidString)
END
GO

CREATE PROCEDURE dbo.CT_ExportColumns (@Align SMALLINT,@Description VARCHAR(255),@ExportID INT,@ExportValue VARCHAR(255),@FieldName VARCHAR(255),@Format SMALLINT,@IEAID INT,@Include SMALLINT,@MaxSize SMALLINT,@MinSize SMALLINT,@Padding CHAR(32),@Quoted SMALLINT,@SortOrder SMALLINT,@TransType INT) AS
SET NOCOUNT ON
UPDATE ExportColumns SET Align = @Align,
	Description = @Description,
	ExportID = @ExportID,
	ExportValue = @ExportValue,
	FieldName = @FieldName,
	Format = @Format,
	Include = @Include,
	MaxSize = @MaxSize,
	MinSize = @MinSize,
	Padding = @Padding,
	Quoted = @Quoted,
	SortOrder = @SortOrder,
	TransType = @TransType
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExportColumns (Align,Description,ExportID,ExportValue,FieldName,Format,IEAID,Include,MaxSize,MinSize,Padding,Quoted,SortOrder,TransType)
VALUES (@Align,@Description,@ExportID,@ExportValue,@FieldName,@Format,@IEAID,@Include,@MaxSize,@MinSize,@Padding,@Quoted,@SortOrder,@TransType)
END
GO

CREATE PROCEDURE dbo.CT_CCImportColumns (@ApproveValue VARCHAR(255),@DeclineValue VARCHAR(255),@Description VARCHAR(255),@ErrorValue VARCHAR(255),@ExportID INT,@FieldSize SMALLINT,@FieldType SMALLINT,@IEAID INT,@Line INT,@Position SMALLINT,@Quoted SMALLINT,@SortOrder SMALLINT,@TransType INT) AS
SET NOCOUNT ON
UPDATE CCImportColumns SET ApproveValue = @ApproveValue,
	DeclineValue = @DeclineValue,
	Description = @Description,
	ErrorValue = @ErrorValue,
	ExportID = @ExportID,
	FieldSize = @FieldSize,
	FieldType = @FieldType,
	Line = @Line,
	Position = @Position,
	Quoted = @Quoted,
	SortOrder = @SortOrder,
	TransType = @TransType
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO CCImportColumns (ApproveValue,DeclineValue,Description,ErrorValue,ExportID,FieldSize,FieldType,IEAID,Line,Position,Quoted,SortOrder,TransType)
VALUES (@ApproveValue,@DeclineValue,@Description,@ErrorValue,@ExportID,@FieldSize,@FieldType,@IEAID,@Line,@Position,@Quoted,@SortOrder,@TransType)
END
GO

CREATE PROCEDURE dbo.CT_ConfigGroups (@ConfigGroupID INT,@Name VARCHAR(255),@SortOrder INT,@VisibleGlobal SMALLINT,@VisibleGroupID SMALLINT,@VisibleOperatorGroupID SMALLINT) AS
SET NOCOUNT ON
UPDATE ConfigGroups SET Name = @Name,
	SortOrder = @SortOrder,
	VisibleGlobal = @VisibleGlobal,
	VisibleGroupID = @VisibleGroupID,
	VisibleOperatorGroupID = @VisibleOperatorGroupID
	WHERE ConfigGroupID = @ConfigGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ConfigGroups (ConfigGroupID,Name,SortOrder,VisibleGlobal,VisibleGroupID,VisibleOperatorGroupID)
VALUES (@ConfigGroupID,@Name,@SortOrder,@VisibleGlobal,@VisibleGroupID,@VisibleOperatorGroupID)
END
GO

CREATE PROCEDURE dbo.CT_Configs (@AllowGlobal SMALLINT,@AllowGroupID SMALLINT,@AllowOperatorGroupID SMALLINT,@ConfigGroupID INT,@ConfigID INT,@Data VARCHAR(255),@DataTypeID SMALLINT,@Description VARCHAR(255),@FeatureID INT,@NumValue NUMERIC(18,4),@SortOrder SMALLINT,@ValuesQuery VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Configs SET ConfigGroupID = @ConfigGroupID,
	DataTypeID = @DataTypeID,
	Description = @Description,
	FeatureID = @FeatureID,
	AllowGlobal = @AllowGlobal,
	AllowGroupID = @AllowGroupID,
	AllowOperatorGroupID = @AllowOperatorGroupID,
	ValuesQuery = @ValuesQuery
	WHERE ConfigID = @ConfigID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Configs (AllowGlobal,AllowGroupID,AllowOperatorGroupID,ConfigGroupID,ConfigID,Data,DataTypeID,Description,FeatureID,NumValue,SortOrder,ValuesQuery)
VALUES (@AllowGlobal,@AllowGroupID,@AllowOperatorGroupID,@ConfigGroupID,@ConfigID,@Data,@DataTypeID,@Description,@FeatureID,@NumValue,@SortOrder,@ValuesQuery)
END
GO

CREATE PROCEDURE dbo.CT_ConfigValues (@ConfigID INT,@NumValue NUMERIC(18,4),@ValueName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ConfigValues SET ValueName = @ValueName
	WHERE ConfigID = @ConfigID
	AND NumValue = @NumValue

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ConfigValues (ConfigID,NumValue,ValueName)
VALUES (@ConfigID,@NumValue,@ValueName)
END
GO

CREATE PROCEDURE dbo.CT_Continents (@Continent VARCHAR(255),@ContinentID INT,@Hidden SMALLINT,@Planet VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Continents SET ContinentID = @ContinentID,
	Continent = @Continent,
	Planet = @Planet
	WHERE ContinentID = @ContinentID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Continents (Continent,ContinentID,Hidden,Planet,SortOrder)
VALUES (@Continent,@ContinentID,@Hidden,@Planet,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_Countries (@Abbr2 CHAR(32),@Abbr3 CHAR(32),@Comments VARCHAR(255),@ContinentID INT,@Country VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@Hidden SMALLINT,@InternetDomain VARCHAR(255),@Restricted SMALLINT,@SortOrder SMALLINT,@TelIDD VARCHAR(255),@TelLocPrefixLen SMALLINT,@TelNDD VARCHAR(255),@TelPrefix VARCHAR(255),@ZipStatus SMALLINT) AS
SET NOCOUNT ON
UPDATE Countries SET CountryID = @CountryID,
	ZipStatus = @ZipStatus,
	Country = @Country,
	InternetDomain = @InternetDomain,
	ContinentID = @ContinentID,
	TelPrefix = @TelPrefix,
	TelIDD = @TelIDD,
	TelNDD = @TelNDD,
	TelLocPrefixLen = @TelLocPrefixLen,
	Abbr2 = @Abbr2,
	Abbr3 = @Abbr3
	WHERE CountryID = @CountryID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Countries (Abbr2,Abbr3,Comments,ContinentID,Country,CountryID,Currency,Hidden,InternetDomain,Restricted,SortOrder,TelIDD,TelLocPrefixLen,TelNDD,TelPrefix,ZipStatus)
VALUES (@Abbr2,@Abbr3,@Comments,@ContinentID,@Country,@CountryID,@Currency,@Hidden,@InternetDomain,@Restricted,@SortOrder,@TelIDD,@TelLocPrefixLen,@TelNDD,@TelPrefix,@ZipStatus)
END
GO

CREATE PROCEDURE dbo.CT_TimeZones (@StringID INT,@TimeZone VARCHAR(255),@TimeZoneID NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE TimeZones SET StringID = @StringID,
	TimeZone = @TimeZone
	WHERE TimeZoneID = @TimeZoneID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TimeZones (StringID,TimeZone,TimeZoneID)
VALUES (@StringID,@TimeZone,@TimeZoneID)
END
GO

CREATE PROCEDURE dbo.CT_States (@Abbreviation VARCHAR(255),@CountryID INT,@SortOrder SMALLINT,@State VARCHAR(255),@TimeZone1 NUMERIC(18,4),@TimeZone2 NUMERIC(18,4)) AS
SET NOCOUNT ON
UPDATE States SET CountryID = @CountryID,
	State = @State,
	Abbreviation = @Abbreviation,
	TimeZone1 = @TimeZone1,
	TimeZone2 = @TimeZone2
	WHERE CountryID = @CountryID
	AND State = @State

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO States (Abbreviation,CountryID,SortOrder,State,TimeZone1,TimeZone2)
VALUES (@Abbreviation,@CountryID,@SortOrder,@State,@TimeZone1,@TimeZone2)
END
GO

CREATE PROCEDURE dbo.CT_EmailTypes (@EmailType VARCHAR(255),@EmailTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE EmailTypes SET EmailType = @EmailType
	WHERE EmailTypeID = @EmailTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO EmailTypes (EmailType,EmailTypeID)
VALUES (@EmailType,@EmailTypeID)
END
GO

CREATE PROCEDURE dbo.CT_PrintTypes (@CRData VARCHAR(255),@Data VARCHAR(255),@PrintType VARCHAR(255),@PrintTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE PrintTypes SET CRData = @CRData,
	Data = @Data,
	PrintType = @PrintType
	WHERE PrintTypeID = @PrintTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (@CRData,@Data,@PrintType,@PrintTypeID)
END
GO

CREATE PROCEDURE dbo.CT_ExternalSystemTypes (@DescAux1 VARCHAR(255),@DescAux2 VARCHAR(255),@DescAux3 VARCHAR(255),@ExportID INT,@ExternalSystemType VARCHAR(255),@ExternalSystemTypeID INT,@ShowExportID SMALLINT,@ShowLogin SMALLINT,@ShowMailHost SMALLINT,@ShowPassword SMALLINT,@ShowURL SMALLINT) AS
SET NOCOUNT ON
UPDATE ExternalSystemTypes SET DescAux1 = @DescAux1,
	DescAux2 = @DescAux2,
	DescAux3 = @DescAux3,
	ExportID = @ExportID,
	ExternalSystemType = @ExternalSystemType,
	ShowExportID = @ShowExportID,
	ShowLogin = @ShowLogin,
	ShowMailHost = @ShowMailHost,
	ShowPassword = @ShowPassword,
	ShowURL = @ShowURL
	WHERE ExternalSystemTypeID = @ExternalSystemTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExternalSystemTypes (DescAux1,DescAux2,DescAux3,ExportID,ExternalSystemType,ExternalSystemTypeID,ShowExportID,ShowLogin,ShowMailHost,ShowPassword,ShowURL)
VALUES (@DescAux1,@DescAux2,@DescAux3,@ExportID,@ExternalSystemType,@ExternalSystemTypeID,@ShowExportID,@ShowLogin,@ShowMailHost,@ShowPassword,@ShowURL)
END
GO

CREATE PROCEDURE dbo.CT_ExternalSystemDataTypes (@AccountDataTypeID INT,@ExternalSystemTypeID INT,@Required SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE ExternalSystemDataTypes SET ExternalSystemTypeID = @ExternalSystemTypeID,
	AccountDataTypeID = @AccountDataTypeID
	WHERE ExternalSystemTypeID = @ExternalSystemTypeID
	AND AccountDataTypeID = @AccountDataTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ExternalSystemDataTypes (AccountDataTypeID,ExternalSystemTypeID,Required,SortOrder)
VALUES (@AccountDataTypeID,@ExternalSystemTypeID,@Required,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_FilterTypes (@Checked INT,@Description VARCHAR(255),@FilterType VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE FilterTypes SET Checked = @Checked,
	Description = @Description,
	SortOrder = @SortOrder
	WHERE FilterType = @FilterType

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO FilterTypes (Checked,Description,FilterType,SortOrder)
VALUES (@Checked,@Description,@FilterType,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_Currencies (@Active SMALLINT,@Code VARCHAR(255),@CountryID INT,@Currency VARCHAR(255),@CurrencyID INT,@SortOrder SMALLINT,@Symbol VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE Currencies SET CountryID = @CountryID,
	Currency = @Currency,
	Symbol = @Symbol,
	Code = @Code
	WHERE CurrencyID = @CurrencyID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Currencies (Active,Code,CountryID,Currency,CurrencyID,SortOrder,Symbol)
VALUES (@Active,@Code,@CountryID,@Currency,@CurrencyID,@SortOrder,@Symbol)
END
GO

CREATE PROCEDURE dbo.CT_Organizations (@InvoiceDetailed SMALLINT,@InvoiceFractional SMALLINT,@MaxAccounts INT,@Organization VARCHAR(255),@OrganizationID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Organizations WHERE OrganizationID = @OrganizationID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Organizations ON


INSERT INTO Organizations (InvoiceDetailed,InvoiceFractional,MaxAccounts,Organization,OrganizationID)
VALUES (@InvoiceDetailed,@InvoiceFractional,@MaxAccounts,@Organization,@OrganizationID)
SET IDENTITY_INSERT Organizations OFF
END
GO

CREATE PROCEDURE dbo.CT_Groups (@Active SMALLINT,@AutoEmailInvoices SMALLINT,@AutoEmailStatements SMALLINT,@BillAddress1 VARCHAR(255),@BillAddress2 VARCHAR(255),@BillCity VARCHAR(255),@BillCountryID INT,@BillFax VARCHAR(255),@BillName VARCHAR(255),@BillPhone VARCHAR(255),@BillState VARCHAR(255),@BillZip VARCHAR(255),@BillingOption SMALLINT,@Description VARCHAR(255),@DomainID INT,@EmailAccounts VARCHAR(255),@EmailSubject VARCHAR(255),@EndDate DATETIME,@FTPDir VARCHAR(255),@GlobalAccountTypes SMALLINT,@GlobalBillingCycles SMALLINT,@GlobalChargeTypes SMALLINT,@GlobalDiscounts SMALLINT,@GlobalDomains SMALLINT,@GlobalIncidentTypes SMALLINT,@GlobalPackageTypes SMALLINT,@GlobalPayPeriods SMALLINT,@GlobalRegions SMALLINT,@GlobalSalesPersons SMALLINT,@GlobalSendMethods SMALLINT,@GroupID INT,@GroupName VARCHAR(255),@InvoiceHTMLReport VARCHAR(255),@InvoiceReport VARCHAR(255),@InvoiceTextReport VARCHAR(255),@MBRFields INT,@OrganizationID INT,@PaymentTypes INT,@SendCredits SMALLINT,@SortOrder SMALLINT,@StartDate DATETIME,@StatementHTMLReport VARCHAR(255),@StatementReport VARCHAR(255),@StatementTextReport VARCHAR(255),@ThemeID INT,@ThemeScore INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Groups WHERE GroupID = @GroupID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Groups ON


INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillZip,BillingOption,Description,DomainID,EmailAccounts,EmailSubject,EndDate,FTPDir,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDiscounts,GlobalDomains,GlobalIncidentTypes,GlobalPackageTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,MBRFields,OrganizationID,PaymentTypes,SendCredits,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (@Active,@AutoEmailInvoices,@AutoEmailStatements,@BillAddress1,@BillAddress2,@BillCity,@BillCountryID,@BillFax,@BillName,@BillPhone,@BillState,@BillZip,@BillingOption,@Description,@DomainID,@EmailAccounts,@EmailSubject,@EndDate,@FTPDir,@GlobalAccountTypes,@GlobalBillingCycles,@GlobalChargeTypes,@GlobalDiscounts,@GlobalDomains,@GlobalIncidentTypes,@GlobalPackageTypes,@GlobalPayPeriods,@GlobalRegions,@GlobalSalesPersons,@GlobalSendMethods,@GroupID,@GroupName,@InvoiceHTMLReport,@InvoiceReport,@InvoiceTextReport,@MBRFields,@OrganizationID,@PaymentTypes,@SendCredits,@SortOrder,@StartDate,@StatementHTMLReport,@StatementReport,@StatementTextReport,@ThemeID,@ThemeScore)
SET IDENTITY_INSERT Groups OFF
END
GO

CREATE PROCEDURE dbo.CT_Languages (@Active SMALLINT,@AllowIEAUpdate SMALLINT,@BaseURL VARCHAR(255),@Description VARCHAR(255),@HttpAcceptLanguage VARCHAR(255),@LanguageID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Languages SET LanguageID = @LanguageID,
	Description = @Description,
	BaseURL = @BaseURL,
	HttpAcceptLanguage = @HttpAcceptLanguage
	WHERE LanguageID = @LanguageID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Languages (Active,AllowIEAUpdate,BaseURL,Description,HttpAcceptLanguage,LanguageID,SortOrder)
VALUES (@Active,@AllowIEAUpdate,@BaseURL,@Description,@HttpAcceptLanguage,@LanguageID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_Strings (@ApplicationID INT,@Data VARCHAR(255),@LanguageID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE Strings SET Data = @Data
	WHERE ApplicationID = @ApplicationID
	AND StringID = @StringID
	AND LanguageID = @LanguageID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Strings (ApplicationID,Data,LanguageID,StringID)
VALUES (@ApplicationID,@Data,@LanguageID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_LogMsgs (@Description VARCHAR(255),@LogMsgID INT,@Severity INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE LogMsgs SET Description = @Description,
	Severity = @Severity,
	StringID = @StringID
	WHERE LogMsgID = @LogMsgID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO LogMsgs (Description,LogMsgID,Severity,StringID)
VALUES (@Description,@LogMsgID,@Severity,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_MenuItems (@Access VARCHAR(255),@AccessKey VARCHAR(255),@Attribute VARCHAR(255),@ColumnName VARCHAR(255),@Condition VARCHAR(255),@DescStringID INT,@Description VARCHAR(255),@FeatureID INT,@FileName VARCHAR(255),@HelpStringID INT,@Label VARCHAR(255),@Link VARCHAR(255),@MenuItem VARCHAR(255),@MenuItemID INT,@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE MenuItems SET TableName = @TableName,
	ColumnName = @ColumnName,
	FileName = @FileName,
	Access = @Access,
	Condition = @Condition,
	FeatureID = @FeatureID,
	DescStringID = @DescStringID,
	HelpStringID = @HelpStringID,
	Link = @Link,
	Attribute = @Attribute
	WHERE MenuItemID = @MenuItemID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MenuItems (Access,AccessKey,Attribute,ColumnName,Condition,DescStringID,Description,FeatureID,FileName,HelpStringID,Label,Link,MenuItem,MenuItemID,TableName)
VALUES (@Access,@AccessKey,@Attribute,@ColumnName,@Condition,@DescStringID,@Description,@FeatureID,@FileName,@HelpStringID,@Label,@Link,@MenuItem,@MenuItemID,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_Menus (@Class VARCHAR(255),@Description VARCHAR(8000),@Menu VARCHAR(255),@MenuID INT) AS
SET NOCOUNT ON
UPDATE Menus SET Class = @Class,
	Description = @Description,
	Menu = @Menu
	WHERE MenuID = @MenuID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Menus (Class,Description,Menu,MenuID)
VALUES (@Class,@Description,@Menu,@MenuID)
END
GO

CREATE PROCEDURE dbo.CT_MenuSets (@MenuID INT,@MenuItemID INT,@SortOrder INT) AS
SET NOCOUNT ON
UPDATE MenuSets SET SortOrder = @SortOrder
	WHERE MenuID = @MenuID
	AND MenuItemID = @MenuItemID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MenuSets (MenuID,MenuItemID,SortOrder)
VALUES (@MenuID,@MenuItemID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_MetaRules (@Description VARCHAR(255),@MetaRuleID INT) AS
SET NOCOUNT ON
UPDATE MetaRules SET Description = @Description
	WHERE MetaRuleID = @MetaRuleID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MetaRules (Description,MetaRuleID)
VALUES (@Description,@MetaRuleID)
END
GO

CREATE PROCEDURE dbo.CT_MetaTables (@Description VARCHAR(255),@GroupTable VARCHAR(255),@SortOrder INT,@TableName VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE MetaTables SET Description = @Description,
	GroupTable = @GroupTable,
	SortOrder = @SortOrder
	WHERE TableName = @TableName

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO MetaTables (Description,GroupTable,SortOrder,TableName)
VALUES (@Description,@GroupTable,@SortOrder,@TableName)
END
GO

CREATE PROCEDURE dbo.CT_MetaColumns (@TableName VARCHAR(32), @ColumnName VARCHAR(32), @Description VARCHAR(255), @DepTable VARCHAR(32), @DepColumn VARCHAR(32), @DepGroup INT, @MetaRuleID INT, @Required SMALLINT, @Nullable SMALLINT, @Quoted SMALLINT, @MinSize INT, @MaxSize INT, @IsKey SMALLINT, @ColumnType INT, @HelpText VARCHAR(8000)) AS
SET NOCOUNT ON
DECLARE @MetaTableID INT
SELECT @MetaTableID = MetaTableID FROM MetaTables WHERE TableName = @TableName
IF (@MetaTableID IS NOT NULL)
BEGIN
UPDATE MetaColumns SET Description = @Description,
	DepTable = @DepTable,
	DepGroup = @DepGroup,
	MetaRuleID = @MetaRuleID,
	Required = @Required,
	Nullable = @Nullable,
	Quoted = @Quoted,
	MinSize = @MinSize,
	MaxSize = CASE WHEN @MaxSize > MaxSize THEN @MaxSize ELSE MaxSize END,
	IsKey = @IsKey,
	ColumnType = @ColumnType,
	HelpText = @HelpText
	WHERE MetaTableID = @MetaTableID
	AND ColumnName = @ColumnName
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO MetaColumns (MetaTableID,ColumnName,Description,DepTable,DepColumn,DepGroup,MetaRuleID,Required,Nullable,Quoted,MinSize,MaxSize,IsKey,ColumnType,HelpText)
	VALUES (@MetaTableID,@ColumnName,@Description,@DepTable,@DepColumn,@DepGroup,@MetaRuleID,@Required,@Nullable,@Quoted,@MinSize,@MaxSize,@IsKey,@ColumnType,@HelpText)
	END
END
GO

CREATE PROCEDURE dbo.CT_NoticeTypes (@DefaultText VARCHAR(8000),@Description VARCHAR(8000),@IEAID INT,@IEATag INT,@InternalID SMALLINT,@NoticeType VARCHAR(255),@Parm1Desc VARCHAR(255),@Parm1Query VARCHAR(8000),@Parm1TypeID SMALLINT,@Parm2Desc VARCHAR(255),@Parm2Query VARCHAR(8000),@Parm2TypeID SMALLINT,@Parm3Desc VARCHAR(255),@Parm3Query VARCHAR(8000),@Parm3TypeID SMALLINT,@ReportFile VARCHAR(255),@SQLQuery VARCHAR(8000),@SentQuery VARCHAR(8000)) AS
SET NOCOUNT ON
UPDATE NoticeTypes SET IEATag = @IEATag,
	NoticeType = @NoticeType,
	Description = @Description,
	SQLQuery = @SQLQuery,
	ReportFile = @ReportFile,
	Parm1Desc = @Parm1Desc,
	Parm2Desc = @Parm2Desc,
	Parm3Desc = @Parm3Desc,
	Parm1TypeID = @Parm1TypeID,
	Parm2TypeID = @Parm2TypeID,
	Parm3TypeID = @Parm3TypeID,
	InternalID = @InternalID,
	Parm1Query = @Parm1Query,
	Parm2Query = @Parm2Query,
	Parm3Query = @Parm3Query
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO NoticeTypes (DefaultText,Description,IEAID,IEATag,InternalID,NoticeType,Parm1Desc,Parm1Query,Parm1TypeID,Parm2Desc,Parm2Query,Parm2TypeID,Parm3Desc,Parm3Query,Parm3TypeID,ReportFile,SQLQuery,SentQuery)
VALUES (@DefaultText,@Description,@IEAID,@IEATag,@InternalID,@NoticeType,@Parm1Desc,@Parm1Query,@Parm1TypeID,@Parm2Desc,@Parm2Query,@Parm2TypeID,@Parm3Desc,@Parm3Query,@Parm3TypeID,@ReportFile,@SQLQuery,@SentQuery)
END
GO

CREATE PROCEDURE dbo.CT_Notices (@InternalID INT, @Active INT, @Notice VARCHAR(64), @MailFrom VARCHAR(128), @MailSubject VARCHAR(128), @MailCC VARCHAR(128), @NoticeText VARCHAR(8000)) AS
INSERT INTO Notices (InternalID, NoticeTypeID, Active, Notice, MailFrom, MailSubject, MailCC, NoticeText)
SELECT nt.InternalID, nt.NoticeTypeID, @Active, @Notice, @MailFrom, @MailSubject, @MailCC, @NoticeText
FROM NoticeTypes nt
	WHERE nt.InternalID = @InternalID
	AND nt.InternalID NOT IN (SELECT InternalID FROM Notices)
GO

CREATE PROCEDURE dbo.CT_ObjectGroups (@Description VARCHAR(8000),@ObjectGroup VARCHAR(255),@ObjectGroupID INT) AS
SET NOCOUNT ON
UPDATE ObjectGroups SET Description = @Description,
	ObjectGroup = @ObjectGroup
	WHERE ObjectGroupID = @ObjectGroupID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ObjectGroups (Description,ObjectGroup,ObjectGroupID)
VALUES (@Description,@ObjectGroup,@ObjectGroupID)
END
GO

CREATE PROCEDURE dbo.CT_Objects (@TableName VARCHAR(255), @ColumnName VARCHAR(255), @FileName VARCHAR(255), @ObjectTypeID INT, @ObjectGroupID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
IF (@ObjectTypeID = 1)
BEGIN
SELECT @CTcnt = COUNT(*) FROM Objects WHERE ObjectGroupID = @ObjectGroupID AND ObjectTypeID = 1 AND Data = @FileName
END
IF (@ObjectTypeID = 1 AND @CTcnt = 0)
BEGIN
INSERT INTO Objects (Data,ObjectGroupID,ObjectTypeID)
VALUES(@FileName,@ObjectGroupID,1)
END
IF (@ObjectTypeID = 2)
BEGIN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID)
SELECT mt.MetaTableID,@ObjectGroupID,2
FROM MetaTables mt
	WHERE mt.TableName = @TableName
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mt.MetaTableID AND ObjectGroupID = @ObjectGroupID AND ObjectTypeID = 2)
END
IF (@ObjectTypeID = 3)
BEGIN
INSERT INTO Objects (Value,ObjectGroupID,ObjectTypeID)
SELECT mc.MetaColumnID,@ObjectGroupID,3
FROM MetaTables mt, MetaColumns mc
	WHERE mt.TableName = @TableName
	AND mt.MetaTableID = mc.MetaTableID
	AND mc.ColumnName = @ColumnName
	AND NOT EXISTS (SELECT * FROM Objects WHERE Value = mc.MetaColumnID AND ObjectGroupID = @ObjectGroupID AND ObjectTypeID = 3)
END
GO

CREATE PROCEDURE dbo.CT_PaymentTypes (@CustomerAccess SMALLINT,@CustomerDescription VARCHAR(255),@CustomerPayment SMALLINT,@CustomerStringID INT,@GLCodeID INT,@IsPayMethod SMALLINT,@IsPayType SMALLINT,@PaymentType VARCHAR(255),@PaymentTypeID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
UPDATE PaymentTypes SET IsPayMethod = @IsPayMethod,
	IsPayType = @IsPayType,
	CustomerAccess = @CustomerAccess,
	CustomerPayment = @CustomerPayment
	WHERE PaymentTypeID = @PaymentTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PaymentTypes (CustomerAccess,CustomerDescription,CustomerPayment,CustomerStringID,GLCodeID,IsPayMethod,IsPayType,PaymentType,PaymentTypeID,SortOrder,StringID)
VALUES (@CustomerAccess,@CustomerDescription,@CustomerPayment,@CustomerStringID,@GLCodeID,@IsPayMethod,@IsPayType,@PaymentType,@PaymentTypeID,@SortOrder,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_Priorities (@Priority VARCHAR(255),@PriorityID SMALLINT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Priorities WHERE PriorityID = @PriorityID
IF (@CTcnt = 0)
BEGIN
INSERT INTO Priorities (Priority,PriorityID,StringID)
VALUES (@Priority,@PriorityID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RadDestTypes (@RadDestType VARCHAR(255),@RadDestTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE RadDestTypes SET RadDestType = @RadDestType,
	SortOrder = @SortOrder
	WHERE RadDestTypeID = @RadDestTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID,SortOrder)
VALUES (@RadDestType,@RadDestTypeID,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RadSourceTypes (@RadSourceType VARCHAR(255),@RadSourceTypeID INT) AS
SET NOCOUNT ON
UPDATE RadSourceTypes SET RadSourceType = @RadSourceType
	WHERE RadSourceTypeID = @RadSourceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID)
VALUES (@RadSourceType,@RadSourceTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RadFilterTypes (@RadFilterType VARCHAR(255),@RadFilterTypeID INT) AS
SET NOCOUNT ON
UPDATE RadFilterTypes SET RadFilterType = @RadFilterType
	WHERE RadFilterTypeID = @RadFilterTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadFilterTypes (RadFilterType,RadFilterTypeID)
VALUES (@RadFilterType,@RadFilterTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RadMergeTypes (@RadMergeType CHAR(32),@RadMergeTypeID INT) AS
SET NOCOUNT ON
UPDATE RadMergeTypes SET RadMergeType = @RadMergeType
	WHERE RadMergeTypeID = @RadMergeTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID)
VALUES (@RadMergeType,@RadMergeTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RadLogMsgs (@Description VARCHAR(255),@RadLogMsgID INT,@Severity INT) AS
SET NOCOUNT ON
UPDATE RadLogMsgs SET Description = @Description,
	Severity = @Severity
	WHERE RadLogMsgID = @RadLogMsgID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadLogMsgs (Description,RadLogMsgID,Severity)
VALUES (@Description,@RadLogMsgID,@Severity)
END
GO

CREATE PROCEDURE dbo.CT_RadRejectAttributes (@Data VARCHAR(255),@IEAID INT,@RadAttributeID INT,@RadLogMsgID INT,@RadVendorID INT,@ServerID INT) AS
SET NOCOUNT ON
UPDATE RadRejectAttributes SET RadLogMsgID = @RadLogMsgID,
	RadVendorID = @RadVendorID,
	RadAttributeID = @RadAttributeID,
	Data = @Data
	WHERE IEAID = @IEAID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadRejectAttributes (Data,IEAID,RadAttributeID,RadLogMsgID,RadVendorID,ServerID)
VALUES (@Data,@IEAID,@RadAttributeID,@RadLogMsgID,@RadVendorID,@ServerID)
END
GO

CREATE PROCEDURE dbo.CT_RadSearchTypes (@RadSearchType VARCHAR(255),@RadSearchTypeID INT) AS
SET NOCOUNT ON
UPDATE RadSearchTypes SET RadSearchType = @RadSearchType
	WHERE RadSearchTypeID = @RadSearchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RadSearchTypes (RadSearchType,RadSearchTypeID)
VALUES (@RadSearchType,@RadSearchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateRuleTypes (@RateRuleType VARCHAR(255),@RateRuleTypeID INT) AS
SET NOCOUNT ON
UPDATE RateRuleTypes SET RateRuleType = @RateRuleType
	WHERE RateRuleTypeID = @RateRuleTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRuleTypes (RateRuleType,RateRuleTypeID)
VALUES (@RateRuleType,@RateRuleTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateIntervals (@NamePlural VARCHAR(255),@NameShort VARCHAR(255),@NameSingular VARCHAR(255),@RateIntervalID INT,@RateRuleTypeID INT) AS
SET NOCOUNT ON
UPDATE RateIntervals SET RateRuleTypeID = @RateRuleTypeID
	WHERE RateIntervalID = @RateIntervalID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateIntervals (NamePlural,NameShort,NameSingular,RateIntervalID,RateRuleTypeID)
VALUES (@NamePlural,@NameShort,@NameSingular,@RateIntervalID,@RateRuleTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateIPPorts (@Description VARCHAR(255),@Port INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM RateIPPorts WHERE Port = @Port
IF (@CTcnt = 0)
BEGIN
INSERT INTO RateIPPorts (Description,Port,SortOrder)
VALUES (@Description,@Port,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RateIPProtocols (@Description VARCHAR(255),@Protocol INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM RateIPProtocols WHERE Protocol = @Protocol
IF (@CTcnt = 0)
BEGIN
INSERT INTO RateIPProtocols (Description,Protocol,SortOrder)
VALUES (@Description,@Protocol,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_RateMatchTypes (@RateMatchType VARCHAR(255),@RateMatchTypeID INT) AS
SET NOCOUNT ON
UPDATE RateMatchTypes SET RateMatchType = @RateMatchType
	WHERE RateMatchTypeID = @RateMatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateMatchTypes (RateMatchType,RateMatchTypeID)
VALUES (@RateMatchType,@RateMatchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateRoundTypes (@AllowData SMALLINT,@AllowTime SMALLINT,@RateRoundType VARCHAR(255),@RateRoundTypeID INT) AS
SET NOCOUNT ON
UPDATE RateRoundTypes SET AllowData = @AllowData,
	AllowTime = @AllowTime,
	RateRoundType = @RateRoundType
	WHERE RateRoundTypeID = @RateRoundTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRoundTypes (AllowData,AllowTime,RateRoundType,RateRoundTypeID)
VALUES (@AllowData,@AllowTime,@RateRoundType,@RateRoundTypeID)
END
GO

CREATE PROCEDURE dbo.CT_RateSources (@AllowData SMALLINT,@AllowTime SMALLINT,@RateSource VARCHAR(255),@RateSourceID INT) AS
SET NOCOUNT ON
UPDATE RateSources SET AllowData = @AllowData,
	AllowTime = @AllowTime,
	RateSource = @RateSource
	WHERE RateSourceID = @RateSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateSources (AllowData,AllowTime,RateSource,RateSourceID)
VALUES (@AllowData,@AllowTime,@RateSource,@RateSourceID)
END
GO

CREATE PROCEDURE dbo.CT_RateSourceAttributes (@AllowData SMALLINT,@AllowTime SMALLINT,@Attribute VARCHAR(255),@Description VARCHAR(255),@Dynamic SMALLINT,@RateMatchTypes INT,@RateSourceID INT,@SortOrder SMALLINT,@ValuesQuery VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateSourceAttributes SET RateSourceID = @RateSourceID,
	Attribute = @Attribute,
	Description = @Description,
	AllowData = @AllowData,
	AllowTime = @AllowTime,
	Dynamic = @Dynamic,
	ValuesQuery = @ValuesQuery,
	RateMatchTypes = @RateMatchTypes
	WHERE RateSourceID = @RateSourceID
	AND Attribute = @Attribute

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateSourceAttributes (AllowData,AllowTime,Attribute,Description,Dynamic,RateMatchTypes,RateSourceID,SortOrder,ValuesQuery)
VALUES (@AllowData,@AllowTime,@Attribute,@Description,@Dynamic,@RateMatchTypes,@RateSourceID,@SortOrder,@ValuesQuery)
END
GO

CREATE PROCEDURE dbo.CT_RateTypes (@RateSourceID INT,@RateType VARCHAR(255),@RateTypeID INT,@RuleQuery VARCHAR(255),@ScriptConfigure VARCHAR(255),@ScriptSummary VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateTypes SET RateSourceID = @RateSourceID,
	RateType = @RateType,
	RuleQuery = @RuleQuery,
	ScriptConfigure = @ScriptConfigure,
	ScriptSummary = @ScriptSummary
	WHERE RateTypeID = @RateTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateTypes (RateSourceID,RateType,RateTypeID,RuleQuery,ScriptConfigure,ScriptSummary)
VALUES (@RateSourceID,@RateType,@RateTypeID,@RuleQuery,@ScriptConfigure,@ScriptSummary)
END
GO

CREATE PROCEDURE dbo.CT_RateRules (@ClassQuery VARCHAR(255),@ClassRequired SMALLINT,@ClassTTL INT,@DefaultCost NUMERIC(18,4),@Description VARCHAR(8000),@Interval INT,@RateRoundTypeID INT,@RateRule VARCHAR(255),@RateRuleTypeID INT,@RateSourceID INT,@RateTypeID INT,@RuleQuery VARCHAR(255),@StringID INT) AS
SET NOCOUNT ON
UPDATE RateRules SET ClassQuery = @ClassQuery,
	ClassRequired = @ClassRequired,
	ClassTTL = @ClassTTL,
	DefaultCost = @DefaultCost,
	Description = @Description,
	Interval = @Interval,
	RateRoundTypeID = @RateRoundTypeID,
	RateRuleTypeID = @RateRuleTypeID,
	RateSourceID = @RateSourceID,
	RateTypeID = @RateTypeID,
	RuleQuery = @RuleQuery,
	StringID = @StringID
	WHERE RateRule = @RateRule

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateRules (ClassQuery,ClassRequired,ClassTTL,DefaultCost,Description,Interval,RateRoundTypeID,RateRule,RateRuleTypeID,RateSourceID,RateTypeID,RuleQuery,StringID)
VALUES (@ClassQuery,@ClassRequired,@ClassTTL,@DefaultCost,@Description,@Interval,@RateRoundTypeID,@RateRule,@RateRuleTypeID,@RateSourceID,@RateTypeID,@RuleQuery,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_ScheduleIntervals (@Interval VARCHAR(255),@Seconds INT) AS
SET NOCOUNT ON
UPDATE ScheduleIntervals SET Interval = @Interval
	WHERE Seconds = @Seconds

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ScheduleIntervals (Interval,Seconds)
VALUES (@Interval,@Seconds)
END
GO

CREATE PROCEDURE dbo.CT_ScheduleTasks (@Description VARCHAR(255),@TaskName VARCHAR(255),@TaskType VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ScheduleTasks SET Description = @Description,
	TaskType = @TaskType
	WHERE TaskName = @TaskName

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ScheduleTasks (Description,TaskName,TaskType)
VALUES (@Description,@TaskName,@TaskType)
END
GO

CREATE PROCEDURE dbo.CT_ServerTypes (@Model VARCHAR(255),@SNMPType INT,@SNMPUser VARCHAR(255),@ServerType INT,@Vendor VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE ServerTypes SET Model = @Model,
	SNMPType = @SNMPType,
	SNMPUser = @SNMPUser,
	Vendor = @Vendor
	WHERE ServerType = @ServerType

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ServerTypes (Model,SNMPType,SNMPUser,ServerType,Vendor)
VALUES (@Model,@SNMPType,@SNMPUser,@ServerType,@Vendor)
END
GO

CREATE PROCEDURE dbo.CT_ThemeMatchTypes (@Hidden SMALLINT,@ThemeMatchType VARCHAR(255),@ThemeMatchTypeID INT) AS
SET NOCOUNT ON
UPDATE ThemeMatchTypes SET Hidden = @Hidden,
	ThemeMatchType = @ThemeMatchType
	WHERE ThemeMatchTypeID = @ThemeMatchTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ThemeMatchTypes (Hidden,ThemeMatchType,ThemeMatchTypeID)
VALUES (@Hidden,@ThemeMatchType,@ThemeMatchTypeID)
END
GO

CREATE PROCEDURE dbo.CT_TransStates (@StringID INT,@TransState VARCHAR(255),@TransStateID INT) AS
SET NOCOUNT ON
UPDATE TransStates SET StringID = @StringID,
	TransState = @TransState
	WHERE TransStateID = @TransStateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TransStates (StringID,TransState,TransStateID)
VALUES (@StringID,@TransState,@TransStateID)
END
GO

CREATE PROCEDURE dbo.CT_TransTypes (@StringID INT,@TransType VARCHAR(255),@TransTypeID INT) AS
SET NOCOUNT ON
UPDATE TransTypes SET StringID = @StringID,
	TransType = @TransType
	WHERE TransTypeID = @TransTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO TransTypes (StringID,TransType,TransTypeID)
VALUES (@StringID,@TransType,@TransTypeID)
END
GO

CREATE PROCEDURE dbo.CT_WebAccess (@Name VARCHAR(255),@WebAccess INT) AS
SET NOCOUNT ON
UPDATE WebAccess SET Name = @Name
	WHERE WebAccess = @WebAccess

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO WebAccess (Name,WebAccess)
VALUES (@Name,@WebAccess)
END
GO

CREATE PROCEDURE dbo.CT_PeriodTypes (@AllowPayPeriod SMALLINT,@PeriodType VARCHAR(255),@PeriodTypeID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE PeriodTypes SET AllowPayPeriod = @AllowPayPeriod,
	PeriodType = @PeriodType,
	StringID = @StringID
	WHERE PeriodTypeID = @PeriodTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PeriodTypes (AllowPayPeriod,PeriodType,PeriodTypeID,StringID)
VALUES (@AllowPayPeriod,@PeriodType,@PeriodTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_RateDataSources (@BillingMode INT,@ClearQuery VARCHAR(8000),@DSN VARCHAR(255),@DataQuery VARCHAR(8000),@Password VARCHAR(255),@RateDataSource VARCHAR(255),@RateDataSourceID INT,@RateSourceID INT,@UpdateInterval SMALLINT,@UpdateQuery VARCHAR(8000),@UseTransactions SMALLINT,@Username VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE RateDataSources SET BillingMode = @BillingMode,
	ClearQuery = @ClearQuery,
	DSN = @DSN,
	DataQuery = @DataQuery,
	Password = @Password,
	RateDataSource = @RateDataSource,
	RateSourceID = @RateSourceID,
	UpdateInterval = @UpdateInterval,
	UpdateQuery = @UpdateQuery,
	UseTransactions = @UseTransactions,
	Username = @Username
	WHERE RateDataSourceID = @RateDataSourceID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO RateDataSources (BillingMode,ClearQuery,DSN,DataQuery,Password,RateDataSource,RateDataSourceID,RateSourceID,UpdateInterval,UpdateQuery,UseTransactions,Username)
VALUES (@BillingMode,@ClearQuery,@DSN,@DataQuery,@Password,@RateDataSource,@RateDataSourceID,@RateSourceID,@UpdateInterval,@UpdateQuery,@UseTransactions,@Username)
END
GO

CREATE PROCEDURE dbo.CT_InvoiceTypes (@InvoiceType VARCHAR(255),@InvoiceTypeID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE InvoiceTypes SET InvoiceType = @InvoiceType,
	StringID = @StringID
	WHERE InvoiceTypeID = @InvoiceTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvoiceTypes (InvoiceType,InvoiceTypeID,StringID)
VALUES (@InvoiceType,@InvoiceTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_InvoiceItemTypes (@InvoiceItemType VARCHAR(255),@InvoiceItemTypeID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE InvoiceItemTypes SET InvoiceItemType = @InvoiceItemType,
	StringID = @StringID
	WHERE InvoiceItemTypeID = @InvoiceItemTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO InvoiceItemTypes (InvoiceItemType,InvoiceItemTypeID,StringID)
VALUES (@InvoiceItemType,@InvoiceItemTypeID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_IEALocks (@IEALock VARCHAR(255),@IEALockID INT,@RefCount INT) AS
SET NOCOUNT ON
UPDATE IEALocks SET IEALock = @IEALock
	WHERE IEALockID = @IEALockID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IEALocks (IEALock,IEALockID,RefCount)
VALUES (@IEALock,@IEALockID,@RefCount)
END
GO

CREATE PROCEDURE dbo.CT2_ReportFields (@CRFieldName VARCHAR(255),@DataType SMALLINT,@DefaultValue VARCHAR(255),@Description VARCHAR(255),@EWSFile VARCHAR(255),@FieldName VARCHAR(255),@ReportField VARCHAR(255),@ReportFieldID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE ReportFields SET Description = @Description,
	CRFieldName = @CRFieldName,
	DataType = @DataType,
	DefaultValue = @DefaultValue,
	EWSFile = @EWSFile
	WHERE ReportFieldID = @ReportFieldID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportFields (CRFieldName,DataType,DefaultValue,Description,EWSFile,FieldName,ReportField,ReportFieldID,StringID)
VALUES (@CRFieldName,@DataType,@DefaultValue,@Description,@EWSFile,@FieldName,@ReportField,@ReportFieldID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_AccountTemplates (@AccountTemplate VARCHAR(255),@AccountTemplateID INT,@CustEdit VARCHAR(255),@CustEditLabel VARCHAR(255),@CustEditStringID INT,@CustNew VARCHAR(255),@CustSave VARCHAR(255),@LoginLabel VARCHAR(255),@LoginStringID INT,@SADetail VARCHAR(255),@SAEdit VARCHAR(255),@SANew VARCHAR(255),@SASave VARCHAR(255),@SignupForm VARCHAR(255),@SignupPage VARCHAR(255),@SignupSave VARCHAR(255),@SignupValidate VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE AccountTemplates SET AccountTemplate = @AccountTemplate,
	LoginLabel = @LoginLabel,
	LoginStringID = @LoginStringID,
	SANew = @SANew,
	SAEdit = @SAEdit,
	SASave = @SASave,
	SADetail = @SADetail,
	CustNew = @CustNew,
	CustEdit = @CustEdit,
	CustEditLabel = @CustEditLabel,
	CustEditStringID = @CustEditStringID,
	CustSave = @CustSave,
	SignupPage = @SignupPage,
	SignupForm = @SignupForm,
	SignupValidate = @SignupValidate,
	SignupSave = @SignupSave
	WHERE AccountTemplateID = @AccountTemplateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO AccountTemplates (AccountTemplate,AccountTemplateID,CustEdit,CustEditLabel,CustEditStringID,CustNew,CustSave,LoginLabel,LoginStringID,SADetail,SAEdit,SANew,SASave,SignupForm,SignupPage,SignupSave,SignupValidate,SortOrder)
VALUES (@AccountTemplate,@AccountTemplateID,@CustEdit,@CustEditLabel,@CustEditStringID,@CustNew,@CustSave,@LoginLabel,@LoginStringID,@SADetail,@SAEdit,@SANew,@SASave,@SignupForm,@SignupPage,@SignupSave,@SignupValidate,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_IncidentTemplates (@CustIncidentEdit VARCHAR(255),@CustIncidentSave VARCHAR(255),@IncidentEdit VARCHAR(255),@IncidentSave VARCHAR(255),@IncidentTemplate VARCHAR(255),@IncidentTemplateID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE IncidentTemplates SET IncidentTemplate = @IncidentTemplate,
	IncidentEdit = @IncidentEdit,
	IncidentSave = @IncidentSave,
	CustIncidentEdit = @CustIncidentEdit,
	CustIncidentSave = @CustIncidentSave
	WHERE IncidentTemplateID = @IncidentTemplateID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO IncidentTemplates (CustIncidentEdit,CustIncidentSave,IncidentEdit,IncidentSave,IncidentTemplate,IncidentTemplateID,SortOrder)
VALUES (@CustIncidentEdit,@CustIncidentSave,@IncidentEdit,@IncidentSave,@IncidentTemplate,@IncidentTemplateID,@SortOrder)
END
GO

