CREATE OR REPLACE PROCEDURE CT_IncidentStateGroups (IncidentStateGroup_ IN VARCHAR2,IncidentStateGroupID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT IncidentStateGroups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO IncidentStateGroups (IncidentStateGroup,IncidentStateGroupID)
VALUES (IncidentStateGroup_,IncidentStateGroupID_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateTimeGroups (RateTimeGroup_ IN VARCHAR2,RateTimeGroupID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT RateTimeGroups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO RateTimeGroups (RateTimeGroup,RateTimeGroupID)
VALUES (RateTimeGroup_,RateTimeGroupID_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateTimes (DayWeekMask_ IN INTEGER,Description_ IN VARCHAR2,EndHour_ IN SMALLINT,EndMinute_ IN SMALLINT,MonthDay_ IN SMALLINT,MonthMask_ IN INTEGER,Priority_ IN SMALLINT,RateTimeGroupID_ IN INTEGER,StartHour_ IN SMALLINT,StartMinute_ IN SMALLINT,WeekNumMask_ IN INTEGER) AS
BEGIN
INSERT INTO RateTimes (DayWeekMask,Description,EndHour,EndMinute,MonthDay,MonthMask,Priority,RateTimeGroupID,StartHour,StartMinute,WeekNumMask)
VALUES (DayWeekMask_,Description_ ,EndHour_ ,EndMinute_ ,MonthDay_ ,MonthMask_ ,Priority_ ,RateTimeGroupID_ ,StartHour_ ,StartMinute_ ,WeekNumMask_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_Roles (Role_ IN VARCHAR2) AS
BEGIN
INSERT INTO Roles (Role)
VALUES (Role_);
END;
/

CREATE OR REPLACE PROCEDURE CT_ReportGroups (Description_ IN VARCHAR2,OperatorGroupID_ IN INTEGER,ReportGroup_ IN VARCHAR2,ReportGroupID_ IN INTEGER,SortOrder_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT ReportGroups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO ReportGroups (Description,OperatorGroupID,ReportGroup,ReportGroupID,SortOrder)
VALUES (Description_,OperatorGroupID_ ,ReportGroup_ ,ReportGroupID_ ,SortOrder_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_Reports (FileName_ IN VARCHAR2,GroupID_ IN INTEGER,Report_ IN VARCHAR2,ReportGroupID_ IN INTEGER,ReportType_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE Reports SET GroupID =GroupID_,
	Report =Report_,
	ReportGroupID =ReportGroupID_,
	ReportType =ReportType_,
	SortOrder =SortOrder_
	WHERE FileName =FileName_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO Reports (FileName,GroupID,Report,ReportGroupID,ReportType,SortOrder)
VALUES (FileName_,GroupID_ ,Report_ ,ReportGroupID_ ,ReportType_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ReportFields (CRFieldName_ IN VARCHAR2,DataType_ IN SMALLINT,DefaultValue_ IN VARCHAR2,Description_ IN VARCHAR2,EWSFile_ IN VARCHAR2,FieldName_ IN VARCHAR2,ReportField_ IN VARCHAR2,ReportFieldID_ IN INTEGER,StringID_ IN INTEGER) AS
BEGIN
UPDATE ReportFields SET CRFieldName =CRFieldName_,
	DataType =DataType_,
	DefaultValue =DefaultValue_,
	Description =Description_,
	EWSFile =EWSFile_,
	FieldName =FieldName_,
	ReportField =ReportField_,
	StringID =StringID_
	WHERE ReportFieldID =ReportFieldID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ReportFields (CRFieldName,DataType,DefaultValue,Description,EWSFile,FieldName,ReportField,ReportFieldID,StringID)
VALUES (CRFieldName_,DataType_ ,DefaultValue_ ,Description_ ,EWSFile_ ,FieldName_ ,ReportField_ ,ReportFieldID_ ,StringID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_ReportParameters (FileName_ IN VARCHAR2,ReportFieldID_ IN INTEGER,Required_ IN SMALLINT,SortOrder_ IN SMALLINT) AS
BEGIN
UPDATE ReportParameters SET Required =Required_,
	SortOrder =SortOrder_
	WHERE FileName =FileName_
	AND ReportFieldID =ReportFieldID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ReportParameters (FileName,ReportFieldID,Required,SortOrder)
VALUES (FileName_,ReportFieldID_ ,Required_ ,SortOrder_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT2_PrintTypes (CRData_ IN VARCHAR2,Data_ IN VARCHAR2,PrintType_ IN VARCHAR2,PrintTypeID_ IN SMALLINT) AS
BEGIN
UPDATE PrintTypes SET CRData =CRData_,
	Data =Data_,
	PrintType =PrintType_
	WHERE PrintTypeID =PrintTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (CRData_,Data_ ,PrintType_ ,PrintTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT2_EmailTypes (EmailType_ IN VARCHAR2,EmailTypeID_ IN SMALLINT) AS
BEGIN
UPDATE EmailTypes SET EmailType =EmailType_
	WHERE EmailTypeID =EmailTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO EmailTypes (EmailType,EmailTypeID)
VALUES (EmailType_,EmailTypeID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_SendMethods (Description_ IN VARCHAR2,EmailAutoTrans_ IN SMALLINT,EmailTypeID_ IN SMALLINT,PrintAutoTrans_ IN SMALLINT,PrintTypeID_ IN SMALLINT,SendMethodID_ IN INTEGER,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT SendMethods_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO SendMethods (Description,EmailAutoTrans,EmailTypeID,PrintAutoTrans,PrintTypeID,SendMethodID,SortOrder,StringID)
VALUES (Description_,EmailAutoTrans_ ,EmailTypeID_ ,PrintAutoTrans_ ,PrintTypeID_ ,SendMethodID_ ,SortOrder_ ,StringID_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_TaxExemptions (Active_ IN SMALLINT,AllowItem_ IN SMALLINT,AllowMBR_ IN SMALLINT,Exemption_ IN VARCHAR2,StringID_ IN INTEGER,TaxExemptionID_ IN INTEGER) AS
BEGIN
INSERT INTO TaxExemptions (Active,AllowItem,AllowMBR,Exemption,StringID,TaxExemptionID)
VALUES (Active_,AllowItem_ ,AllowMBR_ ,Exemption_ ,StringID_ ,TaxExemptionID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_TaxPiggyBacks (TaxPiggyBack_ IN VARCHAR2) AS
BEGIN
INSERT INTO TaxPiggyBacks (TaxPiggyBack)
VALUES (TaxPiggyBack_);
END;
/

CREATE OR REPLACE PROCEDURE CT_Domains (Description_ IN VARCHAR2,Domain_ IN VARCHAR2,DomainID_ IN INTEGER,GroupID_ IN INTEGER,MailDomain_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT Domains_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO Domains (Description,Domain,DomainID,GroupID,MailDomain,SortOrder)
VALUES (Description_,Domain_ ,DomainID_ ,GroupID_ ,MailDomain_ ,SortOrder_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_Schedules (TaskName_ IN VARCHAR2,Parameter_ IN VARCHAR2,TargetSecs_ IN INTEGER,MaxSecs_ IN INTEGER,Status_ IN SMALLINT,Interval_ IN INTEGER,StartHH_ IN INTEGER,StartMI_ IN INTEGER,Aligned_ IN SMALLINT,Description_ IN VARCHAR2,Active_ IN SMALLINT,MaxConcurrent_ IN INTEGER,LastModifyUser_ IN VARCHAR2,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
StartDate_ DATE;
BEGIN
SELECT DATEADD(mi,StartMI_ ,DATEADD(hh,StartHH_ ,DATEADD(hh,-(DATEPART(hh,sysdate)),DATEADD(mi,-(DATEPART(mi,sysdate)),sysdate)))) INTO StartDate_ 

 FROM DUAL;
INSERT INTO Schedules (Active,Aligned,Description,Interval,LastModifyDate,LastModifyUser,LastStart,LastStatus,LastUpdate,LockServerID,MaxConcurrent,MaxSecs,Operator,Parameter,Server,StartDate,Status,TargetSecs,TaskName)
VALUES (Active_,Aligned_ ,Description_ ,Interval_ ,sysdate,LastModifyUser_ ,NULL,NULL,NULL,NULL,MaxConcurrent_ ,MaxSecs_ ,Operator_ ,Parameter_ ,NULL,StartDate_ ,Status_ ,TargetSecs_ ,TaskName_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RateStatusCalls AS
BEGIN
INSERT INTO RateStatusCalls(LastCallID,Leader,LastUpdate,LastMessage,Advisor,LastAdviceDate)
VALUES(0,NULL,sysdate,NULL,NULL,sysdate);
END;
