CREATE PROCEDURE dbo.CT_AllowedHosts (@Description VARCHAR(255),@IPAddress VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO AllowedHosts (Description,IPAddress)
VALUES (@Description,@IPAddress)
GO

CREATE PROCEDURE dbo.CT_CancelReasons (@CancelReason VARCHAR(255),@CustomerAccess SMALLINT,@Returning SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO CancelReasons (CancelReason,CustomerAccess,Returning,SortOrder,StringID)
VALUES (@CancelReason,@CustomerAccess,@Returning,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_BillingCycles (@AutoBill SMALLINT,@BillDay INT,@CycleType SMALLINT,@Description VARCHAR(255),@EBillDays INT,@Extension SMALLINT,@IBillDays INT,@RenewDays INT,@RenewPeriods INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO BillingCycles (AutoBill,BillDay,CycleType,Description,EBillDays,Extension,IBillDays,RenewDays,RenewPeriods,SortOrder,StringID)
VALUES (@AutoBill,@BillDay,@CycleType,@Description,@EBillDays,@Extension,@IBillDays,@RenewDays,@RenewPeriods,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_ChargeTypes (@Amount NUMERIC(18,4),@ChargeUses INT,@Description VARCHAR(255),@ServiceGroupID INT,@SortOrder SMALLINT,@StringID INT,@TaxExemptions INT) AS
SET NOCOUNT ON
INSERT INTO ChargeTypes (Amount,ChargeUses,Description,ServiceGroupID,SortOrder,StringID,TaxExemptions)
VALUES (@Amount,@ChargeUses,@Description,@ServiceGroupID,@SortOrder,@StringID,@TaxExemptions)
GO

CREATE PROCEDURE dbo.CT_Discounts (@Amount NUMERIC(18,4),@AmountType SMALLINT,@Discount VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO Discounts (Amount,AmountType,Discount,SortOrder,StringID)
VALUES (@Amount,@AmountType,@Discount,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_IncidentTypes (@CustomerAccess SMALLINT,@Description VARCHAR(255),@Email VARCHAR(255),@EscalateDays SMALLINT,@IncidentStateGroupID INT,@IncidentType VARCHAR(255),@OverDays SMALLINT,@ShowCustDueDate SMALLINT,@ShowCustomerAccess SMALLINT,@ShowDueDate SMALLINT,@ShowDuration SMALLINT,@ShowEmail SMALLINT,@ShowPriority SMALLINT,@ShowSummary SMALLINT,@SortOrder SMALLINT,@WarnDays SMALLINT) AS
SET NOCOUNT ON
INSERT INTO IncidentTypes (CustomerAccess,Description,Email,EscalateDays,IncidentStateGroupID,IncidentType,OverDays,ShowCustDueDate,ShowCustomerAccess,ShowDueDate,ShowDuration,ShowEmail,ShowPriority,ShowSummary,SortOrder,WarnDays)
VALUES (@CustomerAccess,@Description,@Email,@EscalateDays,@IncidentStateGroupID,@IncidentType,@OverDays,@ShowCustDueDate,@ShowCustomerAccess,@ShowDueDate,@ShowDuration,@ShowEmail,@ShowPriority,@ShowSummary,@SortOrder,@WarnDays)
GO

CREATE PROCEDURE dbo.CT_IncidentStates (@CustomerAccess SMALLINT,@Description VARCHAR(255),@IncidentState VARCHAR(255),@IncidentStateGroupID INT,@Priority SMALLINT,@SortOrder SMALLINT,@StatArchive SMALLINT,@StatBlock SMALLINT,@StatEscalate SMALLINT,@StatOpen SMALLINT,@StatWait SMALLINT,@Style VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO IncidentStates (CustomerAccess,Description,IncidentState,IncidentStateGroupID,Priority,SortOrder,StatArchive,StatBlock,StatEscalate,StatOpen,StatWait,Style)
VALUES (@CustomerAccess,@Description,@IncidentState,@IncidentStateGroupID,@Priority,@SortOrder,@StatArchive,@StatBlock,@StatEscalate,@StatOpen,@StatWait,@Style)
GO

CREATE PROCEDURE dbo.CT_OperatorGroups (@Description VARCHAR(255),@InternalUse SMALLINT,@OperatorGroup VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO OperatorGroups (Description,InternalUse,OperatorGroup)
VALUES (@Description,@InternalUse,@OperatorGroup)
GO

CREATE PROCEDURE dbo.CT_Operators AS
INSERT INTO Operators (PrintTypeID,OperatorGroupID,Operator,Password,Email,WebObjectAccess,CountryID)
SELECT 2, og.OperatorGroupID, 'admin','pass1',NULL,1,840
FROM OperatorGroups og
	WHERE OperatorGroup = 'Admin'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'admin')
UNION ALL
SELECT 2, og.OperatorGroupID, 'signup','signup',NULL,1,NULL
FROM OperatorGroups og
	WHERE OperatorGroup = 'CustomerSignup'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'signup')
GO

CREATE PROCEDURE dbo.CT_OperatorGroupAccess (@ObjectGroupID INT, @OperatorGroup VARCHAR(32), @AccessType INT) AS
SET NOCOUNT ON
DECLARE @OperatorGroupID INT
SELECT @OperatorGroupID = OperatorGroupID FROM OperatorGroups WHERE OperatorGroup = @OperatorGroup
IF (@OperatorGroupID IS NOT NULL)
BEGIN
UPDATE OperatorGroupAccess SET AccessType = @AccessType
	WHERE ObjectGroupID = @ObjectGroupID
	AND OperatorGroupID = @OperatorGroupID
	AND GroupID = 1
IF (@@ROWCOUNT = 0)
	BEGIN
	INSERT INTO OperatorGroupAccess (ObjectGroupID,OperatorGroupID,GroupID,AccessType)
	VALUES (@ObjectGroupID,@OperatorGroupID,1,@AccessType)
	END
END
GO

CREATE PROCEDURE dbo.CT_PayPeriods (@Amount NUMERIC(18,4),@AmountType SMALLINT,@ConfirmTrans SMALLINT,@PayPeriod VARCHAR(255),@Period SMALLINT,@PeriodTypeID INT,@SetupCharge SMALLINT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO PayPeriods (Amount,AmountType,ConfirmTrans,PayPeriod,Period,PeriodTypeID,SetupCharge,SortOrder,StringID)
VALUES (@Amount,@AmountType,@ConfirmTrans,@PayPeriod,@Period,@PeriodTypeID,@SetupCharge,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_AccountTypes (@AccountType VARCHAR(255),@ApplyDiscount SMALLINT,@ChangeClose SMALLINT,@ChangeFrom SMALLINT,@ChangeOpen SMALLINT,@ChangeTo SMALLINT,@Cost NUMERIC(18,4),@Description VARCHAR(255),@HomeDirSize INT,@LoginLimit SMALLINT,@OverDue SMALLINT,@RemoteAccess SMALLINT,@RequireUserPass INT,@SendBill SMALLINT,@SortOrder SMALLINT,@StringID INT,@TimeLeft INT) AS
SET NOCOUNT ON
INSERT INTO AccountTypes (AccountType,ApplyDiscount,ChangeClose,ChangeFrom,ChangeOpen,ChangeTo,Cost,Description,HomeDirSize,LoginLimit,OverDue,RemoteAccess,RequireUserPass,SendBill,SortOrder,StringID,TimeLeft)
VALUES (@AccountType,@ApplyDiscount,@ChangeClose,@ChangeFrom,@ChangeOpen,@ChangeTo,@Cost,@Description,@HomeDirSize,@LoginLimit,@OverDue,@RemoteAccess,@RequireUserPass,@SendBill,@SortOrder,@StringID,@TimeLeft)
GO

CREATE PROCEDURE dbo.CT_RadATConfigs AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SELECT @CTcnt = COUNT(*) FROM RadATConfigs
IF (@CTcnt = 0)
BEGIN
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,Data,Value,RadCheck)
SELECT AccountTypeID,6,0,' ',2,0 FROM AccountTypes
UNION ALL
SELECT AccountTypeID,7,0,' ',1,0 FROM AccountTypes
END
GO

CREATE PROCEDURE dbo.CT_RadFilterGroups (@Active SMALLINT,@Description VARCHAR(255),@DestData VARCHAR(255),@DestRadFilterGroupID INT,@RadDestTypeID INT,@RadFilterGroup VARCHAR(255),@RadFilterGroupID INT,@RadSourceTypeID INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT RadFilterGroups ON


INSERT INTO RadFilterGroups (Active,Description,DestData,DestRadFilterGroupID,RadDestTypeID,RadFilterGroup,RadFilterGroupID,RadSourceTypeID,SortOrder)
VALUES (@Active,@Description,@DestData,@DestRadFilterGroupID,@RadDestTypeID,@RadFilterGroup,@RadFilterGroupID,@RadSourceTypeID,@SortOrder)
SET IDENTITY_INSERT RadFilterGroups OFF
GO

CREATE PROCEDURE dbo.CT_RadFilters (@Data VARCHAR(255),@Location VARCHAR(255),@RadAttributeID INT,@RadFilterGroupID INT,@RadFilterTypeID INT,@RadMergeTypeID INT,@RadSearchTypeID INT,@RadVendorID INT) AS
SET NOCOUNT ON
INSERT INTO RadFilters (Data,Location,RadAttributeID,RadFilterGroupID,RadFilterTypeID,RadMergeTypeID,RadSearchTypeID,RadVendorID)
VALUES (@Data,@Location,@RadAttributeID,@RadFilterGroupID,@RadFilterTypeID,@RadMergeTypeID,@RadSearchTypeID,@RadVendorID)
GO

CREATE PROCEDURE dbo.CT_ReferredBys (@GroupID INT,@ReferredBy VARCHAR(255),@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
INSERT INTO ReferredBys (GroupID,ReferredBy,SortOrder,StringID)
VALUES (@GroupID,@ReferredBy,@SortOrder,@StringID)
GO

CREATE PROCEDURE dbo.CT_Regions (@Region VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO Regions (Region,SortOrder)
VALUES (@Region,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_SalesPersons (@Active SMALLINT,@SalesPerson VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
INSERT INTO SalesPersons (Active,SalesPerson,SortOrder)
VALUES (@Active,@SalesPerson,@SortOrder)
GO

CREATE PROCEDURE dbo.CT_ServerGroups (@ServerGroup VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO ServerGroups (ServerGroup)
VALUES (@ServerGroup)
GO

CREATE PROCEDURE dbo.CT_Servers AS
SET NOCOUNT ON
INSERT INTO Servers (ServerGroupID,Server,ServerType,IPAddress,Location,Secret) 
SELECT ServerGroupID,'localhost',-1,'127.0.0.1','local','localhost'
FROM ServerGroups
	WHERE ServerGroup = 'Other'
GO

CREATE PROCEDURE dbo.CT_AddressTypes (@AddressType VARCHAR(255),@RequiredFields VARCHAR(255),@ShowFields INT,@SortOrder INT) AS
SET NOCOUNT ON
INSERT INTO AddressTypes (AddressType,RequiredFields,ShowFields,SortOrder)
VALUES (@AddressType,@RequiredFields,@ShowFields,@SortOrder)
GO

CREATE PROCEDURE dbo.CT2_Groups (@Active SMALLINT,@AutoEmailInvoices SMALLINT,@AutoEmailStatements SMALLINT,@BillAddress1 VARCHAR(255),@BillAddress2 VARCHAR(255),@BillCity VARCHAR(255),@BillCountryID INT,@BillFax VARCHAR(255),@BillName VARCHAR(255),@BillPhone VARCHAR(255),@BillState VARCHAR(255),@BillZip VARCHAR(255),@BillingOption SMALLINT,@Description VARCHAR(255),@DomainID INT,@EmailAccounts VARCHAR(255),@EmailSubject VARCHAR(255),@EndDate DATETIME,@FTPDir VARCHAR(255),@GlobalAccountTypes SMALLINT,@GlobalBillingCycles SMALLINT,@GlobalChargeTypes SMALLINT,@GlobalDiscounts SMALLINT,@GlobalDomains SMALLINT,@GlobalIncidentTypes SMALLINT,@GlobalPackageTypes SMALLINT,@GlobalPayPeriods SMALLINT,@GlobalRegions SMALLINT,@GlobalSalesPersons SMALLINT,@GlobalSendMethods SMALLINT,@GroupID INT,@GroupName VARCHAR(255),@InvoiceHTMLReport VARCHAR(255),@InvoiceReport VARCHAR(255),@InvoiceTextReport VARCHAR(255),@MBRFields INT,@OrganizationID INT,@PaymentTypes INT,@SendCredits SMALLINT,@SortOrder SMALLINT,@StartDate DATETIME,@StatementHTMLReport VARCHAR(255),@StatementReport VARCHAR(255),@StatementTextReport VARCHAR(255),@ThemeID INT,@ThemeScore INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT

SELECT @CTcnt = COUNT(*) FROM Groups WHERE GroupID = @GroupID
IF (@CTcnt = 0)
BEGIN
SET IDENTITY_INSERT Groups ON


INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillZip,BillingOption,Description,DomainID,EmailAccounts,EmailSubject,EndDate,FTPDir,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDiscounts,GlobalDomains,GlobalIncidentTypes,GlobalPackageTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,MBRFields,OrganizationID,PaymentTypes,SendCredits,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (@Active,@AutoEmailInvoices,@AutoEmailStatements,@BillAddress1,@BillAddress2,@BillCity,@BillCountryID,@BillFax,@BillName,@BillPhone,@BillState,@BillZip,@BillingOption,@Description,@DomainID,@EmailAccounts,@EmailSubject,@EndDate,@FTPDir,@GlobalAccountTypes,@GlobalBillingCycles,@GlobalChargeTypes,@GlobalDiscounts,@GlobalDomains,@GlobalIncidentTypes,@GlobalPackageTypes,@GlobalPayPeriods,@GlobalRegions,@GlobalSalesPersons,@GlobalSendMethods,@GroupID,@GroupName,@InvoiceHTMLReport,@InvoiceReport,@InvoiceTextReport,@MBRFields,@OrganizationID,@PaymentTypes,@SendCredits,@SortOrder,@StartDate,@StatementHTMLReport,@StatementReport,@StatementTextReport,@ThemeID,@ThemeScore)
SET IDENTITY_INSERT Groups OFF
END
GO

