SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT INTO Calls (AcctSessionID, NASIdentifier, AcctStatusType, NASPort, CallDate, Username, AcctDelayTime, AcctSessionTime, FramedAddress, AcctInputOctets, AcctOutputOctets, AcctTerminateCause, NASPortType, NASPortDNIS, CallerID, ConnectInfo, ServerID, AccountID)
SELECT AcctSessionID, NASIdentifier, AcctStatusType, COALESCE(NASPort,'-1') AS NASPort, CallDate, Username, AcctDelayTime, AcctSessionTime, FramedAddress, AcctInputOctets, AcctOutputOctets, AcctTerminateCause, NASPortType, NASPortDNIS, CallerID, ConnectInfo, CASE WHEN c.ServerID IN (SELECT ServerID FROM Servers) THEN c.ServerID ELSE NULL END, AccountID
FROM Emerald..Calls c
	WHERE CallDate BETWEEN DATEADD(dd,-($day),$getdate) AND DATEADD(mi,-1,DATEADD(dd,-($day-1),$getdate))
	AND AcctStatusType IN ($CallType)

IF ((SELECT LastCallID FROM RateStatusCalls) = 0 AND EXISTS (SELECT * FROM Emerald..RateTables WHERE RateTableID=1 AND LastProcDate <= DATEADD(mi,-1,DATEADD(dd,-($day-1),$getdate))))
BEGIN
UPDATE RateStatusCalls SET LastCallID = (SELECT MAX(CallID) FROM Calls WHERE CallDate < (SELECT LastProcDate FROM Emerald..RateTables WHERE RateTableID=1))
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

