CREATE OR REPLACE TRIGGER calls_insert
AFTER INSERT ON Calls
FOR EACH ROW
BEGIN

-- IP Pooling
IF :new.AcctStatusType IN (1,2,3) THEN
UPDATE RadIPAddresses SET LastCallDate = :new.CallDate, State = CASE WHEN :new.AcctStatusType IN (1,3) THEN 2 WHEN :new.AcctStatusType = 2 THEN 0 ELSE State END
	WHERE NASPort = :new.NASPort
	AND NASIdentifier = :new.NASIdentifier
	AND LastCallDate <= :new.CallDate;
END IF;

-- Group Concurrency
IF :new.AcctStatusType IN (1,2) THEN
MERGE INTO RadConcurrency mrc
USING (SELECT Connections + CASE WHEN :new.AcctStatusType = 1 THEN 1 WHEN :new.AcctStatusType = 2 THEN -1 ELSE 0 END AS Connections, rc.GroupID, rc.AccountTypeID
FROM MasterAccounts ma, SubAccounts sa, RadConcurrency rc
	WHERE sa.AccountID = :new.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR rc.AccountTypeID = sa.AccountTypeID)) rc
ON (mrc.GroupID = rc.GroupID AND ((mrc.AccountTypeID IS NULL AND rc.AccountTypeID IS NULL) OR (mrc.AccountTypeID = rc.AccountTypeID)))
WHEN MATCHED THEN UPDATE SET mrc.Connections = rc.Connections;
END IF;

-- Update Online List
UPDATE ServerPorts
	SET Username = :new.Username, 
	AccountID = :new.AccountID,
	AcctSessionTime = :new.AcctSessionTime,
	AcctInputOctets = :new.AcctInputOctets,
	AcctOutputOctets = :new.AcctOutputOctets,
	AcctStatusType = CASE WHEN :new.AcctStatusType IN (1,3) THEN 1 ELSE 2 END,
	CallDate = :new.CallDate,
	FramedAddress = :new.FramedAddress,
	CallerID = :new.CallerID,
	NASPortDNIS = :new.NASPortDNIS,
	ConnectInfo = :new.ConnectInfo,
	AcctSessionID = :new.AcctSessionID
	WHERE NASIdentifier = :new.NASIdentifier
	AND Port = :new.NASPort
	AND CallDate <= :new.CallDate;

IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO ServerPorts (AcctSessionTime,ServerID,Port,NASIdentifier,Username,AccountID,AcctSessionID,AcctStatusType,CallDate,FramedAddress,CallerID,NASPortDNIS,ConnectInfo)
SELECT :new.AcctSessionTime,:new.ServerID,:new.NASPort,:new.NASIdentifier,:new.Username,:new.AccountID,:new.AcctSessionID,CASE WHEN :new.AcctStatusType IN (1,3) THEN 1 ELSE 2 END,
:new.CallDate,:new.FramedAddress,:new.CallerID,:new.NASPortDNIS,:new.ConnectInfo
FROM DUAL
	WHERE NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.NASIdentifier = :new.NASIdentifier AND sp.Port = :new.NASPort);
END IF;

-- Update Time Left
IF (:new.AcctStatusType = 2 AND :new.AccountID IS NOT NULL) THEN
UPDATE SubAccounts SET TimeLeft = TimeLeft - (:new.AcctSessionTime/60 + 1), DataLeft = DataLeft - (COALESCE(:new.AcctOutputOctets,0) + COALESCE(:new.AcctInputOctets,0))
WHERE AccountID = :new.AccountID;
END IF;

END;
/

CREATE OR REPLACE TRIGGER Calls_itrig
BEFORE INSERT ON Calls
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CallID IS NULL THEN

IF :new.AccountID IS NULL THEN
SELECT MAX(sa.AccountID) INTO :new.AccountID
FROM MasterAccounts ma, SubAccounts sa
	WHERE ma.CustomerID = sa.CustomerID
	AND :new.Username = sa.Login
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0);
END IF;

IF :new.AccountID IS NULL THEN
SELECT MAX(sa.AccountID) INTO :new.AccountID
FROM MasterAccounts ma, SubAccounts sa
	WHERE ma.CustomerID = sa.CustomerID
	AND :new.Username = sa.Email
	AND sa.Email <> ' '
	AND sa.Email IS NOT NULL
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0);
END IF;

SELECT Calls_seq.nextval INTO seq_val FROM DUAL;
:new.CallID := seq_val;
Last.ID := seq_val;

END IF;
END;
/
