CREATE PROCEDURE dbo.ACHExport (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NULL)
BEGIN
SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber, et.AuthName AS AccountHolder, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
COALESCE(et.AuthAddress,ma.Address1) AS Address, ma.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State, COALESCE(et.AuthZip,ma.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC, CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC, et.BankNumber, et.BankName, ma.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS CountryCode,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et, MasterAccounts ma, Groups g, BatchProcessors bp, Organizations o, Currencies c
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND o.CurrencyID = c.CurrencyID
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.BatchProcessorID = @BatchProcessorID

END ELSE BEGIN

SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber,
et.AuthName AS AccountHolder, SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) AS FirstName, SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,100) AS LastName,
COALESCE(et.AuthAddress,ma.Address1) AS Address, ma.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State, COALESCE(et.AuthZip,ma.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC, CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC, et.BankNumber, et.BankName, ma.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS CountryCode,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et, MasterAccounts ma, Groups g, BatchProcessors bp, Organizations o, Currencies c
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND o.CurrencyID = c.CurrencyID
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND bp.BatchProcessorID = @BatchProcessorID
END
GO

CREATE PROCEDURE dbo.RBCExport (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @BatchID INT

CREATE TABLE #rbse (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5))
CREATE TABLE #rbsed (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5), RecordCount INT IDENTITY, ItemCount INT, ItemTotal NUMERIC(18,4))
CREATE TABLE #rbsec (Merchant VARCHAR(64), Store VARCHAR(64), CurrencyCode VARCHAR(5), Login VARCHAR(64), ExternalTransID INT, TransTypeID INT, BankNumber VARCHAR(128), AccountNumber VARCHAR(128), Amount NUMERIC(18,4), ReqDate DATETIME, AuthName VARCHAR(64), Country3 VARCHAR(5), RecordCount INT IDENTITY, ItemCount INT, ItemTotal NUMERIC(18,4))

IF (@CustomerID IS NULL)
BEGIN
INSERT INTO #rbse (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT bp.Merchant, 
bp.Store,
c.Code AS CurrencyCode,
bp.Login,
et.ExternalTransID, 
et.TransTypeID,
et.BankNumber, 
et.AccountNumber,
et.Amount,
et.ReqDate,
et.AuthName,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country3

FROM ExternalTrans et, MasterAccounts ma, Groups g, BatchProcessors bp, Organizations o, Currencies c
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND o.CurrencyID = c.CurrencyID
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.BatchProcessorID = @BatchProcessorID

IF ((SELECT COUNT(*) FROM #rbse) > 0)
BEGIN
INSERT INTO Batches (BatchTypeID,BatchStateID,GroupID,Operator,StartDate,EndDate,LastModifyDate,LastModifyUser,ItemCount,ItemTotal)
SELECT 6 AS BatchTypeID,3 AS BatchStateID, NULL AS GroupID,'batch' AS Operator,getdate() AS StartDate, getdate() AS EndDate, getdate() AS LastModifyDate, 'batch' AS LastModifyUser, COUNT(*) AS ItemCount, SUM(Amount) AS ItemTotal
FROM #rbse
SELECT @BatchID = @@IDENTITY

IF ((SELECT COUNT(*) FROM #rbse WHERE TransTypeID = 64) > 0)
BEGIN
-- Header
INSERT INTO #rbsed (TransTypeID,Merchant,Store,CurrencyCode)
SELECT 16384,MIN(Merchant),MIN(Store),MIN(CurrencyCode) FROM #rbse WHERE TransTypeID = 64

-- Debit
INSERT INTO #rbsed (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3
FROM #rbse WHERE TransTypeID = 64

-- Footer
INSERT INTO #rbsed (TransTypeID,Merchant,ItemCount,ItemTotal)
SELECT 32768,MIN(Merchant),COUNT(*),SUM(Amount) FROM #rbse WHERE TransTypeID = 64

SELECT 'D' AS GroupName, '$$AAPASTD0152[PROD[NL$$' AS FileFormat, @BatchID % 9999 AS GroupID,RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,ItemCount,ItemTotal,
DATEPART(yyyy,getdate()) AS nowyyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(dd,-DATEPART(dd,getdate())+1,getdate())),getdate()) AS nowddd,
DATEPART(yyyy,DATEADD(dd,2,getdate())) AS now2yyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,DATEADD(dd,2,getdate()))+1,DATEADD(dd,-DATEPART(dd,DATEADD(dd,2,getdate()))+1,DATEADD(dd,2,getdate()))),DATEADD(dd,2,getdate())) AS now2ddd
FROM #rbsed
ORDER BY RecordCount
END

IF ((SELECT COUNT(*) FROM #rbse WHERE TransTypeID = 256) > 0)
BEGIN
-- Header
INSERT INTO #rbsec (TransTypeID,Merchant,Store,CurrencyCode)
SELECT 16384,MIN(Merchant),MIN(Store),MIN(CurrencyCode) FROM #rbse WHERE TransTypeID = 256

-- Credit
INSERT INTO #rbsec (Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3)
SELECT Merchant,Store,CurrencyCode,Login,ExternalTransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3
FROM #rbse WHERE TransTypeID = 256

-- Footer
INSERT INTO #rbsec (TransTypeID,Merchant,ItemCount,ItemTotal)
SELECT 32768,MIN(Merchant),COUNT(*),SUM(Amount) FROM #rbse WHERE TransTypeID = 256

SELECT 'C' AS GroupName, '$$AAPDSTD0152[PROD[NL$$' AS FileFormat, @BatchID % 9999 AS GroupID,RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,ItemCount,ItemTotal,
DATEPART(yyyy,getdate()) AS nowyyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,getdate())+1,DATEADD(dd,-DATEPART(dd,getdate())+1,getdate())),getdate()) AS nowddd,
DATEPART(yyyy,DATEADD(dd,2,getdate())) AS now2yyyy, DATEDIFF(dd,DATEADD(mm,-DATEPART(mm,DATEADD(dd,2,getdate()))+1,DATEADD(dd,-DATEPART(dd,DATEADD(dd,2,getdate()))+1,DATEADD(dd,2,getdate()))),DATEADD(dd,2,getdate())) AS now2ddd
FROM #rbsec
ORDER BY RecordCount
END

UPDATE ExternalTrans SET BatchOutID = @BatchID WHERE ExternalTransID IN (SELECT ExternalTransID FROM #rbse)
END ELSE BEGIN
SELECT NULL AS GroupName, NULL AS FileFormat, NULL AS GroupID,NULL AS RecordCount,Merchant,Store,CurrencyCode,Login,ExternalTransID,ExternalTransID AS TransID,TransTypeID,BankNumber,AccountNumber,Amount,ReqDate,AuthName,Country3,NULL AS ItemCount,NULL AS ItemTotal,
NULL AS nowyyyy,NULL AS nowddd, NULL AS now2yyyy, NULL AS now2ddd
FROM #rbse
END
END 

DROP TABLE #rbse
DROP TABLE #rbsed
DROP TABLE #rbsec
GO

CREATE PROCEDURE dbo.AddrSearchZip (@CountryID INT, @Zip VARCHAR(20)) AS
SET NOCOUNT ON
DECLARE @City VARCHAR(64), @StateID INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT @City = MIN(lzc.City), @StateID = MIN(lzc.StateID)
FROM LocZipCodes lzc, States s
	WHERE lzc.StateID = s.StateID
	AND s.CountryID = @CountryID 
	AND lzc.ZipCode = @Zip

IF (@StateID IS NULL)
BEGIN
SELECT City, StateID, COUNT(*) AS Cnt
FROM MasterAccounts
	WHERE CountryID = @CountryID
	AND Zip = @Zip
GROUP BY City, StateID
HAVING COUNT(*) > 2
ORDER BY 3 DESC
END ELSE BEGIN
SELECT @City AS City, @StateID AS StateID
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.Aging (@update INT, @operatorgroupid INT) AS
SET NOCOUNT ON
CREATE TABLE #tempaging (CustomerID INT, Age0 NUMERIC(18,4), Age30 NUMERIC(18,4), Age60 NUMERIC(18,4), Age90 NUMERIC(18,4), Age120 NUMERIC(18,4), PendingCharge NUMERIC(18,4), PendingPOS NUMERIC(18,4))

INSERT INTO #tempaging (CustomerID,Age0,Age30,Age60,Age90,Age120,PendingCharge,PendingPOS)
SELECT ma.CustomerID,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,getdate()) AND getdate() THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age0,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,getdate()) AND DATEADD(dd,-30,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age30,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,getdate()) AND DATEADD(dd,-60,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age60,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,getdate()) AND DATEADD(dd,-90,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age90,
SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,getdate())THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age120,
COALESCE((SELECT SUM(c.Amount) From Charges c WHERE c.CustomerID = ma.CustomerID AND c.ItemID IS NULL),0) AS PendingCharge,
COALESCE((SELECT SUM(i2.Amount) From Invoices i2 WHERE i2.CustomerID = ma.CustomerID AND i2.InvoiceTypeID = 91 AND i2.StatementID IS NULL),0) AS PendingPOS
FROM Invoices i, MasterAccounts ma, InvoiceItems ii
	WHERE ma.CustomerID = i.CustomerID
	AND i.VoidDate IS NULL
	AND i.InvoiceID = ii.InvoiceID
	AND ii.Amount > 0
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ma.Active = 1
	AND i.StatementID IS NOT NULL
GROUP BY ma.CustomerID
IF (@update <> 1)
BEGIN
SELECT ma.CustomerID, CASE WHEN ((ma.PendingBalance < 0) OR (a.Age30 = 0 AND a.Age60 = 0 AND a.Age90 = 0 AND a.Age120 = 0)) THEN ma.PendingBalance ELSE a.Age0 + a.PendingCharge END AS Age0, a.Age30, a.Age60, a.Age90, a.Age120, ma.FirstName, ma.LastName, ma.Company, ma.PhoneWork, ma.PhoneHome, ma.Active, ma.GroupID
FROM MasterAccounts ma, #tempaging a
	WHERE ma.CustomerID = a.CustomerID
	AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
	AND (@operatorgroupid = 1 OR EXISTS (SELECT * FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @operatorgroupid AND (GroupID = ma.GroupID OR GroupID = 1)))
ORDER BY 6 DESC, 5 DESC, 4 DESC, 3 DESC, 2 DESC
END
DROP TABLE #tempaging
SET NOCOUNT OFF
GO

CREATE PROCEDURE dbo.BatchProcessorGet (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@CustomerID IS NULL)
BEGIN
SELECT bp.BatchProcessorID, bp.ExportID, bp.BatchProcessor, bp.BatchIn, bp.BatchOut, bp.BatchLimit, bp.ImportOptions, bp.ExportOptions, bp.ProcessorURL, bp.Login, bp.Password, 1 AS Armed
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE (@BatchProcessorID IS NULL OR BatchProcessorID = @BatchProcessorID)
END ELSE BEGIN
SELECT bp.BatchProcessorID, bp.ExportID, bp.BatchProcessor, bp.BatchIn, bp.BatchOut, bp.BatchLimit, bp.ImportOptions, bp.ExportOptions, bp.ProcessorURL, bp.Login, bp.Password, 1 AS Armed
FROM BatchProcessors bp JOIN Exports e ON (bp.ExportID = e.ExportID)
	WHERE (@BatchProcessorID IS NULL OR BatchProcessorID = @BatchProcessorID)
	AND e.ExportType IN (5,6,7)
	AND bp.BatchProcessorID IN (SELECT BatchProcessorID FROM ExternalTrans WHERE CustomerID = @CustomerID AND TransStateID IN (0,1,2,3))
END
GO

CREATE PROCEDURE dbo.BatchGetTrans (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@CustomerID IS NULL)
BEGIN
SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE TransStateID IN (0,1,2)
END ELSE BEGIN
SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE CustomerID = @CustomerID
	AND TransStateID IN (0,1,2)
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.BatchStatements (@custid INT, @GroupID INT, @operatorgroupid INT) AS
SET NOCOUNT ON
DECLARE @newinterval INT, @tmpcnt INT, @newpayments INT
SELECT @newinterval = MAX(NumValue) FROM Configs WHERE ConfigID = 505
SELECT @newinterval = COALESCE(@newinterval,0)
SELECT @newpayments = MAX(NumValue) FROM Configs WHERE ConfigID = 377

CREATE TABLE #tma (CustomerID INT)
CREATE TABLE #ti (CustomerID INT, NewCharge NUMERIC(18,4), NewCredit NUMERIC(18,4), LastInvoiceID INT, InvoiceCount INT)
CREATE TABLE #tp (CustomerID INT, Amount NUMERIC(18,4), LastPaymentID INT, PayCount INT)

IF @custid IS NULL
BEGIN

IF (@GroupID IS NULL)
BEGIN
	INSERT INTO #tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
		WHERE i.StatementID IS NULL
		AND i.VoidDate IS NULL
		AND i.Processed = 1
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.Active = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.Active = 1
		AND @newpayments = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.Active = 1
		AND @newpayments = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1

END ELSE BEGIN

	INSERT INTO #tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
		WHERE i.StatementID IS NULL
		AND i.VoidDate IS NULL
		AND i.Processed = 1
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
		AND @newpayments = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
		AND @newpayments = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DATEADD(mm,-1,getdate()))
		AND ma.Active = 1
		AND ma.GroupID = @GroupID
END

	DELETE FROM #tma WHERE CustomerID IN (SELECT et.CustomerID FROM ExternalTrans et, #tma t WHERE et.CustomerID = t.CustomerID AND et.TransStateID IN (0,2))

	DELETE FROM #tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
		WHERE bc.AutoBill IN (0,1)
		AND sa.Active = 1
		AND (p.Active IS NULL OR p.Active = 1)
		AND (COALESCE(p.CancelDate,sa.CancelDate) IS NULL OR (COALESCE(p.CancelDate,sa.CancelDate) > GetDate() AND COALESCE(p.CancelDate,sa.CancelDate) > sa.BilledThru))
		AND NOT EXISTS (SELECT * FROM Invoices i WHERE i.Processed = 1 AND i.CustomerID = t.CustomerID AND i.Amount <> 0 AND i.StatementID IS NULL AND i.InvoiceTypeID IN (1,2,3,4,5,50))
		AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 15, getdate())
		AND sa.BilledThru > DATEADD(dd,-15,getdate())
		AND (ma.CancelDate IS NULL OR (ma.CancelDate > GetDate() AND ma.CancelDate > sa.BilledThru)))

	DELETE FROM #tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
		WHERE bc.AutoBill IN (0,1)
		AND sa.Active = 1
		AND (p.Active IS NULL OR p.Active = 1)
		AND (COALESCE(p.CancelDate,sa.CancelDate) IS NULL OR (COALESCE(p.CancelDate,sa.CancelDate) > GetDate() AND COALESCE(p.CancelDate,sa.CancelDate) > sa.BilledThru))
		AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 2, getdate())
		AND EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(dd,-33,getdate()))
		AND (ma.CancelDate IS NULL OR (ma.CancelDate > GetDate() AND ma.CancelDate > sa.BilledThru)))

	DELETE FROM #tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM #tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN Statements s ON (ma.LastStatementID = s.StatementID)
		LEFT JOIN ConfigGroupData cg ON (ma.GroupID = cg.GroupID AND cg.ConfigID = 505)
		WHERE s.StatementDate > DATEADD(dd,-(COALESCE(cg.NumValue,@newinterval)),getdate()))

	IF (@operatorgroupid IS NOT NULL)
		BEGIN
		SELECT @tmpcnt = COUNT(*) FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @operatorgroupid AND GroupID = 1

		IF (@tmpcnt = 0)
			BEGIN
			DELETE FROM #tma WHERE CustomerID IN (SELECT ma.CustomerID
			FROM #tma t, MasterAccounts ma
				WHERE t.CustomerID = ma.CustomerID
				AND ma.GroupID NOT IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @operatorgroupid))
			END
		END

	INSERT INTO #ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
	SELECT i.CustomerID, MAX(i.InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
	SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount > 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) > 0 THEN -(i.Amount) ELSE 0 END END) AS NewCharge,
	SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount < 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) < 0 THEN -(i.Amount) ELSE 0 END END) AS NewCredit
	FROM #tma t, Invoices i
		WHERE t.CustomerID = i.CustomerID
		AND i.Processed = 1
		AND (i.StatementID IS NULL OR (i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL))
	GROUP BY i.CustomerID

	INSERT INTO #tp (CustomerID,LastPaymentID,PayCount,Amount)
	SELECT p.CustomerID, MAX(p.PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
	SUM(CASE WHEN p.StatementID IS NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount WHEN p.StatementID IS NULL THEN p.Amount WHEN p.StatementID IS NOT NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount-p.Amount END) AS Amount
	FROM #tma t, Payments p
	WHERE t.CustomerID = p.CustomerID
		AND (p.StatementID IS NULL OR (p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL))
		AND p.PaymentTypeID <> 0
	GROUP BY p.CustomerID
END ELSE BEGIN
INSERT INTO #tma (CustomerID) VALUES(@custid)

DELETE FROM #tma WHERE CustomerID IN (SELECT et.CustomerID
FROM ExternalTrans et, #tma t
	WHERE et.CustomerID = t.CustomerID
	AND et.TransStateID IN (0,2))

INSERT INTO #ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
SELECT i.CustomerID, MAX(i.InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount > 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) > 0 THEN -(i.Amount) ELSE 0 END END) AS NewCharge,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount < 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) < 0 THEN -(i.Amount) ELSE 0 END END) AS NewCredit
FROM Invoices i
	WHERE i.CustomerID = @custid
	AND (i.StatementID IS NULL OR (i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL))
	AND i.Processed = 1
GROUP BY i.CustomerID

INSERT INTO #tp (CustomerID,LastPaymentID,PayCount,Amount)
SELECT p.CustomerID, MAX(p.PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
SUM(CASE WHEN p.StatementID IS NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount WHEN p.StatementID IS NULL THEN p.Amount WHEN p.StatementID IS NOT NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount-p.Amount END) AS Amount
FROM Payments p
	WHERE p.CustomerID = @custid
	AND (p.StatementID IS NULL OR (p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL))
GROUP BY p.CustomerID
END

IF (@GroupID IS NULL)
BEGIN
SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, ma.FirstName, ma.LastName, ma.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.SentDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge
FROM MasterAccounts ma JOIN #tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN #ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN #tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
END ELSE BEGIN
SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, ma.FirstName, ma.LastName, ma.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.SentDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge
FROM MasterAccounts ma JOIN #tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN #ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN #tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
	AND ma.GroupID = @GroupID
END

DROP TABLE #tma
DROP TABLE #ti
DROP TABLE #tp
GO

CREATE PROCEDURE dbo.BillingGroupSummary (@MBRGlobal INT, @OperatorGroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #bgstmp (GroupID INT, ActiveCount INT, InactiveCount INT, TransCount INT)

INSERT INTO #bgstmp (GroupID,ActiveCount,InactiveCount,TransCount)
SELECT g.GroupID, SUM(CASE WHEN ma.Active = 1 THEN 1 ELSE 0 END) AS ActiveCount, SUM(CASE WHEN ma.Active = 0 THEN 1 ELSE 0 END) AS InactiveCount, (SELECT COUNT(*) FROM ExternalTrans et, MasterAccounts ma2 WHERE ma2.CustomerID=et.CustomerID AND ma2.Active = 1 AND ma2.GroupID = g.GroupID AND et.TransStateID IN (0,2)) AS TransCount
FROM Groups g, MasterAccounts ma
	WHERE ma.GroupID = g.GroupID
	AND ma.Active >= 0
	AND (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))
GROUP BY g.GroupID

SELECT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, SUM(ActiveCount) AS ActiveCount, SUM(InactiveCount) AS InactiveCount, SUM(TransCount) AS TransCount
FROM #bgstmp
UNION ALL
SELECT t.GroupID, o.Organization, g.GroupName, t.ActiveCount, t.InactiveCount, t.TransCount
FROM #bgstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID

DROP TABLE #bgstmp

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.BulkEmail (@GroupID INT, @AccountTypeID INT, @RegionID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@AccountTypeID IS NULL)
BEGIN
SELECT ma.FirstName, ma.LastName, ma.CustomerID, ma.Company
FROM MasterAccounts ma, Groups g
	WHERE ma.GroupID = g.GroupID
	AND ma.Active = 1
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
END ELSE BEGIN
SELECT COALESCE(sa.FirstName,ma.FirstName) AS FirstName, COALESCE(sa.LastName,ma.LastName) AS LastName, ma.CustomerID, ma.Company
FROM MasterAccounts ma, Groups g, SubAccounts sa
	WHERE ma.GroupID = g.GroupID
	AND ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND sa.AccountTypeID = @AccountTypeID
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CallSummary (@startdate DATETIME, @enddate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @istartdate DATETIME, @ienddate DATETIME
IF @startdate IS NULL
BEGIN
	SELECT @istartdate = DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),DATEADD(dd,-DATEPART(dd,getdate())+1,getdate()))
END
IF @enddate IS NULL
BEGIN
	SELECT @ienddate = getdate()
END
SELECT sa.AccountID, MIN(sa.CustomerID) AS CustomerID, MIN(sa.FirstName) AS FirstName, MIN(sa.LastName) AS LastName, MIN(sa.Login) AS Login, COUNT(*) AS Calls, SUM(c.AcctSessionTime)/60 AS Mins, SUM(c.AcctInputOctets) AS InBytes, SUM(c.AcctOutputOctets) AS OutBytes, MIN(c.CallDate) AS StartDate, MAX(c.CallDate) AS EndDate
FROM Calls c, MasterAccounts ma, SubAccounts sa
	WHERE c.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND c.CallDate BETWEEN @istartdate AND @ienddate
	AND c.AcctStatusType = 2
GROUP BY sa.AccountID
ORDER BY 6
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CanceledAccounts AS
SET NOCOUNT ON

DECLARE @yn INT, @autovoid INT
SELECT @yn = MAX(NumValue) FROM Configs WHERE ConfigID=34
SELECT @autovoid = MAX(NumValue) FROM Configs WHERE ConfigID=651

CREATE TABLE #canaaxe (CustomerID INT)

INSERT INTO #canaaxe (CustomerID)
SELECT ma.CustomerID
FROM MasterAccounts ma LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 34)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	WHERE ma.Active = 1
	AND ( (ma.PendingBalance = 0 AND ma.Balance = 0) OR (cgd.NumValue = 1) OR (cgd.NumValue IS NULL AND @yn = 1) )
	AND ma.CancelDate < getdate()
	AND (cr.CancelReasonID IS NULL OR cr.Returning = 0)

UPDATE MasterAccounts SET Active = 0 WHERE CustomerID IN (SELECT CustomerID FROM #canaaxe)

INSERT INTO AuditLogs(LogDate, LogMsgID, LogMsg, Operator, CustomerID, AccountID)
SELECT getdate(), 111, 'CID:' + CAST(ma.CustomerID AS VARCHAR(10)) + ' - Balance:' + CAST(ma.PendingBalance AS VARCHAR(15)), 'Scheduler', ma.CustomerID, NULL
FROM MasterAccounts ma, #canaaxe a
	WHERE ma.CustomerID = a.CustomerID

UPDATE ExternalTrans SET TransStateID = 9 WHERE ExternalTransID IN 
(SELECT et.ExternalTransID
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 651)
	WHERE ma.PendingBalance <= 0
	AND ma.Active = 1
	AND et.TransStateID = 3
	AND et.TransTypeID IN (16,64)
	AND et.ReqDate < DATEADD(hh,-3,getdate())
	AND (cgd.NumValue = 1 OR (cgd.NumValue IS NULL AND @autovoid = 1)))

DROP TABLE #canaaxe

UPDATE SubAccounts SET Active = 0
	WHERE AccountID IN (SELECT sa.AccountID FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
		WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND at1.InactCanceledDays > 0
		AND ma.Active = 1
		AND sa.Active = 1
		AND sa.CancelDate < DATEADD(dd,-(at1.InactCanceledDays),getdate()))
GO

CREATE PROCEDURE dbo.ChangeMailUserPassword (@login varchar(64), @domain varchar(64), @password varchar(16), @esid integer) AS
UPDATE SubAccounts SET Password = @password
	WHERE AccountID IN (SELECT sa.AccountID	
	From SubAccounts sa, Domains d, AccountTypes at1, ExternalSystemAccountTypes esat
	WHERE sa.DomainID = d.DomainID
	 AND at1.AccountTypeID = esat.AccountTypeID
	 AND esat.ExternalSystemID = @esid
	 AND (
		(sa.Login = @login AND d.MailDomain = @domain)
		OR
		(sa.Email = @login + '@' + @domain)
	     ))
GO

CREATE PROCEDURE dbo.ChargeRateAdd (@CustomerID INT, @AccountID INT, @ChargeTypeID INT, @TaxGroupID INT, @TaxExemptions INT, @StartDate DATETIME, @Amount NUMERIC(18,4), @Description VARCHAR(64), @Login VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,Login,DistFlag,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,LastModifyDate,LastModifyUser)
VALUES(@CustomerID,@Description,
CASE WHEN DATEADD(mm,1,@StartDate) > getdate() THEN getdate() ELSE @StartDate END,
CASE WHEN DATEADD(mm,1,@StartDate) > getdate() THEN getdate() ELSE DATEADD(dd,-1,DATEADD(mm,1,@StartDate)) END,@AccountID,@Login,1,1,@Amount,1,@TaxGroupID,@TaxExemptions,@ChargeTypeID,getdate(),'Emerald Auto Bill')

SELECT @@IDENTITY AS ChargeID
GO

CREATE PROCEDURE dbo.ChargeSetupAdd (@AccountID INT, @PackageID INT, @StartDate DATETIME, @Operator VARCHAR(64)) AS
SET NOCOUNT ON

IF (@AccountID IS NOT NULL)
BEGIN
INSERT INTO Charges (CustomerID, StartDate, EndDate, AccountID, Login, AccountTypeID, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser,Operator, AllowInterim)
SELECT DISTINCT sa.CustomerID, @StartDate, @StartDate, sa.AccountID, COALESCE(sa.Login,sa.Email), sa.AccountTypeID,  ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate(), @Operator, @Operator, 0
FROM SubAccounts sa, AccountTypes at1, ChargeTypes ct
	WHERE sa.AccountTypeID = at1.AccountTypeID
	AND (at1.ChargeTypeID = ct.ChargeTypeID OR at1.SecChargeTypeID = ct.ChargeTypeID)
	AND at1.ChargeTypeID IS NOT NULL
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND sa.AccountID = @AccountID
END

IF (@PackageID IS NOT NULL)
BEGIN
INSERT INTO Charges (CustomerID, StartDate, EndDate, PackageID, PackageTypeID, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser, Operator, AllowInterim)
SELECT DISTINCT p.CustomerID, @StartDate, @StartDate, p.PackageID, p.PackageTypeID, ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, getdate(), @Operator, @Operator, 0
FROM Packages p, PackageTypes pt, ChargeTypes ct
	WHERE p.PackageTypeID = pt.PackageTypeID
	AND (pt.ChargeTypeID = ct.ChargeTypeID OR pt.SecChargeTypeID = ct.ChargeTypeID)
	AND pt.ChargeTypeID IS NOT NULL
	AND p.Active = 1
	AND p.PackageID = @PackageID
END
GO

CREATE PROCEDURE dbo.CheckDatabase AS
DBCC CheckDB
GO

CREATE PROCEDURE dbo.CheckGroupGlobal @groupid INT AS
SELECT (SELECT COUNT(*) FROM AccountTypes at1, ServiceGroupItems sgi WHERE at1.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM AccountTypes WHERE GroupID = @groupid AND SortOrder >= 0) AS AccountTypes,
	(SELECT COUNT(*) FROM PackageTypes pt, ServiceGroupItems sgi WHERE pt.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM PackageTypes WHERE GroupID = @groupid AND SortOrder >= 0) AS PackageTypes,
	(SELECT COUNT(*) FROM BillingCycles bc, ServiceGroupItems sgi WHERE bc.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM BillingCycles WHERE GroupID = @groupid AND SortOrder >= 0) AS BillingCycles,
	(SELECT COUNT(*) FROM Regions r, ServiceGroupItems sgi WHERE r.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM Regions WHERE GroupID = @groupid AND SortOrder >= 0) AS Regions,
	(SELECT COUNT(*) FROM Domains d, ServiceGroupItems sgi WHERE d.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM Domains WHERE GroupID = @groupid AND SortOrder >= 0) AS Domains,
	(SELECT COUNT(*) FROM PayPeriods pp, ServiceGroupItems sgi WHERE pp.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM PayPeriods WHERE GroupID = @groupid AND SortOrder >= 0) AS PayPeriods,
	(SELECT COUNT(*) FROM ChargeTypes ct, ServiceGroupItems sgi WHERE ct.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM ChargeTypes WHERE GroupID = @groupid AND SortOrder >= 0) AS ChargeTypes,
	(SELECT COUNT(*) FROM SalesPersons sp, ServiceGroupItems sgi WHERE sp.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM SalesPersons WHERE GroupID = @groupid AND SortOrder >= 0) AS SalesPersons,
	(SELECT COUNT(*) FROM SendMethods sm, ServiceGroupItems sgi WHERE sm.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM SendMethods WHERE GroupID = @groupid AND SortOrder >= 0) AS SendMethods,
	(SELECT COUNT(*) FROM IncidentTypes it, ServiceGroupItems sgi WHERE it.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM IncidentTypes WHERE GroupID = @groupid AND SortOrder >= 0) AS IncidentTypes,
	(SELECT COUNT(*) FROM Discounts d, ServiceGroupItems sgi WHERE d.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=@groupid AND SortOrder >= 0) + (SELECT COUNT(*) FROM Discounts WHERE GroupID = @groupid AND SortOrder >= 0) AS Discounts
FROM Configs 
	WHERE ConfigID = 0
GO

CREATE PROCEDURE dbo.ClearOnline (@mins int) AS 
UPDATE ServerPorts SET AcctStatusType = 2
	WHERE DATEDIFF(mi,CallDate,getdate()) >= @mins
	AND AcctStatusType IN (1,3)
GO

CREATE PROCEDURE dbo.ConfigsGet AS
SET NOCOUNT ON
SELECT c.ConfigID, cd.GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c, ConfigGroupData cd
	WHERE c.ConfigID = cd.ConfigID
UNION ALL
SELECT c.ConfigID, cd.OperatorGroupID AS GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c, ConfigOperatorGroupData cd
	WHERE c.ConfigID = cd.ConfigID
UNION ALL
SELECT c.ConfigID, NULL AS GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, c.NumValue, c.Data
FROM Configs c
UNION ALL
SELECT 325 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 323
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 326 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 324
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 328 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' + cu.Code + ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 327
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 512 AS ConfigID, GroupID, 0 AS DataTypeID, OrganizationID AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 550 AS ConfigID, GroupID, 0 AS DataTypeID, DomainID AS Value, NULL AS Data FROM Groups WHERE DomainID IS NOT NULL
UNION ALL
SELECT 551 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, GroupName AS Data FROM Groups WHERE GroupName IS NOT NULL
UNION ALL
SELECT 552 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, Description AS Data FROM Groups WHERE Description IS NOT NULL
UNION ALL
SELECT 553 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceReport AS Data FROM Groups WHERE InvoiceReport IS NOT NULL
UNION ALL
SELECT 554 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceTextReport AS Data FROM Groups WHERE InvoiceTextReport IS NOT NULL
UNION ALL
SELECT 555 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceHTMLReport AS Data FROM Groups WHERE InvoiceHTMLReport IS NOT NULL
UNION ALL
SELECT 556 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementReport AS Data FROM Groups WHERE StatementReport IS NOT NULL
UNION ALL
SELECT 557 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementTextReport AS Data FROM Groups WHERE StatementTextReport IS NOT NULL
UNION ALL
SELECT 558 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementHTMLReport AS Data FROM Groups WHERE StatementHTMLReport IS NOT NULL
UNION ALL
SELECT 62 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, FTPDir AS Data FROM Groups WHERE FTPDir IS NOT NULL
UNION ALL
SELECT 560 AS ConfigID, OrganizationID, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups WHERE ReportLogoURL IS NOT NULL
UNION ALL
SELECT 562 AS ConfigID, GroupID, 0 AS DataTypeID, BillingOption AS Value, NULL AS Data FROM Groups WHERE BillingOption IS NOT NULL
UNION ALL
SELECT 563 AS ConfigID, GroupID, 0 AS DataTypeID, SendCredits AS Value, NULL AS Data FROM Groups WHERE SendCredits IS NOT NULL
UNION ALL
SELECT 567 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillName AS Data FROM Groups WHERE BillName IS NOT NULL
UNION ALL
SELECT 568 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillAddress1 AS Data FROM Groups WHERE BillAddress1 IS NOT NULL
UNION ALL
SELECT 569 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillAddress2 AS Data FROM Groups WHERE BillAddress2 IS NOT NULL
UNION ALL
SELECT 570 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillCity AS Data FROM Groups WHERE BillCity IS NOT NULL
UNION ALL
SELECT 571 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillState AS Data FROM Groups WHERE BillState IS NOT NULL
UNION ALL
SELECT 573 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillZip AS Data FROM Groups WHERE BillZip IS NOT NULL
UNION ALL
SELECT 574 AS ConfigID, GroupID, 0 AS DataTypeID, BillCountryID AS Value, NULL AS Data FROM Groups WHERE BillCountryID IS NOT NULL
UNION ALL
SELECT 575 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, EmailAccounts AS Data FROM Groups WHERE EmailAccounts IS NOT NULL
UNION ALL
SELECT 576 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, EmailSubject AS Data FROM Groups WHERE EmailSubject IS NOT NULL
UNION ALL
SELECT 579 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalIncidentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 580 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups
UNION ALL
SELECT 565 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalSendMethods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 590 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalAccountTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 591 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalBillingCycles AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 592 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalRegions AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 593 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalPayPeriods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 594 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalDiscounts AS Value, NULL  AS Data FROM Groups
UNION ALL
SELECT 595 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalChargeTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 596 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalPackageTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 597 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalDomains AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 598 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalSalesPersons AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 599 AS ConfigID, GroupID, 0 AS DataTypeID, MBRFields AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 583 AS ConfigID, GroupID, 0 AS DataTypeID, PaymentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 577 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType IN (1,2,5) THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 578 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType IN (4,6) THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 581 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType = 5 THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 582 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType = 6 THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
GO

CREATE PROCEDURE dbo.CreateServerPorts (@serverid int) AS
SET NOCOUNT ON
DECLARE @i int, @j int, @ports int, @servertype int, @maxports int, @p1 int, @p2 int, @snmptype int, @snmpbaseuser varchar(128), @snmpuser varchar(148)

if (@serverid > 0)
BEGIN
SELECT @servertype = s.ServerType, @ports = Ports, @snmptype = SNMPType, @snmpbaseuser = SNMPUser
FROM Servers s, ServerTypes st
	WHERE s.ServerID = @serverid
	AND s.ServerType = st.ServerType

if (@ports > 0)
	BEGIN
	DELETE FROM ServerPorts WHERE ServerID = @serverid
	SELECT @i = 0
	WHILE (@i < @ports)
		BEGIN
		SELECT @maxports = 1
		if (@servertype in (0, 2, 3, 4, 10))
			BEGIN
	                Select @p1 = @i

	        END ELSE IF (@servertype = 5)
			BEGIN
			SELECT @p1 = 10000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1
			SELECT @p2 = 20000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1, @maxports = 2
		END ELSE IF (@servertype = 6)
			BEGIN
			SELECT @p1 = 10000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1
			SELECT @p2 = 20000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1, @maxports = 2
		END ELSE IF (@servertype = 7)
			BEGIN
			SELECT @p1 = 10000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1
			SELECT @p2 = 20000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1, @maxports = 2
		END ELSE IF (@servertype = 12)
			BEGIN
			SELECT @p1 = 10000 + @i
			SELECT @p2 = 60000 + ((@i+1) * 100), @maxports = 2
		END ELSE IF (@servertype = 13)
			BEGIN
			SELECT @p1 = (1256 - (((@i % 256) / 31) * 7)) + @i
		END ELSE BEGIN
	                Select @p1 = @i + 1
			END
		SELECT @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then CAST(@p1 AS VARCHAR(10)) ELSE '' END 

		INSERT INTO ServerPorts (ServerID, NASIdentifier, Port, SNMPUser)
		SELECT @serverid, s.IPAddress, CAST(@p1 AS VARCHAR(10)), @snmpuser
		FROM Servers s
			WHERE s.ServerID = @serverid

		if (@maxports = 2)
			BEGIN
			SELECT @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then CAST(@p2 AS VARCHAR(10)) ELSE '' END

			INSERT INTO ServerPorts (ServerID,NASIdentifier,Port,SNMPUser) 
			SELECT @serverid, s.IPAddress, CAST(@p2 AS VARCHAR(10)), @snmpuser 
			FROM Servers s 
				WHERE s.ServerID = @serverid
			END
		Select @i = @i + 1
		END
	Select 'Ports Created: ' + CAST(@ports AS VARCHAR(64)) as Results, @servertype as ServerType
	END ELSE BEGIN
	Select 'Server Has no ports defined for it' as Results, @servertype as ServerType
	END
END ELSE BEGIN
	Select 'Invalid ServerID Parameter' as Results, @servertype as ServerType
END
GO

CREATE PROCEDURE dbo.CreditAdd (@CustomerID INT, @AccountID INT, @AccountTypeID INT, @PackageID INT, @PackageTypeID INT, @Amount NUMERIC(18,4), @LastModifyUser VARCHAR(64), @StartDate DATETIME, @EndDate DATETIME, @Description VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @Login VARCHAR(64)

IF (@AccountID IS NOT NULL)
BEGIN
SELECT @Login = COALESCE(Login,Email) FROM SubAccounts WHERE AccountID = @AccountID
END

INSERT INTO Charges (CustomerID,AccountID,Login,AccountTypeID,PackageID,PackageTypeID,Amount,Quantity,Description,StartDate,EndDate,LastModifyDate,LastModifyUser,DistFlag)
VALUES(@CustomerID,@AccountID,@Login,@AccountTypeID,@PackageID,@PackageTypeID,-(@Amount),1,@Description,COALESCE(@StartDate,getdate()),COALESCE(@EndDate,getdate()),getdate(),@LastModifyUser,1)
GO

CREATE PROCEDURE dbo.CreditCardExport (@BatchProcessorID INT, @CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@CustomerID IS NULL)
BEGIN
SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.AccountExpire) % 100 AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
(SELECT State FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State,
(SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State2,
COALESCE(cc.BillToCity,ma.City) AS City,
(SELECT Country FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country,
(SELECT Abbr2 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country2,
(SELECT Abbr3 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country3,
COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.ProcTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd,et.ExternalTransID, et.TransTypeID,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, ma.Company,
c.Code AS CurrencyCode, ma.PayInfo, et.AutoBill, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.BatchProcessorID = @BatchProcessorID
	AND ma.Active = 1
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND et.AccountExpire IS NOT NULL
	AND p.FinalAmount IS NULL

END ELSE BEGIN

SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.AccountExpire) % 100 AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
(SELECT State FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State,
(SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State2,
COALESCE(cc.BillToCity,ma.City) AS City,
(SELECT Country FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country,
(SELECT Abbr2 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country2,
(SELECT Abbr3 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country3,
COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.ProcTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode,
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd,et.ExternalTransID, et.TransTypeID,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CAST(DATEPART(yy,et.ReqDate) % 100 AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, ma.Company,
c.Code AS CurrencyCode, ma.PayInfo, et.AutoBill, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.BatchProcessorID = @BatchProcessorID
	AND ma.Active = 1
	AND et.TransStateID = 0
	AND ma.CustomerID = @CustomerID
	AND et.AccountNumber IS NOT NULL
	AND et.AccountExpire IS NOT NULL
	AND p.FinalAmount IS NULL
END
GO

CREATE PROCEDURE dbo.CreditCardImport (@TransID INT, @TransStateID INT, @ApproveCode VARCHAR(12), @Response VARCHAR(256), @etransid VARCHAR(64)) AS
UPDATE ExternalTrans
	SET TransStateID = @TransStateID, AuthSecurityCode = NULL,
	ApproveCode = @ApproveCode,
	Response = CAST(@Response AS VARCHAR(50)),
	ProcTransID = @etransid,
	ProcDate = getdate()
WHERE ExternalTransID = @TransID 
	AND TransStateID IN (0,2)

SET NOCOUNT ON
UPDATE CreditCards SET SecurityCode = NULL 
	WHERE CustomerID IN (SELECT cc.CustomerID
	FROM CreditCards cc, ExternalTrans et
		WHERE cc.CustomerID = et.CustomerID
		AND et.ExternalTransID = @TransID
		AND cc.SecurityCode IS NOT NULL)
GO

CREATE PROCEDURE dbo.CreditCardAuthOnlyVoid AS
UPDATE ExternalTrans SET TransStateID = 9
	WHERE TransTypeID = 16 
	AND TransStateID = 4 
	AND ProcDate < DATEADD(dd,-10,getdate())
GO

CREATE PROCEDURE dbo.CustomerAcctList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

CREATE TABLE #caltmp (PackageID INT, AccountTypeID INT, Cnt INT)

INSERT INTO #caltmp (PackageID, AccountTypeID, Cnt)
SELECT p.PackageID, sa.AccountTypeID, COUNT(*) AS Cnt
FROM Packages p, SubAccounts sa
	WHERE p.PackageID = sa.PackageID
	AND p.CustomerID = @CustomerID
	AND sa.CustomerID = p.CustomerID
	AND p.Active = 1
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
GROUP BY p.PackageID, sa.AccountTypeID

INSERT INTO #caltmp (PackageID, AccountTypeID, Cnt)
SELECT NULL, sa.AccountTypeID, COUNT(*) AS Cnt
FROM SubAccounts sa
	WHERE sa.CustomerID = @CustomerID
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > getdate())
GROUP BY sa.AccountTypeID

SELECT 4 AS GroupingID, p.PackageID, NULL AS AccountID, p.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS PackageType, pt.StringID AS PackageTypeStringID,
NULL AS Login, NULL AS AccountTypeID, NULL AS AccountType, NULL AS AccountTypeStringID, (SELECT MAX(AllowCustCancel) FROM PackageAccountTypes pat WHERE pat.PackageTypeID=p.PackageTypeID) AS AllowEdit, 
CASE WHEN p.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,CASE WHEN bc.AutoBill <> 2 THEN 1 ELSE 0 END + COALESCE(p.Extension,0)+COALESCE(ma.OverDue,0),p.ExpireDate) < getdate() THEN 3 ELSE 1 END AS Status, 
p.CancelDate, p.ExpireDate, COALESCE(p.Extension,0)+COALESCE(ma.OverDue,0) AS Extension,
NULL AS AvailCnt, NULL AS MaxCnt,
pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN p.DiffCost = 1 THEN p.Cost WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
- d.Amount END AS Cost, pp.PayPeriod AS PayPeriod, pp.StringID AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (pt.PackageTypeID = opt.PackageTypeID AND o.OrganizationID = opt.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM PackageAccountTypes pat WHERE pat.PackageTypeID = p.PackageTypeID AND pat.MaxQty > 0)

UNION ALL

SELECT 3 AS GroupingID, p.PackageID, sa.AccountID, pat.PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
COALESCE(sa.Login + CASE WHEN pat.AllowCustSetDomain = 1 THEN '@' + d.MailDomain ELSE '' END,sa.Email) AS Login, pat.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID,
CASE WHEN pat.AllowCustCancel = 1 AND sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 WHEN pat.AllowCustChangeLogin = 1 THEN 1 WHEN pat.AllowCustChangePass = 1 THEN 1 ELSE 0 END AS AllowEdit, CASE WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 ELSE 1 END AS Status, sa.CancelDate, NULL AS ExpireDate, NULL AS Extension,
NULL AS AvailCnt, NULL AS MaxCnt,
NULL AS Cost, NULL AS PayPeriod, NULL AS PayPeriodStringID,
2 AS LeftType, sa.TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS NUMERIC(18,4)) / 60 AS HoursLeft, sa.FirstName, sa.LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN SubAccounts sa ON (sa.PackageID = p.PackageID AND sa.AccountTypeID = pat.AccountTypeID AND sa.CustomerID = p.CustomerID AND sa.Active IN (1,0))
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.MaxQty > 0

UNION ALL

SELECT 2 AS GroupingID, p.PackageID, NULL AS AccountID, pat.PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
NULL AS Login, pat.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID, NULL AS AllowEdit, NULL AS Status, NULL AS CancelDate, NULL AS ExpireDate, NULL AS Extension,
CASE WHEN pat.CustomerMax < pat.MaxQty THEN pat.CustomerMax ELSE pat.MaxQty END - COALESCE(t.Cnt,0) AS AvailCnt,
CASE WHEN pat.CustomerMax < pat.MaxQty THEN pat.CustomerMax ELSE pat.MaxQty END AS MaxCnt,
NULL AS Cost, NULL AS PayPeriod, NULL AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN #caltmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND ((t.Cnt IS NULL AND pat.CustomerMax > 0 AND pat.MaxQty > 0) OR (t.Cnt < pat.CustomerMax AND t.Cnt < pat.MaxQty))

UNION ALL

SELECT DISTINCT 1 AS GroupingID, NULL AS PackageID, sa.AccountID, NULL AS PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
COALESCE(sa.Login + CASE WHEN pat.AllowCustSetDomain = 1 THEN '@' + dom.MailDomain ELSE '' END,sa.Email) AS Login, sa.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID,
CASE WHEN pat.AllowCustCancel = 1 AND sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 WHEN pat.AllowCustChangeLogin = 1 THEN 1 WHEN pat.AllowCustChangePass = 1 THEN 1 ELSE 0 END AS AllowEdit,
CASE WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,CASE WHEN bc.AutoBill <> 2 THEN 1 ELSE 0 END + COALESCE(sa.Extension,0)+COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate() THEN 3 ELSE 1 END AS Status, sa.CancelDate,
sa.ExpireDate, COALESCE(sa.Extension,0)+COALESCE(ma.OverDue,0) AS Extension, NULL AS AvailCnt, NULL AS MaxCnt,
pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
- d.Amount END AS Cost,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pp.PayPeriod END AS PayPeriod, CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pp.StringID END  AS PayPeriodStringID, 
2 AS LeftType, sa.TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS NUMERIC(18,4)) / 60 AS HoursLeft, sa.FirstName, sa.LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN SubAccounts sa ON (sa.PackageID IS NULL AND sa.AccountTypeID = pat.AccountTypeID AND sa.CustomerID = p.CustomerID AND sa.Active IN (1,0))
	JOIN Domains dom ON (sa.DomainID = dom.DomainID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1

UNION ALL

SELECT 0 AS GroupingID, NULL AS PackageID, NULL AS AccountID, NULL AS PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
NULL AS Login, at1.AccountTypeID, MIN(at1.AccountType), MIN(at1.StringID) AS AccountTypeStringID, NULL AS AllowEdit, NULL AS Status, NULL AS CancelDate, NULL AS ExpireDate, NULL AS Extension,
MAX(pat.CustomerMax) - (MAX(COALESCE(t.Cnt,0)) + MAX(COALESCE(t2.Cnt,0))) AS AvailCnt, MAX(pat.CustomerMax) AS MaxCnt,
MIN(pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
- d.Amount END) AS Cost,MIN(pp.PayPeriod) AS PayPeriod, MIN(pp.StringID) AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Discounts d ON (pat.NonPkgDiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN #caltmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	LEFT JOIN #caltmp t2 ON (t2.PackageID IS NULL AND t2.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND ((t.Cnt IS NULL AND pat.MaxQty <= 0) OR (t.Cnt >= pat.MaxQty))
	AND pat.CustomerMax > COALESCE(t.Cnt,0) + COALESCE(t2.Cnt,0)
GROUP BY at1.AccountTypeID
ORDER BY 2 DESC,1 DESC, 7 ASC

DROP TABLE #caltmp
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustomerAddCheck (@CustomerID INT, @AccountTypeID INT, @PackageID INT) AS
SET NOCOUNT ON
IF (@PackageID IS NULL)
BEGIN
CREATE TABLE #cactmp (PackageID INT, AccountTypeID INT, Cnt INT)

INSERT INTO #cactmp (PackageID, AccountTypeID, Cnt)
SELECT p.PackageID, sa.AccountTypeID, COUNT(*) AS Cnt
FROM Packages p, SubAccounts sa
	WHERE p.PackageID = sa.PackageID
	AND p.CustomerID = @CustomerID
	AND sa.CustomerID = p.CustomerID
	AND p.Active = 1
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > getdate())
GROUP BY p.PackageID, sa.AccountTypeID

INSERT INTO #cactmp (PackageID, AccountTypeID, Cnt)
SELECT NULL, sa.AccountTypeID, COUNT(*) AS Cnt
FROM SubAccounts sa
	WHERE sa.CustomerID = @CustomerID
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > getdate())
GROUP BY sa.AccountTypeID

SELECT CASE WHEN MAX(pat.CustomerMax) - (MAX(COALESCE(t.Cnt,0)) + MAX(COALESCE(t2.Cnt,0))) >= 0 THEN 1 ELSE 0 END AS Status
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Discounts d ON (pat.NonPkgDiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN #cactmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	LEFT JOIN #cactmp t2 ON (t2.PackageID IS NULL AND t2.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID = @CustomerID
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND at1.AccountTypeID=@AccountTypeID
	AND ((t.Cnt IS NULL AND pat.MaxQty <= 0) OR (t.Cnt >= pat.MaxQty))
	AND pat.CustomerMax >= COALESCE(t.Cnt,0) + COALESCE(t2.Cnt,0)
GROUP BY at1.AccountTypeID

DROP TABLE #cactmp
END ELSE BEGIN
SELECT CASE WHEN MAX(MaxQty) - COUNT(*) >= 0 THEN 1 ELSE 0 END AS Status
FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND pat.AccountTypeID=@AccountTypeID)
	LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.PackageID = p.PackageID AND sa.AccountTypeID = pat.AccountTypeID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()))
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND p.Active = 1
	AND p.PackageID = @PackageID
	AND pt.CustomerAccess = 1
END
GO

CREATE PROCEDURE dbo.CustomerAgingDetail (@custid INT) AS
SET NOCOUNT ON
SELECT i.InvoiceID, DATEDIFF(dd,i.CreateDate,getdate()) AS Days, SUM((ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount) AS Amount, i.CreateDate
FROM MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND ii.Amount > 0
	AND i.Estimate = 0
	AND i.VoidDate IS NULL
	AND ma.CustomerID = i.CustomerID
	AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
	AND ma.CustomerID = @custid
GROUP BY i.InvoiceID, i.CreateDate
HAVING SUM((ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount) > 0
GO

CREATE PROCEDURE dbo.CustomerAllowSA (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT DISTINCT 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustCancel ELSE 0 END AS AllowCustCancel, 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustChangeLogin ELSE 0 END AS AllowCustChangeLogin, 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustChangePass ELSE 0 END AS AllowCustChangePass,
sa.FirstName, sa.LastName, COALESCE(sa.Login,sa.Email) AS Account, at1.StringID AS AccountTypeStringID, at1.AccountType, at1.AccountTypeID
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN SubAccounts sa ON (sa.CustomerID = p.CustomerID AND sa.AccountID = @AccountID AND (sa.PackageID IS NULL OR sa.PackageID = p.PackageID))
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND pat.AccountTypeID = sa.AccountTypeID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID = @CustomerID
	AND sa.CustomerID = @CustomerID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustomerBillingInfo (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @RTPending NUMERIC(18,4)
SELECT @RTPending = SUM(TotalCost)
FROM RateHistory 
	WHERE ChargeID IS NULL 
	AND CustomerID = @CustomerID

SELECT CASE WHEN ma.PendingBalance + COALESCE(@RTPending,0) < 0 THEN 1 ELSE 0 END AS CreditBalance, CASE WHEN ma.OverLimit - ma.PendingBalance - COALESCE(@RTPending,0) > 0 THEN 1 ELSE 0 END AS HaveCredit, ma.OverLimit - ma.PendingBalance - COALESCE(@RTPending,0) AS CreditAmount, ma.PendingBalance + COALESCE(@RTPending,0) AS CurrentBalance, ma.PendingBalance, COALESCE(@RTPending,0) AS RealtimeAmount,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pt.PaymentType END AS PaymentType, CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pt.StringID END AS PaymentTypeStringID
FROM MasterAccounts ma, BillingCycles bc, PaymentTypes pt
	WHERE ma.CustomerID = @CustomerID 
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.PaymentTypeID = pt.PaymentTypeID
	AND ma.Active = 1
GO

CREATE PROCEDURE dbo.CustomerBuyTime (@CustomerID INT, @AccountID INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 0 AS Package, 2 AS LeftType, sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft AS NUMERIC(18,4)) / 60 AS HoursLeft, COALESCE(p.ExpireDate,sa.ExpireDate) AS ExpireDate, at1.AccountType, at1.StringID AS AccountTypeStringID, NULL AS PackageType, NULL AS PackageTypeStringID, ct.Amount, tc.TimeCharge, tc.StringID AS TimeChargeStringID, tc.Description, COALESCE(sa.Login,sa.Email) AS Login, sa.AccountID, NULL AS PackageID, ct.ChargeTypeID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN ServiceGroups sgc ON (ct.ServiceGroupID = sgc.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgic ON (ct.ServiceGroupID = sgic.ServiceGroupID AND sgic.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND sa.Active = 1
	AND sa.CancelDate IS NULL
	AND ma.Active = 1
	AND tc.CustomerAccess = 1
	AND tc.SortOrder >= 0
	AND ((ct.GroupID IS NULL AND g.GlobalChargeTypes=1) OR (ct.GroupID = ma.GroupID) OR (sgic.GroupID = ma.GroupID))
	AND ((bc.AutoBill = 2 AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
	AND (sa.PackageID IS NULL OR (sa.PackageID IS NOT NULL AND ((tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))))
	AND (@AccountID IS NULL OR sa.AccountID = @AccountID)

UNION ALL

SELECT 1 AS Package, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, p.ExpireDate, NULL AS AccountType, NULL AS AccountTypeStringID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS PackageType, pt.StringID AS PackageTypeStringID, ct.Amount, tc.TimeCharge, tc.StringID AS TimeChargeStringID, tc.Description, NULL AS Login, NULL AS AccountID, p.PackageID, ct.ChargeTypeID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN TimeCharges tc ON (p.PackageTypeID = tc.PackageTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ServiceGroups sgc ON (ct.ServiceGroupID = sgc.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgic ON (ct.ServiceGroupID = sgic.ServiceGroupID AND sgic.GroupID = ma.GroupID)
	WHERE ma.CustomerID = @CustomerID
	AND p.Active = 1
	AND p.CancelDate IS NULL
	AND ma.Active = 1
	AND tc.CustomerAccess = 1
	AND bc.AutoBill = 2
	AND tc.TimeLeft IS NULL
	AND tc.DataLeft IS NULL
	AND p.ExpireDate IS NOT NULL
	AND tc.SortOrder >= 0
	AND ((ct.GroupID IS NULL AND g.GlobalChargeTypes=1) OR (ct.GroupID = ma.GroupID) OR (sgic.GroupID = ma.GroupID))
	AND ((tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL))
	AND (@AccountID IS NULL OR p.PackageID IN (SELECT PackageID FROM SubAccounts WHERE AccountID=@AccountID))
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active = 1 AND sa.PackageID = p.PackageID)

ORDER BY 1 DESC, 12 ASC, 10 ASC
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustomerHistory (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @sd DATETIME

SELECT @sd = DATEADD(mm,-COALESCE(cgd.NumValue,c.NumValue,4),getdate())
FROM MasterAccounts ma JOIN Configs c ON (c.ConfigID = 693)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 693)
	WHERE ma.CustomerID = @CustomerID

SELECT 0 AS SortOrder, i.CreateDate, i.InvoiceID AS HistoryID, CASE WHEN i.VoidDate IS NOT NULL THEN 0 ELSE 1 END AS HistoryType, CASE WHEN Amount < 0 THEN Amount END AS Credit, CASE WHEN Amount >= 0 THEN Amount END AS Debit,  it.InvoiceType AS Description, it.StringID, NULL AS Info, NULL AS NumInfo
FROM Invoices i, InvoiceTypes it
	WHERE CustomerID = @CustomerID
		And i.InvoiceTypeID = it.InvoiceTypeID
		And i.CreateDate > @sd
		AND i.Processed = 1
UNION ALL
SELECT 0 AS SortOrder, s.StatementDate AS CreateDate, s.StatementID AS HistoryID, 7 AS HistoryType, NULL AS Credit, NULL AS Debit, NULL AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM Statements s
	WHERE s.CustomerID = @CustomerID
	AND s.StatementDate > @sd
UNION ALL
SELECT 0 AS SortOrder, LastModifyDate, ChargeID AS HistoryID, 3 AS HistoryType, CASE WHEN Amount < 0 THEN Amount END AS Credit, CASE WHEN Amount >= 0 THEN Amount END AS Debit, COALESCE(Login,'') + ' ' + Description AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM Charges
	WHERE  CustomerID = @CustomerID
	AND ItemID IS NULL
	AND LastModifyDate > @sd
UNION ALL
SELECT 0 AS SortOrder, nl.CreateDate, nl.NoticeLogID, 8 AS HistoryType, NULL AS Credit, NULL AS Debit, n.Notice AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM NoticeLogs nl LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
	WHERE nl.CustomerID = @CustomerID
	AND nl.AccountID IS NULL
	AND nl.CreateDate > @sd
UNION ALL
SELECT 0 AS SortOrder, p.CreateDate, p.PaymentID AS HistoryID, 4 AS HistoryType, CASE WHEN et.TransTypeID = 256 THEN NULL WHEN p.Amount >= 0 THEN p.Amount END AS Credit, CASE WHEN et.TransTypeID = 256 THEN p.Amount - p.FinalAmount WHEN p.Amount < 0 THEN p.Amount END AS Debit,
pt.PaymentType, pt.StringID, CASE WHEN p.PaymentTypeID = 4 THEN 'Check #' + p.CheckNumber ELSE et.Response END AS Info, NULL AS NumInfo
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID)
	WHERE p.CustomerID = @CustomerID
	AND p.CreateDate > @sd
UNION ALL
SELECT 0 AS SortOrder, ReqDate as CreateDate, et.ExternalTransID AS HistoryID, 5 AS HistoryType, Amount AS Credit, NULL AS Debit, CASE WHEN ts.TransStateID = 3 THEN Response ELSE ts.TransState END AS Response, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM ExternalTrans et, TransStates ts
	WHERE et.CustomerID = @CustomerID
	AND et.TransStateID = ts.TransStateID
	AND et.ReqDate > @sd
	AND et.TransStateID IN (0,1,2,3,7)
UNION ALL
SELECT 1 AS SortOrder, rh.StartDate AS CreateDate, r.RateID AS HistoryID, 6 AS HistoryType, NULL AS Credit, SUM(TotalCost) AS Debit, MIN(r.Description) AS Description, NULL AS StringID, MIN(ri.NameShort) AS Info, CASE WHEN MIN(rr.RateRuleTypeID) = 1 THEN SUM(rh.TotalTime) ELSE SUM(rh.TotalData) END / CAST(MIN(rr.Interval) AS NUMERIC(18,4)) AS NumInfo
FROM RateHistory rh, Rates r, RateRules rr, RateIntervals ri
	WHERE rh.ChargeID IS NULL
	AND rh.RateRuleID = rr.RateRuleID
	AND rr.Interval = ri.RateIntervalID
	AND rh.RateID = r.RateID
	AND rh.CustomerID = @CustomerID
	AND (rh.TotalCost > 0 OR rh.StartDate > DATEADD(dd,-32,getdate()))
GROUP BY rh.StartDate, r.RateID, rh.RateRuleID

ORDER BY 1 DESC,2 DESC
GO

CREATE PROCEDURE dbo.CustomerPOSItem (@CustomerID INT, @InvoiceID INT, @AccountID INT, @PackageID INT, @ChargeTypeID INT, @Quantity INT) AS
SET NOCOUNT ON
INSERT INTO InvoiceItems (InvoiceID,ItemType,Login,Days,Description,StartDate,EndDate,AccountID,PackageID,Amount,Quantity,TaxGroupID,AccountTypeID,ChargeTypeID,PackageTypeID)
SELECT @InvoiceID, 0, COALESCE(sa.Login,sa.Email),0,ct.Description,getdate(),getdate(),sa.AccountID,p.PackageID,ct.Amount,@Quantity,ct.TaxGroupID,sa.AccountTypeID,ct.ChargeTypeID,p.PackageTypeID
FROM MasterAccounts ma JOIN ChargeTypes ct ON (@ChargeTypeID = ct.ChargeTypeID)
	LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.AccountID = @AccountID)
	LEFT JOIN Packages p ON (ma.CustomerID = p.CustomerID AND p.PackageID = @PackageID)
	WHERE ma.Active = 1
	AND ma.CustomerID = @CustomerID
	AND @Quantity >= 1
GO

CREATE PROCEDURE dbo.CustomerStatus (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @timeused INT, @dataused BIGINT, @timeu INT, @datau BIGINT
SELECT @timeused = COALESCE(SUM(DATEDIFF(ss,CallDate,getdate())) / 60,0), @dataused = COALESCE(SUM(AcctOutputOctets),0) FROM ServerPorts WHERE AcctStatusType = 1 AND AccountID = @AccountID

SELECT @timeu = SUM(sau.TimeLeft) 
FROM SubAccountUsages sau 
	WHERE sau.AccountID = @AccountID
	AND sau.ExpireDate > getdate() 
	AND sau.TimeLeft > 0

SELECT @datau = SUM(sau.DataLeft) 
FROM SubAccountUsages sau 
	WHERE sau.AccountID = @AccountID
	AND sau.ExpireDate > getdate() 
	AND sau.DataLeft > 0

SELECT sa.ExpireDate AS ExpireDate, 
ma.PendingBalance AS Balance, 
(SELECT et2.ExternalTransID FROM ExternalTrans et2 WHERE et2.TransStateID = 3 AND et2.ExternalTransID IN (SELECT MAX(et1.ExternalTransID) FROM ExternalTrans et1 WHERE et1.CustomerID = ma.CustomerID AND ma.PendingBalance > 0 AND et1.ReqDate > DATEADD(dd,-30,getdate()))) AS CCFail,
(SELECT SUM(et.Amount) FROM ExternalTrans et WHERE et.CustomerID = ma.CustomerID AND et.TransStateID IN (0,1,2) AND et.TransTypeID IN (32,64)) AS CCPending,
ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS RealtimeBalance,
ma.OverLimit, CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(ma.OverDue,0) + COALESCE(sa.Extension,0) END AS Extension,
sa.FirstName, sa.LastName, sa.LoginLimit,
CASE WHEN (sa.TimeLeft + COALESCE(@timeu,0)) - @timeused < 60 THEN 1 ELSE 2 END AS LeftType, (sa.TimeLeft + COALESCE(@timeu,0)) - @timeused AS TimeLeft, ((sa.DataLeft + COALESCE(@datau,0)) - @dataused) / 1000000.0 AS DataLeft, CAST (((sa.TimeLeft + COALESCE(@timeu,0)) - @timeused) AS NUMERIC(18,4)) / 60 AS HoursLeft, 
ma.OverLimit, 
CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate
	WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate
	ELSE COALESCE(ma.CancelDate,sa.CancelDate) END AS CancelDate,
CASE WHEN ma.Active = 0 OR sa.Active = 0 THEN 0 WHEN DATEADD(dd,CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(ma.OverDue,0) + COALESCE(sa.Extension,0) END, sa.ExpireDate) < getdate() THEN 2 WHEN (sa.TimeLeft + COALESCE(@timeu,0)) - @timeused <= 0 THEN 3 WHEN (sa.DataLeft + COALESCE(@datau,0)) - @dataused <= 0 THEN 4 ELSE 1 END AS Status
FROM SubAccounts sa,MasterAccounts ma,BillingCycles bc
	WHERE sa.AccountID=@AccountID
	AND ma.CustomerID=sa.CustomerID
	AND ma.BillingCycleID=bc.BillingCycleID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustomerCCFailInfo (@ExternalTransID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT et.ExternalTransID, et.ProcDate, et.Amount, et.Response, CASE WHEN ma.PaymentTypeID = 1 OR bc.AutoBill = 2 THEN 0 ELSE 1 END AS AutoPay
FROM ExternalTrans et, MasterAccounts ma, BillingCycles bc
	WHERE et.ExternalTransID = @ExternalTransID
	AND et.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND et.TransStateID = 3	
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustomerCCVoid (@CustomerID INT) AS
SET NOCOUNT ON
UPDATE ExternalTrans SET TransStateID = 9 
	WHERE TransStateID = 3 
	AND ExternalTransID IN (SELECT MAX(et.ExternalTransID) FROM ExternalTrans et WHERE et.CustomerID = @CustomerID AND et.ReqDate > DATEADD(dd,-30,getdate()))
GO

CREATE PROCEDURE dbo.DeleteStartRecords AS
DELETE FROM Calls WHERE AcctStatusType = 1
GO

CREATE PROCEDURE dbo.DistInvoiceGet (@CustomerID INT, @InvoiceID INT, @upgrade INT) AS
SET NOCOUNT ON
IF (@CustomerID IS NOT NULL)
BEGIN
SELECT CASE WHEN MIN(i.InvoiceID) = @InvoiceID THEN 2 WHEN MIN(i.InvoiceTypeID) = 91 AND MIN(ma.PaymentTypeID) IN (8,16) AND @upgrade = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType,  MAX(ii.Amount * ii.Quantity) AS Amount, ROUND(MAX(ii.Amount * ii.Quantity),2) - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.VoidDate IS NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND (i.ChargeAmount <> i.PaidAmount OR (i.ChargeAmount = 0 AND i.InvoiceID = @InvoiceID))
	AND i.CustomerID = @CustomerID
GROUP BY ii.ItemID
UNION ALL
SELECT CASE WHEN MIN(i.InvoiceID) = @InvoiceID THEN 2 WHEN MIN(i.InvoiceTypeID) = 91 AND MIN(ma.PaymentTypeID) IN (8,16) AND @upgrade = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, 0 AS Amount, 0 - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.VoidDate IS NOT NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND (i.PaidAmount <> 0 OR (i.ChargeAmount = 0 AND i.InvoiceID = @InvoiceID))
	AND i.CustomerID = @CustomerID
GROUP BY ii.ItemID
ORDER BY 1 ASC, 8 DESC, 3 DESC, 2 DESC
END ELSE BEGIN
SELECT ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, CASE WHEN MIN(i.VoidDate) IS NULL THEN MIN(ii.Amount * ii.Quantity) ELSE 0 END AS Amount, CASE WHEN MIN(i.VoidDate) IS NULL THEN ROUND(MIN(ii.Amount * ii.Quantity),2) ELSE 0 END - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.InvoiceID = @InvoiceID
	AND i.Estimate = 0
GROUP BY ii.ItemID
ORDER BY 2 DESC, 1 DESC
END
GO

CREATE PROCEDURE dbo.DistInvoiceUpdate (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @CustomerID INT, @GroupID INT, @PaidAmount NUMERIC(18,4), @AutoBill INT, @PartialMode INT, @PartialAmount NUMERIC(18,4), @PartialPercent NUMERIC(18,4)
CREATE TABLE #diu (AccountID INT PRIMARY KEY, ExpireDate DATETIME, StartDate DATETIME, EndDate DATETIME)
CREATE TABLE #diup (PackageID INT PRIMARY KEY, ExpireDate DATETIME, StartDate DATETIME, EndDate DATETIME)

SELECT @CustomerID = ma.CustomerID, @GroupID = ma.GroupID, @AutoBill = bc.AutoBill
FROM Invoices i, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID = @InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID

SELECT @PartialMode = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 603 AND GroupID = @GroupID
SELECT @PartialAmount = MAX(NumValue) FROM ConfigGroupData WHERE ConfigID = 604 AND GroupID = @GroupID

IF (@PartialMode IS NULL)
BEGIN
SELECT @PartialMode = MAX(NumValue) FROM Configs WHERE ConfigID = 603
END

IF (@PartialAmount IS NULL)
BEGIN
SELECT @PartialAmount = MAX(NumValue) FROM Configs WHERE ConfigID = 604
END

IF (@PartialMode IS NULL OR @PartialMode = 0)
BEGIN
SELECT @PartialMode = 0, @PartialAmount = COALESCE(@PartialAmount,0.01)
END

IF (@PartialMode = 1)
BEGIN
SELECT @PartialPercent = CASE WHEN @PartialAmount IS NULL THEN .01 WHEN @PartialAmount BETWEEN 1 AND 100 THEN @PartialAmount/100 WHEN @PartialAmount BETWEEN .01 AND .99 THEN @PartialAmount END
END

SELECT @PaidAmount = SUM(ii.PaidAmount)
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.InvoiceID = @InvoiceID
	AND (ii.Quantity * ii.Amount) > 0

UPDATE Invoices SET PaidAmount = COALESCE(@PaidAmount,0) 
	WHERE InvoiceID = @InvoiceID 
	AND PaidAmount <> COALESCE(@PaidAmount,0)

INSERT INTO #diu (AccountID, ExpireDate, StartDate, EndDate)
SELECT sa.AccountID,
MAX(CASE		WHEN @AutoBill = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN @PartialMode = 0 AND ii.PaidAmount >= @PartialAmount THEN ii.EndDate
			WHEN @PartialMode = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * @PartialPercent) <= ii.PaidAmount  THEN ii.EndDate
			WHEN @PartialMode = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
			WHEN @AutoBill = 0 AND sa.ExpireDate IS NULL THEN ii.StartDate
END) AS ExpireDate, MIN(ii.StartDate) AS StartDate, MAX(ii.EndDate) AS EndDate
FROM SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE ma.CustomerID = sa.CustomerID
	AND i.CustomerID = ma.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.AccountID = sa.AccountID
	AND ii.ItemType IN (2,3)
	AND ii.Canceled = 0
	AND @AutoBill IN (0,1)
	AND i.VoidDate IS NULL
	AND ma.CustomerID = @CustomerID
	AND i.InvoiceID >= @InvoiceID
	AND i.Estimate = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
GROUP BY sa.AccountID

INSERT INTO #diup (PackageID, ExpireDate, StartDate, EndDate)
SELECT p.PackageID,
MAX(CASE		WHEN @AutoBill = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN @PartialMode = 0 AND ii.PaidAmount >= @PartialAmount THEN ii.EndDate
			WHEN @PartialMode = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * @PartialPercent) <= ii.PaidAmount  THEN ii.EndDate
			WHEN @PartialMode = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
			WHEN @AutoBill = 0 AND p.ExpireDate IS NULL THEN ii.StartDate
END) AS ExpireDate, MIN(ii.StartDate) AS StartDate, MAX(ii.EndDate) AS EndDate
FROM Packages p, SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE ma.CustomerID = sa.CustomerID
	AND i.CustomerID = ma.CustomerID
	AND ma.CustomerID = p.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.PackageID = sa.PackageID
	AND ii.ItemType IN (2,3)
	AND ii.Canceled = 0
	AND @AutoBill IN (0,1)
	AND i.VoidDate IS NULL
	AND ma.CustomerID = @CustomerID
	AND i.InvoiceID >= @InvoiceID
	AND i.Estimate = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND p.Active = 1
	AND p.PackageID = sa.PackageID
GROUP BY p.PackageID

-- Update service for non-packaged accounts
UPDATE SubAccounts SET ExpireDate = CASE WHEN diu.ExpireDate IS NOT NULL THEN diu.ExpireDate WHEN sa.ExpireDate >= diu.StartDate THEN DATEADD(dd,-1,diu.StartDate) WHEN @AutoBill = 1 THEN NULL ELSE sa.ExpireDate END, BilledThru = CASE WHEN sa.BilledThru < diu.EndDate THEN diu.EndDate ELSE sa.BilledThru END
FROM SubAccounts sa JOIN #diu diu ON (sa.AccountID = diu.AccountID)

-- Update package
UPDATE Packages SET ExpireDate = CASE WHEN diup.ExpireDate IS NOT NULL THEN diup.ExpireDate WHEN p.ExpireDate >= diup.StartDate THEN DATEADD(dd,-1,diup.StartDate) ELSE p.ExpireDate END, BilledThru = CASE WHEN p.BilledThru < diup.EndDate THEN diup.EndDate ELSE p.BilledThru END
FROM Packages p JOIN #diup diup ON (p.PackageID = diup.PackageID)

-- Update packaged services
UPDATE SubAccounts SET ExpireDate = CASE WHEN diup.ExpireDate IS NOT NULL THEN diup.ExpireDate WHEN sa.ExpireDate >= diup.StartDate THEN DATEADD(dd,-1,diup.StartDate) WHEN @AutoBill = 1 THEN NULL ELSE sa.ExpireDate END, BilledThru = CASE WHEN sa.BilledThru < diup.EndDate THEN diup.EndDate ELSE sa.BilledThru END
FROM SubAccounts sa JOIN #diup diup ON (sa.PackageID = diup.PackageID)
	WHERE sa.Active = 1

DROP TABLE #diu
DROP TABLE #diup
GO

CREATE PROCEDURE dbo.DistPayGet (@CustomerID INT, @PaymentID INT) AS
SET NOCOUNT ON
SELECT 1 AS IDType, p.PaymentID AS PID, MIN(COALESCE(p.FinalAmount,p.Amount)) AS Amount, COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountCommit, MIN(p.DistFlag) AS DistFlag
FROM Payments p LEFT JOIN PaymentItems pi1 ON (p.PaymentID = pi1.PaymentID)
	WHERE p.CustomerID = @CustomerID
	AND (p.DistFlag = 1 OR p.PaymentID = @PaymentID)
GROUP BY p.PaymentID
UNION ALL
SELECT 2 AS IDType, c.ChargeID AS PID, CASE WHEN MIN(i2.VoidDate) IS NULL AND (MAX(i2.Estimate) IS NULL OR MAX(i2.Estimate) = 0) THEN CASE WHEN  -(MIN(c.Amount * c.Quantity))  < 0 THEN 0 ELSE -(MIN(c.Amount * c.Quantity))  END ELSE 0 END AS Amount, COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountCommit, MIN(c.DistFlag) AS DistFlag
FROM Charges c LEFT JOIN PaymentItems pi1 ON (pi1.PaymentID IS NULL AND c.ChargeID = pi1.ChargeID)
	LEFT JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN InvoiceItems ii2 ON (c.ItemID = ii2.ItemID)
	LEFT JOIN Invoices i2 ON (ii2.InvoiceID = i2.InvoiceID)
	LEFT JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	WHERE c.CustomerID = @CustomerID
	AND c.DistFlag = 1
	AND c.Quantity > 0
	AND (i.Estimate IS NULL OR i.Estimate = 0)
	AND (c.Amount < 0 OR pi1.ChargeID IS NOT NULL)
GROUP BY c.ChargeID
ORDER BY 1 ASC, 2 DESC
GO

CREATE PROCEDURE dbo.DistPayItemAdd (@PaymentID INT, @ChargeID INT, @ItemID INT, @Amount NUMERIC(18,4)) AS
INSERT INTO PaymentItems (PaymentID,ChargeID,ItemID,Amount,ActiveDate) 
VALUES(@PaymentID,@ChargeID,@ItemID,@Amount,getdate())
GO

CREATE PROCEDURE dbo.ErrorHistory (@start DATETIME, @stop DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @istart DATETIME, @istop DATETIME
SELECT @istop = COALESCE(@stop,getdate()), @istart = COALESCE(@start,DATEADD(hh,-6,DATEADD(ss,-(  (DATEPART(hh,getdate()) * 3600) + (DATEPART(mi,getdate()) * 60) + DATEPART(ss,getdate()) ),getdate())))

SELECT 'Scheduled task failure - ' + COALESCE(s.TaskName,'') AS Description, sl.Description AS Message, COUNT(*) AS ErrCount
FROM Schedules s Left Join ScheduleLogs sl ON sl.ScheduleID = s.ScheduleID
WHERE sl.StartDate BETWEEN @istart AND @istop 
	AND sl.Status = 2
GROUP BY sl.Description,  s.TaskName
UNION ALL
SELECT 'Card processing' AS Description, et.Response AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et
	WHERE TransStateID = 3
	AND ProcDate BETWEEN @istart AND @istop
GROUP BY et.Response
UNION ALL
SELECT 'Card trans' AS Description, MIN(bp.BatchProcessor) + ' awaiting ' + CASE WHEN TransStateID = 0 THEN 'export' WHEN TransStateID =  2 THEN 'response' ELSE 'internal error' END + ' for more than 15 days' AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et, BatchProcessors bp, MasterAccounts ma
	WHERE et.TransStateID IN (0,2)
	AND et.CustomerID = ma.CustomerID
	AND ma.Active = 1
	AND et.ReqDate <= DATEADD(dd,-15,getdate())
	AND et.BatchProcessorID = bp.BatchProcessorID
GROUP BY bp.BatchProcessorID, TransStateID
UNION ALL
SELECT 'rating charges' AS Description, MIN(r.Description) + ' is over ' + CAST(MIN(DATEDIFF(mm,rh.StartDate,getdate())) AS VARCHAR(10)) + ' month(s) behind schedule' AS Message, COUNT(*) AS ErrCount
FROM RateHistory rh, Rates r, MasterAccounts ma, SubAccounts sa
	WHERE rh.RateID = r.RateID
	AND rh.StartDate < DATEADD(dd,-60,getdate())
	AND rh.ChargeID IS NULL
	AND rh.TotalCost > 0
	AND rh.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
GROUP BY  r.RateID, DATEDIFF(mm,rh.StartDate,getdate())
UNION ALL
SELECT 'CC/EFT pending against finalized payment', 'ExternalTransID ' + CAST(et.ExternalTransID AS VARCHAR(15)) + ', CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)), 1
FROM MasterAccounts ma, ExternalTrans et, Payments p
	WHERE ma.CustomerID = et.CustomerID
	AND et.PaymentID = p.PaymentID
	AND p.FinalAmount IS NOT NULL
	AND et.TransStateID = 0
	AND ma.Active = 1
UNION ALL
SELECT 'No task history for last 2 days','Is the Emerald Task Scheduler running?',1
FROM Configs
	WHERE ConfigID = 0
	AND DATEDIFF(dd,COALESCE((SELECT MAX(StartDate) FROM ScheduleLogs),getdate()),getdate()) > 2
UNION ALL
SELECT 'CC Auto Pay /w no CC number on file', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + ma.FirstName + ' ' + ma.LastName, 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND ma.CancelDate IS NULL
	AND ma.PaymentTypeID = 8
	AND cc.CardNumber IS NULL
UNION ALL
SELECT 'EFT Auto Pay /w no bank numbers on file', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + ma.FirstName + ' ' + ma.LastName, 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND ma.CancelDate IS NULL
	AND ma.PaymentTypeID = 16
	AND bt.ABANumber IS NULL
	AND bt.AccountNumber IS NULL
UNION ALL
SELECT 'MBR /w Email send method has no Email', 'CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' ' + ma.FirstName + ' ' + ma.LastName, 1
FROM MasterAccounts ma, SendMethods sm, PaymentTypes pt, BillingCycles bc
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.PaymentTypeID = pt.PaymentTypeID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sm.EmailTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR (ma.PaymentTypeID NOT IN (8,16)))
	AND ma.Email IS NULL
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > DATEADD(dd,-90,getdate()))
	AND NOT EXISTS (SELECT * FROM SubAccounts sa2 WHERE sa2.CustomerID = ma.CustomerID AND sa2.Active = 1 AND sa2.CancelDate IS NULL AND sa2.SendBill = 1 AND (sa2.Login IS NOT NULL OR sa2.Email IS NOT NULL))
UNION ALL
SELECT 'ES Sync ' + es.Name, ' CustomerID ' + CAST(ma.CustomerID AS VARCHAR(15)) + ' Login: ' + COALESCE(sa.Login,'N/A') + ' ' + ess.Message, ess.ErrorCount
FROM ExternalSyncs ess, SubAccounts sa, MasterAccounts ma, ExternalSystems es
	WHERE ess.ExternalSystemID = es.ExternalSystemID
	AND ess.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ess.ErrorCount > 0
	AND ess.Message IS NOT NULL
	AND ess.LastModifyDate > DATEADD(dd,-15,getdate())
UNION ALL
SELECT 'Syslog message' AS Description, Data AS Message, COUNT(*) AS ErrCount
FROM SysLogs
	WHERE Severity <= 3
	AND LogDate BETWEEN @istart AND @istop
GROUP BY Data
UNION ALL
SELECT 'Emerald - ' + lm.Description AS Description, l.LogMsg AS Message, COUNT(*) AS ErrCount
FROM Logs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND lm.Severity > 3
	AND LogDate BETWEEN @istart AND @istop
GROUP BY lm.Description, l.LogMsg
UNION ALL
SELECT 'Authentication failure - ' + rlm.Description AS Description, 'User: ' + rl.Username AS Message,  COUNT(*) AS ErrCount
FROM RadLogs rl, RadLogMsgs rlm
	WHERE rl.RadLogMsgID = rlm.RadLogMsgID
	AND LogDate BETWEEN @istart AND @istop
	AND rlm.Severity > 0
GROUP BY rl.Username, rlm.Description
UNION ALL
SELECT 'Mail error - ' + lm.Description AS Description, l.LogDescription AS Message, COUNT(*) AS ErrCount
FROM MailLogs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND lm.Severity > 3
	AND l.LogDate BETWEEN @istart AND @istop
GROUP BY lm.Description, l.LogDescription
GO

CREATE PROCEDURE dbo.ExportCopy (@SrcExportID INT, @DstExportID INT) AS
SET NOCOUNT ON
INSERT INTO Exports (ExportID,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount)
SELECT @DstExportID,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount
FROM Exports
	WHERE ExportID = @SrcExportID

INSERT INTO ExportColumns (ExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType)
SELECT @DstExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType
FROM ExportColumns
	WHERE ExportID = @SrcExportID

INSERT INTO CCImportColumns (ExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType)
SELECT @DstExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType
FROM CCImportColumns
	WHERE ExportID = @SrcExportID
GO

CREATE PROCEDURE dbo.ExternalTransCCAdd (@CustomerID INT, @BatchProcessorID INT, @BatchID INT, @InvoiceID INT, @AuthOnly INT, @Amount NUMERIC(18,4), @LastModifyUser VARCHAR(64), @AccountNumber VARCHAR(64), @AccountExpire DATETIME, @AuthName VARCHAR(50), @AuthAddress VARCHAR(64), @AuthStateID INT, @AuthZip VARCHAR(12), @AuthSecurityCode VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,LastRebatchTry)
VALUES(@CustomerID,@BatchProcessorID,@BatchID,@InvoiceID,0,CASE WHEN @AuthOnly = 1 THEN 16 ELSE 64 END,getdate(),@Amount,getdate(),@LastModifyUser,@AccountNumber,@AccountExpire,@AuthName,@AuthAddress,@AuthStateID,@AuthZip,@AuthSecurityCode,getdate())

UPDATE ExternalTrans SET TransStateID = 9 
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1
GO

CREATE PROCEDURE dbo.ExternalTransEFTAdd (@CustomerID INT, @BatchProcessorID INT, @BatchID INT, @InvoiceID INT, @AuthOnly INT, @Amount NUMERIC(18,4), @LastModifyUser VARCHAR(64), @AccountNumber VARCHAR(64), @BankNumber VARCHAR(64), @AuthName VARCHAR(50), @BankName VARCHAR(64), @BankPhone VARCHAR(20), @BankTransType VARCHAR(16), @SSN VARCHAR(64), @DLNumber VARCHAR(64), @DLState VARCHAR(40), @BirthDate DATETIME) AS
SET NOCOUNT ON
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,BankNumber,AuthName,BankName,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry)
VALUES(@CustomerID,@BatchProcessorID,@BatchID,@InvoiceID,0,CASE WHEN @AuthOnly = 1 THEN 16 ELSE 64 END,getdate(),@Amount,getdate(),@LastModifyUser,@AccountNumber,@BankNumber,@AuthName,@BankName,@BankPhone,@BankTransType,@SSN,@DLNumber,@DLState,@BirthDate,getdate())

UPDATE ExternalTrans SET TransStateID = 9
	WHERE CustomerID = @CustomerID
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1
GO

CREATE PROCEDURE dbo.ExternalTransImport (@CustomerID INT) AS
SET NOCOUNT ON
UPDATE IEALocks SET RefCount = RefCount + 1 WHERE IEALockID = 1
CREATE TABLE #etisum (CustomerID INT PRIMARY KEY, Amount NUMERIC(18,4), BatchProcessorID INT)

IF (@CustomerID IS NOT NULL)
BEGIN
UPDATE ExternalTrans SET TransStateID = 9
	WHERE ExternalTransID IN (SELECT ExternalTransID FROM ExternalTrans et, CreditCards cc
		WHERE et.CustomerID = cc.CustomerID
		AND et.AutoBill = 1
		AND et.TransTypeID IN (16,32,64)
		AND et.TransStateID = 3
		AND et.ProcDate < cc.LastModifyDate
		AND et.CustomerID = @CustomerID
		UNION ALL
		SELECT ExternalTransID FROM ExternalTrans et, BankTrans bt
			WHERE et.CustomerID = bt.CustomerID
			AND et.AutoBill = 1
			AND et.TransTypeID IN (16,32,64)
			AND et.TransStateID = 3
			AND et.ProcDate < bt.LastModifyDate
			AND et.CustomerID = @CustomerID)

UPDATE ExternalTrans SET TransStateID = 0, LastRebatchTry = getdate(), RebatchTries = COALESCE(RebatchTries,0) + 1
	WHERE ExternalTransID IN (SELECT et.ExternalTransID 
		FROM ExternalTrans et, BatchProcessors bp
		WHERE et.BatchProcessorID = bp.BatchProcessorID
		AND et.LastModifyDate <= getdate()
		AND et.TransStateID = 3
		AND et.AutoBill = 1
		AND DATEADD(dd,bp.RebatchInterval,LastRebatchTry) <= getdate()
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0
		AND et.CustomerID = @CustomerID)

INSERT INTO #etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE(MIN(aet.Amount),0)
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(Amount) AS Amount
		FROM ExternalTrans
			WHERE CustomerID = @CustomerID
			AND (NOT(TransTypeID IN (16,32,64) AND TransStateID = 3 AND AutoBill = 0)) 
			AND ((TransTypeID IN (16,32,64)	AND TransStateID IN (0,1,2,3,7)) OR (TransTypeID = 16 AND TransStateID = 4))
		GROUP BY CustomerID
		) aet ON (ma.CustomerID = aet.CustomerID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Estimate = 0
	AND i.Processed = 1
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND i.InvoiceTypeID IN (1,2,3,4,5,9,50,90)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate())
	AND (bc.TBillDays IS NULL OR COALESCE((SELECT DATEADD(dd,-(bc.TBillDays),MIN(StartDate)) FROM InvoiceItems ii WHERE i.InvoiceID = ii.InvoiceID AND ItemType = 3),DATEADD(dd,-1,getdate())) < getdate())
	AND ma.CustomerID = @CustomerID
GROUP BY ma.CustomerID
END ELSE BEGIN
UPDATE ExternalTrans SET TransStateID = 9
	WHERE ExternalTransID IN (SELECT ExternalTransID FROM ExternalTrans et, CreditCards cc
		WHERE et.CustomerID = cc.CustomerID
		AND et.AutoBill = 1
		AND et.TransTypeID IN (16,32,64)
		AND et.TransStateID = 3
		AND et.ProcDate < cc.LastModifyDate
		UNION ALL
		SELECT ExternalTransID FROM ExternalTrans et, BankTrans bt
			WHERE et.CustomerID = bt.CustomerID
			AND et.AutoBill = 1
			AND et.TransTypeID IN (16,32,64)
			AND et.TransStateID = 3
			AND et.ProcDate < bt.LastModifyDate)

UPDATE ExternalTrans SET TransStateID = 0, LastRebatchTry = getdate(), RebatchTries = COALESCE(RebatchTries,0) + 1
	WHERE ExternalTransID IN (SELECT et.ExternalTransID 
		FROM ExternalTrans et, BatchProcessors bp
		WHERE et.BatchProcessorID = bp.BatchProcessorID
		AND et.LastModifyDate <= getdate()
		AND et.TransStateID = 3
		AND et.AutoBill = 1
		AND DATEADD(dd,bp.RebatchInterval,LastRebatchTry) <= getdate()
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0)

INSERT INTO #etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE(MIN(aet.Amount),0)
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(Amount) AS Amount
		FROM ExternalTrans
			WHERE (NOT(TransTypeID IN (16,32,64) AND TransStateID = 3 AND AutoBill = 0)) 
			AND ((TransTypeID IN (16,32,64)	AND TransStateID IN (0,1,2,3,7)) OR (TransTypeID = 16 AND TransStateID = 4))
		GROUP BY CustomerID
		) aet ON (ma.CustomerID = aet.CustomerID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Estimate = 0
	AND i.Processed = 1
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND i.InvoiceTypeID IN (1,2,3,4,5,9,50,90)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < getdate())
	AND (bc.TBillDays IS NULL OR COALESCE((SELECT DATEADD(dd,-(bc.TBillDays),MIN(StartDate)) FROM InvoiceItems ii WHERE i.InvoiceID = ii.InvoiceID AND ItemType = 3),DATEADD(dd,-1,getdate())) < getdate())
GROUP BY ma.CustomerID
END

DELETE FROM #etisum WHERE Amount <= 0

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma, #etisum i, Groups g, BatchProcessors bp, CardTypes ct, Exports e, CreditCards cc
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND cc.CardTypeID = ct.CardTypeID
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.PaymentTypeID = 8
	AND ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND i.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma, #etisum i, Groups g, BatchProcessors bp, CardTypes ct, Exports e, CreditCards cc
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND cc.CardTypeID = ct.CardTypeID
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.PaymentTypeID = 8
	AND ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND i.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma, #etisum i, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((ma.PaymentTypeID = 8 AND e.ExportType IN (1,2,5) AND bp.CardTypes & 256 = 256) OR (ma.PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.BatchProcessorID IS NULL

UPDATE #etisum SET BatchProcessorID = bp.BatchProcessorID
FROM MasterAccounts ma, #etisum i, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((ma.PaymentTypeID = 8 AND e.ExportType IN (1,2,5) AND bp.CardTypes & 256 = 256) OR (ma.PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.BatchProcessorID IS NULL

DELETE FROM #etisum WHERE BatchProcessorID IS NULL

DELETE FROM #etisum WHERE CustomerID IN (SELECT et.CustomerID
FROM #etisum i, ExternalTrans et
	WHERE i.CustomerID = et.CustomerID
	AND et.TransStateID = 9
	AND et.LastModifyDate > DATEADD(hh,-3,getdate())
	AND et.Amount = i.Amount)

INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,Response,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,LastRebatchTry)
SELECT 1,ma.CustomerID, bp.BatchProcessorID, NULL, NULL, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 'Card expired' ELSE NULL END, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 3 WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, getdate(), i.Amount, getdate(), 'CC Auto Bill',cc.CardNumber,cc.ExpirationDate,cc.CardHolder,cc.BillToAddress1,cc.BillToZip,cc.SecurityCode,getdate()
FROM MasterAccounts ma, #etisum i, CreditCards cc, BatchProcessors bp, Exports e, PayPeriods pp
	WHERE ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayPeriodID = pp.PayPeriodID
	AND cc.CardNumber IS NOT NULL
	AND i.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND ma.Active = 1
	AND ma.PendingBalance >= i.Amount
	AND e.ExportType IN (1,2,5)

INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AuthName,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry)
SELECT 1,ma.CustomerID, bp.BatchProcessorID, NULL, NULL, CASE WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, getdate(), i.Amount, getdate(), 'ACH Auto Bill', bt.AccountNumber, bt.AuthName, bt.BankName, bt.ABANumber, bt.BankPhone, bt.TransType, bt.SSN, bt.DLNumber, bt.DLState, bt.BirthDate,getdate()
FROM MasterAccounts ma, #etisum i, BankTrans bt, BatchProcessors bp, Exports e, PayPeriods pp
	WHERE ma.CustomerID = i.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayPeriodID = pp.PayPeriodID
	AND i.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND ma.Active = 1
	AND ma.PendingBalance >= i.Amount
	AND bt.ABANumber IS NOT NULL
	AND bt.AccountNumber IS NOT NULL
	AND e.ExportType IN (4,6)

DROP TABLE #etisum
GO

CREATE PROCEDURE dbo.FTSEnabled AS
SET NOCOUNT ON
IF (fulltextserviceproperty('IsFulltextInstalled') = 1 AND (SELECT COUNT(*) FROM sysfulltextcatalogs where name = 'EmeraldCatalog') = 0)
BEGIN

EXEC sp_fulltext_database 'enable'
EXEC sp_fulltext_catalog 'EmeraldCatalog', 'create'

-- Incidents.Description FTI

DECLARE @pk varchar(64)

Select @pk=si.name
From sysindexes si, sysobjects so
Where si.id = so.id
	and so.name = 'Incidents'
 	and (si.status & 2048) = 2048

EXEC sp_fulltext_table 'Incidents', 'create', 'EmeraldCatalog', @pk
EXEC sp_fulltext_column 'Incidents', 'Description', 'add', 0
EXEC sp_fulltext_column 'Incidents', 'Summary', 'add', 0
EXEC sp_fulltext_table 'Incidents', 'activate'

-- Actions.Description FTI

Select @pk=si.name
From sysindexes si, sysobjects so
Where si.id = so.id
	and so.name = 'Actions'
 	and (si.status & 2048) = 2048

EXEC sp_fulltext_table 'Actions', 'create', 'EmeraldCatalog', @pk
EXEC sp_fulltext_column 'Actions', 'Description', 'add', 0
EXEC sp_fulltext_table 'Actions', 'activate'

EXEC sp_fulltext_catalog 'EmeraldCatalog', 'start_full' 
SELECT 1 AS Enabled
END ELSE BEGIN
SELECT fulltextserviceproperty('IsFulltextInstalled') AS Enabled
END
GO

CREATE PROCEDURE dbo.FTSIndex AS
SET NOCOUNT ON
IF ((Select fulltextserviceproperty('IsFulltextInstalled')) = 1 AND (SELECT COUNT(*) FROM sysfulltextcatalogs where name = 'EmeraldCatalog') = 1)
	EXEC sp_fulltext_catalog 'EmeraldCatalog', 'start_incremental'
GO

CREATE PROCEDURE dbo.History (@CustomerID INT, @backmonths  INT, @showtype INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @sd datetime
SELECT @sd = DATEADD(mm,-(COALESCE(@backmonths,120)),getdate())

SELECT i.CreateDate, 'Invoice' as Type, Amount, it.InvoiceType AS Description,  InvoiceID as ID,
 'invoice_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&InvoiceID=' + CAST(InvoiceID AS VARCHAR(16)) AS URL, CASE WHEN i.VoidDate IS NOT NULL THEN 'inactive' ELSE 'active' END AS bgcolor, i.LastModifyUser AS Operator
FROM Invoices i, InvoiceTypes it
WHERE @showtype & 2 = 2
	AND CustomerID = @CustomerID
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.CreateDate > @sd
UNION ALL
SELECT i.VoidDate AS CreateDate, 'Invoice' as Type, Amount,  'Invoice #' + CAST(i.InvoiceID AS VARCHAR(16)) + '  VOID' AS Description,
	 InvoiceID as ID, 'invoice_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&InvoiceID=' + CAST(InvoiceID AS VARCHAR(16)) as URL, 'inactive' AS bgcolor, i.LastModifyUser AS Operator
FROM Invoices i, InvoiceTypes it
WHERE @showtype & 2 = 2
	AND CustomerID = @CustomerID
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.VoidDate > @sd
	AND i.VoidDate IS NOT NULL
UNION ALL
Select s.StatementDate as CreateDate, 'Statement' as Type, EndBal as Amount,  
'' AS Description, StatementID as ID, 'statement_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&StatementID=' + CAST(StatementID AS VARCHAR(16)) as URL, 'active' AS bgcolor, NULL AS Operator
From Statements s
Where @showtype & 2 = 2
	and CustomerID = @CustomerID
	and s.StatementDate > @sd
UNION ALL
SELECT i.CreateDate, 'Incident', 0, COALESCE(CAST(i.Summary AS VARCHAR(128)),CAST(i.Description AS VARCHAR(128))), IncidentID,
'incident_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&IncidentID=' + CAST(i.IncidentID AS VARCHAR(16)) + '&AccountID=' + CAST(s.AccountID AS VARCHAR(16))  as URL,
COALESCE(is1.Style,CASE WHEN is1.StatOpen=1 AND is1.StatEscalate=1 THEN 'escalated' WHEN is1.StatOpen=1 AND is1.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN is1.StatOpen=1 THEN 'open' WHEN is1.StatArchive=1 THEN 'archived' WHEN is1.StatBlock=1 THEN 'blocking' WHEN is1.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS bgcolor, COALESCE(o.Operator, i.LastModifyUser) AS Operator
From Incidents i JOIN SubAccounts s ON (i.AccountID = s.AccountID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators o ON (i.CreateOperatorID = o.OperatorID)
	Where @showtype & 1 = 1
	and s.CustomerID = @CustomerID
	and i.CreateDate > @sd
UNION ALL
SELECT a.CreateDate, 'Action', 0, CAST(a.Description AS VARCHAR(128)), ActionID,
'incident_detail.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&IncidentID=' + CAST(i.IncidentID AS VARCHAR(16)) + '&AccountID=' + CAST(s.AccountID AS VARCHAR(16))  AS URL,
'' AS bgcolor, COALESCE(o.Operator,a.LastModifyUser) AS Operator
From Actions a JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN SubAccounts s ON (i.AccountID = s.AccountID)
	LEFT JOIN Operators o ON (a.CreateOperatorID = o.OperatorID)
	Where @showtype & 1 = 1
	and s.CustomerID = @CustomerID
	AND CAST(a.Description AS VARCHAR(1)) IS NOT NULL
	and a.CreateDate > @sd
UNION  ALL
Select LastModifyDate, 'Adjustment', Quantity * Amount AS Amount, 
Description + CASE WHEN Login IS NOT NULL THEN ' (' + Login + ')' ELSE '' END AS Description, ChargeID, 
CASE WHEN ItemID IS NOT NULL THEN 'none' ELSE 'mbr_adjustment_edit.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&ChargeID=' + CAST(ChargeID AS VARCHAR(16)) END  AS URL, '' AS bgcolor, COALESCE(Operator,LastModifyUser) AS Operator
From Charges
Where @showtype & 2 = 2
	and CustomerID = @CustomerID
    AND ItemID IS NULL
    and LastModifyDate > @sd
UNION ALL
SELECT DISTINCT p.CreateDate, 'Payment', COALESCE(p.FinalAmount,p.Amount) AS Amount,
CASE WHEN p.PaymentTypeID = 4 THEN pt.PaymentType + '# ' + COALESCE(p.CheckNumber,'') + '  ' + COALESCE(p.PayInfo,'') ELSE pt.PaymentType + '  ' + COALESCE(PayInfo,'') END AS Description, p.PaymentID,
CASE WHEN p.PaymentTypeID IN (8,16) AND e.ExportID IS NOT NULL AND et.AccountNumber IS NOT NULL AND p.FinalAmount IS NULL THEN 'mbr_payment_credit.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&PaymentID=' + CAST(p.PaymentID AS VARCHAR(16))
WHEN p.PaymentTypeID IN (2,4,64,128,256,512,1024,2048,4096,8192,16384,32768) AND p.FinalAmount IS NULL THEN 'mbr_payment_edit.ews?CustomerID=' + CAST(@CustomerID AS VARCHAR(16)) + '&PaymentID=' + CAST(p.PaymentID AS VARCHAR(16))
ELSE 'javascript:newwin4(''print_receipt.ews?headertype=17&PaymentID=' + CAST(p.PaymentID AS VARCHAR(16)) + ''',720, w=screen.height*.8)' END AS URL, NULL AS bgcolor, p.LastModifyUser AS Operator
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID AND et.TransStateID = 4 AND et.ProcTransID IS NOT NULL AND et.ProcTransID = p.ProcTransID)
	LEFT JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN Exports e ON (bp.ExportID = e.ExportID AND e.Features & 8 = 8)
	WHERE @showtype & 2 = 2
	AND p.CustomerID = @CustomerID
	AND p.CreateDate > @sd
UNION ALL
Select ReqDate as CreateDate, 'ETrans (' + tt.TransType + ')', Amount, CASE WHEN et.TransStateID = 9 THEN 'VOID - ' ELSE '' END + et.Response AS Response, ExternalTransID, 
	CASE WHEN et.TransStateID IN (0, 2) THEN 
'Javascript:ask(''Void this Etrans?'',''mbr_etrans_void.ews?CustomerID='  + CAST(@CustomerID AS VARCHAR(16)) + '&ExternalTransID=' + CAST(ExternalTransID AS VARCHAR(16)) + ''')' 
		ELSE 'none' END  as URL, 
CASE WHEN et.TransStateID = 4 THEN 'good' WHEN et.TransStateID = 3 THEN 'bad' WHEN et.TransStateID IN (7,8,9) THEN 'inactive' ELSE 'active' END AS bgcolor, et.LastModifyUser AS Operator
From ExternalTrans et, TransStates ts, TransTypes tt
Where @showtype & 4 = 4
	and CustomerID = @CustomerID
	AND et.TransStateID = ts.TransStateID
	AND et.TransTypeID = tt.TransTypeID
	and ReqDate > @sd
UNION ALL
SELECT nl.CreateDate, 'Emailed Notice', 0, COALESCE(n.Notice,'N/A'), nl.NoticeLogID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM NoticeLogs nl LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
WHERE @showtype & 8 = 8
	and nl.CustomerID = @CustomerID
	AND nl.AccountID IS NULL
	AND nl.CreateDate > @sd
UNION ALL
SELECT nl.CreateDate, 'Emailed Notice', 0, COALESCE(n.Notice,'N/A'), nl.NoticeLogID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM NoticeLogs nl JOIN SubAccounts sa ON (nl.AccountID = sa.AccountID) LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
WHERE @showtype & 8 = 8
	and nl.CustomerID IS NULL
	AND nl.CreateDate > @sd
	AND sa.CustomerID = @CustomerID
UNION ALL
SELECT ml.LogDate, lm.Description as Type, 0 as Amount, LogDescription as Description, 0 as ID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM MailLogs ml, LogMsgs lm
WHERE @showtype & 8 = 8
	and ml.LogMsgID = lm.LogMsgID
	AND ml.CustomerID = @CustomerID
	AND ml.LogDate > @sd
UNION ALL

SELECT l.LogDate, lm.Description as Type, 0 as Amount, LogMsg AS Description, 0 as ID, 'none' AS URL, '' AS bgcolor, l.Operator
FROM Logs l, LogMsgs lm
WHERE @showtype & 8 = 8
	and l.LogMsgID = lm.LogMsgID
	AND l.CustomerID = @CustomerID
	AND l.LogDate > @sd
UNION ALL
SELECT l.LogDate, lm.Description as Type, 0 as Amount, LogMsg AS Description, 0 as ID, 'none' AS URL, '' AS bgcolor, l.Operator
FROM AuditLogs l, LogMsgs lm
WHERE @showtype & 8 = 8
	and l.LogMsgID = lm.LogMsgID
	AND l.CustomerID = @CustomerID
	AND l.LogDate > @sd

ORDER BY 1 DESC
GO

CREATE PROCEDURE dbo.IISExport (@esid INT, @filemode INT) AS
SET NOCOUNT ON
DECLARE @incremental INT, @port INT, @ipaddress INT, @hostname INT, @description INT, @homedir INT
SELECT @incremental = CASE WHEN @filemode = 1 THEN 1 WHEN @filemode = 2 THEN 0 ELSE 1 END

SELECT @port = 1000, @hostname = 8, @ipaddress = 10, @description = 1001, @homedir = 2

SELECT sa.AccountID, CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Active, 
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @homedir) AS Path,
at1.AccountType,
COALESCE((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @description),ma.Company + ' (' + CAST(sa.AccountID AS VARCHAR(16)) + ')',sa.FirstName + ' ' + sa.LastName + ' (' + CAST(sa.AccountID AS VARCHAR(16)) + ')') AS Description,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @port) AS Port,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @hostname) AS Hostname,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @ipaddress) AS IPAddress
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystemAccountTypes esat, ExternalSystems es
WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.ExternalSystemID = @esid
	AND (es.LastSyncDate IS NULL OR ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)
	AND (SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = @homedir) IS NOT NULL
	AND (SELECT COUNT(*) FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.AccountDataTypeID IN (@port,@ipaddress,@hostname) AND sad.Data <> ' ') > 0
GO

CREATE PROCEDURE dbo.IMailSetUser (@esid INT, @username VARCHAR(40), @domain VARCHAR(64), @attribute VARCHAR(64), @value VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @DomainID INT, @AccountID INT, @DataTypeID INT, @nid int, @oldpassword VARCHAR(32)
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain

IF (@DomainID IS NOT NULL)
BEGIN
SELECT @AccountID = MAX(sa.AccountID)
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, ExternalSystemAccountTypes esat
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @esid
END

IF (@AccountID IS NOT NULL)
BEGIN
IF (@attribute = 'MaxSize')
	BEGIN
	SELECT @DataTypeID = 3
	END ELSE IF (@attribute = 'Password' AND @value IS NOT NULL AND DATALENGTH(@value) > 3)
	BEGIN
	SELECT @oldpassword = Password FROM SubAccounts WHERE AccountID = @AccountID
	UPDATE SubAccounts SET Password = @value WHERE AccountID = @AccountID
	END ELSE IF (@attribute IS NOT NULL)
	BEGIN
	SELECT @DataTypeID = MAX(AccountDataTypeID)
	FROM AccountDataTypes adt 
		WHERE AccountDataTypeID BETWEEN 900 AND 999
		AND AccountDataType  = @attribute
	END

IF (@DataTypeID IS NOT NULL)
	BEGIN
	UPDATE SubAccountData SET Data = @value WHERE AccountID = @AccountID AND AccountDataTypeID = @DataTypeID
	IF (@@ROWCOUNT = 0)
		BEGIN
		INSERT INTO SubAccountData (AccountID,AccountDataTypeID,Data)
		VALUES(@AccountID,@DataTypeID,@value)
		END
	END
END
GO

CREATE PROCEDURE dbo.IMailUsers (@esid INT, @username varchar(40), @domain varchar(64)) AS
DECLARE @DomainID INT, @AccountID INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain

IF (@username IS NULL) /* List all users in domain */
BEGIN
SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + @domain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN SubAccountData adt900 ON (adt900.AccountID = @AccountID AND adt900.AccountDataTypeID = 900)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID = sa.AccountID AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID = sa.AccountID AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID = sa.AccountID AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID = sa.AccountID AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID = sa.AccountID AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID = sa.AccountID AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID = sa.AccountID AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID = sa.AccountID AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID = sa.AccountID AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID = sa.AccountID AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID = sa.AccountID AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID = sa.AccountID AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID = sa.AccountID AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID = sa.AccountID AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID = sa.AccountID AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID = sa.AccountID AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID = sa.AccountID AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID = sa.AccountID AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID = sa.AccountID AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID = sa.AccountID AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID = sa.AccountID AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID = sa.AccountID AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID = sa.AccountID AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID = sa.AccountID AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID = sa.AccountID AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID = sa.AccountID AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID = sa.AccountID AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID = sa.AccountID AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID = sa.AccountID AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID = sa.AccountID AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID = sa.AccountID AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID = sa.AccountID AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID = sa.AccountID AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID = sa.AccountID AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID = sa.AccountID AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID = sa.AccountID AND adt936.AccountDataTypeID = 936)
	WHERE esat.ExternalSystemID = @esid
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ((sa.Login <> ' ' AND sa.DomainID = @DomainID) 
		OR (sa.Email LIKE '%_@' + @domain))
	AND sa.Active = 1 
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

END ELSE BEGIN

SELECT @AccountID = MAX(sa.AccountID)
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @esid)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email)
		OR (@username + '@' + @domain IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)))

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + @domain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa LEFT JOIN SubAccountData adt900 ON (adt900.AccountID = @AccountID AND adt900.AccountDataTypeID = 900)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID = @AccountID AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID = @AccountID AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID = @AccountID AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID = @AccountID AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID = @AccountID AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID = @AccountID AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID = @AccountID AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID = @AccountID AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID = @AccountID AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID = @AccountID AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID = @AccountID AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID = @AccountID AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID = @AccountID AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID = @AccountID AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID = @AccountID AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID = @AccountID AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID = @AccountID AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID = @AccountID AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID = @AccountID AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID = @AccountID AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID = @AccountID AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID = @AccountID AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID = @AccountID AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID = @AccountID AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID = @AccountID AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID = @AccountID AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID = @AccountID AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID = @AccountID AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID = @AccountID AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID = @AccountID AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID = @AccountID AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID = @AccountID AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID = @AccountID AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID = @AccountID AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID = @AccountID AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID = @AccountID AND adt936.AccountDataTypeID = 936)
	WHERE sa.AccountID = @AccountID
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.IncidentActionList (@GroupID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT a.ActionID,a.CreateDate, COALESCE((SELECT Operator FROM Operators WHERE OperatorID=a.CreateOperatorID),
(SELECT FirstName + '  ' + LastName FROM SubAccounts WHERE AccountID=a.CreateAccountID),'N/A') AS Operator,
a.Description,a.LastModifyDate,a.LastModifyUser, is1.IncidentState, a.Duration
FROM Actions a, IncidentStates is1, Incidents i, SubAccounts sa, MasterAccounts ma
	WHERE a.IncidentStateID = is1.IncidentStateID
	AND a.IncidentID = @IncidentID
	AND (CAST(a.Description AS VARCHAR(1)) IS NOT NULL OR a.Duration <> 0)
	AND a.IncidentID = i.IncidentID
	AND i.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.GroupID = @GroupID
	AND ma.Active IN (1,0)
ORDER BY a.ActionID
GO

CREATE PROCEDURE dbo.IncidentReassign (@RoleID INT, @OperatorID INT, @NewOperatorID INT, @assigntype INT) AS
SET NOCOUNT ON
IF (@assigntype = 1)
BEGIN
UPDATE Incidents SET AssignOperatorID = @NewOperatorID 
	WHERE AssignRoleID = @RoleID 
	AND AssignOperatorID = @OperatorID
	AND IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1)
END

IF (@assigntype = 2)
BEGIN
UPDATE Incidents SET AssignOperatorID = @NewOperatorID WHERE AssignRoleID = @RoleID AND AssignOperatorID = @OperatorID
END
GO

CREATE PROCEDURE dbo.IncidentAssignList (@OperatorID INT, @viewopt INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@viewopt = 1)
BEGIN
SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o, OperatorRoles r
	WHERE o.OperatorID = r.OperatorID
	AND r.RoleID IN (SELECT RoleID FROM OperatorRoles WHERE OperatorID = @OperatorID)
	AND o.Active = 1
	AND o.OperatorID <> @OperatorID
ORDER BY 2 ASC
END

IF (@viewopt = 2)
BEGIN
SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o 
	WHERE o.OperatorID IN (SELECT OperatorID FROM OperatorRoles)
	AND o.Active = 1
	AND o.OperatorID <> @OperatorID
ORDER BY 2 ASC
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.IncidentAssign (@RoleID INT, @GroupID INT, @AccountID INT) AS
SET NOCOUNT ON
DECLARE @iGroupID INT, @AssignStrategyID INT
SELECT @iGroupID = CASE WHEN @GroupID IN (1,0) THEN NULL ELSE @GroupID END
SELECT @AssignStrategyID = COALESCE(AssignStrategyID,1) FROM Roles WHERE RoleID = @RoleID

CREATE TABLE #inatmp (OperatorRoleID INT, Cnt INT)

IF (@AssignStrategyID = 1)
BEGIN
INSERT INTO #inatmp (OperatorRoleID, Cnt)
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.OperatorID = i.AssignOperatorID
	AND i.IncidentStateID = is1.IncidentStateID
	AND is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 0
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION ALL
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.RoleID = i.AssignRoleID
	AND i.IncidentStateID = is1.IncidentStateID
	AND is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID = @RoleID
	AND (GroupID IS NULL OR GroupID = @iGroupID)
END

IF (@AssignStrategyID = 2)
BEGIN
INSERT INTO #inatmp (OperatorRoleID, Cnt)
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.OperatorID = i.AssignOperatorID
	AND i.IncidentStateID = is1.IncidentStateID
	AND i.CreateDate > DATEADD(dd,-20,getdate())
	AND is1.StatEscalate = 0
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION ALL
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.RoleID = i.AssignRoleID
	AND i.IncidentStateID = is1.IncidentStateID
	AND i.CreateDate > DATEADD(dd,-20,getdate())
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID = @RoleID
	AND (or1.GroupID IS NULL OR or1.GroupID = @iGroupID)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID = @RoleID
	AND (GroupID IS NULL OR GroupID = @iGroupID)
END

SELECT TOP 1 NULL AS RoleAssignTypeID, t.OperatorRoleID, MAX(or1.RoleID) AS RoleID, MAX(or1.OperatorID) AS OperatorID, MAX(or1.Tier) AS Tier, SUM(t.Cnt) / CAST (MAX(or1.TargetActive) AS NUMERIC) AS TargetRatio, SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) AS MaxRatio
FROM #inatmp t, OperatorRoles or1
	WHERE t.OperatorRoleID = or1.OperatorRoleID
	AND (or1.TargetActive IS NULL OR or1.TargetActive > 0)
	AND (or1.MaxActive IS NULL OR or1.MaxActive > 0)
GROUP BY t.OperatorRoleID
ORDER BY CASE WHEN SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) > 1 THEN 1 ELSE 0 END ASC, 4 ASC, SUM(t.Cnt) / CAST(MAX(or1.TargetActive) AS NUMERIC) ASC

DROP TABLE #inatmp
GO

CREATE PROCEDURE dbo.IncidentMBRList (@CustomerID INT) AS
SET NOCOUNT ON
SELECT i.AccountID, CASE WHEN ins.StatOpen = 1 THEN i.PriorityID ELSE -1000 END AS Pri, IncidentID, i.CreateDate AS IncidentDate, 
COALESCE((SELECT Operator FROM Operators WHERE OperatorID = i.CreateOperatorID),(SELECT Login FROM SubAccounts WHERE AccountID = i.CreateAccountID)) AS Operator, 
COALESCE(CAST(i.Summary AS VARCHAR(255)),CAST(i.Description AS VARCHAR(100))) AS Description,
COALESCE(Style,CASE WHEN ins.StatOpen=1 AND ins.StatEscalate=1 THEN 'escalated' WHEN ins.StatOpen=1 AND ins.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN ins.StatOpen=1 THEN 'open' WHEN ins.StatArchive=1 THEN 'archived' WHEN ins.StatBlock=1 THEN 'blocking' WHEN ins.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Style,
IncidentState as Status, 
IncidentType, 
(Select Count(ActionID) From Actions a Where a.IncidentID = i.IncidentID) as Actions, p.Priority, p.StringID AS PriorityStringID
FROM Incidents i, IncidentStates ins, IncidentTypes it, SubAccounts sa, Priorities p
	WHERE i.AccountID = sa.AccountID
	AND sa.CustomerID = @CustomerID
	AND i.IncidentStateID = ins.IncidentStateID
	AND i.IncidentTypeID = it.IncidentTypeID
	AND i.PriorityID = p.PriorityID
ORDER BY 2 DESC, 3 DESC
GO

CREATE PROCEDURE dbo.IncidentSAList (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT IncidentID, CASE WHEN ins.StatOpen = 1 THEN i.PriorityID ELSE -1000 END AS Pri, i.CreateDate AS IncidentDate, COALESCE((SELECT Operator FROM Operators WHERE OperatorID = i.CreateOperatorID),(SELECT Login FROM SubAccounts WHERE AccountID = i.CreateAccountID)) AS Operator,
COALESCE(CAST(i.Summary AS VARCHAR(255)),CAST(i.Description AS VARCHAR(100))) AS Description,
	COALESCE(Style,CASE WHEN ins.StatOpen=1 AND ins.StatEscalate=1 THEN 'escalated' WHEN ins.StatOpen=1 AND ins.StatWait=0 AND i.DueDate < getdate() THEN 'pastdue' WHEN ins.StatOpen=1 THEN 'open' WHEN ins.StatArchive=1 THEN 'archived' WHEN ins.StatBlock=1 THEN 'blocking' WHEN ins.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Style,
	IncidentState as Status, IncidentType, (Select Count(ActionID) From Actions a Where a.IncidentID = i.IncidentID) as Actions, p.Priority, p.StringID AS PriorityStringID, i.CustomerAccess
FROM Incidents i, IncidentStates ins, IncidentTypes it, Priorities p
WHERE AccountID = @AccountID
	and i.IncidentStateID = ins.IncidentStateID
	AND i.PriorityID = p.PriorityID
	AND i.IncidentTypeID = it.IncidentTypeID

ORDER BY 2 DESC, 3 DESC
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.IncidentShow (@GroupID INT, @IncidentID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT i.IncidentID,i.AccountID,i.CreateDate,i.IncidentTypeID,i.IncidentStateID,it1.IncidentType,COALESCE(Duration,0) + COALESCE((SELECT SUM(Duration) FROM Actions WHERE IncidentID=i.IncidentID AND Duration IS NOT NULL),0) AS TotalDuration,
CASE WHEN it1.ShowDueDate = 1 AND is1.StatOpen = 1 THEN COALESCE(CASE WHEN it1.ShowCustDueDate = 1 THEN i.DueDate ELSE NULL END,DATEADD(dd,it1.OverDays,i.CreateDate)) ELSE NULL END AS DueDate,
COALESCE((SELECT Operator FROM Operators WHERE OperatorID=i.CreateOperatorID),
(SELECT FirstName + '  ' + LastName FROM SubAccounts WHERE AccountID=i.CreateAccountID),'N/A') AS Operator,i.Summary,i.Description,i.CustomerAccess,i.LastModifyDate,i.LastModifyUser,i.DueDate as CustDueDate,
AssignRoleID,AssignOperatorID,
COALESCE((SELECT [Role] FROM Roles WHERE RoleID=i.AssignRoleID),'N/A') AS AssignRole,
COALESCE((SELECT Operator FROM Operators WHERE OperatorID=i.AssignOperatorID),'N/A') AS AssignOperator,it1.ShowPriority,it1.ShowEmail,it1.ShowDuration,i.Duration,i.Email,it1.ShowSummary,i.PriorityID,it1.ShowCustomerAccess,it1.ShowCustDueDate
FROM Incidents i, IncidentTypes it1, IncidentStates is1, SubAccounts sa, MasterAccounts ma
	WHERE i.IncidentID = @IncidentID
	AND i.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.GroupID = @GroupID
	AND ma.Active IN (1,0)
	AND i.IncidentTypeID = it1.IncidentTypeID
	AND i.IncidentStateID = is1.IncidentStateID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.IncidentChangeTypeData (@IncidentID INT, @newIncidentTypeID INT) AS
SET NOCOUNT ON
CREATE TABLE #ictd (SrcIncidentDataTypeID INT, DstIncidentDataTypeID INT, DstData VARCHAR(255))

INSERT INTO #ictd (SrcIncidentDataTypeID,DstIncidentDataTypeID,DstData)
SELECT it1.IncidentDataTypeID, it2.IncidentDataTypeID, COALESCE(CAST(iv2.NumValue AS VARCHAR(10)),id1.Data)
FROM Incidents i JOIN IncidentDataTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentDataTypes it2 ON (it1.IncidentDataType = it2.IncidentDataType AND it2.IncidentTypeID = @newIncidentTypeID)
	JOIN IncidentData id1 ON (i.IncidentID = id1.IncidentID AND it1.IncidentDataTypeID = id1.IncidentDataTypeID)
	LEFT JOIN IncidentValues iv1 ON (it1.IncidentDataTypeID = iv1.IncidentDataTypeID AND it1.DataTypeID = 2 AND id1.Data = CAST(iv1.NumValue AS VARCHAR(10)))
	LEFT JOIN IncidentValues iv2 ON (it2.IncidentDataTypeID = iv2.IncidentDataTypeID AND it2.DataTypeID = 2 AND iv1.ValueName = iv2.ValueName)
	WHERE i.IncidentID = @IncidentID
	AND id1.Data IS NOT NULL
	AND it1.IncidentDataTypeID <> it2.IncidentDataTypeID
	AND it1.DataTypeID = it2.DataTypeID
	AND (	(it1.DataTypeID IN (0,1) AND it2.DataTypeID IN (0,1))
	OR	(it1.DataTypeID = 3 AND CAST(it1.SQLQuery AS VARCHAR(255)) = CAST(it2.SQLQuery AS VARCHAR(255)))
	OR	(it1.DataTypeID = 2 AND iv2.NumValue IS NOT NULL))

DELETE FROM IncidentData 
	WHERE IncidentID = @IncidentID 
	AND IncidentDataTypeID IN (SELECT DstIncidentDataTypeID FROM #ictd)

UPDATE IncidentData SET IncidentDataTypeID = i.DstIncidentDataTypeID, Data = i.DstData
FROM IncidentData id1, #ictd i
	WHERE id1.IncidentID = @IncidentID
	AND id1.IncidentDataTypeID = i.SrcIncidentDataTypeID

DROP TABLE #ictd
GO

CREATE PROCEDURE dbo.InvoiceAdd (@BatchID INT, @CustomerID INT, @InvoiceTypeID INT, @Amount NUMERIC(18,4), @ChargeAmount NUMERIC(18,4), @LastModifyUser VARCHAR(32), @Tax NUMERIC(18,4)) AS
SET NOCOUNT ON
INSERT INTO Invoices(BatchID,CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,LastModifyUser,Tax,Processed)
VALUES(@BatchID,@CustomerID,@InvoiceTypeID,@Amount,@ChargeAmount,0,@LastModifyUser,@Tax,1)

SELECT @@IDENTITY AS InvoiceID
GO

CREATE PROCEDURE dbo.InvoiceEmailList (@GroupID INT, @OperatorGroupID INT, @MBRGlobal INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT g.BillPhone, g.BillFax, ma.Company, ma.FirstName, ma.LastName, g.BillName, ma.CustomerID, i.InvoiceID, CASE WHEN sm.EmailTypeID = 16 THEN COALESCE(g.InvoiceTextReport,'einvoice.rpt') ELSE COALESCE(g.InvoiceReport,'invoice.rpt') END AS ReportFile,
'{Invoices.InvoiceID}=' + CAST(i.InvoiceID AS VARCHAR(16)) AS Formula
FROM MasterAccounts ma, SendMethods sm, Invoices i, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.EmailDate IS NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND i.CreateDate > DATEADD(dd,-45,getdate())
	AND sm.EmailTypeID IS NOT NULL
	AND g.AutoEmailInvoices IN (0,1)
	AND ma.GroupID = g.GroupID
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND ((@OperatorGroupID IS NULL AND g.AutoEmailInvoices = 1) OR (@OperatorGroupID IS NOT NULL AND (COALESCE(@MBRGlobal,1) = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=106 AND OperatorGroupID=@OperatorGroupID))))
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.InvoiceEmailSent (@CustomerID INT, @InvoiceID INT) AS
SET NOCOUNT ON
UPDATE Invoices SET EmailDate=getdate() WHERE EmailDate IS NULL AND InvoiceID = @InvoiceID
INSERT INTO MailLogs (LogDate, LogMsgID, CustomerID, TokenID) 
VALUES(getdate(), 1001,@CustomerID,@InvoiceID)
GO

CREATE PROCEDURE dbo.InvoiceGetItems (@ForceNext INT, @CustomerID INT) AS
SET NOCOUNT ON
DECLARE @inv_next_days INT
SELECT @inv_next_days = COALESCE(MAX(NumValue),0) FROM Configs WHERE ConfigID = 37

SELECT CASE WHEN c.Amount < 0 THEN 1 ELSE 2 END AS ItemType, c.AccountID, c.AccountTypeID, c.PackageID, c.PackageTypeID, c.ChargeID, c.ChargeTypeID, c.Login, COALESCE(c.Description,ct.Description) AS Description, CASE WHEN c.Description IS NULL THEN ct.StringID ELSE NULL END AS StringID, c.Amount, c.Quantity, 
CASE WHEN c.Prorated = 1 THEN 3 ELSE NULL END AS QuantityType, c.TaxGroupID, c.TaxExemptions, c.StartDate, c.EndDate,
CASE WHEN c.Prorated = 0 THEN NULL WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < COALESCE((SELECT CancelDate FROM SubAccounts WHERE AccountID=c.AccountID),(SELECT CancelDate FROM Packages WHERE PackageID=c.PackageID),ma.CancelDate) THEN ma.CancelDate ELSE COALESCE((SELECT CancelDate FROM SubAccounts WHERE AccountID=c.AccountID),(SELECT CancelDate FROM Packages WHERE PackageID=c.PackageID),ma.CancelDate) END AS CancelDate
FROM MasterAccounts ma JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	LEFT JOIN ChargeTypes ct ON (c.ChargeTypeID = ct.ChargeTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND c.ItemID IS NULL
	AND ma.Active = 1

SELECT 3 AS ItemType, sa.AccountID, sa.AccountTypeID, COALESCE(sa.Login,sa.Email) AS Login, at1.Description, at1.StringID, CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE (COALESCE(oat.CustomerCost,at1.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN at1.NextCount IS NOT NULL AND at1.NextID IS NOT NULL AND pp.PeriodTypeID = 1 AND sa.CycleMonths + pp.Period > at1.NextCount THEN pp.Period - ((sa.CycleMonths + pp.Period) - at1.NextCount) ELSE pp.Period END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN sa.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN sa.DiffCost = 1 OR at1.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, at1.TaxGroupID, at1.TaxExemptions, sa.CycleMonths, sa.LastInvoiceID, DATEADD(dd,1,sa.BilledThru) AS StartDate, CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE COALESCE(sa.CancelDate,ma.CancelDate) END AS CancelDate, at1.ChangeClose,
sa.BillStatus, CASE WHEN pp.PeriodTypeID = 1 THEN pp.Period ELSE NULL END AS Months, CASE WHEN sa.BillStatus = 1 THEN at1.ChangeOpen WHEN sa.BillStatus = 2 THEN at1.ChangeTo ELSE NULL END AS ChangeOpen, CASE WHEN bc.CycleType = 3 AND pp.PeriodTypeID = 1 AND pp.Period > 1 THEN (SELECT MAX(sa2.BilledThru) FROM SubAccounts sa2, PayPeriods pp2 WHERE sa2.PayPeriodID = pp2.PayPeriodID AND sa2.Active = 1 AND pp2.PeriodTypeID = 1 AND pp2.Period = pp.Period AND sa2.CustomerID = @CustomerID) END AS MaxBilled
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND sa.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID = @CustomerID
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate)

SELECT 3 AS ItemType, sa.AccountID, sa.AccountTypeID AS origAccountTypeID, at1.AccountTypeID, COALESCE(sa.Login,sa.Email) AS Login, at1.Description, at1.StringID, CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE (COALESCE(oat.CustomerCost,at1.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN sa.CycleMonths + pp.Period - atc.NextCount > pp.Period THEN pp.Period ELSE sa.CycleMonths + pp.Period - atc.NextCount END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN sa.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN sa.DiffCost = 1 OR at1.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, at1.TaxGroupID, at1.TaxExemptions, -1 AS CycleMonths, sa.LastInvoiceID, CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE COALESCE(sa.CancelDate,ma.CancelDate) END AS CancelDate, at1.ChangeClose
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes atc ON (sa.AccountTypeID = atc.AccountTypeID)
	JOIN AccountTypes at1 ON (atc.NextID = at1.AccountTypeID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND sa.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND atc.NextCount IS NOT NULL
	AND atc.NextID IS NOT NULL
	AND pp.PeriodTypeID = 1
	AND sa.CycleMonths + pp.Period > atc.NextCount
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID = @CustomerID
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate)

SELECT 3 AS ItemType, p.PackageID, p.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS Description, pt.StringID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE (COALESCE(opt.CustomerCost,pt.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN pt.NextCount IS NOT NULL AND pt.NextID IS NOT NULL AND pp.PeriodTypeID = 1 AND p.CycleMonths + pp.Period > pt.NextCount THEN pp.Period - ((p.CycleMonths + pp.Period) - pt.NextCount) ELSE pp.Period END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN p.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN p.DiffCost = 1 OR pt.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, pt.TaxGroupID, pt.TaxExemptions, p.CycleMonths, p.LastInvoiceID, DATEADD(dd,1,p.BilledThru) AS StartDate, CASE WHEN ma.CancelDate IS NOT NULL AND p.CancelDate IS NOT NULL AND ma.CancelDate < p.CancelDate THEN ma.CancelDate ELSE COALESCE(p.CancelDate,ma.CancelDate) END AS CancelDate, pt.ChangeClose,
p.BillStatus, CASE WHEN pp.PeriodTypeID = 1 THEN pp.Period ELSE NULL END AS Months, CASE WHEN p.BillStatus = 1 THEN pt.ChangeOpen WHEN p.BillStatus = 2 THEN pt.ChangeTo ELSE NULL END AS ChangeOpen, CASE WHEN bc.CycleType = 3 AND pp.PeriodTypeID = 1 AND pp.Period > 1 THEN (SELECT MAX(p2.BilledThru) FROM Packages p2, PayPeriods pp2 WHERE p2.PayPeriodID = pp2.PayPeriodID AND p2.Active = 1 AND pp2.PeriodTypeID = 1 AND pp2.Period = pp.Period AND p2.CustomerID = @CustomerID) END AS MaxBilled
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND (sa.CancelDate IS NULL OR sa.CancelDate > p.BilledThru) AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID = @CustomerID
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= p.BilledThru)
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate)

SELECT 3 AS ItemType, p.PackageID, p.PackageTypeID AS origPackageTypeID, pt.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS Description, pt.StringID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE (COALESCE(opt.CustomerCost,pt.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN p.CycleMonths + pp.Period - ptc.NextCount > pp.Period THEN pp.Period ELSE p.CycleMonths + pp.Period - ptc.NextCount END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN p.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN p.DiffCost = 1 OR pt.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, pt.TaxGroupID, pt.TaxExemptions, -1 AS CycleMonths, p.LastInvoiceID, CASE WHEN ma.CancelDate IS NOT NULL AND p.CancelDate IS NOT NULL AND ma.CancelDate < p.CancelDate THEN ma.CancelDate ELSE COALESCE(p.CancelDate,ma.CancelDate) END AS CancelDate, pt.ChangeClose
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes ptc ON (p.PackageTypeID = ptc.PackageTypeID)
	JOIN PackageTypes pt ON (ptc.NextID = pt.PackageTypeID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ptc.NextCount IS NOT NULL
	AND ptc.NextID IS NOT NULL
	AND pp.PeriodTypeID = 1
	AND p.CycleMonths + pp.Period > ptc.NextCount
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID = @CustomerID
	AND ((COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= p.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate)
GO

CREATE PROCEDURE dbo.InvoiceGetList (@ForceNext INT, @InvoiceID INT, @CustomerID INT, @GroupID INT, @OperatorGroupID INT, @LanguageID INT) AS
SET NOCOUNT ON
DECLARE @inv_next_days INT, @interim_lookahead INT

CREATE TABLE #iglc (CustomerID INT PRIMARY KEY)

SELECT @inv_next_days = COALESCE(MAX(NumValue),0) FROM Configs WHERE ConfigID = 37
SELECT @interim_lookahead = COALESCE(MAX(NumValue),45) FROM Configs WHERE ConfigID = 36

IF (@CustomerID IS NOT NULL)
BEGIN
INSERT INTO #iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1 AND CustomerID = @CustomerID
END ELSE IF (@GroupID IS NOT NULL)
BEGIN
INSERT INTO #iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1 AND GroupID = @GroupID
END ELSE BEGIN
INSERT INTO #iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1
END

SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Charges c ON (c.ItemID IS NULL AND ma.CustomerID = c.CustomerID AND c.Quantity > 0)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate()) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND ((c.ChargeID IS NOT NULL AND @CustomerID IS NOT NULL)
		OR (COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= sa.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate)
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Charges c ON (c.ItemID IS NULL AND ma.CustomerID = c.CustomerID AND c.Quantity > 0)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND (sa.CancelDate IS NULL OR sa.CancelDate > p.BilledThru) AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate()) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > getdate())  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND ((c.ChargeID IS NOT NULL AND @CustomerID IS NOT NULL)
		OR (COALESCE(@ForceNext,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) >= p.BilledThru) 
		OR (@ForceNext = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,@inv_next_days,90),getdate()) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate)
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND c.ItemID IS NULL
	AND c.AllowInterim = 1
	AND c.Quantity > 0
	AND bc.AutoBill IN (0,1)
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND c.ChargeID IS NOT NULL
	AND ((ma.CancelDate < getdate()) OR (NOT EXISTS (SELECT * FROM SubAccounts sa WHERE sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate < sa.BilledThru) AND sa.PackageID IS NULL AND DATEADD(dd,@interim_lookahead + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) > sa.BilledThru)
		AND NOT EXISTS (SELECT * FROM Packages p WHERE p.CustomerID = ma.CustomerID AND p.Active = 1 AND DATEADD(dd,@interim_lookahead + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,getdate()) > p.BilledThru)))
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	WHERE ma.Active = 1
	AND c.ItemID IS NULL
	AND c.Quantity > 0
	AND c.AllowInterim = 1
	AND bc.AutoBill = 2
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND c.ChargeID IS NOT NULL
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
UNION ALL
SELECT 91 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, Invoices i, BillingCycles bc
	WHERE ma.CustomerID = i.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.InvoiceID = @InvoiceID
	AND @InvoiceID IS NOT NULL
	AND i.Processed = 0
	AND i.InvoiceTypeID = 91
	AND i.Estimate = 0
UNION ALL
SELECT DISTINCT 50 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, BillingCycles bc, Organizations o, Groups g, MasterAccounts ma2, SubAccounts sa2, ResellerUsage ru
	WHERE ma.CustomerID = o.ResellerCustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND g.OrganizationID = o.OrganizationID
	AND g.GroupID = ma2.GroupID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND ma2.CustomerID = sa2.CustomerID
	AND sa2.AccountID = ru.AccountID
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth AND DATEPART(dd,getdate()) >= 1))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
UNION
SELECT DISTINCT 50 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN @CustomerID IS NOT NULL AND @LanguageID IS NOT NULL THEN @LanguageID ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, BillingCycles bc, Organizations o, Groups g, MasterAccounts ma2, Packages p2, ResellerPkgUsage ru
	WHERE ma.CustomerID = o.ResellerCustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND g.OrganizationID = o.OrganizationID
	AND g.GroupID = ma2.GroupID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ma.CustomerID IN (SELECT CustomerID FROM #iglc)
	AND ma2.CustomerID = p2.CustomerID
	AND p2.PackageID = ru.PackageID
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth AND DATEPART(dd,getdate()) >= 1))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND @InvoiceID IS NULL
	AND (@OperatorGroupID IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID = @OperatorGroupID AND ObjectGroupID = 104 AND AccessType & 2 = 2))
ORDER BY 5

DROP TABLE #iglc
GO

CREATE PROCEDURE dbo.InvoiceGetPOSItems (@InvoiceID INT) AS
SET NOCOUNT ON
SELECT ii.ItemID, ii.ItemType, ii.Login, ii.Days, ii.Description, ii.StartDate, ii.EndDate, ii.AccountID, ii.PackageID, ii.Amount, ii.Quantity, ii.TaxGroupID, ii.ChargeTypeID, COALESCE(sa.LastInvoiceID,p.LastInvoiceID) AS LastInvoiceID
FROM InvoiceItems ii LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE ii.InvoiceID = @InvoiceID
GO

CREATE PROCEDURE dbo.InvoiceGetResellerItems (@CustomerID INT) AS
SET NOCOUNT ON
SELECT 2 AS ItemType, sa2.AccountID, at2.AccountTypeID, COALESCE(sa2.Login,sa2.Email) AS Login, at2.AccountType AS Description, at2.StringID, COALESCE(oat.ResellerCost,at2.Cost) * CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 1 ELSE (CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END) / 30 END AS Amount, 1 AS Quantity, 0 AS QuantityType, at2.TaxGroupID, at2.TaxExemptions, CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 0 ELSE CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END END AS Days,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 1

SELECT 2 AS ItemType, p2.PackageID, pt2.PackageTypeID, pt2.PackageType AS Description, pt2.StringID, COALESCE(opt.ResellerCost,pt2.Cost) * CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 1 ELSE (CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END) / 30 END AS Amount, 1 AS Quantity, 0 AS QuantityType, pt2.TaxGroupID, pt2.TaxExemptions, CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 0 ELSE CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END END AS Days,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN Packages p2 ON (ma2.CustomerID = p2.CustomerID)
	JOIN ResellerPkgUsage ru ON (p2.PackageID = ru.PackageID)
	JOIN PackageTypes pt2 ON (ru.PackageTypeID = pt2.PackageTypeID)
	LEFT JOIN OrgPackageTypes opt ON (o.OrganizationID = opt.OrganizationID AND pt2.PackageTypeID = opt.PackageTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 1

SELECT 2 AS ItemType, ru.AccountTypeID, MIN(at2.AccountType) AS Description, MIN(at2.StringID) AS StringID, COUNT(*) AS RCount,ROUND(SUM(CASE WHEN (o.InvoiceFractional = 0 AND ru.Days > 0) OR ru.Days >= 27.5 THEN 30 ELSE ru.Days END) / 30,0) AS Quantity,MIN(COALESCE(oat.ResellerCost,at2.Cost)) AS Amount, 0 AS QuantityType, MIN(at2.TaxGroupID) AS TaxGroupID, MIN(at2.TaxExemptions) AS TaxExemptions,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 0
GROUP BY ru.StartYear,ru.StartMonth,ru.AccountTypeID

SELECT 2 AS ItemType, ru.PackageTypeID, MIN(pt2.PackageType) AS Description, MIN(pt2.StringID) AS StringID, COUNT(*) AS RCount,ROUND(SUM(CASE WHEN (o.InvoiceFractional = 0 AND ru.Days > 0) OR ru.Days >= 27.5 THEN 30 ELSE ru.Days END) / 30,0) AS Quantity,MIN(COALESCE(opt.ResellerCost,pt2.Cost)) AS Amount, 0 AS QuantityType, MIN(pt2.TaxGroupID) AS TaxGroupID, MIN(pt2.TaxExemptions) AS TaxExemptions,DATEADD(mm,-(DATEPART(mm,getdate())-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,getdate())-ru.StartYear),getdate())) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID = @CustomerID)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN Packages p2 ON (ma2.CustomerID = p2.CustomerID)
	JOIN ResellerPkgUsage ru ON (p2.PackageID = ru.PackageID)
	JOIN PackageTypes pt2 ON (ru.PackageTypeID = pt2.PackageTypeID)
	LEFT JOIN OrgPackageTypes opt ON (o.OrganizationID = opt.OrganizationID AND pt2.PackageTypeID = opt.PackageTypeID)
	WHERE ma.CustomerID = @CustomerID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,getdate()) > ru.StartYear) 
		OR (DATEPART(yy,getdate()) = ru.StartYear AND (DATEPART(mm,getdate())-1 > ru.StartMonth OR (DATEPART(mm,getdate()) > ru.StartMonth))))
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 0
GROUP BY ru.StartYear,ru.StartMonth,ru.PackageTypeID
GO

CREATE PROCEDURE dbo.InvoiceItemAdd (@InvoiceID INT, @BillStatus INT, @ItemType INT, @Days INT, @Quantity INT, @Amount NUMERIC(18,4), @Login VARCHAR(64), @Description VARCHAR(128), @StartDate DATETIME, @EndDate DATETIME, @AccountID INT, @AccountTypeID INT, @PackageID INT, @PackageTypeID INT, @ChargeID INT, @ChargeTypeID INT, @CycleMonths INT, @TaxID INT, @TaxGroupID INT, @ParentItemID INT) AS
SET NOCOUNT ON
INSERT INTO InvoiceItems (InvoiceID,BillStatus,ItemType,Days,Quantity,Amount,Login,Description,StartDate,EndDate,AccountID,AccountTypeID,PackageID,PackageTypeID,ChargeID,ChargeTypeID,CycleMonths,TaxID,TaxGroupID,ParentItemID)
VALUES(@InvoiceID, @BillStatus, @ItemType, @Days, @Quantity, @Amount, @Login, @Description, @StartDate, @EndDate, @AccountID, @AccountTypeID, @PackageID, @PackageTypeID, @ChargeID, @ChargeTypeID, @CycleMonths, @TaxID, @TaxGroupID, @ParentItemID)

SELECT @@IDENTITY AS ItemID
GO

CREATE PROCEDURE dbo.InvoiceItemPaid (@ItemID INT) AS
SET NOCOUNT ON
DECLARE @TimeChargeID INT, @AutoBill INT, @CustomerID INT, @AccountID INT, @PackageID INT, @Quantity INT, @Months INT, @Days INT, @Minutes INT, @TimeLeft INT, @DataLeft BIGINT, @PaidFlag INT, @trackmode INT

SELECT @AutoBill = MAX(bc.AutoBill), @TimeChargeID = MAX(tc.TimeChargeID), @CustomerID = MAX(sa.CustomerID), @AccountID = MAX(sa.AccountID), @Quantity = MAX(ii.Quantity), @Months = MAX(tc.Months * ii.Quantity), @Days = MAX(tc.Days * ii.Quantity), @Minutes = MAX(tc.Minutes * ii.Quantity), @TimeLeft = MAX(tc.TimeLeft * ii.Quantity), @DataLeft = MAX(tc.DataLeft * ii.Quantity), @PaidFlag = MAX(ii.PaidFlag)
FROM InvoiceItems ii, Invoices i, TimeCharges tc, SubAccounts sa, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID = ii.InvoiceID
	AND tc.ChargeTypeID = ii.ChargeTypeID
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.AccountID = sa.AccountID
	AND ii.ItemID = @ItemID
	AND sa.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sa.Active = 1

IF (@TimeChargeID IS NULL)
BEGIN
SELECT @AutoBill = MAX(bc.AutoBill), @TimeChargeID = MAX(tc.TimeChargeID), @CustomerID = MAX(p.CustomerID), @PackageID = MAX(p.PackageID), @Quantity = MAX(ii.Quantity), @Months = MAX(tc.Months * ii.Quantity), @Days = MAX(tc.Days * ii.Quantity), @Minutes = MAX(tc.Minutes * ii.Quantity), @TimeLeft = MAX(tc.TimeLeft * ii.Quantity), @DataLeft = MAX(tc.DataLeft * ii.Quantity), @PaidFlag = MAX(ii.PaidFlag)
FROM InvoiceItems ii, Invoices i, TimeCharges tc, Packages p, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID = ii.InvoiceID
	AND tc.ChargeTypeID = ii.ChargeTypeID
	AND p.PackageTypeID = tc.PackageTypeID
	AND ii.PackageID = p.PackageID
	AND ii.ItemID = @ItemID
	AND p.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND p.Active = 1
END

SELECT @trackmode = NumValue FROM Configs WHERE ConfigID = 535
SELECT @trackmode = COALESCE(MAX(cgd.NumValue),@trackmode)
FROM ConfigGroupData cgd, MasterAccounts ma
	WHERE ma.CustomerID = @CustomerID
	AND ma.GroupID = cgd.GroupID
	AND cgd.ConfigID = 535

IF (@TimeChargeID IS NOT NULL AND @PaidFlag = 0 AND @Quantity > 0 AND @AccountID IS NOT NULL)
BEGIN

IF (@trackmode = 2 AND (@TimeLeft > 0 OR @DataLeft > 0))
	BEGIN	
	INSERT INTO SubAccountUsages (AccountID,ItemID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT @AccountID,@ItemID,@TimeLeft,@DataLeft,@TimeLeft,@DataLeft, CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN DATEADD(yy,2,getdate()) ELSE DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),getdate()))) END
	FROM SubAccounts
		WHERE AccountID = @AccountID
	END

UPDATE SubAccounts SET 
	BilledThru = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < getdate() THEN getdate() ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN ExpireDate WHEN ExpireDate < getdate() THEN getdate() ELSE ExpireDate END))) ELSE ExpireDate END,
	TimeLeft = CASE WHEN @TimeLeft IS NULL OR TimeLeft IS NULL OR @trackmode = 2 THEN TimeLeft WHEN @AutoBill = 2 AND ExpireDate < getdate() THEN @TimeLeft WHEN TimeLeft >= 0 THEN TimeLeft + @TimeLeft ELSE @TimeLeft END,
	DataLeft = CASE WHEN @DataLeft IS NULL OR DataLeft IS NULL OR @trackmode = 2 THEN DataLeft WHEN @AutoBill = 2 AND ExpireDate < getdate() THEN @DataLeft WHEN DataLeft >= 0 THEN DataLeft + @DataLeft ELSE @DataLeft END
	WHERE AccountID=@AccountID

UPDATE InvoiceItems SET PaidFlag = 1 WHERE ItemID = @ItemID
END

IF (@TimeChargeID IS NOT NULL AND @PaidFlag = 0 AND @Quantity > 0 AND @PackageID IS NOT NULL)
BEGIN

IF (@trackmode = 2 AND (@TimeLeft > 0 OR @DataLeft > 0))
	BEGIN
	INSERT INTO SubAccountUsages (AccountID,ItemID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT AccountID,@ItemID,@TimeLeft,@DataLeft,@TimeLeft,@DataLeft, CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN DATEADD(yy,2,getdate()) ELSE DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),getdate()))) END
	FROM SubAccounts
		WHERE PackageID = @PackageID
		AND Active = 1
	END

UPDATE Packages SET 
	BilledThru = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < getdate() THEN getdate() ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN ExpireDate WHEN ExpireDate < getdate() THEN getdate() ELSE ExpireDate END))) ELSE ExpireDate END
	WHERE PackageID=@PackageID

UPDATE SubAccounts SET 
	BilledThru = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < getdate() THEN getdate() ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN @AutoBill = 2 THEN DATEADD(mi,COALESCE(@Minutes,0),DATEADD(mm,COALESCE(@Months,0),DATEADD(dd,COALESCE(@Days,0),CASE WHEN @Months IS NULL AND @Days IS NULL AND @Minutes IS NULL THEN ExpireDate WHEN ExpireDate < getdate() THEN getdate() ELSE ExpireDate END))) ELSE ExpireDate END,
	TimeLeft = CASE WHEN @TimeLeft IS NULL OR TimeLeft IS NULL OR @trackmode = 2 THEN TimeLeft WHEN @AutoBill = 2 AND ExpireDate < getdate() THEN @TimeLeft WHEN TimeLeft >= 0 THEN TimeLeft + @TimeLeft ELSE @TimeLeft END,
	DataLeft = CASE WHEN @DataLeft IS NULL OR DataLeft IS NULL OR @trackmode = 2 THEN DataLeft WHEN @AutoBill = 2 AND ExpireDate < getdate() THEN @DataLeft WHEN DataLeft >= 0 THEN DataLeft + @DataLeft ELSE @DataLeft END
	WHERE PackageID=@PackageID
	AND Active=1

UPDATE InvoiceItems SET PaidFlag = 1 WHERE ItemID = @ItemID
END
GO

CREATE PROCEDURE dbo.InvoiceVoidCheck (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @CheckOrder INT
SELECT @CheckOrder = NumValue FROM Configs WHERE ConfigID = 644
SELECT CASE WHEN MIN(COALESCE(cgd.NumValue,@CheckOrder,1)) = 1 THEN MIN(i2.InvoiceID) ELSE NULL END AS InvoiceID
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Invoices i2 ON (i2.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii2 ON (i2.InvoiceID = ii2.InvoiceID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 644)
	WHERE i.InvoiceID = @InvoiceID
	AND ii.ItemType = 3
	AND ii.Canceled = 0
	AND ii2.Canceled = 0
	AND ii2.ItemType = 3
	AND (ii.AccountID = ii2.AccountID OR ii.PackageID = ii2.PackageID)
	AND i2.VoidDate IS NULL
	AND ii2.StartDate >= ii.StartDate
	AND ii2.InvoiceID <> @InvoiceID
GROUP BY ma.GroupID
GO

CREATE PROCEDURE dbo.InvoiceVoidDupeCharges (@InvoiceID INT) AS
SET NOCOUNT ON
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,PackageID,Login,AccountTypeID,PackageTypeID,Prorated,Amount,Quantity,TaxGroupID,ChargeTypeID,ItemID,Operator,LastModifyDate,LastModifyUser,PrevChargeID)
SELECT c.CustomerID,c.Description,c.StartDate,c.EndDate,c.AccountID,c.PackageID,c.Login,c.AccountTypeID,c.PackageTypeID,c.Prorated,c.Amount,c.Quantity,c.TaxGroupID,c.ChargeTypeID,NULL AS ItemID,c.Operator,c.LastModifyDate,c.LastModifyUser,c.ChargeID
FROM Charges c, InvoiceItems ii
	WHERE c.ItemID = ii.ItemID
	AND ii.InvoiceID = @InvoiceID

UPDATE VoiceCalls SET ChargeID = c.ChargeID
FROM VoiceCalls vc, Invoices i, Charges c
	WHERE i.InvoiceID = @InvoiceID
	AND i.CustomerID = c.CustomerID
	AND c.ItemID IS NULL
	AND c.PrevChargeID IS NOT NULL
	AND vc.ChargeID = c.PrevChargeID


UPDATE ResellerUsage SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
UPDATE ResellerPkgUsage SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)
GO

CREATE PROCEDURE dbo.InvoiceVoidSAUpdate (@InvoiceID INT) AS
SET NOCOUNT ON
DECLARE @counter INT

CREATE TABLE #ivsau (PackageID INT, AutoBill INT, ExpireDate DATETIME, BilledThru DATETIME, PackageTypeID INT, CycleMonths INT, BillStatus INT)

SELECT @counter = 1

UPDATE Charges SET DistFlag = 1 WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE Amount < 0 AND Quantity > 0 AND InvoiceID = @InvoiceID)

UPDATE SubAccounts SET TimeLeft = TimeLeft - COALESCE((SELECT SUM(sau.StartTimeLeft - CASE WHEN sau.TimeLeft < 0 THEN 0 ELSE sau.TimeLeft END)
	FROM SubAccountUsages sau, InvoiceItems ii 
		WHERE sau.ItemID = ii.ItemID
		AND sau.StartTimeLeft IS NOT NULL
		AND sau.AccountID = SubAccounts.AccountID
		AND ii.InvoiceID = @InvoiceID),0),
	DataLeft = DataLeft - COALESCE((SELECT SUM(sau.StartDataLeft - CASE WHEN sau.DataLeft < 0 THEN 0 ELSE sau.DataLeft END)
	FROM SubAccountUsages sau, InvoiceItems ii 
		WHERE sau.ItemID = ii.ItemID
		AND sau.StartDataLeft IS NOT NULL
		AND sau.AccountID = SubAccounts.AccountID
		AND ii.InvoiceID = @InvoiceID),0)

	WHERE Active = 1
	AND (TimeLeft IS NOT NULL OR DataLeft IS NOT NULL)
	AND AccountID IN (SELECT DISTINCT AccountID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)

DELETE FROM SubAccountUsages WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID = @InvoiceID)

WHILE(@counter > 0)
BEGIN

INSERT INTO #ivsau (PackageID, AutoBill, ExpireDate, BilledThru, PackageTypeID, CycleMonths, BillStatus)
SELECT p.PackageID, bc.AutoBill,
CASE WHEN bc.AutoBill = 1 THEN NULL WHEN ii.ItemType = 2 AND ExpireDate > ii.StartDate THEN DATEADD(dd,-1,ii.StartDate) WHEN ii.ItemType = 3 AND DATEADD(dd,1,ii.StartDate) > getdate() AND ExpireDate > ii.StartDate THEN DATEADD(dd,CASE WHEN ii.StartDate > getdate() THEN -1 ELSE 0 END,ii.StartDate) ELSE ExpireDate END AS ExpireDate,
DATEADD(dd,-1,ii.StartDate) AS BilledThru,
COALESCE((SELECT pt2.PackageTypeID FROM PackageTypes pt2 WHERE pt2.PackageTypeID=ii.PackageTypeID AND NextCount IS NOT NULL AND NextID IS NOT NULL),p.PackageTypeID) AS PackageTypeID,
COALESCE(ii.CycleMonths, p.CycleMonths) AS CycleMonths, ii.BillStatus
FROM Packages p, MasterAccounts ma, Invoices i, InvoiceItems ii, BillingCycles bc
	WHERE ma.CustomerID = p.CustomerID
	AND ma.CustomerID = i.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NOT NULL
	AND p.BilledThru = ii.EndDate
	AND ii.AccountID IS NULL
	AND ii.ItemType IN (2,3)
	AND ii.PackageID = p.PackageID
	AND ma.Active = 1
	AND p.Active = 1
	AND i.InvoiceID = @InvoiceID

SELECT @counter = COUNT(*) FROM #ivsau

IF (@counter > 0)
BEGIN
UPDATE Packages SET ExpireDate = iv.ExpireDate, BilledThru = iv.BilledThru, PackageTypeID = iv.PackageTypeID, CycleMonths = iv.CycleMonths, BillStatus = iv.BillStatus
FROM Packages p, #ivsau iv
	WHERE p.PackageID = iv.PackageID

UPDATE SubAccounts SET ExpireDate = iv.ExpireDate, BilledThru = iv.BilledThru
FROM SubAccounts sa, #ivsau iv
	WHERE sa.PackageID = iv.PackageID
	AND sa.Active = 1
	AND iv.AutoBill <> 2

DELETE FROM #ivsau
END

UPDATE SubAccounts SET ExpireDate = CASE WHEN bc.AutoBill = 1 THEN NULL WHEN ii.ItemType = 2 AND ExpireDate > ii.StartDate THEN DATEADD(dd,-1,ii.StartDate) WHEN ii.ItemType = 3 AND DATEADD(dd,1,ii.StartDate) > getdate() AND ExpireDate > ii.StartDate THEN DATEADD(dd,CASE WHEN ii.StartDate > getdate() THEN -1 ELSE 0 END,ii.StartDate) ELSE ExpireDate END,
	BilledThru = DATEADD(dd,-1,ii.StartDate), 
	AccountTypeID = COALESCE((SELECT at2.AccountTypeID FROM AccountTypes at2 WHERE at2.AccountTypeID=ii.AccountTypeID AND NextCount IS NOT NULL AND NextID IS NOT NULL),sa.AccountTypeID), 
	CycleMonths = COALESCE(ii.CycleMonths, sa.CycleMonths), 
	BillStatus = ii.BillStatus
FROM SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.CustomerID = ma.CustomerID
	AND i.VoidDate IS NOT NULL
	AND i.InvoiceID = ii.InvoiceID
	AND sa.BilledThru = ii.EndDate
	AND sa.AccountID = ii.AccountID
	AND ii.ItemType IN (2,3)
	AND ii.StartDate <= ii.EndDate
	AND ma.Active = 1
	AND sa.Active = 1
	AND i.InvoiceID = @InvoiceID

SELECT @counter = @counter + @@ROWCOUNT
END

SELECT CustomerID,InvoiceTypeID 
FROM Invoices 
	WHERE InvoiceID = @InvoiceID

DROP TABLE #ivsau
GO

CREATE PROCEDURE dbo.LDAPrfc822mailbox (@accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain END AS mail
FROM SubAccounts sa, Domains d
	WHERE sa.DomainID = d.DomainID
	AND sa.AccountID = @accountid
UNION
SELECT Alias as mail FROM Aliases WHERE AccountID = @accountid AND Alias LIKE '%_@_%'

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.LDAPmailAlternateAddress (@accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Alias as mail 
FROM Aliases 
	WHERE AccountID = @accountid

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.LDAPmailForwardingAddress (@accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Forward 
FROM Forwards 
	WHERE AccountID = @accountid

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.LDAPSetLastModifyDate (@type VARCHAR(10), @id VARCHAR(50)) AS
SET NOCOUNT ON
IF (@type = 'read')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncRead = getdate(), Calls = Calls + 1 WHERE LDAPServer = @id
IF (@@rowcount = 0)
	BEGIN
	INSERT INTO LDAPServers (LDAPServer,LastSyncWrite,LastModifyDate,LastSyncRead,Calls) VALUES(@id,DATEADD(yy,-20,getdate()),getdate(),getdate(),1)
	END
END

IF (@type = 'write')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncWrite = COALESCE(LastSyncRead,getdate()), Calls = Calls + 1 WHERE LDAPServer = @id
IF (@@rowcount = 0)
	BEGIN
	INSERT INTO LDAPServers (LDAPServer,LastModifyDate,LastSyncWrite,Calls) VALUES(@id,getdate(),getdate(),1)
	END
END

IF (@type = 'reset')
BEGIN
UPDATE LDAPServers SET LastSyncWrite = DATEADD(yy,-20,getdate()) WHERE LDAPServer = @id
END

GO

CREATE PROCEDURE dbo.ListDomainUsers (@domain varchar(64), @esid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @DomainID INT
SELECT @DomainID = MAX(DomainID) FROM Domains WHERE MailDomain = @domain
IF (@DomainID IS NOT NULL)
BEGIN
SELECT COALESCE(sa.Login,SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)) AS Username
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystemAccountTypes esat
WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login IS NOT NULL AND sa.DomainID = @DomainID) OR (sa.Login IS NULL AND sa.Email LIKE '%_@' + @domain))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @esid
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO


CREATE PROCEDURE dbo.ListMailUsers (@esid integer) AS
SELECT Login, Login AS Shell, sa.Email, d.MailDomain, Password, sad.Data as HomeDir 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID = @esid
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

UNION ALL

SELECT Login, Login AS Shell, a.Alias AS Email, d.MailDomain, Password, sad.Data AS HomeDir
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID = @esid
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()
GO

CREATE PROCEDURE dbo.MapGetAttributes AS
SELECT MapAttribute, RadAttributeID,RadVendorID,RadMapTypeID
FROM RadMapAttributes
GO

CREATE PROCEDURE dbo.MapGetValues AS
SELECT MapAttribute,MapValue,RadValue,RadMapTypeID
FROM RadMapValues
ORDER BY MapAttribute,RadMapTypeID
GO
CREATE PROCEDURE dbo.MBRAddresses (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT c.Country, s.State, a.Email, a.AddressID, at2.AddressType, Address1, Address2, City, Zip, FirstName, LastName, Phone
FROM Addresses a JOIN AddressTypes at2 ON (a.AddressTypeID=at2.AddressTypeID)
	LEFT JOIN Countries c ON (a.CountryID=c.CountryID)
	LEFT JOIN States s ON (a.StateID=s.StateID)
	WHERE a.CustomerID=@CustomerID
ORDER BY at2.SortOrder
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

GO

CREATE PROCEDURE dbo.MBRAging (@CustomerID INT) AS
SET NOCOUNT ON
SELECT ma.CustomerID, End0Bal AS Balance0,
	CASE WHEN End30Bal > 0 THEN End30Bal ELSE 0 END AS Balance30,
	CASE WHEN End60Bal > 0 THEN End60Bal ELSE 0 END AS Balance60,
	CASE WHEN End90Bal > 0 THEN End90Bal ELSE 0 END AS Balance90,
	CASE WHEN End120Bal > 0 THEN End120Bal ELSE 0 END AS Balance120,
	ma.Over30Count, ma.Over60Count, ma.Over90Count, ma.Over120Count, s.StatementDate AS AgedDate
FROM MasterAccounts ma, Statements s
	WHERE ma.LastStatementID = s.StatementID
	AND ma.CustomerID = @CustomerID
GO

CREATE PROCEDURE dbo.MBRCCLoad (@CustomerID INT) AS
SET NOCOUNT ON
SELECT cc.CardNumber, DatePart(yy, cc.ExpirationDate) as ExpireYear, 
CASE WHEN DatePart(mm, cc.ExpirationDate) < 10 THEN '0' + CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR(5)) ELSE CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR(5)) END as ExpireMonth, 
cc.CardHolder, cc.BillToAddress1, cc.BillToAddress2, cc.BillToCity AS City, cc.BillToStateID AS StateID, COALESCE(cc.BillToCountryID,ma.CountryID) AS CountryID, cc.BillToZip, cc.SecurityCode, cc.Bank, cc.BankPhone
FROM MasterAccounts ma, CreditCards cc
	WHERE ma.CustomerID = cc.CustomerID
	AND ma.CustomerID=@CustomerID
UNION ALL
SELECT NULL, NULL, NULL, ma.FirstName + ' ' + ma.LastName, ma.Address1, ma.Address2, ma.City, ma.StateID, COALESCE(ma.CountryID,g.BillCountryID), ma.Zip, NULL, NULL, NULL 
FROM MasterAccounts ma, Groups g
	WHERE ma.CustomerID=@CustomerID
	AND ma.GroupID = g.GroupID
GO

CREATE PROCEDURE dbo.MBRCloseVoidList (@CustomerID INT, @CancelDate DATETIME) AS
SET NOCOUNT ON

SELECT i.InvoiceID
FROM MasterAccounts ma, SubAccounts sa, Invoices i, AccountTypes at1, InvoiceItems ii, PayPeriods pp
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CustomerID = @CustomerID
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.Amount > 0
	AND ii.StartDate <> ii.EndDate
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND ii.AccountID = sa.AccountID
	AND ii.AccountTypeID = at1.AccountTypeID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND ((at1.ChangeClose = 1 AND ii.EndDate > @CancelDate)
		OR (pp.PeriodTypeID = 1 AND at1.ChangeClose = 2 AND DATEADD(mm,-1,ii.EndDate) > @CancelDate)
		OR (pp.PeriodTypeID = 2 AND at1.ChangeClose = 2 AND ii.EndDate > @CancelDate)
		OR (pp.PeriodTypeID IN (1,2) AND ii.StartDate > @CancelDate))
UNION
SELECT i.InvoiceID
FROM MasterAccounts ma, Packages p, Invoices i, PackageTypes pt, InvoiceItems ii, PayPeriods pp
	WHERE ma.CustomerID = p.CustomerID
	AND ma.Active = 1
	AND p.Active = 1
	AND ma.CustomerID = @CustomerID
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.Amount > 0
	AND ii.StartDate <> ii.EndDate
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND ii.PackageID = p.PackageID
	AND ii.PackageTypeID = pt.PackageTypeID
	AND p.PayPeriodID = pp.PayPeriodID
	AND ((pt.ChangeClose = 1 AND ii.EndDate > @CancelDate)
		OR (pp.PeriodTypeID = 1 AND pt.ChangeClose = 2 AND DATEADD(mm,-1,ii.EndDate) > @CancelDate)
		OR (pp.PeriodTypeID = 2 AND pt.ChangeClose = 2 AND ii.EndDate > @CancelDate)
		OR (pp.PeriodTypeID IN (1,2) AND ii.StartDate > @CancelDate))

ORDER BY 1 DESC
GO

CREATE PROCEDURE dbo.MBRCurrentBalance (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @iTotal NUMERIC(18,4), @cTotal NUMERIC(18,4), @pTotal NUMERIC(18,4)

IF (@CustomerID IS NULL)
BEGIN
UPDATE ma SET PendingBalance = ma.Balance + COALESCE(ai.Amount,0) + COALESCE(ac.Amount,0) + COALESCE(ap.Amount,0)
FROM MasterAccounts ma
	LEFT JOIN
		(
		SELECT CustomerID, SUM(CASE WHEN StatementID IS NULL THEN Amount ELSE -Amount END) AS Amount
		FROM Invoices 
			WHERE Processed = 1
			AND ((StatementID IS NULL AND VoidDate IS NULL) OR (StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL))
		GROUP BY CustomerID
		) ai ON (ma.CustomerID = ai.CustomerID)
	LEFT JOIN
		(
		SELECT CustomerID, SUM(ROUND(Amount * Quantity,2)) AS Amount
		FROM Charges 
			WHERE ItemID IS NULL
		GROUP BY CustomerID
		) ac ON (ma.CustomerID = ac.CustomerID)
	LEFT JOIN
		(
		SELECT CustomerID, -SUM(CASE WHEN StatementID IS NULL THEN COALESCE(FinalAmount,Amount) ELSE FinalAmount - Amount END) AS Amount
		FROM Payments
			WHERE (StatementID IS NULL OR (StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL))
		GROUP BY CustomerID
		) ap ON (ma.CustomerID = ap.CustomerID)
	WHERE ma.Active = 1
END

IF (@CustomerID IS NOT NULL)
BEGIN
SELECT @iTotal = SUM(CASE WHEN StatementID IS NULL THEN Amount ELSE -Amount END)
FROM Invoices
	WHERE CustomerID = @CustomerID
	AND Processed = 1
	AND ((StatementID IS NULL AND VoidDate IS NULL) OR (StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL))

SELECT @cTotal = SUM(ROUND(Amount * Quantity,2))
FROM Charges
	WHERE CustomerID = @CustomerID
	AND ItemID IS NULL

SELECT @pTotal = -SUM(CASE WHEN StatementID IS NULL THEN COALESCE(FinalAmount,Amount) ELSE FinalAmount - Amount END)
FROM Payments
	WHERE CustomerID = @CustomerID
	AND (StatementID IS NULL OR (StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL))

UPDATE MasterAccounts SET PendingBalance = Balance + COALESCE(@iTotal,0) + COALESCE(@cTotal,0) + COALESCE(@pTotal,0)
	WHERE CustomerID = @CustomerID
	AND Active IN (1,0)
END
GO

CREATE PROCEDURE dbo.MBRCustom (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT adt.AccountDataType, COALESCE(adv.ValueData,mad.Data) AS Data
FROM MasterAccountData mad JOIN AccountDataTypes adt ON (mad.AccountDataTypeID=adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (mad.AccountDataTypeID=adv.AccountDataTypeID AND mad.Data=adv.KeyData)
	WHERE mad.Data IS NOT NULL
	AND mad.CustomerID=@CustomerID
	AND adt.AllowMBR = 1
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBRDefaultEmail (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @Email VARCHAR(64)

SELECT @Email = MAX(Email) FROM SubAccounts WHERE CustomerID=@CustomerID AND Active=1 AND Email IS NOT NULL AND SendBill=1 AND Email LIKE '%@%'

IF (@Email IS NULL)
BEGIN
SELECT @Email = MAX(Email) FROM MasterAccounts WHERE CustomerID=@CustomerID
END

IF (@Email IS NULL)
BEGIN
SELECT @Email = sa.Login + '@' + d.MailDomain
FROM SubAccounts sa, Domains d 
	WHERE sa.CustomerID = @CustomerID
	AND sa.DomainID = d.DomainID
	AND sa.Active = 1
	AND sa.SendBill = 1
	AND sa.Email IS NULL
	AND sa.Login IS NOT NULL
END

SELECT @Email AS Email, sm.EmailTypeID, g.EmailSubject
FROM MasterAccounts ma, SendMethods sm, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID = @CustomerID
	AND ma.GroupID = g.GroupID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBRDetail (@CustomerID INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT ma.CustomerID, FirstName, LastName, Company, Address1, Address2, City, COALESCE(s.Abbreviation,s.State) AS State, Zip, sp.SalesPerson,
LastReceived, PayInfo, PhoneHome, PhoneFax, PhoneWork, rb.ReferredBy, Operator,
ma.StartDate, CancelDate AS EndDate,cr.CancelReason, cr.StringID AS CancelReasonStringID, pt.PaymentType, Region, GroupName, 
ma.Active, ma.PayPeriodID, pp.PayPeriod,
CASE WHEN ma.Active = 0 THEN 0 WHEN ma.CancelDate IS NOT NULL THEN 2 ELSE 1 END AS MBRStatus, ma.Status,
Comments, bc.Description, ma.TaxExemptions, 
CreateDate, ma.Email,
ma.PendingBalance AS CurrentBalance, 
ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS RealtimeBalance,
COALESCE(OverDue, 0) AS OverDue, COALESCE(LastStatementID,0) As LastStatementID, LastModifyUser, LastModifyDate, st.EndBal,ma.OverLimit

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
	LEFT JOIN SalesPersons sp ON (ma.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Statements st ON (ma.LastStatementID = st.StatementID)
WHERE ma.CustomerID = @CustomerID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBRGetCustomFields (@GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT COALESCE(madt.Required,0) AS Required, adt.RegExp, adt.StringID, adt.AccountDataType,adt.AccountDataTypeID,adt.DataTypeID
FROM MasterAccountDataTypes madt, AccountDataTypes adt
	WHERE adt.AccountDataTypeID=madt.AccountDataTypeID
	AND adt.AllowMBR=1
	AND (madt.GroupID IS NULL OR madt.GroupID = @GroupID OR madt.ServiceGroupID IN (SELECT ServiceGroupID FROM ServiceGroupItems WHERE GroupID = @GroupID))
ORDER BY madt.SortOrder, adt.AccountDataType
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBRGroupID (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT ma.Active, CASE WHEN ma.CancelDate IS NULL AND ma.Active = 1 THEN 1 ELSE 0 END AS IsOpen, 
ma.PaymentTypeID, ma.CustomerID, ma.GroupID, g.OrganizationID, ma.FirstName, ma.LastName, ma.Company, ma.PendingBalance AS Balance
FROM MasterAccounts ma, Groups g
	WHERE ma.CustomerID = @CustomerID
	AND ma.GroupID = g.GroupID
	AND ma.Active IN (1,0)
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBROpenChkMax (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @MaxAccounts INT, @GroupID INT

SELECT @MaxAccounts = o.MaxAccounts, @GroupID = ma.GroupID
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE ma.CustomerID = @CustomerID

IF (@MaxAccounts IS NOT NULL)
BEGIN
SELECT @MaxAccounts - COUNT(*) AS CountLeft
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE ma.Active = 1
	AND ma.GroupID = @GroupID
	AND (bc.AutoBill IN (0,1) OR EXISTS ((SELECT * FROM SubAccounts sa
			LEFT JOIN (SELECT AccountID, SUM(TimeLeft) AS TimeLeft, SUM(DataLeft) AS DataLeft FROM SubAccountUsages WHERE ExpireDate > getdate() GROUP BY AccountID) sau ON (sa.AccountID = sau.AccountID)
			WHERE sa.CustomerID = ma.CustomerID
			AND sa.Active = 1 
			AND (sa.ExpireDate IS NULL OR sa.ExpireDate > getdate())
			AND (sa.TimeLeft IS NULL OR sa.TimeLeft + COALESCE(sau.TimeLeft,0) > 0)
			AND (sa.DataLeft IS NULL OR sa.DataLeft + COALESCE(sau.DataLeft,0) > 0))))
END ELSE BEGIN
SELECT NULL AS CountLeft
END
GO

CREATE PROCEDURE dbo.MBROpenList (@CustomerID INT) AS
SET NOCOUNT ON
SELECT NULL AS PackageID, sa.AccountID, ma.GroupID, CASE WHEN at1.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS AllowSetupCharge, CASE WHEN pp.SetupCharge = 1 THEN 1 ELSE 0 END AS DefaultSetupCharge
FROM MasterAccounts ma, SubAccounts sa, PayPeriods pp, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND ma.CustomerID = @CustomerID
	AND sa.Active = 1
	AND PackageID IS NULL
UNION ALL
SELECT p.PackageID, NULL AS AccountID, ma.GroupID, CASE WHEN pt.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS AllowSetupCharge, CASE WHEN pp.SetupCharge = 1 THEN 1 ELSE 0 END AS DefaultSetupCharge
FROM MasterAccounts ma, Packages p, PayPeriods pp, PackageTypes pt
	WHERE ma.CustomerID = p.CustomerID
	AND ma.CustomerID = @CustomerID
	AND p.PackageTypeID = pt.PackageTypeID
	AND p.PayPeriodID = pp.PayPeriodID
	AND p.Active = 1
GO

CREATE PROCEDURE dbo.MenuList (@Menu VARCHAR(128)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi.Access, mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.HelpStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu = @Menu
ORDER BY ms.SortOrder ASC
GO

CREATE PROCEDURE dbo.MenuListAT (@menu VARCHAR(32), @AccountTypeID INT, @gid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT ms.SortOrder, mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi.Access, mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.HelpStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu = @menu
	AND (ms.GroupID IS NULL OR ms.GroupID = @gid)
UNION ALL
SELECT 0, NULL, NULL, act.CustEdit, 'read', NULL, NULL, 'svctemplate', act.CustEditLabel, act.CustEditStringID, NULL, NULL, act.CustEdit, NULL, m.Class
FROM AccountTypes at1, AccountTemplates act, Menus m
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID = @AccountTypeID
	AND act.CustEdit IS NOT NULL
	AND m.Menu = @menu
	AND @menu = 'custsaset'
UNION ALL
SELECT 0, NULL, NULL, act.SADetail, 'read', NULL, NULL, 'svctemplate', act.AccountTemplate, NULL, NULL, NULL, act.SADetail, NULL, m.Class
FROM AccountTypes at1, AccountTemplates act, Menus m
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID = @AccountTypeID
	AND act.SADetail IS NOT NULL
	AND m.Menu = @menu
	AND @menu = 'sadetail'
ORDER BY 1 ASC

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MetaFormCheck (@TableName VARCHAR(64))  AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT mt.MetaTableID, mc.MetaColumnID, mc.ColumnName, mc.Description, CASE WHEN mc.IsKey = 0 AND mc.Quoted = 0 AND mc.Nullable = 0 THEN 1 ELSE mc.Required END AS Required, mc.MinSize, mc.MaxSize, mc.MetaRuleID, mc.Quoted, mc.StringID, mc.RegExp
FROM MetaTables mt, MetaColumns mc
	WHERE mt.MetaTableID = mc.MetaTableID
	AND mt.TableName = @TableName

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MetaGetGroupID (@metatableid INT, @data INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @table VARCHAR(40), @prevtable VARCHAR(40), @column VARCHAR(40), @prevcolumn VARCHAR(40)
DECLARE @txtdata VARCHAR(15), @grouptable VARCHAR(40)

SELECT @grouptable = GroupTable FROM MetaTables WHERE MetaTableID = @metatableid
SELECT @column = ColumnName FROM MetaColumns mc, MetaTables mt WHERE mt.MetaTableID = mc.MetaTableID AND mt.TableName = @grouptable AND mc.IsKey = 1 AND mc.Quoted = 0
SELECT @table = @grouptable
SELECT @txtdata = CAST(@data AS VARCHAR(15))
IF (@column IS NOT NULL)
BEGIN
CREATE TABLE #mggtmp (Data INT NULL)
WHILE(@grouptable IS NOT NULL)
	BEGIN
	SELECT @prevcolumn = @column, @prevtable = @table
	SELECT @grouptable = GroupTable FROM MetaTables WHERE TableName = @grouptable
	IF (@grouptable IS NOT NULL)
		BEGIN
		SELECT @table = @grouptable
		SELECT @column = ColumnName FROM MetaColumns mc, MetaTables mt WHERE mt.MetaTableID = mc.MetaTableID AND mt.TableName = @grouptable AND mc.IsKey = 1 AND mc.Quoted = 0
		DELETE FROM #mggtmp
		EXEC('INSERT INTO #mggtmp (Data) SELECT ' + @column + ' FROM ' + @prevtable + ' WHERE ' + @prevcolumn + ' = ' + @txtdata)
		SELECT @txtdata = 'NULL'
		SELECT @txtdata = CAST(Data AS VARCHAR(15)) FROM #mggtmp
		END
	END
DELETE FROM #mggtmp
EXEC('INSERT INTO #mggtmp (Data) SELECT GroupID FROM ' + @table + ' WHERE ' + @column + ' = ' + @txtdata)
SELECT DISTINCT Data AS GroupID FROM #mggtmp
DROP TABLE #mggtmp
END
ELSE
BEGIN
SELECT NULL AS GroupID
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MetaGetTable (@metatableid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT MetaColumnID,ColumnName,Quoted,DepTable,DepColumn,MetaRuleID,Required,Nullable,MinSize,MaxSize,IsKey,Description,RegExp,CheckQuery
FROM MetaColumns
	WHERE MetaTableID = @metatableid
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MetaGetTableInfo (@table VARCHAR(40)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT mt.MetaTableID, mt.GroupTable, mc2.ColumnName AS GroupColumn
FROM MetaTables mt LEFT JOIN MetaTables mt2 ON (mt.GroupTable = mt2.TableName)
	LEFT JOIN MetaColumns mc2 ON (mt2.MetaTableID = mc2.MetaTableID AND mc2.IsKey = 1)
	WHERE mt.TableName = @table
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.NoticeMailList (@OperatorID INT, @CustomerID INT, @AccountID INT, @CheckSendBill INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT o.LanguageID, o.PrintTypeID AS EmailTypeID, COALESCE(g.EmailAccounts,g2.EmailAccounts) AS EmailAccounts, COALESCE(g.EmailSubject,g2.EmailSubject) AS EmailSubject, o.Operator AS FirstName, NULL AS LastName, NULL AS Login, o.Email, NULL AS MailDomain
FROM Operators o LEFT JOIN MasterAccounts ma ON (ma.CustomerID = @CustomerID)
	LEFT JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Groups g2 ON (g2.GroupID = 1)
	WHERE o.Active = 1
	AND o.Email IS NOT NULL
	AND o.OperatorID = @OperatorID

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, sa.FirstName, sa.LastName, sa.Login, sa.Email, d.MailDomain 
FROM SendMethods sm, SubAccounts sa, Domains d, Groups g, MasterAccounts ma
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND sa.Active = 1
	AND sa.AccountID = @AccountID

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, sa.FirstName, sa.LastName, sa.Login, sa.Email, d.MailDomain 
FROM SendMethods sm, SubAccounts sa, Domains d, Groups g, MasterAccounts ma
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND ma.CustomerID = @CustomerID
	AND sa.Active = 1
	AND (@CheckSendBill = 0 OR sa.SendBill = 1)

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, ma.FirstName, ma.LastName, NULL AS Login, ma.Email, NULL AS MailDomain
FROM MasterAccounts ma, SendMethods sm, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.GroupID = g.GroupID
	AND ma.CustomerID = @CustomerID
	AND ma.Email IS NOT NULL
	AND ma.Email LIKE '%@%'

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.NoticeOrgList AS
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description
UNION ALL
SELECT OrganizationID AS Value,Organization AS Description 
FROM Organizations 
GO

CREATE PROCEDURE dbo.NoticeGroupList AS
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description
UNION ALL
SELECT GroupID AS Value,GroupName AS Description 
FROM Groups 
	WHERE GroupID <> 1 
	AND Active=1 
	AND SortOrder >= 0
GO

CREATE PROCEDURE dbo.NoticeIncidentTypeList AS 
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description, -1 AS SortOrder
UNION ALL
SELECT IncidentTypeID AS Value, IncidentType AS Description, SortOrder
FROM IncidentTypes 
	WHERE SortOrder >= 0
ORDER BY 3,2
GO

CREATE PROCEDURE dbo.NoticeAccountTypeList AS
SET NOCOUNT ON
SELECT NULL AS Value, 'All' AS Description, -1 AS SortOrder
UNION ALL
SELECT AccountTypeID AS Value,AccountType AS Description, SortOrder
FROM AccountTypes 
	WHERE SortOrder >= 0
ORDER BY 3, 2
GO

CREATE PROCEDURE dbo.PackageList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT PackageID, pt.PackageType, CASE WHEN p.Active=1 AND p.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+p.Extension+1,p.ExpireDate) < getdate() 
	THEN 'expired' WHEN p.Active=1 THEN 'active' ELSE 'inactive' END AS bginfo,
CASE DiffCost WHEN 1 then p.Cost ELSE pt.Cost END as Cost, 
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE PayPeriod END AS PayPeriod, BilledThru, ExpireDate, COALESCE(ma.OverDue,0)+p.Extension AS ExpirePlus
FROM MasterAccounts ma, Packages p, PackageTypes pt, PayPeriods pp, BillingCycles bc
WHERE ma.CustomerID=@CustomerID
	AND ma.CustomerID=p.CustomerID
	AND ma.BillingCycleID=bc.BillingCycleID
	and p.PackageTypeID=pt.PackageTypeID
	and p.PayPeriodID=pp.PayPeriodID
	AND p.Active IN (1,0)
Order By pt.SortOrder, pt.PackageType
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO


CREATE PROCEDURE dbo.PayBatchProcGet (@CustomerID INT, @cardlen INT, @cardprefix VARCHAR(4), @PaymentTypeID INT) AS
SET NOCOUNT ON
DECLARE @BatchProcessorID INT, @AllowAuthOnly INT, @Realtime INT

IF (@PaymentTypeID = 8)
BEGIN
SELECT @BatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND ctp.Prefix = SUBSTRING(@cardprefix,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND @cardlen IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID

IF (@BatchProcessorID IS NULL)
BEGIN
SELECT @BatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND ctp.Prefix = SUBSTRING(@cardprefix,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND @cardlen IN (ct.Length1,ct.Length2)
	AND bp.CardTypes & ct.CardTypeID = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
END
END

IF (@BatchProcessorID IS NULL)
BEGIN
SELECT @BatchProcessorID = MAX(bp.BatchProcessorID), @AllowAuthOnly = MAX(CASE WHEN e.Features & 2 = 2 THEN 1 ELSE 0 END), @Realtime = CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END
FROM MasterAccounts ma, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((@PaymentTypeID = 8 AND e.ExportType IN (1,2,5) AND bp.CardTypes & 256 = 256) OR (@PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = @CustomerID
END

SELECT @BatchProcessorID AS BatchProcessorID, @AllowAuthOnly AS AllowAuthOnly, @Realtime AS Realtime
GO

CREATE PROCEDURE dbo.PayCheckAdd (@CustomerID INT, @PaymentTypeID INT, @BatchID INT, @Amount NUMERIC(18,4), @CheckNumber VARCHAR(16), @PayInfo VARCHAR(32), @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE MasterAccounts SET OverDue = 0 WHERE CustomerID = @CustomerID AND OverDue > 0
INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,CheckNumber,PayInfo,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(@CustomerID,@PaymentTypeID,@BatchID,@Amount,@CheckNumber,@PayInfo,@LastModifyUser,1,getdate(),getdate())

SELECT @@IDENTITY AS PaymentID
GO

CREATE PROCEDURE dbo.PayGetTrans (@ExternalTransID INT) AS
SET NOCOUNT ON
SELECT et.CustomerID, et.InvoiceID, et.TransStateID, et.TransTypeID, et.Amount AS TransAmount, et.PaymentID, et.ProcTransID, p.Amount AS PayAmount, p.FinalAmount AS FinalAmount, p.StatementID, p.FinalStatementID
FROM ExternalTrans et LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.ExternalTransID = @ExternalTransID
GO

CREATE PROCEDURE dbo.PayAutoCheck (@CustomerID INT) AS
SET NOCOUNT ON

SELECT CASE WHEN PendingBalance < 0 THEN -(PendingBalance) ELSE 0 END AS Amount
FROM MasterAccounts ma, BillingCycles bc
	WHERE ma.BillingCycleID = bc.BillingCycleID
	AND ma.CustomerID = @CustomerID
	AND ma.PaymentTypeID IN (8,16)
	AND bc.AutoBill IN (0,1)
GO

CREATE PROCEDURE dbo.PaymentChange (@CustomerID INT, @PaymentID INT, @NewAmount NUMERIC(18,4), @PayInfo VARCHAR(128), @Operator VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE Payments SET DistFlag=1, FinalAmount=ROUND(@NewAmount,2), FinalCreateDate=GETDATE(), LastModifyDate=GETDATE(), PayInfo=@PayInfo, LastModifyUser=@Operator
	WHERE PaymentID = @PaymentID 
	AND CustomerID = @CustomerID
	AND FinalAmount IS NULL
	AND PaymentTypeID IN (2,4,8,16,64,128,256,512,1024,2048,4096,8192,16384,32768)
	AND @NewAmount IS NOT NULL
	AND Amount <> ROUND(@NewAmount,2)
SELECT @@ROWCOUNT AS Status
GO

CREATE PROCEDURE dbo.PaymentCredit (@CustomerID INT, @PaymentID INT, @Amount NUMERIC(18,4), @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @Realtime INT, @Status INT

SELECT @Realtime = MAX(ext.IsRealtime)
FROM ExternalTrans et, BatchProcessors bp, Exports e, ExportTypes ext
	WHERE et.PaymentID=@PaymentID
	AND et.CustomerID=@CustomerID
	AND et.Amount >= @Amount
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND e.ExportType = ext.ExportTypeID
	AND et.TransTypeID IN (32,64)

INSERT INTO ExternalTrans (CustomerID,InvoiceID,BatchProcessorID,TransStateID,TransTypeID,ReqDate,Amount,PaymentID,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,ProcTransID,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,AutoBill,LastRebatchTry,ApproveCode)
SELECT et.CustomerID,et.InvoiceID,et.BatchProcessorID,0 AS TransStateID,256 AS TransTypeID,getdate() AS ReqDate,@Amount AS Amount,et.PaymentID,getdate() AS LastModifyDate,@Operator AS LastModifyUser,et.AccountNumber,et.AccountExpire,et.AuthName,et.AuthAddress,et.AuthStateID,et.AuthZip,et.AuthSecurityCode,et.ProcTransID,et.BankName,et.BankNumber,et.BankPhone,et.BankTransType,et.SSN,et.DLNumber,et.DLState,et.BirthDate,0,getdate() AS LastRebatchTry,et.ApproveCode
FROM ExternalTrans et, Payments p
	WHERE et.PaymentID = p.PaymentID
	AND et.PaymentID=@PaymentID
	AND et.CustomerID=@CustomerID
	AND et.Amount >= @Amount
	AND p.FinalAmount IS NULL
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND et.TransTypeID IN (32,64)
	AND NOT EXISTS (SELECT * FROM ExternalTrans et2 WHERE et2.TransStateID IN (0,1,2,7) AND et2.ExternalTransID <> et.ExternalTransID AND et2.PaymentID=@PaymentID)

SELECT @@ROWCOUNT AS Status, @Realtime AS Realtime
GO

CREATE PROCEDURE dbo.PayPrepaidAdd (@CustomerID INT, @BatchID INT, @Amount NUMERIC(18,4), @CardAccountID INT, @PayInfo VARCHAR(32), @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE MasterAccounts SET OverDue = 0 WHERE CustomerID = @CustomerID AND OverDue > 0
INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,ProcTransID,PayInfo,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(@CustomerID,32,@BatchID,@Amount,CAST(@CardAccountID AS VARCHAR(40)),@PayInfo,@LastModifyUser,1,getdate(),getdate())

SELECT @@IDENTITY AS PaymentID
GO


CREATE PROCEDURE dbo.PayPrepaidGet (@CustomerID INT, @Login VARCHAR(40), @Password VARCHAR(128)) AS
SET NOCOUNT ON
SELECT ca.CardAccountID, CASE WHEN ca.Active = 1 AND cb.Active = 1 THEN 1 ELSE 0 END AS Active, 
CASE WHEN ca.InactiveExpireDate < getdate() THEN 1 ELSE 0 END AS Expired,
CASE WHEN ca.UsedForDirect = 1 OR (ca.AllowCredit = 0 AND ca.CreditAmount <= 0) THEN 1 ELSE 0 END AS Consumed,
CASE WHEN (SELECT o.OrganizationID FROM Organizations o, Groups g, MasterAccounts ma WHERE o.OrganizationID = g.OrganizationID AND ma.GroupID = g.GroupID AND ma.CustomerID = @CustomerID) = ca.OrganizationID THEN 1 ELSE 0 END AS OrgMatch,
CASE WHEN ca.AllowCredit = 1 AND ca.CreditAmount IS NOT NULL THEN 1 ELSE 0 END AS AllowCredit, CreditAmount
FROM CardAccounts ca, CardBatches cb
	WHERE ca.CardBatchID = cb.CardBatchID
	AND ca.Login = @Login
	AND ca.Password = @Password
GO

CREATE PROCEDURE dbo.PayTransAdd (@ExternalTransID INT, @BatchID INT, @LastModifyUser VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE MasterAccounts SET OverDue = 0 WHERE OverDue > 0 AND CustomerID IN (SELECT CustomerID FROM ExternalTrans WHERE ExternalTransID = @ExternalTransID)
INSERT INTO Payments (CustomerID,Amount,CreateDate,BatchID,PaymentTypeID,PayInfo,ProcTransID,DistFlag,LastModifyDate,LastModifyUser)
SELECT et.CustomerID,et.Amount,getdate(),@BatchID,CASE WHEN ext.IsBatch = 1 AND ext.IsCC = 1 THEN 8 WHEN ext.IsBatch = 1 AND ext.IsCC = 0 THEN 16 ELSE 64 END AS PaymentTypeID, CASE WHEN et.AutoBill = 1 AND ext.IsBatch = 1 AND ext.IsCC = 1 THEN 'CC Auto' WHEN et.AutoBill = 1 AND ext.IsBatch = 1 AND ext.IsCC = 0 THEN 'ACH Auto' ELSE NULL END,et.ProcTransID,1,getdate(),@LastModifyUser
FROM ExternalTrans et, BatchProcessors bp, Exports e, ExportTypes ext
	WHERE et.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND e.ExportType = ext.ExportTypeID
	AND et.ExternalTransID = @ExternalTransID
	AND et.TransTypeID IN (32,64)

SELECT @@IDENTITY AS PaymentID
GO

CREATE PROCEDURE dbo.PayBalSettle (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @PaidAmount NUMERIC(18,4), @InvAmount NUMERIC(18,4), @FinalAmount NUMERIC(18,4), @InvoiceID INT, @ChargeID INT, @ItemID INT, @StatementID INT, @CurBal NUMERIC(18,4), @NC NUMERIC(18,4)

SELECT @PaidAmount = SUM(CASE WHEN FinalStatementID IS NOT NULL THEN FinalAmount ELSE Amount END) 
FROM Payments 
	WHERE StatementID IS NOT NULL 
	AND CustomerID = @CustomerID

SELECT @InvAmount = SUM(CASE WHEN VoidDate IS NOT NULL AND VoidStatementID IS NOT NULL THEN 0 ELSE Amount END)
FROM Invoices
	WHERE CustomerID = @CustomerID 
	AND StatementID IS NOT NULL

SELECT @PaidAmount = COALESCE(@PaidAmount,0), @InvAmount = COALESCE(@InvAmount,0)

SELECT @FinalAmount = ROUND(Balance - (@InvAmount - @PaidAmount),2), @CurBal = Balance, @NC = ROUND(@InvAmount - @PaidAmount,2)
FROM MasterAccounts 
	WHERE CustomerID = @CustomerID

SELECT @FinalAmount = CASE WHEN COUNT(*) > 0 THEN 0 ELSE @FinalAmount END
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID=ii.InvoiceID
	AND i.CustomerID=@CustomerID
	AND i.VoidDate IS NULL
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(ROUND(ii.Amount * ii.Quantity,2))

IF (@FinalAmount <> 0)
BEGIN
INSERT INTO Invoices (CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,CreateDate,LastModifyDate,LastModifyUser,SentDate,Tax,Comments,Estimate,Processed,PrintDate,EmailDate)
VALUES(@CustomerID,4,@FinalAmount,CASE WHEN @FinalAmount > 0 THEN @FinalAmount ELSE 0 END, CASE WHEN @FinalAmount < 0 THEN -(@FinalAmount) ELSE 0 END,DATEADD(yy,-10,getdate()),getdate(),'GBE',DATEADD(yy,-10,getdate()),0,'GBE Balance sync',0,1,DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()))

SELECT @InvoiceID = @@IDENTITY

IF (@FinalAmount < 0)
	BEGIN
	INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser)
	VALUES(@CustomerID,'GBE balance sync',DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()),1,@FinalAmount,1,getdate(),'GBE')
	SELECT @ChargeID = @@IDENTITY
	END

INSERT INTO InvoiceItems (InvoiceID,ItemType,Days,Description,StartDate,EndDate,Amount,Quantity,ChargeID)
VALUES(@InvoiceID,CASE WHEN @FinalAmount < 0 THEN 1 ELSE 2 END,0,'GBE balance sync',DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()),@FinalAmount,1,@ChargeID)

SELECT @ItemID = @@IDENTITY

IF (@ChargeID IS NOT NULL)
BEGIN
UPDATE Charges SET ItemID = @ItemID WHERE ChargeID = @ChargeID
END

INSERT INTO Statements (CustomerID,StatementDate,SentDate,PrevBal,NewCharges,NewCredits,EndBal,PrintDate,EmailDate)
VALUES(@CustomerID,DATEADD(yy,-10,getdate()),DATEADD(yy,-10,getdate()),@NC,CASE WHEN @FinalAmount < 0 THEN 0 ELSE @FinalAmount END, CASE WHEN @FinalAmount > 0 THEN 0 ELSE -(@FinalAmount) END, @CurBal, DATEADD(yy,-10,getdate()), DATEADD(yy,-10,getdate()))

SELECT @StatementID = @@IDENTITY
UPDATE Invoices SET StatementID = @StatementID WHERE InvoiceID = @InvoiceID
END
GO

CREATE PROCEDURE dbo.PhoneLocation (@phone VARCHAR(64), @OperatorID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT c.Country, s.State, lp.City, Lat, Long, lp.Telco
FROM LocPhones lp, Countries c, States s, Operators o
WHERE c.CountryID = s.CountryID
	AND lp.StateID = s.StateID
	AND c.TelLocPrefixLen IS NOT NULL
	AND lp.Prefix = SUBSTRING(@phone,1,c.TelLocPrefixLen)
	AND o.OperatorID = @OperatorID
	AND (o.CountryID = c.CountryID OR 
			(o.CountryID IN (92,124,316,630,840) AND c.CountryID IN (92,124,316,630,840)))

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.PhoneSearch (@OperatorGroupID INT, @MBRGlobal INT, @phone VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @prea VARCHAR(5), @preb VARCHAR(5)
SELECT @prea = '(' + SUBSTRING(@phone,1,3) + '%', @preb = SUBSTRING(@phone,1,3) + '%'

SELECT ma.CustomerID, ma.FirstName, ma.LastName, ma.Company, r.Region, g.GroupName, ma.Address1, ma.Address2, ma.City, c.Country, s.State, ma.Zip, ma.Active
FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	WHERE (@MBRGlobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=@OperatorGroupID))
	AND ma.Active IN (0,1)
	AND ma.CustomerID IN (SELECT CustomerID FROM MasterAccounts WHERE (PhoneHome LIKE @prea OR PhoneHome LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneHome,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION
		SELECT CustomerID FROM MasterAccounts WHERE (PhoneWork LIKE @prea OR PhoneWork LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneWork,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION
		SELECT CustomerID FROM MasterAccounts WHERE (PhoneFax LIKE @prea OR PhoneFax LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneFax,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION
		SELECT CustomerID FROM SubAccounts WHERE (PhoneHome LIKE @prea OR PhoneHome LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneHome,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION
		SELECT CustomerID FROM SubAccounts WHERE (PhoneWork LIKE @prea OR PhoneWork LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneWork,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION 
		SELECT CustomerID FROM Addresses WHERE (Phone LIKE @prea OR Phone LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(Phone,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone
		UNION
		SELECT CustomerID FROM Addresses WHERE (Fax LIKE @prea OR Fax LIKE @preb) AND REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(Fax,' ',''),'-',''),'.',''),'_',''),'(',''),')',''),'+','') = @phone)
ORDER BY ma.Active DESC, ma.CustomerID DESC
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.PKGSAUpdate (@PackageID INT, @OldPackageTypeID INT) AS
SET NOCOUNT ON
DECLARE @AutoBill INT, @ExpireDate DATETIME, @BilledThru DATETIME, @Extension INT, @OldAccountTypeID INT, @NewAccountTypeID INT

SELECT @OldAccountTypeID = MAX(PrimaryAccountTypeID) 
FROM PackageTypes 
	WHERE PackageTypeID = @OldPackageTypeID

SELECT @AutoBill = bc.AutoBill, @ExpireDate = p.ExpireDate, @BilledThru = p.BilledThru, @Extension = p.Extension, @NewAccountTypeID = pt.PrimaryAccountTypeID
FROM Packages p, MasterAccounts ma, BillingCycles bc, PackageTypes pt
	WHERE p.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND p.PackageTypeID = pt.PackageTypeID
	AND p.PackageID = @PackageID

IF (@AutoBill <> 2)
BEGIN
UPDATE SubAccounts SET ExpireDate = @ExpireDate, BilledThru = @BilledThru, Extension = COALESCE(@Extension,0), AccountTypeID = CASE WHEN AccountTypeID = @OldAccountTypeID THEN COALESCE(@NewAccountTypeID,AccountTypeID) ELSE AccountTypeID END
	WHERE PackageID = @PackageID
	AND Active = 1
END
GO

CREATE PROCEDURE dbo.PKGFindCustomerID (@PackageID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN pt.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS SetupCharge,
CASE WHEN ma.Active = 1 AND p.Active = 1 THEN 1 ELSE 0 END AS Status,
CASE WHEN p.CancelDate IS NULL AND p.Active = 1 THEN 1 ELSE 0 END AS Active, ma.GroupID,p.CustomerID, p.PackageTypeID, p.DiscountID, pt.PackageType
FROM Packages p, MasterAccounts ma, PackageTypes pt
	WHERE p.PackageID = @PackageID
	AND p.CustomerID = ma.CustomerID
	AND p.PackageTypeID = pt.PackageTypeID
	AND ma.Active IN (1,0)
	AND p.Active IN (1,0)
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.PKGSAList (@PackageID INT) AS
SET NOCOUNT ON

CREATE TABLE #psltmp (AccountTypeID INT, Cnt INT)

INSERT INTO #psltmp (AccountTypeID,Cnt)
SELECT sa.AccountTypeID, COUNT(*)
FROM SubAccounts sa
	WHERE sa.PackageID=@PackageID
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
GROUP BY sa.AccountTypeID

SELECT 0 AS SortOrder, sa.AccountID,sa.Login,sa.FirstName,sa.LastName,at1.AccountType,sa.Email, CASE WHEN sa.Active=1 AND sa.CancelDate IS NOT NULL THEN 'canceled' WHEN sa.Active = 1 THEN 'active' ELSE 'inactive' END AS bginfo, sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, 0 AS MinQty, 0 AS MaxQty, 0 AS AddQty, sa.AccountTypeID
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, PayPeriods pp
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.PackageID = @PackageID

UNION ALL

SELECT 1 AS SortOrder, NULL AS AccountID, NULL AS Login, NULL AS FirstName, NULL AS LastName, at1.AccountType, NULL AS Email, 
CASE WHEN COALESCE(t.Cnt,0) < MinQty THEN 'toofew' ELSE 'add' END AS bginfo, NULL AS TimeLeft,NULL AS DataLeft, MinQty, MaxQty, MaxQty - COALESCE(t.Cnt,0) AS AddQty, pat.AccountTypeID
FROM PackageAccountTypes pat JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN Packages p ON (pat.PackageTypeID = p.PackageTypeID)
	LEFT JOIN #psltmp t ON (pat.AccountTypeID = t.AccountTypeID)
	WHERE p.PackageID = @PackageID
	AND (t.Cnt IS NULL OR pat.MaxQty > t.Cnt)

ORDER BY 1, 3, 5

DROP TABLE #psltmp
GO

CREATE PROCEDURE dbo.PrintAddBatch (@type VARCHAR(16), @GroupID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchID INT, @ItemCount INT, @ItemTotal NUMERIC(18,4), @printzero NUMERIC(18,4), @batchmax INT

IF (@type = 'invoice' AND @GroupID IS NOT NULL)
BEGIN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, Operator, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(4,8,@GroupID,@Operator,getdate(),getdate(),@Operator,0,0)

SELECT @printzero = 0, @BatchID = @@IDENTITY
SELECT @printzero = COALESCE((SELECT cgd.NumValue FROM ConfigGroupData cgd WHERE cgd.ConfigID = 507 AND cgd.GroupID = @GroupID),c.NumValue) FROM Configs c WHERE c.ConfigID = 507
SELECT @batchmax = COALESCE(NumValue,0) FROM Configs WHERE ConfigID = 622

SET ROWCOUNT @batchmax
UPDATE Invoices SET PrintBatchID=CASE WHEN @printzero = 0 AND i.Amount <= 0 THEN NULL ELSE @BatchID END, PrintDate = CASE WHEN @printzero = 0 AND i.Amount <= 0 THEN getdate() ELSE NULL END
FROM MasterAccounts ma, SendMethods sm, Invoices i, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.VoidDate IS NULL
	AND i.CreateDate > DATEADD(dd,-45,getdate())
	AND sm.PrintTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND i.PrintBatchID IS NULL
	AND i.PrintDate IS NULL
	AND ma.GroupID = g.GroupID
	AND ma.GroupID = @GroupID
	AND (@printzero = 1 OR (@printzero = 0 AND i.Amount > 0))
SET ROWCOUNT 0

SELECT @ItemCount = COUNT(*), @ItemTotal = SUM(Amount)
FROM Invoices 
	WHERE PrintBatchID = @BatchID

IF (@ItemCount = 0)
	BEGIN
	DELETE FROM Batches WHERE BatchID = @BatchID
	SELECT @BatchID = NULL
	END ELSE BEGIN
	UPDATE Batches SET BatchStateID = 1, EndDate = getdate(), ItemCount = @ItemCount, ItemTotal = @ItemTotal WHERE BatchID = @BatchID
	END
END

IF (@type = 'statement' AND @GroupID IS NOT NULL)
BEGIN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, Operator, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(5,8,@GroupID,@Operator,getdate(),getdate(),@Operator,0,0)

SELECT @printzero = 0, @BatchID = @@IDENTITY
SELECT @printzero = COALESCE((SELECT MAX(cgd.NumValue) FROM ConfigGroupData cgd WHERE cgd.ConfigID = 38 AND cgd.GroupID = @GroupID),c.NumValue) FROM Configs c WHERE c.ConfigID = 38
SELECT @batchmax = COALESCE(NumValue,0) FROM Configs WHERE ConfigID = 627

SET ROWCOUNT @batchmax
UPDATE Statements SET PrintBatchID=CASE WHEN @printzero = 0 AND s.EndBal <= 0 THEN NULL ELSE @BatchID END, PrintDate = CASE WHEN @printzero = 0 AND s.EndBal <= 0 THEN getdate() ELSE NULL END
FROM MasterAccounts ma, SendMethods sm, Statements s, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = s.CustomerID
	AND ma.LastStatementID = s.StatementID
	AND sm.PrintTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND s.PrintBatchID IS NULL
	AND s.PrintDate IS NULL
	AND ma.GroupID = g.GroupID
	AND ma.GroupID = @GroupID
	AND (@printzero = 1 OR (@printzero = 0 AND s.EndBal > 0))
SET ROWCOUNT 0

SELECT @ItemCount = COUNT(*), @ItemTotal = SUM(EndBal)
FROM Statements
	WHERE PrintBatchID = @BatchID

IF (@ItemCount = 0)
	BEGIN
	DELETE FROM Batches WHERE BatchID = @BatchID
	SELECT @BatchID = NULL
	END ELSE BEGIN
	UPDATE Batches SET BatchStateID = 1, EndDate = getdate(), ItemCount = @ItemCount, ItemTotal = @ItemTotal WHERE BatchID = @BatchID
	END
END

SELECT @BatchID AS BatchID
GO

CREATE PROCEDURE dbo.PrintMarkSent (@BatchID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchTypeID INT
SELECT @BatchTypeID = BatchTypeID FROM Batches WHERE BatchID = @BatchID

IF (@BatchTypeID = 4)
BEGIN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = getdate(), LastModifyUser = @Operator WHERE BatchID = @BatchID

INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,Operator,LastModifyDate,LastModifyUser,AllowInterim)
SELECT i.CustomerID, ct.Description, getdate(), getdate(), ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', getdate(), 'GBE',0
FROM Invoices i, MasterAccounts ma, SendMethods sm, ChargeTypes ct, Batches b
	WHERE i.PrintBatchID = @BatchID
	AND i.PrintDate IS NULL
	AND i.CreateDate > DATEADD(dd,-10,getdate())
	AND i.CustomerID = ma.CustomerID
	AND ma.SendMethodID = sm.SendMethodID
	AND sm.ChargeTypeID = ct.ChargeTypeID
	AND i.PrintBatchID = b.BatchID
	AND b.Rebatch IS NULL

UPDATE Invoices SET PrintDate = getdate()
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NULL
END

IF (@BatchTypeID = 5)
BEGIN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = getdate(), LastModifyUser = @Operator WHERE BatchID = @BatchID

INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,Operator,LastModifyDate,LastModifyUser,AllowInterim)
SELECT s.CustomerID, ct.Description, getdate(), getdate(), ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', getdate(), 'GBE',0
FROM Statements s, MasterAccounts ma, SendMethods sm, ChargeTypes ct, Batches b
	WHERE s.PrintBatchID = @BatchID
	AND s.PrintDate IS NULL
	AND s.CustomerID = ma.CustomerID
	AND ma.SendMethodID = sm.SendMethodID
	AND sm.ChargeTypeID = ct.ChargeTypeID
	AND s.PrintBatchID = b.BatchID
	AND b.Rebatch IS NULL

UPDATE Statements SET PrintDate = getdate()
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NULL
END
GO

CREATE PROCEDURE dbo.PrintNoMarkSent (@BatchID INT, @Operator VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @BatchTypeID INT
SELECT @BatchTypeID = BatchTypeID FROM Batches WHERE BatchID = @BatchID

IF (@BatchTypeID = 4)
BEGIN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = getdate(), LastModifyUser = @Operator, Rebatch = 1 WHERE BatchID = @BatchID

UPDATE Invoices SET PrintDate = NULL
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NOT NULL
END

IF (@BatchTypeID = 5)
BEGIN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = getdate(), LastModifyUser = @Operator, Rebatch = 1 WHERE BatchID = @BatchID

UPDATE Statements SET PrintDate = NULL
	WHERE PrintBatchID = @BatchID
	AND PrintDate IS NOT NULL
END
GO

CREATE PROCEDURE dbo.RadAtCache (@accounttype VARCHAR(30)) AS
SET NOCOUNT ON
SELECT at1.AccountType, ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadCheck, rc.Tag, at1.AccountTypeID, at1.RateClassID
FROM RadATConfigs rc, RadAttributes ra, AccountTypes at1
	WHERE ra.RadAttributeID = rc.RadAttributeID
	AND rc.AccountTypeID = at1.AccountTypeID
	AND (ra.RadVendorID = rc.RadVendorID OR rc.RadVendorID IS NULL)
	AND (@accounttype IS NULL OR at1.AccountType = @accounttype)
ORDER BY AccountType, rc.RadATConfigID
GO

CREATE PROCEDURE dbo.RadConcurrencySync AS
SET NOCOUNT ON
CREATE TABLE #rcssync (RadConcurrencyID INT, Connections INT)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT INTO #rcssync (RadConcurrencyID,Connections)
SELECT RadConcurrencyID, COUNT(*) AS Connections 
FROM ServerPorts sp, MasterAccounts ma, SubAccounts sa, RadConcurrency rc
	WHERE sp.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR sa.AccountTypeID = rc.AccountTypeID)
	AND sp.AcctStatusType IN (1,3)
GROUP BY rc.RadConcurrencyID
UPDATE RadConcurrency SET Connections = 0
UPDATE RadConcurrency SET LastSyncDate = getdate(), Connections = s.Connections
FROM RadConcurrency rc, #rcssync s
	WHERE rc.RadConcurrencyID = s.RadConcurrencyID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
DROP TABLE #rcssync
GO

CREATE PROCEDURE dbo.RadCheckOnline (@Username varchar(64), @accountid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @LoginLimit INT, @Connections INT, @ConnectionsMax INT, @LastSyncDate DATETIME, @AccountTypeID INT, @RadConcurrencyID INT


SELECT @AccountTypeID = sa.AccountTypeID, @LoginLimit = sa.LoginLimit, @GroupID = ma.GroupID FROM MasterAccounts ma, SubAccounts sa WHERE ma.CustomerID = sa.CustomerID AND sa.AccountID = @accountid
SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @LastSyncDate = MAX(LastSyncDate), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
FROM RadConcurrency
	WHERE GroupID = @GroupID
	AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)

IF (@RadConcurrencyID IS NOT NULL)
BEGIN
	IF (DATEDIFF(ss,@LastSyncDate,getdate()) > 1800)
		BEGIN
		EXEC RadConcurrencySync
		SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @LastSyncDate = MAX(LastSyncDate), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
		FROM RadConcurrency
			WHERE GroupID = @GroupID
			AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)
		END

	IF (@Connections >= @ConnectionsMax)
	BEGIN
		SELECT @Connections, @ConnectionsMax
	END ELSE BEGIN
		SELECT COUNT(*) 
		FROM ServerPorts 
			WHERE AccountID = @accountid 
			AND AcctStatusType = 1
	END
END ELSE BEGIN
	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID = @accountid 
		AND AcctStatusType = 1
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RadPoolSync AS 
SET NOCOUNT ON
UPDATE RadIPAddresses SET State = 0 
	WHERE ((State = 1 AND LastUsed < DATEADD(mi,-20,getdate())) OR (State = 2))
	AND NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.AcctStatusType = 1 AND sp.NASIdentifier = RadIPAddresses.NASIdentifier AND sp.Port = RadIPAddresses.NASPort)
GO

CREATE PROCEDURE dbo.RadCheckOnlineCallerID (@Username varchar(64), @accountid INT, @CallerID VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @LoginLimit INT, @Connections INT, @ConnectionsMax INT, @LastSyncDate DATETIME, @AccountTypeID INT, @RadConcurrencyID INT

IF (@CallerID IS NOT NULL)
BEGIN
	UPDATE ServerPorts SET AcctStatusType = 2 WHERE CallerID = @CallerID AND AccountID = @accountid
END

SELECT @AccountTypeID = sa.AccountTypeID, @LoginLimit = sa.LoginLimit, @GroupID = ma.GroupID FROM MasterAccounts ma, SubAccounts sa WHERE ma.CustomerID = sa.CustomerID AND sa.AccountID = @accountid
SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @LastSyncDate = MAX(LastSyncDate), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
FROM RadConcurrency
	WHERE GroupID = @GroupID
	AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)

IF (@RadConcurrencyID IS NOT NULL)
BEGIN
	IF (DATEDIFF(ss,@LastSyncDate,getdate()) > 1800)
		BEGIN
		EXEC RadConcurrencySync
		SELECT @RadConcurrencyID = MAX(RadConcurrencyID), @LastSyncDate = MAX(LastSyncDate), @Connections = MAX(Connections), @ConnectionsMax = MAX(ConnectionsMax)
		FROM RadConcurrency
			WHERE GroupID = @GroupID
			AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)
		END

	IF (@Connections >= @ConnectionsMax)
	BEGIN
		SELECT @Connections, @ConnectionsMax
	END ELSE BEGIN
		SELECT COUNT(*) 
		FROM ServerPorts 
			WHERE AccountID = @accountid 
			AND AcctStatusType = 1
	END
END ELSE BEGIN
	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID = @accountid 
		AND AcctStatusType = 1
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RadCheckOnlineSNMP (@Username varchar(64), @accountid INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT s.IPAddress, st.SNMPType, s.Community, sp.SNMPUser, sp.AcctSessionID
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE @accountid = sp.AccountID 
	AND sp.AcctStatusType = 1
	AND s.ServerType = st.ServerType
	AND s.ServerID = sp.ServerID
	AND sp.SNMPUser IS NOT NULL
	AND s.Community IS NOT NULL
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO
CREATE PROCEDURE dbo.RadCheckTrigger (@AccountID INT) AS
SET NOCOUNT ON
SELECT FileName, Parameters, Directory, TriggerType 
FROM RadTriggers 
	WHERE AccountID=@AccountID
GO

CREATE PROCEDURE dbo.RadClearNAS (@NASIdentifier VARCHAR(32)) AS
SET NOCOUNT ON
UPDATE ServerPorts SET AcctStatusType = 2 WHERE NASIdentifier = @NASIdentifier AND AcctStatusType = 1
UPDATE RadIPAddresses SET State = 0 WHERE NASIdentifier = @NASIdentifier AND State <> 0
GO

CREATE PROCEDURE dbo.RadDNISCache AS
SET NOCOUNT ON
SELECT at1.AccountType, dn.DNISNumber
FROM AccountTypes at1, DNISNumbers dn
	WHERE at1.DNISGroupID = dn.DNISGroupID
UNION ALL
SELECT AccountType, NULL
FROM AccountTypes 
	WHERE DNISGroupID IS NULL
GO

CREATE PROCEDURE dbo.RadGetCacheUsers (@ldate DATETIME, @flag SMALLINT)  AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@flag = 1)
BEGIN

SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.LastModifyDate > @ldate
UNION
SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND ma.LastModifyDate > @ldate
UNION
SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND p.LastModifyDate > @ldate
UNION


SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login + '@' + d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND sa.LastModifyDate > @ldate
UNION
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login + '@' + d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND ma.LastModifyDate > @ldate
UNION
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login + '@' + d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND p.LastModifyDate > @ldate

END ELSE IF (@flag = 2)
BEGIN
SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.Login <> ' '
	AND sa.Login IS NOT NULL
UNION ALL
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login + '@' + d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))

END
GO

CREATE PROCEDURE dbo.RadGetConfigs (@AccountID INT) AS
SET NOCOUNT ON
Select ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadCheck, rc.Tag
From RadConfigs rc, RadAttributes ra
Where ra.RadAttributeID=rc.RadAttributeID
	AND ra.RadVendorID = rc.RadVendorID
	AND rc.AccountID=@AccountID
ORDER BY rc.RadConfigID
GO

CREATE PROCEDURE dbo.RadGetFilterGroups AS
SET NOCOUNT ON
SELECT RadFilterGroupID, RadSourceTypeID, RadDestTypeID, DestRadFilterGroupID, DestData
FROM RadFilterGroups
	WHERE Active = 1 OR RadSourceTypeID = 1
ORDER BY SortOrder DESC,RadFilterGroup DESC
GO

CREATE PROCEDURE dbo.RadGetFilters (@RadFilterGroupID INT) AS
SET NOCOUNT ON
SELECT RadFilterTypeID, RadVendorID, RadAttributeID, RadSearchTypeID, RadMergeTypeID, Location, Data
FROM RadFilters
	WHERE RadFilterGroupID = @RadFilterGroupID
ORDER BY RadFilterID DESC
GO

CREATE PROCEDURE dbo.RadGetPoolConfigs (@AccountTypeID int, @ServerID int, @NASIdentifier varchar(16), @NASPort VARCHAR(10), @accountid INT, @callerid VARCHAR(20), @dnis VARCHAR(20)) AS
SET ROWCOUNT 1
SET NOCOUNT ON
DECLARE @AssignType INT, @ip VARCHAR(16)
UPDATE RadIPAddresses SET State = 0
	WHERE NASIdentifier = @NASIdentifier
	AND NASPort = @NASPort
	AND (State = 2
		OR (State = 1 AND LastUsed < DATEADD(mi,-2,getdate())))

SELECT @ip=MIN(IPAddress) FROM RadIPAddresses WHERE AccountID=@accountid

-- Specific Account Type, Specific IP Group
IF (@ip IS NULL)
BEGIN
SELECT @ip=ria.IPAddress, @AssignType = riat.AssignType
FROM ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
	WHERE s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	AND riat.AccountTypeID = @AccountTypeID
	AND s.ServerID = @ServerID
	AND ria.State = 0
	AND ria.AccountID IS NULL
ORDER BY riat.Priority, ria.LastUsed ASC
END

-- All Account Types, Specific IP Group
IF (@ip IS NULL)
BEGIN
Select @ip=ria.IPAddress, @AssignType = riat.AssignType
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	AND riat.AccountTypeID IS NULL
	AND s.ServerID = @ServerID
	AND ria.State = 0
	AND ria.AccountID IS NULL
ORDER BY riat.Priority, ria.LastUsed ASC
END

-- Specific Account Type, All IP Groups
IF (@ip IS NULL)
BEGIN
SELECT @ip=ria.IPAddress, @AssignType = riat.AssignType
From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	and riat.AccountTypeID = @AccountTypeID
	and s.ServerID = @ServerID
	and ria.State = 0
	AND ria.AccountID IS NULL
ORDER BY riat.Priority, ria.LastUsed ASC
END

-- All Account Types, All IP Groups
IF (@ip IS NULL)
BEGIN
SELECT @ip=ria.IPAddress, @AssignType = riat.AssignType
From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	AND riat.AccountTypeID IS NULL
	and s.ServerID = @ServerID
	and ria.State = 0
	AND ria.AccountID IS NULL
ORDER BY riat.Priority, ria.LastUsed ASC
END


IF (@ip IS NOT NULL)
	BEGIN
	Update RadIPAddresses
		Set LastUsed = getdate(), State = 1, NASIdentifier = @NASIdentifier, NASPort = @NASPort, AccountID = CASE WHEN AccountID IS NULL AND @AssignType = 1 THEN @accountid ELSE AccountID END
		Where IPAddress = @ip
	SELECT 8 AS AttributeID,0 AS VendorID, 0 AS Value, @ip AS Data
	END

GO

CREATE PROCEDURE dbo.RadGetProxyAttributes AS
SET NOCOUNT ON
SELECT apg.RadProxyAttributeGroupID,apg.RadRoamServerID,ap.String,ap.SearchType,ap.RadAttributeID, ap.RadVendorID
FROM RadProxyAttributeGroups apg, RadProxyAttributes ap
	WHERE apg.RadProxyAttributeGroupID = ap.RadProxyAttributeGroupID
ORDER BY apg.Priority ASC, apg.RadProxyAttributeGroupID
GO

CREATE PROCEDURE dbo.RadGetRejects AS
SET NOCOUNT ON
SELECT ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rr.RadVendorID
FROM RadAttributes ra, RadRejects rr
	WHERE ra.RadAttributeID=rr.RadAttributeID
	AND ra.RadVendorID = rr.RadVendorID
ORDER BY Data,Value
GO

CREATE PROCEDURE dbo.RadGetUser (@user VARCHAR(64)) AS
SET NOCOUNT ON
DECLARE @CustomerID INT, @AccountID INT, @CardAccountID INT, @userp VARCHAR(64), @domainp VARCHAR(64), @chkcard INT
SELECT @userp = CASE WHEN @user LIKE '%@%' THEN SUBSTRING(@user,1,CHARINDEX('@',@user)-1) END
SELECT @domainp = CASE WHEN @user LIKE '%@%' THEN SUBSTRING(@user,CHARINDEX('@',@user)+1,DATALENGTH(@user)) END

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT @CardAccountID = MAX(CardAccountID)
FROM CardAccounts
	WHERE Login = COALESCE(@userp,@user)
	AND Active = 1
	AND AllowDirect = 1
	AND UsedForCredit = 0
	AND UsedForDirect = 0
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > getdate())

IF (@CardAccountID IS NOT NULL)
	BEGIN
	SELECT @chkcard = COUNT(*) FROM CardAccounts ca, CardBatches cb WHERE ca.CardBatchID = cb.CardBatchID AND cb.Active = 1 AND ca.CardAccountID = @CardAccountID
	IF (@chkcard = 1)
		BEGIN
		SET TRANSACTION ISOLATION LEVEL READ COMMITTED
		UPDATE CardAccounts SET AllowDirect = 0, UsedForDirect = 1 WHERE CardAccountID = @CardAccountID AND UsedForDirect = 0

		IF (@@ROWCOUNT = 1)
			BEGIN
			INSERT INTO MasterAccounts (FirstName, LastName, CountryID, SalesPersonID, CreateDate, StartDate, Active, PayPeriodID, PaymentTypeID, Comments, GroupID, SendMethodID, BillingCycleID, BillDay, Balance, PendingBalance,PayInfo, LastModifyDate, LastModifyUser)
			SELECT ' ' AS FirstName, ' ' AS LastName, g.BillCountryID,  cb.SalesPersonID, getdate(), getdate(), 1, cb.PayPeriodID, 1, 'prepaid auto', cb.GroupID, cb.SendMethodID, cb.BillingCycleID, DATEPART(dd,getdate()),0, -(COALESCE(cb.DirectAmount,0)), 'prepaid auto', getdate(), 'prepaid auto'
			FROM CardAccounts ca, CardBatches cb, Groups g
				WHERE ca.CardBatchID = cb.CardBatchID
				AND cb.GroupID = g.GroupID
				AND ca.CardAccountID = @CardAccountID

			SELECT @CustomerID = @@IDENTITY

			INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
			SELECT CustomerID, -(PendingBalance),getdate(),NULL,32,'prepaid direct credit',0,getdate(),'prepaid auto'
			FROM MasterAccounts
				WHERE CustomerID = @CustomerID
				AND PendingBalance < 0

			INSERT INTO SubAccounts (CustomerID, Login, AccountTypeID, PayPeriodID, DiscountID, Comments, Password, CreateDate, StartDate, BilledThru, ExpireDate, Extension, Active, SalesPersonID, Operator, LastModifyDate, LastModifyUser, TimeLeft, DataLeft, SendBill, RemoteAccess, LoginLimit, DomainID)
			SELECT @CustomerID, ca.Login, cb.AccountTypeID, cb.PayPeriodID, cb.DiscountID, 'prepaid auto', ca.Password, getdate(), getdate(), DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),getdate())), DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),getdate())), 0, 1, cb.SalesPersonID, 'prepaid auto', getdate(), 'prepaid auto', cb.TimeLeft, cb.DataLeft, 1, 2, at1.LoginLimit, cb.DomainID
			FROM CardAccounts ca, CardBatches cb, Groups g, AccountTypes at1
				WHERE ca.CardBatchID = cb.CardBatchID
				AND cb.GroupID = g.GroupID
				AND cb.AccountTypeID = at1.AccountTypeID
				AND ca.CardAccountID = @CardAccountID

			SELECT @AccountID = @@IDENTITY

			UPDATE CardAccounts SET DirectCustomerID = @CustomerID, DirectAccountID = @AccountID, AllowDirect = 0, UsedForDirect = 1, AllowCredit = 0, FirstUseDate = getdate() WHERE CardAccountID = @CardAccountID
			END
		SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
		END
	END

SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft, 
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft,
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login = @user
	AND @user IS NOT NULL
	AND @user <> ' '
UNION ALL
SELECT sa.AccountID, sa.Email, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Email = @user
	AND @user IS NOT NULL
	AND @user <> ' '
UNION ALL
SELECT sa.AccountID, sa.Login + '@' + d.MailDomain, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN getdate() ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > getdate() AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Email IS NULL 
	AND sa.Login = @userp 
	AND d.MailDomain = @domainp 
	AND @userp IS NOT NULL
	AND @domainp IS NOT NULL
	AND @userp <> ' '
	AND @domainp <> ' '
GO

CREATE PROCEDURE dbo.RadOnlineGetSNMP AS
SET NOCOUNT ON
SELECT s.IPAddress, st.SNMPType AS ServerType, s.Community, sp.SNMPUser, sp.AcctSessionID, sp.Username, sp.ServerID,sp.Port
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE s.ServerID = sp.ServerID
	AND s.ServerType = st.ServerType
	AND AcctStatusType=1
	AND DATALENGTH(sp.SNMPUser) > 5
	AND DATALENGTH(s.Community) > 1
	AND Username IS NOT NULL
ORDER BY sp.Port
GO

CREATE PROCEDURE dbo.RadOnlineUpdateSNMP (@serverid INT, @port INT, @username VARCHAR(32)) AS
UPDATE ServerPorts SET AcctStatusType = 0
	WHERE AcctStatusType = 1 
	AND ServerID = @serverid
	AND Port = @port
	AND Username = @username

SELECT CASE WHEN @@rowcount = 0 THEN 'Not Updated' ELSE 'Updated' END AS Status
GO

CREATE PROCEDURE dbo.RadProxyCallCount AS
SET NOCOUNT ON
DECLARE @StartDate SMALLDATETIME
SELECT @StartDate = DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())))

CREATE TABLE #rpcctmp (Realm VARCHAR(64), Username VARCHAR(64), InBytes BIGINT, OutBytes BIGINT, SessionTime  INT, SessionCount INT)

INSERT INTO #rpcctmp (Realm, Username, InBytes, OutBytes, SessionTime, SessionCount)
SELECT SUBSTRING(c.Username,CHARINDEX('@',c.Username) + 1,DATALENGTH(c.Username)) AS Realm, c.Username, SUM(c.AcctInputOctets) AS InBytes, SUM(c.AcctOutputOctets) AS OutBytes, SUM(c.AcctSessionTime) AS SessionTime, COUNT(*) AS SessionCount
FROM Calls c
	WHERE c.CallDate BETWEEN @StartDate AND DATEADD(mm,1,@StartDate)
	AND c.AcctStatusType = 2
	AND c.AccountID IS NULL
	AND c.Username LIKE '%@%'
GROUP BY c.Username

SELECT  @StartDate AS StartDate, COUNT(*) AS Data, COUNT(*) AS SessionMaxData, t.Realm, SUM(t.InBytes) + SUM(t.OutBytes) AS AllBytes, SUM(t.InBytes) AS InBytes, SUM(t.OutBytes) AS OutBytes, SUM(t.SessionTime) AS SessionMaxTime, SUM(t.SessionTime) AS SessionTime, SUM(t.SessionCount) AS SessionCount
FROM #rpcctmp t
	WHERE NOT EXISTS (SELECT * FROM RadProxyRateProcs rprp WHERE rprp.Realm = t.Realm AND rprp.ProxyType = 1 AND rprp.ProcDate = @StartDate)
GROUP BY t.Realm

DROP TABLE #rpcctmp
GO

CREATE PROCEDURE dbo.RadProxyCallCountUP (@ProxyType SMALLINT, @Realm VARCHAR(64), @InBytes BIGINT, @OutBytes BIGINT, @UserCount INT, @SessionTime INT, @SessionCount INT) AS
SET NOCOUNT ON
DECLARE @StartDate DATETIME
SELECT @StartDate = DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())))

INSERT INTO RadProxyRateProcs (Realm, ProxyType, ProcDate, InBytes, OutBytes, UserCount, SessionTime, SessionCount)
VALUES(@Realm, @ProxyType, @StartDate, @InBytes, @OutBytes, @UserCount, @SessionTime, @SessionCount)
GO

CREATE PROCEDURE dbo.RadRoamCache AS
SET NOCOUNT ON
SELECT Domain AS Label, Server, IPAddress, Secret, AuthPort, AcctPort,
Priority, Timeout, Retries, StripDomain, TreatAsLocal, at1.AccountType, rrs.RateTarget, rrs.RateMax
From RadRoamServers rrs JOIN RadRoamDomains rrd ON (rrd.RadRoamServerID = rrs.RadRoamServerID)
	LEFT JOIN AccountTypes at1 ON (rrd.AccountTypeID = at1.AccountTypeID)
UNION
SELECT rrd2.Domain AS Label, Server, IPAddress, Secret, AuthPort, AcctPort, 
rrd.Priority, Timeout, Retries, StripDomain, TreatAsLocal,at1.AccountType, rrs.RateTarget, rrs.RateMax
FROM RadRoamDomains rrd, RadRoamServers rrs, RadRoamDomains rrd2, AccountTypes at1
	WHERE rrd.RadRoamServerID = rrs.RadRoamServerID
	AND rrd.Domain = 'DEFAULT'
	AND rrd.AccountTypeID = at1.AccountTypeID
UNION
SELECT CAST(RadRoamServerID AS VARCHAR(10)) AS Label, Server, IPAddress, Secret, AuthPort, AcctPort, 
0, Timeout, Retries, StripDomain, TreatAsLocal, NULL, RateTarget, RateMax
FROM RadRoamServers
ORDER BY Label,Priority
GO

CREATE PROCEDURE dbo.RadServerAccessCache AS
SET NOCOUNT ON
SELECT MaxSessionLength, StartTime, StopTime, s.IPAddress, sa.Port, at1.AccountType
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
UNION
SELECT MaxSessionLength, StartTime, StopTime, s.Server, sa.Port, at1.AccountType
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
UNION
SELECT NULL, NULL, NULL, s.IPAddress, NULL, NULL
FROM Servers s
WHERE s.CheckAccess = 0
UNION
SELECT NULL, NULL, NULL, s.Server, NULL, NULL
FROM Servers s
WHERE s.CheckAccess = 0
GO

CREATE PROCEDURE dbo.RateCallsResellerClassifier AS
SET NOCOUNT ON
CREATE TABLE #rcrctmp2 (GroupID INT)
INSERT INTO #rcrctmp2 (GroupID)
SELECT g.GroupID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NULL

CREATE TABLE #rcrctmp (GroupID INT, CustomerID INT)
INSERT INTO #rcrctmp (GroupID, CustomerID)
SELECT g.GroupID, o.ResellerCustomerID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NOT NULL

SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp
UNION ALL
SELECT 'CustomerID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp
UNION ALL
SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp2
UNION ALL
SELECT 'RateClassID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, '0' AS Data, NULL AS Cost, NULL AS Priority FROM #rcrctmp2
GO

CREATE PROCEDURE dbo.RateCallsUP (@hostip VARCHAR(64), @Preferred INT, @CallID BIGINT, @Message VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @IsLeader INT, @Leader VARCHAR(64), @LastUpdate DATETIME, @LastMessage VARCHAR(255), @Advisor VARCHAR(64), @LastAdviceDate DATETIME, @status INT, @Lead INT
SELECT @Leader = MAX(Leader), @LastUpdate = MAX(LastUpdate), @LastMessage = MAX(LastMessage), @Advisor = MAX(Advisor), @LastAdviceDate = MAX(LastAdviceDate) FROM RateStatusCalls
IF (@hostip = @Leader)
BEGIN
IF (@Advisor <> @hostip AND DATEDIFF(ss,@LastAdviceDate,getdate()) < 90 AND @Preferred = 0 AND @CallID IS NOT NULL)
	BEGIN
	UPDATE RateStatusCalls SET LastCallID = @CallID, LastMessage = COALESCE(@Message,LastMessage), Leader = Advisor, LastUpdate = getdate() WHERE Leader = @hostip
	SELECT @Lead = 0

	END ELSE BEGIN
	UPDATE RateStatusCalls SET LastUpdate = getdate(), LastCallID = COALESCE(@CallID,LastCallID), LastMessage = COALESCE(@Message,LastMessage) WHERE Leader = @hostip
	IF (@@ROWCOUNT = 0)
		BEGIN
		IF (@Preferred = 1)
			BEGIN
			UPDATE RateStatusCalls SET Advisor = @hostip, LastAdviceDate = DATEADD(mi,1,getdate())
			END
		SELECT @Lead = 0

		END ELSE BEGIN
		SELECT @Lead = 1
		END
	END

END ELSE BEGIN
IF (DATEDIFF(ss,@LastUpdate,getdate()) > 90)
	BEGIN
	UPDATE RateStatusCalls SET Leader = @hostip, LastUpdate = getdate(), LastCallID = COALESCE(@CallID,LastCallID), LastMessage = NULL WHERE DATEDIFF(ss,LastUpdate,getdate()) > 90 OR Leader = @hostip
	SELECT @Lead = CASE WHEN @@ROWCOUNT = 1 THEN 1 ELSE 0 END
	END ELSE BEGIN
	SELECT @Lead = 0
	END
END

SELECT @Lead AS Lead
GO

CREATE PROCEDURE dbo.RateChargesGet AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @delay INT, @interim INT, @thismonth DATETIME
CREATE TABLE #rcgv (AccountID INT, MaxCallDate DATETIME, Cost NUMERIC(18,4), Cnt INT, RateID INT, Interim INT)
SELECT @delay = CASE WHEN NumValue <= 0 THEN 1 WHEN NumValue > 15 THEN 15 ELSE NumValue END FROM Configs WHERE ConfigID = 646
SELECT @interim = CASE WHEN NumValue = 1 THEN 1 ELSE 0 END FROM Configs WHERE ConfigID = 647
SELECT @thismonth = DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,getdate()))),DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate()))

INSERT INTO #rcgv (AccountID,MaxCallDate,Cost,Cnt,RateID,Interim)
SELECT sa.AccountID, MAX(vc.CallDate) AS MaxCallDate, SUM(vc.Cost) AS Cost, COUNT(*) AS Cnt, (SELECT MIN(RateID) FROM Rates WHERE RateClassID=at1.RateClassID AND RateSourceID=4) AS RateID, COALESCE(MAX(cgdi.NumValue),@interim) AS Interim
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (bc.BillingCycleID = ma.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ConfigGroupData cgdi ON (cgdi.GroupID = ma.GroupID AND cgdi.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdd ON (cgdd.GroupID = ma.GroupID AND cgdd.ConfigID = 646)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND vc.ProcDate IS NOT NULL
	AND vc.ChargeID IS NULL
	AND (COALESCE(cgdi.NumValue,@interim) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR vc.CallDate < DATEADD(dd,CASE
	WHEN bc.CycleType IN (1,2) AND (bc.BillDay IS NULL OR bc.BillDay = 1) THEN 0
	WHEN bc.CycleType IN (0,3) AND (ma.BillDay <= 1 OR ma.BillDay >= 28) THEN 0
	WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) - 1
	WHEN bc.CycleType IN (0,3) THEN ma.BillDay - 1 END + 
	CASE WHEN COALESCE(cgdd.NumValue,@delay) <= 1 OR COALESCE(cgdi.NumValue,@interim) = 1 THEN 0 ELSE -(@delay) END,@thismonth))
GROUP BY sa.AccountID, at1.RateClassID

SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID)
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID = 0
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,@interim,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,@delay,1)),DATEADD(mm,-1,getdate())))

UNION ALL

SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID) 
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN MasterAccounts ma ON (rh.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (sa.AccountID = rh.AccountID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID <> 0
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,@interim,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < getdate()
		OR DATEADD(dd,1,sa.CancelDate) < getdate()
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,@delay,1)),DATEADD(mm,-1,getdate())))

UNION ALL

SELECT NULL AS RRDescription, NULL AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, CASE WHEN r.MaxCharge < rcgv.Cost THEN r.MaxCharge ELSE rcgv.Cost END AS TotalCost, ma.CustomerID, sa.AccountID, rcgv.MaxCallDate AS StartDate, ma.CustomerID AS RHCustomerID, NULL AS RateRuleID,
rcgv.RateID, ma.LanguageID, CASE WHEN rcgv.Interim = 1 THEN NULL ELSE r.MinCharge END AS MinCharge, COALESCE(sa.Login,sa.Email) AS Login,
2 AS RBType,rcgv.Cnt AS RecordCount
FROM #rcgv rcgv, SubAccounts sa, MasterAccounts ma, Rates r, ChargeTypes ct
	WHERE rcgv.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND rcgv.RateID = r.RateID
	AND r.ChargeTypeID = ct.ChargeTypeID
ORDER BY 9,11,10,14

DROP TABLE #rcgv

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RateGetCalls AS
SET NOCOUNT ON
DECLARE @LastCallID BIGINT
SELECT @LastCallID = MAX(LastCallID) FROM RateStatusCalls

SELECT ma.GroupID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, c.CallID, c.Username, c.NASIdentifier, c.NASPort, DATEADD(ss,-(c.AcctSessionTime),c.CallDate) AS StartDate, c.AcctSessionTime AS Duration, c.FramedAddress, COALESCE(c.AcctOutputOctets,0) + COALESCE(c.AcctInputOctets,0) AS Data, c.AcctTerminateCause, c.NASPortType, c.NASPortDNIS, c.CallerID, c.ConnectInfo, c.AccountID
FROM Calls c, MasterAccounts ma, SubAccounts sa, AccountTypes at1, BillingCycles bc
	WHERE c.CallID > @LastCallID
	AND c.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND c.AcctStatusType = 2
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL
GO

CREATE PROCEDURE dbo.RateGetVoiceCalls AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.BillDay, ma.GroupID, at1.RateClassID, vc.VoiceCallID,vc.Login,sa.AccountID,vc.CallDate AS StartDate, vc.Duration, vc.SessionRef, vc.CalledNumber, vc.CallingPort, vc.CalledPort, vc.Bytes AS Data, vc.CallType, vc.AcctTerminateCause, vc.Location
FROM VoiceCalls vc, SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE vc.Login = sa.Login
	AND ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active IN (1,0)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND vc.ChargeID IS NULL
	AND vc.ProcDate IS NULL
	AND at1.RateClassID IS NOT NULL

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RateVoiceCallsUP (@AccountID INT,@VoiceCallID BIGINT,@Matched INT, @Cost NUMERIC(28,12)) AS
SET NOCOUNT ON
UPDATE VoiceCalls SET AccountID = COALESCE(AccountID,@AccountID), Cost = CAST(@Cost AS NUMERIC(18,4)), ProcDate = CASE WHEN @Matched = 1 THEN getdate() ELSE NULL END, ErrorCode = CASE WHEN @Matched = 0 THEN 1 ELSE NULL END 
WHERE VoiceCallID = @VoiceCallID
AND ProcDate IS NULL
AND ChargeID IS NULL
GO

CREATE PROCEDURE dbo.RateVoiceCallsClear AS
SET NOCOUNT ON
UPDATE VoiceCalls SET ProcDate = NULL, ErrorCode = NULL WHERE ProcDate IS NOT NULL AND ChargeID IS NULL
GO

CREATE PROCEDURE dbo.RateVoiceCallsLoc AS
SET NOCOUNT ON
UPDATE VoiceCalls SET Location = lp.City, StateID = s.StateID, CountryID = s.CountryID
FROM VoiceCalls vc, LocPhones lp, States s
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 10
	AND SUBSTRING(vc.CalledNumber,1,6) = lp.Prefix
	AND lp.StateID = s.StateID

UPDATE VoiceCalls SET Location = lp.City, StateID = s.StateID, CountryID = s.CountryID
FROM VoiceCalls vc, LocPhones lp, States s
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 11
	AND SUBSTRING(vc.CalledNumber,1,7) = '1' + lp.Prefix
	AND lp.StateID = s.StateID

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND (vc.CalledNumber LIKE '+%' OR vc.CalledNumber LIKE '0%')
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,2,DATALENGTH(c.TelPrefix)) = c.TelPrefix

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,1,DATALENGTH(c.TelPrefix)) = c.TelPrefix

UPDATE VoiceCalls SET CountryID = c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND vc.CalledNumber LIKE '011%'
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,4,DATALENGTH(c.TelPrefix)) = c.TelPrefix
GO

CREATE PROCEDURE dbo.RateHistAll (@RateSourceID INT) AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT rh.StartDate, rh.AccountID,  CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalCost, rh.TotalData
FROM Rates r, RateHistory rh, SubAccounts sa
	WHERE rh.StartDate > DATEADD(dd,-45,getdate())
	AND r.RateID = rh.RateID
	AND rh.AccountID = sa.AccountID
	AND r.RateSourceID = @RateSourceID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RateHistoryUnapplied AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT MIN(r.Description) AS Rate, DATEDIFF(mm,StartDate,getdate()) AS Months, COUNT(*) AS Records, SUM (TotalTime) AS TotalTime, SUM(TotalCost) AS TotalCost, SUM(TotalCount) AS TotalCount, SUM(TotalData) AS TotalData
FROM RateHistory rh, Rates r
	WHERE rh.ChargeID IS NULL
	AND rh.StartDate >= DATEADD(mm,-12,getdate())
	AND r.RateID = rh.RateID
GROUP BY DATEDIFF(mm,StartDate,getdate()), r.RateID
ORDER BY 2,1

SET TRANSACTION ISOLATION LEVEL READ COMMITTED

GO

CREATE PROCEDURE dbo.RateHistUser (@RateSourceID INT, @AccountID INT, @StartDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT rh.StartDate, rh.AccountID, CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalData, rh.TotalCost
FROM Rates r, RateHistory rh, SubAccounts sa
	WHERE rh.StartDate >= @StartDate
	AND r.RateID = rh.RateID
	AND rh.AccountID = sa.AccountID
	AND rh.AccountID = @AccountID
	AND r.RateSourceID = @RateSourceID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RateNetflowResellerClassifier (@Direction INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED


CREATE TABLE #rnrctmp (AccountID INT, CustomerID INT, RateClassID INT, BillDay SMALLINT, IPAddress VARCHAR(64), CollectIP VARCHAR(64))

INSERT INTO #rnrctmp (AccountID, CustomerID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, o.ResellerCustomerID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND o.ResellerCustomerID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2

SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'CustomerID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnrctmp WHERE @Direction IN (2,3)

SET TRANSACTION ISOLATION LEVEL READ COMMITTED

DROP TABLE #rnrctmp
GO

CREATE PROCEDURE dbo.RateNetflowUserClassifier (@Direction INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED


CREATE TABLE #rnuctmp (AccountID INT, RateClassID INT, BillDay SMALLINT, IPAddress VARCHAR(64), CollectIP VARCHAR(64))

INSERT INTO #rnuctmp (AccountID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2

SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM #rnuctmp WHERE @Direction IN (2,3) AND CollectIP IS NOT NULL

SET TRANSACTION ISOLATION LEVEL READ COMMITTED

DROP TABLE #rnuctmp
GO

CREATE PROCEDURE dbo.RateProxyUserClassifier AS
SET NOCOUNT ON
CREATE TABLE #rpuctmp (AccountID INT, RateClassID INT, Data VARCHAR(255))

INSERT INTO #rpuctmp (AccountID, RateClassID, Data)
SELECT sa.AccountID, at1.RateClassID, sad.Data
FROM SubAccountData sad JOIN SubAccounts sa ON (sad.AccountID = sa.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND sad.AccountDataTypeID = 14
	AND at1.RateClassID IS NOT NULL

SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(1 AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp
UNION ALL
SELECT 'Realm' AS Attribute, AccountID AS GroupingID, 1 AS MatchTypeID, Data, NULL AS Cost, NULL AS Priority FROM #rpuctmp

DROP TABLE #rpuctmp

GO

CREATE PROCEDURE dbo.RateStdRules (@RateRuleID INT) AS
SET NOCOUNT ON
SELECT rsi.Attribute, rsi.RateStdGroupID AS GroupingID, rsi.RateMatchTypeID AS MatchTypeID, rsi.Data, rsg.Cost, rsg.Priority
FROM RateStdGroups rsg, RateStdItems rsi
	WHERE rsg.RateStdGroupID = rsi.RateStdGroupID
	AND rsg.RateRuleID = @RateRuleID
UNION ALL
SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost, NULL AS Priority
FROM RateRules WHERE RateRuleID = @RateRuleID

GO

CREATE PROCEDURE dbo.RateUP (@CustomerID INT, @AccountID INT, @RateID INT, @RateRuleID INT, @TotalCount NUMERIC(28,12), @TotalData BIGINT, @TotalTime INT, @TotalCost NUMERIC(28,12), @StartDate DATETIME) AS
SET NOCOUNT ON
DECLARE @MaxStartDate DATETIME, @custid INT
SELECT @custid = CustomerID FROM SubAccounts WHERE AccountID=@AccountID

IF (@custid IS NOT NULL)
BEGIN
UPDATE RateHistory SET TotalCount = TotalCount + @TotalCount, TotalData = TotalData + @TotalData, TotalTime = TotalTime + @TotalTime, TotalCost = TotalCost + @TotalCost
	WHERE StartDate BETWEEN @StartDate AND DATEADD(hh,1,@StartDate)
	AND AccountID = @AccountID
	AND CustomerID = CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END
	AND RateID = @RateID
	AND RateRuleID = @RateRuleID
	AND ChargeID IS NULL

IF (@@ROWCOUNT < 1)
	BEGIN
	SELECT @MaxStartDate = MAX(StartDate) 
	FROM RateHistory 
		WHERE StartDate BETWEEN @StartDate AND DATEADD(hh,1,@StartDate)
		AND AccountID = @AccountID
		AND CustomerID = CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END
		AND RateID = @RateID
		AND RateRuleID = @RateRuleID
	
	INSERT INTO RateHistory (StartDate,AccountID,CustomerID,RateRuleID,RateID,TotalTime,ChargeID,TotalCount,TotalData,TotalCost)
	VALUES(CASE WHEN @MaxStartDate IS NULL THEN @StartDate ELSE DATEADD(mi,1,@MaxStartDate) END, @AccountID, CASE WHEN @CustomerID <= 0 THEN @custid ELSE @CustomerID END, @RateRuleID, @RateID, @TotalTime, NULL, @TotalCount, @TotalData, @TotalCost)
	END
END
GO

CREATE PROCEDURE dbo.RateClassDataLeft (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED 

SELECT	MIN(sa.DataLeft) - (COALESCE(SUM(sp.AcctInputOctets),0) + COALESCE(SUM(sp.AcctOutputOctets),0)) AS DataLeft,
	MIN(sa.TimeLeft) - COALESCE(SUM(DATEDIFF(mi,sp.CallDate,DATEADD(ss,sp.AcctSessionTime,getdate()))),0) AS TimeLeft

FROM SubAccounts sa LEFT JOIN ServerPorts sp ON (sp.AcctStatusType = 1 AND sp.AccountID = @AccountID)
	WHERE sa.AccountID = @AccountID
GO

CREATE PROCEDURE dbo.ReportChurn (@sd DATETIME, @ed DATETIME, @OrganizationID INT, @GroupID INT, @RegionID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @counter INT, @starting DATETIME, @ending DATETIME, @monthcount INT, @isd DATETIME, @ied DATETIME

SELECT @counter = 1, @isd = COALESCE(@sd,DATEADD(mm,-12,getdate())), @ied = COALESCE(@ed,getdate())
SELECT @starting = DATEADD(ss,-((DATEPART(hh,@ied)*3600)+(DATEPART(mi,@ied)*60)+DATEPART(ss,@ied)),DATEADD(dd,-DATEPART(dd,@ied) + 1,@ied))
SELECT @monthcount = DATEDIFF(mm,@isd,@ied)

CREATE TABLE #rcsadiff (CustomerID INT, AccountID INT, PackageID INT, SA INT, SAPrev INT, InvoicedAmount NUMERIC(18,4))
CREATE TABLE #rcmbrdiff (CustomerID INT, MBRTotal INT, MBRNew INT, MBRLost INT, SATotal INT, SANew INT, SALost INT, InvoicedAmount NUMERIC(18,4))
CREATE TABLE #rcdiff (StartDate DATETIME, MBRTotal INT, MBRNew INT, MBRLost INT, SATotal INT, SANew INT, SALost INT, InvoicedAmount NUMERIC(18,4))

WHILE(@counter <= @monthcount)
BEGIN

SELECT @ending = @starting
SELECT @starting = DATEADD(mm,-1,@starting), @counter = @counter + 1

INSERT INTO #rcsadiff (CustomerID, AccountID, PackageID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID,
MAX(CASE WHEN @starting BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,@starting) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN @starting AND @ending THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,@starting)
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID

INSERT INTO #rcmbrdiff (CustomerID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT CustomerID,
MAX(SA) AS MBRTotal,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost,
SUM(SA) AS SATotal,
SUM(CASE WHEN SAPrev = 0 AND SA = 1 THEN 1 ELSE 0 END) AS SANew,
SUM(CASE WHEN SAPrev = 1 AND SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(InvoicedAmount) AS InvoicedAmount
FROM #rcsadiff
GROUP BY CustomerID

INSERT INTO #rcdiff (StartDate, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT @starting, SUM(MBRTotal), SUM(MBRNew), SUM(MBRLost), SUM(SATotal), SUM(SANew), SUM(SALost), SUM(InvoicedAmount)
FROM #rcmbrdiff

DELETE FROM #rcsadiff
DELETE FROM #rcmbrdiff
END

SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost, d1.MBRTotal AS MCount,
d1.SANew AS SAdd, d1.SALost AS SLost, d1.SATotal AS SCount,
d1.InvoicedAmount AS InvAmt,

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) + 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) AS PayAmt

FROM #rcdiff d1
ORDER BY 1,2

DROP TABLE #rcmbrdiff
DROP TABLE #rcsadiff
DROP TABLE #rcdiff
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ReportChurnService (@sd DATETIME, @ed DATETIME, @OrganizationID INT, @GroupID INT, @RegionID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @counter INT, @starting DATETIME, @ending DATETIME, @monthcount INT, @isd DATETIME, @ied DATETIME

SELECT @counter = 1, @isd = COALESCE(@sd,DATEADD(mm,-12,getdate())), @ied = COALESCE(@ed,getdate())
SELECT @starting = DATEADD(ss,-((DATEPART(hh,@ied)*3600)+(DATEPART(mi,@ied)*60)+DATEPART(ss,@ied)),DATEADD(dd,-DATEPART(dd,@ied) + 1,@ied))
SELECT @monthcount = DATEDIFF(mm,@isd,@ied)

CREATE TABLE #rcatsadiff (CustomerID INT, AccountID INT, PackageID INT, AccountTypeID INT, PackageTypeID INT, SA INT, SAPrev INT, InvoicedAmount NUMERIC(18,4))
CREATE TABLE #rcatmbrdiff (CustomerID INT, AccountTypeID INT, PackageTypeID INT, MBRTotal INT, MBRNew INT, MBRLost INT, SATotal INT, SANew INT, SALost INT, InvoicedAmount NUMERIC(18,4))
CREATE TABLE #rcatdiff (StartDate DATETIME, AccountTypeID INT, PackageTypeID INT, MBRTotal INT, MBRNew INT, MBRLost INT, SATotal INT, SANew INT, SALost INT, InvoicedAmount NUMERIC(18,4))

WHILE(@counter <= @monthcount)
BEGIN

SELECT @ending = @starting
SELECT @starting = DATEADD(mm,-1,@starting), @counter = @counter + 1

INSERT INTO #rcatsadiff (CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID,
MAX(CASE WHEN @starting BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,@starting) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN @starting AND @ending THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (ii.AccountID IS NOT NULL OR ii.PackageID IS NOT NULL)
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,@starting)
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID

INSERT INTO #rcatmbrdiff (CustomerID, AccountTypeID, PackageTypeID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT CustomerID, AccountTypeID, PackageTypeID,
MAX(SA) AS MBRTotal,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost,
SUM(SA) AS SATotal,
SUM(CASE WHEN SAPrev = 0 AND SA = 1 THEN 1 ELSE 0 END) AS SANew,
SUM(CASE WHEN SAPrev = 1 AND SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(InvoicedAmount) AS InvoicedAmount
FROM #rcatsadiff
GROUP BY CustomerID, AccountTypeID, PackageTypeID

INSERT INTO #rcatdiff (StartDate, AccountTypeID, PackageTypeID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT @starting, AccountTypeID, PackageTypeID, SUM(MBRTotal), SUM(MBRNew), SUM(MBRLost), SUM(SATotal), SUM(SANew), SUM(SALost), SUM(InvoicedAmount)
FROM #rcatmbrdiff
GROUP BY AccountTypeID, PackageTypeID

DELETE FROM #rcatsadiff
DELETE FROM #rcatmbrdiff
END


SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.AccountTypeID, d1.PackageTypeID, CAST(COALESCE(d1.AccountTypeID,0) AS VARCHAR(32)) + 'z' + CAST(COALESCE(d1.PackageTypeID,0) AS VARCHAR(32)) AS groupref, COALESCE(at1.AccountType,pt.PackageType) AS groupdescr, COALESCE(at1.StringID,pt.StringID) AS groupstringid, at1.AccountType, at1.StringID AS ATStringID, pt.PackageType, pt.StringID AS PTStringID, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost, d1.MBRTotal AS MCount,
d1.SANew AS SAdd, d1.SALost AS SLost, d1.SATotal AS SCount,
d1.InvoicedAmount AS InvAmt,

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.AccountTypeID = ii.AccountTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) +

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.PackageTypeID = ii.PackageTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) +
 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.AccountTypeID = ii.AccountTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) +
 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.PackageTypeID = ii.PackageTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	),0) AS PayAmt

FROM #rcatdiff d1
	LEFT JOIN AccountTypes at1 ON (d1.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt ON (d1.PackageTypeID = pt.PackageTypeID)
ORDER BY 3,4,1,2

DROP TABLE #rcatmbrdiff
DROP TABLE #rcatsadiff
DROP TABLE #rcatdiff
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ReportChurnServiceDetail (@sd DATETIME, @ed DATETIME, @OrganizationID INT, @GroupID INT, @RegionID INT, @AccountTypeID INT, @PackageTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @counter INT, @starting DATETIME, @ending DATETIME, @monthcount INT, @isd DATETIME, @ied DATETIME

SELECT @counter = 1, @isd = COALESCE(@sd,DATEADD(mm,-12,getdate())), @ied = COALESCE(@ed,getdate())
SELECT @starting = DATEADD(ss,-((DATEPART(hh,@ied)*3600)+(DATEPART(mi,@ied)*60)+DATEPART(ss,@ied)),DATEADD(dd,-DATEPART(dd,@ied) + 1,@ied))
SELECT @monthcount = DATEDIFF(mm,@isd,@ied)

CREATE TABLE #rcatdsadiff (CustomerID INT, AccountID INT, PackageID INT, AccountTypeID INT, PackageTypeID INT, SA INT, SAPrev INT, InvoicedAmount NUMERIC(18,4))
CREATE TABLE #rcatdmbrdiff (CustomerID INT, AccountTypeID INT, PackageTypeID INT, MBRNew INT, MBRLost INT)
CREATE TABLE #rcatddiff (StartDate DATETIME, CustomerID INT, AccountID INT, PackageID INT, AccountTypeID INT, PackageTypeID INT, MBRNew INT, MBRLost INT, SANew INT, SALost INT, InvoicedAmount NUMERIC(18,4))
WHILE(@counter <= @monthcount)
BEGIN

SELECT @ending = @starting
SELECT @starting = DATEADD(mm,-1,@starting), @counter = @counter + 1

INSERT INTO #rcatdsadiff (CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID,
MAX(CASE WHEN @starting BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,@starting) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN @starting AND @ending THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (ii.AccountID IS NOT NULL OR ii.PackageID IS NOT NULL)
	AND (@GroupID IS NULL OR @GroupID = ma.GroupID)
	AND (@OrganizationID IS NULL OR @OrganizationID = g.OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,@starting)
	AND (@AccountTypeID IS NULL OR @AccountTypeID = ii.AccountTypeID)
	AND (@PackageTypeID IS NULL OR @PackageTypeID = ii.PackageTypeID)
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID

INSERT INTO #rcatdmbrdiff (CustomerID, AccountTypeID, PackageTypeID, MBRNew, MBRLost)
SELECT CustomerID, AccountTypeID, PackageTypeID,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost
FROM #rcatdsadiff
GROUP BY CustomerID, AccountTypeID, PackageTypeID

INSERT INTO #rcatddiff (StartDate, CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, MBRNew, MBRLost, SANew, SALost, InvoicedAmount)
SELECT @starting, rsa.CustomerID, rsa.AccountID, rsa.PackageID, rsa.AccountTypeID, rsa.PackageTypeID, 
MAX(rma.MBRNew), MAX(rma.MBRLost), 

MAX(CASE WHEN rsa.SAPrev = 0 AND rsa.SA = 1 THEN 1 ELSE 0 END) AS SANew, 
MAX(CASE WHEN rsa.SAPrev = 1 AND rsa.SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(rsa.InvoicedAmount) AS InvoicedAmount

FROM #rcatdsadiff rsa, #rcatdmbrdiff rma
	WHERE rsa.CustomerID = rma.CustomerID

GROUP BY rsa.CustomerID, rsa.AccountID, rsa.PackageID, rsa.AccountTypeID, rsa.PackageTypeID

DELETE FROM #rcatdsadiff
DELETE FROM #rcatdmbrdiff
END

SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.AccountTypeID, d1.PackageTypeID, CAST(COALESCE(d1.AccountTypeID,0) AS VARCHAR(32)) + 'z' + CAST(COALESCE(d1.PackageTypeID,0) AS VARCHAR(32)) AS groupref, COALESCE(at1.AccountType,pt.PackageType) AS groupdescr, COALESCE(at1.StringID,pt.StringID) AS groupstringid, at1.AccountType, at1.StringID AS ATStringID, pt.PackageType, pt.StringID AS PTStringID, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost,
d1.SANew AS SAdd, d1.SALost AS SLost,
d1.InvoicedAmount AS InvAmt, d1.CustomerID, d1.AccountID, d1.PackageID, COALESCE(dsa.FirstName,dma.FirstName) AS FirstName, COALESCE(dsa.LastName,dma.LastName) AS LastName, dma.Company, dsa.Login

FROM #rcatddiff d1 JOIN MasterAccounts dma ON (d1.CustomerID = dma.CustomerID)
	LEFT JOIN SubAccounts dsa ON (d1.AccountID = dsa.AccountID)
	LEFT JOIN AccountTypes at1 ON (d1.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt ON (d1.PackageTypeID = pt.PackageTypeID)
	WHERE (d1.SANew > 0 OR d1.SALost > 0)
ORDER BY 3,4,1,2,15,16,18,19

DROP TABLE #rcatdmbrdiff
DROP TABLE #rcatdsadiff
DROP TABLE #rcatddiff
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ReportCommission (@OrganizationID INT, @GroupID INT, @RegionID INT, @SalesPersonID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON

CREATE TABLE #rcpayp (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4))
CREATE TABLE #rcpaym (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4))
CREATE TABLE #rcinv (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, ItemCount INT, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4))
CREATE TABLE #rcommtmp (Type INT, SalesPerson VARCHAR(128), Item VARCHAR(128), StringID INT, ItemCount INT, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4))

INSERT INTO #rcpayp (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, SUM(pi1.Amount) AS PaidAmount, 
SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2)) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.ActiveDate BETWEEN @StartDate AND @EndDate
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID


INSERT INTO #rcpaym (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, -(SUM(pi1.Amount)) AS PaidAmount,
-(SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2))) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.InactiveDate BETWEEN @StartDate AND @EndDate
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID

INSERT INTO #rcinv (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, ItemCount, InvoicedAmount, InvoicedPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, COUNT(*) AS ItemCount,
SUM(ROUND(ii.Amount * ii.Quantity,2)) AS InvoicedAmount, 
COALESCE(MIN(sp.CommissionValue),1.0000) * SUM(CASE WHEN cg.CommissionType = 1 AND ii.Days <> 0 THEN (ci.CommissionValue * ii.Quantity) / 30
	WHEN cg.CommissionType = 1 AND ii.Days = 0 THEN ci.CommissionValue * ii.Quantity
	WHEN cg.CommissionType = 2 THEN (ROUND(ii.Amount * ii.Quantity,2)) * (ci.CommissionValue/100) END) AS InvoicedPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID AND i.VoidDate IS NULL)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Estimate = 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate <= @EndDate)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID


INSERT INTO #rcommtmp (Type, SalesPerson, Item, StringID, ItemCount, InvoicedAmount, InvoicedPoints, PaidAmount, PaidPoints)
SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
COALESCE(ri.ItemCount,0) AS ItemCount, COALESCE(ri.InvoicedAmount,0) AS InvoicedAmount, COALESCE(ri.InvoicedPoints,0) AS InvoicedPoints,
COALESCE(rp.PaidAmount,0) + COALESCE(rm.PaidAmount,0) AS PaidAmount, 
COALESCE(rp.PaidPoints,0) + COALESCE(rm.PaidPoints,0) AS PaidPoints

FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	LEFT JOIN #rcpayp rp ON (rp.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rp.AccountTypeID OR ci.PackageTypeID = rp.PackageTypeID OR ci.ChargeTypeID = rp.ChargeTypeID))
	LEFT JOIN #rcpaym rm ON (rm.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rm.AccountTypeID OR ci.PackageTypeID = rm.PackageTypeID OR ci.ChargeTypeID = rm.ChargeTypeID))
	LEFT JOIN #rcinv ri ON (ri.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = ri.AccountTypeID OR ci.PackageTypeID = ri.PackageTypeID OR ci.ChargeTypeID = ri.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND (rp.SalesPersonID IS NOT NULL OR rm.SalesPersonID IS NOT NULL OR ri.SalesPersonID IS NOT NULL)

INSERT INTO #rcommtmp (Type,SalesPerson,ItemCount,InvoicedAmount,InvoicedPoints,PaidAmount,PaidPoints)
SELECT 4, SalesPerson, SUM(ItemCount), SUM(InvoicedAmount), SUM(InvoicedPoints), SUM(PaidAmount), SUM(PaidPoints)
FROM #rcommtmp 
GROUP BY SalesPerson

SELECT * 
FROM #rcommtmp
ORDER BY SalesPerson, Type, Item

DROP TABLE #rcommtmp
DROP TABLE #rcpayp
DROP TABLE #rcpaym
DROP TABLE #rcinv
GO

CREATE PROCEDURE dbo.ReportCommissionDetail (@OrganizationID INT, @GroupID INT, @RegionID INT, @SalesPersonID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON

CREATE TABLE #rcdpayp (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INT)
CREATE TABLE #rcdpaym (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INT)
CREATE TABLE #rcdinv (SalesPersonID INT, AccountTypeID INT, PackageTypeID INT, ChargeTypeID INT, ItemCount INT, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), CustomerID INT)
CREATE TABLE #rcdommtmp (Type INT, SalesPerson VARCHAR(128), Item VARCHAR(128), StringID INT, ItemCount INT, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INT)

INSERT INTO #rcdpayp (SalesPersonID, CustomerID,AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, SUM(pi1.Amount) AS PaidAmount, 
SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2)) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.ActiveDate BETWEEN @StartDate AND @EndDate
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID


INSERT INTO #rcdpaym (SalesPersonID, CustomerID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, -(SUM(pi1.Amount)) AS PaidAmount,
-(SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2))) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.InactiveDate BETWEEN @StartDate AND @EndDate
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID


INSERT INTO #rcdinv (SalesPersonID, CustomerID, AccountTypeID, PackageTypeID, ChargeTypeID, ItemCount, InvoicedAmount, InvoicedPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, COUNT(*) AS ItemCount,
SUM(ROUND(ii.Amount * ii.Quantity,2)) AS InvoicedAmount, 
COALESCE(MIN(sp.CommissionValue),1.0000) * SUM(CASE WHEN cg.CommissionType = 1 AND ii.Days <> 0 THEN (ci.CommissionValue * ii.Quantity) / 30
	WHEN cg.CommissionType = 1 AND ii.Days = 0 THEN ci.CommissionValue * ii.Quantity
	WHEN cg.CommissionType = 2 THEN (ROUND(ii.Amount * ii.Quantity,2)) * (ci.CommissionValue/100) END) AS InvoicedPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID AND i.VoidDate IS NULL)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Estimate = 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate <= @EndDate)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID


INSERT INTO #rcdommtmp (Type, CustomerID, SalesPerson, Item, StringID, ItemCount, InvoicedAmount, InvoicedPoints, PaidAmount, PaidPoints)
SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
rp.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
0 AS ItemCount, 0 AS InvoicedAmount, 0 AS InvoicedPoints, rp.PaidAmount, rp.PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN #rcdpayp rp ON (rp.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rp.AccountTypeID OR ci.PackageTypeID = rp.PackageTypeID OR ci.ChargeTypeID = rp.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND rp.SalesPersonID IS NOT NULL

UNION ALL

SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
rm.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
0 AS ItemCount, 0 AS InvoicedAmount, 0 AS InvoicedPoints, rm.PaidAmount, rm.PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN #rcdpaym rm ON (rm.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rm.AccountTypeID OR ci.PackageTypeID = rm.PackageTypeID OR ci.ChargeTypeID = rm.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND rm.SalesPersonID IS NOT NULL

UNION ALL

SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
ri.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
ri.ItemCount, ri.InvoicedAmount, ri.InvoicedPoints AS InvoicedPoints, 0 AS PaidAmount, 0 AS PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN #rcdinv ri ON (ri.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = ri.AccountTypeID OR ci.PackageTypeID = ri.PackageTypeID OR ci.ChargeTypeID = ri.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (@SalesPersonID IS NULL OR sp.SalesPersonID = @SalesPersonID)
	AND ri.SalesPersonID IS NOT NULL


SELECT MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, tmp.CustomerID, MIN(ma.Company) AS Company, tmp.Type, MIN(tmp.SalesPerson) AS SalesPerson, tmp.Item, MIN(tmp.StringID) AS StringID, SUM(tmp.ItemCount) AS ItemCount, SUM(tmp.InvoicedAmount) AS InvoicedAmount, SUM(tmp.InvoicedPoints) AS InvoicedPoints, SUM(tmp.PaidAmount) AS PaidAmount, SUM(tmp.PaidPoints) AS PaidPoints
FROM #rcdommtmp tmp JOIN MasterAccounts ma ON (tmp.CustomerID = ma.CustomerID)
GROUP BY tmp.CustomerID, tmp.Type, tmp.Item

UNION ALL

SELECT NULL AS FirstName, NULL AS LastName, NULL AS CustomerID, NULL AS Company, 4 AS Type, SalesPerson, NULL AS Item, NULL AS StringID, SUM(ItemCount) AS ItemCount, SUM(InvoicedAmount) AS InvoicedAmount, SUM(InvoicedPoints) AS INvoicedPoints, SUM(PaidAmount) AS PaidAmount, SUM(PaidPoints) AS PaidPoints
FROM #rcdommtmp
GROUP BY SalesPerson

ORDER BY 6, 5, 3, 7

DROP TABLE #rcdommtmp
DROP TABLE #rcdpayp
DROP TABLE #rcdpaym
DROP TABLE #rcdinv
GO

CREATE PROCEDURE dbo.ReportForecast (@OrganizationID INT, @GroupID INT, @RegionID INT, @month DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @imonth DATETIME

SELECT @imonth = CASE WHEN @month IS NULL THEN getdate() ELSE @month END
SELECT @imonth = DATEADD(ss,-((DATEPART(hh,@imonth)*3600)+(DATEPART(mi,@imonth)*60)+DATEPART(ss,@imonth)),DATEADD(dd,-DATEPART(dd,@imonth) + 1,@imonth))

CREATE TABLE #fcast (Type INT, Description VARCHAR(128), StringID INT, Services INT, Cost NUMERIC(18,4))

INSERT INTO #fcast (Type,Description,StringID,Services,Cost)
SELECT 0 AS Type, MIN(at1.AccountType) AS Description, MIN(at1.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN sa.DiffCost = 1 THEN sa.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(oat.CustomerCost,at1.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND at1.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > @imonth)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > @imonth)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,sa.ExpireDate,getdate()) <= 1))
	AND DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)  ,@imonth) % pp.Period = 0
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, MIN(pt.PackageType) AS Description, MIN(pt.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN p.DiffCost = 1 THEN p.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(opt.CustomerCost,pt.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.PackageID = p.PackageID AND sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > @imonth))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > @imonth)
	AND (p.CancelDate IS NULL OR p.CancelDate > @imonth)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,p.ExpireDate,getdate()) <= 1))
	AND DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)  ,@imonth) % pp.Period = 0
GROUP BY pt.PackageTypeID

SELECT Type,Description,StringID,Services,Cost 
FROM #fcast
UNION ALL
SELECT 2,NULL,NULL,SUM(Services),SUM(Cost) 
FROM #fcast

DROP TABLE #fcast
GO

CREATE PROCEDURE dbo.ReportForecastDaily (@OrganizationID INT, @GroupID INT, @RegionID INT, @month DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @imonth DATETIME

SELECT @imonth = CASE WHEN @month IS NULL THEN getdate() ELSE @month END
SELECT @imonth = DATEADD(ss,-((DATEPART(hh,@imonth)*3600)+(DATEPART(mi,@imonth)*60)+DATEPART(ss,@imonth)),DATEADD(dd,-DATEPART(dd,@imonth) + 1,@imonth))

CREATE TABLE #fcastd (Day INT, Type INT, Description VARCHAR(128), StringID INT, Services INT, Cost NUMERIC(18,4))

INSERT INTO #fcastd (Day,Type,Description,StringID,Services,Cost)
SELECT DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)), 0 AS Type, MIN(at1.AccountType) AS Description, MIN(at1.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN sa.DiffCost = 1 THEN sa.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(oat.CustomerCost,at1.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND at1.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > @imonth)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > @imonth)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,sa.ExpireDate,getdate()) <= 1))
	AND DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)  ,@imonth) % pp.Period = 0
GROUP BY DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)), at1.AccountTypeID

UNION ALL

SELECT DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)), 1 AS Type, MIN(pt.PackageType) AS Description, MIN(pt.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN p.DiffCost = 1 THEN p.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(opt.CustomerCost,pt.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.PackageID = p.PackageID AND sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > @imonth))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > @imonth)
	AND (p.CancelDate IS NULL OR p.CancelDate > @imonth)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,p.ExpireDate,getdate()) <= 1))
	AND DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)  ,@imonth) % pp.Period = 0
GROUP BY DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)), pt.PackageTypeID

SELECT Day AS Sorter,Day,Type,Description,StringID,Services,Cost 
FROM #fcastd
UNION ALL
SELECT 99,NULL,2,NULL,NULL,SUM(Services),SUM(Cost) 
FROM #fcastd
ORDER BY 1

DROP TABLE #fcastd
GO

CREATE PROCEDURE dbo.ReportGLPayment (@OrganizationID INT, @GroupID INT, @RegionID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

CREATE TABLE #rglpplus (Type INT, ID INT, GLCode VARCHAR(64), Description VARCHAR(128), Amount NUMERIC(18,4), Cnt INT)
CREATE TABLE #rglpminus (Type INT, ID INT, GLCode VARCHAR(64), Description VARCHAR(128), Amount NUMERIC(18,4), Cnt INT)

INSERT INTO #rglpplus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.ActiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.ActiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < @StartDate OR pi1.InactiveDate > @EndDate)
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.ActiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.ActiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < @StartDate OR pi1.InactiveDate > @EndDate)
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.ActiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.ActiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < @StartDate OR pi1.InactiveDate > @EndDate)
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.ActiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.ActiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < @StartDate OR pi1.InactiveDate > @EndDate)
GROUP BY t.TaxID


INSERT INTO #rglpminus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.InactiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.InactiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.ActiveDate < @StartDate OR pi1.ActiveDate > @EndDate)
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.InactiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.InactiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.ActiveDate < @StartDate OR pi1.ActiveDate > @EndDate)
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.InactiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.InactiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.ActiveDate < @StartDate OR pi1.ActiveDate > @EndDate)
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND pi1.PaymentID IS NOT NULL
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR pi1.InactiveDate >= @StartDate)
	AND (@EndDate IS NULL OR pi1.InactiveDate < @EndDate)
	AND (@StartDate IS NULL OR @EndDate IS NULL OR pi1.ActiveDate < @StartDate OR pi1.ActiveDate > @EndDate)
GROUP BY t.TaxID


SELECT 0 AS Type, p.GLCode, p.Description, p.Amount AS Amount, COALESCE(m.Amount,0) AS VoidAmount, p.Amount - COALESCE(m.Amount,0) AS FinalAmount, COALESCE(p.Cnt,0) AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, COALESCE(p.Cnt,0) - COALESCE(m.Cnt,0) AS AdjCount
FROM #rglpplus p LEFT JOIN #rglpminus m ON (p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 0 AS Type, m.GLCode, m.Description, 0 AS Amount, m.Amount AS VoidAmount, -(m.Amount) AS FinalAmount, 0 AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, 0 - COALESCE(m.Cnt,0) AS AdjCount
FROM #rglpminus m WHERE NOT EXISTS (SELECT * FROM #rglpplus p WHERE p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 1 AS Type, p.GLCode, NULL AS Description, SUM(p.Amount), COALESCE((SELECT SUM(Amount) FROM #rglpminus m WHERE m.GLCode = p.GLCode),0) , SUM(p.Amount) - COALESCE((SELECT SUM(Amount) FROM #rglpminus m WHERE m.GLCode = p.GLCode),0), SUM(p.Cnt) AS NewCount, 0 AS VoidCount, SUM(p.Cnt) - 0 AS AdjCount
FROM #rglpplus p
GROUP BY p.GLCode

UNION ALL

SELECT 1 AS Type, m.GLCode, NULL AS Description, 0 AS Amount, SUM(m.Amount), -(SUM(m.Amount)), 0 AS NewCount, SUM(m.Cnt) AS VoidCount, 0 - SUM(m.Cnt) AS AdjCount
FROM #rglpminus m WHERE m.GLCode NOT IN (SELECT p.GLCode FROM #rglpplus p)
GROUP BY m.GLCode

ORDER BY 2,1,3

DROP TABLE #rglpplus
DROP TABLE #rglpminus
GO

CREATE PROCEDURE dbo.ReportGLInvoiced (@OrganizationID INT, @GroupID INT, @RegionID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

CREATE TABLE #irglpplus (Type INT, ID INT, GLCode VARCHAR(64), Description VARCHAR(128), Amount NUMERIC(18,4), Cnt INT)
CREATE TABLE #irglpminus (Type INT, ID INT, GLCode VARCHAR(64), Description VARCHAR(128), Amount NUMERIC(18,4), Cnt INT)

INSERT INTO #irglpplus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate < @EndDate)
	AND i.Processed = 1
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate < @EndDate)
	AND i.Processed = 1
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate < @EndDate)
	AND i.Processed = 1
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.CreateDate >= @StartDate)
	AND (@EndDate IS NULL OR i.CreateDate < @EndDate)
	AND i.Processed = 1
GROUP BY t.TaxID


INSERT INTO #irglpminus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.VoidDate >= @StartDate)
	AND (@EndDate IS NULL OR i.VoidDate < @EndDate)
	AND i.Processed = 1
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.VoidDate >= @StartDate)
	AND (@EndDate IS NULL OR i.VoidDate < @EndDate)
	AND i.Processed = 1
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.VoidDate >= @StartDate)
	AND (@EndDate IS NULL OR i.VoidDate < @EndDate)
	AND i.Processed = 1
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND (@StartDate IS NULL OR i.VoidDate >= @StartDate)
	AND (@EndDate IS NULL OR i.VoidDate < @EndDate)
	AND i.Processed = 1
GROUP BY t.TaxID


SELECT 0 AS Type, p.GLCode, p.Description, p.Amount AS Amount, COALESCE(m.Amount,0) AS VoidAmount, p.Amount - COALESCE(m.Amount,0) AS FinalAmount, COALESCE(p.Cnt,0) AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, COALESCE(p.Cnt,0) - COALESCE(m.Cnt,0) AS AdjCount
FROM #irglpplus p LEFT JOIN #irglpminus m ON (p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 0 AS Type, m.GLCode, m.Description, 0 AS Amount, m.Amount AS VoidAmount, -(m.Amount) AS FinalAmount, 0 AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, 0 - COALESCE(m.Cnt,0) AS AdjCount
FROM #irglpminus m WHERE NOT EXISTS (SELECT * FROM #irglpplus p WHERE p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 1 AS Type, p.GLCode, NULL AS Description, SUM(p.Amount), COALESCE((SELECT SUM(Amount) FROM #irglpminus m WHERE m.GLCode = p.GLCode),0) , SUM(p.Amount) - COALESCE((SELECT SUM(Amount) FROM #irglpminus m WHERE m.GLCode = p.GLCode),0), SUM(p.Cnt) AS NewCount, 0 AS VoidCount, SUM(p.Cnt) - 0 AS AdjCount
FROM #irglpplus p
GROUP BY p.GLCode

UNION ALL

SELECT 1 AS Type, m.GLCode, NULL AS Description, 0 AS Amount, SUM(m.Amount), -(SUM(m.Amount)), 0 AS NewCount, SUM(m.Cnt) AS VoidCount, 0 - SUM(m.Cnt) AS AdjCount
FROM #irglpminus m WHERE m.GLCode NOT IN (SELECT p.GLCode FROM #irglpplus p)
GROUP BY m.GLCode

ORDER BY 2,1,3

DROP TABLE #irglpplus
DROP TABLE #irglpminus
GO

CREATE PROCEDURE dbo.ReportDefRevGL (@OrganizationID INT, @GroupID INT, @RegionID INT, @defstart DATETIME) AS
SET NOCOUNT ON
DECLARE @defdate DATETIME
CREATE TABLE #defrrptgl (DefRatio FLOAT, InvAmount NUMERIC(18,4), PaidBefore NUMERIC(18,4), PaidAfter NUMERIC(18,4), GLCodeID INT)

SELECT @defdate = CASE WHEN @defstart IS NULL OR @defstart > getdate() THEN getdate() ELSE @defstart END

INSERT INTO #defrrptgl (DefRatio,InvAmount,PaidBefore,PaidAfter,GLCodeID)
SELECT CAST(DATEDIFF(dd,CASE WHEN @defdate < ii.StartDate THEN ii.StartDate ELSE @defdate END,ii.EndDate) AS FLOAT) /
CAST(DATEDIFF(dd,ii.StartDate,ii.EndDate) AS FLOAT) AS DefRatio,
ii.Amount * ii.Quantity AS InvAmount,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE (pi1.InactiveDate IS NULL OR pi1.InactiveDate > @defdate) AND pi1.ActiveDate < @defdate AND pi1.ItemID = ii.ItemID),0) AS PaidBefore,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE pi1.InactiveDate IS NULL AND pi1.ActiveDate > @defdate AND pi1.ItemID = ii.ItemID),0) AS PaidAfter,
COALESCE(t.GLCodeID,at1.GLCodeID,pt1.GLCodeID,ct.GLCodeID) AS GLCodeID

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ii.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)

	WHERE (i.VoidDate IS NULL OR i.VoidDate > @defdate)
	AND ii.ItemType = 3
	AND ii.EndDate > @defdate
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.CreateDate < @defdate
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND bc.AutoBill IN (1,0)

SELECT 1 AS SortOrder, def.GLCodeID, MIN(gl.GLCode) AS GLCode,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM #defrrptgl def LEFT JOIN GLCodes gl ON (def.GLCodeID = gl.GLCodeID)
GROUP BY def.GLCodeID

UNION ALL

SELECT 2 AS SortOrder, NULL, NULL,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM #defrrptgl def
ORDER BY 1 ASC,2,3

DROP TABLE #defrrptgl
GO

CREATE PROCEDURE dbo.ReportDefRevDetail (@OrganizationID INT, @GroupID INT, @RegionID INT, @defstart DATETIME) AS
SET NOCOUNT ON
DECLARE @defdate DATETIME
CREATE TABLE #defrrpt (CustomerID INT, InvoiceID INT, Active INT, DefDays INT, DefRatio FLOAT, InvAmount NUMERIC(18,4), PaidBefore NUMERIC(18,4), PaidAfter NUMERIC(18,4), AccountTypeID INT, PackageTypeID INT, AccountID INT, PackageID INT)

SELECT @defdate = CASE WHEN @defstart IS NULL OR @defstart > getdate() THEN getdate() ELSE @defstart END

INSERT INTO #defrrpt (CustomerID,InvoiceID,Active,DefDays,DefRatio,InvAmount,PaidBefore,PaidAfter,AccountTypeID,PackageTypeID,AccountID,PackageID)
SELECT ma.CustomerID, i.InvoiceID, ma.Active,
DATEDIFF(dd,CASE WHEN @defdate < ii.StartDate THEN ii.StartDate ELSE @defdate END,ii.EndDate) AS DefDays,
CAST(DATEDIFF(dd,CASE WHEN @defdate < ii.StartDate THEN ii.StartDate ELSE @defdate END,ii.EndDate) AS FLOAT) /
CAST(DATEDIFF(dd,ii.StartDate,ii.EndDate) AS FLOAT) AS DefRatio,
ii.Amount * ii.Quantity AS InvAmount,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE (pi1.InactiveDate IS NULL OR pi1.InactiveDate > @defdate) AND pi1.ActiveDate < @defdate AND pi1.ItemID = ii.ItemID),0) AS PaidBefore,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE pi1.InactiveDate IS NULL AND pi1.ActiveDate > @defdate AND pi1.ItemID = ii.ItemID),0) AS PaidAfter,
ii.AccountTypeID, ii.PackageTypeID, ii.AccountID, ii.PackageID

FROM MasterAccounts ma, Groups g, BillingCycles bc, Invoices i, InvoiceItems ii
	WHERE ma.GroupID = g.GroupID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND (i.VoidDate IS NULL OR i.VoidDate > @defdate)
	AND ii.ItemType = 3
	AND ii.EndDate > @defdate
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.CreateDate < @defdate
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
	AND (@RegionID IS NULL OR ma.RegionID = @RegionID)
	AND bc.AutoBill IN (1,0)

SELECT 1 AS SortOrder, ma.CustomerID, def.InvoiceID, MIN(ma.Active) AS Active, MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, MIN(ma.Company) AS Company, 
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount

FROM #defrrpt def, MasterAccounts ma 
	WHERE def.CustomerID = ma.CustomerID
GROUP BY ma.CustomerID, def.InvoiceID

UNION ALL

SELECT 2 AS SortOrder, NULL, NULL, NULL, NULL, NULL, NULL,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM #defrrpt def

ORDER BY 1 ASC,2,3

DROP TABLE #defrrpt
GO

CREATE PROCEDURE dbo.ReportTaxPayments (@OrganizationID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON

CREATE TABLE #rtpplus (TaxID INT, ItemCount INT, Amount NUMERIC(18,4), InvAmount NUMERIC(18,4), TaxableAmount NUMERIC(18,4))
CREATE TABLE #rtpminus (TaxID INT, Amount NUMERIC(18,4), InvAmount NUMERIC(18,4), TaxableAmount NUMERIC(18,4))
CREATE TABLE #rtpplusta (TaxID INT, ItemCount INT, TaxableAmount NUMERIC(18,4))
CREATE TABLE #rtpminusta (TaxID INT, TaxableAmount NUMERIC(18,4))

INSERT INTO #rtpplusta (TaxID,ItemCount,TaxableAmount)
SELECT ii.TaxID, COUNT(*), SUM(ROUND(iis.Amount * iis.Quantity,2))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN TaxGroupTaxes tgt ON (ii.TaxID = tgt.TaxID)
	JOIN InvoiceItems iis ON (i.InvoiceID = iis.InvoiceID AND iis.ItemType <> 254 AND iis.Amount > 0 AND iis.Quantity > 0 AND iis.TaxGroupID = tgt.TaxGroupID)
	WHERE ii.ItemType = 254
	AND pi1.ActiveDate BETWEEN @StartDate AND @EndDate
	AND g.OrganizationID = @OrganizationID
GROUP BY ii.TaxID

INSERT INTO #rtpplus (TaxID,ItemCount,Amount,InvAmount,TaxableAmount)
SELECT ii.TaxID, MIN(ta.ItemCount), SUM(pi1.Amount) AS Amount, SUM(i.Amount * (pi1.Amount / ROUND(ii.Amount * ii.Quantity,2))) , MIN(ta.TaxableAmount) * (SUM(pi1.Amount) / SUM(ROUND(ii.Amount * ii.Quantity,2)))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN #rtpplusta ta ON (ii.TaxID = ta.TaxID)
	WHERE ii.ItemType = 254
	AND pi1.ActiveDate BETWEEN @StartDate AND @EndDate
	AND g.OrganizationID = @OrganizationID
GROUP BY ii.TaxID

INSERT INTO #rtpminusta (TaxID,TaxableAmount)
SELECT ii.TaxID, SUM(ROUND(iis.Amount * iis.Quantity,2))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN TaxGroupTaxes tgt ON (ii.TaxID = tgt.TaxID)
	JOIN InvoiceItems iis ON (i.InvoiceID = iis.InvoiceID AND iis.ItemType <> 254 AND iis.Amount > 0 AND iis.Quantity > 0 AND iis.TaxGroupID = tgt.TaxGroupID)
	WHERE ii.ItemType = 254
	AND pi1.InactiveDate BETWEEN @StartDate AND @EndDate
	AND g.OrganizationID = @OrganizationID
GROUP BY ii.TaxID


INSERT INTO #rtpminus (TaxID,Amount,InvAmount,TaxableAmount)
SELECT ii.TaxID, SUM(pi1.Amount) AS Amount,SUM(i.Amount * (pi1.Amount / ROUND(ii.Amount * ii.Quantity,2))), MIN(ta.TaxableAmount) * (SUM(pi1.Amount) / SUM(ROUND(ii.Amount * ii.Quantity,2)))

FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN #rtpminusta ta ON (ii.TaxID = ta.TaxID)
	WHERE ii.ItemType = 254
	AND pi1.InactiveDate BETWEEN @StartDate AND @EndDate
	AND g.OrganizationID = @OrganizationID
GROUP BY ii.TaxID

SELECT t.Description, t.StringID, 
COALESCE(p.Amount,0) AS NewPayments, COALESCE(m.Amount,0) AS VoidedPayments, COALESCE(p.Amount,0) - COALESCE(m.Amount,0) AS AdjustedTotal, 
COALESCE(p.ItemCount,0) AS NewItemCount, COALESCE(p.InvAmount,0) AS NewInvoiced, COALESCE(m.InvAmount,0) AS VoidedInvoiced, COALESCE(p.InvAmount,0) - COALESCE(m.InvAmount,0) AS AdjustedInvoiced,
COALESCE(p.TaxableAmount,0) AS NewTaxable, COALESCE(m.TaxableAmount,0) AS VoidedTaxable, COALESCE(p.TaxableAmount,0) - COALESCE(m.TaxableAmount,0) AS AdjustedTaxable
FROM Taxes t LEFT JOIN #rtpplus p ON (t.TaxID = p.TaxID)
	LEFT JOIN #rtpminus m ON (t.TaxID = m.TaxID)
	WHERE (p.TaxID IS NOT NULL OR m.TaxID IS NOT NULL)

DROP TABLE #rtpplus
DROP TABLE #rtpminus
DROP TABLE #rtpplusta
DROP TABLE #rtpminusta
GO

CREATE PROCEDURE dbo.ResellerUsageUpdate AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @StartYear INT, @StartMonth INT
SELECT @StartYear = DATEPART(yy,getdate()), @StartMonth = DATEPART(mm,getdate())

UPDATE ResellerUsage SET LastUpdate = getdate(), Days = Days + 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND sa.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) AND (sa.ExpireDate IS NULL OR DATEADD(dd,1+sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate())
THEN CAST(DATEDIFF(ss,ru.LastUpdate,getdate()) AS FLOAT)/86400 ELSE 0 END
FROM ResellerUsage ru JOIN SubAccounts sa ON (ru.AccountID = sa.AccountID AND ru.AccountTypeID = sa.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (g.OrganizationID = org.OrganizationID)
	WHERE ru.StartYear = @StartYear
	AND ru.StartMonth = @StartMonth
	AND org.ResellerCustomerID IS NOT NULL
	AND sa.PackageID IS NULL

UPDATE ResellerPkgUsage SET LastUpdate = getdate(), Days = Days + 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND p.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (p.CancelDate IS NULL OR p.CancelDate > getdate()) AND (p.ExpireDate IS NULL OR DATEADD(dd,1+p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate())
THEN CAST(DATEDIFF(ss,ru.LastUpdate,getdate()) AS FLOAT)/86400 ELSE 0 END
FROM ResellerPkgUsage ru JOIN Packages p ON (ru.PackageID = p.PackageID AND ru.PackageTypeID = p.PackageTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (g.OrganizationID = org.OrganizationID)
	WHERE ru.StartYear = @StartYear
	AND ru.StartMonth = @StartMonth
	AND org.ResellerCustomerID IS NOT NULL

INSERT INTO ResellerUsage (StartYear,StartMonth,AccountID,AccountTypeID,Days,LastUpdate)
SELECT @StartYear, @StartMonth, sa.AccountID, sa.AccountTypeID, 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND sa.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) AND (sa.ExpireDate IS NULL OR DATEADD(dd,1+sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= getdate())
THEN CAST(DATEDIFF(ss,DATEADD(dd,-DATEPART(dd,getdate()) + 1,DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())),getdate()) AS FLOAT)/86400 ELSE 0 END,getdate()
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (org.OrganizationID = g.OrganizationID)
	LEFT JOIN ResellerUsage ru ON (ru.StartYear = @StartYear AND ru.StartMonth = @StartMonth AND ru.AccountID = sa.AccountID AND ru.AccountTypeID = sa.AccountTypeID)
	WHERE ru.AccountID IS NULL
	AND org.ResellerCustomerID IS NOT NULL
	AND sa.PackageID IS NULL
	AND sa.Active >= 0
	AND ma.Active >= 0

INSERT INTO ResellerPkgUsage (StartYear,StartMonth,PackageID,PackageTypeID,Days,LastUpdate)
SELECT @StartYear, @StartMonth, p.PackageID, p.PackageTypeID, 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND p.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate()) AND (p.CancelDate IS NULL OR p.CancelDate > getdate()) AND (p.ExpireDate IS NULL OR DATEADD(dd,1+p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= getdate())
THEN CAST(DATEDIFF(ss,DATEADD(dd,-DATEPART(dd,getdate()) + 1,DATEADD(ss,-((DATEPART(hh,getdate())*3600)+(DATEPART(mi,getdate())*60)+DATEPART(ss,getdate())),getdate())),getdate()) AS FLOAT)/86400 ELSE 0 END,getdate()
FROM Packages p JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (org.OrganizationID = g.OrganizationID)
	LEFT JOIN ResellerPkgUsage ru ON (ru.StartYear = @StartYear AND ru.StartMonth = @StartMonth AND ru.PackageID = p.PackageID AND ru.PackageTypeID = p.PackageTypeID)
	WHERE ru.PackageID IS NULL
	AND org.ResellerCustomerID IS NOT NULL
	AND p.Active >= 0
	AND ma.Active >= 0

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.RU_AT AS
SELECT AccountType, rc.AccountTypeID, ra.RadAttributeID, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck, ra.Name
FROM RadATConfigs rc, RadAttributes ra, AccountTypes at1
	WHERE rc.RadAttributeID = ra.RadAttributeID
	AND rc.RadVendorID = ra.RadVendorID
	AND rc.AccountTypeID = at1.AccountTypeID 
ORDER BY rc.AccountTypeID, rc.RadCheck DESC
GO

CREATE PROCEDURE dbo.RU_RATC AS
SELECT sa.Login, sa.Password, att.AccountType, DATEADD(dd,(Extension+COALESCE(ma.OverDue,0)+1), ExpireDate) AS SubExpire
FROM MasterAccounts ma, SubAccounts sa, AccountTypes att
	WHERE ma.CustomerID = sa.CustomerID
 	AND (DateAdd(dd,(Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) >= GetDate() or ExpireDate is NULL)
 	AND sa.Login is not NULL 
	AND sa.Password is not NULL
        AND ma.Active = 1 
	AND sa.Active = 1
	AND sa.AccountTypeID = att.AccountTypeID
	AND NOT EXISTS (SELECT * FROM RadConfigs rc WHERE sa.AccountID = rc.AccountID)
	AND EXISTS (Select * From RadATConfigs rat where sa.AccountTypeID = rat.AccountTypeID)
GO
CREATE PROCEDURE dbo.RU_RC AS
SELECT sa.Login, sa.Password, ra.Name, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck,
DateAdd(dd, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
    From MasterAccounts ma, SubAccounts sa, RadConfigs rc, RadAttributes ra
    Where ma.CustomerID = sa.CustomerID
AND rc.AccountID = sa.AccountID
AND ra.RadAttributeID = rc.RadAttributeID
 	AND sa.Login is not null and sa.Password is not null
 	AND (DateAdd(dd, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate) >= GetDate() or ExpireDate is NULL)
        AND ma.Active = 1 AND sa.Active = 1
   Order BY sa.Login, rc.RadCheck DESC
GO

CREATE PROCEDURE dbo.SACallSearch (@CustomerID INT, @AccountID INT, @StartDate DATETIME, @EndDate DATETIME) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

CREATE TABLE #sacstmp (Calls INT, CallStart DATETIME, Mins NUMERIC(18,4), InMB NUMERIC(18,4), OutMB NUMERIC(18,4), Username VARCHAR(64), Server VARCHAR(64), NASPort VARCHAR(64), ConnectInfo VARCHAR(64), CallerID VARCHAR(64), NASPortDNIS VARCHAR(64), NASIdentifier VARCHAR(64), AcctTerminateCause INT, Cost NUMERIC(18,4), State VARCHAR(64), Country VARCHAR(64), Location VARCHAR(64))
INSERT INTO #sacstmp (Calls,CallStart,Mins,InMB,OutMB,Username,Server,NASPort,ConnectInfo,CallerID,NASPortDNIS,NASIdentifier,AcctTerminateCause)
SELECT 1,DATEADD(ss,-(COALESCE(c.AcctSessionTime,0)),c.CallDate) AS CallStart, (c.AcctSessionTime/60)+1 AS Mins,
CAST(c.AcctInputOctets AS NUMERIC(18,4))/1000000 AS InMB,
CAST(c.AcctOutputOctets AS NUMERIC(18,4))/1000000 AS OutMB,
c.Username, s.Server, c.NASPort, c.ConnectInfo, c.CallerID, c.NASPortDNIS, c.NASIdentifier, c.AcctTerminateCause
FROM Calls c JOIN SubAccounts sa ON (c.AccountID = sa.AccountID)
	LEFT JOIN Servers s ON (c.ServerID = s.ServerID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND c.CallDate BETWEEN @StartDate AND @EndDate
	AND c.AcctStatusType = 2
ORDER BY 2

INSERT INTO #sacstmp (Calls,CallStart,Mins,OutMB,Username,ConnectInfo,CallerID,NASPortDNIS,AcctTerminateCause,Cost,State,Country,Location)
SELECT 1,CallDate,vc.Duration/60.0,Bytes/1000000.0 AS OutMB,vc.Login,vc.CallType,vc.Login,vc.CalledNumber,AcctTerminateCause,vc.Cost,COALESCE(s.Abbreviation,s.State), c.Country, vc.Location
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.AccountID = sa.AccountID)
	LEFT JOIN States s ON (vc.StateID = s.StateID)
	LEFT JOIN Countries c ON (vc.CountryID = c.CountryID)
	WHERE sa.CustomerID = @CustomerID
	AND sa.AccountID = @AccountID
	AND vc.CallDate BETWEEN @StartDate AND @EndDate
	AND vc.ProcDate IS NOT NULL
ORDER BY 2

SELECT Calls,CallStart,Mins,InMB,OutMB,Cost,Username,Server,NASPort,ConnectInfo,CallerID,NASPortDNIS,NASIdentifier,AcctTerminateCause,State,Country,Location,0 AS Summary FROM #sacstmp
UNION ALL
SELECT COUNT(*),NULL,SUM(Mins), SUM(InMB), SUM(OutMB), SUM(Cost), NULL, NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1 FROM #sacstmp

DROP TABLE #sacstmp

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SACustomData (@AccountID INT) AS 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT DISTINCT adt.AccountDataType, COALESCE(adv.ValueData,sad.Data) AS Data, COALESCE(sadt.SortOrder,sadt2.SortOrder,0) AS SortOrder
FROM SubAccounts sa JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	JOIN AccountDataTypes adt ON (sad.AccountDataTypeID = adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (sad.AccountDataTypeID = adv.AccountDataTypeID AND sad.Data = adv.KeyData)
	LEFT JOIN SubAccountDataTypes sadt ON (sa.AccountTypeID = sadt.AccountTypeID AND sad.AccountDataTypeID = sadt.AccountDataTypeID)
	LEFT JOIN SubAccountDataTypes sadt2 ON (sadt2.AccountTypeID IS NULL AND sad.AccountDataTypeID = sadt2.AccountDataTypeID)
	WHERE sad.Data IS NOT NULL
	AND sad.AccountID = @AccountID
	AND adt.AllowSA = 1
ORDER BY 3,1
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SchedStatus AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT s.ScheduleID, ss.Server, ss.ScheduleServerID, s.Description, s.LastStatus, s.LastStart, DATEDIFF(ss,s.LastStart,getdate()) AS Seconds
FROM Schedules s, ScheduleServers ss
	WHERE Status = 1
	AND (s.ScheduleServerID = ss.ScheduleServerID OR s.LockServerID = ss.ScheduleServerID)
ORDER BY ss.Server
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SchedStatusUP (@LastStatus VARCHAR(255), @LastUpdate DATETIME, @LastStart DATETIME, @Status SMALLINT, @ScheduleID INT) AS
UPDATE Schedules SET LastStatus = @LastStatus, LastUpdate = @LastUpdate, LastStart = @LastStart, Status = @Status
	WHERE Active = 1
	AND ScheduleID = @ScheduleID
GO

CREATE PROCEDURE dbo.PKGDetail (@PackageID INT) AS
SET NOCOUNT ON
SELECT p.CustomerID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE pt.Cost END AS Cost,
CASE WHEN p.DiffCost = 1 THEN 'Yes' ELSE 'No' END AS StaticCost,
pt.PackageType,di.Discount,p.CreateDate,p.StartDate, p.Comments,p.ExpireDate, p.CancelDate,
p.BilledThru, PayPeriod, p.LastModifyUser, p.LastModifyDate, cr.CancelReason, cr.StringID AS CancelReasonStringID,
CASE WHEN ma.Active = 0 THEN 4 WHEN p.Active = 0 THEN 5 WHEN p.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) < getdate() THEN 3 ELSE 1 END AS Status

FROM Packages p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN PackageTypes pt ON (pt.PackageTypeID = p.PackageTypeID)
	JOIN Discounts di ON (p.DiscountID = di.DiscountID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN CancelReasons cr ON (p.CancelReasonID = cr.CancelReasonID)
	WHERE p.PackageID = @PackageID
GO

CREATE PROCEDURE dbo.SADetail (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT sa.CustomerID, sa.FirstName, sa.LastName, sa.Login,sa.Password,sa.Email,sa.MaidenName,sa.PhoneHome,sa.PhoneWork,
CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE at1.Cost END AS Cost,
CASE WHEN sa.DiffCost = 1 THEN 1 ELSE 0 END AS StaticCost,
sa.SendBill, sa.Preferred, sa.RemoteAccess,
CASE WHEN ma.Active = 0 THEN 4 WHEN p.Active = 0 THEN 5 WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate() THEN 3 ELSE 1 END AS Status,
at1.AccountType,at1.AccountTypeID,COALESCE(di.Discount,'None') AS Discount,sa.CreateDate,sa.StartDate,
sa.Comments,sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS TimeLeft,(sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, sa.LoginLimit,sa.ExpireDate,
sa.BilledThru, PayPeriod, sa.LastModifyUser, 
sa.LastModifyDate, cr.CancelReason, cr.StringID AS CancelReasonStringID, sa.CancelDate, pt.PackageType, es.Message, es.ErrorCount,
CASE WHEN es.ExternalSystemID IS NOT NULL THEN (SELECT Name FROM ExternalSystems WHERE ExternalSystemID = es.ExternalSystemID) ELSE NULL END AS ESName, d.MailDomain, ria.IPAddress AS StaticIP, sa.Operator
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Discounts di ON (sa.DiscountID = di.DiscountID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN RadIPAddresses ria ON (sa.AccountID = ria.AccountID)
	LEFT JOIN CancelReasons cr ON (sa.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	LEFT JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID AND es.ErrorCount > 0)
	WHERE sa.AccountID = @AccountID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SAFormTemplate (@AccountTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT act.LoginLabel, act.LoginStringID, act.SAEdit, act.SANew, act.SASave, act.CustNew, act.CustSave
FROM AccountTypes at1, AccountTemplates act
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID = @AccountTypeID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SignupFormTemplate (@PackageTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT act.SignupPage, act.SignupForm, act.SignupValidate, act.SignupSave, act.SignupBillSave, act.LoginLabel, act.LoginStringID
FROM AccountTypes at1, PackageTypes pt, AccountTemplates act
	WHERE pt.PrimaryAccountTypeID = at1.AccountTypeID
	AND at1.AccountTemplateID = act.AccountTemplateID
	AND pt.CustomerSignup = 1
	AND pt.PackageTypeID = @PackageTypeID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SAEmail (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT 0 AS Type, AliasID AS ID, AccountID, Alias AS Email
FROM Aliases 
	WHERE AccountID = @AccountID
UNION ALL
SELECT 1 AS Type, ForwardID AS ID, AccountID, Forward AS Email
FROM Forwards 
	WHERE AccountID = @AccountID
Order By Email, Type
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SAFindCustomerID (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CASE WHEN at1.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS SetupCharge,CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Status,CASE WHEN sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 ELSE 0 END AS Active,ma.GroupID,g.OrganizationID,sa.CustomerID,sa.FirstName,sa.LastName,COALESCE(sa.Login,sa.Email) as Login, Password, at1.AccountTypeID, ma.BillDay
FROM SubAccounts sa,MasterAccounts ma, AccountTypes at1, Groups g
	WHERE sa.AccountID=@AccountID
	AND sa.CustomerID=ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.AccountTypeID=at1.AccountTypeID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SAGetCustomFields (@AccountTypeID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT COALESCE(MIN(sadt.Required),0) AS Required, MIN(adt.RegExp) AS RegExp, MIN(adt.StringID) AS StringID, MIN(adt.AccountDataType) AS AccountDataType,adt.AccountDataTypeID,MIN(sadt.SortOrder) AS SortOrder,MIN(adt.DataTypeID) AS DataTypeID
FROM AccountDataTypes adt, SubAccountDataTypes sadt
	WHERE adt.AccountDataTypeID=sadt.AccountDataTypeID
	AND adt.AllowSA=1
	AND (sadt.AccountTypeID IS NULL OR sadt.AccountTypeID=@AccountTypeID)
GROUP BY adt.AccountDataTypeID
UNION ALL
SELECT COALESCE(MIN(esdt.Required),0) AS Required, MIN(adt.RegExp) AS RegExp, MIN(adt.StringID) AS StringID, MIN(adt.AccountDataType) AS AccountDataType,adt.AccountDataTypeID,MIN(esdt.SortOrder) AS SortOrder,MIN(adt.DataTypeID) AS DataTypeID
FROM AccountDataTypes adt, ExternalSystemAccountTypes esat, ExternalSystems es, ExternalSystemDataTypes esdt
	WHERE esat.AccountTypeID=@AccountTypeID
	AND esat.ExternalSystemID=es.ExternalSystemID
	AND esdt.AccountDataTypeID=adt.AccountDataTypeID
	AND es.ExternalSystemTypeID=esdt.ExternalSystemTypeID
	AND adt.AccountDataTypeID NOT IN (SELECT AccountDataTypeID FROM SubAccountDataTypes WHERE AccountTypeID=@AccountTypeID OR AccountTypeID IS NULL)
GROUP BY adt.AccountDataTypeID
ORDER BY 6,4
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SAList (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT sa.PackageID, pt.PackageType, AccountID,Login,sa.FirstName,sa.LastName,AccountType,sa.Email, 

CASE WHEN sa.PackageID IS NULL THEN
CASE WHEN sa.Active=1 AND sa.CancelDate IS NOT NULL THEN 'canceled' WHEN sa.Active=1 AND sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'expired'
WHEN sa.Active=1 THEN 'active' ELSE 'inactive' END  
ELSE
CASE WHEN sa.Active=1 AND p.Active=1 AND (sa.CancelDate IS NOT NULL OR p.CancelDate IS NOT NULL) THEN 'canceled' WHEN sa.Active=1 AND p.Active=1 AND sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+COALESCE(p.Extension,sa.Extension)+1,sa.ExpireDate) < getdate() THEN 'expired'
WHEN sa.Active=1 AND p.Active=1 THEN 'active' ELSE 'inactive' END  
END AS bginfo,
CASE WHEN p.DiffCost = 1 THEN p.Cost WHEN p.DiffCost = 0 THEN pt.Cost WHEN sa.DiffCost = 1 THEN sa.Cost ELSE COALESCE(oat1.CustomerCost,at1.Cost) END AS Cost,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE COALESCE(pp2.PayPeriod,pp.PayPeriod) END AS PayPeriod, 
CASE WHEN sa.Active = 0 AND p.BilledThru IS NOT NULL THEN p.BilledThru ELSE sa.BilledThru END AS BilledThru,
CASE WHEN sa.Active = 0 AND p.ExpireDate IS NOT NULL THEN p.ExpireDate ELSE sa.ExpireDate END AS ExpireDate,
COALESCE(ma.OverDue,0)+COALESCE(p.Extension,sa.Extension) AS ExpirePlus

FROM MasterAccounts ma JOIN SubAccounts sa ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN OrgAccountTypes oat1 ON (at1.AccountTypeID = oat1.AccountTypeID AND o.OrganizationID = oat1.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	LEFT JOIN PayPeriods pp2 ON (p.PayPeriodID = pp2.PayPeriodID)
	WHERE ma.CustomerID=@CustomerID
	AND sa.Active >= 0
	AND (p.Active IS NULL OR p.Active >= 0)
ORDER BY COALESCE(sa.PackageID,0) ASC, Login, sa.LastName
GO

CREATE PROCEDURE dbo.SAOpen (@AccountID INT, @PackageID INT, @StartDate DATETIME) AS
DECLARE @GroupID INT, @Extension INT, @FreePeriod INT, @Breakout INT, @CustomerID INT, @PID INT, @AccountTypeID INT
SET NOCOUNT ON

SELECT @FreePeriod = NumValue FROM Configs WHERE ConfigID = 8
SELECT @Extension = NumValue FROM Configs WHERE ConfigID = 5

IF (@AccountID IS NOT NULL)
BEGIN
SELECT @Breakout = 0, @CustomerID = CustomerID, @PID = PackageID, @AccountTypeID = AccountTypeID FROM SubAccounts WHERE AccountID = @AccountID
IF (@PID IS NOT NULL)
	BEGIN
	SELECT @Breakout = CASE WHEN MAX(p.Active) <= 0 THEN 1 WHEN COALESCE(MAX(pat.MaxQty),0) >= COUNT(*) THEN 0 ELSE 1 END
	FROM SubAccounts sa JOIN Packages p ON (sa.PackageID = p.PackageID)
		 LEFT JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND sa.AccountTypeID = pat.AccountTypeID)
		WHERE sa.CustomerID = @CustomerID
		AND sa.AccountTypeID = @AccountTypeID
		AND sa.Active = 1
		AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate()) 
		AND sa.PackageID = @PID
	END

UPDATE SubAccounts SET Active=1, BillStatus=CASE WHEN @Breakout = 1 OR p.PackageID IS NULL THEN 1 ELSE 0 END, CancelDate = NULL, CancelReasonID = NULL,
PackageID=CASE WHEN @Breakout = 1 THEN NULL ELSE p.PackageID END,
LastModifyDate=getdate(),
StartDate=CASE WHEN @Breakout = 1 OR p.PackageID IS NULL THEN @StartDate ELSE COALESCE(p.StartDate,sa.StartDate) END, 
BilledThru=CASE WHEN @Breakout = 0 AND p.PackageID IS NOT NULL THEN COALESCE(p.BilledThru,sa.BilledThru) ELSE DATEADD(dd,COALESCE(cg.NumValue,@FreePeriod,0) - 1,@StartDate) END,
ExpireDate=CASE WHEN @Breakout = 0 AND p.PackageID IS NOT NULL THEN p.ExpireDate WHEN bc.AutoBill = 1 THEN NULL ELSE DATEADD(dd,COALESCE(cg.NumValue,@FreePeriod,0) - 1,@StartDate) END,
LoginLimit = at1.LoginLimit, TimeLeft = at1.TimeLeft, DataLeft = at1.DataLeft,
Extension = CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(bc.Extension,cg5.NumValue,@Extension,sa.Extension) END
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ConfigGroupData cg ON (g.GroupID = cg.GroupID AND cg.ConfigID = 8)
	LEFT JOIN ConfigGroupData cg5 ON (g.GroupID = cg5.GroupID AND cg5.ConfigID = 5)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.AccountID = @AccountID

END

IF (@PackageID IS NOT NULL)
BEGIN
UPDATE Packages SET Active=1, BillStatus = 1, CancelDate = NULL, CancelReasonID = NULL, StartDate = @StartDate,
BilledThru = DATEADD(dd,COALESCE(cg.NumValue,@FreePeriod,0) - 1,@StartDate),
LastModifyDate = getdate(),
ExpireDate = CASE WHEN bc.AutoBill = 1 THEN NULL ELSE DATEADD(dd,COALESCE(cg.NumValue,@FreePeriod,0) - 1,@StartDate) END
FROM Packages p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cg ON (g.GroupID = cg.GroupID AND cg.ConfigID = 8)
	WHERE p.PackageID = @PackageID

UPDATE SubAccounts SET BillStatus = 0, StartDate = COALESCE(p.StartDate,sa.StartDate), BilledThru = COALESCE(p.BilledThru,sa.BilledThru), ExpireDate = p.ExpireDate, LoginLimit = at1.LoginLimit, TimeLeft = at1.TimeLeft, DataLeft = at1.DataLeft, Extension = CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(bc.Extension,cg5.NumValue,@Extension,sa.Extension) END, LastModifyDate = getdate()
FROM SubAccounts sa JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cg5 ON (g.GroupID = cg5.GroupID AND cg5.ConfigID = 5)
	WHERE sa.CustomerID = p.CustomerID
	AND p.PackageID = @PackageID
	AND sa.Active = 1

END
SELECT CASE WHEN @PackageID IS NOT NULL THEN 1 WHEN @AccountID IS NOT NULL AND @PID IS NULL THEN 1 WHEN @AccountID IS NOT NULL AND @PID IS NOT NULL AND @Breakout = 1 THEN 1 ELSE 0 END AS SetupInd
GO

CREATE PROCEDURE dbo.SAPackageCloseList (@PackageID INT, @CancelDate DATETIME) AS
SET NOCOUNT ON
SELECT ii.ItemID, ii.Amount, ii.Quantity, ii.StartDate, ii.EndDate, ii.Days, pt.ChangeClose, pt.ChangeFrom, pt.PackageTypeID, p.BilledThru, ma.CustomerID, ma.LanguageID
FROM MasterAccounts ma, Packages p, Invoices i, InvoiceItems ii, PackageTypes pt
	WHERE ma.CustomerID = p.CustomerID
	AND p.PackageID = @PackageID
	AND p.PackageTypeID = pt.PackageTypeID
	AND ma.Active = 1
	AND p.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.PackageID = @PackageID
	AND ii.StartDate <> ii.EndDate
	AND ii.EndDate > @CancelDate
	AND i.VoidDate IS NULL
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.Canceled = 0
ORDER BY ii.StartDate
GO

CREATE PROCEDURE dbo.SAPackageUpdate (@CustomerID INT) AS
UPDATE SubAccounts SET BilledThru = p.BilledThru, ExpireDate = p.ExpireDate
FROM MasterAccounts ma, SubAccounts sa, Packages p
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.CustomerID = p.CustomerID
	AND sa.PackageID = p.PackageID
	AND ma.Active = 1
	AND sa.Active = 1
	AND p.Active = 1
	AND ma.CustomerID = @CustomerID

GO


CREATE PROCEDURE dbo.SARadius (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT rc.RadConfigID, ra.Name, rc.Data, CASE WHEN ra.RadAttributeType <> 0 THEN COALESCE(rv.Name,CAST(rc.Value AS VARCHAR(10))) ELSE '' END AS Data2,
rc.Value, rc.RadAttributeID, rvend.Name AS VendorName,ra.RadVendorID, 
CASE WHEN rc.RadCheck=1 Then 'Check' ELSE 'Reply' END AS RadCheckStr, RadCheck, rc.Tag
FROM RadConfigs rc
LEFT JOIN RadValues rv ON (rv.Value = rc.Value AND rv.RadVendorID = rc.RadVendorID AND rv.RadAttributeID = rc.RadAttributeID)
JOIN RadAttributes ra ON (rc.RadAttributeID = ra.RadAttributeID AND rc.RadVendorID = ra.RadVendorID)
JOIN RadVendors rvend ON (rvend.RadVendorID = rc.RadVendorID)
	WHERE rc.AccountID=@AccountID
ORDER BY ra.RadVendorID, ra.RadAttributeID
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
GO

CREATE PROCEDURE dbo.SAServiceCloseList (@AccountID INT, @CancelDate DATETIME) AS
SET NOCOUNT ON
SELECT ii.ItemID, ii.Amount, ii.Quantity, ii.StartDate, ii.EndDate, ii.Days, at1.ChangeClose, at1.ChangeFrom, at1.AccountTypeID, sa.BilledThru, ma.CustomerID, ma.LanguageID
FROM MasterAccounts ma, SubAccounts sa, Invoices i, InvoiceItems ii, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = @AccountID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.AccountID = @AccountID
	AND ii.StartDate <> ii.EndDate
	AND ii.EndDate > DATEADD(dd,CASE WHEN DATEPART(hh,@CancelDate) = 0 AND DATEPART(mi,@CancelDate) = 0 AND DATEPART(ss,@CancelDate) = 0 THEN 0 ELSE -1 END,@CancelDate)
	AND i.VoidDate IS NULL
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.Canceled = 0
ORDER BY ii.StartDate
GO

CREATE PROCEDURE dbo.SAUsage (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft, SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft
FROM SubAccountUsages
	WHERE AccountID = @AccountID
	AND ExpireDate > getdate()
	AND (TimeLeft > 0 OR DataLeft > 0)
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ScheduleGetOnetime (@ServerID INT) AS
SET NOCOUNT ON
SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,1 AS MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID = @ServerID) OR ScheduleServerID = @ServerID)
	AND ((Status = 0) OR (Status = 1 AND (LockServerID = @ServerID OR ScheduleServerID = @ServerID)))
	AND Interval = 0
	AND Active = 1
GO
CREATE PROCEDURE dbo.ScheduleGetRecurring (@ServerID INT) AS
SET NOCOUNT ON
SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID = @ServerID) OR ScheduleServerID = @ServerID)
	AND Interval > 0
	AND Active = 1
GO
CREATE PROCEDURE dbo.ScheduleLocks AS
SET NOCOUNT ON
SELECT ScheduleID,TaskName
FROM Schedules
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL
	AND Active = 1

GO
CREATE PROCEDURE dbo.ScheduleLog (@ScheduleServerID INT, @ScheduleID INT, @Status TINYINT, @Description VARCHAR(255), @StartDate DATETIME, @EndDate DATETIME) AS
INSERT INTO ScheduleLogs (ScheduleServerID,ScheduleID,Status,Description,StartDate,EndDate)
VALUES(@ScheduleServerID,@ScheduleID,@Status,@Description, @StartDate,@EndDate)
UPDATE Schedules SET LastUpdate = @EndDate,  Status = @Status, LastStatus = @Description
	WHERE ScheduleID = @ScheduleID
	AND (LastUpdate <= @EndDate OR LastUpdate IS NULL)
GO
CREATE PROCEDURE dbo.ScheduleSetLock (@ServerID INT, @ScheduleID INT) AS
UPDATE Schedules SET LockServerID = @ServerID 
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL 
	AND ScheduleID = @ScheduleID

GO
CREATE PROCEDURE dbo.ScheduleStaleLocks AS
UPDATE Schedules SET LockServerID = NULL
	WHERE ScheduleServerID IS NULL
	AND LockServerID IS NOT NULL
	AND ((Interval = 0 AND Status = 0 AND DATEADD(hh,1,StartDate) < getdate()) 
		OR (Status = 1 AND DATEADD(hh,1,LastUpdate) < getdate()) 
		OR (Interval > 0 AND Status <> 1 AND LastUpdate < DATEADD(hh,-1,DATEADD(ss,-(Interval),getdate())))
	)
UPDATE Schedules SET LockServerID = NULL WHERE ScheduleServerID IS NOT NULL AND LockServerID IS NOT NULL
GO

CREATE PROCEDURE dbo.ScheduleStatusClear (@servername VARCHAR(32)) AS
UPDATE Schedules SET Status = 0
WHERE ScheduleID IN (SELECT s.ScheduleID 
FROM Schedules s, ScheduleServers ss 
	WHERE Status = 1 
	AND (s.ScheduleServerID = ss.ScheduleServerID OR s.LockServerID = ss.ScheduleServerID) 
	AND ss.Server = @servername)
GO

CREATE PROCEDURE dbo.SecurityGetAllowedHosts AS
SET NOCOUNT ON
SELECT OperatorGroupID,IPAddress
FROM AllowedHosts
GO

CREATE PROCEDURE dbo.SecurityGetGroupAccess AS
SET NOCOUNT ON
SELECT OperatorGroupID,GroupID,ObjectGroupID,AccessType
FROM OperatorGroupAccess
GO

CREATE PROCEDURE dbo.SecurityGetObjectGroups AS
SET NOCOUNT ON
SELECT DISTINCT ObjectGroupID,ObjectTypeID,Data,NULL AS Value
FROM Objects
	WHERE ObjectTypeID = 1
UNION ALL
SELECT DISTINCT ObjectGroupID,ObjectTypeID, mt.TableName, o.Value
FROM Objects o, MetaTables mt
	WHERE o.ObjectTypeID = 2
	AND mt.MetaTableID = o.Value
UNION ALL
SELECT DISTINCT ObjectGroupID,ObjectTypeID, mt.TableName + '.' + mc.ColumnName, o.Value
FROM Objects o, MetaTables mt, MetaColumns mc
	WHERE o.ObjectTypeID = 3
	AND mc.MetaColumnID = o.Value
	AND mc.MetaTableID = mt.MetaTableID
GO

CREATE PROCEDURE dbo.SetMetaColumnRule (@tabname VARCHAR(64), @colname VARCHAR(64), @ruleid INT) AS
UPDATE MetaColumns SET MetaRuleID=@ruleid
WHERE MetaColumnID IN (SELECT mc.MetaColumnID
FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID 
	AND mt.TableName = @tabname 
	AND mc.ColumnName = @colname)
GO

CREATE PROCEDURE dbo.SetMetaTableKey (@tabname VARCHAR(64), @colname VARCHAR(64), @req INT) AS
UPDATE MetaColumns SET IsKey=1, Required=@req, Nullable=0 
WHERE MetaColumnID IN (SELECT mc.MetaColumnID
FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID 
	AND mt.TableName = @tabname 
	AND mc.ColumnName = @colname)
GO

CREATE PROCEDURE dbo.ShowBillingSend (@OperatorGroupID INT) AS
SET NOCOUNT ON
DECLARE @batchglobal INT, @zerostmt INT, @zeroinv INT
IF (@OperatorGroupID = 1)
BEGIN
SELECT @batchglobal = 1
END ELSE BEGIN
SELECT @batchglobal = COUNT(*) 
FROM OperatorGroupAccess 
	WHERE ObjectGroupID = 106 
	AND OperatorGroupID = @OperatorGroupID 
	AND GroupID = 1
END

SELECT @zerostmt = NumValue FROM Configs WHERE ConfigID = 38
SELECT @zeroinv = NumValue FROM Configs WHERE ConfigID = 507

CREATE TABLE #sbstmp (GroupID INT NULL, Type INT NULL, PrintCount INT NULL, EmailCount INT NULL, PrintAmount NUMERIC(18,4) NULL, EmailAmount NUMERIC(18,4) NULL, AutoSend INT NULL)

INSERT INTO #sbstmp (GroupID, Type, PrintCount, PrintAmount, EmailCount, EmailAmount,AutoSend)
SELECT ma.GroupID, 20 AS Type,
SUM(CASE WHEN g.PrintStatements = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR s.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,@zerostmt) = 0 AND s.EndBal <= 0) OR sm.PrintTypeID IS NULL OR s.PrintDate IS NOT NULL THEN 0 ELSE 1 END) AS PrintCount,
SUM(CASE WHEN g.PrintStatements = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR s.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,@zerostmt) = 0 AND s.EndBal <= 0) OR sm.PrintTypeID IS NULL OR s.PrintDate IS NOT NULL THEN 0 ELSE s.EndBal END) AS PrintAmount,
SUM(CASE WHEN g.AutoEmailStatements = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,@zerostmt) = 0 AND s.EndBal <= 0) OR sm.EmailTypeID IS NULL OR s.EmailDate IS NOT NULL THEN 0 ELSE 1 END) AS EmailCount,
SUM(CASE WHEN g.AutoEmailStatements = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,@zerostmt) = 0 AND s.EndBal <= 0) OR sm.EmailTypeID IS NULL OR s.EmailDate IS NOT NULL THEN 0 ELSE s.EndBal END) AS EmailAmount,
MAX(CASE WHEN g.AutoEmailStatements = 1 THEN 1 ELSE 0 END) AS AutoSend
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Statements s ON (ma.LastStatementID = s.StatementID AND ma.CustomerID = s.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 38)
	WHERE ma.Active = 1
	AND (s.EmailDate IS NULL OR (s.PrintDate IS NULL AND g.PrintStatements IS NULL))
	AND (@batchglobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))
GROUP BY ma.GroupID
UNION ALL
SELECT ma.GroupID, 10 AS Type,
SUM(CASE WHEN g.PrintInvoices = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR i.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,@zeroinv) = 0 AND i.Amount <= 0) OR sm.PrintTypeID IS NULL OR i.PrintDate IS NOT NULL THEN 0 ELSE 1 END) AS PrintCount,
SUM(CASE WHEN g.PrintInvoices = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR i.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,@zeroinv) = 0 AND i.Amount <= 0) OR sm.PrintTypeID IS NULL OR i.PrintDate IS NOT NULL THEN 0 ELSE i.Amount END) AS PrintAmount,
SUM(CASE WHEN g.AutoEmailInvoices = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,@zeroinv) = 0 AND i.Amount <= 0) OR sm.EmailTypeID IS NULL OR i.EmailDate IS NOT NULL THEN 0 ELSE 1 END) AS EmailCount,
SUM(CASE WHEN g.AutoEmailInvoices = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,@zeroinv) = 0 AND i.Amount <= 0) OR sm.EmailTypeID IS NULL OR i.EmailDate IS NOT NULL THEN 0 ELSE i.Amount END) AS EmailAmount,
MAX(CASE WHEN g.AutoEmailInvoices = 1 THEN 1 ELSE 0 END) AS AutoSend
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 507)
	WHERE ma.Active = 1
	AND i.CreateDate > DATEADD(dd,-45,getdate())
	AND i.VoidDate IS NULL
	AND (i.EmailDate IS NULL OR (i.PrintDate IS NULL AND g.PrintInvoices IS NULL))
	AND (@batchglobal = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID = @OperatorGroupID))
GROUP BY ma.GroupID

INSERT INTO #sbstmp (GroupID,Type,PrintCount,EmailCount,PrintAmount,EmailAmount)
SELECT NULL AS GroupID, Type, SUM(PrintCount) AS PrintCount, SUM(EmailCount) AS EmailCount, SUM(PrintAmount) AS PrintAmount, SUM(EmailAmount) AS EmailAmount
FROM #sbstmp GROUP BY Type

SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 1 AS SendType, 20 AS Type, NULL AS Cnt, NULL AS Amt 
FROM #sbstmp t
	WHERE PrintCount > 0 
	AND Type = 20
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, NULL AS Class, 1 AS SendType, Type, PrintCount AS Cnt, PrintAmount AS Amt
FROM #sbstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND t.PrintCount > 0
	AND t.Type = 20
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 2 AS SendType, 20 AS Type, NULL AS Cnt, NULL AS Amt 
FROM #sbstmp 
	WHERE EmailCount > 0 
	AND Type = 20
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, CASE WHEN g.GroupID IS NULL THEN 'billing_all' WHEN t.AutoSend = 1 THEN 'inactive' ELSE NULL END AS Class, 2 AS SendType, Type, EmailCount AS Cnt, EmailAmount AS Amt
FROM #sbstmp t LEFT JOIN Groups g ON (t.GroupID = g.GroupID)
	LEFT JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE t.EmailCount > 0
	AND t.Type = 20
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 1 AS SendType, 10 AS Type, NULL AS Cnt, NULL AS Amt 
FROM #sbstmp 
	WHERE PrintCount > 0 
	AND Type = 10
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, NULL AS Class, 1 AS SendType, Type, PrintCount AS Cnt, PrintAmount AS Amt
FROM #sbstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND t.PrintCount > 0
	AND t.Type = 10
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 2 AS SendType, 10 AS Type, NULL AS Cnt, NULL AS Amt 
FROM #sbstmp 
	WHERE EmailCount > 0 
	AND Type = 10
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, CASE WHEN g.GroupID IS NULL THEN 'billing_all' WHEN t.AutoSend = 1 THEN 'inactive' ELSE NULL END AS Class, 2 AS SendType, Type, EmailCount AS Cnt, EmailAmount AS Amt
FROM #sbstmp t LEFT JOIN Groups g ON (t.GroupID = g.GroupID)
	LEFT JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE t.EmailCount > 0
	AND t.Type = 10

DROP TABLE #sbstmp
GO

CREATE PROCEDURE dbo.ShowDuplicateLogins (@sdate datetime, @edate datetime) AS 
SET NOCOUNT ON
Select rl.LogDate, rl.Username, rl.NASIdentifier as FNASID, rl.NASPort as FPort,
	c.NASIdentifier as ONASIdentifier, c.NASPort as OPort, c.AcctSessionID as ASID,
	DATEADD(ss, 0-c.AcctSessionTime, c.CallDate) as OnlineStart, CallDate as OnlineEnd,
	AcctSessionTime/60 as Mins, rl.CallerID as FCallerID, c.CallerID as OCallerID
From RadLogs rl, Calls c
Where rl.Username = c.Username
	and c.AcctStatusType = 2
	and c.CallDate >= rl.LogDate
	and DateAdd(ss, 0-c.AcctSessionTime, c.CallDate) <= rl.LogDate
	and rl.RadLogMsgID = 14 
	and rl.LogDate between @sdate and @edate
	and c.CallDate between DateAdd(dd, -1, @sdate) and DateAdd(dd, 1, @edate)
UNION
Select rl.LogDate, rl.Username, rl.NASIdentifier as FNASID, rl.NASPort as FPort,
	c.NASIdentifier as ONASIdentifier, c.Port as OPort, c.AcctSessionID as ASID,
	c.CallDate as OnlineStart, CallDate as OnlineEnd,
	DateDiff(ss,CallDate, GetDate()) as Mins, rl.CallerID as FCallerID, c.CallerID as OCallerID
From RadLogs rl, ServerPorts c
Where rl.Username = c.Username
	and c.AcctStatusType = 1
	and c.CallDate <= rl.LogDate
	and rl.RadLogMsgID = 14 
	and rl.LogDate between @sdate and @edate
	and c.CallDate between DateAdd(dd, -1, @sdate) and DateAdd(dd, 1, @edate)
ORDER BY 1, 7
GO

CREATE PROCEDURE dbo.SPIDQuery (@spid INT) AS
SET NOCOUNT ON
DBCC INPUTBUFFER(@spid) WITH NO_INFOMSGS
GO
CREATE PROCEDURE dbo.StatementAdd (@BatchID INT, @CustomerID INT, @PrevBal NUMERIC(18,4), @NewCharges NUMERIC(18,4), @NewCredits NUMERIC(18,4), @EndBal NUMERIC(18,4)) AS
SET NOCOUNT ON
INSERT INTO Statements (BatchID,CustomerID,StatementDate,PrevBal,NewCharges,NewCredits,EndBal,End0Bal,End30Bal,End60Bal,End90Bal,End120Bal)
VALUES(@BatchID,@CustomerID,getdate(),@PrevBal,@NewCharges,@NewCredits,@EndBal,0,0,0,0,0)

SELECT @@IDENTITY AS StatementID
GO

CREATE PROCEDURE dbo.StatementEmailList (@GroupID INT, @OperatorGroupID INT, @MBRGlobal INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT g.BillPhone, g.BillFax, ma.Company, ma.FirstName, ma.LastName, g.BillName, ma.CustomerID, s.StatementID, CASE WHEN sm.EmailTypeID = 16 THEN COALESCE(g.StatementTextReport,'estatement.rpt') ELSE COALESCE(g.StatementReport,'statement.rpt') END AS ReportFile,
'{Statements.StatementID}=' + CAST(s.StatementID AS VARCHAR(16)) AS Formula
FROM MasterAccounts ma, SendMethods sm, Statements s, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.LastStatementID = s.StatementID
	AND s.EmailDate IS NULL
	AND sm.EmailTypeID IS NOT NULL
	AND g.AutoEmailStatements IN (0,1)
	AND ma.GroupID = g.GroupID
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND ((@OperatorGroupID IS NULL AND g.AutoEmailStatements = 1) OR (@OperatorGroupID IS NOT NULL AND (COALESCE(@MBRGlobal,1) = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=106 AND OperatorGroupID=@OperatorGroupID))))
GO

CREATE PROCEDURE dbo.StatementEmailSent (@CustomerID INT, @StatementID INT) AS
SET NOCOUNT ON
UPDATE Statements SET EmailDate=getdate() WHERE EmailDate IS NULL AND StatementID = @StatementID
INSERT INTO MailLogs (LogDate, LogMsgID, CustomerID, TokenID) 
VALUES(getdate(), 1002,@CustomerID,@StatementID)
GO

CREATE PROCEDURE dbo.StatementItems (@CustomerID INT) AS
SET NOCOUNT ON
SELECT 1 AS ItemType, i.InvoiceID AS ItemID, ii.Amount * Quantity AS Amount, ii.Login AS Info, ii.Description, ii.StartDate, ii.EndDate
FROM Invoices i, InvoiceTypes it, InvoiceItems ii
	WHERE i.CustomerID = @CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.VoidDate IS NULL
	AND i.StatementID IS NULL
 UNION ALL
SELECT 0 AS ItemType, p.PaymentID AS ItemID, p.Amount, p.PayInfo AS Info, pt.PaymentType + '  Payment ' + p.CheckNumber AS Description, p.CreateDate AS StartDate, NULL AS EndDate
FROM Payments p, PaymentTypes pt
	WHERE p.PaymentTypeID = pt.PaymentTypeID
	AND p.CustomerID = @CustomerID
	AND p.StatementID IS NULL
ORDER BY 1, 6
GO

CREATE PROCEDURE dbo.StatementPreview (@CustomerID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 0 AS SortOrder, pt.PaymentType AS Type, pt.StringID AS TypeStringID, PaymentID AS ID, CASE WHEN p.FinalAmount = 0 THEN 1 ELSE 0 END AS Void,
CASE WHEN FinalAmount IS NOT NULL AND StatementID IS NOT NULL THEN p.FinalAmount - p.Amount WHEN FinalAmount IS NOT NULL THEN FinalAmount ELSE Amount END AS Credit, NULL AS Charge,
CASE WHEN p.FinalAmount IS NOT NULL THEN p.FinalCreateDate ELSE p.CreateDate END AS CreateDate, NULL AS StartDate, NULL AS EndDate,
p.CheckNumber, p.PayInfo, NULL AS Login, NULL AS Description
FROM Payments p, PaymentTypes pt
	WHERE p.CustomerID = @CustomerID
	AND p.PaymentTypeID = pt.PaymentTypeID
	AND (StatementID IS NULL OR FinalAmount IS NOT NULL AND FinalStatementID IS NULL)

UNION ALL

SELECT 1 AS SortOrder, iit.InvoiceItemType AS Type, iit.StringID AS TypeStringID, i.InvoiceID AS ID, CASE WHEN i.VoidDate IS NOT NULL THEN 1 ELSE 0 END AS Void,
CASE WHEN ii.ItemType = 1 THEN ROUND(ii.Amount * ii.Quantity,2) WHEN ii.Amount * ii.Quantity < 0 THEN -(ROUND(ii.Amount * ii.Quantity,2)) ELSE NULL END AS Credit,
CASE WHEN ii.ItemType <> 1 AND ii.Amount * ii.Quantity >= 0 THEN ROUND(ii.Amount * ii.Quantity,2) ELSE NULL END AS Charge,
NULL AS CreateDate, ii.StartDate, ii.EndDate, NULL AS CheckNumber, NULL AS PayInfo, ii.Login, ii.Description

FROM Invoices i, InvoiceItems ii, InvoiceItemTypes iit
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ii.ItemType = iit.InvoiceItemTypeID
	AND (i.StatementID IS NULL OR i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL)
	AND i.CustomerID = @CustomerID
ORDER BY 1, 4, 2

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.StringsGet (@appname VARCHAR(32), @ver INT) AS
SET NOCOUNT ON
SELECT s.StringID, CASE s.LanguageID WHEN 1 THEN NULL ELSE s.LanguageID END as LanguageID, a.AppName, s.Data, NULL AS URL, l.BaseURL
FROM Applications a, Strings s, Languages l
WHERE a.ApplicationID = s.ApplicationID
	AND s.LanguageID = l.LanguageID
	AND (a.ApplicationID = 1 OR a.AppName = @appname)
GO

CREATE PROCEDURE dbo.SysLog (@crc SMALLINT, @severity TINYINT, @facility TINYINT, @srcip VARCHAR(32), @date DATETIME, @msg VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO SysLogs (LogDate,Severity,Facility,IPAddress,Data)
VALUES(@date,@severity,@facility,@srcip,@msg)
GO

CREATE PROCEDURE dbo.SysLogGetFilter AS
SET NOCOUNT ON
SELECT IPAddress,Severity,SubString 
FROM SysLogFilters
GO

CREATE PROCEDURE dbo.TaskES (@esid INT) AS
SET NOCOUNT ON
SELECT et.ExportID, e.FormatDefault AS Type, COALESCE(et.LogFile,e.DefaultProcessorURL) AS LogFile, et.FileMode, et.Name, et.Login, et.Password
FROM ExternalSystems et, Exports e 
	WHERE et.ExportID = e.ExportID
	AND et.ExternalSystemID = @esid
GO

CREATE PROCEDURE dbo.TaskESUpdate (@esid INT, @date DATETIME) AS 
UPDATE ExternalSystems SET LastSyncDate = @date 
	WHERE ExternalSystemID = @esid
GO

CREATE PROCEDURE dbo.TaxesGet AS
SET NOCOUNT ON
SELECT t.TaxTypeID, tgt.TaxGroupID, t.TaxID, t.TaxExemptions, tgt.StateID, tgt.CountryID, tgt.RegionID, tgt.City, tgt.Zip, t.Description, t.StringID, t.Tax, t.AmountType, t.CumulativeType, t.FloorLimit, t.CeilingLimit, t.TaxPiggyBackID, t.TaxPigOrder, t.TaxCredits
FROM TaxGroupTaxes tgt, Taxes t
	WHERE tgt.TaxID = t.TaxID
ORDER BY tgt.TaxGroupID, t.TaxTypeID, CASE WHEN tgt.StateID IS NOT NULL THEN 1 ELSE 0 END + CASE WHEN tgt.RegionID IS NOT NULL THEN 1 ELSE 0 END + CASE WHEN tgt.City IS NOT NULL AND tgt.Zip IS NOT NULL THEN 3 WHEN tgt.City IS NOT NULL THEN 1 WHEN tgt.Zip IS NOT NULL THEN 2 ELSE 0 END ASC, t.TaxPiggyBackID DESC, t.TaxPigOrder DESC
GO

CREATE PROCEDURE dbo.ThemeGet AS
SET NOCOUNT ON
SELECT t.Theme, ThemeMatchTypeID, Data, Score
FROM ThemeFilters tf, Themes t
	WHERE t.ThemeID = tf.ThemeID
UNION ALL
SELECT t.Theme, 6 AS ThemeMatchTypeID, CAST(g.GroupID AS VARCHAR(32)) AS Data, 1000100 AS Score
FROM Groups g, Themes t
	WHERE g.ThemeID = t.ThemeID
UNION ALL
SELECT t.Theme, 5 AS ThemeMatchTypeID, CAST(o.OperatorID AS VARCHAR(32)) AS Data, 1000000 AS Score
FROM Operators o, Themes t
	WHERE o.ThemeID = t.ThemeID
GO

CREATE PROCEDURE dbo.ThemeDetail (@ThemeID INT) AS
SET NOCOUNT ON
SELECT tf.ThemeFilter,tmt.ThemeMatchType,tf.Data,tf.Score
FROM ThemeFilters tf, ThemeMatchTypes tmt
	WHERE tf.ThemeMatchTypeID = tmt.ThemeMatchTypeID
	AND tf.ThemeID = @ThemeID
UNION ALL
SELECT 'Billing Groups','Group Match',GroupName, 1000100 AS Score
FROM Groups
	WHERE ThemeID = @ThemeID
UNION ALL
SELECT 'Operators','Operator Match',Operator, 1000000 AS Score
FROM Operators
	WHERE ThemeID = @ThemeID
GO

CREATE PROCEDURE dbo.TrimCalls AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @stoponly INT, @calls INT, @MaxCallID BIGINT, @stopdate datetime, @callsdate datetime
SELECT @calls = NumValue FROM Configs WHERE ConfigID = 205
SELECT @stoponly = NumValue FROM Configs WHERE ConfigID = 206
SELECT @stopdate = DATEADD(dd,-(@stoponly),getdate()), @callsdate= DATEADD(dd,-(@calls),getdate())

CREATE TABLE #trimaxelist (CallID BIGINT)

INSERT INTO #trimaxelist (CallID)
SELECT CallID FROM Calls WHERE AcctStatusType IN (1,3) AND CallDate < @stopdate AND @stoponly > 0 AND @stoponly IS NOT NULL
UNION
SELECT CallID FROM Calls WHERE CallDate < @callsdate AND @calls > 0 AND @calls IS NOT NULL

DELETE FROM Calls
FROM Calls c, #trimaxelist a
	WHERE c.CallID = a.CallID

IF (@calls > 60)
BEGIN
DELETE FROM VoiceCalls WHERE CallDate < @callsdate
END

DROP TABLE #trimaxelist
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.TrimLogs AS
DECLARE @radlogs INT, @auditlogs INT, @syslogs INT, @logs INT, @schedlogs INT, @serverports INT, @ftplogs INT, @transdays INT, @inactdays INT
SELECT @radlogs = NumValue FROM Configs WHERE ConfigID = 200
SELECT @schedlogs = NumValue FROM Configs WHERE ConfigID = 201
SELECT @auditlogs = NumValue FROM Configs WHERE ConfigID = 202
SELECT @syslogs = NumValue FROM Configs WHERE ConfigID = 203
SELECT @logs = NumValue FROM Configs WHERE ConfigID = 204
SELECT @serverports = NumValue FROM Configs WHERE ConfigID = 207
SELECT @ftplogs = NumValue FROM Configs WHERE ConfigID = 208
SELECT @transdays = NumValue FROM Configs WHERE ConfigID = 209
SELECT @inactdays = NumValue FROM Configs WHERE ConfigID = 210

IF (@radlogs IS NOT NULL AND @radlogs <> 0)
	BEGIN
	DELETE FROM RadLogs WHERE LogDate < DATEADD(dd,-(@radlogs),getdate())
	END
IF (@auditlogs IS NOT NULL AND @auditlogs <> 0)
	BEGIN
	DELETE FROM AuditLogs WHERE LogDate < DATEADD(dd,-(@auditlogs),getdate()) 
	END
IF (@syslogs IS NOT NULL AND @syslogs <> 0)
	BEGIN
	DELETE FROM SysLogs WHERE LogDate < DATEADD(dd,-(@syslogs),getdate()) 
	END
IF (@logs IS NOT NULL AND @logs <> 0)
	BEGIN
	DELETE FROM Logs WHERE LogDate < DATEADD(dd,-(@logs),getdate()) 
	END
IF (@schedlogs IS NOT NULL AND @schedlogs <> 0)
	BEGIN
	DELETE FROM ScheduleLogs WHERE EndDate < DATEADD(dd,-(@schedlogs),getdate())
	DELETE FROM ScheduleLogs WHERE ScheduleID IN (SELECT ScheduleID FROM Schedules WHERE Interval = 0 AND (StartDate IS NULL OR StartDate < DATEADD(dd,-(@schedlogs),getdate())) AND LastModifyDate < DATEADD(dd,-(@schedlogs),getdate()))
	DELETE FROM Schedules WHERE Interval = 0 AND (StartDate IS NULL OR StartDate < DATEADD(dd,-(@schedlogs),getdate())) AND LastModifyDate < DATEADD(dd,-(@schedlogs),getdate())
	END
IF (@serverports IS NOT NULL AND @serverports <> 0)
	BEGIN
	DELETE FROM ServerPorts
		WHERE CallDate < DATEADD(dd,-(@serverports),getdate())
		AND (SNMPUser IS NULL OR DATALENGTH(SNMPUser) <= 10 OR CallDate < DATEADD(dd,-365,getdate()))
		AND AcctStatusType = 2
		AND (Port IS NULL OR Port NOT IN (SELECT sa.Port FROM ServerAccess sa WHERE ServerPorts.Port = sa.Port AND sa.ServerID = ServerPorts.ServerID))
	END
IF (@ftplogs IS NOT NULL AND @ftplogs <> 0)
	BEGIN
	DELETE FROM FileTransfers WHERE TransferDate < DATEADD(dd,-(@ftplogs),getdate())
	END

DELETE FROM OperatorCookies WHERE LastUsed < DATEADD(dd,-3,GETDATE())

UPDATE RadIPAddresses SET AccountID = NULL, State = 0 WHERE AccountID IN (SELECT sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, RadIPAddresses ria
	WHERE ma.CustomerID = sa.CustomerID
	AND ria.AccountID = sa.AccountID
	AND (ma.Active IN (0,-1) OR sa.Active IN (0,-1) OR ma.CancelDate < DATEADD(dd,-1,getdate()) OR sa.CancelDate < DATEADD(dd,-1,getdate())))

UPDATE SubAccounts SET DomainID = g.DomainID
FROM SubAccounts sa, MasterAccounts ma, Groups g, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND ma.Active = -1
	AND d.CustomerID IS NOT NULL

IF (@transdays > 0)
BEGIN
UPDATE ExternalTrans SET AccountNumber = NULL, SSN = NULL, DLNumber = NULL, AuthSecurityCode = NULL
	WHERE TransStateID IN (3,8,9)
	AND COALESCE(ProcDate,ReqDate) < DATEADD(dd,-@transdays,getdate())
	AND (AccountNumber IS NOT NULL OR SSN IS NOT NULL OR DLNumber IS NOT NULL OR AuthSecurityCode IS NOT NULL)

UPDATE ExternalTrans SET AccountNumber = NULL, SSN = NULL, DLNumber = NULL, AuthSecurityCode = NULL
	WHERE TransStateID = 4
	AND COALESCE(ProcDate,ReqDate) < DATEADD(dd,-CASE WHEN @transdays < 180 THEN 180 ELSE @transdays END,getdate())
	AND (AccountNumber IS NOT NULL OR SSN IS NOT NULL OR DLNumber IS NOT NULL OR AuthSecurityCode IS NOT NULL)
END

IF (@inactdays > 0)
BEGIN
UPDATE ExternalTrans SET AccountNumber = NULL, SSN = NULL, DLNumber = NULL, AuthSecurityCode = NULL
FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND (et.AccountNumber IS NOT NULL OR et.SSN IS NOT NULL OR et.DLNumber IS NOT NULL OR et.AuthSecurityCode IS NOT NULL)
	AND ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-@inactdays,getdate())

UPDATE SubAccounts SET Password = NULL
FROM SubAccounts sa, MasterAccounts ma
	WHERE ma.CustomerID = sa.CustomerID
	AND (sa.Active IN (0,-1) OR ma.Active IN (0,-1))
	AND sa.Password IS NOT NULL
	AND ma.LastModifyDate < DATEADD(dd,-@inactdays,getdate())
	AND sa.LastModifyDate < DATEADD(dd,-@inactdays,getdate())

DELETE FROM CreditCards WHERE CustomerID IN (SELECT CustomerID FROM MasterAccounts ma
	WHERE ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-@inactdays,getdate()))

DELETE FROM BankTrans WHERE CustomerID IN (SELECT CustomerID FROM MasterAccounts ma
	WHERE ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-@inactdays,getdate()))
END
GO

CREATE PROCEDURE dbo.Update_TimeLeft (@accountid INT, @customerid INT) AS
SET NOCOUNT ON
DECLARE @option INT, @counter INT

SELECT @option = NumValue FROM Configs WHERE ConfigID = 504
SELECT @option = COALESCE(@option,1)

CREATE TABLE #utsa (AccountID INT, TimeLeft INT, DataLeft BIGINT)

IF (@accountid IS NULL AND @customerid IS NULL)
BEGIN

INSERT INTO #utsa (AccountID, TimeLeft, DataLeft)
SELECT sa.AccountID, CASE WHEN sa.TimeLeft < 0 THEN sa.TimeLeft END, CASE WHEN sa.DataLeft < 0 THEN sa.DataLeft END
FROM MasterAccounts ma, SubAccounts sa
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (sa.TimeLeft < 0 OR sa.DataLeft < 0)
UNION ALL
SELECT sau.AccountID, CASE WHEN sau.TimeLeft < 0 THEN sau.TimeLeft ELSE 0 END, CASE WHEN sau.DataLeft < 0 THEN sau.DataLeft ELSE 0 END
FROM SubAccountUsages sau
	WHERE (TimeLeft < 0 OR DataLeft < 0)

UPDATE SubAccounts SET TimeLeft = CASE WHEN TimeLeft < 0 THEN 0 ELSE TimeLeft END, DataLeft = CASE WHEN DataLeft < 0 THEN 0 ELSE DataLeft END
	WHERE Active = 1
	AND (TimeLeft < 0 OR DataLeft < 0)

SELECT @counter = @@ROWCOUNT

WHILE (@counter > 0)
BEGIN

UPDATE SubAccountUsages SET TimeLeft = CASE WHEN TimeLeft < 0 THEN 0 ELSE TimeLeft END, DataLeft = CASE WHEN DataLeft < 0 THEN 0 ELSE DataLeft END
	WHERE (TimeLeft < 0 OR DataLeft < 0)

UPDATE SubAccountUsages SET TimeLeft = TimeLeft + (SELECT SUM(ut.TimeLeft) FROM #utsa ut WHERE ut.AccountID=SubAccountUsages.AccountID)
	WHERE SubAccountUsageID IN (SELECT MIN(sau2.SubAccountUsageID) FROM #utsa ut, SubAccountUsages sau2
		WHERE ut.AccountID=sau2.AccountID
		AND sau2.TimeLeft > 0
		AND sau2.ExpireDate > DATEADD(mi,-COALESCE(sau2.TimeLeft+1440,1440),getdate())
		GROUP BY ut.AccountID)
SELECT @counter = @@ROWCOUNT

UPDATE SubAccountUsages SET DataLeft = DataLeft + (SELECT SUM(ut.DataLeft) FROM #utsa ut WHERE ut.AccountID=SubAccountUsages.AccountID)
	WHERE SubAccountUsageID IN (SELECT MIN(sau2.SubAccountUsageID) FROM #utsa ut, SubAccountUsages sau2
		WHERE ut.AccountID=sau2.AccountID
		AND sau2.DataLeft > 0
		AND sau2.ExpireDate > DATEADD(dd,-1,getdate())
		GROUP BY ut.AccountID)

SELECT @counter = @counter + @@ROWCOUNT

IF (@counter > 0)
BEGIN
DELETE FROM #utsa

INSERT INTO #utsa (AccountID, TimeLeft, DataLeft)
SELECT AccountID, CASE WHEN TimeLeft < 0 THEN TimeLeft ELSE 0 END, CASE WHEN DataLeft < 0 THEN DataLeft ELSE 0 END
FROM SubAccountUsages
	WHERE (TimeLeft < 0 OR DataLeft < 0)
END

END

DELETE FROM SubAccountUsages 
	WHERE ExpireDate < DATEADD(dd,-5,getdate()) 
	OR (TimeLeft <= 0 AND DataLeft <= 0)
	OR (TimeLeft IS NULL AND DataLeft IS NULL)

UPDATE SubAccounts
SET	DataLeft = CASE WHEN sa.DataLeft > at1.DataLeft THEN sa.DataLeft ELSE at1.DataLeft END,
	LastDataLeftDate = getdate()
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 504)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND bc.AutoBill <> 2
	AND COALESCE(cgd.NumValue,@option) <> 0
	AND (at1.DataLeftRenewal = 2 OR ((COALESCE(sa.LastDataLeftDate,sa.LastTimeLeftDate) < DATEADD(dd,-33,getdate()) OR ((DATEPART(dd,GETDATE()) = ma.BillDay) OR ((DATEPART(mm,GETDATE()) <> DATEPART(mm,DATEADD(dd,1,GETDATE()))) AND DATEPART(dd,GETDATE()) <= ma.BillDay)))))
	AND sa.DataLeft IS NOT NULL
	AND at1.DataLeft IS NOT NULL
	AND COALESCE(sa.LastDataLeftDate,sa.LastTimeLeftDate) <= DATEADD(hh,-22,getdate())
	AND (at1.DataLeftRenewal IS NULL OR at1.DataLeftRenewal IN (1,2))
	AND (COALESCE(cgd.NumValue,@option) = 1 OR (COALESCE(cgd.NumValue,@option) = 2 AND (sa.ExpireDate > getdate() OR ((sa.DiffCost=1 AND sa.Cost <= 0) OR (d.AmountType = 0 AND (at1.Cost*d.Amount) <= 0) OR (d.AmountType = 1 AND at1.Cost <= d.Amount)) )))

UPDATE SubAccounts
SET	TimeLeft = CASE WHEN sa.TimeLeft > at1.TimeLeft THEN sa.TimeLeft ELSE at1.TimeLeft END,
	LastTimeLeftDate = getdate()
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 504)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND bc.AutoBill <> 2
	AND COALESCE(cgd.NumValue,@option) <> 0
	AND (at1.TimeLeftRenewal = 2 OR ((sa.LastTimeLeftDate < DATEADD(dd,-33,getdate()) OR ((DATEPART(dd,GETDATE()) = ma.BillDay) OR ((DATEPART(mm,GETDATE()) <> DATEPART(mm,DATEADD(dd,1,GETDATE()))) AND DATEPART(dd,GETDATE()) <= ma.BillDay)))))
	AND sa.TimeLeft IS NOT NULL
	AND at1.TimeLeft IS NOT NULL
	AND sa.LastTimeLeftDate <= DATEADD(hh,-22,getdate())
	AND (at1.TimeLeftRenewal IS NULL OR at1.TimeLeftRenewal IN (1,2))
	AND (COALESCE(cgd.NumValue,@option) = 1 OR (COALESCE(cgd.NumValue,@option) = 2 AND (sa.ExpireDate > getdate() OR ((sa.DiffCost=1 AND sa.Cost <= 0) OR (d.AmountType = 0 AND (at1.Cost*d.Amount) <= 0) OR (d.AmountType = 1 AND at1.Cost <= d.Amount)) )))


END

DROP TABLE #utsa

GO

CREATE PROCEDURE dbo.UpdateServerHistory AS
INSERT INTO ServerHistory (ServerID, HistoryDate, Calls)
SELECT ServerID, GetDate(), COUNT(*) 
FROM ServerPorts 
	WHERE AcctStatusType=1 
GROUP BY ServerID
GO

CREATE PROCEDURE dbo.UpdateStatementAging (@sid INT, @custid INT) AS
SET NOCOUNT ON
DECLARE @Age0 NUMERIC(18,4), @Age30 NUMERIC(18,4), @Age60 NUMERIC(18,4), @Age90 NUMERIC(18,4), @Age120 NUMERIC(18,4), @MinAmount NUMERIC(18,4), @MaxAmount NUMERIC(18,4), @Amount NUMERIC(18,4), @Percentage NUMERIC(18,4), @ChargeTypeID INT,  @Description VARCHAR(64), @StatementDate DATETIME, @TaxGroupID INT, @TaxExemptions INT, @DueDate DATETIME

SELECT @Age0 = SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,getdate()) AND getdate() THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END), @Age30 = SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,getdate()) AND DATEADD(dd,-30,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END), @Age60 = SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,getdate()) AND DATEADD(dd,-60,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END), @Age90 = SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,getdate()) AND DATEADD(dd,-90,getdate()) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END), @Age120 = SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,getdate())THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END)
FROM Invoices i, InvoiceItems ii, MasterAccounts ma
WHERE i.InvoiceID = ii.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND i.CustomerID = @custid
	AND ii.Amount > 0
	AND i.Processed = 1
	AND i.Estimate = 0
	AND i.VoidDate IS NULL
GROUP BY ma.CustomerID

SELECT @DueDate = MIN(ii.StartDate)
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.CustomerID = @custid
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ii.ItemType = 3
	AND i.CreateDate > DATEADD(yy,-1,getdate())
	AND ii.PaidAmount < (ROUND(ii.Amount * ii.Quantity,2))

UPDATE Statements SET DueDate = COALESCE(DueDate,@DueDate), End0Bal = COALESCE(@Age0,0), End30Bal = COALESCE(@Age30,0), End60Bal = COALESCE(@Age60,0), End90Bal = COALESCE(@Age90,0), End120Bal = COALESCE(@Age120,0)
WHERE StatementID = @sid

SELECT @Amount = MAX(CASE WHEN lf.MinDays <= 30 THEN s.End30Bal ELSE 0 END + CASE WHEN lf.MinDays <= 60 THEN s.End60Bal ELSE 0 END + CASE WHEN lf.MinDays <= 90 THEN s.End90Bal ELSE 0 END + CASE WHEN lf.MinDays <= 120 THEN s.End120Bal ELSE 0 END), @Percentage = MAX(lf.Percentage), @ChargeTypeID = MAX(lf.ChargeTypeID), @Description = COALESCE(MAX(st.Data),MAX(ct.Description),'Late Fee'), @MinAmount = MAX(lf.MinAmount), @MaxAmount = MAX(lf.MaxAmount),@StatementDate = MAX(s.StatementDate), @TaxGroupID = MAX(ct.TaxGroupID), @TaxExemptions = MAX(ct.TaxExemptions)
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN LateFees lf ON (bc.LateFeeID = lf.LateFeeID)
	JOIN ChargeTypes ct ON (lf.ChargeTypeID = ct.ChargeTypeID)
	JOIN Statements s ON (s.StatementID = @sid AND ma.CustomerID = s.CustomerID)
	LEFT JOIN Strings st ON (ma.LanguageID = st.LanguageID AND st.StringID = ct.StringID)
	WHERE ma.CustomerID = @custid
	AND (ma.LastLateFee IS NULL OR DATEADD(dd,28,ma.LastLateFee) <= s.StatementDate)
	AND ma.PendingBalance > 0

IF ((@MinAmount IS NULL OR @MinAmount > 0) AND (@MaxAmount IS NULL OR @MaxAmount > 0) AND NOT (@MinAmount IS NOT NULL AND @MaxAmount IS NOT NULL AND @MinAmount > @MaxAmount) AND @Amount > 0 AND @Percentage > 0 AND @Percentage < 100 AND @StatementDate IS NOT NULL AND @ChargeTypeID IS NOT NULL)
BEGIN
SELECT @Amount = @Amount * (@Percentage / 100)
INSERT INTO Charges (CustomerID, Description, StartDate, EndDate, DistFlag, AllowInterim, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser)
VALUES(@custid, @Description, @StatementDate, @StatementDate, 1, 0, CASE WHEN @MinAmount IS NOT NULL AND @Amount < @MinAmount THEN @MinAmount WHEN @MaxAmount IS NOT NULL AND @Amount > @MaxAmount THEN @MaxAmount ELSE @Amount END, 1, @TaxGroupID, @TaxExemptions, @ChargeTypeID, getdate(), 'Emerald Auto Bill')

UPDATE MasterAccounts SET LastLateFee = @StatementDate WHERE CustomerID = @custid
END
GO

CREATE PROCEDURE dbo.UserExport (@esid INT, @filemode INT) AS
SET NOCOUNT ON
DECLARE @incremental INT
SELECT @incremental = CASE WHEN @filemode = 1 THEN 1 WHEN @filemode = 2 THEN 0 ELSE 1 END

SELECT sa.AccountID AS ID,
CASE WHEN ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < getdate() THEN 'inactive'  WHEN COALESCE(ma.OverLimit,0) > 0 AND ma.OverLimit < ma.Balance THEN 'expired' WHEN DATEADD(dd,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate) < getdate() THEN 'expired' WHEN @incremental <> 0 AND sa.CreateDate > es.LastSyncDate THEN 'active-new' WHEN @incremental = 0 THEN 'active' ELSE 'active-update' END AS Status,
sa.Login, sa.Email, sa.Password, sa.FirstName, sa.LastName, es.MailHost, 
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = 2) AS HomeDir,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = 4) AS HomeDirLimit,
COALESCE(DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate)),0) AS ExpireDay
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystems es, ExternalSystemAccountTypes esat
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND es.ExternalSystemID = @esid
	AND ma.Active IN (1,0)
	AND (@incremental = 0 OR (
		(ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)))
GO

CREATE PROCEDURE dbo.VerifyFTPUser (@username varchar(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @globallimit INT
SELECT @globallimit = NumValue FROM Configs WHERE ConfigID = 61

SELECT sa.AccountID, sa.Login, sa.Login AS Shell, sa.Password, sadh.Data AS HomeDir, COALESCE(CAST(sadl.Data AS INT),cgd.NumValue,@globallimit) AS HomeDirLimit
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SubAccountData sadh ON (sa.AccountID = sadh.AccountID AND sadh.AccountDataTypeID = 2)
	LEFT JOIN SubAccountData sadl ON (sa.AccountID = sadl.AccountID AND sadl.AccountDataTypeID = 4)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 61)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND ma.StartDate < getdate()
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND ((ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance) OR ma.OverLimit = 0)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + COALESCE(ma.OverDue,0), sa.ExpireDate) > getdate())
	AND sa.Login = @username
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.VerifyMailUser (@username VARCHAR(40), @domain VARCHAR(40), @esid INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @cnt INT
CREATE TABLE #vmuAccountIDs (AccountID INT)

INSERT INTO #vmuAccountIDs (AccountID)
SELECT AccountID FROM SubAccounts WHERE Email = @username + '@' + @domain
UNION
SELECT AccountID FROM SubAccounts sa, Domains d WHERE sa.Login = @username AND sa.DomainID = d.DomainID AND d.MailDomain = @domain

DELETE FROM #vmuAccountIDs WHERE AccountID IN (SELECT sa.AccountID
FROM #vmuAccountIDs ai, SubAccounts sa, MasterAccounts ma
	WHERE ai.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND (sa.Active <> 1 OR ma.Active <> 1 OR ma.CancelDate < DATEADD(dd,-1,getdate()) OR sa.CancelDate < DATEADD(dd,-1,getdate())))

SELECT @cnt = COUNT(AccountID) 
FROM #vmuAccountIDs

IF (@cnt = 0)
BEGIN
INSERT INTO #vmuAccountIDs (AccountID)
SELECT AccountID FROM Aliases WHERE Alias = @username + '@' + @domain
END

SELECT sa.Login, sa.Login AS Shell,sa.Email, @domain AS MailDomain,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit < ma.PendingBalance THEN NULL
WHEN DATEADD(dd,sa.Extension + COALESCE(ma.OverDue,0) + 1,sa.ExpireDate) < getdate() THEN NULL
ELSE sa.Password END AS Password,  sad.Data AS HomeDir
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID) 
	JOIN #vmuAccountIDs ai ON (sa.AccountID = ai.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 2)
	WHERE esat.ExternalSystemID = @esid
	AND ma.StartDate < GETDATE()
ORDER BY sa.Email DESC

DROP TABLE #vmuAccountIDs
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO


CREATE PROCEDURE dbo.VerifyNewsUser (@username varchar(40)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT Login, Login AS Shell, sa.Password, at1.AccountType
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ( (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingBalance)) 
			OR (DATEADD(dd,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) < GETDATE())
			OR ((ma.OverLimit IS NULL OR ma.OverLimit = 0) AND ExpireDate IS NULL))
		AND ma.StartDate < GETDATE()
		AND Login=@username
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.WebCheckOperator (@user VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @DateFormatID INT, @DateSeparator CHAR(1), @PrintTypeID INT
SELECT @DateFormatID = NumValue FROM Configs WHERE ConfigID = 390
SELECT @DateSeparator = CAST(Data AS CHAR(1)) FROM Configs WHERE ConfigID = 391
SELECT @PrintTypeID = NumValue FROM Configs WHERE ConfigID = 18

SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,@DateFormatID) AS DateFormatID, COALESCE(op.DateSeperator,@DateSeparator) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID, @PrintTypeID) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	WHERE op.Operator = @user
	AND op.Active = 1
UNION ALL
SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,@DateFormatID) AS DateFormatID, COALESCE(op.DateSeperator,@DateSeparator) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID, @PrintTypeID) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	WHERE op.Email = @user
	AND op.Active = 1
	AND @user LIKE '%@%'
UNION ALL
SELECT og.OperatorGroupID, 0 as OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID, @DateFormatID AS DateFormatID, @DateSeparator AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme, @PrintTypeID AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 AND sa.Active = 1
	AND sa.Login = @user 
	AND sa.Login IS NOT NULL
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0
UNION ALL
SELECT og.OperatorGroupID, 0 as OperatorID, sa.Email, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID, @DateFormatID AS DateFormatID, @DateSeparator AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme, @PrintTypeID AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 AND sa.Active = 1
	AND sa.Email = @user 
	AND sa.Email IS NOT NULL
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0
ORDER BY CustomerID ASC

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.WebCheckOperatorCookie (@Cookie VARCHAR(64)) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @DateFormatID INT, @DateSeparator CHAR(1), @PrintTypeID INT
SELECT @DateFormatID = NumValue FROM Configs WHERE ConfigID = 390
SELECT @DateSeparator = CAST(Data AS CHAR(1)) FROM Configs WHERE ConfigID = 391
SELECT @PrintTypeID = NumValue FROM Configs WHERE ConfigID = 18

SELECT oc.LastUsed, op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,@DateFormatID) AS DateFormatID, COALESCE(op.DateSeperator,@DateSeparator) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID, @PrintTypeID) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	JOIN OperatorCookies oc ON (op.OperatorID = oc.OperatorID)
	WHERE oc.Cookie = @Cookie
	AND op.Active = 1

UNION ALL

SELECT oc.LastUsed, og.OperatorGroupID, 0 AS OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID, @DateFormatID AS DateFormatID, @DateSeparator AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme, @PrintTypeID AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og, OperatorCookies oc
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND oc.AccountID = sa.AccountID
	AND oc.Cookie = @Cookie
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0
GO

CREATE PROCEDURE dbo.WebDeleteOperatorCookie (@Cookie VARCHAR(64)) AS
SET NOCOUNT ON
DELETE FROM OperatorCookies WHERE Cookie = @Cookie
GO

CREATE PROCEDURE dbo.WebAddOperatorCookie (@Operator VARCHAR(32), @Cookie VARCHAR(64), @OperatorID INT, @AccountID INT) AS
SET NOCOUNT ON

INSERT INTO OperatorCookies (Operator,Cookie,OperatorID,AccountID)
VALUES (@Operator, @Cookie, @OperatorID, @AccountID)
GO

CREATE PROCEDURE dbo.WebUpdateOperatorCookie (@Operator VARCHAR(32), @Cookie VARCHAR(64), @OperatorID INT, @AccountID INT) AS
SET NOCOUNT ON
UPDATE OperatorCookies SET LastUsed=GetDate(), OperatorID = @OperatorID, AccountID = @AccountID, Operator = @Operator WHERE Cookie = @Cookie

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO OperatorCookies (Operator,Cookie,OperatorID,AccountID)
VALUES (@Operator, @Cookie, @OperatorID, @AccountID)
END
GO

CREATE PROCEDURE dbo.SesCheckLimit AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @loginlimit INT, @timeleft INT, @dataleft INT
SELECT @loginlimit = NumValue FROM Configs WHERE ConfigID = 634
SELECT @timeleft = NumValue FROM Configs WHERE ConfigID = 635
SELECT @dataleft = NumValue FROM Configs WHERE ConfigID = 650

SELECT sp.AccountID, NULL AS Username, 1 AS VType, COUNT(*) AS Active, MIN(sa.LoginLimit) AS Limit
FROM ServerPorts sp JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
	JOIN Servers s ON (sp.NASIdentifier = s.IPAddress)
	WHERE sp.AcctStatusType = 1
	AND @loginlimit = 1
	AND sa.LoginLimit IS NOT NULL
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
	AND (s.Concurrency IS NULL OR s.Concurrency = 1)
GROUP BY sp.AccountID
HAVING COUNT(*) > MIN(sa.LoginLimit)
UNION ALL
SELECT sp.AccountID, NULL AS Username, 2 AS VType, SUM(DATEDIFF(ss,sp.CallDate,getdate())) AS Active, MIN(sa.TimeLeft) + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0) AS Limit
FROM ServerPorts sp, SubAccounts sa, Servers s
	WHERE sp.AccountID = sa.AccountID
	AND sp.AcctStatusType = 1
	AND @timeleft = 1
	AND sa.TimeLeft IS NOT NULL
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
GROUP BY sp.AccountID
HAVING SUM(DATEDIFF(ss,sp.CallDate,getdate())) > ((MIN(sa.TimeLeft) + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.TimeLeft > 0),0)) * 60)
UNION ALL
SELECT sp.AccountID, NULL AS Username, 4 AS VType, NULL AS Active, NULL AS Limit
FROM ServerPorts sp, SubAccounts sa, Servers s
	WHERE sp.AccountID = sa.AccountID
	AND sp.AcctStatusType = 1
	AND @dataleft = 1
	AND sp.AcctOutputOctets IS NOT NULL
	AND sp.AcctOutputOctets > 0
	AND sa.DataLeft IS NOT NULL
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
GROUP BY sp.AccountID
HAVING SUM(sp.AcctOutputOctets) > (MIN(sa.DataLeft) + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > getdate() AND sau.DataLeft > 0),0))
UNION ALL
SELECT DISTINCT sp.AccountID, NULL AS Username, 3 AS VType, NULL AS Active, NULL AS Limit
FROM ServerPorts sp JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Servers s ON (sp.NASIdentifier = s.IPAddress)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE sp.AcctStatusType = 1
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0) OR g.Active = 0 OR (sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate()))
GO

CREATE PROCEDURE dbo.SesGetLimit (@AccountID INT, @Username VARCHAR(64), @Authorized TINYINT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@AccountID IS NOT NULL)
BEGIN
SELECT s.IPAddress, s.Secret, s.DisconnectType, s.DisconnectPort, sp.AcctSessionID,
CASE WHEN s.DisconnectType = NULL OR 8 & s.DisconnectType = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR 2 & s.DisconnectType = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR 1 & s.DisconnectType = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR 4 & s.DisconnectType = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR 16 & s.DisconnectType = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR 32 & s.DisconnectType = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s
	WHERE sp.AcctStatusType = 1
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID = @AccountID
ORDER BY DATEADD(ss,-COALESCE(sp.AcctSessionTime,0),sp.CallDate) ASC
END ELSE BEGIN
SELECT s.IPAddress, s.Secret, s.DisconnectType, s.DisconnectPort, sp.AcctSessionID, 
CASE WHEN s.DisconnectType = NULL OR 8 & s.DisconnectType = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR 2 & s.DisconnectType = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR 1 & s.DisconnectType = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR 4 & s.DisconnectType = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR 16 & s.DisconnectType = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR 32 & s.DisconnectType = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s
	WHERE sp.AcctStatusType = 1
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.Username = @Username
ORDER BY DATEADD(ss,-COALESCE(sp.AcctSessionTime,0),sp.CallDate) ASC
END
GO

CREATE PROCEDURE dbo.SesRadVendors AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Name, RadVendorID AS VendorID
FROM RadVendors
ORDER BY RadVendorID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SesRadAttributes AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT Name, RadVendorID AS VendorID, RadAttributeID AS AttributeID, RadAttributeType AS Type
FROM RadAttributes 
ORDER BY RadVendorID, RadAttributeID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SesCheckRate AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @rate INT
SELECT @rate = NumValue FROM Configs WHERE ConfigID = 636

SELECT ma.GroupID, sa.AccountID, sa.CustomerID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, at1.RateClassID, sp.Username, 
sp.NASIdentifier, sp.Port, DATEDIFF(ss,sp.CallDate,getdate()) AS Duration, COALESCE(sp.AcctOutputOctets,0) + COALESCE(sp.AcctInputOctets,0) + 1 AS Data, sp.FramedAddress, sp.NASPortDNIS, sp.CallerID, sp.CallDate,
ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(rh.TotalCost) FROM RateHistory rh WHERE rh.ChargeID IS NULL AND rh.CustomerID = sa.CustomerID),0) AS AmountLeft
FROM ServerPorts sp, Servers s, SubAccounts sa, MasterAccounts ma, AccountTypes at1, BillingCycles bc
	WHERE sp.AccountID = sa.AccountID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND sp.NASIdentifier = s.IPAddress
	AND sa.CustomerID = ma.CustomerID
	AND s.DisconnectPort IS NOT NULL
	AND sp.AcctStatusType = 1
	AND @rate = 1
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL
ORDER BY sa.CustomerID, sa.AccountID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SesGetRate (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT s.IPAddress, s.Secret, s.DisconnectType, s.DisconnectPort, sp.AcctSessionID, 
CASE WHEN s.DisconnectType = NULL OR 8 & s.DisconnectType = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR 2 & s.DisconnectType = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR 1 & s.DisconnectType = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR 4 & s.DisconnectType = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR 16 & s.DisconnectType = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR 32 & s.DisconnectType = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s, SubAccounts sa, AccountTypes at1
	WHERE sp.AccountID = sa.AccountID
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AcctStatusType = 1
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL
	AND sa.AccountID = @AccountID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.SesConfig AS
SET NOCOUNT ON
DECLARE @limit INT, @rate INT, @intlimit INT, @intrate INT, @preload INT, @debug INT
SELECT @limit = CASE WHEN SUM(NumValue) > 0 THEN 1 ELSE 0 END FROM Configs WHERE ConfigID IN (634,635)
SELECT @rate = NumValue FROM Configs WHERE ConfigID = 636

SELECT @intlimit = NumValue FROM Configs WHERE ConfigID = 637
SELECT @intrate = NumValue FROM Configs WHERE ConfigID = 638
SELECT @preload = NumValue FROM Configs WHERE ConfigID = 639
SELECT @debug = NumValue 
FROM Configs WHERE ConfigID = 633

SELECT @limit AS LimitEnabled, COALESCE(@rate,0) AS RateEnabled, COALESCE(@intlimit,60) AS LimitInterval, COALESCE(@intrate,240) AS RateInterval, COALESCE(@preload,1) AS RatePreload, COALESCE(@debug,0) AS DebugFlag

GO

CREATE PROCEDURE dbo.SesOnlineReset (@NASIdentifier VARCHAR(64), @NASPort VARCHAR(64)) AS
SET NOCOUNT ON
UPDATE ServerPorts SET AcctStatusType = 2 
	WHERE NASIdentifier = @NASIdentifier 
	AND Port = @NASPort
	AND AcctStatusType = 1
GO

CREATE PROCEDURE dbo.StatementDeleteLast (@CustomerID INT) AS
SET NOCOUNT ON
DECLARE @StatementID INT
SELECT @StatementID = LastStatementID FROM MasterAccounts WHERE CustomerID = @CustomerID

IF (@StatementID IS NOT NULL)
BEGIN
UPDATE ExternalTrans SET StatementID = NULL WHERE StatementID = @StatementID
UPDATE MasterAccounts SET Balance = (SELECT PrevBal FROM Statements WHERE StatementID = @StatementID), LastStatementID = (SELECT MAX(s2.StatementID) FROM Statements s2 WHERE s2.CustomerID = @CustomerID AND s2.StatementID <> @StatementID)
WHERE CustomerID = @CustomerID

UPDATE ExternalTrans SET StatementID = NULL WHERE StatementID = @StatementID

UPDATE Invoices SET StatementID = NULL WHERE StatementID = @StatementID
UPDATE Invoices SET VoidStatementID = NULL WHERE VoidStatementID = @StatementID

UPDATE Payments SET StatementID = NULL WHERE StatementID = @StatementID
UPDATE Payments SET FinalStatementID = NULL WHERE FinalStatementID = @StatementID

DELETE FROM Statements WHERE StatementID = @StatementID
END
GO

CREATE PROCEDURE dbo.ExternalSyncUpdate (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(768), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN

IF (@TransTypeID = 1024)
BEGIN
UPDATE	ExternalSyncs SET ErrorCount = 0, Message = NULL, Login = COALESCE(sa.Login,sa.Email), Password = sa.Password, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, 
	CreateDate = getdate(), LastModifyDate = getdate(), LastUpdate = getdate(), Active = 1, Created = 1, ProcTransID = @Data
FROM SubAccounts sa, ExternalSyncs es
	WHERE sa.AccountID = es.AccountID
	AND es.ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2048)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate()
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 4096)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 0, Created = 0
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 8192)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Login = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 65536)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Password = sa.Password
FROM ExternalSyncs es, SubAccounts sa
	WHERE es.AccountID = sa.AccountID
	AND es.ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 131072)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 262144)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Active = 0
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 524288)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux1 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 1048576)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux2 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2097152)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux3 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 4194304)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux4 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 8388608)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux5 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 16777216)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux6 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 33554432)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux7 = CAST(@Data AS VARCHAR(128))
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 67108864)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux8 = CAST(@Data AS VARCHAR(768))
	WHERE ExternalSyncID = @ExternalSyncID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ExternalSyncDelete (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(768), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN
DELETE FROM ExternalSyncs WHERE ExternalSyncID = @ExternalSyncID
END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEveryoneDomainUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @DomainID INT, @MailDomain VARCHAR(128)

IF (@Retcode = 0)
BEGIN
SELECT @DomainID = d.DomainID, @MailDomain = d.MailDomain
FROM ExternalSyncs esy, Domains d 
	WHERE d.MailDomain = esy.Aux3
	AND esy.ExternalSyncID = @ExternalSyncID

UPDATE Domains SET ExternalRef = @Data WHERE DomainID = @DomainID
DELETE FROM ExternalSyncs WHERE Aux3 = @MailDomain AND ExternalSyncID = @ExternalSyncID
END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEveryoneNet (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @ClientID VARCHAR(64), @ClientPass VARCHAR(64), @OfferID VARCHAR(64), @ESExternalRef VARCHAR(64)
SELECT @ClientID = Login, @ClientPass = Password, @OfferID = Aux1, @ESExternalRef = Aux2 FROM ExternalSystems WHERE ExternalSystemID = @ESID

IF (@Stage = 1)
BEGIN

INSERT INTO ExternalSyncs (ExternalSystemID,Aux3,Aux6)
SELECT DISTINCT @ESID, d.MailDomain, ' '
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND @ESExternalRef IS NULL
	AND d.ExternalRef IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM ExternalSyncs esy2 WHERE esy2.ExternalSystemID = @ESID AND esy2.Aux3 = d.MailDomain)

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT esy.ExternalSyncID, 2097152 AS TransTypeID, NULL AS OrigData, NULL AS Login, NULL Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, NULL AS ExternalRef, @OfferID AS OfferID, d.MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID IS NULL
	AND esy.Aux3 = d.MailDomain
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND @ESExternalRef IS NULL
	AND d.ExternalRef IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID,Aux1,Aux2)
SELECT @ESID, sa.AccountID, COALESCE(sa.FirstName,'') + COALESCE(sa.LastName,''), COALESCE(esat.ExternalRef,@OfferID)
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT esy.ExternalSyncID, 1024 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID)

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < getdate() OR sa.CancelDate < getdate() OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND (ma.Active = -1 OR sa.Active = -1 OR sa.BilledThru < DATEADD(dd,-30,getdate()))

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID, NULL, esy.Login, sa.Password, @ClientID, @ClientPass, NULL, NULL, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 524288 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, sa.FirstName, sa.LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, @OfferID AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(sa.FirstName,'') + COALESCE(sa.LastName,'') <> esy.Aux1 OR esy.Aux1 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 1048576 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, sa.FirstName, sa.LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(esat.ExternalRef,@OfferID) <> esy.Aux2 OR esy.Aux2 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 4194304 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass, @ClientID AS clientID, @ClientPass AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, (SELECT MIN(f1.Forward) FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND sa.Login IS NOT NULL
	AND EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')
	AND (esy.Aux4 IS NULL OR esy.Aux4 <> (SELECT MIN(f2.Forward) FROM Forwards f2 WHERE f2.AccountID = sa.AccountID AND f2.Forward LIKE '%[a-z0-9]@[a-z0-9]%'))

UNION ALL

SELECT esy.ExternalSyncID, 8388608 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 0
	AND (esy.Aux5 IS NOT NULL AND esy.Aux5 <> ' ')
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')

UNION ALL

SELECT esy.ExternalSyncID, 16777216 AS TransTypeID, NULL, esy.Login, NULL, @ClientID, @ClientPass, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,@ESExternalRef) AS ExternalRef, COALESCE(esat.ExternalRef,@OfferID) AS OfferID, NULL AS MailDomain,
(SELECT MIN('"' + f1.Forward + '"') FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, CASE WHEN (SELECT COUNT(*) FROM Forwards f3 WHERE f3.AccountID = sa.AccountID AND f3.Forward LIKE '%[a-z0-9]@[a-z0-9]%') > 0 THEN 1 ELSE 0 END AS ForwardOption

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (@ESExternalRef IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 1
	AND esy.Active = 1
	AND (esy.Aux6 IS NULL OR esy.Aux6 <> (SELECT MIN(f4.Forward) FROM Forwards f4 WHERE f4.AccountID = sa.AccountID AND f4.Forward LIKE '%[a-z0-9]@[a-z0-9]%'))
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESSmarterMail (@ESID INT) AS
SET NOCOUNT ON
DECLARE @authlogin VARCHAR(64), @authpassword VARCHAR(64)
SELECT @authlogin = Login, @authpassword = Password FROM ExternalSystems WHERE ExternalSystemID = @ESID

INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT esy.ExternalSyncID, 1024 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 1
	AND sa.Login IS NOT NULL

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < getdate() OR sa.CancelDate < getdate() OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate())
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID, @authlogin AS authlogin, @authpassword AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = @ESID
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID = @ESID
	AND sa.DomainID = d.DomainID
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 1

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESEnom (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @Login VARCHAR(64), @Password VARCHAR(64), @OptionID VARCHAR(15), @AddressTypeID INT, @HostRecord SMALLINT

SELECT @Login = MIN(es.Login), @Password = MIN(es.Password), @OptionID = COALESCE(MIN(es.Aux1),'1054'), @HostRecord = CASE WHEN MIN(es.Aux2) LIKE '%1%' THEN 1 ELSE 0 END, @AddressTypeID = MIN(at1.AddressTypeID)
FROM ExternalSystems es LEFT JOIN AddressTypes at1 ON (es.Aux3 = at1.AddressType)
	WHERE es.ExternalSystemID = @ESID

IF (@Stage = 1)
BEGIN
INSERT INTO Domains (Domain,MailDomain,Description,CustomerID)
SELECT sa.Login,sa.Login,sa.Login,sa.CustomerID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Domains d ON (sa.Login = d.MailDomain)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.Login LIKE '%[a-z0-9].[a-z]%'
	AND d.DomainID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())

INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.Login = d.MailDomain AND ma.CustomerID = d.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND esy.AccountID IS NULL
END

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@Stage = 1)
BEGIN
SELECT esy.ExternalSyncID, 2048 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
ma.Company AS RegistrantOrganizationName,
CASE WHEN a.AddressID IS NULL THEN ma.FirstName ELSE a.FirstName END AS RegistrantFirstName,
CASE WHEN a.AddressID IS NULL THEN ma.LastName ELSE a.LastName END AS RegistrantLastName,
CASE WHEN a.AddressID IS NULL THEN ma.Address1 ELSE a.Address1 END AS RegistrantAddress1,
CASE WHEN a.AddressID IS NULL THEN ma.Address2 ELSE a.Address2 END AS RegistrantAddress2,
CASE WHEN a.AddressID IS NULL THEN ma.City ELSE a.City END AS RegistrantCity,
CASE WHEN a.AddressID IS NULL THEN COALESCE(s.Abbreviation,s.State) ELSE COALESCE(ads.Abbreviation,ads.State) END AS RegistrantStateProvince,
CASE WHEN a.AddressID IS NULL THEN ma.Zip ELSE a.Zip END AS RegistrantPostalCode,
CASE WHEN a.AddressID IS NULL THEN c.Country ELSE adc.Country END AS RegistrantCountry,
CASE WHEN a.AddressID IS NULL THEN 'dns@' + sa.Login ELSE a.Email END AS RegistrantEmailAddress,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneWork ELSE a.Phone END AS RegistrantPhone,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneFax ELSE a.Fax END AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID AND ma.CountryID = s.CountryID)
	LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AddressTypeID = @AddressTypeID)
	LEFT JOIN Countries adc ON (a.CountryID = adc.CountryID)
	LEFT JOIN States ads ON (a.StateID = ads.StateID AND a.CountryID = ads.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active IN (1,0)
	AND (esy.Created = 1 OR ma.Active = 1)
	AND (esy.Created = 1 OR sa.Active = 1)
	AND (esy.Created = 1 OR g.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (esy.Created = 0 OR esy.LastUpdate < ma.LastModifyDate)
END

IF (@Stage = 2)
BEGIN
SELECT esy.ExternalSyncID, 1024 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
ma.Company AS RegistrantOrganizationName,
CASE WHEN a.AddressID IS NULL THEN ma.FirstName ELSE a.FirstName END AS RegistrantFirstName,
CASE WHEN a.AddressID IS NULL THEN ma.LastName ELSE a.LastName END AS RegistrantLastName,
CASE WHEN a.AddressID IS NULL THEN ma.Address1 ELSE a.Address1 END AS RegistrantAddress1,
CASE WHEN a.AddressID IS NULL THEN ma.Address2 ELSE a.Address2 END AS RegistrantAddress2,
CASE WHEN a.AddressID IS NULL THEN ma.City ELSE a.City END AS RegistrantCity,
CASE WHEN a.AddressID IS NULL THEN COALESCE(s.Abbreviation,s.State) ELSE COALESCE(ads.Abbreviation,ads.State) END AS RegistrantStateProvince,
CASE WHEN a.AddressID IS NULL THEN ma.Zip ELSE a.Zip END AS RegistrantPostalCode,
CASE WHEN a.AddressID IS NULL THEN c.Country ELSE adc.Country END AS RegistrantCountry,
CASE WHEN a.AddressID IS NULL THEN 'dns@' + sa.Login ELSE a.Email END AS RegistrantEmailAddress,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneWork ELSE a.Phone END AS RegistrantPhone,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneFax ELSE a.Fax END AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID AND ma.CountryID = s.CountryID)
	LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AddressTypeID = @AddressTypeID)
	LEFT JOIN Countries adc ON (a.CountryID = adc.CountryID)
	LEFT JOIN States ads ON (a.StateID = ads.StateID AND a.CountryID = ads.CountryID)
	WHERE ma.Active = 1 
	AND sa.Active = 1 
	AND g.Active = 1 
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND esy.Created = 0
END

IF (@Stage = 3)
BEGIN
SELECT esy.ExternalSyncID, 524288 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
@OptionID AS NewOptionID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> @OptionID)
END

IF (@Stage = 4)
BEGIN
SELECT esy.ExternalSyncID, 1048576 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
@OptionID AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND @HostRecord = 1
	AND (esy.Aux2 IS NULL OR esy.Aux1 <> @OptionID)

UNION ALL

SELECT esy.ExternalSyncID, 2097152 AS TransTypeID, @Login AS UID, @Password AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	WHERE ma.Active = 1
	AND sa.Active = 1 
	AND g.Active = 1
	AND esy.Created = 1
	AND d.ExpireDate < DATEADD(dd,15,getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
END
GO

CREATE PROCEDURE dbo.ESEnomUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @numyears INT, @DomainID INT

IF (@Retcode = 0)
BEGIN

IF (@TransTypeID = 1024)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate(), Created = 1, Active = 1, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, CreateDate = getdate(), ProcTransID = @Data
	WHERE ExternalSyncID = @ExternalSyncID

SELECT @numyears = CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END, @DomainID = d.DomainID
FROM SubAccounts sa, ExternalSyncs esy, PayPeriods pp, Domains d
	WHERE sa.AccountID = esy.AccountID
	AND esy.ExternalSyncID = @ExternalSyncID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.CustomerID = d.CustomerID
	AND sa.Login = d.MailDomain

UPDATE Domains SET ExpireDate = DATEADD(yy,@numyears,getdate()) WHERE DomainID = @DomainID
END

IF (@TransTypeID = 2048)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), LastUpdate = getdate(), Created = 1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 2097152)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux3 = @Data
	WHERE ExternalSyncID = @ExternalSyncID

SELECT @numyears = CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END, @DomainID = d.DomainID
FROM SubAccounts sa, ExternalSyncs esy, PayPeriods pp, Domains d
	WHERE sa.AccountID = esy.AccountID
	AND esy.ExternalSyncID = @ExternalSyncID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.CustomerID = d.CustomerID
	AND sa.Login = d.MailDomain

UPDATE Domains SET ExpireDate = DATEADD(yy,@numyears,ExpireDate) WHERE DomainID = @DomainID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.CardUnusedReset (@reset INT, @agemax INT) AS
SET NOCOUNT ON
CREATE TABLE #caf (CardAccountID INT, CustomerID INT, AccountID INT)

INSERT INTO #caf (CardAccountID, CustomerID, AccountID)
SELECT ca.CardAccountID, ma.CustomerID, sa.AccountID
FROM CardAccounts ca JOIN MasterAccounts ma ON (ma.CustomerID = ca.DirectCustomerID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.AccountID = ca.DirectAccountID)
	JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Incidents i ON (sa.AccountID = i.AccountID)
	LEFT JOIN Payments p ON (ma.CustomerID = p.CustomerID AND p.PaymentTypeID <> 32)
	LEFT JOIN Invoices inv ON (ma.CustomerID = inv.CustomerID)
	LEFT JOIN Charges ch ON (ma.CustomerID = ch.CustomerID)
	LEFT JOIN Calls c ON (sa.AccountID = c.AccountID)
	LEFT JOIN RateHistory rh ON (sa.AccountID = rh.AccountID)
	LEFT JOIN Statements s ON (ma.CustomerID = s.CustomerID)
	WHERE bc.AutoBill = 2
	AND cb.AllowDirect = 1
	AND ma.Active = 1
	AND sa.Active = 1
	AND cb.Active = 1
	AND ca.Active = 1
	AND p.PaymentID IS NULL
	AND i.IncidentID IS NULL
	AND inv.InvoiceID IS NULL
	AND ch.ChargeID IS NULL
	AND c.CallID IS NULL
	AND rh.AccountID IS NULL
	AND s.StatementID IS NULL
	AND ma.PayInfo = 'prepaid auto'
	AND ((cb.TimeLeft IS NULL AND sa.TimeLeft IS NULL) OR (cb.TimeLeft = sa.TimeLeft))
	AND ((cb.DataLeft IS NULL AND sa.DataLeft IS NULL) OR (cb.DataLeft = sa.DataLeft))
	AND ma.Company IS NULL
	AND ma.Address1 IS NULL
	AND ma.Address1 IS NULL
	AND ma.PhoneHome IS NULL
	AND ma.PhoneWork IS NULL
	AND ma.PhoneFax IS NULL
	AND ma.City IS NULL
	AND ma.StateID IS NULL
	AND ma.Zip IS NULL
	AND ma.CreateDate < DATEADD(dd,-4,getdate())
	AND (@agemax IS NULL OR ma.CreateDate > DATEADD(dd,-@agemax,getdate()))
	AND ca.AllowDirect = 0
	AND ca.UsedForDirect = 1
	AND ca.UsedForCredit = 0
	AND (SELECT COUNT(*) FROM SubAccounts sa2 WHERE sa2.CustomerID = ma.CustomerID) = 1
	AND (SELECT COUNT(*) FROM Payments p2 WHERE p2.CustomerID = ma.CustomerID) <= 1

IF (@reset = 1)
BEGIN
UPDATE ca SET AllowDirect = cb.AllowDirect, UsedForDirect = 0, FirstUseDate = NULL, AllowCredit = CASE WHEN cb.Amount IS NOT NULL THEN 1 ELSE 0 END, DirectCustomerID = NULL, DirectAccountID = NULL
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN #caf c ON (ca.CardAccountID = c.CardAccountID)

DELETE FROM PaymentItems WHERE PaymentID IN (SELECT PaymentID FROM Payments p, #caf c WHERE p.CustomerID = c.CustomerID)
DELETE FROM Payments WHERE CustomerID IN (SELECT CustomerID FROM #caf)
DELETE FROM SubAccounts WHERE AccountID IN (SELECT AccountID FROM #caf)
DELETE FROM MasterAccounts WHERE CustomerID IN (SELECT CustomerID FROM #caf)

END ELSE BEGIN

SELECT ca.CardAccountID, ca.Login, cb.CardBatch, cbt.CardBatchType, ca.FirstUseDate AS UseDate, c.CustomerID, c.AccountID
FROM CardAccounts ca JOIN CardBatches cb ON (ca.CardBatchID = cb.CardBatchID)
	JOIN CardBatchTypes cbt ON (cb.CardBatchTypeID = cbt.CardBatchTypeID)
	JOIN #caf c ON (ca.CardAccountID = c.CardAccountID)
ORDER BY cb.CardBatch, ca.FirstUseDate

END

DROP TABLE #caf
GO

CREATE PROCEDURE dbo.CardAccountRecharge (@AccountID INT, @CardLogin VARCHAR(64), @CardPassword VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @CustomerID INT, @RC SMALLINT, @OrganizationID INT, @AccountTypeID INT, @CardAccountID INT, @TimeLeft INT, @DataLeft BIGINT, @ActiveExpireDays INT, @ActiveExpireMins INT, @DirectAmount NUMERIC(18,4), @AutoBill INT, @PaymentID INT, @trackmode INT

SELECT @CardAccountID = MAX(CardAccountID), @TimeLeft = COALESCE(MAX(cb.TimeLeft),0), @DataLeft = COALESCE(MAX(cb.DataLeft),0), @DirectAmount = COALESCE(MAX(cb.DirectAmount),0), @ActiveExpireDays = COALESCE(MAX(cb.ActiveExpireDays),0), @ActiveExpireMins = COALESCE(MAX(cb.ActiveExpireMins),0)
FROM CardAccounts ca, CardBatches cb
	WHERE ca.CardBatchID = cb.CardBatchID
	AND ca.Login = @CardLogin 
	AND ca.Password = @CardPassword

SELECT @CustomerID = MAX(ma.CustomerID), @AccountTypeID = MAX(sa.AccountTypeID), @OrganizationID = MAX(g.OrganizationID), @AutoBill = MAX(bc.AutoBill)
FROM MasterAccounts ma, SubAccounts sa, Groups g, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.AccountID = @AccountID
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())

SELECT @trackmode = NumValue FROM Configs WHERE ConfigID = 535
SELECT @trackmode = COALESCE(MAX(cgd.NumValue),@trackmode)
FROM ConfigGroupData cgd, MasterAccounts ma
	WHERE ma.CustomerID = @CustomerID
	AND ma.GroupID = cgd.GroupID
	AND cgd.ConfigID = 535

IF (@CardAccountID IS NOT NULL AND @CustomerID IS NOT NULL)
BEGIN
UPDATE CardAccounts SET UsedForDirect = 1, FirstUseDate = getdate(), DirectCustomerID = @CustomerID, DirectAccountID = @AccountID
	WHERE Active = 1
	AND UsedForCredit = 0
	AND AllowDirect = 1
	AND UsedForDirect = 0
	AND OrganizationID = @OrganizationID
	AND CardAccountID = @CardAccountID
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > getdate())
	AND CardBatchID IN (SELECT cb.CardBatchID FROM CardBatches cb WHERE cb.Active = 1 AND cb.AccountTypeID = @AccountTypeID)

IF (@@ROWCOUNT = 1)
	BEGIN

	IF (@trackmode = 2 AND (@TimeLeft > 0 OR @DataLeft > 0))
	BEGIN	
	INSERT INTO SubAccountUsages (AccountID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT @AccountID, @TimeLeft,@DataLeft,@TimeLeft,@DataLeft,DATEADD(mi,@ActiveExpireMins,DATEADD(dd,CASE WHEN @ActiveExpireDays = 0 AND @ActiveExpireMins = 0 THEN 720 ELSE @ActiveExpireDays END,getdate()))
	FROM SubAccounts 
		WHERE AccountID = @AccountID
	END

	UPDATE SubAccounts SET	TimeLeft = CASE WHEN TimeLeft IS NULL OR @TimeLeft = 0 OR @trackmode = 2 THEN TimeLeft WHEN TimeLeft <= 0 THEN @TimeLeft ELSE TimeLeft + @TimeLeft END,
				DataLeft = CASE WHEN DataLeft IS NULL OR @DataLeft = 0 OR @trackmode = 2 THEN DataLeft WHEN DataLeft <= 0 THEN @DataLeft ELSE DataLeft + @DataLeft END,
				ExpireDate = CASE WHEN PackageID IS NOT NULL OR ExpireDate IS NULL OR (@ActiveExpireDays = 0 AND @ActiveExpireMins = 0) THEN ExpireDate WHEN @AutoBill = 2 AND ExpireDate < getdate() THEN DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,getdate())) ELSE DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,ExpireDate)) END,
				BilledThru = CASE WHEN PackageID IS NOT NULL OR BilledThru IS NULL OR (@ActiveExpireDays = 0 AND @ActiveExpireMins = 0) THEN BilledThru WHEN @AutoBill = 2 AND BilledThru < getdate() THEN DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,getdate())) ELSE DATEADD(mi,@ActiveExpireMins,DATEADD(dd,@ActiveExpireDays,BilledThru)) END
	WHERE AccountID = @AccountID

	IF (@DirectAmount > 0)
		BEGIN
		INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
		VALUES(@CustomerID,@DirectAmount,getdate(),NULL,32,'prepaid recharge credit',1,getdate(),'prepaid auto')
		SELECT @PaymentID = @@IDENTITY
		END

	SELECT @RC = 0

	END ELSE BEGIN
	SELECT @RC = -3
	END

END ELSE BEGIN
SELECT @RC = CASE WHEN @CustomerID IS NULL THEN -1 ELSE -2 END
END

SELECT @RC AS Status, @CustomerID AS CustomerID, @PaymentID AS PaymentID
GO

CREATE PROCEDURE dbo.BackupDevInfo (@devname VARCHAR(64)) AS
RESTORE HEADERONLY FROM @devname
GO

CREATE PROCEDURE dbo.BackupDB (@devname VARCHAR(64), @description VARCHAR(128)) AS 
SET NOCOUNT ON
DECLARE @dbname varchar(128)
SELECT @dbname = DB_NAME()
BACKUP DATABASE @dbname TO @devname WITH INIT, DESCRIPTION = @description
SELECT 'Database ' + @dbname + ' backed up to device ' + @devname AS Description
GO

CREATE PROCEDURE dbo.RateVRules (@RateRuleID INT) AS
SET NOCOUNT ON

CREATE TABLE #rvrtmp (RuleCounter INT IDENTITY, RateVCondGroupID INT, DNIS VARCHAR(64), Attribute VARCHAR(64), RateMatchTypeID INT, IntervalCost NUMERIC(18,4), InitialCost NUMERIC(18,4), StaticCost NUMERIC(18,4))

-- Group Interval
INSERT INTO #rvrtmp (RateVCondGroupID,DNIS,Attribute,RateMatchTypeID,IntervalCost,InitialCost,StaticCost)
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
-- Group Initial
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
-- Group Static
SELECT vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
-- Single Interval
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
-- Single Initial
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

UNION
-- Single Static
SELECT vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID = @RateRuleID

SELECT vci.Attribute, t.RuleCounter AS GroupingID, vci.RateMatchTypeID AS MatchTypeID, vci.Data, t.IntervalCost AS Cost, vcg.Priority
FROM #rvrtmp t, RateVCondGroups vcg, RateVCondItems vci
	WHERE t.RateVCondGroupID = vcg.RateVCondGroupID
	AND vcg.RateVCondGroupID = vci.RateVCondGroupID

UNION ALL
SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost AS Cost, NULL AS Priority
FROM RateRules
	WHERE RateRuleID = @RateRuleID

UNION ALL
SELECT Attribute, RuleCounter AS GroupingID, RateMatchTypeID AS MatchTypeID, DNIS AS Data, COALESCE(IntervalCost,(SELECT DefaultCost FROM RateRules WHERE RateRuleID=@RateRuleID)) AS Cost, NULL AS Priority
FROM #rvrtmp
	WHERE IntervalCost IS NOT NULL OR StaticCost IS NOT NULL OR InitialCost IS NOT NULL

UNION ALL
SELECT 'InitialCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(InitialCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM #rvrtmp t
	WHERE InitialCost IS NOT NULL

UNION ALL
SELECT 'StaticCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(StaticCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM #rvrtmp
	WHERE StaticCost IS NOT NULL
ORDER BY 2,1

DROP TABLE #rvrtmp
GO

CREATE PROCEDURE dbo.ShowCustomerNextBillDay (@CustomerID int) AS
SET NOCOUNT ON
Declare @bd int

Select @bd = Case When ma.PaymentTypeID in (8,16) then EBillDays else IBillDays END
From BillingCycles bc, MasterAccounts ma
Where bc.BillingCycleID = ma.BillingCycleID 
	and ma.CustomerID = @CustomerID

Select DATEADD(dd, 0-@bd, (select Min(ExpireDate) From SubAccounts Where CustomerID =  @CustomerID and Active = 1)) as BillDay
GO

CREATE PROCEDURE dbo.CheckInvoices (@fixinvoices INT) AS
SET NOCOUNT ON

CREATE TABLE #chkitmp (InvoiceID INT, CustomerID INT, Name VARCHAR(80), CreateDate DATETIME, InvoiceAmount NUMERIC(18,4), CalcInvoiceAmount NUMERIC(18,4), Condition INT)
INSERT INTO #chkitmp (InvoiceID,CustomerID,Name,CreateDate,InvoiceAmount,CalcInvoiceAmount,Condition)
SELECT i.InvoiceID, MIN(ma.CustomerID) AS CustomerID, MIN(ma.FirstName + ' ' + ma.LastName) AS Name, 
MIN(i.CreateDate) AS CreateDate, MIN(ROUND(i.Amount,2)) AS InvoiceAmount, COALESCE(SUM(ROUND(ii.Amount * ii.Quantity,2)),0) AS CalcInvoiceAmount,
CASE	WHEN SUM(CASE WHEN ii.Description LIKE '%Days' THEN ROUND(ii.Amount,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 1
	WHEN SUM(ROUND(ii.Amount,2)) = MIN(i.Amount) THEN 2
	WHEN SUM(CASE WHEN c.ChargeID IS NOT NULL THEN ROUND(c.Amount * c.Quantity,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 3
ELSE NULL END AS Condition
FROM Invoices i LEFT JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Charges c ON (ii.ChargeID = c.ChargeID)
	WHERE i.VoidDate IS NULL
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(COALESCE(ROUND(ii.Amount * ii.Quantity,2),0))

IF (@fixinvoices IN (1,2,3))
BEGIN
UPDATE InvoiceItems SET Quantity = 1
	WHERE Description LIKE '%Days'
	AND InvoiceID IN (SELECT InvoiceID FROM #chkitmp WHERE Condition = 1)

UPDATE InvoiceItems SET Quantity = 1
	WHERE InvoiceID IN (SELECT InvoiceID FROM #chkitmp WHERE Condition = 2)

UPDATE InvoiceItems SET Amount = c.Amount, Quantity = c.Quantity
FROM InvoiceItems ii, Charges c, #chkitmp t
	WHERE ii.InvoiceID = t.InvoiceID
	AND ii.ChargeID = c.ChargeID
	AND t.Condition = 3


IF (@fixinvoices = 2)
	BEGIN
	UPDATE InvoiceItems SET Amount = ii.Amount + ((t.InvoiceAmount - t.CalcInvoiceAmount) / ii.Quantity)
	FROM InvoiceItems ii, #chkitmp t
		WHERE ii.InvoiceID = t.InvoiceID
		AND ii.ItemID = (SELECT MIN(ItemID) FROM InvoiceItems ii2 WHERE ii2.InvoiceID = t.InvoiceID AND ii2.Quantity > 0)
		AND t.Condition IS NULL

	END

IF (@fixinvoices = 3)
	BEGIN
	INSERT INTO InvoiceItems (InvoiceID,ItemType,Description,StartDate,EndDate,Amount,Quantity,PaidAmount)
	SELECT t.InvoiceID, CASE WHEN t.InvoiceAmount - t.CalcInvoiceAmount < 0 THEN 1 ELSE 2 END,'Conversion Adjustment',t.CreateDate,t.CreateDate,t.InvoiceAmount - t.CalcInvoiceAmount,1,0
	FROM #chkitmp t
		WHERE t.InvoiceAmount <> t.CalcInvoiceAmount
	END

END ELSE BEGIN
SELECT t.InvoiceID, t.CustomerID, t.Name, t.CreateDate, t.InvoiceAmount, t.CalcInvoiceAmount, 
CASE WHEN t.Condition = 1 THEN 'E2.5 Prorate Qty Error' 
WHEN t.Condition = 2 THEN 'General Qty Error' 
WHEN t.Condition = 3 THEN 'Use Charge Amount'
ELSE 'N/A' END AS Comments
FROM #chkitmp t
END

DROP TABLE #chkitmp
GO

CREATE PROCEDURE dbo.RadGetRejectAttributes AS
SET NOCOUNT ON
SELECT RadLogMsgID,ServerID,RadVendorID,RadAttributeID,Data
FROM RadRejectAttributes
GO

CREATE PROCEDURE dbo.ESHelm (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esat.ExternalRef IS NOT NULL
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2
	AND es.Aux1 IS NOT NULL
	AND sad.Data = '1'

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1024 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
CASE WHEN COALESCE(s.Abbreviation,s.State) IS NOT NULL THEN COALESCE(ma.City,' ') + ', ' + COALESCE(s.Abbreviation,s.State) ELSE ma.City END AS Town,
ma.Zip AS PostCode,
c.Abbr2 AS CountryCode,
NULL AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
524288 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE (SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND sa2.Active=1
			AND es2.ExternalSystemID = @ESID
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23) END AS UserAccountID,
esat.ExternalRef AS PlanID,
sa.Login + ' (' + at1.AccountType + ')' AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Aux1 IS NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data = '2' AND EXISTS (SELECT * 
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND es2.ExternalSystemID = @ESID
			AND sa2.Active=1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23)))
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
END

IF (@Stage = 3)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1048576 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE (SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND sa2.Active=1
			AND es2.ExternalSystemID = @ESID
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23) END AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Aux1 IS NOT NULL
	AND esy.Aux2 IS NULL
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data IN ('2','3') AND EXISTS (SELECT * 
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND es2.ExternalSystemID = @ESID
			AND sa2.Active=1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > getdate())
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23)))
END

IF (@Stage = 4)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
262144 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= getdate()) OR (sa.CancelDate <= getdate()) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= getdate()) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
131072 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
4096 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESCPanel (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan, sa.Password AS SAPassword, sa.Email, CASE WHEN sad.Data IS NOT NULL AND sad.Data LIKE '%.%' THEN 'y' ELSE 'n' END AS ip, sad.Data AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 524288 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan,
NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Aux1 <> COALESCE(esat.ExternalRef,at1.AccountType)
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL

SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, sa.Password AS SAPassword,
NULL AS cplan, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, 
CASE WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'Account canceled' ELSE 'Account Expired' END AS reason,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)

	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= getdate()) OR (sa.CancelDate <= getdate()) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= getdate()) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESDirectAdmin (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, sad2.Data AS domain, COALESCE(esat.ExternalRef,at1.AccountType) AS package, sa.Password, sa.Email, sad.Data AS ip
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	LEFT JOIN SubAccountData sad2 ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 25)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 4
	AND sad2.Data IS NOT NULL
	AND sa.Login IS NOT NULL
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, sa.Password
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 4
	AND sa.Login IS NOT NULL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, CASE WHEN ma.CancelDate < getdate() OR sa.CancelDate < getdate() THEN 'Account canceled' ELSE 'Account Expired' END AS reason
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)

	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= getdate()) OR (sa.CancelDate <= getdate()) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= getdate()) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.MBRCloseAutoList AS
SET NOCOUNT ON
DECLARE @Days INT, @CancelReasonID INT

SELECT @Days = NumValue FROM Configs WHERE ConfigID = 376
SELECT @CancelReasonID = NumValue FROM Configs WHERE ConfigID = 375

SELECT ma.CustomerID, COALESCE(MAX(cgdc.NumValue),@CancelReasonID) AS CancelReasonID, MAX(COALESCE(p.ExpireDate,sa.ExpireDate)) AS CancelDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 376)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 375)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE bc.AutoBill = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CancelDate IS NULL
	AND sa.CancelDate IS NULL
	AND (p.PackageID IS NULL OR (p.Active = 1 AND p.CancelDate IS NULL))
	AND sa.ExpireDate IS NOT NULL
	AND COALESCE(cgdc.NumValue,@CancelReasonID) IS NOT NULL
	AND COALESCE(cgdd.NumValue,@Days) > 0
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) > DATEADD(dd,1 + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate)
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) > sa.BilledThru
	AND NOT EXISTS (SELECT * FROM SubAccounts sa2 
			WHERE sa2.CustomerID = ma.CustomerID 
			AND sa2.Active = 1
			AND sa2.PackageID IS NULL
			AND ((sa2.ExpireDate IS NULL) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < sa2.BilledThru) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < DATEADD(dd,1 + sa2.Extension + COALESCE(ma.OverDue,0),sa2.ExpireDate))))

	AND NOT EXISTS (SELECT * FROM Packages p2 
			WHERE p2.CustomerID = ma.CustomerID 
			AND p2.Active = 1
			AND ((p2.ExpireDate IS NULL) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < p2.BilledThru) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,@Days),getdate()) < DATEADD(dd,1 + p2.Extension + COALESCE(ma.OverDue,0),p2.ExpireDate))))
GROUP BY ma.CustomerID
GO

CREATE PROCEDURE dbo.DomainGlobalUse (@DomainID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @CBTCount INT, @GroupCount INT, @SignupServerCount INT

SELECT @CBTCount = COUNT(*) FROM CardBatchTypes WHERE DomainID = @DomainID
SELECT @GroupCount = COUNT(*) FROM Groups WHERE DomainID = @DomainID
SELECT @SignupServerCount = COUNT(*) FROM SignupServers WHERE DomainID = @DomainID

SELECT CASE WHEN @CBTCount > 0 OR @GroupCount > 0 OR @SignupServerCount > 0 THEN 1 ELSE 0 END AS GlobalUse

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.DomainCustAllowed (@CustomerID INT, @AccountTypeID INT, @DomainID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @GroupID INT, @AllowDomain INT, @Allowed INT

SELECT @GroupID = ma.GroupID, @AllowDomain = pat.AllowCustSetDomain
FROM PackageAccountTypes pat, Packages p, PackageTypes pt, MasterAccounts ma
	WHERE pat.AccountTypeID=@AccountTypeID
	AND pat.PackageTypeID=p.PackageTypeID
	AND p.PackageTypeID=pt.PackageTypeID
	AND p.Active=1
	AND p.CustomerID=@CustomerID
	AND pt.CustomerAccess=1
	AND pat.AllowCustSetDomain = 1
	AND pat.CustomerMax > 0
	AND p.CustomerID = ma.CustomerID

IF (@AllowDomain = 1)
BEGIN
SELECT @Allowed = COUNT(*) 
FROM Domains 
	WHERE DomainID = @DomainID 
	AND CustomerAccess = 1 
	AND ((GroupID IS NULL AND 1 IN (SELECT GlobalDomains FROM Groups WHERE GroupID = @GroupID))
		OR GroupID = @GroupID
		OR ServiceGroupID IN (SELECT ServiceGroupID FROM ServiceGroupItems WHERE GroupID = @GroupID))
END

SELECT CASE WHEN @Allowed > 0 THEN 1 ELSE 0 END AS Allowed
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.CustSAInfo (@AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT ma.PaymentTypeID, ma.CancelDate, bc.AutoBill, 
CASE WHEN sa.RemoteAccess = 2 THEN 1 ELSE 0 END AS SendBill,
CASE WHEN sa.RemoteAccess > 0 THEN 1 ELSE 0 END AS RemoteAccess,
CASE WHEN ma.PendingBalance <= 0 THEN 1 ELSE 0 END AS HaveCredit
FROM SubAccounts sa, MasterAccounts ma, BillingCycles bc 
	WHERE sa.AccountID=@AccountID
	AND ma.CustomerID=sa.CustomerID 
	AND ma.BillingCycleID=bc.BillingCycleID

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESGenericWS (@ESID INT) AS
SET NOCOUNT ON
DECLARE @APILogin VARCHAR(64), @APIPassword VARCHAR(64), @APIRef VARCHAR(64)
SELECT @APILogin = Login, @APIPassword = Password, @APIRef = Aux1 FROM ExternalSystems WHERE ExternalSystemID = @ESID

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT es.ExternalSyncID, 2048 AS TransTypeID, @APILogin AS APILogin, @APIPassword AS APIPassword, @APIRef AS APIRef, ma.CustomerID, sa.AccountID,
d.MailDomain AS Domain, CASE WHEN d.MailDomain = es.Aux1 THEN 0 ELSE 1 END AS chDomain,
sa.Login, CASE WHEN sa.Login = es.Login THEN 0 ELSE 1 END AS chLogin,
sa.Password, CASE WHEN sa.Password = es.Password THEN 0 ELSE 1 END AS chPassword,
sa.FirstName, CASE WHEN sa.FirstName = es.Aux2 THEN 0 ELSE 1 END AS chFirstName,
sa.LastName, CASE WHEN sa.LastName = es.Aux3 THEN 0 ELSE 1 END AS chLastName,
at1.AccountType AS ServiceType, CASE WHEN es.Aux4 = at1.AccountType THEN 0 ELSE 1 END AS chServiceType,
esat.ExternalRef, CASE WHEN COALESCE(es.Aux5,' ') = COALESCE(esat.ExternalRef,' ') THEN 0 ELSE 1 END AS chExternalRef,
(SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID) AS Alias,
CASE WHEN COALESCE(es.Aux6,' ') = COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chAlias,
(SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID) AS Forward,
CASE WHEN COALESCE(es.Aux7,' ') = COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chForward,
CASE WHEN es.Created = 0 THEN 'add' WHEN sa.Active <> 1 OR sa.Active <> 1 THEN 'delete' ELSE 'update' END AS Action,
CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END AS Active, 

CASE WHEN CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END = es.Active THEN 0 ELSE 1 END AS chActive

FROM MasterAccounts ma, SubAccounts sa, ExternalSyncs es, AccountTypes at1, ExternalSystemAccountTypes esat, Domains d
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = es.AccountID
	AND sa.DomainID = d.DomainID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND esat.AccountTypeID = at1.AccountTypeID
	AND es.ExternalSystemID = @ESID
	AND (sa.Active IN (0,-1) 
		OR ma.Active IN (0,-1)
		OR d.MailDomain <> es.Aux1
		OR sa.Login <> es.Login
		OR sa.Password <> es.Password
		OR COALESCE(sa.FirstName,' ') <> COALESCE(es.Aux2,' ')
		OR COALESCE(sa.LastName,' ') <> COALESCE(es.Aux3,' ')
		OR at1.AccountType <> es.Aux4
		OR COALESCE(esat.ExternalRef,' ')  <> COALESCE(es.Aux5,' ')
		OR CASE WHEN ma.Active = 1 
			AND sa.Active = 1
			AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
			AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
			AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
			AND DATALENGTH(sa.Password) > 2
		THEN 1 ELSE 0 END <> es.Active

		OR COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID=sa.AccountID),'') <> COALESCE(es.Aux6,'')
		OR COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID=sa.AccountID),'') <> COALESCE(es.Aux7,'')
	)
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

CREATE PROCEDURE dbo.ESGenericWSUP (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON

IF (@Retcode = 0)
BEGIN
UPDATE es SET Login = sa.Login, Password = sa.Password, LastUpdate = GETDATE(), LastModifyDate = GETDATE(), ErrorCount = 0, Message = NULL,
Aux1 = d.MailDomain, Aux2 = sa.FirstName, Aux3 = sa.LastName, Aux4 = at1.AccountType, Aux5 = esat.ExternalRef, 
Aux6 = (SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID),
Aux7 = (SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID),
Created = CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END,
Active = CASE WHEN ma.Active = 1 
--es
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 2
--ee
	THEN 1 ELSE 0 END

FROM MasterAccounts ma, SubAccounts sa, ExternalSyncs es, AccountTypes at1, ExternalSystemAccountTypes esat, Domains d
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = es.AccountID
	AND sa.DomainID = d.DomainID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND esat.AccountTypeID = at1.AccountTypeID
	AND es.ExternalSyncID = @ExternalSyncID

DELETE FROM ExternalSyncs WHERE ExternalSyncID = @ExternalSyncID AND Created = 0

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.MBROpenChkStartDate (@CustomerID INT, @startdate DATETIME) AS
SET NOCOUNT ON
SELECT DISTINCT i.InvoiceID, i.Amount, i.CreateDate
FROM Invoices i, InvoiceItems ii, SubAccounts sa
	WHERE i.InvoiceID = ii.InvoiceID
	AND ii.AccountID = sa.AccountID
	AND sa.Active = 1
	AND ii.Canceled = 0
	AND i.VoidDate IS NULL
	AND ii.StartDate <> ii.EndDate
	AND ii.Amount <> 0
	AND ii.ItemType = 3
	AND ii.EndDate > @startdate
	AND i.CustomerID = @CustomerID
ORDER BY i.InvoiceID DESC
GO

CREATE PROCEDURE dbo.SAOpenChkStartDate (@AccountID INT, @startdate DATETIME) AS
SET NOCOUNT ON
SELECT i.InvoiceID, i.Amount, i.CreateDate
FROM SubAccounts sa, Invoices i, InvoiceItems ii
	WHERE sa.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.StartDate <> ii.EndDate
	AND ii.Amount <> 0
	AND ii.ItemType = 3
	AND sa.AccountID = @AccountID
	AND ii.EndDate > @startdate
ORDER BY i.InvoiceID DESC
GO

CREATE PROCEDURE dbo.SARateHistory (@CustomerID INT, @AccountID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT  r.Description AS Rate, rr.RateRule, rs.RateSource, rh.StartDate, DATEADD(mm,1,rh.StartDate) AS EndDate,
rh.TotalCount, (CAST(rh.TotalTime AS NUMERIC(18,4))/3600) as TotalHours, CAST(rh.TotalData AS NUMERIC(18,4))/1000000 AS TotalMB, rh.TotalCost, rh.ChargeID
FROM RateHistory rh JOIN Rates r ON (rh.RateID=r.RateID)
	JOIN RateSources rs ON (r.RateSourceID=rs.RateSourceID)
	JOIN RateRules rr ON (rh.RateRuleID=rr.RateRuleID)
	WHERE rh.AccountID = @AccountID
	AND rh.CustomerID = @CustomerID
ORDER BY rh.StartDate DESC
GO

CREATE PROCEDURE dbo.InvoicePOSCredit (@InvoiceID INT) AS
SET NOCOUNT ON
INSERT INTO Charges (CustomerID,AccountID,PackageID,ChargeTypeID,AccountTypeID,PackageTypeID,ItemID,Login,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser)
SELECT i.CustomerID, ii.AccountID, ii.PackageID, ii.ChargeTypeID, ii.AccountTypeID, ii.PackageTypeID, ii.ItemID, ii.Login, ii.Description, ii.StartDate, ii.EndDate, 1, ii.Amount, ii.Quantity, i.LastModifyDate, i.LastModifyUser
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.InvoiceID = @InvoiceID
	AND ii.Quantity > 0
	AND ii.Amount <= -0.01
GO

CREATE PROCEDURE dbo.ESDiino (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
sa.Login AS Username, sa.Password, sa.FirstName, sa.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS Email,
c.Abbr2 AS country, NULL AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
NULL AS username, sa.Password, sa.FirstName, sa.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS Email,
c.Abbr2 AS country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATALENGTH(sa.Password) > 5
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate()
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
END
GO

CREATE PROCEDURE dbo.ESEFolderUpdate (@ExternalSyncID INT, @TransTypeID INT, @Data VARCHAR(128), @Retcode INT) AS
SET NOCOUNT ON
DECLARE @Login VARCHAR(64), @Aux1 VARCHAR(255), @Password VARCHAR(128)

IF (@Retcode = 0)
BEGIN
SELECT @Login = COALESCE(sa.Login,sa.Email), @Password = sa.Password, @Aux1 = COALESCE(esat.ExternalRef,'') + COALESCE(esat.Description,'')
FROM SubAccounts sa, ExternalSyncs es, ExternalSystemAccountTypes esat
	WHERE sa.AccountID = es.AccountID
	AND es.ExternalSyncID = @ExternalSyncID
	AND es.ExternalSystemID = esat.ExternalSystemID
	AND sa.AccountTypeID = esat.AccountTypeID

IF (@TransTypeID = 1024)
BEGIN
UPDATE	ExternalSyncs SET ErrorCount = 0, Message = NULL, Login = @Login, Password = @Password, Aux1 = @Aux1, Aux2 = NULL, Aux3 = NULL, 
	CreateDate = getdate(), LastModifyDate = getdate(), LastUpdate = getdate(), Active = 1, Created = 1, ProcTransID = @Data
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 524288)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux1 = @Aux1
	WHERE ExternalSyncID = @ExternalSyncID
END

IF (@TransTypeID = 1048576)
BEGIN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = getdate(), Aux2 = CASE WHEN Aux2 IS NULL THEN @Data WHEN CAST(Aux2 AS BIGINT) < CAST(@Data AS BIGINT) THEN @Data ELSE Aux2 END
	WHERE ExternalSyncID = @ExternalSyncID
END

END ELSE BEGIN
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message = @Data, LastModifyDate = getdate() WHERE ExternalSyncID = @ExternalSyncID
END
GO

CREATE PROCEDURE dbo.ESEFolder (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,CHARINDEX(':',esat.ExternalRef)+1,20) ELSE NULL END AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
sa.Login AS Username,
sa.Password,
ma.Company AS ct_company,
sa.FirstName AS ct_firstname,
sa.Lastname AS ct_lastname,
COALESCE(sa.PhoneHome,ma.PhoneHome) AS ct_phone,
ma.Address1 AS ct_address1,
ma.Address2 AS ct_address2,
ma.City as ct_city,
s.Abbreviation AS ct_state,
ma.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
ma.Company AS ct_company,
sa.FirstName AS ct_firstname,
sa.Lastname AS ct_lastname,
COALESCE(sa.PhoneHome,ma.PhoneHome) AS ct_phone,
ma.Address1 AS ct_address1,
ma.Address2 AS ct_address2,
ma.City as ct_city,
s.Abbreviation AS ct_state,
ma.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < ma.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate()
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
sa.Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> COALESCE(esat.ExternalRef,'') + COALESCE(esat.Description,''))

UNION ALL
SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND es.Aux2 IS NOT NULL
	AND esy.LastModifyDate < DATEADD(mi,-(CAST(es.Aux2 AS INTEGER)),getdate())
END
GO

CREATE PROCEDURE dbo.ESGMail (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @cnt INT

IF (@Stage = 1)
BEGIN
SELECT @cnt = COUNT(*) FROM ExternalSyncs WHERE ExternalSystemID = @ESID AND AccountID IS NULL
IF (@cnt = 0)
	BEGIN
	INSERT INTO ExternalSyncs (ExternalSystemID) VALUES(@ESID)
	END

SELECT 67108864 AS TransTypeID,
esy.ExternalSyncID,
NULL AS Auth,
'ini' AS ExportFilter,
es.Login AS APILogin,
es.Password AS APIPassword,
NULL AS Login,
NULL AS NewLogin,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName
FROM ExternalSystems es, ExternalSyncs esy
	WHERE es.ExternalSystemID = esy.ExternalSystemID
	AND es.ExternalSystemID = @ESID
	AND esy.AccountID IS NULL
	AND esy.aux1 IS NULL
	AND (esy.Aux8 IS NULL OR esy.LastModifyDate < DATEADD(hh,-2,getdate()))
END

IF (@Stage = 2)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID AND es.Aux1 IS NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID,Aux1)
SELECT DISTINCT @ESID, sa.AccountID, CAST(a.AliasID AS VARCHAR(16))
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND a.AccountID = es.AccountID AND a.AliasID = CAST(es.Aux1 AS INTEGER))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND DATALENGTH(a.Alias) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
sa.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 3)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2097152 AS TransTypeID,
esa.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esa.Aux2 AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	LEFT JOIN Aliases a ON (sa.AccountID = a.AccountID AND CAST(esa.Aux1 AS INTEGER) = a.AliasID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND DATALENGTH(esa.Aux2) > 1
	AND esa.Aux2 IS NOT NULL
	AND A.AliasID IS NULL

UNION ALL

SELECT 1048576 AS TransTypeID,
esa.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
a.Alias AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	JOIN Aliases a ON (sa.AccountID = a.AccountID AND CAST(esa.Aux1 AS INTEGER) = a.AliasID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND DATALENGTH(a.Alias) > 1
	AND esa.Aux2 IS NULL

UNION ALL

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND (esy.LastUpdate < sa.LastModifyDate OR esy.LastUpdate < ma.LastModifyDate)

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate()
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 5
END

IF (@Stage = 4)
BEGIN
SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 8192 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
sa.Login AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Login <> sa.Login
END
GO

CREATE PROCEDURE dbo.ESAptilo (@ESID INT, @Stage INT) AS
SET NOCOUNT ON

IF (@Stage = 1)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
sa.Login + '@' + d.MailDomain AS Username,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ma.Email,sa.Email) AS Email,
COALESCE(sa.PhoneHome,sa.PhoneWork) AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' + CAST(at1.DataLeft AS VARCHAR(16)) END accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'normal' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 2)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ma.Email,sa.Email) AS Email,
COALESCE(sa.PhoneHome,sa.PhoneWork) AS Phonenumber,
NULL AS accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'timereducer' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' + CAST(at1.DataLeft AS VARCHAR(16)) END AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(sa.LastDataLeftDate AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND at1.DataLeft IS NOT NULL
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> CAST(sa.LastDataLeftDate AS VARCHAR(32)))

UNION ALL

SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) + '-' + RIGHT('00' + CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) + '-' + RIGHT('00' + CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux2 IS NULL OR esy.Aux2 <> CAST(DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) AS VARCHAR(32)))
END
GO

CREATE PROCEDURE dbo.ESZimbra (@ESID INT, @Stage INT) AS
SET NOCOUNT ON
DECLARE @cnt INT

IF (@Stage = 1)
BEGIN
SELECT @cnt = COUNT(*) FROM ExternalSyncs WHERE ExternalSystemID = @ESID AND AccountID IS NULL
IF (@cnt = 0)
	BEGIN
	INSERT INTO ExternalSyncs (ExternalSystemID) VALUES(@ESID)
	END

SELECT 67108864 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin, 
es.Password AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
NULL AS AuthToken,
NULL AS COSID

FROM ExternalSystems es, ExternalSyncs esy
	WHERE es.ExternalSystemID = esy.ExternalSystemID
	AND es.ExternalSystemID = @ESID
	AND esy.AccountID IS NULL
	AND esy.aux1 IS NULL
	AND (esy.Aux8 IS NULL OR esy.LastModifyDate < DATEADD(mi,-30,getdate()))
END

IF (@Stage = 2)
BEGIN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT @ESID, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND es.AccountID = sa.AccountID AND es.Aux1 IS NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL

INSERT INTO ExternalSyncs (ExternalSystemID,AccountID,Aux1)
SELECT DISTINCT @ESID, sa.AccountID, a.Alias
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID = @ESID AND a.AccountID = es.AccountID AND a.Alias = es.Aux1)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND DATALENGTH(a.Alias) > 1
	AND es.ExternalSyncID IS NULL

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
ma.Address1 AS Address1,
ma.City AS City,
s.State AS State,
ma.Zip AS Zip,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
ma.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0
END

IF (@Stage = 3)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
ma.Address1 AS Address1,
ma.City AS City,
s.State AS State,
ma.Zip AS Zip,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
ma.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.LastUpdate < sa.LastModifyDate OR esy.LastUpdate < ma.LastModifyDate)

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND (sa.CancelDate IS NULL OR sa.CancelDate > getdate())
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > getdate())
	AND esy.Created = 1
	AND esy.Active = 0

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,CASE WHEN COALESCE(sa.CancelDate,ma.CancelDate) < getdate() THEN 1 ELSE sa.Extension + 1 + COALESCE(ma.OverDue,0) END,sa.ExpireDate) < getdate()
	AND esy.Created = 1
	AND esy.Active = 1	

UNION ALL

SELECT 8192 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE esy.Created = 1
	AND esy.Login <> sa.Login

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
sa.Password AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 1048576 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
a.Alias AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND DATALENGTH(a.Alias) > 1
	AND esa.Aux2 IS NULL

UNION ALL

SELECT 2097152 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
esa.Aux1 AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID = @ESID AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	LEFT JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esa.Aux2 IS NOT NULL
	AND A.AliasID IS NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID = @ESID AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID = @ESID)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID = @ESID AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID = @ESID AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,getdate()))
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
END
GO

CREATE PROCEDURE dbo.CallsMissing (@numdays INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT c.NASIdentifier,
SUM(CASE WHEN c.AcctStatusType = 1 AND c2.AcctStatusType IS NULL THEN 1 ELSE 0 END) AS MissingStopCount, 
SUM(CASE WHEN c.AcctStatusType = 2 AND c2.AcctStatusType IS NULL THEN 1 ELSE 0 END) AS MissingStartCount
FROM Calls c LEFT JOIN Calls c2 ON (c.CallID <> c2.CallID AND c.NASIdentifier = c2.NASIdentifier AND c.AcctSessionID = c2.AcctSessionID AND c.NASPort = c2.NASPort AND c.Username = c2.Username)
	WHERE c.CallDate > DATEADD(dd,-@numdays,getdate())
GROUP BY c.NASIdentifier
ORDER BY 2 DESC, 3 DESC
GO

CREATE PROCEDURE dbo.CallsMissingDetail (@numdays INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT DISTINCT c.CallDate,c.CallID,c.AccountID,c.UserName,
CASE WHEN c.AcctStatusType = 1 THEN 'Stop' ELSE 'Start' END AS Missing, CASE WHEN sp.AcctSessionID IS NULL THEN 'No' ELSE 'Yes' END AS Online, c.NASIdentifier,c.AcctSessionID,
CAST(c.AcctOutputOctets / 1000000.0 AS NUMERIC(18,2)) AS DownloadMB,
CAST(c.AcctInputOctets / 1000000.0 AS NUMERIC(18,2)) AS UploadMB,
CAST(c.AcctSessionTime / 60.0 AS NUMERIC(18,2)) AS SessionMins,c.AcctDelayTime
FROM Calls c LEFT JOIN Calls c2 ON (c.CallID <> c2.CallID AND c.NASIdentifier = c2.NASIdentifier AND c.AcctSessionID = c2.AcctSessionID AND c.NASPort = c2.NASPort AND c.Username = c2.Username)
	LEFT JOIN ServerPorts sp ON (c.AcctSessionID = sp.AcctSessionID AND sp.NASIdentifier = c.NASIdentifier AND c.NASPort = sp.Port AND c.Username = sp.Username)
	WHERE c.CallDate > DATEADD(dd,-@numdays,getdate())
	AND c.AcctStatusType IN (1,2)
	AND ((c.AcctStatusType = 1 AND c2.AcctStatusType IS NULL)
		OR (c.AcctStatusType = 2 AND c2.AcctStatusType IS NULL))
ORDER BY 7,6,1,3,5
GO

CREATE PROCEDURE dbo.AssignStaticIP(@IPAddress VARCHAR(64), @AccountID INT) AS 
SET NOCOUNT ON
IF (@IPAddress IS NOT NULL AND @AccountID IS NOT NULL)
BEGIN
UPDATE RadIPAddresses SET State = 2, AccountID = @AccountID WHERE State = 0 AND IPAddress = @IPAddress
IF (@@ROWCOUNT = 0)
	BEGIN
	SELECT 'IP Address ' + @IPAddress + ' not in pool or already assigned/unavailable' AS Status
	END ELSE BEGIN
	UPDATE RadIPAddresses SET State = 0, AccountID = NULL WHERE State = 2 AND AccountID = @AccountID AND IPAddress <> @IPAddress
	SELECT 'IP Address ' + @IPAddress + ' successfully assigned' AS Status
	END
END ELSE BEGIN
SELECT 'IP and AccountID required' AS Status
END
GO

CREATE PROCEDURE dbo.RateVDNISClear (@RateVDNISID INT) AS
SET NOCOUNT ON
DELETE FROM RateVDNISItems WHERE RateVDNISID = @RateVDNISID
GO

CREATE PROCEDURE dbo.RateVDNISImport (@RateVDNISID INT, @prefix VARCHAR(64), @rate NUMERIC(18,4), @label VARCHAR(128), @location VARCHAR(128), @country VARCHAR(128), @state VARCHAR(128)) AS
SET NOCOUNT ON
DECLARE @CountryID INT, @StateID INT

IF (@country IS NOT NULL)
BEGIN
SELECT @CountryID = MIN(CountryID) FROM Countries WHERE Country = @country OR Abbr2 = @country OR Abbr3 = @country
END

IF (@state IS NOT NULL)
BEGIN
SELECT @StateID = MIN(StateID) FROM States WHERE (@CountryID IS NULL OR @CountryID = CountryID) AND (State = @state OR Abbreviation = @state)
END

IF (@prefix IS NOT NULL AND @rate IS NOT NULL)
BEGIN
INSERT INTO RateVDNISItems (RateVDNISID,RateVDNISItem,DNIS,Location,RateMatchTypeID,IntervalCost,IntervalOption,CountryID,StateID,SortOrder)
VALUES(@RateVDNISID,COALESCE(@label,@prefix),@prefix,@location,2,@rate,1,@CountryID,@StateID,0)
END
GO

CREATE PROCEDURE dbo.NSFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.NSGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x500uniqueIdentifier,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
'mailbox' AS mailDeliveryOption,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS inetuserstatus,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS mailuserstatus,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + d.MailDomain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS rfc822mailbox,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.CGPROPartialNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE 
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain END AS pk
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.Active IN (-1,0) OR ma.Active IN (-1,0) OR p.Active IN (-1,0))
	AND (sa.Login <> ' ' OR sa.Email LIKE '%_@_%')
	AND sa.Password <> ' '
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.CGPROGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
CASE
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain END AS pk,
CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> ' ' THEN sa.Login END AS uid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.LastName AS sn,
sa.AccountID,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance) THEN '{crypt}abcdefghijklm'
WHEN (ma.CancelDate < getdate() OR sa.CancelDate < getdate()) THEN '{crypt}abcdefghijklm'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN '{crypt}abcdefghijklm'
ELSE sa.Password 
END AS userpassword,
CASE WHEN al.Alias IS NULL THEN 
	CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain
	END ELSE NULL END AS mail,
es.MailHost AS hostserver,
'clear' AS passwordEncryption
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Password <> ' '
	AND (sa.Email LIKE '%_@_%' OR sa.Login <> ' ')
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.GeneralGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id

SELECT DISTINCT sa.AccountID,
COALESCE(sa.LastName,'N/A') AS sn,
COALESCE(sa.FirstName,' ') + ' ' + COALESCE(sa.LastName,' ') AS cn,
CASE WHEN sa.Email IS NOT NULL AND sa.Email <> ' ' THEN sa.Email ELSE sa.Login END AS uid,
sa.Password AS userPassword,
g.GroupName AS ou,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login + '@' + d.MailDomain ELSE sa.Email END AS mail,
sa.PhoneHome AS telephoneNumber,
COALESCE(s.Abbreviation,s.State) AS st,
ma.Zip AS postalCode,
sa.AccountID AS uniqueIdentifier,
sa.LastModifyUser AS LastModifiedBy,
sa.LastModifyDate AS LastModifyDate,
ma.Address1 AS streetAddress,
ma.PhoneFax AS facsimileTelephoneNumber,
COALESCE(ma.Company,'N/A') AS o,
CASE 	WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'Inactive' 
	WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < getdate() THEN 'Canceled'
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'Over Credit Limit'
	WHEN DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'Expired'
	ELSE 'Active'
END AS organizationalStatus,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS otherMailbox

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.GeneralFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID AS uniqueIdentifier
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.Name = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

CREATE PROCEDURE dbo.MDGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.FirstName + ' ' + sa.LastName AS mdFullName,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mdForwardAddress,
'N' AS mdKeepForwardedMail,
CASE WHEN fw.Forward IS NULL THEN 'N' ELSE 'Y' END AS mdIsForwarding,
es.MailHost AS mailHost,
sa.Password AS mdPassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'N' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'N'
	WHEN (ma.CancelDate < getdate() OR sa.CancelDate < getdate()) THEN 'N'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'N'
	ELSE 'Y' END
END AS mdAllowAccess,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,
es.LogFile + '/' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mdMailDir, 
ma.Address1 AS mdHomeAddress,
ma.City AS mdHomeCity,
s.State AS mdHomeState,
ma.Zip AS mdHomeZipcode,
c.Country AS mdHomeCountry,
ma.PhoneHome AS mdHomePhone,
ma.PhoneFax AS mdHomeFax,
ma.Company AS mdBusCompany,
ma.PhoneWork AS mdBusPhone

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.MDFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT CASE WHEN sa.Email LIKE '%@%' THEN sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain END
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.Password <> ' '
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.PosixGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
-- Read & Set Last Retreive Date
DECLARE @lmdate DATETIME, @calls INT, @pasid INT, @pasuid INT, @accountid INT, @uid INT
EXEC LDAPSetLastModifyDate 'read', @id
SELECT @lmdate = LastSyncWrite, @calls = Calls
FROM LDAPServers
	WHERE LDAPServer = @id

-- Find the lowest avaliable uidNumber and assign it.

-- Starting UID
SELECT @uid = 1000
IF NOT EXISTS (SELECT * FROM PosixAccountUIDs WHERE LDAPServer = @id)
BEGIN
WHILE(@uid < 65535)
	BEGIN
	INSERT INTO PosixAccountUIDs (uidNumber,PosixAccountUserID,LDAPServer) VALUES(@uid,NULL,@id)
	SELECT @uid = @uid + 1
	END
END

DECLARE onebyone CURSOR FOR
SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, PosixAccountServers pas
	WHERE sa.CustomerID = ma.CustomerID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau2, PosixAccountUIDs pai2 WHERE AccountID = sa.AccountID AND pau2.PosixAccountUserID = pai2.PosixAccountUserID AND pai2.LDAPServer = @id)
	AND sa.AccountTypeID = pas.AccountTypeID
	AND pas.LDAPServer = @id
	AND sa.Password <> ' '
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)

OPEN onebyone
FETCH NEXT FROM onebyone INTO @accountid
WHILE(@@FETCH_STATUS <> -1)
BEGIN
SELECT @uid = NULL, @pasuid = NULL, @pasid = NULL

SELECT @uid = MIN(uidNumber) FROM PosixAccountUIDs
	WHERE PosixAccountUserID IS NULL
	AND LDAPServer = @id

SELECT @pasid = PosixAccountServerID
FROM PosixAccountServers pas, SubAccounts sa
	WHERE sa.AccountID = @accountid
	AND pas.AccountTypeID = sa.AccountTypeID

INSERT INTO PosixAccountUsers (PosixAccountServerID,AccountID)
	VALUES(@pasid,@accountid)

SELECT @pasuid = PosixAccountUserID FROM PosixAccountUsers
	WHERE AccountID = @accountid

IF (@pasuid IS NOT NULL)
SELECT @uid = uidNumber FROM PosixAccountUIDs
	WHERE PosixAccountUserID = @pasuid
	AND LDAPServer = @id

UPDATE PosixAccountUIDs
	SET PosixAccountUserID = @pasuid
		WHERE uidNumber = @uid
		AND LDAPServer = @id

IF NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau, PosixAccountUIDs pai
		WHERE pai.PosixAccountUserID = pau.PosixAccountUserID)
BEGIN
RAISERROR('UID Assignment Failed. Make sure all 65535 UIDs are not in use',10,1,50000)
END

FETCH NEXT FROM onebyone INTO @accountid
END
CLOSE onebyone
DEALLOCATE onebyone

-- Periodically remove deleted entries to free up uids.
IF @calls % 50 = 0
BEGIN
DELETE FROM PosixAccountUsers
FROM PosixAccountUsers pau
WHERE NOT EXISTS (SELECT 1 FROM SubAccounts sa, MasterAccounts ma WHERE sa.AccountID = pau.AccountID AND ma.CustomerID = sa.CustomerID AND ma.Active IN (1,0) AND sa.Active IN (1,0))

UPDATE pai SET PosixAccountUserID = NULL
FROM PosixAccountUIDs pai
	WHERE NOT EXISTS (SELECT 1 FROM PosixAccountUsers WHERE PosixAccountUserID = pai.PosixAccountUserID)
	AND PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
END

SELECT DISTINCT sa.AccountID as accountid, pai.uidNumber AS uidnumber,
CASE	WHEN ma.Active = 0 OR sa.Active = 0 OR p.Active = 0 THEN 1
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 1
	WHEN ma.CancelDate < getdate() THEN 1
	WHEN ma.OverLimit > 0 THEN NULL
	ELSE DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate)) END AS shadowexpire,
CASE WHEN al.Alias IS NOT NULL THEN NULL ELSE COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) END AS rfc822mailbox,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
COALESCE(sa.FirstName,' ') + ' ' + COALESCE(sa.LastName,' ') AS cn,
COALESCE(sa.LastName,'N/A') as sn,
COALESCE(sa.FirstName,'N/A') as gn,
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END AS uid,
CASE WHEN pau.userPassword <> ' ' THEN pau.UserPassword ELSE sa.Password END AS userpassword,
COALESCE(Pau.loginShell,pas.loginShell) AS loginshell,
COALESCE(pau.gidNumber,pas.gidNumber) AS gidNumber,
CASE WHEN pau.homeDirectory <> ' ' THEN pau.homeDirectory ELSE pas.homeDirectory + '/' + CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END END AS homedirectory,
d.MailDomain AS dc

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN PosixAccountUsers pau ON (sa.AccountID = pau.AccountID)
	JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID AND sa.AccountTypeID = pas.AccountTypeID)
	JOIN PosixAccountUIDs pai ON (pau.PosixAccountUserID = pai.PosixAccountUserID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Password <> ' '
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)
	AND sa.Active IN (1,0)
	AND ma.Active IN (1,0)
	AND pas.LDAPServer = @id
GO

CREATE PROCEDURE dbo.PosixFullNegSync @id VARCHAR(50) AS
SET NOCOUNT ON
SELECT uidNumber 
FROM PosixAccountUIDs 
	WHERE PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
GO

CREATE PROCEDURE dbo.QmailGetPartial (@id VARCHAR(50)) AS
SET NOCOUNT ON
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'disabled' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'nopop'
	WHEN ma.OverLimit > 0 THEN 'active'
	WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'nopop'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0)+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'nopop'
	ELSE 'active' END END AS accountStatus,
CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress, './' + CAST(sa.AccountID AS VARCHAR(10)) + '/' AS mailMessageStore,
CASE WHEN fw.Forward IS NULL THEN 'noforward' ELSE 'nolocal' END AS deliveryMode

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	JOIN LDAPServers ls ON (ls.LDAPServer = @id)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name = @id
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
GO

CREATE PROCEDURE dbo.QmailFullNegSync (@id VARCHAR(50)) AS
SET NOCOUNT ON
SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.Name = @id
GO

CREATE PROCEDURE dbo.ReportAgingSnapshot (@snapdate DATETIME, @OrganizationID INT, @GroupID INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #rad (CustomerID INT, Days INT, Amount NUMERIC(18,4))

INSERT INTO #rad (CustomerID, Days, Amount)
SELECT MIN(i.CustomerID), DATEDIFF(dd,MIN(i.CreateDate),@snapdate), ROUND(MIN(ii.Amount) * MIN(ii.Quantity),2) - SUM(pi1.Amount)
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID AND pi1.ActiveDate <= @snapdate AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate > @snapdate))
	WHERE (i.VoidDate IS NULL OR i.VoidDate > @snapdate)
	AND i.CreateDate <= @snapdate
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Processed = 1
	AND i.Estimate = 0
GROUP BY ii.ItemID
HAVING SUM(pi1.Amount) < ROUND(MIN(ii.Amount) * MIN(ii.Quantity),2)

SELECT ma.CustomerID, MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, MIN(ma.Company) AS Company, MIN(ma.PhoneWork) AS PhoneWork, MIN(ma.PhoneHome) AS PhoneHome,
SUM(CASE WHEN Days < 30 THEN Amount ELSE 0 END) AS Age0, 
SUM(CASE WHEN Days BETWEEN 30 AND 59 THEN Amount ELSE 0 END) AS Age30, 
SUM(CASE WHEN Days BETWEEN 60 AND 89 THEN Amount ELSE 0 END) AS Age60, 
SUM(CASE WHEN Days BETWEEN 90 AND 119 THEN Amount ELSE 0 END) AS Age90, 
SUM(CASE WHEN Days >= 120 THEN Amount ELSE 0 END) AS Age120
FROM MasterAccounts ma JOIN #rad r ON (ma.CustomerID = r.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (@GroupID IS NULL OR ma.GroupID = @GroupID)
	AND (@OrganizationID IS NULL OR g.OrganizationID = @OrganizationID)
GROUP BY ma.CustomerID
ORDER BY SUM(r.Amount) DESC

DROP TABLE #rad
GO

CREATE PROCEDURE dbo.OnlineServerPorts AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT DISTINCT sp.NASIdentifier, s.Server
FROM ServerPorts sp JOIN Servers s ON (sp.ServerID = s.ServerID)
	WHERE sp.AcctStatusType IN (1,3)
GO

CREATE PROCEDURE dbo.AuditLogsAdd (@LogMsgID INT, @CustomerID INT, @AccountID INT, @LogMsg VARCHAR(255), @Operator VARCHAR(64)) AS
SET NOCOUNT ON
INSERT INTO AuditLogs (LogMsgID,CustomerID,AccountID,LogMsg,Operator) VALUES(@LogMsgID,@CustomerID,@AccountID,@LogMsg,@Operator)
GO

CREATE PROCEDURE dbo.AppLock (@IEALockID INT, @IPAddress VARCHAR(64), @holdsecs INT) AS
SET NOCOUNT ON
UPDATE IEALocks SET RefCount = RefCount + 1, LastModifyDate = getdate(), IPAddress = @IPAddress
	WHERE IEALockID = @IEALockID
	AND @IPAddress IS NOT NULL
	AND (IPAddress IS NULL OR IPAddress = @IPAddress OR DATEDIFF(ss,LastModifyDate,getdate()) > @holdsecs)

SELECT CASE WHEN @@ROWCOUNT = 1 THEN 1 ELSE 0 END AS Locked
GO

