CREATE PROCEDURE dbo.CT_IncidentStateGroups (@IncidentStateGroup VARCHAR(255),@IncidentStateGroupID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT IncidentStateGroups ON


INSERT INTO IncidentStateGroups (IncidentStateGroup,IncidentStateGroupID)
VALUES (@IncidentStateGroup,@IncidentStateGroupID)
SET IDENTITY_INSERT IncidentStateGroups OFF
GO

CREATE PROCEDURE dbo.CT_RateTimeGroups (@RateTimeGroup VARCHAR(255),@RateTimeGroupID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT RateTimeGroups ON


INSERT INTO RateTimeGroups (RateTimeGroup,RateTimeGroupID)
VALUES (@RateTimeGroup,@RateTimeGroupID)
SET IDENTITY_INSERT RateTimeGroups OFF
GO

CREATE PROCEDURE dbo.CT_RateTimes (@DayWeekMask INT,@Description VARCHAR(255),@EndHour SMALLINT,@EndMinute SMALLINT,@MonthDay SMALLINT,@MonthMask INT,@Priority SMALLINT,@RateTimeGroupID INT,@StartHour SMALLINT,@StartMinute SMALLINT,@WeekNumMask INT) AS
SET NOCOUNT ON
INSERT INTO RateTimes (DayWeekMask,Description,EndHour,EndMinute,MonthDay,MonthMask,Priority,RateTimeGroupID,StartHour,StartMinute,WeekNumMask)
VALUES (@DayWeekMask,@Description,@EndHour,@EndMinute,@MonthDay,@MonthMask,@Priority,@RateTimeGroupID,@StartHour,@StartMinute,@WeekNumMask)
GO

CREATE PROCEDURE dbo.CT_Roles (@Role VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO Roles ([Role])
VALUES (@Role)
GO

CREATE PROCEDURE dbo.CT_ReportGroups (@Description VARCHAR(255),@OperatorGroupID INT,@ReportGroup VARCHAR(255),@ReportGroupID INT,@SortOrder INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT ReportGroups ON


INSERT INTO ReportGroups (Description,OperatorGroupID,ReportGroup,ReportGroupID,SortOrder)
VALUES (@Description,@OperatorGroupID,@ReportGroup,@ReportGroupID,@SortOrder)
SET IDENTITY_INSERT ReportGroups OFF
GO

CREATE PROCEDURE dbo.CT_Reports (@FileName VARCHAR(255),@GroupID INT,@Report VARCHAR(255),@ReportGroupID INT,@ReportType INT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE Reports SET GroupID = @GroupID,
	Report = @Report,
	ReportGroupID = @ReportGroupID,
	ReportType = @ReportType,
	SortOrder = @SortOrder
	WHERE FileName = @FileName

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO Reports (FileName,GroupID,Report,ReportGroupID,ReportType,SortOrder)
VALUES (@FileName,@GroupID,@Report,@ReportGroupID,@ReportType,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT_ReportFields (@CRFieldName VARCHAR(255),@DataType SMALLINT,@DefaultValue VARCHAR(255),@Description VARCHAR(255),@EWSFile VARCHAR(255),@FieldName VARCHAR(255),@ReportField VARCHAR(255),@ReportFieldID INT,@StringID INT) AS
SET NOCOUNT ON
UPDATE ReportFields SET CRFieldName = @CRFieldName,
	DataType = @DataType,
	DefaultValue = @DefaultValue,
	Description = @Description,
	EWSFile = @EWSFile,
	FieldName = @FieldName,
	ReportField = @ReportField,
	StringID = @StringID
	WHERE ReportFieldID = @ReportFieldID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportFields (CRFieldName,DataType,DefaultValue,Description,EWSFile,FieldName,ReportField,ReportFieldID,StringID)
VALUES (@CRFieldName,@DataType,@DefaultValue,@Description,@EWSFile,@FieldName,@ReportField,@ReportFieldID,@StringID)
END
GO

CREATE PROCEDURE dbo.CT_ReportParameters (@FileName VARCHAR(255),@ReportFieldID INT,@Required SMALLINT,@SortOrder SMALLINT) AS
SET NOCOUNT ON
UPDATE ReportParameters SET Required = @Required,
	SortOrder = @SortOrder
	WHERE FileName = @FileName
	AND ReportFieldID = @ReportFieldID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO ReportParameters (FileName,ReportFieldID,Required,SortOrder)
VALUES (@FileName,@ReportFieldID,@Required,@SortOrder)
END
GO

CREATE PROCEDURE dbo.CT2_PrintTypes (@CRData VARCHAR(255),@Data VARCHAR(255),@PrintType VARCHAR(255),@PrintTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE PrintTypes SET CRData = @CRData,
	Data = @Data,
	PrintType = @PrintType
	WHERE PrintTypeID = @PrintTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO PrintTypes (CRData,Data,PrintType,PrintTypeID)
VALUES (@CRData,@Data,@PrintType,@PrintTypeID)
END
GO

CREATE PROCEDURE dbo.CT2_EmailTypes (@EmailType VARCHAR(255),@EmailTypeID SMALLINT) AS
SET NOCOUNT ON
UPDATE EmailTypes SET EmailType = @EmailType
	WHERE EmailTypeID = @EmailTypeID

IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO EmailTypes (EmailType,EmailTypeID)
VALUES (@EmailType,@EmailTypeID)
END
GO

CREATE PROCEDURE dbo.CT_SendMethods (@Description VARCHAR(255),@EmailAutoTrans SMALLINT,@EmailTypeID SMALLINT,@PrintAutoTrans SMALLINT,@PrintTypeID SMALLINT,@SendMethodID INT,@SortOrder SMALLINT,@StringID INT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT SendMethods ON


INSERT INTO SendMethods (Description,EmailAutoTrans,EmailTypeID,PrintAutoTrans,PrintTypeID,SendMethodID,SortOrder,StringID)
VALUES (@Description,@EmailAutoTrans,@EmailTypeID,@PrintAutoTrans,@PrintTypeID,@SendMethodID,@SortOrder,@StringID)
SET IDENTITY_INSERT SendMethods OFF
GO

CREATE PROCEDURE dbo.CT_TaxExemptions (@Active SMALLINT,@AllowItem SMALLINT,@AllowMBR SMALLINT,@Exemption VARCHAR(255),@StringID INT,@TaxExemptionID INT) AS
SET NOCOUNT ON
INSERT INTO TaxExemptions (Active,AllowItem,AllowMBR,Exemption,StringID,TaxExemptionID)
VALUES (@Active,@AllowItem,@AllowMBR,@Exemption,@StringID,@TaxExemptionID)
GO

CREATE PROCEDURE dbo.CT_TaxPiggyBacks (@TaxPiggyBack VARCHAR(255)) AS
SET NOCOUNT ON
INSERT INTO TaxPiggyBacks (TaxPiggyBack)
VALUES (@TaxPiggyBack)
GO

CREATE PROCEDURE dbo.CT_Domains (@Description VARCHAR(255),@Domain VARCHAR(255),@DomainID INT,@GroupID INT,@MailDomain VARCHAR(255),@SortOrder SMALLINT) AS
SET NOCOUNT ON
DECLARE @CTcnt INT
SET IDENTITY_INSERT Domains ON


INSERT INTO Domains (Description,Domain,DomainID,GroupID,MailDomain,SortOrder)
VALUES (@Description,@Domain,@DomainID,@GroupID,@MailDomain,@SortOrder)
SET IDENTITY_INSERT Domains OFF
GO

CREATE PROCEDURE dbo.CT_Schedules (@TaskName VARCHAR(255),@Parameter VARCHAR(255),@TargetSecs INT,@MaxSecs INT,@Status SMALLINT,@Interval INT,@StartHH INT, @StartMI INT, @Aligned SMALLINT, @Description VARCHAR(255),@Active SMALLINT,@MaxConcurrent INT,@LastModifyUser VARCHAR(255),@Operator VARCHAR(255)) AS
SET NOCOUNT ON
DECLARE @StartDate DATETIME
SELECT @StartDate = DATEADD(mi,@StartMI,DATEADD(hh,@StartHH,DATEADD(hh,-(DATEPART(hh,getdate())),DATEADD(mi,-(DATEPART(mi,getdate())),getdate()))))
INSERT INTO Schedules (Active,Aligned,Description,Interval,LastModifyDate,LastModifyUser,LastStart,LastStatus,LastUpdate,LockServerID,MaxConcurrent,MaxSecs,Operator,Parameter,Server,StartDate,Status,TargetSecs,TaskName)
VALUES (@Active,@Aligned,@Description,@Interval,getdate(),@LastModifyUser,NULL,NULL,NULL,NULL,@MaxConcurrent,@MaxSecs,@Operator,@Parameter,NULL,@StartDate,@Status,@TargetSecs,@TaskName)
GO

CREATE PROCEDURE dbo.CT_RateStatusCalls AS
SET NOCOUNT ON
INSERT INTO RateStatusCalls(LastCallID,Leader,LastUpdate,LastMessage,Advisor,LastAdviceDate)
VALUES(0,NULL,getdate(),NULL,NULL,getdate())
GO

