CREATE OR REPLACE PROCEDURE CT_AllowedHosts (Description_ IN VARCHAR2,IPAddress_ IN VARCHAR2) AS
BEGIN
INSERT INTO AllowedHosts (Description,IPAddress)
VALUES (Description_,IPAddress_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_CancelReasons (CancelReason_ IN VARCHAR2,CustomerAccess_ IN SMALLINT,Returning_ IN SMALLINT,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
INSERT INTO CancelReasons (CancelReason,CustomerAccess,Returning,SortOrder,StringID)
VALUES (CancelReason_,CustomerAccess_ ,Returning_ ,SortOrder_ ,StringID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_BillingCycles (AutoBill_ IN SMALLINT,BillDay_ IN INTEGER,CycleType_ IN SMALLINT,Description_ IN VARCHAR2,EBillDays_ IN INTEGER,Extension_ IN SMALLINT,IBillDays_ IN INTEGER,RenewDays_ IN INTEGER,RenewPeriods_ IN INTEGER,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
INSERT INTO BillingCycles (AutoBill,BillDay,CycleType,Description,EBillDays,Extension,IBillDays,RenewDays,RenewPeriods,SortOrder,StringID)
VALUES (AutoBill_,BillDay_ ,CycleType_ ,Description_ ,EBillDays_ ,Extension_ ,IBillDays_ ,RenewDays_ ,RenewPeriods_ ,SortOrder_ ,StringID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_ChargeTypes (Amount_ IN NUMERIC,ChargeUses_ IN INTEGER,Description_ IN VARCHAR2,ServiceGroupID_ IN INTEGER,SortOrder_ IN SMALLINT,StringID_ IN INTEGER,TaxExemptions_ IN INTEGER) AS
BEGIN
INSERT INTO ChargeTypes (Amount,ChargeUses,Description,ServiceGroupID,SortOrder,StringID,TaxExemptions)
VALUES (Amount_,ChargeUses_ ,Description_ ,ServiceGroupID_ ,SortOrder_ ,StringID_ ,TaxExemptions_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_Discounts (Amount_ IN NUMERIC,AmountType_ IN SMALLINT,Discount_ IN VARCHAR2,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
INSERT INTO Discounts (Amount,AmountType,Discount,SortOrder,StringID)
VALUES (Amount_,AmountType_ ,Discount_ ,SortOrder_ ,StringID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_IncidentTypes (CustomerAccess_ IN SMALLINT,Description_ IN VARCHAR2,Email_ IN VARCHAR2,EscalateDays_ IN SMALLINT,IncidentStateGroupID_ IN INTEGER,IncidentType_ IN VARCHAR2,OverDays_ IN SMALLINT,ShowCustDueDate_ IN SMALLINT,ShowCustomerAccess_ IN SMALLINT,ShowDueDate_ IN SMALLINT,ShowDuration_ IN SMALLINT,ShowEmail_ IN SMALLINT,ShowPriority_ IN SMALLINT,ShowSummary_ IN SMALLINT,SortOrder_ IN SMALLINT,WarnDays_ IN SMALLINT) AS
BEGIN
INSERT INTO IncidentTypes (CustomerAccess,Description,Email,EscalateDays,IncidentStateGroupID,IncidentType,OverDays,ShowCustDueDate,ShowCustomerAccess,ShowDueDate,ShowDuration,ShowEmail,ShowPriority,ShowSummary,SortOrder,WarnDays)
VALUES (CustomerAccess_,Description_ ,Email_ ,EscalateDays_ ,IncidentStateGroupID_ ,IncidentType_ ,OverDays_ ,ShowCustDueDate_ ,ShowCustomerAccess_ ,ShowDueDate_ ,ShowDuration_ ,ShowEmail_ ,ShowPriority_ ,ShowSummary_ ,SortOrder_ ,WarnDays_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_IncidentStates (CustomerAccess_ IN SMALLINT,Description_ IN VARCHAR2,IncidentState_ IN VARCHAR2,IncidentStateGroupID_ IN INTEGER,Priority_ IN SMALLINT,SortOrder_ IN SMALLINT,StatArchive_ IN SMALLINT,StatBlock_ IN SMALLINT,StatEscalate_ IN SMALLINT,StatOpen_ IN SMALLINT,StatWait_ IN SMALLINT,Style_ IN VARCHAR2) AS
BEGIN
INSERT INTO IncidentStates (CustomerAccess,Description,IncidentState,IncidentStateGroupID,Priority,SortOrder,StatArchive,StatBlock,StatEscalate,StatOpen,StatWait,Style)
VALUES (CustomerAccess_,Description_ ,IncidentState_ ,IncidentStateGroupID_ ,Priority_ ,SortOrder_ ,StatArchive_ ,StatBlock_ ,StatEscalate_ ,StatOpen_ ,StatWait_ ,Style_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_OperatorGroups (Description_ IN VARCHAR2,InternalUse_ IN SMALLINT,OperatorGroup_ IN VARCHAR2) AS
BEGIN
INSERT INTO OperatorGroups (Description,InternalUse,OperatorGroup)
VALUES (Description_,InternalUse_ ,OperatorGroup_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_Operators AS
BEGIN
INSERT INTO Operators (PrintTypeID,OperatorGroupID,Operator,Password,Email,WebObjectAccess,CountryID)
SELECT 2, og.OperatorGroupID, 'admin','pass1',NULL,1,840
FROM OperatorGroups og
	WHERE OperatorGroup = 'Admin'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'admin')
UNION ALL
SELECT 2, og.OperatorGroupID, 'signup','signup',NULL,1,NULL
FROM OperatorGroups og
	WHERE OperatorGroup = 'CustomerSignup'
	AND NOT EXISTS (SELECT * FROM Operators WHERE Operator = 'signup');
END;
/

CREATE OR REPLACE PROCEDURE CT_OperatorGroupAccess (ObjectGroupID_ IN INTEGER,OperatorGroup_ IN VARCHAR2,AccessType_ IN INTEGER) AS
BEGIN
DECLARE
OperatorGroupID_ INTEGER;
BEGIN
SELECT OperatorGroupID INTO OperatorGroupID_  FROM OperatorGroups WHERE OperatorGroup = OperatorGroup_;
IF (OperatorGroupID_ IS NOT NULL) THEN
UPDATE OperatorGroupAccess SET AccessType =AccessType_
	WHERE ObjectGroupID =ObjectGroupID_
	AND OperatorGroupID =OperatorGroupID_
	AND GroupID = 1;
IF (SQL%ROWCOUNT = 0) THEN
	INSERT INTO OperatorGroupAccess (ObjectGroupID,OperatorGroupID,GroupID,AccessType)
	VALUES (ObjectGroupID_,OperatorGroupID_ ,1,AccessType_ );
END IF;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_PayPeriods (Amount_ IN NUMERIC,AmountType_ IN SMALLINT,ConfirmTrans_ IN SMALLINT,PayPeriod_ IN VARCHAR2,Period_ IN SMALLINT,PeriodTypeID_ IN INTEGER,SetupCharge_ IN SMALLINT,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
INSERT INTO PayPeriods (Amount,AmountType,ConfirmTrans,PayPeriod,Period,PeriodTypeID,SetupCharge,SortOrder,StringID)
VALUES (Amount_,AmountType_ ,ConfirmTrans_ ,PayPeriod_ ,Period_ ,PeriodTypeID_ ,SetupCharge_ ,SortOrder_ ,StringID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_AccountTypes (AccountType_ IN VARCHAR2,ApplyDiscount_ IN SMALLINT,ChangeClose_ IN SMALLINT,ChangeFrom_ IN SMALLINT,ChangeOpen_ IN SMALLINT,ChangeTo_ IN SMALLINT,Cost_ IN NUMERIC,Description_ IN VARCHAR2,HomeDirSize_ IN INTEGER,LoginLimit_ IN SMALLINT,OverDue_ IN SMALLINT,RemoteAccess_ IN SMALLINT,RequireUserPass_ IN INTEGER,SendBill_ IN SMALLINT,SortOrder_ IN SMALLINT,StringID_ IN INTEGER,TimeLeft_ IN INTEGER) AS
BEGIN
INSERT INTO AccountTypes (AccountType,ApplyDiscount,ChangeClose,ChangeFrom,ChangeOpen,ChangeTo,Cost,Description,HomeDirSize,LoginLimit,OverDue,RemoteAccess,RequireUserPass,SendBill,SortOrder,StringID,TimeLeft)
VALUES (AccountType_,ApplyDiscount_ ,ChangeClose_ ,ChangeFrom_ ,ChangeOpen_ ,ChangeTo_ ,Cost_ ,Description_ ,HomeDirSize_ ,LoginLimit_ ,OverDue_ ,RemoteAccess_ ,RequireUserPass_ ,SendBill_ ,SortOrder_ ,StringID_ ,TimeLeft_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_RadATConfigs AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN
SELECT COUNT(*) INTO CTcnt_  FROM RadATConfigs;
IF (CTcnt_ = 0) THEN
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,Data,Value,RadCheck)
SELECT AccountTypeID,6,0,' ',2,0 FROM AccountTypes
UNION ALL
SELECT AccountTypeID,7,0,' ',1,0 FROM AccountTypes;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadFilterGroups (Active_ IN SMALLINT,Description_ IN VARCHAR2,DestData_ IN VARCHAR2,DestRadFilterGroupID_ IN INTEGER,RadDestTypeID_ IN INTEGER,RadFilterGroup_ IN VARCHAR2,RadFilterGroupID_ IN INTEGER,RadSourceTypeID_ IN INTEGER,SortOrder_ IN SMALLINT) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT RadFilterGroups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO RadFilterGroups (Active,Description,DestData,DestRadFilterGroupID,RadDestTypeID,RadFilterGroup,RadFilterGroupID,RadSourceTypeID,SortOrder)
VALUES (Active_,Description_ ,DestData_ ,DestRadFilterGroupID_ ,RadDestTypeID_ ,RadFilterGroup_ ,RadFilterGroupID_ ,RadSourceTypeID_ ,SortOrder_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE CT_RadFilters (Data_ IN VARCHAR2,Location_ IN VARCHAR2,RadAttributeID_ IN INTEGER,RadFilterGroupID_ IN INTEGER,RadFilterTypeID_ IN INTEGER,RadMergeTypeID_ IN INTEGER,RadSearchTypeID_ IN INTEGER,RadVendorID_ IN INTEGER) AS
BEGIN
INSERT INTO RadFilters (Data,Location,RadAttributeID,RadFilterGroupID,RadFilterTypeID,RadMergeTypeID,RadSearchTypeID,RadVendorID)
VALUES (Data_,Location_ ,RadAttributeID_ ,RadFilterGroupID_ ,RadFilterTypeID_ ,RadMergeTypeID_ ,RadSearchTypeID_ ,RadVendorID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_ReferredBys (GroupID_ IN INTEGER,ReferredBy_ IN VARCHAR2,SortOrder_ IN SMALLINT,StringID_ IN INTEGER) AS
BEGIN
INSERT INTO ReferredBys (GroupID,ReferredBy,SortOrder,StringID)
VALUES (GroupID_,ReferredBy_ ,SortOrder_ ,StringID_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_Regions (Region_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
INSERT INTO Regions (Region,SortOrder)
VALUES (Region_,SortOrder_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_SalesPersons (Active_ IN SMALLINT,SalesPerson_ IN VARCHAR2,SortOrder_ IN SMALLINT) AS
BEGIN
INSERT INTO SalesPersons (Active,SalesPerson,SortOrder)
VALUES (Active_,SalesPerson_ ,SortOrder_ );
END;
/

CREATE OR REPLACE PROCEDURE CT_ServerGroups (ServerGroup_ IN VARCHAR2) AS
BEGIN
INSERT INTO ServerGroups (ServerGroup)
VALUES (ServerGroup_);
END;
/

CREATE OR REPLACE PROCEDURE CT_Servers AS
BEGIN
INSERT INTO Servers (ServerGroupID,Server,ServerType,IPAddress,Location,Secret) 
SELECT ServerGroupID,'localhost',-1,'127.0.0.1','local','localhost'
FROM ServerGroups
	WHERE ServerGroup = 'Other';
END;
/

CREATE OR REPLACE PROCEDURE CT_AddressTypes (AddressType_ IN VARCHAR2,RequiredFields_ IN VARCHAR2,ShowFields_ IN INTEGER,SortOrder_ IN INTEGER) AS
BEGIN
INSERT INTO AddressTypes (AddressType,RequiredFields,ShowFields,SortOrder)
VALUES (AddressType_,RequiredFields_ ,ShowFields_ ,SortOrder_ );
END;
/

CREATE OR REPLACE PROCEDURE CT2_Groups (Active_ IN SMALLINT,AutoEmailInvoices_ IN SMALLINT,AutoEmailStatements_ IN SMALLINT,BillAddress1_ IN VARCHAR2,BillAddress2_ IN VARCHAR2,BillCity_ IN VARCHAR2,BillCountryID_ IN INTEGER,BillFax_ IN VARCHAR2,BillName_ IN VARCHAR2,BillPhone_ IN VARCHAR2,BillState_ IN VARCHAR2,BillZip_ IN VARCHAR2,BillingOption_ IN SMALLINT,Description_ IN VARCHAR2,DomainID_ IN INTEGER,EmailAccounts_ IN VARCHAR2,EmailSubject_ IN VARCHAR2,EndDate_ IN DATE,FTPDir_ IN VARCHAR2,GlobalAccountTypes_ IN SMALLINT,GlobalBillingCycles_ IN SMALLINT,GlobalChargeTypes_ IN SMALLINT,GlobalDiscounts_ IN SMALLINT,GlobalDomains_ IN SMALLINT,GlobalIncidentTypes_ IN SMALLINT,GlobalPackageTypes_ IN SMALLINT,GlobalPayPeriods_ IN SMALLINT,GlobalRegions_ IN SMALLINT,GlobalSalesPersons_ IN SMALLINT,GlobalSendMethods_ IN SMALLINT,GroupID_ IN INTEGER,GroupName_ IN VARCHAR2,InvoiceHTMLReport_ IN VARCHAR2,InvoiceReport_ IN VARCHAR2,InvoiceTextReport_ IN VARCHAR2,MBRFields_ IN INTEGER,OrganizationID_ IN INTEGER,PaymentTypes_ IN INTEGER,SendCredits_ IN SMALLINT,SortOrder_ IN SMALLINT,StartDate_ IN DATE,StatementHTMLReport_ IN VARCHAR2,StatementReport_ IN VARCHAR2,StatementTextReport_ IN VARCHAR2,ThemeID_ IN INTEGER,ThemeScore_ IN INTEGER) AS
BEGIN
DECLARE
CTcnt_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CTcnt_  FROM Groups WHERE GroupID = GroupID_;
IF (CTcnt_ = 0) THEN

SELECT Groups_seq.nextval INTO CTcnt_ 

 FROM DUAL;

INSERT INTO Groups (Active,AutoEmailInvoices,AutoEmailStatements,BillAddress1,BillAddress2,BillCity,BillCountryID,BillFax,BillName,BillPhone,BillState,BillZip,BillingOption,Description,DomainID,EmailAccounts,EmailSubject,EndDate,FTPDir,GlobalAccountTypes,GlobalBillingCycles,GlobalChargeTypes,GlobalDiscounts,GlobalDomains,GlobalIncidentTypes,GlobalPackageTypes,GlobalPayPeriods,GlobalRegions,GlobalSalesPersons,GlobalSendMethods,GroupID,GroupName,InvoiceHTMLReport,InvoiceReport,InvoiceTextReport,MBRFields,OrganizationID,PaymentTypes,SendCredits,SortOrder,StartDate,StatementHTMLReport,StatementReport,StatementTextReport,ThemeID,ThemeScore)
VALUES (Active_,AutoEmailInvoices_ ,AutoEmailStatements_ ,BillAddress1_ ,BillAddress2_ ,BillCity_ ,BillCountryID_ ,BillFax_ ,BillName_ ,BillPhone_ ,BillState_ ,BillZip_ ,BillingOption_ ,Description_ ,DomainID_ ,EmailAccounts_ ,EmailSubject_ ,EndDate_ ,FTPDir_ ,GlobalAccountTypes_ ,GlobalBillingCycles_ ,GlobalChargeTypes_ ,GlobalDiscounts_ ,GlobalDomains_ ,GlobalIncidentTypes_ ,GlobalPackageTypes_ ,GlobalPayPeriods_ ,GlobalRegions_ ,GlobalSalesPersons_ ,GlobalSendMethods_ ,GroupID_ ,GroupName_ ,InvoiceHTMLReport_ ,InvoiceReport_ ,InvoiceTextReport_ ,MBRFields_ ,OrganizationID_ ,PaymentTypes_ ,SendCredits_ ,SortOrder_ ,StartDate_ ,StatementHTMLReport_ ,StatementReport_ ,StatementTextReport_ ,ThemeID_ ,ThemeScore_ );
END IF;
END;
END;
