CREATE OR REPLACE FUNCTION DatePart(date_part IN VARCHAR2, date_in IN DATE) RETURN NUMBER IS
BEGIN
RETURN TO_NUMBER(TO_CHAR(date_in,CASE WHEN date_part = 'hh' THEN 'HH24' ELSE date_part END));
END;
/

CREATE OR REPLACE FUNCTION CHARINDEX(string1 IN VARCHAR2, string2 IN VARCHAR2) RETURN INTEGER IS
BEGIN
RETURN INSTR(string2,string1);
END;
/

CREATE OR REPLACE FUNCTION RIGHT(string1 IN VARCHAR2, rightchars IN NUMBER) RETURN VARCHAR2 IS
BEGIN
RETURN SUBSTR(string1,(LENGTH(string1)-rightchars)+1);
END;
/

CREATE OR REPLACE FUNCTION Substring(string1 IN VARCHAR2, starting IN NUMBER, len IN NUMBER) RETURN VARCHAR2 IS
BEGIN
RETURN SUBSTR(string1,starting,len);
END;
/

CREATE OR REPLACE FUNCTION GetDate 
RETURN date IS today date;
BEGIN
RETURN(sysdate);
END;
/

CREATE OR REPLACE Function dataLength( string_in IN varchar2)
RETURN integer IS string_length integer;
BEGIN
RETURN(LENGTH(string_in));
END;
/

CREATE OR REPLACE FUNCTION mm RETURN VARCHAR2 IS BEGIN RETURN('mm'); END;
/
CREATE OR REPLACE FUNCTION yy RETURN VARCHAR2 IS BEGIN RETURN('yyyy'); END;
/
CREATE OR REPLACE FUNCTION dd RETURN VARCHAR2 IS BEGIN RETURN('dd'); END;
/
CREATE OR REPLACE FUNCTION hh RETURN VARCHAR2 IS BEGIN RETURN('hh'); END;
/
CREATE OR REPLACE FUNCTION mi RETURN VARCHAR2 IS BEGIN RETURN('mi'); END;
/
CREATE OR REPLACE FUNCTION ss RETURN VARCHAR2 IS BEGIN RETURN('ss'); END;
/

CREATE OR REPLACE Function DateAdd(date_type IN varchar2, offset IN integer, date_in IN date )
RETURN date IS date_returned date;
BEGIN
date_returned := CASE date_type
	WHEN 'mm'   THEN add_months(date_in,TRUNC(offset))
	WHEN 'yyyy' THEN add_months(date_in,TRUNC(offset) * 12)
	WHEN 'dd'   THEN date_in + TRUNC(offset)
	WHEN 'hh'   THEN date_in + (TRUNC(offset) / 24)
	WHEN 'mi'   THEN date_in + (TRUNC(offset) /24/60)
	WHEN 'ss'   THEN date_in + (TRUNC(offset) /24/60/60)
	END;
RETURN(date_returned);
END;
/

CREATE OR REPLACE Function DateDiff( return_type IN varchar2, date_1 IN date, date_2 IN date)
RETURN integer IS number_return integer;
BEGIN
number_return := CASE return_type
	WHEN 'mm'   THEN ROUND(MONTHS_BETWEEN(TRUNC(date_2,'MM'),TRUNC(date_1, 'MM')))
	WHEN 'yyyy' THEN ROUND(MONTHS_BETWEEN(TRUNC(date_2,'YYYY'), TRUNC(date_1, 'YYYY')))/12
	WHEN 'dd'   THEN ROUND((TRUNC(date_2,'DD') - TRUNC(date_1, 'DD')))
	WHEN 'hh'   THEN (TRUNC(date_2,'HH') - TRUNC(date_1,'HH')) * 24
	WHEN 'mi'   THEN (TRUNC(date_2,'MI') - TRUNC(date_1,'MI')) * 24 * 60
	WHEN 'ss'   THEN (date_2 - date_1) * 24 * 60 * 60
	END;
RETURN(number_return);
END;
/

CREATE OR REPLACE PACKAGE LAST
AS
ID NUMBER;
FUNCTION IDENT RETURN NUMBER;
END;
/

CREATE OR REPLACE PACKAGE BODY LAST
AS
FUNCTION IDENT RETURN NUMBER IS
	BEGIN
	RETURN ID;
	END;
END;
/

CREATE OR REPLACE PACKAGE ieatypes AS
TYPE CursorType IS REF CURSOR;
END;
/
