CREATE TABLE dbo.AccountDataTypes (
       AccountDataTypeID    int NOT NULL,
       AccountDataType      varchar(64) NOT NULL,
       DataTypeID           smallint NOT NULL,
       AllowMBR             smallint NOT NULL DEFAULT 1,
       AllowSA              smallint NOT NULL DEFAULT 1,
       StringID             int NULL,
       SQLQuery             varchar(255) NULL,
       RegExp               varchar(255) NULL
)
go

CREATE INDEX i_ADT_ADTs ON dbo.AccountDataTypes
(
       AccountDataType
)
go


ALTER TABLE dbo.AccountDataTypes
       ADD PRIMARY KEY (AccountDataTypeID)
go


CREATE TABLE dbo.AccountDataValues (
       AccountDataTypeID    int NOT NULL,
       KeyData              varchar(128) NOT NULL,
       ValueData            varchar(128) NOT NULL
)
go


ALTER TABLE dbo.AccountDataValues
       ADD PRIMARY KEY (AccountDataTypeID, KeyData)
go


CREATE TABLE dbo.AccountTemplates (
       AccountTemplateID    int NOT NULL,
       AccountTemplate      varchar(128) NOT NULL,
       LoginLabel           varchar(128) NULL,
       LoginStringID        int NULL,
       SANew                varchar(64) NULL,
       SAEdit               varchar(64) NULL,
       SASave               varchar(64) NULL,
       SADetail             varchar(64) NULL,
       CustNew              varchar(64) NULL,
       CustEdit             varchar(64) NULL,
       CustEditLabel        varchar(128) NULL,
       CustEditStringID     int NULL,
       CustSave             varchar(64) NULL,
       SignupPage           varchar(64) NULL,
       SignupForm           varchar(64) NULL,
       SignupValidate       varchar(64) NULL,
       SignupSave           varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT (0),
       SignupBillSave       varchar(64) NULL
)
go


ALTER TABLE dbo.AccountTemplates
       ADD PRIMARY KEY (AccountTemplateID)
go


CREATE TABLE dbo.AccountTypes (
       AccountTypeID        int IDENTITY,
       AccountType          varchar(30) NOT NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          varchar(64) NOT NULL,
       StringID             int NULL,
       ApplyDiscount        smallint NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       RateClassID          int NULL,
       ChargeTypeID         int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       DNISGroupID          int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       OverDue              smallint NULL DEFAULT 0,
       GLCodeID             int NULL,
       LoginLimit           smallint NULL,
       TimeLeft             int NULL,
       HomeDirSize          int NULL,
       SendBill             smallint NULL,
       RemoteAccess         smallint NULL,
       PayPeriodID          int NULL,
       RadFailAccountTypeID int NULL,
       RadFailReason        smallint NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       NextID               int NULL,
       NextCount            int NULL,
       RequireUserPass      int NULL,
       ChangeOpen           smallint NOT NULL DEFAULT 1,
       ChangeTo             smallint NOT NULL DEFAULT 1,
       ChangeClose          smallint NOT NULL DEFAULT 1,
       ChangeFrom           smallint NOT NULL DEFAULT 1,
       DataLeft             BIGINT NULL,
       SecChargeTypeID      int NULL,
       AccountTemplateID    int NULL,
       DataLeftRenewal      smallint NULL,
       TimeLeftRenewal      smallint NULL,
       InactCanceledDays    smallint NULL
)
go

CREATE UNIQUE INDEX XAK1AccountTypes ON dbo.AccountTypes
(
       AccountType
)
go

CREATE INDEX i_AccountTypes_RFATID ON dbo.AccountTypes
(
       RadFailAccountTypeID
)
go


ALTER TABLE dbo.AccountTypes
       ADD PRIMARY KEY (AccountTypeID)
go


CREATE TABLE dbo.Actions (
       ActionID             int IDENTITY,
       IncidentID           int NOT NULL,
       CreateOperatorID     int NULL,
       CreateAccountID      int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       Description          text NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       CustomerAccess       smallint NOT NULL DEFAULT 0,
       Duration             int NOT NULL DEFAULT 0,
       IncidentTypeID       int NOT NULL,
       IncidentStateID      int NOT NULL,
       AssignRoleID         int NULL,
       AssignOperatorID     int NULL
)
go

CREATE INDEX i_Actions_IncidentID ON dbo.Actions
(
       IncidentID
)
go


ALTER TABLE dbo.Actions
       ADD PRIMARY KEY (ActionID)
go


CREATE TABLE dbo.Addresses (
       AddressID            int IDENTITY,
       CustomerID           int NULL,
       AddressTypeID        int NOT NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Company              varchar(80) NULL,
       Address1             varchar(80) NULL,
       Address2             varchar(80) NULL,
       City                 varchar(40) NULL,
       Zip                  varchar(20) NULL,
       Province             varchar(40) NULL,
       FirstName            varchar(40) NULL,
       LastName             varchar(40) NULL,
       Phone                varchar(32) NULL,
       Fax                  varchar(32) NULL,
       Email                varchar(80) NULL,
       WWW                  varchar(128) NULL,
       Comments             varchar(255) NULL
)
go


ALTER TABLE dbo.Addresses
       ADD PRIMARY KEY (AddressID)
go


CREATE TABLE dbo.AddressTypes (
       AddressTypeID        int IDENTITY,
       AddressType          varchar(64) NOT NULL,
       SortOrder            int NOT NULL DEFAULT 1,
       RequiredFields       varchar(255) NULL,
       ShowFields           int NOT NULL DEFAULT 65535
)
go


ALTER TABLE dbo.AddressTypes
       ADD PRIMARY KEY (AddressTypeID)
go


CREATE TABLE dbo.Aliases (
       AliasID              int IDENTITY,
       Alias                varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Aliases_AccountID ON dbo.Aliases
(
       AccountID
)
go

CREATE INDEX IX_Aliases_Alias ON dbo.Aliases
(
       Alias
)
go


ALTER TABLE dbo.Aliases
       ADD PRIMARY KEY (AliasID)
go


CREATE TABLE dbo.AllowedHosts (
       AllowedHostID        int IDENTITY,
       OperatorGroupID      int NULL,
       IPAddress            varchar(16) NULL,
       Description          varchar(100) NOT NULL
)
go


ALTER TABLE dbo.AllowedHosts
       ADD PRIMARY KEY (AllowedHostID)
go


CREATE TABLE dbo.Applications (
       ApplicationID        int NOT NULL,
       AppName              varchar(32) NOT NULL
)
go

CREATE INDEX XIE1Applications ON dbo.Applications
(
       AppName
)
go


ALTER TABLE dbo.Applications
       ADD PRIMARY KEY (ApplicationID)
go


CREATE TABLE dbo.AuditLogs (
       AuditLogID           int IDENTITY,
       LogMsgID             int NOT NULL,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       LogMsg               varchar(255) NOT NULL,
       Operator             varchar(64) NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       PackageID            int NULL
)
go

CREATE INDEX i_Logs_LogDate ON dbo.AuditLogs
(
       LogDate
)
go


ALTER TABLE dbo.AuditLogs
       ADD PRIMARY KEY (AuditLogID)
go


CREATE TABLE dbo.BankTrans (
       CustomerID           int NOT NULL,
       AuthName             varchar(64) NOT NULL,
       BankName             varchar(64) NOT NULL,
       BankPhone            varchar(20) NULL,
       ABANumber            varchar(128) NOT NULL,
       AccountNumber        varchar(128) NOT NULL,
       TransType            varchar(16) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       SSN                  varchar(128) NULL,
       DLNumber             varchar(128) NULL,
       DLState              varchar(40) NULL,
       BirthDate            datetime NULL
)
go


ALTER TABLE dbo.BankTrans
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.Batches (
       BatchID              int IDENTITY,
       BatchTypeID          int NOT NULL,
       BatchStateID         int NOT NULL,
       GroupID              int NULL,
       Operator             varchar(64) NOT NULL,
       StartDate            datetime NOT NULL DEFAULT getdate(),
       EndDate              datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL,
       BatchInfo            varchar(255) NULL,
       ItemCount            int NULL,
       ItemTotal            numeric(18,4) NULL,
       Rebatch              smallint NULL
)
go

CREATE INDEX i_Batches_GroupID ON dbo.Batches
(
       GroupID
)
go

CREATE INDEX i_Batches_BatchTypeID ON dbo.Batches
(
       BatchTypeID,
       BatchStateID
)
go

CREATE INDEX i_Batches_StartDate ON dbo.Batches
(
       StartDate
)
go


ALTER TABLE dbo.Batches
       ADD PRIMARY KEY (BatchID)
go


CREATE TABLE dbo.BatchProcessors (
       BatchProcessorID     int IDENTITY,
       OrganizationID       int NULL,
       GroupID              int NULL,
       ExportID             int NOT NULL,
       BatchProcessor       varchar(128) NOT NULL,
       BatchIn              varchar(255) NULL,
       BatchOut             varchar(255) NULL,
       BatchLimit           int NULL,
       Merchant             varchar(64) NULL,
       Store                varchar(64) NULL,
       Terminal             varchar(64) NULL,
       ImportOptions        int NULL,
       ExportOptions        int NULL,
       RebatchTries         int NULL DEFAULT 0,
       RebatchInterval      int NULL,
       ProcessorURL         varchar(255) NULL,
       Login                varchar(64) NULL,
       Password             varchar(128) NULL,
       CardTypes            int NOT NULL DEFAULT 255,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX Statistic_CardTypes ON dbo.BatchProcessors
(
       CardTypes
)
go


ALTER TABLE dbo.BatchProcessors
       ADD PRIMARY KEY (BatchProcessorID)
go


CREATE TABLE dbo.BatchStates (
       BatchStateID         int NOT NULL,
       BatchState           varchar(128) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.BatchStates
       ADD PRIMARY KEY (BatchStateID)
go


CREATE TABLE dbo.BatchTypes (
       BatchTypeID          int NOT NULL,
       BatchType            varchar(64) NOT NULL,
       StringID             int NULL,
       TableName            varchar(64) NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.BatchTypes
       ADD PRIMARY KEY (BatchTypeID)
go


CREATE TABLE dbo.BillingCycles (
       BillingCycleID       int IDENTITY,
       Description          varchar(45) NOT NULL,
       StringID             int NULL,
       CycleType            smallint NOT NULL DEFAULT 0,
       AutoBill             smallint NOT NULL DEFAULT 0,
       Extension            smallint NULL,
       BillDay              int NULL,
       IBillDays            int NOT NULL DEFAULT 15,
       EBillDays            int NOT NULL DEFAULT 5,
       RenewDays            int NOT NULL DEFAULT 0,
       RenewPeriods         int NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       LateFeeID            int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       TBillDays            int NULL
)
go


ALTER TABLE dbo.BillingCycles
       ADD PRIMARY KEY (BillingCycleID)
go


CREATE TABLE dbo.Calls (
       CallID               bigint IDENTITY,
       Username             varchar(64) NOT NULL,
       AcctSessionID        varchar(32) NOT NULL,
       NASIdentifier        varchar(32) NOT NULL,
       AcctStatusType       tinyint NOT NULL,
       NASPort              varchar(32) NOT NULL DEFAULT (-1),
       CallDate             smalldatetime NOT NULL DEFAULT getdate(),
       AcctDelayTime        int NULL DEFAULT 0,
       AcctSessionTime      int NULL DEFAULT 0,
       FramedAddress        varchar(32) NULL,
       AcctInputOctets      bigint NULL,
       AcctOutputOctets     bigint NULL,
       AcctTerminateCause   smallint NULL,
       NASPortType          tinyint NULL,
       NASPortDNIS          varchar(64) NULL,
       CallerID             varchar(64) NULL,
       ConnectInfo          varchar(64) NULL,
       ServerID             int NULL,
       AccountID            int NULL
)
go

CREATE UNIQUE CLUSTERED INDEX iCalls_CallID ON Calls
(
       CallID
)
go

CREATE INDEX iCalls_AccountID ON dbo.Calls
(
       AccountID
)
go

CREATE INDEX iCalls_ServerID ON dbo.Calls
(
       ServerID
)
go

CREATE INDEX iCalls_CallDate ON dbo.Calls
(
       CallDate
)
go


ALTER TABLE dbo.Calls
       ADD PRIMARY KEY NONCLUSTERED (Username, AcctSessionID, 
              NASIdentifier, AcctStatusType, NASPort, CallDate)
go


CREATE TABLE dbo.CancelReasons (
       CancelReasonID       int IDENTITY,
       CancelReason         varchar(128) NOT NULL,
       StringID             int NULL,
       Returning            smallint NOT NULL DEFAULT 0,
       CustomerAccess       smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.CancelReasons
       ADD PRIMARY KEY (CancelReasonID)
go


CREATE TABLE dbo.CardAccounts (
       CardAccountID        int IDENTITY,
       CardBatchID          int NOT NULL,
       OrganizationID       int NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       Login                varchar(40) NOT NULL,
       Password             varchar(128) NOT NULL,
       InactiveExpireDate   datetime NULL,
       FirstUseDate         datetime NULL,
       AllowCredit          smallint NOT NULL DEFAULT 1,
       UsedForCredit        smallint NOT NULL DEFAULT 0,
       LastCreditDate       datetime NULL,
       CreditAmount         numeric(18,4) NULL,
       AllowDirect          smallint NOT NULL DEFAULT 1,
       UsedForDirect        smallint NOT NULL DEFAULT 0,
       DirectCustomerID     int NULL,
       DirectAccountID      int NULL
)
go

CREATE UNIQUE INDEX I_CardAccounts_Login ON dbo.CardAccounts
(
       Login
)
go

CREATE INDEX I_CardAccounts_CardBatchID ON dbo.CardAccounts
(
       CardBatchID,
       Active
)
go


ALTER TABLE dbo.CardAccounts
       ADD PRIMARY KEY (CardAccountID)
go


CREATE TABLE dbo.CardBatches (
       CardBatchID          int IDENTITY,
       CardBatch            varchar(128) NULL,
       CardBatchTypeID      int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       Operator             varchar(64) NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       LastModifyDate       datetime NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NULL,
       InactiveExpireDate   datetime NULL,
       ActiveExpireDays     int NULL,
       TimeLeft             int NULL,
       BytesLeft            bigint NULL,
       Amount               numeric(18,4) NULL,
       GroupID              int NOT NULL,
       LoginCardDigitID     int NOT NULL,
       PasswordCardDigitID  int NOT NULL,
       AllowDirect          smallint NOT NULL DEFAULT 1,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          int NULL,
       SendMethodID         int NULL,
       BillingCycleID       int NULL,
       AccountTypeID        int NULL,
       DiscountID           int NULL,
       DomainID             int NULL,
       SalesPersonID        int NULL,
       RangeStart           numeric(18,4) NULL,
       BatchSize            int NOT NULL,
       RangeStep            numeric(18,4) NULL,
       LoginPrefix          varchar(10) NULL,
       LoginParm1           varchar(20) NULL,
       LoginParm2           varchar(20) NULL,
       PasswordParm1        varchar(20) NULL,
       PasswordParm2        varchar(20) NULL,
       Comments             text NULL,
       DataLeft             BIGINT NULL,
       ActiveExpireMins     int NULL
)
go


ALTER TABLE dbo.CardBatches
       ADD PRIMARY KEY (CardBatchID)
go


CREATE TABLE dbo.CardBatchTypes (
       CardBatchTypeID      int IDENTITY,
       CardBatchType        varchar(128) NOT NULL,
       InactiveExpireDays   int NULL,
       ActiveExpireDays     int NOT NULL DEFAULT 30,
       TimeLeft             int NULL,
       BytesLeft            int NULL,
       Amount               numeric(18,4) NULL,
       BatchSize            int NULL,
       GroupID              int NULL,
       LoginCardDigitID     int NOT NULL,
       PasswordCardDigitID  int NOT NULL,
       AllowDirectUse       smallint NOT NULL DEFAULT 1,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          int NULL,
       SendMethodID         int NULL,
       BillingCycleID       int NULL,
       AccountTypeID        int NULL,
       DiscountID           int NULL,
       DomainID             int NULL,
       SalesPersonID        int NULL,
       DataLeft             BIGINT NULL,
       ActiveExpireMins     int NULL
)
go


ALTER TABLE dbo.CardBatchTypes
       ADD PRIMARY KEY (CardBatchTypeID)
go


CREATE TABLE dbo.CardDigits (
       CardDigitID          int IDENTITY,
       CardDigit            varchar(64) NOT NULL,
       JavascriptHeader     text NULL,
       JavascriptField      text NOT NULL,
       AllowLogin           smallint NOT NULL DEFAULT 1,
       AllowPassword        smallint NOT NULL DEFAULT 1,
       IEAID                int NULL
)
go


ALTER TABLE dbo.CardDigits
       ADD PRIMARY KEY (CardDigitID)
go


CREATE TABLE dbo.CardTypePrefixes (
       CardTypeID           int NOT NULL,
       Prefix               varchar(5) NOT NULL
)
go


ALTER TABLE dbo.CardTypePrefixes
       ADD PRIMARY KEY (CardTypeID, Prefix)
go


CREATE TABLE dbo.CardTypes (
       CardTypeID           int NOT NULL,
       CardType             varchar(128) NOT NULL,
       Length1              int NULL,
       Length2              int NULL,
       CRC                  varchar(10) NOT NULL DEFAULT 'crc'
)
go


ALTER TABLE dbo.CardTypes
       ADD PRIMARY KEY (CardTypeID)
go


CREATE TABLE dbo.CCImportColumns (
       CCImportColumnID     int IDENTITY,
       ExportID             int NOT NULL,
       FieldType            smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Position             smallint NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL DEFAULT 0,
       FieldSize            smallint NOT NULL,
       ApproveValue         varchar(50) NULL,
       DeclineValue         varchar(50) NULL,
       ErrorValue           varchar(50) NULL,
       Line                 int NOT NULL DEFAULT 1,
       TransType            int NOT NULL DEFAULT 511,
       IEAID                int NULL
)
go


ALTER TABLE dbo.CCImportColumns
       ADD PRIMARY KEY (CCImportColumnID)
go


CREATE TABLE dbo.Charges (
       ChargeID             int IDENTITY,
       CustomerID           int NOT NULL,
       Description          varchar(64) NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       AccountID            int NULL,
       PackageID            int NULL,
       Login                varchar(64) NULL,
       AccountTypeID        int NULL,
       PackageTypeID        int NULL,
       DistFlag             smallint NOT NULL DEFAULT 1,
       AllowInterim         smallint NOT NULL DEFAULT 1,
       Prorated             smallint NOT NULL DEFAULT 0,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       ChargeTypeID         int NULL,
       ItemID               int NULL,
       Operator             varchar(64) NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       PrevChargeID         int NULL
)
go

CREATE INDEX iCustomerID ON dbo.Charges
(
       CustomerID
)
go

CREATE INDEX iItemID ON dbo.Charges
(
       ItemID
)
go


ALTER TABLE dbo.Charges
       ADD PRIMARY KEY (ChargeID)
go


CREATE TABLE dbo.ChargeTypes (
       ChargeTypeID         int IDENTITY,
       Description          varchar(45) NOT NULL,
       StringID             int NULL,
       Amount               numeric(18,4) NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       GLCodeID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       ChargeUses           int NOT NULL DEFAULT 65535
)
go


ALTER TABLE dbo.ChargeTypes
       ADD PRIMARY KEY (ChargeTypeID)
go


CREATE TABLE dbo.CommissionGroups (
       CommissionGroupID    int IDENTITY,
       CommissionGroup      varchar(128) NOT NULL,
       CommissionType       smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Active               smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.CommissionGroups
       ADD PRIMARY KEY (CommissionGroupID)
go


CREATE TABLE dbo.CommissionItems (
       CommissionItemID     int IDENTITY,
       CommissionGroupID    int NOT NULL,
       AccountTypeID        int NULL,
       PackageTypeID        int NULL,
       ChargeTypeID         int NULL,
       CommissionValue      numeric(18,4) NOT NULL,
       Comments             varchar(255) NULL
)
go

CREATE INDEX I_CI_AT ON dbo.CommissionItems
(
       CommissionGroupID,
       AccountTypeID
)
go

CREATE INDEX I_CI_PT ON dbo.CommissionItems
(
       CommissionGroupID,
       PackageTypeID
)
go

CREATE INDEX I_CI_CT ON dbo.CommissionItems
(
       CommissionGroupID,
       ChargeTypeID
)
go


ALTER TABLE dbo.CommissionItems
       ADD PRIMARY KEY (CommissionItemID)
go


CREATE TABLE dbo.ConfigGroupData (
       ConfigID             int NOT NULL,
       GroupID              int NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go

CREATE INDEX Statistic_NumValue ON dbo.ConfigGroupData
(
       NumValue
)
go


ALTER TABLE dbo.ConfigGroupData
       ADD PRIMARY KEY (ConfigID, GroupID)
go


CREATE TABLE dbo.ConfigGroups (
       ConfigGroupID        int NOT NULL,
       Name                 varchar(128) NOT NULL,
       SortOrder            int NOT NULL DEFAULT 1,
       VisibleGlobal        smallint NOT NULL DEFAULT 1,
       VisibleGroupID       smallint NOT NULL DEFAULT 0,
       VisibleOperatorGroupID smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ConfigGroups
       ADD PRIMARY KEY (ConfigGroupID)
go


CREATE TABLE dbo.ConfigOperatorGroupData (
       ConfigID             int NOT NULL,
       OperatorGroupID      int NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.ConfigOperatorGroupData
       ADD PRIMARY KEY (ConfigID, OperatorGroupID)
go


CREATE TABLE dbo.Configs (
       ConfigID             int NOT NULL,
       ConfigGroupID        int NOT NULL,
       DataTypeID           smallint NOT NULL DEFAULT 1,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       FeatureID            int NULL,
       AllowGlobal          smallint NOT NULL DEFAULT 1,
       AllowGroupID         smallint NOT NULL DEFAULT 0,
       AllowOperatorGroupID smallint NOT NULL DEFAULT 0,
       ValuesQuery          varchar(255) NULL,
       NumValue             numeric(18,4) NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.Configs
       ADD PRIMARY KEY (ConfigID)
go


CREATE TABLE dbo.ConfigValues (
       ConfigID             int NOT NULL,
       NumValue             numeric(18,4) NOT NULL,
       ValueName            varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ConfigValues
       ADD PRIMARY KEY (ConfigID, NumValue)
go


CREATE TABLE dbo.Continents (
       ContinentID          int NOT NULL,
       Continent            varchar(64) NOT NULL,
       Planet               varchar(64) NOT NULL,
       Hidden               smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.Continents
       ADD PRIMARY KEY (ContinentID)
go


CREATE TABLE dbo.Countries (
       CountryID            int NOT NULL,
       Country              varchar(64) NOT NULL,
       InternetDomain       varchar(5) NULL,
       ContinentID          int NOT NULL,
       TelPrefix            varchar(10) NULL,
       TelIDD               varchar(32) NULL,
       TelNDD               varchar(32) NULL,
       TelLocPrefixLen      smallint NULL,
       Abbr2                char(2) NULL,
       Abbr3                char(3) NULL,
       Hidden               smallint NOT NULL DEFAULT 0,
       Restricted           smallint NOT NULL DEFAULT 0,
       Currency             varchar(5) NULL,
       Comments             varchar(255) NULL,
       SortOrder            smallint NOT NULL DEFAULT 100,
       ZipStatus            smallint NULL
)
go

CREATE INDEX IX_Countries ON dbo.Countries
(
       Country
)
go


ALTER TABLE dbo.Countries
       ADD PRIMARY KEY (CountryID)
go


CREATE TABLE dbo.CreditCards (
       CustomerID           int NOT NULL,
       CardHolder           varchar(64) NULL,
       CardNumber           varchar(64) NULL,
       CardTypeID           int NULL,
       CardLength           int NULL,
       ExpirationDate       datetime NOT NULL,
       BillToAddress1       varchar(64) NULL,
       BillToAddress2       varchar(64) NULL,
       BillToCity           varchar(64) NULL,
       BillToZip            varchar(15) NULL,
       BillToCountryID      int NULL,
       BillToStateID        int NULL,
       SecurityCode         varchar(32) NULL,
       Bank                 varchar(64) NULL,
       BankPhone            varchar(16) NULL,
       Misc1                varchar(64) NULL,
       Misc2                varchar(64) NULL,
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate()
)
go


ALTER TABLE dbo.CreditCards
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.Currencies (
       CurrencyID           int NOT NULL,
       CountryID            int NULL,
       Currency             varchar(64) NULL,
       Symbol               varchar(50) NULL,
       Code                 varchar(5) NULL,
       Active               smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_Currencies_CountryID ON dbo.Currencies
(
       CountryID
)
go

CREATE INDEX i_Currencies_Code ON dbo.Currencies
(
       Code
)
go


ALTER TABLE dbo.Currencies
       ADD PRIMARY KEY (CurrencyID)
go


CREATE TABLE dbo.CustomerSettings (
       CustomerID           int NOT NULL,
       NotifyAcctLimit      smallint NOT NULL DEFAULT 1,
       NotifyIncidents      smallint NOT NULL DEFAULT 1,
       NotifyAnnounce       smallint NOT NULL DEFAULT 1,
       NotifyAcctStatus     smallint NOT NULL DEFAULT 1,
       NotifyShipStatus     smallint NOT NULL DEFAULT 1,
       NotifyOffers         smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.CustomerSettings
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.DataTypes (
       DataTypeID           smallint NOT NULL,
       DataType             varchar(64) NOT NULL,
       ConfigsOnly          smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.DataTypes
       ADD PRIMARY KEY (DataTypeID)
go


CREATE TABLE dbo.Discounts (
       DiscountID           int IDENTITY,
       Discount             varchar(32) NOT NULL,
       StringID             int NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT 0,
       AmountType           smallint NOT NULL DEFAULT 1,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX i_Discounts_GroupID ON dbo.Discounts
(
       GroupID
)
go


ALTER TABLE dbo.Discounts
       ADD PRIMARY KEY (DiscountID)
go


CREATE TABLE dbo.DNISGroups (
       DNISGroupID          int IDENTITY,
       DNISGroup            varchar(25) NOT NULL,
       Description          varchar(45) NOT NULL
)
go

CREATE INDEX i_DNISGroups_DNISGroup ON dbo.DNISGroups
(
       DNISGroup
)
go


ALTER TABLE dbo.DNISGroups
       ADD PRIMARY KEY (DNISGroupID)
go


CREATE TABLE dbo.DNISNumbers (
       DNISGroupID          int NOT NULL,
       DNISNumber           varchar(20) NOT NULL
)
go


ALTER TABLE dbo.DNISNumbers
       ADD PRIMARY KEY (DNISGroupID, DNISNumber)
go


CREATE TABLE dbo.Documents (
       DocumentID           int IDENTITY,
       CustomerID           int NULL,
       AccountID            int NULL,
       Description          varchar(128) NULL,
       StorageType          int NOT NULL DEFAULT 0,
       DocumentSize         int NOT NULL,
       CreateDate           datetime NULL DEFAULT getdate(),
       Operator             varchar(64) NULL,
       ContentType          varchar(64) NULL,
       Filename             varchar(64) NULL,
       DocumentData         text NULL
)
go

CREATE INDEX i_Documents_CustomerID ON dbo.Documents
(
       CustomerID,
       AccountID
)
go

CREATE INDEX i_Documents_Filename ON dbo.Documents
(
       Filename
)
go


ALTER TABLE dbo.Documents
       ADD PRIMARY KEY (DocumentID)
go


CREATE TABLE dbo.Domains (
       DomainID             int IDENTITY,
       Domain               varchar(40) NOT NULL,
       ServiceGroupID       INT NULL,
       MailDomain           varchar(40) NOT NULL,
       GroupID              int NULL,
       Description          varchar(45) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       ExternalRef          varchar(64) NULL,
       CustomerID           int NULL,
       CustomerAccess       smallint NULL,
       ExpireDate           datetime NULL,
       ExternalDNSRef       varchar(64) NULL,
       ErrorCount           int NULL,
       ErrorMessage         varchar(128) NULL
)
go

CREATE INDEX i_Domains_Domain ON dbo.Domains
(
       Domain
)
go

CREATE INDEX i_Domains_MailDomain ON dbo.Domains
(
       MailDomain
)
go

CREATE INDEX i_Domains_CustomerID ON dbo.Domains
(
       CustomerID
)
go


ALTER TABLE dbo.Domains
       ADD PRIMARY KEY (DomainID)
go


CREATE TABLE dbo.DUAL (
       A                    char(1) NOT NULL
)
go


CREATE TABLE dbo.EmailTypes (
       EmailTypeID          smallint NOT NULL,
       EmailType            varchar(64) NOT NULL
)
go


ALTER TABLE dbo.EmailTypes
       ADD PRIMARY KEY (EmailTypeID)
go


CREATE TABLE dbo.ExportColumns (
       ExportColumnID       int IDENTITY,
       ExportID             int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       FieldName            varchar(32) NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL,
       MinSize              smallint NOT NULL,
       MaxSize              smallint NOT NULL,
       Align                smallint NOT NULL,
       Format               smallint NOT NULL,
       Padding              char(1) NULL,
       ExportValue          varchar(100) NULL,
       Include              smallint NOT NULL,
       TransType            int NOT NULL DEFAULT 511,
       IEAID                int NULL
)
go

CREATE INDEX i_ExportColumns_ExportID ON dbo.ExportColumns
(
       ExportID
)
go


ALTER TABLE dbo.ExportColumns
       ADD PRIMARY KEY (ExportColumnID)
go


CREATE TABLE dbo.Exports (
       ExportID             int NOT NULL,
       Description          varchar(64) NOT NULL,
       Separator            varchar(6) NULL,
       ImportKeySeparator   varchar(6) NULL,
       ImportKeyValueSeparator varchar(6) NULL,
       QuoteString          varchar(6) NULL,
       SQLString            varchar(255) NOT NULL,
       HeaderRow            smallint NOT NULL,
       ApproveString        varchar(100) NULL,
       AuthString           varchar(100) NULL,
       VoidString           varchar(100) NULL,
       CreditString         varchar(100) NULL,
       DeclineString        varchar(100) NULL,
       ApproveMatch         smallint NULL,
       AuthMatch            smallint NULL,
       VoidMatch            smallint NULL,
       CreditMatch          smallint NULL,
       DeclineMatch         smallint NULL,
       ExportType           smallint NOT NULL,
       Filter               varchar(16) NULL,
       Lines                smallint NOT NULL,
       FormatDefault        int NULL DEFAULT 1,
       DefaultProcessorURL  varchar(128) NULL,
       Features             int NULL,
       Template             text NULL,
       StageCount           int NULL
)
go

CREATE INDEX i_Exports_ExportType ON dbo.Exports
(
       ExportType
)
go


ALTER TABLE dbo.Exports
       ADD PRIMARY KEY (ExportID)
go


CREATE TABLE dbo.ExportTypes (
       ExportTypeID         int NOT NULL,
       ExportType           varchar(64) NOT NULL,
       IsBatch              smallint NOT NULL DEFAULT 0,
       IsRealtime           smallint NOT NULL DEFAULT 0,
       IsCC                 smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ExportTypes
       ADD PRIMARY KEY (ExportTypeID)
go


CREATE TABLE dbo.ExternalConfigs (
       ExternalConfigID     int IDENTITY,
       Application          varchar(64) NOT NULL,
       Service              varchar(64) NOT NULL,
       Attribute            varchar(64) NOT NULL,
       Description          varchar(255) NULL,
       Type                 int NULL,
       Value                int NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.ExternalConfigs
       ADD PRIMARY KEY (ExternalConfigID)
go


CREATE TABLE dbo.ExternalSyncs (
       ExternalSyncID       int IDENTITY,
       ExternalSystemID     int NOT NULL,
       AccountID            int NULL,
       ProcTransID          varchar(64) NULL,
       Login                varchar(128) NULL,
       Password             varchar(128) NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL,
       Active               smallint NOT NULL DEFAULT 0,
       Created              smallint NOT NULL DEFAULT 0,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastUpdate           datetime NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       ErrorCount           int NOT NULL DEFAULT 0,
       Message              varchar(128) NULL,
       Aux4                 varchar(128) NULL,
       Aux5                 varchar(128) NULL,
       Aux6                 varchar(128) NULL,
       Aux7                 varchar(128) NULL,
       Aux8                 varchar(768) NULL
)
go

CREATE INDEX I2_ES_AID_ESID ON dbo.ExternalSyncs
(
       AccountID,
       ExternalSystemID
)
go


ALTER TABLE dbo.ExternalSyncs
       ADD PRIMARY KEY (ExternalSyncID)
go


CREATE TABLE dbo.ExternalSystemAccountTypes (
       ExternalSystemID     int NOT NULL,
       AccountTypeID        int NOT NULL,
       Description          varchar(255) NULL,
       ExternalRef          varchar(64) NULL
)
go


ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD PRIMARY KEY (ExternalSystemID, AccountTypeID)
go


CREATE TABLE dbo.ExternalSystemDataTypes (
       ExternalSystemTypeID int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL
)
go


ALTER TABLE dbo.ExternalSystemDataTypes
       ADD PRIMARY KEY (ExternalSystemTypeID, AccountDataTypeID)
go


CREATE TABLE dbo.ExternalSystems (
       ExternalSystemID     int IDENTITY,
       Name                 varchar(32) NOT NULL,
       ExternalSystemTypeID int NOT NULL,
       ExportID             int NULL,
       Description          varchar(50) NULL,
       MailHost             varchar(40) NULL,
       Login                varchar(40) NULL,
       Password             varchar(128) NULL,
       LogFile              varchar(100) NULL,
       LastSyncDate         datetime NULL,
       FileMode             smallint NOT NULL,
       Aux1                 varchar(128) NULL,
       Aux2                 varchar(128) NULL,
       Aux3                 varchar(128) NULL
)
go

CREATE INDEX i_ExternalSystems_Name ON dbo.ExternalSystems
(
       Name
)
go


ALTER TABLE dbo.ExternalSystems
       ADD PRIMARY KEY (ExternalSystemID)
go


CREATE TABLE dbo.ExternalSystemTypes (
       ExternalSystemTypeID int NOT NULL,
       ExternalSystemType   varchar(128) NOT NULL,
       ShowExportID         smallint NOT NULL DEFAULT 1,
       ShowMailHost         smallint NOT NULL DEFAULT 1,
       ShowLogin            smallint NOT NULL DEFAULT 1,
       ShowPassword         smallint NOT NULL DEFAULT 1,
       ShowURL              smallint NOT NULL DEFAULT 1,
       ExportID             INT NULL,
       DescAux1             varchar(64) NULL,
       DescAux2             varchar(64) NULL,
       DescAux3             varchar(128) NULL
)
go


ALTER TABLE dbo.ExternalSystemTypes
       ADD PRIMARY KEY (ExternalSystemTypeID)
go


CREATE TABLE dbo.ExternalTrans (
       ExternalTransID      int IDENTITY(2000,1),
       BatchID              int NULL,
       BatchOutID           int NULL,
       BatchInID            int NULL,
       CustomerID           int NOT NULL,
       InvoiceID            int NULL,
       BatchProcessorID     int NOT NULL,
       TransStateID         int NOT NULL DEFAULT 0,
       TransTypeID          int NOT NULL,
       ReqDate              datetime NOT NULL DEFAULT getdate(),
       ExportDate           datetime NULL,
       ProcDate             datetime NULL,
       Amount               numeric(18,4) NOT NULL,
       PaymentID            int NULL,
       ApproveCode          varchar(12) NULL,
       Response             varchar(50) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       AccountNumber        varchar(128) NULL,
       AccountExpire        datetime NULL,
       AuthName             varchar(64) NULL,
       AuthAddress          varchar(64) NULL,
       AuthStateID          int NULL,
       AuthZip              varchar(15) NULL,
       AuthSecurityCode     varchar(64) NULL,
       ProcTransID          varchar(64) NULL,
       BankName             varchar(64) NULL,
       BankNumber           varchar(128) NULL,
       BankPhone            varchar(20) NULL,
       BankTransType        varchar(16) NULL,
       RebatchTries         smallint NULL,
       LastRebatchTry       datetime NOT NULL,
       SSN                  varchar(128) NULL,
       DLNumber             varchar(128) NULL,
       DLState              varchar(40) NULL,
       BirthDate            datetime NULL,
       StatementID          int NULL,
       AutoBill             smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_ET_CustomerID ON dbo.ExternalTrans
(
       CustomerID
)
go

CREATE INDEX i_ET_TransStateID ON dbo.ExternalTrans
(
       TransStateID
)
go

CREATE INDEX i_ET_PaymentID ON dbo.ExternalTrans
(
       PaymentID
)
go

CREATE INDEX i_ET_BatchProcessorID ON dbo.ExternalTrans
(
       BatchProcessorID
)
go


ALTER TABLE dbo.ExternalTrans
       ADD PRIMARY KEY (ExternalTransID)
go


CREATE TABLE dbo.FileTransfers (
       TransferDate         datetime NOT NULL,
       AccountID            int NOT NULL,
       FileName             varchar(100) NOT NULL,
       NumBytes             int NOT NULL,
       Direction            smallint NOT NULL DEFAULT 0,
       Processed            smallint NULL
)
go

CREATE INDEX XIE1FileTransfers ON dbo.FileTransfers
(
       TransferDate,
       AccountID,
       FileName
)
go


ALTER TABLE dbo.FileTransfers
       ADD PRIMARY KEY (TransferDate, AccountID, FileName, NumBytes, 
              Direction)
go


CREATE TABLE dbo.FilterTypes (
       FilterTypeID         int IDENTITY,
       FilterType           varchar(30) NOT NULL,
       Description          varchar(64) NOT NULL,
       Checked              int NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.FilterTypes
       ADD PRIMARY KEY (FilterTypeID)
go


CREATE TABLE dbo.FlowFilterGroups (
       FlowFilterGroupID    int IDENTITY,
       FlowFilterGroup      varchar(32) NULL,
       Description          varchar(64) NULL,
       SortOrder            int NOT NULL DEFAULT 1,
       AccountID            int NULL,
       SummaryMode          int NULL,
       CacheExpire          int NULL
)
go


ALTER TABLE dbo.FlowFilterGroups
       ADD PRIMARY KEY (FlowFilterGroupID)
go


CREATE TABLE dbo.FlowFilters (
       FlowFilterID         int IDENTITY,
       FlowFilterGroupID    int NOT NULL,
       FilterType           int NOT NULL DEFAULT 1,
       SortOrder            int NOT NULL,
       SrcIP                varchar(16) NULL,
       SrcMask              varchar(16) NULL,
       SrcPort              int NULL,
       DestIP               varchar(16) NULL,
       DestMask             varchar(16) NULL,
       DestPort             int NULL,
       Prot                 int NULL,
       CacheExpire          int NULL,
       SummaryMode          int NULL
)
go


ALTER TABLE dbo.FlowFilters
       ADD PRIMARY KEY (FlowFilterID)
go


CREATE TABLE dbo.Flows (
       FlowDate             datetime NOT NULL,
       SrcIP                int NOT NULL,
       DestIP               int NOT NULL,
       SrcPort              int NOT NULL,
       DestPort             int NOT NULL,
       Prot                 int NOT NULL,
       Packets              int NOT NULL,
       Octets               int NOT NULL,
       AccountID            int NULL,
       FlowFilterID         int NULL,
       ROWGUID              uniqueidentifier NOT NULL DEFAULT newid()
)
go

CREATE INDEX iFlowDate ON dbo.Flows
(
       FlowDate
)
go


ALTER TABLE dbo.Flows
       ADD PRIMARY KEY (ROWGUID)
go


CREATE TABLE dbo.Forwards (
       ForwardID            int IDENTITY,
       Forward              varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Forwards_AccountID ON dbo.Forwards
(
       AccountID
)
go


ALTER TABLE dbo.Forwards
       ADD PRIMARY KEY (ForwardID)
go


CREATE TABLE dbo.GLCodes (
       GLCodeID             int IDENTITY,
       GLCode               varchar(32) NOT NULL,
       Description          varchar(128) NOT NULL,
       DetailFlag           smallint NULL
)
go


ALTER TABLE dbo.GLCodes
       ADD PRIMARY KEY (GLCodeID)
go


CREATE TABLE dbo.Groups (
       GroupID              int IDENTITY,
       OrganizationID       int NOT NULL,
       DomainID             int NOT NULL,
       GroupName            varchar(32) NOT NULL,
       Description          varchar(45) NOT NULL,
       ReportLogoURL        varchar(128) NULL,
       InvoiceReport        varchar(45) NULL,
       InvoiceTextReport    varchar(45) NULL,
       InvoiceHTMLReport    varchar(45) NULL,
       StatementReport      varchar(45) NULL,
       StatementTextReport  varchar(45) NULL,
       StatementHTMLReport  varchar(45) NULL,
       GlobalAccountTypes   smallint NOT NULL DEFAULT 1,
       GlobalBillingCycles  smallint NOT NULL DEFAULT 1,
       GlobalRegions        smallint NOT NULL DEFAULT 1,
       GlobalPayPeriods     smallint NOT NULL DEFAULT 1,
       GlobalDiscounts      smallint NOT NULL DEFAULT 1,
       GlobalChargeTypes    smallint NOT NULL DEFAULT 1,
       GlobalPackageTypes   smallint NOT NULL DEFAULT 1,
       GlobalDomains        smallint NOT NULL DEFAULT 1,
       GlobalSalesPersons   smallint NOT NULL DEFAULT 1,
       GlobalSendMethods    smallint NOT NULL DEFAULT 1,
       GlobalIncidentTypes  smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1,
       FTPDir               varchar(64) NULL,
       BillingOption        smallint NULL,
       SendCredits          smallint NULL DEFAULT 0,
       BillName             varchar(50) NOT NULL,
       BillAddress1         varchar(50) NOT NULL,
       BillAddress2         varchar(50) NULL,
       BillCity             varchar(50) NOT NULL,
       BillState            varchar(50) NOT NULL,
       BillZip              varchar(32) NULL,
       BillCountryID        int NULL,
       BillPhone            varchar(32) NULL,
       BillFax              varchar(32) NULL,
       EmailAccounts        varchar(64) NOT NULL,
       EmailSubject         varchar(64) NOT NULL,
       AutoEmailInvoices    smallint NOT NULL DEFAULT 0,
       AutoEmailStatements  smallint NOT NULL DEFAULT 1,
       ThemeID              int NULL,
       ThemeScore           int NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       Active               smallint NOT NULL DEFAULT 1,
       MBRFields            int NOT NULL DEFAULT 65535,
       PaymentTypes         int NOT NULL DEFAULT 65535,
       PrintInvoices        smallint NULL,
       PrintStatements      smallint NULL
)
go

CREATE INDEX i_Groups_DomainID ON dbo.Groups
(
       DomainID
)
go

CREATE INDEX I_Groups_OrganizationID ON dbo.Groups
(
       OrganizationID
)
go

CREATE INDEX i_Groups_GroupName ON dbo.Groups
(
       GroupName
)
go


ALTER TABLE dbo.Groups
       ADD PRIMARY KEY (GroupID)
go


CREATE TABLE dbo.IEALocks (
       IEALockID            int NOT NULL,
       IEALock              varchar(128) NOT NULL,
       RefCount             int NOT NULL DEFAULT 0,
       LastModifyDate       DATETIME NOT NULL DEFAULT getdate(),
       IPAddress            VARCHAR(64) NULL
)
go


ALTER TABLE dbo.IEALocks
       ADD PRIMARY KEY (IEALockID)
go


CREATE TABLE dbo.IncidentData (
       IncidentID           int NOT NULL,
       IncidentDataTypeID   int NOT NULL,
       Data                 varchar(255) NULL
)
go

CREATE INDEX IX_IncidentData ON dbo.IncidentData
(
       Data
)
go

CREATE INDEX x_IncidentData_IDTID ON dbo.IncidentData
(
       IncidentDataTypeID
)
go


ALTER TABLE dbo.IncidentData
       ADD PRIMARY KEY (IncidentID, IncidentDataTypeID)
go


CREATE TABLE dbo.IncidentDataTypes (
       IncidentDataTypeID   int IDENTITY,
       IncidentTypeID       int NOT NULL,
       IncidentDataType     varchar(128) NOT NULL,
       DataTypeID           smallint NOT NULL DEFAULT 0,
       Searchable           smallint NOT NULL DEFAULT 1,
       CustomerAccess       smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Required             smallint NULL,
       RegExp               varchar(255) NULL,
       SQLQuery             text NULL,
       IncidentTemplateID   int NULL
)
go


ALTER TABLE dbo.IncidentDataTypes
       ADD PRIMARY KEY (IncidentDataTypeID)
go


CREATE TABLE dbo.Incidents (
       IncidentID           int IDENTITY,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       IncidentTypeID       int NOT NULL,
       IncidentStateID      int NOT NULL,
       CreateOperatorID     int NULL,
       CreateAccountID      int NULL,
       Summary              text NULL,
       Description          text NULL,
       CustomerAccess       smallint NOT NULL DEFAULT 0,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Duration             int NOT NULL DEFAULT 0,
       Email                varchar(80) NULL,
       AssignRoleID         int NULL,
       AssignOperatorID     int NULL,
       DueDate              datetime NULL,
       PriorityID           smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_Incidents_AccountID ON dbo.Incidents
(
       AccountID
)
go

CREATE INDEX i_Incidents_Date ON dbo.Incidents
(
       CreateDate
)
go

CREATE INDEX i_Incidents_IncidentTypeID ON dbo.Incidents
(
       IncidentTypeID
)
go

CREATE INDEX i_Incidents_IncidentStateID ON dbo.Incidents
(
       IncidentStateID
)
go

CREATE INDEX i_Incidents_CreateOperatorID ON dbo.Incidents
(
       CreateOperatorID
)
go

CREATE INDEX i_Incidents_AssignRoleID ON dbo.Incidents
(
       AssignRoleID
)
go

CREATE INDEX i_Incidents_AssignOperatorID ON dbo.Incidents
(
       AssignOperatorID
)
go

CREATE INDEX i_Incidents_DueDate ON dbo.Incidents
(
       DueDate
)
go


ALTER TABLE dbo.Incidents
       ADD PRIMARY KEY (IncidentID)
go


CREATE TABLE dbo.IncidentStateGroups (
       IncidentStateGroupID int IDENTITY,
       IncidentStateGroup   varchar(128) NOT NULL
)
go


ALTER TABLE dbo.IncidentStateGroups
       ADD PRIMARY KEY (IncidentStateGroupID)
go


CREATE TABLE dbo.IncidentStates (
       IncidentStateID      int IDENTITY,
       IncidentStateGroupID int NULL,
       StatOpen             smallint NOT NULL DEFAULT 0,
       StatWait             smallint NOT NULL DEFAULT 0,
       StatEscalate         smallint NOT NULL DEFAULT 0,
       StatBlock            smallint NOT NULL DEFAULT 0,
       StatArchive          smallint NOT NULL DEFAULT 0,
       IncidentState        varchar(64) NOT NULL,
       CustomerAccess       smallint NOT NULL DEFAULT 1,
       Description          varchar(255) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Style                varchar(255) NULL,
       Priority             smallint NOT NULL DEFAULT 0,
       ActionOnly           smallint NULL
)
go

CREATE INDEX i_IncidentStates_ISG ON dbo.IncidentStates
(
       IncidentStateGroupID
)
go


ALTER TABLE dbo.IncidentStates
       ADD PRIMARY KEY (IncidentStateID)
go


CREATE TABLE dbo.IncidentTemplates (
       IncidentTemplateID   int NOT NULL,
       IncidentTemplate     varchar(128) NOT NULL,
       IncidentEdit         varchar(64) NULL,
       IncidentSave         varchar(64) NULL,
       CustIncidentEdit     varchar(64) NULL,
       CustIncidentSave     varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT (0)
)
go


ALTER TABLE dbo.IncidentTemplates
       ADD PRIMARY KEY (IncidentTemplateID)
go


CREATE TABLE dbo.IncidentTypes (
       IncidentTypeID       int IDENTITY,
       IncidentStateGroupID int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       IncidentType         varchar(32) NOT NULL,
       Description          varchar(64) NOT NULL DEFAULT null,
       Email                varchar(64) NULL DEFAULT null,
       SortOrder            smallint NOT NULL DEFAULT 1,
       OverDays             smallint NULL,
       EscalateDays         smallint NULL,
       WarnDays             smallint NULL,
       RoleID               int NULL,
       CustomerAccess       smallint NOT NULL DEFAULT 0,
       ShowPriority         smallint NOT NULL DEFAULT 0,
       ShowEmail            smallint NOT NULL DEFAULT 0,
       ShowDuration         smallint NOT NULL DEFAULT 0,
       ShowDueDate          smallint NOT NULL DEFAULT 0,
       ShowCustomerAccess   smallint NOT NULL DEFAULT 0,
       ShowSummary          smallint NOT NULL DEFAULT 0,
       ShowCustDueDate      smallint NOT NULL DEFAULT 0,
       EnableOperatorRole   smallint NULL
)
go

CREATE INDEX i_IncidentTypes_GroupID ON dbo.IncidentTypes
(
       GroupID
)
go


ALTER TABLE dbo.IncidentTypes
       ADD PRIMARY KEY (IncidentTypeID)
go


CREATE TABLE dbo.IncidentValues (
       IncidentDataTypeID   int NOT NULL,
       NumValue             int NOT NULL,
       ValueName            varchar(128) NOT NULL
)
go


ALTER TABLE dbo.IncidentValues
       ADD PRIMARY KEY (IncidentDataTypeID, NumValue)
go


CREATE TABLE dbo.InvoiceItems (
       ItemID               int IDENTITY,
       InvoiceID            int NOT NULL,
       ItemType             int NOT NULL DEFAULT 1,
       Login                varchar(64) NULL,
       Days                 smallint NOT NULL DEFAULT 0,
       Description          varchar(128) NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       AccountID            int NULL,
       PackageID            int NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       TaxID                int NULL,
       TaxGroupID           int NULL,
       PaidAmount           numeric(18,4) NOT NULL DEFAULT 0,
       AccountTypeID        int NULL,
       ChargeID             int NULL,
       ChargeTypeID         int NULL,
       PackageTypeID        int NULL,
       GLState              smallint NULL,
       Canceled             smallint NOT NULL DEFAULT 0,
       CycleMonths          smallint NULL,
       BillStatus           smallint NULL,
       PaidFlag             smallint NOT NULL DEFAULT 0,
       ParentItemID         int NULL
)
go

CREATE INDEX iInvoiceID ON dbo.InvoiceItems
(
       InvoiceID
)
go

CREATE INDEX i_InvoiceItems_AID ON dbo.InvoiceItems
(
       AccountID,
       InvoiceID
)
go


ALTER TABLE dbo.InvoiceItems
       ADD PRIMARY KEY (ItemID)
go


CREATE TABLE dbo.InvoiceItemTypes (
       InvoiceItemTypeID    int NOT NULL,
       InvoiceItemType      varchar(32) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.InvoiceItemTypes
       ADD PRIMARY KEY (InvoiceItemTypeID)
go


CREATE TABLE dbo.Invoices (
       InvoiceID            int IDENTITY,
       BatchID              int NULL,
       CustomerID           int NOT NULL,
       InvoiceTypeID        int NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       ChargeAmount         numeric(18,4) NOT NULL DEFAULT 0,
       PaidAmount           numeric(18,4) NOT NULL DEFAULT 0,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       SentDate             datetime NULL DEFAULT null,
       Tax                  numeric(18,4) NOT NULL DEFAULT 0,
       StatementID          int NULL,
       VoidDate             datetime NULL,
       VoidStatementID      int NULL,
       PO                   varchar(25) NULL,
       Comments             varchar(100) NULL,
       PrintDate            datetime NULL,
       EmailDate            datetime NULL,
       PrintBatchID         int NULL,
       Estimate             smallint NOT NULL DEFAULT 0,
       Processed            smallint NOT NULL DEFAULT 1,
       ExtInvoiceNum        varchar(20) NULL
)
go

CREATE INDEX iCustomerID ON dbo.Invoices
(
       CustomerID
)
go

CREATE INDEX i_Invoices_PrintBatchID ON dbo.Invoices
(
       PrintBatchID
)
go

CREATE INDEX i_Invoices_VoidStatementID ON dbo.Invoices
(
       VoidStatementID
)
go

CREATE INDEX i_Invoices_ExtInvoiceNum ON dbo.Invoices
(
       ExtInvoiceNum
)
go

CREATE INDEX i_Invoices_StatementID ON dbo.Invoices
(
       StatementID
)
go


ALTER TABLE dbo.Invoices
       ADD PRIMARY KEY (InvoiceID)
go


CREATE TABLE dbo.InvoiceTypes (
       InvoiceTypeID        int NOT NULL,
       InvoiceType          varchar(32) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.InvoiceTypes
       ADD PRIMARY KEY (InvoiceTypeID)
go


CREATE TABLE dbo.IPClasses (
       IPClassID            int NOT NULL,
       IPClass              varchar(32) NOT NULL,
       Description          varchar(64) NULL,
       LastModifyDate       datetime NOT NULL,
       LastModifyUser       varchar(64) NOT NULL
)
go


ALTER TABLE dbo.IPClasses
       ADD PRIMARY KEY (IPClassID)
go


CREATE TABLE dbo.IPs (
       IPID                 int NOT NULL,
       IP                   varchar(16) NOT NULL,
       IPClassID            int NOT NULL,
       LastModifyDate       datetime NOT NULL,
       LastModifyUser       varchar(64) NOT NULL
)
go


ALTER TABLE dbo.IPs
       ADD PRIMARY KEY (IPID)
go


CREATE TABLE dbo.Languages (
       LanguageID           int NOT NULL,
       Description          varchar(30) NULL,
       Active               smallint NOT NULL DEFAULT 1,
       BaseURL              varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       HttpAcceptLanguage   varchar(64) NULL,
       AllowIEAUpdate       smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.Languages
       ADD PRIMARY KEY (LanguageID)
go


CREATE TABLE dbo.LateFees (
       LateFeeID            int IDENTITY,
       LateFee              varchar(64) NOT NULL,
       ChargeTypeID         int NOT NULL,
       MinAmount            numeric(18,4) NULL,
       MaxAmount            numeric(18,4) NULL,
       MinDays              smallint NOT NULL DEFAULT 30,
       Percentage           numeric(18,4) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.LateFees
       ADD PRIMARY KEY (LateFeeID)
go


CREATE TABLE dbo.LDAPServers (
       LDAPServer           varchar(50) NOT NULL,
       LastModifyDate       datetime NOT NULL,
       LastSyncRead         datetime NOT NULL,
       LastSyncWrite        datetime NOT NULL,
       Calls                int NULL
)
go


ALTER TABLE dbo.LDAPServers
       ADD PRIMARY KEY (LDAPServer)
go


CREATE TABLE dbo.Licenses (
       LicenseID            varchar(50) NOT NULL,
       Company              varchar(80) NOT NULL
)
go


ALTER TABLE dbo.Licenses
       ADD PRIMARY KEY (LicenseID)
go


CREATE TABLE dbo.LocPhones (
       Prefix               varchar(12) NOT NULL,
       StateID              int NOT NULL,
       City                 varchar(64) NOT NULL,
       Lat                  float NULL,
       Long                 float NULL,
       Telco                varchar(64) NULL
)
go


ALTER TABLE dbo.LocPhones
       ADD PRIMARY KEY (Prefix, StateID)
go


CREATE TABLE dbo.LocZipCodes (
       ZipCode              varchar(15) NOT NULL,
       StateID              int NOT NULL,
       City                 varchar(64) NOT NULL,
       County               varchar(64) NULL,
       Lat                  float NULL,
       Long                 float NULL
)
go


ALTER TABLE dbo.LocZipCodes
       ADD PRIMARY KEY (ZipCode, StateID)
go


CREATE TABLE dbo.LogMsgs (
       LogMsgID             int NOT NULL,
       Description          varchar(50) NOT NULL DEFAULT 'Undefined',
       StringID             int NULL,
       Severity             int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.LogMsgs
       ADD PRIMARY KEY (LogMsgID)
go


CREATE TABLE dbo.Logs (
       LogID                int IDENTITY,
       LogMsgID             int NOT NULL,
       LogDate              smalldatetime NOT NULL DEFAULT getdate(),
       LogMsg               varchar(255) NOT NULL,
       Operator             varchar(64) NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       BatchID              int NULL
)
go

CREATE INDEX i_Logs_LogDate ON dbo.Logs
(
       LogDate,
       CustomerID,
       AccountID
)
go


ALTER TABLE dbo.Logs
       ADD PRIMARY KEY (LogID)
go


CREATE TABLE dbo.MailLogs (
       MailLogID            int IDENTITY,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       LogMsgID             int NOT NULL,
       CustomerID           int NOT NULL,
       TokenID              int NULL,
       Sent                 smallint NOT NULL DEFAULT 1,
       LogDescription       varchar(255) NULL
)
go

CREATE INDEX IX_MailLogs ON dbo.MailLogs
(
       LogDate,
       CustomerID
)
go


ALTER TABLE dbo.MailLogs
       ADD PRIMARY KEY (MailLogID)
go


CREATE TABLE dbo.MasterAccountData (
       CustomerID           int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.MasterAccountData
       ADD PRIMARY KEY (CustomerID, AccountDataTypeID)
go


CREATE TABLE dbo.MasterAccountDataTypes (
       MasterAccountDataTypeID int IDENTITY,
       GroupID              int NULL,
       AccountDataTypeID    int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL,
       ServiceGroupID       int NULL
)
go

CREATE UNIQUE INDEX IX_MasterAccountDataTypes ON dbo.MasterAccountDataTypes
(
       GroupID,
       AccountDataTypeID
)
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD PRIMARY KEY (MasterAccountDataTypeID)
go


CREATE TABLE dbo.MasterAccounts (
       CustomerID           int IDENTITY,
       LastStatementID      int NULL,
       FirstName            varchar(40) NOT NULL,
       MiddleName           varchar(25) NULL,
       LastName             varchar(40) NOT NULL,
       Company              varchar(60) NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Address1             varchar(64) NULL,
       Address2             varchar(64) NULL,
       City                 varchar(45) NULL,
       Zip                  varchar(15) NULL,
       PhoneHome            varchar(32) NULL,
       PhoneWork            varchar(32) NULL,
       Gender               varchar(1) NULL,
       BirthDate            datetime NULL,
       Salutation           varchar(4) NULL,
       PhoneFax             varchar(32) NULL,
       Email                varchar(64) NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       RegionID             int NULL,
       ReferredByID         int NULL,
       SalesPersonID        int NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       StartDate            datetime NOT NULL DEFAULT getdate(),
       Active               smallint NOT NULL DEFAULT 1,
       LanguageID           int NULL,
       PayPeriodID          int NOT NULL,
       PaymentTypeID        int NOT NULL DEFAULT 1,
       LastReceived         datetime NOT NULL DEFAULT getdate(),
       LastLateFee          datetime NULL,
       Comments             text NULL,
       Status               smallint NOT NULL DEFAULT 1,
       GroupID              int NOT NULL,
       OverDue              smallint NULL DEFAULT 0,
       SendMethodID         int NOT NULL,
       OverLimit            numeric(18,4) NOT NULL DEFAULT 0,
       BillingCycleID       int NOT NULL,
       BillDay              smallint NOT NULL DEFAULT 1,
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       Balance              numeric(18,4) NOT NULL DEFAULT 0,
       Over30Count          smallint NOT NULL DEFAULT 0,
       Over60Count          smallint NOT NULL DEFAULT 0,
       Over90Count          smallint NOT NULL DEFAULT 0,
       Over120Count         smallint NOT NULL DEFAULT 0,
       MaxAgedDays          int NULL DEFAULT 0,
       AgedDate             datetime NULL,
       PendingBalance       numeric(18,4) NOT NULL DEFAULT 0,
       NoticeDate           datetime NULL,
       PayInfo              varchar(50) NULL,
       Operator             varchar(64) NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       TransHoldDate        datetime NULL
)
go

CREATE INDEX iCompany ON dbo.MasterAccounts
(
       Company
)
go

CREATE INDEX IX_MasterAccounts_Country ON dbo.MasterAccounts
(
       CountryID,
       StateID
)
go

CREATE INDEX IX_MasterAccounts_Email ON dbo.MasterAccounts
(
       Email
)
go

CREATE INDEX i_MBR_PhoneHome ON dbo.MasterAccounts
(
       PhoneHome
)
go

CREATE INDEX i_MBR_PhoneWork ON dbo.MasterAccounts
(
       PhoneWork
)
go

CREATE INDEX i_MBR_PhoneFax ON dbo.MasterAccounts
(
       PhoneFax
)
go

CREATE INDEX iLastName ON dbo.MasterAccounts
(
       LastName
)
go

CREATE INDEX iBillingCycleID ON dbo.MasterAccounts
(
       BillingCycleID
)
go

CREATE INDEX i_MasterAccounts_GroupID ON dbo.MasterAccounts
(
       GroupID
)
go

CREATE INDEX i_MasterAccounts_LastMDate ON dbo.MasterAccounts
(
       LastModifyDate
)
go

CREATE INDEX i_MasterAccounts_Active ON dbo.MasterAccounts
(
       Active
)
go

CREATE INDEX i_MasterAccounts_CancelDate ON dbo.MasterAccounts
(
       CancelDate
)
go

CREATE INDEX IX_MasterAccounts_FirstName ON dbo.MasterAccounts
(
       FirstName
)
go

CREATE INDEX IX_MasterAccounts_Region ON dbo.MasterAccounts
(
       RegionID
)
go


ALTER TABLE dbo.MasterAccounts
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.MenuItems (
       MenuItemID           int NOT NULL,
       MenuItem             varchar(128) NOT NULL,
       Label                varchar(64) NOT NULL,
       TableName            varchar(64) NULL,
       ColumnName           varchar(64) NULL,
       FileName             varchar(64) NULL,
       Access               varchar(16) NULL,
       Condition            varchar(255) NULL,
       FeatureID            int NULL,
       Description          varchar(128) NOT NULL,
       DescStringID         int NULL,
       HelpStringID         int NULL,
       AccessKey            varchar(5) NULL,
       Link                 varchar(255) NOT NULL,
       Attribute            varchar(255) NULL
)
go


ALTER TABLE dbo.MenuItems
       ADD PRIMARY KEY (MenuItemID)
go


CREATE TABLE dbo.Menus (
       MenuID               int NOT NULL,
       Menu                 varchar(128) NOT NULL,
       Description          text NULL,
       Class                varchar(64) NULL
)
go


ALTER TABLE dbo.Menus
       ADD PRIMARY KEY (MenuID)
go


CREATE TABLE dbo.MenuSets (
       MenuID               int NOT NULL,
       MenuItemID           int NOT NULL,
       GroupID              int NULL,
       SortOrder            int NOT NULL
)
go


ALTER TABLE dbo.MenuSets
       ADD PRIMARY KEY (MenuID, MenuItemID)
go


CREATE TABLE dbo.MetaColumns (
       MetaColumnID         int IDENTITY,
       MetaTableID          int NULL,
       ColumnName           varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       StringID             int NULL,
       DepTable             varchar(32) NULL,
       DepColumn            varchar(32) NULL,
       DepGroup             int NULL,
       MetaRuleID           int NULL,
       Required             smallint NULL,
       Nullable             smallint NULL,
       Quoted               smallint NULL,
       MinSize              int NULL,
       MaxSize              int NULL,
       IsKey                smallint NULL,
       ColumnType           int NULL,
       HelpText             text NULL,
       RegExp               varchar(255) NULL,
       CheckQuery           varchar(255) NULL
)
go

CREATE INDEX i_MetaColumns_IsKey ON dbo.MetaColumns
(
       MetaTableID,
       IsKey
)
go

CREATE INDEX i_MetaColumns_MTID_MC ON dbo.MetaColumns
(
       MetaTableID,
       ColumnName
)
go


ALTER TABLE dbo.MetaColumns
       ADD PRIMARY KEY (MetaColumnID)
go


CREATE TABLE dbo.MetaRules (
       MetaRuleID           int NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.MetaRules
       ADD PRIMARY KEY (MetaRuleID)
go


CREATE TABLE dbo.MetaTableGroups (
       MetaTableGroupID     int NOT NULL,
       GroupName            varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL
)
go


ALTER TABLE dbo.MetaTableGroups
       ADD PRIMARY KEY (MetaTableGroupID)
go


CREATE TABLE dbo.MetaTables (
       MetaTableID          int IDENTITY,
       TableName            varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       GroupTable           varchar(32) NULL,
       SortOrder            int NULL,
       GroupName            varchar(15) NULL
)
go

CREATE UNIQUE INDEX XAK1MetaTables ON dbo.MetaTables
(
       TableName
)
go


ALTER TABLE dbo.MetaTables
       ADD PRIMARY KEY (MetaTableID)
go


CREATE TABLE dbo.NoticeActives (
       NoticeID             int NOT NULL,
       CustomerID           int NULL,
       AccountID            int NULL,
       TokenID              int NULL,
       SubTokenID           int NULL
)
go

CREATE UNIQUE INDEX IX_NoticeActives ON dbo.NoticeActives
(
       NoticeID,
       CustomerID,
       AccountID,
       TokenID,
       SubTokenID
)
go

CREATE INDEX i_NoticeActives_CustomerID ON dbo.NoticeActives
(
       CustomerID
)
go


CREATE TABLE dbo.NoticeLogs (
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       NoticeLogID          int IDENTITY,
       CustomerID           int NULL,
       AccountID            int NULL,
       NoticeID             int NOT NULL
)
go

CREATE INDEX iNoticeLogs_CustomerID ON dbo.NoticeLogs
(
       CustomerID
)
go

CREATE INDEX iNoticeLogs_AccountID ON dbo.NoticeLogs
(
       AccountID
)
go


ALTER TABLE dbo.NoticeLogs
       ADD PRIMARY KEY (CreateDate, NoticeLogID)
go


CREATE TABLE dbo.NoticeParmTypes (
       NoticeParmTypeID     smallint NOT NULL,
       SQLQuery             text NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.NoticeParmTypes
       ADD PRIMARY KEY (NoticeParmTypeID)
go


CREATE TABLE dbo.Notices (
       NoticeID             int IDENTITY,
       NoticeTypeID         int NOT NULL,
       Active               int NOT NULL DEFAULT 1,
       Notice               varchar(64) NOT NULL,
       MailFrom             varchar(128) NULL,
       MailSubject          varchar(128) NULL,
       MailCC               varchar(128) NULL,
       NoticeText           text NOT NULL,
       Parm1                varchar(64) NULL,
       Parm2                varchar(64) NULL,
       Parm3                varchar(64) NULL,
       LastRunDate          datetime NULL,
       InternalID           smallint NULL
)
go


ALTER TABLE dbo.Notices
       ADD PRIMARY KEY (NoticeID)
go


CREATE TABLE dbo.NoticeTypes (
       NoticeTypeID         int IDENTITY,
       IEATag               int NULL,
       NoticeType           varchar(64) NOT NULL,
       Description          text NULL,
       DefaultText          text NULL,
       SQLQuery             text NOT NULL,
       SentQuery            text NULL,
       ReportFile           varchar(45) NULL,
       Parm1Desc            varchar(64) NULL,
       Parm2Desc            varchar(64) NULL,
       Parm3Desc            varchar(64) NULL,
       Parm1TypeID          smallint NULL,
       Parm2TypeID          smallint NULL,
       Parm3TypeID          smallint NULL,
       InternalID           smallint NULL,
       Parm1Query           text NULL,
       Parm2Query           text NULL,
       Parm3Query           text NULL,
       IEAID                int NULL
)
go

CREATE INDEX IX_NoticeTypes ON dbo.NoticeTypes
(
       InternalID
)
go


ALTER TABLE dbo.NoticeTypes
       ADD PRIMARY KEY (NoticeTypeID)
go


CREATE TABLE dbo.ObjectGroups (
       ObjectGroupID        int NOT NULL,
       ReportID             int NULL,
       ObjectGroup          varchar(32) NOT NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.ObjectGroups
       ADD PRIMARY KEY (ObjectGroupID)
go


CREATE TABLE dbo.Objects (
       ObjectID             int IDENTITY,
       ObjectGroupID        int NOT NULL,
       ObjectTypeID         int NOT NULL,
       Value                int NULL,
       Data                 varchar(80) NULL,
       Description          varchar(16) NULL
)
go


ALTER TABLE dbo.Objects
       ADD PRIMARY KEY (ObjectID)
go


CREATE TABLE dbo.OnlineSignups (
       OnlineSignupID       int IDENTITY,
       FirstName            varchar(40) NULL,
       LastName             varchar(40) NULL,
       Address1             varchar(100) NULL,
       Address2             varchar(100) NULL,
       City                 varchar(50) NULL,
       State                varchar(50) NULL,
       Province             varchar(50) NULL,
       Zip                  varchar(16) NULL,
       Country              varchar(50) NULL,
       ReferredBy           varchar(25) NULL,
       Region               varchar(15) NULL,
       AccountTypeID        int NOT NULL,
       Login                varchar(64) NULL,
       Password             varchar(128) NULL,
       MaidenName           varchar(25) NULL,
       NetSoftware          varchar(15) NULL,
       SystemType           varchar(15) NULL,
       ModemSpeed           varchar(15) NULL,
       CallerID             varchar(64) NULL,
       FramedAddress        varchar(16) NULL,
       CallDate             datetime NOT NULL,
       SignUpDate           datetime NOT NULL,
       Status               varchar(16) NULL,
       PaymentOption        varchar(15) NULL,
       CardNumber           varchar(16) NULL,
       CardExpiration       varchar(20) NULL,
       SignUpComment        varchar(255) NULL
)
go

CREATE INDEX XIE1OnlineSignups ON dbo.OnlineSignups
(
       LastName,
       FirstName
)
go

CREATE INDEX XIE2OnlineSignups ON dbo.OnlineSignups
(
       Region,
       CallDate
)
go


ALTER TABLE dbo.OnlineSignups
       ADD PRIMARY KEY (OnlineSignupID)
go


CREATE TABLE dbo.OperatorCookies (
       Cookie               varchar(64) NOT NULL,
       Operator             varchar(64) NOT NULL,
       LastUsed             datetime NOT NULL DEFAULT getdate(),
       OperatorID           int NULL,
       AccountID            int NULL
)
go


ALTER TABLE dbo.OperatorCookies
       ADD PRIMARY KEY (Cookie)
go


CREATE TABLE dbo.OperatorGroupAccess (
       ObjectGroupID        int NOT NULL,
       OperatorGroupID      int NOT NULL,
       GroupID              int NOT NULL,
       AccessType           smallint NOT NULL DEFAULT 1
)
go

CREATE INDEX IX_OperatorGroupAccess ON dbo.OperatorGroupAccess
(
       OperatorGroupID,
       ObjectGroupID,
       GroupID
)
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD PRIMARY KEY (ObjectGroupID, OperatorGroupID, GroupID)
go


CREATE TABLE dbo.OperatorGroups (
       OperatorGroupID      int IDENTITY,
       OperatorGroup        varchar(32) NOT NULL,
       Description          varchar(64) NULL,
       InternalUse          smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.OperatorGroups
       ADD PRIMARY KEY (OperatorGroupID)
go


CREATE TABLE dbo.OperatorRoles (
       OperatorRoleID       int IDENTITY,
       OperatorID           int NOT NULL,
       RoleID               int NOT NULL,
       GroupID              int NULL,
       TargetActive         int NULL,
       MaxActive            int NULL,
       Tier                 smallint NOT NULL DEFAULT 1,
       ShowEscalate         smallint NOT NULL DEFAULT 0,
       ShowLate             smallint NOT NULL DEFAULT 0
)
go

CREATE UNIQUE INDEX i_OperatorRoles_unique ON dbo.OperatorRoles
(
       OperatorID,
       RoleID,
       GroupID
)
go

CREATE INDEX IX_OperatorRoles ON dbo.OperatorRoles
(
       RoleID,
       OperatorID
)
go


ALTER TABLE dbo.OperatorRoles
       ADD PRIMARY KEY (OperatorRoleID)
go


CREATE TABLE dbo.Operators (
       OperatorID           int IDENTITY,
       PrintTypeID          smallint NULL,
       OperatorGroupID      int NOT NULL,
       Operator             varchar(32) NOT NULL,
       Password             varchar(128) NULL,
       Email                varchar(64) NULL,
       WebObjectAccess      int NULL DEFAULT 1,
       LanguageID           int NULL,
       Active               smallint NOT NULL DEFAULT 1,
       DateFormatID         int NULL,
       DateSeperator        char(1) NULL,
       ThemeID              int NULL,
       CountryID            int NULL,
       DaySumIncident       smallint NULL,
       MeasureUnitID        smallint NULL
)
go

CREATE UNIQUE INDEX uc_Operator ON dbo.Operators
(
       Operator
)
go

CREATE INDEX i_Operators_OperatorGroupID ON dbo.Operators
(
       OperatorGroupID
)
go

CREATE INDEX i_Operators_Email ON dbo.Operators
(
       Email
)
go


ALTER TABLE dbo.Operators
       ADD PRIMARY KEY (OperatorID)
go


CREATE TABLE dbo.OrgAccountTypes (
       OrganizationID       int NOT NULL,
       AccountTypeID        int NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             varchar(128) NULL
)
go


ALTER TABLE dbo.OrgAccountTypes
       ADD PRIMARY KEY (OrganizationID, AccountTypeID)
go


CREATE TABLE dbo.Organizations (
       OrganizationID       int IDENTITY,
       ResellerCustomerID   int NULL,
       Organization         varchar(255) NOT NULL,
       InvoiceDetailed      smallint NOT NULL DEFAULT 0,
       InvoiceFractional    smallint NOT NULL DEFAULT 0,
       MaxAccounts          int NULL,
       CurrencyID           int NOT NULL DEFAULT 207
)
go


ALTER TABLE dbo.Organizations
       ADD PRIMARY KEY (OrganizationID)
go


CREATE TABLE dbo.OrgPackageTypes (
       OrganizationID       int NOT NULL,
       PackageTypeID        int NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             varchar(128) NULL
)
go


ALTER TABLE dbo.OrgPackageTypes
       ADD PRIMARY KEY (OrganizationID, PackageTypeID)
go


CREATE TABLE dbo.PackageAccountTypes (
       PackageTypeID        int NOT NULL,
       AccountTypeID        int NOT NULL,
       NonPkgCost           numeric(18,4) NULL,
       NonPkgDiscountID     int NOT NULL,
       MinQty               smallint NOT NULL DEFAULT 0,
       MaxQty               smallint NOT NULL DEFAULT 0,
       CustomerMax          smallint NULL,
       OperatorMax          smallint NULL DEFAULT 0,
       AllowCustCancel      smallint NOT NULL DEFAULT 1,
       AllowCustChangeLogin smallint NOT NULL DEFAULT 0,
       AllowCustChangePass  smallint NOT NULL DEFAULT 1,
       AllowCustAdd         smallint NOT NULL DEFAULT 1,
       PackageLoginLimit    int NULL,
       PackageTimeLeft      int NULL,
       AllowCustSetDomain   smallint NULL
)
go

CREATE INDEX i_PAT_PTID_ATID ON dbo.PackageAccountTypes
(
       PackageTypeID,
       AccountTypeID
)
go


ALTER TABLE dbo.PackageAccountTypes
       ADD PRIMARY KEY (AccountTypeID, PackageTypeID)
go


CREATE TABLE dbo.Packages (
       PackageID            int IDENTITY,
       CustomerID           int NOT NULL,
       PackageTypeID        int NOT NULL,
       BillStatus           smallint NULL,
       DiffCost             smallint NOT NULL DEFAULT 0,
       Cost                 numeric(18,4) NULL,
       CreateOperatorID     int NULL,
       CreateDate           datetime NULL,
       StartDate            datetime NULL,
       LastModifyUser       varchar(64) NULL,
       LastModifyDate       datetime NULL,
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       Active               smallint NOT NULL DEFAULT 1,
       ExpireDate           datetime NULL,
       Extension            int NULL DEFAULT 0,
       BilledThru           datetime NULL,
       PayPeriodID          int NULL,
       DiscountID           int NOT NULL,
       SalesPersonID        int NULL,
       Comments             text NULL,
       CycleMonths          smallint NOT NULL DEFAULT 0,
       LastInvoiceID        int NULL
)
go

CREATE INDEX IX_Packages ON dbo.Packages
(
       CustomerID
)
go

CREATE INDEX i_Packages_LMD ON dbo.Packages
(
       LastModifyDate
)
go


ALTER TABLE dbo.Packages
       ADD PRIMARY KEY (PackageID)
go


CREATE TABLE dbo.PackageTypes (
       PackageTypeID        int IDENTITY,
       PackageType          varchar(64) NOT NULL,
       StringID             int NULL,
       Cost                 numeric(18,4) NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       CustomerAccess       smallint NOT NULL DEFAULT 0,
       CustomerSignup       smallint NOT NULL DEFAULT 0,
       UniquePerMBR         smallint NOT NULL,
       MaxPerMBR            smallint NOT NULL,
       StartDate            datetime NULL,
       EndDate              datetime NULL,
       ApplyDiscount        smallint NOT NULL,
       TaxGroupID           int NULL,
       TaxExemptions        int NULL,
       ChargeTypeID         int NULL,
       GLCodeID             int NULL,
       PayPeriodID          int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       BillingCycleID       int NULL,
       PrimaryAccountTypeID int NULL,
       SendMethodID         int NULL,
       Description          text NULL,
       CustomerDescription  text NULL,
       SortOrder            smallint NOT NULL,
       PaymentTypes         int NOT NULL DEFAULT 65535,
       ChangeOpen           smallint NOT NULL DEFAULT 1,
       ChangeTo             smallint NOT NULL DEFAULT 1,
       ChangeClose          smallint NOT NULL DEFAULT 1,
       ChangeFrom           smallint NOT NULL DEFAULT 1,
       NextCount            smallint NULL,
       NextID               int NULL,
       InvoiceDescription   varchar(64) NULL,
       CustomerStringID     INT NULL,
       SecChargeTypeID      int NULL
)
go


ALTER TABLE dbo.PackageTypes
       ADD PRIMARY KEY (PackageTypeID)
go


CREATE TABLE dbo.PaymentItems (
       PaymentItemID        int IDENTITY,
       PaymentID            int NULL,
       ChargeID             int NULL,
       ItemID               int NOT NULL,
       ActiveDate           datetime NOT NULL,
       InactiveDate         datetime NULL,
       Amount               numeric(18,4) NULL
)
go

CREATE CLUSTERED INDEX IX_PaymentItems ON dbo.PaymentItems
(
       PaymentID,
       ChargeID,
       ItemID
)
go

CREATE INDEX IX_ActiveDate ON dbo.PaymentItems
(
       ActiveDate
)
go

CREATE INDEX IX_InactiveDate ON dbo.PaymentItems
(
       InactiveDate
)
go

CREATE INDEX iPaymentItems_ItemID ON dbo.PaymentItems
(
       ItemID
)
go


ALTER TABLE dbo.PaymentItems
       ADD PRIMARY KEY NONCLUSTERED (PaymentItemID)
go


CREATE TABLE dbo.Payments (
       PaymentID            int IDENTITY,
       CustomerID           int NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       BatchID              int NULL,
       PaymentTypeID        int NOT NULL,
       CheckNumber          varchar(16) NULL,
       PayInfo              varchar(45) NULL,
       ProcTransID          varchar(64) NULL,
       DistFlag             smallint NOT NULL DEFAULT 1,
       Confirmed            smallint NULL,
       StatementID          int NULL,
       FinalAmount          numeric(18,4) NULL,
       FinalStatementID     int NULL,
       FinalCreateDate      datetime NULL,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       GLState              smallint NULL
)
go

CREATE INDEX iCustomerID ON dbo.Payments
(
       CustomerID
)
go

CREATE INDEX iDate ON dbo.Payments
(
       CreateDate
)
go

CREATE INDEX i_PMT_StatementID ON dbo.Payments
(
       StatementID
)
go

CREATE INDEX i_PMT_FinalStatementID ON dbo.Payments
(
       FinalStatementID
)
go


ALTER TABLE dbo.Payments
       ADD PRIMARY KEY (PaymentID)
go


CREATE TABLE dbo.PaymentTypes (
       PaymentTypeID        int NOT NULL,
       PaymentType          varchar(32) NOT NULL,
       StringID             int NULL,
       CustomerDescription  varchar(128) NULL,
       CustomerStringID     int NULL,
       GLCodeID             int NULL,
       CustomerAccess       smallint NOT NULL DEFAULT 1,
       CustomerPayment      smallint NOT NULL DEFAULT 1,
       IsPayMethod          smallint NOT NULL DEFAULT 1,
       IsPayType            smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.PaymentTypes
       ADD PRIMARY KEY (PaymentTypeID)
go


CREATE TABLE dbo.PayPeriods (
       PayPeriodID          int IDENTITY,
       AccountTypeID        int NULL,
       PayPeriod            varchar(64) NOT NULL,
       StringID             int NULL,
       PeriodTypeID         int NOT NULL,
       Period               smallint NOT NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT 0,
       AmountType           smallint NOT NULL DEFAULT 1,
       SetupCharge          smallint NOT NULL DEFAULT 0,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       ConfirmTrans         smallint NULL DEFAULT 0
)
go

CREATE INDEX i_PayPeriods_GroupID ON dbo.PayPeriods
(
       GroupID
)
go


ALTER TABLE dbo.PayPeriods
       ADD PRIMARY KEY (PayPeriodID)
go


CREATE TABLE dbo.PeriodTypes (
       PeriodTypeID         int NOT NULL,
       PeriodType           varchar(32) NOT NULL,
       StringID             int NULL,
       AllowPayPeriod       smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.PeriodTypes
       ADD PRIMARY KEY (PeriodTypeID)
go


CREATE TABLE dbo.PosixAccountServers (
       PosixAccountServerID int IDENTITY,
       LDAPServer           varchar(50) NOT NULL,
       AccountTypeID        varchar(20) NOT NULL,
       gidNumber            int NOT NULL,
       loginShell           varchar(100) NOT NULL,
       homeDirectory        varchar(100) NOT NULL
)
go

CREATE INDEX i_PosixAccountServers_ID ON dbo.PosixAccountServers
(
       PosixAccountServerID
)
go


ALTER TABLE dbo.PosixAccountServers
       ADD PRIMARY KEY (LDAPServer, AccountTypeID)
go


CREATE TABLE dbo.PosixAccountUIDs (
       uidNumber            int NOT NULL,
       PosixAccountUserID   int NULL,
       LDAPServer           varchar(50) NOT NULL
)
go

CREATE INDEX i_PosixAccountUIDs_PAUID ON dbo.PosixAccountUIDs
(
       PosixAccountUserID
)
go

CREATE INDEX i_PAU_uidNumber ON dbo.PosixAccountUIDs
(
       uidNumber
)
go


ALTER TABLE dbo.PosixAccountUIDs
       ADD PRIMARY KEY (uidNumber, LDAPServer)
go


CREATE TABLE dbo.PosixAccountUsers (
       PosixAccountUserID   int IDENTITY,
       PosixAccountServerID int NOT NULL,
       AccountID            int NOT NULL,
       gidNumber            int NULL,
       loginShell           varchar(100) NULL,
       homeDirectory        varchar(100) NULL,
       userPassword         varchar(50) NULL
)
go

CREATE INDEX i_PosixAccountUsers_ID ON dbo.PosixAccountUsers
(
       PosixAccountUserID
)
go

CREATE INDEX i_PosixAccountUsers_SrvrID ON dbo.PosixAccountUsers
(
       PosixAccountServerID
)
go


ALTER TABLE dbo.PosixAccountUsers
       ADD PRIMARY KEY (AccountID)
go


CREATE TABLE dbo.PrintTypes (
       PrintTypeID          smallint NOT NULL,
       PrintType            varchar(64) NOT NULL,
       Data                 varchar(128) NULL,
       CRData               varchar(128) NULL
)
go

CREATE UNIQUE INDEX pk_PrintTypes ON dbo.PrintTypes
(
       PrintType
)
go


ALTER TABLE dbo.PrintTypes
       ADD PRIMARY KEY (PrintTypeID)
go


CREATE TABLE dbo.Priorities (
       PriorityID           smallint NOT NULL,
       Priority             varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.Priorities
       ADD PRIMARY KEY (PriorityID)
go


CREATE TABLE dbo.RadATConfigs (
       RadATConfigID        int IDENTITY,
       AccountTypeID        int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Value                int NULL,
       RadCheck             smallint NOT NULL DEFAULT 0,
       Tag                  smallint NULL,
       SortOrder            smallint NULL
)
go


ALTER TABLE dbo.RadATConfigs
       ADD PRIMARY KEY (RadATConfigID)
go


CREATE TABLE dbo.RadAttributes (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Name                 varchar(40) NOT NULL,
       RadAttributeType     smallint NOT NULL,
       ReplyType            smallint NOT NULL,
       AliasAttributeID     int NULL,
       AliasVendorID        int NULL
)
go


ALTER TABLE dbo.RadAttributes
       ADD PRIMARY KEY (RadAttributeID, RadVendorID)
go


CREATE TABLE dbo.RadConcurrency (
       RadConcurrencyID     int IDENTITY,
       GroupID              int NOT NULL,
       AccountTypeID        int NULL,
       LastSyncDate         datetime NOT NULL DEFAULT getdate(),
       ConnectionsMax       int NOT NULL DEFAULT 0,
       Connections          int NOT NULL DEFAULT 0,
       Description          varchar(100) NULL
)
go

CREATE UNIQUE CLUSTERED INDEX i_RC_GroupAccountID ON RadConcurrency
(
       GroupID,
       AccountTypeID
)
go


ALTER TABLE dbo.RadConcurrency
       ADD PRIMARY KEY NONCLUSTERED (RadConcurrencyID)
go


CREATE TABLE dbo.RadConfigs (
       RadConfigID          int IDENTITY,
       AccountID            int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Value                int NULL,
       RadCheck             smallint NOT NULL DEFAULT 0,
       Tag                  smallint NULL
)
go

CREATE INDEX i_RadConfigs_AccountID ON dbo.RadConfigs
(
       AccountID
)
go


ALTER TABLE dbo.RadConfigs
       ADD PRIMARY KEY (RadConfigID)
go


CREATE TABLE dbo.RadDestTypes (
       RadDestTypeID        int NOT NULL,
       RadDestType          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RadDestTypes
       ADD PRIMARY KEY (RadDestTypeID)
go


CREATE TABLE dbo.RadFilterGroups (
       RadFilterGroupID     int IDENTITY,
       RadFilterGroup       varchar(64) NOT NULL,
       RadSourceTypeID      int NOT NULL,
       Description          varchar(255) NULL,
       DestRadFilterGroupID int NULL,
       DestData             varchar(255) NULL,
       RadDestTypeID        int NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.RadFilterGroups
       ADD PRIMARY KEY (RadFilterGroupID)
go


CREATE TABLE dbo.RadFilters (
       RadFilterID          int IDENTITY,
       RadMergeTypeID       int NULL,
       RadFilterTypeID      int NULL,
       RadVendorID          int NULL,
       RadSearchTypeID      int NOT NULL,
       RadAttributeID       int NULL,
       RadFilterGroupID     int NOT NULL,
       Location             varchar(64) NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.RadFilters
       ADD PRIMARY KEY (RadFilterID)
go


CREATE TABLE dbo.RadFilterTypes (
       RadFilterTypeID      int NOT NULL,
       RadFilterType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RadFilterTypes
       ADD PRIMARY KEY (RadFilterTypeID)
go


CREATE TABLE dbo.RadIPAccountTypes (
       RadIPAccountTypeID   int IDENTITY,
       ServerGroupID        int NOT NULL,
       AccountTypeID        int NULL,
       RadIPGroupID         int NULL,
       Priority             int NOT NULL DEFAULT 0,
       AssignType           smallint NULL
)
go


ALTER TABLE dbo.RadIPAccountTypes
       ADD PRIMARY KEY (RadIPAccountTypeID)
go


CREATE TABLE dbo.RadIPAddresses (
       NASIdentifier        varchar(32) NULL,
       NASPort              varchar(32) NULL,
       IPAddress            varchar(16) NOT NULL,
       RadIPGroupID         int NOT NULL,
       State                int NOT NULL DEFAULT 0,
       LastUsed             datetime NULL DEFAULT getdate(),
       LastCallDate         datetime NOT NULL DEFAULT getdate(),
       AccountID            int NULL
)
go

CREATE CLUSTERED INDEX IX_RadIPAddresses ON dbo.RadIPAddresses
(
       NASIdentifier,
       NASPort
)
go

CREATE INDEX I_RadIPAddress_AID ON dbo.RadIPAddresses
(
       AccountID
)
go


ALTER TABLE dbo.RadIPAddresses
       ADD PRIMARY KEY NONCLUSTERED (IPAddress)
go


CREATE TABLE dbo.RadIPGroups (
       RadIPGroupID         int IDENTITY,
       RadIPGroup           varchar(32) NOT NULL
)
go


ALTER TABLE dbo.RadIPGroups
       ADD PRIMARY KEY (RadIPGroupID)
go


CREATE TABLE dbo.RadLogMsgs (
       RadLogMsgID          int NOT NULL,
       Description          varchar(50) NOT NULL,
       Severity             int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RadLogMsgs
       ADD PRIMARY KEY (RadLogMsgID)
go


CREATE TABLE dbo.RadLogs (
       RadLogMsgID          int NOT NULL,
       LogDate              smalldatetime NOT NULL DEFAULT getdate(),
       Username             varchar(64) NOT NULL,
       Data                 varchar(50) NULL,
       NASIdentifier        varchar(32) NULL,
       NASPort              varchar(32) NULL,
       CallerID             varchar(64) NULL
)
go


ALTER TABLE dbo.RadLogs
       ADD PRIMARY KEY (RadLogMsgID, LogDate, Username)
go


CREATE TABLE dbo.RadMapAttributes (
       MapAttribute         varchar(64) NOT NULL,
       RadMapTypeID         int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL
)
go


ALTER TABLE dbo.RadMapAttributes
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID)
go


CREATE TABLE dbo.RadMapTypes (
       RadMapTypeID         int NOT NULL,
       RadMapType           varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RadMapTypes
       ADD PRIMARY KEY (RadMapTypeID)
go


CREATE TABLE dbo.RadMapValues (
       MapAttribute         varchar(64) NOT NULL,
       RadMapTypeID         int NOT NULL,
       MapValue             varchar(64) NOT NULL,
       RadValue             int NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RadMapValues
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID, MapValue, 
              RadValue)
go


CREATE TABLE dbo.RadMergeTypes (
       RadMergeTypeID       int NOT NULL,
       RadMergeType         char(64) NOT NULL
)
go


ALTER TABLE dbo.RadMergeTypes
       ADD PRIMARY KEY (RadMergeTypeID)
go


CREATE TABLE dbo.RadProxyAttributeGroups (
       RadProxyAttributeGroupID int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Priority             int NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RadProxyAttributeGroups
       ADD PRIMARY KEY (RadProxyAttributeGroupID)
go


CREATE TABLE dbo.RadProxyAttributes (
       RadProxyAttributeGroupID int NOT NULL,
       SearchType           smallint NOT NULL,
       String               varchar(253) NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadProxyAttributeID  int IDENTITY
)
go


ALTER TABLE dbo.RadProxyAttributes
       ADD PRIMARY KEY (RadProxyAttributeGroupID, SearchType, String, 
              RadAttributeID, RadVendorID)
go


CREATE TABLE dbo.RadProxyRateProcs (
       Realm                varchar(64) NOT NULL,
       ProxyType            smallint NOT NULL,
       ProcDate             smalldatetime NOT NULL,
       InBytes              bigint NULL,
       OutBytes             bigint NULL,
       UserCount            int NULL,
       SessionTime          int NULL,
       SessionCount         int NULL
)
go


ALTER TABLE dbo.RadProxyRateProcs
       ADD PRIMARY KEY (Realm, ProcDate, ProxyType)
go


CREATE TABLE dbo.RadRejectAttributes (
       RadRejectAttributeID int IDENTITY,
       IEAID                int NULL,
       ServerID             int NULL,
       RadLogMsgID          int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RadRejectAttributes
       ADD PRIMARY KEY (RadRejectAttributeID)
go


CREATE TABLE dbo.RadRejects (
       RadRejectID          int IDENTITY,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Data                 varchar(100) NOT NULL,
       Value                int NULL
)
go


ALTER TABLE dbo.RadRejects
       ADD PRIMARY KEY (RadRejectID)
go


CREATE TABLE dbo.RadRoamDomains (
       RadRoamDomainID      int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Domain               varchar(64) NOT NULL,
       Priority             int NOT NULL DEFAULT 0,
       AccountTypeID        int NULL
)
go

CREATE INDEX i_RadRoamDomains_Domain ON dbo.RadRoamDomains
(
       Domain
)
go


ALTER TABLE dbo.RadRoamDomains
       ADD PRIMARY KEY (RadRoamDomainID)
go


CREATE TABLE dbo.RadRoamServers (
       RadRoamServerID      int IDENTITY,
       IPAddress            varchar(32) NOT NULL,
       Server               varchar(32) NOT NULL,
       Secret               varchar(255) NOT NULL,
       Timeout              int NOT NULL DEFAULT 0,
       Retries              int NOT NULL DEFAULT 0,
       TreatAsLocal         smallint NOT NULL DEFAULT 0,
       StripDomain          smallint NOT NULL DEFAULT 0,
       AuthPort             int NULL,
       AcctPort             int NULL,
       RateTarget           int NULL,
       RateMax              int NULL
)
go


ALTER TABLE dbo.RadRoamServers
       ADD PRIMARY KEY (RadRoamServerID)
go


CREATE TABLE dbo.RadSearchTypes (
       RadSearchTypeID      int NOT NULL,
       RadSearchType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RadSearchTypes
       ADD PRIMARY KEY (RadSearchTypeID)
go


CREATE TABLE dbo.RadSourceTypes (
       RadSourceTypeID      int NOT NULL,
       RadSourceType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RadSourceTypes
       ADD PRIMARY KEY (RadSourceTypeID)
go


CREATE TABLE dbo.RadTriggers (
       RadTriggerID         int IDENTITY,
       AccountID            int NOT NULL,
       TriggerType          int NOT NULL DEFAULT 0,
       FileName             varchar(64) NOT NULL,
       Parameters           varchar(64) NULL,
       Directory            varchar(128) NULL
)
go


ALTER TABLE dbo.RadTriggers
       ADD PRIMARY KEY (RadTriggerID)
go


CREATE TABLE dbo.RadValues (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       Value                int NOT NULL,
       Name                 varchar(40) NOT NULL
)
go


ALTER TABLE dbo.RadValues
       ADD PRIMARY KEY (RadAttributeID, RadVendorID, Value)
go


CREATE TABLE dbo.RadVendors (
       RadVendorID          int NOT NULL,
       Name                 varchar(32) NOT NULL,
       VendorURL            varchar(128) NULL,
       Description          text NULL,
       Comments             text NULL
)
go


ALTER TABLE dbo.RadVendors
       ADD PRIMARY KEY (RadVendorID)
go


CREATE TABLE dbo.RateClasses (
       RateClassID          int IDENTITY,
       RateClass            varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RateClasses
       ADD PRIMARY KEY (RateClassID)
go


CREATE TABLE dbo.RateDataSources (
       RateDataSourceID     int NOT NULL,
       RateDataSource       varchar(128) NOT NULL,
       RateSourceID         int NULL,
       DSN                  varchar(128) NULL,
       Username             varchar(64) NULL,
       Password             varchar(128) NULL,
       DataQuery            text NOT NULL,
       UpdateQuery          text NULL,
       UseTransactions      smallint NOT NULL DEFAULT 1,
       UpdateInterval       smallint NOT NULL DEFAULT 0,
       BillingMode          int NULL,
       ClearQuery           text NULL
)
go


ALTER TABLE dbo.RateDataSources
       ADD PRIMARY KEY (RateDataSourceID)
go


CREATE TABLE dbo.RateHistory (
       StartDate            datetime NOT NULL,
       AccountID            int NOT NULL,
       CustomerID           int NOT NULL,
       RateRuleID           int NOT NULL,
       RateID               int NOT NULL,
       TotalTime            int NOT NULL,
       ChargeID             int NULL,
       TotalCount           numeric(28,12) NOT NULL,
       TotalData            bigint NOT NULL,
       TotalCost            numeric(28,12) NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RateHistory_ChargeID ON dbo.RateHistory
(
       CustomerID,
       ChargeID
)
go


ALTER TABLE dbo.RateHistory
       ADD PRIMARY KEY (StartDate, AccountID, CustomerID, RateRuleID, 
              RateID)
go


CREATE TABLE dbo.RateIntervals (
       RateIntervalID       int NOT NULL,
       RateRuleTypeID       int NOT NULL,
       NameSingular         varchar(64) NOT NULL,
       NamePlural           varchar(64) NOT NULL,
       NameShort            varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RateIntervals
       ADD PRIMARY KEY (RateIntervalID)
go


CREATE TABLE dbo.RateIPPorts (
       Port                 int NOT NULL,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateIPPorts
       ADD PRIMARY KEY (Port)
go


CREATE TABLE dbo.RateIPProtocols (
       Protocol             int NOT NULL,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateIPProtocols
       ADD PRIMARY KEY (Protocol)
go


CREATE TABLE dbo.RateItems (
       RateItemID           int IDENTITY,
       RateID               int NOT NULL,
       RateRuleID           int NOT NULL,
       RateTimeGroupID      int NOT NULL
)
go

CREATE UNIQUE INDEX IX_RateItems ON dbo.RateItems
(
       RateID,
       RateRuleID,
       RateTimeGroupID
)
go


ALTER TABLE dbo.RateItems
       ADD PRIMARY KEY (RateItemID)
go


CREATE TABLE dbo.RateMatchTypes (
       RateMatchTypeID      int NOT NULL,
       RateMatchType        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RateMatchTypes
       ADD PRIMARY KEY (RateMatchTypeID)
go


CREATE TABLE dbo.RateRoundTypes (
       RateRoundTypeID      int NOT NULL,
       RateRoundType        varchar(64) NOT NULL,
       AllowData            smallint NOT NULL DEFAULT 0,
       AllowTime            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateRoundTypes
       ADD PRIMARY KEY (RateRoundTypeID)
go


CREATE TABLE dbo.RateRules (
       RateRuleID           int IDENTITY,
       RateRule             varchar(64) NOT NULL,
       StringID             int NULL,
       RateSourceID         int NOT NULL,
       RateRoundTypeID      int NOT NULL,
       RateTypeID           int NULL,
       RateRuleTypeID       int NOT NULL DEFAULT 1,
       Interval             int NOT NULL,
       ClassRequired        smallint NOT NULL,
       ClassTTL             int NULL,
       ClassQuery           varchar(255) NULL,
       RuleQuery            varchar(255) NULL,
       DefaultCost          numeric(18,4) NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.RateRules
       ADD PRIMARY KEY (RateRuleID)
go


CREATE TABLE dbo.RateRuleTypes (
       RateRuleTypeID       int NOT NULL,
       RateRuleType         varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RateRuleTypes
       ADD PRIMARY KEY (RateRuleTypeID)
go


CREATE TABLE dbo.Rates (
       RateID               int IDENTITY,
       RateSourceID         int NOT NULL,
       Description          varchar(30) NOT NULL,
       MinCharge            numeric(18,4) NULL,
       MaxCharge            numeric(18,4) NULL,
       ChargeTypeID         int NOT NULL,
       RateClassID          int NOT NULL DEFAULT 1,
       DataRateRuleID       int NULL,
       ClassifierRateRuleID int NULL,
       AuthMaxTime          int NULL,
       AuthRate             smallint NULL,
       AuthRateTime         smallint NULL
)
go


ALTER TABLE dbo.Rates
       ADD PRIMARY KEY (RateID)
go


CREATE TABLE dbo.RateSourceAttributes (
       RateSourceID         int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       Description          varchar(255) NULL,
       AllowData            smallint NOT NULL DEFAULT 0,
       AllowTime            smallint NOT NULL DEFAULT 0,
       Dynamic              smallint NOT NULL DEFAULT 0,
       ValuesQuery          varchar(255) NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       RateMatchTypes       int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateSourceAttributes
       ADD PRIMARY KEY (RateSourceID, Attribute)
go


CREATE TABLE dbo.RateSources (
       RateSourceID         int NOT NULL,
       RateSource           varchar(255) NOT NULL,
       AllowData            smallint NOT NULL DEFAULT 1,
       AllowTime            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.RateSources
       ADD PRIMARY KEY (RateSourceID)
go


CREATE TABLE dbo.RateStatusCalls (
       LastCallID           bigint NULL,
       Leader               varchar(64) NULL,
       LastUpdate           datetime NOT NULL DEFAULT 'Jan 1 2000',
       LastMessage          varchar(255) NULL,
       Advisor              varchar(64) NULL,
       LastAdviceDate       datetime NOT NULL DEFAULT 'Jan 1 2000'
)
go


CREATE TABLE dbo.RateStdGroups (
       RateStdGroupID       int IDENTITY,
       RateRuleID           int NOT NULL,
       Priority             smallint NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RateStdGroups
       ADD PRIMARY KEY (RateStdGroupID)
go


CREATE TABLE dbo.RateStdItems (
       RateStdItemID        int IDENTITY,
       RateStdGroupID       int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       RateMatchTypeID      int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RateStdItems
       ADD PRIMARY KEY (RateStdItemID)
go


CREATE TABLE dbo.RateTimeGroups (
       RateTimeGroupID      int IDENTITY,
       RateTimeGroup        varchar(128) NOT NULL
)
go


ALTER TABLE dbo.RateTimeGroups
       ADD PRIMARY KEY (RateTimeGroupID)
go


CREATE TABLE dbo.RateTimes (
       RateTimeID           int IDENTITY,
       RateTimeGroupID      int NOT NULL,
       StartHour            smallint NULL,
       StartMinute          smallint NULL,
       EndHour              smallint NULL,
       EndMinute            smallint NULL,
       DayWeekMask          int NULL,
       WeekNumMask          int NULL,
       MonthMask            int NULL,
       MonthDay             smallint NULL,
       Priority             smallint NULL,
       Description          varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RateTimes
       ADD PRIMARY KEY (RateTimeID)
go


CREATE TABLE dbo.RateTypes (
       RateTypeID           int NOT NULL,
       RateType             varchar(128) NOT NULL,
       RateSourceID         int NULL,
       RuleQuery            varchar(255) NOT NULL,
       ScriptConfigure      varchar(64) NOT NULL,
       ScriptSummary        varchar(64) NOT NULL
)
go


ALTER TABLE dbo.RateTypes
       ADD PRIMARY KEY (RateTypeID)
go


CREATE TABLE dbo.RateVCondGroups (
       RateVCondGroupID     int IDENTITY(1, 1),
       RateVCondGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Priority             smallint NULL
)
go


ALTER TABLE dbo.RateVCondGroups
       ADD PRIMARY KEY (RateVCondGroupID)
go


CREATE TABLE dbo.RateVCondItems (
       RateVCondItemID      int IDENTITY(1, 1),
       RateVCondGroupID     int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       RateMatchTypeID      int NOT NULL,
       Data                 varchar(255) NOT NULL
)
go


ALTER TABLE dbo.RateVCondItems
       ADD PRIMARY KEY (RateVCondItemID)
go


CREATE TABLE dbo.RateVDNIS (
       RateVDNISID          int IDENTITY(1, 1),
       RateVDNIS            varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       Attribute            varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.RateVDNIS
       ADD PRIMARY KEY (RateVDNISID)
go


CREATE TABLE dbo.RateVDNISGroupItems (
       RateVDNISGroupID     int NOT NULL,
       RateVDNISID          int NOT NULL,
       RateVCondGroupID     int NULL
)
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD PRIMARY KEY (RateVDNISGroupID, RateVDNISID)
go


CREATE TABLE dbo.RateVDNISGroups (
       RateVDNISGroupID     int IDENTITY(1, 1),
       RateVDNISGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.RateVDNISGroups
       ADD PRIMARY KEY (RateVDNISGroupID)
go


CREATE TABLE dbo.RateVDNISItems (
       RateVDNISItemID      int IDENTITY(1, 1),
       RateVDNISID          int NOT NULL,
       RateVDNISItem        varchar(128) NULL,
       DNIS                 varchar(64) NOT NULL,
       Location             varchar(128) NULL,
       RateMatchTypeID      int NOT NULL,
       IntervalCost         numeric(18,4) NULL,
       IntervalOption       smallint NOT NULL DEFAULT 0,
       InitialCost          numeric(18,4) NULL,
       InitialOption        smallint NOT NULL DEFAULT 0,
       StaticCost           numeric(18,4) NULL,
       StaticOption         smallint NOT NULL DEFAULT 0,
       CountryID            int NULL,
       StateID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go

CREATE INDEX i_RVDI_DNIS ON dbo.RateVDNISItems
(
       DNIS
)
go


ALTER TABLE dbo.RateVDNISItems
       ADD PRIMARY KEY (RateVDNISItemID)
go


CREATE TABLE dbo.RateVRates (
       RateVRateID          int IDENTITY(1, 1),
       RateVRate            varchar(128) NULL,
       RateRuleID           int NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       RateVDNISID          int NULL,
       RateVDNISGroupID     int NULL,
       RateVCondGroupID     int NULL,
       Multiplier           numeric(18,4) NULL
)
go


ALTER TABLE dbo.RateVRates
       ADD PRIMARY KEY (RateVRateID)
go


CREATE TABLE dbo.ReferredBys (
       ReferredByID         int IDENTITY,
       ReferredBy           varchar(64) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.ReferredBys
       ADD PRIMARY KEY (ReferredByID)
go


CREATE TABLE dbo.Regions (
       RegionID             int IDENTITY,
       Region               varchar(64) NOT NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.Regions
       ADD PRIMARY KEY (RegionID)
go


CREATE TABLE dbo.ReportFields (
       ReportFieldID        int NOT NULL,
       ReportField          varchar(128) NOT NULL,
       StringID             int NULL,
       Description          varchar(255) NULL,
       FieldName            varchar(64) NOT NULL,
       CRFieldName          varchar(128) NULL,
       DataType             smallint NOT NULL,
       DefaultValue         varchar(255) NULL,
       EWSFile              varchar(64) NULL
)
go


ALTER TABLE dbo.ReportFields
       ADD PRIMARY KEY (ReportFieldID)
go


CREATE TABLE dbo.ReportGroups (
       ReportGroupID        int IDENTITY,
       ReportGroup          varchar(64) NOT NULL,
       Description          varchar(128) NOT NULL,
       SortOrder            int NOT NULL,
       OperatorGroupID      int NULL
)
go


ALTER TABLE dbo.ReportGroups
       ADD PRIMARY KEY (ReportGroupID)
go


CREATE TABLE dbo.ReportParameters (
       FileName             varchar(45) NOT NULL,
       ReportFieldID        int NOT NULL,
       Required             smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ReportParameters
       ADD PRIMARY KEY (FileName, ReportFieldID)
go


CREATE TABLE dbo.Reports (
       ReportID             int IDENTITY,
       ReportGroupID        int NOT NULL,
       Report               varchar(35) NOT NULL,
       FileName             varchar(45) NOT NULL,
       GroupID              int NULL,
       ReportType           int NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.Reports
       ADD PRIMARY KEY (ReportID)
go


CREATE TABLE dbo.ReportSessionParameters (
       ReportSessionID      int NOT NULL,
       ParameterName        varchar(32) NOT NULL,
       ParameterData        varchar(128) NOT NULL
)
go


ALTER TABLE dbo.ReportSessionParameters
       ADD PRIMARY KEY (ReportSessionID, ParameterName)
go


CREATE TABLE dbo.ReportSessions (
       ReportSessionID      int IDENTITY,
       OperatorID           int NOT NULL,
       SessionTag           varchar(16) NOT NULL,
       ReportName           varchar(128) NOT NULL,
       GroupSecurity        int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ReportSessions
       ADD PRIMARY KEY (ReportSessionID)
go


CREATE TABLE dbo.ResellerPkgUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       PackageID            int NOT NULL,
       PackageTypeID        int NOT NULL,
       Days                 float NOT NULL DEFAULT (0),
       LastUpdate           datetime NOT NULL DEFAULT (getdate()),
       ItemID               int NULL
)
go

CREATE INDEX i_ResellerPkgUsage_PackageID ON dbo.ResellerPkgUsage
(
       PackageID,
       StartYear,
       StartMonth
)
go


ALTER TABLE dbo.ResellerPkgUsage
       ADD PRIMARY KEY (StartYear, StartMonth, PackageID, 
              PackageTypeID)
go


CREATE TABLE dbo.ResellerUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       AccountID            int NOT NULL,
       AccountTypeID        int NOT NULL,
       Days                 float NOT NULL DEFAULT 0,
       LastUpdate           datetime NOT NULL DEFAULT getdate(),
       ItemID               int NULL
)
go

CREATE INDEX i_ResellerUsage_AccountID ON dbo.ResellerUsage
(
       AccountID,
       StartYear,
       StartMonth
)
go


ALTER TABLE dbo.ResellerUsage
       ADD PRIMARY KEY (StartYear, StartMonth, AccountID, 
              AccountTypeID)
go


CREATE TABLE dbo.Roles (
       RoleID               int IDENTITY,
       Role                 varchar(128) NOT NULL,
       GroupID              int NULL,
       AssignStrategyID     int NULL
)
go


ALTER TABLE dbo.Roles
       ADD PRIMARY KEY (RoleID)
go


CREATE TABLE dbo.SalesPersons (
       SalesPersonID        int IDENTITY,
       SalesPerson          varchar(128) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1,
       Active               smallint NOT NULL DEFAULT 1,
       OperatorID           int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       CommissionGroupID    int NULL,
       CommissionValue      numeric(18,4) NULL
)
go

CREATE UNIQUE INDEX iSalesPersons_SalesPerson ON dbo.SalesPersons
(
       SalesPerson
)
go

CREATE INDEX I_SalesPersons_SPCG ON dbo.SalesPersons
(
       SalesPersonID,
       CommissionGroupID
)
go


ALTER TABLE dbo.SalesPersons
       ADD PRIMARY KEY (SalesPersonID)
go


CREATE TABLE dbo.ScheduleIntervals (
       Interval             varchar(32) NOT NULL,
       Seconds              int NOT NULL
)
go


ALTER TABLE dbo.ScheduleIntervals
       ADD PRIMARY KEY (Interval)
go


CREATE TABLE dbo.ScheduleLogs (
       ScheduleLogID        int IDENTITY,
       ScheduleID           int NOT NULL,
       ScheduleServerID     int NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       Status               smallint NOT NULL,
       Description          varchar(255) NULL
)
go

CREATE INDEX i_ScheduleLogs_StartDate ON dbo.ScheduleLogs
(
       StartDate
)
go


ALTER TABLE dbo.ScheduleLogs
       ADD PRIMARY KEY (ScheduleLogID)
go


CREATE TABLE dbo.Schedules (
       ScheduleID           int IDENTITY,
       Server               varchar(32) NULL,
       ScheduleServerID     int NULL,
       TaskName             varchar(32) NOT NULL,
       Parameter            varchar(255) NULL,
       TargetSecs           int NULL,
       MaxSecs              int NULL,
       Status               smallint NOT NULL DEFAULT 0,
       LastStatus           varchar(255) NULL,
       LastStart            datetime NULL,
       LastUpdate           datetime NULL,
       Interval             int NOT NULL DEFAULT 0,
       StartDate            datetime NULL,
       Aligned              smallint NOT NULL DEFAULT 0,
       Description          varchar(100) NULL,
       LockServerID         int NULL,
       Active               smallint NOT NULL DEFAULT 1,
       MaxConcurrent        int NOT NULL DEFAULT 1,
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Operator             varchar(64) NULL DEFAULT suser_name()
)
go


ALTER TABLE dbo.Schedules
       ADD PRIMARY KEY (ScheduleID)
go


CREATE TABLE dbo.ScheduleServers (
       Server               varchar(32) NOT NULL,
       ScheduleServerID     int IDENTITY,
       IPAddress            varchar(32) NULL,
       Port                 int NOT NULL,
       Description          varchar(100) NULL,
       LastStart            datetime NULL DEFAULT getdate(),
       Signal               smallint NOT NULL DEFAULT 1
)
go


ALTER TABLE dbo.ScheduleServers
       ADD PRIMARY KEY (Server)
go


CREATE TABLE dbo.ScheduleTasks (
       TaskName             varchar(32) NOT NULL,
       TaskType             varchar(32) NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE dbo.ScheduleTasks
       ADD PRIMARY KEY (TaskName)
go


CREATE TABLE dbo.SendMethods (
       SendMethodID         int IDENTITY,
       Description          varchar(64) NOT NULL,
       StringID             int NULL,
       GroupID              int NULL,
       ServiceGroupID       int NULL,
       ChargeTypeID         int NULL,
       PrintTypeID          smallint NULL,
       EmailTypeID          smallint NULL,
       SortOrder            smallint NOT NULL,
       PrintAutoTrans       smallint NOT NULL DEFAULT 0,
       EmailAutoTrans       smallint NOT NULL DEFAULT 0,
       CustomerAccess       smallint NULL
)
go


ALTER TABLE dbo.SendMethods
       ADD PRIMARY KEY (SendMethodID)
go


CREATE TABLE dbo.ServerAccess (
       ServerAccessID       int IDENTITY,
       ServerID             int NULL,
       Port                 varchar(10) NULL,
       AccountTypeID        int NULL,
       StartTime            int NULL,
       StopTime             int NULL,
       MaxSessionLength     int NULL DEFAULT 0
)
go


ALTER TABLE dbo.ServerAccess
       ADD PRIMARY KEY (ServerAccessID)
go


CREATE TABLE dbo.ServerGroups (
       ServerGroupID        int IDENTITY,
       ServerGroup          varchar(32) NOT NULL
)
go


ALTER TABLE dbo.ServerGroups
       ADD PRIMARY KEY (ServerGroupID)
go


CREATE TABLE dbo.ServerHistory (
       ServerID             int NOT NULL,
       HistoryDate          datetime NOT NULL DEFAULT getdate(),
       Calls                int NOT NULL DEFAULT 0,
       Minutes              int NOT NULL DEFAULT 0,
       Bytes                int NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ServerHistory
       ADD PRIMARY KEY (ServerID, HistoryDate)
go


CREATE TABLE dbo.ServerPorts (
       NASIdentifier        varchar(32) NOT NULL,
       Port                 varchar(32) NOT NULL,
       ServerID             int NULL,
       Username             varchar(64) NULL DEFAULT null,
       AccountID            int NULL,
       AcctSessionID        varchar(32) NULL DEFAULT null,
       AcctSessionTime      int NULL,
       AcctInputOctets      bigint NULL,
       AcctOutputOctets     bigint NULL,
       AcctStatusType       smallint NULL DEFAULT null,
       CallDate             smalldatetime NOT NULL DEFAULT getdate(),
       FramedAddress        varchar(32) NULL DEFAULT null,
       NASPortDNIS          varchar(64) NULL,
       CallerID             varchar(64) NULL DEFAULT null,
       ConnectInfo          varchar(64) NULL DEFAULT null,
       SNMPUser             varchar(64) NULL DEFAULT null
)
go

CREATE INDEX i_ServerPorts_UserName ON dbo.ServerPorts
(
       Username
)
go

CREATE INDEX i_ServerPorts_CallerID ON dbo.ServerPorts
(
       CallerID
)
go

CREATE INDEX IX_ServerPorts ON dbo.ServerPorts
(
       AccountID,
       AcctStatusType
)
go


ALTER TABLE dbo.ServerPorts
       ADD PRIMARY KEY (NASIdentifier, Port)
go


CREATE TABLE dbo.Servers (
       ServerID             int IDENTITY,
       ServerGroupID        int NOT NULL,
       Server               varchar(32) NOT NULL,
       ServerType           int NOT NULL,
       IPAddress            varchar(64) NOT NULL,
       Location             varchar(128) NULL,
       Ports                smallint NULL DEFAULT 0,
       Modems               smallint NULL DEFAULT 0,
       PhoneNumber          varchar(32) NULL,
       ContactName          varchar(64) NULL,
       ContactPhone         varchar(32) NULL,
       ContactPage          varchar(32) NULL,
       Comments             varchar(128) NULL,
       DynamicStart         varchar(16) NULL,
       DynamicEnd           varchar(16) NULL,
       Secret               varchar(255) NULL DEFAULT null,
       Community            varchar(16) NULL DEFAULT null,
       RadRoamServerID      int NULL,
       CheckAccess          int NULL DEFAULT null,
       Concurrency          int NULL DEFAULT 1,
       AuthPort             int NULL,
       AcctPort             int NULL,
       DisconnectPort       int NULL,
       DisconnectType       INT NULL
)
go

CREATE UNIQUE INDEX iIPAddress ON dbo.Servers
(
       IPAddress
)
go


ALTER TABLE dbo.Servers
       ADD PRIMARY KEY (ServerID)
go


CREATE TABLE dbo.ServerTypes (
       ServerType           int NOT NULL,
       Vendor               varchar(32) NULL,
       Model                varchar(32) NULL,
       SNMPType             int NULL,
       SNMPUser             varchar(64) NULL
)
go


ALTER TABLE dbo.ServerTypes
       ADD PRIMARY KEY (ServerType)
go


CREATE TABLE dbo.ServiceGroupItems (
       ServiceGroupID       int NOT NULL,
       GroupID              int NOT NULL
)
go

CREATE INDEX i_ServiceGroupItems_GroupID ON dbo.ServiceGroupItems
(
       GroupID
)
go


ALTER TABLE dbo.ServiceGroupItems
       ADD PRIMARY KEY (ServiceGroupID, GroupID)
go


CREATE TABLE dbo.ServiceGroups (
       ServiceGroupID       int IDENTITY,
       ServiceGroup         varchar(128) NOT NULL,
       Description          text NULL,
       AllowAccountTypes    smallint NOT NULL DEFAULT 1,
       AllowPackageTypes    smallint NOT NULL DEFAULT 1,
       AllowBillingCycles   smallint NOT NULL DEFAULT 1,
       AllowRegions         smallint NOT NULL DEFAULT 1,
       AllowDomains         smallint NOT NULL DEFAULT 1,
       AllowPayPeriods      smallint NOT NULL DEFAULT 1,
       AllowChargeTypes     smallint NOT NULL DEFAULT 1,
       AllowSalesPersons    smallint NOT NULL DEFAULT 1,
       AllowDiscounts       smallint NOT NULL DEFAULT 1,
       AllowSendMethods     smallint NOT NULL DEFAULT 1,
       AllowIncidentTypes   smallint NOT NULL DEFAULT 1,
       SortOrder            smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ServiceGroups
       ADD PRIMARY KEY (ServiceGroupID)
go


CREATE TABLE dbo.SignupPackageTypes (
       SignupPackageTypeID  int IDENTITY,
       SignupServerID       int NOT NULL,
       PackageTypeID        int NOT NULL
)
go

CREATE UNIQUE INDEX i_SPT_Signup_Package ON dbo.SignupPackageTypes
(
       SignupServerID,
       PackageTypeID
)
go


ALTER TABLE dbo.SignupPackageTypes
       ADD PRIMARY KEY (SignupPackageTypeID)
go


CREATE TABLE dbo.SignupServers (
       SignupServerID       int IDENTITY,
       SignupServer         varchar(128) NOT NULL,
       Description          text NULL,
       ThemeID              int NOT NULL,
       GroupID              int NOT NULL,
       RegionID             int NOT NULL,
       PackageTypeID        int NULL,
       CountryID            int NULL,
       SalesPersonID        int NULL,
       DiscountID           int NOT NULL,
       DomainID             int NOT NULL,
       LogOffURL            varchar(128) NULL,
       ServerPOP3           varchar(64) NULL,
       ServerSMTP           varchar(64) NULL,
       ServerNNTP           varchar(64) NULL,
       ServerDNS1           varchar(64) NULL,
       ServerDNS2           varchar(64) NULL,
       ServerIMAP4          varchar(64) NULL,
       ServerMisc1          varchar(64) NULL,
       ServerMisc2          varchar(64) NULL,
       ShowCompany          smallint NOT NULL DEFAULT 1,
       ShowAddress          smallint NOT NULL DEFAULT 1,
       ShowPhone            smallint NOT NULL DEFAULT 1,
       ShowEmail            smallint NOT NULL DEFAULT 1,
       ShowReferredBy       smallint NOT NULL DEFAULT 1,
       LoginFillType        smallint NOT NULL DEFAULT 0,
       SetupCharge          smallint NOT NULL DEFAULT 1,
       AddressTypeID        int NULL,
       AddressDescription   varchar(128) NULL,
       Title                varchar(128) NULL,
       ShowLogin            smallint NULL,
       PrepaidTransfer      smallint NULL
)
go


ALTER TABLE dbo.SignupServers
       ADD PRIMARY KEY (SignupServerID)
go


CREATE TABLE dbo.Statements (
       StatementID          int IDENTITY,
       BatchID              int NULL,
       CustomerID           int NOT NULL,
       StatementDate        datetime NOT NULL DEFAULT getdate(),
       SentDate             datetime NULL,
       DueDate              datetime NULL,
       PrevBal              numeric(18,4) NOT NULL DEFAULT 0,
       NewCharges           numeric(18,4) NOT NULL,
       NewCredits           numeric(18,4) NOT NULL,
       EndBal               numeric(18,4) NOT NULL DEFAULT 0,
       End0Bal              numeric(18,4) NOT NULL DEFAULT 0,
       End30Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End60Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End90Bal             numeric(18,4) NOT NULL DEFAULT 0,
       End120Bal            numeric(18,4) NOT NULL DEFAULT 0,
       PrintDate            datetime NULL,
       EmailDate            datetime NULL,
       PrintBatchID         int NULL
)
go

CREATE INDEX XIE1Statements ON dbo.Statements
(
       StatementDate
)
go

CREATE INDEX i_Statements_PrintBatchID ON dbo.Statements
(
       PrintBatchID
)
go

CREATE INDEX i_Statements_CustomerID ON dbo.Statements
(
       CustomerID
)
go


ALTER TABLE dbo.Statements
       ADD PRIMARY KEY (StatementID)
go


CREATE TABLE dbo.States (
       StateID              int IDENTITY,
       CountryID            int NOT NULL,
       State                varchar(64) NOT NULL,
       Abbreviation         varchar(10) NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       TimeZone1            numeric(4,2) NULL,
       TimeZone2            numeric(4,2) NULL
)
go

CREATE UNIQUE INDEX i_States_Country_State ON dbo.States
(
       State,
       CountryID
)
go


ALTER TABLE dbo.States
       ADD PRIMARY KEY (StateID)
go


CREATE TABLE dbo.Strings (
       StringID             int NOT NULL,
       LanguageID           int NOT NULL,
       ApplicationID        int NOT NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.Strings
       ADD PRIMARY KEY (StringID, LanguageID, ApplicationID)
go


CREATE TABLE dbo.SubAccountData (
       AccountID            int NOT NULL,
       AccountDataTypeID    int NOT NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE dbo.SubAccountData
       ADD PRIMARY KEY (AccountID, AccountDataTypeID)
go


CREATE TABLE dbo.SubAccountDataTypes (
       SubAccountDataTypeID int IDENTITY,
       AccountTypeID        int NULL,
       AccountDataTypeID    int NOT NULL,
       DefaultData          varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT 10,
       Required             smallint NULL
)
go

CREATE UNIQUE INDEX IX_SubAccountDataTypes ON dbo.SubAccountDataTypes
(
       AccountTypeID,
       AccountDataTypeID
)
go


ALTER TABLE dbo.SubAccountDataTypes
       ADD PRIMARY KEY (SubAccountDataTypeID)
go


CREATE TABLE dbo.SubAccounts (
       AccountID            int IDENTITY,
       CustomerID           int NOT NULL,
       Login                varchar(40) NULL,
       Email                varchar(64) NULL,
       FirstName            varchar(40) NULL,
       MiddleName           varchar(25) NULL,
       LastName             varchar(40) NULL,
       PhoneHome            varchar(32) NULL,
       PhoneWork            varchar(32) NULL,
       DiffCost             smallint NOT NULL DEFAULT 0,
       AccountTypeID        int NOT NULL,
       PayPeriodID          int NOT NULL,
       Cost                 numeric(18,4) NULL DEFAULT 0,
       DiscountID           int NOT NULL,
       Comments             text NULL,
       Password             varchar(128) NULL,
       MaidenName           varchar(25) NULL,
       CreateDate           datetime NOT NULL DEFAULT getdate(),
       StartDate            datetime NOT NULL DEFAULT getdate(),
       BilledThru           datetime NOT NULL DEFAULT null,
       ExpireDate           datetime NULL DEFAULT null,
       Extension            int NOT NULL DEFAULT 0,
       Active               smallint NOT NULL DEFAULT 1,
       SalesPersonID        int NULL,
       Operator             varchar(64) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT getdate(),
       LastModifyUser       varchar(64) NOT NULL DEFAULT suser_name(),
       Preferred            smallint NOT NULL DEFAULT 0,
       Status               smallint NOT NULL DEFAULT 1,
       TimeLeft             int NULL DEFAULT null,
       SendBill             smallint NOT NULL DEFAULT 1,
       RemoteAccess         smallint NULL DEFAULT 1,
       LoginLimit           smallint NULL DEFAULT 1,
       BillStatus           smallint NULL,
       LastUsed             datetime NULL DEFAULT null,
       DomainID             int NOT NULL,
       Gender               varchar(1) NULL,
       Salutation           char(4) NULL,
       LastTimeLeftDate     datetime NULL DEFAULT getdate(),
       CycleMonths          int NOT NULL DEFAULT 0,
       PackageID            int NULL,
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       LastInvoiceID        int NULL,
       DataLeft             BIGINT NULL,
       LastDataLeftDate     datetime NULL
)
go

CREATE INDEX iLastName ON dbo.SubAccounts
(
       LastName
)
go

CREATE INDEX i_SA_PhoneHome ON dbo.SubAccounts
(
       PhoneHome
)
go

CREATE INDEX i_SA_PhoneWork ON dbo.SubAccounts
(
       PhoneWork
)
go

CREATE INDEX i_SubAccounts_LMD ON dbo.SubAccounts
(
       LastModifyDate
)
go

CREATE INDEX iLogin ON dbo.SubAccounts
(
       Login
)
go

CREATE INDEX iExpireDate ON dbo.SubAccounts
(
       ExpireDate
)
go

CREATE INDEX i_SubAccounts_Email ON dbo.SubAccounts
(
       Email
)
go

CREATE INDEX i_SubAccounts_Password ON dbo.SubAccounts
(
       Password
)
go

CREATE INDEX i_SubAccounts_LastUsed ON dbo.SubAccounts
(
       LastUsed
)
go

CREATE INDEX iSubAccounts_CustomerID ON dbo.SubAccounts
(
       CustomerID
)
go

CREATE INDEX iSubAccounts_AccountTypeID ON dbo.SubAccounts
(
       AccountTypeID
)
go

CREATE INDEX iSubAccounts_PackageID ON dbo.SubAccounts
(
       PackageID
)
go


ALTER TABLE dbo.SubAccounts
       ADD PRIMARY KEY (AccountID)
go


CREATE TABLE dbo.SubAccountUsages (
       SubAccountUsageID    int IDENTITY,
       AccountID            int NOT NULL,
       ExpireDate           datetime NOT NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       ItemID               int NULL,
       StartTimeLeft        int NULL,
       StartDataLeft        bigint NULL
)
go

CREATE INDEX IX_SAU_AIDEXPTLDL ON dbo.SubAccountUsages
(
       AccountID,
       ExpireDate,
       TimeLeft,
       DataLeft
)
go

CREATE INDEX IX_SAU_ItemID ON dbo.SubAccountUsages
(
       ItemID
)
go


ALTER TABLE dbo.SubAccountUsages
       ADD PRIMARY KEY (SubAccountUsageID)
go


CREATE TABLE dbo.SysLogFilters (
       SysLogFilterID       int IDENTITY,
       IPAddress            varchar(32) NULL,
       Severity             smallint NOT NULL DEFAULT 0,
       SubString            varchar(255) NULL
)
go


ALTER TABLE dbo.SysLogFilters
       ADD PRIMARY KEY (SysLogFilterID)
go


CREATE TABLE dbo.SysLogs (
       SyslogID             bigint IDENTITY,
       LogDate              datetime NOT NULL DEFAULT getdate(),
       Severity             smallint NOT NULL DEFAULT 0,
       Facility             smallint NOT NULL DEFAULT 0,
       IPAddress            varchar(32) NOT NULL,
       Data                 varchar(255) NOT NULL
)
go

CREATE INDEX IX_SysLogs_LogDate ON dbo.SysLogs
(
       LogDate
)
go

CREATE INDEX IX_SysLogs_IPAddress ON dbo.SysLogs
(
       IPAddress
)
go


ALTER TABLE dbo.SysLogs
       ADD PRIMARY KEY (SyslogID)
go


CREATE TABLE dbo.Taxes (
       TaxID                int IDENTITY,
       Description          varchar(64) NOT NULL,
       StringID             int NULL,
       Tax                  numeric(18,4) NOT NULL DEFAULT 0,
       AmountType           smallint NOT NULL DEFAULT 1,
       CumulativeType       smallint NULL,
       FloorLimit           numeric(18,4) NULL,
       CeilingLimit         numeric(18,4) NULL,
       TaxPiggyBackID       int NULL,
       TaxPigOrder          smallint NOT NULL DEFAULT 1,
       GLCodeID             int NULL,
       TaxExemptions        int NOT NULL DEFAULT 0,
       TaxCredits           smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NULL DEFAULT 0,
       TaxTypeID            int NULL
)
go


ALTER TABLE dbo.Taxes
       ADD PRIMARY KEY (TaxID)
go


CREATE TABLE dbo.TaxExemptions (
       TaxExemptionID       int NOT NULL,
       Exemption            varchar(64) NOT NULL,
       StringID             int NULL,
       AllowMBR             smallint NOT NULL DEFAULT 0,
       AllowItem            smallint NOT NULL DEFAULT 0,
       Active               smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.TaxExemptions
       ADD PRIMARY KEY (TaxExemptionID)
go


CREATE TABLE dbo.TaxGroups (
       TaxGroupID           int IDENTITY,
       TaxGroup             varchar(64) NOT NULL
)
go


ALTER TABLE dbo.TaxGroups
       ADD PRIMARY KEY (TaxGroupID)
go


CREATE TABLE dbo.TaxGroupTaxes (
       TaxGroupTaxID        int IDENTITY,
       TaxGroupID           int NOT NULL,
       TaxID                int NOT NULL,
       StateID              int NULL,
       CountryID            int NULL,
       RegionID             int NULL,
       City                 varchar(45) NULL,
       Zip                  varchar(15) NULL
)
go

CREATE UNIQUE INDEX IX_TaxGroupTaxes ON dbo.TaxGroupTaxes
(
       TaxGroupID,
       TaxID,
       StateID,
       CountryID,
       RegionID,
       City,
       Zip
)
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD PRIMARY KEY (TaxGroupTaxID)
go


CREATE TABLE dbo.TaxPiggyBacks (
       TaxPiggyBackID       int IDENTITY,
       TaxPiggyBack         varchar(64) NULL
)
go


ALTER TABLE dbo.TaxPiggyBacks
       ADD PRIMARY KEY (TaxPiggyBackID)
go


CREATE TABLE dbo.TaxTypes (
       TaxTypeID            int IDENTITY,
       TaxType              varchar(64) NOT NULL
)
go


ALTER TABLE dbo.TaxTypes
       ADD PRIMARY KEY (TaxTypeID)
go


CREATE TABLE dbo.ThemeFilters (
       ThemeFilterID        int IDENTITY,
       ThemeFilter          varchar(128) NOT NULL,
       Description          text NULL,
       ThemeID              int NOT NULL,
       ThemeMatchTypeID     int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Score                int NOT NULL
)
go


ALTER TABLE dbo.ThemeFilters
       ADD PRIMARY KEY (ThemeFilterID)
go


CREATE TABLE dbo.ThemeMatchTypes (
       ThemeMatchTypeID     int NOT NULL,
       ThemeMatchType       varchar(128) NOT NULL,
       Hidden               smallint NOT NULL DEFAULT 0
)
go


ALTER TABLE dbo.ThemeMatchTypes
       ADD PRIMARY KEY (ThemeMatchTypeID)
go


CREATE TABLE dbo.Themes (
       ThemeID              int IDENTITY,
       Theme                varchar(50) NOT NULL,
       Description          text NULL
)
go


ALTER TABLE dbo.Themes
       ADD PRIMARY KEY (ThemeID)
go


CREATE TABLE dbo.TimeCharges (
       TimeChargeID         int IDENTITY,
       TimeCharge           varchar(128) NOT NULL,
       StringID             int NULL,
       Description          text NULL,
       ChargeTypeID         int NOT NULL,
       AccountTypeID        int NULL,
       PackageTypeID        int NULL,
       Months               int NULL,
       Days                 int NULL,
       Minutes              int NULL,
       TimeLeft             int NULL,
       CustomerAccess       smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT 0,
       DataLeft             BIGINT NULL
)
go

CREATE UNIQUE INDEX IX_TimeCharges_AccountTypes ON dbo.TimeCharges
(
       ChargeTypeID,
       AccountTypeID
)
go

CREATE UNIQUE INDEX IX_TimeCharges_PackageType ON dbo.TimeCharges
(
       ChargeTypeID,
       PackageTypeID
)
go

CREATE INDEX I_TimeCharges_ATID_CTID ON dbo.TimeCharges
(
       AccountTypeID,
       ChargeTypeID
)
go

CREATE INDEX I_TimeCharges_PTID_ATID ON dbo.TimeCharges
(
       PackageTypeID,
       AccountTypeID
)
go


ALTER TABLE dbo.TimeCharges
       ADD PRIMARY KEY (TimeChargeID)
go


CREATE TABLE dbo.TimeZones (
       TimeZoneID           numeric(4,2) NOT NULL,
       TimeZone             varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.TimeZones
       ADD PRIMARY KEY (TimeZoneID)
go


CREATE TABLE dbo.TransStates (
       TransStateID         int NOT NULL,
       TransState           varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.TransStates
       ADD PRIMARY KEY (TransStateID)
go


CREATE TABLE dbo.TransTypes (
       TransTypeID          int NOT NULL,
       TransType            varchar(64) NOT NULL,
       StringID             int NULL
)
go


ALTER TABLE dbo.TransTypes
       ADD PRIMARY KEY (TransTypeID)
go


CREATE TABLE dbo.VoiceCalls (
       VoiceCallID          bigint IDENTITY(1, 1),
       AccountID            int NULL,
       CallDate             datetime NOT NULL,
       Login                varchar(64) NOT NULL,
       Duration             int NOT NULL,
       SessionRef           varchar(64) NULL,
       CalledNumber         varchar(64) NULL,
       CallingPort          varchar(32) NULL,
       CalledPort           varchar(32) NULL,
       Bytes                bigint NULL,
       CallType             varchar(64) NULL,
       AcctTerminateCause   smallint NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Location             varchar(64) NULL,
       ChargeID             int NULL,
       ProcDate             datetime NULL,
       ErrorCode            smallint NULL,
       Cost                 numeric(18,4) NULL
)
go

CREATE UNIQUE INDEX i_VoiceCalls_Unique ON dbo.VoiceCalls
(
       CallDate,
       Login,
       Duration,
       SessionRef,
       CalledNumber
)
go

CREATE INDEX i_VoiceCalls_AID_CD ON dbo.VoiceCalls
(
       AccountID,
       CallDate
)
go

CREATE INDEX i_VoiceCalls_C_PD ON dbo.VoiceCalls
(
       ChargeID,
       ProcDate
)
go


ALTER TABLE dbo.VoiceCalls
       ADD PRIMARY KEY (VoiceCallID)
go


CREATE TABLE dbo.WebAccess (
       WebAccess            int NOT NULL,
       Name                 varchar(32) NOT NULL
)
go


ALTER TABLE dbo.WebAccess
       ADD PRIMARY KEY (WebAccess)
go


CREATE TABLE dbo.WebLinks (
       WebLinkID            int IDENTITY,
       LinkType             int NOT NULL DEFAULT 1,
       SortOrder            int NOT NULL DEFAULT 1,
       Title                varchar(64) NOT NULL,
       URL                  varchar(128) NOT NULL
)
go


ALTER TABLE dbo.WebLinks
       ADD PRIMARY KEY (WebLinkID)
go


ALTER TABLE dbo.AccountDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go


ALTER TABLE dbo.AccountDataValues
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (AccountTemplateID)
                             REFERENCES dbo.AccountTemplates
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES dbo.RateClasses
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES dbo.DNISGroups
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (CreateAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES dbo.Incidents
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.Actions
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.Addresses
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Aliases
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.AuditLogs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES dbo.LogMsgs
go


ALTER TABLE dbo.BankTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Batches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.BatchProcessors
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (LateFeeID)
                             REFERENCES dbo.LateFees
go


ALTER TABLE dbo.BillingCycles
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (DirectAccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (DirectCustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.CardAccounts
       ADD FOREIGN KEY (CardBatchID)
                             REFERENCES dbo.CardBatches
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (CardBatchTypeID)
                             REFERENCES dbo.CardBatchTypes
go


ALTER TABLE dbo.CardBatches
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (LoginCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (PasswordCardDigitID)
                             REFERENCES dbo.CardDigits
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.CardBatchTypes
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.CardTypePrefixes
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES dbo.CardTypes
go


ALTER TABLE dbo.CCImportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (PackageID)
                             REFERENCES dbo.Packages
go


ALTER TABLE dbo.Charges
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.ChargeTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES dbo.CommissionGroups
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.CommissionItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.ConfigGroupData
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ConfigGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.ConfigOperatorGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.ConfigOperatorGroupData
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.Configs
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go


ALTER TABLE dbo.Configs
       ADD FOREIGN KEY (ConfigGroupID)
                             REFERENCES dbo.ConfigGroups
go


ALTER TABLE dbo.ConfigValues
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES dbo.Configs
go


ALTER TABLE dbo.Countries
       ADD FOREIGN KEY (ContinentID)
                             REFERENCES dbo.Continents
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BillToCountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (BillToStateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.CreditCards
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES dbo.CardTypes
go


ALTER TABLE dbo.Currencies
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.CustomerSettings
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Discounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Discounts
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.DNISNumbers
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES dbo.DNISGroups
go


ALTER TABLE dbo.Documents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Documents
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.Domains
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ExportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.ExternalSyncs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.ExternalSyncs
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES dbo.ExternalSystems
go


ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ExternalSystemAccountTypes
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES dbo.ExternalSystems
go


ALTER TABLE dbo.ExternalSystemDataTypes
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES dbo.ExternalSystemTypes
go


ALTER TABLE dbo.ExternalSystemDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.ExternalSystems
       ADD FOREIGN KEY (ExportID)
                             REFERENCES dbo.Exports
go


ALTER TABLE dbo.ExternalSystems
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES dbo.ExternalSystemTypes
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (TransStateID)
                             REFERENCES dbo.TransStates
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (TransTypeID)
                             REFERENCES dbo.TransTypes
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES dbo.BatchProcessors
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (AuthStateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.ExternalTrans
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES dbo.Payments
go


ALTER TABLE dbo.FileTransfers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.FlowFilters
       ADD FOREIGN KEY (FlowFilterGroupID)
                             REFERENCES dbo.FlowFilterGroups
go


ALTER TABLE dbo.Forwards
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.Groups
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.IncidentData
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES dbo.Incidents
go


ALTER TABLE dbo.IncidentData
       ADD FOREIGN KEY (IncidentDataTypeID)
                             REFERENCES dbo.IncidentDataTypes
go


ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (IncidentTemplateID)
                             REFERENCES dbo.IncidentTemplates
go


ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES dbo.DataTypes
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES dbo.IncidentTypes
go


ALTER TABLE dbo.Incidents
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES dbo.IncidentStates
go


ALTER TABLE dbo.IncidentStates
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES dbo.IncidentStateGroups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES dbo.IncidentStateGroups
go


ALTER TABLE dbo.IncidentTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (PackageID)
                             REFERENCES dbo.Packages
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES dbo.Charges
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ItemType)
                             REFERENCES dbo.InvoiceItemTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.InvoiceItems
       ADD FOREIGN KEY (TaxID)
                             REFERENCES dbo.Taxes
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (BatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (StatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.Invoices
       ADD FOREIGN KEY (InvoiceTypeID)
                             REFERENCES dbo.InvoiceTypes
go


ALTER TABLE dbo.IPs
       ADD FOREIGN KEY (IPClassID)
                             REFERENCES dbo.IPClasses
go


ALTER TABLE dbo.LateFees
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.LocPhones
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.LocZipCodes
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.Logs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES dbo.LogMsgs
go


ALTER TABLE dbo.MasterAccountData
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MasterAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES dbo.CancelReasons
go


ALTER TABLE dbo.MasterAccounts
       ADD FOREIGN KEY (LastStatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.MenuSets
       ADD FOREIGN KEY (MenuItemID)
                             REFERENCES dbo.MenuItems
go


ALTER TABLE dbo.MenuSets
       ADD FOREIGN KEY (MenuID)
                             REFERENCES dbo.Menus
go


ALTER TABLE dbo.MetaColumns
       ADD FOREIGN KEY (MetaRuleID)
                             REFERENCES dbo.MetaRules
go


ALTER TABLE dbo.MetaColumns
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES dbo.MetaTables
go


ALTER TABLE dbo.NoticeActives
       ADD FOREIGN KEY (NoticeID)
                             REFERENCES dbo.Notices
go


ALTER TABLE dbo.Notices
       ADD FOREIGN KEY (NoticeTypeID)
                             REFERENCES dbo.NoticeTypes
go


ALTER TABLE dbo.ObjectGroups
       ADD FOREIGN KEY (ReportID)
                             REFERENCES dbo.Reports
go


ALTER TABLE dbo.Objects
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES dbo.ObjectGroups
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.OperatorGroupAccess
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES dbo.ObjectGroups
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (RoleID)
                             REFERENCES dbo.Roles
go


ALTER TABLE dbo.OperatorRoles
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES dbo.PrintTypes
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.Operators
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.OrgAccountTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.OrgAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.Organizations
       ADD FOREIGN KEY (CurrencyID)
                             REFERENCES dbo.Currencies
go


ALTER TABLE dbo.Organizations
       ADD FOREIGN KEY (ResellerCustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.OrgPackageTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
go


ALTER TABLE dbo.OrgPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.PackageAccountTypes
       ADD FOREIGN KEY (NonPkgDiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.PackageAccountTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.PackageAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES dbo.Operators
go


ALTER TABLE dbo.Packages
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES dbo.CancelReasons
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES dbo.BillingCycles
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES dbo.TaxGroups
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (NextID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES dbo.SendMethods
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (PrimaryAccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.PackageTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES dbo.Charges
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES dbo.Payments
go


ALTER TABLE dbo.PaymentItems
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES dbo.PaymentTypes
go


ALTER TABLE dbo.Payments
       ADD FOREIGN KEY (StatementID)
                             REFERENCES dbo.Statements
go


ALTER TABLE dbo.PaymentTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (PeriodTypeID)
                             REFERENCES dbo.PeriodTypes
go


ALTER TABLE dbo.PayPeriods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.RadATConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadATConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadAttributes
       ADD FOREIGN KEY (RadVendorID)
                             REFERENCES dbo.RadVendors
go


ALTER TABLE dbo.RadConcurrency
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.RadConcurrency
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadConfigs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RadConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadFilterGroups
       ADD FOREIGN KEY (RadDestTypeID)
                             REFERENCES dbo.RadDestTypes
go


ALTER TABLE dbo.RadFilterGroups
       ADD FOREIGN KEY (RadSourceTypeID)
                             REFERENCES dbo.RadSourceTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadFilterGroupID)
                             REFERENCES dbo.RadFilterGroups
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadFilterTypeID)
                             REFERENCES dbo.RadFilterTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES dbo.RadMergeTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadSearchTypeID)
                             REFERENCES dbo.RadSearchTypes
go


ALTER TABLE dbo.RadFilters
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadIPAccountTypes
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES dbo.RadIPGroups
go


ALTER TABLE dbo.RadIPAccountTypes
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups
go


ALTER TABLE dbo.RadIPAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadIPAddresses
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RadIPAddresses
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES dbo.RadIPGroups
go


ALTER TABLE dbo.RadLogs
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES dbo.RadLogMsgs
go


ALTER TABLE dbo.RadMapValues
       ADD FOREIGN KEY (MapAttribute, RadMapTypeID)
                             REFERENCES dbo.RadMapAttributes
go


ALTER TABLE dbo.RadProxyAttributes
       ADD FOREIGN KEY (RadProxyAttributeGroupID)
                             REFERENCES dbo.RadProxyAttributeGroups
go


ALTER TABLE dbo.RadProxyAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES dbo.RadLogMsgs
go


ALTER TABLE dbo.RadRejects
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes
go


ALTER TABLE dbo.RadRoamDomains
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES dbo.RadRoamServers
go


ALTER TABLE dbo.RadRoamDomains
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.RadTriggers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.RateDataSources
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateIntervals
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES dbo.RateRuleTypes
go


ALTER TABLE dbo.RateItems
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES dbo.RateTimeGroups
go


ALTER TABLE dbo.RateItems
       ADD FOREIGN KEY (RateID)
                             REFERENCES dbo.Rates
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateRoundTypeID)
                             REFERENCES dbo.RateRoundTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateTypeID)
                             REFERENCES dbo.RateTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES dbo.RateRuleTypes
go


ALTER TABLE dbo.RateRules
       ADD FOREIGN KEY (Interval)
                             REFERENCES dbo.RateIntervals
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (ClassifierRateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (DataRateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES dbo.RateClasses
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.Rates
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.RateStdGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateStdGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateStdItems
       ADD FOREIGN KEY (RateStdGroupID)
                             REFERENCES dbo.RateStdGroups
go


ALTER TABLE dbo.RateStdItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateTimes
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES dbo.RateTimeGroups
go


ALTER TABLE dbo.RateTimes
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateTypes
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups
go


ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVDNISGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS
go


ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups
go


ALTER TABLE dbo.ReferredBys
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Regions
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.Regions
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.ReportGroups
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES dbo.OperatorGroups
go


ALTER TABLE dbo.ReportParameters
       ADD FOREIGN KEY (ReportFieldID)
                             REFERENCES dbo.ReportFields
go


ALTER TABLE dbo.Reports
       ADD FOREIGN KEY (ReportGroupID)
                             REFERENCES dbo.ReportGroups
go


ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (PackageID)
                             REFERENCES dbo.Packages
go


ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ResellerUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.Roles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES dbo.CommissionGroups
go


ALTER TABLE dbo.SalesPersons
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.Schedules
       ADD FOREIGN KEY (Server)
                             REFERENCES dbo.ScheduleServers
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES dbo.PrintTypes
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.SendMethods
       ADD FOREIGN KEY (EmailTypeID)
                             REFERENCES dbo.EmailTypes
go


ALTER TABLE dbo.ServerAccess
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.ServerAccess
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.ServerHistory
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.ServerPorts
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES dbo.ServerGroups
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (ServerType)
                             REFERENCES dbo.ServerTypes
go


ALTER TABLE dbo.Servers
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES dbo.RadRoamServers
go


ALTER TABLE dbo.ServiceGroupItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.ServiceGroupItems
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES dbo.ServiceGroups
go


ALTER TABLE dbo.SignupPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.SignupPackageTypes
       ADD FOREIGN KEY (SignupServerID)
                             REFERENCES dbo.SignupServers
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES dbo.AddressTypes
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (GroupID)
                             REFERENCES dbo.Groups
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.SignupServers
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (BatchID)
                             REFERENCES dbo.Batches
go


ALTER TABLE dbo.Statements
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.States
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.Strings
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES dbo.Languages
go


ALTER TABLE dbo.Strings
       ADD FOREIGN KEY (ApplicationID)
                             REFERENCES dbo.Applications
go


ALTER TABLE dbo.SubAccountData
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.SubAccountData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SubAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES dbo.AccountDataTypes
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES dbo.PayPeriods
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (LastInvoiceID)
                             REFERENCES dbo.Invoices
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (PackageID)
                             REFERENCES dbo.Packages
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES dbo.SalesPersons
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES dbo.MasterAccounts
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (DomainID)
                             REFERENCES dbo.Domains
go


ALTER TABLE dbo.SubAccounts
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES dbo.Discounts
go


ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
go


ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES dbo.TaxTypes
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES dbo.GLCodes
go


ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxPiggyBackID)
                             REFERENCES dbo.TaxPiggyBacks
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES dbo.Regions
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (TaxID)
                             REFERENCES dbo.Taxes
go


ALTER TABLE dbo.TaxGroupTaxes
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States
go


ALTER TABLE dbo.ThemeFilters
       ADD FOREIGN KEY (ThemeMatchTypeID)
                             REFERENCES dbo.ThemeMatchTypes
go


ALTER TABLE dbo.ThemeFilters
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES dbo.Themes
go


ALTER TABLE dbo.TimeCharges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES dbo.ChargeTypes
go


ALTER TABLE dbo.TimeCharges
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
go


ALTER TABLE dbo.TimeCharges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES dbo.AccountTypes
go

