#!/usr/bin/perl

$emerwebini = '/usr/local/emerald/emerweb.ini';
$scheduleini = '/usr/local/emerald/schedule.ini';
$commonini = '/usr/local/iea/common.ini';

&fix_emerweb;
if (-e $scheduleini)
	{
	&fix_schedule;
	}
&fix_common;

sub fix_schedule
{
open(DATA,$scheduleini) || die "Can't open $scheduleini for read $!";
@data = <DATA>;
close(DATA);

foreach(@data)
	{
	s/\r|\n//g;
	if (/^TaskDir=/i)
		{
		$have_taskdir = 1;
		}
	if (/^TaskLibs=/i)
		{
		$_ = "";
		}
	}

if (!$have_taskdir)
	{
	push(@data,'TaskDir=/usr/local/emerald');
	}

push(@data,'TaskLibs=gbe.so');

open(DATA,">$scheduleini") || die "Can't open $emerwebini for write $!";
foreach(@data)
	{
	if ($_ ne "")
		{
		print DATA "$_\n";
		}
	}
close(DATA);
}

sub fix_emerweb
{
open(DATA,$emerwebini) || die "Can't open $emerwebini for read $!";
@data = <DATA>;
close(DATA);

foreach(@data)
	{
	s/\r|\n//g;
	s/^SQLDir=.*//gi;
	s/^PackageDirectory=.*//gi;
	s/^ServerRoot=.*//gi;
	if (/^dll=/i)
		{
		$have_dll = 1;
		}
	if (/^execdlls=/i)
		{
		$have_exec = 1;
		}
	if (/^serverroot=/i)
		{
		$have_sroot = 1;
		}
	if (/^HeightmapDirectory=/i)
		{
		$have_heightmap = 1;
		}
	if (/^MIBDirectory=/i)
		{
		$have_mib = 1;
		}
	}

push(@data,'SQLDir=/usr/local/emerald/sql');
push(@data,'PackageDirectory=/usr/local/emerald/web/package');
if (!$have_dll)
	{
	push(@data,'dll=/usr/local/emerald/web/emerweb.so');
	}
if (!$have_exec)
	{
	push(@data,'ExecDlls=/usr/local/emerald/gbe.so');
	}
if (!$have_sroot)
	{
	push(@data,'ServerRoot=/usr/local/emerald/web');
	}
if (!$have_heightmap)
	{
	push(@data,'HeightmapDirectory=/usr/local/emerald/heightmaps');
	}
if (!$have_mib)
	{
	push(@data,'MIBDirectory=/usr/local/emerald/mibs');
	}

open(DATA,">$emerwebini") || die "Can't open $emerwebini for write $!";
foreach(@data)
	{
	if ($_ ne "")
		{
		print DATA "$_\n";
		}
	}
close(DATA);
}

sub fix_common
{
if (-e $commonini)
	{
	open(DATA,$commonini) || die "Can't open $commonini for read $!";
	@data = <DATA>;
	close(DATA);

	foreach(@data)
		{
		s/\r|\n//g;
		if (/^capath=/i)
			{
			$have_capath = 1;
			}
		}

	if ($have_capath != 1)
		{
		open(DATA,">>$commonini") || die "Can't open $commonini for append $!";
		print DATA "\nCAPath=/usr/local/emerald/cacerts\n";
		close(DATA);
		}
	}
else
	{
	open(DATA,">$commonini") || die "Can't open $commonini for write $!";
	print DATA "[]\nCAPath=/usr/local/emerald/cacerts\n";
	close(DATA);
	}
}


