#!/usr/bin/perl
# PortalShell is copyright (c) 2007-2013 IEA Software, Inc. - All rights reserved world wide
# This script may not be used for any purpose other than Air Marshal

$portaldir = '/usr/local/portal';
$portalini = "$portaldir/portal.ini";
$gardenfile = "$portaldir/gardens.dat";
$keyfile = "$portaldir/shellkey.dat";

&parseini($portalini,'ini');
&parsekeys($keyfile);

@arglist = @ARGV;

foreach $arg (@arglist)
{
&parsearg($arg,'vars');
$action = $vars{action};

if ($ini{InetIF} !~ /\w/)
	{
	$ini{InetIF} = 'eth0';
	}

if ($action =~ /\w/)
	{
	if ($action eq 'startup')
		{
		&runcmd('startupenv','');
		if ($ini{Routing} eq '2')
			{
			&runcmd('startupenvnat','');
			$execcmd = 'startupnat';
			}
		else
			{
			$execcmd = 'startupstatic';	
			}

		foreach(split(/\s+/,$ini{Networks}))
			{
			undef %tmp;
			$tmp{ptlnet} = $_;
			&runcmd($execcmd,'tmp');
			}

		if ($ini{Routing} eq '3')
			{
			$ini{Interfaces} = 'portalbr';
			$brnetif = $ini{BridgeNetIF};
			$brclientif = $ini{BridgeClientIF};
			$brip = $ini{BridgeIP};
			$brnet = $ini{BridgeNetmask};
			$brdefault = $ini{BridgeDefaultRoute};

			if (!($brnetif =~ /\w/ && $brclientif =~ /\w/))
				{
				die "Bridge network and client interfaces missing";
				}
			if ($brip !~ /\d+\.\d+\.\d+\.\d+/g)
				{
				die "Local IP address on bridge is missing or invalid";
				}
			if ($brnet !~ /\d+\.\d+\.\d+\.\d+/g)
				{
				die "Local IP subnet mask on bridge is missing or invalid";
				}
			if ($brdefault !~ /\d+\.\d+\.\d+\.\d+/g)
				{
				die "Local IP default route on bridge is missing or invalid";
				}

			&runcmd('startupbrinit','');
			foreach(split(/\s+/,$brnetif))
				{
				undef %tmp;
				$tmp{interface} = $_;
				&runcmd('startupbrif','tmp');
				}
			foreach(split(/\s+/,$brclientif))
				{
				undef %tmp;
				$tmp{interface} = $_;
				&runcmd('startupbrif','tmp');
				}
			&runcmd('startupbrip','ini');
			}

		undef %dupe;
		foreach(split(/\s+/,$ini{Interfaces}))
			{
			undef %tmp;
			$tmp{interface} = $_;
			$tmp{inetinterface} = $ini{InetIF};
			$tmp{interface} =~ s/^\s*eth(\d+)\.\d+\s*$/eth$1/i;
			if (!$dupe{$tmp{interface}})
				{
				&runcmd('startupif','tmp');
				}
			$dupe{$tmp{interface}} = 1;
			}
		foreach $dns (split(/\s+/,$ini{DNSServers}))
			{
			foreach $net (split(/\s+/,$ini{Networks}))
				{
				undef %tmp;
				$tmp{ptlnet} = $net;
				$tmp{dnsserver} = $dns;
				&runcmd('startupdns','tmp');
				}
			}

		if (!$ini{DNSServers})
			{
			foreach $net (split(/\s+/,$ini{Networks}))
				{
				undef %tmp;
				$tmp{ptlnet} = $net;
				$tmp{dnsserver} = '0.0.0.0/0';
				&runcmd('startupdns','tmp');
				}
			}

		foreach $net (split(/\s+/,$ini{Networks}))
			{
			undef %tmp;
			$tmp{ptlnet} = $net;
			if (($ini{PreAuthTCPPort} > 0 || $ini{PreAuthUDPPort} > 0) && $ini{EnablePreAuth} == 1)
				{
				&runcmd('startuplredir','tmp');
				}
			else
				{
				&runcmd('startupredir','tmp');
				}
			}

		if ($ini{PreAuthTCPPort} > 0 && $ini{EnablePreAuth} == 1)
			{
			undef %tmp;
			$tmp{tcpport} = $ini{PreAuthTCPPort};
			&runcmd('startuptcpfin','tmp');
			}

		if ($ini{PreAuthUDPPort} > 0 && $ini{EnablePreAuth} == 1)
			{
			undef %tmp;
			$tmp{udpport} = $ini{PreAuthUDPPort};
			&runcmd('startupudpfin','tmp');
			}

		undef %tmp;
		if (!$ini{Port})
			{
			$tmp{port} = 81;
			}
		else
			{
			$tmp{port} = $ini{Port};
			}

		&runcmd('startupredirfin','tmp');
		&garden;

		if ($ini{IPExceptions} =~ /\d/)
			{
			foreach(split(/\s+/,$ini{IPExceptions}))
				{
				undef %tmp;
				$tmp{ip} = $_;
				&runcmd('sesopen','tmp');
				}
			}

		}
	elsif ($action eq 'groupbw' || $action eq 'groupbwup')
		{
		undef %dupe;
		foreach(split(/\s+/,$ini{Interfaces}))
			{
			undef %tmp;
			$tmp{interface} = $_;
			$tmp{inetinterface} = $ini{InetIF};
			$tmp{parent} = $vars{parent};
			$tmp{handle} = $vars{handle};
			$tmp{speedin} = $vars{speedin};
			$tmp{speedout} = $vars{speedout};

			$tmp{interface} =~ s/^\s*eth(\d+)\.\d+\s*$/eth$1/i;
			if (!$dupe{$tmp{interface}})
				{
				&runcmd($action,'tmp');
				}	
			$dupe{$tmp{interface}} = 1;
			}
		}
	elsif ($action eq 'sesopenbw')
		{
		$vars{interface} =~ s/^\s*eth(\d+)\.\d+\s*$/eth$1/i;
		&runcmd($action,'vars');
		}
	elsif ($action eq 'nostartup')
		{
		}
	elsif ($action eq 'garden')
		{
		&garden;
		}
	elsif ($action eq 'nogarden')
		{
		&nogarden;
		}
	elsif ($action eq 'sesint' || $action eq 'nosesint')
		{
		undef %tmp;
		$tmp{ip} = $vars{ip};
		if (!$ini{Port})
			{
			$tmp{port} = 81;
			}
		else
			{
			$tmp{port} = $ini{Port};
			}
		&runcmd($action,'tmp');
		}
	else
		{
		&runcmd($action,'vars');
		}
	}
}

sub garden
{
my $no = $_[0];
if ($no ne 'no')
	{
	$no = '';
	}

if ($havegarden == 0)
	{
	&parsegarden($gardenfile,'garden');
	$havegarden = 1;
	}

foreach $key (keys(%garden))
	{
	$addr = $garden{$key}->{'addr'};
	$prot = $garden{$key}->{'prot'};
	$port = $garden{$key}->{'port'};
	$active = $garden{$key}->{'active'};
	if ($active eq '1' && $addr =~ /\w/ && $addr =~ /\./)
		{
		foreach(split(/\s+/,$ini{Networks}))
			{
			undef %tmp;
			$tmp{ptlnet} = $_;
			$tmp{dest} = $addr;
			if (!$port || $port eq '0' || $port > 65535 || $port < 1)
				{
				&runcmd($no.'gardenall','tmp');
				}
			if ($port eq '80')
				{
				&runcmd($no.'gardenweb','tmp');
				}
			else
				{
				$tmp{destport} = $port;
				&runcmd($no.'gardenport','tmp');
				}
			}
		}
	}
}

sub nogarden
{
&garden('no');
}

sub runcmd
{
my $aname = "key$_[0]";
my $var = $_[1];
my $fail, $rc, $out;

foreach $cmd (@$aname)
	{
	$cmdcopy = $cmd;
	if ($var =~ /\w/)
		{
		$cmdcopy =~ s/\$(\w+)/$$var{$1}/g;
		}
	if ($cmdcopy =~ /^\s*canfail/i)
		{
		$fail = 1;
		$cmdcopy =~ s/^\s*canfail\s*//gi;
		}
	else
		{
		$fail = 0;
		}

	for (;;)
		{
		$out = qx($cmdcopy);
		$rc = $?;
		if ($rc == 0 || $out !~ /resource temporarily unavailable/i)
			{
			last;
			}
		else
			{
			sleep(1);
			}
		}
	if ($fail == 0 && $rc != 0)
		{
		die "command execution: $cmdcopy failed: $rc ($out)";
		}
	}
}

sub parsearg
{
my $argdata = $_[0];
my $var = $_[1];
my $avp, $key, $value;
undef %$var;
foreach (split(/\s+/,$argdata))
	{
	if (/([\w\-]+)\s*\=\s*(.*)$/)
		{
		$key = $1;
		$value = $2;
		$value =~ s/[^\w\.\-\/]//g;
		$$var{$key} = $value;
		}
	}
}

sub parsekeys
{
my $file = $_[0];
open(DATA,$file) || die "Can't open $file for read $!";
while(<DATA>)
	{
	s/\r|\n//g;
	if (/\s*(\w+)\s+(.*)$/)
		{
		$aname = "key$1";
		push(@$aname,$2);
		}
	}
close(DATA);
}

sub parsegarden
{
# addr, prot, port, active

my $file = $_[0];
my $gardenlist = $_[1];
my @data;

if (-e $file)
	{
	open(DATA,$file) || die "Can't open $file for read $!";
	while(<DATA>)
		{
		s/\r|\n//g;
		@data = split(/\t/,$_);
		$$gardenlist{$data[0]}->{'addr'} = $data[1];
		$$gardenlist{$data[0]}->{'prot'} = $data[2];
		$$gardenlist{$data[0]}->{'port'} = $data[3];
		$$gardenlist{$data[0]}->{'active'} = $data[5];
		}
	close(DATA);
	}
}

sub parseini
{
my $file = $_[0];
my $iniarray = $_[1];

if (!$iniarray)
	{
	die "iniarray must be defined";
	}

open(DATA,$file) || die "Can't open $file for read $!";
while(<DATA>)
	{
	s/\r|\n//g;
	if (/([\w\-]+)\s*=\s*(.*)$/)
		{
		$$iniarray{$1} = $2;
		}
	}
close(DATA);
}

