IF (object_id('dbo.ExternalSyncs') IS NULL)
BEGIN
CREATE TABLE dbo.ExternalSyncs (
	ExternalSyncID int IDENTITY,
	ExternalSystemID int NOT NULL,
	AccountID int NOT NULL,
	ProcTransID varchar (64) NULL,
	Login varchar (128) NULL,
	Password varchar (128) NULL,
	Aux1 varchar (128) NULL,
	Aux2 varchar (128) NULL,
	Aux3 varchar (128) NULL,
	Active smallint NOT NULL DEFAULT 0,
	Created smallint NOT NULL DEFAULT 0,
	CreateDate datetime NOT NULL DEFAULT getdate(),
	LastUpdate datetime NULL,
	LastModifyDate datetime NOT NULL DEFAULT getdate(),
	ErrorCount int NOT NULL DEFAULT 0,
	Message varchar (128) NULL 
)

ALTER TABLE dbo.ExternalSyncs
	ADD PRIMARY KEY (ExternalSyncID)

ALTER TABLE dbo.ExternalSyncs
	ADD FOREIGN KEY (ExternalSystemID)
		REFERENCES dbo.ExternalSystems


ALTER TABLE dbo.ExternalSyncs
	ADD FOREIGN KEY (AccountID)
		REFERENCES dbo.SubAccounts
END
GO

IF (object_id('dbo.RateVRates') IS NULL)
BEGIN
CREATE TABLE dbo.RateVCondGroups (
       RateVCondGroupID     int IDENTITY(1, 1),
       RateVCondGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Priority             smallint NULL
)

ALTER TABLE dbo.RateVCondGroups
       ADD PRIMARY KEY (RateVCondGroupID)

CREATE TABLE dbo.RateVCondItems (
       RateVCondItemID      int IDENTITY(1, 1),
       RateVCondGroupID     int NOT NULL,
       Attribute            varchar(64) NOT NULL,
       RateMatchTypeID      int NOT NULL,
       Data                 varchar(255) NOT NULL
)

ALTER TABLE dbo.RateVCondItems
       ADD PRIMARY KEY (RateVCondItemID)

CREATE TABLE dbo.RateVDNIS (
       RateVDNISID          int IDENTITY(1, 1),
       RateVDNIS            varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       RateRuleID           int NULL,
       Attribute            varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0,
       Description          varchar(255) NULL
)

ALTER TABLE dbo.RateVDNIS
       ADD PRIMARY KEY (RateVDNISID)

CREATE TABLE dbo.RateVDNISGroupItems (
       RateVDNISGroupID     int NOT NULL,
       RateVDNISID          int NOT NULL,
       RateVCondGroupID     int NULL
)

ALTER TABLE dbo.RateVDNISGroupItems
       ADD PRIMARY KEY (RateVDNISGroupID, RateVDNISID)

CREATE TABLE dbo.RateVDNISGroups (
       RateVDNISGroupID     int IDENTITY(1, 1),
       RateVDNISGroup       varchar(128) NOT NULL,
       RateSourceID         int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

ALTER TABLE dbo.RateVDNISGroups
       ADD PRIMARY KEY (RateVDNISGroupID)

CREATE TABLE dbo.RateVDNISItems (
       RateVDNISItemID      int IDENTITY(1, 1),
       RateVDNISID          int NOT NULL,
       RateVDNISItem        varchar(128) NULL,
       DNIS                 varchar(64) NOT NULL,
       Location             varchar(128) NULL,
       RateMatchTypeID      int NOT NULL,
       IntervalCost         numeric(18,4) NULL,
       IntervalOption       smallint NOT NULL DEFAULT 0,
       InitialCost          numeric(18,4) NULL,
       InitialOption        smallint NOT NULL DEFAULT 0,
       StaticCost           numeric(18,4) NULL,
       StaticOption         smallint NOT NULL DEFAULT 0,
       CountryID            int NULL,
       StateID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT 0
)

CREATE INDEX i_RVDI_DNIS ON dbo.RateVDNISItems
(
       DNIS
)

ALTER TABLE dbo.RateVDNISItems
       ADD PRIMARY KEY (RateVDNISItemID)

CREATE TABLE dbo.RateVRates (
       RateVRateID          int IDENTITY(1, 1),
       RateVRate            varchar(128) NULL,
       RateRuleID           int NOT NULL,
       Active               smallint NOT NULL DEFAULT 1,
       RateVDNISID          int NULL,
       RateVDNISGroupID     int NULL,
       RateVCondGroupID     int NULL,
       Multiplier           numeric(18,4) NULL
)

ALTER TABLE dbo.RateVRates
       ADD PRIMARY KEY (RateVRateID)

ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES dbo.Priorities

ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules

ALTER TABLE dbo.RateVCondGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources

ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes

ALTER TABLE dbo.RateVCondItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups

ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules

ALTER TABLE dbo.RateVDNIS
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources

ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS

ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups

ALTER TABLE dbo.RateVDNISGroupItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups

ALTER TABLE dbo.RateVDNISGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES dbo.RateSources

ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (CountryID)
                             REFERENCES dbo.Countries

ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES dbo.RateMatchTypes

ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS

ALTER TABLE dbo.RateVDNISItems
       ADD FOREIGN KEY (StateID)
                             REFERENCES dbo.States

ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES dbo.RateRules

ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES dbo.RateVCondGroups

ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES dbo.RateVDNIS

ALTER TABLE dbo.RateVRates
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES dbo.RateVDNISGroups
END
GO

IF (object_id('dbo.RadRejectAttributes') IS NULL)
BEGIN
CREATE TABLE dbo.RadRejectAttributes (
       RadRejectAttributeID int IDENTITY,
       IEAID                int NULL,
       ServerID             int NULL,
       RadLogMsgID          int NOT NULL,
       RadVendorID          int NOT NULL,
       RadAttributeID       int NOT NULL,
       Data                 varchar(255) NOT NULL
)

ALTER TABLE dbo.RadRejectAttributes
       ADD PRIMARY KEY (RadRejectAttributeID)

ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (ServerID)
                             REFERENCES dbo.Servers

ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES dbo.RadAttributes

ALTER TABLE dbo.RadRejectAttributes
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES dbo.RadLogMsgs
END
GO

IF (object_id('dbo.SubAccountUsages') IS NULL)
BEGIN
CREATE TABLE dbo.SubAccountUsages (
       SubAccountUsageID    int IDENTITY,
       AccountID            int NOT NULL,
       ExpireDate           datetime NOT NULL,
       TimeLeft             int NULL,
       DataLeft             bigint NULL,
       ItemID               int NULL,
       StartTimeLeft        int NULL,
       StartDataLeft        bigint NULL
)

CREATE INDEX IX_SAU_AIDEXPTLDL ON dbo.SubAccountUsages
(
       AccountID,
       ExpireDate,
       TimeLeft,
       DataLeft
)

CREATE INDEX IX_SAU_ItemID ON dbo.SubAccountUsages
(
       ItemID
)

ALTER TABLE dbo.SubAccountUsages
       ADD PRIMARY KEY (SubAccountUsageID)

ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems

ALTER TABLE dbo.SubAccountUsages
       ADD FOREIGN KEY (AccountID)
                             REFERENCES dbo.SubAccounts
END
GO

ALTER TABLE dbo.Taxes ADD TaxTypeID INT
GO

IF (object_id('dbo.TaxTypes') IS NULL)
BEGIN
CREATE TABLE dbo.TaxTypes (
       TaxTypeID            int IDENTITY,
       TaxType              varchar(64) NOT NULL
)

ALTER TABLE dbo.TaxTypes
       ADD PRIMARY KEY (TaxTypeID)

ALTER TABLE dbo.Taxes
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES dbo.TaxTypes
END
GO

IF (object_id('dbo.ResellerPkgUsage') IS NULL)
BEGIN
CREATE TABLE dbo.ResellerPkgUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       PackageID            int NOT NULL,
       PackageTypeID        int NOT NULL,
       Days                 float NOT NULL DEFAULT (0),
       LastUpdate           datetime NOT NULL DEFAULT (getdate()),
       ItemID               int NULL
)
CREATE INDEX i_ResellerPkgUsage_PackageID ON dbo.ResellerPkgUsage
(
       PackageID,
       StartYear,
       StartMonth
)
ALTER TABLE dbo.ResellerPkgUsage
       ADD PRIMARY KEY (StartYear, StartMonth, PackageID, 
              PackageTypeID)
ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES dbo.InvoiceItems
ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (PackageID)
                             REFERENCES dbo.Packages
ALTER TABLE dbo.ResellerPkgUsage
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
END
GO

IF (object_id('dbo.OrgPackageTypes') IS NULL)
BEGIN
CREATE TABLE dbo.OrgPackageTypes (
       OrganizationID       int NOT NULL,
       PackageTypeID        int NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             varchar(128) NULL
)
ALTER TABLE dbo.OrgPackageTypes
       ADD PRIMARY KEY (OrganizationID, PackageTypeID)
ALTER TABLE dbo.OrgPackageTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES dbo.Organizations
ALTER TABLE dbo.OrgPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes
END
GO

IF (object_id('dbo.VoiceCalls') IS NULL)
BEGIN
CREATE TABLE dbo.VoiceCalls (
       VoiceCallID          bigint IDENTITY(1, 1),
       AccountID            int NULL,
       CallDate             datetime NOT NULL,
       Login                varchar(64) NOT NULL,
       Duration             int NOT NULL,
       SessionRef           varchar(64) NULL,
       CalledNumber         varchar(64) NULL,
       CallingPort          varchar(32) NULL,
       CalledPort           varchar(32) NULL,
       Bytes                bigint NULL,
       CallType             varchar(64) NULL,
       AcctTerminateCause   smallint NULL,
       CountryID            int NULL,
       StateID              int NULL,
       Location             varchar(64) NULL,
       ChargeID             int NULL,
       ProcDate             datetime NULL,
       ErrorCode            smallint NULL,
       Cost                 numeric(18,4) NULL
)
CREATE UNIQUE INDEX i_VoiceCalls_Unique ON dbo.VoiceCalls
(
       CallDate,
       Login,
       Duration,
       SessionRef,
       CalledNumber
)
CREATE INDEX i_VoiceCalls_AID_CD ON dbo.VoiceCalls
(
       AccountID,
       CallDate
)
CREATE INDEX i_VoiceCalls_C_PD ON dbo.VoiceCalls
(
       ChargeID,
       ProcDate
)
ALTER TABLE dbo.VoiceCalls
       ADD PRIMARY KEY (VoiceCallID)
END
GO

CREATE INDEX i_MBR_PhoneHome ON dbo.MasterAccounts (PhoneHome)
GO
CREATE INDEX i_MBR_PhoneWork ON dbo.MasterAccounts (PhoneWork)
GO
CREATE INDEX i_PMT_StatementID ON dbo.Payments (StatementID)
GO
CREATE INDEX i_PMT_FinalStatementID ON dbo.Payments (FinalStatementID)
GO


ALTER TABLE dbo.AccountTypes ADD DataLeft BIGINT
GO
ALTER TABLE dbo.CardBatches ADD DataLeft BIGINT
GO
ALTER TABLE dbo.CardBatchTypes ADD DataLeft BIGINT
GO
ALTER TABLE dbo.SubAccounts ADD DataLeft BIGINT
GO
ALTER TABLE dbo.TimeCharges ADD DataLeft BIGINT
GO
ALTER TABLE dbo.ExternalSystemTypes ADD ExportID INT
GO
ALTER TABLE dbo.Domains ADD ServiceGroupID INT
GO
ALTER TABLE dbo.Domains ADD ExternalRef VARCHAR(64)
GO
ALTER TABLE dbo.ExternalSystems ADD Aux1 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSystems ADD Aux2 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSystems ADD Aux3 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSystemTypes ADD DescAux1 VARCHAR(64)
GO
ALTER TABLE dbo.ExternalSystemTypes ADD DescAux2 VARCHAR(64)
GO
ALTER TABLE dbo.ExternalSystemTypes ADD DescAux3 VARCHAR(64)
GO
ALTER TABLE dbo.Servers ADD DisconnectType INT
GO
ALTER TABLE dbo.RateDataSources ADD BillingMode INT
GO
ALTER TABLE dbo.Countries ADD ZipStatus SMALLINT
GO
ALTER TABLE dbo.Groups ADD PrintInvoices SMALLINT
GO
ALTER TABLE dbo.Groups ADD PrintStatements SMALLINT
GO
ALTER TABLE dbo.PackageTypes ADD InvoiceDescription VARCHAR(64)
GO
ALTER TABLE dbo.PackageTypes ADD CustomerStringID INT
GO
ALTER TABLE dbo.ExternalSystemAccountTypes ADD ExternalRef VARCHAR(64) 
GO
ALTER TABLE dbo.Exports ADD StageCount INT
GO
ALTER TABLE dbo.TaxGroupTaxes ADD City VARCHAR(45)
GO
ALTER TABLE dbo.TaxGroupTaxes ADD Zip VARCHAR(15)
GO
ALTER TABLE dbo.BatchProcessors ALTER COLUMN OrganizationID INT NULL
GO
ALTER TABLE dbo.InvoiceItems ADD ParentItemID INT
GO
ALTER TABLE dbo.RateDataSources ADD ClearQuery TEXT
GO
ALTER TABLE dbo.Charges ADD PrevChargeID INT
GO
ALTER TABLE dbo.SignupServers ADD AddressTypeID INT
GO
ALTER TABLE dbo.SignupServers ADD AddressDescription VARCHAR(128)
GO
ALTER TABLE dbo.Payments ALTER COLUMN ProcTransID VARCHAR(64)
GO
ALTER TABLE dbo.ExternalTrans ALTER COLUMN ProcTransID VARCHAR(64)
GO

ALTER TABLE dbo.MasterAccountDataTypes ADD Required SMALLINT
GO
ALTER TABLE dbo.SubAccountDataTypes ADD Required SMALLINT
GO
ALTER TABLE dbo.IncidentDataTypes ADD Required SMALLINT
GO
ALTER TABLE dbo.IncidentDataTypes ADD RegExp VARCHAR(255)
GO
ALTER TABLE dbo.IncidentDataTypes ADD SQLQuery TEXT
GO
ALTER TABLE dbo.AccountDataTypes ADD RegExp VARCHAR(255)
GO
ALTER TABLE dbo.ExternalSystemDataTypes ADD Required SMALLINT
GO
ALTER TABLE dbo.IncidentStates ADD ActionOnly SMALLINT
GO
ALTER TABLE dbo.SignupServers ADD Title VARCHAR(128)
GO
ALTER TABLE dbo.MasterAccountDataTypes ADD ServiceGroupID INT
GO
ALTER TABLE dbo.AccountTypes ADD SecChargeTypeID INT
GO
ALTER TABLE dbo.PackageTypes ADD SecChargeTypeID INT
GO
ALTER TABLE dbo.Domains ADD CustomerID INT
GO
CREATE INDEX i_Domains_CustomerID ON dbo.Domains (CustomerID)
GO
ALTER TABLE dbo.Domains ADD CustomerAccess SMALLINT
GO
ALTER TABLE dbo.PackageAccountTypes ADD AllowCustSetDomain SMALLINT
GO
CREATE INDEX i_SA_PhoneHome ON dbo.SubAccounts (PhoneHome)
GO
CREATE INDEX i_SA_PhoneWork ON dbo.SubAccounts (PhoneWork)
GO
CREATE INDEX i_MBR_PhoneFax ON dbo.MasterAccounts (PhoneFax)
GO
CREATE INDEX i_Packages_LMD ON dbo.Packages (LastModifyDate)
GO
CREATE INDEX i_SubAccounts_LMD ON dbo.SubAccounts (LastModifyDate)
GO
ALTER TABLE dbo.RadIPAccountTypes ADD AssignType SMALLINT
GO
ALTER TABLE dbo.RadIPAddresses ADD AccountID INT
GO
CREATE INDEX I_RadIPAddress_AID ON dbo.RadIPAddresses (AccountID)
GO
ALTER TABLE dbo.AccountTypes ADD AccountTemplateID INT
GO

IF (object_id('dbo.AccountTemplates') IS NULL)
BEGIN
CREATE TABLE dbo.AccountTemplates (
       AccountTemplateID    int NOT NULL,
       AccountTemplate      varchar(128) NOT NULL,
       LoginLabel           varchar(128) NULL,
       LoginStringID        int NULL,
       SANew                varchar(64) NULL,
       SAEdit               varchar(64) NULL,
       SASave               varchar(64) NULL,
       SADetail             varchar(64) NULL,
       CustNew              varchar(64) NULL,
       CustEdit             varchar(64) NULL,
       CustEditLabel        varchar(128) NULL,
       CustEditStringID     int NULL,
       CustSave             varchar(64) NULL,
       SignupPage           varchar(64) NULL,
       SignupForm           varchar(64) NULL,
       SignupValidate       varchar(64) NULL,
       SignupSave           varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT (0)
)

ALTER TABLE dbo.AccountTemplates
       ADD PRIMARY KEY (AccountTemplateID)

ALTER TABLE dbo.AccountTypes
       ADD FOREIGN KEY (AccountTemplateID)
                             REFERENCES dbo.AccountTemplates
END
GO

ALTER TABLE dbo.Domains ADD ExpireDate DATETIME
GO
ALTER TABLE dbo.Domains ADD ExternalDNSRef VARCHAR(64)
GO
ALTER TABLE dbo.Domains ADD ErrorCount INT
GO
ALTER TABLE dbo.Domains ADD ErrorMessage VARCHAR(128)
GO
CREATE INDEX i_MetaColumns_MTID_MC ON dbo.MetaColumns (MetaTableID,ColumnName)
GO

ALTER TABLE dbo.IncidentDataTypes ADD IncidentTemplateID INT
GO
IF (object_id('dbo.IncidentTemplates') IS NULL)
BEGIN
CREATE TABLE dbo.IncidentTemplates (
       IncidentTemplateID   int NOT NULL,
       IncidentTemplate     varchar(128) NOT NULL,
       IncidentEdit         varchar(64) NULL,
       IncidentSave         varchar(64) NULL,
       CustIncidentEdit     varchar(64) NULL,
       CustIncidentSave     varchar(64) NULL,
       SortOrder            smallint NOT NULL DEFAULT (0)
)

ALTER TABLE dbo.IncidentTemplates
       ADD PRIMARY KEY (IncidentTemplateID)

ALTER TABLE dbo.IncidentDataTypes
       ADD FOREIGN KEY (IncidentTemplateID)
                             REFERENCES dbo.IncidentTemplates

END
GO

ALTER TABLE dbo.ExternalSyncs ADD Aux4 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSyncs ADD Aux5 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSyncs ADD Aux6 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSyncs ADD Aux7 VARCHAR(128)
GO
ALTER TABLE dbo.ExternalSyncs ADD Aux8 VARCHAR(768)
GO
ALTER TABLE dbo.Operators ADD DaySumIncident SMALLINT
GO


IF (object_id('dbo.SignupPackageTypes') IS NULL)
BEGIN
CREATE TABLE dbo.SignupPackageTypes (
       SignupPackageTypeID  int IDENTITY,
       SignupServerID       int NOT NULL,
       PackageTypeID        int NOT NULL
)

CREATE UNIQUE INDEX i_SPT_Signup_Package ON dbo.SignupPackageTypes
(
       SignupServerID,
       PackageTypeID
)

ALTER TABLE dbo.SignupPackageTypes
       ADD PRIMARY KEY (SignupPackageTypeID)

ALTER TABLE dbo.SignupPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES dbo.PackageTypes

ALTER TABLE dbo.SignupPackageTypes
       ADD FOREIGN KEY (SignupServerID)
                             REFERENCES dbo.SignupServers
END
GO

ALTER TABLE dbo.SignupServers ADD ShowLogin SMALLINT
GO
ALTER TABLE dbo.Roles ADD AssignStrategyID INT
GO
ALTER TABLE dbo.Operators ADD MeasureUnitID SMALLINT
GO
ALTER TABLE dbo.Batches ADD Rebatch SMALLINT
GO
ALTER TABLE dbo.AccountTypes ADD DataLeftRenewal SMALLINT
GO
ALTER TABLE dbo.AccountTypes ADD TimeLeftRenewal SMALLINT
GO
ALTER TABLE dbo.SubAccounts ADD LastDataLeftDate DATETIME
GO
ALTER TABLE dbo.AccountTemplates ADD SignupBillSave VARCHAR(64)
GO
ALTER TABLE dbo.MasterAccounts ADD TransHoldDate DATETIME
GO
ALTER TABLE dbo.BillingCycles ADD TBillDays INT
GO
ALTER TABLE dbo.SignupServers ADD PrepaidTransfer SMALLINT
GO
CREATE INDEX i_Operators_Email ON dbo.Operators (Email)
GO
ALTER TABLE dbo.AccountTypes ADD InactCanceledDays SMALLINT
GO
ALTER TABLE dbo.OperatorCookies ADD OperatorID INT
GO
ALTER TABLE dbo.OperatorCookies ADD AccountID INT
GO
ALTER TABLE dbo.CardBatches ADD ActiveExpireMins INT
GO
ALTER TABLE dbo.CardBatchTypes ADD ActiveExpireMins INT
GO
ALTER TABLE dbo.IncidentTypes ADD EnableOperatorRole SMALLINT
GO
ALTER TABLE dbo.SendMethods ADD CustomerAccess SMALLINT
GO
ALTER TABLE dbo.Invoices ADD ExtInvoiceNum VARCHAR(20)
GO
CREATE INDEX i_Invoices_ExtInvoiceNum ON dbo.Invoices (ExtInvoiceNum)
GO
ALTER TABLE dbo.MetaColumns ADD RegExp VARCHAR(255)
GO
ALTER TABLE dbo.MetaColumns ADD CheckQuery VARCHAR(255)
GO
CREATE INDEX i_Statements_CustomerID ON dbo.Statements (CustomerID)
GO
ALTER TABLE dbo.ServerPorts ALTER COLUMN ServerID INT NULL
GO
CREATE INDEX i_InvoiceItems_AID ON dbo.InvoiceItems (AccountID,InvoiceID)
GO


IF (SELECT COUNT(*) FROM sysindexes WHERE name = 'I_ES_AID_ESID') > 0
	DROP INDEX ExternalSyncs.I_ES_AID_ESID
GO
CREATE INDEX I2_ES_AID_ESID ON dbo.ExternalSyncs (AccountID,ExternalSystemID)
GO


UPDATE RadAttributes SET RadAttributeType = 6 WHERE RadAttributeID = 80 AND RadVendorID = 0 AND RadAttributeType <> 6
GO
UPDATE RadValues SET Name = 'GRE' WHERE Value = 10 AND RadAttributeID = 64 AND RadVendorID = 0 AND Name <> 'GRE'
GO
UPDATE RadAttributes SET RadAttributeType = 1, Name = 'Motorola-Canopy-VLAGETO' WHERE RadAttributeID = 20 AND RadVendorID = 161 AND RadAttributeType = 6
GO
UPDATE RadAttributes SET RadAttributeType = 20 WHERE RadAttributeID IN (1,28,29,35,37,38) AND RadVendorID = 24757 AND RadAttributeType = 6
GO
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-1' WHERE RadVendorID = 0 AND RadAttributeID = 241 AND RadAttributeType = 1
GO
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-2' WHERE RadVendorID = 0 AND RadAttributeID = 242 AND RadAttributeType = 4
GO
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-3' WHERE RadVendorID = 0 AND RadAttributeID = 243 AND RadAttributeType = 4
GO
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-4' WHERE RadVendorID = 0 AND RadAttributeID = 244 AND RadAttributeType = 1
GO
UPDATE RadAttributes SET RadAttributeType = 22, Name = 'Extended-Type-Flagged-1' WHERE RadVendorID = 0 AND RadAttributeID = 245 AND RadAttributeType = 1
GO
UPDATE RadAttributes SET RadAttributeType = 22, Name = 'Extended-Type-Flagged-2' WHERE RadVendorID = 0 AND RadAttributeID = 246 AND RadAttributeType = 1
GO

UPDATE RadAttributes SET RadAttributeType = 10, Name = 'Tunnel-Client-Auth-ID' WHERE RadVendorID = 0 AND RadAttributeID = 90 AND RadAttributeType = 0
GO
UPDATE RadAttributes SET RadAttributeType = 10, Name = 'Tunnel-Server-Auth-ID' WHERE RadVendorID = 0 AND RadAttributeID = 91 AND RadAttributeType = 0
GO
UPDATE RadAttributes SET RadAttributeType = 9, Name = 'Delegated-IPv6-Prefix' WHERE RadVendorID = 0 AND RadAttributeID = 123 AND RadAttributeType = 1
GO
UPDATE RadAttributes SET RadAttributeType = 5, Name = 'Framed-IPv6-Address' WHERE RadVendorID = 0 AND RadAttributeID = 168 AND RadAttributeType = 0
GO
UPDATE RadAttributes SET RadAttributeType = 0, Name = 'Stateful-IPv6-Address-Pool' WHERE RadVendorID = 0 AND RadAttributeID = 172 AND RadAttributeType = 1
GO
UPDATE RadAttributes SET RadAttributeType = 20, Name = 'IPv6-6rd-Configuration' WHERE RadVendorID = 0 AND RadAttributeID = 173 AND RadAttributeType = 1
GO

UPDATE RadAttributes SET RadAttributeType = 0 WHERE RadAttributeType <> 0 AND RadVendorID = 0 AND RadAttributeID BETWEEN 103 AND 122
GO
UPDATE RadAttributes SET RadAttributeType = 1 WHERE RadVendorID = 161 AND RadAttributeID IN (5,14,15,21,22,23,50)
GO

DELETE FROM RadVendors WHERE RadVendorID NOT IN (SELECT RadVendorID FROM RadAttributes)
GO
DELETE FROM RadValues WHERE RadVendorID = 0 AND RadAttributeID BETWEEN 224 AND 236
GO

UPDATE sa SET CancelDate = BilledThru
FROM MasterAccounts ma, SubAccounts sa, Configs c
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND c.ConfigID = 0
	AND c.NumValue < 5084
	AND sa.CancelDate = DATEADD(dd,1,sa.BilledThru)
GO

UPDATE p SET CancelDate = BilledThru
FROM MasterAccounts ma, Packages p, Configs c
	WHERE ma.CustomerID = p.CustomerID
	AND ma.Active = 1
	AND p.Active = 1
	AND c.ConfigID = 0
	AND c.NumValue < 5084
	AND p.CancelDate = DATEADD(dd,1,p.BilledThru)
GO
