IF object_id('calls_insert') IS NOT NULL
	DROP TRIGGER calls_insert
GO

CREATE TRIGGER calls_insert ON dbo.Calls
FOR INSERT
AS
SET NOCOUNT ON
-- Emerald 5 Calls Trigger
DECLARE @rows INT, @irows INT, @start SMALLINT, @stop SMALLINT, @interim SMALLINT, @noaccountid INT, @aidrows INT

SELECT @irows = COUNT(*), @rows = 0,
	@start = MAX(CASE WHEN AcctStatusType = 1 THEN 1 ELSE 0 END), 
	@stop = MAX(CASE WHEN AcctStatusType = 2 THEN 1 ELSE 0 END),
	@interim = MAX(CASE WHEN AcctStatusType = 3 THEN 1 ELSE 0 END),
	@noaccountid = MAX(CASE WHEN AccountID IS NULL THEN 1 ELSE 0 END),
	@aidrows = SUM(CASE WHEN AccountID IS NOT NULL THEN 1 ELSE 0 END)
FROM inserted i

IF (@noaccountid = 1)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
UPDATE Calls SET AccountID = sa.AccountID
FROM Calls c, inserted i, MasterAccounts ma, SubAccounts sa
	WHERE i.AccountID IS NULL
	AND ma.CustomerID = sa.CustomerID
	AND c.CallID = i.CallID
	AND i.Username = sa.Login
	AND i.Username <> ''
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)

IF (@@ROWCOUNT <> @irows - @aidrows)
BEGIN
UPDATE Calls SET AccountID = sa.AccountID
FROM Calls c, inserted i, MasterAccounts ma, SubAccounts sa
	WHERE c.AccountID IS NULL
	AND i.AccountID IS NULL
	AND ma.CustomerID = sa.CustomerID
	AND c.CallID = i.CallID
	AND i.Username = sa.Email
	AND i.Username <> ''
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
END

SET TRANSACTION ISOLATION LEVEL READ COMMITTED
END

-- IP Pooling
UPDATE RadIPAddresses SET LastCallDate = i.CallDate, State = CASE WHEN i.AcctStatusType IN (1,3) THEN 2 WHEN i.AcctStatusType = 2 THEN 0 ELSE State END
FROM RadIPAddresses ri, inserted i
	WHERE ri.NASPort = i.NASPort
	AND ri.NASIdentifier = i.NASIdentifier
	AND ri.LastCallDate <= i.CallDate
	AND i.AcctStatusType IN (1,2,3)

-- Group Concurrency
IF (@start = 1 OR @stop = 1)
BEGIN
UPDATE RadConcurrency SET Connections = Connections + CASE WHEN i.AcctStatusType = 1 THEN 1 WHEN i.AcctStatusType = 2 THEN -1 ELSE 0 END
FROM MasterAccounts ma, SubAccounts sa, RadConcurrency rc, inserted i, Calls c
	WHERE c.AccountID = sa.AccountID
	AND i.CallID = c.CallID
	AND ma.CustomerID = sa.CustomerID
	AND rc.GroupID = ma.GroupID
	AND c.AccountID IS NOT NULL
	AND i.AcctStatusType IN (1,2)
	AND (rc.AccountTypeID IS NULL OR rc.AccountTypeID = sa.AccountTypeID)
END

-- Update Online List
SELECT @rows = @rows + 1
FROM inserted
GROUP BY NASIdentifier, NASPort

IF (@noaccountid = 0)
BEGIN
UPDATE ServerPorts
        SET Username = i.Username, 
		AccountID = i.AccountID,
		AcctSessionTime = i.AcctSessionTime,
		AcctInputOctets = i.AcctInputOctets,
		AcctOutputOctets = i.AcctOutputOctets,
                AcctStatusType = CASE WHEN i.AcctStatusType IN (1,3) THEN 1 ELSE 2 END,
		CallDate = i.CallDate,
		FramedAddress = i.FramedAddress,
		CallerID = i.CallerID,
		NASPortDNIS = i.NASPortDNIS,
		ConnectInfo = i.ConnectInfo,
		AcctSessionID = i.AcctSessionID
        FROM ServerPorts sp, inserted i
        WHERE sp.NASIdentifier = i.NASIdentifier
	AND sp.Port = i.NASPort
	AND (sp.CallDate <= i.CallDate OR (sp.AcctStatusType = 1 AND i.AcctStatusType = 2 AND sp.AcctSessionTime > 0))
END ELSE BEGIN
UPDATE ServerPorts
        SET Username = i.Username, 
		AccountID = c.AccountID,
		AcctSessionTime = i.AcctSessionTime,
		AcctInputOctets = i.AcctInputOctets,
		AcctOutputOctets = i.AcctOutputOctets,
                AcctStatusType = CASE WHEN i.AcctStatusType IN (1,3) THEN 1 ELSE 2 END,
		CallDate = i.CallDate,
		FramedAddress = i.FramedAddress,
		CallerID = i.CallerID,
		NASPortDNIS = i.NASPortDNIS,
		ConnectInfo = i.ConnectInfo,
		AcctSessionID = i.AcctSessionID
        FROM ServerPorts sp, inserted i, Calls c
        WHERE sp.NASIdentifier = i.NASIdentifier
	AND sp.Port = i.NASPort
	AND i.CallID = c.CallID
	AND (sp.CallDate <= i.CallDate OR (sp.AcctStatusType = 1 AND i.AcctStatusType = 2 AND sp.AcctSessionTime > 0))
END

IF (@@ROWCOUNT <> @rows)
BEGIN
	IF (@noaccountid = 0)
	BEGIN
	INSERT INTO ServerPorts (AcctSessionTime,ServerID,Port,NASIdentifier,Username,AccountID,AcctSessionID,AcctStatusType,CallDate,FramedAddress,CallerID,NASPortDNIS,ConnectInfo)
	SELECT MIN(i.AcctSessionTime),MIN(i.ServerID),i.NASPort,i.NASIdentifier,MIN(i.Username),MIN(i.AccountID),MIN(i.AcctSessionID),CASE WHEN MAX(i.AcctStatusType) IN (1,3) THEN 1 ELSE 2 END,
	MAX(i.CallDate),MIN(i.FramedAddress),MIN(i.CallerID),MIN(i.NASPortDNIS),MIN(i.ConnectInfo)
	FROM inserted i
		WHERE NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.NASIdentifier = i.NASIdentifier AND sp.Port = i.NASPort)
	GROUP BY i.NASIdentifier, i.NASPort
	END ELSE BEGIN
	INSERT INTO ServerPorts (AcctSessionTime,ServerID,Port,NASIdentifier,Username,AccountID,AcctSessionID,AcctStatusType,CallDate,FramedAddress,CallerID,NASPortDNIS,ConnectInfo)
	SELECT MIN(i.AcctSessionTime),MIN(i.ServerID),i.NASPort,i.NASIdentifier,MIN(i.Username),MIN(c.AccountID),MIN(i.AcctSessionID),CASE WHEN MAX(i.AcctStatusType) IN (1,3) THEN 1 ELSE 2 END,
	MAX(i.CallDate),MIN(i.FramedAddress),MIN(i.CallerID),MIN(i.NASPortDNIS),MIN(i.ConnectInfo)
	FROM inserted i, Calls c
		WHERE i.CallID = c.CallID
		AND NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.NASIdentifier = i.NASIdentifier AND sp.Port = i.NASPort)
	GROUP BY i.NASIdentifier, i.NASPort
	END
END

-- Update Time Left
IF (@stop = 1)
BEGIN
	IF (@noaccountid = 0)
	BEGIN
	UPDATE SubAccounts
	SET TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + CASE WHEN i.AcctSessionTime % 60 <> 0 THEN 1 ELSE 0 END),
	DataLeft = sa.DataLeft - (COALESCE(i.AcctOutputOctets,0) + COALESCE(i.AcctInputOctets,0))
	FROM SubAccounts sa, inserted i
		WHERE i.AccountID IS NOT NULL
		AND sa.AccountID = i.AccountID
		AND (sa.TimeLeft IS NOT NULL OR sa.DataLeft IS NOT NULL)
		AND i.AcctStatusType = 2
	END ELSE BEGIN
	UPDATE SubAccounts
	SET TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + CASE WHEN i.AcctSessionTime % 60 <> 0 THEN 1 ELSE 0 END),
	DataLeft = sa.DataLeft - (COALESCE(i.AcctOutputOctets,0) + COALESCE(i.AcctInputOctets,0))
	FROM SubAccounts sa, inserted i, Calls c
		WHERE i.CallID = c.CallID
		AND c.AccountID IS NOT NULL
		AND sa.AccountID = c.AccountID
		AND (sa.TimeLeft IS NOT NULL OR sa.DataLeft IS NOT NULL)
		AND i.AcctStatusType = 2
	END
END

IF (@interim = 1)
BEGIN
DELETE FROM Calls
FROM Calls c, inserted i
	WHERE c.CallID = i.CallID
	AND i.AcctStatusType = 3
END

SET NOCOUNT OFF

