-- CREATE PROCEDURE dbo.ieaid AS
-- UPDATE ExportColumns SET IEAID=ExportColumnID WHERE IEAID IS NULL
-- UPDATE CCImportColumns SET IEAID=CCImportColumnID WHERE IEAID IS NULL
-- UPDATE CardDigits SET IEAID=CardDigitID WHERE IEAID IS NULL
-- UPDATE NoticeTypes SET IEAID=NoticeTypeID WHERE IEAID IS NULL
-- GO

CREATE PROCEDURE TabName2Description ( @tab varchar(64),  @d varchar(72) OUTPUT)  AS
set nocount on
DECLARE @i int
Select @i = 2, @d = upper(substring(@tab, 1, 1))
while (@i <= datalength(@tab) )
	BEGIN
	if ascii(substring(@tab, @i, 1)) = ascii(upper(substring(@tab, @i, 1))) and
		ascii(substring(@tab, @i-1, 1)) <> ascii(upper(substring(@tab, @i-1, 1))) 
		select @d = @d + ' ' + substring(@tab, @i, 1)
	else
		select @d = @d + substring(@tab, @i, 1)
	select @i = @i + 1
	END
if left(@d,4) = 'Rad ' 
	select @d = substring(@d, 5, datalength(@d)-4)
select @d = REPLACE (@d, 'Rad ', 'RADIUS ')
GO

CREATE PROCEDURE dbo.AddMetaTable (@tabname varchar(64)) AS
Declare @t varchar(72), @cname varchar(64), @mcid int
Insert Into MetaTables(TableName,Description)
Select TableName=Convert(varchar,name), 'N/A' AS Description
From sysobjects
Where type = 'U'
	and name = @tabname
	AND @tabname NOT IN (SELECT TableName FROM MetaTables)
INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case isnullable when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	'N/A' AS Description,
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, NULL as DepGroup, NULL as DepColumn, 	
	CASE WHEN st.name in ('datetime') THEN 7 ELSE NULL END as MetaRuleID, mt.MetaTableID, 
	0 as MinSize, isnullable as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.xtype = st.xtype
	and so.name = @tabname
	AND CONVERT(VARCHAR,sc.name) NOT IN (SELECT ColumnName FROM MetaColumns WHERE MetaTableID = mt.MetaTableID)
Update mc
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = fkeyid
	and fc.id = fkeyid	
	and fc.colid = fkey1
	and rt.id = rkeyid
	and rc.id = rkeyid	
	and rc.colid = rkey1
	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and ft.name = @tabname
	AND mc.DepTable IS NULL
	AND mc.DepColumn IS NULL
Update mc Set Required=0
From syscolumns sc, sysobjects so, MetaColumns mc, MetaTables mt
Where so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and so.id = sc.id
	and so.type = 'U'
	and sc.cdefault > 0
	and mt.TableName = @tabname
Update mc Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
	and mt.TableName = @tabname
EXEC TabName2Description @tabname, @t OUTPUT
Update MetaTables Set Description = @t Where TableName = @tabname AND Description = 'N/A'
DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = @tabname
OPEN clist
FETCH NEXT FROM clist INTO @mcid, @cname
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	EXEC TabName2Description @cname, @t OUTPUT
	Update MetaColumns Set Description = @t Where MetaColumnID = @mcid AND Description = 'N/A'
	FETCH NEXT FROM clist INTO @mcid, @cname
	END
close clist
deallocate clist
GO

CREATE PROCEDURE dbo.BackupDB @devname VARCHAR(64), @description VARCHAR(128) AS 
DECLARE @dbname varchar(128)
SELECT @dbname = DB_NAME()
BACKUP DATABASE @dbname TO @devname WITH INIT, DESCRIPTION = @description 

GO
CREATE PROCEDURE dbo.BackupDevInfo @devname VARCHAR(64) AS
RESTORE HEADERONLY FROM @devname
GO

CREATE PROCEDURE dbo.CallOverage (@callmonth DATETIME, @minhrs INT) AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @icallmonth DATETIME, @iminhrs INT
SELECT @icallmonth = COALESCE(@callmonth,getdate())
SELECT @icallmonth = DATEADD(dd,-DATEPART(dd,@icallmonth),@icallmonth), @iminhrs = COALESCE(@minhrs,0)

SELECT sa.AccountID, SUM(c.AcctSessionTime) AS SecsUsed INTO #tmp
FROM MasterAccounts ma, SubAccounts sa, Calls c
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = c.AccountID
	AND c.AcctStatusType = 2
	AND c.CallDate BETWEEN DATEADD(dd,ma.BillDay,@icallmonth) AND DATEADD(mm,1,DATEADD(dd,ma.BillDay,@icallmonth))
GROUP BY sa.AccountID
HAVING SUM(c.AcctSessionTime) > (@iminhrs * 3600)
SELECT ma.CustomerID, sa.AccountID, sa.Login, sa.Email, sa.FirstName, sa.LastName, ma.Company, t.SecsUsed, DATEADD(dd,ma.BillDay,@icallmonth) AS StartDate, DATEADD(mm,1,DATEADD(dd,ma.BillDay,@icallmonth)) AS EndDate
FROM SubAccounts sa, MasterAccounts ma, #tmp t
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = t.AccountID
	
DROP TABLE #tmp
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

GO



Create PROCEDURE [dbo].[DeleteGroup] @groupid INT, @mode int AS

-- Modes:	0 = Delete Just MBRs in group (not group itself)
--			1 = Delete MBRs, set objects with GroupID to global and delete group.
--			2 = Delete MBRs, delete any objects assigned to this group and delete group
-- 
--		Please note:  There is a REALLY good chance mode #2 will fail, as a result of the
--						high inter-dependent relationships around groups and its dependent objects.
--					This is because this proc only handles first-tier relationships and deleting objects
--					like Regions w/out first clearing all MBRs assigned that Region will cause an error.

-- ********* This proc runs inside a transaction.  It will rollback a mode that fails. *****************

DECLARE @cid int
IF @groupid IS NULL RETURN

BEGIN TRAN 

CREATE TABLE #summary (Description VARCHAR(100) NOT NULL)

if (select count(*) From Groups Where GroupID = @groupid) = 0
	BEGIN
	INSERT INTO #summary (Description) VALUES('GroupID #' + CONVERT(VARCHAR(15),@groupid) + ' Not Found')
	END

else
	BEGIN	

	IF ((SELECT COUNT(*) FROM MasterAccounts WHERE GroupID = @groupid) > 0)
		BEGIN
		DECLARE m_cursor CURSOR
		FOR Select CustomerID From MasterAccounts Where GroupID = @groupid
		OPEN m_cursor
		FETCH NEXT FROM m_cursor INTO @cid
		WHILE (@@fetch_status <> -1)
			BEGIN
			Exec DeleteMasterAccount @cid, 1
			FETCH NEXT FROM m_cursor INTO @cid
			END
		CLOSE m_cursor
		DEALLOCATE m_cursor
		END

	if @mode = 1	-- Set objects to global/null for this group
		BEGIN
		Update AccountTypes Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from AccountTypes')
		Update BillingCycles Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from BillingCycles')
		Update Discounts Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from Discounts')
		Update Domains Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from Domains')
		Update IncidentTypes Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from IncidentTypes')
		Update MasterAccountDataTypes Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from MasterAccountDataTypes')
		Update ReferredBys Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from ReferredBys')
		Update Regions Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from Regions')
		Update SalesPersons Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from SalesPersons')
		Update SendMethods Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from SendMethods')
		Update ServiceGroupItems Set GroupID = NULL Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated from ServiceGroupItems')
		END

	if @mode = 2	-- delete objects for this group (will probably fail except for groups w/out mbrs)
		BEGIN
		Delete From RadATConfigs Where AccountTypeID IN (Select AccountTypeID From AccountTypes Where GroupID = @groupid)
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from RadATConfigs')
		Delete From OrgAccountTypes Where AccountTypeID IN (Select AccountTypeID From AccountTypes Where GroupID = @groupid)
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from OrgAccountTypes')
		Delete From AccountTypes Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from AccountTypes')

		Delete From BillingCycles Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from BillingCycles')

		Delete From Batches Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Batches')

		Delete From RadConcurrency Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from RadConcurrency')

		Delete From PayPeriods Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from PayPeriods')
		Delete From Discounts Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Discounts')
		Delete From Domains Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Domains')
		Delete From IncidentTypes Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from IncidentTypes')
		Delete From MasterAccountDataTypes Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from MasterAccountDataTypes')
		Delete From ReferredBys Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from ReferredBys')
		Delete From Regions Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Regions')
		Delete From SalesPersons Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from SalesPersons')
		Delete From SendMethods Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from SendMethods')
		Delete From ServiceGroupItems Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from ServiceGroupItems')
		END


	if @mode = 1 or @mode = 2	-- Delete Group
		BEGIN
		-- This data is dependent and NOT-NULL, so we just delete it, even in mode=1

		Delete From ConfigGroupData Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) Removed from ConfigGroupData')
		Delete From OperatorGroupAccess Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) Removed from OperatorGroupAccess')
		Delete From OperatorRoles Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) Removed from OperatorRoles')
		Delete From Roles Where GroupID = @groupid
		INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) Removed from Roles')

		-- Finally try to delete the group as well

		Delete From Groups Where GroupID = @groupid
		if (@@rowcount > 0)
			INSERT INTO #summary (Description) VALUES('GroupID #' + CONVERT(VARCHAR(15),@groupid) + ' Deleted successfully')
		else
			INSERT INTO #summary (Description) VALUES('GroupID #' + CONVERT(VARCHAR(15),@groupid) + ' *NOT* Deleted successfully')

		END
	END

SELECT * FROM #summary

DROP TABLE #summary

COMMIT TRAN

GO


CREATE PROCEDURE dbo.DeleteMasterAccount (@customerid INT, @mode INT = 0) AS
DECLARE @aid int
IF @customerid IS NULL RETURN

CREATE TABLE #summary (Description VARCHAR(100) NOT NULL)

IF ((SELECT COUNT(*) FROM SubAccounts WHERE CustomerID = @customerid) > 0)
	BEGIN
	DECLARE s_cursor CURSOR
	FOR Select AccountID From SubAccounts Where CustomerID = @customerid
	OPEN s_cursor
	FETCH NEXT FROM s_cursor INTO @aid
	WHILE (@@fetch_status <> -1)
		BEGIN
		Exec DeleteSubAccount @aid, 1
		FETCH NEXT FROM s_cursor INTO @aid
		END
	CLOSE s_cursor
	DEALLOCATE s_cursor
	END

Update MasterAccounts Set LastStatementID = NULL Where CustomerID = @customerid

Update InvoiceItems Set ChargeID = NULL WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid)

DELETE FROM PaymentItems 
		WHERE ItemID IN (SELECT ItemID FROM Invoices i, InvoiceItems ii WHERE i.InvoiceID = ii.InvoiceID and CustomerID = @customerid)
			or PaymentID IN (Select PaymentID From Payments WHERE CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from PaymentItems')

DELETE FROM Charges WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Charges')

DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoice Items')
DELETE FROM ExternalTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from External Transactions')
DELETE FROM Payments WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Payments')
DELETE FROM BankTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Bank Transactions')
DELETE FROM Invoices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoices')
DELETE FROM MailLogs WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Mail Logs')
DELETE FROM Statements 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Statements')
DELETE FROM CreditCards WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from CreditCards')
DELETE FROM BankTrans 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from BankTrans')
DELETE FROM Addresses 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Addresses')
DELETE FROM CustomerSettings WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Customer Settings')
DELETE FROM NoticeActives WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Notice Actives')

DELETE FROM ResellerPkgUsage WHERE PackageID IN (SELECT PackageID FROM Packages WHERE CustomerID = @customerid)
DELETE FROM Packages WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Packages')

DELETE FROM MasterAccountData WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Custom Data')
DELETE FROM MasterAccounts WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Master Accounts')
INSERT INTO #summary (Description) VALUES('Master Account #' + CONVERT(VARCHAR(15),@customerid) + ' Deleted successfully')

if (@mode = 0)
	BEGIN
	SELECT * FROM #summary
	END

DROP TABLE #summary
GO

CREATE PROCEDURE DeleteMetaTable @tablename VARCHAR(64) AS
SET NOCOUNT ON
DECLARE @MetaTableID INT
SELECT @MetaTableID = MetaTableID FROM MetaTables WHERE TableName = @tablename
IF @MetaTableID IS NOT NULL
BEGIN
DELETE FROM MetaColumns WHERE MetaTableID = @MetaTableID
DELETE FROM MetaTables WHERE MetaTableID = @MetaTableID
END ELSE BEGIN
SELECT 'The table ' + @tablename + ' was not found in MetaTables'
END


GO



CREATE PROCEDURE [dbo].[DeleteSubAccount] ( @accountid INT, @mode int = 0 ) AS

if @accountid IS NULL RETURN

CREATE TABLE #summary ( Description VARCHAR(100) NOT NULL )

DELETE FROM Aliases WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Email Aliases')

DELETE FROM Forwards WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Email Forwards')

DELETE FROM FileTransfers WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from File Transfers')

DELETE FROM Actions WHERE IncidentID IN (SELECT IncidentID FROM Incidents WHERE AccountID = @accountid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Incident Actions')
DELETE FROM Incidents WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Incidents')
DELETE FROM RadConfigs WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Radius Configurations')
DELETE FROM RadTriggers WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Radius Triggers')
DELETE FROM RateHistory WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Call History')
DELETE FROM ResellerUsage WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Reseller Usage')
DELETE FROM SubAccountData WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Service Custom Data')
Update Charges
Set AccountID = NULL
Where AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated in InvoiceItems')
Update InvoiceItems
Set AccountID = NULL
Where AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated in Charges')

DELETE FROM ResellerUsage WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Reseller Usage')

DELETE FROM SubAccounts WHERE AccountID = @accountid


INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Sub Accounts')
INSERT INTO #summary (Description) VALUES('Sub Account #' + CONVERT(VARCHAR(15),@accountid) + ' Deleted successfully')

if (@mode = 0)
	BEGIN
	SELECT * FROM #summary
	END

DROP TABLE #summary

GO



CREATE PROCEDURE EmailCount @signature VARCHAR(64) AS
SET NOCOUNT ON
-- FIXME: I need work!!
--SELECT (Select Count(EmailID) From Emails Where Signature = @signature) + (Select Count(Signature) From EmailsDeleted Where Signature = @signature) as Emails

GO

CREATE PROCEDURE dbo.EmailSender @sender VARCHAR(64) AS
SET NOCOUNT ON
DECLARE @AccountID INT

-- MBR Email
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = (SELECT MIN(AccountID) FROM SubAccounts sa WHERE sa.Active=1 AND sa.CustomerID=ma.CustomerID) 
FROM MasterAccounts ma
	WHERE ma.Active >= 0 
	AND ma.Email = @sender
END

-- SA Email, Active
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.Email = @sender
	AND sa.Active = 1
	AND ma.Active = 1
END

-- SA Login, Active
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.DomainID = d.DomainID
	AND sa.Login + '@' + d.MailDomain = @sender
	AND ma.Active = 1
	AND sa.Active = 1
END

-- SA Alias, Active
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, Aliases a
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountID = a.AccountID
	AND a.Alias = @sender
	AND sa.Active = 1
	AND ma.Active = 1
END


-- SA Email, Inactive
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.Email = @sender
	AND ma.Active >= 0
	AND sa.Active >= 0
END

-- SA Login, Inactive
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.DomainID = d.DomainID
	AND sa.Login + '@' + d.MailDomain = @sender
	AND ma.Active >= 0
	AND sa.Active >= 0
END

-- SA Alias, Inactive
IF (@AccountID IS NULL)
BEGIN
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, Aliases a
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountID = a.AccountID
	AND a.Alias = @sender
	AND ma.Active >= 0
	AND sa.Active >= 0
END


GO




CREATE PROCEDURE dbo.MetaAddObjectColumn (@objectgroup varchar(32), @table VARCHAR(32), @column varchar(32)) AS
DECLARE @mtid INT, @ogid INT, @colid INT
Select @mtid = ISNULL(mt.MetaTableID,0), @colid = ISNULL(mc.MetaColumnID,0)
FROM MetaTables mt Left Join MetaColumns mc ON mt.MetaTableID = mc.MetaTableID
WHERE mt.TableName = @table
	AND mc.ColumnName = @column
Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup
if (@mtid > 0 and @ogid > 0 AND @colid > 0)
	BEGIN
	INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
	SELECT @ogid, mc.MetaColumnID, 3 
	FROM MetaColumns mc
		WHERE mc.MetaTableID = @mtid
		AND mc.MetaColumnID = @colid
		AND mc.MetaColumnID NOT IN 
			(SELECT o.Value FROM Objects o 
			WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)
	END ELSE
	BEGIN
	RAISERROR('Object Group/Table/Column not found',11,1)
	END


GO
CREATE PROCEDURE dbo.MetaAddObjectFile @ObjectGroup VARCHAR(32), @filename VARCHAR(128) AS
DECLARE @ObjectGroupID INT
SELECT @ObjectGroupID = ObjectGroupID FROM ObjectGroups WHERE ObjectGroup = @ObjectGroup
IF @ObjectGroupID IS NOT NULL
BEGIN
	IF (SELECT COUNT(*) FROM Objects WHERE ObjectGroupID = @ObjectGroupID AND Data = @filename AND ObjectTypeID = 1) = 0
		INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,@ObjectGroupID,@filename)
END ELSE BEGIN
	RAISERROR('Could not find Object Group',11,1)
END

GO
CREATE PROCEDURE dbo.MetaAddObjectTable @objectgroup varchar(32), @table VARCHAR(32), @addcols int AS
DECLARE @mtid int, @ogid int
Select @mtid = ISNULL(MetaTableID,0) 
From MetaTables
Where TableName = @table
Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup
if (@mtid > 0 and @ogid > 0)
BEGIN
	INSERT INTO Objects (ObjectGroupID, Value, ObjectTypeID)
	SELECT @ogid, @mtid, 2 
	WHERE NOT EXISTS (SELECT * FROM Objects WHERE ObjectGroupID = @ogid AND @mtid = Value AND ObjectTypeID = 2)
	if @addcols = 1
	BEGIN
		INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
		SELECT @ogid, mc.MetaColumnID, 3 
		FROM MetaColumns mc
			WHERE mc.MetaTableID = @mtid
			AND mc.MetaColumnID NOT IN 
				(SELECT o.Value FROM Objects o 
				WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)
	END
END
ELSE
	RAISERROR('Could not find Table or Object',11,1)

GO

CREATE PROCEDURE dbo.pkcols @table VARCHAR(32), @cols INT OUTPUT AS
SELECT @cols=COUNT(*) 
From sysindexes i, syscolumns c, sysobjects o
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and o.name = @table
GO

CREATE PROCEDURE sizecheck @column VARCHAR(64) AS
SELECT CONVERT(VARCHAR(32),st.name) AS TableName,CONVERT(VARCHAR(32),sc.name) AS ColumnName, sc.length, CASE WHEN MIN(sr1.rkeyid) IS NULL AND MIN(sr2.constid) IS NULL THEN 'No References' WHEN MIN(sr1.rkeyid) IS NOT NULL THEN object_name(MIN(sr1.rkeyid)) ELSE 'Primary key /w ' + CAST(COUNT(sr2.constid) AS VARCHAR(10)) + ' references' END AS KeyInfo
FROM sysobjects st JOIN syscolumns sc ON (st.id = sc.id)
	LEFT JOIN sysreferences sr1 ON (sc.id = sr1.fkeyid AND colorder = sr1.fkey1)
	LEFT JOIN sysreferences sr2 ON (sc.id = sr2.rkeyid AND colorder = sr2.rkey1)
	WHERE sc.name = @column
	AND st.id = sc.id
GROUP BY st.name, sc.name, sc.length
GO


CREATE PROCEDURE dbo.Table2Script (@tabname varchar(32), @script varchar(16)) AS
DECLARE @tabkey varchar(32), @keyquoted int, @str varchar(512)
DECLARE @DepTable varchar(32), @depcol varchar(32), @depkey varchar(32)
DECLARE @addcols varchar(512), @adddefs varchar(512), @col varchar(32)
SET NOCOUNT ON
If (select Count(MetaTableID) From MetaTables Where TableName = @tabname) = 0
	BEGIN
	PRINT @tabname + ' Not Defined in MetaTables'
	RETURN
	END
Select @tabkey = mc.ColumnName, @keyquoted = Quoted
From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	and mt.TableName = @tabname
	and IsKey = 1
Select @tabkey = ISNULL(@tabkey, @tabname)
Create Table #t_lines ( lines varchar(512) )
IF @script = 'list' 
BEGIN
Insert Into #t_lines VALUES('$include html_header.ews')
Insert Into #t_lines VALUES('$include admin_header.ews')
Insert Into #t_lines VALUES('')
Insert Into #t_lines Select '$query.' + @tabname
Insert Into #t_lines Select 'SELECT * FROM ' + @tabname + ' ORDER BY ' + 
	CASE WHEN (Select count(*) From MetaColumns mc, MetaTables mt
			Where mc.MetaTableID = mt.MetaTableID
				and mt.TableName = @tabname
				and mc.ColumnName = 'SortOrder') <> 0 THEN ' SortOrder' ELSE @tabkey END
Insert Into #t_lines VALUES('$query')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('<P>')
Insert Into #t_lines Select '<A CLASS="menu menu_adminoptions" HREF='+@tabname+'-edit.ews?MGID=$Variables.MGID>New '+@tabkey+'</A>'
Insert Into #t_lines VALUES('<DIV CLASS="list list_admin">')
Insert Into #t_lines VALUES('<H3>'+@tabname+'</H3>')
Insert Into #t_lines VALUES('<TABLE>')
Insert Into #t_lines
	Select '<TH>' + mc.Description + '</TH>' as line
	From MetaColumns mc, MetaTables mt
	Where mc.MetaTableID = mt.MetaTableID
		and mt.TableName = @tabname
		and (IsKey=0 OR (IsKey=1 and right(mc.ColumnName, 2) <> 'ID')) 
		and mc.ColumnName NOT IN ('SortOrder')
Insert Into #t_lines VALUES('<TH></TH>')
Insert Into #t_lines VALUES('$if.queryrows')
Insert Into #t_lines Select 'query=' + @tabname
Insert Into #t_lines Select 'norows=<TR><TD COLSPAN=4 CLASS="notfound">No ' + @tabname + '</TD>'
Insert Into #t_lines VALUES('$if')
Insert Into #t_lines VALUES('')
Insert Into #t_lines Select '$loop.' + @tabname
Insert Into #t_lines VALUES('<TR>')
Insert Into #t_lines 
	Select '<TD><A HREF=' + @tabname + '-edit.ews?' + @tabkey + '=$loop.'+@tabkey+'&MGID=$Variables.MGID>$loop.' + mc.ColumnName + '</A></TD>'
	From MetaColumns mc, MetaTables mt
	Where mc.MetaTableID = mt.MetaTableID
		and mt.TableName = @tabname
		and (IsKey=0 OR (IsKey=1 and right(mc.ColumnName, 2) <> 'ID')) 
		and mc.ColumnName NOT IN ('SortOrder')
Insert Into #t_lines 
	Select '<TD><A HREF='+CHAR(ASCII(''''))+'Javascript:ask("Delete ' + @tabkey + '?","' + @tabname + '-delete.ews?' + @tabkey + '=$loop.' + @tabkey + '&Cookie=$User.Cookie&MGID=$Variables.MGID")'+CHAR(ASCII(''''))+'>Delete</A></TD>'
Insert Into #t_lines VALUES('$loop')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('</TABLE>')
Insert Into #t_lines VALUES('</DIV>')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$audit.void')
Insert Into #t_lines VALUES('action=view')
Insert Into #t_lines SELECT 'location=' + LOWER(@tabname)
Insert Into #t_lines VALUES('$audit')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$include html_footer.ews')
END
ELSE
IF @script = 'edit'
BEGIN
Insert Into #t_lines VALUES('$include html_header.ews')
Insert Into #t_lines VALUES('$include admin_header.ews')
Insert Into #t_lines VALUES('')
Insert Into #t_lines Select '$query.' + @tabname
Insert Into #t_lines Select 'SELECT * FROM ' + @tabname  +  ' WHERE ' + @tabkey + '=' + CASE WHEN @keyquoted=1 THEN '''' ELSE '' END + '$-Variables.' + @tabkey + CASE WHEN @keyquoted=1 THEN '''' ELSE '' END
Insert Into #t_lines VALUES('$query')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$check.compare')
Insert Into #t_lines VALUES('compare=$Variables.' + @tabkey)
Insert Into #t_lines VALUES('with=')
Insert Into #t_lines VALUES('allowed_inline=$tablist.' + @tabname)
Insert Into #t_lines VALUES('A')
Insert Into #t_lines VALUES('A')
Insert Into #t_lines VALUES('$tablist')
Insert Into #t_lines VALUES('$check')
Insert Into #t_lines VALUES('')
DECLARE deplist CURSOR FOR
SELECT DISTINCT DepTable, DepColumn
From MetaColumns mc, MetaTables mt
Where mt.MetaTableID = mc.MetaTableID
	and mt.TableName = @tabname
	and DepTable is not NULL
	and DepColumn is not NULL
OPEN deplist
FETCH NEXT FROM deplist INTO @DepTable, @depcol
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	Insert Into #t_lines Select '$query.' + @DepTable

	IF (@DepTable = 'Groups' AND @depcol = 'GroupID')
	BEGIN

	Insert Into #t_lines VALUES('SELECT GroupID, GroupName, SortOrder FROM Groups WHERE GroupID > 1 AND SortOrder >= 0 AND Active=1')
	Insert Into #t_lines SELECT 'UNION SELECT GroupID, GroupName, SortOrder FROM Groups WHERE GroupID=$-' + @tabname + '.GroupID'
	Insert Into #t_lines VALUES('ORDER BY 3,2')

	END ELSE BEGIN

	Insert Into #t_lines Select 'SELECT ' + @depcol + ', Description'
	Insert Into #t_lines Select 'FROM ' + @DepTable
	Insert Into #t_lines Select 'ORDER BY ' + CASE WHEN (Select count(*) From MetaColumns mc, MetaTables mt
				Where mc.MetaTableID = mt.MetaTableID
					and mt.TableName = @DepTable
					and mc.ColumnName = 'SortOrder') <> 0 THEN ' SortOrder' ELSE @depcol END
	END

	Insert Into #t_lines VALUES('$query')
	Insert Into #t_lines VALUES('')
	FETCH NEXT FROM deplist INTO @DepTable, @depcol
	END
CLOSE deplist
DEALLOCATE deplist
Insert Into #t_lines Select '<FORM METHOD=POST ACTION=' + @tabname + '-update.ews onSubmit=this.sub.disabled=1>'
Insert Into #t_lines VALUES('<TABLE CLASS="edit edit_admin"><TH COLSPAN=2>')

Insert Into #t_lines VALUES('$check.compare')
Insert Into #t_lines SELECT 'compare=$Variables.' + @tabkey
Insert Into #t_lines VALUES('with=')
Insert Into #t_lines VALUES('allowed=New')
Insert Into #t_lines VALUES('denied=Edit')
Insert Into #t_lines VALUES('$check')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES(' ' + @tabkey + '</TH>')
Insert Into #t_lines
Select '<TR><TD class="label">' + 
	CASE WHEN RIGHT (mc.Description,2) = 'ID' THEN LEFT(mc.Description, datalength(mc.Description)-2) ELSE mc.Description END 
		+ ':</TD><TD>' +
	CASE WHEN DepTable IS NULL THEN '<INPUT NAME=' + ColumnName + ' SIZE=' + Convert(varchar, CASE WHEN MaxSize > 64 THEN 64 WHEN MaxSize > 0 THEN MAXSIZE ELSE 15 END) + ' VALUE="$'+@tabname+'.'+mc.ColumnName+'">' 
		ELSE '<SELECT NAME=' + ColumnName+ '>' + char(13) + char(10) + 
			'$select.' + DepTable + char(13) + char(10) + 
			'description=$select.Description' + char(13) + char(10) + 
			'value=$select.' + DepColumn + char(13) + char(10) + 
			'selected=$' + @tabname + '.' + DepColumn + char(13) + char(10) + 
			'$select' + char(13) + char(10) + 
			'</SELECT>'
		END + '</TD>'
From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	and mt.TableName = @tabname
	and (IsKey=0 OR (IsKey=1 and right(mc.ColumnName, 2) <> 'ID')) 
Insert Into #t_lines VALUES('<TR><TD COLSPAN=2 ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Update" NAME=sub onClick="return formcheck();"></TD>')
Insert Into #t_lines VALUES('</TABLE>')
Insert Into #t_lines 
	Select '<INPUT TYPE=HIDDEN NAME=' + @tabkey + ' VALUE="$Variables.' + @tabkey + '">'
	From MetaColumns mc, MetaTables mt
	Where mc.MetaTableID = mt.MetaTableID
		and mt.TableName = @tabname
		and IsKey=1 
		and right(mc.ColumnName, 2) = 'ID' 
Insert Into #t_lines VALUES('<INPUT TYPE=HIDDEN NAME=MGID VALUE="$Variables.MGID">')
Insert Into #t_lines VALUES('</FORM>')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$formcheck.' + @tabname)
INSERT INTO #t_lines SELECT 'actionid=$Variables.' + @tabkey
Insert Into #t_lines VALUES('$formcheck')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$audit.void')
Insert Into #t_lines VALUES('action=edit')
Insert Into #t_lines SELECT 'location=' + LOWER(@tabname)
Insert Into #t_lines SELECT 'description=' + @tabkey + '=$Variables.' + @tabkey
Insert Into #t_lines VALUES('$audit')
Insert Into #t_lines VALUES('')
Insert Into #t_lines VALUES('$include html_footer.ews')
END
ELSE
IF @script = 'update'
BEGIN

Insert Into #t_lines VALUES('$check.referer')
Insert Into #t_lines VALUES('$check')

Insert Into #t_lines Select '$update.' + @tabname
Insert Into #t_lines 
	Select mc.ColumnName + '=$Variables.' + mc.ColumnName
	From MetaColumns mc, MetaTables mt
	Where mc.MetaTableID = mt.MetaTableID
		and mt.TableName = @tabname
Insert Into #t_lines VALUES('error_include=admin_error.ews')
Insert Into #t_lines VALUES('$update')
Insert Into #t_lines VALUES('')

INSERT INTO #t_lines VALUES('$audit.void')
INSERT INTO #t_lines VALUES('action=update')
INSERT INTO #t_lines SELECT 'location=' + LOWER(@tabname)
INSERT INTO #t_lines VALUES('description=' + @tabkey + '=$Variables.' + @tabkey + ',...FIXME!!!')
INSERT INTO #t_lines VALUES('$audit')
INSERT INTO #t_lines VALUES('')

Insert Into #t_lines Select '$include ' + @tabname + '-list.ews'
END
ELSE
IF @script = 'delete'
BEGIN
Insert Into #t_lines VALUES('$check.referer')
Insert Into #t_lines VALUES('$check')
Insert Into #t_lines Select '$delete.' + @tabname
Insert Into #t_lines Select @tabkey + '=$Variables.' + @tabkey
Insert Into #t_lines VALUES('error_include=admin_error.ews')
Insert Into #t_lines VALUES('$delete')
INSERT INTO #t_lines VALUES('$audit.void')
INSERT INTO #t_lines VALUES('action=delete')
INSERT INTO #t_lines SELECT 'location=' + LOWER(@tabname)
INSERT INTO #t_lines SELECT 'description=' + @tabkey + '=$Variables.' + @tabkey
INSERT INTO #t_lines VALUES('$audit')
Insert Into #t_lines Select '$include ' + @tabname + '-list.ews'
END
if (select count(*) from #t_lines) > 0 
	Select * From #t_lines
else
	print 'Unknown script type ' + @script
Drop Table #t_lines
GO

CREATE PROCEDURE AddAllExportColumns(@ExportID int) as

Create table #t ( col varchar(20) )

INSERT INTO #t(col) VALUES('Email')
INSERT INTO #t(col) VALUES('expmm')
INSERT INTO #t(col) VALUES('expyy')
INSERT INTO #t(col) VALUES('Phone')
INSERT INTO #t(col) VALUES('FirstName')
INSERT INTO #t(col) VALUES('LastName')
INSERT INTO #t(col) VALUES('State')
INSERT INTO #t(col) VALUES('City')
INSERT INTO #t(col) VALUES('Country')
INSERT INTO #t(col) VALUES('CardNumber')
INSERT INTO #t(col) VALUES('CardHolder')
INSERT INTO #t(col) VALUES('Address')
INSERT INTO #t(col) VALUES('Zip')
INSERT INTO #t(col) VALUES('SecurityCode')
INSERT INTO #t(col) VALUES('ExternalTransID')
INSERT INTO #t(col) VALUES('TransTypeID')
INSERT INTO #t(col) VALUES('TransID')
INSERT INTO #t(col) VALUES('CustomerID')
INSERT INTO #t(col) VALUES('LastModifyUser')
INSERT INTO #t(col) VALUES('InvoiceID')
INSERT INTO #t(col) VALUES('Merchant')
INSERT INTO #t(col) VALUES('Store')
INSERT INTO #t(col) VALUES('Terminal')
INSERT INTO #t(col) VALUES('startdd')
INSERT INTO #t(col) VALUES('startmm')
INSERT INTO #t(col) VALUES('startyy')
INSERT INTO #t(col) VALUES('starthh')
INSERT INTO #t(col) VALUES('startmi')
INSERT INTO #t(col) VALUES('startss')
INSERT INTO #t(col) VALUES('Amount')
INSERT INTO #t(col) VALUES('CardType')
INSERT INTO #t(col) VALUES('SecurityCodePresent')
INSERT INTO #t(col) VALUES('Login')
INSERT INTO #t(col) VALUES('Password')
INSERT INTO #t(col) VALUES('Company')


INSERT INTO ExportColumns(ExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType)
Select @exportid as ExportID,0 as SortOrder,col as FieldName,NULL AS Description,0 as Quoted,0 as MinSize, 0 as MaxSize,
	0 as Align,0 as Format,0 as Padding,NULL as ExportValue,1 as Include,511 as TransType
From #t

Drop table #t

GO

CREATE PROCEDURE InvoiceGaps AS
SET NOCOUNT ON
SELECT MIN(ma.CustomerID) AS CustomerID, sa.AccountID, MIN(ii.StartDate) AS Starting, MAX(ii.EndDate) AS Ending, 
DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate)) - (SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1) AS FreeDays,
(MIN(at1.Cost)/30) * (DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate)) - (SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1)) AS EstimatedCost

FROM MasterAccounts ma, SubAccounts sa, Invoices i, InvoiceItems ii, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CancelDate IS NULL
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.AccountID = sa.AccountID
	AND ii.StartDate > DATEADD(mm,-12,getdate())
	AND sa.BilledThru > DATEADD(mm,-1,getdate())
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.Cost > 0
GROUP BY sa.AccountID
HAVING SUM(DATEDIFF(dd,ii.StartDate,ii.EndDate)+1)-1 < DATEDIFF(dd,MIN(ii.StartDate),MAX(ii.EndDate))
GO

CREATE PROCEDURE dbo.ShowTriggers AS
SET NOCOUNT ON
SELECT s2.name AS TableName, s1.name AS TriggerName, 
LTRIM(CASE WHEN s1.deltrig > 0 THEN ' Delete' ELSE '' END + 
CASE WHEN s1.instrig > 0 THEN ' Insert' ELSE '' END + 
CASE WHEN s1.updtrig > 0 THEN ' Update' ELSE '' END) AS Type
FROM sysobjects s1, sysobjects s2 
	WHERE s1.parent_obj = s2.id
	AND s1.xtype = 'TR'
ORDER BY 1
GO

