CREATE CLUSTER iCalls_CallID (CallID NUMBER(38)) SIZE 64
/
CREATE CLUSTER IX_PaymentItems (PaymentID INTEGER,ChargeID INTEGER,ItemID INTEGER) SIZE 16
/
CREATE CLUSTER i_RC_GroupAccountID (GroupID INTEGER,AccountTypeID INTEGER) SIZE 64
/
CREATE CLUSTER IX_RadIPAddresses (NASIdentifier VARCHAR2(32),NASPort VARCHAR2(32)) SIZE 64
/
CREATE TABLE AccountDataTypes (
       AccountDataTypeID    INTEGER NOT NULL,
       AccountDataType      VARCHAR2(64) NOT NULL,
       DataTypeID           smallint NOT NULL,
       AllowMBR             smallint DEFAULT 1  NOT NULL,
       AllowSA              smallint DEFAULT 1  NOT NULL,
       StringID             INTEGER NULL,
       SQLQuery             VARCHAR2(255) NULL,
       RegExp               VARCHAR2(255) NULL
)
/

CREATE INDEX i_ADT_ADTs ON AccountDataTypes
(
       AccountDataType
)
/


ALTER TABLE AccountDataTypes
       ADD PRIMARY KEY (AccountDataTypeID)
/


CREATE TABLE AccountDataValues (
       AccountDataTypeID    INTEGER NOT NULL,
       KeyData              VARCHAR2(128) NOT NULL,
       ValueData            VARCHAR2(128) NOT NULL
)
/


ALTER TABLE AccountDataValues
       ADD PRIMARY KEY (AccountDataTypeID, KeyData)
/


CREATE TABLE AccountTemplates (
       AccountTemplateID    INTEGER NOT NULL,
       AccountTemplate      VARCHAR2(128) NOT NULL,
       LoginLabel           VARCHAR2(128) NULL,
       LoginStringID        INTEGER NULL,
       SANew                VARCHAR2(64) NULL,
       SAEdit               VARCHAR2(64) NULL,
       SASave               VARCHAR2(64) NULL,
       SADetail             VARCHAR2(64) NULL,
       CustNew              VARCHAR2(64) NULL,
       CustEdit             VARCHAR2(64) NULL,
       CustEditLabel        VARCHAR2(128) NULL,
       CustEditStringID     INTEGER NULL,
       CustSave             VARCHAR2(64) NULL,
       SignupPage           VARCHAR2(64) NULL,
       SignupForm           VARCHAR2(64) NULL,
       SignupValidate       VARCHAR2(64) NULL,
       SignupSave           VARCHAR2(64) NULL,
       SortOrder            smallint DEFAULT (0)  NOT NULL,
       SignupBillSave       VARCHAR2(64) NULL
)
/


ALTER TABLE AccountTemplates
       ADD PRIMARY KEY (AccountTemplateID)
/


CREATE TABLE AccountTypes (
       AccountTypeID        INTEGER ,
       AccountType          VARCHAR2(30) NOT NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       ApplyDiscount        smallint NOT NULL,
       TaxGroupID           INTEGER NULL,
       TaxExemptions        INTEGER DEFAULT 0  NOT NULL,
       RateClassID          INTEGER NULL,
       ChargeTypeID         INTEGER NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       DNISGroupID          INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       OverDue              smallint DEFAULT 0  NULL,
       GLCodeID             INTEGER NULL,
       LoginLimit           smallint NULL,
       TimeLeft             INTEGER NULL,
       HomeDirSize          INTEGER NULL,
       SendBill             smallint NULL,
       RemoteAccess         smallint NULL,
       PayPeriodID          INTEGER NULL,
       RadFailAccountTypeID INTEGER NULL,
       RadFailReason        smallint NULL,
       StartDate            DATE NULL,
       EndDate              DATE NULL,
       NextID               INTEGER NULL,
       NextCount            INTEGER NULL,
       RequireUserPass      INTEGER NULL,
       ChangeOpen           smallint DEFAULT 1  NOT NULL,
       ChangeTo             smallint DEFAULT 1  NOT NULL,
       ChangeClose          smallint DEFAULT 1  NOT NULL,
       ChangeFrom           smallint DEFAULT 1  NOT NULL,
       DataLeft             NUMBER(38) NULL,
       SecChargeTypeID      INTEGER NULL,
       AccountTemplateID    INTEGER NULL,
       DataLeftRenewal      smallint NULL,
       TimeLeftRenewal      smallint NULL,
       InactCanceledDays    smallint NULL
)
/

CREATE UNIQUE INDEX XAK1AccountTypes ON AccountTypes
(
       AccountType
)
/

CREATE INDEX i_AccountTypes_RFATID ON AccountTypes
(
       RadFailAccountTypeID
)
/


ALTER TABLE AccountTypes
       ADD PRIMARY KEY (AccountTypeID)
/


CREATE TABLE Actions (
       ActionID             INTEGER ,
       IncidentID           INTEGER NOT NULL,
       CreateOperatorID     INTEGER NULL,
       CreateAccountID      INTEGER NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       Description          CLOB NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       CustomerAccess       smallint DEFAULT 0  NOT NULL,
       Duration             INTEGER DEFAULT 0  NOT NULL,
       IncidentTypeID       INTEGER NOT NULL,
       IncidentStateID      INTEGER NOT NULL,
       AssignRoleID         INTEGER NULL,
       AssignOperatorID     INTEGER NULL
)
/

CREATE INDEX i_Actions_IncidentID ON Actions
(
       IncidentID
)
/


ALTER TABLE Actions
       ADD PRIMARY KEY (ActionID)
/


CREATE TABLE Addresses (
       AddressID            INTEGER ,
       CustomerID           INTEGER NULL,
       AddressTypeID        INTEGER NOT NULL,
       CountryID            INTEGER NULL,
       StateID              INTEGER NULL,
       Company              VARCHAR2(80) NULL,
       Address1             VARCHAR2(80) NULL,
       Address2             VARCHAR2(80) NULL,
       City                 VARCHAR2(40) NULL,
       Zip                  VARCHAR2(20) NULL,
       Province             VARCHAR2(40) NULL,
       FirstName            VARCHAR2(40) NULL,
       LastName             VARCHAR2(40) NULL,
       Phone                VARCHAR2(32) NULL,
       Fax                  VARCHAR2(32) NULL,
       Email                VARCHAR2(80) NULL,
       WWW                  VARCHAR2(128) NULL,
       Comments             VARCHAR2(255) NULL
)
/


ALTER TABLE Addresses
       ADD PRIMARY KEY (AddressID)
/


CREATE TABLE AddressTypes (
       AddressTypeID        INTEGER ,
       AddressType          VARCHAR2(64) NOT NULL,
       SortOrder            INTEGER DEFAULT 1  NOT NULL,
       RequiredFields       VARCHAR2(255) NULL,
       ShowFields           INTEGER DEFAULT 65535  NOT NULL
)
/


ALTER TABLE AddressTypes
       ADD PRIMARY KEY (AddressTypeID)
/


CREATE TABLE Aliases (
       AliasID              INTEGER ,
       Alias                VARCHAR2(64) NOT NULL,
       AccountID            INTEGER NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL
)
/

CREATE INDEX i_Aliases_AccountID ON Aliases
(
       AccountID
)
/

CREATE INDEX IX_Aliases_Alias ON Aliases
(
       Alias
)
/


ALTER TABLE Aliases
       ADD PRIMARY KEY (AliasID)
/


CREATE TABLE AllowedHosts (
       AllowedHostID        INTEGER ,
       OperatorGroupID      INTEGER NULL,
       IPAddress            VARCHAR2(16) NULL,
       Description          VARCHAR2(100) NOT NULL
)
/


ALTER TABLE AllowedHosts
       ADD PRIMARY KEY (AllowedHostID)
/


CREATE TABLE Applications (
       ApplicationID        INTEGER NOT NULL,
       AppName              VARCHAR2(32) NOT NULL
)
/

CREATE INDEX XIE1Applications ON Applications
(
       AppName
)
/


ALTER TABLE Applications
       ADD PRIMARY KEY (ApplicationID)
/


CREATE TABLE AuditLogs (
       AuditLogID           INTEGER ,
       LogMsgID             INTEGER NOT NULL,
       LogDate              DATE DEFAULT SYSDATE  NOT NULL,
       LogMsg               VARCHAR2(255) NOT NULL,
       Operator             VARCHAR2(64) NULL,
       CustomerID           INTEGER NULL,
       AccountID            INTEGER NULL,
       PackageID            INTEGER NULL
)
/

CREATE INDEX i_Logs_LogDate ON AuditLogs
(
       LogDate
)
/


ALTER TABLE AuditLogs
       ADD PRIMARY KEY (AuditLogID)
/


CREATE TABLE BankTrans (
       CustomerID           INTEGER NOT NULL,
       AuthName             VARCHAR2(64) NOT NULL,
       BankName             VARCHAR2(64) NOT NULL,
       BankPhone            VARCHAR2(20) NULL,
       ABANumber            VARCHAR2(128) NOT NULL,
       AccountNumber        VARCHAR2(128) NOT NULL,
       TransType            VARCHAR2(16) NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       SSN                  VARCHAR2(128) NULL,
       DLNumber             VARCHAR2(128) NULL,
       DLState              VARCHAR2(40) NULL,
       BirthDate            DATE NULL
)
/


ALTER TABLE BankTrans
       ADD PRIMARY KEY (CustomerID)
/


CREATE TABLE Batches (
       BatchID              INTEGER ,
       BatchTypeID          INTEGER NOT NULL,
       BatchStateID         INTEGER NOT NULL,
       GroupID              INTEGER NULL,
       Operator             VARCHAR2(64) NOT NULL,
       StartDate            DATE DEFAULT SYSDATE  NOT NULL,
       EndDate              DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) NOT NULL,
       BatchInfo            VARCHAR2(255) NULL,
       ItemCount            INTEGER NULL,
       ItemTotal            numeric(18,4) NULL,
       Rebatch              smallint NULL
)
/

CREATE INDEX i_Batches_GroupID ON Batches
(
       GroupID
)
/

CREATE INDEX i_Batches_BatchTypeID ON Batches
(
       BatchTypeID,
       BatchStateID
)
/

CREATE INDEX i_Batches_StartDate ON Batches
(
       StartDate
)
/


ALTER TABLE Batches
       ADD PRIMARY KEY (BatchID)
/


CREATE TABLE BatchProcessors (
       BatchProcessorID     INTEGER ,
       OrganizationID       INTEGER NULL,
       GroupID              INTEGER NULL,
       ExportID             INTEGER NOT NULL,
       BatchProcessor       VARCHAR2(128) NOT NULL,
       BatchIn              VARCHAR2(255) NULL,
       BatchOut             VARCHAR2(255) NULL,
       BatchLimit           INTEGER NULL,
       Merchant             VARCHAR2(64) NULL,
       Store                VARCHAR2(64) NULL,
       Terminal             VARCHAR2(64) NULL,
       ImportOptions        INTEGER NULL,
       ExportOptions        INTEGER NULL,
       RebatchTries         INTEGER DEFAULT 0  NULL,
       RebatchInterval      INTEGER NULL,
       ProcessorURL         VARCHAR2(255) NULL,
       Login                VARCHAR2(64) NULL,
       Password             VARCHAR2(128) NULL,
       CardTypes            INTEGER DEFAULT 255  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL
)
/

CREATE INDEX Statistic_CardTypes ON BatchProcessors
(
       CardTypes
)
/


ALTER TABLE BatchProcessors
       ADD PRIMARY KEY (BatchProcessorID)
/


CREATE TABLE BatchStates (
       BatchStateID         INTEGER NOT NULL,
       BatchState           VARCHAR2(128) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE BatchStates
       ADD PRIMARY KEY (BatchStateID)
/


CREATE TABLE BatchTypes (
       BatchTypeID          INTEGER NOT NULL,
       BatchType            VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       TableName            VARCHAR2(64) NULL,
       Description          CLOB NULL
)
/


ALTER TABLE BatchTypes
       ADD PRIMARY KEY (BatchTypeID)
/


CREATE TABLE BillingCycles (
       BillingCycleID       INTEGER ,
       Description          VARCHAR2(45) NOT NULL,
       StringID             INTEGER NULL,
       CycleType            smallint DEFAULT 0  NOT NULL,
       AutoBill             smallint DEFAULT 0  NOT NULL,
       Extension            smallint NULL,
       BillDay              INTEGER NULL,
       IBillDays            INTEGER DEFAULT 15  NOT NULL,
       EBillDays            INTEGER DEFAULT 5  NOT NULL,
       RenewDays            INTEGER DEFAULT 0  NOT NULL,
       RenewPeriods         INTEGER DEFAULT 0  NOT NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       LateFeeID            INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       TBillDays            INTEGER NULL
)
/


ALTER TABLE BillingCycles
       ADD PRIMARY KEY (BillingCycleID)
/


CREATE TABLE Calls (
       CallID               NUMBER(38) ,
       Username             VARCHAR2(64) NOT NULL,
       AcctSessionID        VARCHAR2(32) NOT NULL,
       NASIdentifier        VARCHAR2(32) NOT NULL,
       AcctStatusType       smallint NOT NULL,
       NASPort              VARCHAR2(32) DEFAULT (-1)  NOT NULL,
       CallDate             DATE DEFAULT SYSDATE  NOT NULL,
       AcctDelayTime        INTEGER DEFAULT 0  NULL,
       AcctSessionTime      INTEGER DEFAULT 0  NULL,
       FramedAddress        VARCHAR2(32) NULL,
       AcctInputOctets      NUMBER(38) NULL,
       AcctOutputOctets     NUMBER(38) NULL,
       AcctTerminateCause   smallint NULL,
       NASPortType          smallint NULL,
       NASPortDNIS          VARCHAR2(64) NULL,
       CallerID             VARCHAR2(64) NULL,
       ConnectInfo          VARCHAR2(64) NULL,
       ServerID             INTEGER NULL,
       AccountID            INTEGER NULL
) CLUSTER iCalls_CallID (CallID)
/
CREATE INDEX iCalls_CallID ON CLUSTER iCalls_CallID
/







CREATE INDEX iCalls_AccountID ON Calls
(
       AccountID
)
/

CREATE INDEX iCalls_ServerID ON Calls
(
       ServerID
)
/

CREATE INDEX iCalls_CallDate ON Calls
(
       CallDate
)
/


ALTER TABLE Calls
       ADD PRIMARY KEY  (Username, AcctSessionID, 
              NASIdentifier, AcctStatusType, NASPort, CallDate)
/


CREATE TABLE CancelReasons (
       CancelReasonID       INTEGER ,
       CancelReason         VARCHAR2(128) NOT NULL,
       StringID             INTEGER NULL,
       Returning            smallint DEFAULT 0  NOT NULL,
       CustomerAccess       smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE CancelReasons
       ADD PRIMARY KEY (CancelReasonID)
/


CREATE TABLE CardAccounts (
       CardAccountID        INTEGER ,
       CardBatchID          INTEGER NOT NULL,
       OrganizationID       INTEGER NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       Login                VARCHAR2(40) NOT NULL,
       Password             VARCHAR2(128) NOT NULL,
       InactiveExpireDate   DATE NULL,
       FirstUseDate         DATE NULL,
       AllowCredit          smallint DEFAULT 1  NOT NULL,
       UsedForCredit        smallint DEFAULT 0  NOT NULL,
       LastCreditDate       DATE NULL,
       CreditAmount         numeric(18,4) NULL,
       AllowDirect          smallint DEFAULT 1  NOT NULL,
       UsedForDirect        smallint DEFAULT 0  NOT NULL,
       DirectCustomerID     INTEGER NULL,
       DirectAccountID      INTEGER NULL
)
/

CREATE UNIQUE INDEX I_CardAccounts_Login ON CardAccounts
(
       Login
)
/

CREATE INDEX I_CardAccounts_CardBatchID ON CardAccounts
(
       CardBatchID,
       Active
)
/


ALTER TABLE CardAccounts
       ADD PRIMARY KEY (CardAccountID)
/


CREATE TABLE CardBatches (
       CardBatchID          INTEGER ,
       CardBatch            VARCHAR2(128) NULL,
       CardBatchTypeID      INTEGER NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       Operator             VARCHAR2(64) NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NULL,
       LastModifyUser       VARCHAR2(64) NULL,
       InactiveExpireDate   DATE NULL,
       ActiveExpireDays     INTEGER NULL,
       TimeLeft             INTEGER NULL,
       BytesLeft            NUMBER(38) NULL,
       Amount               numeric(18,4) NULL,
       GroupID              INTEGER NOT NULL,
       LoginCardDigitID     INTEGER NOT NULL,
       PasswordCardDigitID  INTEGER NOT NULL,
       AllowDirect          smallint DEFAULT 1  NOT NULL,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          INTEGER NULL,
       SendMethodID         INTEGER NULL,
       BillingCycleID       INTEGER NULL,
       AccountTypeID        INTEGER NULL,
       DiscountID           INTEGER NULL,
       DomainID             INTEGER NULL,
       SalesPersonID        INTEGER NULL,
       RangeStart           numeric(18,4) NULL,
       BatchSize            INTEGER NOT NULL,
       RangeStep            numeric(18,4) NULL,
       LoginPrefix          VARCHAR2(10) NULL,
       LoginParm1           VARCHAR2(20) NULL,
       LoginParm2           VARCHAR2(20) NULL,
       PasswordParm1        VARCHAR2(20) NULL,
       PasswordParm2        VARCHAR2(20) NULL,
       Comments             CLOB NULL,
       DataLeft             NUMBER(38) NULL,
       ActiveExpireMins     INTEGER NULL
)
/


ALTER TABLE CardBatches
       ADD PRIMARY KEY (CardBatchID)
/


CREATE TABLE CardBatchTypes (
       CardBatchTypeID      INTEGER ,
       CardBatchType        VARCHAR2(128) NOT NULL,
       InactiveExpireDays   INTEGER NULL,
       ActiveExpireDays     INTEGER DEFAULT 30  NOT NULL,
       TimeLeft             INTEGER NULL,
       BytesLeft            INTEGER NULL,
       Amount               numeric(18,4) NULL,
       BatchSize            INTEGER NULL,
       GroupID              INTEGER NULL,
       LoginCardDigitID     INTEGER NOT NULL,
       PasswordCardDigitID  INTEGER NOT NULL,
       AllowDirectUse       smallint DEFAULT 1  NOT NULL,
       DirectAmount         numeric(18,4) NULL,
       PayPeriodID          INTEGER NULL,
       SendMethodID         INTEGER NULL,
       BillingCycleID       INTEGER NULL,
       AccountTypeID        INTEGER NULL,
       DiscountID           INTEGER NULL,
       DomainID             INTEGER NULL,
       SalesPersonID        INTEGER NULL,
       DataLeft             NUMBER(38) NULL,
       ActiveExpireMins     INTEGER NULL
)
/


ALTER TABLE CardBatchTypes
       ADD PRIMARY KEY (CardBatchTypeID)
/


CREATE TABLE CardDigits (
       CardDigitID          INTEGER ,
       CardDigit            VARCHAR2(64) NOT NULL,
       JavascriptHeader     CLOB NULL,
       JavascriptField      CLOB NOT NULL,
       AllowLogin           smallint DEFAULT 1  NOT NULL,
       AllowPassword        smallint DEFAULT 1  NOT NULL,
       IEAID                INTEGER NULL
)
/


ALTER TABLE CardDigits
       ADD PRIMARY KEY (CardDigitID)
/


CREATE TABLE CardTypePrefixes (
       CardTypeID           INTEGER NOT NULL,
       Prefix               VARCHAR2(5) NOT NULL
)
/


ALTER TABLE CardTypePrefixes
       ADD PRIMARY KEY (CardTypeID, Prefix)
/


CREATE TABLE CardTypes (
       CardTypeID           INTEGER NOT NULL,
       CardType             VARCHAR2(128) NOT NULL,
       Length1              INTEGER NULL,
       Length2              INTEGER NULL,
       CRC                  VARCHAR2(10) DEFAULT 'crc'  NOT NULL
)
/


ALTER TABLE CardTypes
       ADD PRIMARY KEY (CardTypeID)
/


CREATE TABLE CCImportColumns (
       CCImportColumnID     INTEGER ,
       ExportID             INTEGER NOT NULL,
       FieldType            smallint DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       Position             smallint NOT NULL,
       Description          VARCHAR2(64) NULL,
       Quoted               smallint DEFAULT 0  NOT NULL,
       FieldSize            smallint NOT NULL,
       ApproveValue         VARCHAR2(50) NULL,
       DeclineValue         VARCHAR2(50) NULL,
       ErrorValue           VARCHAR2(50) NULL,
       Line                 INTEGER DEFAULT 1  NOT NULL,
       TransType            INTEGER DEFAULT 511  NOT NULL,
       IEAID                INTEGER NULL
)
/


ALTER TABLE CCImportColumns
       ADD PRIMARY KEY (CCImportColumnID)
/


CREATE TABLE Charges (
       ChargeID             INTEGER ,
       CustomerID           INTEGER NOT NULL,
       Description          VARCHAR2(64) NULL,
       StartDate            DATE NOT NULL,
       EndDate              DATE NOT NULL,
       AccountID            INTEGER NULL,
       PackageID            INTEGER NULL,
       Login                VARCHAR2(64) NULL,
       AccountTypeID        INTEGER NULL,
       PackageTypeID        INTEGER NULL,
       DistFlag             smallint DEFAULT 1  NOT NULL,
       AllowInterim         smallint DEFAULT 1  NOT NULL,
       Prorated             smallint DEFAULT 0  NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             INTEGER NOT NULL,
       TaxGroupID           INTEGER NULL,
       TaxExemptions        INTEGER DEFAULT 0  NOT NULL,
       ChargeTypeID         INTEGER NULL,
       ItemID               INTEGER NULL,
       Operator             VARCHAR2(64) DEFAULT (user)  NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       PrevChargeID         INTEGER NULL
)
/

CREATE INDEX iCustomerID ON Charges
(
       CustomerID
)
/

CREATE INDEX iItemID ON Charges
(
       ItemID
)
/


ALTER TABLE Charges
       ADD PRIMARY KEY (ChargeID)
/


CREATE TABLE ChargeTypes (
       ChargeTypeID         INTEGER ,
       Description          VARCHAR2(45) NOT NULL,
       StringID             INTEGER NULL,
       Amount               numeric(18,4) NOT NULL,
       TaxGroupID           INTEGER NULL,
       TaxExemptions        INTEGER DEFAULT 0  NOT NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       GLCodeID             INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       ChargeUses           INTEGER DEFAULT 65535  NOT NULL
)
/


ALTER TABLE ChargeTypes
       ADD PRIMARY KEY (ChargeTypeID)
/


CREATE TABLE CommissionGroups (
       CommissionGroupID    INTEGER ,
       CommissionGroup      VARCHAR2(128) NOT NULL,
       CommissionType       smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE CommissionGroups
       ADD PRIMARY KEY (CommissionGroupID)
/


CREATE TABLE CommissionItems (
       CommissionItemID     INTEGER ,
       CommissionGroupID    INTEGER NOT NULL,
       AccountTypeID        INTEGER NULL,
       PackageTypeID        INTEGER NULL,
       ChargeTypeID         INTEGER NULL,
       CommissionValue      numeric(18,4) NOT NULL,
       Comments             VARCHAR2(255) NULL
)
/

CREATE INDEX I_CI_AT ON CommissionItems
(
       CommissionGroupID,
       AccountTypeID
)
/

CREATE INDEX I_CI_PT ON CommissionItems
(
       CommissionGroupID,
       PackageTypeID
)
/

CREATE INDEX I_CI_CT ON CommissionItems
(
       CommissionGroupID,
       ChargeTypeID
)
/


ALTER TABLE CommissionItems
       ADD PRIMARY KEY (CommissionItemID)
/


CREATE TABLE ConfigGroupData (
       ConfigID             INTEGER NOT NULL,
       GroupID              INTEGER NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 VARCHAR2(255) NULL
)
/

CREATE INDEX Statistic_NumValue ON ConfigGroupData
(
       NumValue
)
/


ALTER TABLE ConfigGroupData
       ADD PRIMARY KEY (ConfigID, GroupID)
/


CREATE TABLE ConfigGroups (
       ConfigGroupID        INTEGER NOT NULL,
       Name                 VARCHAR2(128) NOT NULL,
       SortOrder            INTEGER DEFAULT 1  NOT NULL,
       VisibleGlobal        smallint DEFAULT 1  NOT NULL,
       VisibleGroupID       smallint DEFAULT 0  NOT NULL,
       VisibleOperatorGroupID smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE ConfigGroups
       ADD PRIMARY KEY (ConfigGroupID)
/


CREATE TABLE ConfigOperatorGroupData (
       ConfigID             INTEGER NOT NULL,
       OperatorGroupID      INTEGER NOT NULL,
       NumValue             numeric(18,4) NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE ConfigOperatorGroupData
       ADD PRIMARY KEY (ConfigID, OperatorGroupID)
/


CREATE TABLE Configs (
       ConfigID             INTEGER NOT NULL,
       ConfigGroupID        INTEGER NOT NULL,
       DataTypeID           smallint DEFAULT 1  NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       FeatureID            INTEGER NULL,
       AllowGlobal          smallint DEFAULT 1  NOT NULL,
       AllowGroupID         smallint DEFAULT 0  NOT NULL,
       AllowOperatorGroupID smallint DEFAULT 0  NOT NULL,
       ValuesQuery          VARCHAR2(255) NULL,
       NumValue             numeric(18,4) NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE Configs
       ADD PRIMARY KEY (ConfigID)
/


CREATE TABLE ConfigValues (
       ConfigID             INTEGER NOT NULL,
       NumValue             numeric(18,4) NOT NULL,
       ValueName            VARCHAR2(128) NOT NULL
)
/


ALTER TABLE ConfigValues
       ADD PRIMARY KEY (ConfigID, NumValue)
/


CREATE TABLE Continents (
       ContinentID          INTEGER NOT NULL,
       Continent            VARCHAR2(64) NOT NULL,
       Planet               VARCHAR2(64) NOT NULL,
       Hidden               smallint DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE Continents
       ADD PRIMARY KEY (ContinentID)
/


CREATE TABLE Countries (
       CountryID            INTEGER NOT NULL,
       Country              VARCHAR2(64) NOT NULL,
       InternetDomain       VARCHAR2(5) NULL,
       ContinentID          INTEGER NOT NULL,
       TelPrefix            VARCHAR2(10) NULL,
       TelIDD               VARCHAR2(32) NULL,
       TelNDD               VARCHAR2(32) NULL,
       TelLocPrefixLen      smallint NULL,
       Abbr2                char(2) NULL,
       Abbr3                char(3) NULL,
       Hidden               smallint DEFAULT 0  NOT NULL,
       Restricted           smallint DEFAULT 0  NOT NULL,
       Currency             VARCHAR2(5) NULL,
       Comments             VARCHAR2(255) NULL,
       SortOrder            smallint DEFAULT 100  NOT NULL,
       ZipStatus            smallint NULL
)
/

CREATE INDEX IX_Countries ON Countries
(
       Country
)
/


ALTER TABLE Countries
       ADD PRIMARY KEY (CountryID)
/


CREATE TABLE CreditCards (
       CustomerID           INTEGER NOT NULL,
       CardHolder           VARCHAR2(64) NULL,
       CardNumber           VARCHAR2(64) NULL,
       CardTypeID           INTEGER NULL,
       CardLength           INTEGER NULL,
       ExpirationDate       DATE NOT NULL,
       BillToAddress1       VARCHAR2(64) NULL,
       BillToAddress2       VARCHAR2(64) NULL,
       BillToCity           VARCHAR2(64) NULL,
       BillToZip            VARCHAR2(15) NULL,
       BillToCountryID      INTEGER NULL,
       BillToStateID        INTEGER NULL,
       SecurityCode         VARCHAR2(32) NULL,
       Bank                 VARCHAR2(64) NULL,
       BankPhone            VARCHAR2(16) NULL,
       Misc1                VARCHAR2(64) NULL,
       Misc2                VARCHAR2(64) NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL
)
/


ALTER TABLE CreditCards
       ADD PRIMARY KEY (CustomerID)
/


CREATE TABLE Currencies (
       CurrencyID           INTEGER NOT NULL,
       CountryID            INTEGER NULL,
       Currency             VARCHAR2(64) NULL,
       Symbol               VARCHAR2(50) NULL,
       Code                 VARCHAR2(5) NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/

CREATE INDEX i_Currencies_CountryID ON Currencies
(
       CountryID
)
/

CREATE INDEX i_Currencies_Code ON Currencies
(
       Code
)
/


ALTER TABLE Currencies
       ADD PRIMARY KEY (CurrencyID)
/


CREATE TABLE CustomerSettings (
       CustomerID           INTEGER NOT NULL,
       NotifyAcctLimit      smallint DEFAULT 1  NOT NULL,
       NotifyIncidents      smallint DEFAULT 1  NOT NULL,
       NotifyAnnounce       smallint DEFAULT 1  NOT NULL,
       NotifyAcctStatus     smallint DEFAULT 1  NOT NULL,
       NotifyShipStatus     smallint DEFAULT 1  NOT NULL,
       NotifyOffers         smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE CustomerSettings
       ADD PRIMARY KEY (CustomerID)
/


CREATE TABLE DataTypes (
       DataTypeID           smallint NOT NULL,
       DataType             VARCHAR2(64) NOT NULL,
       ConfigsOnly          smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE DataTypes
       ADD PRIMARY KEY (DataTypeID)
/


CREATE TABLE Discounts (
       DiscountID           INTEGER ,
       Discount             VARCHAR2(32) NOT NULL,
       StringID             INTEGER NULL,
       Amount               numeric(18,4) DEFAULT 0  NOT NULL,
       AmountType           smallint DEFAULT 1  NOT NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/

CREATE INDEX i_Discounts_GroupID ON Discounts
(
       GroupID
)
/


ALTER TABLE Discounts
       ADD PRIMARY KEY (DiscountID)
/


CREATE TABLE DNISGroups (
       DNISGroupID          INTEGER ,
       DNISGroup            VARCHAR2(25) NOT NULL,
       Description          VARCHAR2(45) NOT NULL
)
/

CREATE INDEX i_DNISGroups_DNISGroup ON DNISGroups
(
       DNISGroup
)
/


ALTER TABLE DNISGroups
       ADD PRIMARY KEY (DNISGroupID)
/


CREATE TABLE DNISNumbers (
       DNISGroupID          INTEGER NOT NULL,
       DNISNumber           VARCHAR2(20) NOT NULL
)
/


ALTER TABLE DNISNumbers
       ADD PRIMARY KEY (DNISGroupID, DNISNumber)
/


CREATE TABLE Documents (
       DocumentID           INTEGER ,
       CustomerID           INTEGER NULL,
       AccountID            INTEGER NULL,
       Description          VARCHAR2(128) NULL,
       StorageType          INTEGER DEFAULT 0  NOT NULL,
       DocumentSize         INTEGER NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NULL,
       Operator             VARCHAR2(64) NULL,
       ContentType          VARCHAR2(64) NULL,
       Filename             VARCHAR2(64) NULL,
       DocumentData         CLOB NULL
)
/

CREATE INDEX i_Documents_CustomerID ON Documents
(
       CustomerID,
       AccountID
)
/

CREATE INDEX i_Documents_Filename ON Documents
(
       Filename
)
/


ALTER TABLE Documents
       ADD PRIMARY KEY (DocumentID)
/


CREATE TABLE Domains (
       DomainID             INTEGER ,
       Domain               VARCHAR2(40) NOT NULL,
       ServiceGroupID       INT NULL,
       MailDomain           VARCHAR2(40) NOT NULL,
       GroupID              INTEGER NULL,
       Description          VARCHAR2(45) NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       ExternalRef          VARCHAR2(64) NULL,
       CustomerID           INTEGER NULL,
       CustomerAccess       smallint NULL,
       ExpireDate           DATE NULL,
       ExternalDNSRef       VARCHAR2(64) NULL,
       ErrorCount           INTEGER NULL,
       ErrorMessage         VARCHAR2(128) NULL
)
/

CREATE INDEX i_Domains_Domain ON Domains
(
       Domain
)
/

CREATE INDEX i_Domains_MailDomain ON Domains
(
       MailDomain
)
/

CREATE INDEX i_Domains_CustomerID ON Domains
(
       CustomerID
)
/


ALTER TABLE Domains
       ADD PRIMARY KEY (DomainID)
/








CREATE TABLE EmailTypes (
       EmailTypeID          smallint NOT NULL,
       EmailType            VARCHAR2(64) NOT NULL
)
/


ALTER TABLE EmailTypes
       ADD PRIMARY KEY (EmailTypeID)
/


CREATE TABLE ExportColumns (
       ExportColumnID       INTEGER ,
       ExportID             INTEGER NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       FieldName            VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(64) NULL,
       Quoted               smallint NOT NULL,
       MinSize              smallint NOT NULL,
       MaxSize              smallint NOT NULL,
       Align                smallint NOT NULL,
       Format               smallint NOT NULL,
       Padding              char(1) NULL,
       ExportValue          VARCHAR2(100) NULL,
       Include              smallint NOT NULL,
       TransType            INTEGER DEFAULT 511  NOT NULL,
       IEAID                INTEGER NULL
)
/

CREATE INDEX i_ExportColumns_ExportID ON ExportColumns
(
       ExportID
)
/


ALTER TABLE ExportColumns
       ADD PRIMARY KEY (ExportColumnID)
/


CREATE TABLE Exports (
       ExportID             INTEGER NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       Separator            VARCHAR2(6) NULL,
       ImportKeySeparator   VARCHAR2(6) NULL,
       ImportKeyValueSeparator VARCHAR2(6) NULL,
       QuoteString          VARCHAR2(6) NULL,
       SQLString            VARCHAR2(255) NOT NULL,
       HeaderRow            smallint NOT NULL,
       ApproveString        VARCHAR2(100) NULL,
       AuthString           VARCHAR2(100) NULL,
       VoidString           VARCHAR2(100) NULL,
       CreditString         VARCHAR2(100) NULL,
       DeclineString        VARCHAR2(100) NULL,
       ApproveMatch         smallint NULL,
       AuthMatch            smallint NULL,
       VoidMatch            smallint NULL,
       CreditMatch          smallint NULL,
       DeclineMatch         smallint NULL,
       ExportType           smallint NOT NULL,
       Filter               VARCHAR2(16) NULL,
       Lines                smallint NOT NULL,
       FormatDefault        INTEGER DEFAULT 1  NULL,
       DefaultProcessorURL  VARCHAR2(128) NULL,
       Features             INTEGER NULL,
       Template             CLOB NULL,
       StageCount           INTEGER NULL
)
/

CREATE INDEX i_Exports_ExportType ON Exports
(
       ExportType
)
/


ALTER TABLE Exports
       ADD PRIMARY KEY (ExportID)
/


CREATE TABLE ExportTypes (
       ExportTypeID         INTEGER NOT NULL,
       ExportType           VARCHAR2(64) NOT NULL,
       IsBatch              smallint DEFAULT 0  NOT NULL,
       IsRealtime           smallint DEFAULT 0  NOT NULL,
       IsCC                 smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE ExportTypes
       ADD PRIMARY KEY (ExportTypeID)
/


CREATE TABLE ExternalConfigs (
       ExternalConfigID     INTEGER ,
       Application          VARCHAR2(64) NOT NULL,
       Service              VARCHAR2(64) NOT NULL,
       Attribute            VARCHAR2(64) NOT NULL,
       Description          VARCHAR2(255) NULL,
       Type                 INTEGER NULL,
       Value                INTEGER NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE ExternalConfigs
       ADD PRIMARY KEY (ExternalConfigID)
/


CREATE TABLE ExternalSyncs (
       ExternalSyncID       INTEGER ,
       ExternalSystemID     INTEGER NOT NULL,
       AccountID            INTEGER NULL,
       ProcTransID          VARCHAR2(64) NULL,
       Login                VARCHAR2(128) NULL,
       Password             VARCHAR2(128) NULL,
       Aux1                 VARCHAR2(128) NULL,
       Aux2                 VARCHAR2(128) NULL,
       Aux3                 VARCHAR2(128) NULL,
       Active               smallint DEFAULT 0  NOT NULL,
       Created              smallint DEFAULT 0  NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       LastUpdate           DATE NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       ErrorCount           INTEGER DEFAULT 0  NOT NULL,
       Message              VARCHAR2(128) NULL,
       Aux4                 VARCHAR2(128) NULL,
       Aux5                 VARCHAR2(128) NULL,
       Aux6                 VARCHAR2(128) NULL,
       Aux7                 VARCHAR2(128) NULL,
       Aux8                 VARCHAR2(768) NULL
)
/

CREATE INDEX I2_ES_AID_ESID ON ExternalSyncs
(
       AccountID,
       ExternalSystemID
)
/


ALTER TABLE ExternalSyncs
       ADD PRIMARY KEY (ExternalSyncID)
/


CREATE TABLE ExternalSystemAccountTypes (
       ExternalSystemID     INTEGER NOT NULL,
       AccountTypeID        INTEGER NOT NULL,
       Description          VARCHAR2(255) NULL,
       ExternalRef          VARCHAR2(64) NULL
)
/


ALTER TABLE ExternalSystemAccountTypes
       ADD PRIMARY KEY (ExternalSystemID, AccountTypeID)
/


CREATE TABLE ExternalSystemDataTypes (
       ExternalSystemTypeID INTEGER NOT NULL,
       AccountDataTypeID    INTEGER NOT NULL,
       SortOrder            smallint DEFAULT 10  NOT NULL,
       Required             smallint NULL
)
/


ALTER TABLE ExternalSystemDataTypes
       ADD PRIMARY KEY (ExternalSystemTypeID, AccountDataTypeID)
/


CREATE TABLE ExternalSystems (
       ExternalSystemID     INTEGER ,
       Name                 VARCHAR2(32) NOT NULL,
       ExternalSystemTypeID INTEGER NOT NULL,
       ExportID             INTEGER NULL,
       Description          VARCHAR2(50) NULL,
       MailHost             VARCHAR2(40) NULL,
       Login                VARCHAR2(40) NULL,
       Password             VARCHAR2(128) NULL,
       LogFile              VARCHAR2(100) NULL,
       LastSyncDate         DATE NULL,
       FileMode             smallint NOT NULL,
       Aux1                 VARCHAR2(128) NULL,
       Aux2                 VARCHAR2(128) NULL,
       Aux3                 VARCHAR2(128) NULL
)
/

CREATE INDEX i_ExternalSystems_Name ON ExternalSystems
(
       Name
)
/


ALTER TABLE ExternalSystems
       ADD PRIMARY KEY (ExternalSystemID)
/


CREATE TABLE ExternalSystemTypes (
       ExternalSystemTypeID INTEGER NOT NULL,
       ExternalSystemType   VARCHAR2(128) NOT NULL,
       ShowExportID         smallint DEFAULT 1  NOT NULL,
       ShowMailHost         smallint DEFAULT 1  NOT NULL,
       ShowLogin            smallint DEFAULT 1  NOT NULL,
       ShowPassword         smallint DEFAULT 1  NOT NULL,
       ShowURL              smallint DEFAULT 1  NOT NULL,
       ExportID             INT NULL,
       DescAux1             VARCHAR2(64) NULL,
       DescAux2             VARCHAR2(64) NULL,
       DescAux3             VARCHAR2(128) NULL
)
/


ALTER TABLE ExternalSystemTypes
       ADD PRIMARY KEY (ExternalSystemTypeID)
/


CREATE TABLE ExternalTrans (
       ExternalTransID      INTEGER ,
       BatchID              INTEGER NULL,
       BatchOutID           INTEGER NULL,
       BatchInID            INTEGER NULL,
       CustomerID           INTEGER NOT NULL,
       InvoiceID            INTEGER NULL,
       BatchProcessorID     INTEGER NOT NULL,
       TransStateID         INTEGER DEFAULT 0  NOT NULL,
       TransTypeID          INTEGER NOT NULL,
       ReqDate              DATE DEFAULT SYSDATE  NOT NULL,
       ExportDate           DATE NULL,
       ProcDate             DATE NULL,
       Amount               numeric(18,4) NOT NULL,
       PaymentID            INTEGER NULL,
       ApproveCode          VARCHAR2(12) NULL,
       Response             VARCHAR2(50) NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       AccountNumber        VARCHAR2(128) NULL,
       AccountExpire        DATE NULL,
       AuthName             VARCHAR2(64) NULL,
       AuthAddress          VARCHAR2(64) NULL,
       AuthStateID          INTEGER NULL,
       AuthZip              VARCHAR2(15) NULL,
       AuthSecurityCode     VARCHAR2(64) NULL,
       ProcTransID          VARCHAR2(64) NULL,
       BankName             VARCHAR2(64) NULL,
       BankNumber           VARCHAR2(128) NULL,
       BankPhone            VARCHAR2(20) NULL,
       BankTransType        VARCHAR2(16) NULL,
       RebatchTries         smallint NULL,
       LastRebatchTry       DATE NOT NULL,
       SSN                  VARCHAR2(128) NULL,
       DLNumber             VARCHAR2(128) NULL,
       DLState              VARCHAR2(40) NULL,
       BirthDate            DATE NULL,
       StatementID          INTEGER NULL,
       AutoBill             smallint DEFAULT 0  NOT NULL
)
/

CREATE INDEX i_ET_CustomerID ON ExternalTrans
(
       CustomerID
)
/

CREATE INDEX i_ET_TransStateID ON ExternalTrans
(
       TransStateID
)
/

CREATE INDEX i_ET_PaymentID ON ExternalTrans
(
       PaymentID
)
/

CREATE INDEX i_ET_BatchProcessorID ON ExternalTrans
(
       BatchProcessorID
)
/


ALTER TABLE ExternalTrans
       ADD PRIMARY KEY (ExternalTransID)
/


CREATE TABLE FileTransfers (
       TransferDate         DATE NOT NULL,
       AccountID            INTEGER NOT NULL,
       FileName             VARCHAR2(100) NOT NULL,
       NumBytes             INTEGER NOT NULL,
       Direction            smallint DEFAULT 0  NOT NULL,
       Processed            smallint NULL
)
/

CREATE INDEX XIE1FileTransfers ON FileTransfers
(
       TransferDate,
       AccountID,
       FileName
)
/


ALTER TABLE FileTransfers
       ADD PRIMARY KEY (TransferDate, AccountID, FileName, NumBytes, 
              Direction)
/


CREATE TABLE FilterTypes (
       FilterTypeID         INTEGER ,
       FilterType           VARCHAR2(30) NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       Checked              INTEGER DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE FilterTypes
       ADD PRIMARY KEY (FilterTypeID)
/


CREATE TABLE FlowFilterGroups (
       FlowFilterGroupID    INTEGER ,
       FlowFilterGroup      VARCHAR2(32) NULL,
       Description          VARCHAR2(64) NULL,
       SortOrder            INTEGER DEFAULT 1  NOT NULL,
       AccountID            INTEGER NULL,
       SummaryMode          INTEGER NULL,
       CacheExpire          INTEGER NULL
)
/


ALTER TABLE FlowFilterGroups
       ADD PRIMARY KEY (FlowFilterGroupID)
/


CREATE TABLE FlowFilters (
       FlowFilterID         INTEGER ,
       FlowFilterGroupID    INTEGER NOT NULL,
       FilterType           INTEGER DEFAULT 1  NOT NULL,
       SortOrder            INTEGER NOT NULL,
       SrcIP                VARCHAR2(16) NULL,
       SrcMask              VARCHAR2(16) NULL,
       SrcPort              INTEGER NULL,
       DestIP               VARCHAR2(16) NULL,
       DestMask             VARCHAR2(16) NULL,
       DestPort             INTEGER NULL,
       Prot                 INTEGER NULL,
       CacheExpire          INTEGER NULL,
       SummaryMode          INTEGER NULL
)
/


ALTER TABLE FlowFilters
       ADD PRIMARY KEY (FlowFilterID)
/


CREATE TABLE Flows (
       FlowDate             DATE NOT NULL,
       SrcIP                INTEGER NOT NULL,
       DestIP               INTEGER NOT NULL,
       SrcPort              INTEGER NOT NULL,
       DestPort             INTEGER NOT NULL,
       Prot                 INTEGER NOT NULL,
       Packets              INTEGER NOT NULL,
       Octets               INTEGER NOT NULL,
       AccountID            INTEGER NULL,
       FlowFilterID         INTEGER NULL,
       ROWGUID              INTEGER NOT NULL
)
/

CREATE INDEX iFlowDate ON Flows
(
       FlowDate
)
/


ALTER TABLE Flows
       ADD PRIMARY KEY (ROWGUID)
/


CREATE TABLE Forwards (
       ForwardID            INTEGER ,
       Forward              VARCHAR2(64) NOT NULL,
       AccountID            INTEGER NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL
)
/

CREATE INDEX i_Forwards_AccountID ON Forwards
(
       AccountID
)
/


ALTER TABLE Forwards
       ADD PRIMARY KEY (ForwardID)
/


CREATE TABLE GLCodes (
       GLCodeID             INTEGER ,
       GLCode               VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(128) NOT NULL,
       DetailFlag           smallint NULL
)
/


ALTER TABLE GLCodes
       ADD PRIMARY KEY (GLCodeID)
/


CREATE TABLE Groups (
       GroupID              INTEGER ,
       OrganizationID       INTEGER NOT NULL,
       DomainID             INTEGER NOT NULL,
       GroupName            VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(45) NOT NULL,
       ReportLogoURL        VARCHAR2(128) NULL,
       InvoiceReport        VARCHAR2(45) NULL,
       InvoiceTextReport    VARCHAR2(45) NULL,
       InvoiceHTMLReport    VARCHAR2(45) NULL,
       StatementReport      VARCHAR2(45) NULL,
       StatementTextReport  VARCHAR2(45) NULL,
       StatementHTMLReport  VARCHAR2(45) NULL,
       GlobalAccountTypes   smallint DEFAULT 1  NOT NULL,
       GlobalBillingCycles  smallint DEFAULT 1  NOT NULL,
       GlobalRegions        smallint DEFAULT 1  NOT NULL,
       GlobalPayPeriods     smallint DEFAULT 1  NOT NULL,
       GlobalDiscounts      smallint DEFAULT 1  NOT NULL,
       GlobalChargeTypes    smallint DEFAULT 1  NOT NULL,
       GlobalPackageTypes   smallint DEFAULT 1  NOT NULL,
       GlobalDomains        smallint DEFAULT 1  NOT NULL,
       GlobalSalesPersons   smallint DEFAULT 1  NOT NULL,
       GlobalSendMethods    smallint DEFAULT 1  NOT NULL,
       GlobalIncidentTypes  smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       FTPDir               VARCHAR2(64) NULL,
       BillingOption        smallint NULL,
       SendCredits          smallint DEFAULT 0  NULL,
       BillName             VARCHAR2(50) NOT NULL,
       BillAddress1         VARCHAR2(50) NOT NULL,
       BillAddress2         VARCHAR2(50) NULL,
       BillCity             VARCHAR2(50) NOT NULL,
       BillState            VARCHAR2(50) NOT NULL,
       BillZip              VARCHAR2(32) NULL,
       BillCountryID        INTEGER NULL,
       BillPhone            VARCHAR2(32) NULL,
       BillFax              VARCHAR2(32) NULL,
       EmailAccounts        VARCHAR2(64) NOT NULL,
       EmailSubject         VARCHAR2(64) NOT NULL,
       AutoEmailInvoices    smallint DEFAULT 0  NOT NULL,
       AutoEmailStatements  smallint DEFAULT 1  NOT NULL,
       ThemeID              INTEGER NULL,
       ThemeScore           INTEGER NULL,
       StartDate            DATE NULL,
       EndDate              DATE NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       MBRFields            INTEGER DEFAULT 65535  NOT NULL,
       PaymentTypes         INTEGER DEFAULT 65535  NOT NULL,
       PrintInvoices        smallint NULL,
       PrintStatements      smallint NULL
)
/

CREATE INDEX i_Groups_DomainID ON Groups
(
       DomainID
)
/

CREATE INDEX I_Groups_OrganizationID ON Groups
(
       OrganizationID
)
/

CREATE INDEX i_Groups_GroupName ON Groups
(
       GroupName
)
/


ALTER TABLE Groups
       ADD PRIMARY KEY (GroupID)
/


CREATE TABLE IEALocks (
       IEALockID            INTEGER NOT NULL,
       IEALock              VARCHAR2(128) NOT NULL,
       RefCount             INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE IEALocks
       ADD PRIMARY KEY (IEALockID)
/


CREATE TABLE IncidentData (
       IncidentID           INTEGER NOT NULL,
       IncidentDataTypeID   INTEGER NOT NULL,
       Data                 VARCHAR2(255) NULL
)
/

CREATE INDEX IX_IncidentData ON IncidentData
(
       Data
)
/

CREATE INDEX x_IncidentData_IDTID ON IncidentData
(
       IncidentDataTypeID
)
/


ALTER TABLE IncidentData
       ADD PRIMARY KEY (IncidentID, IncidentDataTypeID)
/


CREATE TABLE IncidentDataTypes (
       IncidentDataTypeID   INTEGER ,
       IncidentTypeID       INTEGER NOT NULL,
       IncidentDataType     VARCHAR2(128) NOT NULL,
       DataTypeID           smallint DEFAULT 0  NOT NULL,
       Searchable           smallint DEFAULT 1  NOT NULL,
       CustomerAccess       smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       Required             smallint NULL,
       RegExp               VARCHAR2(255) NULL,
       SQLQuery             CLOB NULL,
       IncidentTemplateID   INTEGER NULL
)
/


ALTER TABLE IncidentDataTypes
       ADD PRIMARY KEY (IncidentDataTypeID)
/


CREATE TABLE Incidents (
       IncidentID           INTEGER ,
       AccountID            INTEGER NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       IncidentTypeID       INTEGER NOT NULL,
       IncidentStateID      INTEGER NOT NULL,
       CreateOperatorID     INTEGER NULL,
       CreateAccountID      INTEGER NULL,
       Summary              CLOB NULL,
       Description          CLOB NULL,
       CustomerAccess       smallint DEFAULT 0  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       Duration             INTEGER DEFAULT 0  NOT NULL,
       Email                VARCHAR2(80) NULL,
       AssignRoleID         INTEGER NULL,
       AssignOperatorID     INTEGER NULL,
       DueDate              DATE NULL,
       PriorityID           smallint DEFAULT 0  NOT NULL
)
/

CREATE INDEX i_Incidents_AccountID ON Incidents
(
       AccountID
)
/

CREATE INDEX i_Incidents_Date ON Incidents
(
       CreateDate
)
/

CREATE INDEX i_Incidents_IncidentTypeID ON Incidents
(
       IncidentTypeID
)
/

CREATE INDEX i_Incidents_IncidentStateID ON Incidents
(
       IncidentStateID
)
/

CREATE INDEX i_Incidents_CreateOperatorID ON Incidents
(
       CreateOperatorID
)
/

CREATE INDEX i_Incidents_AssignRoleID ON Incidents
(
       AssignRoleID
)
/

CREATE INDEX i_Incidents_AssignOperatorID ON Incidents
(
       AssignOperatorID
)
/

CREATE INDEX i_Incidents_DueDate ON Incidents
(
       DueDate
)
/


ALTER TABLE Incidents
       ADD PRIMARY KEY (IncidentID)
/


CREATE TABLE IncidentStateGroups (
       IncidentStateGroupID INTEGER ,
       IncidentStateGroup   VARCHAR2(128) NOT NULL
)
/


ALTER TABLE IncidentStateGroups
       ADD PRIMARY KEY (IncidentStateGroupID)
/


CREATE TABLE IncidentStates (
       IncidentStateID      INTEGER ,
       IncidentStateGroupID INTEGER NULL,
       StatOpen             smallint DEFAULT 0  NOT NULL,
       StatWait             smallint DEFAULT 0  NOT NULL,
       StatEscalate         smallint DEFAULT 0  NOT NULL,
       StatBlock            smallint DEFAULT 0  NOT NULL,
       StatArchive          smallint DEFAULT 0  NOT NULL,
       IncidentState        VARCHAR2(64) NOT NULL,
       CustomerAccess       smallint DEFAULT 1  NOT NULL,
       Description          VARCHAR2(255) NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       Style                VARCHAR2(255) NULL,
       Priority             smallint DEFAULT 0  NOT NULL,
       ActionOnly           smallint NULL
)
/

CREATE INDEX i_IncidentStates_ISG ON IncidentStates
(
       IncidentStateGroupID
)
/


ALTER TABLE IncidentStates
       ADD PRIMARY KEY (IncidentStateID)
/


CREATE TABLE IncidentTemplates (
       IncidentTemplateID   INTEGER NOT NULL,
       IncidentTemplate     VARCHAR2(128) NOT NULL,
       IncidentEdit         VARCHAR2(64) NULL,
       IncidentSave         VARCHAR2(64) NULL,
       CustIncidentEdit     VARCHAR2(64) NULL,
       CustIncidentSave     VARCHAR2(64) NULL,
       SortOrder            smallint DEFAULT (0)  NOT NULL
)
/


ALTER TABLE IncidentTemplates
       ADD PRIMARY KEY (IncidentTemplateID)
/


CREATE TABLE IncidentTypes (
       IncidentTypeID       INTEGER ,
       IncidentStateGroupID INTEGER NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       IncidentType         VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(64) DEFAULT null  NOT NULL,
       Email                VARCHAR2(64) DEFAULT null  NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       OverDays             smallint NULL,
       EscalateDays         smallint NULL,
       WarnDays             smallint NULL,
       RoleID               INTEGER NULL,
       CustomerAccess       smallint DEFAULT 0  NOT NULL,
       ShowPriority         smallint DEFAULT 0  NOT NULL,
       ShowEmail            smallint DEFAULT 0  NOT NULL,
       ShowDuration         smallint DEFAULT 0  NOT NULL,
       ShowDueDate          smallint DEFAULT 0  NOT NULL,
       ShowCustomerAccess   smallint DEFAULT 0  NOT NULL,
       ShowSummary          smallint DEFAULT 0  NOT NULL,
       ShowCustDueDate      smallint DEFAULT 0  NOT NULL,
       EnableOperatorRole   smallint NULL
)
/

CREATE INDEX i_IncidentTypes_GroupID ON IncidentTypes
(
       GroupID
)
/


ALTER TABLE IncidentTypes
       ADD PRIMARY KEY (IncidentTypeID)
/


CREATE TABLE IncidentValues (
       IncidentDataTypeID   INTEGER NOT NULL,
       NumValue             INTEGER NOT NULL,
       ValueName            VARCHAR2(128) NOT NULL
)
/


ALTER TABLE IncidentValues
       ADD PRIMARY KEY (IncidentDataTypeID, NumValue)
/


CREATE TABLE InvoiceItems (
       ItemID               INTEGER ,
       InvoiceID            INTEGER NOT NULL,
       ItemType             INTEGER DEFAULT 1  NOT NULL,
       Login                VARCHAR2(64) NULL,
       Days                 smallint DEFAULT 0  NOT NULL,
       Description          VARCHAR2(128) NULL,
       StartDate            DATE NOT NULL,
       EndDate              DATE NOT NULL,
       AccountID            INTEGER NULL,
       PackageID            INTEGER NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             INTEGER NOT NULL,
       TaxID                INTEGER NULL,
       TaxGroupID           INTEGER NULL,
       PaidAmount           numeric(18,4) DEFAULT 0  NOT NULL,
       AccountTypeID        INTEGER NULL,
       ChargeID             INTEGER NULL,
       ChargeTypeID         INTEGER NULL,
       PackageTypeID        INTEGER NULL,
       GLState              smallint NULL,
       Canceled             smallint DEFAULT 0  NOT NULL,
       CycleMonths          smallint NULL,
       BillStatus           smallint NULL,
       PaidFlag             smallint DEFAULT 0  NOT NULL,
       ParentItemID         INTEGER NULL
)
/

CREATE INDEX iInvoiceID ON InvoiceItems
(
       InvoiceID
)
/

CREATE INDEX i_InvoiceItems_AID ON InvoiceItems
(
       AccountID,
       InvoiceID
)
/


ALTER TABLE InvoiceItems
       ADD PRIMARY KEY (ItemID)
/


CREATE TABLE InvoiceItemTypes (
       InvoiceItemTypeID    INTEGER NOT NULL,
       InvoiceItemType      VARCHAR2(32) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE InvoiceItemTypes
       ADD PRIMARY KEY (InvoiceItemTypeID)
/


CREATE TABLE Invoices (
       InvoiceID            INTEGER ,
       BatchID              INTEGER NULL,
       CustomerID           INTEGER NOT NULL,
       InvoiceTypeID        INTEGER NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       ChargeAmount         numeric(18,4) DEFAULT 0  NOT NULL,
       PaidAmount           numeric(18,4) DEFAULT 0  NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       SentDate             DATE DEFAULT null  NULL,
       Tax                  numeric(18,4) DEFAULT 0  NOT NULL,
       StatementID          INTEGER NULL,
       VoidDate             DATE NULL,
       VoidStatementID      INTEGER NULL,
       PO                   VARCHAR2(25) NULL,
       Comments             VARCHAR2(100) NULL,
       PrintDate            DATE NULL,
       EmailDate            DATE NULL,
       PrintBatchID         INTEGER NULL,
       Estimate             smallint DEFAULT 0  NOT NULL,
       Processed            smallint DEFAULT 1  NOT NULL,
       ExtInvoiceNum        VARCHAR2(20) NULL
)
/

CREATE INDEX iCustomerID_2 ON Invoices
(
       CustomerID
)
/

CREATE INDEX i_Invoices_PrintBatchID ON Invoices
(
       PrintBatchID
)
/

CREATE INDEX i_Invoices_VoidStatementID ON Invoices
(
       VoidStatementID
)
/

CREATE INDEX i_Invoices_ExtInvoiceNum ON Invoices
(
       ExtInvoiceNum
)
/

CREATE INDEX i_Invoices_StatementID ON Invoices
(
       StatementID
)
/


ALTER TABLE Invoices
       ADD PRIMARY KEY (InvoiceID)
/


CREATE TABLE InvoiceTypes (
       InvoiceTypeID        INTEGER NOT NULL,
       InvoiceType          VARCHAR2(32) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE InvoiceTypes
       ADD PRIMARY KEY (InvoiceTypeID)
/


CREATE TABLE IPClasses (
       IPClassID            INTEGER NOT NULL,
       IPClass              VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(64) NULL,
       LastModifyDate       DATE NOT NULL,
       LastModifyUser       VARCHAR2(64) NOT NULL
)
/


ALTER TABLE IPClasses
       ADD PRIMARY KEY (IPClassID)
/


CREATE TABLE IPs (
       IPID                 INTEGER NOT NULL,
       IP                   VARCHAR2(16) NOT NULL,
       IPClassID            INTEGER NOT NULL,
       LastModifyDate       DATE NOT NULL,
       LastModifyUser       VARCHAR2(64) NOT NULL
)
/


ALTER TABLE IPs
       ADD PRIMARY KEY (IPID)
/


CREATE TABLE Languages (
       LanguageID           INTEGER NOT NULL,
       Description          VARCHAR2(30) NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       BaseURL              VARCHAR2(128) NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       HttpAcceptLanguage   VARCHAR2(64) NULL,
       AllowIEAUpdate       smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE Languages
       ADD PRIMARY KEY (LanguageID)
/


CREATE TABLE LateFees (
       LateFeeID            INTEGER ,
       LateFee              VARCHAR2(64) NOT NULL,
       ChargeTypeID         INTEGER NOT NULL,
       MinAmount            numeric(18,4) NULL,
       MaxAmount            numeric(18,4) NULL,
       MinDays              smallint DEFAULT 30  NOT NULL,
       Percentage           numeric(18,4) NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE LateFees
       ADD PRIMARY KEY (LateFeeID)
/


CREATE TABLE LDAPServers (
       LDAPServer           VARCHAR2(50) NOT NULL,
       LastModifyDate       DATE NOT NULL,
       LastSyncRead         DATE NOT NULL,
       LastSyncWrite        DATE NOT NULL,
       Calls                INTEGER NULL
)
/


ALTER TABLE LDAPServers
       ADD PRIMARY KEY (LDAPServer)
/


CREATE TABLE Licenses (
       LicenseID            VARCHAR2(50) NOT NULL,
       Company              VARCHAR2(80) NOT NULL
)
/


ALTER TABLE Licenses
       ADD PRIMARY KEY (LicenseID)
/


CREATE TABLE LocPhones (
       Prefix               VARCHAR2(12) NOT NULL,
       StateID              INTEGER NOT NULL,
       City                 VARCHAR2(64) NOT NULL,
       Lat                  NUMBER NULL,
       "Long"                 NUMBER NULL,
       Telco                VARCHAR2(64) NULL
)
/


ALTER TABLE LocPhones
       ADD PRIMARY KEY (Prefix, StateID)
/


CREATE TABLE LocZipCodes (
       ZipCode              VARCHAR2(15) NOT NULL,
       StateID              INTEGER NOT NULL,
       City                 VARCHAR2(64) NOT NULL,
       County               VARCHAR2(64) NULL,
       Lat                  NUMBER NULL,
       "Long"                 NUMBER NULL
)
/


ALTER TABLE LocZipCodes
       ADD PRIMARY KEY (ZipCode, StateID)
/


CREATE TABLE LogMsgs (
       LogMsgID             INTEGER NOT NULL,
       Description          VARCHAR2(50) DEFAULT 'Undefined'  NOT NULL,
       StringID             INTEGER NULL,
       Severity             INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE LogMsgs
       ADD PRIMARY KEY (LogMsgID)
/


CREATE TABLE Logs (
       LogID                INTEGER ,
       LogMsgID             INTEGER NOT NULL,
       LogDate              DATE DEFAULT SYSDATE  NOT NULL,
       LogMsg               VARCHAR2(255) NOT NULL,
       Operator             VARCHAR2(64) NULL,
       CustomerID           INTEGER NULL,
       AccountID            INTEGER NULL,
       BatchID              INTEGER NULL
)
/

CREATE INDEX i_Logs_LogDate_2 ON Logs
(
       LogDate,
       CustomerID,
       AccountID
)
/


ALTER TABLE Logs
       ADD PRIMARY KEY (LogID)
/


CREATE TABLE MailLogs (
       MailLogID            INTEGER ,
       LogDate              DATE DEFAULT SYSDATE  NOT NULL,
       LogMsgID             INTEGER NOT NULL,
       CustomerID           INTEGER NOT NULL,
       TokenID              INTEGER NULL,
       Sent                 smallint DEFAULT 1  NOT NULL,
       LogDescription       VARCHAR2(255) NULL
)
/

CREATE INDEX IX_MailLogs ON MailLogs
(
       LogDate,
       CustomerID
)
/


ALTER TABLE MailLogs
       ADD PRIMARY KEY (MailLogID)
/


CREATE TABLE MasterAccountData (
       CustomerID           INTEGER NOT NULL,
       AccountDataTypeID    INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/


ALTER TABLE MasterAccountData
       ADD PRIMARY KEY (CustomerID, AccountDataTypeID)
/


CREATE TABLE MasterAccountDataTypes (
       MasterAccountDataTypeID INTEGER ,
       GroupID              INTEGER NULL,
       AccountDataTypeID    INTEGER NOT NULL,
       SortOrder            smallint DEFAULT 10  NOT NULL,
       Required             smallint NULL,
       ServiceGroupID       INTEGER NULL
)
/

CREATE UNIQUE INDEX IX_MasterAccountDataTypes ON MasterAccountDataTypes
(
       GroupID,
       AccountDataTypeID
)
/


ALTER TABLE MasterAccountDataTypes
       ADD PRIMARY KEY (MasterAccountDataTypeID)
/


CREATE TABLE MasterAccounts (
       CustomerID           INTEGER ,
       LastStatementID      INTEGER NULL,
       FirstName            VARCHAR2(40) NOT NULL,
       MiddleName           VARCHAR2(25) NULL,
       LastName             VARCHAR2(40) NOT NULL,
       Company              VARCHAR2(60) NULL,
       CountryID            INTEGER NULL,
       StateID              INTEGER NULL,
       Address1             VARCHAR2(64) NULL,
       Address2             VARCHAR2(64) NULL,
       City                 VARCHAR2(45) NULL,
       Zip                  VARCHAR2(15) NULL,
       PhoneHome            VARCHAR2(32) NULL,
       PhoneWork            VARCHAR2(32) NULL,
       Gender               VARCHAR2(1) NULL,
       BirthDate            DATE NULL,
       Salutation           VARCHAR2(4) NULL,
       PhoneFax             VARCHAR2(32) NULL,
       Email                VARCHAR2(64) NULL,
       TaxExemptions        INTEGER DEFAULT 0  NOT NULL,
       RegionID             INTEGER NULL,
       ReferredByID         INTEGER NULL,
       SalesPersonID        INTEGER NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       StartDate            DATE DEFAULT SYSDATE  NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       LanguageID           INTEGER NULL,
       PayPeriodID          INTEGER NOT NULL,
       PaymentTypeID        INTEGER DEFAULT 1  NOT NULL,
       LastReceived         DATE DEFAULT SYSDATE  NOT NULL,
       LastLateFee          DATE NULL,
       Comments             CLOB NULL,
       Status               smallint DEFAULT 1  NOT NULL,
       GroupID              INTEGER NOT NULL,
       OverDue              smallint DEFAULT 0  NULL,
       SendMethodID         INTEGER NOT NULL,
       OverLimit            numeric(18,4) DEFAULT 0  NOT NULL,
       BillingCycleID       INTEGER NOT NULL,
       BillDay              smallint DEFAULT 1  NOT NULL,
       CancelDate           DATE NULL,
       CancelReasonID       INTEGER NULL,
       Balance              numeric(18,4) DEFAULT 0  NOT NULL,
       Over30Count          smallint DEFAULT 0  NOT NULL,
       Over60Count          smallint DEFAULT 0  NOT NULL,
       Over90Count          smallint DEFAULT 0  NOT NULL,
       Over120Count         smallint DEFAULT 0  NOT NULL,
       MaxAgedDays          INTEGER DEFAULT 0  NULL,
       AgedDate             DATE NULL,
       PendingBalance       numeric(18,4) DEFAULT 0  NOT NULL,
       NoticeDate           DATE NULL,
       PayInfo              VARCHAR2(50) NULL,
       Operator             VARCHAR2(64) DEFAULT (user)  NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       TransHoldDate        DATE NULL
)
/

CREATE INDEX iCompany ON MasterAccounts
(
       Company
)
/

CREATE INDEX IX_MasterAccounts_Country ON MasterAccounts
(
       CountryID,
       StateID
)
/

CREATE INDEX IX_MasterAccounts_Email ON MasterAccounts
(
       Email
)
/

CREATE INDEX i_MBR_PhoneHome ON MasterAccounts
(
       PhoneHome
)
/

CREATE INDEX i_MBR_PhoneWork ON MasterAccounts
(
       PhoneWork
)
/

CREATE INDEX i_MBR_PhoneFax ON MasterAccounts
(
       PhoneFax
)
/

CREATE INDEX iLastName ON MasterAccounts
(
       LastName
)
/

CREATE INDEX iBillingCycleID ON MasterAccounts
(
       BillingCycleID
)
/

CREATE INDEX i_MasterAccounts_GroupID ON MasterAccounts
(
       GroupID
)
/

CREATE INDEX i_MasterAccounts_LastMDate ON MasterAccounts
(
       LastModifyDate
)
/

CREATE INDEX i_MasterAccounts_Active ON MasterAccounts
(
       Active
)
/

CREATE INDEX i_MasterAccounts_CancelDate ON MasterAccounts
(
       CancelDate
)
/

CREATE INDEX IX_MasterAccounts_FirstName ON MasterAccounts
(
       FirstName
)
/

CREATE INDEX IX_MasterAccounts_Region ON MasterAccounts
(
       RegionID
)
/


ALTER TABLE MasterAccounts
       ADD PRIMARY KEY (CustomerID)
/


CREATE TABLE MenuItems (
       MenuItemID           INTEGER NOT NULL,
       MenuItem             VARCHAR2(128) NOT NULL,
       Label                VARCHAR2(64) NOT NULL,
       TableName            VARCHAR2(64) NULL,
       ColumnName           VARCHAR2(64) NULL,
       FileName             VARCHAR2(64) NULL,
       "Access"               VARCHAR2(16) NULL,
       Condition            VARCHAR2(255) NULL,
       FeatureID            INTEGER NULL,
       Description          VARCHAR2(128) NOT NULL,
       DescStringID         INTEGER NULL,
       HelpStringID         INTEGER NULL,
       AccessKey            VARCHAR2(5) NULL,
       Link                 VARCHAR2(255) NOT NULL,
       Attribute            VARCHAR2(255) NULL
)
/


ALTER TABLE MenuItems
       ADD PRIMARY KEY (MenuItemID)
/


CREATE TABLE Menus (
       MenuID               INTEGER NOT NULL,
       Menu                 VARCHAR2(128) NOT NULL,
       Description          CLOB NULL,
       Class                VARCHAR2(64) NULL
)
/


ALTER TABLE Menus
       ADD PRIMARY KEY (MenuID)
/


CREATE TABLE MenuSets (
       MenuID               INTEGER NOT NULL,
       MenuItemID           INTEGER NOT NULL,
       GroupID              INTEGER NULL,
       SortOrder            INTEGER NOT NULL
)
/


ALTER TABLE MenuSets
       ADD PRIMARY KEY (MenuID, MenuItemID)
/


CREATE TABLE MetaColumns (
       MetaColumnID         INTEGER ,
       MetaTableID          INTEGER NULL,
       ColumnName           VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(255) NOT NULL,
       StringID             INTEGER NULL,
       DepTable             VARCHAR2(32) NULL,
       DepColumn            VARCHAR2(32) NULL,
       DepGroup             INTEGER NULL,
       MetaRuleID           INTEGER NULL,
       Required             smallint NULL,
       Nullable             smallint NULL,
       Quoted               smallint NULL,
       MinSize              INTEGER NULL,
       MaxSize              INTEGER NULL,
       IsKey                smallint NULL,
       ColumnType           INTEGER NULL,
       HelpText             CLOB NULL,
       RegExp               VARCHAR2(255) NULL,
       CheckQuery           VARCHAR2(255) NULL
)
/

CREATE INDEX i_MetaColumns_IsKey ON MetaColumns
(
       MetaTableID,
       IsKey
)
/

CREATE INDEX i_MetaColumns_MTID_MC ON MetaColumns
(
       MetaTableID,
       ColumnName
)
/


ALTER TABLE MetaColumns
       ADD PRIMARY KEY (MetaColumnID)
/


CREATE TABLE MetaRules (
       MetaRuleID           INTEGER NOT NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE MetaRules
       ADD PRIMARY KEY (MetaRuleID)
/


CREATE TABLE MetaTableGroups (
       MetaTableGroupID     INTEGER NOT NULL,
       GroupName            VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(255) NOT NULL
)
/


ALTER TABLE MetaTableGroups
       ADD PRIMARY KEY (MetaTableGroupID)
/


CREATE TABLE MetaTables (
       MetaTableID          INTEGER ,
       TableName            VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(255) NOT NULL,
       GroupTable           VARCHAR2(32) NULL,
       SortOrder            INTEGER NULL,
       GroupName            VARCHAR2(15) NULL
)
/

CREATE UNIQUE INDEX XAK1MetaTables ON MetaTables
(
       TableName
)
/


ALTER TABLE MetaTables
       ADD PRIMARY KEY (MetaTableID)
/


CREATE TABLE NoticeActives (
       NoticeID             INTEGER NOT NULL,
       CustomerID           INTEGER NULL,
       AccountID            INTEGER NULL,
       TokenID              INTEGER NULL,
       SubTokenID           INTEGER NULL
)
/

CREATE UNIQUE INDEX IX_NoticeActives ON NoticeActives
(
       NoticeID,
       CustomerID,
       AccountID,
       TokenID,
       SubTokenID
)
/

CREATE INDEX i_NoticeActives_CustomerID ON NoticeActives
(
       CustomerID
)
/


CREATE TABLE NoticeLogs (
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       NoticeLogID          INTEGER ,
       CustomerID           INTEGER NULL,
       AccountID            INTEGER NULL,
       NoticeID             INTEGER NOT NULL
)
/

CREATE INDEX iNoticeLogs_CustomerID ON NoticeLogs
(
       CustomerID
)
/

CREATE INDEX iNoticeLogs_AccountID ON NoticeLogs
(
       AccountID
)
/


ALTER TABLE NoticeLogs
       ADD PRIMARY KEY (CreateDate, NoticeLogID)
/


CREATE TABLE NoticeParmTypes (
       NoticeParmTypeID     smallint NOT NULL,
       SQLQuery             CLOB NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE NoticeParmTypes
       ADD PRIMARY KEY (NoticeParmTypeID)
/


CREATE TABLE Notices (
       NoticeID             INTEGER ,
       NoticeTypeID         INTEGER NOT NULL,
       Active               INTEGER DEFAULT 1  NOT NULL,
       Notice               VARCHAR2(64) NOT NULL,
       MailFrom             VARCHAR2(128) NULL,
       MailSubject          VARCHAR2(128) NULL,
       MailCC               VARCHAR2(128) NULL,
       NoticeText           CLOB NOT NULL,
       Parm1                VARCHAR2(64) NULL,
       Parm2                VARCHAR2(64) NULL,
       Parm3                VARCHAR2(64) NULL,
       LastRunDate          DATE NULL,
       InternalID           smallint NULL
)
/


ALTER TABLE Notices
       ADD PRIMARY KEY (NoticeID)
/


CREATE TABLE NoticeTypes (
       NoticeTypeID         INTEGER ,
       IEATag               INTEGER NULL,
       NoticeType           VARCHAR2(64) NOT NULL,
       Description          CLOB NULL,
       DefaultText          CLOB NULL,
       SQLQuery             CLOB NOT NULL,
       SentQuery            CLOB NULL,
       ReportFile           VARCHAR2(45) NULL,
       Parm1Desc            VARCHAR2(64) NULL,
       Parm2Desc            VARCHAR2(64) NULL,
       Parm3Desc            VARCHAR2(64) NULL,
       Parm1TypeID          smallint NULL,
       Parm2TypeID          smallint NULL,
       Parm3TypeID          smallint NULL,
       InternalID           smallint NULL,
       Parm1Query           CLOB NULL,
       Parm2Query           CLOB NULL,
       Parm3Query           CLOB NULL,
       IEAID                INTEGER NULL
)
/

CREATE INDEX IX_NoticeTypes ON NoticeTypes
(
       InternalID
)
/


ALTER TABLE NoticeTypes
       ADD PRIMARY KEY (NoticeTypeID)
/


CREATE TABLE ObjectGroups (
       ObjectGroupID        INTEGER NOT NULL,
       ReportID             INTEGER NULL,
       ObjectGroup          VARCHAR2(32) NOT NULL,
       Description          CLOB NULL
)
/


ALTER TABLE ObjectGroups
       ADD PRIMARY KEY (ObjectGroupID)
/


CREATE TABLE Objects (
       ObjectID             INTEGER ,
       ObjectGroupID        INTEGER NOT NULL,
       ObjectTypeID         INTEGER NOT NULL,
       Value                INTEGER NULL,
       Data                 VARCHAR2(80) NULL,
       Description          VARCHAR2(16) NULL
)
/


ALTER TABLE Objects
       ADD PRIMARY KEY (ObjectID)
/


CREATE TABLE OnlineSignups (
       OnlineSignupID       INTEGER ,
       FirstName            VARCHAR2(40) NULL,
       LastName             VARCHAR2(40) NULL,
       Address1             VARCHAR2(100) NULL,
       Address2             VARCHAR2(100) NULL,
       City                 VARCHAR2(50) NULL,
       State                VARCHAR2(50) NULL,
       Province             VARCHAR2(50) NULL,
       Zip                  VARCHAR2(16) NULL,
       Country              VARCHAR2(50) NULL,
       ReferredBy           VARCHAR2(25) NULL,
       Region               VARCHAR2(15) NULL,
       AccountTypeID        INTEGER NOT NULL,
       Login                VARCHAR2(64) NULL,
       Password             VARCHAR2(128) NULL,
       MaidenName           VARCHAR2(25) NULL,
       NetSoftware          VARCHAR2(15) NULL,
       SystemType           VARCHAR2(15) NULL,
       ModemSpeed           VARCHAR2(15) NULL,
       CallerID             VARCHAR2(64) NULL,
       FramedAddress        VARCHAR2(16) NULL,
       CallDate             DATE NOT NULL,
       SignUpDate           DATE NOT NULL,
       Status               VARCHAR2(16) NULL,
       PaymentOption        VARCHAR2(15) NULL,
       CardNumber           VARCHAR2(16) NULL,
       CardExpiration       VARCHAR2(20) NULL,
       SignUpComment        VARCHAR2(255) NULL
)
/

CREATE INDEX XIE1OnlineSignups ON OnlineSignups
(
       LastName,
       FirstName
)
/

CREATE INDEX XIE2OnlineSignups ON OnlineSignups
(
       Region,
       CallDate
)
/


ALTER TABLE OnlineSignups
       ADD PRIMARY KEY (OnlineSignupID)
/


CREATE TABLE OperatorCookies (
       Cookie               VARCHAR2(64) NOT NULL,
       Operator             VARCHAR2(64) NOT NULL,
       LastUsed             DATE DEFAULT SYSDATE  NOT NULL,
       OperatorID           INTEGER NULL,
       AccountID            INTEGER NULL
)
/


ALTER TABLE OperatorCookies
       ADD PRIMARY KEY (Cookie)
/


CREATE TABLE OperatorGroupAccess (
       ObjectGroupID        INTEGER NOT NULL,
       OperatorGroupID      INTEGER NOT NULL,
       GroupID              INTEGER NOT NULL,
       AccessType           smallint DEFAULT 1  NOT NULL
)
/

CREATE INDEX IX_OperatorGroupAccess ON OperatorGroupAccess
(
       OperatorGroupID,
       ObjectGroupID,
       GroupID
)
/


ALTER TABLE OperatorGroupAccess
       ADD PRIMARY KEY (ObjectGroupID, OperatorGroupID, GroupID)
/


CREATE TABLE OperatorGroups (
       OperatorGroupID      INTEGER ,
       OperatorGroup        VARCHAR2(32) NOT NULL,
       Description          VARCHAR2(64) NULL,
       InternalUse          smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE OperatorGroups
       ADD PRIMARY KEY (OperatorGroupID)
/


CREATE TABLE OperatorRoles (
       OperatorRoleID       INTEGER ,
       OperatorID           INTEGER NOT NULL,
       RoleID               INTEGER NOT NULL,
       GroupID              INTEGER NULL,
       TargetActive         INTEGER NULL,
       MaxActive            INTEGER NULL,
       Tier                 smallint DEFAULT 1  NOT NULL,
       ShowEscalate         smallint DEFAULT 0  NOT NULL,
       ShowLate             smallint DEFAULT 0  NOT NULL
)
/

CREATE UNIQUE INDEX i_OperatorRoles_unique ON OperatorRoles
(
       OperatorID,
       RoleID,
       GroupID
)
/

CREATE INDEX IX_OperatorRoles ON OperatorRoles
(
       RoleID,
       OperatorID
)
/


ALTER TABLE OperatorRoles
       ADD PRIMARY KEY (OperatorRoleID)
/


CREATE TABLE Operators (
       OperatorID           INTEGER ,
       PrintTypeID          smallint NULL,
       OperatorGroupID      INTEGER NOT NULL,
       Operator             VARCHAR2(32) NOT NULL,
       Password             VARCHAR2(128) NULL,
       Email                VARCHAR2(64) NULL,
       WebObjectAccess      INTEGER DEFAULT 1  NULL,
       LanguageID           INTEGER NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       DateFormatID         INTEGER NULL,
       DateSeperator        char(1) NULL,
       ThemeID              INTEGER NULL,
       CountryID            INTEGER NULL,
       DaySumIncident       smallint NULL,
       MeasureUnitID        smallint NULL
)
/

CREATE UNIQUE INDEX uc_Operator ON Operators
(
       Operator
)
/

CREATE INDEX i_Operators_OperatorGroupID ON Operators
(
       OperatorGroupID
)
/

CREATE INDEX i_Operators_Email ON Operators
(
       Email
)
/


ALTER TABLE Operators
       ADD PRIMARY KEY (OperatorID)
/


CREATE TABLE OrgAccountTypes (
       OrganizationID       INTEGER NOT NULL,
       AccountTypeID        INTEGER NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             VARCHAR2(128) NULL
)
/


ALTER TABLE OrgAccountTypes
       ADD PRIMARY KEY (OrganizationID, AccountTypeID)
/


CREATE TABLE Organizations (
       OrganizationID       INTEGER ,
       ResellerCustomerID   INTEGER NULL,
       Organization         VARCHAR2(255) NOT NULL,
       InvoiceDetailed      smallint DEFAULT 0  NOT NULL,
       InvoiceFractional    smallint DEFAULT 0  NOT NULL,
       MaxAccounts          INTEGER NULL,
       CurrencyID           INTEGER DEFAULT 207  NOT NULL
)
/


ALTER TABLE Organizations
       ADD PRIMARY KEY (OrganizationID)
/


CREATE TABLE OrgPackageTypes (
       OrganizationID       INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             VARCHAR2(128) NULL
)
/


ALTER TABLE OrgPackageTypes
       ADD PRIMARY KEY (OrganizationID, PackageTypeID)
/


CREATE TABLE PackageAccountTypes (
       PackageTypeID        INTEGER NOT NULL,
       AccountTypeID        INTEGER NOT NULL,
       NonPkgCost           numeric(18,4) NULL,
       NonPkgDiscountID     INTEGER NOT NULL,
       MinQty               smallint DEFAULT 0  NOT NULL,
       MaxQty               smallint DEFAULT 0  NOT NULL,
       CustomerMax          smallint NULL,
       OperatorMax          smallint DEFAULT 0  NULL,
       AllowCustCancel      smallint DEFAULT 1  NOT NULL,
       AllowCustChangeLogin smallint DEFAULT 0  NOT NULL,
       AllowCustChangePass  smallint DEFAULT 1  NOT NULL,
       AllowCustAdd         smallint DEFAULT 1  NOT NULL,
       PackageLoginLimit    INTEGER NULL,
       PackageTimeLeft      INTEGER NULL,
       AllowCustSetDomain   smallint NULL
)
/

CREATE INDEX i_PAT_PTID_ATID ON PackageAccountTypes
(
       PackageTypeID,
       AccountTypeID
)
/


ALTER TABLE PackageAccountTypes
       ADD PRIMARY KEY (AccountTypeID, PackageTypeID)
/


CREATE TABLE Packages (
       PackageID            INTEGER ,
       CustomerID           INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL,
       BillStatus           smallint NULL,
       DiffCost             smallint DEFAULT 0  NOT NULL,
       Cost                 numeric(18,4) NULL,
       CreateOperatorID     INTEGER NULL,
       CreateDate           DATE NULL,
       StartDate            DATE NULL,
       LastModifyUser       VARCHAR2(64) NULL,
       LastModifyDate       DATE NULL,
       CancelDate           DATE NULL,
       CancelReasonID       INTEGER NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       ExpireDate           DATE NULL,
       Extension            INTEGER DEFAULT 0  NULL,
       BilledThru           DATE NULL,
       PayPeriodID          INTEGER NULL,
       DiscountID           INTEGER NOT NULL,
       SalesPersonID        INTEGER NULL,
       Comments             CLOB NULL,
       CycleMonths          smallint DEFAULT 0  NOT NULL,
       LastInvoiceID        INTEGER NULL
)
/

CREATE INDEX IX_Packages ON Packages
(
       CustomerID
)
/

CREATE INDEX i_Packages_LMD ON Packages
(
       LastModifyDate
)
/


ALTER TABLE Packages
       ADD PRIMARY KEY (PackageID)
/


CREATE TABLE PackageTypes (
       PackageTypeID        INTEGER ,
       PackageType          VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       Cost                 numeric(18,4) NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       CustomerAccess       smallint DEFAULT 0  NOT NULL,
       CustomerSignup       smallint DEFAULT 0  NOT NULL,
       UniquePerMBR         smallint NOT NULL,
       MaxPerMBR            smallint NOT NULL,
       StartDate            DATE NULL,
       EndDate              DATE NULL,
       ApplyDiscount        smallint NOT NULL,
       TaxGroupID           INTEGER NULL,
       TaxExemptions        INTEGER NULL,
       ChargeTypeID         INTEGER NULL,
       GLCodeID             INTEGER NULL,
       PayPeriodID          INTEGER NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       BillingCycleID       INTEGER NULL,
       PrimaryAccountTypeID INTEGER NULL,
       SendMethodID         INTEGER NULL,
       Description          CLOB NULL,
       CustomerDescription  CLOB NULL,
       SortOrder            smallint NOT NULL,
       PaymentTypes         INTEGER DEFAULT 65535  NOT NULL,
       ChangeOpen           smallint DEFAULT 1  NOT NULL,
       ChangeTo             smallint DEFAULT 1  NOT NULL,
       ChangeClose          smallint DEFAULT 1  NOT NULL,
       ChangeFrom           smallint DEFAULT 1  NOT NULL,
       NextCount            smallint NULL,
       NextID               INTEGER NULL,
       InvoiceDescription   VARCHAR2(64) NULL,
       CustomerStringID     INT NULL,
       SecChargeTypeID      INTEGER NULL
)
/


ALTER TABLE PackageTypes
       ADD PRIMARY KEY (PackageTypeID)
/


CREATE TABLE PaymentItems (
       PaymentItemID        INTEGER ,
       PaymentID            INTEGER NULL,
       ChargeID             INTEGER NULL,
       ItemID               INTEGER NOT NULL,
       ActiveDate           DATE NOT NULL,
       InactiveDate         DATE NULL,
       Amount               numeric(18,4) NULL
) CLUSTER IX_PaymentItems (PaymentID,ChargeID,ItemID)
/
CREATE INDEX IX_PaymentItems ON CLUSTER IX_PaymentItems
/









CREATE INDEX IX_ActiveDate ON PaymentItems
(
       ActiveDate
)
/

CREATE INDEX IX_InactiveDate ON PaymentItems
(
       InactiveDate
)
/

CREATE INDEX iPaymentItems_ItemID ON PaymentItems
(
       ItemID
)
/


ALTER TABLE PaymentItems
       ADD PRIMARY KEY  (PaymentItemID)
/


CREATE TABLE Payments (
       PaymentID            INTEGER ,
       CustomerID           INTEGER NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       BatchID              INTEGER NULL,
       PaymentTypeID        INTEGER NOT NULL,
       CheckNumber          VARCHAR2(16) NULL,
       PayInfo              VARCHAR2(45) NULL,
       ProcTransID          VARCHAR2(64) NULL,
       DistFlag             smallint DEFAULT 1  NOT NULL,
       Confirmed            smallint NULL,
       StatementID          INTEGER NULL,
       FinalAmount          numeric(18,4) NULL,
       FinalStatementID     INTEGER NULL,
       FinalCreateDate      DATE NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       GLState              smallint NULL
)
/

CREATE INDEX iCustomerID_3 ON Payments
(
       CustomerID
)
/

CREATE INDEX iDate ON Payments
(
       CreateDate
)
/

CREATE INDEX i_PMT_StatementID ON Payments
(
       StatementID
)
/

CREATE INDEX i_PMT_FinalStatementID ON Payments
(
       FinalStatementID
)
/


ALTER TABLE Payments
       ADD PRIMARY KEY (PaymentID)
/


CREATE TABLE PaymentTypes (
       PaymentTypeID        INTEGER NOT NULL,
       PaymentType          VARCHAR2(32) NOT NULL,
       StringID             INTEGER NULL,
       CustomerDescription  VARCHAR2(128) NULL,
       CustomerStringID     INTEGER NULL,
       GLCodeID             INTEGER NULL,
       CustomerAccess       smallint DEFAULT 1  NOT NULL,
       CustomerPayment      smallint DEFAULT 1  NOT NULL,
       IsPayMethod          smallint DEFAULT 1  NOT NULL,
       IsPayType            smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE PaymentTypes
       ADD PRIMARY KEY (PaymentTypeID)
/


CREATE TABLE PayPeriods (
       PayPeriodID          INTEGER ,
       AccountTypeID        INTEGER NULL,
       PayPeriod            VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       PeriodTypeID         INTEGER NOT NULL,
       Period               smallint NOT NULL,
       Amount               numeric(18,4) DEFAULT 0  NOT NULL,
       AmountType           smallint DEFAULT 1  NOT NULL,
       SetupCharge          smallint DEFAULT 0  NOT NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       ConfirmTrans         smallint DEFAULT 0  NULL
)
/

CREATE INDEX i_PayPeriods_GroupID ON PayPeriods
(
       GroupID
)
/


ALTER TABLE PayPeriods
       ADD PRIMARY KEY (PayPeriodID)
/


CREATE TABLE PeriodTypes (
       PeriodTypeID         INTEGER NOT NULL,
       PeriodType           VARCHAR2(32) NOT NULL,
       StringID             INTEGER NULL,
       AllowPayPeriod       smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE PeriodTypes
       ADD PRIMARY KEY (PeriodTypeID)
/


CREATE TABLE PosixAccountServers (
       PosixAccountServerID INTEGER ,
       LDAPServer           VARCHAR2(50) NOT NULL,
       AccountTypeID        VARCHAR2(20) NOT NULL,
       gidNumber            INTEGER NOT NULL,
       loginShell           VARCHAR2(100) NOT NULL,
       homeDirectory        VARCHAR2(100) NOT NULL
)
/

CREATE INDEX i_PosixAccountServers_ID ON PosixAccountServers
(
       PosixAccountServerID
)
/


ALTER TABLE PosixAccountServers
       ADD PRIMARY KEY (LDAPServer, AccountTypeID)
/


CREATE TABLE PosixAccountUIDs (
       uidNumber            INTEGER NOT NULL,
       PosixAccountUserID   INTEGER NULL,
       LDAPServer           VARCHAR2(50) NOT NULL
)
/

CREATE INDEX i_PosixAccountUIDs_PAUID ON PosixAccountUIDs
(
       PosixAccountUserID
)
/

CREATE INDEX i_PAU_uidNumber ON PosixAccountUIDs
(
       uidNumber
)
/


ALTER TABLE PosixAccountUIDs
       ADD PRIMARY KEY (uidNumber, LDAPServer)
/


CREATE TABLE PosixAccountUsers (
       PosixAccountUserID   INTEGER ,
       PosixAccountServerID INTEGER NOT NULL,
       AccountID            INTEGER NOT NULL,
       gidNumber            INTEGER NULL,
       loginShell           VARCHAR2(100) NULL,
       homeDirectory        VARCHAR2(100) NULL,
       userPassword         VARCHAR2(50) NULL
)
/

CREATE INDEX i_PosixAccountUsers_ID ON PosixAccountUsers
(
       PosixAccountUserID
)
/

CREATE INDEX i_PosixAccountUsers_SrvrID ON PosixAccountUsers
(
       PosixAccountServerID
)
/


ALTER TABLE PosixAccountUsers
       ADD PRIMARY KEY (AccountID)
/


CREATE TABLE PrintTypes (
       PrintTypeID          smallint NOT NULL,
       PrintType            VARCHAR2(64) NOT NULL,
       Data                 VARCHAR2(128) NULL,
       CRData               VARCHAR2(128) NULL
)
/

CREATE UNIQUE INDEX pk_PrintTypes ON PrintTypes
(
       PrintType
)
/


ALTER TABLE PrintTypes
       ADD PRIMARY KEY (PrintTypeID)
/


CREATE TABLE Priorities (
       PriorityID           smallint NOT NULL,
       Priority             VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE Priorities
       ADD PRIMARY KEY (PriorityID)
/


CREATE TABLE RadATConfigs (
       RadATConfigID        INTEGER ,
       AccountTypeID        INTEGER NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL,
       Value                INTEGER NULL,
       RadCheck             smallint DEFAULT 0  NOT NULL,
       Tag                  smallint NULL,
       SortOrder            smallint NULL
)
/


ALTER TABLE RadATConfigs
       ADD PRIMARY KEY (RadATConfigID)
/


CREATE TABLE RadAttributes (
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       Name                 VARCHAR2(40) NOT NULL,
       RadAttributeType     smallint NOT NULL,
       ReplyType            smallint NOT NULL,
       AliasAttributeID     INTEGER NULL,
       AliasVendorID        INTEGER NULL
)
/


ALTER TABLE RadAttributes
       ADD PRIMARY KEY (RadAttributeID, RadVendorID)
/


CREATE TABLE RadConcurrency (
       RadConcurrencyID     INTEGER ,
       GroupID              INTEGER NOT NULL,
       AccountTypeID        INTEGER NULL,
       LastSyncDate         DATE DEFAULT SYSDATE  NOT NULL,
       ConnectionsMax       INTEGER DEFAULT 0  NOT NULL,
       Connections          INTEGER DEFAULT 0  NOT NULL,
       Description          VARCHAR2(100) NULL
) CLUSTER i_RC_GroupAccountID (GroupID,AccountTypeID)
/
CREATE INDEX i_RC_GroupAccountID ON CLUSTER i_RC_GroupAccountID
/









ALTER TABLE RadConcurrency
       ADD PRIMARY KEY  (RadConcurrencyID)
/


CREATE TABLE RadConfigs (
       RadConfigID          INTEGER ,
       AccountID            INTEGER NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL,
       Value                INTEGER NULL,
       RadCheck             smallint DEFAULT 0  NOT NULL,
       Tag                  smallint NULL
)
/

CREATE INDEX i_RadConfigs_AccountID ON RadConfigs
(
       AccountID
)
/


ALTER TABLE RadConfigs
       ADD PRIMARY KEY (RadConfigID)
/


CREATE TABLE RadDestTypes (
       RadDestTypeID        INTEGER NOT NULL,
       RadDestType          VARCHAR2(64) NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE RadDestTypes
       ADD PRIMARY KEY (RadDestTypeID)
/


CREATE TABLE RadFilterGroups (
       RadFilterGroupID     INTEGER ,
       RadFilterGroup       VARCHAR2(64) NOT NULL,
       RadSourceTypeID      INTEGER NOT NULL,
       Description          VARCHAR2(255) NULL,
       DestRadFilterGroupID INTEGER NULL,
       DestData             VARCHAR2(255) NULL,
       RadDestTypeID        INTEGER NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE RadFilterGroups
       ADD PRIMARY KEY (RadFilterGroupID)
/


CREATE TABLE RadFilters (
       RadFilterID          INTEGER ,
       RadMergeTypeID       INTEGER NULL,
       RadFilterTypeID      INTEGER NULL,
       RadVendorID          INTEGER NULL,
       RadSearchTypeID      INTEGER NOT NULL,
       RadAttributeID       INTEGER NULL,
       RadFilterGroupID     INTEGER NOT NULL,
       Location             VARCHAR2(64) NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE RadFilters
       ADD PRIMARY KEY (RadFilterID)
/


CREATE TABLE RadFilterTypes (
       RadFilterTypeID      INTEGER NOT NULL,
       RadFilterType        VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RadFilterTypes
       ADD PRIMARY KEY (RadFilterTypeID)
/


CREATE TABLE RadIPAccountTypes (
       RadIPAccountTypeID   INTEGER ,
       ServerGroupID        INTEGER NOT NULL,
       AccountTypeID        INTEGER NULL,
       RadIPGroupID         INTEGER NULL,
       Priority             INTEGER DEFAULT 0  NOT NULL,
       AssignType           smallint NULL
)
/


ALTER TABLE RadIPAccountTypes
       ADD PRIMARY KEY (RadIPAccountTypeID)
/


CREATE TABLE RadIPAddresses (
       NASIdentifier        VARCHAR2(32) NULL,
       NASPort              VARCHAR2(32) NULL,
       IPAddress            VARCHAR2(16) NOT NULL,
       RadIPGroupID         INTEGER NOT NULL,
       State                INTEGER DEFAULT 0  NOT NULL,
       LastUsed             DATE DEFAULT SYSDATE  NULL,
       LastCallDate         DATE DEFAULT SYSDATE  NOT NULL,
       AccountID            INTEGER NULL
) CLUSTER IX_RadIPAddresses (NASIdentifier,NASPort)
/
CREATE INDEX IX_RadIPAddresses ON CLUSTER IX_RadIPAddresses
/








CREATE INDEX I_RadIPAddress_AID ON RadIPAddresses
(
       AccountID
)
/


ALTER TABLE RadIPAddresses
       ADD PRIMARY KEY  (IPAddress)
/


CREATE TABLE RadIPGroups (
       RadIPGroupID         INTEGER ,
       RadIPGroup           VARCHAR2(32) NOT NULL
)
/


ALTER TABLE RadIPGroups
       ADD PRIMARY KEY (RadIPGroupID)
/


CREATE TABLE RadLogMsgs (
       RadLogMsgID          INTEGER NOT NULL,
       Description          VARCHAR2(50) NOT NULL,
       Severity             INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE RadLogMsgs
       ADD PRIMARY KEY (RadLogMsgID)
/


CREATE TABLE RadLogs (
       RadLogMsgID          INTEGER NOT NULL,
       LogDate              DATE DEFAULT SYSDATE  NOT NULL,
       Username             VARCHAR2(64) NOT NULL,
       Data                 VARCHAR2(50) NULL,
       NASIdentifier        VARCHAR2(32) NULL,
       NASPort              VARCHAR2(32) NULL,
       CallerID             VARCHAR2(64) NULL
)
/


ALTER TABLE RadLogs
       ADD PRIMARY KEY (RadLogMsgID, LogDate, Username)
/


CREATE TABLE RadMapAttributes (
       MapAttribute         VARCHAR2(64) NOT NULL,
       RadMapTypeID         INTEGER NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL
)
/


ALTER TABLE RadMapAttributes
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID)
/


CREATE TABLE RadMapTypes (
       RadMapTypeID         INTEGER NOT NULL,
       RadMapType           VARCHAR2(128) NOT NULL
)
/


ALTER TABLE RadMapTypes
       ADD PRIMARY KEY (RadMapTypeID)
/


CREATE TABLE RadMapValues (
       MapAttribute         VARCHAR2(64) NOT NULL,
       RadMapTypeID         INTEGER NOT NULL,
       MapValue             VARCHAR2(64) NOT NULL,
       RadValue             INTEGER NOT NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE RadMapValues
       ADD PRIMARY KEY (MapAttribute, RadMapTypeID, MapValue, 
              RadValue)
/


CREATE TABLE RadMergeTypes (
       RadMergeTypeID       INTEGER NOT NULL,
       RadMergeType         char(64) NOT NULL
)
/


ALTER TABLE RadMergeTypes
       ADD PRIMARY KEY (RadMergeTypeID)
/


CREATE TABLE RadProxyAttributeGroups (
       RadProxyAttributeGroupID INTEGER ,
       RadRoamServerID      INTEGER NOT NULL,
       Priority             INTEGER NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE RadProxyAttributeGroups
       ADD PRIMARY KEY (RadProxyAttributeGroupID)
/


CREATE TABLE RadProxyAttributes (
       RadProxyAttributeGroupID INTEGER NOT NULL,
       SearchType           smallint NOT NULL,
       String               VARCHAR2(253) NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       RadProxyAttributeID  INTEGER 
)
/


ALTER TABLE RadProxyAttributes
       ADD PRIMARY KEY (RadProxyAttributeGroupID, SearchType, String, 
              RadAttributeID, RadVendorID)
/


CREATE TABLE RadProxyRateProcs (
       Realm                VARCHAR2(64) NOT NULL,
       ProxyType            smallint NOT NULL,
       ProcDate             DATE NOT NULL,
       InBytes              NUMBER(38) NULL,
       OutBytes             NUMBER(38) NULL,
       UserCount            INTEGER NULL,
       SessionTime          INTEGER NULL,
       SessionCount         INTEGER NULL
)
/


ALTER TABLE RadProxyRateProcs
       ADD PRIMARY KEY (Realm, ProcDate, ProxyType)
/


CREATE TABLE RadRejectAttributes (
       RadRejectAttributeID INTEGER ,
       IEAID                INTEGER NULL,
       ServerID             INTEGER NULL,
       RadLogMsgID          INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/


ALTER TABLE RadRejectAttributes
       ADD PRIMARY KEY (RadRejectAttributeID)
/


CREATE TABLE RadRejects (
       RadRejectID          INTEGER ,
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       Data                 VARCHAR2(100) NOT NULL,
       Value                INTEGER NULL
)
/


ALTER TABLE RadRejects
       ADD PRIMARY KEY (RadRejectID)
/


CREATE TABLE RadRoamDomains (
       RadRoamDomainID      INTEGER ,
       RadRoamServerID      INTEGER NOT NULL,
       Domain               VARCHAR2(64) NOT NULL,
       Priority             INTEGER DEFAULT 0  NOT NULL,
       AccountTypeID        INTEGER NULL
)
/

CREATE INDEX i_RadRoamDomains_Domain ON RadRoamDomains
(
       Domain
)
/


ALTER TABLE RadRoamDomains
       ADD PRIMARY KEY (RadRoamDomainID)
/


CREATE TABLE RadRoamServers (
       RadRoamServerID      INTEGER ,
       IPAddress            VARCHAR2(32) NOT NULL,
       Server               VARCHAR2(32) NOT NULL,
       Secret               VARCHAR2(255) NOT NULL,
       Timeout              INTEGER DEFAULT 0  NOT NULL,
       Retries              INTEGER DEFAULT 0  NOT NULL,
       TreatAsLocal         smallint DEFAULT 0  NOT NULL,
       StripDomain          smallint DEFAULT 0  NOT NULL,
       AuthPort             INTEGER NULL,
       AcctPort             INTEGER NULL,
       RateTarget           INTEGER NULL,
       RateMax              INTEGER NULL
)
/


ALTER TABLE RadRoamServers
       ADD PRIMARY KEY (RadRoamServerID)
/


CREATE TABLE RadSearchTypes (
       RadSearchTypeID      INTEGER NOT NULL,
       RadSearchType        VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RadSearchTypes
       ADD PRIMARY KEY (RadSearchTypeID)
/


CREATE TABLE RadSourceTypes (
       RadSourceTypeID      INTEGER NOT NULL,
       RadSourceType        VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RadSourceTypes
       ADD PRIMARY KEY (RadSourceTypeID)
/


CREATE TABLE RadTriggers (
       RadTriggerID         INTEGER ,
       AccountID            INTEGER NOT NULL,
       TriggerType          INTEGER DEFAULT 0  NOT NULL,
       FileName             VARCHAR2(64) NOT NULL,
       Parameters           VARCHAR2(64) NULL,
       Directory            VARCHAR2(128) NULL
)
/


ALTER TABLE RadTriggers
       ADD PRIMARY KEY (RadTriggerID)
/


CREATE TABLE RadValues (
       RadAttributeID       INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       Value                INTEGER NOT NULL,
       Name                 VARCHAR2(40) NOT NULL
)
/


ALTER TABLE RadValues
       ADD PRIMARY KEY (RadAttributeID, RadVendorID, Value)
/


CREATE TABLE RadVendors (
       RadVendorID          INTEGER NOT NULL,
       Name                 VARCHAR2(32) NOT NULL,
       VendorURL            VARCHAR2(128) NULL,
       Description          CLOB NULL,
       Comments             CLOB NULL
)
/


ALTER TABLE RadVendors
       ADD PRIMARY KEY (RadVendorID)
/


CREATE TABLE RateClasses (
       RateClassID          INTEGER ,
       RateClass            VARCHAR2(128) NOT NULL
)
/


ALTER TABLE RateClasses
       ADD PRIMARY KEY (RateClassID)
/


CREATE TABLE RateDataSources (
       RateDataSourceID     INTEGER NOT NULL,
       RateDataSource       VARCHAR2(128) NOT NULL,
       RateSourceID         INTEGER NULL,
       DSN                  VARCHAR2(128) NULL,
       Username             VARCHAR2(64) NULL,
       Password             VARCHAR2(128) NULL,
       DataQuery            CLOB NOT NULL,
       UpdateQuery          CLOB NULL,
       UseTransactions      smallint DEFAULT 1  NOT NULL,
       UpdateInterval       smallint DEFAULT 0  NOT NULL,
       BillingMode          INTEGER NULL,
       ClearQuery           CLOB NULL
)
/


ALTER TABLE RateDataSources
       ADD PRIMARY KEY (RateDataSourceID)
/


CREATE TABLE RateHistory (
       StartDate            DATE NOT NULL,
       AccountID            INTEGER NOT NULL,
       CustomerID           INTEGER NOT NULL,
       RateRuleID           INTEGER NOT NULL,
       RateID               INTEGER NOT NULL,
       TotalTime            INTEGER NOT NULL,
       ChargeID             INTEGER NULL,
       TotalCount           numeric(28,12) NOT NULL,
       TotalData            NUMBER(38) NOT NULL,
       TotalCost            numeric(28,12) DEFAULT 0  NOT NULL
)
/

CREATE INDEX i_RateHistory_ChargeID ON RateHistory
(
       CustomerID,
       ChargeID
)
/


ALTER TABLE RateHistory
       ADD PRIMARY KEY (StartDate, AccountID, CustomerID, RateRuleID, 
              RateID)
/


CREATE TABLE RateIntervals (
       RateIntervalID       INTEGER NOT NULL,
       RateRuleTypeID       INTEGER NOT NULL,
       NameSingular         VARCHAR2(64) NOT NULL,
       NamePlural           VARCHAR2(64) NOT NULL,
       NameShort            VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RateIntervals
       ADD PRIMARY KEY (RateIntervalID)
/


CREATE TABLE RateIPPorts (
       Port                 INTEGER NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE RateIPPorts
       ADD PRIMARY KEY (Port)
/


CREATE TABLE RateIPProtocols (
       Protocol             INTEGER NOT NULL,
       Description          VARCHAR2(64) NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE RateIPProtocols
       ADD PRIMARY KEY (Protocol)
/


CREATE TABLE RateItems (
       RateItemID           INTEGER ,
       RateID               INTEGER NOT NULL,
       RateRuleID           INTEGER NOT NULL,
       RateTimeGroupID      INTEGER NOT NULL
)
/

CREATE UNIQUE INDEX IX_RateItems ON RateItems
(
       RateID,
       RateRuleID,
       RateTimeGroupID
)
/


ALTER TABLE RateItems
       ADD PRIMARY KEY (RateItemID)
/


CREATE TABLE RateMatchTypes (
       RateMatchTypeID      INTEGER NOT NULL,
       RateMatchType        VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RateMatchTypes
       ADD PRIMARY KEY (RateMatchTypeID)
/


CREATE TABLE RateRoundTypes (
       RateRoundTypeID      INTEGER NOT NULL,
       RateRoundType        VARCHAR2(64) NOT NULL,
       AllowData            smallint DEFAULT 0  NOT NULL,
       AllowTime            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE RateRoundTypes
       ADD PRIMARY KEY (RateRoundTypeID)
/


CREATE TABLE RateRules (
       RateRuleID           INTEGER ,
       RateRule             VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       RateSourceID         INTEGER NOT NULL,
       RateRoundTypeID      INTEGER NOT NULL,
       RateTypeID           INTEGER NULL,
       RateRuleTypeID       INTEGER DEFAULT 1  NOT NULL,
       Interval             INTEGER NOT NULL,
       ClassRequired        smallint NOT NULL,
       ClassTTL             INTEGER NULL,
       ClassQuery           VARCHAR2(255) NULL,
       RuleQuery            VARCHAR2(255) NULL,
       DefaultCost          numeric(18,4) NULL,
       Description          CLOB NULL
)
/


ALTER TABLE RateRules
       ADD PRIMARY KEY (RateRuleID)
/


CREATE TABLE RateRuleTypes (
       RateRuleTypeID       INTEGER NOT NULL,
       RateRuleType         VARCHAR2(128) NOT NULL
)
/


ALTER TABLE RateRuleTypes
       ADD PRIMARY KEY (RateRuleTypeID)
/


CREATE TABLE Rates (
       RateID               INTEGER ,
       RateSourceID         INTEGER NOT NULL,
       Description          VARCHAR2(30) NOT NULL,
       MinCharge            numeric(18,4) NULL,
       MaxCharge            numeric(18,4) NULL,
       ChargeTypeID         INTEGER NOT NULL,
       RateClassID          INTEGER DEFAULT 1  NOT NULL,
       DataRateRuleID       INTEGER NULL,
       ClassifierRateRuleID INTEGER NULL,
       AuthMaxTime          INTEGER NULL,
       AuthRate             smallint NULL,
       AuthRateTime         smallint NULL
)
/


ALTER TABLE Rates
       ADD PRIMARY KEY (RateID)
/


CREATE TABLE RateSourceAttributes (
       RateSourceID         INTEGER NOT NULL,
       Attribute            VARCHAR2(64) NOT NULL,
       Description          VARCHAR2(255) NULL,
       AllowData            smallint DEFAULT 0  NOT NULL,
       AllowTime            smallint DEFAULT 0  NOT NULL,
       Dynamic              smallint DEFAULT 0  NOT NULL,
       ValuesQuery          VARCHAR2(255) NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       RateMatchTypes       INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE RateSourceAttributes
       ADD PRIMARY KEY (RateSourceID, Attribute)
/


CREATE TABLE RateSources (
       RateSourceID         INTEGER NOT NULL,
       RateSource           VARCHAR2(255) NOT NULL,
       AllowData            smallint DEFAULT 1  NOT NULL,
       AllowTime            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE RateSources
       ADD PRIMARY KEY (RateSourceID)
/


CREATE TABLE RateStatusCalls (
       LastCallID           NUMBER(38) NULL,
       Leader               VARCHAR2(64) NULL,
       LastUpdate           DATE DEFAULT SYSDATE  NOT NULL,
       LastMessage          VARCHAR2(255) NULL,
       Advisor              VARCHAR2(64) NULL,
       LastAdviceDate       DATE DEFAULT SYSDATE  NOT NULL
)
/


CREATE TABLE RateStdGroups (
       RateStdGroupID       INTEGER ,
       RateRuleID           INTEGER NOT NULL,
       Priority             smallint NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE RateStdGroups
       ADD PRIMARY KEY (RateStdGroupID)
/


CREATE TABLE RateStdItems (
       RateStdItemID        INTEGER ,
       RateStdGroupID       INTEGER NOT NULL,
       Attribute            VARCHAR2(64) NOT NULL,
       RateMatchTypeID      INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/


ALTER TABLE RateStdItems
       ADD PRIMARY KEY (RateStdItemID)
/


CREATE TABLE RateTimeGroups (
       RateTimeGroupID      INTEGER ,
       RateTimeGroup        VARCHAR2(128) NOT NULL
)
/


ALTER TABLE RateTimeGroups
       ADD PRIMARY KEY (RateTimeGroupID)
/


CREATE TABLE RateTimes (
       RateTimeID           INTEGER ,
       RateTimeGroupID      INTEGER NOT NULL,
       StartHour            smallint NULL,
       StartMinute          smallint NULL,
       EndHour              smallint NULL,
       EndMinute            smallint NULL,
       DayWeekMask          INTEGER NULL,
       WeekNumMask          INTEGER NULL,
       MonthMask            INTEGER NULL,
       MonthDay             smallint NULL,
       Priority             smallint NULL,
       Description          VARCHAR2(255) NOT NULL
)
/


ALTER TABLE RateTimes
       ADD PRIMARY KEY (RateTimeID)
/


CREATE TABLE RateTypes (
       RateTypeID           INTEGER NOT NULL,
       RateType             VARCHAR2(128) NOT NULL,
       RateSourceID         INTEGER NULL,
       RuleQuery            VARCHAR2(255) NOT NULL,
       ScriptConfigure      VARCHAR2(64) NOT NULL,
       ScriptSummary        VARCHAR2(64) NOT NULL
)
/


ALTER TABLE RateTypes
       ADD PRIMARY KEY (RateTypeID)
/


CREATE TABLE RateVCondGroups (
       RateVCondGroupID     INTEGER ,
       RateVCondGroup       VARCHAR2(128) NOT NULL,
       RateSourceID         INTEGER NOT NULL,
       RateRuleID           INTEGER NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       Priority             smallint NULL
)
/


ALTER TABLE RateVCondGroups
       ADD PRIMARY KEY (RateVCondGroupID)
/


CREATE TABLE RateVCondItems (
       RateVCondItemID      INTEGER ,
       RateVCondGroupID     INTEGER NOT NULL,
       Attribute            VARCHAR2(64) NOT NULL,
       RateMatchTypeID      INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/


ALTER TABLE RateVCondItems
       ADD PRIMARY KEY (RateVCondItemID)
/


CREATE TABLE RateVDNIS (
       RateVDNISID          INTEGER ,
       RateVDNIS            VARCHAR2(128) NOT NULL,
       RateSourceID         INTEGER NOT NULL,
       RateRuleID           INTEGER NULL,
       Attribute            VARCHAR2(64) NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE RateVDNIS
       ADD PRIMARY KEY (RateVDNISID)
/


CREATE TABLE RateVDNISGroupItems (
       RateVDNISGroupID     INTEGER NOT NULL,
       RateVDNISID          INTEGER NOT NULL,
       RateVCondGroupID     INTEGER NULL
)
/


ALTER TABLE RateVDNISGroupItems
       ADD PRIMARY KEY (RateVDNISGroupID, RateVDNISID)
/


CREATE TABLE RateVDNISGroups (
       RateVDNISGroupID     INTEGER ,
       RateVDNISGroup       VARCHAR2(128) NOT NULL,
       RateSourceID         INTEGER NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE RateVDNISGroups
       ADD PRIMARY KEY (RateVDNISGroupID)
/


CREATE TABLE RateVDNISItems (
       RateVDNISItemID      INTEGER ,
       RateVDNISID          INTEGER NOT NULL,
       RateVDNISItem        VARCHAR2(128) NULL,
       DNIS                 VARCHAR2(64) NOT NULL,
       Location             VARCHAR2(128) NULL,
       RateMatchTypeID      INTEGER NOT NULL,
       IntervalCost         numeric(18,4) NULL,
       IntervalOption       smallint DEFAULT 0  NOT NULL,
       InitialCost          numeric(18,4) NULL,
       InitialOption        smallint DEFAULT 0  NOT NULL,
       StaticCost           numeric(18,4) NULL,
       StaticOption         smallint DEFAULT 0  NOT NULL,
       CountryID            INTEGER NULL,
       StateID              INTEGER NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/

CREATE INDEX i_RVDI_DNIS ON RateVDNISItems
(
       DNIS
)
/


ALTER TABLE RateVDNISItems
       ADD PRIMARY KEY (RateVDNISItemID)
/


CREATE TABLE RateVRates (
       RateVRateID          INTEGER ,
       RateVRate            VARCHAR2(128) NULL,
       RateRuleID           INTEGER NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       RateVDNISID          INTEGER NULL,
       RateVDNISGroupID     INTEGER NULL,
       RateVCondGroupID     INTEGER NULL,
       Multiplier           numeric(18,4) NULL
)
/


ALTER TABLE RateVRates
       ADD PRIMARY KEY (RateVRateID)
/


CREATE TABLE ReferredBys (
       ReferredByID         INTEGER ,
       ReferredBy           VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       GroupID              INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE ReferredBys
       ADD PRIMARY KEY (ReferredByID)
/


CREATE TABLE Regions (
       RegionID             INTEGER ,
       Region               VARCHAR2(64) NOT NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE Regions
       ADD PRIMARY KEY (RegionID)
/


CREATE TABLE ReportFields (
       ReportFieldID        INTEGER NOT NULL,
       ReportField          VARCHAR2(128) NOT NULL,
       StringID             INTEGER NULL,
       Description          VARCHAR2(255) NULL,
       FieldName            VARCHAR2(64) NOT NULL,
       CRFieldName          VARCHAR2(128) NULL,
       DataType             smallint NOT NULL,
       DefaultValue         VARCHAR2(255) NULL,
       EWSFile              VARCHAR2(64) NULL
)
/


ALTER TABLE ReportFields
       ADD PRIMARY KEY (ReportFieldID)
/


CREATE TABLE ReportGroups (
       ReportGroupID        INTEGER ,
       ReportGroup          VARCHAR2(64) NOT NULL,
       Description          VARCHAR2(128) NOT NULL,
       SortOrder            INTEGER NOT NULL,
       OperatorGroupID      INTEGER NULL
)
/


ALTER TABLE ReportGroups
       ADD PRIMARY KEY (ReportGroupID)
/


CREATE TABLE ReportParameters (
       FileName             VARCHAR2(45) NOT NULL,
       ReportFieldID        INTEGER NOT NULL,
       Required             smallint DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE ReportParameters
       ADD PRIMARY KEY (FileName, ReportFieldID)
/


CREATE TABLE Reports (
       ReportID             INTEGER ,
       ReportGroupID        INTEGER NOT NULL,
       Report               VARCHAR2(35) NOT NULL,
       FileName             VARCHAR2(45) NOT NULL,
       GroupID              INTEGER NULL,
       ReportType           INTEGER DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE Reports
       ADD PRIMARY KEY (ReportID)
/


CREATE TABLE ReportSessionParameters (
       ReportSessionID      INTEGER NOT NULL,
       ParameterName        VARCHAR2(32) NOT NULL,
       ParameterData        VARCHAR2(128) NOT NULL
)
/


ALTER TABLE ReportSessionParameters
       ADD PRIMARY KEY (ReportSessionID, ParameterName)
/


CREATE TABLE ReportSessions (
       ReportSessionID      INTEGER ,
       OperatorID           INTEGER NOT NULL,
       SessionTag           VARCHAR2(16) NOT NULL,
       ReportName           VARCHAR2(128) NOT NULL,
       GroupSecurity        INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE ReportSessions
       ADD PRIMARY KEY (ReportSessionID)
/


CREATE TABLE ResellerPkgUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       PackageID            INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL,
       Days                 NUMBER DEFAULT (0)  NOT NULL,
       LastUpdate           DATE DEFAULT (SYSDATE)  NOT NULL,
       ItemID               INTEGER NULL
)
/

CREATE INDEX i_ResellerPkgUsage_PackageID ON ResellerPkgUsage
(
       PackageID,
       StartYear,
       StartMonth
)
/


ALTER TABLE ResellerPkgUsage
       ADD PRIMARY KEY (StartYear, StartMonth, PackageID, 
              PackageTypeID)
/


CREATE TABLE ResellerUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       AccountID            INTEGER NOT NULL,
       AccountTypeID        INTEGER NOT NULL,
       Days                 NUMBER DEFAULT 0  NOT NULL,
       LastUpdate           DATE DEFAULT SYSDATE  NOT NULL,
       ItemID               INTEGER NULL
)
/

CREATE INDEX i_ResellerUsage_AccountID ON ResellerUsage
(
       AccountID,
       StartYear,
       StartMonth
)
/


ALTER TABLE ResellerUsage
       ADD PRIMARY KEY (StartYear, StartMonth, AccountID, 
              AccountTypeID)
/


CREATE TABLE Roles (
       RoleID               INTEGER ,
       Role                 VARCHAR2(128) NOT NULL,
       GroupID              INTEGER NULL,
       AssignStrategyID     INTEGER NULL
)
/


ALTER TABLE Roles
       ADD PRIMARY KEY (RoleID)
/


CREATE TABLE SalesPersons (
       SalesPersonID        INTEGER ,
       SalesPerson          VARCHAR2(128) NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       OperatorID           INTEGER NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       CommissionGroupID    INTEGER NULL,
       CommissionValue      numeric(18,4) NULL
)
/

CREATE UNIQUE INDEX iSalesPersons_SalesPerson ON SalesPersons
(
       SalesPerson
)
/

CREATE INDEX I_SalesPersons_SPCG ON SalesPersons
(
       SalesPersonID,
       CommissionGroupID
)
/


ALTER TABLE SalesPersons
       ADD PRIMARY KEY (SalesPersonID)
/


CREATE TABLE ScheduleIntervals (
       Interval             VARCHAR2(32) NOT NULL,
       Seconds              INTEGER NOT NULL
)
/


ALTER TABLE ScheduleIntervals
       ADD PRIMARY KEY (Interval)
/


CREATE TABLE ScheduleLogs (
       ScheduleLogID        INTEGER ,
       ScheduleID           INTEGER NOT NULL,
       ScheduleServerID     INTEGER NULL,
       StartDate            DATE NOT NULL,
       EndDate              DATE NOT NULL,
       Status               smallint NOT NULL,
       Description          VARCHAR2(255) NULL
)
/

CREATE INDEX i_ScheduleLogs_StartDate ON ScheduleLogs
(
       StartDate
)
/


ALTER TABLE ScheduleLogs
       ADD PRIMARY KEY (ScheduleLogID)
/


CREATE TABLE Schedules (
       ScheduleID           INTEGER ,
       Server               VARCHAR2(32) NULL,
       ScheduleServerID     INTEGER NULL,
       TaskName             VARCHAR2(32) NOT NULL,
       Parameter            VARCHAR2(255) NULL,
       TargetSecs           INTEGER NULL,
       MaxSecs              INTEGER NULL,
       Status               smallint DEFAULT 0  NOT NULL,
       LastStatus           VARCHAR2(255) NULL,
       LastStart            DATE NULL,
       LastUpdate           DATE NULL,
       Interval             INTEGER DEFAULT 0  NOT NULL,
       StartDate            DATE NULL,
       Aligned              smallint DEFAULT 0  NOT NULL,
       Description          VARCHAR2(100) NULL,
       LockServerID         INTEGER NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       MaxConcurrent        INTEGER DEFAULT 1  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       Operator             VARCHAR2(64) DEFAULT (user)  NULL
)
/


ALTER TABLE Schedules
       ADD PRIMARY KEY (ScheduleID)
/


CREATE TABLE ScheduleServers (
       Server               VARCHAR2(32) NOT NULL,
       ScheduleServerID     INTEGER ,
       IPAddress            VARCHAR2(32) NULL,
       Port                 INTEGER NOT NULL,
       Description          VARCHAR2(100) NULL,
       LastStart            DATE DEFAULT SYSDATE  NULL,
       Signal               smallint DEFAULT 1  NOT NULL
)
/


ALTER TABLE ScheduleServers
       ADD PRIMARY KEY (Server)
/


CREATE TABLE ScheduleTasks (
       TaskName             VARCHAR2(32) NOT NULL,
       TaskType             VARCHAR2(32) NULL,
       Description          VARCHAR2(255) NULL
)
/


ALTER TABLE ScheduleTasks
       ADD PRIMARY KEY (TaskName)
/


CREATE TABLE SendMethods (
       SendMethodID         INTEGER ,
       Description          VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       GroupID              INTEGER NULL,
       ServiceGroupID       INTEGER NULL,
       ChargeTypeID         INTEGER NULL,
       PrintTypeID          smallint NULL,
       EmailTypeID          smallint NULL,
       SortOrder            smallint NOT NULL,
       PrintAutoTrans       smallint DEFAULT 0  NOT NULL,
       EmailAutoTrans       smallint DEFAULT 0  NOT NULL,
       CustomerAccess       smallint NULL
)
/


ALTER TABLE SendMethods
       ADD PRIMARY KEY (SendMethodID)
/


CREATE TABLE ServerAccess (
       ServerAccessID       INTEGER ,
       ServerID             INTEGER NULL,
       Port                 VARCHAR2(10) NULL,
       AccountTypeID        INTEGER NULL,
       StartTime            INTEGER NULL,
       StopTime             INTEGER NULL,
       MaxSessionLength     INTEGER DEFAULT 0  NULL
)
/


ALTER TABLE ServerAccess
       ADD PRIMARY KEY (ServerAccessID)
/


CREATE TABLE ServerGroups (
       ServerGroupID        INTEGER ,
       ServerGroup          VARCHAR2(32) NOT NULL
)
/


ALTER TABLE ServerGroups
       ADD PRIMARY KEY (ServerGroupID)
/


CREATE TABLE ServerHistory (
       ServerID             INTEGER NOT NULL,
       HistoryDate          DATE DEFAULT SYSDATE  NOT NULL,
       Calls                INTEGER DEFAULT 0  NOT NULL,
       Minutes              INTEGER DEFAULT 0  NOT NULL,
       Bytes                INTEGER DEFAULT 0  NOT NULL
)
/


ALTER TABLE ServerHistory
       ADD PRIMARY KEY (ServerID, HistoryDate)
/


CREATE TABLE ServerPorts (
       NASIdentifier        VARCHAR2(32) NOT NULL,
       Port                 VARCHAR2(32) NOT NULL,
       ServerID             INTEGER NULL,
       Username             VARCHAR2(64) DEFAULT null  NULL,
       AccountID            INTEGER NULL,
       AcctSessionID        VARCHAR2(32) DEFAULT null  NULL,
       AcctSessionTime      INTEGER NULL,
       AcctInputOctets      NUMBER(38) NULL,
       AcctOutputOctets     NUMBER(38) NULL,
       AcctStatusType       smallint DEFAULT null  NULL,
       CallDate             DATE DEFAULT SYSDATE  NOT NULL,
       FramedAddress        VARCHAR2(32) DEFAULT null  NULL,
       NASPortDNIS          VARCHAR2(64) NULL,
       CallerID             VARCHAR2(64) DEFAULT null  NULL,
       ConnectInfo          VARCHAR2(64) DEFAULT null  NULL,
       SNMPUser             VARCHAR2(64) DEFAULT null  NULL
)
/

CREATE INDEX i_ServerPorts_UserName ON ServerPorts
(
       Username
)
/

CREATE INDEX i_ServerPorts_CallerID ON ServerPorts
(
       CallerID
)
/

CREATE INDEX IX_ServerPorts ON ServerPorts
(
       AccountID,
       AcctStatusType
)
/


ALTER TABLE ServerPorts
       ADD PRIMARY KEY (NASIdentifier, Port)
/


CREATE TABLE Servers (
       ServerID             INTEGER ,
       ServerGroupID        INTEGER NOT NULL,
       Server               VARCHAR2(32) NOT NULL,
       ServerType           INTEGER NOT NULL,
       IPAddress            VARCHAR2(64) NOT NULL,
       Location             VARCHAR2(128) NULL,
       Ports                smallint DEFAULT 0  NULL,
       Modems               smallint DEFAULT 0  NULL,
       PhoneNumber          VARCHAR2(32) NULL,
       ContactName          VARCHAR2(64) NULL,
       ContactPhone         VARCHAR2(32) NULL,
       ContactPage          VARCHAR2(32) NULL,
       Comments             VARCHAR2(128) NULL,
       DynamicStart         VARCHAR2(16) NULL,
       DynamicEnd           VARCHAR2(16) NULL,
       Secret               VARCHAR2(255) DEFAULT null  NULL,
       Community            VARCHAR2(16) DEFAULT null  NULL,
       RadRoamServerID      INTEGER NULL,
       CheckAccess          INTEGER DEFAULT null  NULL,
       Concurrency          INTEGER DEFAULT 1  NULL,
       AuthPort             INTEGER NULL,
       AcctPort             INTEGER NULL,
       DisconnectPort       INTEGER NULL,
       DisconnectType       INT NULL
)
/

CREATE UNIQUE INDEX iIPAddress ON Servers
(
       IPAddress
)
/


ALTER TABLE Servers
       ADD PRIMARY KEY (ServerID)
/


CREATE TABLE ServerTypes (
       ServerType           INTEGER NOT NULL,
       Vendor               VARCHAR2(32) NULL,
       Model                VARCHAR2(32) NULL,
       SNMPType             INTEGER NULL,
       SNMPUser             VARCHAR2(64) NULL
)
/


ALTER TABLE ServerTypes
       ADD PRIMARY KEY (ServerType)
/


CREATE TABLE ServiceGroupItems (
       ServiceGroupID       INTEGER NOT NULL,
       GroupID              INTEGER NOT NULL
)
/

CREATE INDEX i_ServiceGroupItems_GroupID ON ServiceGroupItems
(
       GroupID
)
/


ALTER TABLE ServiceGroupItems
       ADD PRIMARY KEY (ServiceGroupID, GroupID)
/


CREATE TABLE ServiceGroups (
       ServiceGroupID       INTEGER ,
       ServiceGroup         VARCHAR2(128) NOT NULL,
       Description          CLOB NULL,
       AllowAccountTypes    smallint DEFAULT 1  NOT NULL,
       AllowPackageTypes    smallint DEFAULT 1  NOT NULL,
       AllowBillingCycles   smallint DEFAULT 1  NOT NULL,
       AllowRegions         smallint DEFAULT 1  NOT NULL,
       AllowDomains         smallint DEFAULT 1  NOT NULL,
       AllowPayPeriods      smallint DEFAULT 1  NOT NULL,
       AllowChargeTypes     smallint DEFAULT 1  NOT NULL,
       AllowSalesPersons    smallint DEFAULT 1  NOT NULL,
       AllowDiscounts       smallint DEFAULT 1  NOT NULL,
       AllowSendMethods     smallint DEFAULT 1  NOT NULL,
       AllowIncidentTypes   smallint DEFAULT 1  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE ServiceGroups
       ADD PRIMARY KEY (ServiceGroupID)
/


CREATE TABLE SignupPackageTypes (
       SignupPackageTypeID  INTEGER ,
       SignupServerID       INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL
)
/

CREATE UNIQUE INDEX i_SPT_Signup_Package ON SignupPackageTypes
(
       SignupServerID,
       PackageTypeID
)
/


ALTER TABLE SignupPackageTypes
       ADD PRIMARY KEY (SignupPackageTypeID)
/


CREATE TABLE SignupServers (
       SignupServerID       INTEGER ,
       SignupServer         VARCHAR2(128) NOT NULL,
       Description          CLOB NULL,
       ThemeID              INTEGER NOT NULL,
       GroupID              INTEGER NOT NULL,
       RegionID             INTEGER NOT NULL,
       PackageTypeID        INTEGER NULL,
       CountryID            INTEGER NULL,
       SalesPersonID        INTEGER NULL,
       DiscountID           INTEGER NOT NULL,
       DomainID             INTEGER NOT NULL,
       LogOffURL            VARCHAR2(128) NULL,
       ServerPOP3           VARCHAR2(64) NULL,
       ServerSMTP           VARCHAR2(64) NULL,
       ServerNNTP           VARCHAR2(64) NULL,
       ServerDNS1           VARCHAR2(64) NULL,
       ServerDNS2           VARCHAR2(64) NULL,
       ServerIMAP4          VARCHAR2(64) NULL,
       ServerMisc1          VARCHAR2(64) NULL,
       ServerMisc2          VARCHAR2(64) NULL,
       ShowCompany          smallint DEFAULT 1  NOT NULL,
       ShowAddress          smallint DEFAULT 1  NOT NULL,
       ShowPhone            smallint DEFAULT 1  NOT NULL,
       ShowEmail            smallint DEFAULT 1  NOT NULL,
       ShowReferredBy       smallint DEFAULT 1  NOT NULL,
       LoginFillType        smallint DEFAULT 0  NOT NULL,
       SetupCharge          smallint DEFAULT 1  NOT NULL,
       AddressTypeID        INTEGER NULL,
       AddressDescription   VARCHAR2(128) NULL,
       Title                VARCHAR2(128) NULL,
       ShowLogin            smallint NULL,
       PrepaidTransfer      smallint NULL
)
/


ALTER TABLE SignupServers
       ADD PRIMARY KEY (SignupServerID)
/


CREATE TABLE Statements (
       StatementID          INTEGER ,
       BatchID              INTEGER NULL,
       CustomerID           INTEGER NOT NULL,
       StatementDate        DATE DEFAULT SYSDATE  NOT NULL,
       SentDate             DATE NULL,
       DueDate              DATE NULL,
       PrevBal              numeric(18,4) DEFAULT 0  NOT NULL,
       NewCharges           numeric(18,4) NOT NULL,
       NewCredits           numeric(18,4) NOT NULL,
       EndBal               numeric(18,4) DEFAULT 0  NOT NULL,
       End0Bal              numeric(18,4) DEFAULT 0  NOT NULL,
       End30Bal             numeric(18,4) DEFAULT 0  NOT NULL,
       End60Bal             numeric(18,4) DEFAULT 0  NOT NULL,
       End90Bal             numeric(18,4) DEFAULT 0  NOT NULL,
       End120Bal            numeric(18,4) DEFAULT 0  NOT NULL,
       PrintDate            DATE NULL,
       EmailDate            DATE NULL,
       PrintBatchID         INTEGER NULL
)
/

CREATE INDEX XIE1Statements ON Statements
(
       StatementDate
)
/

CREATE INDEX i_Statements_PrintBatchID ON Statements
(
       PrintBatchID
)
/

CREATE INDEX i_Statements_CustomerID ON Statements
(
       CustomerID
)
/


ALTER TABLE Statements
       ADD PRIMARY KEY (StatementID)
/


CREATE TABLE States (
       StateID              INTEGER ,
       CountryID            INTEGER NOT NULL,
       State                VARCHAR2(64) NOT NULL,
       Abbreviation         VARCHAR2(10) NULL,
       SortOrder            smallint DEFAULT 10  NOT NULL,
       TimeZone1            numeric(4,2) NULL,
       TimeZone2            numeric(4,2) NULL
)
/

CREATE UNIQUE INDEX i_States_Country_State ON States
(
       State,
       CountryID
)
/


ALTER TABLE States
       ADD PRIMARY KEY (StateID)
/


CREATE TABLE Strings (
       StringID             INTEGER NOT NULL,
       LanguageID           INTEGER NOT NULL,
       ApplicationID        INTEGER NOT NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE Strings
       ADD PRIMARY KEY (StringID, LanguageID, ApplicationID)
/


CREATE TABLE SubAccountData (
       AccountID            INTEGER NOT NULL,
       AccountDataTypeID    INTEGER NOT NULL,
       Data                 VARCHAR2(255) NULL
)
/


ALTER TABLE SubAccountData
       ADD PRIMARY KEY (AccountID, AccountDataTypeID)
/


CREATE TABLE SubAccountDataTypes (
       SubAccountDataTypeID INTEGER ,
       AccountTypeID        INTEGER NULL,
       AccountDataTypeID    INTEGER NOT NULL,
       DefaultData          VARCHAR2(128) NULL,
       SortOrder            smallint DEFAULT 10  NOT NULL,
       Required             smallint NULL
)
/

CREATE UNIQUE INDEX IX_SubAccountDataTypes ON SubAccountDataTypes
(
       AccountTypeID,
       AccountDataTypeID
)
/


ALTER TABLE SubAccountDataTypes
       ADD PRIMARY KEY (SubAccountDataTypeID)
/


CREATE TABLE SubAccounts (
       AccountID            INTEGER ,
       CustomerID           INTEGER NOT NULL,
       Login                VARCHAR2(40) NULL,
       Email                VARCHAR2(64) NULL,
       FirstName            VARCHAR2(40) NULL,
       MiddleName           VARCHAR2(25) NULL,
       LastName             VARCHAR2(40) NULL,
       PhoneHome            VARCHAR2(32) NULL,
       PhoneWork            VARCHAR2(32) NULL,
       DiffCost             smallint DEFAULT 0  NOT NULL,
       AccountTypeID        INTEGER NOT NULL,
       PayPeriodID          INTEGER NOT NULL,
       Cost                 numeric(18,4) DEFAULT 0  NULL,
       DiscountID           INTEGER NOT NULL,
       Comments             CLOB NULL,
       Password             VARCHAR2(128) NULL,
       MaidenName           VARCHAR2(25) NULL,
       CreateDate           DATE DEFAULT SYSDATE  NOT NULL,
       StartDate            DATE DEFAULT SYSDATE  NOT NULL,
       BilledThru           DATE DEFAULT null  NOT NULL,
       ExpireDate           DATE DEFAULT null  NULL,
       Extension            INTEGER DEFAULT 0  NOT NULL,
       Active               smallint DEFAULT 1  NOT NULL,
       SalesPersonID        INTEGER NULL,
       Operator             VARCHAR2(64) DEFAULT (user)  NOT NULL,
       LastModifyDate       DATE DEFAULT SYSDATE  NOT NULL,
       LastModifyUser       VARCHAR2(64) DEFAULT (user)  NOT NULL,
       Preferred            smallint DEFAULT 0  NOT NULL,
       Status               smallint DEFAULT 1  NOT NULL,
       TimeLeft             INTEGER DEFAULT null  NULL,
       SendBill             smallint DEFAULT 1  NOT NULL,
       RemoteAccess         smallint DEFAULT 1  NULL,
       LoginLimit           smallint DEFAULT 1  NULL,
       BillStatus           smallint NULL,
       LastUsed             DATE DEFAULT null  NULL,
       DomainID             INTEGER NOT NULL,
       Gender               VARCHAR2(1) NULL,
       Salutation           char(4) NULL,
       LastTimeLeftDate     DATE DEFAULT SYSDATE  NULL,
       CycleMonths          INTEGER DEFAULT 0  NOT NULL,
       PackageID            INTEGER NULL,
       CancelDate           DATE NULL,
       CancelReasonID       INTEGER NULL,
       LastInvoiceID        INTEGER NULL,
       DataLeft             NUMBER(38) NULL,
       LastDataLeftDate     DATE NULL
)
/

CREATE INDEX iLastName_2 ON SubAccounts
(
       LastName
)
/

CREATE INDEX i_SA_PhoneHome ON SubAccounts
(
       PhoneHome
)
/

CREATE INDEX i_SA_PhoneWork ON SubAccounts
(
       PhoneWork
)
/

CREATE INDEX i_SubAccounts_LMD ON SubAccounts
(
       LastModifyDate
)
/

CREATE INDEX iLogin ON SubAccounts
(
       Login
)
/

CREATE INDEX iExpireDate ON SubAccounts
(
       ExpireDate
)
/

CREATE INDEX i_SubAccounts_Email ON SubAccounts
(
       Email
)
/

CREATE INDEX i_SubAccounts_Password ON SubAccounts
(
       Password
)
/

CREATE INDEX i_SubAccounts_LastUsed ON SubAccounts
(
       LastUsed
)
/

CREATE INDEX iSubAccounts_CustomerID ON SubAccounts
(
       CustomerID
)
/

CREATE INDEX iSubAccounts_AccountTypeID ON SubAccounts
(
       AccountTypeID
)
/

CREATE INDEX iSubAccounts_PackageID ON SubAccounts
(
       PackageID
)
/


ALTER TABLE SubAccounts
       ADD PRIMARY KEY (AccountID)
/


CREATE TABLE SubAccountUsages (
       SubAccountUsageID    INTEGER ,
       AccountID            INTEGER NOT NULL,
       ExpireDate           DATE NOT NULL,
       TimeLeft             INTEGER NULL,
       DataLeft             NUMBER(38) NULL,
       ItemID               INTEGER NULL,
       StartTimeLeft        INTEGER NULL,
       StartDataLeft        NUMBER(38) NULL
)
/

CREATE INDEX IX_SAU_AIDEXPTLDL ON SubAccountUsages
(
       AccountID,
       ExpireDate,
       TimeLeft,
       DataLeft
)
/

CREATE INDEX IX_SAU_ItemID ON SubAccountUsages
(
       ItemID
)
/


ALTER TABLE SubAccountUsages
       ADD PRIMARY KEY (SubAccountUsageID)
/


CREATE TABLE SysLogFilters (
       SysLogFilterID       INTEGER ,
       IPAddress            VARCHAR2(32) NULL,
       Severity             smallint DEFAULT 0  NOT NULL,
       SubString            VARCHAR2(255) NULL
)
/


ALTER TABLE SysLogFilters
       ADD PRIMARY KEY (SysLogFilterID)
/


CREATE TABLE SysLogs (
       SyslogID             NUMBER(38) ,
       LogDate              DATE DEFAULT SYSDATE  NOT NULL,
       Severity             smallint DEFAULT 0  NOT NULL,
       Facility             smallint DEFAULT 0  NOT NULL,
       IPAddress            VARCHAR2(32) NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/

CREATE INDEX IX_SysLogs_LogDate ON SysLogs
(
       LogDate
)
/

CREATE INDEX IX_SysLogs_IPAddress ON SysLogs
(
       IPAddress
)
/


ALTER TABLE SysLogs
       ADD PRIMARY KEY (SyslogID)
/


CREATE TABLE Taxes (
       TaxID                INTEGER ,
       Description          VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       Tax                  numeric(18,4) DEFAULT 0  NOT NULL,
       AmountType           smallint DEFAULT 1  NOT NULL,
       CumulativeType       smallint NULL,
       FloorLimit           numeric(18,4) NULL,
       CeilingLimit         numeric(18,4) NULL,
       TaxPiggyBackID       INTEGER NULL,
       TaxPigOrder          smallint DEFAULT 1  NOT NULL,
       GLCodeID             INTEGER NULL,
       TaxExemptions        INTEGER DEFAULT 0  NOT NULL,
       TaxCredits           smallint DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 0  NULL,
       TaxTypeID            INTEGER NULL
)
/


ALTER TABLE Taxes
       ADD PRIMARY KEY (TaxID)
/


CREATE TABLE TaxExemptions (
       TaxExemptionID       INTEGER NOT NULL,
       Exemption            VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL,
       AllowMBR             smallint DEFAULT 0  NOT NULL,
       AllowItem            smallint DEFAULT 0  NOT NULL,
       Active               smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE TaxExemptions
       ADD PRIMARY KEY (TaxExemptionID)
/


CREATE TABLE TaxGroups (
       TaxGroupID           INTEGER ,
       TaxGroup             VARCHAR2(64) NOT NULL
)
/


ALTER TABLE TaxGroups
       ADD PRIMARY KEY (TaxGroupID)
/


CREATE TABLE TaxGroupTaxes (
       TaxGroupTaxID        INTEGER ,
       TaxGroupID           INTEGER NOT NULL,
       TaxID                INTEGER NOT NULL,
       StateID              INTEGER NULL,
       CountryID            INTEGER NULL,
       RegionID             INTEGER NULL,
       City                 VARCHAR2(45) NULL,
       Zip                  VARCHAR2(15) NULL
)
/

CREATE UNIQUE INDEX IX_TaxGroupTaxes ON TaxGroupTaxes
(
       TaxGroupID,
       TaxID,
       StateID,
       CountryID,
       RegionID,
       City,
       Zip
)
/


ALTER TABLE TaxGroupTaxes
       ADD PRIMARY KEY (TaxGroupTaxID)
/


CREATE TABLE TaxPiggyBacks (
       TaxPiggyBackID       INTEGER ,
       TaxPiggyBack         VARCHAR2(64) NULL
)
/


ALTER TABLE TaxPiggyBacks
       ADD PRIMARY KEY (TaxPiggyBackID)
/


CREATE TABLE TaxTypes (
       TaxTypeID            INTEGER ,
       TaxType              VARCHAR2(64) NOT NULL
)
/


ALTER TABLE TaxTypes
       ADD PRIMARY KEY (TaxTypeID)
/


CREATE TABLE ThemeFilters (
       ThemeFilterID        INTEGER ,
       ThemeFilter          VARCHAR2(128) NOT NULL,
       Description          CLOB NULL,
       ThemeID              INTEGER NOT NULL,
       ThemeMatchTypeID     INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL,
       Score                INTEGER NOT NULL
)
/


ALTER TABLE ThemeFilters
       ADD PRIMARY KEY (ThemeFilterID)
/


CREATE TABLE ThemeMatchTypes (
       ThemeMatchTypeID     INTEGER NOT NULL,
       ThemeMatchType       VARCHAR2(128) NOT NULL,
       Hidden               smallint DEFAULT 0  NOT NULL
)
/


ALTER TABLE ThemeMatchTypes
       ADD PRIMARY KEY (ThemeMatchTypeID)
/


CREATE TABLE Themes (
       ThemeID              INTEGER ,
       Theme                VARCHAR2(50) NOT NULL,
       Description          CLOB NULL
)
/


ALTER TABLE Themes
       ADD PRIMARY KEY (ThemeID)
/


CREATE TABLE TimeCharges (
       TimeChargeID         INTEGER ,
       TimeCharge           VARCHAR2(128) NOT NULL,
       StringID             INTEGER NULL,
       Description          CLOB NULL,
       ChargeTypeID         INTEGER NOT NULL,
       AccountTypeID        INTEGER NULL,
       PackageTypeID        INTEGER NULL,
       Months               INTEGER NULL,
       Days                 INTEGER NULL,
       Minutes              INTEGER NULL,
       TimeLeft             INTEGER NULL,
       CustomerAccess       smallint DEFAULT 0  NOT NULL,
       SortOrder            smallint DEFAULT 0  NOT NULL,
       DataLeft             NUMBER(38) NULL
)
/

CREATE UNIQUE INDEX IX_TimeCharges_AccountTypes ON TimeCharges
(
       ChargeTypeID,
       AccountTypeID
)
/

CREATE UNIQUE INDEX IX_TimeCharges_PackageType ON TimeCharges
(
       ChargeTypeID,
       PackageTypeID
)
/

CREATE INDEX I_TimeCharges_ATID_CTID ON TimeCharges
(
       AccountTypeID,
       ChargeTypeID
)
/

CREATE INDEX I_TimeCharges_PTID_ATID ON TimeCharges
(
       PackageTypeID,
       AccountTypeID
)
/


ALTER TABLE TimeCharges
       ADD PRIMARY KEY (TimeChargeID)
/


CREATE TABLE TimeZones (
       TimeZoneID           numeric(4,2) NOT NULL,
       TimeZone             VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE TimeZones
       ADD PRIMARY KEY (TimeZoneID)
/


CREATE TABLE TransStates (
       TransStateID         INTEGER NOT NULL,
       TransState           VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE TransStates
       ADD PRIMARY KEY (TransStateID)
/


CREATE TABLE TransTypes (
       TransTypeID          INTEGER NOT NULL,
       TransType            VARCHAR2(64) NOT NULL,
       StringID             INTEGER NULL
)
/


ALTER TABLE TransTypes
       ADD PRIMARY KEY (TransTypeID)
/


CREATE TABLE VoiceCalls (
       VoiceCallID          NUMBER(38) ,
       AccountID            INTEGER NULL,
       CallDate             DATE NOT NULL,
       Login                VARCHAR2(64) NOT NULL,
       Duration             INTEGER NOT NULL,
       SessionRef           VARCHAR2(64) NULL,
       CalledNumber         VARCHAR2(64) NULL,
       CallingPort          VARCHAR2(32) NULL,
       CalledPort           VARCHAR2(32) NULL,
       Bytes                NUMBER(38) NULL,
       CallType             VARCHAR2(64) NULL,
       AcctTerminateCause   smallint NULL,
       CountryID            INTEGER NULL,
       StateID              INTEGER NULL,
       Location             VARCHAR2(64) NULL,
       ChargeID             INTEGER NULL,
       ProcDate             DATE NULL,
       ErrorCode            smallint NULL,
       Cost                 numeric(18,4) NULL
)
/

CREATE UNIQUE INDEX i_VoiceCalls_Unique ON VoiceCalls
(
       CallDate,
       Login,
       Duration,
       SessionRef,
       CalledNumber
)
/

CREATE INDEX i_VoiceCalls_AID_CD ON VoiceCalls
(
       AccountID,
       CallDate
)
/

CREATE INDEX i_VoiceCalls_C_PD ON VoiceCalls
(
       ChargeID,
       ProcDate
)
/


ALTER TABLE VoiceCalls
       ADD PRIMARY KEY (VoiceCallID)
/


CREATE TABLE WebAccess (
       WebAccess            INTEGER NOT NULL,
       Name                 VARCHAR2(32) NOT NULL
)
/


ALTER TABLE WebAccess
       ADD PRIMARY KEY (WebAccess)
/


CREATE TABLE WebLinks (
       WebLinkID            INTEGER ,
       LinkType             INTEGER DEFAULT 1  NOT NULL,
       SortOrder            INTEGER DEFAULT 1  NOT NULL,
       Title                VARCHAR2(64) NOT NULL,
       URL                  VARCHAR2(128) NOT NULL
)
/


ALTER TABLE WebLinks
       ADD PRIMARY KEY (WebLinkID)
/


ALTER TABLE AccountDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES DataTypes
/


ALTER TABLE AccountDataValues
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES AccountDataTypes
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (AccountTemplateID)
                             REFERENCES AccountTemplates
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES TaxGroups
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES RateClasses
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES DNISGroups
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE Actions
       ADD FOREIGN KEY (CreateAccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Actions
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES Incidents
/


ALTER TABLE Actions
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES Operators
/


ALTER TABLE Actions
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES Operators
/


ALTER TABLE Actions
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES IncidentTypes
/


ALTER TABLE Actions
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES Roles
/


ALTER TABLE Actions
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES IncidentStates
/


ALTER TABLE Addresses
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE Addresses
       ADD FOREIGN KEY (StateID)
                             REFERENCES States
/


ALTER TABLE Addresses
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES AddressTypes
/


ALTER TABLE Addresses
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Aliases
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE AuditLogs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES LogMsgs
/


ALTER TABLE BankTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Batches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE BatchProcessors
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE BatchProcessors
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/


ALTER TABLE BatchProcessors
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
/


ALTER TABLE BillingCycles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE BillingCycles
       ADD FOREIGN KEY (LateFeeID)
                             REFERENCES LateFees
/


ALTER TABLE BillingCycles
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE CardAccounts
       ADD FOREIGN KEY (DirectAccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE CardAccounts
       ADD FOREIGN KEY (DirectCustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE CardAccounts
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/


ALTER TABLE CardAccounts
       ADD FOREIGN KEY (CardBatchID)
                             REFERENCES CardBatches
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES BillingCycles
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES SendMethods
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (CardBatchTypeID)
                             REFERENCES CardBatchTypes
/


ALTER TABLE CardBatches
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES BillingCycles
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES SendMethods
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (LoginCardDigitID)
                             REFERENCES CardDigits
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (PasswordCardDigitID)
                             REFERENCES CardDigits
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
/


ALTER TABLE CardBatchTypes
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
/


ALTER TABLE CardTypePrefixes
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES CardTypes
/


ALTER TABLE CCImportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
/


ALTER TABLE Charges
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES TaxGroups
/


ALTER TABLE Charges
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Charges
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Charges
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE Charges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE Charges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE Charges
       ADD FOREIGN KEY (PackageID)
                             REFERENCES Packages
/


ALTER TABLE Charges
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
/


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES TaxGroups
/


ALTER TABLE CommissionItems
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES CommissionGroups
/


ALTER TABLE CommissionItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE CommissionItems
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE CommissionItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE ConfigGroupData
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE ConfigGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES Configs
/


ALTER TABLE ConfigOperatorGroupData
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES Configs
/


ALTER TABLE ConfigOperatorGroupData
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES OperatorGroups
/


ALTER TABLE Configs
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES DataTypes
/


ALTER TABLE Configs
       ADD FOREIGN KEY (ConfigGroupID)
                             REFERENCES ConfigGroups
/


ALTER TABLE ConfigValues
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES Configs
/


ALTER TABLE Countries
       ADD FOREIGN KEY (ContinentID)
                             REFERENCES Continents
/


ALTER TABLE CreditCards
       ADD FOREIGN KEY (BillToCountryID)
                             REFERENCES Countries
/


ALTER TABLE CreditCards
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE CreditCards
       ADD FOREIGN KEY (BillToStateID)
                             REFERENCES States
/


ALTER TABLE CreditCards
       ADD FOREIGN KEY (CardTypeID)
                             REFERENCES CardTypes
/


ALTER TABLE Currencies
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE CustomerSettings
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Discounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE Discounts
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE DNISNumbers
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES DNISGroups
/


ALTER TABLE Documents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Documents
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Domains
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Domains
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE Domains
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE ExportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
/


ALTER TABLE ExternalSyncs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE ExternalSyncs
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES ExternalSystems
/


ALTER TABLE ExternalSystemAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE ExternalSystemAccountTypes
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES ExternalSystems
/


ALTER TABLE ExternalSystemDataTypes
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES ExternalSystemTypes
/


ALTER TABLE ExternalSystemDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES AccountDataTypes
/


ALTER TABLE ExternalSystems
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
/


ALTER TABLE ExternalSystems
       ADD FOREIGN KEY (ExternalSystemTypeID)
                             REFERENCES ExternalSystemTypes
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (TransStateID)
                             REFERENCES TransStates
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (TransTypeID)
                             REFERENCES TransTypes
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES Invoices
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (BatchProcessorID)
                             REFERENCES BatchProcessors
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (AuthStateID)
                             REFERENCES States
/


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES Payments
/


ALTER TABLE FileTransfers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE FlowFilters
       ADD FOREIGN KEY (FlowFilterGroupID)
                             REFERENCES FlowFilterGroups
/


ALTER TABLE Forwards
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Groups
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/


ALTER TABLE Groups
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES Themes
/


ALTER TABLE Groups
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
/


ALTER TABLE IncidentData
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES Incidents
/


ALTER TABLE IncidentData
       ADD FOREIGN KEY (IncidentDataTypeID)
                             REFERENCES IncidentDataTypes
/


ALTER TABLE IncidentDataTypes
       ADD FOREIGN KEY (IncidentTemplateID)
                             REFERENCES IncidentTemplates
/


ALTER TABLE IncidentDataTypes
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES DataTypes
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (AssignRoleID)
                             REFERENCES Roles
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (PriorityID)
                             REFERENCES Priorities
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (AssignOperatorID)
                             REFERENCES Operators
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES IncidentTypes
/


ALTER TABLE Incidents
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES IncidentStates
/


ALTER TABLE IncidentStates
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES IncidentStateGroups
/


ALTER TABLE IncidentTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE IncidentTypes
       ADD FOREIGN KEY (IncidentStateGroupID)
                             REFERENCES IncidentStateGroups
/


ALTER TABLE IncidentTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (PackageID)
                             REFERENCES Packages
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES Charges
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (ItemType)
                             REFERENCES InvoiceItemTypes
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES TaxGroups
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES Invoices
/


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
/


ALTER TABLE Invoices
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES Batches
/


ALTER TABLE Invoices
       ADD FOREIGN KEY (BatchID)
                             REFERENCES Batches
/


ALTER TABLE Invoices
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Invoices
       ADD FOREIGN KEY (StatementID)
                             REFERENCES Statements
/


ALTER TABLE Invoices
       ADD FOREIGN KEY (InvoiceTypeID)
                             REFERENCES InvoiceTypes
/


ALTER TABLE IPs
       ADD FOREIGN KEY (IPClassID)
                             REFERENCES IPClasses
/


ALTER TABLE LateFees
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE LocPhones
       ADD FOREIGN KEY (StateID)
                             REFERENCES States
/


ALTER TABLE LocZipCodes
       ADD FOREIGN KEY (StateID)
                             REFERENCES States
/


ALTER TABLE Logs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES LogMsgs
/


ALTER TABLE MasterAccountData
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE MasterAccountDataTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE MasterAccountDataTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE MasterAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES AccountDataTypes
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES BillingCycles
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES Languages
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES SendMethods
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (RegionID)
                             REFERENCES Regions
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES PaymentTypes
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES CancelReasons
/


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (LastStatementID)
                             REFERENCES Statements
/


ALTER TABLE MenuSets
       ADD FOREIGN KEY (MenuItemID)
                             REFERENCES MenuItems
/


ALTER TABLE MenuSets
       ADD FOREIGN KEY (MenuID)
                             REFERENCES Menus
/


ALTER TABLE MetaColumns
       ADD FOREIGN KEY (MetaRuleID)
                             REFERENCES MetaRules
/


ALTER TABLE MetaColumns
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES MetaTables
/


ALTER TABLE NoticeActives
       ADD FOREIGN KEY (NoticeID)
                             REFERENCES Notices
/


ALTER TABLE Notices
       ADD FOREIGN KEY (NoticeTypeID)
                             REFERENCES NoticeTypes
/


ALTER TABLE ObjectGroups
       ADD FOREIGN KEY (ReportID)
                             REFERENCES Reports
/


ALTER TABLE Objects
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES ObjectGroups
/


ALTER TABLE OperatorGroupAccess
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE OperatorGroupAccess
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES ObjectGroups
/


ALTER TABLE OperatorRoles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE OperatorRoles
       ADD FOREIGN KEY (RoleID)
                             REFERENCES Roles
/


ALTER TABLE OperatorRoles
       ADD FOREIGN KEY (OperatorID)
                             REFERENCES Operators
/


ALTER TABLE Operators
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE Operators
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES PrintTypes
/


ALTER TABLE Operators
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES Languages
/


ALTER TABLE Operators
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES OperatorGroups
/


ALTER TABLE Operators
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES Themes
/


ALTER TABLE OrgAccountTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/


ALTER TABLE OrgAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE Organizations
       ADD FOREIGN KEY (CurrencyID)
                             REFERENCES Currencies
/


ALTER TABLE Organizations
       ADD FOREIGN KEY (ResellerCustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE OrgPackageTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/


ALTER TABLE OrgPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE PackageAccountTypes
       ADD FOREIGN KEY (NonPkgDiscountID)
                             REFERENCES Discounts
/


ALTER TABLE PackageAccountTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE PackageAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE Packages
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Packages
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
/


ALTER TABLE Packages
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE Packages
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
/


ALTER TABLE Packages
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE Packages
       ADD FOREIGN KEY (CreateOperatorID)
                             REFERENCES Operators
/


ALTER TABLE Packages
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES CancelReasons
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES BillingCycles
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (TaxGroupID)
                             REFERENCES TaxGroups
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (NextID)
                             REFERENCES PackageTypes
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES SendMethods
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (PrimaryAccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE PackageTypes
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE PaymentItems
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES Charges
/


ALTER TABLE PaymentItems
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES Payments
/


ALTER TABLE PaymentItems
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/


ALTER TABLE Payments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE Payments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES PaymentTypes
/


ALTER TABLE Payments
       ADD FOREIGN KEY (StatementID)
                             REFERENCES Statements
/


ALTER TABLE PaymentTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
/


ALTER TABLE PayPeriods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE PayPeriods
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE PayPeriods
       ADD FOREIGN KEY (PeriodTypeID)
                             REFERENCES PeriodTypes
/


ALTER TABLE PayPeriods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE RadATConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadATConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE RadAttributes
       ADD FOREIGN KEY (RadVendorID)
                             REFERENCES RadVendors
/


ALTER TABLE RadConcurrency
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE RadConcurrency
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE RadConfigs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE RadConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadFilterGroups
       ADD FOREIGN KEY (RadDestTypeID)
                             REFERENCES RadDestTypes
/


ALTER TABLE RadFilterGroups
       ADD FOREIGN KEY (RadSourceTypeID)
                             REFERENCES RadSourceTypes
/


ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadFilterGroupID)
                             REFERENCES RadFilterGroups
/


ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadFilterTypeID)
                             REFERENCES RadFilterTypes
/


ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES RadMergeTypes
/


ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadSearchTypeID)
                             REFERENCES RadSearchTypes
/


ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES RadIPGroups
/


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES ServerGroups
/


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE RadIPAddresses
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE RadIPAddresses
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES RadIPGroups
/


ALTER TABLE RadLogs
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES RadLogMsgs
/


ALTER TABLE RadMapValues
       ADD FOREIGN KEY (MapAttribute, RadMapTypeID)
                             REFERENCES RadMapAttributes
/


ALTER TABLE RadProxyAttributes
       ADD FOREIGN KEY (RadProxyAttributeGroupID)
                             REFERENCES RadProxyAttributeGroups
/


ALTER TABLE RadProxyAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
/


ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES RadLogMsgs
/


ALTER TABLE RadRejects
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/


ALTER TABLE RadRoamDomains
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES RadRoamServers
/


ALTER TABLE RadRoamDomains
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE RadTriggers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE RateDataSources
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateIntervals
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES RateRuleTypes
/


ALTER TABLE RateItems
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES RateTimeGroups
/


ALTER TABLE RateItems
       ADD FOREIGN KEY (RateID)
                             REFERENCES Rates
/


ALTER TABLE RateRules
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateRules
       ADD FOREIGN KEY (RateRoundTypeID)
                             REFERENCES RateRoundTypes
/


ALTER TABLE RateRules
       ADD FOREIGN KEY (RateTypeID)
                             REFERENCES RateTypes
/


ALTER TABLE RateRules
       ADD FOREIGN KEY (RateRuleTypeID)
                             REFERENCES RateRuleTypes
/


ALTER TABLE RateRules
       ADD FOREIGN KEY (Interval)
                             REFERENCES RateIntervals
/


ALTER TABLE Rates
       ADD FOREIGN KEY (ClassifierRateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE Rates
       ADD FOREIGN KEY (DataRateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE Rates
       ADD FOREIGN KEY (RateClassID)
                             REFERENCES RateClasses
/


ALTER TABLE Rates
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE Rates
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE RateStdGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE RateStdGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES Priorities
/


ALTER TABLE RateStdItems
       ADD FOREIGN KEY (RateStdGroupID)
                             REFERENCES RateStdGroups
/


ALTER TABLE RateStdItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES RateMatchTypes
/


ALTER TABLE RateTimes
       ADD FOREIGN KEY (RateTimeGroupID)
                             REFERENCES RateTimeGroups
/


ALTER TABLE RateTimes
       ADD FOREIGN KEY (Priority)
                             REFERENCES Priorities
/


ALTER TABLE RateTypes
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateVCondGroups
       ADD FOREIGN KEY (Priority)
                             REFERENCES Priorities
/


ALTER TABLE RateVCondGroups
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE RateVCondGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateVCondItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES RateMatchTypes
/


ALTER TABLE RateVCondItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES RateVCondGroups
/


ALTER TABLE RateVDNIS
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE RateVDNIS
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES RateVDNIS
/


ALTER TABLE RateVDNISGroupItems
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES RateVDNISGroups
/


ALTER TABLE RateVDNISGroupItems
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES RateVCondGroups
/


ALTER TABLE RateVDNISGroups
       ADD FOREIGN KEY (RateSourceID)
                             REFERENCES RateSources
/


ALTER TABLE RateVDNISItems
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE RateVDNISItems
       ADD FOREIGN KEY (RateMatchTypeID)
                             REFERENCES RateMatchTypes
/


ALTER TABLE RateVDNISItems
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES RateVDNIS
/


ALTER TABLE RateVDNISItems
       ADD FOREIGN KEY (StateID)
                             REFERENCES States
/


ALTER TABLE RateVRates
       ADD FOREIGN KEY (RateRuleID)
                             REFERENCES RateRules
/


ALTER TABLE RateVRates
       ADD FOREIGN KEY (RateVCondGroupID)
                             REFERENCES RateVCondGroups
/


ALTER TABLE RateVRates
       ADD FOREIGN KEY (RateVDNISID)
                             REFERENCES RateVDNIS
/


ALTER TABLE RateVRates
       ADD FOREIGN KEY (RateVDNISGroupID)
                             REFERENCES RateVDNISGroups
/


ALTER TABLE ReferredBys
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE Regions
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE Regions
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE ReportGroups
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES OperatorGroups
/


ALTER TABLE ReportParameters
       ADD FOREIGN KEY (ReportFieldID)
                             REFERENCES ReportFields
/


ALTER TABLE Reports
       ADD FOREIGN KEY (ReportGroupID)
                             REFERENCES ReportGroups
/


ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/


ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (PackageID)
                             REFERENCES Packages
/


ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE ResellerUsage
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE ResellerUsage
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE ResellerUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/


ALTER TABLE Roles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE SalesPersons
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE SalesPersons
       ADD FOREIGN KEY (CommissionGroupID)
                             REFERENCES CommissionGroups
/


ALTER TABLE SalesPersons
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE Schedules
       ADD FOREIGN KEY (Server)
                             REFERENCES ScheduleServers
/


ALTER TABLE SendMethods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE SendMethods
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE SendMethods
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES PrintTypes
/


ALTER TABLE SendMethods
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE SendMethods
       ADD FOREIGN KEY (EmailTypeID)
                             REFERENCES EmailTypes
/


ALTER TABLE ServerAccess
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
/


ALTER TABLE ServerAccess
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE ServerHistory
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
/


ALTER TABLE ServerPorts
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
/


ALTER TABLE Servers
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES ServerGroups
/


ALTER TABLE Servers
       ADD FOREIGN KEY (ServerType)
                             REFERENCES ServerTypes
/


ALTER TABLE Servers
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES RadRoamServers
/


ALTER TABLE ServiceGroupItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE ServiceGroupItems
       ADD FOREIGN KEY (ServiceGroupID)
                             REFERENCES ServiceGroups
/


ALTER TABLE SignupPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE SignupPackageTypes
       ADD FOREIGN KEY (SignupServerID)
                             REFERENCES SignupServers
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES AddressTypes
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES Themes
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (RegionID)
                             REFERENCES Regions
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
/


ALTER TABLE SignupServers
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
/


ALTER TABLE Statements
       ADD FOREIGN KEY (PrintBatchID)
                             REFERENCES Batches
/


ALTER TABLE Statements
       ADD FOREIGN KEY (BatchID)
                             REFERENCES Batches
/


ALTER TABLE Statements
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE States
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE Strings
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES Languages
/


ALTER TABLE Strings
       ADD FOREIGN KEY (ApplicationID)
                             REFERENCES Applications
/


ALTER TABLE SubAccountData
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES AccountDataTypes
/


ALTER TABLE SubAccountData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE SubAccountDataTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE SubAccountDataTypes
       ADD FOREIGN KEY (AccountDataTypeID)
                             REFERENCES AccountDataTypes
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (LastInvoiceID)
                             REFERENCES Invoices
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (PackageID)
                             REFERENCES Packages
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
/


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
/


ALTER TABLE SubAccountUsages
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/


ALTER TABLE SubAccountUsages
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/


ALTER TABLE Taxes
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES TaxTypes
/


ALTER TABLE Taxes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
/


ALTER TABLE Taxes
       ADD FOREIGN KEY (TaxPiggyBackID)
                             REFERENCES TaxPiggyBacks
/


ALTER TABLE TaxGroupTaxes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES Regions
/


ALTER TABLE TaxGroupTaxes
       ADD FOREIGN KEY (CountryID)
                             REFERENCES Countries
/


ALTER TABLE TaxGroupTaxes
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
/


ALTER TABLE TaxGroupTaxes
       ADD FOREIGN KEY (StateID)
                             REFERENCES States
/


ALTER TABLE ThemeFilters
       ADD FOREIGN KEY (ThemeMatchTypeID)
                             REFERENCES ThemeMatchTypes
/


ALTER TABLE ThemeFilters
       ADD FOREIGN KEY (ThemeID)
                             REFERENCES Themes
/


ALTER TABLE TimeCharges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
/


ALTER TABLE TimeCharges
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/


ALTER TABLE TimeCharges
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
/


CREATE SEQUENCE AccountTypes_seq
/
CREATE OR REPLACE TRIGGER AccountTypes_itrig
BEFORE INSERT ON AccountTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AccountTypeID IS NULL THEN
	SELECT AccountTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.AccountTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Actions_seq
/
CREATE OR REPLACE TRIGGER Actions_itrig
BEFORE INSERT ON Actions
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ActionID IS NULL THEN
	SELECT Actions_seq.nextval INTO seq_val FROM DUAL;
	:new.ActionID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE AddressTypes_seq
/
CREATE OR REPLACE TRIGGER AddressTypes_itrig
BEFORE INSERT ON AddressTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AddressTypeID IS NULL THEN
	SELECT AddressTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.AddressTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Addresses_seq
/
CREATE OR REPLACE TRIGGER Addresses_itrig
BEFORE INSERT ON Addresses
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AddressID IS NULL THEN
	SELECT Addresses_seq.nextval INTO seq_val FROM DUAL;
	:new.AddressID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Aliases_seq
/
CREATE OR REPLACE TRIGGER Aliases_itrig
BEFORE INSERT ON Aliases
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AliasID IS NULL THEN
	SELECT Aliases_seq.nextval INTO seq_val FROM DUAL;
	:new.AliasID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE AllowedHosts_seq
/
CREATE OR REPLACE TRIGGER AllowedHosts_itrig
BEFORE INSERT ON AllowedHosts
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AllowedHostID IS NULL THEN
	SELECT AllowedHosts_seq.nextval INTO seq_val FROM DUAL;
	:new.AllowedHostID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE AuditLogs_seq
/
CREATE OR REPLACE TRIGGER AuditLogs_itrig
BEFORE INSERT ON AuditLogs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AuditLogID IS NULL THEN
	SELECT AuditLogs_seq.nextval INTO seq_val FROM DUAL;
	:new.AuditLogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE BatchProcessors_seq
/
CREATE OR REPLACE TRIGGER BatchProcessors_itrig
BEFORE INSERT ON BatchProcessors
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.BatchProcessorID IS NULL THEN
	SELECT BatchProcessors_seq.nextval INTO seq_val FROM DUAL;
	:new.BatchProcessorID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Batches_seq
/
CREATE OR REPLACE TRIGGER Batches_itrig
BEFORE INSERT ON Batches
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.BatchID IS NULL THEN
	SELECT Batches_seq.nextval INTO seq_val FROM DUAL;
	:new.BatchID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE BillingCycles_seq
/
CREATE OR REPLACE TRIGGER BillingCycles_itrig
BEFORE INSERT ON BillingCycles
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.BillingCycleID IS NULL THEN
	SELECT BillingCycles_seq.nextval INTO seq_val FROM DUAL;
	:new.BillingCycleID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CCImportColumns_seq
/
CREATE OR REPLACE TRIGGER CCImportColumns_itrig
BEFORE INSERT ON CCImportColumns
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CCImportColumnID IS NULL THEN
	SELECT CCImportColumns_seq.nextval INTO seq_val FROM DUAL;
	:new.CCImportColumnID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Calls_seq
/
CREATE OR REPLACE TRIGGER Calls_itrig
BEFORE INSERT ON Calls
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CallID IS NULL THEN
	SELECT Calls_seq.nextval INTO seq_val FROM DUAL;
	:new.CallID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CancelReasons_seq
/
CREATE OR REPLACE TRIGGER CancelReasons_itrig
BEFORE INSERT ON CancelReasons
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CancelReasonID IS NULL THEN
	SELECT CancelReasons_seq.nextval INTO seq_val FROM DUAL;
	:new.CancelReasonID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CardAccounts_seq
/
CREATE OR REPLACE TRIGGER CardAccounts_itrig
BEFORE INSERT ON CardAccounts
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CardAccountID IS NULL THEN
	SELECT CardAccounts_seq.nextval INTO seq_val FROM DUAL;
	:new.CardAccountID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CardBatchTypes_seq
/
CREATE OR REPLACE TRIGGER CardBatchTypes_itrig
BEFORE INSERT ON CardBatchTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CardBatchTypeID IS NULL THEN
	SELECT CardBatchTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.CardBatchTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CardBatches_seq
/
CREATE OR REPLACE TRIGGER CardBatches_itrig
BEFORE INSERT ON CardBatches
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CardBatchID IS NULL THEN
	SELECT CardBatches_seq.nextval INTO seq_val FROM DUAL;
	:new.CardBatchID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CardDigits_seq
/
CREATE OR REPLACE TRIGGER CardDigits_itrig
BEFORE INSERT ON CardDigits
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CardDigitID IS NULL THEN
	SELECT CardDigits_seq.nextval INTO seq_val FROM DUAL;
	:new.CardDigitID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ChargeTypes_seq
/
CREATE OR REPLACE TRIGGER ChargeTypes_itrig
BEFORE INSERT ON ChargeTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ChargeTypeID IS NULL THEN
	SELECT ChargeTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.ChargeTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Charges_seq
/
CREATE OR REPLACE TRIGGER Charges_itrig
BEFORE INSERT ON Charges
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ChargeID IS NULL THEN
	SELECT Charges_seq.nextval INTO seq_val FROM DUAL;
	:new.ChargeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CommissionGroups_seq
/
CREATE OR REPLACE TRIGGER CommissionGroups_itrig
BEFORE INSERT ON CommissionGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CommissionGroupID IS NULL THEN
	SELECT CommissionGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.CommissionGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE CommissionItems_seq
/
CREATE OR REPLACE TRIGGER CommissionItems_itrig
BEFORE INSERT ON CommissionItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CommissionItemID IS NULL THEN
	SELECT CommissionItems_seq.nextval INTO seq_val FROM DUAL;
	:new.CommissionItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE DNISGroups_seq
/
CREATE OR REPLACE TRIGGER DNISGroups_itrig
BEFORE INSERT ON DNISGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.DNISGroupID IS NULL THEN
	SELECT DNISGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.DNISGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Discounts_seq
/
CREATE OR REPLACE TRIGGER Discounts_itrig
BEFORE INSERT ON Discounts
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.DiscountID IS NULL THEN
	SELECT Discounts_seq.nextval INTO seq_val FROM DUAL;
	:new.DiscountID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Documents_seq
/
CREATE OR REPLACE TRIGGER Documents_itrig
BEFORE INSERT ON Documents
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.DocumentID IS NULL THEN
	SELECT Documents_seq.nextval INTO seq_val FROM DUAL;
	:new.DocumentID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Domains_seq
/
CREATE OR REPLACE TRIGGER Domains_itrig
BEFORE INSERT ON Domains
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.DomainID IS NULL THEN
	SELECT Domains_seq.nextval INTO seq_val FROM DUAL;
	:new.DomainID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ExportColumns_seq
/
CREATE OR REPLACE TRIGGER ExportColumns_itrig
BEFORE INSERT ON ExportColumns
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ExportColumnID IS NULL THEN
	SELECT ExportColumns_seq.nextval INTO seq_val FROM DUAL;
	:new.ExportColumnID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ExternalConfigs_seq
/
CREATE OR REPLACE TRIGGER ExternalConfigs_itrig
BEFORE INSERT ON ExternalConfigs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ExternalConfigID IS NULL THEN
	SELECT ExternalConfigs_seq.nextval INTO seq_val FROM DUAL;
	:new.ExternalConfigID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ExternalSyncs_seq
/
CREATE OR REPLACE TRIGGER ExternalSyncs_itrig
BEFORE INSERT ON ExternalSyncs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ExternalSyncID IS NULL THEN
	SELECT ExternalSyncs_seq.nextval INTO seq_val FROM DUAL;
	:new.ExternalSyncID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ExternalSystems_seq
/
CREATE OR REPLACE TRIGGER ExternalSystems_itrig
BEFORE INSERT ON ExternalSystems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ExternalSystemID IS NULL THEN
	SELECT ExternalSystems_seq.nextval INTO seq_val FROM DUAL;
	:new.ExternalSystemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ExternalTrans_seq
/
CREATE OR REPLACE TRIGGER ExternalTrans_itrig
BEFORE INSERT ON ExternalTrans
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ExternalTransID IS NULL THEN
	SELECT ExternalTrans_seq.nextval INTO seq_val FROM DUAL;
	:new.ExternalTransID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE FilterTypes_seq
/
CREATE OR REPLACE TRIGGER FilterTypes_itrig
BEFORE INSERT ON FilterTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.FilterTypeID IS NULL THEN
	SELECT FilterTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.FilterTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE FlowFilterGroups_seq
/
CREATE OR REPLACE TRIGGER FlowFilterGroups_itrig
BEFORE INSERT ON FlowFilterGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.FlowFilterGroupID IS NULL THEN
	SELECT FlowFilterGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.FlowFilterGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE FlowFilters_seq
/
CREATE OR REPLACE TRIGGER FlowFilters_itrig
BEFORE INSERT ON FlowFilters
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.FlowFilterID IS NULL THEN
	SELECT FlowFilters_seq.nextval INTO seq_val FROM DUAL;
	:new.FlowFilterID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Forwards_seq
/
CREATE OR REPLACE TRIGGER Forwards_itrig
BEFORE INSERT ON Forwards
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ForwardID IS NULL THEN
	SELECT Forwards_seq.nextval INTO seq_val FROM DUAL;
	:new.ForwardID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE GLCodes_seq
/
CREATE OR REPLACE TRIGGER GLCodes_itrig
BEFORE INSERT ON GLCodes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.GLCodeID IS NULL THEN
	SELECT GLCodes_seq.nextval INTO seq_val FROM DUAL;
	:new.GLCodeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Groups_seq
/
CREATE OR REPLACE TRIGGER Groups_itrig
BEFORE INSERT ON Groups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.GroupID IS NULL THEN
	SELECT Groups_seq.nextval INTO seq_val FROM DUAL;
	:new.GroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE IncidentDataTypes_seq
/
CREATE OR REPLACE TRIGGER IncidentDataTypes_itrig
BEFORE INSERT ON IncidentDataTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.IncidentDataTypeID IS NULL THEN
	SELECT IncidentDataTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.IncidentDataTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE IncidentStateGroups_seq
/
CREATE OR REPLACE TRIGGER IncidentStateGroups_itrig
BEFORE INSERT ON IncidentStateGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.IncidentStateGroupID IS NULL THEN
	SELECT IncidentStateGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.IncidentStateGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE IncidentStates_seq
/
CREATE OR REPLACE TRIGGER IncidentStates_itrig
BEFORE INSERT ON IncidentStates
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.IncidentStateID IS NULL THEN
	SELECT IncidentStates_seq.nextval INTO seq_val FROM DUAL;
	:new.IncidentStateID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE IncidentTypes_seq
/
CREATE OR REPLACE TRIGGER IncidentTypes_itrig
BEFORE INSERT ON IncidentTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.IncidentTypeID IS NULL THEN
	SELECT IncidentTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.IncidentTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Incidents_seq
/
CREATE OR REPLACE TRIGGER Incidents_itrig
BEFORE INSERT ON Incidents
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.IncidentID IS NULL THEN
	SELECT Incidents_seq.nextval INTO seq_val FROM DUAL;
	:new.IncidentID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE InvoiceItems_seq
/
CREATE OR REPLACE TRIGGER InvoiceItems_itrig
BEFORE INSERT ON InvoiceItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ItemID IS NULL THEN
	SELECT InvoiceItems_seq.nextval INTO seq_val FROM DUAL;
	:new.ItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Invoices_seq
/
CREATE OR REPLACE TRIGGER Invoices_itrig
BEFORE INSERT ON Invoices
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.InvoiceID IS NULL THEN
	SELECT Invoices_seq.nextval INTO seq_val FROM DUAL;
	:new.InvoiceID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE LateFees_seq
/
CREATE OR REPLACE TRIGGER LateFees_itrig
BEFORE INSERT ON LateFees
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.LateFeeID IS NULL THEN
	SELECT LateFees_seq.nextval INTO seq_val FROM DUAL;
	:new.LateFeeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Logs_seq
/
CREATE OR REPLACE TRIGGER Logs_itrig
BEFORE INSERT ON Logs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.LogID IS NULL THEN
	SELECT Logs_seq.nextval INTO seq_val FROM DUAL;
	:new.LogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE MailLogs_seq
/
CREATE OR REPLACE TRIGGER MailLogs_itrig
BEFORE INSERT ON MailLogs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.MailLogID IS NULL THEN
	SELECT MailLogs_seq.nextval INTO seq_val FROM DUAL;
	:new.MailLogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE MasterAccountDataTypes_seq
/
CREATE OR REPLACE TRIGGER MasterAccountDataTypes_itrig
BEFORE INSERT ON MasterAccountDataTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.MasterAccountDataTypeID IS NULL THEN
	SELECT MasterAccountDataTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.MasterAccountDataTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE MasterAccounts_seq
/
CREATE OR REPLACE TRIGGER MasterAccounts_itrig
BEFORE INSERT ON MasterAccounts
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.CustomerID IS NULL THEN
	SELECT MasterAccounts_seq.nextval INTO seq_val FROM DUAL;
	:new.CustomerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE MetaColumns_seq
/
CREATE OR REPLACE TRIGGER MetaColumns_itrig
BEFORE INSERT ON MetaColumns
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.MetaColumnID IS NULL THEN
	SELECT MetaColumns_seq.nextval INTO seq_val FROM DUAL;
	:new.MetaColumnID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE MetaTables_seq
/
CREATE OR REPLACE TRIGGER MetaTables_itrig
BEFORE INSERT ON MetaTables
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.MetaTableID IS NULL THEN
	SELECT MetaTables_seq.nextval INTO seq_val FROM DUAL;
	:new.MetaTableID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE NoticeLogs_seq
/
CREATE OR REPLACE TRIGGER NoticeLogs_itrig
BEFORE INSERT ON NoticeLogs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.NoticeLogID IS NULL THEN
	SELECT NoticeLogs_seq.nextval INTO seq_val FROM DUAL;
	:new.NoticeLogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE NoticeTypes_seq
/
CREATE OR REPLACE TRIGGER NoticeTypes_itrig
BEFORE INSERT ON NoticeTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.NoticeTypeID IS NULL THEN
	SELECT NoticeTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.NoticeTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Notices_seq
/
CREATE OR REPLACE TRIGGER Notices_itrig
BEFORE INSERT ON Notices
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.NoticeID IS NULL THEN
	SELECT Notices_seq.nextval INTO seq_val FROM DUAL;
	:new.NoticeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Objects_seq
/
CREATE OR REPLACE TRIGGER Objects_itrig
BEFORE INSERT ON Objects
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ObjectID IS NULL THEN
	SELECT Objects_seq.nextval INTO seq_val FROM DUAL;
	:new.ObjectID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE OnlineSignups_seq
/
CREATE OR REPLACE TRIGGER OnlineSignups_itrig
BEFORE INSERT ON OnlineSignups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.OnlineSignupID IS NULL THEN
	SELECT OnlineSignups_seq.nextval INTO seq_val FROM DUAL;
	:new.OnlineSignupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE OperatorGroups_seq
/
CREATE OR REPLACE TRIGGER OperatorGroups_itrig
BEFORE INSERT ON OperatorGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.OperatorGroupID IS NULL THEN
	SELECT OperatorGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.OperatorGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE OperatorRoles_seq
/
CREATE OR REPLACE TRIGGER OperatorRoles_itrig
BEFORE INSERT ON OperatorRoles
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.OperatorRoleID IS NULL THEN
	SELECT OperatorRoles_seq.nextval INTO seq_val FROM DUAL;
	:new.OperatorRoleID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Operators_seq
/
CREATE OR REPLACE TRIGGER Operators_itrig
BEFORE INSERT ON Operators
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.OperatorID IS NULL THEN
	SELECT Operators_seq.nextval INTO seq_val FROM DUAL;
	:new.OperatorID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Organizations_seq
/
CREATE OR REPLACE TRIGGER Organizations_itrig
BEFORE INSERT ON Organizations
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.OrganizationID IS NULL THEN
	SELECT Organizations_seq.nextval INTO seq_val FROM DUAL;
	:new.OrganizationID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE PackageTypes_seq
/
CREATE OR REPLACE TRIGGER PackageTypes_itrig
BEFORE INSERT ON PackageTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PackageTypeID IS NULL THEN
	SELECT PackageTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.PackageTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Packages_seq
/
CREATE OR REPLACE TRIGGER Packages_itrig
BEFORE INSERT ON Packages
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PackageID IS NULL THEN
	SELECT Packages_seq.nextval INTO seq_val FROM DUAL;
	:new.PackageID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE PayPeriods_seq
/
CREATE OR REPLACE TRIGGER PayPeriods_itrig
BEFORE INSERT ON PayPeriods
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PayPeriodID IS NULL THEN
	SELECT PayPeriods_seq.nextval INTO seq_val FROM DUAL;
	:new.PayPeriodID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE PaymentItems_seq
/
CREATE OR REPLACE TRIGGER PaymentItems_itrig
BEFORE INSERT ON PaymentItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PaymentItemID IS NULL THEN
	SELECT PaymentItems_seq.nextval INTO seq_val FROM DUAL;
	:new.PaymentItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Payments_seq
/
CREATE OR REPLACE TRIGGER Payments_itrig
BEFORE INSERT ON Payments
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PaymentID IS NULL THEN
	SELECT Payments_seq.nextval INTO seq_val FROM DUAL;
	:new.PaymentID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE PosixAccountServers_seq
/
CREATE OR REPLACE TRIGGER PosixAccountServers_itrig
BEFORE INSERT ON PosixAccountServers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PosixAccountServerID IS NULL THEN
	SELECT PosixAccountServers_seq.nextval INTO seq_val FROM DUAL;
	:new.PosixAccountServerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE PosixAccountUsers_seq
/
CREATE OR REPLACE TRIGGER PosixAccountUsers_itrig
BEFORE INSERT ON PosixAccountUsers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.PosixAccountUserID IS NULL THEN
	SELECT PosixAccountUsers_seq.nextval INTO seq_val FROM DUAL;
	:new.PosixAccountUserID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadATConfigs_seq
/
CREATE OR REPLACE TRIGGER RadATConfigs_itrig
BEFORE INSERT ON RadATConfigs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadATConfigID IS NULL THEN
	SELECT RadATConfigs_seq.nextval INTO seq_val FROM DUAL;
	:new.RadATConfigID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadConcurrency_seq
/
CREATE OR REPLACE TRIGGER RadConcurrency_itrig
BEFORE INSERT ON RadConcurrency
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadConcurrencyID IS NULL THEN
	SELECT RadConcurrency_seq.nextval INTO seq_val FROM DUAL;
	:new.RadConcurrencyID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadConfigs_seq
/
CREATE OR REPLACE TRIGGER RadConfigs_itrig
BEFORE INSERT ON RadConfigs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadConfigID IS NULL THEN
	SELECT RadConfigs_seq.nextval INTO seq_val FROM DUAL;
	:new.RadConfigID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadFilterGroups_seq
/
CREATE OR REPLACE TRIGGER RadFilterGroups_itrig
BEFORE INSERT ON RadFilterGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadFilterGroupID IS NULL THEN
	SELECT RadFilterGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RadFilterGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadFilters_seq
/
CREATE OR REPLACE TRIGGER RadFilters_itrig
BEFORE INSERT ON RadFilters
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadFilterID IS NULL THEN
	SELECT RadFilters_seq.nextval INTO seq_val FROM DUAL;
	:new.RadFilterID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadIPAccountTypes_seq
/
CREATE OR REPLACE TRIGGER RadIPAccountTypes_itrig
BEFORE INSERT ON RadIPAccountTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadIPAccountTypeID IS NULL THEN
	SELECT RadIPAccountTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.RadIPAccountTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadIPGroups_seq
/
CREATE OR REPLACE TRIGGER RadIPGroups_itrig
BEFORE INSERT ON RadIPGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadIPGroupID IS NULL THEN
	SELECT RadIPGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RadIPGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadProxyAttributeGroups_seq
/
CREATE OR REPLACE TRIGGER RadProxyAttributeGroups_itrig
BEFORE INSERT ON RadProxyAttributeGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadProxyAttributeGroupID IS NULL THEN
	SELECT RadProxyAttributeGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RadProxyAttributeGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadProxyAttributes_seq
/
CREATE OR REPLACE TRIGGER RadProxyAttributes_itrig
BEFORE INSERT ON RadProxyAttributes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadProxyAttributeID IS NULL THEN
	SELECT RadProxyAttributes_seq.nextval INTO seq_val FROM DUAL;
	:new.RadProxyAttributeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadRejectAttributes_seq
/
CREATE OR REPLACE TRIGGER RadRejectAttributes_itrig
BEFORE INSERT ON RadRejectAttributes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadRejectAttributeID IS NULL THEN
	SELECT RadRejectAttributes_seq.nextval INTO seq_val FROM DUAL;
	:new.RadRejectAttributeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadRejects_seq
/
CREATE OR REPLACE TRIGGER RadRejects_itrig
BEFORE INSERT ON RadRejects
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadRejectID IS NULL THEN
	SELECT RadRejects_seq.nextval INTO seq_val FROM DUAL;
	:new.RadRejectID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadRoamDomains_seq
/
CREATE OR REPLACE TRIGGER RadRoamDomains_itrig
BEFORE INSERT ON RadRoamDomains
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadRoamDomainID IS NULL THEN
	SELECT RadRoamDomains_seq.nextval INTO seq_val FROM DUAL;
	:new.RadRoamDomainID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadRoamServers_seq
/
CREATE OR REPLACE TRIGGER RadRoamServers_itrig
BEFORE INSERT ON RadRoamServers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadRoamServerID IS NULL THEN
	SELECT RadRoamServers_seq.nextval INTO seq_val FROM DUAL;
	:new.RadRoamServerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RadTriggers_seq
/
CREATE OR REPLACE TRIGGER RadTriggers_itrig
BEFORE INSERT ON RadTriggers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadTriggerID IS NULL THEN
	SELECT RadTriggers_seq.nextval INTO seq_val FROM DUAL;
	:new.RadTriggerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateClasses_seq
/
CREATE OR REPLACE TRIGGER RateClasses_itrig
BEFORE INSERT ON RateClasses
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateClassID IS NULL THEN
	SELECT RateClasses_seq.nextval INTO seq_val FROM DUAL;
	:new.RateClassID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateItems_seq
/
CREATE OR REPLACE TRIGGER RateItems_itrig
BEFORE INSERT ON RateItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateItemID IS NULL THEN
	SELECT RateItems_seq.nextval INTO seq_val FROM DUAL;
	:new.RateItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateRules_seq
/
CREATE OR REPLACE TRIGGER RateRules_itrig
BEFORE INSERT ON RateRules
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateRuleID IS NULL THEN
	SELECT RateRules_seq.nextval INTO seq_val FROM DUAL;
	:new.RateRuleID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateStdGroups_seq
/
CREATE OR REPLACE TRIGGER RateStdGroups_itrig
BEFORE INSERT ON RateStdGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateStdGroupID IS NULL THEN
	SELECT RateStdGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RateStdGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateStdItems_seq
/
CREATE OR REPLACE TRIGGER RateStdItems_itrig
BEFORE INSERT ON RateStdItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateStdItemID IS NULL THEN
	SELECT RateStdItems_seq.nextval INTO seq_val FROM DUAL;
	:new.RateStdItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateTimeGroups_seq
/
CREATE OR REPLACE TRIGGER RateTimeGroups_itrig
BEFORE INSERT ON RateTimeGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateTimeGroupID IS NULL THEN
	SELECT RateTimeGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RateTimeGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateTimes_seq
/
CREATE OR REPLACE TRIGGER RateTimes_itrig
BEFORE INSERT ON RateTimes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateTimeID IS NULL THEN
	SELECT RateTimes_seq.nextval INTO seq_val FROM DUAL;
	:new.RateTimeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVCondGroups_seq
/
CREATE OR REPLACE TRIGGER RateVCondGroups_itrig
BEFORE INSERT ON RateVCondGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVCondGroupID IS NULL THEN
	SELECT RateVCondGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVCondGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVCondItems_seq
/
CREATE OR REPLACE TRIGGER RateVCondItems_itrig
BEFORE INSERT ON RateVCondItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVCondItemID IS NULL THEN
	SELECT RateVCondItems_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVCondItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVDNIS_seq
/
CREATE OR REPLACE TRIGGER RateVDNIS_itrig
BEFORE INSERT ON RateVDNIS
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVDNISID IS NULL THEN
	SELECT RateVDNIS_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVDNISID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVDNISGroups_seq
/
CREATE OR REPLACE TRIGGER RateVDNISGroups_itrig
BEFORE INSERT ON RateVDNISGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVDNISGroupID IS NULL THEN
	SELECT RateVDNISGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVDNISGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVDNISItems_seq
/
CREATE OR REPLACE TRIGGER RateVDNISItems_itrig
BEFORE INSERT ON RateVDNISItems
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVDNISItemID IS NULL THEN
	SELECT RateVDNISItems_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVDNISItemID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE RateVRates_seq
/
CREATE OR REPLACE TRIGGER RateVRates_itrig
BEFORE INSERT ON RateVRates
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateVRateID IS NULL THEN
	SELECT RateVRates_seq.nextval INTO seq_val FROM DUAL;
	:new.RateVRateID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Rates_seq
/
CREATE OR REPLACE TRIGGER Rates_itrig
BEFORE INSERT ON Rates
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RateID IS NULL THEN
	SELECT Rates_seq.nextval INTO seq_val FROM DUAL;
	:new.RateID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ReferredBys_seq
/
CREATE OR REPLACE TRIGGER ReferredBys_itrig
BEFORE INSERT ON ReferredBys
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ReferredByID IS NULL THEN
	SELECT ReferredBys_seq.nextval INTO seq_val FROM DUAL;
	:new.ReferredByID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Regions_seq
/
CREATE OR REPLACE TRIGGER Regions_itrig
BEFORE INSERT ON Regions
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RegionID IS NULL THEN
	SELECT Regions_seq.nextval INTO seq_val FROM DUAL;
	:new.RegionID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ReportGroups_seq
/
CREATE OR REPLACE TRIGGER ReportGroups_itrig
BEFORE INSERT ON ReportGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ReportGroupID IS NULL THEN
	SELECT ReportGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.ReportGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ReportSessions_seq
/
CREATE OR REPLACE TRIGGER ReportSessions_itrig
BEFORE INSERT ON ReportSessions
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ReportSessionID IS NULL THEN
	SELECT ReportSessions_seq.nextval INTO seq_val FROM DUAL;
	:new.ReportSessionID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Reports_seq
/
CREATE OR REPLACE TRIGGER Reports_itrig
BEFORE INSERT ON Reports
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ReportID IS NULL THEN
	SELECT Reports_seq.nextval INTO seq_val FROM DUAL;
	:new.ReportID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Roles_seq
/
CREATE OR REPLACE TRIGGER Roles_itrig
BEFORE INSERT ON Roles
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RoleID IS NULL THEN
	SELECT Roles_seq.nextval INTO seq_val FROM DUAL;
	:new.RoleID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SalesPersons_seq
/
CREATE OR REPLACE TRIGGER SalesPersons_itrig
BEFORE INSERT ON SalesPersons
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SalesPersonID IS NULL THEN
	SELECT SalesPersons_seq.nextval INTO seq_val FROM DUAL;
	:new.SalesPersonID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ScheduleLogs_seq
/
CREATE OR REPLACE TRIGGER ScheduleLogs_itrig
BEFORE INSERT ON ScheduleLogs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ScheduleLogID IS NULL THEN
	SELECT ScheduleLogs_seq.nextval INTO seq_val FROM DUAL;
	:new.ScheduleLogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ScheduleServers_seq
/
CREATE OR REPLACE TRIGGER ScheduleServers_itrig
BEFORE INSERT ON ScheduleServers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ScheduleServerID IS NULL THEN
	SELECT ScheduleServers_seq.nextval INTO seq_val FROM DUAL;
	:new.ScheduleServerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Schedules_seq
/
CREATE OR REPLACE TRIGGER Schedules_itrig
BEFORE INSERT ON Schedules
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ScheduleID IS NULL THEN
	SELECT Schedules_seq.nextval INTO seq_val FROM DUAL;
	:new.ScheduleID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SendMethods_seq
/
CREATE OR REPLACE TRIGGER SendMethods_itrig
BEFORE INSERT ON SendMethods
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SendMethodID IS NULL THEN
	SELECT SendMethods_seq.nextval INTO seq_val FROM DUAL;
	:new.SendMethodID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ServerAccess_seq
/
CREATE OR REPLACE TRIGGER ServerAccess_itrig
BEFORE INSERT ON ServerAccess
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ServerAccessID IS NULL THEN
	SELECT ServerAccess_seq.nextval INTO seq_val FROM DUAL;
	:new.ServerAccessID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ServerGroups_seq
/
CREATE OR REPLACE TRIGGER ServerGroups_itrig
BEFORE INSERT ON ServerGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ServerGroupID IS NULL THEN
	SELECT ServerGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.ServerGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Servers_seq
/
CREATE OR REPLACE TRIGGER Servers_itrig
BEFORE INSERT ON Servers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ServerID IS NULL THEN
	SELECT Servers_seq.nextval INTO seq_val FROM DUAL;
	:new.ServerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ServiceGroups_seq
/
CREATE OR REPLACE TRIGGER ServiceGroups_itrig
BEFORE INSERT ON ServiceGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ServiceGroupID IS NULL THEN
	SELECT ServiceGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.ServiceGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SignupPackageTypes_seq
/
CREATE OR REPLACE TRIGGER SignupPackageTypes_itrig
BEFORE INSERT ON SignupPackageTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SignupPackageTypeID IS NULL THEN
	SELECT SignupPackageTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.SignupPackageTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SignupServers_seq
/
CREATE OR REPLACE TRIGGER SignupServers_itrig
BEFORE INSERT ON SignupServers
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SignupServerID IS NULL THEN
	SELECT SignupServers_seq.nextval INTO seq_val FROM DUAL;
	:new.SignupServerID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Statements_seq
/
CREATE OR REPLACE TRIGGER Statements_itrig
BEFORE INSERT ON Statements
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.StatementID IS NULL THEN
	SELECT Statements_seq.nextval INTO seq_val FROM DUAL;
	:new.StatementID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE States_seq
/
CREATE OR REPLACE TRIGGER States_itrig
BEFORE INSERT ON States
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.StateID IS NULL THEN
	SELECT States_seq.nextval INTO seq_val FROM DUAL;
	:new.StateID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SubAccountDataTypes_seq
/
CREATE OR REPLACE TRIGGER SubAccountDataTypes_itrig
BEFORE INSERT ON SubAccountDataTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SubAccountDataTypeID IS NULL THEN
	SELECT SubAccountDataTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.SubAccountDataTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SubAccountUsages_seq
/
CREATE OR REPLACE TRIGGER SubAccountUsages_itrig
BEFORE INSERT ON SubAccountUsages
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SubAccountUsageID IS NULL THEN
	SELECT SubAccountUsages_seq.nextval INTO seq_val FROM DUAL;
	:new.SubAccountUsageID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SubAccounts_seq
/
CREATE OR REPLACE TRIGGER SubAccounts_itrig
BEFORE INSERT ON SubAccounts
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.AccountID IS NULL THEN
	SELECT SubAccounts_seq.nextval INTO seq_val FROM DUAL;
	:new.AccountID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SysLogFilters_seq
/
CREATE OR REPLACE TRIGGER SysLogFilters_itrig
BEFORE INSERT ON SysLogFilters
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SysLogFilterID IS NULL THEN
	SELECT SysLogFilters_seq.nextval INTO seq_val FROM DUAL;
	:new.SysLogFilterID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE SysLogs_seq
/
CREATE OR REPLACE TRIGGER SysLogs_itrig
BEFORE INSERT ON SysLogs
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SyslogID IS NULL THEN
	SELECT SysLogs_seq.nextval INTO seq_val FROM DUAL;
	:new.SyslogID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE TaxGroupTaxes_seq
/
CREATE OR REPLACE TRIGGER TaxGroupTaxes_itrig
BEFORE INSERT ON TaxGroupTaxes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxGroupTaxID IS NULL THEN
	SELECT TaxGroupTaxes_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxGroupTaxID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE TaxGroups_seq
/
CREATE OR REPLACE TRIGGER TaxGroups_itrig
BEFORE INSERT ON TaxGroups
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxGroupID IS NULL THEN
	SELECT TaxGroups_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxGroupID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE TaxPiggyBacks_seq
/
CREATE OR REPLACE TRIGGER TaxPiggyBacks_itrig
BEFORE INSERT ON TaxPiggyBacks
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxPiggyBackID IS NULL THEN
	SELECT TaxPiggyBacks_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxPiggyBackID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE TaxTypes_seq
/
CREATE OR REPLACE TRIGGER TaxTypes_itrig
BEFORE INSERT ON TaxTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxTypeID IS NULL THEN
	SELECT TaxTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Taxes_seq
/
CREATE OR REPLACE TRIGGER Taxes_itrig
BEFORE INSERT ON Taxes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxID IS NULL THEN
	SELECT Taxes_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE ThemeFilters_seq
/
CREATE OR REPLACE TRIGGER ThemeFilters_itrig
BEFORE INSERT ON ThemeFilters
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ThemeFilterID IS NULL THEN
	SELECT ThemeFilters_seq.nextval INTO seq_val FROM DUAL;
	:new.ThemeFilterID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE Themes_seq
/
CREATE OR REPLACE TRIGGER Themes_itrig
BEFORE INSERT ON Themes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.ThemeID IS NULL THEN
	SELECT Themes_seq.nextval INTO seq_val FROM DUAL;
	:new.ThemeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE TimeCharges_seq
/
CREATE OR REPLACE TRIGGER TimeCharges_itrig
BEFORE INSERT ON TimeCharges
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TimeChargeID IS NULL THEN
	SELECT TimeCharges_seq.nextval INTO seq_val FROM DUAL;
	:new.TimeChargeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE VoiceCalls_seq
/
CREATE OR REPLACE TRIGGER VoiceCalls_itrig
BEFORE INSERT ON VoiceCalls
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.VoiceCallID IS NULL THEN
	SELECT VoiceCalls_seq.nextval INTO seq_val FROM DUAL;
	:new.VoiceCallID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE SEQUENCE WebLinks_seq
/
CREATE OR REPLACE TRIGGER WebLinks_itrig
BEFORE INSERT ON WebLinks
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.WebLinkID IS NULL THEN
	SELECT WebLinks_seq.nextval INTO seq_val FROM DUAL;
	:new.WebLinkID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/
