IF object_id('GeneralFullNegSync') IS NOT NULL
	DROP PROCEDURE GeneralFullNegSync
GO

IF object_id('GeneralGetPartial') IS NOT NULL
	DROP PROCEDURE GeneralGetPartial
GO

CREATE PROCEDURE GeneralGetPartial @id VARCHAR(50) AS
EXEC LDAPSetLastModifyDate 'read', @id

SELECT
sa.AccountID,
COALESCE(sa.LastName,'N/A') AS sn,
COALESCE(sa.FirstName,'') + ' ' + COALESCE(sa.LastName,'') AS cn,
CASE WHEN sa.Email IS NOT NULL AND sa.Email <> '' THEN sa.Email ELSE sa.Login END AS uid,
sa.Password AS userPassword,
g.GroupName AS ou,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain ELSE sa.Email END AS mail,
sa.PhoneHome AS telephoneNumber,
ma.State AS st,
ma.Zip AS postalCode,
sa.AccountID AS uniqueIdentifier,
sa.LastModifyUser AS LastModifiedBy,
sa.LastModifyDate AS LastModifyDate,
ma.Address1 AS streetAddress,
ma.PhoneFax AS facsimileTelephoneNumber,
COALESCE(ma.Company,'N/A') AS o,
CASE 	WHEN sa.Active = 0 OR ma.Active = 0 THEN 'Inactive' 
	WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < getdate() THEN 'Canceled'
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'Over Credit Limit'
	WHEN DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'Expired'
	ELSE 'Active'
END AS organizationalStatus,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS otherMailbox

FROM MasterAccounts ma, SubAccounts sa, Groups g, Domains d, AccountTypes at1, Aliases al, LDAPServers ls, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND g.GroupID = ma.GroupID
	AND sa.DomainID = d.DomainID
	AND (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND ls.LDAPServer = @id
	AND sa.AccountID *= al.AccountID
	AND es.Name = @id
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
go

CREATE PROCEDURE GeneralFullNegSync @id VARCHAR(50) AS
SELECT sa.AccountID AS uniqueIdentifier
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, ExternalSystems es
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.Name = @id
go

GRANT EXECUTE ON GeneralFullNegSync TO Emerald
GRANT EXECUTE ON GeneralGetPartial TO Emerald
go
