IF object_id('CGPROPartialNegSync') IS NOT NULL
	DROP PROCEDURE CGPROPartialNegSync
go

IF object_id('CGPROGetPartial') IS NOT NULL
	DROP PROCEDURE CGPROGetPartial
go

CREATE PROCEDURE CGPROPartialNegSync @id VARCHAR(50) AS
SELECT CASE 
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> '' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, ExternalSystems es, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND (sa.Active = 0 OR ma.Active = 0)
	AND (sa.Login <> '' OR sa.Email LIKE '%_@_%')
	AND sa.Password <> ''
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.Name = @id
	AND sa.DomainID = d.DomainID
go

CREATE PROCEDURE CGPROGetPartial @id VARCHAR(50) AS
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
CASE
	WHEN sa.Email LIKE '%_@_%' THEN 'uid=' + SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) + ',cn=' + RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> '' THEN 'uid=' + sa.Login + ',cn=' + d.MailDomain
END AS pk,
CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> '' THEN sa.Login END AS uid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.LastName AS sn,
sa.AccountID,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) THEN '{crypt}abcdefghijklm'
WHEN ma.OverLimit > 0 THEN sa.Password
WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN '{crypt}abcdefghijklm'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN '{crypt}abcdefghijklm'
ELSE sa.Password 
END AS userpassword,
CASE WHEN al.Alias IS NULL THEN 
	CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain
	END ELSE NULL END AS mail,
es.MailHost AS hostserver,
'clear' AS passwordEncryption
FROM MasterAccounts ma, SubAccounts sa, Domains d, AccountTypes at1, Forwards fw, Aliases al, LDAPServers ls, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.DomainID = d.DomainID
	AND (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND ls.LDAPServer = @id
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.AccountID *= fw.AccountID
	AND sa.AccountID *= al.AccountID
	AND sa.Password <> ''
	AND (sa.Email LIKE '%_@_%' OR sa.Login <> '')
	AND es.Name = @id
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
GO

GRANT EXECUTE ON CGPROPartialNegSync TO Emerald
GRANT EXECUTE ON CGPROGetPartial TO Emerald
go
