IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'AccountTypes' AND sc.name = 'RadFailAccountTypeID') = 0)
	ALTER TABLE AccountTypes ADD RadFailAccountTypeID NUMERIC(10,0) NULL
GO

-- RadDestTypes
CREATE TABLE dbo.RadDestTypes2 (
       RadDestTypeID        int NOT NULL,
       RadDestType          varchar(64) NOT NULL
)
go
IF object_id('RadDestTypes') IS NOT NULL
	DROP TABLE RadDestTypes2
ELSE BEGIN
	EXEC sp_rename 'RadDestTypes2','RadDestTypes'
	ALTER TABLE RadDestTypes ADD PRIMARY KEY (RadDestTypeID)
END
go

-- RadFilterTypes
CREATE TABLE dbo.RadFilterTypes2 (
       RadFilterTypeID      int NOT NULL,
       RadFilterType        varchar(64) NOT NULL
)
go
if object_id('RadFilterTypes') IS NOT NULL
	DROP TABLE RadFilterTypes2
ELSE BEGIN
	EXEC sp_rename 'RadFilterTypes2','RadFilterTypes'
	ALTER TABLE RadFilterTypes ADD PRIMARY KEY (RadFilterTypeID)
END
go

-- RadMergeTypes
CREATE TABLE dbo.RadMergeTypes2 (
       RadMergeTypeID       int NOT NULL,
       RadMergeType         char(64) NOT NULL
)
go
if object_id('RadMergeTypes') IS NOT NULL
	DROP TABLE RadMergeTypes2
ELSE BEGIN
	EXEC sp_rename 'RadMergeTypes2','RadMergeTypes'
	ALTER TABLE RadMergeTypes ADD PRIMARY KEY (RadMergeTypeID)
END
go

-- RadSearchTypes
CREATE TABLE dbo.RadSearchTypes2 (
       RadSearchTypeID      int NOT NULL,
       RadSearchType        varchar(64) NOT NULL
)
go
if object_id('RadSearchTypes') IS NOT NULL
	DROP TABLE RadSearchTypes2
ELSE BEGIN
	EXEC sp_rename 'RadSearchTypes2','RadSearchTypes'
	ALTER TABLE RadSearchTypes ADD PRIMARY KEY (RadSearchTypeID)
END
go

-- RadSourceTypes
CREATE TABLE dbo.RadSourceTypes2 (
       RadSourceTypeID      int NOT NULL,
       RadSourceType        varchar(64) NOT NULL
)
go
if object_id('RadSourceTypes') IS NOT NULL
	DROP TABLE RadSourceTypes2
ELSE BEGIN
	EXEC sp_rename 'RadSourceTypes2','RadSourceTypes'
	ALTER TABLE RadSourceTypes ADD PRIMARY KEY (RadSourceTypeID)
END
go

-- RadFilterGroups
CREATE TABLE dbo.RadFilterGroups2 (
       RadFilterGroupID     NUMERIC(10,0) IDENTITY,
       RadFilterGroup       varchar(64) NOT NULL,
       RadSourceTypeID      int NOT NULL,
       Description          varchar(255) NULL,
       DestRadFilterGroupID int NULL,
       DestData             varchar(255) NULL,
       RadDestTypeID        int NOT NULL,
       SortOrder            smallint DEFAULT 1  NOT NULL
)
go
if object_id('RadFilterGroups') IS NOT NULL
	DROP TABLE RadFilterGroups2
ELSE BEGIN
	EXEC sp_rename 'RadFilterGroups2','RadFilterGroups'
	ALTER TABLE RadFilterGroups ADD PRIMARY KEY (RadFilterGroupID)
	ALTER TABLE RadFilterGroups ADD FOREIGN KEY (RadSourceTypeID) REFERENCES RadSourceTypes
	ALTER TABLE RadFilterGroups ADD FOREIGN KEY (RadDestTypeID) REFERENCES RadDestTypes
END
go

-- RadFilters
CREATE TABLE dbo.RadFilters2 (
       RadFilterID          NUMERIC(10,0) IDENTITY,
       RadMergeTypeID       int NULL,
       RadFilterTypeID      int NULL,
       RadVendorID          int NULL,
       RadSearchTypeID      int NOT NULL,
       RadAttributeID       int NULL,
       RadFilterGroupID     NUMERIC(10,0) NOT NULL,
       Data                 varchar(255) NULL
)
go
if object_id('RadFilters') IS NOT NULL
	DROP TABLE RadFilters2
ELSE BEGIN
	EXEC sp_rename 'RadFilters2','RadFilters'
	ALTER TABLE RadFilters ADD PRIMARY KEY (RadFilterID)
	ALTER TABLE RadFilters ADD FOREIGN KEY (RadMergeTypeID) REFERENCES RadMergeTypes
	ALTER TABLE RadFilters ADD FOREIGN KEY (RadFilterTypeID) REFERENCES RadFilterTypes
	ALTER TABLE RadFilters ADD FOREIGN KEY (RadSearchTypeID) REFERENCES RadSearchTypes
	ALTER TABLE RadFilters ADD FOREIGN KEY (RadFilterGroupID) REFERENCES RadFilterGroups
END
go

IF object_id('TimeCharges2') IS NOT NULL
	DROP TABLE TimeCharges2
GO

CREATE TABLE dbo.TimeCharges2 (
	TimeChargeID NUMERIC(10,0) IDENTITY,
	TimeCharge varchar(128) NULL,
	Description varchar(255) NULL,
	ChargeTypeID NUMERIC(10,0) NOT NULL,
	AccountTypeID NUMERIC(10,0),
	Minutes int,
	CustomerAccess smallint DEFAULT (0) NOT NULL
)
GO

IF object_id('TimeCharges') IS NOT NULL
	DROP TABLE TimeCharges2
ELSE BEGIN
	EXEC sp_rename 'TimeCharges2','TimeCharges'
	ALTER TABLE TimeCharges	ADD PRIMARY KEY (TimeChargeID)
	ALTER TABLE TimeCharges ADD FOREIGN KEY (ChargeTypeID) REFERENCES ChargeTypes
	ALTER TABLE TimeCharges ADD FOREIGN KEY (AccountTypeID) REFERENCES AccountTypes
	CREATE UNIQUE INDEX XAK1TimeCharges ON TimeCharges (ChargeTypeID,AccountTypeID)
END
GO

IF object_id('UpdatePaidAmount') IS NOT NULL
	DROP PROCEDURE UpdatePaidAmount
GO

CREATE PROCEDURE UpdatePaidAmount @CustomerID INT, @ItemID INT, @PaidAmount NUMERIC(18,4) AS
SET NOCOUNT ON
IF @CustomerID IS NOT NULL
BEGIN
UPDATE SubAccounts SET TimeLeft = TimeLeft + (SELECT SUM(tc2.Minutes * ii2.Quantity)
	FROM Invoices i2, InvoiceItems ii2, TimeCharges tc2
		WHERE i2.CustomerID = @CustomerID
		AND sa.AccountID = ii2.AccountID
		AND i2.InvoiceTypeID <> 0
		AND i2.InvoiceID = ii2.InvoiceID
		AND sa.AccountTypeID = tc2.AccountTypeID
		AND ii2.ChargeTypeID = tc2.ChargeTypeID
		AND ii2.PaidAmount < (ii2.Amount * ii2.Quantity)
		AND (ii2.Amount * ii2.Quantity) > 0)
FROM SubAccounts sa, Invoices i, InvoiceItems ii, TimeCharges tc
	WHERE sa.CustomerID = @CustomerID
	AND i.CustomerID = @CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.InvoiceTypeID <> 0
	AND sa.Active = 1
	AND sa.TimeLeft IS NOT NULL
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.ChargeTypeID = tc.ChargeTypeID
	AND ii.PaidAmount < (ii.Amount * ii.Quantity)
	AND (ii.Amount * ii.Quantity) > 0

UPDATE InvoiceItems SET PaidAmount = (ii.Amount*ii.Quantity) 
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID 
	AND ii.PaidAmount < (ii.Amount*ii.Quantity)
	AND i.CustomerID = @CustomerID

END ELSE BEGIN
UPDATE SubAccounts SET TimeLeft = TimeLeft + (tc.Minutes * ii.Quantity)
FROM SubAccounts sa, Invoices i, InvoiceItems ii, TimeCharges tc
	WHERE ii.ItemID = @ItemID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.InvoiceTypeID <> 0
	AND sa.Active = 1
	AND sa.TimeLeft IS NOT NULL
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.ChargeTypeID = tc.ChargeTypeID
	AND ii.PaidAmount < (ii.Amount * ii.Quantity)
	AND ii.PaidAmount + @PaidAmount >= (ii.Amount * ii.Quantity)

UPDATE InvoiceItems SET PaidAmount = @PaidAmount WHERE ItemID = @ItemID
END
GO

IF object_id('Logs2') IS NOT NULL
	DROP TABLE Logs2
GO

CREATE TABLE Logs2 (
       LogMsgID             int NOT NULL,
       LogDate              smalldatetime DEFAULT getdate()  NOT NULL,
       LogMsg               varchar(255) NOT NULL,
       Operator             varchar(32) NULL,
       CustomerID           NUMERIC(10,0) NULL,
       AccountID            NUMERIC(10,0) NULL
)
GO

IF (SELECT length FROM syscolumns where id = object_id('Logs') AND name = 'LogMsg') <> 255
BEGIN
INSERT INTO Logs2 (LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID)
SELECT LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID FROM Logs

CREATE INDEX i_Logs_LogDate ON Logs2 (LogDate)
ALTER TABLE Logs2 ADD FOREIGN KEY (LogMsgID) REFERENCES LogMsgs

GRANT SELECT, INSERT, DELETE, UPDATE ON Logs2 TO Emerald
DROP TABLE Logs
EXEC sp_rename 'Logs2','Logs'
END
GO

IF object_id('Logs2') IS NOT NULL
	DROP TABLE Logs2
GO

IF object_id('RadConcurrency') IS NOT NULL
	EXEC sp_rename 'RadConcurrency','RadConcurrency2'
GO

CREATE TABLE RadConcurrency (
	RadConcurrencyID NUMERIC(10,0) IDENTITY,
	GroupID NUMERIC(10,0) NOT NULL,
	AccountTypeID NUMERIC(10,0) NULL,
	LastSyncDate datetime DEFAULT (getdate()) NOT NULL,
	ConnectionsMax int DEFAULT (0) NOT NULL,
	Connections int DEFAULT(0) NOT NULL,
	Description varchar (100) NULL
)
GO

IF object_id('RadConcurrency') IS NOT NULL AND object_id('RadConcurrency2') IS NOT NULL
	BEGIN
	DROP TABLE RadConcurrency
	EXEC sp_rename 'RadConcurrency2','RadConcurrency'
	END
GO

IF (SELECT COUNT(*) FROM sysindexes WHERE name = 'i_RadC_GroupAccountID') = 0
	CREATE UNIQUE CLUSTERED INDEX i_RadC_GroupAccountID ON RadConcurrency(GroupID, AccountTypeID)
GO

DECLARE @cols INT
EXEC pkcols 'RadConcurrency', @cols OUTPUT
IF (@cols = 0)
	ALTER TABLE RadConcurrency ADD PRIMARY KEY (RadConcurrencyID)

IF object_id('FK_RadC_GroupID') IS NULL
	ALTER TABLE RadConcurrency ADD 
	CONSTRAINT FK_RadC_GroupID FOREIGN KEY (AccountTypeID) REFERENCES AccountTypes (AccountTypeID),
	CONSTRAINT FK_RadC_Groups FOREIGN KEY (GroupID) REFERENCES Groups (GroupID)
GO

IF object_id('SPIDQuery') IS NOT NULL
	DROP PROCEDURE SPIDQuery
GO
CREATE PROCEDURE SPIDQuery @spid INT AS
SELECT 'No Event' AS EventType, 0 AS Parameters, 'N/A' AS EventInfo
GO
GRANT EXECUTE ON SPIDQuery TO Emerald
GO

IF object_id('calls_insert') IS NOT NULL
	DROP TRIGGER calls_insert
GO

CREATE TRIGGER calls_insert ON Calls 
FOR INSERT
AS
DECLARE @rows INT
UPDATE RadIPAddresses SET State = CASE WHEN i.AcctStatusType IN (1,3) THEN 2 WHEN i.AcctStatusType = 2 THEN 0 ELSE State END
FROM RadIPAddresses ri, inserted i
	WHERE ri.NASPort = i.NASPort
	AND ri.NASIdentifier = i.NASIdentifier

UPDATE RadConcurrency SET Connections = Connections + CASE WHEN i.AcctStatusType IN (1,3) THEN 1 WHEN i.AcctStatusType = 2 THEN -1 ELSE 0 END
FROM MasterAccounts ma, SubAccounts sa, RadConcurrency rc, inserted i
	WHERE i.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR rc.AccountTypeID = sa.AccountTypeID)

SELECT @rows = 0
SELECT @rows = @rows + 1 
FROM inserted
GROUP BY NASIdentifier, NASPort, ServerID

UPDATE ServerPorts
        Set Username = i.Username, 
		AccountID = i.AccountID,
                AcctStatusType = CASE WHEN (i.CallDate = sp.CallDate AND i.AcctSessionID = sp.AcctSessionID AND i.AcctStatusType = 1 AND sp.AcctStatusType = 2) THEN 2 WHEN i.AcctStatusType in (1,3) THEN 1 ELSE i.AcctStatusType END,
		CallDate = i.CallDate,
		FramedAddress = i.FramedAddress,
		CallerID = i.CallerID,
		ConnectInfo = i.ConnectInfo,
		AcctSessionID = i.AcctSessionID
        FROM ServerPorts sp, inserted i
        WHERE sp.NASIdentifier = i.NASIdentifier
	AND sp.Port = i.NASPort
	AND (i.CallDate >= sp.CallDate OR sp.CallDate IS NULL)

IF (@@rowcount <> @rows)
	BEGIN
	/* SNMPUser should add the port for all except 10 (ascend) */

	INSERT INTO ServerPorts (ServerID,Port,NASIdentifier,IPAddress,MaxSessionTime,CostPerMinute,Username,AccountID,AcctSessionID,
	AcctStatusType,CallDate,FramedAddress,CallerID,ConnectInfo,SNMPUser)

	SELECT i.ServerID,i.NASPort,i.NASIdentifier,NULL,0,0,MIN(i.Username),MIN(i.AccountID),MIN(i.AcctSessionID),CASE WHEN MAX(i.AcctStatusType) in (1,3) THEN 1 ELSE MAX(i.AcctStatusType) END,
	MAX(i.CallDate),MIN(i.FramedAddress),MIN(i.CallerID),MIN(i.ConnectInfo),
	Case when MIN(st.SNMPType)=1 then MIN(st.SNMPUser) else MIN(st.SNMPUser) + convert(varchar(9), i.NASPort) END
	FROM inserted i, Servers s, ServerTypes st
		WHERE s.ServerType = st.ServerType
		AND s.ServerID = COALESCE(i.ServerID,(SELECT MAX(s.ServerID) FROM Servers s, inserted ii WHERE s.IPAddress = ii.NASIdentifier))
		AND NOT EXISTS (SELECT * FROM ServerPorts sp, inserted ii WHERE sp.NASIdentifier = ii.NASIdentifier AND sp.Port = ii.NASPort)
	GROUP BY i.NASIdentifier, i.NASPort, i.ServerID
	END

/* Stuff we only do on stop records */
UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NULL
        AND sa.Login = i.Username
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2

UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NOT NULL
        AND sa.AccountID = i.AccountID
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2
GO


/* Change the datatype for the TotalData column in the RateHistory table from int to numeric(17). BJP - 2/10/03 */

IF object_id('RateHistory2') IS NOT NULL
	DROP TABLE RateHistory2
GO

CREATE TABLE RateHistory2 (
       AccountID            NUMERIC(10,0) NOT NULL,
       StartDate            datetime NOT NULL,
       HistoryType          smallint NOT NULL,
       RateID               NUMERIC(10,0) NULL,
       TotalCount           int NOT NULL,
       TotalTime            int NOT NULL,
       TotalData            NUMERIC(17) NOT NULL,
       ChargeID             NUMERIC(10,0) NULL,
       TotalRate	    NUMERIC(18,4) DEFAULT 0 NULL
)
GO

IF (SELECT COUNT(*) FROM syscolumns sc, systypes st where id = object_id('RateHistory') AND sc.name = 'TotalData' 
    AND st.type = sc.type AND st.name = 'numeric' AND sc.length = 17) = 0
	BEGIN
	INSERT INTO RateHistory2 (AccountID,StartDate,HistoryType,RateID,TotalCount,TotalTime,TotalData,ChargeID,TotalRate)
	SELECT AccountID,StartDate,HistoryType,RateID,TotalCount,TotalTime,TotalData,ChargeID,TotalRate FROM RateHistory
	
	ALTER TABLE RateHistory2
	       ADD PRIMARY KEY (AccountID, StartDate, HistoryType)
		
	ALTER TABLE RateHistory2
	       ADD FOREIGN KEY (ChargeID)
	                             REFERENCES Charges
		
	ALTER TABLE RateHistory2
	       ADD FOREIGN KEY (AccountID)
	                             REFERENCES SubAccounts
		
	GRANT SELECT, INSERT, DELETE, UPDATE ON RateHistory2 TO Emerald
	DROP TABLE RateHistory
	EXEC sp_rename 'RateHistory2','RateHistory'
	END
GO

IF object_id('RateHistory2') IS NOT NULL
	DROP TABLE RateHistory2
GO


-- Make the RadConfigs.Data and RadATConfigs.Data columns up to 255 characters long
-- from the original 100 long.
-- BJP - 2/10/03

IF object_id('RadConfigs2') IS NOT NULL
	DROP TABLE RadConfigs2
GO

CREATE TABLE RadConfigs2 (
       RadConfigID          NUMERIC(10,0) IDENTITY,
       AccountID            NUMERIC(10,0) NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Value                int NULL,
       RadCheck             smallint DEFAULT (0)  NOT NULL,
       Tag                  smallint NULL
)
GO

IF (SELECT length FROM syscolumns where id = object_id('RadConfigs') AND name = 'Data') < 255
	BEGIN
	SET IDENTITY_INSERT RadConfigs2 ON
	
	INSERT INTO RadConfigs2 (RadConfigID,AccountID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck,Tag)
	SELECT RadConfigID,AccountID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck,Tag FROM RadConfigs
	
	SET IDENTITY_INSERT RadConfigs2 OFF

	CREATE INDEX i_RadConfigs_AccountID ON RadConfigs2
	(
	       AccountID
	)
		
	ALTER TABLE RadConfigs2
	       ADD PRIMARY KEY (RadConfigID)
				
	ALTER TABLE RadConfigs2
	       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
	                             REFERENCES RadAttributes
	
	ALTER TABLE RadConfigs2
	       ADD FOREIGN KEY (AccountID)
	                             REFERENCES SubAccounts
				
	GRANT SELECT, INSERT, DELETE, UPDATE ON RadConfigs2 TO Emerald
	DROP TABLE RadConfigs
	EXEC sp_rename 'RadConfigs2','RadConfigs'
	END
GO

-- Update the MetaColumns also.
IF (SELECT mc.MaxSize FROM MetaColumns mc, MetaTables mt WHERE mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = 'RadConfigs' AND mc.ColumnName = 'Data') < 255
	BEGIN
	UPDATE MetaColumns SET MaxSize = 255 FROM MetaColumns mc, MetaTables mt
		WHERE mc.MetaTableID = mt.MetaTableID
			AND mt.TableName = 'RadConfigs'
			AND mc.ColumnName = 'Data'
	END
GO

IF object_id('RadConfigs2') IS NOT NULL
	DROP TABLE RadConfigs2
GO


IF object_id('RadATConfigs2') IS NOT NULL
	DROP TABLE RadATConfigs2
GO

CREATE TABLE RadATConfigs2 (
       RadATConfigID        NUMERIC(10,0) IDENTITY,
       AccountTypeID        NUMERIC(10,0) NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Data                 varchar(255) NOT NULL,
       Value                int NULL,
       RadCheck             smallint DEFAULT (0)  NOT NULL,
       Tag                  smallint NULL
)
GO

IF (SELECT length FROM syscolumns where id = object_id('RadATConfigs') AND name = 'Data') < 255
	BEGIN
	SET IDENTITY_INSERT RadATConfigs2 ON
	
	INSERT INTO RadATConfigs2 (RadATConfigID,AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck,Tag)
	SELECT RadATConfigID,AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck,Tag FROM RadATConfigs
	
	SET IDENTITY_INSERT RadATConfigs2 OFF
		
	ALTER TABLE RadATConfigs2
       ADD PRIMARY KEY (RadATConfigID)
				
	ALTER TABLE RadATConfigs2
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
	
	ALTER TABLE RadATConfigs2
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
				
	GRANT SELECT, INSERT, DELETE, UPDATE ON RadATConfigs2 TO Emerald
	DROP TABLE RadATConfigs
	EXEC sp_rename 'RadATConfigs2','RadATConfigs'
	END
GO

IF (SELECT mc.MaxSize FROM MetaColumns mc, MetaTables mt WHERE mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = 'RadATConfigs' AND mc.ColumnName = 'Data') < 255
	BEGIN
	UPDATE MetaColumns SET MaxSize = 255 FROM MetaColumns mc, MetaTables mt
		WHERE mc.MetaTableID = mt.MetaTableID
			AND mt.TableName = 'RadATConfigs'
			AND mc.ColumnName = 'Data'
	END
GO

IF object_id('RadATConfigs2') IS NOT NULL
	DROP TABLE RadATConfigs2
GO

