IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'AccountTypes' AND sc.name = 'RadFailAccountTypeID') = 0)
	ALTER TABLE AccountTypes ADD RadFailAccountTypeID int NULL
GO

-- RadDestTypes
IF object_id('RadDestTypes') IS NULL
BEGIN
CREATE TABLE RadDestTypes (
       RadDestTypeID        int NOT NULL,
       RadDestType          varchar(64) NOT NULL
)
ALTER TABLE RadDestTypes
       ADD PRIMARY KEY (RadDestTypeID)
END
GO

-- RadFilterTypes
IF object_id('RadFilterTypes') IS NULL
BEGIN
CREATE TABLE RadFilterTypes (
       RadFilterTypeID      int NOT NULL,
       RadFilterType        varchar(64) NOT NULL
)
ALTER TABLE RadFilterTypes
       ADD PRIMARY KEY (RadFilterTypeID)
END
GO

-- RadMergeTypes
IF object_id('RadMergeTypes') IS NULL
BEGIN
CREATE TABLE RadMergeTypes (
       RadMergeTypeID       int NOT NULL,
       RadMergeType         char(64) NOT NULL
)
ALTER TABLE RadMergeTypes
       ADD PRIMARY KEY (RadMergeTypeID)
END
GO

-- RadSearchTypes
IF object_id('RadSearchTypes') IS NULL
BEGIN
CREATE TABLE RadSearchTypes (
       RadSearchTypeID      int NOT NULL,
       RadSearchType        varchar(64) NOT NULL
)
ALTER TABLE RadSearchTypes
       ADD PRIMARY KEY (RadSearchTypeID)
END
GO

-- RadSourceTypes
IF object_id('RadSourceTypes') IS NULL
BEGIN
CREATE TABLE RadSourceTypes (
       RadSourceTypeID      int NOT NULL,
       RadSourceType        varchar(64) NOT NULL
)
ALTER TABLE RadSourceTypes
       ADD PRIMARY KEY (RadSourceTypeID)
END
GO

-- RadFilterGroups
IF object_id('RadFilterGroups') IS NULL
BEGIN
CREATE TABLE RadFilterGroups (
       RadFilterGroupID     int IDENTITY,
       RadFilterGroup       varchar(64) NOT NULL,
       RadSourceTypeID      int NOT NULL,
       Description          varchar(255) NULL,
       DestRadFilterGroupID int NULL,
       DestData             varchar(255) NULL,
       RadDestTypeID        int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT 1
)
ALTER TABLE RadFilterGroups
       ADD PRIMARY KEY (RadFilterGroupID)
ALTER TABLE RadFilterGroups
       ADD FOREIGN KEY (RadSourceTypeID)
                             REFERENCES RadSourceTypes
ALTER TABLE RadFilterGroups
       ADD FOREIGN KEY (RadDestTypeID)
                             REFERENCES RadDestTypes
END
GO

-- RadFilters
IF object_id('RadFilters') IS NULL
BEGIN
CREATE TABLE RadFilters (
       RadFilterID          int IDENTITY,
       RadMergeTypeID       int NULL,
       RadFilterTypeID      int NULL,
       RadVendorID          int NULL,
       RadSearchTypeID      int NOT NULL,
       RadAttributeID       int NULL,
       RadFilterGroupID     int NOT NULL,
       Data                 varchar(255) NULL
)
ALTER TABLE RadFilters
       ADD PRIMARY KEY (RadFilterID)

ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadMergeTypeID)
                             REFERENCES RadMergeTypes
ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadFilterTypeID)
                             REFERENCES RadFilterTypes
ALTER TABLE RadFilters
       ADD FOREIGN KEY (RadSearchTypeID)
                             REFERENCES RadSearchTypes
END
GO


IF object_id('RadConcurrency') IS NULL
BEGIN
CREATE TABLE dbo.RadConcurrency (
	RadConcurrencyID int IDENTITY (1, 1) NOT NULL,
	GroupID int NOT NULL,
	AccountTypeID int NULL,
	LastSyncDate datetime NOT NULL DEFAULT(getdate()),
	ConnectionsMax int NOT NULL DEFAULT(0),
	Connections int NOT NULL DEFAULT(0),
	Description varchar (100) NULL
)

CREATE UNIQUE CLUSTERED INDEX i_RadConcurrency_GroupAccountID ON RadConcurrency(GroupID, AccountTypeID)

ALTER TABLE RadConcurrency ADD PRIMARY KEY (RadConcurrencyID)

ALTER TABLE RadConcurrency ADD 
	CONSTRAINT FK_RadConcurrency_GroupID FOREIGN KEY (AccountTypeID) REFERENCES AccountTypes (AccountTypeID),
	CONSTRAINT FK_RadConcurrency_Groups FOREIGN KEY (GroupID) REFERENCES Groups (GroupID)
END
GO

IF object_id('TimeCharges') IS NULL
BEGIN
CREATE TABLE TimeCharges (
	TimeChargeID int IDENTITY,
	TimeCharge varchar(128) NULL,
	Description varchar(255) NULL,
	ChargeTypeID int NOT NULL,
	AccountTypeID int,
	Minutes int,
	CustomerAccess smallint NOT NULL DEFAULT 0
)
ALTER TABLE TimeCharges	ADD PRIMARY KEY (TimeChargeID)
ALTER TABLE TimeCharges ADD FOREIGN KEY (ChargeTypeID) REFERENCES ChargeTypes
ALTER TABLE TimeCharges ADD FOREIGN KEY (AccountTypeID) REFERENCES AccountTypes
CREATE UNIQUE INDEX XAK1TimeCharges ON TimeCharges (ChargeTypeID,AccountTypeID)
END
GO

IF object_id('UpdatePaidAmount') IS NOT NULL
	DROP PROCEDURE UpdatePaidAmount
GO

CREATE PROCEDURE UpdatePaidAmount @CustomerID INT, @ItemID INT, @PaidAmount NUMERIC(18,4) AS
SET NOCOUNT ON
IF @CustomerID IS NOT NULL
BEGIN
SELECT sa.AccountID, SUM((tc.Minutes * ii.Quantity)) AS Minutes INTO #paytmp
FROM SubAccounts sa, Invoices i, InvoiceItems ii, TimeCharges tc
	WHERE sa.CustomerID = @CustomerID
	AND i.CustomerID = @CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.InvoiceTypeID <> 0
	AND sa.Active = 1
	AND sa.TimeLeft IS NOT NULL
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.ChargeTypeID = tc.ChargeTypeID
	AND ii.PaidAmount < (ii.Amount * ii.Quantity)
	AND (ii.Amount * ii.Quantity) > 0
GROUP BY sa.AccountID

IF EXISTS (SELECT * FROM #paytmp)
	UPDATE SubAccounts SET TimeLeft = TimeLeft + pt.Minutes
	FROM SubAccounts sa, #paytmp pt
		WHERE sa.AccountID = pt.AccountID

UPDATE InvoiceItems SET PaidAmount = (ii.Amount*ii.Quantity) 
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID 
	AND ii.PaidAmount < (ii.Amount*ii.Quantity)
	AND i.CustomerID = @CustomerID

DROP TABLE #paytmp
END ELSE BEGIN
UPDATE SubAccounts SET TimeLeft = TimeLeft + (tc.Minutes * ii.Quantity)
FROM SubAccounts sa, Invoices i, InvoiceItems ii, TimeCharges tc
	WHERE ii.ItemID = @ItemID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.InvoiceTypeID <> 0
	AND sa.Active = 1
	AND sa.TimeLeft IS NOT NULL
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.ChargeTypeID = tc.ChargeTypeID
	AND ii.PaidAmount < (ii.Amount * ii.Quantity)
	AND ii.PaidAmount + @PaidAmount >= (ii.Amount * ii.Quantity)

UPDATE InvoiceItems SET PaidAmount = @PaidAmount WHERE ItemID = @ItemID
END
GO

DECLARE @cols INT
EXEC pkcols 'FileTransfers', @cols OUTPUT
IF (@cols = 0)
BEGIN
	ALTER TABLE FileTransfers ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
	ALTER TABLE FileTransfers ADD PRIMARY KEY (ROWGUID)
END

IF (Select type From sysobjects where name = 'Flows') = 'U'
BEGIN
	EXEC pkcols 'Flows', @cols OUTPUT
	IF (@cols = 0)
	BEGIN
		ALTER TABLE Flows ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
		ALTER TABLE Flows ADD PRIMARY KEY (ROWGUID)
	END
END

EXEC pkcols 'MailLogs', @cols OUTPUT
IF (@cols = 0)
BEGIN
	ALTER TABLE MailLogs ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
	ALTER TABLE MailLogs ADD PRIMARY KEY (ROWGUID)
END

EXEC pkcols 'ScheduleLogs', @cols OUTPUT
IF (@cols = 0)
BEGIN
	ALTER TABLE ScheduleLogs ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
	ALTER TABLE ScheduleLogs ADD PRIMARY KEY (ROWGUID)
END

EXEC pkcols 'ServerAccess', @cols OUTPUT
IF (@cols = 0)
BEGIN
	ALTER TABLE ServerAccess ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
	ALTER TABLE ServerAccess ADD PRIMARY KEY (ROWGUID)
END

EXEC pkcols 'SysLogs', @cols OUTPUT
IF (@cols = 0)
BEGIN
	ALTER TABLE SysLogs ADD ROWGUID UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID()
	ALTER TABLE SysLogs ADD PRIMARY KEY (ROWGUID)
END
GO

-- If SQL Server 2000, change the "TotalData" column to bigint.
-- If SQL Server 7, change the "TotalData" column to numeric(17) since bigint
-- is not support in SQL Server 7.
-- BJP - 1/28/03

if TYPEPROPERTY( 'BIGINT', 'PRECISION') IS NOT NULL
	BEGIN
	if (Select st.name From sysobjects so, syscolumns sc, systypes st
	Where so.id = sc.id and sc.xtype = st.xtype
		and so.name = 'RateHistory' and sc.name = 'TotalData') <> 'bigint'
		BEGIN
		Exec('Alter Table RateHistory Alter Column TotalData bigint NOT NULL')
		END
	END
else
	BEGIN
	if exists (Select * From sysobjects so, syscolumns sc, systypes st
	Where so.id = sc.id and sc.xtype = st.xtype
		and so.name = 'RateHistory' and sc.name = 'TotalData' and st.name <> 'numeric' and st.length <> 17)
		BEGIN
		Alter Table RateHistory Alter Column TotalData numeric(17) NOT NULL
		END
	END
GO


-- Make the RadConfigs.Data and RadATConfigs.Data columns up to 255 characters long 
-- from the original 100 long.
-- BJP - 2/10/03

IF (SELECT COLUMNPROPERTY( OBJECT_ID('RadConfigs'),'Data','PRECISION')) < 255
	BEGIN
	ALTER TABLE RadConfigs ALTER COLUMN Data varchar (255) NOT NULL

	UPDATE MetaColumns SET MaxSize = 255
	FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID
		AND mt.TableName = 'RadConfigs'
		AND mc.ColumnName = 'Data'

	END
GO

IF (SELECT COLUMNPROPERTY( OBJECT_ID('RadATConfigs'),'Data','PRECISION')) < 255
	BEGIN
	ALTER TABLE RadATConfigs ALTER COLUMN Data varchar (255) NOT NULL

	UPDATE MetaColumns SET MaxSize = 255
	FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID
		AND mt.TableName = 'RadATConfigs'
		AND mc.ColumnName = 'Data'

	END
GO

IF object_id('SPIDQuery') IS NOT NULL
	DROP PROCEDURE SPIDQuery
GO
CREATE PROCEDURE dbo.SPIDQuery @spid INT AS
DBCC INPUTBUFFER(@spid)
GO
GRANT EXECUTE ON SPIDQuery TO Emerald
GO

DECLARE @switchto VARCHAR(32), @current VARCHAR(32)
SELECT @current = DB_NAME()
IF (SELECT COUNT(*) FROM sysobjects WHERE name = 'Calls' AND type = 'V') > 0
BEGIN
IF object_id('Emerald4_Calls..Calls') IS NOT NULL
	SELECT @switchto = 'Emerald4_Calls'
END

IF @switchto IS NOT NULL
	EXEC('use ' + @switchto)

IF object_id('calls_insert') IS NOT NULL
	DROP TRIGGER calls_insert

EXEC('CREATE TRIGGER calls_insert ON Calls
FOR INSERT
AS
DECLARE @rows INT
UPDATE RadIPAddresses SET State = CASE WHEN i.AcctStatusType IN (1,3) THEN 2 WHEN i.AcctStatusType = 2 THEN 0 ELSE State END
FROM RadIPAddresses ri, inserted i
	WHERE ri.NASPort = i.NASPort
	AND ri.NASIdentifier = i.NASIdentifier

UPDATE RadConcurrency SET Connections = Connections + CASE WHEN i.AcctStatusType IN (1,3) THEN 1 WHEN i.AcctStatusType = 2 THEN -1 ELSE 0 END
FROM MasterAccounts ma, SubAccounts sa, RadConcurrency rc, inserted i
	WHERE i.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR rc.AccountTypeID = sa.AccountTypeID)

SELECT @rows = 0
SELECT @rows = @rows + 1 
FROM inserted
GROUP BY NASIdentifier, NASPort, ServerID

UPDATE ServerPorts
        Set Username = i.Username, 
		AccountID = i.AccountID,
                AcctStatusType = CASE WHEN (i.CallDate = sp.CallDate AND i.AcctSessionID = sp.AcctSessionID AND i.AcctStatusType = 1 AND sp.AcctStatusType = 2) THEN 2 WHEN i.AcctStatusType in (1,3) THEN 1 ELSE i.AcctStatusType END,
		CallDate = i.CallDate,
		FramedAddress = i.FramedAddress,
		CallerID = i.CallerID,
		ConnectInfo = i.ConnectInfo,
		AcctSessionID = i.AcctSessionID
        FROM ServerPorts sp, inserted i
        WHERE sp.NASIdentifier = i.NASIdentifier
	AND sp.Port = CASE WHEN i.NASPort IN (''0'',''-1'') THEN RIGHT(COALESCE(REPLACE(i.CallerID,'':'',''''),i.AcctSessionID),10) ELSE i.NASPort END
	AND (i.CallDate >= sp.CallDate OR sp.CallDate IS NULL)

IF (@@rowcount <> @rows)
	BEGIN
	/* SNMPUser should add the port for all except 10 (ascend) */

	INSERT INTO ServerPorts (ServerID,Port,NASIdentifier,IPAddress,MaxSessionTime,CostPerMinute,Username,AccountID,AcctSessionID,
	AcctStatusType,CallDate,FramedAddress,CallerID,ConnectInfo,SNMPUser)

	SELECT i.ServerID,CASE WHEN i.NASPort IN (''0'',''-1'') THEN RIGHT(COALESCE(REPLACE(MIN(i.CallerID),'':'',''''),MIN(i.AcctSessionID)),10) ELSE i.NASPort END,i.NASIdentifier,NULL,0,0,MIN(i.Username),MIN(i.AccountID),MIN(i.AcctSessionID),CASE WHEN MAX(i.AcctStatusType) in (1,3) THEN 1 ELSE MAX(i.AcctStatusType) END,
	MAX(i.CallDate),MIN(i.FramedAddress),MIN(i.CallerID),MIN(i.ConnectInfo),
	Case when MIN(st.SNMPType)=1 then MIN(st.SNMPUser) else MIN(st.SNMPUser) + convert(varchar(9), i.NASPort) END
	FROM inserted i, Servers s, ServerTypes st
		WHERE s.ServerType = st.ServerType
		AND s.ServerID = COALESCE(i.ServerID,(SELECT MAX(s.ServerID) FROM Servers s, inserted ii WHERE s.IPAddress = ii.NASIdentifier))
		AND NOT EXISTS (SELECT * FROM ServerPorts sp, inserted ii WHERE sp.NASIdentifier = ii.NASIdentifier AND sp.Port = CASE WHEN ii.NASPort IN (''0'',''-1'') THEN RIGHT(COALESCE(REPLACE(ii.CallerID,'':'',''''),ii.AcctSessionID),10) ELSE ii.NASPort END)
	GROUP BY i.NASIdentifier, i.NASPort, i.ServerID
	END

/* Stuff we only do on stop records */
UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NULL
        AND sa.Login = i.Username
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2

UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NOT NULL
        AND sa.AccountID = i.AccountID
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2
')
IF @switchto IS NOT NULL
	EXEC('use ' + @current)
GO


