EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'DateSeperator'
GO
EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'DateFormatID'
GO
EXEC MetaAddObjectFile 'Incidents','mbr_incidents.ews'
GO
EXEC MetaAddObjectFile 'Incidents','mbr_incident_list_f.ews'
GO
EXEC MetaAddObjectFile 'MBR Acct','mbr_invoice_current.ews'
GO
EXEC MetaAddObjectFile 'All','cookie_js.ews'
GO
EXEC MetaAddObjectFile 'Client','cookie_js.ews'
GO
EXEC MetaAddObjectFile 'Customer Access','cookie_js.ews'
GO
EXEC MetaAddObjectFile 'Client','datepicker_js.ews'
GO
EXEC MetaAddObjectFile 'Client','form_js.ews'
GO
EXEC MetaAddObjectFile 'Client','form_js.ews'
GO
EXEC MetaAddObjectFile 'Customer Access','prompt_js.ews'
GO
EXEC MetaAddObjectFile 'Customer Access','creditcardinfo.ews'
GO
EXEC MetaAddObjectFile 'Customer Access','cust_buytime.ews'
GO
EXEC MetaAddObjectFile 'Customer Access','cust_buytime_submit.ews'
GO
EXEC MetaAddObjectTable 'Customer Access', 'Invoices', 0
GO
EXEC MetaAddObjectTable 'Customer Access', 'InvoiceItems', 0
GO
EXEC MetaAddObjectFile 'Client','prompt_js.ews'
GO
EXEC MetaAddObjectFile 'Client','validation_js.ews'
GO
EXEC MetaAddObjectFile 'Invoices','statement_header.ews'
GO
EXEC MetaAddObjectFile 'MBR Acct','statement_header.ews'
GO
EXEC MetaAddObjectFile 'Invoices','mbr_statement_next.ews'
GO
EXEC MetaAddObjectFile 'MBR Acct','mbr_statement_next.ews'
GO
EXEC MetaAddObjectFile 'Invoices','mbr_statement_preview.ews'
GO
EXEC MetaAddObjectFile 'MBR Acct','mbr_statement_preview.ews'
GO
EXEC MetaAddObjectFile 'Invoices','statement_marksent.ews'
GO
EXEC MetaAddObjectFile 'MBR Acct','statement_marksent.ews'
GO
EXEC MetaAddObjectFile 'Services','sa_atadjust.ews'
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Servers' AND sc.name = 'Concurrency') = 0)
	ALTER TABLE Servers ADD Concurrency INT DEFAULT 1 NULL
GO

UPDATE RadAttributes SET RadAttributeType = 0, Name = 'Digest-Response' WHERE RadAttributeID = 206 AND RadVendorID = 0
UPDATE RadAttributes SET RadAttributeType = 0, Name = 'Digest-Attributes' WHERE RadAttributeID = 207 AND RadVendorID = 0
GO

EXEC AddMetaTable 'Servers'
GO

IF ((SELECT COUNT(*) FROM SubAccountDataTypes WHERE ExternalSystemType = -3) = 0)
	INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Max Mailbox Size',NULL,-3,0)
GO

EXEC AddMetaTable 'TimeCharges'
EXEC SetMetaTableGroup 'TimeCharges', 2, 60, 0, NULL
GO

IF object_id('Aging') IS NOT NULL
	DROP PROCEDURE Aging
GO
CREATE PROCEDURE Aging (@update INT = 0, @operatorgroupid INT = 1) AS
SET NOCOUNT ON
SELECT ma.CustomerID,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,getdate()) AND getdate() THEN (ii.Amount * ii.Quantity) - ii.PaidAmount ELSE 0 END) AS Age0,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,getdate()) AND DATEADD(dd,-30,getdate()) THEN (ii.Amount * ii.Quantity) - ii.PaidAmount ELSE 0 END) AS Age30,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,getdate()) AND DATEADD(dd,-60,getdate()) THEN (ii.Amount * ii.Quantity) - ii.PaidAmount ELSE 0 END) AS Age60,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,getdate()) AND DATEADD(dd,-90,getdate()) THEN (ii.Amount * ii.Quantity) - ii.PaidAmount ELSE 0 END) AS Age90,
SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,getdate())THEN (ii.Amount * ii.Quantity) - ii.PaidAmount ELSE 0 END) AS Age120,
COALESCE((SELECT SUM(c.Amount) From Charges c WHERE c.CustomerID = ma.CustomerID AND c.ItemID IS NULL),0) AS PendingCharge,
COALESCE((SELECT SUM(i2.Amount) From Invoices i2 WHERE i2.CustomerID = ma.CustomerID AND i2.InvoiceTypeID = 91 AND i2.StatementID IS NULL),0) AS PendingPOS
INTO #temp_aging

FROM Invoices i, MasterAccounts ma, InvoiceItems ii
	WHERE ma.CustomerID = i.CustomerID
	AND i.InvoiceTypeID <> 0
	AND i.InvoiceID = ii.InvoiceID
	AND ii.Amount > 0
	AND i.StatementID IS NOT NULL
GROUP BY ma.CustomerID

IF @update <> 1
SELECT ma.CustomerID, CASE WHEN ((ma.Balance + ma.PendingDebit - ma.PendingCredit + a.PendingCharge + a.PendingPOS < 0) OR (a.Age30 = 0 AND a.Age60 = 0 AND a.Age90 = 0 AND a.Age120 = 0)) THEN ma.Balance + ma.PendingDebit - ma.PendingCredit + a.PendingCharge + a.PendingPOS ELSE a.Age0 + a.PendingCharge END AS Age0, a.Age30, a.Age60, a.Age90, a.Age120, ma.FirstName, ma.LastName, ma.Company, ma.PhoneWork, ma.PhoneHome, ma.Active, ma.GroupID
FROM MasterAccounts ma, #temp_aging a
	WHERE ma.CustomerID = a.CustomerID
	AND (ma.Balance + ma.PendingDebit - ma.PendingCredit + a.PendingCharge + a.PendingPOS) NOT BETWEEN -.0099 AND .0099
	AND (@operatorgroupid = 1 OR EXISTS (SELECT * FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID = @operatorgroupid AND (GroupID = ma.GroupID OR GroupID = 1)))
ORDER BY ma.CustomerID

DROP TABLE #temp_aging
SET NOCOUNT OFF
GO
GRANT EXECUTE ON Aging TO Emerald
GO

DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('SalesPersons-Add.ews','SalesPersons-Delete.ews','SalesPersons-Edit.ews','SalesPersons-List.ews','SalesPersons-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('AccountTypes-Add.ews','AccountTypes-Delete.ews','AccountTypes-Edit-Radius5.ews','AccountTypes-Edit.ews','AccountTypes-List.ews','AccountTypes-Update.ews')
GO
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('Domains-Add.ews','Domains-Delete.ews','Domains-Edit.ews','Domains-List.ews','Domains-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('Groups-Add.ews','Groups-Delete.ews','Groups-Edit-Default.ews','Groups-Edit.ews','Groups-Edit_global.ews','Groups-List.ews','Groups-Update.ews')
GO
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('Regions-Add.ews','Regions-Delete.ews','Regions-Edit.ews','Regions-List.ews','Regions-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('CancelReasons-Add.ews','CancelReasons-Delete.ews','CancelReasons-Edit.ews','CancelReasons-List.ews','CancelReasons-Update.ews')
GO
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('ReferredBys-Add.ews','ReferredBys-Delete.ews','ReferredBys-Edit.ews','ReferredBys-List.ews','ReferredBys-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('IncidentTypes-Add.ews','IncidentTypes-Delete.ews','IncidentTypes-Edit.ews','IncidentTypes-List.ews','IncidentTypes-Update.ews')
GO
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('IncidentStates-Add.ews','IncidentStates-Delete.ews','IncidentStates-Edit.ews','IncidentStates-List.ews','IncidentStates-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('ModemSpeeds-Add.ews','ModemSpeeds-Delete.ews','ModemSpeeds-Edit.ews','ModemSpeeds-List.ews','ModemSpeeds-Update.ews')
GO
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('NetSoftwares-Add.ews','NetSoftwares-Delete.ews','NetSoftwares-Edit.ews','NetSoftwares-List.ews','NetSoftwares-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('SystemTypes-Add.ews','SystemTypes-Delete.ews','SystemTypes-Edit.ews','SystemTypes-List.ews','SystemTypes-Update.ews')
DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('admin.ews','group.ews')
GO

UPDATE Configs SET Edition = 1 WHERE Edition = 0 AND ConfigID IN (8,16,34,35,45,505,503,501,506)
GO

UPDATE MetaTables SET Edition = 1 WHERE TableName IN ('BillingCycles','GLCodes') AND Edition = 0
GO

DELETE FROM ConfigValues WHERE ConfigID = 29
DELETE FROM Configs WHERE ConfigID = 29
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 308) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('MBR Custom Edit File',308,308,8,0,1,NULL,0,1)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 309) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('MBR Custom Save File',309,309,8,0,1,NULL,0,1)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 310) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Service Custom Edit File',310,310,8,0,1,NULL,0,1)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 311) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Service Custom Save File',311,311,8,0,1,NULL,0,1)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 508) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Email Incidents by default',508,61,4,1,0,NULL,0,1)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(508,1,'Yes')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(508,0,'No')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 507) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Print Invoices if Current Balance is 0 or Credit',507,39,6,1,0,NULL,0,1)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(507,1,'Yes')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(507,0,'No')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 506) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Customer Website Show Billing History',506,506,8,1,0,NULL,0,1)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(506,1,'Yes')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(506,0,'No')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 505) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Minimum new statement interval (Days)',505,505,6,15,0,NULL,0,1)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 509) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Customer Website Links File',509,509,8,0,1,NULL,0,1)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 510) = 0
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Customer Website Header File',510,510,8,0,1,NULL,0,1)
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'SubAccounts' AND sc.name = 'LastTimeLeftDate') = 0)
	ALTER TABLE SubAccounts ADD LastTimeLeftDate DATETIME DEFAULT getdate() NULL
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 504) = 0
BEGIN
DECLARE @active INT
SELECT @active = Active FROM Schedules WHERE Parameter = '{CALL Update_TimeLeft}' AND Interval >= 0 AND TaskName = 'query'
IF (@active = 0)
	UPDATE Schedules SET Active = 1 WHERE Parameter = '{CALL Update_TimeLeft}' AND Interval >= 0 AND TaskName = 'query'
SELECT @active = COALESCE(@active,0)

UPDATE SubAccounts SET LastTimeLeftDate = DATEADD(mm,CASE WHEN DATEPART(dd,getdate()) < ma.BillDay THEN -1 ELSE 0 END,DATEADD(dd,ma.BillDay,DATEADD(dd,-(DATEPART(dd,getdate())),getdate())))
FROM SubAccounts sa, MasterAccounts ma
	WHERE ma.CustomerID = sa.CustomerID

INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Time Left monthly update',504,504,6,@active,0,NULL,0,0)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(504,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(504,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(504,2,'If not expired')
END
GO

-- Add New expire date moving options 600-602 11/7/04
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 600) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Move Expire Date On Any Payment Amount',600,200,6,1,0,NULL,0,0)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(600,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(600,1,'Yes')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 601) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Move Expire Forward Minimum Type',601,201,6,1,0,NULL,0,0)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(601,0,'Money')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(601,1,'Percentage')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 602) = 0
BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Move Expire Forward Minimum Amount',602,202,6,1,0,NULL,0,0)
END
GO


IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'AccountTypes' AND sc.name = 'RadFailReason') = 0)
	ALTER TABLE AccountTypes ADD RadFailReason smallint NULL
GO

IF (SELECT COUNT(*) FROM RadDestTypes) = 0
BEGIN
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID) VALUES('Filter Replace',1)
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID) VALUES('Filter Merge',2)
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID) VALUES('Nak',3)
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID) VALUES('Ignore',4)
INSERT INTO RadDestTypes (RadDestType,RadDestTypeID) VALUES('Source Specific',5)
END
GO

IF (SELECT COUNT(*) FROM RadFilterTypes) = 0
BEGIN
INSERT INTO RadFilterTypes (RadFilterTypeID,RadFilterType) VALUES(1,'Client IP')
INSERT INTO RadFilterTypes (RadFilterTypeID,RadFilterType) VALUES(2,'Host IP')
INSERT INTO RadFilterTypes (RadFilterTypeID,RadFilterType) VALUES(3,'Radius Attribute')
INSERT INTO RadFilterTypes (RadFilterTypeID,RadFilterType) VALUES(4,'Destination IP')
END
GO

IF (SELECT COUNT(*) FROM RadMergeTypes) = 0
BEGIN
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Delete',1)
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Delete matching',2)
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Add',3)
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Replace value',4)
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Add or replace value',5)
INSERT INTO RadMergeTypes (RadMergeType,RadMergeTypeID) VALUES('Add attributes from query',6)
END
GO

IF (SELECT COUNT(*) FROM RadSearchTypes) = 0
BEGIN
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(1,'String')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(2,'Substring')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(3,'Equal')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(4,'Less than')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(5,'Greater than')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(6,'Ends with')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(7,'Starts with')
INSERT INTO RadSearchTypes (RadSearchTypeID,RadSearchType) VALUES(8,'Any value')
END
GO

IF (SELECT COUNT(*) FROM RadSourceTypes) = 0
BEGIN
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Disable or Chain Dest',1)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth In',10)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth Out',11)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth Proxy Out',12)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth Proxy Req+Resp',13)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth Req+Resp',14)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Acct In',20)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Acct Out',21)
INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Acct Proxy Out',22)
END
GO

IF (SELECT COUNT(*) FROM RadSourceTypes WHERE RadSourceTypeID = 15) = 0
	INSERT INTO RadSourceTypes (RadSourceType,RadSourceTypeID) VALUES('Auth Proxy Resp',15)
GO

EXEC AddMetaTable 'AccountTypes'
EXEC AddMetaTable 'RadFilterGroups'
EXEC AddMetaTable 'RadFilters'
EXEC SetMetaTableGroup 'RadFilterGroups', 4, 11, 0, 100
EXEC MetaAddObjectFile 'Accounting','AccountTypes-Edit-Radius5.ews'
GO

IF object_id('RadGetFilterGroups') IS NOT NULL
	DROP PROCEDURE RadGetFilterGroups
GO
CREATE PROCEDURE RadGetFilterGroups AS
SELECT RadFilterGroupID, RadSourceTypeID, RadDestTypeID, DestRadFilterGroupID, DestData
FROM RadFilterGroups
ORDER BY SortOrder DESC,RadFilterGroup DESC
GO
GRANT EXECUTE ON RadGetFilterGroups TO Emerald
GO

IF object_id('RadGetFilters') IS NOT NULL
	DROP PROCEDURE RadGetFilters
GO
CREATE PROCEDURE RadGetFilters @RadFilterGroupID INT AS
SELECT RadFilterTypeID, RadVendorID, RadAttributeID, RadSearchTypeID, RadMergeTypeID, Data
FROM RadFilters
	WHERE RadFilterGroupID = @RadFilterGroupID
ORDER BY RadFilterID DESC
GO
GRANT EXECUTE ON RadGetFilters TO Emerald
GO



EXEC AddMetaTable 'RadConcurrency'
EXEC SetMetaTableGroup 'RadConcurrency', 4, 12, 0, NULL

EXEC MetaAddObjectFile 'RADIUS','RadConcurrency-Delete.ews'
EXEC MetaAddObjectFile 'RADIUS','RadConcurrency-List.ews'
EXEC MetaAddObjectFile 'RADIUS','RadConcurrency-Update.ews'
EXEC MetaAddObjectFile 'RADIUS','RadConcurrency-Edit.ews'
EXEC MetaAddObjectFile 'RADIUS','RadConcurrency-Add.ews'
GO

EXEC MetaAddObjectFile 'MBR', 'query_madatatypes.ews'
EXEC MetaAddObjectFile 'Services', 'query_sadatatypes.ews'
EXEC MetaAddObjectFile 'MBR', 'accounts_custom.ews'
EXEC MetaAddObjectFile 'Services', 'accounts_custom.ews'
EXEC MetaAddObjectFile 'MBR', 'accounts_custom-search.ews'
EXEC MetaAddObjectFile 'Services', 'accounts_custom-search.ews'
EXEC MetaAddObjectFile 'Services','sa_check_login.ews'
GO

EXEC MetaAddObjectFile 'Client', 'db_nofound.ews'
EXEC MetaAddObjectFile 'Client', 'print_parm.ews'

EXEC MetaAddObjectFile 'MBR Acct', 'mbr_payment_edit.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'mbr_payment_edit_save.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'mbr_payment_delete.ews'

EXEC MetaAddObjectFile 'Services', 'sa_open_check.ews'
EXEC MetaAddObjectFile 'Services', 'sa_close_check.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'sa_open.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'sa_close.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'sa_close_form.ews'
GO

EXEC MetaAddObjectFile 'Reports','callsearch.ews'
EXEC MetaAddObjectFile 'Reports','callsearch_f.ews'
EXEC MetaAddObjectFile 'Reports','callsearch_list.ews'
EXEC MetaAddObjectFile 'Reports','callsearch_list_f.ews'
GO

EXEC MetaAddObjectFile 'Reports','expaccts.ews'
EXEC MetaAddObjectFile 'Reports','serv_rev.ews'
EXEC MetaAddObjectFile 'Reports','call_sum.ews'
EXEC MetaAddObjectFile 'Reports','payments.ews'
EXEC MetaAddObjectFile 'Reports','newusers.ews'
EXEC MetaAddObjectFile 'Reports','futureexp.ews'
EXEC MetaAddObjectFile 'Reports','badtrans.ews'
EXEC MetaAddObjectFile 'Reports','statement.ews'
EXEC MetaAddObjectFile 'Reports','invoice.ews'
EXEC MetaAddObjectFile 'Reports','receipt.ews'
EXEC MetaAddObjectFile 'Reports','account.ews'
EXEC MetaAddObjectFile 'Reports','history.ews'
GO

EXEC MetaAddObjectFile 'Reports','region_summary.ews'
EXEC MetaAddObjectFile 'Reports','service_summary.ews'
EXEC MetaAddObjectFile 'Reports','commission.ews'
EXEC MetaAddObjectFile 'Reports','errors_daily.ews'
EXEC MetaAddObjectFile 'Reports','commission2.ews'
EXEC MetaAddObjectFile 'Reports','call_proxy.ews'
EXEC MetaAddObjectFile 'Reports','ExpiredAuth.ews'
EXEC MetaAddObjectFile 'Reports','payments_parm.ews'
EXEC MetaAddObjectFile 'Reports','newusers_monthly.ews'
EXEC MetaAddObjectFile 'Reports','users_monthly.ews'
GO

EXEC MetaAddObjectFile 'MBR Acct','singleinvoice.ews'
EXEC MetaAddObjectFile 'MBR Acct','singleeinvoice.ews'
EXEC MetaAddObjectFile 'MBR Acct','singlestatement.ews'
EXEC MetaAddObjectFile 'MBR Acct','singleestatement.ews'
EXEC MetaAddObjectFile 'MBR Acct','account.ews'
EXEC MetaAddObjectFile 'MBR Acct','history.ews'
EXEC MetaAddObjectFile 'MBR Acct','receipt.ews'
EXEC MetaAddObjectFile 'MBR','account.ews'
GO

EXEC MetaAddObjectFile 'Batch','batch_preview_ach_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_preview_cc_f.ews'
GO

EXEC MetaAddObjectFile 'MBR','ma_cust.html'
EXEC MetaAddObjectFile 'Services','sa_cust.html'
EXEC MetaAddObjectFile 'Services','sa_data-Delete.ews'
EXEC MetaAddObjectFile 'MBR','mbr_data-Delete.ews'
GO

EXEC MetaAddObjectFile 'MBR Acct','mbr_etrans_void.ews'
EXEC MetaAddObjectFile 'Reports','online_clear.ews'
GO

EXEC MetaAddObjectFile 'Client','error_update.ews'
GO

EXEC MetaAddObjectFile 'Incidents','incident_add_email.ews'
GO

EXEC MetaAddObjectFile 'Invoices','invoice_comments_save.ews'
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'MasterAccountDataTypes' AND sc.name = 'SortOrder') = 0)
	ALTER TABLE MasterAccountDataTypes ADD SortOrder smallint DEFAULT 1 NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'SubAccountDataTypes' AND sc.name = 'SortOrder') = 0)
	ALTER TABLE SubAccountDataTypes ADD SortOrder smallint DEFAULT 1 NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'PayPeriods' AND sc.name = 'ConfirmTrans') = 0)
	ALTER TABLE PayPeriods ADD ConfirmTrans smallint DEFAULT 0 NULL
GO

EXEC AddMetaTable 'MasterAccountDataTypes'
EXEC AddMetaTable 'SubAccountDataTypes'
EXEC AddMetaTable 'PayPeriods'
GO

EXEC MetaAddObjectTable 'MBR Acct', 'Payments', 1
EXEC MetaAddObjectTable 'MBR Payment', 'Payments', 1
GO

IF object_id('RadGetProxyAttributes') IS NOT NULL
	DROP PROCEDURE RadGetProxyAttributes
GO

CREATE PROCEDURE dbo.RadGetProxyAttributes AS
SELECT apg.RadProxyAttributeGroupID,apg.RadRoamServerID,ap.String,ap.SearchType,CASE WHEN ap.RadVendorID = 0 THEN ap.RadAttributeID ELSE ap.RadVendorType END AS AttributeID, ap.RadVendorID
FROM RadProxyAttributeGroups apg, RadProxyAttributes ap
	WHERE apg.RadProxyAttributeGroupID = ap.RadProxyAttributeGroupID
ORDER BY apg.Priority ASC, apg.RadProxyAttributeGroupID
GO

GRANT EXECUTE ON RadGetProxyAttributes TO Emerald
GO

IF object_id('RadGetUser') IS NOT NULL
	DROP PROCEDURE RadGetUser
GO

CREATE PROCEDURE dbo.RadGetUser @user VARCHAR(64) , @password VARCHAR(32) AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60 AS TimeLeft, 
CASE WHEN ma.CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',ma.CancelDate) END AS MasterExpire,
CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
        WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
        AND sa.Login = @user
UNION ALL
SELECT sa.AccountID, sa.Email, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60 AS TimeLeft, 
MasterExpire=CASE WHEN ma.CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',ma.CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
        WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
        AND sa.Email = @user
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO
GRANT EXECUTE ON RadGetUser TO Emerald
GO


IF object_id('RadGetCacheUsers') IS NOT NULL
	DROP PROCEDURE RadGetCacheUsers
GO

CREATE PROCEDURE dbo.RadGetCacheUsers @date DATETIME, @flag SMALLINT AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@flag = 1)
BEGIN
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountTypeID, sa.LoginLimit, sa.TimeLeft * 60,
MasterExpire=CASE WHEN ma.CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',ma.CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
0 AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.Login <> ''
	AND (sa.LastModifyDate > @date OR ma.LastModifyDate > @date)
END ELSE IF (@flag = 2)
BEGIN
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60,
MasterExpire=CASE WHEN ma.CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',ma.CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.Login <> ''
	AND (sa.LastUsed > @date OR sa.LastUsed IS NULL)
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO
GRANT EXECUTE ON RadGetCacheUsers TO Emerald
GO

IF object_id('UpdateBillDay') IS NOT NULL
	DROP PROCEDURE UpdateBillDay
GO

CREATE PROCEDURE UpdateBillDay AS
SET NOCOUNT ON
SELECT ma.CustomerID, MAX(DATEPART(dd,sa.BilledThru)) AS BillDay INTO #tmp
FROM MasterAccounts ma, SubAccounts sa, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sa.Active = 1
	AND bc.CycleType IN (0,3)
	AND ma.BillDay <= 28
GROUP BY ma.CustomerID
	HAVING MAX(DATEPART(dd,sa.BilledThru)) = MIN(DATEPART(dd,sa.BilledThru))
	AND MIN(ma.BillDay) <> MAX(DATEPART(dd,sa.BilledThru))
UNION
SELECT ma.CustomerID, COALESCE(bc.BillDay,1) AS BillDay
FROM MasterAccounts ma, BillingCycles bc
	WHERE ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND bc.CycleType NOT IN (0,3)
	AND ma.BillDay <> COALESCE(bc.BillDay,1)

UPDATE MasterAccounts SET BillDay = t.BillDay
FROM MasterAccounts ma, #tmp t
	WHERE ma.CustomerID = t.CustomerID

DROP TABLE #tmp
GO

GRANT EXECUTE ON UpdateBillDay TO Emerald
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL UpdateBillDay}') = 0
INSERT INTO Schedules
(Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate)
VALUES('Update MBR billing day','query',NULL,1,NULL,1,'{CALL UpdateBillDay}',NULL,0,getdate(),
'admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 01:55:00')
GO

IF object_id('Update_TimeLeft') IS NOT NULL
	DROP PROCEDURE Update_TimeLeft
GO

CREATE PROCEDURE dbo.Update_TimeLeft (@accountid INT = NULL, @customerid INT = NULL) AS
SET NOCOUNT ON
DECLARE @option INT

IF @accountid IS NULL AND @customerid IS NULL
BEGIN
SELECT @option = Value FROM Configs WHERE ConfigID = 504
SELECT @option = COALESCE(@option,1)
END

IF @option <> 0 AND (@accountid IS NULL AND @customerid IS NULL)
Update SubAccounts
Set TimeLeft = CASE WHEN sa.TimeLeft > at1.TimeLeft THEN sa.TimeLeft ELSE at1.TimeLeft END, LastTimeLeftDate = getdate()
From MasterAccounts ma, SubAccounts sa, AccountTypes at1, Discounts d
	WHERE ma.CustomerID = sa.CustomerID
	AND (sa.LastTimeLeftDate < DATEADD(mm,-1,getdate()) OR ((DATEPART(dd,GETDATE()) = ma.BillDay) OR ((DATEPART(mm,GETDATE()) <> DATEPART(mm,DATEADD(dd,1,GETDATE()))) AND DATEPART(dd,GETDATE()) <= ma.BillDay)))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.TimeLeft IS NOT NULL
	AND at1.TimeLeft IS NOT NULL
	AND sa.DiscountID = d.DiscountID
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.LastTimeLeftDate <= DATEADD(dd,-1,getdate())
	AND (@option = 1 OR (@option = 2 AND (sa.ExpireDate > getdate() OR ((sa.DiffCost=1 AND sa.Cost <= 0) OR (d.AmountType = 0 AND (at1.Cost*d.Amount) <= 0) OR (d.AmountType = 1 AND at1.Cost <= d.Amount)) )))

IF (@accountid IS NOT NULL OR @customerid IS NOT NULL)
UPDATE SubAccounts SET TimeLeft = at1.TimeLeft, LastTimeLeftDate = CASE WHEN DATEDIFF(mm,getdate(),DATEADD(dd,-(DATEPART(dd,getdate()) - ma.BillDay),getdate())) > 0 THEN DATEADD(dd,1 - (DATEPART(dd,DATEADD(mm,1,getdate()))),DATEADD(mm,1,getdate())) ELSE DATEADD(mm,CASE WHEN ma.BillDay <= DATEPART(dd,getdate()) THEN 0 ELSE -1 END,DATEADD(dd,-(DATEPART(dd,getdate()) - ma.BillDay),getdate())) END
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.LastTimeLeftDate < CASE WHEN DATEDIFF(mm,getdate(),DATEADD(dd,-(DATEPART(dd,getdate()) - ma.BillDay),getdate())) > 0 THEN DATEADD(dd,1 - (DATEPART(dd,DATEADD(mm,1,getdate()))),DATEADD(mm,1,getdate())) ELSE DATEADD(mm,CASE WHEN ma.BillDay <= DATEPART(dd,getdate()) THEN 0 ELSE -1 END,DATEADD(dd,-(DATEPART(dd,getdate()) - ma.BillDay),getdate())) END
	AND sa.TimeLeft IS NOT NULL
	AND at1.TimeLeft IS NOT NULL
	AND sa.TimeLeft < at1.TimeLeft
	AND (sa.AccountID = @accountid OR sa.CustomerID = @customerid)
GO


GRANT EXECUTE ON Update_TimeLeft TO Emerald
GO

IF object_id('ScheduleStatusClear') IS NOT NULL
	DROP PROCEDURE ScheduleStatusClear
GO

CREATE PROCEDURE ScheduleStatusClear @servername VARCHAR(32) AS
UPDATE Schedules SET Status = 0
FROM Schedules s, ScheduleServers ss
	WHERE Status = 1
	AND (s.ScheduleServerID = ss.ScheduleServerID OR s.LockServerID = ss.ScheduleServerID)
	AND ss.Server = @servername
GO

GRANT EXECUTE ON ScheduleStatusClear TO Emerald
GO

IF object_id('RadConcurrencySync') IS NOT NULL
	DROP PROCEDURE RadConcurrencySync
GO

CREATE PROCEDURE dbo.RadConcurrencySync AS
CREATE TABLE #sync (RadConcurrencyID INT, Connections INT)

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT INTO #sync (RadConcurrencyID,Connections)
SELECT RadConcurrencyID, COUNT(*) AS Connections 
FROM ServerPorts sp, MasterAccounts ma, SubAccounts sa, RadConcurrency rc
	WHERE sp.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR sa.AccountTypeID = rc.AccountTypeID)
	AND sp.AcctStatusType IN (1,3)
GROUP BY rc.RadConcurrencyID

UPDATE RadConcurrency SET Connections = 0
UPDATE RadConcurrency SET LastSyncDate = getdate(), Connections = rc.Connections
FROM RadConcurrency rc, #sync s
	WHERE rc.RadConcurrencyID = s.RadConcurrencyID
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

DROP TABLE #sync
GO
GRANT EXECUTE ON RadConcurrencySync TO Emerald
GO

IF object_id('RadCheckOnline') IS NOT NULL
	DROP PROCEDURE RadCheckOnline
GO

CREATE PROCEDURE dbo.RadCheckOnline @Username varchar(64), @accountid INT, @CallerID VARCHAR(64) = NULL, @NASIdentifier VARCHAR(64) = NULL  AS
DECLARE @GroupID INT, @LoginLimit INT, @Connections INT, @ConnectionsMax INT, @LastSyncDate DATETIME, @AccountTypeID INT, @RadConcurrencyID INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

IF (@accountid IS NOT NULL)
BEGIN
	SELECT @AccountTypeID = sa.AccountTypeID, @LoginLimit = sa.LoginLimit, @GroupID = ma.GroupID FROM MasterAccounts ma, SubAccounts sa WHERE ma.CustomerID = sa.CustomerID AND sa.AccountID = @accountid

	SELECT @RadConcurrencyID = RadConcurrencyID, @LastSyncDate = LastSyncDate, @Connections = Connections, @ConnectionsMax = ConnectionsMax
	FROM RadConcurrency
		WHERE GroupID = @GroupID
		AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)
	ORDER BY AccountTypeID ASC

	IF (@RadConcurrencyID IS NOT NULL)
	BEGIN
		IF (@Connections >= @ConnectionsMax AND DATEDIFF(ss,@LastSyncDate,getdate()) > 1800)
			BEGIN
			EXEC RadConcurrencySync
			SELECT @RadConcurrencyID = RadConcurrencyID, @LastSyncDate = LastSyncDate, @Connections = Connections, @ConnectionsMax = ConnectionsMax
			FROM RadConcurrency
				WHERE GroupID = @GroupID
				AND (AccountTypeID IS NULL OR AccountTypeID = @AccountTypeID)
			ORDER BY AccountTypeID ASC
			END

		IF (@Connections >= @ConnectionsMax)
			SELECT @Connections, @ConnectionsMax
		ELSE
			SELECT COUNT(*) FROM ServerPorts WHERE AccountID = @accountid AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID)

	END ELSE BEGIN
		IF @accountid IS NOT NULL
			SELECT (SELECT COUNT(*) FROM ServerPorts WHERE AccountID IS NULL AND Username = @Username AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID)) + (SELECT COUNT(*) FROM ServerPorts WHERE AccountID = @accountid AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID))
		ELSE
			SELECT COUNT(*) FROM ServerPorts WHERE Username = @Username AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID)
	END

END ELSE BEGIN
IF @accountid IS NOT NULL
	SELECT (SELECT COUNT(*) FROM ServerPorts WHERE AccountID IS NULL AND Username = @Username AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID)) + (SELECT COUNT(*) FROM ServerPorts WHERE AccountID = @accountid AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID))
ELSE
	SELECT COUNT(*) FROM ServerPorts WHERE Username = @Username AND AcctStatusType IN (1,3) AND (@CallerID IS NULL OR CallerID IS NULL OR CallerID <> @CallerID)
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO
GRANT EXECUTE ON RadCheckOnline TO Emerald
GO

IF object_id('ErrorHistory') IS NOT NULL
	DROP PROCEDURE ErrorHistory
GO
CREATE PROCEDURE ErrorHistory (@start DATETIME = NULL, @stop DATETIME = NULL) AS
SELECT @stop = COALESCE(@stop,getdate()), @start = COALESCE(@start,DATEADD(hh,-6,DATEADD(ss,-(  (DATEPART(hh,getdate()) * 3600) + (DATEPART(mi,getdate()) * 60) + DATEPART(ss,getdate()) ),getdate())))

SELECT 'Emerald - ' + lm.Description AS Description, l.LogMsg AS Message, COUNT(*) AS ErrCount
FROM Logs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND lm.Severity > 3
	AND LogDate BETWEEN @start AND @stop
GROUP BY lm.Description, l.LogMsg
UNION ALL
SELECT 'Authentication failure - ' + rlm.Description AS Description, 'User: ' + rl.Username AS Message,  COUNT(*) AS ErrCount
FROM RadLogs rl, RadLogMsgs rlm
	WHERE rl.RadLogMsgID = rlm.RadLogMsgID
	AND LogDate BETWEEN @start AND @stop
	AND rlm.Severity > 0
GROUP BY rl.Username, rlm.Description
UNION ALL
SELECT 'Scheduled task failure - ' + COALESCE(s.TaskName,'') AS Description, sl.Description AS Message, COUNT(*) AS ErrCount
FROM Schedules s, ScheduleLogs sl
	WHERE sl.ScheduleID *= s.ScheduleID
	AND sl.StartDate BETWEEN @start AND @stop 
	AND sl.Status = 2
GROUP BY sl.Description,  s.TaskName
UNION ALL
SELECT 'Mail error - ' + lm.Description AS Description, l.LogDescription AS Message, COUNT(*) AS ErrCount
FROM MailLogs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND (lm.Severity > 3 OR l.LogDescription LIKE '%Error initializing%' OR l.LogDescription LIKE '% Failed %')
	AND l.LogDate BETWEEN @start AND @stop
GROUP BY lm.Description, l.LogDescription
UNION ALL
SELECT 'Syslog message' AS Description, sld.Data AS Message, COUNT(*) AS ErrCount
FROM SysLogs sl, SysLogDefs sld
	WHERE sl.DefID = sld.DefID
	AND sl.Version = sld.Version
	AND sl.LogDate BETWEEN @start AND @stop
	AND sl.Severity <= 3
GROUP BY sld.Data
UNION ALL
SELECT 'Card processing' AS Description, et.Response AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et
	WHERE TransType = 3
	AND ProcDate BETWEEN @start AND @stop
GROUP BY et.Response
UNION ALL
SELECT 'Card trans' AS Description, 'Card awaiting ' + CASE WHEN TransType = 0 THEN 'CC export' WHEN TransType = 100 THEN 'EFT export' WHEN TransType = 2 THEN 'CC response' WHEN TransType = 102 THEN 'EFT response' ELSE 'internal error' END + ' for more than 15 days' AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et
	WHERE TransType IN (0,2,100,102)
	AND ReqDate <= DATEADD(dd,-15,getdate())
Group BY TransType
UNION ALL
SELECT rt.RateTable + ' summary' AS Description, rt.RateTable + ' summary is over ' + CONVERT(VARCHAR,DATEDIFF(mm,LastProcDate,getdate())) + ' month(s) behind schedule' AS Message, 1 AS ErrCount
FROM RateTables rt
	WHERE rt.LastProcDate <= DATEADD(dd,-32,getdate())
	AND (RateTableID <> 2 OR EXISTS(SELECT * FROM Flows))
GO
GRANT EXECUTE ON ErrorHistory TO Emerald
GO

-- Database options
DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10410 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings(StringID, LanguageID, Version, ApplicationID, Data, URL) VALUES(10410, 1, 4, @appid, '<IMG SRC=/images/database.jpg BORDER=0 ALT=Database>', NULL)
	INSERT INTO Strings(StringID, LanguageID, Version, ApplicationID, Data, URL) VALUES(10410, 101, 4, @appid, '[Database]', NULL)
END

-- Custom search
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10130 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10130, '<IMG src="/images/customsearch.jpg" BORDER=0 ALT="Custom">',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10130, '[custom]', NULL)
END

-- custom data
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10357 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10357, '<IMG src="/images/customdata.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10357, '[custom data]', NULL)
END

-- service incidents
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10358 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10358, '<IMG src="/images/serviceincidents.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10358, '[incidents]', NULL)
END

-- radius config
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10359 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10359, '<IMG src="/images/radiusconfig.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10359, '[radius]', NULL)
END

-- close service
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10360 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10360, '<IMG src="/images/closeservice.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10360, '[close service]', NULL)
END

-- custom
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10225 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10225,'<IMG src="/images/customreports.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10225,'[custom]',NULL)
END

-- users online
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10226 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10226,'<IMG src="/images/online.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10226,'[users online]',NULL)
END

-- calls search
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10227 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10227,'<IMG src="/images/callsearch.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10227,'[calls search]',NULL)
END

-- ts graph
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10228 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10228,'<IMG src="/images/tsgraph.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10228,'[ts graph]',NULL)
END

-- aging report
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10229 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10229,'<IMG src="/images/aging.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10229,'[aging report]',NULL)
END

-- emerald log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10230 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10230,'<IMG src="/images/emerlog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10230,'[emerald log]',NULL)
END

-- audit log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10231 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10231,'<IMG src="/images/auditlog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10231,'[audit log]',NULL)
END

-- radius log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10232 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10232,'<IMG src="/images/radlog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10232,'[radius log]',NULL)
END

-- mail log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10233 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10233,'<IMG src="/images/maillog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10233,'[mail log]',NULL)
END

-- system log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10234 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10234,'<IMG src="/images/syslog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10234,'[system log]',NULL)
END

-- ftp log
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10235 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10235,'<IMG src="/images/ftplog.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10235,'[ftp log]',NULL)
END

-- open service
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10361 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,1,10361,'<IMG src="/images/openservice.jpg" BORDER=0>',NULL)
	INSERT INTO Strings (ApplicationID,Version,LanguageID,StringID,Data,URL) VALUES(@appid,4,101,10361,'[open service]',NULL)
END
GO

DELETE FROM Objects WHERE ObjectTypeID = 1 AND Data IN ('db.ews','db_backup.ews','db_backup_f.ews','db_backup_newdev.ews','db_backup_newdev_save.ews','db_backup_remove.ews','db_backup_schedule.ews','db_header.ews','db_query.ews','db_spidkill.ews','db_spidwatch.ews','db_spidwatch_f.ews')
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = 'email' AND TaskName = 'taskstatement') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('email',NULL,0,'Email Statements',86400,1,'20000101','admin',NULL,NULL,'taskstatement',NULL,1,NULL,NULL,NULL,NULL,'20000101','admin',0)
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = 'email' AND TaskName = 'taskinvoice') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('email',NULL,0,'Email Invoices',86400,1,'20000101','admin',NULL,NULL,'taskinvoice',NULL,1,NULL,NULL,NULL,NULL,'20000101','admin',0)
GO


DECLARE @cols INT
EXEC pkcols 'AuditLogs', @cols OUTPUT
IF (@cols = 0)
BEGIN
	SELECT LogMsgID,LogDate,LogMsg,MAX(Operator) AS Operator,MAX(CustomerID) AS CustomerID,MAX(AccountID) AS AccountID INTO #tmp2
	FROM AuditLogs
	GROUP BY LogMsgID,LogDate,LogMsg HAVING COUNT(LogMsgID) > 1

	DELETE FROM AuditLogs
	FROM AuditLogs l, #tmp2 t
		WHERE l.LogMsgID = t.LogMsgID
		AND l.LogDate = t.LogDate
		AND l.LogMsg = t.LogMsg

	INSERT INTO AuditLogs (LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID)
	SELECT LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID
		FROM #tmp2

	DROP TABLE #tmp2
	ALTER TABLE AuditLogs ADD PRIMARY KEY (LogMsgID, LogDate, LogMsg)
END
GO

DECLARE @cols INT
EXEC pkcols 'Logs', @cols OUTPUT
IF (@cols = 0)
BEGIN
	SELECT LogMsgID,LogDate,LogMsg,MAX(Operator) AS Operator,MAX(CustomerID) AS CustomerID,MAX(AccountID) AS AccountID INTO #tmp2
	FROM Logs
	GROUP BY LogMsgID,LogDate,LogMsg HAVING COUNT(LogMsgID) > 1

	DELETE FROM Logs 
	FROM Logs l, #tmp2 t
		WHERE l.LogMsgID = t.LogMsgID
		AND l.LogDate = t.LogDate
		AND l.LogMsg = t.LogMsg

	INSERT INTO Logs (LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID)
	SELECT LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID
		FROM #tmp2

	DROP TABLE #tmp2
	ALTER TABLE Logs ADD PRIMARY KEY (LogMsgID,LogDate,LogMsg)
END

EXEC pkcols 'OperatorCookies', @cols OUTPUT
IF (@cols = 0)
BEGIN
	DELETE FROM OperatorCookies
	ALTER TABLE OperatorCookies ADD PRIMARY KEY (Operator,Cookie)
END

EXEC pkcols 'StatementNotes', @cols OUTPUT
IF (@cols = 0)
	ALTER TABLE StatementNotes ADD PRIMARY KEY (StatementID,NoteID)

EXEC pkcols 'WebAccess', @cols OUTPUT
IF (@cols = 0)
	ALTER TABLE WebAccess ADD PRIMARY KEY (WebAccess)

EXEC pkcols 'WebConfigs', @cols OUTPUT
IF (@cols = 0)
	ALTER TABLE WebConfigs ADD PRIMARY KEY (WebConfigID)

EXEC pkcols 'WebLinks', @cols OUTPUT
IF (@cols = 0)
	ALTER TABLE WebLinks ADD PRIMARY KEY (WebLinkID)
GO

IF object_id('RadRoamPorts') IS NOT NULL
	DROP TABLE RadRoamPorts
GO


IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Reports' AND sc.name = 'Parameters') = 0)
	ALTER TABLE Reports ADD Parameters smallint DEFAULT 0 NULL
GO

EXEC AddMetaTable 'AuditLogs'
EXEC AddMetaTable 'Logs'
EXEC AddMetaTable 'OperatorCookies'
EXEC AddMetaTable 'StatementNotes'
EXEC AddMetaTable 'WebAccess'
EXEC AddMetaTable 'WebConfigs'
EXEC AddMetaTable 'WebLinks'
EXEC AddMetaTable 'RadRoamPorts'
EXEC AddMetaTable 'Reports'
GO

EXEC MetaAddObjectColumn 'Global', 'Reports', 'Parameters'
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'Phone') = 0
BEGIN
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,17,'Phone',0,'Phone',NULL,1,0,32,0,NULL)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,17,'Phone',1,'x_Phone',NULL,0,0,32,0,'$Phone')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'State') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,18,'State',0,'State',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,18,'State',1,'x_State',NULL,0,0,32,0,'$State')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'City') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,19,'City',0,'City',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,19,'City',1,'x_City',NULL,0,0,32,0,'$City')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'FirstName') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,20,'FirstName',0,'FirstName',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,20,'FirstName',1,'x_First_Name',NULL,0,0,32,0,'$FirstName')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'LastName') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,21,'LastName',0,'LastName',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,21,'LastName',1,'x_Last_Name',NULL,0,0,32,0,'$LastName')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'Country') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,22,'Country',0,'Country',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,22,'Country',1,'x_Country',NULL,0,0,32,0,'$Country')
END
GO

IF (SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 32 AND Description = 'Email') = 0
BEGIN
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,23,'Email',0,'Email',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,23,'Email',1,'x_Email',NULL,0,0,32,0,'$Email')
END
GO

DELETE FROM ExportColumns WHERE ExportID = 32 AND SortOrder = 7
GO

IF (SELECT COUNT(*) FROM CCImportColumns WHERE ExportID = 32 AND Description = 'Response Reason Code') = 0
	INSERT INTO CCImportColumns(ExportID, FieldType, SortOrder, Position, Description, Quoted, FieldSize, ApproveValue, DeclineValue, ErrorValue, Line) VALUES(32, 5, 3, 0, 'Response Reason Code', 0, 0, NULL, NULL, NULL, 1)
GO

-- Authorize.Net (AIM)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue)
SELECT MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,37,MinSize,ExportValue
FROM ExportColumns 
	WHERE ExportID = 32

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue)
SELECT MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,204,MinSize,ExportValue
FROM ExportColumns 
	WHERE ExportID = 203


INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize)
SELECT DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,37,FieldSize
FROM CCImportColumns
	WHERE ExportID = 32

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize)
SELECT DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,204,FieldSize
FROM CCImportColumns
	WHERE ExportID = 203

UPDATE ExportColumns SET FieldName = 'x_tran_key' 
	WHERE FieldName = 'x_Password' 
	AND ExportID IN (37,204)
	AND ExportValue = '$Password'
GO

DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10317 AND ApplicationID = @appid AND (LanguageID = 1 OR LanguageID = 101)) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10317, '<IMG src="/images/print.jpg" BORDER=0  ALT="Print History">', NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10317, '[print history]', NULL)
END

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 46) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) 
	VALUES('Text Export CPI',46,46,5,12,0,NULL,0,0)
END
GO

-- Add History # Months to display
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 303) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) 
	VALUES('Max Months of Customer History to Display',303,303,8,24,0,NULL,0,0)
END
GO

IF (SELECT Description FROM Configs WHERE ConfigID = 35) = 'Inactivate MBR w/non-zero Balance'
	BEGIN
	DELETE FROM ConfigValues WHERE ConfigID = 35
	DELETE FROM Configs Where ConfigID = 35
	END

-- Updating the database with Handling of Multiple Merchants accounts.
-- BJP - 3/12/2003

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Groups' AND sc.name = 'ccLogin') = 0)
	ALTER TABLE Groups ADD ccLogin varchar(40) NULL
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Groups' AND sc.name = 'ccPassword') = 0)
	ALTER TABLE Groups ADD 	ccPassword varchar(40) NULL
GO

EXEC AddMetaTable 'Groups'
GO

-- Add CC/EFT Dupe protection to Accounting
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 35) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) 
	VALUES('CC/EFT Dupe payment protection (Days)',35,350,6,14,0,NULL,0,0)
END
GO

-- External trans import should exclude negative balances, ACH additions, new StatementID in the table
IF object_id('ExternalTransImport') IS NOT NULL
	DROP PROCEDURE ExternalTransImport
GO
CREATE PROCEDURE dbo.ExternalTransImport @PayMethodID INT, @transtime DATETIME AS
DECLARE @maxstatid INT, @confirmdays INT
SELECT @confirmdays = COALESCE(Value,0) FROM Configs WHERE ConfigID = 35

IF @PayMethodID = 2
BEGIN
SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.StatementID = ma.LastStatementID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1
INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry,StatementID)
SELECT DISTINCT ma.CustomerID,NULL AS InvoiceID,
CASE 	WHEN g.ccLogin = 'NONE' THEN 3
	WHEN pp.ConfirmTrans = 1 OR p.PaymentID IS NOT NULL OR et2.ExternalTransID IS NOT NULL THEN 1 
	WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 3  
	ELSE 0 
    END AS TransType,
getdate() AS ReqDate,NULL AS ProcDate, s.EndBal AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,
-- S Confirm Trans
CASE	WHEN pp.ConfirmTrans = 1 THEN 'Period ' + pp.PayPeriod + ' requires confirm'
	WHEN g.ccLogin = 'NONE' THEN 'Group Not Configured for CC Processing'
	WHEN p.PaymentID IS NOT NULL THEN 'Existing PaymentID ' + CONVERT(VARCHAR,(SELECT MAX(PaymentID) FROM Payments p2 WHERE ma.CustomerID = p2.CustomerID AND Amount = s.EndBal)) + ' dupe amount'
	WHEN et2.ExternalTransID IS NOT NULL THEN 'Existing TransID ' + CONVERT(VARCHAR,(SELECT MAX(ExternalTransID) FROM ExternalTrans e2 WHERE ma.CustomerID = e2.CustomerID AND Amount = s.EndBal)) + ' dupe amount'
	WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 'Card expired'
    ELSE NULL 
END AS Response,
-- E Confirm Trans
@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, s.StatementID
FROM Payments p, Statements s, MasterAccounts ma, CreditCards cc, PayPeriods pp, ExternalTrans et2, Groups g
WHERE s.StatementID = ma.LastStatementID
	AND ma.GroupID = g.GroupID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND s.EndBal >= 1
	AND ma.PayPeriodID = pp.PayPeriodID
	AND ma.Balance + ma.PendingDebit - ma.PendingCredit >= 1	-- If Pending Credit, don't hit card!
-- S Confirm Trans
	AND ma.CustomerID *= et2.CustomerID
	AND s.EndBal *= et2.Amount
	AND et2.ReqDate > DATEADD(dd,-(@confirmdays),getdate())
	AND et2.TransType NOT IN (9,109,8,108)
	AND ma.CustomerID *=  p.CustomerID
	AND s.EndBal *= p.Amount
	AND p.CreateDate > DATEADD(dd,-(@confirmdays),getdate())
-- E Confirm Trans
	AND s.StatementID NOT IN (Select StatementID From ExternalTrans Where TransType in (0, 2, 4, 100, 102, 104) and StatementID IS NOT NULL)
UNION ALL
SELECT ma.CustomerID, NULL AS InvoiceID, 
CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate() THEN 3 ELSE 0 END AS TransType, 
getdate() AS ReqDate, NULL AS ProcDate, et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,
CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < getdate()  THEN 'Card expired' ELSE NULL END AS Response,
@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, et.StatementID
FROM ExternalTrans et, MasterAccounts ma, CreditCards cc
	WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND et.TransType = 7
	AND et.ReqDate < @transtime
UPDATE ExternalTrans SET TransType = 8 WHERE TransType = 7 AND ReqDate < @transtime
UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
END
ELSE IF @PayMethodID = 3
BEGIN
SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1
INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry,BankName,BankNumber,BankTransType,SSN,DLNumber,DLState,BirthDate,StatementID)
SELECT DISTINCT ma.CustomerID,NULL AS InvoiceID,
CASE 	WHEN g.ccLogin = 'NONE' THEN 103
	WHEN pp.ConfirmTrans = 1 OR p.PaymentID IS NOT NULL OR et2.ExternalTransID IS NOT NULL THEN 101 
	ELSE 100 
    END AS TransType,
getdate() AS ReqDate,NULL AS ProcDate, s.EndBal AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,
-- S Confirm Trans
CASE	WHEN g.ccLogin = 'NONE' THEN 'Group Not Configured for ACH Processing'
	WHEN pp.ConfirmTrans = 1 THEN 'Period ' + pp.PayPeriod + ' requires confirm'
	WHEN p.PaymentID IS NOT NULL THEN 'Existing PaymentID ' + CONVERT(VARCHAR,(SELECT MAX(PaymentID) FROM Payments p2 WHERE ma.CustomerID = p2.CustomerID AND Amount = s.EndBal)) + ' dupe amount'
	WHEN et2.ExternalTransID IS NOT NULL THEN 'Existing TransID ' + CONVERT(VARCHAR,(SELECT MAX(ExternalTransID) FROM ExternalTrans e2 WHERE ma.CustomerID = e2.CustomerID AND Amount = s.EndBal)) + ' dupe amount'
	ELSE NULL 
    END AS Response,
-- E Confirm Trans
@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType,
bt.SSN,bt.DLNumber,bt.DLState,bt.BirthDate,s.StatementID
FROM Payments p, Statements s, MasterAccounts ma, BankTrans bt, PayPeriods pp, ExternalTrans et2, Groups g
WHERE s.StatementID = ma.LastStatementID
	AND ma.GroupID = g.GroupID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND ma.PayPeriodID = pp.PayPeriodID
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND s.EndBal >= 1
	AND ma.Balance + ma.PendingDebit - ma.PendingCredit >= 1	-- If Pending Credit, don't hit card!
-- S Confirm Trans
	AND ma.CustomerID *= et2.CustomerID
	AND s.EndBal *= et2.Amount
	AND et2.ReqDate > DATEADD(dd,-(@confirmdays),getdate())
	AND et2.TransType NOT IN (9,109,8,108)
	AND ma.CustomerID *=  p.CustomerID
	AND s.EndBal *= p.Amount
	AND p.CreateDate > DATEADD(dd,-(@confirmdays),getdate())
-- E Confirm Trans
	AND s.StatementID NOT IN (Select StatementID From ExternalTrans Where TransType in (0, 2, 4, 100, 102, 104) and StatementID IS NOT NULL)
UNION ALL
SELECT ma.CustomerID,NULL AS InvoiceID,100 AS TransType,getdate() AS ReqDate,NULL AS ProcDate,et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType,
bt.SSN,bt.DLNumber,bt.DLState,bt.BirthDate,et.StatementID
FROM ExternalTrans et, MasterAccounts ma, BankTrans bt
WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND et.TransType = 107
	AND et.ReqDate < @transtime
UPDATE ExternalTrans SET TransType = 108 WHERE TransType = 107 AND ReqDate < @transtime
UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
END
GO

GRANT EXECUTE ON ExternalTransImport TO Emerald
GO


IF object_id('History') IS NOT NULL
	DROP PROCEDURE History
GO

CREATE PROCEDURE dbo.History @CustomerID int AS

DECLARE @sd datetime
select @sd = DateAdd(mm, 0-(Select ISNULL( (Select Value From Configs Where ConfigID = 303), 24)), GetDate())

Select i.CreateDate, 'Invoice' as Type, Amount,  
	CASE WHEN i.InvoiceTypeID = 0 THEN 'VOID ' + convert(varchar, LastModifyDate) ELSE it.InvoiceType END as Description,
	 InvoiceID as ID, 'invoice_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&InvoiceID=' + convert(varchar, InvoiceID) as URL
From Invoices i, InvoiceTypes it
Where CustomerID = @CustomerID
	and i.InvoiceTypeID = it.InvoiceTypeID
	and i.CreateDate > @sd
UNION ALL
Select s.StatementDate as CreateDate, 'Statement' as Type, EndBal as Amount,  
	'' as Description, StatementID as ID, 'statement_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&StatementID=' + convert(varchar, StatementID) as URL
From Statements s
Where CustomerID = @CustomerID
	and s.StatementDate > @sd
UNION ALL
Select i.CreateDate, 'Incident', 0, Convert(varchar(128),i.Description), IncidentID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
	and i.CreateDate > @sd
UNION ALL
Select a.CreateDate, 'Action', 0, Convert(varchar(128),a.Description), ActionID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Actions a, Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
		And a.IncidentID = i.IncidentID
	and a.CreateDate > @sd
UNION  ALL
Select LastModifyDate, 'Adjustment', Quantity * Amount AS Amount, COALESCE(Login,'') + ' '
+ Description as Description, ChargeID,
        CASE WHEN ItemID IS NOT NULL THEN 'none' ELSE
'mbr_adjustment_edit.ews?CustomerID=' + convert(varchar, @CustomerID) +
'&ChargeID=' + convert(varchar, ChargeID)END  as URL
        From Charges
        Where CustomerID = @CustomerID
                AND ItemID IS NULL
        and LastModifyDate > @sd
UNION ALL
Select p.CreateDate, 'Payment', p.Amount, Description =
         CASE
           WHEN PaymentType='Check' OR PaymentType='Money Order'
             THEN PaymentType + '# ' + CheckNumber + '  ' + PayInfo
           ELSE PaymentType + '  ' + PayInfo
         END, PaymentID,
CASE WHEN StatementID IS NOT NULL OR EXISTS (SELECT * FROM ExternalTrans et WHERE et.PaymentID = p.PaymentID) THEN 
	'javascript:newwin2("print.ews?printdoc=receipt%2Erpt&formula=%7BPayments.PaymentID%7D%3D' + convert(varchar(8), PaymentID) + '&format=2&PaymentID=' + CONVERT(VARCHAR,PaymentID) + '",screen.width*.9, w=screen.height*.8)'
ELSE
'mbr_payment_edit.ews?CustomerID=' + convert(varchar, @CustomerID) +
'&PaymentID=' + convert(varchar, PaymentID)END  as URL
	From Payments p, PaymentTypes pt
	Where p.PaymentTypeID = pt.PaymentTypeID
		AND CustomerID = @CustomerID
	and p.CreateDate > @sd
UNION ALL

Select ReqDate as CreateDate, 'ETrans', Amount, 
	CASE TransType 
			WHEN 0 THEN 'CC Awaiting Export' 
			WHEN 1 THEN 'CC Awaiting Validation'
			WHEN 2 THEN 'CC Awaiting Results'
			WHEN 7 THEN 'CC Awaiting Rebatch'
			WHEN 8 THEN 'CC Rebatched'
			WHEN 9 THEN 'CC Voided'
			WHEN 100 THEN 'ACH Awaiting Export' 
			WHEN 101 THEN 'ACH Awaiting Validation'
			WHEN 102 THEN 'ACH Awaiting Results'
			WHEN 107 THEN 'ACH Awaiting Rebatch'
			WHEN 108 THEN 'ACH Rebatched'
			WHEN 109 THEN 'ACH Voided'
			ELSE Response END AS Response, ExternalTransID, 

	CASE WHEN TransType IN (0, 2, 100, 102) THEN 
	'Javascript:ask("Void this Etrans?","mbr_etrans_void.ews?CustomerID=' 
		+ convert(varchar, @CustomerID) + 
	'&ExternalTransID=' 
		+ convert(varchar, ExternalTransID) + '")' 

		ELSE 'none' END  as URL
	From ExternalTrans
	Where CustomerID = @CustomerID
		and ReqDate > @sd
Order by CreateDate DESC
GO
GRANT EXECUTE ON History TO Emerald
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'statement.rpt')
	INSERT INTO Reports(Report, FileName,Parameters,ReportType) VALUES('Statement Report','statement.rpt',1,0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'invoice.rpt')
	INSERT INTO Reports(Report, FileName,Parameters,ReportType) VALUES('Invoice Report','invoice.rpt',1,0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'receipt.rpt')
	INSERT INTO Reports(Report, FileName,Parameters,ReportType) VALUES('Receipt Report','receipt.rpt',1,0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'account.rpt')
	INSERT INTO Reports(Report, FileName,Parameters,ReportType) VALUES('Account Report','account.rpt',1,0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'history.rpt')
	INSERT INTO Reports(Report, FileName,Parameters,ReportType) VALUES('History Report','history.rpt',1,0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'region_summary.rpt')
	INSERT INTO Reports(Report, FileName) VALUES('Region Summary','region_summary.rpt')
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'service_summary.rpt')
	INSERT INTO Reports(Report, FileName) VALUES('Service Type Summary','service_summary.rpt')
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'commission.rpt')
	INSERT INTO Reports(Report, FileName) VALUES('Commission Monthly','commission.rpt')
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'errors_daily.rpt')
	INSERT INTO Reports(Report, FileName) VALUES('Daily Error Summary','errors_daily.rpt')
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'commission2.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('Commission Simple','commission2.rpt', 1)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'call_proxy.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('Proxy RADIUS Calls','call_proxy.rpt', 1)
GO

UPDATE Reports SET Parameters = 0 WHERE FileName = 'expiredauth.rpt' AND Parameters = 1
GO

UPDATE Reports SET FileName = 'expiredauth.rpt' WHERE FileName = 'ExpiredAuth.rpt'
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'expiredauth.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('Expired Accounts w/Auth Attempts','expiredauth.rpt', 0)
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'payments_parm.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('Payments Report (definable dates)','payments_parm.rpt', 1)
GO

UPDATE Reports SET Parameters = 0 WHERE FileName = 'newusers_monthly.rpt' AND Parameters = 1
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'newusers_monthly.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('New Users Last Month by Group','newusers_monthly.rpt', 0)
GO

UPDATE Reports SET Parameters = 0 WHERE FileName = 'users_monthly.rpt' AND Parameters = 1
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'users_monthly.rpt')
	INSERT INTO Reports(Report, FileName, Parameters) VALUES('Users By Group/Service Type','users_monthly.rpt', 0)
GO

IF object_id('BatchStatements') IS NOT NULL
	DROP PROCEDURE BatchStatements
GO

CREATE PROCEDURE dbo.BatchStatements (@custid int = NULL, @groupid int = NULL, @operatorgroupid INT = NULL) AS
SET NOCOUNT ON
DECLARE @newinterval INT
SELECT @newinterval = Value FROM Configs WHERE ConfigID = 505
SELECT @newinterval = COALESCE(@newinterval,0)

CREATE TABLE #t_ma (CustomerID INT)
CREATE TABLE #t_i (CustomerID INT, Amount NUMERIC(18,4), LastInvoiceID INT)
CREATE TABLE #t_p (CustomerID INT, Amount NUMERIC(18,4), LastPaymentID INT)

IF @custid IS NULL
BEGIN
	INSERT INTO #t_ma (CustomerID)
	Select DISTINCT CustomerID
	From Invoices i
	Where StatementID IS NULL 
		AND InvoiceTypeID IN (1,2,3)
	UNION
	SELECT DISTINCT ma.CustomerID
	FROM MasterAccounts ma, Invoices i
		WHERE ma.LastStatementID IS NULL
		AND ma.CustomerID = i.CustomerID
		AND i.InvoiceTypeID = 5
	UNION
	Select DISTINCT CustomerID
	From Payments p
	Where StatementID IS NULL 
		AND Amount > 0 
		AND NOT EXISTS (SELECT * FROM Statements s WHERE p.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,getdate()))
	UNION
	Select DISTINCT CustomerID
	From MasterAccounts ma
		WHERE Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,getdate()))
	UNION
	Select DISTINCT CustomerID
	From MasterAccounts ma
		WHERE Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.StatementID IS NULL AND i.InvoiceTypeID <> 0 AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,getdate()))
	
	DELETE FROM #t_ma
	FROM ExternalTrans et, #t_ma t
		WHERE et.CustomerID = t.CustomerID
		AND et.TransType IN (0,2,100,102)
	
	DELETE FROM #t_ma
	FROM #t_ma t, MasterAccounts ma, BillingCycles bc, SubAccounts sa
		WHERE t.CustomerID = ma.CustomerID
		AND ma.BillingCycleID = bc.BillingCycleID
		AND ma.CustomerID = sa.CustomerID
		AND sa.Active = 1
		AND NOT EXISTS (SELECT * FROM Invoices i WHERE i.CustomerID = t.CustomerID AND i.StatementID IS NULL AND i.InvoiceTypeID <> 0)
		AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PayMethodID IN (2,3) THEN bc.EBillDays ELSE bc.IBillDays END + 15, getdate())
		AND EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(dd,-36,getdate()))

	DELETE FROM #t_ma
	FROM #t_ma t, Statements s, MasterAccounts ma
		WHERE t.CustomerID = ma.CustomerID
		AND ma.LastStatementID = s.StatementID
		AND s.StatementDate > DATEADD(dd,-(@newinterval),getdate())

	IF (@operatorgroupid IS NOT NULL AND NOT EXISTS (SELECT * FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @operatorgroupid AND GroupID = 1))
		DELETE FROM #t_ma
		FROM #t_ma t, MasterAccounts ma
			WHERE t.CustomerID = ma.CustomerID
			AND ma.GroupID NOT IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = @operatorgroupid)

	INSERT INTO #t_i (CustomerID,Amount,LastInvoiceID)
	SELECT i.CustomerID, SUM(i.Amount) AS Amount, MAX(i.InvoiceID) AS LastInvoiceID
	FROM #t_ma t, Invoices i
	WHERE t.CustomerID = i.CustomerID
		AND i.StatementID IS NULL
		AND i.InvoiceTypeID <> 0
	GROUP BY i.CustomerID
	
	INSERT INTO #t_p (CustomerID,Amount,LastPaymentID)
	SELECT p.CustomerID, SUM(p.Amount) AS Amount, MAX(p.PaymentID) AS LastPaymentID
	FROM #t_ma t, Payments p
	WHERE t.CustomerID = p.CustomerID
		AND p.StatementID IS NULL
		AND p.PaymentTypeID <> 0
	GROUP BY p.CustomerID
END ELSE BEGIN
INSERT INTO #t_ma (CustomerID) VALUES(@custid)

DELETE FROM #t_ma
FROM ExternalTrans et, #t_ma t
	WHERE et.CustomerID = t.CustomerID
	AND et.TransType IN (0,2,100,102)

INSERT INTO #t_i (CustomerID,Amount,LastInvoiceID)
SELECT i.CustomerID, SUM(i.Amount) AS Amount, MAX(i.InvoiceID) AS LastInvoiceID
FROM Invoices i
	WHERE i.CustomerID = @custid
	AND i.StatementID IS NULL
	AND i.InvoiceTypeID <> 0
GROUP BY i.CustomerID

INSERT INTO #t_p (CustomerID,Amount,LastPaymentID)
SELECT p.CustomerID, SUM(p.Amount) AS Amount, MAX(p.PaymentID) AS LastPaymentID
FROM Payments p
	WHERE p.CustomerID = @custid
	AND p.StatementID IS NULL
	AND p.PaymentTypeID <> 0
GROUP BY p.CustomerID
END

SELECT ma.CustomerID, ma.Balance, i.Amount AS NewCharges, i.LastInvoiceID, p.Amount AS NewCredits, p.LastPaymentID,
sm.Amount AS SM_Amount, sm.AmountType AS SM_AmountType, ma.FirstName + ' ' + ma.LastName as FullName, ma.Company,
CASE WHEN s.StatementID IS NOT NULL AND s.SentDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge
FROM MasterAccounts ma, SendMethods sm, #t_ma t, #t_i i, #t_p p, Statements s
	WHERE ma.CustomerID = t.CustomerID
	AND ma.SendMethodID *= sm.SendMethodID
	AND ma.CustomerID *= i.CustomerID
	AND ma.CustomerID *= p.CustomerID
	AND ma.LastStatementID *= s.StatementID
	AND ma.Active <> 0
	AND (@groupid = 0 OR @groupid IS NULL or @groupid = ma.GroupID)

DROP TABLE #t_ma
DROP TABLE #t_i
DROP TABLE #t_p
GO

GRANT EXECUTE ON BatchStatements TO Emerald
GO

IF object_id('RateHistoryCharges') IS NOT NULL
	DROP PROCEDURE RateHistoryCharges
GO

CREATE PROCEDURE dbo.RateHistoryCharges AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
Select sa.CustomerID, at1.RateID, sa.AccountID, rh.StartDate, rh.HistoryType, 
	TotalCount, TotalTime, TotalData, 0 as TotalRate, sa.Login, at1.AccountTypeID, at1.AccountType, 
	DateAdd(Day, -1, DateAdd(Month, 1, rh.StartDate)) as EndDate
From SubAccounts sa, RateHistory rh, AccountTypes at1
Where sa.AccountID = rh.AccountID
	and sa.AccountTypeID = at1.AccountTypeID 
	and rh.RateID is NULL 
	and DateAdd(Month, 1, rh.StartDate) < GetDate()
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO

GRANT EXECUTE ON RateHistoryCharges TO Emerald
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 306) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Edition) 
		VALUES('MBR Custom Header (mbr_cust.html)',306,306,8,0,0,NULL,1)

	DELETE FROM ConfigValues WHERE ConfigID = 306
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(306,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(306,1,'Yes')
	END
GO


IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 307) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Edition) 
		VALUES('Service Custom Header (sa_cust.html)',307,307,8,0,0,NULL,1)

	DELETE FROM ConfigValues WHERE ConfigID = 307
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(307,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(307,1,'Yes')
	END
GO

-- Since the Crystal Reports Print Issue is resolved, then 
-- 'Always Close Report Engine' is no longer needed.
-- BJP - 2/5/03

IF (SELECT Count(*) FROM Configs WHERE ConfigID = 40) > 0
	BEGIN
	DELETE FROM ConfigValues WHERE ConfigID = 40
	DELETE FROM Configs Where ConfigID = 40
	END
GO

IF (SELECT Description FROM Configs WHERE ConfigID = 34) <> 'Inactivate MBR w/non-zero Balance'
	BEGIN
	DELETE FROM ConfigValues WHERE ConfigID = 34
	DELETE FROM Configs Where ConfigID = 34
	END

IF (SELECT Count(*) FROM Configs WHERE ConfigID = 34) = 0
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Edition) VALUES('Inactivate MBR w/non-zero Balance',34,34,6,0,0,NULL,0)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(34,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(34,1,'Yes')
	END
GO

IF object_id('CanceledAccounts') IS NOT NULL
	DROP PROCEDURE CanceledAccounts
GO

CREATE PROCEDURE dbo.CanceledAccounts AS
DECLARE @nzb int
SET NOCOUNT ON
Select @nzb=ISNULL((Select Value From Configs Where ConfigID = 34), 0)

Select CustomerID, CancelDate, Balance
INTO #t_ma
From MasterAccounts
Where CancelDate < GetDate()
	and Active <> 0
	and (@nzb=1 or Balance = 0)

if (Select count(*) From #t_ma) <> 0
	BEGIN
	Update MasterAccounts Set Active=0, LastModifyDate=getdate() 
		Where CustomerID IN (Select CustomerID From #t_ma)

	INSERT INTO AuditLogs(LogDate, LogMsgID, LogMsg, Operator, CustomerID, AccountID)
	Select GetDate(), 111, 'CID:' + CONVERT(VARCHAR,CustomerID) + ' Balance: ' + convert(varchar(15), Balance), 'Scheduler', CustomerID, NULL
	From #t_ma
	END

drop table #t_ma
GO
GRANT EXECUTE ON CanceledAccounts TO Emerald
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL CanceledAccounts}') = 0
INSERT INTO Schedules
(Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate)
VALUES('Inactivate Canceled Accounts','query',NULL,1,NULL,1,'{CALL CanceledAccounts}',NULL,0,getdate(),
'admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 00:45:00')
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Description = 'Update Server History') = 0
INSERT INTO Schedules
	(Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,
	Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,
	LastStart,StartDate)
VALUES('Update Server History','query',NULL,0,NULL,1,'{CALL UpdateServerHistory}',NULL,0,getdate(),
	'admin',1800,NULL,NULL,1,NULL,'admin',NULL,
	NULL,'2000-01-01 00:00:00')
GO

Update Schedules Set Parameter = '{CALL UpdateServerHistory}' 
Where Description = 'Update Server History' and Parameter = '{CALL UpdateServerPorts}'
GO

IF (SELECT COUNT(*) FROM LogMsgs WHERE LogMsgID = 110) = 0
	INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(110, 'MBR Cancel', 1)
IF (SELECT COUNT(*) FROM LogMsgs WHERE LogMsgID = 111) = 0
	INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(111, 'MBR Inactivate', 1)
IF (SELECT COUNT(*) FROM LogMsgs WHERE LogMsgID = 112) = 0
	INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(112, 'MBR ReActivate', 1)
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL UpdateServerHistory}' AND TaskName = 'query') = 0
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,
	LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) 
VALUES('Update Server History','query',NULL,0,NULL,1,'{CALL UpdateServerHistory}',NULL,0,
	'2001-04-09 10:56:56.977', 'admin',3600,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 02:40:00')

GO

-- Add Random password generation for Client
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 7) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) 
	VALUES('Random Password Length',7,21,1,5,0,NULL,0,0)
END

GO

IF (SELECT COUNT(*) FROM ConfigValues WHERE ConfigID = 20) <> 3
BEGIN
	UPDATE Configs SET Description = 'Unique Login Checking' WHERE ConfigID = 20

	DELETE FROM ConfigValues WHERE ConfigID = 20
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,1,'Per Domain')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,2,'System-Wide')
END
GO

-- Reversal Invoices
IF ((SELECT COUNT(*) FROM InvoiceTypes WHERE InvoiceTypeID = 7) = 0)
	INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(7, 'VOID Reversal', NULL)
GO

-- Remove meta check for date on the BirthDate column in the BankTrans table.
-- This is done so we can have dates prior to 1/1/1970.
-- BJP - 2/13/2003
IF ((SELECT mc.MetaRuleID FROM MetaColumns mc, MetaTables mt WHERE mc.MetaTableID = mt.MetaTableID AND mt.TableName = 'BankTrans' AND mc.ColumnName = 'BirthDate') <> 0)
	UPDATE MetaColumns SET MetaRuleID = 0 FROM MetaColumns mc, MetaTables mt WHERE mc.MetaTableID = mt.MetaTableID AND mt.TableName = 'BankTrans' AND mc.ColumnName = 'BirthDate'
GO

UPDATE MetaColumns SET MetaRuleID = 6
FROM MetaColumns mc, MetaTables mt 
	WHERE mc.MetaTableID = mt.MetaTableID 
	AND mt.TableName = 'Groups' 
	AND mc.ColumnName = 'EmailAccounts'
	AND mc.MetaRuleID IS NULL
GO

IF object_id('CreditCardExport') IS NOT NULL
	DROP PROCEDURE CreditCardExport
GO

CREATE PROCEDURE dbo.CreditCardExport @transtime DATETIME, @CustomerID INT AS
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @Login VARCHAR(64), @Password VARCHAR(64)

SELECT @Merchant = Data FROM Configs WHERE ConfigID = 75
SELECT @Store = Value FROM Configs WHERE ConfigID = 76
SELECT @Terminal = Value FROM Configs WHERE ConfigID = 77
SELECT @Login = Data FROM Configs WHERE ConfigID = 400
SELECT @Password = Data FROM Configs WHERE ConfigID = 401
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'ccexport'

SELECT 
(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID) AS Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.AccountExpire)) AS expmm,
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.AccountExpire) % 100) AS expyy, 
ma.PhoneHome AS Phone,
SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)) AS FirstName,
SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName),255) AS LastName,
COALESCE(cc.BillToState,ma.State) AS State,
COALESCE(cc.BillToCity,ma.City) AS City,
COALESCE(g.BillCountry,'USA') AS Country,
et.AccountNumber AS CardNumber,
et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, @Merchant AS Merchant, @Store AS Store,
@Terminal AS Terminal, 
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount, 'NA' AS CardType, CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = '' THEN 0 ELSE 1 END AS SecurityCodePresent,
ISNULL(g.ccLogin, @Login) AS Login, ISNULL(g.ccPassword, @Password) AS Password, ma.Company INTO #tmp
FROM ExternalTrans et, MasterAccounts ma, CreditCards cc, Groups g
	WHERE ma.CustomerID = et.CustomerID
	AND ma.GroupID = g.GroupID
	AND et.LastModifyDate <= @transtime
	AND et.TransType = 0
	AND ma.Active = 1
	AND ma.CustomerID *= cc.CustomerID
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
ORDER BY et.AccountNumber

SELECT * FROM #tmp
DROP TABLE #tmp
GO
GRANT EXECUTE ON CreditCardExport TO Emerald
GO


-- ACH Updates
IF object_id('ACHExport') IS NOT NULL
	DROP PROCEDURE ACHExport
GO

CREATE PROCEDURE dbo.ACHExport @transtime DATETIME, @CustomerID INT AS
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @Login VARCHAR(64), @Password VARCHAR(64)
SELECT @Merchant = Data FROM Configs WHERE ConfigID = 85
SELECT @Login = Data FROM Configs WHERE ConfigID = 410
SELECT @Password = Data FROM Configs WHERE ConfigID = 411
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'achexport'

SELECT DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(dd,et.AccountExpire) AS expyy, et.AccountNumber,
et.AuthName AS AccountHolder, et.AuthAddress AS Address, ma.City, ma.State, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, @Merchant AS Merchant,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount, et.BankTransType, et.BankNumber, et.BankName, ma.Company, ISNULL(g.ccLogin, @Login) AS Login, 
ISNULL(g.ccPassword, @Password) AS Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.BirthDate)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.BirthDate)) AS birthdd,
COALESCE(ma.Country,'USA') AS Country, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone INTO #tmp

FROM ExternalTrans et, MasterAccounts ma, Groups g
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND et.LastModifyDate <= @transtime
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
	AND et.TransType = 100
	AND ma.Active = 1

SELECT * FROM #tmp
DROP TABLE #tmp
GO
GRANT EXECUTE ON ACHExport TO Emerald
GO

IF ((SELECT COUNT(*) FROM ConfigValues WHERE ConfigID = 16) = 0)
BEGIN
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(16,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(16,1,'Yes')
END
GO

-- End of Multiple Merchant Processing Update.

-- Add Feature to RadRoam and RadConcurrency Tables

Update MetaTables Set Edition = NULL, Feature=1 Where TableName = 'RadRoamServers'
Update MetaTables Set Edition = NULL, Feature=1 Where TableName = 'RadRoamDomains'
Update MetaTables Set Feature=1 Where TableName = 'RadConcurrency' and Feature IS NULL
GO

Update MetaTables 
Set MetaTableGroupID = 2, Edition = 1, Description = 'GL Codes', SortOrder = 56
Where TableName = 'GLCodes'
    	AND MetaTableGroupID IS NULL

GO

IF object_id('WebCheckOperator') IS NOT NULL
	DROP PROCEDURE WebCheckOperator
GO

CREATE PROCEDURE dbo.WebCheckOperator @user VARCHAR(64)
AS
DECLARE @DateFormatID INT, @DateSeperator CHAR(1)
SELECT @DateFormatID = Value FROM Configs WHERE ConfigID = 390
SELECT @DateSeperator = CONVERT(CHAR(1),Data) FROM Configs WHERE ConfigID = 391

SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,@DateFormatID) AS DateFormatID, COALESCE(op.DateSeperator,@DateSeperator) AS DateSeperator, 0 AS CustomerID, 0 AS AccountID
FROM Operators op, OperatorGroups og
	WHERE op.Operator = @user
	AND op.Active = 1
	AND op.OperatorGroupID *= og.OperatorGroupID
UNION ALL
SELECT og.OperatorGroupID, 0 as OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, -1 as LanguageID, @DateFormatID AS DateFormatID, @DateSeperator AS DateSeperator, sa.CustomerID, sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 AND sa.Active = 1
	AND sa.Login = @user 
	AND sa.Login IS NOT NULL
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ''
	AND sa.RemoteAccess = 1
ORDER BY CustomerID ASC
GO

GRANT EXECUTE ON WebCheckOperator TO Emerald
GO

IF object_id('WebCheckOperatorCookie') IS NOT NULL
	DROP PROCEDURE WebCheckOperatorCookie
GO

CREATE PROCEDURE dbo.WebCheckOperatorCookie @cookie VARCHAR(64) AS
DECLARE @DateFormatID INT, @DateSeperator CHAR(1)
SELECT @DateFormatID = Value FROM Configs WHERE ConfigID = 390
SELECT @DateSeperator = CONVERT(CHAR(1),Data) FROM Configs WHERE ConfigID = 391

SELECT op.OperatorGroupID, op.LanguageID, op.OperatorID, op.Operator, op.Email, og.OperatorGroup, oc.LastUsed, COALESCE(op.DateFormatID,@DateFormatID) AS DateFormatID, COALESCE(op.DateSeperator,@DateSeperator) AS DateSeperator
FROM Operators op, OperatorGroups og, OperatorCookies oc
	WHERE oc.Cookie = @cookie 
	AND op.Operator = oc.Operator
	AND op.Active = 1 
	AND op.OperatorGroupID *= og.OperatorGroupID
GO

GRANT EXECUTE ON WebCheckOperatorCookie TO Emerald
GO

IF NOT EXISTS (SELECT * FROM Exports WHERE ExportID = 33)
BEGIN
INSERT INTO Exports (Description,Separator,ApproveString,DeclineString,ApproveMatch,FormatDefault,ExportType,Lines,QuoteString,HeaderRow,Filter,ExportID,DeclineMatch,SQLString) VALUES('Vital POS-partner 5.2','\t','Settled','Exception',1,NULL,1,1,NULL,0,NULL,33,1,'{CALL CreditCardExport($transtime,$parameter)}')
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,1,'CardHolder',1,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,2,'Amount',1,3,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,3,'CardNumber',1,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,0,'expyy',0,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,0,'expmm',0,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,4,'CreditCardExpire',1,0,0,0,0,33,NULL,'$expyy/$expmm',0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,5,'LastModifyUser',1,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,6,'TransactionType',1,0,0,0,0,33,NULL,'Pending Authorization',0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,0,'startdd',0,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,0,'startyy',0,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,0,'startmm',0,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,7,'DueDate',1,0,0,0,0,33,NULL,'$startmm/$startdd/$startyy',0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,8,'Merchant',1,1,0,0,0,33,NULL,NULL,0)
INSERT INTO ExportColumns (Description,SortOrder,FieldName,Include,Format,Quoted,Align,MinSize,ExportID,Padding,ExportValue,MaxSize) VALUES(NULL,9,'TransID',1,2,0,0,0,33,NULL,NULL,0)
INSERT INTO CCImportColumns (Description,SortOrder,DeclineValue,Quoted,FieldSize,Line,FieldType,Position,ApproveValue,ExportID,ErrorValue) VALUES('Trans ID',9,NULL,0,0,1,1,0,NULL,33,NULL)
INSERT INTO CCImportColumns (Description,SortOrder,DeclineValue,Quoted,FieldSize,Line,FieldType,Position,ApproveValue,ExportID,ErrorValue) VALUES('Approve Code',10,NULL,0,0,1,7,0,NULL,33,NULL)
INSERT INTO CCImportColumns (Description,SortOrder,DeclineValue,Quoted,FieldSize,Line,FieldType,Position,ApproveValue,ExportID,ErrorValue) VALUES('Status',6,NULL,0,0,1,2,0,NULL,33,NULL)
INSERT INTO CCImportColumns (Description,SortOrder,DeclineValue,Quoted,FieldSize,Line,FieldType,Position,ApproveValue,ExportID,ErrorValue) VALUES('Response',0,'Declined $approvecode',0,0,1,8,0,'Authorized $approvecode',33,'Error $approvecode')
END
GO

UPDATE ExportColumns SET FieldName = 'BankTransType' WHERE ExportID = 201 AND FieldName = 'TransType'
GO

