-- Emerald 4.1 to 4.2 Upgrade

/* MetaColumns Update */
Update MetaColumns 
Set MinSize = 0
From MetaColumns mc, MetaTables mt
where mt.TableName = 'Addresses'
and mc.MetaTableID = mt.MetaTableID
and ColumnName='Address1'
GO


if not exists (Select ExportID From Exports Where ExportID = 22)
BEGIN
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) 	VALUES(',',0,NULL,'Web Authorize (IC Verify Emu)','A TIME Y',1,'"',NULL,'{CALL CreditCardExport($transtime,$parameter)}',2,NULL,2,22)

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,22,0,'C1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CardHolder',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardNumber',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'CreditCardExpire',NULL,0,0,22,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Amount',NULL,3,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'Const2',NULL,0,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'Zip',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,9,NULL,1,'Address',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,0,NULL,0,'expyy',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,0,NULL,0,'expmm',NULL,1,0,22,0,NULL)

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'C1',0,9,NULL,1,'C1',22,2)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,2,'Trans ID',0,1,NULL,1,NULL,8,20)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Approve Code',2,7,NULL,2,NULL,22,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Response',0,8,NULL,2,'Authorized $this',22,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Status',0,2,NULL,2,NULL,22,0)
END
go

-- Statement creation parameters
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 36) = 0 
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data)  VALUES('Prorate days on Cancel',36,36,6,0,0,NULL)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(36,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(36,1,'Yes')
END
GO

-- Security Code removal
IF object_id('CreditCardImport') IS NOT NULL
	DROP PROCEDURE CreditCardImport
GO

CREATE PROCEDURE CreditCardImport @TransID INT, @TransType INT, @ApproveCode VARCHAR(12), @Response VARCHAR(50) AS
IF @TransType IN (3,4)
UPDATE CreditCards SET SecurityCode = NULL 
FROM CreditCards cc, ExternalTrans et
	WHERE cc.CustomerID = et.CustomerID
	AND et.ExternalTransID = @TransID
	AND cc.SecurityCode IS NOT NULL

UPDATE ExternalTrans
	SET TransType = @TransType,
	ApproveCode = @ApproveCode,
	Response = @Response,
	AuthSecurityCode = NULL
WHERE ExternalTransID = @TransID
GO
GRANT EXECUTE ON CreditCardImport TO Emerald
GO
