ALTER TABLE Calls REPLACE NASPort DEFAULT '-1'
GO

-- IMail web access and 'MaxSize' vs 'Max Mailbox Size' updates
IF object_id('IMailUsers') IS NOT NULL
	DROP PROCEDURE IMailUsers
GO

CREATE PROCEDURE IMailUsers @esid INT, @username varchar(40), @domain varchar(64) AS
DECLARE @DomainID INT, @AccountID INT
SET NOCOUNT ON

SELECT @DomainID = DomainID FROM Domains WHERE MailDomain = @domain

IF (@username IS NULL) /* List all users in domain */
BEGIN

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'UserDir') AS UserDir,
NULL AS NumTries,
NULL AS AttemptTime,
NULL AS NumTimesSuspended,
NULL AS LastLogin,
NULL AS SuspendUserAccount,
NULL AS ICalEnable,
NULL AS SpellEnable,
NULL AS NoOfSuggestions,
NULL AS Depth,
NULL AS Options,
NULL AS SpellChecking,
NULL AS PreviewSize,
NULL AS ConfirmOnDelete,
NULL AS DisplayCompletedTasks,
NULL AS EntryGranularity,
NULL AS StartTime,
NULL AS EndTime,
NULL AS MaxEventsToDisplay,
NULL AS MaxTasksToDisplay,
NULL AS MaxNotesToDisplay,
NULL AS MaxDailyRecurCount,
NULL AS MaxWeeklyRecurCount,
NULL AS MaxMonthlyRecurCount,
NULL AS MaxYearlyRecurCount,
NULL AS HoursClock,
NULL AS MaxNoOfSearchResultsPerPage,
NULL AS MaxEventTitleLength,
NULL AS MaxTaskTitleLength,
NULL AS StartDay,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Max Mailbox Size') AS MaxSize,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxMessages') AS MaxMessages,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Type') AS Type,
COALESCE((SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Flags'),'128') AS Flags,
NULL AS DefaultView,
NULL AS DefCalName,
NULL AS TimeZone

FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ''
	AND ((sa.Login <> '' AND sa.DomainID = @DomainID) 
		OR (sa.Email LIKE '%_@' + @domain))
	AND at1.AccountTypeID = sa.AccountTypeID
	AND at1.ExternalSystemID = @esid
	AND sa.Active = 1
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

END ELSE BEGIN /* Lookup user */

DECLARE
@UserDir VARCHAR(64), 
@NumTries VARCHAR(64), 
@AttemptTime VARCHAR(64), 
@NumTimesSuspended VARCHAR(64), 
@LastLogin VARCHAR(64), 
@SuspendUserAccount VARCHAR(64), 
@ICalEnable VARCHAR(64), 
@SpellEnable VARCHAR(64), 
@NoOfSuggestions VARCHAR(64), 
@Depth VARCHAR(64), 
@Options VARCHAR(64), 
@SpellChecking VARCHAR(64), 
@PreviewSize VARCHAR(64), 
@ConfirmOnDelete VARCHAR(64), 
@DisplayCompletedTasks VARCHAR(64), 
@EntryGranularity VARCHAR(64), 
@StartTime VARCHAR(64), 
@EndTime VARCHAR(64), 
@MaxEventsToDisplay VARCHAR(64), 
@MaxTasksToDisplay VARCHAR(64), 
@MaxNotesToDisplay VARCHAR(64), 
@MaxDailyRecurCount VARCHAR(64), 
@MaxWeeklyRecurCount VARCHAR(64), 
@MaxMonthlyRecurCount VARCHAR(64), 
@MaxYearlyRecurCount VARCHAR(64), 
@HoursClock VARCHAR(64), 
@MaxNoOfSearchResultsPerPage VARCHAR(64), 
@MaxEventTitleLength VARCHAR(64), 
@MaxTaskTitleLength VARCHAR(64), 
@StartDay VARCHAR(64), 
@MaxSize VARCHAR(64), 
@MaxMessages VARCHAR(64), 
@Flags VARCHAR(64), 
@Type VARCHAR(64), 
@DefaultView VARCHAR(64), 
@DefCalName VARCHAR(64), 
@TimeZone VARCHAR(64)

SELECT sadt.Description, sad.Data INTO #settings
FROM SubAccountData sad, SubAccountDataTypes sadt 
	WHERE sad.DataTypeID = sadt.DataTypeID 
	AND sadt.ExternalSystemType = -2
	AND sad.AccountID = @AccountID
	AND sad.Data IS NOT NULL

CREATE INDEX i_settings_Description ON #settings (Description)

SELECT @UserDir = Data FROM #settings WHERE Description = 'UserDir'
SELECT @NumTries = Data FROM #settings WHERE Description = 'NumTries'
SELECT @AttemptTime = Data FROM #settings WHERE Description = 'AttemptTime'
SELECT @NumTimesSuspended = Data FROM #settings WHERE Description = 'NumTimesSuspended'
SELECT @LastLogin = Data FROM #settings WHERE Description = 'LastLogin'
SELECT @SuspendUserAccount = Data FROM #settings WHERE Description = 'SuspendUserAccount'
SELECT @ICalEnable = Data FROM #settings WHERE Description = 'ICalEnable'
SELECT @SpellEnable = Data FROM #settings WHERE Description = 'SpellEnable'
SELECT @NoOfSuggestions = Data FROM #settings WHERE Description = 'NoOfSuggestions'
SELECT @Depth = Data FROM #settings WHERE Description = 'Depth'
SELECT @Options = Data FROM #settings WHERE Description = 'Options'
SELECT @SpellChecking = Data FROM #settings WHERE Description = 'SpellChecking'
SELECT @PreviewSize = Data FROM #settings WHERE Description = 'PreviewSize'
SELECT @ConfirmOnDelete = Data FROM #settings WHERE Description = 'ConfirmOnDelete'
SELECT @DisplayCompletedTasks = Data FROM #settings WHERE Description = 'DisplayCompletedTasks'
SELECT @EntryGranularity = Data FROM #settings WHERE Description = 'EntryGranularity'
SELECT @StartTime = Data FROM #settings WHERE Description = 'StartTime'
SELECT @EndTime = Data FROM #settings WHERE Description = 'EndTime'
SELECT @MaxEventsToDisplay = Data FROM #settings WHERE Description = 'MaxEventsToDisplay'
SELECT @MaxTasksToDisplay = Data FROM #settings WHERE Description = 'MaxTasksToDisplay'
SELECT @MaxNotesToDisplay = Data FROM #settings WHERE Description = 'MaxNotesToDisplay'
SELECT @MaxDailyRecurCount = Data FROM #settings WHERE Description = 'MaxDailyRecurCount'
SELECT @MaxWeeklyRecurCount = Data FROM #settings WHERE Description = 'MaxWeeklyRecurCount'
SELECT @MaxMonthlyRecurCount = Data FROM #settings WHERE Description = 'MaxMonthlyRecurCount'
SELECT @MaxYearlyRecurCount = Data FROM #settings WHERE Description = 'MaxYearlyRecurCount'
SELECT @HoursClock = Data FROM #settings WHERE Description = 'HoursClock'
SELECT @MaxNoOfSearchResultsPerPage = Data FROM #settings WHERE Description = 'MaxNoOfSearchResultsPerPage'
SELECT @MaxEventTitleLength = Data FROM #settings WHERE Description = 'MaxEventTitleLength'
SELECT @MaxTaskTitleLength = Data FROM #settings WHERE Description = 'MaxTaskTitleLength'
SELECT @StartDay = Data FROM #settings WHERE Description = 'StartDay'
SELECT @MaxSize = Data FROM #settings WHERE Description = 'Max Mailbox Size'
SELECT @MaxMessages = Data FROM #settings WHERE Description = 'MaxMessages'
SELECT @Flags = COALESCE(Data,'128') FROM #settings WHERE Description = 'Flags'
SELECT @Type = Data FROM #settings WHERE Description = 'Type'
SELECT @DefaultView = Data FROM #settings WHERE Description = 'DefaultView'
SELECT @DefCalName = Data FROM #settings WHERE Description = 'DefCalName'
SELECT @TimeZone = Data FROM #settings WHERE Description = 'TimeZone'

SELECT @AccountID = sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email)
		OR (@username + '@' + @domain IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = @esid

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
@UserDir AS UserDir,
@NumTries AS NumTries,
@AttemptTime AS AttemptTime,
@NumTimesSuspended AS NumTimesSuspended,
@LastLogin AS LastLogin,
@SuspendUserAccount AS SuspendUserAccount,
@ICalEnable AS ICalEnable,
@SpellEnable AS SpellEnable,
@NoOfSuggestions AS NoOfSuggestions,
@Depth AS Depth,
@Options AS Options,
@SpellChecking AS SpellChecking,
@PreviewSize AS PreviewSize,
@ConfirmOnDelete AS ConfirmOnDelete,
@DisplayCompletedTasks AS DisplayCompletedTasks,
@EntryGranularity AS EntryGranularity,
@StartTime AS StartTime,
@EndTime AS EndTime,
@MaxEventsToDisplay AS MaxEventsToDisplay,
@MaxTasksToDisplay AS MaxTasksToDisplay,
@MaxNotesToDisplay AS MaxNotesToDisplay,
@MaxDailyRecurCount AS MaxDailyRecurCount,
@MaxWeeklyRecurCount AS MaxWeeklyRecurCount,
@MaxMonthlyRecurCount AS MaxMonthlyRecurCount,
@MaxYearlyRecurCount AS MaxYearlyRecurCount,
@HoursClock AS HoursClock,
@MaxNoOfSearchResultsPerPage AS MaxNoOfSearchResultsPerPage,
@MaxEventTitleLength AS MaxEventTitleLength,
@MaxTaskTitleLength AS MaxTaskTitleLength,
@StartDay AS StartDay,
@MaxSize AS MaxSize,
@MaxMessages AS MaxMessages,
@Flags AS Flags,
@Type AS Type,
@DefaultView AS DefaultView,
@DefCalName AS DefCalName,
@TimeZone AS TimeZone
FROM SubAccounts sa
	WHERE sa.AccountID = @AccountID

DROP TABLE #settings
END
GO
GRANT EXECUTE ON IMailUsers TO Emerald
GO

IF object_id('MetaAddObjectTable') IS NOT NULL
	DROP PROCEDURE MetaAddObjectTable
GO

CREATE PROCEDURE MetaAddObjectTable @objectgroup varchar(32), @table VARCHAR(32), @addcols int AS
DECLARE @mtid int, @ogid int

Select @mtid = ISNULL(MetaTableID,0) 
From MetaTables
Where TableName = @table

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if (@mtid > 0 and @ogid > 0)
BEGIN
	INSERT INTO Objects (ObjectGroupID, Value, ObjectTypeID)
	SELECT @ogid, @mtid, 2 
	WHERE NOT EXISTS (SELECT * FROM Objects WHERE ObjectGroupID = @ogid AND @mtid = Value AND ObjectTypeID = 2)
	
	if @addcols = 1
	BEGIN
		INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
		SELECT @ogid, mc.MetaColumnID, 3 
		FROM MetaColumns mc
			WHERE mc.MetaTableID = @mtid
			AND mc.MetaColumnID NOT IN 
				(SELECT o.Value FROM Objects o 
				WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)

	END
END
ELSE
	RAISERROR 50000, 'Could not find Table or Object'
GO
GRANT EXECUTE ON MetaAddObjectTable TO Emerald
GO

IF object_id('DeleteMasterAccount') IS NOT NULL
	DROP PROCEDURE DeleteMasterAccount
GO

CREATE PROCEDURE DeleteMasterAccount @customerid INT AS
DECLARE @aid int
IF @customerid IS NULL RETURN

CREATE TABLE #summary (Description VARCHAR(100) NOT NULL)

IF ((SELECT COUNT(*) FROM SubAccounts WHERE CustomerID = @customerid) > 0)
	BEGIN
	
	DECLARE s_cursor CURSOR
	FOR Select AccountID From SubAccounts Where CustomerID = @customerid
	
	OPEN s_cursor
	
	FETCH s_cursor INTO @aid
	WHILE (@@sqlstatus <> 2)
		BEGIN
		Exec DeleteSubAccount @aid, 1
	
		FETCH s_cursor INTO @aid
		END
	
	CLOSE s_cursor
	DEALLOCATE CURSOR s_cursor
	
	END

Update MasterAccounts Set LastStatementID = NULL Where CustomerID = @customerid

DELETE FROM Charges WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Charges')

/* DELETE FROM GroupAccess WHERE CustomerID = @customerid */
/* INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from GroupAccess') */

DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoice Items')

DELETE FROM ExternalTrans WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid) OR CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from External Transactions')

DELETE FROM Payments WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Payments')

DELETE FROM BankTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Bank Transactions')

DELETE FROM Invoices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoices')

DELETE FROM MailLogs WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Mail Logs')

DELETE FROM StatementNotes WHERE StatementID IN (Select StatementID From Statements Where CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from StatementNotes')

DELETE FROM Statements 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Statements')

DELETE FROM LateNotices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from LateNotices')

DELETE FROM CreditCards WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from CreditCards')

DELETE FROM BankTrans 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from BankTrans')

DELETE FROM Addresses 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Addresses')

DELETE FROM MasterAccountData 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Custom Data')

DELETE FROM MasterAccounts WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Master Accounts')

INSERT INTO #summary (Description) VALUES('Master Account #' + CONVERT(VARCHAR(15),@customerid) + ' Deleted successfully')

SELECT * FROM #summary
DROP TABLE #summary
GO
GRANT EXECUTE ON DeleteMasterAccount TO Emerald
GO

IF object_id('AddMetaTable') IS NOT NULL
	DROP PROCEDURE AddMetaTable
GO

CREATE PROCEDURE AddMetaTable (@tabname varchar(64)) AS
Declare @t varchar(72), @cname varchar(64), @mcid int

Insert Into MetaTables(TableName,Description, GroupMetaTableID)
Select TableName=Convert(varchar,name), 'N/A' AS Description, NULL
From sysobjects
Where type = 'U'
	and name = @tabname
	AND @tabname NOT IN (SELECT TableName FROM MetaTables)

INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select DISTINCT NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case convert(smallint, convert(bit, sc.status&8)) when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('sysname','nvarchar','varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('sysname','nvarchar','varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	'N/A' AS Description, 
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, NULL as DepGroup, NULL as DepColumn, 	
	CASE WHEN st.name in ('datetime') THEN 7 ELSE NULL END as MetaRuleID, mt.MetaTableID, 
	0 as MinSize, convert(smallint, convert(bit, sc.status&8)) as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.type = st.type
	and so.name = @tabname
	AND CONVERT(VARCHAR,sc.name) NOT IN (SELECT ColumnName FROM MetaColumns WHERE MetaTableID = mt.MetaTableID)

Update MetaColumns
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = tableid
	and fc.id = tableid
	and fc.colid = fokey1

	and rt.id = reftabid
	and rc.id = reftabid
	and rc.colid = refkey1

	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID

	and ft.name = @tabname
	AND mc.DepTable IS NULL
	AND mc.DepColumn IS NULL

Update MetaColumns Set Required=0
From syscolumns sc, sysobjects so, MetaColumns mc, MetaTables mt
Where so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and so.id = sc.id
	and so.type = 'U'
	and sc.cdefault > 0
	and mt.TableName = @tabname

Update MetaColumns Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
	and mt.TableName = @tabname

EXEC TabName2Description @tabname, @t OUTPUT
Update MetaTables Set Description = @t Where TableName = @tabname AND Description = 'N/A'

DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = @tabname

OPEN clist
FETCH clist INTO @mcid, @cname
WHILE(@@sqlstatus <> 2)
	BEGIN
	EXEC TabName2Description @cname, @t OUTPUT

	Update MetaColumns Set Description = @t Where MetaColumnID = @mcid AND Description = 'N/A'

	FETCH clist INTO @mcid, @cname
	END

close clist
DEALLOCATE CURSOR clist
GO
GRANT EXECUTE ON AddMetaTable TO Emerald
GO

IF object_id('MetaAddObjectFile') IS NOT NULL
	DROP PROCEDURE MetaAddObjectFile
GO

CREATE PROCEDURE MetaAddObjectFile @ObjectGroup VARCHAR(32), @filename VARCHAR(128) AS
DECLARE @ObjectGroupID INT
SELECT @ObjectGroupID = ObjectGroupID FROM ObjectGroups WHERE ObjectGroup = @ObjectGroup

IF @ObjectGroupID IS NOT NULL
BEGIN
	IF (SELECT COUNT(*) FROM Objects WHERE ObjectGroupID = @ObjectGroupID AND Data = @filename AND ObjectTypeID = 1) = 0
		INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,@ObjectGroupID,@filename)
END ELSE BEGIN
	RAISERROR 50000, 'Could not find Object Group'
END
GO
GRANT EXECUTE ON MetaAddObjectFile TO Emerald
GO

-- Update MetaAddObjectColumn Proc.
IF object_id('MetaAddObjectColumn') IS NOT NULL
	DROP PROCEDURE MetaAddObjectColumn
GO

CREATE PROCEDURE dbo.MetaAddObjectColumn @objectgroup varchar(32), @table VARCHAR(32), @column varchar(32) AS
DECLARE @mtid INT, @ogid INT, @colid INT

Select @mtid = ISNULL(mt.MetaTableID,0), @colid = ISNULL(mc.MetaColumnID,0)
FROM MetaTables mt, MetaColumns mc
	WHERE mt.TableName = @table
	AND mt.MetaTableID *= mc.MetaTableID
	AND mc.ColumnName = @column

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if (@mtid > 0 and @ogid > 0 AND @colid > 0)
	BEGIN
	INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
	SELECT @ogid, mc.MetaColumnID, 3 
	FROM MetaColumns mc
		WHERE mc.MetaTableID = @mtid
		AND mc.MetaColumnID = @colid
		AND mc.MetaColumnID NOT IN 
			(SELECT o.Value FROM Objects o 
			WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)
	END ELSE
	BEGIN
	RAISERROR 50000, 'Object Group/Table/Column not found'
	END
GO

GRANT EXECUTE ON MetaAddObjectColumn TO Emerald
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Reports' AND sc.name = 'ReportType') = 0)
	ALTER TABLE Reports ADD ReportType INT DEFAULT 1 NULL
GO

EXEC AddMetaTable 'Reports'
GO

