-- Emerald 4.0 to 4.1 Upgrade
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Exports' AND sc.name = 'FormatDefault') = 0)
	ALTER TABLE Exports ADD FormatDefault INT NULL
GO

-- EFT - SSN
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'ExternalTrans' AND sc.name = 'SSN') = 0)
	ALTER TABLE ExternalTrans ADD SSN VARCHAR(32) NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'BankTrans' AND sc.name = 'SSN') = 0)
	ALTER TABLE BankTrans ADD SSN VARCHAR(32) NULL
GO

-- EFT - DLNumber
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'ExternalTrans' AND sc.name = 'DLNumber') = 0)
	ALTER TABLE ExternalTrans ADD DLNumber VARCHAR(32) NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'BankTrans' AND sc.name = 'DLNumber') = 0)
	ALTER TABLE BankTrans ADD DLNumber VARCHAR(32) NULL
GO

-- EFT - DLState
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'ExternalTrans' AND sc.name = 'DLState') = 0)
	ALTER TABLE ExternalTrans ADD DLState VARCHAR(40) NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'BankTrans' AND sc.name = 'DLState') = 0)
	ALTER TABLE BankTrans ADD DLState VARCHAR(40) NULL
GO

-- EFT - BirthDate
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'ExternalTrans' AND sc.name = 'BirthDate') = 0)
	ALTER TABLE ExternalTrans ADD BirthDate DATETIME NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'BankTrans' AND sc.name = 'BirthDate') = 0)
	ALTER TABLE BankTrans ADD BirthDate DATETIME NULL
GO

-- Operators
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Operators' AND sc.name = 'DateFormatID') = 0)
	Alter Table Operators ADD DateFormatID INT NULL
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Operators' AND sc.name = 'DateSeperator') = 0)
	Alter Table Operators ADD DateSeperator CHAR(1) NULL
GO

-- ExternalTrans
IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'ExternalTrans' AND sc.name = 'StatementID') = 0)
	ALTER TABLE ExternalTrans ADD StatementID int NULL
GO

-- Meta Updates
EXEC AddMetaTable 'Operators'
EXEC AddMetaTable 'BankTrans'

UPDATE MetaColumns SET Required = 0, Nullable = 1
FROM MetaColumns mc, MetaTables mt
	WHERE mt.MetaTableID = mc.MetaTableID
	AND mt.TableName = 'Operators'
	AND mc.ColumnName IN ('DateFormatID','DateSeperator')
	AND (mc.Required = 1 OR mc.Nullable = 0)
GO

UPDATE Exports SET FormatDefault = 1 WHERE FormatDefault = NULL
GO

-- External trans import should exclude negative balances, ACH additions, new StatementID in the table
IF object_id('ExternalTransImport') IS NOT NULL
	DROP PROCEDURE ExternalTransImport
GO

CREATE PROCEDURE dbo.ExternalTransImport @PayMethodID INT, @transtime DATETIME AS
DECLARE @maxstatid INT
IF @PayMethodID = 2
BEGIN
SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.StatementID = ma.LastStatementID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1

INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry,StatementID)
SELECT ma.CustomerID,NULL AS InvoiceID,0 AS TransType,getdate() AS ReqDate,NULL AS ProcDate, s.EndBal AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, s.StatementID
FROM Statements s, MasterAccounts ma, CreditCards cc
WHERE s.StatementID = ma.LastStatementID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND s.EndBal >= 1
	AND s.StatementID NOT IN (Select StatementID From ExternalTrans Where TransType in (0, 2, 4, 100, 102, 104) and StatementID IS NOT NULL)

UNION ALL

SELECT ma.CustomerID, NULL AS InvoiceID, 0 AS TransType,getdate() AS ReqDate, NULL AS ProcDate, et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, et.StatementID
FROM ExternalTrans et, MasterAccounts ma, CreditCards cc
	WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND et.TransType = 7
	AND et.ReqDate < @transtime

UPDATE ExternalTrans SET TransType = 8 WHERE TransType = 7 AND ReqDate < @transtime

UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
END
ELSE IF @PayMethodID = 3
BEGIN
SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1
INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry,BankName,BankNumber,BankTransType,SSN,DLNumber,DLState,BirthDate,StatementID)
SELECT ma.CustomerID,NULL AS InvoiceID,100 AS TransType,getdate() AS ReqDate,NULL AS ProcDate, s.EndBal AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType,
bt.SSN,bt.DLNumber,bt.DLState,bt.BirthDate,s.StatementID
FROM Statements s, MasterAccounts ma, BankTrans bt
WHERE s.StatementID = ma.LastStatementID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND s.EndBal >= 1
	AND s.StatementID NOT IN (Select StatementID From ExternalTrans Where TransType in (0, 2, 4, 100, 102, 104) and StatementID IS NOT NULL)

UNION ALL

SELECT ma.CustomerID,NULL AS InvoiceID,100 AS TransType,getdate() AS ReqDate,NULL AS ProcDate,et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType,
bt.SSN,bt.DLNumber,bt.DLState,bt.BirthDate,et.StatementID
FROM ExternalTrans et, MasterAccounts ma, BankTrans bt
WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND et.TransType = 107
	AND et.ReqDate < @transtime

UPDATE ExternalTrans SET TransType = 108 WHERE TransType = 107 AND ReqDate < @transtime

UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
END
GO

GRANT EXECUTE ON ExternalTransImport TO Emerald
GO

-- ACH Updates
IF object_id('ACHExport') IS NOT NULL
	DROP PROCEDURE ACHExport
GO

CREATE PROCEDURE dbo.ACHExport @transtime DATETIME, @CustomerID INT AS
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @Login VARCHAR(64), @Password VARCHAR(64)
SELECT @Merchant = Data FROM Configs WHERE ConfigID = 85
SELECT @Login = Data FROM Configs WHERE ConfigID = 410
SELECT @Password = Data FROM Configs WHERE ConfigID = 411
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'achexport'

SELECT DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(dd,et.AccountExpire) AS expyy, et.AccountNumber,
et.AuthName AS AccountHolder, et.AuthAddress AS Address, ma.City, ma.State, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, @Merchant AS Merchant,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount, et.BankTransType, et.BankNumber, et.BankName, ma.Company, @Login AS Login, @Password AS Password,
et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.BirthDate)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.BirthDate)) AS birthdd,
COALESCE(ma.Country,'USA') AS Country, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone INTO #tmp

FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND et.LastModifyDate <= @transtime
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
	AND et.TransType = 100

SELECT * FROM #tmp
DROP TABLE #tmp
GO
GRANT EXECUTE ON ACHExport TO Emerald
GO

-- TaskCreditCardUpdate
IF object_id('TaskCreditCardUpdate') IS NOT NULL
	DROP PROCEDURE TaskCreditCardUpdate
GO

CREATE PROCEDURE dbo.TaskCreditCardUpdate @cardtype INT, @transtime DATETIME AS
-- TransTypes
-- 0 needs to be batched out
-- 2 batched out
-- 3 declined
-- 4 good
-- 7 needs to be rebatched
-- 8 was rebatched
-- 9 trans void

IF (@cardtype = 1)
	UPDATE ExternalTrans SET TransType = 2
		WHERE LastModifyDate <= @transtime
		AND TransType = 0

IF (@cardtype = 2)
	UPDATE ExternalTrans SET TransType = 102
		WHERE LastModifyDate <= @transtime
		AND TransType = 100
GO

GRANT EXECUTE ON TaskCreditCardUpdate TO Emerald
GO

IF object_id('CreditCardGetTrans') IS NOT NULL
	DROP PROCEDURE CreditCardGetTrans
GO

CREATE PROCEDURE dbo.CreditCardGetTrans @CustomerID INT AS
DECLARE @batchinterval INT, @batchtries INT, @transtime DATETIME, @ExportID INT, @SendReceipt INT
SELECT @batchinterval = Value FROM Configs WHERE ConfigID = 94
SELECT @batchtries = Value FROM Configs WHERE ConfigID = 93
SELECT @ExportID = Value FROM Configs WHERE ConfigID = 74
SELECT @SendReceipt = Value FROM Configs WHERE ConfigID = 14
SELECT @transtime = DATEADD(mi,-1,getdate())
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'ccexport'

EXEC ExternalTransImport 2, @transtime

IF @ExportID <> 30
UPDATE ExternalTrans SET TransType = 0, LastRebatchTry = getdate(), RebatchTries = RebatchTries + 1
	WHERE LastModifyDate <= @transtime
	AND TransType = 3
	AND DATEADD(dd,@batchinterval,LastRebatchTry) <= @transtime
	AND RebatchTries < @batchtries
	AND (@CustomerID IS NULL OR CustomerID = @CustomerID)

SELECT et.ExternalTransID AS TransID, NULL AS InvoiceID, et.Amount, et.TransType, et.CustomerID, @SendReceipt AS SendReceipt
FROM ExternalTrans et
	WHERE et.TransType IN(0,2)
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
GO
GRANT EXECUTE ON CreditCardGetTrans TO Emerald
GO

IF object_id('ACHGetTrans') IS NOT NULL
	DROP PROCEDURE ACHGetTrans
GO

CREATE PROCEDURE dbo.ACHGetTrans @CustomerID INT AS
DECLARE @batchinterval INT, @batchtries INT, @transtime DATETIME, @SendReceipt INT
SELECT @batchinterval = Value FROM Configs WHERE ConfigID = 94
SELECT @batchtries = Value FROM Configs WHERE ConfigID = 93
SELECT @SendReceipt = Value FROM Configs WHERE ConfigID = 14
SELECT @transtime = DATEADD(mi,-1,getdate())
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'achexport'

EXEC ExternalTransImport 3, @transtime

UPDATE ExternalTrans SET TransType = 100, LastRebatchTry = getdate(), RebatchTries = RebatchTries + 1
	WHERE LastModifyDate <= @transtime
	AND TransType = 103
	AND (@CustomerID IS NULL OR CustomerID = @CustomerID)
	AND DATEADD(dd,@batchinterval,LastRebatchTry) <= @transtime
	AND RebatchTries < @batchtries

SELECT et.ExternalTransID AS TransID, NULL AS InvoiceID, et.Amount, et.TransType, et.CustomerID, @SendReceipt AS SendReceipt
FROM ExternalTrans et
	WHERE et.TransType IN(100,102)
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
GO
GRANT EXECUTE ON ACHGetTrans TO Emerald
GO

IF object_id('CreditCardExport') IS NOT NULL
	DROP PROCEDURE CreditCardExport
GO

CREATE PROCEDURE dbo.CreditCardExport @transtime DATETIME, @CustomerID INT AS
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @Login VARCHAR(64), @Password VARCHAR(64)

SELECT @Merchant = Data FROM Configs WHERE ConfigID = 75
SELECT @Store = Value FROM Configs WHERE ConfigID = 76
SELECT @Terminal = Value FROM Configs WHERE ConfigID = 77
SELECT @Login = Data FROM Configs WHERE ConfigID = 400
SELECT @Password = Data FROM Configs WHERE ConfigID = 401
UPDATE ScheduleTasks SET TaskName = TaskName WHERE TaskName = 'ccexport'

SELECT
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.AccountExpire)) AS expmm, 
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.AccountExpire) % 100) AS expyy, 
et.AccountNumber AS CardNumber,
et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, @Merchant AS Merchant, @Store AS Store,
@Terminal AS Terminal, 
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount, 'NA' AS CardType, CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = '' THEN 0 ELSE 1 END AS SecurityCodePresent,
@Login AS Login, @Password AS Password, ma.Company INTO #tmp

FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND et.LastModifyDate <= @transtime
	AND et.TransType = 0
	AND (@CustomerID IS NULL OR et.CustomerID = @CustomerID)
ORDER BY et.AccountNumber

SELECT * FROM #tmp
DROP TABLE #tmp
GO
GRANT EXECUTE ON CreditCardExport TO Emerald
GO

IF object_id('TaskCreditCard') IS NOT NULL
	DROP PROCEDURE TaskCreditCard
GO

CREATE PROCEDURE dbo.TaskCreditCard AS
DECLARE @BatchOut VARCHAR(100), @BatchIn VARCHAR(100), @ExportID INT, @BatchLimit INT, @ExportMode INT, @ImportMode INT, @Format INT, @ProcAddress VARCHAR(255)
SELECT @BatchOut = Data FROM Configs WHERE ConfigID = 70
SELECT @BatchIn = Data FROM Configs WHERE ConfigID = 71
SELECT @ExportID = Value FROM Configs WHERE ConfigID = 74
SELECT @BatchLimit = Value FROM Configs WHERE ConfigID = 72
SELECT @ExportMode = Value FROM Configs WHERE ConfigID = 90
SELECT @ImportMode = Value FROM Configs WHERE ConfigID = 92
SELECT @Format = FormatDefault FROM Exports WHERE ExportID = @ExportID
SELECT @ProcAddress = Data FROM Configs WHERE ConfigID = 79

SELECT @BatchOut AS BatchOut, @BatchIn AS BatchIn, @ExportID AS ExportID, @BatchLimit AS BatchLimit, @ExportMode AS ExportMode, @ImportMode AS ImportMode, @Format AS Format, @ProcAddress AS ProcAddress
GO
GRANT EXECUTE ON TaskCreditCard TO Emerald
GO

IF object_id('TaskACH') IS NOT NULL
	DROP PROCEDURE TaskACH
GO

CREATE PROCEDURE dbo.TaskACH AS
DECLARE @BatchOut VARCHAR(100), @BatchIn VARCHAR(100), @ExportID INT, @BatchLimit INT, @ExportMode INT, @ImportMode INT, @Format INT, @ProcAddress VARCHAR(64)
SELECT @BatchOut = Data FROM Configs WHERE ConfigID = 80
SELECT @BatchIn = Data FROM Configs WHERE ConfigID = 81
SELECT @ExportID = Value FROM Configs WHERE ConfigID = 84
SELECT @BatchLimit = Value FROM Configs WHERE ConfigID = 82
SELECT @ExportMode = Value FROM Configs WHERE ConfigID = 98
SELECT @ImportMode = Value FROM Configs WHERE ConfigID = 97
SELECT @Format = FormatDefault FROM Exports WHERE ExportID = @ExportID
SELECT @ProcAddress = Data FROM Configs WHERE ConfigID = 99

SELECT @BatchOut AS BatchOut, @BatchIn AS BatchIn, @ExportID AS ExportID, @BatchLimit AS BatchLimit, @ExportMode AS ExportMode, @ImportMode AS ImportMode, @Format AS Format, @ProcAddress AS ProcAddress
GO
GRANT EXECUTE ON TaskACH TO Emerald
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 79) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Processor Address',79,79,9,0,1,'localhost:port')
GO

-- Add Shift4, Concord and Authorize.Net realtime CC support
DELETE FROM CCImportColumns WHERE ExportID IN (30,31,32,203,204,37)
DELETE FROM ExportColumns WHERE ExportID IN (30,31,32,203,204,37)
DELETE FROM Exports WHERE ExportID IN (30,31,32,203,204,37)
GO

INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,ApproveString,Description,ExportType,QuoteString,Filter,SQLString,ApproveMatch,Lines,DeclineString,FormatDefault,ExportID) VALUES(NULL,0,1,'A','Shift4',5,NULL,NULL,'{CALL CreditCardExport($transtime,$parameter)}',1,1,'D R',5,30)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,FormatDefault,ExportID) VALUES(NULL,0,NULL,'Concord','APPROVED',5,NULL,'urlencoded','{CALL CreditCardExport($transtime,$parameter)}',1,NULL,1,2,31)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,FormatDefault,ExportID) VALUES(',',0,7,'Authorize.Net','1',5,NULL,NULL,'{CALL CreditCardExport($transtime,$parameter)}',7,'2',1,2,32)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,FormatDefault,ExportID) VALUES(',',0,7,'Authorize.Net (AIM)','1',5,NULL,NULL,'{CALL CreditCardExport($transtime,$parameter)}',7,'2',1,2,37)
GO

UPDATE Exports SET SQLString = '{CALL CreditCardExport($transtime,$parameter)}' WHERE SQLString = '{CALL CreditCardExport($transtime)}'
UPDATE Exports SET SQLString = '{CALL ACHExport($transtime,$parameter)}' WHERE SQLString = '{CALL ACHExport($transtime)}'
GO

-- SHIFT4
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,11,'THB - API Signature',1,'Const1',NULL,0,0,2,'$0',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,12,'THB - Function Request',1,'Const2',NULL,0,0,2,'1D',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(12,0,13,'THB - Requester Reference',1,'TransID',NULL,2,0,12,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,14,'THB - Error Indicator',1,'Const3',NULL,0,0,1,'N',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(9,0,15,'THB - Error Pri/Sec Codes',1,'Const4',NULL,0,0,9,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(10,0,16,'THB - Merchant ID',1,'Merchant','0',2,1,10,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(10,0,17,'THB - Tran ID',1,'Const5','0',0,1,10,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(10,0,18,'THB - Invoice',1,'TransID',NULL,1,0,10,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(19,0,19,'THB - Card Number',1,'CardNumber',NULL,1,0,19,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(4,0,100,'VDB - FS & DTI',1,'Const7',NULL,0,0,4,'$FS$Const9',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(35,0,101,'VDB - Vendor',1,'Const8',NULL,0,0,35,'Emerald v4 - Export v$version',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,102,'VDB - DTI 000',0,'Const9',NULL,0,0,0,'000',30)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,200,'STB - DTI 001',0,'Const10',NULL,0,0,0,'001',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(4,0,201,'STB - FS & DTI',1,'Const11',NULL,0,0,4,'$FS$Const10',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,202,'STB - Card Type',1,'CardType',NULL,1,0,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,203,'STB - Card Entry Mode',1,'Const12',NULL,0,0,1,'M',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,204,'STB - Card Present',1,'Const13',NULL,0,0,1,'N',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,205,'STB - expyy',0,'expyy','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,206,'STB - expmm',0,'expmm','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(4,0,207,'STB - Expiration Date',1,'CreditCardExpire',NULL,0,0,4,'$expmm$expyy',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(5,0,208,'STB - Clerk',1,'Const14',NULL,0,0,5,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,209,'STB - startyy',0,'startyy','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,210,'STB - startmm',0,'startmm','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,211,'STB - startdd',0,'startdd','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,212,'STB - starthh',0,'starthh','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,213,'STB - startmi',0,'startmi','0',1,1,2,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(2,0,214,'STB - startss',0,'startss','0',1,1,2,NULL,30)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(6,0,215,'STB - Date',1,'Const15',NULL,0,0,6,'$startmm$startdd$startyy',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(6,0,216,'STB - Time',1,'Const16',NULL,0,0,6,'$starthh$startmi$startss',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,217,'STB - Sale Flag',1,'Const17',NULL,0,0,1,'S',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(14,0,218,'STB - Amount',1,'Amount','0',4,1,14,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(14,0,219,'STB - Secondary Amount',1,'Const18','0',0,1,14,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,220,'STB - Response Code',1,'Const19',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(6,0,221,'STB - Authorization',1,'Const20',NULL,0,0,6,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,222,'STB - AVS Result',1,'Const21',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,223,'STB - AVS Street Verified',1,'Const22',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,224,'STB - AVS Zip Verified',1,'Const23',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(3,0,300,'AVSB - DTI 002',0,'Const24',NULL,0,0,3,'002',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(4,0,301,'AVSB - FS & DTI',1,'Const25',NULL,0,0,4,'$FS$Const24',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(35,0,302,'AVSB - Customer Name',1,'CardHolder',NULL,1,0,35,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(30,0,303,'AVSB - Street Address',1,'Address',NULL,1,0,30,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(9,0,304,'AVSB - Zip Code',1,'Zip',NULL,1,0,9,NULL,30)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(3,0,400,'CVV2B - DTI 022',0,'Const26',NULL,0,0,3,'022',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(4,0,401,'CVV2B - FS & DTI',1,'Const27',NULL,0,0,4,'$FS$Const26',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(1,0,402,'CVV2B - CVV2 Indicator',1,'SecurityCodePresent',NULL,1,0,30,1,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(4,0,403,'CVV2B - Code',1,'SecurityCode',NULL,1,0,30,4,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,404,'CVV2B - Result',1,'Const30',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,405,'CVV2B - Valid',1,'Const31',NULL,0,0,1,NULL,30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,1,'TH - STX',1,'Const0',NULL,0,0,1,'$STX',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,1000,'TH - ETX',1,'Const100',NULL,0,0,1,'$ETX',30)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(1,0,1001,'TH - LRC',1,'Const101',NULL,0,0,1,'A',30)
GO

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,FieldSize,ExportID) VALUES(NULL,0,1,'Trans ID',6,1,NULL,1,NULL,12,30)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,FieldSize,ExportID) VALUES(NULL,0,2,'Status',135,2,NULL,1,NULL,1,30)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,FieldSize,ExportID) VALUES(NULL,0,3,'Approve Code',136,7,NULL,1,NULL,6,30)
GO

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,FieldSize,ExportID) VALUES(NULL,0,4,'Sink (Error Codes)',19,0,NULL,1,NULL,9,30)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,FieldSize,ExportID) VALUES('Declined $status $approvecode $sink',0,5,'Response',0,8,'Error $status $sink',1,'Authorized $approvecode',0,30)
GO

-- Concord
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,'Method',1,'Method',NULL,0,0,31,0,'CreditCardCharge')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'TransID',0,'TransID',NULL,2,0,31,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'TransID',1,'ReferenceNumber',NULL,0,0,31,0,'$TransID')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'Amount',0,'Amount',NULL,3,0,31,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'Amount',1,'TransactionAmount',NULL,0,0,31,0,'$Amount')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'CardNumber',0,'CardNumber',NULL,1,0,31,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'CardNumber',1,'AccountNumber',NULL,0,0,31,0,'$CardNumber')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,'expmm',0,'expmm',NULL,1,0,31,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,'expmm',1,'ExpirationMonth',NULL,0,0,31,0,'$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expyy',0,'expyy',NULL,1,0,31,0,NULL)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expyy',1,'ExpirationYear',NULL,0,0,31,0,'$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'Login',0,'Login',NULL,1,0,31,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'Login',1,'Username',NULL,0,0,31,0,'$Login')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,'Password',1,'Password',NULL,1,0,31,0,NULL)
GO

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,0,'$ReferenceNumber',0,1,NULL,0,NULL,31,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,0,'$ResultMessage',0,2,NULL,0,NULL,31,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,0,'$ApprovalNumber',0,7,NULL,0,NULL,31,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$status  $ResponseCode - $ResultCode',0,0,NULL,0,8,NULL,0,'Authorized $approvecode',31,0)
GO

-- Authorize.Net (CC)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,'Address',0,'Address',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,'Address',1,'x_Address',NULL,0,0,32,0,'$Address')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'Amount',0,'Amount',NULL,3,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'Amount',1,'x_Amount',NULL,0,0,32,0,'$Amount')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'CardNumber',0,'CardNumber',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'CardNumber',1,'x_Card_Num',NULL,0,0,32,0,'$CardNumber')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expmm',0,'expmm',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expyy',0,'expyy',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expmmexpyy',1,'x_Exp_Date',NULL,0,0,32,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'CardHolder',0,'CardHolder',NULL,1,0,32,0,NULL)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'CardHolder',1,'x_Last_Name',NULL,0,0,32,0,'$CardHolder')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,'x_Method',1,'x_Method',NULL,0,0,32,0,'CC')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,'Zip',0,'Zip',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,'Zip',1,'x_Zip',NULL,0,0,32,0,'$Zip')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,'X_ADC_URL',1,'X_ADC_URL',NULL,0,0,32,0,'FALSE')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,11,'X_ADC_Delim_Data',1,'X_ADC_Delim_Data',NULL,0,0,32,0,'TRUE')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,12,'x_Version',1,'x_Version',NULL,0,0,32,0,'3.0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'CustomerID',0,'CustomerID',NULL,2,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'CustomerID',1,'x_cust_id',NULL,0,0,32,0,'$CustomerID')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,'TransID',0,'TransID',NULL,2,0,32,0,NULL)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,'TransID',1,'x_Invoice_Num',NULL,0,0,32,0,'$TransID')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,14,'Login',0,'Login',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,14,'Login',1,'x_Login',NULL,0,0,32,0,'$Login')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,15,'Password',0,'Password',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,15,'Password',1,'x_Password',NULL,0,0,32,0,'$Password')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,16,'SecurityCode',0,'SecurityCode',NULL,1,0,32,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,16,'SecurityCode',1,'x_Card_Code',NULL,0,0,32,0,'$SecurityCode')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,17,'x_relay_response',1,'x_relay_response',NULL,0,0,32,0,'False')
GO

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Trans ID',0,1,NULL,1,NULL,32,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Status',0,2,NULL,1,NULL,32,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,5,'Approve Code',0,7,NULL,1,NULL,32,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $this',0,4,'Response Code',0,8,'Error $this',1,'Authorized $approvecode',32,0)
GO

-- Authorize.Net (EFT)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,FormatDefault,ExportID) VALUES(',',0,7,'Authorize.Net','1',6,NULL,NULL,'{CALL ACHExport($transtime,$parameter)}',7,'2',1,2,203)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,FormatDefault,ExportID) VALUES(',',0,7,'Authorize.Net (AIM)','1',6,NULL,NULL,'{CALL ACHExport($transtime,$parameter)}',7,'2',1,2,204)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,'Address',0,'Address',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,'Address',1,'x_Address',NULL,0,0,203,0,'$Address')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'Amount',0,'Amount',NULL,3,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,'Amount',1,'x_Amount',NULL,0,0,203,0,'$Amount')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'AccountNumber',0,'AccountNumber',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,'AccountNumber',1,'x_Bank_Acct_Num',NULL,0,0,203,0,'$AccountNumber')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expmm',0,'expmm',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expyy',0,'expyy',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,'expmmexpyy',1,'x_Exp_Date',NULL,0,0,203,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'AccountHolder',0,'AccountHolder',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,'AccountHolder',1,'x_Last_Name',NULL,0,0,203,0,'$AccountHolder')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,'x_Method',1,'x_Method',NULL,0,0,203,0,'ECHECK')
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,'Zip',0,'Zip',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,'Zip',1,'x_Zip',NULL,0,0,203,0,'$Zip')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,'X_ADC_URL',1,'X_ADC_URL',NULL,0,0,203,0,'FALSE')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,11,'X_ADC_Delim_Data',1,'X_ADC_Delim_Data',NULL,0,0,203,0,'TRUE')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,12,'x_Version',1,'x_Version',NULL,0,0,203,0,'3.0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'CustomerID',0,'CustomerID',NULL,2,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,'CustomerID',1,'x_cust_id',NULL,0,0,203,0,'$CustomerID')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,'TransID',0,'TransID',NULL,2,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,'TransID',1,'x_Invoice_Num',NULL,0,0,203,0,'$TransID')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,14,'Login',0,'Login',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,14,'Login',1,'x_Login',NULL,0,0,203,0,'$Login')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,15,'Password',0,'Password',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,15,'Password',1,'x_Password',NULL,0,0,203,0,'$Password')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,16,'BankNumber',0,'BankNumber',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,16,'BankNumber',1,'x_Bank_ABA_Code',NULL,0,0,203,0,'$BankNumber')
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,17,'BankName',0,'BankName',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,17,'BankName',1,'x_Bank_Name',NULL,0,0,203,0,'$BankName')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,18,'Company',0,'Company',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,18,'Company',1,'x_Company',NULL,0,0,203,0,'$Company')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,19,'BankTransType',0,'BankTransType',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,19,'BankTransType',1,'x_Bank_Acct_Type',NULL,0,0,203,0,'$BankTransType')
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,20,'Address',0,'Address',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,20,'Address',1,'x_Address',NULL,0,0,203,0,'$Address')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,21,'City',0,'City',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,21,'City',1,'x_City',NULL,0,0,203,0,'$City')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,22,'Country',0,'Country',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,22,'Country',1,'x_Country',NULL,0,0,203,0,'$Country')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,23,'SSN',0,'SSN',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,23,'SSN',1,'x_Customer_Tax_ID',NULL,0,0,203,0,'$SSN')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,24,'x_Customer_Organization_Type',1,'x_Customer_Organization_Type',NULL,0,0,203,0,'I')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,25,'DLNumber',0,'DLNumber',NULL,1,0,203,0,NULL)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,25,'DLNumber',1,'x_Drivers_License_Num',NULL,0,0,203,0,'$DLNumber')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,26,'DLState',0,'DLState',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,26,'DLState',1,'x_Drivers_License_State',NULL,0,0,203,0,'$DLState')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,27,'birthmm',0,'birthmm',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,27,'birthdd',0,'birthdd',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,27,'birthyyyy',0,'birthyyyy',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,27,'x_Drivers_License_DOB',1,'x_Drivers_License_DOB',NULL,0,0,203,0,'$birthyyyy/$birthmm/$birthdd')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,28,'x_First_Name',1,'x_First_Name',NULL,0,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,29,'x_Freight',1,'x_Freight',NULL,0,0,203,0,'0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,30,'State',0,'State',NULL,1,0,203,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,30,'State',1,'x_State',NULL,0,0,203,0,'$State')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,31,'x_Tax',1,'x_Tax',NULL,0,0,203,0,'0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,32,'x_relay_response',1,'x_relay_response',NULL,0,0,203,0,'False')
GO

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Trans ID',0,1,NULL,1,NULL,203,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Status',0,2,NULL,1,NULL,203,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,5,'Approve Code',0,7,NULL,1,NULL,203,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $this',0,4,'Response Code',0,8,'Error $this',1,'Authorized $approvecode',203,0)
GO

EXEC MetaAddObjectFile 'Customer Access','realtime.ews'
EXEC MetaAddObjectFile 'Customer Access','mbr_error.ews'
EXEC MetaAddObjectFile 'Customer Access','cust_creditcard_schedule.ews'
EXEC MetaAddObjectFile 'MBR Acct','cc_schedule.ews'
EXEC MetaAddObjectFile 'MBR Acct','cc_taskwatch.ews'

EXEC MetaAddObjectFile 'MBR Basic','mbr_open_check.ews'
EXEC MetaAddObjectFile 'MBR Basic','mbr_close_check.ews'

EXEC MetaAddObjectFile 'MBR Acct','mbr_open.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_close.ews'

DELETE FROM Objects WHERE Data = 'mbr_close.ews' AND ObjectGroupID = 110 AND ObjectTypeID = 1
DELETE FROM Objects WHERE Data = 'mbr_open.ews' AND ObjectGroupID = 110 AND ObjectTypeID = 1
GO


EXEC MetaAddObjectFile 'MBR Acct','sched_taskwatch_f.ews'
EXEC MetaAddObjectFile 'Client','realtime.ews'
EXEC MetaAddObjectFile 'Client','print_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_failed_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_failed_retry.ews'
EXEC MetaAddObjectFile 'Batch','batch_failed_void.ews'
EXEC MetaAddObjectFile 'Batch','batch_mail_all_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_print_all_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_outstanding_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_outstanding_void.ews'
GO

-- POS Invoices
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_delete.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_detail.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_done.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_edit.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_error.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_inv_add.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_inv_del.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_item_add.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_item_f.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_pos_save.ews'
GO

-- Quick Payments 
EXEC MetaAddObjectFile 'MBR Acct','qpay.ews'
EXEC MetaAddObjectFile 'MBR Acct','qpay_f.ews'
EXEC MetaAddObjectFile 'MBR Acct','qpay_list.ews'
EXEC MetaAddObjectFile 'MBR Acct','qpay_save.ews'
GO

-- Payments
EXEC MetaAddObjectFile 'MBR Acct','mbr_payment_cc.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_payment_eft.ews'
GO

-- Other
EXEC MetaAddObjectFile 'Incidents','action_add_save_f.ews'
EXEC MetaAddObjectFile 'System Logs', 'radlogsport_query.ews'
EXEC MetaAddObjectFile 'System Logs', 'radlogs_query.ews'
GO

EXEC MetaAddObjectTable 'Customer Access', 'Schedules', 0
GO

EXEC MetaAddObjectTable 'Invoices', 'Schedules', 0
GO

-- Missing Columns From Objects
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Country'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'MiddleName'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Province'
GO

EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'StartDate'
GO

EXEC MetaAddObjectColumn 'MBR Acct','BankTrans', 'BirthDate'
EXEC MetaAddObjectColumn 'MBR Acct','BankTrans', 'DLNumber'
EXEC MetaAddObjectColumn 'MBR Acct','BankTrans', 'DLState'
EXEC MetaAddObjectColumn 'MBR Acct','BankTrans', 'SSN'
GO

IF ((SELECT COUNT(*) FROM sysobjects so WHERE so.name = 'Strings2')  = 1)
	DROP TABLE Strings2
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc 
		WHERE so.id = sc.id AND so.name = 'Strings' AND sc.name = 'URL' AND sc.length < 60) = 1)
	BEGIN

-- Resize URL
CREATE TABLE dbo.Strings2 (
       StringID             int NOT NULL,
       LanguageID           int NOT NULL,
       Version              int NOT NULL,
       ApplicationID        int NOT NULL,
       Data                 varchar(255) NULL,
       URL                  varchar(60) NULL
)

INSERT INTO Strings2(StringID,LanguageID,Version,ApplicationID,Data,URL)
SELECT StringID,LanguageID,Version,ApplicationID,Data,URL
FROM Strings

DROP TABLE Strings
EXEC sp_rename 'Strings2','Strings'

CREATE INDEX XIE1Strings ON Strings (Version)

ALTER TABLE Strings
       ADD PRIMARY KEY (StringID, LanguageID, Version, ApplicationID)
END
GO

-- Export format overrides to allow SA template data
IF object_id('TaskES') IS NOT NULL
	DROP PROCEDURE TaskES
GO

CREATE PROCEDURE dbo.TaskES @esid INT AS
SELECT CASE WHEN et.ExternalSystemType >= 1000 THEN et.ExternalSystemType ELSE et.ExportID END AS ExportID, CASE WHEN et.ExternalSystemType >= 1000 AND e.FormatDefault IS NOT NULL THEN e.FormatDefault ELSE et.ExternalSystemType END AS Type, LogFile, et.FileMode, et.Name, et.Login, et.Password
FROM ExternalSystems et, Exports e
	WHERE et.ExternalSystemID = @esid
	AND et.ExternalSystemType *= e.ExportID
GO
GRANT EXECUTE ON TaskES TO Emerald
GO

-- IIS Export
IF ((SELECT COUNT(*) FROM SubAccountDataTypes WHERE ExternalSystemType = 1000) = 0)
BEGIN
	INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Hostname',NULL,1000,0)
	INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Port',NULL,1000,0)
	INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('IP Address',NULL,1000,0)
	INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Description',NULL,1000,0)
END

IF object_id('IISExport') IS NOT NULL
	DROP PROCEDURE IISExport
GO

CREATE PROCEDURE dbo.IISExport @esid INT, @filemode INT AS
DECLARE @incremental INT, @port INT, @ipaddress INT, @hostname INT, @description INT
SELECT @incremental = CASE WHEN @filemode = 1 THEN 1 WHEN @filemode = 2 THEN 0 ELSE 1 END
SELECT @port = DataTypeID FROM SubAccountDataTypes WHERE ExternalSystemType = 1000 AND Description = 'Port'
SELECT @ipaddress = DataTypeID FROM SubAccountDataTypes WHERE ExternalSystemType = 1000 AND Description = 'IP Address'
SELECT @hostname = DataTypeID FROM SubAccountDataTypes WHERE ExternalSystemType = 1000 AND Description = 'Hostname'
SELECT @description = DataTypeID FROM SubAccountDataTypes WHERE ExternalSystemType = 1000 AND Description = 'Description'

SELECT sa.AccountID, CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Active, sa.HomeDir AS Path, at1.AccountType,
COALESCE((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND DataTypeID = @description),ma.Company + ' (' + CONVERT(VARCHAR,sa.AccountID) + ')',sa.FirstName + ' ' + sa.LastName + ' (' + CONVERT(VARCHAR,sa.AccountID) + ')') AS Description,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND DataTypeID = @port) AS Port,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND DataTypeID = @hostname) AS Hostname,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND DataTypeID = @ipaddress) AS IPAddress
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.ExternalSystemID = @esid
	AND (es.LastSyncDate IS NULL OR ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)
	AND sa.HomeDir IS NOT NULL
	AND (SELECT COUNT(*) FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.DataTypeID IN (@port,@ipaddress,@hostname) AND sad.Data <> '') > 0
GO
GRANT EXECUTE ON IISExport TO Emerald
GO

-- Add IIS Export support
DELETE FROM ExportColumns WHERE ExportID = 1000
IF NOT EXISTS (SELECT * FROM Exports WHERE ExportID = 1000)
	INSERT INTO Exports (FormatDefault,Separator,HeaderRow,DeclineMatch,ApproveString,Description,ExportType,QuoteString,Filter,SQLString,ApproveMatch,Lines,DeclineString,ExportID) VALUES(2,NULL,0,2,'SetupOK','IIS',3,NULL,NULL,'{CALL IISExport($esid,$FileMode)}',2,1,NULL,1000)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,1,NULL,1,'AccountID',NULL,2,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,2,NULL,1,'Active',NULL,2,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,3,NULL,1,'Path',NULL,1,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,4,NULL,1,'AccountType',NULL,1,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,5,NULL,1,'Description',NULL,1,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,6,NULL,1,'Port',NULL,1,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,7,NULL,1,'Hostname',NULL,1,0,0,NULL,1000)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,8,NULL,1,'IPAddress',NULL,1,0,0,NULL,1000)
GO

-- Populate Online Help
DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
DELETE FROM Strings WHERE StringID between 12000 And 12175 And ApplicationID = @appid
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12000, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12000_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12005, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12005_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12010, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12010_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12015, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12015_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12020, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12020_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12025, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12025_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12030, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12030_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12035, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12035_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12040, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12040_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12045, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12045_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12050, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12050_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12055, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12055_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12060, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12060_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12065, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12065_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12070, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12070_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12075, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12075_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12080, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12080_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12085, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12085_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12090, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12090_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12095, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12095_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12100, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12100_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12105, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12105_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12110, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12110_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12115, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12115_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12120, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12120_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12125, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12125_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12130, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12130_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12135, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12135_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12140, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12140_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12145, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12145_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12150, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12150_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12155, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12155_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12160, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12160_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12165, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12165_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12170, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12170_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12175, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/emerald.htm#12175_help')

DELETE FROM Strings WHERE StringID between 12300 And 12320 And ApplicationID = @appid
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12300, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerCust.htm#12300_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12305, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerCust.htm#12305_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12310, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerCust.htm#12310_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12315, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerCust.htm#12315_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 12320, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerCust.htm#12320_help')
go

DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
DELETE FROM Strings WHERE StringID between 13000 And 13390 And ApplicationID = @appid
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13000, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13000_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13003, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13003_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13005, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13005_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13010, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13010_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13015, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13015_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13020, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13020_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13025, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13025_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13030, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13030_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13035, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13035_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13040, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13040_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13045, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13045_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13050, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13050_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13055, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13055_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13060, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13060_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13065, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13065_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13070, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13070_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13080, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13080_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13085, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13085_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13090, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13090_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13095, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13095_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13100, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13100_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13103, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13103_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13105, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13105_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13110, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13110_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13115, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13115_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13120, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13120_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13125, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13125_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13130, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13130_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13135, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13135_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13140, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13140_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13145, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13145_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13150, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13150_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13155, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13155_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13160, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13160_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13165, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13165_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13167, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13167_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13170, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13170_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13175, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13175_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13180, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13180_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13182, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13182_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13183, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13183_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13185, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13185_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13190, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13190_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13200, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13200_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13205, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13205_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13210, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13210_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13215, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13215_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13220, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13220_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13225, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13225_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13230, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13230_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13235, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13235_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13238, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13238_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13240, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13240_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13245, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13245_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13250, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13250_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13255, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13255_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13260, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13260_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13265, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13265_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13270, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13270_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13275, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13275_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13280, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13280_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13285, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13285_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13290, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13290_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13295, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13295_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13297, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13297_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13298, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13298_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13300, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13300_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13305, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13305_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13310, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13310_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13315, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13315_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13317, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13317_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13320, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13320_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13325, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13325_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13330, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13330_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13335, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13335_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13337, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13337_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13340, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13340_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13345, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13345_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13350, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13350_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13355, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13355_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13360, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13360_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13365, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13365_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13370, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13370_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13375, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13375_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13380, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13380_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13385, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13385_help')
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 13390, '<IMG src="/images/help.gif" BORDER=0 ALT="Help">', '$BaseURL/EmerAdmn.htm#13390_help')
GO

Update Languages Set BaseURL = '/docs' Where BaseURL IS NULL OR BaseURL = '/docs/'
GO

Delete From Reports where FileName = 'futureexp.rpt'
INSERT INTO Reports(Report, FileName) VALUES('Future Expired Accounts', 'futureexp.rpt')
GO

UPDATE Configs SET Description = 'Service type 1' WHERE Description = 'Service type' AND ConfigID = 353
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 371) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Service type 2',371,353,12,NULL,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 372) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Service type 3',372,353,12,NULL,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 373) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Service type 4',373,353,12,NULL,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 374) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Service type 5',374,353,12,NULL,0,NULL)

if not exists (Select * From Objects o, MetaTables mt
	Where o.Value = mt.MetaTableID and o.ObjectTypeID = 2)
	BEGIN
	EXEC MetaAddObjectTable 'MBR Acct', 'Charges', 1
	END
GO

-- CC Login fields
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 400) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Login',400,400,9,NULL,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 401) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Password',401,401,9,NULL,1,NULL)
GO

-- ACH Realtime fields
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 99) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Processor Address',99,99,10,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 410) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Login',410,410,10,NULL,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 411) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Password',411,411,10,NULL,1,NULL)
GO

-- Statement creation parameters
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 37) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data)  VALUES('Invoice Next Term Max Days',37,37,6,90,0,NULL)
GO

-- Add missing object group associations
EXEC MetaAddObjectTable 'Services', 'SubAccountData', 1
EXEC MetaAddObjectTable 'MBR Basic', 'MasterAccountData', 1
EXEC MetaAddObjectTable 'MBR Basic', 'Addresses', 1
EXEC MetaAddObjectTable 'MBR Acct', 'Charges', 1
EXEC MetaAddObjectTable 'MBR Acct', 'InvoiceItems', 1
EXEC MetaAddObjectTable 'MBR Acct', 'InvoiceNotes', 1
EXEC MetaAddObjectTable 'MBR Acct', 'LateNotices', 1
EXEC MetaAddObjectTable 'MBR Acct', 'StatementNotes', 1
EXEC MetaAddObjectTable 'MBR Acct', 'ExternalTrans', 1
EXEC MetaAddObjectTable 'Client', 'Languages', 1
EXEC MetaAddObjectTable 'Service RADIUS', 'RadTriggers', 1
GO

-- POS Invoices
IF ((SELECT COUNT(*) FROM InvoiceTypes WHERE InvoiceTypeID = 91) = 0)
	INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(91, 'Point of Sale', NULL)
GO

DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10315 AND ApplicationID = @appid) = 0)
BEGIN
	INSERT INTO Strings(StringID, LanguageID, Version, ApplicationID, Data, URL) VALUES(10315, 1, 4, @appid, '<IMG src="/images/mbr_pos.jpg" BORDER=0 ALT="Point of Sale">', NULL)
	INSERT INTO Strings(StringID, LanguageID, Version, ApplicationID, Data, URL) VALUES(10315, 101, 4, @appid, '[point of sale]', NULL)
END

-- Automatic MBR Config on Reopen
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10316 AND ApplicationID = @appid AND LanguageID IN (1,101)) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10316, '<IMG src="/images/mbr_open.jpg" BORDER=0 ALT="Reopen MBR">',NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10316, '[mbr_open]', NULL)
END

-- Advanced Search
IF ((SELECT COUNT(*) FROM Strings WHERE StringID = 10129 AND ApplicationID = @appid AND LanguageID IN (1,101)) = 0)
BEGIN
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10129, '<IMG src="/images/advancedsearch.jpg" BORDER=0 ALT="Advanced">', NULL)
	INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 101, 10129, '[advanced]', NULL)
END
GO

Update Configs Set ConfigGroupID = 6 Where ConfigID = 38 And ConfigGroupID = 5
GO

Update Configs Set ConfigType = 0 Where ConfigID = 37 And ConfigType = 1
GO

IF EXISTS (Select ReportID From Reports Where FileName = 'ccbad.rpt')
	Delete From Reports Where FileName = 'ccbad.rpt'
GO

IF NOT EXISTS (Select ReportID From Reports Where FileName = 'badtrans.rpt')
	INSERT INTO Reports(Report, FileName) VALUES('Failed Transactions','badtrans.rpt')
GO

-- Emerald 4.1 to 4.2 Upgrade

/* MetaColumns Update */
Update MetaColumns 
Set MinSize = 0
From MetaColumns mc, MetaTables mt
where mt.TableName = 'Addresses'
and mc.MetaTableID = mt.MetaTableID
and ColumnName='Address1'
GO


if not exists (Select ExportID From Exports Where ExportID = 22)
BEGIN
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) 	VALUES(',',0,NULL,'Web Authorize (IC Verify Emu)','A TIME Y',1,'"',NULL,'{CALL CreditCardExport($transtime,$parameter)}',2,NULL,2,22)

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,22,0,'C1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CardHolder',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardNumber',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'CreditCardExpire',NULL,0,0,22,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Amount',NULL,3,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'Const2',NULL,0,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'Zip',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,9,NULL,1,'Address',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,0,NULL,0,'expyy',NULL,1,0,22,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,0,NULL,0,'expmm',NULL,1,0,22,0,NULL)

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'C1',0,9,NULL,1,'C1',22,2)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,2,'Trans ID',0,1,NULL,1,NULL,8,20)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Approve Code',2,7,NULL,2,NULL,22,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Response',0,8,NULL,2,'Authorized $this',22,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Status',0,2,NULL,2,NULL,22,0)
END
go

-- Statement creation parameters
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 36) = 0 
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data)  VALUES('Prorate days on Cancel',36,36,6,0,0,NULL)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(36,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(36,1,'Yes')
END
GO

-- Security Code removal
IF object_id('CreditCardImport') IS NOT NULL
	DROP PROCEDURE CreditCardImport
GO

CREATE PROCEDURE dbo.CreditCardImport @TransID INT, @TransType INT, @ApproveCode VARCHAR(12), @Response VARCHAR(50) AS
IF @TransType IN (3,4)
UPDATE CreditCards SET SecurityCode = NULL 
FROM CreditCards cc, ExternalTrans et
	WHERE cc.CustomerID = et.CustomerID
	AND et.ExternalTransID = @TransID
	AND cc.SecurityCode IS NOT NULL

UPDATE ExternalTrans
	SET TransType = @TransType, AuthSecurityCode = NULL,
	ApproveCode = @ApproveCode,
	Response = @Response,
	ProcDate = getdate()
WHERE ExternalTransID = @TransID
GO
GRANT EXECUTE ON CreditCardImport TO Emerald
GO

-- Customer Site Configuration Options

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 500) = 0 
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) 
		VALUES('Customer Website Login URL',500,500,8,NULL,1,NULL)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 501) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Customer Website Allow Payment',501,501,8,1,0,NULL)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(501,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(501,1,'Yes')
	END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 502) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Customer Website Name',502,502,8,0,1,NULL)
	END
GO


IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 503) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Customer Website Hide Payment Method Change',503,503,8,0,0,NULL)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(503,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(503,1,'Yes')
	END ELSE BEGIN
	UPDATE Configs SET Description = 'Customer Website Hide Payment Method Change' WHERE Description = 'Customer Website Allow Payment Method Change' AND ConfigID = 503
	END
GO

-- Allow Caller-ID, DNIS to be seen in reply list
Update RadAttributes Set ReplyType = 2 Where RadAttributeID in (30, 31) and RadVendorID = 0 and ReplyType = 0
GO

-- reset Editions and Features
-- Reseting Editions or feature will only display the link.  Internal code verified sections
-- and will give a invalid license error if the edition is wrong.

--Select TableName, Edition, Feature From MetaTables Where Edition IS NULL Order By TableName
Update MetaTables Set Edition = 0, Feature = NULL
Update MetaTables Set Edition = 1 Where TableName IN ('Invoices', 'Statements', 'Payments', 'BankTrans', 'Charges', 'ChargeTypes')
Update MetaTables Set Edition = 1 Where TableName IN ('CreditCards', 'ExternalTrans', 'LateNotices', 'PaymentTypes', 'PayMethods', 'PayPeriods')
Update MetaTables Set Edition = 1 Where TableName IN ('SubAccountDataTypes', 'MasterAccountDataTypes', 'Taxes', 'Addresses', 'AddressTypes')
Update MetaTables Set Edition = 1 Where TableName IN ('Discounts', 'LateNoticeTypes', 'Rates', 'SendMethods')
Update MetaTables Set Edition = 2 Where TableName IN ('RadRoamDomains', 'RadRoamServers')
Update MetaTables Set Edition = 3 Where TableName IN ('FlowFilterGroups', 'RateTables')
Update MetaTables Set Feature = 3 Where TableName = 'FlowFilterGroups'
GO

--Select ConfigID, Description From Configs
Update Configs Set Edition = 0
Update Configs Set Edition = 1 Where ConfigID IN (13, 14, 36, 37, 38)
UPDATE Configs SET Edition = 1 WHERE ConfigGroupID IN (9,10)
GO

UPDATE ExternalTrans SET AuthSecurityCode = NULL WHERE AuthSecurityCode = '(null)'
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'RateHistory' AND sc.name = 'TotalRate') = 0)
	ALTER TABLE RateHistory ADD TotalRate numeric(18,4) DEFAULT 0 NULL
GO

-- Add Logs Object Group
IF NOT EXISTS (Select * From ObjectGroups Where ObjectGroupID = 120)
	BEGIN
	INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (120, 'Logs')

	EXEC MetaAddObjectTable 'Logs', 'AuditLogs', 1
	EXEC MetaAddObjectTable 'Logs', 'MailLogs', 1
	EXEC MetaAddObjectTable 'Logs', 'Logs', 1

	/* GroupID=2 Tech */
	INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) 
		VALUES(2, 1, 120, 3)

	/* GroupID=3 Accounting */
	INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) 
		VALUES(3, 1, 120, 3)
	END
GO

---- Please do not add update queries below this line
DELETE FROM ConfigValues WHERE ConfigID IN(74,84,353,371,372,373,374) AND Value <> 0
GO

INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 74 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType IN (1,2,5)
GO

INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 84 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType IN (4,6)
GO

INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 353 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
UNION ALL
SELECT 371 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
UNION ALL
SELECT 372 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
UNION ALL
SELECT 373 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
UNION ALL
SELECT 374 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
GO

UPDATE MetaColumns SET MaxSize = 64
FROM MetaColumns mc, MetaTables mt
WHERE mc.MetaTableID = mt.MetaTableID
AND mt.TableName = 'Charges'
AND mc.ColumnName = 'Description'
AND mc.MaxSize < 64
GO

UPDATE MetaColumns SET MaxSize = 64
FROM MetaColumns mc, MetaTables mt
WHERE mc.MetaTableID = mt.MetaTableID
AND mt.TableName = 'InvoiceItems'
AND mc.ColumnName = 'Description'
AND mc.MaxSize < 64
GO

UPDATE MetaColumns SET MaxSize = 45
FROM MetaColumns mc, MetaTables mt
WHERE mc.MetaTableID = mt.MetaTableID
AND mt.TableName = 'Reports'
AND mc.ColumnName = 'FileName'
AND mc.MaxSize < 45
GO
