-- ConvertData_25_40.sql
 
-- This script will be used to convert a user's existing Emerald 2.5 database over
-- to a new Emerald 4.0 schema. You must run insttabs.sql and codetabs.sql before 
-- running this script.  It is highely recommended to use EmerDBA to upgrade rather
-- than trying to run the scripts manually.  Order is VERY important for correct results.

-- If you are running this script manually and your DB is NOT Emerald, then do a global search 
-- and replace for "Emerald.." to "DatabaseName..", where database name if your Emerald 2.5    
-- database.  DO NOT change the Emerald.. string if you are going to use the Emerald DB Admin,  
-- as it will do a search/replace on the fly for the name of the database that you chose.      

-- Note:  Comments /* */ MUST begin/end on the same line, or the Emerald parser will error 
--        one line comments can be anywhere and any that start at the beginning of the line
--		  will be filterd by the Emerald parser

/* Domains  */
SET IDENTITY_INSERT Domains ON
Insert Into Domains(DomainID, Domain, MailDomain, GroupID, Description, SortOrder) 
	 Select DomainID, Domain, MailDomain, NULL, ISNULL(Description, Domain), 1 
	 From Emerald..Domains
SET IDENTITY_INSERT Domains OFF
GO

/*  Groups  */
SET IDENTITY_INSERT Groups ON
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into Groups(GroupID, DomainID, GroupName, Description, SortOrder, GlobalOptions, InvoiceReport, InvoiceTextReport, UniqueLogins, FTPDir, BillName, BillAddress1, BillCity, BillState, BillZip, EmailAccounts,EmailSubject)
	 Select CASE WHEN g.GroupID = -1 THEN 1 WHEN g.GroupID = 1 THEN @GroupID ELSE g.GroupID END AS GroupID, COALESCE(g.DomainID,(SELECT MIN(DomainID) FROM Domains)), g.GroupName, ISNULL(g.Description, g.GroupName), ISNULL(g.SortOrder,98), g.GlobalOptions, g.InvoiceReport, g.EmailReport, ISNULL(g.UniqueLogins,0), g.FTPDir, 'ISP Inc', '1234 Someplace Ave', 'SomeWhere', 'AW', '99999','billing@my.com', 'ISP Billing Account' 
	 From Emerald..Groups g, Emerald..Domains d
		WHERE g.DomainID *= d.DomainID
SET IDENTITY_INSERT Groups OFF

Update Groups Set InvoiceReport = NULL Where InvoiceReport = ' ' or Datalength(InvoiceReport) < 4
Update Groups Set InvoiceTextReport = NULL Where InvoiceTextReport = ' ' or Datalength(InvoiceTextReport) < 4
GO

/* Global Group */
IF ((SELECT COUNT(*) FROM Groups WHERE GroupID = 1) = 0)
BEGIN
SET IDENTITY_INSERT Groups ON
DECLARE @DomainID INT
SELECT @DomainID = MIN(DomainID) FROM Domains
INSERT INTO Groups(GroupID,DomainID,GroupName,Description,SortOrder,GlobalOptions,BillName, BillAddress1, BillCity, BillState, BillZip, EmailAccounts,EmailSubject)
VALUES(1, @DomainID, 'Global', 'All Groups',0, 1,'ISP Inc', '1234 Someplace Ave', 'SomeWhere', 'AW', '99999','billing', 'ISP Billing Account')
SET IDENTITY_INSERT Groups OFF
END
GO

/*  DNISGroups  */
SET IDENTITY_INSERT DNISGroups ON
Insert Into DNISGroups(DNISGroupID, DNISGroup, Description) 
	Select DNISGroupID, DNISGroup, ISNULL(Description, DNISGroup)
	From Emerald..DNISGroups
SET IDENTITY_INSERT DNISGroups OFF
GO

/*  DNISNumbers  */
Insert Into DNISNumbers(DNISGroupID, DNISNumber) 
	Select DNISGroupID, DNISNumber 
	From Emerald..DNISNumbers 
GO


/*  Rates */
SET IDENTITY_INSERT Rates ON
Insert Into Rates(RateID, Description, DefaultType, DefaultInterval, DefaultCharge, 
	PrimaryStart, PrimaryStop, MinCharge, MaxCharge, TaxID) 
	Select RateID, Description, 0, StandardInterval, StandardCharge, 
	PrimaryStart, PrimaryStop, 0, 0, NULL 
	From Emerald..Rates 

-- histtype 0=standard, 1=primary   schetype 0=time, 1=data
-- standard over time
Insert Into RateSchedules(RateID,HistoryType,ScheduleType,Offset,Interval,Charge,SortOrder) 
	Select RateID, 0, 0, StandardHours, OverInterval, OverCharge, 1
	From Emerald..Rates 
	Where OverCharge > 0 and OverInterval > 0

-- Primary Standard
Insert Into RateSchedules(RateID,HistoryType,ScheduleType,Offset,Interval,Charge,SortOrder) 
	Select RateID, 1, 0, 0, StandardInterval, PrimaryCharge, 2
	From Emerald..Rates 
	Where PrimaryPay <> 0 

-- Primary Over
Insert Into RateSchedules(RateID,HistoryType,ScheduleType,Offset,Interval,Charge,SortOrder) 
	Select RateID, 1, 0, 0, StandardInterval, PrimaryCharge, 3 
	From Emerald..Rates 
	Where PrimaryPay <> 0 

SET IDENTITY_INSERT Rates OFF
GO

/*  Taxes  */
SET IDENTITY_INSERT Taxes ON
if exists (Select so.id from Emerald..sysobjects so, Emerald..syscolumns sc 
		 where so.id=sc.id and so.name='Taxes' and sc.name='Limit')
	BEGIN EXEC('Insert Into Taxes(TaxID, Tax, Tax2, TaxType, Limit, LimitType, Description) 
		Select TaxID, Tax, Tax2, TaxType, Limit, LimitType, Description 
		From Emerald..Taxes ')
	END

if not exists (Select so.id from Emerald..sysobjects so, Emerald..syscolumns sc 
		 where so.id=sc.id and so.name='Taxes' and sc.name='Limit')
	BEGIN Insert Into Taxes(TaxID, Tax, Tax2, TaxType, Limit, LimitType, Description) 
		Select TaxID, Tax, Tax2, TaxType, NULL, NULL, Description 
		From Emerald..Taxes 
	 END 
SET IDENTITY_INSERT Taxes OFF
GO

/*  ChargeTypes  */
SET IDENTITY_INSERT ChargeTypes ON
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into ChargeTypes(ChargeTypeID, Description, Amount, TaxID, GroupID) 
	Select ChargeTypeID, ISNULL(Description, convert(varchar, ChargeTypeID)), Amount, TaxID, CASE WHEN GroupID = -1 THEN 1 WHEN GroupID = 1 THEN @GroupID ELSE GroupID END AS GroupID
	From Emerald..ChargeTypes
SET IDENTITY_INSERT ChargeTypes OFF
GO

/*  ExternalSystems  */
SET IDENTITY_INSERT ExternalSystems ON
Insert Into ExternalSystems(ExternalSystemID, Name, ExternalSystemType, Description, MailHost, Accounts, Login, Password, FormID, LogFile,FileMode, LastSyncDate)
	Select ExternalSystemID, Name, Type, ISNULL(Description, Name), SmartHost, Accounts, PostMaster, Password, FormID, LogFile, 0 , 'Jan 1 1990'
	From Emerald..ExternalSystems 
SET IDENTITY_INSERT ExternalSystems OFF
GO

/*  AccountTypes */
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into AccountTypes(AccountType, Cost, Description, ApplyDiscount, TaxID, RateID, 
	ChargeTypeID, ExternalSystemID, GroupID, DNISGroupID, SortOrder, SendBill, RemoteAccess)

Select at1.AccountType, at1.Cost, ISNULL(at1.Description,at1.AccountType), at1.ApplyDiscount, at1.TaxID, at1.RateID,at1.ChargeTypeID, et.ExternalSystemID, CASE WHEN at1.GroupID = -1 THEN 1 WHEN at1.GroupID = 1 THEN @GroupID ELSE at1.GroupID END AS GroupID, at1.DNISGroupID,ISNULL(at1.SortOrder,98), 1,1
FROM Emerald..AccountTypes at1, ExternalSystems et
	WHERE at1.ExternalSystemID *= et.ExternalSystemID
GO

/*  Billing Cycles  */
SET IDENTITY_INSERT BillingCycles ON
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into BillingCycles(BillingCycleID, Description, CycleType, AutoBill, IBillDays, EBillDays, SortOrder, GroupID) 
	Select BillingCycleID, Description, Monthly, AutoBill, IBillDays, EBillDays, ISNULL(SortOrder,98), CASE WHEN GroupID = -1 THEN 1 WHEN GroupID = 1 THEN @GroupID ELSE GroupID END AS GroupID
	From Emerald..BillingCycles
SET IDENTITY_INSERT BillingCycles OFF
GO

/*  ReferredBys  */
Insert Into ReferredBys(ReferredBy, SortOrder)
	 Select Distinct ReferredBy, ISNULL(SortOrder, 98)
	 From Emerald..ReferredBys
GO

Insert Into ReferredBys(ReferredBy, SortOrder)
	Select Distinct ReferredBy, 199
	From MasterAccounts
	Where ReferredBy NOT IN (Select ReferredBy From ReferredBys)
		AND ReferredBy IS NOT NULL
GO


/*  SalesPersons  */
Insert Into SalesPersons(SalesPerson, SortOrder)
	 Select Distinct SalesPerson, min(ISNULL(SortOrder,98))
	 From Emerald..SalesPersons
	 Group By SalesPerson
GO

Insert Into SalesPersons(SalesPerson, SortOrder)
	Select Distinct SalesPerson, 199
	From Emerald..MasterAccounts
	Where SalesPerson NOT IN (Select SalesPerson From SalesPersons)
	AND SalesPerson IS NOT NULL
GO

If NOT EXISTS (Select SalesPersonID From SalesPersons Where SalesPerson = 'Other')
	Insert Into SalesPersons(SalesPerson, SortOrder) VALUES('Other', 254)
GO

/*  Regions  */
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into Regions(Region, GroupID, Taxable, SortOrder)
	 Select Region, CASE WHEN GroupID = -1 THEN 1 WHEN GroupID = 1 THEN @GroupID ELSE GroupID END AS GroupID, Taxable, ISNULL(SortOrder,98)
	 From Emerald..Regions
GO

/*  PayPeriods  */
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into PayPeriods(PayPeriod, Period, Amount, AmountType, SetupCharge, GroupID, SortOrder) 
	 Select PayPeriod, Period, Percentage, 0, ISNULL(SetupCharge,0), 
		CASE WHEN GroupID = -1 THEN 1 WHEN GroupID = 1 THEN @GroupID ELSE GroupID END AS GroupID, ISNULL(SortOrder,98)
	 From Emerald..PayPeriods 
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts WHERE BillingCycleID IS NULL) > 0)
	RAISERROR('Some Emerald 2.5 MBRs have no billing cycles. See the release notes for more information.  Select "Ignore" to automatically assign a Billing cycle to these accounts.',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts WHERE Region NOT IN (SELECT Region FROM Emerald..Regions)) > 0)
	RAISERROR('There are Regions missing from the Emerald 2.5 Regions table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts WHERE PayPeriod NOT IN (SELECT PayPeriod FROM Emerald..PayPeriods)) > 0)
	RAISERROR('There are PayPeriods missing from the Emerald 2.5 PayPeriods table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts WHERE PayMethod NOT IN (SELECT PayMethod FROM Emerald..PayMethods)) > 0)
	RAISERROR('There are PayMethods missing from the Emerald 2.5 PayMethods table',11,1)
GO

/*  MasterAccounts  */
SET IDENTITY_INSERT MasterAccounts ON
DECLARE @defsp int, @defbc INT, @GroupID INT
Select @defsp=SalesPersonID From SalesPersons Where SalesPerson = 'Other'
SELECT @defbc = MIN(BillingCycleID) FROM BillingCycles
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups

Insert Into MasterAccounts(CustomerID, ReferredBy, FirstName, LastName, Company, Address1, Address2, City, State, 
		Zip, PhoneHome, PhoneWork, PhoneFax, Gender, Salutation, SalesPersonID, RegionID, CreateDate, StartDate,  Active, 
		PayMethodID, PayPeriodID, LastReceived, Comments, LastModifyDate, LastModifyUser, Status, 
		GroupID, Balance, OverDue, SendMethodID, OverLimit, Taxable, BillingCycleID, CancelDate, CancelReasonID, Operator, 
		Over30Count, Over60Count, Over90Count, Over120Count, AgedDate, PendingCredit, 
		PendingDebit, LastStatementID, NoticeDate, PayInfo, BillDay) 

	 Select CustomerID, ReferredBy, FirstName, LastName, Company, Address1, Address2, City, State, 
		Zip, PhoneHome, PhoneWork, PhoneFax, NULL, NULL, ISNULL(SalesPersonID, @defsp), RegionID, CreateDate, StartDate, ma.Active, 
		COALESCE(PayMethodID,(SELECT PayMethodID FROM PayMethods WHERE PayMethod = 'Other')) AS PayMethodID, pp.PayPeriodID, LastReceived, Comments, LastModifyDate, LastModifyUser, CASE WHEN maNew <> 0 then 2 WHEN maCurrent <> 0 then 1 ELSE 0 END As Status, 
		CASE WHEN ma.GroupID = -1 THEN 1 WHEN ma.GroupID = 1 THEN @GroupID ELSE ma.GroupID END AS GroupID, ISNULL(ma.Balance,0) + ISNULL((SELECT SUM(p.Amount) FROM Emerald..Payments p WHERE p.InvoiceID IS NULL AND p.CustomerID = ma.CustomerID),0) as Balance, Extension, COALESCE(SendMethod,3), OverLimit, ISNULL(ma.Taxable,0), COALESCE(BillingCycleID,@defbc), 
		NULL, NULL, NULL, 0, 0, 0, 0, NULL, ISNULL((SELECT SUM(p.Amount) FROM Emerald..Payments p WHERE p.InvoiceID IS NULL AND p.CustomerID = ma.CustomerID),0), 
		0, NULL, NULL, PayInfo, Day(COALESCE(BilledThru,getdate()))
	From Emerald..MasterAccounts ma, Regions r, PayMethods pm, SalesPersons sp, PayPeriods pp
	Where (ma.Region = r.Region 
		OR (ma.Region IN ('Unknown',' ','') AND r.Region = 'Other' AND NOT (ma.Region = 'Unknown' AND EXISTS (SELECT * FROM Regions WHERE Region = 'Unknown')) )
		)
	  and ((pm.PayMethod = 'Renewal' AND ma.Paymethod IN ('Invoice', ' Purchase Order', 'Purchase Order', ' Cash', ' Check'))
		OR (pm.PayMethod = 'Credit Card' AND ma.PayMethod = 'Credit Card')
		OR (pm.PayMethod = 'Bank Transfer' AND ma.PayMethod = 'Bank Transfer')
		OR (pm.PayMethod = 'Custom' AND ma.PayMethod = 'Custom')
		OR (pm.PayMethod = 'Other' AND ma.PayMethod NOT IN ('Invoice', ' Purchase Order', 'Purchase Order', ' Cash', ' Check','Credit Card','Bank Transfer','Custom'))
	     )
	  and ma.PayPeriod = pp.PayPeriod
	  and ma.SalesPerson *= sp.SalesPerson
SET IDENTITY_INSERT MasterAccounts OFF
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts) <> (SELECT COUNT(*) FROM MasterAccounts))
	RAISERROR('Not all MBR records have been converted',11,1)
GO

/* CreditCards */
SET DATEFORMAT mdy
CREATE TABLE #cctmp (CustomerID INT, ExpireString VARCHAR(10), ExpireDate DATETIME)

INSERT INTO #cctmp (CustomerID,ExpireString) 
	SELECT CustomerID, Replace(Replace(CreditCardExpire, Char(13), ''), char(10), '')
	FROM Emerald..MasterAccounts 
	WHERE CreditCardExpire <> ''
		and PayMethod = 'Credit Card'
		and Active = 1

DECLARE @left INT, @right INT, @monthpos INT

IF ((SELECT COUNT(*) FROM #cctmp) = 0)
	SELECT @monthpos = 1

SELECT @left = MAX(CONVERT(INT,LEFT(ExpireString,2))), @right = MAX(CONVERT(INT,RIGHT(ExpireString,2))), @monthpos = 0
	FROM #cctmp
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9][0-9][0-9][0-9]'

IF ('$ccmonthpos' = '1')
	SELECT @monthpos = 1
ELSE IF ('$ccmonthpos' = '2')
	SELECT @monthpos = 2
ELSE BEGIN
	IF (@monthpos = 0 AND @left = 12)
		SELECT @monthpos = 1
	IF (@monthpos = 0 AND @right = 12)
		SELECT @monthpos = 2
	IF (@monthpos = 0 AND @left > 12 AND @right <= 12)
		SELECT @monthpos = 2
	IF (@monthpos = 0 AND @right > 12 AND @left <= 12)
		SELECT @monthpos = 1
END

IF (@monthpos = 0)
	RAISERROR('Can not determine date format of the MBR CreditCard expiration field. (Either MMYY or YYMM).  Please select "abort" and rerun this conversion selecting the correct format',11,1)

UPDATE #cctmp SET ExpireDate = LEFT(ExpireString,2) + '/01/' + RIGHT(ExpireString,2)
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9][0-9]/[0-9][0-9]'
	AND CONVERT(INT,LEFT(ExpireString,2)) BETWEEN 1 and 12

UPDATE #cctmp SET ExpireDate = LEFT(ExpireString,1) + '/01/' + RIGHT(ExpireString,1)
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9]/[0-9]'

UPDATE #cctmp SET ExpireDate = LEFT(ExpireString,1) + '/01/' + RIGHT(ExpireString,2)
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9]/[0-9][0-9]'

UPDATE #cctmp SET ExpireDate = LEFT(ExpireString,2) + '/01/' + RIGHT(ExpireString,1)
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9][0-9]/[0-9]'
	AND CONVERT(INT,LEFT(ExpireString,2)) BETWEEN 1 and 12

UPDATE #cctmp SET ExpireDate = CASE WHEN @monthpos = 1 THEN LEFT(ExpireString,2) ELSE RIGHT(ExpireString,2) END + '/01/' + CASE WHEN @monthpos = 1 THEN RIGHT(ExpireString,2) ELSE LEFT(ExpireString,2) END
	WHERE ExpireDate IS NULL
	AND ExpireString LIKE '[0-9][0-9][0-9][0-9]'
	AND ((@monthpos = 1 AND CONVERT(INT,LEFT(ExpireString,2)) BETWEEN 1 and 12) OR
		(@monthpos = 2 AND CONVERT(INT,RIGHT(ExpireString,2)) BETWEEN 1 and 12))

INSERT INTO CreditCards (CustomerID,CardHolder,CardNumber,ExpirationDate,BillToAddress1,BillToAddress2,BillToCity,BillToState,BillToZip,LastModifyDate,LastModifyUser)
SELECT ma.CustomerID, ma.CreditCardAuth, ma.CreditCardNumber,cc.ExpireDate,ma.Address1,ma.Address2,ma.City,ma.State,ma.Zip,ma.LastModifyDate,ma.LastModifyUser
FROM Emerald..MasterAccounts ma, #cctmp cc
	WHERE ma.CustomerID = cc.CustomerID
	AND ma.CreditCardNumber <> ''
	AND cc.ExpireDate IS NOT NULL

INSERT INTO Logs (LogMsgID,Operator,LogMsg,CustomerID,AccountID)
SELECT 11 AS LogMsgID,'DB Conversion' AS Operator,'Unknown CC expiration format: ' + cc.ExpireString AS LogMsg,ma.CustomerID,NULL AS AccountID
FROM Emerald..MasterAccounts ma, #cctmp cc
	WHERE ma.CustomerID = cc.CustomerID
	AND ma.CreditCardNumber <> ''
	AND ma.PayMethod = 'Credit Card'
	AND cc.ExpireDate IS NULL
	AND ma.Active = 1
	AND ma.CustomerID IN (SELECT CustomerID FROM SubAccounts WHERE Active = 1)

DROP TABLE #cctmp
GO

/*  BankTrans  */
if exists (Select so.id from Emerald..sysobjects so, Emerald..syscolumns sc 
		 where so.id=sc.id and so.name='BankTrans' and sc.name='TransType')
	BEGIN 
	 Insert Into BankTrans(CustomerID, AuthName, BankName, ABANumber, AccountNumber, LastModifyDate, LastModifyUser) 
	 Select CustomerID, AuthName, BankName, ABANumber, AccountNumber, LastModifyDate, LastModifyUser 
	 From Emerald..BankTrans 
	 END
GO

/*  MasterAccounts  -- calculate and update MBR aging fields.... */

/*  Discounts  */
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups
Insert Into Discounts(Discount, Amount, GroupID, SortOrder, AmountType) 
	 Select Discount, Percentage, CASE WHEN GroupID = -1 THEN 1 WHEN GroupID = 1 THEN @GroupID ELSE GroupID END AS GroupID, ISNULL(SortOrder,98), 0 
	 From Emerald..Discounts 
GO

Update MasterAccounts Set ReferredBy = 'Other'
Where ReferredBy IS NULL
	OR ReferredBy = ''
	OR ReferredBy = ' '
GO

/*  ModemSpeeds  */
 Insert Into ModemSpeeds(ModemSpeed, SortOrder) 
	 Select ModemSpeed, ISNULL(SortOrder,98)
	 From Emerald..ModemSpeeds
GO

/*  NetSoftware  */
 Insert Into NetSoftwares(NetSoftware, Map, SortOrder) 
	 Select NetSoftware, Map, ISNULL(SortOrder,98)
	 From Emerald..NetSoftwares 
GO

/*  SystemTypes  */
Insert Into SystemTypes(SystemType, SortOrder) 
	 Select SystemType, ISNULL(SortOrder,98)
	 From Emerald..SystemTypes
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE AccountType NOT IN (SELECT AccountType FROM Emerald..AccountTypes)) > 0)
	RAISERROR('There are AccountTypes missing from the Emerald 2.5 AccountTypes table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE Discount NOT IN (SELECT Discount FROM Emerald..Discounts)) > 0)
	RAISERROR('There are Discounts missing from the Emerald 2.5 Discounts table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE SystemType NOT IN (SELECT SystemType FROM Emerald..SystemTypes)) > 0)
	RAISERROR('There are SystemTypes missing from the Emerald 2.5 SystemTypes table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE ModemSpeed NOT IN (SELECT ModemSpeed FROM Emerald..ModemSpeeds)) > 0)
	RAISERROR('There are ModemSpeeds missing from the Emerald 2.5 ModemSpeeds table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE NetSoftware NOT IN (SELECT NetSoftware FROM Emerald..NetSoftwares)) > 0)
	RAISERROR('There are NetSoftwares missing from the Emerald 2.5 NetSoftwares table',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts WHERE CustomerID NOT IN (SELECT CustomerID FROM Emerald..MasterAccounts)) > 0)
	RAISERROR('There are Customers missing from the Emerald 2.5 MasterAccounts table (SA)',11,1)
GO

/*  SubAccounts  */
SET IDENTITY_INSERT SubAccounts ON
DECLARE @GroupID INT
SELECT @GroupID = MAX(GroupID) + 1 FROM Emerald..Groups

Insert Into SubAccounts(AccountID, CustomerID, Login, Email, FirstName, LastName, PhoneHome, PhoneWork, 
		AccountTypeID, DiffCost, Cost, DiscountID, Comments, Password, MaidenName, SystemTypeID, ModemSpeedID, 
		NetSoftwareID, CreateDate, StartDate, PayPeriodID, BilledThru, 
		ExpireDate, Extension, Active, Operator, 
		LastModifyDate, LastModifyUser, Preferred, TimeLeft, HomeDir, HomeDirLimit, SendBill, LoginLimit, LastUsed,
		DomainID, Gender, Salutation, Status, RemoteAccess) 
	 Select AccountID, sa.CustomerID, Login, Email, sa.FirstName, sa.LastName, sa.PhoneHome, sa.PhoneWork, 
		 at1.AccountTypeID, DiffCost, sa.Cost, DiscountID, sa.Description, Password, MaidenName, SystemTypeID, ModemSpeedID, 
		 NetSoftwareID, SignDate, SignDate, pp.PayPeriodID, DateAdd(Day, 0-1, CONVERT(DATETIME,COALESCE(ma.BilledThru,getdate()))) AS BilledThru, maExpireDate, ISNULL(ma.Overdue,0), sa.Active, 
		 ISNULL(Operator, 'Unknown'), sa.LastModifyDate, ISNULL(sa.LastModifyUser, 'Unknown'), Preferred, sa.TimeLeft, HomeDir,  
		 HomeDirLimit, ISNULL(sa.SendBill,0), sa.LoginLimit, LastUsed, COALESCE((SELECT DomainID FROM Groups g WHERE CASE WHEN ma.GroupID = -1 THEN 1 WHEN ma.GroupID = 1 THEN @GroupID ELSE ma.GroupID END = g.GroupID),1), NULL, NULL, 
		CASE WHEN saNew <> 0 then 2 WHEN saCurrent <> 0 then 1 ELSE 0 END As Status, 1
	From Emerald..SubAccounts sa, Emerald..MasterAccounts ma, Discounts d, AccountTypes at1, PayPeriods pp, NetSoftwares ns, ModemSpeeds ms, SystemTypes st
	Where sa.CustomerID = ma.CustomerID 
		and sa.AccountType = at1.AccountType 
		and sa.Discount = d.Discount
	 	and pp.PayPeriod = ma.PayPeriod
	 	and sa.ModemSpeed = ms.ModemSpeed
	 	and sa.SystemType = st.SystemType
	 	and sa.NetSoftware = ns.NetSoftware
SET IDENTITY_INSERT SubAccounts OFF
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts) <> (SELECT COUNT(*) FROM SubAccounts))
	RAISERROR('Not all service records have been converted',11,1)
GO

/*  Incident Types  */
 Insert Into IncidentTypes(IncidentType, Description, Email, SortOrder) 
	 Select IncidentType, ISNULL(Description, IncidentType), Email, ISNULL(SortOrder,98)
	 From Emerald..IncidentTypes
GO

/*  Incidents  */
SET IDENTITY_INSERT Incidents ON
Insert Into Incidents(IncidentID, AccountID, CreateDate, Operator, Description, 
	 LastModifyDate, LastModifyUser, IncidentTypeID, IncidentStateID, Hide) 
	 Select i.IncidentID, i.AccountID, i.Date, i.Operator, i.Description, i.LastModifyDate, i.LastModifyUser, 
	 ISNULL(it.IncidentTypeID, (Select Min(IncidentTypeID) From IncidentTypes)), CASE WHEN i.Closed = 1 THEN 0 ELSE 1 END, 1
	 From Emerald..Incidents i, IncidentTypes it, SubAccounts sa
	 Where i.IncidentType *= it.IncidentType
	AND i.AccountID = sa.AccountID
SET IDENTITY_INSERT Incidents OFF
GO

/*  Actions  */
SET IDENTITY_INSERT Actions ON
Insert Into Actions(ActionID, IncidentID, CreateDate, Operator, Description, LastModifyDate, LastModifyUser, Hide) 
	Select a.ActionID, a.IncidentID, a.Date, a.Operator, a.Description, a.LastModifyDate, a.LastModifyUser, 1
	 From Emerald..Actions a, Incidents i
	WHERE a.IncidentID = i.IncidentID
SET IDENTITY_INSERT Actions OFF
GO

/*  Aliases  */
Insert Into Aliases(Alias, AccountID, CreateDate, LastModifyDate, LastModifyUser) 
	Select Alias, AccountID, CreateDate, LastModifyDate, LastModifyUser 
	From Emerald..Aliases
GO

/*  Forwards  */
-- Some Emerald 2.5 installs had a misspelled "fowards" table.
if exists (Select id from Emerald..sysobjects where name='Forwards')
	BEGIN 
	EXEC('Insert Into Forwards(Forward, AccountID, CreateDate, LastModifyDate, LastModifyUser) 
		Select Forward, AccountID, CreateDate, LastModifyDate, LastModifyUser 
		From Emerald..Forwards')
	END

GO

/*  RadTriggers  */
Insert Into RadTriggers(AccountID, TriggerType, FileName, Parameters, Directory) 
	Select AccountID, Type, FileName, Parameters, Directory 
	 From Emerald..RadTriggers
GO

/*  Invoices  */
SET IDENTITY_INSERT Invoices ON
Insert Into Invoices(InvoiceID, CustomerID, InvoiceTypeID, Amount, CreateDate, 
	LastModifyDate, LastModifyUser, SentDate, Tax, StatementID, Comments) 
	Select InvoiceID, CustomerID, ISNULL(IT.InvoiceTypeID, 99), 
	COALESCE(Amount,0)-COALESCE(PreviousBalance,0) as Amount, Date, LastModifyDate, 
	LastModifyUser, SentDate, ISNULL(Tax,0)+ISNULL(Tax2,0), NULL, NULL 
	From Emerald..Invoices I, InvoiceTypes IT 
	Where I.Type *= IT.InvoiceType 
SET IDENTITY_INSERT Invoices OFF
GO

/*  Payments  */

DECLARE @defpt int
Select @defpt=PaymentTypeID From PaymentTypes Where PaymentType = 'Other'

SET IDENTITY_INSERT Payments ON
Insert Into Payments(PaymentID, CustomerID, Amount, CreateDate, LastModifyDate, 
		LastModifyUser, PayInfo, CheckNumber, GLState, PaymentTypeID) 
	Select PaymentID, CustomerID, p.Amount, Date, LastModifyDate, 
		LastModifyUser, PayInfo, NULL, NULL, ISNULL(pt.PaymentTypeID, @defpt)
	From Emerald..Payments p, PaymentTypes pt 
	Where p.Type *= pt.PaymentType 
SET IDENTITY_INSERT Payments OFF
GO

/*  InvoiceItems  */
SELECT sa.CustomerID, sa.Login, MIN(sa.AccountID) AS AccountID, MIN(sa.AccountTypeID) AS AccountTypeID INTO #tmp
FROM SubAccounts sa
	GROUP BY sa.CustomerID, sa.Login
GO

SET IDENTITY_INSERT InvoiceItems ON
INSERT INTO InvoiceItems(ItemID, ItemType, InvoiceID, Login, Description, Amount, StartDate, 
	 EndDate, Quantity, TaxID, AccountID, AccountTypeID, PaidAmount, ChargeTypeID, GLState) 
Select ii.ItemID, CASE WHEN ii.Amount > 0 THEN 3 ELSE 1 END, ii.InvoiceID, ii.Login, 
	ISNULL(ii.Description, ii.Login) AS Description, ii.Amount, i.StartDate, i.EndDate, 
	Quantity, TaxID, t.AccountID, t.AccountTypeID,
	CASE PaymentID WHEN NULL THEN 0 ELSE ii.Amount*ii.Quantity END AS PaidAmount, NULL AS ChargeTypeID, NULL AS GLState
FROM Emerald..InvoiceItems ii, Emerald..Invoices i, #tmp t
	WHERE ii.InvoiceID = i.InvoiceID
	AND i.CustomerID *= t.CustomerID
	AND ii.Login *= t.Login
GO

DROP TABLE #tmp
GO

SET IDENTITY_INSERT InvoiceItems OFF
GO

INSERT INTO InvoiceItems(ItemType, InvoiceID, Login, Description, Amount, StartDate, 
	 EndDate, Quantity, TaxID, AccountID, AccountTypeID, PaidAmount, ChargeTypeID, GLState) 

Select 254, InvoiceID, NULL, NULL, SUM(Tax), GetDate(), GetDate(), 1, TaxID, NULL, NULL, SUM(Tax), NULL, NULL
FROM Emerald..InvoiceItems 
Where TaxID IS NOT NULL and Tax > 0
Group BY InvoiceID, TaxID
Having SUM(Tax) > 0

UNION

Select 255, InvoiceID, NULL, NULL, SUM(Tax2), GetDate(), GetDate(), 1, TaxID, NULL, NULL, SUM(Tax2), NULL, NULL
FROM Emerald..InvoiceItems 
Where TaxID IS NOT NULL and Tax2 > 0
Group BY InvoiceID, TaxID
Having SUM(Tax2) > 0
GO

Update ii
Set ii.Description = t.Description, ii.StartDate=i.StartDate, ii.EndDate=i.StartDate
From InvoiceItems ii, Taxes t, Emerald..Invoices i
Where ii.InvoiceID = i.InvoiceID
	and ii.TaxID = t.TaxID
	and ii.ItemType in (254, 255)

GO

/*  Charges  */
SET IDENTITY_INSERT Charges ON
Insert Into Charges(ChargeID, CustomerID, Description, Amount, Quantity, 
		StartDate, EndDate, TaxID, ItemID, LastModifyDate, LastModifyUser, ChargeTypeID) 
	Select ChargeID, CustomerID, ISNULL(Description,convert(varchar, ChargeID)), Amount, 1, 
		LastModifyDate, LastModifyDate, TaxID, 
		CASE WHEN ItemID = 0 THEN NULL ELSE ItemID END, LastModifyDate, LastModifyUser, NULL 
	From Emerald..Charges 
SET IDENTITY_INSERT Charges OFF
GO

/*  CallHistory  */
INSERT INTO RateHistory(AccountID,StartDate,HistoryType,RateID,TotalCount,TotalTime,TotalData,ChargeID) 
SELECT AccountID, StartDate, 0, 0, SUM(Calls), SUM(Mins), 0, MIN(ChargeID)
FROM Emerald..CallHistory 
	WHERE AccountID IN (SELECT AccountID FROM Emerald..SubAccounts)
GROUP BY AccountID,StartDate
HAVING MIN(ChargeID) IN (SELECT ChargeID FROM Emerald..Charges)
GO

/*  ExternalTrans  */
SET IDENTITY_INSERT ExternalTrans ON
Insert Into ExternalTrans(ExternalTransID, CustomerID, InvoiceID, TransType, ReqDate, ProcDate, Amount, 
		PaymentID, ApproveCode, Response, LastModifyDate, LastModifyUser, 
		AccountNumber, AccountExpire, RebatchTries, LastRebatchTry, AuthName) 
	Select TransID, i.CustomerID, i.InvoiceID, TransType, ReqDate, ProcDate, et.Amount, 
		PaymentID, ApproveCode, Response + ' ' + PS2000, et.LastModifyDate, et.LastModifyUser, 
		'0', getdate(), 0, et.LastModifyDate,CONVERT(VARCHAR(50),ma.FirstName + ' ' + ma.LastName) AS CreditCardAuth
	From Emerald..ExternalTrans et, Emerald..Invoices i, MasterAccounts ma
	Where et.InvoiceID = i.InvoiceID
	AND ma.CustomerID = i.CustomerID
SET IDENTITY_INSERT ExternalTrans OFF
GO

/*  Configs  */
Insert Into Configs(ConfigID, ConfigType, Value, Data, ConfigGroupID, Description) 
	Select ConfigID, Type, Value, Data, 1, 'Unknown'
	From Emerald..Configs
	Where ConfigID IN (1, 5, 6, 8, 9, 13, 14, 27, 28, 29, 47, 50, 51, 52, 53, 55, 59)

Insert Into Configs(ConfigID, ConfigType, Value, Data, ConfigGroupID, Description) 
	Select CASE WHEN ConfigID = 60 THEN 61 WHEN ConfigID = 61 THEN 60 ELSE ConfigID END AS ConfigID, Type, 
	CASE WHEN ConfigID = 84 THEN Value + 200 ELSE Value END AS Value, Data, 1, 'Unknown'
	From Emerald..Configs
	Where ConfigID IN (60, 61, 62, 70, 71, 72, 73, 75, 76, 77, 78, 79, 80, 81, 82, 85)
GO

Update Configs Set ConfigGroupID = 1 Where ConfigID IN (0, 1, 2, 3, 4, 6, 7, 16, 20, 21)
--Update Configs Set ConfigGroupID = 2 Where ConfigID IN (30, 31, 32, 70, 71, 72)
Update Configs Set ConfigGroupID = 6 Where ConfigID IN (5, 8, 9, 10, 12, 13, 22)
Update Configs Set ConfigGroupID = 5 Where ConfigID BETWEEN 40 and 49
Update Configs Set ConfigGroupID = 4 Where ConfigID BETWEEN 50 and 59
Update Configs Set ConfigGroupID = 3 Where ConfigID BETWEEN 60 and 69
--Update Configs Set ConfigGroupID = 7 Where ConfigID BETWEEN 100 and 119
GO

Update Configs Set ConfigGroupID = 1, Description = 'Company Name' Where ConfigID = 0
Update Configs Set ConfigGroupID = 1, Description = 'Hide Passwords ' Where ConfigID = 1
Update Configs Set ConfigGroupID = 1, Description = 'Encrypt Passwords' Where ConfigID = 2
Update Configs Set ConfigGroupID = 1, Description = 'Restrict Expire' Where ConfigID = 3
Update Configs Set ConfigGroupID = 1, Description = 'Restrict Acct Delete' Where ConfigID = 4
Update Configs Set ConfigGroupID = 6, Description = 'Default Expire Grace Period (Days)' Where ConfigID = 5
Update Configs Set ConfigGroupID = 1, Description = 'Min Password Length' Where ConfigID = 6
Update Configs Set ConfigGroupID = 1, Description = 'Random Password Length' Where ConfigID = 7
Update Configs Set ConfigGroupID = 6, Description = 'Setup Free Period Before Billing (Days)' Where ConfigID = 8
Update Configs Set ConfigGroupID = 6, Description = 'Setup Expire Grace Period (Days)' Where ConfigID = 9
Update Configs Set ConfigGroupID = 6, Description = 'Incremental Batch' Where ConfigID = 10
Update Configs Set ConfigGroupID = 6, Description = 'No SubCost Rounding' Where ConfigID = 12
Update Configs Set ConfigGroupID = 6, Description = 'Batch Time Min' Where ConfigID = 13
Update Configs Set ConfigGroupID = 6, Description = 'Send Receipts' Where ConfigID = 14
Update Configs Set ConfigGroupID = 1, Description = 'Show SA Expire' Where ConfigID = 16
Update Configs Set ConfigGroupID = 1, Description = 'Referred By Change' Where ConfigID = 20
Update Configs Set ConfigGroupID = 1, Description = 'Sales Person Change' Where ConfigID = 21
Update Configs Set ConfigGroupID = 6, Description = 'External CC Batch' Where ConfigID = 22
--Update Configs Set ConfigGroupID = 2, Description = 'External File' Where ConfigID = 30
--Update Configs Set ConfigGroupID = 2, Description = 'External Log' Where ConfigID = 31
--Update Configs Set ConfigGroupID = 2, Description = 'External Radius' Where ConfigID = 32
Update Configs Set ConfigGroupID = 5, Description = 'Report Account' Where ConfigID = 40
Update Configs Set ConfigGroupID = 5, Description = 'Report Invoice' Where ConfigID = 41
Update Configs Set ConfigGroupID = 5, Description = 'Report InvoiceCC' Where ConfigID = 42
Update Configs Set ConfigGroupID = 5, Description = 'Global Reports Only' Where ConfigID = 48
Update Configs Set ConfigGroupID = 5, Description = 'Reports Default Dir' Where ConfigID = 49
Update Configs Set ConfigGroupID = 4, Description = 'Email Smart Host' Where ConfigID = 50
Update Configs Set ConfigGroupID = 4, Description = 'Email Domain' Where ConfigID = 51
Update Configs Set ConfigGroupID = 4, Description = 'Email Admin' Where ConfigID = 52
Update Configs Set ConfigGroupID = 4, Description = 'Email Accounts' Where ConfigID = 53
Update Configs Set ConfigGroupID = 4, Description = 'Email AutoSync' Where ConfigID = 59
Update Configs Set ConfigGroupID = 3, Description = 'FTP Allow Directories' Where ConfigID = 60
Update Configs Set ConfigGroupID = 3, Description = 'FTP Max Dir Size' Where ConfigID = 61
Update Configs Set ConfigGroupID = 3, Description = 'FTP Default DIR UNC' Where ConfigID = 62
Update Configs Set ConfigGroupID = 9, Description = 'CC Batch Out' Where ConfigID = 70
Update Configs Set ConfigGroupID = 9, Description = 'CC Batch In' Where ConfigID = 71
Update Configs Set ConfigGroupID = 9, Description = 'CC Batch Limit' Where ConfigID = 72

Update Configs set ConfigGroupID = 9, Description = 'CC Batch Merchant-ID' WHERE ConfigID = 75
Update Configs set ConfigGroupID = 9, Description = 'CC Batch Store' WHERE ConfigID = 76
Update Configs set ConfigGroupID = 9, Description = 'CC Batch Terminal' WHERE ConfigID = 77

Update Configs set ConfigGroupID = 10, Description = 'ACH Batch Out' WHERE ConfigID = 80
Update Configs set ConfigGroupID = 10, Description = 'ACH Batch In' WHERE ConfigID = 81
Update Configs set ConfigGroupID = 10, Description = 'ACH Batch Limit' WHERE ConfigID = 82
Update Configs set ConfigGroupID = 10, Description = 'ACH Batch Merchant-ID' WHERE ConfigID = 85

--Update Configs Set ConfigGroupID = 7, Description = 'Radius Debug Level' Where ConfigID = 100
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Log Level' Where ConfigID = 101
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Auth Port' Where ConfigID = 102
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Acct Port' Where ConfigID = 103
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Concurrency' Where ConfigID = 110
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Case Sense' Where ConfigID = 111
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Acct Authentic' Where ConfigID = 112
--Update Configs Set ConfigGroupID = 7, Description = 'Radius Encrypt Passwd' Where ConfigID = 113
GO

/* New Configs */

INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Report Server URL',48,48,5,0,1,'http://127.0.0.1')
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('EmerWeb Server URL',49,49,5,0,1,'http://127.0.0.1')

/*  RadRoamServers  */
SET IDENTITY_INSERT RadRoamServers ON
Insert Into RadRoamServers(RadRoamServerID, IPAddress, Server, Secret, Timeout, 
	Retries, TreatAsLocal, StripDomain, AuthPort, AcctPort) 
	Select RadRoamServerID, IPAddress, Server, Secret, Timeout, Retries, TreatAsLocal, StripDomain, 
	AuthPort, AcctPort 
	From Emerald..RadRoamServers 
SET IDENTITY_INSERT RadRoamServers OFF
GO

/*  ServerTypes  */
Insert Into ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) 
	Select ServerType, Vendor, Model, 0, NULL  
	From Emerald..ServerTypes WHERE ServerType NOT IN (SELECT ServerType FROM ServerTypes)
GO


/*  Servers  */
SET IDENTITY_INSERT Servers ON

declare @defst int
Select @defst = min(ServerType) From ServerTypes

Insert Into Servers(ServerID, Server, ServerType, IPAddress, Location, Ports, Modems, PhoneNumber, 
	ContactName, ContactPhone, ContactPage, Comments, DynamicStart, DynamicEnd, Secret, Community, 
	RadRoamServerID, CheckAccess, ServerGroupID) 
SELECT MIN(ServerID) AS ServerID, MIN(Server) AS Server, 
		ISNULL(CASE WHEN MIN(ServerType) NOT IN (SELECT ServerType FROM ServerTypes) THEN 10
		ELSE MIN(ServerType) END,0) AS ServerType, 
	MIN(IPAddress) AS IPAddress, MIN(Location) AS Location, MIN(Ports) AS Ports, MIN(Modems) AS Modems, MIN(PhoneNumber) AS PhoneNumber, 
	MIN(ContactName) AS ContactName, MIN(ContactPhone) AS ContactPhone, MIN(ContactPage) AS ContactPage, MIN(CONVERT(VARCHAR(255),Comments)) AS Comments,
	MIN(DynamicStart) AS DynamicStart , MIN(DynamicEnd) AS DynamicEnd, MIN(Secret) AS Secret, MIN(Community) AS Community, 
	MIN(RadRoamServerID) AS RadRoamServerID, NULL, 1
	From Emerald..Servers 
	GROUP BY IPAddress

SET IDENTITY_INSERT Servers OFF
GO

/*  ServerPorts  */
Insert Into ServerPorts(ServerID, Port, NASIdentifier, IPAddress, MaxSessionTime, CostPerMinute, Username, 
	AcctSessionID, AcctStatusType, CallDate, FramedAddress, CallerID, ConnectInfo, SNMPUser) 
	SELECT CASE WHEN sp.ServerID IS NULL THEN (SELECT MIN(ServerID) FROM Servers) ELSE sp.ServerID END, COALESCE(sp.Port,''), s.IPAddress, sp.IPAddress, sp.MaxSessionTime, sp.CostPerMinute, sp.Username, sp.AcctSessionID, 
	sp.AcctStatusType, sp.CallDate, sp.FramedAddress, sp.CallerID, sp.ConnectInfo, sp.SNMPUser 
	FROM Emerald..ServerPorts sp, Servers s
		WHERE s.ServerID = sp.ServerID
GO

/*  ServerAccess  */
Insert Into ServerAccess(ServerID, Port, AccountTypeID, StartTime, StopTime, MaxSessionLength) 
	Select ServerID, Port, at1.AccountTypeID, StartTime, StopTime, MaxSessionLength 
	From Emerald..ServerAccess sa, AccountTypes at1
	Where sa.AccountType = at1.AccountType
GO

/*  Operators  - default language to English*/
Insert Into Operators(OperatorGroupID, Operator, Password, Email, WebObjectAccess, LanguageID, Active) 
	Select 2, Operator, Password, Email, NULL, 1, 1 
	From Emerald..Operators 
	Where Operator <> 'Admin'
GO

/*  RadVendors  */
Insert Into RadVendors(RadVendorID, Name) 
	Select RadVendorID, Name 
	From Emerald..RadVendors 
	Where RadVendorID NOT IN (Select RadVendorID From RadVendors) 
GO

/*  RadAttributes  */
Insert Into RadAttributes(RadAttributeID, RadVendorID, RadVendorType, Name, RadAttributeType, 
	ReplyType, AliasAttributeID, AliasVendorID) 
	Select RadAttributeID, ISNULL(RadVendorID,0), ISNULL(RadVendorType,0), Name, Type, 0, NULL, NULL 
	From Emerald..RadAttributes ra1 
	Where NOT EXISTS (Select RadAttributeID From RadAttributes ra2 
		Where ra1.RadAttributeID = ra2.RadAttributeID 
			and ra2.RadVendorID = ISNULL(ra1.RadVendorID,0) 
			and ra2.RadVendorType = ISNULL(ra1.RadVendorType,0)) 
GO

/*  RadValues  */
Insert Into RadValues(RadAttributeID, RadVendorID, RadVendorType, Value, Name) 
	Select RadAttributeID, RadVendorID, RadVendorType, Value, Name 
	From Emerald..RadValues rv1 
	Where NOT EXISTS (Select RadAttributeID From RadValues rv2 
		Where rv1.RadAttributeID = rv2.RadAttributeID 
			and rv2.RadVendorID = ISNULL(rv1.RadVendorID,0) 
			and rv2.RadVendorType = ISNULL(rv1.RadVendorType,0) 
			and rv2.Value = rv1.Value) 
GO

/*  RadRoamDomains  */
SET IDENTITY_INSERT RadRoamDomains ON
Insert Into RadRoamDomains(RadRoamDomainID, RadRoamServerID, Domain, Priority, CostPerMinute, AccountTypeID) 
	Select RadRoamDomainID, RadRoamServerID, Domain, Priority, CostPerMinute, at1.AccountTypeID 
	From Emerald..RadRoamDomains rrd, AccountTypes at1
	Where rrd.AccountType *= at1.AccountType 
SET IDENTITY_INSERT RadRoamDomains OFF
GO

/*  RadConfigs  */
SET IDENTITY_INSERT RadConfigs ON
Insert Into RadConfigs(RadConfigID, AccountID, RadAttributeID, RadVendorID, RadVendorType, Data, Value, RadCheck) 
	Select RadConfigID, AccountID, RadAttributeID, ISNULL(RadVendorID,0), ISNULL(RadVendorType,0), Data, Value, COALESCE(RadCheck,0)
	From Emerald..RadConfigs 
SET IDENTITY_INSERT RadConfigs OFF
GO

/*  RadATConfigs  */
SET IDENTITY_INSERT RadATConfigs ON
Insert Into RadATConfigs(RadATConfigID, AccountTypeID, RadAttributeID, RadVendorID, RadVendorType, Data, Value, RadCheck) 
	Select RadATConfigID, at1.AccountTypeID, RadAttributeID, RadVendorID, RadVendorType, Data, Value, COALESCE(RadCheck,0)
	From Emerald..RadATConfigs rc, AccountTypes at1
	Where rc.AccountType = at1.AccountType
SET IDENTITY_INSERT RadATConfigs OFF
GO

/*  RadLogs  */ 
Insert Into RadLogs(RadLogMsgID, LogDate, Username, Data, NASIdentifier, NASPort, CallerID) 
	Select DISTINCT RadLogMsgID, LogDate, Username, Data, NASIdentifier, NASPort, CallerID 
	From Emerald..RadLogs 
GO

/*  RadRejects  */
IF object_id('Emerald..RadRejects') IS NOT NULL
BEGIN
SET IDENTITY_INSERT RadRejects ON
Insert Into RadRejects(RadRejectID, RadAttributeID, RadVendorID, RadVendorType, Data, Value) 
	Select RadRejectID, RadAttributeID, RadVendorID, RadVendorType, Data, Value 
	From Emerald..RadRejects 
SET IDENTITY_INSERT RadRejects OFF
END
GO

/*  IMailConfigs  */
If exists (select * from Emerald..sysobjects so where name = 'IMailConfigs') 
BEGIN

EXEC('INSERT INTO SubAccountData (AccountID,DataTypeID,Data)
SELECT imc.AccountID,sadt.DataTypeID,CONVERT(VARCHAR(64),imc.MaxSize)
FROM Emerald..IMailConfigs imc, SubAccountDataTypes sadt
	WHERE sadt.ExternalSystemType = -2
	AND sadt.Description = ''Max Mailbox Size''
	AND imc.MaxSize IS NOT NULL')

EXEC('INSERT INTO SubAccountData (AccountID,DataTypeID,Data)
SELECT imc.AccountID,sadt.DataTypeID,CONVERT(VARCHAR(64),imc.MaxMessages)
FROM Emerald..IMailConfigs imc, SubAccountDataTypes sadt
	WHERE sadt.ExternalSystemType = -2
	AND sadt.Description = ''MaxMsgs''
	AND imc.MaxMessages IS NOT NULL')

EXEC('INSERT INTO SubAccountData (AccountID,DataTypeID,Data)
SELECT imc.AccountID,sadt.DataTypeID,CONVERT(VARCHAR(64),imc.Type)
FROM Emerald..IMailConfigs imc, SubAccountDataTypes sadt
	WHERE sadt.ExternalSystemType = -2
	AND sadt.Description = ''Type''
	AND imc.Type IS NOT NULL')

EXEC('INSERT INTO SubAccountData (AccountID,DataTypeID,Data)
SELECT imc.AccountID,sadt.DataTypeID,CONVERT(VARCHAR(64),imc.Flags)
FROM Emerald..IMailConfigs imc, SubAccountDataTypes sadt
	WHERE sadt.ExternalSystemType = -2
	AND sadt.Description = ''Flags''
	AND imc.Flags IS NOT NULL')

EXEC('INSERT INTO SubAccountData (AccountID,DataTypeID,Data)
SELECT imc.AccountID,sadt.DataTypeID,CONVERT(VARCHAR(64),imc.UserDir)
FROM Emerald..IMailConfigs imc, SubAccountDataTypes sadt
	WHERE sadt.ExternalSystemType = -2
	AND sadt.Description = ''UserDir''
	AND imc.UserDir IS NOT NULL')
END
GO

-- This should only be ran on a system that has no
-- statements and was upgraded from Emerald 2.5.  It will
-- create one opening statement with sent flag set that
-- contains the existing invoices for the account. 
-- It also requires instproc.sql to be ran first 

INSERT INTO Statements(CustomerID, StatementDate, SentDate, PrevBal, NewCharges, NewCredits, EndBal, End0Bal, End30Bal, End60Bal, End90Bal, End120Bal)
SELECT ma.CustomerID, COALESCE(DATEADD(dd,-1,(SELECT MAX(i.CreateDate) FROM Invoices i WHERE i.CustomerID = ma.CustomerID)),GETDATE()), GETDATE(), 0, ma.Balance, 0, ma.Balance, 0, 0, 0, 0, 0
FROM MasterAccounts ma WHERE ma.CustomerID IN (SELECT CustomerID FROM Invoices)
GO

UPDATE ma SET ma.LastStatementID = st.StatementID
FROM MasterAccounts ma, Statements st
	WHERE ma.CustomerID = st.CustomerID
	AND ma.LastStatementID IS NULL
GO

UPDATE i SET i.StatementID = st.StatementID
FROM Invoices i, Statements st
	WHERE i.CustomerID = st.CustomerID
	AND i.StatementID IS NULL
GO

UPDATE p1 SET p1.StatementID = st.StatementID
FROM Payments p1, Emerald..Payments p2, Statements st
	WHERE p1.CustomerID = st.CustomerID
	AND p1.PaymentID = p2.PaymentID
	AND p2.InvoiceID > 0
	AND p1.CustomerID = st.CustomerID
	AND p1.StatementID IS NULL
GO

-- Convert Calls.Status to RateTables.LastProcDate
UPDATE RateTables
SET LastProcDate = (SELECT MAX(CallDate) FROM Emerald..Calls (NOLOCK) WHERE Status IS NOT NULL)
	WHERE RateTableID = 1
GO
