/* instproc.sql */

CREATE PROCEDURE History @CustomerID int AS

DECLARE @sd datetime
select @sd = DateAdd(Day, 0-120, GetDate())

Select i.CreateDate, 'Invoice' as Type, Amount,  
	CASE WHEN i.InvoiceTypeID = 0 THEN 'VOID ' + convert(varchar, LastModifyDate) ELSE it.InvoiceType END as Description,
	 InvoiceID as ID, 'invoice_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&InvoiceID=' + convert(varchar, InvoiceID) as URL
From Invoices i, InvoiceTypes it
Where CustomerID = @CustomerID
	and i.InvoiceTypeID = it.InvoiceTypeID
	and i.CreateDate > @sd
UNION ALL
Select s.StatementDate as CreateDate, 'Statement' as Type, EndBal as Amount,  
	'' as Description, StatementID as ID, 'statement_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&StatementID=' + convert(varchar, StatementID) as URL
From Statements s
Where CustomerID = @CustomerID
	and s.StatementDate > @sd
UNION ALL
Select i.CreateDate, 'Incident', 0, Convert(varchar(128),i.Description), IncidentID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
	and i.CreateDate > @sd
UNION ALL
Select a.CreateDate, 'Action', 0, Convert(varchar(128),a.Description), ActionID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Actions a, Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
		And a.IncidentID = i.IncidentID
	and a.CreateDate > @sd
UNION  ALL
Select LastModifyDate, 'Adjustment', Quantity * Amount AS Amount, Login + ' '
+ Description as Description, ChargeID,
        CASE WHEN ItemID IS NOT NULL THEN 'none' ELSE
'mbr_adjustment_edit.ews?CustomerID=' + convert(varchar, @CustomerID) +
'&ChargeID=' + convert(varchar, ChargeID)END  as URL
        From Charges
        Where CustomerID = @CustomerID
                AND ItemID IS NULL
        and LastModifyDate > @sd
UNION ALL
Select p.CreateDate, 'Payment', p.Amount, Description =
         CASE
           WHEN PaymentType='Check' OR PaymentType='Money Order'
             THEN PaymentType + '# ' + CheckNumber + '  ' + PayInfo
           ELSE PaymentType + '  ' + PayInfo
         END, PaymentID,
	'none' as URL
	From Payments p, PaymentTypes pt
	Where p.PaymentTypeID = pt.PaymentTypeID
		AND CustomerID = @CustomerID
	and p.CreateDate > @sd
UNION ALL
Select ReqDate as CreateDate, 'ETrans', Amount, 
	CASE TransType WHEN 0 THEN 'Awaiting Export' 
			WHEN 1 THEN 'Awaiting Results'
			ELSE Response END AS Response, ExternalTransID, 'none' as URL
	From ExternalTrans
	Where CustomerID = @CustomerID
		and ReqDate > @sd
Order by CreateDate DESC
GO

CREATE PROCEDURE CustomerHistory @CustomerID int AS

DECLARE @sd datetime
select @sd = DateAdd(Day, 0-120, GetDate())

Select i.CreateDate, 'Invoice' as Type, Amount,  
	CASE WHEN i.InvoiceTypeID = 0 THEN 'VOID ' + convert(varchar, LastModifyDate) ELSE it.InvoiceType END as Description,
	 InvoiceID as ID, 'invoice_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&InvoiceID=' + convert(varchar, InvoiceID) as URL
	From Invoices i, InvoiceTypes it
	Where CustomerID = @CustomerID
		And i.InvoiceTypeID = it.InvoiceTypeID
		And i.CreateDate > @sd
UNION ALL
Select s.StatementDate as CreateDate, 'Statement' as Type, EndBal as Amount,  
	'' as Description, StatementID as ID, 'statement_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + '&StatementID=' + convert(varchar, StatementID) as URL
	From Statements s
	Where CustomerID = @CustomerID
		And s.StatementDate > @sd
UNION ALL
Select i.CreateDate, 'Incident', 0, Convert(varchar,i.Description), IncidentID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
		And i.CreateDate > @sd
		And i.Hide = 0
UNION ALL
Select a.CreateDate, 'Action', 0, Convert(varchar,a.Description), ActionID,
	'incident_detail.ews?CustomerID=' + convert(varchar, @CustomerID) + 
		'&IncidentID=' + convert(varchar, i.IncidentID) +
		'&AccountID=' + convert(varchar, s.AccountID)  as URL
	From Actions a, Incidents i, SubAccounts s
	Where s.CustomerID = @CustomerID
		And i.AccountID = s.AccountID
		And a.IncidentID = i.IncidentID
		And a.CreateDate > @sd
		And a.Hide = 0
UNION  ALL
Select LastModifyDate, 'Adjustment', Amount, Login + ' ' + Description as Description, ChargeID,
	'none' as URL
	From Charges
	Where CustomerID = @CustomerID
		And ItemID IS NULL
		And LastModifyDate > @sd
UNION ALL
Select p.CreateDate, 'Payment', p.Amount, Description =
         CASE
           WHEN PaymentType='Check' OR PaymentType='Money Order'
             THEN PaymentType + '# ' + CheckNumber + '  ' + PayInfo
           ELSE PaymentType + '  ' + PayInfo
         END, PaymentID,
	'none' as URL
	From Payments p, PaymentTypes pt
	Where p.PaymentTypeID = pt.PaymentTypeID
		And CustomerID = @CustomerID
		And p.CreateDate > @sd
UNION ALL
Select ReqDate as CreateDate, 'ETrans', Amount, 
	CASE TransType WHEN 0 THEN 'Awaiting Export' 
			WHEN 1 THEN 'Awaiting Results'
			ELSE Response END AS Response, ExternalTransID, 'none' as URL
	From ExternalTrans
	Where CustomerID = @CustomerID
		and ReqDate > @sd
Order by CreateDate DESC
GO


CREATE PROCEDURE VerifyMailUser @username varchar(40), @domain varchar(40), @esid integer AS
CREATE TABLE #AccountIDs (AccountID INT)
INSERT INTO #AccountIDs
SELECT AccountID FROM SubAccounts WHERE Email = @username + '@' + @domain
UNION
SELECT AccountID FROM SubAccounts sa, Domains d WHERE sa.Login = @username AND sa.DomainID = d.DomainID AND d.MailDomain = @domain

DELETE #AccountIDs
FROM #AccountIDs ai, SubAccounts sa, MasterAccounts ma
	WHERE ai.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND (sa.Active <> 1 OR ma.Active <> 1)

IF (SELECT COUNT(AccountID) FROM #AccountIDs) = 0
INSERT INTO #AccountIDs
SELECT AccountID FROM Aliases WHERE Alias = @username + '@' + @domain

SELECT Login, Login AS Shell, Email,@domain AS MailDomain,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) OR DateAdd(Day, (sa.Extension+COALESCE(ma.OverDue,0)+1), sa.ExpireDate) < GetDate()
THEN RIGHT(CONVERT(VARCHAR(20),RAND()),4) + RIGHT(CONVERT(VARCHAR(20),RAND()),4)
ELSE sa.Password END AS Password, HomeDir
	From MasterAccounts ma, SubAccounts sa, AccountTypes at1, Domains d, #AccountIDs ai
	WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountID = ai.AccountID
		AND at1.AccountTypeID = sa.AccountTypeID
		AND at1.ExternalSystemID = @esid
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ma.StartDate < GETDATE()
ORDER BY Email DESC

DROP TABLE #AccountIDs
GO

CREATE PROCEDURE VerifyFTPUser @username varchar(40) AS
DECLARE @globallimit INT
SELECT @globallimit = Value FROM Configs WHERE ConfigID = 61
Select AccountID, Login, Login AS Shell,sa.Password, HomeDir, 
CASE WHEN HomeDirLimit IS NULL THEN @globallimit ELSE HomeDirLimit END AS HomeDirLimit
	From MasterAccounts ma, SubAccounts sa
	Where ma.CustomerID = sa.CustomerID
		AND sa.CustomerID=ma.CustomerID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ((ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) OR (DATEADD(Day,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) > GETDATE()))
		AND (Login = @username or Email = @username)
		AND ma.StartDate < GETDATE()
GO

CREATE PROCEDURE VerifyNewsUser @username varchar(40) AS
SELECT Login, Login AS Shell, sa.Password, at1.AccountType
	FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ((ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) OR (DATEADD(Day,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) < GETDATE()))
		AND ma.StartDate < GETDATE()
		AND Login=@username
GO

CREATE PROCEDURE ListMailUsers @esid integer AS

Select Login, Login AS Shell, Email, d.MailDomain, Password, HomeDir 
From MasterAccounts ma, SubAccounts sa, Domains d, AccountTypes at1 
Where ma.CustomerID = sa.CustomerID
 AND sa.DomainID = d.DomainID
 AND at1.AccountTypeID = sa.AccountTypeID
 AND at1.ExternalSystemID = @esid

UNION ALL

Select Login, Login AS Shell, Email=a.Alias, d.MailDomain, Password, HomeDir 
From MasterAccounts ma, SubAccounts sa, Domains d, Aliases a, AccountTypes at1 
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.DomainID = d.DomainID
	AND sa.AccountID = a.AccountID
	AND at1.AccountTypeID = sa.AccountTypeID
	AND at1.ExternalSystemID = @esid
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()
GO

IF object_id('IMailUsers') IS NOT NULL
	DROP PROCEDURE IMailUsers
go

CREATE PROCEDURE IMailUsers @esid INT, @username varchar(40), @domain varchar(64) AS
DECLARE @DomainID INT, @AccountID INT
SET NOCOUNT ON

SELECT @DomainID = DomainID FROM Domains WHERE MailDomain = @domain

IF (@username IS NULL) /* List all users in domain */
BEGIN

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'UserDir') AS UserDir,
NULL AS NumTries,
NULL AS AttemptTime,
NULL AS NumTimesSuspended,
NULL AS LastLogin,
NULL AS SuspendUserAccount,
NULL AS ICalEnable,
NULL AS SpellEnable,
NULL AS NoOfSuggestions,
NULL AS Depth,
NULL AS Options,
NULL AS SpellChecking,
NULL AS PreviewSize,
NULL AS ConfirmOnDelete,
NULL AS DisplayCompletedTasks,
NULL AS EntryGranularity,
NULL AS StartTime,
NULL AS EndTime,
NULL AS MaxEventsToDisplay,
NULL AS MaxTasksToDisplay,
NULL AS MaxNotesToDisplay,
NULL AS MaxDailyRecurCount,
NULL AS MaxWeeklyRecurCount,
NULL AS MaxMonthlyRecurCount,
NULL AS MaxYearlyRecurCount,
NULL AS HoursClock,
NULL AS MaxNoOfSearchResultsPerPage,
NULL AS MaxEventTitleLength,
NULL AS MaxTaskTitleLength,
NULL AS StartDay,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Max Mailbox Size') AS MaxSize,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxMessages') AS MaxMessages,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Type') AS Type,
COALESCE((SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Flags'),'128') AS Flags,
NULL AS DefaultView,
NULL AS DefCalName,
NULL AS TimeZone

FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ''
	AND ((sa.Login <> '' AND sa.DomainID = @DomainID) 
		OR (sa.Email LIKE '%_@' + @domain))
	AND at1.AccountTypeID = sa.AccountTypeID
	AND at1.ExternalSystemID = @esid
	AND sa.Active = 1
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

END ELSE BEGIN /* Lookup user */

DECLARE
@UserDir VARCHAR(64), 
@NumTries VARCHAR(64), 
@AttemptTime VARCHAR(64), 
@NumTimesSuspended VARCHAR(64), 
@LastLogin VARCHAR(64), 
@SuspendUserAccount VARCHAR(64), 
@ICalEnable VARCHAR(64), 
@SpellEnable VARCHAR(64), 
@NoOfSuggestions VARCHAR(64), 
@Depth VARCHAR(64), 
@Options VARCHAR(64), 
@SpellChecking VARCHAR(64), 
@PreviewSize VARCHAR(64), 
@ConfirmOnDelete VARCHAR(64), 
@DisplayCompletedTasks VARCHAR(64), 
@EntryGranularity VARCHAR(64), 
@StartTime VARCHAR(64), 
@EndTime VARCHAR(64), 
@MaxEventsToDisplay VARCHAR(64), 
@MaxTasksToDisplay VARCHAR(64), 
@MaxNotesToDisplay VARCHAR(64), 
@MaxDailyRecurCount VARCHAR(64), 
@MaxWeeklyRecurCount VARCHAR(64), 
@MaxMonthlyRecurCount VARCHAR(64), 
@MaxYearlyRecurCount VARCHAR(64), 
@HoursClock VARCHAR(64), 
@MaxNoOfSearchResultsPerPage VARCHAR(64), 
@MaxEventTitleLength VARCHAR(64), 
@MaxTaskTitleLength VARCHAR(64), 
@StartDay VARCHAR(64), 
@MaxSize VARCHAR(64), 
@MaxMessages VARCHAR(64), 
@Flags VARCHAR(64), 
@Type VARCHAR(64), 
@DefaultView VARCHAR(64), 
@DefCalName VARCHAR(64), 
@TimeZone VARCHAR(64)

SELECT sadt.Description, sad.Data INTO #settings
FROM SubAccountData sad, SubAccountDataTypes sadt 
	WHERE sad.DataTypeID = sadt.DataTypeID 
	AND sadt.ExternalSystemType = -2
	AND sad.AccountID = @AccountID
	AND sad.Data IS NOT NULL

CREATE INDEX i_settings_Description ON #settings (Description)

SELECT @UserDir = Data FROM #settings WHERE Description = 'UserDir'
SELECT @NumTries = Data FROM #settings WHERE Description = 'NumTries'
SELECT @AttemptTime = Data FROM #settings WHERE Description = 'AttemptTime'
SELECT @NumTimesSuspended = Data FROM #settings WHERE Description = 'NumTimesSuspended'
SELECT @LastLogin = Data FROM #settings WHERE Description = 'LastLogin'
SELECT @SuspendUserAccount = Data FROM #settings WHERE Description = 'SuspendUserAccount'
SELECT @ICalEnable = Data FROM #settings WHERE Description = 'ICalEnable'
SELECT @SpellEnable = Data FROM #settings WHERE Description = 'SpellEnable'
SELECT @NoOfSuggestions = Data FROM #settings WHERE Description = 'NoOfSuggestions'
SELECT @Depth = Data FROM #settings WHERE Description = 'Depth'
SELECT @Options = Data FROM #settings WHERE Description = 'Options'
SELECT @SpellChecking = Data FROM #settings WHERE Description = 'SpellChecking'
SELECT @PreviewSize = Data FROM #settings WHERE Description = 'PreviewSize'
SELECT @ConfirmOnDelete = Data FROM #settings WHERE Description = 'ConfirmOnDelete'
SELECT @DisplayCompletedTasks = Data FROM #settings WHERE Description = 'DisplayCompletedTasks'
SELECT @EntryGranularity = Data FROM #settings WHERE Description = 'EntryGranularity'
SELECT @StartTime = Data FROM #settings WHERE Description = 'StartTime'
SELECT @EndTime = Data FROM #settings WHERE Description = 'EndTime'
SELECT @MaxEventsToDisplay = Data FROM #settings WHERE Description = 'MaxEventsToDisplay'
SELECT @MaxTasksToDisplay = Data FROM #settings WHERE Description = 'MaxTasksToDisplay'
SELECT @MaxNotesToDisplay = Data FROM #settings WHERE Description = 'MaxNotesToDisplay'
SELECT @MaxDailyRecurCount = Data FROM #settings WHERE Description = 'MaxDailyRecurCount'
SELECT @MaxWeeklyRecurCount = Data FROM #settings WHERE Description = 'MaxWeeklyRecurCount'
SELECT @MaxMonthlyRecurCount = Data FROM #settings WHERE Description = 'MaxMonthlyRecurCount'
SELECT @MaxYearlyRecurCount = Data FROM #settings WHERE Description = 'MaxYearlyRecurCount'
SELECT @HoursClock = Data FROM #settings WHERE Description = 'HoursClock'
SELECT @MaxNoOfSearchResultsPerPage = Data FROM #settings WHERE Description = 'MaxNoOfSearchResultsPerPage'
SELECT @MaxEventTitleLength = Data FROM #settings WHERE Description = 'MaxEventTitleLength'
SELECT @MaxTaskTitleLength = Data FROM #settings WHERE Description = 'MaxTaskTitleLength'
SELECT @StartDay = Data FROM #settings WHERE Description = 'StartDay'
SELECT @MaxSize = Data FROM #settings WHERE Description = 'Max Mailbox Size'
SELECT @MaxMessages = Data FROM #settings WHERE Description = 'MaxMessages'
SELECT @Flags = COALESCE(Data,'128') FROM #settings WHERE Description = 'Flags'
SELECT @Type = Data FROM #settings WHERE Description = 'Type'
SELECT @DefaultView = Data FROM #settings WHERE Description = 'DefaultView'
SELECT @DefCalName = Data FROM #settings WHERE Description = 'DefCalName'
SELECT @TimeZone = Data FROM #settings WHERE Description = 'TimeZone'

SELECT @AccountID = sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email)
		OR (@username + '@' + @domain IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = @esid

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
@UserDir AS UserDir,
@NumTries AS NumTries,
@AttemptTime AS AttemptTime,
@NumTimesSuspended AS NumTimesSuspended,
@LastLogin AS LastLogin,
@SuspendUserAccount AS SuspendUserAccount,
@ICalEnable AS ICalEnable,
@SpellEnable AS SpellEnable,
@NoOfSuggestions AS NoOfSuggestions,
@Depth AS Depth,
@Options AS Options,
@SpellChecking AS SpellChecking,
@PreviewSize AS PreviewSize,
@ConfirmOnDelete AS ConfirmOnDelete,
@DisplayCompletedTasks AS DisplayCompletedTasks,
@EntryGranularity AS EntryGranularity,
@StartTime AS StartTime,
@EndTime AS EndTime,
@MaxEventsToDisplay AS MaxEventsToDisplay,
@MaxTasksToDisplay AS MaxTasksToDisplay,
@MaxNotesToDisplay AS MaxNotesToDisplay,
@MaxDailyRecurCount AS MaxDailyRecurCount,
@MaxWeeklyRecurCount AS MaxWeeklyRecurCount,
@MaxMonthlyRecurCount AS MaxMonthlyRecurCount,
@MaxYearlyRecurCount AS MaxYearlyRecurCount,
@HoursClock AS HoursClock,
@MaxNoOfSearchResultsPerPage AS MaxNoOfSearchResultsPerPage,
@MaxEventTitleLength AS MaxEventTitleLength,
@MaxTaskTitleLength AS MaxTaskTitleLength,
@StartDay AS StartDay,
@MaxSize AS MaxSize,
@MaxMessages AS MaxMessages,
@Flags AS Flags,
@Type AS Type,
@DefaultView AS DefaultView,
@DefCalName AS DefCalName,
@TimeZone AS TimeZone
FROM SubAccounts sa
	WHERE sa.AccountID = @AccountID

DROP TABLE #settings
END
GO

-- IMailSetUser
IF object_id('IMailSetUser') IS NOT NULL
	DROP PROCEDURE IMailSetUser
GO

CREATE PROCEDURE IMailSetUser @esid INT, @username VARCHAR(40), @domain VARCHAR(64), @attribute VARCHAR(64), @value VARCHAR(64) AS
DECLARE @DomainID INT, @AccountID INT,  @DataTypeID INT, @oldpassword VARCHAR(32)

SELECT @DomainID = DomainID FROM Domains WHERE MailDomain = @domain

IF @DomainID IS NOT NULL
SELECT @AccountID = sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ''
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = @esid

IF @AccountID IS NOT NULL
BEGIN

SELECT @attribute = 'Max Mailbox Size' WHERE @attribute = 'MaxSize'

IF (@attribute = 'Password' AND @value IS NOT NULL AND DATALENGTH(@value) > 3)
	BEGIN
	SELECT @oldpassword = Password FROM SubAccounts WHERE AccountID = @AccountID
	UPDATE SubAccounts SET Password = @value WHERE AccountID = @AccountID
	INSERT INTO Incidents 
	(AccountID,CreateDate,Description,IncidentStateID,LastModifyDate,LastModifyUser,Operator)
	VALUES(@AccountID,getdate(),'Changed password via IMail from ''' + @oldpassword + ''' to ''' + @value + '''' ,0,getdate(),suser_name(),suser_name())
	END
ELSE IF @attribute IS NOT NULL
	BEGIN
	SELECT @DataTypeID = DataTypeID
	FROM SubAccountDataTypes
		WHERE ExternalSystemType = -2
		AND Description = @attribute
	IF @DataTypeID IS NULL
		BEGIN
		INSERT INTO SubAccountDataTypes (ExternalSystemType,AccountTypeID,Description,Hidden)
		VALUES(-2,NULL,@attribute,1)
		SELECT @DataTypeID = @@IDENTITY
		END

	UPDATE SubAccountData SET Data = @value WHERE AccountID = @AccountID AND DataTypeID = @DataTypeID
	IF @@ROWCOUNT = 0
		INSERT INTO SubAccountData (AccountID,DataTypeID,Data) VALUES(@AccountID,@DataTypeID,@value)
	END
END
go

CREATE PROCEDURE ChangeMailUserPassword @login varchar(64), @domain varchar(64), @password varchar(16), @esid integer AS

Update SubAccounts
Set Password = @password
From SubAccounts sa, Domains d, AccountTypes at1 
 WHERE sa.DomainID = d.DomainID
 AND at1.AccountTypeID = sa.AccountTypeID
 AND at1.ExternalSystemID = @esid
 AND (
	(sa.Login = @login AND d.MailDomain = @domain)
	OR
	(sa.Email = @login + '@' + @domain)
     )
GO

CREATE PROCEDURE SendMailUsers AS

Select Email AS EmailAddress, FullName = sa.FirstName + ' ' + sa.LastName
From MasterAccounts ma, SubAccounts sa
Where ma.CustomerID = sa.CustomerID
	and sa.Email IS NOT NULL
	and sa.Email <> ' '
	and ma.Active <> 0 and sa.Active <> 0
	and (DateDiff(Month, ExpireDate, GetDate()) <= 1
		OR ma.OverLimit > 0 AND ma.OverLimit < (ma.Balance + ma.PendingDebit - ma.PendingCredit))
	AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())

UNION

Select sa.Login + '@' + d.MailDomain as EmailAddress, sa.FirstName + ' ' + sa.LastName as FullName
From MasterAccounts ma, SubAccounts sa, Domains d
Where ma.CustomerID = sa.CustomerID
	and sa.DomainID = d.DomainID
	and sa.Login IS NOT NULL
	and sa.Login != ' '
	and (sa.Email IS NULL or sa.Email = ' ')
	and ma.Active <> 0 and sa.Active <> 0
	AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
	and (DateDiff(Month, ExpireDate, GetDate()) <= 1
		OR ma.OverLimit > 0 AND ma.OverLimit < (ma.Balance + ma.PendingDebit - ma.PendingCredit))

Order By EmailAddress
GO

CREATE PROCEDURE RadCheckOnline @Username varchar(64), @accountid INT AS
Select Count(*) From ServerPorts WHERE (((@accountid IS NULL OR AccountID IS NULL) AND Username=@Username) OR (@accountid IS NOT NULL AND AccountID=@accountid)) and AcctStatusType IN (1,3) AT ISOLATION READ UNCOMMITTED
GO

CREATE PROCEDURE RadCheckTrigger @AccountID int AS
Select FileName, Parameters, Directory, TriggerType from RadTriggers Where AccountID=@AccountID
GO

CREATE PROCEDURE RadDNISCache AS
Select at1.AccountType, dn.DNISNumber
FROM AccountTypes at1, DNISNumbers dn
	WHERE at1.DNISGroupID = dn.DNISGroupID
GO

CREATE PROCEDURE RadServerAccessCache AS
Select MaxSessionLength, StartTime, StopTime, s.IPAddress, sa.Port, at1.AccountType
From Servers s, ServerAccess sa, AccountTypes at1
	WHERE s.ServerID = sa.ServerID
	AND sa.AccountTypeID = at1.AccountTypeID
GO

CREATE PROCEDURE RadGetConfigs @AccountID int AS
Select ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadVendorType, rc.RadCheck, rc.Tag
From RadConfigs rc, RadAttributes ra
Where ra.RadAttributeID=rc.RadAttributeID
	AND ra.RadVendorID = rc.RadVendorID
	AND ra.RadVendorType = rc.RadVendorType
	AND rc.AccountID=@AccountID
ORDER BY rc.RadConfigID
GO

CREATE PROCEDURE RadGetPoolConfigs (@AccountTypeID int, @ServerID int, @NASIdentifier varchar(16), @NASPort VARCHAR(10), @accountid INT, @callerid VARCHAR(20), @dnis VARCHAR(20)) AS
SET ROWCOUNT 1
SET NOCOUNT ON
DECLARE @ip VARCHAR(16)

UPDATE RadIPAddresses SET State = 0
	WHERE NASIdentifier = @NASIdentifier
	AND NASPort = @NASPort
	AND (State = 2
		OR (State = 1 AND LastUsed < DATEADD(mi,-2,getdate())))

Select @ip=ria.IPAddress
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	and riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	and riat.AccountTypeID = @AccountTypeID
	and s.ServerID = @ServerID
	and State = 0
Order By riat.Priority, ria.LastUsed

IF @ip IS NULL
BEGIN
Select @ip=ria.IPAddress
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID *= rig.RadIPGroupID
	AND ria.RadIPGroupID *= rig.RadIPGroupID
	and riat.AccountTypeID = @AccountTypeID
	AND s.ServerID = @ServerID
	AND State = 0
Order By riat.Priority, ria.LastUsed
END

IF @ip IS NULL
BEGIN
Select @ip=ria.IPAddress
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID *= rig.RadIPGroupID
	AND ria.RadIPGroupID *= rig.RadIPGroupID
	and (riat.AccountTypeID = @AccountTypeID OR riat.AccountTypeID IS NULL)
	AND s.ServerID = @ServerID
	AND State = 0
Order By riat.Priority, ria.LastUsed
END

IF @ip IS NOT NULL
	BEGIN
	Update RadIPAddresses
		Set LastUsed = getdate(), State = 1, NASIdentifier = @NASIdentifier, NASPort = @NASPort
		Where IPAddress = @ip

	Select 8 as AttributeID,0 as VendorID, 0 as Value, @ip as Data
	END
GO

CREATE PROCEDURE RadCheckOnlineSNMP @Username varchar(64), @accountid INT AS 
SELECT s.IPAddress, st.SNMPType, s.Community, sp.SNMPUser, sp.AcctSessionID
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE (((@accountid IS NULL OR sp.AccountID IS NULL) AND sp.Username=@Username)
		OR (@accountid IS NOT NULL AND sp.AccountID=@accountid))
	AND sp.AcctStatusType IN (1,3)
	AND s.ServerType = st.ServerType
	AND s.ServerID = sp.ServerID
	AND sp.SNMPUser IS NOT NULL
	AND s.Community IS NOT NULL
AT ISOLATION READ UNCOMMITTED
GO

/* These are for radusers */

CREATE PROCEDURE RU_AT AS
SELECT AccountType, rc.AccountTypeID, ra.RadAttributeID, ra.ReplyType, rc.Data, rc.Value, rc.RadCheck, ra.Name
    From RadATConfigs rc, RadAttributes ra, AccountTypes at1
    Where rc.RadAttributeID = ra.RadAttributeID
	AND rc.RadVendorID = ra.RadVendorID
	AND rc.RadVendorType = ra.RadVendorType
      AND rc.AccountTypeID = at1.AccountTypeID 
    Order by rc.AccountTypeID, ra.RadAttributeID
GO

CREATE PROCEDURE RU_RATC AS
SELECT sa.Login, sa.Password, att.AccountType, 
SubExpire=DateAdd(Day, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
   From MasterAccounts ma, SubAccounts sa, AccountTypes att
    Where ma.CustomerID = sa.CustomerID
 	AND ( ExpireDate >= GetDate() or ExpireDate is NULL)
 	AND sa.Login is not NULL and sa.Password is not NULL
        AND ma.Active = 1 AND sa.Active = 1 AND
        sa.AccountTypeID = att.AccountTypeID
AND NOT EXISTS (
Select * From RadConfigs rc where sa.AccountID = rc.AccountID
)
AND EXISTS (
Select * From RadATConfigs rat where sa.AccountTypeID = rat.AccountTypeID
)
GO

CREATE PROCEDURE RU_RC AS
SELECT sa.Login, sa.Password, ra.Name, ra.ReplyType, rc.Data, rc.Value, rc.RadCheck,
DateAdd(Day, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
    From MasterAccounts ma, SubAccounts sa, RadConfigs rc, RadAttributes ra
    Where ma.CustomerID = sa.CustomerID
AND rc.AccountID = sa.AccountID
AND ra.RadAttributeID = rc.RadAttributeID
 	AND sa.Login is not null and sa.Password is not null
 	AND (ExpireDate >= GetDate() or ExpireDate is NULL)
        AND ma.Active = 1 AND sa.Active = 1
   Order BY sa.Login, rc.RadCheck DESC
GO

CREATE PROCEDURE UpdateCalls_ServerID AS
DECLARE @nasid varchar(16), @sid int 

Select NASIdentifier, ServerID=0
Into #temp_serverupdate
From Calls
Where ServerID IS NULL
Group by NASIdentifier

Update #temp_serverupdate
Set ServerID = (Select ServerID from Servers Where #temp_serverupdate.NASIdentifier = IPAddress)

DECLARE cu_cursor CURSOR 
FOR Select NASIdentifier, ServerID From #temp_serverupdate

OPEN cu_cursor

FETCH cu_cursor INTO @nasid, @sid
WHILE (@@sqlstatus <> 2)
	BEGIN
	Update Calls
	Set ServerID = @sid
	Where ServerID is NULL
		AND NASIdentifier = @nasid

	FETCH cu_cursor INTO @nasid, @sid
	END

CLOSE cu_cursor
DEALLOCATE CURSOR cu_cursor

drop table #temp_serverupdate
GO

CREATE PROCEDURE UpdateCalls_AccountID @rtid INT AS
DECLARE @username varchar(40), @acctid int, @lastprocdate DATETIME

SELECT @lastprocdate = COALESCE(LastProcDate,'Jan 1 2000') FROM RateTables WHERE RateTableID = @rtid

Select Login, AccountID
Into #accountlist
From SubAccounts

CREATE INDEX iTA_Login ON #accountlist(Login)

Select Username, AccountID=0
Into #accountupdate
From Calls
	WHERE AccountID IS NULL
	AND Username in (Select Login From #accountlist)
	AND AcctStatusType = 2
	AND CallDate >= @lastprocdate
Group by Username

CREATE INDEX iTA_Username ON #accountupdate(Username)

Update #accountupdate
Set AccountID = (Select Min(AccountID) From #accountlist
	 Where #accountupdate.Username = Login)

DECLARE cu_cursor CURSOR
FOR Select Username, AccountID From #accountupdate

OPEN cu_cursor

FETCH cu_cursor INTO @username, @acctid
WHILE (@@sqlstatus <> 2)
	BEGIN
	Update Calls
	Set AccountID = @acctid
		WHERE AccountID is NULL
		AND Username = @username
		AND AcctStatusType = 2
		AND CallDate >= @lastprocdate
	FETCH cu_cursor INTO @username, @acctid
	END

CLOSE cu_cursor
DEALLOCATE CURSOR cu_cursor

drop table #accountlist
drop table #accountupdate
GO


CREATE PROCEDURE CheckDatabase AS
DBCC CheckDB
GO

CREATE PROCEDURE DeleteStartRecords AS
Delete From Calls Where AcctStatusType <> 2
GO

CREATE PROCEDURE TrimCalls AS
SET NOCOUNT ON

DECLARE @stoponly INT, @calls INT
DECLARE @stopdate datetime, @callsdate datetime

SELECT @calls = Value FROM Configs WHERE ConfigID = 205
SELECT @stoponly = Value FROM Configs WHERE ConfigID = 206

SELECT  @stopdate = DATEADD(dd,-(@stoponly),getdate()),
	@callsdate= DATEADD(dd,-(@calls),getdate())

if (@calls <> 0 AND @calls IS NOT NULL AND @stoponly <> 0 AND @stoponly IS NOT NULL)
	DELETE FROM Calls 
		WHERE (AcctStatusType IN (1,3) AND CallDate < @stopdate)
		OR CallDate < @callsdate

ELSE IF (@calls <> 0 AND @calls IS NOT NULL)
	DELETE FROM Calls WHERE CallDate < @callsdate

ELSE IF (@stoponly <> 0 AND @stoponly IS NOT NULL)
	DELETE FROM Calls WHERE AcctStatusType IN (1,3) AND CallDate < @stopdate
GO

CREATE PROCEDURE TrimLogs AS
DECLARE @radlogs INT, @auditlogs INT, @syslogs INT, @logs INT, @schedlogs INT, @serverports INT

SELECT @radlogs = Value FROM Configs WHERE ConfigID = 200
SELECT @schedlogs = Value FROM Configs WHERE ConfigID = 201
SELECT @auditlogs = Value FROM Configs WHERE ConfigID = 202
SELECT @syslogs = Value FROM Configs WHERE ConfigID = 203
SELECT @logs = Value FROM Configs WHERE ConfigID = 204
SELECT @serverports = Value FROM Configs WHERE ConfigID = 207

IF (@radlogs IS NOT NULL AND @radlogs <> 0)
	DELETE FROM RadLogs WHERE LogDate < DATEADD(dd,-(@radlogs),getdate())

IF (@auditlogs IS NOT NULL AND @auditlogs <> 0)
	DELETE FROM AuditLogs WHERE LogDate < DATEADD(dd,-(@auditlogs),getdate()) 

IF (@syslogs IS NOT NULL AND @syslogs <> 0)
	DELETE FROM SysLogs WHERE LogDate < DATEADD(dd,-(@syslogs),getdate()) 

IF (@logs IS NOT NULL AND @logs <> 0)
	DELETE FROM Logs WHERE LogDate < DATEADD(dd,-(@logs),getdate()) 

IF (@schedlogs IS NOT NULL AND @schedlogs <> 0)
	DELETE FROM ScheduleLogs WHERE EndDate < DATEADD(dd,-(@schedlogs),getdate())

IF (@serverports IS NOT NULL AND @serverports <> 0)
	DELETE FROM ServerPorts
	FROM ServerPorts sp, Servers s
		WHERE sp.ServerID = s.ServerID
		AND sp.CallDate < DATEADD(dd,-(@serverports),getdate())
		AND sp.SNMPUser IS NULL
		AND sp.NASIdentifier <> s.IPAddress
GO

CREATE PROCEDURE RadGetCacheUsers @date DATETIME, @flag SMALLINT AS
IF (@flag = 1)
BEGIN
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountTypeID, sa.LoginLimit, sa.TimeLeft * 60,
MasterExpire=CASE WHEN CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
0 AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.Login <> ''
	AND (sa.LastModifyDate > @date OR ma.LastModifyDate > @date)
END ELSE IF (@flag = 2)
BEGIN
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60,
MasterExpire=CASE WHEN CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.Login <> ''
	AND (sa.LastUsed > @date OR sa.LastUsed IS NULL)
END
GO

CREATE PROCEDURE RadGetUser @user VARCHAR(64) , @password VARCHAR(32) AS
SELECT sa.AccountID, sa.Login, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60, 
MasterExpire=CASE WHEN CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
        WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
        AND sa.Login = @user
UNION ALL
SELECT sa.AccountID, sa.Email, sa.Password, NULL, at1.AccountType, sa.LoginLimit, sa.TimeLeft * 60, 
MasterExpire=CASE WHEN CancelDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',CancelDate) END,
SubExpire=CASE WHEN ExpireDate IS NULL THEN NULL ELSE DATEDIFF(Day,'19700101',DATEADD(Day,sa.Extension+COALESCE(ma.OverDue,0),ExpireDate)) END,
CASE WHEN ma.OverLimit > 0 AND (ma.Balance + ma.PendingDebit - ma.PendingCredit) > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit, CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 0 ELSE CASE WHEN ma.StartDate IS NULL THEN 1 ELSE DATEDIFF(ss,'19700101',ma.StartDate) END END AS StartDate
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
        WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
        AND sa.Email = @user
GO


CREATE PROCEDURE RadRoamCache AS
Select Domain AS Label, Server, IPAddress, Secret, AuthPort, AcctPort,
Priority, Timeout, Retries, StripDomain, TreatAsLocal, at1.AccountType, rrs.RateTarget, rrs.RateMax
From RadRoamDomains rrd, RadRoamServers rrs, AccountTypes at1
	Where rrd.RadRoamServerID = rrs.RadRoamServerID
	AND rrd.AccountTypeID *= at1.AccountTypeID
UNION
Select rrd2.Domain AS Label, Server, IPAddress, Secret, AuthPort,
AcctPort, rrd.Priority, Timeout, Retries, StripDomain, TreatAsLocal,
at1.AccountType, rrs.RateTarget, rrs.RateMax
From RadRoamDomains rrd, RadRoamServers rrs, RadRoamDomains rrd2, AccountTypes at1
        Where rrd.RadRoamServerID = rrs.RadRoamServerID
        AND rrd.Domain = 'DEFAULT'
	AND rrd.AccountTypeID = at1.AccountTypeID
UNION
Select CONVERT(VARCHAR(5),RadRoamServerID) AS Label, Server, IPAddress,
Secret, AuthPort, AcctPort, 0, Timeout, Retries, StripDomain,
TreatAsLocal, NULL, RateTarget, RateMax
From RadRoamServers
Order By Label,Priority
GO

CREATE PROCEDURE RadGetRejects AS
Select ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rr.RadVendorID, rr.RadVendorType
From RadAttributes ra, RadRejects rr
Where ra.RadAttributeID=rr.RadAttributeID
        AND ra.RadVendorID = rr.RadVendorID
        AND ra.RadVendorType = rr.RadVendorType
ORDER BY Data,Value
GO

CREATE PROCEDURE RadGetProxyAttributes AS
SELECT apg.RadProxyAttributeGroupID,apg.RadRoamServerID,ap.String,ap.SearchType,ap.RadAttributeID
FROM RadProxyAttributeGroups apg, RadProxyAttributes ap
	WHERE apg.RadProxyAttributeGroupID = ap.RadProxyAttributeGroupID
ORDER BY apg.Priority ASC, apg.RadProxyAttributeGroupID
GO

CREATE PROCEDURE CreateServerPorts (@serverid int) AS

SET NOCOUNT ON

DECLARE @i int, @j int, @ports int, @servertype int, @maxports int, @p1 int, @p2 int
DECLARE @snmptype int, @snmpbaseuser varchar(128), @snmpuser varchar(148)

if @serverid > 0 
BEGIN

Select @servertype = s.ServerType, @ports = Ports, @snmptype = SNMPType, @snmpbaseuser = SNMPUser
From Servers s, ServerTypes st
Where s.ServerID = @serverid
	and s.ServerType = st.ServerType

if @ports > 0
	BEGIN

	Delete From ServerPorts Where ServerID = @serverid

	Select @i = 0
	While @i < @ports
		BEGIN
		Select @maxports = 1
	
		if @servertype in (0, 2, 3, 4, 10)  -- Starts at 0, PMx
	                Select @p1 = @i

	        else if @servertype = 5		-- Max 4xxx T1
			BEGIN
			SELECT @p1 = 10000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1
			SELECT @p2 = 20000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1, @maxports = 2
			END

	        else if @servertype = 6		-- Max 4xxx E1
			BEGIN
			SELECT @p1 = 10000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1
			SELECT @p2 = 20000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1, @maxports = 2
			END

	        else if @servertype = 7		-- Max 1800
			BEGIN
			SELECT @p1 = 10000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1
			SELECT @p2 = 20000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1, @maxports = 2
			END

	        else if @servertype = 12	-- Microcom 6000
			BEGIN
			SELECT @p1 = 10000 + @i
			SELECT @p2 = 60000 + ((@i+1) * 100), @maxports = 2 -- Starts at 60100
			END

	        else if @servertype = 13	-- USR TC HyperARC: Slot-1*256+Port
			BEGIN                                            
	                If @ports <= 48
	                    select @p1 = round(@i / 4, 0) * 256 + (@i % 4)
	                Else
	                    select @p1 = round(@i / 24, 0) * 256 + (@i % 24)
			END

	        else 				-- Starts at 1, CompuTone, TNT, AS5200
	                Select @p1 = @i + 1
	
		Select @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then convert(varchar(10), @p1) ELSE '' END 
		INSERT INTO ServerPorts(ServerID, NASIdentifier, Port, SNMPUser)
		SELECT @serverid, s.IPAddress, CONVERT(VARCHAR(10),@p1), @snmpuser
		FROM Servers s
			WHERE s.ServerID = @serverid
	
		if @maxports = 2
			BEGIN
			Select @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then convert(varchar(10), @p2) ELSE '' END 
			INSERT INTO ServerPorts(ServerID, NASIdentifier, Port, SNMPUser) 
			SELECT @serverid, s.IPAddress, CONVERT(VARCHAR(10),@p2), @snmpuser
			FROM Servers s
				WHERE s.ServerID = @serverid
			END
	
		Select @i = @i + 1
		END
	
	Select 'Ports Created: ' + convert(varchar, @ports) as Results, @servertype as ServerType
	END
ELSE
	Select 'Server Has no ports defined for it' as Results, @servertype as ServerType

END
ELSE
	Select 'Invalid ServerID Parameter' as Results, @servertype as ServerType
GO

CREATE PROCEDURE ListDomainUsers @domain varchar(64), @esid INT AS
SET NOCOUNT ON
DECLARE @DomainID INT
SELECT @DomainID = DomainID FROM Domains WHERE MailDomain = @domain

IF (@DomainID IS NOT NULL)
SELECT COALESCE(sa.Login,SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)) AS Username
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login IS NOT NULL AND sa.DomainID = @DomainID) OR (sa.Login IS NULL AND sa.Email LIKE '%_@' + @domain))
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = @esid
AT ISOLATION READ UNCOMMITTED
go


/* SysLogGetFilter */
CREATE PROCEDURE SysLogGetFilter AS
SELECT IPAddress,Severity,SubString FROM SysLogFilters
GO

/* SysLog */
CREATE PROCEDURE SysLog (@crc SMALLINT, @severity TINYINT, @facility TINYINT, @srcip INT, @date VARCHAR(30), @msg VARCHAR(255) )AS

DECLARE @version INT, @icrc INT

SELECT @version = Version, @icrc = DefID 
FROM SysLogDefs 
WHERE DefID = @crc 
	AND Data = @msg

IF (@icrc IS NULL)
BEGIN
	SELECT @version = MAX(Version) FROM SysLogDefs WHERE DefID = @crc
	SELECT @version = CASE WHEN @version IS NULL THEN 1 
				WHEN @version IS NOT NULL THEN @version + 1
			 END

	INSERT INTO SysLogDefs(DefID,Version,Data) VALUES(@crc,@version,@msg)
END

INSERT INTO SysLogs (LogDate,DefID,Version,Severity,Facility,IPAddress)
VALUES(@date,@crc,@version,@severity,@facility,@srcip)
GO

CREATE PROCEDURE RadAtCache (@accounttype VARCHAR(30)) AS
SELECT at1.AccountType, ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadVendorType, rc.RadCheck, rc.Tag, at1.AccountTypeID
FROM RadATConfigs rc, RadAttributes ra, AccountTypes at1
	WHERE ra.RadAttributeID = rc.RadAttributeID
	AND rc.AccountTypeID = at1.AccountTypeID
	AND (ra.RadVendorID = rc.RadVendorID OR rc.RadVendorID IS NULL)
	AND (ra.RadVendorType = rc.RadVendorType OR rc.RadVendorType IS NULL)
	AND (@accounttype IS NULL OR at1.AccountType = @accounttype)
ORDER BY AccountType, rc.RadATConfigID
GO

Create Procedure Aging(@update int) AS

SET NOCOUNT ON

DECLARE @custid NUMERIC(10,0), @bal numeric(18,4), @a0 numeric(18,4), @a1 numeric(18,4), @a2 numeric(18,4), @a3 numeric(18,4), @a4 numeric(18,4)
DECLARE @msg varchar(64), @idays int, @amount numeric(18,4), @done int, @obal numeric(18,4)

Select CustomerID=0, Age0=convert(numeric(18,4), 0), Age30=convert(numeric(18,4), 0), Age60=convert(numeric(18,4), 0), Age90=convert(numeric(18,4), 0), Age120=convert(numeric(18,4), 0)
Into #temp_aging

create index itmp_customerid on #temp_aging(CustomerID)

DECLARE uc_cursor CURSOR FOR 
Select CustomerID, Balance
From MasterAccounts 
	WHERE Balance <> 0

OPEN uc_cursor

FETCH uc_cursor INTO @custid, @bal
WHILE (@@sqlstatus <> 2)
	BEGIN
	Select @a0=0, @a1=0, @a2=0, @a3=0, @a4=0, @done=0, @obal = @bal

	DECLARE ud_cursor CURSOR FOR 
	Select DateDiff(Day, i.CreateDate, GetDate()), Amount=(ii.Amount*Quantity)
	From Invoices i, InvoiceItems ii
	Where i.InvoiceID = ii.InvoiceID
		and i.CustomerID = @custid
		and i.InvoiceTypeID <> 0
		and i.StatementID IS NOT NULL
	Order By i.CreateDate DESC

	OPEN ud_cursor

	FETCH ud_cursor INTO @idays, @amount
	WHILE (@@sqlstatus <> 2 and @done = 0 )
		BEGIN

		if @amount > @bal  
			BEGIN
			select @amount = @bal, @done = 1
			END

		if @idays <= 29 (select @a0=@a0+@amount)
		else if @idays <= 59 (select @a1=@a1+@amount)
		else if @idays <= 89 (select @a2=@a2+@amount)
		else if @idays <= 119 (select @a3=@a3+@amount)
		else (select @a4=@a4+@amount)

		select @bal = @bal - @amount
	
		FETCH ud_cursor INTO @idays, @amount
		END

	CLOSE ud_cursor
	DEALLOCATE CURSOR ud_cursor

	Insert into #temp_aging(CustomerID, Age0, Age30, Age60, Age90, Age120)
 		VALUES(@custid, @a0, @a1, @a2, @a3, @a4)

	/* The update is suppose to go here, but its in statements now! */

	FETCH uc_cursor INTO @custid, @bal
	END

CLOSE uc_cursor
DEALLOCATE CURSOR uc_cursor

if @update <> 1 
	BEGIN
	Select ta.CustomerID, Age0, Age30, Age60, Age90, Age120, FirstName, LastName, Company, PhoneWork, PhoneHome, Active
	From #temp_aging  ta, MasterAccounts ma
	Where ta.CustomerID = ma.CustomerID
	Order By ta.CustomerID
	END

Drop table #temp_aging
GO

CREATE PROCEDURE CustomerAgingDetail(@custid int) AS
SET NOCOUNT ON

DECLARE @bal numeric(18,4), @a0 numeric(18,4), @a1 numeric(18,4), @a2
numeric(18,4), @a3 numeric(18,4), @a4 numeric(18,4)
DECLARE @msg varchar(64), @idays int, @amount numeric(18,4), @done int, @obal
numeric(18,4)
DECLARE @createdate datetime, @invid int, @agedate datetime, @slot varchar(16)

Select InvoiceID=0,  convert(varchar(16), ' ') as Days, convert(numeric(18,4),
0) AS Amount, GetDate() as CreateDate
Into #temp_aging

Select @bal = (Balance+PendingDebit-PendingCredit+ ISNULL((Select sum(Amount)
From Charges WHERE CustomerID = @custid AND ItemID IS NULL),0) )
From MasterAccounts
Where CustomerID = @custid

Select @a0=0, @a1=0, @a2=0, @a3=0, @a4=0, @done=0, @obal = @bal
DECLARE ud_cursor CURSOR FOR 

Select  DateDiff(Day, i.CreateDate, ISNULL(AgedDate, GetDate())) as Days,
i.Amount, 
	i.CreateDate, ISNULL(AgedDate, GetDate()) As AgedDate, i.InvoiceID
From Invoices i, MasterAccounts ma
Where i.CustomerID = ma.CustomerID
	and i.CustomerID = @custid
	and i.InvoiceTypeID <> 0
	and i.CreateDate < ISNULL(AgedDate, GetDate())
Order By i.CreateDate DESC

OPEN ud_cursor

FETCH ud_cursor INTO @idays, @amount,  @createdate, @agedate, @invid
WHILE (@@sqlstatus <> 2 and @done = 0  and @bal > 0)
	BEGIN

       if (@bal <=0) (select @idays=0, @done=1)
        else if @amount > @bal  (select @amount = @bal, @done = 1)

        if @idays <= 29 (select @a0=@a0+@amount, @slot = 'Current')
        else if @idays <= 59 (select @a1=@a1+@amount, @slot = convert(varchar,
@idays))
        else if @idays <= 89 (select @a2=@a2+@amount, @slot = convert(varchar,
@idays))
        else if @idays <= 119 (select @a3=@a3+@amount, @slot = convert(varchar,
@idays))
        else (select @a4=@a4+@amount)
        select @bal = @bal - @amount

        Insert into #temp_aging(InvoiceID, Days, Amount, CreateDate )
                VALUES(@invid, @slot, @amount, @createdate)

	FETCH ud_cursor INTO @idays, @amount, @createdate, @agedate, @invid
	END

CLOSE ud_cursor
DEALLOCATE CURSOR ud_cursor

Select InvoiceID, Days, Amount, CreateDate
From #temp_aging
Where InvoiceID > 0
Order By CreateDate
Drop table #temp_aging
GO

CREATE PROCEDURE BatchStatements (@custid int) AS
SET NOCOUNT ON
CREATE TABLE #t_ma (CustomerID INT)
CREATE TABLE #t_i (CustomerID INT, Amount NUMERIC(18,4), LastInvoiceID INT)
CREATE TABLE #t_p (CustomerID INT, Amount NUMERIC(18,4), LastPaymentID INT)

INSERT INTO #t_ma (CustomerID)
Select CustomerID
From Invoices Where StatementID IS NULL 
UNION
Select CustomerID
From Payments p Where StatementID IS NULL AND Amount > 0 AND NOT Exists 
	(Select StatementID From Statements s Where p.CustomerID = s.CustomerID AND StatementDate > DateAdd(mm, 0-1, GetDate()) )
UNION
Select CustomerID
From MasterAccounts ma Where Balance > 0 AND NOT Exists 
	(Select StatementID From Statements s Where ma.CustomerID = s.CustomerID AND StatementDate > DateAdd(mm, 0-1, GetDate()) )

INSERT INTO #t_i (CustomerID,Amount,LastInvoiceID)
SELECT i.CustomerID, SUM(i.Amount) AS Amount, MAX(i.InvoiceID) AS LastInvoiceID
FROM #t_ma t, Invoices i
	WHERE t.CustomerID = i.CustomerID
	AND i.StatementID IS NULL
	AND i.InvoiceTypeID <> 0
GROUP BY i.CustomerID

INSERT INTO #t_p (CustomerID,Amount,LastPaymentID)
SELECT p.CustomerID, SUM(p.Amount) AS Amount, MAX(p.PaymentID) AS LastPaymentID
FROM #t_ma t, Payments p
	WHERE t.CustomerID = p.CustomerID
	AND p.StatementID IS NULL
	AND p.PaymentTypeID <> 0
GROUP BY p.CustomerID

SELECT ma.CustomerID, ma.Balance, i.Amount AS NewCharges, i.LastInvoiceID, p.Amount AS NewCredits, p.LastPaymentID,
sm.Amount AS SM_Amount, sm.AmountType AS SM_AmountType, ma.FirstName + ' ' + ma.LastName as FullName, ma.Company 
FROM MasterAccounts ma, SendMethods sm, #t_ma t, #t_i i, #t_p p
	WHERE ma.CustomerID = t.CustomerID
	AND ma.SendMethodID *= sm.SendMethodID
	AND ma.CustomerID *= i.CustomerID
	AND ma.CustomerID *= p.CustomerID

DROP TABLE #t_ma
DROP TABLE #t_i
DROP TABLE #t_p
GO

CREATE PROCEDURE UpdateStatementAging(@sid NUMERIC(10,0), @custid NUMERIC(10,0), @endbal numeric(18,4)) AS

SET NOCOUNT ON

DECLARE @bal numeric(18,4), @a0 numeric(18,4), @a1 numeric(18,4), @a2 numeric(18,4), @a3 numeric(18,4), @a4 numeric(18,4)
DECLARE @idays int, @amount numeric(18,4), @done int

Select @a0=0, @a1=0, @a2=0, @a3=0, @a4=0, @done=0, @bal=@endbal

IF @bal > 0 BEGIN
DECLARE ud_cursor CURSOR FOR 
Select DateDiff(Day, i.CreateDate, ISNULL(AgedDate, GetDate())), Amount=(ii.Amount*Quantity)
From Invoices i, InvoiceItems ii, MasterAccounts ma
Where i.InvoiceID = ii.InvoiceID
	and i.CustomerID = ma.CustomerID
	and i.CustomerID = @custid
	and i.InvoiceTypeID <> 0
Order By i.CreateDate DESC

OPEN ud_cursor

FETCH ud_cursor INTO @idays, @amount
WHILE (@@sqlstatus <> 2 and @done = 0 )
	BEGIN

	if @amount > @bal  
		BEGIN
		select @amount = @bal, @done = 1
		END

	if @idays <= 29 (select @a0=@a0+@amount)
	else if @idays <= 59 (select @a1=@a1+@amount)
	else if @idays <= 89 (select @a2=@a2+@amount)
	else if @idays <= 119 (select @a3=@a3+@amount)
	else (select @a4=@a4+@amount)

	select @bal = @bal - @amount
	
	FETCH ud_cursor INTO @idays, @amount
	END

CLOSE ud_cursor
DEALLOCATE CURSOR ud_cursor
END

Update Statements
Set EndBal = @endbal, End0Bal = @a0, End30Bal = @a1, End60Bal = @a2, End90Bal = @a3, End120Bal = @a4
Where StatementID = @sid

GO

CREATE PROCEDURE CreateStatements AS
DECLARE @custid NUMERIC(10,0), @endbal numeric(18,4), @sid NUMERIC(10,0), @invamt numeric(18,4)

SET NOCOUNT ON

DECLARE s_cursor CURSOR FOR 
Select ma.CustomerID, Balance
From MasterAccounts ma, Statements s
Where ma.LastStatementID *= s.StatementID
	AND Active <> 0
	and isnull(StatementDate,GetDate()) < DateAdd(dd, 0-15, GetDate())

OPEN s_cursor

FETCH s_cursor INTO @custid, @endbal
WHILE (@@sqlstatus <> 2)
	BEGIN
	
	BEGIN TRANSACTION
	INSERT Into Statements(CustomerID, StatementDate, SentDate, PrevBal, EndBal, End0Bal, End30Bal, End60Bal, End90Bal, End120Bal)
	VALUES(@custid, GetDate(), NULL, @endbal, 0, 0, 0, 0, 0, 0)

	Select @sid=@@IDENTITY

	Select @endbal = @endbal + isnull(Sum(Amount),0)
	From Invoices
	Where CustomerID = @custid
		AND StatementID IS NULL

--	PRINT 'Customer: ' + convert(varchar, @custid) + '  End Bal: ' + convert(varchar, @endbal) 

	Update MasterAccounts
	Set Balance = @endbal, LastStatementID = @sid
	Where CustomerID = @custid

	Update Invoices
	Set StatementID = @sid
	Where CustomerID = @custid
		and StatementID IS NULL

	EXEC UpdateStatementAging @sid, @custid, @endbal

	COMMIT TRANSACTION
	FETCH s_cursor INTO @custid, @endbal
	END

CLOSE s_cursor
DEALLOCATE CURSOR s_cursor
GO

-- Scheduler Procedures
CREATE PROCEDURE ScheduleGetOnetime @ServerID INT AS
SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,1 AS MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID = @ServerID) OR ScheduleServerID = @ServerID)
	AND ((Status = 0) OR (Status = 1 AND (LockServerID = @ServerID OR ScheduleServerID = @ServerID)))
	AND Interval = 0
	AND Active = 1
GO

CREATE PROCEDURE ScheduleGetRecurring @ServerID INT AS
SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID = @ServerID) OR ScheduleServerID = @ServerID)
	AND Interval > 0
	AND Active = 1
GO

CREATE PROCEDURE ScheduleLocks AS
SELECT ScheduleID,TaskName
FROM Schedules
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL
	AND Active = 1
GO

CREATE PROCEDURE ScheduleLog @ScheduleID INT, @Status TINYINT, @Description VARCHAR(255), @StartDate DATETIME, @EndDate DATETIME AS
INSERT INTO ScheduleLogs (ScheduleID,Status,Description,StartDate,EndDate) VALUES(@ScheduleID,@Status,@Description, @StartDate,@EndDate)
UPDATE Schedules SET LastUpdate = getdate(),  Status = @Status, LastStatus = @Description  
	WHERE ScheduleID = @ScheduleID
	AND (LastUpdate < @EndDate OR LastUpdate IS NULL)
GO

CREATE PROCEDURE ScheduleSetLock @ServerID INT, @ScheduleID INT AS
UPDATE Schedules SET LockServerID = @ServerID 
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL 
	AND ScheduleID = @ScheduleID
GO

CREATE PROCEDURE ScheduleStaleLocks AS
UPDATE Schedules SET LockServerID = NULL
	WHERE ScheduleServerID IS NULL
	AND LockServerID IS NOT NULL
	AND ((Interval = 0 AND Status = 0 AND DATEADD(hh,1,StartDate) < getdate()) /* One time hasn't started within an hour of being scheduled */
		OR (Status = 1 AND DATEADD(hh,1,LastUpdate) < getdate()) /* Recurring or One time, no updates within an hour of last start */
		OR (Interval > 0 AND Status <> 1 AND LastStart IS NOT NULL AND LastUpdate < DATEADD(hh,-1,DATEADD(ss,-(Interval),getdate()))) /* Recurring non aligned */
	)
UPDATE Schedules SET LockServerID = NULL WHERE ScheduleServerID IS NOT NULL AND LockServerID IS NOT NULL
GO

CREATE PROCEDURE CheckGroupGlobal ( @groupid int ) as

Declare @err varchar(16)
Select @err = ''

IF NOT Exists (SELECT AccountTypeID From AccountTypes Where GroupID = @groupid)
	Select @err = 'Service Type'

else IF NOT Exists (SELECT BillingCycleID From BillingCycles Where GroupID = @groupid)
	Select @err = 'Billing Cycle'

else IF NOT Exists (SELECT RegionID From Regions Where GroupID = @groupid)
	Select @err = 'Region'

else IF NOT Exists (SELECT PayPeriodID From PayPeriods Where GroupID = @groupid)
	Select @err = 'Pay Period'

else IF NOT Exists (SELECT DiscountID From Discounts Where GroupID = @groupid)
	Select @err = 'Discounts'

if @err <> ''
	select @err as Missing
GO

CREATE Procedure UpdateServerHistory AS

Insert Into ServerHistory (ServerID, HistoryDate, Calls)
Select ServerID, GetDate(), count(*)
From ServerPorts
Where AcctStatusType=1
Group By ServerID
GO

CREATE PROCEDURE ExternalTransImport @PayMethodID INT, @transtime DATETIME AS
DECLARE @maxstatid INT

IF @PayMethodID = 2
BEGIN

SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1

INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry)
SELECT ma.CustomerID,NULL AS InvoiceID,0 AS TransType,getdate() AS ReqDate,NULL AS ProcDate,CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END >= 1
UNION ALL
SELECT ma.CustomerID, NULL AS InvoiceID, 0 AS TransType,getdate() AS ReqDate, NULL AS ProcDate, et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
cc.CardNumber AS AccountNumber,cc.ExpirationDate AS AccountExpire,cc.CardHolder AS AuthName,cc.BillToAddress1 AS AuthAddress,
cc.BillToZip AS AuthZip,cc.SecurityCode AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry
FROM ExternalTrans et, MasterAccounts ma, CreditCards cc
	WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND et.TransType = 7
	AND et.ReqDate < @transtime

UPDATE ExternalTrans SET TransType = 8 WHERE TransType = 7 AND ReqDate < @transtime

UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, CreditCards cc
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayMethodID = 2
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END >= 1
END
ELSE IF @PayMethodID = 3
BEGIN
SELECT @maxstatid = MAX(s.StatementID)
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = @PayMethodID
	AND s.SentDate IS NULL
	AND ma.Active = 1

INSERT INTO ExternalTrans (CustomerID,InvoiceID,TransType,ReqDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,RebatchTries,LastRebatchTry,BankName,BankNumber,BankTransType)
SELECT ma.CustomerID,NULL AS InvoiceID,100 AS TransType,getdate() AS ReqDate,NULL AS ProcDate,CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END AS Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END >= 1
UNION ALL
SELECT ma.CustomerID,NULL AS InvoiceID,100 AS TransType,getdate() AS ReqDate,NULL AS ProcDate,et.Amount,
NULL AS PaymentID,NULL AS ApproveCode,NULL AS Response,@transtime AS LastModifyDate, 'Export' AS LastModifyUser,
bt.AccountNumber AS AccountNumber,NULL AS AccountExpire,bt.AuthName AS AuthName,ma.Address1 AS AuthAddress,
ma.Zip AS AuthZip,NULL AS AuthSecurityCode,0 AS RebatchTries,getdate() AS LastRebatchTry, bt.BankName,bt.ABANumber AS BankNumber,bt.TransType AS BankTransType
FROM ExternalTrans et, MasterAccounts ma, BankTrans bt
	WHERE et.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND et.TransType = 107
	AND et.ReqDate < @transtime

UPDATE ExternalTrans SET TransType = 108 WHERE TransType = 107 AND ReqDate < @transtime

UPDATE Statements SET SentDate = getdate()
FROM Statements s, MasterAccounts ma, BankTrans bt
	WHERE s.CustomerID = ma.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayMethodID = 3
	AND s.SentDate IS NULL
	AND ma.Active = 1
	AND s.StatementID <= @maxstatid
	AND CASE WHEN (s.EndBal-s.PrevBal) > s.EndBal THEN s.EndBal ELSE (s.EndBal-s.PrevBal) END >= 1
END
GO

CREATE PROCEDURE CreditCardExport @transtime DATETIME AS
-- expmm and expyy must be %0.2d
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @batchinterval INT, @batchtries INT

SELECT @Merchant = Data FROM Configs WHERE ConfigID = 75
SELECT @Store = Value FROM Configs WHERE ConfigID = 76
SELECT @Terminal = Value FROM Configs WHERE ConfigID = 77
SELECT @batchinterval = Value FROM Configs WHERE ConfigID = 94
SELECT @batchtries = Value FROM Configs WHERE ConfigID = 93

EXEC ExternalTransImport 2

UPDATE ExternalTrans SET TransType = 0, RebatchTries = RebatchTries + 1
	WHERE LastModifyDate <= @transtime
	AND TransType = 3
	AND DATEADD(dd,@batchinterval,LastRebatchTry) <= @transtime
	AND RebatchTries < @batchtries

SELECT
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.AccountExpire)) AS expmm, 
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.AccountExpire) % 100) AS expyy, 
et.AccountNumber AS CardNumber,
et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, et.InvoiceID, @Merchant AS Merchant, @Store AS Store,
@Terminal AS Terminal, 
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount

FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND et.LastModifyDate <= @transtime
	AND et.TransType = 0
GO

CREATE PROCEDURE ACHExport @transtime DATETIME AS
DECLARE @Merchant VARCHAR(100), @Store INT, @Terminal INT, @batchinterval INT, @batchtries INT
SELECT @Merchant = Data FROM Configs WHERE ConfigID = 85
SELECT @batchinterval = Value FROM Configs WHERE ConfigID = 94
SELECT @batchtries = Value FROM Configs WHERE ConfigID = 93

EXEC ExternalTransImport 3

UPDATE ExternalTrans SET TransType = 100 
	WHERE LastModifyDate <= @transtime
	AND TransType = 103
	AND DATEADD(dd,@batchinterval,LastRebatchTry) <= @transtime
	AND RebatchTries < @batchtries

SELECT 
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.AccountExpire)) AS expmm, 
CASE WHEN DATEPART(yy,et.AccountExpire) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.AccountExpire) % 100) AS expyy, 
et.AccountNumber,
et.AuthName AS AccountHolder, et.AuthAddress AS Address, ma.City, ma.State, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, et.InvoiceID, @Merchant AS Merchant,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(dd,et.ReqDate)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mm,et.ReqDate)) AS startmm, 
CASE WHEN DATEPART(yy,et.ReqDate) % 100 < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(yy,et.ReqDate) % 100) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(hh,et.ReqDate)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(mi,et.ReqDate)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END + CONVERT(VARCHAR(2),DATEPART(ss,et.ReqDate)) AS startss,
et.Amount, et.BankTransType, et.BankNumber, et.BankName, ma.Company

FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND et.LastModifyDate <= @transtime
	AND et.TransType = 100
GO

CREATE PROCEDURE TaskCreditCard AS
DECLARE @BatchOut VARCHAR(100), @BatchIn VARCHAR(100), @ExportID INT, @BatchLimit INT, @ExportMode INT, @ImportMode INT
SELECT @BatchOut = Data FROM Configs WHERE ConfigID = 70
SELECT @BatchIn = Data FROM Configs WHERE ConfigID = 71
SELECT @ExportID = Value FROM Configs WHERE ConfigID = 74
SELECT @BatchLimit = Value FROM Configs WHERE ConfigID = 72
SELECT @ExportMode = Value FROM Configs WHERE ConfigID = 90
SELECT @ImportMode = Value FROM Configs WHERE ConfigID = 92

SELECT @BatchOut AS BatchOut, @BatchIn AS BatchIn, @ExportID AS ExportID, @BatchLimit AS BatchLimit, @ExportMode AS ExportMode, @ImportMode AS ImportMode
GO

CREATE PROCEDURE TaskCreditCardUpdate @transtime DATETIME AS
-- TransTypes
-- 0 needs to be batched out
-- 2 batched out
-- 3 declined
-- 4 good
-- 7 needs to be rebatched
-- 8 was rebatched
-- 9 trans void

UPDATE ExternalTrans SET TransType = 2
	WHERE LastModifyDate <= @transtime
	AND TransType = 0
GO

CREATE PROCEDURE TaskACH AS
DECLARE @BatchOut VARCHAR(100), @BatchIn VARCHAR(100), @ExportID INT, @BatchLimit INT, @ExportMode INT, @ImportMode INT
SELECT @BatchOut = Data FROM Configs WHERE ConfigID = 80
SELECT @BatchIn = Data FROM Configs WHERE ConfigID = 81
SELECT @ExportID = Value FROM Configs WHERE ConfigID = 84
SELECT @BatchLimit = Value FROM Configs WHERE ConfigID = 82
SELECT @ExportMode = Value FROM Configs WHERE ConfigID = 97
SELECT @ImportMode = Value FROM Configs WHERE ConfigID = 98

SELECT @BatchOut AS BatchOut, @BatchIn AS BatchIn, @ExportID AS ExportID, @BatchLimit AS BatchLimit, @ExportMode AS ExportMode, @ImportMode AS ImportMode
GO

CREATE PROCEDURE CreditCardGetTrans AS
SELECT et.ExternalTransID AS TransID, et.InvoiceID, et.Amount, et.TransType, et.CustomerID
FROM ExternalTrans et
	WHERE et.TransType IN(0,2)
GO

CREATE PROCEDURE ACHGetTrans AS
SELECT et.ExternalTransID AS TransID, et.InvoiceID, et.Amount, et.TransType, et.CustomerID
FROM ExternalTrans et
	WHERE et.TransType IN(100,102)
GO

CREATE PROCEDURE CreditCardImport @TransID INT, @TransType INT, @ApproveCode VARCHAR(12), @Response VARCHAR(50) AS
UPDATE ExternalTrans
	SET TransType = @TransType,
	ApproveCode = @ApproveCode,
	Response = @Response
WHERE ExternalTransID = @TransID
GO

CREATE PROCEDURE LDAPSetLastModifyDate (@type VARCHAR(10), @id VARCHAR(50)) AS
IF (@type = 'read')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncRead = getdate(), Calls = Calls + 1
WHERE LDAPServer = @id
IF (@@rowcount = 0)
	INSERT INTO LDAPServers (LDAPServer,LastSyncWrite,LastModifyDate,LastSyncRead,Calls) VALUES(@id,'19900101',getdate(),getdate(),1)
END

IF (@type = 'write')
BEGIN
UPDATE LDAPServers SET LastModifyDate = getdate(), LastSyncWrite = COALESCE(LastSyncRead,getdate()), Calls = Calls + 1
WHERE LDAPServer = @id
IF (@@rowcount = 0)
	INSERT INTO LDAPServers (LDAPServer,LastModifyDate,LastSyncWrite,Calls) VALUES(@id,getdate(),getdate(),1)
END

IF (@type = 'reset')
BEGIN
UPDATE LDAPServers SET LastSyncWrite = '19900101' 
WHERE LDAPServer = @id
END
GO

CREATE PROCEDURE LDAPrfc822mailbox @accountid INT AS
SELECT CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain END AS mail
FROM SubAccounts sa, Domains d
	WHERE sa.DomainID = d.DomainID
	AND sa.AccountID = @accountid
UNION
SELECT Alias as mail FROM Aliases WHERE AccountID = @accountid
GO

CREATE PROCEDURE LDAPmailAlternateAddress @accountid INT AS
SELECT Alias as mail FROM Aliases WHERE AccountID = @accountid
GO

CREATE PROCEDURE LDAPmailForwardingAddress @accountid INT AS
SELECT Forward FROM Forwards WHERE AccountID = @accountid
GO


/* Insert Meta information into DB */


CREATE PROCEDURE TabName2Description ( @tab varchar(64),  @d varchar(72) OUTPUT)  AS

set nocount on

DECLARE @i int
Select @i = 2, @d = upper(substring(@tab, 1, 1))

while (@i <= datalength(@tab) )
	BEGIN
	if ascii(substring(@tab, @i, 1)) = ascii(upper(substring(@tab, @i, 1))) and
		ascii(substring(@tab, @i-1, 1)) <> ascii(upper(substring(@tab, @i-1, 1))) 

		select @d = @d + ' ' + substring(@tab, @i, 1)
	else
		select @d = @d + substring(@tab, @i, 1)

	select @i = @i + 1
	END

if substring(@d,1,4) = 'Rad ' 
	select @d = substring(@d, 5, datalength(@d)-4)
GO

CREATE PROCEDURE SetMetaTableKey(@tabname varchar(64), @colname varchar(64), @req int) AS

Update MetaColumns Set IsKey=1, Required=@req, Nullable=0 
From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID 
	and mt.TableName = @tabname and mc.ColumnName = @colname
GO

CREATE PROCEDURE SetMetaTableGroup(@tabname varchar(64), @group int, @sortorder int, @edition int, @feature int) AS

Update MetaTables Set MetaTableGroupID = @group, SortOrder = @sortorder,
	Edition = @edition, Feature = @feature 
Where TableName = @tabname
GO

CREATE PROCEDURE SetMetaColumnRule(@tabname varchar(64), @colname varchar(64), @ruleid int) AS

Update MetaColumns Set MetaRuleID=@ruleid
From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID 
	and mt.TableName = @tabname and mc.ColumnName = @colname
GO

/* Below is a useful proc for adding a table and columns */

CREATE PROCEDURE AddMetaTable (@tabname varchar(64)) AS
Declare @t varchar(72), @cname varchar(64), @mcid int

Insert Into MetaTables(TableName,Description, GroupMetaTableID)
Select TableName=Convert(varchar,name), Description=Convert(varchar,name), NULL
From sysobjects
Where type = 'U'
	and name = @tabname

INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case convert(smallint, convert(bit, sc.status&8)) when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	Convert(varchar, so.name + '.' + sc.name) as Description, 
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, NULL as DepGroup, NULL as DepColumn, 	
	CASE WHEN st.name in ('datetime') THEN 7 ELSE NULL END as MetaRuleID, mt.MetaTableID, 
	0 as MinSize, convert(smallint, convert(bit, sc.status&8)) as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.type = st.type
	and so.name = @tabname

Update MetaColumns
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = tableid
	and fc.id = tableid
	and fc.colid = fokey1

	and rt.id = reftabid
	and rc.id = reftabid
	and rc.colid = refkey1

	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID

	and ft.name = @tabname

Update MetaColumns Set Required=0
From syscolumns sc, sysobjects so, MetaColumns mc, MetaTables mt
Where so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and so.id = sc.id
	and so.type = 'U'
	and sc.cdefault > 0
	and mt.TableName = @tabname

Update MetaColumns Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
	and mt.TableName = @tabname

EXEC TabName2Description @tabname, @t OUTPUT
Update MetaTables Set Description = @t Where TableName = @tabname

DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = @tabname

OPEN clist
FETCH clist INTO @mcid, @cname
WHILE(@@sqlstatus <> 2)
	BEGIN
	EXEC TabName2Description @cname, @t OUTPUT

	Update MetaColumns Set Description = @t Where MetaColumnID = @mcid

	FETCH clist INTO @mcid, @cname
	END

close clist
DEALLOCATE CURSOR clist

GO

CREATE PROCEDURE MetaGetTable @metatableid INT AS
SELECT MetaColumnID,ColumnName,Quoted,DepTable,DepColumn,MetaRuleID,Required,Nullable,MinSize,MaxSize,IsKey,Description,DepGroup
FROM MetaColumns
	WHERE MetaTableID = @metatableid
AT ISOLATION READ UNCOMMITTED
go


CREATE PROCEDURE MetaGetTableInfo @table VARCHAR(32) AS
SELECT mt.MetaTableID,
(SELECT TableName FROM MetaTables WHERE mt.GroupMetaTableID = MetaTableID) AS GroupTable,
(SELECT ColumnName FROM MetaColumns mc, MetaTables gmt
	WHERE mc.MetaTableID = gmt.MetaTableID
	AND mc.MetaTableID = mt.GroupMetaTableID
	AND mc.IsKey = 1) AS GroupColumn
FROM MetaTables mt
	WHERE mt.TableName = @table
AT ISOLATION READ UNCOMMITTED
go

-- Procs to add tables or objects

-- drop proc MetaAddObjectTable
CREATE PROCEDURE MetaAddObjectTable @objectgroup varchar(32), @table VARCHAR(32), @addcols int AS
DECLARE @mtid int, @ogid int

Select @mtid = ISNULL(MetaTableID,0) 
From MetaTables
Where TableName = @table

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if (@mtid > 0 and @ogid > 0)
BEGIN
	INSERT INTO Objects (ObjectGroupID, Value, ObjectTypeID)
	SELECT @ogid, @mtid, 2 
	WHERE NOT EXISTS (SELECT * FROM Objects WHERE ObjectGroupID = @ogid AND @mtid = Value AND ObjectTypeID = 2)
	
	if @addcols = 1
	BEGIN
		INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
		SELECT @ogid, mc.MetaColumnID, 3 
		FROM MetaColumns mc
			WHERE mc.MetaTableID = @mtid
			AND mc.MetaColumnID NOT IN 
				(SELECT o.Value FROM Objects o 
				WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)

	END
END
ELSE
	RAISERROR 50000, 'Could not find Table or Object'
GO

-- drop proc MetaAddObjectColumn
CREATE PROCEDURE MetaAddObjectColumn @objectgroup varchar(32), @table VARCHAR(32), @column varchar(32) AS

DECLARE @mtid int, @ogid int

Select @mtid = ISNULL(MetaTableID,0) 
From MetaTables
Where TableName = @table

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if @mtid > 0 and @ogid > 0
	BEGIN

	INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
	SELECT @ogid, mc.MetaColumnID, 3 
	FROM MetaColumns mc
		WHERE mc.MetaTableID = @mtid
		AND mc.ColumnName = @column
		AND mc.MetaColumnID NOT IN 
			(SELECT o.Value FROM Objects o 
			WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)
	END
GO

-- Add web objects to database

/* Create Procedures */
--drop proc StringsGet
CREATE PROCEDURE StringsGet @appname VARCHAR(32), @ver int AS
SELECT s.StringID, CASE s.LanguageID WHEN 1 THEN NULL ELSE s.LanguageID END as LanguageID, 
	a.AppName, s.Data, s.URL, l.BaseURL
FROM Applications a, Strings s, Languages l
WHERE a.ApplicationID = s.ApplicationID
	AND s.LanguageID = l.LanguageID
	AND a.ApplicationID=1 OR (a.AppName = @appname AND s.Version >= @ver)
go


--drop PROCEDURE WebCheckOperator 
CREATE PROCEDURE WebCheckOperator @user VARCHAR(16)
AS
SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, 0 AS CustomerID, 0 AS AccountID
FROM Operators op, OperatorGroups og
WHERE op.Operator = @user
 AND op.Active = 1
 AND op.OperatorGroupID *= og.OperatorGroupID

UNION ALL

SELECT og.OperatorGroupID, 0 as OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, -1 as LanguageID, sa.CustomerID, sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
WHERE og.OperatorGroup = 'CustomerAccess'
 AND sa.CustomerID = ma.CustomerID
 AND ma.Active = 1 AND sa.Active = 1
 AND sa.Login = @user 
 AND sa.Login IS NOT NULL
 AND sa.Password IS NOT NULL 
 AND sa.Password <> ''
 AND sa.RemoteAccess = 1

ORDER BY CustomerID ASC
GO

CREATE PROCEDURE WebCheckOperatorCookie @cookie VARCHAR(64) AS
SELECT op.OperatorGroupID, op.LanguageID, op.OperatorID, op.Operator, op.Email, og.OperatorGroup, oc.LastUsed
FROM Operators op, OperatorGroups og, OperatorCookies oc
WHERE oc.Cookie = @cookie 
 AND op.Operator = oc.Operator
 AND op.Active = 1 
 AND op.OperatorGroupID *= og.OperatorGroupID
go

CREATE PROCEDURE WebAddOperatorCookie @operator VARCHAR(16), @cookie VARCHAR(64) AS
INSERT INTO OperatorCookies(Operator, Cookie) VALUES (@operator, @cookie)
go

CREATE PROCEDURE WebUpdateOperatorCookie @operator VARCHAR(16), @cookie VARCHAR(64) AS

Update OperatorCookies Set LastUsed=GetDate() Where Operator=@operator and Cookie=@cookie
if @@ROWCOUNT = 0 
	EXEC WebAddOperatorCookie @operator, @cookie

go


CREATE PROCEDURE SecurityGetAllowedHosts AS
SELECT OperatorGroupID,IPAddress
FROM AllowedHosts
go

CREATE PROCEDURE SecurityGetGroupAccess AS
SELECT OperatorGroupID,GroupID,ObjectGroupID,AccessType
FROM OperatorGroupAccess
go

CREATE PROCEDURE SecurityGetObjectGroups AS
SELECT ObjectGroupID,ObjectTypeID,Data,Value
FROM Objects
go

CREATE PROCEDURE DeleteSubAccount @accountid INT, @mode int AS
if @accountid IS NULL RETURN

CREATE TABLE #summary ( Description VARCHAR(100) NOT NULL )

DELETE FROM Aliases WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Email Aliases')

DELETE FROM Forwards WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Email Forwards')

DELETE FROM Actions WHERE IncidentID IN (SELECT IncidentID FROM Incidents WHERE AccountID = @accountid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Incident Actions')

DELETE FROM Incidents WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Incidents')

DELETE FROM RadConfigs WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Radius Configurations')

DELETE FROM RadTriggers WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Radius Triggers')

DELETE FROM RateHistory WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Call History')

DELETE FROM SubAccountData WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Service Custom Data')

Update Charges
Set AccountID = NULL
Where AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated in InvoiceItems')

Update InvoiceItems
Set AccountID = NULL
Where AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) updated in Charges')

DELETE FROM SubAccounts WHERE AccountID = @accountid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Sub Accounts')

INSERT INTO #summary (Description) VALUES('Sub Account #' + CONVERT(VARCHAR(15),@accountid) + ' Deleted successfully')

if (@mode = 0)
	BEGIN
	SELECT * FROM #summary
	DROP TABLE #summary
	END
go

CREATE PROCEDURE DeleteMasterAccount @customerid INT AS
DECLARE @aid int
IF @customerid IS NULL RETURN

CREATE TABLE #summary (Description VARCHAR(100) NOT NULL)

IF ((SELECT COUNT(*) FROM SubAccounts WHERE CustomerID = @customerid) > 0)
	BEGIN
	
	DECLARE s_cursor CURSOR
	FOR Select AccountID From SubAccounts Where CustomerID = @customerid
	
	OPEN s_cursor
	
	FETCH s_cursor INTO @aid
	WHILE (@@sqlstatus <> 2)
		BEGIN
		Exec DeleteSubAccount @aid, 1
	
		FETCH s_cursor INTO @aid
		END
	
	CLOSE s_cursor
	DEALLOCATE CURSOR s_cursor
	
	END

Update MasterAccounts Set LastStatementID = NULL Where CustomerID = @customerid

DELETE FROM Charges WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Charges')

/* DELETE FROM GroupAccess WHERE CustomerID = @customerid */
/* INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from GroupAccess') */

DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoice Items')

DELETE FROM ExternalTrans WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid) OR CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from External Transactions')

DELETE FROM Payments WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Payments')

DELETE FROM BankTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Bank Transactions')

DELETE FROM Invoices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoices')

DELETE FROM MailLogs WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Mail Logs')

DELETE FROM StatementNotes WHERE StatementID IN (Select StatementID From Statements Where CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from StatementNotes')

DELETE FROM Statements 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Statements')

DELETE FROM LateNotices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from LateNotices')

DELETE FROM CreditCards WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from CreditCards')

DELETE FROM BankTrans 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from BankTrans')

DELETE FROM Addresses 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Addresses')

DELETE FROM MasterAccountData 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Custom Data')

DELETE FROM MasterAccounts WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Master Accounts')

INSERT INTO #summary (Description) VALUES('Master Account #' + CONVERT(VARCHAR(15),@customerid) + ' Deleted successfully')

SELECT * FROM #summary
DROP TABLE #summary
go

CREATE PROCEDURE TaskES @esid INT AS
SELECT et.ExportID, et.ExternalSystemType AS Type, LogFile, et.FileMode, et.Name, et.Login, et.Password
FROM ExternalSystems et
	WHERE et.ExternalSystemID = @esid
go

CREATE PROCEDURE TaskESUpdate @esid INT, @date DATETIME AS 
UPDATE ExternalSystems SET LastSyncDate = @date 
	WHERE ExternalSystemID = @esid
go

CREATE PROCEDURE FTSEnabled AS
SELECT 0 AS Enabled
go

CREATE PROCEDURE UserExport @esid INT, @filemode INT AS
DECLARE @incremental INT
SELECT @incremental = CASE WHEN @filemode = 1 THEN 1 WHEN @filemode = 2 THEN 0 ELSE 1 END
SELECT sa.AccountID AS ID,
CASE WHEN ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < getdate() THEN 'inactive'  WHEN COALESCE(ma.OverLimit,0) > 0 AND ma.OverLimit < (ma.Balance + ma.PendingDebit - ma.PendingCredit) THEN 'expired' WHEN DATEADD(Day,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate) < getdate() THEN 'expired' WHEN @incremental <> 0 AND sa.CreateDate > es.LastSyncDate THEN 'active-new' WHEN @incremental = 0 THEN 'active' ELSE 'active-update' END AS Status,
sa.Login, sa.Email, sa.Password, sa.FirstName, sa.LastName, es.MailHost, sa.HomeDir, sa.HomeDirLimit, 
COALESCE(DATEDIFF(dd,'Jan 1 1970',DATEADD(Day,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate)),0) AS ExpireDay
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.ExternalSystemID = @esid
	AND (@incremental = 0 OR (
		(ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)))
go

CREATE PROCEDURE Update_TimeLeft AS
UPDATE SubAccounts
SET TimeLeft = at1.TimeLeft
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND DatePart(day, GetDate()) = ma.BillDay
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.TimeLeft IS NOT NULL
go

CREATE PROCEDURE RadOnlineGetSNMP AS
SELECT s.IPAddress, st.SNMPType AS ServerType, s.Community, sp.SNMPUser, sp.AcctSessionID, sp.Username, sp.ServerID,sp.Port
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE s.ServerID = sp.ServerID
	AND s.ServerType = st.ServerType
	AND AcctStatusType=1
	AND DATALENGTH(sp.SNMPUser) > 5
	AND DATALENGTH(s.Community) > 1
	AND Username IS NOT NULL
ORDER BY sp.Port
go

CREATE PROCEDURE RadOnlineUpdateSNMP @serverid INT, @port INT, @username VARCHAR(32) AS
UPDATE ServerPorts SET AcctStatusType = 0
	WHERE AcctStatusType = 1 
	AND ServerID = @serverid
	AND Port = @port
	AND Username = @username
SELECT CASE WHEN @@rowcount = 0 THEN 'Not Updated' ELSE 'Updated' END AS Status
go

