/* instmeta.sql */

/* Populate MetaTableGroups */
INSERT INTO MetaTableGroups (Description,GroupName,MetaTableGroupID) VALUES('General',		'General',	1)
INSERT INTO MetaTableGroups (Description,GroupName,MetaTableGroupID) VALUES('Accounting',	'Accounting',	2)
INSERT INTO MetaTableGroups (Description,GroupName,MetaTableGroupID) VALUES('System',		'System',	3)
INSERT INTO MetaTableGroups (Description,GroupName,MetaTableGroupID) VALUES('RADIUS',		'RADIUS',	4)
GO

/* Populate MetaRules */
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(0,'No Rule')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(1,'Credit Card')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(2,'Password')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(3,'Unique Login')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(4,'IP Address')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(5,'Bit Field')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(6,'Email Address')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(7,'Date/Time')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(8,'DNS Address')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(9,'Password Encrypted')
INSERT INTO MetaRules (MetaRuleID,Description) VALUES(10,'Numeric')
GO


Insert Into MetaTables(TableName,Description, GroupMetaTableID)
Select TableName=Convert(varchar,name), Description=Convert(varchar,name), NULL
From sysobjects
Where type = 'U'
GO

INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case isnullable when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	sc.name as Description, 
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, 
	NULL as DepGroup, NULL as DepColumn, 
	CASE WHEN st.name in ('datetime') THEN 7 
	     WHEN st.name in ('int',  'smallint',  'bigint',  'tinyint') THEN 10 ELSE NULL END as MetaRuleID, 
	mt.MetaTableID, 0 as MinSize, isnullable as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.xtype = st.xtype
	AND so.xtype NOT IN ('V')
GO

Update mc
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = fkeyid
	and fc.id = fkeyid	
	and fc.colid = fkey1

	and rt.id = rkeyid
	and rc.id = rkeyid	
	and rc.colid = rkey1

	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
GO

Update mc
Set Required=0
From syscolumns sc, sysobjects do, sysobjects so, MetaColumns mc, MetaTables mt
Where so.id = do.parent_obj
	and so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and sc.cdefault = do.id

	and so.type = 'U' and do.type = 'D'
GO

Update mc Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
GO



/* General */

EXEC SetMetaTableGroup 'Domains', 1, 1, 0, NULL
EXEC SetMetaTableGroup 'Groups', 1, 2, 0, NULL
-- EXEC SetMetaTableGroup 'CompanyData', 1, 3, 0, NULL
EXEC SetMetaTableGroup 'Regions', 1, 4, 0, NULL
EXEC SetMetaTableGroup 'CancelReasons', 1, 5, 0, NULL
EXEC SetMetaTableGroup 'ReferredBys', 1, 6, 0, NULL
EXEC SetMetaTableGroup 'SalesPersons', 1, 7, 0, NULL
EXEC SetMetaTableGroup 'IncidentTypes', 1, 8, 0, NULL
EXEC SetMetaTableGroup 'IncidentStates', 1, 9, 0, NULL
EXEC SetMetaTableGroup 'ModemSpeeds', 1, 10, 0, NULL
EXEC SetMetaTableGroup 'NetSoftwares', 1, 11, 0, NULL
EXEC SetMetaTableGroup 'SystemTypes', 1, 12, 0, NULL
EXEC SetMetaTableGroup 'MasterAccountDataTypes', 1, 13, 0, NULL
EXEC SetMetaTableGroup 'SubAccountDataTypes', 1, 14, 0, NULL
EXEC SetMetaTableGroup 'AddressTypes', 1, 15, 0, NULL
GO

/* Accounting */
EXEC SetMetaTableGroup 'ChargeTypes', 2, 1, 0, NULL
EXEC SetMetaTableGroup 'Rates', 2, 2, 0, NULL
EXEC SetMetaTableGroup 'Taxes', 2, 3, 0, NULL
EXEC SetMetaTableGroup 'AccountTypes', 2, 4, 0, NULL
EXEC SetMetaTableGroup 'Discounts', 2, 5, 0, NULL
EXEC SetMetaTableGroup 'BillingCycles', 2, 6, 0, NULL
EXEC SetMetaTableGroup 'PayPeriods', 2, 7, 0, NULL
EXEC SetMetaTableGroup 'PaymentTypes', 2, 8, 0, NULL
EXEC SetMetaTableGroup 'PayMethods', 2, 9, 0, NULL
EXEC SetMetaTableGroup 'SendMethods', 2, 10, 0, NULL

-- EXEC SetMetaTableGroup 'LateNoticeTypes', 2, 19, 2, NULL
-- EXEC SetMetaTableGroup 'GLCodes', 2, 20, 0, NULL
GO

/* System */
EXEC SetMetaTableGroup 'Reports', 	3, 1, 0, NULL
EXEC SetMetaTableGroup 'ExternalSystems', 3, 2, 0, NULL
EXEC SetMetaTableGroup 'SysLogFilters', 3, 3, 0, NULL
EXEC SetMetaTableGroup 'FlowFilterGroups', 3, 4, 2, 10
GO

/* RADIUS */
EXEC SetMetaTableGroup 'RadVendors', 		4, 1,  0, NULL
EXEC SetMetaTableGroup 'RadIPGroups', 		4, 2,  1, NULL
EXEC SetMetaTableGroup 'RadIPAccountTypes', 	4, 3,  1, NULL
EXEC SetMetaTableGroup 'ServerTypes', 		4, 4,  0, NULL
EXEC SetMetaTableGroup 'ServerGroups', 		4, 5,  0, NULL
EXEC SetMetaTableGroup 'RadRoamServers', 	4, 6,  1, NULL
EXEC SetMetaTableGroup 'RadRoamDomains', 	4, 7,  1, NULL
EXEC SetMetaTableGroup 'RadLogMsgs', 		4, 8,  0, NULL
EXEC SetMetaTableGroup 'RadRejects', 		4, 9,  0, NULL
EXEC SetMetaTableGroup 'DNISGroups', 		4, 10, 0, NULL
GO

/* This section will populate the MetaTables with their default object groups */

-- General
EXEC MetaAddObjectTable 'General', 'Domains', 1
EXEC MetaAddObjectTable 'General', 'Groups', 1
--EXEC MetaAddObjectTable 'General', 'CompanyData', 1
EXEC MetaAddObjectTable 'General', 'Regions', 1
EXEC MetaAddObjectTable 'General', 'CancelReasons', 1
EXEC MetaAddObjectTable 'General', 'ReferredBys', 1
EXEC MetaAddObjectTable 'General', 'SalesPersons', 1
EXEC MetaAddObjectTable 'General', 'IncidentTypes', 1
EXEC MetaAddObjectTable 'General', 'IncidentStates', 1
EXEC MetaAddObjectTable 'General', 'ModemSpeeds', 1
EXEC MetaAddObjectTable 'General', 'NetSoftwares', 1
EXEC MetaAddObjectTable 'General', 'SystemTypes', 1
EXEC MetaAddObjectTable 'General', 'MasterAccountDataTypes', 1
EXEC MetaAddObjectTable 'General', 'SubAccountDataTypes', 1
GO

-- Accounting
EXEC MetaAddObjectTable 'Accounting', 'AccountTypes', 1
EXEC MetaAddObjectTable 'Accounting', 'BillingCycles', 1
EXEC MetaAddObjectTable 'Accounting', 'ChargeTypes', 1
EXEC MetaAddObjectTable 'Accounting', 'Rates', 1
EXEC MetaAddObjectTable 'Accounting', 'Discounts', 1
EXEC MetaAddObjectTable 'Accounting', 'PayPeriods', 1
EXEC MetaAddObjectTable 'Accounting', 'PaymentTypes', 1
EXEC MetaAddObjectTable 'Accounting', 'Taxes', 1
EXEC MetaAddObjectTable 'Accounting', 'PayMethods', 1
EXEC MetaAddObjectTable 'Accounting', 'SendMethods', 1
EXEC MetaAddObjectTable 'Accounting', 'GLCodes', 1
GO

-- Global
EXEC MetaAddObjectTable 'Global', 'Reports', 1
EXEC MetaAddObjectTable 'Global', 'ExternalSystems', 1
EXEC MetaAddObjectTable 'Global', 'SysLogFilters', 1
EXEC MetaAddObjectTable 'Global', 'FlowFilterGroups', 1
GO

-- RADIUS
EXEC MetaAddObjectTable 'RADIUS', 'RadVendors', 1
EXEC MetaAddObjectTable 'RADIUS', 'RadIPGroups', 1
EXEC MetaAddObjectTable 'RADIUS', 'RadIPAccountTypes', 1
EXEC MetaAddObjectTable 'RADIUS', 'ServerTypes', 1
EXEC MetaAddObjectTable 'RADIUS', 'ServerGroups', 1
EXEC MetaAddObjectTable 'RADIUS', 'Servers', 1
EXEC MetaAddObjectTable 'RADIUS', 'RadRoamServers', 1
EXEC MetaAddObjectTable 'RADIUS', 'RadRoamDomains', 1
EXEC MetaAddObjectTable 'RADIUS', 'LogMsgs', 1
EXEC MetaAddObjectTable 'RADIUS', 'RadRejects', 1
EXEC MetaAddObjectTable 'RADIUS', 'DNISGroups', 1
GO

-- Security
EXEC MetaAddObjectTable 'Security', 'Operators', 1
EXEC MetaAddObjectTable 'Security', 'OperatorGroups', 1
EXEC MetaAddObjectTable 'Security', 'OperatorGroupAccess', 1
EXEC MetaAddObjectTable 'Security', 'AllowedHosts', 1
GO

-- Web
EXEC MetaAddObjectTable 'Web', 'WebConfigs', 1
EXEC MetaAddObjectTable 'Web', 'WebLinks', 1
EXEC MetaAddObjectTable 'Web', 'PrintTypes', 1
EXEC MetaAddObjectTable 'Web', 'Licenses', 1
GO

-- Client
EXEC MetaAddObjectTable 'Client', 'AuditLogs', 1
EXEC MetaAddObjectTable 'Client', 'Languages', 1
GO

-- MBR
EXEC MetaAddObjectTable 'MBR', 'MasterAccounts', 0
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Active'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Address1'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Address2'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'BillDay'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'BillingCycleID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'CancelDate'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'CancelReasonID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'City'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Comments'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Company'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'CustomerID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'FirstName'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Gender'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'GroupID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'LastModifyDate'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'LastModifyUser'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'LastName'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'NoticeDate'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Operator'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'PayInfo'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'PhoneFax'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'PhoneHome'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'PhoneWork'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'ReferredBy'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'RegionID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'SalesPersonID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Salutation'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'SendMethodID'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'State'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Status'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Taxable'
EXEC MetaAddObjectColumn 'MBR','MasterAccounts', 'Zip'

EXEC MetaAddObjectTable 'MBR', 'CreditCards', 1
EXEC MetaAddObjectTable 'MBR', 'BankTrans', 1
GO

-- MBR Basic
EXEC MetaAddObjectTable 'MBR Basic', 'MasterAccountData', 1
EXEC MetaAddObjectTable 'MBR Basic', 'Addresses', 1
GO

-- Services
EXEC MetaAddObjectTable 'Services', 'SubAccounts', 1
EXEC MetaAddObjectTable 'Services', 'SubAccountData', 1
GO

-- Incidents
EXEC MetaAddObjectTable 'Incidents', 'Incidents', 1
EXEC MetaAddObjectTable 'Incidents', 'Actions', 1
GO

-- Invoices
EXEC MetaAddObjectTable 'Invoices', 'Invoices', 1
EXEC MetaAddObjectTable 'Invoices', 'Payments', 1
EXEC MetaAddObjectTable 'Invoices', 'Statements', 1
GO

-- Reports
EXEC MetaAddObjectTable 'Reports', 'Reports', 1
GO

-- Service Mail
EXEC MetaAddObjectTable 'Service Mail', 'Aliases', 1
EXEC MetaAddObjectTable 'Service Mail', 'Forwards', 1
GO

-- System Logs
EXEC MetaAddObjectTable 'System Logs', 'RadLogs', 0
EXEC MetaAddObjectTable 'System Logs', 'Logs', 0
EXEC MetaAddObjectTable 'System Logs', 'MailLogs', 0
EXEC MetaAddObjectTable 'System Logs', 'ScheduleLogs', 0
EXEC MetaAddObjectTable 'System Logs', 'SysLogs', 0
EXEC MetaAddObjectTable 'System Logs', 'SysLogDefs', 0
GO

-- Service RADIUS
EXEC MetaAddObjectTable 'Service RADIUS', 'RadConfigs', 1
EXEC MetaAddObjectTable 'Service RADIUS', 'RadTriggers', 1
GO

-- MBR Acct
EXEC MetaAddObjectTable 'MBR Acct', 'MasterAccounts', 0

EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'Balance'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'BillDay'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'BillingCycleID'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'LastReceived'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'LastStatementID'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'Over120Count'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'Over30Count'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'Over60Count'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'Over90Count'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'OverDue'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'OverLimit'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'PayMethodID'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'PayPeriodID'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'PendingCredit'
EXEC MetaAddObjectColumn 'MBR Acct','MasterAccounts', 'PendingDebit'

EXEC MetaAddObjectTable 'MBR Acct', 'Charges', 1
EXEC MetaAddObjectTable 'MBR Acct', 'InvoiceItems', 1
EXEC MetaAddObjectTable 'MBR Acct', 'InvoiceNotes', 1
EXEC MetaAddObjectTable 'MBR Acct', 'LateNotices', 1
EXEC MetaAddObjectTable 'MBR Acct', 'StatementNotes', 1
GO

-- Preferences
EXEC MetaAddObjectTable 'Preferences', 'Operators', 0
EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'OperatorID'
EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'Password'
EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'PrintTypeID'
EXEC MetaAddObjectColumn 'Preferences', 'Operators', 'LanguageID'
GO

-- Customer Access
EXEC MetaAddObjectTable 'Customer Access', 'MasterAccounts', 0
EXEC MetaAddObjectColumn 'Customer Access','MasterAccounts', 'PayMethodID'
EXEC MetaAddObjectColumn 'Customer Access','MasterAccounts', 'LastModifyDate'
EXEC MetaAddObjectColumn 'Customer Access','MasterAccounts', 'LastModifyUser'

EXEC MetaAddObjectTable 'Customer Access', 'SubAccounts', 0
EXEC MetaAddObjectColumn 'Customer Access','SubAccounts', 'Password'
EXEC MetaAddObjectColumn 'Customer Access','SubAccounts', 'LastModifyDate'
EXEC MetaAddObjectColumn 'Customer Access','SubAccounts', 'LastModifyUser'

EXEC MetaAddObjectTable 'Customer Access', 'Incidents', 0
EXEC MetaAddObjectTable 'Customer Access', 'CreditCards', 1
GO

Declare @t varchar(72), @mtid int, @tabname varchar(64)

DECLARE clist CURSOR FOR
SELECT MetaTableID, TableName
FROM MetaTables
OPEN clist
FETCH NEXT FROM clist INTO @mtid, @tabname
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	EXEC TabName2Description @tabname, @t OUTPUT

	Update MetaTables Set Description = @t Where MetaTableID = @mtid
	print @tabname + ' -> ' + @t

	FETCH NEXT FROM clist INTO @mtid, @tabname
	END

close clist
deallocate clist

DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns
OPEN clist
FETCH NEXT FROM clist INTO @mtid, @tabname
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	EXEC TabName2Description @tabname, @t OUTPUT

	Update MetaColumns Set Description = @t Where MetaColumnID = @mtid
	print @tabname + ' -> ' + @t

	FETCH NEXT FROM clist INTO @mtid, @tabname
	END

close clist
deallocate clist
GO

Update MetaTables Set Description = 'Service Custom Data Fields' Where TableName = 'SubAccountDataTypes'
Update MetaTables Set Description = 'MBR Custom Data Fields' Where TableName = 'MasterAccountDataTypes'
Update MetaTables Set Description = 'IP Groups' Where TableName = 'RadIPGroups'
Update MetaTables Set Description = 'IP Service Types' Where TableName = 'RadIPAccountTypes'
Update MetaTables Set Description = 'Billing Groups' Where TableName = 'Groups'
Update MetaTables Set Description = 'DNIS Groups' Where TableName = 'DNISGroups'
Update MetaTables Set Description = 'Service Types' Where TableName = 'AccountTypes'
Update MetaTables Set Description = 'Referrals' Where TableName = 'ReferredBys'
GO

/* Apply MetaRules to Columns */

/* 1-CC 2-PWD 3-Login 4-IP 5-BIT (0/1) 6-Email 7-Date/Time 8-DNS Address */
/* Note: Date/Time is handled automatically */

SetMetaColumnRule 'SubAccounts', 'Password', 2
GO
SetMetaColumnRule 'SubAccounts', 'Login', 3
GO
SetMetaColumnRule 'SubAccounts', 'Email', 6
GO

SetMetaColumnRule 'CreditCards', 'CardNumber', 1
GO

EXEC SetMetaColumnRule 'SysLogs', 'IPAddress', 8
-- EXEC SetMetaColumnRule 'AllowedHosts', 'IPAddress', 8
EXEC SetMetaColumnRule 'Servers', 'IPAddress', 8
EXEC SetMetaColumnRule 'ServerPorts', 'IPAddress', 8
EXEC SetMetaColumnRule 'ScheduleServers', 'IPAddress', 8
EXEC SetMetaColumnRule 'RadRoamServers', 'IPAddress', 8
EXEC SetMetaColumnRule 'RadIPAddresses', 'IPAddress', 4
GO

SetMetaTableKey 'AuditLogs', 'LogMsgID', 1
GO
SetMetaTableKey 'AuditLogs', 'LogDate', 1
GO
SetMetaTableKey 'AuditLogs', 'CustomerID', 1
GO
SetMetaTableKey 'AuditLogs', 'LogMsg', 1
GO
SetMetaTableKey 'AuditLogs', 'Operator', 1
GO

Update mc Set IsKey=1, Required=1 From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID and TableName = 'DNISNumbers'
GO

Update mc Set MinSize=1
From MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID 
	AND mc.Quoted = 1 
	AND mc.Required = 1
	AND mc.Nullable = 0
GO

-- Setup GroupID MetaTable references
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Statements'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Incidents' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'Incidents')  WHERE TableName = 'Actions' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Addresses' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Aliases' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'Invoices')  WHERE TableName = 'InvoiceItems' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'SubAccountData' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'RadConfigs'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Invoices'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'SubAccounts' 
GO

UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'BankTrans' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'LateNotices' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'RadTriggers'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'MasterAccountData' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'CreditCards' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Forwards'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Payments'
GO

