# parameters: $1 = chain(xxxx), $2 = network(x.x.x.x/yy), $3 = serverport(xx), $4 = routemode(ACCEPT,MASQUERADE)
echo 1 > /proc/sys/net/ipv4/ip_forward

# Load iptables and supporting modules if necessary
modprobe iptables >/dev/null 2>/dev/null
modprobe iptable_nat >/dev/null 2>/dev/null
modprobe ip_nat_ftp >/dev/null 2>/dev/null
modprobe ip_nat_irc >/dev/null 2>/dev/null
modprobe ip_conntrack_irc >/dev/null 2>/dev/null
modprobe ip_conntrack_ftp >/dev/null 2>/dev/null
modprobe ip_nat_snmp_basic >/dev/null 2>/dev/null

# configure NAT
iptables -t nat -D POSTROUTING -s $2 -d ! $2 -j $4 >/dev/null 2>/dev/null
iptables -t nat -A POSTROUTING -s $2 -d ! $2 -j $4

# cleanup existing server rules
iptables -t nat -N $1_nat >/dev/null 2>/dev/null
iptables -N $1_fwd >/dev/null 2>/dev/null
iptables -D FORWARD -s $2 -j $1_fwd >/dev/null 2>/dev/null
iptables -D FORWARD -d $2 -j $1_fwd >/dev/null 2>/dev/null
iptables -t nat -D PREROUTING -p TCP -s $2 --dport 80 -j $1_nat >/dev/null 2>/dev/null
iptables -t nat -F $1_nat >/dev/null 2>/dev/null
iptables -F $1_fwd >/dev/null 2>/dev/null

# Direct traffic to the forwarding chain
iptables -I FORWARD -s $2 -j $1_fwd
iptables -I FORWARD -d $2 -j $1_fwd

# Deny network access
iptables -I $1_fwd -p all -s $2 -d 0/0 -j REJECT

# With the following exceptions
iptables -I $1_fwd -p UDP -s $2 --dport 53 -j ACCEPT
iptables -I $1_fwd -p UDP -d $2 --sport 53 -j ACCEPT
iptables -I $1_fwd -p TCP -s $2 --dport 80 -j ACCEPT

# HTTP redirect
iptables -t nat -I PREROUTING -p TCP -s $2 --dport 80 -j $1_nat
iptables -t nat -I $1_nat -p TCP --dport 80 -j REDIRECT --to-ports $3

# Example allowing limited access before authentication to http://www.iea-software.com
# iptables -t nat -I $1_nat -p TCP -s $2 -d www.iea-software.com --dport http -j RETURN

# Example allowing limited access before authentication to https://www.iea-software.com
# iptables -I $1_fwd -p TCP -s $2 -d www.iea-software.com --dport https -j ACCEPT
# iptables -t nat -I $1_nat -p TCP -s $2 -d www.iea-software.com --dport https -j RETURN

