IF object_id('QmailFullNegSync') IS NOT NULL
	DROP PROCEDURE QmailFullNegSync
GO

IF object_id('QmailGetPartial') IS NOT NULL
	DROP PROCEDURE QmailGetPartial
GO

CREATE PROCEDURE QmailGetPartial @id VARCHAR(50) AS
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
/* 'mailbox' AS mailDeliveryOption, */
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
/* NULL AS mailQuota, */
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,

CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 'disabled' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'nopop'
	WHEN ma.OverLimit > 0 THEN 'active'
	WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'nopop'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'nopop'
	ELSE 'active'
	END
END AS accountStatus,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,

CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress,
'./' + CONVERT(VARCHAR(10),sa.AccountID) + '/' AS mailMessageStore, 
CASE WHEN fw.Forward IS NULL THEN 'normal' ELSE 'forwardonly' END AS deliveryMode

FROM MasterAccounts ma, SubAccounts sa, Domains d, AccountTypes at1, Forwards fw, Aliases al, LDAPServers ls, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND d.DomainID = sa.DomainID
	AND (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND ls.LDAPServer = @id
	AND sa.AccountID *= fw.AccountID
	AND sa.AccountID *= al.AccountID
	AND sa.Password <> ''
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
go

CREATE PROCEDURE QmailFullNegSync @id VARCHAR(50) AS
SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, Domains d, ExternalSystems es
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.DomainID = d.DomainID
	AND (sa.Login <> '' OR sa.Email <> '')
	AND sa.Password <> ''
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.Name = @id
go

/* Permissions */
GRANT EXECUTE ON QmailFullNegSync TO Emerald
GRANT EXECUTE ON QmailGetPartial TO Emerald
go
