IF object_id('NSFullNegSync') IS NOT NULL
	DROP PROCEDURE NSFullNegSync
go

IF object_id('NSGetPartial') IS NOT NULL
	DROP PROCEDURE NSGetPartial
go

CREATE PROCEDURE NSFullNegSync @id VARCHAR(50) AS
SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, ExternalSystems es
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.Active = 1
	AND ma.Active = 1
	AND (sa.Login <> '' OR sa.Email <> '')
	AND sa.Password <> ''
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.Name = @id
go

CREATE PROCEDURE NSGetPartial @id VARCHAR(50) AS
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x500uniqueIdentifier,
sa.AccountID AS accountid, sa.FirstName + ' ' + sa.LastName AS cn,
CASE WHEN sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS uid,
'mailbox' AS mailDeliveryOption,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
NULL AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS inetuserstatus,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'inactive' ELSE 'active' END AS mailuserstatus,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + d.MailDomain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS rfc822mailbox,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress

FROM MasterAccounts ma, SubAccounts sa, Domains d, AccountTypes at1, Forwards fw, Aliases al, LDAPServers ls, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.DomainID = d.DomainID
	AND (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND ls.LDAPServer = @id
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.AccountID *= fw.AccountID
	AND sa.AccountID *= al.AccountID
	AND sa.Password <> ''
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
go

GRANT EXECUTE ON NSFullNegSync TO Emerald
GRANT EXECUTE ON NSGetPartial TO Emerald
go
